/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "org/freedesktop/systemd1/Unit.h"
#include "org/freedesktop/systemd1/UnitJson.h"
#include "org/freedesktop/systemd1/UnitJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "job"

void serializeJson (const ::org::freedesktop::systemd1::Unit::job& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobId()) {
        yajl_gen_string(g, (const unsigned char*)  "jobId" , 5);
        yajl_gen_integer(g, (long long)value.getJobId());
    }
    if (!isSparse || value.hasPath()) {
        yajl_gen_string(g, (const unsigned char*)  "path" , 4);
        const char *s = value.getPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::job& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "condition"

void serializeJson (const ::org::freedesktop::systemd1::Unit::condition& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasType()) {
        yajl_gen_string(g, (const unsigned char*)  "type" , 4);
        const char *s = value.getType().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTriggerCondition()) {
        yajl_gen_string(g, (const unsigned char*)  "triggerCondition" , 16);
        yajl_gen_bool(g, (bool)value.getTriggerCondition());
    }
    if (!isSparse || value.hasReverseCondition()) {
        yajl_gen_string(g, (const unsigned char*)  "reverseCondition" , 16);
        yajl_gen_bool(g, (bool)value.getReverseCondition());
    }
    if (!isSparse || value.hasPath()) {
        yajl_gen_string(g, (const unsigned char*)  "path" , 4);
        const char *s = value.getPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_integer(g, (long long)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::condition& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "loadError"

void serializeJson (const ::org::freedesktop::systemd1::Unit::loadError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorId()) {
        yajl_gen_string(g, (const unsigned char*)  "errorId" , 7);
        const char *s = value.getErrorId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasErrorName()) {
        yajl_gen_string(g, (const unsigned char*)  "errorName" , 9);
        const char *s = value.getErrorName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::loadError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "property"

void serializeJson (const ::org::freedesktop::systemd1::Unit::property& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasValue()) {
        yajl_gen_string(g, (const unsigned char*)  "value" , 5);
        const char *s = value.getValue().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::property& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartRequest"

void serializeJson (const ::org::freedesktop::systemd1::Unit::StartRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::StartRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartResponse"

void serializeJson (const ::org::freedesktop::systemd1::Unit::StartResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::StartResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopRequest"

void serializeJson (const ::org::freedesktop::systemd1::Unit::StopRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::StopRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopResponse"

void serializeJson (const ::org::freedesktop::systemd1::Unit::StopResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::StopResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadRequest"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadResponse"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartRequest"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RestartRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RestartRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartResponse"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RestartResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RestartResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TryRestartRequest"

void serializeJson (const ::org::freedesktop::systemd1::Unit::TryRestartRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::TryRestartRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TryRestartResponse"

void serializeJson (const ::org::freedesktop::systemd1::Unit::TryRestartResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::TryRestartResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadOrRestartRequest"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadOrRestartRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadOrRestartRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadOrRestartResponse"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadOrRestartResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadOrRestartResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadOrTryRestartRequest"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadOrTryRestartRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadOrTryRestartRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadOrTryRestartResponse"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadOrTryRestartResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadOrTryRestartResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KillRequest"

void serializeJson (const ::org::freedesktop::systemd1::Unit::KillRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::KillRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KillResponse"

void serializeJson (const ::org::freedesktop::systemd1::Unit::KillResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::KillResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetPropertiesRequest"

void serializeJson (const ::org::freedesktop::systemd1::Unit::SetPropertiesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRuntime()) {
        yajl_gen_string(g, (const unsigned char*)  "runtime" , 7);
        yajl_gen_bool(g, (bool)value.getRuntime());
    }
    if (!isSparse || value.hasProperties()) {
        yajl_gen_string(g, (const unsigned char*)  "properties" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Unit::property >& o1 = value.getProperties();
        {
            ::std::vector< ::org::freedesktop::systemd1::Unit::property >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::SetPropertiesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IdUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::IdUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "Id" , 2);
        const char *s = value.getId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::IdUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IdRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::IdRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::IdRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NamesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::NamesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNames()) {
        yajl_gen_string(g, (const unsigned char*)  "Names" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o3 = value.getNames();
        {
            ::std::vector< ::std::string >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                const char *s = (*o2).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::NamesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NamesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::NamesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::NamesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FollowingUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::FollowingUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFollowing()) {
        yajl_gen_string(g, (const unsigned char*)  "Following" , 9);
        const char *s = value.getFollowing().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::FollowingUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FollowingRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::FollowingRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::FollowingRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequiresUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiresUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequires()) {
        yajl_gen_string(g, (const unsigned char*)  "Requires" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o5 = value.getRequires();
        {
            ::std::vector< ::std::string >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                const char *s = (*o4).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiresUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequiresRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiresRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiresRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequiresOverridableUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiresOverridableUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequiresOverridable()) {
        yajl_gen_string(g, (const unsigned char*)  "RequiresOverridable" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o7 = value.getRequiresOverridable();
        {
            ::std::vector< ::std::string >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                const char *s = (*o6).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiresOverridableUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequiresOverridableRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiresOverridableRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiresOverridableRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequisiteUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequisite()) {
        yajl_gen_string(g, (const unsigned char*)  "Requisite" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o9 = value.getRequisite();
        {
            ::std::vector< ::std::string >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                const char *s = (*o8).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequisiteRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequisiteOverridableUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteOverridableUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequisiteOverridable()) {
        yajl_gen_string(g, (const unsigned char*)  "RequisiteOverridable" , 20);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o11 = value.getRequisiteOverridable();
        {
            ::std::vector< ::std::string >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                const char *s = (*o10).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteOverridableUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequisiteOverridableRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteOverridableRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteOverridableRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WantsUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::WantsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWants()) {
        yajl_gen_string(g, (const unsigned char*)  "Wants" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o13 = value.getWants();
        {
            ::std::vector< ::std::string >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                const char *s = (*o12).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::WantsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WantsRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::WantsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::WantsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BindsToUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::BindsToUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBindsTo()) {
        yajl_gen_string(g, (const unsigned char*)  "BindsTo" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o15 = value.getBindsTo();
        {
            ::std::vector< ::std::string >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                const char *s = (*o14).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::BindsToUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BindsToRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::BindsToRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::BindsToRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PartOfUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::PartOfUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPartOf()) {
        yajl_gen_string(g, (const unsigned char*)  "PartOf" , 6);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o17 = value.getPartOf();
        {
            ::std::vector< ::std::string >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                const char *s = (*o16).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::PartOfUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PartOfRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::PartOfRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::PartOfRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequiredByUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiredByUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequiredBy()) {
        yajl_gen_string(g, (const unsigned char*)  "RequiredBy" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o19 = value.getRequiredBy();
        {
            ::std::vector< ::std::string >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                const char *s = (*o18).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiredByUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequiredByRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiredByRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiredByRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequiredByOverridableUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiredByOverridableUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequiredByOverridable()) {
        yajl_gen_string(g, (const unsigned char*)  "RequiredByOverridable" , 21);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o21 = value.getRequiredByOverridable();
        {
            ::std::vector< ::std::string >::const_iterator o20;
            for (o20 = o21.begin(); o20 != o21.end(); ++o20) {
                const char *s = (*o20).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiredByOverridableUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequiredByOverridableRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiredByOverridableRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiredByOverridableRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequisiteOfUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteOfUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequisiteOf()) {
        yajl_gen_string(g, (const unsigned char*)  "RequisiteOf" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o23 = value.getRequisiteOf();
        {
            ::std::vector< ::std::string >::const_iterator o22;
            for (o22 = o23.begin(); o22 != o23.end(); ++o22) {
                const char *s = (*o22).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteOfUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequisiteOfRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteOfRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteOfRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequisiteOfOverridableUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteOfOverridableUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequisiteOfOverridable()) {
        yajl_gen_string(g, (const unsigned char*)  "RequisiteOfOverridable" , 22);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o25 = value.getRequisiteOfOverridable();
        {
            ::std::vector< ::std::string >::const_iterator o24;
            for (o24 = o25.begin(); o24 != o25.end(); ++o24) {
                const char *s = (*o24).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteOfOverridableUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequisiteOfOverridableRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteOfOverridableRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequisiteOfOverridableRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WantedByUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::WantedByUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWantedBy()) {
        yajl_gen_string(g, (const unsigned char*)  "WantedBy" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o27 = value.getWantedBy();
        {
            ::std::vector< ::std::string >::const_iterator o26;
            for (o26 = o27.begin(); o26 != o27.end(); ++o26) {
                const char *s = (*o26).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::WantedByUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WantedByRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::WantedByRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::WantedByRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BoundByUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::BoundByUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBoundBy()) {
        yajl_gen_string(g, (const unsigned char*)  "BoundBy" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o29 = value.getBoundBy();
        {
            ::std::vector< ::std::string >::const_iterator o28;
            for (o28 = o29.begin(); o28 != o29.end(); ++o28) {
                const char *s = (*o28).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::BoundByUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BoundByRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::BoundByRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::BoundByRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConsistsOfUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConsistsOfUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConsistsOf()) {
        yajl_gen_string(g, (const unsigned char*)  "ConsistsOf" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o31 = value.getConsistsOf();
        {
            ::std::vector< ::std::string >::const_iterator o30;
            for (o30 = o31.begin(); o30 != o31.end(); ++o30) {
                const char *s = (*o30).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConsistsOfUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConsistsOfRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConsistsOfRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConsistsOfRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConflictsUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConflictsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConflicts()) {
        yajl_gen_string(g, (const unsigned char*)  "Conflicts" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o33 = value.getConflicts();
        {
            ::std::vector< ::std::string >::const_iterator o32;
            for (o32 = o33.begin(); o32 != o33.end(); ++o32) {
                const char *s = (*o32).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConflictsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConflictsRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConflictsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConflictsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConflictedByUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConflictedByUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConflictedBy()) {
        yajl_gen_string(g, (const unsigned char*)  "ConflictedBy" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o35 = value.getConflictedBy();
        {
            ::std::vector< ::std::string >::const_iterator o34;
            for (o34 = o35.begin(); o34 != o35.end(); ++o34) {
                const char *s = (*o34).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConflictedByUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConflictedByRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConflictedByRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConflictedByRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BeforeUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::BeforeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBefore()) {
        yajl_gen_string(g, (const unsigned char*)  "Before" , 6);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o37 = value.getBefore();
        {
            ::std::vector< ::std::string >::const_iterator o36;
            for (o36 = o37.begin(); o36 != o37.end(); ++o36) {
                const char *s = (*o36).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::BeforeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BeforeRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::BeforeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::BeforeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AfterUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::AfterUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAfter()) {
        yajl_gen_string(g, (const unsigned char*)  "After" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o39 = value.getAfter();
        {
            ::std::vector< ::std::string >::const_iterator o38;
            for (o38 = o39.begin(); o38 != o39.end(); ++o38) {
                const char *s = (*o38).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::AfterUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AfterRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::AfterRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::AfterRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnFailureUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::OnFailureUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOnFailure()) {
        yajl_gen_string(g, (const unsigned char*)  "OnFailure" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o41 = value.getOnFailure();
        {
            ::std::vector< ::std::string >::const_iterator o40;
            for (o40 = o41.begin(); o40 != o41.end(); ++o40) {
                const char *s = (*o40).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::OnFailureUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnFailureRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::OnFailureRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::OnFailureRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TriggersUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::TriggersUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTriggers()) {
        yajl_gen_string(g, (const unsigned char*)  "Triggers" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o43 = value.getTriggers();
        {
            ::std::vector< ::std::string >::const_iterator o42;
            for (o42 = o43.begin(); o42 != o43.end(); ++o42) {
                const char *s = (*o42).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::TriggersUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TriggersRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::TriggersRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::TriggersRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TriggeredByUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::TriggeredByUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTriggeredBy()) {
        yajl_gen_string(g, (const unsigned char*)  "TriggeredBy" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o45 = value.getTriggeredBy();
        {
            ::std::vector< ::std::string >::const_iterator o44;
            for (o44 = o45.begin(); o44 != o45.end(); ++o44) {
                const char *s = (*o44).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::TriggeredByUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TriggeredByRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::TriggeredByRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::TriggeredByRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PropagatesReloadToUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::PropagatesReloadToUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPropagatesReloadTo()) {
        yajl_gen_string(g, (const unsigned char*)  "PropagatesReloadTo" , 18);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o47 = value.getPropagatesReloadTo();
        {
            ::std::vector< ::std::string >::const_iterator o46;
            for (o46 = o47.begin(); o46 != o47.end(); ++o46) {
                const char *s = (*o46).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::PropagatesReloadToUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PropagatesReloadToRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::PropagatesReloadToRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::PropagatesReloadToRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadPropagatedFromUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadPropagatedFromUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasReloadPropagatedFrom()) {
        yajl_gen_string(g, (const unsigned char*)  "ReloadPropagatedFrom" , 20);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o49 = value.getReloadPropagatedFrom();
        {
            ::std::vector< ::std::string >::const_iterator o48;
            for (o48 = o49.begin(); o48 != o49.end(); ++o48) {
                const char *s = (*o48).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadPropagatedFromUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadPropagatedFromRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadPropagatedFromRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ReloadPropagatedFromRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JoinsNamespaceOfUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::JoinsNamespaceOfUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJoinsNamespaceOf()) {
        yajl_gen_string(g, (const unsigned char*)  "JoinsNamespaceOf" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o51 = value.getJoinsNamespaceOf();
        {
            ::std::vector< ::std::string >::const_iterator o50;
            for (o50 = o51.begin(); o50 != o51.end(); ++o50) {
                const char *s = (*o50).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::JoinsNamespaceOfUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JoinsNamespaceOfRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::JoinsNamespaceOfRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::JoinsNamespaceOfRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequiresMountsForUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiresMountsForUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequiresMountsFor()) {
        yajl_gen_string(g, (const unsigned char*)  "RequiresMountsFor" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o53 = value.getRequiresMountsFor();
        {
            ::std::vector< ::std::string >::const_iterator o52;
            for (o52 = o53.begin(); o52 != o53.end(); ++o52) {
                const char *s = (*o52).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiresMountsForUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequiresMountsForRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiresMountsForRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RequiresMountsForRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DocumentationUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::DocumentationUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDocumentation()) {
        yajl_gen_string(g, (const unsigned char*)  "Documentation" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o55 = value.getDocumentation();
        {
            ::std::vector< ::std::string >::const_iterator o54;
            for (o54 = o55.begin(); o54 != o55.end(); ++o54) {
                const char *s = (*o54).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::DocumentationUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DocumentationRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::DocumentationRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::DocumentationRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DescriptionUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::DescriptionUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDescription()) {
        yajl_gen_string(g, (const unsigned char*)  "Description" , 11);
        const char *s = value.getDescription().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::DescriptionUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DescriptionRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::DescriptionRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::DescriptionRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LoadStateUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::LoadStateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLoadState()) {
        yajl_gen_string(g, (const unsigned char*)  "LoadState" , 9);
        const char *s = value.getLoadState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::LoadStateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LoadStateRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::LoadStateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::LoadStateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveStateUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveStateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActiveState()) {
        yajl_gen_string(g, (const unsigned char*)  "ActiveState" , 11);
        const char *s = value.getActiveState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveStateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveStateRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveStateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveStateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SubStateUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::SubStateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSubState()) {
        yajl_gen_string(g, (const unsigned char*)  "SubState" , 8);
        const char *s = value.getSubState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::SubStateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SubStateRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::SubStateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::SubStateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FragmentPathUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::FragmentPathUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFragmentPath()) {
        yajl_gen_string(g, (const unsigned char*)  "FragmentPath" , 12);
        const char *s = value.getFragmentPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::FragmentPathUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FragmentPathRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::FragmentPathRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::FragmentPathRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SourcePathUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::SourcePathUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSourcePath()) {
        yajl_gen_string(g, (const unsigned char*)  "SourcePath" , 10);
        const char *s = value.getSourcePath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::SourcePathUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SourcePathRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::SourcePathRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::SourcePathRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DropInPathsUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::DropInPathsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDropInPaths()) {
        yajl_gen_string(g, (const unsigned char*)  "DropInPaths" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o57 = value.getDropInPaths();
        {
            ::std::vector< ::std::string >::const_iterator o56;
            for (o56 = o57.begin(); o56 != o57.end(); ++o56) {
                const char *s = (*o56).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::DropInPathsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DropInPathsRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::DropInPathsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::DropInPathsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitFileStateUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::UnitFileStateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnitFileState()) {
        yajl_gen_string(g, (const unsigned char*)  "UnitFileState" , 13);
        const char *s = value.getUnitFileState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::UnitFileStateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitFileStateRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::UnitFileStateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::UnitFileStateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitFilePresetUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::UnitFilePresetUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnitFilePreset()) {
        yajl_gen_string(g, (const unsigned char*)  "UnitFilePreset" , 14);
        const char *s = value.getUnitFilePreset().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::UnitFilePresetUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitFilePresetRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::UnitFilePresetRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::UnitFilePresetRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InactiveExitTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInactiveExitTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "InactiveExitTimestamp" , 21);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getInactiveExitTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InactiveExitTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InactiveExitTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInactiveExitTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "InactiveExitTimestampMonotonic" , 30);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getInactiveExitTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InactiveExitTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveEnterTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActiveEnterTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "ActiveEnterTimestamp" , 20);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getActiveEnterTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveEnterTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveEnterTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActiveEnterTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "ActiveEnterTimestampMonotonic" , 29);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getActiveEnterTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveEnterTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveExitTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActiveExitTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "ActiveExitTimestamp" , 19);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getActiveExitTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveExitTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveExitTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActiveExitTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "ActiveExitTimestampMonotonic" , 28);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getActiveExitTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveExitTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InactiveEnterTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInactiveEnterTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "InactiveEnterTimestamp" , 22);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getInactiveEnterTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InactiveEnterTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InactiveEnterTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInactiveEnterTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "InactiveEnterTimestampMonotonic" , 31);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getInactiveEnterTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InactiveEnterTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CanStartUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanStartUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCanStart()) {
        yajl_gen_string(g, (const unsigned char*)  "CanStart" , 8);
        yajl_gen_bool(g, (bool)value.getCanStart());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanStartUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CanStartRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanStartRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanStartRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CanStopUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanStopUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCanStop()) {
        yajl_gen_string(g, (const unsigned char*)  "CanStop" , 7);
        yajl_gen_bool(g, (bool)value.getCanStop());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanStopUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CanStopRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanStopRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanStopRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CanReloadUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanReloadUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCanReload()) {
        yajl_gen_string(g, (const unsigned char*)  "CanReload" , 9);
        yajl_gen_bool(g, (bool)value.getCanReload());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanReloadUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CanReloadRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanReloadRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanReloadRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CanIsolateUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanIsolateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCanIsolate()) {
        yajl_gen_string(g, (const unsigned char*)  "CanIsolate" , 10);
        yajl_gen_bool(g, (bool)value.getCanIsolate());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanIsolateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CanIsolateRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanIsolateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::CanIsolateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JobUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "Job" , 3);
        serializeJson(value.getJob(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JobRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopWhenUnneededUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::StopWhenUnneededUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStopWhenUnneeded()) {
        yajl_gen_string(g, (const unsigned char*)  "StopWhenUnneeded" , 16);
        yajl_gen_bool(g, (bool)value.getStopWhenUnneeded());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::StopWhenUnneededUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopWhenUnneededRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::StopWhenUnneededRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::StopWhenUnneededRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RefuseManualStartUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RefuseManualStartUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRefuseManualStart()) {
        yajl_gen_string(g, (const unsigned char*)  "RefuseManualStart" , 17);
        yajl_gen_bool(g, (bool)value.getRefuseManualStart());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RefuseManualStartUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RefuseManualStartRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RefuseManualStartRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RefuseManualStartRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RefuseManualStopUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RefuseManualStopUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRefuseManualStop()) {
        yajl_gen_string(g, (const unsigned char*)  "RefuseManualStop" , 16);
        yajl_gen_bool(g, (bool)value.getRefuseManualStop());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RefuseManualStopUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RefuseManualStopRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::RefuseManualStopRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::RefuseManualStopRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AllowIsolateUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::AllowIsolateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAllowIsolate()) {
        yajl_gen_string(g, (const unsigned char*)  "AllowIsolate" , 12);
        yajl_gen_bool(g, (bool)value.getAllowIsolate());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::AllowIsolateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AllowIsolateRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::AllowIsolateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::AllowIsolateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DefaultDependenciesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::DefaultDependenciesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefaultDependencies()) {
        yajl_gen_string(g, (const unsigned char*)  "DefaultDependencies" , 19);
        yajl_gen_bool(g, (bool)value.getDefaultDependencies());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::DefaultDependenciesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DefaultDependenciesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::DefaultDependenciesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::DefaultDependenciesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnFailureJobModeUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::OnFailureJobModeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOnFailureJobMode()) {
        yajl_gen_string(g, (const unsigned char*)  "OnFailureJobMode" , 16);
        const char *s = value.getOnFailureJobMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::OnFailureJobModeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnFailureJobModeRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::OnFailureJobModeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::OnFailureJobModeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IgnoreOnIsolateUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::IgnoreOnIsolateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIgnoreOnIsolate()) {
        yajl_gen_string(g, (const unsigned char*)  "IgnoreOnIsolate" , 15);
        yajl_gen_bool(g, (bool)value.getIgnoreOnIsolate());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::IgnoreOnIsolateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IgnoreOnIsolateRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::IgnoreOnIsolateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::IgnoreOnIsolateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IgnoreOnSnapshotUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::IgnoreOnSnapshotUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIgnoreOnSnapshot()) {
        yajl_gen_string(g, (const unsigned char*)  "IgnoreOnSnapshot" , 16);
        yajl_gen_bool(g, (bool)value.getIgnoreOnSnapshot());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::IgnoreOnSnapshotUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IgnoreOnSnapshotRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::IgnoreOnSnapshotRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::IgnoreOnSnapshotRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NeedDaemonReloadUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::NeedDaemonReloadUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNeedDaemonReload()) {
        yajl_gen_string(g, (const unsigned char*)  "NeedDaemonReload" , 16);
        yajl_gen_bool(g, (bool)value.getNeedDaemonReload());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::NeedDaemonReloadUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NeedDaemonReloadRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::NeedDaemonReloadRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::NeedDaemonReloadRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JobTimeoutUSecUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobTimeoutUSecUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobTimeoutUSec()) {
        yajl_gen_string(g, (const unsigned char*)  "JobTimeoutUSec" , 14);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getJobTimeoutUSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobTimeoutUSecUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JobTimeoutUSecRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobTimeoutUSecRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobTimeoutUSecRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JobTimeoutActionUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobTimeoutActionUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobTimeoutAction()) {
        yajl_gen_string(g, (const unsigned char*)  "JobTimeoutAction" , 16);
        const char *s = value.getJobTimeoutAction().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobTimeoutActionUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JobTimeoutActionRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobTimeoutActionRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobTimeoutActionRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JobTimeoutRebootArgumentUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobTimeoutRebootArgumentUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobTimeoutRebootArgument()) {
        yajl_gen_string(g, (const unsigned char*)  "JobTimeoutRebootArgument" , 24);
        const char *s = value.getJobTimeoutRebootArgument().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobTimeoutRebootArgumentUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JobTimeoutRebootArgumentRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobTimeoutRebootArgumentRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::JobTimeoutRebootArgumentRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConditionResultUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionResultUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConditionResult()) {
        yajl_gen_string(g, (const unsigned char*)  "ConditionResult" , 15);
        yajl_gen_bool(g, (bool)value.getConditionResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionResultUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConditionResultRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionResultRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionResultRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AssertResultUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertResultUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAssertResult()) {
        yajl_gen_string(g, (const unsigned char*)  "AssertResult" , 12);
        yajl_gen_bool(g, (bool)value.getAssertResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertResultUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AssertResultRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertResultRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertResultRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConditionTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConditionTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "ConditionTimestamp" , 18);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getConditionTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConditionTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConditionTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConditionTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "ConditionTimestampMonotonic" , 27);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getConditionTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConditionTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AssertTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAssertTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "AssertTimestamp" , 15);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getAssertTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AssertTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AssertTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAssertTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "AssertTimestampMonotonic" , 24);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getAssertTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AssertTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConditionsUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConditions()) {
        yajl_gen_string(g, (const unsigned char*)  "Conditions" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Unit::condition >& o59 = value.getConditions();
        {
            ::std::vector< ::org::freedesktop::systemd1::Unit::condition >::const_iterator o58;
            for (o58 = o59.begin(); o58 != o59.end(); ++o58) {
                serializeJson((*o58), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConditionsRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::ConditionsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AssertsUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAsserts()) {
        yajl_gen_string(g, (const unsigned char*)  "Asserts" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Unit::condition >& o61 = value.getAsserts();
        {
            ::std::vector< ::org::freedesktop::systemd1::Unit::condition >::const_iterator o60;
            for (o60 = o61.begin(); o60 != o61.end(); ++o60) {
                serializeJson((*o60), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AssertsRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::AssertsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LoadErrorUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::LoadErrorUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLoadError()) {
        yajl_gen_string(g, (const unsigned char*)  "LoadError" , 9);
        serializeJson(value.getLoadError(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::LoadErrorUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LoadErrorRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::LoadErrorRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::LoadErrorRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TransientUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Unit::TransientUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTransient()) {
        yajl_gen_string(g, (const unsigned char*)  "Transient" , 9);
        yajl_gen_bool(g, (bool)value.getTransient());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::TransientUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TransientRegister"

void serializeJson (const ::org::freedesktop::systemd1::Unit::TransientRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Unit::TransientRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::job& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::condition& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::loadError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::property& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::StartRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::StartResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::StopRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::StopResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ReloadRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ReloadResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RestartRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RestartResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::TryRestartRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::TryRestartResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ReloadOrRestartRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ReloadOrRestartResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ReloadOrTryRestartRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ReloadOrTryRestartResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::KillRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::KillResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::SetPropertiesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::IdUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::IdRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::NamesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::NamesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::FollowingUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::FollowingRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequiresUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequiresRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequiresOverridableUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequiresOverridableRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequisiteUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequisiteRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequisiteOverridableUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequisiteOverridableRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::WantsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::WantsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::BindsToUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::BindsToRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::PartOfUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::PartOfRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequiredByUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequiredByRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequiredByOverridableUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequiredByOverridableRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequisiteOfUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequisiteOfRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequisiteOfOverridableUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequisiteOfOverridableRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::WantedByUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::WantedByRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::BoundByUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::BoundByRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConsistsOfUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConsistsOfRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConflictsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConflictsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConflictedByUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConflictedByRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::BeforeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::BeforeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::AfterUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::AfterRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::OnFailureUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::OnFailureRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::TriggersUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::TriggersRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::TriggeredByUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::TriggeredByRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::PropagatesReloadToUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::PropagatesReloadToRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ReloadPropagatedFromUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ReloadPropagatedFromRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::JoinsNamespaceOfUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::JoinsNamespaceOfRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequiresMountsForUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RequiresMountsForRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::DocumentationUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::DocumentationRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::DescriptionUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::DescriptionRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::LoadStateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::LoadStateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ActiveStateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ActiveStateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::SubStateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::SubStateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::FragmentPathUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::FragmentPathRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::SourcePathUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::SourcePathRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::DropInPathsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::DropInPathsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::UnitFileStateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::UnitFileStateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::UnitFilePresetUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::UnitFilePresetRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::CanStartUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::CanStartRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::CanStopUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::CanStopRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::CanReloadUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::CanReloadRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::CanIsolateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::CanIsolateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::JobUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::JobRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::StopWhenUnneededUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::StopWhenUnneededRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RefuseManualStartUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RefuseManualStartRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RefuseManualStopUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::RefuseManualStopRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::AllowIsolateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::AllowIsolateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::DefaultDependenciesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::DefaultDependenciesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::OnFailureJobModeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::OnFailureJobModeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::IgnoreOnIsolateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::IgnoreOnIsolateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::IgnoreOnSnapshotUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::IgnoreOnSnapshotRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::NeedDaemonReloadUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::NeedDaemonReloadRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::JobTimeoutUSecUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::JobTimeoutUSecRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::JobTimeoutActionUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::JobTimeoutActionRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::JobTimeoutRebootArgumentUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::JobTimeoutRebootArgumentRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConditionResultUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConditionResultRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::AssertResultUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::AssertResultRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConditionTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConditionTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConditionTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConditionTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::AssertTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::AssertTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::AssertTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::AssertTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConditionsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::ConditionsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::AssertsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::AssertsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::LoadErrorUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::LoadErrorRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::TransientUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Unit::TransientRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org

