#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_FREEDESKTOP_SYSTEMD1_UNIT_H
#define ORG_FREEDESKTOP_SYSTEMD1_UNIT_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * org.freedesktop.systemd1.Unit:
 *     short_description: All Unit objects implement the generic org.freedesktop.systemd1.Unit interface.
 *     Depending on the unit type they also implement one unit-type-specific interface.
 */

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

// method IDs
static const uint16 ID_Start = 0;
static const uint16 ID_Stop = 1;
static const uint16 ID_Reload = 2;
static const uint16 ID_Restart = 3;
static const uint16 ID_TryRestart = 4;
static const uint16 ID_ReloadOrRestart = 5;
static const uint16 ID_ReloadOrTryRestart = 6;
static const uint16 ID_Kill = 7;
static const uint16 ID_ResetFailed = 8;
static const uint16 ID_SetProperties = 9;

// signal IDs

// property IDs
static const uint16 ID_Id = 10;
static const uint16 ID_Names = 11;
static const uint16 ID_Following = 12;
static const uint16 ID_Requires = 13;
static const uint16 ID_RequiresOverridable = 14;
static const uint16 ID_Requisite = 15;
static const uint16 ID_RequisiteOverridable = 16;
static const uint16 ID_Wants = 17;
static const uint16 ID_BindsTo = 18;
static const uint16 ID_PartOf = 19;
static const uint16 ID_RequiredBy = 20;
static const uint16 ID_RequiredByOverridable = 21;
static const uint16 ID_RequisiteOf = 22;
static const uint16 ID_RequisiteOfOverridable = 23;
static const uint16 ID_WantedBy = 24;
static const uint16 ID_BoundBy = 25;
static const uint16 ID_ConsistsOf = 26;
static const uint16 ID_Conflicts = 27;
static const uint16 ID_ConflictedBy = 28;
static const uint16 ID_Before = 29;
static const uint16 ID_After = 30;
static const uint16 ID_OnFailure = 31;
static const uint16 ID_Triggers = 32;
static const uint16 ID_TriggeredBy = 33;
static const uint16 ID_PropagatesReloadTo = 34;
static const uint16 ID_ReloadPropagatedFrom = 35;
static const uint16 ID_JoinsNamespaceOf = 36;
static const uint16 ID_RequiresMountsFor = 37;
static const uint16 ID_Documentation = 38;
static const uint16 ID_Description = 39;
static const uint16 ID_LoadState = 40;
static const uint16 ID_ActiveState = 41;
static const uint16 ID_SubState = 42;
static const uint16 ID_FragmentPath = 43;
static const uint16 ID_SourcePath = 44;
static const uint16 ID_DropInPaths = 45;
static const uint16 ID_UnitFileState = 46;
static const uint16 ID_UnitFilePreset = 47;
static const uint16 ID_InactiveExitTimestamp = 48;
static const uint16 ID_InactiveExitTimestampMonotonic = 49;
static const uint16 ID_ActiveEnterTimestamp = 50;
static const uint16 ID_ActiveEnterTimestampMonotonic = 51;
static const uint16 ID_ActiveExitTimestamp = 52;
static const uint16 ID_ActiveExitTimestampMonotonic = 53;
static const uint16 ID_InactiveEnterTimestamp = 54;
static const uint16 ID_InactiveEnterTimestampMonotonic = 55;
static const uint16 ID_CanStart = 56;
static const uint16 ID_CanStop = 57;
static const uint16 ID_CanReload = 58;
static const uint16 ID_CanIsolate = 59;
static const uint16 ID_Job = 60;
static const uint16 ID_StopWhenUnneeded = 61;
static const uint16 ID_RefuseManualStart = 62;
static const uint16 ID_RefuseManualStop = 63;
static const uint16 ID_AllowIsolate = 64;
static const uint16 ID_DefaultDependencies = 65;
static const uint16 ID_OnFailureJobMode = 66;
static const uint16 ID_IgnoreOnIsolate = 67;
static const uint16 ID_IgnoreOnSnapshot = 68;
static const uint16 ID_NeedDaemonReload = 69;
static const uint16 ID_JobTimeoutUSec = 70;
static const uint16 ID_JobTimeoutAction = 71;
static const uint16 ID_JobTimeoutRebootArgument = 72;
static const uint16 ID_ConditionResult = 73;
static const uint16 ID_AssertResult = 74;
static const uint16 ID_ConditionTimestamp = 75;
static const uint16 ID_ConditionTimestampMonotonic = 76;
static const uint16 ID_AssertTimestamp = 77;
static const uint16 ID_AssertTimestampMonotonic = 78;
static const uint16 ID_Conditions = 79;
static const uint16 ID_Asserts = 80;
static const uint16 ID_LoadError = 81;
static const uint16 ID_Transient = 82;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class job;

class condition;

class loadError;

class property;

class StartRequest;

class StartResponse;

class StopRequest;

class StopResponse;

class ReloadRequest;

class ReloadResponse;

class RestartRequest;

class RestartResponse;

class TryRestartRequest;

class TryRestartResponse;

class ReloadOrRestartRequest;

class ReloadOrRestartResponse;

class ReloadOrTryRestartRequest;

class ReloadOrTryRestartResponse;

class KillRequest;

class KillResponse;

class SetPropertiesRequest;

class IdUpdate;

class IdRegister;

class NamesUpdate;

class NamesRegister;

class FollowingUpdate;

class FollowingRegister;

class RequiresUpdate;

class RequiresRegister;

class RequiresOverridableUpdate;

class RequiresOverridableRegister;

class RequisiteUpdate;

class RequisiteRegister;

class RequisiteOverridableUpdate;

class RequisiteOverridableRegister;

class WantsUpdate;

class WantsRegister;

class BindsToUpdate;

class BindsToRegister;

class PartOfUpdate;

class PartOfRegister;

class RequiredByUpdate;

class RequiredByRegister;

class RequiredByOverridableUpdate;

class RequiredByOverridableRegister;

class RequisiteOfUpdate;

class RequisiteOfRegister;

class RequisiteOfOverridableUpdate;

class RequisiteOfOverridableRegister;

class WantedByUpdate;

class WantedByRegister;

class BoundByUpdate;

class BoundByRegister;

class ConsistsOfUpdate;

class ConsistsOfRegister;

class ConflictsUpdate;

class ConflictsRegister;

class ConflictedByUpdate;

class ConflictedByRegister;

class BeforeUpdate;

class BeforeRegister;

class AfterUpdate;

class AfterRegister;

class OnFailureUpdate;

class OnFailureRegister;

class TriggersUpdate;

class TriggersRegister;

class TriggeredByUpdate;

class TriggeredByRegister;

class PropagatesReloadToUpdate;

class PropagatesReloadToRegister;

class ReloadPropagatedFromUpdate;

class ReloadPropagatedFromRegister;

class JoinsNamespaceOfUpdate;

class JoinsNamespaceOfRegister;

class RequiresMountsForUpdate;

class RequiresMountsForRegister;

class DocumentationUpdate;

class DocumentationRegister;

class DescriptionUpdate;

class DescriptionRegister;

class LoadStateUpdate;

class LoadStateRegister;

class ActiveStateUpdate;

class ActiveStateRegister;

class SubStateUpdate;

class SubStateRegister;

class FragmentPathUpdate;

class FragmentPathRegister;

class SourcePathUpdate;

class SourcePathRegister;

class DropInPathsUpdate;

class DropInPathsRegister;

class UnitFileStateUpdate;

class UnitFileStateRegister;

class UnitFilePresetUpdate;

class UnitFilePresetRegister;

class InactiveExitTimestampUpdate;

class InactiveExitTimestampRegister;

class InactiveExitTimestampMonotonicUpdate;

class InactiveExitTimestampMonotonicRegister;

class ActiveEnterTimestampUpdate;

class ActiveEnterTimestampRegister;

class ActiveEnterTimestampMonotonicUpdate;

class ActiveEnterTimestampMonotonicRegister;

class ActiveExitTimestampUpdate;

class ActiveExitTimestampRegister;

class ActiveExitTimestampMonotonicUpdate;

class ActiveExitTimestampMonotonicRegister;

class InactiveEnterTimestampUpdate;

class InactiveEnterTimestampRegister;

class InactiveEnterTimestampMonotonicUpdate;

class InactiveEnterTimestampMonotonicRegister;

class CanStartUpdate;

class CanStartRegister;

class CanStopUpdate;

class CanStopRegister;

class CanReloadUpdate;

class CanReloadRegister;

class CanIsolateUpdate;

class CanIsolateRegister;

class JobUpdate;

class JobRegister;

class StopWhenUnneededUpdate;

class StopWhenUnneededRegister;

class RefuseManualStartUpdate;

class RefuseManualStartRegister;

class RefuseManualStopUpdate;

class RefuseManualStopRegister;

class AllowIsolateUpdate;

class AllowIsolateRegister;

class DefaultDependenciesUpdate;

class DefaultDependenciesRegister;

class OnFailureJobModeUpdate;

class OnFailureJobModeRegister;

class IgnoreOnIsolateUpdate;

class IgnoreOnIsolateRegister;

class IgnoreOnSnapshotUpdate;

class IgnoreOnSnapshotRegister;

class NeedDaemonReloadUpdate;

class NeedDaemonReloadRegister;

class JobTimeoutUSecUpdate;

class JobTimeoutUSecRegister;

class JobTimeoutActionUpdate;

class JobTimeoutActionRegister;

class JobTimeoutRebootArgumentUpdate;

class JobTimeoutRebootArgumentRegister;

class ConditionResultUpdate;

class ConditionResultRegister;

class AssertResultUpdate;

class AssertResultRegister;

class ConditionTimestampUpdate;

class ConditionTimestampRegister;

class ConditionTimestampMonotonicUpdate;

class ConditionTimestampMonotonicRegister;

class AssertTimestampUpdate;

class AssertTimestampRegister;

class AssertTimestampMonotonicUpdate;

class AssertTimestampMonotonicRegister;

class ConditionsUpdate;

class ConditionsRegister;

class AssertsUpdate;

class AssertsRegister;

class LoadErrorUpdate;

class LoadErrorRegister;

class TransientUpdate;

class TransientRegister;

// type definitions
/**
 * The ObjectPath type (defined as an alias).
 */
typedef ::std::string ObjectPath;

/**
 * If the meaning of "StartError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartError;

/**
 * If the meaning of "StopError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StopError;

/**
 * If the meaning of "ReloadError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReloadError;

/**
 * If the meaning of "RestartError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RestartError;

/**
 * If the meaning of "TryRestartError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TryRestartError;

/**
 * If the meaning of "ReloadOrRestartError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReloadOrRestartError;

/**
 * If the meaning of "ReloadOrTryRestartError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReloadOrTryRestartError;

/**
 * If the meaning of "KillError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError KillError;

/**
 * ResetFailed.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ResetFailedRequest;

/**
 * ResetFailed.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ResetFailedResponse;

/**
 * If the meaning of "ResetFailedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ResetFailedError;

/**
 * SetProperties.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetPropertiesResponse;

/**
 * If the meaning of "SetPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetPropertiesError;

/**
 * Id contains the primary name of the unit
 */
typedef IdUpdate IdSet;

/**
 * Id contains the primary name of the unit
 */
typedef IdUpdate IdGet;

/**
 * If the meaning of "IdError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IdError;

/**
 * Names contains all names of the unit, including the primary name that is also exposed in Id.
 */
typedef NamesUpdate NamesSet;

/**
 * Names contains all names of the unit, including the primary name that is also exposed in Id.
 */
typedef NamesUpdate NamesGet;

/**
 * If the meaning of "NamesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NamesError;

/**
 * Following either contains the empty string or contains the name of another unit that this
 * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
 * 		unit, and which other unit this is might possibly change.
 */
typedef FollowingUpdate FollowingSet;

/**
 * Following either contains the empty string or contains the name of another unit that this
 * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
 * 		unit, and which other unit this is might possibly change.
 */
typedef FollowingUpdate FollowingGet;

/**
 * If the meaning of "FollowingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FollowingError;

/**
 * Requires contain arrays which encode the dependencies and their inverse dependencies
 * 		(where this applies), as configured in the unit file or determined automatically.
 */
typedef RequiresUpdate RequiresSet;

/**
 * Requires contain arrays which encode the dependencies and their inverse dependencies
 * 		(where this applies), as configured in the unit file or determined automatically.
 */
typedef RequiresUpdate RequiresGet;

/**
 * If the meaning of "RequiresError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequiresError;

/**
 * RequiresOverridable
 */
typedef RequiresOverridableUpdate RequiresOverridableSet;

/**
 * RequiresOverridable
 */
typedef RequiresOverridableUpdate RequiresOverridableGet;

/**
 * If the meaning of "RequiresOverridableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequiresOverridableError;

/**
 * Requisite
 */
typedef RequisiteUpdate RequisiteSet;

/**
 * Requisite
 */
typedef RequisiteUpdate RequisiteGet;

/**
 * If the meaning of "RequisiteError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequisiteError;

/**
 * RequisiteOverridable
 */
typedef RequisiteOverridableUpdate RequisiteOverridableSet;

/**
 * RequisiteOverridable
 */
typedef RequisiteOverridableUpdate RequisiteOverridableGet;

/**
 * If the meaning of "RequisiteOverridableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequisiteOverridableError;

/**
 * Wants
 */
typedef WantsUpdate WantsSet;

/**
 * Wants
 */
typedef WantsUpdate WantsGet;

/**
 * If the meaning of "WantsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WantsError;

/**
 * BindsTo
 */
typedef BindsToUpdate BindsToSet;

/**
 * BindsTo
 */
typedef BindsToUpdate BindsToGet;

/**
 * If the meaning of "BindsToError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BindsToError;

/**
 * PartOf
 */
typedef PartOfUpdate PartOfSet;

/**
 * PartOf
 */
typedef PartOfUpdate PartOfGet;

/**
 * If the meaning of "PartOfError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PartOfError;

/**
 * RequiredBy
 */
typedef RequiredByUpdate RequiredBySet;

/**
 * RequiredBy
 */
typedef RequiredByUpdate RequiredByGet;

/**
 * If the meaning of "RequiredByError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequiredByError;

/**
 * RequiredByOverridable
 */
typedef RequiredByOverridableUpdate RequiredByOverridableSet;

/**
 * RequiredByOverridable
 */
typedef RequiredByOverridableUpdate RequiredByOverridableGet;

/**
 * If the meaning of "RequiredByOverridableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequiredByOverridableError;

/**
 * RequisiteOf
 */
typedef RequisiteOfUpdate RequisiteOfSet;

/**
 * RequisiteOf
 */
typedef RequisiteOfUpdate RequisiteOfGet;

/**
 * If the meaning of "RequisiteOfError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequisiteOfError;

/**
 * RequisiteOfOverridable
 */
typedef RequisiteOfOverridableUpdate RequisiteOfOverridableSet;

/**
 * RequisiteOfOverridable
 */
typedef RequisiteOfOverridableUpdate RequisiteOfOverridableGet;

/**
 * If the meaning of "RequisiteOfOverridableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequisiteOfOverridableError;

/**
 * WantedBy
 */
typedef WantedByUpdate WantedBySet;

/**
 * WantedBy
 */
typedef WantedByUpdate WantedByGet;

/**
 * If the meaning of "WantedByError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WantedByError;

/**
 * BoundBy
 */
typedef BoundByUpdate BoundBySet;

/**
 * BoundBy
 */
typedef BoundByUpdate BoundByGet;

/**
 * If the meaning of "BoundByError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BoundByError;

/**
 * ConsistsOf
 */
typedef ConsistsOfUpdate ConsistsOfSet;

/**
 * ConsistsOf
 */
typedef ConsistsOfUpdate ConsistsOfGet;

/**
 * If the meaning of "ConsistsOfError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConsistsOfError;

/**
 * Conflicts
 */
typedef ConflictsUpdate ConflictsSet;

/**
 * Conflicts
 */
typedef ConflictsUpdate ConflictsGet;

/**
 * If the meaning of "ConflictsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConflictsError;

/**
 * ConflictedBy
 */
typedef ConflictedByUpdate ConflictedBySet;

/**
 * ConflictedBy
 */
typedef ConflictedByUpdate ConflictedByGet;

/**
 * If the meaning of "ConflictedByError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConflictedByError;

/**
 * Before
 */
typedef BeforeUpdate BeforeSet;

/**
 * Before
 */
typedef BeforeUpdate BeforeGet;

/**
 * If the meaning of "BeforeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BeforeError;

/**
 * After
 */
typedef AfterUpdate AfterSet;

/**
 * After
 */
typedef AfterUpdate AfterGet;

/**
 * If the meaning of "AfterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AfterError;

/**
 * OnFailure
 */
typedef OnFailureUpdate OnFailureSet;

/**
 * OnFailure
 */
typedef OnFailureUpdate OnFailureGet;

/**
 * If the meaning of "OnFailureError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnFailureError;

/**
 * Triggers
 */
typedef TriggersUpdate TriggersSet;

/**
 * Triggers
 */
typedef TriggersUpdate TriggersGet;

/**
 * If the meaning of "TriggersError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TriggersError;

/**
 * TriggeredBy
 */
typedef TriggeredByUpdate TriggeredBySet;

/**
 * TriggeredBy
 */
typedef TriggeredByUpdate TriggeredByGet;

/**
 * If the meaning of "TriggeredByError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TriggeredByError;

/**
 * PropagatesReloadTo
 */
typedef PropagatesReloadToUpdate PropagatesReloadToSet;

/**
 * PropagatesReloadTo
 */
typedef PropagatesReloadToUpdate PropagatesReloadToGet;

/**
 * If the meaning of "PropagatesReloadToError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PropagatesReloadToError;

/**
 * ReloadPropagatedFrom
 */
typedef ReloadPropagatedFromUpdate ReloadPropagatedFromSet;

/**
 * ReloadPropagatedFrom
 */
typedef ReloadPropagatedFromUpdate ReloadPropagatedFromGet;

/**
 * If the meaning of "ReloadPropagatedFromError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReloadPropagatedFromError;

/**
 * JoinsNamespaceOf
 */
typedef JoinsNamespaceOfUpdate JoinsNamespaceOfSet;

/**
 * JoinsNamespaceOf
 */
typedef JoinsNamespaceOfUpdate JoinsNamespaceOfGet;

/**
 * If the meaning of "JoinsNamespaceOfError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError JoinsNamespaceOfError;

/**
 * RequiresMountsFor
 */
typedef RequiresMountsForUpdate RequiresMountsForSet;

/**
 * RequiresMountsFor
 */
typedef RequiresMountsForUpdate RequiresMountsForGet;

/**
 * If the meaning of "RequiresMountsForError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequiresMountsForError;

/**
 * Documentation
 */
typedef DocumentationUpdate DocumentationSet;

/**
 * Documentation
 */
typedef DocumentationUpdate DocumentationGet;

/**
 * If the meaning of "DocumentationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DocumentationError;

/**
 * Description contains the human readable description string for the unit.
 */
typedef DescriptionUpdate DescriptionSet;

/**
 * Description contains the human readable description string for the unit.
 */
typedef DescriptionUpdate DescriptionGet;

/**
 * If the meaning of "DescriptionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DescriptionError;

/**
 * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
 * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
 * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
 * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
 * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
 * 		a time where a unit was already active).
 */
typedef LoadStateUpdate LoadStateSet;

/**
 * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
 * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
 * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
 * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
 * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
 * 		a time where a unit was already active).
 */
typedef LoadStateUpdate LoadStateGet;

/**
 * If the meaning of "LoadStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LoadStateError;

/**
 * ActiveState contains a state value that reflects whether the unit is currently active or not.
 * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
 * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
 * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
 * 		failed indicates that it is inactive and the previous run was not successful.
 * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
 * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
 */
typedef ActiveStateUpdate ActiveStateSet;

/**
 * ActiveState contains a state value that reflects whether the unit is currently active or not.
 * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
 * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
 * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
 * 		failed indicates that it is inactive and the previous run was not successful.
 * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
 * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
 */
typedef ActiveStateUpdate ActiveStateGet;

/**
 * If the meaning of "ActiveStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveStateError;

/**
 * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
 * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
 * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
 * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
 * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
 */
typedef SubStateUpdate SubStateSet;

/**
 * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
 * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
 * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
 * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
 * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
 */
typedef SubStateUpdate SubStateGet;

/**
 * If the meaning of "SubStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SubStateError;

/**
 * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
 */
typedef FragmentPathUpdate FragmentPathSet;

/**
 * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
 */
typedef FragmentPathUpdate FragmentPathGet;

/**
 * If the meaning of "FragmentPathError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FragmentPathError;

/**
 * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
 * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
 */
typedef SourcePathUpdate SourcePathSet;

/**
 * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
 * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
 */
typedef SourcePathUpdate SourcePathGet;

/**
 * If the meaning of "SourcePathError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SourcePathError;

/**
 * DropInPaths
 */
typedef DropInPathsUpdate DropInPathsSet;

/**
 * DropInPaths
 */
typedef DropInPathsUpdate DropInPathsGet;

/**
 * If the meaning of "DropInPathsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DropInPathsError;

/**
 * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
 * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
 * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
 * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
 * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
 * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
 * 		determined whether the unit file is enabled.
 */
typedef UnitFileStateUpdate UnitFileStateSet;

/**
 * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
 * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
 * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
 * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
 * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
 * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
 * 		determined whether the unit file is enabled.
 */
typedef UnitFileStateUpdate UnitFileStateGet;

/**
 * If the meaning of "UnitFileStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnitFileStateError;

/**
 * UnitFilePreset
 */
typedef UnitFilePresetUpdate UnitFilePresetSet;

/**
 * UnitFilePreset
 */
typedef UnitFilePresetUpdate UnitFilePresetGet;

/**
 * If the meaning of "UnitFilePresetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnitFilePresetError;

/**
 * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
 * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
 * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
 */
typedef InactiveExitTimestampUpdate InactiveExitTimestampSet;

/**
 * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
 * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
 * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
 */
typedef InactiveExitTimestampUpdate InactiveExitTimestampGet;

/**
 * If the meaning of "InactiveExitTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InactiveExitTimestampError;

/**
 * InactiveExitTimestampMonotonic
 */
typedef InactiveExitTimestampMonotonicUpdate InactiveExitTimestampMonotonicSet;

/**
 * InactiveExitTimestampMonotonic
 */
typedef InactiveExitTimestampMonotonicUpdate InactiveExitTimestampMonotonicGet;

/**
 * If the meaning of "InactiveExitTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InactiveExitTimestampMonotonicError;

/**
 * ActiveEnterTimestamp
 */
typedef ActiveEnterTimestampUpdate ActiveEnterTimestampSet;

/**
 * ActiveEnterTimestamp
 */
typedef ActiveEnterTimestampUpdate ActiveEnterTimestampGet;

/**
 * If the meaning of "ActiveEnterTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveEnterTimestampError;

/**
 * ActiveEnterTimestampMonotonic
 */
typedef ActiveEnterTimestampMonotonicUpdate ActiveEnterTimestampMonotonicSet;

/**
 * ActiveEnterTimestampMonotonic
 */
typedef ActiveEnterTimestampMonotonicUpdate ActiveEnterTimestampMonotonicGet;

/**
 * If the meaning of "ActiveEnterTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveEnterTimestampMonotonicError;

/**
 * ActiveExitTimestamp
 */
typedef ActiveExitTimestampUpdate ActiveExitTimestampSet;

/**
 * ActiveExitTimestamp
 */
typedef ActiveExitTimestampUpdate ActiveExitTimestampGet;

/**
 * If the meaning of "ActiveExitTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveExitTimestampError;

/**
 * ActiveExitTimestampMonotonic
 */
typedef ActiveExitTimestampMonotonicUpdate ActiveExitTimestampMonotonicSet;

/**
 * ActiveExitTimestampMonotonic
 */
typedef ActiveExitTimestampMonotonicUpdate ActiveExitTimestampMonotonicGet;

/**
 * If the meaning of "ActiveExitTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveExitTimestampMonotonicError;

/**
 * InactiveEnterTimestamp
 */
typedef InactiveEnterTimestampUpdate InactiveEnterTimestampSet;

/**
 * InactiveEnterTimestamp
 */
typedef InactiveEnterTimestampUpdate InactiveEnterTimestampGet;

/**
 * If the meaning of "InactiveEnterTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InactiveEnterTimestampError;

/**
 * InactiveEnterTimestampMonotonic
 */
typedef InactiveEnterTimestampMonotonicUpdate InactiveEnterTimestampMonotonicSet;

/**
 * InactiveEnterTimestampMonotonic
 */
typedef InactiveEnterTimestampMonotonicUpdate InactiveEnterTimestampMonotonicGet;

/**
 * If the meaning of "InactiveEnterTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InactiveEnterTimestampMonotonicError;

/**
 * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
 * 		the client might not necessary have the right privileges to execute them.
 */
typedef CanStartUpdate CanStartSet;

/**
 * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
 * 		the client might not necessary have the right privileges to execute them.
 */
typedef CanStartUpdate CanStartGet;

/**
 * If the meaning of "CanStartError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CanStartError;

/**
 * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
 * 		the client might not necessary have the right privileges to execute them.
 */
typedef CanStopUpdate CanStopSet;

/**
 * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
 * 		the client might not necessary have the right privileges to execute them.
 */
typedef CanStopUpdate CanStopGet;

/**
 * If the meaning of "CanStopError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CanStopError;

/**
 * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
 * 		the client might not necessary have the right privileges to execute them.
 */
typedef CanReloadUpdate CanReloadSet;

/**
 * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
 * 		the client might not necessary have the right privileges to execute them.
 */
typedef CanReloadUpdate CanReloadGet;

/**
 * If the meaning of "CanReloadError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CanReloadError;

/**
 * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
 */
typedef CanIsolateUpdate CanIsolateSet;

/**
 * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
 */
typedef CanIsolateUpdate CanIsolateGet;

/**
 * If the meaning of "CanIsolateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CanIsolateError;

/**
 * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
 * 		If no job is scheduled or executed the job id field will be 0.
 */
typedef JobUpdate JobSet;

/**
 * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
 * 		If no job is scheduled or executed the job id field will be 0.
 */
typedef JobUpdate JobGet;

/**
 * If the meaning of "JobError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError JobError;

/**
 * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
 */
typedef StopWhenUnneededUpdate StopWhenUnneededSet;

/**
 * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
 */
typedef StopWhenUnneededUpdate StopWhenUnneededGet;

/**
 * If the meaning of "StopWhenUnneededError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StopWhenUnneededError;

/**
 * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
 */
typedef RefuseManualStartUpdate RefuseManualStartSet;

/**
 * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
 */
typedef RefuseManualStartUpdate RefuseManualStartGet;

/**
 * If the meaning of "RefuseManualStartError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RefuseManualStartError;

/**
 * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
 */
typedef RefuseManualStopUpdate RefuseManualStopSet;

/**
 * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
 */
typedef RefuseManualStopUpdate RefuseManualStopGet;

/**
 * If the meaning of "RefuseManualStopError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RefuseManualStopError;

/**
 * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
 */
typedef AllowIsolateUpdate AllowIsolateSet;

/**
 * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
 */
typedef AllowIsolateUpdate AllowIsolateGet;

/**
 * If the meaning of "AllowIsolateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AllowIsolateError;

/**
 * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
 */
typedef DefaultDependenciesUpdate DefaultDependenciesSet;

/**
 * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
 */
typedef DefaultDependenciesUpdate DefaultDependenciesGet;

/**
 * If the meaning of "DefaultDependenciesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DefaultDependenciesError;

/**
 * OnFailureJobMode
 */
typedef OnFailureJobModeUpdate OnFailureJobModeSet;

/**
 * OnFailureJobMode
 */
typedef OnFailureJobModeUpdate OnFailureJobModeGet;

/**
 * If the meaning of "OnFailureJobModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnFailureJobModeError;

/**
 * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
 */
typedef IgnoreOnIsolateUpdate IgnoreOnIsolateSet;

/**
 * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
 */
typedef IgnoreOnIsolateUpdate IgnoreOnIsolateGet;

/**
 * If the meaning of "IgnoreOnIsolateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IgnoreOnIsolateError;

/**
 * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
 */
typedef IgnoreOnSnapshotUpdate IgnoreOnSnapshotSet;

/**
 * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
 */
typedef IgnoreOnSnapshotUpdate IgnoreOnSnapshotGet;

/**
 * If the meaning of "IgnoreOnSnapshotError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IgnoreOnSnapshotError;

/**
 * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
 * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
 */
typedef NeedDaemonReloadUpdate NeedDaemonReloadSet;

/**
 * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
 * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
 */
typedef NeedDaemonReloadUpdate NeedDaemonReloadGet;

/**
 * If the meaning of "NeedDaemonReloadError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NeedDaemonReloadError;

/**
 * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
 */
typedef JobTimeoutUSecUpdate JobTimeoutUSecSet;

/**
 * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
 */
typedef JobTimeoutUSecUpdate JobTimeoutUSecGet;

/**
 * If the meaning of "JobTimeoutUSecError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError JobTimeoutUSecError;

/**
 * JobTimeoutAction
 */
typedef JobTimeoutActionUpdate JobTimeoutActionSet;

/**
 * JobTimeoutAction
 */
typedef JobTimeoutActionUpdate JobTimeoutActionGet;

/**
 * If the meaning of "JobTimeoutActionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError JobTimeoutActionError;

/**
 * JobTimeoutRebootArgument
 */
typedef JobTimeoutRebootArgumentUpdate JobTimeoutRebootArgumentSet;

/**
 * JobTimeoutRebootArgument
 */
typedef JobTimeoutRebootArgumentUpdate JobTimeoutRebootArgumentGet;

/**
 * If the meaning of "JobTimeoutRebootArgumentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError JobTimeoutRebootArgumentError;

/**
 * ConditionResult contains the condition result of the last time the configured
 * 		conditions of this unit were checked.
 */
typedef ConditionResultUpdate ConditionResultSet;

/**
 * ConditionResult contains the condition result of the last time the configured
 * 		conditions of this unit were checked.
 */
typedef ConditionResultUpdate ConditionResultGet;

/**
 * If the meaning of "ConditionResultError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConditionResultError;

/**
 * AssertResult
 */
typedef AssertResultUpdate AssertResultSet;

/**
 * AssertResult
 */
typedef AssertResultUpdate AssertResultGet;

/**
 * If the meaning of "AssertResultError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AssertResultError;

/**
 * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
 * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
 */
typedef ConditionTimestampUpdate ConditionTimestampSet;

/**
 * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
 * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
 */
typedef ConditionTimestampUpdate ConditionTimestampGet;

/**
 * If the meaning of "ConditionTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConditionTimestampError;

/**
 * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
 * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
 */
typedef ConditionTimestampMonotonicUpdate ConditionTimestampMonotonicSet;

/**
 * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
 * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
 */
typedef ConditionTimestampMonotonicUpdate ConditionTimestampMonotonicGet;

/**
 * If the meaning of "ConditionTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConditionTimestampMonotonicError;

/**
 * AssertTimestamp
 */
typedef AssertTimestampUpdate AssertTimestampSet;

/**
 * AssertTimestamp
 */
typedef AssertTimestampUpdate AssertTimestampGet;

/**
 * If the meaning of "AssertTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AssertTimestampError;

/**
 * AssertTimestampMonotonic
 */
typedef AssertTimestampMonotonicUpdate AssertTimestampMonotonicSet;

/**
 * AssertTimestampMonotonic
 */
typedef AssertTimestampMonotonicUpdate AssertTimestampMonotonicGet;

/**
 * If the meaning of "AssertTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AssertTimestampMonotonicError;

/**
 * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
 * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
 * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
 * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
 */
typedef ConditionsUpdate ConditionsSet;

/**
 * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
 * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
 * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
 * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
 */
typedef ConditionsUpdate ConditionsGet;

/**
 * If the meaning of "ConditionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConditionsError;

/**
 * Asserts
 */
typedef AssertsUpdate AssertsSet;

/**
 * Asserts
 */
typedef AssertsUpdate AssertsGet;

/**
 * If the meaning of "AssertsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AssertsError;

/**
 * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
 * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
 * 		If it succeeded to load this will be a pair of empty strings.
 */
typedef LoadErrorUpdate LoadErrorSet;

/**
 * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
 * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
 * 		If it succeeded to load this will be a pair of empty strings.
 */
typedef LoadErrorUpdate LoadErrorGet;

/**
 * If the meaning of "LoadErrorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LoadErrorError;

/**
 * Transient contains a boolean that indicates whether the unit was created as transient unit
 * 		(i.e. via CreateTransientUnit() on the manager object).
 */
typedef TransientUpdate TransientSet;

/**
 * Transient contains a boolean that indicates whether the unit was created as transient unit
 * 		(i.e. via CreateTransientUnit() on the manager object).
 */
typedef TransientUpdate TransientGet;

/**
 * If the meaning of "TransientError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TransientError;


/**
 * job struct
 */
class job {
public:

    /**
     * Default constructor
     */
    inline  job ();

    /**
     * Copy constructor
     */
    inline  job (const job &rhs);

    /**
     * All fields constructor
     */
    inline  job (uint32 jobId_, const ::std::string& path_);

    /**
     * Destructor
     */
    inline  ~job();

    /**
     * Assignment operator
     */
    inline job& operator = (const job& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const job& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const job& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const job& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const job& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jobId"

    static const int kJobId = 0;

    /**
     * Clears the field "jobId".
     *
     * The field will be set to its default value. The hasJobId()
     * method will return false.
     */
    inline void clearJobId();

    /**
     * Checks whether the field "jobId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobId()). Otherwise it will return false.
     */
    inline bool hasJobId () const;

    /**
     * Returns the value of the member "jobId".
     *
     * If the meaning of "jobId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "jobId"
     */
    inline uint32 getJobId () const;

    /**
     * Sets the value of the member "jobId".
     *
     * If the meaning of "jobId" isn't clear, then there should be a description here.
     *
     * @param jobId The value which will be set
     */
    inline void setJobId (uint32 jobId_);

    // API of field "path"

    static const int kPath = 1;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const job &getDefaultInstance();

private:

    inline void set_has_jobId ();

    inline void clear_has_jobId ();

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _jobId;

    ::std::string _path;

};

/**
 * condition struct
 */
class condition {
public:

    /**
     * Default constructor
     */
    inline  condition ();

    /**
     * Copy constructor
     */
    inline  condition (const condition &rhs);

    /**
     * All fields constructor
     */
    inline  condition (const ::std::string& type_, bool triggerCondition_, bool reverseCondition_, const ::std::string& path_, int32 status_);

    /**
     * Destructor
     */
    inline  ~condition();

    /**
     * Assignment operator
     */
    inline condition& operator = (const condition& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const condition& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const condition& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const condition& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const condition& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "type"

    static const int kType = 0;

    /**
     * Clears the field "type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "type".
     *
     * If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "type"
     */
    inline const ::std::string& getType () const;

    /**
     * Retrieves the value of the field "type" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "type".
     */
    inline ::std::string& getTypeMutable ();

    /**
     * Sets the value of the member "type".
     *
     * If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @param type The value which will be set
     */
    inline void setType (const ::std::string& type_);

    /**
     * Sets the value of the member "type".
     *
     * If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @param type The value which will be set
     */
    inline void setType (const char* type_);

    /**
     * Sets the value of the member "type".
     *
     * If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @param type The value which will be set
     */
    inline void setType (const char* value, size_t size);

    // API of field "triggerCondition"

    static const int kTriggerCondition = 1;

    /**
     * Clears the field "triggerCondition".
     *
     * The field will be set to its default value. The hasTriggerCondition()
     * method will return false.
     */
    inline void clearTriggerCondition();

    /**
     * Checks whether the field "triggerCondition" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTriggerCondition()). Otherwise it will return false.
     */
    inline bool hasTriggerCondition () const;

    /**
     * Returns the value of the member "triggerCondition".
     *
     * If the meaning of "triggerCondition" isn't clear, then there should be a description here.
     *
     * @return The value of the field "triggerCondition"
     */
    inline bool getTriggerCondition () const;

    /**
     * Sets the value of the member "triggerCondition".
     *
     * If the meaning of "triggerCondition" isn't clear, then there should be a description here.
     *
     * @param triggerCondition The value which will be set
     */
    inline void setTriggerCondition (bool triggerCondition_);

    // API of field "reverseCondition"

    static const int kReverseCondition = 2;

    /**
     * Clears the field "reverseCondition".
     *
     * The field will be set to its default value. The hasReverseCondition()
     * method will return false.
     */
    inline void clearReverseCondition();

    /**
     * Checks whether the field "reverseCondition" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReverseCondition()). Otherwise it will return false.
     */
    inline bool hasReverseCondition () const;

    /**
     * Returns the value of the member "reverseCondition".
     *
     * If the meaning of "reverseCondition" isn't clear, then there should be a description here.
     *
     * @return The value of the field "reverseCondition"
     */
    inline bool getReverseCondition () const;

    /**
     * Sets the value of the member "reverseCondition".
     *
     * If the meaning of "reverseCondition" isn't clear, then there should be a description here.
     *
     * @param reverseCondition The value which will be set
     */
    inline void setReverseCondition (bool reverseCondition_);

    // API of field "path"

    static const int kPath = 3;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    // API of field "status"

    static const int kStatus = 4;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline int32 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (int32 status_);

    static const condition &getDefaultInstance();

private:

    inline void set_has_type ();

    inline void clear_has_type ();

    inline void set_has_triggerCondition ();

    inline void clear_has_triggerCondition ();

    inline void set_has_reverseCondition ();

    inline void clear_has_reverseCondition ();

    inline void set_has_path ();

    inline void clear_has_path ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _type;

    bool _triggerCondition;

    bool _reverseCondition;

    ::std::string _path;

    int32 _status;

};

/**
 * loadError struct
 */
class loadError {
public:

    /**
     * Default constructor
     */
    inline  loadError ();

    /**
     * Copy constructor
     */
    inline  loadError (const loadError &rhs);

    /**
     * All fields constructor
     */
    inline  loadError (const ::std::string& errorId_, const ::std::string& errorName_);

    /**
     * Destructor
     */
    inline  ~loadError();

    /**
     * Assignment operator
     */
    inline loadError& operator = (const loadError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const loadError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const loadError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const loadError& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const loadError& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "errorId"

    static const int kErrorId = 0;

    /**
     * Clears the field "errorId".
     *
     * The field will be set to its default value. The hasErrorId()
     * method will return false.
     */
    inline void clearErrorId();

    /**
     * Checks whether the field "errorId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorId()). Otherwise it will return false.
     */
    inline bool hasErrorId () const;

    /**
     * Returns the value of the member "errorId".
     *
     * If the meaning of "errorId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "errorId"
     */
    inline const ::std::string& getErrorId () const;

    /**
     * Retrieves the value of the field "errorId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "errorId".
     */
    inline ::std::string& getErrorIdMutable ();

    /**
     * Sets the value of the member "errorId".
     *
     * If the meaning of "errorId" isn't clear, then there should be a description here.
     *
     * @param errorId The value which will be set
     */
    inline void setErrorId (const ::std::string& errorId_);

    /**
     * Sets the value of the member "errorId".
     *
     * If the meaning of "errorId" isn't clear, then there should be a description here.
     *
     * @param errorId The value which will be set
     */
    inline void setErrorId (const char* errorId_);

    /**
     * Sets the value of the member "errorId".
     *
     * If the meaning of "errorId" isn't clear, then there should be a description here.
     *
     * @param errorId The value which will be set
     */
    inline void setErrorId (const char* value, size_t size);

    // API of field "errorName"

    static const int kErrorName = 1;

    /**
     * Clears the field "errorName".
     *
     * The field will be set to its default value. The hasErrorName()
     * method will return false.
     */
    inline void clearErrorName();

    /**
     * Checks whether the field "errorName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorName()). Otherwise it will return false.
     */
    inline bool hasErrorName () const;

    /**
     * Returns the value of the member "errorName".
     *
     * If the meaning of "errorName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "errorName"
     */
    inline const ::std::string& getErrorName () const;

    /**
     * Retrieves the value of the field "errorName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "errorName".
     */
    inline ::std::string& getErrorNameMutable ();

    /**
     * Sets the value of the member "errorName".
     *
     * If the meaning of "errorName" isn't clear, then there should be a description here.
     *
     * @param errorName The value which will be set
     */
    inline void setErrorName (const ::std::string& errorName_);

    /**
     * Sets the value of the member "errorName".
     *
     * If the meaning of "errorName" isn't clear, then there should be a description here.
     *
     * @param errorName The value which will be set
     */
    inline void setErrorName (const char* errorName_);

    /**
     * Sets the value of the member "errorName".
     *
     * If the meaning of "errorName" isn't clear, then there should be a description here.
     *
     * @param errorName The value which will be set
     */
    inline void setErrorName (const char* value, size_t size);

    static const loadError &getDefaultInstance();

private:

    inline void set_has_errorId ();

    inline void clear_has_errorId ();

    inline void set_has_errorName ();

    inline void clear_has_errorName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _errorId;

    ::std::string _errorName;

};

/**
 * Property info struct
 */
class property {
public:

    /**
     * Default constructor
     */
    inline  property ();

    /**
     * Copy constructor
     */
    inline  property (const property &rhs);

    /**
     * All fields constructor
     */
    inline  property (const ::std::string& name_, const ::std::string& value_);

    /**
     * Destructor
     */
    inline  ~property();

    /**
     * Assignment operator
     */
    inline property& operator = (const property& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const property& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const property& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const property& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const property& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::std::string& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::std::string& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::std::string& value_);

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const char* value_);

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const char* value, size_t size);

    static const property &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::std::string _value;

};

/**
 * Start(), Stop(), Reload(), Restart(), TryRestart(), ReloadOrRestart(), ReloadOrTryRestart(),
 * 		Kill(), ResetFailed() and SetProperties() implement the same operation as the respective method calls on the Manager
 * 		object (see above), however operate on the unit object and hence do not take a unit name parameter. Invoking the methods
 * 		directly on the Manager object has the advantage of not requiring a GetUnit() call to get the unit object for a specific
 * 		unit name. Calling the methods on the Manager object is hence a round trip optimization.
 */
class StartRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartRequest ();

    /**
     * Copy constructor
     */
    inline  StartRequest (const StartRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartRequest (const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~StartRequest();

    /**
     * Assignment operator
     */
    inline StartRequest& operator = (const StartRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mode"

    static const int kMode = 0;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const StartRequest &getDefaultInstance();

private:

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _mode;

};

/**
 * Start(), Stop(), Reload(), Restart(), TryRestart(), ReloadOrRestart(), ReloadOrTryRestart(),
 * 		Kill(), ResetFailed() and SetProperties() implement the same operation as the respective method calls on the Manager
 * 		object (see above), however operate on the unit object and hence do not take a unit name parameter. Invoking the methods
 * 		directly on the Manager object has the advantage of not requiring a GetUnit() call to get the unit object for a specific
 * 		unit name. Calling the methods on the Manager object is hence a round trip optimization.
 */
class StartResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartResponse ();

    /**
     * Copy constructor
     */
    inline  StartResponse (const StartResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StartResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~StartResponse();

    /**
     * Assignment operator
     */
    inline StartResponse& operator = (const StartResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const StartResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * Stop.
 */
class StopRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopRequest ();

    /**
     * Copy constructor
     */
    inline  StopRequest (const StopRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StopRequest (const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~StopRequest();

    /**
     * Assignment operator
     */
    inline StopRequest& operator = (const StopRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mode"

    static const int kMode = 0;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const StopRequest &getDefaultInstance();

private:

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _mode;

};

/**
 * Stop.
 */
class StopResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopResponse ();

    /**
     * Copy constructor
     */
    inline  StopResponse (const StopResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StopResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~StopResponse();

    /**
     * Assignment operator
     */
    inline StopResponse& operator = (const StopResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const StopResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * Reload.
 */
class ReloadRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadRequest ();

    /**
     * Copy constructor
     */
    inline  ReloadRequest (const ReloadRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadRequest (const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadRequest();

    /**
     * Assignment operator
     */
    inline ReloadRequest& operator = (const ReloadRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mode"

    static const int kMode = 0;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const ReloadRequest &getDefaultInstance();

private:

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _mode;

};

/**
 * Reload.
 */
class ReloadResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadResponse ();

    /**
     * Copy constructor
     */
    inline  ReloadResponse (const ReloadResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadResponse();

    /**
     * Assignment operator
     */
    inline ReloadResponse& operator = (const ReloadResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const ReloadResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * Restart.
 */
class RestartRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartRequest ();

    /**
     * Copy constructor
     */
    inline  RestartRequest (const RestartRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RestartRequest (const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~RestartRequest();

    /**
     * Assignment operator
     */
    inline RestartRequest& operator = (const RestartRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mode"

    static const int kMode = 0;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const RestartRequest &getDefaultInstance();

private:

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _mode;

};

/**
 * Restart.
 */
class RestartResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartResponse ();

    /**
     * Copy constructor
     */
    inline  RestartResponse (const RestartResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RestartResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~RestartResponse();

    /**
     * Assignment operator
     */
    inline RestartResponse& operator = (const RestartResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const RestartResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * TryRestart.
 */
class TryRestartRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TryRestartRequest ();

    /**
     * Copy constructor
     */
    inline  TryRestartRequest (const TryRestartRequest &rhs);

    /**
     * All fields constructor
     */
    inline  TryRestartRequest (const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~TryRestartRequest();

    /**
     * Assignment operator
     */
    inline TryRestartRequest& operator = (const TryRestartRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TryRestartRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TryRestartRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TryRestartRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TryRestartRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mode"

    static const int kMode = 0;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const TryRestartRequest &getDefaultInstance();

private:

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _mode;

};

/**
 * TryRestart.
 */
class TryRestartResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TryRestartResponse ();

    /**
     * Copy constructor
     */
    inline  TryRestartResponse (const TryRestartResponse &rhs);

    /**
     * All fields constructor
     */
    inline  TryRestartResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~TryRestartResponse();

    /**
     * Assignment operator
     */
    inline TryRestartResponse& operator = (const TryRestartResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TryRestartResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TryRestartResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TryRestartResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TryRestartResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const TryRestartResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * ReloadOrRestart.
 */
class ReloadOrRestartRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadOrRestartRequest ();

    /**
     * Copy constructor
     */
    inline  ReloadOrRestartRequest (const ReloadOrRestartRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadOrRestartRequest (const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadOrRestartRequest();

    /**
     * Assignment operator
     */
    inline ReloadOrRestartRequest& operator = (const ReloadOrRestartRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadOrRestartRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadOrRestartRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadOrRestartRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadOrRestartRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mode"

    static const int kMode = 0;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const ReloadOrRestartRequest &getDefaultInstance();

private:

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _mode;

};

/**
 * ReloadOrRestart.
 */
class ReloadOrRestartResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadOrRestartResponse ();

    /**
     * Copy constructor
     */
    inline  ReloadOrRestartResponse (const ReloadOrRestartResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadOrRestartResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadOrRestartResponse();

    /**
     * Assignment operator
     */
    inline ReloadOrRestartResponse& operator = (const ReloadOrRestartResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadOrRestartResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadOrRestartResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadOrRestartResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadOrRestartResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const ReloadOrRestartResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * ReloadOrTryRestart.
 */
class ReloadOrTryRestartRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadOrTryRestartRequest ();

    /**
     * Copy constructor
     */
    inline  ReloadOrTryRestartRequest (const ReloadOrTryRestartRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadOrTryRestartRequest (const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadOrTryRestartRequest();

    /**
     * Assignment operator
     */
    inline ReloadOrTryRestartRequest& operator = (const ReloadOrTryRestartRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadOrTryRestartRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadOrTryRestartRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadOrTryRestartRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadOrTryRestartRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mode"

    static const int kMode = 0;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const ReloadOrTryRestartRequest &getDefaultInstance();

private:

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _mode;

};

/**
 * ReloadOrTryRestart.
 */
class ReloadOrTryRestartResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadOrTryRestartResponse ();

    /**
     * Copy constructor
     */
    inline  ReloadOrTryRestartResponse (const ReloadOrTryRestartResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadOrTryRestartResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadOrTryRestartResponse();

    /**
     * Assignment operator
     */
    inline ReloadOrTryRestartResponse& operator = (const ReloadOrTryRestartResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadOrTryRestartResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadOrTryRestartResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadOrTryRestartResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadOrTryRestartResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const ReloadOrTryRestartResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * Kill.
 */
class KillRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KillRequest ();

    /**
     * Copy constructor
     */
    inline  KillRequest (const KillRequest &rhs);

    /**
     * All fields constructor
     */
    inline  KillRequest (const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~KillRequest();

    /**
     * Assignment operator
     */
    inline KillRequest& operator = (const KillRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KillRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KillRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KillRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KillRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mode"

    static const int kMode = 0;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const KillRequest &getDefaultInstance();

private:

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _mode;

};

/**
 * Kill.
 */
class KillResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KillResponse ();

    /**
     * Copy constructor
     */
    inline  KillResponse (const KillResponse &rhs);

    /**
     * All fields constructor
     */
    inline  KillResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~KillResponse();

    /**
     * Assignment operator
     */
    inline KillResponse& operator = (const KillResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KillResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KillResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KillResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KillResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const KillResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * SetProperties.
 */
class SetPropertiesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPropertiesRequest ();

    /**
     * Copy constructor
     */
    inline  SetPropertiesRequest (const SetPropertiesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetPropertiesRequest (bool runtime_, const ::std::vector< property >& properties_);

    /**
     * Destructor
     */
    inline virtual  ~SetPropertiesRequest();

    /**
     * Assignment operator
     */
    inline SetPropertiesRequest& operator = (const SetPropertiesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPropertiesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPropertiesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPropertiesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPropertiesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "runtime"

    static const int kRuntime = 0;

    /**
     * Clears the field "runtime".
     *
     * The field will be set to its default value. The hasRuntime()
     * method will return false.
     */
    inline void clearRuntime();

    /**
     * Checks whether the field "runtime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntime()). Otherwise it will return false.
     */
    inline bool hasRuntime () const;

    /**
     * Returns the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "runtime"
     */
    inline bool getRuntime () const;

    /**
     * Sets the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param runtime The value which will be set
     */
    inline void setRuntime (bool runtime_);

    // API of field "properties"

    static const int kProperties = 1;

    /**
     * Clears the field "properties".
     *
     * The field will be set to its default value. The hasProperties()
     * method will return false.
     */
    inline void clearProperties();

    /**
     * Checks whether the field "properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperties()). Otherwise it will return false.
     */
    inline bool hasProperties () const;

    /**
     * Returns the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "properties"
     */
    inline const ::std::vector< property >& getProperties () const;

    /**
     * Retrieves the value of the field "properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "properties".
     */
    inline ::std::vector< property >& getPropertiesMutable ();

    /**
     * Sets the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param properties The value which will be set
     */
    inline void setProperties (const ::std::vector< property >& properties_);

    static const SetPropertiesRequest &getDefaultInstance();

private:

    static const ::std::vector< property >& getPropertyList_DefaultInstance ();

    inline void set_has_runtime ();

    inline void clear_has_runtime ();

    inline void set_has_properties ();

    inline void clear_has_properties ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _runtime;

    ::std::vector< property > _properties;

};

/**
 * Id contains the primary name of the unit
 */
class IdUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IdUpdate ();

    /**
     * Copy constructor
     */
    inline  IdUpdate (const IdUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IdUpdate (const ::std::string& Id_);

    /**
     * Destructor
     */
    inline virtual  ~IdUpdate();

    /**
     * Assignment operator
     */
    inline IdUpdate& operator = (const IdUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IdUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IdUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IdUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IdUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Id"

    static const int kId = 0;

    /**
     * Clears the field "Id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "Id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "Id".
     *
     * Id contains the primary name of the unit
     *
     * @return The value of the field "Id"
     */
    inline const ::std::string& getId () const;

    /**
     * Retrieves the value of the field "Id" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Id".
     */
    inline ::std::string& getIdMutable ();

    /**
     * Sets the value of the member "Id".
     *
     * Id contains the primary name of the unit
     *
     * @param Id The value which will be set
     */
    inline void setId (const ::std::string& Id_);

    /**
     * Sets the value of the member "Id".
     *
     * Id contains the primary name of the unit
     *
     * @param Id The value which will be set
     */
    inline void setId (const char* Id_);

    /**
     * Sets the value of the member "Id".
     *
     * Id contains the primary name of the unit
     *
     * @param Id The value which will be set
     */
    inline void setId (const char* value, size_t size);

    static const IdUpdate &getDefaultInstance();

private:

    inline void set_has_Id ();

    inline void clear_has_Id ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Id;

};

/**
 * Id contains the primary name of the unit
 */
class IdRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IdRegister ();

    /**
     * Copy constructor
     */
    inline  IdRegister (const IdRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IdRegister();

    /**
     * Assignment operator
     */
    inline IdRegister& operator = (const IdRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IdRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IdRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IdRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IdRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IdRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Names contains all names of the unit, including the primary name that is also exposed in Id.
 */
class NamesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NamesUpdate ();

    /**
     * Copy constructor
     */
    inline  NamesUpdate (const NamesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NamesUpdate (const ::std::vector< ::std::string >& Names_);

    /**
     * Destructor
     */
    inline virtual  ~NamesUpdate();

    /**
     * Assignment operator
     */
    inline NamesUpdate& operator = (const NamesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NamesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NamesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NamesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NamesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Names"

    static const int kNames = 0;

    /**
     * Clears the field "Names".
     *
     * The field will be set to its default value. The hasNames()
     * method will return false.
     */
    inline void clearNames();

    /**
     * Checks whether the field "Names" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNames()). Otherwise it will return false.
     */
    inline bool hasNames () const;

    /**
     * Returns the value of the member "Names".
     *
     * Names contains all names of the unit, including the primary name that is also exposed in Id.
     *
     * @return The value of the field "Names"
     */
    inline const ::std::vector< ::std::string >& getNames () const;

    /**
     * Retrieves the value of the field "Names" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Names".
     */
    inline ::std::vector< ::std::string >& getNamesMutable ();

    /**
     * Sets the value of the member "Names".
     *
     * Names contains all names of the unit, including the primary name that is also exposed in Id.
     *
     * @param Names The value which will be set
     */
    inline void setNames (const ::std::vector< ::std::string >& Names_);

    static const NamesUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_Names ();

    inline void clear_has_Names ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _Names;

};

/**
 * Names contains all names of the unit, including the primary name that is also exposed in Id.
 */
class NamesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NamesRegister ();

    /**
     * Copy constructor
     */
    inline  NamesRegister (const NamesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NamesRegister();

    /**
     * Assignment operator
     */
    inline NamesRegister& operator = (const NamesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NamesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NamesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NamesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NamesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NamesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Following either contains the empty string or contains the name of another unit that this
 * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
 * 		unit, and which other unit this is might possibly change.
 */
class FollowingUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FollowingUpdate ();

    /**
     * Copy constructor
     */
    inline  FollowingUpdate (const FollowingUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FollowingUpdate (const ::std::string& Following_);

    /**
     * Destructor
     */
    inline virtual  ~FollowingUpdate();

    /**
     * Assignment operator
     */
    inline FollowingUpdate& operator = (const FollowingUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FollowingUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FollowingUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FollowingUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FollowingUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Following"

    static const int kFollowing = 0;

    /**
     * Clears the field "Following".
     *
     * The field will be set to its default value. The hasFollowing()
     * method will return false.
     */
    inline void clearFollowing();

    /**
     * Checks whether the field "Following" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFollowing()). Otherwise it will return false.
     */
    inline bool hasFollowing () const;

    /**
     * Returns the value of the member "Following".
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     *
     * @return The value of the field "Following"
     */
    inline const ::std::string& getFollowing () const;

    /**
     * Retrieves the value of the field "Following" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Following".
     */
    inline ::std::string& getFollowingMutable ();

    /**
     * Sets the value of the member "Following".
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     *
     * @param Following The value which will be set
     */
    inline void setFollowing (const ::std::string& Following_);

    /**
     * Sets the value of the member "Following".
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     *
     * @param Following The value which will be set
     */
    inline void setFollowing (const char* Following_);

    /**
     * Sets the value of the member "Following".
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     *
     * @param Following The value which will be set
     */
    inline void setFollowing (const char* value, size_t size);

    static const FollowingUpdate &getDefaultInstance();

private:

    inline void set_has_Following ();

    inline void clear_has_Following ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Following;

};

/**
 * Following either contains the empty string or contains the name of another unit that this
 * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
 * 		unit, and which other unit this is might possibly change.
 */
class FollowingRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FollowingRegister ();

    /**
     * Copy constructor
     */
    inline  FollowingRegister (const FollowingRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FollowingRegister();

    /**
     * Assignment operator
     */
    inline FollowingRegister& operator = (const FollowingRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FollowingRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FollowingRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FollowingRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FollowingRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FollowingRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Requires contain arrays which encode the dependencies and their inverse dependencies
 * 		(where this applies), as configured in the unit file or determined automatically.
 */
class RequiresUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequiresUpdate ();

    /**
     * Copy constructor
     */
    inline  RequiresUpdate (const RequiresUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RequiresUpdate (const ::std::vector< ::std::string >& Requires_);

    /**
     * Destructor
     */
    inline virtual  ~RequiresUpdate();

    /**
     * Assignment operator
     */
    inline RequiresUpdate& operator = (const RequiresUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequiresUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequiresUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequiresUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequiresUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Requires"

    static const int kRequires = 0;

    /**
     * Clears the field "Requires".
     *
     * The field will be set to its default value. The hasRequires()
     * method will return false.
     */
    inline void clearRequires();

    /**
     * Checks whether the field "Requires" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequires()). Otherwise it will return false.
     */
    inline bool hasRequires () const;

    /**
     * Returns the value of the member "Requires".
     *
     * Requires contain arrays which encode the dependencies and their inverse dependencies
     * 		(where this applies), as configured in the unit file or determined automatically.
     *
     * @return The value of the field "Requires"
     */
    inline const ::std::vector< ::std::string >& getRequires () const;

    /**
     * Retrieves the value of the field "Requires" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Requires".
     */
    inline ::std::vector< ::std::string >& getRequiresMutable ();

    /**
     * Sets the value of the member "Requires".
     *
     * Requires contain arrays which encode the dependencies and their inverse dependencies
     * 		(where this applies), as configured in the unit file or determined automatically.
     *
     * @param Requires The value which will be set
     */
    inline void setRequires (const ::std::vector< ::std::string >& Requires_);

    static const RequiresUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_Requires ();

    inline void clear_has_Requires ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _Requires;

};

/**
 * Requires contain arrays which encode the dependencies and their inverse dependencies
 * 		(where this applies), as configured in the unit file or determined automatically.
 */
class RequiresRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequiresRegister ();

    /**
     * Copy constructor
     */
    inline  RequiresRegister (const RequiresRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RequiresRegister();

    /**
     * Assignment operator
     */
    inline RequiresRegister& operator = (const RequiresRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequiresRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequiresRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequiresRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequiresRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RequiresRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * RequiresOverridable
 */
class RequiresOverridableUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequiresOverridableUpdate ();

    /**
     * Copy constructor
     */
    inline  RequiresOverridableUpdate (const RequiresOverridableUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RequiresOverridableUpdate (const ::std::vector< ::std::string >& RequiresOverridable_);

    /**
     * Destructor
     */
    inline virtual  ~RequiresOverridableUpdate();

    /**
     * Assignment operator
     */
    inline RequiresOverridableUpdate& operator = (const RequiresOverridableUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequiresOverridableUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequiresOverridableUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequiresOverridableUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequiresOverridableUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RequiresOverridable"

    static const int kRequiresOverridable = 0;

    /**
     * Clears the field "RequiresOverridable".
     *
     * The field will be set to its default value. The hasRequiresOverridable()
     * method will return false.
     */
    inline void clearRequiresOverridable();

    /**
     * Checks whether the field "RequiresOverridable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequiresOverridable()). Otherwise it will return false.
     */
    inline bool hasRequiresOverridable () const;

    /**
     * Returns the value of the member "RequiresOverridable".
     *
     * RequiresOverridable
     *
     * @return The value of the field "RequiresOverridable"
     */
    inline const ::std::vector< ::std::string >& getRequiresOverridable () const;

    /**
     * Retrieves the value of the field "RequiresOverridable" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RequiresOverridable".
     */
    inline ::std::vector< ::std::string >& getRequiresOverridableMutable ();

    /**
     * Sets the value of the member "RequiresOverridable".
     *
     * RequiresOverridable
     *
     * @param RequiresOverridable The value which will be set
     */
    inline void setRequiresOverridable (const ::std::vector< ::std::string >& RequiresOverridable_);

    static const RequiresOverridableUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_RequiresOverridable ();

    inline void clear_has_RequiresOverridable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _RequiresOverridable;

};

/**
 * RequiresOverridable
 */
class RequiresOverridableRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequiresOverridableRegister ();

    /**
     * Copy constructor
     */
    inline  RequiresOverridableRegister (const RequiresOverridableRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RequiresOverridableRegister();

    /**
     * Assignment operator
     */
    inline RequiresOverridableRegister& operator = (const RequiresOverridableRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequiresOverridableRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequiresOverridableRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequiresOverridableRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequiresOverridableRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RequiresOverridableRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Requisite
 */
class RequisiteUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequisiteUpdate ();

    /**
     * Copy constructor
     */
    inline  RequisiteUpdate (const RequisiteUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RequisiteUpdate (const ::std::vector< ::std::string >& Requisite_);

    /**
     * Destructor
     */
    inline virtual  ~RequisiteUpdate();

    /**
     * Assignment operator
     */
    inline RequisiteUpdate& operator = (const RequisiteUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequisiteUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequisiteUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequisiteUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequisiteUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Requisite"

    static const int kRequisite = 0;

    /**
     * Clears the field "Requisite".
     *
     * The field will be set to its default value. The hasRequisite()
     * method will return false.
     */
    inline void clearRequisite();

    /**
     * Checks whether the field "Requisite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequisite()). Otherwise it will return false.
     */
    inline bool hasRequisite () const;

    /**
     * Returns the value of the member "Requisite".
     *
     * Requisite
     *
     * @return The value of the field "Requisite"
     */
    inline const ::std::vector< ::std::string >& getRequisite () const;

    /**
     * Retrieves the value of the field "Requisite" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Requisite".
     */
    inline ::std::vector< ::std::string >& getRequisiteMutable ();

    /**
     * Sets the value of the member "Requisite".
     *
     * Requisite
     *
     * @param Requisite The value which will be set
     */
    inline void setRequisite (const ::std::vector< ::std::string >& Requisite_);

    static const RequisiteUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_Requisite ();

    inline void clear_has_Requisite ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _Requisite;

};

/**
 * Requisite
 */
class RequisiteRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequisiteRegister ();

    /**
     * Copy constructor
     */
    inline  RequisiteRegister (const RequisiteRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RequisiteRegister();

    /**
     * Assignment operator
     */
    inline RequisiteRegister& operator = (const RequisiteRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequisiteRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequisiteRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequisiteRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequisiteRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RequisiteRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * RequisiteOverridable
 */
class RequisiteOverridableUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequisiteOverridableUpdate ();

    /**
     * Copy constructor
     */
    inline  RequisiteOverridableUpdate (const RequisiteOverridableUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RequisiteOverridableUpdate (const ::std::vector< ::std::string >& RequisiteOverridable_);

    /**
     * Destructor
     */
    inline virtual  ~RequisiteOverridableUpdate();

    /**
     * Assignment operator
     */
    inline RequisiteOverridableUpdate& operator = (const RequisiteOverridableUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequisiteOverridableUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequisiteOverridableUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequisiteOverridableUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequisiteOverridableUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RequisiteOverridable"

    static const int kRequisiteOverridable = 0;

    /**
     * Clears the field "RequisiteOverridable".
     *
     * The field will be set to its default value. The hasRequisiteOverridable()
     * method will return false.
     */
    inline void clearRequisiteOverridable();

    /**
     * Checks whether the field "RequisiteOverridable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequisiteOverridable()). Otherwise it will return false.
     */
    inline bool hasRequisiteOverridable () const;

    /**
     * Returns the value of the member "RequisiteOverridable".
     *
     * RequisiteOverridable
     *
     * @return The value of the field "RequisiteOverridable"
     */
    inline const ::std::vector< ::std::string >& getRequisiteOverridable () const;

    /**
     * Retrieves the value of the field "RequisiteOverridable" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RequisiteOverridable".
     */
    inline ::std::vector< ::std::string >& getRequisiteOverridableMutable ();

    /**
     * Sets the value of the member "RequisiteOverridable".
     *
     * RequisiteOverridable
     *
     * @param RequisiteOverridable The value which will be set
     */
    inline void setRequisiteOverridable (const ::std::vector< ::std::string >& RequisiteOverridable_);

    static const RequisiteOverridableUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_RequisiteOverridable ();

    inline void clear_has_RequisiteOverridable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _RequisiteOverridable;

};

/**
 * RequisiteOverridable
 */
class RequisiteOverridableRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequisiteOverridableRegister ();

    /**
     * Copy constructor
     */
    inline  RequisiteOverridableRegister (const RequisiteOverridableRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RequisiteOverridableRegister();

    /**
     * Assignment operator
     */
    inline RequisiteOverridableRegister& operator = (const RequisiteOverridableRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequisiteOverridableRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequisiteOverridableRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequisiteOverridableRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequisiteOverridableRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RequisiteOverridableRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Wants
 */
class WantsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WantsUpdate ();

    /**
     * Copy constructor
     */
    inline  WantsUpdate (const WantsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WantsUpdate (const ::std::vector< ::std::string >& Wants_);

    /**
     * Destructor
     */
    inline virtual  ~WantsUpdate();

    /**
     * Assignment operator
     */
    inline WantsUpdate& operator = (const WantsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WantsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WantsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WantsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WantsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Wants"

    static const int kWants = 0;

    /**
     * Clears the field "Wants".
     *
     * The field will be set to its default value. The hasWants()
     * method will return false.
     */
    inline void clearWants();

    /**
     * Checks whether the field "Wants" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWants()). Otherwise it will return false.
     */
    inline bool hasWants () const;

    /**
     * Returns the value of the member "Wants".
     *
     * Wants
     *
     * @return The value of the field "Wants"
     */
    inline const ::std::vector< ::std::string >& getWants () const;

    /**
     * Retrieves the value of the field "Wants" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Wants".
     */
    inline ::std::vector< ::std::string >& getWantsMutable ();

    /**
     * Sets the value of the member "Wants".
     *
     * Wants
     *
     * @param Wants The value which will be set
     */
    inline void setWants (const ::std::vector< ::std::string >& Wants_);

    static const WantsUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_Wants ();

    inline void clear_has_Wants ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _Wants;

};

/**
 * Wants
 */
class WantsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WantsRegister ();

    /**
     * Copy constructor
     */
    inline  WantsRegister (const WantsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WantsRegister();

    /**
     * Assignment operator
     */
    inline WantsRegister& operator = (const WantsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WantsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WantsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WantsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WantsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WantsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * BindsTo
 */
class BindsToUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BindsToUpdate ();

    /**
     * Copy constructor
     */
    inline  BindsToUpdate (const BindsToUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BindsToUpdate (const ::std::vector< ::std::string >& BindsTo_);

    /**
     * Destructor
     */
    inline virtual  ~BindsToUpdate();

    /**
     * Assignment operator
     */
    inline BindsToUpdate& operator = (const BindsToUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BindsToUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BindsToUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BindsToUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BindsToUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BindsTo"

    static const int kBindsTo = 0;

    /**
     * Clears the field "BindsTo".
     *
     * The field will be set to its default value. The hasBindsTo()
     * method will return false.
     */
    inline void clearBindsTo();

    /**
     * Checks whether the field "BindsTo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBindsTo()). Otherwise it will return false.
     */
    inline bool hasBindsTo () const;

    /**
     * Returns the value of the member "BindsTo".
     *
     * BindsTo
     *
     * @return The value of the field "BindsTo"
     */
    inline const ::std::vector< ::std::string >& getBindsTo () const;

    /**
     * Retrieves the value of the field "BindsTo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BindsTo".
     */
    inline ::std::vector< ::std::string >& getBindsToMutable ();

    /**
     * Sets the value of the member "BindsTo".
     *
     * BindsTo
     *
     * @param BindsTo The value which will be set
     */
    inline void setBindsTo (const ::std::vector< ::std::string >& BindsTo_);

    static const BindsToUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_BindsTo ();

    inline void clear_has_BindsTo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _BindsTo;

};

/**
 * BindsTo
 */
class BindsToRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BindsToRegister ();

    /**
     * Copy constructor
     */
    inline  BindsToRegister (const BindsToRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BindsToRegister();

    /**
     * Assignment operator
     */
    inline BindsToRegister& operator = (const BindsToRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BindsToRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BindsToRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BindsToRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BindsToRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BindsToRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * PartOf
 */
class PartOfUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PartOfUpdate ();

    /**
     * Copy constructor
     */
    inline  PartOfUpdate (const PartOfUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PartOfUpdate (const ::std::vector< ::std::string >& PartOf_);

    /**
     * Destructor
     */
    inline virtual  ~PartOfUpdate();

    /**
     * Assignment operator
     */
    inline PartOfUpdate& operator = (const PartOfUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PartOfUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PartOfUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PartOfUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PartOfUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PartOf"

    static const int kPartOf = 0;

    /**
     * Clears the field "PartOf".
     *
     * The field will be set to its default value. The hasPartOf()
     * method will return false.
     */
    inline void clearPartOf();

    /**
     * Checks whether the field "PartOf" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPartOf()). Otherwise it will return false.
     */
    inline bool hasPartOf () const;

    /**
     * Returns the value of the member "PartOf".
     *
     * PartOf
     *
     * @return The value of the field "PartOf"
     */
    inline const ::std::vector< ::std::string >& getPartOf () const;

    /**
     * Retrieves the value of the field "PartOf" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PartOf".
     */
    inline ::std::vector< ::std::string >& getPartOfMutable ();

    /**
     * Sets the value of the member "PartOf".
     *
     * PartOf
     *
     * @param PartOf The value which will be set
     */
    inline void setPartOf (const ::std::vector< ::std::string >& PartOf_);

    static const PartOfUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_PartOf ();

    inline void clear_has_PartOf ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _PartOf;

};

/**
 * PartOf
 */
class PartOfRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PartOfRegister ();

    /**
     * Copy constructor
     */
    inline  PartOfRegister (const PartOfRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PartOfRegister();

    /**
     * Assignment operator
     */
    inline PartOfRegister& operator = (const PartOfRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PartOfRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PartOfRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PartOfRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PartOfRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PartOfRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * RequiredBy
 */
class RequiredByUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequiredByUpdate ();

    /**
     * Copy constructor
     */
    inline  RequiredByUpdate (const RequiredByUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RequiredByUpdate (const ::std::vector< ::std::string >& RequiredBy_);

    /**
     * Destructor
     */
    inline virtual  ~RequiredByUpdate();

    /**
     * Assignment operator
     */
    inline RequiredByUpdate& operator = (const RequiredByUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequiredByUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequiredByUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequiredByUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequiredByUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RequiredBy"

    static const int kRequiredBy = 0;

    /**
     * Clears the field "RequiredBy".
     *
     * The field will be set to its default value. The hasRequiredBy()
     * method will return false.
     */
    inline void clearRequiredBy();

    /**
     * Checks whether the field "RequiredBy" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequiredBy()). Otherwise it will return false.
     */
    inline bool hasRequiredBy () const;

    /**
     * Returns the value of the member "RequiredBy".
     *
     * RequiredBy
     *
     * @return The value of the field "RequiredBy"
     */
    inline const ::std::vector< ::std::string >& getRequiredBy () const;

    /**
     * Retrieves the value of the field "RequiredBy" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RequiredBy".
     */
    inline ::std::vector< ::std::string >& getRequiredByMutable ();

    /**
     * Sets the value of the member "RequiredBy".
     *
     * RequiredBy
     *
     * @param RequiredBy The value which will be set
     */
    inline void setRequiredBy (const ::std::vector< ::std::string >& RequiredBy_);

    static const RequiredByUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_RequiredBy ();

    inline void clear_has_RequiredBy ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _RequiredBy;

};

/**
 * RequiredBy
 */
class RequiredByRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequiredByRegister ();

    /**
     * Copy constructor
     */
    inline  RequiredByRegister (const RequiredByRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RequiredByRegister();

    /**
     * Assignment operator
     */
    inline RequiredByRegister& operator = (const RequiredByRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequiredByRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequiredByRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequiredByRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequiredByRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RequiredByRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * RequiredByOverridable
 */
class RequiredByOverridableUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequiredByOverridableUpdate ();

    /**
     * Copy constructor
     */
    inline  RequiredByOverridableUpdate (const RequiredByOverridableUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RequiredByOverridableUpdate (const ::std::vector< ::std::string >& RequiredByOverridable_);

    /**
     * Destructor
     */
    inline virtual  ~RequiredByOverridableUpdate();

    /**
     * Assignment operator
     */
    inline RequiredByOverridableUpdate& operator = (const RequiredByOverridableUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequiredByOverridableUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequiredByOverridableUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequiredByOverridableUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequiredByOverridableUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RequiredByOverridable"

    static const int kRequiredByOverridable = 0;

    /**
     * Clears the field "RequiredByOverridable".
     *
     * The field will be set to its default value. The hasRequiredByOverridable()
     * method will return false.
     */
    inline void clearRequiredByOverridable();

    /**
     * Checks whether the field "RequiredByOverridable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequiredByOverridable()). Otherwise it will return false.
     */
    inline bool hasRequiredByOverridable () const;

    /**
     * Returns the value of the member "RequiredByOverridable".
     *
     * RequiredByOverridable
     *
     * @return The value of the field "RequiredByOverridable"
     */
    inline const ::std::vector< ::std::string >& getRequiredByOverridable () const;

    /**
     * Retrieves the value of the field "RequiredByOverridable" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RequiredByOverridable".
     */
    inline ::std::vector< ::std::string >& getRequiredByOverridableMutable ();

    /**
     * Sets the value of the member "RequiredByOverridable".
     *
     * RequiredByOverridable
     *
     * @param RequiredByOverridable The value which will be set
     */
    inline void setRequiredByOverridable (const ::std::vector< ::std::string >& RequiredByOverridable_);

    static const RequiredByOverridableUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_RequiredByOverridable ();

    inline void clear_has_RequiredByOverridable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _RequiredByOverridable;

};

/**
 * RequiredByOverridable
 */
class RequiredByOverridableRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequiredByOverridableRegister ();

    /**
     * Copy constructor
     */
    inline  RequiredByOverridableRegister (const RequiredByOverridableRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RequiredByOverridableRegister();

    /**
     * Assignment operator
     */
    inline RequiredByOverridableRegister& operator = (const RequiredByOverridableRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequiredByOverridableRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequiredByOverridableRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequiredByOverridableRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequiredByOverridableRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RequiredByOverridableRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * RequisiteOf
 */
class RequisiteOfUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequisiteOfUpdate ();

    /**
     * Copy constructor
     */
    inline  RequisiteOfUpdate (const RequisiteOfUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RequisiteOfUpdate (const ::std::vector< ::std::string >& RequisiteOf_);

    /**
     * Destructor
     */
    inline virtual  ~RequisiteOfUpdate();

    /**
     * Assignment operator
     */
    inline RequisiteOfUpdate& operator = (const RequisiteOfUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequisiteOfUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequisiteOfUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequisiteOfUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequisiteOfUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RequisiteOf"

    static const int kRequisiteOf = 0;

    /**
     * Clears the field "RequisiteOf".
     *
     * The field will be set to its default value. The hasRequisiteOf()
     * method will return false.
     */
    inline void clearRequisiteOf();

    /**
     * Checks whether the field "RequisiteOf" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequisiteOf()). Otherwise it will return false.
     */
    inline bool hasRequisiteOf () const;

    /**
     * Returns the value of the member "RequisiteOf".
     *
     * RequisiteOf
     *
     * @return The value of the field "RequisiteOf"
     */
    inline const ::std::vector< ::std::string >& getRequisiteOf () const;

    /**
     * Retrieves the value of the field "RequisiteOf" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RequisiteOf".
     */
    inline ::std::vector< ::std::string >& getRequisiteOfMutable ();

    /**
     * Sets the value of the member "RequisiteOf".
     *
     * RequisiteOf
     *
     * @param RequisiteOf The value which will be set
     */
    inline void setRequisiteOf (const ::std::vector< ::std::string >& RequisiteOf_);

    static const RequisiteOfUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_RequisiteOf ();

    inline void clear_has_RequisiteOf ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _RequisiteOf;

};

/**
 * RequisiteOf
 */
class RequisiteOfRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequisiteOfRegister ();

    /**
     * Copy constructor
     */
    inline  RequisiteOfRegister (const RequisiteOfRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RequisiteOfRegister();

    /**
     * Assignment operator
     */
    inline RequisiteOfRegister& operator = (const RequisiteOfRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequisiteOfRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequisiteOfRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequisiteOfRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequisiteOfRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RequisiteOfRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * RequisiteOfOverridable
 */
class RequisiteOfOverridableUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequisiteOfOverridableUpdate ();

    /**
     * Copy constructor
     */
    inline  RequisiteOfOverridableUpdate (const RequisiteOfOverridableUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RequisiteOfOverridableUpdate (const ::std::vector< ::std::string >& RequisiteOfOverridable_);

    /**
     * Destructor
     */
    inline virtual  ~RequisiteOfOverridableUpdate();

    /**
     * Assignment operator
     */
    inline RequisiteOfOverridableUpdate& operator = (const RequisiteOfOverridableUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequisiteOfOverridableUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequisiteOfOverridableUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequisiteOfOverridableUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequisiteOfOverridableUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RequisiteOfOverridable"

    static const int kRequisiteOfOverridable = 0;

    /**
     * Clears the field "RequisiteOfOverridable".
     *
     * The field will be set to its default value. The hasRequisiteOfOverridable()
     * method will return false.
     */
    inline void clearRequisiteOfOverridable();

    /**
     * Checks whether the field "RequisiteOfOverridable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequisiteOfOverridable()). Otherwise it will return false.
     */
    inline bool hasRequisiteOfOverridable () const;

    /**
     * Returns the value of the member "RequisiteOfOverridable".
     *
     * RequisiteOfOverridable
     *
     * @return The value of the field "RequisiteOfOverridable"
     */
    inline const ::std::vector< ::std::string >& getRequisiteOfOverridable () const;

    /**
     * Retrieves the value of the field "RequisiteOfOverridable" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RequisiteOfOverridable".
     */
    inline ::std::vector< ::std::string >& getRequisiteOfOverridableMutable ();

    /**
     * Sets the value of the member "RequisiteOfOverridable".
     *
     * RequisiteOfOverridable
     *
     * @param RequisiteOfOverridable The value which will be set
     */
    inline void setRequisiteOfOverridable (const ::std::vector< ::std::string >& RequisiteOfOverridable_);

    static const RequisiteOfOverridableUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_RequisiteOfOverridable ();

    inline void clear_has_RequisiteOfOverridable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _RequisiteOfOverridable;

};

/**
 * RequisiteOfOverridable
 */
class RequisiteOfOverridableRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequisiteOfOverridableRegister ();

    /**
     * Copy constructor
     */
    inline  RequisiteOfOverridableRegister (const RequisiteOfOverridableRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RequisiteOfOverridableRegister();

    /**
     * Assignment operator
     */
    inline RequisiteOfOverridableRegister& operator = (const RequisiteOfOverridableRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequisiteOfOverridableRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequisiteOfOverridableRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequisiteOfOverridableRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequisiteOfOverridableRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RequisiteOfOverridableRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * WantedBy
 */
class WantedByUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WantedByUpdate ();

    /**
     * Copy constructor
     */
    inline  WantedByUpdate (const WantedByUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WantedByUpdate (const ::std::vector< ::std::string >& WantedBy_);

    /**
     * Destructor
     */
    inline virtual  ~WantedByUpdate();

    /**
     * Assignment operator
     */
    inline WantedByUpdate& operator = (const WantedByUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WantedByUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WantedByUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WantedByUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WantedByUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WantedBy"

    static const int kWantedBy = 0;

    /**
     * Clears the field "WantedBy".
     *
     * The field will be set to its default value. The hasWantedBy()
     * method will return false.
     */
    inline void clearWantedBy();

    /**
     * Checks whether the field "WantedBy" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWantedBy()). Otherwise it will return false.
     */
    inline bool hasWantedBy () const;

    /**
     * Returns the value of the member "WantedBy".
     *
     * WantedBy
     *
     * @return The value of the field "WantedBy"
     */
    inline const ::std::vector< ::std::string >& getWantedBy () const;

    /**
     * Retrieves the value of the field "WantedBy" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WantedBy".
     */
    inline ::std::vector< ::std::string >& getWantedByMutable ();

    /**
     * Sets the value of the member "WantedBy".
     *
     * WantedBy
     *
     * @param WantedBy The value which will be set
     */
    inline void setWantedBy (const ::std::vector< ::std::string >& WantedBy_);

    static const WantedByUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_WantedBy ();

    inline void clear_has_WantedBy ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _WantedBy;

};

/**
 * WantedBy
 */
class WantedByRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WantedByRegister ();

    /**
     * Copy constructor
     */
    inline  WantedByRegister (const WantedByRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WantedByRegister();

    /**
     * Assignment operator
     */
    inline WantedByRegister& operator = (const WantedByRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WantedByRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WantedByRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WantedByRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WantedByRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WantedByRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * BoundBy
 */
class BoundByUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BoundByUpdate ();

    /**
     * Copy constructor
     */
    inline  BoundByUpdate (const BoundByUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BoundByUpdate (const ::std::vector< ::std::string >& BoundBy_);

    /**
     * Destructor
     */
    inline virtual  ~BoundByUpdate();

    /**
     * Assignment operator
     */
    inline BoundByUpdate& operator = (const BoundByUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BoundByUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BoundByUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BoundByUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BoundByUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BoundBy"

    static const int kBoundBy = 0;

    /**
     * Clears the field "BoundBy".
     *
     * The field will be set to its default value. The hasBoundBy()
     * method will return false.
     */
    inline void clearBoundBy();

    /**
     * Checks whether the field "BoundBy" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBoundBy()). Otherwise it will return false.
     */
    inline bool hasBoundBy () const;

    /**
     * Returns the value of the member "BoundBy".
     *
     * BoundBy
     *
     * @return The value of the field "BoundBy"
     */
    inline const ::std::vector< ::std::string >& getBoundBy () const;

    /**
     * Retrieves the value of the field "BoundBy" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BoundBy".
     */
    inline ::std::vector< ::std::string >& getBoundByMutable ();

    /**
     * Sets the value of the member "BoundBy".
     *
     * BoundBy
     *
     * @param BoundBy The value which will be set
     */
    inline void setBoundBy (const ::std::vector< ::std::string >& BoundBy_);

    static const BoundByUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_BoundBy ();

    inline void clear_has_BoundBy ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _BoundBy;

};

/**
 * BoundBy
 */
class BoundByRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BoundByRegister ();

    /**
     * Copy constructor
     */
    inline  BoundByRegister (const BoundByRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BoundByRegister();

    /**
     * Assignment operator
     */
    inline BoundByRegister& operator = (const BoundByRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BoundByRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BoundByRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BoundByRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BoundByRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BoundByRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ConsistsOf
 */
class ConsistsOfUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConsistsOfUpdate ();

    /**
     * Copy constructor
     */
    inline  ConsistsOfUpdate (const ConsistsOfUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConsistsOfUpdate (const ::std::vector< ::std::string >& ConsistsOf_);

    /**
     * Destructor
     */
    inline virtual  ~ConsistsOfUpdate();

    /**
     * Assignment operator
     */
    inline ConsistsOfUpdate& operator = (const ConsistsOfUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConsistsOfUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConsistsOfUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConsistsOfUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConsistsOfUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConsistsOf"

    static const int kConsistsOf = 0;

    /**
     * Clears the field "ConsistsOf".
     *
     * The field will be set to its default value. The hasConsistsOf()
     * method will return false.
     */
    inline void clearConsistsOf();

    /**
     * Checks whether the field "ConsistsOf" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConsistsOf()). Otherwise it will return false.
     */
    inline bool hasConsistsOf () const;

    /**
     * Returns the value of the member "ConsistsOf".
     *
     * ConsistsOf
     *
     * @return The value of the field "ConsistsOf"
     */
    inline const ::std::vector< ::std::string >& getConsistsOf () const;

    /**
     * Retrieves the value of the field "ConsistsOf" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ConsistsOf".
     */
    inline ::std::vector< ::std::string >& getConsistsOfMutable ();

    /**
     * Sets the value of the member "ConsistsOf".
     *
     * ConsistsOf
     *
     * @param ConsistsOf The value which will be set
     */
    inline void setConsistsOf (const ::std::vector< ::std::string >& ConsistsOf_);

    static const ConsistsOfUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_ConsistsOf ();

    inline void clear_has_ConsistsOf ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _ConsistsOf;

};

/**
 * ConsistsOf
 */
class ConsistsOfRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConsistsOfRegister ();

    /**
     * Copy constructor
     */
    inline  ConsistsOfRegister (const ConsistsOfRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConsistsOfRegister();

    /**
     * Assignment operator
     */
    inline ConsistsOfRegister& operator = (const ConsistsOfRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConsistsOfRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConsistsOfRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConsistsOfRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConsistsOfRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConsistsOfRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Conflicts
 */
class ConflictsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConflictsUpdate ();

    /**
     * Copy constructor
     */
    inline  ConflictsUpdate (const ConflictsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConflictsUpdate (const ::std::vector< ::std::string >& Conflicts_);

    /**
     * Destructor
     */
    inline virtual  ~ConflictsUpdate();

    /**
     * Assignment operator
     */
    inline ConflictsUpdate& operator = (const ConflictsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConflictsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConflictsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConflictsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConflictsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Conflicts"

    static const int kConflicts = 0;

    /**
     * Clears the field "Conflicts".
     *
     * The field will be set to its default value. The hasConflicts()
     * method will return false.
     */
    inline void clearConflicts();

    /**
     * Checks whether the field "Conflicts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConflicts()). Otherwise it will return false.
     */
    inline bool hasConflicts () const;

    /**
     * Returns the value of the member "Conflicts".
     *
     * Conflicts
     *
     * @return The value of the field "Conflicts"
     */
    inline const ::std::vector< ::std::string >& getConflicts () const;

    /**
     * Retrieves the value of the field "Conflicts" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Conflicts".
     */
    inline ::std::vector< ::std::string >& getConflictsMutable ();

    /**
     * Sets the value of the member "Conflicts".
     *
     * Conflicts
     *
     * @param Conflicts The value which will be set
     */
    inline void setConflicts (const ::std::vector< ::std::string >& Conflicts_);

    static const ConflictsUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_Conflicts ();

    inline void clear_has_Conflicts ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _Conflicts;

};

/**
 * Conflicts
 */
class ConflictsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConflictsRegister ();

    /**
     * Copy constructor
     */
    inline  ConflictsRegister (const ConflictsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConflictsRegister();

    /**
     * Assignment operator
     */
    inline ConflictsRegister& operator = (const ConflictsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConflictsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConflictsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConflictsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConflictsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConflictsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ConflictedBy
 */
class ConflictedByUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConflictedByUpdate ();

    /**
     * Copy constructor
     */
    inline  ConflictedByUpdate (const ConflictedByUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConflictedByUpdate (const ::std::vector< ::std::string >& ConflictedBy_);

    /**
     * Destructor
     */
    inline virtual  ~ConflictedByUpdate();

    /**
     * Assignment operator
     */
    inline ConflictedByUpdate& operator = (const ConflictedByUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConflictedByUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConflictedByUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConflictedByUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConflictedByUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConflictedBy"

    static const int kConflictedBy = 0;

    /**
     * Clears the field "ConflictedBy".
     *
     * The field will be set to its default value. The hasConflictedBy()
     * method will return false.
     */
    inline void clearConflictedBy();

    /**
     * Checks whether the field "ConflictedBy" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConflictedBy()). Otherwise it will return false.
     */
    inline bool hasConflictedBy () const;

    /**
     * Returns the value of the member "ConflictedBy".
     *
     * ConflictedBy
     *
     * @return The value of the field "ConflictedBy"
     */
    inline const ::std::vector< ::std::string >& getConflictedBy () const;

    /**
     * Retrieves the value of the field "ConflictedBy" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ConflictedBy".
     */
    inline ::std::vector< ::std::string >& getConflictedByMutable ();

    /**
     * Sets the value of the member "ConflictedBy".
     *
     * ConflictedBy
     *
     * @param ConflictedBy The value which will be set
     */
    inline void setConflictedBy (const ::std::vector< ::std::string >& ConflictedBy_);

    static const ConflictedByUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_ConflictedBy ();

    inline void clear_has_ConflictedBy ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _ConflictedBy;

};

/**
 * ConflictedBy
 */
class ConflictedByRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConflictedByRegister ();

    /**
     * Copy constructor
     */
    inline  ConflictedByRegister (const ConflictedByRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConflictedByRegister();

    /**
     * Assignment operator
     */
    inline ConflictedByRegister& operator = (const ConflictedByRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConflictedByRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConflictedByRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConflictedByRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConflictedByRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConflictedByRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Before
 */
class BeforeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeforeUpdate ();

    /**
     * Copy constructor
     */
    inline  BeforeUpdate (const BeforeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BeforeUpdate (const ::std::vector< ::std::string >& Before_);

    /**
     * Destructor
     */
    inline virtual  ~BeforeUpdate();

    /**
     * Assignment operator
     */
    inline BeforeUpdate& operator = (const BeforeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeforeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeforeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeforeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeforeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Before"

    static const int kBefore = 0;

    /**
     * Clears the field "Before".
     *
     * The field will be set to its default value. The hasBefore()
     * method will return false.
     */
    inline void clearBefore();

    /**
     * Checks whether the field "Before" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBefore()). Otherwise it will return false.
     */
    inline bool hasBefore () const;

    /**
     * Returns the value of the member "Before".
     *
     * Before
     *
     * @return The value of the field "Before"
     */
    inline const ::std::vector< ::std::string >& getBefore () const;

    /**
     * Retrieves the value of the field "Before" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Before".
     */
    inline ::std::vector< ::std::string >& getBeforeMutable ();

    /**
     * Sets the value of the member "Before".
     *
     * Before
     *
     * @param Before The value which will be set
     */
    inline void setBefore (const ::std::vector< ::std::string >& Before_);

    static const BeforeUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_Before ();

    inline void clear_has_Before ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _Before;

};

/**
 * Before
 */
class BeforeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeforeRegister ();

    /**
     * Copy constructor
     */
    inline  BeforeRegister (const BeforeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BeforeRegister();

    /**
     * Assignment operator
     */
    inline BeforeRegister& operator = (const BeforeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeforeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeforeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeforeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeforeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BeforeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * After
 */
class AfterUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AfterUpdate ();

    /**
     * Copy constructor
     */
    inline  AfterUpdate (const AfterUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AfterUpdate (const ::std::vector< ::std::string >& After_);

    /**
     * Destructor
     */
    inline virtual  ~AfterUpdate();

    /**
     * Assignment operator
     */
    inline AfterUpdate& operator = (const AfterUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AfterUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AfterUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AfterUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AfterUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "After"

    static const int kAfter = 0;

    /**
     * Clears the field "After".
     *
     * The field will be set to its default value. The hasAfter()
     * method will return false.
     */
    inline void clearAfter();

    /**
     * Checks whether the field "After" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAfter()). Otherwise it will return false.
     */
    inline bool hasAfter () const;

    /**
     * Returns the value of the member "After".
     *
     * After
     *
     * @return The value of the field "After"
     */
    inline const ::std::vector< ::std::string >& getAfter () const;

    /**
     * Retrieves the value of the field "After" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "After".
     */
    inline ::std::vector< ::std::string >& getAfterMutable ();

    /**
     * Sets the value of the member "After".
     *
     * After
     *
     * @param After The value which will be set
     */
    inline void setAfter (const ::std::vector< ::std::string >& After_);

    static const AfterUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_After ();

    inline void clear_has_After ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _After;

};

/**
 * After
 */
class AfterRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AfterRegister ();

    /**
     * Copy constructor
     */
    inline  AfterRegister (const AfterRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AfterRegister();

    /**
     * Assignment operator
     */
    inline AfterRegister& operator = (const AfterRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AfterRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AfterRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AfterRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AfterRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AfterRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * OnFailure
 */
class OnFailureUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnFailureUpdate ();

    /**
     * Copy constructor
     */
    inline  OnFailureUpdate (const OnFailureUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  OnFailureUpdate (const ::std::vector< ::std::string >& OnFailure_);

    /**
     * Destructor
     */
    inline virtual  ~OnFailureUpdate();

    /**
     * Assignment operator
     */
    inline OnFailureUpdate& operator = (const OnFailureUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnFailureUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnFailureUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnFailureUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnFailureUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OnFailure"

    static const int kOnFailure = 0;

    /**
     * Clears the field "OnFailure".
     *
     * The field will be set to its default value. The hasOnFailure()
     * method will return false.
     */
    inline void clearOnFailure();

    /**
     * Checks whether the field "OnFailure" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOnFailure()). Otherwise it will return false.
     */
    inline bool hasOnFailure () const;

    /**
     * Returns the value of the member "OnFailure".
     *
     * OnFailure
     *
     * @return The value of the field "OnFailure"
     */
    inline const ::std::vector< ::std::string >& getOnFailure () const;

    /**
     * Retrieves the value of the field "OnFailure" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OnFailure".
     */
    inline ::std::vector< ::std::string >& getOnFailureMutable ();

    /**
     * Sets the value of the member "OnFailure".
     *
     * OnFailure
     *
     * @param OnFailure The value which will be set
     */
    inline void setOnFailure (const ::std::vector< ::std::string >& OnFailure_);

    static const OnFailureUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_OnFailure ();

    inline void clear_has_OnFailure ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _OnFailure;

};

/**
 * OnFailure
 */
class OnFailureRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnFailureRegister ();

    /**
     * Copy constructor
     */
    inline  OnFailureRegister (const OnFailureRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~OnFailureRegister();

    /**
     * Assignment operator
     */
    inline OnFailureRegister& operator = (const OnFailureRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnFailureRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnFailureRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnFailureRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnFailureRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const OnFailureRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Triggers
 */
class TriggersUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TriggersUpdate ();

    /**
     * Copy constructor
     */
    inline  TriggersUpdate (const TriggersUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TriggersUpdate (const ::std::vector< ::std::string >& Triggers_);

    /**
     * Destructor
     */
    inline virtual  ~TriggersUpdate();

    /**
     * Assignment operator
     */
    inline TriggersUpdate& operator = (const TriggersUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TriggersUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TriggersUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TriggersUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TriggersUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Triggers"

    static const int kTriggers = 0;

    /**
     * Clears the field "Triggers".
     *
     * The field will be set to its default value. The hasTriggers()
     * method will return false.
     */
    inline void clearTriggers();

    /**
     * Checks whether the field "Triggers" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTriggers()). Otherwise it will return false.
     */
    inline bool hasTriggers () const;

    /**
     * Returns the value of the member "Triggers".
     *
     * Triggers
     *
     * @return The value of the field "Triggers"
     */
    inline const ::std::vector< ::std::string >& getTriggers () const;

    /**
     * Retrieves the value of the field "Triggers" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Triggers".
     */
    inline ::std::vector< ::std::string >& getTriggersMutable ();

    /**
     * Sets the value of the member "Triggers".
     *
     * Triggers
     *
     * @param Triggers The value which will be set
     */
    inline void setTriggers (const ::std::vector< ::std::string >& Triggers_);

    static const TriggersUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_Triggers ();

    inline void clear_has_Triggers ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _Triggers;

};

/**
 * Triggers
 */
class TriggersRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TriggersRegister ();

    /**
     * Copy constructor
     */
    inline  TriggersRegister (const TriggersRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TriggersRegister();

    /**
     * Assignment operator
     */
    inline TriggersRegister& operator = (const TriggersRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TriggersRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TriggersRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TriggersRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TriggersRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TriggersRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * TriggeredBy
 */
class TriggeredByUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TriggeredByUpdate ();

    /**
     * Copy constructor
     */
    inline  TriggeredByUpdate (const TriggeredByUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TriggeredByUpdate (const ::std::vector< ::std::string >& TriggeredBy_);

    /**
     * Destructor
     */
    inline virtual  ~TriggeredByUpdate();

    /**
     * Assignment operator
     */
    inline TriggeredByUpdate& operator = (const TriggeredByUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TriggeredByUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TriggeredByUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TriggeredByUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TriggeredByUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TriggeredBy"

    static const int kTriggeredBy = 0;

    /**
     * Clears the field "TriggeredBy".
     *
     * The field will be set to its default value. The hasTriggeredBy()
     * method will return false.
     */
    inline void clearTriggeredBy();

    /**
     * Checks whether the field "TriggeredBy" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTriggeredBy()). Otherwise it will return false.
     */
    inline bool hasTriggeredBy () const;

    /**
     * Returns the value of the member "TriggeredBy".
     *
     * TriggeredBy
     *
     * @return The value of the field "TriggeredBy"
     */
    inline const ::std::vector< ::std::string >& getTriggeredBy () const;

    /**
     * Retrieves the value of the field "TriggeredBy" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TriggeredBy".
     */
    inline ::std::vector< ::std::string >& getTriggeredByMutable ();

    /**
     * Sets the value of the member "TriggeredBy".
     *
     * TriggeredBy
     *
     * @param TriggeredBy The value which will be set
     */
    inline void setTriggeredBy (const ::std::vector< ::std::string >& TriggeredBy_);

    static const TriggeredByUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_TriggeredBy ();

    inline void clear_has_TriggeredBy ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _TriggeredBy;

};

/**
 * TriggeredBy
 */
class TriggeredByRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TriggeredByRegister ();

    /**
     * Copy constructor
     */
    inline  TriggeredByRegister (const TriggeredByRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TriggeredByRegister();

    /**
     * Assignment operator
     */
    inline TriggeredByRegister& operator = (const TriggeredByRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TriggeredByRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TriggeredByRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TriggeredByRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TriggeredByRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TriggeredByRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * PropagatesReloadTo
 */
class PropagatesReloadToUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PropagatesReloadToUpdate ();

    /**
     * Copy constructor
     */
    inline  PropagatesReloadToUpdate (const PropagatesReloadToUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PropagatesReloadToUpdate (const ::std::vector< ::std::string >& PropagatesReloadTo_);

    /**
     * Destructor
     */
    inline virtual  ~PropagatesReloadToUpdate();

    /**
     * Assignment operator
     */
    inline PropagatesReloadToUpdate& operator = (const PropagatesReloadToUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PropagatesReloadToUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PropagatesReloadToUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PropagatesReloadToUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PropagatesReloadToUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PropagatesReloadTo"

    static const int kPropagatesReloadTo = 0;

    /**
     * Clears the field "PropagatesReloadTo".
     *
     * The field will be set to its default value. The hasPropagatesReloadTo()
     * method will return false.
     */
    inline void clearPropagatesReloadTo();

    /**
     * Checks whether the field "PropagatesReloadTo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPropagatesReloadTo()). Otherwise it will return false.
     */
    inline bool hasPropagatesReloadTo () const;

    /**
     * Returns the value of the member "PropagatesReloadTo".
     *
     * PropagatesReloadTo
     *
     * @return The value of the field "PropagatesReloadTo"
     */
    inline const ::std::vector< ::std::string >& getPropagatesReloadTo () const;

    /**
     * Retrieves the value of the field "PropagatesReloadTo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PropagatesReloadTo".
     */
    inline ::std::vector< ::std::string >& getPropagatesReloadToMutable ();

    /**
     * Sets the value of the member "PropagatesReloadTo".
     *
     * PropagatesReloadTo
     *
     * @param PropagatesReloadTo The value which will be set
     */
    inline void setPropagatesReloadTo (const ::std::vector< ::std::string >& PropagatesReloadTo_);

    static const PropagatesReloadToUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_PropagatesReloadTo ();

    inline void clear_has_PropagatesReloadTo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _PropagatesReloadTo;

};

/**
 * PropagatesReloadTo
 */
class PropagatesReloadToRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PropagatesReloadToRegister ();

    /**
     * Copy constructor
     */
    inline  PropagatesReloadToRegister (const PropagatesReloadToRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PropagatesReloadToRegister();

    /**
     * Assignment operator
     */
    inline PropagatesReloadToRegister& operator = (const PropagatesReloadToRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PropagatesReloadToRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PropagatesReloadToRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PropagatesReloadToRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PropagatesReloadToRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PropagatesReloadToRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ReloadPropagatedFrom
 */
class ReloadPropagatedFromUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadPropagatedFromUpdate ();

    /**
     * Copy constructor
     */
    inline  ReloadPropagatedFromUpdate (const ReloadPropagatedFromUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadPropagatedFromUpdate (const ::std::vector< ::std::string >& ReloadPropagatedFrom_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadPropagatedFromUpdate();

    /**
     * Assignment operator
     */
    inline ReloadPropagatedFromUpdate& operator = (const ReloadPropagatedFromUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadPropagatedFromUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadPropagatedFromUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadPropagatedFromUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadPropagatedFromUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ReloadPropagatedFrom"

    static const int kReloadPropagatedFrom = 0;

    /**
     * Clears the field "ReloadPropagatedFrom".
     *
     * The field will be set to its default value. The hasReloadPropagatedFrom()
     * method will return false.
     */
    inline void clearReloadPropagatedFrom();

    /**
     * Checks whether the field "ReloadPropagatedFrom" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReloadPropagatedFrom()). Otherwise it will return false.
     */
    inline bool hasReloadPropagatedFrom () const;

    /**
     * Returns the value of the member "ReloadPropagatedFrom".
     *
     * ReloadPropagatedFrom
     *
     * @return The value of the field "ReloadPropagatedFrom"
     */
    inline const ::std::vector< ::std::string >& getReloadPropagatedFrom () const;

    /**
     * Retrieves the value of the field "ReloadPropagatedFrom" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReloadPropagatedFrom".
     */
    inline ::std::vector< ::std::string >& getReloadPropagatedFromMutable ();

    /**
     * Sets the value of the member "ReloadPropagatedFrom".
     *
     * ReloadPropagatedFrom
     *
     * @param ReloadPropagatedFrom The value which will be set
     */
    inline void setReloadPropagatedFrom (const ::std::vector< ::std::string >& ReloadPropagatedFrom_);

    static const ReloadPropagatedFromUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_ReloadPropagatedFrom ();

    inline void clear_has_ReloadPropagatedFrom ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _ReloadPropagatedFrom;

};

/**
 * ReloadPropagatedFrom
 */
class ReloadPropagatedFromRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadPropagatedFromRegister ();

    /**
     * Copy constructor
     */
    inline  ReloadPropagatedFromRegister (const ReloadPropagatedFromRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ReloadPropagatedFromRegister();

    /**
     * Assignment operator
     */
    inline ReloadPropagatedFromRegister& operator = (const ReloadPropagatedFromRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadPropagatedFromRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadPropagatedFromRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadPropagatedFromRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadPropagatedFromRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ReloadPropagatedFromRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * JoinsNamespaceOf
 */
class JoinsNamespaceOfUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JoinsNamespaceOfUpdate ();

    /**
     * Copy constructor
     */
    inline  JoinsNamespaceOfUpdate (const JoinsNamespaceOfUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  JoinsNamespaceOfUpdate (const ::std::vector< ::std::string >& JoinsNamespaceOf_);

    /**
     * Destructor
     */
    inline virtual  ~JoinsNamespaceOfUpdate();

    /**
     * Assignment operator
     */
    inline JoinsNamespaceOfUpdate& operator = (const JoinsNamespaceOfUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JoinsNamespaceOfUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JoinsNamespaceOfUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JoinsNamespaceOfUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JoinsNamespaceOfUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JoinsNamespaceOf"

    static const int kJoinsNamespaceOf = 0;

    /**
     * Clears the field "JoinsNamespaceOf".
     *
     * The field will be set to its default value. The hasJoinsNamespaceOf()
     * method will return false.
     */
    inline void clearJoinsNamespaceOf();

    /**
     * Checks whether the field "JoinsNamespaceOf" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJoinsNamespaceOf()). Otherwise it will return false.
     */
    inline bool hasJoinsNamespaceOf () const;

    /**
     * Returns the value of the member "JoinsNamespaceOf".
     *
     * JoinsNamespaceOf
     *
     * @return The value of the field "JoinsNamespaceOf"
     */
    inline const ::std::vector< ::std::string >& getJoinsNamespaceOf () const;

    /**
     * Retrieves the value of the field "JoinsNamespaceOf" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JoinsNamespaceOf".
     */
    inline ::std::vector< ::std::string >& getJoinsNamespaceOfMutable ();

    /**
     * Sets the value of the member "JoinsNamespaceOf".
     *
     * JoinsNamespaceOf
     *
     * @param JoinsNamespaceOf The value which will be set
     */
    inline void setJoinsNamespaceOf (const ::std::vector< ::std::string >& JoinsNamespaceOf_);

    static const JoinsNamespaceOfUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_JoinsNamespaceOf ();

    inline void clear_has_JoinsNamespaceOf ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _JoinsNamespaceOf;

};

/**
 * JoinsNamespaceOf
 */
class JoinsNamespaceOfRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JoinsNamespaceOfRegister ();

    /**
     * Copy constructor
     */
    inline  JoinsNamespaceOfRegister (const JoinsNamespaceOfRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~JoinsNamespaceOfRegister();

    /**
     * Assignment operator
     */
    inline JoinsNamespaceOfRegister& operator = (const JoinsNamespaceOfRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JoinsNamespaceOfRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JoinsNamespaceOfRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JoinsNamespaceOfRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JoinsNamespaceOfRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const JoinsNamespaceOfRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * RequiresMountsFor
 */
class RequiresMountsForUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequiresMountsForUpdate ();

    /**
     * Copy constructor
     */
    inline  RequiresMountsForUpdate (const RequiresMountsForUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RequiresMountsForUpdate (const ::std::vector< ::std::string >& RequiresMountsFor_);

    /**
     * Destructor
     */
    inline virtual  ~RequiresMountsForUpdate();

    /**
     * Assignment operator
     */
    inline RequiresMountsForUpdate& operator = (const RequiresMountsForUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequiresMountsForUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequiresMountsForUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequiresMountsForUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequiresMountsForUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RequiresMountsFor"

    static const int kRequiresMountsFor = 0;

    /**
     * Clears the field "RequiresMountsFor".
     *
     * The field will be set to its default value. The hasRequiresMountsFor()
     * method will return false.
     */
    inline void clearRequiresMountsFor();

    /**
     * Checks whether the field "RequiresMountsFor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequiresMountsFor()). Otherwise it will return false.
     */
    inline bool hasRequiresMountsFor () const;

    /**
     * Returns the value of the member "RequiresMountsFor".
     *
     * RequiresMountsFor
     *
     * @return The value of the field "RequiresMountsFor"
     */
    inline const ::std::vector< ::std::string >& getRequiresMountsFor () const;

    /**
     * Retrieves the value of the field "RequiresMountsFor" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RequiresMountsFor".
     */
    inline ::std::vector< ::std::string >& getRequiresMountsForMutable ();

    /**
     * Sets the value of the member "RequiresMountsFor".
     *
     * RequiresMountsFor
     *
     * @param RequiresMountsFor The value which will be set
     */
    inline void setRequiresMountsFor (const ::std::vector< ::std::string >& RequiresMountsFor_);

    static const RequiresMountsForUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_RequiresMountsFor ();

    inline void clear_has_RequiresMountsFor ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _RequiresMountsFor;

};

/**
 * RequiresMountsFor
 */
class RequiresMountsForRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequiresMountsForRegister ();

    /**
     * Copy constructor
     */
    inline  RequiresMountsForRegister (const RequiresMountsForRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RequiresMountsForRegister();

    /**
     * Assignment operator
     */
    inline RequiresMountsForRegister& operator = (const RequiresMountsForRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequiresMountsForRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequiresMountsForRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequiresMountsForRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequiresMountsForRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RequiresMountsForRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Documentation
 */
class DocumentationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DocumentationUpdate ();

    /**
     * Copy constructor
     */
    inline  DocumentationUpdate (const DocumentationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DocumentationUpdate (const ::std::vector< ::std::string >& Documentation_);

    /**
     * Destructor
     */
    inline virtual  ~DocumentationUpdate();

    /**
     * Assignment operator
     */
    inline DocumentationUpdate& operator = (const DocumentationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DocumentationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DocumentationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DocumentationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DocumentationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Documentation"

    static const int kDocumentation = 0;

    /**
     * Clears the field "Documentation".
     *
     * The field will be set to its default value. The hasDocumentation()
     * method will return false.
     */
    inline void clearDocumentation();

    /**
     * Checks whether the field "Documentation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDocumentation()). Otherwise it will return false.
     */
    inline bool hasDocumentation () const;

    /**
     * Returns the value of the member "Documentation".
     *
     * Documentation
     *
     * @return The value of the field "Documentation"
     */
    inline const ::std::vector< ::std::string >& getDocumentation () const;

    /**
     * Retrieves the value of the field "Documentation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Documentation".
     */
    inline ::std::vector< ::std::string >& getDocumentationMutable ();

    /**
     * Sets the value of the member "Documentation".
     *
     * Documentation
     *
     * @param Documentation The value which will be set
     */
    inline void setDocumentation (const ::std::vector< ::std::string >& Documentation_);

    static const DocumentationUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_Documentation ();

    inline void clear_has_Documentation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _Documentation;

};

/**
 * Documentation
 */
class DocumentationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DocumentationRegister ();

    /**
     * Copy constructor
     */
    inline  DocumentationRegister (const DocumentationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DocumentationRegister();

    /**
     * Assignment operator
     */
    inline DocumentationRegister& operator = (const DocumentationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DocumentationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DocumentationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DocumentationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DocumentationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DocumentationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Description contains the human readable description string for the unit.
 */
class DescriptionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DescriptionUpdate ();

    /**
     * Copy constructor
     */
    inline  DescriptionUpdate (const DescriptionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DescriptionUpdate (const ::std::string& Description_);

    /**
     * Destructor
     */
    inline virtual  ~DescriptionUpdate();

    /**
     * Assignment operator
     */
    inline DescriptionUpdate& operator = (const DescriptionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DescriptionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DescriptionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DescriptionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DescriptionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Description"

    static const int kDescription = 0;

    /**
     * Clears the field "Description".
     *
     * The field will be set to its default value. The hasDescription()
     * method will return false.
     */
    inline void clearDescription();

    /**
     * Checks whether the field "Description" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDescription()). Otherwise it will return false.
     */
    inline bool hasDescription () const;

    /**
     * Returns the value of the member "Description".
     *
     * Description contains the human readable description string for the unit.
     *
     * @return The value of the field "Description"
     */
    inline const ::std::string& getDescription () const;

    /**
     * Retrieves the value of the field "Description" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Description".
     */
    inline ::std::string& getDescriptionMutable ();

    /**
     * Sets the value of the member "Description".
     *
     * Description contains the human readable description string for the unit.
     *
     * @param Description The value which will be set
     */
    inline void setDescription (const ::std::string& Description_);

    /**
     * Sets the value of the member "Description".
     *
     * Description contains the human readable description string for the unit.
     *
     * @param Description The value which will be set
     */
    inline void setDescription (const char* Description_);

    /**
     * Sets the value of the member "Description".
     *
     * Description contains the human readable description string for the unit.
     *
     * @param Description The value which will be set
     */
    inline void setDescription (const char* value, size_t size);

    static const DescriptionUpdate &getDefaultInstance();

private:

    inline void set_has_Description ();

    inline void clear_has_Description ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Description;

};

/**
 * Description contains the human readable description string for the unit.
 */
class DescriptionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DescriptionRegister ();

    /**
     * Copy constructor
     */
    inline  DescriptionRegister (const DescriptionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DescriptionRegister();

    /**
     * Assignment operator
     */
    inline DescriptionRegister& operator = (const DescriptionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DescriptionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DescriptionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DescriptionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DescriptionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DescriptionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
 * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
 * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
 * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
 * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
 * 		a time where a unit was already active).
 */
class LoadStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoadStateUpdate ();

    /**
     * Copy constructor
     */
    inline  LoadStateUpdate (const LoadStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  LoadStateUpdate (const ::std::string& LoadState_);

    /**
     * Destructor
     */
    inline virtual  ~LoadStateUpdate();

    /**
     * Assignment operator
     */
    inline LoadStateUpdate& operator = (const LoadStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoadStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoadStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoadStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoadStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LoadState"

    static const int kLoadState = 0;

    /**
     * Clears the field "LoadState".
     *
     * The field will be set to its default value. The hasLoadState()
     * method will return false.
     */
    inline void clearLoadState();

    /**
     * Checks whether the field "LoadState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoadState()). Otherwise it will return false.
     */
    inline bool hasLoadState () const;

    /**
     * Returns the value of the member "LoadState".
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     *
     * @return The value of the field "LoadState"
     */
    inline const ::std::string& getLoadState () const;

    /**
     * Retrieves the value of the field "LoadState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LoadState".
     */
    inline ::std::string& getLoadStateMutable ();

    /**
     * Sets the value of the member "LoadState".
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     *
     * @param LoadState The value which will be set
     */
    inline void setLoadState (const ::std::string& LoadState_);

    /**
     * Sets the value of the member "LoadState".
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     *
     * @param LoadState The value which will be set
     */
    inline void setLoadState (const char* LoadState_);

    /**
     * Sets the value of the member "LoadState".
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     *
     * @param LoadState The value which will be set
     */
    inline void setLoadState (const char* value, size_t size);

    static const LoadStateUpdate &getDefaultInstance();

private:

    inline void set_has_LoadState ();

    inline void clear_has_LoadState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _LoadState;

};

/**
 * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
 * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
 * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
 * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
 * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
 * 		a time where a unit was already active).
 */
class LoadStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoadStateRegister ();

    /**
     * Copy constructor
     */
    inline  LoadStateRegister (const LoadStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~LoadStateRegister();

    /**
     * Assignment operator
     */
    inline LoadStateRegister& operator = (const LoadStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoadStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoadStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoadStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoadStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const LoadStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ActiveState contains a state value that reflects whether the unit is currently active or not.
 * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
 * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
 * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
 * 		failed indicates that it is inactive and the previous run was not successful.
 * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
 * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
 */
class ActiveStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveStateUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveStateUpdate (const ActiveStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveStateUpdate (const ::std::string& ActiveState_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveStateUpdate();

    /**
     * Assignment operator
     */
    inline ActiveStateUpdate& operator = (const ActiveStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActiveState"

    static const int kActiveState = 0;

    /**
     * Clears the field "ActiveState".
     *
     * The field will be set to its default value. The hasActiveState()
     * method will return false.
     */
    inline void clearActiveState();

    /**
     * Checks whether the field "ActiveState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveState()). Otherwise it will return false.
     */
    inline bool hasActiveState () const;

    /**
     * Returns the value of the member "ActiveState".
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     *
     * @return The value of the field "ActiveState"
     */
    inline const ::std::string& getActiveState () const;

    /**
     * Retrieves the value of the field "ActiveState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ActiveState".
     */
    inline ::std::string& getActiveStateMutable ();

    /**
     * Sets the value of the member "ActiveState".
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     *
     * @param ActiveState The value which will be set
     */
    inline void setActiveState (const ::std::string& ActiveState_);

    /**
     * Sets the value of the member "ActiveState".
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     *
     * @param ActiveState The value which will be set
     */
    inline void setActiveState (const char* ActiveState_);

    /**
     * Sets the value of the member "ActiveState".
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     *
     * @param ActiveState The value which will be set
     */
    inline void setActiveState (const char* value, size_t size);

    static const ActiveStateUpdate &getDefaultInstance();

private:

    inline void set_has_ActiveState ();

    inline void clear_has_ActiveState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _ActiveState;

};

/**
 * ActiveState contains a state value that reflects whether the unit is currently active or not.
 * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
 * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
 * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
 * 		failed indicates that it is inactive and the previous run was not successful.
 * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
 * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
 */
class ActiveStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveStateRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveStateRegister (const ActiveStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveStateRegister();

    /**
     * Assignment operator
     */
    inline ActiveStateRegister& operator = (const ActiveStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
 * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
 * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
 * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
 * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
 */
class SubStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubStateUpdate ();

    /**
     * Copy constructor
     */
    inline  SubStateUpdate (const SubStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SubStateUpdate (const ::std::string& SubState_);

    /**
     * Destructor
     */
    inline virtual  ~SubStateUpdate();

    /**
     * Assignment operator
     */
    inline SubStateUpdate& operator = (const SubStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SubState"

    static const int kSubState = 0;

    /**
     * Clears the field "SubState".
     *
     * The field will be set to its default value. The hasSubState()
     * method will return false.
     */
    inline void clearSubState();

    /**
     * Checks whether the field "SubState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubState()). Otherwise it will return false.
     */
    inline bool hasSubState () const;

    /**
     * Returns the value of the member "SubState".
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     *
     * @return The value of the field "SubState"
     */
    inline const ::std::string& getSubState () const;

    /**
     * Retrieves the value of the field "SubState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SubState".
     */
    inline ::std::string& getSubStateMutable ();

    /**
     * Sets the value of the member "SubState".
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     *
     * @param SubState The value which will be set
     */
    inline void setSubState (const ::std::string& SubState_);

    /**
     * Sets the value of the member "SubState".
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     *
     * @param SubState The value which will be set
     */
    inline void setSubState (const char* SubState_);

    /**
     * Sets the value of the member "SubState".
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     *
     * @param SubState The value which will be set
     */
    inline void setSubState (const char* value, size_t size);

    static const SubStateUpdate &getDefaultInstance();

private:

    inline void set_has_SubState ();

    inline void clear_has_SubState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _SubState;

};

/**
 * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
 * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
 * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
 * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
 * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
 */
class SubStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubStateRegister ();

    /**
     * Copy constructor
     */
    inline  SubStateRegister (const SubStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SubStateRegister();

    /**
     * Assignment operator
     */
    inline SubStateRegister& operator = (const SubStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SubStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
 */
class FragmentPathUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FragmentPathUpdate ();

    /**
     * Copy constructor
     */
    inline  FragmentPathUpdate (const FragmentPathUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FragmentPathUpdate (const ::std::string& FragmentPath_);

    /**
     * Destructor
     */
    inline virtual  ~FragmentPathUpdate();

    /**
     * Assignment operator
     */
    inline FragmentPathUpdate& operator = (const FragmentPathUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FragmentPathUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FragmentPathUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FragmentPathUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FragmentPathUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FragmentPath"

    static const int kFragmentPath = 0;

    /**
     * Clears the field "FragmentPath".
     *
     * The field will be set to its default value. The hasFragmentPath()
     * method will return false.
     */
    inline void clearFragmentPath();

    /**
     * Checks whether the field "FragmentPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFragmentPath()). Otherwise it will return false.
     */
    inline bool hasFragmentPath () const;

    /**
     * Returns the value of the member "FragmentPath".
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     *
     * @return The value of the field "FragmentPath"
     */
    inline const ::std::string& getFragmentPath () const;

    /**
     * Retrieves the value of the field "FragmentPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FragmentPath".
     */
    inline ::std::string& getFragmentPathMutable ();

    /**
     * Sets the value of the member "FragmentPath".
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     *
     * @param FragmentPath The value which will be set
     */
    inline void setFragmentPath (const ::std::string& FragmentPath_);

    /**
     * Sets the value of the member "FragmentPath".
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     *
     * @param FragmentPath The value which will be set
     */
    inline void setFragmentPath (const char* FragmentPath_);

    /**
     * Sets the value of the member "FragmentPath".
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     *
     * @param FragmentPath The value which will be set
     */
    inline void setFragmentPath (const char* value, size_t size);

    static const FragmentPathUpdate &getDefaultInstance();

private:

    inline void set_has_FragmentPath ();

    inline void clear_has_FragmentPath ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _FragmentPath;

};

/**
 * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
 */
class FragmentPathRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FragmentPathRegister ();

    /**
     * Copy constructor
     */
    inline  FragmentPathRegister (const FragmentPathRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FragmentPathRegister();

    /**
     * Assignment operator
     */
    inline FragmentPathRegister& operator = (const FragmentPathRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FragmentPathRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FragmentPathRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FragmentPathRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FragmentPathRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FragmentPathRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
 * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
 */
class SourcePathUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourcePathUpdate ();

    /**
     * Copy constructor
     */
    inline  SourcePathUpdate (const SourcePathUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SourcePathUpdate (const ::std::string& SourcePath_);

    /**
     * Destructor
     */
    inline virtual  ~SourcePathUpdate();

    /**
     * Assignment operator
     */
    inline SourcePathUpdate& operator = (const SourcePathUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourcePathUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourcePathUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourcePathUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourcePathUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SourcePath"

    static const int kSourcePath = 0;

    /**
     * Clears the field "SourcePath".
     *
     * The field will be set to its default value. The hasSourcePath()
     * method will return false.
     */
    inline void clearSourcePath();

    /**
     * Checks whether the field "SourcePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourcePath()). Otherwise it will return false.
     */
    inline bool hasSourcePath () const;

    /**
     * Returns the value of the member "SourcePath".
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     *
     * @return The value of the field "SourcePath"
     */
    inline const ::std::string& getSourcePath () const;

    /**
     * Retrieves the value of the field "SourcePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SourcePath".
     */
    inline ::std::string& getSourcePathMutable ();

    /**
     * Sets the value of the member "SourcePath".
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     *
     * @param SourcePath The value which will be set
     */
    inline void setSourcePath (const ::std::string& SourcePath_);

    /**
     * Sets the value of the member "SourcePath".
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     *
     * @param SourcePath The value which will be set
     */
    inline void setSourcePath (const char* SourcePath_);

    /**
     * Sets the value of the member "SourcePath".
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     *
     * @param SourcePath The value which will be set
     */
    inline void setSourcePath (const char* value, size_t size);

    static const SourcePathUpdate &getDefaultInstance();

private:

    inline void set_has_SourcePath ();

    inline void clear_has_SourcePath ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _SourcePath;

};

/**
 * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
 * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
 */
class SourcePathRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourcePathRegister ();

    /**
     * Copy constructor
     */
    inline  SourcePathRegister (const SourcePathRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SourcePathRegister();

    /**
     * Assignment operator
     */
    inline SourcePathRegister& operator = (const SourcePathRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourcePathRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourcePathRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourcePathRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourcePathRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SourcePathRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * DropInPaths
 */
class DropInPathsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DropInPathsUpdate ();

    /**
     * Copy constructor
     */
    inline  DropInPathsUpdate (const DropInPathsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DropInPathsUpdate (const ::std::vector< ::std::string >& DropInPaths_);

    /**
     * Destructor
     */
    inline virtual  ~DropInPathsUpdate();

    /**
     * Assignment operator
     */
    inline DropInPathsUpdate& operator = (const DropInPathsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DropInPathsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DropInPathsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DropInPathsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DropInPathsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DropInPaths"

    static const int kDropInPaths = 0;

    /**
     * Clears the field "DropInPaths".
     *
     * The field will be set to its default value. The hasDropInPaths()
     * method will return false.
     */
    inline void clearDropInPaths();

    /**
     * Checks whether the field "DropInPaths" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDropInPaths()). Otherwise it will return false.
     */
    inline bool hasDropInPaths () const;

    /**
     * Returns the value of the member "DropInPaths".
     *
     * DropInPaths
     *
     * @return The value of the field "DropInPaths"
     */
    inline const ::std::vector< ::std::string >& getDropInPaths () const;

    /**
     * Retrieves the value of the field "DropInPaths" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DropInPaths".
     */
    inline ::std::vector< ::std::string >& getDropInPathsMutable ();

    /**
     * Sets the value of the member "DropInPaths".
     *
     * DropInPaths
     *
     * @param DropInPaths The value which will be set
     */
    inline void setDropInPaths (const ::std::vector< ::std::string >& DropInPaths_);

    static const DropInPathsUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_DropInPaths ();

    inline void clear_has_DropInPaths ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _DropInPaths;

};

/**
 * DropInPaths
 */
class DropInPathsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DropInPathsRegister ();

    /**
     * Copy constructor
     */
    inline  DropInPathsRegister (const DropInPathsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DropInPathsRegister();

    /**
     * Assignment operator
     */
    inline DropInPathsRegister& operator = (const DropInPathsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DropInPathsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DropInPathsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DropInPathsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DropInPathsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DropInPathsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
 * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
 * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
 * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
 * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
 * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
 * 		determined whether the unit file is enabled.
 */
class UnitFileStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitFileStateUpdate ();

    /**
     * Copy constructor
     */
    inline  UnitFileStateUpdate (const UnitFileStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UnitFileStateUpdate (const ::std::string& UnitFileState_);

    /**
     * Destructor
     */
    inline virtual  ~UnitFileStateUpdate();

    /**
     * Assignment operator
     */
    inline UnitFileStateUpdate& operator = (const UnitFileStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitFileStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitFileStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitFileStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitFileStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UnitFileState"

    static const int kUnitFileState = 0;

    /**
     * Clears the field "UnitFileState".
     *
     * The field will be set to its default value. The hasUnitFileState()
     * method will return false.
     */
    inline void clearUnitFileState();

    /**
     * Checks whether the field "UnitFileState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnitFileState()). Otherwise it will return false.
     */
    inline bool hasUnitFileState () const;

    /**
     * Returns the value of the member "UnitFileState".
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     *
     * @return The value of the field "UnitFileState"
     */
    inline const ::std::string& getUnitFileState () const;

    /**
     * Retrieves the value of the field "UnitFileState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UnitFileState".
     */
    inline ::std::string& getUnitFileStateMutable ();

    /**
     * Sets the value of the member "UnitFileState".
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     *
     * @param UnitFileState The value which will be set
     */
    inline void setUnitFileState (const ::std::string& UnitFileState_);

    /**
     * Sets the value of the member "UnitFileState".
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     *
     * @param UnitFileState The value which will be set
     */
    inline void setUnitFileState (const char* UnitFileState_);

    /**
     * Sets the value of the member "UnitFileState".
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     *
     * @param UnitFileState The value which will be set
     */
    inline void setUnitFileState (const char* value, size_t size);

    static const UnitFileStateUpdate &getDefaultInstance();

private:

    inline void set_has_UnitFileState ();

    inline void clear_has_UnitFileState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _UnitFileState;

};

/**
 * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
 * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
 * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
 * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
 * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
 * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
 * 		determined whether the unit file is enabled.
 */
class UnitFileStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitFileStateRegister ();

    /**
     * Copy constructor
     */
    inline  UnitFileStateRegister (const UnitFileStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UnitFileStateRegister();

    /**
     * Assignment operator
     */
    inline UnitFileStateRegister& operator = (const UnitFileStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitFileStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitFileStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitFileStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitFileStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UnitFileStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * UnitFilePreset
 */
class UnitFilePresetUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitFilePresetUpdate ();

    /**
     * Copy constructor
     */
    inline  UnitFilePresetUpdate (const UnitFilePresetUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UnitFilePresetUpdate (const ::std::string& UnitFilePreset_);

    /**
     * Destructor
     */
    inline virtual  ~UnitFilePresetUpdate();

    /**
     * Assignment operator
     */
    inline UnitFilePresetUpdate& operator = (const UnitFilePresetUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitFilePresetUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitFilePresetUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitFilePresetUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitFilePresetUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UnitFilePreset"

    static const int kUnitFilePreset = 0;

    /**
     * Clears the field "UnitFilePreset".
     *
     * The field will be set to its default value. The hasUnitFilePreset()
     * method will return false.
     */
    inline void clearUnitFilePreset();

    /**
     * Checks whether the field "UnitFilePreset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnitFilePreset()). Otherwise it will return false.
     */
    inline bool hasUnitFilePreset () const;

    /**
     * Returns the value of the member "UnitFilePreset".
     *
     * UnitFilePreset
     *
     * @return The value of the field "UnitFilePreset"
     */
    inline const ::std::string& getUnitFilePreset () const;

    /**
     * Retrieves the value of the field "UnitFilePreset" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UnitFilePreset".
     */
    inline ::std::string& getUnitFilePresetMutable ();

    /**
     * Sets the value of the member "UnitFilePreset".
     *
     * UnitFilePreset
     *
     * @param UnitFilePreset The value which will be set
     */
    inline void setUnitFilePreset (const ::std::string& UnitFilePreset_);

    /**
     * Sets the value of the member "UnitFilePreset".
     *
     * UnitFilePreset
     *
     * @param UnitFilePreset The value which will be set
     */
    inline void setUnitFilePreset (const char* UnitFilePreset_);

    /**
     * Sets the value of the member "UnitFilePreset".
     *
     * UnitFilePreset
     *
     * @param UnitFilePreset The value which will be set
     */
    inline void setUnitFilePreset (const char* value, size_t size);

    static const UnitFilePresetUpdate &getDefaultInstance();

private:

    inline void set_has_UnitFilePreset ();

    inline void clear_has_UnitFilePreset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _UnitFilePreset;

};

/**
 * UnitFilePreset
 */
class UnitFilePresetRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitFilePresetRegister ();

    /**
     * Copy constructor
     */
    inline  UnitFilePresetRegister (const UnitFilePresetRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UnitFilePresetRegister();

    /**
     * Assignment operator
     */
    inline UnitFilePresetRegister& operator = (const UnitFilePresetRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitFilePresetRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitFilePresetRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitFilePresetRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitFilePresetRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UnitFilePresetRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
 * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
 * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
 */
class InactiveExitTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InactiveExitTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  InactiveExitTimestampUpdate (const InactiveExitTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  InactiveExitTimestampUpdate (uint64 InactiveExitTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~InactiveExitTimestampUpdate();

    /**
     * Assignment operator
     */
    inline InactiveExitTimestampUpdate& operator = (const InactiveExitTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InactiveExitTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InactiveExitTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InactiveExitTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InactiveExitTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InactiveExitTimestamp"

    static const int kInactiveExitTimestamp = 0;

    /**
     * Clears the field "InactiveExitTimestamp".
     *
     * The field will be set to its default value. The hasInactiveExitTimestamp()
     * method will return false.
     */
    inline void clearInactiveExitTimestamp();

    /**
     * Checks whether the field "InactiveExitTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInactiveExitTimestamp()). Otherwise it will return false.
     */
    inline bool hasInactiveExitTimestamp () const;

    /**
     * Returns the value of the member "InactiveExitTimestamp".
     *
     * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
     * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
     * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
     *
     * @return The value of the field "InactiveExitTimestamp"
     */
    inline uint64 getInactiveExitTimestamp () const;

    /**
     * Sets the value of the member "InactiveExitTimestamp".
     *
     * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
     * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
     * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
     *
     * @param InactiveExitTimestamp The value which will be set
     */
    inline void setInactiveExitTimestamp (uint64 InactiveExitTimestamp_);

    static const InactiveExitTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_InactiveExitTimestamp ();

    inline void clear_has_InactiveExitTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _InactiveExitTimestamp;

};

/**
 * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
 * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
 * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
 */
class InactiveExitTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InactiveExitTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  InactiveExitTimestampRegister (const InactiveExitTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~InactiveExitTimestampRegister();

    /**
     * Assignment operator
     */
    inline InactiveExitTimestampRegister& operator = (const InactiveExitTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InactiveExitTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InactiveExitTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InactiveExitTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InactiveExitTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const InactiveExitTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * InactiveExitTimestampMonotonic
 */
class InactiveExitTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InactiveExitTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  InactiveExitTimestampMonotonicUpdate (const InactiveExitTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  InactiveExitTimestampMonotonicUpdate (uint64 InactiveExitTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~InactiveExitTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline InactiveExitTimestampMonotonicUpdate& operator = (const InactiveExitTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InactiveExitTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InactiveExitTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InactiveExitTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InactiveExitTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InactiveExitTimestampMonotonic"

    static const int kInactiveExitTimestampMonotonic = 0;

    /**
     * Clears the field "InactiveExitTimestampMonotonic".
     *
     * The field will be set to its default value. The hasInactiveExitTimestampMonotonic()
     * method will return false.
     */
    inline void clearInactiveExitTimestampMonotonic();

    /**
     * Checks whether the field "InactiveExitTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInactiveExitTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasInactiveExitTimestampMonotonic () const;

    /**
     * Returns the value of the member "InactiveExitTimestampMonotonic".
     *
     * InactiveExitTimestampMonotonic
     *
     * @return The value of the field "InactiveExitTimestampMonotonic"
     */
    inline uint64 getInactiveExitTimestampMonotonic () const;

    /**
     * Sets the value of the member "InactiveExitTimestampMonotonic".
     *
     * InactiveExitTimestampMonotonic
     *
     * @param InactiveExitTimestampMonotonic The value which will be set
     */
    inline void setInactiveExitTimestampMonotonic (uint64 InactiveExitTimestampMonotonic_);

    static const InactiveExitTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_InactiveExitTimestampMonotonic ();

    inline void clear_has_InactiveExitTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _InactiveExitTimestampMonotonic;

};

/**
 * InactiveExitTimestampMonotonic
 */
class InactiveExitTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InactiveExitTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  InactiveExitTimestampMonotonicRegister (const InactiveExitTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~InactiveExitTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline InactiveExitTimestampMonotonicRegister& operator = (const InactiveExitTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InactiveExitTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InactiveExitTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InactiveExitTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InactiveExitTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const InactiveExitTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ActiveEnterTimestamp
 */
class ActiveEnterTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveEnterTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveEnterTimestampUpdate (const ActiveEnterTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveEnterTimestampUpdate (uint64 ActiveEnterTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveEnterTimestampUpdate();

    /**
     * Assignment operator
     */
    inline ActiveEnterTimestampUpdate& operator = (const ActiveEnterTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveEnterTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveEnterTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveEnterTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveEnterTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActiveEnterTimestamp"

    static const int kActiveEnterTimestamp = 0;

    /**
     * Clears the field "ActiveEnterTimestamp".
     *
     * The field will be set to its default value. The hasActiveEnterTimestamp()
     * method will return false.
     */
    inline void clearActiveEnterTimestamp();

    /**
     * Checks whether the field "ActiveEnterTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveEnterTimestamp()). Otherwise it will return false.
     */
    inline bool hasActiveEnterTimestamp () const;

    /**
     * Returns the value of the member "ActiveEnterTimestamp".
     *
     * ActiveEnterTimestamp
     *
     * @return The value of the field "ActiveEnterTimestamp"
     */
    inline uint64 getActiveEnterTimestamp () const;

    /**
     * Sets the value of the member "ActiveEnterTimestamp".
     *
     * ActiveEnterTimestamp
     *
     * @param ActiveEnterTimestamp The value which will be set
     */
    inline void setActiveEnterTimestamp (uint64 ActiveEnterTimestamp_);

    static const ActiveEnterTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_ActiveEnterTimestamp ();

    inline void clear_has_ActiveEnterTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _ActiveEnterTimestamp;

};

/**
 * ActiveEnterTimestamp
 */
class ActiveEnterTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveEnterTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveEnterTimestampRegister (const ActiveEnterTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveEnterTimestampRegister();

    /**
     * Assignment operator
     */
    inline ActiveEnterTimestampRegister& operator = (const ActiveEnterTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveEnterTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveEnterTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveEnterTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveEnterTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveEnterTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ActiveEnterTimestampMonotonic
 */
class ActiveEnterTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveEnterTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveEnterTimestampMonotonicUpdate (const ActiveEnterTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveEnterTimestampMonotonicUpdate (uint64 ActiveEnterTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveEnterTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline ActiveEnterTimestampMonotonicUpdate& operator = (const ActiveEnterTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveEnterTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveEnterTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveEnterTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveEnterTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActiveEnterTimestampMonotonic"

    static const int kActiveEnterTimestampMonotonic = 0;

    /**
     * Clears the field "ActiveEnterTimestampMonotonic".
     *
     * The field will be set to its default value. The hasActiveEnterTimestampMonotonic()
     * method will return false.
     */
    inline void clearActiveEnterTimestampMonotonic();

    /**
     * Checks whether the field "ActiveEnterTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveEnterTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasActiveEnterTimestampMonotonic () const;

    /**
     * Returns the value of the member "ActiveEnterTimestampMonotonic".
     *
     * ActiveEnterTimestampMonotonic
     *
     * @return The value of the field "ActiveEnterTimestampMonotonic"
     */
    inline uint64 getActiveEnterTimestampMonotonic () const;

    /**
     * Sets the value of the member "ActiveEnterTimestampMonotonic".
     *
     * ActiveEnterTimestampMonotonic
     *
     * @param ActiveEnterTimestampMonotonic The value which will be set
     */
    inline void setActiveEnterTimestampMonotonic (uint64 ActiveEnterTimestampMonotonic_);

    static const ActiveEnterTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_ActiveEnterTimestampMonotonic ();

    inline void clear_has_ActiveEnterTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _ActiveEnterTimestampMonotonic;

};

/**
 * ActiveEnterTimestampMonotonic
 */
class ActiveEnterTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveEnterTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveEnterTimestampMonotonicRegister (const ActiveEnterTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveEnterTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline ActiveEnterTimestampMonotonicRegister& operator = (const ActiveEnterTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveEnterTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveEnterTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveEnterTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveEnterTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveEnterTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ActiveExitTimestamp
 */
class ActiveExitTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveExitTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveExitTimestampUpdate (const ActiveExitTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveExitTimestampUpdate (uint64 ActiveExitTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveExitTimestampUpdate();

    /**
     * Assignment operator
     */
    inline ActiveExitTimestampUpdate& operator = (const ActiveExitTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveExitTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveExitTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveExitTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveExitTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActiveExitTimestamp"

    static const int kActiveExitTimestamp = 0;

    /**
     * Clears the field "ActiveExitTimestamp".
     *
     * The field will be set to its default value. The hasActiveExitTimestamp()
     * method will return false.
     */
    inline void clearActiveExitTimestamp();

    /**
     * Checks whether the field "ActiveExitTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveExitTimestamp()). Otherwise it will return false.
     */
    inline bool hasActiveExitTimestamp () const;

    /**
     * Returns the value of the member "ActiveExitTimestamp".
     *
     * ActiveExitTimestamp
     *
     * @return The value of the field "ActiveExitTimestamp"
     */
    inline uint64 getActiveExitTimestamp () const;

    /**
     * Sets the value of the member "ActiveExitTimestamp".
     *
     * ActiveExitTimestamp
     *
     * @param ActiveExitTimestamp The value which will be set
     */
    inline void setActiveExitTimestamp (uint64 ActiveExitTimestamp_);

    static const ActiveExitTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_ActiveExitTimestamp ();

    inline void clear_has_ActiveExitTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _ActiveExitTimestamp;

};

/**
 * ActiveExitTimestamp
 */
class ActiveExitTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveExitTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveExitTimestampRegister (const ActiveExitTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveExitTimestampRegister();

    /**
     * Assignment operator
     */
    inline ActiveExitTimestampRegister& operator = (const ActiveExitTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveExitTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveExitTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveExitTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveExitTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveExitTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ActiveExitTimestampMonotonic
 */
class ActiveExitTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveExitTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveExitTimestampMonotonicUpdate (const ActiveExitTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveExitTimestampMonotonicUpdate (uint64 ActiveExitTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveExitTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline ActiveExitTimestampMonotonicUpdate& operator = (const ActiveExitTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveExitTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveExitTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveExitTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveExitTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActiveExitTimestampMonotonic"

    static const int kActiveExitTimestampMonotonic = 0;

    /**
     * Clears the field "ActiveExitTimestampMonotonic".
     *
     * The field will be set to its default value. The hasActiveExitTimestampMonotonic()
     * method will return false.
     */
    inline void clearActiveExitTimestampMonotonic();

    /**
     * Checks whether the field "ActiveExitTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveExitTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasActiveExitTimestampMonotonic () const;

    /**
     * Returns the value of the member "ActiveExitTimestampMonotonic".
     *
     * ActiveExitTimestampMonotonic
     *
     * @return The value of the field "ActiveExitTimestampMonotonic"
     */
    inline uint64 getActiveExitTimestampMonotonic () const;

    /**
     * Sets the value of the member "ActiveExitTimestampMonotonic".
     *
     * ActiveExitTimestampMonotonic
     *
     * @param ActiveExitTimestampMonotonic The value which will be set
     */
    inline void setActiveExitTimestampMonotonic (uint64 ActiveExitTimestampMonotonic_);

    static const ActiveExitTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_ActiveExitTimestampMonotonic ();

    inline void clear_has_ActiveExitTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _ActiveExitTimestampMonotonic;

};

/**
 * ActiveExitTimestampMonotonic
 */
class ActiveExitTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveExitTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveExitTimestampMonotonicRegister (const ActiveExitTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveExitTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline ActiveExitTimestampMonotonicRegister& operator = (const ActiveExitTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveExitTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveExitTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveExitTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveExitTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveExitTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * InactiveEnterTimestamp
 */
class InactiveEnterTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InactiveEnterTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  InactiveEnterTimestampUpdate (const InactiveEnterTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  InactiveEnterTimestampUpdate (uint64 InactiveEnterTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~InactiveEnterTimestampUpdate();

    /**
     * Assignment operator
     */
    inline InactiveEnterTimestampUpdate& operator = (const InactiveEnterTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InactiveEnterTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InactiveEnterTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InactiveEnterTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InactiveEnterTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InactiveEnterTimestamp"

    static const int kInactiveEnterTimestamp = 0;

    /**
     * Clears the field "InactiveEnterTimestamp".
     *
     * The field will be set to its default value. The hasInactiveEnterTimestamp()
     * method will return false.
     */
    inline void clearInactiveEnterTimestamp();

    /**
     * Checks whether the field "InactiveEnterTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInactiveEnterTimestamp()). Otherwise it will return false.
     */
    inline bool hasInactiveEnterTimestamp () const;

    /**
     * Returns the value of the member "InactiveEnterTimestamp".
     *
     * InactiveEnterTimestamp
     *
     * @return The value of the field "InactiveEnterTimestamp"
     */
    inline uint64 getInactiveEnterTimestamp () const;

    /**
     * Sets the value of the member "InactiveEnterTimestamp".
     *
     * InactiveEnterTimestamp
     *
     * @param InactiveEnterTimestamp The value which will be set
     */
    inline void setInactiveEnterTimestamp (uint64 InactiveEnterTimestamp_);

    static const InactiveEnterTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_InactiveEnterTimestamp ();

    inline void clear_has_InactiveEnterTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _InactiveEnterTimestamp;

};

/**
 * InactiveEnterTimestamp
 */
class InactiveEnterTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InactiveEnterTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  InactiveEnterTimestampRegister (const InactiveEnterTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~InactiveEnterTimestampRegister();

    /**
     * Assignment operator
     */
    inline InactiveEnterTimestampRegister& operator = (const InactiveEnterTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InactiveEnterTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InactiveEnterTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InactiveEnterTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InactiveEnterTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const InactiveEnterTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * InactiveEnterTimestampMonotonic
 */
class InactiveEnterTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InactiveEnterTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  InactiveEnterTimestampMonotonicUpdate (const InactiveEnterTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  InactiveEnterTimestampMonotonicUpdate (uint64 InactiveEnterTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~InactiveEnterTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline InactiveEnterTimestampMonotonicUpdate& operator = (const InactiveEnterTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InactiveEnterTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InactiveEnterTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InactiveEnterTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InactiveEnterTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InactiveEnterTimestampMonotonic"

    static const int kInactiveEnterTimestampMonotonic = 0;

    /**
     * Clears the field "InactiveEnterTimestampMonotonic".
     *
     * The field will be set to its default value. The hasInactiveEnterTimestampMonotonic()
     * method will return false.
     */
    inline void clearInactiveEnterTimestampMonotonic();

    /**
     * Checks whether the field "InactiveEnterTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInactiveEnterTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasInactiveEnterTimestampMonotonic () const;

    /**
     * Returns the value of the member "InactiveEnterTimestampMonotonic".
     *
     * InactiveEnterTimestampMonotonic
     *
     * @return The value of the field "InactiveEnterTimestampMonotonic"
     */
    inline uint64 getInactiveEnterTimestampMonotonic () const;

    /**
     * Sets the value of the member "InactiveEnterTimestampMonotonic".
     *
     * InactiveEnterTimestampMonotonic
     *
     * @param InactiveEnterTimestampMonotonic The value which will be set
     */
    inline void setInactiveEnterTimestampMonotonic (uint64 InactiveEnterTimestampMonotonic_);

    static const InactiveEnterTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_InactiveEnterTimestampMonotonic ();

    inline void clear_has_InactiveEnterTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _InactiveEnterTimestampMonotonic;

};

/**
 * InactiveEnterTimestampMonotonic
 */
class InactiveEnterTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InactiveEnterTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  InactiveEnterTimestampMonotonicRegister (const InactiveEnterTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~InactiveEnterTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline InactiveEnterTimestampMonotonicRegister& operator = (const InactiveEnterTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InactiveEnterTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InactiveEnterTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InactiveEnterTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InactiveEnterTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const InactiveEnterTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
 * 		the client might not necessary have the right privileges to execute them.
 */
class CanStartUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CanStartUpdate ();

    /**
     * Copy constructor
     */
    inline  CanStartUpdate (const CanStartUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CanStartUpdate (bool CanStart_);

    /**
     * Destructor
     */
    inline virtual  ~CanStartUpdate();

    /**
     * Assignment operator
     */
    inline CanStartUpdate& operator = (const CanStartUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CanStartUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CanStartUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CanStartUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CanStartUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CanStart"

    static const int kCanStart = 0;

    /**
     * Clears the field "CanStart".
     *
     * The field will be set to its default value. The hasCanStart()
     * method will return false.
     */
    inline void clearCanStart();

    /**
     * Checks whether the field "CanStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanStart()). Otherwise it will return false.
     */
    inline bool hasCanStart () const;

    /**
     * Returns the value of the member "CanStart".
     *
     * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @return The value of the field "CanStart"
     */
    inline bool getCanStart () const;

    /**
     * Sets the value of the member "CanStart".
     *
     * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param CanStart The value which will be set
     */
    inline void setCanStart (bool CanStart_);

    static const CanStartUpdate &getDefaultInstance();

private:

    inline void set_has_CanStart ();

    inline void clear_has_CanStart ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _CanStart;

};

/**
 * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
 * 		the client might not necessary have the right privileges to execute them.
 */
class CanStartRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CanStartRegister ();

    /**
     * Copy constructor
     */
    inline  CanStartRegister (const CanStartRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CanStartRegister();

    /**
     * Assignment operator
     */
    inline CanStartRegister& operator = (const CanStartRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CanStartRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CanStartRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CanStartRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CanStartRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CanStartRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
 * 		the client might not necessary have the right privileges to execute them.
 */
class CanStopUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CanStopUpdate ();

    /**
     * Copy constructor
     */
    inline  CanStopUpdate (const CanStopUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CanStopUpdate (bool CanStop_);

    /**
     * Destructor
     */
    inline virtual  ~CanStopUpdate();

    /**
     * Assignment operator
     */
    inline CanStopUpdate& operator = (const CanStopUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CanStopUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CanStopUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CanStopUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CanStopUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CanStop"

    static const int kCanStop = 0;

    /**
     * Clears the field "CanStop".
     *
     * The field will be set to its default value. The hasCanStop()
     * method will return false.
     */
    inline void clearCanStop();

    /**
     * Checks whether the field "CanStop" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanStop()). Otherwise it will return false.
     */
    inline bool hasCanStop () const;

    /**
     * Returns the value of the member "CanStop".
     *
     * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @return The value of the field "CanStop"
     */
    inline bool getCanStop () const;

    /**
     * Sets the value of the member "CanStop".
     *
     * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param CanStop The value which will be set
     */
    inline void setCanStop (bool CanStop_);

    static const CanStopUpdate &getDefaultInstance();

private:

    inline void set_has_CanStop ();

    inline void clear_has_CanStop ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _CanStop;

};

/**
 * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
 * 		the client might not necessary have the right privileges to execute them.
 */
class CanStopRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CanStopRegister ();

    /**
     * Copy constructor
     */
    inline  CanStopRegister (const CanStopRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CanStopRegister();

    /**
     * Assignment operator
     */
    inline CanStopRegister& operator = (const CanStopRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CanStopRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CanStopRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CanStopRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CanStopRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CanStopRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
 * 		the client might not necessary have the right privileges to execute them.
 */
class CanReloadUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CanReloadUpdate ();

    /**
     * Copy constructor
     */
    inline  CanReloadUpdate (const CanReloadUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CanReloadUpdate (bool CanReload_);

    /**
     * Destructor
     */
    inline virtual  ~CanReloadUpdate();

    /**
     * Assignment operator
     */
    inline CanReloadUpdate& operator = (const CanReloadUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CanReloadUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CanReloadUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CanReloadUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CanReloadUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CanReload"

    static const int kCanReload = 0;

    /**
     * Clears the field "CanReload".
     *
     * The field will be set to its default value. The hasCanReload()
     * method will return false.
     */
    inline void clearCanReload();

    /**
     * Checks whether the field "CanReload" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanReload()). Otherwise it will return false.
     */
    inline bool hasCanReload () const;

    /**
     * Returns the value of the member "CanReload".
     *
     * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @return The value of the field "CanReload"
     */
    inline bool getCanReload () const;

    /**
     * Sets the value of the member "CanReload".
     *
     * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param CanReload The value which will be set
     */
    inline void setCanReload (bool CanReload_);

    static const CanReloadUpdate &getDefaultInstance();

private:

    inline void set_has_CanReload ();

    inline void clear_has_CanReload ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _CanReload;

};

/**
 * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
 * 		the client might not necessary have the right privileges to execute them.
 */
class CanReloadRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CanReloadRegister ();

    /**
     * Copy constructor
     */
    inline  CanReloadRegister (const CanReloadRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CanReloadRegister();

    /**
     * Assignment operator
     */
    inline CanReloadRegister& operator = (const CanReloadRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CanReloadRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CanReloadRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CanReloadRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CanReloadRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CanReloadRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
 */
class CanIsolateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CanIsolateUpdate ();

    /**
     * Copy constructor
     */
    inline  CanIsolateUpdate (const CanIsolateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CanIsolateUpdate (bool CanIsolate_);

    /**
     * Destructor
     */
    inline virtual  ~CanIsolateUpdate();

    /**
     * Assignment operator
     */
    inline CanIsolateUpdate& operator = (const CanIsolateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CanIsolateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CanIsolateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CanIsolateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CanIsolateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CanIsolate"

    static const int kCanIsolate = 0;

    /**
     * Clears the field "CanIsolate".
     *
     * The field will be set to its default value. The hasCanIsolate()
     * method will return false.
     */
    inline void clearCanIsolate();

    /**
     * Checks whether the field "CanIsolate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanIsolate()). Otherwise it will return false.
     */
    inline bool hasCanIsolate () const;

    /**
     * Returns the value of the member "CanIsolate".
     *
     * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
     *
     * @return The value of the field "CanIsolate"
     */
    inline bool getCanIsolate () const;

    /**
     * Sets the value of the member "CanIsolate".
     *
     * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
     *
     * @param CanIsolate The value which will be set
     */
    inline void setCanIsolate (bool CanIsolate_);

    static const CanIsolateUpdate &getDefaultInstance();

private:

    inline void set_has_CanIsolate ();

    inline void clear_has_CanIsolate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _CanIsolate;

};

/**
 * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
 */
class CanIsolateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CanIsolateRegister ();

    /**
     * Copy constructor
     */
    inline  CanIsolateRegister (const CanIsolateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CanIsolateRegister();

    /**
     * Assignment operator
     */
    inline CanIsolateRegister& operator = (const CanIsolateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CanIsolateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CanIsolateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CanIsolateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CanIsolateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CanIsolateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
 * 		If no job is scheduled or executed the job id field will be 0.
 */
class JobUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JobUpdate ();

    /**
     * Copy constructor
     */
    inline  JobUpdate (const JobUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  JobUpdate (const job& Job_);

    /**
     * Destructor
     */
    inline virtual  ~JobUpdate();

    /**
     * Assignment operator
     */
    inline JobUpdate& operator = (const JobUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JobUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JobUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JobUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JobUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Job"

    static const int kJob = 0;

    /**
     * Clears the field "Job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "Job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "Job".
     *
     * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
     * 		If no job is scheduled or executed the job id field will be 0.
     *
     * @return The value of the field "Job"
     */
    inline const job& getJob () const;

    /**
     * Retrieves the value of the field "Job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Job".
     */
    inline job& getJobMutable ();

    /**
     * Sets the value of the member "Job".
     *
     * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
     * 		If no job is scheduled or executed the job id field will be 0.
     *
     * @param Job The value which will be set
     */
    inline void setJob (const job& Job_);

    static const JobUpdate &getDefaultInstance();

private:

    inline void set_has_Job ();

    inline void clear_has_Job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    job _Job;

};

/**
 * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
 * 		If no job is scheduled or executed the job id field will be 0.
 */
class JobRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JobRegister ();

    /**
     * Copy constructor
     */
    inline  JobRegister (const JobRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~JobRegister();

    /**
     * Assignment operator
     */
    inline JobRegister& operator = (const JobRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JobRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JobRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JobRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JobRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const JobRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
 */
class StopWhenUnneededUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopWhenUnneededUpdate ();

    /**
     * Copy constructor
     */
    inline  StopWhenUnneededUpdate (const StopWhenUnneededUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StopWhenUnneededUpdate (bool StopWhenUnneeded_);

    /**
     * Destructor
     */
    inline virtual  ~StopWhenUnneededUpdate();

    /**
     * Assignment operator
     */
    inline StopWhenUnneededUpdate& operator = (const StopWhenUnneededUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopWhenUnneededUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopWhenUnneededUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopWhenUnneededUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopWhenUnneededUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StopWhenUnneeded"

    static const int kStopWhenUnneeded = 0;

    /**
     * Clears the field "StopWhenUnneeded".
     *
     * The field will be set to its default value. The hasStopWhenUnneeded()
     * method will return false.
     */
    inline void clearStopWhenUnneeded();

    /**
     * Checks whether the field "StopWhenUnneeded" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStopWhenUnneeded()). Otherwise it will return false.
     */
    inline bool hasStopWhenUnneeded () const;

    /**
     * Returns the value of the member "StopWhenUnneeded".
     *
     * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
     *
     * @return The value of the field "StopWhenUnneeded"
     */
    inline bool getStopWhenUnneeded () const;

    /**
     * Sets the value of the member "StopWhenUnneeded".
     *
     * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
     *
     * @param StopWhenUnneeded The value which will be set
     */
    inline void setStopWhenUnneeded (bool StopWhenUnneeded_);

    static const StopWhenUnneededUpdate &getDefaultInstance();

private:

    inline void set_has_StopWhenUnneeded ();

    inline void clear_has_StopWhenUnneeded ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _StopWhenUnneeded;

};

/**
 * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
 */
class StopWhenUnneededRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopWhenUnneededRegister ();

    /**
     * Copy constructor
     */
    inline  StopWhenUnneededRegister (const StopWhenUnneededRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StopWhenUnneededRegister();

    /**
     * Assignment operator
     */
    inline StopWhenUnneededRegister& operator = (const StopWhenUnneededRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopWhenUnneededRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopWhenUnneededRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopWhenUnneededRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopWhenUnneededRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StopWhenUnneededRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
 */
class RefuseManualStartUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RefuseManualStartUpdate ();

    /**
     * Copy constructor
     */
    inline  RefuseManualStartUpdate (const RefuseManualStartUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RefuseManualStartUpdate (bool RefuseManualStart_);

    /**
     * Destructor
     */
    inline virtual  ~RefuseManualStartUpdate();

    /**
     * Assignment operator
     */
    inline RefuseManualStartUpdate& operator = (const RefuseManualStartUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RefuseManualStartUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RefuseManualStartUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RefuseManualStartUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RefuseManualStartUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RefuseManualStart"

    static const int kRefuseManualStart = 0;

    /**
     * Clears the field "RefuseManualStart".
     *
     * The field will be set to its default value. The hasRefuseManualStart()
     * method will return false.
     */
    inline void clearRefuseManualStart();

    /**
     * Checks whether the field "RefuseManualStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRefuseManualStart()). Otherwise it will return false.
     */
    inline bool hasRefuseManualStart () const;

    /**
     * Returns the value of the member "RefuseManualStart".
     *
     * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
     *
     * @return The value of the field "RefuseManualStart"
     */
    inline bool getRefuseManualStart () const;

    /**
     * Sets the value of the member "RefuseManualStart".
     *
     * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
     *
     * @param RefuseManualStart The value which will be set
     */
    inline void setRefuseManualStart (bool RefuseManualStart_);

    static const RefuseManualStartUpdate &getDefaultInstance();

private:

    inline void set_has_RefuseManualStart ();

    inline void clear_has_RefuseManualStart ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RefuseManualStart;

};

/**
 * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
 */
class RefuseManualStartRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RefuseManualStartRegister ();

    /**
     * Copy constructor
     */
    inline  RefuseManualStartRegister (const RefuseManualStartRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RefuseManualStartRegister();

    /**
     * Assignment operator
     */
    inline RefuseManualStartRegister& operator = (const RefuseManualStartRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RefuseManualStartRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RefuseManualStartRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RefuseManualStartRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RefuseManualStartRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RefuseManualStartRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
 */
class RefuseManualStopUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RefuseManualStopUpdate ();

    /**
     * Copy constructor
     */
    inline  RefuseManualStopUpdate (const RefuseManualStopUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RefuseManualStopUpdate (bool RefuseManualStop_);

    /**
     * Destructor
     */
    inline virtual  ~RefuseManualStopUpdate();

    /**
     * Assignment operator
     */
    inline RefuseManualStopUpdate& operator = (const RefuseManualStopUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RefuseManualStopUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RefuseManualStopUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RefuseManualStopUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RefuseManualStopUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RefuseManualStop"

    static const int kRefuseManualStop = 0;

    /**
     * Clears the field "RefuseManualStop".
     *
     * The field will be set to its default value. The hasRefuseManualStop()
     * method will return false.
     */
    inline void clearRefuseManualStop();

    /**
     * Checks whether the field "RefuseManualStop" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRefuseManualStop()). Otherwise it will return false.
     */
    inline bool hasRefuseManualStop () const;

    /**
     * Returns the value of the member "RefuseManualStop".
     *
     * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
     *
     * @return The value of the field "RefuseManualStop"
     */
    inline bool getRefuseManualStop () const;

    /**
     * Sets the value of the member "RefuseManualStop".
     *
     * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
     *
     * @param RefuseManualStop The value which will be set
     */
    inline void setRefuseManualStop (bool RefuseManualStop_);

    static const RefuseManualStopUpdate &getDefaultInstance();

private:

    inline void set_has_RefuseManualStop ();

    inline void clear_has_RefuseManualStop ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RefuseManualStop;

};

/**
 * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
 */
class RefuseManualStopRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RefuseManualStopRegister ();

    /**
     * Copy constructor
     */
    inline  RefuseManualStopRegister (const RefuseManualStopRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RefuseManualStopRegister();

    /**
     * Assignment operator
     */
    inline RefuseManualStopRegister& operator = (const RefuseManualStopRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RefuseManualStopRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RefuseManualStopRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RefuseManualStopRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RefuseManualStopRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RefuseManualStopRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
 */
class AllowIsolateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AllowIsolateUpdate ();

    /**
     * Copy constructor
     */
    inline  AllowIsolateUpdate (const AllowIsolateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AllowIsolateUpdate (bool AllowIsolate_);

    /**
     * Destructor
     */
    inline virtual  ~AllowIsolateUpdate();

    /**
     * Assignment operator
     */
    inline AllowIsolateUpdate& operator = (const AllowIsolateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllowIsolateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllowIsolateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllowIsolateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllowIsolateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AllowIsolate"

    static const int kAllowIsolate = 0;

    /**
     * Clears the field "AllowIsolate".
     *
     * The field will be set to its default value. The hasAllowIsolate()
     * method will return false.
     */
    inline void clearAllowIsolate();

    /**
     * Checks whether the field "AllowIsolate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAllowIsolate()). Otherwise it will return false.
     */
    inline bool hasAllowIsolate () const;

    /**
     * Returns the value of the member "AllowIsolate".
     *
     * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
     *
     * @return The value of the field "AllowIsolate"
     */
    inline bool getAllowIsolate () const;

    /**
     * Sets the value of the member "AllowIsolate".
     *
     * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
     *
     * @param AllowIsolate The value which will be set
     */
    inline void setAllowIsolate (bool AllowIsolate_);

    static const AllowIsolateUpdate &getDefaultInstance();

private:

    inline void set_has_AllowIsolate ();

    inline void clear_has_AllowIsolate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _AllowIsolate;

};

/**
 * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
 */
class AllowIsolateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AllowIsolateRegister ();

    /**
     * Copy constructor
     */
    inline  AllowIsolateRegister (const AllowIsolateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AllowIsolateRegister();

    /**
     * Assignment operator
     */
    inline AllowIsolateRegister& operator = (const AllowIsolateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllowIsolateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllowIsolateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllowIsolateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllowIsolateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AllowIsolateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
 */
class DefaultDependenciesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DefaultDependenciesUpdate ();

    /**
     * Copy constructor
     */
    inline  DefaultDependenciesUpdate (const DefaultDependenciesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DefaultDependenciesUpdate (bool DefaultDependencies_);

    /**
     * Destructor
     */
    inline virtual  ~DefaultDependenciesUpdate();

    /**
     * Assignment operator
     */
    inline DefaultDependenciesUpdate& operator = (const DefaultDependenciesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DefaultDependenciesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DefaultDependenciesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DefaultDependenciesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DefaultDependenciesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefaultDependencies"

    static const int kDefaultDependencies = 0;

    /**
     * Clears the field "DefaultDependencies".
     *
     * The field will be set to its default value. The hasDefaultDependencies()
     * method will return false.
     */
    inline void clearDefaultDependencies();

    /**
     * Checks whether the field "DefaultDependencies" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefaultDependencies()). Otherwise it will return false.
     */
    inline bool hasDefaultDependencies () const;

    /**
     * Returns the value of the member "DefaultDependencies".
     *
     * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
     *
     * @return The value of the field "DefaultDependencies"
     */
    inline bool getDefaultDependencies () const;

    /**
     * Sets the value of the member "DefaultDependencies".
     *
     * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
     *
     * @param DefaultDependencies The value which will be set
     */
    inline void setDefaultDependencies (bool DefaultDependencies_);

    static const DefaultDependenciesUpdate &getDefaultInstance();

private:

    inline void set_has_DefaultDependencies ();

    inline void clear_has_DefaultDependencies ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _DefaultDependencies;

};

/**
 * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
 */
class DefaultDependenciesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DefaultDependenciesRegister ();

    /**
     * Copy constructor
     */
    inline  DefaultDependenciesRegister (const DefaultDependenciesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DefaultDependenciesRegister();

    /**
     * Assignment operator
     */
    inline DefaultDependenciesRegister& operator = (const DefaultDependenciesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DefaultDependenciesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DefaultDependenciesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DefaultDependenciesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DefaultDependenciesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DefaultDependenciesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * OnFailureJobMode
 */
class OnFailureJobModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnFailureJobModeUpdate ();

    /**
     * Copy constructor
     */
    inline  OnFailureJobModeUpdate (const OnFailureJobModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  OnFailureJobModeUpdate (const ::std::string& OnFailureJobMode_);

    /**
     * Destructor
     */
    inline virtual  ~OnFailureJobModeUpdate();

    /**
     * Assignment operator
     */
    inline OnFailureJobModeUpdate& operator = (const OnFailureJobModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnFailureJobModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnFailureJobModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnFailureJobModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnFailureJobModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OnFailureJobMode"

    static const int kOnFailureJobMode = 0;

    /**
     * Clears the field "OnFailureJobMode".
     *
     * The field will be set to its default value. The hasOnFailureJobMode()
     * method will return false.
     */
    inline void clearOnFailureJobMode();

    /**
     * Checks whether the field "OnFailureJobMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOnFailureJobMode()). Otherwise it will return false.
     */
    inline bool hasOnFailureJobMode () const;

    /**
     * Returns the value of the member "OnFailureJobMode".
     *
     * OnFailureJobMode
     *
     * @return The value of the field "OnFailureJobMode"
     */
    inline const ::std::string& getOnFailureJobMode () const;

    /**
     * Retrieves the value of the field "OnFailureJobMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OnFailureJobMode".
     */
    inline ::std::string& getOnFailureJobModeMutable ();

    /**
     * Sets the value of the member "OnFailureJobMode".
     *
     * OnFailureJobMode
     *
     * @param OnFailureJobMode The value which will be set
     */
    inline void setOnFailureJobMode (const ::std::string& OnFailureJobMode_);

    /**
     * Sets the value of the member "OnFailureJobMode".
     *
     * OnFailureJobMode
     *
     * @param OnFailureJobMode The value which will be set
     */
    inline void setOnFailureJobMode (const char* OnFailureJobMode_);

    /**
     * Sets the value of the member "OnFailureJobMode".
     *
     * OnFailureJobMode
     *
     * @param OnFailureJobMode The value which will be set
     */
    inline void setOnFailureJobMode (const char* value, size_t size);

    static const OnFailureJobModeUpdate &getDefaultInstance();

private:

    inline void set_has_OnFailureJobMode ();

    inline void clear_has_OnFailureJobMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _OnFailureJobMode;

};

/**
 * OnFailureJobMode
 */
class OnFailureJobModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnFailureJobModeRegister ();

    /**
     * Copy constructor
     */
    inline  OnFailureJobModeRegister (const OnFailureJobModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~OnFailureJobModeRegister();

    /**
     * Assignment operator
     */
    inline OnFailureJobModeRegister& operator = (const OnFailureJobModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnFailureJobModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnFailureJobModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnFailureJobModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnFailureJobModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const OnFailureJobModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
 */
class IgnoreOnIsolateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnoreOnIsolateUpdate ();

    /**
     * Copy constructor
     */
    inline  IgnoreOnIsolateUpdate (const IgnoreOnIsolateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IgnoreOnIsolateUpdate (bool IgnoreOnIsolate_);

    /**
     * Destructor
     */
    inline virtual  ~IgnoreOnIsolateUpdate();

    /**
     * Assignment operator
     */
    inline IgnoreOnIsolateUpdate& operator = (const IgnoreOnIsolateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnoreOnIsolateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnoreOnIsolateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnoreOnIsolateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnoreOnIsolateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IgnoreOnIsolate"

    static const int kIgnoreOnIsolate = 0;

    /**
     * Clears the field "IgnoreOnIsolate".
     *
     * The field will be set to its default value. The hasIgnoreOnIsolate()
     * method will return false.
     */
    inline void clearIgnoreOnIsolate();

    /**
     * Checks whether the field "IgnoreOnIsolate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIgnoreOnIsolate()). Otherwise it will return false.
     */
    inline bool hasIgnoreOnIsolate () const;

    /**
     * Returns the value of the member "IgnoreOnIsolate".
     *
     * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
     *
     * @return The value of the field "IgnoreOnIsolate"
     */
    inline bool getIgnoreOnIsolate () const;

    /**
     * Sets the value of the member "IgnoreOnIsolate".
     *
     * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
     *
     * @param IgnoreOnIsolate The value which will be set
     */
    inline void setIgnoreOnIsolate (bool IgnoreOnIsolate_);

    static const IgnoreOnIsolateUpdate &getDefaultInstance();

private:

    inline void set_has_IgnoreOnIsolate ();

    inline void clear_has_IgnoreOnIsolate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _IgnoreOnIsolate;

};

/**
 * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
 */
class IgnoreOnIsolateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnoreOnIsolateRegister ();

    /**
     * Copy constructor
     */
    inline  IgnoreOnIsolateRegister (const IgnoreOnIsolateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IgnoreOnIsolateRegister();

    /**
     * Assignment operator
     */
    inline IgnoreOnIsolateRegister& operator = (const IgnoreOnIsolateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnoreOnIsolateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnoreOnIsolateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnoreOnIsolateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnoreOnIsolateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IgnoreOnIsolateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
 */
class IgnoreOnSnapshotUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnoreOnSnapshotUpdate ();

    /**
     * Copy constructor
     */
    inline  IgnoreOnSnapshotUpdate (const IgnoreOnSnapshotUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IgnoreOnSnapshotUpdate (bool IgnoreOnSnapshot_);

    /**
     * Destructor
     */
    inline virtual  ~IgnoreOnSnapshotUpdate();

    /**
     * Assignment operator
     */
    inline IgnoreOnSnapshotUpdate& operator = (const IgnoreOnSnapshotUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnoreOnSnapshotUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnoreOnSnapshotUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnoreOnSnapshotUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnoreOnSnapshotUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IgnoreOnSnapshot"

    static const int kIgnoreOnSnapshot = 0;

    /**
     * Clears the field "IgnoreOnSnapshot".
     *
     * The field will be set to its default value. The hasIgnoreOnSnapshot()
     * method will return false.
     */
    inline void clearIgnoreOnSnapshot();

    /**
     * Checks whether the field "IgnoreOnSnapshot" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIgnoreOnSnapshot()). Otherwise it will return false.
     */
    inline bool hasIgnoreOnSnapshot () const;

    /**
     * Returns the value of the member "IgnoreOnSnapshot".
     *
     * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
     *
     * @return The value of the field "IgnoreOnSnapshot"
     */
    inline bool getIgnoreOnSnapshot () const;

    /**
     * Sets the value of the member "IgnoreOnSnapshot".
     *
     * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
     *
     * @param IgnoreOnSnapshot The value which will be set
     */
    inline void setIgnoreOnSnapshot (bool IgnoreOnSnapshot_);

    static const IgnoreOnSnapshotUpdate &getDefaultInstance();

private:

    inline void set_has_IgnoreOnSnapshot ();

    inline void clear_has_IgnoreOnSnapshot ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _IgnoreOnSnapshot;

};

/**
 * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
 */
class IgnoreOnSnapshotRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnoreOnSnapshotRegister ();

    /**
     * Copy constructor
     */
    inline  IgnoreOnSnapshotRegister (const IgnoreOnSnapshotRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IgnoreOnSnapshotRegister();

    /**
     * Assignment operator
     */
    inline IgnoreOnSnapshotRegister& operator = (const IgnoreOnSnapshotRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnoreOnSnapshotRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnoreOnSnapshotRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnoreOnSnapshotRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnoreOnSnapshotRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IgnoreOnSnapshotRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
 * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
 */
class NeedDaemonReloadUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NeedDaemonReloadUpdate ();

    /**
     * Copy constructor
     */
    inline  NeedDaemonReloadUpdate (const NeedDaemonReloadUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NeedDaemonReloadUpdate (bool NeedDaemonReload_);

    /**
     * Destructor
     */
    inline virtual  ~NeedDaemonReloadUpdate();

    /**
     * Assignment operator
     */
    inline NeedDaemonReloadUpdate& operator = (const NeedDaemonReloadUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NeedDaemonReloadUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NeedDaemonReloadUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NeedDaemonReloadUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NeedDaemonReloadUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NeedDaemonReload"

    static const int kNeedDaemonReload = 0;

    /**
     * Clears the field "NeedDaemonReload".
     *
     * The field will be set to its default value. The hasNeedDaemonReload()
     * method will return false.
     */
    inline void clearNeedDaemonReload();

    /**
     * Checks whether the field "NeedDaemonReload" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNeedDaemonReload()). Otherwise it will return false.
     */
    inline bool hasNeedDaemonReload () const;

    /**
     * Returns the value of the member "NeedDaemonReload".
     *
     * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
     * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
     *
     * @return The value of the field "NeedDaemonReload"
     */
    inline bool getNeedDaemonReload () const;

    /**
     * Sets the value of the member "NeedDaemonReload".
     *
     * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
     * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
     *
     * @param NeedDaemonReload The value which will be set
     */
    inline void setNeedDaemonReload (bool NeedDaemonReload_);

    static const NeedDaemonReloadUpdate &getDefaultInstance();

private:

    inline void set_has_NeedDaemonReload ();

    inline void clear_has_NeedDaemonReload ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _NeedDaemonReload;

};

/**
 * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
 * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
 */
class NeedDaemonReloadRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NeedDaemonReloadRegister ();

    /**
     * Copy constructor
     */
    inline  NeedDaemonReloadRegister (const NeedDaemonReloadRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NeedDaemonReloadRegister();

    /**
     * Assignment operator
     */
    inline NeedDaemonReloadRegister& operator = (const NeedDaemonReloadRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NeedDaemonReloadRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NeedDaemonReloadRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NeedDaemonReloadRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NeedDaemonReloadRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NeedDaemonReloadRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
 */
class JobTimeoutUSecUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JobTimeoutUSecUpdate ();

    /**
     * Copy constructor
     */
    inline  JobTimeoutUSecUpdate (const JobTimeoutUSecUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  JobTimeoutUSecUpdate (uint64 JobTimeoutUSec_);

    /**
     * Destructor
     */
    inline virtual  ~JobTimeoutUSecUpdate();

    /**
     * Assignment operator
     */
    inline JobTimeoutUSecUpdate& operator = (const JobTimeoutUSecUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JobTimeoutUSecUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JobTimeoutUSecUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JobTimeoutUSecUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JobTimeoutUSecUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobTimeoutUSec"

    static const int kJobTimeoutUSec = 0;

    /**
     * Clears the field "JobTimeoutUSec".
     *
     * The field will be set to its default value. The hasJobTimeoutUSec()
     * method will return false.
     */
    inline void clearJobTimeoutUSec();

    /**
     * Checks whether the field "JobTimeoutUSec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobTimeoutUSec()). Otherwise it will return false.
     */
    inline bool hasJobTimeoutUSec () const;

    /**
     * Returns the value of the member "JobTimeoutUSec".
     *
     * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
     *
     * @return The value of the field "JobTimeoutUSec"
     */
    inline uint64 getJobTimeoutUSec () const;

    /**
     * Sets the value of the member "JobTimeoutUSec".
     *
     * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
     *
     * @param JobTimeoutUSec The value which will be set
     */
    inline void setJobTimeoutUSec (uint64 JobTimeoutUSec_);

    static const JobTimeoutUSecUpdate &getDefaultInstance();

private:

    inline void set_has_JobTimeoutUSec ();

    inline void clear_has_JobTimeoutUSec ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _JobTimeoutUSec;

};

/**
 * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
 */
class JobTimeoutUSecRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JobTimeoutUSecRegister ();

    /**
     * Copy constructor
     */
    inline  JobTimeoutUSecRegister (const JobTimeoutUSecRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~JobTimeoutUSecRegister();

    /**
     * Assignment operator
     */
    inline JobTimeoutUSecRegister& operator = (const JobTimeoutUSecRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JobTimeoutUSecRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JobTimeoutUSecRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JobTimeoutUSecRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JobTimeoutUSecRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const JobTimeoutUSecRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * JobTimeoutAction
 */
class JobTimeoutActionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JobTimeoutActionUpdate ();

    /**
     * Copy constructor
     */
    inline  JobTimeoutActionUpdate (const JobTimeoutActionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  JobTimeoutActionUpdate (const ::std::string& JobTimeoutAction_);

    /**
     * Destructor
     */
    inline virtual  ~JobTimeoutActionUpdate();

    /**
     * Assignment operator
     */
    inline JobTimeoutActionUpdate& operator = (const JobTimeoutActionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JobTimeoutActionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JobTimeoutActionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JobTimeoutActionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JobTimeoutActionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobTimeoutAction"

    static const int kJobTimeoutAction = 0;

    /**
     * Clears the field "JobTimeoutAction".
     *
     * The field will be set to its default value. The hasJobTimeoutAction()
     * method will return false.
     */
    inline void clearJobTimeoutAction();

    /**
     * Checks whether the field "JobTimeoutAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobTimeoutAction()). Otherwise it will return false.
     */
    inline bool hasJobTimeoutAction () const;

    /**
     * Returns the value of the member "JobTimeoutAction".
     *
     * JobTimeoutAction
     *
     * @return The value of the field "JobTimeoutAction"
     */
    inline const ::std::string& getJobTimeoutAction () const;

    /**
     * Retrieves the value of the field "JobTimeoutAction" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobTimeoutAction".
     */
    inline ::std::string& getJobTimeoutActionMutable ();

    /**
     * Sets the value of the member "JobTimeoutAction".
     *
     * JobTimeoutAction
     *
     * @param JobTimeoutAction The value which will be set
     */
    inline void setJobTimeoutAction (const ::std::string& JobTimeoutAction_);

    /**
     * Sets the value of the member "JobTimeoutAction".
     *
     * JobTimeoutAction
     *
     * @param JobTimeoutAction The value which will be set
     */
    inline void setJobTimeoutAction (const char* JobTimeoutAction_);

    /**
     * Sets the value of the member "JobTimeoutAction".
     *
     * JobTimeoutAction
     *
     * @param JobTimeoutAction The value which will be set
     */
    inline void setJobTimeoutAction (const char* value, size_t size);

    static const JobTimeoutActionUpdate &getDefaultInstance();

private:

    inline void set_has_JobTimeoutAction ();

    inline void clear_has_JobTimeoutAction ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _JobTimeoutAction;

};

/**
 * JobTimeoutAction
 */
class JobTimeoutActionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JobTimeoutActionRegister ();

    /**
     * Copy constructor
     */
    inline  JobTimeoutActionRegister (const JobTimeoutActionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~JobTimeoutActionRegister();

    /**
     * Assignment operator
     */
    inline JobTimeoutActionRegister& operator = (const JobTimeoutActionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JobTimeoutActionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JobTimeoutActionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JobTimeoutActionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JobTimeoutActionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const JobTimeoutActionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * JobTimeoutRebootArgument
 */
class JobTimeoutRebootArgumentUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JobTimeoutRebootArgumentUpdate ();

    /**
     * Copy constructor
     */
    inline  JobTimeoutRebootArgumentUpdate (const JobTimeoutRebootArgumentUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  JobTimeoutRebootArgumentUpdate (const ::std::string& JobTimeoutRebootArgument_);

    /**
     * Destructor
     */
    inline virtual  ~JobTimeoutRebootArgumentUpdate();

    /**
     * Assignment operator
     */
    inline JobTimeoutRebootArgumentUpdate& operator = (const JobTimeoutRebootArgumentUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JobTimeoutRebootArgumentUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JobTimeoutRebootArgumentUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JobTimeoutRebootArgumentUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JobTimeoutRebootArgumentUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobTimeoutRebootArgument"

    static const int kJobTimeoutRebootArgument = 0;

    /**
     * Clears the field "JobTimeoutRebootArgument".
     *
     * The field will be set to its default value. The hasJobTimeoutRebootArgument()
     * method will return false.
     */
    inline void clearJobTimeoutRebootArgument();

    /**
     * Checks whether the field "JobTimeoutRebootArgument" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobTimeoutRebootArgument()). Otherwise it will return false.
     */
    inline bool hasJobTimeoutRebootArgument () const;

    /**
     * Returns the value of the member "JobTimeoutRebootArgument".
     *
     * JobTimeoutRebootArgument
     *
     * @return The value of the field "JobTimeoutRebootArgument"
     */
    inline const ::std::string& getJobTimeoutRebootArgument () const;

    /**
     * Retrieves the value of the field "JobTimeoutRebootArgument" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobTimeoutRebootArgument".
     */
    inline ::std::string& getJobTimeoutRebootArgumentMutable ();

    /**
     * Sets the value of the member "JobTimeoutRebootArgument".
     *
     * JobTimeoutRebootArgument
     *
     * @param JobTimeoutRebootArgument The value which will be set
     */
    inline void setJobTimeoutRebootArgument (const ::std::string& JobTimeoutRebootArgument_);

    /**
     * Sets the value of the member "JobTimeoutRebootArgument".
     *
     * JobTimeoutRebootArgument
     *
     * @param JobTimeoutRebootArgument The value which will be set
     */
    inline void setJobTimeoutRebootArgument (const char* JobTimeoutRebootArgument_);

    /**
     * Sets the value of the member "JobTimeoutRebootArgument".
     *
     * JobTimeoutRebootArgument
     *
     * @param JobTimeoutRebootArgument The value which will be set
     */
    inline void setJobTimeoutRebootArgument (const char* value, size_t size);

    static const JobTimeoutRebootArgumentUpdate &getDefaultInstance();

private:

    inline void set_has_JobTimeoutRebootArgument ();

    inline void clear_has_JobTimeoutRebootArgument ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _JobTimeoutRebootArgument;

};

/**
 * JobTimeoutRebootArgument
 */
class JobTimeoutRebootArgumentRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JobTimeoutRebootArgumentRegister ();

    /**
     * Copy constructor
     */
    inline  JobTimeoutRebootArgumentRegister (const JobTimeoutRebootArgumentRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~JobTimeoutRebootArgumentRegister();

    /**
     * Assignment operator
     */
    inline JobTimeoutRebootArgumentRegister& operator = (const JobTimeoutRebootArgumentRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JobTimeoutRebootArgumentRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JobTimeoutRebootArgumentRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JobTimeoutRebootArgumentRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JobTimeoutRebootArgumentRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const JobTimeoutRebootArgumentRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ConditionResult contains the condition result of the last time the configured
 * 		conditions of this unit were checked.
 */
class ConditionResultUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConditionResultUpdate ();

    /**
     * Copy constructor
     */
    inline  ConditionResultUpdate (const ConditionResultUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConditionResultUpdate (bool ConditionResult_);

    /**
     * Destructor
     */
    inline virtual  ~ConditionResultUpdate();

    /**
     * Assignment operator
     */
    inline ConditionResultUpdate& operator = (const ConditionResultUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConditionResultUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConditionResultUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConditionResultUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConditionResultUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConditionResult"

    static const int kConditionResult = 0;

    /**
     * Clears the field "ConditionResult".
     *
     * The field will be set to its default value. The hasConditionResult()
     * method will return false.
     */
    inline void clearConditionResult();

    /**
     * Checks whether the field "ConditionResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConditionResult()). Otherwise it will return false.
     */
    inline bool hasConditionResult () const;

    /**
     * Returns the value of the member "ConditionResult".
     *
     * ConditionResult contains the condition result of the last time the configured
     * 		conditions of this unit were checked.
     *
     * @return The value of the field "ConditionResult"
     */
    inline bool getConditionResult () const;

    /**
     * Sets the value of the member "ConditionResult".
     *
     * ConditionResult contains the condition result of the last time the configured
     * 		conditions of this unit were checked.
     *
     * @param ConditionResult The value which will be set
     */
    inline void setConditionResult (bool ConditionResult_);

    static const ConditionResultUpdate &getDefaultInstance();

private:

    inline void set_has_ConditionResult ();

    inline void clear_has_ConditionResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _ConditionResult;

};

/**
 * ConditionResult contains the condition result of the last time the configured
 * 		conditions of this unit were checked.
 */
class ConditionResultRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConditionResultRegister ();

    /**
     * Copy constructor
     */
    inline  ConditionResultRegister (const ConditionResultRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConditionResultRegister();

    /**
     * Assignment operator
     */
    inline ConditionResultRegister& operator = (const ConditionResultRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConditionResultRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConditionResultRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConditionResultRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConditionResultRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConditionResultRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * AssertResult
 */
class AssertResultUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AssertResultUpdate ();

    /**
     * Copy constructor
     */
    inline  AssertResultUpdate (const AssertResultUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AssertResultUpdate (bool AssertResult_);

    /**
     * Destructor
     */
    inline virtual  ~AssertResultUpdate();

    /**
     * Assignment operator
     */
    inline AssertResultUpdate& operator = (const AssertResultUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AssertResultUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AssertResultUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AssertResultUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AssertResultUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AssertResult"

    static const int kAssertResult = 0;

    /**
     * Clears the field "AssertResult".
     *
     * The field will be set to its default value. The hasAssertResult()
     * method will return false.
     */
    inline void clearAssertResult();

    /**
     * Checks whether the field "AssertResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAssertResult()). Otherwise it will return false.
     */
    inline bool hasAssertResult () const;

    /**
     * Returns the value of the member "AssertResult".
     *
     * AssertResult
     *
     * @return The value of the field "AssertResult"
     */
    inline bool getAssertResult () const;

    /**
     * Sets the value of the member "AssertResult".
     *
     * AssertResult
     *
     * @param AssertResult The value which will be set
     */
    inline void setAssertResult (bool AssertResult_);

    static const AssertResultUpdate &getDefaultInstance();

private:

    inline void set_has_AssertResult ();

    inline void clear_has_AssertResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _AssertResult;

};

/**
 * AssertResult
 */
class AssertResultRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AssertResultRegister ();

    /**
     * Copy constructor
     */
    inline  AssertResultRegister (const AssertResultRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AssertResultRegister();

    /**
     * Assignment operator
     */
    inline AssertResultRegister& operator = (const AssertResultRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AssertResultRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AssertResultRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AssertResultRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AssertResultRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AssertResultRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
 * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
 */
class ConditionTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConditionTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  ConditionTimestampUpdate (const ConditionTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConditionTimestampUpdate (uint64 ConditionTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~ConditionTimestampUpdate();

    /**
     * Assignment operator
     */
    inline ConditionTimestampUpdate& operator = (const ConditionTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConditionTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConditionTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConditionTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConditionTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConditionTimestamp"

    static const int kConditionTimestamp = 0;

    /**
     * Clears the field "ConditionTimestamp".
     *
     * The field will be set to its default value. The hasConditionTimestamp()
     * method will return false.
     */
    inline void clearConditionTimestamp();

    /**
     * Checks whether the field "ConditionTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConditionTimestamp()). Otherwise it will return false.
     */
    inline bool hasConditionTimestamp () const;

    /**
     * Returns the value of the member "ConditionTimestamp".
     *
     * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     *
     * @return The value of the field "ConditionTimestamp"
     */
    inline uint64 getConditionTimestamp () const;

    /**
     * Sets the value of the member "ConditionTimestamp".
     *
     * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     *
     * @param ConditionTimestamp The value which will be set
     */
    inline void setConditionTimestamp (uint64 ConditionTimestamp_);

    static const ConditionTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_ConditionTimestamp ();

    inline void clear_has_ConditionTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _ConditionTimestamp;

};

/**
 * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
 * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
 */
class ConditionTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConditionTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  ConditionTimestampRegister (const ConditionTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConditionTimestampRegister();

    /**
     * Assignment operator
     */
    inline ConditionTimestampRegister& operator = (const ConditionTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConditionTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConditionTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConditionTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConditionTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConditionTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
 * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
 */
class ConditionTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConditionTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  ConditionTimestampMonotonicUpdate (const ConditionTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConditionTimestampMonotonicUpdate (uint64 ConditionTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~ConditionTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline ConditionTimestampMonotonicUpdate& operator = (const ConditionTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConditionTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConditionTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConditionTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConditionTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConditionTimestampMonotonic"

    static const int kConditionTimestampMonotonic = 0;

    /**
     * Clears the field "ConditionTimestampMonotonic".
     *
     * The field will be set to its default value. The hasConditionTimestampMonotonic()
     * method will return false.
     */
    inline void clearConditionTimestampMonotonic();

    /**
     * Checks whether the field "ConditionTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConditionTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasConditionTimestampMonotonic () const;

    /**
     * Returns the value of the member "ConditionTimestampMonotonic".
     *
     * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     *
     * @return The value of the field "ConditionTimestampMonotonic"
     */
    inline uint64 getConditionTimestampMonotonic () const;

    /**
     * Sets the value of the member "ConditionTimestampMonotonic".
     *
     * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     *
     * @param ConditionTimestampMonotonic The value which will be set
     */
    inline void setConditionTimestampMonotonic (uint64 ConditionTimestampMonotonic_);

    static const ConditionTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_ConditionTimestampMonotonic ();

    inline void clear_has_ConditionTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _ConditionTimestampMonotonic;

};

/**
 * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
 * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
 */
class ConditionTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConditionTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  ConditionTimestampMonotonicRegister (const ConditionTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConditionTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline ConditionTimestampMonotonicRegister& operator = (const ConditionTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConditionTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConditionTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConditionTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConditionTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConditionTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * AssertTimestamp
 */
class AssertTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AssertTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  AssertTimestampUpdate (const AssertTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AssertTimestampUpdate (uint64 AssertTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~AssertTimestampUpdate();

    /**
     * Assignment operator
     */
    inline AssertTimestampUpdate& operator = (const AssertTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AssertTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AssertTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AssertTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AssertTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AssertTimestamp"

    static const int kAssertTimestamp = 0;

    /**
     * Clears the field "AssertTimestamp".
     *
     * The field will be set to its default value. The hasAssertTimestamp()
     * method will return false.
     */
    inline void clearAssertTimestamp();

    /**
     * Checks whether the field "AssertTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAssertTimestamp()). Otherwise it will return false.
     */
    inline bool hasAssertTimestamp () const;

    /**
     * Returns the value of the member "AssertTimestamp".
     *
     * AssertTimestamp
     *
     * @return The value of the field "AssertTimestamp"
     */
    inline uint64 getAssertTimestamp () const;

    /**
     * Sets the value of the member "AssertTimestamp".
     *
     * AssertTimestamp
     *
     * @param AssertTimestamp The value which will be set
     */
    inline void setAssertTimestamp (uint64 AssertTimestamp_);

    static const AssertTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_AssertTimestamp ();

    inline void clear_has_AssertTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _AssertTimestamp;

};

/**
 * AssertTimestamp
 */
class AssertTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AssertTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  AssertTimestampRegister (const AssertTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AssertTimestampRegister();

    /**
     * Assignment operator
     */
    inline AssertTimestampRegister& operator = (const AssertTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AssertTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AssertTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AssertTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AssertTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AssertTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * AssertTimestampMonotonic
 */
class AssertTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AssertTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  AssertTimestampMonotonicUpdate (const AssertTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AssertTimestampMonotonicUpdate (uint64 AssertTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~AssertTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline AssertTimestampMonotonicUpdate& operator = (const AssertTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AssertTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AssertTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AssertTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AssertTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AssertTimestampMonotonic"

    static const int kAssertTimestampMonotonic = 0;

    /**
     * Clears the field "AssertTimestampMonotonic".
     *
     * The field will be set to its default value. The hasAssertTimestampMonotonic()
     * method will return false.
     */
    inline void clearAssertTimestampMonotonic();

    /**
     * Checks whether the field "AssertTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAssertTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasAssertTimestampMonotonic () const;

    /**
     * Returns the value of the member "AssertTimestampMonotonic".
     *
     * AssertTimestampMonotonic
     *
     * @return The value of the field "AssertTimestampMonotonic"
     */
    inline uint64 getAssertTimestampMonotonic () const;

    /**
     * Sets the value of the member "AssertTimestampMonotonic".
     *
     * AssertTimestampMonotonic
     *
     * @param AssertTimestampMonotonic The value which will be set
     */
    inline void setAssertTimestampMonotonic (uint64 AssertTimestampMonotonic_);

    static const AssertTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_AssertTimestampMonotonic ();

    inline void clear_has_AssertTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _AssertTimestampMonotonic;

};

/**
 * AssertTimestampMonotonic
 */
class AssertTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AssertTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  AssertTimestampMonotonicRegister (const AssertTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AssertTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline AssertTimestampMonotonicRegister& operator = (const AssertTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AssertTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AssertTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AssertTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AssertTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AssertTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
 * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
 * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
 * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
 */
class ConditionsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConditionsUpdate ();

    /**
     * Copy constructor
     */
    inline  ConditionsUpdate (const ConditionsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConditionsUpdate (const ::std::vector< condition >& Conditions_);

    /**
     * Destructor
     */
    inline virtual  ~ConditionsUpdate();

    /**
     * Assignment operator
     */
    inline ConditionsUpdate& operator = (const ConditionsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConditionsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConditionsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConditionsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConditionsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Conditions"

    static const int kConditions = 0;

    /**
     * Clears the field "Conditions".
     *
     * The field will be set to its default value. The hasConditions()
     * method will return false.
     */
    inline void clearConditions();

    /**
     * Checks whether the field "Conditions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConditions()). Otherwise it will return false.
     */
    inline bool hasConditions () const;

    /**
     * Returns the value of the member "Conditions".
     *
     * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
     * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
     * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
     * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
     *
     * @return The value of the field "Conditions"
     */
    inline const ::std::vector< condition >& getConditions () const;

    /**
     * Retrieves the value of the field "Conditions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Conditions".
     */
    inline ::std::vector< condition >& getConditionsMutable ();

    /**
     * Sets the value of the member "Conditions".
     *
     * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
     * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
     * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
     * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
     *
     * @param Conditions The value which will be set
     */
    inline void setConditions (const ::std::vector< condition >& Conditions_);

    static const ConditionsUpdate &getDefaultInstance();

private:

    static const ::std::vector< condition >& getConditionList_DefaultInstance ();

    inline void set_has_Conditions ();

    inline void clear_has_Conditions ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< condition > _Conditions;

};

/**
 * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
 * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
 * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
 * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
 */
class ConditionsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConditionsRegister ();

    /**
     * Copy constructor
     */
    inline  ConditionsRegister (const ConditionsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConditionsRegister();

    /**
     * Assignment operator
     */
    inline ConditionsRegister& operator = (const ConditionsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConditionsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConditionsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConditionsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConditionsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConditionsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Asserts
 */
class AssertsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AssertsUpdate ();

    /**
     * Copy constructor
     */
    inline  AssertsUpdate (const AssertsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AssertsUpdate (const ::std::vector< condition >& Asserts_);

    /**
     * Destructor
     */
    inline virtual  ~AssertsUpdate();

    /**
     * Assignment operator
     */
    inline AssertsUpdate& operator = (const AssertsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AssertsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AssertsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AssertsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AssertsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Asserts"

    static const int kAsserts = 0;

    /**
     * Clears the field "Asserts".
     *
     * The field will be set to its default value. The hasAsserts()
     * method will return false.
     */
    inline void clearAsserts();

    /**
     * Checks whether the field "Asserts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAsserts()). Otherwise it will return false.
     */
    inline bool hasAsserts () const;

    /**
     * Returns the value of the member "Asserts".
     *
     * Asserts
     *
     * @return The value of the field "Asserts"
     */
    inline const ::std::vector< condition >& getAsserts () const;

    /**
     * Retrieves the value of the field "Asserts" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Asserts".
     */
    inline ::std::vector< condition >& getAssertsMutable ();

    /**
     * Sets the value of the member "Asserts".
     *
     * Asserts
     *
     * @param Asserts The value which will be set
     */
    inline void setAsserts (const ::std::vector< condition >& Asserts_);

    static const AssertsUpdate &getDefaultInstance();

private:

    static const ::std::vector< condition >& getConditionList_DefaultInstance ();

    inline void set_has_Asserts ();

    inline void clear_has_Asserts ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< condition > _Asserts;

};

/**
 * Asserts
 */
class AssertsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AssertsRegister ();

    /**
     * Copy constructor
     */
    inline  AssertsRegister (const AssertsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AssertsRegister();

    /**
     * Assignment operator
     */
    inline AssertsRegister& operator = (const AssertsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AssertsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AssertsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AssertsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AssertsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AssertsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
 * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
 * 		If it succeeded to load this will be a pair of empty strings.
 */
class LoadErrorUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoadErrorUpdate ();

    /**
     * Copy constructor
     */
    inline  LoadErrorUpdate (const LoadErrorUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  LoadErrorUpdate (const loadError& LoadError_);

    /**
     * Destructor
     */
    inline virtual  ~LoadErrorUpdate();

    /**
     * Assignment operator
     */
    inline LoadErrorUpdate& operator = (const LoadErrorUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoadErrorUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoadErrorUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoadErrorUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoadErrorUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LoadError"

    static const int kLoadError = 0;

    /**
     * Clears the field "LoadError".
     *
     * The field will be set to its default value. The hasLoadError()
     * method will return false.
     */
    inline void clearLoadError();

    /**
     * Checks whether the field "LoadError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoadError()). Otherwise it will return false.
     */
    inline bool hasLoadError () const;

    /**
     * Returns the value of the member "LoadError".
     *
     * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
     * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
     * 		If it succeeded to load this will be a pair of empty strings.
     *
     * @return The value of the field "LoadError"
     */
    inline const loadError& getLoadError () const;

    /**
     * Retrieves the value of the field "LoadError" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LoadError".
     */
    inline loadError& getLoadErrorMutable ();

    /**
     * Sets the value of the member "LoadError".
     *
     * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
     * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
     * 		If it succeeded to load this will be a pair of empty strings.
     *
     * @param LoadError The value which will be set
     */
    inline void setLoadError (const loadError& LoadError_);

    static const LoadErrorUpdate &getDefaultInstance();

private:

    inline void set_has_LoadError ();

    inline void clear_has_LoadError ();

    uint32 _has_bits_[ (1 + 31) / 32];

    loadError _LoadError;

};

/**
 * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
 * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
 * 		If it succeeded to load this will be a pair of empty strings.
 */
class LoadErrorRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoadErrorRegister ();

    /**
     * Copy constructor
     */
    inline  LoadErrorRegister (const LoadErrorRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~LoadErrorRegister();

    /**
     * Assignment operator
     */
    inline LoadErrorRegister& operator = (const LoadErrorRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoadErrorRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoadErrorRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoadErrorRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoadErrorRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const LoadErrorRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Transient contains a boolean that indicates whether the unit was created as transient unit
 * 		(i.e. via CreateTransientUnit() on the manager object).
 */
class TransientUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransientUpdate ();

    /**
     * Copy constructor
     */
    inline  TransientUpdate (const TransientUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TransientUpdate (bool Transient_);

    /**
     * Destructor
     */
    inline virtual  ~TransientUpdate();

    /**
     * Assignment operator
     */
    inline TransientUpdate& operator = (const TransientUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransientUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransientUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransientUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransientUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Transient"

    static const int kTransient = 0;

    /**
     * Clears the field "Transient".
     *
     * The field will be set to its default value. The hasTransient()
     * method will return false.
     */
    inline void clearTransient();

    /**
     * Checks whether the field "Transient" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransient()). Otherwise it will return false.
     */
    inline bool hasTransient () const;

    /**
     * Returns the value of the member "Transient".
     *
     * Transient contains a boolean that indicates whether the unit was created as transient unit
     * 		(i.e. via CreateTransientUnit() on the manager object).
     *
     * @return The value of the field "Transient"
     */
    inline bool getTransient () const;

    /**
     * Sets the value of the member "Transient".
     *
     * Transient contains a boolean that indicates whether the unit was created as transient unit
     * 		(i.e. via CreateTransientUnit() on the manager object).
     *
     * @param Transient The value which will be set
     */
    inline void setTransient (bool Transient_);

    static const TransientUpdate &getDefaultInstance();

private:

    inline void set_has_Transient ();

    inline void clear_has_Transient ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Transient;

};

/**
 * Transient contains a boolean that indicates whether the unit was created as transient unit
 * 		(i.e. via CreateTransientUnit() on the manager object).
 */
class TransientRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransientRegister ();

    /**
     * Copy constructor
     */
    inline  TransientRegister (const TransientRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TransientRegister();

    /**
     * Assignment operator
     */
    inline TransientRegister& operator = (const TransientRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransientRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransientRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransientRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransientRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TransientRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  job::job ()  :
    _jobId (0u),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  job::job (const job &rhs)  :
    _jobId (0u),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  job::job (uint32 jobId_, const ::std::string& path_)  :
    _jobId (jobId_),
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  job::~job() {
}

inline job& job::operator = (const job& rhs) {
    if( this != &rhs ) {
        if (rhs.hasJobId()) {
            setJobId(rhs.getJobId());
        } else {
            clearJobId();
        }
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool job::operator == (const job& rhs) const {
    return (((!hasJobId() && !rhs.hasJobId()) || getJobId() == rhs.getJobId()) &&
        ((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool job::operator != (const job& rhs) const {
    return ! (*this == rhs);
}

inline bool job::operator < (const job& rhs) const {
    if (hasJobId() || rhs.hasJobId()) {
        if (getJobId() < rhs.getJobId()) return true;
        if (getJobId() > rhs.getJobId()) return false;
    }
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline bool job::operator > (const job& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void job::clear() {
    clearJobId();
    clearPath();
}

inline void job::clearJobId() {
    if (hasJobId()) {
         clear_has_jobId();
        _jobId = 0u;
     }
}

inline bool job::hasJobId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 job::getJobId () const {
    return _jobId;
}

inline void job::setJobId (uint32 jobId_) {
    set_has_jobId();
    this->_jobId = jobId_;
}

inline void job::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool job::hasPath () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& job::getPath () const {
    return _path;
}

inline ::std::string& job::getPathMutable () {
    set_has_path();
    return _path;
}

inline void job::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void job::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void job::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void job::set_has_jobId () {
    _has_bits_[0] |= 1u << 0;
}

inline void job::clear_has_jobId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void job::set_has_path () {
    _has_bits_[0] |= 1u << 1;
}

inline void job::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  condition::condition ()  :
    _type (),
    _triggerCondition (false),
    _reverseCondition (false),
    _path (),
    _status (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  condition::condition (const condition &rhs)  :
    _type (),
    _triggerCondition (false),
    _reverseCondition (false),
    _path (),
    _status (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  condition::condition (const ::std::string& type_, bool triggerCondition_, bool reverseCondition_, const ::std::string& path_, int32 status_)  :
    _type (type_),
    _triggerCondition (triggerCondition_),
    _reverseCondition (reverseCondition_),
    _path (path_),
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (type_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  condition::~condition() {
}

inline condition& condition::operator = (const condition& rhs) {
    if( this != &rhs ) {
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
        if (rhs.hasTriggerCondition()) {
            setTriggerCondition(rhs.getTriggerCondition());
        } else {
            clearTriggerCondition();
        }
        if (rhs.hasReverseCondition()) {
            setReverseCondition(rhs.getReverseCondition());
        } else {
            clearReverseCondition();
        }
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool condition::operator == (const condition& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()) &&
        ((!hasTriggerCondition() && !rhs.hasTriggerCondition()) || getTriggerCondition() == rhs.getTriggerCondition()) &&
        ((!hasReverseCondition() && !rhs.hasReverseCondition()) || getReverseCondition() == rhs.getReverseCondition()) &&
        ((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool condition::operator != (const condition& rhs) const {
    return ! (*this == rhs);
}

inline bool condition::operator < (const condition& rhs) const {
    if (hasType() || rhs.hasType()) {
        if (getType() < rhs.getType()) return true;
        if (getType() > rhs.getType()) return false;
    }
    if (hasTriggerCondition() || rhs.hasTriggerCondition()) {
        if (getTriggerCondition() < rhs.getTriggerCondition()) return true;
        if (getTriggerCondition() > rhs.getTriggerCondition()) return false;
    }
    if (hasReverseCondition() || rhs.hasReverseCondition()) {
        if (getReverseCondition() < rhs.getReverseCondition()) return true;
        if (getReverseCondition() > rhs.getReverseCondition()) return false;
    }
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline bool condition::operator > (const condition& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void condition::clear() {
    clearType();
    clearTriggerCondition();
    clearReverseCondition();
    clearPath();
    clearStatus();
}

inline void condition::clearType() {
    if (hasType()) {
         clear_has_type();
        _type.clear();
     }
}

inline bool condition::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& condition::getType () const {
    return _type;
}

inline ::std::string& condition::getTypeMutable () {
    set_has_type();
    return _type;
}

inline void condition::setType (const ::std::string& type_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (type_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_type();
    this->_type = type_;
}

inline void condition::setType (const char* type_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (type_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_type();
    this->_type.assign(type_);
}

inline void condition::setType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_type();
    this->_type.assign(value, size);
}

inline void condition::clearTriggerCondition() {
    if (hasTriggerCondition()) {
         clear_has_triggerCondition();
        _triggerCondition = false;
     }
}

inline bool condition::hasTriggerCondition () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool condition::getTriggerCondition () const {
    return _triggerCondition;
}

inline void condition::setTriggerCondition (bool triggerCondition_) {
    set_has_triggerCondition();
    this->_triggerCondition = triggerCondition_;
}

inline void condition::clearReverseCondition() {
    if (hasReverseCondition()) {
         clear_has_reverseCondition();
        _reverseCondition = false;
     }
}

inline bool condition::hasReverseCondition () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool condition::getReverseCondition () const {
    return _reverseCondition;
}

inline void condition::setReverseCondition (bool reverseCondition_) {
    set_has_reverseCondition();
    this->_reverseCondition = reverseCondition_;
}

inline void condition::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool condition::hasPath () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& condition::getPath () const {
    return _path;
}

inline ::std::string& condition::getPathMutable () {
    set_has_path();
    return _path;
}

inline void condition::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void condition::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void condition::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void condition::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0;
     }
}

inline bool condition::hasStatus () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int32 condition::getStatus () const {
    return _status;
}

inline void condition::setStatus (int32 status_) {
    set_has_status();
    this->_status = status_;
}

inline void condition::set_has_type () {
    _has_bits_[0] |= 1u << 0;
}

inline void condition::clear_has_type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void condition::set_has_triggerCondition () {
    _has_bits_[0] |= 1u << 1;
}

inline void condition::clear_has_triggerCondition () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void condition::set_has_reverseCondition () {
    _has_bits_[0] |= 1u << 2;
}

inline void condition::clear_has_reverseCondition () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void condition::set_has_path () {
    _has_bits_[0] |= 1u << 3;
}

inline void condition::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void condition::set_has_status () {
    _has_bits_[0] |= 1u << 4;
}

inline void condition::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  loadError::loadError ()  :
    _errorId (),
    _errorName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  loadError::loadError (const loadError &rhs)  :
    _errorId (),
    _errorName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  loadError::loadError (const ::std::string& errorId_, const ::std::string& errorName_)  :
    _errorId (errorId_),
    _errorName (errorName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (errorId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (errorName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  loadError::~loadError() {
}

inline loadError& loadError::operator = (const loadError& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorId()) {
            setErrorId(rhs.getErrorId());
        } else {
            clearErrorId();
        }
        if (rhs.hasErrorName()) {
            setErrorName(rhs.getErrorName());
        } else {
            clearErrorName();
        }
    }
    return *this;
}

inline bool loadError::operator == (const loadError& rhs) const {
    return (((!hasErrorId() && !rhs.hasErrorId()) || getErrorId() == rhs.getErrorId()) &&
        ((!hasErrorName() && !rhs.hasErrorName()) || getErrorName() == rhs.getErrorName()));
}

inline bool loadError::operator != (const loadError& rhs) const {
    return ! (*this == rhs);
}

inline bool loadError::operator < (const loadError& rhs) const {
    if (hasErrorId() || rhs.hasErrorId()) {
        if (getErrorId() < rhs.getErrorId()) return true;
        if (getErrorId() > rhs.getErrorId()) return false;
    }
    if (hasErrorName() || rhs.hasErrorName()) {
        if (getErrorName() < rhs.getErrorName()) return true;
        if (getErrorName() > rhs.getErrorName()) return false;
    }
    return false;
}

inline bool loadError::operator > (const loadError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void loadError::clear() {
    clearErrorId();
    clearErrorName();
}

inline void loadError::clearErrorId() {
    if (hasErrorId()) {
         clear_has_errorId();
        _errorId.clear();
     }
}

inline bool loadError::hasErrorId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& loadError::getErrorId () const {
    return _errorId;
}

inline ::std::string& loadError::getErrorIdMutable () {
    set_has_errorId();
    return _errorId;
}

inline void loadError::setErrorId (const ::std::string& errorId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (errorId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_errorId();
    this->_errorId = errorId_;
}

inline void loadError::setErrorId (const char* errorId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (errorId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_errorId();
    this->_errorId.assign(errorId_);
}

inline void loadError::setErrorId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_errorId();
    this->_errorId.assign(value, size);
}

inline void loadError::clearErrorName() {
    if (hasErrorName()) {
         clear_has_errorName();
        _errorName.clear();
     }
}

inline bool loadError::hasErrorName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& loadError::getErrorName () const {
    return _errorName;
}

inline ::std::string& loadError::getErrorNameMutable () {
    set_has_errorName();
    return _errorName;
}

inline void loadError::setErrorName (const ::std::string& errorName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (errorName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_errorName();
    this->_errorName = errorName_;
}

inline void loadError::setErrorName (const char* errorName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (errorName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_errorName();
    this->_errorName.assign(errorName_);
}

inline void loadError::setErrorName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_errorName();
    this->_errorName.assign(value, size);
}

inline void loadError::set_has_errorId () {
    _has_bits_[0] |= 1u << 0;
}

inline void loadError::clear_has_errorId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void loadError::set_has_errorName () {
    _has_bits_[0] |= 1u << 1;
}

inline void loadError::clear_has_errorName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  property::property ()  :
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  property::property (const property &rhs)  :
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  property::property (const ::std::string& name_, const ::std::string& value_)  :
    _name (name_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  property::~property() {
}

inline property& property::operator = (const property& rhs) {
    if( this != &rhs ) {
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool property::operator == (const property& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool property::operator != (const property& rhs) const {
    return ! (*this == rhs);
}

inline bool property::operator < (const property& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline bool property::operator > (const property& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void property::clear() {
    clearName();
    clearValue();
}

inline void property::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool property::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& property::getName () const {
    return _name;
}

inline ::std::string& property::getNameMutable () {
    set_has_name();
    return _name;
}

inline void property::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void property::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void property::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void property::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value.clear();
     }
}

inline bool property::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& property::getValue () const {
    return _value;
}

inline ::std::string& property::getValueMutable () {
    set_has_value();
    return _value;
}

inline void property::setValue (const ::std::string& value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value = value_;
}

inline void property::setValue (const char* value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value.assign(value_);
}

inline void property::setValue (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value.assign(value, size);
}

inline void property::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void property::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void property::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void property::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StartRequest::StartRequest ()  :
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartRequest::StartRequest (const StartRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartRequest::StartRequest (const ::std::string& mode_)  :
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartRequest::~StartRequest() {
}

inline StartRequest& StartRequest::operator = (const StartRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool StartRequest::operator == (const StartRequest& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool StartRequest::operator != (const StartRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartRequest::operator < (const StartRequest& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartRequest::clone() {
    return new StartRequest(*this);
}

inline bool StartRequest::operator > (const StartRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartRequest::clear() {
    clearMode();
}

inline void StartRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool StartRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartRequest::getMode () const {
    return _mode;
}

inline ::std::string& StartRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void StartRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void StartRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void StartRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void StartRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartResponse::StartResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartResponse::StartResponse (const StartResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartResponse::StartResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartResponse::~StartResponse() {
}

inline StartResponse& StartResponse::operator = (const StartResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool StartResponse::operator == (const StartResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool StartResponse::operator != (const StartResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool StartResponse::operator < (const StartResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartResponse::clone() {
    return new StartResponse(*this);
}

inline bool StartResponse::operator > (const StartResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartResponse::clear() {
    clearJob();
}

inline void StartResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool StartResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartResponse::getJob () const {
    return _job;
}

inline ::std::string& StartResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void StartResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void StartResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void StartResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void StartResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StopRequest::StopRequest ()  :
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopRequest::StopRequest (const StopRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopRequest::StopRequest (const ::std::string& mode_)  :
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StopRequest::~StopRequest() {
}

inline StopRequest& StopRequest::operator = (const StopRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool StopRequest::operator == (const StopRequest& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool StopRequest::operator != (const StopRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StopRequest::operator < (const StopRequest& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StopRequest::clone() {
    return new StopRequest(*this);
}

inline bool StopRequest::operator > (const StopRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopRequest::clear() {
    clearMode();
}

inline void StopRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool StopRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StopRequest::getMode () const {
    return _mode;
}

inline ::std::string& StopRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void StopRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void StopRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void StopRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void StopRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void StopRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StopResponse::StopResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopResponse::StopResponse (const StopResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopResponse::StopResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StopResponse::~StopResponse() {
}

inline StopResponse& StopResponse::operator = (const StopResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool StopResponse::operator == (const StopResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool StopResponse::operator != (const StopResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool StopResponse::operator < (const StopResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StopResponse::clone() {
    return new StopResponse(*this);
}

inline bool StopResponse::operator > (const StopResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopResponse::clear() {
    clearJob();
}

inline void StopResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool StopResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StopResponse::getJob () const {
    return _job;
}

inline ::std::string& StopResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void StopResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void StopResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void StopResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void StopResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void StopResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReloadRequest::ReloadRequest ()  :
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadRequest::ReloadRequest (const ReloadRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadRequest::ReloadRequest (const ::std::string& mode_)  :
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadRequest::~ReloadRequest() {
}

inline ReloadRequest& ReloadRequest::operator = (const ReloadRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool ReloadRequest::operator == (const ReloadRequest& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool ReloadRequest::operator != (const ReloadRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadRequest::operator < (const ReloadRequest& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadRequest::clone() {
    return new ReloadRequest(*this);
}

inline bool ReloadRequest::operator > (const ReloadRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadRequest::clear() {
    clearMode();
}

inline void ReloadRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool ReloadRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReloadRequest::getMode () const {
    return _mode;
}

inline ::std::string& ReloadRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void ReloadRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void ReloadRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void ReloadRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void ReloadRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReloadResponse::ReloadResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadResponse::ReloadResponse (const ReloadResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadResponse::ReloadResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadResponse::~ReloadResponse() {
}

inline ReloadResponse& ReloadResponse::operator = (const ReloadResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool ReloadResponse::operator == (const ReloadResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool ReloadResponse::operator != (const ReloadResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadResponse::operator < (const ReloadResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadResponse::clone() {
    return new ReloadResponse(*this);
}

inline bool ReloadResponse::operator > (const ReloadResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadResponse::clear() {
    clearJob();
}

inline void ReloadResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool ReloadResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReloadResponse::getJob () const {
    return _job;
}

inline ::std::string& ReloadResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void ReloadResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void ReloadResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void ReloadResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void ReloadResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestartRequest::RestartRequest ()  :
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestartRequest::RestartRequest (const RestartRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestartRequest::RestartRequest (const ::std::string& mode_)  :
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestartRequest::~RestartRequest() {
}

inline RestartRequest& RestartRequest::operator = (const RestartRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool RestartRequest::operator == (const RestartRequest& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool RestartRequest::operator != (const RestartRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RestartRequest::operator < (const RestartRequest& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RestartRequest::clone() {
    return new RestartRequest(*this);
}

inline bool RestartRequest::operator > (const RestartRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestartRequest::clear() {
    clearMode();
}

inline void RestartRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool RestartRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RestartRequest::getMode () const {
    return _mode;
}

inline ::std::string& RestartRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void RestartRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void RestartRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void RestartRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void RestartRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestartRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestartResponse::RestartResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestartResponse::RestartResponse (const RestartResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestartResponse::RestartResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestartResponse::~RestartResponse() {
}

inline RestartResponse& RestartResponse::operator = (const RestartResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool RestartResponse::operator == (const RestartResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool RestartResponse::operator != (const RestartResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RestartResponse::operator < (const RestartResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RestartResponse::clone() {
    return new RestartResponse(*this);
}

inline bool RestartResponse::operator > (const RestartResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestartResponse::clear() {
    clearJob();
}

inline void RestartResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool RestartResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RestartResponse::getJob () const {
    return _job;
}

inline ::std::string& RestartResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void RestartResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void RestartResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void RestartResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void RestartResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestartResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TryRestartRequest::TryRestartRequest ()  :
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TryRestartRequest::TryRestartRequest (const TryRestartRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TryRestartRequest::TryRestartRequest (const ::std::string& mode_)  :
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TryRestartRequest::~TryRestartRequest() {
}

inline TryRestartRequest& TryRestartRequest::operator = (const TryRestartRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool TryRestartRequest::operator == (const TryRestartRequest& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool TryRestartRequest::operator != (const TryRestartRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool TryRestartRequest::operator < (const TryRestartRequest& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TryRestartRequest::clone() {
    return new TryRestartRequest(*this);
}

inline bool TryRestartRequest::operator > (const TryRestartRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TryRestartRequest::clear() {
    clearMode();
}

inline void TryRestartRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool TryRestartRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TryRestartRequest::getMode () const {
    return _mode;
}

inline ::std::string& TryRestartRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void TryRestartRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void TryRestartRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void TryRestartRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void TryRestartRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void TryRestartRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TryRestartResponse::TryRestartResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TryRestartResponse::TryRestartResponse (const TryRestartResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TryRestartResponse::TryRestartResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TryRestartResponse::~TryRestartResponse() {
}

inline TryRestartResponse& TryRestartResponse::operator = (const TryRestartResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool TryRestartResponse::operator == (const TryRestartResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool TryRestartResponse::operator != (const TryRestartResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool TryRestartResponse::operator < (const TryRestartResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TryRestartResponse::clone() {
    return new TryRestartResponse(*this);
}

inline bool TryRestartResponse::operator > (const TryRestartResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TryRestartResponse::clear() {
    clearJob();
}

inline void TryRestartResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool TryRestartResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TryRestartResponse::getJob () const {
    return _job;
}

inline ::std::string& TryRestartResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void TryRestartResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void TryRestartResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void TryRestartResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void TryRestartResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void TryRestartResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReloadOrRestartRequest::ReloadOrRestartRequest ()  :
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadOrRestartRequest::ReloadOrRestartRequest (const ReloadOrRestartRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadOrRestartRequest::ReloadOrRestartRequest (const ::std::string& mode_)  :
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadOrRestartRequest::~ReloadOrRestartRequest() {
}

inline ReloadOrRestartRequest& ReloadOrRestartRequest::operator = (const ReloadOrRestartRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool ReloadOrRestartRequest::operator == (const ReloadOrRestartRequest& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool ReloadOrRestartRequest::operator != (const ReloadOrRestartRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadOrRestartRequest::operator < (const ReloadOrRestartRequest& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadOrRestartRequest::clone() {
    return new ReloadOrRestartRequest(*this);
}

inline bool ReloadOrRestartRequest::operator > (const ReloadOrRestartRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadOrRestartRequest::clear() {
    clearMode();
}

inline void ReloadOrRestartRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool ReloadOrRestartRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReloadOrRestartRequest::getMode () const {
    return _mode;
}

inline ::std::string& ReloadOrRestartRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void ReloadOrRestartRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void ReloadOrRestartRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void ReloadOrRestartRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void ReloadOrRestartRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadOrRestartRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReloadOrRestartResponse::ReloadOrRestartResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadOrRestartResponse::ReloadOrRestartResponse (const ReloadOrRestartResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadOrRestartResponse::ReloadOrRestartResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadOrRestartResponse::~ReloadOrRestartResponse() {
}

inline ReloadOrRestartResponse& ReloadOrRestartResponse::operator = (const ReloadOrRestartResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool ReloadOrRestartResponse::operator == (const ReloadOrRestartResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool ReloadOrRestartResponse::operator != (const ReloadOrRestartResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadOrRestartResponse::operator < (const ReloadOrRestartResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadOrRestartResponse::clone() {
    return new ReloadOrRestartResponse(*this);
}

inline bool ReloadOrRestartResponse::operator > (const ReloadOrRestartResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadOrRestartResponse::clear() {
    clearJob();
}

inline void ReloadOrRestartResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool ReloadOrRestartResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReloadOrRestartResponse::getJob () const {
    return _job;
}

inline ::std::string& ReloadOrRestartResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void ReloadOrRestartResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void ReloadOrRestartResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void ReloadOrRestartResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void ReloadOrRestartResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadOrRestartResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReloadOrTryRestartRequest::ReloadOrTryRestartRequest ()  :
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadOrTryRestartRequest::ReloadOrTryRestartRequest (const ReloadOrTryRestartRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadOrTryRestartRequest::ReloadOrTryRestartRequest (const ::std::string& mode_)  :
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadOrTryRestartRequest::~ReloadOrTryRestartRequest() {
}

inline ReloadOrTryRestartRequest& ReloadOrTryRestartRequest::operator = (const ReloadOrTryRestartRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool ReloadOrTryRestartRequest::operator == (const ReloadOrTryRestartRequest& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool ReloadOrTryRestartRequest::operator != (const ReloadOrTryRestartRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadOrTryRestartRequest::operator < (const ReloadOrTryRestartRequest& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadOrTryRestartRequest::clone() {
    return new ReloadOrTryRestartRequest(*this);
}

inline bool ReloadOrTryRestartRequest::operator > (const ReloadOrTryRestartRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadOrTryRestartRequest::clear() {
    clearMode();
}

inline void ReloadOrTryRestartRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool ReloadOrTryRestartRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReloadOrTryRestartRequest::getMode () const {
    return _mode;
}

inline ::std::string& ReloadOrTryRestartRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void ReloadOrTryRestartRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void ReloadOrTryRestartRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void ReloadOrTryRestartRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void ReloadOrTryRestartRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadOrTryRestartRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReloadOrTryRestartResponse::ReloadOrTryRestartResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadOrTryRestartResponse::ReloadOrTryRestartResponse (const ReloadOrTryRestartResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadOrTryRestartResponse::ReloadOrTryRestartResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadOrTryRestartResponse::~ReloadOrTryRestartResponse() {
}

inline ReloadOrTryRestartResponse& ReloadOrTryRestartResponse::operator = (const ReloadOrTryRestartResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool ReloadOrTryRestartResponse::operator == (const ReloadOrTryRestartResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool ReloadOrTryRestartResponse::operator != (const ReloadOrTryRestartResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadOrTryRestartResponse::operator < (const ReloadOrTryRestartResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadOrTryRestartResponse::clone() {
    return new ReloadOrTryRestartResponse(*this);
}

inline bool ReloadOrTryRestartResponse::operator > (const ReloadOrTryRestartResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadOrTryRestartResponse::clear() {
    clearJob();
}

inline void ReloadOrTryRestartResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool ReloadOrTryRestartResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReloadOrTryRestartResponse::getJob () const {
    return _job;
}

inline ::std::string& ReloadOrTryRestartResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void ReloadOrTryRestartResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void ReloadOrTryRestartResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void ReloadOrTryRestartResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void ReloadOrTryRestartResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadOrTryRestartResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  KillRequest::KillRequest ()  :
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KillRequest::KillRequest (const KillRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KillRequest::KillRequest (const ::std::string& mode_)  :
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KillRequest::~KillRequest() {
}

inline KillRequest& KillRequest::operator = (const KillRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool KillRequest::operator == (const KillRequest& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool KillRequest::operator != (const KillRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool KillRequest::operator < (const KillRequest& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KillRequest::clone() {
    return new KillRequest(*this);
}

inline bool KillRequest::operator > (const KillRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KillRequest::clear() {
    clearMode();
}

inline void KillRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool KillRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& KillRequest::getMode () const {
    return _mode;
}

inline ::std::string& KillRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void KillRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void KillRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void KillRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void KillRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void KillRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  KillResponse::KillResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KillResponse::KillResponse (const KillResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KillResponse::KillResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KillResponse::~KillResponse() {
}

inline KillResponse& KillResponse::operator = (const KillResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool KillResponse::operator == (const KillResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool KillResponse::operator != (const KillResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool KillResponse::operator < (const KillResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KillResponse::clone() {
    return new KillResponse(*this);
}

inline bool KillResponse::operator > (const KillResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KillResponse::clear() {
    clearJob();
}

inline void KillResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool KillResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& KillResponse::getJob () const {
    return _job;
}

inline ::std::string& KillResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void KillResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void KillResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void KillResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void KillResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void KillResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetPropertiesRequest::SetPropertiesRequest ()  :
    _runtime (false),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPropertiesRequest::SetPropertiesRequest (const SetPropertiesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _runtime (false),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPropertiesRequest::SetPropertiesRequest (bool runtime_, const ::std::vector< property >& properties_)  :
    _runtime (runtime_),
    _properties (properties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPropertiesRequest::~SetPropertiesRequest() {
}

inline SetPropertiesRequest& SetPropertiesRequest::operator = (const SetPropertiesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRuntime()) {
            setRuntime(rhs.getRuntime());
        } else {
            clearRuntime();
        }
        if (rhs.hasProperties()) {
            setProperties(rhs.getProperties());
        } else {
            clearProperties();
        }
    }
    return *this;
}

inline bool SetPropertiesRequest::operator == (const SetPropertiesRequest& rhs) const {
    return (((!hasRuntime() && !rhs.hasRuntime()) || getRuntime() == rhs.getRuntime()) &&
        ((!hasProperties() && !rhs.hasProperties()) || getProperties() == rhs.getProperties()));
}

inline bool SetPropertiesRequest::operator != (const SetPropertiesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPropertiesRequest::operator < (const SetPropertiesRequest& rhs) const {
    if (hasRuntime() || rhs.hasRuntime()) {
        if (getRuntime() < rhs.getRuntime()) return true;
        if (getRuntime() > rhs.getRuntime()) return false;
    }
    if (hasProperties() || rhs.hasProperties()) {
        if (getProperties() < rhs.getProperties()) return true;
        if (getProperties() > rhs.getProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPropertiesRequest::clone() {
    return new SetPropertiesRequest(*this);
}

inline bool SetPropertiesRequest::operator > (const SetPropertiesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPropertiesRequest::clear() {
    clearRuntime();
    clearProperties();
}

inline void SetPropertiesRequest::clearRuntime() {
    if (hasRuntime()) {
         clear_has_runtime();
        _runtime = false;
     }
}

inline bool SetPropertiesRequest::hasRuntime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetPropertiesRequest::getRuntime () const {
    return _runtime;
}

inline void SetPropertiesRequest::setRuntime (bool runtime_) {
    set_has_runtime();
    this->_runtime = runtime_;
}

inline void SetPropertiesRequest::clearProperties() {
    if (hasProperties()) {
         clear_has_properties();
        _properties.clear();
     }
}

inline bool SetPropertiesRequest::hasProperties () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< property >& SetPropertiesRequest::getProperties () const {
    return _properties;
}

inline ::std::vector< property >& SetPropertiesRequest::getPropertiesMutable () {
    set_has_properties();
    return _properties;
}

inline void SetPropertiesRequest::setProperties (const ::std::vector< property >& properties_) {
    set_has_properties();
    this->_properties = properties_;
}

inline void SetPropertiesRequest::set_has_runtime () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPropertiesRequest::clear_has_runtime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetPropertiesRequest::set_has_properties () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetPropertiesRequest::clear_has_properties () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  IdUpdate::IdUpdate ()  :
    _Id ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IdUpdate::IdUpdate (const IdUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Id ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IdUpdate::IdUpdate (const ::std::string& Id_)  :
    _Id (Id_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Id_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  IdUpdate::~IdUpdate() {
}

inline IdUpdate& IdUpdate::operator = (const IdUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasId()) {
            setId(rhs.getId());
        } else {
            clearId();
        }
    }
    return *this;
}

inline bool IdUpdate::operator == (const IdUpdate& rhs) const {
    return (((!hasId() && !rhs.hasId()) || getId() == rhs.getId()));
}

inline bool IdUpdate::operator != (const IdUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool IdUpdate::operator < (const IdUpdate& rhs) const {
    if (hasId() || rhs.hasId()) {
        if (getId() < rhs.getId()) return true;
        if (getId() > rhs.getId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* IdUpdate::clone() {
    return new IdUpdate(*this);
}

inline bool IdUpdate::operator > (const IdUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IdUpdate::clear() {
    clearId();
}

inline void IdUpdate::clearId() {
    if (hasId()) {
         clear_has_Id();
        _Id.clear();
     }
}

inline bool IdUpdate::hasId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& IdUpdate::getId () const {
    return _Id;
}

inline ::std::string& IdUpdate::getIdMutable () {
    set_has_Id();
    return _Id;
}

inline void IdUpdate::setId (const ::std::string& Id_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Id_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Id();
    this->_Id = Id_;
}

inline void IdUpdate::setId (const char* Id_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Id_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Id();
    this->_Id.assign(Id_);
}

inline void IdUpdate::setId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Id();
    this->_Id.assign(value, size);
}

inline void IdUpdate::set_has_Id () {
    _has_bits_[0] |= 1u << 0;
}

inline void IdUpdate::clear_has_Id () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  IdRegister::IdRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IdRegister::IdRegister (const IdRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IdRegister::~IdRegister() {
}

inline IdRegister& IdRegister::operator = (const IdRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool IdRegister::operator == (const IdRegister& ) const {
    return true;
}

inline bool IdRegister::operator != (const IdRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool IdRegister::operator < (const IdRegister& ) const {
    return false;
}

inline ::asf::core::Payload* IdRegister::clone() {
    return new IdRegister(*this);
}

inline bool IdRegister::operator > (const IdRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IdRegister::clear() {
}

inline  NamesUpdate::NamesUpdate ()  :
    _Names ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NamesUpdate::NamesUpdate (const NamesUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Names ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NamesUpdate::NamesUpdate (const ::std::vector< ::std::string >& Names_)  :
    _Names (Names_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NamesUpdate::~NamesUpdate() {
}

inline NamesUpdate& NamesUpdate::operator = (const NamesUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNames()) {
            setNames(rhs.getNames());
        } else {
            clearNames();
        }
    }
    return *this;
}

inline bool NamesUpdate::operator == (const NamesUpdate& rhs) const {
    return (((!hasNames() && !rhs.hasNames()) || getNames() == rhs.getNames()));
}

inline bool NamesUpdate::operator != (const NamesUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NamesUpdate::operator < (const NamesUpdate& rhs) const {
    if (hasNames() || rhs.hasNames()) {
        if (getNames() < rhs.getNames()) return true;
        if (getNames() > rhs.getNames()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NamesUpdate::clone() {
    return new NamesUpdate(*this);
}

inline bool NamesUpdate::operator > (const NamesUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NamesUpdate::clear() {
    clearNames();
}

inline void NamesUpdate::clearNames() {
    if (hasNames()) {
         clear_has_Names();
        _Names.clear();
     }
}

inline bool NamesUpdate::hasNames () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& NamesUpdate::getNames () const {
    return _Names;
}

inline ::std::vector< ::std::string >& NamesUpdate::getNamesMutable () {
    set_has_Names();
    return _Names;
}

inline void NamesUpdate::setNames (const ::std::vector< ::std::string >& Names_) {
    set_has_Names();
    this->_Names = Names_;
}

inline void NamesUpdate::set_has_Names () {
    _has_bits_[0] |= 1u << 0;
}

inline void NamesUpdate::clear_has_Names () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NamesRegister::NamesRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NamesRegister::NamesRegister (const NamesRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NamesRegister::~NamesRegister() {
}

inline NamesRegister& NamesRegister::operator = (const NamesRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NamesRegister::operator == (const NamesRegister& ) const {
    return true;
}

inline bool NamesRegister::operator != (const NamesRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NamesRegister::operator < (const NamesRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NamesRegister::clone() {
    return new NamesRegister(*this);
}

inline bool NamesRegister::operator > (const NamesRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NamesRegister::clear() {
}

inline  FollowingUpdate::FollowingUpdate ()  :
    _Following ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FollowingUpdate::FollowingUpdate (const FollowingUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Following ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FollowingUpdate::FollowingUpdate (const ::std::string& Following_)  :
    _Following (Following_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Following_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FollowingUpdate::~FollowingUpdate() {
}

inline FollowingUpdate& FollowingUpdate::operator = (const FollowingUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFollowing()) {
            setFollowing(rhs.getFollowing());
        } else {
            clearFollowing();
        }
    }
    return *this;
}

inline bool FollowingUpdate::operator == (const FollowingUpdate& rhs) const {
    return (((!hasFollowing() && !rhs.hasFollowing()) || getFollowing() == rhs.getFollowing()));
}

inline bool FollowingUpdate::operator != (const FollowingUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool FollowingUpdate::operator < (const FollowingUpdate& rhs) const {
    if (hasFollowing() || rhs.hasFollowing()) {
        if (getFollowing() < rhs.getFollowing()) return true;
        if (getFollowing() > rhs.getFollowing()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FollowingUpdate::clone() {
    return new FollowingUpdate(*this);
}

inline bool FollowingUpdate::operator > (const FollowingUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FollowingUpdate::clear() {
    clearFollowing();
}

inline void FollowingUpdate::clearFollowing() {
    if (hasFollowing()) {
         clear_has_Following();
        _Following.clear();
     }
}

inline bool FollowingUpdate::hasFollowing () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FollowingUpdate::getFollowing () const {
    return _Following;
}

inline ::std::string& FollowingUpdate::getFollowingMutable () {
    set_has_Following();
    return _Following;
}

inline void FollowingUpdate::setFollowing (const ::std::string& Following_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Following_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Following();
    this->_Following = Following_;
}

inline void FollowingUpdate::setFollowing (const char* Following_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Following_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Following();
    this->_Following.assign(Following_);
}

inline void FollowingUpdate::setFollowing (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Following();
    this->_Following.assign(value, size);
}

inline void FollowingUpdate::set_has_Following () {
    _has_bits_[0] |= 1u << 0;
}

inline void FollowingUpdate::clear_has_Following () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FollowingRegister::FollowingRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FollowingRegister::FollowingRegister (const FollowingRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FollowingRegister::~FollowingRegister() {
}

inline FollowingRegister& FollowingRegister::operator = (const FollowingRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool FollowingRegister::operator == (const FollowingRegister& ) const {
    return true;
}

inline bool FollowingRegister::operator != (const FollowingRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool FollowingRegister::operator < (const FollowingRegister& ) const {
    return false;
}

inline ::asf::core::Payload* FollowingRegister::clone() {
    return new FollowingRegister(*this);
}

inline bool FollowingRegister::operator > (const FollowingRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FollowingRegister::clear() {
}

inline  RequiresUpdate::RequiresUpdate ()  :
    _Requires ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequiresUpdate::RequiresUpdate (const RequiresUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Requires ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequiresUpdate::RequiresUpdate (const ::std::vector< ::std::string >& Requires_)  :
    _Requires (Requires_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequiresUpdate::~RequiresUpdate() {
}

inline RequiresUpdate& RequiresUpdate::operator = (const RequiresUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequires()) {
            setRequires(rhs.getRequires());
        } else {
            clearRequires();
        }
    }
    return *this;
}

inline bool RequiresUpdate::operator == (const RequiresUpdate& rhs) const {
    return (((!hasRequires() && !rhs.hasRequires()) || getRequires() == rhs.getRequires()));
}

inline bool RequiresUpdate::operator != (const RequiresUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RequiresUpdate::operator < (const RequiresUpdate& rhs) const {
    if (hasRequires() || rhs.hasRequires()) {
        if (getRequires() < rhs.getRequires()) return true;
        if (getRequires() > rhs.getRequires()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequiresUpdate::clone() {
    return new RequiresUpdate(*this);
}

inline bool RequiresUpdate::operator > (const RequiresUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequiresUpdate::clear() {
    clearRequires();
}

inline void RequiresUpdate::clearRequires() {
    if (hasRequires()) {
         clear_has_Requires();
        _Requires.clear();
     }
}

inline bool RequiresUpdate::hasRequires () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& RequiresUpdate::getRequires () const {
    return _Requires;
}

inline ::std::vector< ::std::string >& RequiresUpdate::getRequiresMutable () {
    set_has_Requires();
    return _Requires;
}

inline void RequiresUpdate::setRequires (const ::std::vector< ::std::string >& Requires_) {
    set_has_Requires();
    this->_Requires = Requires_;
}

inline void RequiresUpdate::set_has_Requires () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequiresUpdate::clear_has_Requires () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequiresRegister::RequiresRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequiresRegister::RequiresRegister (const RequiresRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequiresRegister::~RequiresRegister() {
}

inline RequiresRegister& RequiresRegister::operator = (const RequiresRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RequiresRegister::operator == (const RequiresRegister& ) const {
    return true;
}

inline bool RequiresRegister::operator != (const RequiresRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RequiresRegister::operator < (const RequiresRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RequiresRegister::clone() {
    return new RequiresRegister(*this);
}

inline bool RequiresRegister::operator > (const RequiresRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequiresRegister::clear() {
}

inline  RequiresOverridableUpdate::RequiresOverridableUpdate ()  :
    _RequiresOverridable ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequiresOverridableUpdate::RequiresOverridableUpdate (const RequiresOverridableUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RequiresOverridable ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequiresOverridableUpdate::RequiresOverridableUpdate (const ::std::vector< ::std::string >& RequiresOverridable_)  :
    _RequiresOverridable (RequiresOverridable_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequiresOverridableUpdate::~RequiresOverridableUpdate() {
}

inline RequiresOverridableUpdate& RequiresOverridableUpdate::operator = (const RequiresOverridableUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequiresOverridable()) {
            setRequiresOverridable(rhs.getRequiresOverridable());
        } else {
            clearRequiresOverridable();
        }
    }
    return *this;
}

inline bool RequiresOverridableUpdate::operator == (const RequiresOverridableUpdate& rhs) const {
    return (((!hasRequiresOverridable() && !rhs.hasRequiresOverridable()) || getRequiresOverridable() == rhs.getRequiresOverridable()));
}

inline bool RequiresOverridableUpdate::operator != (const RequiresOverridableUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RequiresOverridableUpdate::operator < (const RequiresOverridableUpdate& rhs) const {
    if (hasRequiresOverridable() || rhs.hasRequiresOverridable()) {
        if (getRequiresOverridable() < rhs.getRequiresOverridable()) return true;
        if (getRequiresOverridable() > rhs.getRequiresOverridable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequiresOverridableUpdate::clone() {
    return new RequiresOverridableUpdate(*this);
}

inline bool RequiresOverridableUpdate::operator > (const RequiresOverridableUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequiresOverridableUpdate::clear() {
    clearRequiresOverridable();
}

inline void RequiresOverridableUpdate::clearRequiresOverridable() {
    if (hasRequiresOverridable()) {
         clear_has_RequiresOverridable();
        _RequiresOverridable.clear();
     }
}

inline bool RequiresOverridableUpdate::hasRequiresOverridable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& RequiresOverridableUpdate::getRequiresOverridable () const {
    return _RequiresOverridable;
}

inline ::std::vector< ::std::string >& RequiresOverridableUpdate::getRequiresOverridableMutable () {
    set_has_RequiresOverridable();
    return _RequiresOverridable;
}

inline void RequiresOverridableUpdate::setRequiresOverridable (const ::std::vector< ::std::string >& RequiresOverridable_) {
    set_has_RequiresOverridable();
    this->_RequiresOverridable = RequiresOverridable_;
}

inline void RequiresOverridableUpdate::set_has_RequiresOverridable () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequiresOverridableUpdate::clear_has_RequiresOverridable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequiresOverridableRegister::RequiresOverridableRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequiresOverridableRegister::RequiresOverridableRegister (const RequiresOverridableRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequiresOverridableRegister::~RequiresOverridableRegister() {
}

inline RequiresOverridableRegister& RequiresOverridableRegister::operator = (const RequiresOverridableRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RequiresOverridableRegister::operator == (const RequiresOverridableRegister& ) const {
    return true;
}

inline bool RequiresOverridableRegister::operator != (const RequiresOverridableRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RequiresOverridableRegister::operator < (const RequiresOverridableRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RequiresOverridableRegister::clone() {
    return new RequiresOverridableRegister(*this);
}

inline bool RequiresOverridableRegister::operator > (const RequiresOverridableRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequiresOverridableRegister::clear() {
}

inline  RequisiteUpdate::RequisiteUpdate ()  :
    _Requisite ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequisiteUpdate::RequisiteUpdate (const RequisiteUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Requisite ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequisiteUpdate::RequisiteUpdate (const ::std::vector< ::std::string >& Requisite_)  :
    _Requisite (Requisite_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequisiteUpdate::~RequisiteUpdate() {
}

inline RequisiteUpdate& RequisiteUpdate::operator = (const RequisiteUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequisite()) {
            setRequisite(rhs.getRequisite());
        } else {
            clearRequisite();
        }
    }
    return *this;
}

inline bool RequisiteUpdate::operator == (const RequisiteUpdate& rhs) const {
    return (((!hasRequisite() && !rhs.hasRequisite()) || getRequisite() == rhs.getRequisite()));
}

inline bool RequisiteUpdate::operator != (const RequisiteUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RequisiteUpdate::operator < (const RequisiteUpdate& rhs) const {
    if (hasRequisite() || rhs.hasRequisite()) {
        if (getRequisite() < rhs.getRequisite()) return true;
        if (getRequisite() > rhs.getRequisite()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequisiteUpdate::clone() {
    return new RequisiteUpdate(*this);
}

inline bool RequisiteUpdate::operator > (const RequisiteUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequisiteUpdate::clear() {
    clearRequisite();
}

inline void RequisiteUpdate::clearRequisite() {
    if (hasRequisite()) {
         clear_has_Requisite();
        _Requisite.clear();
     }
}

inline bool RequisiteUpdate::hasRequisite () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& RequisiteUpdate::getRequisite () const {
    return _Requisite;
}

inline ::std::vector< ::std::string >& RequisiteUpdate::getRequisiteMutable () {
    set_has_Requisite();
    return _Requisite;
}

inline void RequisiteUpdate::setRequisite (const ::std::vector< ::std::string >& Requisite_) {
    set_has_Requisite();
    this->_Requisite = Requisite_;
}

inline void RequisiteUpdate::set_has_Requisite () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequisiteUpdate::clear_has_Requisite () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequisiteRegister::RequisiteRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequisiteRegister::RequisiteRegister (const RequisiteRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequisiteRegister::~RequisiteRegister() {
}

inline RequisiteRegister& RequisiteRegister::operator = (const RequisiteRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RequisiteRegister::operator == (const RequisiteRegister& ) const {
    return true;
}

inline bool RequisiteRegister::operator != (const RequisiteRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RequisiteRegister::operator < (const RequisiteRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RequisiteRegister::clone() {
    return new RequisiteRegister(*this);
}

inline bool RequisiteRegister::operator > (const RequisiteRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequisiteRegister::clear() {
}

inline  RequisiteOverridableUpdate::RequisiteOverridableUpdate ()  :
    _RequisiteOverridable ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequisiteOverridableUpdate::RequisiteOverridableUpdate (const RequisiteOverridableUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RequisiteOverridable ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequisiteOverridableUpdate::RequisiteOverridableUpdate (const ::std::vector< ::std::string >& RequisiteOverridable_)  :
    _RequisiteOverridable (RequisiteOverridable_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequisiteOverridableUpdate::~RequisiteOverridableUpdate() {
}

inline RequisiteOverridableUpdate& RequisiteOverridableUpdate::operator = (const RequisiteOverridableUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequisiteOverridable()) {
            setRequisiteOverridable(rhs.getRequisiteOverridable());
        } else {
            clearRequisiteOverridable();
        }
    }
    return *this;
}

inline bool RequisiteOverridableUpdate::operator == (const RequisiteOverridableUpdate& rhs) const {
    return (((!hasRequisiteOverridable() && !rhs.hasRequisiteOverridable()) || getRequisiteOverridable() == rhs.getRequisiteOverridable()));
}

inline bool RequisiteOverridableUpdate::operator != (const RequisiteOverridableUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RequisiteOverridableUpdate::operator < (const RequisiteOverridableUpdate& rhs) const {
    if (hasRequisiteOverridable() || rhs.hasRequisiteOverridable()) {
        if (getRequisiteOverridable() < rhs.getRequisiteOverridable()) return true;
        if (getRequisiteOverridable() > rhs.getRequisiteOverridable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequisiteOverridableUpdate::clone() {
    return new RequisiteOverridableUpdate(*this);
}

inline bool RequisiteOverridableUpdate::operator > (const RequisiteOverridableUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequisiteOverridableUpdate::clear() {
    clearRequisiteOverridable();
}

inline void RequisiteOverridableUpdate::clearRequisiteOverridable() {
    if (hasRequisiteOverridable()) {
         clear_has_RequisiteOverridable();
        _RequisiteOverridable.clear();
     }
}

inline bool RequisiteOverridableUpdate::hasRequisiteOverridable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& RequisiteOverridableUpdate::getRequisiteOverridable () const {
    return _RequisiteOverridable;
}

inline ::std::vector< ::std::string >& RequisiteOverridableUpdate::getRequisiteOverridableMutable () {
    set_has_RequisiteOverridable();
    return _RequisiteOverridable;
}

inline void RequisiteOverridableUpdate::setRequisiteOverridable (const ::std::vector< ::std::string >& RequisiteOverridable_) {
    set_has_RequisiteOverridable();
    this->_RequisiteOverridable = RequisiteOverridable_;
}

inline void RequisiteOverridableUpdate::set_has_RequisiteOverridable () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequisiteOverridableUpdate::clear_has_RequisiteOverridable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequisiteOverridableRegister::RequisiteOverridableRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequisiteOverridableRegister::RequisiteOverridableRegister (const RequisiteOverridableRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequisiteOverridableRegister::~RequisiteOverridableRegister() {
}

inline RequisiteOverridableRegister& RequisiteOverridableRegister::operator = (const RequisiteOverridableRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RequisiteOverridableRegister::operator == (const RequisiteOverridableRegister& ) const {
    return true;
}

inline bool RequisiteOverridableRegister::operator != (const RequisiteOverridableRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RequisiteOverridableRegister::operator < (const RequisiteOverridableRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RequisiteOverridableRegister::clone() {
    return new RequisiteOverridableRegister(*this);
}

inline bool RequisiteOverridableRegister::operator > (const RequisiteOverridableRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequisiteOverridableRegister::clear() {
}

inline  WantsUpdate::WantsUpdate ()  :
    _Wants ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WantsUpdate::WantsUpdate (const WantsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Wants ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WantsUpdate::WantsUpdate (const ::std::vector< ::std::string >& Wants_)  :
    _Wants (Wants_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WantsUpdate::~WantsUpdate() {
}

inline WantsUpdate& WantsUpdate::operator = (const WantsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWants()) {
            setWants(rhs.getWants());
        } else {
            clearWants();
        }
    }
    return *this;
}

inline bool WantsUpdate::operator == (const WantsUpdate& rhs) const {
    return (((!hasWants() && !rhs.hasWants()) || getWants() == rhs.getWants()));
}

inline bool WantsUpdate::operator != (const WantsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool WantsUpdate::operator < (const WantsUpdate& rhs) const {
    if (hasWants() || rhs.hasWants()) {
        if (getWants() < rhs.getWants()) return true;
        if (getWants() > rhs.getWants()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WantsUpdate::clone() {
    return new WantsUpdate(*this);
}

inline bool WantsUpdate::operator > (const WantsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WantsUpdate::clear() {
    clearWants();
}

inline void WantsUpdate::clearWants() {
    if (hasWants()) {
         clear_has_Wants();
        _Wants.clear();
     }
}

inline bool WantsUpdate::hasWants () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& WantsUpdate::getWants () const {
    return _Wants;
}

inline ::std::vector< ::std::string >& WantsUpdate::getWantsMutable () {
    set_has_Wants();
    return _Wants;
}

inline void WantsUpdate::setWants (const ::std::vector< ::std::string >& Wants_) {
    set_has_Wants();
    this->_Wants = Wants_;
}

inline void WantsUpdate::set_has_Wants () {
    _has_bits_[0] |= 1u << 0;
}

inline void WantsUpdate::clear_has_Wants () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WantsRegister::WantsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WantsRegister::WantsRegister (const WantsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WantsRegister::~WantsRegister() {
}

inline WantsRegister& WantsRegister::operator = (const WantsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool WantsRegister::operator == (const WantsRegister& ) const {
    return true;
}

inline bool WantsRegister::operator != (const WantsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool WantsRegister::operator < (const WantsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* WantsRegister::clone() {
    return new WantsRegister(*this);
}

inline bool WantsRegister::operator > (const WantsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WantsRegister::clear() {
}

inline  BindsToUpdate::BindsToUpdate ()  :
    _BindsTo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BindsToUpdate::BindsToUpdate (const BindsToUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _BindsTo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BindsToUpdate::BindsToUpdate (const ::std::vector< ::std::string >& BindsTo_)  :
    _BindsTo (BindsTo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BindsToUpdate::~BindsToUpdate() {
}

inline BindsToUpdate& BindsToUpdate::operator = (const BindsToUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBindsTo()) {
            setBindsTo(rhs.getBindsTo());
        } else {
            clearBindsTo();
        }
    }
    return *this;
}

inline bool BindsToUpdate::operator == (const BindsToUpdate& rhs) const {
    return (((!hasBindsTo() && !rhs.hasBindsTo()) || getBindsTo() == rhs.getBindsTo()));
}

inline bool BindsToUpdate::operator != (const BindsToUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool BindsToUpdate::operator < (const BindsToUpdate& rhs) const {
    if (hasBindsTo() || rhs.hasBindsTo()) {
        if (getBindsTo() < rhs.getBindsTo()) return true;
        if (getBindsTo() > rhs.getBindsTo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BindsToUpdate::clone() {
    return new BindsToUpdate(*this);
}

inline bool BindsToUpdate::operator > (const BindsToUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BindsToUpdate::clear() {
    clearBindsTo();
}

inline void BindsToUpdate::clearBindsTo() {
    if (hasBindsTo()) {
         clear_has_BindsTo();
        _BindsTo.clear();
     }
}

inline bool BindsToUpdate::hasBindsTo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& BindsToUpdate::getBindsTo () const {
    return _BindsTo;
}

inline ::std::vector< ::std::string >& BindsToUpdate::getBindsToMutable () {
    set_has_BindsTo();
    return _BindsTo;
}

inline void BindsToUpdate::setBindsTo (const ::std::vector< ::std::string >& BindsTo_) {
    set_has_BindsTo();
    this->_BindsTo = BindsTo_;
}

inline void BindsToUpdate::set_has_BindsTo () {
    _has_bits_[0] |= 1u << 0;
}

inline void BindsToUpdate::clear_has_BindsTo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BindsToRegister::BindsToRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BindsToRegister::BindsToRegister (const BindsToRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BindsToRegister::~BindsToRegister() {
}

inline BindsToRegister& BindsToRegister::operator = (const BindsToRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool BindsToRegister::operator == (const BindsToRegister& ) const {
    return true;
}

inline bool BindsToRegister::operator != (const BindsToRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool BindsToRegister::operator < (const BindsToRegister& ) const {
    return false;
}

inline ::asf::core::Payload* BindsToRegister::clone() {
    return new BindsToRegister(*this);
}

inline bool BindsToRegister::operator > (const BindsToRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BindsToRegister::clear() {
}

inline  PartOfUpdate::PartOfUpdate ()  :
    _PartOf ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PartOfUpdate::PartOfUpdate (const PartOfUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _PartOf ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PartOfUpdate::PartOfUpdate (const ::std::vector< ::std::string >& PartOf_)  :
    _PartOf (PartOf_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PartOfUpdate::~PartOfUpdate() {
}

inline PartOfUpdate& PartOfUpdate::operator = (const PartOfUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPartOf()) {
            setPartOf(rhs.getPartOf());
        } else {
            clearPartOf();
        }
    }
    return *this;
}

inline bool PartOfUpdate::operator == (const PartOfUpdate& rhs) const {
    return (((!hasPartOf() && !rhs.hasPartOf()) || getPartOf() == rhs.getPartOf()));
}

inline bool PartOfUpdate::operator != (const PartOfUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PartOfUpdate::operator < (const PartOfUpdate& rhs) const {
    if (hasPartOf() || rhs.hasPartOf()) {
        if (getPartOf() < rhs.getPartOf()) return true;
        if (getPartOf() > rhs.getPartOf()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PartOfUpdate::clone() {
    return new PartOfUpdate(*this);
}

inline bool PartOfUpdate::operator > (const PartOfUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PartOfUpdate::clear() {
    clearPartOf();
}

inline void PartOfUpdate::clearPartOf() {
    if (hasPartOf()) {
         clear_has_PartOf();
        _PartOf.clear();
     }
}

inline bool PartOfUpdate::hasPartOf () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& PartOfUpdate::getPartOf () const {
    return _PartOf;
}

inline ::std::vector< ::std::string >& PartOfUpdate::getPartOfMutable () {
    set_has_PartOf();
    return _PartOf;
}

inline void PartOfUpdate::setPartOf (const ::std::vector< ::std::string >& PartOf_) {
    set_has_PartOf();
    this->_PartOf = PartOf_;
}

inline void PartOfUpdate::set_has_PartOf () {
    _has_bits_[0] |= 1u << 0;
}

inline void PartOfUpdate::clear_has_PartOf () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PartOfRegister::PartOfRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PartOfRegister::PartOfRegister (const PartOfRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PartOfRegister::~PartOfRegister() {
}

inline PartOfRegister& PartOfRegister::operator = (const PartOfRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PartOfRegister::operator == (const PartOfRegister& ) const {
    return true;
}

inline bool PartOfRegister::operator != (const PartOfRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PartOfRegister::operator < (const PartOfRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PartOfRegister::clone() {
    return new PartOfRegister(*this);
}

inline bool PartOfRegister::operator > (const PartOfRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PartOfRegister::clear() {
}

inline  RequiredByUpdate::RequiredByUpdate ()  :
    _RequiredBy ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequiredByUpdate::RequiredByUpdate (const RequiredByUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RequiredBy ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequiredByUpdate::RequiredByUpdate (const ::std::vector< ::std::string >& RequiredBy_)  :
    _RequiredBy (RequiredBy_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequiredByUpdate::~RequiredByUpdate() {
}

inline RequiredByUpdate& RequiredByUpdate::operator = (const RequiredByUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequiredBy()) {
            setRequiredBy(rhs.getRequiredBy());
        } else {
            clearRequiredBy();
        }
    }
    return *this;
}

inline bool RequiredByUpdate::operator == (const RequiredByUpdate& rhs) const {
    return (((!hasRequiredBy() && !rhs.hasRequiredBy()) || getRequiredBy() == rhs.getRequiredBy()));
}

inline bool RequiredByUpdate::operator != (const RequiredByUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RequiredByUpdate::operator < (const RequiredByUpdate& rhs) const {
    if (hasRequiredBy() || rhs.hasRequiredBy()) {
        if (getRequiredBy() < rhs.getRequiredBy()) return true;
        if (getRequiredBy() > rhs.getRequiredBy()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequiredByUpdate::clone() {
    return new RequiredByUpdate(*this);
}

inline bool RequiredByUpdate::operator > (const RequiredByUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequiredByUpdate::clear() {
    clearRequiredBy();
}

inline void RequiredByUpdate::clearRequiredBy() {
    if (hasRequiredBy()) {
         clear_has_RequiredBy();
        _RequiredBy.clear();
     }
}

inline bool RequiredByUpdate::hasRequiredBy () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& RequiredByUpdate::getRequiredBy () const {
    return _RequiredBy;
}

inline ::std::vector< ::std::string >& RequiredByUpdate::getRequiredByMutable () {
    set_has_RequiredBy();
    return _RequiredBy;
}

inline void RequiredByUpdate::setRequiredBy (const ::std::vector< ::std::string >& RequiredBy_) {
    set_has_RequiredBy();
    this->_RequiredBy = RequiredBy_;
}

inline void RequiredByUpdate::set_has_RequiredBy () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequiredByUpdate::clear_has_RequiredBy () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequiredByRegister::RequiredByRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequiredByRegister::RequiredByRegister (const RequiredByRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequiredByRegister::~RequiredByRegister() {
}

inline RequiredByRegister& RequiredByRegister::operator = (const RequiredByRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RequiredByRegister::operator == (const RequiredByRegister& ) const {
    return true;
}

inline bool RequiredByRegister::operator != (const RequiredByRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RequiredByRegister::operator < (const RequiredByRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RequiredByRegister::clone() {
    return new RequiredByRegister(*this);
}

inline bool RequiredByRegister::operator > (const RequiredByRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequiredByRegister::clear() {
}

inline  RequiredByOverridableUpdate::RequiredByOverridableUpdate ()  :
    _RequiredByOverridable ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequiredByOverridableUpdate::RequiredByOverridableUpdate (const RequiredByOverridableUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RequiredByOverridable ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequiredByOverridableUpdate::RequiredByOverridableUpdate (const ::std::vector< ::std::string >& RequiredByOverridable_)  :
    _RequiredByOverridable (RequiredByOverridable_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequiredByOverridableUpdate::~RequiredByOverridableUpdate() {
}

inline RequiredByOverridableUpdate& RequiredByOverridableUpdate::operator = (const RequiredByOverridableUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequiredByOverridable()) {
            setRequiredByOverridable(rhs.getRequiredByOverridable());
        } else {
            clearRequiredByOverridable();
        }
    }
    return *this;
}

inline bool RequiredByOverridableUpdate::operator == (const RequiredByOverridableUpdate& rhs) const {
    return (((!hasRequiredByOverridable() && !rhs.hasRequiredByOverridable()) || getRequiredByOverridable() == rhs.getRequiredByOverridable()));
}

inline bool RequiredByOverridableUpdate::operator != (const RequiredByOverridableUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RequiredByOverridableUpdate::operator < (const RequiredByOverridableUpdate& rhs) const {
    if (hasRequiredByOverridable() || rhs.hasRequiredByOverridable()) {
        if (getRequiredByOverridable() < rhs.getRequiredByOverridable()) return true;
        if (getRequiredByOverridable() > rhs.getRequiredByOverridable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequiredByOverridableUpdate::clone() {
    return new RequiredByOverridableUpdate(*this);
}

inline bool RequiredByOverridableUpdate::operator > (const RequiredByOverridableUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequiredByOverridableUpdate::clear() {
    clearRequiredByOverridable();
}

inline void RequiredByOverridableUpdate::clearRequiredByOverridable() {
    if (hasRequiredByOverridable()) {
         clear_has_RequiredByOverridable();
        _RequiredByOverridable.clear();
     }
}

inline bool RequiredByOverridableUpdate::hasRequiredByOverridable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& RequiredByOverridableUpdate::getRequiredByOverridable () const {
    return _RequiredByOverridable;
}

inline ::std::vector< ::std::string >& RequiredByOverridableUpdate::getRequiredByOverridableMutable () {
    set_has_RequiredByOverridable();
    return _RequiredByOverridable;
}

inline void RequiredByOverridableUpdate::setRequiredByOverridable (const ::std::vector< ::std::string >& RequiredByOverridable_) {
    set_has_RequiredByOverridable();
    this->_RequiredByOverridable = RequiredByOverridable_;
}

inline void RequiredByOverridableUpdate::set_has_RequiredByOverridable () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequiredByOverridableUpdate::clear_has_RequiredByOverridable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequiredByOverridableRegister::RequiredByOverridableRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequiredByOverridableRegister::RequiredByOverridableRegister (const RequiredByOverridableRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequiredByOverridableRegister::~RequiredByOverridableRegister() {
}

inline RequiredByOverridableRegister& RequiredByOverridableRegister::operator = (const RequiredByOverridableRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RequiredByOverridableRegister::operator == (const RequiredByOverridableRegister& ) const {
    return true;
}

inline bool RequiredByOverridableRegister::operator != (const RequiredByOverridableRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RequiredByOverridableRegister::operator < (const RequiredByOverridableRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RequiredByOverridableRegister::clone() {
    return new RequiredByOverridableRegister(*this);
}

inline bool RequiredByOverridableRegister::operator > (const RequiredByOverridableRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequiredByOverridableRegister::clear() {
}

inline  RequisiteOfUpdate::RequisiteOfUpdate ()  :
    _RequisiteOf ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequisiteOfUpdate::RequisiteOfUpdate (const RequisiteOfUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RequisiteOf ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequisiteOfUpdate::RequisiteOfUpdate (const ::std::vector< ::std::string >& RequisiteOf_)  :
    _RequisiteOf (RequisiteOf_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequisiteOfUpdate::~RequisiteOfUpdate() {
}

inline RequisiteOfUpdate& RequisiteOfUpdate::operator = (const RequisiteOfUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequisiteOf()) {
            setRequisiteOf(rhs.getRequisiteOf());
        } else {
            clearRequisiteOf();
        }
    }
    return *this;
}

inline bool RequisiteOfUpdate::operator == (const RequisiteOfUpdate& rhs) const {
    return (((!hasRequisiteOf() && !rhs.hasRequisiteOf()) || getRequisiteOf() == rhs.getRequisiteOf()));
}

inline bool RequisiteOfUpdate::operator != (const RequisiteOfUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RequisiteOfUpdate::operator < (const RequisiteOfUpdate& rhs) const {
    if (hasRequisiteOf() || rhs.hasRequisiteOf()) {
        if (getRequisiteOf() < rhs.getRequisiteOf()) return true;
        if (getRequisiteOf() > rhs.getRequisiteOf()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequisiteOfUpdate::clone() {
    return new RequisiteOfUpdate(*this);
}

inline bool RequisiteOfUpdate::operator > (const RequisiteOfUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequisiteOfUpdate::clear() {
    clearRequisiteOf();
}

inline void RequisiteOfUpdate::clearRequisiteOf() {
    if (hasRequisiteOf()) {
         clear_has_RequisiteOf();
        _RequisiteOf.clear();
     }
}

inline bool RequisiteOfUpdate::hasRequisiteOf () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& RequisiteOfUpdate::getRequisiteOf () const {
    return _RequisiteOf;
}

inline ::std::vector< ::std::string >& RequisiteOfUpdate::getRequisiteOfMutable () {
    set_has_RequisiteOf();
    return _RequisiteOf;
}

inline void RequisiteOfUpdate::setRequisiteOf (const ::std::vector< ::std::string >& RequisiteOf_) {
    set_has_RequisiteOf();
    this->_RequisiteOf = RequisiteOf_;
}

inline void RequisiteOfUpdate::set_has_RequisiteOf () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequisiteOfUpdate::clear_has_RequisiteOf () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequisiteOfRegister::RequisiteOfRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequisiteOfRegister::RequisiteOfRegister (const RequisiteOfRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequisiteOfRegister::~RequisiteOfRegister() {
}

inline RequisiteOfRegister& RequisiteOfRegister::operator = (const RequisiteOfRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RequisiteOfRegister::operator == (const RequisiteOfRegister& ) const {
    return true;
}

inline bool RequisiteOfRegister::operator != (const RequisiteOfRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RequisiteOfRegister::operator < (const RequisiteOfRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RequisiteOfRegister::clone() {
    return new RequisiteOfRegister(*this);
}

inline bool RequisiteOfRegister::operator > (const RequisiteOfRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequisiteOfRegister::clear() {
}

inline  RequisiteOfOverridableUpdate::RequisiteOfOverridableUpdate ()  :
    _RequisiteOfOverridable ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequisiteOfOverridableUpdate::RequisiteOfOverridableUpdate (const RequisiteOfOverridableUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RequisiteOfOverridable ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequisiteOfOverridableUpdate::RequisiteOfOverridableUpdate (const ::std::vector< ::std::string >& RequisiteOfOverridable_)  :
    _RequisiteOfOverridable (RequisiteOfOverridable_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequisiteOfOverridableUpdate::~RequisiteOfOverridableUpdate() {
}

inline RequisiteOfOverridableUpdate& RequisiteOfOverridableUpdate::operator = (const RequisiteOfOverridableUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequisiteOfOverridable()) {
            setRequisiteOfOverridable(rhs.getRequisiteOfOverridable());
        } else {
            clearRequisiteOfOverridable();
        }
    }
    return *this;
}

inline bool RequisiteOfOverridableUpdate::operator == (const RequisiteOfOverridableUpdate& rhs) const {
    return (((!hasRequisiteOfOverridable() && !rhs.hasRequisiteOfOverridable()) || getRequisiteOfOverridable() == rhs.getRequisiteOfOverridable()));
}

inline bool RequisiteOfOverridableUpdate::operator != (const RequisiteOfOverridableUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RequisiteOfOverridableUpdate::operator < (const RequisiteOfOverridableUpdate& rhs) const {
    if (hasRequisiteOfOverridable() || rhs.hasRequisiteOfOverridable()) {
        if (getRequisiteOfOverridable() < rhs.getRequisiteOfOverridable()) return true;
        if (getRequisiteOfOverridable() > rhs.getRequisiteOfOverridable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequisiteOfOverridableUpdate::clone() {
    return new RequisiteOfOverridableUpdate(*this);
}

inline bool RequisiteOfOverridableUpdate::operator > (const RequisiteOfOverridableUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequisiteOfOverridableUpdate::clear() {
    clearRequisiteOfOverridable();
}

inline void RequisiteOfOverridableUpdate::clearRequisiteOfOverridable() {
    if (hasRequisiteOfOverridable()) {
         clear_has_RequisiteOfOverridable();
        _RequisiteOfOverridable.clear();
     }
}

inline bool RequisiteOfOverridableUpdate::hasRequisiteOfOverridable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& RequisiteOfOverridableUpdate::getRequisiteOfOverridable () const {
    return _RequisiteOfOverridable;
}

inline ::std::vector< ::std::string >& RequisiteOfOverridableUpdate::getRequisiteOfOverridableMutable () {
    set_has_RequisiteOfOverridable();
    return _RequisiteOfOverridable;
}

inline void RequisiteOfOverridableUpdate::setRequisiteOfOverridable (const ::std::vector< ::std::string >& RequisiteOfOverridable_) {
    set_has_RequisiteOfOverridable();
    this->_RequisiteOfOverridable = RequisiteOfOverridable_;
}

inline void RequisiteOfOverridableUpdate::set_has_RequisiteOfOverridable () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequisiteOfOverridableUpdate::clear_has_RequisiteOfOverridable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequisiteOfOverridableRegister::RequisiteOfOverridableRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequisiteOfOverridableRegister::RequisiteOfOverridableRegister (const RequisiteOfOverridableRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequisiteOfOverridableRegister::~RequisiteOfOverridableRegister() {
}

inline RequisiteOfOverridableRegister& RequisiteOfOverridableRegister::operator = (const RequisiteOfOverridableRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RequisiteOfOverridableRegister::operator == (const RequisiteOfOverridableRegister& ) const {
    return true;
}

inline bool RequisiteOfOverridableRegister::operator != (const RequisiteOfOverridableRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RequisiteOfOverridableRegister::operator < (const RequisiteOfOverridableRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RequisiteOfOverridableRegister::clone() {
    return new RequisiteOfOverridableRegister(*this);
}

inline bool RequisiteOfOverridableRegister::operator > (const RequisiteOfOverridableRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequisiteOfOverridableRegister::clear() {
}

inline  WantedByUpdate::WantedByUpdate ()  :
    _WantedBy ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WantedByUpdate::WantedByUpdate (const WantedByUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _WantedBy ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WantedByUpdate::WantedByUpdate (const ::std::vector< ::std::string >& WantedBy_)  :
    _WantedBy (WantedBy_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WantedByUpdate::~WantedByUpdate() {
}

inline WantedByUpdate& WantedByUpdate::operator = (const WantedByUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWantedBy()) {
            setWantedBy(rhs.getWantedBy());
        } else {
            clearWantedBy();
        }
    }
    return *this;
}

inline bool WantedByUpdate::operator == (const WantedByUpdate& rhs) const {
    return (((!hasWantedBy() && !rhs.hasWantedBy()) || getWantedBy() == rhs.getWantedBy()));
}

inline bool WantedByUpdate::operator != (const WantedByUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool WantedByUpdate::operator < (const WantedByUpdate& rhs) const {
    if (hasWantedBy() || rhs.hasWantedBy()) {
        if (getWantedBy() < rhs.getWantedBy()) return true;
        if (getWantedBy() > rhs.getWantedBy()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WantedByUpdate::clone() {
    return new WantedByUpdate(*this);
}

inline bool WantedByUpdate::operator > (const WantedByUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WantedByUpdate::clear() {
    clearWantedBy();
}

inline void WantedByUpdate::clearWantedBy() {
    if (hasWantedBy()) {
         clear_has_WantedBy();
        _WantedBy.clear();
     }
}

inline bool WantedByUpdate::hasWantedBy () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& WantedByUpdate::getWantedBy () const {
    return _WantedBy;
}

inline ::std::vector< ::std::string >& WantedByUpdate::getWantedByMutable () {
    set_has_WantedBy();
    return _WantedBy;
}

inline void WantedByUpdate::setWantedBy (const ::std::vector< ::std::string >& WantedBy_) {
    set_has_WantedBy();
    this->_WantedBy = WantedBy_;
}

inline void WantedByUpdate::set_has_WantedBy () {
    _has_bits_[0] |= 1u << 0;
}

inline void WantedByUpdate::clear_has_WantedBy () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WantedByRegister::WantedByRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WantedByRegister::WantedByRegister (const WantedByRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WantedByRegister::~WantedByRegister() {
}

inline WantedByRegister& WantedByRegister::operator = (const WantedByRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool WantedByRegister::operator == (const WantedByRegister& ) const {
    return true;
}

inline bool WantedByRegister::operator != (const WantedByRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool WantedByRegister::operator < (const WantedByRegister& ) const {
    return false;
}

inline ::asf::core::Payload* WantedByRegister::clone() {
    return new WantedByRegister(*this);
}

inline bool WantedByRegister::operator > (const WantedByRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WantedByRegister::clear() {
}

inline  BoundByUpdate::BoundByUpdate ()  :
    _BoundBy ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BoundByUpdate::BoundByUpdate (const BoundByUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _BoundBy ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BoundByUpdate::BoundByUpdate (const ::std::vector< ::std::string >& BoundBy_)  :
    _BoundBy (BoundBy_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BoundByUpdate::~BoundByUpdate() {
}

inline BoundByUpdate& BoundByUpdate::operator = (const BoundByUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBoundBy()) {
            setBoundBy(rhs.getBoundBy());
        } else {
            clearBoundBy();
        }
    }
    return *this;
}

inline bool BoundByUpdate::operator == (const BoundByUpdate& rhs) const {
    return (((!hasBoundBy() && !rhs.hasBoundBy()) || getBoundBy() == rhs.getBoundBy()));
}

inline bool BoundByUpdate::operator != (const BoundByUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool BoundByUpdate::operator < (const BoundByUpdate& rhs) const {
    if (hasBoundBy() || rhs.hasBoundBy()) {
        if (getBoundBy() < rhs.getBoundBy()) return true;
        if (getBoundBy() > rhs.getBoundBy()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BoundByUpdate::clone() {
    return new BoundByUpdate(*this);
}

inline bool BoundByUpdate::operator > (const BoundByUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BoundByUpdate::clear() {
    clearBoundBy();
}

inline void BoundByUpdate::clearBoundBy() {
    if (hasBoundBy()) {
         clear_has_BoundBy();
        _BoundBy.clear();
     }
}

inline bool BoundByUpdate::hasBoundBy () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& BoundByUpdate::getBoundBy () const {
    return _BoundBy;
}

inline ::std::vector< ::std::string >& BoundByUpdate::getBoundByMutable () {
    set_has_BoundBy();
    return _BoundBy;
}

inline void BoundByUpdate::setBoundBy (const ::std::vector< ::std::string >& BoundBy_) {
    set_has_BoundBy();
    this->_BoundBy = BoundBy_;
}

inline void BoundByUpdate::set_has_BoundBy () {
    _has_bits_[0] |= 1u << 0;
}

inline void BoundByUpdate::clear_has_BoundBy () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BoundByRegister::BoundByRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BoundByRegister::BoundByRegister (const BoundByRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BoundByRegister::~BoundByRegister() {
}

inline BoundByRegister& BoundByRegister::operator = (const BoundByRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool BoundByRegister::operator == (const BoundByRegister& ) const {
    return true;
}

inline bool BoundByRegister::operator != (const BoundByRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool BoundByRegister::operator < (const BoundByRegister& ) const {
    return false;
}

inline ::asf::core::Payload* BoundByRegister::clone() {
    return new BoundByRegister(*this);
}

inline bool BoundByRegister::operator > (const BoundByRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BoundByRegister::clear() {
}

inline  ConsistsOfUpdate::ConsistsOfUpdate ()  :
    _ConsistsOf ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConsistsOfUpdate::ConsistsOfUpdate (const ConsistsOfUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ConsistsOf ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConsistsOfUpdate::ConsistsOfUpdate (const ::std::vector< ::std::string >& ConsistsOf_)  :
    _ConsistsOf (ConsistsOf_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConsistsOfUpdate::~ConsistsOfUpdate() {
}

inline ConsistsOfUpdate& ConsistsOfUpdate::operator = (const ConsistsOfUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConsistsOf()) {
            setConsistsOf(rhs.getConsistsOf());
        } else {
            clearConsistsOf();
        }
    }
    return *this;
}

inline bool ConsistsOfUpdate::operator == (const ConsistsOfUpdate& rhs) const {
    return (((!hasConsistsOf() && !rhs.hasConsistsOf()) || getConsistsOf() == rhs.getConsistsOf()));
}

inline bool ConsistsOfUpdate::operator != (const ConsistsOfUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ConsistsOfUpdate::operator < (const ConsistsOfUpdate& rhs) const {
    if (hasConsistsOf() || rhs.hasConsistsOf()) {
        if (getConsistsOf() < rhs.getConsistsOf()) return true;
        if (getConsistsOf() > rhs.getConsistsOf()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConsistsOfUpdate::clone() {
    return new ConsistsOfUpdate(*this);
}

inline bool ConsistsOfUpdate::operator > (const ConsistsOfUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConsistsOfUpdate::clear() {
    clearConsistsOf();
}

inline void ConsistsOfUpdate::clearConsistsOf() {
    if (hasConsistsOf()) {
         clear_has_ConsistsOf();
        _ConsistsOf.clear();
     }
}

inline bool ConsistsOfUpdate::hasConsistsOf () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& ConsistsOfUpdate::getConsistsOf () const {
    return _ConsistsOf;
}

inline ::std::vector< ::std::string >& ConsistsOfUpdate::getConsistsOfMutable () {
    set_has_ConsistsOf();
    return _ConsistsOf;
}

inline void ConsistsOfUpdate::setConsistsOf (const ::std::vector< ::std::string >& ConsistsOf_) {
    set_has_ConsistsOf();
    this->_ConsistsOf = ConsistsOf_;
}

inline void ConsistsOfUpdate::set_has_ConsistsOf () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConsistsOfUpdate::clear_has_ConsistsOf () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConsistsOfRegister::ConsistsOfRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConsistsOfRegister::ConsistsOfRegister (const ConsistsOfRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConsistsOfRegister::~ConsistsOfRegister() {
}

inline ConsistsOfRegister& ConsistsOfRegister::operator = (const ConsistsOfRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ConsistsOfRegister::operator == (const ConsistsOfRegister& ) const {
    return true;
}

inline bool ConsistsOfRegister::operator != (const ConsistsOfRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ConsistsOfRegister::operator < (const ConsistsOfRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ConsistsOfRegister::clone() {
    return new ConsistsOfRegister(*this);
}

inline bool ConsistsOfRegister::operator > (const ConsistsOfRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConsistsOfRegister::clear() {
}

inline  ConflictsUpdate::ConflictsUpdate ()  :
    _Conflicts ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConflictsUpdate::ConflictsUpdate (const ConflictsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Conflicts ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConflictsUpdate::ConflictsUpdate (const ::std::vector< ::std::string >& Conflicts_)  :
    _Conflicts (Conflicts_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConflictsUpdate::~ConflictsUpdate() {
}

inline ConflictsUpdate& ConflictsUpdate::operator = (const ConflictsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConflicts()) {
            setConflicts(rhs.getConflicts());
        } else {
            clearConflicts();
        }
    }
    return *this;
}

inline bool ConflictsUpdate::operator == (const ConflictsUpdate& rhs) const {
    return (((!hasConflicts() && !rhs.hasConflicts()) || getConflicts() == rhs.getConflicts()));
}

inline bool ConflictsUpdate::operator != (const ConflictsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ConflictsUpdate::operator < (const ConflictsUpdate& rhs) const {
    if (hasConflicts() || rhs.hasConflicts()) {
        if (getConflicts() < rhs.getConflicts()) return true;
        if (getConflicts() > rhs.getConflicts()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConflictsUpdate::clone() {
    return new ConflictsUpdate(*this);
}

inline bool ConflictsUpdate::operator > (const ConflictsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConflictsUpdate::clear() {
    clearConflicts();
}

inline void ConflictsUpdate::clearConflicts() {
    if (hasConflicts()) {
         clear_has_Conflicts();
        _Conflicts.clear();
     }
}

inline bool ConflictsUpdate::hasConflicts () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& ConflictsUpdate::getConflicts () const {
    return _Conflicts;
}

inline ::std::vector< ::std::string >& ConflictsUpdate::getConflictsMutable () {
    set_has_Conflicts();
    return _Conflicts;
}

inline void ConflictsUpdate::setConflicts (const ::std::vector< ::std::string >& Conflicts_) {
    set_has_Conflicts();
    this->_Conflicts = Conflicts_;
}

inline void ConflictsUpdate::set_has_Conflicts () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConflictsUpdate::clear_has_Conflicts () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConflictsRegister::ConflictsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConflictsRegister::ConflictsRegister (const ConflictsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConflictsRegister::~ConflictsRegister() {
}

inline ConflictsRegister& ConflictsRegister::operator = (const ConflictsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ConflictsRegister::operator == (const ConflictsRegister& ) const {
    return true;
}

inline bool ConflictsRegister::operator != (const ConflictsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ConflictsRegister::operator < (const ConflictsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ConflictsRegister::clone() {
    return new ConflictsRegister(*this);
}

inline bool ConflictsRegister::operator > (const ConflictsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConflictsRegister::clear() {
}

inline  ConflictedByUpdate::ConflictedByUpdate ()  :
    _ConflictedBy ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConflictedByUpdate::ConflictedByUpdate (const ConflictedByUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ConflictedBy ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConflictedByUpdate::ConflictedByUpdate (const ::std::vector< ::std::string >& ConflictedBy_)  :
    _ConflictedBy (ConflictedBy_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConflictedByUpdate::~ConflictedByUpdate() {
}

inline ConflictedByUpdate& ConflictedByUpdate::operator = (const ConflictedByUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConflictedBy()) {
            setConflictedBy(rhs.getConflictedBy());
        } else {
            clearConflictedBy();
        }
    }
    return *this;
}

inline bool ConflictedByUpdate::operator == (const ConflictedByUpdate& rhs) const {
    return (((!hasConflictedBy() && !rhs.hasConflictedBy()) || getConflictedBy() == rhs.getConflictedBy()));
}

inline bool ConflictedByUpdate::operator != (const ConflictedByUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ConflictedByUpdate::operator < (const ConflictedByUpdate& rhs) const {
    if (hasConflictedBy() || rhs.hasConflictedBy()) {
        if (getConflictedBy() < rhs.getConflictedBy()) return true;
        if (getConflictedBy() > rhs.getConflictedBy()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConflictedByUpdate::clone() {
    return new ConflictedByUpdate(*this);
}

inline bool ConflictedByUpdate::operator > (const ConflictedByUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConflictedByUpdate::clear() {
    clearConflictedBy();
}

inline void ConflictedByUpdate::clearConflictedBy() {
    if (hasConflictedBy()) {
         clear_has_ConflictedBy();
        _ConflictedBy.clear();
     }
}

inline bool ConflictedByUpdate::hasConflictedBy () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& ConflictedByUpdate::getConflictedBy () const {
    return _ConflictedBy;
}

inline ::std::vector< ::std::string >& ConflictedByUpdate::getConflictedByMutable () {
    set_has_ConflictedBy();
    return _ConflictedBy;
}

inline void ConflictedByUpdate::setConflictedBy (const ::std::vector< ::std::string >& ConflictedBy_) {
    set_has_ConflictedBy();
    this->_ConflictedBy = ConflictedBy_;
}

inline void ConflictedByUpdate::set_has_ConflictedBy () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConflictedByUpdate::clear_has_ConflictedBy () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConflictedByRegister::ConflictedByRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConflictedByRegister::ConflictedByRegister (const ConflictedByRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConflictedByRegister::~ConflictedByRegister() {
}

inline ConflictedByRegister& ConflictedByRegister::operator = (const ConflictedByRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ConflictedByRegister::operator == (const ConflictedByRegister& ) const {
    return true;
}

inline bool ConflictedByRegister::operator != (const ConflictedByRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ConflictedByRegister::operator < (const ConflictedByRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ConflictedByRegister::clone() {
    return new ConflictedByRegister(*this);
}

inline bool ConflictedByRegister::operator > (const ConflictedByRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConflictedByRegister::clear() {
}

inline  BeforeUpdate::BeforeUpdate ()  :
    _Before ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BeforeUpdate::BeforeUpdate (const BeforeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Before ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BeforeUpdate::BeforeUpdate (const ::std::vector< ::std::string >& Before_)  :
    _Before (Before_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BeforeUpdate::~BeforeUpdate() {
}

inline BeforeUpdate& BeforeUpdate::operator = (const BeforeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBefore()) {
            setBefore(rhs.getBefore());
        } else {
            clearBefore();
        }
    }
    return *this;
}

inline bool BeforeUpdate::operator == (const BeforeUpdate& rhs) const {
    return (((!hasBefore() && !rhs.hasBefore()) || getBefore() == rhs.getBefore()));
}

inline bool BeforeUpdate::operator != (const BeforeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool BeforeUpdate::operator < (const BeforeUpdate& rhs) const {
    if (hasBefore() || rhs.hasBefore()) {
        if (getBefore() < rhs.getBefore()) return true;
        if (getBefore() > rhs.getBefore()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BeforeUpdate::clone() {
    return new BeforeUpdate(*this);
}

inline bool BeforeUpdate::operator > (const BeforeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BeforeUpdate::clear() {
    clearBefore();
}

inline void BeforeUpdate::clearBefore() {
    if (hasBefore()) {
         clear_has_Before();
        _Before.clear();
     }
}

inline bool BeforeUpdate::hasBefore () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& BeforeUpdate::getBefore () const {
    return _Before;
}

inline ::std::vector< ::std::string >& BeforeUpdate::getBeforeMutable () {
    set_has_Before();
    return _Before;
}

inline void BeforeUpdate::setBefore (const ::std::vector< ::std::string >& Before_) {
    set_has_Before();
    this->_Before = Before_;
}

inline void BeforeUpdate::set_has_Before () {
    _has_bits_[0] |= 1u << 0;
}

inline void BeforeUpdate::clear_has_Before () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BeforeRegister::BeforeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BeforeRegister::BeforeRegister (const BeforeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BeforeRegister::~BeforeRegister() {
}

inline BeforeRegister& BeforeRegister::operator = (const BeforeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool BeforeRegister::operator == (const BeforeRegister& ) const {
    return true;
}

inline bool BeforeRegister::operator != (const BeforeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool BeforeRegister::operator < (const BeforeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* BeforeRegister::clone() {
    return new BeforeRegister(*this);
}

inline bool BeforeRegister::operator > (const BeforeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BeforeRegister::clear() {
}

inline  AfterUpdate::AfterUpdate ()  :
    _After ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AfterUpdate::AfterUpdate (const AfterUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _After ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AfterUpdate::AfterUpdate (const ::std::vector< ::std::string >& After_)  :
    _After (After_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AfterUpdate::~AfterUpdate() {
}

inline AfterUpdate& AfterUpdate::operator = (const AfterUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAfter()) {
            setAfter(rhs.getAfter());
        } else {
            clearAfter();
        }
    }
    return *this;
}

inline bool AfterUpdate::operator == (const AfterUpdate& rhs) const {
    return (((!hasAfter() && !rhs.hasAfter()) || getAfter() == rhs.getAfter()));
}

inline bool AfterUpdate::operator != (const AfterUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AfterUpdate::operator < (const AfterUpdate& rhs) const {
    if (hasAfter() || rhs.hasAfter()) {
        if (getAfter() < rhs.getAfter()) return true;
        if (getAfter() > rhs.getAfter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AfterUpdate::clone() {
    return new AfterUpdate(*this);
}

inline bool AfterUpdate::operator > (const AfterUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AfterUpdate::clear() {
    clearAfter();
}

inline void AfterUpdate::clearAfter() {
    if (hasAfter()) {
         clear_has_After();
        _After.clear();
     }
}

inline bool AfterUpdate::hasAfter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& AfterUpdate::getAfter () const {
    return _After;
}

inline ::std::vector< ::std::string >& AfterUpdate::getAfterMutable () {
    set_has_After();
    return _After;
}

inline void AfterUpdate::setAfter (const ::std::vector< ::std::string >& After_) {
    set_has_After();
    this->_After = After_;
}

inline void AfterUpdate::set_has_After () {
    _has_bits_[0] |= 1u << 0;
}

inline void AfterUpdate::clear_has_After () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AfterRegister::AfterRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AfterRegister::AfterRegister (const AfterRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AfterRegister::~AfterRegister() {
}

inline AfterRegister& AfterRegister::operator = (const AfterRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AfterRegister::operator == (const AfterRegister& ) const {
    return true;
}

inline bool AfterRegister::operator != (const AfterRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AfterRegister::operator < (const AfterRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AfterRegister::clone() {
    return new AfterRegister(*this);
}

inline bool AfterRegister::operator > (const AfterRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AfterRegister::clear() {
}

inline  OnFailureUpdate::OnFailureUpdate ()  :
    _OnFailure ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnFailureUpdate::OnFailureUpdate (const OnFailureUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _OnFailure ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnFailureUpdate::OnFailureUpdate (const ::std::vector< ::std::string >& OnFailure_)  :
    _OnFailure (OnFailure_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnFailureUpdate::~OnFailureUpdate() {
}

inline OnFailureUpdate& OnFailureUpdate::operator = (const OnFailureUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOnFailure()) {
            setOnFailure(rhs.getOnFailure());
        } else {
            clearOnFailure();
        }
    }
    return *this;
}

inline bool OnFailureUpdate::operator == (const OnFailureUpdate& rhs) const {
    return (((!hasOnFailure() && !rhs.hasOnFailure()) || getOnFailure() == rhs.getOnFailure()));
}

inline bool OnFailureUpdate::operator != (const OnFailureUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool OnFailureUpdate::operator < (const OnFailureUpdate& rhs) const {
    if (hasOnFailure() || rhs.hasOnFailure()) {
        if (getOnFailure() < rhs.getOnFailure()) return true;
        if (getOnFailure() > rhs.getOnFailure()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnFailureUpdate::clone() {
    return new OnFailureUpdate(*this);
}

inline bool OnFailureUpdate::operator > (const OnFailureUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnFailureUpdate::clear() {
    clearOnFailure();
}

inline void OnFailureUpdate::clearOnFailure() {
    if (hasOnFailure()) {
         clear_has_OnFailure();
        _OnFailure.clear();
     }
}

inline bool OnFailureUpdate::hasOnFailure () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& OnFailureUpdate::getOnFailure () const {
    return _OnFailure;
}

inline ::std::vector< ::std::string >& OnFailureUpdate::getOnFailureMutable () {
    set_has_OnFailure();
    return _OnFailure;
}

inline void OnFailureUpdate::setOnFailure (const ::std::vector< ::std::string >& OnFailure_) {
    set_has_OnFailure();
    this->_OnFailure = OnFailure_;
}

inline void OnFailureUpdate::set_has_OnFailure () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnFailureUpdate::clear_has_OnFailure () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  OnFailureRegister::OnFailureRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnFailureRegister::OnFailureRegister (const OnFailureRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnFailureRegister::~OnFailureRegister() {
}

inline OnFailureRegister& OnFailureRegister::operator = (const OnFailureRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool OnFailureRegister::operator == (const OnFailureRegister& ) const {
    return true;
}

inline bool OnFailureRegister::operator != (const OnFailureRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool OnFailureRegister::operator < (const OnFailureRegister& ) const {
    return false;
}

inline ::asf::core::Payload* OnFailureRegister::clone() {
    return new OnFailureRegister(*this);
}

inline bool OnFailureRegister::operator > (const OnFailureRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnFailureRegister::clear() {
}

inline  TriggersUpdate::TriggersUpdate ()  :
    _Triggers ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TriggersUpdate::TriggersUpdate (const TriggersUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Triggers ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TriggersUpdate::TriggersUpdate (const ::std::vector< ::std::string >& Triggers_)  :
    _Triggers (Triggers_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TriggersUpdate::~TriggersUpdate() {
}

inline TriggersUpdate& TriggersUpdate::operator = (const TriggersUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTriggers()) {
            setTriggers(rhs.getTriggers());
        } else {
            clearTriggers();
        }
    }
    return *this;
}

inline bool TriggersUpdate::operator == (const TriggersUpdate& rhs) const {
    return (((!hasTriggers() && !rhs.hasTriggers()) || getTriggers() == rhs.getTriggers()));
}

inline bool TriggersUpdate::operator != (const TriggersUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TriggersUpdate::operator < (const TriggersUpdate& rhs) const {
    if (hasTriggers() || rhs.hasTriggers()) {
        if (getTriggers() < rhs.getTriggers()) return true;
        if (getTriggers() > rhs.getTriggers()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TriggersUpdate::clone() {
    return new TriggersUpdate(*this);
}

inline bool TriggersUpdate::operator > (const TriggersUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TriggersUpdate::clear() {
    clearTriggers();
}

inline void TriggersUpdate::clearTriggers() {
    if (hasTriggers()) {
         clear_has_Triggers();
        _Triggers.clear();
     }
}

inline bool TriggersUpdate::hasTriggers () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& TriggersUpdate::getTriggers () const {
    return _Triggers;
}

inline ::std::vector< ::std::string >& TriggersUpdate::getTriggersMutable () {
    set_has_Triggers();
    return _Triggers;
}

inline void TriggersUpdate::setTriggers (const ::std::vector< ::std::string >& Triggers_) {
    set_has_Triggers();
    this->_Triggers = Triggers_;
}

inline void TriggersUpdate::set_has_Triggers () {
    _has_bits_[0] |= 1u << 0;
}

inline void TriggersUpdate::clear_has_Triggers () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TriggersRegister::TriggersRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TriggersRegister::TriggersRegister (const TriggersRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TriggersRegister::~TriggersRegister() {
}

inline TriggersRegister& TriggersRegister::operator = (const TriggersRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TriggersRegister::operator == (const TriggersRegister& ) const {
    return true;
}

inline bool TriggersRegister::operator != (const TriggersRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TriggersRegister::operator < (const TriggersRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TriggersRegister::clone() {
    return new TriggersRegister(*this);
}

inline bool TriggersRegister::operator > (const TriggersRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TriggersRegister::clear() {
}

inline  TriggeredByUpdate::TriggeredByUpdate ()  :
    _TriggeredBy ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TriggeredByUpdate::TriggeredByUpdate (const TriggeredByUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _TriggeredBy ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TriggeredByUpdate::TriggeredByUpdate (const ::std::vector< ::std::string >& TriggeredBy_)  :
    _TriggeredBy (TriggeredBy_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TriggeredByUpdate::~TriggeredByUpdate() {
}

inline TriggeredByUpdate& TriggeredByUpdate::operator = (const TriggeredByUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTriggeredBy()) {
            setTriggeredBy(rhs.getTriggeredBy());
        } else {
            clearTriggeredBy();
        }
    }
    return *this;
}

inline bool TriggeredByUpdate::operator == (const TriggeredByUpdate& rhs) const {
    return (((!hasTriggeredBy() && !rhs.hasTriggeredBy()) || getTriggeredBy() == rhs.getTriggeredBy()));
}

inline bool TriggeredByUpdate::operator != (const TriggeredByUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TriggeredByUpdate::operator < (const TriggeredByUpdate& rhs) const {
    if (hasTriggeredBy() || rhs.hasTriggeredBy()) {
        if (getTriggeredBy() < rhs.getTriggeredBy()) return true;
        if (getTriggeredBy() > rhs.getTriggeredBy()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TriggeredByUpdate::clone() {
    return new TriggeredByUpdate(*this);
}

inline bool TriggeredByUpdate::operator > (const TriggeredByUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TriggeredByUpdate::clear() {
    clearTriggeredBy();
}

inline void TriggeredByUpdate::clearTriggeredBy() {
    if (hasTriggeredBy()) {
         clear_has_TriggeredBy();
        _TriggeredBy.clear();
     }
}

inline bool TriggeredByUpdate::hasTriggeredBy () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& TriggeredByUpdate::getTriggeredBy () const {
    return _TriggeredBy;
}

inline ::std::vector< ::std::string >& TriggeredByUpdate::getTriggeredByMutable () {
    set_has_TriggeredBy();
    return _TriggeredBy;
}

inline void TriggeredByUpdate::setTriggeredBy (const ::std::vector< ::std::string >& TriggeredBy_) {
    set_has_TriggeredBy();
    this->_TriggeredBy = TriggeredBy_;
}

inline void TriggeredByUpdate::set_has_TriggeredBy () {
    _has_bits_[0] |= 1u << 0;
}

inline void TriggeredByUpdate::clear_has_TriggeredBy () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TriggeredByRegister::TriggeredByRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TriggeredByRegister::TriggeredByRegister (const TriggeredByRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TriggeredByRegister::~TriggeredByRegister() {
}

inline TriggeredByRegister& TriggeredByRegister::operator = (const TriggeredByRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TriggeredByRegister::operator == (const TriggeredByRegister& ) const {
    return true;
}

inline bool TriggeredByRegister::operator != (const TriggeredByRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TriggeredByRegister::operator < (const TriggeredByRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TriggeredByRegister::clone() {
    return new TriggeredByRegister(*this);
}

inline bool TriggeredByRegister::operator > (const TriggeredByRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TriggeredByRegister::clear() {
}

inline  PropagatesReloadToUpdate::PropagatesReloadToUpdate ()  :
    _PropagatesReloadTo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PropagatesReloadToUpdate::PropagatesReloadToUpdate (const PropagatesReloadToUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _PropagatesReloadTo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PropagatesReloadToUpdate::PropagatesReloadToUpdate (const ::std::vector< ::std::string >& PropagatesReloadTo_)  :
    _PropagatesReloadTo (PropagatesReloadTo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PropagatesReloadToUpdate::~PropagatesReloadToUpdate() {
}

inline PropagatesReloadToUpdate& PropagatesReloadToUpdate::operator = (const PropagatesReloadToUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPropagatesReloadTo()) {
            setPropagatesReloadTo(rhs.getPropagatesReloadTo());
        } else {
            clearPropagatesReloadTo();
        }
    }
    return *this;
}

inline bool PropagatesReloadToUpdate::operator == (const PropagatesReloadToUpdate& rhs) const {
    return (((!hasPropagatesReloadTo() && !rhs.hasPropagatesReloadTo()) || getPropagatesReloadTo() == rhs.getPropagatesReloadTo()));
}

inline bool PropagatesReloadToUpdate::operator != (const PropagatesReloadToUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PropagatesReloadToUpdate::operator < (const PropagatesReloadToUpdate& rhs) const {
    if (hasPropagatesReloadTo() || rhs.hasPropagatesReloadTo()) {
        if (getPropagatesReloadTo() < rhs.getPropagatesReloadTo()) return true;
        if (getPropagatesReloadTo() > rhs.getPropagatesReloadTo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PropagatesReloadToUpdate::clone() {
    return new PropagatesReloadToUpdate(*this);
}

inline bool PropagatesReloadToUpdate::operator > (const PropagatesReloadToUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PropagatesReloadToUpdate::clear() {
    clearPropagatesReloadTo();
}

inline void PropagatesReloadToUpdate::clearPropagatesReloadTo() {
    if (hasPropagatesReloadTo()) {
         clear_has_PropagatesReloadTo();
        _PropagatesReloadTo.clear();
     }
}

inline bool PropagatesReloadToUpdate::hasPropagatesReloadTo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& PropagatesReloadToUpdate::getPropagatesReloadTo () const {
    return _PropagatesReloadTo;
}

inline ::std::vector< ::std::string >& PropagatesReloadToUpdate::getPropagatesReloadToMutable () {
    set_has_PropagatesReloadTo();
    return _PropagatesReloadTo;
}

inline void PropagatesReloadToUpdate::setPropagatesReloadTo (const ::std::vector< ::std::string >& PropagatesReloadTo_) {
    set_has_PropagatesReloadTo();
    this->_PropagatesReloadTo = PropagatesReloadTo_;
}

inline void PropagatesReloadToUpdate::set_has_PropagatesReloadTo () {
    _has_bits_[0] |= 1u << 0;
}

inline void PropagatesReloadToUpdate::clear_has_PropagatesReloadTo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PropagatesReloadToRegister::PropagatesReloadToRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PropagatesReloadToRegister::PropagatesReloadToRegister (const PropagatesReloadToRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PropagatesReloadToRegister::~PropagatesReloadToRegister() {
}

inline PropagatesReloadToRegister& PropagatesReloadToRegister::operator = (const PropagatesReloadToRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PropagatesReloadToRegister::operator == (const PropagatesReloadToRegister& ) const {
    return true;
}

inline bool PropagatesReloadToRegister::operator != (const PropagatesReloadToRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PropagatesReloadToRegister::operator < (const PropagatesReloadToRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PropagatesReloadToRegister::clone() {
    return new PropagatesReloadToRegister(*this);
}

inline bool PropagatesReloadToRegister::operator > (const PropagatesReloadToRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PropagatesReloadToRegister::clear() {
}

inline  ReloadPropagatedFromUpdate::ReloadPropagatedFromUpdate ()  :
    _ReloadPropagatedFrom ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadPropagatedFromUpdate::ReloadPropagatedFromUpdate (const ReloadPropagatedFromUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ReloadPropagatedFrom ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadPropagatedFromUpdate::ReloadPropagatedFromUpdate (const ::std::vector< ::std::string >& ReloadPropagatedFrom_)  :
    _ReloadPropagatedFrom (ReloadPropagatedFrom_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadPropagatedFromUpdate::~ReloadPropagatedFromUpdate() {
}

inline ReloadPropagatedFromUpdate& ReloadPropagatedFromUpdate::operator = (const ReloadPropagatedFromUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasReloadPropagatedFrom()) {
            setReloadPropagatedFrom(rhs.getReloadPropagatedFrom());
        } else {
            clearReloadPropagatedFrom();
        }
    }
    return *this;
}

inline bool ReloadPropagatedFromUpdate::operator == (const ReloadPropagatedFromUpdate& rhs) const {
    return (((!hasReloadPropagatedFrom() && !rhs.hasReloadPropagatedFrom()) || getReloadPropagatedFrom() == rhs.getReloadPropagatedFrom()));
}

inline bool ReloadPropagatedFromUpdate::operator != (const ReloadPropagatedFromUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadPropagatedFromUpdate::operator < (const ReloadPropagatedFromUpdate& rhs) const {
    if (hasReloadPropagatedFrom() || rhs.hasReloadPropagatedFrom()) {
        if (getReloadPropagatedFrom() < rhs.getReloadPropagatedFrom()) return true;
        if (getReloadPropagatedFrom() > rhs.getReloadPropagatedFrom()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadPropagatedFromUpdate::clone() {
    return new ReloadPropagatedFromUpdate(*this);
}

inline bool ReloadPropagatedFromUpdate::operator > (const ReloadPropagatedFromUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadPropagatedFromUpdate::clear() {
    clearReloadPropagatedFrom();
}

inline void ReloadPropagatedFromUpdate::clearReloadPropagatedFrom() {
    if (hasReloadPropagatedFrom()) {
         clear_has_ReloadPropagatedFrom();
        _ReloadPropagatedFrom.clear();
     }
}

inline bool ReloadPropagatedFromUpdate::hasReloadPropagatedFrom () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& ReloadPropagatedFromUpdate::getReloadPropagatedFrom () const {
    return _ReloadPropagatedFrom;
}

inline ::std::vector< ::std::string >& ReloadPropagatedFromUpdate::getReloadPropagatedFromMutable () {
    set_has_ReloadPropagatedFrom();
    return _ReloadPropagatedFrom;
}

inline void ReloadPropagatedFromUpdate::setReloadPropagatedFrom (const ::std::vector< ::std::string >& ReloadPropagatedFrom_) {
    set_has_ReloadPropagatedFrom();
    this->_ReloadPropagatedFrom = ReloadPropagatedFrom_;
}

inline void ReloadPropagatedFromUpdate::set_has_ReloadPropagatedFrom () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadPropagatedFromUpdate::clear_has_ReloadPropagatedFrom () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReloadPropagatedFromRegister::ReloadPropagatedFromRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadPropagatedFromRegister::ReloadPropagatedFromRegister (const ReloadPropagatedFromRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadPropagatedFromRegister::~ReloadPropagatedFromRegister() {
}

inline ReloadPropagatedFromRegister& ReloadPropagatedFromRegister::operator = (const ReloadPropagatedFromRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ReloadPropagatedFromRegister::operator == (const ReloadPropagatedFromRegister& ) const {
    return true;
}

inline bool ReloadPropagatedFromRegister::operator != (const ReloadPropagatedFromRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadPropagatedFromRegister::operator < (const ReloadPropagatedFromRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ReloadPropagatedFromRegister::clone() {
    return new ReloadPropagatedFromRegister(*this);
}

inline bool ReloadPropagatedFromRegister::operator > (const ReloadPropagatedFromRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadPropagatedFromRegister::clear() {
}

inline  JoinsNamespaceOfUpdate::JoinsNamespaceOfUpdate ()  :
    _JoinsNamespaceOf ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  JoinsNamespaceOfUpdate::JoinsNamespaceOfUpdate (const JoinsNamespaceOfUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _JoinsNamespaceOf ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  JoinsNamespaceOfUpdate::JoinsNamespaceOfUpdate (const ::std::vector< ::std::string >& JoinsNamespaceOf_)  :
    _JoinsNamespaceOf (JoinsNamespaceOf_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  JoinsNamespaceOfUpdate::~JoinsNamespaceOfUpdate() {
}

inline JoinsNamespaceOfUpdate& JoinsNamespaceOfUpdate::operator = (const JoinsNamespaceOfUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJoinsNamespaceOf()) {
            setJoinsNamespaceOf(rhs.getJoinsNamespaceOf());
        } else {
            clearJoinsNamespaceOf();
        }
    }
    return *this;
}

inline bool JoinsNamespaceOfUpdate::operator == (const JoinsNamespaceOfUpdate& rhs) const {
    return (((!hasJoinsNamespaceOf() && !rhs.hasJoinsNamespaceOf()) || getJoinsNamespaceOf() == rhs.getJoinsNamespaceOf()));
}

inline bool JoinsNamespaceOfUpdate::operator != (const JoinsNamespaceOfUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool JoinsNamespaceOfUpdate::operator < (const JoinsNamespaceOfUpdate& rhs) const {
    if (hasJoinsNamespaceOf() || rhs.hasJoinsNamespaceOf()) {
        if (getJoinsNamespaceOf() < rhs.getJoinsNamespaceOf()) return true;
        if (getJoinsNamespaceOf() > rhs.getJoinsNamespaceOf()) return false;
    }
    return false;
}

inline ::asf::core::Payload* JoinsNamespaceOfUpdate::clone() {
    return new JoinsNamespaceOfUpdate(*this);
}

inline bool JoinsNamespaceOfUpdate::operator > (const JoinsNamespaceOfUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void JoinsNamespaceOfUpdate::clear() {
    clearJoinsNamespaceOf();
}

inline void JoinsNamespaceOfUpdate::clearJoinsNamespaceOf() {
    if (hasJoinsNamespaceOf()) {
         clear_has_JoinsNamespaceOf();
        _JoinsNamespaceOf.clear();
     }
}

inline bool JoinsNamespaceOfUpdate::hasJoinsNamespaceOf () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& JoinsNamespaceOfUpdate::getJoinsNamespaceOf () const {
    return _JoinsNamespaceOf;
}

inline ::std::vector< ::std::string >& JoinsNamespaceOfUpdate::getJoinsNamespaceOfMutable () {
    set_has_JoinsNamespaceOf();
    return _JoinsNamespaceOf;
}

inline void JoinsNamespaceOfUpdate::setJoinsNamespaceOf (const ::std::vector< ::std::string >& JoinsNamespaceOf_) {
    set_has_JoinsNamespaceOf();
    this->_JoinsNamespaceOf = JoinsNamespaceOf_;
}

inline void JoinsNamespaceOfUpdate::set_has_JoinsNamespaceOf () {
    _has_bits_[0] |= 1u << 0;
}

inline void JoinsNamespaceOfUpdate::clear_has_JoinsNamespaceOf () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  JoinsNamespaceOfRegister::JoinsNamespaceOfRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  JoinsNamespaceOfRegister::JoinsNamespaceOfRegister (const JoinsNamespaceOfRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  JoinsNamespaceOfRegister::~JoinsNamespaceOfRegister() {
}

inline JoinsNamespaceOfRegister& JoinsNamespaceOfRegister::operator = (const JoinsNamespaceOfRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool JoinsNamespaceOfRegister::operator == (const JoinsNamespaceOfRegister& ) const {
    return true;
}

inline bool JoinsNamespaceOfRegister::operator != (const JoinsNamespaceOfRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool JoinsNamespaceOfRegister::operator < (const JoinsNamespaceOfRegister& ) const {
    return false;
}

inline ::asf::core::Payload* JoinsNamespaceOfRegister::clone() {
    return new JoinsNamespaceOfRegister(*this);
}

inline bool JoinsNamespaceOfRegister::operator > (const JoinsNamespaceOfRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void JoinsNamespaceOfRegister::clear() {
}

inline  RequiresMountsForUpdate::RequiresMountsForUpdate ()  :
    _RequiresMountsFor ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequiresMountsForUpdate::RequiresMountsForUpdate (const RequiresMountsForUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RequiresMountsFor ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequiresMountsForUpdate::RequiresMountsForUpdate (const ::std::vector< ::std::string >& RequiresMountsFor_)  :
    _RequiresMountsFor (RequiresMountsFor_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequiresMountsForUpdate::~RequiresMountsForUpdate() {
}

inline RequiresMountsForUpdate& RequiresMountsForUpdate::operator = (const RequiresMountsForUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequiresMountsFor()) {
            setRequiresMountsFor(rhs.getRequiresMountsFor());
        } else {
            clearRequiresMountsFor();
        }
    }
    return *this;
}

inline bool RequiresMountsForUpdate::operator == (const RequiresMountsForUpdate& rhs) const {
    return (((!hasRequiresMountsFor() && !rhs.hasRequiresMountsFor()) || getRequiresMountsFor() == rhs.getRequiresMountsFor()));
}

inline bool RequiresMountsForUpdate::operator != (const RequiresMountsForUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RequiresMountsForUpdate::operator < (const RequiresMountsForUpdate& rhs) const {
    if (hasRequiresMountsFor() || rhs.hasRequiresMountsFor()) {
        if (getRequiresMountsFor() < rhs.getRequiresMountsFor()) return true;
        if (getRequiresMountsFor() > rhs.getRequiresMountsFor()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequiresMountsForUpdate::clone() {
    return new RequiresMountsForUpdate(*this);
}

inline bool RequiresMountsForUpdate::operator > (const RequiresMountsForUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequiresMountsForUpdate::clear() {
    clearRequiresMountsFor();
}

inline void RequiresMountsForUpdate::clearRequiresMountsFor() {
    if (hasRequiresMountsFor()) {
         clear_has_RequiresMountsFor();
        _RequiresMountsFor.clear();
     }
}

inline bool RequiresMountsForUpdate::hasRequiresMountsFor () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& RequiresMountsForUpdate::getRequiresMountsFor () const {
    return _RequiresMountsFor;
}

inline ::std::vector< ::std::string >& RequiresMountsForUpdate::getRequiresMountsForMutable () {
    set_has_RequiresMountsFor();
    return _RequiresMountsFor;
}

inline void RequiresMountsForUpdate::setRequiresMountsFor (const ::std::vector< ::std::string >& RequiresMountsFor_) {
    set_has_RequiresMountsFor();
    this->_RequiresMountsFor = RequiresMountsFor_;
}

inline void RequiresMountsForUpdate::set_has_RequiresMountsFor () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequiresMountsForUpdate::clear_has_RequiresMountsFor () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequiresMountsForRegister::RequiresMountsForRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequiresMountsForRegister::RequiresMountsForRegister (const RequiresMountsForRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequiresMountsForRegister::~RequiresMountsForRegister() {
}

inline RequiresMountsForRegister& RequiresMountsForRegister::operator = (const RequiresMountsForRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RequiresMountsForRegister::operator == (const RequiresMountsForRegister& ) const {
    return true;
}

inline bool RequiresMountsForRegister::operator != (const RequiresMountsForRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RequiresMountsForRegister::operator < (const RequiresMountsForRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RequiresMountsForRegister::clone() {
    return new RequiresMountsForRegister(*this);
}

inline bool RequiresMountsForRegister::operator > (const RequiresMountsForRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequiresMountsForRegister::clear() {
}

inline  DocumentationUpdate::DocumentationUpdate ()  :
    _Documentation ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DocumentationUpdate::DocumentationUpdate (const DocumentationUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Documentation ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DocumentationUpdate::DocumentationUpdate (const ::std::vector< ::std::string >& Documentation_)  :
    _Documentation (Documentation_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DocumentationUpdate::~DocumentationUpdate() {
}

inline DocumentationUpdate& DocumentationUpdate::operator = (const DocumentationUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDocumentation()) {
            setDocumentation(rhs.getDocumentation());
        } else {
            clearDocumentation();
        }
    }
    return *this;
}

inline bool DocumentationUpdate::operator == (const DocumentationUpdate& rhs) const {
    return (((!hasDocumentation() && !rhs.hasDocumentation()) || getDocumentation() == rhs.getDocumentation()));
}

inline bool DocumentationUpdate::operator != (const DocumentationUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DocumentationUpdate::operator < (const DocumentationUpdate& rhs) const {
    if (hasDocumentation() || rhs.hasDocumentation()) {
        if (getDocumentation() < rhs.getDocumentation()) return true;
        if (getDocumentation() > rhs.getDocumentation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DocumentationUpdate::clone() {
    return new DocumentationUpdate(*this);
}

inline bool DocumentationUpdate::operator > (const DocumentationUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DocumentationUpdate::clear() {
    clearDocumentation();
}

inline void DocumentationUpdate::clearDocumentation() {
    if (hasDocumentation()) {
         clear_has_Documentation();
        _Documentation.clear();
     }
}

inline bool DocumentationUpdate::hasDocumentation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& DocumentationUpdate::getDocumentation () const {
    return _Documentation;
}

inline ::std::vector< ::std::string >& DocumentationUpdate::getDocumentationMutable () {
    set_has_Documentation();
    return _Documentation;
}

inline void DocumentationUpdate::setDocumentation (const ::std::vector< ::std::string >& Documentation_) {
    set_has_Documentation();
    this->_Documentation = Documentation_;
}

inline void DocumentationUpdate::set_has_Documentation () {
    _has_bits_[0] |= 1u << 0;
}

inline void DocumentationUpdate::clear_has_Documentation () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DocumentationRegister::DocumentationRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DocumentationRegister::DocumentationRegister (const DocumentationRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DocumentationRegister::~DocumentationRegister() {
}

inline DocumentationRegister& DocumentationRegister::operator = (const DocumentationRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DocumentationRegister::operator == (const DocumentationRegister& ) const {
    return true;
}

inline bool DocumentationRegister::operator != (const DocumentationRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DocumentationRegister::operator < (const DocumentationRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DocumentationRegister::clone() {
    return new DocumentationRegister(*this);
}

inline bool DocumentationRegister::operator > (const DocumentationRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DocumentationRegister::clear() {
}

inline  DescriptionUpdate::DescriptionUpdate ()  :
    _Description ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DescriptionUpdate::DescriptionUpdate (const DescriptionUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Description ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DescriptionUpdate::DescriptionUpdate (const ::std::string& Description_)  :
    _Description (Description_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Description_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DescriptionUpdate::~DescriptionUpdate() {
}

inline DescriptionUpdate& DescriptionUpdate::operator = (const DescriptionUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDescription()) {
            setDescription(rhs.getDescription());
        } else {
            clearDescription();
        }
    }
    return *this;
}

inline bool DescriptionUpdate::operator == (const DescriptionUpdate& rhs) const {
    return (((!hasDescription() && !rhs.hasDescription()) || getDescription() == rhs.getDescription()));
}

inline bool DescriptionUpdate::operator != (const DescriptionUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DescriptionUpdate::operator < (const DescriptionUpdate& rhs) const {
    if (hasDescription() || rhs.hasDescription()) {
        if (getDescription() < rhs.getDescription()) return true;
        if (getDescription() > rhs.getDescription()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DescriptionUpdate::clone() {
    return new DescriptionUpdate(*this);
}

inline bool DescriptionUpdate::operator > (const DescriptionUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DescriptionUpdate::clear() {
    clearDescription();
}

inline void DescriptionUpdate::clearDescription() {
    if (hasDescription()) {
         clear_has_Description();
        _Description.clear();
     }
}

inline bool DescriptionUpdate::hasDescription () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DescriptionUpdate::getDescription () const {
    return _Description;
}

inline ::std::string& DescriptionUpdate::getDescriptionMutable () {
    set_has_Description();
    return _Description;
}

inline void DescriptionUpdate::setDescription (const ::std::string& Description_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Description_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Description();
    this->_Description = Description_;
}

inline void DescriptionUpdate::setDescription (const char* Description_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Description_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Description();
    this->_Description.assign(Description_);
}

inline void DescriptionUpdate::setDescription (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Description();
    this->_Description.assign(value, size);
}

inline void DescriptionUpdate::set_has_Description () {
    _has_bits_[0] |= 1u << 0;
}

inline void DescriptionUpdate::clear_has_Description () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DescriptionRegister::DescriptionRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DescriptionRegister::DescriptionRegister (const DescriptionRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DescriptionRegister::~DescriptionRegister() {
}

inline DescriptionRegister& DescriptionRegister::operator = (const DescriptionRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DescriptionRegister::operator == (const DescriptionRegister& ) const {
    return true;
}

inline bool DescriptionRegister::operator != (const DescriptionRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DescriptionRegister::operator < (const DescriptionRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DescriptionRegister::clone() {
    return new DescriptionRegister(*this);
}

inline bool DescriptionRegister::operator > (const DescriptionRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DescriptionRegister::clear() {
}

inline  LoadStateUpdate::LoadStateUpdate ()  :
    _LoadState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LoadStateUpdate::LoadStateUpdate (const LoadStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _LoadState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LoadStateUpdate::LoadStateUpdate (const ::std::string& LoadState_)  :
    _LoadState (LoadState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LoadState_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LoadStateUpdate::~LoadStateUpdate() {
}

inline LoadStateUpdate& LoadStateUpdate::operator = (const LoadStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLoadState()) {
            setLoadState(rhs.getLoadState());
        } else {
            clearLoadState();
        }
    }
    return *this;
}

inline bool LoadStateUpdate::operator == (const LoadStateUpdate& rhs) const {
    return (((!hasLoadState() && !rhs.hasLoadState()) || getLoadState() == rhs.getLoadState()));
}

inline bool LoadStateUpdate::operator != (const LoadStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool LoadStateUpdate::operator < (const LoadStateUpdate& rhs) const {
    if (hasLoadState() || rhs.hasLoadState()) {
        if (getLoadState() < rhs.getLoadState()) return true;
        if (getLoadState() > rhs.getLoadState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LoadStateUpdate::clone() {
    return new LoadStateUpdate(*this);
}

inline bool LoadStateUpdate::operator > (const LoadStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LoadStateUpdate::clear() {
    clearLoadState();
}

inline void LoadStateUpdate::clearLoadState() {
    if (hasLoadState()) {
         clear_has_LoadState();
        _LoadState.clear();
     }
}

inline bool LoadStateUpdate::hasLoadState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LoadStateUpdate::getLoadState () const {
    return _LoadState;
}

inline ::std::string& LoadStateUpdate::getLoadStateMutable () {
    set_has_LoadState();
    return _LoadState;
}

inline void LoadStateUpdate::setLoadState (const ::std::string& LoadState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LoadState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LoadState();
    this->_LoadState = LoadState_;
}

inline void LoadStateUpdate::setLoadState (const char* LoadState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LoadState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LoadState();
    this->_LoadState.assign(LoadState_);
}

inline void LoadStateUpdate::setLoadState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LoadState();
    this->_LoadState.assign(value, size);
}

inline void LoadStateUpdate::set_has_LoadState () {
    _has_bits_[0] |= 1u << 0;
}

inline void LoadStateUpdate::clear_has_LoadState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LoadStateRegister::LoadStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LoadStateRegister::LoadStateRegister (const LoadStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LoadStateRegister::~LoadStateRegister() {
}

inline LoadStateRegister& LoadStateRegister::operator = (const LoadStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool LoadStateRegister::operator == (const LoadStateRegister& ) const {
    return true;
}

inline bool LoadStateRegister::operator != (const LoadStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool LoadStateRegister::operator < (const LoadStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* LoadStateRegister::clone() {
    return new LoadStateRegister(*this);
}

inline bool LoadStateRegister::operator > (const LoadStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LoadStateRegister::clear() {
}

inline  ActiveStateUpdate::ActiveStateUpdate ()  :
    _ActiveState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveStateUpdate::ActiveStateUpdate (const ActiveStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ActiveState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveStateUpdate::ActiveStateUpdate (const ::std::string& ActiveState_)  :
    _ActiveState (ActiveState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ActiveState_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveStateUpdate::~ActiveStateUpdate() {
}

inline ActiveStateUpdate& ActiveStateUpdate::operator = (const ActiveStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveState()) {
            setActiveState(rhs.getActiveState());
        } else {
            clearActiveState();
        }
    }
    return *this;
}

inline bool ActiveStateUpdate::operator == (const ActiveStateUpdate& rhs) const {
    return (((!hasActiveState() && !rhs.hasActiveState()) || getActiveState() == rhs.getActiveState()));
}

inline bool ActiveStateUpdate::operator != (const ActiveStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveStateUpdate::operator < (const ActiveStateUpdate& rhs) const {
    if (hasActiveState() || rhs.hasActiveState()) {
        if (getActiveState() < rhs.getActiveState()) return true;
        if (getActiveState() > rhs.getActiveState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveStateUpdate::clone() {
    return new ActiveStateUpdate(*this);
}

inline bool ActiveStateUpdate::operator > (const ActiveStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveStateUpdate::clear() {
    clearActiveState();
}

inline void ActiveStateUpdate::clearActiveState() {
    if (hasActiveState()) {
         clear_has_ActiveState();
        _ActiveState.clear();
     }
}

inline bool ActiveStateUpdate::hasActiveState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ActiveStateUpdate::getActiveState () const {
    return _ActiveState;
}

inline ::std::string& ActiveStateUpdate::getActiveStateMutable () {
    set_has_ActiveState();
    return _ActiveState;
}

inline void ActiveStateUpdate::setActiveState (const ::std::string& ActiveState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ActiveState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ActiveState();
    this->_ActiveState = ActiveState_;
}

inline void ActiveStateUpdate::setActiveState (const char* ActiveState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ActiveState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ActiveState();
    this->_ActiveState.assign(ActiveState_);
}

inline void ActiveStateUpdate::setActiveState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ActiveState();
    this->_ActiveState.assign(value, size);
}

inline void ActiveStateUpdate::set_has_ActiveState () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveStateUpdate::clear_has_ActiveState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveStateRegister::ActiveStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveStateRegister::ActiveStateRegister (const ActiveStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveStateRegister::~ActiveStateRegister() {
}

inline ActiveStateRegister& ActiveStateRegister::operator = (const ActiveStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveStateRegister::operator == (const ActiveStateRegister& ) const {
    return true;
}

inline bool ActiveStateRegister::operator != (const ActiveStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveStateRegister::operator < (const ActiveStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveStateRegister::clone() {
    return new ActiveStateRegister(*this);
}

inline bool ActiveStateRegister::operator > (const ActiveStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveStateRegister::clear() {
}

inline  SubStateUpdate::SubStateUpdate ()  :
    _SubState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SubStateUpdate::SubStateUpdate (const SubStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SubState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SubStateUpdate::SubStateUpdate (const ::std::string& SubState_)  :
    _SubState (SubState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SubState_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SubStateUpdate::~SubStateUpdate() {
}

inline SubStateUpdate& SubStateUpdate::operator = (const SubStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSubState()) {
            setSubState(rhs.getSubState());
        } else {
            clearSubState();
        }
    }
    return *this;
}

inline bool SubStateUpdate::operator == (const SubStateUpdate& rhs) const {
    return (((!hasSubState() && !rhs.hasSubState()) || getSubState() == rhs.getSubState()));
}

inline bool SubStateUpdate::operator != (const SubStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SubStateUpdate::operator < (const SubStateUpdate& rhs) const {
    if (hasSubState() || rhs.hasSubState()) {
        if (getSubState() < rhs.getSubState()) return true;
        if (getSubState() > rhs.getSubState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SubStateUpdate::clone() {
    return new SubStateUpdate(*this);
}

inline bool SubStateUpdate::operator > (const SubStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SubStateUpdate::clear() {
    clearSubState();
}

inline void SubStateUpdate::clearSubState() {
    if (hasSubState()) {
         clear_has_SubState();
        _SubState.clear();
     }
}

inline bool SubStateUpdate::hasSubState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SubStateUpdate::getSubState () const {
    return _SubState;
}

inline ::std::string& SubStateUpdate::getSubStateMutable () {
    set_has_SubState();
    return _SubState;
}

inline void SubStateUpdate::setSubState (const ::std::string& SubState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SubState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SubState();
    this->_SubState = SubState_;
}

inline void SubStateUpdate::setSubState (const char* SubState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SubState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SubState();
    this->_SubState.assign(SubState_);
}

inline void SubStateUpdate::setSubState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SubState();
    this->_SubState.assign(value, size);
}

inline void SubStateUpdate::set_has_SubState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SubStateUpdate::clear_has_SubState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SubStateRegister::SubStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SubStateRegister::SubStateRegister (const SubStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SubStateRegister::~SubStateRegister() {
}

inline SubStateRegister& SubStateRegister::operator = (const SubStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SubStateRegister::operator == (const SubStateRegister& ) const {
    return true;
}

inline bool SubStateRegister::operator != (const SubStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SubStateRegister::operator < (const SubStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SubStateRegister::clone() {
    return new SubStateRegister(*this);
}

inline bool SubStateRegister::operator > (const SubStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SubStateRegister::clear() {
}

inline  FragmentPathUpdate::FragmentPathUpdate ()  :
    _FragmentPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FragmentPathUpdate::FragmentPathUpdate (const FragmentPathUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _FragmentPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FragmentPathUpdate::FragmentPathUpdate (const ::std::string& FragmentPath_)  :
    _FragmentPath (FragmentPath_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FragmentPath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FragmentPathUpdate::~FragmentPathUpdate() {
}

inline FragmentPathUpdate& FragmentPathUpdate::operator = (const FragmentPathUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFragmentPath()) {
            setFragmentPath(rhs.getFragmentPath());
        } else {
            clearFragmentPath();
        }
    }
    return *this;
}

inline bool FragmentPathUpdate::operator == (const FragmentPathUpdate& rhs) const {
    return (((!hasFragmentPath() && !rhs.hasFragmentPath()) || getFragmentPath() == rhs.getFragmentPath()));
}

inline bool FragmentPathUpdate::operator != (const FragmentPathUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool FragmentPathUpdate::operator < (const FragmentPathUpdate& rhs) const {
    if (hasFragmentPath() || rhs.hasFragmentPath()) {
        if (getFragmentPath() < rhs.getFragmentPath()) return true;
        if (getFragmentPath() > rhs.getFragmentPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FragmentPathUpdate::clone() {
    return new FragmentPathUpdate(*this);
}

inline bool FragmentPathUpdate::operator > (const FragmentPathUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FragmentPathUpdate::clear() {
    clearFragmentPath();
}

inline void FragmentPathUpdate::clearFragmentPath() {
    if (hasFragmentPath()) {
         clear_has_FragmentPath();
        _FragmentPath.clear();
     }
}

inline bool FragmentPathUpdate::hasFragmentPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FragmentPathUpdate::getFragmentPath () const {
    return _FragmentPath;
}

inline ::std::string& FragmentPathUpdate::getFragmentPathMutable () {
    set_has_FragmentPath();
    return _FragmentPath;
}

inline void FragmentPathUpdate::setFragmentPath (const ::std::string& FragmentPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FragmentPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FragmentPath();
    this->_FragmentPath = FragmentPath_;
}

inline void FragmentPathUpdate::setFragmentPath (const char* FragmentPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FragmentPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FragmentPath();
    this->_FragmentPath.assign(FragmentPath_);
}

inline void FragmentPathUpdate::setFragmentPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FragmentPath();
    this->_FragmentPath.assign(value, size);
}

inline void FragmentPathUpdate::set_has_FragmentPath () {
    _has_bits_[0] |= 1u << 0;
}

inline void FragmentPathUpdate::clear_has_FragmentPath () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FragmentPathRegister::FragmentPathRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FragmentPathRegister::FragmentPathRegister (const FragmentPathRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FragmentPathRegister::~FragmentPathRegister() {
}

inline FragmentPathRegister& FragmentPathRegister::operator = (const FragmentPathRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool FragmentPathRegister::operator == (const FragmentPathRegister& ) const {
    return true;
}

inline bool FragmentPathRegister::operator != (const FragmentPathRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool FragmentPathRegister::operator < (const FragmentPathRegister& ) const {
    return false;
}

inline ::asf::core::Payload* FragmentPathRegister::clone() {
    return new FragmentPathRegister(*this);
}

inline bool FragmentPathRegister::operator > (const FragmentPathRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FragmentPathRegister::clear() {
}

inline  SourcePathUpdate::SourcePathUpdate ()  :
    _SourcePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourcePathUpdate::SourcePathUpdate (const SourcePathUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SourcePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourcePathUpdate::SourcePathUpdate (const ::std::string& SourcePath_)  :
    _SourcePath (SourcePath_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SourcePath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourcePathUpdate::~SourcePathUpdate() {
}

inline SourcePathUpdate& SourcePathUpdate::operator = (const SourcePathUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourcePath()) {
            setSourcePath(rhs.getSourcePath());
        } else {
            clearSourcePath();
        }
    }
    return *this;
}

inline bool SourcePathUpdate::operator == (const SourcePathUpdate& rhs) const {
    return (((!hasSourcePath() && !rhs.hasSourcePath()) || getSourcePath() == rhs.getSourcePath()));
}

inline bool SourcePathUpdate::operator != (const SourcePathUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SourcePathUpdate::operator < (const SourcePathUpdate& rhs) const {
    if (hasSourcePath() || rhs.hasSourcePath()) {
        if (getSourcePath() < rhs.getSourcePath()) return true;
        if (getSourcePath() > rhs.getSourcePath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SourcePathUpdate::clone() {
    return new SourcePathUpdate(*this);
}

inline bool SourcePathUpdate::operator > (const SourcePathUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourcePathUpdate::clear() {
    clearSourcePath();
}

inline void SourcePathUpdate::clearSourcePath() {
    if (hasSourcePath()) {
         clear_has_SourcePath();
        _SourcePath.clear();
     }
}

inline bool SourcePathUpdate::hasSourcePath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SourcePathUpdate::getSourcePath () const {
    return _SourcePath;
}

inline ::std::string& SourcePathUpdate::getSourcePathMutable () {
    set_has_SourcePath();
    return _SourcePath;
}

inline void SourcePathUpdate::setSourcePath (const ::std::string& SourcePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SourcePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SourcePath();
    this->_SourcePath = SourcePath_;
}

inline void SourcePathUpdate::setSourcePath (const char* SourcePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SourcePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SourcePath();
    this->_SourcePath.assign(SourcePath_);
}

inline void SourcePathUpdate::setSourcePath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SourcePath();
    this->_SourcePath.assign(value, size);
}

inline void SourcePathUpdate::set_has_SourcePath () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourcePathUpdate::clear_has_SourcePath () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SourcePathRegister::SourcePathRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourcePathRegister::SourcePathRegister (const SourcePathRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourcePathRegister::~SourcePathRegister() {
}

inline SourcePathRegister& SourcePathRegister::operator = (const SourcePathRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SourcePathRegister::operator == (const SourcePathRegister& ) const {
    return true;
}

inline bool SourcePathRegister::operator != (const SourcePathRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SourcePathRegister::operator < (const SourcePathRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SourcePathRegister::clone() {
    return new SourcePathRegister(*this);
}

inline bool SourcePathRegister::operator > (const SourcePathRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourcePathRegister::clear() {
}

inline  DropInPathsUpdate::DropInPathsUpdate ()  :
    _DropInPaths ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DropInPathsUpdate::DropInPathsUpdate (const DropInPathsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DropInPaths ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DropInPathsUpdate::DropInPathsUpdate (const ::std::vector< ::std::string >& DropInPaths_)  :
    _DropInPaths (DropInPaths_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DropInPathsUpdate::~DropInPathsUpdate() {
}

inline DropInPathsUpdate& DropInPathsUpdate::operator = (const DropInPathsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDropInPaths()) {
            setDropInPaths(rhs.getDropInPaths());
        } else {
            clearDropInPaths();
        }
    }
    return *this;
}

inline bool DropInPathsUpdate::operator == (const DropInPathsUpdate& rhs) const {
    return (((!hasDropInPaths() && !rhs.hasDropInPaths()) || getDropInPaths() == rhs.getDropInPaths()));
}

inline bool DropInPathsUpdate::operator != (const DropInPathsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DropInPathsUpdate::operator < (const DropInPathsUpdate& rhs) const {
    if (hasDropInPaths() || rhs.hasDropInPaths()) {
        if (getDropInPaths() < rhs.getDropInPaths()) return true;
        if (getDropInPaths() > rhs.getDropInPaths()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DropInPathsUpdate::clone() {
    return new DropInPathsUpdate(*this);
}

inline bool DropInPathsUpdate::operator > (const DropInPathsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DropInPathsUpdate::clear() {
    clearDropInPaths();
}

inline void DropInPathsUpdate::clearDropInPaths() {
    if (hasDropInPaths()) {
         clear_has_DropInPaths();
        _DropInPaths.clear();
     }
}

inline bool DropInPathsUpdate::hasDropInPaths () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& DropInPathsUpdate::getDropInPaths () const {
    return _DropInPaths;
}

inline ::std::vector< ::std::string >& DropInPathsUpdate::getDropInPathsMutable () {
    set_has_DropInPaths();
    return _DropInPaths;
}

inline void DropInPathsUpdate::setDropInPaths (const ::std::vector< ::std::string >& DropInPaths_) {
    set_has_DropInPaths();
    this->_DropInPaths = DropInPaths_;
}

inline void DropInPathsUpdate::set_has_DropInPaths () {
    _has_bits_[0] |= 1u << 0;
}

inline void DropInPathsUpdate::clear_has_DropInPaths () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DropInPathsRegister::DropInPathsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DropInPathsRegister::DropInPathsRegister (const DropInPathsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DropInPathsRegister::~DropInPathsRegister() {
}

inline DropInPathsRegister& DropInPathsRegister::operator = (const DropInPathsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DropInPathsRegister::operator == (const DropInPathsRegister& ) const {
    return true;
}

inline bool DropInPathsRegister::operator != (const DropInPathsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DropInPathsRegister::operator < (const DropInPathsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DropInPathsRegister::clone() {
    return new DropInPathsRegister(*this);
}

inline bool DropInPathsRegister::operator > (const DropInPathsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DropInPathsRegister::clear() {
}

inline  UnitFileStateUpdate::UnitFileStateUpdate ()  :
    _UnitFileState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnitFileStateUpdate::UnitFileStateUpdate (const UnitFileStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _UnitFileState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnitFileStateUpdate::UnitFileStateUpdate (const ::std::string& UnitFileState_)  :
    _UnitFileState (UnitFileState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (UnitFileState_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnitFileStateUpdate::~UnitFileStateUpdate() {
}

inline UnitFileStateUpdate& UnitFileStateUpdate::operator = (const UnitFileStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUnitFileState()) {
            setUnitFileState(rhs.getUnitFileState());
        } else {
            clearUnitFileState();
        }
    }
    return *this;
}

inline bool UnitFileStateUpdate::operator == (const UnitFileStateUpdate& rhs) const {
    return (((!hasUnitFileState() && !rhs.hasUnitFileState()) || getUnitFileState() == rhs.getUnitFileState()));
}

inline bool UnitFileStateUpdate::operator != (const UnitFileStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool UnitFileStateUpdate::operator < (const UnitFileStateUpdate& rhs) const {
    if (hasUnitFileState() || rhs.hasUnitFileState()) {
        if (getUnitFileState() < rhs.getUnitFileState()) return true;
        if (getUnitFileState() > rhs.getUnitFileState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnitFileStateUpdate::clone() {
    return new UnitFileStateUpdate(*this);
}

inline bool UnitFileStateUpdate::operator > (const UnitFileStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnitFileStateUpdate::clear() {
    clearUnitFileState();
}

inline void UnitFileStateUpdate::clearUnitFileState() {
    if (hasUnitFileState()) {
         clear_has_UnitFileState();
        _UnitFileState.clear();
     }
}

inline bool UnitFileStateUpdate::hasUnitFileState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UnitFileStateUpdate::getUnitFileState () const {
    return _UnitFileState;
}

inline ::std::string& UnitFileStateUpdate::getUnitFileStateMutable () {
    set_has_UnitFileState();
    return _UnitFileState;
}

inline void UnitFileStateUpdate::setUnitFileState (const ::std::string& UnitFileState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (UnitFileState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_UnitFileState();
    this->_UnitFileState = UnitFileState_;
}

inline void UnitFileStateUpdate::setUnitFileState (const char* UnitFileState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (UnitFileState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_UnitFileState();
    this->_UnitFileState.assign(UnitFileState_);
}

inline void UnitFileStateUpdate::setUnitFileState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_UnitFileState();
    this->_UnitFileState.assign(value, size);
}

inline void UnitFileStateUpdate::set_has_UnitFileState () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnitFileStateUpdate::clear_has_UnitFileState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UnitFileStateRegister::UnitFileStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnitFileStateRegister::UnitFileStateRegister (const UnitFileStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnitFileStateRegister::~UnitFileStateRegister() {
}

inline UnitFileStateRegister& UnitFileStateRegister::operator = (const UnitFileStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool UnitFileStateRegister::operator == (const UnitFileStateRegister& ) const {
    return true;
}

inline bool UnitFileStateRegister::operator != (const UnitFileStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool UnitFileStateRegister::operator < (const UnitFileStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* UnitFileStateRegister::clone() {
    return new UnitFileStateRegister(*this);
}

inline bool UnitFileStateRegister::operator > (const UnitFileStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnitFileStateRegister::clear() {
}

inline  UnitFilePresetUpdate::UnitFilePresetUpdate ()  :
    _UnitFilePreset ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnitFilePresetUpdate::UnitFilePresetUpdate (const UnitFilePresetUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _UnitFilePreset ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnitFilePresetUpdate::UnitFilePresetUpdate (const ::std::string& UnitFilePreset_)  :
    _UnitFilePreset (UnitFilePreset_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (UnitFilePreset_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnitFilePresetUpdate::~UnitFilePresetUpdate() {
}

inline UnitFilePresetUpdate& UnitFilePresetUpdate::operator = (const UnitFilePresetUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUnitFilePreset()) {
            setUnitFilePreset(rhs.getUnitFilePreset());
        } else {
            clearUnitFilePreset();
        }
    }
    return *this;
}

inline bool UnitFilePresetUpdate::operator == (const UnitFilePresetUpdate& rhs) const {
    return (((!hasUnitFilePreset() && !rhs.hasUnitFilePreset()) || getUnitFilePreset() == rhs.getUnitFilePreset()));
}

inline bool UnitFilePresetUpdate::operator != (const UnitFilePresetUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool UnitFilePresetUpdate::operator < (const UnitFilePresetUpdate& rhs) const {
    if (hasUnitFilePreset() || rhs.hasUnitFilePreset()) {
        if (getUnitFilePreset() < rhs.getUnitFilePreset()) return true;
        if (getUnitFilePreset() > rhs.getUnitFilePreset()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnitFilePresetUpdate::clone() {
    return new UnitFilePresetUpdate(*this);
}

inline bool UnitFilePresetUpdate::operator > (const UnitFilePresetUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnitFilePresetUpdate::clear() {
    clearUnitFilePreset();
}

inline void UnitFilePresetUpdate::clearUnitFilePreset() {
    if (hasUnitFilePreset()) {
         clear_has_UnitFilePreset();
        _UnitFilePreset.clear();
     }
}

inline bool UnitFilePresetUpdate::hasUnitFilePreset () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UnitFilePresetUpdate::getUnitFilePreset () const {
    return _UnitFilePreset;
}

inline ::std::string& UnitFilePresetUpdate::getUnitFilePresetMutable () {
    set_has_UnitFilePreset();
    return _UnitFilePreset;
}

inline void UnitFilePresetUpdate::setUnitFilePreset (const ::std::string& UnitFilePreset_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (UnitFilePreset_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_UnitFilePreset();
    this->_UnitFilePreset = UnitFilePreset_;
}

inline void UnitFilePresetUpdate::setUnitFilePreset (const char* UnitFilePreset_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (UnitFilePreset_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_UnitFilePreset();
    this->_UnitFilePreset.assign(UnitFilePreset_);
}

inline void UnitFilePresetUpdate::setUnitFilePreset (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_UnitFilePreset();
    this->_UnitFilePreset.assign(value, size);
}

inline void UnitFilePresetUpdate::set_has_UnitFilePreset () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnitFilePresetUpdate::clear_has_UnitFilePreset () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UnitFilePresetRegister::UnitFilePresetRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnitFilePresetRegister::UnitFilePresetRegister (const UnitFilePresetRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnitFilePresetRegister::~UnitFilePresetRegister() {
}

inline UnitFilePresetRegister& UnitFilePresetRegister::operator = (const UnitFilePresetRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool UnitFilePresetRegister::operator == (const UnitFilePresetRegister& ) const {
    return true;
}

inline bool UnitFilePresetRegister::operator != (const UnitFilePresetRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool UnitFilePresetRegister::operator < (const UnitFilePresetRegister& ) const {
    return false;
}

inline ::asf::core::Payload* UnitFilePresetRegister::clone() {
    return new UnitFilePresetRegister(*this);
}

inline bool UnitFilePresetRegister::operator > (const UnitFilePresetRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnitFilePresetRegister::clear() {
}

inline  InactiveExitTimestampUpdate::InactiveExitTimestampUpdate ()  :
    _InactiveExitTimestamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InactiveExitTimestampUpdate::InactiveExitTimestampUpdate (const InactiveExitTimestampUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _InactiveExitTimestamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InactiveExitTimestampUpdate::InactiveExitTimestampUpdate (uint64 InactiveExitTimestamp_)  :
    _InactiveExitTimestamp (InactiveExitTimestamp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InactiveExitTimestampUpdate::~InactiveExitTimestampUpdate() {
}

inline InactiveExitTimestampUpdate& InactiveExitTimestampUpdate::operator = (const InactiveExitTimestampUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInactiveExitTimestamp()) {
            setInactiveExitTimestamp(rhs.getInactiveExitTimestamp());
        } else {
            clearInactiveExitTimestamp();
        }
    }
    return *this;
}

inline bool InactiveExitTimestampUpdate::operator == (const InactiveExitTimestampUpdate& rhs) const {
    return (((!hasInactiveExitTimestamp() && !rhs.hasInactiveExitTimestamp()) || getInactiveExitTimestamp() == rhs.getInactiveExitTimestamp()));
}

inline bool InactiveExitTimestampUpdate::operator != (const InactiveExitTimestampUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool InactiveExitTimestampUpdate::operator < (const InactiveExitTimestampUpdate& rhs) const {
    if (hasInactiveExitTimestamp() || rhs.hasInactiveExitTimestamp()) {
        if (getInactiveExitTimestamp() < rhs.getInactiveExitTimestamp()) return true;
        if (getInactiveExitTimestamp() > rhs.getInactiveExitTimestamp()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InactiveExitTimestampUpdate::clone() {
    return new InactiveExitTimestampUpdate(*this);
}

inline bool InactiveExitTimestampUpdate::operator > (const InactiveExitTimestampUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InactiveExitTimestampUpdate::clear() {
    clearInactiveExitTimestamp();
}

inline void InactiveExitTimestampUpdate::clearInactiveExitTimestamp() {
    if (hasInactiveExitTimestamp()) {
         clear_has_InactiveExitTimestamp();
        _InactiveExitTimestamp = 0u;
     }
}

inline bool InactiveExitTimestampUpdate::hasInactiveExitTimestamp () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 InactiveExitTimestampUpdate::getInactiveExitTimestamp () const {
    return _InactiveExitTimestamp;
}

inline void InactiveExitTimestampUpdate::setInactiveExitTimestamp (uint64 InactiveExitTimestamp_) {
    set_has_InactiveExitTimestamp();
    this->_InactiveExitTimestamp = InactiveExitTimestamp_;
}

inline void InactiveExitTimestampUpdate::set_has_InactiveExitTimestamp () {
    _has_bits_[0] |= 1u << 0;
}

inline void InactiveExitTimestampUpdate::clear_has_InactiveExitTimestamp () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  InactiveExitTimestampRegister::InactiveExitTimestampRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InactiveExitTimestampRegister::InactiveExitTimestampRegister (const InactiveExitTimestampRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InactiveExitTimestampRegister::~InactiveExitTimestampRegister() {
}

inline InactiveExitTimestampRegister& InactiveExitTimestampRegister::operator = (const InactiveExitTimestampRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool InactiveExitTimestampRegister::operator == (const InactiveExitTimestampRegister& ) const {
    return true;
}

inline bool InactiveExitTimestampRegister::operator != (const InactiveExitTimestampRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool InactiveExitTimestampRegister::operator < (const InactiveExitTimestampRegister& ) const {
    return false;
}

inline ::asf::core::Payload* InactiveExitTimestampRegister::clone() {
    return new InactiveExitTimestampRegister(*this);
}

inline bool InactiveExitTimestampRegister::operator > (const InactiveExitTimestampRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InactiveExitTimestampRegister::clear() {
}

inline  InactiveExitTimestampMonotonicUpdate::InactiveExitTimestampMonotonicUpdate ()  :
    _InactiveExitTimestampMonotonic (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InactiveExitTimestampMonotonicUpdate::InactiveExitTimestampMonotonicUpdate (const InactiveExitTimestampMonotonicUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _InactiveExitTimestampMonotonic (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InactiveExitTimestampMonotonicUpdate::InactiveExitTimestampMonotonicUpdate (uint64 InactiveExitTimestampMonotonic_)  :
    _InactiveExitTimestampMonotonic (InactiveExitTimestampMonotonic_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InactiveExitTimestampMonotonicUpdate::~InactiveExitTimestampMonotonicUpdate() {
}

inline InactiveExitTimestampMonotonicUpdate& InactiveExitTimestampMonotonicUpdate::operator = (const InactiveExitTimestampMonotonicUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInactiveExitTimestampMonotonic()) {
            setInactiveExitTimestampMonotonic(rhs.getInactiveExitTimestampMonotonic());
        } else {
            clearInactiveExitTimestampMonotonic();
        }
    }
    return *this;
}

inline bool InactiveExitTimestampMonotonicUpdate::operator == (const InactiveExitTimestampMonotonicUpdate& rhs) const {
    return (((!hasInactiveExitTimestampMonotonic() && !rhs.hasInactiveExitTimestampMonotonic()) || getInactiveExitTimestampMonotonic() == rhs.getInactiveExitTimestampMonotonic()));
}

inline bool InactiveExitTimestampMonotonicUpdate::operator != (const InactiveExitTimestampMonotonicUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool InactiveExitTimestampMonotonicUpdate::operator < (const InactiveExitTimestampMonotonicUpdate& rhs) const {
    if (hasInactiveExitTimestampMonotonic() || rhs.hasInactiveExitTimestampMonotonic()) {
        if (getInactiveExitTimestampMonotonic() < rhs.getInactiveExitTimestampMonotonic()) return true;
        if (getInactiveExitTimestampMonotonic() > rhs.getInactiveExitTimestampMonotonic()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InactiveExitTimestampMonotonicUpdate::clone() {
    return new InactiveExitTimestampMonotonicUpdate(*this);
}

inline bool InactiveExitTimestampMonotonicUpdate::operator > (const InactiveExitTimestampMonotonicUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InactiveExitTimestampMonotonicUpdate::clear() {
    clearInactiveExitTimestampMonotonic();
}

inline void InactiveExitTimestampMonotonicUpdate::clearInactiveExitTimestampMonotonic() {
    if (hasInactiveExitTimestampMonotonic()) {
         clear_has_InactiveExitTimestampMonotonic();
        _InactiveExitTimestampMonotonic = 0u;
     }
}

inline bool InactiveExitTimestampMonotonicUpdate::hasInactiveExitTimestampMonotonic () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 InactiveExitTimestampMonotonicUpdate::getInactiveExitTimestampMonotonic () const {
    return _InactiveExitTimestampMonotonic;
}

inline void InactiveExitTimestampMonotonicUpdate::setInactiveExitTimestampMonotonic (uint64 InactiveExitTimestampMonotonic_) {
    set_has_InactiveExitTimestampMonotonic();
    this->_InactiveExitTimestampMonotonic = InactiveExitTimestampMonotonic_;
}

inline void InactiveExitTimestampMonotonicUpdate::set_has_InactiveExitTimestampMonotonic () {
    _has_bits_[0] |= 1u << 0;
}

inline void InactiveExitTimestampMonotonicUpdate::clear_has_InactiveExitTimestampMonotonic () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  InactiveExitTimestampMonotonicRegister::InactiveExitTimestampMonotonicRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InactiveExitTimestampMonotonicRegister::InactiveExitTimestampMonotonicRegister (const InactiveExitTimestampMonotonicRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InactiveExitTimestampMonotonicRegister::~InactiveExitTimestampMonotonicRegister() {
}

inline InactiveExitTimestampMonotonicRegister& InactiveExitTimestampMonotonicRegister::operator = (const InactiveExitTimestampMonotonicRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool InactiveExitTimestampMonotonicRegister::operator == (const InactiveExitTimestampMonotonicRegister& ) const {
    return true;
}

inline bool InactiveExitTimestampMonotonicRegister::operator != (const InactiveExitTimestampMonotonicRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool InactiveExitTimestampMonotonicRegister::operator < (const InactiveExitTimestampMonotonicRegister& ) const {
    return false;
}

inline ::asf::core::Payload* InactiveExitTimestampMonotonicRegister::clone() {
    return new InactiveExitTimestampMonotonicRegister(*this);
}

inline bool InactiveExitTimestampMonotonicRegister::operator > (const InactiveExitTimestampMonotonicRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InactiveExitTimestampMonotonicRegister::clear() {
}

inline  ActiveEnterTimestampUpdate::ActiveEnterTimestampUpdate ()  :
    _ActiveEnterTimestamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveEnterTimestampUpdate::ActiveEnterTimestampUpdate (const ActiveEnterTimestampUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ActiveEnterTimestamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveEnterTimestampUpdate::ActiveEnterTimestampUpdate (uint64 ActiveEnterTimestamp_)  :
    _ActiveEnterTimestamp (ActiveEnterTimestamp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveEnterTimestampUpdate::~ActiveEnterTimestampUpdate() {
}

inline ActiveEnterTimestampUpdate& ActiveEnterTimestampUpdate::operator = (const ActiveEnterTimestampUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveEnterTimestamp()) {
            setActiveEnterTimestamp(rhs.getActiveEnterTimestamp());
        } else {
            clearActiveEnterTimestamp();
        }
    }
    return *this;
}

inline bool ActiveEnterTimestampUpdate::operator == (const ActiveEnterTimestampUpdate& rhs) const {
    return (((!hasActiveEnterTimestamp() && !rhs.hasActiveEnterTimestamp()) || getActiveEnterTimestamp() == rhs.getActiveEnterTimestamp()));
}

inline bool ActiveEnterTimestampUpdate::operator != (const ActiveEnterTimestampUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveEnterTimestampUpdate::operator < (const ActiveEnterTimestampUpdate& rhs) const {
    if (hasActiveEnterTimestamp() || rhs.hasActiveEnterTimestamp()) {
        if (getActiveEnterTimestamp() < rhs.getActiveEnterTimestamp()) return true;
        if (getActiveEnterTimestamp() > rhs.getActiveEnterTimestamp()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveEnterTimestampUpdate::clone() {
    return new ActiveEnterTimestampUpdate(*this);
}

inline bool ActiveEnterTimestampUpdate::operator > (const ActiveEnterTimestampUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveEnterTimestampUpdate::clear() {
    clearActiveEnterTimestamp();
}

inline void ActiveEnterTimestampUpdate::clearActiveEnterTimestamp() {
    if (hasActiveEnterTimestamp()) {
         clear_has_ActiveEnterTimestamp();
        _ActiveEnterTimestamp = 0u;
     }
}

inline bool ActiveEnterTimestampUpdate::hasActiveEnterTimestamp () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 ActiveEnterTimestampUpdate::getActiveEnterTimestamp () const {
    return _ActiveEnterTimestamp;
}

inline void ActiveEnterTimestampUpdate::setActiveEnterTimestamp (uint64 ActiveEnterTimestamp_) {
    set_has_ActiveEnterTimestamp();
    this->_ActiveEnterTimestamp = ActiveEnterTimestamp_;
}

inline void ActiveEnterTimestampUpdate::set_has_ActiveEnterTimestamp () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveEnterTimestampUpdate::clear_has_ActiveEnterTimestamp () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveEnterTimestampRegister::ActiveEnterTimestampRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveEnterTimestampRegister::ActiveEnterTimestampRegister (const ActiveEnterTimestampRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveEnterTimestampRegister::~ActiveEnterTimestampRegister() {
}

inline ActiveEnterTimestampRegister& ActiveEnterTimestampRegister::operator = (const ActiveEnterTimestampRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveEnterTimestampRegister::operator == (const ActiveEnterTimestampRegister& ) const {
    return true;
}

inline bool ActiveEnterTimestampRegister::operator != (const ActiveEnterTimestampRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveEnterTimestampRegister::operator < (const ActiveEnterTimestampRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveEnterTimestampRegister::clone() {
    return new ActiveEnterTimestampRegister(*this);
}

inline bool ActiveEnterTimestampRegister::operator > (const ActiveEnterTimestampRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveEnterTimestampRegister::clear() {
}

inline  ActiveEnterTimestampMonotonicUpdate::ActiveEnterTimestampMonotonicUpdate ()  :
    _ActiveEnterTimestampMonotonic (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveEnterTimestampMonotonicUpdate::ActiveEnterTimestampMonotonicUpdate (const ActiveEnterTimestampMonotonicUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ActiveEnterTimestampMonotonic (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveEnterTimestampMonotonicUpdate::ActiveEnterTimestampMonotonicUpdate (uint64 ActiveEnterTimestampMonotonic_)  :
    _ActiveEnterTimestampMonotonic (ActiveEnterTimestampMonotonic_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveEnterTimestampMonotonicUpdate::~ActiveEnterTimestampMonotonicUpdate() {
}

inline ActiveEnterTimestampMonotonicUpdate& ActiveEnterTimestampMonotonicUpdate::operator = (const ActiveEnterTimestampMonotonicUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveEnterTimestampMonotonic()) {
            setActiveEnterTimestampMonotonic(rhs.getActiveEnterTimestampMonotonic());
        } else {
            clearActiveEnterTimestampMonotonic();
        }
    }
    return *this;
}

inline bool ActiveEnterTimestampMonotonicUpdate::operator == (const ActiveEnterTimestampMonotonicUpdate& rhs) const {
    return (((!hasActiveEnterTimestampMonotonic() && !rhs.hasActiveEnterTimestampMonotonic()) || getActiveEnterTimestampMonotonic() == rhs.getActiveEnterTimestampMonotonic()));
}

inline bool ActiveEnterTimestampMonotonicUpdate::operator != (const ActiveEnterTimestampMonotonicUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveEnterTimestampMonotonicUpdate::operator < (const ActiveEnterTimestampMonotonicUpdate& rhs) const {
    if (hasActiveEnterTimestampMonotonic() || rhs.hasActiveEnterTimestampMonotonic()) {
        if (getActiveEnterTimestampMonotonic() < rhs.getActiveEnterTimestampMonotonic()) return true;
        if (getActiveEnterTimestampMonotonic() > rhs.getActiveEnterTimestampMonotonic()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveEnterTimestampMonotonicUpdate::clone() {
    return new ActiveEnterTimestampMonotonicUpdate(*this);
}

inline bool ActiveEnterTimestampMonotonicUpdate::operator > (const ActiveEnterTimestampMonotonicUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveEnterTimestampMonotonicUpdate::clear() {
    clearActiveEnterTimestampMonotonic();
}

inline void ActiveEnterTimestampMonotonicUpdate::clearActiveEnterTimestampMonotonic() {
    if (hasActiveEnterTimestampMonotonic()) {
         clear_has_ActiveEnterTimestampMonotonic();
        _ActiveEnterTimestampMonotonic = 0u;
     }
}

inline bool ActiveEnterTimestampMonotonicUpdate::hasActiveEnterTimestampMonotonic () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 ActiveEnterTimestampMonotonicUpdate::getActiveEnterTimestampMonotonic () const {
    return _ActiveEnterTimestampMonotonic;
}

inline void ActiveEnterTimestampMonotonicUpdate::setActiveEnterTimestampMonotonic (uint64 ActiveEnterTimestampMonotonic_) {
    set_has_ActiveEnterTimestampMonotonic();
    this->_ActiveEnterTimestampMonotonic = ActiveEnterTimestampMonotonic_;
}

inline void ActiveEnterTimestampMonotonicUpdate::set_has_ActiveEnterTimestampMonotonic () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveEnterTimestampMonotonicUpdate::clear_has_ActiveEnterTimestampMonotonic () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveEnterTimestampMonotonicRegister::ActiveEnterTimestampMonotonicRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveEnterTimestampMonotonicRegister::ActiveEnterTimestampMonotonicRegister (const ActiveEnterTimestampMonotonicRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveEnterTimestampMonotonicRegister::~ActiveEnterTimestampMonotonicRegister() {
}

inline ActiveEnterTimestampMonotonicRegister& ActiveEnterTimestampMonotonicRegister::operator = (const ActiveEnterTimestampMonotonicRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveEnterTimestampMonotonicRegister::operator == (const ActiveEnterTimestampMonotonicRegister& ) const {
    return true;
}

inline bool ActiveEnterTimestampMonotonicRegister::operator != (const ActiveEnterTimestampMonotonicRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveEnterTimestampMonotonicRegister::operator < (const ActiveEnterTimestampMonotonicRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveEnterTimestampMonotonicRegister::clone() {
    return new ActiveEnterTimestampMonotonicRegister(*this);
}

inline bool ActiveEnterTimestampMonotonicRegister::operator > (const ActiveEnterTimestampMonotonicRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveEnterTimestampMonotonicRegister::clear() {
}

inline  ActiveExitTimestampUpdate::ActiveExitTimestampUpdate ()  :
    _ActiveExitTimestamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveExitTimestampUpdate::ActiveExitTimestampUpdate (const ActiveExitTimestampUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ActiveExitTimestamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveExitTimestampUpdate::ActiveExitTimestampUpdate (uint64 ActiveExitTimestamp_)  :
    _ActiveExitTimestamp (ActiveExitTimestamp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveExitTimestampUpdate::~ActiveExitTimestampUpdate() {
}

inline ActiveExitTimestampUpdate& ActiveExitTimestampUpdate::operator = (const ActiveExitTimestampUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveExitTimestamp()) {
            setActiveExitTimestamp(rhs.getActiveExitTimestamp());
        } else {
            clearActiveExitTimestamp();
        }
    }
    return *this;
}

inline bool ActiveExitTimestampUpdate::operator == (const ActiveExitTimestampUpdate& rhs) const {
    return (((!hasActiveExitTimestamp() && !rhs.hasActiveExitTimestamp()) || getActiveExitTimestamp() == rhs.getActiveExitTimestamp()));
}

inline bool ActiveExitTimestampUpdate::operator != (const ActiveExitTimestampUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveExitTimestampUpdate::operator < (const ActiveExitTimestampUpdate& rhs) const {
    if (hasActiveExitTimestamp() || rhs.hasActiveExitTimestamp()) {
        if (getActiveExitTimestamp() < rhs.getActiveExitTimestamp()) return true;
        if (getActiveExitTimestamp() > rhs.getActiveExitTimestamp()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveExitTimestampUpdate::clone() {
    return new ActiveExitTimestampUpdate(*this);
}

inline bool ActiveExitTimestampUpdate::operator > (const ActiveExitTimestampUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveExitTimestampUpdate::clear() {
    clearActiveExitTimestamp();
}

inline void ActiveExitTimestampUpdate::clearActiveExitTimestamp() {
    if (hasActiveExitTimestamp()) {
         clear_has_ActiveExitTimestamp();
        _ActiveExitTimestamp = 0u;
     }
}

inline bool ActiveExitTimestampUpdate::hasActiveExitTimestamp () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 ActiveExitTimestampUpdate::getActiveExitTimestamp () const {
    return _ActiveExitTimestamp;
}

inline void ActiveExitTimestampUpdate::setActiveExitTimestamp (uint64 ActiveExitTimestamp_) {
    set_has_ActiveExitTimestamp();
    this->_ActiveExitTimestamp = ActiveExitTimestamp_;
}

inline void ActiveExitTimestampUpdate::set_has_ActiveExitTimestamp () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveExitTimestampUpdate::clear_has_ActiveExitTimestamp () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveExitTimestampRegister::ActiveExitTimestampRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveExitTimestampRegister::ActiveExitTimestampRegister (const ActiveExitTimestampRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveExitTimestampRegister::~ActiveExitTimestampRegister() {
}

inline ActiveExitTimestampRegister& ActiveExitTimestampRegister::operator = (const ActiveExitTimestampRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveExitTimestampRegister::operator == (const ActiveExitTimestampRegister& ) const {
    return true;
}

inline bool ActiveExitTimestampRegister::operator != (const ActiveExitTimestampRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveExitTimestampRegister::operator < (const ActiveExitTimestampRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveExitTimestampRegister::clone() {
    return new ActiveExitTimestampRegister(*this);
}

inline bool ActiveExitTimestampRegister::operator > (const ActiveExitTimestampRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveExitTimestampRegister::clear() {
}

inline  ActiveExitTimestampMonotonicUpdate::ActiveExitTimestampMonotonicUpdate ()  :
    _ActiveExitTimestampMonotonic (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveExitTimestampMonotonicUpdate::ActiveExitTimestampMonotonicUpdate (const ActiveExitTimestampMonotonicUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ActiveExitTimestampMonotonic (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveExitTimestampMonotonicUpdate::ActiveExitTimestampMonotonicUpdate (uint64 ActiveExitTimestampMonotonic_)  :
    _ActiveExitTimestampMonotonic (ActiveExitTimestampMonotonic_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveExitTimestampMonotonicUpdate::~ActiveExitTimestampMonotonicUpdate() {
}

inline ActiveExitTimestampMonotonicUpdate& ActiveExitTimestampMonotonicUpdate::operator = (const ActiveExitTimestampMonotonicUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveExitTimestampMonotonic()) {
            setActiveExitTimestampMonotonic(rhs.getActiveExitTimestampMonotonic());
        } else {
            clearActiveExitTimestampMonotonic();
        }
    }
    return *this;
}

inline bool ActiveExitTimestampMonotonicUpdate::operator == (const ActiveExitTimestampMonotonicUpdate& rhs) const {
    return (((!hasActiveExitTimestampMonotonic() && !rhs.hasActiveExitTimestampMonotonic()) || getActiveExitTimestampMonotonic() == rhs.getActiveExitTimestampMonotonic()));
}

inline bool ActiveExitTimestampMonotonicUpdate::operator != (const ActiveExitTimestampMonotonicUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveExitTimestampMonotonicUpdate::operator < (const ActiveExitTimestampMonotonicUpdate& rhs) const {
    if (hasActiveExitTimestampMonotonic() || rhs.hasActiveExitTimestampMonotonic()) {
        if (getActiveExitTimestampMonotonic() < rhs.getActiveExitTimestampMonotonic()) return true;
        if (getActiveExitTimestampMonotonic() > rhs.getActiveExitTimestampMonotonic()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveExitTimestampMonotonicUpdate::clone() {
    return new ActiveExitTimestampMonotonicUpdate(*this);
}

inline bool ActiveExitTimestampMonotonicUpdate::operator > (const ActiveExitTimestampMonotonicUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveExitTimestampMonotonicUpdate::clear() {
    clearActiveExitTimestampMonotonic();
}

inline void ActiveExitTimestampMonotonicUpdate::clearActiveExitTimestampMonotonic() {
    if (hasActiveExitTimestampMonotonic()) {
         clear_has_ActiveExitTimestampMonotonic();
        _ActiveExitTimestampMonotonic = 0u;
     }
}

inline bool ActiveExitTimestampMonotonicUpdate::hasActiveExitTimestampMonotonic () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 ActiveExitTimestampMonotonicUpdate::getActiveExitTimestampMonotonic () const {
    return _ActiveExitTimestampMonotonic;
}

inline void ActiveExitTimestampMonotonicUpdate::setActiveExitTimestampMonotonic (uint64 ActiveExitTimestampMonotonic_) {
    set_has_ActiveExitTimestampMonotonic();
    this->_ActiveExitTimestampMonotonic = ActiveExitTimestampMonotonic_;
}

inline void ActiveExitTimestampMonotonicUpdate::set_has_ActiveExitTimestampMonotonic () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveExitTimestampMonotonicUpdate::clear_has_ActiveExitTimestampMonotonic () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveExitTimestampMonotonicRegister::ActiveExitTimestampMonotonicRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveExitTimestampMonotonicRegister::ActiveExitTimestampMonotonicRegister (const ActiveExitTimestampMonotonicRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveExitTimestampMonotonicRegister::~ActiveExitTimestampMonotonicRegister() {
}

inline ActiveExitTimestampMonotonicRegister& ActiveExitTimestampMonotonicRegister::operator = (const ActiveExitTimestampMonotonicRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveExitTimestampMonotonicRegister::operator == (const ActiveExitTimestampMonotonicRegister& ) const {
    return true;
}

inline bool ActiveExitTimestampMonotonicRegister::operator != (const ActiveExitTimestampMonotonicRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveExitTimestampMonotonicRegister::operator < (const ActiveExitTimestampMonotonicRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveExitTimestampMonotonicRegister::clone() {
    return new ActiveExitTimestampMonotonicRegister(*this);
}

inline bool ActiveExitTimestampMonotonicRegister::operator > (const ActiveExitTimestampMonotonicRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveExitTimestampMonotonicRegister::clear() {
}

inline  InactiveEnterTimestampUpdate::InactiveEnterTimestampUpdate ()  :
    _InactiveEnterTimestamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InactiveEnterTimestampUpdate::InactiveEnterTimestampUpdate (const InactiveEnterTimestampUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _InactiveEnterTimestamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InactiveEnterTimestampUpdate::InactiveEnterTimestampUpdate (uint64 InactiveEnterTimestamp_)  :
    _InactiveEnterTimestamp (InactiveEnterTimestamp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InactiveEnterTimestampUpdate::~InactiveEnterTimestampUpdate() {
}

inline InactiveEnterTimestampUpdate& InactiveEnterTimestampUpdate::operator = (const InactiveEnterTimestampUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInactiveEnterTimestamp()) {
            setInactiveEnterTimestamp(rhs.getInactiveEnterTimestamp());
        } else {
            clearInactiveEnterTimestamp();
        }
    }
    return *this;
}

inline bool InactiveEnterTimestampUpdate::operator == (const InactiveEnterTimestampUpdate& rhs) const {
    return (((!hasInactiveEnterTimestamp() && !rhs.hasInactiveEnterTimestamp()) || getInactiveEnterTimestamp() == rhs.getInactiveEnterTimestamp()));
}

inline bool InactiveEnterTimestampUpdate::operator != (const InactiveEnterTimestampUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool InactiveEnterTimestampUpdate::operator < (const InactiveEnterTimestampUpdate& rhs) const {
    if (hasInactiveEnterTimestamp() || rhs.hasInactiveEnterTimestamp()) {
        if (getInactiveEnterTimestamp() < rhs.getInactiveEnterTimestamp()) return true;
        if (getInactiveEnterTimestamp() > rhs.getInactiveEnterTimestamp()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InactiveEnterTimestampUpdate::clone() {
    return new InactiveEnterTimestampUpdate(*this);
}

inline bool InactiveEnterTimestampUpdate::operator > (const InactiveEnterTimestampUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InactiveEnterTimestampUpdate::clear() {
    clearInactiveEnterTimestamp();
}

inline void InactiveEnterTimestampUpdate::clearInactiveEnterTimestamp() {
    if (hasInactiveEnterTimestamp()) {
         clear_has_InactiveEnterTimestamp();
        _InactiveEnterTimestamp = 0u;
     }
}

inline bool InactiveEnterTimestampUpdate::hasInactiveEnterTimestamp () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 InactiveEnterTimestampUpdate::getInactiveEnterTimestamp () const {
    return _InactiveEnterTimestamp;
}

inline void InactiveEnterTimestampUpdate::setInactiveEnterTimestamp (uint64 InactiveEnterTimestamp_) {
    set_has_InactiveEnterTimestamp();
    this->_InactiveEnterTimestamp = InactiveEnterTimestamp_;
}

inline void InactiveEnterTimestampUpdate::set_has_InactiveEnterTimestamp () {
    _has_bits_[0] |= 1u << 0;
}

inline void InactiveEnterTimestampUpdate::clear_has_InactiveEnterTimestamp () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  InactiveEnterTimestampRegister::InactiveEnterTimestampRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InactiveEnterTimestampRegister::InactiveEnterTimestampRegister (const InactiveEnterTimestampRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InactiveEnterTimestampRegister::~InactiveEnterTimestampRegister() {
}

inline InactiveEnterTimestampRegister& InactiveEnterTimestampRegister::operator = (const InactiveEnterTimestampRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool InactiveEnterTimestampRegister::operator == (const InactiveEnterTimestampRegister& ) const {
    return true;
}

inline bool InactiveEnterTimestampRegister::operator != (const InactiveEnterTimestampRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool InactiveEnterTimestampRegister::operator < (const InactiveEnterTimestampRegister& ) const {
    return false;
}

inline ::asf::core::Payload* InactiveEnterTimestampRegister::clone() {
    return new InactiveEnterTimestampRegister(*this);
}

inline bool InactiveEnterTimestampRegister::operator > (const InactiveEnterTimestampRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InactiveEnterTimestampRegister::clear() {
}

inline  InactiveEnterTimestampMonotonicUpdate::InactiveEnterTimestampMonotonicUpdate ()  :
    _InactiveEnterTimestampMonotonic (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InactiveEnterTimestampMonotonicUpdate::InactiveEnterTimestampMonotonicUpdate (const InactiveEnterTimestampMonotonicUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _InactiveEnterTimestampMonotonic (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InactiveEnterTimestampMonotonicUpdate::InactiveEnterTimestampMonotonicUpdate (uint64 InactiveEnterTimestampMonotonic_)  :
    _InactiveEnterTimestampMonotonic (InactiveEnterTimestampMonotonic_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InactiveEnterTimestampMonotonicUpdate::~InactiveEnterTimestampMonotonicUpdate() {
}

inline InactiveEnterTimestampMonotonicUpdate& InactiveEnterTimestampMonotonicUpdate::operator = (const InactiveEnterTimestampMonotonicUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInactiveEnterTimestampMonotonic()) {
            setInactiveEnterTimestampMonotonic(rhs.getInactiveEnterTimestampMonotonic());
        } else {
            clearInactiveEnterTimestampMonotonic();
        }
    }
    return *this;
}

inline bool InactiveEnterTimestampMonotonicUpdate::operator == (const InactiveEnterTimestampMonotonicUpdate& rhs) const {
    return (((!hasInactiveEnterTimestampMonotonic() && !rhs.hasInactiveEnterTimestampMonotonic()) || getInactiveEnterTimestampMonotonic() == rhs.getInactiveEnterTimestampMonotonic()));
}

inline bool InactiveEnterTimestampMonotonicUpdate::operator != (const InactiveEnterTimestampMonotonicUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool InactiveEnterTimestampMonotonicUpdate::operator < (const InactiveEnterTimestampMonotonicUpdate& rhs) const {
    if (hasInactiveEnterTimestampMonotonic() || rhs.hasInactiveEnterTimestampMonotonic()) {
        if (getInactiveEnterTimestampMonotonic() < rhs.getInactiveEnterTimestampMonotonic()) return true;
        if (getInactiveEnterTimestampMonotonic() > rhs.getInactiveEnterTimestampMonotonic()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InactiveEnterTimestampMonotonicUpdate::clone() {
    return new InactiveEnterTimestampMonotonicUpdate(*this);
}

inline bool InactiveEnterTimestampMonotonicUpdate::operator > (const InactiveEnterTimestampMonotonicUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InactiveEnterTimestampMonotonicUpdate::clear() {
    clearInactiveEnterTimestampMonotonic();
}

inline void InactiveEnterTimestampMonotonicUpdate::clearInactiveEnterTimestampMonotonic() {
    if (hasInactiveEnterTimestampMonotonic()) {
         clear_has_InactiveEnterTimestampMonotonic();
        _InactiveEnterTimestampMonotonic = 0u;
     }
}

inline bool InactiveEnterTimestampMonotonicUpdate::hasInactiveEnterTimestampMonotonic () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 InactiveEnterTimestampMonotonicUpdate::getInactiveEnterTimestampMonotonic () const {
    return _InactiveEnterTimestampMonotonic;
}

inline void InactiveEnterTimestampMonotonicUpdate::setInactiveEnterTimestampMonotonic (uint64 InactiveEnterTimestampMonotonic_) {
    set_has_InactiveEnterTimestampMonotonic();
    this->_InactiveEnterTimestampMonotonic = InactiveEnterTimestampMonotonic_;
}

inline void InactiveEnterTimestampMonotonicUpdate::set_has_InactiveEnterTimestampMonotonic () {
    _has_bits_[0] |= 1u << 0;
}

inline void InactiveEnterTimestampMonotonicUpdate::clear_has_InactiveEnterTimestampMonotonic () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  InactiveEnterTimestampMonotonicRegister::InactiveEnterTimestampMonotonicRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InactiveEnterTimestampMonotonicRegister::InactiveEnterTimestampMonotonicRegister (const InactiveEnterTimestampMonotonicRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InactiveEnterTimestampMonotonicRegister::~InactiveEnterTimestampMonotonicRegister() {
}

inline InactiveEnterTimestampMonotonicRegister& InactiveEnterTimestampMonotonicRegister::operator = (const InactiveEnterTimestampMonotonicRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool InactiveEnterTimestampMonotonicRegister::operator == (const InactiveEnterTimestampMonotonicRegister& ) const {
    return true;
}

inline bool InactiveEnterTimestampMonotonicRegister::operator != (const InactiveEnterTimestampMonotonicRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool InactiveEnterTimestampMonotonicRegister::operator < (const InactiveEnterTimestampMonotonicRegister& ) const {
    return false;
}

inline ::asf::core::Payload* InactiveEnterTimestampMonotonicRegister::clone() {
    return new InactiveEnterTimestampMonotonicRegister(*this);
}

inline bool InactiveEnterTimestampMonotonicRegister::operator > (const InactiveEnterTimestampMonotonicRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InactiveEnterTimestampMonotonicRegister::clear() {
}

inline  CanStartUpdate::CanStartUpdate ()  :
    _CanStart (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CanStartUpdate::CanStartUpdate (const CanStartUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _CanStart (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CanStartUpdate::CanStartUpdate (bool CanStart_)  :
    _CanStart (CanStart_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CanStartUpdate::~CanStartUpdate() {
}

inline CanStartUpdate& CanStartUpdate::operator = (const CanStartUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCanStart()) {
            setCanStart(rhs.getCanStart());
        } else {
            clearCanStart();
        }
    }
    return *this;
}

inline bool CanStartUpdate::operator == (const CanStartUpdate& rhs) const {
    return (((!hasCanStart() && !rhs.hasCanStart()) || getCanStart() == rhs.getCanStart()));
}

inline bool CanStartUpdate::operator != (const CanStartUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CanStartUpdate::operator < (const CanStartUpdate& rhs) const {
    if (hasCanStart() || rhs.hasCanStart()) {
        if (getCanStart() < rhs.getCanStart()) return true;
        if (getCanStart() > rhs.getCanStart()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CanStartUpdate::clone() {
    return new CanStartUpdate(*this);
}

inline bool CanStartUpdate::operator > (const CanStartUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CanStartUpdate::clear() {
    clearCanStart();
}

inline void CanStartUpdate::clearCanStart() {
    if (hasCanStart()) {
         clear_has_CanStart();
        _CanStart = false;
     }
}

inline bool CanStartUpdate::hasCanStart () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool CanStartUpdate::getCanStart () const {
    return _CanStart;
}

inline void CanStartUpdate::setCanStart (bool CanStart_) {
    set_has_CanStart();
    this->_CanStart = CanStart_;
}

inline void CanStartUpdate::set_has_CanStart () {
    _has_bits_[0] |= 1u << 0;
}

inline void CanStartUpdate::clear_has_CanStart () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CanStartRegister::CanStartRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CanStartRegister::CanStartRegister (const CanStartRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CanStartRegister::~CanStartRegister() {
}

inline CanStartRegister& CanStartRegister::operator = (const CanStartRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CanStartRegister::operator == (const CanStartRegister& ) const {
    return true;
}

inline bool CanStartRegister::operator != (const CanStartRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CanStartRegister::operator < (const CanStartRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CanStartRegister::clone() {
    return new CanStartRegister(*this);
}

inline bool CanStartRegister::operator > (const CanStartRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CanStartRegister::clear() {
}

inline  CanStopUpdate::CanStopUpdate ()  :
    _CanStop (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CanStopUpdate::CanStopUpdate (const CanStopUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _CanStop (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CanStopUpdate::CanStopUpdate (bool CanStop_)  :
    _CanStop (CanStop_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CanStopUpdate::~CanStopUpdate() {
}

inline CanStopUpdate& CanStopUpdate::operator = (const CanStopUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCanStop()) {
            setCanStop(rhs.getCanStop());
        } else {
            clearCanStop();
        }
    }
    return *this;
}

inline bool CanStopUpdate::operator == (const CanStopUpdate& rhs) const {
    return (((!hasCanStop() && !rhs.hasCanStop()) || getCanStop() == rhs.getCanStop()));
}

inline bool CanStopUpdate::operator != (const CanStopUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CanStopUpdate::operator < (const CanStopUpdate& rhs) const {
    if (hasCanStop() || rhs.hasCanStop()) {
        if (getCanStop() < rhs.getCanStop()) return true;
        if (getCanStop() > rhs.getCanStop()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CanStopUpdate::clone() {
    return new CanStopUpdate(*this);
}

inline bool CanStopUpdate::operator > (const CanStopUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CanStopUpdate::clear() {
    clearCanStop();
}

inline void CanStopUpdate::clearCanStop() {
    if (hasCanStop()) {
         clear_has_CanStop();
        _CanStop = false;
     }
}

inline bool CanStopUpdate::hasCanStop () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool CanStopUpdate::getCanStop () const {
    return _CanStop;
}

inline void CanStopUpdate::setCanStop (bool CanStop_) {
    set_has_CanStop();
    this->_CanStop = CanStop_;
}

inline void CanStopUpdate::set_has_CanStop () {
    _has_bits_[0] |= 1u << 0;
}

inline void CanStopUpdate::clear_has_CanStop () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CanStopRegister::CanStopRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CanStopRegister::CanStopRegister (const CanStopRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CanStopRegister::~CanStopRegister() {
}

inline CanStopRegister& CanStopRegister::operator = (const CanStopRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CanStopRegister::operator == (const CanStopRegister& ) const {
    return true;
}

inline bool CanStopRegister::operator != (const CanStopRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CanStopRegister::operator < (const CanStopRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CanStopRegister::clone() {
    return new CanStopRegister(*this);
}

inline bool CanStopRegister::operator > (const CanStopRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CanStopRegister::clear() {
}

inline  CanReloadUpdate::CanReloadUpdate ()  :
    _CanReload (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CanReloadUpdate::CanReloadUpdate (const CanReloadUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _CanReload (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CanReloadUpdate::CanReloadUpdate (bool CanReload_)  :
    _CanReload (CanReload_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CanReloadUpdate::~CanReloadUpdate() {
}

inline CanReloadUpdate& CanReloadUpdate::operator = (const CanReloadUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCanReload()) {
            setCanReload(rhs.getCanReload());
        } else {
            clearCanReload();
        }
    }
    return *this;
}

inline bool CanReloadUpdate::operator == (const CanReloadUpdate& rhs) const {
    return (((!hasCanReload() && !rhs.hasCanReload()) || getCanReload() == rhs.getCanReload()));
}

inline bool CanReloadUpdate::operator != (const CanReloadUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CanReloadUpdate::operator < (const CanReloadUpdate& rhs) const {
    if (hasCanReload() || rhs.hasCanReload()) {
        if (getCanReload() < rhs.getCanReload()) return true;
        if (getCanReload() > rhs.getCanReload()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CanReloadUpdate::clone() {
    return new CanReloadUpdate(*this);
}

inline bool CanReloadUpdate::operator > (const CanReloadUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CanReloadUpdate::clear() {
    clearCanReload();
}

inline void CanReloadUpdate::clearCanReload() {
    if (hasCanReload()) {
         clear_has_CanReload();
        _CanReload = false;
     }
}

inline bool CanReloadUpdate::hasCanReload () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool CanReloadUpdate::getCanReload () const {
    return _CanReload;
}

inline void CanReloadUpdate::setCanReload (bool CanReload_) {
    set_has_CanReload();
    this->_CanReload = CanReload_;
}

inline void CanReloadUpdate::set_has_CanReload () {
    _has_bits_[0] |= 1u << 0;
}

inline void CanReloadUpdate::clear_has_CanReload () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CanReloadRegister::CanReloadRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CanReloadRegister::CanReloadRegister (const CanReloadRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CanReloadRegister::~CanReloadRegister() {
}

inline CanReloadRegister& CanReloadRegister::operator = (const CanReloadRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CanReloadRegister::operator == (const CanReloadRegister& ) const {
    return true;
}

inline bool CanReloadRegister::operator != (const CanReloadRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CanReloadRegister::operator < (const CanReloadRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CanReloadRegister::clone() {
    return new CanReloadRegister(*this);
}

inline bool CanReloadRegister::operator > (const CanReloadRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CanReloadRegister::clear() {
}

inline  CanIsolateUpdate::CanIsolateUpdate ()  :
    _CanIsolate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CanIsolateUpdate::CanIsolateUpdate (const CanIsolateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _CanIsolate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CanIsolateUpdate::CanIsolateUpdate (bool CanIsolate_)  :
    _CanIsolate (CanIsolate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CanIsolateUpdate::~CanIsolateUpdate() {
}

inline CanIsolateUpdate& CanIsolateUpdate::operator = (const CanIsolateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCanIsolate()) {
            setCanIsolate(rhs.getCanIsolate());
        } else {
            clearCanIsolate();
        }
    }
    return *this;
}

inline bool CanIsolateUpdate::operator == (const CanIsolateUpdate& rhs) const {
    return (((!hasCanIsolate() && !rhs.hasCanIsolate()) || getCanIsolate() == rhs.getCanIsolate()));
}

inline bool CanIsolateUpdate::operator != (const CanIsolateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CanIsolateUpdate::operator < (const CanIsolateUpdate& rhs) const {
    if (hasCanIsolate() || rhs.hasCanIsolate()) {
        if (getCanIsolate() < rhs.getCanIsolate()) return true;
        if (getCanIsolate() > rhs.getCanIsolate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CanIsolateUpdate::clone() {
    return new CanIsolateUpdate(*this);
}

inline bool CanIsolateUpdate::operator > (const CanIsolateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CanIsolateUpdate::clear() {
    clearCanIsolate();
}

inline void CanIsolateUpdate::clearCanIsolate() {
    if (hasCanIsolate()) {
         clear_has_CanIsolate();
        _CanIsolate = false;
     }
}

inline bool CanIsolateUpdate::hasCanIsolate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool CanIsolateUpdate::getCanIsolate () const {
    return _CanIsolate;
}

inline void CanIsolateUpdate::setCanIsolate (bool CanIsolate_) {
    set_has_CanIsolate();
    this->_CanIsolate = CanIsolate_;
}

inline void CanIsolateUpdate::set_has_CanIsolate () {
    _has_bits_[0] |= 1u << 0;
}

inline void CanIsolateUpdate::clear_has_CanIsolate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CanIsolateRegister::CanIsolateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CanIsolateRegister::CanIsolateRegister (const CanIsolateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CanIsolateRegister::~CanIsolateRegister() {
}

inline CanIsolateRegister& CanIsolateRegister::operator = (const CanIsolateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CanIsolateRegister::operator == (const CanIsolateRegister& ) const {
    return true;
}

inline bool CanIsolateRegister::operator != (const CanIsolateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CanIsolateRegister::operator < (const CanIsolateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CanIsolateRegister::clone() {
    return new CanIsolateRegister(*this);
}

inline bool CanIsolateRegister::operator > (const CanIsolateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CanIsolateRegister::clear() {
}

inline  JobUpdate::JobUpdate ()  :
    _Job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  JobUpdate::JobUpdate (const JobUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  JobUpdate::JobUpdate (const job& Job_)  :
    _Job (Job_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  JobUpdate::~JobUpdate() {
}

inline JobUpdate& JobUpdate::operator = (const JobUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool JobUpdate::operator == (const JobUpdate& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool JobUpdate::operator != (const JobUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool JobUpdate::operator < (const JobUpdate& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* JobUpdate::clone() {
    return new JobUpdate(*this);
}

inline bool JobUpdate::operator > (const JobUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void JobUpdate::clear() {
    clearJob();
}

inline void JobUpdate::clearJob() {
    if (hasJob()) {
         clear_has_Job();
        _Job.clear();
     }
}

inline bool JobUpdate::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const job& JobUpdate::getJob () const {
    return _Job;
}

inline job& JobUpdate::getJobMutable () {
    set_has_Job();
    return _Job;
}

inline void JobUpdate::setJob (const job& Job_) {
    set_has_Job();
    this->_Job = Job_;
}

inline void JobUpdate::set_has_Job () {
    _has_bits_[0] |= 1u << 0;
}

inline void JobUpdate::clear_has_Job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  JobRegister::JobRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  JobRegister::JobRegister (const JobRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  JobRegister::~JobRegister() {
}

inline JobRegister& JobRegister::operator = (const JobRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool JobRegister::operator == (const JobRegister& ) const {
    return true;
}

inline bool JobRegister::operator != (const JobRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool JobRegister::operator < (const JobRegister& ) const {
    return false;
}

inline ::asf::core::Payload* JobRegister::clone() {
    return new JobRegister(*this);
}

inline bool JobRegister::operator > (const JobRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void JobRegister::clear() {
}

inline  StopWhenUnneededUpdate::StopWhenUnneededUpdate ()  :
    _StopWhenUnneeded (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopWhenUnneededUpdate::StopWhenUnneededUpdate (const StopWhenUnneededUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _StopWhenUnneeded (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopWhenUnneededUpdate::StopWhenUnneededUpdate (bool StopWhenUnneeded_)  :
    _StopWhenUnneeded (StopWhenUnneeded_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StopWhenUnneededUpdate::~StopWhenUnneededUpdate() {
}

inline StopWhenUnneededUpdate& StopWhenUnneededUpdate::operator = (const StopWhenUnneededUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStopWhenUnneeded()) {
            setStopWhenUnneeded(rhs.getStopWhenUnneeded());
        } else {
            clearStopWhenUnneeded();
        }
    }
    return *this;
}

inline bool StopWhenUnneededUpdate::operator == (const StopWhenUnneededUpdate& rhs) const {
    return (((!hasStopWhenUnneeded() && !rhs.hasStopWhenUnneeded()) || getStopWhenUnneeded() == rhs.getStopWhenUnneeded()));
}

inline bool StopWhenUnneededUpdate::operator != (const StopWhenUnneededUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool StopWhenUnneededUpdate::operator < (const StopWhenUnneededUpdate& rhs) const {
    if (hasStopWhenUnneeded() || rhs.hasStopWhenUnneeded()) {
        if (getStopWhenUnneeded() < rhs.getStopWhenUnneeded()) return true;
        if (getStopWhenUnneeded() > rhs.getStopWhenUnneeded()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StopWhenUnneededUpdate::clone() {
    return new StopWhenUnneededUpdate(*this);
}

inline bool StopWhenUnneededUpdate::operator > (const StopWhenUnneededUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopWhenUnneededUpdate::clear() {
    clearStopWhenUnneeded();
}

inline void StopWhenUnneededUpdate::clearStopWhenUnneeded() {
    if (hasStopWhenUnneeded()) {
         clear_has_StopWhenUnneeded();
        _StopWhenUnneeded = false;
     }
}

inline bool StopWhenUnneededUpdate::hasStopWhenUnneeded () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool StopWhenUnneededUpdate::getStopWhenUnneeded () const {
    return _StopWhenUnneeded;
}

inline void StopWhenUnneededUpdate::setStopWhenUnneeded (bool StopWhenUnneeded_) {
    set_has_StopWhenUnneeded();
    this->_StopWhenUnneeded = StopWhenUnneeded_;
}

inline void StopWhenUnneededUpdate::set_has_StopWhenUnneeded () {
    _has_bits_[0] |= 1u << 0;
}

inline void StopWhenUnneededUpdate::clear_has_StopWhenUnneeded () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StopWhenUnneededRegister::StopWhenUnneededRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopWhenUnneededRegister::StopWhenUnneededRegister (const StopWhenUnneededRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopWhenUnneededRegister::~StopWhenUnneededRegister() {
}

inline StopWhenUnneededRegister& StopWhenUnneededRegister::operator = (const StopWhenUnneededRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool StopWhenUnneededRegister::operator == (const StopWhenUnneededRegister& ) const {
    return true;
}

inline bool StopWhenUnneededRegister::operator != (const StopWhenUnneededRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool StopWhenUnneededRegister::operator < (const StopWhenUnneededRegister& ) const {
    return false;
}

inline ::asf::core::Payload* StopWhenUnneededRegister::clone() {
    return new StopWhenUnneededRegister(*this);
}

inline bool StopWhenUnneededRegister::operator > (const StopWhenUnneededRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopWhenUnneededRegister::clear() {
}

inline  RefuseManualStartUpdate::RefuseManualStartUpdate ()  :
    _RefuseManualStart (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RefuseManualStartUpdate::RefuseManualStartUpdate (const RefuseManualStartUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RefuseManualStart (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RefuseManualStartUpdate::RefuseManualStartUpdate (bool RefuseManualStart_)  :
    _RefuseManualStart (RefuseManualStart_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RefuseManualStartUpdate::~RefuseManualStartUpdate() {
}

inline RefuseManualStartUpdate& RefuseManualStartUpdate::operator = (const RefuseManualStartUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRefuseManualStart()) {
            setRefuseManualStart(rhs.getRefuseManualStart());
        } else {
            clearRefuseManualStart();
        }
    }
    return *this;
}

inline bool RefuseManualStartUpdate::operator == (const RefuseManualStartUpdate& rhs) const {
    return (((!hasRefuseManualStart() && !rhs.hasRefuseManualStart()) || getRefuseManualStart() == rhs.getRefuseManualStart()));
}

inline bool RefuseManualStartUpdate::operator != (const RefuseManualStartUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RefuseManualStartUpdate::operator < (const RefuseManualStartUpdate& rhs) const {
    if (hasRefuseManualStart() || rhs.hasRefuseManualStart()) {
        if (getRefuseManualStart() < rhs.getRefuseManualStart()) return true;
        if (getRefuseManualStart() > rhs.getRefuseManualStart()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RefuseManualStartUpdate::clone() {
    return new RefuseManualStartUpdate(*this);
}

inline bool RefuseManualStartUpdate::operator > (const RefuseManualStartUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RefuseManualStartUpdate::clear() {
    clearRefuseManualStart();
}

inline void RefuseManualStartUpdate::clearRefuseManualStart() {
    if (hasRefuseManualStart()) {
         clear_has_RefuseManualStart();
        _RefuseManualStart = false;
     }
}

inline bool RefuseManualStartUpdate::hasRefuseManualStart () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RefuseManualStartUpdate::getRefuseManualStart () const {
    return _RefuseManualStart;
}

inline void RefuseManualStartUpdate::setRefuseManualStart (bool RefuseManualStart_) {
    set_has_RefuseManualStart();
    this->_RefuseManualStart = RefuseManualStart_;
}

inline void RefuseManualStartUpdate::set_has_RefuseManualStart () {
    _has_bits_[0] |= 1u << 0;
}

inline void RefuseManualStartUpdate::clear_has_RefuseManualStart () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RefuseManualStartRegister::RefuseManualStartRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RefuseManualStartRegister::RefuseManualStartRegister (const RefuseManualStartRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RefuseManualStartRegister::~RefuseManualStartRegister() {
}

inline RefuseManualStartRegister& RefuseManualStartRegister::operator = (const RefuseManualStartRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RefuseManualStartRegister::operator == (const RefuseManualStartRegister& ) const {
    return true;
}

inline bool RefuseManualStartRegister::operator != (const RefuseManualStartRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RefuseManualStartRegister::operator < (const RefuseManualStartRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RefuseManualStartRegister::clone() {
    return new RefuseManualStartRegister(*this);
}

inline bool RefuseManualStartRegister::operator > (const RefuseManualStartRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RefuseManualStartRegister::clear() {
}

inline  RefuseManualStopUpdate::RefuseManualStopUpdate ()  :
    _RefuseManualStop (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RefuseManualStopUpdate::RefuseManualStopUpdate (const RefuseManualStopUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RefuseManualStop (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RefuseManualStopUpdate::RefuseManualStopUpdate (bool RefuseManualStop_)  :
    _RefuseManualStop (RefuseManualStop_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RefuseManualStopUpdate::~RefuseManualStopUpdate() {
}

inline RefuseManualStopUpdate& RefuseManualStopUpdate::operator = (const RefuseManualStopUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRefuseManualStop()) {
            setRefuseManualStop(rhs.getRefuseManualStop());
        } else {
            clearRefuseManualStop();
        }
    }
    return *this;
}

inline bool RefuseManualStopUpdate::operator == (const RefuseManualStopUpdate& rhs) const {
    return (((!hasRefuseManualStop() && !rhs.hasRefuseManualStop()) || getRefuseManualStop() == rhs.getRefuseManualStop()));
}

inline bool RefuseManualStopUpdate::operator != (const RefuseManualStopUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RefuseManualStopUpdate::operator < (const RefuseManualStopUpdate& rhs) const {
    if (hasRefuseManualStop() || rhs.hasRefuseManualStop()) {
        if (getRefuseManualStop() < rhs.getRefuseManualStop()) return true;
        if (getRefuseManualStop() > rhs.getRefuseManualStop()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RefuseManualStopUpdate::clone() {
    return new RefuseManualStopUpdate(*this);
}

inline bool RefuseManualStopUpdate::operator > (const RefuseManualStopUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RefuseManualStopUpdate::clear() {
    clearRefuseManualStop();
}

inline void RefuseManualStopUpdate::clearRefuseManualStop() {
    if (hasRefuseManualStop()) {
         clear_has_RefuseManualStop();
        _RefuseManualStop = false;
     }
}

inline bool RefuseManualStopUpdate::hasRefuseManualStop () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RefuseManualStopUpdate::getRefuseManualStop () const {
    return _RefuseManualStop;
}

inline void RefuseManualStopUpdate::setRefuseManualStop (bool RefuseManualStop_) {
    set_has_RefuseManualStop();
    this->_RefuseManualStop = RefuseManualStop_;
}

inline void RefuseManualStopUpdate::set_has_RefuseManualStop () {
    _has_bits_[0] |= 1u << 0;
}

inline void RefuseManualStopUpdate::clear_has_RefuseManualStop () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RefuseManualStopRegister::RefuseManualStopRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RefuseManualStopRegister::RefuseManualStopRegister (const RefuseManualStopRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RefuseManualStopRegister::~RefuseManualStopRegister() {
}

inline RefuseManualStopRegister& RefuseManualStopRegister::operator = (const RefuseManualStopRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RefuseManualStopRegister::operator == (const RefuseManualStopRegister& ) const {
    return true;
}

inline bool RefuseManualStopRegister::operator != (const RefuseManualStopRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RefuseManualStopRegister::operator < (const RefuseManualStopRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RefuseManualStopRegister::clone() {
    return new RefuseManualStopRegister(*this);
}

inline bool RefuseManualStopRegister::operator > (const RefuseManualStopRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RefuseManualStopRegister::clear() {
}

inline  AllowIsolateUpdate::AllowIsolateUpdate ()  :
    _AllowIsolate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AllowIsolateUpdate::AllowIsolateUpdate (const AllowIsolateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _AllowIsolate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AllowIsolateUpdate::AllowIsolateUpdate (bool AllowIsolate_)  :
    _AllowIsolate (AllowIsolate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AllowIsolateUpdate::~AllowIsolateUpdate() {
}

inline AllowIsolateUpdate& AllowIsolateUpdate::operator = (const AllowIsolateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAllowIsolate()) {
            setAllowIsolate(rhs.getAllowIsolate());
        } else {
            clearAllowIsolate();
        }
    }
    return *this;
}

inline bool AllowIsolateUpdate::operator == (const AllowIsolateUpdate& rhs) const {
    return (((!hasAllowIsolate() && !rhs.hasAllowIsolate()) || getAllowIsolate() == rhs.getAllowIsolate()));
}

inline bool AllowIsolateUpdate::operator != (const AllowIsolateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AllowIsolateUpdate::operator < (const AllowIsolateUpdate& rhs) const {
    if (hasAllowIsolate() || rhs.hasAllowIsolate()) {
        if (getAllowIsolate() < rhs.getAllowIsolate()) return true;
        if (getAllowIsolate() > rhs.getAllowIsolate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AllowIsolateUpdate::clone() {
    return new AllowIsolateUpdate(*this);
}

inline bool AllowIsolateUpdate::operator > (const AllowIsolateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AllowIsolateUpdate::clear() {
    clearAllowIsolate();
}

inline void AllowIsolateUpdate::clearAllowIsolate() {
    if (hasAllowIsolate()) {
         clear_has_AllowIsolate();
        _AllowIsolate = false;
     }
}

inline bool AllowIsolateUpdate::hasAllowIsolate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AllowIsolateUpdate::getAllowIsolate () const {
    return _AllowIsolate;
}

inline void AllowIsolateUpdate::setAllowIsolate (bool AllowIsolate_) {
    set_has_AllowIsolate();
    this->_AllowIsolate = AllowIsolate_;
}

inline void AllowIsolateUpdate::set_has_AllowIsolate () {
    _has_bits_[0] |= 1u << 0;
}

inline void AllowIsolateUpdate::clear_has_AllowIsolate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AllowIsolateRegister::AllowIsolateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AllowIsolateRegister::AllowIsolateRegister (const AllowIsolateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AllowIsolateRegister::~AllowIsolateRegister() {
}

inline AllowIsolateRegister& AllowIsolateRegister::operator = (const AllowIsolateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AllowIsolateRegister::operator == (const AllowIsolateRegister& ) const {
    return true;
}

inline bool AllowIsolateRegister::operator != (const AllowIsolateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AllowIsolateRegister::operator < (const AllowIsolateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AllowIsolateRegister::clone() {
    return new AllowIsolateRegister(*this);
}

inline bool AllowIsolateRegister::operator > (const AllowIsolateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AllowIsolateRegister::clear() {
}

inline  DefaultDependenciesUpdate::DefaultDependenciesUpdate ()  :
    _DefaultDependencies (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DefaultDependenciesUpdate::DefaultDependenciesUpdate (const DefaultDependenciesUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DefaultDependencies (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DefaultDependenciesUpdate::DefaultDependenciesUpdate (bool DefaultDependencies_)  :
    _DefaultDependencies (DefaultDependencies_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DefaultDependenciesUpdate::~DefaultDependenciesUpdate() {
}

inline DefaultDependenciesUpdate& DefaultDependenciesUpdate::operator = (const DefaultDependenciesUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefaultDependencies()) {
            setDefaultDependencies(rhs.getDefaultDependencies());
        } else {
            clearDefaultDependencies();
        }
    }
    return *this;
}

inline bool DefaultDependenciesUpdate::operator == (const DefaultDependenciesUpdate& rhs) const {
    return (((!hasDefaultDependencies() && !rhs.hasDefaultDependencies()) || getDefaultDependencies() == rhs.getDefaultDependencies()));
}

inline bool DefaultDependenciesUpdate::operator != (const DefaultDependenciesUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DefaultDependenciesUpdate::operator < (const DefaultDependenciesUpdate& rhs) const {
    if (hasDefaultDependencies() || rhs.hasDefaultDependencies()) {
        if (getDefaultDependencies() < rhs.getDefaultDependencies()) return true;
        if (getDefaultDependencies() > rhs.getDefaultDependencies()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DefaultDependenciesUpdate::clone() {
    return new DefaultDependenciesUpdate(*this);
}

inline bool DefaultDependenciesUpdate::operator > (const DefaultDependenciesUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DefaultDependenciesUpdate::clear() {
    clearDefaultDependencies();
}

inline void DefaultDependenciesUpdate::clearDefaultDependencies() {
    if (hasDefaultDependencies()) {
         clear_has_DefaultDependencies();
        _DefaultDependencies = false;
     }
}

inline bool DefaultDependenciesUpdate::hasDefaultDependencies () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DefaultDependenciesUpdate::getDefaultDependencies () const {
    return _DefaultDependencies;
}

inline void DefaultDependenciesUpdate::setDefaultDependencies (bool DefaultDependencies_) {
    set_has_DefaultDependencies();
    this->_DefaultDependencies = DefaultDependencies_;
}

inline void DefaultDependenciesUpdate::set_has_DefaultDependencies () {
    _has_bits_[0] |= 1u << 0;
}

inline void DefaultDependenciesUpdate::clear_has_DefaultDependencies () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DefaultDependenciesRegister::DefaultDependenciesRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DefaultDependenciesRegister::DefaultDependenciesRegister (const DefaultDependenciesRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DefaultDependenciesRegister::~DefaultDependenciesRegister() {
}

inline DefaultDependenciesRegister& DefaultDependenciesRegister::operator = (const DefaultDependenciesRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DefaultDependenciesRegister::operator == (const DefaultDependenciesRegister& ) const {
    return true;
}

inline bool DefaultDependenciesRegister::operator != (const DefaultDependenciesRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DefaultDependenciesRegister::operator < (const DefaultDependenciesRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DefaultDependenciesRegister::clone() {
    return new DefaultDependenciesRegister(*this);
}

inline bool DefaultDependenciesRegister::operator > (const DefaultDependenciesRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DefaultDependenciesRegister::clear() {
}

inline  OnFailureJobModeUpdate::OnFailureJobModeUpdate ()  :
    _OnFailureJobMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnFailureJobModeUpdate::OnFailureJobModeUpdate (const OnFailureJobModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _OnFailureJobMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnFailureJobModeUpdate::OnFailureJobModeUpdate (const ::std::string& OnFailureJobMode_)  :
    _OnFailureJobMode (OnFailureJobMode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OnFailureJobMode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnFailureJobModeUpdate::~OnFailureJobModeUpdate() {
}

inline OnFailureJobModeUpdate& OnFailureJobModeUpdate::operator = (const OnFailureJobModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOnFailureJobMode()) {
            setOnFailureJobMode(rhs.getOnFailureJobMode());
        } else {
            clearOnFailureJobMode();
        }
    }
    return *this;
}

inline bool OnFailureJobModeUpdate::operator == (const OnFailureJobModeUpdate& rhs) const {
    return (((!hasOnFailureJobMode() && !rhs.hasOnFailureJobMode()) || getOnFailureJobMode() == rhs.getOnFailureJobMode()));
}

inline bool OnFailureJobModeUpdate::operator != (const OnFailureJobModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool OnFailureJobModeUpdate::operator < (const OnFailureJobModeUpdate& rhs) const {
    if (hasOnFailureJobMode() || rhs.hasOnFailureJobMode()) {
        if (getOnFailureJobMode() < rhs.getOnFailureJobMode()) return true;
        if (getOnFailureJobMode() > rhs.getOnFailureJobMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnFailureJobModeUpdate::clone() {
    return new OnFailureJobModeUpdate(*this);
}

inline bool OnFailureJobModeUpdate::operator > (const OnFailureJobModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnFailureJobModeUpdate::clear() {
    clearOnFailureJobMode();
}

inline void OnFailureJobModeUpdate::clearOnFailureJobMode() {
    if (hasOnFailureJobMode()) {
         clear_has_OnFailureJobMode();
        _OnFailureJobMode.clear();
     }
}

inline bool OnFailureJobModeUpdate::hasOnFailureJobMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& OnFailureJobModeUpdate::getOnFailureJobMode () const {
    return _OnFailureJobMode;
}

inline ::std::string& OnFailureJobModeUpdate::getOnFailureJobModeMutable () {
    set_has_OnFailureJobMode();
    return _OnFailureJobMode;
}

inline void OnFailureJobModeUpdate::setOnFailureJobMode (const ::std::string& OnFailureJobMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OnFailureJobMode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OnFailureJobMode();
    this->_OnFailureJobMode = OnFailureJobMode_;
}

inline void OnFailureJobModeUpdate::setOnFailureJobMode (const char* OnFailureJobMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OnFailureJobMode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OnFailureJobMode();
    this->_OnFailureJobMode.assign(OnFailureJobMode_);
}

inline void OnFailureJobModeUpdate::setOnFailureJobMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OnFailureJobMode();
    this->_OnFailureJobMode.assign(value, size);
}

inline void OnFailureJobModeUpdate::set_has_OnFailureJobMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnFailureJobModeUpdate::clear_has_OnFailureJobMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  OnFailureJobModeRegister::OnFailureJobModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnFailureJobModeRegister::OnFailureJobModeRegister (const OnFailureJobModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnFailureJobModeRegister::~OnFailureJobModeRegister() {
}

inline OnFailureJobModeRegister& OnFailureJobModeRegister::operator = (const OnFailureJobModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool OnFailureJobModeRegister::operator == (const OnFailureJobModeRegister& ) const {
    return true;
}

inline bool OnFailureJobModeRegister::operator != (const OnFailureJobModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool OnFailureJobModeRegister::operator < (const OnFailureJobModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* OnFailureJobModeRegister::clone() {
    return new OnFailureJobModeRegister(*this);
}

inline bool OnFailureJobModeRegister::operator > (const OnFailureJobModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnFailureJobModeRegister::clear() {
}

inline  IgnoreOnIsolateUpdate::IgnoreOnIsolateUpdate ()  :
    _IgnoreOnIsolate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IgnoreOnIsolateUpdate::IgnoreOnIsolateUpdate (const IgnoreOnIsolateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _IgnoreOnIsolate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IgnoreOnIsolateUpdate::IgnoreOnIsolateUpdate (bool IgnoreOnIsolate_)  :
    _IgnoreOnIsolate (IgnoreOnIsolate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  IgnoreOnIsolateUpdate::~IgnoreOnIsolateUpdate() {
}

inline IgnoreOnIsolateUpdate& IgnoreOnIsolateUpdate::operator = (const IgnoreOnIsolateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIgnoreOnIsolate()) {
            setIgnoreOnIsolate(rhs.getIgnoreOnIsolate());
        } else {
            clearIgnoreOnIsolate();
        }
    }
    return *this;
}

inline bool IgnoreOnIsolateUpdate::operator == (const IgnoreOnIsolateUpdate& rhs) const {
    return (((!hasIgnoreOnIsolate() && !rhs.hasIgnoreOnIsolate()) || getIgnoreOnIsolate() == rhs.getIgnoreOnIsolate()));
}

inline bool IgnoreOnIsolateUpdate::operator != (const IgnoreOnIsolateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool IgnoreOnIsolateUpdate::operator < (const IgnoreOnIsolateUpdate& rhs) const {
    if (hasIgnoreOnIsolate() || rhs.hasIgnoreOnIsolate()) {
        if (getIgnoreOnIsolate() < rhs.getIgnoreOnIsolate()) return true;
        if (getIgnoreOnIsolate() > rhs.getIgnoreOnIsolate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* IgnoreOnIsolateUpdate::clone() {
    return new IgnoreOnIsolateUpdate(*this);
}

inline bool IgnoreOnIsolateUpdate::operator > (const IgnoreOnIsolateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IgnoreOnIsolateUpdate::clear() {
    clearIgnoreOnIsolate();
}

inline void IgnoreOnIsolateUpdate::clearIgnoreOnIsolate() {
    if (hasIgnoreOnIsolate()) {
         clear_has_IgnoreOnIsolate();
        _IgnoreOnIsolate = false;
     }
}

inline bool IgnoreOnIsolateUpdate::hasIgnoreOnIsolate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool IgnoreOnIsolateUpdate::getIgnoreOnIsolate () const {
    return _IgnoreOnIsolate;
}

inline void IgnoreOnIsolateUpdate::setIgnoreOnIsolate (bool IgnoreOnIsolate_) {
    set_has_IgnoreOnIsolate();
    this->_IgnoreOnIsolate = IgnoreOnIsolate_;
}

inline void IgnoreOnIsolateUpdate::set_has_IgnoreOnIsolate () {
    _has_bits_[0] |= 1u << 0;
}

inline void IgnoreOnIsolateUpdate::clear_has_IgnoreOnIsolate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  IgnoreOnIsolateRegister::IgnoreOnIsolateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IgnoreOnIsolateRegister::IgnoreOnIsolateRegister (const IgnoreOnIsolateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IgnoreOnIsolateRegister::~IgnoreOnIsolateRegister() {
}

inline IgnoreOnIsolateRegister& IgnoreOnIsolateRegister::operator = (const IgnoreOnIsolateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool IgnoreOnIsolateRegister::operator == (const IgnoreOnIsolateRegister& ) const {
    return true;
}

inline bool IgnoreOnIsolateRegister::operator != (const IgnoreOnIsolateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool IgnoreOnIsolateRegister::operator < (const IgnoreOnIsolateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* IgnoreOnIsolateRegister::clone() {
    return new IgnoreOnIsolateRegister(*this);
}

inline bool IgnoreOnIsolateRegister::operator > (const IgnoreOnIsolateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IgnoreOnIsolateRegister::clear() {
}

inline  IgnoreOnSnapshotUpdate::IgnoreOnSnapshotUpdate ()  :
    _IgnoreOnSnapshot (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IgnoreOnSnapshotUpdate::IgnoreOnSnapshotUpdate (const IgnoreOnSnapshotUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _IgnoreOnSnapshot (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IgnoreOnSnapshotUpdate::IgnoreOnSnapshotUpdate (bool IgnoreOnSnapshot_)  :
    _IgnoreOnSnapshot (IgnoreOnSnapshot_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  IgnoreOnSnapshotUpdate::~IgnoreOnSnapshotUpdate() {
}

inline IgnoreOnSnapshotUpdate& IgnoreOnSnapshotUpdate::operator = (const IgnoreOnSnapshotUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIgnoreOnSnapshot()) {
            setIgnoreOnSnapshot(rhs.getIgnoreOnSnapshot());
        } else {
            clearIgnoreOnSnapshot();
        }
    }
    return *this;
}

inline bool IgnoreOnSnapshotUpdate::operator == (const IgnoreOnSnapshotUpdate& rhs) const {
    return (((!hasIgnoreOnSnapshot() && !rhs.hasIgnoreOnSnapshot()) || getIgnoreOnSnapshot() == rhs.getIgnoreOnSnapshot()));
}

inline bool IgnoreOnSnapshotUpdate::operator != (const IgnoreOnSnapshotUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool IgnoreOnSnapshotUpdate::operator < (const IgnoreOnSnapshotUpdate& rhs) const {
    if (hasIgnoreOnSnapshot() || rhs.hasIgnoreOnSnapshot()) {
        if (getIgnoreOnSnapshot() < rhs.getIgnoreOnSnapshot()) return true;
        if (getIgnoreOnSnapshot() > rhs.getIgnoreOnSnapshot()) return false;
    }
    return false;
}

inline ::asf::core::Payload* IgnoreOnSnapshotUpdate::clone() {
    return new IgnoreOnSnapshotUpdate(*this);
}

inline bool IgnoreOnSnapshotUpdate::operator > (const IgnoreOnSnapshotUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IgnoreOnSnapshotUpdate::clear() {
    clearIgnoreOnSnapshot();
}

inline void IgnoreOnSnapshotUpdate::clearIgnoreOnSnapshot() {
    if (hasIgnoreOnSnapshot()) {
         clear_has_IgnoreOnSnapshot();
        _IgnoreOnSnapshot = false;
     }
}

inline bool IgnoreOnSnapshotUpdate::hasIgnoreOnSnapshot () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool IgnoreOnSnapshotUpdate::getIgnoreOnSnapshot () const {
    return _IgnoreOnSnapshot;
}

inline void IgnoreOnSnapshotUpdate::setIgnoreOnSnapshot (bool IgnoreOnSnapshot_) {
    set_has_IgnoreOnSnapshot();
    this->_IgnoreOnSnapshot = IgnoreOnSnapshot_;
}

inline void IgnoreOnSnapshotUpdate::set_has_IgnoreOnSnapshot () {
    _has_bits_[0] |= 1u << 0;
}

inline void IgnoreOnSnapshotUpdate::clear_has_IgnoreOnSnapshot () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  IgnoreOnSnapshotRegister::IgnoreOnSnapshotRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IgnoreOnSnapshotRegister::IgnoreOnSnapshotRegister (const IgnoreOnSnapshotRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IgnoreOnSnapshotRegister::~IgnoreOnSnapshotRegister() {
}

inline IgnoreOnSnapshotRegister& IgnoreOnSnapshotRegister::operator = (const IgnoreOnSnapshotRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool IgnoreOnSnapshotRegister::operator == (const IgnoreOnSnapshotRegister& ) const {
    return true;
}

inline bool IgnoreOnSnapshotRegister::operator != (const IgnoreOnSnapshotRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool IgnoreOnSnapshotRegister::operator < (const IgnoreOnSnapshotRegister& ) const {
    return false;
}

inline ::asf::core::Payload* IgnoreOnSnapshotRegister::clone() {
    return new IgnoreOnSnapshotRegister(*this);
}

inline bool IgnoreOnSnapshotRegister::operator > (const IgnoreOnSnapshotRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IgnoreOnSnapshotRegister::clear() {
}

inline  NeedDaemonReloadUpdate::NeedDaemonReloadUpdate ()  :
    _NeedDaemonReload (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NeedDaemonReloadUpdate::NeedDaemonReloadUpdate (const NeedDaemonReloadUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _NeedDaemonReload (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NeedDaemonReloadUpdate::NeedDaemonReloadUpdate (bool NeedDaemonReload_)  :
    _NeedDaemonReload (NeedDaemonReload_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NeedDaemonReloadUpdate::~NeedDaemonReloadUpdate() {
}

inline NeedDaemonReloadUpdate& NeedDaemonReloadUpdate::operator = (const NeedDaemonReloadUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNeedDaemonReload()) {
            setNeedDaemonReload(rhs.getNeedDaemonReload());
        } else {
            clearNeedDaemonReload();
        }
    }
    return *this;
}

inline bool NeedDaemonReloadUpdate::operator == (const NeedDaemonReloadUpdate& rhs) const {
    return (((!hasNeedDaemonReload() && !rhs.hasNeedDaemonReload()) || getNeedDaemonReload() == rhs.getNeedDaemonReload()));
}

inline bool NeedDaemonReloadUpdate::operator != (const NeedDaemonReloadUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NeedDaemonReloadUpdate::operator < (const NeedDaemonReloadUpdate& rhs) const {
    if (hasNeedDaemonReload() || rhs.hasNeedDaemonReload()) {
        if (getNeedDaemonReload() < rhs.getNeedDaemonReload()) return true;
        if (getNeedDaemonReload() > rhs.getNeedDaemonReload()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NeedDaemonReloadUpdate::clone() {
    return new NeedDaemonReloadUpdate(*this);
}

inline bool NeedDaemonReloadUpdate::operator > (const NeedDaemonReloadUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NeedDaemonReloadUpdate::clear() {
    clearNeedDaemonReload();
}

inline void NeedDaemonReloadUpdate::clearNeedDaemonReload() {
    if (hasNeedDaemonReload()) {
         clear_has_NeedDaemonReload();
        _NeedDaemonReload = false;
     }
}

inline bool NeedDaemonReloadUpdate::hasNeedDaemonReload () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool NeedDaemonReloadUpdate::getNeedDaemonReload () const {
    return _NeedDaemonReload;
}

inline void NeedDaemonReloadUpdate::setNeedDaemonReload (bool NeedDaemonReload_) {
    set_has_NeedDaemonReload();
    this->_NeedDaemonReload = NeedDaemonReload_;
}

inline void NeedDaemonReloadUpdate::set_has_NeedDaemonReload () {
    _has_bits_[0] |= 1u << 0;
}

inline void NeedDaemonReloadUpdate::clear_has_NeedDaemonReload () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NeedDaemonReloadRegister::NeedDaemonReloadRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NeedDaemonReloadRegister::NeedDaemonReloadRegister (const NeedDaemonReloadRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NeedDaemonReloadRegister::~NeedDaemonReloadRegister() {
}

inline NeedDaemonReloadRegister& NeedDaemonReloadRegister::operator = (const NeedDaemonReloadRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NeedDaemonReloadRegister::operator == (const NeedDaemonReloadRegister& ) const {
    return true;
}

inline bool NeedDaemonReloadRegister::operator != (const NeedDaemonReloadRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NeedDaemonReloadRegister::operator < (const NeedDaemonReloadRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NeedDaemonReloadRegister::clone() {
    return new NeedDaemonReloadRegister(*this);
}

inline bool NeedDaemonReloadRegister::operator > (const NeedDaemonReloadRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NeedDaemonReloadRegister::clear() {
}

inline  JobTimeoutUSecUpdate::JobTimeoutUSecUpdate ()  :
    _JobTimeoutUSec (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  JobTimeoutUSecUpdate::JobTimeoutUSecUpdate (const JobTimeoutUSecUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _JobTimeoutUSec (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  JobTimeoutUSecUpdate::JobTimeoutUSecUpdate (uint64 JobTimeoutUSec_)  :
    _JobTimeoutUSec (JobTimeoutUSec_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  JobTimeoutUSecUpdate::~JobTimeoutUSecUpdate() {
}

inline JobTimeoutUSecUpdate& JobTimeoutUSecUpdate::operator = (const JobTimeoutUSecUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobTimeoutUSec()) {
            setJobTimeoutUSec(rhs.getJobTimeoutUSec());
        } else {
            clearJobTimeoutUSec();
        }
    }
    return *this;
}

inline bool JobTimeoutUSecUpdate::operator == (const JobTimeoutUSecUpdate& rhs) const {
    return (((!hasJobTimeoutUSec() && !rhs.hasJobTimeoutUSec()) || getJobTimeoutUSec() == rhs.getJobTimeoutUSec()));
}

inline bool JobTimeoutUSecUpdate::operator != (const JobTimeoutUSecUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool JobTimeoutUSecUpdate::operator < (const JobTimeoutUSecUpdate& rhs) const {
    if (hasJobTimeoutUSec() || rhs.hasJobTimeoutUSec()) {
        if (getJobTimeoutUSec() < rhs.getJobTimeoutUSec()) return true;
        if (getJobTimeoutUSec() > rhs.getJobTimeoutUSec()) return false;
    }
    return false;
}

inline ::asf::core::Payload* JobTimeoutUSecUpdate::clone() {
    return new JobTimeoutUSecUpdate(*this);
}

inline bool JobTimeoutUSecUpdate::operator > (const JobTimeoutUSecUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void JobTimeoutUSecUpdate::clear() {
    clearJobTimeoutUSec();
}

inline void JobTimeoutUSecUpdate::clearJobTimeoutUSec() {
    if (hasJobTimeoutUSec()) {
         clear_has_JobTimeoutUSec();
        _JobTimeoutUSec = 0u;
     }
}

inline bool JobTimeoutUSecUpdate::hasJobTimeoutUSec () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 JobTimeoutUSecUpdate::getJobTimeoutUSec () const {
    return _JobTimeoutUSec;
}

inline void JobTimeoutUSecUpdate::setJobTimeoutUSec (uint64 JobTimeoutUSec_) {
    set_has_JobTimeoutUSec();
    this->_JobTimeoutUSec = JobTimeoutUSec_;
}

inline void JobTimeoutUSecUpdate::set_has_JobTimeoutUSec () {
    _has_bits_[0] |= 1u << 0;
}

inline void JobTimeoutUSecUpdate::clear_has_JobTimeoutUSec () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  JobTimeoutUSecRegister::JobTimeoutUSecRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  JobTimeoutUSecRegister::JobTimeoutUSecRegister (const JobTimeoutUSecRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  JobTimeoutUSecRegister::~JobTimeoutUSecRegister() {
}

inline JobTimeoutUSecRegister& JobTimeoutUSecRegister::operator = (const JobTimeoutUSecRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool JobTimeoutUSecRegister::operator == (const JobTimeoutUSecRegister& ) const {
    return true;
}

inline bool JobTimeoutUSecRegister::operator != (const JobTimeoutUSecRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool JobTimeoutUSecRegister::operator < (const JobTimeoutUSecRegister& ) const {
    return false;
}

inline ::asf::core::Payload* JobTimeoutUSecRegister::clone() {
    return new JobTimeoutUSecRegister(*this);
}

inline bool JobTimeoutUSecRegister::operator > (const JobTimeoutUSecRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void JobTimeoutUSecRegister::clear() {
}

inline  JobTimeoutActionUpdate::JobTimeoutActionUpdate ()  :
    _JobTimeoutAction ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  JobTimeoutActionUpdate::JobTimeoutActionUpdate (const JobTimeoutActionUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _JobTimeoutAction ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  JobTimeoutActionUpdate::JobTimeoutActionUpdate (const ::std::string& JobTimeoutAction_)  :
    _JobTimeoutAction (JobTimeoutAction_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (JobTimeoutAction_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  JobTimeoutActionUpdate::~JobTimeoutActionUpdate() {
}

inline JobTimeoutActionUpdate& JobTimeoutActionUpdate::operator = (const JobTimeoutActionUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobTimeoutAction()) {
            setJobTimeoutAction(rhs.getJobTimeoutAction());
        } else {
            clearJobTimeoutAction();
        }
    }
    return *this;
}

inline bool JobTimeoutActionUpdate::operator == (const JobTimeoutActionUpdate& rhs) const {
    return (((!hasJobTimeoutAction() && !rhs.hasJobTimeoutAction()) || getJobTimeoutAction() == rhs.getJobTimeoutAction()));
}

inline bool JobTimeoutActionUpdate::operator != (const JobTimeoutActionUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool JobTimeoutActionUpdate::operator < (const JobTimeoutActionUpdate& rhs) const {
    if (hasJobTimeoutAction() || rhs.hasJobTimeoutAction()) {
        if (getJobTimeoutAction() < rhs.getJobTimeoutAction()) return true;
        if (getJobTimeoutAction() > rhs.getJobTimeoutAction()) return false;
    }
    return false;
}

inline ::asf::core::Payload* JobTimeoutActionUpdate::clone() {
    return new JobTimeoutActionUpdate(*this);
}

inline bool JobTimeoutActionUpdate::operator > (const JobTimeoutActionUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void JobTimeoutActionUpdate::clear() {
    clearJobTimeoutAction();
}

inline void JobTimeoutActionUpdate::clearJobTimeoutAction() {
    if (hasJobTimeoutAction()) {
         clear_has_JobTimeoutAction();
        _JobTimeoutAction.clear();
     }
}

inline bool JobTimeoutActionUpdate::hasJobTimeoutAction () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& JobTimeoutActionUpdate::getJobTimeoutAction () const {
    return _JobTimeoutAction;
}

inline ::std::string& JobTimeoutActionUpdate::getJobTimeoutActionMutable () {
    set_has_JobTimeoutAction();
    return _JobTimeoutAction;
}

inline void JobTimeoutActionUpdate::setJobTimeoutAction (const ::std::string& JobTimeoutAction_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (JobTimeoutAction_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_JobTimeoutAction();
    this->_JobTimeoutAction = JobTimeoutAction_;
}

inline void JobTimeoutActionUpdate::setJobTimeoutAction (const char* JobTimeoutAction_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (JobTimeoutAction_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_JobTimeoutAction();
    this->_JobTimeoutAction.assign(JobTimeoutAction_);
}

inline void JobTimeoutActionUpdate::setJobTimeoutAction (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_JobTimeoutAction();
    this->_JobTimeoutAction.assign(value, size);
}

inline void JobTimeoutActionUpdate::set_has_JobTimeoutAction () {
    _has_bits_[0] |= 1u << 0;
}

inline void JobTimeoutActionUpdate::clear_has_JobTimeoutAction () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  JobTimeoutActionRegister::JobTimeoutActionRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  JobTimeoutActionRegister::JobTimeoutActionRegister (const JobTimeoutActionRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  JobTimeoutActionRegister::~JobTimeoutActionRegister() {
}

inline JobTimeoutActionRegister& JobTimeoutActionRegister::operator = (const JobTimeoutActionRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool JobTimeoutActionRegister::operator == (const JobTimeoutActionRegister& ) const {
    return true;
}

inline bool JobTimeoutActionRegister::operator != (const JobTimeoutActionRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool JobTimeoutActionRegister::operator < (const JobTimeoutActionRegister& ) const {
    return false;
}

inline ::asf::core::Payload* JobTimeoutActionRegister::clone() {
    return new JobTimeoutActionRegister(*this);
}

inline bool JobTimeoutActionRegister::operator > (const JobTimeoutActionRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void JobTimeoutActionRegister::clear() {
}

inline  JobTimeoutRebootArgumentUpdate::JobTimeoutRebootArgumentUpdate ()  :
    _JobTimeoutRebootArgument ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  JobTimeoutRebootArgumentUpdate::JobTimeoutRebootArgumentUpdate (const JobTimeoutRebootArgumentUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _JobTimeoutRebootArgument ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  JobTimeoutRebootArgumentUpdate::JobTimeoutRebootArgumentUpdate (const ::std::string& JobTimeoutRebootArgument_)  :
    _JobTimeoutRebootArgument (JobTimeoutRebootArgument_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (JobTimeoutRebootArgument_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  JobTimeoutRebootArgumentUpdate::~JobTimeoutRebootArgumentUpdate() {
}

inline JobTimeoutRebootArgumentUpdate& JobTimeoutRebootArgumentUpdate::operator = (const JobTimeoutRebootArgumentUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobTimeoutRebootArgument()) {
            setJobTimeoutRebootArgument(rhs.getJobTimeoutRebootArgument());
        } else {
            clearJobTimeoutRebootArgument();
        }
    }
    return *this;
}

inline bool JobTimeoutRebootArgumentUpdate::operator == (const JobTimeoutRebootArgumentUpdate& rhs) const {
    return (((!hasJobTimeoutRebootArgument() && !rhs.hasJobTimeoutRebootArgument()) || getJobTimeoutRebootArgument() == rhs.getJobTimeoutRebootArgument()));
}

inline bool JobTimeoutRebootArgumentUpdate::operator != (const JobTimeoutRebootArgumentUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool JobTimeoutRebootArgumentUpdate::operator < (const JobTimeoutRebootArgumentUpdate& rhs) const {
    if (hasJobTimeoutRebootArgument() || rhs.hasJobTimeoutRebootArgument()) {
        if (getJobTimeoutRebootArgument() < rhs.getJobTimeoutRebootArgument()) return true;
        if (getJobTimeoutRebootArgument() > rhs.getJobTimeoutRebootArgument()) return false;
    }
    return false;
}

inline ::asf::core::Payload* JobTimeoutRebootArgumentUpdate::clone() {
    return new JobTimeoutRebootArgumentUpdate(*this);
}

inline bool JobTimeoutRebootArgumentUpdate::operator > (const JobTimeoutRebootArgumentUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void JobTimeoutRebootArgumentUpdate::clear() {
    clearJobTimeoutRebootArgument();
}

inline void JobTimeoutRebootArgumentUpdate::clearJobTimeoutRebootArgument() {
    if (hasJobTimeoutRebootArgument()) {
         clear_has_JobTimeoutRebootArgument();
        _JobTimeoutRebootArgument.clear();
     }
}

inline bool JobTimeoutRebootArgumentUpdate::hasJobTimeoutRebootArgument () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& JobTimeoutRebootArgumentUpdate::getJobTimeoutRebootArgument () const {
    return _JobTimeoutRebootArgument;
}

inline ::std::string& JobTimeoutRebootArgumentUpdate::getJobTimeoutRebootArgumentMutable () {
    set_has_JobTimeoutRebootArgument();
    return _JobTimeoutRebootArgument;
}

inline void JobTimeoutRebootArgumentUpdate::setJobTimeoutRebootArgument (const ::std::string& JobTimeoutRebootArgument_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (JobTimeoutRebootArgument_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_JobTimeoutRebootArgument();
    this->_JobTimeoutRebootArgument = JobTimeoutRebootArgument_;
}

inline void JobTimeoutRebootArgumentUpdate::setJobTimeoutRebootArgument (const char* JobTimeoutRebootArgument_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (JobTimeoutRebootArgument_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_JobTimeoutRebootArgument();
    this->_JobTimeoutRebootArgument.assign(JobTimeoutRebootArgument_);
}

inline void JobTimeoutRebootArgumentUpdate::setJobTimeoutRebootArgument (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_JobTimeoutRebootArgument();
    this->_JobTimeoutRebootArgument.assign(value, size);
}

inline void JobTimeoutRebootArgumentUpdate::set_has_JobTimeoutRebootArgument () {
    _has_bits_[0] |= 1u << 0;
}

inline void JobTimeoutRebootArgumentUpdate::clear_has_JobTimeoutRebootArgument () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  JobTimeoutRebootArgumentRegister::JobTimeoutRebootArgumentRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  JobTimeoutRebootArgumentRegister::JobTimeoutRebootArgumentRegister (const JobTimeoutRebootArgumentRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  JobTimeoutRebootArgumentRegister::~JobTimeoutRebootArgumentRegister() {
}

inline JobTimeoutRebootArgumentRegister& JobTimeoutRebootArgumentRegister::operator = (const JobTimeoutRebootArgumentRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool JobTimeoutRebootArgumentRegister::operator == (const JobTimeoutRebootArgumentRegister& ) const {
    return true;
}

inline bool JobTimeoutRebootArgumentRegister::operator != (const JobTimeoutRebootArgumentRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool JobTimeoutRebootArgumentRegister::operator < (const JobTimeoutRebootArgumentRegister& ) const {
    return false;
}

inline ::asf::core::Payload* JobTimeoutRebootArgumentRegister::clone() {
    return new JobTimeoutRebootArgumentRegister(*this);
}

inline bool JobTimeoutRebootArgumentRegister::operator > (const JobTimeoutRebootArgumentRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void JobTimeoutRebootArgumentRegister::clear() {
}

inline  ConditionResultUpdate::ConditionResultUpdate ()  :
    _ConditionResult (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConditionResultUpdate::ConditionResultUpdate (const ConditionResultUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ConditionResult (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConditionResultUpdate::ConditionResultUpdate (bool ConditionResult_)  :
    _ConditionResult (ConditionResult_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConditionResultUpdate::~ConditionResultUpdate() {
}

inline ConditionResultUpdate& ConditionResultUpdate::operator = (const ConditionResultUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConditionResult()) {
            setConditionResult(rhs.getConditionResult());
        } else {
            clearConditionResult();
        }
    }
    return *this;
}

inline bool ConditionResultUpdate::operator == (const ConditionResultUpdate& rhs) const {
    return (((!hasConditionResult() && !rhs.hasConditionResult()) || getConditionResult() == rhs.getConditionResult()));
}

inline bool ConditionResultUpdate::operator != (const ConditionResultUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ConditionResultUpdate::operator < (const ConditionResultUpdate& rhs) const {
    if (hasConditionResult() || rhs.hasConditionResult()) {
        if (getConditionResult() < rhs.getConditionResult()) return true;
        if (getConditionResult() > rhs.getConditionResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConditionResultUpdate::clone() {
    return new ConditionResultUpdate(*this);
}

inline bool ConditionResultUpdate::operator > (const ConditionResultUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConditionResultUpdate::clear() {
    clearConditionResult();
}

inline void ConditionResultUpdate::clearConditionResult() {
    if (hasConditionResult()) {
         clear_has_ConditionResult();
        _ConditionResult = false;
     }
}

inline bool ConditionResultUpdate::hasConditionResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ConditionResultUpdate::getConditionResult () const {
    return _ConditionResult;
}

inline void ConditionResultUpdate::setConditionResult (bool ConditionResult_) {
    set_has_ConditionResult();
    this->_ConditionResult = ConditionResult_;
}

inline void ConditionResultUpdate::set_has_ConditionResult () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConditionResultUpdate::clear_has_ConditionResult () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConditionResultRegister::ConditionResultRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConditionResultRegister::ConditionResultRegister (const ConditionResultRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConditionResultRegister::~ConditionResultRegister() {
}

inline ConditionResultRegister& ConditionResultRegister::operator = (const ConditionResultRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ConditionResultRegister::operator == (const ConditionResultRegister& ) const {
    return true;
}

inline bool ConditionResultRegister::operator != (const ConditionResultRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ConditionResultRegister::operator < (const ConditionResultRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ConditionResultRegister::clone() {
    return new ConditionResultRegister(*this);
}

inline bool ConditionResultRegister::operator > (const ConditionResultRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConditionResultRegister::clear() {
}

inline  AssertResultUpdate::AssertResultUpdate ()  :
    _AssertResult (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AssertResultUpdate::AssertResultUpdate (const AssertResultUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _AssertResult (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AssertResultUpdate::AssertResultUpdate (bool AssertResult_)  :
    _AssertResult (AssertResult_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AssertResultUpdate::~AssertResultUpdate() {
}

inline AssertResultUpdate& AssertResultUpdate::operator = (const AssertResultUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAssertResult()) {
            setAssertResult(rhs.getAssertResult());
        } else {
            clearAssertResult();
        }
    }
    return *this;
}

inline bool AssertResultUpdate::operator == (const AssertResultUpdate& rhs) const {
    return (((!hasAssertResult() && !rhs.hasAssertResult()) || getAssertResult() == rhs.getAssertResult()));
}

inline bool AssertResultUpdate::operator != (const AssertResultUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AssertResultUpdate::operator < (const AssertResultUpdate& rhs) const {
    if (hasAssertResult() || rhs.hasAssertResult()) {