/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_FREEDESKTOP_SYSTEMD1_SERVICESTUB_H
#define ORG_FREEDESKTOP_SYSTEMD1_SERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/freedesktop/systemd1/Service.h"
#include <string>
#include <vector>

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

class ServiceStubDelegate;

class ServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ServiceStub (const std::string& portName);

    /**
     * Create an instance of the ServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~ServiceStub();

    // property 'Type'

    /**
     * The method onTypeGet() is called by ASF when a client invokes the read
     * method for the property 'Type'. The onTypeGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * Type
     */
    virtual void onTypeGet(const ::boost::shared_ptr< TypeGet >& payload);

    /**
     * Sends back the update to a previous onTypeGet().
     *
     * <b>Documentation of 'Type'</b>:
     *
     * Type
     *
     * @param act Identifies a previous invocation of onTypeGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTypeGetUpdate(const ::std::string& type, act_t act = 0);

    /**
     * Set the value of the property 'Type' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * Type
     */
    void setType(const ::std::string& type);

    /**
     * Returns the current value of the property 'Type'.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * Type
     */
    const ::std::string& getType() const;

    /**
     * Returns the current value of the property 'Type' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendTypeUpdate() method.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * Type
     */
    ::std::string& getTypeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTypeUpdate().
     *
     * <b>Documentation of 'Type'</b>:
     *
     * Type
     */
    void sendTypeUpdate();

    // property 'Restart'

    /**
     * The method onRestartGet() is called by ASF when a client invokes the
     * read method for the property 'Restart'. The onRestartGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * Restart
     */
    virtual void onRestartGet(const ::boost::shared_ptr< RestartGet >& payload);

    /**
     * Sends back the update to a previous onRestartGet().
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * Restart
     *
     * @param act Identifies a previous invocation of onRestartGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRestartGetUpdate(const ::std::string& restart, act_t act = 0);

    /**
     * Set the value of the property 'Restart' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * Restart
     */
    void setRestart(const ::std::string& restart);

    /**
     * Returns the current value of the property 'Restart'.
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * Restart
     */
    const ::std::string& getRestart() const;

    /**
     * Returns the current value of the property 'Restart' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendRestartUpdate() method.
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * Restart
     */
    ::std::string& getRestartMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRestartUpdate().
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * Restart
     */
    void sendRestartUpdate();

    // property 'PIDFile'

    /**
     * The method onPIDFileGet() is called by ASF when a client invokes the
     * read method for the property 'PIDFile'. The onPIDFileGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'PIDFile'</b>:
     *
     * PIDFile
     */
    virtual void onPIDFileGet(const ::boost::shared_ptr< PIDFileGet >& payload);

    /**
     * Sends back the update to a previous onPIDFileGet().
     *
     * <b>Documentation of 'PIDFile'</b>:
     *
     * PIDFile
     *
     * @param act Identifies a previous invocation of onPIDFileGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPIDFileGetUpdate(const ::std::string& pIDFile, act_t act = 0);

    /**
     * Set the value of the property 'PIDFile' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'PIDFile'</b>:
     *
     * PIDFile
     */
    void setPIDFile(const ::std::string& pIDFile);

    /**
     * Returns the current value of the property 'PIDFile'.
     *
     * <b>Documentation of 'PIDFile'</b>:
     *
     * PIDFile
     */
    const ::std::string& getPIDFile() const;

    /**
     * Returns the current value of the property 'PIDFile' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendPIDFileUpdate() method.
     *
     * <b>Documentation of 'PIDFile'</b>:
     *
     * PIDFile
     */
    ::std::string& getPIDFileMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPIDFileUpdate().
     *
     * <b>Documentation of 'PIDFile'</b>:
     *
     * PIDFile
     */
    void sendPIDFileUpdate();

    // property 'NotifyAccess'

    /**
     * The method onNotifyAccessGet() is called by ASF when a client invokes
     * the read method for the property 'NotifyAccess'. The
     * onNotifyAccessGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'NotifyAccess'</b>:
     *
     * NotifyAccess
     */
    virtual void onNotifyAccessGet(const ::boost::shared_ptr< NotifyAccessGet >& payload);

    /**
     * Sends back the update to a previous onNotifyAccessGet().
     *
     * <b>Documentation of 'NotifyAccess'</b>:
     *
     * NotifyAccess
     *
     * @param act Identifies a previous invocation of onNotifyAccessGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNotifyAccessGetUpdate(const ::std::string& notifyAccess, act_t act = 0);

    /**
     * Set the value of the property 'NotifyAccess' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'NotifyAccess'</b>:
     *
     * NotifyAccess
     */
    void setNotifyAccess(const ::std::string& notifyAccess);

    /**
     * Returns the current value of the property 'NotifyAccess'.
     *
     * <b>Documentation of 'NotifyAccess'</b>:
     *
     * NotifyAccess
     */
    const ::std::string& getNotifyAccess() const;

    /**
     * Returns the current value of the property 'NotifyAccess' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendNotifyAccessUpdate() method.
     *
     * <b>Documentation of 'NotifyAccess'</b>:
     *
     * NotifyAccess
     */
    ::std::string& getNotifyAccessMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNotifyAccessUpdate().
     *
     * <b>Documentation of 'NotifyAccess'</b>:
     *
     * NotifyAccess
     */
    void sendNotifyAccessUpdate();

    // property 'RestartUSec'

    /**
     * The method onRestartUSecGet() is called by ASF when a client invokes
     * the read method for the property 'RestartUSec'. The onRestartUSecGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'RestartUSec'</b>:
     *
     * RestartUSec
     */
    virtual void onRestartUSecGet(const ::boost::shared_ptr< RestartUSecGet >& payload);

    /**
     * Sends back the update to a previous onRestartUSecGet().
     *
     * <b>Documentation of 'RestartUSec'</b>:
     *
     * RestartUSec
     *
     * @param act Identifies a previous invocation of onRestartUSecGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRestartUSecGetUpdate(uint64 restartUSec, act_t act = 0);

    /**
     * Set the value of the property 'RestartUSec' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RestartUSec'</b>:
     *
     * RestartUSec
     */
    void setRestartUSec(uint64 restartUSec);

    /**
     * Returns the current value of the property 'RestartUSec'.
     *
     * <b>Documentation of 'RestartUSec'</b>:
     *
     * RestartUSec
     */
    uint64 getRestartUSec() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRestartUSecUpdate().
     *
     * <b>Documentation of 'RestartUSec'</b>:
     *
     * RestartUSec
     */
    void sendRestartUSecUpdate();

    // property 'TimeoutStartUSec'

    /**
     * The method onTimeoutStartUSecGet() is called by ASF when a client
     * invokes the read method for the property 'TimeoutStartUSec'. The
     * onTimeoutStartUSecGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'TimeoutStartUSec'</b>:
     *
     * TimeoutStartUSec
     */
    virtual void onTimeoutStartUSecGet(const ::boost::shared_ptr< TimeoutStartUSecGet >& payload);

    /**
     * Sends back the update to a previous onTimeoutStartUSecGet().
     *
     * <b>Documentation of 'TimeoutStartUSec'</b>:
     *
     * TimeoutStartUSec
     *
     * @param act Identifies a previous invocation of onTimeoutStartUSecGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTimeoutStartUSecGetUpdate(uint64 timeoutStartUSec, act_t act = 0);

    /**
     * Set the value of the property 'TimeoutStartUSec' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'TimeoutStartUSec'</b>:
     *
     * TimeoutStartUSec
     */
    void setTimeoutStartUSec(uint64 timeoutStartUSec);

    /**
     * Returns the current value of the property 'TimeoutStartUSec'.
     *
     * <b>Documentation of 'TimeoutStartUSec'</b>:
     *
     * TimeoutStartUSec
     */
    uint64 getTimeoutStartUSec() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTimeoutStartUSecUpdate().
     *
     * <b>Documentation of 'TimeoutStartUSec'</b>:
     *
     * TimeoutStartUSec
     */
    void sendTimeoutStartUSecUpdate();

    // property 'TimeoutStopUSec'

    /**
     * The method onTimeoutStopUSecGet() is called by ASF when a client
     * invokes the read method for the property 'TimeoutStopUSec'. The
     * onTimeoutStopUSecGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'TimeoutStopUSec'</b>:
     *
     * TimeoutStopUSec
     */
    virtual void onTimeoutStopUSecGet(const ::boost::shared_ptr< TimeoutStopUSecGet >& payload);

    /**
     * Sends back the update to a previous onTimeoutStopUSecGet().
     *
     * <b>Documentation of 'TimeoutStopUSec'</b>:
     *
     * TimeoutStopUSec
     *
     * @param act Identifies a previous invocation of onTimeoutStopUSecGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTimeoutStopUSecGetUpdate(uint64 timeoutStopUSec, act_t act = 0);

    /**
     * Set the value of the property 'TimeoutStopUSec' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'TimeoutStopUSec'</b>:
     *
     * TimeoutStopUSec
     */
    void setTimeoutStopUSec(uint64 timeoutStopUSec);

    /**
     * Returns the current value of the property 'TimeoutStopUSec'.
     *
     * <b>Documentation of 'TimeoutStopUSec'</b>:
     *
     * TimeoutStopUSec
     */
    uint64 getTimeoutStopUSec() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTimeoutStopUSecUpdate().
     *
     * <b>Documentation of 'TimeoutStopUSec'</b>:
     *
     * TimeoutStopUSec
     */
    void sendTimeoutStopUSecUpdate();

    // property 'WatchdogUSec'

    /**
     * The method onWatchdogUSecGet() is called by ASF when a client invokes
     * the read method for the property 'WatchdogUSec'. The
     * onWatchdogUSecGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'WatchdogUSec'</b>:
     *
     * WatchdogUSec
     */
    virtual void onWatchdogUSecGet(const ::boost::shared_ptr< WatchdogUSecGet >& payload);

    /**
     * Sends back the update to a previous onWatchdogUSecGet().
     *
     * <b>Documentation of 'WatchdogUSec'</b>:
     *
     * WatchdogUSec
     *
     * @param act Identifies a previous invocation of onWatchdogUSecGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendWatchdogUSecGetUpdate(uint64 watchdogUSec, act_t act = 0);

    /**
     * Set the value of the property 'WatchdogUSec' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'WatchdogUSec'</b>:
     *
     * WatchdogUSec
     */
    void setWatchdogUSec(uint64 watchdogUSec);

    /**
     * Returns the current value of the property 'WatchdogUSec'.
     *
     * <b>Documentation of 'WatchdogUSec'</b>:
     *
     * WatchdogUSec
     */
    uint64 getWatchdogUSec() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWatchdogUSecUpdate().
     *
     * <b>Documentation of 'WatchdogUSec'</b>:
     *
     * WatchdogUSec
     */
    void sendWatchdogUSecUpdate();

    // property 'WatchdogTimestamp'

    /**
     * The method onWatchdogTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'WatchdogTimestamp'. The
     * onWatchdogTimestampGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'WatchdogTimestamp'</b>:
     *
     * WatchdogTimestamp
     */
    virtual void onWatchdogTimestampGet(const ::boost::shared_ptr< WatchdogTimestampGet >& payload);

    /**
     * Sends back the update to a previous onWatchdogTimestampGet().
     *
     * <b>Documentation of 'WatchdogTimestamp'</b>:
     *
     * WatchdogTimestamp
     *
     * @param act Identifies a previous invocation of
     * onWatchdogTimestampGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendWatchdogTimestampGetUpdate(uint64 watchdogTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'WatchdogTimestamp' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'WatchdogTimestamp'</b>:
     *
     * WatchdogTimestamp
     */
    void setWatchdogTimestamp(uint64 watchdogTimestamp);

    /**
     * Returns the current value of the property 'WatchdogTimestamp'.
     *
     * <b>Documentation of 'WatchdogTimestamp'</b>:
     *
     * WatchdogTimestamp
     */
    uint64 getWatchdogTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWatchdogTimestampUpdate().
     *
     * <b>Documentation of 'WatchdogTimestamp'</b>:
     *
     * WatchdogTimestamp
     */
    void sendWatchdogTimestampUpdate();

    // property 'WatchdogTimestampMonotonic'

    /**
     * The method onWatchdogTimestampMonotonicGet() is called by ASF when a
     * client invokes the read method for the property
     * 'WatchdogTimestampMonotonic'. The onWatchdogTimestampMonotonicGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'WatchdogTimestampMonotonic'</b>:
     *
     * WatchdogTimestampMonotonic
     */
    virtual void onWatchdogTimestampMonotonicGet(const ::boost::shared_ptr< WatchdogTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous onWatchdogTimestampMonotonicGet().
     *
     * <b>Documentation of 'WatchdogTimestampMonotonic'</b>:
     *
     * WatchdogTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onWatchdogTimestampMonotonicGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendWatchdogTimestampMonotonicGetUpdate(uint64 watchdogTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'WatchdogTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'WatchdogTimestampMonotonic'</b>:
     *
     * WatchdogTimestampMonotonic
     */
    void setWatchdogTimestampMonotonic(uint64 watchdogTimestampMonotonic);

    /**
     * Returns the current value of the property 'WatchdogTimestampMonotonic'.
     *
     * <b>Documentation of 'WatchdogTimestampMonotonic'</b>:
     *
     * WatchdogTimestampMonotonic
     */
    uint64 getWatchdogTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWatchdogTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'WatchdogTimestampMonotonic'</b>:
     *
     * WatchdogTimestampMonotonic
     */
    void sendWatchdogTimestampMonotonicUpdate();

    // property 'StartLimitInterval'

    /**
     * The method onStartLimitIntervalGet() is called by ASF when a client
     * invokes the read method for the property 'StartLimitInterval'. The
     * onStartLimitIntervalGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'StartLimitInterval'</b>:
     *
     * StartLimitInterval
     */
    virtual void onStartLimitIntervalGet(const ::boost::shared_ptr< StartLimitIntervalGet >& payload);

    /**
     * Sends back the update to a previous onStartLimitIntervalGet().
     *
     * <b>Documentation of 'StartLimitInterval'</b>:
     *
     * StartLimitInterval
     *
     * @param act Identifies a previous invocation of
     * onStartLimitIntervalGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartLimitIntervalGetUpdate(uint64 startLimitInterval, act_t act = 0);

    /**
     * Set the value of the property 'StartLimitInterval' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StartLimitInterval'</b>:
     *
     * StartLimitInterval
     */
    void setStartLimitInterval(uint64 startLimitInterval);

    /**
     * Returns the current value of the property 'StartLimitInterval'.
     *
     * <b>Documentation of 'StartLimitInterval'</b>:
     *
     * StartLimitInterval
     */
    uint64 getStartLimitInterval() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStartLimitIntervalUpdate().
     *
     * <b>Documentation of 'StartLimitInterval'</b>:
     *
     * StartLimitInterval
     */
    void sendStartLimitIntervalUpdate();

    // property 'StartLimitBurst'

    /**
     * The method onStartLimitBurstGet() is called by ASF when a client
     * invokes the read method for the property 'StartLimitBurst'. The
     * onStartLimitBurstGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'StartLimitBurst'</b>:
     *
     * StartLimitBurst
     */
    virtual void onStartLimitBurstGet(const ::boost::shared_ptr< StartLimitBurstGet >& payload);

    /**
     * Sends back the update to a previous onStartLimitBurstGet().
     *
     * <b>Documentation of 'StartLimitBurst'</b>:
     *
     * StartLimitBurst
     *
     * @param act Identifies a previous invocation of onStartLimitBurstGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartLimitBurstGetUpdate(uint32 startLimitBurst, act_t act = 0);

    /**
     * Set the value of the property 'StartLimitBurst' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StartLimitBurst'</b>:
     *
     * StartLimitBurst
     */
    void setStartLimitBurst(uint32 startLimitBurst);

    /**
     * Returns the current value of the property 'StartLimitBurst'.
     *
     * <b>Documentation of 'StartLimitBurst'</b>:
     *
     * StartLimitBurst
     */
    uint32 getStartLimitBurst() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStartLimitBurstUpdate().
     *
     * <b>Documentation of 'StartLimitBurst'</b>:
     *
     * StartLimitBurst
     */
    void sendStartLimitBurstUpdate();

    // property 'StartLimitAction'

    /**
     * The method onStartLimitActionGet() is called by ASF when a client
     * invokes the read method for the property 'StartLimitAction'. The
     * onStartLimitActionGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'StartLimitAction'</b>:
     *
     * StartLimitAction
     */
    virtual void onStartLimitActionGet(const ::boost::shared_ptr< StartLimitActionGet >& payload);

    /**
     * Sends back the update to a previous onStartLimitActionGet().
     *
     * <b>Documentation of 'StartLimitAction'</b>:
     *
     * StartLimitAction
     *
     * @param act Identifies a previous invocation of onStartLimitActionGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartLimitActionGetUpdate(const ::std::string& startLimitAction, act_t act = 0);

    /**
     * Set the value of the property 'StartLimitAction' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StartLimitAction'</b>:
     *
     * StartLimitAction
     */
    void setStartLimitAction(const ::std::string& startLimitAction);

    /**
     * Returns the current value of the property 'StartLimitAction'.
     *
     * <b>Documentation of 'StartLimitAction'</b>:
     *
     * StartLimitAction
     */
    const ::std::string& getStartLimitAction() const;

    /**
     * Returns the current value of the property 'StartLimitAction' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendStartLimitActionUpdate() method.
     *
     * <b>Documentation of 'StartLimitAction'</b>:
     *
     * StartLimitAction
     */
    ::std::string& getStartLimitActionMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStartLimitActionUpdate().
     *
     * <b>Documentation of 'StartLimitAction'</b>:
     *
     * StartLimitAction
     */
    void sendStartLimitActionUpdate();

    // property 'RebootArgument'

    /**
     * The method onRebootArgumentGet() is called by ASF when a client invokes
     * the read method for the property 'RebootArgument'. The
     * onRebootArgumentGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RebootArgument'</b>:
     *
     * RebootArgument
     */
    virtual void onRebootArgumentGet(const ::boost::shared_ptr< RebootArgumentGet >& payload);

    /**
     * Sends back the update to a previous onRebootArgumentGet().
     *
     * <b>Documentation of 'RebootArgument'</b>:
     *
     * RebootArgument
     *
     * @param act Identifies a previous invocation of onRebootArgumentGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRebootArgumentGetUpdate(const ::std::string& rebootArgument, act_t act = 0);

    /**
     * Set the value of the property 'RebootArgument' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RebootArgument'</b>:
     *
     * RebootArgument
     */
    void setRebootArgument(const ::std::string& rebootArgument);

    /**
     * Returns the current value of the property 'RebootArgument'.
     *
     * <b>Documentation of 'RebootArgument'</b>:
     *
     * RebootArgument
     */
    const ::std::string& getRebootArgument() const;

    /**
     * Returns the current value of the property 'RebootArgument' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendRebootArgumentUpdate() method.
     *
     * <b>Documentation of 'RebootArgument'</b>:
     *
     * RebootArgument
     */
    ::std::string& getRebootArgumentMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRebootArgumentUpdate().
     *
     * <b>Documentation of 'RebootArgument'</b>:
     *
     * RebootArgument
     */
    void sendRebootArgumentUpdate();

    // property 'FailureAction'

    /**
     * The method onFailureActionGet() is called by ASF when a client invokes
     * the read method for the property 'FailureAction'. The
     * onFailureActionGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'FailureAction'</b>:
     *
     * FailureAction
     */
    virtual void onFailureActionGet(const ::boost::shared_ptr< FailureActionGet >& payload);

    /**
     * Sends back the update to a previous onFailureActionGet().
     *
     * <b>Documentation of 'FailureAction'</b>:
     *
     * FailureAction
     *
     * @param act Identifies a previous invocation of onFailureActionGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendFailureActionGetUpdate(const ::std::string& failureAction, act_t act = 0);

    /**
     * Set the value of the property 'FailureAction' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'FailureAction'</b>:
     *
     * FailureAction
     */
    void setFailureAction(const ::std::string& failureAction);

    /**
     * Returns the current value of the property 'FailureAction'.
     *
     * <b>Documentation of 'FailureAction'</b>:
     *
     * FailureAction
     */
    const ::std::string& getFailureAction() const;

    /**
     * Returns the current value of the property 'FailureAction' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendFailureActionUpdate() method.
     *
     * <b>Documentation of 'FailureAction'</b>:
     *
     * FailureAction
     */
    ::std::string& getFailureActionMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFailureActionUpdate().
     *
     * <b>Documentation of 'FailureAction'</b>:
     *
     * FailureAction
     */
    void sendFailureActionUpdate();

    // property 'PermissionsStartOnly'

    /**
     * The method onPermissionsStartOnlyGet() is called by ASF when a client
     * invokes the read method for the property 'PermissionsStartOnly'. The
     * onPermissionsStartOnlyGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'PermissionsStartOnly'</b>:
     *
     * PermissionsStartOnly
     */
    virtual void onPermissionsStartOnlyGet(const ::boost::shared_ptr< PermissionsStartOnlyGet >& payload);

    /**
     * Sends back the update to a previous onPermissionsStartOnlyGet().
     *
     * <b>Documentation of 'PermissionsStartOnly'</b>:
     *
     * PermissionsStartOnly
     *
     * @param act Identifies a previous invocation of
     * onPermissionsStartOnlyGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPermissionsStartOnlyGetUpdate(bool permissionsStartOnly, act_t act = 0);

    /**
     * Set the value of the property 'PermissionsStartOnly' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'PermissionsStartOnly'</b>:
     *
     * PermissionsStartOnly
     */
    void setPermissionsStartOnly(bool permissionsStartOnly);

    /**
     * Returns the current value of the property 'PermissionsStartOnly'.
     *
     * <b>Documentation of 'PermissionsStartOnly'</b>:
     *
     * PermissionsStartOnly
     */
    bool getPermissionsStartOnly() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPermissionsStartOnlyUpdate().
     *
     * <b>Documentation of 'PermissionsStartOnly'</b>:
     *
     * PermissionsStartOnly
     */
    void sendPermissionsStartOnlyUpdate();

    // property 'RootDirectoryStartOnly'

    /**
     * The method onRootDirectoryStartOnlyGet() is called by ASF when a client
     * invokes the read method for the property 'RootDirectoryStartOnly'. The
     * onRootDirectoryStartOnlyGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'RootDirectoryStartOnly'</b>:
     *
     * RootDirectoryStartOnly
     */
    virtual void onRootDirectoryStartOnlyGet(const ::boost::shared_ptr< RootDirectoryStartOnlyGet >& payload);

    /**
     * Sends back the update to a previous onRootDirectoryStartOnlyGet().
     *
     * <b>Documentation of 'RootDirectoryStartOnly'</b>:
     *
     * RootDirectoryStartOnly
     *
     * @param act Identifies a previous invocation of
     * onRootDirectoryStartOnlyGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRootDirectoryStartOnlyGetUpdate(bool rootDirectoryStartOnly, act_t act = 0);

    /**
     * Set the value of the property 'RootDirectoryStartOnly' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'RootDirectoryStartOnly'</b>:
     *
     * RootDirectoryStartOnly
     */
    void setRootDirectoryStartOnly(bool rootDirectoryStartOnly);

    /**
     * Returns the current value of the property 'RootDirectoryStartOnly'.
     *
     * <b>Documentation of 'RootDirectoryStartOnly'</b>:
     *
     * RootDirectoryStartOnly
     */
    bool getRootDirectoryStartOnly() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRootDirectoryStartOnlyUpdate().
     *
     * <b>Documentation of 'RootDirectoryStartOnly'</b>:
     *
     * RootDirectoryStartOnly
     */
    void sendRootDirectoryStartOnlyUpdate();

    // property 'RemainAfterExit'

    /**
     * The method onRemainAfterExitGet() is called by ASF when a client
     * invokes the read method for the property 'RemainAfterExit'. The
     * onRemainAfterExitGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RemainAfterExit'</b>:
     *
     * RemainAfterExit
     */
    virtual void onRemainAfterExitGet(const ::boost::shared_ptr< RemainAfterExitGet >& payload);

    /**
     * Sends back the update to a previous onRemainAfterExitGet().
     *
     * <b>Documentation of 'RemainAfterExit'</b>:
     *
     * RemainAfterExit
     *
     * @param act Identifies a previous invocation of onRemainAfterExitGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRemainAfterExitGetUpdate(bool remainAfterExit, act_t act = 0);

    /**
     * Set the value of the property 'RemainAfterExit' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RemainAfterExit'</b>:
     *
     * RemainAfterExit
     */
    void setRemainAfterExit(bool remainAfterExit);

    /**
     * Returns the current value of the property 'RemainAfterExit'.
     *
     * <b>Documentation of 'RemainAfterExit'</b>:
     *
     * RemainAfterExit
     */
    bool getRemainAfterExit() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRemainAfterExitUpdate().
     *
     * <b>Documentation of 'RemainAfterExit'</b>:
     *
     * RemainAfterExit
     */
    void sendRemainAfterExitUpdate();

    // property 'GuessMainPID'

    /**
     * The method onGuessMainPIDGet() is called by ASF when a client invokes
     * the read method for the property 'GuessMainPID'. The
     * onGuessMainPIDGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'GuessMainPID'</b>:
     *
     * GuessMainPID
     */
    virtual void onGuessMainPIDGet(const ::boost::shared_ptr< GuessMainPIDGet >& payload);

    /**
     * Sends back the update to a previous onGuessMainPIDGet().
     *
     * <b>Documentation of 'GuessMainPID'</b>:
     *
     * GuessMainPID
     *
     * @param act Identifies a previous invocation of onGuessMainPIDGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGuessMainPIDGetUpdate(bool guessMainPID, act_t act = 0);

    /**
     * Set the value of the property 'GuessMainPID' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'GuessMainPID'</b>:
     *
     * GuessMainPID
     */
    void setGuessMainPID(bool guessMainPID);

    /**
     * Returns the current value of the property 'GuessMainPID'.
     *
     * <b>Documentation of 'GuessMainPID'</b>:
     *
     * GuessMainPID
     */
    bool getGuessMainPID() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendGuessMainPIDUpdate().
     *
     * <b>Documentation of 'GuessMainPID'</b>:
     *
     * GuessMainPID
     */
    void sendGuessMainPIDUpdate();

    // property 'MainPID'

    /**
     * The method onMainPIDGet() is called by ASF when a client invokes the
     * read method for the property 'MainPID'. The onMainPIDGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'MainPID'</b>:
     *
     * MainPID
     */
    virtual void onMainPIDGet(const ::boost::shared_ptr< MainPIDGet >& payload);

    /**
     * Sends back the update to a previous onMainPIDGet().
     *
     * <b>Documentation of 'MainPID'</b>:
     *
     * MainPID
     *
     * @param act Identifies a previous invocation of onMainPIDGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendMainPIDGetUpdate(uint32 mainPID, act_t act = 0);

    /**
     * Set the value of the property 'MainPID' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'MainPID'</b>:
     *
     * MainPID
     */
    void setMainPID(uint32 mainPID);

    /**
     * Returns the current value of the property 'MainPID'.
     *
     * <b>Documentation of 'MainPID'</b>:
     *
     * MainPID
     */
    uint32 getMainPID() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMainPIDUpdate().
     *
     * <b>Documentation of 'MainPID'</b>:
     *
     * MainPID
     */
    void sendMainPIDUpdate();

    // property 'ControlPID'

    /**
     * The method onControlPIDGet() is called by ASF when a client invokes the
     * read method for the property 'ControlPID'. The onControlPIDGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'ControlPID'</b>:
     *
     * ControlPID
     */
    virtual void onControlPIDGet(const ::boost::shared_ptr< ControlPIDGet >& payload);

    /**
     * Sends back the update to a previous onControlPIDGet().
     *
     * <b>Documentation of 'ControlPID'</b>:
     *
     * ControlPID
     *
     * @param act Identifies a previous invocation of onControlPIDGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendControlPIDGetUpdate(uint32 controlPID, act_t act = 0);

    /**
     * Set the value of the property 'ControlPID' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ControlPID'</b>:
     *
     * ControlPID
     */
    void setControlPID(uint32 controlPID);

    /**
     * Returns the current value of the property 'ControlPID'.
     *
     * <b>Documentation of 'ControlPID'</b>:
     *
     * ControlPID
     */
    uint32 getControlPID() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendControlPIDUpdate().
     *
     * <b>Documentation of 'ControlPID'</b>:
     *
     * ControlPID
     */
    void sendControlPIDUpdate();

    // property 'BusName'

    /**
     * The method onBusNameGet() is called by ASF when a client invokes the
     * read method for the property 'BusName'. The onBusNameGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'BusName'</b>:
     *
     * BusName
     */
    virtual void onBusNameGet(const ::boost::shared_ptr< BusNameGet >& payload);

    /**
     * Sends back the update to a previous onBusNameGet().
     *
     * <b>Documentation of 'BusName'</b>:
     *
     * BusName
     *
     * @param act Identifies a previous invocation of onBusNameGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendBusNameGetUpdate(const ::std::string& busName, act_t act = 0);

    /**
     * Set the value of the property 'BusName' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'BusName'</b>:
     *
     * BusName
     */
    void setBusName(const ::std::string& busName);

    /**
     * Returns the current value of the property 'BusName'.
     *
     * <b>Documentation of 'BusName'</b>:
     *
     * BusName
     */
    const ::std::string& getBusName() const;

    /**
     * Returns the current value of the property 'BusName' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendBusNameUpdate() method.
     *
     * <b>Documentation of 'BusName'</b>:
     *
     * BusName
     */
    ::std::string& getBusNameMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBusNameUpdate().
     *
     * <b>Documentation of 'BusName'</b>:
     *
     * BusName
     */
    void sendBusNameUpdate();

    // property 'FileDescriptorStoreMax'

    /**
     * The method onFileDescriptorStoreMaxGet() is called by ASF when a client
     * invokes the read method for the property 'FileDescriptorStoreMax'. The
     * onFileDescriptorStoreMaxGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'FileDescriptorStoreMax'</b>:
     *
     * FileDescriptorStoreMax
     */
    virtual void onFileDescriptorStoreMaxGet(const ::boost::shared_ptr< FileDescriptorStoreMaxGet >& payload);

    /**
     * Sends back the update to a previous onFileDescriptorStoreMaxGet().
     *
     * <b>Documentation of 'FileDescriptorStoreMax'</b>:
     *
     * FileDescriptorStoreMax
     *
     * @param act Identifies a previous invocation of
     * onFileDescriptorStoreMaxGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFileDescriptorStoreMaxGetUpdate(uint32 fileDescriptorStoreMax, act_t act = 0);

    /**
     * Set the value of the property 'FileDescriptorStoreMax' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'FileDescriptorStoreMax'</b>:
     *
     * FileDescriptorStoreMax
     */
    void setFileDescriptorStoreMax(uint32 fileDescriptorStoreMax);

    /**
     * Returns the current value of the property 'FileDescriptorStoreMax'.
     *
     * <b>Documentation of 'FileDescriptorStoreMax'</b>:
     *
     * FileDescriptorStoreMax
     */
    uint32 getFileDescriptorStoreMax() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFileDescriptorStoreMaxUpdate().
     *
     * <b>Documentation of 'FileDescriptorStoreMax'</b>:
     *
     * FileDescriptorStoreMax
     */
    void sendFileDescriptorStoreMaxUpdate();

    // property 'StatusText'

    /**
     * The method onStatusTextGet() is called by ASF when a client invokes the
     * read method for the property 'StatusText'. The onStatusTextGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'StatusText'</b>:
     *
     * StatusText
     */
    virtual void onStatusTextGet(const ::boost::shared_ptr< StatusTextGet >& payload);

    /**
     * Sends back the update to a previous onStatusTextGet().
     *
     * <b>Documentation of 'StatusText'</b>:
     *
     * StatusText
     *
     * @param act Identifies a previous invocation of onStatusTextGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStatusTextGetUpdate(const ::std::string& statusText, act_t act = 0);

    /**
     * Set the value of the property 'StatusText' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StatusText'</b>:
     *
     * StatusText
     */
    void setStatusText(const ::std::string& statusText);

    /**
     * Returns the current value of the property 'StatusText'.
     *
     * <b>Documentation of 'StatusText'</b>:
     *
     * StatusText
     */
    const ::std::string& getStatusText() const;

    /**
     * Returns the current value of the property 'StatusText' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendStatusTextUpdate() method.
     *
     * <b>Documentation of 'StatusText'</b>:
     *
     * StatusText
     */
    ::std::string& getStatusTextMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStatusTextUpdate().
     *
     * <b>Documentation of 'StatusText'</b>:
     *
     * StatusText
     */
    void sendStatusTextUpdate();

    // property 'StatusErrno'

    /**
     * The method onStatusErrnoGet() is called by ASF when a client invokes
     * the read method for the property 'StatusErrno'. The onStatusErrnoGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'StatusErrno'</b>:
     *
     * StatusErrno
     */
    virtual void onStatusErrnoGet(const ::boost::shared_ptr< StatusErrnoGet >& payload);

    /**
     * Sends back the update to a previous onStatusErrnoGet().
     *
     * <b>Documentation of 'StatusErrno'</b>:
     *
     * StatusErrno
     *
     * @param act Identifies a previous invocation of onStatusErrnoGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStatusErrnoGetUpdate(int32 statusErrno, act_t act = 0);

    /**
     * Set the value of the property 'StatusErrno' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StatusErrno'</b>:
     *
     * StatusErrno
     */
    void setStatusErrno(int32 statusErrno);

    /**
     * Returns the current value of the property 'StatusErrno'.
     *
     * <b>Documentation of 'StatusErrno'</b>:
     *
     * StatusErrno
     */
    int32 getStatusErrno() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStatusErrnoUpdate().
     *
     * <b>Documentation of 'StatusErrno'</b>:
     *
     * StatusErrno
     */
    void sendStatusErrnoUpdate();

    // property 'Result'

    /**
     * The method onResultGet() is called by ASF when a client invokes the
     * read method for the property 'Result'. The onResultGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Result'</b>:
     *
     * Result
     */
    virtual void onResultGet(const ::boost::shared_ptr< ResultGet >& payload);

    /**
     * Sends back the update to a previous onResultGet().
     *
     * <b>Documentation of 'Result'</b>:
     *
     * Result
     *
     * @param act Identifies a previous invocation of onResultGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendResultGetUpdate(const ::std::string& result, act_t act = 0);

    /**
     * Set the value of the property 'Result' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Result'</b>:
     *
     * Result
     */
    void setResult(const ::std::string& result);

    /**
     * Returns the current value of the property 'Result'.
     *
     * <b>Documentation of 'Result'</b>:
     *
     * Result
     */
    const ::std::string& getResult() const;

    /**
     * Returns the current value of the property 'Result' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendResultUpdate() method.
     *
     * <b>Documentation of 'Result'</b>:
     *
     * Result
     */
    ::std::string& getResultMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendResultUpdate().
     *
     * <b>Documentation of 'Result'</b>:
     *
     * Result
     */
    void sendResultUpdate();

    // property 'ExecMainStartTimestamp'

    /**
     * The method onExecMainStartTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'ExecMainStartTimestamp'. The
     * onExecMainStartTimestampGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ExecMainStartTimestamp'</b>:
     *
     * ExecMainStartTimestamp
     */
    virtual void onExecMainStartTimestampGet(const ::boost::shared_ptr< ExecMainStartTimestampGet >& payload);

    /**
     * Sends back the update to a previous onExecMainStartTimestampGet().
     *
     * <b>Documentation of 'ExecMainStartTimestamp'</b>:
     *
     * ExecMainStartTimestamp
     *
     * @param act Identifies a previous invocation of
     * onExecMainStartTimestampGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendExecMainStartTimestampGetUpdate(uint64 execMainStartTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'ExecMainStartTimestamp' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'ExecMainStartTimestamp'</b>:
     *
     * ExecMainStartTimestamp
     */
    void setExecMainStartTimestamp(uint64 execMainStartTimestamp);

    /**
     * Returns the current value of the property 'ExecMainStartTimestamp'.
     *
     * <b>Documentation of 'ExecMainStartTimestamp'</b>:
     *
     * ExecMainStartTimestamp
     */
    uint64 getExecMainStartTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecMainStartTimestampUpdate().
     *
     * <b>Documentation of 'ExecMainStartTimestamp'</b>:
     *
     * ExecMainStartTimestamp
     */
    void sendExecMainStartTimestampUpdate();

    // property 'ExecMainStartTimestampMonotonic'

    /**
     * The method onExecMainStartTimestampMonotonicGet() is called by ASF when
     * a client invokes the read method for the property
     * 'ExecMainStartTimestampMonotonic'. The
     * onExecMainStartTimestampMonotonicGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'ExecMainStartTimestampMonotonic'</b>:
     *
     * ExecMainStartTimestampMonotonic
     */
    virtual void onExecMainStartTimestampMonotonicGet(const ::boost::shared_ptr< ExecMainStartTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous
     * onExecMainStartTimestampMonotonicGet().
     *
     * <b>Documentation of 'ExecMainStartTimestampMonotonic'</b>:
     *
     * ExecMainStartTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onExecMainStartTimestampMonotonicGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendExecMainStartTimestampMonotonicGetUpdate(uint64 execMainStartTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'ExecMainStartTimestampMonotonic' and
     * send updates to registered clients. No updates will be sent if the
     * property value does not change.
     *
     * <b>Documentation of 'ExecMainStartTimestampMonotonic'</b>:
     *
     * ExecMainStartTimestampMonotonic
     */
    void setExecMainStartTimestampMonotonic(uint64 execMainStartTimestampMonotonic);

    /**
     * Returns the current value of the property 'ExecMainStartTimestampMonotonic'.
     *
     * <b>Documentation of 'ExecMainStartTimestampMonotonic'</b>:
     *
     * ExecMainStartTimestampMonotonic
     */
    uint64 getExecMainStartTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecMainStartTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'ExecMainStartTimestampMonotonic'</b>:
     *
     * ExecMainStartTimestampMonotonic
     */
    void sendExecMainStartTimestampMonotonicUpdate();

    // property 'ExecMainExitTimestamp'

    /**
     * The method onExecMainExitTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'ExecMainExitTimestamp'. The
     * onExecMainExitTimestampGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ExecMainExitTimestamp'</b>:
     *
     * ExecMainExitTimestamp
     */
    virtual void onExecMainExitTimestampGet(const ::boost::shared_ptr< ExecMainExitTimestampGet >& payload);

    /**
     * Sends back the update to a previous onExecMainExitTimestampGet().
     *
     * <b>Documentation of 'ExecMainExitTimestamp'</b>:
     *
     * ExecMainExitTimestamp
     *
     * @param act Identifies a previous invocation of
     * onExecMainExitTimestampGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendExecMainExitTimestampGetUpdate(uint64 execMainExitTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'ExecMainExitTimestamp' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'ExecMainExitTimestamp'</b>:
     *
     * ExecMainExitTimestamp
     */
    void setExecMainExitTimestamp(uint64 execMainExitTimestamp);

    /**
     * Returns the current value of the property 'ExecMainExitTimestamp'.
     *
     * <b>Documentation of 'ExecMainExitTimestamp'</b>:
     *
     * ExecMainExitTimestamp
     */
    uint64 getExecMainExitTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecMainExitTimestampUpdate().
     *
     * <b>Documentation of 'ExecMainExitTimestamp'</b>:
     *
     * ExecMainExitTimestamp
     */
    void sendExecMainExitTimestampUpdate();

    // property 'ExecMainExitTimestampMonotonic'

    /**
     * The method onExecMainExitTimestampMonotonicGet() is called by ASF when
     * a client invokes the read method for the property
     * 'ExecMainExitTimestampMonotonic'. The
     * onExecMainExitTimestampMonotonicGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'ExecMainExitTimestampMonotonic'</b>:
     *
     * ExecMainExitTimestampMonotonic
     */
    virtual void onExecMainExitTimestampMonotonicGet(const ::boost::shared_ptr< ExecMainExitTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous
     * onExecMainExitTimestampMonotonicGet().
     *
     * <b>Documentation of 'ExecMainExitTimestampMonotonic'</b>:
     *
     * ExecMainExitTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onExecMainExitTimestampMonotonicGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendExecMainExitTimestampMonotonicGetUpdate(uint64 execMainExitTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'ExecMainExitTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'ExecMainExitTimestampMonotonic'</b>:
     *
     * ExecMainExitTimestampMonotonic
     */
    void setExecMainExitTimestampMonotonic(uint64 execMainExitTimestampMonotonic);

    /**
     * Returns the current value of the property 'ExecMainExitTimestampMonotonic'.
     *
     * <b>Documentation of 'ExecMainExitTimestampMonotonic'</b>:
     *
     * ExecMainExitTimestampMonotonic
     */
    uint64 getExecMainExitTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecMainExitTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'ExecMainExitTimestampMonotonic'</b>:
     *
     * ExecMainExitTimestampMonotonic
     */
    void sendExecMainExitTimestampMonotonicUpdate();

    // property 'ExecMainPID'

    /**
     * The method onExecMainPIDGet() is called by ASF when a client invokes
     * the read method for the property 'ExecMainPID'. The onExecMainPIDGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'ExecMainPID'</b>:
     *
     * ExecMainPID contains the PID of the main process of the service as far as it is known.
     *       And ExecMainPID contains information collected from the last run even if the process is no longer around.
     */
    virtual void onExecMainPIDGet(const ::boost::shared_ptr< ExecMainPIDGet >& payload);

    /**
     * Sends back the update to a previous onExecMainPIDGet().
     *
     * <b>Documentation of 'ExecMainPID'</b>:
     *
     * ExecMainPID contains the PID of the main process of the service as far as it is known.
     *       And ExecMainPID contains information collected from the last run even if the process is no longer around.
     *
     * @param act Identifies a previous invocation of onExecMainPIDGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendExecMainPIDGetUpdate(uint32 execMainPID, act_t act = 0);

    /**
     * Set the value of the property 'ExecMainPID' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ExecMainPID'</b>:
     *
     * ExecMainPID contains the PID of the main process of the service as far as it is known.
     *       And ExecMainPID contains information collected from the last run even if the process is no longer around.
     */
    void setExecMainPID(uint32 execMainPID);

    /**
     * Returns the current value of the property 'ExecMainPID'.
     *
     * <b>Documentation of 'ExecMainPID'</b>:
     *
     * ExecMainPID contains the PID of the main process of the service as far as it is known.
     *       And ExecMainPID contains information collected from the last run even if the process is no longer around.
     */
    uint32 getExecMainPID() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecMainPIDUpdate().
     *
     * <b>Documentation of 'ExecMainPID'</b>:
     *
     * ExecMainPID contains the PID of the main process of the service as far as it is known.
     *       And ExecMainPID contains information collected from the last run even if the process is no longer around.
     */
    void sendExecMainPIDUpdate();

    // property 'ExecMainCode'

    /**
     * The method onExecMainCodeGet() is called by ASF when a client invokes
     * the read method for the property 'ExecMainCode'. The
     * onExecMainCodeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ExecMainCode'</b>:
     *
     * ExecMainCode
     */
    virtual void onExecMainCodeGet(const ::boost::shared_ptr< ExecMainCodeGet >& payload);

    /**
     * Sends back the update to a previous onExecMainCodeGet().
     *
     * <b>Documentation of 'ExecMainCode'</b>:
     *
     * ExecMainCode
     *
     * @param act Identifies a previous invocation of onExecMainCodeGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendExecMainCodeGetUpdate(int32 execMainCode, act_t act = 0);

    /**
     * Set the value of the property 'ExecMainCode' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ExecMainCode'</b>:
     *
     * ExecMainCode
     */
    void setExecMainCode(int32 execMainCode);

    /**
     * Returns the current value of the property 'ExecMainCode'.
     *
     * <b>Documentation of 'ExecMainCode'</b>:
     *
     * ExecMainCode
     */
    int32 getExecMainCode() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecMainCodeUpdate().
     *
     * <b>Documentation of 'ExecMainCode'</b>:
     *
     * ExecMainCode
     */
    void sendExecMainCodeUpdate();

    // property 'ExecMainStatus'

    /**
     * The method onExecMainStatusGet() is called by ASF when a client invokes
     * the read method for the property 'ExecMainStatus'. The
     * onExecMainStatusGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ExecMainStatus'</b>:
     *
     * ExecMainStatus
     */
    virtual void onExecMainStatusGet(const ::boost::shared_ptr< ExecMainStatusGet >& payload);

    /**
     * Sends back the update to a previous onExecMainStatusGet().
     *
     * <b>Documentation of 'ExecMainStatus'</b>:
     *
     * ExecMainStatus
     *
     * @param act Identifies a previous invocation of onExecMainStatusGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendExecMainStatusGetUpdate(int32 execMainStatus, act_t act = 0);

    /**
     * Set the value of the property 'ExecMainStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ExecMainStatus'</b>:
     *
     * ExecMainStatus
     */
    void setExecMainStatus(int32 execMainStatus);

    /**
     * Returns the current value of the property 'ExecMainStatus'.
     *
     * <b>Documentation of 'ExecMainStatus'</b>:
     *
     * ExecMainStatus
     */
    int32 getExecMainStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecMainStatusUpdate().
     *
     * <b>Documentation of 'ExecMainStatus'</b>:
     *
     * ExecMainStatus
     */
    void sendExecMainStatusUpdate();

    // property 'ExecStartPre'

    /**
     * The method onExecStartPreGet() is called by ASF when a client invokes
     * the read method for the property 'ExecStartPre'. The
     * onExecStartPreGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ExecStartPre'</b>:
     *
     * ExecStartPre
     */
    virtual void onExecStartPreGet(const ::boost::shared_ptr< ExecStartPreGet >& payload);

    /**
     * Sends back the update to a previous onExecStartPreGet().
     *
     * <b>Documentation of 'ExecStartPre'</b>:
     *
     * ExecStartPre
     *
     * @param act Identifies a previous invocation of onExecStartPreGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendExecStartPreGetUpdate(const ::std::vector< execData >& execStartPre, act_t act = 0);

    /**
     * Set the value of the property 'ExecStartPre' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ExecStartPre'</b>:
     *
     * ExecStartPre
     */
    void setExecStartPre(const ::std::vector< execData >& execStartPre);

    /**
     * Returns the current value of the property 'ExecStartPre'.
     *
     * <b>Documentation of 'ExecStartPre'</b>:
     *
     * ExecStartPre
     */
    const ::std::vector< execData >& getExecStartPre() const;

    /**
     * Returns the current value of the property 'ExecStartPre' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendExecStartPreUpdate() method.
     *
     * <b>Documentation of 'ExecStartPre'</b>:
     *
     * ExecStartPre
     */
    ::std::vector< execData >& getExecStartPreMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecStartPreUpdate().
     *
     * <b>Documentation of 'ExecStartPre'</b>:
     *
     * ExecStartPre
     */
    void sendExecStartPreUpdate();

    // property 'ExecStart'

    /**
     * The method onExecStartGet() is called by ASF when a client invokes the
     * read method for the property 'ExecStart'. The onExecStartGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'ExecStart'</b>:
     *
     * ExecStart
     */
    virtual void onExecStartGet(const ::boost::shared_ptr< ExecStartGet >& payload);

    /**
     * Sends back the update to a previous onExecStartGet().
     *
     * <b>Documentation of 'ExecStart'</b>:
     *
     * ExecStart
     *
     * @param act Identifies a previous invocation of onExecStartGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendExecStartGetUpdate(const ::std::vector< execData >& execStart, act_t act = 0);

    /**
     * Set the value of the property 'ExecStart' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ExecStart'</b>:
     *
     * ExecStart
     */
    void setExecStart(const ::std::vector< execData >& execStart);

    /**
     * Returns the current value of the property 'ExecStart'.
     *
     * <b>Documentation of 'ExecStart'</b>:
     *
     * ExecStart
     */
    const ::std::vector< execData >& getExecStart() const;

    /**
     * Returns the current value of the property 'ExecStart' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendExecStartUpdate() method.
     *
     * <b>Documentation of 'ExecStart'</b>:
     *
     * ExecStart
     */
    ::std::vector< execData >& getExecStartMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecStartUpdate().
     *
     * <b>Documentation of 'ExecStart'</b>:
     *
     * ExecStart
     */
    void sendExecStartUpdate();

    // property 'ExecStartPost'

    /**
     * The method onExecStartPostGet() is called by ASF when a client invokes
     * the read method for the property 'ExecStartPost'. The
     * onExecStartPostGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ExecStartPost'</b>:
     *
     * ExecStartPost
     */
    virtual void onExecStartPostGet(const ::boost::shared_ptr< ExecStartPostGet >& payload);

    /**
     * Sends back the update to a previous onExecStartPostGet().
     *
     * <b>Documentation of 'ExecStartPost'</b>:
     *
     * ExecStartPost
     *
     * @param act Identifies a previous invocation of onExecStartPostGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendExecStartPostGetUpdate(const ::std::vector< execData >& execStartPost, act_t act = 0);

    /**
     * Set the value of the property 'ExecStartPost' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ExecStartPost'</b>:
     *
     * ExecStartPost
     */
    void setExecStartPost(const ::std::vector< execData >& execStartPost);

    /**
     * Returns the current value of the property 'ExecStartPost'.
     *
     * <b>Documentation of 'ExecStartPost'</b>:
     *
     * ExecStartPost
     */
    const ::std::vector< execData >& getExecStartPost() const;

    /**
     * Returns the current value of the property 'ExecStartPost' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendExecStartPostUpdate() method.
     *
     * <b>Documentation of 'ExecStartPost'</b>:
     *
     * ExecStartPost
     */
    ::std::vector< execData >& getExecStartPostMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecStartPostUpdate().
     *
     * <b>Documentation of 'ExecStartPost'</b>:
     *
     * ExecStartPost
     */
    void sendExecStartPostUpdate();

    // property 'ExecReload'

    /**
     * The method onExecReloadGet() is called by ASF when a client invokes the
     * read method for the property 'ExecReload'. The onExecReloadGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'ExecReload'</b>:
     *
     * ExecReload
     */
    virtual void onExecReloadGet(const ::boost::shared_ptr< ExecReloadGet >& payload);

    /**
     * Sends back the update to a previous onExecReloadGet().
     *
     * <b>Documentation of 'ExecReload'</b>:
     *
     * ExecReload
     *
     * @param act Identifies a previous invocation of onExecReloadGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendExecReloadGetUpdate(const ::std::vector< execData >& execReload, act_t act = 0);

    /**
     * Set the value of the property 'ExecReload' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ExecReload'</b>:
     *
     * ExecReload
     */
    void setExecReload(const ::std::vector< execData >& execReload);

    /**
     * Returns the current value of the property 'ExecReload'.
     *
     * <b>Documentation of 'ExecReload'</b>:
     *
     * ExecReload
     */
    const ::std::vector< execData >& getExecReload() const;

    /**
     * Returns the current value of the property 'ExecReload' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendExecReloadUpdate() method.
     *
     * <b>Documentation of 'ExecReload'</b>:
     *
     * ExecReload
     */
    ::std::vector< execData >& getExecReloadMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecReloadUpdate().
     *
     * <b>Documentation of 'ExecReload'</b>:
     *
     * ExecReload
     */
    void sendExecReloadUpdate();

    // property 'ExecStop'

    /**
     * The method onExecStopGet() is called by ASF when a client invokes the
     * read method for the property 'ExecStop'. The onExecStopGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'ExecStop'</b>:
     *
     * ExecStop
     */
    virtual void onExecStopGet(const ::boost::shared_ptr< ExecStopGet >& payload);

    /**
     * Sends back the update to a previous onExecStopGet().
     *
     * <b>Documentation of 'ExecStop'</b>:
     *
     * ExecStop
     *
     * @param act Identifies a previous invocation of onExecStopGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendExecStopGetUpdate(const ::std::vector< execData >& execStop, act_t act = 0);

    /**
     * Set the value of the property 'ExecStop' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'ExecStop'</b>:
     *
     * ExecStop
     */
    void setExecStop(const ::std::vector< execData >& execStop);

    /**
     * Returns the current value of the property 'ExecStop'.
     *
     * <b>Documentation of 'ExecStop'</b>:
     *
     * ExecStop
     */
    const ::std::vector< execData >& getExecStop() const;

    /**
     * Returns the current value of the property 'ExecStop' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendExecStopUpdate() method.
     *
     * <b>Documentation of 'ExecStop'</b>:
     *
     * ExecStop
     */
    ::std::vector< execData >& getExecStopMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecStopUpdate().
     *
     * <b>Documentation of 'ExecStop'</b>:
     *
     * ExecStop
     */
    void sendExecStopUpdate();

    // property 'ExecStopPost'

    /**
     * The method onExecStopPostGet() is called by ASF when a client invokes
     * the read method for the property 'ExecStopPost'. The
     * onExecStopPostGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ExecStopPost'</b>:
     *
     * ExecStopPost
     */
    virtual void onExecStopPostGet(const ::boost::shared_ptr< ExecStopPostGet >& payload);

    /**
     * Sends back the update to a previous onExecStopPostGet().
     *
     * <b>Documentation of 'ExecStopPost'</b>:
     *
     * ExecStopPost
     *
     * @param act Identifies a previous invocation of onExecStopPostGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendExecStopPostGetUpdate(const ::std::vector< execData >& execStopPost, act_t act = 0);

    /**
     * Set the value of the property 'ExecStopPost' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ExecStopPost'</b>:
     *
     * ExecStopPost
     */
    void setExecStopPost(const ::std::vector< execData >& execStopPost);

    /**
     * Returns the current value of the property 'ExecStopPost'.
     *
     * <b>Documentation of 'ExecStopPost'</b>:
     *
     * ExecStopPost
     */
    const ::std::vector< execData >& getExecStopPost() const;

    /**
     * Returns the current value of the property 'ExecStopPost' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendExecStopPostUpdate() method.
     *
     * <b>Documentation of 'ExecStopPost'</b>:
     *
     * ExecStopPost
     */
    ::std::vector< execData >& getExecStopPostMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExecStopPostUpdate().
     *
     * <b>Documentation of 'ExecStopPost'</b>:
     *
     * ExecStopPost
     */
    void sendExecStopPostUpdate();

    // property 'Slice'

    /**
     * The method onSliceGet() is called by ASF when a client invokes the read
     * method for the property 'Slice'. The onSliceGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Slice'</b>:
     *
     * Slice
     */
    virtual void onSliceGet(const ::boost::shared_ptr< SliceGet >& payload);

    /**
     * Sends back the update to a previous onSliceGet().
     *
     * <b>Documentation of 'Slice'</b>:
     *
     * Slice
     *
     * @param act Identifies a previous invocation of onSliceGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSliceGetUpdate(const ::std::string& slice, act_t act = 0);

    /**
     * Set the value of the property 'Slice' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Slice'</b>:
     *
     * Slice
     */
    void setSlice(const ::std::string& slice);

    /**
     * Returns the current value of the property 'Slice'.
     *
     * <b>Documentation of 'Slice'</b>:
     *
     * Slice
     */
    const ::std::string& getSlice() const;

    /**
     * Returns the current value of the property 'Slice' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSliceUpdate() method.
     *
     * <b>Documentation of 'Slice'</b>:
     *
     * Slice
     */
    ::std::string& getSliceMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSliceUpdate().
     *
     * <b>Documentation of 'Slice'</b>:
     *
     * Slice
     */
    void sendSliceUpdate();

    // property 'ControlGroup'

    /**
     * The method onControlGroupGet() is called by ASF when a client invokes
     * the read method for the property 'ControlGroup'. The
     * onControlGroupGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     */
    virtual void onControlGroupGet(const ::boost::shared_ptr< ControlGroupGet >& payload);

    /**
     * Sends back the update to a previous onControlGroupGet().
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     *
     * @param act Identifies a previous invocation of onControlGroupGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendControlGroupGetUpdate(const ::std::string& controlGroup, act_t act = 0);

    /**
     * Set the value of the property 'ControlGroup' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     */
    void setControlGroup(const ::std::string& controlGroup);

    /**
     * Returns the current value of the property 'ControlGroup'.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     */
    const ::std::string& getControlGroup() const;

    /**
     * Returns the current value of the property 'ControlGroup' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendControlGroupUpdate() method.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     */
    ::std::string& getControlGroupMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendControlGroupUpdate().
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     */
    void sendControlGroupUpdate();

    // property 'MemoryCurrent'

    /**
     * The method onMemoryCurrentGet() is called by ASF when a client invokes
     * the read method for the property 'MemoryCurrent'. The
     * onMemoryCurrentGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'MemoryCurrent'</b>:
     *
     * MemoryCurrent
     */
    virtual void onMemoryCurrentGet(const ::boost::shared_ptr< MemoryCurrentGet >& payload);

    /**
     * Sends back the update to a previous onMemoryCurrentGet().
     *
     * <b>Documentation of 'MemoryCurrent'</b>:
     *
     * MemoryCurrent
     *
     * @param act Identifies a previous invocation of onMemoryCurrentGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMemoryCurrentGetUpdate(uint64 memoryCurrent, act_t act = 0);

    /**
     * Set the value of the property 'MemoryCurrent' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'MemoryCurrent'</b>:
     *
     * MemoryCurrent
     */
    void setMemoryCurrent(uint64 memoryCurrent);

    /**
     * Returns the current value of the property 'MemoryCurrent'.
     *
     * <b>Documentation of 'MemoryCurrent'</b>:
     *
     * MemoryCurrent
     */
    uint64 getMemoryCurrent() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMemoryCurrentUpdate().
     *
     * <b>Documentation of 'MemoryCurrent'</b>:
     *
     * MemoryCurrent
     */
    void sendMemoryCurrentUpdate();

    // property 'CPUUsageNSec'

    /**
     * The method onCPUUsageNSecGet() is called by ASF when a client invokes
     * the read method for the property 'CPUUsageNSec'. The
     * onCPUUsageNSecGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'CPUUsageNSec'</b>:
     *
     * CPUUsageNSec
     */
    virtual void onCPUUsageNSecGet(const ::boost::shared_ptr< CPUUsageNSecGet >& payload);

    /**
     * Sends back the update to a previous onCPUUsageNSecGet().
     *
     * <b>Documentation of 'CPUUsageNSec'</b>:
     *
     * CPUUsageNSec
     *
     * @param act Identifies a previous invocation of onCPUUsageNSecGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCPUUsageNSecGetUpdate(uint64 cPUUsageNSec, act_t act = 0);

    /**
     * Set the value of the property 'CPUUsageNSec' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CPUUsageNSec'</b>:
     *
     * CPUUsageNSec
     */
    void setCPUUsageNSec(uint64 cPUUsageNSec);

    /**
     * Returns the current value of the property 'CPUUsageNSec'.
     *
     * <b>Documentation of 'CPUUsageNSec'</b>:
     *
     * CPUUsageNSec
     */
    uint64 getCPUUsageNSec() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCPUUsageNSecUpdate().
     *
     * <b>Documentation of 'CPUUsageNSec'</b>:
     *
     * CPUUsageNSec
     */
    void sendCPUUsageNSecUpdate();

    // property 'Delegate'

    /**
     * The method onDelegateGet() is called by ASF when a client invokes the
     * read method for the property 'Delegate'. The onDelegateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Delegate'</b>:
     *
     * Delegate
     */
    virtual void onDelegateGet(const ::boost::shared_ptr< DelegateGet >& payload);

    /**
     * Sends back the update to a previous onDelegateGet().
     *
     * <b>Documentation of 'Delegate'</b>:
     *
     * Delegate
     *
     * @param act Identifies a previous invocation of onDelegateGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDelegateGetUpdate(bool delegate, act_t act = 0);

    /**
     * Set the value of the property 'Delegate' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Delegate'</b>:
     *
     * Delegate
     */
    void setDelegate(bool delegate);

    /**
     * Returns the current value of the property 'Delegate'.
     *
     * <b>Documentation of 'Delegate'</b>:
     *
     * Delegate
     */
    bool getDelegate() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDelegateUpdate().
     *
     * <b>Documentation of 'Delegate'</b>:
     *
     * Delegate
     */
    void sendDelegateUpdate();

    // property 'CPUAccounting'

    /**
     * The method onCPUAccountingGet() is called by ASF when a client invokes
     * the read method for the property 'CPUAccounting'. The
     * onCPUAccountingGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'CPUAccounting'</b>:
     *
     * CPUAccounting
     */
    virtual void onCPUAccountingGet(const ::boost::shared_ptr< CPUAccountingGet >& payload);

    /**
     * Sends back the update to a previous onCPUAccountingGet().
     *
     * <b>Documentation of 'CPUAccounting'</b>:
     *
     * CPUAccounting
     *
     * @param act Identifies a previous invocation of onCPUAccountingGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCPUAccountingGetUpdate(bool cPUAccounting, act_t act = 0);

    /**
     * Set the value of the property 'CPUAccounting' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CPUAccounting'</b>:
     *
     * CPUAccounting
     */
    void setCPUAccounting(bool cPUAccounting);

    /**
     * Returns the current value of the property 'CPUAccounting'.
     *
     * <b>Documentation of 'CPUAccounting'</b>:
     *
     * CPUAccounting
     */
    bool getCPUAccounting() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCPUAccountingUpdate().
     *
     * <b>Documentation of 'CPUAccounting'</b>:
     *
     * CPUAccounting
     */
    void sendCPUAccountingUpdate();

    // property 'CPUShares'

    /**
     * The method onCPUSharesGet() is called by ASF when a client invokes the
     * read method for the property 'CPUShares'. The onCPUSharesGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'CPUShares'</b>:
     *
     * CPUShares
     */
    virtual void onCPUSharesGet(const ::boost::shared_ptr< CPUSharesGet >& payload);

    /**
     * Sends back the update to a previous onCPUSharesGet().
     *
     * <b>Documentation of 'CPUShares'</b>:
     *
     * CPUShares
     *
     * @param act Identifies a previous invocation of onCPUSharesGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCPUSharesGetUpdate(uint64 cPUShares, act_t act = 0);

    /**
     * Set the value of the property 'CPUShares' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CPUShares'</b>:
     *
     * CPUShares
     */
    void setCPUShares(uint64 cPUShares);

    /**
     * Returns the current value of the property 'CPUShares'.
     *
     * <b>Documentation of 'CPUShares'</b>:
     *
     * CPUShares
     */
    uint64 getCPUShares() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCPUSharesUpdate().
     *
     * <b>Documentation of 'CPUShares'</b>:
     *
     * CPUShares
     */
    void sendCPUSharesUpdate();

    // property 'StartupCPUShares'

    /**
     * The method onStartupCPUSharesGet() is called by ASF when a client
     * invokes the read method for the property 'StartupCPUShares'. The
     * onStartupCPUSharesGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'StartupCPUShares'</b>:
     *
     * StartupCPUShares
     */
    virtual void onStartupCPUSharesGet(const ::boost::shared_ptr< StartupCPUSharesGet >& payload);

    /**
     * Sends back the update to a previous onStartupCPUSharesGet().
     *
     * <b>Documentation of 'StartupCPUShares'</b>:
     *
     * StartupCPUShares
     *
     * @param act Identifies a previous invocation of onStartupCPUSharesGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartupCPUSharesGetUpdate(uint64 startupCPUShares, act_t act = 0);

    /**
     * Set the value of the property 'StartupCPUShares' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StartupCPUShares'</b>:
     *
     * StartupCPUShares
     */
    void setStartupCPUShares(uint64 startupCPUShares);

    /**
     * Returns the current value of the property 'StartupCPUShares'.
     *
     * <b>Documentation of 'StartupCPUShares'</b>:
     *
     * StartupCPUShares
     */
    uint64 getStartupCPUShares() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStartupCPUSharesUpdate().
     *
     * <b>Documentation of 'StartupCPUShares'</b>:
     *
     * StartupCPUShares
     */
    void sendStartupCPUSharesUpdate();

    // property 'CPUQuotaPerSecUSec'

    /**
     * The method onCPUQuotaPerSecUSecGet() is called by ASF when a client
     * invokes the read method for the property 'CPUQuotaPerSecUSec'. The
     * onCPUQuotaPerSecUSecGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'CPUQuotaPerSecUSec'</b>:
     *
     * CPUQuotaPerSecUSec
     */
    virtual void onCPUQuotaPerSecUSecGet(const ::boost::shared_ptr< CPUQuotaPerSecUSecGet >& payload);

    /**
     * Sends back the update to a previous onCPUQuotaPerSecUSecGet().
     *
     * <b>Documentation of 'CPUQuotaPerSecUSec'</b>:
     *
     * CPUQuotaPerSecUSec
     *
     * @param act Identifies a previous invocation of
     * onCPUQuotaPerSecUSecGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCPUQuotaPerSecUSecGetUpdate(uint64 cPUQuotaPerSecUSec, act_t act = 0);

    /**
     * Set the value of the property 'CPUQuotaPerSecUSec' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CPUQuotaPerSecUSec'</b>:
     *
     * CPUQuotaPerSecUSec
     */
    void setCPUQuotaPerSecUSec(uint64 cPUQuotaPerSecUSec);

    /**
     * Returns the current value of the property 'CPUQuotaPerSecUSec'.
     *
     * <b>Documentation of 'CPUQuotaPerSecUSec'</b>:
     *
     * CPUQuotaPerSecUSec
     */
    uint64 getCPUQuotaPerSecUSec() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCPUQuotaPerSecUSecUpdate().
     *
     * <b>Documentation of 'CPUQuotaPerSecUSec'</b>:
     *
     * CPUQuotaPerSecUSec
     */
    void sendCPUQuotaPerSecUSecUpdate();

    // property 'BlockIOAccounting'

    /**
     * The method onBlockIOAccountingGet() is called by ASF when a client
     * invokes the read method for the property 'BlockIOAccounting'. The
     * onBlockIOAccountingGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'BlockIOAccounting'</b>:
     *
     * BlockIOAccounting
     */
    virtual void onBlockIOAccountingGet(const ::boost::shared_ptr< BlockIOAccountingGet >& payload);

    /**
     * Sends back the update to a previous onBlockIOAccountingGet().
     *
     * <b>Documentation of 'BlockIOAccounting'</b>:
     *
     * BlockIOAccounting
     *
     * @param act Identifies a previous invocation of
     * onBlockIOAccountingGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBlockIOAccountingGetUpdate(bool blockIOAccounting, act_t act = 0);

    /**
     * Set the value of the property 'BlockIOAccounting' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'BlockIOAccounting'</b>:
     *
     * BlockIOAccounting
     */
    void setBlockIOAccounting(bool blockIOAccounting);

    /**
     * Returns the current value of the property 'BlockIOAccounting'.
     *
     * <b>Documentation of 'BlockIOAccounting'</b>:
     *
     * BlockIOAccounting
     */
    bool getBlockIOAccounting() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBlockIOAccountingUpdate().
     *
     * <b>Documentation of 'BlockIOAccounting'</b>:
     *
     * BlockIOAccounting
     */
    void sendBlockIOAccountingUpdate();

    // property 'BlockIOWeight'

    /**
     * The method onBlockIOWeightGet() is called by ASF when a client invokes
     * the read method for the property 'BlockIOWeight'. The
     * onBlockIOWeightGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'BlockIOWeight'</b>:
     *
     * BlockIOWeight
     */
    virtual void onBlockIOWeightGet(const ::boost::shared_ptr< BlockIOWeightGet >& payload);

    /**
     * Sends back the update to a previous onBlockIOWeightGet().
     *
     * <b>Documentation of 'BlockIOWeight'</b>:
     *
     * BlockIOWeight
     *
     * @param act Identifies a previous invocation of onBlockIOWeightGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendBlockIOWeightGetUpdate(uint64 blockIOWeight, act_t act = 0);

    /**
     * Set the value of the property 'BlockIOWeight' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'BlockIOWeight'</b>:
     *
     * BlockIOWeight
     */
    void setBlockIOWeight(uint64 blockIOWeight);

    /**
     * Returns the current value of the property 'BlockIOWeight'.
     *
     * <b>Documentation of 'BlockIOWeight'</b>:
     *
     * BlockIOWeight
     */
    uint64 getBlockIOWeight() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBlockIOWeightUpdate().
     *
     * <b>Documentation of 'BlockIOWeight'</b>:
     *
     * BlockIOWeight
     */
    void sendBlockIOWeightUpdate();

    // property 'StartupBlockIOWeight'

    /**
     * The method onStartupBlockIOWeightGet() is called by ASF when a client
     * invokes the read method for the property 'StartupBlockIOWeight'. The
     * onStartupBlockIOWeightGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'StartupBlockIOWeight'</b>:
     *
     * StartupBlockIOWeight
     */
    virtual void onStartupBlockIOWeightGet(const ::boost::shared_ptr< StartupBlockIOWeightGet >& payload);

    /**
     * Sends back the update to a previous onStartupBlockIOWeightGet().
     *
     * <b>Documentation of 'StartupBlockIOWeight'</b>:
     *
     * StartupBlockIOWeight
     *
     * @param act Identifies a previous invocation of
     * onStartupBlockIOWeightGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartupBlockIOWeightGetUpdate(uint64 startupBlockIOWeight, act_t act = 0);

    /**
     * Set the value of the property 'StartupBlockIOWeight' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'StartupBlockIOWeight'</b>:
     *
     * StartupBlockIOWeight
     */
    void setStartupBlockIOWeight(uint64 startupBlockIOWeight);

    /**
     * Returns the current value of the property 'StartupBlockIOWeight'.
     *
     * <b>Documentation of 'StartupBlockIOWeight'</b>:
     *
     * StartupBlockIOWeight
     */
    uint64 getStartupBlockIOWeight() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStartupBlockIOWeightUpdate().
     *
     * <b>Documentation of 'StartupBlockIOWeight'</b>:
     *
     * StartupBlockIOWeight
     */
    void sendStartupBlockIOWeightUpdate();

    // property 'BlockIODeviceWeight'

    /**
     * The method onBlockIODeviceWeightGet() is called by ASF when a client
     * invokes the read method for the property 'BlockIODeviceWeight'. The
     * onBlockIODeviceWeightGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'BlockIODeviceWeight'</b>:
     *
     * BlockIODeviceWeight
     */
    virtual void onBlockIODeviceWeightGet(const ::boost::shared_ptr< BlockIODeviceWeightGet >& payload);

    /**
     * Sends back the update to a previous onBlockIODeviceWeightGet().
     *
     * <b>Documentation of 'BlockIODeviceWeight'</b>:
     *
     * BlockIODeviceWeight
     *
     * @param act Identifies a previous invocation of
     * onBlockIODeviceWeightGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBlockIODeviceWeightGetUpdate(const ::std::vector< blockIOData >& blockIODeviceWeight, act_t act = 0);

    /**
     * Set the value of the property 'BlockIODeviceWeight' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'BlockIODeviceWeight'</b>:
     *
     * BlockIODeviceWeight
     */
    void setBlockIODeviceWeight(const ::std::vector< blockIOData >& blockIODeviceWeight);

    /**
     * Returns the current value of the property 'BlockIODeviceWeight'.
     *
     * <b>Documentation of 'BlockIODeviceWeight'</b>:
     *
     * BlockIODeviceWeight
     */
    const ::std::vector< blockIOData >& getBlockIODeviceWeight() const;

    /**
     * Returns the current value of the property 'BlockIODeviceWeight' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendBlockIODeviceWeightUpdate() method.
     *
     * <b>Documentation of 'BlockIODeviceWeight'</b>:
     *
     * BlockIODeviceWeight
     */
    ::std::vector< blockIOData >& getBlockIODeviceWeightMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBlockIODeviceWeightUpdate().
     *
     * <b>Documentation of 'BlockIODeviceWeight'</b>:
     *
     * BlockIODeviceWeight
     */
    void sendBlockIODeviceWeightUpdate();

    // property 'BlockIOReadBandwidth'

    /**
     * The method onBlockIOReadBandwidthGet() is called by ASF when a client
     * invokes the read method for the property 'BlockIOReadBandwidth'. The
     * onBlockIOReadBandwidthGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'BlockIOReadBandwidth'</b>:
     *
     * BlockIOReadBandwidth
     */
    virtual void onBlockIOReadBandwidthGet(const ::boost::shared_ptr< BlockIOReadBandwidthGet >& payload);

    /**
     * Sends back the update to a previous onBlockIOReadBandwidthGet().
     *
     * <b>Documentation of 'BlockIOReadBandwidth'</b>:
     *
     * BlockIOReadBandwidth
     *
     * @param act Identifies a previous invocation of
     * onBlockIOReadBandwidthGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBlockIOReadBandwidthGetUpdate(const ::std::vector< blockIOData >& blockIOReadBandwidth, act_t act = 0);

    /**
     * Set the value of the property 'BlockIOReadBandwidth' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'BlockIOReadBandwidth'</b>:
     *
     * BlockIOReadBandwidth
     */
    void setBlockIOReadBandwidth(const ::std::vector< blockIOData >& blockIOReadBandwidth);

    /**
     * Returns the current value of the property 'BlockIOReadBandwidth'.
     *
     * <b>Documentation of 'BlockIOReadBandwidth'</b>:
     *
     * BlockIOReadBandwidth
     */
    const ::std::vector< blockIOData >& getBlockIOReadBandwidth() const;

    /**
     * Returns the current value of the property 'BlockIOReadBandwidth' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendBlockIOReadBandwidthUpdate() method.
     *
     * <b>Documentation of 'BlockIOReadBandwidth'</b>:
     *
     * BlockIOReadBandwidth
     */
    ::std::vector< blockIOData >& getBlockIOReadBandwidthMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBlockIOReadBandwidthUpdate().
     *
     * <b>Documentation of 'BlockIOReadBandwidth'</b>:
     *
     * BlockIOReadBandwidth
     */
    void sendBlockIOReadBandwidthUpdate();

    // property 'BlockIOWriteBandwidth'

    /**
     * The method onBlockIOWriteBandwidthGet() is called by ASF when a client
     * invokes the read method for the property 'BlockIOWriteBandwidth'. The
     * onBlockIOWriteBandwidthGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'BlockIOWriteBandwidth'</b>:
     *
     * BlockIOWriteBandwidth
     */
    virtual void onBlockIOWriteBandwidthGet(const ::boost::shared_ptr< BlockIOWriteBandwidthGet >& payload);

    /**
     * Sends back the update to a previous onBlockIOWriteBandwidthGet().
     *
     * <b>Documentation of 'BlockIOWriteBandwidth'</b>:
     *
     * BlockIOWriteBandwidth
     *
     * @param act Identifies a previous invocation of
     * onBlockIOWriteBandwidthGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBlockIOWriteBandwidthGetUpdate(const ::std::vector< blockIOData >& blockIOWriteBandwidth, act_t act = 0);

    /**
     * Set the value of the property 'BlockIOWriteBandwidth' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'BlockIOWriteBandwidth'</b>:
     *
     * BlockIOWriteBandwidth
     */
    void setBlockIOWriteBandwidth(const ::std::vector< blockIOData >& blockIOWriteBandwidth);

    /**
     * Returns the current value of the property 'BlockIOWriteBandwidth'.
     *
     * <b>Documentation of 'BlockIOWriteBandwidth'</b>:
     *
     * BlockIOWriteBandwidth
     */
    const ::std::vector< blockIOData >& getBlockIOWriteBandwidth() const;

    /**
     * Returns the current value of the property 'BlockIOWriteBandwidth' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendBlockIOWriteBandwidthUpdate() method.
     *
     * <b>Documentation of 'BlockIOWriteBandwidth'</b>:
     *
     * BlockIOWriteBandwidth
     */
    ::std::vector< blockIOData >& getBlockIOWriteBandwidthMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBlockIOWriteBandwidthUpdate().
     *
     * <b>Documentation of 'BlockIOWriteBandwidth'</b>:
     *
     * BlockIOWriteBandwidth
     */
    void sendBlockIOWriteBandwidthUpdate();

    // property 'MemoryAccounting'

    /**
     * The method onMemoryAccountingGet() is called by ASF when a client
     * invokes the read method for the property 'MemoryAccounting'. The
     * onMemoryAccountingGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'MemoryAccounting'</b>:
     *
     * MemoryAccounting
     */
    virtual void onMemoryAccountingGet(const ::boost::shared_ptr< MemoryAccountingGet >& payload);

    /**
     * Sends back the update to a previous onMemoryAccountingGet().
     *
     * <b>Documentation of 'MemoryAccounting'</b>:
     *
     * MemoryAccounting
     *
     * @param act Identifies a previous invocation of onMemoryAccountingGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMemoryAccountingGetUpdate(bool memoryAccounting, act_t act = 0);

    /**
     * Set the value of the property 'MemoryAccounting' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'MemoryAccounting'</b>:
     *
     * MemoryAccounting
     */
    void setMemoryAccounting(bool memoryAccounting);

    /**
     * Returns the current value of the property 'MemoryAccounting'.
     *
     * <b>Documentation of 'MemoryAccounting'</b>:
     *
     * MemoryAccounting
     */
    bool getMemoryAccounting() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMemoryAccountingUpdate().
     *
     * <b>Documentation of 'MemoryAccounting'</b>:
     *
     * MemoryAccounting
     */
    void sendMemoryAccountingUpdate();

    // property 'MemoryLimit'

    /**
     * The method onMemoryLimitGet() is called by ASF when a client invokes
     * the read method for the property 'MemoryLimit'. The onMemoryLimitGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'MemoryLimit'</b>:
     *
     * MemoryLimit
     */
    virtual void onMemoryLimitGet(const ::boost::shared_ptr< MemoryLimitGet >& payload);

    /**
     * Sends back the update to a previous onMemoryLimitGet().
     *
     * <b>Documentation of 'MemoryLimit'</b>:
     *
     * MemoryLimit
     *
     * @param act Identifies a previous invocation of onMemoryLimitGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMemoryLimitGetUpdate(uint64 memoryLimit, act_t act = 0);

    /**
     * Set the value of the property 'MemoryLimit' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'MemoryLimit'</b>:
     *
     * MemoryLimit
     */
    void setMemoryLimit(uint64 memoryLimit);

    /**
     * Returns the current value of the property 'MemoryLimit'.
     *
     * <b>Documentation of 'MemoryLimit'</b>:
     *
     * MemoryLimit
     */
    uint64 getMemoryLimit() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMemoryLimitUpdate().
     *
     * <b>Documentation of 'MemoryLimit'</b>:
     *
     * MemoryLimit
     */
    void sendMemoryLimitUpdate();

    // property 'DevicePolicy'

    /**
     * The method onDevicePolicyGet() is called by ASF when a client invokes
     * the read method for the property 'DevicePolicy'. The
     * onDevicePolicyGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'DevicePolicy'</b>:
     *
     * DevicePolicy
     */
    virtual void onDevicePolicyGet(const ::boost::shared_ptr< DevicePolicyGet >& payload);

    /**
     * Sends back the update to a previous onDevicePolicyGet().
     *
     * <b>Documentation of 'DevicePolicy'</b>:
     *
     * DevicePolicy
     *
     * @param act Identifies a previous invocation of onDevicePolicyGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDevicePolicyGetUpdate(const ::std::string& devicePolicy, act_t act = 0);

    /**
     * Set the value of the property 'DevicePolicy' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DevicePolicy'</b>:
     *
     * DevicePolicy
     */
    void setDevicePolicy(const ::std::string& devicePolicy);

    /**
     * Returns the current value of the property 'DevicePolicy'.
     *
     * <b>Documentation of 'DevicePolicy'</b>:
     *
     * DevicePolicy
     */
    const ::std::string& getDevicePolicy() const;

    /**
     * Returns the current value of the property 'DevicePolicy' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDevicePolicyUpdate() method.
     *
     * <b>Documentation of 'DevicePolicy'</b>:
     *
     * DevicePolicy
     */
    ::std::string& getDevicePolicyMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDevicePolicyUpdate().
     *
     * <b>Documentation of 'DevicePolicy'</b>:
     *
     * DevicePolicy
     */
    void sendDevicePolicyUpdate();

    // property 'DeviceAllow'

    /**
     * The method onDeviceAllowGet() is called by ASF when a client invokes
     * the read method for the property 'DeviceAllow'. The onDeviceAllowGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'DeviceAllow'</b>:
     *
     * DeviceAllow
     */
    virtual void onDeviceAllowGet(const ::boost::shared_ptr< DeviceAllowGet >& payload);

    /**
     * Sends back the update to a previous onDeviceAllowGet().
     *
     * <b>Documentation of 'DeviceAllow'</b>:
     *
     * DeviceAllow
     *
     * @param act Identifies a previous invocation of onDeviceAllowGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDeviceAllowGetUpdate(const ::std::vector< deviceNode >& deviceAllow, act_t act = 0);

    /**
     * Set the value of the property 'DeviceAllow' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DeviceAllow'</b>:
     *
     * DeviceAllow
     */
    void setDeviceAllow(const ::std::vector< deviceNode >& deviceAllow);

    /**
     * Returns the current value of the property 'DeviceAllow'.
     *
     * <b>Documentation of 'DeviceAllow'</b>:
     *
     * DeviceAllow
     */
    const ::std::vector< deviceNode >& getDeviceAllow() const;

    /**
     * Returns the current value of the property 'DeviceAllow' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDeviceAllowUpdate() method.
     *
     * <b>Documentation of 'DeviceAllow'</b>:
     *
     * DeviceAllow
     */
    ::std::vector< deviceNode >& getDeviceAllowMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDeviceAllowUpdate().
     *
     * <b>Documentation of 'DeviceAllow'</b>:
     *
     * DeviceAllow
     */
    void sendDeviceAllowUpdate();

    // property 'Environment'

    /**
     * The method onEnvironmentGet() is called by ASF when a client invokes
     * the read method for the property 'Environment'. The onEnvironmentGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment
     */
    virtual void onEnvironmentGet(const ::boost::shared_ptr< EnvironmentGet >& payload);

    /**
     * Sends back the update to a previous onEnvironmentGet().
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment
     *
     * @param act Identifies a previous invocation of onEnvironmentGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEnvironmentGetUpdate(const ::std::vector< ::std::string >& environment, act_t act = 0);

    /**
     * Set the value of the property 'Environment' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment
     */
    void setEnvironment(const ::std::vector< ::std::string >& environment);

    /**
     * Returns the current value of the property 'Environment'.
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment
     */
    const ::std::vector< ::std::string >& getEnvironment() const;

    /**
     * Returns the current value of the property 'Environment' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendEnvironmentUpdate() method.
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment
     */
    ::std::vector< ::std::string >& getEnvironmentMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEnvironmentUpdate().
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment
     */
    void sendEnvironmentUpdate();

    // property 'EnvironmentFiles'

    /**
     * The method onEnvironmentFilesGet() is called by ASF when a client
     * invokes the read method for the property 'EnvironmentFiles'. The
     * onEnvironmentFilesGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'EnvironmentFiles'</b>:
     *
     * EnvironmentFiles
     */
    virtual void onEnvironmentFilesGet(const ::boost::shared_ptr< EnvironmentFilesGet >& payload);

    /**
     * Sends back the update to a previous onEnvironmentFilesGet().
     *
     * <b>Documentation of 'EnvironmentFiles'</b>:
     *
     * EnvironmentFiles
     *
     * @param act Identifies a previous invocation of onEnvironmentFilesGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEnvironmentFilesGetUpdate(const ::std::vector< EnvironmentFile >& environmentFiles, act_t act = 0);

    /**
     * Set the value of the property 'EnvironmentFiles' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'EnvironmentFiles'</b>:
     *
     * EnvironmentFiles
     */
    void setEnvironmentFiles(const ::std::vector< EnvironmentFile >& environmentFiles);

    /**
     * Returns the current value of the property 'EnvironmentFiles'.
     *
     * <b>Documentation of 'EnvironmentFiles'</b>:
     *
     * EnvironmentFiles
     */
    const ::std::vector< EnvironmentFile >& getEnvironmentFiles() const;

    /**
     * Returns the current value of the property 'EnvironmentFiles' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendEnvironmentFilesUpdate() method.
     *
     * <b>Documentation of 'EnvironmentFiles'</b>:
     *
     * EnvironmentFiles
     */
    ::std::vector< EnvironmentFile >& getEnvironmentFilesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEnvironmentFilesUpdate().
     *
     * <b>Documentation of 'EnvironmentFiles'</b>:
     *
     * EnvironmentFiles
     */
    void sendEnvironmentFilesUpdate();

    // property 'UMask'

    /**
     * The method onUMaskGet() is called by ASF when a client invokes the read
     * method for the property 'UMask'. The onUMaskGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'UMask'</b>:
     *
     * UMask
     */
    virtual void onUMaskGet(const ::boost::shared_ptr< UMaskGet >& payload);

    /**
     * Sends back the update to a previous onUMaskGet().
     *
     * <b>Documentation of 'UMask'</b>:
     *
     * UMask
     *
     * @param act Identifies a previous invocation of onUMaskGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUMaskGetUpdate(uint32 uMask, act_t act = 0);

    /**
     * Set the value of the property 'UMask' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'UMask'</b>:
     *
     * UMask
     */
    void setUMask(uint32 uMask);

    /**
     * Returns the current value of the property 'UMask'.
     *
     * <b>Documentation of 'UMask'</b>:
     *
     * UMask
     */
    uint32 getUMask() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUMaskUpdate().
     *
     * <b>Documentation of 'UMask'</b>:
     *
     * UMask
     */
    void sendUMaskUpdate();

    // property 'LimitCPU'

    /**
     * The method onLimitCPUGet() is called by ASF when a client invokes the
     * read method for the property 'LimitCPU'. The onLimitCPUGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LimitCPU'</b>:
     *
     * LimitCPU
     */
    virtual void onLimitCPUGet(const ::boost::shared_ptr< LimitCPUGet >& payload);

    /**
     * Sends back the update to a previous onLimitCPUGet().
     *
     * <b>Documentation of 'LimitCPU'</b>:
     *
     * LimitCPU
     *
     * @param act Identifies a previous invocation of onLimitCPUGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLimitCPUGetUpdate(uint64 limitCPU, act_t act = 0);

    /**
     * Set the value of the property 'LimitCPU' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'LimitCPU'</b>:
     *
     * LimitCPU
     */
    void setLimitCPU(uint64 limitCPU);

    /**
     * Returns the current value of the property 'LimitCPU'.
     *
     * <b>Documentation of 'LimitCPU'</b>:
     *
     * LimitCPU
     */
    uint64 getLimitCPU() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitCPUUpdate().
     *
     * <b>Documentation of 'LimitCPU'</b>:
     *
     * LimitCPU
     */
    void sendLimitCPUUpdate();

    // property 'LimitFSIZE'

    /**
     * The method onLimitFSIZEGet() is called by ASF when a client invokes the
     * read method for the property 'LimitFSIZE'. The onLimitFSIZEGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LimitFSIZE'</b>:
     *
     * LimitFSIZE
     */
    virtual void onLimitFSIZEGet(const ::boost::shared_ptr< LimitFSIZEGet >& payload);

    /**
     * Sends back the update to a previous onLimitFSIZEGet().
     *
     * <b>Documentation of 'LimitFSIZE'</b>:
     *
     * LimitFSIZE
     *
     * @param act Identifies a previous invocation of onLimitFSIZEGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLimitFSIZEGetUpdate(uint64 limitFSIZE, act_t act = 0);

    /**
     * Set the value of the property 'LimitFSIZE' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitFSIZE'</b>:
     *
     * LimitFSIZE
     */
    void setLimitFSIZE(uint64 limitFSIZE);

    /**
     * Returns the current value of the property 'LimitFSIZE'.
     *
     * <b>Documentation of 'LimitFSIZE'</b>:
     *
     * LimitFSIZE
     */
    uint64 getLimitFSIZE() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitFSIZEUpdate().
     *
     * <b>Documentation of 'LimitFSIZE'</b>:
     *
     * LimitFSIZE
     */
    void sendLimitFSIZEUpdate();

    // property 'LimitDATA'

    /**
     * The method onLimitDATAGet() is called by ASF when a client invokes the
     * read method for the property 'LimitDATA'. The onLimitDATAGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LimitDATA'</b>:
     *
     * LimitDATA
     */
    virtual void onLimitDATAGet(const ::boost::shared_ptr< LimitDATAGet >& payload);

    /**
     * Sends back the update to a previous onLimitDATAGet().
     *
     * <b>Documentation of 'LimitDATA'</b>:
     *
     * LimitDATA
     *
     * @param act Identifies a previous invocation of onLimitDATAGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLimitDATAGetUpdate(uint64 limitDATA, act_t act = 0);

    /**
     * Set the value of the property 'LimitDATA' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitDATA'</b>:
     *
     * LimitDATA
     */
    void setLimitDATA(uint64 limitDATA);

    /**
     * Returns the current value of the property 'LimitDATA'.
     *
     * <b>Documentation of 'LimitDATA'</b>:
     *
     * LimitDATA
     */
    uint64 getLimitDATA() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitDATAUpdate().
     *
     * <b>Documentation of 'LimitDATA'</b>:
     *
     * LimitDATA
     */
    void sendLimitDATAUpdate();

    // property 'LimitSTACK'

    /**
     * The method onLimitSTACKGet() is called by ASF when a client invokes the
     * read method for the property 'LimitSTACK'. The onLimitSTACKGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LimitSTACK'</b>:
     *
     * LimitSTACK
     */
    virtual void onLimitSTACKGet(const ::boost::shared_ptr< LimitSTACKGet >& payload);

    /**
     * Sends back the update to a previous onLimitSTACKGet().
     *
     * <b>Documentation of 'LimitSTACK'</b>:
     *
     * LimitSTACK
     *
     * @param act Identifies a previous invocation of onLimitSTACKGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLimitSTACKGetUpdate(uint64 limitSTACK, act_t act = 0);

    /**
     * Set the value of the property 'LimitSTACK' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitSTACK'</b>:
     *
     * LimitSTACK
     */
    void setLimitSTACK(uint64 limitSTACK);

    /**
     * Returns the current value of the property 'LimitSTACK'.
     *
     * <b>Documentation of 'LimitSTACK'</b>:
     *
     * LimitSTACK
     */
    uint64 getLimitSTACK() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitSTACKUpdate().
     *
     * <b>Documentation of 'LimitSTACK'</b>:
     *
     * LimitSTACK
     */
    void sendLimitSTACKUpdate();

    // property 'LimitCORE'

    /**
     * The method onLimitCOREGet() is called by ASF when a client invokes the
     * read method for the property 'LimitCORE'. The onLimitCOREGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LimitCORE'</b>:
     *
     * LimitCORE
     */
    virtual void onLimitCOREGet(const ::boost::shared_ptr< LimitCOREGet >& payload);

    /**
     * Sends back the update to a previous onLimitCOREGet().
     *
     * <b>Documentation of 'LimitCORE'</b>:
     *
     * LimitCORE
     *
     * @param act Identifies a previous invocation of onLimitCOREGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLimitCOREGetUpdate(uint64 limitCORE, act_t act = 0);

    /**
     * Set the value of the property 'LimitCORE' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitCORE'</b>:
     *
     * LimitCORE
     */
    void setLimitCORE(uint64 limitCORE);

    /**
     * Returns the current value of the property 'LimitCORE'.
     *
     * <b>Documentation of 'LimitCORE'</b>:
     *
     * LimitCORE
     */
    uint64 getLimitCORE() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitCOREUpdate().
     *
     * <b>Documentation of 'LimitCORE'</b>:
     *
     * LimitCORE
     */
    void sendLimitCOREUpdate();

    // property 'LimitRSS'

    /**
     * The method onLimitRSSGet() is called by ASF when a client invokes the
     * read method for the property 'LimitRSS'. The onLimitRSSGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LimitRSS'</b>:
     *
     * LimitRSS
     */
    virtual void onLimitRSSGet(const ::boost::shared_ptr< LimitRSSGet >& payload);

    /**
     * Sends back the update to a previous onLimitRSSGet().
     *
     * <b>Documentation of 'LimitRSS'</b>:
     *
     * LimitRSS
     *
     * @param act Identifies a previous invocation of onLimitRSSGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLimitRSSGetUpdate(uint64 limitRSS, act_t act = 0);

    /**
     * Set the value of the property 'LimitRSS' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'LimitRSS'</b>:
     *
     * LimitRSS
     */
    void setLimitRSS(uint64 limitRSS);

    /**
     * Returns the current value of the property 'LimitRSS'.
     *
     * <b>Documentation of 'LimitRSS'</b>:
     *
     * LimitRSS
     */
    uint64 getLimitRSS() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitRSSUpdate().
     *
     * <b>Documentation of 'LimitRSS'</b>:
     *
     * LimitRSS
     */
    void sendLimitRSSUpdate();

    // property 'LimitNOFILE'

    /**
     * The method onLimitNOFILEGet() is called by ASF when a client invokes
     * the read method for the property 'LimitNOFILE'. The onLimitNOFILEGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'LimitNOFILE'</b>:
     *
     * LimitNOFILE
     */
    virtual void onLimitNOFILEGet(const ::boost::shared_ptr< LimitNOFILEGet >& payload);

    /**
     * Sends back the update to a previous onLimitNOFILEGet().
     *
     * <b>Documentation of 'LimitNOFILE'</b>:
     *
     * LimitNOFILE
     *
     * @param act Identifies a previous invocation of onLimitNOFILEGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLimitNOFILEGetUpdate(uint64 limitNOFILE, act_t act = 0);

    /**
     * Set the value of the property 'LimitNOFILE' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitNOFILE'</b>:
     *
     * LimitNOFILE
     */
    void setLimitNOFILE(uint64 limitNOFILE);

    /**
     * Returns the current value of the property 'LimitNOFILE'.
     *
     * <b>Documentation of 'LimitNOFILE'</b>:
     *
     * LimitNOFILE
     */
    uint64 getLimitNOFILE() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitNOFILEUpdate().
     *
     * <b>Documentation of 'LimitNOFILE'</b>:
     *
     * LimitNOFILE
     */
    void sendLimitNOFILEUpdate();

    // property 'LimitAS'

    /**
     * The method onLimitASGet() is called by ASF when a client invokes the
     * read method for the property 'LimitAS'. The onLimitASGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LimitAS'</b>:
     *
     * LimitAS
     */
    virtual void onLimitASGet(const ::boost::shared_ptr< LimitASGet >& payload);

    /**
     * Sends back the update to a previous onLimitASGet().
     *
     * <b>Documentation of 'LimitAS'</b>:
     *
     * LimitAS
     *
     * @param act Identifies a previous invocation of onLimitASGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLimitASGetUpdate(uint64 limitAS, act_t act = 0);

    /**
     * Set the value of the property 'LimitAS' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'LimitAS'</b>:
     *
     * LimitAS
     */
    void setLimitAS(uint64 limitAS);

    /**
     * Returns the current value of the property 'LimitAS'.
     *
     * <b>Documentation of 'LimitAS'</b>:
     *
     * LimitAS
     */
    uint64 getLimitAS() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitASUpdate().
     *
     * <b>Documentation of 'LimitAS'</b>:
     *
     * LimitAS
     */
    void sendLimitASUpdate();

    // property 'LimitNPROC'

    /**
     * The method onLimitNPROCGet() is called by ASF when a client invokes the
     * read method for the property 'LimitNPROC'. The onLimitNPROCGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LimitNPROC'</b>:
     *
     * LimitNPROC
     */
    virtual void onLimitNPROCGet(const ::boost::shared_ptr< LimitNPROCGet >& payload);

    /**
     * Sends back the update to a previous onLimitNPROCGet().
     *
     * <b>Documentation of 'LimitNPROC'</b>:
     *
     * LimitNPROC
     *
     * @param act Identifies a previous invocation of onLimitNPROCGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLimitNPROCGetUpdate(uint64 limitNPROC, act_t act = 0);

    /**
     * Set the value of the property 'LimitNPROC' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitNPROC'</b>:
     *
     * LimitNPROC
     */
    void setLimitNPROC(uint64 limitNPROC);

    /**
     * Returns the current value of the property 'LimitNPROC'.
     *
     * <b>Documentation of 'LimitNPROC'</b>:
     *
     * LimitNPROC
     */
    uint64 getLimitNPROC() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitNPROCUpdate().
     *
     * <b>Documentation of 'LimitNPROC'</b>:
     *
     * LimitNPROC
     */
    void sendLimitNPROCUpdate();

    // property 'LimitMEMLOCK'

    /**
     * The method onLimitMEMLOCKGet() is called by ASF when a client invokes
     * the read method for the property 'LimitMEMLOCK'. The
     * onLimitMEMLOCKGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'LimitMEMLOCK'</b>:
     *
     * LimitMEMLOCK
     */
    virtual void onLimitMEMLOCKGet(const ::boost::shared_ptr< LimitMEMLOCKGet >& payload);

    /**
     * Sends back the update to a previous onLimitMEMLOCKGet().
     *
     * <b>Documentation of 'LimitMEMLOCK'</b>:
     *
     * LimitMEMLOCK
     *
     * @param act Identifies a previous invocation of onLimitMEMLOCKGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLimitMEMLOCKGetUpdate(uint64 limitMEMLOCK, act_t act = 0);

    /**
     * Set the value of the property 'LimitMEMLOCK' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitMEMLOCK'</b>:
     *
     * LimitMEMLOCK
     */
    void setLimitMEMLOCK(uint64 limitMEMLOCK);

    /**
     * Returns the current value of the property 'LimitMEMLOCK'.
     *
     * <b>Documentation of 'LimitMEMLOCK'</b>:
     *
     * LimitMEMLOCK
     */
    uint64 getLimitMEMLOCK() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitMEMLOCKUpdate().
     *
     * <b>Documentation of 'LimitMEMLOCK'</b>:
     *
     * LimitMEMLOCK
     */
    void sendLimitMEMLOCKUpdate();

    // property 'LimitLOCKS'

    /**
     * The method onLimitLOCKSGet() is called by ASF when a client invokes the
     * read method for the property 'LimitLOCKS'. The onLimitLOCKSGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LimitLOCKS'</b>:
     *
     * LimitLOCKS
     */
    virtual void onLimitLOCKSGet(const ::boost::shared_ptr< LimitLOCKSGet >& payload);

    /**
     * Sends back the update to a previous onLimitLOCKSGet().
     *
     * <b>Documentation of 'LimitLOCKS'</b>:
     *
     * LimitLOCKS
     *
     * @param act Identifies a previous invocation of onLimitLOCKSGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLimitLOCKSGetUpdate(uint64 limitLOCKS, act_t act = 0);

    /**
     * Set the value of the property 'LimitLOCKS' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitLOCKS'</b>:
     *
     * LimitLOCKS
     */
    void setLimitLOCKS(uint64 limitLOCKS);

    /**
     * Returns the current value of the property 'LimitLOCKS'.
     *
     * <b>Documentation of 'LimitLOCKS'</b>:
     *
     * LimitLOCKS
     */
    uint64 getLimitLOCKS() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitLOCKSUpdate().
     *
     * <b>Documentation of 'LimitLOCKS'</b>:
     *
     * LimitLOCKS
     */
    void sendLimitLOCKSUpdate();

    // property 'LimitSIGPENDING'

    /**
     * The method onLimitSIGPENDINGGet() is called by ASF when a client
     * invokes the read method for the property 'LimitSIGPENDING'. The
     * onLimitSIGPENDINGGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'LimitSIGPENDING'</b>:
     *
     * LimitSIGPENDING
     */
    virtual void onLimitSIGPENDINGGet(const ::boost::shared_ptr< LimitSIGPENDINGGet >& payload);

    /**
     * Sends back the update to a previous onLimitSIGPENDINGGet().
     *
     * <b>Documentation of 'LimitSIGPENDING'</b>:
     *
     * LimitSIGPENDING
     *
     * @param act Identifies a previous invocation of onLimitSIGPENDINGGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLimitSIGPENDINGGetUpdate(uint64 limitSIGPENDING, act_t act = 0);

    /**
     * Set the value of the property 'LimitSIGPENDING' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitSIGPENDING'</b>:
     *
     * LimitSIGPENDING
     */
    void setLimitSIGPENDING(uint64 limitSIGPENDING);

    /**
     * Returns the current value of the property 'LimitSIGPENDING'.
     *
     * <b>Documentation of 'LimitSIGPENDING'</b>:
     *
     * LimitSIGPENDING
     */
    uint64 getLimitSIGPENDING() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitSIGPENDINGUpdate().
     *
     * <b>Documentation of 'LimitSIGPENDING'</b>:
     *
     * LimitSIGPENDING
     */
    void sendLimitSIGPENDINGUpdate();

    // property 'LimitMSGQUEUE'

    /**
     * The method onLimitMSGQUEUEGet() is called by ASF when a client invokes
     * the read method for the property 'LimitMSGQUEUE'. The
     * onLimitMSGQUEUEGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'LimitMSGQUEUE'</b>:
     *
     * LimitMSGQUEUE
     */
    virtual void onLimitMSGQUEUEGet(const ::boost::shared_ptr< LimitMSGQUEUEGet >& payload);

    /**
     * Sends back the update to a previous onLimitMSGQUEUEGet().
     *
     * <b>Documentation of 'LimitMSGQUEUE'</b>:
     *
     * LimitMSGQUEUE
     *
     * @param act Identifies a previous invocation of onLimitMSGQUEUEGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLimitMSGQUEUEGetUpdate(uint64 limitMSGQUEUE, act_t act = 0);

    /**
     * Set the value of the property 'LimitMSGQUEUE' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitMSGQUEUE'</b>:
     *
     * LimitMSGQUEUE
     */
    void setLimitMSGQUEUE(uint64 limitMSGQUEUE);

    /**
     * Returns the current value of the property 'LimitMSGQUEUE'.
     *
     * <b>Documentation of 'LimitMSGQUEUE'</b>:
     *
     * LimitMSGQUEUE
     */
    uint64 getLimitMSGQUEUE() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitMSGQUEUEUpdate().
     *
     * <b>Documentation of 'LimitMSGQUEUE'</b>:
     *
     * LimitMSGQUEUE
     */
    void sendLimitMSGQUEUEUpdate();

    // property 'LimitNICE'

    /**
     * The method onLimitNICEGet() is called by ASF when a client invokes the
     * read method for the property 'LimitNICE'. The onLimitNICEGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LimitNICE'</b>:
     *
     * LimitNICE
     */
    virtual void onLimitNICEGet(const ::boost::shared_ptr< LimitNICEGet >& payload);

    /**
     * Sends back the update to a previous onLimitNICEGet().
     *
     * <b>Documentation of 'LimitNICE'</b>:
     *
     * LimitNICE
     *
     * @param act Identifies a previous invocation of onLimitNICEGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLimitNICEGetUpdate(uint64 limitNICE, act_t act = 0);

    /**
     * Set the value of the property 'LimitNICE' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitNICE'</b>:
     *
     * LimitNICE
     */
    void setLimitNICE(uint64 limitNICE);

    /**
     * Returns the current value of the property 'LimitNICE'.
     *
     * <b>Documentation of 'LimitNICE'</b>:
     *
     * LimitNICE
     */
    uint64 getLimitNICE() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitNICEUpdate().
     *
     * <b>Documentation of 'LimitNICE'</b>:
     *
     * LimitNICE
     */
    void sendLimitNICEUpdate();

    // property 'LimitRTPRIO'

    /**
     * The method onLimitRTPRIOGet() is called by ASF when a client invokes
     * the read method for the property 'LimitRTPRIO'. The onLimitRTPRIOGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'LimitRTPRIO'</b>:
     *
     * LimitRTPRIO
     */
    virtual void onLimitRTPRIOGet(const ::boost::shared_ptr< LimitRTPRIOGet >& payload);

    /**
     * Sends back the update to a previous onLimitRTPRIOGet().
     *
     * <b>Documentation of 'LimitRTPRIO'</b>:
     *
     * LimitRTPRIO
     *
     * @param act Identifies a previous invocation of onLimitRTPRIOGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLimitRTPRIOGetUpdate(uint64 limitRTPRIO, act_t act = 0);

    /**
     * Set the value of the property 'LimitRTPRIO' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitRTPRIO'</b>:
     *
     * LimitRTPRIO
     */
    void setLimitRTPRIO(uint64 limitRTPRIO);

    /**
     * Returns the current value of the property 'LimitRTPRIO'.
     *
     * <b>Documentation of 'LimitRTPRIO'</b>:
     *
     * LimitRTPRIO
     */
    uint64 getLimitRTPRIO() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitRTPRIOUpdate().
     *
     * <b>Documentation of 'LimitRTPRIO'</b>:
     *
     * LimitRTPRIO
     */
    void sendLimitRTPRIOUpdate();

    // property 'LimitRTTIME'

    /**
     * The method onLimitRTTIMEGet() is called by ASF when a client invokes
     * the read method for the property 'LimitRTTIME'. The onLimitRTTIMEGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'LimitRTTIME'</b>:
     *
     * LimitRTTIME
     */
    virtual void onLimitRTTIMEGet(const ::boost::shared_ptr< LimitRTTIMEGet >& payload);

    /**
     * Sends back the update to a previous onLimitRTTIMEGet().
     *
     * <b>Documentation of 'LimitRTTIME'</b>:
     *
     * LimitRTTIME
     *
     * @param act Identifies a previous invocation of onLimitRTTIMEGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLimitRTTIMEGetUpdate(uint64 limitRTTIME, act_t act = 0);

    /**
     * Set the value of the property 'LimitRTTIME' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LimitRTTIME'</b>:
     *
     * LimitRTTIME
     */
    void setLimitRTTIME(uint64 limitRTTIME);

    /**
     * Returns the current value of the property 'LimitRTTIME'.
     *
     * <b>Documentation of 'LimitRTTIME'</b>:
     *
     * LimitRTTIME
     */
    uint64 getLimitRTTIME() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLimitRTTIMEUpdate().
     *
     * <b>Documentation of 'LimitRTTIME'</b>:
     *
     * LimitRTTIME
     */
    void sendLimitRTTIMEUpdate();

    // property 'WorkingDirectory'

    /**
     * The method onWorkingDirectoryGet() is called by ASF when a client
     * invokes the read method for the property 'WorkingDirectory'. The
     * onWorkingDirectoryGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'WorkingDirectory'</b>:
     *
     * WorkingDirectory
     */
    virtual void onWorkingDirectoryGet(const ::boost::shared_ptr< WorkingDirectoryGet >& payload);

    /**
     * Sends back the update to a previous onWorkingDirectoryGet().
     *
     * <b>Documentation of 'WorkingDirectory'</b>:
     *
     * WorkingDirectory
     *
     * @param act Identifies a previous invocation of onWorkingDirectoryGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendWorkingDirectoryGetUpdate(const ::std::string& workingDirectory, act_t act = 0);

    /**
     * Set the value of the property 'WorkingDirectory' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'WorkingDirectory'</b>:
     *
     * WorkingDirectory
     */
    void setWorkingDirectory(const ::std::string& workingDirectory);

    /**
     * Returns the current value of the property 'WorkingDirectory'.
     *
     * <b>Documentation of 'WorkingDirectory'</b>:
     *
     * WorkingDirectory
     */
    const ::std::string& getWorkingDirectory() const;

    /**
     * Returns the current value of the property 'WorkingDirectory' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendWorkingDirectoryUpdate() method.
     *
     * <b>Documentation of 'WorkingDirectory'</b>:
     *
     * WorkingDirectory
     */
    ::std::string& getWorkingDirectoryMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWorkingDirectoryUpdate().
     *
     * <b>Documentation of 'WorkingDirectory'</b>:
     *
     * WorkingDirectory
     */
    void sendWorkingDirectoryUpdate();

    // property 'RootDirectory'

    /**
     * The method onRootDirectoryGet() is called by ASF when a client invokes
     * the read method for the property 'RootDirectory'. The
     * onRootDirectoryGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RootDirectory'</b>:
     *
     * RootDirectory
     */
    virtual void onRootDirectoryGet(const ::boost::shared_ptr< RootDirectoryGet >& payload);

    /**
     * Sends back the update to a previous onRootDirectoryGet().
     *
     * <b>Documentation of 'RootDirectory'</b>:
     *
     * RootDirectory
     *
     * @param act Identifies a previous invocation of onRootDirectoryGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRootDirectoryGetUpdate(const ::std::string& rootDirectory, act_t act = 0);

    /**
     * Set the value of the property 'RootDirectory' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RootDirectory'</b>:
     *
     * RootDirectory
     */
    void setRootDirectory(const ::std::string& rootDirectory);

    /**
     * Returns the current value of the property 'RootDirectory'.
     *
     * <b>Documentation of 'RootDirectory'</b>:
     *
     * RootDirectory
     */
    const ::std::string& getRootDirectory() const;

    /**
     * Returns the current value of the property 'RootDirectory' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendRootDirectoryUpdate() method.
     *
     * <b>Documentation of 'RootDirectory'</b>:
     *
     * RootDirectory
     */
    ::std::string& getRootDirectoryMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRootDirectoryUpdate().
     *
     * <b>Documentation of 'RootDirectory'</b>:
     *
     * RootDirectory
     */
    void sendRootDirectoryUpdate();

    // property 'OOMScoreAdjust'

    /**
     * The method onOOMScoreAdjustGet() is called by ASF when a client invokes
     * the read method for the property 'OOMScoreAdjust'. The
     * onOOMScoreAdjustGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'OOMScoreAdjust'</b>:
     *
     * OOMScoreAdjust
     */
    virtual void onOOMScoreAdjustGet(const ::boost::shared_ptr< OOMScoreAdjustGet >& payload);

    /**
     * Sends back the update to a previous onOOMScoreAdjustGet().
     *
     * <b>Documentation of 'OOMScoreAdjust'</b>:
     *
     * OOMScoreAdjust
     *
     * @param act Identifies a previous invocation of onOOMScoreAdjustGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendOOMScoreAdjustGetUpdate(int32 oOMScoreAdjust, act_t act = 0);

    /**
     * Set the value of the property 'OOMScoreAdjust' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'OOMScoreAdjust'</b>:
     *
     * OOMScoreAdjust
     */
    void setOOMScoreAdjust(int32 oOMScoreAdjust);

    /**
     * Returns the current value of the property 'OOMScoreAdjust'.
     *
     * <b>Documentation of 'OOMScoreAdjust'</b>:
     *
     * OOMScoreAdjust
     */
    int32 getOOMScoreAdjust() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendOOMScoreAdjustUpdate().
     *
     * <b>Documentation of 'OOMScoreAdjust'</b>:
     *
     * OOMScoreAdjust
     */
    void sendOOMScoreAdjustUpdate();

    // property 'Nice'

    /**
     * The method onNiceGet() is called by ASF when a client invokes the read
     * method for the property 'Nice'. The onNiceGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Nice'</b>:
     *
     * Nice
     */
    virtual void onNiceGet(const ::boost::shared_ptr< NiceGet >& payload);

    /**
     * Sends back the update to a previous onNiceGet().
     *
     * <b>Documentation of 'Nice'</b>:
     *
     * Nice
     *
     * @param act Identifies a previous invocation of onNiceGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendNiceGetUpdate(int32 nice, act_t act = 0);

    /**
     * Set the value of the property 'Nice' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Nice'</b>:
     *
     * Nice
     */
    void setNice(int32 nice);

    /**
     * Returns the current value of the property 'Nice'.
     *
     * <b>Documentation of 'Nice'</b>:
     *
     * Nice
     */
    int32 getNice() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNiceUpdate().
     *
     * <b>Documentation of 'Nice'</b>:
     *
     * Nice
     */
    void sendNiceUpdate();

    // property 'IOScheduling'

    /**
     * The method onIOSchedulingGet() is called by ASF when a client invokes
     * the read method for the property 'IOScheduling'. The
     * onIOSchedulingGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'IOScheduling'</b>:
     *
     * IOScheduling
     */
    virtual void onIOSchedulingGet(const ::boost::shared_ptr< IOSchedulingGet >& payload);

    /**
     * Sends back the update to a previous onIOSchedulingGet().
     *
     * <b>Documentation of 'IOScheduling'</b>:
     *
     * IOScheduling
     *
     * @param act Identifies a previous invocation of onIOSchedulingGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendIOSchedulingGetUpdate(int32 iOScheduling, act_t act = 0);

    /**
     * Set the value of the property 'IOScheduling' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'IOScheduling'</b>:
     *
     * IOScheduling
     */
    void setIOScheduling(int32 iOScheduling);

    /**
     * Returns the current value of the property 'IOScheduling'.
     *
     * <b>Documentation of 'IOScheduling'</b>:
     *
     * IOScheduling
     */
    int32 getIOScheduling() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIOSchedulingUpdate().
     *
     * <b>Documentation of 'IOScheduling'</b>:
     *
     * IOScheduling
     */
    void sendIOSchedulingUpdate();

    // property 'CPUSchedulingPolicy'

    /**
     * The method onCPUSchedulingPolicyGet() is called by ASF when a client
     * invokes the read method for the property 'CPUSchedulingPolicy'. The
     * onCPUSchedulingPolicyGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'CPUSchedulingPolicy'</b>:
     *
     * CPUSchedulingPolicy
     */
    virtual void onCPUSchedulingPolicyGet(const ::boost::shared_ptr< CPUSchedulingPolicyGet >& payload);

    /**
     * Sends back the update to a previous onCPUSchedulingPolicyGet().
     *
     * <b>Documentation of 'CPUSchedulingPolicy'</b>:
     *
     * CPUSchedulingPolicy
     *
     * @param act Identifies a previous invocation of
     * onCPUSchedulingPolicyGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCPUSchedulingPolicyGetUpdate(int32 cPUSchedulingPolicy, act_t act = 0);

    /**
     * Set the value of the property 'CPUSchedulingPolicy' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CPUSchedulingPolicy'</b>:
     *
     * CPUSchedulingPolicy
     */
    void setCPUSchedulingPolicy(int32 cPUSchedulingPolicy);

    /**
     * Returns the current value of the property 'CPUSchedulingPolicy'.
     *
     * <b>Documentation of 'CPUSchedulingPolicy'</b>:
     *
     * CPUSchedulingPolicy
     */
    int32 getCPUSchedulingPolicy() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCPUSchedulingPolicyUpdate().
     *
     * <b>Documentation of 'CPUSchedulingPolicy'</b>:
     *
     * CPUSchedulingPolicy
     */
    void sendCPUSchedulingPolicyUpdate();

    // property 'CPUSchedulingPriority'

    /**
     * The method onCPUSchedulingPriorityGet() is called by ASF when a client
     * invokes the read method for the property 'CPUSchedulingPriority'. The
     * onCPUSchedulingPriorityGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'CPUSchedulingPriority'</b>:
     *
     * CPUSchedulingPriority
     */
    virtual void onCPUSchedulingPriorityGet(const ::boost::shared_ptr< CPUSchedulingPriorityGet >& payload);

    /**
     * Sends back the update to a previous onCPUSchedulingPriorityGet().
     *
     * <b>Documentation of 'CPUSchedulingPriority'</b>:
     *
     * CPUSchedulingPriority
     *
     * @param act Identifies a previous invocation of
     * onCPUSchedulingPriorityGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCPUSchedulingPriorityGetUpdate(int32 cPUSchedulingPriority, act_t act = 0);

    /**
     * Set the value of the property 'CPUSchedulingPriority' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'CPUSchedulingPriority'</b>:
     *
     * CPUSchedulingPriority
     */
    void setCPUSchedulingPriority(int32 cPUSchedulingPriority);

    /**
     * Returns the current value of the property 'CPUSchedulingPriority'.
     *
     * <b>Documentation of 'CPUSchedulingPriority'</b>:
     *
     * CPUSchedulingPriority
     */
    int32 getCPUSchedulingPriority() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCPUSchedulingPriorityUpdate().
     *
     * <b>Documentation of 'CPUSchedulingPriority'</b>:
     *
     * CPUSchedulingPriority
     */
    void sendCPUSchedulingPriorityUpdate();

    // property 'CPUAffinity'

    /**
     * The method onCPUAffinityGet() is called by ASF when a client invokes
     * the read method for the property 'CPUAffinity'. The onCPUAffinityGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'CPUAffinity'</b>:
     *
     * CPUAffinity
     */
    virtual void onCPUAffinityGet(const ::boost::shared_ptr< CPUAffinityGet >& payload);

    /**
     * Sends back the update to a previous onCPUAffinityGet().
     *
     * <b>Documentation of 'CPUAffinity'</b>:
     *
     * CPUAffinity
     *
     * @param act Identifies a previous invocation of onCPUAffinityGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCPUAffinityGetUpdate(const ::std::vector< ::std::string >& cPUAffinity, act_t act = 0);

    /**
     * Set the value of the property 'CPUAffinity' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CPUAffinity'</b>:
     *
     * CPUAffinity
     */
    void setCPUAffinity(const ::std::vector< ::std::string >& cPUAffinity);

    /**
     * Returns the current value of the property 'CPUAffinity'.
     *
     * <b>Documentation of 'CPUAffinity'</b>:
     *
     * CPUAffinity
     */
    const ::std::vector< ::std::string >& getCPUAffinity() const;

    /**
     * Returns the current value of the property 'CPUAffinity' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendCPUAffinityUpdate() method.
     *
     * <b>Documentation of 'CPUAffinity'</b>:
     *
     * CPUAffinity
     */
    ::std::vector< ::std::string >& getCPUAffinityMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCPUAffinityUpdate().
     *
     * <b>Documentation of 'CPUAffinity'</b>:
     *
     * CPUAffinity
     */
    void sendCPUAffinityUpdate();

    // property 'TimerSlackNSec'

    /**
     * The method onTimerSlackNSecGet() is called by ASF when a client invokes
     * the read method for the property 'TimerSlackNSec'. The
     * onTimerSlackNSecGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'TimerSlackNSec'</b>:
     *
     * TimerSlackNSec
     */
    virtual void onTimerSlackNSecGet(const ::boost::shared_ptr< TimerSlackNSecGet >& payload);

    /**
     * Sends back the update to a previous onTimerSlackNSecGet().
     *
     * <b>Documentation of 'TimerSlackNSec'</b>:
     *
     * TimerSlackNSec
     *
     * @param act Identifies a previous invocation of onTimerSlackNSecGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTimerSlackNSecGetUpdate(uint64 timerSlackNSec, act_t act = 0);

    /**
     * Set the value of the property 'TimerSlackNSec' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'TimerSlackNSec'</b>:
     *
     * TimerSlackNSec
     */
    void setTimerSlackNSec(uint64 timerSlackNSec);

    /**
     * Returns the current value of the property 'TimerSlackNSec'.
     *
     * <b>Documentation of 'TimerSlackNSec'</b>:
     *
     * TimerSlackNSec
     */
    uint64 getTimerSlackNSec() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTimerSlackNSecUpdate().
     *
     * <b>Documentation of 'TimerSlackNSec'</b>:
     *
     * TimerSlackNSec
     */
    void sendTimerSlackNSecUpdate();

    // property 'CPUSchedulingResetOnFork'

    /**
     * The method onCPUSchedulingResetOnForkGet() is called by ASF when a
     * client invokes the read method for the property
     * 'CPUSchedulingResetOnFork'. The onCPUSchedulingResetOnForkGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'CPUSchedulingResetOnFork'</b>:
     *
     * CPUSchedulingResetOnFork
     */
    virtual void onCPUSchedulingResetOnForkGet(const ::boost::shared_ptr< CPUSchedulingResetOnForkGet >& payload);

    /**
     * Sends back the update to a previous onCPUSchedulingResetOnForkGet().
     *
     * <b>Documentation of 'CPUSchedulingResetOnFork'</b>:
     *
     * CPUSchedulingResetOnFork
     *
     * @param act Identifies a previous invocation of
     * onCPUSchedulingResetOnForkGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCPUSchedulingResetOnForkGetUpdate(bool cPUSchedulingResetOnFork, act_t act = 0);

    /**
     * Set the value of the property 'CPUSchedulingResetOnFork' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'CPUSchedulingResetOnFork'</b>:
     *
     * CPUSchedulingResetOnFork
     */
    void setCPUSchedulingResetOnFork(bool cPUSchedulingResetOnFork);

    /**
     * Returns the current value of the property 'CPUSchedulingResetOnFork'.
     *
     * <b>Documentation of 'CPUSchedulingResetOnFork'</b>:
     *
     * CPUSchedulingResetOnFork
     */
    bool getCPUSchedulingResetOnFork() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCPUSchedulingResetOnForkUpdate().
     *
     * <b>Documentation of 'CPUSchedulingResetOnFork'</b>:
     *
     * CPUSchedulingResetOnFork
     */
    void sendCPUSchedulingResetOnForkUpdate();

    // property 'NonBlocking'

    /**
     * The method onNonBlockingGet() is called by ASF when a client invokes
     * the read method for the property 'NonBlocking'. The onNonBlockingGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'NonBlocking'</b>:
     *
     * NonBlocking
     */
    virtual void onNonBlockingGet(const ::boost::shared_ptr< NonBlockingGet >& payload);

    /**
     * Sends back the update to a previous onNonBlockingGet().
     *
     * <b>Documentation of 'NonBlocking'</b>:
     *
     * NonBlocking
     *
     * @param act Identifies a previous invocation of onNonBlockingGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNonBlockingGetUpdate(bool nonBlocking, act_t act = 0);

    /**
     * Set the value of the property 'NonBlocking' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'NonBlocking'</b>:
     *
     * NonBlocking
     */
    void setNonBlocking(bool nonBlocking);

    /**
     * Returns the current value of the property 'NonBlocking'.
     *
     * <b>Documentation of 'NonBlocking'</b>:
     *
     * NonBlocking
     */
    bool getNonBlocking() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNonBlockingUpdate().
     *
     * <b>Documentation of 'NonBlocking'</b>:
     *
     * NonBlocking
     */
    void sendNonBlockingUpdate();

    // property 'StandardInput'

    /**
     * The method onStandardInputGet() is called by ASF when a client invokes
     * the read method for the property 'StandardInput'. The
     * onStandardInputGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'StandardInput'</b>:
     *
     * StandardInput
     */
    virtual void onStandardInputGet(const ::boost::shared_ptr< StandardInputGet >& payload);

    /**
     * Sends back the update to a previous onStandardInputGet().
     *
     * <b>Documentation of 'StandardInput'</b>:
     *
     * StandardInput
     *
     * @param act Identifies a previous invocation of onStandardInputGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStandardInputGetUpdate(const ::std::string& standardInput, act_t act = 0);

    /**
     * Set the value of the property 'StandardInput' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StandardInput'</b>:
     *
     * StandardInput
     */
    void setStandardInput(const ::std::string& standardInput);

    /**
     * Returns the current value of the property 'StandardInput'.
     *
     * <b>Documentation of 'StandardInput'</b>:
     *
     * StandardInput
     */
    const ::std::string& getStandardInput() const;

    /**
     * Returns the current value of the property 'StandardInput' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendStandardInputUpdate() method.
     *
     * <b>Documentation of 'StandardInput'</b>:
     *
     * StandardInput
     */
    ::std::string& getStandardInputMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStandardInputUpdate().
     *
     * <b>Documentation of 'StandardInput'</b>:
     *
     * StandardInput
     */
    void sendStandardInputUpdate();

    // property 'StandardOutput'

    /**
     * The method onStandardOutputGet() is called by ASF when a client invokes
     * the read method for the property 'StandardOutput'. The
     * onStandardOutputGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'StandardOutput'</b>:
     *
     * StandardOutput
     */
    virtual void onStandardOutputGet(const ::boost::shared_ptr< StandardOutputGet >& payload);

    /**
     * Sends back the update to a previous onStandardOutputGet().
     *
     * <b>Documentation of 'StandardOutput'</b>:
     *
     * StandardOutput
     *
     * @param act Identifies a previous invocation of onStandardOutputGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStandardOutputGetUpdate(const ::std::string& standardOutput, act_t act = 0);

    /**
     * Set the value of the property 'StandardOutput' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StandardOutput'</b>:
     *
     * StandardOutput
     */
    void setStandardOutput(const ::std::string& standardOutput);

    /**
     * Returns the current value of the property 'StandardOutput'.
     *
     * <b>Documentation of 'StandardOutput'</b>:
     *
     * StandardOutput
     */
    const ::std::string& getStandardOutput() const;

    /**
     * Returns the current value of the property 'StandardOutput' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendStandardOutputUpdate() method.
     *
     * <b>Documentation of 'StandardOutput'</b>:
     *
     * StandardOutput
     */
    ::std::string& getStandardOutputMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStandardOutputUpdate().
     *
     * <b>Documentation of 'StandardOutput'</b>:
     *
     * StandardOutput
     */
    void sendStandardOutputUpdate();

    // property 'StandardError'

    /**
     * The method onStandardErrorGet() is called by ASF when a client invokes
     * the read method for the property 'StandardError'. The
     * onStandardErrorGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'StandardError'</b>:
     *
     * StandardError
     */
    virtual void onStandardErrorGet(const ::boost::shared_ptr< StandardErrorGet >& payload);

    /**
     * Sends back the update to a previous onStandardErrorGet().
     *
     * <b>Documentation of 'StandardError'</b>:
     *
     * StandardError
     *
     * @param act Identifies a previous invocation of onStandardErrorGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStandardErrorGetUpdate(const ::std::string& standardError, act_t act = 0);

    /**
     * Set the value of the property 'StandardError' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StandardError'</b>:
     *
     * StandardError
     */
    void setStandardError(const ::std::string& standardError);

    /**
     * Returns the current value of the property 'StandardError'.
     *
     * <b>Documentation of 'StandardError'</b>:
     *
     * StandardError
     */
    const ::std::string& getStandardError() const;

    /**
     * Returns the current value of the property 'StandardError' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendStandardErrorUpdate() method.
     *
     * <b>Documentation of 'StandardError'</b>:
     *
     * StandardError
     */
    ::std::string& getStandardErrorMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStandardErrorUpdate().
     *
     * <b>Documentation of 'StandardError'</b>:
     *
     * StandardError
     */
    void sendStandardErrorUpdate();

    // property 'TTYPath'

    /**
     * The method onTTYPathGet() is called by ASF when a client invokes the
     * read method for the property 'TTYPath'. The onTTYPathGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'TTYPath'</b>:
     *
     * TTYPath
     */
    virtual void onTTYPathGet(const ::boost::shared_ptr< TTYPathGet >& payload);

    /**
     * Sends back the update to a previous onTTYPathGet().
     *
     * <b>Documentation of 'TTYPath'</b>:
     *
     * TTYPath
     *
     * @param act Identifies a previous invocation of onTTYPathGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTTYPathGetUpdate(bool tTYPath, act_t act = 0);

    /**
     * Set the value of the property 'TTYPath' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'TTYPath'</b>:
     *
     * TTYPath
     */
    void setTTYPath(bool tTYPath);

    /**
     * Returns the current value of the property 'TTYPath'.
     *
     * <b>Documentation of 'TTYPath'</b>:
     *
     * TTYPath
     */
    bool getTTYPath() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTTYPathUpdate().
     *
     * <b>Documentation of 'TTYPath'</b>:
     *
     * TTYPath
     */
    void sendTTYPathUpdate();

    // property 'TTYReset'

    /**
     * The method onTTYResetGet() is called by ASF when a client invokes the
     * read method for the property 'TTYReset'. The onTTYResetGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'TTYReset'</b>:
     *
     * TTYReset
     */
    virtual void onTTYResetGet(const ::boost::shared_ptr< TTYResetGet >& payload);

    /**
     * Sends back the update to a previous onTTYResetGet().
     *
     * <b>Documentation of 'TTYReset'</b>:
     *
     * TTYReset
     *
     * @param act Identifies a previous invocation of onTTYResetGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTTYResetGetUpdate(bool tTYReset, act_t act = 0);

    /**
     * Set the value of the property 'TTYReset' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'TTYReset'</b>:
     *
     * TTYReset
     */
    void setTTYReset(bool tTYReset);

    /**
     * Returns the current value of the property 'TTYReset'.
     *
     * <b>Documentation of 'TTYReset'</b>:
     *
     * TTYReset
     */
    bool getTTYReset() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTTYResetUpdate().
     *
     * <b>Documentation of 'TTYReset'</b>:
     *
     * TTYReset
     */
    void sendTTYResetUpdate();

    // property 'TTYVHangup'

    /**
     * The method onTTYVHangupGet() is called by ASF when a client invokes the
     * read method for the property 'TTYVHangup'. The onTTYVHangupGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'TTYVHangup'</b>:
     *
     * TTYVHangup
     */
    virtual void onTTYVHangupGet(const ::boost::shared_ptr< TTYVHangupGet >& payload);

    /**
     * Sends back the update to a previous onTTYVHangupGet().
     *
     * <b>Documentation of 'TTYVHangup'</b>:
     *
     * TTYVHangup
     *
     * @param act Identifies a previous invocation of onTTYVHangupGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTTYVHangupGetUpdate(bool tTYVHangup, act_t act = 0);

    /**
     * Set the value of the property 'TTYVHangup' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'TTYVHangup'</b>:
     *
     * TTYVHangup
     */
    void setTTYVHangup(bool tTYVHangup);

    /**
     * Returns the current value of the property 'TTYVHangup'.
     *
     * <b>Documentation of 'TTYVHangup'</b>:
     *
     * TTYVHangup
     */
    bool getTTYVHangup() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTTYVHangupUpdate().
     *
     * <b>Documentation of 'TTYVHangup'</b>:
     *
     * TTYVHangup
     */
    void sendTTYVHangupUpdate();

    // property 'TTYVTDisallocate'

    /**
     * The method onTTYVTDisallocateGet() is called by ASF when a client
     * invokes the read method for the property 'TTYVTDisallocate'. The
     * onTTYVTDisallocateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'TTYVTDisallocate'</b>:
     *
     * TTYVTDisallocate
     */
    virtual void onTTYVTDisallocateGet(const ::boost::shared_ptr< TTYVTDisallocateGet >& payload);

    /**
     * Sends back the update to a previous onTTYVTDisallocateGet().
     *
     * <b>Documentation of 'TTYVTDisallocate'</b>:
     *
     * TTYVTDisallocate
     *
     * @param act Identifies a previous invocation of onTTYVTDisallocateGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTTYVTDisallocateGetUpdate(bool tTYVTDisallocate, act_t act = 0);

    /**
     * Set the value of the property 'TTYVTDisallocate' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'TTYVTDisallocate'</b>:
     *
     * TTYVTDisallocate
     */
    void setTTYVTDisallocate(bool tTYVTDisallocate);

    /**
     * Returns the current value of the property 'TTYVTDisallocate'.
     *
     * <b>Documentation of 'TTYVTDisallocate'</b>:
     *
     * TTYVTDisallocate
     */
    bool getTTYVTDisallocate() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTTYVTDisallocateUpdate().
     *
     * <b>Documentation of 'TTYVTDisallocate'</b>:
     *
     * TTYVTDisallocate
     */
    void sendTTYVTDisallocateUpdate();

    // property 'SyslogPriority'

    /**
     * The method onSyslogPriorityGet() is called by ASF when a client invokes
     * the read method for the property 'SyslogPriority'. The
     * onSyslogPriorityGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SyslogPriority'</b>:
     *
     * SyslogPriority
     */
    virtual void onSyslogPriorityGet(const ::boost::shared_ptr< SyslogPriorityGet >& payload);

    /**
     * Sends back the update to a previous onSyslogPriorityGet().
     *
     * <b>Documentation of 'SyslogPriority'</b>:
     *
     * SyslogPriority
     *
     * @param act Identifies a previous invocation of onSyslogPriorityGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSyslogPriorityGetUpdate(int32 syslogPriority, act_t act = 0);

    /**
     * Set the value of the property 'SyslogPriority' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SyslogPriority'</b>:
     *
     * SyslogPriority
     */
    void setSyslogPriority(int32 syslogPriority);

    /**
     * Returns the current value of the property 'SyslogPriority'.
     *
     * <b>Documentation of 'SyslogPriority'</b>:
     *
     * SyslogPriority
     */
    int32 getSyslogPriority() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSyslogPriorityUpdate().
     *
     * <b>Documentation of 'SyslogPriority'</b>:
     *
     * SyslogPriority
     */
    void sendSyslogPriorityUpdate();

    // property 'SyslogIdentifier'

    /**
     * The method onSyslogIdentifierGet() is called by ASF when a client
     * invokes the read method for the property 'SyslogIdentifier'. The
     * onSyslogIdentifierGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SyslogIdentifier'</b>:
     *
     * SyslogIdentifier
     */
    virtual void onSyslogIdentifierGet(const ::boost::shared_ptr< SyslogIdentifierGet >& payload);

    /**
     * Sends back the update to a previous onSyslogIdentifierGet().
     *
     * <b>Documentation of 'SyslogIdentifier'</b>:
     *
     * SyslogIdentifier
     *
     * @param act Identifies a previous invocation of onSyslogIdentifierGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSyslogIdentifierGetUpdate(const ::std::string& syslogIdentifier, act_t act = 0);

    /**
     * Set the value of the property 'SyslogIdentifier' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SyslogIdentifier'</b>:
     *
     * SyslogIdentifier
     */
    void setSyslogIdentifier(const ::std::string& syslogIdentifier);

    /**
     * Returns the current value of the property 'SyslogIdentifier'.
     *
     * <b>Documentation of 'SyslogIdentifier'</b>:
     *
     * SyslogIdentifier
     */
    const ::std::string& getSyslogIdentifier() const;

    /**
     * Returns the current value of the property 'SyslogIdentifier' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSyslogIdentifierUpdate() method.
     *
     * <b>Documentation of 'SyslogIdentifier'</b>:
     *
     * SyslogIdentifier
     */
    ::std::string& getSyslogIdentifierMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSyslogIdentifierUpdate().
     *
     * <b>Documentation of 'SyslogIdentifier'</b>:
     *
     * SyslogIdentifier
     */
    void sendSyslogIdentifierUpdate();

    // property 'SyslogLevelPrefix'

    /**
     * The method onSyslogLevelPrefixGet() is called by ASF when a client
     * invokes the read method for the property 'SyslogLevelPrefix'. The
     * onSyslogLevelPrefixGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SyslogLevelPrefix'</b>:
     *
     * SyslogLevelPrefix
     */
    virtual void onSyslogLevelPrefixGet(const ::boost::shared_ptr< SyslogLevelPrefixGet >& payload);

    /**
     * Sends back the update to a previous onSyslogLevelPrefixGet().
     *
     * <b>Documentation of 'SyslogLevelPrefix'</b>:
     *
     * SyslogLevelPrefix
     *
     * @param act Identifies a previous invocation of
     * onSyslogLevelPrefixGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSyslogLevelPrefixGetUpdate(bool syslogLevelPrefix, act_t act = 0);

    /**
     * Set the value of the property 'SyslogLevelPrefix' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SyslogLevelPrefix'</b>:
     *
     * SyslogLevelPrefix
     */
    void setSyslogLevelPrefix(bool syslogLevelPrefix);

    /**
     * Returns the current value of the property 'SyslogLevelPrefix'.
     *
     * <b>Documentation of 'SyslogLevelPrefix'</b>:
     *
     * SyslogLevelPrefix
     */
    bool getSyslogLevelPrefix() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSyslogLevelPrefixUpdate().
     *
     * <b>Documentation of 'SyslogLevelPrefix'</b>:
     *
     * SyslogLevelPrefix
     */
    void sendSyslogLevelPrefixUpdate();

    // property 'Capabilities'

    /**
     * The method onCapabilitiesGet() is called by ASF when a client invokes
     * the read method for the property 'Capabilities'. The
     * onCapabilitiesGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'Capabilities'</b>:
     *
     * Capabilities
     */
    virtual void onCapabilitiesGet(const ::boost::shared_ptr< CapabilitiesGet >& payload);

    /**
     * Sends back the update to a previous onCapabilitiesGet().
     *
     * <b>Documentation of 'Capabilities'</b>:
     *
     * Capabilities
     *
     * @param act Identifies a previous invocation of onCapabilitiesGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCapabilitiesGetUpdate(const ::std::string& capabilities, act_t act = 0);

    /**
     * Set the value of the property 'Capabilities' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Capabilities'</b>:
     *
     * Capabilities
     */
    void setCapabilities(const ::std::string& capabilities);

    /**
     * Returns the current value of the property 'Capabilities'.
     *
     * <b>Documentation of 'Capabilities'</b>:
     *
     * Capabilities
     */
    const ::std::string& getCapabilities() const;

    /**
     * Returns the current value of the property 'Capabilities' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendCapabilitiesUpdate() method.
     *
     * <b>Documentation of 'Capabilities'</b>:
     *
     * Capabilities
     */
    ::std::string& getCapabilitiesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCapabilitiesUpdate().
     *
     * <b>Documentation of 'Capabilities'</b>:
     *
     * Capabilities
     */
    void sendCapabilitiesUpdate();

    // property 'SecureBits'

    /**
     * The method onSecureBitsGet() is called by ASF when a client invokes the
     * read method for the property 'SecureBits'. The onSecureBitsGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'SecureBits'</b>:
     *
     * SecureBits
     */
    virtual void onSecureBitsGet(const ::boost::shared_ptr< SecureBitsGet >& payload);

    /**
     * Sends back the update to a previous onSecureBitsGet().
     *
     * <b>Documentation of 'SecureBits'</b>:
     *
     * SecureBits
     *
     * @param act Identifies a previous invocation of onSecureBitsGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSecureBitsGetUpdate(int32 secureBits, act_t act = 0);

    /**
     * Set the value of the property 'SecureBits' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SecureBits'</b>:
     *
     * SecureBits
     */
    void setSecureBits(int32 secureBits);

    /**
     * Returns the current value of the property 'SecureBits'.
     *
     * <b>Documentation of 'SecureBits'</b>:
     *
     * SecureBits
     */
    int32 getSecureBits() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSecureBitsUpdate().
     *
     * <b>Documentation of 'SecureBits'</b>:
     *
     * SecureBits
     */
    void sendSecureBitsUpdate();

    // property 'CapabilityBoundingSet'

    /**
     * The method onCapabilityBoundingSetGet() is called by ASF when a client
     * invokes the read method for the property 'CapabilityBoundingSet'. The
     * onCapabilityBoundingSetGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'CapabilityBoundingSet'</b>:
     *
     * CapabilityBoundingSet
     */
    virtual void onCapabilityBoundingSetGet(const ::boost::shared_ptr< CapabilityBoundingSetGet >& payload);

    /**
     * Sends back the update to a previous onCapabilityBoundingSetGet().
     *
     * <b>Documentation of 'CapabilityBoundingSet'</b>:
     *
     * CapabilityBoundingSet
     *
     * @param act Identifies a previous invocation of
     * onCapabilityBoundingSetGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCapabilityBoundingSetGetUpdate(uint64 capabilityBoundingSet, act_t act = 0);

    /**
     * Set the value of the property 'CapabilityBoundingSet' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'CapabilityBoundingSet'</b>:
     *
     * CapabilityBoundingSet
     */
    void setCapabilityBoundingSet(uint64 capabilityBoundingSet);

    /**
     * Returns the current value of the property 'CapabilityBoundingSet'.
     *
     * <b>Documentation of 'CapabilityBoundingSet'</b>:
     *
     * CapabilityBoundingSet
     */
    uint64 getCapabilityBoundingSet() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCapabilityBoundingSetUpdate().
     *
     * <b>Documentation of 'CapabilityBoundingSet'</b>:
     *
     * CapabilityBoundingSet
     */
    void sendCapabilityBoundingSetUpdate();

    // property 'User'

    /**
     * The method onUserGet() is called by ASF when a client invokes the read
     * method for the property 'User'. The onUserGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'User'</b>:
     *
     * User
     */
    virtual void onUserGet(const ::boost::shared_ptr< UserGet >& payload);

    /**
     * Sends back the update to a previous onUserGet().
     *
     * <b>Documentation of 'User'</b>:
     *
     * User
     *
     * @param act Identifies a previous invocation of onUserGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUserGetUpdate(const ::std::string& user, act_t act = 0);

    /**
     * Set the value of the property 'User' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'User'</b>:
     *
     * User
     */
    void setUser(const ::std::string& user);

    /**
     * Returns the current value of the property 'User'.
     *
     * <b>Documentation of 'User'</b>:
     *
     * User
     */
    const ::std::string& getUser() const;

    /**
     * Returns the current value of the property 'User' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendUserUpdate() method.
     *
     * <b>Documentation of 'User'</b>:
     *
     * User
     */
    ::std::string& getUserMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUserUpdate().
     *
     * <b>Documentation of 'User'</b>:
     *
     * User
     */
    void sendUserUpdate();

    // property 'Group'

    /**
     * The method onGroupGet() is called by ASF when a client invokes the read
     * method for the property 'Group'. The onGroupGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Group'</b>:
     *
     * Group
     */
    virtual void onGroupGet(const ::boost::shared_ptr< GroupGet >& payload);

    /**
     * Sends back the update to a previous onGroupGet().
     *
     * <b>Documentation of 'Group'</b>:
     *
     * Group
     *
     * @param act Identifies a previous invocation of onGroupGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGroupGetUpdate(const ::std::string& group, act_t act = 0);

    /**
     * Set the value of the property 'Group' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Group'</b>:
     *
     * Group
     */
    void setGroup(const ::std::string& group);

    /**
     * Returns the current value of the property 'Group'.
     *
     * <b>Documentation of 'Group'</b>:
     *
     * Group
     */
    const ::std::string& getGroup() const;

    /**
     * Returns the current value of the property 'Group' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendGroupUpdate() method.
     *
     * <b>Documentation of 'Group'</b>:
     *
     * Group
     */
    ::std::string& getGroupMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendGroupUpdate().
     *
     * <b>Documentation of 'Group'</b>:
     *
     * Group
     */
    void sendGroupUpdate();

    // property 'SupplementaryGroups'

    /**
     * The method onSupplementaryGroupsGet() is called by ASF when a client
     * invokes the read method for the property 'SupplementaryGroups'. The
     * onSupplementaryGroupsGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'SupplementaryGroups'</b>:
     *
     * SupplementaryGroups
     */
    virtual void onSupplementaryGroupsGet(const ::boost::shared_ptr< SupplementaryGroupsGet >& payload);

    /**
     * Sends back the update to a previous onSupplementaryGroupsGet().
     *
     * <b>Documentation of 'SupplementaryGroups'</b>:
     *
     * SupplementaryGroups
     *
     * @param act Identifies a previous invocation of
     * onSupplementaryGroupsGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSupplementaryGroupsGetUpdate(const ::std::vector< ::std::string >& supplementaryGroups, act_t act = 0);

    /**
     * Set the value of the property 'SupplementaryGroups' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SupplementaryGroups'</b>:
     *
     * SupplementaryGroups
     */
    void setSupplementaryGroups(const ::std::vector< ::std::string >& supplementaryGroups);

    /**
     * Returns the current value of the property 'SupplementaryGroups'.
     *
     * <b>Documentation of 'SupplementaryGroups'</b>:
     *
     * SupplementaryGroups
     */
    const ::std::vector< ::std::string >& getSupplementaryGroups() const;

    /**
     * Returns the current value of the property 'SupplementaryGroups' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSupplementaryGroupsUpdate() method.
     *
     * <b>Documentation of 'SupplementaryGroups'</b>:
     *
     * SupplementaryGroups
     */
    ::std::vector< ::std::string >& getSupplementaryGroupsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSupplementaryGroupsUpdate().
     *
     * <b>Documentation of 'SupplementaryGroups'</b>:
     *
     * SupplementaryGroups
     */
    void sendSupplementaryGroupsUpdate();

    // property 'PAMName'

    /**
     * The method onPAMNameGet() is called by ASF when a client invokes the
     * read method for the property 'PAMName'. The onPAMNameGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'PAMName'</b>:
     *
     * PAMName
     */
    virtual void onPAMNameGet(const ::boost::shared_ptr< PAMNameGet >& payload);

    /**
     * Sends back the update to a previous onPAMNameGet().
     *
     * <b>Documentation of 'PAMName'</b>:
     *
     * PAMName
     *
     * @param act Identifies a previous invocation of onPAMNameGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPAMNameGetUpdate(const ::std::string& pAMName, act_t act = 0);

    /**
     * Set the value of the property 'PAMName' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'PAMName'</b>:
     *
     * PAMName
     */
    void setPAMName(const ::std::string& pAMName);

    /**
     * Returns the current value of the property 'PAMName'.
     *
     * <b>Documentation of 'PAMName'</b>:
     *
     * PAMName
     */
    const ::std::string& getPAMName() const;

    /**
     * Returns the current value of the property 'PAMName' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendPAMNameUpdate() method.
     *
     * <b>Documentation of 'PAMName'</b>:
     *
     * PAMName
     */
    ::std::string& getPAMNameMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPAMNameUpdate().
     *
     * <b>Documentation of 'PAMName'</b>:
     *
     * PAMName
     */
    void sendPAMNameUpdate();

    // property 'ReadWriteDirectories'

    /**
     * The method onReadWriteDirectoriesGet() is called by ASF when a client
     * invokes the read method for the property 'ReadWriteDirectories'. The
     * onReadWriteDirectoriesGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ReadWriteDirectories'</b>:
     *
     * ReadWriteDirectories
     */
    virtual void onReadWriteDirectoriesGet(const ::boost::shared_ptr< ReadWriteDirectoriesGet >& payload);

    /**
     * Sends back the update to a previous onReadWriteDirectoriesGet().
     *
     * <b>Documentation of 'ReadWriteDirectories'</b>:
     *
     * ReadWriteDirectories
     *
     * @param act Identifies a previous invocation of
     * onReadWriteDirectoriesGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReadWriteDirectoriesGetUpdate(const ::std::vector< ::std::string >& readWriteDirectories, act_t act = 0);

    /**
     * Set the value of the property 'ReadWriteDirectories' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'ReadWriteDirectories'</b>:
     *
     * ReadWriteDirectories
     */
    void setReadWriteDirectories(const ::std::vector< ::std::string >& readWriteDirectories);

    /**
     * Returns the current value of the property 'ReadWriteDirectories'.
     *
     * <b>Documentation of 'ReadWriteDirectories'</b>:
     *
     * ReadWriteDirectories
     */
    const ::std::vector< ::std::string >& getReadWriteDirectories() const;

    /**
     * Returns the current value of the property 'ReadWriteDirectories' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendReadWriteDirectoriesUpdate() method.
     *
     * <b>Documentation of 'ReadWriteDirectories'</b>:
     *
     * ReadWriteDirectories
     */
    ::std::vector< ::std::string >& getReadWriteDirectoriesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendReadWriteDirectoriesUpdate().
     *
     * <b>Documentation of 'ReadWriteDirectories'</b>:
     *
     * ReadWriteDirectories
     */
    void sendReadWriteDirectoriesUpdate();

    // property 'ReadOnlyDirectories'

    /**
     * The method onReadOnlyDirectoriesGet() is called by ASF when a client
     * invokes the read method for the property 'ReadOnlyDirectories'. The
     * onReadOnlyDirectoriesGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ReadOnlyDirectories'</b>:
     *
     * ReadOnlyDirectories
     */
    virtual void onReadOnlyDirectoriesGet(const ::boost::shared_ptr< ReadOnlyDirectoriesGet >& payload);

    /**
     * Sends back the update to a previous onReadOnlyDirectoriesGet().
     *
     * <b>Documentation of 'ReadOnlyDirectories'</b>:
     *
     * ReadOnlyDirectories
     *
     * @param act Identifies a previous invocation of
     * onReadOnlyDirectoriesGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReadOnlyDirectoriesGetUpdate(const ::std::vector< ::std::string >& readOnlyDirectories, act_t act = 0);

    /**
     * Set the value of the property 'ReadOnlyDirectories' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ReadOnlyDirectories'</b>:
     *
     * ReadOnlyDirectories
     */
    void setReadOnlyDirectories(const ::std::vector< ::std::string >& readOnlyDirectories);

    /**
     * Returns the current value of the property 'ReadOnlyDirectories'.
     *
     * <b>Documentation of 'ReadOnlyDirectories'</b>:
     *
     * ReadOnlyDirectories
     */
    const ::std::vector< ::std::string >& getReadOnlyDirectories() const;

    /**
     * Returns the current value of the property 'ReadOnlyDirectories' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendReadOnlyDirectoriesUpdate() method.
     *
     * <b>Documentation of 'ReadOnlyDirectories'</b>:
     *
     * ReadOnlyDirectories
     */
    ::std::vector< ::std::string >& getReadOnlyDirectoriesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendReadOnlyDirectoriesUpdate().
     *
     * <b>Documentation of 'ReadOnlyDirectories'</b>:
     *
     * ReadOnlyDirectories
     */
    void sendReadOnlyDirectoriesUpdate();

    // property 'InaccessibleDirectories'

    /**
     * The method onInaccessibleDirectoriesGet() is called by ASF when a
     * client invokes the read method for the property
     * 'InaccessibleDirectories'. The onInaccessibleDirectoriesGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'InaccessibleDirectories'</b>:
     *
     * InaccessibleDirectories
     */
    virtual void onInaccessibleDirectoriesGet(const ::boost::shared_ptr< InaccessibleDirectoriesGet >& payload);

    /**
     * Sends back the update to a previous onInaccessibleDirectoriesGet().
     *
     * <b>Documentation of 'InaccessibleDirectories'</b>:
     *
     * InaccessibleDirectories
     *
     * @param act Identifies a previous invocation of
     * onInaccessibleDirectoriesGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendInaccessibleDirectoriesGetUpdate(const ::std::vector< ::std::string >& inaccessibleDirectories, act_t act = 0);

    /**
     * Set the value of the property 'InaccessibleDirectories' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'InaccessibleDirectories'</b>:
     *
     * InaccessibleDirectories
     */
    void setInaccessibleDirectories(const ::std::vector< ::std::string >& inaccessibleDirectories);

    /**
     * Returns the current value of the property 'InaccessibleDirectories'.
     *
     * <b>Documentation of 'InaccessibleDirectories'</b>:
     *
     * InaccessibleDirectories
     */
    const ::std::vector< ::std::string >& getInaccessibleDirectories() const;

    /**
     * Returns the current value of the property 'InaccessibleDirectories' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendInaccessibleDirectoriesUpdate() method.
     *
     * <b>Documentation of 'InaccessibleDirectories'</b>:
     *
     * InaccessibleDirectories
     */
    ::std::vector< ::std::string >& getInaccessibleDirectoriesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendInaccessibleDirectoriesUpdate().
     *
     * <b>Documentation of 'InaccessibleDirectories'</b>:
     *
     * InaccessibleDirectories
     */
    void sendInaccessibleDirectoriesUpdate();

    // property 'MountFlags'

    /**
     * The method onMountFlagsGet() is called by ASF when a client invokes the
     * read method for the property 'MountFlags'. The onMountFlagsGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'MountFlags'</b>:
     *
     * MountFlags
     */
    virtual void onMountFlagsGet(const ::boost::shared_ptr< MountFlagsGet >& payload);

    /**
     * Sends back the update to a previous onMountFlagsGet().
     *
     * <b>Documentation of 'MountFlags'</b>:
     *
     * MountFlags
     *
     * @param act Identifies a previous invocation of onMountFlagsGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMountFlagsGetUpdate(uint64 mountFlags, act_t act = 0);

    /**
     * Set the value of the property 'MountFlags' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'MountFlags'</b>:
     *
     * MountFlags
     */
    void setMountFlags(uint64 mountFlags);

    /**
     * Returns the current value of the property 'MountFlags'.
     *
     * <b>Documentation of 'MountFlags'</b>:
     *
     * MountFlags
     */
    uint64 getMountFlags() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMountFlagsUpdate().
     *
     * <b>Documentation of 'MountFlags'</b>:
     *
     * MountFlags
     */
    void sendMountFlagsUpdate();

    // property 'PrivateTmp'

    /**
     * The method onPrivateTmpGet() is called by ASF when a client invokes the
     * read method for the property 'PrivateTmp'. The onPrivateTmpGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'PrivateTmp'</b>:
     *
     * PrivateTmp
     */
    virtual void onPrivateTmpGet(const ::boost::shared_ptr< PrivateTmpGet >& payload);

    /**
     * Sends back the update to a previous onPrivateTmpGet().
     *
     * <b>Documentation of 'PrivateTmp'</b>:
     *
     * PrivateTmp
     *
     * @param act Identifies a previous invocation of onPrivateTmpGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPrivateTmpGetUpdate(bool privateTmp, act_t act = 0);

    /**
     * Set the value of the property 'PrivateTmp' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'PrivateTmp'</b>:
     *
     * PrivateTmp
     */
    void setPrivateTmp(bool privateTmp);

    /**
     * Returns the current value of the property 'PrivateTmp'.
     *
     * <b>Documentation of 'PrivateTmp'</b>:
     *
     * PrivateTmp
     */
    bool getPrivateTmp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPrivateTmpUpdate().
     *
     * <b>Documentation of 'PrivateTmp'</b>:
     *
     * PrivateTmp
     */
    void sendPrivateTmpUpdate();

    // property 'PrivateNetwork'

    /**
     * The method onPrivateNetworkGet() is called by ASF when a client invokes
     * the read method for the property 'PrivateNetwork'. The
     * onPrivateNetworkGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'PrivateNetwork'</b>:
     *
     * PrivateNetwork
     */
    virtual void onPrivateNetworkGet(const ::boost::shared_ptr< PrivateNetworkGet >& payload);

    /**
     * Sends back the update to a previous onPrivateNetworkGet().
     *
     * <b>Documentation of 'PrivateNetwork'</b>:
     *
     * PrivateNetwork
     *
     * @param act Identifies a previous invocation of onPrivateNetworkGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPrivateNetworkGetUpdate(bool privateNetwork, act_t act = 0);

    /**
     * Set the value of the property 'PrivateNetwork' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'PrivateNetwork'</b>:
     *
     * PrivateNetwork
     */
    void setPrivateNetwork(bool privateNetwork);

    /**
     * Returns the current value of the property 'PrivateNetwork'.
     *
     * <b>Documentation of 'PrivateNetwork'</b>:
     *
     * PrivateNetwork
     */
    bool getPrivateNetwork() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPrivateNetworkUpdate().
     *
     * <b>Documentation of 'PrivateNetwork'</b>:
     *
     * PrivateNetwork
     */
    void sendPrivateNetworkUpdate();

    // property 'PrivateDevices'

    /**
     * The method onPrivateDevicesGet() is called by ASF when a client invokes
     * the read method for the property 'PrivateDevices'. The
     * onPrivateDevicesGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'PrivateDevices'</b>:
     *
     * PrivateDevices
     */
    virtual void onPrivateDevicesGet(const ::boost::shared_ptr< PrivateDevicesGet >& payload);

    /**
     * Sends back the update to a previous onPrivateDevicesGet().
     *
     * <b>Documentation of 'PrivateDevices'</b>:
     *
     * PrivateDevices
     *
     * @param act Identifies a previous invocation of onPrivateDevicesGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPrivateDevicesGetUpdate(bool privateDevices, act_t act = 0);

    /**
     * Set the value of the property 'PrivateDevices' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'PrivateDevices'</b>:
     *
     * PrivateDevices
     */
    void setPrivateDevices(bool privateDevices);

    /**
     * Returns the current value of the property 'PrivateDevices'.
     *
     * <b>Documentation of 'PrivateDevices'</b>:
     *
     * PrivateDevices
     */
    bool getPrivateDevices() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPrivateDevicesUpdate().
     *
     * <b>Documentation of 'PrivateDevices'</b>:
     *
     * PrivateDevices
     */
    void sendPrivateDevicesUpdate();

    // property 'ProtectHome'

    /**
     * The method onProtectHomeGet() is called by ASF when a client invokes
     * the read method for the property 'ProtectHome'. The onProtectHomeGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'ProtectHome'</b>:
     *
     * ProtectHome
     */
    virtual void onProtectHomeGet(const ::boost::shared_ptr< ProtectHomeGet >& payload);

    /**
     * Sends back the update to a previous onProtectHomeGet().
     *
     * <b>Documentation of 'ProtectHome'</b>:
     *
     * ProtectHome
     *
     * @param act Identifies a previous invocation of onProtectHomeGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendProtectHomeGetUpdate(const ::std::string& protectHome, act_t act = 0);

    /**
     * Set the value of the property 'ProtectHome' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ProtectHome'</b>:
     *
     * ProtectHome
     */
    void setProtectHome(const ::std::string& protectHome);

    /**
     * Returns the current value of the property 'ProtectHome'.
     *
     * <b>Documentation of 'ProtectHome'</b>:
     *
     * ProtectHome
     */
    const ::std::string& getProtectHome() const;

    /**
     * Returns the current value of the property 'ProtectHome' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendProtectHomeUpdate() method.
     *
     * <b>Documentation of 'ProtectHome'</b>:
     *
     * ProtectHome
     */
    ::std::string& getProtectHomeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendProtectHomeUpdate().
     *
     * <b>Documentation of 'ProtectHome'</b>:
     *
     * ProtectHome
     */
    void sendProtectHomeUpdate();

    // property 'ProtectSystem'

    /**
     * The method onProtectSystemGet() is called by ASF when a client invokes
     * the read method for the property 'ProtectSystem'. The
     * onProtectSystemGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ProtectSystem'</b>:
     *
     * ProtectSystem
     */
    virtual void onProtectSystemGet(const ::boost::shared_ptr< ProtectSystemGet >& payload);

    /**
     * Sends back the update to a previous onProtectSystemGet().
     *
     * <b>Documentation of 'ProtectSystem'</b>:
     *
     * ProtectSystem
     *
     * @param act Identifies a previous invocation of onProtectSystemGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendProtectSystemGetUpdate(const ::std::string& protectSystem, act_t act = 0);

    /**
     * Set the value of the property 'ProtectSystem' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ProtectSystem'</b>:
     *
     * ProtectSystem
     */
    void setProtectSystem(const ::std::string& protectSystem);

    /**
     * Returns the current value of the property 'ProtectSystem'.
     *
     * <b>Documentation of 'ProtectSystem'</b>:
     *
     * ProtectSystem
     */
    const ::std::string& getProtectSystem() const;

    /**
     * Returns the current value of the property 'ProtectSystem' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendProtectSystemUpdate() method.
     *
     * <b>Documentation of 'ProtectSystem'</b>:
     *
     * ProtectSystem
     */
    ::std::string& getProtectSystemMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendProtectSystemUpdate().
     *
     * <b>Documentation of 'ProtectSystem'</b>:
     *
     * ProtectSystem
     */
    void sendProtectSystemUpdate();

    // property 'SameProcessGroup'

    /**
     * The method onSameProcessGroupGet() is called by ASF when a client
     * invokes the read method for the property 'SameProcessGroup'. The
     * onSameProcessGroupGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SameProcessGroup'</b>:
     *
     * SameProcessGroup
     */
    virtual void onSameProcessGroupGet(const ::boost::shared_ptr< SameProcessGroupGet >& payload);

    /**
     * Sends back the update to a previous onSameProcessGroupGet().
     *
     * <b>Documentation of 'SameProcessGroup'</b>:
     *
     * SameProcessGroup
     *
     * @param act Identifies a previous invocation of onSameProcessGroupGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSameProcessGroupGetUpdate(bool sameProcessGroup, act_t act = 0);

    /**
     * Set the value of the property 'SameProcessGroup' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SameProcessGroup'</b>:
     *
     * SameProcessGroup
     */
    void setSameProcessGroup(bool sameProcessGroup);

    /**
     * Returns the current value of the property 'SameProcessGroup'.
     *
     * <b>Documentation of 'SameProcessGroup'</b>:
     *
     * SameProcessGroup
     */
    bool getSameProcessGroup() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSameProcessGroupUpdate().
     *
     * <b>Documentation of 'SameProcessGroup'</b>:
     *
     * SameProcessGroup
     */
    void sendSameProcessGroupUpdate();

    // property 'UtmpIdentifier'

    /**
     * The method onUtmpIdentifierGet() is called by ASF when a client invokes
     * the read method for the property 'UtmpIdentifier'. The
     * onUtmpIdentifierGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'UtmpIdentifier'</b>:
     *
     * UtmpIdentifier
     */
    virtual void onUtmpIdentifierGet(const ::boost::shared_ptr< UtmpIdentifierGet >& payload);

    /**
     * Sends back the update to a previous onUtmpIdentifierGet().
     *
     * <b>Documentation of 'UtmpIdentifier'</b>:
     *
     * UtmpIdentifier
     *
     * @param act Identifies a previous invocation of onUtmpIdentifierGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendUtmpIdentifierGetUpdate(const ::std::string& utmpIdentifier, act_t act = 0);

    /**
     * Set the value of the property 'UtmpIdentifier' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'UtmpIdentifier'</b>:
     *
     * UtmpIdentifier
     */
    void setUtmpIdentifier(const ::std::string& utmpIdentifier);

    /**
     * Returns the current value of the property 'UtmpIdentifier'.
     *
     * <b>Documentation of 'UtmpIdentifier'</b>:
     *
     * UtmpIdentifier
     */
    const ::std::string& getUtmpIdentifier() const;

    /**
     * Returns the current value of the property 'UtmpIdentifier' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendUtmpIdentifierUpdate() method.
     *
     * <b>Documentation of 'UtmpIdentifier'</b>:
     *
     * UtmpIdentifier
     */
    ::std::string& getUtmpIdentifierMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUtmpIdentifierUpdate().
     *
     * <b>Documentation of 'UtmpIdentifier'</b>:
     *
     * UtmpIdentifier
     */
    void sendUtmpIdentifierUpdate();

    // property 'UtmpMode'

    /**
     * The method onUtmpModeGet() is called by ASF when a client invokes the
     * read method for the property 'UtmpMode'. The onUtmpModeGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'UtmpMode'</b>:
     *
     * UtmpMode
     */
    virtual void onUtmpModeGet(const ::boost::shared_ptr< UtmpModeGet >& payload);

    /**
     * Sends back the update to a previous onUtmpModeGet().
     *
     * <b>Documentation of 'UtmpMode'</b>:
     *
     * UtmpMode
     *
     * @param act Identifies a previous invocation of onUtmpModeGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUtmpModeGetUpdate(const ::std::string& utmpMode, act_t act = 0);

    /**
     * Set the value of the property 'UtmpMode' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'UtmpMode'</b>:
     *
     * UtmpMode
     */
    void setUtmpMode(const ::std::string& utmpMode);

    /**
     * Returns the current value of the property 'UtmpMode'.
     *
     * <b>Documentation of 'UtmpMode'</b>:
     *
     * UtmpMode
     */
    const ::std::string& getUtmpMode() const;

    /**
     * Returns the current value of the property 'UtmpMode' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendUtmpModeUpdate() method.
     *
     * <b>Documentation of 'UtmpMode'</b>:
     *
     * UtmpMode
     */
    ::std::string& getUtmpModeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUtmpModeUpdate().
     *
     * <b>Documentation of 'UtmpMode'</b>:
     *
     * UtmpMode
     */
    void sendUtmpModeUpdate();

    // property 'SELinuxContext'

    /**
     * The method onSELinuxContextGet() is called by ASF when a client invokes
     * the read method for the property 'SELinuxContext'. The
     * onSELinuxContextGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SELinuxContext'</b>:
     *
     * SELinuxContext
     */
    virtual void onSELinuxContextGet(const ::boost::shared_ptr< SELinuxContextGet >& payload);

    /**
     * Sends back the update to a previous onSELinuxContextGet().
     *
     * <b>Documentation of 'SELinuxContext'</b>:
     *
     * SELinuxContext
     *
     * @param act Identifies a previous invocation of onSELinuxContextGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSELinuxContextGetUpdate(const securityContext& sELinuxContext, act_t act = 0);

    /**
     * Set the value of the property 'SELinuxContext' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SELinuxContext'</b>:
     *
     * SELinuxContext
     */
    void setSELinuxContext(const securityContext& sELinuxContext);

    /**
     * Returns the current value of the property 'SELinuxContext'.
     *
     * <b>Documentation of 'SELinuxContext'</b>:
     *
     * SELinuxContext
     */
    const securityContext& getSELinuxContext() const;

    /**
     * Returns the current value of the property 'SELinuxContext' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSELinuxContextUpdate() method.
     *
     * <b>Documentation of 'SELinuxContext'</b>:
     *
     * SELinuxContext
     */
    securityContext& getSELinuxContextMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSELinuxContextUpdate().
     *
     * <b>Documentation of 'SELinuxContext'</b>:
     *
     * SELinuxContext
     */
    void sendSELinuxContextUpdate();

    // property 'AppArmorProfile'

    /**
     * The method onAppArmorProfileGet() is called by ASF when a client
     * invokes the read method for the property 'AppArmorProfile'. The
     * onAppArmorProfileGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'AppArmorProfile'</b>:
     *
     * AppArmorProfile
     */
    virtual void onAppArmorProfileGet(const ::boost::shared_ptr< AppArmorProfileGet >& payload);

    /**
     * Sends back the update to a previous onAppArmorProfileGet().
     *
     * <b>Documentation of 'AppArmorProfile'</b>:
     *
     * AppArmorProfile
     *
     * @param act Identifies a previous invocation of onAppArmorProfileGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAppArmorProfileGetUpdate(const ArmorProfile& appArmorProfile, act_t act = 0);

    /**
     * Set the value of the property 'AppArmorProfile' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AppArmorProfile'</b>:
     *
     * AppArmorProfile
     */
    void setAppArmorProfile(const ArmorProfile& appArmorProfile);

    /**
     * Returns the current value of the property 'AppArmorProfile'.
     *
     * <b>Documentation of 'AppArmorProfile'</b>:
     *
     * AppArmorProfile
     */
    const ArmorProfile& getAppArmorProfile() const;

    /**
     * Returns the current value of the property 'AppArmorProfile' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendAppArmorProfileUpdate() method.
     *
     * <b>Documentation of 'AppArmorProfile'</b>:
     *
     * AppArmorProfile
     */
    ArmorProfile& getAppArmorProfileMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAppArmorProfileUpdate().
     *
     * <b>Documentation of 'AppArmorProfile'</b>:
     *
     * AppArmorProfile
     */
    void sendAppArmorProfileUpdate();

    // property 'SmackProcessLabel'

    /**
     * The method onSmackProcessLabelGet() is called by ASF when a client
     * invokes the read method for the property 'SmackProcessLabel'. The
     * onSmackProcessLabelGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SmackProcessLabel'</b>:
     *
     * SmackProcessLabel
     */
    virtual void onSmackProcessLabelGet(const ::boost::shared_ptr< SmackProcessLabelGet >& payload);

    /**
     * Sends back the update to a previous onSmackProcessLabelGet().
     *
     * <b>Documentation of 'SmackProcessLabel'</b>:
     *
     * SmackProcessLabel
     *
     * @param act Identifies a previous invocation of
     * onSmackProcessLabelGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSmackProcessLabelGetUpdate(const ProcessLabel& smackProcessLabel, act_t act = 0);

    /**
     * Set the value of the property 'SmackProcessLabel' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SmackProcessLabel'</b>:
     *
     * SmackProcessLabel
     */
    void setSmackProcessLabel(const ProcessLabel& smackProcessLabel);

    /**
     * Returns the current value of the property 'SmackProcessLabel'.
     *
     * <b>Documentation of 'SmackProcessLabel'</b>:
     *
     * SmackProcessLabel
     */
    const ProcessLabel& getSmackProcessLabel() const;

    /**
     * Returns the current value of the property 'SmackProcessLabel' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSmackProcessLabelUpdate() method.
     *
     * <b>Documentation of 'SmackProcessLabel'</b>:
     *
     * SmackProcessLabel
     */
    ProcessLabel& getSmackProcessLabelMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSmackProcessLabelUpdate().
     *
     * <b>Documentation of 'SmackProcessLabel'</b>:
     *
     * SmackProcessLabel
     */
    void sendSmackProcessLabelUpdate();

    // property 'IgnoreSIGPIPE'

    /**
     * The method onIgnoreSIGPIPEGet() is called by ASF when a client invokes
     * the read method for the property 'IgnoreSIGPIPE'. The
     * onIgnoreSIGPIPEGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'IgnoreSIGPIPE'</b>:
     *
     * IgnoreSIGPIPE
     */
    virtual void onIgnoreSIGPIPEGet(const ::boost::shared_ptr< IgnoreSIGPIPEGet >& payload);

    /**
     * Sends back the update to a previous onIgnoreSIGPIPEGet().
     *
     * <b>Documentation of 'IgnoreSIGPIPE'</b>:
     *
     * IgnoreSIGPIPE
     *
     * @param act Identifies a previous invocation of onIgnoreSIGPIPEGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendIgnoreSIGPIPEGetUpdate(bool ignoreSIGPIPE, act_t act = 0);

    /**
     * Set the value of the property 'IgnoreSIGPIPE' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'IgnoreSIGPIPE'</b>:
     *
     * IgnoreSIGPIPE
     */
    void setIgnoreSIGPIPE(bool ignoreSIGPIPE);

    /**
     * Returns the current value of the property 'IgnoreSIGPIPE'.
     *
     * <b>Documentation of 'IgnoreSIGPIPE'</b>:
     *
     * IgnoreSIGPIPE
     */
    bool getIgnoreSIGPIPE() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIgnoreSIGPIPEUpdate().
     *
     * <b>Documentation of 'IgnoreSIGPIPE'</b>:
     *
     * IgnoreSIGPIPE
     */
    void sendIgnoreSIGPIPEUpdate();

    // property 'NoNewPrivileges'

    /**
     * The method onNoNewPrivilegesGet() is called by ASF when a client
     * invokes the read method for the property 'NoNewPrivileges'. The
     * onNoNewPrivilegesGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'NoNewPrivileges'</b>:
     *
     * NoNewPrivileges
     */
    virtual void onNoNewPrivilegesGet(const ::boost::shared_ptr< NoNewPrivilegesGet >& payload);

    /**
     * Sends back the update to a previous onNoNewPrivilegesGet().
     *
     * <b>Documentation of 'NoNewPrivileges'</b>:
     *
     * NoNewPrivileges
     *
     * @param act Identifies a previous invocation of onNoNewPrivilegesGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNoNewPrivilegesGetUpdate(bool noNewPrivileges, act_t act = 0);

    /**
     * Set the value of the property 'NoNewPrivileges' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'NoNewPrivileges'</b>:
     *
     * NoNewPrivileges
     */
    void setNoNewPrivileges(bool noNewPrivileges);

    /**
     * Returns the current value of the property 'NoNewPrivileges'.
     *
     * <b>Documentation of 'NoNewPrivileges'</b>:
     *
     * NoNewPrivileges
     */
    bool getNoNewPrivileges() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNoNewPrivilegesUpdate().
     *
     * <b>Documentation of 'NoNewPrivileges'</b>:
     *
     * NoNewPrivileges
     */
    void sendNoNewPrivilegesUpdate();

    // property 'SystemCallFilter'

    /**
     * The method onSystemCallFilterGet() is called by ASF when a client
     * invokes the read method for the property 'SystemCallFilter'. The
     * onSystemCallFilterGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SystemCallFilter'</b>:
     *
     * SystemCallFilter
     */
    virtual void onSystemCallFilterGet(const ::boost::shared_ptr< SystemCallFilterGet >& payload);

    /**
     * Sends back the update to a previous onSystemCallFilterGet().
     *
     * <b>Documentation of 'SystemCallFilter'</b>:
     *
     * SystemCallFilter
     *
     * @param act Identifies a previous invocation of onSystemCallFilterGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSystemCallFilterGetUpdate(const systemCallFilter& systemCallFilter, act_t act = 0);

    /**
     * Set the value of the property 'SystemCallFilter' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SystemCallFilter'</b>:
     *
     * SystemCallFilter
     */
    void setSystemCallFilter(const systemCallFilter& systemCallFilter);

    /**
     * Returns the current value of the property 'SystemCallFilter'.
     *
     * <b>Documentation of 'SystemCallFilter'</b>:
     *
     * SystemCallFilter
     */
    const systemCallFilter& getSystemCallFilter() const;

    /**
     * Returns the current value of the property 'SystemCallFilter' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSystemCallFilterUpdate() method.
     *
     * <b>Documentation of 'SystemCallFilter'</b>:
     *
     * SystemCallFilter
     */
    systemCallFilter& getSystemCallFilterMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSystemCallFilterUpdate().
     *
     * <b>Documentation of 'SystemCallFilter'</b>:
     *
     * SystemCallFilter
     */
    void sendSystemCallFilterUpdate();

    // property 'SystemCallArchitectures'

    /**
     * The method onSystemCallArchitecturesGet() is called by ASF when a
     * client invokes the read method for the property
     * 'SystemCallArchitectures'. The onSystemCallArchitecturesGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'SystemCallArchitectures'</b>:
     *
     * SystemCallArchitectures
     */
    virtual void onSystemCallArchitecturesGet(const ::boost::shared_ptr< SystemCallArchitecturesGet >& payload);

    /**
     * Sends back the update to a previous onSystemCallArchitecturesGet().
     *
     * <b>Documentation of 'SystemCallArchitectures'</b>:
     *
     * SystemCallArchitectures
     *
     * @param act Identifies a previous invocation of
     * onSystemCallArchitecturesGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSystemCallArchitecturesGetUpdate(const ::std::vector< ::std::string >& systemCallArchitectures, act_t act = 0);

    /**
     * Set the value of the property 'SystemCallArchitectures' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'SystemCallArchitectures'</b>:
     *
     * SystemCallArchitectures
     */
    void setSystemCallArchitectures(const ::std::vector< ::std::string >& systemCallArchitectures);

    /**
     * Returns the current value of the property 'SystemCallArchitectures'.
     *
     * <b>Documentation of 'SystemCallArchitectures'</b>:
     *
     * SystemCallArchitectures
     */
    const ::std::vector< ::std::string >& getSystemCallArchitectures() const;

    /**
     * Returns the current value of the property 'SystemCallArchitectures' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendSystemCallArchitecturesUpdate() method.
     *
     * <b>Documentation of 'SystemCallArchitectures'</b>:
     *
     * SystemCallArchitectures
     */
    ::std::vector< ::std::string >& getSystemCallArchitecturesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSystemCallArchitecturesUpdate().
     *
     * <b>Documentation of 'SystemCallArchitectures'</b>:
     *
     * SystemCallArchitectures
     */
    void sendSystemCallArchitecturesUpdate();

    // property 'SystemCallErrorNumber'

    /**
     * The method onSystemCallErrorNumberGet() is called by ASF when a client
     * invokes the read method for the property 'SystemCallErrorNumber'. The
     * onSystemCallErrorNumberGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'SystemCallErrorNumber'</b>:
     *
     * SystemCallErrorNumber
     */
    virtual void onSystemCallErrorNumberGet(const ::boost::shared_ptr< SystemCallErrorNumberGet >& payload);

    /**
     * Sends back the update to a previous onSystemCallErrorNumberGet().
     *
     * <b>Documentation of 'SystemCallErrorNumber'</b>:
     *
     * SystemCallErrorNumber
     *
     * @param act Identifies a previous invocation of
     * onSystemCallErrorNumberGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSystemCallErrorNumberGetUpdate(int32 systemCallErrorNumber, act_t act = 0);

    /**
     * Set the value of the property 'SystemCallErrorNumber' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'SystemCallErrorNumber'</b>:
     *
     * SystemCallErrorNumber
     */
    void setSystemCallErrorNumber(int32 systemCallErrorNumber);

    /**
     * Returns the current value of the property 'SystemCallErrorNumber'.
     *
     * <b>Documentation of 'SystemCallErrorNumber'</b>:
     *
     * SystemCallErrorNumber
     */
    int32 getSystemCallErrorNumber() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSystemCallErrorNumberUpdate().
     *
     * <b>Documentation of 'SystemCallErrorNumber'</b>:
     *
     * SystemCallErrorNumber
     */
    void sendSystemCallErrorNumberUpdate();

    // property 'Personality'

    /**
     * The method onPersonalityGet() is called by ASF when a client invokes
     * the read method for the property 'Personality'. The onPersonalityGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'Personality'</b>:
     *
     * Personality
     */
    virtual void onPersonalityGet(const ::boost::shared_ptr< PersonalityGet >& payload);

    /**
     * Sends back the update to a previous onPersonalityGet().
     *
     * <b>Documentation of 'Personality'</b>:
     *
     * Personality
     *
     * @param act Identifies a previous invocation of onPersonalityGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPersonalityGetUpdate(const ::std::string& personality, act_t act = 0);

    /**
     * Set the value of the property 'Personality' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Personality'</b>:
     *
     * Personality
     */
    void setPersonality(const ::std::string& personality);

    /**
     * Returns the current value of the property 'Personality'.
     *
     * <b>Documentation of 'Personality'</b>:
     *
     * Personality
     */
    const ::std::string& getPersonality() const;

    /**
     * Returns the current value of the property 'Personality' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendPersonalityUpdate() method.
     *
     * <b>Documentation of 'Personality'</b>:
     *
     * Personality
     */
    ::std::string& getPersonalityMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPersonalityUpdate().
     *
     * <b>Documentation of 'Personality'</b>:
     *
     * Personality
     */
    void sendPersonalityUpdate();

    // property 'RestrictAddressFamilies'

    /**
     * The method onRestrictAddressFamiliesGet() is called by ASF when a
     * client invokes the read method for the property
     * 'RestrictAddressFamilies'. The onRestrictAddressFamiliesGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'RestrictAddressFamilies'</b>:
     *
     * RestrictAddressFamilies
     */
    virtual void onRestrictAddressFamiliesGet(const ::boost::shared_ptr< RestrictAddressFamiliesGet >& payload);

    /**
     * Sends back the update to a previous onRestrictAddressFamiliesGet().
     *
     * <b>Documentation of 'RestrictAddressFamilies'</b>:
     *
     * RestrictAddressFamilies
     *
     * @param act Identifies a previous invocation of
     * onRestrictAddressFamiliesGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRestrictAddressFamiliesGetUpdate(const AddressFamily& restrictAddressFamilies, act_t act = 0);

    /**
     * Set the value of the property 'RestrictAddressFamilies' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'RestrictAddressFamilies'</b>:
     *
     * RestrictAddressFamilies
     */
    void setRestrictAddressFamilies(const AddressFamily& restrictAddressFamilies);

    /**
     * Returns the current value of the property 'RestrictAddressFamilies'.
     *
     * <b>Documentation of 'RestrictAddressFamilies'</b>:
     *
     * RestrictAddressFamilies
     */
    const AddressFamily& getRestrictAddressFamilies() const;

    /**
     * Returns the current value of the property 'RestrictAddressFamilies' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendRestrictAddressFamiliesUpdate() method.
     *
     * <b>Documentation of 'RestrictAddressFamilies'</b>:
     *
     * RestrictAddressFamilies
     */
    AddressFamily& getRestrictAddressFamiliesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRestrictAddressFamiliesUpdate().
     *
     * <b>Documentation of 'RestrictAddressFamilies'</b>:
     *
     * RestrictAddressFamilies
     */
    void sendRestrictAddressFamiliesUpdate();

    // property 'RuntimeDirectoryMode'

    /**
     * The method onRuntimeDirectoryModeGet() is called by ASF when a client
     * invokes the read method for the property 'RuntimeDirectoryMode'. The
     * onRuntimeDirectoryModeGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'RuntimeDirectoryMode'</b>:
     *
     * RuntimeDirectoryMode
     */
    virtual void onRuntimeDirectoryModeGet(const ::boost::shared_ptr< RuntimeDirectoryModeGet >& payload);

    /**
     * Sends back the update to a previous onRuntimeDirectoryModeGet().
     *
     * <b>Documentation of 'RuntimeDirectoryMode'</b>:
     *
     * RuntimeDirectoryMode
     *
     * @param act Identifies a previous invocation of
     * onRuntimeDirectoryModeGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRuntimeDirectoryModeGetUpdate(uint32 runtimeDirectoryMode, act_t act = 0);

    /**
     * Set the value of the property 'RuntimeDirectoryMode' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'RuntimeDirectoryMode'</b>:
     *
     * RuntimeDirectoryMode
     */
    void setRuntimeDirectoryMode(uint32 runtimeDirectoryMode);

    /**
     * Returns the current value of the property 'RuntimeDirectoryMode'.
     *
     * <b>Documentation of 'RuntimeDirectoryMode'</b>:
     *
     * RuntimeDirectoryMode
     */
    uint32 getRuntimeDirectoryMode() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRuntimeDirectoryModeUpdate().
     *
     * <b>Documentation of 'RuntimeDirectoryMode'</b>:
     *
     * RuntimeDirectoryMode
     */
    void sendRuntimeDirectoryModeUpdate();

    // property 'RuntimeDirectory'

    /**
     * The method onRuntimeDirectoryGet() is called by ASF when a client
     * invokes the read method for the property 'RuntimeDirectory'. The
     * onRuntimeDirectoryGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RuntimeDirectory'</b>:
     *
     * RuntimeDirectory
     */
    virtual void onRuntimeDirectoryGet(const ::boost::shared_ptr< RuntimeDirectoryGet >& payload);

    /**
     * Sends back the update to a previous onRuntimeDirectoryGet().
     *
     * <b>Documentation of 'RuntimeDirectory'</b>:
     *
     * RuntimeDirectory
     *
     * @param act Identifies a previous invocation of onRuntimeDirectoryGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRuntimeDirectoryGetUpdate(const ::std::vector< ::std::string >& runtimeDirectory, act_t act = 0);

    /**
     * Set the value of the property 'RuntimeDirectory' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RuntimeDirectory'</b>:
     *
     * RuntimeDirectory
     */
    void setRuntimeDirectory(const ::std::vector< ::std::string >& runtimeDirectory);

    /**
     * Returns the current value of the property 'RuntimeDirectory'.
     *
     * <b>Documentation of 'RuntimeDirectory'</b>:
     *
     * RuntimeDirectory
     */
    const ::std::vector< ::std::string >& getRuntimeDirectory() const;

    /**
     * Returns the current value of the property 'RuntimeDirectory' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendRuntimeDirectoryUpdate() method.
     *
     * <b>Documentation of 'RuntimeDirectory'</b>:
     *
     * RuntimeDirectory
     */
    ::std::vector< ::std::string >& getRuntimeDirectoryMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRuntimeDirectoryUpdate().
     *
     * <b>Documentation of 'RuntimeDirectory'</b>:
     *
     * RuntimeDirectory
     */
    void sendRuntimeDirectoryUpdate();

    // property 'KillMode'

    /**
     * The method onKillModeGet() is called by ASF when a client invokes the
     * read method for the property 'KillMode'. The onKillModeGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'KillMode'</b>:
     *
     * KillMode
     */
    virtual void onKillModeGet(const ::boost::shared_ptr< KillModeGet >& payload);

    /**
     * Sends back the update to a previous onKillModeGet().
     *
     * <b>Documentation of 'KillMode'</b>:
     *
     * KillMode
     *
     * @param act Identifies a previous invocation of onKillModeGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendKillModeGetUpdate(const ::std::string& killMode, act_t act = 0);

    /**
     * Set the value of the property 'KillMode' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'KillMode'</b>:
     *
     * KillMode
     */
    void setKillMode(const ::std::string& killMode);

    /**
     * Returns the current value of the property 'KillMode'.
     *
     * <b>Documentation of 'KillMode'</b>:
     *
     * KillMode
     */
    const ::std::string& getKillMode() const;

    /**
     * Returns the current value of the property 'KillMode' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendKillModeUpdate() method.
     *
     * <b>Documentation of 'KillMode'</b>:
     *
     * KillMode
     */
    ::std::string& getKillModeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendKillModeUpdate().
     *
     * <b>Documentation of 'KillMode'</b>:
     *
     * KillMode
     */
    void sendKillModeUpdate();

    // property 'KillSignal'

    /**
     * The method onKillSignalGet() is called by ASF when a client invokes the
     * read method for the property 'KillSignal'. The onKillSignalGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'KillSignal'</b>:
     *
     * KillSignal
     */
    virtual void onKillSignalGet(const ::boost::shared_ptr< KillSignalGet >& payload);

    /**
     * Sends back the update to a previous onKillSignalGet().
     *
     * <b>Documentation of 'KillSignal'</b>:
     *
     * KillSignal
     *
     * @param act Identifies a previous invocation of onKillSignalGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendKillSignalGetUpdate(int32 killSignal, act_t act = 0);

    /**
     * Set the value of the property 'KillSignal' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'KillSignal'</b>:
     *
     * KillSignal
     */
    void setKillSignal(int32 killSignal);

    /**
     * Returns the current value of the property 'KillSignal'.
     *
     * <b>Documentation of 'KillSignal'</b>:
     *
     * KillSignal
     */
    int32 getKillSignal() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendKillSignalUpdate().
     *
     * <b>Documentation of 'KillSignal'</b>:
     *
     * KillSignal
     */
    void sendKillSignalUpdate();

    // property 'SendSIGKILL'

    /**
     * The method onSendSIGKILLGet() is called by ASF when a client invokes
     * the read method for the property 'SendSIGKILL'. The onSendSIGKILLGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'SendSIGKILL'</b>:
     *
     * SendSIGKILL
     */
    virtual void onSendSIGKILLGet(const ::boost::shared_ptr< SendSIGKILLGet >& payload);

    /**
     * Sends back the update to a previous onSendSIGKILLGet().
     *
     * <b>Documentation of 'SendSIGKILL'</b>:
     *
     * SendSIGKILL
     *
     * @param act Identifies a previous invocation of onSendSIGKILLGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSendSIGKILLGetUpdate(bool sendSIGKILL, act_t act = 0);

    /**
     * Set the value of the property 'SendSIGKILL' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SendSIGKILL'</b>:
     *
     * SendSIGKILL
     */
    void setSendSIGKILL(bool sendSIGKILL);

    /**
     * Returns the current value of the property 'SendSIGKILL'.
     *
     * <b>Documentation of 'SendSIGKILL'</b>:
     *
     * SendSIGKILL
     */
    bool getSendSIGKILL() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSendSIGKILLUpdate().
     *
     * <b>Documentation of 'SendSIGKILL'</b>:
     *
     * SendSIGKILL
     */
    void sendSendSIGKILLUpdate();

    // property 'SendSIGHUP'

    /**
     * The method onSendSIGHUPGet() is called by ASF when a client invokes the
     * read method for the property 'SendSIGHUP'. The onSendSIGHUPGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'SendSIGHUP'</b>:
     *
     * SendSIGHUP
     */
    virtual void onSendSIGHUPGet(const ::boost::shared_ptr< SendSIGHUPGet >& payload);

    /**
     * Sends back the update to a previous onSendSIGHUPGet().
     *
     * <b>Documentation of 'SendSIGHUP'</b>:
     *
     * SendSIGHUP
     *
     * @param act Identifies a previous invocation of onSendSIGHUPGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSendSIGHUPGetUpdate(bool sendSIGHUP, act_t act = 0);

    /**
     * Set the value of the property 'SendSIGHUP' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SendSIGHUP'</b>:
     *
     * SendSIGHUP
     */
    void setSendSIGHUP(bool sendSIGHUP);

    /**
     * Returns the current value of the property 'SendSIGHUP'.
     *
     * <b>Documentation of 'SendSIGHUP'</b>:
     *
     * SendSIGHUP
     */
    bool getSendSIGHUP() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSendSIGHUPUpdate().
     *
     * <b>Documentation of 'SendSIGHUP'</b>:
     *
     * SendSIGHUP
     */
    void sendSendSIGHUPUpdate();

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    TypeUpdate _TypeProperty;

    RestartUpdate _RestartProperty;

    PIDFileUpdate _PIDFileProperty;

    NotifyAccessUpdate _NotifyAccessProperty;

    RestartUSecUpdate _RestartUSecProperty;

    TimeoutStartUSecUpdate _TimeoutStartUSecProperty;

    TimeoutStopUSecUpdate _TimeoutStopUSecProperty;

    WatchdogUSecUpdate _WatchdogUSecProperty;

    WatchdogTimestampUpdate _WatchdogTimestampProperty;

    WatchdogTimestampMonotonicUpdate _WatchdogTimestampMonotonicProperty;

    StartLimitIntervalUpdate _StartLimitIntervalProperty;

    StartLimitBurstUpdate _StartLimitBurstProperty;

    StartLimitActionUpdate _StartLimitActionProperty;

    RebootArgumentUpdate _RebootArgumentProperty;

    FailureActionUpdate _FailureActionProperty;

    PermissionsStartOnlyUpdate _PermissionsStartOnlyProperty;

    RootDirectoryStartOnlyUpdate _RootDirectoryStartOnlyProperty;

    RemainAfterExitUpdate _RemainAfterExitProperty;

    GuessMainPIDUpdate _GuessMainPIDProperty;

    MainPIDUpdate _MainPIDProperty;

    ControlPIDUpdate _ControlPIDProperty;

    BusNameUpdate _BusNameProperty;

    FileDescriptorStoreMaxUpdate _FileDescriptorStoreMaxProperty;

    StatusTextUpdate _StatusTextProperty;

    StatusErrnoUpdate _StatusErrnoProperty;

    ResultUpdate _ResultProperty;

    ExecMainStartTimestampUpdate _ExecMainStartTimestampProperty;

    ExecMainStartTimestampMonotonicUpdate _ExecMainStartTimestampMonotonicProperty;

    ExecMainExitTimestampUpdate _ExecMainExitTimestampProperty;

    ExecMainExitTimestampMonotonicUpdate _ExecMainExitTimestampMonotonicProperty;

    ExecMainPIDUpdate _ExecMainPIDProperty;

    ExecMainCodeUpdate _ExecMainCodeProperty;

    ExecMainStatusUpdate _ExecMainStatusProperty;

    ExecStartPreUpdate _ExecStartPreProperty;

    ExecStartUpdate _ExecStartProperty;

    ExecStartPostUpdate _ExecStartPostProperty;

    ExecReloadUpdate _ExecReloadProperty;

    ExecStopUpdate _ExecStopProperty;

    ExecStopPostUpdate _ExecStopPostProperty;

    SliceUpdate _SliceProperty;

    ControlGroupUpdate _ControlGroupProperty;

    MemoryCurrentUpdate _MemoryCurrentProperty;

    CPUUsageNSecUpdate _CPUUsageNSecProperty;

    DelegateUpdate _DelegateProperty;

    CPUAccountingUpdate _CPUAccountingProperty;

    CPUSharesUpdate _CPUSharesProperty;

    StartupCPUSharesUpdate _StartupCPUSharesProperty;

    CPUQuotaPerSecUSecUpdate _CPUQuotaPerSecUSecProperty;

    BlockIOAccountingUpdate _BlockIOAccountingProperty;

    BlockIOWeightUpdate _BlockIOWeightProperty;

    StartupBlockIOWeightUpdate _StartupBlockIOWeightProperty;

    BlockIODeviceWeightUpdate _BlockIODeviceWeightProperty;

    BlockIOReadBandwidthUpdate _BlockIOReadBandwidthProperty;

    BlockIOWriteBandwidthUpdate _BlockIOWriteBandwidthProperty;

    MemoryAccountingUpdate _MemoryAccountingProperty;

    MemoryLimitUpdate _MemoryLimitProperty;

    DevicePolicyUpdate _DevicePolicyProperty;

    DeviceAllowUpdate _DeviceAllowProperty;

    EnvironmentUpdate _EnvironmentProperty;

    EnvironmentFilesUpdate _EnvironmentFilesProperty;

    UMaskUpdate _UMaskProperty;

    LimitCPUUpdate _LimitCPUProperty;

    LimitFSIZEUpdate _LimitFSIZEProperty;

    LimitDATAUpdate _LimitDATAProperty;

    LimitSTACKUpdate _LimitSTACKProperty;

    LimitCOREUpdate _LimitCOREProperty;

    LimitRSSUpdate _LimitRSSProperty;

    LimitNOFILEUpdate _LimitNOFILEProperty;

    LimitASUpdate _LimitASProperty;

    LimitNPROCUpdate _LimitNPROCProperty;

    LimitMEMLOCKUpdate _LimitMEMLOCKProperty;

    LimitLOCKSUpdate _LimitLOCKSProperty;

    LimitSIGPENDINGUpdate _LimitSIGPENDINGProperty;

    LimitMSGQUEUEUpdate _LimitMSGQUEUEProperty;

    LimitNICEUpdate _LimitNICEProperty;

    LimitRTPRIOUpdate _LimitRTPRIOProperty;

    LimitRTTIMEUpdate _LimitRTTIMEProperty;

    WorkingDirectoryUpdate _WorkingDirectoryProperty;

    RootDirectoryUpdate _RootDirectoryProperty;

    OOMScoreAdjustUpdate _OOMScoreAdjustProperty;

    NiceUpdate _NiceProperty;

    IOSchedulingUpdate _IOSchedulingProperty;

    CPUSchedulingPolicyUpdate _CPUSchedulingPolicyProperty;

    CPUSchedulingPriorityUpdate _CPUSchedulingPriorityProperty;

    CPUAffinityUpdate _CPUAffinityProperty;

    TimerSlackNSecUpdate _TimerSlackNSecProperty;

    CPUSchedulingResetOnForkUpdate _CPUSchedulingResetOnForkProperty;

    NonBlockingUpdate _NonBlockingProperty;

    StandardInputUpdate _StandardInputProperty;

    StandardOutputUpdate _StandardOutputProperty;

    StandardErrorUpdate _StandardErrorProperty;

    TTYPathUpdate _TTYPathProperty;

    TTYResetUpdate _TTYResetProperty;

    TTYVHangupUpdate _TTYVHangupProperty;

    TTYVTDisallocateUpdate _TTYVTDisallocateProperty;

    SyslogPriorityUpdate _SyslogPriorityProperty;

    SyslogIdentifierUpdate _SyslogIdentifierProperty;

    SyslogLevelPrefixUpdate _SyslogLevelPrefixProperty;

    CapabilitiesUpdate _CapabilitiesProperty;

    SecureBitsUpdate _SecureBitsProperty;

    CapabilityBoundingSetUpdate _CapabilityBoundingSetProperty;

    UserUpdate _UserProperty;

    GroupUpdate _GroupProperty;

    SupplementaryGroupsUpdate _SupplementaryGroupsProperty;

    PAMNameUpdate _PAMNameProperty;

    ReadWriteDirectoriesUpdate _ReadWriteDirectoriesProperty;

    ReadOnlyDirectoriesUpdate _ReadOnlyDirectoriesProperty;

    InaccessibleDirectoriesUpdate _InaccessibleDirectoriesProperty;

    MountFlagsUpdate _MountFlagsProperty;

    PrivateTmpUpdate _PrivateTmpProperty;

    PrivateNetworkUpdate _PrivateNetworkProperty;

    PrivateDevicesUpdate _PrivateDevicesProperty;

    ProtectHomeUpdate _ProtectHomeProperty;

    ProtectSystemUpdate _ProtectSystemProperty;

    SameProcessGroupUpdate _SameProcessGroupProperty;

    UtmpIdentifierUpdate _UtmpIdentifierProperty;

    UtmpModeUpdate _UtmpModeProperty;

    SELinuxContextUpdate _SELinuxContextProperty;

    AppArmorProfileUpdate _AppArmorProfileProperty;

    SmackProcessLabelUpdate _SmackProcessLabelProperty;

    IgnoreSIGPIPEUpdate _IgnoreSIGPIPEProperty;

    NoNewPrivilegesUpdate _NoNewPrivilegesProperty;

    SystemCallFilterUpdate _SystemCallFilterProperty;

    SystemCallArchitecturesUpdate _SystemCallArchitecturesProperty;

    SystemCallErrorNumberUpdate _SystemCallErrorNumberProperty;

    PersonalityUpdate _PersonalityProperty;

    RestrictAddressFamiliesUpdate _RestrictAddressFamiliesProperty;

    RuntimeDirectoryModeUpdate _RuntimeDirectoryModeProperty;

    RuntimeDirectoryUpdate _RuntimeDirectoryProperty;

    KillModeUpdate _KillModeProperty;

    KillSignalUpdate _KillSignalProperty;

    SendSIGKILLUpdate _SendSIGKILLProperty;

    SendSIGHUPUpdate _SendSIGHUPProperty;

    friend class ServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org

#endif // ORG_FREEDESKTOP_SYSTEMD1_SERVICESTUB_H
