/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "org/freedesktop/systemd1/Service.h"
#include "org/freedesktop/systemd1/ServiceJson.h"
#include "org/freedesktop/systemd1/ServiceJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "execData"

void serializeJson (const ::org::freedesktop::systemd1::Service::execData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBinaryPath()) {
        yajl_gen_string(g, (const unsigned char*)  "binaryPath" , 10);
        const char *s = value.getBinaryPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasArguments()) {
        yajl_gen_string(g, (const unsigned char*)  "arguments" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o1 = value.getArguments();
        {
            ::std::vector< ::std::string >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                const char *s = (*o0).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasExitType()) {
        yajl_gen_string(g, (const unsigned char*)  "exitType" , 8);
        yajl_gen_bool(g, (bool)value.getExitType());
    }
    if (!isSparse || value.hasClockRealTimeStartUSec()) {
        yajl_gen_string(g, (const unsigned char*)  "clockRealTimeStartUSec" , 22);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getClockRealTimeStartUSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasClockMonotonicStartUSec()) {
        yajl_gen_string(g, (const unsigned char*)  "clockMonotonicStartUSec" , 23);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getClockMonotonicStartUSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasClockRealTimeFinishUSec()) {
        yajl_gen_string(g, (const unsigned char*)  "clockRealTimeFinishUSec" , 23);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getClockRealTimeFinishUSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasClockMonotonicFinishUSec()) {
        yajl_gen_string(g, (const unsigned char*)  "clockMonotonicFinishUSec" , 24);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getClockMonotonicFinishUSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasPID()) {
        yajl_gen_string(g, (const unsigned char*)  "PID" , 3);
        yajl_gen_integer(g, (long long)value.getPID());
    }
    if (!isSparse || value.hasExitStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "exitStatus" , 10);
        yajl_gen_integer(g, (long long)value.getExitStatus());
    }
    if (!isSparse || value.hasLastRunStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "lastRunStatus" , 13);
        yajl_gen_integer(g, (long long)value.getLastRunStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::execData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "blockIOData"

void serializeJson (const ::org::freedesktop::systemd1::Service::blockIOData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceName()) {
        yajl_gen_string(g, (const unsigned char*)  "deviceName" , 10);
        const char *s = value.getDeviceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasValue()) {
        yajl_gen_string(g, (const unsigned char*)  "value" , 5);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getValue(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::blockIOData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "deviceNode"

void serializeJson (const ::org::freedesktop::systemd1::Service::deviceNode& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNodeName()) {
        yajl_gen_string(g, (const unsigned char*)  "nodeName" , 8);
        const char *s = value.getNodeName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::deviceNode& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnvironmentFile"

void serializeJson (const ::org::freedesktop::systemd1::Service::EnvironmentFile& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFileName()) {
        yajl_gen_string(g, (const unsigned char*)  "fileName" , 8);
        const char *s = value.getFileName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasActive()) {
        yajl_gen_string(g, (const unsigned char*)  "active" , 6);
        yajl_gen_bool(g, (bool)value.getActive());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::EnvironmentFile& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "securityContext"

void serializeJson (const ::org::freedesktop::systemd1::Service::securityContext& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnable()) {
        yajl_gen_string(g, (const unsigned char*)  "enable" , 6);
        yajl_gen_bool(g, (bool)value.getEnable());
    }
    if (!isSparse || value.hasSecurityContext()) {
        yajl_gen_string(g, (const unsigned char*)  "securityContext" , 15);
        const char *s = value.getSecurityContext().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::securityContext& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ArmorProfile"

void serializeJson (const ::org::freedesktop::systemd1::Service::ArmorProfile& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnable()) {
        yajl_gen_string(g, (const unsigned char*)  "enable" , 6);
        yajl_gen_bool(g, (bool)value.getEnable());
    }
    if (!isSparse || value.hasProfile()) {
        yajl_gen_string(g, (const unsigned char*)  "profile" , 7);
        const char *s = value.getProfile().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ArmorProfile& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProcessLabel"

void serializeJson (const ::org::freedesktop::systemd1::Service::ProcessLabel& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnable()) {
        yajl_gen_string(g, (const unsigned char*)  "enable" , 6);
        yajl_gen_bool(g, (bool)value.getEnable());
    }
    if (!isSparse || value.hasLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "label" , 5);
        const char *s = value.getLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ProcessLabel& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "systemCallFilter"

void serializeJson (const ::org::freedesktop::systemd1::Service::systemCallFilter& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnable()) {
        yajl_gen_string(g, (const unsigned char*)  "enable" , 6);
        yajl_gen_bool(g, (bool)value.getEnable());
    }
    if (!isSparse || value.hasSystemCalls()) {
        yajl_gen_string(g, (const unsigned char*)  "systemCalls" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o3 = value.getSystemCalls();
        {
            ::std::vector< ::std::string >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                const char *s = (*o2).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::systemCallFilter& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AddressFamily"

void serializeJson (const ::org::freedesktop::systemd1::Service::AddressFamily& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnable()) {
        yajl_gen_string(g, (const unsigned char*)  "enable" , 6);
        yajl_gen_bool(g, (bool)value.getEnable());
    }
    if (!isSparse || value.hasAddresses()) {
        yajl_gen_string(g, (const unsigned char*)  "addresses" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o5 = value.getAddresses();
        {
            ::std::vector< ::std::string >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                const char *s = (*o4).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::AddressFamily& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TypeUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::TypeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasType()) {
        yajl_gen_string(g, (const unsigned char*)  "Type" , 4);
        const char *s = value.getType().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TypeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TypeRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::TypeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TypeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::RestartUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRestart()) {
        yajl_gen_string(g, (const unsigned char*)  "Restart" , 7);
        const char *s = value.getRestart().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RestartUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::RestartRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RestartRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PIDFileUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::PIDFileUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPIDFile()) {
        yajl_gen_string(g, (const unsigned char*)  "PIDFile" , 7);
        const char *s = value.getPIDFile().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PIDFileUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PIDFileRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::PIDFileRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PIDFileRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NotifyAccessUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::NotifyAccessUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNotifyAccess()) {
        yajl_gen_string(g, (const unsigned char*)  "NotifyAccess" , 12);
        const char *s = value.getNotifyAccess().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::NotifyAccessUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NotifyAccessRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::NotifyAccessRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::NotifyAccessRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartUSecUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::RestartUSecUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRestartUSec()) {
        yajl_gen_string(g, (const unsigned char*)  "RestartUSec" , 11);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getRestartUSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RestartUSecUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartUSecRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::RestartUSecRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RestartUSecRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TimeoutStartUSecUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::TimeoutStartUSecUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTimeoutStartUSec()) {
        yajl_gen_string(g, (const unsigned char*)  "TimeoutStartUSec" , 16);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getTimeoutStartUSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TimeoutStartUSecUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TimeoutStartUSecRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::TimeoutStartUSecRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TimeoutStartUSecRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TimeoutStopUSecUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::TimeoutStopUSecUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTimeoutStopUSec()) {
        yajl_gen_string(g, (const unsigned char*)  "TimeoutStopUSec" , 15);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getTimeoutStopUSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TimeoutStopUSecUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TimeoutStopUSecRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::TimeoutStopUSecRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TimeoutStopUSecRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WatchdogUSecUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::WatchdogUSecUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWatchdogUSec()) {
        yajl_gen_string(g, (const unsigned char*)  "WatchdogUSec" , 12);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getWatchdogUSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::WatchdogUSecUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WatchdogUSecRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::WatchdogUSecRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::WatchdogUSecRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WatchdogTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::WatchdogTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWatchdogTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "WatchdogTimestamp" , 17);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getWatchdogTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::WatchdogTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WatchdogTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::WatchdogTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::WatchdogTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WatchdogTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::WatchdogTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWatchdogTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "WatchdogTimestampMonotonic" , 26);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getWatchdogTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::WatchdogTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WatchdogTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::WatchdogTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::WatchdogTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartLimitIntervalUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::StartLimitIntervalUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStartLimitInterval()) {
        yajl_gen_string(g, (const unsigned char*)  "StartLimitInterval" , 18);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getStartLimitInterval(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StartLimitIntervalUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartLimitIntervalRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::StartLimitIntervalRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StartLimitIntervalRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartLimitBurstUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::StartLimitBurstUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStartLimitBurst()) {
        yajl_gen_string(g, (const unsigned char*)  "StartLimitBurst" , 15);
        yajl_gen_integer(g, (long long)value.getStartLimitBurst());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StartLimitBurstUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartLimitBurstRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::StartLimitBurstRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StartLimitBurstRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartLimitActionUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::StartLimitActionUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStartLimitAction()) {
        yajl_gen_string(g, (const unsigned char*)  "StartLimitAction" , 16);
        const char *s = value.getStartLimitAction().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StartLimitActionUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartLimitActionRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::StartLimitActionRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StartLimitActionRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RebootArgumentUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::RebootArgumentUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRebootArgument()) {
        yajl_gen_string(g, (const unsigned char*)  "RebootArgument" , 14);
        const char *s = value.getRebootArgument().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RebootArgumentUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RebootArgumentRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::RebootArgumentRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RebootArgumentRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FailureActionUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::FailureActionUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFailureAction()) {
        yajl_gen_string(g, (const unsigned char*)  "FailureAction" , 13);
        const char *s = value.getFailureAction().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::FailureActionUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FailureActionRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::FailureActionRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::FailureActionRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PermissionsStartOnlyUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::PermissionsStartOnlyUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPermissionsStartOnly()) {
        yajl_gen_string(g, (const unsigned char*)  "PermissionsStartOnly" , 20);
        yajl_gen_bool(g, (bool)value.getPermissionsStartOnly());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PermissionsStartOnlyUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PermissionsStartOnlyRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::PermissionsStartOnlyRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PermissionsStartOnlyRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RootDirectoryStartOnlyUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::RootDirectoryStartOnlyUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRootDirectoryStartOnly()) {
        yajl_gen_string(g, (const unsigned char*)  "RootDirectoryStartOnly" , 22);
        yajl_gen_bool(g, (bool)value.getRootDirectoryStartOnly());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RootDirectoryStartOnlyUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RootDirectoryStartOnlyRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::RootDirectoryStartOnlyRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RootDirectoryStartOnlyRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RemainAfterExitUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::RemainAfterExitUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRemainAfterExit()) {
        yajl_gen_string(g, (const unsigned char*)  "RemainAfterExit" , 15);
        yajl_gen_bool(g, (bool)value.getRemainAfterExit());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RemainAfterExitUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RemainAfterExitRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::RemainAfterExitRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RemainAfterExitRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GuessMainPIDUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::GuessMainPIDUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGuessMainPID()) {
        yajl_gen_string(g, (const unsigned char*)  "GuessMainPID" , 12);
        yajl_gen_bool(g, (bool)value.getGuessMainPID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::GuessMainPIDUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GuessMainPIDRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::GuessMainPIDRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::GuessMainPIDRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MainPIDUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::MainPIDUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMainPID()) {
        yajl_gen_string(g, (const unsigned char*)  "MainPID" , 7);
        yajl_gen_integer(g, (long long)value.getMainPID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::MainPIDUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MainPIDRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::MainPIDRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::MainPIDRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ControlPIDUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ControlPIDUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasControlPID()) {
        yajl_gen_string(g, (const unsigned char*)  "ControlPID" , 10);
        yajl_gen_integer(g, (long long)value.getControlPID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ControlPIDUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ControlPIDRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ControlPIDRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ControlPIDRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BusNameUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::BusNameUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBusName()) {
        yajl_gen_string(g, (const unsigned char*)  "BusName" , 7);
        const char *s = value.getBusName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::BusNameUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BusNameRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::BusNameRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::BusNameRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FileDescriptorStoreMaxUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::FileDescriptorStoreMaxUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFileDescriptorStoreMax()) {
        yajl_gen_string(g, (const unsigned char*)  "FileDescriptorStoreMax" , 22);
        yajl_gen_integer(g, (long long)value.getFileDescriptorStoreMax());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::FileDescriptorStoreMaxUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FileDescriptorStoreMaxRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::FileDescriptorStoreMaxRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::FileDescriptorStoreMaxRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StatusTextUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::StatusTextUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatusText()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusText" , 10);
        const char *s = value.getStatusText().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StatusTextUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StatusTextRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::StatusTextRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StatusTextRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StatusErrnoUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::StatusErrnoUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatusErrno()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusErrno" , 11);
        yajl_gen_integer(g, (long long)value.getStatusErrno());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StatusErrnoUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StatusErrnoRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::StatusErrnoRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StatusErrnoRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResultUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ResultUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char *s = value.getResult().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ResultUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResultRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ResultRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ResultRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainStartTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecMainStartTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecMainStartTimestamp" , 22);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getExecMainStartTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainStartTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainStartTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecMainStartTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecMainStartTimestampMonotonic" , 31);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getExecMainStartTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainStartTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainExitTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecMainExitTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecMainExitTimestamp" , 21);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getExecMainExitTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainExitTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainExitTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecMainExitTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecMainExitTimestampMonotonic" , 30);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getExecMainExitTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainExitTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainPIDUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainPIDUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecMainPID()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecMainPID" , 11);
        yajl_gen_integer(g, (long long)value.getExecMainPID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainPIDUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainPIDRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainPIDRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainPIDRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainCodeUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainCodeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecMainCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecMainCode" , 12);
        yajl_gen_integer(g, (long long)value.getExecMainCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainCodeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainCodeRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainCodeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainCodeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainStatusUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecMainStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecMainStatus" , 14);
        yajl_gen_integer(g, (long long)value.getExecMainStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecMainStatusRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecMainStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecStartPreUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStartPreUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecStartPre()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecStartPre" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Service::execData >& o7 = value.getExecStartPre();
        {
            ::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStartPreUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecStartPreRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStartPreRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStartPreRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecStartUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStartUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecStart()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecStart" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Service::execData >& o9 = value.getExecStart();
        {
            ::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStartUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecStartRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStartRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStartRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecStartPostUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStartPostUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecStartPost()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecStartPost" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Service::execData >& o11 = value.getExecStartPost();
        {
            ::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                serializeJson((*o10), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStartPostUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecStartPostRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStartPostRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStartPostRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecReloadUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecReloadUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecReload()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecReload" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Service::execData >& o13 = value.getExecReload();
        {
            ::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecReloadUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecReloadRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecReloadRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecReloadRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecStopUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStopUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecStop()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecStop" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Service::execData >& o15 = value.getExecStop();
        {
            ::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                serializeJson((*o14), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStopUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecStopRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStopRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStopRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecStopPostUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStopPostUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExecStopPost()) {
        yajl_gen_string(g, (const unsigned char*)  "ExecStopPost" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Service::execData >& o17 = value.getExecStopPost();
        {
            ::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                serializeJson((*o16), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStopPostUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExecStopPostRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStopPostRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ExecStopPostRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SliceUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SliceUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSlice()) {
        yajl_gen_string(g, (const unsigned char*)  "Slice" , 5);
        const char *s = value.getSlice().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SliceUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SliceRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SliceRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SliceRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ControlGroupUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ControlGroupUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasControlGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "ControlGroup" , 12);
        const char *s = value.getControlGroup().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ControlGroupUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ControlGroupRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ControlGroupRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ControlGroupRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MemoryCurrentUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::MemoryCurrentUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMemoryCurrent()) {
        yajl_gen_string(g, (const unsigned char*)  "MemoryCurrent" , 13);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getMemoryCurrent(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::MemoryCurrentUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MemoryCurrentRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::MemoryCurrentRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::MemoryCurrentRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUUsageNSecUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUUsageNSecUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCPUUsageNSec()) {
        yajl_gen_string(g, (const unsigned char*)  "CPUUsageNSec" , 12);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getCPUUsageNSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUUsageNSecUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUUsageNSecRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUUsageNSecRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUUsageNSecRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DelegateUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::DelegateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDelegate()) {
        yajl_gen_string(g, (const unsigned char*)  "Delegate" , 8);
        yajl_gen_bool(g, (bool)value.getDelegate());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::DelegateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DelegateRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::DelegateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::DelegateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUAccountingUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUAccountingUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCPUAccounting()) {
        yajl_gen_string(g, (const unsigned char*)  "CPUAccounting" , 13);
        yajl_gen_bool(g, (bool)value.getCPUAccounting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUAccountingUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUAccountingRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUAccountingRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUAccountingRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUSharesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSharesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCPUShares()) {
        yajl_gen_string(g, (const unsigned char*)  "CPUShares" , 9);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getCPUShares(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSharesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUSharesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSharesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSharesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartupCPUSharesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::StartupCPUSharesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStartupCPUShares()) {
        yajl_gen_string(g, (const unsigned char*)  "StartupCPUShares" , 16);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getStartupCPUShares(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StartupCPUSharesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartupCPUSharesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::StartupCPUSharesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StartupCPUSharesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUQuotaPerSecUSecUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUQuotaPerSecUSecUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCPUQuotaPerSecUSec()) {
        yajl_gen_string(g, (const unsigned char*)  "CPUQuotaPerSecUSec" , 18);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getCPUQuotaPerSecUSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUQuotaPerSecUSecUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUQuotaPerSecUSecRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUQuotaPerSecUSecRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUQuotaPerSecUSecRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlockIOAccountingUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOAccountingUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBlockIOAccounting()) {
        yajl_gen_string(g, (const unsigned char*)  "BlockIOAccounting" , 17);
        yajl_gen_bool(g, (bool)value.getBlockIOAccounting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOAccountingUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlockIOAccountingRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOAccountingRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOAccountingRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlockIOWeightUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOWeightUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBlockIOWeight()) {
        yajl_gen_string(g, (const unsigned char*)  "BlockIOWeight" , 13);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getBlockIOWeight(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOWeightUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlockIOWeightRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOWeightRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOWeightRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartupBlockIOWeightUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::StartupBlockIOWeightUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStartupBlockIOWeight()) {
        yajl_gen_string(g, (const unsigned char*)  "StartupBlockIOWeight" , 20);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getStartupBlockIOWeight(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StartupBlockIOWeightUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartupBlockIOWeightRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::StartupBlockIOWeightRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StartupBlockIOWeightRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlockIODeviceWeightUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIODeviceWeightUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBlockIODeviceWeight()) {
        yajl_gen_string(g, (const unsigned char*)  "BlockIODeviceWeight" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >& o19 = value.getBlockIODeviceWeight();
        {
            ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                serializeJson((*o18), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIODeviceWeightUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlockIODeviceWeightRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIODeviceWeightRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIODeviceWeightRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlockIOReadBandwidthUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOReadBandwidthUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBlockIOReadBandwidth()) {
        yajl_gen_string(g, (const unsigned char*)  "BlockIOReadBandwidth" , 20);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >& o21 = value.getBlockIOReadBandwidth();
        {
            ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >::const_iterator o20;
            for (o20 = o21.begin(); o20 != o21.end(); ++o20) {
                serializeJson((*o20), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOReadBandwidthUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlockIOReadBandwidthRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOReadBandwidthRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOReadBandwidthRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlockIOWriteBandwidthUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOWriteBandwidthUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBlockIOWriteBandwidth()) {
        yajl_gen_string(g, (const unsigned char*)  "BlockIOWriteBandwidth" , 21);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >& o23 = value.getBlockIOWriteBandwidth();
        {
            ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >::const_iterator o22;
            for (o22 = o23.begin(); o22 != o23.end(); ++o22) {
                serializeJson((*o22), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOWriteBandwidthUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlockIOWriteBandwidthRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOWriteBandwidthRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::BlockIOWriteBandwidthRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MemoryAccountingUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::MemoryAccountingUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMemoryAccounting()) {
        yajl_gen_string(g, (const unsigned char*)  "MemoryAccounting" , 16);
        yajl_gen_bool(g, (bool)value.getMemoryAccounting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::MemoryAccountingUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MemoryAccountingRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::MemoryAccountingRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::MemoryAccountingRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MemoryLimitUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::MemoryLimitUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMemoryLimit()) {
        yajl_gen_string(g, (const unsigned char*)  "MemoryLimit" , 11);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getMemoryLimit(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::MemoryLimitUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MemoryLimitRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::MemoryLimitRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::MemoryLimitRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevicePolicyUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::DevicePolicyUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDevicePolicy()) {
        yajl_gen_string(g, (const unsigned char*)  "DevicePolicy" , 12);
        const char *s = value.getDevicePolicy().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::DevicePolicyUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevicePolicyRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::DevicePolicyRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::DevicePolicyRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceAllowUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::DeviceAllowUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceAllow()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceAllow" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Service::deviceNode >& o25 = value.getDeviceAllow();
        {
            ::std::vector< ::org::freedesktop::systemd1::Service::deviceNode >::const_iterator o24;
            for (o24 = o25.begin(); o24 != o25.end(); ++o24) {
                serializeJson((*o24), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::DeviceAllowUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceAllowRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::DeviceAllowRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::DeviceAllowRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnvironmentUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::EnvironmentUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnvironment()) {
        yajl_gen_string(g, (const unsigned char*)  "Environment" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o27 = value.getEnvironment();
        {
            ::std::vector< ::std::string >::const_iterator o26;
            for (o26 = o27.begin(); o26 != o27.end(); ++o26) {
                const char *s = (*o26).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::EnvironmentUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnvironmentRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::EnvironmentRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::EnvironmentRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnvironmentFilesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::EnvironmentFilesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnvironmentFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "EnvironmentFiles" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Service::EnvironmentFile >& o29 = value.getEnvironmentFiles();
        {
            ::std::vector< ::org::freedesktop::systemd1::Service::EnvironmentFile >::const_iterator o28;
            for (o28 = o29.begin(); o28 != o29.end(); ++o28) {
                serializeJson((*o28), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::EnvironmentFilesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnvironmentFilesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::EnvironmentFilesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::EnvironmentFilesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UMaskUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::UMaskUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUMask()) {
        yajl_gen_string(g, (const unsigned char*)  "UMask" , 5);
        yajl_gen_integer(g, (long long)value.getUMask());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::UMaskUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UMaskRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::UMaskRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::UMaskRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitCPUUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitCPUUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitCPU()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitCPU" , 8);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitCPU(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitCPUUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitCPURegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitCPURegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitCPURegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitFSIZEUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitFSIZEUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitFSIZE()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitFSIZE" , 10);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitFSIZE(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitFSIZEUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitFSIZERegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitFSIZERegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitFSIZERegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitDATAUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitDATAUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitDATA()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitDATA" , 9);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitDATA(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitDATAUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitDATARegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitDATARegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitDATARegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitSTACKUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitSTACKUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitSTACK()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitSTACK" , 10);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitSTACK(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitSTACKUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitSTACKRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitSTACKRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitSTACKRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitCOREUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitCOREUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitCORE()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitCORE" , 9);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitCORE(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitCOREUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitCORERegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitCORERegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitCORERegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitRSSUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitRSSUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitRSS()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitRSS" , 8);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitRSS(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitRSSUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitRSSRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitRSSRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitRSSRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitNOFILEUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitNOFILEUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitNOFILE()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitNOFILE" , 11);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitNOFILE(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitNOFILEUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitNOFILERegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitNOFILERegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitNOFILERegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitASUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitASUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitAS()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitAS" , 7);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitAS(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitASUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitASRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitASRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitASRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitNPROCUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitNPROCUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitNPROC()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitNPROC" , 10);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitNPROC(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitNPROCUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitNPROCRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitNPROCRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitNPROCRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitMEMLOCKUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitMEMLOCKUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitMEMLOCK()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitMEMLOCK" , 12);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitMEMLOCK(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitMEMLOCKUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitMEMLOCKRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitMEMLOCKRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitMEMLOCKRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitLOCKSUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitLOCKSUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitLOCKS()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitLOCKS" , 10);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitLOCKS(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitLOCKSUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitLOCKSRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitLOCKSRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitLOCKSRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitSIGPENDINGUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitSIGPENDINGUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitSIGPENDING()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitSIGPENDING" , 15);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitSIGPENDING(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitSIGPENDINGUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitSIGPENDINGRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitSIGPENDINGRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitSIGPENDINGRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitMSGQUEUEUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitMSGQUEUEUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitMSGQUEUE()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitMSGQUEUE" , 13);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitMSGQUEUE(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitMSGQUEUEUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitMSGQUEUERegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitMSGQUEUERegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitMSGQUEUERegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitNICEUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitNICEUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitNICE()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitNICE" , 9);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitNICE(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitNICEUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitNICERegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitNICERegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitNICERegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitRTPRIOUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitRTPRIOUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitRTPRIO()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitRTPRIO" , 11);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitRTPRIO(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitRTPRIOUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitRTPRIORegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitRTPRIORegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitRTPRIORegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitRTTIMEUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitRTTIMEUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLimitRTTIME()) {
        yajl_gen_string(g, (const unsigned char*)  "LimitRTTIME" , 11);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLimitRTTIME(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitRTTIMEUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LimitRTTIMERegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitRTTIMERegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::LimitRTTIMERegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WorkingDirectoryUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::WorkingDirectoryUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWorkingDirectory()) {
        yajl_gen_string(g, (const unsigned char*)  "WorkingDirectory" , 16);
        const char *s = value.getWorkingDirectory().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::WorkingDirectoryUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WorkingDirectoryRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::WorkingDirectoryRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::WorkingDirectoryRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RootDirectoryUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::RootDirectoryUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRootDirectory()) {
        yajl_gen_string(g, (const unsigned char*)  "RootDirectory" , 13);
        const char *s = value.getRootDirectory().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RootDirectoryUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RootDirectoryRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::RootDirectoryRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RootDirectoryRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OOMScoreAdjustUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::OOMScoreAdjustUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOOMScoreAdjust()) {
        yajl_gen_string(g, (const unsigned char*)  "OOMScoreAdjust" , 14);
        yajl_gen_integer(g, (long long)value.getOOMScoreAdjust());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::OOMScoreAdjustUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OOMScoreAdjustRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::OOMScoreAdjustRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::OOMScoreAdjustRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NiceUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::NiceUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNice()) {
        yajl_gen_string(g, (const unsigned char*)  "Nice" , 4);
        yajl_gen_integer(g, (long long)value.getNice());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::NiceUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NiceRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::NiceRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::NiceRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IOSchedulingUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::IOSchedulingUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIOScheduling()) {
        yajl_gen_string(g, (const unsigned char*)  "IOScheduling" , 12);
        yajl_gen_integer(g, (long long)value.getIOScheduling());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::IOSchedulingUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IOSchedulingRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::IOSchedulingRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::IOSchedulingRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUSchedulingPolicyUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSchedulingPolicyUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCPUSchedulingPolicy()) {
        yajl_gen_string(g, (const unsigned char*)  "CPUSchedulingPolicy" , 19);
        yajl_gen_integer(g, (long long)value.getCPUSchedulingPolicy());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSchedulingPolicyUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUSchedulingPolicyRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSchedulingPolicyRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSchedulingPolicyRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUSchedulingPriorityUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSchedulingPriorityUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCPUSchedulingPriority()) {
        yajl_gen_string(g, (const unsigned char*)  "CPUSchedulingPriority" , 21);
        yajl_gen_integer(g, (long long)value.getCPUSchedulingPriority());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSchedulingPriorityUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUSchedulingPriorityRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSchedulingPriorityRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSchedulingPriorityRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUAffinityUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUAffinityUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCPUAffinity()) {
        yajl_gen_string(g, (const unsigned char*)  "CPUAffinity" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o31 = value.getCPUAffinity();
        {
            ::std::vector< ::std::string >::const_iterator o30;
            for (o30 = o31.begin(); o30 != o31.end(); ++o30) {
                const char *s = (*o30).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUAffinityUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUAffinityRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUAffinityRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUAffinityRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TimerSlackNSecUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::TimerSlackNSecUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTimerSlackNSec()) {
        yajl_gen_string(g, (const unsigned char*)  "TimerSlackNSec" , 14);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getTimerSlackNSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TimerSlackNSecUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TimerSlackNSecRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::TimerSlackNSecRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TimerSlackNSecRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUSchedulingResetOnForkUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSchedulingResetOnForkUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCPUSchedulingResetOnFork()) {
        yajl_gen_string(g, (const unsigned char*)  "CPUSchedulingResetOnFork" , 24);
        yajl_gen_bool(g, (bool)value.getCPUSchedulingResetOnFork());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSchedulingResetOnForkUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CPUSchedulingResetOnForkRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSchedulingResetOnForkRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CPUSchedulingResetOnForkRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NonBlockingUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::NonBlockingUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNonBlocking()) {
        yajl_gen_string(g, (const unsigned char*)  "NonBlocking" , 11);
        yajl_gen_bool(g, (bool)value.getNonBlocking());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::NonBlockingUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NonBlockingRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::NonBlockingRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::NonBlockingRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StandardInputUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::StandardInputUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStandardInput()) {
        yajl_gen_string(g, (const unsigned char*)  "StandardInput" , 13);
        const char *s = value.getStandardInput().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StandardInputUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StandardInputRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::StandardInputRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StandardInputRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StandardOutputUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::StandardOutputUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStandardOutput()) {
        yajl_gen_string(g, (const unsigned char*)  "StandardOutput" , 14);
        const char *s = value.getStandardOutput().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StandardOutputUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StandardOutputRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::StandardOutputRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StandardOutputRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StandardErrorUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::StandardErrorUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStandardError()) {
        yajl_gen_string(g, (const unsigned char*)  "StandardError" , 13);
        const char *s = value.getStandardError().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StandardErrorUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StandardErrorRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::StandardErrorRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::StandardErrorRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TTYPathUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYPathUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTTYPath()) {
        yajl_gen_string(g, (const unsigned char*)  "TTYPath" , 7);
        yajl_gen_bool(g, (bool)value.getTTYPath());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYPathUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TTYPathRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYPathRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYPathRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TTYResetUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYResetUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTTYReset()) {
        yajl_gen_string(g, (const unsigned char*)  "TTYReset" , 8);
        yajl_gen_bool(g, (bool)value.getTTYReset());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYResetUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TTYResetRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYResetRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYResetRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TTYVHangupUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYVHangupUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTTYVHangup()) {
        yajl_gen_string(g, (const unsigned char*)  "TTYVHangup" , 10);
        yajl_gen_bool(g, (bool)value.getTTYVHangup());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYVHangupUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TTYVHangupRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYVHangupRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYVHangupRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TTYVTDisallocateUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYVTDisallocateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTTYVTDisallocate()) {
        yajl_gen_string(g, (const unsigned char*)  "TTYVTDisallocate" , 16);
        yajl_gen_bool(g, (bool)value.getTTYVTDisallocate());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYVTDisallocateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TTYVTDisallocateRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYVTDisallocateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::TTYVTDisallocateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SyslogPriorityUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SyslogPriorityUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSyslogPriority()) {
        yajl_gen_string(g, (const unsigned char*)  "SyslogPriority" , 14);
        yajl_gen_integer(g, (long long)value.getSyslogPriority());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SyslogPriorityUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SyslogPriorityRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SyslogPriorityRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SyslogPriorityRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SyslogIdentifierUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SyslogIdentifierUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSyslogIdentifier()) {
        yajl_gen_string(g, (const unsigned char*)  "SyslogIdentifier" , 16);
        const char *s = value.getSyslogIdentifier().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SyslogIdentifierUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SyslogIdentifierRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SyslogIdentifierRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SyslogIdentifierRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SyslogLevelPrefixUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SyslogLevelPrefixUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSyslogLevelPrefix()) {
        yajl_gen_string(g, (const unsigned char*)  "SyslogLevelPrefix" , 17);
        yajl_gen_bool(g, (bool)value.getSyslogLevelPrefix());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SyslogLevelPrefixUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SyslogLevelPrefixRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SyslogLevelPrefixRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SyslogLevelPrefixRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CapabilitiesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::CapabilitiesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCapabilities()) {
        yajl_gen_string(g, (const unsigned char*)  "Capabilities" , 12);
        const char *s = value.getCapabilities().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CapabilitiesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CapabilitiesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::CapabilitiesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CapabilitiesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecureBitsUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SecureBitsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSecureBits()) {
        yajl_gen_string(g, (const unsigned char*)  "SecureBits" , 10);
        yajl_gen_integer(g, (long long)value.getSecureBits());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SecureBitsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecureBitsRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SecureBitsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SecureBitsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CapabilityBoundingSetUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::CapabilityBoundingSetUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCapabilityBoundingSet()) {
        yajl_gen_string(g, (const unsigned char*)  "CapabilityBoundingSet" , 21);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getCapabilityBoundingSet(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CapabilityBoundingSetUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CapabilityBoundingSetRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::CapabilityBoundingSetRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::CapabilityBoundingSetRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UserUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::UserUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUser()) {
        yajl_gen_string(g, (const unsigned char*)  "User" , 4);
        const char *s = value.getUser().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::UserUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UserRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::UserRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::UserRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GroupUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::GroupUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "Group" , 5);
        const char *s = value.getGroup().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::GroupUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GroupRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::GroupRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::GroupRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SupplementaryGroupsUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SupplementaryGroupsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSupplementaryGroups()) {
        yajl_gen_string(g, (const unsigned char*)  "SupplementaryGroups" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o33 = value.getSupplementaryGroups();
        {
            ::std::vector< ::std::string >::const_iterator o32;
            for (o32 = o33.begin(); o32 != o33.end(); ++o32) {
                const char *s = (*o32).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SupplementaryGroupsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SupplementaryGroupsRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SupplementaryGroupsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SupplementaryGroupsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PAMNameUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::PAMNameUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPAMName()) {
        yajl_gen_string(g, (const unsigned char*)  "PAMName" , 7);
        const char *s = value.getPAMName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PAMNameUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PAMNameRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::PAMNameRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PAMNameRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReadWriteDirectoriesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ReadWriteDirectoriesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasReadWriteDirectories()) {
        yajl_gen_string(g, (const unsigned char*)  "ReadWriteDirectories" , 20);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o35 = value.getReadWriteDirectories();
        {
            ::std::vector< ::std::string >::const_iterator o34;
            for (o34 = o35.begin(); o34 != o35.end(); ++o34) {
                const char *s = (*o34).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ReadWriteDirectoriesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReadWriteDirectoriesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ReadWriteDirectoriesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ReadWriteDirectoriesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReadOnlyDirectoriesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ReadOnlyDirectoriesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasReadOnlyDirectories()) {
        yajl_gen_string(g, (const unsigned char*)  "ReadOnlyDirectories" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o37 = value.getReadOnlyDirectories();
        {
            ::std::vector< ::std::string >::const_iterator o36;
            for (o36 = o37.begin(); o36 != o37.end(); ++o36) {
                const char *s = (*o36).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ReadOnlyDirectoriesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReadOnlyDirectoriesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ReadOnlyDirectoriesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ReadOnlyDirectoriesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InaccessibleDirectoriesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::InaccessibleDirectoriesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInaccessibleDirectories()) {
        yajl_gen_string(g, (const unsigned char*)  "InaccessibleDirectories" , 23);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o39 = value.getInaccessibleDirectories();
        {
            ::std::vector< ::std::string >::const_iterator o38;
            for (o38 = o39.begin(); o38 != o39.end(); ++o38) {
                const char *s = (*o38).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::InaccessibleDirectoriesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InaccessibleDirectoriesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::InaccessibleDirectoriesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::InaccessibleDirectoriesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MountFlagsUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::MountFlagsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMountFlags()) {
        yajl_gen_string(g, (const unsigned char*)  "MountFlags" , 10);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getMountFlags(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::MountFlagsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MountFlagsRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::MountFlagsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::MountFlagsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrivateTmpUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::PrivateTmpUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPrivateTmp()) {
        yajl_gen_string(g, (const unsigned char*)  "PrivateTmp" , 10);
        yajl_gen_bool(g, (bool)value.getPrivateTmp());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PrivateTmpUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrivateTmpRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::PrivateTmpRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PrivateTmpRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrivateNetworkUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::PrivateNetworkUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPrivateNetwork()) {
        yajl_gen_string(g, (const unsigned char*)  "PrivateNetwork" , 14);
        yajl_gen_bool(g, (bool)value.getPrivateNetwork());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PrivateNetworkUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrivateNetworkRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::PrivateNetworkRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PrivateNetworkRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrivateDevicesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::PrivateDevicesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPrivateDevices()) {
        yajl_gen_string(g, (const unsigned char*)  "PrivateDevices" , 14);
        yajl_gen_bool(g, (bool)value.getPrivateDevices());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PrivateDevicesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrivateDevicesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::PrivateDevicesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PrivateDevicesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProtectHomeUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ProtectHomeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProtectHome()) {
        yajl_gen_string(g, (const unsigned char*)  "ProtectHome" , 11);
        const char *s = value.getProtectHome().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ProtectHomeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProtectHomeRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ProtectHomeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ProtectHomeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProtectSystemUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::ProtectSystemUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProtectSystem()) {
        yajl_gen_string(g, (const unsigned char*)  "ProtectSystem" , 13);
        const char *s = value.getProtectSystem().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ProtectSystemUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProtectSystemRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::ProtectSystemRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::ProtectSystemRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SameProcessGroupUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SameProcessGroupUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSameProcessGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "SameProcessGroup" , 16);
        yajl_gen_bool(g, (bool)value.getSameProcessGroup());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SameProcessGroupUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SameProcessGroupRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SameProcessGroupRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SameProcessGroupRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UtmpIdentifierUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::UtmpIdentifierUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUtmpIdentifier()) {
        yajl_gen_string(g, (const unsigned char*)  "UtmpIdentifier" , 14);
        const char *s = value.getUtmpIdentifier().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::UtmpIdentifierUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UtmpIdentifierRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::UtmpIdentifierRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::UtmpIdentifierRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UtmpModeUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::UtmpModeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUtmpMode()) {
        yajl_gen_string(g, (const unsigned char*)  "UtmpMode" , 8);
        const char *s = value.getUtmpMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::UtmpModeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UtmpModeRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::UtmpModeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::UtmpModeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SELinuxContextUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SELinuxContextUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSELinuxContext()) {
        yajl_gen_string(g, (const unsigned char*)  "SELinuxContext" , 14);
        serializeJson(value.getSELinuxContext(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SELinuxContextUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SELinuxContextRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SELinuxContextRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SELinuxContextRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AppArmorProfileUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::AppArmorProfileUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAppArmorProfile()) {
        yajl_gen_string(g, (const unsigned char*)  "AppArmorProfile" , 15);
        serializeJson(value.getAppArmorProfile(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::AppArmorProfileUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AppArmorProfileRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::AppArmorProfileRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::AppArmorProfileRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SmackProcessLabelUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SmackProcessLabelUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSmackProcessLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "SmackProcessLabel" , 17);
        serializeJson(value.getSmackProcessLabel(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SmackProcessLabelUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SmackProcessLabelRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SmackProcessLabelRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SmackProcessLabelRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IgnoreSIGPIPEUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::IgnoreSIGPIPEUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIgnoreSIGPIPE()) {
        yajl_gen_string(g, (const unsigned char*)  "IgnoreSIGPIPE" , 13);
        yajl_gen_bool(g, (bool)value.getIgnoreSIGPIPE());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::IgnoreSIGPIPEUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IgnoreSIGPIPERegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::IgnoreSIGPIPERegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::IgnoreSIGPIPERegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NoNewPrivilegesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::NoNewPrivilegesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNoNewPrivileges()) {
        yajl_gen_string(g, (const unsigned char*)  "NoNewPrivileges" , 15);
        yajl_gen_bool(g, (bool)value.getNoNewPrivileges());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::NoNewPrivilegesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NoNewPrivilegesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::NoNewPrivilegesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::NoNewPrivilegesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemCallFilterUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SystemCallFilterUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSystemCallFilter()) {
        yajl_gen_string(g, (const unsigned char*)  "SystemCallFilter" , 16);
        serializeJson(value.getSystemCallFilter(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SystemCallFilterUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemCallFilterRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SystemCallFilterRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SystemCallFilterRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemCallArchitecturesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SystemCallArchitecturesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSystemCallArchitectures()) {
        yajl_gen_string(g, (const unsigned char*)  "SystemCallArchitectures" , 23);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o41 = value.getSystemCallArchitectures();
        {
            ::std::vector< ::std::string >::const_iterator o40;
            for (o40 = o41.begin(); o40 != o41.end(); ++o40) {
                const char *s = (*o40).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SystemCallArchitecturesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemCallArchitecturesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SystemCallArchitecturesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SystemCallArchitecturesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemCallErrorNumberUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SystemCallErrorNumberUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSystemCallErrorNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "SystemCallErrorNumber" , 21);
        yajl_gen_integer(g, (long long)value.getSystemCallErrorNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SystemCallErrorNumberUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemCallErrorNumberRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SystemCallErrorNumberRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SystemCallErrorNumberRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PersonalityUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::PersonalityUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPersonality()) {
        yajl_gen_string(g, (const unsigned char*)  "Personality" , 11);
        const char *s = value.getPersonality().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PersonalityUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PersonalityRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::PersonalityRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::PersonalityRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestrictAddressFamiliesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::RestrictAddressFamiliesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRestrictAddressFamilies()) {
        yajl_gen_string(g, (const unsigned char*)  "RestrictAddressFamilies" , 23);
        serializeJson(value.getRestrictAddressFamilies(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RestrictAddressFamiliesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestrictAddressFamiliesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::RestrictAddressFamiliesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RestrictAddressFamiliesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RuntimeDirectoryModeUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::RuntimeDirectoryModeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRuntimeDirectoryMode()) {
        yajl_gen_string(g, (const unsigned char*)  "RuntimeDirectoryMode" , 20);
        yajl_gen_integer(g, (long long)value.getRuntimeDirectoryMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RuntimeDirectoryModeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RuntimeDirectoryModeRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::RuntimeDirectoryModeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RuntimeDirectoryModeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RuntimeDirectoryUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::RuntimeDirectoryUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRuntimeDirectory()) {
        yajl_gen_string(g, (const unsigned char*)  "RuntimeDirectory" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o43 = value.getRuntimeDirectory();
        {
            ::std::vector< ::std::string >::const_iterator o42;
            for (o42 = o43.begin(); o42 != o43.end(); ++o42) {
                const char *s = (*o42).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RuntimeDirectoryUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RuntimeDirectoryRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::RuntimeDirectoryRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::RuntimeDirectoryRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KillModeUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::KillModeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKillMode()) {
        yajl_gen_string(g, (const unsigned char*)  "KillMode" , 8);
        const char *s = value.getKillMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::KillModeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KillModeRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::KillModeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::KillModeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KillSignalUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::KillSignalUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKillSignal()) {
        yajl_gen_string(g, (const unsigned char*)  "KillSignal" , 10);
        yajl_gen_integer(g, (long long)value.getKillSignal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::KillSignalUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KillSignalRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::KillSignalRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::KillSignalRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendSIGKILLUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SendSIGKILLUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSendSIGKILL()) {
        yajl_gen_string(g, (const unsigned char*)  "SendSIGKILL" , 11);
        yajl_gen_bool(g, (bool)value.getSendSIGKILL());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SendSIGKILLUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendSIGKILLRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SendSIGKILLRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SendSIGKILLRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendSIGHUPUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Service::SendSIGHUPUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSendSIGHUP()) {
        yajl_gen_string(g, (const unsigned char*)  "SendSIGHUP" , 10);
        yajl_gen_bool(g, (bool)value.getSendSIGHUP());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SendSIGHUPUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendSIGHUPRegister"

void serializeJson (const ::org::freedesktop::systemd1::Service::SendSIGHUPRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Service::SendSIGHUPRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::execData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::blockIOData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::deviceNode& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::EnvironmentFile& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::securityContext& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ArmorProfile& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ProcessLabel& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::systemCallFilter& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::AddressFamily& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TypeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TypeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RestartUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RestartRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PIDFileUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PIDFileRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::NotifyAccessUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::NotifyAccessRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RestartUSecUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RestartUSecRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TimeoutStartUSecUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TimeoutStartUSecRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TimeoutStopUSecUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TimeoutStopUSecRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::WatchdogUSecUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::WatchdogUSecRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::WatchdogTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::WatchdogTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::WatchdogTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::WatchdogTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StartLimitIntervalUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StartLimitIntervalRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StartLimitBurstUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StartLimitBurstRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StartLimitActionUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StartLimitActionRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RebootArgumentUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RebootArgumentRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::FailureActionUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::FailureActionRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PermissionsStartOnlyUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PermissionsStartOnlyRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RootDirectoryStartOnlyUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RootDirectoryStartOnlyRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RemainAfterExitUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RemainAfterExitRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::GuessMainPIDUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::GuessMainPIDRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::MainPIDUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::MainPIDRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ControlPIDUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ControlPIDRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::BusNameUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::BusNameRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::FileDescriptorStoreMaxUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::FileDescriptorStoreMaxRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StatusTextUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StatusTextRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StatusErrnoUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StatusErrnoRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ResultUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ResultRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainPIDUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainPIDRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainCodeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainCodeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecMainStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecStartPreUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecStartPreRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecStartUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecStartRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecStartPostUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecStartPostRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecReloadUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecReloadRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecStopUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecStopRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecStopPostUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ExecStopPostRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SliceUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SliceRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ControlGroupUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ControlGroupRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::MemoryCurrentUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::MemoryCurrentRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUUsageNSecUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUUsageNSecRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::DelegateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::DelegateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUAccountingUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUAccountingRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUSharesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUSharesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StartupCPUSharesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StartupCPUSharesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUQuotaPerSecUSecUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUQuotaPerSecUSecRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::BlockIOAccountingUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::BlockIOAccountingRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::BlockIOWeightUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::BlockIOWeightRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StartupBlockIOWeightUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StartupBlockIOWeightRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::BlockIODeviceWeightUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::BlockIODeviceWeightRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::BlockIOReadBandwidthUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::BlockIOReadBandwidthRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::BlockIOWriteBandwidthUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::BlockIOWriteBandwidthRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::MemoryAccountingUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::MemoryAccountingRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::MemoryLimitUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::MemoryLimitRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::DevicePolicyUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::DevicePolicyRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::DeviceAllowUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::DeviceAllowRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::EnvironmentUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::EnvironmentRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::EnvironmentFilesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::EnvironmentFilesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::UMaskUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::UMaskRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitCPUUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitCPURegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitFSIZEUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitFSIZERegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitDATAUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitDATARegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitSTACKUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitSTACKRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitCOREUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitCORERegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitRSSUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitRSSRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitNOFILEUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitNOFILERegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitASUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitASRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitNPROCUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitNPROCRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitMEMLOCKUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitMEMLOCKRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitLOCKSUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitLOCKSRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitSIGPENDINGUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitSIGPENDINGRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitMSGQUEUEUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitMSGQUEUERegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitNICEUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitNICERegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitRTPRIOUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitRTPRIORegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitRTTIMEUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::LimitRTTIMERegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::WorkingDirectoryUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::WorkingDirectoryRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RootDirectoryUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RootDirectoryRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::OOMScoreAdjustUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::OOMScoreAdjustRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::NiceUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::NiceRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::IOSchedulingUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::IOSchedulingRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUSchedulingPolicyUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUSchedulingPolicyRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUSchedulingPriorityUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUSchedulingPriorityRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUAffinityUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUAffinityRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TimerSlackNSecUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TimerSlackNSecRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUSchedulingResetOnForkUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CPUSchedulingResetOnForkRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::NonBlockingUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::NonBlockingRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StandardInputUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StandardInputRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StandardOutputUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StandardOutputRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StandardErrorUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::StandardErrorRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TTYPathUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TTYPathRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TTYResetUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TTYResetRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TTYVHangupUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TTYVHangupRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TTYVTDisallocateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::TTYVTDisallocateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SyslogPriorityUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SyslogPriorityRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SyslogIdentifierUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SyslogIdentifierRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SyslogLevelPrefixUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SyslogLevelPrefixRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CapabilitiesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CapabilitiesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SecureBitsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SecureBitsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CapabilityBoundingSetUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::CapabilityBoundingSetRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::UserUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::UserRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::GroupUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::GroupRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SupplementaryGroupsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SupplementaryGroupsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PAMNameUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PAMNameRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ReadWriteDirectoriesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ReadWriteDirectoriesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ReadOnlyDirectoriesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ReadOnlyDirectoriesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::InaccessibleDirectoriesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::InaccessibleDirectoriesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::MountFlagsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::MountFlagsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PrivateTmpUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PrivateTmpRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PrivateNetworkUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PrivateNetworkRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PrivateDevicesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PrivateDevicesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ProtectHomeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ProtectHomeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ProtectSystemUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::ProtectSystemRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SameProcessGroupUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SameProcessGroupRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::UtmpIdentifierUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::UtmpIdentifierRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::UtmpModeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::UtmpModeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SELinuxContextUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SELinuxContextRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::AppArmorProfileUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::AppArmorProfileRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SmackProcessLabelUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SmackProcessLabelRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::IgnoreSIGPIPEUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::IgnoreSIGPIPERegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::NoNewPrivilegesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::NoNewPrivilegesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SystemCallFilterUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SystemCallFilterRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SystemCallArchitecturesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SystemCallArchitecturesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SystemCallErrorNumberUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SystemCallErrorNumberRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PersonalityUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::PersonalityRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RestrictAddressFamiliesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RestrictAddressFamiliesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RuntimeDirectoryModeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RuntimeDirectoryModeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RuntimeDirectoryUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::RuntimeDirectoryRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::KillModeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::KillModeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::KillSignalUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::KillSignalRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SendSIGKILLUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SendSIGKILLRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SendSIGHUPUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Service::SendSIGHUPRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org

