/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "org/freedesktop/systemd1/Service.h"
#include "org/freedesktop/systemd1/ServiceDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of execData

void serializeDBus (const ::org::freedesktop::systemd1::Service::execData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        const char* o1 = in.getBinaryPath().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o1));
        DBusMessageIter o2ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o0Struct, DBUS_TYPE_ARRAY, "s", &o2ArrayIter));
        const ::std::vector< ::std::string >* o3 = &in.getArguments();
        ::std::vector< ::std::string >::const_iterator o4 = o3->end();
        for (::std::vector< ::std::string >::const_iterator o5 = o3->begin(); o5 != o4; ++o5) {
            const char* o6 = (*o5).c_str();
            DBUS_ASSERT(dbus_message_iter_append_basic(&o2ArrayIter, DBUS_TYPE_STRING, &o6));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o0Struct, &o2ArrayIter));
        dbus_bool_t o7 = in.getExitType() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_BOOLEAN, &o7));
        uint64 o8 = in.getClockRealTimeStartUSec();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT64, &o8));
        uint64 o9 = in.getClockMonotonicStartUSec();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT64, &o9));
        uint64 o10 = in.getClockRealTimeFinishUSec();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT64, &o10));
        uint64 o11 = in.getClockMonotonicFinishUSec();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT64, &o11));
        uint32 o12 = in.getPID();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o12));
        int32 o13 = in.getExitStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_INT32, &o13));
        int32 o14 = in.getLastRunStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_INT32, &o14));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::execData& out) {
    {
        DBusMessageIter o15;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o15);
                {
                    ::std::string binaryPathValue;
                    ::std::string &binaryPathTmpValue = binaryPathValue;
                    {
                        char* o16 = 0;
                        dbus_message_iter_get_basic(&o15, &o16);
                        binaryPathTmpValue.assign (o16);
                    }
                    out.setBinaryPath(binaryPathValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::std::string > argumentsValue;

                    if (dbus_message_iter_get_arg_type(&o15) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o17ArrayIter;
                        dbus_message_iter_recurse (&o15, &o17ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o17ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::std::string o18;
                                {
                                    char* o19 = 0;
                                    dbus_message_iter_get_basic(&o17ArrayIter, &o19);
                                    o18.assign (o19);
                                }
                                argumentsValue.push_back(o18);
                            } while (dbus_message_iter_next(&o17ArrayIter));
                        }
                    }
                    out.setArguments(argumentsValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

                {
                    bool exitTypeValue;
                    bool &exitTypeTmpValue = exitTypeValue;
                    {
                        dbus_bool_t o20;
                        dbus_message_iter_get_basic(&o15, &o20);
                        exitTypeTmpValue = o20 ? true : false;
                    }
                    out.setExitType(exitTypeValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

                {
                    uint64 clockRealTimeStartUSecValue;
                    uint64 &clockRealTimeStartUSecTmpValue = clockRealTimeStartUSecValue;
                    dbus_message_iter_get_basic(&o15, &clockRealTimeStartUSecTmpValue);
                    out.setClockRealTimeStartUSec(clockRealTimeStartUSecValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

                {
                    uint64 clockMonotonicStartUSecValue;
                    uint64 &clockMonotonicStartUSecTmpValue = clockMonotonicStartUSecValue;
                    dbus_message_iter_get_basic(&o15, &clockMonotonicStartUSecTmpValue);
                    out.setClockMonotonicStartUSec(clockMonotonicStartUSecValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

                {
                    uint64 clockRealTimeFinishUSecValue;
                    uint64 &clockRealTimeFinishUSecTmpValue = clockRealTimeFinishUSecValue;
                    dbus_message_iter_get_basic(&o15, &clockRealTimeFinishUSecTmpValue);
                    out.setClockRealTimeFinishUSec(clockRealTimeFinishUSecValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

                {
                    uint64 clockMonotonicFinishUSecValue;
                    uint64 &clockMonotonicFinishUSecTmpValue = clockMonotonicFinishUSecValue;
                    dbus_message_iter_get_basic(&o15, &clockMonotonicFinishUSecTmpValue);
                    out.setClockMonotonicFinishUSec(clockMonotonicFinishUSecValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

                {
                    uint32 PIDValue;
                    uint32 &PIDTmpValue = PIDValue;
                    dbus_message_iter_get_basic(&o15, &PIDTmpValue);
                    out.setPID(PIDValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

                {
                    int32 exitStatusValue;
                    int32 &exitStatusTmpValue = exitStatusValue;
                    dbus_message_iter_get_basic(&o15, &exitStatusTmpValue);
                    out.setExitStatus(exitStatusValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

                {
                    int32 lastRunStatusValue;
                    int32 &lastRunStatusTmpValue = lastRunStatusValue;
                    dbus_message_iter_get_basic(&o15, &lastRunStatusTmpValue);
                    out.setLastRunStatus(lastRunStatusValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of blockIOData

void serializeDBus (const ::org::freedesktop::systemd1::Service::blockIOData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o21Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o21Struct));
        const char* o22 = in.getDeviceName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o21Struct, DBUS_TYPE_STRING, &o22));
        uint64 o23 = in.getValue();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o21Struct, DBUS_TYPE_UINT64, &o23));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o21Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::blockIOData& out) {
    {
        DBusMessageIter o24;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o24);
                {
                    ::std::string deviceNameValue;
                    ::std::string &deviceNameTmpValue = deviceNameValue;
                    {
                        char* o25 = 0;
                        dbus_message_iter_get_basic(&o24, &o25);
                        deviceNameTmpValue.assign (o25);
                    }
                    out.setDeviceName(deviceNameValue);
                }

                if (dbus_message_iter_has_next(&o24)) {
                    dbus_message_iter_next(&o24);
                } else {
                    return true;
                }

                {
                    uint64 valueValue;
                    uint64 &valueTmpValue = valueValue;
                    dbus_message_iter_get_basic(&o24, &valueTmpValue);
                    out.setValue(valueValue);
                }

                if (dbus_message_iter_has_next(&o24)) {
                    dbus_message_iter_next(&o24);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of deviceNode

void serializeDBus (const ::org::freedesktop::systemd1::Service::deviceNode& in, DBusMessageIter* out) {
    {
        DBusMessageIter o26Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o26Struct));
        const char* o27 = in.getNodeName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o26Struct, DBUS_TYPE_STRING, &o27));
        const char* o28 = in.getMode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o26Struct, DBUS_TYPE_STRING, &o28));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o26Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::deviceNode& out) {
    {
        DBusMessageIter o29;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o29);
                {
                    ::std::string nodeNameValue;
                    ::std::string &nodeNameTmpValue = nodeNameValue;
                    {
                        char* o30 = 0;
                        dbus_message_iter_get_basic(&o29, &o30);
                        nodeNameTmpValue.assign (o30);
                    }
                    out.setNodeName(nodeNameValue);
                }

                if (dbus_message_iter_has_next(&o29)) {
                    dbus_message_iter_next(&o29);
                } else {
                    return true;
                }

                {
                    ::std::string modeValue;
                    ::std::string &modeTmpValue = modeValue;
                    {
                        char* o31 = 0;
                        dbus_message_iter_get_basic(&o29, &o31);
                        modeTmpValue.assign (o31);
                    }
                    out.setMode(modeValue);
                }

                if (dbus_message_iter_has_next(&o29)) {
                    dbus_message_iter_next(&o29);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of EnvironmentFile

void serializeDBus (const ::org::freedesktop::systemd1::Service::EnvironmentFile& in, DBusMessageIter* out) {
    {
        DBusMessageIter o32Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o32Struct));
        const char* o33 = in.getFileName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o32Struct, DBUS_TYPE_STRING, &o33));
        dbus_bool_t o34 = in.getActive() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o32Struct, DBUS_TYPE_BOOLEAN, &o34));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o32Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::EnvironmentFile& out) {
    {
        DBusMessageIter o35;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o35);
                {
                    ::std::string fileNameValue;
                    ::std::string &fileNameTmpValue = fileNameValue;
                    {
                        char* o36 = 0;
                        dbus_message_iter_get_basic(&o35, &o36);
                        fileNameTmpValue.assign (o36);
                    }
                    out.setFileName(fileNameValue);
                }

                if (dbus_message_iter_has_next(&o35)) {
                    dbus_message_iter_next(&o35);
                } else {
                    return true;
                }

                {
                    bool activeValue;
                    bool &activeTmpValue = activeValue;
                    {
                        dbus_bool_t o37;
                        dbus_message_iter_get_basic(&o35, &o37);
                        activeTmpValue = o37 ? true : false;
                    }
                    out.setActive(activeValue);
                }

                if (dbus_message_iter_has_next(&o35)) {
                    dbus_message_iter_next(&o35);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of securityContext

void serializeDBus (const ::org::freedesktop::systemd1::Service::securityContext& in, DBusMessageIter* out) {
    {
        DBusMessageIter o38Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o38Struct));
        dbus_bool_t o39 = in.getEnable() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o38Struct, DBUS_TYPE_BOOLEAN, &o39));
        const char* o40 = in.getSecurityContext().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o38Struct, DBUS_TYPE_STRING, &o40));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o38Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::securityContext& out) {
    {
        DBusMessageIter o41;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o41);
                {
                    bool enableValue;
                    bool &enableTmpValue = enableValue;
                    {
                        dbus_bool_t o42;
                        dbus_message_iter_get_basic(&o41, &o42);
                        enableTmpValue = o42 ? true : false;
                    }
                    out.setEnable(enableValue);
                }

                if (dbus_message_iter_has_next(&o41)) {
                    dbus_message_iter_next(&o41);
                } else {
                    return true;
                }

                {
                    ::std::string securityContextValue;
                    ::std::string &securityContextTmpValue = securityContextValue;
                    {
                        char* o43 = 0;
                        dbus_message_iter_get_basic(&o41, &o43);
                        securityContextTmpValue.assign (o43);
                    }
                    out.setSecurityContext(securityContextValue);
                }

                if (dbus_message_iter_has_next(&o41)) {
                    dbus_message_iter_next(&o41);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of ArmorProfile

void serializeDBus (const ::org::freedesktop::systemd1::Service::ArmorProfile& in, DBusMessageIter* out) {
    {
        DBusMessageIter o44Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o44Struct));
        dbus_bool_t o45 = in.getEnable() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o44Struct, DBUS_TYPE_BOOLEAN, &o45));
        const char* o46 = in.getProfile().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o44Struct, DBUS_TYPE_STRING, &o46));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o44Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ArmorProfile& out) {
    {
        DBusMessageIter o47;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o47);
                {
                    bool enableValue;
                    bool &enableTmpValue = enableValue;
                    {
                        dbus_bool_t o48;
                        dbus_message_iter_get_basic(&o47, &o48);
                        enableTmpValue = o48 ? true : false;
                    }
                    out.setEnable(enableValue);
                }

                if (dbus_message_iter_has_next(&o47)) {
                    dbus_message_iter_next(&o47);
                } else {
                    return true;
                }

                {
                    ::std::string profileValue;
                    ::std::string &profileTmpValue = profileValue;
                    {
                        char* o49 = 0;
                        dbus_message_iter_get_basic(&o47, &o49);
                        profileTmpValue.assign (o49);
                    }
                    out.setProfile(profileValue);
                }

                if (dbus_message_iter_has_next(&o47)) {
                    dbus_message_iter_next(&o47);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of ProcessLabel

void serializeDBus (const ::org::freedesktop::systemd1::Service::ProcessLabel& in, DBusMessageIter* out) {
    {
        DBusMessageIter o50Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o50Struct));
        dbus_bool_t o51 = in.getEnable() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o50Struct, DBUS_TYPE_BOOLEAN, &o51));
        const char* o52 = in.getLabel().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o50Struct, DBUS_TYPE_STRING, &o52));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o50Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ProcessLabel& out) {
    {
        DBusMessageIter o53;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o53);
                {
                    bool enableValue;
                    bool &enableTmpValue = enableValue;
                    {
                        dbus_bool_t o54;
                        dbus_message_iter_get_basic(&o53, &o54);
                        enableTmpValue = o54 ? true : false;
                    }
                    out.setEnable(enableValue);
                }

                if (dbus_message_iter_has_next(&o53)) {
                    dbus_message_iter_next(&o53);
                } else {
                    return true;
                }

                {
                    ::std::string labelValue;
                    ::std::string &labelTmpValue = labelValue;
                    {
                        char* o55 = 0;
                        dbus_message_iter_get_basic(&o53, &o55);
                        labelTmpValue.assign (o55);
                    }
                    out.setLabel(labelValue);
                }

                if (dbus_message_iter_has_next(&o53)) {
                    dbus_message_iter_next(&o53);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of systemCallFilter

void serializeDBus (const ::org::freedesktop::systemd1::Service::systemCallFilter& in, DBusMessageIter* out) {
    {
        DBusMessageIter o56Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o56Struct));
        dbus_bool_t o57 = in.getEnable() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o56Struct, DBUS_TYPE_BOOLEAN, &o57));
        DBusMessageIter o58ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o56Struct, DBUS_TYPE_ARRAY, "s", &o58ArrayIter));
        const ::std::vector< ::std::string >* o59 = &in.getSystemCalls();
        ::std::vector< ::std::string >::const_iterator o60 = o59->end();
        for (::std::vector< ::std::string >::const_iterator o61 = o59->begin(); o61 != o60; ++o61) {
            const char* o62 = (*o61).c_str();
            DBUS_ASSERT(dbus_message_iter_append_basic(&o58ArrayIter, DBUS_TYPE_STRING, &o62));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o56Struct, &o58ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o56Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::systemCallFilter& out) {
    {
        DBusMessageIter o63;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o63);
                {
                    bool enableValue;
                    bool &enableTmpValue = enableValue;
                    {
                        dbus_bool_t o64;
                        dbus_message_iter_get_basic(&o63, &o64);
                        enableTmpValue = o64 ? true : false;
                    }
                    out.setEnable(enableValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::std::string > systemCallsValue;

                    if (dbus_message_iter_get_arg_type(&o63) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o65ArrayIter;
                        dbus_message_iter_recurse (&o63, &o65ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o65ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::std::string o66;
                                {
                                    char* o67 = 0;
                                    dbus_message_iter_get_basic(&o65ArrayIter, &o67);
                                    o66.assign (o67);
                                }
                                systemCallsValue.push_back(o66);
                            } while (dbus_message_iter_next(&o65ArrayIter));
                        }
                    }
                    out.setSystemCalls(systemCallsValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of AddressFamily

void serializeDBus (const ::org::freedesktop::systemd1::Service::AddressFamily& in, DBusMessageIter* out) {
    {
        DBusMessageIter o68Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o68Struct));
        dbus_bool_t o69 = in.getEnable() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o68Struct, DBUS_TYPE_BOOLEAN, &o69));
        DBusMessageIter o70ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o68Struct, DBUS_TYPE_ARRAY, "s", &o70ArrayIter));
        const ::std::vector< ::std::string >* o71 = &in.getAddresses();
        ::std::vector< ::std::string >::const_iterator o72 = o71->end();
        for (::std::vector< ::std::string >::const_iterator o73 = o71->begin(); o73 != o72; ++o73) {
            const char* o74 = (*o73).c_str();
            DBUS_ASSERT(dbus_message_iter_append_basic(&o70ArrayIter, DBUS_TYPE_STRING, &o74));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o68Struct, &o70ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o68Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::AddressFamily& out) {
    {
        DBusMessageIter o75;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o75);
                {
                    bool enableValue;
                    bool &enableTmpValue = enableValue;
                    {
                        dbus_bool_t o76;
                        dbus_message_iter_get_basic(&o75, &o76);
                        enableTmpValue = o76 ? true : false;
                    }
                    out.setEnable(enableValue);
                }

                if (dbus_message_iter_has_next(&o75)) {
                    dbus_message_iter_next(&o75);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::std::string > addressesValue;

                    if (dbus_message_iter_get_arg_type(&o75) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o77ArrayIter;
                        dbus_message_iter_recurse (&o75, &o77ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o77ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::std::string o78;
                                {
                                    char* o79 = 0;
                                    dbus_message_iter_get_basic(&o77ArrayIter, &o79);
                                    o78.assign (o79);
                                }
                                addressesValue.push_back(o78);
                            } while (dbus_message_iter_next(&o77ArrayIter));
                        }
                    }
                    out.setAddresses(addressesValue);
                }

                if (dbus_message_iter_has_next(&o75)) {
                    dbus_message_iter_next(&o75);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of TypeUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::TypeUpdate& in, DBusMessageIter* out) {
    const char* o80 = in.getType().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o80));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::TypeUpdate& out) {
    {
        ::std::string TypeValue;
        ::std::string &TypeTmpValue = TypeValue;
        {
            char* o81 = 0;
            dbus_message_iter_get_basic(in, &o81);
            TypeTmpValue.assign (o81);
        }
        out.setType(TypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TypeRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::TypeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::TypeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RestartUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::RestartUpdate& in, DBusMessageIter* out) {
    const char* o82 = in.getRestart().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o82));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::RestartUpdate& out) {
    {
        ::std::string RestartValue;
        ::std::string &RestartTmpValue = RestartValue;
        {
            char* o83 = 0;
            dbus_message_iter_get_basic(in, &o83);
            RestartTmpValue.assign (o83);
        }
        out.setRestart(RestartValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RestartRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::RestartRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::RestartRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PIDFileUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::PIDFileUpdate& in, DBusMessageIter* out) {
    const char* o84 = in.getPIDFile().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o84));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::PIDFileUpdate& out) {
    {
        ::std::string PIDFileValue;
        ::std::string &PIDFileTmpValue = PIDFileValue;
        {
            char* o85 = 0;
            dbus_message_iter_get_basic(in, &o85);
            PIDFileTmpValue.assign (o85);
        }
        out.setPIDFile(PIDFileValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PIDFileRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::PIDFileRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::PIDFileRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NotifyAccessUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::NotifyAccessUpdate& in, DBusMessageIter* out) {
    const char* o86 = in.getNotifyAccess().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o86));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::NotifyAccessUpdate& out) {
    {
        ::std::string NotifyAccessValue;
        ::std::string &NotifyAccessTmpValue = NotifyAccessValue;
        {
            char* o87 = 0;
            dbus_message_iter_get_basic(in, &o87);
            NotifyAccessTmpValue.assign (o87);
        }
        out.setNotifyAccess(NotifyAccessValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NotifyAccessRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::NotifyAccessRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::NotifyAccessRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RestartUSecUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::RestartUSecUpdate& in, DBusMessageIter* out) {
    uint64 o88 = in.getRestartUSec();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o88));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::RestartUSecUpdate& out) {
    {
        uint64 RestartUSecValue;
        uint64 &RestartUSecTmpValue = RestartUSecValue;
        dbus_message_iter_get_basic(in, &RestartUSecTmpValue);
        out.setRestartUSec(RestartUSecValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RestartUSecRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::RestartUSecRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::RestartUSecRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TimeoutStartUSecUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::TimeoutStartUSecUpdate& in, DBusMessageIter* out) {
    uint64 o89 = in.getTimeoutStartUSec();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o89));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::TimeoutStartUSecUpdate& out) {
    {
        uint64 TimeoutStartUSecValue;
        uint64 &TimeoutStartUSecTmpValue = TimeoutStartUSecValue;
        dbus_message_iter_get_basic(in, &TimeoutStartUSecTmpValue);
        out.setTimeoutStartUSec(TimeoutStartUSecValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TimeoutStartUSecRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::TimeoutStartUSecRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::TimeoutStartUSecRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TimeoutStopUSecUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::TimeoutStopUSecUpdate& in, DBusMessageIter* out) {
    uint64 o90 = in.getTimeoutStopUSec();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o90));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::TimeoutStopUSecUpdate& out) {
    {
        uint64 TimeoutStopUSecValue;
        uint64 &TimeoutStopUSecTmpValue = TimeoutStopUSecValue;
        dbus_message_iter_get_basic(in, &TimeoutStopUSecTmpValue);
        out.setTimeoutStopUSec(TimeoutStopUSecValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TimeoutStopUSecRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::TimeoutStopUSecRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::TimeoutStopUSecRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of WatchdogUSecUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::WatchdogUSecUpdate& in, DBusMessageIter* out) {
    uint64 o91 = in.getWatchdogUSec();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o91));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::WatchdogUSecUpdate& out) {
    {
        uint64 WatchdogUSecValue;
        uint64 &WatchdogUSecTmpValue = WatchdogUSecValue;
        dbus_message_iter_get_basic(in, &WatchdogUSecTmpValue);
        out.setWatchdogUSec(WatchdogUSecValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WatchdogUSecRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::WatchdogUSecRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::WatchdogUSecRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of WatchdogTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::WatchdogTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o92 = in.getWatchdogTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o92));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::WatchdogTimestampUpdate& out) {
    {
        uint64 WatchdogTimestampValue;
        uint64 &WatchdogTimestampTmpValue = WatchdogTimestampValue;
        dbus_message_iter_get_basic(in, &WatchdogTimestampTmpValue);
        out.setWatchdogTimestamp(WatchdogTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WatchdogTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::WatchdogTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::WatchdogTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of WatchdogTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::WatchdogTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o93 = in.getWatchdogTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o93));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::WatchdogTimestampMonotonicUpdate& out) {
    {
        uint64 WatchdogTimestampMonotonicValue;
        uint64 &WatchdogTimestampMonotonicTmpValue = WatchdogTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &WatchdogTimestampMonotonicTmpValue);
        out.setWatchdogTimestampMonotonic(WatchdogTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WatchdogTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::WatchdogTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::WatchdogTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of StartLimitIntervalUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::StartLimitIntervalUpdate& in, DBusMessageIter* out) {
    uint64 o94 = in.getStartLimitInterval();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o94));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::StartLimitIntervalUpdate& out) {
    {
        uint64 StartLimitIntervalValue;
        uint64 &StartLimitIntervalTmpValue = StartLimitIntervalValue;
        dbus_message_iter_get_basic(in, &StartLimitIntervalTmpValue);
        out.setStartLimitInterval(StartLimitIntervalValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartLimitIntervalRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::StartLimitIntervalRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::StartLimitIntervalRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of StartLimitBurstUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::StartLimitBurstUpdate& in, DBusMessageIter* out) {
    uint32 o95 = in.getStartLimitBurst();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o95));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::StartLimitBurstUpdate& out) {
    {
        uint32 StartLimitBurstValue;
        uint32 &StartLimitBurstTmpValue = StartLimitBurstValue;
        dbus_message_iter_get_basic(in, &StartLimitBurstTmpValue);
        out.setStartLimitBurst(StartLimitBurstValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartLimitBurstRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::StartLimitBurstRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::StartLimitBurstRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of StartLimitActionUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::StartLimitActionUpdate& in, DBusMessageIter* out) {
    const char* o96 = in.getStartLimitAction().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o96));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::StartLimitActionUpdate& out) {
    {
        ::std::string StartLimitActionValue;
        ::std::string &StartLimitActionTmpValue = StartLimitActionValue;
        {
            char* o97 = 0;
            dbus_message_iter_get_basic(in, &o97);
            StartLimitActionTmpValue.assign (o97);
        }
        out.setStartLimitAction(StartLimitActionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartLimitActionRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::StartLimitActionRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::StartLimitActionRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RebootArgumentUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::RebootArgumentUpdate& in, DBusMessageIter* out) {
    const char* o98 = in.getRebootArgument().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o98));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::RebootArgumentUpdate& out) {
    {
        ::std::string RebootArgumentValue;
        ::std::string &RebootArgumentTmpValue = RebootArgumentValue;
        {
            char* o99 = 0;
            dbus_message_iter_get_basic(in, &o99);
            RebootArgumentTmpValue.assign (o99);
        }
        out.setRebootArgument(RebootArgumentValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RebootArgumentRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::RebootArgumentRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::RebootArgumentRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of FailureActionUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::FailureActionUpdate& in, DBusMessageIter* out) {
    const char* o100 = in.getFailureAction().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o100));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::FailureActionUpdate& out) {
    {
        ::std::string FailureActionValue;
        ::std::string &FailureActionTmpValue = FailureActionValue;
        {
            char* o101 = 0;
            dbus_message_iter_get_basic(in, &o101);
            FailureActionTmpValue.assign (o101);
        }
        out.setFailureAction(FailureActionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FailureActionRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::FailureActionRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::FailureActionRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PermissionsStartOnlyUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::PermissionsStartOnlyUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o102 = in.getPermissionsStartOnly() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o102));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::PermissionsStartOnlyUpdate& out) {
    {
        bool PermissionsStartOnlyValue;
        bool &PermissionsStartOnlyTmpValue = PermissionsStartOnlyValue;
        {
            dbus_bool_t o103;
            dbus_message_iter_get_basic(in, &o103);
            PermissionsStartOnlyTmpValue = o103 ? true : false;
        }
        out.setPermissionsStartOnly(PermissionsStartOnlyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PermissionsStartOnlyRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::PermissionsStartOnlyRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::PermissionsStartOnlyRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RootDirectoryStartOnlyUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::RootDirectoryStartOnlyUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o104 = in.getRootDirectoryStartOnly() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o104));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::RootDirectoryStartOnlyUpdate& out) {
    {
        bool RootDirectoryStartOnlyValue;
        bool &RootDirectoryStartOnlyTmpValue = RootDirectoryStartOnlyValue;
        {
            dbus_bool_t o105;
            dbus_message_iter_get_basic(in, &o105);
            RootDirectoryStartOnlyTmpValue = o105 ? true : false;
        }
        out.setRootDirectoryStartOnly(RootDirectoryStartOnlyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RootDirectoryStartOnlyRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::RootDirectoryStartOnlyRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::RootDirectoryStartOnlyRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RemainAfterExitUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::RemainAfterExitUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o106 = in.getRemainAfterExit() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o106));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::RemainAfterExitUpdate& out) {
    {
        bool RemainAfterExitValue;
        bool &RemainAfterExitTmpValue = RemainAfterExitValue;
        {
            dbus_bool_t o107;
            dbus_message_iter_get_basic(in, &o107);
            RemainAfterExitTmpValue = o107 ? true : false;
        }
        out.setRemainAfterExit(RemainAfterExitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RemainAfterExitRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::RemainAfterExitRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::RemainAfterExitRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of GuessMainPIDUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::GuessMainPIDUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o108 = in.getGuessMainPID() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o108));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::GuessMainPIDUpdate& out) {
    {
        bool GuessMainPIDValue;
        bool &GuessMainPIDTmpValue = GuessMainPIDValue;
        {
            dbus_bool_t o109;
            dbus_message_iter_get_basic(in, &o109);
            GuessMainPIDTmpValue = o109 ? true : false;
        }
        out.setGuessMainPID(GuessMainPIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GuessMainPIDRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::GuessMainPIDRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::GuessMainPIDRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MainPIDUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::MainPIDUpdate& in, DBusMessageIter* out) {
    uint32 o110 = in.getMainPID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o110));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::MainPIDUpdate& out) {
    {
        uint32 MainPIDValue;
        uint32 &MainPIDTmpValue = MainPIDValue;
        dbus_message_iter_get_basic(in, &MainPIDTmpValue);
        out.setMainPID(MainPIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MainPIDRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::MainPIDRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::MainPIDRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ControlPIDUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ControlPIDUpdate& in, DBusMessageIter* out) {
    uint32 o111 = in.getControlPID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o111));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ControlPIDUpdate& out) {
    {
        uint32 ControlPIDValue;
        uint32 &ControlPIDTmpValue = ControlPIDValue;
        dbus_message_iter_get_basic(in, &ControlPIDTmpValue);
        out.setControlPID(ControlPIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ControlPIDRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ControlPIDRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ControlPIDRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BusNameUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::BusNameUpdate& in, DBusMessageIter* out) {
    const char* o112 = in.getBusName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o112));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::BusNameUpdate& out) {
    {
        ::std::string BusNameValue;
        ::std::string &BusNameTmpValue = BusNameValue;
        {
            char* o113 = 0;
            dbus_message_iter_get_basic(in, &o113);
            BusNameTmpValue.assign (o113);
        }
        out.setBusName(BusNameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BusNameRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::BusNameRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::BusNameRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of FileDescriptorStoreMaxUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::FileDescriptorStoreMaxUpdate& in, DBusMessageIter* out) {
    uint32 o114 = in.getFileDescriptorStoreMax();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o114));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::FileDescriptorStoreMaxUpdate& out) {
    {
        uint32 FileDescriptorStoreMaxValue;
        uint32 &FileDescriptorStoreMaxTmpValue = FileDescriptorStoreMaxValue;
        dbus_message_iter_get_basic(in, &FileDescriptorStoreMaxTmpValue);
        out.setFileDescriptorStoreMax(FileDescriptorStoreMaxValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FileDescriptorStoreMaxRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::FileDescriptorStoreMaxRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::FileDescriptorStoreMaxRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of StatusTextUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::StatusTextUpdate& in, DBusMessageIter* out) {
    const char* o115 = in.getStatusText().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o115));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::StatusTextUpdate& out) {
    {
        ::std::string StatusTextValue;
        ::std::string &StatusTextTmpValue = StatusTextValue;
        {
            char* o116 = 0;
            dbus_message_iter_get_basic(in, &o116);
            StatusTextTmpValue.assign (o116);
        }
        out.setStatusText(StatusTextValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StatusTextRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::StatusTextRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::StatusTextRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of StatusErrnoUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::StatusErrnoUpdate& in, DBusMessageIter* out) {
    int32 o117 = in.getStatusErrno();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o117));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::StatusErrnoUpdate& out) {
    {
        int32 StatusErrnoValue;
        int32 &StatusErrnoTmpValue = StatusErrnoValue;
        dbus_message_iter_get_basic(in, &StatusErrnoTmpValue);
        out.setStatusErrno(StatusErrnoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StatusErrnoRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::StatusErrnoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::StatusErrnoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ResultUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ResultUpdate& in, DBusMessageIter* out) {
    const char* o118 = in.getResult().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o118));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ResultUpdate& out) {
    {
        ::std::string ResultValue;
        ::std::string &ResultTmpValue = ResultValue;
        {
            char* o119 = 0;
            dbus_message_iter_get_basic(in, &o119);
            ResultTmpValue.assign (o119);
        }
        out.setResult(ResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ResultRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ResultRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ResultRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecMainStartTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o120 = in.getExecMainStartTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o120));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecMainStartTimestampUpdate& out) {
    {
        uint64 ExecMainStartTimestampValue;
        uint64 &ExecMainStartTimestampTmpValue = ExecMainStartTimestampValue;
        dbus_message_iter_get_basic(in, &ExecMainStartTimestampTmpValue);
        out.setExecMainStartTimestamp(ExecMainStartTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecMainStartTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecMainStartTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecMainStartTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o121 = in.getExecMainStartTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o121));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecMainStartTimestampMonotonicUpdate& out) {
    {
        uint64 ExecMainStartTimestampMonotonicValue;
        uint64 &ExecMainStartTimestampMonotonicTmpValue = ExecMainStartTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &ExecMainStartTimestampMonotonicTmpValue);
        out.setExecMainStartTimestampMonotonic(ExecMainStartTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecMainStartTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainStartTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecMainStartTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecMainExitTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o122 = in.getExecMainExitTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o122));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecMainExitTimestampUpdate& out) {
    {
        uint64 ExecMainExitTimestampValue;
        uint64 &ExecMainExitTimestampTmpValue = ExecMainExitTimestampValue;
        dbus_message_iter_get_basic(in, &ExecMainExitTimestampTmpValue);
        out.setExecMainExitTimestamp(ExecMainExitTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecMainExitTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecMainExitTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecMainExitTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o123 = in.getExecMainExitTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o123));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecMainExitTimestampMonotonicUpdate& out) {
    {
        uint64 ExecMainExitTimestampMonotonicValue;
        uint64 &ExecMainExitTimestampMonotonicTmpValue = ExecMainExitTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &ExecMainExitTimestampMonotonicTmpValue);
        out.setExecMainExitTimestampMonotonic(ExecMainExitTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecMainExitTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainExitTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecMainExitTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecMainPIDUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainPIDUpdate& in, DBusMessageIter* out) {
    uint32 o124 = in.getExecMainPID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o124));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecMainPIDUpdate& out) {
    {
        uint32 ExecMainPIDValue;
        uint32 &ExecMainPIDTmpValue = ExecMainPIDValue;
        dbus_message_iter_get_basic(in, &ExecMainPIDTmpValue);
        out.setExecMainPID(ExecMainPIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecMainPIDRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainPIDRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecMainPIDRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecMainCodeUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainCodeUpdate& in, DBusMessageIter* out) {
    int32 o125 = in.getExecMainCode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o125));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecMainCodeUpdate& out) {
    {
        int32 ExecMainCodeValue;
        int32 &ExecMainCodeTmpValue = ExecMainCodeValue;
        dbus_message_iter_get_basic(in, &ExecMainCodeTmpValue);
        out.setExecMainCode(ExecMainCodeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecMainCodeRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainCodeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecMainCodeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecMainStatusUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainStatusUpdate& in, DBusMessageIter* out) {
    int32 o126 = in.getExecMainStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o126));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecMainStatusUpdate& out) {
    {
        int32 ExecMainStatusValue;
        int32 &ExecMainStatusTmpValue = ExecMainStatusValue;
        dbus_message_iter_get_basic(in, &ExecMainStatusTmpValue);
        out.setExecMainStatus(ExecMainStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecMainStatusRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecMainStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecMainStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecStartPreUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecStartPreUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o127ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sasbttttuii)", &o127ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Service::execData >* o128 = &in.getExecStartPre();
    ::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o129 = o128->end();
    for (::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o130 = o128->begin(); o130 != o129; ++o130) {
        serializeDBus((*o130), &o127ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o127ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecStartPreUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Service::execData > ExecStartPreValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o131ArrayIter;
            dbus_message_iter_recurse (in, &o131ArrayIter);

            if(dbus_message_iter_get_arg_type(&o131ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Service::execData o132;
                    if (!deserializeDBus(&o131ArrayIter, o132)) {
                        return false;
                    }
                    ExecStartPreValue.push_back(o132);
                } while (dbus_message_iter_next(&o131ArrayIter));
            }
        }
        out.setExecStartPre(ExecStartPreValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecStartPreRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecStartPreRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecStartPreRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecStartUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecStartUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o133ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sasbttttuii)", &o133ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Service::execData >* o134 = &in.getExecStart();
    ::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o135 = o134->end();
    for (::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o136 = o134->begin(); o136 != o135; ++o136) {
        serializeDBus((*o136), &o133ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o133ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecStartUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Service::execData > ExecStartValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o137ArrayIter;
            dbus_message_iter_recurse (in, &o137ArrayIter);

            if(dbus_message_iter_get_arg_type(&o137ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Service::execData o138;
                    if (!deserializeDBus(&o137ArrayIter, o138)) {
                        return false;
                    }
                    ExecStartValue.push_back(o138);
                } while (dbus_message_iter_next(&o137ArrayIter));
            }
        }
        out.setExecStart(ExecStartValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecStartRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecStartRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecStartRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecStartPostUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecStartPostUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o139ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sasbttttuii)", &o139ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Service::execData >* o140 = &in.getExecStartPost();
    ::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o141 = o140->end();
    for (::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o142 = o140->begin(); o142 != o141; ++o142) {
        serializeDBus((*o142), &o139ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o139ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecStartPostUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Service::execData > ExecStartPostValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o143ArrayIter;
            dbus_message_iter_recurse (in, &o143ArrayIter);

            if(dbus_message_iter_get_arg_type(&o143ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Service::execData o144;
                    if (!deserializeDBus(&o143ArrayIter, o144)) {
                        return false;
                    }
                    ExecStartPostValue.push_back(o144);
                } while (dbus_message_iter_next(&o143ArrayIter));
            }
        }
        out.setExecStartPost(ExecStartPostValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecStartPostRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecStartPostRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecStartPostRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecReloadUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecReloadUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o145ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sasbttttuii)", &o145ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Service::execData >* o146 = &in.getExecReload();
    ::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o147 = o146->end();
    for (::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o148 = o146->begin(); o148 != o147; ++o148) {
        serializeDBus((*o148), &o145ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o145ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecReloadUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Service::execData > ExecReloadValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o149ArrayIter;
            dbus_message_iter_recurse (in, &o149ArrayIter);

            if(dbus_message_iter_get_arg_type(&o149ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Service::execData o150;
                    if (!deserializeDBus(&o149ArrayIter, o150)) {
                        return false;
                    }
                    ExecReloadValue.push_back(o150);
                } while (dbus_message_iter_next(&o149ArrayIter));
            }
        }
        out.setExecReload(ExecReloadValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecReloadRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecReloadRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecReloadRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecStopUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecStopUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o151ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sasbttttuii)", &o151ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Service::execData >* o152 = &in.getExecStop();
    ::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o153 = o152->end();
    for (::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o154 = o152->begin(); o154 != o153; ++o154) {
        serializeDBus((*o154), &o151ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o151ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecStopUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Service::execData > ExecStopValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o155ArrayIter;
            dbus_message_iter_recurse (in, &o155ArrayIter);

            if(dbus_message_iter_get_arg_type(&o155ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Service::execData o156;
                    if (!deserializeDBus(&o155ArrayIter, o156)) {
                        return false;
                    }
                    ExecStopValue.push_back(o156);
                } while (dbus_message_iter_next(&o155ArrayIter));
            }
        }
        out.setExecStop(ExecStopValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecStopRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecStopRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecStopRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ExecStopPostUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecStopPostUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o157ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sasbttttuii)", &o157ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Service::execData >* o158 = &in.getExecStopPost();
    ::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o159 = o158->end();
    for (::std::vector< ::org::freedesktop::systemd1::Service::execData >::const_iterator o160 = o158->begin(); o160 != o159; ++o160) {
        serializeDBus((*o160), &o157ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o157ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ExecStopPostUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Service::execData > ExecStopPostValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o161ArrayIter;
            dbus_message_iter_recurse (in, &o161ArrayIter);

            if(dbus_message_iter_get_arg_type(&o161ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Service::execData o162;
                    if (!deserializeDBus(&o161ArrayIter, o162)) {
                        return false;
                    }
                    ExecStopPostValue.push_back(o162);
                } while (dbus_message_iter_next(&o161ArrayIter));
            }
        }
        out.setExecStopPost(ExecStopPostValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExecStopPostRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ExecStopPostRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ExecStopPostRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SliceUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SliceUpdate& in, DBusMessageIter* out) {
    const char* o163 = in.getSlice().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o163));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SliceUpdate& out) {
    {
        ::std::string SliceValue;
        ::std::string &SliceTmpValue = SliceValue;
        {
            char* o164 = 0;
            dbus_message_iter_get_basic(in, &o164);
            SliceTmpValue.assign (o164);
        }
        out.setSlice(SliceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SliceRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SliceRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SliceRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ControlGroupUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ControlGroupUpdate& in, DBusMessageIter* out) {
    const char* o165 = in.getControlGroup().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o165));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ControlGroupUpdate& out) {
    {
        ::std::string ControlGroupValue;
        ::std::string &ControlGroupTmpValue = ControlGroupValue;
        {
            char* o166 = 0;
            dbus_message_iter_get_basic(in, &o166);
            ControlGroupTmpValue.assign (o166);
        }
        out.setControlGroup(ControlGroupValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ControlGroupRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ControlGroupRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ControlGroupRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MemoryCurrentUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::MemoryCurrentUpdate& in, DBusMessageIter* out) {
    uint64 o167 = in.getMemoryCurrent();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o167));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::MemoryCurrentUpdate& out) {
    {
        uint64 MemoryCurrentValue;
        uint64 &MemoryCurrentTmpValue = MemoryCurrentValue;
        dbus_message_iter_get_basic(in, &MemoryCurrentTmpValue);
        out.setMemoryCurrent(MemoryCurrentValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MemoryCurrentRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::MemoryCurrentRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::MemoryCurrentRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CPUUsageNSecUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUUsageNSecUpdate& in, DBusMessageIter* out) {
    uint64 o168 = in.getCPUUsageNSec();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o168));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::CPUUsageNSecUpdate& out) {
    {
        uint64 CPUUsageNSecValue;
        uint64 &CPUUsageNSecTmpValue = CPUUsageNSecValue;
        dbus_message_iter_get_basic(in, &CPUUsageNSecTmpValue);
        out.setCPUUsageNSec(CPUUsageNSecValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CPUUsageNSecRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUUsageNSecRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::CPUUsageNSecRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DelegateUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::DelegateUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o169 = in.getDelegate() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o169));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::DelegateUpdate& out) {
    {
        bool DelegateValue;
        bool &DelegateTmpValue = DelegateValue;
        {
            dbus_bool_t o170;
            dbus_message_iter_get_basic(in, &o170);
            DelegateTmpValue = o170 ? true : false;
        }
        out.setDelegate(DelegateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DelegateRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::DelegateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::DelegateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CPUAccountingUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUAccountingUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o171 = in.getCPUAccounting() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o171));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::CPUAccountingUpdate& out) {
    {
        bool CPUAccountingValue;
        bool &CPUAccountingTmpValue = CPUAccountingValue;
        {
            dbus_bool_t o172;
            dbus_message_iter_get_basic(in, &o172);
            CPUAccountingTmpValue = o172 ? true : false;
        }
        out.setCPUAccounting(CPUAccountingValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CPUAccountingRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUAccountingRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::CPUAccountingRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CPUSharesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUSharesUpdate& in, DBusMessageIter* out) {
    uint64 o173 = in.getCPUShares();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o173));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::CPUSharesUpdate& out) {
    {
        uint64 CPUSharesValue;
        uint64 &CPUSharesTmpValue = CPUSharesValue;
        dbus_message_iter_get_basic(in, &CPUSharesTmpValue);
        out.setCPUShares(CPUSharesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CPUSharesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUSharesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::CPUSharesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of StartupCPUSharesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::StartupCPUSharesUpdate& in, DBusMessageIter* out) {
    uint64 o174 = in.getStartupCPUShares();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o174));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::StartupCPUSharesUpdate& out) {
    {
        uint64 StartupCPUSharesValue;
        uint64 &StartupCPUSharesTmpValue = StartupCPUSharesValue;
        dbus_message_iter_get_basic(in, &StartupCPUSharesTmpValue);
        out.setStartupCPUShares(StartupCPUSharesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartupCPUSharesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::StartupCPUSharesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::StartupCPUSharesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CPUQuotaPerSecUSecUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUQuotaPerSecUSecUpdate& in, DBusMessageIter* out) {
    uint64 o175 = in.getCPUQuotaPerSecUSec();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o175));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::CPUQuotaPerSecUSecUpdate& out) {
    {
        uint64 CPUQuotaPerSecUSecValue;
        uint64 &CPUQuotaPerSecUSecTmpValue = CPUQuotaPerSecUSecValue;
        dbus_message_iter_get_basic(in, &CPUQuotaPerSecUSecTmpValue);
        out.setCPUQuotaPerSecUSec(CPUQuotaPerSecUSecValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CPUQuotaPerSecUSecRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUQuotaPerSecUSecRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::CPUQuotaPerSecUSecRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BlockIOAccountingUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::BlockIOAccountingUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o176 = in.getBlockIOAccounting() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o176));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::BlockIOAccountingUpdate& out) {
    {
        bool BlockIOAccountingValue;
        bool &BlockIOAccountingTmpValue = BlockIOAccountingValue;
        {
            dbus_bool_t o177;
            dbus_message_iter_get_basic(in, &o177);
            BlockIOAccountingTmpValue = o177 ? true : false;
        }
        out.setBlockIOAccounting(BlockIOAccountingValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BlockIOAccountingRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::BlockIOAccountingRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::BlockIOAccountingRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BlockIOWeightUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::BlockIOWeightUpdate& in, DBusMessageIter* out) {
    uint64 o178 = in.getBlockIOWeight();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o178));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::BlockIOWeightUpdate& out) {
    {
        uint64 BlockIOWeightValue;
        uint64 &BlockIOWeightTmpValue = BlockIOWeightValue;
        dbus_message_iter_get_basic(in, &BlockIOWeightTmpValue);
        out.setBlockIOWeight(BlockIOWeightValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BlockIOWeightRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::BlockIOWeightRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::BlockIOWeightRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of StartupBlockIOWeightUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::StartupBlockIOWeightUpdate& in, DBusMessageIter* out) {
    uint64 o179 = in.getStartupBlockIOWeight();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o179));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::StartupBlockIOWeightUpdate& out) {
    {
        uint64 StartupBlockIOWeightValue;
        uint64 &StartupBlockIOWeightTmpValue = StartupBlockIOWeightValue;
        dbus_message_iter_get_basic(in, &StartupBlockIOWeightTmpValue);
        out.setStartupBlockIOWeight(StartupBlockIOWeightValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartupBlockIOWeightRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::StartupBlockIOWeightRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::StartupBlockIOWeightRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BlockIODeviceWeightUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::BlockIODeviceWeightUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o180ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(st)", &o180ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >* o181 = &in.getBlockIODeviceWeight();
    ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >::const_iterator o182 = o181->end();
    for (::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >::const_iterator o183 = o181->begin(); o183 != o182; ++o183) {
        serializeDBus((*o183), &o180ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o180ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::BlockIODeviceWeightUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData > BlockIODeviceWeightValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o184ArrayIter;
            dbus_message_iter_recurse (in, &o184ArrayIter);

            if(dbus_message_iter_get_arg_type(&o184ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Service::blockIOData o185;
                    if (!deserializeDBus(&o184ArrayIter, o185)) {
                        return false;
                    }
                    BlockIODeviceWeightValue.push_back(o185);
                } while (dbus_message_iter_next(&o184ArrayIter));
            }
        }
        out.setBlockIODeviceWeight(BlockIODeviceWeightValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BlockIODeviceWeightRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::BlockIODeviceWeightRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::BlockIODeviceWeightRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BlockIOReadBandwidthUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::BlockIOReadBandwidthUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o186ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(st)", &o186ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >* o187 = &in.getBlockIOReadBandwidth();
    ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >::const_iterator o188 = o187->end();
    for (::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >::const_iterator o189 = o187->begin(); o189 != o188; ++o189) {
        serializeDBus((*o189), &o186ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o186ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::BlockIOReadBandwidthUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData > BlockIOReadBandwidthValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o190ArrayIter;
            dbus_message_iter_recurse (in, &o190ArrayIter);

            if(dbus_message_iter_get_arg_type(&o190ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Service::blockIOData o191;
                    if (!deserializeDBus(&o190ArrayIter, o191)) {
                        return false;
                    }
                    BlockIOReadBandwidthValue.push_back(o191);
                } while (dbus_message_iter_next(&o190ArrayIter));
            }
        }
        out.setBlockIOReadBandwidth(BlockIOReadBandwidthValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BlockIOReadBandwidthRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::BlockIOReadBandwidthRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::BlockIOReadBandwidthRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BlockIOWriteBandwidthUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::BlockIOWriteBandwidthUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o192ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(st)", &o192ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >* o193 = &in.getBlockIOWriteBandwidth();
    ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >::const_iterator o194 = o193->end();
    for (::std::vector< ::org::freedesktop::systemd1::Service::blockIOData >::const_iterator o195 = o193->begin(); o195 != o194; ++o195) {
        serializeDBus((*o195), &o192ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o192ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::BlockIOWriteBandwidthUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Service::blockIOData > BlockIOWriteBandwidthValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o196ArrayIter;
            dbus_message_iter_recurse (in, &o196ArrayIter);

            if(dbus_message_iter_get_arg_type(&o196ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Service::blockIOData o197;
                    if (!deserializeDBus(&o196ArrayIter, o197)) {
                        return false;
                    }
                    BlockIOWriteBandwidthValue.push_back(o197);
                } while (dbus_message_iter_next(&o196ArrayIter));
            }
        }
        out.setBlockIOWriteBandwidth(BlockIOWriteBandwidthValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BlockIOWriteBandwidthRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::BlockIOWriteBandwidthRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::BlockIOWriteBandwidthRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MemoryAccountingUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::MemoryAccountingUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o198 = in.getMemoryAccounting() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o198));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::MemoryAccountingUpdate& out) {
    {
        bool MemoryAccountingValue;
        bool &MemoryAccountingTmpValue = MemoryAccountingValue;
        {
            dbus_bool_t o199;
            dbus_message_iter_get_basic(in, &o199);
            MemoryAccountingTmpValue = o199 ? true : false;
        }
        out.setMemoryAccounting(MemoryAccountingValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MemoryAccountingRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::MemoryAccountingRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::MemoryAccountingRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MemoryLimitUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::MemoryLimitUpdate& in, DBusMessageIter* out) {
    uint64 o200 = in.getMemoryLimit();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o200));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::MemoryLimitUpdate& out) {
    {
        uint64 MemoryLimitValue;
        uint64 &MemoryLimitTmpValue = MemoryLimitValue;
        dbus_message_iter_get_basic(in, &MemoryLimitTmpValue);
        out.setMemoryLimit(MemoryLimitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MemoryLimitRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::MemoryLimitRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::MemoryLimitRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DevicePolicyUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::DevicePolicyUpdate& in, DBusMessageIter* out) {
    const char* o201 = in.getDevicePolicy().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o201));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::DevicePolicyUpdate& out) {
    {
        ::std::string DevicePolicyValue;
        ::std::string &DevicePolicyTmpValue = DevicePolicyValue;
        {
            char* o202 = 0;
            dbus_message_iter_get_basic(in, &o202);
            DevicePolicyTmpValue.assign (o202);
        }
        out.setDevicePolicy(DevicePolicyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DevicePolicyRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::DevicePolicyRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::DevicePolicyRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DeviceAllowUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::DeviceAllowUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o203ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(ss)", &o203ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Service::deviceNode >* o204 = &in.getDeviceAllow();
    ::std::vector< ::org::freedesktop::systemd1::Service::deviceNode >::const_iterator o205 = o204->end();
    for (::std::vector< ::org::freedesktop::systemd1::Service::deviceNode >::const_iterator o206 = o204->begin(); o206 != o205; ++o206) {
        serializeDBus((*o206), &o203ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o203ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::DeviceAllowUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Service::deviceNode > DeviceAllowValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o207ArrayIter;
            dbus_message_iter_recurse (in, &o207ArrayIter);

            if(dbus_message_iter_get_arg_type(&o207ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Service::deviceNode o208;
                    if (!deserializeDBus(&o207ArrayIter, o208)) {
                        return false;
                    }
                    DeviceAllowValue.push_back(o208);
                } while (dbus_message_iter_next(&o207ArrayIter));
            }
        }
        out.setDeviceAllow(DeviceAllowValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeviceAllowRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::DeviceAllowRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::DeviceAllowRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of EnvironmentUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::EnvironmentUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o209ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o209ArrayIter));
    const ::std::vector< ::std::string >* o210 = &in.getEnvironment();
    ::std::vector< ::std::string >::const_iterator o211 = o210->end();
    for (::std::vector< ::std::string >::const_iterator o212 = o210->begin(); o212 != o211; ++o212) {
        const char* o213 = (*o212).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o209ArrayIter, DBUS_TYPE_STRING, &o213));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o209ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::EnvironmentUpdate& out) {
    {
        ::std::vector< ::std::string > EnvironmentValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o214ArrayIter;
            dbus_message_iter_recurse (in, &o214ArrayIter);

            if(dbus_message_iter_get_arg_type(&o214ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o215;
                    {
                        char* o216 = 0;
                        dbus_message_iter_get_basic(&o214ArrayIter, &o216);
                        o215.assign (o216);
                    }
                    EnvironmentValue.push_back(o215);
                } while (dbus_message_iter_next(&o214ArrayIter));
            }
        }
        out.setEnvironment(EnvironmentValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EnvironmentRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::EnvironmentRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::EnvironmentRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of EnvironmentFilesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::EnvironmentFilesUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o217ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sb)", &o217ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Service::EnvironmentFile >* o218 = &in.getEnvironmentFiles();
    ::std::vector< ::org::freedesktop::systemd1::Service::EnvironmentFile >::const_iterator o219 = o218->end();
    for (::std::vector< ::org::freedesktop::systemd1::Service::EnvironmentFile >::const_iterator o220 = o218->begin(); o220 != o219; ++o220) {
        serializeDBus((*o220), &o217ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o217ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::EnvironmentFilesUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Service::EnvironmentFile > EnvironmentFilesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o221ArrayIter;
            dbus_message_iter_recurse (in, &o221ArrayIter);

            if(dbus_message_iter_get_arg_type(&o221ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Service::EnvironmentFile o222;
                    if (!deserializeDBus(&o221ArrayIter, o222)) {
                        return false;
                    }
                    EnvironmentFilesValue.push_back(o222);
                } while (dbus_message_iter_next(&o221ArrayIter));
            }
        }
        out.setEnvironmentFiles(EnvironmentFilesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EnvironmentFilesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::EnvironmentFilesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::EnvironmentFilesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UMaskUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::UMaskUpdate& in, DBusMessageIter* out) {
    uint32 o223 = in.getUMask();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o223));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::UMaskUpdate& out) {
    {
        uint32 UMaskValue;
        uint32 &UMaskTmpValue = UMaskValue;
        dbus_message_iter_get_basic(in, &UMaskTmpValue);
        out.setUMask(UMaskValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UMaskRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::UMaskRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::UMaskRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitCPUUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitCPUUpdate& in, DBusMessageIter* out) {
    uint64 o224 = in.getLimitCPU();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o224));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitCPUUpdate& out) {
    {
        uint64 LimitCPUValue;
        uint64 &LimitCPUTmpValue = LimitCPUValue;
        dbus_message_iter_get_basic(in, &LimitCPUTmpValue);
        out.setLimitCPU(LimitCPUValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitCPURegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitCPURegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitCPURegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitFSIZEUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitFSIZEUpdate& in, DBusMessageIter* out) {
    uint64 o225 = in.getLimitFSIZE();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o225));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitFSIZEUpdate& out) {
    {
        uint64 LimitFSIZEValue;
        uint64 &LimitFSIZETmpValue = LimitFSIZEValue;
        dbus_message_iter_get_basic(in, &LimitFSIZETmpValue);
        out.setLimitFSIZE(LimitFSIZEValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitFSIZERegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitFSIZERegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitFSIZERegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitDATAUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitDATAUpdate& in, DBusMessageIter* out) {
    uint64 o226 = in.getLimitDATA();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o226));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitDATAUpdate& out) {
    {
        uint64 LimitDATAValue;
        uint64 &LimitDATATmpValue = LimitDATAValue;
        dbus_message_iter_get_basic(in, &LimitDATATmpValue);
        out.setLimitDATA(LimitDATAValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitDATARegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitDATARegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitDATARegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitSTACKUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitSTACKUpdate& in, DBusMessageIter* out) {
    uint64 o227 = in.getLimitSTACK();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o227));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitSTACKUpdate& out) {
    {
        uint64 LimitSTACKValue;
        uint64 &LimitSTACKTmpValue = LimitSTACKValue;
        dbus_message_iter_get_basic(in, &LimitSTACKTmpValue);
        out.setLimitSTACK(LimitSTACKValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitSTACKRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitSTACKRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitSTACKRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitCOREUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitCOREUpdate& in, DBusMessageIter* out) {
    uint64 o228 = in.getLimitCORE();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o228));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitCOREUpdate& out) {
    {
        uint64 LimitCOREValue;
        uint64 &LimitCORETmpValue = LimitCOREValue;
        dbus_message_iter_get_basic(in, &LimitCORETmpValue);
        out.setLimitCORE(LimitCOREValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitCORERegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitCORERegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitCORERegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitRSSUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitRSSUpdate& in, DBusMessageIter* out) {
    uint64 o229 = in.getLimitRSS();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o229));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitRSSUpdate& out) {
    {
        uint64 LimitRSSValue;
        uint64 &LimitRSSTmpValue = LimitRSSValue;
        dbus_message_iter_get_basic(in, &LimitRSSTmpValue);
        out.setLimitRSS(LimitRSSValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitRSSRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitRSSRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitRSSRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitNOFILEUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitNOFILEUpdate& in, DBusMessageIter* out) {
    uint64 o230 = in.getLimitNOFILE();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o230));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitNOFILEUpdate& out) {
    {
        uint64 LimitNOFILEValue;
        uint64 &LimitNOFILETmpValue = LimitNOFILEValue;
        dbus_message_iter_get_basic(in, &LimitNOFILETmpValue);
        out.setLimitNOFILE(LimitNOFILEValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitNOFILERegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitNOFILERegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitNOFILERegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitASUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitASUpdate& in, DBusMessageIter* out) {
    uint64 o231 = in.getLimitAS();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o231));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitASUpdate& out) {
    {
        uint64 LimitASValue;
        uint64 &LimitASTmpValue = LimitASValue;
        dbus_message_iter_get_basic(in, &LimitASTmpValue);
        out.setLimitAS(LimitASValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitASRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitASRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitASRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitNPROCUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitNPROCUpdate& in, DBusMessageIter* out) {
    uint64 o232 = in.getLimitNPROC();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o232));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitNPROCUpdate& out) {
    {
        uint64 LimitNPROCValue;
        uint64 &LimitNPROCTmpValue = LimitNPROCValue;
        dbus_message_iter_get_basic(in, &LimitNPROCTmpValue);
        out.setLimitNPROC(LimitNPROCValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitNPROCRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitNPROCRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitNPROCRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitMEMLOCKUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitMEMLOCKUpdate& in, DBusMessageIter* out) {
    uint64 o233 = in.getLimitMEMLOCK();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o233));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitMEMLOCKUpdate& out) {
    {
        uint64 LimitMEMLOCKValue;
        uint64 &LimitMEMLOCKTmpValue = LimitMEMLOCKValue;
        dbus_message_iter_get_basic(in, &LimitMEMLOCKTmpValue);
        out.setLimitMEMLOCK(LimitMEMLOCKValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitMEMLOCKRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitMEMLOCKRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitMEMLOCKRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitLOCKSUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitLOCKSUpdate& in, DBusMessageIter* out) {
    uint64 o234 = in.getLimitLOCKS();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o234));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitLOCKSUpdate& out) {
    {
        uint64 LimitLOCKSValue;
        uint64 &LimitLOCKSTmpValue = LimitLOCKSValue;
        dbus_message_iter_get_basic(in, &LimitLOCKSTmpValue);
        out.setLimitLOCKS(LimitLOCKSValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitLOCKSRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitLOCKSRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitLOCKSRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitSIGPENDINGUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitSIGPENDINGUpdate& in, DBusMessageIter* out) {
    uint64 o235 = in.getLimitSIGPENDING();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o235));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitSIGPENDINGUpdate& out) {
    {
        uint64 LimitSIGPENDINGValue;
        uint64 &LimitSIGPENDINGTmpValue = LimitSIGPENDINGValue;
        dbus_message_iter_get_basic(in, &LimitSIGPENDINGTmpValue);
        out.setLimitSIGPENDING(LimitSIGPENDINGValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitSIGPENDINGRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitSIGPENDINGRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitSIGPENDINGRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitMSGQUEUEUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitMSGQUEUEUpdate& in, DBusMessageIter* out) {
    uint64 o236 = in.getLimitMSGQUEUE();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o236));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitMSGQUEUEUpdate& out) {
    {
        uint64 LimitMSGQUEUEValue;
        uint64 &LimitMSGQUEUETmpValue = LimitMSGQUEUEValue;
        dbus_message_iter_get_basic(in, &LimitMSGQUEUETmpValue);
        out.setLimitMSGQUEUE(LimitMSGQUEUEValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitMSGQUEUERegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitMSGQUEUERegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitMSGQUEUERegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitNICEUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitNICEUpdate& in, DBusMessageIter* out) {
    uint64 o237 = in.getLimitNICE();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o237));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitNICEUpdate& out) {
    {
        uint64 LimitNICEValue;
        uint64 &LimitNICETmpValue = LimitNICEValue;
        dbus_message_iter_get_basic(in, &LimitNICETmpValue);
        out.setLimitNICE(LimitNICEValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitNICERegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitNICERegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitNICERegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitRTPRIOUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitRTPRIOUpdate& in, DBusMessageIter* out) {
    uint64 o238 = in.getLimitRTPRIO();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o238));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitRTPRIOUpdate& out) {
    {
        uint64 LimitRTPRIOValue;
        uint64 &LimitRTPRIOTmpValue = LimitRTPRIOValue;
        dbus_message_iter_get_basic(in, &LimitRTPRIOTmpValue);
        out.setLimitRTPRIO(LimitRTPRIOValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitRTPRIORegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitRTPRIORegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitRTPRIORegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LimitRTTIMEUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitRTTIMEUpdate& in, DBusMessageIter* out) {
    uint64 o239 = in.getLimitRTTIME();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o239));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::LimitRTTIMEUpdate& out) {
    {
        uint64 LimitRTTIMEValue;
        uint64 &LimitRTTIMETmpValue = LimitRTTIMEValue;
        dbus_message_iter_get_basic(in, &LimitRTTIMETmpValue);
        out.setLimitRTTIME(LimitRTTIMEValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LimitRTTIMERegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::LimitRTTIMERegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::LimitRTTIMERegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of WorkingDirectoryUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::WorkingDirectoryUpdate& in, DBusMessageIter* out) {
    const char* o240 = in.getWorkingDirectory().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o240));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::WorkingDirectoryUpdate& out) {
    {
        ::std::string WorkingDirectoryValue;
        ::std::string &WorkingDirectoryTmpValue = WorkingDirectoryValue;
        {
            char* o241 = 0;
            dbus_message_iter_get_basic(in, &o241);
            WorkingDirectoryTmpValue.assign (o241);
        }
        out.setWorkingDirectory(WorkingDirectoryValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WorkingDirectoryRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::WorkingDirectoryRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::WorkingDirectoryRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RootDirectoryUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::RootDirectoryUpdate& in, DBusMessageIter* out) {
    const char* o242 = in.getRootDirectory().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o242));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::RootDirectoryUpdate& out) {
    {
        ::std::string RootDirectoryValue;
        ::std::string &RootDirectoryTmpValue = RootDirectoryValue;
        {
            char* o243 = 0;
            dbus_message_iter_get_basic(in, &o243);
            RootDirectoryTmpValue.assign (o243);
        }
        out.setRootDirectory(RootDirectoryValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RootDirectoryRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::RootDirectoryRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::RootDirectoryRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of OOMScoreAdjustUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::OOMScoreAdjustUpdate& in, DBusMessageIter* out) {
    int32 o244 = in.getOOMScoreAdjust();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o244));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::OOMScoreAdjustUpdate& out) {
    {
        int32 OOMScoreAdjustValue;
        int32 &OOMScoreAdjustTmpValue = OOMScoreAdjustValue;
        dbus_message_iter_get_basic(in, &OOMScoreAdjustTmpValue);
        out.setOOMScoreAdjust(OOMScoreAdjustValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OOMScoreAdjustRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::OOMScoreAdjustRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::OOMScoreAdjustRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NiceUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::NiceUpdate& in, DBusMessageIter* out) {
    int32 o245 = in.getNice();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o245));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::NiceUpdate& out) {
    {
        int32 NiceValue;
        int32 &NiceTmpValue = NiceValue;
        dbus_message_iter_get_basic(in, &NiceTmpValue);
        out.setNice(NiceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NiceRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::NiceRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::NiceRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of IOSchedulingUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::IOSchedulingUpdate& in, DBusMessageIter* out) {
    int32 o246 = in.getIOScheduling();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o246));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::IOSchedulingUpdate& out) {
    {
        int32 IOSchedulingValue;
        int32 &IOSchedulingTmpValue = IOSchedulingValue;
        dbus_message_iter_get_basic(in, &IOSchedulingTmpValue);
        out.setIOScheduling(IOSchedulingValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of IOSchedulingRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::IOSchedulingRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::IOSchedulingRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CPUSchedulingPolicyUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUSchedulingPolicyUpdate& in, DBusMessageIter* out) {
    int32 o247 = in.getCPUSchedulingPolicy();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o247));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::CPUSchedulingPolicyUpdate& out) {
    {
        int32 CPUSchedulingPolicyValue;
        int32 &CPUSchedulingPolicyTmpValue = CPUSchedulingPolicyValue;
        dbus_message_iter_get_basic(in, &CPUSchedulingPolicyTmpValue);
        out.setCPUSchedulingPolicy(CPUSchedulingPolicyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CPUSchedulingPolicyRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUSchedulingPolicyRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::CPUSchedulingPolicyRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CPUSchedulingPriorityUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUSchedulingPriorityUpdate& in, DBusMessageIter* out) {
    int32 o248 = in.getCPUSchedulingPriority();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o248));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::CPUSchedulingPriorityUpdate& out) {
    {
        int32 CPUSchedulingPriorityValue;
        int32 &CPUSchedulingPriorityTmpValue = CPUSchedulingPriorityValue;
        dbus_message_iter_get_basic(in, &CPUSchedulingPriorityTmpValue);
        out.setCPUSchedulingPriority(CPUSchedulingPriorityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CPUSchedulingPriorityRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUSchedulingPriorityRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::CPUSchedulingPriorityRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CPUAffinityUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUAffinityUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o249ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o249ArrayIter));
    const ::std::vector< ::std::string >* o250 = &in.getCPUAffinity();
    ::std::vector< ::std::string >::const_iterator o251 = o250->end();
    for (::std::vector< ::std::string >::const_iterator o252 = o250->begin(); o252 != o251; ++o252) {
        const char* o253 = (*o252).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o249ArrayIter, DBUS_TYPE_STRING, &o253));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o249ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::CPUAffinityUpdate& out) {
    {
        ::std::vector< ::std::string > CPUAffinityValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o254ArrayIter;
            dbus_message_iter_recurse (in, &o254ArrayIter);

            if(dbus_message_iter_get_arg_type(&o254ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o255;
                    {
                        char* o256 = 0;
                        dbus_message_iter_get_basic(&o254ArrayIter, &o256);
                        o255.assign (o256);
                    }
                    CPUAffinityValue.push_back(o255);
                } while (dbus_message_iter_next(&o254ArrayIter));
            }
        }
        out.setCPUAffinity(CPUAffinityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CPUAffinityRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUAffinityRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::CPUAffinityRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TimerSlackNSecUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::TimerSlackNSecUpdate& in, DBusMessageIter* out) {
    uint64 o257 = in.getTimerSlackNSec();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o257));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::TimerSlackNSecUpdate& out) {
    {
        uint64 TimerSlackNSecValue;
        uint64 &TimerSlackNSecTmpValue = TimerSlackNSecValue;
        dbus_message_iter_get_basic(in, &TimerSlackNSecTmpValue);
        out.setTimerSlackNSec(TimerSlackNSecValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TimerSlackNSecRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::TimerSlackNSecRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::TimerSlackNSecRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CPUSchedulingResetOnForkUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUSchedulingResetOnForkUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o258 = in.getCPUSchedulingResetOnFork() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o258));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::CPUSchedulingResetOnForkUpdate& out) {
    {
        bool CPUSchedulingResetOnForkValue;
        bool &CPUSchedulingResetOnForkTmpValue = CPUSchedulingResetOnForkValue;
        {
            dbus_bool_t o259;
            dbus_message_iter_get_basic(in, &o259);
            CPUSchedulingResetOnForkTmpValue = o259 ? true : false;
        }
        out.setCPUSchedulingResetOnFork(CPUSchedulingResetOnForkValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CPUSchedulingResetOnForkRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::CPUSchedulingResetOnForkRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::CPUSchedulingResetOnForkRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NonBlockingUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::NonBlockingUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o260 = in.getNonBlocking() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o260));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::NonBlockingUpdate& out) {
    {
        bool NonBlockingValue;
        bool &NonBlockingTmpValue = NonBlockingValue;
        {
            dbus_bool_t o261;
            dbus_message_iter_get_basic(in, &o261);
            NonBlockingTmpValue = o261 ? true : false;
        }
        out.setNonBlocking(NonBlockingValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NonBlockingRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::NonBlockingRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::NonBlockingRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of StandardInputUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::StandardInputUpdate& in, DBusMessageIter* out) {
    const char* o262 = in.getStandardInput().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o262));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::StandardInputUpdate& out) {
    {
        ::std::string StandardInputValue;
        ::std::string &StandardInputTmpValue = StandardInputValue;
        {
            char* o263 = 0;
            dbus_message_iter_get_basic(in, &o263);
            StandardInputTmpValue.assign (o263);
        }
        out.setStandardInput(StandardInputValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StandardInputRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::StandardInputRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::StandardInputRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of StandardOutputUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::StandardOutputUpdate& in, DBusMessageIter* out) {
    const char* o264 = in.getStandardOutput().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o264));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::StandardOutputUpdate& out) {
    {
        ::std::string StandardOutputValue;
        ::std::string &StandardOutputTmpValue = StandardOutputValue;
        {
            char* o265 = 0;
            dbus_message_iter_get_basic(in, &o265);
            StandardOutputTmpValue.assign (o265);
        }
        out.setStandardOutput(StandardOutputValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StandardOutputRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::StandardOutputRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::StandardOutputRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of StandardErrorUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::StandardErrorUpdate& in, DBusMessageIter* out) {
    const char* o266 = in.getStandardError().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o266));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::StandardErrorUpdate& out) {
    {
        ::std::string StandardErrorValue;
        ::std::string &StandardErrorTmpValue = StandardErrorValue;
        {
            char* o267 = 0;
            dbus_message_iter_get_basic(in, &o267);
            StandardErrorTmpValue.assign (o267);
        }
        out.setStandardError(StandardErrorValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StandardErrorRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::StandardErrorRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::StandardErrorRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TTYPathUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::TTYPathUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o268 = in.getTTYPath() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o268));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::TTYPathUpdate& out) {
    {
        bool TTYPathValue;
        bool &TTYPathTmpValue = TTYPathValue;
        {
            dbus_bool_t o269;
            dbus_message_iter_get_basic(in, &o269);
            TTYPathTmpValue = o269 ? true : false;
        }
        out.setTTYPath(TTYPathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TTYPathRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::TTYPathRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::TTYPathRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TTYResetUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::TTYResetUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o270 = in.getTTYReset() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o270));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::TTYResetUpdate& out) {
    {
        bool TTYResetValue;
        bool &TTYResetTmpValue = TTYResetValue;
        {
            dbus_bool_t o271;
            dbus_message_iter_get_basic(in, &o271);
            TTYResetTmpValue = o271 ? true : false;
        }
        out.setTTYReset(TTYResetValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TTYResetRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::TTYResetRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::TTYResetRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TTYVHangupUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::TTYVHangupUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o272 = in.getTTYVHangup() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o272));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::TTYVHangupUpdate& out) {
    {
        bool TTYVHangupValue;
        bool &TTYVHangupTmpValue = TTYVHangupValue;
        {
            dbus_bool_t o273;
            dbus_message_iter_get_basic(in, &o273);
            TTYVHangupTmpValue = o273 ? true : false;
        }
        out.setTTYVHangup(TTYVHangupValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TTYVHangupRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::TTYVHangupRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::TTYVHangupRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TTYVTDisallocateUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::TTYVTDisallocateUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o274 = in.getTTYVTDisallocate() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o274));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::TTYVTDisallocateUpdate& out) {
    {
        bool TTYVTDisallocateValue;
        bool &TTYVTDisallocateTmpValue = TTYVTDisallocateValue;
        {
            dbus_bool_t o275;
            dbus_message_iter_get_basic(in, &o275);
            TTYVTDisallocateTmpValue = o275 ? true : false;
        }
        out.setTTYVTDisallocate(TTYVTDisallocateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TTYVTDisallocateRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::TTYVTDisallocateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::TTYVTDisallocateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SyslogPriorityUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SyslogPriorityUpdate& in, DBusMessageIter* out) {
    int32 o276 = in.getSyslogPriority();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o276));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SyslogPriorityUpdate& out) {
    {
        int32 SyslogPriorityValue;
        int32 &SyslogPriorityTmpValue = SyslogPriorityValue;
        dbus_message_iter_get_basic(in, &SyslogPriorityTmpValue);
        out.setSyslogPriority(SyslogPriorityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SyslogPriorityRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SyslogPriorityRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SyslogPriorityRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SyslogIdentifierUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SyslogIdentifierUpdate& in, DBusMessageIter* out) {
    const char* o277 = in.getSyslogIdentifier().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o277));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SyslogIdentifierUpdate& out) {
    {
        ::std::string SyslogIdentifierValue;
        ::std::string &SyslogIdentifierTmpValue = SyslogIdentifierValue;
        {
            char* o278 = 0;
            dbus_message_iter_get_basic(in, &o278);
            SyslogIdentifierTmpValue.assign (o278);
        }
        out.setSyslogIdentifier(SyslogIdentifierValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SyslogIdentifierRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SyslogIdentifierRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SyslogIdentifierRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SyslogLevelPrefixUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SyslogLevelPrefixUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o279 = in.getSyslogLevelPrefix() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o279));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SyslogLevelPrefixUpdate& out) {
    {
        bool SyslogLevelPrefixValue;
        bool &SyslogLevelPrefixTmpValue = SyslogLevelPrefixValue;
        {
            dbus_bool_t o280;
            dbus_message_iter_get_basic(in, &o280);
            SyslogLevelPrefixTmpValue = o280 ? true : false;
        }
        out.setSyslogLevelPrefix(SyslogLevelPrefixValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SyslogLevelPrefixRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SyslogLevelPrefixRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SyslogLevelPrefixRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CapabilitiesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::CapabilitiesUpdate& in, DBusMessageIter* out) {
    const char* o281 = in.getCapabilities().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o281));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::CapabilitiesUpdate& out) {
    {
        ::std::string CapabilitiesValue;
        ::std::string &CapabilitiesTmpValue = CapabilitiesValue;
        {
            char* o282 = 0;
            dbus_message_iter_get_basic(in, &o282);
            CapabilitiesTmpValue.assign (o282);
        }
        out.setCapabilities(CapabilitiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CapabilitiesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::CapabilitiesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::CapabilitiesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SecureBitsUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SecureBitsUpdate& in, DBusMessageIter* out) {
    int32 o283 = in.getSecureBits();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o283));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SecureBitsUpdate& out) {
    {
        int32 SecureBitsValue;
        int32 &SecureBitsTmpValue = SecureBitsValue;
        dbus_message_iter_get_basic(in, &SecureBitsTmpValue);
        out.setSecureBits(SecureBitsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SecureBitsRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SecureBitsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SecureBitsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CapabilityBoundingSetUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::CapabilityBoundingSetUpdate& in, DBusMessageIter* out) {
    uint64 o284 = in.getCapabilityBoundingSet();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o284));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::CapabilityBoundingSetUpdate& out) {
    {
        uint64 CapabilityBoundingSetValue;
        uint64 &CapabilityBoundingSetTmpValue = CapabilityBoundingSetValue;
        dbus_message_iter_get_basic(in, &CapabilityBoundingSetTmpValue);
        out.setCapabilityBoundingSet(CapabilityBoundingSetValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CapabilityBoundingSetRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::CapabilityBoundingSetRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::CapabilityBoundingSetRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UserUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::UserUpdate& in, DBusMessageIter* out) {
    const char* o285 = in.getUser().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o285));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::UserUpdate& out) {
    {
        ::std::string UserValue;
        ::std::string &UserTmpValue = UserValue;
        {
            char* o286 = 0;
            dbus_message_iter_get_basic(in, &o286);
            UserTmpValue.assign (o286);
        }
        out.setUser(UserValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UserRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::UserRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::UserRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of GroupUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::GroupUpdate& in, DBusMessageIter* out) {
    const char* o287 = in.getGroup().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o287));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::GroupUpdate& out) {
    {
        ::std::string GroupValue;
        ::std::string &GroupTmpValue = GroupValue;
        {
            char* o288 = 0;
            dbus_message_iter_get_basic(in, &o288);
            GroupTmpValue.assign (o288);
        }
        out.setGroup(GroupValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GroupRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::GroupRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::GroupRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SupplementaryGroupsUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SupplementaryGroupsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o289ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o289ArrayIter));
    const ::std::vector< ::std::string >* o290 = &in.getSupplementaryGroups();
    ::std::vector< ::std::string >::const_iterator o291 = o290->end();
    for (::std::vector< ::std::string >::const_iterator o292 = o290->begin(); o292 != o291; ++o292) {
        const char* o293 = (*o292).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o289ArrayIter, DBUS_TYPE_STRING, &o293));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o289ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SupplementaryGroupsUpdate& out) {
    {
        ::std::vector< ::std::string > SupplementaryGroupsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o294ArrayIter;
            dbus_message_iter_recurse (in, &o294ArrayIter);

            if(dbus_message_iter_get_arg_type(&o294ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o295;
                    {
                        char* o296 = 0;
                        dbus_message_iter_get_basic(&o294ArrayIter, &o296);
                        o295.assign (o296);
                    }
                    SupplementaryGroupsValue.push_back(o295);
                } while (dbus_message_iter_next(&o294ArrayIter));
            }
        }
        out.setSupplementaryGroups(SupplementaryGroupsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SupplementaryGroupsRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SupplementaryGroupsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SupplementaryGroupsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PAMNameUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::PAMNameUpdate& in, DBusMessageIter* out) {
    const char* o297 = in.getPAMName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o297));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::PAMNameUpdate& out) {
    {
        ::std::string PAMNameValue;
        ::std::string &PAMNameTmpValue = PAMNameValue;
        {
            char* o298 = 0;
            dbus_message_iter_get_basic(in, &o298);
            PAMNameTmpValue.assign (o298);
        }
        out.setPAMName(PAMNameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PAMNameRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::PAMNameRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::PAMNameRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ReadWriteDirectoriesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ReadWriteDirectoriesUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o299ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o299ArrayIter));
    const ::std::vector< ::std::string >* o300 = &in.getReadWriteDirectories();
    ::std::vector< ::std::string >::const_iterator o301 = o300->end();
    for (::std::vector< ::std::string >::const_iterator o302 = o300->begin(); o302 != o301; ++o302) {
        const char* o303 = (*o302).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o299ArrayIter, DBUS_TYPE_STRING, &o303));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o299ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ReadWriteDirectoriesUpdate& out) {
    {
        ::std::vector< ::std::string > ReadWriteDirectoriesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o304ArrayIter;
            dbus_message_iter_recurse (in, &o304ArrayIter);

            if(dbus_message_iter_get_arg_type(&o304ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o305;
                    {
                        char* o306 = 0;
                        dbus_message_iter_get_basic(&o304ArrayIter, &o306);
                        o305.assign (o306);
                    }
                    ReadWriteDirectoriesValue.push_back(o305);
                } while (dbus_message_iter_next(&o304ArrayIter));
            }
        }
        out.setReadWriteDirectories(ReadWriteDirectoriesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReadWriteDirectoriesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ReadWriteDirectoriesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ReadWriteDirectoriesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ReadOnlyDirectoriesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ReadOnlyDirectoriesUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o307ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o307ArrayIter));
    const ::std::vector< ::std::string >* o308 = &in.getReadOnlyDirectories();
    ::std::vector< ::std::string >::const_iterator o309 = o308->end();
    for (::std::vector< ::std::string >::const_iterator o310 = o308->begin(); o310 != o309; ++o310) {
        const char* o311 = (*o310).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o307ArrayIter, DBUS_TYPE_STRING, &o311));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o307ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ReadOnlyDirectoriesUpdate& out) {
    {
        ::std::vector< ::std::string > ReadOnlyDirectoriesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o312ArrayIter;
            dbus_message_iter_recurse (in, &o312ArrayIter);

            if(dbus_message_iter_get_arg_type(&o312ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o313;
                    {
                        char* o314 = 0;
                        dbus_message_iter_get_basic(&o312ArrayIter, &o314);
                        o313.assign (o314);
                    }
                    ReadOnlyDirectoriesValue.push_back(o313);
                } while (dbus_message_iter_next(&o312ArrayIter));
            }
        }
        out.setReadOnlyDirectories(ReadOnlyDirectoriesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReadOnlyDirectoriesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ReadOnlyDirectoriesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ReadOnlyDirectoriesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of InaccessibleDirectoriesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::InaccessibleDirectoriesUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o315ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o315ArrayIter));
    const ::std::vector< ::std::string >* o316 = &in.getInaccessibleDirectories();
    ::std::vector< ::std::string >::const_iterator o317 = o316->end();
    for (::std::vector< ::std::string >::const_iterator o318 = o316->begin(); o318 != o317; ++o318) {
        const char* o319 = (*o318).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o315ArrayIter, DBUS_TYPE_STRING, &o319));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o315ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::InaccessibleDirectoriesUpdate& out) {
    {
        ::std::vector< ::std::string > InaccessibleDirectoriesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o320ArrayIter;
            dbus_message_iter_recurse (in, &o320ArrayIter);

            if(dbus_message_iter_get_arg_type(&o320ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o321;
                    {
                        char* o322 = 0;
                        dbus_message_iter_get_basic(&o320ArrayIter, &o322);
                        o321.assign (o322);
                    }
                    InaccessibleDirectoriesValue.push_back(o321);
                } while (dbus_message_iter_next(&o320ArrayIter));
            }
        }
        out.setInaccessibleDirectories(InaccessibleDirectoriesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of InaccessibleDirectoriesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::InaccessibleDirectoriesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::InaccessibleDirectoriesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MountFlagsUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::MountFlagsUpdate& in, DBusMessageIter* out) {
    uint64 o323 = in.getMountFlags();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o323));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::MountFlagsUpdate& out) {
    {
        uint64 MountFlagsValue;
        uint64 &MountFlagsTmpValue = MountFlagsValue;
        dbus_message_iter_get_basic(in, &MountFlagsTmpValue);
        out.setMountFlags(MountFlagsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MountFlagsRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::MountFlagsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::MountFlagsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PrivateTmpUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::PrivateTmpUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o324 = in.getPrivateTmp() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o324));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::PrivateTmpUpdate& out) {
    {
        bool PrivateTmpValue;
        bool &PrivateTmpTmpValue = PrivateTmpValue;
        {
            dbus_bool_t o325;
            dbus_message_iter_get_basic(in, &o325);
            PrivateTmpTmpValue = o325 ? true : false;
        }
        out.setPrivateTmp(PrivateTmpValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PrivateTmpRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::PrivateTmpRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::PrivateTmpRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PrivateNetworkUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::PrivateNetworkUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o326 = in.getPrivateNetwork() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o326));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::PrivateNetworkUpdate& out) {
    {
        bool PrivateNetworkValue;
        bool &PrivateNetworkTmpValue = PrivateNetworkValue;
        {
            dbus_bool_t o327;
            dbus_message_iter_get_basic(in, &o327);
            PrivateNetworkTmpValue = o327 ? true : false;
        }
        out.setPrivateNetwork(PrivateNetworkValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PrivateNetworkRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::PrivateNetworkRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::PrivateNetworkRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PrivateDevicesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::PrivateDevicesUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o328 = in.getPrivateDevices() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o328));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::PrivateDevicesUpdate& out) {
    {
        bool PrivateDevicesValue;
        bool &PrivateDevicesTmpValue = PrivateDevicesValue;
        {
            dbus_bool_t o329;
            dbus_message_iter_get_basic(in, &o329);
            PrivateDevicesTmpValue = o329 ? true : false;
        }
        out.setPrivateDevices(PrivateDevicesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PrivateDevicesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::PrivateDevicesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::PrivateDevicesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ProtectHomeUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ProtectHomeUpdate& in, DBusMessageIter* out) {
    const char* o330 = in.getProtectHome().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o330));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ProtectHomeUpdate& out) {
    {
        ::std::string ProtectHomeValue;
        ::std::string &ProtectHomeTmpValue = ProtectHomeValue;
        {
            char* o331 = 0;
            dbus_message_iter_get_basic(in, &o331);
            ProtectHomeTmpValue.assign (o331);
        }
        out.setProtectHome(ProtectHomeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ProtectHomeRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ProtectHomeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ProtectHomeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ProtectSystemUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::ProtectSystemUpdate& in, DBusMessageIter* out) {
    const char* o332 = in.getProtectSystem().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o332));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::ProtectSystemUpdate& out) {
    {
        ::std::string ProtectSystemValue;
        ::std::string &ProtectSystemTmpValue = ProtectSystemValue;
        {
            char* o333 = 0;
            dbus_message_iter_get_basic(in, &o333);
            ProtectSystemTmpValue.assign (o333);
        }
        out.setProtectSystem(ProtectSystemValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ProtectSystemRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::ProtectSystemRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::ProtectSystemRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SameProcessGroupUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SameProcessGroupUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o334 = in.getSameProcessGroup() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o334));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SameProcessGroupUpdate& out) {
    {
        bool SameProcessGroupValue;
        bool &SameProcessGroupTmpValue = SameProcessGroupValue;
        {
            dbus_bool_t o335;
            dbus_message_iter_get_basic(in, &o335);
            SameProcessGroupTmpValue = o335 ? true : false;
        }
        out.setSameProcessGroup(SameProcessGroupValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SameProcessGroupRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SameProcessGroupRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SameProcessGroupRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UtmpIdentifierUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::UtmpIdentifierUpdate& in, DBusMessageIter* out) {
    const char* o336 = in.getUtmpIdentifier().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o336));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::UtmpIdentifierUpdate& out) {
    {
        ::std::string UtmpIdentifierValue;
        ::std::string &UtmpIdentifierTmpValue = UtmpIdentifierValue;
        {
            char* o337 = 0;
            dbus_message_iter_get_basic(in, &o337);
            UtmpIdentifierTmpValue.assign (o337);
        }
        out.setUtmpIdentifier(UtmpIdentifierValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UtmpIdentifierRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::UtmpIdentifierRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::UtmpIdentifierRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UtmpModeUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::UtmpModeUpdate& in, DBusMessageIter* out) {
    const char* o338 = in.getUtmpMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o338));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::UtmpModeUpdate& out) {
    {
        ::std::string UtmpModeValue;
        ::std::string &UtmpModeTmpValue = UtmpModeValue;
        {
            char* o339 = 0;
            dbus_message_iter_get_basic(in, &o339);
            UtmpModeTmpValue.assign (o339);
        }
        out.setUtmpMode(UtmpModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UtmpModeRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::UtmpModeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::UtmpModeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SELinuxContextUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SELinuxContextUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getSELinuxContext(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SELinuxContextUpdate& out) {
    {
        ::org::freedesktop::systemd1::Service::securityContext SELinuxContextValue;
        if (!deserializeDBus(in, SELinuxContextValue)) {
            return false;
        }
        out.setSELinuxContext(SELinuxContextValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SELinuxContextRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SELinuxContextRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SELinuxContextRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AppArmorProfileUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::AppArmorProfileUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getAppArmorProfile(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::AppArmorProfileUpdate& out) {
    {
        ::org::freedesktop::systemd1::Service::ArmorProfile AppArmorProfileValue;
        if (!deserializeDBus(in, AppArmorProfileValue)) {
            return false;
        }
        out.setAppArmorProfile(AppArmorProfileValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AppArmorProfileRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::AppArmorProfileRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::AppArmorProfileRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SmackProcessLabelUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SmackProcessLabelUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getSmackProcessLabel(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SmackProcessLabelUpdate& out) {
    {
        ::org::freedesktop::systemd1::Service::ProcessLabel SmackProcessLabelValue;
        if (!deserializeDBus(in, SmackProcessLabelValue)) {
            return false;
        }
        out.setSmackProcessLabel(SmackProcessLabelValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SmackProcessLabelRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SmackProcessLabelRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SmackProcessLabelRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of IgnoreSIGPIPEUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::IgnoreSIGPIPEUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o340 = in.getIgnoreSIGPIPE() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o340));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::IgnoreSIGPIPEUpdate& out) {
    {
        bool IgnoreSIGPIPEValue;
        bool &IgnoreSIGPIPETmpValue = IgnoreSIGPIPEValue;
        {
            dbus_bool_t o341;
            dbus_message_iter_get_basic(in, &o341);
            IgnoreSIGPIPETmpValue = o341 ? true : false;
        }
        out.setIgnoreSIGPIPE(IgnoreSIGPIPEValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of IgnoreSIGPIPERegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::IgnoreSIGPIPERegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::IgnoreSIGPIPERegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NoNewPrivilegesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::NoNewPrivilegesUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o342 = in.getNoNewPrivileges() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o342));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::NoNewPrivilegesUpdate& out) {
    {
        bool NoNewPrivilegesValue;
        bool &NoNewPrivilegesTmpValue = NoNewPrivilegesValue;
        {
            dbus_bool_t o343;
            dbus_message_iter_get_basic(in, &o343);
            NoNewPrivilegesTmpValue = o343 ? true : false;
        }
        out.setNoNewPrivileges(NoNewPrivilegesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NoNewPrivilegesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::NoNewPrivilegesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::NoNewPrivilegesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SystemCallFilterUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SystemCallFilterUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getSystemCallFilter(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SystemCallFilterUpdate& out) {
    {
        ::org::freedesktop::systemd1::Service::systemCallFilter SystemCallFilterValue;
        if (!deserializeDBus(in, SystemCallFilterValue)) {
            return false;
        }
        out.setSystemCallFilter(SystemCallFilterValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SystemCallFilterRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SystemCallFilterRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SystemCallFilterRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SystemCallArchitecturesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SystemCallArchitecturesUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o344ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o344ArrayIter));
    const ::std::vector< ::std::string >* o345 = &in.getSystemCallArchitectures();
    ::std::vector< ::std::string >::const_iterator o346 = o345->end();
    for (::std::vector< ::std::string >::const_iterator o347 = o345->begin(); o347 != o346; ++o347) {
        const char* o348 = (*o347).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o344ArrayIter, DBUS_TYPE_STRING, &o348));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o344ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SystemCallArchitecturesUpdate& out) {
    {
        ::std::vector< ::std::string > SystemCallArchitecturesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o349ArrayIter;
            dbus_message_iter_recurse (in, &o349ArrayIter);

            if(dbus_message_iter_get_arg_type(&o349ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o350;
                    {
                        char* o351 = 0;
                        dbus_message_iter_get_basic(&o349ArrayIter, &o351);
                        o350.assign (o351);
                    }
                    SystemCallArchitecturesValue.push_back(o350);
                } while (dbus_message_iter_next(&o349ArrayIter));
            }
        }
        out.setSystemCallArchitectures(SystemCallArchitecturesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SystemCallArchitecturesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SystemCallArchitecturesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SystemCallArchitecturesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SystemCallErrorNumberUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SystemCallErrorNumberUpdate& in, DBusMessageIter* out) {
    int32 o352 = in.getSystemCallErrorNumber();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o352));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SystemCallErrorNumberUpdate& out) {
    {
        int32 SystemCallErrorNumberValue;
        int32 &SystemCallErrorNumberTmpValue = SystemCallErrorNumberValue;
        dbus_message_iter_get_basic(in, &SystemCallErrorNumberTmpValue);
        out.setSystemCallErrorNumber(SystemCallErrorNumberValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SystemCallErrorNumberRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SystemCallErrorNumberRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SystemCallErrorNumberRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PersonalityUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::PersonalityUpdate& in, DBusMessageIter* out) {
    const char* o353 = in.getPersonality().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o353));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::PersonalityUpdate& out) {
    {
        ::std::string PersonalityValue;
        ::std::string &PersonalityTmpValue = PersonalityValue;
        {
            char* o354 = 0;
            dbus_message_iter_get_basic(in, &o354);
            PersonalityTmpValue.assign (o354);
        }
        out.setPersonality(PersonalityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PersonalityRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::PersonalityRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::PersonalityRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RestrictAddressFamiliesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::RestrictAddressFamiliesUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getRestrictAddressFamilies(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::RestrictAddressFamiliesUpdate& out) {
    {
        ::org::freedesktop::systemd1::Service::AddressFamily RestrictAddressFamiliesValue;
        if (!deserializeDBus(in, RestrictAddressFamiliesValue)) {
            return false;
        }
        out.setRestrictAddressFamilies(RestrictAddressFamiliesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RestrictAddressFamiliesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::RestrictAddressFamiliesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::RestrictAddressFamiliesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RuntimeDirectoryModeUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::RuntimeDirectoryModeUpdate& in, DBusMessageIter* out) {
    uint32 o355 = in.getRuntimeDirectoryMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o355));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::RuntimeDirectoryModeUpdate& out) {
    {
        uint32 RuntimeDirectoryModeValue;
        uint32 &RuntimeDirectoryModeTmpValue = RuntimeDirectoryModeValue;
        dbus_message_iter_get_basic(in, &RuntimeDirectoryModeTmpValue);
        out.setRuntimeDirectoryMode(RuntimeDirectoryModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RuntimeDirectoryModeRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::RuntimeDirectoryModeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::RuntimeDirectoryModeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RuntimeDirectoryUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::RuntimeDirectoryUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o356ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o356ArrayIter));
    const ::std::vector< ::std::string >* o357 = &in.getRuntimeDirectory();
    ::std::vector< ::std::string >::const_iterator o358 = o357->end();
    for (::std::vector< ::std::string >::const_iterator o359 = o357->begin(); o359 != o358; ++o359) {
        const char* o360 = (*o359).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o356ArrayIter, DBUS_TYPE_STRING, &o360));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o356ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::RuntimeDirectoryUpdate& out) {
    {
        ::std::vector< ::std::string > RuntimeDirectoryValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o361ArrayIter;
            dbus_message_iter_recurse (in, &o361ArrayIter);

            if(dbus_message_iter_get_arg_type(&o361ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o362;
                    {
                        char* o363 = 0;
                        dbus_message_iter_get_basic(&o361ArrayIter, &o363);
                        o362.assign (o363);
                    }
                    RuntimeDirectoryValue.push_back(o362);
                } while (dbus_message_iter_next(&o361ArrayIter));
            }
        }
        out.setRuntimeDirectory(RuntimeDirectoryValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RuntimeDirectoryRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::RuntimeDirectoryRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::RuntimeDirectoryRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of KillModeUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::KillModeUpdate& in, DBusMessageIter* out) {
    const char* o364 = in.getKillMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o364));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::KillModeUpdate& out) {
    {
        ::std::string KillModeValue;
        ::std::string &KillModeTmpValue = KillModeValue;
        {
            char* o365 = 0;
            dbus_message_iter_get_basic(in, &o365);
            KillModeTmpValue.assign (o365);
        }
        out.setKillMode(KillModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of KillModeRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::KillModeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::KillModeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of KillSignalUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::KillSignalUpdate& in, DBusMessageIter* out) {
    int32 o366 = in.getKillSignal();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o366));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::KillSignalUpdate& out) {
    {
        int32 KillSignalValue;
        int32 &KillSignalTmpValue = KillSignalValue;
        dbus_message_iter_get_basic(in, &KillSignalTmpValue);
        out.setKillSignal(KillSignalValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of KillSignalRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::KillSignalRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::KillSignalRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SendSIGKILLUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SendSIGKILLUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o367 = in.getSendSIGKILL() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o367));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SendSIGKILLUpdate& out) {
    {
        bool SendSIGKILLValue;
        bool &SendSIGKILLTmpValue = SendSIGKILLValue;
        {
            dbus_bool_t o368;
            dbus_message_iter_get_basic(in, &o368);
            SendSIGKILLTmpValue = o368 ? true : false;
        }
        out.setSendSIGKILL(SendSIGKILLValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SendSIGKILLRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SendSIGKILLRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SendSIGKILLRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SendSIGHUPUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Service::SendSIGHUPUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o369 = in.getSendSIGHUP() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o369));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Service::SendSIGHUPUpdate& out) {
    {
        bool SendSIGHUPValue;
        bool &SendSIGHUPTmpValue = SendSIGHUPValue;
        {
            dbus_bool_t o370;
            dbus_message_iter_get_basic(in, &o370);
            SendSIGHUPTmpValue = o370 ? true : false;
        }
        out.setSendSIGHUP(SendSIGHUPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SendSIGHUPRegister

void serializeDBus (const ::org::freedesktop::systemd1::Service::SendSIGHUPRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Service::SendSIGHUPRegister& /*out*/) {
    return true;
}

