/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/freedesktop/systemd1/Manager.h"
#include "org/freedesktop/systemd1/ManagerDBus.h"
#include "org/freedesktop/systemd1/ManagerJson.h"
#include "org/freedesktop/systemd1/ManagerProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

DEFINE_CLASS_LOGGER("/org/freedesktop/systemd1/org/freedesktop/systemd1/Manager", ManagerProxy);

class ManagerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ManagerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ManagerProxy >& proxyShared = ::boost::static_pointer_cast< ManagerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_UnitNew:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitNewSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitNew", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<UnitNewSignal> payload = ::boost::static_pointer_cast<UnitNewSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((UnitNewCallbackIF*) _callback)->onUnitNewSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_UnitRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<UnitRemovedSignal> payload = ::boost::static_pointer_cast<UnitRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((UnitRemovedCallbackIF*) _callback)->onUnitRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_JobNew:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JobNewSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JobNew", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<JobNewSignal> payload = ::boost::static_pointer_cast<JobNewSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((JobNewCallbackIF*) _callback)->onJobNewSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_JobRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JobRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JobRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<JobRemovedSignal> payload = ::boost::static_pointer_cast<JobRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((JobRemovedCallbackIF*) _callback)->onJobRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_StartupFinished:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartupFinishedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartupFinished", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<StartupFinishedSignal> payload = ::boost::static_pointer_cast<StartupFinishedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((StartupFinishedCallbackIF*) _callback)->onStartupFinishedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_UnitFilesChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitFilesChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitFilesChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<UnitFilesChangedSignal> payload = ::boost::static_pointer_cast<UnitFilesChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((UnitFilesChangedCallbackIF*) _callback)->onUnitFilesChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_Reloading:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadingSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Reloading", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ReloadingSignal> payload = ::boost::static_pointer_cast<ReloadingSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ReloadingCallbackIF*) _callback)->onReloadingSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_Version:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VersionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Version", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VersionError> payload = ::boost::static_pointer_cast<VersionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VersionCallbackIF*) _callback)->onVersionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VersionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Version", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VersionUpdate> payload = ::boost::static_pointer_cast<VersionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VersionCallbackIF*) _callback)->onVersionUpdate(proxyShared, payload);
                        proxyShared->_version = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Features:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FeaturesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Features", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FeaturesError> payload = ::boost::static_pointer_cast<FeaturesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FeaturesCallbackIF*) _callback)->onFeaturesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FeaturesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Features", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FeaturesUpdate> payload = ::boost::static_pointer_cast<FeaturesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FeaturesCallbackIF*) _callback)->onFeaturesUpdate(proxyShared, payload);
                        proxyShared->_features = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Virtualization:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VirtualizationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Virtualization", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VirtualizationError> payload = ::boost::static_pointer_cast<VirtualizationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VirtualizationCallbackIF*) _callback)->onVirtualizationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VirtualizationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Virtualization", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VirtualizationUpdate> payload = ::boost::static_pointer_cast<VirtualizationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VirtualizationCallbackIF*) _callback)->onVirtualizationUpdate(proxyShared, payload);
                        proxyShared->_virtualization = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Architecture:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ArchitectureError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Architecture", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ArchitectureError> payload = ::boost::static_pointer_cast<ArchitectureError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ArchitectureCallbackIF*) _callback)->onArchitectureError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ArchitectureUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Architecture", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ArchitectureUpdate> payload = ::boost::static_pointer_cast<ArchitectureUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ArchitectureCallbackIF*) _callback)->onArchitectureUpdate(proxyShared, payload);
                        proxyShared->_architecture = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Tainted:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TaintedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Tainted", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TaintedError> payload = ::boost::static_pointer_cast<TaintedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TaintedCallbackIF*) _callback)->onTaintedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TaintedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Tainted", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TaintedUpdate> payload = ::boost::static_pointer_cast<TaintedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TaintedCallbackIF*) _callback)->onTaintedUpdate(proxyShared, payload);
                        proxyShared->_tainted = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_FirmwareTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FirmwareTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FirmwareTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FirmwareTimestampError> payload = ::boost::static_pointer_cast<FirmwareTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FirmwareTimestampCallbackIF*) _callback)->onFirmwareTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FirmwareTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FirmwareTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FirmwareTimestampUpdate> payload = ::boost::static_pointer_cast<FirmwareTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FirmwareTimestampCallbackIF*) _callback)->onFirmwareTimestampUpdate(proxyShared, payload);
                        proxyShared->_firmwareTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_FirmwareTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FirmwareTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FirmwareTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FirmwareTimestampMonotonicError> payload = ::boost::static_pointer_cast<FirmwareTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FirmwareTimestampMonotonicCallbackIF*) _callback)->onFirmwareTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FirmwareTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FirmwareTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FirmwareTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<FirmwareTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FirmwareTimestampMonotonicCallbackIF*) _callback)->onFirmwareTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_firmwareTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LoaderTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LoaderTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LoaderTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LoaderTimestampError> payload = ::boost::static_pointer_cast<LoaderTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LoaderTimestampCallbackIF*) _callback)->onLoaderTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LoaderTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LoaderTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LoaderTimestampUpdate> payload = ::boost::static_pointer_cast<LoaderTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LoaderTimestampCallbackIF*) _callback)->onLoaderTimestampUpdate(proxyShared, payload);
                        proxyShared->_loaderTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LoaderTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LoaderTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LoaderTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LoaderTimestampMonotonicError> payload = ::boost::static_pointer_cast<LoaderTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LoaderTimestampMonotonicCallbackIF*) _callback)->onLoaderTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LoaderTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LoaderTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LoaderTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<LoaderTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LoaderTimestampMonotonicCallbackIF*) _callback)->onLoaderTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_loaderTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_KernelTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KernelTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KernelTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KernelTimestampError> payload = ::boost::static_pointer_cast<KernelTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((KernelTimestampCallbackIF*) _callback)->onKernelTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KernelTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KernelTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KernelTimestampUpdate> payload = ::boost::static_pointer_cast<KernelTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((KernelTimestampCallbackIF*) _callback)->onKernelTimestampUpdate(proxyShared, payload);
                        proxyShared->_kernelTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_KernelTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KernelTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KernelTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KernelTimestampMonotonicError> payload = ::boost::static_pointer_cast<KernelTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((KernelTimestampMonotonicCallbackIF*) _callback)->onKernelTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KernelTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KernelTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KernelTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<KernelTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((KernelTimestampMonotonicCallbackIF*) _callback)->onKernelTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_kernelTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_InitRDTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InitRDTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InitRDTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InitRDTimestampError> payload = ::boost::static_pointer_cast<InitRDTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((InitRDTimestampCallbackIF*) _callback)->onInitRDTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InitRDTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InitRDTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InitRDTimestampUpdate> payload = ::boost::static_pointer_cast<InitRDTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((InitRDTimestampCallbackIF*) _callback)->onInitRDTimestampUpdate(proxyShared, payload);
                        proxyShared->_initRDTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_InitRDTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InitRDTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InitRDTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InitRDTimestampMonotonicError> payload = ::boost::static_pointer_cast<InitRDTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((InitRDTimestampMonotonicCallbackIF*) _callback)->onInitRDTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InitRDTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InitRDTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InitRDTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<InitRDTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((InitRDTimestampMonotonicCallbackIF*) _callback)->onInitRDTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_initRDTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UserspaceTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UserspaceTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UserspaceTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UserspaceTimestampError> payload = ::boost::static_pointer_cast<UserspaceTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UserspaceTimestampCallbackIF*) _callback)->onUserspaceTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UserspaceTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UserspaceTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UserspaceTimestampUpdate> payload = ::boost::static_pointer_cast<UserspaceTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UserspaceTimestampCallbackIF*) _callback)->onUserspaceTimestampUpdate(proxyShared, payload);
                        proxyShared->_userspaceTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UserspaceTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UserspaceTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UserspaceTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UserspaceTimestampMonotonicError> payload = ::boost::static_pointer_cast<UserspaceTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UserspaceTimestampMonotonicCallbackIF*) _callback)->onUserspaceTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UserspaceTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UserspaceTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UserspaceTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<UserspaceTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UserspaceTimestampMonotonicCallbackIF*) _callback)->onUserspaceTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_userspaceTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_FinishTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FinishTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FinishTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FinishTimestampError> payload = ::boost::static_pointer_cast<FinishTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FinishTimestampCallbackIF*) _callback)->onFinishTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FinishTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FinishTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FinishTimestampUpdate> payload = ::boost::static_pointer_cast<FinishTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FinishTimestampCallbackIF*) _callback)->onFinishTimestampUpdate(proxyShared, payload);
                        proxyShared->_finishTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_FinishTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FinishTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FinishTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FinishTimestampMonotonicError> payload = ::boost::static_pointer_cast<FinishTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FinishTimestampMonotonicCallbackIF*) _callback)->onFinishTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FinishTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FinishTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FinishTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<FinishTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FinishTimestampMonotonicCallbackIF*) _callback)->onFinishTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_finishTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SecurityStartTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SecurityStartTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SecurityStartTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SecurityStartTimestampError> payload = ::boost::static_pointer_cast<SecurityStartTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SecurityStartTimestampCallbackIF*) _callback)->onSecurityStartTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SecurityStartTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SecurityStartTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SecurityStartTimestampUpdate> payload = ::boost::static_pointer_cast<SecurityStartTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SecurityStartTimestampCallbackIF*) _callback)->onSecurityStartTimestampUpdate(proxyShared, payload);
                        proxyShared->_securityStartTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SecurityStartTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SecurityStartTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SecurityStartTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SecurityStartTimestampMonotonicError> payload = ::boost::static_pointer_cast<SecurityStartTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SecurityStartTimestampMonotonicCallbackIF*) _callback)->onSecurityStartTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SecurityStartTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SecurityStartTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SecurityStartTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<SecurityStartTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SecurityStartTimestampMonotonicCallbackIF*) _callback)->onSecurityStartTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_securityStartTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SecurityFinishTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SecurityFinishTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SecurityFinishTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SecurityFinishTimestampError> payload = ::boost::static_pointer_cast<SecurityFinishTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SecurityFinishTimestampCallbackIF*) _callback)->onSecurityFinishTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SecurityFinishTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SecurityFinishTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SecurityFinishTimestampUpdate> payload = ::boost::static_pointer_cast<SecurityFinishTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SecurityFinishTimestampCallbackIF*) _callback)->onSecurityFinishTimestampUpdate(proxyShared, payload);
                        proxyShared->_securityFinishTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SecurityFinishTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SecurityFinishTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SecurityFinishTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SecurityFinishTimestampMonotonicError> payload = ::boost::static_pointer_cast<SecurityFinishTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SecurityFinishTimestampMonotonicCallbackIF*) _callback)->onSecurityFinishTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SecurityFinishTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SecurityFinishTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SecurityFinishTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<SecurityFinishTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SecurityFinishTimestampMonotonicCallbackIF*) _callback)->onSecurityFinishTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_securityFinishTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_GeneratorsStartTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GeneratorsStartTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "GeneratorsStartTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GeneratorsStartTimestampError> payload = ::boost::static_pointer_cast<GeneratorsStartTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((GeneratorsStartTimestampCallbackIF*) _callback)->onGeneratorsStartTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GeneratorsStartTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "GeneratorsStartTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GeneratorsStartTimestampUpdate> payload = ::boost::static_pointer_cast<GeneratorsStartTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((GeneratorsStartTimestampCallbackIF*) _callback)->onGeneratorsStartTimestampUpdate(proxyShared, payload);
                        proxyShared->_generatorsStartTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_GeneratorsStartTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GeneratorsStartTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "GeneratorsStartTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GeneratorsStartTimestampMonotonicError> payload = ::boost::static_pointer_cast<GeneratorsStartTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((GeneratorsStartTimestampMonotonicCallbackIF*) _callback)->onGeneratorsStartTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GeneratorsStartTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "GeneratorsStartTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GeneratorsStartTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<GeneratorsStartTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((GeneratorsStartTimestampMonotonicCallbackIF*) _callback)->onGeneratorsStartTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_generatorsStartTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_GeneratorsFinishTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GeneratorsFinishTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "GeneratorsFinishTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GeneratorsFinishTimestampError> payload = ::boost::static_pointer_cast<GeneratorsFinishTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((GeneratorsFinishTimestampCallbackIF*) _callback)->onGeneratorsFinishTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GeneratorsFinishTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "GeneratorsFinishTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GeneratorsFinishTimestampUpdate> payload = ::boost::static_pointer_cast<GeneratorsFinishTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((GeneratorsFinishTimestampCallbackIF*) _callback)->onGeneratorsFinishTimestampUpdate(proxyShared, payload);
                        proxyShared->_generatorsFinishTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_GeneratorsFinishTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GeneratorsFinishTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "GeneratorsFinishTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GeneratorsFinishTimestampMonotonicError> payload = ::boost::static_pointer_cast<GeneratorsFinishTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((GeneratorsFinishTimestampMonotonicCallbackIF*) _callback)->onGeneratorsFinishTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GeneratorsFinishTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "GeneratorsFinishTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GeneratorsFinishTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<GeneratorsFinishTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((GeneratorsFinishTimestampMonotonicCallbackIF*) _callback)->onGeneratorsFinishTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_generatorsFinishTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UnitsLoadStartTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitsLoadStartTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitsLoadStartTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitsLoadStartTimestampError> payload = ::boost::static_pointer_cast<UnitsLoadStartTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UnitsLoadStartTimestampCallbackIF*) _callback)->onUnitsLoadStartTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitsLoadStartTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitsLoadStartTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitsLoadStartTimestampUpdate> payload = ::boost::static_pointer_cast<UnitsLoadStartTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UnitsLoadStartTimestampCallbackIF*) _callback)->onUnitsLoadStartTimestampUpdate(proxyShared, payload);
                        proxyShared->_unitsLoadStartTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UnitsLoadStartTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitsLoadStartTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitsLoadStartTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitsLoadStartTimestampMonotonicError> payload = ::boost::static_pointer_cast<UnitsLoadStartTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UnitsLoadStartTimestampMonotonicCallbackIF*) _callback)->onUnitsLoadStartTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitsLoadStartTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitsLoadStartTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitsLoadStartTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<UnitsLoadStartTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UnitsLoadStartTimestampMonotonicCallbackIF*) _callback)->onUnitsLoadStartTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_unitsLoadStartTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UnitsLoadFinishTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitsLoadFinishTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitsLoadFinishTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitsLoadFinishTimestampError> payload = ::boost::static_pointer_cast<UnitsLoadFinishTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UnitsLoadFinishTimestampCallbackIF*) _callback)->onUnitsLoadFinishTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitsLoadFinishTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitsLoadFinishTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitsLoadFinishTimestampUpdate> payload = ::boost::static_pointer_cast<UnitsLoadFinishTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UnitsLoadFinishTimestampCallbackIF*) _callback)->onUnitsLoadFinishTimestampUpdate(proxyShared, payload);
                        proxyShared->_unitsLoadFinishTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UnitsLoadFinishTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitsLoadFinishTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitsLoadFinishTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitsLoadFinishTimestampMonotonicError> payload = ::boost::static_pointer_cast<UnitsLoadFinishTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UnitsLoadFinishTimestampMonotonicCallbackIF*) _callback)->onUnitsLoadFinishTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitsLoadFinishTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitsLoadFinishTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitsLoadFinishTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<UnitsLoadFinishTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UnitsLoadFinishTimestampMonotonicCallbackIF*) _callback)->onUnitsLoadFinishTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_unitsLoadFinishTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LogLevel:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LogLevelError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LogLevel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LogLevelError> payload = ::boost::static_pointer_cast<LogLevelError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LogLevelCallbackIF*) _callback)->onLogLevelError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LogLevelUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LogLevel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LogLevelUpdate> payload = ::boost::static_pointer_cast<LogLevelUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LogLevelCallbackIF*) _callback)->onLogLevelUpdate(proxyShared, payload);
                        proxyShared->_logLevel = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LogTarget:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LogTargetError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LogTarget", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LogTargetError> payload = ::boost::static_pointer_cast<LogTargetError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LogTargetCallbackIF*) _callback)->onLogTargetError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LogTargetUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LogTarget", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LogTargetUpdate> payload = ::boost::static_pointer_cast<LogTargetUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LogTargetCallbackIF*) _callback)->onLogTargetUpdate(proxyShared, payload);
                        proxyShared->_logTarget = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_NNames:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NNamesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NNamesError> payload = ::boost::static_pointer_cast<NNamesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NNamesCallbackIF*) _callback)->onNNamesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NNamesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NNamesUpdate> payload = ::boost::static_pointer_cast<NNamesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NNamesCallbackIF*) _callback)->onNNamesUpdate(proxyShared, payload);
                        proxyShared->_nNames = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_NFailedUnits:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NFailedUnitsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NFailedUnits", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NFailedUnitsError> payload = ::boost::static_pointer_cast<NFailedUnitsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NFailedUnitsCallbackIF*) _callback)->onNFailedUnitsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NFailedUnitsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NFailedUnits", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NFailedUnitsUpdate> payload = ::boost::static_pointer_cast<NFailedUnitsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NFailedUnitsCallbackIF*) _callback)->onNFailedUnitsUpdate(proxyShared, payload);
                        proxyShared->_nFailedUnits = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_NJobs:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NJobsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NJobs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NJobsError> payload = ::boost::static_pointer_cast<NJobsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NJobsCallbackIF*) _callback)->onNJobsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NJobsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NJobs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NJobsUpdate> payload = ::boost::static_pointer_cast<NJobsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NJobsCallbackIF*) _callback)->onNJobsUpdate(proxyShared, payload);
                        proxyShared->_nJobs = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_NInstalledJobs:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NInstalledJobsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NInstalledJobs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NInstalledJobsError> payload = ::boost::static_pointer_cast<NInstalledJobsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NInstalledJobsCallbackIF*) _callback)->onNInstalledJobsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NInstalledJobsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NInstalledJobs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NInstalledJobsUpdate> payload = ::boost::static_pointer_cast<NInstalledJobsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NInstalledJobsCallbackIF*) _callback)->onNInstalledJobsUpdate(proxyShared, payload);
                        proxyShared->_nInstalledJobs = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_NFailedJobs:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NFailedJobsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NFailedJobs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NFailedJobsError> payload = ::boost::static_pointer_cast<NFailedJobsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NFailedJobsCallbackIF*) _callback)->onNFailedJobsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NFailedJobsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NFailedJobs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NFailedJobsUpdate> payload = ::boost::static_pointer_cast<NFailedJobsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NFailedJobsCallbackIF*) _callback)->onNFailedJobsUpdate(proxyShared, payload);
                        proxyShared->_nFailedJobs = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Progress:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProgressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Progress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProgressError> payload = ::boost::static_pointer_cast<ProgressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ProgressCallbackIF*) _callback)->onProgressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProgressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Progress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProgressUpdate> payload = ::boost::static_pointer_cast<ProgressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ProgressCallbackIF*) _callback)->onProgressUpdate(proxyShared, payload);
                        proxyShared->_progress = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Environment:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnvironmentError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Environment", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnvironmentError> payload = ::boost::static_pointer_cast<EnvironmentError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EnvironmentCallbackIF*) _callback)->onEnvironmentError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnvironmentUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Environment", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnvironmentUpdate> payload = ::boost::static_pointer_cast<EnvironmentUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EnvironmentCallbackIF*) _callback)->onEnvironmentUpdate(proxyShared, payload);
                        proxyShared->_environment = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ConfirmSpawn:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConfirmSpawnError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConfirmSpawn", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConfirmSpawnError> payload = ::boost::static_pointer_cast<ConfirmSpawnError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConfirmSpawnCallbackIF*) _callback)->onConfirmSpawnError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConfirmSpawnUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConfirmSpawn", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConfirmSpawnUpdate> payload = ::boost::static_pointer_cast<ConfirmSpawnUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConfirmSpawnCallbackIF*) _callback)->onConfirmSpawnUpdate(proxyShared, payload);
                        proxyShared->_confirmSpawn = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ShowStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ShowStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowStatusError> payload = ::boost::static_pointer_cast<ShowStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ShowStatusCallbackIF*) _callback)->onShowStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ShowStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowStatusUpdate> payload = ::boost::static_pointer_cast<ShowStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ShowStatusCallbackIF*) _callback)->onShowStatusUpdate(proxyShared, payload);
                        proxyShared->_showStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UnitPath:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitPathError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitPath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitPathError> payload = ::boost::static_pointer_cast<UnitPathError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UnitPathCallbackIF*) _callback)->onUnitPathError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitPathUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitPath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitPathUpdate> payload = ::boost::static_pointer_cast<UnitPathUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UnitPathCallbackIF*) _callback)->onUnitPathUpdate(proxyShared, payload);
                        proxyShared->_unitPath = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DefaultStandardOutput:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DefaultStandardOutputError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DefaultStandardOutput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DefaultStandardOutputError> payload = ::boost::static_pointer_cast<DefaultStandardOutputError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DefaultStandardOutputCallbackIF*) _callback)->onDefaultStandardOutputError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DefaultStandardOutputUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DefaultStandardOutput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DefaultStandardOutputUpdate> payload = ::boost::static_pointer_cast<DefaultStandardOutputUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DefaultStandardOutputCallbackIF*) _callback)->onDefaultStandardOutputUpdate(proxyShared, payload);
                        proxyShared->_defaultStandardOutput = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DefaultStandardError:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DefaultStandardErrorError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DefaultStandardError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DefaultStandardErrorError> payload = ::boost::static_pointer_cast<DefaultStandardErrorError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DefaultStandardErrorCallbackIF*) _callback)->onDefaultStandardErrorError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DefaultStandardErrorUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DefaultStandardError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DefaultStandardErrorUpdate> payload = ::boost::static_pointer_cast<DefaultStandardErrorUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DefaultStandardErrorCallbackIF*) _callback)->onDefaultStandardErrorUpdate(proxyShared, payload);
                        proxyShared->_defaultStandardError = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RuntimeWatchdogUSec:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RuntimeWatchdogUSecError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RuntimeWatchdogUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RuntimeWatchdogUSecError> payload = ::boost::static_pointer_cast<RuntimeWatchdogUSecError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RuntimeWatchdogUSecCallbackIF*) _callback)->onRuntimeWatchdogUSecError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RuntimeWatchdogUSecUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RuntimeWatchdogUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RuntimeWatchdogUSecUpdate> payload = ::boost::static_pointer_cast<RuntimeWatchdogUSecUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RuntimeWatchdogUSecCallbackIF*) _callback)->onRuntimeWatchdogUSecUpdate(proxyShared, payload);
                        proxyShared->_runtimeWatchdogUSec = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ShutdownWatchdogUSec:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShutdownWatchdogUSecError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ShutdownWatchdogUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShutdownWatchdogUSecError> payload = ::boost::static_pointer_cast<ShutdownWatchdogUSecError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ShutdownWatchdogUSecCallbackIF*) _callback)->onShutdownWatchdogUSecError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShutdownWatchdogUSecUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ShutdownWatchdogUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShutdownWatchdogUSecUpdate> payload = ::boost::static_pointer_cast<ShutdownWatchdogUSecUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ShutdownWatchdogUSecCallbackIF*) _callback)->onShutdownWatchdogUSecUpdate(proxyShared, payload);
                        proxyShared->_shutdownWatchdogUSec = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ControlGroup:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ControlGroupError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ControlGroup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ControlGroupError> payload = ::boost::static_pointer_cast<ControlGroupError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ControlGroupCallbackIF*) _callback)->onControlGroupError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ControlGroupUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ControlGroup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ControlGroupUpdate> payload = ::boost::static_pointer_cast<ControlGroupUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ControlGroupCallbackIF*) _callback)->onControlGroupUpdate(proxyShared, payload);
                        proxyShared->_controlGroup = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SystemState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SystemStateError> payload = ::boost::static_pointer_cast<SystemStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SystemStateCallbackIF*) _callback)->onSystemStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SystemStateUpdate> payload = ::boost::static_pointer_cast<SystemStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SystemStateCallbackIF*) _callback)->onSystemStateUpdate(proxyShared, payload);
                        proxyShared->_systemState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_GetUnit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetUnitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUnitError> payload = ::boost::static_pointer_cast<GetUnitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUnitCallbackIF*) _callback)->onGetUnitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUnitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUnitResponse> payload = ::boost::static_pointer_cast<GetUnitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUnitCallbackIF*) _callback)->onGetUnitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetUnitByPID:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetUnitByPIDError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUnitByPID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUnitByPIDError> payload = ::boost::static_pointer_cast<GetUnitByPIDError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUnitByPIDCallbackIF*) _callback)->onGetUnitByPIDError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUnitByPIDResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUnitByPID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUnitByPIDResponse> payload = ::boost::static_pointer_cast<GetUnitByPIDResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUnitByPIDCallbackIF*) _callback)->onGetUnitByPIDResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_LoadUnit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), LoadUnitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LoadUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LoadUnitError> payload = ::boost::static_pointer_cast<LoadUnitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LoadUnitCallbackIF*) _callback)->onLoadUnitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LoadUnitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "LoadUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LoadUnitResponse> payload = ::boost::static_pointer_cast<LoadUnitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LoadUnitCallbackIF*) _callback)->onLoadUnitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StartUnit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartUnitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartUnitError> payload = ::boost::static_pointer_cast<StartUnitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartUnitCallbackIF*) _callback)->onStartUnitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartUnitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartUnitResponse> payload = ::boost::static_pointer_cast<StartUnitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartUnitCallbackIF*) _callback)->onStartUnitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StartUnitReplace:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartUnitReplaceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartUnitReplace", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartUnitReplaceError> payload = ::boost::static_pointer_cast<StartUnitReplaceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartUnitReplaceCallbackIF*) _callback)->onStartUnitReplaceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartUnitReplaceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartUnitReplace", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartUnitReplaceResponse> payload = ::boost::static_pointer_cast<StartUnitReplaceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartUnitReplaceCallbackIF*) _callback)->onStartUnitReplaceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StopUnit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StopUnitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopUnitError> payload = ::boost::static_pointer_cast<StopUnitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StopUnitCallbackIF*) _callback)->onStopUnitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopUnitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopUnitResponse> payload = ::boost::static_pointer_cast<StopUnitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StopUnitCallbackIF*) _callback)->onStopUnitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReloadUnit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReloadUnitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReloadUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadUnitError> payload = ::boost::static_pointer_cast<ReloadUnitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadUnitCallbackIF*) _callback)->onReloadUnitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadUnitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReloadUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadUnitResponse> payload = ::boost::static_pointer_cast<ReloadUnitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadUnitCallbackIF*) _callback)->onReloadUnitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RestartUnit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RestartUnitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RestartUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestartUnitError> payload = ::boost::static_pointer_cast<RestartUnitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RestartUnitCallbackIF*) _callback)->onRestartUnitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestartUnitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RestartUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestartUnitResponse> payload = ::boost::static_pointer_cast<RestartUnitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RestartUnitCallbackIF*) _callback)->onRestartUnitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_TryRestartUnit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), TryRestartUnitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TryRestartUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TryRestartUnitError> payload = ::boost::static_pointer_cast<TryRestartUnitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((TryRestartUnitCallbackIF*) _callback)->onTryRestartUnitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TryRestartUnitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "TryRestartUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TryRestartUnitResponse> payload = ::boost::static_pointer_cast<TryRestartUnitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((TryRestartUnitCallbackIF*) _callback)->onTryRestartUnitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReloadOrRestartUnit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReloadOrRestartUnitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReloadOrRestartUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadOrRestartUnitError> payload = ::boost::static_pointer_cast<ReloadOrRestartUnitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadOrRestartUnitCallbackIF*) _callback)->onReloadOrRestartUnitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadOrRestartUnitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReloadOrRestartUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadOrRestartUnitResponse> payload = ::boost::static_pointer_cast<ReloadOrRestartUnitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadOrRestartUnitCallbackIF*) _callback)->onReloadOrRestartUnitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReloadOrTryRestartUnit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReloadOrTryRestartUnitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReloadOrTryRestartUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadOrTryRestartUnitError> payload = ::boost::static_pointer_cast<ReloadOrTryRestartUnitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadOrTryRestartUnitCallbackIF*) _callback)->onReloadOrTryRestartUnitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadOrTryRestartUnitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReloadOrTryRestartUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadOrTryRestartUnitResponse> payload = ::boost::static_pointer_cast<ReloadOrTryRestartUnitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadOrTryRestartUnitCallbackIF*) _callback)->onReloadOrTryRestartUnitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_KillUnit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), KillUnitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "KillUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KillUnitError> payload = ::boost::static_pointer_cast<KillUnitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((KillUnitCallbackIF*) _callback)->onKillUnitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KillUnitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "KillUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KillUnitResponse> payload = ::boost::static_pointer_cast<KillUnitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((KillUnitCallbackIF*) _callback)->onKillUnitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ResetFailedUnit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ResetFailedUnitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResetFailedUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResetFailedUnitError> payload = ::boost::static_pointer_cast<ResetFailedUnitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ResetFailedUnitCallbackIF*) _callback)->onResetFailedUnitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResetFailedUnitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResetFailedUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResetFailedUnitResponse> payload = ::boost::static_pointer_cast<ResetFailedUnitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ResetFailedUnitCallbackIF*) _callback)->onResetFailedUnitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetUnitProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetUnitPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetUnitProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetUnitPropertiesError> payload = ::boost::static_pointer_cast<SetUnitPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetUnitPropertiesCallbackIF*) _callback)->onSetUnitPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetUnitPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetUnitProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetUnitPropertiesResponse> payload = ::boost::static_pointer_cast<SetUnitPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetUnitPropertiesCallbackIF*) _callback)->onSetUnitPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StartTransientUnit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartTransientUnitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartTransientUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartTransientUnitError> payload = ::boost::static_pointer_cast<StartTransientUnitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartTransientUnitCallbackIF*) _callback)->onStartTransientUnitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartTransientUnitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartTransientUnit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartTransientUnitResponse> payload = ::boost::static_pointer_cast<StartTransientUnitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartTransientUnitCallbackIF*) _callback)->onStartTransientUnitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetJob:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetJobError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetJob", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetJobError> payload = ::boost::static_pointer_cast<GetJobError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetJobCallbackIF*) _callback)->onGetJobError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetJobResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetJob", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetJobResponse> payload = ::boost::static_pointer_cast<GetJobResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetJobCallbackIF*) _callback)->onGetJobResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CancelJob:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelJobError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelJob", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelJobError> payload = ::boost::static_pointer_cast<CancelJobError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelJobCallbackIF*) _callback)->onCancelJobError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelJobResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelJob", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelJobResponse> payload = ::boost::static_pointer_cast<CancelJobResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelJobCallbackIF*) _callback)->onCancelJobResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ClearJobs:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ClearJobsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClearJobs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClearJobsError> payload = ::boost::static_pointer_cast<ClearJobsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ClearJobsCallbackIF*) _callback)->onClearJobsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClearJobsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClearJobs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClearJobsResponse> payload = ::boost::static_pointer_cast<ClearJobsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ClearJobsCallbackIF*) _callback)->onClearJobsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ResetFailed:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ResetFailedError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResetFailed", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResetFailedError> payload = ::boost::static_pointer_cast<ResetFailedError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ResetFailedCallbackIF*) _callback)->onResetFailedError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResetFailedResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResetFailed", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResetFailedResponse> payload = ::boost::static_pointer_cast<ResetFailedResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ResetFailedCallbackIF*) _callback)->onResetFailedResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ListUnits:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ListUnitsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListUnits", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListUnitsError> payload = ::boost::static_pointer_cast<ListUnitsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListUnitsCallbackIF*) _callback)->onListUnitsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListUnitsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListUnits", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListUnitsResponse> payload = ::boost::static_pointer_cast<ListUnitsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListUnitsCallbackIF*) _callback)->onListUnitsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ListUnitsFiltered:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ListUnitsFilteredError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListUnitsFiltered", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListUnitsFilteredError> payload = ::boost::static_pointer_cast<ListUnitsFilteredError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListUnitsFilteredCallbackIF*) _callback)->onListUnitsFilteredError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListUnitsFilteredResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListUnitsFiltered", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListUnitsFilteredResponse> payload = ::boost::static_pointer_cast<ListUnitsFilteredResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListUnitsFilteredCallbackIF*) _callback)->onListUnitsFilteredResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ListJobs:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ListJobsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListJobs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListJobsError> payload = ::boost::static_pointer_cast<ListJobsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListJobsCallbackIF*) _callback)->onListJobsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListJobsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListJobs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListJobsResponse> payload = ::boost::static_pointer_cast<ListJobsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListJobsCallbackIF*) _callback)->onListJobsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Subscribe:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SubscribeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Subscribe", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SubscribeError> payload = ::boost::static_pointer_cast<SubscribeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SubscribeCallbackIF*) _callback)->onSubscribeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SubscribeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Subscribe", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SubscribeResponse> payload = ::boost::static_pointer_cast<SubscribeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SubscribeCallbackIF*) _callback)->onSubscribeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Unsubscribe:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnsubscribeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Unsubscribe", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnsubscribeError> payload = ::boost::static_pointer_cast<UnsubscribeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnsubscribeCallbackIF*) _callback)->onUnsubscribeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnsubscribeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Unsubscribe", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnsubscribeResponse> payload = ::boost::static_pointer_cast<UnsubscribeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnsubscribeCallbackIF*) _callback)->onUnsubscribeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Dump:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DumpError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Dump", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DumpError> payload = ::boost::static_pointer_cast<DumpError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DumpCallbackIF*) _callback)->onDumpError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DumpResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Dump", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DumpResponse> payload = ::boost::static_pointer_cast<DumpResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DumpCallbackIF*) _callback)->onDumpResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CreateSnapshot:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CreateSnapshotError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateSnapshot", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateSnapshotError> payload = ::boost::static_pointer_cast<CreateSnapshotError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CreateSnapshotCallbackIF*) _callback)->onCreateSnapshotError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateSnapshotResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateSnapshot", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateSnapshotResponse> payload = ::boost::static_pointer_cast<CreateSnapshotResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CreateSnapshotCallbackIF*) _callback)->onCreateSnapshotResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RemoveSnapshot:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RemoveSnapshotError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveSnapshot", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoveSnapshotError> payload = ::boost::static_pointer_cast<RemoveSnapshotError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoveSnapshotCallbackIF*) _callback)->onRemoveSnapshotError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveSnapshotResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveSnapshot", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoveSnapshotResponse> payload = ::boost::static_pointer_cast<RemoveSnapshotResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoveSnapshotCallbackIF*) _callback)->onRemoveSnapshotResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Reload:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReloadError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Reload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadError> payload = ::boost::static_pointer_cast<ReloadError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadCallbackIF*) _callback)->onReloadError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Reload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadResponse> payload = ::boost::static_pointer_cast<ReloadResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadCallbackIF*) _callback)->onReloadResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Reexecute:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReexecuteError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Reexecute", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReexecuteError> payload = ::boost::static_pointer_cast<ReexecuteError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReexecuteCallbackIF*) _callback)->onReexecuteError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReexecuteResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Reexecute", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReexecuteResponse> payload = ::boost::static_pointer_cast<ReexecuteResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReexecuteCallbackIF*) _callback)->onReexecuteResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Exit:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ExitError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Exit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExitError> payload = ::boost::static_pointer_cast<ExitError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ExitCallbackIF*) _callback)->onExitError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExitResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Exit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExitResponse> payload = ::boost::static_pointer_cast<ExitResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ExitCallbackIF*) _callback)->onExitResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Reboot:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RebootError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Reboot", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RebootError> payload = ::boost::static_pointer_cast<RebootError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RebootCallbackIF*) _callback)->onRebootError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RebootResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Reboot", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RebootResponse> payload = ::boost::static_pointer_cast<RebootResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RebootCallbackIF*) _callback)->onRebootResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_PowerOff:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PowerOffError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PowerOff", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PowerOffError> payload = ::boost::static_pointer_cast<PowerOffError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PowerOffCallbackIF*) _callback)->onPowerOffError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PowerOffResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PowerOff", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PowerOffResponse> payload = ::boost::static_pointer_cast<PowerOffResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PowerOffCallbackIF*) _callback)->onPowerOffResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Halt:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), HaltError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Halt", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HaltError> payload = ::boost::static_pointer_cast<HaltError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HaltCallbackIF*) _callback)->onHaltError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HaltResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Halt", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HaltResponse> payload = ::boost::static_pointer_cast<HaltResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HaltCallbackIF*) _callback)->onHaltResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_KExec:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), KExecError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "KExec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KExecError> payload = ::boost::static_pointer_cast<KExecError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((KExecCallbackIF*) _callback)->onKExecError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KExecResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "KExec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KExecResponse> payload = ::boost::static_pointer_cast<KExecResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((KExecCallbackIF*) _callback)->onKExecResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SwitchRoot:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SwitchRootError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SwitchRoot", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SwitchRootError> payload = ::boost::static_pointer_cast<SwitchRootError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SwitchRootCallbackIF*) _callback)->onSwitchRootError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SwitchRootResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SwitchRoot", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SwitchRootResponse> payload = ::boost::static_pointer_cast<SwitchRootResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SwitchRootCallbackIF*) _callback)->onSwitchRootResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetEnvironment:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetEnvironmentError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetEnvironment", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetEnvironmentError> payload = ::boost::static_pointer_cast<SetEnvironmentError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetEnvironmentCallbackIF*) _callback)->onSetEnvironmentError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetEnvironmentResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetEnvironment", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetEnvironmentResponse> payload = ::boost::static_pointer_cast<SetEnvironmentResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetEnvironmentCallbackIF*) _callback)->onSetEnvironmentResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UnsetEnvironment:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnsetEnvironmentError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnsetEnvironment", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnsetEnvironmentError> payload = ::boost::static_pointer_cast<UnsetEnvironmentError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnsetEnvironmentCallbackIF*) _callback)->onUnsetEnvironmentError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnsetEnvironmentResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnsetEnvironment", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnsetEnvironmentResponse> payload = ::boost::static_pointer_cast<UnsetEnvironmentResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnsetEnvironmentCallbackIF*) _callback)->onUnsetEnvironmentResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UnsetAndSetEnvironment:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnsetAndSetEnvironmentError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnsetAndSetEnvironment", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnsetAndSetEnvironmentError> payload = ::boost::static_pointer_cast<UnsetAndSetEnvironmentError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnsetAndSetEnvironmentCallbackIF*) _callback)->onUnsetAndSetEnvironmentError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnsetAndSetEnvironmentResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnsetAndSetEnvironment", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnsetAndSetEnvironmentResponse> payload = ::boost::static_pointer_cast<UnsetAndSetEnvironmentResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnsetAndSetEnvironmentCallbackIF*) _callback)->onUnsetAndSetEnvironmentResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ListUnitFiles:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ListUnitFilesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListUnitFilesError> payload = ::boost::static_pointer_cast<ListUnitFilesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListUnitFilesCallbackIF*) _callback)->onListUnitFilesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListUnitFilesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListUnitFilesResponse> payload = ::boost::static_pointer_cast<ListUnitFilesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListUnitFilesCallbackIF*) _callback)->onListUnitFilesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetUnitFileState:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetUnitFileStateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUnitFileState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUnitFileStateError> payload = ::boost::static_pointer_cast<GetUnitFileStateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUnitFileStateCallbackIF*) _callback)->onGetUnitFileStateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUnitFileStateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUnitFileState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUnitFileStateResponse> payload = ::boost::static_pointer_cast<GetUnitFileStateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUnitFileStateCallbackIF*) _callback)->onGetUnitFileStateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_EnableUnitFiles:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EnableUnitFilesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EnableUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnableUnitFilesError> payload = ::boost::static_pointer_cast<EnableUnitFilesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EnableUnitFilesCallbackIF*) _callback)->onEnableUnitFilesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnableUnitFilesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EnableUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnableUnitFilesResponse> payload = ::boost::static_pointer_cast<EnableUnitFilesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EnableUnitFilesCallbackIF*) _callback)->onEnableUnitFilesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_DisableUnitFiles:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DisableUnitFilesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DisableUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisableUnitFilesError> payload = ::boost::static_pointer_cast<DisableUnitFilesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisableUnitFilesCallbackIF*) _callback)->onDisableUnitFilesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisableUnitFilesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DisableUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisableUnitFilesResponse> payload = ::boost::static_pointer_cast<DisableUnitFilesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisableUnitFilesCallbackIF*) _callback)->onDisableUnitFilesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReenableUnitFiles:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReenableUnitFilesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReenableUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReenableUnitFilesError> payload = ::boost::static_pointer_cast<ReenableUnitFilesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReenableUnitFilesCallbackIF*) _callback)->onReenableUnitFilesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReenableUnitFilesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReenableUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReenableUnitFilesResponse> payload = ::boost::static_pointer_cast<ReenableUnitFilesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReenableUnitFilesCallbackIF*) _callback)->onReenableUnitFilesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_LinkUnitFiles:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), LinkUnitFilesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LinkUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LinkUnitFilesError> payload = ::boost::static_pointer_cast<LinkUnitFilesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LinkUnitFilesCallbackIF*) _callback)->onLinkUnitFilesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LinkUnitFilesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "LinkUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LinkUnitFilesResponse> payload = ::boost::static_pointer_cast<LinkUnitFilesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LinkUnitFilesCallbackIF*) _callback)->onLinkUnitFilesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_PresetUnitFiles:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PresetUnitFilesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PresetUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PresetUnitFilesError> payload = ::boost::static_pointer_cast<PresetUnitFilesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PresetUnitFilesCallbackIF*) _callback)->onPresetUnitFilesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PresetUnitFilesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PresetUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PresetUnitFilesResponse> payload = ::boost::static_pointer_cast<PresetUnitFilesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PresetUnitFilesCallbackIF*) _callback)->onPresetUnitFilesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_PresetUnitFilesWithMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PresetUnitFilesWithModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PresetUnitFilesWithMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PresetUnitFilesWithModeError> payload = ::boost::static_pointer_cast<PresetUnitFilesWithModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PresetUnitFilesWithModeCallbackIF*) _callback)->onPresetUnitFilesWithModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PresetUnitFilesWithModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PresetUnitFilesWithMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PresetUnitFilesWithModeResponse> payload = ::boost::static_pointer_cast<PresetUnitFilesWithModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PresetUnitFilesWithModeCallbackIF*) _callback)->onPresetUnitFilesWithModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_MaskUnitFiles:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), MaskUnitFilesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MaskUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MaskUnitFilesError> payload = ::boost::static_pointer_cast<MaskUnitFilesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MaskUnitFilesCallbackIF*) _callback)->onMaskUnitFilesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MaskUnitFilesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "MaskUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MaskUnitFilesResponse> payload = ::boost::static_pointer_cast<MaskUnitFilesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MaskUnitFilesCallbackIF*) _callback)->onMaskUnitFilesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UnmaskUnitFiles:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnmaskUnitFilesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnmaskUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnmaskUnitFilesError> payload = ::boost::static_pointer_cast<UnmaskUnitFilesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnmaskUnitFilesCallbackIF*) _callback)->onUnmaskUnitFilesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnmaskUnitFilesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnmaskUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnmaskUnitFilesResponse> payload = ::boost::static_pointer_cast<UnmaskUnitFilesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnmaskUnitFilesCallbackIF*) _callback)->onUnmaskUnitFilesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetDefaultTarget:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetDefaultTargetError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetDefaultTarget", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetDefaultTargetError> payload = ::boost::static_pointer_cast<SetDefaultTargetError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetDefaultTargetCallbackIF*) _callback)->onSetDefaultTargetError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetDefaultTargetResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetDefaultTarget", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetDefaultTargetResponse> payload = ::boost::static_pointer_cast<SetDefaultTargetResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetDefaultTargetCallbackIF*) _callback)->onSetDefaultTargetResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetDefaultTarget:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetDefaultTargetError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetDefaultTarget", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetDefaultTargetError> payload = ::boost::static_pointer_cast<GetDefaultTargetError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetDefaultTargetCallbackIF*) _callback)->onGetDefaultTargetError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetDefaultTargetResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetDefaultTarget", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetDefaultTargetResponse> payload = ::boost::static_pointer_cast<GetDefaultTargetResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetDefaultTargetCallbackIF*) _callback)->onGetDefaultTargetResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_PresetAllUnitFiles:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PresetAllUnitFilesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PresetAllUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PresetAllUnitFilesError> payload = ::boost::static_pointer_cast<PresetAllUnitFilesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PresetAllUnitFilesCallbackIF*) _callback)->onPresetAllUnitFilesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PresetAllUnitFilesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PresetAllUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PresetAllUnitFilesResponse> payload = ::boost::static_pointer_cast<PresetAllUnitFilesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PresetAllUnitFilesCallbackIF*) _callback)->onPresetAllUnitFilesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AddDependencyUnitFiles:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AddDependencyUnitFilesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AddDependencyUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddDependencyUnitFilesError> payload = ::boost::static_pointer_cast<AddDependencyUnitFilesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AddDependencyUnitFilesCallbackIF*) _callback)->onAddDependencyUnitFilesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddDependencyUnitFilesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AddDependencyUnitFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddDependencyUnitFilesResponse> payload = ::boost::static_pointer_cast<AddDependencyUnitFilesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AddDependencyUnitFilesCallbackIF*) _callback)->onAddDependencyUnitFilesResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_UnitNew: {
                ::boost::shared_ptr< UnitNewError > payload = ::boost::shared_ptr< UnitNewError >
                (new UnitNewError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnitNew", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnitNewCallbackIF*) _callback)->onUnitNewError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnitRemoved: {
                ::boost::shared_ptr< UnitRemovedError > payload = ::boost::shared_ptr< UnitRemovedError >
                (new UnitRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnitRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnitRemovedCallbackIF*) _callback)->onUnitRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_JobNew: {
                ::boost::shared_ptr< JobNewError > payload = ::boost::shared_ptr< JobNewError >
                (new JobNewError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "JobNew", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((JobNewCallbackIF*) _callback)->onJobNewError (proxyShared,payload);
                return true;
            }
            break;
            case ID_JobRemoved: {
                ::boost::shared_ptr< JobRemovedError > payload = ::boost::shared_ptr< JobRemovedError >
                (new JobRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "JobRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((JobRemovedCallbackIF*) _callback)->onJobRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartupFinished: {
                ::boost::shared_ptr< StartupFinishedError > payload = ::boost::shared_ptr< StartupFinishedError >
                (new StartupFinishedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartupFinished", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartupFinishedCallbackIF*) _callback)->onStartupFinishedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnitFilesChanged: {
                ::boost::shared_ptr< UnitFilesChangedError > payload = ::boost::shared_ptr< UnitFilesChangedError >
                (new UnitFilesChangedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnitFilesChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnitFilesChangedCallbackIF*) _callback)->onUnitFilesChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Reloading: {
                ::boost::shared_ptr< ReloadingError > payload = ::boost::shared_ptr< ReloadingError >
                (new ReloadingError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Reloading", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReloadingCallbackIF*) _callback)->onReloadingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Version: {
                ::boost::shared_ptr< VersionError > payload = ::boost::shared_ptr< VersionError >
                (new VersionError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Version", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VersionCallbackIF*) _callback)->onVersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Features: {
                ::boost::shared_ptr< FeaturesError > payload = ::boost::shared_ptr< FeaturesError >
                (new FeaturesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Features", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FeaturesCallbackIF*) _callback)->onFeaturesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Virtualization: {
                ::boost::shared_ptr< VirtualizationError > payload = ::boost::shared_ptr< VirtualizationError >
                (new VirtualizationError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Virtualization", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VirtualizationCallbackIF*) _callback)->onVirtualizationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Architecture: {
                ::boost::shared_ptr< ArchitectureError > payload = ::boost::shared_ptr< ArchitectureError >
                (new ArchitectureError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Architecture", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ArchitectureCallbackIF*) _callback)->onArchitectureError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Tainted: {
                ::boost::shared_ptr< TaintedError > payload = ::boost::shared_ptr< TaintedError >
                (new TaintedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Tainted", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TaintedCallbackIF*) _callback)->onTaintedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FirmwareTimestamp: {
                ::boost::shared_ptr< FirmwareTimestampError > payload = ::boost::shared_ptr< FirmwareTimestampError >
                (new FirmwareTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FirmwareTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FirmwareTimestampCallbackIF*) _callback)->onFirmwareTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FirmwareTimestampMonotonic: {
                ::boost::shared_ptr< FirmwareTimestampMonotonicError > payload = ::boost::shared_ptr< FirmwareTimestampMonotonicError >
                (new FirmwareTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FirmwareTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FirmwareTimestampMonotonicCallbackIF*) _callback)->onFirmwareTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LoaderTimestamp: {
                ::boost::shared_ptr< LoaderTimestampError > payload = ::boost::shared_ptr< LoaderTimestampError >
                (new LoaderTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LoaderTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LoaderTimestampCallbackIF*) _callback)->onLoaderTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LoaderTimestampMonotonic: {
                ::boost::shared_ptr< LoaderTimestampMonotonicError > payload = ::boost::shared_ptr< LoaderTimestampMonotonicError >
                (new LoaderTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LoaderTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LoaderTimestampMonotonicCallbackIF*) _callback)->onLoaderTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_KernelTimestamp: {
                ::boost::shared_ptr< KernelTimestampError > payload = ::boost::shared_ptr< KernelTimestampError >
                (new KernelTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "KernelTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((KernelTimestampCallbackIF*) _callback)->onKernelTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_KernelTimestampMonotonic: {
                ::boost::shared_ptr< KernelTimestampMonotonicError > payload = ::boost::shared_ptr< KernelTimestampMonotonicError >
                (new KernelTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "KernelTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((KernelTimestampMonotonicCallbackIF*) _callback)->onKernelTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_InitRDTimestamp: {
                ::boost::shared_ptr< InitRDTimestampError > payload = ::boost::shared_ptr< InitRDTimestampError >
                (new InitRDTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InitRDTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InitRDTimestampCallbackIF*) _callback)->onInitRDTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_InitRDTimestampMonotonic: {
                ::boost::shared_ptr< InitRDTimestampMonotonicError > payload = ::boost::shared_ptr< InitRDTimestampMonotonicError >
                (new InitRDTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InitRDTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InitRDTimestampMonotonicCallbackIF*) _callback)->onInitRDTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UserspaceTimestamp: {
                ::boost::shared_ptr< UserspaceTimestampError > payload = ::boost::shared_ptr< UserspaceTimestampError >
                (new UserspaceTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UserspaceTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UserspaceTimestampCallbackIF*) _callback)->onUserspaceTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UserspaceTimestampMonotonic: {
                ::boost::shared_ptr< UserspaceTimestampMonotonicError > payload = ::boost::shared_ptr< UserspaceTimestampMonotonicError >
                (new UserspaceTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UserspaceTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UserspaceTimestampMonotonicCallbackIF*) _callback)->onUserspaceTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FinishTimestamp: {
                ::boost::shared_ptr< FinishTimestampError > payload = ::boost::shared_ptr< FinishTimestampError >
                (new FinishTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FinishTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FinishTimestampCallbackIF*) _callback)->onFinishTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FinishTimestampMonotonic: {
                ::boost::shared_ptr< FinishTimestampMonotonicError > payload = ::boost::shared_ptr< FinishTimestampMonotonicError >
                (new FinishTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FinishTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FinishTimestampMonotonicCallbackIF*) _callback)->onFinishTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SecurityStartTimestamp: {
                ::boost::shared_ptr< SecurityStartTimestampError > payload = ::boost::shared_ptr< SecurityStartTimestampError >
                (new SecurityStartTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SecurityStartTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SecurityStartTimestampCallbackIF*) _callback)->onSecurityStartTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SecurityStartTimestampMonotonic: {
                ::boost::shared_ptr< SecurityStartTimestampMonotonicError > payload = ::boost::shared_ptr< SecurityStartTimestampMonotonicError >
                (new SecurityStartTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SecurityStartTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SecurityStartTimestampMonotonicCallbackIF*) _callback)->onSecurityStartTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SecurityFinishTimestamp: {
                ::boost::shared_ptr< SecurityFinishTimestampError > payload = ::boost::shared_ptr< SecurityFinishTimestampError >
                (new SecurityFinishTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SecurityFinishTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SecurityFinishTimestampCallbackIF*) _callback)->onSecurityFinishTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SecurityFinishTimestampMonotonic: {
                ::boost::shared_ptr< SecurityFinishTimestampMonotonicError > payload = ::boost::shared_ptr< SecurityFinishTimestampMonotonicError >
                (new SecurityFinishTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SecurityFinishTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SecurityFinishTimestampMonotonicCallbackIF*) _callback)->onSecurityFinishTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GeneratorsStartTimestamp: {
                ::boost::shared_ptr< GeneratorsStartTimestampError > payload = ::boost::shared_ptr< GeneratorsStartTimestampError >
                (new GeneratorsStartTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GeneratorsStartTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GeneratorsStartTimestampCallbackIF*) _callback)->onGeneratorsStartTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GeneratorsStartTimestampMonotonic: {
                ::boost::shared_ptr< GeneratorsStartTimestampMonotonicError > payload = ::boost::shared_ptr< GeneratorsStartTimestampMonotonicError >
                (new GeneratorsStartTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GeneratorsStartTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GeneratorsStartTimestampMonotonicCallbackIF*) _callback)->onGeneratorsStartTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GeneratorsFinishTimestamp: {
                ::boost::shared_ptr< GeneratorsFinishTimestampError > payload = ::boost::shared_ptr< GeneratorsFinishTimestampError >
                (new GeneratorsFinishTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GeneratorsFinishTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GeneratorsFinishTimestampCallbackIF*) _callback)->onGeneratorsFinishTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GeneratorsFinishTimestampMonotonic: {
                ::boost::shared_ptr< GeneratorsFinishTimestampMonotonicError > payload = ::boost::shared_ptr< GeneratorsFinishTimestampMonotonicError >
                (new GeneratorsFinishTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GeneratorsFinishTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GeneratorsFinishTimestampMonotonicCallbackIF*) _callback)->onGeneratorsFinishTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnitsLoadStartTimestamp: {
                ::boost::shared_ptr< UnitsLoadStartTimestampError > payload = ::boost::shared_ptr< UnitsLoadStartTimestampError >
                (new UnitsLoadStartTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnitsLoadStartTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnitsLoadStartTimestampCallbackIF*) _callback)->onUnitsLoadStartTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnitsLoadStartTimestampMonotonic: {
                ::boost::shared_ptr< UnitsLoadStartTimestampMonotonicError > payload = ::boost::shared_ptr< UnitsLoadStartTimestampMonotonicError >
                (new UnitsLoadStartTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnitsLoadStartTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnitsLoadStartTimestampMonotonicCallbackIF*) _callback)->onUnitsLoadStartTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnitsLoadFinishTimestamp: {
                ::boost::shared_ptr< UnitsLoadFinishTimestampError > payload = ::boost::shared_ptr< UnitsLoadFinishTimestampError >
                (new UnitsLoadFinishTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnitsLoadFinishTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnitsLoadFinishTimestampCallbackIF*) _callback)->onUnitsLoadFinishTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnitsLoadFinishTimestampMonotonic: {
                ::boost::shared_ptr< UnitsLoadFinishTimestampMonotonicError > payload = ::boost::shared_ptr< UnitsLoadFinishTimestampMonotonicError >
                (new UnitsLoadFinishTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnitsLoadFinishTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnitsLoadFinishTimestampMonotonicCallbackIF*) _callback)->onUnitsLoadFinishTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LogLevel: {
                ::boost::shared_ptr< LogLevelError > payload = ::boost::shared_ptr< LogLevelError >
                (new LogLevelError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LogLevel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LogLevelCallbackIF*) _callback)->onLogLevelError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LogTarget: {
                ::boost::shared_ptr< LogTargetError > payload = ::boost::shared_ptr< LogTargetError >
                (new LogTargetError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LogTarget", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LogTargetCallbackIF*) _callback)->onLogTargetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NNames: {
                ::boost::shared_ptr< NNamesError > payload = ::boost::shared_ptr< NNamesError >
                (new NNamesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NNames", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NNamesCallbackIF*) _callback)->onNNamesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NFailedUnits: {
                ::boost::shared_ptr< NFailedUnitsError > payload = ::boost::shared_ptr< NFailedUnitsError >
                (new NFailedUnitsError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NFailedUnits", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NFailedUnitsCallbackIF*) _callback)->onNFailedUnitsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NJobs: {
                ::boost::shared_ptr< NJobsError > payload = ::boost::shared_ptr< NJobsError >
                (new NJobsError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NJobs", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NJobsCallbackIF*) _callback)->onNJobsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NInstalledJobs: {
                ::boost::shared_ptr< NInstalledJobsError > payload = ::boost::shared_ptr< NInstalledJobsError >
                (new NInstalledJobsError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NInstalledJobs", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NInstalledJobsCallbackIF*) _callback)->onNInstalledJobsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NFailedJobs: {
                ::boost::shared_ptr< NFailedJobsError > payload = ::boost::shared_ptr< NFailedJobsError >
                (new NFailedJobsError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NFailedJobs", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NFailedJobsCallbackIF*) _callback)->onNFailedJobsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Progress: {
                ::boost::shared_ptr< ProgressError > payload = ::boost::shared_ptr< ProgressError >
                (new ProgressError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Progress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProgressCallbackIF*) _callback)->onProgressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Environment: {
                ::boost::shared_ptr< EnvironmentError > payload = ::boost::shared_ptr< EnvironmentError >
                (new EnvironmentError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Environment", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EnvironmentCallbackIF*) _callback)->onEnvironmentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ConfirmSpawn: {
                ::boost::shared_ptr< ConfirmSpawnError > payload = ::boost::shared_ptr< ConfirmSpawnError >
                (new ConfirmSpawnError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConfirmSpawn", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConfirmSpawnCallbackIF*) _callback)->onConfirmSpawnError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ShowStatus: {
                ::boost::shared_ptr< ShowStatusError > payload = ::boost::shared_ptr< ShowStatusError >
                (new ShowStatusError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowStatusCallbackIF*) _callback)->onShowStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnitPath: {
                ::boost::shared_ptr< UnitPathError > payload = ::boost::shared_ptr< UnitPathError >
                (new UnitPathError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnitPath", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnitPathCallbackIF*) _callback)->onUnitPathError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DefaultStandardOutput: {
                ::boost::shared_ptr< DefaultStandardOutputError > payload = ::boost::shared_ptr< DefaultStandardOutputError >
                (new DefaultStandardOutputError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DefaultStandardOutput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DefaultStandardOutputCallbackIF*) _callback)->onDefaultStandardOutputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DefaultStandardError: {
                ::boost::shared_ptr< DefaultStandardErrorError > payload = ::boost::shared_ptr< DefaultStandardErrorError >
                (new DefaultStandardErrorError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DefaultStandardError", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DefaultStandardErrorCallbackIF*) _callback)->onDefaultStandardErrorError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RuntimeWatchdogUSec: {
                ::boost::shared_ptr< RuntimeWatchdogUSecError > payload = ::boost::shared_ptr< RuntimeWatchdogUSecError >
                (new RuntimeWatchdogUSecError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RuntimeWatchdogUSec", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RuntimeWatchdogUSecCallbackIF*) _callback)->onRuntimeWatchdogUSecError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ShutdownWatchdogUSec: {
                ::boost::shared_ptr< ShutdownWatchdogUSecError > payload = ::boost::shared_ptr< ShutdownWatchdogUSecError >
                (new ShutdownWatchdogUSecError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShutdownWatchdogUSec", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShutdownWatchdogUSecCallbackIF*) _callback)->onShutdownWatchdogUSecError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ControlGroup: {
                ::boost::shared_ptr< ControlGroupError > payload = ::boost::shared_ptr< ControlGroupError >
                (new ControlGroupError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ControlGroup", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ControlGroupCallbackIF*) _callback)->onControlGroupError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SystemState: {
                ::boost::shared_ptr< SystemStateError > payload = ::boost::shared_ptr< SystemStateError >
                (new SystemStateError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SystemState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SystemStateCallbackIF*) _callback)->onSystemStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetUnit: {
                ::boost::shared_ptr< GetUnitError > payload = ::boost::shared_ptr< GetUnitError >
                (new GetUnitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetUnit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetUnitCallbackIF*) _callback)->onGetUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetUnitByPID: {
                ::boost::shared_ptr< GetUnitByPIDError > payload = ::boost::shared_ptr< GetUnitByPIDError >
                (new GetUnitByPIDError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetUnitByPID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetUnitByPIDCallbackIF*) _callback)->onGetUnitByPIDError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LoadUnit: {
                ::boost::shared_ptr< LoadUnitError > payload = ::boost::shared_ptr< LoadUnitError >
                (new LoadUnitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LoadUnit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LoadUnitCallbackIF*) _callback)->onLoadUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartUnit: {
                ::boost::shared_ptr< StartUnitError > payload = ::boost::shared_ptr< StartUnitError >
                (new StartUnitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartUnit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartUnitCallbackIF*) _callback)->onStartUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartUnitReplace: {
                ::boost::shared_ptr< StartUnitReplaceError > payload = ::boost::shared_ptr< StartUnitReplaceError >
                (new StartUnitReplaceError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartUnitReplace", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartUnitReplaceCallbackIF*) _callback)->onStartUnitReplaceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StopUnit: {
                ::boost::shared_ptr< StopUnitError > payload = ::boost::shared_ptr< StopUnitError >
                (new StopUnitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StopUnit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StopUnitCallbackIF*) _callback)->onStopUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReloadUnit: {
                ::boost::shared_ptr< ReloadUnitError > payload = ::boost::shared_ptr< ReloadUnitError >
                (new ReloadUnitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReloadUnit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReloadUnitCallbackIF*) _callback)->onReloadUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RestartUnit: {
                ::boost::shared_ptr< RestartUnitError > payload = ::boost::shared_ptr< RestartUnitError >
                (new RestartUnitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RestartUnit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RestartUnitCallbackIF*) _callback)->onRestartUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TryRestartUnit: {
                ::boost::shared_ptr< TryRestartUnitError > payload = ::boost::shared_ptr< TryRestartUnitError >
                (new TryRestartUnitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TryRestartUnit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TryRestartUnitCallbackIF*) _callback)->onTryRestartUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReloadOrRestartUnit: {
                ::boost::shared_ptr< ReloadOrRestartUnitError > payload = ::boost::shared_ptr< ReloadOrRestartUnitError >
                (new ReloadOrRestartUnitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReloadOrRestartUnit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReloadOrRestartUnitCallbackIF*) _callback)->onReloadOrRestartUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReloadOrTryRestartUnit: {
                ::boost::shared_ptr< ReloadOrTryRestartUnitError > payload = ::boost::shared_ptr< ReloadOrTryRestartUnitError >
                (new ReloadOrTryRestartUnitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReloadOrTryRestartUnit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReloadOrTryRestartUnitCallbackIF*) _callback)->onReloadOrTryRestartUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_KillUnit: {
                ::boost::shared_ptr< KillUnitError > payload = ::boost::shared_ptr< KillUnitError >
                (new KillUnitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "KillUnit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((KillUnitCallbackIF*) _callback)->onKillUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ResetFailedUnit: {
                ::boost::shared_ptr< ResetFailedUnitError > payload = ::boost::shared_ptr< ResetFailedUnitError >
                (new ResetFailedUnitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ResetFailedUnit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ResetFailedUnitCallbackIF*) _callback)->onResetFailedUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetUnitProperties: {
                ::boost::shared_ptr< SetUnitPropertiesError > payload = ::boost::shared_ptr< SetUnitPropertiesError >
                (new SetUnitPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetUnitProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetUnitPropertiesCallbackIF*) _callback)->onSetUnitPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartTransientUnit: {
                ::boost::shared_ptr< StartTransientUnitError > payload = ::boost::shared_ptr< StartTransientUnitError >
                (new StartTransientUnitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartTransientUnit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartTransientUnitCallbackIF*) _callback)->onStartTransientUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetJob: {
                ::boost::shared_ptr< GetJobError > payload = ::boost::shared_ptr< GetJobError >
                (new GetJobError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetJob", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetJobCallbackIF*) _callback)->onGetJobError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CancelJob: {
                ::boost::shared_ptr< CancelJobError > payload = ::boost::shared_ptr< CancelJobError >
                (new CancelJobError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CancelJob", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelJobCallbackIF*) _callback)->onCancelJobError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ClearJobs: {
                ::boost::shared_ptr< ClearJobsError > payload = ::boost::shared_ptr< ClearJobsError >
                (new ClearJobsError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ClearJobs", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ClearJobsCallbackIF*) _callback)->onClearJobsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ResetFailed: {
                ::boost::shared_ptr< ResetFailedError > payload = ::boost::shared_ptr< ResetFailedError >
                (new ResetFailedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ResetFailed", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ResetFailedCallbackIF*) _callback)->onResetFailedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ListUnits: {
                ::boost::shared_ptr< ListUnitsError > payload = ::boost::shared_ptr< ListUnitsError >
                (new ListUnitsError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ListUnits", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ListUnitsCallbackIF*) _callback)->onListUnitsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ListUnitsFiltered: {
                ::boost::shared_ptr< ListUnitsFilteredError > payload = ::boost::shared_ptr< ListUnitsFilteredError >
                (new ListUnitsFilteredError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ListUnitsFiltered", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ListUnitsFilteredCallbackIF*) _callback)->onListUnitsFilteredError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ListJobs: {
                ::boost::shared_ptr< ListJobsError > payload = ::boost::shared_ptr< ListJobsError >
                (new ListJobsError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ListJobs", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ListJobsCallbackIF*) _callback)->onListJobsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Subscribe: {
                ::boost::shared_ptr< SubscribeError > payload = ::boost::shared_ptr< SubscribeError >
                (new SubscribeError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Subscribe", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SubscribeCallbackIF*) _callback)->onSubscribeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Unsubscribe: {
                ::boost::shared_ptr< UnsubscribeError > payload = ::boost::shared_ptr< UnsubscribeError >
                (new UnsubscribeError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Unsubscribe", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnsubscribeCallbackIF*) _callback)->onUnsubscribeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Dump: {
                ::boost::shared_ptr< DumpError > payload = ::boost::shared_ptr< DumpError >
                (new DumpError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Dump", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DumpCallbackIF*) _callback)->onDumpError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CreateSnapshot: {
                ::boost::shared_ptr< CreateSnapshotError > payload = ::boost::shared_ptr< CreateSnapshotError >
                (new CreateSnapshotError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CreateSnapshot", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CreateSnapshotCallbackIF*) _callback)->onCreateSnapshotError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RemoveSnapshot: {
                ::boost::shared_ptr< RemoveSnapshotError > payload = ::boost::shared_ptr< RemoveSnapshotError >
                (new RemoveSnapshotError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemoveSnapshot", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemoveSnapshotCallbackIF*) _callback)->onRemoveSnapshotError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Reload: {
                ::boost::shared_ptr< ReloadError > payload = ::boost::shared_ptr< ReloadError >
                (new ReloadError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Reload", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReloadCallbackIF*) _callback)->onReloadError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Reexecute: {
                ::boost::shared_ptr< ReexecuteError > payload = ::boost::shared_ptr< ReexecuteError >
                (new ReexecuteError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Reexecute", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReexecuteCallbackIF*) _callback)->onReexecuteError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Exit: {
                ::boost::shared_ptr< ExitError > payload = ::boost::shared_ptr< ExitError >
                (new ExitError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Exit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExitCallbackIF*) _callback)->onExitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Reboot: {
                ::boost::shared_ptr< RebootError > payload = ::boost::shared_ptr< RebootError >
                (new RebootError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Reboot", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RebootCallbackIF*) _callback)->onRebootError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PowerOff: {
                ::boost::shared_ptr< PowerOffError > payload = ::boost::shared_ptr< PowerOffError >
                (new PowerOffError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PowerOff", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PowerOffCallbackIF*) _callback)->onPowerOffError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Halt: {
                ::boost::shared_ptr< HaltError > payload = ::boost::shared_ptr< HaltError >
                (new HaltError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Halt", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HaltCallbackIF*) _callback)->onHaltError (proxyShared,payload);
                return true;
            }
            break;
            case ID_KExec: {
                ::boost::shared_ptr< KExecError > payload = ::boost::shared_ptr< KExecError >
                (new KExecError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "KExec", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((KExecCallbackIF*) _callback)->onKExecError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SwitchRoot: {
                ::boost::shared_ptr< SwitchRootError > payload = ::boost::shared_ptr< SwitchRootError >
                (new SwitchRootError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SwitchRoot", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SwitchRootCallbackIF*) _callback)->onSwitchRootError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetEnvironment: {
                ::boost::shared_ptr< SetEnvironmentError > payload = ::boost::shared_ptr< SetEnvironmentError >
                (new SetEnvironmentError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetEnvironment", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetEnvironmentCallbackIF*) _callback)->onSetEnvironmentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnsetEnvironment: {
                ::boost::shared_ptr< UnsetEnvironmentError > payload = ::boost::shared_ptr< UnsetEnvironmentError >
                (new UnsetEnvironmentError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnsetEnvironment", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnsetEnvironmentCallbackIF*) _callback)->onUnsetEnvironmentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnsetAndSetEnvironment: {
                ::boost::shared_ptr< UnsetAndSetEnvironmentError > payload = ::boost::shared_ptr< UnsetAndSetEnvironmentError >
                (new UnsetAndSetEnvironmentError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnsetAndSetEnvironment", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnsetAndSetEnvironmentCallbackIF*) _callback)->onUnsetAndSetEnvironmentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ListUnitFiles: {
                ::boost::shared_ptr< ListUnitFilesError > payload = ::boost::shared_ptr< ListUnitFilesError >
                (new ListUnitFilesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ListUnitFiles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ListUnitFilesCallbackIF*) _callback)->onListUnitFilesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetUnitFileState: {
                ::boost::shared_ptr< GetUnitFileStateError > payload = ::boost::shared_ptr< GetUnitFileStateError >
                (new GetUnitFileStateError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetUnitFileState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetUnitFileStateCallbackIF*) _callback)->onGetUnitFileStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EnableUnitFiles: {
                ::boost::shared_ptr< EnableUnitFilesError > payload = ::boost::shared_ptr< EnableUnitFilesError >
                (new EnableUnitFilesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EnableUnitFiles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EnableUnitFilesCallbackIF*) _callback)->onEnableUnitFilesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DisableUnitFiles: {
                ::boost::shared_ptr< DisableUnitFilesError > payload = ::boost::shared_ptr< DisableUnitFilesError >
                (new DisableUnitFilesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DisableUnitFiles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisableUnitFilesCallbackIF*) _callback)->onDisableUnitFilesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReenableUnitFiles: {
                ::boost::shared_ptr< ReenableUnitFilesError > payload = ::boost::shared_ptr< ReenableUnitFilesError >
                (new ReenableUnitFilesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReenableUnitFiles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReenableUnitFilesCallbackIF*) _callback)->onReenableUnitFilesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LinkUnitFiles: {
                ::boost::shared_ptr< LinkUnitFilesError > payload = ::boost::shared_ptr< LinkUnitFilesError >
                (new LinkUnitFilesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LinkUnitFiles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LinkUnitFilesCallbackIF*) _callback)->onLinkUnitFilesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PresetUnitFiles: {
                ::boost::shared_ptr< PresetUnitFilesError > payload = ::boost::shared_ptr< PresetUnitFilesError >
                (new PresetUnitFilesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PresetUnitFiles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PresetUnitFilesCallbackIF*) _callback)->onPresetUnitFilesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PresetUnitFilesWithMode: {
                ::boost::shared_ptr< PresetUnitFilesWithModeError > payload = ::boost::shared_ptr< PresetUnitFilesWithModeError >
                (new PresetUnitFilesWithModeError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PresetUnitFilesWithMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PresetUnitFilesWithModeCallbackIF*) _callback)->onPresetUnitFilesWithModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MaskUnitFiles: {
                ::boost::shared_ptr< MaskUnitFilesError > payload = ::boost::shared_ptr< MaskUnitFilesError >
                (new MaskUnitFilesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MaskUnitFiles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MaskUnitFilesCallbackIF*) _callback)->onMaskUnitFilesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnmaskUnitFiles: {
                ::boost::shared_ptr< UnmaskUnitFilesError > payload = ::boost::shared_ptr< UnmaskUnitFilesError >
                (new UnmaskUnitFilesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnmaskUnitFiles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnmaskUnitFilesCallbackIF*) _callback)->onUnmaskUnitFilesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetDefaultTarget: {
                ::boost::shared_ptr< SetDefaultTargetError > payload = ::boost::shared_ptr< SetDefaultTargetError >
                (new SetDefaultTargetError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetDefaultTarget", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetDefaultTargetCallbackIF*) _callback)->onSetDefaultTargetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetDefaultTarget: {
                ::boost::shared_ptr< GetDefaultTargetError > payload = ::boost::shared_ptr< GetDefaultTargetError >
                (new GetDefaultTargetError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetDefaultTarget", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetDefaultTargetCallbackIF*) _callback)->onGetDefaultTargetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PresetAllUnitFiles: {
                ::boost::shared_ptr< PresetAllUnitFilesError > payload = ::boost::shared_ptr< PresetAllUnitFilesError >
                (new PresetAllUnitFilesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PresetAllUnitFiles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PresetAllUnitFilesCallbackIF*) _callback)->onPresetAllUnitFilesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AddDependencyUnitFiles: {
                ::boost::shared_ptr< AddDependencyUnitFilesError > payload = ::boost::shared_ptr< AddDependencyUnitFilesError >
                (new AddDependencyUnitFilesError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AddDependencyUnitFiles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AddDependencyUnitFilesCallbackIF*) _callback)->onAddDependencyUnitFilesError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ManagerProxyCallback::_logger (ManagerProxy::_logger);

ManagerProxy::ManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.freedesktop.systemd1.Manager", serviceAvailable, _logger) {
}

ManagerProxy::~ManagerProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ManagerProxy > ManagerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ManagerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ManagerProxy > proxyNew(new ManagerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t ManagerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ManagerProxyCallback* callback = new ManagerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ManagerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ManagerProxyCallback* callback = new ManagerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ManagerProxy::clearAllProperties ()
{
    _version = ::asf::core::nullable< VersionUpdate >();
    _features = ::asf::core::nullable< FeaturesUpdate >();
    _virtualization = ::asf::core::nullable< VirtualizationUpdate >();
    _architecture = ::asf::core::nullable< ArchitectureUpdate >();
    _tainted = ::asf::core::nullable< TaintedUpdate >();
    _firmwareTimestamp = ::asf::core::nullable< FirmwareTimestampUpdate >();
    _firmwareTimestampMonotonic = ::asf::core::nullable< FirmwareTimestampMonotonicUpdate >();
    _loaderTimestamp = ::asf::core::nullable< LoaderTimestampUpdate >();
    _loaderTimestampMonotonic = ::asf::core::nullable< LoaderTimestampMonotonicUpdate >();
    _kernelTimestamp = ::asf::core::nullable< KernelTimestampUpdate >();
    _kernelTimestampMonotonic = ::asf::core::nullable< KernelTimestampMonotonicUpdate >();
    _initRDTimestamp = ::asf::core::nullable< InitRDTimestampUpdate >();
    _initRDTimestampMonotonic = ::asf::core::nullable< InitRDTimestampMonotonicUpdate >();
    _userspaceTimestamp = ::asf::core::nullable< UserspaceTimestampUpdate >();
    _userspaceTimestampMonotonic = ::asf::core::nullable< UserspaceTimestampMonotonicUpdate >();
    _finishTimestamp = ::asf::core::nullable< FinishTimestampUpdate >();
    _finishTimestampMonotonic = ::asf::core::nullable< FinishTimestampMonotonicUpdate >();
    _securityStartTimestamp = ::asf::core::nullable< SecurityStartTimestampUpdate >();
    _securityStartTimestampMonotonic = ::asf::core::nullable< SecurityStartTimestampMonotonicUpdate >();
    _securityFinishTimestamp = ::asf::core::nullable< SecurityFinishTimestampUpdate >();
    _securityFinishTimestampMonotonic = ::asf::core::nullable< SecurityFinishTimestampMonotonicUpdate >();
    _generatorsStartTimestamp = ::asf::core::nullable< GeneratorsStartTimestampUpdate >();
    _generatorsStartTimestampMonotonic = ::asf::core::nullable< GeneratorsStartTimestampMonotonicUpdate >();
    _generatorsFinishTimestamp = ::asf::core::nullable< GeneratorsFinishTimestampUpdate >();
    _generatorsFinishTimestampMonotonic = ::asf::core::nullable< GeneratorsFinishTimestampMonotonicUpdate >();
    _unitsLoadStartTimestamp = ::asf::core::nullable< UnitsLoadStartTimestampUpdate >();
    _unitsLoadStartTimestampMonotonic = ::asf::core::nullable< UnitsLoadStartTimestampMonotonicUpdate >();
    _unitsLoadFinishTimestamp = ::asf::core::nullable< UnitsLoadFinishTimestampUpdate >();
    _unitsLoadFinishTimestampMonotonic = ::asf::core::nullable< UnitsLoadFinishTimestampMonotonicUpdate >();
    _logLevel = ::asf::core::nullable< LogLevelUpdate >();
    _logTarget = ::asf::core::nullable< LogTargetUpdate >();
    _nNames = ::asf::core::nullable< NNamesUpdate >();
    _nFailedUnits = ::asf::core::nullable< NFailedUnitsUpdate >();
    _nJobs = ::asf::core::nullable< NJobsUpdate >();
    _nInstalledJobs = ::asf::core::nullable< NInstalledJobsUpdate >();
    _nFailedJobs = ::asf::core::nullable< NFailedJobsUpdate >();
    _progress = ::asf::core::nullable< ProgressUpdate >();
    _environment = ::asf::core::nullable< EnvironmentUpdate >();
    _confirmSpawn = ::asf::core::nullable< ConfirmSpawnUpdate >();
    _showStatus = ::asf::core::nullable< ShowStatusUpdate >();
    _unitPath = ::asf::core::nullable< UnitPathUpdate >();
    _defaultStandardOutput = ::asf::core::nullable< DefaultStandardOutputUpdate >();
    _defaultStandardError = ::asf::core::nullable< DefaultStandardErrorUpdate >();
    _runtimeWatchdogUSec = ::asf::core::nullable< RuntimeWatchdogUSecUpdate >();
    _shutdownWatchdogUSec = ::asf::core::nullable< ShutdownWatchdogUSecUpdate >();
    _controlGroup = ::asf::core::nullable< ControlGroupUpdate >();
    _systemState = ::asf::core::nullable< SystemStateUpdate >();
}

void ManagerProxy::sendDeregisterAll () const
{
    sendVersionDeregisterAll();
    sendFeaturesDeregisterAll();
    sendVirtualizationDeregisterAll();
    sendArchitectureDeregisterAll();
    sendTaintedDeregisterAll();
    sendFirmwareTimestampDeregisterAll();
    sendFirmwareTimestampMonotonicDeregisterAll();
    sendLoaderTimestampDeregisterAll();
    sendLoaderTimestampMonotonicDeregisterAll();
    sendKernelTimestampDeregisterAll();
    sendKernelTimestampMonotonicDeregisterAll();
    sendInitRDTimestampDeregisterAll();
    sendInitRDTimestampMonotonicDeregisterAll();
    sendUserspaceTimestampDeregisterAll();
    sendUserspaceTimestampMonotonicDeregisterAll();
    sendFinishTimestampDeregisterAll();
    sendFinishTimestampMonotonicDeregisterAll();
    sendSecurityStartTimestampDeregisterAll();
    sendSecurityStartTimestampMonotonicDeregisterAll();
    sendSecurityFinishTimestampDeregisterAll();
    sendSecurityFinishTimestampMonotonicDeregisterAll();
    sendGeneratorsStartTimestampDeregisterAll();
    sendGeneratorsStartTimestampMonotonicDeregisterAll();
    sendGeneratorsFinishTimestampDeregisterAll();
    sendGeneratorsFinishTimestampMonotonicDeregisterAll();
    sendUnitsLoadStartTimestampDeregisterAll();
    sendUnitsLoadStartTimestampMonotonicDeregisterAll();
    sendUnitsLoadFinishTimestampDeregisterAll();
    sendUnitsLoadFinishTimestampMonotonicDeregisterAll();
    sendLogLevelDeregisterAll();
    sendLogTargetDeregisterAll();
    sendNNamesDeregisterAll();
    sendNFailedUnitsDeregisterAll();
    sendNJobsDeregisterAll();
    sendNInstalledJobsDeregisterAll();
    sendNFailedJobsDeregisterAll();
    sendProgressDeregisterAll();
    sendEnvironmentDeregisterAll();
    sendConfirmSpawnDeregisterAll();
    sendShowStatusDeregisterAll();
    sendUnitPathDeregisterAll();
    sendDefaultStandardOutputDeregisterAll();
    sendDefaultStandardErrorDeregisterAll();
    sendRuntimeWatchdogUSecDeregisterAll();
    sendShutdownWatchdogUSecDeregisterAll();
    sendControlGroupDeregisterAll();
    sendSystemStateDeregisterAll();
    sendUnitNewDeregisterAll();
    sendUnitRemovedDeregisterAll();
    sendJobNewDeregisterAll();
    sendJobRemovedDeregisterAll();
    sendStartupFinishedDeregisterAll();
    sendUnitFilesChangedDeregisterAll();
    sendReloadingDeregisterAll();
}

act_t ManagerProxy::sendUnitNewRegister(UnitNewCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "UnitNew");
    act_t act = addSignalCallback(ID_UnitNew, "UnitNew", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UnitNew", &cb, act);
    return act;
}

bool ManagerProxy::sendUnitNewDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UnitNew", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UnitNew", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendUnitNewDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UnitNew");
    _dbusProxyDelegate->deregisterSignalCallback("UnitNew", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendUnitRemovedRegister(UnitRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "UnitRemoved");
    act_t act = addSignalCallback(ID_UnitRemoved, "UnitRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UnitRemoved", &cb, act);
    return act;
}

bool ManagerProxy::sendUnitRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UnitRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UnitRemoved", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendUnitRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UnitRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("UnitRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendJobNewRegister(JobNewCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "JobNew");
    act_t act = addSignalCallback(ID_JobNew, "JobNew", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "JobNew", &cb, act);
    return act;
}

bool ManagerProxy::sendJobNewDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("JobNew", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "JobNew", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendJobNewDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "JobNew");
    _dbusProxyDelegate->deregisterSignalCallback("JobNew", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendJobRemovedRegister(JobRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "JobRemoved");
    act_t act = addSignalCallback(ID_JobRemoved, "JobRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "JobRemoved", &cb, act);
    return act;
}

bool ManagerProxy::sendJobRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("JobRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "JobRemoved", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendJobRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "JobRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("JobRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendStartupFinishedRegister(StartupFinishedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "StartupFinished");
    act_t act = addSignalCallback(ID_StartupFinished, "StartupFinished", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StartupFinished", &cb, act);
    return act;
}

bool ManagerProxy::sendStartupFinishedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StartupFinished", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StartupFinished", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendStartupFinishedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StartupFinished");
    _dbusProxyDelegate->deregisterSignalCallback("StartupFinished", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendUnitFilesChangedRegister(UnitFilesChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "UnitFilesChanged");
    act_t act = addSignalCallback(ID_UnitFilesChanged, "UnitFilesChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UnitFilesChanged", &cb, act);
    return act;
}

bool ManagerProxy::sendUnitFilesChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UnitFilesChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UnitFilesChanged", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendUnitFilesChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UnitFilesChanged");
    _dbusProxyDelegate->deregisterSignalCallback("UnitFilesChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendReloadingRegister(ReloadingCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "Reloading");
    act_t act = addSignalCallback(ID_Reloading, "Reloading", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Reloading", &cb, act);
    return act;
}

bool ManagerProxy::sendReloadingDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Reloading", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Reloading", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendReloadingDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Reloading");
    _dbusProxyDelegate->deregisterSignalCallback("Reloading", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendVersionRegister(VersionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Version, "Version", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Version", &cb, act);
    return act;
}

bool ManagerProxy::sendVersionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Version", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Version", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendVersionGet(VersionCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_Version, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Version", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Version", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ManagerProxy::getVersion() const {
    return _version.get().getVersion();
}

bool ManagerProxy::hasVersion() const {
    return _version.hasValue();
}

void ManagerProxy::sendVersionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Version");
    _dbusProxyDelegate->deregisterSignalCallback("Version", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendFeaturesRegister(FeaturesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Features, "Features", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Features", &cb, act);
    return act;
}

bool ManagerProxy::sendFeaturesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Features", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Features", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendFeaturesGet(FeaturesCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_Features, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Features", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Features", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ManagerProxy::getFeatures() const {
    return _features.get().getFeatures();
}

bool ManagerProxy::hasFeatures() const {
    return _features.hasValue();
}

void ManagerProxy::sendFeaturesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Features");
    _dbusProxyDelegate->deregisterSignalCallback("Features", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendVirtualizationRegister(VirtualizationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Virtualization, "Virtualization", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Virtualization", &cb, act);
    return act;
}

bool ManagerProxy::sendVirtualizationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Virtualization", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Virtualization", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendVirtualizationGet(VirtualizationCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_Virtualization, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Virtualization", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Virtualization", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ManagerProxy::getVirtualization() const {
    return _virtualization.get().getVirtualization();
}

bool ManagerProxy::hasVirtualization() const {
    return _virtualization.hasValue();
}

void ManagerProxy::sendVirtualizationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Virtualization");
    _dbusProxyDelegate->deregisterSignalCallback("Virtualization", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendArchitectureRegister(ArchitectureCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Architecture, "Architecture", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Architecture", &cb, act);
    return act;
}

bool ManagerProxy::sendArchitectureDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Architecture", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Architecture", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendArchitectureGet(ArchitectureCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_Architecture, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Architecture", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Architecture", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ManagerProxy::getArchitecture() const {
    return _architecture.get().getArchitecture();
}

bool ManagerProxy::hasArchitecture() const {
    return _architecture.hasValue();
}

void ManagerProxy::sendArchitectureDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Architecture");
    _dbusProxyDelegate->deregisterSignalCallback("Architecture", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendTaintedRegister(TaintedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Tainted, "Tainted", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Tainted", &cb, act);
    return act;
}

bool ManagerProxy::sendTaintedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Tainted", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Tainted", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendTaintedGet(TaintedCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_Tainted, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Tainted", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Tainted", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ManagerProxy::getTainted() const {
    return _tainted.get().getTainted();
}

bool ManagerProxy::hasTainted() const {
    return _tainted.hasValue();
}

void ManagerProxy::sendTaintedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Tainted");
    _dbusProxyDelegate->deregisterSignalCallback("Tainted", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendFirmwareTimestampRegister(FirmwareTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_FirmwareTimestamp, "FirmwareTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FirmwareTimestamp", &cb, act);
    return act;
}

bool ManagerProxy::sendFirmwareTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FirmwareTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FirmwareTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendFirmwareTimestampGet(FirmwareTimestampCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_FirmwareTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FirmwareTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FirmwareTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getFirmwareTimestamp() const {
    return _firmwareTimestamp.get().getFirmwareTimestamp();
}

bool ManagerProxy::hasFirmwareTimestamp() const {
    return _firmwareTimestamp.hasValue();
}

void ManagerProxy::sendFirmwareTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FirmwareTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("FirmwareTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendFirmwareTimestampMonotonicRegister(FirmwareTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_FirmwareTimestampMonotonic, "FirmwareTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FirmwareTimestampMonotonic", &cb, act);
    return act;
}

bool ManagerProxy::sendFirmwareTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FirmwareTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FirmwareTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendFirmwareTimestampMonotonicGet(FirmwareTimestampMonotonicCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_FirmwareTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FirmwareTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FirmwareTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getFirmwareTimestampMonotonic() const {
    return _firmwareTimestampMonotonic.get().getFirmwareTimestampMonotonic();
}

bool ManagerProxy::hasFirmwareTimestampMonotonic() const {
    return _firmwareTimestampMonotonic.hasValue();
}

void ManagerProxy::sendFirmwareTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FirmwareTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("FirmwareTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendLoaderTimestampRegister(LoaderTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LoaderTimestamp, "LoaderTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LoaderTimestamp", &cb, act);
    return act;
}

bool ManagerProxy::sendLoaderTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LoaderTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LoaderTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendLoaderTimestampGet(LoaderTimestampCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_LoaderTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LoaderTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LoaderTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getLoaderTimestamp() const {
    return _loaderTimestamp.get().getLoaderTimestamp();
}

bool ManagerProxy::hasLoaderTimestamp() const {
    return _loaderTimestamp.hasValue();
}

void ManagerProxy::sendLoaderTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LoaderTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("LoaderTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendLoaderTimestampMonotonicRegister(LoaderTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LoaderTimestampMonotonic, "LoaderTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LoaderTimestampMonotonic", &cb, act);
    return act;
}

bool ManagerProxy::sendLoaderTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LoaderTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LoaderTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendLoaderTimestampMonotonicGet(LoaderTimestampMonotonicCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_LoaderTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LoaderTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LoaderTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getLoaderTimestampMonotonic() const {
    return _loaderTimestampMonotonic.get().getLoaderTimestampMonotonic();
}

bool ManagerProxy::hasLoaderTimestampMonotonic() const {
    return _loaderTimestampMonotonic.hasValue();
}

void ManagerProxy::sendLoaderTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LoaderTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("LoaderTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendKernelTimestampRegister(KernelTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_KernelTimestamp, "KernelTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "KernelTimestamp", &cb, act);
    return act;
}

bool ManagerProxy::sendKernelTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("KernelTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "KernelTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendKernelTimestampGet(KernelTimestampCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_KernelTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "KernelTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("KernelTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getKernelTimestamp() const {
    return _kernelTimestamp.get().getKernelTimestamp();
}

bool ManagerProxy::hasKernelTimestamp() const {
    return _kernelTimestamp.hasValue();
}

void ManagerProxy::sendKernelTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "KernelTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("KernelTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendKernelTimestampMonotonicRegister(KernelTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_KernelTimestampMonotonic, "KernelTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "KernelTimestampMonotonic", &cb, act);
    return act;
}

bool ManagerProxy::sendKernelTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("KernelTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "KernelTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendKernelTimestampMonotonicGet(KernelTimestampMonotonicCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_KernelTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "KernelTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("KernelTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getKernelTimestampMonotonic() const {
    return _kernelTimestampMonotonic.get().getKernelTimestampMonotonic();
}

bool ManagerProxy::hasKernelTimestampMonotonic() const {
    return _kernelTimestampMonotonic.hasValue();
}

void ManagerProxy::sendKernelTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "KernelTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("KernelTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendInitRDTimestampRegister(InitRDTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_InitRDTimestamp, "InitRDTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InitRDTimestamp", &cb, act);
    return act;
}

bool ManagerProxy::sendInitRDTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("InitRDTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InitRDTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendInitRDTimestampGet(InitRDTimestampCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_InitRDTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "InitRDTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("InitRDTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getInitRDTimestamp() const {
    return _initRDTimestamp.get().getInitRDTimestamp();
}

bool ManagerProxy::hasInitRDTimestamp() const {
    return _initRDTimestamp.hasValue();
}

void ManagerProxy::sendInitRDTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InitRDTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("InitRDTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendInitRDTimestampMonotonicRegister(InitRDTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_InitRDTimestampMonotonic, "InitRDTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InitRDTimestampMonotonic", &cb, act);
    return act;
}

bool ManagerProxy::sendInitRDTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("InitRDTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InitRDTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendInitRDTimestampMonotonicGet(InitRDTimestampMonotonicCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_InitRDTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "InitRDTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("InitRDTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getInitRDTimestampMonotonic() const {
    return _initRDTimestampMonotonic.get().getInitRDTimestampMonotonic();
}

bool ManagerProxy::hasInitRDTimestampMonotonic() const {
    return _initRDTimestampMonotonic.hasValue();
}

void ManagerProxy::sendInitRDTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InitRDTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("InitRDTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendUserspaceTimestampRegister(UserspaceTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UserspaceTimestamp, "UserspaceTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UserspaceTimestamp", &cb, act);
    return act;
}

bool ManagerProxy::sendUserspaceTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UserspaceTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UserspaceTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendUserspaceTimestampGet(UserspaceTimestampCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_UserspaceTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UserspaceTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UserspaceTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getUserspaceTimestamp() const {
    return _userspaceTimestamp.get().getUserspaceTimestamp();
}

bool ManagerProxy::hasUserspaceTimestamp() const {
    return _userspaceTimestamp.hasValue();
}

void ManagerProxy::sendUserspaceTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UserspaceTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("UserspaceTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendUserspaceTimestampMonotonicRegister(UserspaceTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UserspaceTimestampMonotonic, "UserspaceTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UserspaceTimestampMonotonic", &cb, act);
    return act;
}

bool ManagerProxy::sendUserspaceTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UserspaceTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UserspaceTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendUserspaceTimestampMonotonicGet(UserspaceTimestampMonotonicCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_UserspaceTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UserspaceTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UserspaceTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getUserspaceTimestampMonotonic() const {
    return _userspaceTimestampMonotonic.get().getUserspaceTimestampMonotonic();
}

bool ManagerProxy::hasUserspaceTimestampMonotonic() const {
    return _userspaceTimestampMonotonic.hasValue();
}

void ManagerProxy::sendUserspaceTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UserspaceTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("UserspaceTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendFinishTimestampRegister(FinishTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_FinishTimestamp, "FinishTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FinishTimestamp", &cb, act);
    return act;
}

bool ManagerProxy::sendFinishTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FinishTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FinishTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendFinishTimestampGet(FinishTimestampCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_FinishTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FinishTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FinishTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getFinishTimestamp() const {
    return _finishTimestamp.get().getFinishTimestamp();
}

bool ManagerProxy::hasFinishTimestamp() const {
    return _finishTimestamp.hasValue();
}

void ManagerProxy::sendFinishTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FinishTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("FinishTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendFinishTimestampMonotonicRegister(FinishTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_FinishTimestampMonotonic, "FinishTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FinishTimestampMonotonic", &cb, act);
    return act;
}

bool ManagerProxy::sendFinishTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FinishTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FinishTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendFinishTimestampMonotonicGet(FinishTimestampMonotonicCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_FinishTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FinishTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FinishTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getFinishTimestampMonotonic() const {
    return _finishTimestampMonotonic.get().getFinishTimestampMonotonic();
}

bool ManagerProxy::hasFinishTimestampMonotonic() const {
    return _finishTimestampMonotonic.hasValue();
}

void ManagerProxy::sendFinishTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FinishTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("FinishTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendSecurityStartTimestampRegister(SecurityStartTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SecurityStartTimestamp, "SecurityStartTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SecurityStartTimestamp", &cb, act);
    return act;
}

bool ManagerProxy::sendSecurityStartTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SecurityStartTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SecurityStartTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendSecurityStartTimestampGet(SecurityStartTimestampCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_SecurityStartTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SecurityStartTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SecurityStartTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getSecurityStartTimestamp() const {
    return _securityStartTimestamp.get().getSecurityStartTimestamp();
}

bool ManagerProxy::hasSecurityStartTimestamp() const {
    return _securityStartTimestamp.hasValue();
}

void ManagerProxy::sendSecurityStartTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SecurityStartTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("SecurityStartTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendSecurityStartTimestampMonotonicRegister(SecurityStartTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SecurityStartTimestampMonotonic, "SecurityStartTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SecurityStartTimestampMonotonic", &cb, act);
    return act;
}

bool ManagerProxy::sendSecurityStartTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SecurityStartTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SecurityStartTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendSecurityStartTimestampMonotonicGet(SecurityStartTimestampMonotonicCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_SecurityStartTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SecurityStartTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SecurityStartTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getSecurityStartTimestampMonotonic() const {
    return _securityStartTimestampMonotonic.get().getSecurityStartTimestampMonotonic();
}

bool ManagerProxy::hasSecurityStartTimestampMonotonic() const {
    return _securityStartTimestampMonotonic.hasValue();
}

void ManagerProxy::sendSecurityStartTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SecurityStartTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("SecurityStartTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendSecurityFinishTimestampRegister(SecurityFinishTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SecurityFinishTimestamp, "SecurityFinishTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SecurityFinishTimestamp", &cb, act);
    return act;
}

bool ManagerProxy::sendSecurityFinishTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SecurityFinishTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SecurityFinishTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendSecurityFinishTimestampGet(SecurityFinishTimestampCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_SecurityFinishTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SecurityFinishTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SecurityFinishTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getSecurityFinishTimestamp() const {
    return _securityFinishTimestamp.get().getSecurityFinishTimestamp();
}

bool ManagerProxy::hasSecurityFinishTimestamp() const {
    return _securityFinishTimestamp.hasValue();
}

void ManagerProxy::sendSecurityFinishTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SecurityFinishTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("SecurityFinishTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendSecurityFinishTimestampMonotonicRegister(SecurityFinishTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SecurityFinishTimestampMonotonic, "SecurityFinishTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SecurityFinishTimestampMonotonic", &cb, act);
    return act;
}

bool ManagerProxy::sendSecurityFinishTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SecurityFinishTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SecurityFinishTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendSecurityFinishTimestampMonotonicGet(SecurityFinishTimestampMonotonicCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_SecurityFinishTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SecurityFinishTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SecurityFinishTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getSecurityFinishTimestampMonotonic() const {
    return _securityFinishTimestampMonotonic.get().getSecurityFinishTimestampMonotonic();
}

bool ManagerProxy::hasSecurityFinishTimestampMonotonic() const {
    return _securityFinishTimestampMonotonic.hasValue();
}

void ManagerProxy::sendSecurityFinishTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SecurityFinishTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("SecurityFinishTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendGeneratorsStartTimestampRegister(GeneratorsStartTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_GeneratorsStartTimestamp, "GeneratorsStartTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "GeneratorsStartTimestamp", &cb, act);
    return act;
}

bool ManagerProxy::sendGeneratorsStartTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("GeneratorsStartTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "GeneratorsStartTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendGeneratorsStartTimestampGet(GeneratorsStartTimestampCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_GeneratorsStartTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "GeneratorsStartTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("GeneratorsStartTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getGeneratorsStartTimestamp() const {
    return _generatorsStartTimestamp.get().getGeneratorsStartTimestamp();
}

bool ManagerProxy::hasGeneratorsStartTimestamp() const {
    return _generatorsStartTimestamp.hasValue();
}

void ManagerProxy::sendGeneratorsStartTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "GeneratorsStartTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("GeneratorsStartTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendGeneratorsStartTimestampMonotonicRegister(GeneratorsStartTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_GeneratorsStartTimestampMonotonic, "GeneratorsStartTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "GeneratorsStartTimestampMonotonic", &cb, act);
    return act;
}

bool ManagerProxy::sendGeneratorsStartTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("GeneratorsStartTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "GeneratorsStartTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendGeneratorsStartTimestampMonotonicGet(GeneratorsStartTimestampMonotonicCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_GeneratorsStartTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "GeneratorsStartTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("GeneratorsStartTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getGeneratorsStartTimestampMonotonic() const {
    return _generatorsStartTimestampMonotonic.get().getGeneratorsStartTimestampMonotonic();
}

bool ManagerProxy::hasGeneratorsStartTimestampMonotonic() const {
    return _generatorsStartTimestampMonotonic.hasValue();
}

void ManagerProxy::sendGeneratorsStartTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "GeneratorsStartTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("GeneratorsStartTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendGeneratorsFinishTimestampRegister(GeneratorsFinishTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_GeneratorsFinishTimestamp, "GeneratorsFinishTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "GeneratorsFinishTimestamp", &cb, act);
    return act;
}

bool ManagerProxy::sendGeneratorsFinishTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("GeneratorsFinishTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "GeneratorsFinishTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendGeneratorsFinishTimestampGet(GeneratorsFinishTimestampCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_GeneratorsFinishTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "GeneratorsFinishTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("GeneratorsFinishTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getGeneratorsFinishTimestamp() const {
    return _generatorsFinishTimestamp.get().getGeneratorsFinishTimestamp();
}

bool ManagerProxy::hasGeneratorsFinishTimestamp() const {
    return _generatorsFinishTimestamp.hasValue();
}

void ManagerProxy::sendGeneratorsFinishTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "GeneratorsFinishTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("GeneratorsFinishTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendGeneratorsFinishTimestampMonotonicRegister(GeneratorsFinishTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_GeneratorsFinishTimestampMonotonic, "GeneratorsFinishTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "GeneratorsFinishTimestampMonotonic", &cb, act);
    return act;
}

bool ManagerProxy::sendGeneratorsFinishTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("GeneratorsFinishTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "GeneratorsFinishTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendGeneratorsFinishTimestampMonotonicGet(GeneratorsFinishTimestampMonotonicCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_GeneratorsFinishTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "GeneratorsFinishTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("GeneratorsFinishTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getGeneratorsFinishTimestampMonotonic() const {
    return _generatorsFinishTimestampMonotonic.get().getGeneratorsFinishTimestampMonotonic();
}

bool ManagerProxy::hasGeneratorsFinishTimestampMonotonic() const {
    return _generatorsFinishTimestampMonotonic.hasValue();
}

void ManagerProxy::sendGeneratorsFinishTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "GeneratorsFinishTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("GeneratorsFinishTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendUnitsLoadStartTimestampRegister(UnitsLoadStartTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UnitsLoadStartTimestamp, "UnitsLoadStartTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UnitsLoadStartTimestamp", &cb, act);
    return act;
}

bool ManagerProxy::sendUnitsLoadStartTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UnitsLoadStartTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UnitsLoadStartTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendUnitsLoadStartTimestampGet(UnitsLoadStartTimestampCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_UnitsLoadStartTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UnitsLoadStartTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UnitsLoadStartTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getUnitsLoadStartTimestamp() const {
    return _unitsLoadStartTimestamp.get().getUnitsLoadStartTimestamp();
}

bool ManagerProxy::hasUnitsLoadStartTimestamp() const {
    return _unitsLoadStartTimestamp.hasValue();
}

void ManagerProxy::sendUnitsLoadStartTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UnitsLoadStartTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("UnitsLoadStartTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendUnitsLoadStartTimestampMonotonicRegister(UnitsLoadStartTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UnitsLoadStartTimestampMonotonic, "UnitsLoadStartTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UnitsLoadStartTimestampMonotonic", &cb, act);
    return act;
}

bool ManagerProxy::sendUnitsLoadStartTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UnitsLoadStartTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UnitsLoadStartTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendUnitsLoadStartTimestampMonotonicGet(UnitsLoadStartTimestampMonotonicCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_UnitsLoadStartTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UnitsLoadStartTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UnitsLoadStartTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getUnitsLoadStartTimestampMonotonic() const {
    return _unitsLoadStartTimestampMonotonic.get().getUnitsLoadStartTimestampMonotonic();
}

bool ManagerProxy::hasUnitsLoadStartTimestampMonotonic() const {
    return _unitsLoadStartTimestampMonotonic.hasValue();
}

void ManagerProxy::sendUnitsLoadStartTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UnitsLoadStartTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("UnitsLoadStartTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendUnitsLoadFinishTimestampRegister(UnitsLoadFinishTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UnitsLoadFinishTimestamp, "UnitsLoadFinishTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UnitsLoadFinishTimestamp", &cb, act);
    return act;
}

bool ManagerProxy::sendUnitsLoadFinishTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UnitsLoadFinishTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UnitsLoadFinishTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendUnitsLoadFinishTimestampGet(UnitsLoadFinishTimestampCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_UnitsLoadFinishTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UnitsLoadFinishTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UnitsLoadFinishTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getUnitsLoadFinishTimestamp() const {
    return _unitsLoadFinishTimestamp.get().getUnitsLoadFinishTimestamp();
}

bool ManagerProxy::hasUnitsLoadFinishTimestamp() const {
    return _unitsLoadFinishTimestamp.hasValue();
}

void ManagerProxy::sendUnitsLoadFinishTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UnitsLoadFinishTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("UnitsLoadFinishTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendUnitsLoadFinishTimestampMonotonicRegister(UnitsLoadFinishTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UnitsLoadFinishTimestampMonotonic, "UnitsLoadFinishTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UnitsLoadFinishTimestampMonotonic", &cb, act);
    return act;
}

bool ManagerProxy::sendUnitsLoadFinishTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UnitsLoadFinishTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UnitsLoadFinishTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendUnitsLoadFinishTimestampMonotonicGet(UnitsLoadFinishTimestampMonotonicCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_UnitsLoadFinishTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UnitsLoadFinishTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UnitsLoadFinishTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ManagerProxy::getUnitsLoadFinishTimestampMonotonic() const {
    return _unitsLoadFinishTimestampMonotonic.get().getUnitsLoadFinishTimestampMonotonic();
}

bool ManagerProxy::hasUnitsLoadFinishTimestampMonotonic() const {
    return _unitsLoadFinishTimestampMonotonic.hasValue();
}

void ManagerProxy::sendUnitsLoadFinishTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UnitsLoadFinishTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("UnitsLoadFinishTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendLogLevelRegister(LogLevelCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LogLevel, "LogLevel", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LogLevel", &cb, act);
    return act;
}

bool ManagerProxy::sendLogLevelDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LogLevel", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LogLevel", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendLogLevelGet(LogLevelCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_LogLevel, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LogLevel", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LogLevel", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ManagerProxy::sendLogLevelSet(const ::std::string& logLevel) {
    LogLevelSet parameter(logLevel);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "LogLevel");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "LogLevel", propertyContent);
}

act_t ManagerProxy::sendLogLevelSet(LogLevelCallbackIF& cb, const ::std::string& logLevel) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_LogLevel, &cb);
    LogLevelSet parameter(logLevel);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "LogLevel", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "LogLevel", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& ManagerProxy::getLogLevel() const {
    return _logLevel.get().getLogLevel();
}

bool ManagerProxy::hasLogLevel() const {
    return _logLevel.hasValue();
}

void ManagerProxy::sendLogLevelDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LogLevel");
    _dbusProxyDelegate->deregisterSignalCallback("LogLevel", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendLogTargetRegister(LogTargetCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LogTarget, "LogTarget", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LogTarget", &cb, act);
    return act;
}

bool ManagerProxy::sendLogTargetDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LogTarget", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LogTarget", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendLogTargetGet(LogTargetCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_LogTarget, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LogTarget", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LogTarget", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ManagerProxy::sendLogTargetSet(const ::std::string& logTarget) {
    LogTargetSet parameter(logTarget);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "LogTarget");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "LogTarget", propertyContent);
}

act_t ManagerProxy::sendLogTargetSet(LogTargetCallbackIF& cb, const ::std::string& logTarget) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_LogTarget, &cb);
    LogTargetSet parameter(logTarget);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "LogTarget", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "LogTarget", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& ManagerProxy::getLogTarget() const {
    return _logTarget.get().getLogTarget();
}

bool ManagerProxy::hasLogTarget() const {
    return _logTarget.hasValue();
}

void ManagerProxy::sendLogTargetDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LogTarget");
    _dbusProxyDelegate->deregisterSignalCallback("LogTarget", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendNNamesRegister(NNamesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_NNames, "NNames", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NNames", &cb, act);
    return act;
}

bool ManagerProxy::sendNNamesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NNames", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NNames", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendNNamesGet(NNamesCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_NNames, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NNames", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("NNames", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ManagerProxy::getNNames() const {
    return _nNames.get().getNNames();
}

bool ManagerProxy::hasNNames() const {
    return _nNames.hasValue();
}

void ManagerProxy::sendNNamesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NNames");
    _dbusProxyDelegate->deregisterSignalCallback("NNames", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendNFailedUnitsRegister(NFailedUnitsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_NFailedUnits, "NFailedUnits", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NFailedUnits", &cb, act);
    return act;
}

bool ManagerProxy::sendNFailedUnitsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NFailedUnits", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NFailedUnits", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendNFailedUnitsGet(NFailedUnitsCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_NFailedUnits, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NFailedUnits", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("NFailedUnits", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ManagerProxy::getNFailedUnits() const {
    return _nFailedUnits.get().getNFailedUnits();
}

bool ManagerProxy::hasNFailedUnits() const {
    return _nFailedUnits.hasValue();
}

void ManagerProxy::sendNFailedUnitsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NFailedUnits");
    _dbusProxyDelegate->deregisterSignalCallback("NFailedUnits", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendNJobsRegister(NJobsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_NJobs, "NJobs", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NJobs", &cb, act);
    return act;
}

bool ManagerProxy::sendNJobsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NJobs", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NJobs", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendNJobsGet(NJobsCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_NJobs, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NJobs", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("NJobs", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ManagerProxy::getNJobs() const {
    return _nJobs.get().getNJobs();
}

bool ManagerProxy::hasNJobs() const {
    return _nJobs.hasValue();
}

void ManagerProxy::sendNJobsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NJobs");
    _dbusProxyDelegate->deregisterSignalCallback("NJobs", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendNInstalledJobsRegister(NInstalledJobsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_NInstalledJobs, "NInstalledJobs", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NInstalledJobs", &cb, act);
    return act;
}

bool ManagerProxy::sendNInstalledJobsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NInstalledJobs", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NInstalledJobs", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendNInstalledJobsGet(NInstalledJobsCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_NInstalledJobs, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NInstalledJobs", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("NInstalledJobs", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ManagerProxy::getNInstalledJobs() const {
    return _nInstalledJobs.get().getNInstalledJobs();
}

bool ManagerProxy::hasNInstalledJobs() const {
    return _nInstalledJobs.hasValue();
}

void ManagerProxy::sendNInstalledJobsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NInstalledJobs");
    _dbusProxyDelegate->deregisterSignalCallback("NInstalledJobs", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendNFailedJobsRegister(NFailedJobsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_NFailedJobs, "NFailedJobs", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NFailedJobs", &cb, act);
    return act;
}

bool ManagerProxy::sendNFailedJobsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NFailedJobs", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NFailedJobs", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendNFailedJobsGet(NFailedJobsCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_NFailedJobs, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NFailedJobs", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("NFailedJobs", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ManagerProxy::getNFailedJobs() const {
    return _nFailedJobs.get().getNFailedJobs();
}

bool ManagerProxy::hasNFailedJobs() const {
    return _nFailedJobs.hasValue();
}

void ManagerProxy::sendNFailedJobsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NFailedJobs");
    _dbusProxyDelegate->deregisterSignalCallback("NFailedJobs", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendProgressRegister(ProgressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Progress, "Progress", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Progress", &cb, act);
    return act;
}

bool ManagerProxy::sendProgressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Progress", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Progress", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendProgressGet(ProgressCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_Progress, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Progress", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Progress", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


double ManagerProxy::getProgress() const {
    return _progress.get().getProgress();
}

bool ManagerProxy::hasProgress() const {
    return _progress.hasValue();
}

void ManagerProxy::sendProgressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Progress");
    _dbusProxyDelegate->deregisterSignalCallback("Progress", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendEnvironmentRegister(EnvironmentCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Environment, "Environment", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Environment", &cb, act);
    return act;
}

bool ManagerProxy::sendEnvironmentDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Environment", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Environment", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendEnvironmentGet(EnvironmentCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_Environment, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Environment", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Environment", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& ManagerProxy::getEnvironment() const {
    return _environment.get().getEnvironment();
}

bool ManagerProxy::hasEnvironment() const {
    return _environment.hasValue();
}

void ManagerProxy::sendEnvironmentDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Environment");
    _dbusProxyDelegate->deregisterSignalCallback("Environment", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendConfirmSpawnRegister(ConfirmSpawnCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ConfirmSpawn, "ConfirmSpawn", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ConfirmSpawn", &cb, act);
    return act;
}

bool ManagerProxy::sendConfirmSpawnDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ConfirmSpawn", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ConfirmSpawn", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendConfirmSpawnGet(ConfirmSpawnCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_ConfirmSpawn, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ConfirmSpawn", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ConfirmSpawn", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ManagerProxy::getConfirmSpawn() const {
    return _confirmSpawn.get().getConfirmSpawn();
}

bool ManagerProxy::hasConfirmSpawn() const {
    return _confirmSpawn.hasValue();
}

void ManagerProxy::sendConfirmSpawnDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ConfirmSpawn");
    _dbusProxyDelegate->deregisterSignalCallback("ConfirmSpawn", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendShowStatusRegister(ShowStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ShowStatus, "ShowStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ShowStatus", &cb, act);
    return act;
}

bool ManagerProxy::sendShowStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ShowStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ShowStatus", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendShowStatusGet(ShowStatusCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_ShowStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ShowStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ShowStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ManagerProxy::getShowStatus() const {
    return _showStatus.get().getShowStatus();
}

bool ManagerProxy::hasShowStatus() const {
    return _showStatus.hasValue();
}

void ManagerProxy::sendShowStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ShowStatus");
    _dbusProxyDelegate->deregisterSignalCallback("ShowStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendUnitPathRegister(UnitPathCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UnitPath, "UnitPath", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UnitPath", &cb, act);
    return act;
}

bool ManagerProxy::sendUnitPathDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UnitPath", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UnitPath", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendUnitPathGet(UnitPathCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_UnitPath, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UnitPath", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UnitPath", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& ManagerProxy::getUnitPath() const {
    return _unitPath.get().getUnitPath();
}

bool ManagerProxy::hasUnitPath() const {
    return _unitPath.hasValue();
}

void ManagerProxy::sendUnitPathDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UnitPath");
    _dbusProxyDelegate->deregisterSignalCallback("UnitPath", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendDefaultStandardOutputRegister(DefaultStandardOutputCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DefaultStandardOutput, "DefaultStandardOutput", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DefaultStandardOutput", &cb, act);
    return act;
}

bool ManagerProxy::sendDefaultStandardOutputDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DefaultStandardOutput", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DefaultStandardOutput", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendDefaultStandardOutputGet(DefaultStandardOutputCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_DefaultStandardOutput, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DefaultStandardOutput", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DefaultStandardOutput", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ManagerProxy::getDefaultStandardOutput() const {
    return _defaultStandardOutput.get().getDefaultStandardOutput();
}

bool ManagerProxy::hasDefaultStandardOutput() const {
    return _defaultStandardOutput.hasValue();
}

void ManagerProxy::sendDefaultStandardOutputDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DefaultStandardOutput");
    _dbusProxyDelegate->deregisterSignalCallback("DefaultStandardOutput", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendDefaultStandardErrorRegister(DefaultStandardErrorCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DefaultStandardError, "DefaultStandardError", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DefaultStandardError", &cb, act);
    return act;
}

bool ManagerProxy::sendDefaultStandardErrorDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DefaultStandardError", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DefaultStandardError", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendDefaultStandardErrorGet(DefaultStandardErrorCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_DefaultStandardError, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DefaultStandardError", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DefaultStandardError", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ManagerProxy::getDefaultStandardError() const {
    return _defaultStandardError.get().getDefaultStandardError();
}

bool ManagerProxy::hasDefaultStandardError() const {
    return _defaultStandardError.hasValue();
}

void ManagerProxy::sendDefaultStandardErrorDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DefaultStandardError");
    _dbusProxyDelegate->deregisterSignalCallback("DefaultStandardError", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendRuntimeWatchdogUSecRegister(RuntimeWatchdogUSecCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RuntimeWatchdogUSec, "RuntimeWatchdogUSec", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RuntimeWatchdogUSec", &cb, act);
    return act;
}

bool ManagerProxy::sendRuntimeWatchdogUSecDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RuntimeWatchdogUSec", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RuntimeWatchdogUSec", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendRuntimeWatchdogUSecGet(RuntimeWatchdogUSecCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_RuntimeWatchdogUSec, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RuntimeWatchdogUSec", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RuntimeWatchdogUSec", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ManagerProxy::sendRuntimeWatchdogUSecSet(uint64 runtimeWatchdogUSec) {
    RuntimeWatchdogUSecSet parameter(runtimeWatchdogUSec);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "RuntimeWatchdogUSec");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "RuntimeWatchdogUSec", propertyContent);
}

act_t ManagerProxy::sendRuntimeWatchdogUSecSet(RuntimeWatchdogUSecCallbackIF& cb, uint64 runtimeWatchdogUSec) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_RuntimeWatchdogUSec, &cb);
    RuntimeWatchdogUSecSet parameter(runtimeWatchdogUSec);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "RuntimeWatchdogUSec", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "RuntimeWatchdogUSec", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint64 ManagerProxy::getRuntimeWatchdogUSec() const {
    return _runtimeWatchdogUSec.get().getRuntimeWatchdogUSec();
}

bool ManagerProxy::hasRuntimeWatchdogUSec() const {
    return _runtimeWatchdogUSec.hasValue();
}

void ManagerProxy::sendRuntimeWatchdogUSecDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RuntimeWatchdogUSec");
    _dbusProxyDelegate->deregisterSignalCallback("RuntimeWatchdogUSec", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendShutdownWatchdogUSecRegister(ShutdownWatchdogUSecCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ShutdownWatchdogUSec, "ShutdownWatchdogUSec", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ShutdownWatchdogUSec", &cb, act);
    return act;
}

bool ManagerProxy::sendShutdownWatchdogUSecDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ShutdownWatchdogUSec", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ShutdownWatchdogUSec", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendShutdownWatchdogUSecGet(ShutdownWatchdogUSecCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_ShutdownWatchdogUSec, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ShutdownWatchdogUSec", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ShutdownWatchdogUSec", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ManagerProxy::sendShutdownWatchdogUSecSet(uint64 shutdownWatchdogUSec) {
    ShutdownWatchdogUSecSet parameter(shutdownWatchdogUSec);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "ShutdownWatchdogUSec");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ShutdownWatchdogUSec", propertyContent);
}

act_t ManagerProxy::sendShutdownWatchdogUSecSet(ShutdownWatchdogUSecCallbackIF& cb, uint64 shutdownWatchdogUSec) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_ShutdownWatchdogUSec, &cb);
    ShutdownWatchdogUSecSet parameter(shutdownWatchdogUSec);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "ShutdownWatchdogUSec", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ShutdownWatchdogUSec", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint64 ManagerProxy::getShutdownWatchdogUSec() const {
    return _shutdownWatchdogUSec.get().getShutdownWatchdogUSec();
}

bool ManagerProxy::hasShutdownWatchdogUSec() const {
    return _shutdownWatchdogUSec.hasValue();
}

void ManagerProxy::sendShutdownWatchdogUSecDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ShutdownWatchdogUSec");
    _dbusProxyDelegate->deregisterSignalCallback("ShutdownWatchdogUSec", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendControlGroupRegister(ControlGroupCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ControlGroup, "ControlGroup", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ControlGroup", &cb, act);
    return act;
}

bool ManagerProxy::sendControlGroupDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ControlGroup", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ControlGroup", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendControlGroupGet(ControlGroupCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_ControlGroup, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ControlGroup", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ControlGroup", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ManagerProxy::sendControlGroupSet(const ::std::string& controlGroup) {
    ControlGroupSet parameter(controlGroup);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "ControlGroup");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ControlGroup", propertyContent);
}

act_t ManagerProxy::sendControlGroupSet(ControlGroupCallbackIF& cb, const ::std::string& controlGroup) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_ControlGroup, &cb);
    ControlGroupSet parameter(controlGroup);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "ControlGroup", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ControlGroup", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& ManagerProxy::getControlGroup() const {
    return _controlGroup.get().getControlGroup();
}

bool ManagerProxy::hasControlGroup() const {
    return _controlGroup.hasValue();
}

void ManagerProxy::sendControlGroupDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ControlGroup");
    _dbusProxyDelegate->deregisterSignalCallback("ControlGroup", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendSystemStateRegister(SystemStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SystemState, "SystemState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SystemState", &cb, act);
    return act;
}

bool ManagerProxy::sendSystemStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SystemState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SystemState", act, static_cast<int>(rv));
    return rv;
}

act_t ManagerProxy::sendSystemStateGet(SystemStateCallbackIF& cb) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_SystemState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SystemState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SystemState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ManagerProxy::sendSystemStateSet(const ::std::string& systemState) {
    SystemStateSet parameter(systemState);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "SystemState");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "SystemState", propertyContent);
}

act_t ManagerProxy::sendSystemStateSet(SystemStateCallbackIF& cb, const ::std::string& systemState) {
    ManagerProxyCallback* callback = new ManagerProxyCallback(ID_SystemState, &cb);
    SystemStateSet parameter(systemState);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "SystemState", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "SystemState", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& ManagerProxy::getSystemState() const {
    return _systemState.get().getSystemState();
}

bool ManagerProxy::hasSystemState() const {
    return _systemState.hasValue();
}

void ManagerProxy::sendSystemStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SystemState");
    _dbusProxyDelegate->deregisterSignalCallback("SystemState", 0, _dbusDaemonProxy.get(), true);
}

act_t ManagerProxy::sendGetUnitRequest(GetUnitCallbackIF& cb, const ::std::string& name) const {
    GetUnitRequest* payload = new GetUnitRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    DBUS_MESSAGE_CALL(dbusMessage, "GetUnit", GetUnitRequest, payload, true)
    act_t act = addMethodCallback(ID_GetUnit, dbusMessage.getUniqueSerial(), "GetUnit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetUnit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendGetUnitByPIDRequest(GetUnitByPIDCallbackIF& cb, uint32 pid) const {
    GetUnitByPIDRequest* payload = new GetUnitByPIDRequest();
    CHECK_ALLOCATION(payload);
    payload->setPid(pid);
    DBUS_MESSAGE_CALL(dbusMessage, "GetUnitByPID", GetUnitByPIDRequest, payload, true)
    act_t act = addMethodCallback(ID_GetUnitByPID, dbusMessage.getUniqueSerial(), "GetUnitByPID", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetUnitByPID", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendLoadUnitRequest(LoadUnitCallbackIF& cb, const ::std::string& name) const {
    LoadUnitRequest* payload = new LoadUnitRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    DBUS_MESSAGE_CALL(dbusMessage, "LoadUnit", LoadUnitRequest, payload, true)
    act_t act = addMethodCallback(ID_LoadUnit, dbusMessage.getUniqueSerial(), "LoadUnit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "LoadUnit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendStartUnitRequest(StartUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const {
    StartUnitRequest* payload = new StartUnitRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "StartUnit", StartUnitRequest, payload, true)
    act_t act = addMethodCallback(ID_StartUnit, dbusMessage.getUniqueSerial(), "StartUnit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartUnit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendStartUnitReplaceRequest(StartUnitReplaceCallbackIF& cb, const ::std::string& old_unit, const ::std::string& new_unit, const ::std::string& mode) const {
    StartUnitReplaceRequest* payload = new StartUnitReplaceRequest();
    CHECK_ALLOCATION(payload);
    payload->setOld_unit(old_unit);
    payload->setNew_unit(new_unit);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "StartUnitReplace", StartUnitReplaceRequest, payload, true)
    act_t act = addMethodCallback(ID_StartUnitReplace, dbusMessage.getUniqueSerial(), "StartUnitReplace", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartUnitReplace", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendStopUnitRequest(StopUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const {
    StopUnitRequest* payload = new StopUnitRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "StopUnit", StopUnitRequest, payload, true)
    act_t act = addMethodCallback(ID_StopUnit, dbusMessage.getUniqueSerial(), "StopUnit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StopUnit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendReloadUnitRequest(ReloadUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const {
    ReloadUnitRequest* payload = new ReloadUnitRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "ReloadUnit", ReloadUnitRequest, payload, true)
    act_t act = addMethodCallback(ID_ReloadUnit, dbusMessage.getUniqueSerial(), "ReloadUnit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReloadUnit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendRestartUnitRequest(RestartUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const {
    RestartUnitRequest* payload = new RestartUnitRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "RestartUnit", RestartUnitRequest, payload, true)
    act_t act = addMethodCallback(ID_RestartUnit, dbusMessage.getUniqueSerial(), "RestartUnit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RestartUnit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendTryRestartUnitRequest(TryRestartUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const {
    TryRestartUnitRequest* payload = new TryRestartUnitRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "TryRestartUnit", TryRestartUnitRequest, payload, true)
    act_t act = addMethodCallback(ID_TryRestartUnit, dbusMessage.getUniqueSerial(), "TryRestartUnit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "TryRestartUnit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendReloadOrRestartUnitRequest(ReloadOrRestartUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const {
    ReloadOrRestartUnitRequest* payload = new ReloadOrRestartUnitRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "ReloadOrRestartUnit", ReloadOrRestartUnitRequest, payload, true)
    act_t act = addMethodCallback(ID_ReloadOrRestartUnit, dbusMessage.getUniqueSerial(), "ReloadOrRestartUnit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReloadOrRestartUnit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendReloadOrTryRestartUnitRequest(ReloadOrTryRestartUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const {
    ReloadOrTryRestartUnitRequest* payload = new ReloadOrTryRestartUnitRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "ReloadOrTryRestartUnit", ReloadOrTryRestartUnitRequest, payload, true)
    act_t act = addMethodCallback(ID_ReloadOrTryRestartUnit, dbusMessage.getUniqueSerial(), "ReloadOrTryRestartUnit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReloadOrTryRestartUnit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendKillUnitRequest(KillUnitCallbackIF& cb, const ::std::string& name, const ::std::string& who, int32 signal) const {
    KillUnitRequest* payload = new KillUnitRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setWho(who);
    payload->setSignal(signal);
    DBUS_MESSAGE_CALL(dbusMessage, "KillUnit", KillUnitRequest, payload, true)
    act_t act = addMethodCallback(ID_KillUnit, dbusMessage.getUniqueSerial(), "KillUnit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "KillUnit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendResetFailedUnitRequest(ResetFailedUnitCallbackIF& cb, const ::std::string& name) const {
    ResetFailedUnitRequest* payload = new ResetFailedUnitRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    DBUS_MESSAGE_CALL(dbusMessage, "ResetFailedUnit", ResetFailedUnitRequest, payload, true)
    act_t act = addMethodCallback(ID_ResetFailedUnit, dbusMessage.getUniqueSerial(), "ResetFailedUnit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ResetFailedUnit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendSetUnitPropertiesRequest(SetUnitPropertiesCallbackIF& cb, const ::std::string& name, bool runtime, const ::std::vector< property >& properties) const {
    SetUnitPropertiesRequest* payload = new SetUnitPropertiesRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setRuntime(runtime);
    payload->setProperties(properties);
    DBUS_MESSAGE_CALL(dbusMessage, "SetUnitProperties", SetUnitPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_SetUnitProperties, dbusMessage.getUniqueSerial(), "SetUnitProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetUnitProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendStartTransientUnitRequest(StartTransientUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode, const ::std::vector< property >& properties, const ::std::vector< transientunitdata >& transientunitdata) const {
    StartTransientUnitRequest* payload = new StartTransientUnitRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setMode(mode);
    payload->setProperties(properties);
    payload->setTransientunitdata(transientunitdata);
    DBUS_MESSAGE_CALL(dbusMessage, "StartTransientUnit", StartTransientUnitRequest, payload, true)
    act_t act = addMethodCallback(ID_StartTransientUnit, dbusMessage.getUniqueSerial(), "StartTransientUnit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartTransientUnit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendGetJobRequest(GetJobCallbackIF& cb, uint32 id) const {
    GetJobRequest* payload = new GetJobRequest();
    CHECK_ALLOCATION(payload);
    payload->setId(id);
    DBUS_MESSAGE_CALL(dbusMessage, "GetJob", GetJobRequest, payload, true)
    act_t act = addMethodCallback(ID_GetJob, dbusMessage.getUniqueSerial(), "GetJob", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetJob", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendCancelJobRequest(CancelJobCallbackIF& cb, uint32 id) const {
    CancelJobRequest* payload = new CancelJobRequest();
    CHECK_ALLOCATION(payload);
    payload->setId(id);
    DBUS_MESSAGE_CALL(dbusMessage, "CancelJob", CancelJobRequest, payload, true)
    act_t act = addMethodCallback(ID_CancelJob, dbusMessage.getUniqueSerial(), "CancelJob", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CancelJob", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendClearJobsRequest(ClearJobsCallbackIF& cb) const {
    ClearJobsRequest* payload = new ClearJobsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ClearJobs", ClearJobsRequest, payload, true)
    act_t act = addMethodCallback(ID_ClearJobs, dbusMessage.getUniqueSerial(), "ClearJobs", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ClearJobs", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendResetFailedRequest(ResetFailedCallbackIF& cb) const {
    ResetFailedRequest* payload = new ResetFailedRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ResetFailed", ResetFailedRequest, payload, true)
    act_t act = addMethodCallback(ID_ResetFailed, dbusMessage.getUniqueSerial(), "ResetFailed", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ResetFailed", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendListUnitsRequest(ListUnitsCallbackIF& cb) const {
    ListUnitsRequest* payload = new ListUnitsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ListUnits", ListUnitsRequest, payload, true)
    act_t act = addMethodCallback(ID_ListUnits, dbusMessage.getUniqueSerial(), "ListUnits", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ListUnits", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendListUnitsFilteredRequest(ListUnitsFilteredCallbackIF& cb, const ::std::vector< ::std::string >& unitList) const {
    ListUnitsFilteredRequest* payload = new ListUnitsFilteredRequest();
    CHECK_ALLOCATION(payload);
    payload->setUnitList(unitList);
    DBUS_MESSAGE_CALL(dbusMessage, "ListUnitsFiltered", ListUnitsFilteredRequest, payload, true)
    act_t act = addMethodCallback(ID_ListUnitsFiltered, dbusMessage.getUniqueSerial(), "ListUnitsFiltered", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ListUnitsFiltered", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendListJobsRequest(ListJobsCallbackIF& cb) const {
    ListJobsRequest* payload = new ListJobsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ListJobs", ListJobsRequest, payload, true)
    act_t act = addMethodCallback(ID_ListJobs, dbusMessage.getUniqueSerial(), "ListJobs", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ListJobs", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendSubscribeRequest(SubscribeCallbackIF& cb) const {
    SubscribeRequest* payload = new SubscribeRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Subscribe", SubscribeRequest, payload, true)
    act_t act = addMethodCallback(ID_Subscribe, dbusMessage.getUniqueSerial(), "Subscribe", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Subscribe", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendUnsubscribeRequest(UnsubscribeCallbackIF& cb) const {
    UnsubscribeRequest* payload = new UnsubscribeRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Unsubscribe", UnsubscribeRequest, payload, true)
    act_t act = addMethodCallback(ID_Unsubscribe, dbusMessage.getUniqueSerial(), "Unsubscribe", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Unsubscribe", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendDumpRequest(DumpCallbackIF& cb) const {
    DumpRequest* payload = new DumpRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Dump", DumpRequest, payload, true)
    act_t act = addMethodCallback(ID_Dump, dbusMessage.getUniqueSerial(), "Dump", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Dump", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendCreateSnapshotRequest(CreateSnapshotCallbackIF& cb, const ::std::string& name, bool cleanup) const {
    CreateSnapshotRequest* payload = new CreateSnapshotRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setCleanup(cleanup);
    DBUS_MESSAGE_CALL(dbusMessage, "CreateSnapshot", CreateSnapshotRequest, payload, true)
    act_t act = addMethodCallback(ID_CreateSnapshot, dbusMessage.getUniqueSerial(), "CreateSnapshot", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CreateSnapshot", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendRemoveSnapshotRequest(RemoveSnapshotCallbackIF& cb, const ::std::string& name) const {
    RemoveSnapshotRequest* payload = new RemoveSnapshotRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    DBUS_MESSAGE_CALL(dbusMessage, "RemoveSnapshot", RemoveSnapshotRequest, payload, true)
    act_t act = addMethodCallback(ID_RemoveSnapshot, dbusMessage.getUniqueSerial(), "RemoveSnapshot", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RemoveSnapshot", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendReloadRequest(ReloadCallbackIF& cb) const {
    ReloadRequest* payload = new ReloadRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Reload", ReloadRequest, payload, true)
    act_t act = addMethodCallback(ID_Reload, dbusMessage.getUniqueSerial(), "Reload", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Reload", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendReexecuteRequest(ReexecuteCallbackIF& cb) const {
    ReexecuteRequest* payload = new ReexecuteRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Reexecute", ReexecuteRequest, payload, true)
    act_t act = addMethodCallback(ID_Reexecute, dbusMessage.getUniqueSerial(), "Reexecute", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Reexecute", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendExitRequest(ExitCallbackIF& cb) const {
    ExitRequest* payload = new ExitRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Exit", ExitRequest, payload, true)
    act_t act = addMethodCallback(ID_Exit, dbusMessage.getUniqueSerial(), "Exit", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Exit", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendRebootRequest(RebootCallbackIF& cb) const {
    RebootRequest* payload = new RebootRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Reboot", RebootRequest, payload, true)
    act_t act = addMethodCallback(ID_Reboot, dbusMessage.getUniqueSerial(), "Reboot", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Reboot", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendPowerOffRequest(PowerOffCallbackIF& cb) const {
    PowerOffRequest* payload = new PowerOffRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "PowerOff", PowerOffRequest, payload, true)
    act_t act = addMethodCallback(ID_PowerOff, dbusMessage.getUniqueSerial(), "PowerOff", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PowerOff", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendHaltRequest(HaltCallbackIF& cb) const {
    HaltRequest* payload = new HaltRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Halt", HaltRequest, payload, true)
    act_t act = addMethodCallback(ID_Halt, dbusMessage.getUniqueSerial(), "Halt", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Halt", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendKExecRequest(KExecCallbackIF& cb) const {
    KExecRequest* payload = new KExecRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "KExec", KExecRequest, payload, true)
    act_t act = addMethodCallback(ID_KExec, dbusMessage.getUniqueSerial(), "KExec", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "KExec", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendSwitchRootRequest(SwitchRootCallbackIF& cb, const ::std::string& new_root, const ::std::string& init) const {
    SwitchRootRequest* payload = new SwitchRootRequest();
    CHECK_ALLOCATION(payload);
    payload->setNew_root(new_root);
    payload->setInit(init);
    DBUS_MESSAGE_CALL(dbusMessage, "SwitchRoot", SwitchRootRequest, payload, true)
    act_t act = addMethodCallback(ID_SwitchRoot, dbusMessage.getUniqueSerial(), "SwitchRoot", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SwitchRoot", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendSetEnvironmentRequest(SetEnvironmentCallbackIF& cb, const ::std::vector< ::std::string >& names) const {
    SetEnvironmentRequest* payload = new SetEnvironmentRequest();
    CHECK_ALLOCATION(payload);
    payload->setNames(names);
    DBUS_MESSAGE_CALL(dbusMessage, "SetEnvironment", SetEnvironmentRequest, payload, true)
    act_t act = addMethodCallback(ID_SetEnvironment, dbusMessage.getUniqueSerial(), "SetEnvironment", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetEnvironment", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendUnsetEnvironmentRequest(UnsetEnvironmentCallbackIF& cb, const ::std::vector< ::std::string >& names) const {
    UnsetEnvironmentRequest* payload = new UnsetEnvironmentRequest();
    CHECK_ALLOCATION(payload);
    payload->setNames(names);
    DBUS_MESSAGE_CALL(dbusMessage, "UnsetEnvironment", UnsetEnvironmentRequest, payload, true)
    act_t act = addMethodCallback(ID_UnsetEnvironment, dbusMessage.getUniqueSerial(), "UnsetEnvironment", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UnsetEnvironment", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendUnsetAndSetEnvironmentRequest(UnsetAndSetEnvironmentCallbackIF& cb, const ::std::vector< ::std::string >& unset, const ::std::vector< ::std::string >& set) const {
    UnsetAndSetEnvironmentRequest* payload = new UnsetAndSetEnvironmentRequest();
    CHECK_ALLOCATION(payload);
    payload->setUnset(unset);
    payload->setSet(set);
    DBUS_MESSAGE_CALL(dbusMessage, "UnsetAndSetEnvironment", UnsetAndSetEnvironmentRequest, payload, true)
    act_t act = addMethodCallback(ID_UnsetAndSetEnvironment, dbusMessage.getUniqueSerial(), "UnsetAndSetEnvironment", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UnsetAndSetEnvironment", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendListUnitFilesRequest(ListUnitFilesCallbackIF& cb) const {
    ListUnitFilesRequest* payload = new ListUnitFilesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ListUnitFiles", ListUnitFilesRequest, payload, true)
    act_t act = addMethodCallback(ID_ListUnitFiles, dbusMessage.getUniqueSerial(), "ListUnitFiles", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ListUnitFiles", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendGetUnitFileStateRequest(GetUnitFileStateCallbackIF& cb, const ::std::string& file) const {
    GetUnitFileStateRequest* payload = new GetUnitFileStateRequest();
    CHECK_ALLOCATION(payload);
    payload->setFile(file);
    DBUS_MESSAGE_CALL(dbusMessage, "GetUnitFileState", GetUnitFileStateRequest, payload, true)
    act_t act = addMethodCallback(ID_GetUnitFileState, dbusMessage.getUniqueSerial(), "GetUnitFileState", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetUnitFileState", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendEnableUnitFilesRequest(EnableUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime, bool force) const {
    EnableUnitFilesRequest* payload = new EnableUnitFilesRequest();
    CHECK_ALLOCATION(payload);
    payload->setFiles(files);
    payload->setRuntime(runtime);
    payload->setForce(force);
    DBUS_MESSAGE_CALL(dbusMessage, "EnableUnitFiles", EnableUnitFilesRequest, payload, true)
    act_t act = addMethodCallback(ID_EnableUnitFiles, dbusMessage.getUniqueSerial(), "EnableUnitFiles", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EnableUnitFiles", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendDisableUnitFilesRequest(DisableUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime) const {
    DisableUnitFilesRequest* payload = new DisableUnitFilesRequest();
    CHECK_ALLOCATION(payload);
    payload->setFiles(files);
    payload->setRuntime(runtime);
    DBUS_MESSAGE_CALL(dbusMessage, "DisableUnitFiles", DisableUnitFilesRequest, payload, true)
    act_t act = addMethodCallback(ID_DisableUnitFiles, dbusMessage.getUniqueSerial(), "DisableUnitFiles", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DisableUnitFiles", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendReenableUnitFilesRequest(ReenableUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime, bool force) const {
    ReenableUnitFilesRequest* payload = new ReenableUnitFilesRequest();
    CHECK_ALLOCATION(payload);
    payload->setFiles(files);
    payload->setRuntime(runtime);
    payload->setForce(force);
    DBUS_MESSAGE_CALL(dbusMessage, "ReenableUnitFiles", ReenableUnitFilesRequest, payload, true)
    act_t act = addMethodCallback(ID_ReenableUnitFiles, dbusMessage.getUniqueSerial(), "ReenableUnitFiles", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReenableUnitFiles", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendLinkUnitFilesRequest(LinkUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime, bool force) const {
    LinkUnitFilesRequest* payload = new LinkUnitFilesRequest();
    CHECK_ALLOCATION(payload);
    payload->setFiles(files);
    payload->setRuntime(runtime);
    payload->setForce(force);
    DBUS_MESSAGE_CALL(dbusMessage, "LinkUnitFiles", LinkUnitFilesRequest, payload, true)
    act_t act = addMethodCallback(ID_LinkUnitFiles, dbusMessage.getUniqueSerial(), "LinkUnitFiles", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "LinkUnitFiles", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendPresetUnitFilesRequest(PresetUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime, bool force) const {
    PresetUnitFilesRequest* payload = new PresetUnitFilesRequest();
    CHECK_ALLOCATION(payload);
    payload->setFiles(files);
    payload->setRuntime(runtime);
    payload->setForce(force);
    DBUS_MESSAGE_CALL(dbusMessage, "PresetUnitFiles", PresetUnitFilesRequest, payload, true)
    act_t act = addMethodCallback(ID_PresetUnitFiles, dbusMessage.getUniqueSerial(), "PresetUnitFiles", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PresetUnitFiles", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendPresetUnitFilesWithModeRequest(PresetUnitFilesWithModeCallbackIF& cb, const ::std::vector< ::std::string >& files, const ::std::string& mode, bool runtime, bool force) const {
    PresetUnitFilesWithModeRequest* payload = new PresetUnitFilesWithModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setFiles(files);
    payload->setMode(mode);
    payload->setRuntime(runtime);
    payload->setForce(force);
    DBUS_MESSAGE_CALL(dbusMessage, "PresetUnitFilesWithMode", PresetUnitFilesWithModeRequest, payload, true)
    act_t act = addMethodCallback(ID_PresetUnitFilesWithMode, dbusMessage.getUniqueSerial(), "PresetUnitFilesWithMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PresetUnitFilesWithMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendMaskUnitFilesRequest(MaskUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime, bool force) const {
    MaskUnitFilesRequest* payload = new MaskUnitFilesRequest();
    CHECK_ALLOCATION(payload);
    payload->setFiles(files);
    payload->setRuntime(runtime);
    payload->setForce(force);
    DBUS_MESSAGE_CALL(dbusMessage, "MaskUnitFiles", MaskUnitFilesRequest, payload, true)
    act_t act = addMethodCallback(ID_MaskUnitFiles, dbusMessage.getUniqueSerial(), "MaskUnitFiles", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "MaskUnitFiles", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendUnmaskUnitFilesRequest(UnmaskUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime) const {
    UnmaskUnitFilesRequest* payload = new UnmaskUnitFilesRequest();
    CHECK_ALLOCATION(payload);
    payload->setFiles(files);
    payload->setRuntime(runtime);
    DBUS_MESSAGE_CALL(dbusMessage, "UnmaskUnitFiles", UnmaskUnitFilesRequest, payload, true)
    act_t act = addMethodCallback(ID_UnmaskUnitFiles, dbusMessage.getUniqueSerial(), "UnmaskUnitFiles", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UnmaskUnitFiles", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendSetDefaultTargetRequest(SetDefaultTargetCallbackIF& cb, const ::std::string& arg_0, bool arg_1) const {
    SetDefaultTargetRequest* payload = new SetDefaultTargetRequest();
    CHECK_ALLOCATION(payload);
    payload->setArg_0(arg_0);
    payload->setArg_1(arg_1);
    DBUS_MESSAGE_CALL(dbusMessage, "SetDefaultTarget", SetDefaultTargetRequest, payload, true)
    act_t act = addMethodCallback(ID_SetDefaultTarget, dbusMessage.getUniqueSerial(), "SetDefaultTarget", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetDefaultTarget", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendGetDefaultTargetRequest(GetDefaultTargetCallbackIF& cb) const {
    GetDefaultTargetRequest* payload = new GetDefaultTargetRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetDefaultTarget", GetDefaultTargetRequest, payload, true)
    act_t act = addMethodCallback(ID_GetDefaultTarget, dbusMessage.getUniqueSerial(), "GetDefaultTarget", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetDefaultTarget", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendPresetAllUnitFilesRequest(PresetAllUnitFilesCallbackIF& cb, const ::std::string& name, bool runtime, bool force) const {
    PresetAllUnitFilesRequest* payload = new PresetAllUnitFilesRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setRuntime(runtime);
    payload->setForce(force);
    DBUS_MESSAGE_CALL(dbusMessage, "PresetAllUnitFiles", PresetAllUnitFilesRequest, payload, true)
    act_t act = addMethodCallback(ID_PresetAllUnitFiles, dbusMessage.getUniqueSerial(), "PresetAllUnitFiles", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PresetAllUnitFiles", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ManagerProxy::sendAddDependencyUnitFilesRequest(AddDependencyUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, const ::std::string& arg_1, const ::std::string& arg_2, bool runtime, bool force) const {
    AddDependencyUnitFilesRequest* payload = new AddDependencyUnitFilesRequest();
    CHECK_ALLOCATION(payload);
    payload->setFiles(files);
    payload->setArg_1(arg_1);
    payload->setArg_2(arg_2);
    payload->setRuntime(runtime);
    payload->setForce(force);
    DBUS_MESSAGE_CALL(dbusMessage, "AddDependencyUnitFiles", AddDependencyUnitFilesRequest, payload, true)
    act_t act = addMethodCallback(ID_AddDependencyUnitFiles, dbusMessage.getUniqueSerial(), "AddDependencyUnitFiles", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AddDependencyUnitFiles", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
