/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "org/freedesktop/systemd1/Manager.h"
#include "org/freedesktop/systemd1/ManagerJson.h"
#include "org/freedesktop/systemd1/ManagerJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "units"

void serializeJson (const ::org::freedesktop::systemd1::Manager::units& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDescription()) {
        yajl_gen_string(g, (const unsigned char*)  "description" , 11);
        const char *s = value.getDescription().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasLoadState()) {
        yajl_gen_string(g, (const unsigned char*)  "loadState" , 9);
        const char *s = value.getLoadState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasActiveState()) {
        yajl_gen_string(g, (const unsigned char*)  "activeState" , 11);
        const char *s = value.getActiveState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSubState()) {
        yajl_gen_string(g, (const unsigned char*)  "subState" , 8);
        const char *s = value.getSubState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFollower()) {
        yajl_gen_string(g, (const unsigned char*)  "follower" , 8);
        const char *s = value.getFollower().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPath()) {
        yajl_gen_string(g, (const unsigned char*)  "path" , 4);
        const char *s = value.getPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasJobId()) {
        yajl_gen_string(g, (const unsigned char*)  "jobId" , 5);
        yajl_gen_integer(g, (long long)value.getJobId());
    }
    if (!isSparse || value.hasJobType()) {
        yajl_gen_string(g, (const unsigned char*)  "jobType" , 7);
        const char *s = value.getJobType().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasJobPath()) {
        yajl_gen_string(g, (const unsigned char*)  "jobPath" , 7);
        const char *s = value.getJobPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::units& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "jobs"

void serializeJson (const ::org::freedesktop::systemd1::Manager::jobs& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobId()) {
        yajl_gen_string(g, (const unsigned char*)  "jobId" , 5);
        yajl_gen_integer(g, (long long)value.getJobId());
    }
    if (!isSparse || value.hasPrimaryUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "primaryUnit" , 11);
        const char *s = value.getPrimaryUnit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasType()) {
        yajl_gen_string(g, (const unsigned char*)  "type" , 4);
        const char *s = value.getType().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasState()) {
        yajl_gen_string(g, (const unsigned char*)  "state" , 5);
        const char *s = value.getState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPath()) {
        yajl_gen_string(g, (const unsigned char*)  "path" , 4);
        const char *s = value.getPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasUnitPath()) {
        yajl_gen_string(g, (const unsigned char*)  "unitPath" , 8);
        const char *s = value.getUnitPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::jobs& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "files"

void serializeJson (const ::org::freedesktop::systemd1::Manager::files& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnitName()) {
        yajl_gen_string(g, (const unsigned char*)  "unitName" , 8);
        const char *s = value.getUnitName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEnablement()) {
        yajl_gen_string(g, (const unsigned char*)  "enablement" , 10);
        const char *s = value.getEnablement().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::files& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "changes"

void serializeJson (const ::org::freedesktop::systemd1::Manager::changes& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasType()) {
        yajl_gen_string(g, (const unsigned char*)  "type" , 4);
        const char *s = value.getType().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "filename" , 8);
        const char *s = value.getFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDestination()) {
        yajl_gen_string(g, (const unsigned char*)  "destination" , 11);
        const char *s = value.getDestination().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::changes& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "property"

void serializeJson (const ::org::freedesktop::systemd1::Manager::property& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasValue()) {
        yajl_gen_string(g, (const unsigned char*)  "value" , 5);
        const char *s = value.getValue().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::property& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "transientunitdata"

void serializeJson (const ::org::freedesktop::systemd1::Manager::transientunitdata& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTransientproperties()) {
        yajl_gen_string(g, (const unsigned char*)  "transientproperties" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::property >& o1 = value.getTransientproperties();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::property >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::transientunitdata& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUnitRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetUnitRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetUnitRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUnitResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetUnitResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "unit" , 4);
        const char *s = value.getUnit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetUnitResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUnitByPIDRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetUnitByPIDRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetUnitByPIDRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUnitByPIDResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetUnitByPIDResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "unit" , 4);
        const char *s = value.getUnit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetUnitByPIDResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LoadUnitRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::LoadUnitRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::LoadUnitRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LoadUnitResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::LoadUnitResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "unit" , 4);
        const char *s = value.getUnit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::LoadUnitResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartUnitRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartUnitRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartUnitRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartUnitResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartUnitResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartUnitResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartUnitReplaceRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartUnitReplaceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOld_unit()) {
        yajl_gen_string(g, (const unsigned char*)  "old_unit" , 8);
        const char *s = value.getOld_unit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasNew_unit()) {
        yajl_gen_string(g, (const unsigned char*)  "new_unit" , 8);
        const char *s = value.getNew_unit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartUnitReplaceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartUnitReplaceResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartUnitReplaceResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartUnitReplaceResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopUnitRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::StopUnitRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::StopUnitRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopUnitResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::StopUnitResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::StopUnitResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadUnitRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadUnitRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadUnitRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadUnitResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadUnitResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadUnitResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartUnitRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::RestartUnitRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::RestartUnitRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartUnitResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::RestartUnitResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::RestartUnitResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TryRestartUnitRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::TryRestartUnitRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::TryRestartUnitRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TryRestartUnitResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::TryRestartUnitResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::TryRestartUnitResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadOrRestartUnitRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadOrRestartUnitRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadOrRestartUnitRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadOrRestartUnitResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadOrRestartUnitResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadOrRestartUnitResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadOrTryRestartUnitRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadOrTryRestartUnitRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadOrTryRestartUnitRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadOrTryRestartUnitResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadOrTryRestartUnitResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadOrTryRestartUnitResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KillUnitRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::KillUnitRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasWho()) {
        yajl_gen_string(g, (const unsigned char*)  "who" , 3);
        const char *s = value.getWho().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSignal()) {
        yajl_gen_string(g, (const unsigned char*)  "signal" , 6);
        yajl_gen_integer(g, (long long)value.getSignal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::KillUnitRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResetFailedUnitRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ResetFailedUnitRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ResetFailedUnitRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetUnitPropertiesRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SetUnitPropertiesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRuntime()) {
        yajl_gen_string(g, (const unsigned char*)  "runtime" , 7);
        yajl_gen_bool(g, (bool)value.getRuntime());
    }
    if (!isSparse || value.hasProperties()) {
        yajl_gen_string(g, (const unsigned char*)  "properties" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::property >& o3 = value.getProperties();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::property >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SetUnitPropertiesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartTransientUnitRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartTransientUnitRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasProperties()) {
        yajl_gen_string(g, (const unsigned char*)  "properties" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::property >& o5 = value.getProperties();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::property >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasTransientunitdata()) {
        yajl_gen_string(g, (const unsigned char*)  "transientunitdata" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::transientunitdata >& o7 = value.getTransientunitdata();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::transientunitdata >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartTransientUnitRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartTransientUnitResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartTransientUnitResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartTransientUnitResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetJobRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetJobRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "id" , 2);
        yajl_gen_integer(g, (long long)value.getId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetJobRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetJobResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetJobResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetJobResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CancelJobRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::CancelJobRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "id" , 2);
        yajl_gen_integer(g, (long long)value.getId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::CancelJobRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ListUnitsResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ListUnitsResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnits()) {
        yajl_gen_string(g, (const unsigned char*)  "units" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::units >& o9 = value.getUnits();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::units >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ListUnitsResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ListUnitsFilteredRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ListUnitsFilteredRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnitList()) {
        yajl_gen_string(g, (const unsigned char*)  "unitList" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o11 = value.getUnitList();
        {
            ::std::vector< ::std::string >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                const char *s = (*o10).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ListUnitsFilteredRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ListUnitsFilteredResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ListUnitsFilteredResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnits()) {
        yajl_gen_string(g, (const unsigned char*)  "units" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::units >& o13 = value.getUnits();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::units >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ListUnitsFilteredResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ListJobsResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ListJobsResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobs()) {
        yajl_gen_string(g, (const unsigned char*)  "jobs" , 4);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::jobs >& o15 = value.getJobs();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::jobs >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                serializeJson((*o14), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ListJobsResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DumpResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::DumpResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDump()) {
        yajl_gen_string(g, (const unsigned char*)  "dump" , 4);
        const char *s = value.getDump().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::DumpResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateSnapshotRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::CreateSnapshotRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCleanup()) {
        yajl_gen_string(g, (const unsigned char*)  "cleanup" , 7);
        yajl_gen_bool(g, (bool)value.getCleanup());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::CreateSnapshotRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateSnapshotResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::CreateSnapshotResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "unit" , 4);
        const char *s = value.getUnit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::CreateSnapshotResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RemoveSnapshotRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::RemoveSnapshotRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::RemoveSnapshotRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SwitchRootRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SwitchRootRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNew_root()) {
        yajl_gen_string(g, (const unsigned char*)  "new_root" , 8);
        const char *s = value.getNew_root().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasInit()) {
        yajl_gen_string(g, (const unsigned char*)  "init" , 4);
        const char *s = value.getInit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SwitchRootRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetEnvironmentRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SetEnvironmentRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNames()) {
        yajl_gen_string(g, (const unsigned char*)  "names" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o17 = value.getNames();
        {
            ::std::vector< ::std::string >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                const char *s = (*o16).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SetEnvironmentRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnsetEnvironmentRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnsetEnvironmentRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNames()) {
        yajl_gen_string(g, (const unsigned char*)  "names" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o19 = value.getNames();
        {
            ::std::vector< ::std::string >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                const char *s = (*o18).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnsetEnvironmentRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnsetAndSetEnvironmentRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnsetAndSetEnvironmentRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnset()) {
        yajl_gen_string(g, (const unsigned char*)  "unset" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o21 = value.getUnset();
        {
            ::std::vector< ::std::string >::const_iterator o20;
            for (o20 = o21.begin(); o20 != o21.end(); ++o20) {
                const char *s = (*o20).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasSet()) {
        yajl_gen_string(g, (const unsigned char*)  "set" , 3);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o23 = value.getSet();
        {
            ::std::vector< ::std::string >::const_iterator o22;
            for (o22 = o23.begin(); o22 != o23.end(); ++o22) {
                const char *s = (*o22).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnsetAndSetEnvironmentRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ListUnitFilesResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ListUnitFilesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "files" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::files >& o25 = value.getFiles();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::files >::const_iterator o24;
            for (o24 = o25.begin(); o24 != o25.end(); ++o24) {
                serializeJson((*o24), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ListUnitFilesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUnitFileStateRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetUnitFileStateRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFile()) {
        yajl_gen_string(g, (const unsigned char*)  "file" , 4);
        const char *s = value.getFile().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetUnitFileStateRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUnitFileStateResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetUnitFileStateResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasState()) {
        yajl_gen_string(g, (const unsigned char*)  "state" , 5);
        const char *s = value.getState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetUnitFileStateResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnableUnitFilesRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::EnableUnitFilesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "files" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o27 = value.getFiles();
        {
            ::std::vector< ::std::string >::const_iterator o26;
            for (o26 = o27.begin(); o26 != o27.end(); ++o26) {
                const char *s = (*o26).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRuntime()) {
        yajl_gen_string(g, (const unsigned char*)  "runtime" , 7);
        yajl_gen_bool(g, (bool)value.getRuntime());
    }
    if (!isSparse || value.hasForce()) {
        yajl_gen_string(g, (const unsigned char*)  "force" , 5);
        yajl_gen_bool(g, (bool)value.getForce());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::EnableUnitFilesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnableUnitFilesResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::EnableUnitFilesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCarries_install_info()) {
        yajl_gen_string(g, (const unsigned char*)  "carries_install_info" , 20);
        yajl_gen_bool(g, (bool)value.getCarries_install_info());
    }
    if (!isSparse || value.hasChanges()) {
        yajl_gen_string(g, (const unsigned char*)  "changes" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >& o29 = value.getChanges();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o28;
            for (o28 = o29.begin(); o28 != o29.end(); ++o28) {
                serializeJson((*o28), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::EnableUnitFilesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DisableUnitFilesRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::DisableUnitFilesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "files" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o31 = value.getFiles();
        {
            ::std::vector< ::std::string >::const_iterator o30;
            for (o30 = o31.begin(); o30 != o31.end(); ++o30) {
                const char *s = (*o30).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRuntime()) {
        yajl_gen_string(g, (const unsigned char*)  "runtime" , 7);
        yajl_gen_bool(g, (bool)value.getRuntime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::DisableUnitFilesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DisableUnitFilesResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::DisableUnitFilesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChanges()) {
        yajl_gen_string(g, (const unsigned char*)  "changes" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >& o33 = value.getChanges();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o32;
            for (o32 = o33.begin(); o32 != o33.end(); ++o32) {
                serializeJson((*o32), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::DisableUnitFilesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReenableUnitFilesRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReenableUnitFilesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "files" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o35 = value.getFiles();
        {
            ::std::vector< ::std::string >::const_iterator o34;
            for (o34 = o35.begin(); o34 != o35.end(); ++o34) {
                const char *s = (*o34).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRuntime()) {
        yajl_gen_string(g, (const unsigned char*)  "runtime" , 7);
        yajl_gen_bool(g, (bool)value.getRuntime());
    }
    if (!isSparse || value.hasForce()) {
        yajl_gen_string(g, (const unsigned char*)  "force" , 5);
        yajl_gen_bool(g, (bool)value.getForce());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReenableUnitFilesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReenableUnitFilesResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReenableUnitFilesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCarries_install_info()) {
        yajl_gen_string(g, (const unsigned char*)  "carries_install_info" , 20);
        yajl_gen_bool(g, (bool)value.getCarries_install_info());
    }
    if (!isSparse || value.hasChanges()) {
        yajl_gen_string(g, (const unsigned char*)  "changes" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >& o37 = value.getChanges();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o36;
            for (o36 = o37.begin(); o36 != o37.end(); ++o36) {
                serializeJson((*o36), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReenableUnitFilesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LinkUnitFilesRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::LinkUnitFilesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "files" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o39 = value.getFiles();
        {
            ::std::vector< ::std::string >::const_iterator o38;
            for (o38 = o39.begin(); o38 != o39.end(); ++o38) {
                const char *s = (*o38).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRuntime()) {
        yajl_gen_string(g, (const unsigned char*)  "runtime" , 7);
        yajl_gen_bool(g, (bool)value.getRuntime());
    }
    if (!isSparse || value.hasForce()) {
        yajl_gen_string(g, (const unsigned char*)  "force" , 5);
        yajl_gen_bool(g, (bool)value.getForce());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::LinkUnitFilesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LinkUnitFilesResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::LinkUnitFilesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChanges()) {
        yajl_gen_string(g, (const unsigned char*)  "changes" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >& o41 = value.getChanges();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o40;
            for (o40 = o41.begin(); o40 != o41.end(); ++o40) {
                serializeJson((*o40), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::LinkUnitFilesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PresetUnitFilesRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::PresetUnitFilesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "files" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o43 = value.getFiles();
        {
            ::std::vector< ::std::string >::const_iterator o42;
            for (o42 = o43.begin(); o42 != o43.end(); ++o42) {
                const char *s = (*o42).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRuntime()) {
        yajl_gen_string(g, (const unsigned char*)  "runtime" , 7);
        yajl_gen_bool(g, (bool)value.getRuntime());
    }
    if (!isSparse || value.hasForce()) {
        yajl_gen_string(g, (const unsigned char*)  "force" , 5);
        yajl_gen_bool(g, (bool)value.getForce());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::PresetUnitFilesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PresetUnitFilesResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::PresetUnitFilesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCarries_install_info()) {
        yajl_gen_string(g, (const unsigned char*)  "carries_install_info" , 20);
        yajl_gen_bool(g, (bool)value.getCarries_install_info());
    }
    if (!isSparse || value.hasChanges()) {
        yajl_gen_string(g, (const unsigned char*)  "changes" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >& o45 = value.getChanges();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o44;
            for (o44 = o45.begin(); o44 != o45.end(); ++o44) {
                serializeJson((*o44), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::PresetUnitFilesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PresetUnitFilesWithModeRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::PresetUnitFilesWithModeRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "files" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o47 = value.getFiles();
        {
            ::std::vector< ::std::string >::const_iterator o46;
            for (o46 = o47.begin(); o46 != o47.end(); ++o46) {
                const char *s = (*o46).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char *s = value.getMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRuntime()) {
        yajl_gen_string(g, (const unsigned char*)  "runtime" , 7);
        yajl_gen_bool(g, (bool)value.getRuntime());
    }
    if (!isSparse || value.hasForce()) {
        yajl_gen_string(g, (const unsigned char*)  "force" , 5);
        yajl_gen_bool(g, (bool)value.getForce());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::PresetUnitFilesWithModeRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PresetUnitFilesWithModeResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::PresetUnitFilesWithModeResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCarries_install_info()) {
        yajl_gen_string(g, (const unsigned char*)  "carries_install_info" , 20);
        yajl_gen_bool(g, (bool)value.getCarries_install_info());
    }
    if (!isSparse || value.hasChanges()) {
        yajl_gen_string(g, (const unsigned char*)  "changes" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >& o49 = value.getChanges();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o48;
            for (o48 = o49.begin(); o48 != o49.end(); ++o48) {
                serializeJson((*o48), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::PresetUnitFilesWithModeResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MaskUnitFilesRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::MaskUnitFilesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "files" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o51 = value.getFiles();
        {
            ::std::vector< ::std::string >::const_iterator o50;
            for (o50 = o51.begin(); o50 != o51.end(); ++o50) {
                const char *s = (*o50).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRuntime()) {
        yajl_gen_string(g, (const unsigned char*)  "runtime" , 7);
        yajl_gen_bool(g, (bool)value.getRuntime());
    }
    if (!isSparse || value.hasForce()) {
        yajl_gen_string(g, (const unsigned char*)  "force" , 5);
        yajl_gen_bool(g, (bool)value.getForce());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::MaskUnitFilesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MaskUnitFilesResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::MaskUnitFilesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChanges()) {
        yajl_gen_string(g, (const unsigned char*)  "changes" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >& o53 = value.getChanges();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o52;
            for (o52 = o53.begin(); o52 != o53.end(); ++o52) {
                serializeJson((*o52), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::MaskUnitFilesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnmaskUnitFilesRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnmaskUnitFilesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "files" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o55 = value.getFiles();
        {
            ::std::vector< ::std::string >::const_iterator o54;
            for (o54 = o55.begin(); o54 != o55.end(); ++o54) {
                const char *s = (*o54).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRuntime()) {
        yajl_gen_string(g, (const unsigned char*)  "runtime" , 7);
        yajl_gen_bool(g, (bool)value.getRuntime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnmaskUnitFilesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnmaskUnitFilesResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnmaskUnitFilesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChanges()) {
        yajl_gen_string(g, (const unsigned char*)  "changes" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >& o57 = value.getChanges();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o56;
            for (o56 = o57.begin(); o56 != o57.end(); ++o56) {
                serializeJson((*o56), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnmaskUnitFilesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDefaultTargetRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SetDefaultTargetRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasArg_0()) {
        yajl_gen_string(g, (const unsigned char*)  "arg_0" , 5);
        const char *s = value.getArg_0().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasArg_1()) {
        yajl_gen_string(g, (const unsigned char*)  "arg_1" , 5);
        yajl_gen_bool(g, (bool)value.getArg_1());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SetDefaultTargetRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDefaultTargetResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SetDefaultTargetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChanges()) {
        yajl_gen_string(g, (const unsigned char*)  "changes" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >& o59 = value.getChanges();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o58;
            for (o58 = o59.begin(); o58 != o59.end(); ++o58) {
                serializeJson((*o58), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SetDefaultTargetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDefaultTargetResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetDefaultTargetResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTargetName()) {
        yajl_gen_string(g, (const unsigned char*)  "targetName" , 10);
        const char *s = value.getTargetName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GetDefaultTargetResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PresetAllUnitFilesRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::PresetAllUnitFilesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRuntime()) {
        yajl_gen_string(g, (const unsigned char*)  "runtime" , 7);
        yajl_gen_bool(g, (bool)value.getRuntime());
    }
    if (!isSparse || value.hasForce()) {
        yajl_gen_string(g, (const unsigned char*)  "force" , 5);
        yajl_gen_bool(g, (bool)value.getForce());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::PresetAllUnitFilesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PresetAllUnitFilesResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::PresetAllUnitFilesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChanges()) {
        yajl_gen_string(g, (const unsigned char*)  "changes" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >& o61 = value.getChanges();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o60;
            for (o60 = o61.begin(); o60 != o61.end(); ++o60) {
                serializeJson((*o60), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::PresetAllUnitFilesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AddDependencyUnitFilesRequest"

void serializeJson (const ::org::freedesktop::systemd1::Manager::AddDependencyUnitFilesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "files" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o63 = value.getFiles();
        {
            ::std::vector< ::std::string >::const_iterator o62;
            for (o62 = o63.begin(); o62 != o63.end(); ++o62) {
                const char *s = (*o62).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasArg_1()) {
        yajl_gen_string(g, (const unsigned char*)  "arg_1" , 5);
        const char *s = value.getArg_1().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasArg_2()) {
        yajl_gen_string(g, (const unsigned char*)  "arg_2" , 5);
        const char *s = value.getArg_2().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRuntime()) {
        yajl_gen_string(g, (const unsigned char*)  "runtime" , 7);
        yajl_gen_bool(g, (bool)value.getRuntime());
    }
    if (!isSparse || value.hasForce()) {
        yajl_gen_string(g, (const unsigned char*)  "force" , 5);
        yajl_gen_bool(g, (bool)value.getForce());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::AddDependencyUnitFilesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AddDependencyUnitFilesResponse"

void serializeJson (const ::org::freedesktop::systemd1::Manager::AddDependencyUnitFilesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChanges()) {
        yajl_gen_string(g, (const unsigned char*)  "changes" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >& o65 = value.getChanges();
        {
            ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o64;
            for (o64 = o65.begin(); o64 != o65.end(); ++o64) {
                serializeJson((*o64), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::AddDependencyUnitFilesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VersionUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::VersionUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "Version" , 7);
        const char *s = value.getVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::VersionUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VersionRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::VersionRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::VersionRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FeaturesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::FeaturesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFeatures()) {
        yajl_gen_string(g, (const unsigned char*)  "Features" , 8);
        const char *s = value.getFeatures().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::FeaturesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FeaturesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::FeaturesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::FeaturesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VirtualizationUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::VirtualizationUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVirtualization()) {
        yajl_gen_string(g, (const unsigned char*)  "Virtualization" , 14);
        const char *s = value.getVirtualization().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::VirtualizationUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VirtualizationRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::VirtualizationRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::VirtualizationRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ArchitectureUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ArchitectureUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasArchitecture()) {
        yajl_gen_string(g, (const unsigned char*)  "Architecture" , 12);
        const char *s = value.getArchitecture().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ArchitectureUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ArchitectureRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ArchitectureRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ArchitectureRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TaintedUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::TaintedUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTainted()) {
        yajl_gen_string(g, (const unsigned char*)  "Tainted" , 7);
        const char *s = value.getTainted().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::TaintedUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TaintedRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::TaintedRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::TaintedRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FirmwareTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::FirmwareTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFirmwareTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "FirmwareTimestamp" , 17);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getFirmwareTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::FirmwareTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FirmwareTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::FirmwareTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::FirmwareTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FirmwareTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::FirmwareTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFirmwareTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "FirmwareTimestampMonotonic" , 26);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getFirmwareTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::FirmwareTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FirmwareTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::FirmwareTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::FirmwareTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LoaderTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::LoaderTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLoaderTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "LoaderTimestamp" , 15);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLoaderTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::LoaderTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LoaderTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::LoaderTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::LoaderTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LoaderTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::LoaderTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLoaderTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "LoaderTimestampMonotonic" , 24);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLoaderTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::LoaderTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LoaderTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::LoaderTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::LoaderTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KernelTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::KernelTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKernelTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "KernelTimestamp" , 15);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getKernelTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::KernelTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KernelTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::KernelTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::KernelTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KernelTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::KernelTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKernelTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "KernelTimestampMonotonic" , 24);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getKernelTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::KernelTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KernelTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::KernelTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::KernelTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InitRDTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::InitRDTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInitRDTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "InitRDTimestamp" , 15);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getInitRDTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::InitRDTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InitRDTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::InitRDTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::InitRDTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InitRDTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::InitRDTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInitRDTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "InitRDTimestampMonotonic" , 24);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getInitRDTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::InitRDTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InitRDTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::InitRDTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::InitRDTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UserspaceTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UserspaceTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUserspaceTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "UserspaceTimestamp" , 18);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getUserspaceTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UserspaceTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UserspaceTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UserspaceTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UserspaceTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UserspaceTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UserspaceTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUserspaceTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "UserspaceTimestampMonotonic" , 27);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getUserspaceTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UserspaceTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UserspaceTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UserspaceTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UserspaceTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FinishTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::FinishTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFinishTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "FinishTimestamp" , 15);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getFinishTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::FinishTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FinishTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::FinishTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::FinishTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FinishTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::FinishTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFinishTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "FinishTimestampMonotonic" , 24);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getFinishTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::FinishTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FinishTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::FinishTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::FinishTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityStartTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSecurityStartTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "SecurityStartTimestamp" , 22);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getSecurityStartTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityStartTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityStartTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSecurityStartTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "SecurityStartTimestampMonotonic" , 31);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getSecurityStartTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityStartTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityFinishTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSecurityFinishTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "SecurityFinishTimestamp" , 23);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getSecurityFinishTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityFinishTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityFinishTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSecurityFinishTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "SecurityFinishTimestampMonotonic" , 32);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getSecurityFinishTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityFinishTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneratorsStartTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGeneratorsStartTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "GeneratorsStartTimestamp" , 24);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getGeneratorsStartTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneratorsStartTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneratorsStartTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGeneratorsStartTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "GeneratorsStartTimestampMonotonic" , 33);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getGeneratorsStartTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneratorsStartTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneratorsFinishTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGeneratorsFinishTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "GeneratorsFinishTimestamp" , 25);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getGeneratorsFinishTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneratorsFinishTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneratorsFinishTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGeneratorsFinishTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "GeneratorsFinishTimestampMonotonic" , 34);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getGeneratorsFinishTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneratorsFinishTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitsLoadStartTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnitsLoadStartTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "UnitsLoadStartTimestamp" , 23);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getUnitsLoadStartTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitsLoadStartTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitsLoadStartTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnitsLoadStartTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "UnitsLoadStartTimestampMonotonic" , 32);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getUnitsLoadStartTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitsLoadStartTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitsLoadFinishTimestampUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnitsLoadFinishTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "UnitsLoadFinishTimestamp" , 24);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getUnitsLoadFinishTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitsLoadFinishTimestampRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitsLoadFinishTimestampMonotonicUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampMonotonicUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnitsLoadFinishTimestampMonotonic()) {
        yajl_gen_string(g, (const unsigned char*)  "UnitsLoadFinishTimestampMonotonic" , 33);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getUnitsLoadFinishTimestampMonotonic(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampMonotonicUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitsLoadFinishTimestampMonotonicRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampMonotonicRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampMonotonicRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LogLevelUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::LogLevelUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLogLevel()) {
        yajl_gen_string(g, (const unsigned char*)  "LogLevel" , 8);
        const char *s = value.getLogLevel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::LogLevelUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LogLevelRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::LogLevelRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::LogLevelRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LogTargetUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::LogTargetUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLogTarget()) {
        yajl_gen_string(g, (const unsigned char*)  "LogTarget" , 9);
        const char *s = value.getLogTarget().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::LogTargetUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LogTargetRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::LogTargetRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::LogTargetRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NNamesUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::NNamesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNNames()) {
        yajl_gen_string(g, (const unsigned char*)  "NNames" , 6);
        yajl_gen_integer(g, (long long)value.getNNames());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::NNamesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NNamesRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::NNamesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::NNamesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NFailedUnitsUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::NFailedUnitsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNFailedUnits()) {
        yajl_gen_string(g, (const unsigned char*)  "NFailedUnits" , 12);
        yajl_gen_integer(g, (long long)value.getNFailedUnits());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::NFailedUnitsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NFailedUnitsRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::NFailedUnitsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::NFailedUnitsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NJobsUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::NJobsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNJobs()) {
        yajl_gen_string(g, (const unsigned char*)  "NJobs" , 5);
        yajl_gen_integer(g, (long long)value.getNJobs());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::NJobsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NJobsRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::NJobsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::NJobsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NInstalledJobsUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::NInstalledJobsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNInstalledJobs()) {
        yajl_gen_string(g, (const unsigned char*)  "NInstalledJobs" , 14);
        yajl_gen_integer(g, (long long)value.getNInstalledJobs());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::NInstalledJobsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NInstalledJobsRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::NInstalledJobsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::NInstalledJobsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NFailedJobsUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::NFailedJobsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNFailedJobs()) {
        yajl_gen_string(g, (const unsigned char*)  "NFailedJobs" , 11);
        yajl_gen_integer(g, (long long)value.getNFailedJobs());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::NFailedJobsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NFailedJobsRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::NFailedJobsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::NFailedJobsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProgressUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ProgressUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "Progress" , 8);
        yajl_gen_double(g, (double)value.getProgress());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ProgressUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProgressRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ProgressRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ProgressRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnvironmentUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::EnvironmentUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnvironment()) {
        yajl_gen_string(g, (const unsigned char*)  "Environment" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o67 = value.getEnvironment();
        {
            ::std::vector< ::std::string >::const_iterator o66;
            for (o66 = o67.begin(); o66 != o67.end(); ++o66) {
                const char *s = (*o66).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::EnvironmentUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnvironmentRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::EnvironmentRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::EnvironmentRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConfirmSpawnUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ConfirmSpawnUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfirmSpawn()) {
        yajl_gen_string(g, (const unsigned char*)  "ConfirmSpawn" , 12);
        yajl_gen_bool(g, (bool)value.getConfirmSpawn());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ConfirmSpawnUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConfirmSpawnRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ConfirmSpawnRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ConfirmSpawnRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowStatusUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ShowStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasShowStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ShowStatus" , 10);
        yajl_gen_bool(g, (bool)value.getShowStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ShowStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowStatusRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ShowStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ShowStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitPathUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitPathUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUnitPath()) {
        yajl_gen_string(g, (const unsigned char*)  "UnitPath" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o69 = value.getUnitPath();
        {
            ::std::vector< ::std::string >::const_iterator o68;
            for (o68 = o69.begin(); o68 != o69.end(); ++o68) {
                const char *s = (*o68).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitPathUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitPathRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitPathRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitPathRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DefaultStandardOutputUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::DefaultStandardOutputUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefaultStandardOutput()) {
        yajl_gen_string(g, (const unsigned char*)  "DefaultStandardOutput" , 21);
        const char *s = value.getDefaultStandardOutput().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::DefaultStandardOutputUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DefaultStandardOutputRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::DefaultStandardOutputRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::DefaultStandardOutputRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DefaultStandardErrorUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::DefaultStandardErrorUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefaultStandardError()) {
        yajl_gen_string(g, (const unsigned char*)  "DefaultStandardError" , 20);
        const char *s = value.getDefaultStandardError().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::DefaultStandardErrorUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DefaultStandardErrorRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::DefaultStandardErrorRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::DefaultStandardErrorRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RuntimeWatchdogUSecUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::RuntimeWatchdogUSecUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRuntimeWatchdogUSec()) {
        yajl_gen_string(g, (const unsigned char*)  "RuntimeWatchdogUSec" , 19);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getRuntimeWatchdogUSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::RuntimeWatchdogUSecUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RuntimeWatchdogUSecRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::RuntimeWatchdogUSecRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::RuntimeWatchdogUSecRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShutdownWatchdogUSecUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ShutdownWatchdogUSecUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasShutdownWatchdogUSec()) {
        yajl_gen_string(g, (const unsigned char*)  "ShutdownWatchdogUSec" , 20);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getShutdownWatchdogUSec(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ShutdownWatchdogUSecUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShutdownWatchdogUSecRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ShutdownWatchdogUSecRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ShutdownWatchdogUSecRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ControlGroupUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ControlGroupUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasControlGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "ControlGroup" , 12);
        const char *s = value.getControlGroup().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ControlGroupUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ControlGroupRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ControlGroupRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ControlGroupRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemStateUpdate"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SystemStateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSystemState()) {
        yajl_gen_string(g, (const unsigned char*)  "SystemState" , 11);
        const char *s = value.getSystemState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SystemStateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemStateRegister"

void serializeJson (const ::org::freedesktop::systemd1::Manager::SystemStateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::SystemStateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitNewSignal"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitNewSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "id" , 2);
        const char *s = value.getId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "unit" , 4);
        const char *s = value.getUnit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitNewSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnitRemovedSignal"

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitRemovedSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "id" , 2);
        const char *s = value.getId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "unit" , 4);
        const char *s = value.getUnit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::UnitRemovedSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JobNewSignal"

void serializeJson (const ::org::freedesktop::systemd1::Manager::JobNewSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "id" , 2);
        yajl_gen_integer(g, (long long)value.getId());
    }
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "unit" , 4);
        const char *s = value.getUnit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::JobNewSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JobRemovedSignal"

void serializeJson (const ::org::freedesktop::systemd1::Manager::JobRemovedSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "id" , 2);
        yajl_gen_integer(g, (long long)value.getId());
    }
    if (!isSparse || value.hasJob()) {
        yajl_gen_string(g, (const unsigned char*)  "job" , 3);
        const char *s = value.getJob().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "unit" , 4);
        const char *s = value.getUnit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char *s = value.getResult().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::JobRemovedSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartupFinishedSignal"

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartupFinishedSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFirmware()) {
        yajl_gen_string(g, (const unsigned char*)  "firmware" , 8);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getFirmware(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasLoader()) {
        yajl_gen_string(g, (const unsigned char*)  "loader" , 6);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getLoader(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasKernel()) {
        yajl_gen_string(g, (const unsigned char*)  "kernel" , 6);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getKernel(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasInitrd()) {
        yajl_gen_string(g, (const unsigned char*)  "initrd" , 6);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getInitrd(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasUserspace()) {
        yajl_gen_string(g, (const unsigned char*)  "userspace" , 9);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getUserspace(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasTotal()) {
        yajl_gen_string(g, (const unsigned char*)  "total" , 5);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getTotal(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::StartupFinishedSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReloadingSignal"

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadingSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActive()) {
        yajl_gen_string(g, (const unsigned char*)  "active" , 6);
        yajl_gen_bool(g, (bool)value.getActive());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::freedesktop::systemd1::Manager::ReloadingSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::units& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::jobs& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::files& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::changes& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::property& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::transientunitdata& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GetUnitRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GetUnitResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GetUnitByPIDRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GetUnitByPIDResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::LoadUnitRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::LoadUnitResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::StartUnitRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::StartUnitResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::StartUnitReplaceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::StartUnitReplaceResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::StopUnitRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::StopUnitResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ReloadUnitRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ReloadUnitResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::RestartUnitRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::RestartUnitResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::TryRestartUnitRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::TryRestartUnitResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ReloadOrRestartUnitRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ReloadOrRestartUnitResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ReloadOrTryRestartUnitRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ReloadOrTryRestartUnitResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::KillUnitRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ResetFailedUnitRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SetUnitPropertiesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::StartTransientUnitRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::StartTransientUnitResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GetJobRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GetJobResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::CancelJobRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ListUnitsResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ListUnitsFilteredRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ListUnitsFilteredResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ListJobsResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::DumpResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::CreateSnapshotRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::CreateSnapshotResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::RemoveSnapshotRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SwitchRootRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SetEnvironmentRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnsetEnvironmentRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnsetAndSetEnvironmentRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ListUnitFilesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GetUnitFileStateRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GetUnitFileStateResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::EnableUnitFilesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::EnableUnitFilesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::DisableUnitFilesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::DisableUnitFilesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ReenableUnitFilesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ReenableUnitFilesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::LinkUnitFilesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::LinkUnitFilesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::PresetUnitFilesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::PresetUnitFilesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::PresetUnitFilesWithModeRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::PresetUnitFilesWithModeResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::MaskUnitFilesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::MaskUnitFilesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnmaskUnitFilesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnmaskUnitFilesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SetDefaultTargetRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SetDefaultTargetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GetDefaultTargetResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::PresetAllUnitFilesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::PresetAllUnitFilesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::AddDependencyUnitFilesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::AddDependencyUnitFilesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::VersionUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::VersionRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::FeaturesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::FeaturesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::VirtualizationUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::VirtualizationRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ArchitectureUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ArchitectureRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::TaintedUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::TaintedRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::FirmwareTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::FirmwareTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::FirmwareTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::FirmwareTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::LoaderTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::LoaderTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::LoaderTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::LoaderTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::KernelTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::KernelTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::KernelTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::KernelTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::InitRDTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::InitRDTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::InitRDTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::InitRDTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UserspaceTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UserspaceTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UserspaceTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UserspaceTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::FinishTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::FinishTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::FinishTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::FinishTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampMonotonicUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampMonotonicRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::LogLevelUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::LogLevelRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::LogTargetUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::LogTargetRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::NNamesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::NNamesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::NFailedUnitsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::NFailedUnitsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::NJobsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::NJobsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::NInstalledJobsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::NInstalledJobsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::NFailedJobsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::NFailedJobsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ProgressUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ProgressRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::EnvironmentUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::EnvironmentRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ConfirmSpawnUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ConfirmSpawnRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ShowStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ShowStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnitPathUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnitPathRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::DefaultStandardOutputUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::DefaultStandardOutputRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::DefaultStandardErrorUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::DefaultStandardErrorRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::RuntimeWatchdogUSecUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::RuntimeWatchdogUSecRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ShutdownWatchdogUSecUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ShutdownWatchdogUSecRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ControlGroupUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ControlGroupRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SystemStateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::SystemStateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnitNewSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::UnitRemovedSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::JobNewSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::JobRemovedSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::StartupFinishedSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

std::ostream& operator<<(std::ostream& o, const ::org::freedesktop::systemd1::Manager::ReloadingSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org

