/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "org/freedesktop/systemd1/Manager.h"
#include "org/freedesktop/systemd1/ManagerDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of units

void serializeDBus (const ::org::freedesktop::systemd1::Manager::units& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        const char* o1 = in.getName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o1));
        const char* o2 = in.getDescription().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o2));
        const char* o3 = in.getLoadState().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o3));
        const char* o4 = in.getActiveState().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o4));
        const char* o5 = in.getSubState().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o5));
        const char* o6 = in.getFollower().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o6));
        const char* o7 = in.getPath().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o7));
        uint32 o8 = in.getJobId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o8));
        const char* o9 = in.getJobType().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o9));
        const char* o10 = in.getJobPath().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o10));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::units& out) {
    {
        DBusMessageIter o11;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o11);
                {
                    ::std::string nameValue;
                    ::std::string &nameTmpValue = nameValue;
                    {
                        char* o12 = 0;
                        dbus_message_iter_get_basic(&o11, &o12);
                        nameTmpValue.assign (o12);
                    }
                    out.setName(nameValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::std::string descriptionValue;
                    ::std::string &descriptionTmpValue = descriptionValue;
                    {
                        char* o13 = 0;
                        dbus_message_iter_get_basic(&o11, &o13);
                        descriptionTmpValue.assign (o13);
                    }
                    out.setDescription(descriptionValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::std::string loadStateValue;
                    ::std::string &loadStateTmpValue = loadStateValue;
                    {
                        char* o14 = 0;
                        dbus_message_iter_get_basic(&o11, &o14);
                        loadStateTmpValue.assign (o14);
                    }
                    out.setLoadState(loadStateValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::std::string activeStateValue;
                    ::std::string &activeStateTmpValue = activeStateValue;
                    {
                        char* o15 = 0;
                        dbus_message_iter_get_basic(&o11, &o15);
                        activeStateTmpValue.assign (o15);
                    }
                    out.setActiveState(activeStateValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::std::string subStateValue;
                    ::std::string &subStateTmpValue = subStateValue;
                    {
                        char* o16 = 0;
                        dbus_message_iter_get_basic(&o11, &o16);
                        subStateTmpValue.assign (o16);
                    }
                    out.setSubState(subStateValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::std::string followerValue;
                    ::std::string &followerTmpValue = followerValue;
                    {
                        char* o17 = 0;
                        dbus_message_iter_get_basic(&o11, &o17);
                        followerTmpValue.assign (o17);
                    }
                    out.setFollower(followerValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::std::string pathValue;
                    ::std::string &pathTmpValue = pathValue;
                    {
                        char* o18 = 0;
                        dbus_message_iter_get_basic(&o11, &o18);
                        pathTmpValue.assign (o18);
                    }
                    out.setPath(pathValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    uint32 jobIdValue;
                    uint32 &jobIdTmpValue = jobIdValue;
                    dbus_message_iter_get_basic(&o11, &jobIdTmpValue);
                    out.setJobId(jobIdValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::std::string jobTypeValue;
                    ::std::string &jobTypeTmpValue = jobTypeValue;
                    {
                        char* o19 = 0;
                        dbus_message_iter_get_basic(&o11, &o19);
                        jobTypeTmpValue.assign (o19);
                    }
                    out.setJobType(jobTypeValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::std::string jobPathValue;
                    ::std::string &jobPathTmpValue = jobPathValue;
                    {
                        char* o20 = 0;
                        dbus_message_iter_get_basic(&o11, &o20);
                        jobPathTmpValue.assign (o20);
                    }
                    out.setJobPath(jobPathValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of jobs

void serializeDBus (const ::org::freedesktop::systemd1::Manager::jobs& in, DBusMessageIter* out) {
    {
        DBusMessageIter o21Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o21Struct));
        uint32 o22 = in.getJobId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o21Struct, DBUS_TYPE_UINT32, &o22));
        const char* o23 = in.getPrimaryUnit().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o21Struct, DBUS_TYPE_STRING, &o23));
        const char* o24 = in.getType().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o21Struct, DBUS_TYPE_STRING, &o24));
        const char* o25 = in.getState().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o21Struct, DBUS_TYPE_STRING, &o25));
        const char* o26 = in.getPath().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o21Struct, DBUS_TYPE_STRING, &o26));
        const char* o27 = in.getUnitPath().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o21Struct, DBUS_TYPE_STRING, &o27));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o21Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::jobs& out) {
    {
        DBusMessageIter o28;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o28);
                {
                    uint32 jobIdValue;
                    uint32 &jobIdTmpValue = jobIdValue;
                    dbus_message_iter_get_basic(&o28, &jobIdTmpValue);
                    out.setJobId(jobIdValue);
                }

                if (dbus_message_iter_has_next(&o28)) {
                    dbus_message_iter_next(&o28);
                } else {
                    return true;
                }

                {
                    ::std::string primaryUnitValue;
                    ::std::string &primaryUnitTmpValue = primaryUnitValue;
                    {
                        char* o29 = 0;
                        dbus_message_iter_get_basic(&o28, &o29);
                        primaryUnitTmpValue.assign (o29);
                    }
                    out.setPrimaryUnit(primaryUnitValue);
                }

                if (dbus_message_iter_has_next(&o28)) {
                    dbus_message_iter_next(&o28);
                } else {
                    return true;
                }

                {
                    ::std::string typeValue;
                    ::std::string &typeTmpValue = typeValue;
                    {
                        char* o30 = 0;
                        dbus_message_iter_get_basic(&o28, &o30);
                        typeTmpValue.assign (o30);
                    }
                    out.setType(typeValue);
                }

                if (dbus_message_iter_has_next(&o28)) {
                    dbus_message_iter_next(&o28);
                } else {
                    return true;
                }

                {
                    ::std::string stateValue;
                    ::std::string &stateTmpValue = stateValue;
                    {
                        char* o31 = 0;
                        dbus_message_iter_get_basic(&o28, &o31);
                        stateTmpValue.assign (o31);
                    }
                    out.setState(stateValue);
                }

                if (dbus_message_iter_has_next(&o28)) {
                    dbus_message_iter_next(&o28);
                } else {
                    return true;
                }

                {
                    ::std::string pathValue;
                    ::std::string &pathTmpValue = pathValue;
                    {
                        char* o32 = 0;
                        dbus_message_iter_get_basic(&o28, &o32);
                        pathTmpValue.assign (o32);
                    }
                    out.setPath(pathValue);
                }

                if (dbus_message_iter_has_next(&o28)) {
                    dbus_message_iter_next(&o28);
                } else {
                    return true;
                }

                {
                    ::std::string unitPathValue;
                    ::std::string &unitPathTmpValue = unitPathValue;
                    {
                        char* o33 = 0;
                        dbus_message_iter_get_basic(&o28, &o33);
                        unitPathTmpValue.assign (o33);
                    }
                    out.setUnitPath(unitPathValue);
                }

                if (dbus_message_iter_has_next(&o28)) {
                    dbus_message_iter_next(&o28);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of files

void serializeDBus (const ::org::freedesktop::systemd1::Manager::files& in, DBusMessageIter* out) {
    {
        DBusMessageIter o34Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o34Struct));
        const char* o35 = in.getUnitName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o34Struct, DBUS_TYPE_STRING, &o35));
        const char* o36 = in.getEnablement().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o34Struct, DBUS_TYPE_STRING, &o36));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o34Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::files& out) {
    {
        DBusMessageIter o37;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o37);
                {
                    ::std::string unitNameValue;
                    ::std::string &unitNameTmpValue = unitNameValue;
                    {
                        char* o38 = 0;
                        dbus_message_iter_get_basic(&o37, &o38);
                        unitNameTmpValue.assign (o38);
                    }
                    out.setUnitName(unitNameValue);
                }

                if (dbus_message_iter_has_next(&o37)) {
                    dbus_message_iter_next(&o37);
                } else {
                    return true;
                }

                {
                    ::std::string enablementValue;
                    ::std::string &enablementTmpValue = enablementValue;
                    {
                        char* o39 = 0;
                        dbus_message_iter_get_basic(&o37, &o39);
                        enablementTmpValue.assign (o39);
                    }
                    out.setEnablement(enablementValue);
                }

                if (dbus_message_iter_has_next(&o37)) {
                    dbus_message_iter_next(&o37);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of changes

void serializeDBus (const ::org::freedesktop::systemd1::Manager::changes& in, DBusMessageIter* out) {
    {
        DBusMessageIter o40Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o40Struct));
        const char* o41 = in.getType().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o40Struct, DBUS_TYPE_STRING, &o41));
        const char* o42 = in.getFilename().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o40Struct, DBUS_TYPE_STRING, &o42));
        const char* o43 = in.getDestination().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o40Struct, DBUS_TYPE_STRING, &o43));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o40Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::changes& out) {
    {
        DBusMessageIter o44;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o44);
                {
                    ::std::string typeValue;
                    ::std::string &typeTmpValue = typeValue;
                    {
                        char* o45 = 0;
                        dbus_message_iter_get_basic(&o44, &o45);
                        typeTmpValue.assign (o45);
                    }
                    out.setType(typeValue);
                }

                if (dbus_message_iter_has_next(&o44)) {
                    dbus_message_iter_next(&o44);
                } else {
                    return true;
                }

                {
                    ::std::string filenameValue;
                    ::std::string &filenameTmpValue = filenameValue;
                    {
                        char* o46 = 0;
                        dbus_message_iter_get_basic(&o44, &o46);
                        filenameTmpValue.assign (o46);
                    }
                    out.setFilename(filenameValue);
                }

                if (dbus_message_iter_has_next(&o44)) {
                    dbus_message_iter_next(&o44);
                } else {
                    return true;
                }

                {
                    ::std::string destinationValue;
                    ::std::string &destinationTmpValue = destinationValue;
                    {
                        char* o47 = 0;
                        dbus_message_iter_get_basic(&o44, &o47);
                        destinationTmpValue.assign (o47);
                    }
                    out.setDestination(destinationValue);
                }

                if (dbus_message_iter_has_next(&o44)) {
                    dbus_message_iter_next(&o44);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of property

void serializeDBus (const ::org::freedesktop::systemd1::Manager::property& in, DBusMessageIter* out) {
    {
        DBusMessageIter o48Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o48Struct));
        const char* o49 = in.getName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o48Struct, DBUS_TYPE_STRING, &o49));
        const char* o50 = in.getValue().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o48Struct, DBUS_TYPE_STRING, &o50));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o48Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::property& out) {
    {
        DBusMessageIter o51;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o51);
                {
                    ::std::string nameValue;
                    ::std::string &nameTmpValue = nameValue;
                    {
                        char* o52 = 0;
                        dbus_message_iter_get_basic(&o51, &o52);
                        nameTmpValue.assign (o52);
                    }
                    out.setName(nameValue);
                }

                if (dbus_message_iter_has_next(&o51)) {
                    dbus_message_iter_next(&o51);
                } else {
                    return true;
                }

                {
                    ::std::string valueValue;
                    ::std::string &valueTmpValue = valueValue;
                    {
                        char* o53 = 0;
                        dbus_message_iter_get_basic(&o51, &o53);
                        valueTmpValue.assign (o53);
                    }
                    out.setValue(valueValue);
                }

                if (dbus_message_iter_has_next(&o51)) {
                    dbus_message_iter_next(&o51);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of transientunitdata

void serializeDBus (const ::org::freedesktop::systemd1::Manager::transientunitdata& in, DBusMessageIter* out) {
    {
        DBusMessageIter o54Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o54Struct));
        const char* o55 = in.getName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o54Struct, DBUS_TYPE_STRING, &o55));
        DBusMessageIter o56ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o54Struct, DBUS_TYPE_ARRAY, "(ss)", &o56ArrayIter));
        const ::std::vector< ::org::freedesktop::systemd1::Manager::property >* o57 = &in.getTransientproperties();
        ::std::vector< ::org::freedesktop::systemd1::Manager::property >::const_iterator o58 = o57->end();
        for (::std::vector< ::org::freedesktop::systemd1::Manager::property >::const_iterator o59 = o57->begin(); o59 != o58; ++o59) {
            serializeDBus((*o59), &o56ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o54Struct, &o56ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o54Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::transientunitdata& out) {
    {
        DBusMessageIter o60;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o60);
                {
                    ::std::string nameValue;
                    ::std::string &nameTmpValue = nameValue;
                    {
                        char* o61 = 0;
                        dbus_message_iter_get_basic(&o60, &o61);
                        nameTmpValue.assign (o61);
                    }
                    out.setName(nameValue);
                }

                if (dbus_message_iter_has_next(&o60)) {
                    dbus_message_iter_next(&o60);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::freedesktop::systemd1::Manager::property > transientpropertiesValue;

                    if (dbus_message_iter_get_arg_type(&o60) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o62ArrayIter;
                        dbus_message_iter_recurse (&o60, &o62ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o62ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::freedesktop::systemd1::Manager::property o63;
                                if (!deserializeDBus(&o62ArrayIter, o63)) {
                                    return false;
                                }
                                transientpropertiesValue.push_back(o63);
                            } while (dbus_message_iter_next(&o62ArrayIter));
                        }
                    }
                    out.setTransientproperties(transientpropertiesValue);
                }

                if (dbus_message_iter_has_next(&o60)) {
                    dbus_message_iter_next(&o60);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of GetUnitRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GetUnitRequest& in, DBusMessageIter* out) {
    const char* o64 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o64));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GetUnitRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o65 = 0;
            dbus_message_iter_get_basic(in, &o65);
            nameTmpValue.assign (o65);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetUnitResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GetUnitResponse& in, DBusMessageIter* out) {
    const char* o66 = in.getUnit().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o66));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GetUnitResponse& out) {
    {
        ::std::string unitValue;
        ::std::string &unitTmpValue = unitValue;
        {
            char* o67 = 0;
            dbus_message_iter_get_basic(in, &o67);
            unitTmpValue.assign (o67);
        }
        out.setUnit(unitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetUnitByPIDRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GetUnitByPIDRequest& in, DBusMessageIter* out) {
    uint32 o68 = in.getPid();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o68));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GetUnitByPIDRequest& out) {
    {
        uint32 pidValue;
        uint32 &pidTmpValue = pidValue;
        dbus_message_iter_get_basic(in, &pidTmpValue);
        out.setPid(pidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetUnitByPIDResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GetUnitByPIDResponse& in, DBusMessageIter* out) {
    const char* o69 = in.getUnit().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o69));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GetUnitByPIDResponse& out) {
    {
        ::std::string unitValue;
        ::std::string &unitTmpValue = unitValue;
        {
            char* o70 = 0;
            dbus_message_iter_get_basic(in, &o70);
            unitTmpValue.assign (o70);
        }
        out.setUnit(unitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LoadUnitRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::LoadUnitRequest& in, DBusMessageIter* out) {
    const char* o71 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o71));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::LoadUnitRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o72 = 0;
            dbus_message_iter_get_basic(in, &o72);
            nameTmpValue.assign (o72);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LoadUnitResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::LoadUnitResponse& in, DBusMessageIter* out) {
    const char* o73 = in.getUnit().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o73));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::LoadUnitResponse& out) {
    {
        ::std::string unitValue;
        ::std::string &unitTmpValue = unitValue;
        {
            char* o74 = 0;
            dbus_message_iter_get_basic(in, &o74);
            unitTmpValue.assign (o74);
        }
        out.setUnit(unitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartUnitRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::StartUnitRequest& in, DBusMessageIter* out) {
    const char* o75 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o75));
    const char* o76 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o76));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::StartUnitRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o77 = 0;
            dbus_message_iter_get_basic(in, &o77);
            nameTmpValue.assign (o77);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o78 = 0;
            dbus_message_iter_get_basic(in, &o78);
            modeTmpValue.assign (o78);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartUnitResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::StartUnitResponse& in, DBusMessageIter* out) {
    const char* o79 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o79));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::StartUnitResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o80 = 0;
            dbus_message_iter_get_basic(in, &o80);
            jobTmpValue.assign (o80);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartUnitReplaceRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::StartUnitReplaceRequest& in, DBusMessageIter* out) {
    const char* o81 = in.getOld_unit().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o81));
    const char* o82 = in.getNew_unit().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o82));
    const char* o83 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o83));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::StartUnitReplaceRequest& out) {
    {
        ::std::string old_unitValue;
        ::std::string &old_unitTmpValue = old_unitValue;
        {
            char* o84 = 0;
            dbus_message_iter_get_basic(in, &o84);
            old_unitTmpValue.assign (o84);
        }
        out.setOld_unit(old_unitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string new_unitValue;
        ::std::string &new_unitTmpValue = new_unitValue;
        {
            char* o85 = 0;
            dbus_message_iter_get_basic(in, &o85);
            new_unitTmpValue.assign (o85);
        }
        out.setNew_unit(new_unitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o86 = 0;
            dbus_message_iter_get_basic(in, &o86);
            modeTmpValue.assign (o86);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartUnitReplaceResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::StartUnitReplaceResponse& in, DBusMessageIter* out) {
    const char* o87 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o87));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::StartUnitReplaceResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o88 = 0;
            dbus_message_iter_get_basic(in, &o88);
            jobTmpValue.assign (o88);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StopUnitRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::StopUnitRequest& in, DBusMessageIter* out) {
    const char* o89 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o89));
    const char* o90 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o90));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::StopUnitRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o91 = 0;
            dbus_message_iter_get_basic(in, &o91);
            nameTmpValue.assign (o91);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o92 = 0;
            dbus_message_iter_get_basic(in, &o92);
            modeTmpValue.assign (o92);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StopUnitResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::StopUnitResponse& in, DBusMessageIter* out) {
    const char* o93 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o93));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::StopUnitResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o94 = 0;
            dbus_message_iter_get_basic(in, &o94);
            jobTmpValue.assign (o94);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadUnitRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ReloadUnitRequest& in, DBusMessageIter* out) {
    const char* o95 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o95));
    const char* o96 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o96));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ReloadUnitRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o97 = 0;
            dbus_message_iter_get_basic(in, &o97);
            nameTmpValue.assign (o97);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o98 = 0;
            dbus_message_iter_get_basic(in, &o98);
            modeTmpValue.assign (o98);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadUnitResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ReloadUnitResponse& in, DBusMessageIter* out) {
    const char* o99 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o99));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ReloadUnitResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o100 = 0;
            dbus_message_iter_get_basic(in, &o100);
            jobTmpValue.assign (o100);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RestartUnitRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::RestartUnitRequest& in, DBusMessageIter* out) {
    const char* o101 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o101));
    const char* o102 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o102));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::RestartUnitRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o103 = 0;
            dbus_message_iter_get_basic(in, &o103);
            nameTmpValue.assign (o103);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o104 = 0;
            dbus_message_iter_get_basic(in, &o104);
            modeTmpValue.assign (o104);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RestartUnitResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::RestartUnitResponse& in, DBusMessageIter* out) {
    const char* o105 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o105));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::RestartUnitResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o106 = 0;
            dbus_message_iter_get_basic(in, &o106);
            jobTmpValue.assign (o106);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TryRestartUnitRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::TryRestartUnitRequest& in, DBusMessageIter* out) {
    const char* o107 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o107));
    const char* o108 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o108));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::TryRestartUnitRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o109 = 0;
            dbus_message_iter_get_basic(in, &o109);
            nameTmpValue.assign (o109);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o110 = 0;
            dbus_message_iter_get_basic(in, &o110);
            modeTmpValue.assign (o110);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TryRestartUnitResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::TryRestartUnitResponse& in, DBusMessageIter* out) {
    const char* o111 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o111));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::TryRestartUnitResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o112 = 0;
            dbus_message_iter_get_basic(in, &o112);
            jobTmpValue.assign (o112);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadOrRestartUnitRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ReloadOrRestartUnitRequest& in, DBusMessageIter* out) {
    const char* o113 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o113));
    const char* o114 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o114));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ReloadOrRestartUnitRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o115 = 0;
            dbus_message_iter_get_basic(in, &o115);
            nameTmpValue.assign (o115);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o116 = 0;
            dbus_message_iter_get_basic(in, &o116);
            modeTmpValue.assign (o116);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadOrRestartUnitResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ReloadOrRestartUnitResponse& in, DBusMessageIter* out) {
    const char* o117 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o117));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ReloadOrRestartUnitResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o118 = 0;
            dbus_message_iter_get_basic(in, &o118);
            jobTmpValue.assign (o118);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadOrTryRestartUnitRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ReloadOrTryRestartUnitRequest& in, DBusMessageIter* out) {
    const char* o119 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o119));
    const char* o120 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o120));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ReloadOrTryRestartUnitRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o121 = 0;
            dbus_message_iter_get_basic(in, &o121);
            nameTmpValue.assign (o121);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o122 = 0;
            dbus_message_iter_get_basic(in, &o122);
            modeTmpValue.assign (o122);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadOrTryRestartUnitResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ReloadOrTryRestartUnitResponse& in, DBusMessageIter* out) {
    const char* o123 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o123));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ReloadOrTryRestartUnitResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o124 = 0;
            dbus_message_iter_get_basic(in, &o124);
            jobTmpValue.assign (o124);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of KillUnitRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::KillUnitRequest& in, DBusMessageIter* out) {
    const char* o125 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o125));
    const char* o126 = in.getWho().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o126));
    int32 o127 = in.getSignal();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o127));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::KillUnitRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o128 = 0;
            dbus_message_iter_get_basic(in, &o128);
            nameTmpValue.assign (o128);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string whoValue;
        ::std::string &whoTmpValue = whoValue;
        {
            char* o129 = 0;
            dbus_message_iter_get_basic(in, &o129);
            whoTmpValue.assign (o129);
        }
        out.setWho(whoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 signalValue;
        int32 &signalTmpValue = signalValue;
        dbus_message_iter_get_basic(in, &signalTmpValue);
        out.setSignal(signalValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ResetFailedUnitRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ResetFailedUnitRequest& in, DBusMessageIter* out) {
    const char* o130 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o130));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ResetFailedUnitRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o131 = 0;
            dbus_message_iter_get_basic(in, &o131);
            nameTmpValue.assign (o131);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetUnitPropertiesRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SetUnitPropertiesRequest& in, DBusMessageIter* out) {
    const char* o132 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o132));
    dbus_bool_t o133 = in.getRuntime() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o133));
    DBusMessageIter o134ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(ss)", &o134ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::property >* o135 = &in.getProperties();
    ::std::vector< ::org::freedesktop::systemd1::Manager::property >::const_iterator o136 = o135->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::property >::const_iterator o137 = o135->begin(); o137 != o136; ++o137) {
        serializeDBus((*o137), &o134ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o134ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::SetUnitPropertiesRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o138 = 0;
            dbus_message_iter_get_basic(in, &o138);
            nameTmpValue.assign (o138);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool runtimeValue;
        bool &runtimeTmpValue = runtimeValue;
        {
            dbus_bool_t o139;
            dbus_message_iter_get_basic(in, &o139);
            runtimeTmpValue = o139 ? true : false;
        }
        out.setRuntime(runtimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::property > propertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o140ArrayIter;
            dbus_message_iter_recurse (in, &o140ArrayIter);

            if(dbus_message_iter_get_arg_type(&o140ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::property o141;
                    if (!deserializeDBus(&o140ArrayIter, o141)) {
                        return false;
                    }
                    propertiesValue.push_back(o141);
                } while (dbus_message_iter_next(&o140ArrayIter));
            }
        }
        out.setProperties(propertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartTransientUnitRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::StartTransientUnitRequest& in, DBusMessageIter* out) {
    const char* o142 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o142));
    const char* o143 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o143));
    DBusMessageIter o144ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(ss)", &o144ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::property >* o145 = &in.getProperties();
    ::std::vector< ::org::freedesktop::systemd1::Manager::property >::const_iterator o146 = o145->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::property >::const_iterator o147 = o145->begin(); o147 != o146; ++o147) {
        serializeDBus((*o147), &o144ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o144ArrayIter));
    DBusMessageIter o148ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sa(ss))", &o148ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::transientunitdata >* o149 = &in.getTransientunitdata();
    ::std::vector< ::org::freedesktop::systemd1::Manager::transientunitdata >::const_iterator o150 = o149->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::transientunitdata >::const_iterator o151 = o149->begin(); o151 != o150; ++o151) {
        serializeDBus((*o151), &o148ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o148ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::StartTransientUnitRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o152 = 0;
            dbus_message_iter_get_basic(in, &o152);
            nameTmpValue.assign (o152);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o153 = 0;
            dbus_message_iter_get_basic(in, &o153);
            modeTmpValue.assign (o153);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::property > propertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o154ArrayIter;
            dbus_message_iter_recurse (in, &o154ArrayIter);

            if(dbus_message_iter_get_arg_type(&o154ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::property o155;
                    if (!deserializeDBus(&o154ArrayIter, o155)) {
                        return false;
                    }
                    propertiesValue.push_back(o155);
                } while (dbus_message_iter_next(&o154ArrayIter));
            }
        }
        out.setProperties(propertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::transientunitdata > transientunitdataValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o156ArrayIter;
            dbus_message_iter_recurse (in, &o156ArrayIter);

            if(dbus_message_iter_get_arg_type(&o156ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::transientunitdata o157;
                    if (!deserializeDBus(&o156ArrayIter, o157)) {
                        return false;
                    }
                    transientunitdataValue.push_back(o157);
                } while (dbus_message_iter_next(&o156ArrayIter));
            }
        }
        out.setTransientunitdata(transientunitdataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartTransientUnitResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::StartTransientUnitResponse& in, DBusMessageIter* out) {
    const char* o158 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o158));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::StartTransientUnitResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o159 = 0;
            dbus_message_iter_get_basic(in, &o159);
            jobTmpValue.assign (o159);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetJobRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GetJobRequest& in, DBusMessageIter* out) {
    uint32 o160 = in.getId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o160));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GetJobRequest& out) {
    {
        uint32 idValue;
        uint32 &idTmpValue = idValue;
        dbus_message_iter_get_basic(in, &idTmpValue);
        out.setId(idValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetJobResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GetJobResponse& in, DBusMessageIter* out) {
    const char* o161 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o161));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GetJobResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o162 = 0;
            dbus_message_iter_get_basic(in, &o162);
            jobTmpValue.assign (o162);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CancelJobRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::CancelJobRequest& in, DBusMessageIter* out) {
    uint32 o163 = in.getId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o163));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::CancelJobRequest& out) {
    {
        uint32 idValue;
        uint32 &idTmpValue = idValue;
        dbus_message_iter_get_basic(in, &idTmpValue);
        out.setId(idValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ListUnitsResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ListUnitsResponse& in, DBusMessageIter* out) {
    DBusMessageIter o164ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sssssssuss)", &o164ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::units >* o165 = &in.getUnits();
    ::std::vector< ::org::freedesktop::systemd1::Manager::units >::const_iterator o166 = o165->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::units >::const_iterator o167 = o165->begin(); o167 != o166; ++o167) {
        serializeDBus((*o167), &o164ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o164ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ListUnitsResponse& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::units > unitsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o168ArrayIter;
            dbus_message_iter_recurse (in, &o168ArrayIter);

            if(dbus_message_iter_get_arg_type(&o168ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::units o169;
                    if (!deserializeDBus(&o168ArrayIter, o169)) {
                        return false;
                    }
                    unitsValue.push_back(o169);
                } while (dbus_message_iter_next(&o168ArrayIter));
            }
        }
        out.setUnits(unitsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ListUnitsFilteredRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ListUnitsFilteredRequest& in, DBusMessageIter* out) {
    DBusMessageIter o170ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o170ArrayIter));
    const ::std::vector< ::std::string >* o171 = &in.getUnitList();
    ::std::vector< ::std::string >::const_iterator o172 = o171->end();
    for (::std::vector< ::std::string >::const_iterator o173 = o171->begin(); o173 != o172; ++o173) {
        const char* o174 = (*o173).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o170ArrayIter, DBUS_TYPE_STRING, &o174));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o170ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ListUnitsFilteredRequest& out) {
    {
        ::std::vector< ::std::string > unitListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o175ArrayIter;
            dbus_message_iter_recurse (in, &o175ArrayIter);

            if(dbus_message_iter_get_arg_type(&o175ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o176;
                    {
                        char* o177 = 0;
                        dbus_message_iter_get_basic(&o175ArrayIter, &o177);
                        o176.assign (o177);
                    }
                    unitListValue.push_back(o176);
                } while (dbus_message_iter_next(&o175ArrayIter));
            }
        }
        out.setUnitList(unitListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ListUnitsFilteredResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ListUnitsFilteredResponse& in, DBusMessageIter* out) {
    DBusMessageIter o178ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sssssssuss)", &o178ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::units >* o179 = &in.getUnits();
    ::std::vector< ::org::freedesktop::systemd1::Manager::units >::const_iterator o180 = o179->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::units >::const_iterator o181 = o179->begin(); o181 != o180; ++o181) {
        serializeDBus((*o181), &o178ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o178ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ListUnitsFilteredResponse& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::units > unitsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o182ArrayIter;
            dbus_message_iter_recurse (in, &o182ArrayIter);

            if(dbus_message_iter_get_arg_type(&o182ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::units o183;
                    if (!deserializeDBus(&o182ArrayIter, o183)) {
                        return false;
                    }
                    unitsValue.push_back(o183);
                } while (dbus_message_iter_next(&o182ArrayIter));
            }
        }
        out.setUnits(unitsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ListJobsResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ListJobsResponse& in, DBusMessageIter* out) {
    DBusMessageIter o184ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(usssss)", &o184ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::jobs >* o185 = &in.getJobs();
    ::std::vector< ::org::freedesktop::systemd1::Manager::jobs >::const_iterator o186 = o185->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::jobs >::const_iterator o187 = o185->begin(); o187 != o186; ++o187) {
        serializeDBus((*o187), &o184ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o184ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ListJobsResponse& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::jobs > jobsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o188ArrayIter;
            dbus_message_iter_recurse (in, &o188ArrayIter);

            if(dbus_message_iter_get_arg_type(&o188ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::jobs o189;
                    if (!deserializeDBus(&o188ArrayIter, o189)) {
                        return false;
                    }
                    jobsValue.push_back(o189);
                } while (dbus_message_iter_next(&o188ArrayIter));
            }
        }
        out.setJobs(jobsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DumpResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::DumpResponse& in, DBusMessageIter* out) {
    const char* o190 = in.getDump().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o190));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::DumpResponse& out) {
    {
        ::std::string dumpValue;
        ::std::string &dumpTmpValue = dumpValue;
        {
            char* o191 = 0;
            dbus_message_iter_get_basic(in, &o191);
            dumpTmpValue.assign (o191);
        }
        out.setDump(dumpValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CreateSnapshotRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::CreateSnapshotRequest& in, DBusMessageIter* out) {
    const char* o192 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o192));
    dbus_bool_t o193 = in.getCleanup() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o193));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::CreateSnapshotRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o194 = 0;
            dbus_message_iter_get_basic(in, &o194);
            nameTmpValue.assign (o194);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool cleanupValue;
        bool &cleanupTmpValue = cleanupValue;
        {
            dbus_bool_t o195;
            dbus_message_iter_get_basic(in, &o195);
            cleanupTmpValue = o195 ? true : false;
        }
        out.setCleanup(cleanupValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CreateSnapshotResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::CreateSnapshotResponse& in, DBusMessageIter* out) {
    const char* o196 = in.getUnit().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o196));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::CreateSnapshotResponse& out) {
    {
        ::std::string unitValue;
        ::std::string &unitTmpValue = unitValue;
        {
            char* o197 = 0;
            dbus_message_iter_get_basic(in, &o197);
            unitTmpValue.assign (o197);
        }
        out.setUnit(unitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RemoveSnapshotRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::RemoveSnapshotRequest& in, DBusMessageIter* out) {
    const char* o198 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o198));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::RemoveSnapshotRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o199 = 0;
            dbus_message_iter_get_basic(in, &o199);
            nameTmpValue.assign (o199);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SwitchRootRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SwitchRootRequest& in, DBusMessageIter* out) {
    const char* o200 = in.getNew_root().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o200));
    const char* o201 = in.getInit().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o201));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::SwitchRootRequest& out) {
    {
        ::std::string new_rootValue;
        ::std::string &new_rootTmpValue = new_rootValue;
        {
            char* o202 = 0;
            dbus_message_iter_get_basic(in, &o202);
            new_rootTmpValue.assign (o202);
        }
        out.setNew_root(new_rootValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string initValue;
        ::std::string &initTmpValue = initValue;
        {
            char* o203 = 0;
            dbus_message_iter_get_basic(in, &o203);
            initTmpValue.assign (o203);
        }
        out.setInit(initValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetEnvironmentRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SetEnvironmentRequest& in, DBusMessageIter* out) {
    DBusMessageIter o204ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o204ArrayIter));
    const ::std::vector< ::std::string >* o205 = &in.getNames();
    ::std::vector< ::std::string >::const_iterator o206 = o205->end();
    for (::std::vector< ::std::string >::const_iterator o207 = o205->begin(); o207 != o206; ++o207) {
        const char* o208 = (*o207).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o204ArrayIter, DBUS_TYPE_STRING, &o208));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o204ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::SetEnvironmentRequest& out) {
    {
        ::std::vector< ::std::string > namesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o209ArrayIter;
            dbus_message_iter_recurse (in, &o209ArrayIter);

            if(dbus_message_iter_get_arg_type(&o209ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o210;
                    {
                        char* o211 = 0;
                        dbus_message_iter_get_basic(&o209ArrayIter, &o211);
                        o210.assign (o211);
                    }
                    namesValue.push_back(o210);
                } while (dbus_message_iter_next(&o209ArrayIter));
            }
        }
        out.setNames(namesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnsetEnvironmentRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnsetEnvironmentRequest& in, DBusMessageIter* out) {
    DBusMessageIter o212ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o212ArrayIter));
    const ::std::vector< ::std::string >* o213 = &in.getNames();
    ::std::vector< ::std::string >::const_iterator o214 = o213->end();
    for (::std::vector< ::std::string >::const_iterator o215 = o213->begin(); o215 != o214; ++o215) {
        const char* o216 = (*o215).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o212ArrayIter, DBUS_TYPE_STRING, &o216));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o212ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UnsetEnvironmentRequest& out) {
    {
        ::std::vector< ::std::string > namesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o217ArrayIter;
            dbus_message_iter_recurse (in, &o217ArrayIter);

            if(dbus_message_iter_get_arg_type(&o217ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o218;
                    {
                        char* o219 = 0;
                        dbus_message_iter_get_basic(&o217ArrayIter, &o219);
                        o218.assign (o219);
                    }
                    namesValue.push_back(o218);
                } while (dbus_message_iter_next(&o217ArrayIter));
            }
        }
        out.setNames(namesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnsetAndSetEnvironmentRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnsetAndSetEnvironmentRequest& in, DBusMessageIter* out) {
    DBusMessageIter o220ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o220ArrayIter));
    const ::std::vector< ::std::string >* o221 = &in.getUnset();
    ::std::vector< ::std::string >::const_iterator o222 = o221->end();
    for (::std::vector< ::std::string >::const_iterator o223 = o221->begin(); o223 != o222; ++o223) {
        const char* o224 = (*o223).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o220ArrayIter, DBUS_TYPE_STRING, &o224));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o220ArrayIter));
    DBusMessageIter o225ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o225ArrayIter));
    const ::std::vector< ::std::string >* o226 = &in.getSet();
    ::std::vector< ::std::string >::const_iterator o227 = o226->end();
    for (::std::vector< ::std::string >::const_iterator o228 = o226->begin(); o228 != o227; ++o228) {
        const char* o229 = (*o228).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o225ArrayIter, DBUS_TYPE_STRING, &o229));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o225ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UnsetAndSetEnvironmentRequest& out) {
    {
        ::std::vector< ::std::string > unsetValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o230ArrayIter;
            dbus_message_iter_recurse (in, &o230ArrayIter);

            if(dbus_message_iter_get_arg_type(&o230ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o231;
                    {
                        char* o232 = 0;
                        dbus_message_iter_get_basic(&o230ArrayIter, &o232);
                        o231.assign (o232);
                    }
                    unsetValue.push_back(o231);
                } while (dbus_message_iter_next(&o230ArrayIter));
            }
        }
        out.setUnset(unsetValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::std::string > setValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o233ArrayIter;
            dbus_message_iter_recurse (in, &o233ArrayIter);

            if(dbus_message_iter_get_arg_type(&o233ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o234;
                    {
                        char* o235 = 0;
                        dbus_message_iter_get_basic(&o233ArrayIter, &o235);
                        o234.assign (o235);
                    }
                    setValue.push_back(o234);
                } while (dbus_message_iter_next(&o233ArrayIter));
            }
        }
        out.setSet(setValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ListUnitFilesResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ListUnitFilesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o236ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(ss)", &o236ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::files >* o237 = &in.getFiles();
    ::std::vector< ::org::freedesktop::systemd1::Manager::files >::const_iterator o238 = o237->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::files >::const_iterator o239 = o237->begin(); o239 != o238; ++o239) {
        serializeDBus((*o239), &o236ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o236ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ListUnitFilesResponse& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::files > filesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o240ArrayIter;
            dbus_message_iter_recurse (in, &o240ArrayIter);

            if(dbus_message_iter_get_arg_type(&o240ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::files o241;
                    if (!deserializeDBus(&o240ArrayIter, o241)) {
                        return false;
                    }
                    filesValue.push_back(o241);
                } while (dbus_message_iter_next(&o240ArrayIter));
            }
        }
        out.setFiles(filesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetUnitFileStateRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GetUnitFileStateRequest& in, DBusMessageIter* out) {
    const char* o242 = in.getFile().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o242));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GetUnitFileStateRequest& out) {
    {
        ::std::string fileValue;
        ::std::string &fileTmpValue = fileValue;
        {
            char* o243 = 0;
            dbus_message_iter_get_basic(in, &o243);
            fileTmpValue.assign (o243);
        }
        out.setFile(fileValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetUnitFileStateResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GetUnitFileStateResponse& in, DBusMessageIter* out) {
    const char* o244 = in.getState().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o244));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GetUnitFileStateResponse& out) {
    {
        ::std::string stateValue;
        ::std::string &stateTmpValue = stateValue;
        {
            char* o245 = 0;
            dbus_message_iter_get_basic(in, &o245);
            stateTmpValue.assign (o245);
        }
        out.setState(stateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EnableUnitFilesRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::EnableUnitFilesRequest& in, DBusMessageIter* out) {
    DBusMessageIter o246ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o246ArrayIter));
    const ::std::vector< ::std::string >* o247 = &in.getFiles();
    ::std::vector< ::std::string >::const_iterator o248 = o247->end();
    for (::std::vector< ::std::string >::const_iterator o249 = o247->begin(); o249 != o248; ++o249) {
        const char* o250 = (*o249).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o246ArrayIter, DBUS_TYPE_STRING, &o250));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o246ArrayIter));
    dbus_bool_t o251 = in.getRuntime() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o251));
    dbus_bool_t o252 = in.getForce() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o252));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::EnableUnitFilesRequest& out) {
    {
        ::std::vector< ::std::string > filesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o253ArrayIter;
            dbus_message_iter_recurse (in, &o253ArrayIter);

            if(dbus_message_iter_get_arg_type(&o253ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o254;
                    {
                        char* o255 = 0;
                        dbus_message_iter_get_basic(&o253ArrayIter, &o255);
                        o254.assign (o255);
                    }
                    filesValue.push_back(o254);
                } while (dbus_message_iter_next(&o253ArrayIter));
            }
        }
        out.setFiles(filesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool runtimeValue;
        bool &runtimeTmpValue = runtimeValue;
        {
            dbus_bool_t o256;
            dbus_message_iter_get_basic(in, &o256);
            runtimeTmpValue = o256 ? true : false;
        }
        out.setRuntime(runtimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool forceValue;
        bool &forceTmpValue = forceValue;
        {
            dbus_bool_t o257;
            dbus_message_iter_get_basic(in, &o257);
            forceTmpValue = o257 ? true : false;
        }
        out.setForce(forceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EnableUnitFilesResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::EnableUnitFilesResponse& in, DBusMessageIter* out) {
    dbus_bool_t o258 = in.getCarries_install_info() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o258));
    DBusMessageIter o259ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o259ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >* o260 = &in.getChanges();
    ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o261 = o260->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o262 = o260->begin(); o262 != o261; ++o262) {
        serializeDBus((*o262), &o259ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o259ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::EnableUnitFilesResponse& out) {
    {
        bool carries_install_infoValue;
        bool &carries_install_infoTmpValue = carries_install_infoValue;
        {
            dbus_bool_t o263;
            dbus_message_iter_get_basic(in, &o263);
            carries_install_infoTmpValue = o263 ? true : false;
        }
        out.setCarries_install_info(carries_install_infoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::changes > changesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o264ArrayIter;
            dbus_message_iter_recurse (in, &o264ArrayIter);

            if(dbus_message_iter_get_arg_type(&o264ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::changes o265;
                    if (!deserializeDBus(&o264ArrayIter, o265)) {
                        return false;
                    }
                    changesValue.push_back(o265);
                } while (dbus_message_iter_next(&o264ArrayIter));
            }
        }
        out.setChanges(changesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DisableUnitFilesRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::DisableUnitFilesRequest& in, DBusMessageIter* out) {
    DBusMessageIter o266ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o266ArrayIter));
    const ::std::vector< ::std::string >* o267 = &in.getFiles();
    ::std::vector< ::std::string >::const_iterator o268 = o267->end();
    for (::std::vector< ::std::string >::const_iterator o269 = o267->begin(); o269 != o268; ++o269) {
        const char* o270 = (*o269).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o266ArrayIter, DBUS_TYPE_STRING, &o270));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o266ArrayIter));
    dbus_bool_t o271 = in.getRuntime() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o271));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::DisableUnitFilesRequest& out) {
    {
        ::std::vector< ::std::string > filesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o272ArrayIter;
            dbus_message_iter_recurse (in, &o272ArrayIter);

            if(dbus_message_iter_get_arg_type(&o272ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o273;
                    {
                        char* o274 = 0;
                        dbus_message_iter_get_basic(&o272ArrayIter, &o274);
                        o273.assign (o274);
                    }
                    filesValue.push_back(o273);
                } while (dbus_message_iter_next(&o272ArrayIter));
            }
        }
        out.setFiles(filesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool runtimeValue;
        bool &runtimeTmpValue = runtimeValue;
        {
            dbus_bool_t o275;
            dbus_message_iter_get_basic(in, &o275);
            runtimeTmpValue = o275 ? true : false;
        }
        out.setRuntime(runtimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DisableUnitFilesResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::DisableUnitFilesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o276ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o276ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >* o277 = &in.getChanges();
    ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o278 = o277->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o279 = o277->begin(); o279 != o278; ++o279) {
        serializeDBus((*o279), &o276ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o276ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::DisableUnitFilesResponse& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::changes > changesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o280ArrayIter;
            dbus_message_iter_recurse (in, &o280ArrayIter);

            if(dbus_message_iter_get_arg_type(&o280ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::changes o281;
                    if (!deserializeDBus(&o280ArrayIter, o281)) {
                        return false;
                    }
                    changesValue.push_back(o281);
                } while (dbus_message_iter_next(&o280ArrayIter));
            }
        }
        out.setChanges(changesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReenableUnitFilesRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ReenableUnitFilesRequest& in, DBusMessageIter* out) {
    DBusMessageIter o282ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o282ArrayIter));
    const ::std::vector< ::std::string >* o283 = &in.getFiles();
    ::std::vector< ::std::string >::const_iterator o284 = o283->end();
    for (::std::vector< ::std::string >::const_iterator o285 = o283->begin(); o285 != o284; ++o285) {
        const char* o286 = (*o285).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o282ArrayIter, DBUS_TYPE_STRING, &o286));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o282ArrayIter));
    dbus_bool_t o287 = in.getRuntime() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o287));
    dbus_bool_t o288 = in.getForce() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o288));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ReenableUnitFilesRequest& out) {
    {
        ::std::vector< ::std::string > filesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o289ArrayIter;
            dbus_message_iter_recurse (in, &o289ArrayIter);

            if(dbus_message_iter_get_arg_type(&o289ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o290;
                    {
                        char* o291 = 0;
                        dbus_message_iter_get_basic(&o289ArrayIter, &o291);
                        o290.assign (o291);
                    }
                    filesValue.push_back(o290);
                } while (dbus_message_iter_next(&o289ArrayIter));
            }
        }
        out.setFiles(filesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool runtimeValue;
        bool &runtimeTmpValue = runtimeValue;
        {
            dbus_bool_t o292;
            dbus_message_iter_get_basic(in, &o292);
            runtimeTmpValue = o292 ? true : false;
        }
        out.setRuntime(runtimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool forceValue;
        bool &forceTmpValue = forceValue;
        {
            dbus_bool_t o293;
            dbus_message_iter_get_basic(in, &o293);
            forceTmpValue = o293 ? true : false;
        }
        out.setForce(forceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReenableUnitFilesResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ReenableUnitFilesResponse& in, DBusMessageIter* out) {
    dbus_bool_t o294 = in.getCarries_install_info() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o294));
    DBusMessageIter o295ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o295ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >* o296 = &in.getChanges();
    ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o297 = o296->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o298 = o296->begin(); o298 != o297; ++o298) {
        serializeDBus((*o298), &o295ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o295ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ReenableUnitFilesResponse& out) {
    {
        bool carries_install_infoValue;
        bool &carries_install_infoTmpValue = carries_install_infoValue;
        {
            dbus_bool_t o299;
            dbus_message_iter_get_basic(in, &o299);
            carries_install_infoTmpValue = o299 ? true : false;
        }
        out.setCarries_install_info(carries_install_infoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::changes > changesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o300ArrayIter;
            dbus_message_iter_recurse (in, &o300ArrayIter);

            if(dbus_message_iter_get_arg_type(&o300ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::changes o301;
                    if (!deserializeDBus(&o300ArrayIter, o301)) {
                        return false;
                    }
                    changesValue.push_back(o301);
                } while (dbus_message_iter_next(&o300ArrayIter));
            }
        }
        out.setChanges(changesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LinkUnitFilesRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::LinkUnitFilesRequest& in, DBusMessageIter* out) {
    DBusMessageIter o302ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o302ArrayIter));
    const ::std::vector< ::std::string >* o303 = &in.getFiles();
    ::std::vector< ::std::string >::const_iterator o304 = o303->end();
    for (::std::vector< ::std::string >::const_iterator o305 = o303->begin(); o305 != o304; ++o305) {
        const char* o306 = (*o305).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o302ArrayIter, DBUS_TYPE_STRING, &o306));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o302ArrayIter));
    dbus_bool_t o307 = in.getRuntime() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o307));
    dbus_bool_t o308 = in.getForce() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o308));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::LinkUnitFilesRequest& out) {
    {
        ::std::vector< ::std::string > filesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o309ArrayIter;
            dbus_message_iter_recurse (in, &o309ArrayIter);

            if(dbus_message_iter_get_arg_type(&o309ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o310;
                    {
                        char* o311 = 0;
                        dbus_message_iter_get_basic(&o309ArrayIter, &o311);
                        o310.assign (o311);
                    }
                    filesValue.push_back(o310);
                } while (dbus_message_iter_next(&o309ArrayIter));
            }
        }
        out.setFiles(filesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool runtimeValue;
        bool &runtimeTmpValue = runtimeValue;
        {
            dbus_bool_t o312;
            dbus_message_iter_get_basic(in, &o312);
            runtimeTmpValue = o312 ? true : false;
        }
        out.setRuntime(runtimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool forceValue;
        bool &forceTmpValue = forceValue;
        {
            dbus_bool_t o313;
            dbus_message_iter_get_basic(in, &o313);
            forceTmpValue = o313 ? true : false;
        }
        out.setForce(forceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LinkUnitFilesResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::LinkUnitFilesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o314ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o314ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >* o315 = &in.getChanges();
    ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o316 = o315->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o317 = o315->begin(); o317 != o316; ++o317) {
        serializeDBus((*o317), &o314ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o314ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::LinkUnitFilesResponse& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::changes > changesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o318ArrayIter;
            dbus_message_iter_recurse (in, &o318ArrayIter);

            if(dbus_message_iter_get_arg_type(&o318ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::changes o319;
                    if (!deserializeDBus(&o318ArrayIter, o319)) {
                        return false;
                    }
                    changesValue.push_back(o319);
                } while (dbus_message_iter_next(&o318ArrayIter));
            }
        }
        out.setChanges(changesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PresetUnitFilesRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::PresetUnitFilesRequest& in, DBusMessageIter* out) {
    DBusMessageIter o320ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o320ArrayIter));
    const ::std::vector< ::std::string >* o321 = &in.getFiles();
    ::std::vector< ::std::string >::const_iterator o322 = o321->end();
    for (::std::vector< ::std::string >::const_iterator o323 = o321->begin(); o323 != o322; ++o323) {
        const char* o324 = (*o323).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o320ArrayIter, DBUS_TYPE_STRING, &o324));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o320ArrayIter));
    dbus_bool_t o325 = in.getRuntime() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o325));
    dbus_bool_t o326 = in.getForce() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o326));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::PresetUnitFilesRequest& out) {
    {
        ::std::vector< ::std::string > filesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o327ArrayIter;
            dbus_message_iter_recurse (in, &o327ArrayIter);

            if(dbus_message_iter_get_arg_type(&o327ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o328;
                    {
                        char* o329 = 0;
                        dbus_message_iter_get_basic(&o327ArrayIter, &o329);
                        o328.assign (o329);
                    }
                    filesValue.push_back(o328);
                } while (dbus_message_iter_next(&o327ArrayIter));
            }
        }
        out.setFiles(filesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool runtimeValue;
        bool &runtimeTmpValue = runtimeValue;
        {
            dbus_bool_t o330;
            dbus_message_iter_get_basic(in, &o330);
            runtimeTmpValue = o330 ? true : false;
        }
        out.setRuntime(runtimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool forceValue;
        bool &forceTmpValue = forceValue;
        {
            dbus_bool_t o331;
            dbus_message_iter_get_basic(in, &o331);
            forceTmpValue = o331 ? true : false;
        }
        out.setForce(forceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PresetUnitFilesResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::PresetUnitFilesResponse& in, DBusMessageIter* out) {
    dbus_bool_t o332 = in.getCarries_install_info() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o332));
    DBusMessageIter o333ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o333ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >* o334 = &in.getChanges();
    ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o335 = o334->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o336 = o334->begin(); o336 != o335; ++o336) {
        serializeDBus((*o336), &o333ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o333ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::PresetUnitFilesResponse& out) {
    {
        bool carries_install_infoValue;
        bool &carries_install_infoTmpValue = carries_install_infoValue;
        {
            dbus_bool_t o337;
            dbus_message_iter_get_basic(in, &o337);
            carries_install_infoTmpValue = o337 ? true : false;
        }
        out.setCarries_install_info(carries_install_infoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::changes > changesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o338ArrayIter;
            dbus_message_iter_recurse (in, &o338ArrayIter);

            if(dbus_message_iter_get_arg_type(&o338ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::changes o339;
                    if (!deserializeDBus(&o338ArrayIter, o339)) {
                        return false;
                    }
                    changesValue.push_back(o339);
                } while (dbus_message_iter_next(&o338ArrayIter));
            }
        }
        out.setChanges(changesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PresetUnitFilesWithModeRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::PresetUnitFilesWithModeRequest& in, DBusMessageIter* out) {
    DBusMessageIter o340ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o340ArrayIter));
    const ::std::vector< ::std::string >* o341 = &in.getFiles();
    ::std::vector< ::std::string >::const_iterator o342 = o341->end();
    for (::std::vector< ::std::string >::const_iterator o343 = o341->begin(); o343 != o342; ++o343) {
        const char* o344 = (*o343).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o340ArrayIter, DBUS_TYPE_STRING, &o344));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o340ArrayIter));
    const char* o345 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o345));
    dbus_bool_t o346 = in.getRuntime() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o346));
    dbus_bool_t o347 = in.getForce() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o347));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::PresetUnitFilesWithModeRequest& out) {
    {
        ::std::vector< ::std::string > filesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o348ArrayIter;
            dbus_message_iter_recurse (in, &o348ArrayIter);

            if(dbus_message_iter_get_arg_type(&o348ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o349;
                    {
                        char* o350 = 0;
                        dbus_message_iter_get_basic(&o348ArrayIter, &o350);
                        o349.assign (o350);
                    }
                    filesValue.push_back(o349);
                } while (dbus_message_iter_next(&o348ArrayIter));
            }
        }
        out.setFiles(filesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o351 = 0;
            dbus_message_iter_get_basic(in, &o351);
            modeTmpValue.assign (o351);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool runtimeValue;
        bool &runtimeTmpValue = runtimeValue;
        {
            dbus_bool_t o352;
            dbus_message_iter_get_basic(in, &o352);
            runtimeTmpValue = o352 ? true : false;
        }
        out.setRuntime(runtimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool forceValue;
        bool &forceTmpValue = forceValue;
        {
            dbus_bool_t o353;
            dbus_message_iter_get_basic(in, &o353);
            forceTmpValue = o353 ? true : false;
        }
        out.setForce(forceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PresetUnitFilesWithModeResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::PresetUnitFilesWithModeResponse& in, DBusMessageIter* out) {
    dbus_bool_t o354 = in.getCarries_install_info() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o354));
    DBusMessageIter o355ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o355ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >* o356 = &in.getChanges();
    ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o357 = o356->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o358 = o356->begin(); o358 != o357; ++o358) {
        serializeDBus((*o358), &o355ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o355ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::PresetUnitFilesWithModeResponse& out) {
    {
        bool carries_install_infoValue;
        bool &carries_install_infoTmpValue = carries_install_infoValue;
        {
            dbus_bool_t o359;
            dbus_message_iter_get_basic(in, &o359);
            carries_install_infoTmpValue = o359 ? true : false;
        }
        out.setCarries_install_info(carries_install_infoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::changes > changesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o360ArrayIter;
            dbus_message_iter_recurse (in, &o360ArrayIter);

            if(dbus_message_iter_get_arg_type(&o360ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::changes o361;
                    if (!deserializeDBus(&o360ArrayIter, o361)) {
                        return false;
                    }
                    changesValue.push_back(o361);
                } while (dbus_message_iter_next(&o360ArrayIter));
            }
        }
        out.setChanges(changesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MaskUnitFilesRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::MaskUnitFilesRequest& in, DBusMessageIter* out) {
    DBusMessageIter o362ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o362ArrayIter));
    const ::std::vector< ::std::string >* o363 = &in.getFiles();
    ::std::vector< ::std::string >::const_iterator o364 = o363->end();
    for (::std::vector< ::std::string >::const_iterator o365 = o363->begin(); o365 != o364; ++o365) {
        const char* o366 = (*o365).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o362ArrayIter, DBUS_TYPE_STRING, &o366));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o362ArrayIter));
    dbus_bool_t o367 = in.getRuntime() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o367));
    dbus_bool_t o368 = in.getForce() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o368));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::MaskUnitFilesRequest& out) {
    {
        ::std::vector< ::std::string > filesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o369ArrayIter;
            dbus_message_iter_recurse (in, &o369ArrayIter);

            if(dbus_message_iter_get_arg_type(&o369ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o370;
                    {
                        char* o371 = 0;
                        dbus_message_iter_get_basic(&o369ArrayIter, &o371);
                        o370.assign (o371);
                    }
                    filesValue.push_back(o370);
                } while (dbus_message_iter_next(&o369ArrayIter));
            }
        }
        out.setFiles(filesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool runtimeValue;
        bool &runtimeTmpValue = runtimeValue;
        {
            dbus_bool_t o372;
            dbus_message_iter_get_basic(in, &o372);
            runtimeTmpValue = o372 ? true : false;
        }
        out.setRuntime(runtimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool forceValue;
        bool &forceTmpValue = forceValue;
        {
            dbus_bool_t o373;
            dbus_message_iter_get_basic(in, &o373);
            forceTmpValue = o373 ? true : false;
        }
        out.setForce(forceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MaskUnitFilesResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::MaskUnitFilesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o374ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o374ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >* o375 = &in.getChanges();
    ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o376 = o375->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o377 = o375->begin(); o377 != o376; ++o377) {
        serializeDBus((*o377), &o374ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o374ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::MaskUnitFilesResponse& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::changes > changesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o378ArrayIter;
            dbus_message_iter_recurse (in, &o378ArrayIter);

            if(dbus_message_iter_get_arg_type(&o378ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::changes o379;
                    if (!deserializeDBus(&o378ArrayIter, o379)) {
                        return false;
                    }
                    changesValue.push_back(o379);
                } while (dbus_message_iter_next(&o378ArrayIter));
            }
        }
        out.setChanges(changesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnmaskUnitFilesRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnmaskUnitFilesRequest& in, DBusMessageIter* out) {
    DBusMessageIter o380ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o380ArrayIter));
    const ::std::vector< ::std::string >* o381 = &in.getFiles();
    ::std::vector< ::std::string >::const_iterator o382 = o381->end();
    for (::std::vector< ::std::string >::const_iterator o383 = o381->begin(); o383 != o382; ++o383) {
        const char* o384 = (*o383).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o380ArrayIter, DBUS_TYPE_STRING, &o384));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o380ArrayIter));
    dbus_bool_t o385 = in.getRuntime() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o385));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UnmaskUnitFilesRequest& out) {
    {
        ::std::vector< ::std::string > filesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o386ArrayIter;
            dbus_message_iter_recurse (in, &o386ArrayIter);

            if(dbus_message_iter_get_arg_type(&o386ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o387;
                    {
                        char* o388 = 0;
                        dbus_message_iter_get_basic(&o386ArrayIter, &o388);
                        o387.assign (o388);
                    }
                    filesValue.push_back(o387);
                } while (dbus_message_iter_next(&o386ArrayIter));
            }
        }
        out.setFiles(filesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool runtimeValue;
        bool &runtimeTmpValue = runtimeValue;
        {
            dbus_bool_t o389;
            dbus_message_iter_get_basic(in, &o389);
            runtimeTmpValue = o389 ? true : false;
        }
        out.setRuntime(runtimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnmaskUnitFilesResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnmaskUnitFilesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o390ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o390ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >* o391 = &in.getChanges();
    ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o392 = o391->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o393 = o391->begin(); o393 != o392; ++o393) {
        serializeDBus((*o393), &o390ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o390ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UnmaskUnitFilesResponse& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::changes > changesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o394ArrayIter;
            dbus_message_iter_recurse (in, &o394ArrayIter);

            if(dbus_message_iter_get_arg_type(&o394ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::changes o395;
                    if (!deserializeDBus(&o394ArrayIter, o395)) {
                        return false;
                    }
                    changesValue.push_back(o395);
                } while (dbus_message_iter_next(&o394ArrayIter));
            }
        }
        out.setChanges(changesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetDefaultTargetRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SetDefaultTargetRequest& in, DBusMessageIter* out) {
    const char* o396 = in.getArg_0().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o396));
    dbus_bool_t o397 = in.getArg_1() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o397));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::SetDefaultTargetRequest& out) {
    {
        ::std::string arg_0Value;
        ::std::string &arg_0TmpValue = arg_0Value;
        {
            char* o398 = 0;
            dbus_message_iter_get_basic(in, &o398);
            arg_0TmpValue.assign (o398);
        }
        out.setArg_0(arg_0Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool arg_1Value;
        bool &arg_1TmpValue = arg_1Value;
        {
            dbus_bool_t o399;
            dbus_message_iter_get_basic(in, &o399);
            arg_1TmpValue = o399 ? true : false;
        }
        out.setArg_1(arg_1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetDefaultTargetResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SetDefaultTargetResponse& in, DBusMessageIter* out) {
    DBusMessageIter o400ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o400ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >* o401 = &in.getChanges();
    ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o402 = o401->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o403 = o401->begin(); o403 != o402; ++o403) {
        serializeDBus((*o403), &o400ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o400ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::SetDefaultTargetResponse& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::changes > changesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o404ArrayIter;
            dbus_message_iter_recurse (in, &o404ArrayIter);

            if(dbus_message_iter_get_arg_type(&o404ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::changes o405;
                    if (!deserializeDBus(&o404ArrayIter, o405)) {
                        return false;
                    }
                    changesValue.push_back(o405);
                } while (dbus_message_iter_next(&o404ArrayIter));
            }
        }
        out.setChanges(changesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetDefaultTargetResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GetDefaultTargetResponse& in, DBusMessageIter* out) {
    const char* o406 = in.getTargetName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o406));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GetDefaultTargetResponse& out) {
    {
        ::std::string targetNameValue;
        ::std::string &targetNameTmpValue = targetNameValue;
        {
            char* o407 = 0;
            dbus_message_iter_get_basic(in, &o407);
            targetNameTmpValue.assign (o407);
        }
        out.setTargetName(targetNameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PresetAllUnitFilesRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::PresetAllUnitFilesRequest& in, DBusMessageIter* out) {
    const char* o408 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o408));
    dbus_bool_t o409 = in.getRuntime() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o409));
    dbus_bool_t o410 = in.getForce() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o410));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::PresetAllUnitFilesRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o411 = 0;
            dbus_message_iter_get_basic(in, &o411);
            nameTmpValue.assign (o411);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool runtimeValue;
        bool &runtimeTmpValue = runtimeValue;
        {
            dbus_bool_t o412;
            dbus_message_iter_get_basic(in, &o412);
            runtimeTmpValue = o412 ? true : false;
        }
        out.setRuntime(runtimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool forceValue;
        bool &forceTmpValue = forceValue;
        {
            dbus_bool_t o413;
            dbus_message_iter_get_basic(in, &o413);
            forceTmpValue = o413 ? true : false;
        }
        out.setForce(forceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PresetAllUnitFilesResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::PresetAllUnitFilesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o414ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o414ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >* o415 = &in.getChanges();
    ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o416 = o415->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o417 = o415->begin(); o417 != o416; ++o417) {
        serializeDBus((*o417), &o414ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o414ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::PresetAllUnitFilesResponse& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::changes > changesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o418ArrayIter;
            dbus_message_iter_recurse (in, &o418ArrayIter);

            if(dbus_message_iter_get_arg_type(&o418ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::changes o419;
                    if (!deserializeDBus(&o418ArrayIter, o419)) {
                        return false;
                    }
                    changesValue.push_back(o419);
                } while (dbus_message_iter_next(&o418ArrayIter));
            }
        }
        out.setChanges(changesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AddDependencyUnitFilesRequest

void serializeDBus (const ::org::freedesktop::systemd1::Manager::AddDependencyUnitFilesRequest& in, DBusMessageIter* out) {
    DBusMessageIter o420ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o420ArrayIter));
    const ::std::vector< ::std::string >* o421 = &in.getFiles();
    ::std::vector< ::std::string >::const_iterator o422 = o421->end();
    for (::std::vector< ::std::string >::const_iterator o423 = o421->begin(); o423 != o422; ++o423) {
        const char* o424 = (*o423).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o420ArrayIter, DBUS_TYPE_STRING, &o424));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o420ArrayIter));
    const char* o425 = in.getArg_1().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o425));
    const char* o426 = in.getArg_2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o426));
    dbus_bool_t o427 = in.getRuntime() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o427));
    dbus_bool_t o428 = in.getForce() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o428));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::AddDependencyUnitFilesRequest& out) {
    {
        ::std::vector< ::std::string > filesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o429ArrayIter;
            dbus_message_iter_recurse (in, &o429ArrayIter);

            if(dbus_message_iter_get_arg_type(&o429ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o430;
                    {
                        char* o431 = 0;
                        dbus_message_iter_get_basic(&o429ArrayIter, &o431);
                        o430.assign (o431);
                    }
                    filesValue.push_back(o430);
                } while (dbus_message_iter_next(&o429ArrayIter));
            }
        }
        out.setFiles(filesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string arg_1Value;
        ::std::string &arg_1TmpValue = arg_1Value;
        {
            char* o432 = 0;
            dbus_message_iter_get_basic(in, &o432);
            arg_1TmpValue.assign (o432);
        }
        out.setArg_1(arg_1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string arg_2Value;
        ::std::string &arg_2TmpValue = arg_2Value;
        {
            char* o433 = 0;
            dbus_message_iter_get_basic(in, &o433);
            arg_2TmpValue.assign (o433);
        }
        out.setArg_2(arg_2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool runtimeValue;
        bool &runtimeTmpValue = runtimeValue;
        {
            dbus_bool_t o434;
            dbus_message_iter_get_basic(in, &o434);
            runtimeTmpValue = o434 ? true : false;
        }
        out.setRuntime(runtimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool forceValue;
        bool &forceTmpValue = forceValue;
        {
            dbus_bool_t o435;
            dbus_message_iter_get_basic(in, &o435);
            forceTmpValue = o435 ? true : false;
        }
        out.setForce(forceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AddDependencyUnitFilesResponse

void serializeDBus (const ::org::freedesktop::systemd1::Manager::AddDependencyUnitFilesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o436ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o436ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Manager::changes >* o437 = &in.getChanges();
    ::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o438 = o437->end();
    for (::std::vector< ::org::freedesktop::systemd1::Manager::changes >::const_iterator o439 = o437->begin(); o439 != o438; ++o439) {
        serializeDBus((*o439), &o436ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o436ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::AddDependencyUnitFilesResponse& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Manager::changes > changesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o440ArrayIter;
            dbus_message_iter_recurse (in, &o440ArrayIter);

            if(dbus_message_iter_get_arg_type(&o440ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Manager::changes o441;
                    if (!deserializeDBus(&o440ArrayIter, o441)) {
                        return false;
                    }
                    changesValue.push_back(o441);
                } while (dbus_message_iter_next(&o440ArrayIter));
            }
        }
        out.setChanges(changesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VersionUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::VersionUpdate& in, DBusMessageIter* out) {
    const char* o442 = in.getVersion().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o442));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::VersionUpdate& out) {
    {
        ::std::string VersionValue;
        ::std::string &VersionTmpValue = VersionValue;
        {
            char* o443 = 0;
            dbus_message_iter_get_basic(in, &o443);
            VersionTmpValue.assign (o443);
        }
        out.setVersion(VersionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VersionRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::VersionRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::VersionRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of FeaturesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::FeaturesUpdate& in, DBusMessageIter* out) {
    const char* o444 = in.getFeatures().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o444));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::FeaturesUpdate& out) {
    {
        ::std::string FeaturesValue;
        ::std::string &FeaturesTmpValue = FeaturesValue;
        {
            char* o445 = 0;
            dbus_message_iter_get_basic(in, &o445);
            FeaturesTmpValue.assign (o445);
        }
        out.setFeatures(FeaturesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FeaturesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::FeaturesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::FeaturesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of VirtualizationUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::VirtualizationUpdate& in, DBusMessageIter* out) {
    const char* o446 = in.getVirtualization().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o446));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::VirtualizationUpdate& out) {
    {
        ::std::string VirtualizationValue;
        ::std::string &VirtualizationTmpValue = VirtualizationValue;
        {
            char* o447 = 0;
            dbus_message_iter_get_basic(in, &o447);
            VirtualizationTmpValue.assign (o447);
        }
        out.setVirtualization(VirtualizationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VirtualizationRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::VirtualizationRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::VirtualizationRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ArchitectureUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ArchitectureUpdate& in, DBusMessageIter* out) {
    const char* o448 = in.getArchitecture().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o448));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ArchitectureUpdate& out) {
    {
        ::std::string ArchitectureValue;
        ::std::string &ArchitectureTmpValue = ArchitectureValue;
        {
            char* o449 = 0;
            dbus_message_iter_get_basic(in, &o449);
            ArchitectureTmpValue.assign (o449);
        }
        out.setArchitecture(ArchitectureValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ArchitectureRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ArchitectureRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::ArchitectureRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TaintedUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::TaintedUpdate& in, DBusMessageIter* out) {
    const char* o450 = in.getTainted().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o450));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::TaintedUpdate& out) {
    {
        ::std::string TaintedValue;
        ::std::string &TaintedTmpValue = TaintedValue;
        {
            char* o451 = 0;
            dbus_message_iter_get_basic(in, &o451);
            TaintedTmpValue.assign (o451);
        }
        out.setTainted(TaintedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TaintedRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::TaintedRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::TaintedRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of FirmwareTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::FirmwareTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o452 = in.getFirmwareTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o452));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::FirmwareTimestampUpdate& out) {
    {
        uint64 FirmwareTimestampValue;
        uint64 &FirmwareTimestampTmpValue = FirmwareTimestampValue;
        dbus_message_iter_get_basic(in, &FirmwareTimestampTmpValue);
        out.setFirmwareTimestamp(FirmwareTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FirmwareTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::FirmwareTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::FirmwareTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of FirmwareTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::FirmwareTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o453 = in.getFirmwareTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o453));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::FirmwareTimestampMonotonicUpdate& out) {
    {
        uint64 FirmwareTimestampMonotonicValue;
        uint64 &FirmwareTimestampMonotonicTmpValue = FirmwareTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &FirmwareTimestampMonotonicTmpValue);
        out.setFirmwareTimestampMonotonic(FirmwareTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FirmwareTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::FirmwareTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::FirmwareTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LoaderTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::LoaderTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o454 = in.getLoaderTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o454));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::LoaderTimestampUpdate& out) {
    {
        uint64 LoaderTimestampValue;
        uint64 &LoaderTimestampTmpValue = LoaderTimestampValue;
        dbus_message_iter_get_basic(in, &LoaderTimestampTmpValue);
        out.setLoaderTimestamp(LoaderTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LoaderTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::LoaderTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::LoaderTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LoaderTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::LoaderTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o455 = in.getLoaderTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o455));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::LoaderTimestampMonotonicUpdate& out) {
    {
        uint64 LoaderTimestampMonotonicValue;
        uint64 &LoaderTimestampMonotonicTmpValue = LoaderTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &LoaderTimestampMonotonicTmpValue);
        out.setLoaderTimestampMonotonic(LoaderTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LoaderTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::LoaderTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::LoaderTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of KernelTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::KernelTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o456 = in.getKernelTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o456));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::KernelTimestampUpdate& out) {
    {
        uint64 KernelTimestampValue;
        uint64 &KernelTimestampTmpValue = KernelTimestampValue;
        dbus_message_iter_get_basic(in, &KernelTimestampTmpValue);
        out.setKernelTimestamp(KernelTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of KernelTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::KernelTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::KernelTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of KernelTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::KernelTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o457 = in.getKernelTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o457));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::KernelTimestampMonotonicUpdate& out) {
    {
        uint64 KernelTimestampMonotonicValue;
        uint64 &KernelTimestampMonotonicTmpValue = KernelTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &KernelTimestampMonotonicTmpValue);
        out.setKernelTimestampMonotonic(KernelTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of KernelTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::KernelTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::KernelTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of InitRDTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::InitRDTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o458 = in.getInitRDTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o458));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::InitRDTimestampUpdate& out) {
    {
        uint64 InitRDTimestampValue;
        uint64 &InitRDTimestampTmpValue = InitRDTimestampValue;
        dbus_message_iter_get_basic(in, &InitRDTimestampTmpValue);
        out.setInitRDTimestamp(InitRDTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of InitRDTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::InitRDTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::InitRDTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of InitRDTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::InitRDTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o459 = in.getInitRDTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o459));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::InitRDTimestampMonotonicUpdate& out) {
    {
        uint64 InitRDTimestampMonotonicValue;
        uint64 &InitRDTimestampMonotonicTmpValue = InitRDTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &InitRDTimestampMonotonicTmpValue);
        out.setInitRDTimestampMonotonic(InitRDTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of InitRDTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::InitRDTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::InitRDTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UserspaceTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UserspaceTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o460 = in.getUserspaceTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o460));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UserspaceTimestampUpdate& out) {
    {
        uint64 UserspaceTimestampValue;
        uint64 &UserspaceTimestampTmpValue = UserspaceTimestampValue;
        dbus_message_iter_get_basic(in, &UserspaceTimestampTmpValue);
        out.setUserspaceTimestamp(UserspaceTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UserspaceTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UserspaceTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::UserspaceTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UserspaceTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UserspaceTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o461 = in.getUserspaceTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o461));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UserspaceTimestampMonotonicUpdate& out) {
    {
        uint64 UserspaceTimestampMonotonicValue;
        uint64 &UserspaceTimestampMonotonicTmpValue = UserspaceTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &UserspaceTimestampMonotonicTmpValue);
        out.setUserspaceTimestampMonotonic(UserspaceTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UserspaceTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UserspaceTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::UserspaceTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of FinishTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::FinishTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o462 = in.getFinishTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o462));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::FinishTimestampUpdate& out) {
    {
        uint64 FinishTimestampValue;
        uint64 &FinishTimestampTmpValue = FinishTimestampValue;
        dbus_message_iter_get_basic(in, &FinishTimestampTmpValue);
        out.setFinishTimestamp(FinishTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FinishTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::FinishTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::FinishTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of FinishTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::FinishTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o463 = in.getFinishTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o463));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::FinishTimestampMonotonicUpdate& out) {
    {
        uint64 FinishTimestampMonotonicValue;
        uint64 &FinishTimestampMonotonicTmpValue = FinishTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &FinishTimestampMonotonicTmpValue);
        out.setFinishTimestampMonotonic(FinishTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FinishTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::FinishTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::FinishTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SecurityStartTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o464 = in.getSecurityStartTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o464));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::SecurityStartTimestampUpdate& out) {
    {
        uint64 SecurityStartTimestampValue;
        uint64 &SecurityStartTimestampTmpValue = SecurityStartTimestampValue;
        dbus_message_iter_get_basic(in, &SecurityStartTimestampTmpValue);
        out.setSecurityStartTimestamp(SecurityStartTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SecurityStartTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::SecurityStartTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SecurityStartTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o465 = in.getSecurityStartTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o465));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::SecurityStartTimestampMonotonicUpdate& out) {
    {
        uint64 SecurityStartTimestampMonotonicValue;
        uint64 &SecurityStartTimestampMonotonicTmpValue = SecurityStartTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &SecurityStartTimestampMonotonicTmpValue);
        out.setSecurityStartTimestampMonotonic(SecurityStartTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SecurityStartTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SecurityStartTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::SecurityStartTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SecurityFinishTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o466 = in.getSecurityFinishTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o466));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampUpdate& out) {
    {
        uint64 SecurityFinishTimestampValue;
        uint64 &SecurityFinishTimestampTmpValue = SecurityFinishTimestampValue;
        dbus_message_iter_get_basic(in, &SecurityFinishTimestampTmpValue);
        out.setSecurityFinishTimestamp(SecurityFinishTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SecurityFinishTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SecurityFinishTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o467 = in.getSecurityFinishTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o467));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampMonotonicUpdate& out) {
    {
        uint64 SecurityFinishTimestampMonotonicValue;
        uint64 &SecurityFinishTimestampMonotonicTmpValue = SecurityFinishTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &SecurityFinishTimestampMonotonicTmpValue);
        out.setSecurityFinishTimestampMonotonic(SecurityFinishTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SecurityFinishTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::SecurityFinishTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of GeneratorsStartTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o468 = in.getGeneratorsStartTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o468));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampUpdate& out) {
    {
        uint64 GeneratorsStartTimestampValue;
        uint64 &GeneratorsStartTimestampTmpValue = GeneratorsStartTimestampValue;
        dbus_message_iter_get_basic(in, &GeneratorsStartTimestampTmpValue);
        out.setGeneratorsStartTimestamp(GeneratorsStartTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GeneratorsStartTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of GeneratorsStartTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o469 = in.getGeneratorsStartTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o469));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampMonotonicUpdate& out) {
    {
        uint64 GeneratorsStartTimestampMonotonicValue;
        uint64 &GeneratorsStartTimestampMonotonicTmpValue = GeneratorsStartTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &GeneratorsStartTimestampMonotonicTmpValue);
        out.setGeneratorsStartTimestampMonotonic(GeneratorsStartTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GeneratorsStartTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::GeneratorsStartTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of GeneratorsFinishTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o470 = in.getGeneratorsFinishTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o470));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampUpdate& out) {
    {
        uint64 GeneratorsFinishTimestampValue;
        uint64 &GeneratorsFinishTimestampTmpValue = GeneratorsFinishTimestampValue;
        dbus_message_iter_get_basic(in, &GeneratorsFinishTimestampTmpValue);
        out.setGeneratorsFinishTimestamp(GeneratorsFinishTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GeneratorsFinishTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of GeneratorsFinishTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o471 = in.getGeneratorsFinishTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o471));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampMonotonicUpdate& out) {
    {
        uint64 GeneratorsFinishTimestampMonotonicValue;
        uint64 &GeneratorsFinishTimestampMonotonicTmpValue = GeneratorsFinishTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &GeneratorsFinishTimestampMonotonicTmpValue);
        out.setGeneratorsFinishTimestampMonotonic(GeneratorsFinishTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GeneratorsFinishTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::GeneratorsFinishTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UnitsLoadStartTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o472 = in.getUnitsLoadStartTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o472));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampUpdate& out) {
    {
        uint64 UnitsLoadStartTimestampValue;
        uint64 &UnitsLoadStartTimestampTmpValue = UnitsLoadStartTimestampValue;
        dbus_message_iter_get_basic(in, &UnitsLoadStartTimestampTmpValue);
        out.setUnitsLoadStartTimestamp(UnitsLoadStartTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnitsLoadStartTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UnitsLoadStartTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o473 = in.getUnitsLoadStartTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o473));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampMonotonicUpdate& out) {
    {
        uint64 UnitsLoadStartTimestampMonotonicValue;
        uint64 &UnitsLoadStartTimestampMonotonicTmpValue = UnitsLoadStartTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &UnitsLoadStartTimestampMonotonicTmpValue);
        out.setUnitsLoadStartTimestampMonotonic(UnitsLoadStartTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnitsLoadStartTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::UnitsLoadStartTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UnitsLoadFinishTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o474 = in.getUnitsLoadFinishTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o474));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampUpdate& out) {
    {
        uint64 UnitsLoadFinishTimestampValue;
        uint64 &UnitsLoadFinishTimestampTmpValue = UnitsLoadFinishTimestampValue;
        dbus_message_iter_get_basic(in, &UnitsLoadFinishTimestampTmpValue);
        out.setUnitsLoadFinishTimestamp(UnitsLoadFinishTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnitsLoadFinishTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UnitsLoadFinishTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o475 = in.getUnitsLoadFinishTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o475));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampMonotonicUpdate& out) {
    {
        uint64 UnitsLoadFinishTimestampMonotonicValue;
        uint64 &UnitsLoadFinishTimestampMonotonicTmpValue = UnitsLoadFinishTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &UnitsLoadFinishTimestampMonotonicTmpValue);
        out.setUnitsLoadFinishTimestampMonotonic(UnitsLoadFinishTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnitsLoadFinishTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::UnitsLoadFinishTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LogLevelUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::LogLevelUpdate& in, DBusMessageIter* out) {
    const char* o476 = in.getLogLevel().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o476));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::LogLevelUpdate& out) {
    {
        ::std::string LogLevelValue;
        ::std::string &LogLevelTmpValue = LogLevelValue;
        {
            char* o477 = 0;
            dbus_message_iter_get_basic(in, &o477);
            LogLevelTmpValue.assign (o477);
        }
        out.setLogLevel(LogLevelValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LogLevelRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::LogLevelRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::LogLevelRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LogTargetUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::LogTargetUpdate& in, DBusMessageIter* out) {
    const char* o478 = in.getLogTarget().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o478));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::LogTargetUpdate& out) {
    {
        ::std::string LogTargetValue;
        ::std::string &LogTargetTmpValue = LogTargetValue;
        {
            char* o479 = 0;
            dbus_message_iter_get_basic(in, &o479);
            LogTargetTmpValue.assign (o479);
        }
        out.setLogTarget(LogTargetValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LogTargetRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::LogTargetRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::LogTargetRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NNamesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::NNamesUpdate& in, DBusMessageIter* out) {
    uint32 o480 = in.getNNames();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o480));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::NNamesUpdate& out) {
    {
        uint32 NNamesValue;
        uint32 &NNamesTmpValue = NNamesValue;
        dbus_message_iter_get_basic(in, &NNamesTmpValue);
        out.setNNames(NNamesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NNamesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::NNamesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::NNamesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NFailedUnitsUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::NFailedUnitsUpdate& in, DBusMessageIter* out) {
    uint32 o481 = in.getNFailedUnits();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o481));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::NFailedUnitsUpdate& out) {
    {
        uint32 NFailedUnitsValue;
        uint32 &NFailedUnitsTmpValue = NFailedUnitsValue;
        dbus_message_iter_get_basic(in, &NFailedUnitsTmpValue);
        out.setNFailedUnits(NFailedUnitsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NFailedUnitsRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::NFailedUnitsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::NFailedUnitsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NJobsUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::NJobsUpdate& in, DBusMessageIter* out) {
    uint32 o482 = in.getNJobs();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o482));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::NJobsUpdate& out) {
    {
        uint32 NJobsValue;
        uint32 &NJobsTmpValue = NJobsValue;
        dbus_message_iter_get_basic(in, &NJobsTmpValue);
        out.setNJobs(NJobsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NJobsRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::NJobsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::NJobsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NInstalledJobsUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::NInstalledJobsUpdate& in, DBusMessageIter* out) {
    uint32 o483 = in.getNInstalledJobs();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o483));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::NInstalledJobsUpdate& out) {
    {
        uint32 NInstalledJobsValue;
        uint32 &NInstalledJobsTmpValue = NInstalledJobsValue;
        dbus_message_iter_get_basic(in, &NInstalledJobsTmpValue);
        out.setNInstalledJobs(NInstalledJobsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NInstalledJobsRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::NInstalledJobsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::NInstalledJobsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NFailedJobsUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::NFailedJobsUpdate& in, DBusMessageIter* out) {
    uint32 o484 = in.getNFailedJobs();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o484));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::NFailedJobsUpdate& out) {
    {
        uint32 NFailedJobsValue;
        uint32 &NFailedJobsTmpValue = NFailedJobsValue;
        dbus_message_iter_get_basic(in, &NFailedJobsTmpValue);
        out.setNFailedJobs(NFailedJobsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NFailedJobsRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::NFailedJobsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::NFailedJobsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ProgressUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ProgressUpdate& in, DBusMessageIter* out) {
    double o485 = in.getProgress();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_DOUBLE, &o485));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ProgressUpdate& out) {
    {
        double ProgressValue;
        double &ProgressTmpValue = ProgressValue;
        dbus_message_iter_get_basic(in, &ProgressTmpValue);
        out.setProgress(ProgressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ProgressRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ProgressRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::ProgressRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of EnvironmentUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::EnvironmentUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o486ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o486ArrayIter));
    const ::std::vector< ::std::string >* o487 = &in.getEnvironment();
    ::std::vector< ::std::string >::const_iterator o488 = o487->end();
    for (::std::vector< ::std::string >::const_iterator o489 = o487->begin(); o489 != o488; ++o489) {
        const char* o490 = (*o489).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o486ArrayIter, DBUS_TYPE_STRING, &o490));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o486ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::EnvironmentUpdate& out) {
    {
        ::std::vector< ::std::string > EnvironmentValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o491ArrayIter;
            dbus_message_iter_recurse (in, &o491ArrayIter);

            if(dbus_message_iter_get_arg_type(&o491ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o492;
                    {
                        char* o493 = 0;
                        dbus_message_iter_get_basic(&o491ArrayIter, &o493);
                        o492.assign (o493);
                    }
                    EnvironmentValue.push_back(o492);
                } while (dbus_message_iter_next(&o491ArrayIter));
            }
        }
        out.setEnvironment(EnvironmentValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EnvironmentRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::EnvironmentRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::EnvironmentRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ConfirmSpawnUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ConfirmSpawnUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o494 = in.getConfirmSpawn() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o494));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ConfirmSpawnUpdate& out) {
    {
        bool ConfirmSpawnValue;
        bool &ConfirmSpawnTmpValue = ConfirmSpawnValue;
        {
            dbus_bool_t o495;
            dbus_message_iter_get_basic(in, &o495);
            ConfirmSpawnTmpValue = o495 ? true : false;
        }
        out.setConfirmSpawn(ConfirmSpawnValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConfirmSpawnRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ConfirmSpawnRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::ConfirmSpawnRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ShowStatusUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ShowStatusUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o496 = in.getShowStatus() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o496));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ShowStatusUpdate& out) {
    {
        bool ShowStatusValue;
        bool &ShowStatusTmpValue = ShowStatusValue;
        {
            dbus_bool_t o497;
            dbus_message_iter_get_basic(in, &o497);
            ShowStatusTmpValue = o497 ? true : false;
        }
        out.setShowStatus(ShowStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShowStatusRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ShowStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::ShowStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UnitPathUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnitPathUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o498ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o498ArrayIter));
    const ::std::vector< ::std::string >* o499 = &in.getUnitPath();
    ::std::vector< ::std::string >::const_iterator o500 = o499->end();
    for (::std::vector< ::std::string >::const_iterator o501 = o499->begin(); o501 != o500; ++o501) {
        const char* o502 = (*o501).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o498ArrayIter, DBUS_TYPE_STRING, &o502));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o498ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UnitPathUpdate& out) {
    {
        ::std::vector< ::std::string > UnitPathValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o503ArrayIter;
            dbus_message_iter_recurse (in, &o503ArrayIter);

            if(dbus_message_iter_get_arg_type(&o503ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o504;
                    {
                        char* o505 = 0;
                        dbus_message_iter_get_basic(&o503ArrayIter, &o505);
                        o504.assign (o505);
                    }
                    UnitPathValue.push_back(o504);
                } while (dbus_message_iter_next(&o503ArrayIter));
            }
        }
        out.setUnitPath(UnitPathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnitPathRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnitPathRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::UnitPathRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DefaultStandardOutputUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::DefaultStandardOutputUpdate& in, DBusMessageIter* out) {
    const char* o506 = in.getDefaultStandardOutput().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o506));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::DefaultStandardOutputUpdate& out) {
    {
        ::std::string DefaultStandardOutputValue;
        ::std::string &DefaultStandardOutputTmpValue = DefaultStandardOutputValue;
        {
            char* o507 = 0;
            dbus_message_iter_get_basic(in, &o507);
            DefaultStandardOutputTmpValue.assign (o507);
        }
        out.setDefaultStandardOutput(DefaultStandardOutputValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DefaultStandardOutputRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::DefaultStandardOutputRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::DefaultStandardOutputRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DefaultStandardErrorUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::DefaultStandardErrorUpdate& in, DBusMessageIter* out) {
    const char* o508 = in.getDefaultStandardError().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o508));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::DefaultStandardErrorUpdate& out) {
    {
        ::std::string DefaultStandardErrorValue;
        ::std::string &DefaultStandardErrorTmpValue = DefaultStandardErrorValue;
        {
            char* o509 = 0;
            dbus_message_iter_get_basic(in, &o509);
            DefaultStandardErrorTmpValue.assign (o509);
        }
        out.setDefaultStandardError(DefaultStandardErrorValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DefaultStandardErrorRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::DefaultStandardErrorRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::DefaultStandardErrorRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RuntimeWatchdogUSecUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::RuntimeWatchdogUSecUpdate& in, DBusMessageIter* out) {
    uint64 o510 = in.getRuntimeWatchdogUSec();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o510));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::RuntimeWatchdogUSecUpdate& out) {
    {
        uint64 RuntimeWatchdogUSecValue;
        uint64 &RuntimeWatchdogUSecTmpValue = RuntimeWatchdogUSecValue;
        dbus_message_iter_get_basic(in, &RuntimeWatchdogUSecTmpValue);
        out.setRuntimeWatchdogUSec(RuntimeWatchdogUSecValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RuntimeWatchdogUSecRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::RuntimeWatchdogUSecRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::RuntimeWatchdogUSecRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ShutdownWatchdogUSecUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ShutdownWatchdogUSecUpdate& in, DBusMessageIter* out) {
    uint64 o511 = in.getShutdownWatchdogUSec();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o511));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ShutdownWatchdogUSecUpdate& out) {
    {
        uint64 ShutdownWatchdogUSecValue;
        uint64 &ShutdownWatchdogUSecTmpValue = ShutdownWatchdogUSecValue;
        dbus_message_iter_get_basic(in, &ShutdownWatchdogUSecTmpValue);
        out.setShutdownWatchdogUSec(ShutdownWatchdogUSecValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShutdownWatchdogUSecRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ShutdownWatchdogUSecRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::ShutdownWatchdogUSecRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ControlGroupUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ControlGroupUpdate& in, DBusMessageIter* out) {
    const char* o512 = in.getControlGroup().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o512));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ControlGroupUpdate& out) {
    {
        ::std::string ControlGroupValue;
        ::std::string &ControlGroupTmpValue = ControlGroupValue;
        {
            char* o513 = 0;
            dbus_message_iter_get_basic(in, &o513);
            ControlGroupTmpValue.assign (o513);
        }
        out.setControlGroup(ControlGroupValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ControlGroupRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ControlGroupRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::ControlGroupRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SystemStateUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SystemStateUpdate& in, DBusMessageIter* out) {
    const char* o514 = in.getSystemState().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o514));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::SystemStateUpdate& out) {
    {
        ::std::string SystemStateValue;
        ::std::string &SystemStateTmpValue = SystemStateValue;
        {
            char* o515 = 0;
            dbus_message_iter_get_basic(in, &o515);
            SystemStateTmpValue.assign (o515);
        }
        out.setSystemState(SystemStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SystemStateRegister

void serializeDBus (const ::org::freedesktop::systemd1::Manager::SystemStateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Manager::SystemStateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UnitNewSignal

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnitNewSignal& in, DBusMessageIter* out) {
    const char* o516 = in.getId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o516));
    const char* o517 = in.getUnit().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o517));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UnitNewSignal& out) {
    {
        ::std::string idValue;
        ::std::string &idTmpValue = idValue;
        {
            char* o518 = 0;
            dbus_message_iter_get_basic(in, &o518);
            idTmpValue.assign (o518);
        }
        out.setId(idValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string unitValue;
        ::std::string &unitTmpValue = unitValue;
        {
            char* o519 = 0;
            dbus_message_iter_get_basic(in, &o519);
            unitTmpValue.assign (o519);
        }
        out.setUnit(unitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnitRemovedSignal

void serializeDBus (const ::org::freedesktop::systemd1::Manager::UnitRemovedSignal& in, DBusMessageIter* out) {
    const char* o520 = in.getId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o520));
    const char* o521 = in.getUnit().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o521));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::UnitRemovedSignal& out) {
    {
        ::std::string idValue;
        ::std::string &idTmpValue = idValue;
        {
            char* o522 = 0;
            dbus_message_iter_get_basic(in, &o522);
            idTmpValue.assign (o522);
        }
        out.setId(idValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string unitValue;
        ::std::string &unitTmpValue = unitValue;
        {
            char* o523 = 0;
            dbus_message_iter_get_basic(in, &o523);
            unitTmpValue.assign (o523);
        }
        out.setUnit(unitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of JobNewSignal

void serializeDBus (const ::org::freedesktop::systemd1::Manager::JobNewSignal& in, DBusMessageIter* out) {
    uint32 o524 = in.getId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o524));
    const char* o525 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o525));
    const char* o526 = in.getUnit().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o526));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::JobNewSignal& out) {
    {
        uint32 idValue;
        uint32 &idTmpValue = idValue;
        dbus_message_iter_get_basic(in, &idTmpValue);
        out.setId(idValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o527 = 0;
            dbus_message_iter_get_basic(in, &o527);
            jobTmpValue.assign (o527);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string unitValue;
        ::std::string &unitTmpValue = unitValue;
        {
            char* o528 = 0;
            dbus_message_iter_get_basic(in, &o528);
            unitTmpValue.assign (o528);
        }
        out.setUnit(unitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of JobRemovedSignal

void serializeDBus (const ::org::freedesktop::systemd1::Manager::JobRemovedSignal& in, DBusMessageIter* out) {
    uint32 o529 = in.getId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o529));
    const char* o530 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o530));
    const char* o531 = in.getUnit().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o531));
    const char* o532 = in.getResult().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o532));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::JobRemovedSignal& out) {
    {
        uint32 idValue;
        uint32 &idTmpValue = idValue;
        dbus_message_iter_get_basic(in, &idTmpValue);
        out.setId(idValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o533 = 0;
            dbus_message_iter_get_basic(in, &o533);
            jobTmpValue.assign (o533);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string unitValue;
        ::std::string &unitTmpValue = unitValue;
        {
            char* o534 = 0;
            dbus_message_iter_get_basic(in, &o534);
            unitTmpValue.assign (o534);
        }
        out.setUnit(unitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string resultValue;
        ::std::string &resultTmpValue = resultValue;
        {
            char* o535 = 0;
            dbus_message_iter_get_basic(in, &o535);
            resultTmpValue.assign (o535);
        }
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartupFinishedSignal

void serializeDBus (const ::org::freedesktop::systemd1::Manager::StartupFinishedSignal& in, DBusMessageIter* out) {
    uint64 o536 = in.getFirmware();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o536));
    uint64 o537 = in.getLoader();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o537));
    uint64 o538 = in.getKernel();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o538));
    uint64 o539 = in.getInitrd();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o539));
    uint64 o540 = in.getUserspace();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o540));
    uint64 o541 = in.getTotal();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o541));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::StartupFinishedSignal& out) {
    {
        uint64 firmwareValue;
        uint64 &firmwareTmpValue = firmwareValue;
        dbus_message_iter_get_basic(in, &firmwareTmpValue);
        out.setFirmware(firmwareValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint64 loaderValue;
        uint64 &loaderTmpValue = loaderValue;
        dbus_message_iter_get_basic(in, &loaderTmpValue);
        out.setLoader(loaderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint64 kernelValue;
        uint64 &kernelTmpValue = kernelValue;
        dbus_message_iter_get_basic(in, &kernelTmpValue);
        out.setKernel(kernelValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint64 initrdValue;
        uint64 &initrdTmpValue = initrdValue;
        dbus_message_iter_get_basic(in, &initrdTmpValue);
        out.setInitrd(initrdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint64 userspaceValue;
        uint64 &userspaceTmpValue = userspaceValue;
        dbus_message_iter_get_basic(in, &userspaceTmpValue);
        out.setUserspace(userspaceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint64 totalValue;
        uint64 &totalTmpValue = totalValue;
        dbus_message_iter_get_basic(in, &totalTmpValue);
        out.setTotal(totalValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadingSignal

void serializeDBus (const ::org::freedesktop::systemd1::Manager::ReloadingSignal& in, DBusMessageIter* out) {
    dbus_bool_t o542 = in.getActive() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o542));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Manager::ReloadingSignal& out) {
    {
        bool activeValue;
        bool &activeTmpValue = activeValue;
        {
            dbus_bool_t o543;
            dbus_message_iter_get_basic(in, &o543);
            activeTmpValue = o543 ? true : false;
        }
        out.setActive(activeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

