#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_FREEDESKTOP_SYSTEMD1_MANAGER_H
#define ORG_FREEDESKTOP_SYSTEMD1_MANAGER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * systemd Manager interface.
 *
 *                     As this is an example interface only, it doesn't contain full
 *                     documentation. Some documentation has been added to illustrate
 *                     how Franca interfaces could be documented.
 */

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

// method IDs
static const uint16 ID_GetUnit = 0;
static const uint16 ID_GetUnitByPID = 1;
static const uint16 ID_LoadUnit = 2;
static const uint16 ID_StartUnit = 3;
static const uint16 ID_StartUnitReplace = 4;
static const uint16 ID_StopUnit = 5;
static const uint16 ID_ReloadUnit = 6;
static const uint16 ID_RestartUnit = 7;
static const uint16 ID_TryRestartUnit = 8;
static const uint16 ID_ReloadOrRestartUnit = 9;
static const uint16 ID_ReloadOrTryRestartUnit = 10;
static const uint16 ID_KillUnit = 11;
static const uint16 ID_ResetFailedUnit = 12;
static const uint16 ID_SetUnitProperties = 13;
static const uint16 ID_StartTransientUnit = 14;
static const uint16 ID_GetJob = 15;
static const uint16 ID_CancelJob = 16;
static const uint16 ID_ClearJobs = 17;
static const uint16 ID_ResetFailed = 18;
static const uint16 ID_ListUnits = 19;
static const uint16 ID_ListUnitsFiltered = 20;
static const uint16 ID_ListJobs = 21;
static const uint16 ID_Subscribe = 22;
static const uint16 ID_Unsubscribe = 23;
static const uint16 ID_Dump = 24;
static const uint16 ID_CreateSnapshot = 25;
static const uint16 ID_RemoveSnapshot = 26;
static const uint16 ID_Reload = 27;
static const uint16 ID_Reexecute = 28;
static const uint16 ID_Exit = 29;
static const uint16 ID_Reboot = 30;
static const uint16 ID_PowerOff = 31;
static const uint16 ID_Halt = 32;
static const uint16 ID_KExec = 33;
static const uint16 ID_SwitchRoot = 34;
static const uint16 ID_SetEnvironment = 35;
static const uint16 ID_UnsetEnvironment = 36;
static const uint16 ID_UnsetAndSetEnvironment = 37;
static const uint16 ID_ListUnitFiles = 38;
static const uint16 ID_GetUnitFileState = 39;
static const uint16 ID_EnableUnitFiles = 40;
static const uint16 ID_DisableUnitFiles = 41;
static const uint16 ID_ReenableUnitFiles = 42;
static const uint16 ID_LinkUnitFiles = 43;
static const uint16 ID_PresetUnitFiles = 44;
static const uint16 ID_PresetUnitFilesWithMode = 45;
static const uint16 ID_MaskUnitFiles = 46;
static const uint16 ID_UnmaskUnitFiles = 47;
static const uint16 ID_SetDefaultTarget = 48;
static const uint16 ID_GetDefaultTarget = 49;
static const uint16 ID_PresetAllUnitFiles = 50;
static const uint16 ID_AddDependencyUnitFiles = 51;

// signal IDs
static const uint16 ID_UnitNew = 52;
static const uint16 ID_UnitRemoved = 53;
static const uint16 ID_JobNew = 54;
static const uint16 ID_JobRemoved = 55;
static const uint16 ID_StartupFinished = 56;
static const uint16 ID_UnitFilesChanged = 57;
static const uint16 ID_Reloading = 58;

// property IDs
static const uint16 ID_Version = 59;
static const uint16 ID_Features = 60;
static const uint16 ID_Virtualization = 61;
static const uint16 ID_Architecture = 62;
static const uint16 ID_Tainted = 63;
static const uint16 ID_FirmwareTimestamp = 64;
static const uint16 ID_FirmwareTimestampMonotonic = 65;
static const uint16 ID_LoaderTimestamp = 66;
static const uint16 ID_LoaderTimestampMonotonic = 67;
static const uint16 ID_KernelTimestamp = 68;
static const uint16 ID_KernelTimestampMonotonic = 69;
static const uint16 ID_InitRDTimestamp = 70;
static const uint16 ID_InitRDTimestampMonotonic = 71;
static const uint16 ID_UserspaceTimestamp = 72;
static const uint16 ID_UserspaceTimestampMonotonic = 73;
static const uint16 ID_FinishTimestamp = 74;
static const uint16 ID_FinishTimestampMonotonic = 75;
static const uint16 ID_SecurityStartTimestamp = 76;
static const uint16 ID_SecurityStartTimestampMonotonic = 77;
static const uint16 ID_SecurityFinishTimestamp = 78;
static const uint16 ID_SecurityFinishTimestampMonotonic = 79;
static const uint16 ID_GeneratorsStartTimestamp = 80;
static const uint16 ID_GeneratorsStartTimestampMonotonic = 81;
static const uint16 ID_GeneratorsFinishTimestamp = 82;
static const uint16 ID_GeneratorsFinishTimestampMonotonic = 83;
static const uint16 ID_UnitsLoadStartTimestamp = 84;
static const uint16 ID_UnitsLoadStartTimestampMonotonic = 85;
static const uint16 ID_UnitsLoadFinishTimestamp = 86;
static const uint16 ID_UnitsLoadFinishTimestampMonotonic = 87;
static const uint16 ID_LogLevel = 88;
static const uint16 ID_LogTarget = 89;
static const uint16 ID_NNames = 90;
static const uint16 ID_NFailedUnits = 91;
static const uint16 ID_NJobs = 92;
static const uint16 ID_NInstalledJobs = 93;
static const uint16 ID_NFailedJobs = 94;
static const uint16 ID_Progress = 95;
static const uint16 ID_Environment = 96;
static const uint16 ID_ConfirmSpawn = 97;
static const uint16 ID_ShowStatus = 98;
static const uint16 ID_UnitPath = 99;
static const uint16 ID_DefaultStandardOutput = 100;
static const uint16 ID_DefaultStandardError = 101;
static const uint16 ID_RuntimeWatchdogUSec = 102;
static const uint16 ID_ShutdownWatchdogUSec = 103;
static const uint16 ID_ControlGroup = 104;
static const uint16 ID_SystemState = 105;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class units;

class jobs;

class files;

class changes;

class property;

class transientunitdata;

class GetUnitRequest;

class GetUnitResponse;

class GetUnitByPIDRequest;

class GetUnitByPIDResponse;

class LoadUnitRequest;

class LoadUnitResponse;

class StartUnitRequest;

class StartUnitResponse;

class StartUnitReplaceRequest;

class StartUnitReplaceResponse;

class StopUnitRequest;

class StopUnitResponse;

class ReloadUnitRequest;

class ReloadUnitResponse;

class RestartUnitRequest;

class RestartUnitResponse;

class TryRestartUnitRequest;

class TryRestartUnitResponse;

class ReloadOrRestartUnitRequest;

class ReloadOrRestartUnitResponse;

class ReloadOrTryRestartUnitRequest;

class ReloadOrTryRestartUnitResponse;

class KillUnitRequest;

class ResetFailedUnitRequest;

class SetUnitPropertiesRequest;

class StartTransientUnitRequest;

class StartTransientUnitResponse;

class GetJobRequest;

class GetJobResponse;

class CancelJobRequest;

class ListUnitsResponse;

class ListUnitsFilteredRequest;

class ListUnitsFilteredResponse;

class ListJobsResponse;

class DumpResponse;

class CreateSnapshotRequest;

class CreateSnapshotResponse;

class RemoveSnapshotRequest;

class SwitchRootRequest;

class SetEnvironmentRequest;

class UnsetEnvironmentRequest;

class UnsetAndSetEnvironmentRequest;

class ListUnitFilesResponse;

class GetUnitFileStateRequest;

class GetUnitFileStateResponse;

class EnableUnitFilesRequest;

class EnableUnitFilesResponse;

class DisableUnitFilesRequest;

class DisableUnitFilesResponse;

class ReenableUnitFilesRequest;

class ReenableUnitFilesResponse;

class LinkUnitFilesRequest;

class LinkUnitFilesResponse;

class PresetUnitFilesRequest;

class PresetUnitFilesResponse;

class PresetUnitFilesWithModeRequest;

class PresetUnitFilesWithModeResponse;

class MaskUnitFilesRequest;

class MaskUnitFilesResponse;

class UnmaskUnitFilesRequest;

class UnmaskUnitFilesResponse;

class SetDefaultTargetRequest;

class SetDefaultTargetResponse;

class GetDefaultTargetResponse;

class PresetAllUnitFilesRequest;

class PresetAllUnitFilesResponse;

class AddDependencyUnitFilesRequest;

class AddDependencyUnitFilesResponse;

class VersionUpdate;

class VersionRegister;

class FeaturesUpdate;

class FeaturesRegister;

class VirtualizationUpdate;

class VirtualizationRegister;

class ArchitectureUpdate;

class ArchitectureRegister;

class TaintedUpdate;

class TaintedRegister;

class FirmwareTimestampUpdate;

class FirmwareTimestampRegister;

class FirmwareTimestampMonotonicUpdate;

class FirmwareTimestampMonotonicRegister;

class LoaderTimestampUpdate;

class LoaderTimestampRegister;

class LoaderTimestampMonotonicUpdate;

class LoaderTimestampMonotonicRegister;

class KernelTimestampUpdate;

class KernelTimestampRegister;

class KernelTimestampMonotonicUpdate;

class KernelTimestampMonotonicRegister;

class InitRDTimestampUpdate;

class InitRDTimestampRegister;

class InitRDTimestampMonotonicUpdate;

class InitRDTimestampMonotonicRegister;

class UserspaceTimestampUpdate;

class UserspaceTimestampRegister;

class UserspaceTimestampMonotonicUpdate;

class UserspaceTimestampMonotonicRegister;

class FinishTimestampUpdate;

class FinishTimestampRegister;

class FinishTimestampMonotonicUpdate;

class FinishTimestampMonotonicRegister;

class SecurityStartTimestampUpdate;

class SecurityStartTimestampRegister;

class SecurityStartTimestampMonotonicUpdate;

class SecurityStartTimestampMonotonicRegister;

class SecurityFinishTimestampUpdate;

class SecurityFinishTimestampRegister;

class SecurityFinishTimestampMonotonicUpdate;

class SecurityFinishTimestampMonotonicRegister;

class GeneratorsStartTimestampUpdate;

class GeneratorsStartTimestampRegister;

class GeneratorsStartTimestampMonotonicUpdate;

class GeneratorsStartTimestampMonotonicRegister;

class GeneratorsFinishTimestampUpdate;

class GeneratorsFinishTimestampRegister;

class GeneratorsFinishTimestampMonotonicUpdate;

class GeneratorsFinishTimestampMonotonicRegister;

class UnitsLoadStartTimestampUpdate;

class UnitsLoadStartTimestampRegister;

class UnitsLoadStartTimestampMonotonicUpdate;

class UnitsLoadStartTimestampMonotonicRegister;

class UnitsLoadFinishTimestampUpdate;

class UnitsLoadFinishTimestampRegister;

class UnitsLoadFinishTimestampMonotonicUpdate;

class UnitsLoadFinishTimestampMonotonicRegister;

class LogLevelUpdate;

class LogLevelRegister;

class LogTargetUpdate;

class LogTargetRegister;

class NNamesUpdate;

class NNamesRegister;

class NFailedUnitsUpdate;

class NFailedUnitsRegister;

class NJobsUpdate;

class NJobsRegister;

class NInstalledJobsUpdate;

class NInstalledJobsRegister;

class NFailedJobsUpdate;

class NFailedJobsRegister;

class ProgressUpdate;

class ProgressRegister;

class EnvironmentUpdate;

class EnvironmentRegister;

class ConfirmSpawnUpdate;

class ConfirmSpawnRegister;

class ShowStatusUpdate;

class ShowStatusRegister;

class UnitPathUpdate;

class UnitPathRegister;

class DefaultStandardOutputUpdate;

class DefaultStandardOutputRegister;

class DefaultStandardErrorUpdate;

class DefaultStandardErrorRegister;

class RuntimeWatchdogUSecUpdate;

class RuntimeWatchdogUSecRegister;

class ShutdownWatchdogUSecUpdate;

class ShutdownWatchdogUSecRegister;

class ControlGroupUpdate;

class ControlGroupRegister;

class SystemStateUpdate;

class SystemStateRegister;

class UnitNewSignal;

class UnitRemovedSignal;

class JobNewSignal;

class JobRemovedSignal;

class StartupFinishedSignal;

class ReloadingSignal;

// type definitions
/**
 * The ObjectPath type (defined as an alias).
 */
typedef ::std::string ObjectPath;

/**
 * If the meaning of "GetUnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetUnitError;

/**
 * If the meaning of "GetUnitByPIDError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetUnitByPIDError;

/**
 * If the meaning of "LoadUnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LoadUnitError;

/**
 * If the meaning of "StartUnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartUnitError;

/**
 * If the meaning of "StartUnitReplaceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartUnitReplaceError;

/**
 * If the meaning of "StopUnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StopUnitError;

/**
 * If the meaning of "ReloadUnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReloadUnitError;

/**
 * If the meaning of "RestartUnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RestartUnitError;

/**
 * If the meaning of "TryRestartUnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TryRestartUnitError;

/**
 * If the meaning of "ReloadOrRestartUnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReloadOrRestartUnitError;

/**
 * If the meaning of "ReloadOrTryRestartUnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReloadOrTryRestartUnitError;

/**
 * KillUnit() may be used to kill (i.e. send a signal to) all processes of a unit.
 * 		Takes the unit name, an enum who and a UNIX signal number to send. The who enum is one of "main", "control" or "all".
 * 	 	If "main", only the main process of a unit is killed. If "control" only the control process of the unit is killed, if "all" all processes are killed.
 * 	 	A "control" process is for example a process that is configured via ExecStop= and is spawned in parallel to the main daemon process, in order to shut it down
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage KillUnitResponse;

/**
 * If the meaning of "KillUnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError KillUnitError;

/**
 * ResetFailedUnit
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ResetFailedUnitResponse;

/**
 * If the meaning of "ResetFailedUnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ResetFailedUnitError;

/**
 * SetUnitProperties
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetUnitPropertiesResponse;

/**
 * If the meaning of "SetUnitPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetUnitPropertiesError;

/**
 * If the meaning of "StartTransientUnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartTransientUnitError;

/**
 * If the meaning of "GetJobError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetJobError;

/**
 * CancelJob() cancels a specific job identified by its numer ID. This operation is also available
 * 		in the Cancel() method of Job objects (see below), and exists primarily to reduce the necessary round trips to
 * 		execute this operation. Note that this will not have any effect on jobs whose execution has already begun.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelJobResponse;

/**
 * If the meaning of "CancelJobError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelJobError;

/**
 * ClearJobs() flushes the job queue, removing all jobs that are still queued.
 * 		Note that this does not have any effect on jobs whose execution has already begun,
 * 		it only flushes jobs that are queued and have not yet begun execution.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ClearJobsRequest;

/**
 * ClearJobs() flushes the job queue, removing all jobs that are still queued.
 * 		Note that this does not have any effect on jobs whose execution has already begun,
 * 		it only flushes jobs that are queued and have not yet begun execution.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ClearJobsResponse;

/**
 * If the meaning of "ClearJobsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ClearJobsError;

/**
 * ResetFailed() resets the "failed" state of all units.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ResetFailedRequest;

/**
 * ResetFailed() resets the "failed" state of all units.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ResetFailedResponse;

/**
 * If the meaning of "ResetFailedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ResetFailedError;

/**
 * ListUnits() returns an array with all currently loaded units. Note that units may be known by multiple names at the same name,
 * 		and hence there might be more unit names loaded than actual units behind them. The array consists of structures with the following elements:
 *
 *     	The primary unit name as string
 *     	The human readable description string
 *     	The load state (i.e. whether the unit file has been loaded successfully)
 *     	The active state (i.e. whether the unit is currently started or not)
 *     	The sub state (a more fine-grained version of the active state that is specific to the unit type, which the active state is not)
 *     	A unit that is being followed in its state by this unit, if there is any, otherwise the empty string.
 *     	The unit object path
 *     	If there is a job queued for the job unit the numeric job id, 0 otherwise
 *     	The job type as string
 *     	The job object path
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ListUnitsRequest;

/**
 * If the meaning of "ListUnitsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ListUnitsError;

/**
 * If the meaning of "ListUnitsFilteredError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ListUnitsFilteredError;

/**
 * ListJobs() returns an array with all currently queued jobs. Returns an array consisting of structures with the following elements:
 *
 *    		 The numeric job id
 *     	The primary unit name for this job
 *     	The job type as string
 *     	The job state as string
 *     	The job object path
 *     	The unit object path
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ListJobsRequest;

/**
 * If the meaning of "ListJobsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ListJobsError;

/**
 * Subscribe() enables most bus signals to be sent out.
 * 		Clients which are interested in signals need to call this function. Signals are only sent out if at least one client invoked this function.
 * 		Unsubscribe() undoes the signal subscription that Subscribe() implements. It is not necessary to invoke Unsubscribe() as clients are tracked.
 * 		Signals are no longer sent out as soon as all clients which previously asked for Subscribe() either closed the bus connection or invoked Unsubscribe().
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SubscribeRequest;

/**
 * Subscribe() enables most bus signals to be sent out.
 * 		Clients which are interested in signals need to call this function. Signals are only sent out if at least one client invoked this function.
 * 		Unsubscribe() undoes the signal subscription that Subscribe() implements. It is not necessary to invoke Unsubscribe() as clients are tracked.
 * 		Signals are no longer sent out as soon as all clients which previously asked for Subscribe() either closed the bus connection or invoked Unsubscribe().
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SubscribeResponse;

/**
 * If the meaning of "SubscribeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SubscribeError;

/**
 * Unsubscribe
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UnsubscribeRequest;

/**
 * Unsubscribe
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UnsubscribeResponse;

/**
 * If the meaning of "UnsubscribeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnsubscribeError;

/**
 * Dump
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DumpRequest;

/**
 * If the meaning of "DumpError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DumpError;

/**
 * If the meaning of "CreateSnapshotError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CreateSnapshotError;

/**
 * RemoveSnapshot() removes a snapshot. This call is also available in the Remove() method of
 * 		Snapshot objects (see below), and exists primarily to reduce the number of required roundtrips for this call.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RemoveSnapshotResponse;

/**
 * If the meaning of "RemoveSnapshotError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoveSnapshotError;

/**
 * Reload() may be invoked to reload all unit files.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReloadRequest;

/**
 * Reload() may be invoked to reload all unit files.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReloadResponse;

/**
 * If the meaning of "ReloadError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReloadError;

/**
 * Reexecute() may be invoked to reexecute the main manager process.
 * 		It will serialize its state, reexecute, and deserizalize the state again. This is useful for upgrades and is a more comprehensive version of Reload().
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReexecuteRequest;

/**
 * Reexecute() may be invoked to reexecute the main manager process.
 * 		It will serialize its state, reexecute, and deserizalize the state again. This is useful for upgrades and is a more comprehensive version of Reload().
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReexecuteResponse;

/**
 * If the meaning of "ReexecuteError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReexecuteError;

/**
 * Exit() may be invoked to ask the manager to exit. This is not available for the system manager and is useful only for user session managers.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ExitRequest;

/**
 * Exit() may be invoked to ask the manager to exit. This is not available for the system manager and is useful only for user session managers.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ExitResponse;

/**
 * If the meaning of "ExitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ExitError;

/**
 * Reboot(), PowerOff(), Halt(), KExec() may be used to ask for immediate reboot, powering down, halt or kexec based reboot of the system.
 * 		Note that this does not shut down any services and immediately transitions into the reboot process.
 * 		These functions are normally only called as last step of shutdown, and should not be called directly.
 * 		To shut down the machine it is a much better choice generally to invoke Reboot() and PoweOff() on the logind manager object. See On logind for more information.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RebootRequest;

/**
 * Reboot(), PowerOff(), Halt(), KExec() may be used to ask for immediate reboot, powering down, halt or kexec based reboot of the system.
 * 		Note that this does not shut down any services and immediately transitions into the reboot process.
 * 		These functions are normally only called as last step of shutdown, and should not be called directly.
 * 		To shut down the machine it is a much better choice generally to invoke Reboot() and PoweOff() on the logind manager object. See On logind for more information.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RebootResponse;

/**
 * If the meaning of "RebootError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RebootError;

/**
 * PowerOff()
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage PowerOffRequest;

/**
 * PowerOff()
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage PowerOffResponse;

/**
 * If the meaning of "PowerOffError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PowerOffError;

/**
 * Halt()
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HaltRequest;

/**
 * Halt()
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HaltResponse;

/**
 * If the meaning of "HaltError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HaltError;

/**
 * KExec()
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage KExecRequest;

/**
 * KExec()
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage KExecResponse;

/**
 * If the meaning of "KExecError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError KExecError;

/**
 * SwitchRoot() may be used to transition to a new root directory. This is intended to be used by initial RAM disks.
 *  		The call takes two arguments: the new root directory (which needs to be specified), plus an init binary path (which may be left empty,
 *  		in which case it is automatically searched for).
 *  		The state of the system manager will be serialized before the transition.
 *  		After the transition the manager binary on the main system is invoked and replaces the old PID 1. All state will then be deserialized.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SwitchRootResponse;

/**
 * If the meaning of "SwitchRootError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SwitchRootError;

/**
 * SetEnvironment() may be used to alter the environment block that is passed to all spawned processes.
 * 	    Takes a string array with environment variable assignments. Settings passed will override previously set variables
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetEnvironmentResponse;

/**
 * If the meaning of "SetEnvironmentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetEnvironmentError;

/**
 * UnsetEnvironment() may be used to unset environment variables. Takes a string array with environment variable names.
 * 		All variables specified will be unset (if they have been set previously) and no longer be passed to all spawned processes.
 * 		This call has no effect for variables that were previously not set, but will not fail in that case.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UnsetEnvironmentResponse;

/**
 * If the meaning of "UnsetEnvironmentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnsetEnvironmentError;

/**
 * UnsetAndSetEnvironment() is a combination of UnsetEnvironment() and SetEnvironment().
 * 		It takes two lists. The first one is a list of variables to unset, the second one of assignments to set.
 * 		If a variable is listed in both the variable is set after this call, i.e. the set list overrides the unset list.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UnsetAndSetEnvironmentResponse;

/**
 * If the meaning of "UnsetAndSetEnvironmentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnsetAndSetEnvironmentError;

/**
 * ListUnitFiles() returns an array of unit names plus their enablement status.
 * 		Note that ListUnit() returns a list of units currently loaded into memory, while ListUnitFiles()
 * 		returns a list of unit files that could be found on disk. Note that while most units are read directly from a unit file with the same name
 * 		some units are not backed by files, and some files (templates) cannot directly be loaded as units but need to be instantiated.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ListUnitFilesRequest;

/**
 * If the meaning of "ListUnitFilesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ListUnitFilesError;

/**
 * If the meaning of "GetUnitFileStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetUnitFileStateError;

/**
 * If the meaning of "EnableUnitFilesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EnableUnitFilesError;

/**
 * If the meaning of "DisableUnitFilesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisableUnitFilesError;

/**
 * If the meaning of "ReenableUnitFilesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReenableUnitFilesError;

/**
 * If the meaning of "LinkUnitFilesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LinkUnitFilesError;

/**
 * If the meaning of "PresetUnitFilesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PresetUnitFilesError;

/**
 * If the meaning of "PresetUnitFilesWithModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PresetUnitFilesWithModeError;

/**
 * If the meaning of "MaskUnitFilesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MaskUnitFilesError;

/**
 * If the meaning of "UnmaskUnitFilesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnmaskUnitFilesError;

/**
 * If the meaning of "SetDefaultTargetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetDefaultTargetError;

/**
 * GetDefaultTarget()  retrieves the name of the unit to which default.target is aliased.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetDefaultTargetRequest;

/**
 * If the meaning of "GetDefaultTargetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetDefaultTargetError;

/**
 * If the meaning of "PresetAllUnitFilesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PresetAllUnitFilesError;

/**
 * If the meaning of "AddDependencyUnitFilesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AddDependencyUnitFilesError;

/**
 * This encodes encodes the version string of the running
 * 	    systemd instance.
 */
typedef VersionUpdate VersionSet;

/**
 * This encodes encodes the version string of the running
 * 	    systemd instance.
 */
typedef VersionUpdate VersionGet;

/**
 * If the meaning of "VersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VersionError;

/**
 * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
 */
typedef FeaturesUpdate FeaturesSet;

/**
 * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
 */
typedef FeaturesUpdate FeaturesGet;

/**
 * If the meaning of "FeaturesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FeaturesError;

/**
 * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
 * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
 * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
 */
typedef VirtualizationUpdate VirtualizationSet;

/**
 * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
 * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
 * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
 */
typedef VirtualizationUpdate VirtualizationGet;

/**
 * If the meaning of "VirtualizationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VirtualizationError;

/**
 * Architecture contains a short ID string describing the architecture the systemd instance is running on.
 * 		This follows the same vocabulary as ConditionArchitectures=.
 */
typedef ArchitectureUpdate ArchitectureSet;

/**
 * Architecture contains a short ID string describing the architecture the systemd instance is running on.
 * 		This follows the same vocabulary as ConditionArchitectures=.
 */
typedef ArchitectureUpdate ArchitectureGet;

/**
 * If the meaning of "ArchitectureError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ArchitectureError;

/**
 * Tainted encodes a couple of taint flags, as colon separated list.
 * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
 */
typedef TaintedUpdate TaintedSet;

/**
 * Tainted encodes a couple of taint flags, as colon separated list.
 * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
 */
typedef TaintedUpdate TaintedGet;

/**
 * If the meaning of "TaintedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TaintedError;

/**
 * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
 * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
 * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
 * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
 * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
 * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
 * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
 */
typedef FirmwareTimestampUpdate FirmwareTimestampSet;

/**
 * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
 * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
 * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
 * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
 * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
 * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
 * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
 */
typedef FirmwareTimestampUpdate FirmwareTimestampGet;

/**
 * If the meaning of "FirmwareTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FirmwareTimestampError;

/**
 * FirmwareTimestampMonotonic
 */
typedef FirmwareTimestampMonotonicUpdate FirmwareTimestampMonotonicSet;

/**
 * FirmwareTimestampMonotonic
 */
typedef FirmwareTimestampMonotonicUpdate FirmwareTimestampMonotonicGet;

/**
 * If the meaning of "FirmwareTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FirmwareTimestampMonotonicError;

/**
 * LoaderTimestamp
 */
typedef LoaderTimestampUpdate LoaderTimestampSet;

/**
 * LoaderTimestamp
 */
typedef LoaderTimestampUpdate LoaderTimestampGet;

/**
 * If the meaning of "LoaderTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LoaderTimestampError;

/**
 * LoaderTimestampMonotonic
 */
typedef LoaderTimestampMonotonicUpdate LoaderTimestampMonotonicSet;

/**
 * LoaderTimestampMonotonic
 */
typedef LoaderTimestampMonotonicUpdate LoaderTimestampMonotonicGet;

/**
 * If the meaning of "LoaderTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LoaderTimestampMonotonicError;

/**
 * KernelTimestamp
 */
typedef KernelTimestampUpdate KernelTimestampSet;

/**
 * KernelTimestamp
 */
typedef KernelTimestampUpdate KernelTimestampGet;

/**
 * If the meaning of "KernelTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError KernelTimestampError;

/**
 * KernelTimestampMonotonic
 */
typedef KernelTimestampMonotonicUpdate KernelTimestampMonotonicSet;

/**
 * KernelTimestampMonotonic
 */
typedef KernelTimestampMonotonicUpdate KernelTimestampMonotonicGet;

/**
 * If the meaning of "KernelTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError KernelTimestampMonotonicError;

/**
 * InitRDTimestamp
 */
typedef InitRDTimestampUpdate InitRDTimestampSet;

/**
 * InitRDTimestamp
 */
typedef InitRDTimestampUpdate InitRDTimestampGet;

/**
 * If the meaning of "InitRDTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InitRDTimestampError;

/**
 * InitRDTimestampMonotonic
 */
typedef InitRDTimestampMonotonicUpdate InitRDTimestampMonotonicSet;

/**
 * InitRDTimestampMonotonic
 */
typedef InitRDTimestampMonotonicUpdate InitRDTimestampMonotonicGet;

/**
 * If the meaning of "InitRDTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InitRDTimestampMonotonicError;

/**
 * UserspaceTimestamp
 */
typedef UserspaceTimestampUpdate UserspaceTimestampSet;

/**
 * UserspaceTimestamp
 */
typedef UserspaceTimestampUpdate UserspaceTimestampGet;

/**
 * If the meaning of "UserspaceTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UserspaceTimestampError;

/**
 * UserspaceTimestampMonotonic
 */
typedef UserspaceTimestampMonotonicUpdate UserspaceTimestampMonotonicSet;

/**
 * UserspaceTimestampMonotonic
 */
typedef UserspaceTimestampMonotonicUpdate UserspaceTimestampMonotonicGet;

/**
 * If the meaning of "UserspaceTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UserspaceTimestampMonotonicError;

/**
 * FinishTimestamp
 */
typedef FinishTimestampUpdate FinishTimestampSet;

/**
 * FinishTimestamp
 */
typedef FinishTimestampUpdate FinishTimestampGet;

/**
 * If the meaning of "FinishTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FinishTimestampError;

/**
 * FinishTimestampMonotonic
 */
typedef FinishTimestampMonotonicUpdate FinishTimestampMonotonicSet;

/**
 * FinishTimestampMonotonic
 */
typedef FinishTimestampMonotonicUpdate FinishTimestampMonotonicGet;

/**
 * If the meaning of "FinishTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FinishTimestampMonotonicError;

/**
 * SecurityStartTimestamp
 */
typedef SecurityStartTimestampUpdate SecurityStartTimestampSet;

/**
 * SecurityStartTimestamp
 */
typedef SecurityStartTimestampUpdate SecurityStartTimestampGet;

/**
 * If the meaning of "SecurityStartTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SecurityStartTimestampError;

/**
 * SecurityStartTimestampMonotonic
 */
typedef SecurityStartTimestampMonotonicUpdate SecurityStartTimestampMonotonicSet;

/**
 * SecurityStartTimestampMonotonic
 */
typedef SecurityStartTimestampMonotonicUpdate SecurityStartTimestampMonotonicGet;

/**
 * If the meaning of "SecurityStartTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SecurityStartTimestampMonotonicError;

/**
 * SecurityFinishTimestamp
 */
typedef SecurityFinishTimestampUpdate SecurityFinishTimestampSet;

/**
 * SecurityFinishTimestamp
 */
typedef SecurityFinishTimestampUpdate SecurityFinishTimestampGet;

/**
 * If the meaning of "SecurityFinishTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SecurityFinishTimestampError;

/**
 * SecurityFinishTimestampMonotonic
 */
typedef SecurityFinishTimestampMonotonicUpdate SecurityFinishTimestampMonotonicSet;

/**
 * SecurityFinishTimestampMonotonic
 */
typedef SecurityFinishTimestampMonotonicUpdate SecurityFinishTimestampMonotonicGet;

/**
 * If the meaning of "SecurityFinishTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SecurityFinishTimestampMonotonicError;

/**
 * GeneratorsStartTimestamp
 */
typedef GeneratorsStartTimestampUpdate GeneratorsStartTimestampSet;

/**
 * GeneratorsStartTimestamp
 */
typedef GeneratorsStartTimestampUpdate GeneratorsStartTimestampGet;

/**
 * If the meaning of "GeneratorsStartTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GeneratorsStartTimestampError;

/**
 * GeneratorsStartTimestampMonotonic
 */
typedef GeneratorsStartTimestampMonotonicUpdate GeneratorsStartTimestampMonotonicSet;

/**
 * GeneratorsStartTimestampMonotonic
 */
typedef GeneratorsStartTimestampMonotonicUpdate GeneratorsStartTimestampMonotonicGet;

/**
 * If the meaning of "GeneratorsStartTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GeneratorsStartTimestampMonotonicError;

/**
 * GeneratorsFinishTimestamp
 */
typedef GeneratorsFinishTimestampUpdate GeneratorsFinishTimestampSet;

/**
 * GeneratorsFinishTimestamp
 */
typedef GeneratorsFinishTimestampUpdate GeneratorsFinishTimestampGet;

/**
 * If the meaning of "GeneratorsFinishTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GeneratorsFinishTimestampError;

/**
 * GeneratorsFinishTimestampMonotonic
 */
typedef GeneratorsFinishTimestampMonotonicUpdate GeneratorsFinishTimestampMonotonicSet;

/**
 * GeneratorsFinishTimestampMonotonic
 */
typedef GeneratorsFinishTimestampMonotonicUpdate GeneratorsFinishTimestampMonotonicGet;

/**
 * If the meaning of "GeneratorsFinishTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GeneratorsFinishTimestampMonotonicError;

/**
 * UnitsLoadStartTimestamp
 */
typedef UnitsLoadStartTimestampUpdate UnitsLoadStartTimestampSet;

/**
 * UnitsLoadStartTimestamp
 */
typedef UnitsLoadStartTimestampUpdate UnitsLoadStartTimestampGet;

/**
 * If the meaning of "UnitsLoadStartTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnitsLoadStartTimestampError;

/**
 * UnitsLoadStartTimestampMonotonic
 */
typedef UnitsLoadStartTimestampMonotonicUpdate UnitsLoadStartTimestampMonotonicSet;

/**
 * UnitsLoadStartTimestampMonotonic
 */
typedef UnitsLoadStartTimestampMonotonicUpdate UnitsLoadStartTimestampMonotonicGet;

/**
 * If the meaning of "UnitsLoadStartTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnitsLoadStartTimestampMonotonicError;

/**
 * UnitsLoadFinishTimestamp
 */
typedef UnitsLoadFinishTimestampUpdate UnitsLoadFinishTimestampSet;

/**
 * UnitsLoadFinishTimestamp
 */
typedef UnitsLoadFinishTimestampUpdate UnitsLoadFinishTimestampGet;

/**
 * If the meaning of "UnitsLoadFinishTimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnitsLoadFinishTimestampError;

/**
 * UnitsLoadFinishTimestampMonotonic
 */
typedef UnitsLoadFinishTimestampMonotonicUpdate UnitsLoadFinishTimestampMonotonicSet;

/**
 * UnitsLoadFinishTimestampMonotonic
 */
typedef UnitsLoadFinishTimestampMonotonicUpdate UnitsLoadFinishTimestampMonotonicGet;

/**
 * If the meaning of "UnitsLoadFinishTimestampMonotonicError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnitsLoadFinishTimestampMonotonicError;

/**
 * LogLevel
 */
typedef LogLevelUpdate LogLevelSet;

/**
 * LogLevel
 */
typedef LogLevelUpdate LogLevelGet;

/**
 * If the meaning of "LogLevelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LogLevelError;

/**
 * LogTarget
 */
typedef LogTargetUpdate LogTargetSet;

/**
 * LogTarget
 */
typedef LogTargetUpdate LogTargetGet;

/**
 * If the meaning of "LogTargetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LogTargetError;

/**
 * NNames encodes how many unit names are currently known. This only includes names of units that are currently
 * 		loaded and can be more than actually loaded units since units may have more than one name.
 */
typedef NNamesUpdate NNamesSet;

/**
 * NNames encodes how many unit names are currently known. This only includes names of units that are currently
 * 		loaded and can be more than actually loaded units since units may have more than one name.
 */
typedef NNamesUpdate NNamesGet;

/**
 * If the meaning of "NNamesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NNamesError;

/**
 * NFailedUnits.
 */
typedef NFailedUnitsUpdate NFailedUnitsSet;

/**
 * NFailedUnits.
 */
typedef NFailedUnitsUpdate NFailedUnitsGet;

/**
 * If the meaning of "NFailedUnitsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NFailedUnitsError;

/**
 * NJobs encodes how many jobs are currently queued.
 */
typedef NJobsUpdate NJobsSet;

/**
 * NJobs encodes how many jobs are currently queued.
 */
typedef NJobsUpdate NJobsGet;

/**
 * If the meaning of "NJobsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NJobsError;

/**
 * NInstalledJobs encodes how many jobs have ever been queued in total.
 */
typedef NInstalledJobsUpdate NInstalledJobsSet;

/**
 * NInstalledJobs encodes how many jobs have ever been queued in total.
 */
typedef NInstalledJobsUpdate NInstalledJobsGet;

/**
 * If the meaning of "NInstalledJobsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NInstalledJobsError;

/**
 * NFailedJobs encodes how many jobs have ever failed in total.
 */
typedef NFailedJobsUpdate NFailedJobsSet;

/**
 * NFailedJobs encodes how many jobs have ever failed in total.
 */
typedef NFailedJobsUpdate NFailedJobsGet;

/**
 * If the meaning of "NFailedJobsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NFailedJobsError;

/**
 * Progress encodes boot progress as floating point value between 0.0 and 1.0.
 * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
 * 		After startup this field is always 1.0 indicating a finished boot.
 */
typedef ProgressUpdate ProgressSet;

/**
 * Progress encodes boot progress as floating point value between 0.0 and 1.0.
 * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
 * 		After startup this field is always 1.0 indicating a finished boot.
 */
typedef ProgressUpdate ProgressGet;

/**
 * If the meaning of "ProgressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProgressError;

/**
 * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
 */
typedef EnvironmentUpdate EnvironmentSet;

/**
 * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
 */
typedef EnvironmentUpdate EnvironmentGet;

/**
 * If the meaning of "EnvironmentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EnvironmentError;

/**
 * ConfirmSpawn
 */
typedef ConfirmSpawnUpdate ConfirmSpawnSet;

/**
 * ConfirmSpawn
 */
typedef ConfirmSpawnUpdate ConfirmSpawnGet;

/**
 * If the meaning of "ConfirmSpawnError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConfirmSpawnError;

/**
 * ShowStatus
 */
typedef ShowStatusUpdate ShowStatusSet;

/**
 * ShowStatus
 */
typedef ShowStatusUpdate ShowStatusGet;

/**
 * If the meaning of "ShowStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowStatusError;

/**
 * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
 */
typedef UnitPathUpdate UnitPathSet;

/**
 * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
 */
typedef UnitPathUpdate UnitPathGet;

/**
 * If the meaning of "UnitPathError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnitPathError;

/**
 * DefaultStandardOutput
 */
typedef DefaultStandardOutputUpdate DefaultStandardOutputSet;

/**
 * DefaultStandardOutput
 */
typedef DefaultStandardOutputUpdate DefaultStandardOutputGet;

/**
 * If the meaning of "DefaultStandardOutputError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DefaultStandardOutputError;

/**
 * DefaultStandardError
 */
typedef DefaultStandardErrorUpdate DefaultStandardErrorSet;

/**
 * DefaultStandardError
 */
typedef DefaultStandardErrorUpdate DefaultStandardErrorGet;

/**
 * If the meaning of "DefaultStandardErrorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DefaultStandardErrorError;

/**
 * RuntimeWatchdogUSec
 */
typedef RuntimeWatchdogUSecUpdate RuntimeWatchdogUSecSet;

/**
 * RuntimeWatchdogUSec
 */
typedef RuntimeWatchdogUSecUpdate RuntimeWatchdogUSecGet;

/**
 * If the meaning of "RuntimeWatchdogUSecError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RuntimeWatchdogUSecError;

/**
 * ShutdownWatchdogUSec
 */
typedef ShutdownWatchdogUSecUpdate ShutdownWatchdogUSecSet;

/**
 * ShutdownWatchdogUSec
 */
typedef ShutdownWatchdogUSecUpdate ShutdownWatchdogUSecGet;

/**
 * If the meaning of "ShutdownWatchdogUSecError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShutdownWatchdogUSecError;

/**
 * ControlGroup
 */
typedef ControlGroupUpdate ControlGroupSet;

/**
 * ControlGroup
 */
typedef ControlGroupUpdate ControlGroupGet;

/**
 * If the meaning of "ControlGroupError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ControlGroupError;

/**
 * SystemState
 */
typedef SystemStateUpdate SystemStateSet;

/**
 * SystemState
 */
typedef SystemStateUpdate SystemStateGet;

/**
 * If the meaning of "SystemStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SystemStateError;

/**
 * If the meaning of "UnitNewError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnitNewError;

/**
 * If the meaning of "UnitRemovedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnitRemovedError;

/**
 * If the meaning of "JobNewError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError JobNewError;

/**
 * If the meaning of "JobRemovedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError JobRemovedError;

/**
 * If the meaning of "StartupFinishedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartupFinishedError;

/**
 * UnitFilesChanged() is sent out each time the list of enabled or masked unit files on disk have changed.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UnitFilesChangedSignal;

/**
 * If the meaning of "UnitFilesChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnitFilesChangedError;

/**
 * If the meaning of "ReloadingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReloadingError;


/**
 * Unit info structure
 */
class units {
public:

    /**
     * Default constructor
     */
    inline  units ();

    /**
     * Copy constructor
     */
    inline  units (const units &rhs);

    /**
     * All fields constructor
     */
    inline  units (const ::std::string& name_, const ::std::string& description_, const ::std::string& loadState_, const ::std::string& activeState_, const ::std::string& subState_, const ::std::string& follower_, const ::std::string& path_, uint32 jobId_, const ::std::string& jobType_, const ::std::string& jobPath_);

    /**
     * Destructor
     */
    inline  ~units();

    /**
     * Assignment operator
     */
    inline units& operator = (const units& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const units& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const units& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const units& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const units& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "description"

    static const int kDescription = 1;

    /**
     * Clears the field "description".
     *
     * The field will be set to its default value. The hasDescription()
     * method will return false.
     */
    inline void clearDescription();

    /**
     * Checks whether the field "description" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDescription()). Otherwise it will return false.
     */
    inline bool hasDescription () const;

    /**
     * Returns the value of the member "description".
     *
     * If the meaning of "description" isn't clear, then there should be a description here.
     *
     * @return The value of the field "description"
     */
    inline const ::std::string& getDescription () const;

    /**
     * Retrieves the value of the field "description" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "description".
     */
    inline ::std::string& getDescriptionMutable ();

    /**
     * Sets the value of the member "description".
     *
     * If the meaning of "description" isn't clear, then there should be a description here.
     *
     * @param description The value which will be set
     */
    inline void setDescription (const ::std::string& description_);

    /**
     * Sets the value of the member "description".
     *
     * If the meaning of "description" isn't clear, then there should be a description here.
     *
     * @param description The value which will be set
     */
    inline void setDescription (const char* description_);

    /**
     * Sets the value of the member "description".
     *
     * If the meaning of "description" isn't clear, then there should be a description here.
     *
     * @param description The value which will be set
     */
    inline void setDescription (const char* value, size_t size);

    // API of field "loadState"

    static const int kLoadState = 2;

    /**
     * Clears the field "loadState".
     *
     * The field will be set to its default value. The hasLoadState()
     * method will return false.
     */
    inline void clearLoadState();

    /**
     * Checks whether the field "loadState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoadState()). Otherwise it will return false.
     */
    inline bool hasLoadState () const;

    /**
     * Returns the value of the member "loadState".
     *
     * If the meaning of "loadState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "loadState"
     */
    inline const ::std::string& getLoadState () const;

    /**
     * Retrieves the value of the field "loadState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "loadState".
     */
    inline ::std::string& getLoadStateMutable ();

    /**
     * Sets the value of the member "loadState".
     *
     * If the meaning of "loadState" isn't clear, then there should be a description here.
     *
     * @param loadState The value which will be set
     */
    inline void setLoadState (const ::std::string& loadState_);

    /**
     * Sets the value of the member "loadState".
     *
     * If the meaning of "loadState" isn't clear, then there should be a description here.
     *
     * @param loadState The value which will be set
     */
    inline void setLoadState (const char* loadState_);

    /**
     * Sets the value of the member "loadState".
     *
     * If the meaning of "loadState" isn't clear, then there should be a description here.
     *
     * @param loadState The value which will be set
     */
    inline void setLoadState (const char* value, size_t size);

    // API of field "activeState"

    static const int kActiveState = 3;

    /**
     * Clears the field "activeState".
     *
     * The field will be set to its default value. The hasActiveState()
     * method will return false.
     */
    inline void clearActiveState();

    /**
     * Checks whether the field "activeState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveState()). Otherwise it will return false.
     */
    inline bool hasActiveState () const;

    /**
     * Returns the value of the member "activeState".
     *
     * If the meaning of "activeState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "activeState"
     */
    inline const ::std::string& getActiveState () const;

    /**
     * Retrieves the value of the field "activeState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "activeState".
     */
    inline ::std::string& getActiveStateMutable ();

    /**
     * Sets the value of the member "activeState".
     *
     * If the meaning of "activeState" isn't clear, then there should be a description here.
     *
     * @param activeState The value which will be set
     */
    inline void setActiveState (const ::std::string& activeState_);

    /**
     * Sets the value of the member "activeState".
     *
     * If the meaning of "activeState" isn't clear, then there should be a description here.
     *
     * @param activeState The value which will be set
     */
    inline void setActiveState (const char* activeState_);

    /**
     * Sets the value of the member "activeState".
     *
     * If the meaning of "activeState" isn't clear, then there should be a description here.
     *
     * @param activeState The value which will be set
     */
    inline void setActiveState (const char* value, size_t size);

    // API of field "subState"

    static const int kSubState = 4;

    /**
     * Clears the field "subState".
     *
     * The field will be set to its default value. The hasSubState()
     * method will return false.
     */
    inline void clearSubState();

    /**
     * Checks whether the field "subState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubState()). Otherwise it will return false.
     */
    inline bool hasSubState () const;

    /**
     * Returns the value of the member "subState".
     *
     * If the meaning of "subState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "subState"
     */
    inline const ::std::string& getSubState () const;

    /**
     * Retrieves the value of the field "subState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "subState".
     */
    inline ::std::string& getSubStateMutable ();

    /**
     * Sets the value of the member "subState".
     *
     * If the meaning of "subState" isn't clear, then there should be a description here.
     *
     * @param subState The value which will be set
     */
    inline void setSubState (const ::std::string& subState_);

    /**
     * Sets the value of the member "subState".
     *
     * If the meaning of "subState" isn't clear, then there should be a description here.
     *
     * @param subState The value which will be set
     */
    inline void setSubState (const char* subState_);

    /**
     * Sets the value of the member "subState".
     *
     * If the meaning of "subState" isn't clear, then there should be a description here.
     *
     * @param subState The value which will be set
     */
    inline void setSubState (const char* value, size_t size);

    // API of field "follower"

    static const int kFollower = 5;

    /**
     * Clears the field "follower".
     *
     * The field will be set to its default value. The hasFollower()
     * method will return false.
     */
    inline void clearFollower();

    /**
     * Checks whether the field "follower" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFollower()). Otherwise it will return false.
     */
    inline bool hasFollower () const;

    /**
     * Returns the value of the member "follower".
     *
     * If the meaning of "follower" isn't clear, then there should be a description here.
     *
     * @return The value of the field "follower"
     */
    inline const ::std::string& getFollower () const;

    /**
     * Retrieves the value of the field "follower" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "follower".
     */
    inline ::std::string& getFollowerMutable ();

    /**
     * Sets the value of the member "follower".
     *
     * If the meaning of "follower" isn't clear, then there should be a description here.
     *
     * @param follower The value which will be set
     */
    inline void setFollower (const ::std::string& follower_);

    /**
     * Sets the value of the member "follower".
     *
     * If the meaning of "follower" isn't clear, then there should be a description here.
     *
     * @param follower The value which will be set
     */
    inline void setFollower (const char* follower_);

    /**
     * Sets the value of the member "follower".
     *
     * If the meaning of "follower" isn't clear, then there should be a description here.
     *
     * @param follower The value which will be set
     */
    inline void setFollower (const char* value, size_t size);

    // API of field "path"

    static const int kPath = 6;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    // API of field "jobId"

    static const int kJobId = 7;

    /**
     * Clears the field "jobId".
     *
     * The field will be set to its default value. The hasJobId()
     * method will return false.
     */
    inline void clearJobId();

    /**
     * Checks whether the field "jobId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobId()). Otherwise it will return false.
     */
    inline bool hasJobId () const;

    /**
     * Returns the value of the member "jobId".
     *
     * If the meaning of "jobId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "jobId"
     */
    inline uint32 getJobId () const;

    /**
     * Sets the value of the member "jobId".
     *
     * If the meaning of "jobId" isn't clear, then there should be a description here.
     *
     * @param jobId The value which will be set
     */
    inline void setJobId (uint32 jobId_);

    // API of field "jobType"

    static const int kJobType = 8;

    /**
     * Clears the field "jobType".
     *
     * The field will be set to its default value. The hasJobType()
     * method will return false.
     */
    inline void clearJobType();

    /**
     * Checks whether the field "jobType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobType()). Otherwise it will return false.
     */
    inline bool hasJobType () const;

    /**
     * Returns the value of the member "jobType".
     *
     * If the meaning of "jobType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "jobType"
     */
    inline const ::std::string& getJobType () const;

    /**
     * Retrieves the value of the field "jobType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jobType".
     */
    inline ::std::string& getJobTypeMutable ();

    /**
     * Sets the value of the member "jobType".
     *
     * If the meaning of "jobType" isn't clear, then there should be a description here.
     *
     * @param jobType The value which will be set
     */
    inline void setJobType (const ::std::string& jobType_);

    /**
     * Sets the value of the member "jobType".
     *
     * If the meaning of "jobType" isn't clear, then there should be a description here.
     *
     * @param jobType The value which will be set
     */
    inline void setJobType (const char* jobType_);

    /**
     * Sets the value of the member "jobType".
     *
     * If the meaning of "jobType" isn't clear, then there should be a description here.
     *
     * @param jobType The value which will be set
     */
    inline void setJobType (const char* value, size_t size);

    // API of field "jobPath"

    static const int kJobPath = 9;

    /**
     * Clears the field "jobPath".
     *
     * The field will be set to its default value. The hasJobPath()
     * method will return false.
     */
    inline void clearJobPath();

    /**
     * Checks whether the field "jobPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobPath()). Otherwise it will return false.
     */
    inline bool hasJobPath () const;

    /**
     * Returns the value of the member "jobPath".
     *
     * If the meaning of "jobPath" isn't clear, then there should be a description here.
     *
     * @return The value of the field "jobPath"
     */
    inline const ::std::string& getJobPath () const;

    /**
     * Retrieves the value of the field "jobPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jobPath".
     */
    inline ::std::string& getJobPathMutable ();

    /**
     * Sets the value of the member "jobPath".
     *
     * If the meaning of "jobPath" isn't clear, then there should be a description here.
     *
     * @param jobPath The value which will be set
     */
    inline void setJobPath (const ::std::string& jobPath_);

    /**
     * Sets the value of the member "jobPath".
     *
     * If the meaning of "jobPath" isn't clear, then there should be a description here.
     *
     * @param jobPath The value which will be set
     */
    inline void setJobPath (const char* jobPath_);

    /**
     * Sets the value of the member "jobPath".
     *
     * If the meaning of "jobPath" isn't clear, then there should be a description here.
     *
     * @param jobPath The value which will be set
     */
    inline void setJobPath (const char* value, size_t size);

    static const units &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_description ();

    inline void clear_has_description ();

    inline void set_has_loadState ();

    inline void clear_has_loadState ();

    inline void set_has_activeState ();

    inline void clear_has_activeState ();

    inline void set_has_subState ();

    inline void clear_has_subState ();

    inline void set_has_follower ();

    inline void clear_has_follower ();

    inline void set_has_path ();

    inline void clear_has_path ();

    inline void set_has_jobId ();

    inline void clear_has_jobId ();

    inline void set_has_jobType ();

    inline void clear_has_jobType ();

    inline void set_has_jobPath ();

    inline void clear_has_jobPath ();

    uint32 _has_bits_[ (10 + 31) / 32];

    ::std::string _name;

    ::std::string _description;

    ::std::string _loadState;

    ::std::string _activeState;

    ::std::string _subState;

    ::std::string _follower;

    ::std::string _path;

    uint32 _jobId;

    ::std::string _jobType;

    ::std::string _jobPath;

};

/**
 * Job info structure
 */
class jobs {
public:

    /**
     * Default constructor
     */
    inline  jobs ();

    /**
     * Copy constructor
     */
    inline  jobs (const jobs &rhs);

    /**
     * All fields constructor
     */
    inline  jobs (uint32 jobId_, const ::std::string& primaryUnit_, const ::std::string& type_, const ::std::string& state_, const ::std::string& path_, const ::std::string& unitPath_);

    /**
     * Destructor
     */
    inline  ~jobs();

    /**
     * Assignment operator
     */
    inline jobs& operator = (const jobs& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const jobs& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const jobs& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const jobs& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const jobs& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jobId"

    static const int kJobId = 0;

    /**
     * Clears the field "jobId".
     *
     * The field will be set to its default value. The hasJobId()
     * method will return false.
     */
    inline void clearJobId();

    /**
     * Checks whether the field "jobId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobId()). Otherwise it will return false.
     */
    inline bool hasJobId () const;

    /**
     * Returns the value of the member "jobId".
     *
     * If the meaning of "jobId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "jobId"
     */
    inline uint32 getJobId () const;

    /**
     * Sets the value of the member "jobId".
     *
     * If the meaning of "jobId" isn't clear, then there should be a description here.
     *
     * @param jobId The value which will be set
     */
    inline void setJobId (uint32 jobId_);

    // API of field "primaryUnit"

    static const int kPrimaryUnit = 1;

    /**
     * Clears the field "primaryUnit".
     *
     * The field will be set to its default value. The hasPrimaryUnit()
     * method will return false.
     */
    inline void clearPrimaryUnit();

    /**
     * Checks whether the field "primaryUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrimaryUnit()). Otherwise it will return false.
     */
    inline bool hasPrimaryUnit () const;

    /**
     * Returns the value of the member "primaryUnit".
     *
     * If the meaning of "primaryUnit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "primaryUnit"
     */
    inline const ::std::string& getPrimaryUnit () const;

    /**
     * Retrieves the value of the field "primaryUnit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "primaryUnit".
     */
    inline ::std::string& getPrimaryUnitMutable ();

    /**
     * Sets the value of the member "primaryUnit".
     *
     * If the meaning of "primaryUnit" isn't clear, then there should be a description here.
     *
     * @param primaryUnit The value which will be set
     */
    inline void setPrimaryUnit (const ::std::string& primaryUnit_);

    /**
     * Sets the value of the member "primaryUnit".
     *
     * If the meaning of "primaryUnit" isn't clear, then there should be a description here.
     *
     * @param primaryUnit The value which will be set
     */
    inline void setPrimaryUnit (const char* primaryUnit_);

    /**
     * Sets the value of the member "primaryUnit".
     *
     * If the meaning of "primaryUnit" isn't clear, then there should be a description here.
     *
     * @param primaryUnit The value which will be set
     */
    inline void setPrimaryUnit (const char* value, size_t size);

    // API of field "type"

    static const int kType = 2;

    /**
     * Clears the field "type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "type".
     *
     * If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "type"
     */
    inline const ::std::string& getType () const;

    /**
     * Retrieves the value of the field "type" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "type".
     */
    inline ::std::string& getTypeMutable ();

    /**
     * Sets the value of the member "type".
     *
     * If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @param type The value which will be set
     */
    inline void setType (const ::std::string& type_);

    /**
     * Sets the value of the member "type".
     *
     * If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @param type The value which will be set
     */
    inline void setType (const char* type_);

    /**
     * Sets the value of the member "type".
     *
     * If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @param type The value which will be set
     */
    inline void setType (const char* value, size_t size);

    // API of field "state"

    static const int kState = 3;

    /**
     * Clears the field "state".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "state" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "state".
     *
     * If the meaning of "state" isn't clear, then there should be a description here.
     *
     * @return The value of the field "state"
     */
    inline const ::std::string& getState () const;

    /**
     * Retrieves the value of the field "state" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "state".
     */
    inline ::std::string& getStateMutable ();

    /**
     * Sets the value of the member "state".
     *
     * If the meaning of "state" isn't clear, then there should be a description here.
     *
     * @param state The value which will be set
     */
    inline void setState (const ::std::string& state_);

    /**
     * Sets the value of the member "state".
     *
     * If the meaning of "state" isn't clear, then there should be a description here.
     *
     * @param state The value which will be set
     */
    inline void setState (const char* state_);

    /**
     * Sets the value of the member "state".
     *
     * If the meaning of "state" isn't clear, then there should be a description here.
     *
     * @param state The value which will be set
     */
    inline void setState (const char* value, size_t size);

    // API of field "path"

    static const int kPath = 4;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    // API of field "unitPath"

    static const int kUnitPath = 5;

    /**
     * Clears the field "unitPath".
     *
     * The field will be set to its default value. The hasUnitPath()
     * method will return false.
     */
    inline void clearUnitPath();

    /**
     * Checks whether the field "unitPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnitPath()). Otherwise it will return false.
     */
    inline bool hasUnitPath () const;

    /**
     * Returns the value of the member "unitPath".
     *
     * If the meaning of "unitPath" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unitPath"
     */
    inline const ::std::string& getUnitPath () const;

    /**
     * Retrieves the value of the field "unitPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unitPath".
     */
    inline ::std::string& getUnitPathMutable ();

    /**
     * Sets the value of the member "unitPath".
     *
     * If the meaning of "unitPath" isn't clear, then there should be a description here.
     *
     * @param unitPath The value which will be set
     */
    inline void setUnitPath (const ::std::string& unitPath_);

    /**
     * Sets the value of the member "unitPath".
     *
     * If the meaning of "unitPath" isn't clear, then there should be a description here.
     *
     * @param unitPath The value which will be set
     */
    inline void setUnitPath (const char* unitPath_);

    /**
     * Sets the value of the member "unitPath".
     *
     * If the meaning of "unitPath" isn't clear, then there should be a description here.
     *
     * @param unitPath The value which will be set
     */
    inline void setUnitPath (const char* value, size_t size);

    static const jobs &getDefaultInstance();

private:

    inline void set_has_jobId ();

    inline void clear_has_jobId ();

    inline void set_has_primaryUnit ();

    inline void clear_has_primaryUnit ();

    inline void set_has_type ();

    inline void clear_has_type ();

    inline void set_has_state ();

    inline void clear_has_state ();

    inline void set_has_path ();

    inline void clear_has_path ();

    inline void set_has_unitPath ();

    inline void clear_has_unitPath ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint32 _jobId;

    ::std::string _primaryUnit;

    ::std::string _type;

    ::std::string _state;

    ::std::string _path;

    ::std::string _unitPath;

};

/**
 * struct generated for DBus argument ListUnitFiles_changes
 */
class files {
public:

    /**
     * Default constructor
     */
    inline  files ();

    /**
     * Copy constructor
     */
    inline  files (const files &rhs);

    /**
     * All fields constructor
     */
    inline  files (const ::std::string& unitName_, const ::std::string& enablement_);

    /**
     * Destructor
     */
    inline  ~files();

    /**
     * Assignment operator
     */
    inline files& operator = (const files& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const files& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const files& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const files& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const files& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "unitName"

    static const int kUnitName = 0;

    /**
     * Clears the field "unitName".
     *
     * The field will be set to its default value. The hasUnitName()
     * method will return false.
     */
    inline void clearUnitName();

    /**
     * Checks whether the field "unitName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnitName()). Otherwise it will return false.
     */
    inline bool hasUnitName () const;

    /**
     * Returns the value of the member "unitName".
     *
     * If the meaning of "unitName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unitName"
     */
    inline const ::std::string& getUnitName () const;

    /**
     * Retrieves the value of the field "unitName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unitName".
     */
    inline ::std::string& getUnitNameMutable ();

    /**
     * Sets the value of the member "unitName".
     *
     * If the meaning of "unitName" isn't clear, then there should be a description here.
     *
     * @param unitName The value which will be set
     */
    inline void setUnitName (const ::std::string& unitName_);

    /**
     * Sets the value of the member "unitName".
     *
     * If the meaning of "unitName" isn't clear, then there should be a description here.
     *
     * @param unitName The value which will be set
     */
    inline void setUnitName (const char* unitName_);

    /**
     * Sets the value of the member "unitName".
     *
     * If the meaning of "unitName" isn't clear, then there should be a description here.
     *
     * @param unitName The value which will be set
     */
    inline void setUnitName (const char* value, size_t size);

    // API of field "enablement"

    static const int kEnablement = 1;

    /**
     * Clears the field "enablement".
     *
     * The field will be set to its default value. The hasEnablement()
     * method will return false.
     */
    inline void clearEnablement();

    /**
     * Checks whether the field "enablement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnablement()). Otherwise it will return false.
     */
    inline bool hasEnablement () const;

    /**
     * Returns the value of the member "enablement".
     *
     * If the meaning of "enablement" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enablement"
     */
    inline const ::std::string& getEnablement () const;

    /**
     * Retrieves the value of the field "enablement" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "enablement".
     */
    inline ::std::string& getEnablementMutable ();

    /**
     * Sets the value of the member "enablement".
     *
     * If the meaning of "enablement" isn't clear, then there should be a description here.
     *
     * @param enablement The value which will be set
     */
    inline void setEnablement (const ::std::string& enablement_);

    /**
     * Sets the value of the member "enablement".
     *
     * If the meaning of "enablement" isn't clear, then there should be a description here.
     *
     * @param enablement The value which will be set
     */
    inline void setEnablement (const char* enablement_);

    /**
     * Sets the value of the member "enablement".
     *
     * If the meaning of "enablement" isn't clear, then there should be a description here.
     *
     * @param enablement The value which will be set
     */
    inline void setEnablement (const char* value, size_t size);

    static const files &getDefaultInstance();

private:

    inline void set_has_unitName ();

    inline void clear_has_unitName ();

    inline void set_has_enablement ();

    inline void clear_has_enablement ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _unitName;

    ::std::string _enablement;

};

/**
 * Change info struct
 */
class changes {
public:

    /**
     * Default constructor
     */
    inline  changes ();

    /**
     * Copy constructor
     */
    inline  changes (const changes &rhs);

    /**
     * All fields constructor
     */
    inline  changes (const ::std::string& type_, const ::std::string& filename_, const ::std::string& destination_);

    /**
     * Destructor
     */
    inline  ~changes();

    /**
     * Assignment operator
     */
    inline changes& operator = (const changes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const changes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const changes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const changes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const changes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "type"

    static const int kType = 0;

    /**
     * Clears the field "type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "type".
     *
     * change type, one of 'symlink' or 'unlink'
     *
     * @return The value of the field "type"
     */
    inline const ::std::string& getType () const;

    /**
     * Retrieves the value of the field "type" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "type".
     */
    inline ::std::string& getTypeMutable ();

    /**
     * Sets the value of the member "type".
     *
     * change type, one of 'symlink' or 'unlink'
     *
     * @param type The value which will be set
     */
    inline void setType (const ::std::string& type_);

    /**
     * Sets the value of the member "type".
     *
     * change type, one of 'symlink' or 'unlink'
     *
     * @param type The value which will be set
     */
    inline void setType (const char* type_);

    /**
     * Sets the value of the member "type".
     *
     * change type, one of 'symlink' or 'unlink'
     *
     * @param type The value which will be set
     */
    inline void setType (const char* value, size_t size);

    // API of field "filename"

    static const int kFilename = 1;

    /**
     * Clears the field "filename".
     *
     * The field will be set to its default value. The hasFilename()
     * method will return false.
     */
    inline void clearFilename();

    /**
     * Checks whether the field "filename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilename()). Otherwise it will return false.
     */
    inline bool hasFilename () const;

    /**
     * Returns the value of the member "filename".
     *
     * If the meaning of "filename" isn't clear, then there should be a description here.
     *
     * @return The value of the field "filename"
     */
    inline const ::std::string& getFilename () const;

    /**
     * Retrieves the value of the field "filename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "filename".
     */
    inline ::std::string& getFilenameMutable ();

    /**
     * Sets the value of the member "filename".
     *
     * If the meaning of "filename" isn't clear, then there should be a description here.
     *
     * @param filename The value which will be set
     */
    inline void setFilename (const ::std::string& filename_);

    /**
     * Sets the value of the member "filename".
     *
     * If the meaning of "filename" isn't clear, then there should be a description here.
     *
     * @param filename The value which will be set
     */
    inline void setFilename (const char* filename_);

    /**
     * Sets the value of the member "filename".
     *
     * If the meaning of "filename" isn't clear, then there should be a description here.
     *
     * @param filename The value which will be set
     */
    inline void setFilename (const char* value, size_t size);

    // API of field "destination"

    static const int kDestination = 2;

    /**
     * Clears the field "destination".
     *
     * The field will be set to its default value. The hasDestination()
     * method will return false.
     */
    inline void clearDestination();

    /**
     * Checks whether the field "destination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestination()). Otherwise it will return false.
     */
    inline bool hasDestination () const;

    /**
     * Returns the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destination"
     */
    inline const ::std::string& getDestination () const;

    /**
     * Retrieves the value of the field "destination" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "destination".
     */
    inline ::std::string& getDestinationMutable ();

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const ::std::string& destination_);

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const char* destination_);

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const char* value, size_t size);

    static const changes &getDefaultInstance();

private:

    inline void set_has_type ();

    inline void clear_has_type ();

    inline void set_has_filename ();

    inline void clear_has_filename ();

    inline void set_has_destination ();

    inline void clear_has_destination ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _type;

    ::std::string _filename;

    ::std::string _destination;

};

/**
 * Property info struct
 */
class property {
public:

    /**
     * Default constructor
     */
    inline  property ();

    /**
     * Copy constructor
     */
    inline  property (const property &rhs);

    /**
     * All fields constructor
     */
    inline  property (const ::std::string& name_, const ::std::string& value_);

    /**
     * Destructor
     */
    inline  ~property();

    /**
     * Assignment operator
     */
    inline property& operator = (const property& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const property& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const property& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const property& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const property& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * change type, one of 'symlink' or 'unlink'
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * change type, one of 'symlink' or 'unlink'
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * change type, one of 'symlink' or 'unlink'
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * change type, one of 'symlink' or 'unlink'
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::std::string& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::std::string& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::std::string& value_);

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const char* value_);

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const char* value, size_t size);

    static const property &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::std::string _value;

};

/**
 * transientunitdata info struct
 */
class transientunitdata {
public:

    /**
     * Default constructor
     */
    inline  transientunitdata ();

    /**
     * Copy constructor
     */
    inline  transientunitdata (const transientunitdata &rhs);

    /**
     * All fields constructor
     */
    inline  transientunitdata (const ::std::string& name_, const ::std::vector< property >& transientproperties_);

    /**
     * Destructor
     */
    inline  ~transientunitdata();

    /**
     * Assignment operator
     */
    inline transientunitdata& operator = (const transientunitdata& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const transientunitdata& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const transientunitdata& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const transientunitdata& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const transientunitdata& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * change type, one of 'symlink' or 'unlink'
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * change type, one of 'symlink' or 'unlink'
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * change type, one of 'symlink' or 'unlink'
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * change type, one of 'symlink' or 'unlink'
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "transientproperties"

    static const int kTransientproperties = 1;

    /**
     * Clears the field "transientproperties".
     *
     * The field will be set to its default value. The hasTransientproperties()
     * method will return false.
     */
    inline void clearTransientproperties();

    /**
     * Checks whether the field "transientproperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransientproperties()). Otherwise it will return false.
     */
    inline bool hasTransientproperties () const;

    /**
     * Returns the value of the member "transientproperties".
     *
     * If the meaning of "transientproperties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "transientproperties"
     */
    inline const ::std::vector< property >& getTransientproperties () const;

    /**
     * Retrieves the value of the field "transientproperties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "transientproperties".
     */
    inline ::std::vector< property >& getTransientpropertiesMutable ();

    /**
     * Sets the value of the member "transientproperties".
     *
     * If the meaning of "transientproperties" isn't clear, then there should be a description here.
     *
     * @param transientproperties The value which will be set
     */
    inline void setTransientproperties (const ::std::vector< property >& transientproperties_);

    static const transientunitdata &getDefaultInstance();

private:

    static const ::std::vector< property >& getPropertyList_DefaultInstance ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_transientproperties ();

    inline void clear_has_transientproperties ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::std::vector< property > _transientproperties;

};

/**
 * GetUnit() may be used to get the unit object path
 * 	    for a unit name. It takes the unit name and returns the object path.
 * 	    If a unit has not been loaded yet by this name this call will fail.
 */
class GetUnitRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUnitRequest ();

    /**
     * Copy constructor
     */
    inline  GetUnitRequest (const GetUnitRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetUnitRequest (const ::std::string& name_);

    /**
     * Destructor
     */
    inline virtual  ~GetUnitRequest();

    /**
     * Assignment operator
     */
    inline GetUnitRequest& operator = (const GetUnitRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUnitRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUnitRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUnitRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUnitRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const GetUnitRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _name;

};

/**
 * GetUnit() may be used to get the unit object path
 * 	    for a unit name. It takes the unit name and returns the object path.
 * 	    If a unit has not been loaded yet by this name this call will fail.
 */
class GetUnitResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUnitResponse ();

    /**
     * Copy constructor
     */
    inline  GetUnitResponse (const GetUnitResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetUnitResponse (const ::std::string& unit_);

    /**
     * Destructor
     */
    inline virtual  ~GetUnitResponse();

    /**
     * Assignment operator
     */
    inline GetUnitResponse& operator = (const GetUnitResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUnitResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUnitResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUnitResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUnitResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "unit"

    static const int kUnit = 0;

    /**
     * Clears the field "unit".
     *
     * The field will be set to its default value. The hasUnit()
     * method will return false.
     */
    inline void clearUnit();

    /**
     * Checks whether the field "unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnit()). Otherwise it will return false.
     */
    inline bool hasUnit () const;

    /**
     * Returns the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unit"
     */
    inline const ::std::string& getUnit () const;

    /**
     * Retrieves the value of the field "unit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unit".
     */
    inline ::std::string& getUnitMutable ();

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const ::std::string& unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* value, size_t size);

    static const GetUnitResponse &getDefaultInstance();

private:

    inline void set_has_unit ();

    inline void clear_has_unit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _unit;

};

/**
 * GetUnitByPID() may be used to get the unit object path of the unit a process ID belongs to.
 * 	    Takes a Unix PID and returns the object path. The PID must refer to an existing process of the system.
 */
class GetUnitByPIDRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUnitByPIDRequest ();

    /**
     * Copy constructor
     */
    inline  GetUnitByPIDRequest (const GetUnitByPIDRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetUnitByPIDRequest (uint32 pid_);

    /**
     * Destructor
     */
    inline virtual  ~GetUnitByPIDRequest();

    /**
     * Assignment operator
     */
    inline GetUnitByPIDRequest& operator = (const GetUnitByPIDRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUnitByPIDRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUnitByPIDRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUnitByPIDRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUnitByPIDRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline uint32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (uint32 pid_);

    static const GetUnitByPIDRequest &getDefaultInstance();

private:

    inline void set_has_pid ();

    inline void clear_has_pid ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _pid;

};

/**
 * GetUnitByPID() may be used to get the unit object path of the unit a process ID belongs to.
 * 	    Takes a Unix PID and returns the object path. The PID must refer to an existing process of the system.
 */
class GetUnitByPIDResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUnitByPIDResponse ();

    /**
     * Copy constructor
     */
    inline  GetUnitByPIDResponse (const GetUnitByPIDResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetUnitByPIDResponse (const ::std::string& unit_);

    /**
     * Destructor
     */
    inline virtual  ~GetUnitByPIDResponse();

    /**
     * Assignment operator
     */
    inline GetUnitByPIDResponse& operator = (const GetUnitByPIDResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUnitByPIDResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUnitByPIDResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUnitByPIDResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUnitByPIDResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "unit"

    static const int kUnit = 0;

    /**
     * Clears the field "unit".
     *
     * The field will be set to its default value. The hasUnit()
     * method will return false.
     */
    inline void clearUnit();

    /**
     * Checks whether the field "unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnit()). Otherwise it will return false.
     */
    inline bool hasUnit () const;

    /**
     * Returns the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unit"
     */
    inline const ::std::string& getUnit () const;

    /**
     * Retrieves the value of the field "unit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unit".
     */
    inline ::std::string& getUnitMutable ();

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const ::std::string& unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* value, size_t size);

    static const GetUnitByPIDResponse &getDefaultInstance();

private:

    inline void set_has_unit ();

    inline void clear_has_unit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _unit;

};

/**
 * LoadUnit() is similar to GetUnit() but will load the unit from disk if possible
 */
class LoadUnitRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoadUnitRequest ();

    /**
     * Copy constructor
     */
    inline  LoadUnitRequest (const LoadUnitRequest &rhs);

    /**
     * All fields constructor
     */
    inline  LoadUnitRequest (const ::std::string& name_);

    /**
     * Destructor
     */
    inline virtual  ~LoadUnitRequest();

    /**
     * Assignment operator
     */
    inline LoadUnitRequest& operator = (const LoadUnitRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoadUnitRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoadUnitRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoadUnitRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoadUnitRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const LoadUnitRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _name;

};

/**
 * LoadUnit() is similar to GetUnit() but will load the unit from disk if possible
 */
class LoadUnitResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoadUnitResponse ();

    /**
     * Copy constructor
     */
    inline  LoadUnitResponse (const LoadUnitResponse &rhs);

    /**
     * All fields constructor
     */
    inline  LoadUnitResponse (const ::std::string& unit_);

    /**
     * Destructor
     */
    inline virtual  ~LoadUnitResponse();

    /**
     * Assignment operator
     */
    inline LoadUnitResponse& operator = (const LoadUnitResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoadUnitResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoadUnitResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoadUnitResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoadUnitResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "unit"

    static const int kUnit = 0;

    /**
     * Clears the field "unit".
     *
     * The field will be set to its default value. The hasUnit()
     * method will return false.
     */
    inline void clearUnit();

    /**
     * Checks whether the field "unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnit()). Otherwise it will return false.
     */
    inline bool hasUnit () const;

    /**
     * Returns the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unit"
     */
    inline const ::std::string& getUnit () const;

    /**
     * Retrieves the value of the field "unit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unit".
     */
    inline ::std::string& getUnitMutable ();

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const ::std::string& unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* value, size_t size);

    static const LoadUnitResponse &getDefaultInstance();

private:

    inline void set_has_unit ();

    inline void clear_has_unit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _unit;

};

/**
 * StartUnit() enqeues a start job, and possibly depending jobs. Takes the unit to activate, plus a mode string.
 *     	The mode needs to be one of replace, fail, isolate, ignore-dependencies, ignore-requirements.
 *     	If "replace" the call will start the unit and its dependencies, possibly replacing already queued jobs that conflict with this.
 *     	If "fail" the call will start the unit and its dependencies, but will fail if this would change an already queued job.
 *     	If "isolate" the call will start the unit in question and terminate all units that aren't dependencies of it.
 *      	If "ignore-dependencies" it will start a unit but ignore all its dependencies.
 *     	If "ignore-requirements" it will start a unit but only ignore the requirement dependencies.
 *     	It is not recommended to make use of the latter two options. Returns the newly created job object.
 */
class StartUnitRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartUnitRequest ();

    /**
     * Copy constructor
     */
    inline  StartUnitRequest (const StartUnitRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartUnitRequest (const ::std::string& name_, const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~StartUnitRequest();

    /**
     * Assignment operator
     */
    inline StartUnitRequest& operator = (const StartUnitRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartUnitRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartUnitRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartUnitRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartUnitRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const StartUnitRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::std::string _mode;

};

/**
 * StartUnit() enqeues a start job, and possibly depending jobs. Takes the unit to activate, plus a mode string.
 *     	The mode needs to be one of replace, fail, isolate, ignore-dependencies, ignore-requirements.
 *     	If "replace" the call will start the unit and its dependencies, possibly replacing already queued jobs that conflict with this.
 *     	If "fail" the call will start the unit and its dependencies, but will fail if this would change an already queued job.
 *     	If "isolate" the call will start the unit in question and terminate all units that aren't dependencies of it.
 *      	If "ignore-dependencies" it will start a unit but ignore all its dependencies.
 *     	If "ignore-requirements" it will start a unit but only ignore the requirement dependencies.
 *     	It is not recommended to make use of the latter two options. Returns the newly created job object.
 */
class StartUnitResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartUnitResponse ();

    /**
     * Copy constructor
     */
    inline  StartUnitResponse (const StartUnitResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StartUnitResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~StartUnitResponse();

    /**
     * Assignment operator
     */
    inline StartUnitResponse& operator = (const StartUnitResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartUnitResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartUnitResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartUnitResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartUnitResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const StartUnitResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * StartUnitReplace() is similar to StartUnit() but replaces a job that is queued for one unit by a job for another.
 */
class StartUnitReplaceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartUnitReplaceRequest ();

    /**
     * Copy constructor
     */
    inline  StartUnitReplaceRequest (const StartUnitReplaceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartUnitReplaceRequest (const ::std::string& old_unit_, const ::std::string& new_unit_, const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~StartUnitReplaceRequest();

    /**
     * Assignment operator
     */
    inline StartUnitReplaceRequest& operator = (const StartUnitReplaceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartUnitReplaceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartUnitReplaceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartUnitReplaceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartUnitReplaceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "old_unit"

    static const int kOld_unit = 0;

    /**
     * Clears the field "old_unit".
     *
     * The field will be set to its default value. The hasOld_unit()
     * method will return false.
     */
    inline void clearOld_unit();

    /**
     * Checks whether the field "old_unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOld_unit()). Otherwise it will return false.
     */
    inline bool hasOld_unit () const;

    /**
     * Returns the value of the member "old_unit".
     *
     * If the meaning of "old_unit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "old_unit"
     */
    inline const ::std::string& getOld_unit () const;

    /**
     * Retrieves the value of the field "old_unit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "old_unit".
     */
    inline ::std::string& getOld_unitMutable ();

    /**
     * Sets the value of the member "old_unit".
     *
     * If the meaning of "old_unit" isn't clear, then there should be a description here.
     *
     * @param old_unit The value which will be set
     */
    inline void setOld_unit (const ::std::string& old_unit_);

    /**
     * Sets the value of the member "old_unit".
     *
     * If the meaning of "old_unit" isn't clear, then there should be a description here.
     *
     * @param old_unit The value which will be set
     */
    inline void setOld_unit (const char* old_unit_);

    /**
     * Sets the value of the member "old_unit".
     *
     * If the meaning of "old_unit" isn't clear, then there should be a description here.
     *
     * @param old_unit The value which will be set
     */
    inline void setOld_unit (const char* value, size_t size);

    // API of field "new_unit"

    static const int kNew_unit = 1;

    /**
     * Clears the field "new_unit".
     *
     * The field will be set to its default value. The hasNew_unit()
     * method will return false.
     */
    inline void clearNew_unit();

    /**
     * Checks whether the field "new_unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNew_unit()). Otherwise it will return false.
     */
    inline bool hasNew_unit () const;

    /**
     * Returns the value of the member "new_unit".
     *
     * If the meaning of "new_unit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "new_unit"
     */
    inline const ::std::string& getNew_unit () const;

    /**
     * Retrieves the value of the field "new_unit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "new_unit".
     */
    inline ::std::string& getNew_unitMutable ();

    /**
     * Sets the value of the member "new_unit".
     *
     * If the meaning of "new_unit" isn't clear, then there should be a description here.
     *
     * @param new_unit The value which will be set
     */
    inline void setNew_unit (const ::std::string& new_unit_);

    /**
     * Sets the value of the member "new_unit".
     *
     * If the meaning of "new_unit" isn't clear, then there should be a description here.
     *
     * @param new_unit The value which will be set
     */
    inline void setNew_unit (const char* new_unit_);

    /**
     * Sets the value of the member "new_unit".
     *
     * If the meaning of "new_unit" isn't clear, then there should be a description here.
     *
     * @param new_unit The value which will be set
     */
    inline void setNew_unit (const char* value, size_t size);

    // API of field "mode"

    static const int kMode = 2;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const StartUnitReplaceRequest &getDefaultInstance();

private:

    inline void set_has_old_unit ();

    inline void clear_has_old_unit ();

    inline void set_has_new_unit ();

    inline void clear_has_new_unit ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _old_unit;

    ::std::string _new_unit;

    ::std::string _mode;

};

/**
 * StartUnitReplace() is similar to StartUnit() but replaces a job that is queued for one unit by a job for another.
 */
class StartUnitReplaceResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartUnitReplaceResponse ();

    /**
     * Copy constructor
     */
    inline  StartUnitReplaceResponse (const StartUnitReplaceResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StartUnitReplaceResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~StartUnitReplaceResponse();

    /**
     * Assignment operator
     */
    inline StartUnitReplaceResponse& operator = (const StartUnitReplaceResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartUnitReplaceResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartUnitReplaceResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartUnitReplaceResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartUnitReplaceResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const StartUnitReplaceResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * StopUnit() is similar to StartUnit() but stops the specified unit rather than starting it. Note that "isolate" mode is invalid for this call
 */
class StopUnitRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopUnitRequest ();

    /**
     * Copy constructor
     */
    inline  StopUnitRequest (const StopUnitRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StopUnitRequest (const ::std::string& name_, const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~StopUnitRequest();

    /**
     * Assignment operator
     */
    inline StopUnitRequest& operator = (const StopUnitRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopUnitRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopUnitRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopUnitRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopUnitRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const StopUnitRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::std::string _mode;

};

/**
 * StopUnit() is similar to StartUnit() but stops the specified unit rather than starting it. Note that "isolate" mode is invalid for this call
 */
class StopUnitResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopUnitResponse ();

    /**
     * Copy constructor
     */
    inline  StopUnitResponse (const StopUnitResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StopUnitResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~StopUnitResponse();

    /**
     * Assignment operator
     */
    inline StopUnitResponse& operator = (const StopUnitResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopUnitResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopUnitResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopUnitResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopUnitResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const StopUnitResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * ReloadUnit(), RestartUnit(), TryRestartUnit(), ReloadOrRestartUnit(), ReloadOrTryRestartUnit() may be used to restart and/or reload a unit,
 *     	and takes similar arguments as StartUnit(). Reloading is done only if the unit is already running and fails otherwise.
 *     	If a service is restarted that isn't running it will be started, unless the "Try" flavor is used in which case a service that isn't running is not affected by the restart.
 *     	The "ReloadOrRestart" flavors attempt a reload if the unit supports it and use a restart otherwise.
 */
class ReloadUnitRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadUnitRequest ();

    /**
     * Copy constructor
     */
    inline  ReloadUnitRequest (const ReloadUnitRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadUnitRequest (const ::std::string& name_, const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadUnitRequest();

    /**
     * Assignment operator
     */
    inline ReloadUnitRequest& operator = (const ReloadUnitRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadUnitRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadUnitRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadUnitRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadUnitRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const ReloadUnitRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::std::string _mode;

};

/**
 * ReloadUnit(), RestartUnit(), TryRestartUnit(), ReloadOrRestartUnit(), ReloadOrTryRestartUnit() may be used to restart and/or reload a unit,
 *     	and takes similar arguments as StartUnit(). Reloading is done only if the unit is already running and fails otherwise.
 *     	If a service is restarted that isn't running it will be started, unless the "Try" flavor is used in which case a service that isn't running is not affected by the restart.
 *     	The "ReloadOrRestart" flavors attempt a reload if the unit supports it and use a restart otherwise.
 */
class ReloadUnitResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadUnitResponse ();

    /**
     * Copy constructor
     */
    inline  ReloadUnitResponse (const ReloadUnitResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadUnitResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadUnitResponse();

    /**
     * Assignment operator
     */
    inline ReloadUnitResponse& operator = (const ReloadUnitResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadUnitResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadUnitResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadUnitResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadUnitResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const ReloadUnitResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * RestartUnit()
 */
class RestartUnitRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartUnitRequest ();

    /**
     * Copy constructor
     */
    inline  RestartUnitRequest (const RestartUnitRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RestartUnitRequest (const ::std::string& name_, const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~RestartUnitRequest();

    /**
     * Assignment operator
     */
    inline RestartUnitRequest& operator = (const RestartUnitRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartUnitRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartUnitRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartUnitRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartUnitRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const RestartUnitRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::std::string _mode;

};

/**
 * RestartUnit()
 */
class RestartUnitResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartUnitResponse ();

    /**
     * Copy constructor
     */
    inline  RestartUnitResponse (const RestartUnitResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RestartUnitResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~RestartUnitResponse();

    /**
     * Assignment operator
     */
    inline RestartUnitResponse& operator = (const RestartUnitResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartUnitResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartUnitResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartUnitResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartUnitResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const RestartUnitResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * TryRestartUnit()
 */
class TryRestartUnitRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TryRestartUnitRequest ();

    /**
     * Copy constructor
     */
    inline  TryRestartUnitRequest (const TryRestartUnitRequest &rhs);

    /**
     * All fields constructor
     */
    inline  TryRestartUnitRequest (const ::std::string& name_, const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~TryRestartUnitRequest();

    /**
     * Assignment operator
     */
    inline TryRestartUnitRequest& operator = (const TryRestartUnitRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TryRestartUnitRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TryRestartUnitRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TryRestartUnitRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TryRestartUnitRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const TryRestartUnitRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::std::string _mode;

};

/**
 * TryRestartUnit()
 */
class TryRestartUnitResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TryRestartUnitResponse ();

    /**
     * Copy constructor
     */
    inline  TryRestartUnitResponse (const TryRestartUnitResponse &rhs);

    /**
     * All fields constructor
     */
    inline  TryRestartUnitResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~TryRestartUnitResponse();

    /**
     * Assignment operator
     */
    inline TryRestartUnitResponse& operator = (const TryRestartUnitResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TryRestartUnitResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TryRestartUnitResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TryRestartUnitResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TryRestartUnitResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const TryRestartUnitResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * ReloadOrRestartUnit()
 */
class ReloadOrRestartUnitRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadOrRestartUnitRequest ();

    /**
     * Copy constructor
     */
    inline  ReloadOrRestartUnitRequest (const ReloadOrRestartUnitRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadOrRestartUnitRequest (const ::std::string& name_, const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadOrRestartUnitRequest();

    /**
     * Assignment operator
     */
    inline ReloadOrRestartUnitRequest& operator = (const ReloadOrRestartUnitRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadOrRestartUnitRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadOrRestartUnitRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadOrRestartUnitRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadOrRestartUnitRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const ReloadOrRestartUnitRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::std::string _mode;

};

/**
 * ReloadOrRestartUnit()
 */
class ReloadOrRestartUnitResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadOrRestartUnitResponse ();

    /**
     * Copy constructor
     */
    inline  ReloadOrRestartUnitResponse (const ReloadOrRestartUnitResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadOrRestartUnitResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadOrRestartUnitResponse();

    /**
     * Assignment operator
     */
    inline ReloadOrRestartUnitResponse& operator = (const ReloadOrRestartUnitResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadOrRestartUnitResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadOrRestartUnitResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadOrRestartUnitResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadOrRestartUnitResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const ReloadOrRestartUnitResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * ReloadOrTryRestartUnit()
 */
class ReloadOrTryRestartUnitRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadOrTryRestartUnitRequest ();

    /**
     * Copy constructor
     */
    inline  ReloadOrTryRestartUnitRequest (const ReloadOrTryRestartUnitRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadOrTryRestartUnitRequest (const ::std::string& name_, const ::std::string& mode_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadOrTryRestartUnitRequest();

    /**
     * Assignment operator
     */
    inline ReloadOrTryRestartUnitRequest& operator = (const ReloadOrTryRestartUnitRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadOrTryRestartUnitRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadOrTryRestartUnitRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadOrTryRestartUnitRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadOrTryRestartUnitRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const ReloadOrTryRestartUnitRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::std::string _mode;

};

/**
 * ReloadOrTryRestartUnit()
 */
class ReloadOrTryRestartUnitResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadOrTryRestartUnitResponse ();

    /**
     * Copy constructor
     */
    inline  ReloadOrTryRestartUnitResponse (const ReloadOrTryRestartUnitResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadOrTryRestartUnitResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadOrTryRestartUnitResponse();

    /**
     * Assignment operator
     */
    inline ReloadOrTryRestartUnitResponse& operator = (const ReloadOrTryRestartUnitResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadOrTryRestartUnitResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadOrTryRestartUnitResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadOrTryRestartUnitResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadOrTryRestartUnitResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const ReloadOrTryRestartUnitResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * KillUnit() may be used to kill (i.e. send a signal to) all processes of a unit.
 * 		Takes the unit name, an enum who and a UNIX signal number to send. The who enum is one of "main", "control" or "all".
 * 	 	If "main", only the main process of a unit is killed. If "control" only the control process of the unit is killed, if "all" all processes are killed.
 * 	 	A "control" process is for example a process that is configured via ExecStop= and is spawned in parallel to the main daemon process, in order to shut it down
 */
class KillUnitRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KillUnitRequest ();

    /**
     * Copy constructor
     */
    inline  KillUnitRequest (const KillUnitRequest &rhs);

    /**
     * All fields constructor
     */
    inline  KillUnitRequest (const ::std::string& name_, const ::std::string& who_, int32 signal_);

    /**
     * Destructor
     */
    inline virtual  ~KillUnitRequest();

    /**
     * Assignment operator
     */
    inline KillUnitRequest& operator = (const KillUnitRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KillUnitRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KillUnitRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KillUnitRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KillUnitRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "who"

    static const int kWho = 1;

    /**
     * Clears the field "who".
     *
     * The field will be set to its default value. The hasWho()
     * method will return false.
     */
    inline void clearWho();

    /**
     * Checks whether the field "who" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWho()). Otherwise it will return false.
     */
    inline bool hasWho () const;

    /**
     * Returns the value of the member "who".
     *
     * If the meaning of "who" isn't clear, then there should be a description here.
     *
     * @return The value of the field "who"
     */
    inline const ::std::string& getWho () const;

    /**
     * Retrieves the value of the field "who" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "who".
     */
    inline ::std::string& getWhoMutable ();

    /**
     * Sets the value of the member "who".
     *
     * If the meaning of "who" isn't clear, then there should be a description here.
     *
     * @param who The value which will be set
     */
    inline void setWho (const ::std::string& who_);

    /**
     * Sets the value of the member "who".
     *
     * If the meaning of "who" isn't clear, then there should be a description here.
     *
     * @param who The value which will be set
     */
    inline void setWho (const char* who_);

    /**
     * Sets the value of the member "who".
     *
     * If the meaning of "who" isn't clear, then there should be a description here.
     *
     * @param who The value which will be set
     */
    inline void setWho (const char* value, size_t size);

    // API of field "signal"

    static const int kSignal = 2;

    /**
     * Clears the field "signal".
     *
     * The field will be set to its default value. The hasSignal()
     * method will return false.
     */
    inline void clearSignal();

    /**
     * Checks whether the field "signal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSignal()). Otherwise it will return false.
     */
    inline bool hasSignal () const;

    /**
     * Returns the value of the member "signal".
     *
     * If the meaning of "signal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "signal"
     */
    inline int32 getSignal () const;

    /**
     * Sets the value of the member "signal".
     *
     * If the meaning of "signal" isn't clear, then there should be a description here.
     *
     * @param signal The value which will be set
     */
    inline void setSignal (int32 signal_);

    static const KillUnitRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_who ();

    inline void clear_has_who ();

    inline void set_has_signal ();

    inline void clear_has_signal ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _name;

    ::std::string _who;

    int32 _signal;

};

/**
 * ResetFailedUnit
 */
class ResetFailedUnitRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetFailedUnitRequest ();

    /**
     * Copy constructor
     */
    inline  ResetFailedUnitRequest (const ResetFailedUnitRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ResetFailedUnitRequest (const ::std::string& name_);

    /**
     * Destructor
     */
    inline virtual  ~ResetFailedUnitRequest();

    /**
     * Assignment operator
     */
    inline ResetFailedUnitRequest& operator = (const ResetFailedUnitRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetFailedUnitRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetFailedUnitRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetFailedUnitRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetFailedUnitRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const ResetFailedUnitRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _name;

};

/**
 * SetUnitProperties
 */
class SetUnitPropertiesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetUnitPropertiesRequest ();

    /**
     * Copy constructor
     */
    inline  SetUnitPropertiesRequest (const SetUnitPropertiesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetUnitPropertiesRequest (const ::std::string& name_, bool runtime_, const ::std::vector< property >& properties_);

    /**
     * Destructor
     */
    inline virtual  ~SetUnitPropertiesRequest();

    /**
     * Assignment operator
     */
    inline SetUnitPropertiesRequest& operator = (const SetUnitPropertiesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetUnitPropertiesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetUnitPropertiesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetUnitPropertiesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetUnitPropertiesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "runtime"

    static const int kRuntime = 1;

    /**
     * Clears the field "runtime".
     *
     * The field will be set to its default value. The hasRuntime()
     * method will return false.
     */
    inline void clearRuntime();

    /**
     * Checks whether the field "runtime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntime()). Otherwise it will return false.
     */
    inline bool hasRuntime () const;

    /**
     * Returns the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "runtime"
     */
    inline bool getRuntime () const;

    /**
     * Sets the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param runtime The value which will be set
     */
    inline void setRuntime (bool runtime_);

    // API of field "properties"

    static const int kProperties = 2;

    /**
     * Clears the field "properties".
     *
     * The field will be set to its default value. The hasProperties()
     * method will return false.
     */
    inline void clearProperties();

    /**
     * Checks whether the field "properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperties()). Otherwise it will return false.
     */
    inline bool hasProperties () const;

    /**
     * Returns the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "properties"
     */
    inline const ::std::vector< property >& getProperties () const;

    /**
     * Retrieves the value of the field "properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "properties".
     */
    inline ::std::vector< property >& getPropertiesMutable ();

    /**
     * Sets the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param properties The value which will be set
     */
    inline void setProperties (const ::std::vector< property >& properties_);

    static const SetUnitPropertiesRequest &getDefaultInstance();

private:

    static const ::std::vector< property >& getPropertyList_DefaultInstance ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_runtime ();

    inline void clear_has_runtime ();

    inline void set_has_properties ();

    inline void clear_has_properties ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _name;

    bool _runtime;

    ::std::vector< property > _properties;

};

/**
 * StartTransientUnit
 */
class StartTransientUnitRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartTransientUnitRequest ();

    /**
     * Copy constructor
     */
    inline  StartTransientUnitRequest (const StartTransientUnitRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartTransientUnitRequest (const ::std::string& name_, const ::std::string& mode_, const ::std::vector< property >& properties_, const ::std::vector< transientunitdata >& transientunitdata_);

    /**
     * Destructor
     */
    inline virtual  ~StartTransientUnitRequest();

    /**
     * Assignment operator
     */
    inline StartTransientUnitRequest& operator = (const StartTransientUnitRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartTransientUnitRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartTransientUnitRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartTransientUnitRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartTransientUnitRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    // API of field "properties"

    static const int kProperties = 2;

    /**
     * Clears the field "properties".
     *
     * The field will be set to its default value. The hasProperties()
     * method will return false.
     */
    inline void clearProperties();

    /**
     * Checks whether the field "properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperties()). Otherwise it will return false.
     */
    inline bool hasProperties () const;

    /**
     * Returns the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "properties"
     */
    inline const ::std::vector< property >& getProperties () const;

    /**
     * Retrieves the value of the field "properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "properties".
     */
    inline ::std::vector< property >& getPropertiesMutable ();

    /**
     * Sets the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param properties The value which will be set
     */
    inline void setProperties (const ::std::vector< property >& properties_);

    // API of field "transientunitdata"

    static const int kTransientunitdata = 3;

    /**
     * Clears the field "transientunitdata".
     *
     * The field will be set to its default value. The hasTransientunitdata()
     * method will return false.
     */
    inline void clearTransientunitdata();

    /**
     * Checks whether the field "transientunitdata" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransientunitdata()). Otherwise it will return false.
     */
    inline bool hasTransientunitdata () const;

    /**
     * Returns the value of the member "transientunitdata".
     *
     * If the meaning of "transientunitdata" isn't clear, then there should be a description here.
     *
     * @return The value of the field "transientunitdata"
     */
    inline const ::std::vector< transientunitdata >& getTransientunitdata () const;

    /**
     * Retrieves the value of the field "transientunitdata" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "transientunitdata".
     */
    inline ::std::vector< transientunitdata >& getTransientunitdataMutable ();

    /**
     * Sets the value of the member "transientunitdata".
     *
     * If the meaning of "transientunitdata" isn't clear, then there should be a description here.
     *
     * @param transientunitdata The value which will be set
     */
    inline void setTransientunitdata (const ::std::vector< transientunitdata >& transientunitdata_);

    static const StartTransientUnitRequest &getDefaultInstance();

private:

    static const ::std::vector< property >& getPropertyList_DefaultInstance ();

    static const ::std::vector< transientunitdata >& getTransientunitdataList_DefaultInstance ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    inline void set_has_properties ();

    inline void clear_has_properties ();

    inline void set_has_transientunitdata ();

    inline void clear_has_transientunitdata ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _name;

    ::std::string _mode;

    ::std::vector< property > _properties;

    ::std::vector< transientunitdata > _transientunitdata;

};

/**
 * StartTransientUnit
 */
class StartTransientUnitResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartTransientUnitResponse ();

    /**
     * Copy constructor
     */
    inline  StartTransientUnitResponse (const StartTransientUnitResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StartTransientUnitResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~StartTransientUnitResponse();

    /**
     * Assignment operator
     */
    inline StartTransientUnitResponse& operator = (const StartTransientUnitResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartTransientUnitResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartTransientUnitResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartTransientUnitResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartTransientUnitResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const StartTransientUnitResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * GetJob() returns the job object path for a specific job, identified by its id.
 */
class GetJobRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetJobRequest ();

    /**
     * Copy constructor
     */
    inline  GetJobRequest (const GetJobRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetJobRequest (uint32 id_);

    /**
     * Destructor
     */
    inline virtual  ~GetJobRequest();

    /**
     * Assignment operator
     */
    inline GetJobRequest& operator = (const GetJobRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetJobRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetJobRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetJobRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetJobRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "id"

    static const int kId = 0;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "id"
     */
    inline uint32 getId () const;

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (uint32 id_);

    static const GetJobRequest &getDefaultInstance();

private:

    inline void set_has_id ();

    inline void clear_has_id ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _id;

};

/**
 * GetJob() returns the job object path for a specific job, identified by its id.
 */
class GetJobResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetJobResponse ();

    /**
     * Copy constructor
     */
    inline  GetJobResponse (const GetJobResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetJobResponse (const ::std::string& job_);

    /**
     * Destructor
     */
    inline virtual  ~GetJobResponse();

    /**
     * Assignment operator
     */
    inline GetJobResponse& operator = (const GetJobResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetJobResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetJobResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetJobResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetJobResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "job"

    static const int kJob = 0;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    static const GetJobResponse &getDefaultInstance();

private:

    inline void set_has_job ();

    inline void clear_has_job ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _job;

};

/**
 * CancelJob() cancels a specific job identified by its numer ID. This operation is also available
 * 		in the Cancel() method of Job objects (see below), and exists primarily to reduce the necessary round trips to
 * 		execute this operation. Note that this will not have any effect on jobs whose execution has already begun.
 */
class CancelJobRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CancelJobRequest ();

    /**
     * Copy constructor
     */
    inline  CancelJobRequest (const CancelJobRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CancelJobRequest (uint32 id_);

    /**
     * Destructor
     */
    inline virtual  ~CancelJobRequest();

    /**
     * Assignment operator
     */
    inline CancelJobRequest& operator = (const CancelJobRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelJobRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelJobRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelJobRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelJobRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "id"

    static const int kId = 0;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "id"
     */
    inline uint32 getId () const;

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (uint32 id_);

    static const CancelJobRequest &getDefaultInstance();

private:

    inline void set_has_id ();

    inline void clear_has_id ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _id;

};

/**
 * ListUnits() returns an array with all currently loaded units. Note that units may be known by multiple names at the same name,
 * 		and hence there might be more unit names loaded than actual units behind them. The array consists of structures with the following elements:
 *
 *     	The primary unit name as string
 *     	The human readable description string
 *     	The load state (i.e. whether the unit file has been loaded successfully)
 *     	The active state (i.e. whether the unit is currently started or not)
 *     	The sub state (a more fine-grained version of the active state that is specific to the unit type, which the active state is not)
 *     	A unit that is being followed in its state by this unit, if there is any, otherwise the empty string.
 *     	The unit object path
 *     	If there is a job queued for the job unit the numeric job id, 0 otherwise
 *     	The job type as string
 *     	The job object path
 */
class ListUnitsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListUnitsResponse ();

    /**
     * Copy constructor
     */
    inline  ListUnitsResponse (const ListUnitsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ListUnitsResponse (const ::std::vector< units >& units_);

    /**
     * Destructor
     */
    inline virtual  ~ListUnitsResponse();

    /**
     * Assignment operator
     */
    inline ListUnitsResponse& operator = (const ListUnitsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListUnitsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListUnitsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListUnitsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListUnitsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "units"

    static const int kUnits = 0;

    /**
     * Clears the field "units".
     *
     * The field will be set to its default value. The hasUnits()
     * method will return false.
     */
    inline void clearUnits();

    /**
     * Checks whether the field "units" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnits()). Otherwise it will return false.
     */
    inline bool hasUnits () const;

    /**
     * Returns the value of the member "units".
     *
     * If the meaning of "units" isn't clear, then there should be a description here.
     *
     * @return The value of the field "units"
     */
    inline const ::std::vector< units >& getUnits () const;

    /**
     * Retrieves the value of the field "units" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "units".
     */
    inline ::std::vector< units >& getUnitsMutable ();

    /**
     * Sets the value of the member "units".
     *
     * If the meaning of "units" isn't clear, then there should be a description here.
     *
     * @param units The value which will be set
     */
    inline void setUnits (const ::std::vector< units >& units_);

    static const ListUnitsResponse &getDefaultInstance();

private:

    static const ::std::vector< units >& getUnitsList_DefaultInstance ();

    inline void set_has_units ();

    inline void clear_has_units ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< units > _units;

};

/**
 * ListUnitsFiltered
 */
class ListUnitsFilteredRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListUnitsFilteredRequest ();

    /**
     * Copy constructor
     */
    inline  ListUnitsFilteredRequest (const ListUnitsFilteredRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ListUnitsFilteredRequest (const ::std::vector< ::std::string >& unitList_);

    /**
     * Destructor
     */
    inline virtual  ~ListUnitsFilteredRequest();

    /**
     * Assignment operator
     */
    inline ListUnitsFilteredRequest& operator = (const ListUnitsFilteredRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListUnitsFilteredRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListUnitsFilteredRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListUnitsFilteredRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListUnitsFilteredRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "unitList"

    static const int kUnitList = 0;

    /**
     * Clears the field "unitList".
     *
     * The field will be set to its default value. The hasUnitList()
     * method will return false.
     */
    inline void clearUnitList();

    /**
     * Checks whether the field "unitList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnitList()). Otherwise it will return false.
     */
    inline bool hasUnitList () const;

    /**
     * Returns the value of the member "unitList".
     *
     * If the meaning of "unitList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unitList"
     */
    inline const ::std::vector< ::std::string >& getUnitList () const;

    /**
     * Retrieves the value of the field "unitList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unitList".
     */
    inline ::std::vector< ::std::string >& getUnitListMutable ();

    /**
     * Sets the value of the member "unitList".
     *
     * If the meaning of "unitList" isn't clear, then there should be a description here.
     *
     * @param unitList The value which will be set
     */
    inline void setUnitList (const ::std::vector< ::std::string >& unitList_);

    static const ListUnitsFilteredRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_unitList ();

    inline void clear_has_unitList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _unitList;

};

/**
 * ListUnitsFiltered
 */
class ListUnitsFilteredResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListUnitsFilteredResponse ();

    /**
     * Copy constructor
     */
    inline  ListUnitsFilteredResponse (const ListUnitsFilteredResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ListUnitsFilteredResponse (const ::std::vector< units >& units_);

    /**
     * Destructor
     */
    inline virtual  ~ListUnitsFilteredResponse();

    /**
     * Assignment operator
     */
    inline ListUnitsFilteredResponse& operator = (const ListUnitsFilteredResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListUnitsFilteredResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListUnitsFilteredResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListUnitsFilteredResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListUnitsFilteredResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "units"

    static const int kUnits = 0;

    /**
     * Clears the field "units".
     *
     * The field will be set to its default value. The hasUnits()
     * method will return false.
     */
    inline void clearUnits();

    /**
     * Checks whether the field "units" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnits()). Otherwise it will return false.
     */
    inline bool hasUnits () const;

    /**
     * Returns the value of the member "units".
     *
     * If the meaning of "units" isn't clear, then there should be a description here.
     *
     * @return The value of the field "units"
     */
    inline const ::std::vector< units >& getUnits () const;

    /**
     * Retrieves the value of the field "units" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "units".
     */
    inline ::std::vector< units >& getUnitsMutable ();

    /**
     * Sets the value of the member "units".
     *
     * If the meaning of "units" isn't clear, then there should be a description here.
     *
     * @param units The value which will be set
     */
    inline void setUnits (const ::std::vector< units >& units_);

    static const ListUnitsFilteredResponse &getDefaultInstance();

private:

    static const ::std::vector< units >& getUnitsList_DefaultInstance ();

    inline void set_has_units ();

    inline void clear_has_units ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< units > _units;

};

/**
 * ListJobs() returns an array with all currently queued jobs. Returns an array consisting of structures with the following elements:
 *
 *    		 The numeric job id
 *     	The primary unit name for this job
 *     	The job type as string
 *     	The job state as string
 *     	The job object path
 *     	The unit object path
 */
class ListJobsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListJobsResponse ();

    /**
     * Copy constructor
     */
    inline  ListJobsResponse (const ListJobsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ListJobsResponse (const ::std::vector< jobs >& jobs_);

    /**
     * Destructor
     */
    inline virtual  ~ListJobsResponse();

    /**
     * Assignment operator
     */
    inline ListJobsResponse& operator = (const ListJobsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListJobsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListJobsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListJobsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListJobsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jobs"

    static const int kJobs = 0;

    /**
     * Clears the field "jobs".
     *
     * The field will be set to its default value. The hasJobs()
     * method will return false.
     */
    inline void clearJobs();

    /**
     * Checks whether the field "jobs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobs()). Otherwise it will return false.
     */
    inline bool hasJobs () const;

    /**
     * Returns the value of the member "jobs".
     *
     * If the meaning of "jobs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "jobs"
     */
    inline const ::std::vector< jobs >& getJobs () const;

    /**
     * Retrieves the value of the field "jobs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jobs".
     */
    inline ::std::vector< jobs >& getJobsMutable ();

    /**
     * Sets the value of the member "jobs".
     *
     * If the meaning of "jobs" isn't clear, then there should be a description here.
     *
     * @param jobs The value which will be set
     */
    inline void setJobs (const ::std::vector< jobs >& jobs_);

    static const ListJobsResponse &getDefaultInstance();

private:

    static const ::std::vector< jobs >& getJobsList_DefaultInstance ();

    inline void set_has_jobs ();

    inline void clear_has_jobs ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< jobs > _jobs;

};

/**
 * Dump
 */
class DumpResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DumpResponse ();

    /**
     * Copy constructor
     */
    inline  DumpResponse (const DumpResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DumpResponse (const ::std::string& dump_);

    /**
     * Destructor
     */
    inline virtual  ~DumpResponse();

    /**
     * Assignment operator
     */
    inline DumpResponse& operator = (const DumpResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DumpResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DumpResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DumpResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DumpResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "dump"

    static const int kDump = 0;

    /**
     * Clears the field "dump".
     *
     * The field will be set to its default value. The hasDump()
     * method will return false.
     */
    inline void clearDump();

    /**
     * Checks whether the field "dump" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDump()). Otherwise it will return false.
     */
    inline bool hasDump () const;

    /**
     * Returns the value of the member "dump".
     *
     * If the meaning of "dump" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dump"
     */
    inline const ::std::string& getDump () const;

    /**
     * Retrieves the value of the field "dump" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dump".
     */
    inline ::std::string& getDumpMutable ();

    /**
     * Sets the value of the member "dump".
     *
     * If the meaning of "dump" isn't clear, then there should be a description here.
     *
     * @param dump The value which will be set
     */
    inline void setDump (const ::std::string& dump_);

    /**
     * Sets the value of the member "dump".
     *
     * If the meaning of "dump" isn't clear, then there should be a description here.
     *
     * @param dump The value which will be set
     */
    inline void setDump (const char* dump_);

    /**
     * Sets the value of the member "dump".
     *
     * If the meaning of "dump" isn't clear, then there should be a description here.
     *
     * @param dump The value which will be set
     */
    inline void setDump (const char* value, size_t size);

    static const DumpResponse &getDefaultInstance();

private:

    inline void set_has_dump ();

    inline void clear_has_dump ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _dump;

};

/**
 * CreateSnapshot() creates a snapshot unit for the current system state, and stores it under the specified name.
 * 		It will return the unit object path to the new snapshot. If the cleanup boolean is true the snapshot will be removed automatically
 * 		when it has been activated, otherwise it remains and can be activated multiple times. Snapshots are not persistent
 */
class CreateSnapshotRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateSnapshotRequest ();

    /**
     * Copy constructor
     */
    inline  CreateSnapshotRequest (const CreateSnapshotRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CreateSnapshotRequest (const ::std::string& name_, bool cleanup_);

    /**
     * Destructor
     */
    inline virtual  ~CreateSnapshotRequest();

    /**
     * Assignment operator
     */
    inline CreateSnapshotRequest& operator = (const CreateSnapshotRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateSnapshotRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateSnapshotRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateSnapshotRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateSnapshotRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "cleanup"

    static const int kCleanup = 1;

    /**
     * Clears the field "cleanup".
     *
     * The field will be set to its default value. The hasCleanup()
     * method will return false.
     */
    inline void clearCleanup();

    /**
     * Checks whether the field "cleanup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCleanup()). Otherwise it will return false.
     */
    inline bool hasCleanup () const;

    /**
     * Returns the value of the member "cleanup".
     *
     * If the meaning of "cleanup" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cleanup"
     */
    inline bool getCleanup () const;

    /**
     * Sets the value of the member "cleanup".
     *
     * If the meaning of "cleanup" isn't clear, then there should be a description here.
     *
     * @param cleanup The value which will be set
     */
    inline void setCleanup (bool cleanup_);

    static const CreateSnapshotRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_cleanup ();

    inline void clear_has_cleanup ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    bool _cleanup;

};

/**
 * CreateSnapshot() creates a snapshot unit for the current system state, and stores it under the specified name.
 * 		It will return the unit object path to the new snapshot. If the cleanup boolean is true the snapshot will be removed automatically
 * 		when it has been activated, otherwise it remains and can be activated multiple times. Snapshots are not persistent
 */
class CreateSnapshotResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateSnapshotResponse ();

    /**
     * Copy constructor
     */
    inline  CreateSnapshotResponse (const CreateSnapshotResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CreateSnapshotResponse (const ::std::string& unit_);

    /**
     * Destructor
     */
    inline virtual  ~CreateSnapshotResponse();

    /**
     * Assignment operator
     */
    inline CreateSnapshotResponse& operator = (const CreateSnapshotResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateSnapshotResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateSnapshotResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateSnapshotResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateSnapshotResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "unit"

    static const int kUnit = 0;

    /**
     * Clears the field "unit".
     *
     * The field will be set to its default value. The hasUnit()
     * method will return false.
     */
    inline void clearUnit();

    /**
     * Checks whether the field "unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnit()). Otherwise it will return false.
     */
    inline bool hasUnit () const;

    /**
     * Returns the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unit"
     */
    inline const ::std::string& getUnit () const;

    /**
     * Retrieves the value of the field "unit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unit".
     */
    inline ::std::string& getUnitMutable ();

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const ::std::string& unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* value, size_t size);

    static const CreateSnapshotResponse &getDefaultInstance();

private:

    inline void set_has_unit ();

    inline void clear_has_unit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _unit;

};

/**
 * RemoveSnapshot() removes a snapshot. This call is also available in the Remove() method of
 * 		Snapshot objects (see below), and exists primarily to reduce the number of required roundtrips for this call.
 */
class RemoveSnapshotRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveSnapshotRequest ();

    /**
     * Copy constructor
     */
    inline  RemoveSnapshotRequest (const RemoveSnapshotRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveSnapshotRequest (const ::std::string& name_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveSnapshotRequest();

    /**
     * Assignment operator
     */
    inline RemoveSnapshotRequest& operator = (const RemoveSnapshotRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveSnapshotRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveSnapshotRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveSnapshotRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveSnapshotRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const RemoveSnapshotRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _name;

};

/**
 * SwitchRoot() may be used to transition to a new root directory. This is intended to be used by initial RAM disks.
 *  		The call takes two arguments: the new root directory (which needs to be specified), plus an init binary path (which may be left empty,
 *  		in which case it is automatically searched for).
 *  		The state of the system manager will be serialized before the transition.
 *  		After the transition the manager binary on the main system is invoked and replaces the old PID 1. All state will then be deserialized.
 */
class SwitchRootRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwitchRootRequest ();

    /**
     * Copy constructor
     */
    inline  SwitchRootRequest (const SwitchRootRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SwitchRootRequest (const ::std::string& new_root_, const ::std::string& init_);

    /**
     * Destructor
     */
    inline virtual  ~SwitchRootRequest();

    /**
     * Assignment operator
     */
    inline SwitchRootRequest& operator = (const SwitchRootRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchRootRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchRootRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchRootRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchRootRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "new_root"

    static const int kNew_root = 0;

    /**
     * Clears the field "new_root".
     *
     * The field will be set to its default value. The hasNew_root()
     * method will return false.
     */
    inline void clearNew_root();

    /**
     * Checks whether the field "new_root" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNew_root()). Otherwise it will return false.
     */
    inline bool hasNew_root () const;

    /**
     * Returns the value of the member "new_root".
     *
     * If the meaning of "new_root" isn't clear, then there should be a description here.
     *
     * @return The value of the field "new_root"
     */
    inline const ::std::string& getNew_root () const;

    /**
     * Retrieves the value of the field "new_root" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "new_root".
     */
    inline ::std::string& getNew_rootMutable ();

    /**
     * Sets the value of the member "new_root".
     *
     * If the meaning of "new_root" isn't clear, then there should be a description here.
     *
     * @param new_root The value which will be set
     */
    inline void setNew_root (const ::std::string& new_root_);

    /**
     * Sets the value of the member "new_root".
     *
     * If the meaning of "new_root" isn't clear, then there should be a description here.
     *
     * @param new_root The value which will be set
     */
    inline void setNew_root (const char* new_root_);

    /**
     * Sets the value of the member "new_root".
     *
     * If the meaning of "new_root" isn't clear, then there should be a description here.
     *
     * @param new_root The value which will be set
     */
    inline void setNew_root (const char* value, size_t size);

    // API of field "init"

    static const int kInit = 1;

    /**
     * Clears the field "init".
     *
     * The field will be set to its default value. The hasInit()
     * method will return false.
     */
    inline void clearInit();

    /**
     * Checks whether the field "init" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInit()). Otherwise it will return false.
     */
    inline bool hasInit () const;

    /**
     * Returns the value of the member "init".
     *
     * If the meaning of "init" isn't clear, then there should be a description here.
     *
     * @return The value of the field "init"
     */
    inline const ::std::string& getInit () const;

    /**
     * Retrieves the value of the field "init" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "init".
     */
    inline ::std::string& getInitMutable ();

    /**
     * Sets the value of the member "init".
     *
     * If the meaning of "init" isn't clear, then there should be a description here.
     *
     * @param init The value which will be set
     */
    inline void setInit (const ::std::string& init_);

    /**
     * Sets the value of the member "init".
     *
     * If the meaning of "init" isn't clear, then there should be a description here.
     *
     * @param init The value which will be set
     */
    inline void setInit (const char* init_);

    /**
     * Sets the value of the member "init".
     *
     * If the meaning of "init" isn't clear, then there should be a description here.
     *
     * @param init The value which will be set
     */
    inline void setInit (const char* value, size_t size);

    static const SwitchRootRequest &getDefaultInstance();

private:

    inline void set_has_new_root ();

    inline void clear_has_new_root ();

    inline void set_has_init ();

    inline void clear_has_init ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _new_root;

    ::std::string _init;

};

/**
 * SetEnvironment() may be used to alter the environment block that is passed to all spawned processes.
 * 	    Takes a string array with environment variable assignments. Settings passed will override previously set variables
 */
class SetEnvironmentRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetEnvironmentRequest ();

    /**
     * Copy constructor
     */
    inline  SetEnvironmentRequest (const SetEnvironmentRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetEnvironmentRequest (const ::std::vector< ::std::string >& names_);

    /**
     * Destructor
     */
    inline virtual  ~SetEnvironmentRequest();

    /**
     * Assignment operator
     */
    inline SetEnvironmentRequest& operator = (const SetEnvironmentRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetEnvironmentRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetEnvironmentRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetEnvironmentRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetEnvironmentRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "names"

    static const int kNames = 0;

    /**
     * Clears the field "names".
     *
     * The field will be set to its default value. The hasNames()
     * method will return false.
     */
    inline void clearNames();

    /**
     * Checks whether the field "names" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNames()). Otherwise it will return false.
     */
    inline bool hasNames () const;

    /**
     * Returns the value of the member "names".
     *
     * If the meaning of "names" isn't clear, then there should be a description here.
     *
     * @return The value of the field "names"
     */
    inline const ::std::vector< ::std::string >& getNames () const;

    /**
     * Retrieves the value of the field "names" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "names".
     */
    inline ::std::vector< ::std::string >& getNamesMutable ();

    /**
     * Sets the value of the member "names".
     *
     * If the meaning of "names" isn't clear, then there should be a description here.
     *
     * @param names The value which will be set
     */
    inline void setNames (const ::std::vector< ::std::string >& names_);

    static const SetEnvironmentRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_names ();

    inline void clear_has_names ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _names;

};

/**
 * UnsetEnvironment() may be used to unset environment variables. Takes a string array with environment variable names.
 * 		All variables specified will be unset (if they have been set previously) and no longer be passed to all spawned processes.
 * 		This call has no effect for variables that were previously not set, but will not fail in that case.
 */
class UnsetEnvironmentRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnsetEnvironmentRequest ();

    /**
     * Copy constructor
     */
    inline  UnsetEnvironmentRequest (const UnsetEnvironmentRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UnsetEnvironmentRequest (const ::std::vector< ::std::string >& names_);

    /**
     * Destructor
     */
    inline virtual  ~UnsetEnvironmentRequest();

    /**
     * Assignment operator
     */
    inline UnsetEnvironmentRequest& operator = (const UnsetEnvironmentRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnsetEnvironmentRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnsetEnvironmentRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnsetEnvironmentRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnsetEnvironmentRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "names"

    static const int kNames = 0;

    /**
     * Clears the field "names".
     *
     * The field will be set to its default value. The hasNames()
     * method will return false.
     */
    inline void clearNames();

    /**
     * Checks whether the field "names" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNames()). Otherwise it will return false.
     */
    inline bool hasNames () const;

    /**
     * Returns the value of the member "names".
     *
     * If the meaning of "names" isn't clear, then there should be a description here.
     *
     * @return The value of the field "names"
     */
    inline const ::std::vector< ::std::string >& getNames () const;

    /**
     * Retrieves the value of the field "names" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "names".
     */
    inline ::std::vector< ::std::string >& getNamesMutable ();

    /**
     * Sets the value of the member "names".
     *
     * If the meaning of "names" isn't clear, then there should be a description here.
     *
     * @param names The value which will be set
     */
    inline void setNames (const ::std::vector< ::std::string >& names_);

    static const UnsetEnvironmentRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_names ();

    inline void clear_has_names ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _names;

};

/**
 * UnsetAndSetEnvironment() is a combination of UnsetEnvironment() and SetEnvironment().
 * 		It takes two lists. The first one is a list of variables to unset, the second one of assignments to set.
 * 		If a variable is listed in both the variable is set after this call, i.e. the set list overrides the unset list.
 */
class UnsetAndSetEnvironmentRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnsetAndSetEnvironmentRequest ();

    /**
     * Copy constructor
     */
    inline  UnsetAndSetEnvironmentRequest (const UnsetAndSetEnvironmentRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UnsetAndSetEnvironmentRequest (const ::std::vector< ::std::string >& unset_, const ::std::vector< ::std::string >& set_);

    /**
     * Destructor
     */
    inline virtual  ~UnsetAndSetEnvironmentRequest();

    /**
     * Assignment operator
     */
    inline UnsetAndSetEnvironmentRequest& operator = (const UnsetAndSetEnvironmentRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnsetAndSetEnvironmentRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnsetAndSetEnvironmentRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnsetAndSetEnvironmentRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnsetAndSetEnvironmentRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "unset"

    static const int kUnset = 0;

    /**
     * Clears the field "unset".
     *
     * The field will be set to its default value. The hasUnset()
     * method will return false.
     */
    inline void clearUnset();

    /**
     * Checks whether the field "unset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnset()). Otherwise it will return false.
     */
    inline bool hasUnset () const;

    /**
     * Returns the value of the member "unset".
     *
     * If the meaning of "unset" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unset"
     */
    inline const ::std::vector< ::std::string >& getUnset () const;

    /**
     * Retrieves the value of the field "unset" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unset".
     */
    inline ::std::vector< ::std::string >& getUnsetMutable ();

    /**
     * Sets the value of the member "unset".
     *
     * If the meaning of "unset" isn't clear, then there should be a description here.
     *
     * @param unset The value which will be set
     */
    inline void setUnset (const ::std::vector< ::std::string >& unset_);

    // API of field "set"

    static const int kSet = 1;

    /**
     * Clears the field "set".
     *
     * The field will be set to its default value. The hasSet()
     * method will return false.
     */
    inline void clearSet();

    /**
     * Checks whether the field "set" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSet()). Otherwise it will return false.
     */
    inline bool hasSet () const;

    /**
     * Returns the value of the member "set".
     *
     * If the meaning of "set" isn't clear, then there should be a description here.
     *
     * @return The value of the field "set"
     */
    inline const ::std::vector< ::std::string >& getSet () const;

    /**
     * Retrieves the value of the field "set" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "set".
     */
    inline ::std::vector< ::std::string >& getSetMutable ();

    /**
     * Sets the value of the member "set".
     *
     * If the meaning of "set" isn't clear, then there should be a description here.
     *
     * @param set The value which will be set
     */
    inline void setSet (const ::std::vector< ::std::string >& set_);

    static const UnsetAndSetEnvironmentRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_unset ();

    inline void clear_has_unset ();

    inline void set_has_set ();

    inline void clear_has_set ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ::std::string > _unset;

    ::std::vector< ::std::string > _set;

};

/**
 * ListUnitFiles() returns an array of unit names plus their enablement status.
 * 		Note that ListUnit() returns a list of units currently loaded into memory, while ListUnitFiles()
 * 		returns a list of unit files that could be found on disk. Note that while most units are read directly from a unit file with the same name
 * 		some units are not backed by files, and some files (templates) cannot directly be loaded as units but need to be instantiated.
 */
class ListUnitFilesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListUnitFilesResponse ();

    /**
     * Copy constructor
     */
    inline  ListUnitFilesResponse (const ListUnitFilesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ListUnitFilesResponse (const ::std::vector< files >& files_);

    /**
     * Destructor
     */
    inline virtual  ~ListUnitFilesResponse();

    /**
     * Assignment operator
     */
    inline ListUnitFilesResponse& operator = (const ListUnitFilesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListUnitFilesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListUnitFilesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListUnitFilesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListUnitFilesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "files"

    static const int kFiles = 0;

    /**
     * Clears the field "files".
     *
     * The field will be set to its default value. The hasFiles()
     * method will return false.
     */
    inline void clearFiles();

    /**
     * Checks whether the field "files" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFiles()). Otherwise it will return false.
     */
    inline bool hasFiles () const;

    /**
     * Returns the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @return The value of the field "files"
     */
    inline const ::std::vector< files >& getFiles () const;

    /**
     * Retrieves the value of the field "files" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "files".
     */
    inline ::std::vector< files >& getFilesMutable ();

    /**
     * Sets the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param files The value which will be set
     */
    inline void setFiles (const ::std::vector< files >& files_);

    static const ListUnitFilesResponse &getDefaultInstance();

private:

    static const ::std::vector< files >& getFilesList_DefaultInstance ();

    inline void set_has_files ();

    inline void clear_has_files ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< files > _files;

};

/**
 * GetUnitFileState() returns the current enablement status of specific unit file.
 */
class GetUnitFileStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUnitFileStateRequest ();

    /**
     * Copy constructor
     */
    inline  GetUnitFileStateRequest (const GetUnitFileStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetUnitFileStateRequest (const ::std::string& file_);

    /**
     * Destructor
     */
    inline virtual  ~GetUnitFileStateRequest();

    /**
     * Assignment operator
     */
    inline GetUnitFileStateRequest& operator = (const GetUnitFileStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUnitFileStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUnitFileStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUnitFileStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUnitFileStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "file"

    static const int kFile = 0;

    /**
     * Clears the field "file".
     *
     * The field will be set to its default value. The hasFile()
     * method will return false.
     */
    inline void clearFile();

    /**
     * Checks whether the field "file" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFile()). Otherwise it will return false.
     */
    inline bool hasFile () const;

    /**
     * Returns the value of the member "file".
     *
     * If the meaning of "file" isn't clear, then there should be a description here.
     *
     * @return The value of the field "file"
     */
    inline const ::std::string& getFile () const;

    /**
     * Retrieves the value of the field "file" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "file".
     */
    inline ::std::string& getFileMutable ();

    /**
     * Sets the value of the member "file".
     *
     * If the meaning of "file" isn't clear, then there should be a description here.
     *
     * @param file The value which will be set
     */
    inline void setFile (const ::std::string& file_);

    /**
     * Sets the value of the member "file".
     *
     * If the meaning of "file" isn't clear, then there should be a description here.
     *
     * @param file The value which will be set
     */
    inline void setFile (const char* file_);

    /**
     * Sets the value of the member "file".
     *
     * If the meaning of "file" isn't clear, then there should be a description here.
     *
     * @param file The value which will be set
     */
    inline void setFile (const char* value, size_t size);

    static const GetUnitFileStateRequest &getDefaultInstance();

private:

    inline void set_has_file ();

    inline void clear_has_file ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _file;

};

/**
 * GetUnitFileState() returns the current enablement status of specific unit file.
 */
class GetUnitFileStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUnitFileStateResponse ();

    /**
     * Copy constructor
     */
    inline  GetUnitFileStateResponse (const GetUnitFileStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetUnitFileStateResponse (const ::std::string& state_);

    /**
     * Destructor
     */
    inline virtual  ~GetUnitFileStateResponse();

    /**
     * Assignment operator
     */
    inline GetUnitFileStateResponse& operator = (const GetUnitFileStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUnitFileStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUnitFileStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUnitFileStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUnitFileStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "state"

    static const int kState = 0;

    /**
     * Clears the field "state".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "state" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "state".
     *
     * If the meaning of "state" isn't clear, then there should be a description here.
     *
     * @return The value of the field "state"
     */
    inline const ::std::string& getState () const;

    /**
     * Retrieves the value of the field "state" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "state".
     */
    inline ::std::string& getStateMutable ();

    /**
     * Sets the value of the member "state".
     *
     * If the meaning of "state" isn't clear, then there should be a description here.
     *
     * @param state The value which will be set
     */
    inline void setState (const ::std::string& state_);

    /**
     * Sets the value of the member "state".
     *
     * If the meaning of "state" isn't clear, then there should be a description here.
     *
     * @param state The value which will be set
     */
    inline void setState (const char* state_);

    /**
     * Sets the value of the member "state".
     *
     * If the meaning of "state" isn't clear, then there should be a description here.
     *
     * @param state The value which will be set
     */
    inline void setState (const char* value, size_t size);

    static const GetUnitFileStateResponse &getDefaultInstance();

private:

    inline void set_has_state ();

    inline void clear_has_state ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _state;

};

/**
 * EnableUnitFiles() may be used to enable one or more units in the system (by creating symlinks to them in /etc or /run).
 * 		It takes a list of unit files to enable (either just file names or full absolute paths if the unit files are residing outside the usual unit search paths),
 * 		and two booleans: the first controls whether the unit shall be enabled for runtime only (true, /run), or persistently (false, /etc).
 * 		The second one controls whether symlinks pointing to other units shall be replaced if necessary. This call returns one boolean and an array with the changes made.
 * 		The boolean signals whether the unit files contained any enablement information (i.e. an [Install]) section.
 * 		The changes list consists of structures with three strings: the type of the change (one of symlink or unlink),
 * 		the file name of the symlink and the destination of the symlink. Note that most of the following calls return a changes list in the same format.
 */
class EnableUnitFilesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnableUnitFilesRequest ();

    /**
     * Copy constructor
     */
    inline  EnableUnitFilesRequest (const EnableUnitFilesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EnableUnitFilesRequest (const ::std::vector< ::std::string >& files_, bool runtime_, bool force_);

    /**
     * Destructor
     */
    inline virtual  ~EnableUnitFilesRequest();

    /**
     * Assignment operator
     */
    inline EnableUnitFilesRequest& operator = (const EnableUnitFilesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnableUnitFilesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnableUnitFilesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnableUnitFilesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnableUnitFilesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "files"

    static const int kFiles = 0;

    /**
     * Clears the field "files".
     *
     * The field will be set to its default value. The hasFiles()
     * method will return false.
     */
    inline void clearFiles();

    /**
     * Checks whether the field "files" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFiles()). Otherwise it will return false.
     */
    inline bool hasFiles () const;

    /**
     * Returns the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @return The value of the field "files"
     */
    inline const ::std::vector< ::std::string >& getFiles () const;

    /**
     * Retrieves the value of the field "files" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "files".
     */
    inline ::std::vector< ::std::string >& getFilesMutable ();

    /**
     * Sets the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param files The value which will be set
     */
    inline void setFiles (const ::std::vector< ::std::string >& files_);

    // API of field "runtime"

    static const int kRuntime = 1;

    /**
     * Clears the field "runtime".
     *
     * The field will be set to its default value. The hasRuntime()
     * method will return false.
     */
    inline void clearRuntime();

    /**
     * Checks whether the field "runtime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntime()). Otherwise it will return false.
     */
    inline bool hasRuntime () const;

    /**
     * Returns the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "runtime"
     */
    inline bool getRuntime () const;

    /**
     * Sets the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param runtime The value which will be set
     */
    inline void setRuntime (bool runtime_);

    // API of field "force"

    static const int kForce = 2;

    /**
     * Clears the field "force".
     *
     * The field will be set to its default value. The hasForce()
     * method will return false.
     */
    inline void clearForce();

    /**
     * Checks whether the field "force" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setForce()). Otherwise it will return false.
     */
    inline bool hasForce () const;

    /**
     * Returns the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return The value of the field "force"
     */
    inline bool getForce () const;

    /**
     * Sets the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @param force The value which will be set
     */
    inline void setForce (bool force_);

    static const EnableUnitFilesRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_files ();

    inline void clear_has_files ();

    inline void set_has_runtime ();

    inline void clear_has_runtime ();

    inline void set_has_force ();

    inline void clear_has_force ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< ::std::string > _files;

    bool _runtime;

    bool _force;

};

/**
 * EnableUnitFiles() may be used to enable one or more units in the system (by creating symlinks to them in /etc or /run).
 * 		It takes a list of unit files to enable (either just file names or full absolute paths if the unit files are residing outside the usual unit search paths),
 * 		and two booleans: the first controls whether the unit shall be enabled for runtime only (true, /run), or persistently (false, /etc).
 * 		The second one controls whether symlinks pointing to other units shall be replaced if necessary. This call returns one boolean and an array with the changes made.
 * 		The boolean signals whether the unit files contained any enablement information (i.e. an [Install]) section.
 * 		The changes list consists of structures with three strings: the type of the change (one of symlink or unlink),
 * 		the file name of the symlink and the destination of the symlink. Note that most of the following calls return a changes list in the same format.
 */
class EnableUnitFilesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnableUnitFilesResponse ();

    /**
     * Copy constructor
     */
    inline  EnableUnitFilesResponse (const EnableUnitFilesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EnableUnitFilesResponse (bool carries_install_info_, const ::std::vector< changes >& changes_);

    /**
     * Destructor
     */
    inline virtual  ~EnableUnitFilesResponse();

    /**
     * Assignment operator
     */
    inline EnableUnitFilesResponse& operator = (const EnableUnitFilesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnableUnitFilesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnableUnitFilesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnableUnitFilesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnableUnitFilesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "carries_install_info"

    static const int kCarries_install_info = 0;

    /**
     * Clears the field "carries_install_info".
     *
     * The field will be set to its default value. The hasCarries_install_info()
     * method will return false.
     */
    inline void clearCarries_install_info();

    /**
     * Checks whether the field "carries_install_info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarries_install_info()). Otherwise it will return false.
     */
    inline bool hasCarries_install_info () const;

    /**
     * Returns the value of the member "carries_install_info".
     *
     * If the meaning of "carries_install_info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "carries_install_info"
     */
    inline bool getCarries_install_info () const;

    /**
     * Sets the value of the member "carries_install_info".
     *
     * If the meaning of "carries_install_info" isn't clear, then there should be a description here.
     *
     * @param carries_install_info The value which will be set
     */
    inline void setCarries_install_info (bool carries_install_info_);

    // API of field "changes"

    static const int kChanges = 1;

    /**
     * Clears the field "changes".
     *
     * The field will be set to its default value. The hasChanges()
     * method will return false.
     */
    inline void clearChanges();

    /**
     * Checks whether the field "changes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanges()). Otherwise it will return false.
     */
    inline bool hasChanges () const;

    /**
     * Returns the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changes"
     */
    inline const ::std::vector< changes >& getChanges () const;

    /**
     * Retrieves the value of the field "changes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changes".
     */
    inline ::std::vector< changes >& getChangesMutable ();

    /**
     * Sets the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param changes The value which will be set
     */
    inline void setChanges (const ::std::vector< changes >& changes_);

    static const EnableUnitFilesResponse &getDefaultInstance();

private:

    static const ::std::vector< changes >& getChangesList_DefaultInstance ();

    inline void set_has_carries_install_info ();

    inline void clear_has_carries_install_info ();

    inline void set_has_changes ();

    inline void clear_has_changes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _carries_install_info;

    ::std::vector< changes > _changes;

};

/**
 * DisableUnitFiles() disables one or more units in the system, i.e. removes all symlinks to them in /etc and /run
 */
class DisableUnitFilesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisableUnitFilesRequest ();

    /**
     * Copy constructor
     */
    inline  DisableUnitFilesRequest (const DisableUnitFilesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DisableUnitFilesRequest (const ::std::vector< ::std::string >& files_, bool runtime_);

    /**
     * Destructor
     */
    inline virtual  ~DisableUnitFilesRequest();

    /**
     * Assignment operator
     */
    inline DisableUnitFilesRequest& operator = (const DisableUnitFilesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisableUnitFilesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisableUnitFilesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisableUnitFilesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisableUnitFilesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "files"

    static const int kFiles = 0;

    /**
     * Clears the field "files".
     *
     * The field will be set to its default value. The hasFiles()
     * method will return false.
     */
    inline void clearFiles();

    /**
     * Checks whether the field "files" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFiles()). Otherwise it will return false.
     */
    inline bool hasFiles () const;

    /**
     * Returns the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @return The value of the field "files"
     */
    inline const ::std::vector< ::std::string >& getFiles () const;

    /**
     * Retrieves the value of the field "files" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "files".
     */
    inline ::std::vector< ::std::string >& getFilesMutable ();

    /**
     * Sets the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param files The value which will be set
     */
    inline void setFiles (const ::std::vector< ::std::string >& files_);

    // API of field "runtime"

    static const int kRuntime = 1;

    /**
     * Clears the field "runtime".
     *
     * The field will be set to its default value. The hasRuntime()
     * method will return false.
     */
    inline void clearRuntime();

    /**
     * Checks whether the field "runtime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntime()). Otherwise it will return false.
     */
    inline bool hasRuntime () const;

    /**
     * Returns the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "runtime"
     */
    inline bool getRuntime () const;

    /**
     * Sets the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param runtime The value which will be set
     */
    inline void setRuntime (bool runtime_);

    static const DisableUnitFilesRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_files ();

    inline void clear_has_files ();

    inline void set_has_runtime ();

    inline void clear_has_runtime ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ::std::string > _files;

    bool _runtime;

};

/**
 * DisableUnitFiles() disables one or more units in the system, i.e. removes all symlinks to them in /etc and /run
 */
class DisableUnitFilesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisableUnitFilesResponse ();

    /**
     * Copy constructor
     */
    inline  DisableUnitFilesResponse (const DisableUnitFilesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DisableUnitFilesResponse (const ::std::vector< changes >& changes_);

    /**
     * Destructor
     */
    inline virtual  ~DisableUnitFilesResponse();

    /**
     * Assignment operator
     */
    inline DisableUnitFilesResponse& operator = (const DisableUnitFilesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisableUnitFilesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisableUnitFilesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisableUnitFilesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisableUnitFilesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "changes"

    static const int kChanges = 0;

    /**
     * Clears the field "changes".
     *
     * The field will be set to its default value. The hasChanges()
     * method will return false.
     */
    inline void clearChanges();

    /**
     * Checks whether the field "changes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanges()). Otherwise it will return false.
     */
    inline bool hasChanges () const;

    /**
     * Returns the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changes"
     */
    inline const ::std::vector< changes >& getChanges () const;

    /**
     * Retrieves the value of the field "changes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changes".
     */
    inline ::std::vector< changes >& getChangesMutable ();

    /**
     * Sets the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param changes The value which will be set
     */
    inline void setChanges (const ::std::vector< changes >& changes_);

    static const DisableUnitFilesResponse &getDefaultInstance();

private:

    static const ::std::vector< changes >& getChangesList_DefaultInstance ();

    inline void set_has_changes ();

    inline void clear_has_changes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< changes > _changes;

};

/**
 * ReenableUnitFiles() applies the changes to one or more units that would result from disabling and enabling the
 * 		unit quickly one after the other in an atomic fashion.
 * 		This is useful to apply updated [Install] information contained in unit files.
 */
class ReenableUnitFilesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReenableUnitFilesRequest ();

    /**
     * Copy constructor
     */
    inline  ReenableUnitFilesRequest (const ReenableUnitFilesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReenableUnitFilesRequest (const ::std::vector< ::std::string >& files_, bool runtime_, bool force_);

    /**
     * Destructor
     */
    inline virtual  ~ReenableUnitFilesRequest();

    /**
     * Assignment operator
     */
    inline ReenableUnitFilesRequest& operator = (const ReenableUnitFilesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReenableUnitFilesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReenableUnitFilesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReenableUnitFilesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReenableUnitFilesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "files"

    static const int kFiles = 0;

    /**
     * Clears the field "files".
     *
     * The field will be set to its default value. The hasFiles()
     * method will return false.
     */
    inline void clearFiles();

    /**
     * Checks whether the field "files" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFiles()). Otherwise it will return false.
     */
    inline bool hasFiles () const;

    /**
     * Returns the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @return The value of the field "files"
     */
    inline const ::std::vector< ::std::string >& getFiles () const;

    /**
     * Retrieves the value of the field "files" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "files".
     */
    inline ::std::vector< ::std::string >& getFilesMutable ();

    /**
     * Sets the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param files The value which will be set
     */
    inline void setFiles (const ::std::vector< ::std::string >& files_);

    // API of field "runtime"

    static const int kRuntime = 1;

    /**
     * Clears the field "runtime".
     *
     * The field will be set to its default value. The hasRuntime()
     * method will return false.
     */
    inline void clearRuntime();

    /**
     * Checks whether the field "runtime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntime()). Otherwise it will return false.
     */
    inline bool hasRuntime () const;

    /**
     * Returns the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "runtime"
     */
    inline bool getRuntime () const;

    /**
     * Sets the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param runtime The value which will be set
     */
    inline void setRuntime (bool runtime_);

    // API of field "force"

    static const int kForce = 2;

    /**
     * Clears the field "force".
     *
     * The field will be set to its default value. The hasForce()
     * method will return false.
     */
    inline void clearForce();

    /**
     * Checks whether the field "force" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setForce()). Otherwise it will return false.
     */
    inline bool hasForce () const;

    /**
     * Returns the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return The value of the field "force"
     */
    inline bool getForce () const;

    /**
     * Sets the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @param force The value which will be set
     */
    inline void setForce (bool force_);

    static const ReenableUnitFilesRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_files ();

    inline void clear_has_files ();

    inline void set_has_runtime ();

    inline void clear_has_runtime ();

    inline void set_has_force ();

    inline void clear_has_force ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< ::std::string > _files;

    bool _runtime;

    bool _force;

};

/**
 * ReenableUnitFiles() applies the changes to one or more units that would result from disabling and enabling the
 * 		unit quickly one after the other in an atomic fashion.
 * 		This is useful to apply updated [Install] information contained in unit files.
 */
class ReenableUnitFilesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReenableUnitFilesResponse ();

    /**
     * Copy constructor
     */
    inline  ReenableUnitFilesResponse (const ReenableUnitFilesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReenableUnitFilesResponse (bool carries_install_info_, const ::std::vector< changes >& changes_);

    /**
     * Destructor
     */
    inline virtual  ~ReenableUnitFilesResponse();

    /**
     * Assignment operator
     */
    inline ReenableUnitFilesResponse& operator = (const ReenableUnitFilesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReenableUnitFilesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReenableUnitFilesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReenableUnitFilesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReenableUnitFilesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "carries_install_info"

    static const int kCarries_install_info = 0;

    /**
     * Clears the field "carries_install_info".
     *
     * The field will be set to its default value. The hasCarries_install_info()
     * method will return false.
     */
    inline void clearCarries_install_info();

    /**
     * Checks whether the field "carries_install_info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarries_install_info()). Otherwise it will return false.
     */
    inline bool hasCarries_install_info () const;

    /**
     * Returns the value of the member "carries_install_info".
     *
     * If the meaning of "carries_install_info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "carries_install_info"
     */
    inline bool getCarries_install_info () const;

    /**
     * Sets the value of the member "carries_install_info".
     *
     * If the meaning of "carries_install_info" isn't clear, then there should be a description here.
     *
     * @param carries_install_info The value which will be set
     */
    inline void setCarries_install_info (bool carries_install_info_);

    // API of field "changes"

    static const int kChanges = 1;

    /**
     * Clears the field "changes".
     *
     * The field will be set to its default value. The hasChanges()
     * method will return false.
     */
    inline void clearChanges();

    /**
     * Checks whether the field "changes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanges()). Otherwise it will return false.
     */
    inline bool hasChanges () const;

    /**
     * Returns the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changes"
     */
    inline const ::std::vector< changes >& getChanges () const;

    /**
     * Retrieves the value of the field "changes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changes".
     */
    inline ::std::vector< changes >& getChangesMutable ();

    /**
     * Sets the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param changes The value which will be set
     */
    inline void setChanges (const ::std::vector< changes >& changes_);

    static const ReenableUnitFilesResponse &getDefaultInstance();

private:

    static const ::std::vector< changes >& getChangesList_DefaultInstance ();

    inline void set_has_carries_install_info ();

    inline void clear_has_carries_install_info ();

    inline void set_has_changes ();

    inline void clear_has_changes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _carries_install_info;

    ::std::vector< changes > _changes;

};

/**
 * LinkUnitFiles() links unit files (that are located outside of the usual unit search paths) into the unit search path.
 */
class LinkUnitFilesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LinkUnitFilesRequest ();

    /**
     * Copy constructor
     */
    inline  LinkUnitFilesRequest (const LinkUnitFilesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  LinkUnitFilesRequest (const ::std::vector< ::std::string >& files_, bool runtime_, bool force_);

    /**
     * Destructor
     */
    inline virtual  ~LinkUnitFilesRequest();

    /**
     * Assignment operator
     */
    inline LinkUnitFilesRequest& operator = (const LinkUnitFilesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LinkUnitFilesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LinkUnitFilesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LinkUnitFilesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LinkUnitFilesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "files"

    static const int kFiles = 0;

    /**
     * Clears the field "files".
     *
     * The field will be set to its default value. The hasFiles()
     * method will return false.
     */
    inline void clearFiles();

    /**
     * Checks whether the field "files" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFiles()). Otherwise it will return false.
     */
    inline bool hasFiles () const;

    /**
     * Returns the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @return The value of the field "files"
     */
    inline const ::std::vector< ::std::string >& getFiles () const;

    /**
     * Retrieves the value of the field "files" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "files".
     */
    inline ::std::vector< ::std::string >& getFilesMutable ();

    /**
     * Sets the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param files The value which will be set
     */
    inline void setFiles (const ::std::vector< ::std::string >& files_);

    // API of field "runtime"

    static const int kRuntime = 1;

    /**
     * Clears the field "runtime".
     *
     * The field will be set to its default value. The hasRuntime()
     * method will return false.
     */
    inline void clearRuntime();

    /**
     * Checks whether the field "runtime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntime()). Otherwise it will return false.
     */
    inline bool hasRuntime () const;

    /**
     * Returns the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "runtime"
     */
    inline bool getRuntime () const;

    /**
     * Sets the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param runtime The value which will be set
     */
    inline void setRuntime (bool runtime_);

    // API of field "force"

    static const int kForce = 2;

    /**
     * Clears the field "force".
     *
     * The field will be set to its default value. The hasForce()
     * method will return false.
     */
    inline void clearForce();

    /**
     * Checks whether the field "force" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setForce()). Otherwise it will return false.
     */
    inline bool hasForce () const;

    /**
     * Returns the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return The value of the field "force"
     */
    inline bool getForce () const;

    /**
     * Sets the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @param force The value which will be set
     */
    inline void setForce (bool force_);

    static const LinkUnitFilesRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_files ();

    inline void clear_has_files ();

    inline void set_has_runtime ();

    inline void clear_has_runtime ();

    inline void set_has_force ();

    inline void clear_has_force ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< ::std::string > _files;

    bool _runtime;

    bool _force;

};

/**
 * LinkUnitFiles() links unit files (that are located outside of the usual unit search paths) into the unit search path.
 */
class LinkUnitFilesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LinkUnitFilesResponse ();

    /**
     * Copy constructor
     */
    inline  LinkUnitFilesResponse (const LinkUnitFilesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  LinkUnitFilesResponse (const ::std::vector< changes >& changes_);

    /**
     * Destructor
     */
    inline virtual  ~LinkUnitFilesResponse();

    /**
     * Assignment operator
     */
    inline LinkUnitFilesResponse& operator = (const LinkUnitFilesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LinkUnitFilesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LinkUnitFilesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LinkUnitFilesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LinkUnitFilesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "changes"

    static const int kChanges = 0;

    /**
     * Clears the field "changes".
     *
     * The field will be set to its default value. The hasChanges()
     * method will return false.
     */
    inline void clearChanges();

    /**
     * Checks whether the field "changes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanges()). Otherwise it will return false.
     */
    inline bool hasChanges () const;

    /**
     * Returns the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changes"
     */
    inline const ::std::vector< changes >& getChanges () const;

    /**
     * Retrieves the value of the field "changes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changes".
     */
    inline ::std::vector< changes >& getChangesMutable ();

    /**
     * Sets the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param changes The value which will be set
     */
    inline void setChanges (const ::std::vector< changes >& changes_);

    static const LinkUnitFilesResponse &getDefaultInstance();

private:

    static const ::std::vector< changes >& getChangesList_DefaultInstance ();

    inline void set_has_changes ();

    inline void clear_has_changes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< changes > _changes;

};

/**
 * PresetUnitFiles() enables/disables one or more units file according to the preset policy.
 */
class PresetUnitFilesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PresetUnitFilesRequest ();

    /**
     * Copy constructor
     */
    inline  PresetUnitFilesRequest (const PresetUnitFilesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  PresetUnitFilesRequest (const ::std::vector< ::std::string >& files_, bool runtime_, bool force_);

    /**
     * Destructor
     */
    inline virtual  ~PresetUnitFilesRequest();

    /**
     * Assignment operator
     */
    inline PresetUnitFilesRequest& operator = (const PresetUnitFilesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PresetUnitFilesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PresetUnitFilesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PresetUnitFilesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PresetUnitFilesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "files"

    static const int kFiles = 0;

    /**
     * Clears the field "files".
     *
     * The field will be set to its default value. The hasFiles()
     * method will return false.
     */
    inline void clearFiles();

    /**
     * Checks whether the field "files" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFiles()). Otherwise it will return false.
     */
    inline bool hasFiles () const;

    /**
     * Returns the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @return The value of the field "files"
     */
    inline const ::std::vector< ::std::string >& getFiles () const;

    /**
     * Retrieves the value of the field "files" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "files".
     */
    inline ::std::vector< ::std::string >& getFilesMutable ();

    /**
     * Sets the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param files The value which will be set
     */
    inline void setFiles (const ::std::vector< ::std::string >& files_);

    // API of field "runtime"

    static const int kRuntime = 1;

    /**
     * Clears the field "runtime".
     *
     * The field will be set to its default value. The hasRuntime()
     * method will return false.
     */
    inline void clearRuntime();

    /**
     * Checks whether the field "runtime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntime()). Otherwise it will return false.
     */
    inline bool hasRuntime () const;

    /**
     * Returns the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "runtime"
     */
    inline bool getRuntime () const;

    /**
     * Sets the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param runtime The value which will be set
     */
    inline void setRuntime (bool runtime_);

    // API of field "force"

    static const int kForce = 2;

    /**
     * Clears the field "force".
     *
     * The field will be set to its default value. The hasForce()
     * method will return false.
     */
    inline void clearForce();

    /**
     * Checks whether the field "force" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setForce()). Otherwise it will return false.
     */
    inline bool hasForce () const;

    /**
     * Returns the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return The value of the field "force"
     */
    inline bool getForce () const;

    /**
     * Sets the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @param force The value which will be set
     */
    inline void setForce (bool force_);

    static const PresetUnitFilesRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_files ();

    inline void clear_has_files ();

    inline void set_has_runtime ();

    inline void clear_has_runtime ();

    inline void set_has_force ();

    inline void clear_has_force ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< ::std::string > _files;

    bool _runtime;

    bool _force;

};

/**
 * PresetUnitFiles() enables/disables one or more units file according to the preset policy.
 */
class PresetUnitFilesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PresetUnitFilesResponse ();

    /**
     * Copy constructor
     */
    inline  PresetUnitFilesResponse (const PresetUnitFilesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  PresetUnitFilesResponse (bool carries_install_info_, const ::std::vector< changes >& changes_);

    /**
     * Destructor
     */
    inline virtual  ~PresetUnitFilesResponse();

    /**
     * Assignment operator
     */
    inline PresetUnitFilesResponse& operator = (const PresetUnitFilesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PresetUnitFilesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PresetUnitFilesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PresetUnitFilesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PresetUnitFilesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "carries_install_info"

    static const int kCarries_install_info = 0;

    /**
     * Clears the field "carries_install_info".
     *
     * The field will be set to its default value. The hasCarries_install_info()
     * method will return false.
     */
    inline void clearCarries_install_info();

    /**
     * Checks whether the field "carries_install_info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarries_install_info()). Otherwise it will return false.
     */
    inline bool hasCarries_install_info () const;

    /**
     * Returns the value of the member "carries_install_info".
     *
     * If the meaning of "carries_install_info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "carries_install_info"
     */
    inline bool getCarries_install_info () const;

    /**
     * Sets the value of the member "carries_install_info".
     *
     * If the meaning of "carries_install_info" isn't clear, then there should be a description here.
     *
     * @param carries_install_info The value which will be set
     */
    inline void setCarries_install_info (bool carries_install_info_);

    // API of field "changes"

    static const int kChanges = 1;

    /**
     * Clears the field "changes".
     *
     * The field will be set to its default value. The hasChanges()
     * method will return false.
     */
    inline void clearChanges();

    /**
     * Checks whether the field "changes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanges()). Otherwise it will return false.
     */
    inline bool hasChanges () const;

    /**
     * Returns the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changes"
     */
    inline const ::std::vector< changes >& getChanges () const;

    /**
     * Retrieves the value of the field "changes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changes".
     */
    inline ::std::vector< changes >& getChangesMutable ();

    /**
     * Sets the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param changes The value which will be set
     */
    inline void setChanges (const ::std::vector< changes >& changes_);

    static const PresetUnitFilesResponse &getDefaultInstance();

private:

    static const ::std::vector< changes >& getChangesList_DefaultInstance ();

    inline void set_has_carries_install_info ();

    inline void clear_has_carries_install_info ();

    inline void set_has_changes ();

    inline void clear_has_changes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _carries_install_info;

    ::std::vector< changes > _changes;

};

/**
 * PresetUnitFilesWithMode() enables/disables one or more units file according to the preset policy for a given mode.
 */
class PresetUnitFilesWithModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PresetUnitFilesWithModeRequest ();

    /**
     * Copy constructor
     */
    inline  PresetUnitFilesWithModeRequest (const PresetUnitFilesWithModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  PresetUnitFilesWithModeRequest (const ::std::vector< ::std::string >& files_, const ::std::string& mode_, bool runtime_, bool force_);

    /**
     * Destructor
     */
    inline virtual  ~PresetUnitFilesWithModeRequest();

    /**
     * Assignment operator
     */
    inline PresetUnitFilesWithModeRequest& operator = (const PresetUnitFilesWithModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PresetUnitFilesWithModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PresetUnitFilesWithModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PresetUnitFilesWithModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PresetUnitFilesWithModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "files"

    static const int kFiles = 0;

    /**
     * Clears the field "files".
     *
     * The field will be set to its default value. The hasFiles()
     * method will return false.
     */
    inline void clearFiles();

    /**
     * Checks whether the field "files" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFiles()). Otherwise it will return false.
     */
    inline bool hasFiles () const;

    /**
     * Returns the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @return The value of the field "files"
     */
    inline const ::std::vector< ::std::string >& getFiles () const;

    /**
     * Retrieves the value of the field "files" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "files".
     */
    inline ::std::vector< ::std::string >& getFilesMutable ();

    /**
     * Sets the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param files The value which will be set
     */
    inline void setFiles (const ::std::vector< ::std::string >& files_);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    // API of field "runtime"

    static const int kRuntime = 2;

    /**
     * Clears the field "runtime".
     *
     * The field will be set to its default value. The hasRuntime()
     * method will return false.
     */
    inline void clearRuntime();

    /**
     * Checks whether the field "runtime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntime()). Otherwise it will return false.
     */
    inline bool hasRuntime () const;

    /**
     * Returns the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "runtime"
     */
    inline bool getRuntime () const;

    /**
     * Sets the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param runtime The value which will be set
     */
    inline void setRuntime (bool runtime_);

    // API of field "force"

    static const int kForce = 3;

    /**
     * Clears the field "force".
     *
     * The field will be set to its default value. The hasForce()
     * method will return false.
     */
    inline void clearForce();

    /**
     * Checks whether the field "force" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setForce()). Otherwise it will return false.
     */
    inline bool hasForce () const;

    /**
     * Returns the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return The value of the field "force"
     */
    inline bool getForce () const;

    /**
     * Sets the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @param force The value which will be set
     */
    inline void setForce (bool force_);

    static const PresetUnitFilesWithModeRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_files ();

    inline void clear_has_files ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    inline void set_has_runtime ();

    inline void clear_has_runtime ();

    inline void set_has_force ();

    inline void clear_has_force ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::vector< ::std::string > _files;

    ::std::string _mode;

    bool _runtime;

    bool _force;

};

/**
 * PresetUnitFilesWithMode() enables/disables one or more units file according to the preset policy for a given mode.
 */
class PresetUnitFilesWithModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PresetUnitFilesWithModeResponse ();

    /**
     * Copy constructor
     */
    inline  PresetUnitFilesWithModeResponse (const PresetUnitFilesWithModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  PresetUnitFilesWithModeResponse (bool carries_install_info_, const ::std::vector< changes >& changes_);

    /**
     * Destructor
     */
    inline virtual  ~PresetUnitFilesWithModeResponse();

    /**
     * Assignment operator
     */
    inline PresetUnitFilesWithModeResponse& operator = (const PresetUnitFilesWithModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PresetUnitFilesWithModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PresetUnitFilesWithModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PresetUnitFilesWithModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PresetUnitFilesWithModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "carries_install_info"

    static const int kCarries_install_info = 0;

    /**
     * Clears the field "carries_install_info".
     *
     * The field will be set to its default value. The hasCarries_install_info()
     * method will return false.
     */
    inline void clearCarries_install_info();

    /**
     * Checks whether the field "carries_install_info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarries_install_info()). Otherwise it will return false.
     */
    inline bool hasCarries_install_info () const;

    /**
     * Returns the value of the member "carries_install_info".
     *
     * If the meaning of "carries_install_info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "carries_install_info"
     */
    inline bool getCarries_install_info () const;

    /**
     * Sets the value of the member "carries_install_info".
     *
     * If the meaning of "carries_install_info" isn't clear, then there should be a description here.
     *
     * @param carries_install_info The value which will be set
     */
    inline void setCarries_install_info (bool carries_install_info_);

    // API of field "changes"

    static const int kChanges = 1;

    /**
     * Clears the field "changes".
     *
     * The field will be set to its default value. The hasChanges()
     * method will return false.
     */
    inline void clearChanges();

    /**
     * Checks whether the field "changes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanges()). Otherwise it will return false.
     */
    inline bool hasChanges () const;

    /**
     * Returns the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changes"
     */
    inline const ::std::vector< changes >& getChanges () const;

    /**
     * Retrieves the value of the field "changes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changes".
     */
    inline ::std::vector< changes >& getChangesMutable ();

    /**
     * Sets the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param changes The value which will be set
     */
    inline void setChanges (const ::std::vector< changes >& changes_);

    static const PresetUnitFilesWithModeResponse &getDefaultInstance();

private:

    static const ::std::vector< changes >& getChangesList_DefaultInstance ();

    inline void set_has_carries_install_info ();

    inline void clear_has_carries_install_info ();

    inline void set_has_changes ();

    inline void clear_has_changes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _carries_install_info;

    ::std::vector< changes > _changes;

};

/**
 * MaskUnitFiles() masks unit files, and UnmaskUnitFiles() unmasks them again.
 */
class MaskUnitFilesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MaskUnitFilesRequest ();

    /**
     * Copy constructor
     */
    inline  MaskUnitFilesRequest (const MaskUnitFilesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  MaskUnitFilesRequest (const ::std::vector< ::std::string >& files_, bool runtime_, bool force_);

    /**
     * Destructor
     */
    inline virtual  ~MaskUnitFilesRequest();

    /**
     * Assignment operator
     */
    inline MaskUnitFilesRequest& operator = (const MaskUnitFilesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaskUnitFilesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaskUnitFilesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaskUnitFilesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaskUnitFilesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "files"

    static const int kFiles = 0;

    /**
     * Clears the field "files".
     *
     * The field will be set to its default value. The hasFiles()
     * method will return false.
     */
    inline void clearFiles();

    /**
     * Checks whether the field "files" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFiles()). Otherwise it will return false.
     */
    inline bool hasFiles () const;

    /**
     * Returns the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @return The value of the field "files"
     */
    inline const ::std::vector< ::std::string >& getFiles () const;

    /**
     * Retrieves the value of the field "files" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "files".
     */
    inline ::std::vector< ::std::string >& getFilesMutable ();

    /**
     * Sets the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param files The value which will be set
     */
    inline void setFiles (const ::std::vector< ::std::string >& files_);

    // API of field "runtime"

    static const int kRuntime = 1;

    /**
     * Clears the field "runtime".
     *
     * The field will be set to its default value. The hasRuntime()
     * method will return false.
     */
    inline void clearRuntime();

    /**
     * Checks whether the field "runtime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntime()). Otherwise it will return false.
     */
    inline bool hasRuntime () const;

    /**
     * Returns the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "runtime"
     */
    inline bool getRuntime () const;

    /**
     * Sets the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param runtime The value which will be set
     */
    inline void setRuntime (bool runtime_);

    // API of field "force"

    static const int kForce = 2;

    /**
     * Clears the field "force".
     *
     * The field will be set to its default value. The hasForce()
     * method will return false.
     */
    inline void clearForce();

    /**
     * Checks whether the field "force" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setForce()). Otherwise it will return false.
     */
    inline bool hasForce () const;

    /**
     * Returns the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return The value of the field "force"
     */
    inline bool getForce () const;

    /**
     * Sets the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @param force The value which will be set
     */
    inline void setForce (bool force_);

    static const MaskUnitFilesRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_files ();

    inline void clear_has_files ();

    inline void set_has_runtime ();

    inline void clear_has_runtime ();

    inline void set_has_force ();

    inline void clear_has_force ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< ::std::string > _files;

    bool _runtime;

    bool _force;

};

/**
 * MaskUnitFiles() masks unit files, and UnmaskUnitFiles() unmasks them again.
 */
class MaskUnitFilesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MaskUnitFilesResponse ();

    /**
     * Copy constructor
     */
    inline  MaskUnitFilesResponse (const MaskUnitFilesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  MaskUnitFilesResponse (const ::std::vector< changes >& changes_);

    /**
     * Destructor
     */
    inline virtual  ~MaskUnitFilesResponse();

    /**
     * Assignment operator
     */
    inline MaskUnitFilesResponse& operator = (const MaskUnitFilesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaskUnitFilesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaskUnitFilesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaskUnitFilesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaskUnitFilesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "changes"

    static const int kChanges = 0;

    /**
     * Clears the field "changes".
     *
     * The field will be set to its default value. The hasChanges()
     * method will return false.
     */
    inline void clearChanges();

    /**
     * Checks whether the field "changes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanges()). Otherwise it will return false.
     */
    inline bool hasChanges () const;

    /**
     * Returns the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changes"
     */
    inline const ::std::vector< changes >& getChanges () const;

    /**
     * Retrieves the value of the field "changes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changes".
     */
    inline ::std::vector< changes >& getChangesMutable ();

    /**
     * Sets the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param changes The value which will be set
     */
    inline void setChanges (const ::std::vector< changes >& changes_);

    static const MaskUnitFilesResponse &getDefaultInstance();

private:

    static const ::std::vector< changes >& getChangesList_DefaultInstance ();

    inline void set_has_changes ();

    inline void clear_has_changes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< changes > _changes;

};

/**
 * UnmaskUnitFiles()
 */
class UnmaskUnitFilesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnmaskUnitFilesRequest ();

    /**
     * Copy constructor
     */
    inline  UnmaskUnitFilesRequest (const UnmaskUnitFilesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UnmaskUnitFilesRequest (const ::std::vector< ::std::string >& files_, bool runtime_);

    /**
     * Destructor
     */
    inline virtual  ~UnmaskUnitFilesRequest();

    /**
     * Assignment operator
     */
    inline UnmaskUnitFilesRequest& operator = (const UnmaskUnitFilesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnmaskUnitFilesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnmaskUnitFilesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnmaskUnitFilesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnmaskUnitFilesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "files"

    static const int kFiles = 0;

    /**
     * Clears the field "files".
     *
     * The field will be set to its default value. The hasFiles()
     * method will return false.
     */
    inline void clearFiles();

    /**
     * Checks whether the field "files" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFiles()). Otherwise it will return false.
     */
    inline bool hasFiles () const;

    /**
     * Returns the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @return The value of the field "files"
     */
    inline const ::std::vector< ::std::string >& getFiles () const;

    /**
     * Retrieves the value of the field "files" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "files".
     */
    inline ::std::vector< ::std::string >& getFilesMutable ();

    /**
     * Sets the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param files The value which will be set
     */
    inline void setFiles (const ::std::vector< ::std::string >& files_);

    // API of field "runtime"

    static const int kRuntime = 1;

    /**
     * Clears the field "runtime".
     *
     * The field will be set to its default value. The hasRuntime()
     * method will return false.
     */
    inline void clearRuntime();

    /**
     * Checks whether the field "runtime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntime()). Otherwise it will return false.
     */
    inline bool hasRuntime () const;

    /**
     * Returns the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "runtime"
     */
    inline bool getRuntime () const;

    /**
     * Sets the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param runtime The value which will be set
     */
    inline void setRuntime (bool runtime_);

    static const UnmaskUnitFilesRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_files ();

    inline void clear_has_files ();

    inline void set_has_runtime ();

    inline void clear_has_runtime ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ::std::string > _files;

    bool _runtime;

};

/**
 * UnmaskUnitFiles()
 */
class UnmaskUnitFilesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnmaskUnitFilesResponse ();

    /**
     * Copy constructor
     */
    inline  UnmaskUnitFilesResponse (const UnmaskUnitFilesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UnmaskUnitFilesResponse (const ::std::vector< changes >& changes_);

    /**
     * Destructor
     */
    inline virtual  ~UnmaskUnitFilesResponse();

    /**
     * Assignment operator
     */
    inline UnmaskUnitFilesResponse& operator = (const UnmaskUnitFilesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnmaskUnitFilesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnmaskUnitFilesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnmaskUnitFilesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnmaskUnitFilesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "changes"

    static const int kChanges = 0;

    /**
     * Clears the field "changes".
     *
     * The field will be set to its default value. The hasChanges()
     * method will return false.
     */
    inline void clearChanges();

    /**
     * Checks whether the field "changes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanges()). Otherwise it will return false.
     */
    inline bool hasChanges () const;

    /**
     * Returns the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changes"
     */
    inline const ::std::vector< changes >& getChanges () const;

    /**
     * Retrieves the value of the field "changes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changes".
     */
    inline ::std::vector< changes >& getChangesMutable ();

    /**
     * Sets the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param changes The value which will be set
     */
    inline void setChanges (const ::std::vector< changes >& changes_);

    static const UnmaskUnitFilesResponse &getDefaultInstance();

private:

    static const ::std::vector< changes >& getChangesList_DefaultInstance ();

    inline void set_has_changes ();

    inline void clear_has_changes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< changes > _changes;

};

/**
 * SetDefaultTarget() changes the default.target link.
 */
class SetDefaultTargetRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDefaultTargetRequest ();

    /**
     * Copy constructor
     */
    inline  SetDefaultTargetRequest (const SetDefaultTargetRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetDefaultTargetRequest (const ::std::string& arg_0_, bool arg_1_);

    /**
     * Destructor
     */
    inline virtual  ~SetDefaultTargetRequest();

    /**
     * Assignment operator
     */
    inline SetDefaultTargetRequest& operator = (const SetDefaultTargetRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDefaultTargetRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDefaultTargetRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDefaultTargetRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDefaultTargetRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arg_0"

    static const int kArg_0 = 0;

    /**
     * Clears the field "arg_0".
     *
     * The field will be set to its default value. The hasArg_0()
     * method will return false.
     */
    inline void clearArg_0();

    /**
     * Checks whether the field "arg_0" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg_0()). Otherwise it will return false.
     */
    inline bool hasArg_0 () const;

    /**
     * Returns the value of the member "arg_0".
     *
     * If the meaning of "arg_0" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg_0"
     */
    inline const ::std::string& getArg_0 () const;

    /**
     * Retrieves the value of the field "arg_0" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arg_0".
     */
    inline ::std::string& getArg_0Mutable ();

    /**
     * Sets the value of the member "arg_0".
     *
     * If the meaning of "arg_0" isn't clear, then there should be a description here.
     *
     * @param arg_0 The value which will be set
     */
    inline void setArg_0 (const ::std::string& arg_0_);

    /**
     * Sets the value of the member "arg_0".
     *
     * If the meaning of "arg_0" isn't clear, then there should be a description here.
     *
     * @param arg_0 The value which will be set
     */
    inline void setArg_0 (const char* arg_0_);

    /**
     * Sets the value of the member "arg_0".
     *
     * If the meaning of "arg_0" isn't clear, then there should be a description here.
     *
     * @param arg_0 The value which will be set
     */
    inline void setArg_0 (const char* value, size_t size);

    // API of field "arg_1"

    static const int kArg_1 = 1;

    /**
     * Clears the field "arg_1".
     *
     * The field will be set to its default value. The hasArg_1()
     * method will return false.
     */
    inline void clearArg_1();

    /**
     * Checks whether the field "arg_1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg_1()). Otherwise it will return false.
     */
    inline bool hasArg_1 () const;

    /**
     * Returns the value of the member "arg_1".
     *
     * If the meaning of "arg_1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg_1"
     */
    inline bool getArg_1 () const;

    /**
     * Sets the value of the member "arg_1".
     *
     * If the meaning of "arg_1" isn't clear, then there should be a description here.
     *
     * @param arg_1 The value which will be set
     */
    inline void setArg_1 (bool arg_1_);

    static const SetDefaultTargetRequest &getDefaultInstance();

private:

    inline void set_has_arg_0 ();

    inline void clear_has_arg_0 ();

    inline void set_has_arg_1 ();

    inline void clear_has_arg_1 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _arg_0;

    bool _arg_1;

};

/**
 * SetDefaultTarget() changes the default.target link.
 */
class SetDefaultTargetResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDefaultTargetResponse ();

    /**
     * Copy constructor
     */
    inline  SetDefaultTargetResponse (const SetDefaultTargetResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetDefaultTargetResponse (const ::std::vector< changes >& changes_);

    /**
     * Destructor
     */
    inline virtual  ~SetDefaultTargetResponse();

    /**
     * Assignment operator
     */
    inline SetDefaultTargetResponse& operator = (const SetDefaultTargetResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDefaultTargetResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDefaultTargetResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDefaultTargetResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDefaultTargetResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "changes"

    static const int kChanges = 0;

    /**
     * Clears the field "changes".
     *
     * The field will be set to its default value. The hasChanges()
     * method will return false.
     */
    inline void clearChanges();

    /**
     * Checks whether the field "changes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanges()). Otherwise it will return false.
     */
    inline bool hasChanges () const;

    /**
     * Returns the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changes"
     */
    inline const ::std::vector< changes >& getChanges () const;

    /**
     * Retrieves the value of the field "changes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changes".
     */
    inline ::std::vector< changes >& getChangesMutable ();

    /**
     * Sets the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param changes The value which will be set
     */
    inline void setChanges (const ::std::vector< changes >& changes_);

    static const SetDefaultTargetResponse &getDefaultInstance();

private:

    static const ::std::vector< changes >& getChangesList_DefaultInstance ();

    inline void set_has_changes ();

    inline void clear_has_changes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< changes > _changes;

};

/**
 * GetDefaultTarget()  retrieves the name of the unit to which default.target is aliased.
 */
class GetDefaultTargetResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDefaultTargetResponse ();

    /**
     * Copy constructor
     */
    inline  GetDefaultTargetResponse (const GetDefaultTargetResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetDefaultTargetResponse (const ::std::string& targetName_);

    /**
     * Destructor
     */
    inline virtual  ~GetDefaultTargetResponse();

    /**
     * Assignment operator
     */
    inline GetDefaultTargetResponse& operator = (const GetDefaultTargetResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDefaultTargetResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDefaultTargetResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDefaultTargetResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDefaultTargetResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "targetName"

    static const int kTargetName = 0;

    /**
     * Clears the field "targetName".
     *
     * The field will be set to its default value. The hasTargetName()
     * method will return false.
     */
    inline void clearTargetName();

    /**
     * Checks whether the field "targetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetName()). Otherwise it will return false.
     */
    inline bool hasTargetName () const;

    /**
     * Returns the value of the member "targetName".
     *
     * If the meaning of "targetName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "targetName"
     */
    inline const ::std::string& getTargetName () const;

    /**
     * Retrieves the value of the field "targetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "targetName".
     */
    inline ::std::string& getTargetNameMutable ();

    /**
     * Sets the value of the member "targetName".
     *
     * If the meaning of "targetName" isn't clear, then there should be a description here.
     *
     * @param targetName The value which will be set
     */
    inline void setTargetName (const ::std::string& targetName_);

    /**
     * Sets the value of the member "targetName".
     *
     * If the meaning of "targetName" isn't clear, then there should be a description here.
     *
     * @param targetName The value which will be set
     */
    inline void setTargetName (const char* targetName_);

    /**
     * Sets the value of the member "targetName".
     *
     * If the meaning of "targetName" isn't clear, then there should be a description here.
     *
     * @param targetName The value which will be set
     */
    inline void setTargetName (const char* value, size_t size);

    static const GetDefaultTargetResponse &getDefaultInstance();

private:

    inline void set_has_targetName ();

    inline void clear_has_targetName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _targetName;

};

/**
 * PresetAllUnitFiles() enables/disables one or more units file according to the preset policy.
 */
class PresetAllUnitFilesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PresetAllUnitFilesRequest ();

    /**
     * Copy constructor
     */
    inline  PresetAllUnitFilesRequest (const PresetAllUnitFilesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  PresetAllUnitFilesRequest (const ::std::string& name_, bool runtime_, bool force_);

    /**
     * Destructor
     */
    inline virtual  ~PresetAllUnitFilesRequest();

    /**
     * Assignment operator
     */
    inline PresetAllUnitFilesRequest& operator = (const PresetAllUnitFilesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PresetAllUnitFilesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PresetAllUnitFilesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PresetAllUnitFilesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PresetAllUnitFilesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "runtime"

    static const int kRuntime = 1;

    /**
     * Clears the field "runtime".
     *
     * The field will be set to its default value. The hasRuntime()
     * method will return false.
     */
    inline void clearRuntime();

    /**
     * Checks whether the field "runtime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntime()). Otherwise it will return false.
     */
    inline bool hasRuntime () const;

    /**
     * Returns the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "runtime"
     */
    inline bool getRuntime () const;

    /**
     * Sets the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param runtime The value which will be set
     */
    inline void setRuntime (bool runtime_);

    // API of field "force"

    static const int kForce = 2;

    /**
     * Clears the field "force".
     *
     * The field will be set to its default value. The hasForce()
     * method will return false.
     */
    inline void clearForce();

    /**
     * Checks whether the field "force" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setForce()). Otherwise it will return false.
     */
    inline bool hasForce () const;

    /**
     * Returns the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return The value of the field "force"
     */
    inline bool getForce () const;

    /**
     * Sets the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @param force The value which will be set
     */
    inline void setForce (bool force_);

    static const PresetAllUnitFilesRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_runtime ();

    inline void clear_has_runtime ();

    inline void set_has_force ();

    inline void clear_has_force ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _name;

    bool _runtime;

    bool _force;

};

/**
 * PresetAllUnitFiles() enables/disables one or more units file according to the preset policy.
 */
class PresetAllUnitFilesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PresetAllUnitFilesResponse ();

    /**
     * Copy constructor
     */
    inline  PresetAllUnitFilesResponse (const PresetAllUnitFilesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  PresetAllUnitFilesResponse (const ::std::vector< changes >& changes_);

    /**
     * Destructor
     */
    inline virtual  ~PresetAllUnitFilesResponse();

    /**
     * Assignment operator
     */
    inline PresetAllUnitFilesResponse& operator = (const PresetAllUnitFilesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PresetAllUnitFilesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PresetAllUnitFilesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PresetAllUnitFilesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PresetAllUnitFilesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "changes"

    static const int kChanges = 0;

    /**
     * Clears the field "changes".
     *
     * The field will be set to its default value. The hasChanges()
     * method will return false.
     */
    inline void clearChanges();

    /**
     * Checks whether the field "changes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanges()). Otherwise it will return false.
     */
    inline bool hasChanges () const;

    /**
     * Returns the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changes"
     */
    inline const ::std::vector< changes >& getChanges () const;

    /**
     * Retrieves the value of the field "changes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changes".
     */
    inline ::std::vector< changes >& getChangesMutable ();

    /**
     * Sets the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param changes The value which will be set
     */
    inline void setChanges (const ::std::vector< changes >& changes_);

    static const PresetAllUnitFilesResponse &getDefaultInstance();

private:

    static const ::std::vector< changes >& getChangesList_DefaultInstance ();

    inline void set_has_changes ();

    inline void clear_has_changes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< changes > _changes;

};

/**
 * AddDependencyUnitFiles()
 */
class AddDependencyUnitFilesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddDependencyUnitFilesRequest ();

    /**
     * Copy constructor
     */
    inline  AddDependencyUnitFilesRequest (const AddDependencyUnitFilesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AddDependencyUnitFilesRequest (const ::std::vector< ::std::string >& files_, const ::std::string& arg_1_, const ::std::string& arg_2_, bool runtime_, bool force_);

    /**
     * Destructor
     */
    inline virtual  ~AddDependencyUnitFilesRequest();

    /**
     * Assignment operator
     */
    inline AddDependencyUnitFilesRequest& operator = (const AddDependencyUnitFilesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddDependencyUnitFilesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddDependencyUnitFilesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddDependencyUnitFilesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddDependencyUnitFilesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "files"

    static const int kFiles = 0;

    /**
     * Clears the field "files".
     *
     * The field will be set to its default value. The hasFiles()
     * method will return false.
     */
    inline void clearFiles();

    /**
     * Checks whether the field "files" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFiles()). Otherwise it will return false.
     */
    inline bool hasFiles () const;

    /**
     * Returns the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @return The value of the field "files"
     */
    inline const ::std::vector< ::std::string >& getFiles () const;

    /**
     * Retrieves the value of the field "files" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "files".
     */
    inline ::std::vector< ::std::string >& getFilesMutable ();

    /**
     * Sets the value of the member "files".
     *
     * If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param files The value which will be set
     */
    inline void setFiles (const ::std::vector< ::std::string >& files_);

    // API of field "arg_1"

    static const int kArg_1 = 1;

    /**
     * Clears the field "arg_1".
     *
     * The field will be set to its default value. The hasArg_1()
     * method will return false.
     */
    inline void clearArg_1();

    /**
     * Checks whether the field "arg_1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg_1()). Otherwise it will return false.
     */
    inline bool hasArg_1 () const;

    /**
     * Returns the value of the member "arg_1".
     *
     * If the meaning of "arg_1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg_1"
     */
    inline const ::std::string& getArg_1 () const;

    /**
     * Retrieves the value of the field "arg_1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arg_1".
     */
    inline ::std::string& getArg_1Mutable ();

    /**
     * Sets the value of the member "arg_1".
     *
     * If the meaning of "arg_1" isn't clear, then there should be a description here.
     *
     * @param arg_1 The value which will be set
     */
    inline void setArg_1 (const ::std::string& arg_1_);

    /**
     * Sets the value of the member "arg_1".
     *
     * If the meaning of "arg_1" isn't clear, then there should be a description here.
     *
     * @param arg_1 The value which will be set
     */
    inline void setArg_1 (const char* arg_1_);

    /**
     * Sets the value of the member "arg_1".
     *
     * If the meaning of "arg_1" isn't clear, then there should be a description here.
     *
     * @param arg_1 The value which will be set
     */
    inline void setArg_1 (const char* value, size_t size);

    // API of field "arg_2"

    static const int kArg_2 = 2;

    /**
     * Clears the field "arg_2".
     *
     * The field will be set to its default value. The hasArg_2()
     * method will return false.
     */
    inline void clearArg_2();

    /**
     * Checks whether the field "arg_2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg_2()). Otherwise it will return false.
     */
    inline bool hasArg_2 () const;

    /**
     * Returns the value of the member "arg_2".
     *
     * If the meaning of "arg_2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg_2"
     */
    inline const ::std::string& getArg_2 () const;

    /**
     * Retrieves the value of the field "arg_2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arg_2".
     */
    inline ::std::string& getArg_2Mutable ();

    /**
     * Sets the value of the member "arg_2".
     *
     * If the meaning of "arg_2" isn't clear, then there should be a description here.
     *
     * @param arg_2 The value which will be set
     */
    inline void setArg_2 (const ::std::string& arg_2_);

    /**
     * Sets the value of the member "arg_2".
     *
     * If the meaning of "arg_2" isn't clear, then there should be a description here.
     *
     * @param arg_2 The value which will be set
     */
    inline void setArg_2 (const char* arg_2_);

    /**
     * Sets the value of the member "arg_2".
     *
     * If the meaning of "arg_2" isn't clear, then there should be a description here.
     *
     * @param arg_2 The value which will be set
     */
    inline void setArg_2 (const char* value, size_t size);

    // API of field "runtime"

    static const int kRuntime = 3;

    /**
     * Clears the field "runtime".
     *
     * The field will be set to its default value. The hasRuntime()
     * method will return false.
     */
    inline void clearRuntime();

    /**
     * Checks whether the field "runtime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntime()). Otherwise it will return false.
     */
    inline bool hasRuntime () const;

    /**
     * Returns the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "runtime"
     */
    inline bool getRuntime () const;

    /**
     * Sets the value of the member "runtime".
     *
     * If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param runtime The value which will be set
     */
    inline void setRuntime (bool runtime_);

    // API of field "force"

    static const int kForce = 4;

    /**
     * Clears the field "force".
     *
     * The field will be set to its default value. The hasForce()
     * method will return false.
     */
    inline void clearForce();

    /**
     * Checks whether the field "force" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setForce()). Otherwise it will return false.
     */
    inline bool hasForce () const;

    /**
     * Returns the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return The value of the field "force"
     */
    inline bool getForce () const;

    /**
     * Sets the value of the member "force".
     *
     * If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @param force The value which will be set
     */
    inline void setForce (bool force_);

    static const AddDependencyUnitFilesRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_files ();

    inline void clear_has_files ();

    inline void set_has_arg_1 ();

    inline void clear_has_arg_1 ();

    inline void set_has_arg_2 ();

    inline void clear_has_arg_2 ();

    inline void set_has_runtime ();

    inline void clear_has_runtime ();

    inline void set_has_force ();

    inline void clear_has_force ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::vector< ::std::string > _files;

    ::std::string _arg_1;

    ::std::string _arg_2;

    bool _runtime;

    bool _force;

};

/**
 * AddDependencyUnitFiles()
 */
class AddDependencyUnitFilesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddDependencyUnitFilesResponse ();

    /**
     * Copy constructor
     */
    inline  AddDependencyUnitFilesResponse (const AddDependencyUnitFilesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  AddDependencyUnitFilesResponse (const ::std::vector< changes >& changes_);

    /**
     * Destructor
     */
    inline virtual  ~AddDependencyUnitFilesResponse();

    /**
     * Assignment operator
     */
    inline AddDependencyUnitFilesResponse& operator = (const AddDependencyUnitFilesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddDependencyUnitFilesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddDependencyUnitFilesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddDependencyUnitFilesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddDependencyUnitFilesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "changes"

    static const int kChanges = 0;

    /**
     * Clears the field "changes".
     *
     * The field will be set to its default value. The hasChanges()
     * method will return false.
     */
    inline void clearChanges();

    /**
     * Checks whether the field "changes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanges()). Otherwise it will return false.
     */
    inline bool hasChanges () const;

    /**
     * Returns the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changes"
     */
    inline const ::std::vector< changes >& getChanges () const;

    /**
     * Retrieves the value of the field "changes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changes".
     */
    inline ::std::vector< changes >& getChangesMutable ();

    /**
     * Sets the value of the member "changes".
     *
     * If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param changes The value which will be set
     */
    inline void setChanges (const ::std::vector< changes >& changes_);

    static const AddDependencyUnitFilesResponse &getDefaultInstance();

private:

    static const ::std::vector< changes >& getChangesList_DefaultInstance ();

    inline void set_has_changes ();

    inline void clear_has_changes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< changes > _changes;

};

/**
 * This encodes encodes the version string of the running
 * 	    systemd instance.
 */
class VersionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VersionUpdate ();

    /**
     * Copy constructor
     */
    inline  VersionUpdate (const VersionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VersionUpdate (const ::std::string& Version_);

    /**
     * Destructor
     */
    inline virtual  ~VersionUpdate();

    /**
     * Assignment operator
     */
    inline VersionUpdate& operator = (const VersionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VersionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VersionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VersionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VersionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Version"

    static const int kVersion = 0;

    /**
     * Clears the field "Version".
     *
     * The field will be set to its default value. The hasVersion()
     * method will return false.
     */
    inline void clearVersion();

    /**
     * Checks whether the field "Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersion()). Otherwise it will return false.
     */
    inline bool hasVersion () const;

    /**
     * Returns the value of the member "Version".
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     *
     * @return The value of the field "Version"
     */
    inline const ::std::string& getVersion () const;

    /**
     * Retrieves the value of the field "Version" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Version".
     */
    inline ::std::string& getVersionMutable ();

    /**
     * Sets the value of the member "Version".
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const ::std::string& Version_);

    /**
     * Sets the value of the member "Version".
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const char* Version_);

    /**
     * Sets the value of the member "Version".
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const char* value, size_t size);

    static const VersionUpdate &getDefaultInstance();

private:

    inline void set_has_Version ();

    inline void clear_has_Version ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Version;

};

/**
 * This encodes encodes the version string of the running
 * 	    systemd instance.
 */
class VersionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VersionRegister ();

    /**
     * Copy constructor
     */
    inline  VersionRegister (const VersionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VersionRegister();

    /**
     * Assignment operator
     */
    inline VersionRegister& operator = (const VersionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VersionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VersionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VersionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VersionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VersionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
 */
class FeaturesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FeaturesUpdate ();

    /**
     * Copy constructor
     */
    inline  FeaturesUpdate (const FeaturesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FeaturesUpdate (const ::std::string& Features_);

    /**
     * Destructor
     */
    inline virtual  ~FeaturesUpdate();

    /**
     * Assignment operator
     */
    inline FeaturesUpdate& operator = (const FeaturesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FeaturesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FeaturesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FeaturesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FeaturesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Features"

    static const int kFeatures = 0;

    /**
     * Clears the field "Features".
     *
     * The field will be set to its default value. The hasFeatures()
     * method will return false.
     */
    inline void clearFeatures();

    /**
     * Checks whether the field "Features" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFeatures()). Otherwise it will return false.
     */
    inline bool hasFeatures () const;

    /**
     * Returns the value of the member "Features".
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     *
     * @return The value of the field "Features"
     */
    inline const ::std::string& getFeatures () const;

    /**
     * Retrieves the value of the field "Features" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Features".
     */
    inline ::std::string& getFeaturesMutable ();

    /**
     * Sets the value of the member "Features".
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     *
     * @param Features The value which will be set
     */
    inline void setFeatures (const ::std::string& Features_);

    /**
     * Sets the value of the member "Features".
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     *
     * @param Features The value which will be set
     */
    inline void setFeatures (const char* Features_);

    /**
     * Sets the value of the member "Features".
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     *
     * @param Features The value which will be set
     */
    inline void setFeatures (const char* value, size_t size);

    static const FeaturesUpdate &getDefaultInstance();

private:

    inline void set_has_Features ();

    inline void clear_has_Features ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Features;

};

/**
 * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
 */
class FeaturesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FeaturesRegister ();

    /**
     * Copy constructor
     */
    inline  FeaturesRegister (const FeaturesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FeaturesRegister();

    /**
     * Assignment operator
     */
    inline FeaturesRegister& operator = (const FeaturesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FeaturesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FeaturesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FeaturesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FeaturesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FeaturesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
 * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
 * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
 */
class VirtualizationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VirtualizationUpdate ();

    /**
     * Copy constructor
     */
    inline  VirtualizationUpdate (const VirtualizationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VirtualizationUpdate (const ::std::string& Virtualization_);

    /**
     * Destructor
     */
    inline virtual  ~VirtualizationUpdate();

    /**
     * Assignment operator
     */
    inline VirtualizationUpdate& operator = (const VirtualizationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VirtualizationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VirtualizationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VirtualizationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VirtualizationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Virtualization"

    static const int kVirtualization = 0;

    /**
     * Clears the field "Virtualization".
     *
     * The field will be set to its default value. The hasVirtualization()
     * method will return false.
     */
    inline void clearVirtualization();

    /**
     * Checks whether the field "Virtualization" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVirtualization()). Otherwise it will return false.
     */
    inline bool hasVirtualization () const;

    /**
     * Returns the value of the member "Virtualization".
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     *
     * @return The value of the field "Virtualization"
     */
    inline const ::std::string& getVirtualization () const;

    /**
     * Retrieves the value of the field "Virtualization" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Virtualization".
     */
    inline ::std::string& getVirtualizationMutable ();

    /**
     * Sets the value of the member "Virtualization".
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     *
     * @param Virtualization The value which will be set
     */
    inline void setVirtualization (const ::std::string& Virtualization_);

    /**
     * Sets the value of the member "Virtualization".
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     *
     * @param Virtualization The value which will be set
     */
    inline void setVirtualization (const char* Virtualization_);

    /**
     * Sets the value of the member "Virtualization".
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     *
     * @param Virtualization The value which will be set
     */
    inline void setVirtualization (const char* value, size_t size);

    static const VirtualizationUpdate &getDefaultInstance();

private:

    inline void set_has_Virtualization ();

    inline void clear_has_Virtualization ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Virtualization;

};

/**
 * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
 * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
 * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
 */
class VirtualizationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VirtualizationRegister ();

    /**
     * Copy constructor
     */
    inline  VirtualizationRegister (const VirtualizationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VirtualizationRegister();

    /**
     * Assignment operator
     */
    inline VirtualizationRegister& operator = (const VirtualizationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VirtualizationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VirtualizationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VirtualizationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VirtualizationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VirtualizationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Architecture contains a short ID string describing the architecture the systemd instance is running on.
 * 		This follows the same vocabulary as ConditionArchitectures=.
 */
class ArchitectureUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ArchitectureUpdate ();

    /**
     * Copy constructor
     */
    inline  ArchitectureUpdate (const ArchitectureUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ArchitectureUpdate (const ::std::string& Architecture_);

    /**
     * Destructor
     */
    inline virtual  ~ArchitectureUpdate();

    /**
     * Assignment operator
     */
    inline ArchitectureUpdate& operator = (const ArchitectureUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ArchitectureUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ArchitectureUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ArchitectureUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ArchitectureUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Architecture"

    static const int kArchitecture = 0;

    /**
     * Clears the field "Architecture".
     *
     * The field will be set to its default value. The hasArchitecture()
     * method will return false.
     */
    inline void clearArchitecture();

    /**
     * Checks whether the field "Architecture" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArchitecture()). Otherwise it will return false.
     */
    inline bool hasArchitecture () const;

    /**
     * Returns the value of the member "Architecture".
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     *
     * @return The value of the field "Architecture"
     */
    inline const ::std::string& getArchitecture () const;

    /**
     * Retrieves the value of the field "Architecture" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Architecture".
     */
    inline ::std::string& getArchitectureMutable ();

    /**
     * Sets the value of the member "Architecture".
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     *
     * @param Architecture The value which will be set
     */
    inline void setArchitecture (const ::std::string& Architecture_);

    /**
     * Sets the value of the member "Architecture".
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     *
     * @param Architecture The value which will be set
     */
    inline void setArchitecture (const char* Architecture_);

    /**
     * Sets the value of the member "Architecture".
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     *
     * @param Architecture The value which will be set
     */
    inline void setArchitecture (const char* value, size_t size);

    static const ArchitectureUpdate &getDefaultInstance();

private:

    inline void set_has_Architecture ();

    inline void clear_has_Architecture ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Architecture;

};

/**
 * Architecture contains a short ID string describing the architecture the systemd instance is running on.
 * 		This follows the same vocabulary as ConditionArchitectures=.
 */
class ArchitectureRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ArchitectureRegister ();

    /**
     * Copy constructor
     */
    inline  ArchitectureRegister (const ArchitectureRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ArchitectureRegister();

    /**
     * Assignment operator
     */
    inline ArchitectureRegister& operator = (const ArchitectureRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ArchitectureRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ArchitectureRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ArchitectureRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ArchitectureRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ArchitectureRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Tainted encodes a couple of taint flags, as colon separated list.
 * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
 */
class TaintedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TaintedUpdate ();

    /**
     * Copy constructor
     */
    inline  TaintedUpdate (const TaintedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TaintedUpdate (const ::std::string& Tainted_);

    /**
     * Destructor
     */
    inline virtual  ~TaintedUpdate();

    /**
     * Assignment operator
     */
    inline TaintedUpdate& operator = (const TaintedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TaintedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TaintedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TaintedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TaintedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Tainted"

    static const int kTainted = 0;

    /**
     * Clears the field "Tainted".
     *
     * The field will be set to its default value. The hasTainted()
     * method will return false.
     */
    inline void clearTainted();

    /**
     * Checks whether the field "Tainted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTainted()). Otherwise it will return false.
     */
    inline bool hasTainted () const;

    /**
     * Returns the value of the member "Tainted".
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     *
     * @return The value of the field "Tainted"
     */
    inline const ::std::string& getTainted () const;

    /**
     * Retrieves the value of the field "Tainted" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Tainted".
     */
    inline ::std::string& getTaintedMutable ();

    /**
     * Sets the value of the member "Tainted".
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     *
     * @param Tainted The value which will be set
     */
    inline void setTainted (const ::std::string& Tainted_);

    /**
     * Sets the value of the member "Tainted".
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     *
     * @param Tainted The value which will be set
     */
    inline void setTainted (const char* Tainted_);

    /**
     * Sets the value of the member "Tainted".
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     *
     * @param Tainted The value which will be set
     */
    inline void setTainted (const char* value, size_t size);

    static const TaintedUpdate &getDefaultInstance();

private:

    inline void set_has_Tainted ();

    inline void clear_has_Tainted ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Tainted;

};

/**
 * Tainted encodes a couple of taint flags, as colon separated list.
 * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
 */
class TaintedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TaintedRegister ();

    /**
     * Copy constructor
     */
    inline  TaintedRegister (const TaintedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TaintedRegister();

    /**
     * Assignment operator
     */
    inline TaintedRegister& operator = (const TaintedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TaintedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TaintedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TaintedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TaintedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TaintedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
 * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
 * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
 * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
 * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
 * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
 * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
 */
class FirmwareTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FirmwareTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  FirmwareTimestampUpdate (const FirmwareTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FirmwareTimestampUpdate (uint64 FirmwareTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~FirmwareTimestampUpdate();

    /**
     * Assignment operator
     */
    inline FirmwareTimestampUpdate& operator = (const FirmwareTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FirmwareTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FirmwareTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FirmwareTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FirmwareTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FirmwareTimestamp"

    static const int kFirmwareTimestamp = 0;

    /**
     * Clears the field "FirmwareTimestamp".
     *
     * The field will be set to its default value. The hasFirmwareTimestamp()
     * method will return false.
     */
    inline void clearFirmwareTimestamp();

    /**
     * Checks whether the field "FirmwareTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFirmwareTimestamp()). Otherwise it will return false.
     */
    inline bool hasFirmwareTimestamp () const;

    /**
     * Returns the value of the member "FirmwareTimestamp".
     *
     * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
     * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
     * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
     * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
     * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
     * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
     * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
     *
     * @return The value of the field "FirmwareTimestamp"
     */
    inline uint64 getFirmwareTimestamp () const;

    /**
     * Sets the value of the member "FirmwareTimestamp".
     *
     * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
     * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
     * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
     * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
     * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
     * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
     * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
     *
     * @param FirmwareTimestamp The value which will be set
     */
    inline void setFirmwareTimestamp (uint64 FirmwareTimestamp_);

    static const FirmwareTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_FirmwareTimestamp ();

    inline void clear_has_FirmwareTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _FirmwareTimestamp;

};

/**
 * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
 * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
 * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
 * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
 * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
 * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
 * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
 */
class FirmwareTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FirmwareTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  FirmwareTimestampRegister (const FirmwareTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FirmwareTimestampRegister();

    /**
     * Assignment operator
     */
    inline FirmwareTimestampRegister& operator = (const FirmwareTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FirmwareTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FirmwareTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FirmwareTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FirmwareTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FirmwareTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * FirmwareTimestampMonotonic
 */
class FirmwareTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FirmwareTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  FirmwareTimestampMonotonicUpdate (const FirmwareTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FirmwareTimestampMonotonicUpdate (uint64 FirmwareTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~FirmwareTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline FirmwareTimestampMonotonicUpdate& operator = (const FirmwareTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FirmwareTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FirmwareTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FirmwareTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FirmwareTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FirmwareTimestampMonotonic"

    static const int kFirmwareTimestampMonotonic = 0;

    /**
     * Clears the field "FirmwareTimestampMonotonic".
     *
     * The field will be set to its default value. The hasFirmwareTimestampMonotonic()
     * method will return false.
     */
    inline void clearFirmwareTimestampMonotonic();

    /**
     * Checks whether the field "FirmwareTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFirmwareTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasFirmwareTimestampMonotonic () const;

    /**
     * Returns the value of the member "FirmwareTimestampMonotonic".
     *
     * FirmwareTimestampMonotonic
     *
     * @return The value of the field "FirmwareTimestampMonotonic"
     */
    inline uint64 getFirmwareTimestampMonotonic () const;

    /**
     * Sets the value of the member "FirmwareTimestampMonotonic".
     *
     * FirmwareTimestampMonotonic
     *
     * @param FirmwareTimestampMonotonic The value which will be set
     */
    inline void setFirmwareTimestampMonotonic (uint64 FirmwareTimestampMonotonic_);

    static const FirmwareTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_FirmwareTimestampMonotonic ();

    inline void clear_has_FirmwareTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _FirmwareTimestampMonotonic;

};

/**
 * FirmwareTimestampMonotonic
 */
class FirmwareTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FirmwareTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  FirmwareTimestampMonotonicRegister (const FirmwareTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FirmwareTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline FirmwareTimestampMonotonicRegister& operator = (const FirmwareTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FirmwareTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FirmwareTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FirmwareTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FirmwareTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FirmwareTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * LoaderTimestamp
 */
class LoaderTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoaderTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  LoaderTimestampUpdate (const LoaderTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  LoaderTimestampUpdate (uint64 LoaderTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~LoaderTimestampUpdate();

    /**
     * Assignment operator
     */
    inline LoaderTimestampUpdate& operator = (const LoaderTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoaderTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoaderTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoaderTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoaderTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LoaderTimestamp"

    static const int kLoaderTimestamp = 0;

    /**
     * Clears the field "LoaderTimestamp".
     *
     * The field will be set to its default value. The hasLoaderTimestamp()
     * method will return false.
     */
    inline void clearLoaderTimestamp();

    /**
     * Checks whether the field "LoaderTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoaderTimestamp()). Otherwise it will return false.
     */
    inline bool hasLoaderTimestamp () const;

    /**
     * Returns the value of the member "LoaderTimestamp".
     *
     * LoaderTimestamp
     *
     * @return The value of the field "LoaderTimestamp"
     */
    inline uint64 getLoaderTimestamp () const;

    /**
     * Sets the value of the member "LoaderTimestamp".
     *
     * LoaderTimestamp
     *
     * @param LoaderTimestamp The value which will be set
     */
    inline void setLoaderTimestamp (uint64 LoaderTimestamp_);

    static const LoaderTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_LoaderTimestamp ();

    inline void clear_has_LoaderTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _LoaderTimestamp;

};

/**
 * LoaderTimestamp
 */
class LoaderTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoaderTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  LoaderTimestampRegister (const LoaderTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~LoaderTimestampRegister();

    /**
     * Assignment operator
     */
    inline LoaderTimestampRegister& operator = (const LoaderTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoaderTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoaderTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoaderTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoaderTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const LoaderTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * LoaderTimestampMonotonic
 */
class LoaderTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoaderTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  LoaderTimestampMonotonicUpdate (const LoaderTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  LoaderTimestampMonotonicUpdate (uint64 LoaderTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~LoaderTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline LoaderTimestampMonotonicUpdate& operator = (const LoaderTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoaderTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoaderTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoaderTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoaderTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LoaderTimestampMonotonic"

    static const int kLoaderTimestampMonotonic = 0;

    /**
     * Clears the field "LoaderTimestampMonotonic".
     *
     * The field will be set to its default value. The hasLoaderTimestampMonotonic()
     * method will return false.
     */
    inline void clearLoaderTimestampMonotonic();

    /**
     * Checks whether the field "LoaderTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoaderTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasLoaderTimestampMonotonic () const;

    /**
     * Returns the value of the member "LoaderTimestampMonotonic".
     *
     * LoaderTimestampMonotonic
     *
     * @return The value of the field "LoaderTimestampMonotonic"
     */
    inline uint64 getLoaderTimestampMonotonic () const;

    /**
     * Sets the value of the member "LoaderTimestampMonotonic".
     *
     * LoaderTimestampMonotonic
     *
     * @param LoaderTimestampMonotonic The value which will be set
     */
    inline void setLoaderTimestampMonotonic (uint64 LoaderTimestampMonotonic_);

    static const LoaderTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_LoaderTimestampMonotonic ();

    inline void clear_has_LoaderTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _LoaderTimestampMonotonic;

};

/**
 * LoaderTimestampMonotonic
 */
class LoaderTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoaderTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  LoaderTimestampMonotonicRegister (const LoaderTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~LoaderTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline LoaderTimestampMonotonicRegister& operator = (const LoaderTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoaderTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoaderTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoaderTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoaderTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const LoaderTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * KernelTimestamp
 */
class KernelTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KernelTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  KernelTimestampUpdate (const KernelTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  KernelTimestampUpdate (uint64 KernelTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~KernelTimestampUpdate();

    /**
     * Assignment operator
     */
    inline KernelTimestampUpdate& operator = (const KernelTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KernelTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KernelTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KernelTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KernelTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "KernelTimestamp"

    static const int kKernelTimestamp = 0;

    /**
     * Clears the field "KernelTimestamp".
     *
     * The field will be set to its default value. The hasKernelTimestamp()
     * method will return false.
     */
    inline void clearKernelTimestamp();

    /**
     * Checks whether the field "KernelTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKernelTimestamp()). Otherwise it will return false.
     */
    inline bool hasKernelTimestamp () const;

    /**
     * Returns the value of the member "KernelTimestamp".
     *
     * KernelTimestamp
     *
     * @return The value of the field "KernelTimestamp"
     */
    inline uint64 getKernelTimestamp () const;

    /**
     * Sets the value of the member "KernelTimestamp".
     *
     * KernelTimestamp
     *
     * @param KernelTimestamp The value which will be set
     */
    inline void setKernelTimestamp (uint64 KernelTimestamp_);

    static const KernelTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_KernelTimestamp ();

    inline void clear_has_KernelTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _KernelTimestamp;

};

/**
 * KernelTimestamp
 */
class KernelTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KernelTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  KernelTimestampRegister (const KernelTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~KernelTimestampRegister();

    /**
     * Assignment operator
     */
    inline KernelTimestampRegister& operator = (const KernelTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KernelTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KernelTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KernelTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KernelTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const KernelTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * KernelTimestampMonotonic
 */
class KernelTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KernelTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  KernelTimestampMonotonicUpdate (const KernelTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  KernelTimestampMonotonicUpdate (uint64 KernelTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~KernelTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline KernelTimestampMonotonicUpdate& operator = (const KernelTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KernelTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KernelTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KernelTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KernelTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "KernelTimestampMonotonic"

    static const int kKernelTimestampMonotonic = 0;

    /**
     * Clears the field "KernelTimestampMonotonic".
     *
     * The field will be set to its default value. The hasKernelTimestampMonotonic()
     * method will return false.
     */
    inline void clearKernelTimestampMonotonic();

    /**
     * Checks whether the field "KernelTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKernelTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasKernelTimestampMonotonic () const;

    /**
     * Returns the value of the member "KernelTimestampMonotonic".
     *
     * KernelTimestampMonotonic
     *
     * @return The value of the field "KernelTimestampMonotonic"
     */
    inline uint64 getKernelTimestampMonotonic () const;

    /**
     * Sets the value of the member "KernelTimestampMonotonic".
     *
     * KernelTimestampMonotonic
     *
     * @param KernelTimestampMonotonic The value which will be set
     */
    inline void setKernelTimestampMonotonic (uint64 KernelTimestampMonotonic_);

    static const KernelTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_KernelTimestampMonotonic ();

    inline void clear_has_KernelTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _KernelTimestampMonotonic;

};

/**
 * KernelTimestampMonotonic
 */
class KernelTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KernelTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  KernelTimestampMonotonicRegister (const KernelTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~KernelTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline KernelTimestampMonotonicRegister& operator = (const KernelTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KernelTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KernelTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KernelTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KernelTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const KernelTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * InitRDTimestamp
 */
class InitRDTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InitRDTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  InitRDTimestampUpdate (const InitRDTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  InitRDTimestampUpdate (uint64 InitRDTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~InitRDTimestampUpdate();

    /**
     * Assignment operator
     */
    inline InitRDTimestampUpdate& operator = (const InitRDTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InitRDTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InitRDTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InitRDTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InitRDTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InitRDTimestamp"

    static const int kInitRDTimestamp = 0;

    /**
     * Clears the field "InitRDTimestamp".
     *
     * The field will be set to its default value. The hasInitRDTimestamp()
     * method will return false.
     */
    inline void clearInitRDTimestamp();

    /**
     * Checks whether the field "InitRDTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInitRDTimestamp()). Otherwise it will return false.
     */
    inline bool hasInitRDTimestamp () const;

    /**
     * Returns the value of the member "InitRDTimestamp".
     *
     * InitRDTimestamp
     *
     * @return The value of the field "InitRDTimestamp"
     */
    inline uint64 getInitRDTimestamp () const;

    /**
     * Sets the value of the member "InitRDTimestamp".
     *
     * InitRDTimestamp
     *
     * @param InitRDTimestamp The value which will be set
     */
    inline void setInitRDTimestamp (uint64 InitRDTimestamp_);

    static const InitRDTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_InitRDTimestamp ();

    inline void clear_has_InitRDTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _InitRDTimestamp;

};

/**
 * InitRDTimestamp
 */
class InitRDTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InitRDTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  InitRDTimestampRegister (const InitRDTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~InitRDTimestampRegister();

    /**
     * Assignment operator
     */
    inline InitRDTimestampRegister& operator = (const InitRDTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InitRDTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InitRDTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InitRDTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InitRDTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const InitRDTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * InitRDTimestampMonotonic
 */
class InitRDTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InitRDTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  InitRDTimestampMonotonicUpdate (const InitRDTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  InitRDTimestampMonotonicUpdate (uint64 InitRDTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~InitRDTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline InitRDTimestampMonotonicUpdate& operator = (const InitRDTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InitRDTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InitRDTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InitRDTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InitRDTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InitRDTimestampMonotonic"

    static const int kInitRDTimestampMonotonic = 0;

    /**
     * Clears the field "InitRDTimestampMonotonic".
     *
     * The field will be set to its default value. The hasInitRDTimestampMonotonic()
     * method will return false.
     */
    inline void clearInitRDTimestampMonotonic();

    /**
     * Checks whether the field "InitRDTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInitRDTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasInitRDTimestampMonotonic () const;

    /**
     * Returns the value of the member "InitRDTimestampMonotonic".
     *
     * InitRDTimestampMonotonic
     *
     * @return The value of the field "InitRDTimestampMonotonic"
     */
    inline uint64 getInitRDTimestampMonotonic () const;

    /**
     * Sets the value of the member "InitRDTimestampMonotonic".
     *
     * InitRDTimestampMonotonic
     *
     * @param InitRDTimestampMonotonic The value which will be set
     */
    inline void setInitRDTimestampMonotonic (uint64 InitRDTimestampMonotonic_);

    static const InitRDTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_InitRDTimestampMonotonic ();

    inline void clear_has_InitRDTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _InitRDTimestampMonotonic;

};

/**
 * InitRDTimestampMonotonic
 */
class InitRDTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InitRDTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  InitRDTimestampMonotonicRegister (const InitRDTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~InitRDTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline InitRDTimestampMonotonicRegister& operator = (const InitRDTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InitRDTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InitRDTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InitRDTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InitRDTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const InitRDTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * UserspaceTimestamp
 */
class UserspaceTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UserspaceTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  UserspaceTimestampUpdate (const UserspaceTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UserspaceTimestampUpdate (uint64 UserspaceTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~UserspaceTimestampUpdate();

    /**
     * Assignment operator
     */
    inline UserspaceTimestampUpdate& operator = (const UserspaceTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UserspaceTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UserspaceTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UserspaceTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UserspaceTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UserspaceTimestamp"

    static const int kUserspaceTimestamp = 0;

    /**
     * Clears the field "UserspaceTimestamp".
     *
     * The field will be set to its default value. The hasUserspaceTimestamp()
     * method will return false.
     */
    inline void clearUserspaceTimestamp();

    /**
     * Checks whether the field "UserspaceTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserspaceTimestamp()). Otherwise it will return false.
     */
    inline bool hasUserspaceTimestamp () const;

    /**
     * Returns the value of the member "UserspaceTimestamp".
     *
     * UserspaceTimestamp
     *
     * @return The value of the field "UserspaceTimestamp"
     */
    inline uint64 getUserspaceTimestamp () const;

    /**
     * Sets the value of the member "UserspaceTimestamp".
     *
     * UserspaceTimestamp
     *
     * @param UserspaceTimestamp The value which will be set
     */
    inline void setUserspaceTimestamp (uint64 UserspaceTimestamp_);

    static const UserspaceTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_UserspaceTimestamp ();

    inline void clear_has_UserspaceTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _UserspaceTimestamp;

};

/**
 * UserspaceTimestamp
 */
class UserspaceTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UserspaceTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  UserspaceTimestampRegister (const UserspaceTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UserspaceTimestampRegister();

    /**
     * Assignment operator
     */
    inline UserspaceTimestampRegister& operator = (const UserspaceTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UserspaceTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UserspaceTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UserspaceTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UserspaceTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UserspaceTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * UserspaceTimestampMonotonic
 */
class UserspaceTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UserspaceTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  UserspaceTimestampMonotonicUpdate (const UserspaceTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UserspaceTimestampMonotonicUpdate (uint64 UserspaceTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~UserspaceTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline UserspaceTimestampMonotonicUpdate& operator = (const UserspaceTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UserspaceTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UserspaceTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UserspaceTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UserspaceTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UserspaceTimestampMonotonic"

    static const int kUserspaceTimestampMonotonic = 0;

    /**
     * Clears the field "UserspaceTimestampMonotonic".
     *
     * The field will be set to its default value. The hasUserspaceTimestampMonotonic()
     * method will return false.
     */
    inline void clearUserspaceTimestampMonotonic();

    /**
     * Checks whether the field "UserspaceTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserspaceTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasUserspaceTimestampMonotonic () const;

    /**
     * Returns the value of the member "UserspaceTimestampMonotonic".
     *
     * UserspaceTimestampMonotonic
     *
     * @return The value of the field "UserspaceTimestampMonotonic"
     */
    inline uint64 getUserspaceTimestampMonotonic () const;

    /**
     * Sets the value of the member "UserspaceTimestampMonotonic".
     *
     * UserspaceTimestampMonotonic
     *
     * @param UserspaceTimestampMonotonic The value which will be set
     */
    inline void setUserspaceTimestampMonotonic (uint64 UserspaceTimestampMonotonic_);

    static const UserspaceTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_UserspaceTimestampMonotonic ();

    inline void clear_has_UserspaceTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _UserspaceTimestampMonotonic;

};

/**
 * UserspaceTimestampMonotonic
 */
class UserspaceTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UserspaceTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  UserspaceTimestampMonotonicRegister (const UserspaceTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UserspaceTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline UserspaceTimestampMonotonicRegister& operator = (const UserspaceTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UserspaceTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UserspaceTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UserspaceTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UserspaceTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UserspaceTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * FinishTimestamp
 */
class FinishTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FinishTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  FinishTimestampUpdate (const FinishTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FinishTimestampUpdate (uint64 FinishTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~FinishTimestampUpdate();

    /**
     * Assignment operator
     */
    inline FinishTimestampUpdate& operator = (const FinishTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FinishTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FinishTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FinishTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FinishTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FinishTimestamp"

    static const int kFinishTimestamp = 0;

    /**
     * Clears the field "FinishTimestamp".
     *
     * The field will be set to its default value. The hasFinishTimestamp()
     * method will return false.
     */
    inline void clearFinishTimestamp();

    /**
     * Checks whether the field "FinishTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFinishTimestamp()). Otherwise it will return false.
     */
    inline bool hasFinishTimestamp () const;

    /**
     * Returns the value of the member "FinishTimestamp".
     *
     * FinishTimestamp
     *
     * @return The value of the field "FinishTimestamp"
     */
    inline uint64 getFinishTimestamp () const;

    /**
     * Sets the value of the member "FinishTimestamp".
     *
     * FinishTimestamp
     *
     * @param FinishTimestamp The value which will be set
     */
    inline void setFinishTimestamp (uint64 FinishTimestamp_);

    static const FinishTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_FinishTimestamp ();

    inline void clear_has_FinishTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _FinishTimestamp;

};

/**
 * FinishTimestamp
 */
class FinishTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FinishTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  FinishTimestampRegister (const FinishTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FinishTimestampRegister();

    /**
     * Assignment operator
     */
    inline FinishTimestampRegister& operator = (const FinishTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FinishTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FinishTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FinishTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FinishTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FinishTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * FinishTimestampMonotonic
 */
class FinishTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FinishTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  FinishTimestampMonotonicUpdate (const FinishTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FinishTimestampMonotonicUpdate (uint64 FinishTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~FinishTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline FinishTimestampMonotonicUpdate& operator = (const FinishTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FinishTimestampMonotonic"

    static const int kFinishTimestampMonotonic = 0;

    /**
     * Clears the field "FinishTimestampMonotonic".
     *
     * The field will be set to its default value. The hasFinishTimestampMonotonic()
     * method will return false.
     */
    inline void clearFinishTimestampMonotonic();

    /**
     * Checks whether the field "FinishTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFinishTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasFinishTimestampMonotonic () const;

    /**
     * Returns the value of the member "FinishTimestampMonotonic".
     *
     * FinishTimestampMonotonic
     *
     * @return The value of the field "FinishTimestampMonotonic"
     */
    inline uint64 getFinishTimestampMonotonic () const;

    /**
     * Sets the value of the member "FinishTimestampMonotonic".
     *
     * FinishTimestampMonotonic
     *
     * @param FinishTimestampMonotonic The value which will be set
     */
    inline void setFinishTimestampMonotonic (uint64 FinishTimestampMonotonic_);

    static const FinishTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_FinishTimestampMonotonic ();

    inline void clear_has_FinishTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _FinishTimestampMonotonic;

};

/**
 * FinishTimestampMonotonic
 */
class FinishTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FinishTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  FinishTimestampMonotonicRegister (const FinishTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FinishTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline FinishTimestampMonotonicRegister& operator = (const FinishTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FinishTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FinishTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FinishTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FinishTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FinishTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * SecurityStartTimestamp
 */
class SecurityStartTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityStartTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  SecurityStartTimestampUpdate (const SecurityStartTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SecurityStartTimestampUpdate (uint64 SecurityStartTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~SecurityStartTimestampUpdate();

    /**
     * Assignment operator
     */
    inline SecurityStartTimestampUpdate& operator = (const SecurityStartTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityStartTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityStartTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityStartTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityStartTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SecurityStartTimestamp"

    static const int kSecurityStartTimestamp = 0;

    /**
     * Clears the field "SecurityStartTimestamp".
     *
     * The field will be set to its default value. The hasSecurityStartTimestamp()
     * method will return false.
     */
    inline void clearSecurityStartTimestamp();

    /**
     * Checks whether the field "SecurityStartTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecurityStartTimestamp()). Otherwise it will return false.
     */
    inline bool hasSecurityStartTimestamp () const;

    /**
     * Returns the value of the member "SecurityStartTimestamp".
     *
     * SecurityStartTimestamp
     *
     * @return The value of the field "SecurityStartTimestamp"
     */
    inline uint64 getSecurityStartTimestamp () const;

    /**
     * Sets the value of the member "SecurityStartTimestamp".
     *
     * SecurityStartTimestamp
     *
     * @param SecurityStartTimestamp The value which will be set
     */
    inline void setSecurityStartTimestamp (uint64 SecurityStartTimestamp_);

    static const SecurityStartTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_SecurityStartTimestamp ();

    inline void clear_has_SecurityStartTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _SecurityStartTimestamp;

};

/**
 * SecurityStartTimestamp
 */
class SecurityStartTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityStartTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  SecurityStartTimestampRegister (const SecurityStartTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SecurityStartTimestampRegister();

    /**
     * Assignment operator
     */
    inline SecurityStartTimestampRegister& operator = (const SecurityStartTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityStartTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityStartTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityStartTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityStartTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SecurityStartTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * SecurityStartTimestampMonotonic
 */
class SecurityStartTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityStartTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  SecurityStartTimestampMonotonicUpdate (const SecurityStartTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SecurityStartTimestampMonotonicUpdate (uint64 SecurityStartTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~SecurityStartTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline SecurityStartTimestampMonotonicUpdate& operator = (const SecurityStartTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityStartTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityStartTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityStartTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityStartTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SecurityStartTimestampMonotonic"

    static const int kSecurityStartTimestampMonotonic = 0;

    /**
     * Clears the field "SecurityStartTimestampMonotonic".
     *
     * The field will be set to its default value. The hasSecurityStartTimestampMonotonic()
     * method will return false.
     */
    inline void clearSecurityStartTimestampMonotonic();

    /**
     * Checks whether the field "SecurityStartTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecurityStartTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasSecurityStartTimestampMonotonic () const;

    /**
     * Returns the value of the member "SecurityStartTimestampMonotonic".
     *
     * SecurityStartTimestampMonotonic
     *
     * @return The value of the field "SecurityStartTimestampMonotonic"
     */
    inline uint64 getSecurityStartTimestampMonotonic () const;

    /**
     * Sets the value of the member "SecurityStartTimestampMonotonic".
     *
     * SecurityStartTimestampMonotonic
     *
     * @param SecurityStartTimestampMonotonic The value which will be set
     */
    inline void setSecurityStartTimestampMonotonic (uint64 SecurityStartTimestampMonotonic_);

    static const SecurityStartTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_SecurityStartTimestampMonotonic ();

    inline void clear_has_SecurityStartTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _SecurityStartTimestampMonotonic;

};

/**
 * SecurityStartTimestampMonotonic
 */
class SecurityStartTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityStartTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  SecurityStartTimestampMonotonicRegister (const SecurityStartTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SecurityStartTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline SecurityStartTimestampMonotonicRegister& operator = (const SecurityStartTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityStartTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityStartTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityStartTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityStartTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SecurityStartTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * SecurityFinishTimestamp
 */
class SecurityFinishTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityFinishTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  SecurityFinishTimestampUpdate (const SecurityFinishTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SecurityFinishTimestampUpdate (uint64 SecurityFinishTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~SecurityFinishTimestampUpdate();

    /**
     * Assignment operator
     */
    inline SecurityFinishTimestampUpdate& operator = (const SecurityFinishTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityFinishTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityFinishTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityFinishTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityFinishTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SecurityFinishTimestamp"

    static const int kSecurityFinishTimestamp = 0;

    /**
     * Clears the field "SecurityFinishTimestamp".
     *
     * The field will be set to its default value. The hasSecurityFinishTimestamp()
     * method will return false.
     */
    inline void clearSecurityFinishTimestamp();

    /**
     * Checks whether the field "SecurityFinishTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecurityFinishTimestamp()). Otherwise it will return false.
     */
    inline bool hasSecurityFinishTimestamp () const;

    /**
     * Returns the value of the member "SecurityFinishTimestamp".
     *
     * SecurityFinishTimestamp
     *
     * @return The value of the field "SecurityFinishTimestamp"
     */
    inline uint64 getSecurityFinishTimestamp () const;

    /**
     * Sets the value of the member "SecurityFinishTimestamp".
     *
     * SecurityFinishTimestamp
     *
     * @param SecurityFinishTimestamp The value which will be set
     */
    inline void setSecurityFinishTimestamp (uint64 SecurityFinishTimestamp_);

    static const SecurityFinishTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_SecurityFinishTimestamp ();

    inline void clear_has_SecurityFinishTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _SecurityFinishTimestamp;

};

/**
 * SecurityFinishTimestamp
 */
class SecurityFinishTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityFinishTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  SecurityFinishTimestampRegister (const SecurityFinishTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SecurityFinishTimestampRegister();

    /**
     * Assignment operator
     */
    inline SecurityFinishTimestampRegister& operator = (const SecurityFinishTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityFinishTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityFinishTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityFinishTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityFinishTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SecurityFinishTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * SecurityFinishTimestampMonotonic
 */
class SecurityFinishTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityFinishTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  SecurityFinishTimestampMonotonicUpdate (const SecurityFinishTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SecurityFinishTimestampMonotonicUpdate (uint64 SecurityFinishTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~SecurityFinishTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline SecurityFinishTimestampMonotonicUpdate& operator = (const SecurityFinishTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityFinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityFinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityFinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityFinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SecurityFinishTimestampMonotonic"

    static const int kSecurityFinishTimestampMonotonic = 0;

    /**
     * Clears the field "SecurityFinishTimestampMonotonic".
     *
     * The field will be set to its default value. The hasSecurityFinishTimestampMonotonic()
     * method will return false.
     */
    inline void clearSecurityFinishTimestampMonotonic();

    /**
     * Checks whether the field "SecurityFinishTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecurityFinishTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasSecurityFinishTimestampMonotonic () const;

    /**
     * Returns the value of the member "SecurityFinishTimestampMonotonic".
     *
     * SecurityFinishTimestampMonotonic
     *
     * @return The value of the field "SecurityFinishTimestampMonotonic"
     */
    inline uint64 getSecurityFinishTimestampMonotonic () const;

    /**
     * Sets the value of the member "SecurityFinishTimestampMonotonic".
     *
     * SecurityFinishTimestampMonotonic
     *
     * @param SecurityFinishTimestampMonotonic The value which will be set
     */
    inline void setSecurityFinishTimestampMonotonic (uint64 SecurityFinishTimestampMonotonic_);

    static const SecurityFinishTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_SecurityFinishTimestampMonotonic ();

    inline void clear_has_SecurityFinishTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _SecurityFinishTimestampMonotonic;

};

/**
 * SecurityFinishTimestampMonotonic
 */
class SecurityFinishTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityFinishTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  SecurityFinishTimestampMonotonicRegister (const SecurityFinishTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SecurityFinishTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline SecurityFinishTimestampMonotonicRegister& operator = (const SecurityFinishTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityFinishTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityFinishTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityFinishTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityFinishTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SecurityFinishTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * GeneratorsStartTimestamp
 */
class GeneratorsStartTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneratorsStartTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  GeneratorsStartTimestampUpdate (const GeneratorsStartTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  GeneratorsStartTimestampUpdate (uint64 GeneratorsStartTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~GeneratorsStartTimestampUpdate();

    /**
     * Assignment operator
     */
    inline GeneratorsStartTimestampUpdate& operator = (const GeneratorsStartTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneratorsStartTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneratorsStartTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneratorsStartTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneratorsStartTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GeneratorsStartTimestamp"

    static const int kGeneratorsStartTimestamp = 0;

    /**
     * Clears the field "GeneratorsStartTimestamp".
     *
     * The field will be set to its default value. The hasGeneratorsStartTimestamp()
     * method will return false.
     */
    inline void clearGeneratorsStartTimestamp();

    /**
     * Checks whether the field "GeneratorsStartTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeneratorsStartTimestamp()). Otherwise it will return false.
     */
    inline bool hasGeneratorsStartTimestamp () const;

    /**
     * Returns the value of the member "GeneratorsStartTimestamp".
     *
     * GeneratorsStartTimestamp
     *
     * @return The value of the field "GeneratorsStartTimestamp"
     */
    inline uint64 getGeneratorsStartTimestamp () const;

    /**
     * Sets the value of the member "GeneratorsStartTimestamp".
     *
     * GeneratorsStartTimestamp
     *
     * @param GeneratorsStartTimestamp The value which will be set
     */
    inline void setGeneratorsStartTimestamp (uint64 GeneratorsStartTimestamp_);

    static const GeneratorsStartTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_GeneratorsStartTimestamp ();

    inline void clear_has_GeneratorsStartTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _GeneratorsStartTimestamp;

};

/**
 * GeneratorsStartTimestamp
 */
class GeneratorsStartTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneratorsStartTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  GeneratorsStartTimestampRegister (const GeneratorsStartTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~GeneratorsStartTimestampRegister();

    /**
     * Assignment operator
     */
    inline GeneratorsStartTimestampRegister& operator = (const GeneratorsStartTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneratorsStartTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneratorsStartTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneratorsStartTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneratorsStartTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const GeneratorsStartTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * GeneratorsStartTimestampMonotonic
 */
class GeneratorsStartTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneratorsStartTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  GeneratorsStartTimestampMonotonicUpdate (const GeneratorsStartTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  GeneratorsStartTimestampMonotonicUpdate (uint64 GeneratorsStartTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~GeneratorsStartTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline GeneratorsStartTimestampMonotonicUpdate& operator = (const GeneratorsStartTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneratorsStartTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneratorsStartTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneratorsStartTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneratorsStartTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GeneratorsStartTimestampMonotonic"

    static const int kGeneratorsStartTimestampMonotonic = 0;

    /**
     * Clears the field "GeneratorsStartTimestampMonotonic".
     *
     * The field will be set to its default value. The hasGeneratorsStartTimestampMonotonic()
     * method will return false.
     */
    inline void clearGeneratorsStartTimestampMonotonic();

    /**
     * Checks whether the field "GeneratorsStartTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeneratorsStartTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasGeneratorsStartTimestampMonotonic () const;

    /**
     * Returns the value of the member "GeneratorsStartTimestampMonotonic".
     *
     * GeneratorsStartTimestampMonotonic
     *
     * @return The value of the field "GeneratorsStartTimestampMonotonic"
     */
    inline uint64 getGeneratorsStartTimestampMonotonic () const;

    /**
     * Sets the value of the member "GeneratorsStartTimestampMonotonic".
     *
     * GeneratorsStartTimestampMonotonic
     *
     * @param GeneratorsStartTimestampMonotonic The value which will be set
     */
    inline void setGeneratorsStartTimestampMonotonic (uint64 GeneratorsStartTimestampMonotonic_);

    static const GeneratorsStartTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_GeneratorsStartTimestampMonotonic ();

    inline void clear_has_GeneratorsStartTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _GeneratorsStartTimestampMonotonic;

};

/**
 * GeneratorsStartTimestampMonotonic
 */
class GeneratorsStartTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneratorsStartTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  GeneratorsStartTimestampMonotonicRegister (const GeneratorsStartTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~GeneratorsStartTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline GeneratorsStartTimestampMonotonicRegister& operator = (const GeneratorsStartTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneratorsStartTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneratorsStartTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneratorsStartTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneratorsStartTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const GeneratorsStartTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * GeneratorsFinishTimestamp
 */
class GeneratorsFinishTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneratorsFinishTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  GeneratorsFinishTimestampUpdate (const GeneratorsFinishTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  GeneratorsFinishTimestampUpdate (uint64 GeneratorsFinishTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~GeneratorsFinishTimestampUpdate();

    /**
     * Assignment operator
     */
    inline GeneratorsFinishTimestampUpdate& operator = (const GeneratorsFinishTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneratorsFinishTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneratorsFinishTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneratorsFinishTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneratorsFinishTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GeneratorsFinishTimestamp"

    static const int kGeneratorsFinishTimestamp = 0;

    /**
     * Clears the field "GeneratorsFinishTimestamp".
     *
     * The field will be set to its default value. The hasGeneratorsFinishTimestamp()
     * method will return false.
     */
    inline void clearGeneratorsFinishTimestamp();

    /**
     * Checks whether the field "GeneratorsFinishTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeneratorsFinishTimestamp()). Otherwise it will return false.
     */
    inline bool hasGeneratorsFinishTimestamp () const;

    /**
     * Returns the value of the member "GeneratorsFinishTimestamp".
     *
     * GeneratorsFinishTimestamp
     *
     * @return The value of the field "GeneratorsFinishTimestamp"
     */
    inline uint64 getGeneratorsFinishTimestamp () const;

    /**
     * Sets the value of the member "GeneratorsFinishTimestamp".
     *
     * GeneratorsFinishTimestamp
     *
     * @param GeneratorsFinishTimestamp The value which will be set
     */
    inline void setGeneratorsFinishTimestamp (uint64 GeneratorsFinishTimestamp_);

    static const GeneratorsFinishTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_GeneratorsFinishTimestamp ();

    inline void clear_has_GeneratorsFinishTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _GeneratorsFinishTimestamp;

};

/**
 * GeneratorsFinishTimestamp
 */
class GeneratorsFinishTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneratorsFinishTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  GeneratorsFinishTimestampRegister (const GeneratorsFinishTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~GeneratorsFinishTimestampRegister();

    /**
     * Assignment operator
     */
    inline GeneratorsFinishTimestampRegister& operator = (const GeneratorsFinishTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneratorsFinishTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneratorsFinishTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneratorsFinishTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneratorsFinishTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const GeneratorsFinishTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * GeneratorsFinishTimestampMonotonic
 */
class GeneratorsFinishTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneratorsFinishTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  GeneratorsFinishTimestampMonotonicUpdate (const GeneratorsFinishTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  GeneratorsFinishTimestampMonotonicUpdate (uint64 GeneratorsFinishTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~GeneratorsFinishTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline GeneratorsFinishTimestampMonotonicUpdate& operator = (const GeneratorsFinishTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneratorsFinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneratorsFinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneratorsFinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneratorsFinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GeneratorsFinishTimestampMonotonic"

    static const int kGeneratorsFinishTimestampMonotonic = 0;

    /**
     * Clears the field "GeneratorsFinishTimestampMonotonic".
     *
     * The field will be set to its default value. The hasGeneratorsFinishTimestampMonotonic()
     * method will return false.
     */
    inline void clearGeneratorsFinishTimestampMonotonic();

    /**
     * Checks whether the field "GeneratorsFinishTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeneratorsFinishTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasGeneratorsFinishTimestampMonotonic () const;

    /**
     * Returns the value of the member "GeneratorsFinishTimestampMonotonic".
     *
     * GeneratorsFinishTimestampMonotonic
     *
     * @return The value of the field "GeneratorsFinishTimestampMonotonic"
     */
    inline uint64 getGeneratorsFinishTimestampMonotonic () const;

    /**
     * Sets the value of the member "GeneratorsFinishTimestampMonotonic".
     *
     * GeneratorsFinishTimestampMonotonic
     *
     * @param GeneratorsFinishTimestampMonotonic The value which will be set
     */
    inline void setGeneratorsFinishTimestampMonotonic (uint64 GeneratorsFinishTimestampMonotonic_);

    static const GeneratorsFinishTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_GeneratorsFinishTimestampMonotonic ();

    inline void clear_has_GeneratorsFinishTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _GeneratorsFinishTimestampMonotonic;

};

/**
 * GeneratorsFinishTimestampMonotonic
 */
class GeneratorsFinishTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneratorsFinishTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  GeneratorsFinishTimestampMonotonicRegister (const GeneratorsFinishTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~GeneratorsFinishTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline GeneratorsFinishTimestampMonotonicRegister& operator = (const GeneratorsFinishTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneratorsFinishTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneratorsFinishTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneratorsFinishTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneratorsFinishTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const GeneratorsFinishTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * UnitsLoadStartTimestamp
 */
class UnitsLoadStartTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitsLoadStartTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  UnitsLoadStartTimestampUpdate (const UnitsLoadStartTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UnitsLoadStartTimestampUpdate (uint64 UnitsLoadStartTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~UnitsLoadStartTimestampUpdate();

    /**
     * Assignment operator
     */
    inline UnitsLoadStartTimestampUpdate& operator = (const UnitsLoadStartTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitsLoadStartTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitsLoadStartTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitsLoadStartTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitsLoadStartTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UnitsLoadStartTimestamp"

    static const int kUnitsLoadStartTimestamp = 0;

    /**
     * Clears the field "UnitsLoadStartTimestamp".
     *
     * The field will be set to its default value. The hasUnitsLoadStartTimestamp()
     * method will return false.
     */
    inline void clearUnitsLoadStartTimestamp();

    /**
     * Checks whether the field "UnitsLoadStartTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnitsLoadStartTimestamp()). Otherwise it will return false.
     */
    inline bool hasUnitsLoadStartTimestamp () const;

    /**
     * Returns the value of the member "UnitsLoadStartTimestamp".
     *
     * UnitsLoadStartTimestamp
     *
     * @return The value of the field "UnitsLoadStartTimestamp"
     */
    inline uint64 getUnitsLoadStartTimestamp () const;

    /**
     * Sets the value of the member "UnitsLoadStartTimestamp".
     *
     * UnitsLoadStartTimestamp
     *
     * @param UnitsLoadStartTimestamp The value which will be set
     */
    inline void setUnitsLoadStartTimestamp (uint64 UnitsLoadStartTimestamp_);

    static const UnitsLoadStartTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_UnitsLoadStartTimestamp ();

    inline void clear_has_UnitsLoadStartTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _UnitsLoadStartTimestamp;

};

/**
 * UnitsLoadStartTimestamp
 */
class UnitsLoadStartTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitsLoadStartTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  UnitsLoadStartTimestampRegister (const UnitsLoadStartTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UnitsLoadStartTimestampRegister();

    /**
     * Assignment operator
     */
    inline UnitsLoadStartTimestampRegister& operator = (const UnitsLoadStartTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitsLoadStartTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitsLoadStartTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitsLoadStartTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitsLoadStartTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UnitsLoadStartTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * UnitsLoadStartTimestampMonotonic
 */
class UnitsLoadStartTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitsLoadStartTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  UnitsLoadStartTimestampMonotonicUpdate (const UnitsLoadStartTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UnitsLoadStartTimestampMonotonicUpdate (uint64 UnitsLoadStartTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~UnitsLoadStartTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline UnitsLoadStartTimestampMonotonicUpdate& operator = (const UnitsLoadStartTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitsLoadStartTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitsLoadStartTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitsLoadStartTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitsLoadStartTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UnitsLoadStartTimestampMonotonic"

    static const int kUnitsLoadStartTimestampMonotonic = 0;

    /**
     * Clears the field "UnitsLoadStartTimestampMonotonic".
     *
     * The field will be set to its default value. The hasUnitsLoadStartTimestampMonotonic()
     * method will return false.
     */
    inline void clearUnitsLoadStartTimestampMonotonic();

    /**
     * Checks whether the field "UnitsLoadStartTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnitsLoadStartTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasUnitsLoadStartTimestampMonotonic () const;

    /**
     * Returns the value of the member "UnitsLoadStartTimestampMonotonic".
     *
     * UnitsLoadStartTimestampMonotonic
     *
     * @return The value of the field "UnitsLoadStartTimestampMonotonic"
     */
    inline uint64 getUnitsLoadStartTimestampMonotonic () const;

    /**
     * Sets the value of the member "UnitsLoadStartTimestampMonotonic".
     *
     * UnitsLoadStartTimestampMonotonic
     *
     * @param UnitsLoadStartTimestampMonotonic The value which will be set
     */
    inline void setUnitsLoadStartTimestampMonotonic (uint64 UnitsLoadStartTimestampMonotonic_);

    static const UnitsLoadStartTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_UnitsLoadStartTimestampMonotonic ();

    inline void clear_has_UnitsLoadStartTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _UnitsLoadStartTimestampMonotonic;

};

/**
 * UnitsLoadStartTimestampMonotonic
 */
class UnitsLoadStartTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitsLoadStartTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  UnitsLoadStartTimestampMonotonicRegister (const UnitsLoadStartTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UnitsLoadStartTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline UnitsLoadStartTimestampMonotonicRegister& operator = (const UnitsLoadStartTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitsLoadStartTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitsLoadStartTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitsLoadStartTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitsLoadStartTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UnitsLoadStartTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * UnitsLoadFinishTimestamp
 */
class UnitsLoadFinishTimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitsLoadFinishTimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  UnitsLoadFinishTimestampUpdate (const UnitsLoadFinishTimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UnitsLoadFinishTimestampUpdate (uint64 UnitsLoadFinishTimestamp_);

    /**
     * Destructor
     */
    inline virtual  ~UnitsLoadFinishTimestampUpdate();

    /**
     * Assignment operator
     */
    inline UnitsLoadFinishTimestampUpdate& operator = (const UnitsLoadFinishTimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitsLoadFinishTimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitsLoadFinishTimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitsLoadFinishTimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitsLoadFinishTimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UnitsLoadFinishTimestamp"

    static const int kUnitsLoadFinishTimestamp = 0;

    /**
     * Clears the field "UnitsLoadFinishTimestamp".
     *
     * The field will be set to its default value. The hasUnitsLoadFinishTimestamp()
     * method will return false.
     */
    inline void clearUnitsLoadFinishTimestamp();

    /**
     * Checks whether the field "UnitsLoadFinishTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnitsLoadFinishTimestamp()). Otherwise it will return false.
     */
    inline bool hasUnitsLoadFinishTimestamp () const;

    /**
     * Returns the value of the member "UnitsLoadFinishTimestamp".
     *
     * UnitsLoadFinishTimestamp
     *
     * @return The value of the field "UnitsLoadFinishTimestamp"
     */
    inline uint64 getUnitsLoadFinishTimestamp () const;

    /**
     * Sets the value of the member "UnitsLoadFinishTimestamp".
     *
     * UnitsLoadFinishTimestamp
     *
     * @param UnitsLoadFinishTimestamp The value which will be set
     */
    inline void setUnitsLoadFinishTimestamp (uint64 UnitsLoadFinishTimestamp_);

    static const UnitsLoadFinishTimestampUpdate &getDefaultInstance();

private:

    inline void set_has_UnitsLoadFinishTimestamp ();

    inline void clear_has_UnitsLoadFinishTimestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _UnitsLoadFinishTimestamp;

};

/**
 * UnitsLoadFinishTimestamp
 */
class UnitsLoadFinishTimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitsLoadFinishTimestampRegister ();

    /**
     * Copy constructor
     */
    inline  UnitsLoadFinishTimestampRegister (const UnitsLoadFinishTimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UnitsLoadFinishTimestampRegister();

    /**
     * Assignment operator
     */
    inline UnitsLoadFinishTimestampRegister& operator = (const UnitsLoadFinishTimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitsLoadFinishTimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitsLoadFinishTimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitsLoadFinishTimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitsLoadFinishTimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UnitsLoadFinishTimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * UnitsLoadFinishTimestampMonotonic
 */
class UnitsLoadFinishTimestampMonotonicUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitsLoadFinishTimestampMonotonicUpdate ();

    /**
     * Copy constructor
     */
    inline  UnitsLoadFinishTimestampMonotonicUpdate (const UnitsLoadFinishTimestampMonotonicUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UnitsLoadFinishTimestampMonotonicUpdate (uint64 UnitsLoadFinishTimestampMonotonic_);

    /**
     * Destructor
     */
    inline virtual  ~UnitsLoadFinishTimestampMonotonicUpdate();

    /**
     * Assignment operator
     */
    inline UnitsLoadFinishTimestampMonotonicUpdate& operator = (const UnitsLoadFinishTimestampMonotonicUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitsLoadFinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitsLoadFinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitsLoadFinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitsLoadFinishTimestampMonotonicUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UnitsLoadFinishTimestampMonotonic"

    static const int kUnitsLoadFinishTimestampMonotonic = 0;

    /**
     * Clears the field "UnitsLoadFinishTimestampMonotonic".
     *
     * The field will be set to its default value. The hasUnitsLoadFinishTimestampMonotonic()
     * method will return false.
     */
    inline void clearUnitsLoadFinishTimestampMonotonic();

    /**
     * Checks whether the field "UnitsLoadFinishTimestampMonotonic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnitsLoadFinishTimestampMonotonic()). Otherwise it will return false.
     */
    inline bool hasUnitsLoadFinishTimestampMonotonic () const;

    /**
     * Returns the value of the member "UnitsLoadFinishTimestampMonotonic".
     *
     * UnitsLoadFinishTimestampMonotonic
     *
     * @return The value of the field "UnitsLoadFinishTimestampMonotonic"
     */
    inline uint64 getUnitsLoadFinishTimestampMonotonic () const;

    /**
     * Sets the value of the member "UnitsLoadFinishTimestampMonotonic".
     *
     * UnitsLoadFinishTimestampMonotonic
     *
     * @param UnitsLoadFinishTimestampMonotonic The value which will be set
     */
    inline void setUnitsLoadFinishTimestampMonotonic (uint64 UnitsLoadFinishTimestampMonotonic_);

    static const UnitsLoadFinishTimestampMonotonicUpdate &getDefaultInstance();

private:

    inline void set_has_UnitsLoadFinishTimestampMonotonic ();

    inline void clear_has_UnitsLoadFinishTimestampMonotonic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _UnitsLoadFinishTimestampMonotonic;

};

/**
 * UnitsLoadFinishTimestampMonotonic
 */
class UnitsLoadFinishTimestampMonotonicRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitsLoadFinishTimestampMonotonicRegister ();

    /**
     * Copy constructor
     */
    inline  UnitsLoadFinishTimestampMonotonicRegister (const UnitsLoadFinishTimestampMonotonicRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UnitsLoadFinishTimestampMonotonicRegister();

    /**
     * Assignment operator
     */
    inline UnitsLoadFinishTimestampMonotonicRegister& operator = (const UnitsLoadFinishTimestampMonotonicRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitsLoadFinishTimestampMonotonicRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitsLoadFinishTimestampMonotonicRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitsLoadFinishTimestampMonotonicRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitsLoadFinishTimestampMonotonicRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UnitsLoadFinishTimestampMonotonicRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * LogLevel
 */
class LogLevelUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LogLevelUpdate ();

    /**
     * Copy constructor
     */
    inline  LogLevelUpdate (const LogLevelUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  LogLevelUpdate (const ::std::string& LogLevel_);

    /**
     * Destructor
     */
    inline virtual  ~LogLevelUpdate();

    /**
     * Assignment operator
     */
    inline LogLevelUpdate& operator = (const LogLevelUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LogLevelUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LogLevelUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LogLevelUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LogLevelUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LogLevel"

    static const int kLogLevel = 0;

    /**
     * Clears the field "LogLevel".
     *
     * The field will be set to its default value. The hasLogLevel()
     * method will return false.
     */
    inline void clearLogLevel();

    /**
     * Checks whether the field "LogLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLogLevel()). Otherwise it will return false.
     */
    inline bool hasLogLevel () const;

    /**
     * Returns the value of the member "LogLevel".
     *
     * LogLevel
     *
     * @return The value of the field "LogLevel"
     */
    inline const ::std::string& getLogLevel () const;

    /**
     * Retrieves the value of the field "LogLevel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LogLevel".
     */
    inline ::std::string& getLogLevelMutable ();

    /**
     * Sets the value of the member "LogLevel".
     *
     * LogLevel
     *
     * @param LogLevel The value which will be set
     */
    inline void setLogLevel (const ::std::string& LogLevel_);

    /**
     * Sets the value of the member "LogLevel".
     *
     * LogLevel
     *
     * @param LogLevel The value which will be set
     */
    inline void setLogLevel (const char* LogLevel_);

    /**
     * Sets the value of the member "LogLevel".
     *
     * LogLevel
     *
     * @param LogLevel The value which will be set
     */
    inline void setLogLevel (const char* value, size_t size);

    static const LogLevelUpdate &getDefaultInstance();

private:

    inline void set_has_LogLevel ();

    inline void clear_has_LogLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _LogLevel;

};

/**
 * LogLevel
 */
class LogLevelRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LogLevelRegister ();

    /**
     * Copy constructor
     */
    inline  LogLevelRegister (const LogLevelRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~LogLevelRegister();

    /**
     * Assignment operator
     */
    inline LogLevelRegister& operator = (const LogLevelRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LogLevelRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LogLevelRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LogLevelRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LogLevelRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const LogLevelRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * LogTarget
 */
class LogTargetUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LogTargetUpdate ();

    /**
     * Copy constructor
     */
    inline  LogTargetUpdate (const LogTargetUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  LogTargetUpdate (const ::std::string& LogTarget_);

    /**
     * Destructor
     */
    inline virtual  ~LogTargetUpdate();

    /**
     * Assignment operator
     */
    inline LogTargetUpdate& operator = (const LogTargetUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LogTargetUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LogTargetUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LogTargetUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LogTargetUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LogTarget"

    static const int kLogTarget = 0;

    /**
     * Clears the field "LogTarget".
     *
     * The field will be set to its default value. The hasLogTarget()
     * method will return false.
     */
    inline void clearLogTarget();

    /**
     * Checks whether the field "LogTarget" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLogTarget()). Otherwise it will return false.
     */
    inline bool hasLogTarget () const;

    /**
     * Returns the value of the member "LogTarget".
     *
     * LogTarget
     *
     * @return The value of the field "LogTarget"
     */
    inline const ::std::string& getLogTarget () const;

    /**
     * Retrieves the value of the field "LogTarget" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LogTarget".
     */
    inline ::std::string& getLogTargetMutable ();

    /**
     * Sets the value of the member "LogTarget".
     *
     * LogTarget
     *
     * @param LogTarget The value which will be set
     */
    inline void setLogTarget (const ::std::string& LogTarget_);

    /**
     * Sets the value of the member "LogTarget".
     *
     * LogTarget
     *
     * @param LogTarget The value which will be set
     */
    inline void setLogTarget (const char* LogTarget_);

    /**
     * Sets the value of the member "LogTarget".
     *
     * LogTarget
     *
     * @param LogTarget The value which will be set
     */
    inline void setLogTarget (const char* value, size_t size);

    static const LogTargetUpdate &getDefaultInstance();

private:

    inline void set_has_LogTarget ();

    inline void clear_has_LogTarget ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _LogTarget;

};

/**
 * LogTarget
 */
class LogTargetRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LogTargetRegister ();

    /**
     * Copy constructor
     */
    inline  LogTargetRegister (const LogTargetRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~LogTargetRegister();

    /**
     * Assignment operator
     */
    inline LogTargetRegister& operator = (const LogTargetRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LogTargetRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LogTargetRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LogTargetRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LogTargetRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const LogTargetRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * NNames encodes how many unit names are currently known. This only includes names of units that are currently
 * 		loaded and can be more than actually loaded units since units may have more than one name.
 */
class NNamesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NNamesUpdate ();

    /**
     * Copy constructor
     */
    inline  NNamesUpdate (const NNamesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NNamesUpdate (uint32 NNames_);

    /**
     * Destructor
     */
    inline virtual  ~NNamesUpdate();

    /**
     * Assignment operator
     */
    inline NNamesUpdate& operator = (const NNamesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NNamesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NNamesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NNamesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NNamesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NNames"

    static const int kNNames = 0;

    /**
     * Clears the field "NNames".
     *
     * The field will be set to its default value. The hasNNames()
     * method will return false.
     */
    inline void clearNNames();

    /**
     * Checks whether the field "NNames" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNNames()). Otherwise it will return false.
     */
    inline bool hasNNames () const;

    /**
     * Returns the value of the member "NNames".
     *
     * NNames encodes how many unit names are currently known. This only includes names of units that are currently
     * 		loaded and can be more than actually loaded units since units may have more than one name.
     *
     * @return The value of the field "NNames"
     */
    inline uint32 getNNames () const;

    /**
     * Sets the value of the member "NNames".
     *
     * NNames encodes how many unit names are currently known. This only includes names of units that are currently
     * 		loaded and can be more than actually loaded units since units may have more than one name.
     *
     * @param NNames The value which will be set
     */
    inline void setNNames (uint32 NNames_);

    static const NNamesUpdate &getDefaultInstance();

private:

    inline void set_has_NNames ();

    inline void clear_has_NNames ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _NNames;

};

/**
 * NNames encodes how many unit names are currently known. This only includes names of units that are currently
 * 		loaded and can be more than actually loaded units since units may have more than one name.
 */
class NNamesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NNamesRegister ();

    /**
     * Copy constructor
     */
    inline  NNamesRegister (const NNamesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NNamesRegister();

    /**
     * Assignment operator
     */
    inline NNamesRegister& operator = (const NNamesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NNamesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NNamesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NNamesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NNamesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NNamesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * NFailedUnits.
 */
class NFailedUnitsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NFailedUnitsUpdate ();

    /**
     * Copy constructor
     */
    inline  NFailedUnitsUpdate (const NFailedUnitsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NFailedUnitsUpdate (uint32 NFailedUnits_);

    /**
     * Destructor
     */
    inline virtual  ~NFailedUnitsUpdate();

    /**
     * Assignment operator
     */
    inline NFailedUnitsUpdate& operator = (const NFailedUnitsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NFailedUnitsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NFailedUnitsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NFailedUnitsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NFailedUnitsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NFailedUnits"

    static const int kNFailedUnits = 0;

    /**
     * Clears the field "NFailedUnits".
     *
     * The field will be set to its default value. The hasNFailedUnits()
     * method will return false.
     */
    inline void clearNFailedUnits();

    /**
     * Checks whether the field "NFailedUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNFailedUnits()). Otherwise it will return false.
     */
    inline bool hasNFailedUnits () const;

    /**
     * Returns the value of the member "NFailedUnits".
     *
     * NFailedUnits.
     *
     * @return The value of the field "NFailedUnits"
     */
    inline uint32 getNFailedUnits () const;

    /**
     * Sets the value of the member "NFailedUnits".
     *
     * NFailedUnits.
     *
     * @param NFailedUnits The value which will be set
     */
    inline void setNFailedUnits (uint32 NFailedUnits_);

    static const NFailedUnitsUpdate &getDefaultInstance();

private:

    inline void set_has_NFailedUnits ();

    inline void clear_has_NFailedUnits ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _NFailedUnits;

};

/**
 * NFailedUnits.
 */
class NFailedUnitsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NFailedUnitsRegister ();

    /**
     * Copy constructor
     */
    inline  NFailedUnitsRegister (const NFailedUnitsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NFailedUnitsRegister();

    /**
     * Assignment operator
     */
    inline NFailedUnitsRegister& operator = (const NFailedUnitsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NFailedUnitsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NFailedUnitsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NFailedUnitsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NFailedUnitsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NFailedUnitsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * NJobs encodes how many jobs are currently queued.
 */
class NJobsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NJobsUpdate ();

    /**
     * Copy constructor
     */
    inline  NJobsUpdate (const NJobsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NJobsUpdate (uint32 NJobs_);

    /**
     * Destructor
     */
    inline virtual  ~NJobsUpdate();

    /**
     * Assignment operator
     */
    inline NJobsUpdate& operator = (const NJobsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NJobsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NJobsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NJobsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NJobsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NJobs"

    static const int kNJobs = 0;

    /**
     * Clears the field "NJobs".
     *
     * The field will be set to its default value. The hasNJobs()
     * method will return false.
     */
    inline void clearNJobs();

    /**
     * Checks whether the field "NJobs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNJobs()). Otherwise it will return false.
     */
    inline bool hasNJobs () const;

    /**
     * Returns the value of the member "NJobs".
     *
     * NJobs encodes how many jobs are currently queued.
     *
     * @return The value of the field "NJobs"
     */
    inline uint32 getNJobs () const;

    /**
     * Sets the value of the member "NJobs".
     *
     * NJobs encodes how many jobs are currently queued.
     *
     * @param NJobs The value which will be set
     */
    inline void setNJobs (uint32 NJobs_);

    static const NJobsUpdate &getDefaultInstance();

private:

    inline void set_has_NJobs ();

    inline void clear_has_NJobs ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _NJobs;

};

/**
 * NJobs encodes how many jobs are currently queued.
 */
class NJobsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NJobsRegister ();

    /**
     * Copy constructor
     */
    inline  NJobsRegister (const NJobsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NJobsRegister();

    /**
     * Assignment operator
     */
    inline NJobsRegister& operator = (const NJobsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NJobsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NJobsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NJobsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NJobsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NJobsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * NInstalledJobs encodes how many jobs have ever been queued in total.
 */
class NInstalledJobsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NInstalledJobsUpdate ();

    /**
     * Copy constructor
     */
    inline  NInstalledJobsUpdate (const NInstalledJobsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NInstalledJobsUpdate (uint32 NInstalledJobs_);

    /**
     * Destructor
     */
    inline virtual  ~NInstalledJobsUpdate();

    /**
     * Assignment operator
     */
    inline NInstalledJobsUpdate& operator = (const NInstalledJobsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NInstalledJobsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NInstalledJobsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NInstalledJobsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NInstalledJobsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NInstalledJobs"

    static const int kNInstalledJobs = 0;

    /**
     * Clears the field "NInstalledJobs".
     *
     * The field will be set to its default value. The hasNInstalledJobs()
     * method will return false.
     */
    inline void clearNInstalledJobs();

    /**
     * Checks whether the field "NInstalledJobs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNInstalledJobs()). Otherwise it will return false.
     */
    inline bool hasNInstalledJobs () const;

    /**
     * Returns the value of the member "NInstalledJobs".
     *
     * NInstalledJobs encodes how many jobs have ever been queued in total.
     *
     * @return The value of the field "NInstalledJobs"
     */
    inline uint32 getNInstalledJobs () const;

    /**
     * Sets the value of the member "NInstalledJobs".
     *
     * NInstalledJobs encodes how many jobs have ever been queued in total.
     *
     * @param NInstalledJobs The value which will be set
     */
    inline void setNInstalledJobs (uint32 NInstalledJobs_);

    static const NInstalledJobsUpdate &getDefaultInstance();

private:

    inline void set_has_NInstalledJobs ();

    inline void clear_has_NInstalledJobs ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _NInstalledJobs;

};

/**
 * NInstalledJobs encodes how many jobs have ever been queued in total.
 */
class NInstalledJobsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NInstalledJobsRegister ();

    /**
     * Copy constructor
     */
    inline  NInstalledJobsRegister (const NInstalledJobsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NInstalledJobsRegister();

    /**
     * Assignment operator
     */
    inline NInstalledJobsRegister& operator = (const NInstalledJobsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NInstalledJobsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NInstalledJobsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NInstalledJobsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NInstalledJobsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NInstalledJobsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * NFailedJobs encodes how many jobs have ever failed in total.
 */
class NFailedJobsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NFailedJobsUpdate ();

    /**
     * Copy constructor
     */
    inline  NFailedJobsUpdate (const NFailedJobsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NFailedJobsUpdate (uint32 NFailedJobs_);

    /**
     * Destructor
     */
    inline virtual  ~NFailedJobsUpdate();

    /**
     * Assignment operator
     */
    inline NFailedJobsUpdate& operator = (const NFailedJobsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NFailedJobsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NFailedJobsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NFailedJobsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NFailedJobsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NFailedJobs"

    static const int kNFailedJobs = 0;

    /**
     * Clears the field "NFailedJobs".
     *
     * The field will be set to its default value. The hasNFailedJobs()
     * method will return false.
     */
    inline void clearNFailedJobs();

    /**
     * Checks whether the field "NFailedJobs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNFailedJobs()). Otherwise it will return false.
     */
    inline bool hasNFailedJobs () const;

    /**
     * Returns the value of the member "NFailedJobs".
     *
     * NFailedJobs encodes how many jobs have ever failed in total.
     *
     * @return The value of the field "NFailedJobs"
     */
    inline uint32 getNFailedJobs () const;

    /**
     * Sets the value of the member "NFailedJobs".
     *
     * NFailedJobs encodes how many jobs have ever failed in total.
     *
     * @param NFailedJobs The value which will be set
     */
    inline void setNFailedJobs (uint32 NFailedJobs_);

    static const NFailedJobsUpdate &getDefaultInstance();

private:

    inline void set_has_NFailedJobs ();

    inline void clear_has_NFailedJobs ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _NFailedJobs;

};

/**
 * NFailedJobs encodes how many jobs have ever failed in total.
 */
class NFailedJobsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NFailedJobsRegister ();

    /**
     * Copy constructor
     */
    inline  NFailedJobsRegister (const NFailedJobsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NFailedJobsRegister();

    /**
     * Assignment operator
     */
    inline NFailedJobsRegister& operator = (const NFailedJobsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NFailedJobsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NFailedJobsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NFailedJobsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NFailedJobsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NFailedJobsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Progress encodes boot progress as floating point value between 0.0 and 1.0.
 * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
 * 		After startup this field is always 1.0 indicating a finished boot.
 */
class ProgressUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProgressUpdate ();

    /**
     * Copy constructor
     */
    inline  ProgressUpdate (const ProgressUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ProgressUpdate (double Progress_);

    /**
     * Destructor
     */
    inline virtual  ~ProgressUpdate();

    /**
     * Assignment operator
     */
    inline ProgressUpdate& operator = (const ProgressUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProgressUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProgressUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProgressUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProgressUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Progress"

    static const int kProgress = 0;

    /**
     * Clears the field "Progress".
     *
     * The field will be set to its default value. The hasProgress()
     * method will return false.
     */
    inline void clearProgress();

    /**
     * Checks whether the field "Progress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProgress()). Otherwise it will return false.
     */
    inline bool hasProgress () const;

    /**
     * Returns the value of the member "Progress".
     *
     * Progress encodes boot progress as floating point value between 0.0 and 1.0.
     * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
     * 		After startup this field is always 1.0 indicating a finished boot.
     *
     * @return The value of the field "Progress"
     */
    inline double getProgress () const;

    /**
     * Sets the value of the member "Progress".
     *
     * Progress encodes boot progress as floating point value between 0.0 and 1.0.
     * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
     * 		After startup this field is always 1.0 indicating a finished boot.
     *
     * @param Progress The value which will be set
     */
    inline void setProgress (double Progress_);

    static const ProgressUpdate &getDefaultInstance();

private:

    inline void set_has_Progress ();

    inline void clear_has_Progress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    double _Progress;

};

/**
 * Progress encodes boot progress as floating point value between 0.0 and 1.0.
 * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
 * 		After startup this field is always 1.0 indicating a finished boot.
 */
class ProgressRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProgressRegister ();

    /**
     * Copy constructor
     */
    inline  ProgressRegister (const ProgressRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ProgressRegister();

    /**
     * Assignment operator
     */
    inline ProgressRegister& operator = (const ProgressRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProgressRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProgressRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProgressRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProgressRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ProgressRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
 */
class EnvironmentUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnvironmentUpdate ();

    /**
     * Copy constructor
     */
    inline  EnvironmentUpdate (const EnvironmentUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  EnvironmentUpdate (const ::std::vector< ::std::string >& Environment_);

    /**
     * Destructor
     */
    inline virtual  ~EnvironmentUpdate();

    /**
     * Assignment operator
     */
    inline EnvironmentUpdate& operator = (const EnvironmentUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnvironmentUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnvironmentUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnvironmentUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnvironmentUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Environment"

    static const int kEnvironment = 0;

    /**
     * Clears the field "Environment".
     *
     * The field will be set to its default value. The hasEnvironment()
     * method will return false.
     */
    inline void clearEnvironment();

    /**
     * Checks whether the field "Environment" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnvironment()). Otherwise it will return false.
     */
    inline bool hasEnvironment () const;

    /**
     * Returns the value of the member "Environment".
     *
     * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
     *
     * @return The value of the field "Environment"
     */
    inline const ::std::vector< ::std::string >& getEnvironment () const;

    /**
     * Retrieves the value of the field "Environment" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Environment".
     */
    inline ::std::vector< ::std::string >& getEnvironmentMutable ();

    /**
     * Sets the value of the member "Environment".
     *
     * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
     *
     * @param Environment The value which will be set
     */
    inline void setEnvironment (const ::std::vector< ::std::string >& Environment_);

    static const EnvironmentUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_Environment ();

    inline void clear_has_Environment ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _Environment;

};

/**
 * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
 */
class EnvironmentRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnvironmentRegister ();

    /**
     * Copy constructor
     */
    inline  EnvironmentRegister (const EnvironmentRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~EnvironmentRegister();

    /**
     * Assignment operator
     */
    inline EnvironmentRegister& operator = (const EnvironmentRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnvironmentRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnvironmentRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnvironmentRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnvironmentRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const EnvironmentRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ConfirmSpawn
 */
class ConfirmSpawnUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConfirmSpawnUpdate ();

    /**
     * Copy constructor
     */
    inline  ConfirmSpawnUpdate (const ConfirmSpawnUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConfirmSpawnUpdate (bool ConfirmSpawn_);

    /**
     * Destructor
     */
    inline virtual  ~ConfirmSpawnUpdate();

    /**
     * Assignment operator
     */
    inline ConfirmSpawnUpdate& operator = (const ConfirmSpawnUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConfirmSpawnUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConfirmSpawnUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConfirmSpawnUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConfirmSpawnUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConfirmSpawn"

    static const int kConfirmSpawn = 0;

    /**
     * Clears the field "ConfirmSpawn".
     *
     * The field will be set to its default value. The hasConfirmSpawn()
     * method will return false.
     */
    inline void clearConfirmSpawn();

    /**
     * Checks whether the field "ConfirmSpawn" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfirmSpawn()). Otherwise it will return false.
     */
    inline bool hasConfirmSpawn () const;

    /**
     * Returns the value of the member "ConfirmSpawn".
     *
     * ConfirmSpawn
     *
     * @return The value of the field "ConfirmSpawn"
     */
    inline bool getConfirmSpawn () const;

    /**
     * Sets the value of the member "ConfirmSpawn".
     *
     * ConfirmSpawn
     *
     * @param ConfirmSpawn The value which will be set
     */
    inline void setConfirmSpawn (bool ConfirmSpawn_);

    static const ConfirmSpawnUpdate &getDefaultInstance();

private:

    inline void set_has_ConfirmSpawn ();

    inline void clear_has_ConfirmSpawn ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _ConfirmSpawn;

};

/**
 * ConfirmSpawn
 */
class ConfirmSpawnRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConfirmSpawnRegister ();

    /**
     * Copy constructor
     */
    inline  ConfirmSpawnRegister (const ConfirmSpawnRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConfirmSpawnRegister();

    /**
     * Assignment operator
     */
    inline ConfirmSpawnRegister& operator = (const ConfirmSpawnRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConfirmSpawnRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConfirmSpawnRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConfirmSpawnRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConfirmSpawnRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConfirmSpawnRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ShowStatus
 */
class ShowStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  ShowStatusUpdate (const ShowStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ShowStatusUpdate (bool ShowStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ShowStatusUpdate();

    /**
     * Assignment operator
     */
    inline ShowStatusUpdate& operator = (const ShowStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ShowStatus"

    static const int kShowStatus = 0;

    /**
     * Clears the field "ShowStatus".
     *
     * The field will be set to its default value. The hasShowStatus()
     * method will return false.
     */
    inline void clearShowStatus();

    /**
     * Checks whether the field "ShowStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShowStatus()). Otherwise it will return false.
     */
    inline bool hasShowStatus () const;

    /**
     * Returns the value of the member "ShowStatus".
     *
     * ShowStatus
     *
     * @return The value of the field "ShowStatus"
     */
    inline bool getShowStatus () const;

    /**
     * Sets the value of the member "ShowStatus".
     *
     * ShowStatus
     *
     * @param ShowStatus The value which will be set
     */
    inline void setShowStatus (bool ShowStatus_);

    static const ShowStatusUpdate &getDefaultInstance();

private:

    inline void set_has_ShowStatus ();

    inline void clear_has_ShowStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _ShowStatus;

};

/**
 * ShowStatus
 */
class ShowStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowStatusRegister ();

    /**
     * Copy constructor
     */
    inline  ShowStatusRegister (const ShowStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ShowStatusRegister();

    /**
     * Assignment operator
     */
    inline ShowStatusRegister& operator = (const ShowStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ShowStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
 */
class UnitPathUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitPathUpdate ();

    /**
     * Copy constructor
     */
    inline  UnitPathUpdate (const UnitPathUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UnitPathUpdate (const ::std::vector< ::std::string >& UnitPath_);

    /**
     * Destructor
     */
    inline virtual  ~UnitPathUpdate();

    /**
     * Assignment operator
     */
    inline UnitPathUpdate& operator = (const UnitPathUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitPathUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitPathUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitPathUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitPathUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UnitPath"

    static const int kUnitPath = 0;

    /**
     * Clears the field "UnitPath".
     *
     * The field will be set to its default value. The hasUnitPath()
     * method will return false.
     */
    inline void clearUnitPath();

    /**
     * Checks whether the field "UnitPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnitPath()). Otherwise it will return false.
     */
    inline bool hasUnitPath () const;

    /**
     * Returns the value of the member "UnitPath".
     *
     * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
     *
     * @return The value of the field "UnitPath"
     */
    inline const ::std::vector< ::std::string >& getUnitPath () const;

    /**
     * Retrieves the value of the field "UnitPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UnitPath".
     */
    inline ::std::vector< ::std::string >& getUnitPathMutable ();

    /**
     * Sets the value of the member "UnitPath".
     *
     * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
     *
     * @param UnitPath The value which will be set
     */
    inline void setUnitPath (const ::std::vector< ::std::string >& UnitPath_);

    static const UnitPathUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_UnitPath ();

    inline void clear_has_UnitPath ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _UnitPath;

};

/**
 * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
 */
class UnitPathRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitPathRegister ();

    /**
     * Copy constructor
     */
    inline  UnitPathRegister (const UnitPathRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UnitPathRegister();

    /**
     * Assignment operator
     */
    inline UnitPathRegister& operator = (const UnitPathRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitPathRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitPathRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitPathRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitPathRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UnitPathRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * DefaultStandardOutput
 */
class DefaultStandardOutputUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DefaultStandardOutputUpdate ();

    /**
     * Copy constructor
     */
    inline  DefaultStandardOutputUpdate (const DefaultStandardOutputUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DefaultStandardOutputUpdate (const ::std::string& DefaultStandardOutput_);

    /**
     * Destructor
     */
    inline virtual  ~DefaultStandardOutputUpdate();

    /**
     * Assignment operator
     */
    inline DefaultStandardOutputUpdate& operator = (const DefaultStandardOutputUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DefaultStandardOutputUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DefaultStandardOutputUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DefaultStandardOutputUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DefaultStandardOutputUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefaultStandardOutput"

    static const int kDefaultStandardOutput = 0;

    /**
     * Clears the field "DefaultStandardOutput".
     *
     * The field will be set to its default value. The hasDefaultStandardOutput()
     * method will return false.
     */
    inline void clearDefaultStandardOutput();

    /**
     * Checks whether the field "DefaultStandardOutput" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefaultStandardOutput()). Otherwise it will return false.
     */
    inline bool hasDefaultStandardOutput () const;

    /**
     * Returns the value of the member "DefaultStandardOutput".
     *
     * DefaultStandardOutput
     *
     * @return The value of the field "DefaultStandardOutput"
     */
    inline const ::std::string& getDefaultStandardOutput () const;

    /**
     * Retrieves the value of the field "DefaultStandardOutput" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DefaultStandardOutput".
     */
    inline ::std::string& getDefaultStandardOutputMutable ();

    /**
     * Sets the value of the member "DefaultStandardOutput".
     *
     * DefaultStandardOutput
     *
     * @param DefaultStandardOutput The value which will be set
     */
    inline void setDefaultStandardOutput (const ::std::string& DefaultStandardOutput_);

    /**
     * Sets the value of the member "DefaultStandardOutput".
     *
     * DefaultStandardOutput
     *
     * @param DefaultStandardOutput The value which will be set
     */
    inline void setDefaultStandardOutput (const char* DefaultStandardOutput_);

    /**
     * Sets the value of the member "DefaultStandardOutput".
     *
     * DefaultStandardOutput
     *
     * @param DefaultStandardOutput The value which will be set
     */
    inline void setDefaultStandardOutput (const char* value, size_t size);

    static const DefaultStandardOutputUpdate &getDefaultInstance();

private:

    inline void set_has_DefaultStandardOutput ();

    inline void clear_has_DefaultStandardOutput ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _DefaultStandardOutput;

};

/**
 * DefaultStandardOutput
 */
class DefaultStandardOutputRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DefaultStandardOutputRegister ();

    /**
     * Copy constructor
     */
    inline  DefaultStandardOutputRegister (const DefaultStandardOutputRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DefaultStandardOutputRegister();

    /**
     * Assignment operator
     */
    inline DefaultStandardOutputRegister& operator = (const DefaultStandardOutputRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DefaultStandardOutputRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DefaultStandardOutputRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DefaultStandardOutputRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DefaultStandardOutputRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DefaultStandardOutputRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * DefaultStandardError
 */
class DefaultStandardErrorUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DefaultStandardErrorUpdate ();

    /**
     * Copy constructor
     */
    inline  DefaultStandardErrorUpdate (const DefaultStandardErrorUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DefaultStandardErrorUpdate (const ::std::string& DefaultStandardError_);

    /**
     * Destructor
     */
    inline virtual  ~DefaultStandardErrorUpdate();

    /**
     * Assignment operator
     */
    inline DefaultStandardErrorUpdate& operator = (const DefaultStandardErrorUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DefaultStandardErrorUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DefaultStandardErrorUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DefaultStandardErrorUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DefaultStandardErrorUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefaultStandardError"

    static const int kDefaultStandardError = 0;

    /**
     * Clears the field "DefaultStandardError".
     *
     * The field will be set to its default value. The hasDefaultStandardError()
     * method will return false.
     */
    inline void clearDefaultStandardError();

    /**
     * Checks whether the field "DefaultStandardError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefaultStandardError()). Otherwise it will return false.
     */
    inline bool hasDefaultStandardError () const;

    /**
     * Returns the value of the member "DefaultStandardError".
     *
     * DefaultStandardError
     *
     * @return The value of the field "DefaultStandardError"
     */
    inline const ::std::string& getDefaultStandardError () const;

    /**
     * Retrieves the value of the field "DefaultStandardError" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DefaultStandardError".
     */
    inline ::std::string& getDefaultStandardErrorMutable ();

    /**
     * Sets the value of the member "DefaultStandardError".
     *
     * DefaultStandardError
     *
     * @param DefaultStandardError The value which will be set
     */
    inline void setDefaultStandardError (const ::std::string& DefaultStandardError_);

    /**
     * Sets the value of the member "DefaultStandardError".
     *
     * DefaultStandardError
     *
     * @param DefaultStandardError The value which will be set
     */
    inline void setDefaultStandardError (const char* DefaultStandardError_);

    /**
     * Sets the value of the member "DefaultStandardError".
     *
     * DefaultStandardError
     *
     * @param DefaultStandardError The value which will be set
     */
    inline void setDefaultStandardError (const char* value, size_t size);

    static const DefaultStandardErrorUpdate &getDefaultInstance();

private:

    inline void set_has_DefaultStandardError ();

    inline void clear_has_DefaultStandardError ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _DefaultStandardError;

};

/**
 * DefaultStandardError
 */
class DefaultStandardErrorRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DefaultStandardErrorRegister ();

    /**
     * Copy constructor
     */
    inline  DefaultStandardErrorRegister (const DefaultStandardErrorRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DefaultStandardErrorRegister();

    /**
     * Assignment operator
     */
    inline DefaultStandardErrorRegister& operator = (const DefaultStandardErrorRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DefaultStandardErrorRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DefaultStandardErrorRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DefaultStandardErrorRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DefaultStandardErrorRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DefaultStandardErrorRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * RuntimeWatchdogUSec
 */
class RuntimeWatchdogUSecUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RuntimeWatchdogUSecUpdate ();

    /**
     * Copy constructor
     */
    inline  RuntimeWatchdogUSecUpdate (const RuntimeWatchdogUSecUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RuntimeWatchdogUSecUpdate (uint64 RuntimeWatchdogUSec_);

    /**
     * Destructor
     */
    inline virtual  ~RuntimeWatchdogUSecUpdate();

    /**
     * Assignment operator
     */
    inline RuntimeWatchdogUSecUpdate& operator = (const RuntimeWatchdogUSecUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RuntimeWatchdogUSecUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RuntimeWatchdogUSecUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RuntimeWatchdogUSecUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RuntimeWatchdogUSecUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RuntimeWatchdogUSec"

    static const int kRuntimeWatchdogUSec = 0;

    /**
     * Clears the field "RuntimeWatchdogUSec".
     *
     * The field will be set to its default value. The hasRuntimeWatchdogUSec()
     * method will return false.
     */
    inline void clearRuntimeWatchdogUSec();

    /**
     * Checks whether the field "RuntimeWatchdogUSec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRuntimeWatchdogUSec()). Otherwise it will return false.
     */
    inline bool hasRuntimeWatchdogUSec () const;

    /**
     * Returns the value of the member "RuntimeWatchdogUSec".
     *
     * RuntimeWatchdogUSec
     *
     * @return The value of the field "RuntimeWatchdogUSec"
     */
    inline uint64 getRuntimeWatchdogUSec () const;

    /**
     * Sets the value of the member "RuntimeWatchdogUSec".
     *
     * RuntimeWatchdogUSec
     *
     * @param RuntimeWatchdogUSec The value which will be set
     */
    inline void setRuntimeWatchdogUSec (uint64 RuntimeWatchdogUSec_);

    static const RuntimeWatchdogUSecUpdate &getDefaultInstance();

private:

    inline void set_has_RuntimeWatchdogUSec ();

    inline void clear_has_RuntimeWatchdogUSec ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _RuntimeWatchdogUSec;

};

/**
 * RuntimeWatchdogUSec
 */
class RuntimeWatchdogUSecRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RuntimeWatchdogUSecRegister ();

    /**
     * Copy constructor
     */
    inline  RuntimeWatchdogUSecRegister (const RuntimeWatchdogUSecRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RuntimeWatchdogUSecRegister();

    /**
     * Assignment operator
     */
    inline RuntimeWatchdogUSecRegister& operator = (const RuntimeWatchdogUSecRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RuntimeWatchdogUSecRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RuntimeWatchdogUSecRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RuntimeWatchdogUSecRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RuntimeWatchdogUSecRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RuntimeWatchdogUSecRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ShutdownWatchdogUSec
 */
class ShutdownWatchdogUSecUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShutdownWatchdogUSecUpdate ();

    /**
     * Copy constructor
     */
    inline  ShutdownWatchdogUSecUpdate (const ShutdownWatchdogUSecUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ShutdownWatchdogUSecUpdate (uint64 ShutdownWatchdogUSec_);

    /**
     * Destructor
     */
    inline virtual  ~ShutdownWatchdogUSecUpdate();

    /**
     * Assignment operator
     */
    inline ShutdownWatchdogUSecUpdate& operator = (const ShutdownWatchdogUSecUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShutdownWatchdogUSecUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShutdownWatchdogUSecUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShutdownWatchdogUSecUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShutdownWatchdogUSecUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ShutdownWatchdogUSec"

    static const int kShutdownWatchdogUSec = 0;

    /**
     * Clears the field "ShutdownWatchdogUSec".
     *
     * The field will be set to its default value. The hasShutdownWatchdogUSec()
     * method will return false.
     */
    inline void clearShutdownWatchdogUSec();

    /**
     * Checks whether the field "ShutdownWatchdogUSec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShutdownWatchdogUSec()). Otherwise it will return false.
     */
    inline bool hasShutdownWatchdogUSec () const;

    /**
     * Returns the value of the member "ShutdownWatchdogUSec".
     *
     * ShutdownWatchdogUSec
     *
     * @return The value of the field "ShutdownWatchdogUSec"
     */
    inline uint64 getShutdownWatchdogUSec () const;

    /**
     * Sets the value of the member "ShutdownWatchdogUSec".
     *
     * ShutdownWatchdogUSec
     *
     * @param ShutdownWatchdogUSec The value which will be set
     */
    inline void setShutdownWatchdogUSec (uint64 ShutdownWatchdogUSec_);

    static const ShutdownWatchdogUSecUpdate &getDefaultInstance();

private:

    inline void set_has_ShutdownWatchdogUSec ();

    inline void clear_has_ShutdownWatchdogUSec ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _ShutdownWatchdogUSec;

};

/**
 * ShutdownWatchdogUSec
 */
class ShutdownWatchdogUSecRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShutdownWatchdogUSecRegister ();

    /**
     * Copy constructor
     */
    inline  ShutdownWatchdogUSecRegister (const ShutdownWatchdogUSecRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ShutdownWatchdogUSecRegister();

    /**
     * Assignment operator
     */
    inline ShutdownWatchdogUSecRegister& operator = (const ShutdownWatchdogUSecRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShutdownWatchdogUSecRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShutdownWatchdogUSecRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShutdownWatchdogUSecRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShutdownWatchdogUSecRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ShutdownWatchdogUSecRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * ControlGroup
 */
class ControlGroupUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ControlGroupUpdate ();

    /**
     * Copy constructor
     */
    inline  ControlGroupUpdate (const ControlGroupUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ControlGroupUpdate (const ::std::string& ControlGroup_);

    /**
     * Destructor
     */
    inline virtual  ~ControlGroupUpdate();

    /**
     * Assignment operator
     */
    inline ControlGroupUpdate& operator = (const ControlGroupUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ControlGroupUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ControlGroupUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ControlGroupUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ControlGroupUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ControlGroup"

    static const int kControlGroup = 0;

    /**
     * Clears the field "ControlGroup".
     *
     * The field will be set to its default value. The hasControlGroup()
     * method will return false.
     */
    inline void clearControlGroup();

    /**
     * Checks whether the field "ControlGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setControlGroup()). Otherwise it will return false.
     */
    inline bool hasControlGroup () const;

    /**
     * Returns the value of the member "ControlGroup".
     *
     * ControlGroup
     *
     * @return The value of the field "ControlGroup"
     */
    inline const ::std::string& getControlGroup () const;

    /**
     * Retrieves the value of the field "ControlGroup" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ControlGroup".
     */
    inline ::std::string& getControlGroupMutable ();

    /**
     * Sets the value of the member "ControlGroup".
     *
     * ControlGroup
     *
     * @param ControlGroup The value which will be set
     */
    inline void setControlGroup (const ::std::string& ControlGroup_);

    /**
     * Sets the value of the member "ControlGroup".
     *
     * ControlGroup
     *
     * @param ControlGroup The value which will be set
     */
    inline void setControlGroup (const char* ControlGroup_);

    /**
     * Sets the value of the member "ControlGroup".
     *
     * ControlGroup
     *
     * @param ControlGroup The value which will be set
     */
    inline void setControlGroup (const char* value, size_t size);

    static const ControlGroupUpdate &getDefaultInstance();

private:

    inline void set_has_ControlGroup ();

    inline void clear_has_ControlGroup ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _ControlGroup;

};

/**
 * ControlGroup
 */
class ControlGroupRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ControlGroupRegister ();

    /**
     * Copy constructor
     */
    inline  ControlGroupRegister (const ControlGroupRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ControlGroupRegister();

    /**
     * Assignment operator
     */
    inline ControlGroupRegister& operator = (const ControlGroupRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ControlGroupRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ControlGroupRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ControlGroupRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ControlGroupRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ControlGroupRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * SystemState
 */
class SystemStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemStateUpdate ();

    /**
     * Copy constructor
     */
    inline  SystemStateUpdate (const SystemStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SystemStateUpdate (const ::std::string& SystemState_);

    /**
     * Destructor
     */
    inline virtual  ~SystemStateUpdate();

    /**
     * Assignment operator
     */
    inline SystemStateUpdate& operator = (const SystemStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SystemState"

    static const int kSystemState = 0;

    /**
     * Clears the field "SystemState".
     *
     * The field will be set to its default value. The hasSystemState()
     * method will return false.
     */
    inline void clearSystemState();

    /**
     * Checks whether the field "SystemState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemState()). Otherwise it will return false.
     */
    inline bool hasSystemState () const;

    /**
     * Returns the value of the member "SystemState".
     *
     * SystemState
     *
     * @return The value of the field "SystemState"
     */
    inline const ::std::string& getSystemState () const;

    /**
     * Retrieves the value of the field "SystemState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SystemState".
     */
    inline ::std::string& getSystemStateMutable ();

    /**
     * Sets the value of the member "SystemState".
     *
     * SystemState
     *
     * @param SystemState The value which will be set
     */
    inline void setSystemState (const ::std::string& SystemState_);

    /**
     * Sets the value of the member "SystemState".
     *
     * SystemState
     *
     * @param SystemState The value which will be set
     */
    inline void setSystemState (const char* SystemState_);

    /**
     * Sets the value of the member "SystemState".
     *
     * SystemState
     *
     * @param SystemState The value which will be set
     */
    inline void setSystemState (const char* value, size_t size);

    static const SystemStateUpdate &getDefaultInstance();

private:

    inline void set_has_SystemState ();

    inline void clear_has_SystemState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _SystemState;

};

/**
 * SystemState
 */
class SystemStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemStateRegister ();

    /**
     * Copy constructor
     */
    inline  SystemStateRegister (const SystemStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SystemStateRegister();

    /**
     * Assignment operator
     */
    inline SystemStateRegister& operator = (const SystemStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SystemStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * This signal is sent out each time a new unit is loaded.
 * 	    Note that this has little to do with whether a unit is available on disk or not,
 * 	    and simply reflects the units that are currently loaded into memory.
 * 	    The signals take two parameters: the primary unit name and the object path.
 */
class UnitNewSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitNewSignal ();

    /**
     * Copy constructor
     */
    inline  UnitNewSignal (const UnitNewSignal &rhs);

    /**
     * All fields constructor
     */
    inline  UnitNewSignal (const ::std::string& id_, const ::std::string& unit_);

    /**
     * Destructor
     */
    inline virtual  ~UnitNewSignal();

    /**
     * Assignment operator
     */
    inline UnitNewSignal& operator = (const UnitNewSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitNewSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitNewSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitNewSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitNewSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "id"

    static const int kId = 0;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "id"
     */
    inline const ::std::string& getId () const;

    /**
     * Retrieves the value of the field "id" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "id".
     */
    inline ::std::string& getIdMutable ();

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (const ::std::string& id_);

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (const char* id_);

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (const char* value, size_t size);

    // API of field "unit"

    static const int kUnit = 1;

    /**
     * Clears the field "unit".
     *
     * The field will be set to its default value. The hasUnit()
     * method will return false.
     */
    inline void clearUnit();

    /**
     * Checks whether the field "unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnit()). Otherwise it will return false.
     */
    inline bool hasUnit () const;

    /**
     * Returns the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unit"
     */
    inline const ::std::string& getUnit () const;

    /**
     * Retrieves the value of the field "unit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unit".
     */
    inline ::std::string& getUnitMutable ();

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const ::std::string& unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* value, size_t size);

    static const UnitNewSignal &getDefaultInstance();

private:

    inline void set_has_id ();

    inline void clear_has_id ();

    inline void set_has_unit ();

    inline void clear_has_unit ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _id;

    ::std::string _unit;

};

/**
 * UnitRemoved()
 */
class UnitRemovedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitRemovedSignal ();

    /**
     * Copy constructor
     */
    inline  UnitRemovedSignal (const UnitRemovedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  UnitRemovedSignal (const ::std::string& id_, const ::std::string& unit_);

    /**
     * Destructor
     */
    inline virtual  ~UnitRemovedSignal();

    /**
     * Assignment operator
     */
    inline UnitRemovedSignal& operator = (const UnitRemovedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitRemovedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitRemovedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitRemovedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitRemovedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "id"

    static const int kId = 0;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "id"
     */
    inline const ::std::string& getId () const;

    /**
     * Retrieves the value of the field "id" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "id".
     */
    inline ::std::string& getIdMutable ();

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (const ::std::string& id_);

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (const char* id_);

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (const char* value, size_t size);

    // API of field "unit"

    static const int kUnit = 1;

    /**
     * Clears the field "unit".
     *
     * The field will be set to its default value. The hasUnit()
     * method will return false.
     */
    inline void clearUnit();

    /**
     * Checks whether the field "unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnit()). Otherwise it will return false.
     */
    inline bool hasUnit () const;

    /**
     * Returns the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unit"
     */
    inline const ::std::string& getUnit () const;

    /**
     * Retrieves the value of the field "unit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unit".
     */
    inline ::std::string& getUnitMutable ();

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const ::std::string& unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* value, size_t size);

    static const UnitRemovedSignal &getDefaultInstance();

private:

    inline void set_has_id ();

    inline void clear_has_id ();

    inline void set_has_unit ();

    inline void clear_has_unit ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _id;

    ::std::string _unit;

};

/**
 * JobNew() and JobRemoved() are sent out each time a new job is queued or dequeued. Both signals take the numeric job ID, the bus path
 * 		and the primary unit name for this job as argument. JobRemoved() also includes a result string, being one of done, canceled, timeout, failed, dependency,
 * 		skipped. done indicates successful execution of a job. canceled indicates that a job has been canceled (via CancelJob() above) before it finished execution
 * 		(this doesn't necessarily mean though that the job operation is actually cancelled too, see above). timeout indicates that the job timeout was reached.
 * 		failed indicates that the job failed. dependency indicates that a job this job has been depending on failed and the job hence has been removed too.
 * 		skipped indicates that a job was skipped because it didn't apply to the units current state.
 */
class JobNewSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JobNewSignal ();

    /**
     * Copy constructor
     */
    inline  JobNewSignal (const JobNewSignal &rhs);

    /**
     * All fields constructor
     */
    inline  JobNewSignal (uint32 id_, const ::std::string& job_, const ::std::string& unit_);

    /**
     * Destructor
     */
    inline virtual  ~JobNewSignal();

    /**
     * Assignment operator
     */
    inline JobNewSignal& operator = (const JobNewSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JobNewSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JobNewSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JobNewSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JobNewSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "id"

    static const int kId = 0;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "id"
     */
    inline uint32 getId () const;

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (uint32 id_);

    // API of field "job"

    static const int kJob = 1;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    // API of field "unit"

    static const int kUnit = 2;

    /**
     * Clears the field "unit".
     *
     * The field will be set to its default value. The hasUnit()
     * method will return false.
     */
    inline void clearUnit();

    /**
     * Checks whether the field "unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnit()). Otherwise it will return false.
     */
    inline bool hasUnit () const;

    /**
     * Returns the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unit"
     */
    inline const ::std::string& getUnit () const;

    /**
     * Retrieves the value of the field "unit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unit".
     */
    inline ::std::string& getUnitMutable ();

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const ::std::string& unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* value, size_t size);

    static const JobNewSignal &getDefaultInstance();

private:

    inline void set_has_id ();

    inline void clear_has_id ();

    inline void set_has_job ();

    inline void clear_has_job ();

    inline void set_has_unit ();

    inline void clear_has_unit ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _id;

    ::std::string _job;

    ::std::string _unit;

};

/**
 * JobRemoved()
 */
class JobRemovedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JobRemovedSignal ();

    /**
     * Copy constructor
     */
    inline  JobRemovedSignal (const JobRemovedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  JobRemovedSignal (uint32 id_, const ::std::string& job_, const ::std::string& unit_, const ::std::string& result_);

    /**
     * Destructor
     */
    inline virtual  ~JobRemovedSignal();

    /**
     * Assignment operator
     */
    inline JobRemovedSignal& operator = (const JobRemovedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JobRemovedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JobRemovedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JobRemovedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JobRemovedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "id"

    static const int kId = 0;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "id"
     */
    inline uint32 getId () const;

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (uint32 id_);

    // API of field "job"

    static const int kJob = 1;

    /**
     * Clears the field "job".
     *
     * The field will be set to its default value. The hasJob()
     * method will return false.
     */
    inline void clearJob();

    /**
     * Checks whether the field "job" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJob()). Otherwise it will return false.
     */
    inline bool hasJob () const;

    /**
     * Returns the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @return The value of the field "job"
     */
    inline const ::std::string& getJob () const;

    /**
     * Retrieves the value of the field "job" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "job".
     */
    inline ::std::string& getJobMutable ();

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const ::std::string& job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* job_);

    /**
     * Sets the value of the member "job".
     *
     * If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param job The value which will be set
     */
    inline void setJob (const char* value, size_t size);

    // API of field "unit"

    static const int kUnit = 2;

    /**
     * Clears the field "unit".
     *
     * The field will be set to its default value. The hasUnit()
     * method will return false.
     */
    inline void clearUnit();

    /**
     * Checks whether the field "unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnit()). Otherwise it will return false.
     */
    inline bool hasUnit () const;

    /**
     * Returns the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unit"
     */
    inline const ::std::string& getUnit () const;

    /**
     * Retrieves the value of the field "unit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unit".
     */
    inline ::std::string& getUnitMutable ();

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const ::std::string& unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* unit_);

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (const char* value, size_t size);

    // API of field "result"

    static const int kResult = 3;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline const ::std::string& getResult () const;

    /**
     * Retrieves the value of the field "result" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "result".
     */
    inline ::std::string& getResultMutable ();

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (const ::std::string& result_);

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (const char* result_);

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (const char* value, size_t size);

    static const JobRemovedSignal &getDefaultInstance();

private:

    inline void set_has_id ();

    inline void clear_has_id ();

    inline void set_has_job ();

    inline void clear_has_job ();

    inline void set_has_unit ();

    inline void clear_has_unit ();

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _id;

    ::std::string _job;

    ::std::string _unit;

    ::std::string _result;

};

/**
 * StartupFinished() is sent out when startup finished. It carries six usec timespan values each indicating how much boot time has been spent
 * 		in the firmware (if known), in the boot loader (if known), in the kernel initialization phase, in the initrd (if known),
 * 		in userspace and in total. These values may also be calculated from the FirmwareTimestampMonotonic, LoaderTimestampMonotonic,
 * 		InitRDTimestampMonotonic, UserspaceTimestampMonotonic, FinishTimestampMonotonic properties (see below).
 */
class StartupFinishedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupFinishedSignal ();

    /**
     * Copy constructor
     */
    inline  StartupFinishedSignal (const StartupFinishedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  StartupFinishedSignal (uint64 firmware_, uint64 loader_, uint64 kernel_, uint64 initrd_, uint64 userspace_, uint64 total_);

    /**
     * Destructor
     */
    inline virtual  ~StartupFinishedSignal();

    /**
     * Assignment operator
     */
    inline StartupFinishedSignal& operator = (const StartupFinishedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupFinishedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupFinishedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupFinishedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupFinishedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "firmware"

    static const int kFirmware = 0;

    /**
     * Clears the field "firmware".
     *
     * The field will be set to its default value. The hasFirmware()
     * method will return false.
     */
    inline void clearFirmware();

    /**
     * Checks whether the field "firmware" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFirmware()). Otherwise it will return false.
     */
    inline bool hasFirmware () const;

    /**
     * Returns the value of the member "firmware".
     *
     * If the meaning of "firmware" isn't clear, then there should be a description here.
     *
     * @return The value of the field "firmware"
     */
    inline uint64 getFirmware () const;

    /**
     * Sets the value of the member "firmware".
     *
     * If the meaning of "firmware" isn't clear, then there should be a description here.
     *
     * @param firmware The value which will be set
     */
    inline void setFirmware (uint64 firmware_);

    // API of field "loader"

    static const int kLoader = 1;

    /**
     * Clears the field "loader".
     *
     * The field will be set to its default value. The hasLoader()
     * method will return false.
     */
    inline void clearLoader();

    /**
     * Checks whether the field "loader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoader()). Otherwise it will return false.
     */
    inline bool hasLoader () const;

    /**
     * Returns the value of the member "loader".
     *
     * If the meaning of "loader" isn't clear, then there should be a description here.
     *
     * @return The value of the field "loader"
     */
    inline uint64 getLoader () const;

    /**
     * Sets the value of the member "loader".
     *
     * If the meaning of "loader" isn't clear, then there should be a description here.
     *
     * @param loader The value which will be set
     */
    inline void setLoader (uint64 loader_);

    // API of field "kernel"

    static const int kKernel = 2;

    /**
     * Clears the field "kernel".
     *
     * The field will be set to its default value. The hasKernel()
     * method will return false.
     */
    inline void clearKernel();

    /**
     * Checks whether the field "kernel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKernel()). Otherwise it will return false.
     */
    inline bool hasKernel () const;

    /**
     * Returns the value of the member "kernel".
     *
     * If the meaning of "kernel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "kernel"
     */
    inline uint64 getKernel () const;

    /**
     * Sets the value of the member "kernel".
     *
     * If the meaning of "kernel" isn't clear, then there should be a description here.
     *
     * @param kernel The value which will be set
     */
    inline void setKernel (uint64 kernel_);

    // API of field "initrd"

    static const int kInitrd = 3;

    /**
     * Clears the field "initrd".
     *
     * The field will be set to its default value. The hasInitrd()
     * method will return false.
     */
    inline void clearInitrd();

    /**
     * Checks whether the field "initrd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInitrd()). Otherwise it will return false.
     */
    inline bool hasInitrd () const;

    /**
     * Returns the value of the member "initrd".
     *
     * If the meaning of "initrd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "initrd"
     */
    inline uint64 getInitrd () const;

    /**
     * Sets the value of the member "initrd".
     *
     * If the meaning of "initrd" isn't clear, then there should be a description here.
     *
     * @param initrd The value which will be set
     */
    inline void setInitrd (uint64 initrd_);

    // API of field "userspace"

    static const int kUserspace = 4;

    /**
     * Clears the field "userspace".
     *
     * The field will be set to its default value. The hasUserspace()
     * method will return false.
     */
    inline void clearUserspace();

    /**
     * Checks whether the field "userspace" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserspace()). Otherwise it will return false.
     */
    inline bool hasUserspace () const;

    /**
     * Returns the value of the member "userspace".
     *
     * If the meaning of "userspace" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userspace"
     */
    inline uint64 getUserspace () const;

    /**
     * Sets the value of the member "userspace".
     *
     * If the meaning of "userspace" isn't clear, then there should be a description here.
     *
     * @param userspace The value which will be set
     */
    inline void setUserspace (uint64 userspace_);

    // API of field "total"

    static const int kTotal = 5;

    /**
     * Clears the field "total".
     *
     * The field will be set to its default value. The hasTotal()
     * method will return false.
     */
    inline void clearTotal();

    /**
     * Checks whether the field "total" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTotal()). Otherwise it will return false.
     */
    inline bool hasTotal () const;

    /**
     * Returns the value of the member "total".
     *
     * If the meaning of "total" isn't clear, then there should be a description here.
     *
     * @return The value of the field "total"
     */
    inline uint64 getTotal () const;

    /**
     * Sets the value of the member "total".
     *
     * If the meaning of "total" isn't clear, then there should be a description here.
     *
     * @param total The value which will be set
     */
    inline void setTotal (uint64 total_);

    static const StartupFinishedSignal &getDefaultInstance();

private:

    inline void set_has_firmware ();

    inline void clear_has_firmware ();

    inline void set_has_loader ();

    inline void clear_has_loader ();

    inline void set_has_kernel ();

    inline void clear_has_kernel ();

    inline void set_has_initrd ();

    inline void clear_has_initrd ();

    inline void set_has_userspace ();

    inline void clear_has_userspace ();

    inline void set_has_total ();

    inline void clear_has_total ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint64 _firmware;

    uint64 _loader;

    uint64 _kernel;

    uint64 _initrd;

    uint64 _userspace;

    uint64 _total;

};

/**
 * Reloading() is sent out immediately before a daemon reload is done (with the boolean parameter set to True)
 * 		and after a daemon reload is completed (with the boolean parameter set to False). This may be used by UIs to optimize UI updates.
 */
class ReloadingSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReloadingSignal ();

    /**
     * Copy constructor
     */
    inline  ReloadingSignal (const ReloadingSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ReloadingSignal (bool active_);

    /**
     * Destructor
     */
    inline virtual  ~ReloadingSignal();

    /**
     * Assignment operator
     */
    inline ReloadingSignal& operator = (const ReloadingSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReloadingSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReloadingSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReloadingSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReloadingSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "active"

    static const int kActive = 0;

    /**
     * Clears the field "active".
     *
     * The field will be set to its default value. The hasActive()
     * method will return false.
     */
    inline void clearActive();

    /**
     * Checks whether the field "active" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActive()). Otherwise it will return false.
     */
    inline bool hasActive () const;

    /**
     * Returns the value of the member "active".
     *
     * If the meaning of "active" isn't clear, then there should be a description here.
     *
     * @return The value of the field "active"
     */
    inline bool getActive () const;

    /**
     * Sets the value of the member "active".
     *
     * If the meaning of "active" isn't clear, then there should be a description here.
     *
     * @param active The value which will be set
     */
    inline void setActive (bool active_);

    static const ReloadingSignal &getDefaultInstance();

private:

    inline void set_has_active ();

    inline void clear_has_active ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _active;

};

inline  units::units ()  :
    _name (),
    _description (),
    _loadState (),
    _activeState (),
    _subState (),
    _follower (),
    _path (),
    _jobId (0u),
    _jobType (),
    _jobPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  units::units (const units &rhs)  :
    _name (),
    _description (),
    _loadState (),
    _activeState (),
    _subState (),
    _follower (),
    _path (),
    _jobId (0u),
    _jobType (),
    _jobPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  units::units (const ::std::string& name_, const ::std::string& description_, const ::std::string& loadState_, const ::std::string& activeState_, const ::std::string& subState_, const ::std::string& follower_, const ::std::string& path_, uint32 jobId_, const ::std::string& jobType_, const ::std::string& jobPath_)  :
    _name (name_),
    _description (description_),
    _loadState (loadState_),
    _activeState (activeState_),
    _subState (subState_),
    _follower (follower_),
    _path (path_),
    _jobId (jobId_),
    _jobType (jobType_),
    _jobPath (jobPath_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (description_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (loadState_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeState_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (subState_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (follower_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jobType_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jobPath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  units::~units() {
}

inline units& units::operator = (const units& rhs) {
    if( this != &rhs ) {
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasDescription()) {
            setDescription(rhs.getDescription());
        } else {
            clearDescription();
        }
        if (rhs.hasLoadState()) {
            setLoadState(rhs.getLoadState());
        } else {
            clearLoadState();
        }
        if (rhs.hasActiveState()) {
            setActiveState(rhs.getActiveState());
        } else {
            clearActiveState();
        }
        if (rhs.hasSubState()) {
            setSubState(rhs.getSubState());
        } else {
            clearSubState();
        }
        if (rhs.hasFollower()) {
            setFollower(rhs.getFollower());
        } else {
            clearFollower();
        }
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
        if (rhs.hasJobId()) {
            setJobId(rhs.getJobId());
        } else {
            clearJobId();
        }
        if (rhs.hasJobType()) {
            setJobType(rhs.getJobType());
        } else {
            clearJobType();
        }
        if (rhs.hasJobPath()) {
            setJobPath(rhs.getJobPath());
        } else {
            clearJobPath();
        }
    }
    return *this;
}

inline bool units::operator == (const units& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasDescription() && !rhs.hasDescription()) || getDescription() == rhs.getDescription()) &&
        ((!hasLoadState() && !rhs.hasLoadState()) || getLoadState() == rhs.getLoadState()) &&
        ((!hasActiveState() && !rhs.hasActiveState()) || getActiveState() == rhs.getActiveState()) &&
        ((!hasSubState() && !rhs.hasSubState()) || getSubState() == rhs.getSubState()) &&
        ((!hasFollower() && !rhs.hasFollower()) || getFollower() == rhs.getFollower()) &&
        ((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()) &&
        ((!hasJobId() && !rhs.hasJobId()) || getJobId() == rhs.getJobId()) &&
        ((!hasJobType() && !rhs.hasJobType()) || getJobType() == rhs.getJobType()) &&
        ((!hasJobPath() && !rhs.hasJobPath()) || getJobPath() == rhs.getJobPath()));
}

inline bool units::operator != (const units& rhs) const {
    return ! (*this == rhs);
}

inline bool units::operator < (const units& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasDescription() || rhs.hasDescription()) {
        if (getDescription() < rhs.getDescription()) return true;
        if (getDescription() > rhs.getDescription()) return false;
    }
    if (hasLoadState() || rhs.hasLoadState()) {
        if (getLoadState() < rhs.getLoadState()) return true;
        if (getLoadState() > rhs.getLoadState()) return false;
    }
    if (hasActiveState() || rhs.hasActiveState()) {
        if (getActiveState() < rhs.getActiveState()) return true;
        if (getActiveState() > rhs.getActiveState()) return false;
    }
    if (hasSubState() || rhs.hasSubState()) {
        if (getSubState() < rhs.getSubState()) return true;
        if (getSubState() > rhs.getSubState()) return false;
    }
    if (hasFollower() || rhs.hasFollower()) {
        if (getFollower() < rhs.getFollower()) return true;
        if (getFollower() > rhs.getFollower()) return false;
    }
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    if (hasJobId() || rhs.hasJobId()) {
        if (getJobId() < rhs.getJobId()) return true;
        if (getJobId() > rhs.getJobId()) return false;
    }
    if (hasJobType() || rhs.hasJobType()) {
        if (getJobType() < rhs.getJobType()) return true;
        if (getJobType() > rhs.getJobType()) return false;
    }
    if (hasJobPath() || rhs.hasJobPath()) {
        if (getJobPath() < rhs.getJobPath()) return true;
        if (getJobPath() > rhs.getJobPath()) return false;
    }
    return false;
}

inline bool units::operator > (const units& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void units::clear() {
    clearName();
    clearDescription();
    clearLoadState();
    clearActiveState();
    clearSubState();
    clearFollower();
    clearPath();
    clearJobId();
    clearJobType();
    clearJobPath();
}

inline void units::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool units::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& units::getName () const {
    return _name;
}

inline ::std::string& units::getNameMutable () {
    set_has_name();
    return _name;
}

inline void units::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void units::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void units::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void units::clearDescription() {
    if (hasDescription()) {
         clear_has_description();
        _description.clear();
     }
}

inline bool units::hasDescription () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& units::getDescription () const {
    return _description;
}

inline ::std::string& units::getDescriptionMutable () {
    set_has_description();
    return _description;
}

inline void units::setDescription (const ::std::string& description_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (description_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_description();
    this->_description = description_;
}

inline void units::setDescription (const char* description_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (description_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_description();
    this->_description.assign(description_);
}

inline void units::setDescription (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_description();
    this->_description.assign(value, size);
}

inline void units::clearLoadState() {
    if (hasLoadState()) {
         clear_has_loadState();
        _loadState.clear();
     }
}

inline bool units::hasLoadState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& units::getLoadState () const {
    return _loadState;
}

inline ::std::string& units::getLoadStateMutable () {
    set_has_loadState();
    return _loadState;
}

inline void units::setLoadState (const ::std::string& loadState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (loadState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_loadState();
    this->_loadState = loadState_;
}

inline void units::setLoadState (const char* loadState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (loadState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_loadState();
    this->_loadState.assign(loadState_);
}

inline void units::setLoadState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_loadState();
    this->_loadState.assign(value, size);
}

inline void units::clearActiveState() {
    if (hasActiveState()) {
         clear_has_activeState();
        _activeState.clear();
     }
}

inline bool units::hasActiveState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& units::getActiveState () const {
    return _activeState;
}

inline ::std::string& units::getActiveStateMutable () {
    set_has_activeState();
    return _activeState;
}

inline void units::setActiveState (const ::std::string& activeState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeState();
    this->_activeState = activeState_;
}

inline void units::setActiveState (const char* activeState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeState();
    this->_activeState.assign(activeState_);
}

inline void units::setActiveState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeState();
    this->_activeState.assign(value, size);
}

inline void units::clearSubState() {
    if (hasSubState()) {
         clear_has_subState();
        _subState.clear();
     }
}

inline bool units::hasSubState () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& units::getSubState () const {
    return _subState;
}

inline ::std::string& units::getSubStateMutable () {
    set_has_subState();
    return _subState;
}

inline void units::setSubState (const ::std::string& subState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (subState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_subState();
    this->_subState = subState_;
}

inline void units::setSubState (const char* subState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (subState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_subState();
    this->_subState.assign(subState_);
}

inline void units::setSubState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_subState();
    this->_subState.assign(value, size);
}

inline void units::clearFollower() {
    if (hasFollower()) {
         clear_has_follower();
        _follower.clear();
     }
}

inline bool units::hasFollower () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& units::getFollower () const {
    return _follower;
}

inline ::std::string& units::getFollowerMutable () {
    set_has_follower();
    return _follower;
}

inline void units::setFollower (const ::std::string& follower_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (follower_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_follower();
    this->_follower = follower_;
}

inline void units::setFollower (const char* follower_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (follower_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_follower();
    this->_follower.assign(follower_);
}

inline void units::setFollower (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_follower();
    this->_follower.assign(value, size);
}

inline void units::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool units::hasPath () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& units::getPath () const {
    return _path;
}

inline ::std::string& units::getPathMutable () {
    set_has_path();
    return _path;
}

inline void units::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void units::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void units::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void units::clearJobId() {
    if (hasJobId()) {
         clear_has_jobId();
        _jobId = 0u;
     }
}

inline bool units::hasJobId () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 units::getJobId () const {
    return _jobId;
}

inline void units::setJobId (uint32 jobId_) {
    set_has_jobId();
    this->_jobId = jobId_;
}

inline void units::clearJobType() {
    if (hasJobType()) {
         clear_has_jobType();
        _jobType.clear();
     }
}

inline bool units::hasJobType () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& units::getJobType () const {
    return _jobType;
}

inline ::std::string& units::getJobTypeMutable () {
    set_has_jobType();
    return _jobType;
}

inline void units::setJobType (const ::std::string& jobType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jobType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jobType();
    this->_jobType = jobType_;
}

inline void units::setJobType (const char* jobType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jobType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jobType();
    this->_jobType.assign(jobType_);
}

inline void units::setJobType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jobType();
    this->_jobType.assign(value, size);
}

inline void units::clearJobPath() {
    if (hasJobPath()) {
         clear_has_jobPath();
        _jobPath.clear();
     }
}

inline bool units::hasJobPath () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& units::getJobPath () const {
    return _jobPath;
}

inline ::std::string& units::getJobPathMutable () {
    set_has_jobPath();
    return _jobPath;
}

inline void units::setJobPath (const ::std::string& jobPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jobPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jobPath();
    this->_jobPath = jobPath_;
}

inline void units::setJobPath (const char* jobPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jobPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jobPath();
    this->_jobPath.assign(jobPath_);
}

inline void units::setJobPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jobPath();
    this->_jobPath.assign(value, size);
}

inline void units::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void units::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void units::set_has_description () {
    _has_bits_[0] |= 1u << 1;
}

inline void units::clear_has_description () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void units::set_has_loadState () {
    _has_bits_[0] |= 1u << 2;
}

inline void units::clear_has_loadState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void units::set_has_activeState () {
    _has_bits_[0] |= 1u << 3;
}

inline void units::clear_has_activeState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void units::set_has_subState () {
    _has_bits_[0] |= 1u << 4;
}

inline void units::clear_has_subState () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void units::set_has_follower () {
    _has_bits_[0] |= 1u << 5;
}

inline void units::clear_has_follower () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void units::set_has_path () {
    _has_bits_[0] |= 1u << 6;
}

inline void units::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void units::set_has_jobId () {
    _has_bits_[0] |= 1u << 7;
}

inline void units::clear_has_jobId () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void units::set_has_jobType () {
    _has_bits_[0] |= 1u << 8;
}

inline void units::clear_has_jobType () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void units::set_has_jobPath () {
    _has_bits_[0] |= 1u << 9;
}

inline void units::clear_has_jobPath () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline  jobs::jobs ()  :
    _jobId (0u),
    _primaryUnit (),
    _type (),
    _state (),
    _path (),
    _unitPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  jobs::jobs (const jobs &rhs)  :
    _jobId (0u),
    _primaryUnit (),
    _type (),
    _state (),
    _path (),
    _unitPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  jobs::jobs (uint32 jobId_, const ::std::string& primaryUnit_, const ::std::string& type_, const ::std::string& state_, const ::std::string& path_, const ::std::string& unitPath_)  :
    _jobId (jobId_),
    _primaryUnit (primaryUnit_),
    _type (type_),
    _state (state_),
    _path (path_),
    _unitPath (unitPath_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (primaryUnit_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (type_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (state_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unitPath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  jobs::~jobs() {
}

inline jobs& jobs::operator = (const jobs& rhs) {
    if( this != &rhs ) {
        if (rhs.hasJobId()) {
            setJobId(rhs.getJobId());
        } else {
            clearJobId();
        }
        if (rhs.hasPrimaryUnit()) {
            setPrimaryUnit(rhs.getPrimaryUnit());
        } else {
            clearPrimaryUnit();
        }
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
        if (rhs.hasUnitPath()) {
            setUnitPath(rhs.getUnitPath());
        } else {
            clearUnitPath();
        }
    }
    return *this;
}

inline bool jobs::operator == (const jobs& rhs) const {
    return (((!hasJobId() && !rhs.hasJobId()) || getJobId() == rhs.getJobId()) &&
        ((!hasPrimaryUnit() && !rhs.hasPrimaryUnit()) || getPrimaryUnit() == rhs.getPrimaryUnit()) &&
        ((!hasType() && !rhs.hasType()) || getType() == rhs.getType()) &&
        ((!hasState() && !rhs.hasState()) || getState() == rhs.getState()) &&
        ((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()) &&
        ((!hasUnitPath() && !rhs.hasUnitPath()) || getUnitPath() == rhs.getUnitPath()));
}

inline bool jobs::operator != (const jobs& rhs) const {
    return ! (*this == rhs);
}

inline bool jobs::operator < (const jobs& rhs) const {
    if (hasJobId() || rhs.hasJobId()) {
        if (getJobId() < rhs.getJobId()) return true;
        if (getJobId() > rhs.getJobId()) return false;
    }
    if (hasPrimaryUnit() || rhs.hasPrimaryUnit()) {
        if (getPrimaryUnit() < rhs.getPrimaryUnit()) return true;
        if (getPrimaryUnit() > rhs.getPrimaryUnit()) return false;
    }
    if (hasType() || rhs.hasType()) {
        if (getType() < rhs.getType()) return true;
        if (getType() > rhs.getType()) return false;
    }
    if (hasState() || rhs.hasState()) {
        if (getState() < rhs.getState()) return true;
        if (getState() > rhs.getState()) return false;
    }
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    if (hasUnitPath() || rhs.hasUnitPath()) {
        if (getUnitPath() < rhs.getUnitPath()) return true;
        if (getUnitPath() > rhs.getUnitPath()) return false;
    }
    return false;
}

inline bool jobs::operator > (const jobs& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void jobs::clear() {
    clearJobId();
    clearPrimaryUnit();
    clearType();
    clearState();
    clearPath();
    clearUnitPath();
}

inline void jobs::clearJobId() {
    if (hasJobId()) {
         clear_has_jobId();
        _jobId = 0u;
     }
}

inline bool jobs::hasJobId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 jobs::getJobId () const {
    return _jobId;
}

inline void jobs::setJobId (uint32 jobId_) {
    set_has_jobId();
    this->_jobId = jobId_;
}

inline void jobs::clearPrimaryUnit() {
    if (hasPrimaryUnit()) {
         clear_has_primaryUnit();
        _primaryUnit.clear();
     }
}

inline bool jobs::hasPrimaryUnit () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& jobs::getPrimaryUnit () const {
    return _primaryUnit;
}

inline ::std::string& jobs::getPrimaryUnitMutable () {
    set_has_primaryUnit();
    return _primaryUnit;
}

inline void jobs::setPrimaryUnit (const ::std::string& primaryUnit_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (primaryUnit_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_primaryUnit();
    this->_primaryUnit = primaryUnit_;
}

inline void jobs::setPrimaryUnit (const char* primaryUnit_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (primaryUnit_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_primaryUnit();
    this->_primaryUnit.assign(primaryUnit_);
}

inline void jobs::setPrimaryUnit (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_primaryUnit();
    this->_primaryUnit.assign(value, size);
}

inline void jobs::clearType() {
    if (hasType()) {
         clear_has_type();
        _type.clear();
     }
}

inline bool jobs::hasType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& jobs::getType () const {
    return _type;
}

inline ::std::string& jobs::getTypeMutable () {
    set_has_type();
    return _type;
}

inline void jobs::setType (const ::std::string& type_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (type_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_type();
    this->_type = type_;
}

inline void jobs::setType (const char* type_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (type_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_type();
    this->_type.assign(type_);
}

inline void jobs::setType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_type();
    this->_type.assign(value, size);
}

inline void jobs::clearState() {
    if (hasState()) {
         clear_has_state();
        _state.clear();
     }
}

inline bool jobs::hasState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& jobs::getState () const {
    return _state;
}

inline ::std::string& jobs::getStateMutable () {
    set_has_state();
    return _state;
}

inline void jobs::setState (const ::std::string& state_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (state_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_state();
    this->_state = state_;
}

inline void jobs::setState (const char* state_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (state_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_state();
    this->_state.assign(state_);
}

inline void jobs::setState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_state();
    this->_state.assign(value, size);
}

inline void jobs::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool jobs::hasPath () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& jobs::getPath () const {
    return _path;
}

inline ::std::string& jobs::getPathMutable () {
    set_has_path();
    return _path;
}

inline void jobs::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void jobs::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void jobs::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void jobs::clearUnitPath() {
    if (hasUnitPath()) {
         clear_has_unitPath();
        _unitPath.clear();
     }
}

inline bool jobs::hasUnitPath () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& jobs::getUnitPath () const {
    return _unitPath;
}

inline ::std::string& jobs::getUnitPathMutable () {
    set_has_unitPath();
    return _unitPath;
}

inline void jobs::setUnitPath (const ::std::string& unitPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unitPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unitPath();
    this->_unitPath = unitPath_;
}

inline void jobs::setUnitPath (const char* unitPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unitPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unitPath();
    this->_unitPath.assign(unitPath_);
}

inline void jobs::setUnitPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unitPath();
    this->_unitPath.assign(value, size);
}

inline void jobs::set_has_jobId () {
    _has_bits_[0] |= 1u << 0;
}

inline void jobs::clear_has_jobId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void jobs::set_has_primaryUnit () {
    _has_bits_[0] |= 1u << 1;
}

inline void jobs::clear_has_primaryUnit () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void jobs::set_has_type () {
    _has_bits_[0] |= 1u << 2;
}

inline void jobs::clear_has_type () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void jobs::set_has_state () {
    _has_bits_[0] |= 1u << 3;
}

inline void jobs::clear_has_state () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void jobs::set_has_path () {
    _has_bits_[0] |= 1u << 4;
}

inline void jobs::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void jobs::set_has_unitPath () {
    _has_bits_[0] |= 1u << 5;
}

inline void jobs::clear_has_unitPath () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  files::files ()  :
    _unitName (),
    _enablement ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  files::files (const files &rhs)  :
    _unitName (),
    _enablement ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  files::files (const ::std::string& unitName_, const ::std::string& enablement_)  :
    _unitName (unitName_),
    _enablement (enablement_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unitName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (enablement_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  files::~files() {
}

inline files& files::operator = (const files& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUnitName()) {
            setUnitName(rhs.getUnitName());
        } else {
            clearUnitName();
        }
        if (rhs.hasEnablement()) {
            setEnablement(rhs.getEnablement());
        } else {
            clearEnablement();
        }
    }
    return *this;
}

inline bool files::operator == (const files& rhs) const {
    return (((!hasUnitName() && !rhs.hasUnitName()) || getUnitName() == rhs.getUnitName()) &&
        ((!hasEnablement() && !rhs.hasEnablement()) || getEnablement() == rhs.getEnablement()));
}

inline bool files::operator != (const files& rhs) const {
    return ! (*this == rhs);
}

inline bool files::operator < (const files& rhs) const {
    if (hasUnitName() || rhs.hasUnitName()) {
        if (getUnitName() < rhs.getUnitName()) return true;
        if (getUnitName() > rhs.getUnitName()) return false;
    }
    if (hasEnablement() || rhs.hasEnablement()) {
        if (getEnablement() < rhs.getEnablement()) return true;
        if (getEnablement() > rhs.getEnablement()) return false;
    }
    return false;
}

inline bool files::operator > (const files& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void files::clear() {
    clearUnitName();
    clearEnablement();
}

inline void files::clearUnitName() {
    if (hasUnitName()) {
         clear_has_unitName();
        _unitName.clear();
     }
}

inline bool files::hasUnitName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& files::getUnitName () const {
    return _unitName;
}

inline ::std::string& files::getUnitNameMutable () {
    set_has_unitName();
    return _unitName;
}

inline void files::setUnitName (const ::std::string& unitName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unitName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unitName();
    this->_unitName = unitName_;
}

inline void files::setUnitName (const char* unitName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unitName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unitName();
    this->_unitName.assign(unitName_);
}

inline void files::setUnitName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unitName();
    this->_unitName.assign(value, size);
}

inline void files::clearEnablement() {
    if (hasEnablement()) {
         clear_has_enablement();
        _enablement.clear();
     }
}

inline bool files::hasEnablement () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& files::getEnablement () const {
    return _enablement;
}

inline ::std::string& files::getEnablementMutable () {
    set_has_enablement();
    return _enablement;
}

inline void files::setEnablement (const ::std::string& enablement_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (enablement_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_enablement();
    this->_enablement = enablement_;
}

inline void files::setEnablement (const char* enablement_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (enablement_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_enablement();
    this->_enablement.assign(enablement_);
}

inline void files::setEnablement (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_enablement();
    this->_enablement.assign(value, size);
}

inline void files::set_has_unitName () {
    _has_bits_[0] |= 1u << 0;
}

inline void files::clear_has_unitName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void files::set_has_enablement () {
    _has_bits_[0] |= 1u << 1;
}

inline void files::clear_has_enablement () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  changes::changes ()  :
    _type (),
    _filename (),
    _destination ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  changes::changes (const changes &rhs)  :
    _type (),
    _filename (),
    _destination ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  changes::changes (const ::std::string& type_, const ::std::string& filename_, const ::std::string& destination_)  :
    _type (type_),
    _filename (filename_),
    _destination (destination_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (type_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (filename_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destination_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  changes::~changes() {
}

inline changes& changes::operator = (const changes& rhs) {
    if( this != &rhs ) {
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
        if (rhs.hasFilename()) {
            setFilename(rhs.getFilename());
        } else {
            clearFilename();
        }
        if (rhs.hasDestination()) {
            setDestination(rhs.getDestination());
        } else {
            clearDestination();
        }
    }
    return *this;
}

inline bool changes::operator == (const changes& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()) &&
        ((!hasFilename() && !rhs.hasFilename()) || getFilename() == rhs.getFilename()) &&
        ((!hasDestination() && !rhs.hasDestination()) || getDestination() == rhs.getDestination()));
}

inline bool changes::operator != (const changes& rhs) const {
    return ! (*this == rhs);
}

inline bool changes::operator < (const changes& rhs) const {
    if (hasType() || rhs.hasType()) {
        if (getType() < rhs.getType()) return true;
        if (getType() > rhs.getType()) return false;
    }
    if (hasFilename() || rhs.hasFilename()) {
        if (getFilename() < rhs.getFilename()) return true;
        if (getFilename() > rhs.getFilename()) return false;
    }
    if (hasDestination() || rhs.hasDestination()) {
        if (getDestination() < rhs.getDestination()) return true;
        if (getDestination() > rhs.getDestination()) return false;
    }
    return false;
}

inline bool changes::operator > (const changes& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void changes::clear() {
    clearType();
    clearFilename();
    clearDestination();
}

inline void changes::clearType() {
    if (hasType()) {
         clear_has_type();
        _type.clear();
     }
}

inline bool changes::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& changes::getType () const {
    return _type;
}

inline ::std::string& changes::getTypeMutable () {
    set_has_type();
    return _type;
}

inline void changes::setType (const ::std::string& type_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (type_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_type();
    this->_type = type_;
}

inline void changes::setType (const char* type_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (type_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_type();
    this->_type.assign(type_);
}

inline void changes::setType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_type();
    this->_type.assign(value, size);
}

inline void changes::clearFilename() {
    if (hasFilename()) {
         clear_has_filename();
        _filename.clear();
     }
}

inline bool changes::hasFilename () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& changes::getFilename () const {
    return _filename;
}

inline ::std::string& changes::getFilenameMutable () {
    set_has_filename();
    return _filename;
}

inline void changes::setFilename (const ::std::string& filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_filename();
    this->_filename = filename_;
}

inline void changes::setFilename (const char* filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_filename();
    this->_filename.assign(filename_);
}

inline void changes::setFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_filename();
    this->_filename.assign(value, size);
}

inline void changes::clearDestination() {
    if (hasDestination()) {
         clear_has_destination();
        _destination.clear();
     }
}

inline bool changes::hasDestination () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& changes::getDestination () const {
    return _destination;
}

inline ::std::string& changes::getDestinationMutable () {
    set_has_destination();
    return _destination;
}

inline void changes::setDestination (const ::std::string& destination_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destination_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destination();
    this->_destination = destination_;
}

inline void changes::setDestination (const char* destination_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destination_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destination();
    this->_destination.assign(destination_);
}

inline void changes::setDestination (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destination();
    this->_destination.assign(value, size);
}

inline void changes::set_has_type () {
    _has_bits_[0] |= 1u << 0;
}

inline void changes::clear_has_type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void changes::set_has_filename () {
    _has_bits_[0] |= 1u << 1;
}

inline void changes::clear_has_filename () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void changes::set_has_destination () {
    _has_bits_[0] |= 1u << 2;
}

inline void changes::clear_has_destination () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  property::property ()  :
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  property::property (const property &rhs)  :
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  property::property (const ::std::string& name_, const ::std::string& value_)  :
    _name (name_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  property::~property() {
}

inline property& property::operator = (const property& rhs) {
    if( this != &rhs ) {
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool property::operator == (const property& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool property::operator != (const property& rhs) const {
    return ! (*this == rhs);
}

inline bool property::operator < (const property& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline bool property::operator > (const property& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void property::clear() {
    clearName();
    clearValue();
}

inline void property::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool property::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& property::getName () const {
    return _name;
}

inline ::std::string& property::getNameMutable () {
    set_has_name();
    return _name;
}

inline void property::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void property::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void property::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void property::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value.clear();
     }
}

inline bool property::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& property::getValue () const {
    return _value;
}

inline ::std::string& property::getValueMutable () {
    set_has_value();
    return _value;
}

inline void property::setValue (const ::std::string& value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value = value_;
}

inline void property::setValue (const char* value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value.assign(value_);
}

inline void property::setValue (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value.assign(value, size);
}

inline void property::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void property::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void property::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void property::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  transientunitdata::transientunitdata ()  :
    _name (),
    _transientproperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  transientunitdata::transientunitdata (const transientunitdata &rhs)  :
    _name (),
    _transientproperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  transientunitdata::transientunitdata (const ::std::string& name_, const ::std::vector< property >& transientproperties_)  :
    _name (name_),
    _transientproperties (transientproperties_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  transientunitdata::~transientunitdata() {
}

inline transientunitdata& transientunitdata::operator = (const transientunitdata& rhs) {
    if( this != &rhs ) {
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasTransientproperties()) {
            setTransientproperties(rhs.getTransientproperties());
        } else {
            clearTransientproperties();
        }
    }
    return *this;
}

inline bool transientunitdata::operator == (const transientunitdata& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasTransientproperties() && !rhs.hasTransientproperties()) || getTransientproperties() == rhs.getTransientproperties()));
}

inline bool transientunitdata::operator != (const transientunitdata& rhs) const {
    return ! (*this == rhs);
}

inline bool transientunitdata::operator < (const transientunitdata& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasTransientproperties() || rhs.hasTransientproperties()) {
        if (getTransientproperties() < rhs.getTransientproperties()) return true;
        if (getTransientproperties() > rhs.getTransientproperties()) return false;
    }
    return false;
}

inline bool transientunitdata::operator > (const transientunitdata& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void transientunitdata::clear() {
    clearName();
    clearTransientproperties();
}

inline void transientunitdata::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool transientunitdata::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& transientunitdata::getName () const {
    return _name;
}

inline ::std::string& transientunitdata::getNameMutable () {
    set_has_name();
    return _name;
}

inline void transientunitdata::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void transientunitdata::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void transientunitdata::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void transientunitdata::clearTransientproperties() {
    if (hasTransientproperties()) {
         clear_has_transientproperties();
        _transientproperties.clear();
     }
}

inline bool transientunitdata::hasTransientproperties () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< property >& transientunitdata::getTransientproperties () const {
    return _transientproperties;
}

inline ::std::vector< property >& transientunitdata::getTransientpropertiesMutable () {
    set_has_transientproperties();
    return _transientproperties;
}

inline void transientunitdata::setTransientproperties (const ::std::vector< property >& transientproperties_) {
    set_has_transientproperties();
    this->_transientproperties = transientproperties_;
}

inline void transientunitdata::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void transientunitdata::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void transientunitdata::set_has_transientproperties () {
    _has_bits_[0] |= 1u << 1;
}

inline void transientunitdata::clear_has_transientproperties () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetUnitRequest::GetUnitRequest ()  :
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetUnitRequest::GetUnitRequest (const GetUnitRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetUnitRequest::GetUnitRequest (const ::std::string& name_)  :
    _name (name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetUnitRequest::~GetUnitRequest() {
}

inline GetUnitRequest& GetUnitRequest::operator = (const GetUnitRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool GetUnitRequest::operator == (const GetUnitRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool GetUnitRequest::operator != (const GetUnitRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetUnitRequest::operator < (const GetUnitRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetUnitRequest::clone() {
    return new GetUnitRequest(*this);
}

inline bool GetUnitRequest::operator > (const GetUnitRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetUnitRequest::clear() {
    clearName();
}

inline void GetUnitRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool GetUnitRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetUnitRequest::getName () const {
    return _name;
}

inline ::std::string& GetUnitRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void GetUnitRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void GetUnitRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void GetUnitRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void GetUnitRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetUnitRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetUnitResponse::GetUnitResponse ()  :
    _unit ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetUnitResponse::GetUnitResponse (const GetUnitResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _unit ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetUnitResponse::GetUnitResponse (const ::std::string& unit_)  :
    _unit (unit_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unit_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetUnitResponse::~GetUnitResponse() {
}

inline GetUnitResponse& GetUnitResponse::operator = (const GetUnitResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUnit()) {
            setUnit(rhs.getUnit());
        } else {
            clearUnit();
        }
    }
    return *this;
}

inline bool GetUnitResponse::operator == (const GetUnitResponse& rhs) const {
    return (((!hasUnit() && !rhs.hasUnit()) || getUnit() == rhs.getUnit()));
}

inline bool GetUnitResponse::operator != (const GetUnitResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetUnitResponse::operator < (const GetUnitResponse& rhs) const {
    if (hasUnit() || rhs.hasUnit()) {
        if (getUnit() < rhs.getUnit()) return true;
        if (getUnit() > rhs.getUnit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetUnitResponse::clone() {
    return new GetUnitResponse(*this);
}

inline bool GetUnitResponse::operator > (const GetUnitResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetUnitResponse::clear() {
    clearUnit();
}

inline void GetUnitResponse::clearUnit() {
    if (hasUnit()) {
         clear_has_unit();
        _unit.clear();
     }
}

inline bool GetUnitResponse::hasUnit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetUnitResponse::getUnit () const {
    return _unit;
}

inline ::std::string& GetUnitResponse::getUnitMutable () {
    set_has_unit();
    return _unit;
}

inline void GetUnitResponse::setUnit (const ::std::string& unit_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unit_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unit();
    this->_unit = unit_;
}

inline void GetUnitResponse::setUnit (const char* unit_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unit_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unit();
    this->_unit.assign(unit_);
}

inline void GetUnitResponse::setUnit (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unit();
    this->_unit.assign(value, size);
}

inline void GetUnitResponse::set_has_unit () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetUnitResponse::clear_has_unit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetUnitByPIDRequest::GetUnitByPIDRequest ()  :
    _pid (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetUnitByPIDRequest::GetUnitByPIDRequest (const GetUnitByPIDRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pid (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetUnitByPIDRequest::GetUnitByPIDRequest (uint32 pid_)  :
    _pid (pid_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetUnitByPIDRequest::~GetUnitByPIDRequest() {
}

inline GetUnitByPIDRequest& GetUnitByPIDRequest::operator = (const GetUnitByPIDRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
    }
    return *this;
}

inline bool GetUnitByPIDRequest::operator == (const GetUnitByPIDRequest& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()));
}

inline bool GetUnitByPIDRequest::operator != (const GetUnitByPIDRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetUnitByPIDRequest::operator < (const GetUnitByPIDRequest& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetUnitByPIDRequest::clone() {
    return new GetUnitByPIDRequest(*this);
}

inline bool GetUnitByPIDRequest::operator > (const GetUnitByPIDRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetUnitByPIDRequest::clear() {
    clearPid();
}

inline void GetUnitByPIDRequest::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0u;
     }
}

inline bool GetUnitByPIDRequest::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetUnitByPIDRequest::getPid () const {
    return _pid;
}

inline void GetUnitByPIDRequest::setPid (uint32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void GetUnitByPIDRequest::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetUnitByPIDRequest::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetUnitByPIDResponse::GetUnitByPIDResponse ()  :
    _unit ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetUnitByPIDResponse::GetUnitByPIDResponse (const GetUnitByPIDResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _unit ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetUnitByPIDResponse::GetUnitByPIDResponse (const ::std::string& unit_)  :
    _unit (unit_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unit_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetUnitByPIDResponse::~GetUnitByPIDResponse() {
}

inline GetUnitByPIDResponse& GetUnitByPIDResponse::operator = (const GetUnitByPIDResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUnit()) {
            setUnit(rhs.getUnit());
        } else {
            clearUnit();
        }
    }
    return *this;
}

inline bool GetUnitByPIDResponse::operator == (const GetUnitByPIDResponse& rhs) const {
    return (((!hasUnit() && !rhs.hasUnit()) || getUnit() == rhs.getUnit()));
}

inline bool GetUnitByPIDResponse::operator != (const GetUnitByPIDResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetUnitByPIDResponse::operator < (const GetUnitByPIDResponse& rhs) const {
    if (hasUnit() || rhs.hasUnit()) {
        if (getUnit() < rhs.getUnit()) return true;
        if (getUnit() > rhs.getUnit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetUnitByPIDResponse::clone() {
    return new GetUnitByPIDResponse(*this);
}

inline bool GetUnitByPIDResponse::operator > (const GetUnitByPIDResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetUnitByPIDResponse::clear() {
    clearUnit();
}

inline void GetUnitByPIDResponse::clearUnit() {
    if (hasUnit()) {
         clear_has_unit();
        _unit.clear();
     }
}

inline bool GetUnitByPIDResponse::hasUnit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetUnitByPIDResponse::getUnit () const {
    return _unit;
}

inline ::std::string& GetUnitByPIDResponse::getUnitMutable () {
    set_has_unit();
    return _unit;
}

inline void GetUnitByPIDResponse::setUnit (const ::std::string& unit_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unit_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unit();
    this->_unit = unit_;
}

inline void GetUnitByPIDResponse::setUnit (const char* unit_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unit_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unit();
    this->_unit.assign(unit_);
}

inline void GetUnitByPIDResponse::setUnit (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unit();
    this->_unit.assign(value, size);
}

inline void GetUnitByPIDResponse::set_has_unit () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetUnitByPIDResponse::clear_has_unit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LoadUnitRequest::LoadUnitRequest ()  :
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LoadUnitRequest::LoadUnitRequest (const LoadUnitRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LoadUnitRequest::LoadUnitRequest (const ::std::string& name_)  :
    _name (name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LoadUnitRequest::~LoadUnitRequest() {
}

inline LoadUnitRequest& LoadUnitRequest::operator = (const LoadUnitRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool LoadUnitRequest::operator == (const LoadUnitRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool LoadUnitRequest::operator != (const LoadUnitRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool LoadUnitRequest::operator < (const LoadUnitRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LoadUnitRequest::clone() {
    return new LoadUnitRequest(*this);
}

inline bool LoadUnitRequest::operator > (const LoadUnitRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LoadUnitRequest::clear() {
    clearName();
}

inline void LoadUnitRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool LoadUnitRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LoadUnitRequest::getName () const {
    return _name;
}

inline ::std::string& LoadUnitRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void LoadUnitRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void LoadUnitRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void LoadUnitRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void LoadUnitRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void LoadUnitRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LoadUnitResponse::LoadUnitResponse ()  :
    _unit ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LoadUnitResponse::LoadUnitResponse (const LoadUnitResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _unit ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LoadUnitResponse::LoadUnitResponse (const ::std::string& unit_)  :
    _unit (unit_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unit_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LoadUnitResponse::~LoadUnitResponse() {
}

inline LoadUnitResponse& LoadUnitResponse::operator = (const LoadUnitResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUnit()) {
            setUnit(rhs.getUnit());
        } else {
            clearUnit();
        }
    }
    return *this;
}

inline bool LoadUnitResponse::operator == (const LoadUnitResponse& rhs) const {
    return (((!hasUnit() && !rhs.hasUnit()) || getUnit() == rhs.getUnit()));
}

inline bool LoadUnitResponse::operator != (const LoadUnitResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool LoadUnitResponse::operator < (const LoadUnitResponse& rhs) const {
    if (hasUnit() || rhs.hasUnit()) {
        if (getUnit() < rhs.getUnit()) return true;
        if (getUnit() > rhs.getUnit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LoadUnitResponse::clone() {
    return new LoadUnitResponse(*this);
}

inline bool LoadUnitResponse::operator > (const LoadUnitResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LoadUnitResponse::clear() {
    clearUnit();
}

inline void LoadUnitResponse::clearUnit() {
    if (hasUnit()) {
         clear_has_unit();
        _unit.clear();
     }
}

inline bool LoadUnitResponse::hasUnit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LoadUnitResponse::getUnit () const {
    return _unit;
}

inline ::std::string& LoadUnitResponse::getUnitMutable () {
    set_has_unit();
    return _unit;
}

inline void LoadUnitResponse::setUnit (const ::std::string& unit_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unit_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unit();
    this->_unit = unit_;
}

inline void LoadUnitResponse::setUnit (const char* unit_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unit_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unit();
    this->_unit.assign(unit_);
}

inline void LoadUnitResponse::setUnit (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unit();
    this->_unit.assign(value, size);
}

inline void LoadUnitResponse::set_has_unit () {
    _has_bits_[0] |= 1u << 0;
}

inline void LoadUnitResponse::clear_has_unit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartUnitRequest::StartUnitRequest ()  :
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartUnitRequest::StartUnitRequest (const StartUnitRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartUnitRequest::StartUnitRequest (const ::std::string& name_, const ::std::string& mode_)  :
    _name (name_),
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartUnitRequest::~StartUnitRequest() {
}

inline StartUnitRequest& StartUnitRequest::operator = (const StartUnitRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool StartUnitRequest::operator == (const StartUnitRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool StartUnitRequest::operator != (const StartUnitRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartUnitRequest::operator < (const StartUnitRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartUnitRequest::clone() {
    return new StartUnitRequest(*this);
}

inline bool StartUnitRequest::operator > (const StartUnitRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartUnitRequest::clear() {
    clearName();
    clearMode();
}

inline void StartUnitRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool StartUnitRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartUnitRequest::getName () const {
    return _name;
}

inline ::std::string& StartUnitRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void StartUnitRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void StartUnitRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void StartUnitRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void StartUnitRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool StartUnitRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& StartUnitRequest::getMode () const {
    return _mode;
}

inline ::std::string& StartUnitRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void StartUnitRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void StartUnitRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void StartUnitRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void StartUnitRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartUnitRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartUnitRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartUnitRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StartUnitResponse::StartUnitResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartUnitResponse::StartUnitResponse (const StartUnitResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartUnitResponse::StartUnitResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartUnitResponse::~StartUnitResponse() {
}

inline StartUnitResponse& StartUnitResponse::operator = (const StartUnitResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool StartUnitResponse::operator == (const StartUnitResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool StartUnitResponse::operator != (const StartUnitResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool StartUnitResponse::operator < (const StartUnitResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartUnitResponse::clone() {
    return new StartUnitResponse(*this);
}

inline bool StartUnitResponse::operator > (const StartUnitResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartUnitResponse::clear() {
    clearJob();
}

inline void StartUnitResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool StartUnitResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartUnitResponse::getJob () const {
    return _job;
}

inline ::std::string& StartUnitResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void StartUnitResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void StartUnitResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void StartUnitResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void StartUnitResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartUnitResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartUnitReplaceRequest::StartUnitReplaceRequest ()  :
    _old_unit (),
    _new_unit (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartUnitReplaceRequest::StartUnitReplaceRequest (const StartUnitReplaceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _old_unit (),
    _new_unit (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartUnitReplaceRequest::StartUnitReplaceRequest (const ::std::string& old_unit_, const ::std::string& new_unit_, const ::std::string& mode_)  :
    _old_unit (old_unit_),
    _new_unit (new_unit_),
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (old_unit_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (new_unit_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartUnitReplaceRequest::~StartUnitReplaceRequest() {
}

inline StartUnitReplaceRequest& StartUnitReplaceRequest::operator = (const StartUnitReplaceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOld_unit()) {
            setOld_unit(rhs.getOld_unit());
        } else {
            clearOld_unit();
        }
        if (rhs.hasNew_unit()) {
            setNew_unit(rhs.getNew_unit());
        } else {
            clearNew_unit();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool StartUnitReplaceRequest::operator == (const StartUnitReplaceRequest& rhs) const {
    return (((!hasOld_unit() && !rhs.hasOld_unit()) || getOld_unit() == rhs.getOld_unit()) &&
        ((!hasNew_unit() && !rhs.hasNew_unit()) || getNew_unit() == rhs.getNew_unit()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool StartUnitReplaceRequest::operator != (const StartUnitReplaceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartUnitReplaceRequest::operator < (const StartUnitReplaceRequest& rhs) const {
    if (hasOld_unit() || rhs.hasOld_unit()) {
        if (getOld_unit() < rhs.getOld_unit()) return true;
        if (getOld_unit() > rhs.getOld_unit()) return false;
    }
    if (hasNew_unit() || rhs.hasNew_unit()) {
        if (getNew_unit() < rhs.getNew_unit()) return true;
        if (getNew_unit() > rhs.getNew_unit()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartUnitReplaceRequest::clone() {
    return new StartUnitReplaceRequest(*this);
}

inline bool StartUnitReplaceRequest::operator > (const StartUnitReplaceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartUnitReplaceRequest::clear() {
    clearOld_unit();
    clearNew_unit();
    clearMode();
}

inline void StartUnitReplaceRequest::clearOld_unit() {
    if (hasOld_unit()) {
         clear_has_old_unit();
        _old_unit.clear();
     }
}

inline bool StartUnitReplaceRequest::hasOld_unit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartUnitReplaceRequest::getOld_unit () const {
    return _old_unit;
}

inline ::std::string& StartUnitReplaceRequest::getOld_unitMutable () {
    set_has_old_unit();
    return _old_unit;
}

inline void StartUnitReplaceRequest::setOld_unit (const ::std::string& old_unit_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (old_unit_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_old_unit();
    this->_old_unit = old_unit_;
}

inline void StartUnitReplaceRequest::setOld_unit (const char* old_unit_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (old_unit_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_old_unit();
    this->_old_unit.assign(old_unit_);
}

inline void StartUnitReplaceRequest::setOld_unit (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_old_unit();
    this->_old_unit.assign(value, size);
}

inline void StartUnitReplaceRequest::clearNew_unit() {
    if (hasNew_unit()) {
         clear_has_new_unit();
        _new_unit.clear();
     }
}

inline bool StartUnitReplaceRequest::hasNew_unit () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& StartUnitReplaceRequest::getNew_unit () const {
    return _new_unit;
}

inline ::std::string& StartUnitReplaceRequest::getNew_unitMutable () {
    set_has_new_unit();
    return _new_unit;
}

inline void StartUnitReplaceRequest::setNew_unit (const ::std::string& new_unit_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (new_unit_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_new_unit();
    this->_new_unit = new_unit_;
}

inline void StartUnitReplaceRequest::setNew_unit (const char* new_unit_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (new_unit_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_new_unit();
    this->_new_unit.assign(new_unit_);
}

inline void StartUnitReplaceRequest::setNew_unit (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_new_unit();
    this->_new_unit.assign(value, size);
}

inline void StartUnitReplaceRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool StartUnitReplaceRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& StartUnitReplaceRequest::getMode () const {
    return _mode;
}

inline ::std::string& StartUnitReplaceRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void StartUnitReplaceRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void StartUnitReplaceRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void StartUnitReplaceRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void StartUnitReplaceRequest::set_has_old_unit () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartUnitReplaceRequest::clear_has_old_unit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartUnitReplaceRequest::set_has_new_unit () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartUnitReplaceRequest::clear_has_new_unit () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void StartUnitReplaceRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 2;
}

inline void StartUnitReplaceRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  StartUnitReplaceResponse::StartUnitReplaceResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartUnitReplaceResponse::StartUnitReplaceResponse (const StartUnitReplaceResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartUnitReplaceResponse::StartUnitReplaceResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartUnitReplaceResponse::~StartUnitReplaceResponse() {
}

inline StartUnitReplaceResponse& StartUnitReplaceResponse::operator = (const StartUnitReplaceResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool StartUnitReplaceResponse::operator == (const StartUnitReplaceResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool StartUnitReplaceResponse::operator != (const StartUnitReplaceResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool StartUnitReplaceResponse::operator < (const StartUnitReplaceResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartUnitReplaceResponse::clone() {
    return new StartUnitReplaceResponse(*this);
}

inline bool StartUnitReplaceResponse::operator > (const StartUnitReplaceResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartUnitReplaceResponse::clear() {
    clearJob();
}

inline void StartUnitReplaceResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool StartUnitReplaceResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartUnitReplaceResponse::getJob () const {
    return _job;
}

inline ::std::string& StartUnitReplaceResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void StartUnitReplaceResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void StartUnitReplaceResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void StartUnitReplaceResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void StartUnitReplaceResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartUnitReplaceResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StopUnitRequest::StopUnitRequest ()  :
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopUnitRequest::StopUnitRequest (const StopUnitRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopUnitRequest::StopUnitRequest (const ::std::string& name_, const ::std::string& mode_)  :
    _name (name_),
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StopUnitRequest::~StopUnitRequest() {
}

inline StopUnitRequest& StopUnitRequest::operator = (const StopUnitRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool StopUnitRequest::operator == (const StopUnitRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool StopUnitRequest::operator != (const StopUnitRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StopUnitRequest::operator < (const StopUnitRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StopUnitRequest::clone() {
    return new StopUnitRequest(*this);
}

inline bool StopUnitRequest::operator > (const StopUnitRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopUnitRequest::clear() {
    clearName();
    clearMode();
}

inline void StopUnitRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool StopUnitRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StopUnitRequest::getName () const {
    return _name;
}

inline ::std::string& StopUnitRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void StopUnitRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void StopUnitRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void StopUnitRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void StopUnitRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool StopUnitRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& StopUnitRequest::getMode () const {
    return _mode;
}

inline ::std::string& StopUnitRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void StopUnitRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void StopUnitRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void StopUnitRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void StopUnitRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void StopUnitRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StopUnitRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void StopUnitRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StopUnitResponse::StopUnitResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopUnitResponse::StopUnitResponse (const StopUnitResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopUnitResponse::StopUnitResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StopUnitResponse::~StopUnitResponse() {
}

inline StopUnitResponse& StopUnitResponse::operator = (const StopUnitResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool StopUnitResponse::operator == (const StopUnitResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool StopUnitResponse::operator != (const StopUnitResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool StopUnitResponse::operator < (const StopUnitResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StopUnitResponse::clone() {
    return new StopUnitResponse(*this);
}

inline bool StopUnitResponse::operator > (const StopUnitResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopUnitResponse::clear() {
    clearJob();
}

inline void StopUnitResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool StopUnitResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StopUnitResponse::getJob () const {
    return _job;
}

inline ::std::string& StopUnitResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void StopUnitResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void StopUnitResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void StopUnitResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void StopUnitResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void StopUnitResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReloadUnitRequest::ReloadUnitRequest ()  :
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadUnitRequest::ReloadUnitRequest (const ReloadUnitRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadUnitRequest::ReloadUnitRequest (const ::std::string& name_, const ::std::string& mode_)  :
    _name (name_),
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadUnitRequest::~ReloadUnitRequest() {
}

inline ReloadUnitRequest& ReloadUnitRequest::operator = (const ReloadUnitRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool ReloadUnitRequest::operator == (const ReloadUnitRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool ReloadUnitRequest::operator != (const ReloadUnitRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadUnitRequest::operator < (const ReloadUnitRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadUnitRequest::clone() {
    return new ReloadUnitRequest(*this);
}

inline bool ReloadUnitRequest::operator > (const ReloadUnitRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadUnitRequest::clear() {
    clearName();
    clearMode();
}

inline void ReloadUnitRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool ReloadUnitRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReloadUnitRequest::getName () const {
    return _name;
}

inline ::std::string& ReloadUnitRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void ReloadUnitRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void ReloadUnitRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void ReloadUnitRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void ReloadUnitRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool ReloadUnitRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ReloadUnitRequest::getMode () const {
    return _mode;
}

inline ::std::string& ReloadUnitRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void ReloadUnitRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void ReloadUnitRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void ReloadUnitRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void ReloadUnitRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadUnitRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReloadUnitRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReloadUnitRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ReloadUnitResponse::ReloadUnitResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadUnitResponse::ReloadUnitResponse (const ReloadUnitResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadUnitResponse::ReloadUnitResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadUnitResponse::~ReloadUnitResponse() {
}

inline ReloadUnitResponse& ReloadUnitResponse::operator = (const ReloadUnitResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool ReloadUnitResponse::operator == (const ReloadUnitResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool ReloadUnitResponse::operator != (const ReloadUnitResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadUnitResponse::operator < (const ReloadUnitResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadUnitResponse::clone() {
    return new ReloadUnitResponse(*this);
}

inline bool ReloadUnitResponse::operator > (const ReloadUnitResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadUnitResponse::clear() {
    clearJob();
}

inline void ReloadUnitResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool ReloadUnitResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReloadUnitResponse::getJob () const {
    return _job;
}

inline ::std::string& ReloadUnitResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void ReloadUnitResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void ReloadUnitResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void ReloadUnitResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void ReloadUnitResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadUnitResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestartUnitRequest::RestartUnitRequest ()  :
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestartUnitRequest::RestartUnitRequest (const RestartUnitRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestartUnitRequest::RestartUnitRequest (const ::std::string& name_, const ::std::string& mode_)  :
    _name (name_),
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestartUnitRequest::~RestartUnitRequest() {
}

inline RestartUnitRequest& RestartUnitRequest::operator = (const RestartUnitRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool RestartUnitRequest::operator == (const RestartUnitRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool RestartUnitRequest::operator != (const RestartUnitRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RestartUnitRequest::operator < (const RestartUnitRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RestartUnitRequest::clone() {
    return new RestartUnitRequest(*this);
}

inline bool RestartUnitRequest::operator > (const RestartUnitRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestartUnitRequest::clear() {
    clearName();
    clearMode();
}

inline void RestartUnitRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool RestartUnitRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RestartUnitRequest::getName () const {
    return _name;
}

inline ::std::string& RestartUnitRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void RestartUnitRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void RestartUnitRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void RestartUnitRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void RestartUnitRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool RestartUnitRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RestartUnitRequest::getMode () const {
    return _mode;
}

inline ::std::string& RestartUnitRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void RestartUnitRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void RestartUnitRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void RestartUnitRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void RestartUnitRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestartUnitRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RestartUnitRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void RestartUnitRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RestartUnitResponse::RestartUnitResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestartUnitResponse::RestartUnitResponse (const RestartUnitResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestartUnitResponse::RestartUnitResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestartUnitResponse::~RestartUnitResponse() {
}

inline RestartUnitResponse& RestartUnitResponse::operator = (const RestartUnitResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool RestartUnitResponse::operator == (const RestartUnitResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool RestartUnitResponse::operator != (const RestartUnitResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RestartUnitResponse::operator < (const RestartUnitResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RestartUnitResponse::clone() {
    return new RestartUnitResponse(*this);
}

inline bool RestartUnitResponse::operator > (const RestartUnitResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestartUnitResponse::clear() {
    clearJob();
}

inline void RestartUnitResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool RestartUnitResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RestartUnitResponse::getJob () const {
    return _job;
}

inline ::std::string& RestartUnitResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void RestartUnitResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void RestartUnitResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void RestartUnitResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void RestartUnitResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestartUnitResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TryRestartUnitRequest::TryRestartUnitRequest ()  :
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TryRestartUnitRequest::TryRestartUnitRequest (const TryRestartUnitRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TryRestartUnitRequest::TryRestartUnitRequest (const ::std::string& name_, const ::std::string& mode_)  :
    _name (name_),
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TryRestartUnitRequest::~TryRestartUnitRequest() {
}

inline TryRestartUnitRequest& TryRestartUnitRequest::operator = (const TryRestartUnitRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool TryRestartUnitRequest::operator == (const TryRestartUnitRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool TryRestartUnitRequest::operator != (const TryRestartUnitRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool TryRestartUnitRequest::operator < (const TryRestartUnitRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TryRestartUnitRequest::clone() {
    return new TryRestartUnitRequest(*this);
}

inline bool TryRestartUnitRequest::operator > (const TryRestartUnitRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TryRestartUnitRequest::clear() {
    clearName();
    clearMode();
}

inline void TryRestartUnitRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool TryRestartUnitRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TryRestartUnitRequest::getName () const {
    return _name;
}

inline ::std::string& TryRestartUnitRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void TryRestartUnitRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void TryRestartUnitRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void TryRestartUnitRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void TryRestartUnitRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool TryRestartUnitRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& TryRestartUnitRequest::getMode () const {
    return _mode;
}

inline ::std::string& TryRestartUnitRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void TryRestartUnitRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void TryRestartUnitRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void TryRestartUnitRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void TryRestartUnitRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void TryRestartUnitRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TryRestartUnitRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void TryRestartUnitRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  TryRestartUnitResponse::TryRestartUnitResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TryRestartUnitResponse::TryRestartUnitResponse (const TryRestartUnitResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TryRestartUnitResponse::TryRestartUnitResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TryRestartUnitResponse::~TryRestartUnitResponse() {
}

inline TryRestartUnitResponse& TryRestartUnitResponse::operator = (const TryRestartUnitResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool TryRestartUnitResponse::operator == (const TryRestartUnitResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool TryRestartUnitResponse::operator != (const TryRestartUnitResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool TryRestartUnitResponse::operator < (const TryRestartUnitResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TryRestartUnitResponse::clone() {
    return new TryRestartUnitResponse(*this);
}

inline bool TryRestartUnitResponse::operator > (const TryRestartUnitResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TryRestartUnitResponse::clear() {
    clearJob();
}

inline void TryRestartUnitResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool TryRestartUnitResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TryRestartUnitResponse::getJob () const {
    return _job;
}

inline ::std::string& TryRestartUnitResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void TryRestartUnitResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void TryRestartUnitResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void TryRestartUnitResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void TryRestartUnitResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void TryRestartUnitResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReloadOrRestartUnitRequest::ReloadOrRestartUnitRequest ()  :
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadOrRestartUnitRequest::ReloadOrRestartUnitRequest (const ReloadOrRestartUnitRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadOrRestartUnitRequest::ReloadOrRestartUnitRequest (const ::std::string& name_, const ::std::string& mode_)  :
    _name (name_),
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadOrRestartUnitRequest::~ReloadOrRestartUnitRequest() {
}

inline ReloadOrRestartUnitRequest& ReloadOrRestartUnitRequest::operator = (const ReloadOrRestartUnitRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool ReloadOrRestartUnitRequest::operator == (const ReloadOrRestartUnitRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool ReloadOrRestartUnitRequest::operator != (const ReloadOrRestartUnitRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadOrRestartUnitRequest::operator < (const ReloadOrRestartUnitRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadOrRestartUnitRequest::clone() {
    return new ReloadOrRestartUnitRequest(*this);
}

inline bool ReloadOrRestartUnitRequest::operator > (const ReloadOrRestartUnitRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadOrRestartUnitRequest::clear() {
    clearName();
    clearMode();
}

inline void ReloadOrRestartUnitRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool ReloadOrRestartUnitRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReloadOrRestartUnitRequest::getName () const {
    return _name;
}

inline ::std::string& ReloadOrRestartUnitRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void ReloadOrRestartUnitRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void ReloadOrRestartUnitRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void ReloadOrRestartUnitRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void ReloadOrRestartUnitRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool ReloadOrRestartUnitRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ReloadOrRestartUnitRequest::getMode () const {
    return _mode;
}

inline ::std::string& ReloadOrRestartUnitRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void ReloadOrRestartUnitRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void ReloadOrRestartUnitRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void ReloadOrRestartUnitRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void ReloadOrRestartUnitRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadOrRestartUnitRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReloadOrRestartUnitRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReloadOrRestartUnitRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ReloadOrRestartUnitResponse::ReloadOrRestartUnitResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadOrRestartUnitResponse::ReloadOrRestartUnitResponse (const ReloadOrRestartUnitResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadOrRestartUnitResponse::ReloadOrRestartUnitResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadOrRestartUnitResponse::~ReloadOrRestartUnitResponse() {
}

inline ReloadOrRestartUnitResponse& ReloadOrRestartUnitResponse::operator = (const ReloadOrRestartUnitResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool ReloadOrRestartUnitResponse::operator == (const ReloadOrRestartUnitResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool ReloadOrRestartUnitResponse::operator != (const ReloadOrRestartUnitResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadOrRestartUnitResponse::operator < (const ReloadOrRestartUnitResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadOrRestartUnitResponse::clone() {
    return new ReloadOrRestartUnitResponse(*this);
}

inline bool ReloadOrRestartUnitResponse::operator > (const ReloadOrRestartUnitResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadOrRestartUnitResponse::clear() {
    clearJob();
}

inline void ReloadOrRestartUnitResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool ReloadOrRestartUnitResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReloadOrRestartUnitResponse::getJob () const {
    return _job;
}

inline ::std::string& ReloadOrRestartUnitResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void ReloadOrRestartUnitResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void ReloadOrRestartUnitResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void ReloadOrRestartUnitResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void ReloadOrRestartUnitResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadOrRestartUnitResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReloadOrTryRestartUnitRequest::ReloadOrTryRestartUnitRequest ()  :
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadOrTryRestartUnitRequest::ReloadOrTryRestartUnitRequest (const ReloadOrTryRestartUnitRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadOrTryRestartUnitRequest::ReloadOrTryRestartUnitRequest (const ::std::string& name_, const ::std::string& mode_)  :
    _name (name_),
    _mode (mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadOrTryRestartUnitRequest::~ReloadOrTryRestartUnitRequest() {
}

inline ReloadOrTryRestartUnitRequest& ReloadOrTryRestartUnitRequest::operator = (const ReloadOrTryRestartUnitRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool ReloadOrTryRestartUnitRequest::operator == (const ReloadOrTryRestartUnitRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool ReloadOrTryRestartUnitRequest::operator != (const ReloadOrTryRestartUnitRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadOrTryRestartUnitRequest::operator < (const ReloadOrTryRestartUnitRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadOrTryRestartUnitRequest::clone() {
    return new ReloadOrTryRestartUnitRequest(*this);
}

inline bool ReloadOrTryRestartUnitRequest::operator > (const ReloadOrTryRestartUnitRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadOrTryRestartUnitRequest::clear() {
    clearName();
    clearMode();
}

inline void ReloadOrTryRestartUnitRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool ReloadOrTryRestartUnitRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReloadOrTryRestartUnitRequest::getName () const {
    return _name;
}

inline ::std::string& ReloadOrTryRestartUnitRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void ReloadOrTryRestartUnitRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void ReloadOrTryRestartUnitRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void ReloadOrTryRestartUnitRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void ReloadOrTryRestartUnitRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool ReloadOrTryRestartUnitRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ReloadOrTryRestartUnitRequest::getMode () const {
    return _mode;
}

inline ::std::string& ReloadOrTryRestartUnitRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void ReloadOrTryRestartUnitRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void ReloadOrTryRestartUnitRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void ReloadOrTryRestartUnitRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void ReloadOrTryRestartUnitRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadOrTryRestartUnitRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReloadOrTryRestartUnitRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReloadOrTryRestartUnitRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ReloadOrTryRestartUnitResponse::ReloadOrTryRestartUnitResponse ()  :
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReloadOrTryRestartUnitResponse::ReloadOrTryRestartUnitResponse (const ReloadOrTryRestartUnitResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _job ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReloadOrTryRestartUnitResponse::ReloadOrTryRestartUnitResponse (const ::std::string& job_)  :
    _job (job_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReloadOrTryRestartUnitResponse::~ReloadOrTryRestartUnitResponse() {
}

inline ReloadOrTryRestartUnitResponse& ReloadOrTryRestartUnitResponse::operator = (const ReloadOrTryRestartUnitResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJob()) {
            setJob(rhs.getJob());
        } else {
            clearJob();
        }
    }
    return *this;
}

inline bool ReloadOrTryRestartUnitResponse::operator == (const ReloadOrTryRestartUnitResponse& rhs) const {
    return (((!hasJob() && !rhs.hasJob()) || getJob() == rhs.getJob()));
}

inline bool ReloadOrTryRestartUnitResponse::operator != (const ReloadOrTryRestartUnitResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReloadOrTryRestartUnitResponse::operator < (const ReloadOrTryRestartUnitResponse& rhs) const {
    if (hasJob() || rhs.hasJob()) {
        if (getJob() < rhs.getJob()) return true;
        if (getJob() > rhs.getJob()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReloadOrTryRestartUnitResponse::clone() {
    return new ReloadOrTryRestartUnitResponse(*this);
}

inline bool ReloadOrTryRestartUnitResponse::operator > (const ReloadOrTryRestartUnitResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReloadOrTryRestartUnitResponse::clear() {
    clearJob();
}

inline void ReloadOrTryRestartUnitResponse::clearJob() {
    if (hasJob()) {
         clear_has_job();
        _job.clear();
     }
}

inline bool ReloadOrTryRestartUnitResponse::hasJob () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReloadOrTryRestartUnitResponse::getJob () const {
    return _job;
}

inline ::std::string& ReloadOrTryRestartUnitResponse::getJobMutable () {
    set_has_job();
    return _job;
}

inline void ReloadOrTryRestartUnitResponse::setJob (const ::std::string& job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job = job_;
}

inline void ReloadOrTryRestartUnitResponse::setJob (const char* job_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (job_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(job_);
}

inline void ReloadOrTryRestartUnitResponse::setJob (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_job();
    this->_job.assign(value, size);
}

inline void ReloadOrTryRestartUnitResponse::set_has_job () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReloadOrTryRestartUnitResponse::clear_has_job () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  KillUnitRequest::KillUnitRequest ()  :
    _name (),
    _who (),
    _signal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KillUnitRequest::KillUnitRequest (const KillUnitRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _who (),
    _signal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KillUnitRequest::KillUnitRequest (const ::std::string& name_, const ::std::string& who_, int32 signal_)  :
    _name (name_),
    _who (who_),
    _signal (signal_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (who_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KillUnitRequest::~KillUnitRequest() {
}

inline KillUnitRequest& KillUnitRequest::operator = (const KillUnitRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasWho()) {
            setWho(rhs.getWho());
        } else {
            clearWho();
        }
        if (rhs.hasSignal()) {
            setSignal(rhs.getSignal());
        } else {
            clearSignal();
        }
    }
    return *this;
}

inline bool KillUnitRequest::operator == (const KillUnitRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasWho() && !rhs.hasWho()) || getWho() == rhs.getWho()) &&
        ((!hasSignal() && !rhs.hasSignal()) || getSignal() == rhs.getSignal()));
}

inline bool KillUnitRequest::operator != (const KillUnitRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool KillUnitRequest::operator < (const KillUnitRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasWho() || rhs.hasWho()) {
        if (getWho() < rhs.getWho()) return true;
        if (getWho() > rhs.getWho()) return false;
    }
    if (hasSignal() || rhs.hasSignal()) {
        if (getSignal() < rhs.getSignal()) return true;
        if (getSignal() > rhs.getSignal()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KillUnitRequest::clone() {
    return new KillUnitRequest(*this);
}

inline bool KillUnitRequest::operator > (const KillUnitRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KillUnitRequest::clear() {
    clearName();
    clearWho();
    clearSignal();
}

inline void KillUnitRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool KillUnitRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& KillUnitRequest::getName () const {
    return _name;
}

inline ::std::string& KillUnitRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void KillUnitRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void KillUnitRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void KillUnitRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void KillUnitRequest::clearWho() {
    if (hasWho()) {
         clear_has_who();
        _who.clear();
     }
}

inline bool KillUnitRequest::hasWho () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& KillUnitRequest::getWho () const {
    return _who;
}

inline ::std::string& KillUnitRequest::getWhoMutable () {
    set_has_who();
    return _who;
}

inline void KillUnitRequest::setWho (const ::std::string& who_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (who_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_who();
    this->_who = who_;
}

inline void KillUnitRequest::setWho (const char* who_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (who_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_who();
    this->_who.assign(who_);
}

inline void KillUnitRequest::setWho (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_who();
    this->_who.assign(value, size);
}

inline void KillUnitRequest::clearSignal() {
    if (hasSignal()) {
         clear_has_signal();
        _signal = 0;
     }
}

inline bool KillUnitRequest::hasSignal () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 KillUnitRequest::getSignal () const {
    return _signal;
}

inline void KillUnitRequest::setSignal (int32 signal_) {
    set_has_signal();
    this->_signal = signal_;
}

inline void KillUnitRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void KillUnitRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void KillUnitRequest::set_has_who () {
    _has_bits_[0] |= 1u << 1;
}

inline void KillUnitRequest::clear_has_who () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void KillUnitRequest::set_has_signal () {
    _has_bits_[0] |= 1u << 2;
}

inline void KillUnitRequest::clear_has_signal () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ResetFailedUnitRequest::ResetFailedUnitRequest ()  :
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ResetFailedUnitRequest::ResetFailedUnitRequest (const ResetFailedUnitRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ResetFailedUnitRequest::ResetFailedUnitRequest (const ::std::string& name_)  :
    _name (name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ResetFailedUnitRequest::~ResetFailedUnitRequest() {
}

inline ResetFailedUnitRequest& ResetFailedUnitRequest::operator = (const ResetFailedUnitRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool ResetFailedUnitRequest::operator == (const ResetFailedUnitRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool ResetFailedUnitRequest::operator != (const ResetFailedUnitRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ResetFailedUnitRequest::operator < (const ResetFailedUnitRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ResetFailedUnitRequest::clone() {
    return new ResetFailedUnitRequest(*this);
}

inline bool ResetFailedUnitRequest::operator > (const ResetFailedUnitRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ResetFailedUnitRequest::clear() {
    clearName();
}

inline void ResetFailedUnitRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool ResetFailedUnitRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ResetFailedUnitRequest::getName () const {
    return _name;
}

inline ::std::string& ResetFailedUnitRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void ResetFailedUnitRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void ResetFailedUnitRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void ResetFailedUnitRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void ResetFailedUnitRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void ResetFailedUnitRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetUnitPropertiesRequest::SetUnitPropertiesRequest ()  :
    _name (),
    _runtime (false),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetUnitPropertiesRequest::SetUnitPropertiesRequest (const SetUnitPropertiesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _runtime (false),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetUnitPropertiesRequest::SetUnitPropertiesRequest (const ::std::string& name_, bool runtime_, const ::std::vector< property >& properties_)  :
    _name (name_),
    _runtime (runtime_),
    _properties (properties_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetUnitPropertiesRequest::~SetUnitPropertiesRequest() {
}

inline SetUnitPropertiesRequest& SetUnitPropertiesRequest::operator = (const SetUnitPropertiesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasRuntime()) {
            setRuntime(rhs.getRuntime());
        } else {
            clearRuntime();
        }
        if (rhs.hasProperties()) {
            setProperties(rhs.getProperties());
        } else {
            clearProperties();
        }
    }
    return *this;
}

inline bool SetUnitPropertiesRequest::operator == (const SetUnitPropertiesRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasRuntime() && !rhs.hasRuntime()) || getRuntime() == rhs.getRuntime()) &&
        ((!hasProperties() && !rhs.hasProperties()) || getProperties() == rhs.getProperties()));
}

inline bool SetUnitPropertiesRequest::operator != (const SetUnitPropertiesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetUnitPropertiesRequest::operator < (const SetUnitPropertiesRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasRuntime() || rhs.hasRuntime()) {
        if (getRuntime() < rhs.getRuntime()) return true;
        if (getRuntime() > rhs.getRuntime()) return false;
    }
    if (hasProperties() || rhs.hasProperties()) {
        if (getProperties() < rhs.getProperties()) return true;
        if (getProperties() > rhs.getProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetUnitPropertiesRequest::clone() {
    return new SetUnitPropertiesRequest(*this);
}

inline bool SetUnitPropertiesRequest::operator > (const SetUnitPropertiesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetUnitPropertiesRequest::clear() {
    clearName();
    clearRuntime();
    clearProperties();
}

inline void SetUnitPropertiesRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool SetUnitPropertiesRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetUnitPropertiesRequest::getName () const {
    return _name;
}

inline ::std::string& SetUnitPropertiesRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void SetUnitPropertiesRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void SetUnitPropertiesRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void SetUnitPropertiesRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void SetUnitPropertiesRequest::clearRuntime() {
    if (hasRuntime()) {
         clear_has_runtime();
        _runtime = false;
     }
}

inline bool SetUnitPropertiesRequest::hasRuntime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SetUnitPropertiesRequest::getRuntime () const {
    return _runtime;
}

inline void SetUnitPropertiesRequest::setRuntime (bool runtime_) {
    set_has_runtime();
    this->_runtime = runtime_;
}

inline void SetUnitPropertiesRequest::clearProperties() {
    if (hasProperties()) {
         clear_has_properties();
        _properties.clear();
     }
}

inline bool SetUnitPropertiesRequest::hasProperties () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< property >& SetUnitPropertiesRequest::getProperties () const {
    return _properties;
}

inline ::std::vector< property >& SetUnitPropertiesRequest::getPropertiesMutable () {
    set_has_properties();
    return _properties;
}

inline void SetUnitPropertiesRequest::setProperties (const ::std::vector< property >& properties_) {
    set_has_properties();
    this->_properties = properties_;
}

inline void SetUnitPropertiesRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetUnitPropertiesRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetUnitPropertiesRequest::set_has_runtime () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetUnitPropertiesRequest::clear_has_runtime () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetUnitPropertiesRequest::set_has_properties () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetUnitPropertiesRequest::clear_has_properties () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  StartTransientUnitRequest::StartTransientUnitRequest ()  :
    _name (),
    _mode (),
    _properties (),
    _transientunitdata ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartTransientUnitRequest::StartTransientUnitRequest (const StartTransientUnitRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _mode (),
    _properties (),
    _transientunitdata ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartTransientUnitRequest::StartTransientUnitRequest (const ::std::string& name_, const ::std::string& mode_, const ::std::vector< property >& properties_, const ::std::vector< transientunitdata >& transientunitdata_)  :
    _name (name_),
    _mode (mode_),
    _properties (properties_),
    _transientunitdata (transientunitdata_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartTransientUnitRequest::~StartTransientUnitRequest() {
}

inline StartTransientUnitRequest& StartTransientUnitRequest::operator = (const StartTransientUnitRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
        if (rhs.hasProperties()) {
            setProperties(rhs.getProperties());
        } else {
            clearProperties();
        }
        if (rhs.hasTransientunitdata()) {
            setTransientunitdata(rhs.getTransientunitdata());
        } else {
            clearTransientunitdata();
        }
    }
    return *this;
}

inline bool StartTransientUnitRequest::operator == (const StartTransientUnitRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()) &&
        ((!hasProperties() && !rhs.hasProperties()) || getProperties() == rhs.getProperties()) &&
        ((!hasTransientunitdata() && !rhs.hasTransientunitdata()) || getTransientunitdata() == rhs.getTransientunitdata()));
}

inline bool StartTransientUnitRequest::operator != (const StartTransientUnitRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartTransientUnitRequest::operator < (const StartTransientUnitRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    if (hasProperties() || rhs.hasProperties()) {
        if (getProperties() < rhs.getProperties()) return true;
        if (getProperties() > rhs.getProperties()) return false;
    }
    if (hasTransientunitdata() || rhs.hasTransientunitdata()) {
        if (getTransientunitdata() < rhs.getTransientunitdata()) return true;
