/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/freedesktop/systemd1/Job.h"
#include "org/freedesktop/systemd1/JobDBus.h"
#include "org/freedesktop/systemd1/JobJson.h"
#include "org/freedesktop/systemd1/JobProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Job {

DEFINE_CLASS_LOGGER("/org/freedesktop/systemd1/org/freedesktop/systemd1/Job", JobProxy);

class JobProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    JobProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< JobProxy >& proxyShared = ::boost::static_pointer_cast< JobProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Id:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IdError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Id", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IdError> payload = ::boost::static_pointer_cast<IdError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IdCallbackIF*) _callback)->onIdError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IdUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Id", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IdUpdate> payload = ::boost::static_pointer_cast<IdUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IdCallbackIF*) _callback)->onIdUpdate(proxyShared, payload);
                        proxyShared->_id = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Unit:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Unit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitError> payload = ::boost::static_pointer_cast<UnitError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UnitCallbackIF*) _callback)->onUnitError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Unit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitUpdate> payload = ::boost::static_pointer_cast<UnitUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UnitCallbackIF*) _callback)->onUnitUpdate(proxyShared, payload);
                        proxyShared->_unit = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_JobType:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JobTypeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JobType", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JobTypeError> payload = ::boost::static_pointer_cast<JobTypeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((JobTypeCallbackIF*) _callback)->onJobTypeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JobTypeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JobType", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JobTypeUpdate> payload = ::boost::static_pointer_cast<JobTypeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((JobTypeCallbackIF*) _callback)->onJobTypeUpdate(proxyShared, payload);
                        proxyShared->_jobType = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_State:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "State", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StateError> payload = ::boost::static_pointer_cast<StateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StateCallbackIF*) _callback)->onStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "State", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StateUpdate> payload = ::boost::static_pointer_cast<StateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StateCallbackIF*) _callback)->onStateUpdate(proxyShared, payload);
                        proxyShared->_state = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Cancel:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Cancel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelError> payload = ::boost::static_pointer_cast<CancelError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelCallbackIF*) _callback)->onCancelError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Cancel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelResponse> payload = ::boost::static_pointer_cast<CancelResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelCallbackIF*) _callback)->onCancelResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Id: {
                ::boost::shared_ptr< IdError > payload = ::boost::shared_ptr< IdError >
                (new IdError(DBUS_ERROR_NO_SERVER, "The DBus service Job is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Id", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<JobProxy> proxyShared = ::boost::static_pointer_cast<JobProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IdCallbackIF*) _callback)->onIdError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Unit: {
                ::boost::shared_ptr< UnitError > payload = ::boost::shared_ptr< UnitError >
                (new UnitError(DBUS_ERROR_NO_SERVER, "The DBus service Job is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Unit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<JobProxy> proxyShared = ::boost::static_pointer_cast<JobProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnitCallbackIF*) _callback)->onUnitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_JobType: {
                ::boost::shared_ptr< JobTypeError > payload = ::boost::shared_ptr< JobTypeError >
                (new JobTypeError(DBUS_ERROR_NO_SERVER, "The DBus service Job is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "JobType", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<JobProxy> proxyShared = ::boost::static_pointer_cast<JobProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((JobTypeCallbackIF*) _callback)->onJobTypeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_State: {
                ::boost::shared_ptr< StateError > payload = ::boost::shared_ptr< StateError >
                (new StateError(DBUS_ERROR_NO_SERVER, "The DBus service Job is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "State", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<JobProxy> proxyShared = ::boost::static_pointer_cast<JobProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StateCallbackIF*) _callback)->onStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Cancel: {
                ::boost::shared_ptr< CancelError > payload = ::boost::shared_ptr< CancelError >
                (new CancelError(DBUS_ERROR_NO_SERVER, "The DBus service Job is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Cancel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<JobProxy> proxyShared = ::boost::static_pointer_cast<JobProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelCallbackIF*) _callback)->onCancelError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& JobProxyCallback::_logger (JobProxy::_logger);

JobProxy::JobProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.freedesktop.systemd1.Job", serviceAvailable, _logger) {
}

JobProxy::~JobProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< JobProxy > JobProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<JobProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< JobProxy > proxyNew(new JobProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t JobProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    JobProxyCallback* callback = new JobProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t JobProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    JobProxyCallback* callback = new JobProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void JobProxy::clearAllProperties ()
{
    _id = ::asf::core::nullable< IdUpdate >();
    _unit = ::asf::core::nullable< UnitUpdate >();
    _jobType = ::asf::core::nullable< JobTypeUpdate >();
    _state = ::asf::core::nullable< StateUpdate >();
}

void JobProxy::sendDeregisterAll () const
{
    sendIdDeregisterAll();
    sendUnitDeregisterAll();
    sendJobTypeDeregisterAll();
    sendStateDeregisterAll();
}

act_t JobProxy::sendIdRegister(IdCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Id, "Id", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Id", &cb, act);
    return act;
}

bool JobProxy::sendIdDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Id", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Id", act, static_cast<int>(rv));
    return rv;
}

act_t JobProxy::sendIdGet(IdCallbackIF& cb) {
    JobProxyCallback* callback = new JobProxyCallback(ID_Id, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Id", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Id", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 JobProxy::getId() const {
    return _id.get().getId();
}

bool JobProxy::hasId() const {
    return _id.hasValue();
}

void JobProxy::sendIdDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Id");
    _dbusProxyDelegate->deregisterSignalCallback("Id", 0, _dbusDaemonProxy.get(), true);
}

act_t JobProxy::sendUnitRegister(UnitCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Unit, "Unit", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Unit", &cb, act);
    return act;
}

bool JobProxy::sendUnitDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Unit", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Unit", act, static_cast<int>(rv));
    return rv;
}

act_t JobProxy::sendUnitGet(UnitCallbackIF& cb) {
    JobProxyCallback* callback = new JobProxyCallback(ID_Unit, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Unit", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Unit", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const unit& JobProxy::getUnit() const {
    return _unit.get().getUnit();
}

bool JobProxy::hasUnit() const {
    return _unit.hasValue();
}

void JobProxy::sendUnitDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Unit");
    _dbusProxyDelegate->deregisterSignalCallback("Unit", 0, _dbusDaemonProxy.get(), true);
}

act_t JobProxy::sendJobTypeRegister(JobTypeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_JobType, "JobType", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "JobType", &cb, act);
    return act;
}

bool JobProxy::sendJobTypeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("JobType", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "JobType", act, static_cast<int>(rv));
    return rv;
}

act_t JobProxy::sendJobTypeGet(JobTypeCallbackIF& cb) {
    JobProxyCallback* callback = new JobProxyCallback(ID_JobType, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "JobType", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("JobType", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& JobProxy::getJobType() const {
    return _jobType.get().getJobType();
}

bool JobProxy::hasJobType() const {
    return _jobType.hasValue();
}

void JobProxy::sendJobTypeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "JobType");
    _dbusProxyDelegate->deregisterSignalCallback("JobType", 0, _dbusDaemonProxy.get(), true);
}

act_t JobProxy::sendStateRegister(StateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_State, "State", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "State", &cb, act);
    return act;
}

bool JobProxy::sendStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("State", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "State", act, static_cast<int>(rv));
    return rv;
}

act_t JobProxy::sendStateGet(StateCallbackIF& cb) {
    JobProxyCallback* callback = new JobProxyCallback(ID_State, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "State", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("State", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& JobProxy::getState() const {
    return _state.get().getState();
}

bool JobProxy::hasState() const {
    return _state.hasValue();
}

void JobProxy::sendStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "State");
    _dbusProxyDelegate->deregisterSignalCallback("State", 0, _dbusDaemonProxy.get(), true);
}

act_t JobProxy::sendCancelRequest(CancelCallbackIF& cb) const {
    CancelRequest* payload = new CancelRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Cancel", CancelRequest, payload, true)
    act_t act = addMethodCallback(ID_Cancel, dbusMessage.getUniqueSerial(), "Cancel", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Cancel", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Job
} // namespace systemd1
} // namespace freedesktop
} // namespace org
