#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_FREEDESKTOP_SYSTEMD1_JOB_H
#define ORG_FREEDESKTOP_SYSTEMD1_JOB_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * org.freedesktop.systemd1.Job:
 *     short_description: All Job objects implement the generic org.freedesktop.systemd1.Job interface.
 */

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Job {

// method IDs
static const uint16 ID_Cancel = 0;

// signal IDs

// property IDs
static const uint16 ID_Id = 1;
static const uint16 ID_Unit = 2;
static const uint16 ID_JobType = 3;
static const uint16 ID_State = 4;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class unit;

class IdUpdate;

class IdRegister;

class UnitUpdate;

class UnitRegister;

class JobTypeUpdate;

class JobTypeRegister;

class StateUpdate;

class StateRegister;

// type definitions
/**
 * The ObjectPath type (defined as an alias).
 */
typedef ::std::string ObjectPath;

/**
 * Cancel:
 * 		The method cancels the job. Note that this will remove a job from the queue if it is not yet executed
 * 		but generally will not cause a job that is already in the process of being executed to be aborted. This operation
 * 		may also be requested via the ?CancelJob() method of the Manager object (see above),
 * 		which is sometimes useful to reduce roundtrips.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelRequest;

/**
 * Cancel:
 * 		The method cancels the job. Note that this will remove a job from the queue if it is not yet executed
 * 		but generally will not cause a job that is already in the process of being executed to be aborted. This operation
 * 		may also be requested via the ?CancelJob() method of the Manager object (see above),
 * 		which is sometimes useful to reduce roundtrips.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelResponse;

/**
 * If the meaning of "CancelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelError;

/**
 * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
 * 		only assigned once.
 */
typedef IdUpdate IdSet;

/**
 * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
 * 		only assigned once.
 */
typedef IdUpdate IdGet;

/**
 * If the meaning of "IdError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IdError;

/**
 * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
 * 		and a bus path to the unit's object.
 */
typedef UnitUpdate UnitSet;

/**
 * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
 * 		and a bus path to the unit's object.
 */
typedef UnitUpdate UnitGet;

/**
 * If the meaning of "UnitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnitError;

/**
 * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
 * 		try-restart, reload-or-start. Note that later versions might define additional values.
 */
typedef JobTypeUpdate JobTypeSet;

/**
 * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
 * 		try-restart, reload-or-start. Note that later versions might define additional values.
 */
typedef JobTypeUpdate JobTypeGet;

/**
 * If the meaning of "JobTypeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError JobTypeError;

/**
 * State  refers to the job's state and is one of waiting and running. The former indicates that a job
 * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
 */
typedef StateUpdate StateSet;

/**
 * State  refers to the job's state and is one of waiting and running. The former indicates that a job
 * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
 */
typedef StateUpdate StateGet;

/**
 * If the meaning of "StateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StateError;


/**
 * If the meaning of "unit" isn't clear, then there should be a description here.
 */
class unit {
public:

    /**
     * Default constructor
     */
    inline  unit ();

    /**
     * Copy constructor
     */
    inline  unit (const unit &rhs);

    /**
     * All fields constructor
     */
    inline  unit (const ::std::string& unitName_, const ::std::string& busPath_);

    /**
     * Destructor
     */
    inline  ~unit();

    /**
     * Assignment operator
     */
    inline unit& operator = (const unit& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const unit& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const unit& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const unit& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const unit& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "unitName"

    static const int kUnitName = 0;

    /**
     * Clears the field "unitName".
     *
     * The field will be set to its default value. The hasUnitName()
     * method will return false.
     */
    inline void clearUnitName();

    /**
     * Checks whether the field "unitName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnitName()). Otherwise it will return false.
     */
    inline bool hasUnitName () const;

    /**
     * Returns the value of the member "unitName".
     *
     * If the meaning of "unitName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unitName"
     */
    inline const ::std::string& getUnitName () const;

    /**
     * Retrieves the value of the field "unitName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "unitName".
     */
    inline ::std::string& getUnitNameMutable ();

    /**
     * Sets the value of the member "unitName".
     *
     * If the meaning of "unitName" isn't clear, then there should be a description here.
     *
     * @param unitName The value which will be set
     */
    inline void setUnitName (const ::std::string& unitName_);

    /**
     * Sets the value of the member "unitName".
     *
     * If the meaning of "unitName" isn't clear, then there should be a description here.
     *
     * @param unitName The value which will be set
     */
    inline void setUnitName (const char* unitName_);

    /**
     * Sets the value of the member "unitName".
     *
     * If the meaning of "unitName" isn't clear, then there should be a description here.
     *
     * @param unitName The value which will be set
     */
    inline void setUnitName (const char* value, size_t size);

    // API of field "busPath"

    static const int kBusPath = 1;

    /**
     * Clears the field "busPath".
     *
     * The field will be set to its default value. The hasBusPath()
     * method will return false.
     */
    inline void clearBusPath();

    /**
     * Checks whether the field "busPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBusPath()). Otherwise it will return false.
     */
    inline bool hasBusPath () const;

    /**
     * Returns the value of the member "busPath".
     *
     * If the meaning of "busPath" isn't clear, then there should be a description here.
     *
     * @return The value of the field "busPath"
     */
    inline const ::std::string& getBusPath () const;

    /**
     * Retrieves the value of the field "busPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "busPath".
     */
    inline ::std::string& getBusPathMutable ();

    /**
     * Sets the value of the member "busPath".
     *
     * If the meaning of "busPath" isn't clear, then there should be a description here.
     *
     * @param busPath The value which will be set
     */
    inline void setBusPath (const ::std::string& busPath_);

    /**
     * Sets the value of the member "busPath".
     *
     * If the meaning of "busPath" isn't clear, then there should be a description here.
     *
     * @param busPath The value which will be set
     */
    inline void setBusPath (const char* busPath_);

    /**
     * Sets the value of the member "busPath".
     *
     * If the meaning of "busPath" isn't clear, then there should be a description here.
     *
     * @param busPath The value which will be set
     */
    inline void setBusPath (const char* value, size_t size);

    static const unit &getDefaultInstance();

private:

    inline void set_has_unitName ();

    inline void clear_has_unitName ();

    inline void set_has_busPath ();

    inline void clear_has_busPath ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _unitName;

    ::std::string _busPath;

};

/**
 * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
 * 		only assigned once.
 */
class IdUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IdUpdate ();

    /**
     * Copy constructor
     */
    inline  IdUpdate (const IdUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IdUpdate (uint32 Id_);

    /**
     * Destructor
     */
    inline virtual  ~IdUpdate();

    /**
     * Assignment operator
     */
    inline IdUpdate& operator = (const IdUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IdUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IdUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IdUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IdUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Id"

    static const int kId = 0;

    /**
     * Clears the field "Id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "Id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "Id".
     *
     * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
     * 		only assigned once.
     *
     * @return The value of the field "Id"
     */
    inline uint32 getId () const;

    /**
     * Sets the value of the member "Id".
     *
     * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
     * 		only assigned once.
     *
     * @param Id The value which will be set
     */
    inline void setId (uint32 Id_);

    static const IdUpdate &getDefaultInstance();

private:

    inline void set_has_Id ();

    inline void clear_has_Id ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Id;

};

/**
 * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
 * 		only assigned once.
 */
class IdRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IdRegister ();

    /**
     * Copy constructor
     */
    inline  IdRegister (const IdRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IdRegister();

    /**
     * Assignment operator
     */
    inline IdRegister& operator = (const IdRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IdRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IdRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IdRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IdRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IdRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
 * 		and a bus path to the unit's object.
 */
class UnitUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitUpdate ();

    /**
     * Copy constructor
     */
    inline  UnitUpdate (const UnitUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UnitUpdate (const unit& Unit_);

    /**
     * Destructor
     */
    inline virtual  ~UnitUpdate();

    /**
     * Assignment operator
     */
    inline UnitUpdate& operator = (const UnitUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Unit"

    static const int kUnit = 0;

    /**
     * Clears the field "Unit".
     *
     * The field will be set to its default value. The hasUnit()
     * method will return false.
     */
    inline void clearUnit();

    /**
     * Checks whether the field "Unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnit()). Otherwise it will return false.
     */
    inline bool hasUnit () const;

    /**
     * Returns the value of the member "Unit".
     *
     * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
     * 		and a bus path to the unit's object.
     *
     * @return The value of the field "Unit"
     */
    inline const unit& getUnit () const;

    /**
     * Retrieves the value of the field "Unit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Unit".
     */
    inline unit& getUnitMutable ();

    /**
     * Sets the value of the member "Unit".
     *
     * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
     * 		and a bus path to the unit's object.
     *
     * @param Unit The value which will be set
     */
    inline void setUnit (const unit& Unit_);

    static const UnitUpdate &getDefaultInstance();

private:

    inline void set_has_Unit ();

    inline void clear_has_Unit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    unit _Unit;

};

/**
 * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
 * 		and a bus path to the unit's object.
 */
class UnitRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnitRegister ();

    /**
     * Copy constructor
     */
    inline  UnitRegister (const UnitRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UnitRegister();

    /**
     * Assignment operator
     */
    inline UnitRegister& operator = (const UnitRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnitRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnitRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnitRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnitRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UnitRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
 * 		try-restart, reload-or-start. Note that later versions might define additional values.
 */
class JobTypeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JobTypeUpdate ();

    /**
     * Copy constructor
     */
    inline  JobTypeUpdate (const JobTypeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  JobTypeUpdate (const ::std::string& JobType_);

    /**
     * Destructor
     */
    inline virtual  ~JobTypeUpdate();

    /**
     * Assignment operator
     */
    inline JobTypeUpdate& operator = (const JobTypeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JobTypeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JobTypeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JobTypeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JobTypeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobType"

    static const int kJobType = 0;

    /**
     * Clears the field "JobType".
     *
     * The field will be set to its default value. The hasJobType()
     * method will return false.
     */
    inline void clearJobType();

    /**
     * Checks whether the field "JobType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobType()). Otherwise it will return false.
     */
    inline bool hasJobType () const;

    /**
     * Returns the value of the member "JobType".
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     *
     * @return The value of the field "JobType"
     */
    inline const ::std::string& getJobType () const;

    /**
     * Retrieves the value of the field "JobType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobType".
     */
    inline ::std::string& getJobTypeMutable ();

    /**
     * Sets the value of the member "JobType".
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     *
     * @param JobType The value which will be set
     */
    inline void setJobType (const ::std::string& JobType_);

    /**
     * Sets the value of the member "JobType".
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     *
     * @param JobType The value which will be set
     */
    inline void setJobType (const char* JobType_);

    /**
     * Sets the value of the member "JobType".
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     *
     * @param JobType The value which will be set
     */
    inline void setJobType (const char* value, size_t size);

    static const JobTypeUpdate &getDefaultInstance();

private:

    inline void set_has_JobType ();

    inline void clear_has_JobType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _JobType;

};

/**
 * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
 * 		try-restart, reload-or-start. Note that later versions might define additional values.
 */
class JobTypeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  JobTypeRegister ();

    /**
     * Copy constructor
     */
    inline  JobTypeRegister (const JobTypeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~JobTypeRegister();

    /**
     * Assignment operator
     */
    inline JobTypeRegister& operator = (const JobTypeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JobTypeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JobTypeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JobTypeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JobTypeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const JobTypeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * State  refers to the job's state and is one of waiting and running. The former indicates that a job
 * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
 */
class StateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StateUpdate ();

    /**
     * Copy constructor
     */
    inline  StateUpdate (const StateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StateUpdate (const ::std::string& State_);

    /**
     * Destructor
     */
    inline virtual  ~StateUpdate();

    /**
     * Assignment operator
     */
    inline StateUpdate& operator = (const StateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     *
     * @return The value of the field "State"
     */
    inline const ::std::string& getState () const;

    /**
     * Retrieves the value of the field "State" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "State".
     */
    inline ::std::string& getStateMutable ();

    /**
     * Sets the value of the member "State".
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     *
     * @param State The value which will be set
     */
    inline void setState (const ::std::string& State_);

    /**
     * Sets the value of the member "State".
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     *
     * @param State The value which will be set
     */
    inline void setState (const char* State_);

    /**
     * Sets the value of the member "State".
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     *
     * @param State The value which will be set
     */
    inline void setState (const char* value, size_t size);

    static const StateUpdate &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _State;

};

/**
 * State  refers to the job's state and is one of waiting and running. The former indicates that a job
 * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
 */
class StateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StateRegister ();

    /**
     * Copy constructor
     */
    inline  StateRegister (const StateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StateRegister();

    /**
     * Assignment operator
     */
    inline StateRegister& operator = (const StateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  unit::unit ()  :
    _unitName (),
    _busPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  unit::unit (const unit &rhs)  :
    _unitName (),
    _busPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  unit::unit (const ::std::string& unitName_, const ::std::string& busPath_)  :
    _unitName (unitName_),
    _busPath (busPath_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unitName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (busPath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  unit::~unit() {
}

inline unit& unit::operator = (const unit& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUnitName()) {
            setUnitName(rhs.getUnitName());
        } else {
            clearUnitName();
        }
        if (rhs.hasBusPath()) {
            setBusPath(rhs.getBusPath());
        } else {
            clearBusPath();
        }
    }
    return *this;
}

inline bool unit::operator == (const unit& rhs) const {
    return (((!hasUnitName() && !rhs.hasUnitName()) || getUnitName() == rhs.getUnitName()) &&
        ((!hasBusPath() && !rhs.hasBusPath()) || getBusPath() == rhs.getBusPath()));
}

inline bool unit::operator != (const unit& rhs) const {
    return ! (*this == rhs);
}

inline bool unit::operator < (const unit& rhs) const {
    if (hasUnitName() || rhs.hasUnitName()) {
        if (getUnitName() < rhs.getUnitName()) return true;
        if (getUnitName() > rhs.getUnitName()) return false;
    }
    if (hasBusPath() || rhs.hasBusPath()) {
        if (getBusPath() < rhs.getBusPath()) return true;
        if (getBusPath() > rhs.getBusPath()) return false;
    }
    return false;
}

inline bool unit::operator > (const unit& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void unit::clear() {
    clearUnitName();
    clearBusPath();
}

inline void unit::clearUnitName() {
    if (hasUnitName()) {
         clear_has_unitName();
        _unitName.clear();
     }
}

inline bool unit::hasUnitName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& unit::getUnitName () const {
    return _unitName;
}

inline ::std::string& unit::getUnitNameMutable () {
    set_has_unitName();
    return _unitName;
}

inline void unit::setUnitName (const ::std::string& unitName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unitName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unitName();
    this->_unitName = unitName_;
}

inline void unit::setUnitName (const char* unitName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (unitName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unitName();
    this->_unitName.assign(unitName_);
}

inline void unit::setUnitName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_unitName();
    this->_unitName.assign(value, size);
}

inline void unit::clearBusPath() {
    if (hasBusPath()) {
         clear_has_busPath();
        _busPath.clear();
     }
}

inline bool unit::hasBusPath () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& unit::getBusPath () const {
    return _busPath;
}

inline ::std::string& unit::getBusPathMutable () {
    set_has_busPath();
    return _busPath;
}

inline void unit::setBusPath (const ::std::string& busPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (busPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_busPath();
    this->_busPath = busPath_;
}

inline void unit::setBusPath (const char* busPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (busPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_busPath();
    this->_busPath.assign(busPath_);
}

inline void unit::setBusPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_busPath();
    this->_busPath.assign(value, size);
}

inline void unit::set_has_unitName () {
    _has_bits_[0] |= 1u << 0;
}

inline void unit::clear_has_unitName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void unit::set_has_busPath () {
    _has_bits_[0] |= 1u << 1;
}

inline void unit::clear_has_busPath () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  IdUpdate::IdUpdate ()  :
    _Id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IdUpdate::IdUpdate (const IdUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IdUpdate::IdUpdate (uint32 Id_)  :
    _Id (Id_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  IdUpdate::~IdUpdate() {
}

inline IdUpdate& IdUpdate::operator = (const IdUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasId()) {
            setId(rhs.getId());
        } else {
            clearId();
        }
    }
    return *this;
}

inline bool IdUpdate::operator == (const IdUpdate& rhs) const {
    return (((!hasId() && !rhs.hasId()) || getId() == rhs.getId()));
}

inline bool IdUpdate::operator != (const IdUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool IdUpdate::operator < (const IdUpdate& rhs) const {
    if (hasId() || rhs.hasId()) {
        if (getId() < rhs.getId()) return true;
        if (getId() > rhs.getId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* IdUpdate::clone() {
    return new IdUpdate(*this);
}

inline bool IdUpdate::operator > (const IdUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IdUpdate::clear() {
    clearId();
}

inline void IdUpdate::clearId() {
    if (hasId()) {
         clear_has_Id();
        _Id = 0u;
     }
}

inline bool IdUpdate::hasId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 IdUpdate::getId () const {
    return _Id;
}

inline void IdUpdate::setId (uint32 Id_) {
    set_has_Id();
    this->_Id = Id_;
}

inline void IdUpdate::set_has_Id () {
    _has_bits_[0] |= 1u << 0;
}

inline void IdUpdate::clear_has_Id () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  IdRegister::IdRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IdRegister::IdRegister (const IdRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IdRegister::~IdRegister() {
}

inline IdRegister& IdRegister::operator = (const IdRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool IdRegister::operator == (const IdRegister& ) const {
    return true;
}

inline bool IdRegister::operator != (const IdRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool IdRegister::operator < (const IdRegister& ) const {
    return false;
}

inline ::asf::core::Payload* IdRegister::clone() {
    return new IdRegister(*this);
}

inline bool IdRegister::operator > (const IdRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IdRegister::clear() {
}

inline  UnitUpdate::UnitUpdate ()  :
    _Unit ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnitUpdate::UnitUpdate (const UnitUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Unit ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnitUpdate::UnitUpdate (const unit& Unit_)  :
    _Unit (Unit_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnitUpdate::~UnitUpdate() {
}

inline UnitUpdate& UnitUpdate::operator = (const UnitUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUnit()) {
            setUnit(rhs.getUnit());
        } else {
            clearUnit();
        }
    }
    return *this;
}

inline bool UnitUpdate::operator == (const UnitUpdate& rhs) const {
    return (((!hasUnit() && !rhs.hasUnit()) || getUnit() == rhs.getUnit()));
}

inline bool UnitUpdate::operator != (const UnitUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool UnitUpdate::operator < (const UnitUpdate& rhs) const {
    if (hasUnit() || rhs.hasUnit()) {
        if (getUnit() < rhs.getUnit()) return true;
        if (getUnit() > rhs.getUnit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnitUpdate::clone() {
    return new UnitUpdate(*this);
}

inline bool UnitUpdate::operator > (const UnitUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnitUpdate::clear() {
    clearUnit();
}

inline void UnitUpdate::clearUnit() {
    if (hasUnit()) {
         clear_has_Unit();
        _Unit.clear();
     }
}

inline bool UnitUpdate::hasUnit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const unit& UnitUpdate::getUnit () const {
    return _Unit;
}

inline unit& UnitUpdate::getUnitMutable () {
    set_has_Unit();
    return _Unit;
}

inline void UnitUpdate::setUnit (const unit& Unit_) {
    set_has_Unit();
    this->_Unit = Unit_;
}

inline void UnitUpdate::set_has_Unit () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnitUpdate::clear_has_Unit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UnitRegister::UnitRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnitRegister::UnitRegister (const UnitRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnitRegister::~UnitRegister() {
}

inline UnitRegister& UnitRegister::operator = (const UnitRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool UnitRegister::operator == (const UnitRegister& ) const {
    return true;
}

inline bool UnitRegister::operator != (const UnitRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool UnitRegister::operator < (const UnitRegister& ) const {
    return false;
}

inline ::asf::core::Payload* UnitRegister::clone() {
    return new UnitRegister(*this);
}

inline bool UnitRegister::operator > (const UnitRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnitRegister::clear() {
}

inline  JobTypeUpdate::JobTypeUpdate ()  :
    _JobType ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  JobTypeUpdate::JobTypeUpdate (const JobTypeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _JobType ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  JobTypeUpdate::JobTypeUpdate (const ::std::string& JobType_)  :
    _JobType (JobType_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (JobType_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  JobTypeUpdate::~JobTypeUpdate() {
}

inline JobTypeUpdate& JobTypeUpdate::operator = (const JobTypeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobType()) {
            setJobType(rhs.getJobType());
        } else {
            clearJobType();
        }
    }
    return *this;
}

inline bool JobTypeUpdate::operator == (const JobTypeUpdate& rhs) const {
    return (((!hasJobType() && !rhs.hasJobType()) || getJobType() == rhs.getJobType()));
}

inline bool JobTypeUpdate::operator != (const JobTypeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool JobTypeUpdate::operator < (const JobTypeUpdate& rhs) const {
    if (hasJobType() || rhs.hasJobType()) {
        if (getJobType() < rhs.getJobType()) return true;
        if (getJobType() > rhs.getJobType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* JobTypeUpdate::clone() {
    return new JobTypeUpdate(*this);
}

inline bool JobTypeUpdate::operator > (const JobTypeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void JobTypeUpdate::clear() {
    clearJobType();
}

inline void JobTypeUpdate::clearJobType() {
    if (hasJobType()) {
         clear_has_JobType();
        _JobType.clear();
     }
}

inline bool JobTypeUpdate::hasJobType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& JobTypeUpdate::getJobType () const {
    return _JobType;
}

inline ::std::string& JobTypeUpdate::getJobTypeMutable () {
    set_has_JobType();
    return _JobType;
}

inline void JobTypeUpdate::setJobType (const ::std::string& JobType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (JobType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_JobType();
    this->_JobType = JobType_;
}

inline void JobTypeUpdate::setJobType (const char* JobType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (JobType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_JobType();
    this->_JobType.assign(JobType_);
}

inline void JobTypeUpdate::setJobType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_JobType();
    this->_JobType.assign(value, size);
}

inline void JobTypeUpdate::set_has_JobType () {
    _has_bits_[0] |= 1u << 0;
}

inline void JobTypeUpdate::clear_has_JobType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  JobTypeRegister::JobTypeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  JobTypeRegister::JobTypeRegister (const JobTypeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  JobTypeRegister::~JobTypeRegister() {
}

inline JobTypeRegister& JobTypeRegister::operator = (const JobTypeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool JobTypeRegister::operator == (const JobTypeRegister& ) const {
    return true;
}

inline bool JobTypeRegister::operator != (const JobTypeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool JobTypeRegister::operator < (const JobTypeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* JobTypeRegister::clone() {
    return new JobTypeRegister(*this);
}

inline bool JobTypeRegister::operator > (const JobTypeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void JobTypeRegister::clear() {
}

inline  StateUpdate::StateUpdate ()  :
    _State ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StateUpdate::StateUpdate (const StateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _State ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StateUpdate::StateUpdate (const ::std::string& State_)  :
    _State (State_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StateUpdate::~StateUpdate() {
}

inline StateUpdate& StateUpdate::operator = (const StateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
    }
    return *this;
}

inline bool StateUpdate::operator == (const StateUpdate& rhs) const {
    return (((!hasState() && !rhs.hasState()) || getState() == rhs.getState()));
}

inline bool StateUpdate::operator != (const StateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool StateUpdate::operator < (const StateUpdate& rhs) const {
    if (hasState() || rhs.hasState()) {
        if (getState() < rhs.getState()) return true;
        if (getState() > rhs.getState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StateUpdate::clone() {
    return new StateUpdate(*this);
}

inline bool StateUpdate::operator > (const StateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StateUpdate::clear() {
    clearState();
}

inline void StateUpdate::clearState() {
    if (hasState()) {
         clear_has_State();
        _State.clear();
     }
}

inline bool StateUpdate::hasState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StateUpdate::getState () const {
    return _State;
}

inline ::std::string& StateUpdate::getStateMutable () {
    set_has_State();
    return _State;
}

inline void StateUpdate::setState (const ::std::string& State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State = State_;
}

inline void StateUpdate::setState (const char* State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(State_);
}

inline void StateUpdate::setState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(value, size);
}

inline void StateUpdate::set_has_State () {
    _has_bits_[0] |= 1u << 0;
}

inline void StateUpdate::clear_has_State () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StateRegister::StateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StateRegister::StateRegister (const StateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StateRegister::~StateRegister() {
}

inline StateRegister& StateRegister::operator = (const StateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool StateRegister::operator == (const StateRegister& ) const {
    return true;
}

inline bool StateRegister::operator != (const StateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool StateRegister::operator < (const StateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* StateRegister::clone() {
    return new StateRegister(*this);
}

inline bool StateRegister::operator > (const StateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StateRegister::clear() {
}

} // namespace Job
} // namespace systemd1
} // namespace freedesktop
} // namespace org

#endif // ORG_FREEDESKTOP_SYSTEMD1_JOB_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
