/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_WSALERTS_MAIN_FIPROXY_H
#define SXM_WSALERTS_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "sxm_main_fi_types.h"
#include "sxm_wsalerts_main_fi.h"
#include "sxm_wsalerts_main_fi_types.h"
#include "sxm_wsalerts_main_fi_typesConst.h"
#include <string>
#include <vector>

namespace sxm_wsalerts_main_fi {

class Sxm_wsalerts_main_fiProxy;

class AnnounceWSAlertCallbackIF {
public:
    virtual ~AnnounceWSAlertCallbackIF() {}

    virtual void onAnnounceWSAlertError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< AnnounceWSAlertError >& error) = 0;

    virtual void onAnnounceWSAlertResult(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< AnnounceWSAlertResult >& result) = 0;
};

class CurrentWSAlertsCallbackIF {
public:
    virtual ~CurrentWSAlertsCallbackIF() {}

    virtual void onCurrentWSAlertsError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< CurrentWSAlertsError >& error) = 0;

    virtual void onCurrentWSAlertsStatus(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< CurrentWSAlertsStatus >& status) = 0;
};

class GetWSAlertMsgDetailsCallbackIF {
public:
    virtual ~GetWSAlertMsgDetailsCallbackIF() {}

    virtual void onGetWSAlertMsgDetailsError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< GetWSAlertMsgDetailsError >& error) = 0;

    virtual void onGetWSAlertMsgDetailsResult(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< GetWSAlertMsgDetailsResult >& result) = 0;
};

class GetWSAlertMsgListCallbackIF {
public:
    virtual ~GetWSAlertMsgListCallbackIF() {}

    virtual void onGetWSAlertMsgListError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< GetWSAlertMsgListError >& error) = 0;

    virtual void onGetWSAlertMsgListResult(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< GetWSAlertMsgListResult >& result) = 0;
};

class GetWeatherAlertDataCallbackIF {
public:
    virtual ~GetWeatherAlertDataCallbackIF() {}

    virtual void onGetWeatherAlertDataError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< GetWeatherAlertDataError >& error) = 0;

    virtual void onGetWeatherAlertDataResult(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< GetWeatherAlertDataResult >& result) = 0;
};

class SetListsConfigCallbackIF {
public:
    virtual ~SetListsConfigCallbackIF() {}

    virtual void onSetListsConfigError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< SetListsConfigError >& error) = 0;

    virtual void onSetListsConfigResult(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< SetListsConfigResult >& result) = 0;
};

class SetWSAlertsConfigCallbackIF {
public:
    virtual ~SetWSAlertsConfigCallbackIF() {}

    virtual void onSetWSAlertsConfigError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< SetWSAlertsConfigError >& error) = 0;

    virtual void onSetWSAlertsConfigResult(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< SetWSAlertsConfigResult >& result) = 0;
};

class SetWSAlertsProjectConfigCallbackIF {
public:
    virtual ~SetWSAlertsProjectConfigCallbackIF() {}

    virtual void onSetWSAlertsProjectConfigError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< SetWSAlertsProjectConfigError >& error) = 0;

    virtual void onSetWSAlertsProjectConfigResult(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< SetWSAlertsProjectConfigResult >& result) = 0;
};

class SxmDataServiceStatusCallbackIF {
public:
    virtual ~SxmDataServiceStatusCallbackIF() {}

    virtual void onSxmDataServiceStatusError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusError >& error) = 0;

    virtual void onSxmDataServiceStatusStatus(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusStatus >& status) = 0;
};

class SxmListModeCallbackIF {
public:
    virtual ~SxmListModeCallbackIF() {}

    virtual void onSxmListModeError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeError >& error) = 0;

    virtual void onSxmListModeStatus(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeStatus >& status) = 0;
};

class ValidateWSAlertMessageCallbackIF {
public:
    virtual ~ValidateWSAlertMessageCallbackIF() {}

    virtual void onValidateWSAlertMessageError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< ValidateWSAlertMessageError >& error) = 0;

    virtual void onValidateWSAlertMessageResult(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< ValidateWSAlertMessageResult >& result) = 0;
};

class WSAlertAnnounceStatusCallbackIF {
public:
    virtual ~WSAlertAnnounceStatusCallbackIF() {}

    virtual void onWSAlertAnnounceStatusError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< WSAlertAnnounceStatusError >& error) = 0;

    virtual void onWSAlertAnnounceStatusStatus(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< WSAlertAnnounceStatusStatus >& status) = 0;
};

class WSAlertsInfoListStatusCallbackIF {
public:
    virtual ~WSAlertsInfoListStatusCallbackIF() {}

    virtual void onWSAlertsInfoListStatusError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< WSAlertsInfoListStatusError >& error) = 0;

    virtual void onWSAlertsInfoListStatusStatus(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< WSAlertsInfoListStatusStatus >& status) = 0;
};

class WeatherAlertDataCallbackIF {
public:
    virtual ~WeatherAlertDataCallbackIF() {}

    virtual void onWeatherAlertDataError(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< WeatherAlertDataError >& error) = 0;

    virtual void onWeatherAlertDataStatus(const ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >& proxy, const ::boost::shared_ptr< WeatherAlertDataStatus >& status) = 0;
};

class Sxm_wsalerts_main_fiProxyCallback;

/**
 * Sxm_wsalerts_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'sxm_wsalerts_main_fi' (specified in file
 * sxm_wsalerts_main_fi.xml).
 *
 * CCA Functional Interface 'sxm_wsalerts_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification
 *
 * Version: $Revision:   0.1  $
 *
 * Author: Satish Muchhala
 *
 * Date: $Date:   July 07 2016  $
 *
 * Department: ECV2
 *
 * Title: sxm_wsalerts_main_fi
 *
 * <b>Description of 'sxm_wsalerts_main_fi':</b>
 *
 * RBEI/ECM
 */
class Sxm_wsalerts_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Sxm_wsalerts_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_wsalerts_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_wsalerts_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Sxm_wsalerts_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Sxm_wsalerts_main_fiProxy();

    // Method 'GetWSAlertMsgList'

    /**
     * Call the method 'GetWSAlertMsgList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetWSAlertMsgList'</b>:
     *
     * This method is used to get the Weather and Security Alert Message list for nearby and near destination location based on "Alert Settings".
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ListId List ID, values according to T_e8_SxmListType
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetWSAlertMsgListStart(GetWSAlertMsgListCallbackIF& cb, uint32 listId);

    // Method 'SetListsConfig'

    /**
     * Call the method 'SetListsConfig'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetListsConfig'</b>:
     *
     * This method is used to configure all lists
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Config Currently in T_SxmListsConfig, Capacity is passed.
     * Capacity for Weather alerts is "1". This Method is to provide a control over capacity.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetListsConfigStart(SetListsConfigCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListsConfig& config);

    // Method 'GetWeatherAlertData'

    /**
     * Call the method 'GetWeatherAlertData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetWeatherAlertData'</b>:
     *
     * Provides the Weather and Security Alert messages with shape information for the whole US to map.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetWeatherAlertDataStart(GetWeatherAlertDataCallbackIF& cb);

    // Method 'SetWSAlertsConfig'

    /**
     * Call the method 'SetWSAlertsConfig'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetWSAlertsConfig'</b>:
     *
     * This method is used to set the last saved configuration to enable and disable the alerts
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AlertTypeIDs List of Alert type ID for Weather and Security
     *
     * @param WSAlertAction To enable,disable individual alert types and the group of warnings or watches
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetWSAlertsConfigStart(SetWSAlertsConfigCallbackIF& cb, const ::std::vector< ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes >& alertTypeIDs, ::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType wSAlertAction);

    // Method 'GetWSAlertMsgDetails'

    /**
     * Call the method 'GetWSAlertMsgDetails'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetWSAlertMsgDetails'</b>:
     *
     * This method is used to get the details of the particular alert message.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param MessageID Message ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetWSAlertMsgDetailsStart(GetWSAlertMsgDetailsCallbackIF& cb, uint32 messageID);

    // Method 'AnnounceWSAlert'

    /**
     * Call the method 'AnnounceWSAlert'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'AnnounceWSAlert'</b>:
     *
     * Weather and Security Alerts announcement
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param MessageID Message ID
     *
     * @param Action Weather and Security Alert announcement action
     *
     * @param Text Weather and Security Alert announcement text
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAnnounceWSAlertStart(AnnounceWSAlertCallbackIF& cb, uint32 messageID, ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction action, const ::std::string& text);

    // Method 'SetWSAlertsProjectConfig'

    /**
     * Call the method 'SetWSAlertsProjectConfig'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetWSAlertsProjectConfig'</b>:
     *
     * This method is used to set the Project specific configuration data for alerts.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AlertConfig List of Alert Configuration
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetWSAlertsProjectConfigStart(SetWSAlertsProjectConfigCallbackIF& cb, const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertConfig >& alertConfig);

    // Method 'ValidateWSAlertMessage'

    /**
     * Call the method 'ValidateWSAlertMessage'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ValidateWSAlertMessage'</b>:
     *
     * This method is used to verify the perticular alert message is currently valid or expired.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param MessageID Message ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendValidateWSAlertMessageStart(ValidateWSAlertMessageCallbackIF& cb, uint32 messageID);

    // Property 'WSAlertsInfoListStatus'

    /**
     * Notify on the property 'WSAlertsInfoListStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'WSAlertsInfoListStatus'</b>:
     *
     * Weather and Security Alerts information result
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWSAlertsInfoListStatusUpReg(WSAlertsInfoListStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'WSAlertsInfoListStatus'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'WSAlertsInfoListStatus'</b>:
     *
     * Weather and Security Alerts information result
     *
     * @param act The act which was previously returned by the
     * sendWSAlertsInfoListStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendWSAlertsInfoListStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'WSAlertsInfoListStatus'.
     */
    void sendWSAlertsInfoListStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'WSAlertsInfoListStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasWSAlertsInfoListStatus() returns true.
     *
     * @return the previously received value of the property 'WSAlertsInfoListStatus'.
     */
    const WSAlertsInfoListStatusStatus& getWSAlertsInfoListStatus() const;

    /**
     * Determines whether a status message for the property 'WSAlertsInfoListStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWSAlertsInfoListStatus() const;

    /**
     * Request the value of the property 'WSAlertsInfoListStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'WSAlertsInfoListStatus'</b>:
     *
     * Weather and Security Alerts information result
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWSAlertsInfoListStatusGet(WSAlertsInfoListStatusCallbackIF& cb);

    // Property 'SxmDataServiceStatus'

    /**
     * Notify on the property 'SxmDataServiceStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Weather and Security Alerts Data Service
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmDataServiceStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Weather and Security Alerts Data Service
     *
     * @param act The act which was previously returned by the
     * sendSxmDataServiceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmDataServiceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmDataServiceStatus'.
     */
    void sendSxmDataServiceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmDataServiceStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSxmDataServiceStatus() returns true.
     *
     * @return the previously received value of the property 'SxmDataServiceStatus'.
     */
    const SxmDataServiceStatusStatus& getSxmDataServiceStatus() const;

    /**
     * Determines whether a status message for the property 'SxmDataServiceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmDataServiceStatus() const;

    /**
     * Request the value of the property 'SxmDataServiceStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Weather and Security Alerts Data Service
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb);

    // Property 'SxmListMode'

    /**
     * Notify on the property 'SxmListMode'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Weather and Security Alerts List.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeUpReg(SxmListModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmListMode'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Weather and Security Alerts List.
     *
     * @param act The act which was previously returned by the
     * sendSxmListModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmListModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmListMode'.
     */
    void sendSxmListModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmListMode' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSxmListMode() returns true.
     *
     * @return the previously received value of the property 'SxmListMode'.
     */
    const SxmListModeStatus& getSxmListMode() const;

    /**
     * Determines whether a status message for the property 'SxmListMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmListMode() const;

    /**
     * Set the value of the property 'SxmListMode'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Weather and Security Alerts List.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param ListMode Set the Mode of Weather and Security Alerts List
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeSet(SxmListModeCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListMode& listMode);

    // Property 'WeatherAlertData'

    /**
     * Notify on the property 'WeatherAlertData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'WeatherAlertData'</b>:
     *
     * Gives the status of the Alert shape data
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWeatherAlertDataUpReg(WeatherAlertDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'WeatherAlertData'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'WeatherAlertData'</b>:
     *
     * Gives the status of the Alert shape data
     *
     * @param act The act which was previously returned by the
     * sendWeatherAlertDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendWeatherAlertDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'WeatherAlertData'.
     */
    void sendWeatherAlertDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'WeatherAlertData' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasWeatherAlertData() returns true.
     *
     * @return the previously received value of the property 'WeatherAlertData'.
     */
    const WeatherAlertDataStatus& getWeatherAlertData() const;

    /**
     * Determines whether a status message for the property 'WeatherAlertData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWeatherAlertData() const;

    /**
     * Request the value of the property 'WeatherAlertData' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'WeatherAlertData'</b>:
     *
     * Gives the status of the Alert shape data
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWeatherAlertDataGet(WeatherAlertDataCallbackIF& cb);

    // Property 'CurrentWSAlerts'

    /**
     * Notify on the property 'CurrentWSAlerts'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'CurrentWSAlerts'</b>:
     *
     * Property update for current WSAlerts to be shown to the user
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCurrentWSAlertsUpReg(CurrentWSAlertsCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CurrentWSAlerts'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CurrentWSAlerts'</b>:
     *
     * Property update for current WSAlerts to be shown to the user
     *
     * @param act The act which was previously returned by the
     * sendCurrentWSAlertsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCurrentWSAlertsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CurrentWSAlerts'.
     */
    void sendCurrentWSAlertsRelUpRegAll ();

    /**
     * Returns the current value of the property 'CurrentWSAlerts' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasCurrentWSAlerts() returns true.
     *
     * @return the previously received value of the property 'CurrentWSAlerts'.
     */
    const CurrentWSAlertsStatus& getCurrentWSAlerts() const;

    /**
     * Determines whether a status message for the property 'CurrentWSAlerts' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCurrentWSAlerts() const;

    /**
     * Request the value of the property 'CurrentWSAlerts' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'CurrentWSAlerts'</b>:
     *
     * Property update for current WSAlerts to be shown to the user
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCurrentWSAlertsGet(CurrentWSAlertsCallbackIF& cb);

    // Property 'WSAlertAnnounceStatus'

    /**
     * Notify on the property 'WSAlertAnnounceStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'WSAlertAnnounceStatus'</b>:
     *
     * Status of the WSAlerts
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWSAlertAnnounceStatusUpReg(WSAlertAnnounceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'WSAlertAnnounceStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'WSAlertAnnounceStatus'</b>:
     *
     * Status of the WSAlerts
     *
     * @param act The act which was previously returned by the
     * sendWSAlertAnnounceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendWSAlertAnnounceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'WSAlertAnnounceStatus'.
     */
    void sendWSAlertAnnounceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'WSAlertAnnounceStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasWSAlertAnnounceStatus() returns true.
     *
     * @return the previously received value of the property 'WSAlertAnnounceStatus'.
     */
    const WSAlertAnnounceStatusStatus& getWSAlertAnnounceStatus() const;

    /**
     * Determines whether a status message for the property 'WSAlertAnnounceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWSAlertAnnounceStatus() const;

    /**
     * Request the value of the property 'WSAlertAnnounceStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'WSAlertAnnounceStatus'</b>:
     *
     * Status of the WSAlerts
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWSAlertAnnounceStatusGet(WSAlertAnnounceStatusCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Sxm_wsalerts_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'WSAlertsInfoListStatus'

    ::asf::core::nullable< WSAlertsInfoListStatusStatus > _wSAlertsInfoListStatus;

    // Property 'SxmDataServiceStatus'

    ::asf::core::nullable< SxmDataServiceStatusStatus > _sxmDataServiceStatus;

    // Property 'SxmListMode'

    ::asf::core::nullable< SxmListModeStatus > _sxmListMode;

    // Property 'WeatherAlertData'

    ::asf::core::nullable< WeatherAlertDataStatus > _weatherAlertData;

    // Property 'CurrentWSAlerts'

    ::asf::core::nullable< CurrentWSAlertsStatus > _currentWSAlerts;

    // Property 'WSAlertAnnounceStatus'

    ::asf::core::nullable< WSAlertAnnounceStatusStatus > _wSAlertAnnounceStatus;

    DECLARE_CLASS_LOGGER();

    friend class Sxm_wsalerts_main_fiProxyCallback;
};

} // namespace sxm_wsalerts_main_fi

#endif // SXM_WSALERTS_MAIN_FIPROXY_H
