/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "sxm_main_fi_types.h"
#include "sxm_wsalerts_main_fiCca.h"
#include "sxm_wsalerts_main_fiJson.h"
#include "sxm_wsalerts_main_fiProxy.h"
#include "sxm_wsalerts_main_fi_types.h"
#include "sxm_wsalerts_main_fi_typesConst.h"
#include <string>
#include <vector>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace sxm_wsalerts_main_fi {

/*static*/ ::asf::core::Logger Sxm_wsalerts_main_fiProxy::_logger ("/sxm_wsalerts_main_fi/Sxm_wsalerts_main_fiProxy");


class Sxm_wsalerts_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Sxm_wsalerts_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Sxm_wsalerts_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_wsalerts_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_GetWSAlertMsgList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::GetWSAlertMsgListResult);
                                setActAndLogResult(message, "GetWSAlertMsgList", reinterpret_cast<act_t>(this), _logger);
                                ((GetWSAlertMsgListCallbackIF*) _callback)->onGetWSAlertMsgListResult (proxy, ::boost::static_pointer_cast<GetWSAlertMsgListResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::GetWSAlertMsgListError);
                                setActAndLogError(message, "GetWSAlertMsgList", reinterpret_cast<act_t>(this), _logger);
                                ((GetWSAlertMsgListCallbackIF*) _callback)->onGetWSAlertMsgListError (proxy, ::boost::static_pointer_cast<GetWSAlertMsgListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetListsConfig: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::SetListsConfigResult);
                                setActAndLogResult(message, "SetListsConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigResult (proxy, ::boost::static_pointer_cast<SetListsConfigResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::SetListsConfigError);
                                setActAndLogError(message, "SetListsConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigError (proxy, ::boost::static_pointer_cast<SetListsConfigError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetWeatherAlertData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::GetWeatherAlertDataResult);
                                setActAndLogResult(message, "GetWeatherAlertData", reinterpret_cast<act_t>(this), _logger);
                                ((GetWeatherAlertDataCallbackIF*) _callback)->onGetWeatherAlertDataResult (proxy, ::boost::static_pointer_cast<GetWeatherAlertDataResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::GetWeatherAlertDataError);
                                setActAndLogError(message, "GetWeatherAlertData", reinterpret_cast<act_t>(this), _logger);
                                ((GetWeatherAlertDataCallbackIF*) _callback)->onGetWeatherAlertDataError (proxy, ::boost::static_pointer_cast<GetWeatherAlertDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetWSAlertsConfig: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::SetWSAlertsConfigResult);
                                setActAndLogResult(message, "SetWSAlertsConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetWSAlertsConfigCallbackIF*) _callback)->onSetWSAlertsConfigResult (proxy, ::boost::static_pointer_cast<SetWSAlertsConfigResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::SetWSAlertsConfigError);
                                setActAndLogError(message, "SetWSAlertsConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetWSAlertsConfigCallbackIF*) _callback)->onSetWSAlertsConfigError (proxy, ::boost::static_pointer_cast<SetWSAlertsConfigError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetWSAlertMsgDetails: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::GetWSAlertMsgDetailsResult);
                                setActAndLogResult(message, "GetWSAlertMsgDetails", reinterpret_cast<act_t>(this), _logger);
                                ((GetWSAlertMsgDetailsCallbackIF*) _callback)->onGetWSAlertMsgDetailsResult (proxy, ::boost::static_pointer_cast<GetWSAlertMsgDetailsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::GetWSAlertMsgDetailsError);
                                setActAndLogError(message, "GetWSAlertMsgDetails", reinterpret_cast<act_t>(this), _logger);
                                ((GetWSAlertMsgDetailsCallbackIF*) _callback)->onGetWSAlertMsgDetailsError (proxy, ::boost::static_pointer_cast<GetWSAlertMsgDetailsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AnnounceWSAlert: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::AnnounceWSAlertResult);
                                setActAndLogResult(message, "AnnounceWSAlert", reinterpret_cast<act_t>(this), _logger);
                                ((AnnounceWSAlertCallbackIF*) _callback)->onAnnounceWSAlertResult (proxy, ::boost::static_pointer_cast<AnnounceWSAlertResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::AnnounceWSAlertError);
                                setActAndLogError(message, "AnnounceWSAlert", reinterpret_cast<act_t>(this), _logger);
                                ((AnnounceWSAlertCallbackIF*) _callback)->onAnnounceWSAlertError (proxy, ::boost::static_pointer_cast<AnnounceWSAlertError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetWSAlertsProjectConfig: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::SetWSAlertsProjectConfigResult);
                                setActAndLogResult(message, "SetWSAlertsProjectConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetWSAlertsProjectConfigCallbackIF*) _callback)->onSetWSAlertsProjectConfigResult (proxy, ::boost::static_pointer_cast<SetWSAlertsProjectConfigResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::SetWSAlertsProjectConfigError);
                                setActAndLogError(message, "SetWSAlertsProjectConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetWSAlertsProjectConfigCallbackIF*) _callback)->onSetWSAlertsProjectConfigError (proxy, ::boost::static_pointer_cast<SetWSAlertsProjectConfigError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ValidateWSAlertMessage: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::ValidateWSAlertMessageResult);
                                setActAndLogResult(message, "ValidateWSAlertMessage", reinterpret_cast<act_t>(this), _logger);
                                ((ValidateWSAlertMessageCallbackIF*) _callback)->onValidateWSAlertMessageResult (proxy, ::boost::static_pointer_cast<ValidateWSAlertMessageResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::ValidateWSAlertMessageError);
                                setActAndLogError(message, "ValidateWSAlertMessage", reinterpret_cast<act_t>(this), _logger);
                                ((ValidateWSAlertMessageCallbackIF*) _callback)->onValidateWSAlertMessageError (proxy, ::boost::static_pointer_cast<ValidateWSAlertMessageError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_WSAlertsInfoListStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::WSAlertsInfoListStatusStatus);
                                setActAndLogStatus(message, "WSAlertsInfoListStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<WSAlertsInfoListStatusStatus> payload = ::boost::static_pointer_cast<WSAlertsInfoListStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< WSAlertsInfoListStatusStatus >& refNullableStatus = proxy->_wSAlertsInfoListStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((WSAlertsInfoListStatusCallbackIF*) _callback)->onWSAlertsInfoListStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WSAlertsInfoListStatusCallbackIF*) _callback)->onWSAlertsInfoListStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::WSAlertsInfoListStatusError);
                                setActAndLogError(message, "WSAlertsInfoListStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WSAlertsInfoListStatusCallbackIF*) _callback)->onWSAlertsInfoListStatusError(proxy, ::boost::static_pointer_cast<WSAlertsInfoListStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SxmDataServiceStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::SxmDataServiceStatusStatus);
                                setActAndLogStatus(message, "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SxmDataServiceStatusStatus> payload = ::boost::static_pointer_cast<SxmDataServiceStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SxmDataServiceStatusStatus >& refNullableStatus = proxy->_sxmDataServiceStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::SxmDataServiceStatusError);
                                setActAndLogError(message, "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusError(proxy, ::boost::static_pointer_cast<SxmDataServiceStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SxmListMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::SxmListModeStatus);
                                setActAndLogStatus(message, "SxmListMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SxmListModeStatus> payload = ::boost::static_pointer_cast<SxmListModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SxmListModeStatus >& refNullableStatus = proxy->_sxmListMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SxmListModeCallbackIF*) _callback)->onSxmListModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::SxmListModeError);
                                setActAndLogError(message, "SxmListMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeError(proxy, ::boost::static_pointer_cast<SxmListModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_WeatherAlertData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::WeatherAlertDataStatus);
                                setActAndLogStatus(message, "WeatherAlertData", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<WeatherAlertDataStatus> payload = ::boost::static_pointer_cast<WeatherAlertDataStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< WeatherAlertDataStatus >& refNullableStatus = proxy->_weatherAlertData;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((WeatherAlertDataCallbackIF*) _callback)->onWeatherAlertDataStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WeatherAlertDataCallbackIF*) _callback)->onWeatherAlertDataStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::WeatherAlertDataError);
                                setActAndLogError(message, "WeatherAlertData", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WeatherAlertDataCallbackIF*) _callback)->onWeatherAlertDataError(proxy, ::boost::static_pointer_cast<WeatherAlertDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CurrentWSAlerts: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::CurrentWSAlertsStatus);
                                setActAndLogStatus(message, "CurrentWSAlerts", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CurrentWSAlertsStatus> payload = ::boost::static_pointer_cast<CurrentWSAlertsStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CurrentWSAlertsStatus >& refNullableStatus = proxy->_currentWSAlerts;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CurrentWSAlertsCallbackIF*) _callback)->onCurrentWSAlertsStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CurrentWSAlertsCallbackIF*) _callback)->onCurrentWSAlertsStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::CurrentWSAlertsError);
                                setActAndLogError(message, "CurrentWSAlerts", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CurrentWSAlertsCallbackIF*) _callback)->onCurrentWSAlertsError(proxy, ::boost::static_pointer_cast<CurrentWSAlertsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_WSAlertAnnounceStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::WSAlertAnnounceStatusStatus);
                                setActAndLogStatus(message, "WSAlertAnnounceStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<WSAlertAnnounceStatusStatus> payload = ::boost::static_pointer_cast<WSAlertAnnounceStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< WSAlertAnnounceStatusStatus >& refNullableStatus = proxy->_wSAlertAnnounceStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((WSAlertAnnounceStatusCallbackIF*) _callback)->onWSAlertAnnounceStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WSAlertAnnounceStatusCallbackIF*) _callback)->onWSAlertAnnounceStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_wsalerts_main_fi::WSAlertAnnounceStatusError);
                                setActAndLogError(message, "WSAlertAnnounceStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WSAlertAnnounceStatusCallbackIF*) _callback)->onWSAlertAnnounceStatusError(proxy, ::boost::static_pointer_cast<WSAlertAnnounceStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Sxm_wsalerts_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_wsalerts_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_GetWSAlertMsgList: {
                ::boost::shared_ptr< GetWSAlertMsgListError > payload (new GetWSAlertMsgListError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetWSAlertMsgList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetWSAlertMsgListCallbackIF*) _callback)->onGetWSAlertMsgListError (proxy, payload);
                return true;
            }
            case FID_SetListsConfig: {
                ::boost::shared_ptr< SetListsConfigError > payload (new SetListsConfigError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetListsConfig", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigError (proxy, payload);
                return true;
            }
            case FID_GetWeatherAlertData: {
                ::boost::shared_ptr< GetWeatherAlertDataError > payload (new GetWeatherAlertDataError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetWeatherAlertData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetWeatherAlertDataCallbackIF*) _callback)->onGetWeatherAlertDataError (proxy, payload);
                return true;
            }
            case FID_SetWSAlertsConfig: {
                ::boost::shared_ptr< SetWSAlertsConfigError > payload (new SetWSAlertsConfigError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetWSAlertsConfig", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetWSAlertsConfigCallbackIF*) _callback)->onSetWSAlertsConfigError (proxy, payload);
                return true;
            }
            case FID_GetWSAlertMsgDetails: {
                ::boost::shared_ptr< GetWSAlertMsgDetailsError > payload (new GetWSAlertMsgDetailsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetWSAlertMsgDetails", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetWSAlertMsgDetailsCallbackIF*) _callback)->onGetWSAlertMsgDetailsError (proxy, payload);
                return true;
            }
            case FID_AnnounceWSAlert: {
                ::boost::shared_ptr< AnnounceWSAlertError > payload (new AnnounceWSAlertError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AnnounceWSAlert", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AnnounceWSAlertCallbackIF*) _callback)->onAnnounceWSAlertError (proxy, payload);
                return true;
            }
            case FID_SetWSAlertsProjectConfig: {
                ::boost::shared_ptr< SetWSAlertsProjectConfigError > payload (new SetWSAlertsProjectConfigError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetWSAlertsProjectConfig", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetWSAlertsProjectConfigCallbackIF*) _callback)->onSetWSAlertsProjectConfigError (proxy, payload);
                return true;
            }
            case FID_ValidateWSAlertMessage: {
                ::boost::shared_ptr< ValidateWSAlertMessageError > payload (new ValidateWSAlertMessageError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ValidateWSAlertMessage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ValidateWSAlertMessageCallbackIF*) _callback)->onValidateWSAlertMessageError (proxy, payload);
                return true;
            }
            case FID_WSAlertsInfoListStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< WSAlertsInfoListStatusError > payload (new WSAlertsInfoListStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WSAlertsInfoListStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((WSAlertsInfoListStatusCallbackIF*) _callback)->onWSAlertsInfoListStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SxmDataServiceStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SxmListMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SxmListMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_WeatherAlertData: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< WeatherAlertDataError > payload (new WeatherAlertDataError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WeatherAlertData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((WeatherAlertDataCallbackIF*) _callback)->onWeatherAlertDataError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CurrentWSAlerts: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< CurrentWSAlertsError > payload (new CurrentWSAlertsError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CurrentWSAlerts", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CurrentWSAlertsCallbackIF*) _callback)->onCurrentWSAlertsError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_WSAlertAnnounceStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< WSAlertAnnounceStatusError > payload (new WSAlertAnnounceStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WSAlertAnnounceStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((WSAlertAnnounceStatusCallbackIF*) _callback)->onWSAlertAnnounceStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Sxm_wsalerts_main_fiProxyCallback::_logger (Sxm_wsalerts_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy > Sxm_wsalerts_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >  proxyNew(new Sxm_wsalerts_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy > Sxm_wsalerts_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >  proxyNew(new Sxm_wsalerts_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy > Sxm_wsalerts_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Sxm_wsalerts_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Sxm_wsalerts_main_fiProxy >  proxyNew(new Sxm_wsalerts_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Sxm_wsalerts_main_fiProxy::Sxm_wsalerts_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Sxm_wsalerts_main_fiProxy::~Sxm_wsalerts_main_fiProxy()
{
    LOG_INFO ("Entering ~Sxm_wsalerts_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Sxm_wsalerts_main_fiProxy::sendGetWSAlertMsgListStart(GetWSAlertMsgListCallbackIF& cb, uint32 listId) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetWSAlertMsgList);
        ::boost::shared_ptr< GetWSAlertMsgListStart > payload (new GetWSAlertMsgListStart());
        payload->setListId(listId);
        CCA_MESSAGE(ccaMessage,header,GetWSAlertMsgListStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetWSAlertMsgList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetWSAlertMsgList);
        ::boost::shared_ptr< GetWSAlertMsgListError > payload (new GetWSAlertMsgListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetWSAlertMsgListError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetWSAlertMsgList", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendSetListsConfigStart(SetListsConfigCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListsConfig& config) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetListsConfig);
        ::boost::shared_ptr< SetListsConfigStart > payload (new SetListsConfigStart());
        payload->setConfig(config);
        CCA_MESSAGE(ccaMessage,header,SetListsConfigStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetListsConfig", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetListsConfig);
        ::boost::shared_ptr< SetListsConfigError > payload (new SetListsConfigError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetListsConfigError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetListsConfig", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendGetWeatherAlertDataStart(GetWeatherAlertDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetWeatherAlertData);
        ::boost::shared_ptr< GetWeatherAlertDataStart > payload (new GetWeatherAlertDataStart());
        CCA_MESSAGE(ccaMessage,header,GetWeatherAlertDataStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetWeatherAlertData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetWeatherAlertData);
        ::boost::shared_ptr< GetWeatherAlertDataError > payload (new GetWeatherAlertDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetWeatherAlertDataError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetWeatherAlertData", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendSetWSAlertsConfigStart(SetWSAlertsConfigCallbackIF& cb, const ::std::vector< ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes >& alertTypeIDs, ::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType wSAlertAction) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetWSAlertsConfig);
        ::boost::shared_ptr< SetWSAlertsConfigStart > payload (new SetWSAlertsConfigStart());
        payload->setAlertTypeIDs(alertTypeIDs);
        payload->setWSAlertAction(wSAlertAction);
        CCA_MESSAGE(ccaMessage,header,SetWSAlertsConfigStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetWSAlertsConfig", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetWSAlertsConfig);
        ::boost::shared_ptr< SetWSAlertsConfigError > payload (new SetWSAlertsConfigError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetWSAlertsConfigError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetWSAlertsConfig", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendGetWSAlertMsgDetailsStart(GetWSAlertMsgDetailsCallbackIF& cb, uint32 messageID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetWSAlertMsgDetails);
        ::boost::shared_ptr< GetWSAlertMsgDetailsStart > payload (new GetWSAlertMsgDetailsStart());
        payload->setMessageID(messageID);
        CCA_MESSAGE(ccaMessage,header,GetWSAlertMsgDetailsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetWSAlertMsgDetails", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetWSAlertMsgDetails);
        ::boost::shared_ptr< GetWSAlertMsgDetailsError > payload (new GetWSAlertMsgDetailsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetWSAlertMsgDetailsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetWSAlertMsgDetails", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendAnnounceWSAlertStart(AnnounceWSAlertCallbackIF& cb, uint32 messageID, ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction action, const ::std::string& text) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AnnounceWSAlert);
        ::boost::shared_ptr< AnnounceWSAlertStart > payload (new AnnounceWSAlertStart());
        payload->setMessageID(messageID);
        payload->setAction(action);
        payload->setText(text);
        CCA_MESSAGE(ccaMessage,header,AnnounceWSAlertStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AnnounceWSAlert", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AnnounceWSAlert);
        ::boost::shared_ptr< AnnounceWSAlertError > payload (new AnnounceWSAlertError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AnnounceWSAlertError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AnnounceWSAlert", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendSetWSAlertsProjectConfigStart(SetWSAlertsProjectConfigCallbackIF& cb, const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertConfig >& alertConfig) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetWSAlertsProjectConfig);
        ::boost::shared_ptr< SetWSAlertsProjectConfigStart > payload (new SetWSAlertsProjectConfigStart());
        payload->setAlertConfig(alertConfig);
        CCA_MESSAGE(ccaMessage,header,SetWSAlertsProjectConfigStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetWSAlertsProjectConfig", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetWSAlertsProjectConfig);
        ::boost::shared_ptr< SetWSAlertsProjectConfigError > payload (new SetWSAlertsProjectConfigError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetWSAlertsProjectConfigError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetWSAlertsProjectConfig", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendValidateWSAlertMessageStart(ValidateWSAlertMessageCallbackIF& cb, uint32 messageID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ValidateWSAlertMessage);
        ::boost::shared_ptr< ValidateWSAlertMessageStart > payload (new ValidateWSAlertMessageStart());
        payload->setMessageID(messageID);
        CCA_MESSAGE(ccaMessage,header,ValidateWSAlertMessageStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ValidateWSAlertMessage", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ValidateWSAlertMessage);
        ::boost::shared_ptr< ValidateWSAlertMessageError > payload (new ValidateWSAlertMessageError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ValidateWSAlertMessageError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ValidateWSAlertMessage", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendWSAlertsInfoListStatusUpReg(WSAlertsInfoListStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_WSAlertsInfoListStatus);
        ::boost::shared_ptr< WSAlertsInfoListStatusUpReg > payload (new WSAlertsInfoListStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,WSAlertsInfoListStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< WSAlertsInfoListStatusRelUpReg > payloadRelUpRegHeap (new WSAlertsInfoListStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_WSAlertsInfoListStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_wsalerts_main_fi::WSAlertsInfoListStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_WSAlertsInfoListStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "WSAlertsInfoListStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "WSAlertsInfoListStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasWSAlertsInfoListStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_WSAlertsInfoListStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< WSAlertsInfoListStatusStatus > payloadLoopback (new WSAlertsInfoListStatusStatus(getWSAlertsInfoListStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,WSAlertsInfoListStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WSAlertsInfoListStatus);
        ::boost::shared_ptr< WSAlertsInfoListStatusError > payload (new WSAlertsInfoListStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WSAlertsInfoListStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "WSAlertsInfoListStatus", &cb);
    }
}

bool Sxm_wsalerts_main_fiProxy::sendWSAlertsInfoListStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_WSAlertsInfoListStatus,"WSAlertsInfoListStatus");
}

void Sxm_wsalerts_main_fiProxy::sendWSAlertsInfoListStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_WSAlertsInfoListStatus);
}

const WSAlertsInfoListStatusStatus& Sxm_wsalerts_main_fiProxy::getWSAlertsInfoListStatus() const {
    return _wSAlertsInfoListStatus.get();
}

bool Sxm_wsalerts_main_fiProxy::hasWSAlertsInfoListStatus() const {
    return _wSAlertsInfoListStatus.hasValue();
}

act_t Sxm_wsalerts_main_fiProxy::sendWSAlertsInfoListStatusGet(WSAlertsInfoListStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_WSAlertsInfoListStatus);
        ::boost::shared_ptr< WSAlertsInfoListStatusGet > payload (new WSAlertsInfoListStatusGet());
        CCA_MESSAGE(ccaMessage,header,WSAlertsInfoListStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "WSAlertsInfoListStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WSAlertsInfoListStatus);
        ::boost::shared_ptr< WSAlertsInfoListStatusError > payload (new WSAlertsInfoListStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WSAlertsInfoListStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "WSAlertsInfoListStatus", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusUpReg > payload (new SxmDataServiceStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,SxmDataServiceStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SxmDataServiceStatusRelUpReg > payloadRelUpRegHeap (new SxmDataServiceStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SxmDataServiceStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_wsalerts_main_fi::SxmDataServiceStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SxmDataServiceStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SxmDataServiceStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SxmDataServiceStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSxmDataServiceStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SxmDataServiceStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SxmDataServiceStatusStatus > payloadLoopback (new SxmDataServiceStatusStatus(getSxmDataServiceStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SxmDataServiceStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmDataServiceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SxmDataServiceStatus", &cb);
    }
}

bool Sxm_wsalerts_main_fiProxy::sendSxmDataServiceStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SxmDataServiceStatus,"SxmDataServiceStatus");
}

void Sxm_wsalerts_main_fiProxy::sendSxmDataServiceStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SxmDataServiceStatus);
}

const SxmDataServiceStatusStatus& Sxm_wsalerts_main_fiProxy::getSxmDataServiceStatus() const {
    return _sxmDataServiceStatus.get();
}

bool Sxm_wsalerts_main_fiProxy::hasSxmDataServiceStatus() const {
    return _sxmDataServiceStatus.hasValue();
}

act_t Sxm_wsalerts_main_fiProxy::sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusGet > payload (new SxmDataServiceStatusGet());
        CCA_MESSAGE(ccaMessage,header,SxmDataServiceStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SxmDataServiceStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmDataServiceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SxmDataServiceStatus", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendSxmListModeUpReg(SxmListModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeUpReg > payload (new SxmListModeUpReg());
        CCA_MESSAGE(ccaMessage,header,SxmListModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SxmListModeRelUpReg > payloadRelUpRegHeap (new SxmListModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SxmListMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_wsalerts_main_fi::SxmListModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SxmListMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SxmListMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SxmListMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSxmListMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SxmListMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SxmListModeStatus > payloadLoopback (new SxmListModeStatus(getSxmListMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SxmListModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmListModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SxmListMode", &cb);
    }
}

bool Sxm_wsalerts_main_fiProxy::sendSxmListModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SxmListMode,"SxmListMode");
}

void Sxm_wsalerts_main_fiProxy::sendSxmListModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SxmListMode);
}

const SxmListModeStatus& Sxm_wsalerts_main_fiProxy::getSxmListMode() const {
    return _sxmListMode.get();
}

bool Sxm_wsalerts_main_fiProxy::hasSxmListMode() const {
    return _sxmListMode.hasValue();
}

act_t Sxm_wsalerts_main_fiProxy::sendSxmListModeSet(SxmListModeCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListMode& listMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeSet > payload (new SxmListModeSet());
        payload->setListMode(listMode);
        CCA_MESSAGE(ccaMessage,header,SxmListModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SxmListMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmListModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SxmListMode", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendWeatherAlertDataUpReg(WeatherAlertDataCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_WeatherAlertData);
        ::boost::shared_ptr< WeatherAlertDataUpReg > payload (new WeatherAlertDataUpReg());
        CCA_MESSAGE(ccaMessage,header,WeatherAlertDataUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< WeatherAlertDataRelUpReg > payloadRelUpRegHeap (new WeatherAlertDataRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_WeatherAlertData, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_wsalerts_main_fi::WeatherAlertDataRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_WeatherAlertData, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "WeatherAlertData", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "WeatherAlertData", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasWeatherAlertData()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_WeatherAlertData, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< WeatherAlertDataStatus > payloadLoopback (new WeatherAlertDataStatus(getWeatherAlertData()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,WeatherAlertDataStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WeatherAlertData);
        ::boost::shared_ptr< WeatherAlertDataError > payload (new WeatherAlertDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WeatherAlertDataError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "WeatherAlertData", &cb);
    }
}

bool Sxm_wsalerts_main_fiProxy::sendWeatherAlertDataRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_WeatherAlertData,"WeatherAlertData");
}

void Sxm_wsalerts_main_fiProxy::sendWeatherAlertDataRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_WeatherAlertData);
}

const WeatherAlertDataStatus& Sxm_wsalerts_main_fiProxy::getWeatherAlertData() const {
    return _weatherAlertData.get();
}

bool Sxm_wsalerts_main_fiProxy::hasWeatherAlertData() const {
    return _weatherAlertData.hasValue();
}

act_t Sxm_wsalerts_main_fiProxy::sendWeatherAlertDataGet(WeatherAlertDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_WeatherAlertData);
        ::boost::shared_ptr< WeatherAlertDataGet > payload (new WeatherAlertDataGet());
        CCA_MESSAGE(ccaMessage,header,WeatherAlertDataGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "WeatherAlertData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WeatherAlertData);
        ::boost::shared_ptr< WeatherAlertDataError > payload (new WeatherAlertDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WeatherAlertDataError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "WeatherAlertData", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendCurrentWSAlertsUpReg(CurrentWSAlertsCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CurrentWSAlerts);
        ::boost::shared_ptr< CurrentWSAlertsUpReg > payload (new CurrentWSAlertsUpReg());
        CCA_MESSAGE(ccaMessage,header,CurrentWSAlertsUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CurrentWSAlertsRelUpReg > payloadRelUpRegHeap (new CurrentWSAlertsRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CurrentWSAlerts, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_wsalerts_main_fi::CurrentWSAlertsRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CurrentWSAlerts, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CurrentWSAlerts", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CurrentWSAlerts", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCurrentWSAlerts()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CurrentWSAlerts, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CurrentWSAlertsStatus > payloadLoopback (new CurrentWSAlertsStatus(getCurrentWSAlerts()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CurrentWSAlertsStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CurrentWSAlerts);
        ::boost::shared_ptr< CurrentWSAlertsError > payload (new CurrentWSAlertsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CurrentWSAlertsError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CurrentWSAlerts", &cb);
    }
}

bool Sxm_wsalerts_main_fiProxy::sendCurrentWSAlertsRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CurrentWSAlerts,"CurrentWSAlerts");
}

void Sxm_wsalerts_main_fiProxy::sendCurrentWSAlertsRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CurrentWSAlerts);
}

const CurrentWSAlertsStatus& Sxm_wsalerts_main_fiProxy::getCurrentWSAlerts() const {
    return _currentWSAlerts.get();
}

bool Sxm_wsalerts_main_fiProxy::hasCurrentWSAlerts() const {
    return _currentWSAlerts.hasValue();
}

act_t Sxm_wsalerts_main_fiProxy::sendCurrentWSAlertsGet(CurrentWSAlertsCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_CurrentWSAlerts);
        ::boost::shared_ptr< CurrentWSAlertsGet > payload (new CurrentWSAlertsGet());
        CCA_MESSAGE(ccaMessage,header,CurrentWSAlertsGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "CurrentWSAlerts", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CurrentWSAlerts);
        ::boost::shared_ptr< CurrentWSAlertsError > payload (new CurrentWSAlertsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CurrentWSAlertsError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "CurrentWSAlerts", &cb);
    }
}

act_t Sxm_wsalerts_main_fiProxy::sendWSAlertAnnounceStatusUpReg(WSAlertAnnounceStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_WSAlertAnnounceStatus);
        ::boost::shared_ptr< WSAlertAnnounceStatusUpReg > payload (new WSAlertAnnounceStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,WSAlertAnnounceStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< WSAlertAnnounceStatusRelUpReg > payloadRelUpRegHeap (new WSAlertAnnounceStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_WSAlertAnnounceStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_wsalerts_main_fi::WSAlertAnnounceStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_WSAlertAnnounceStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "WSAlertAnnounceStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "WSAlertAnnounceStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasWSAlertAnnounceStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_WSAlertAnnounceStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< WSAlertAnnounceStatusStatus > payloadLoopback (new WSAlertAnnounceStatusStatus(getWSAlertAnnounceStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,WSAlertAnnounceStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WSAlertAnnounceStatus);
        ::boost::shared_ptr< WSAlertAnnounceStatusError > payload (new WSAlertAnnounceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WSAlertAnnounceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "WSAlertAnnounceStatus", &cb);
    }
}

bool Sxm_wsalerts_main_fiProxy::sendWSAlertAnnounceStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_WSAlertAnnounceStatus,"WSAlertAnnounceStatus");
}

void Sxm_wsalerts_main_fiProxy::sendWSAlertAnnounceStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_WSAlertAnnounceStatus);
}

const WSAlertAnnounceStatusStatus& Sxm_wsalerts_main_fiProxy::getWSAlertAnnounceStatus() const {
    return _wSAlertAnnounceStatus.get();
}

bool Sxm_wsalerts_main_fiProxy::hasWSAlertAnnounceStatus() const {
    return _wSAlertAnnounceStatus.hasValue();
}

act_t Sxm_wsalerts_main_fiProxy::sendWSAlertAnnounceStatusGet(WSAlertAnnounceStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_WSAlertAnnounceStatus);
        ::boost::shared_ptr< WSAlertAnnounceStatusGet > payload (new WSAlertAnnounceStatusGet());
        CCA_MESSAGE(ccaMessage,header,WSAlertAnnounceStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "WSAlertAnnounceStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WSAlertAnnounceStatus);
        ::boost::shared_ptr< WSAlertAnnounceStatusError > payload (new WSAlertAnnounceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WSAlertAnnounceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "WSAlertAnnounceStatus", &cb);
    }
}


void Sxm_wsalerts_main_fiProxy::clearAllProperties ()
{
    _wSAlertsInfoListStatus = ::asf::core::nullable<WSAlertsInfoListStatusStatus>();
    _sxmDataServiceStatus = ::asf::core::nullable<SxmDataServiceStatusStatus>();
    _sxmListMode = ::asf::core::nullable<SxmListModeStatus>();
    _weatherAlertData = ::asf::core::nullable<WeatherAlertDataStatus>();
    _currentWSAlerts = ::asf::core::nullable<CurrentWSAlertsStatus>();
    _wSAlertAnnounceStatus = ::asf::core::nullable<WSAlertAnnounceStatusStatus>();
}

void Sxm_wsalerts_main_fiProxy::sendRelUpRegAll()
{
    sendWSAlertsInfoListStatusRelUpRegAll();
    sendSxmDataServiceStatusRelUpRegAll();
    sendSxmListModeRelUpRegAll();
    sendWeatherAlertDataRelUpRegAll();
    sendCurrentWSAlertsRelUpRegAll();
    sendWSAlertAnnounceStatusRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Sxm_wsalerts_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Sxm_wsalerts_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace sxm_wsalerts_main_fi
