#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_WSALERTS_MAIN_FI_H
#define SXM_WSALERTS_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_main_fi_types.h"
#include "sxm_wsalerts_main_fi_types.h"
#include "sxm_wsalerts_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'sxm_wsalerts_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification
 *
 * Version: $Revision:   0.1  $
 *
 * Author: Satish Muchhala
 *
 * Date: $Date:   July 07 2016  $
 *
 * Department: ECV2
 *
 * Title: sxm_wsalerts_main_fi
 *
 * <b>Description of 'sxm_wsalerts_main_fi':</b>
 *
 * RBEI/ECM
 */

namespace sxm_wsalerts_main_fi {

static const int SERVICE_ID = 188;

static const int FID_GetWSAlertMsgList = 1;

static const int FID_SetListsConfig = 2;

static const int FID_GetWeatherAlertData = 3;

static const int FID_SetWSAlertsConfig = 4;

static const int FID_GetWSAlertMsgDetails = 5;

static const int FID_AnnounceWSAlert = 6;

static const int FID_SetWSAlertsProjectConfig = 7;

static const int FID_ValidateWSAlertMessage = 8;

static const int FID_WSAlertsInfoListStatus = 32;

static const int FID_SxmDataServiceStatus = 33;

static const int FID_SxmListMode = 34;

static const int FID_WeatherAlertData = 35;

static const int FID_CurrentWSAlerts = 36;

static const int FID_WSAlertAnnounceStatus = 37;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 2;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 2;

// forward declarations
class GetWSAlertMsgListStart;

class GetWSAlertMsgListResult;

class GetWSAlertMsgListErrorStructure;

class GetWSAlertMsgListError;

class SetListsConfigStart;

class SetListsConfigResult;

class SetListsConfigErrorStructure;

class SetListsConfigError;

class GetWeatherAlertDataResult;

class SetWSAlertsConfigStart;

class SetWSAlertsConfigResult;

class SetWSAlertsConfigErrorStructure;

class SetWSAlertsConfigError;

class GetWSAlertMsgDetailsStart;

class GetWSAlertMsgDetailsResult;

class GetWSAlertMsgDetailsErrorStructure;

class GetWSAlertMsgDetailsError;

class AnnounceWSAlertStart;

class AnnounceWSAlertResult;

class AnnounceWSAlertErrorStructure;

class AnnounceWSAlertError;

class SetWSAlertsProjectConfigStart;

class SetWSAlertsProjectConfigResult;

class SetWSAlertsProjectConfigErrorStructure;

class SetWSAlertsProjectConfigError;

class ValidateWSAlertMessageStart;

class ValidateWSAlertMessageResult;

class ValidateWSAlertMessageErrorStructure;

class ValidateWSAlertMessageError;

class WSAlertsInfoListStatusStatus;

class WSAlertsInfoListStatusErrorStructure;

class WSAlertsInfoListStatusError;

class SxmDataServiceStatusStatus;

class SxmListModeStatus;

class SxmListModeSet;

class SxmListModeErrorStructure;

class SxmListModeError;

class WeatherAlertDataStatus;

class WeatherAlertDataErrorStructure;

class WeatherAlertDataError;

class CurrentWSAlertsStatus;

class CurrentWSAlertsErrorStructure;

class CurrentWSAlertsError;

class WSAlertAnnounceStatusStatus;

class WSAlertAnnounceStatusErrorStructure;

class WSAlertAnnounceStatusError;

// type definitions
/**
 * The abort error message of the method "GetWSAlertMsgList"
 * This method is used to get the Weather and Security Alert Message list for nearby and near destination location based on "Alert Settings".
 */
typedef ::asf::cca::CcaTypes::DefaultError GetWSAlertMsgListAbortError;

/**
 * The abort error message of the method "SetListsConfig"
 * This method is used to configure all lists
 */
typedef ::asf::cca::CcaTypes::DefaultError SetListsConfigAbortError;

/**
 * The start message of the method "GetWeatherAlertData"
 * Provides the Weather and Security Alert messages with shape information for the whole US to map.
 * No parameters included, always the complete data is requested.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetWeatherAlertDataStart;

/**
 * The abort error message of the method "GetWeatherAlertData"
 * Provides the Weather and Security Alert messages with shape information for the whole US to map.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetWeatherAlertDataAbortError;

/**
 * The error message of 'GetWeatherAlertData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetWeatherAlertDataError;

/**
 * The abort error message of the method "SetWSAlertsConfig"
 * This method is used to set the last saved configuration to enable and disable the alerts
 */
typedef ::asf::cca::CcaTypes::DefaultError SetWSAlertsConfigAbortError;

/**
 * The abort error message of the method "GetWSAlertMsgDetails"
 * This method is used to get the details of the particular alert message.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetWSAlertMsgDetailsAbortError;

/**
 * The abort error message of the method "AnnounceWSAlert"
 * Weather and Security Alerts announcement
 */
typedef ::asf::cca::CcaTypes::DefaultError AnnounceWSAlertAbortError;

/**
 * The abort error message of the method "SetWSAlertsProjectConfig"
 * This method is used to set the Project specific configuration data for alerts.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetWSAlertsProjectConfigAbortError;

/**
 * The abort error message of the method "ValidateWSAlertMessage"
 * This method is used to verify the perticular alert message is currently valid or expired.
 */
typedef ::asf::cca::CcaTypes::DefaultError ValidateWSAlertMessageAbortError;

/**
 * The get message of the property "WSAlertsInfoListStatus"
 * Weather and Security Alerts information result
 * Request Weather and Security Alerts information result
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WSAlertsInfoListStatusGet;

/**
 * The upreg message of the property "WSAlertsInfoListStatus"
 * Weather and Security Alerts information result
 * Register for Weather and Security Alerts Info. changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WSAlertsInfoListStatusUpReg;

/**
 * The relUpReg message of the property "WSAlertsInfoListStatus"
 * Weather and Security Alerts information result
 * Un-register for Weather Security Alerts Info. changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WSAlertsInfoListStatusRelUpReg;

/**
 * The get message of the property "SxmDataServiceStatus"
 * Get the Status of Weather and Security Alerts Data Service
 * Status of Weather and Security Alerts Data Service
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusGet;

/**
 * The upreg message of the property "SxmDataServiceStatus"
 * Get the Status of Weather and Security Alerts Data Service
 * Register for Weather and Security Alerts Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusUpReg;

/**
 * The relUpReg message of the property "SxmDataServiceStatus"
 * Get the Status of Weather and Security Alerts Data Service
 * Unregister for Weather and Security Alerts Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusRelUpReg;

/**
 * The error message of 'SxmDataServiceStatus'
 * This error code specifies Weather and Security Alerts Data Service Status is not available
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmDataServiceStatusError;

/**
 * The upreg message of the property "SxmListMode"
 * Set the Mode of Weather and Security Alerts List.
 * Register for Sxm WS alert list mode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeUpReg;

/**
 * The relUpReg message of the property "SxmListMode"
 * Set the Mode of Weather and Security Alerts List.
 * Un-register for Sxm WS alert list mode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeRelUpReg;

/**
 * The get message of the property "WeatherAlertData"
 * Gives the status of the Alert shape data
 * Request Weather and Security Alerts information result
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WeatherAlertDataGet;

/**
 * The upreg message of the property "WeatherAlertData"
 * Gives the status of the Alert shape data
 * Register for SxmListMode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WeatherAlertDataUpReg;

/**
 * The relUpReg message of the property "WeatherAlertData"
 * Gives the status of the Alert shape data
 * Un-register for SxmListMode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WeatherAlertDataRelUpReg;

/**
 * The get message of the property "CurrentWSAlerts"
 * Property update for current WSAlerts to be shown to the user
 * Request current WS alerts
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentWSAlertsGet;

/**
 * The upreg message of the property "CurrentWSAlerts"
 * Property update for current WSAlerts to be shown to the user
 * Register for current WS alerts
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentWSAlertsUpReg;

/**
 * The relUpReg message of the property "CurrentWSAlerts"
 * Property update for current WSAlerts to be shown to the user
 * Un-register for current WS alerts
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentWSAlertsRelUpReg;

/**
 * The get message of the property "WSAlertAnnounceStatus"
 * Status of the WSAlerts
 * Get WS Alert announcement status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WSAlertAnnounceStatusGet;

/**
 * The upreg message of the property "WSAlertAnnounceStatus"
 * Status of the WSAlerts
 * Register for WS Alert announcement status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WSAlertAnnounceStatusUpReg;

/**
 * The relUpReg message of the property "WSAlertAnnounceStatus"
 * Status of the WSAlerts
 * Un-register for WS Alert announcement status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WSAlertAnnounceStatusRelUpReg;


/**
 * The start message of the method "GetWSAlertMsgList"
 * This method is used to get the Weather and Security Alert Message list for nearby and near destination location based on "Alert Settings".
 */
class GetWSAlertMsgListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetWSAlertMsgListStart ();

    /**
     * Copy constructor
     */
    inline  GetWSAlertMsgListStart (const GetWSAlertMsgListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetWSAlertMsgListStart (uint32 ListId_);

    /**
     * Destructor
     */
    inline virtual  ~GetWSAlertMsgListStart();

    /**
     * Assignment operator
     */
    inline GetWSAlertMsgListStart& operator = (const GetWSAlertMsgListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWSAlertMsgListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWSAlertMsgListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWSAlertMsgListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWSAlertMsgListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListId"

    static const int kListId = 0;

    /**
     * Clears the field "ListId".
     *
     * The field will be set to its default value. The hasListId()
     * method will return false.
     */
    inline void clearListId();

    /**
     * Checks whether the field "ListId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListId()). Otherwise it will return false.
     */
    inline bool hasListId () const;

    /**
     * Returns the value of the member "ListId".
     *
     * List ID, values according to T_e8_SxmListType
     *
     * @return The value of the field "ListId"
     */
    inline uint32 getListId () const;

    /**
     * Sets the value of the member "ListId".
     *
     * List ID, values according to T_e8_SxmListType
     *
     * @param ListId The value which will be set
     */
    inline void setListId (uint32 ListId_);

    static const GetWSAlertMsgListStart &getDefaultInstance();

private:

    inline void set_has_ListId ();

    inline void clear_has_ListId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ListId;

};

/**
 * The result message of the method "GetWSAlertMsgList"
 * This method is used to get the Weather and Security Alert Message list for nearby and near destination location based on "Alert Settings".
 * Result of the method start and provide Weather and Security Alerts information.
 */
class GetWSAlertMsgListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetWSAlertMsgListResult ();

    /**
     * Copy constructor
     */
    inline  GetWSAlertMsgListResult (const GetWSAlertMsgListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetWSAlertMsgListResult (uint32 ListId_, const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& WSAlertMsglist_);

    /**
     * Destructor
     */
    inline virtual  ~GetWSAlertMsgListResult();

    /**
     * Assignment operator
     */
    inline GetWSAlertMsgListResult& operator = (const GetWSAlertMsgListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWSAlertMsgListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWSAlertMsgListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWSAlertMsgListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWSAlertMsgListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListId"

    static const int kListId = 0;

    /**
     * Clears the field "ListId".
     *
     * The field will be set to its default value. The hasListId()
     * method will return false.
     */
    inline void clearListId();

    /**
     * Checks whether the field "ListId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListId()). Otherwise it will return false.
     */
    inline bool hasListId () const;

    /**
     * Returns the value of the member "ListId".
     *
     * List ID, values according to T_e8_SxmListType
     *
     * @return The value of the field "ListId"
     */
    inline uint32 getListId () const;

    /**
     * Sets the value of the member "ListId".
     *
     * List ID, values according to T_e8_SxmListType
     *
     * @param ListId The value which will be set
     */
    inline void setListId (uint32 ListId_);

    // API of field "WSAlertMsglist"

    static const int kWSAlertMsglist = 1;

    /**
     * Clears the field "WSAlertMsglist".
     *
     * The field will be set to its default value. The hasWSAlertMsglist()
     * method will return false.
     */
    inline void clearWSAlertMsglist();

    /**
     * Checks whether the field "WSAlertMsglist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWSAlertMsglist()). Otherwise it will return false.
     */
    inline bool hasWSAlertMsglist () const;

    /**
     * Returns the value of the member "WSAlertMsglist".
     *
     * List of Weather and Security Alert messages
     *
     * @return The value of the field "WSAlertMsglist"
     */
    inline const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& getWSAlertMsglist () const;

    /**
     * Retrieves the value of the field "WSAlertMsglist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WSAlertMsglist".
     */
    inline ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& getWSAlertMsglistMutable ();

    /**
     * Sets the value of the member "WSAlertMsglist".
     *
     * List of Weather and Security Alert messages
     *
     * @param WSAlertMsglist The value which will be set
     */
    inline void setWSAlertMsglist (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& WSAlertMsglist_);

    static const GetWSAlertMsgListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& getT_WSAlertMsgList_DefaultInstance ();

    inline void set_has_ListId ();

    inline void clear_has_ListId ();

    inline void set_has_WSAlertMsglist ();

    inline void clear_has_WSAlertMsglist ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ListId;

    ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg > _WSAlertMsglist;

};

/**
 * The error message of 'GetWSAlertMsgList'
 */
class GetWSAlertMsgListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetWSAlertMsgListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetWSAlertMsgListErrorStructure (const GetWSAlertMsgListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetWSAlertMsgListErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetWSAlertMsgListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetWSAlertMsgListErrorStructure& operator = (const GetWSAlertMsgListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWSAlertMsgListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWSAlertMsgListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWSAlertMsgListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWSAlertMsgListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    static const GetWSAlertMsgListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetWSAlertMsgList'
 */
class GetWSAlertMsgListError  : public ::asf::core::Payload {
public:

    enum GetWSAlertMsgListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetWSAlertMsgListError ();

   /**
     * Copy constructor
     */
    inline  GetWSAlertMsgListError (const GetWSAlertMsgListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetWSAlertMsgListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetWSAlertMsgListError& operator = (const GetWSAlertMsgListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWSAlertMsgListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWSAlertMsgListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWSAlertMsgListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWSAlertMsgListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetWSAlertMsgListError::GetWSAlertMsgListErrorField getField () const;

    inline void setField(GetWSAlertMsgListError::GetWSAlertMsgListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetWSAlertMsgListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetWSAlertMsgListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetWSAlertMsgListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetWSAlertMsgListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetWSAlertMsgListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetWSAlertMsgListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetWSAlertMsgListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetWSAlertMsgListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetWSAlertMsgListError &getDefaultInstance();

private:

    inline void cloneData (const GetWSAlertMsgListError& rhs);

    inline void deleteData ();

    GetWSAlertMsgListErrorField __field;

    union {
        GetWSAlertMsgListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetListsConfig"
 * This method is used to configure all lists
 */
class SetListsConfigStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigStart ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigStart (const SetListsConfigStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigStart (const ::sxm_main_fi_types::T_SxmListsConfig& Config_);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigStart();

    /**
     * Assignment operator
     */
    inline SetListsConfigStart& operator = (const SetListsConfigStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Config"

    static const int kConfig = 0;

    /**
     * Clears the field "Config".
     *
     * The field will be set to its default value. The hasConfig()
     * method will return false.
     */
    inline void clearConfig();

    /**
     * Checks whether the field "Config" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfig()). Otherwise it will return false.
     */
    inline bool hasConfig () const;

    /**
     * Returns the value of the member "Config".
     *
     * Currently in T_SxmListsConfig, Capacity is passed.
     * Capacity for Weather alerts is "1". This Method is to provide a control over capacity.
     *
     * @return The value of the field "Config"
     */
    inline const ::sxm_main_fi_types::T_SxmListsConfig& getConfig () const;

    /**
     * Retrieves the value of the field "Config" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Config".
     */
    inline ::sxm_main_fi_types::T_SxmListsConfig& getConfigMutable ();

    /**
     * Sets the value of the member "Config".
     *
     * Currently in T_SxmListsConfig, Capacity is passed.
     * Capacity for Weather alerts is "1". This Method is to provide a control over capacity.
     *
     * @param Config The value which will be set
     */
    inline void setConfig (const ::sxm_main_fi_types::T_SxmListsConfig& Config_);

    static const SetListsConfigStart &getDefaultInstance();

private:

    inline void set_has_Config ();

    inline void clear_has_Config ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListsConfig _Config;

};

/**
 * The result message of the method "SetListsConfig"
 * This method is used to configure all lists
 */
class SetListsConfigResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigResult ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigResult (const SetListsConfigResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigResult();

    /**
     * Assignment operator
     */
    inline SetListsConfigResult& operator = (const SetListsConfigResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if value was accepted
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if value was accepted
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetListsConfigResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SetListsConfig'
 */
class SetListsConfigErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigErrorStructure (const SetListsConfigErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetListsConfigErrorStructure();

    /**
     * Assignment operator
     */
    inline SetListsConfigErrorStructure& operator = (const SetListsConfigErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    static const SetListsConfigErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SetListsConfig'
 */
class SetListsConfigError  : public ::asf::core::Payload {
public:

    enum SetListsConfigErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetListsConfigError ();

   /**
     * Copy constructor
     */
    inline  SetListsConfigError (const SetListsConfigError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigError();

    /**
     * Assigns a new value to this object.
     */
    inline SetListsConfigError& operator = (const SetListsConfigError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetListsConfigError::SetListsConfigErrorField getField () const;

    inline void setField(SetListsConfigError::SetListsConfigErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetListsConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetListsConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetListsConfigErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetListsConfigErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetListsConfigErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetListsConfigErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetListsConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetListsConfigErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetListsConfigError &getDefaultInstance();

private:

    inline void cloneData (const SetListsConfigError& rhs);

    inline void deleteData ();

    SetListsConfigErrorField __field;

    union {
        SetListsConfigErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "GetWeatherAlertData"
 * Provides the Weather and Security Alert messages with shape information for the whole US to map.
 * Weather and Security Alerts with shape information.
 */
class GetWeatherAlertDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetWeatherAlertDataResult ();

    /**
     * Copy constructor
     */
    inline  GetWeatherAlertDataResult (const GetWeatherAlertDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetWeatherAlertDataResult (uint32 UpdateCounter_, const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& Alerts_);

    /**
     * Destructor
     */
    inline virtual  ~GetWeatherAlertDataResult();

    /**
     * Assignment operator
     */
    inline GetWeatherAlertDataResult& operator = (const GetWeatherAlertDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWeatherAlertDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWeatherAlertDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWeatherAlertDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWeatherAlertDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateCounter"

    static const int kUpdateCounter = 0;

    /**
     * Clears the field "UpdateCounter".
     *
     * The field will be set to its default value. The hasUpdateCounter()
     * method will return false.
     */
    inline void clearUpdateCounter();

    /**
     * Checks whether the field "UpdateCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateCounter()). Otherwise it will return false.
     */
    inline bool hasUpdateCounter () const;

    /**
     * Returns the value of the member "UpdateCounter".
     *
     * Latest UpdateCounter for weather-alert data
     *
     * @return The value of the field "UpdateCounter"
     */
    inline uint32 getUpdateCounter () const;

    /**
     * Sets the value of the member "UpdateCounter".
     *
     * Latest UpdateCounter for weather-alert data
     *
     * @param UpdateCounter The value which will be set
     */
    inline void setUpdateCounter (uint32 UpdateCounter_);

    // API of field "Alerts"

    static const int kAlerts = 1;

    /**
     * Clears the field "Alerts".
     *
     * The field will be set to its default value. The hasAlerts()
     * method will return false.
     */
    inline void clearAlerts();

    /**
     * Checks whether the field "Alerts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlerts()). Otherwise it will return false.
     */
    inline bool hasAlerts () const;

    /**
     * Returns the value of the member "Alerts".
     *
     * All weather alerts in one list.
     *
     * @return The value of the field "Alerts"
     */
    inline const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& getAlerts () const;

    /**
     * Retrieves the value of the field "Alerts" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Alerts".
     */
    inline ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& getAlertsMutable ();

    /**
     * Sets the value of the member "Alerts".
     *
     * All weather alerts in one list.
     *
     * @param Alerts The value which will be set
     */
    inline void setAlerts (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& Alerts_);

    static const GetWeatherAlertDataResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& getT_WSAlertMsgList_DefaultInstance ();

    inline void set_has_UpdateCounter ();

    inline void clear_has_UpdateCounter ();

    inline void set_has_Alerts ();

    inline void clear_has_Alerts ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _UpdateCounter;

    ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg > _Alerts;

};

/**
 * The start message of the method "SetWSAlertsConfig"
 * This method is used to set the last saved configuration to enable and disable the alerts
 */
class SetWSAlertsConfigStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetWSAlertsConfigStart ();

    /**
     * Copy constructor
     */
    inline  SetWSAlertsConfigStart (const SetWSAlertsConfigStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetWSAlertsConfigStart (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes >& AlertTypeIDs_, ::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType WSAlertAction_);

    /**
     * Destructor
     */
    inline virtual  ~SetWSAlertsConfigStart();

    /**
     * Assignment operator
     */
    inline SetWSAlertsConfigStart& operator = (const SetWSAlertsConfigStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWSAlertsConfigStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWSAlertsConfigStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWSAlertsConfigStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWSAlertsConfigStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AlertTypeIDs"

    static const int kAlertTypeIDs = 0;

    /**
     * Clears the field "AlertTypeIDs".
     *
     * The field will be set to its default value. The hasAlertTypeIDs()
     * method will return false.
     */
    inline void clearAlertTypeIDs();

    /**
     * Checks whether the field "AlertTypeIDs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertTypeIDs()). Otherwise it will return false.
     */
    inline bool hasAlertTypeIDs () const;

    /**
     * Returns the value of the member "AlertTypeIDs".
     *
     * List of Alert type ID for Weather and Security
     *
     * @return The value of the field "AlertTypeIDs"
     */
    inline const ::std::vector< ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes >& getAlertTypeIDs () const;

    /**
     * Retrieves the value of the field "AlertTypeIDs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlertTypeIDs".
     */
    inline ::std::vector< ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes >& getAlertTypeIDsMutable ();

    /**
     * Sets the value of the member "AlertTypeIDs".
     *
     * List of Alert type ID for Weather and Security
     *
     * @param AlertTypeIDs The value which will be set
     */
    inline void setAlertTypeIDs (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes >& AlertTypeIDs_);

    // API of field "WSAlertAction"

    static const int kWSAlertAction = 1;

    /**
     * Clears the field "WSAlertAction".
     *
     * The field will be set to its default value. The hasWSAlertAction()
     * method will return false.
     */
    inline void clearWSAlertAction();

    /**
     * Checks whether the field "WSAlertAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWSAlertAction()). Otherwise it will return false.
     */
    inline bool hasWSAlertAction () const;

    /**
     * Returns the value of the member "WSAlertAction".
     *
     * To enable,disable individual alert types and the group of warnings or watches
     *
     * @return The value of the field "WSAlertAction"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType getWSAlertAction () const;

    /**
     * Sets the value of the member "WSAlertAction".
     *
     * To enable,disable individual alert types and the group of warnings or watches
     *
     * @param WSAlertAction The value which will be set
     */
    inline void setWSAlertAction (::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType WSAlertAction_);

    static const SetWSAlertsConfigStart &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes >& getT_e8_WSAlertTypesList_DefaultInstance ();

    inline void set_has_AlertTypeIDs ();

    inline void clear_has_AlertTypeIDs ();

    inline void set_has_WSAlertAction ();

    inline void clear_has_WSAlertAction ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes > _AlertTypeIDs;

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType _WSAlertAction;

};

/**
 * The result message of the method "SetWSAlertsConfig"
 * This method is used to set the last saved configuration to enable and disable the alerts
 */
class SetWSAlertsConfigResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetWSAlertsConfigResult ();

    /**
     * Copy constructor
     */
    inline  SetWSAlertsConfigResult (const SetWSAlertsConfigResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetWSAlertsConfigResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetWSAlertsConfigResult();

    /**
     * Assignment operator
     */
    inline SetWSAlertsConfigResult& operator = (const SetWSAlertsConfigResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWSAlertsConfigResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWSAlertsConfigResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWSAlertsConfigResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWSAlertsConfigResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * True if Success and return false in the case of failed
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * True if Success and return false in the case of failed
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetWSAlertsConfigResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SetWSAlertsConfig'
 */
class SetWSAlertsConfigErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetWSAlertsConfigErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetWSAlertsConfigErrorStructure (const SetWSAlertsConfigErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetWSAlertsConfigErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetWSAlertsConfigErrorStructure();

    /**
     * Assignment operator
     */
    inline SetWSAlertsConfigErrorStructure& operator = (const SetWSAlertsConfigErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWSAlertsConfigErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWSAlertsConfigErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWSAlertsConfigErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWSAlertsConfigErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    static const SetWSAlertsConfigErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SetWSAlertsConfig'
 */
class SetWSAlertsConfigError  : public ::asf::core::Payload {
public:

    enum SetWSAlertsConfigErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetWSAlertsConfigError ();

   /**
     * Copy constructor
     */
    inline  SetWSAlertsConfigError (const SetWSAlertsConfigError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetWSAlertsConfigError();

    /**
     * Assigns a new value to this object.
     */
    inline SetWSAlertsConfigError& operator = (const SetWSAlertsConfigError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWSAlertsConfigError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWSAlertsConfigError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWSAlertsConfigError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWSAlertsConfigError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetWSAlertsConfigError::SetWSAlertsConfigErrorField getField () const;

    inline void setField(SetWSAlertsConfigError::SetWSAlertsConfigErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetWSAlertsConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetWSAlertsConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetWSAlertsConfigErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetWSAlertsConfigErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetWSAlertsConfigErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetWSAlertsConfigErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetWSAlertsConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetWSAlertsConfigErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetWSAlertsConfigError &getDefaultInstance();

private:

    inline void cloneData (const SetWSAlertsConfigError& rhs);

    inline void deleteData ();

    SetWSAlertsConfigErrorField __field;

    union {
        SetWSAlertsConfigErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetWSAlertMsgDetails"
 * This method is used to get the details of the particular alert message.
 */
class GetWSAlertMsgDetailsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetWSAlertMsgDetailsStart ();

    /**
     * Copy constructor
     */
    inline  GetWSAlertMsgDetailsStart (const GetWSAlertMsgDetailsStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetWSAlertMsgDetailsStart (uint32 MessageID_);

    /**
     * Destructor
     */
    inline virtual  ~GetWSAlertMsgDetailsStart();

    /**
     * Assignment operator
     */
    inline GetWSAlertMsgDetailsStart& operator = (const GetWSAlertMsgDetailsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWSAlertMsgDetailsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWSAlertMsgDetailsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWSAlertMsgDetailsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWSAlertMsgDetailsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MessageID"

    static const int kMessageID = 0;

    /**
     * Clears the field "MessageID".
     *
     * The field will be set to its default value. The hasMessageID()
     * method will return false.
     */
    inline void clearMessageID();

    /**
     * Checks whether the field "MessageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessageID()). Otherwise it will return false.
     */
    inline bool hasMessageID () const;

    /**
     * Returns the value of the member "MessageID".
     *
     * Message ID
     *
     * @return The value of the field "MessageID"
     */
    inline uint32 getMessageID () const;

    /**
     * Sets the value of the member "MessageID".
     *
     * Message ID
     *
     * @param MessageID The value which will be set
     */
    inline void setMessageID (uint32 MessageID_);

    static const GetWSAlertMsgDetailsStart &getDefaultInstance();

private:

    inline void set_has_MessageID ();

    inline void clear_has_MessageID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _MessageID;

};

/**
 * The result message of the method "GetWSAlertMsgDetails"
 * This method is used to get the details of the particular alert message.
 * Result of the method start and provide Weather and Security Alerts information.
 */
class GetWSAlertMsgDetailsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetWSAlertMsgDetailsResult ();

    /**
     * Copy constructor
     */
    inline  GetWSAlertMsgDetailsResult (const GetWSAlertMsgDetailsResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetWSAlertMsgDetailsResult (const ::sxm_wsalerts_main_fi_types::T_WSAlertMsg& WSAlertMsgInfo_);

    /**
     * Destructor
     */
    inline virtual  ~GetWSAlertMsgDetailsResult();

    /**
     * Assignment operator
     */
    inline GetWSAlertMsgDetailsResult& operator = (const GetWSAlertMsgDetailsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWSAlertMsgDetailsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWSAlertMsgDetailsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWSAlertMsgDetailsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWSAlertMsgDetailsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WSAlertMsgInfo"

    static const int kWSAlertMsgInfo = 0;

    /**
     * Clears the field "WSAlertMsgInfo".
     *
     * The field will be set to its default value. The hasWSAlertMsgInfo()
     * method will return false.
     */
    inline void clearWSAlertMsgInfo();

    /**
     * Checks whether the field "WSAlertMsgInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWSAlertMsgInfo()). Otherwise it will return false.
     */
    inline bool hasWSAlertMsgInfo () const;

    /**
     * Returns the value of the member "WSAlertMsgInfo".
     *
     * Weather and Security Alert messages
     *
     * @return The value of the field "WSAlertMsgInfo"
     */
    inline const ::sxm_wsalerts_main_fi_types::T_WSAlertMsg& getWSAlertMsgInfo () const;

    /**
     * Retrieves the value of the field "WSAlertMsgInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WSAlertMsgInfo".
     */
    inline ::sxm_wsalerts_main_fi_types::T_WSAlertMsg& getWSAlertMsgInfoMutable ();

    /**
     * Sets the value of the member "WSAlertMsgInfo".
     *
     * Weather and Security Alert messages
     *
     * @param WSAlertMsgInfo The value which will be set
     */
    inline void setWSAlertMsgInfo (const ::sxm_wsalerts_main_fi_types::T_WSAlertMsg& WSAlertMsgInfo_);

    static const GetWSAlertMsgDetailsResult &getDefaultInstance();

private:

    inline void set_has_WSAlertMsgInfo ();

    inline void clear_has_WSAlertMsgInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_WSAlertMsg _WSAlertMsgInfo;

};

/**
 * The error message of 'GetWSAlertMsgDetails'
 */
class GetWSAlertMsgDetailsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetWSAlertMsgDetailsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetWSAlertMsgDetailsErrorStructure (const GetWSAlertMsgDetailsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetWSAlertMsgDetailsErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetWSAlertMsgDetailsErrorStructure();

    /**
     * Assignment operator
     */
    inline GetWSAlertMsgDetailsErrorStructure& operator = (const GetWSAlertMsgDetailsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWSAlertMsgDetailsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWSAlertMsgDetailsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWSAlertMsgDetailsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWSAlertMsgDetailsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    static const GetWSAlertMsgDetailsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetWSAlertMsgDetails'
 */
class GetWSAlertMsgDetailsError  : public ::asf::core::Payload {
public:

    enum GetWSAlertMsgDetailsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetWSAlertMsgDetailsError ();

   /**
     * Copy constructor
     */
    inline  GetWSAlertMsgDetailsError (const GetWSAlertMsgDetailsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetWSAlertMsgDetailsError();

    /**
     * Assigns a new value to this object.
     */
    inline GetWSAlertMsgDetailsError& operator = (const GetWSAlertMsgDetailsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWSAlertMsgDetailsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWSAlertMsgDetailsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWSAlertMsgDetailsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWSAlertMsgDetailsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetWSAlertMsgDetailsError::GetWSAlertMsgDetailsErrorField getField () const;

    inline void setField(GetWSAlertMsgDetailsError::GetWSAlertMsgDetailsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetWSAlertMsgDetailsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetWSAlertMsgDetailsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetWSAlertMsgDetailsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetWSAlertMsgDetailsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetWSAlertMsgDetailsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetWSAlertMsgDetailsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetWSAlertMsgDetailsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetWSAlertMsgDetailsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetWSAlertMsgDetailsError &getDefaultInstance();

private:

    inline void cloneData (const GetWSAlertMsgDetailsError& rhs);

    inline void deleteData ();

    GetWSAlertMsgDetailsErrorField __field;

    union {
        GetWSAlertMsgDetailsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AnnounceWSAlert"
 * Weather and Security Alerts announcement
 */
class AnnounceWSAlertStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AnnounceWSAlertStart ();

    /**
     * Copy constructor
     */
    inline  AnnounceWSAlertStart (const AnnounceWSAlertStart &rhs);

    /**
     * All fields constructor
     */
    inline  AnnounceWSAlertStart (uint32 MessageID_, ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction Action_, const ::std::string& Text_);

    /**
     * Destructor
     */
    inline virtual  ~AnnounceWSAlertStart();

    /**
     * Assignment operator
     */
    inline AnnounceWSAlertStart& operator = (const AnnounceWSAlertStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AnnounceWSAlertStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AnnounceWSAlertStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AnnounceWSAlertStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AnnounceWSAlertStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MessageID"

    static const int kMessageID = 0;

    /**
     * Clears the field "MessageID".
     *
     * The field will be set to its default value. The hasMessageID()
     * method will return false.
     */
    inline void clearMessageID();

    /**
     * Checks whether the field "MessageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessageID()). Otherwise it will return false.
     */
    inline bool hasMessageID () const;

    /**
     * Returns the value of the member "MessageID".
     *
     * Message ID
     *
     * @return The value of the field "MessageID"
     */
    inline uint32 getMessageID () const;

    /**
     * Sets the value of the member "MessageID".
     *
     * Message ID
     *
     * @param MessageID The value which will be set
     */
    inline void setMessageID (uint32 MessageID_);

    // API of field "Action"

    static const int kAction = 1;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * Weather and Security Alert announcement action
     *
     * @return The value of the field "Action"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * Weather and Security Alert announcement action
     *
     * @param Action The value which will be set
     */
    inline void setAction (::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction Action_);

    // API of field "Text"

    static const int kText = 2;

    /**
     * Clears the field "Text".
     *
     * The field will be set to its default value. The hasText()
     * method will return false.
     */
    inline void clearText();

    /**
     * Checks whether the field "Text" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setText()). Otherwise it will return false.
     */
    inline bool hasText () const;

    /**
     * Returns the value of the member "Text".
     *
     * Weather and Security Alert announcement text
     *
     * @return The value of the field "Text"
     */
    inline const ::std::string& getText () const;

    /**
     * Retrieves the value of the field "Text" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Text".
     */
    inline ::std::string& getTextMutable ();

    /**
     * Sets the value of the member "Text".
     *
     * Weather and Security Alert announcement text
     *
     * @param Text The value which will be set
     */
    inline void setText (const ::std::string& Text_);

    /**
     * Sets the value of the member "Text".
     *
     * Weather and Security Alert announcement text
     *
     * @param Text The value which will be set
     */
    inline void setText (const char* Text_);

    /**
     * Sets the value of the member "Text".
     *
     * Weather and Security Alert announcement text
     *
     * @param Text The value which will be set
     */
    inline void setText (const char* value, size_t size);

    static const AnnounceWSAlertStart &getDefaultInstance();

private:

    inline void set_has_MessageID ();

    inline void clear_has_MessageID ();

    inline void set_has_Action ();

    inline void clear_has_Action ();

    inline void set_has_Text ();

    inline void clear_has_Text ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _MessageID;

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction _Action;

    ::std::string _Text;

};

/**
 * The result message of the method "AnnounceWSAlert"
 * Weather and Security Alerts announcement
 * Weather and Security Alerts with shape information.
 */
class AnnounceWSAlertResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AnnounceWSAlertResult ();

    /**
     * Copy constructor
     */
    inline  AnnounceWSAlertResult (const AnnounceWSAlertResult &rhs);

    /**
     * All fields constructor
     */
    inline  AnnounceWSAlertResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~AnnounceWSAlertResult();

    /**
     * Assignment operator
     */
    inline AnnounceWSAlertResult& operator = (const AnnounceWSAlertResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AnnounceWSAlertResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AnnounceWSAlertResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AnnounceWSAlertResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AnnounceWSAlertResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * True - Success
     * False - Failure
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * True - Success
     * False - Failure
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const AnnounceWSAlertResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'AnnounceWSAlert'
 */
class AnnounceWSAlertErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AnnounceWSAlertErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AnnounceWSAlertErrorStructure (const AnnounceWSAlertErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AnnounceWSAlertErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AnnounceWSAlertErrorStructure();

    /**
     * Assignment operator
     */
    inline AnnounceWSAlertErrorStructure& operator = (const AnnounceWSAlertErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AnnounceWSAlertErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AnnounceWSAlertErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AnnounceWSAlertErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AnnounceWSAlertErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    static const AnnounceWSAlertErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'AnnounceWSAlert'
 */
class AnnounceWSAlertError  : public ::asf::core::Payload {
public:

    enum AnnounceWSAlertErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AnnounceWSAlertError ();

   /**
     * Copy constructor
     */
    inline  AnnounceWSAlertError (const AnnounceWSAlertError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AnnounceWSAlertError();

    /**
     * Assigns a new value to this object.
     */
    inline AnnounceWSAlertError& operator = (const AnnounceWSAlertError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AnnounceWSAlertError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AnnounceWSAlertError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AnnounceWSAlertError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AnnounceWSAlertError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AnnounceWSAlertError::AnnounceWSAlertErrorField getField () const;

    inline void setField(AnnounceWSAlertError::AnnounceWSAlertErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AnnounceWSAlertErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AnnounceWSAlertErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AnnounceWSAlertErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AnnounceWSAlertErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AnnounceWSAlertErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AnnounceWSAlertErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AnnounceWSAlertErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AnnounceWSAlertErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AnnounceWSAlertError &getDefaultInstance();

private:

    inline void cloneData (const AnnounceWSAlertError& rhs);

    inline void deleteData ();

    AnnounceWSAlertErrorField __field;

    union {
        AnnounceWSAlertErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetWSAlertsProjectConfig"
 * This method is used to set the Project specific configuration data for alerts.
 */
class SetWSAlertsProjectConfigStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetWSAlertsProjectConfigStart ();

    /**
     * Copy constructor
     */
    inline  SetWSAlertsProjectConfigStart (const SetWSAlertsProjectConfigStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetWSAlertsProjectConfigStart (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertConfig >& AlertConfig_);

    /**
     * Destructor
     */
    inline virtual  ~SetWSAlertsProjectConfigStart();

    /**
     * Assignment operator
     */
    inline SetWSAlertsProjectConfigStart& operator = (const SetWSAlertsProjectConfigStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWSAlertsProjectConfigStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWSAlertsProjectConfigStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWSAlertsProjectConfigStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWSAlertsProjectConfigStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AlertConfig"

    static const int kAlertConfig = 0;

    /**
     * Clears the field "AlertConfig".
     *
     * The field will be set to its default value. The hasAlertConfig()
     * method will return false.
     */
    inline void clearAlertConfig();

    /**
     * Checks whether the field "AlertConfig" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertConfig()). Otherwise it will return false.
     */
    inline bool hasAlertConfig () const;

    /**
     * Returns the value of the member "AlertConfig".
     *
     * List of Alert Configuration
     *
     * @return The value of the field "AlertConfig"
     */
    inline const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertConfig >& getAlertConfig () const;

    /**
     * Retrieves the value of the field "AlertConfig" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlertConfig".
     */
    inline ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertConfig >& getAlertConfigMutable ();

    /**
     * Sets the value of the member "AlertConfig".
     *
     * List of Alert Configuration
     *
     * @param AlertConfig The value which will be set
     */
    inline void setAlertConfig (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertConfig >& AlertConfig_);

    static const SetWSAlertsProjectConfigStart &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertConfig >& getT_WSAlertConfigList_DefaultInstance ();

    inline void set_has_AlertConfig ();

    inline void clear_has_AlertConfig ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertConfig > _AlertConfig;

};

/**
 * The result message of the method "SetWSAlertsProjectConfig"
 * This method is used to set the Project specific configuration data for alerts.
 * Result of the method start.
 */
class SetWSAlertsProjectConfigResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetWSAlertsProjectConfigResult ();

    /**
     * Copy constructor
     */
    inline  SetWSAlertsProjectConfigResult (const SetWSAlertsProjectConfigResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetWSAlertsProjectConfigResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetWSAlertsProjectConfigResult();

    /**
     * Assignment operator
     */
    inline SetWSAlertsProjectConfigResult& operator = (const SetWSAlertsProjectConfigResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWSAlertsProjectConfigResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWSAlertsProjectConfigResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWSAlertsProjectConfigResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWSAlertsProjectConfigResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * True - Success
     * False - Failure
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * True - Success
     * False - Failure
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetWSAlertsProjectConfigResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SetWSAlertsProjectConfig'
 */
class SetWSAlertsProjectConfigErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetWSAlertsProjectConfigErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetWSAlertsProjectConfigErrorStructure (const SetWSAlertsProjectConfigErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetWSAlertsProjectConfigErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetWSAlertsProjectConfigErrorStructure();

    /**
     * Assignment operator
     */
    inline SetWSAlertsProjectConfigErrorStructure& operator = (const SetWSAlertsProjectConfigErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWSAlertsProjectConfigErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWSAlertsProjectConfigErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWSAlertsProjectConfigErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWSAlertsProjectConfigErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    static const SetWSAlertsProjectConfigErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SetWSAlertsProjectConfig'
 */
class SetWSAlertsProjectConfigError  : public ::asf::core::Payload {
public:

    enum SetWSAlertsProjectConfigErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetWSAlertsProjectConfigError ();

   /**
     * Copy constructor
     */
    inline  SetWSAlertsProjectConfigError (const SetWSAlertsProjectConfigError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetWSAlertsProjectConfigError();

    /**
     * Assigns a new value to this object.
     */
    inline SetWSAlertsProjectConfigError& operator = (const SetWSAlertsProjectConfigError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWSAlertsProjectConfigError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWSAlertsProjectConfigError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWSAlertsProjectConfigError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWSAlertsProjectConfigError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetWSAlertsProjectConfigError::SetWSAlertsProjectConfigErrorField getField () const;

    inline void setField(SetWSAlertsProjectConfigError::SetWSAlertsProjectConfigErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetWSAlertsProjectConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetWSAlertsProjectConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetWSAlertsProjectConfigErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetWSAlertsProjectConfigErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetWSAlertsProjectConfigErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetWSAlertsProjectConfigErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetWSAlertsProjectConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetWSAlertsProjectConfigErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetWSAlertsProjectConfigError &getDefaultInstance();

private:

    inline void cloneData (const SetWSAlertsProjectConfigError& rhs);

    inline void deleteData ();

    SetWSAlertsProjectConfigErrorField __field;

    union {
        SetWSAlertsProjectConfigErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ValidateWSAlertMessage"
 * This method is used to verify the perticular alert message is currently valid or expired.
 */
class ValidateWSAlertMessageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ValidateWSAlertMessageStart ();

    /**
     * Copy constructor
     */
    inline  ValidateWSAlertMessageStart (const ValidateWSAlertMessageStart &rhs);

    /**
     * All fields constructor
     */
    inline  ValidateWSAlertMessageStart (uint32 MessageID_);

    /**
     * Destructor
     */
    inline virtual  ~ValidateWSAlertMessageStart();

    /**
     * Assignment operator
     */
    inline ValidateWSAlertMessageStart& operator = (const ValidateWSAlertMessageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ValidateWSAlertMessageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ValidateWSAlertMessageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ValidateWSAlertMessageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ValidateWSAlertMessageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MessageID"

    static const int kMessageID = 0;

    /**
     * Clears the field "MessageID".
     *
     * The field will be set to its default value. The hasMessageID()
     * method will return false.
     */
    inline void clearMessageID();

    /**
     * Checks whether the field "MessageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessageID()). Otherwise it will return false.
     */
    inline bool hasMessageID () const;

    /**
     * Returns the value of the member "MessageID".
     *
     * Message ID
     *
     * @return The value of the field "MessageID"
     */
    inline uint32 getMessageID () const;

    /**
     * Sets the value of the member "MessageID".
     *
     * Message ID
     *
     * @param MessageID The value which will be set
     */
    inline void setMessageID (uint32 MessageID_);

    static const ValidateWSAlertMessageStart &getDefaultInstance();

private:

    inline void set_has_MessageID ();

    inline void clear_has_MessageID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _MessageID;

};

/**
 * The result message of the method "ValidateWSAlertMessage"
 * This method is used to verify the perticular alert message is currently valid or expired.
 * Result of the method start.
 */
class ValidateWSAlertMessageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ValidateWSAlertMessageResult ();

    /**
     * Copy constructor
     */
    inline  ValidateWSAlertMessageResult (const ValidateWSAlertMessageResult &rhs);

    /**
     * All fields constructor
     */
    inline  ValidateWSAlertMessageResult (uint32 MessageID_, bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~ValidateWSAlertMessageResult();

    /**
     * Assignment operator
     */
    inline ValidateWSAlertMessageResult& operator = (const ValidateWSAlertMessageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ValidateWSAlertMessageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ValidateWSAlertMessageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ValidateWSAlertMessageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ValidateWSAlertMessageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MessageID"

    static const int kMessageID = 0;

    /**
     * Clears the field "MessageID".
     *
     * The field will be set to its default value. The hasMessageID()
     * method will return false.
     */
    inline void clearMessageID();

    /**
     * Checks whether the field "MessageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessageID()). Otherwise it will return false.
     */
    inline bool hasMessageID () const;

    /**
     * Returns the value of the member "MessageID".
     *
     * Message ID
     *
     * @return The value of the field "MessageID"
     */
    inline uint32 getMessageID () const;

    /**
     * Sets the value of the member "MessageID".
     *
     * Message ID
     *
     * @param MessageID The value which will be set
     */
    inline void setMessageID (uint32 MessageID_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * True - Valid
     * False - Expired
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * True - Valid
     * False - Expired
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const ValidateWSAlertMessageResult &getDefaultInstance();

private:

    inline void set_has_MessageID ();

    inline void clear_has_MessageID ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _MessageID;

    bool _Status;

};

/**
 * The error message of 'ValidateWSAlertMessage'
 */
class ValidateWSAlertMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ValidateWSAlertMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ValidateWSAlertMessageErrorStructure (const ValidateWSAlertMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ValidateWSAlertMessageErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~ValidateWSAlertMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline ValidateWSAlertMessageErrorStructure& operator = (const ValidateWSAlertMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ValidateWSAlertMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ValidateWSAlertMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ValidateWSAlertMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ValidateWSAlertMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    static const ValidateWSAlertMessageErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'ValidateWSAlertMessage'
 */
class ValidateWSAlertMessageError  : public ::asf::core::Payload {
public:

    enum ValidateWSAlertMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ValidateWSAlertMessageError ();

   /**
     * Copy constructor
     */
    inline  ValidateWSAlertMessageError (const ValidateWSAlertMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ValidateWSAlertMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline ValidateWSAlertMessageError& operator = (const ValidateWSAlertMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ValidateWSAlertMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ValidateWSAlertMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ValidateWSAlertMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ValidateWSAlertMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ValidateWSAlertMessageError::ValidateWSAlertMessageErrorField getField () const;

    inline void setField(ValidateWSAlertMessageError::ValidateWSAlertMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ValidateWSAlertMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ValidateWSAlertMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ValidateWSAlertMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ValidateWSAlertMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ValidateWSAlertMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ValidateWSAlertMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ValidateWSAlertMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ValidateWSAlertMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ValidateWSAlertMessageError &getDefaultInstance();

private:

    inline void cloneData (const ValidateWSAlertMessageError& rhs);

    inline void deleteData ();

    ValidateWSAlertMessageErrorField __field;

    union {
        ValidateWSAlertMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "WSAlertsInfoListStatus"
 * Weather and Security Alerts information result
 */
class WSAlertsInfoListStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WSAlertsInfoListStatusStatus ();

    /**
     * Copy constructor
     */
    inline  WSAlertsInfoListStatusStatus (const WSAlertsInfoListStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WSAlertsInfoListStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& WSAlertsListStatus_);

    /**
     * Destructor
     */
    inline virtual  ~WSAlertsInfoListStatusStatus();

    /**
     * Assignment operator
     */
    inline WSAlertsInfoListStatusStatus& operator = (const WSAlertsInfoListStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WSAlertsInfoListStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WSAlertsInfoListStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WSAlertsInfoListStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WSAlertsInfoListStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WSAlertsListStatus"

    static const int kWSAlertsListStatus = 0;

    /**
     * Clears the field "WSAlertsListStatus".
     *
     * The field will be set to its default value. The hasWSAlertsListStatus()
     * method will return false.
     */
    inline void clearWSAlertsListStatus();

    /**
     * Checks whether the field "WSAlertsListStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWSAlertsListStatus()). Otherwise it will return false.
     */
    inline bool hasWSAlertsListStatus () const;

    /**
     * Returns the value of the member "WSAlertsListStatus".
     *
     * List containing the status provided by the Weather and Security Alerts
     *
     * @return The value of the field "WSAlertsListStatus"
     */
    inline const ::sxm_main_fi_types::T_SxmListInfos& getWSAlertsListStatus () const;

    /**
     * Retrieves the value of the field "WSAlertsListStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WSAlertsListStatus".
     */
    inline ::sxm_main_fi_types::T_SxmListInfos& getWSAlertsListStatusMutable ();

    /**
     * Sets the value of the member "WSAlertsListStatus".
     *
     * List containing the status provided by the Weather and Security Alerts
     *
     * @param WSAlertsListStatus The value which will be set
     */
    inline void setWSAlertsListStatus (const ::sxm_main_fi_types::T_SxmListInfos& WSAlertsListStatus_);

    static const WSAlertsInfoListStatusStatus &getDefaultInstance();

private:

    inline void set_has_WSAlertsListStatus ();

    inline void clear_has_WSAlertsListStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListInfos _WSAlertsListStatus;

};

/**
 * The error message of 'WSAlertsInfoListStatus'
 */
class WSAlertsInfoListStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  WSAlertsInfoListStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  WSAlertsInfoListStatusErrorStructure (const WSAlertsInfoListStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  WSAlertsInfoListStatusErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~WSAlertsInfoListStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline WSAlertsInfoListStatusErrorStructure& operator = (const WSAlertsInfoListStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WSAlertsInfoListStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WSAlertsInfoListStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WSAlertsInfoListStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WSAlertsInfoListStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    static const WSAlertsInfoListStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'WSAlertsInfoListStatus'
 */
class WSAlertsInfoListStatusError  : public ::asf::core::Payload {
public:

    enum WSAlertsInfoListStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  WSAlertsInfoListStatusError ();

   /**
     * Copy constructor
     */
    inline  WSAlertsInfoListStatusError (const WSAlertsInfoListStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~WSAlertsInfoListStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline WSAlertsInfoListStatusError& operator = (const WSAlertsInfoListStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WSAlertsInfoListStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WSAlertsInfoListStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WSAlertsInfoListStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WSAlertsInfoListStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline WSAlertsInfoListStatusError::WSAlertsInfoListStatusErrorField getField () const;

    inline void setField(WSAlertsInfoListStatusError::WSAlertsInfoListStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "WSAlertsInfoListStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "WSAlertsInfoListStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const WSAlertsInfoListStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline WSAlertsInfoListStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline WSAlertsInfoListStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (WSAlertsInfoListStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "WSAlertsInfoListStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const WSAlertsInfoListStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const WSAlertsInfoListStatusError &getDefaultInstance();

private:

    inline void cloneData (const WSAlertsInfoListStatusError& rhs);

    inline void deleteData ();

    WSAlertsInfoListStatusErrorField __field;

    union {
        WSAlertsInfoListStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SxmDataServiceStatus"
 * Get the Status of Weather and Security Alerts Data Service
 */
class SxmDataServiceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmDataServiceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    /**
     * Destructor
     */
    inline virtual  ~SxmDataServiceStatusStatus();

    /**
     * Assignment operator
     */
    inline SxmDataServiceStatusStatus& operator = (const SxmDataServiceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataServiceState"

    static const int kDataServiceState = 0;

    /**
     * Clears the field "DataServiceState".
     *
     * The field will be set to its default value. The hasDataServiceState()
     * method will return false.
     */
    inline void clearDataServiceState();

    /**
     * Checks whether the field "DataServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataServiceState()). Otherwise it will return false.
     */
    inline bool hasDataServiceState () const;

    /**
     * Returns the value of the member "DataServiceState".
     *
     * Status of Weather Security Alerts Data Service
     *
     * @return The value of the field "DataServiceState"
     */
    inline const ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceState () const;

    /**
     * Retrieves the value of the field "DataServiceState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DataServiceState".
     */
    inline ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceStateMutable ();

    /**
     * Sets the value of the member "DataServiceState".
     *
     * Status of Weather Security Alerts Data Service
     *
     * @param DataServiceState The value which will be set
     */
    inline void setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    static const SxmDataServiceStatusStatus &getDefaultInstance();

private:

    inline void set_has_DataServiceState ();

    inline void clear_has_DataServiceState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmDataSrvState _DataServiceState;

};

/**
 * The status message of the property "SxmListMode"
 * Set the Mode of Weather and Security Alerts List.
 */
class SxmListModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeStatus ();

    /**
     * Copy constructor
     */
    inline  SxmListModeStatus (const SxmListModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeStatus();

    /**
     * Assignment operator
     */
    inline SxmListModeStatus& operator = (const SxmListModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of Weather and Security Alerts List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of Weather and Security Alerts List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    static const SxmListModeStatus &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

};

/**
 * The set message of the property "SxmListMode"
 * Set the Mode of Weather and Security Alerts List.
 */
class SxmListModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeSet ();

    /**
     * Copy constructor
     */
    inline  SxmListModeSet (const SxmListModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeSet();

    /**
     * Assignment operator
     */
    inline SxmListModeSet& operator = (const SxmListModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of Weather and Security Alerts List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of Weather and Security Alerts List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    static const SxmListModeSet &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

};

/**
 * The error message of 'SxmListMode'
 */
class SxmListModeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SxmListModeErrorStructure (const SxmListModeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SxmListModeErrorStructure();

    /**
     * Assignment operator
     */
    inline SxmListModeErrorStructure& operator = (const SxmListModeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    static const SxmListModeErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SxmListMode'
 */
class SxmListModeError  : public ::asf::core::Payload {
public:

    enum SxmListModeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SxmListModeError ();

   /**
     * Copy constructor
     */
    inline  SxmListModeError (const SxmListModeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeError();

    /**
     * Assigns a new value to this object.
     */
    inline SxmListModeError& operator = (const SxmListModeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SxmListModeError::SxmListModeErrorField getField () const;

    inline void setField(SxmListModeError::SxmListModeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SxmListModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SxmListModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SxmListModeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SxmListModeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SxmListModeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SxmListModeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SxmListModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SxmListModeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SxmListModeError &getDefaultInstance();

private:

    inline void cloneData (const SxmListModeError& rhs);

    inline void deleteData ();

    SxmListModeErrorField __field;

    union {
        SxmListModeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "WeatherAlertData"
 * Gives the status of the Alert shape data
 */
class WeatherAlertDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WeatherAlertDataStatus ();

    /**
     * Copy constructor
     */
    inline  WeatherAlertDataStatus (const WeatherAlertDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WeatherAlertDataStatus (uint32 UpdateCounter_);

    /**
     * Destructor
     */
    inline virtual  ~WeatherAlertDataStatus();

    /**
     * Assignment operator
     */
    inline WeatherAlertDataStatus& operator = (const WeatherAlertDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WeatherAlertDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WeatherAlertDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WeatherAlertDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WeatherAlertDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateCounter"

    static const int kUpdateCounter = 0;

    /**
     * Clears the field "UpdateCounter".
     *
     * The field will be set to its default value. The hasUpdateCounter()
     * method will return false.
     */
    inline void clearUpdateCounter();

    /**
     * Checks whether the field "UpdateCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateCounter()). Otherwise it will return false.
     */
    inline bool hasUpdateCounter () const;

    /**
     * Returns the value of the member "UpdateCounter".
     *
     * Counter increased with each change in WSAlert Shape data.
     *
     * @return The value of the field "UpdateCounter"
     */
    inline uint32 getUpdateCounter () const;

    /**
     * Sets the value of the member "UpdateCounter".
     *
     * Counter increased with each change in WSAlert Shape data.
     *
     * @param UpdateCounter The value which will be set
     */
    inline void setUpdateCounter (uint32 UpdateCounter_);

    static const WeatherAlertDataStatus &getDefaultInstance();

private:

    inline void set_has_UpdateCounter ();

    inline void clear_has_UpdateCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _UpdateCounter;

};

/**
 * The error message of 'WeatherAlertData'
 */
class WeatherAlertDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  WeatherAlertDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  WeatherAlertDataErrorStructure (const WeatherAlertDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  WeatherAlertDataErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~WeatherAlertDataErrorStructure();

    /**
     * Assignment operator
     */
    inline WeatherAlertDataErrorStructure& operator = (const WeatherAlertDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WeatherAlertDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WeatherAlertDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WeatherAlertDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WeatherAlertDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    static const WeatherAlertDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'WeatherAlertData'
 */
class WeatherAlertDataError  : public ::asf::core::Payload {
public:

    enum WeatherAlertDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  WeatherAlertDataError ();

   /**
     * Copy constructor
     */
    inline  WeatherAlertDataError (const WeatherAlertDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~WeatherAlertDataError();

    /**
     * Assigns a new value to this object.
     */
    inline WeatherAlertDataError& operator = (const WeatherAlertDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WeatherAlertDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WeatherAlertDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WeatherAlertDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WeatherAlertDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline WeatherAlertDataError::WeatherAlertDataErrorField getField () const;

    inline void setField(WeatherAlertDataError::WeatherAlertDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "WeatherAlertDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "WeatherAlertDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const WeatherAlertDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline WeatherAlertDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline WeatherAlertDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (WeatherAlertDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "WeatherAlertDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const WeatherAlertDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const WeatherAlertDataError &getDefaultInstance();

private:

    inline void cloneData (const WeatherAlertDataError& rhs);

    inline void deleteData ();

    WeatherAlertDataErrorField __field;

    union {
        WeatherAlertDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "CurrentWSAlerts"
 * Property update for current WSAlerts to be shown to the user
 */
class CurrentWSAlertsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentWSAlertsStatus ();

    /**
     * Copy constructor
     */
    inline  CurrentWSAlertsStatus (const CurrentWSAlertsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentWSAlertsStatus (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& WSAlertList_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentWSAlertsStatus();

    /**
     * Assignment operator
     */
    inline CurrentWSAlertsStatus& operator = (const CurrentWSAlertsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentWSAlertsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentWSAlertsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentWSAlertsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentWSAlertsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WSAlertList"

    static const int kWSAlertList = 0;

    /**
     * Clears the field "WSAlertList".
     *
     * The field will be set to its default value. The hasWSAlertList()
     * method will return false.
     */
    inline void clearWSAlertList();

    /**
     * Checks whether the field "WSAlertList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWSAlertList()). Otherwise it will return false.
     */
    inline bool hasWSAlertList () const;

    /**
     * Returns the value of the member "WSAlertList".
     *
     * List of Weather and Security Alert messages
     *
     * @return The value of the field "WSAlertList"
     */
    inline const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& getWSAlertList () const;

    /**
     * Retrieves the value of the field "WSAlertList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WSAlertList".
     */
    inline ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& getWSAlertListMutable ();

    /**
     * Sets the value of the member "WSAlertList".
     *
     * List of Weather and Security Alert messages
     *
     * @param WSAlertList The value which will be set
     */
    inline void setWSAlertList (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& WSAlertList_);

    static const CurrentWSAlertsStatus &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& getT_WSAlertMsgList_DefaultInstance ();

    inline void set_has_WSAlertList ();

    inline void clear_has_WSAlertList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg > _WSAlertList;

};

/**
 * The error message of 'CurrentWSAlerts'
 */
class CurrentWSAlertsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CurrentWSAlertsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CurrentWSAlertsErrorStructure (const CurrentWSAlertsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentWSAlertsErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~CurrentWSAlertsErrorStructure();

    /**
     * Assignment operator
     */
    inline CurrentWSAlertsErrorStructure& operator = (const CurrentWSAlertsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentWSAlertsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentWSAlertsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentWSAlertsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentWSAlertsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    static const CurrentWSAlertsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'CurrentWSAlerts'
 */
class CurrentWSAlertsError  : public ::asf::core::Payload {
public:

    enum CurrentWSAlertsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CurrentWSAlertsError ();

   /**
     * Copy constructor
     */
    inline  CurrentWSAlertsError (const CurrentWSAlertsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CurrentWSAlertsError();

    /**
     * Assigns a new value to this object.
     */
    inline CurrentWSAlertsError& operator = (const CurrentWSAlertsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentWSAlertsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentWSAlertsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentWSAlertsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentWSAlertsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CurrentWSAlertsError::CurrentWSAlertsErrorField getField () const;

    inline void setField(CurrentWSAlertsError::CurrentWSAlertsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CurrentWSAlertsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CurrentWSAlertsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CurrentWSAlertsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CurrentWSAlertsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CurrentWSAlertsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CurrentWSAlertsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CurrentWSAlertsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CurrentWSAlertsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CurrentWSAlertsError &getDefaultInstance();

private:

    inline void cloneData (const CurrentWSAlertsError& rhs);

    inline void deleteData ();

    CurrentWSAlertsErrorField __field;

    union {
        CurrentWSAlertsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "WSAlertAnnounceStatus"
 * Status of the WSAlerts
 */
class WSAlertAnnounceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WSAlertAnnounceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  WSAlertAnnounceStatusStatus (const WSAlertAnnounceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WSAlertAnnounceStatusStatus (uint32 MessageID_, ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceStatus WSAlertAnnounceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~WSAlertAnnounceStatusStatus();

    /**
     * Assignment operator
     */
    inline WSAlertAnnounceStatusStatus& operator = (const WSAlertAnnounceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WSAlertAnnounceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WSAlertAnnounceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WSAlertAnnounceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WSAlertAnnounceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MessageID"

    static const int kMessageID = 0;

    /**
     * Clears the field "MessageID".
     *
     * The field will be set to its default value. The hasMessageID()
     * method will return false.
     */
    inline void clearMessageID();

    /**
     * Checks whether the field "MessageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessageID()). Otherwise it will return false.
     */
    inline bool hasMessageID () const;

    /**
     * Returns the value of the member "MessageID".
     *
     * Message ID of the current Alert message for Announcement
     *
     * @return The value of the field "MessageID"
     */
    inline uint32 getMessageID () const;

    /**
     * Sets the value of the member "MessageID".
     *
     * Message ID of the current Alert message for Announcement
     *
     * @param MessageID The value which will be set
     */
    inline void setMessageID (uint32 MessageID_);

    // API of field "WSAlertAnnounceStatus"

    static const int kWSAlertAnnounceStatus = 1;

    /**
     * Clears the field "WSAlertAnnounceStatus".
     *
     * The field will be set to its default value. The hasWSAlertAnnounceStatus()
     * method will return false.
     */
    inline void clearWSAlertAnnounceStatus();

    /**
     * Checks whether the field "WSAlertAnnounceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWSAlertAnnounceStatus()). Otherwise it will return false.
     */
    inline bool hasWSAlertAnnounceStatus () const;

    /**
     * Returns the value of the member "WSAlertAnnounceStatus".
     *
     * Status of the Current Alert message for Announcement
     *
     * @return The value of the field "WSAlertAnnounceStatus"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceStatus getWSAlertAnnounceStatus () const;

    /**
     * Sets the value of the member "WSAlertAnnounceStatus".
     *
     * Status of the Current Alert message for Announcement
     *
     * @param WSAlertAnnounceStatus The value which will be set
     */
    inline void setWSAlertAnnounceStatus (::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceStatus WSAlertAnnounceStatus_);

    static const WSAlertAnnounceStatusStatus &getDefaultInstance();

private:

    inline void set_has_MessageID ();

    inline void clear_has_MessageID ();

    inline void set_has_WSAlertAnnounceStatus ();

    inline void clear_has_WSAlertAnnounceStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _MessageID;

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceStatus _WSAlertAnnounceStatus;

};

/**
 * The error message of 'WSAlertAnnounceStatus'
 */
class WSAlertAnnounceStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  WSAlertAnnounceStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  WSAlertAnnounceStatusErrorStructure (const WSAlertAnnounceStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  WSAlertAnnounceStatusErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~WSAlertAnnounceStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline WSAlertAnnounceStatusErrorStructure& operator = (const WSAlertAnnounceStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WSAlertAnnounceStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WSAlertAnnounceStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WSAlertAnnounceStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WSAlertAnnounceStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_);

    static const WSAlertAnnounceStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'WSAlertAnnounceStatus'
 */
class WSAlertAnnounceStatusError  : public ::asf::core::Payload {
public:

    enum WSAlertAnnounceStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  WSAlertAnnounceStatusError ();

   /**
     * Copy constructor
     */
    inline  WSAlertAnnounceStatusError (const WSAlertAnnounceStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~WSAlertAnnounceStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline WSAlertAnnounceStatusError& operator = (const WSAlertAnnounceStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WSAlertAnnounceStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WSAlertAnnounceStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WSAlertAnnounceStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WSAlertAnnounceStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline WSAlertAnnounceStatusError::WSAlertAnnounceStatusErrorField getField () const;

    inline void setField(WSAlertAnnounceStatusError::WSAlertAnnounceStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "WSAlertAnnounceStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "WSAlertAnnounceStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const WSAlertAnnounceStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline WSAlertAnnounceStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline WSAlertAnnounceStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (WSAlertAnnounceStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "WSAlertAnnounceStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const WSAlertAnnounceStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const WSAlertAnnounceStatusError &getDefaultInstance();

private:

    inline void cloneData (const WSAlertAnnounceStatusError& rhs);

    inline void deleteData ();

    WSAlertAnnounceStatusErrorField __field;

    union {
        WSAlertAnnounceStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

inline  GetWSAlertMsgListStart::GetWSAlertMsgListStart ()  :
    _ListId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetWSAlertMsgListStart::GetWSAlertMsgListStart (const GetWSAlertMsgListStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ListId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetWSAlertMsgListStart::GetWSAlertMsgListStart (uint32 ListId_)  :
    _ListId (ListId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetWSAlertMsgListStart::~GetWSAlertMsgListStart() {
}

inline GetWSAlertMsgListStart& GetWSAlertMsgListStart::operator = (const GetWSAlertMsgListStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListId()) {
            setListId(rhs.getListId());
        } else {
            clearListId();
        }
    }
    return *this;
}

inline bool GetWSAlertMsgListStart::operator == (const GetWSAlertMsgListStart& rhs) const {
    return (((!hasListId() && !rhs.hasListId()) || getListId() == rhs.getListId()));
}

inline bool GetWSAlertMsgListStart::operator != (const GetWSAlertMsgListStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetWSAlertMsgListStart::operator < (const GetWSAlertMsgListStart& rhs) const {
    if (hasListId() || rhs.hasListId()) {
        if (getListId() < rhs.getListId()) return true;
        if (getListId() > rhs.getListId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetWSAlertMsgListStart::clone() {
    return new GetWSAlertMsgListStart(*this);
}

inline bool GetWSAlertMsgListStart::operator > (const GetWSAlertMsgListStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetWSAlertMsgListStart::clear() {
    clearListId();
}

inline void GetWSAlertMsgListStart::clearListId() {
    if (hasListId()) {
         clear_has_ListId();
        _ListId = 0u;
     }
}

inline bool GetWSAlertMsgListStart::hasListId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetWSAlertMsgListStart::getListId () const {
    return _ListId;
}

inline void GetWSAlertMsgListStart::setListId (uint32 ListId_) {
    set_has_ListId();
    this->_ListId = ListId_;
}

inline void GetWSAlertMsgListStart::set_has_ListId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetWSAlertMsgListStart::clear_has_ListId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetWSAlertMsgListResult::GetWSAlertMsgListResult ()  :
    _ListId (0u),
    _WSAlertMsglist ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetWSAlertMsgListResult::GetWSAlertMsgListResult (const GetWSAlertMsgListResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ListId (0u),
    _WSAlertMsglist ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetWSAlertMsgListResult::GetWSAlertMsgListResult (uint32 ListId_, const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& WSAlertMsglist_)  :
    _ListId (ListId_),
    _WSAlertMsglist (WSAlertMsglist_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetWSAlertMsgListResult::~GetWSAlertMsgListResult() {
}

inline GetWSAlertMsgListResult& GetWSAlertMsgListResult::operator = (const GetWSAlertMsgListResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListId()) {
            setListId(rhs.getListId());
        } else {
            clearListId();
        }
        if (rhs.hasWSAlertMsglist()) {
            setWSAlertMsglist(rhs.getWSAlertMsglist());
        } else {
            clearWSAlertMsglist();
        }
    }
    return *this;
}

inline bool GetWSAlertMsgListResult::operator == (const GetWSAlertMsgListResult& rhs) const {
    return (((!hasListId() && !rhs.hasListId()) || getListId() == rhs.getListId()) &&
        ((!hasWSAlertMsglist() && !rhs.hasWSAlertMsglist()) || getWSAlertMsglist() == rhs.getWSAlertMsglist()));
}

inline bool GetWSAlertMsgListResult::operator != (const GetWSAlertMsgListResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetWSAlertMsgListResult::operator < (const GetWSAlertMsgListResult& rhs) const {
    if (hasListId() || rhs.hasListId()) {
        if (getListId() < rhs.getListId()) return true;
        if (getListId() > rhs.getListId()) return false;
    }
    if (hasWSAlertMsglist() || rhs.hasWSAlertMsglist()) {
        if (getWSAlertMsglist() < rhs.getWSAlertMsglist()) return true;
        if (getWSAlertMsglist() > rhs.getWSAlertMsglist()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetWSAlertMsgListResult::clone() {
    return new GetWSAlertMsgListResult(*this);
}

inline bool GetWSAlertMsgListResult::operator > (const GetWSAlertMsgListResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetWSAlertMsgListResult::clear() {
    clearListId();
    clearWSAlertMsglist();
}

inline void GetWSAlertMsgListResult::clearListId() {
    if (hasListId()) {
         clear_has_ListId();
        _ListId = 0u;
     }
}

inline bool GetWSAlertMsgListResult::hasListId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetWSAlertMsgListResult::getListId () const {
    return _ListId;
}

inline void GetWSAlertMsgListResult::setListId (uint32 ListId_) {
    set_has_ListId();
    this->_ListId = ListId_;
}

inline void GetWSAlertMsgListResult::clearWSAlertMsglist() {
    if (hasWSAlertMsglist()) {
         clear_has_WSAlertMsglist();
        _WSAlertMsglist.clear();
     }
}

inline bool GetWSAlertMsgListResult::hasWSAlertMsglist () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& GetWSAlertMsgListResult::getWSAlertMsglist () const {
    return _WSAlertMsglist;
}

inline ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& GetWSAlertMsgListResult::getWSAlertMsglistMutable () {
    set_has_WSAlertMsglist();
    return _WSAlertMsglist;
}

inline void GetWSAlertMsgListResult::setWSAlertMsglist (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& WSAlertMsglist_) {
    set_has_WSAlertMsglist();
    this->_WSAlertMsglist = WSAlertMsglist_;
}

inline void GetWSAlertMsgListResult::set_has_ListId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetWSAlertMsgListResult::clear_has_ListId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetWSAlertMsgListResult::set_has_WSAlertMsglist () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetWSAlertMsgListResult::clear_has_WSAlertMsglist () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetWSAlertMsgListErrorStructure::GetWSAlertMsgListErrorStructure ()  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetWSAlertMsgListErrorStructure::GetWSAlertMsgListErrorStructure (const GetWSAlertMsgListErrorStructure &rhs)  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetWSAlertMsgListErrorStructure::GetWSAlertMsgListErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "GetWSAlertMsgListErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetWSAlertMsgListErrorStructure::~GetWSAlertMsgListErrorStructure() {
}

inline GetWSAlertMsgListErrorStructure& GetWSAlertMsgListErrorStructure::operator = (const GetWSAlertMsgListErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetWSAlertMsgListErrorStructure::operator == (const GetWSAlertMsgListErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetWSAlertMsgListErrorStructure::operator != (const GetWSAlertMsgListErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetWSAlertMsgListErrorStructure::operator < (const GetWSAlertMsgListErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetWSAlertMsgListErrorStructure::operator > (const GetWSAlertMsgListErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetWSAlertMsgListErrorStructure::clear() {
    clearErrorCode();
}

inline void GetWSAlertMsgListErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED;
     }
}

inline bool GetWSAlertMsgListErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes GetWSAlertMsgListErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetWSAlertMsgListErrorStructure::setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "GetWSAlertMsgListErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetWSAlertMsgListErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetWSAlertMsgListErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetWSAlertMsgListError::GetWSAlertMsgListError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetWSAlertMsgListError::GetWSAlertMsgListError (const GetWSAlertMsgListError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetWSAlertMsgListError::~GetWSAlertMsgListError() {
    deleteData ();
}

inline GetWSAlertMsgListError& GetWSAlertMsgListError::operator = (const GetWSAlertMsgListError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetWSAlertMsgListError::operator == (const GetWSAlertMsgListError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetWSAlertMsgListError::operator != (const GetWSAlertMsgListError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetWSAlertMsgListError::operator < (const GetWSAlertMsgListError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetWSAlertMsgListError::operator > (const GetWSAlertMsgListError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetWSAlertMsgListError::GetWSAlertMsgListErrorField GetWSAlertMsgListError::getField () const {
    return __field;
}

inline void GetWSAlertMsgListError::setField(GetWSAlertMsgListError::GetWSAlertMsgListErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetWSAlertMsgListError::clone() {
    return new GetWSAlertMsgListError(*this);
}

inline bool GetWSAlertMsgListError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetWSAlertMsgListErrorStructure& GetWSAlertMsgListError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetWSAlertMsgListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetWSAlertMsgListErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetWSAlertMsgListErrorStructure& GetWSAlertMsgListError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetWSAlertMsgListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetWSAlertMsgListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetWSAlertMsgListErrorStructure* GetWSAlertMsgListError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetWSAlertMsgListError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetWSAlertMsgListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetWSAlertMsgListErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetWSAlertMsgListError::replaceCcaErrorCode (GetWSAlertMsgListErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetWSAlertMsgListError::setCcaErrorCode (const GetWSAlertMsgListErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetWSAlertMsgListErrorStructure(value);
    }
}

inline bool GetWSAlertMsgListError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetWSAlertMsgListError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetWSAlertMsgListError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetWSAlertMsgListError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetWSAlertMsgListError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetWSAlertMsgListError::cloneData (const GetWSAlertMsgListError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetWSAlertMsgListErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetWSAlertMsgListErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetWSAlertMsgListError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SetListsConfigStart::SetListsConfigStart ()  :
    _Config ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigStart::SetListsConfigStart (const SetListsConfigStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Config ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigStart::SetListsConfigStart (const ::sxm_main_fi_types::T_SxmListsConfig& Config_)  :
    _Config (Config_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigStart::~SetListsConfigStart() {
}

inline SetListsConfigStart& SetListsConfigStart::operator = (const SetListsConfigStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfig()) {
            setConfig(rhs.getConfig());
        } else {
            clearConfig();
        }
    }
    return *this;
}

inline bool SetListsConfigStart::operator == (const SetListsConfigStart& rhs) const {
    return (((!hasConfig() && !rhs.hasConfig()) || getConfig() == rhs.getConfig()));
}

inline bool SetListsConfigStart::operator != (const SetListsConfigStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigStart::operator < (const SetListsConfigStart& rhs) const {
    if (hasConfig() || rhs.hasConfig()) {
        if (getConfig() < rhs.getConfig()) return true;
        if (getConfig() > rhs.getConfig()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetListsConfigStart::clone() {
    return new SetListsConfigStart(*this);
}

inline bool SetListsConfigStart::operator > (const SetListsConfigStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigStart::clear() {
    clearConfig();
}

inline void SetListsConfigStart::clearConfig() {
    if (hasConfig()) {
         clear_has_Config();
        _Config.clear();
     }
}

inline bool SetListsConfigStart::hasConfig () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListsConfig& SetListsConfigStart::getConfig () const {
    return _Config;
}

inline ::sxm_main_fi_types::T_SxmListsConfig& SetListsConfigStart::getConfigMutable () {
    set_has_Config();
    return _Config;
}

inline void SetListsConfigStart::setConfig (const ::sxm_main_fi_types::T_SxmListsConfig& Config_) {
    set_has_Config();
    this->_Config = Config_;
}

inline void SetListsConfigStart::set_has_Config () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigStart::clear_has_Config () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigResult::SetListsConfigResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigResult::SetListsConfigResult (const SetListsConfigResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigResult::SetListsConfigResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigResult::~SetListsConfigResult() {
}

inline SetListsConfigResult& SetListsConfigResult::operator = (const SetListsConfigResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SetListsConfigResult::operator == (const SetListsConfigResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SetListsConfigResult::operator != (const SetListsConfigResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigResult::operator < (const SetListsConfigResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetListsConfigResult::clone() {
    return new SetListsConfigResult(*this);
}

inline bool SetListsConfigResult::operator > (const SetListsConfigResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigResult::clear() {
    clearStatus();
}

inline void SetListsConfigResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool SetListsConfigResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetListsConfigResult::getStatus () const {
    return _Status;
}

inline void SetListsConfigResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void SetListsConfigResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigErrorStructure::SetListsConfigErrorStructure ()  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigErrorStructure::SetListsConfigErrorStructure (const SetListsConfigErrorStructure &rhs)  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigErrorStructure::SetListsConfigErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "SetListsConfigErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigErrorStructure::~SetListsConfigErrorStructure() {
}

inline SetListsConfigErrorStructure& SetListsConfigErrorStructure::operator = (const SetListsConfigErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SetListsConfigErrorStructure::operator == (const SetListsConfigErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SetListsConfigErrorStructure::operator != (const SetListsConfigErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigErrorStructure::operator < (const SetListsConfigErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool SetListsConfigErrorStructure::operator > (const SetListsConfigErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigErrorStructure::clear() {
    clearErrorCode();
}

inline void SetListsConfigErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED;
     }
}

inline bool SetListsConfigErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes SetListsConfigErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void SetListsConfigErrorStructure::setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "SetListsConfigErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SetListsConfigErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigError::SetListsConfigError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SetListsConfigError::SetListsConfigError (const SetListsConfigError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SetListsConfigError::~SetListsConfigError() {
    deleteData ();
}

inline SetListsConfigError& SetListsConfigError::operator = (const SetListsConfigError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SetListsConfigError::operator == (const SetListsConfigError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SetListsConfigError::operator != (const SetListsConfigError& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigError::operator < (const SetListsConfigError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SetListsConfigError::operator > (const SetListsConfigError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SetListsConfigError::SetListsConfigErrorField SetListsConfigError::getField () const {
    return __field;
}

inline void SetListsConfigError::setField(SetListsConfigError::SetListsConfigErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SetListsConfigError::clone() {
    return new SetListsConfigError(*this);
}

inline bool SetListsConfigError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SetListsConfigErrorStructure& SetListsConfigError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetListsConfigError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SetListsConfigErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetListsConfigErrorStructure& SetListsConfigError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetListsConfigError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetListsConfigErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetListsConfigErrorStructure* SetListsConfigError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SetListsConfigError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetListsConfigErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SetListsConfigErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SetListsConfigError::replaceCcaErrorCode (SetListsConfigErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SetListsConfigError::setCcaErrorCode (const SetListsConfigErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SetListsConfigErrorStructure(value);
    }
}

inline bool SetListsConfigError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SetListsConfigError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SetListsConfigError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SetListsConfigError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SetListsConfigError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SetListsConfigError::cloneData (const SetListsConfigError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SetListsConfigErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SetListsConfigErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SetListsConfigError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetWeatherAlertDataResult::GetWeatherAlertDataResult ()  :
    _UpdateCounter (0u),
    _Alerts ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetWeatherAlertDataResult::GetWeatherAlertDataResult (const GetWeatherAlertDataResult &rhs)  :
    ::asf::core::Payload(rhs),
    _UpdateCounter (0u),
    _Alerts ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetWeatherAlertDataResult::GetWeatherAlertDataResult (uint32 UpdateCounter_, const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& Alerts_)  :
    _UpdateCounter (UpdateCounter_),
    _Alerts (Alerts_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetWeatherAlertDataResult::~GetWeatherAlertDataResult() {
}

inline GetWeatherAlertDataResult& GetWeatherAlertDataResult::operator = (const GetWeatherAlertDataResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUpdateCounter()) {
            setUpdateCounter(rhs.getUpdateCounter());
        } else {
            clearUpdateCounter();
        }
        if (rhs.hasAlerts()) {
            setAlerts(rhs.getAlerts());
        } else {
            clearAlerts();
        }
    }
    return *this;
}

inline bool GetWeatherAlertDataResult::operator == (const GetWeatherAlertDataResult& rhs) const {
    return (((!hasUpdateCounter() && !rhs.hasUpdateCounter()) || getUpdateCounter() == rhs.getUpdateCounter()) &&
        ((!hasAlerts() && !rhs.hasAlerts()) || getAlerts() == rhs.getAlerts()));
}

inline bool GetWeatherAlertDataResult::operator != (const GetWeatherAlertDataResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetWeatherAlertDataResult::operator < (const GetWeatherAlertDataResult& rhs) const {
    if (hasUpdateCounter() || rhs.hasUpdateCounter()) {
        if (getUpdateCounter() < rhs.getUpdateCounter()) return true;
        if (getUpdateCounter() > rhs.getUpdateCounter()) return false;
    }
    if (hasAlerts() || rhs.hasAlerts()) {
        if (getAlerts() < rhs.getAlerts()) return true;
        if (getAlerts() > rhs.getAlerts()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetWeatherAlertDataResult::clone() {
    return new GetWeatherAlertDataResult(*this);
}

inline bool GetWeatherAlertDataResult::operator > (const GetWeatherAlertDataResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetWeatherAlertDataResult::clear() {
    clearUpdateCounter();
    clearAlerts();
}

inline void GetWeatherAlertDataResult::clearUpdateCounter() {
    if (hasUpdateCounter()) {
         clear_has_UpdateCounter();
        _UpdateCounter = 0u;
     }
}

inline bool GetWeatherAlertDataResult::hasUpdateCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetWeatherAlertDataResult::getUpdateCounter () const {
    return _UpdateCounter;
}

inline void GetWeatherAlertDataResult::setUpdateCounter (uint32 UpdateCounter_) {
    set_has_UpdateCounter();
    this->_UpdateCounter = UpdateCounter_;
}

inline void GetWeatherAlertDataResult::clearAlerts() {
    if (hasAlerts()) {
         clear_has_Alerts();
        _Alerts.clear();
     }
}

inline bool GetWeatherAlertDataResult::hasAlerts () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& GetWeatherAlertDataResult::getAlerts () const {
    return _Alerts;
}

inline ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& GetWeatherAlertDataResult::getAlertsMutable () {
    set_has_Alerts();
    return _Alerts;
}

inline void GetWeatherAlertDataResult::setAlerts (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& Alerts_) {
    set_has_Alerts();
    this->_Alerts = Alerts_;
}

inline void GetWeatherAlertDataResult::set_has_UpdateCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetWeatherAlertDataResult::clear_has_UpdateCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetWeatherAlertDataResult::set_has_Alerts () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetWeatherAlertDataResult::clear_has_Alerts () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetWSAlertsConfigStart::SetWSAlertsConfigStart ()  :
    _AlertTypeIDs (),
    _WSAlertAction (::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType__ENABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetWSAlertsConfigStart::SetWSAlertsConfigStart (const SetWSAlertsConfigStart &rhs)  :
    ::asf::core::Payload(rhs),
    _AlertTypeIDs (),
    _WSAlertAction (::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType__ENABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetWSAlertsConfigStart::SetWSAlertsConfigStart (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes >& AlertTypeIDs_, ::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType WSAlertAction_)  :
    _AlertTypeIDs (AlertTypeIDs_),
    _WSAlertAction (WSAlertAction_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType_IsValid(WSAlertAction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WSAlertAction_, "T_e8_WSAlertActionType", "WSAlertAction", "SetWSAlertsConfigStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetWSAlertsConfigStart::~SetWSAlertsConfigStart() {
}

inline SetWSAlertsConfigStart& SetWSAlertsConfigStart::operator = (const SetWSAlertsConfigStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAlertTypeIDs()) {
            setAlertTypeIDs(rhs.getAlertTypeIDs());
        } else {
            clearAlertTypeIDs();
        }
        if (rhs.hasWSAlertAction()) {
            setWSAlertAction(rhs.getWSAlertAction());
        } else {
            clearWSAlertAction();
        }
    }
    return *this;
}

inline bool SetWSAlertsConfigStart::operator == (const SetWSAlertsConfigStart& rhs) const {
    return (((!hasAlertTypeIDs() && !rhs.hasAlertTypeIDs()) || getAlertTypeIDs() == rhs.getAlertTypeIDs()) &&
        ((!hasWSAlertAction() && !rhs.hasWSAlertAction()) || getWSAlertAction() == rhs.getWSAlertAction()));
}

inline bool SetWSAlertsConfigStart::operator != (const SetWSAlertsConfigStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetWSAlertsConfigStart::operator < (const SetWSAlertsConfigStart& rhs) const {
    if (hasAlertTypeIDs() || rhs.hasAlertTypeIDs()) {
        if (getAlertTypeIDs() < rhs.getAlertTypeIDs()) return true;
        if (getAlertTypeIDs() > rhs.getAlertTypeIDs()) return false;
    }
    if (hasWSAlertAction() || rhs.hasWSAlertAction()) {
        if ((uint32)getWSAlertAction() < (uint32)rhs.getWSAlertAction()) return true;
        if ((uint32)getWSAlertAction() > (uint32)rhs.getWSAlertAction()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetWSAlertsConfigStart::clone() {
    return new SetWSAlertsConfigStart(*this);
}

inline bool SetWSAlertsConfigStart::operator > (const SetWSAlertsConfigStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetWSAlertsConfigStart::clear() {
    clearAlertTypeIDs();
    clearWSAlertAction();
}

inline void SetWSAlertsConfigStart::clearAlertTypeIDs() {
    if (hasAlertTypeIDs()) {
         clear_has_AlertTypeIDs();
        _AlertTypeIDs.clear();
     }
}

inline bool SetWSAlertsConfigStart::hasAlertTypeIDs () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes >& SetWSAlertsConfigStart::getAlertTypeIDs () const {
    return _AlertTypeIDs;
}

inline ::std::vector< ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes >& SetWSAlertsConfigStart::getAlertTypeIDsMutable () {
    set_has_AlertTypeIDs();
    return _AlertTypeIDs;
}

inline void SetWSAlertsConfigStart::setAlertTypeIDs (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes >& AlertTypeIDs_) {
    set_has_AlertTypeIDs();
    this->_AlertTypeIDs = AlertTypeIDs_;
}

inline void SetWSAlertsConfigStart::clearWSAlertAction() {
    if (hasWSAlertAction()) {
         clear_has_WSAlertAction();
        _WSAlertAction = ::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType__ENABLE;
     }
}

inline bool SetWSAlertsConfigStart::hasWSAlertAction () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType SetWSAlertsConfigStart::getWSAlertAction () const {
    return _WSAlertAction;
}

inline void SetWSAlertsConfigStart::setWSAlertAction (::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType WSAlertAction_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlertActionType_IsValid(WSAlertAction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WSAlertAction_, "T_e8_WSAlertActionType", "WSAlertAction", "SetWSAlertsConfigStart");
    }
    #endif
    set_has_WSAlertAction();
    this->_WSAlertAction = WSAlertAction_;
}

inline void SetWSAlertsConfigStart::set_has_AlertTypeIDs () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetWSAlertsConfigStart::clear_has_AlertTypeIDs () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetWSAlertsConfigStart::set_has_WSAlertAction () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetWSAlertsConfigStart::clear_has_WSAlertAction () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetWSAlertsConfigResult::SetWSAlertsConfigResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetWSAlertsConfigResult::SetWSAlertsConfigResult (const SetWSAlertsConfigResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetWSAlertsConfigResult::SetWSAlertsConfigResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetWSAlertsConfigResult::~SetWSAlertsConfigResult() {
}

inline SetWSAlertsConfigResult& SetWSAlertsConfigResult::operator = (const SetWSAlertsConfigResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SetWSAlertsConfigResult::operator == (const SetWSAlertsConfigResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SetWSAlertsConfigResult::operator != (const SetWSAlertsConfigResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetWSAlertsConfigResult::operator < (const SetWSAlertsConfigResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetWSAlertsConfigResult::clone() {
    return new SetWSAlertsConfigResult(*this);
}

inline bool SetWSAlertsConfigResult::operator > (const SetWSAlertsConfigResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetWSAlertsConfigResult::clear() {
    clearStatus();
}

inline void SetWSAlertsConfigResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool SetWSAlertsConfigResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetWSAlertsConfigResult::getStatus () const {
    return _Status;
}

inline void SetWSAlertsConfigResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void SetWSAlertsConfigResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetWSAlertsConfigResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetWSAlertsConfigErrorStructure::SetWSAlertsConfigErrorStructure ()  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetWSAlertsConfigErrorStructure::SetWSAlertsConfigErrorStructure (const SetWSAlertsConfigErrorStructure &rhs)  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetWSAlertsConfigErrorStructure::SetWSAlertsConfigErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "SetWSAlertsConfigErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetWSAlertsConfigErrorStructure::~SetWSAlertsConfigErrorStructure() {
}

inline SetWSAlertsConfigErrorStructure& SetWSAlertsConfigErrorStructure::operator = (const SetWSAlertsConfigErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SetWSAlertsConfigErrorStructure::operator == (const SetWSAlertsConfigErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SetWSAlertsConfigErrorStructure::operator != (const SetWSAlertsConfigErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SetWSAlertsConfigErrorStructure::operator < (const SetWSAlertsConfigErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool SetWSAlertsConfigErrorStructure::operator > (const SetWSAlertsConfigErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetWSAlertsConfigErrorStructure::clear() {
    clearErrorCode();
}

inline void SetWSAlertsConfigErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED;
     }
}

inline bool SetWSAlertsConfigErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes SetWSAlertsConfigErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void SetWSAlertsConfigErrorStructure::setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "SetWSAlertsConfigErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SetWSAlertsConfigErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetWSAlertsConfigErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetWSAlertsConfigError::SetWSAlertsConfigError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SetWSAlertsConfigError::SetWSAlertsConfigError (const SetWSAlertsConfigError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SetWSAlertsConfigError::~SetWSAlertsConfigError() {
    deleteData ();
}

inline SetWSAlertsConfigError& SetWSAlertsConfigError::operator = (const SetWSAlertsConfigError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SetWSAlertsConfigError::operator == (const SetWSAlertsConfigError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SetWSAlertsConfigError::operator != (const SetWSAlertsConfigError& rhs) const {
    return ! (*this == rhs);
}

inline bool SetWSAlertsConfigError::operator < (const SetWSAlertsConfigError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SetWSAlertsConfigError::operator > (const SetWSAlertsConfigError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SetWSAlertsConfigError::SetWSAlertsConfigErrorField SetWSAlertsConfigError::getField () const {
    return __field;
}

inline void SetWSAlertsConfigError::setField(SetWSAlertsConfigError::SetWSAlertsConfigErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SetWSAlertsConfigError::clone() {
    return new SetWSAlertsConfigError(*this);
}

inline bool SetWSAlertsConfigError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SetWSAlertsConfigErrorStructure& SetWSAlertsConfigError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetWSAlertsConfigError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SetWSAlertsConfigErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetWSAlertsConfigErrorStructure& SetWSAlertsConfigError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetWSAlertsConfigError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetWSAlertsConfigErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetWSAlertsConfigErrorStructure* SetWSAlertsConfigError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SetWSAlertsConfigError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetWSAlertsConfigErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SetWSAlertsConfigErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SetWSAlertsConfigError::replaceCcaErrorCode (SetWSAlertsConfigErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SetWSAlertsConfigError::setCcaErrorCode (const SetWSAlertsConfigErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SetWSAlertsConfigErrorStructure(value);
    }
}

inline bool SetWSAlertsConfigError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SetWSAlertsConfigError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SetWSAlertsConfigError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SetWSAlertsConfigError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SetWSAlertsConfigError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SetWSAlertsConfigError::cloneData (const SetWSAlertsConfigError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SetWSAlertsConfigErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SetWSAlertsConfigErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SetWSAlertsConfigError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetWSAlertMsgDetailsStart::GetWSAlertMsgDetailsStart ()  :
    _MessageID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetWSAlertMsgDetailsStart::GetWSAlertMsgDetailsStart (const GetWSAlertMsgDetailsStart &rhs)  :
    ::asf::core::Payload(rhs),
    _MessageID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetWSAlertMsgDetailsStart::GetWSAlertMsgDetailsStart (uint32 MessageID_)  :
    _MessageID (MessageID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetWSAlertMsgDetailsStart::~GetWSAlertMsgDetailsStart() {
}

inline GetWSAlertMsgDetailsStart& GetWSAlertMsgDetailsStart::operator = (const GetWSAlertMsgDetailsStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessageID()) {
            setMessageID(rhs.getMessageID());
        } else {
            clearMessageID();
        }
    }
    return *this;
}

inline bool GetWSAlertMsgDetailsStart::operator == (const GetWSAlertMsgDetailsStart& rhs) const {
    return (((!hasMessageID() && !rhs.hasMessageID()) || getMessageID() == rhs.getMessageID()));
}

inline bool GetWSAlertMsgDetailsStart::operator != (const GetWSAlertMsgDetailsStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetWSAlertMsgDetailsStart::operator < (const GetWSAlertMsgDetailsStart& rhs) const {
    if (hasMessageID() || rhs.hasMessageID()) {
        if (getMessageID() < rhs.getMessageID()) return true;
        if (getMessageID() > rhs.getMessageID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetWSAlertMsgDetailsStart::clone() {
    return new GetWSAlertMsgDetailsStart(*this);
}

inline bool GetWSAlertMsgDetailsStart::operator > (const GetWSAlertMsgDetailsStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetWSAlertMsgDetailsStart::clear() {
    clearMessageID();
}

inline void GetWSAlertMsgDetailsStart::clearMessageID() {
    if (hasMessageID()) {
         clear_has_MessageID();
        _MessageID = 0u;
     }
}

inline bool GetWSAlertMsgDetailsStart::hasMessageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetWSAlertMsgDetailsStart::getMessageID () const {
    return _MessageID;
}

inline void GetWSAlertMsgDetailsStart::setMessageID (uint32 MessageID_) {
    set_has_MessageID();
    this->_MessageID = MessageID_;
}

inline void GetWSAlertMsgDetailsStart::set_has_MessageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetWSAlertMsgDetailsStart::clear_has_MessageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetWSAlertMsgDetailsResult::GetWSAlertMsgDetailsResult ()  :
    _WSAlertMsgInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetWSAlertMsgDetailsResult::GetWSAlertMsgDetailsResult (const GetWSAlertMsgDetailsResult &rhs)  :
    ::asf::core::Payload(rhs),
    _WSAlertMsgInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetWSAlertMsgDetailsResult::GetWSAlertMsgDetailsResult (const ::sxm_wsalerts_main_fi_types::T_WSAlertMsg& WSAlertMsgInfo_)  :
    _WSAlertMsgInfo (WSAlertMsgInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetWSAlertMsgDetailsResult::~GetWSAlertMsgDetailsResult() {
}

inline GetWSAlertMsgDetailsResult& GetWSAlertMsgDetailsResult::operator = (const GetWSAlertMsgDetailsResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWSAlertMsgInfo()) {
            setWSAlertMsgInfo(rhs.getWSAlertMsgInfo());
        } else {
            clearWSAlertMsgInfo();
        }
    }
    return *this;
}

inline bool GetWSAlertMsgDetailsResult::operator == (const GetWSAlertMsgDetailsResult& rhs) const {
    return (((!hasWSAlertMsgInfo() && !rhs.hasWSAlertMsgInfo()) || getWSAlertMsgInfo() == rhs.getWSAlertMsgInfo()));
}

inline bool GetWSAlertMsgDetailsResult::operator != (const GetWSAlertMsgDetailsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetWSAlertMsgDetailsResult::operator < (const GetWSAlertMsgDetailsResult& rhs) const {
    if (hasWSAlertMsgInfo() || rhs.hasWSAlertMsgInfo()) {
        if (getWSAlertMsgInfo() < rhs.getWSAlertMsgInfo()) return true;
        if (getWSAlertMsgInfo() > rhs.getWSAlertMsgInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetWSAlertMsgDetailsResult::clone() {
    return new GetWSAlertMsgDetailsResult(*this);
}

inline bool GetWSAlertMsgDetailsResult::operator > (const GetWSAlertMsgDetailsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetWSAlertMsgDetailsResult::clear() {
    clearWSAlertMsgInfo();
}

inline void GetWSAlertMsgDetailsResult::clearWSAlertMsgInfo() {
    if (hasWSAlertMsgInfo()) {
         clear_has_WSAlertMsgInfo();
        _WSAlertMsgInfo.clear();
     }
}

inline bool GetWSAlertMsgDetailsResult::hasWSAlertMsgInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_wsalerts_main_fi_types::T_WSAlertMsg& GetWSAlertMsgDetailsResult::getWSAlertMsgInfo () const {
    return _WSAlertMsgInfo;
}

inline ::sxm_wsalerts_main_fi_types::T_WSAlertMsg& GetWSAlertMsgDetailsResult::getWSAlertMsgInfoMutable () {
    set_has_WSAlertMsgInfo();
    return _WSAlertMsgInfo;
}

inline void GetWSAlertMsgDetailsResult::setWSAlertMsgInfo (const ::sxm_wsalerts_main_fi_types::T_WSAlertMsg& WSAlertMsgInfo_) {
    set_has_WSAlertMsgInfo();
    this->_WSAlertMsgInfo = WSAlertMsgInfo_;
}

inline void GetWSAlertMsgDetailsResult::set_has_WSAlertMsgInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetWSAlertMsgDetailsResult::clear_has_WSAlertMsgInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetWSAlertMsgDetailsErrorStructure::GetWSAlertMsgDetailsErrorStructure ()  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetWSAlertMsgDetailsErrorStructure::GetWSAlertMsgDetailsErrorStructure (const GetWSAlertMsgDetailsErrorStructure &rhs)  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetWSAlertMsgDetailsErrorStructure::GetWSAlertMsgDetailsErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "GetWSAlertMsgDetailsErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetWSAlertMsgDetailsErrorStructure::~GetWSAlertMsgDetailsErrorStructure() {
}

inline GetWSAlertMsgDetailsErrorStructure& GetWSAlertMsgDetailsErrorStructure::operator = (const GetWSAlertMsgDetailsErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetWSAlertMsgDetailsErrorStructure::operator == (const GetWSAlertMsgDetailsErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetWSAlertMsgDetailsErrorStructure::operator != (const GetWSAlertMsgDetailsErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetWSAlertMsgDetailsErrorStructure::operator < (const GetWSAlertMsgDetailsErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetWSAlertMsgDetailsErrorStructure::operator > (const GetWSAlertMsgDetailsErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetWSAlertMsgDetailsErrorStructure::clear() {
    clearErrorCode();
}

inline void GetWSAlertMsgDetailsErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED;
     }
}

inline bool GetWSAlertMsgDetailsErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes GetWSAlertMsgDetailsErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetWSAlertMsgDetailsErrorStructure::setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "GetWSAlertMsgDetailsErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetWSAlertMsgDetailsErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetWSAlertMsgDetailsErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetWSAlertMsgDetailsError::GetWSAlertMsgDetailsError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetWSAlertMsgDetailsError::GetWSAlertMsgDetailsError (const GetWSAlertMsgDetailsError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetWSAlertMsgDetailsError::~GetWSAlertMsgDetailsError() {
    deleteData ();
}

inline GetWSAlertMsgDetailsError& GetWSAlertMsgDetailsError::operator = (const GetWSAlertMsgDetailsError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetWSAlertMsgDetailsError::operator == (const GetWSAlertMsgDetailsError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetWSAlertMsgDetailsError::operator != (const GetWSAlertMsgDetailsError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetWSAlertMsgDetailsError::operator < (const GetWSAlertMsgDetailsError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetWSAlertMsgDetailsError::operator > (const GetWSAlertMsgDetailsError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetWSAlertMsgDetailsError::GetWSAlertMsgDetailsErrorField GetWSAlertMsgDetailsError::getField () const {
    return __field;
}

inline void GetWSAlertMsgDetailsError::setField(GetWSAlertMsgDetailsError::GetWSAlertMsgDetailsErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetWSAlertMsgDetailsError::clone() {
    return new GetWSAlertMsgDetailsError(*this);
}

inline bool GetWSAlertMsgDetailsError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetWSAlertMsgDetailsErrorStructure& GetWSAlertMsgDetailsError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetWSAlertMsgDetailsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetWSAlertMsgDetailsErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetWSAlertMsgDetailsErrorStructure& GetWSAlertMsgDetailsError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetWSAlertMsgDetailsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetWSAlertMsgDetailsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetWSAlertMsgDetailsErrorStructure* GetWSAlertMsgDetailsError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetWSAlertMsgDetailsError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetWSAlertMsgDetailsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetWSAlertMsgDetailsErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetWSAlertMsgDetailsError::replaceCcaErrorCode (GetWSAlertMsgDetailsErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetWSAlertMsgDetailsError::setCcaErrorCode (const GetWSAlertMsgDetailsErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetWSAlertMsgDetailsErrorStructure(value);
    }
}

inline bool GetWSAlertMsgDetailsError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetWSAlertMsgDetailsError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetWSAlertMsgDetailsError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetWSAlertMsgDetailsError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetWSAlertMsgDetailsError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetWSAlertMsgDetailsError::cloneData (const GetWSAlertMsgDetailsError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetWSAlertMsgDetailsErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetWSAlertMsgDetailsErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetWSAlertMsgDetailsError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  AnnounceWSAlertStart::AnnounceWSAlertStart ()  :
    _MessageID (0u),
    _Action (::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction__ACTION_INVALID),
    _Text ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AnnounceWSAlertStart::AnnounceWSAlertStart (const AnnounceWSAlertStart &rhs)  :
    ::asf::core::Payload(rhs),
    _MessageID (0u),
    _Action (::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction__ACTION_INVALID),
    _Text ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AnnounceWSAlertStart::AnnounceWSAlertStart (uint32 MessageID_, ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction Action_, const ::std::string& Text_)  :
    _MessageID (MessageID_),
    _Action (Action_),
    _Text (Text_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction_IsValid(Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Action_, "T_e8_WSAlertAnnounceAction", "Action", "AnnounceWSAlertStart");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AnnounceWSAlertStart::~AnnounceWSAlertStart() {
}

inline AnnounceWSAlertStart& AnnounceWSAlertStart::operator = (const AnnounceWSAlertStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessageID()) {
            setMessageID(rhs.getMessageID());
        } else {
            clearMessageID();
        }
        if (rhs.hasAction()) {
            setAction(rhs.getAction());
        } else {
            clearAction();
        }
        if (rhs.hasText()) {
            setText(rhs.getText());
        } else {
            clearText();
        }
    }
    return *this;
}

inline bool AnnounceWSAlertStart::operator == (const AnnounceWSAlertStart& rhs) const {
    return (((!hasMessageID() && !rhs.hasMessageID()) || getMessageID() == rhs.getMessageID()) &&
        ((!hasAction() && !rhs.hasAction()) || getAction() == rhs.getAction()) &&
        ((!hasText() && !rhs.hasText()) || getText() == rhs.getText()));
}

inline bool AnnounceWSAlertStart::operator != (const AnnounceWSAlertStart& rhs) const {
    return ! (*this == rhs);
}

inline bool AnnounceWSAlertStart::operator < (const AnnounceWSAlertStart& rhs) const {
    if (hasMessageID() || rhs.hasMessageID()) {
        if (getMessageID() < rhs.getMessageID()) return true;
        if (getMessageID() > rhs.getMessageID()) return false;
    }
    if (hasAction() || rhs.hasAction()) {
        if ((uint32)getAction() < (uint32)rhs.getAction()) return true;
        if ((uint32)getAction() > (uint32)rhs.getAction()) return false;
    }
    if (hasText() || rhs.hasText()) {
        if (getText() < rhs.getText()) return true;
        if (getText() > rhs.getText()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AnnounceWSAlertStart::clone() {
    return new AnnounceWSAlertStart(*this);
}

inline bool AnnounceWSAlertStart::operator > (const AnnounceWSAlertStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AnnounceWSAlertStart::clear() {
    clearMessageID();
    clearAction();
    clearText();
}

inline void AnnounceWSAlertStart::clearMessageID() {
    if (hasMessageID()) {
         clear_has_MessageID();
        _MessageID = 0u;
     }
}

inline bool AnnounceWSAlertStart::hasMessageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AnnounceWSAlertStart::getMessageID () const {
    return _MessageID;
}

inline void AnnounceWSAlertStart::setMessageID (uint32 MessageID_) {
    set_has_MessageID();
    this->_MessageID = MessageID_;
}

inline void AnnounceWSAlertStart::clearAction() {
    if (hasAction()) {
         clear_has_Action();
        _Action = ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction__ACTION_INVALID;
     }
}

inline bool AnnounceWSAlertStart::hasAction () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction AnnounceWSAlertStart::getAction () const {
    return _Action;
}

inline void AnnounceWSAlertStart::setAction (::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction Action_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceAction_IsValid(Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Action_, "T_e8_WSAlertAnnounceAction", "Action", "AnnounceWSAlertStart");
    }
    #endif
    set_has_Action();
    this->_Action = Action_;
}

inline void AnnounceWSAlertStart::clearText() {
    if (hasText()) {
         clear_has_Text();
        _Text.clear();
     }
}

inline bool AnnounceWSAlertStart::hasText () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& AnnounceWSAlertStart::getText () const {
    return _Text;
}

inline ::std::string& AnnounceWSAlertStart::getTextMutable () {
    set_has_Text();
    return _Text;
}

inline void AnnounceWSAlertStart::setText (const ::std::string& Text_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Text();
    this->_Text = Text_;
}

inline void AnnounceWSAlertStart::setText (const char* Text_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Text();
    this->_Text.assign(Text_);
}

inline void AnnounceWSAlertStart::setText (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Text();
    this->_Text.assign(value, size);
}

inline void AnnounceWSAlertStart::set_has_MessageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void AnnounceWSAlertStart::clear_has_MessageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AnnounceWSAlertStart::set_has_Action () {
    _has_bits_[0] |= 1u << 1;
}

inline void AnnounceWSAlertStart::clear_has_Action () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AnnounceWSAlertStart::set_has_Text () {
    _has_bits_[0] |= 1u << 2;
}

inline void AnnounceWSAlertStart::clear_has_Text () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  AnnounceWSAlertResult::AnnounceWSAlertResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AnnounceWSAlertResult::AnnounceWSAlertResult (const AnnounceWSAlertResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AnnounceWSAlertResult::AnnounceWSAlertResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AnnounceWSAlertResult::~AnnounceWSAlertResult() {
}

inline AnnounceWSAlertResult& AnnounceWSAlertResult::operator = (const AnnounceWSAlertResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool AnnounceWSAlertResult::operator == (const AnnounceWSAlertResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool AnnounceWSAlertResult::operator != (const AnnounceWSAlertResult& rhs) const {
    return ! (*this == rhs);
}

inline bool AnnounceWSAlertResult::operator < (const AnnounceWSAlertResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AnnounceWSAlertResult::clone() {
    return new AnnounceWSAlertResult(*this);
}

inline bool AnnounceWSAlertResult::operator > (const AnnounceWSAlertResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AnnounceWSAlertResult::clear() {
    clearStatus();
}

inline void AnnounceWSAlertResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool AnnounceWSAlertResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AnnounceWSAlertResult::getStatus () const {
    return _Status;
}

inline void AnnounceWSAlertResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void AnnounceWSAlertResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void AnnounceWSAlertResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AnnounceWSAlertErrorStructure::AnnounceWSAlertErrorStructure ()  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AnnounceWSAlertErrorStructure::AnnounceWSAlertErrorStructure (const AnnounceWSAlertErrorStructure &rhs)  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AnnounceWSAlertErrorStructure::AnnounceWSAlertErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "AnnounceWSAlertErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AnnounceWSAlertErrorStructure::~AnnounceWSAlertErrorStructure() {
}

inline AnnounceWSAlertErrorStructure& AnnounceWSAlertErrorStructure::operator = (const AnnounceWSAlertErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool AnnounceWSAlertErrorStructure::operator == (const AnnounceWSAlertErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool AnnounceWSAlertErrorStructure::operator != (const AnnounceWSAlertErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool AnnounceWSAlertErrorStructure::operator < (const AnnounceWSAlertErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool AnnounceWSAlertErrorStructure::operator > (const AnnounceWSAlertErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AnnounceWSAlertErrorStructure::clear() {
    clearErrorCode();
}

inline void AnnounceWSAlertErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED;
     }
}

inline bool AnnounceWSAlertErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes AnnounceWSAlertErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void AnnounceWSAlertErrorStructure::setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "AnnounceWSAlertErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void AnnounceWSAlertErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void AnnounceWSAlertErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AnnounceWSAlertError::AnnounceWSAlertError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  AnnounceWSAlertError::AnnounceWSAlertError (const AnnounceWSAlertError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  AnnounceWSAlertError::~AnnounceWSAlertError() {
    deleteData ();
}

inline AnnounceWSAlertError& AnnounceWSAlertError::operator = (const AnnounceWSAlertError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool AnnounceWSAlertError::operator == (const AnnounceWSAlertError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool AnnounceWSAlertError::operator != (const AnnounceWSAlertError& rhs) const {
    return ! (*this == rhs);
}

inline bool AnnounceWSAlertError::operator < (const AnnounceWSAlertError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool AnnounceWSAlertError::operator > (const AnnounceWSAlertError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline AnnounceWSAlertError::AnnounceWSAlertErrorField AnnounceWSAlertError::getField () const {
    return __field;
}

inline void AnnounceWSAlertError::setField(AnnounceWSAlertError::AnnounceWSAlertErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* AnnounceWSAlertError::clone() {
    return new AnnounceWSAlertError(*this);
}

inline bool AnnounceWSAlertError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const AnnounceWSAlertErrorStructure& AnnounceWSAlertError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AnnounceWSAlertError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return AnnounceWSAlertErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline AnnounceWSAlertErrorStructure& AnnounceWSAlertError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AnnounceWSAlertError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new AnnounceWSAlertErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline AnnounceWSAlertErrorStructure* AnnounceWSAlertError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'AnnounceWSAlertError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new AnnounceWSAlertErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        AnnounceWSAlertErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void AnnounceWSAlertError::replaceCcaErrorCode (AnnounceWSAlertErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void AnnounceWSAlertError::setCcaErrorCode (const AnnounceWSAlertErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new AnnounceWSAlertErrorStructure(value);
    }
}

inline bool AnnounceWSAlertError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode AnnounceWSAlertError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "AnnounceWSAlertError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void AnnounceWSAlertError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "AnnounceWSAlertError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void AnnounceWSAlertError::cloneData (const AnnounceWSAlertError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new AnnounceWSAlertErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new AnnounceWSAlertErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void AnnounceWSAlertError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SetWSAlertsProjectConfigStart::SetWSAlertsProjectConfigStart ()  :
    _AlertConfig ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetWSAlertsProjectConfigStart::SetWSAlertsProjectConfigStart (const SetWSAlertsProjectConfigStart &rhs)  :
    ::asf::core::Payload(rhs),
    _AlertConfig ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetWSAlertsProjectConfigStart::SetWSAlertsProjectConfigStart (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertConfig >& AlertConfig_)  :
    _AlertConfig (AlertConfig_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetWSAlertsProjectConfigStart::~SetWSAlertsProjectConfigStart() {
}

inline SetWSAlertsProjectConfigStart& SetWSAlertsProjectConfigStart::operator = (const SetWSAlertsProjectConfigStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAlertConfig()) {
            setAlertConfig(rhs.getAlertConfig());
        } else {
            clearAlertConfig();
        }
    }
    return *this;
}

inline bool SetWSAlertsProjectConfigStart::operator == (const SetWSAlertsProjectConfigStart& rhs) const {
    return (((!hasAlertConfig() && !rhs.hasAlertConfig()) || getAlertConfig() == rhs.getAlertConfig()));
}

inline bool SetWSAlertsProjectConfigStart::operator != (const SetWSAlertsProjectConfigStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetWSAlertsProjectConfigStart::operator < (const SetWSAlertsProjectConfigStart& rhs) const {
    if (hasAlertConfig() || rhs.hasAlertConfig()) {
        if (getAlertConfig() < rhs.getAlertConfig()) return true;
        if (getAlertConfig() > rhs.getAlertConfig()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetWSAlertsProjectConfigStart::clone() {
    return new SetWSAlertsProjectConfigStart(*this);
}

inline bool SetWSAlertsProjectConfigStart::operator > (const SetWSAlertsProjectConfigStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetWSAlertsProjectConfigStart::clear() {
    clearAlertConfig();
}

inline void SetWSAlertsProjectConfigStart::clearAlertConfig() {
    if (hasAlertConfig()) {
         clear_has_AlertConfig();
        _AlertConfig.clear();
     }
}

inline bool SetWSAlertsProjectConfigStart::hasAlertConfig () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertConfig >& SetWSAlertsProjectConfigStart::getAlertConfig () const {
    return _AlertConfig;
}

inline ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertConfig >& SetWSAlertsProjectConfigStart::getAlertConfigMutable () {
    set_has_AlertConfig();
    return _AlertConfig;
}

inline void SetWSAlertsProjectConfigStart::setAlertConfig (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertConfig >& AlertConfig_) {
    set_has_AlertConfig();
    this->_AlertConfig = AlertConfig_;
}

inline void SetWSAlertsProjectConfigStart::set_has_AlertConfig () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetWSAlertsProjectConfigStart::clear_has_AlertConfig () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetWSAlertsProjectConfigResult::SetWSAlertsProjectConfigResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetWSAlertsProjectConfigResult::SetWSAlertsProjectConfigResult (const SetWSAlertsProjectConfigResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetWSAlertsProjectConfigResult::SetWSAlertsProjectConfigResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetWSAlertsProjectConfigResult::~SetWSAlertsProjectConfigResult() {
}

inline SetWSAlertsProjectConfigResult& SetWSAlertsProjectConfigResult::operator = (const SetWSAlertsProjectConfigResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SetWSAlertsProjectConfigResult::operator == (const SetWSAlertsProjectConfigResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SetWSAlertsProjectConfigResult::operator != (const SetWSAlertsProjectConfigResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetWSAlertsProjectConfigResult::operator < (const SetWSAlertsProjectConfigResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetWSAlertsProjectConfigResult::clone() {
    return new SetWSAlertsProjectConfigResult(*this);
}

inline bool SetWSAlertsProjectConfigResult::operator > (const SetWSAlertsProjectConfigResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetWSAlertsProjectConfigResult::clear() {
    clearStatus();
}

inline void SetWSAlertsProjectConfigResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool SetWSAlertsProjectConfigResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetWSAlertsProjectConfigResult::getStatus () const {
    return _Status;
}

inline void SetWSAlertsProjectConfigResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void SetWSAlertsProjectConfigResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetWSAlertsProjectConfigResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetWSAlertsProjectConfigErrorStructure::SetWSAlertsProjectConfigErrorStructure ()  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetWSAlertsProjectConfigErrorStructure::SetWSAlertsProjectConfigErrorStructure (const SetWSAlertsProjectConfigErrorStructure &rhs)  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetWSAlertsProjectConfigErrorStructure::SetWSAlertsProjectConfigErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "SetWSAlertsProjectConfigErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetWSAlertsProjectConfigErrorStructure::~SetWSAlertsProjectConfigErrorStructure() {
}

inline SetWSAlertsProjectConfigErrorStructure& SetWSAlertsProjectConfigErrorStructure::operator = (const SetWSAlertsProjectConfigErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SetWSAlertsProjectConfigErrorStructure::operator == (const SetWSAlertsProjectConfigErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SetWSAlertsProjectConfigErrorStructure::operator != (const SetWSAlertsProjectConfigErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SetWSAlertsProjectConfigErrorStructure::operator < (const SetWSAlertsProjectConfigErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool SetWSAlertsProjectConfigErrorStructure::operator > (const SetWSAlertsProjectConfigErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetWSAlertsProjectConfigErrorStructure::clear() {
    clearErrorCode();
}

inline void SetWSAlertsProjectConfigErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED;
     }
}

inline bool SetWSAlertsProjectConfigErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes SetWSAlertsProjectConfigErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void SetWSAlertsProjectConfigErrorStructure::setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "SetWSAlertsProjectConfigErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SetWSAlertsProjectConfigErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetWSAlertsProjectConfigErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetWSAlertsProjectConfigError::SetWSAlertsProjectConfigError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SetWSAlertsProjectConfigError::SetWSAlertsProjectConfigError (const SetWSAlertsProjectConfigError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SetWSAlertsProjectConfigError::~SetWSAlertsProjectConfigError() {
    deleteData ();
}

inline SetWSAlertsProjectConfigError& SetWSAlertsProjectConfigError::operator = (const SetWSAlertsProjectConfigError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SetWSAlertsProjectConfigError::operator == (const SetWSAlertsProjectConfigError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SetWSAlertsProjectConfigError::operator != (const SetWSAlertsProjectConfigError& rhs) const {
    return ! (*this == rhs);
}

inline bool SetWSAlertsProjectConfigError::operator < (const SetWSAlertsProjectConfigError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SetWSAlertsProjectConfigError::operator > (const SetWSAlertsProjectConfigError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SetWSAlertsProjectConfigError::SetWSAlertsProjectConfigErrorField SetWSAlertsProjectConfigError::getField () const {
    return __field;
}

inline void SetWSAlertsProjectConfigError::setField(SetWSAlertsProjectConfigError::SetWSAlertsProjectConfigErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SetWSAlertsProjectConfigError::clone() {
    return new SetWSAlertsProjectConfigError(*this);
}

inline bool SetWSAlertsProjectConfigError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SetWSAlertsProjectConfigErrorStructure& SetWSAlertsProjectConfigError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetWSAlertsProjectConfigError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SetWSAlertsProjectConfigErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetWSAlertsProjectConfigErrorStructure& SetWSAlertsProjectConfigError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetWSAlertsProjectConfigError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetWSAlertsProjectConfigErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetWSAlertsProjectConfigErrorStructure* SetWSAlertsProjectConfigError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SetWSAlertsProjectConfigError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetWSAlertsProjectConfigErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SetWSAlertsProjectConfigErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SetWSAlertsProjectConfigError::replaceCcaErrorCode (SetWSAlertsProjectConfigErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SetWSAlertsProjectConfigError::setCcaErrorCode (const SetWSAlertsProjectConfigErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SetWSAlertsProjectConfigErrorStructure(value);
    }
}

inline bool SetWSAlertsProjectConfigError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SetWSAlertsProjectConfigError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SetWSAlertsProjectConfigError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SetWSAlertsProjectConfigError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SetWSAlertsProjectConfigError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SetWSAlertsProjectConfigError::cloneData (const SetWSAlertsProjectConfigError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SetWSAlertsProjectConfigErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SetWSAlertsProjectConfigErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SetWSAlertsProjectConfigError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  ValidateWSAlertMessageStart::ValidateWSAlertMessageStart ()  :
    _MessageID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ValidateWSAlertMessageStart::ValidateWSAlertMessageStart (const ValidateWSAlertMessageStart &rhs)  :
    ::asf::core::Payload(rhs),
    _MessageID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ValidateWSAlertMessageStart::ValidateWSAlertMessageStart (uint32 MessageID_)  :
    _MessageID (MessageID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ValidateWSAlertMessageStart::~ValidateWSAlertMessageStart() {
}

inline ValidateWSAlertMessageStart& ValidateWSAlertMessageStart::operator = (const ValidateWSAlertMessageStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessageID()) {
            setMessageID(rhs.getMessageID());
        } else {
            clearMessageID();
        }
    }
    return *this;
}

inline bool ValidateWSAlertMessageStart::operator == (const ValidateWSAlertMessageStart& rhs) const {
    return (((!hasMessageID() && !rhs.hasMessageID()) || getMessageID() == rhs.getMessageID()));
}

inline bool ValidateWSAlertMessageStart::operator != (const ValidateWSAlertMessageStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ValidateWSAlertMessageStart::operator < (const ValidateWSAlertMessageStart& rhs) const {
    if (hasMessageID() || rhs.hasMessageID()) {
        if (getMessageID() < rhs.getMessageID()) return true;
        if (getMessageID() > rhs.getMessageID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ValidateWSAlertMessageStart::clone() {
    return new ValidateWSAlertMessageStart(*this);
}

inline bool ValidateWSAlertMessageStart::operator > (const ValidateWSAlertMessageStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ValidateWSAlertMessageStart::clear() {
    clearMessageID();
}

inline void ValidateWSAlertMessageStart::clearMessageID() {
    if (hasMessageID()) {
         clear_has_MessageID();
        _MessageID = 0u;
     }
}

inline bool ValidateWSAlertMessageStart::hasMessageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ValidateWSAlertMessageStart::getMessageID () const {
    return _MessageID;
}

inline void ValidateWSAlertMessageStart::setMessageID (uint32 MessageID_) {
    set_has_MessageID();
    this->_MessageID = MessageID_;
}

inline void ValidateWSAlertMessageStart::set_has_MessageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ValidateWSAlertMessageStart::clear_has_MessageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ValidateWSAlertMessageResult::ValidateWSAlertMessageResult ()  :
    _MessageID (0u),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ValidateWSAlertMessageResult::ValidateWSAlertMessageResult (const ValidateWSAlertMessageResult &rhs)  :
    ::asf::core::Payload(rhs),
    _MessageID (0u),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ValidateWSAlertMessageResult::ValidateWSAlertMessageResult (uint32 MessageID_, bool Status_)  :
    _MessageID (MessageID_),
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ValidateWSAlertMessageResult::~ValidateWSAlertMessageResult() {
}

inline ValidateWSAlertMessageResult& ValidateWSAlertMessageResult::operator = (const ValidateWSAlertMessageResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessageID()) {
            setMessageID(rhs.getMessageID());
        } else {
            clearMessageID();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool ValidateWSAlertMessageResult::operator == (const ValidateWSAlertMessageResult& rhs) const {
    return (((!hasMessageID() && !rhs.hasMessageID()) || getMessageID() == rhs.getMessageID()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool ValidateWSAlertMessageResult::operator != (const ValidateWSAlertMessageResult& rhs) const {
    return ! (*this == rhs);
}

inline bool ValidateWSAlertMessageResult::operator < (const ValidateWSAlertMessageResult& rhs) const {
    if (hasMessageID() || rhs.hasMessageID()) {
        if (getMessageID() < rhs.getMessageID()) return true;
        if (getMessageID() > rhs.getMessageID()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ValidateWSAlertMessageResult::clone() {
    return new ValidateWSAlertMessageResult(*this);
}

inline bool ValidateWSAlertMessageResult::operator > (const ValidateWSAlertMessageResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ValidateWSAlertMessageResult::clear() {
    clearMessageID();
    clearStatus();
}

inline void ValidateWSAlertMessageResult::clearMessageID() {
    if (hasMessageID()) {
         clear_has_MessageID();
        _MessageID = 0u;
     }
}

inline bool ValidateWSAlertMessageResult::hasMessageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ValidateWSAlertMessageResult::getMessageID () const {
    return _MessageID;
}

inline void ValidateWSAlertMessageResult::setMessageID (uint32 MessageID_) {
    set_has_MessageID();
    this->_MessageID = MessageID_;
}

inline void ValidateWSAlertMessageResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool ValidateWSAlertMessageResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool ValidateWSAlertMessageResult::getStatus () const {
    return _Status;
}

inline void ValidateWSAlertMessageResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void ValidateWSAlertMessageResult::set_has_MessageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ValidateWSAlertMessageResult::clear_has_MessageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ValidateWSAlertMessageResult::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void ValidateWSAlertMessageResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ValidateWSAlertMessageErrorStructure::ValidateWSAlertMessageErrorStructure ()  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ValidateWSAlertMessageErrorStructure::ValidateWSAlertMessageErrorStructure (const ValidateWSAlertMessageErrorStructure &rhs)  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ValidateWSAlertMessageErrorStructure::ValidateWSAlertMessageErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "ValidateWSAlertMessageErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ValidateWSAlertMessageErrorStructure::~ValidateWSAlertMessageErrorStructure() {
}

inline ValidateWSAlertMessageErrorStructure& ValidateWSAlertMessageErrorStructure::operator = (const ValidateWSAlertMessageErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool ValidateWSAlertMessageErrorStructure::operator == (const ValidateWSAlertMessageErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool ValidateWSAlertMessageErrorStructure::operator != (const ValidateWSAlertMessageErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool ValidateWSAlertMessageErrorStructure::operator < (const ValidateWSAlertMessageErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool ValidateWSAlertMessageErrorStructure::operator > (const ValidateWSAlertMessageErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ValidateWSAlertMessageErrorStructure::clear() {
    clearErrorCode();
}

inline void ValidateWSAlertMessageErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED;
     }
}

inline bool ValidateWSAlertMessageErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ValidateWSAlertMessageErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void ValidateWSAlertMessageErrorStructure::setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "ValidateWSAlertMessageErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void ValidateWSAlertMessageErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void ValidateWSAlertMessageErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ValidateWSAlertMessageError::ValidateWSAlertMessageError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  ValidateWSAlertMessageError::ValidateWSAlertMessageError (const ValidateWSAlertMessageError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  ValidateWSAlertMessageError::~ValidateWSAlertMessageError() {
    deleteData ();
}

inline ValidateWSAlertMessageError& ValidateWSAlertMessageError::operator = (const ValidateWSAlertMessageError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool ValidateWSAlertMessageError::operator == (const ValidateWSAlertMessageError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool ValidateWSAlertMessageError::operator != (const ValidateWSAlertMessageError& rhs) const {
    return ! (*this == rhs);
}

inline bool ValidateWSAlertMessageError::operator < (const ValidateWSAlertMessageError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool ValidateWSAlertMessageError::operator > (const ValidateWSAlertMessageError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline ValidateWSAlertMessageError::ValidateWSAlertMessageErrorField ValidateWSAlertMessageError::getField () const {
    return __field;
}

inline void ValidateWSAlertMessageError::setField(ValidateWSAlertMessageError::ValidateWSAlertMessageErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* ValidateWSAlertMessageError::clone() {
    return new ValidateWSAlertMessageError(*this);
}

inline bool ValidateWSAlertMessageError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const ValidateWSAlertMessageErrorStructure& ValidateWSAlertMessageError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "ValidateWSAlertMessageError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return ValidateWSAlertMessageErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline ValidateWSAlertMessageErrorStructure& ValidateWSAlertMessageError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "ValidateWSAlertMessageError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new ValidateWSAlertMessageErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline ValidateWSAlertMessageErrorStructure* ValidateWSAlertMessageError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'ValidateWSAlertMessageError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new ValidateWSAlertMessageErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        ValidateWSAlertMessageErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void ValidateWSAlertMessageError::replaceCcaErrorCode (ValidateWSAlertMessageErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void ValidateWSAlertMessageError::setCcaErrorCode (const ValidateWSAlertMessageErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new ValidateWSAlertMessageErrorStructure(value);
    }
}

inline bool ValidateWSAlertMessageError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode ValidateWSAlertMessageError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "ValidateWSAlertMessageError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void ValidateWSAlertMessageError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "ValidateWSAlertMessageError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void ValidateWSAlertMessageError::cloneData (const ValidateWSAlertMessageError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new ValidateWSAlertMessageErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new ValidateWSAlertMessageErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void ValidateWSAlertMessageError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  WSAlertsInfoListStatusStatus::WSAlertsInfoListStatusStatus ()  :
    _WSAlertsListStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WSAlertsInfoListStatusStatus::WSAlertsInfoListStatusStatus (const WSAlertsInfoListStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _WSAlertsListStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WSAlertsInfoListStatusStatus::WSAlertsInfoListStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& WSAlertsListStatus_)  :
    _WSAlertsListStatus (WSAlertsListStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WSAlertsInfoListStatusStatus::~WSAlertsInfoListStatusStatus() {
}

inline WSAlertsInfoListStatusStatus& WSAlertsInfoListStatusStatus::operator = (const WSAlertsInfoListStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWSAlertsListStatus()) {
            setWSAlertsListStatus(rhs.getWSAlertsListStatus());
        } else {
            clearWSAlertsListStatus();
        }
    }
    return *this;
}

inline bool WSAlertsInfoListStatusStatus::operator == (const WSAlertsInfoListStatusStatus& rhs) const {
    return (((!hasWSAlertsListStatus() && !rhs.hasWSAlertsListStatus()) || getWSAlertsListStatus() == rhs.getWSAlertsListStatus()));
}

inline bool WSAlertsInfoListStatusStatus::operator != (const WSAlertsInfoListStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool WSAlertsInfoListStatusStatus::operator < (const WSAlertsInfoListStatusStatus& rhs) const {
    if (hasWSAlertsListStatus() || rhs.hasWSAlertsListStatus()) {
        if (getWSAlertsListStatus() < rhs.getWSAlertsListStatus()) return true;
        if (getWSAlertsListStatus() > rhs.getWSAlertsListStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WSAlertsInfoListStatusStatus::clone() {
    return new WSAlertsInfoListStatusStatus(*this);
}

inline bool WSAlertsInfoListStatusStatus::operator > (const WSAlertsInfoListStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WSAlertsInfoListStatusStatus::clear() {
    clearWSAlertsListStatus();
}

inline void WSAlertsInfoListStatusStatus::clearWSAlertsListStatus() {
    if (hasWSAlertsListStatus()) {
         clear_has_WSAlertsListStatus();
        _WSAlertsListStatus.clear();
     }
}

inline bool WSAlertsInfoListStatusStatus::hasWSAlertsListStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListInfos& WSAlertsInfoListStatusStatus::getWSAlertsListStatus () const {
    return _WSAlertsListStatus;
}

inline ::sxm_main_fi_types::T_SxmListInfos& WSAlertsInfoListStatusStatus::getWSAlertsListStatusMutable () {
    set_has_WSAlertsListStatus();
    return _WSAlertsListStatus;
}

inline void WSAlertsInfoListStatusStatus::setWSAlertsListStatus (const ::sxm_main_fi_types::T_SxmListInfos& WSAlertsListStatus_) {
    set_has_WSAlertsListStatus();
    this->_WSAlertsListStatus = WSAlertsListStatus_;
}

inline void WSAlertsInfoListStatusStatus::set_has_WSAlertsListStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void WSAlertsInfoListStatusStatus::clear_has_WSAlertsListStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WSAlertsInfoListStatusErrorStructure::WSAlertsInfoListStatusErrorStructure ()  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WSAlertsInfoListStatusErrorStructure::WSAlertsInfoListStatusErrorStructure (const WSAlertsInfoListStatusErrorStructure &rhs)  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WSAlertsInfoListStatusErrorStructure::WSAlertsInfoListStatusErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "WSAlertsInfoListStatusErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WSAlertsInfoListStatusErrorStructure::~WSAlertsInfoListStatusErrorStructure() {
}

inline WSAlertsInfoListStatusErrorStructure& WSAlertsInfoListStatusErrorStructure::operator = (const WSAlertsInfoListStatusErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool WSAlertsInfoListStatusErrorStructure::operator == (const WSAlertsInfoListStatusErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool WSAlertsInfoListStatusErrorStructure::operator != (const WSAlertsInfoListStatusErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool WSAlertsInfoListStatusErrorStructure::operator < (const WSAlertsInfoListStatusErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool WSAlertsInfoListStatusErrorStructure::operator > (const WSAlertsInfoListStatusErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WSAlertsInfoListStatusErrorStructure::clear() {
    clearErrorCode();
}

inline void WSAlertsInfoListStatusErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED;
     }
}

inline bool WSAlertsInfoListStatusErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes WSAlertsInfoListStatusErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void WSAlertsInfoListStatusErrorStructure::setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "WSAlertsInfoListStatusErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void WSAlertsInfoListStatusErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void WSAlertsInfoListStatusErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WSAlertsInfoListStatusError::WSAlertsInfoListStatusError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  WSAlertsInfoListStatusError::WSAlertsInfoListStatusError (const WSAlertsInfoListStatusError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  WSAlertsInfoListStatusError::~WSAlertsInfoListStatusError() {
    deleteData ();
}

inline WSAlertsInfoListStatusError& WSAlertsInfoListStatusError::operator = (const WSAlertsInfoListStatusError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool WSAlertsInfoListStatusError::operator == (const WSAlertsInfoListStatusError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool WSAlertsInfoListStatusError::operator != (const WSAlertsInfoListStatusError& rhs) const {
    return ! (*this == rhs);
}

inline bool WSAlertsInfoListStatusError::operator < (const WSAlertsInfoListStatusError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool WSAlertsInfoListStatusError::operator > (const WSAlertsInfoListStatusError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline WSAlertsInfoListStatusError::WSAlertsInfoListStatusErrorField WSAlertsInfoListStatusError::getField () const {
    return __field;
}

inline void WSAlertsInfoListStatusError::setField(WSAlertsInfoListStatusError::WSAlertsInfoListStatusErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* WSAlertsInfoListStatusError::clone() {
    return new WSAlertsInfoListStatusError(*this);
}

inline bool WSAlertsInfoListStatusError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const WSAlertsInfoListStatusErrorStructure& WSAlertsInfoListStatusError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "WSAlertsInfoListStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return WSAlertsInfoListStatusErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline WSAlertsInfoListStatusErrorStructure& WSAlertsInfoListStatusError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "WSAlertsInfoListStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new WSAlertsInfoListStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline WSAlertsInfoListStatusErrorStructure* WSAlertsInfoListStatusError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'WSAlertsInfoListStatusError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new WSAlertsInfoListStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        WSAlertsInfoListStatusErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void WSAlertsInfoListStatusError::replaceCcaErrorCode (WSAlertsInfoListStatusErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void WSAlertsInfoListStatusError::setCcaErrorCode (const WSAlertsInfoListStatusErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new WSAlertsInfoListStatusErrorStructure(value);
    }
}

inline bool WSAlertsInfoListStatusError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode WSAlertsInfoListStatusError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "WSAlertsInfoListStatusError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void WSAlertsInfoListStatusError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "WSAlertsInfoListStatusError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void WSAlertsInfoListStatusError::cloneData (const WSAlertsInfoListStatusError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new WSAlertsInfoListStatusErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new WSAlertsInfoListStatusErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void WSAlertsInfoListStatusError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus ()  :
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_)  :
    _DataServiceState (DataServiceState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::~SxmDataServiceStatusStatus() {
}

inline SxmDataServiceStatusStatus& SxmDataServiceStatusStatus::operator = (const SxmDataServiceStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataServiceState()) {
            setDataServiceState(rhs.getDataServiceState());
        } else {
            clearDataServiceState();
        }
    }
    return *this;
}

inline bool SxmDataServiceStatusStatus::operator == (const SxmDataServiceStatusStatus& rhs) const {
    return (((!hasDataServiceState() && !rhs.hasDataServiceState()) || getDataServiceState() == rhs.getDataServiceState()));
}

inline bool SxmDataServiceStatusStatus::operator != (const SxmDataServiceStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmDataServiceStatusStatus::operator < (const SxmDataServiceStatusStatus& rhs) const {
    if (hasDataServiceState() || rhs.hasDataServiceState()) {
        if (getDataServiceState() < rhs.getDataServiceState()) return true;
        if (getDataServiceState() > rhs.getDataServiceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmDataServiceStatusStatus::clone() {
    return new SxmDataServiceStatusStatus(*this);
}

inline bool SxmDataServiceStatusStatus::operator > (const SxmDataServiceStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmDataServiceStatusStatus::clear() {
    clearDataServiceState();
}

inline void SxmDataServiceStatusStatus::clearDataServiceState() {
    if (hasDataServiceState()) {
         clear_has_DataServiceState();
        _DataServiceState.clear();
     }
}

inline bool SxmDataServiceStatusStatus::hasDataServiceState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceState () const {
    return _DataServiceState;
}

inline ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceStateMutable () {
    set_has_DataServiceState();
    return _DataServiceState;
}

inline void SxmDataServiceStatusStatus::setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_) {
    set_has_DataServiceState();
    this->_DataServiceState = DataServiceState_;
}

inline void SxmDataServiceStatusStatus::set_has_DataServiceState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmDataServiceStatusStatus::clear_has_DataServiceState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeStatus::SxmListModeStatus ()  :
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeStatus::SxmListModeStatus (const SxmListModeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeStatus::SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_)  :
    _ListMode (ListMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeStatus::~SxmListModeStatus() {
}

inline SxmListModeStatus& SxmListModeStatus::operator = (const SxmListModeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
    }
    return *this;
}

inline bool SxmListModeStatus::operator == (const SxmListModeStatus& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()));
}

inline bool SxmListModeStatus::operator != (const SxmListModeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeStatus::operator < (const SxmListModeStatus& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeStatus::clone() {
    return new SxmListModeStatus(*this);
}

inline bool SxmListModeStatus::operator > (const SxmListModeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeStatus::clear() {
    clearListMode();
}

inline void SxmListModeStatus::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeStatus::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeStatus::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeStatus::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeStatus::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeSet::SxmListModeSet ()  :
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeSet::SxmListModeSet (const SxmListModeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeSet::SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_)  :
    _ListMode (ListMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeSet::~SxmListModeSet() {
}

inline SxmListModeSet& SxmListModeSet::operator = (const SxmListModeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
    }
    return *this;
}

inline bool SxmListModeSet::operator == (const SxmListModeSet& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()));
}

inline bool SxmListModeSet::operator != (const SxmListModeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeSet::operator < (const SxmListModeSet& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeSet::clone() {
    return new SxmListModeSet(*this);
}

inline bool SxmListModeSet::operator > (const SxmListModeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeSet::clear() {
    clearListMode();
}

inline void SxmListModeSet::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeSet::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeSet::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeSet::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeSet::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeErrorStructure::SxmListModeErrorStructure ()  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeErrorStructure::SxmListModeErrorStructure (const SxmListModeErrorStructure &rhs)  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeErrorStructure::SxmListModeErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "SxmListModeErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeErrorStructure::~SxmListModeErrorStructure() {
}

inline SxmListModeErrorStructure& SxmListModeErrorStructure::operator = (const SxmListModeErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SxmListModeErrorStructure::operator == (const SxmListModeErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SxmListModeErrorStructure::operator != (const SxmListModeErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeErrorStructure::operator < (const SxmListModeErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool SxmListModeErrorStructure::operator > (const SxmListModeErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeErrorStructure::clear() {
    clearErrorCode();
}

inline void SxmListModeErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED;
     }
}

inline bool SxmListModeErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes SxmListModeErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void SxmListModeErrorStructure::setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "SxmListModeErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SxmListModeErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeError::SxmListModeError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SxmListModeError::SxmListModeError (const SxmListModeError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SxmListModeError::~SxmListModeError() {
    deleteData ();
}

inline SxmListModeError& SxmListModeError::operator = (const SxmListModeError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SxmListModeError::operator == (const SxmListModeError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SxmListModeError::operator != (const SxmListModeError& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeError::operator < (const SxmListModeError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SxmListModeError::operator > (const SxmListModeError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SxmListModeError::SxmListModeErrorField SxmListModeError::getField () const {
    return __field;
}

inline void SxmListModeError::setField(SxmListModeError::SxmListModeErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SxmListModeError::clone() {
    return new SxmListModeError(*this);
}

inline bool SxmListModeError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SxmListModeErrorStructure& SxmListModeError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SxmListModeError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SxmListModeErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SxmListModeErrorStructure& SxmListModeError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SxmListModeError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SxmListModeErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SxmListModeErrorStructure* SxmListModeError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SxmListModeError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SxmListModeErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SxmListModeErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SxmListModeError::replaceCcaErrorCode (SxmListModeErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SxmListModeError::setCcaErrorCode (const SxmListModeErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SxmListModeErrorStructure(value);
    }
}

inline bool SxmListModeError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SxmListModeError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SxmListModeError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SxmListModeError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SxmListModeError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SxmListModeError::cloneData (const SxmListModeError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SxmListModeErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SxmListModeErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SxmListModeError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  WeatherAlertDataStatus::WeatherAlertDataStatus ()  :
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WeatherAlertDataStatus::WeatherAlertDataStatus (const WeatherAlertDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WeatherAlertDataStatus::WeatherAlertDataStatus (uint32 UpdateCounter_)  :
    _UpdateCounter (UpdateCounter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WeatherAlertDataStatus::~WeatherAlertDataStatus() {
}

inline WeatherAlertDataStatus& WeatherAlertDataStatus::operator = (const WeatherAlertDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUpdateCounter()) {
            setUpdateCounter(rhs.getUpdateCounter());
        } else {
            clearUpdateCounter();
        }
    }
    return *this;
}

inline bool WeatherAlertDataStatus::operator == (const WeatherAlertDataStatus& rhs) const {
    return (((!hasUpdateCounter() && !rhs.hasUpdateCounter()) || getUpdateCounter() == rhs.getUpdateCounter()));
}

inline bool WeatherAlertDataStatus::operator != (const WeatherAlertDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool WeatherAlertDataStatus::operator < (const WeatherAlertDataStatus& rhs) const {
    if (hasUpdateCounter() || rhs.hasUpdateCounter()) {
        if (getUpdateCounter() < rhs.getUpdateCounter()) return true;
        if (getUpdateCounter() > rhs.getUpdateCounter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WeatherAlertDataStatus::clone() {
    return new WeatherAlertDataStatus(*this);
}

inline bool WeatherAlertDataStatus::operator > (const WeatherAlertDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WeatherAlertDataStatus::clear() {
    clearUpdateCounter();
}

inline void WeatherAlertDataStatus::clearUpdateCounter() {
    if (hasUpdateCounter()) {
         clear_has_UpdateCounter();
        _UpdateCounter = 0u;
     }
}

inline bool WeatherAlertDataStatus::hasUpdateCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 WeatherAlertDataStatus::getUpdateCounter () const {
    return _UpdateCounter;
}

inline void WeatherAlertDataStatus::setUpdateCounter (uint32 UpdateCounter_) {
    set_has_UpdateCounter();
    this->_UpdateCounter = UpdateCounter_;
}

inline void WeatherAlertDataStatus::set_has_UpdateCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void WeatherAlertDataStatus::clear_has_UpdateCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WeatherAlertDataErrorStructure::WeatherAlertDataErrorStructure ()  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WeatherAlertDataErrorStructure::WeatherAlertDataErrorStructure (const WeatherAlertDataErrorStructure &rhs)  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WeatherAlertDataErrorStructure::WeatherAlertDataErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "WeatherAlertDataErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WeatherAlertDataErrorStructure::~WeatherAlertDataErrorStructure() {
}

inline WeatherAlertDataErrorStructure& WeatherAlertDataErrorStructure::operator = (const WeatherAlertDataErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool WeatherAlertDataErrorStructure::operator == (const WeatherAlertDataErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool WeatherAlertDataErrorStructure::operator != (const WeatherAlertDataErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool WeatherAlertDataErrorStructure::operator < (const WeatherAlertDataErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool WeatherAlertDataErrorStructure::operator > (const WeatherAlertDataErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WeatherAlertDataErrorStructure::clear() {
    clearErrorCode();
}

inline void WeatherAlertDataErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED;
     }
}

inline bool WeatherAlertDataErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes WeatherAlertDataErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void WeatherAlertDataErrorStructure::setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "WeatherAlertDataErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void WeatherAlertDataErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void WeatherAlertDataErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WeatherAlertDataError::WeatherAlertDataError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  WeatherAlertDataError::WeatherAlertDataError (const WeatherAlertDataError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  WeatherAlertDataError::~WeatherAlertDataError() {
    deleteData ();
}

inline WeatherAlertDataError& WeatherAlertDataError::operator = (const WeatherAlertDataError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool WeatherAlertDataError::operator == (const WeatherAlertDataError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool WeatherAlertDataError::operator != (const WeatherAlertDataError& rhs) const {
    return ! (*this == rhs);
}

inline bool WeatherAlertDataError::operator < (const WeatherAlertDataError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool WeatherAlertDataError::operator > (const WeatherAlertDataError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline WeatherAlertDataError::WeatherAlertDataErrorField WeatherAlertDataError::getField () const {
    return __field;
}

inline void WeatherAlertDataError::setField(WeatherAlertDataError::WeatherAlertDataErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* WeatherAlertDataError::clone() {
    return new WeatherAlertDataError(*this);
}

inline bool WeatherAlertDataError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const WeatherAlertDataErrorStructure& WeatherAlertDataError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "WeatherAlertDataError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return WeatherAlertDataErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline WeatherAlertDataErrorStructure& WeatherAlertDataError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "WeatherAlertDataError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new WeatherAlertDataErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline WeatherAlertDataErrorStructure* WeatherAlertDataError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'WeatherAlertDataError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new WeatherAlertDataErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        WeatherAlertDataErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void WeatherAlertDataError::replaceCcaErrorCode (WeatherAlertDataErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void WeatherAlertDataError::setCcaErrorCode (const WeatherAlertDataErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new WeatherAlertDataErrorStructure(value);
    }
}

inline bool WeatherAlertDataError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode WeatherAlertDataError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "WeatherAlertDataError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void WeatherAlertDataError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "WeatherAlertDataError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void WeatherAlertDataError::cloneData (const WeatherAlertDataError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new WeatherAlertDataErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new WeatherAlertDataErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void WeatherAlertDataError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  CurrentWSAlertsStatus::CurrentWSAlertsStatus ()  :
    _WSAlertList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentWSAlertsStatus::CurrentWSAlertsStatus (const CurrentWSAlertsStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _WSAlertList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentWSAlertsStatus::CurrentWSAlertsStatus (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& WSAlertList_)  :
    _WSAlertList (WSAlertList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CurrentWSAlertsStatus::~CurrentWSAlertsStatus() {
}

inline CurrentWSAlertsStatus& CurrentWSAlertsStatus::operator = (const CurrentWSAlertsStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWSAlertList()) {
            setWSAlertList(rhs.getWSAlertList());
        } else {
            clearWSAlertList();
        }
    }
    return *this;
}

inline bool CurrentWSAlertsStatus::operator == (const CurrentWSAlertsStatus& rhs) const {
    return (((!hasWSAlertList() && !rhs.hasWSAlertList()) || getWSAlertList() == rhs.getWSAlertList()));
}

inline bool CurrentWSAlertsStatus::operator != (const CurrentWSAlertsStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentWSAlertsStatus::operator < (const CurrentWSAlertsStatus& rhs) const {
    if (hasWSAlertList() || rhs.hasWSAlertList()) {
        if (getWSAlertList() < rhs.getWSAlertList()) return true;
        if (getWSAlertList() > rhs.getWSAlertList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CurrentWSAlertsStatus::clone() {
    return new CurrentWSAlertsStatus(*this);
}

inline bool CurrentWSAlertsStatus::operator > (const CurrentWSAlertsStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentWSAlertsStatus::clear() {
    clearWSAlertList();
}

inline void CurrentWSAlertsStatus::clearWSAlertList() {
    if (hasWSAlertList()) {
         clear_has_WSAlertList();
        _WSAlertList.clear();
     }
}

inline bool CurrentWSAlertsStatus::hasWSAlertList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& CurrentWSAlertsStatus::getWSAlertList () const {
    return _WSAlertList;
}

inline ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& CurrentWSAlertsStatus::getWSAlertListMutable () {
    set_has_WSAlertList();
    return _WSAlertList;
}

inline void CurrentWSAlertsStatus::setWSAlertList (const ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertMsg >& WSAlertList_) {
    set_has_WSAlertList();
    this->_WSAlertList = WSAlertList_;
}

inline void CurrentWSAlertsStatus::set_has_WSAlertList () {
    _has_bits_[0] |= 1u << 0;
}

inline void CurrentWSAlertsStatus::clear_has_WSAlertList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CurrentWSAlertsErrorStructure::CurrentWSAlertsErrorStructure ()  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentWSAlertsErrorStructure::CurrentWSAlertsErrorStructure (const CurrentWSAlertsErrorStructure &rhs)  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentWSAlertsErrorStructure::CurrentWSAlertsErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "CurrentWSAlertsErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CurrentWSAlertsErrorStructure::~CurrentWSAlertsErrorStructure() {
}

inline CurrentWSAlertsErrorStructure& CurrentWSAlertsErrorStructure::operator = (const CurrentWSAlertsErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool CurrentWSAlertsErrorStructure::operator == (const CurrentWSAlertsErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool CurrentWSAlertsErrorStructure::operator != (const CurrentWSAlertsErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentWSAlertsErrorStructure::operator < (const CurrentWSAlertsErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool CurrentWSAlertsErrorStructure::operator > (const CurrentWSAlertsErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentWSAlertsErrorStructure::clear() {
    clearErrorCode();
}

inline void CurrentWSAlertsErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED;
     }
}

inline bool CurrentWSAlertsErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes CurrentWSAlertsErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void CurrentWSAlertsErrorStructure::setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "CurrentWSAlertsErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void CurrentWSAlertsErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void CurrentWSAlertsErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CurrentWSAlertsError::CurrentWSAlertsError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  CurrentWSAlertsError::CurrentWSAlertsError (const CurrentWSAlertsError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  CurrentWSAlertsError::~CurrentWSAlertsError() {
    deleteData ();
}

inline CurrentWSAlertsError& CurrentWSAlertsError::operator = (const CurrentWSAlertsError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool CurrentWSAlertsError::operator == (const CurrentWSAlertsError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool CurrentWSAlertsError::operator != (const CurrentWSAlertsError& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentWSAlertsError::operator < (const CurrentWSAlertsError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool CurrentWSAlertsError::operator > (const CurrentWSAlertsError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline CurrentWSAlertsError::CurrentWSAlertsErrorField CurrentWSAlertsError::getField () const {
    return __field;
}

inline void CurrentWSAlertsError::setField(CurrentWSAlertsError::CurrentWSAlertsErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* CurrentWSAlertsError::clone() {
    return new CurrentWSAlertsError(*this);
}

inline bool CurrentWSAlertsError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const CurrentWSAlertsErrorStructure& CurrentWSAlertsError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "CurrentWSAlertsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return CurrentWSAlertsErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline CurrentWSAlertsErrorStructure& CurrentWSAlertsError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "CurrentWSAlertsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new CurrentWSAlertsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline CurrentWSAlertsErrorStructure* CurrentWSAlertsError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'CurrentWSAlertsError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new CurrentWSAlertsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        CurrentWSAlertsErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void CurrentWSAlertsError::replaceCcaErrorCode (CurrentWSAlertsErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void CurrentWSAlertsError::setCcaErrorCode (const CurrentWSAlertsErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new CurrentWSAlertsErrorStructure(value);
    }
}

inline bool CurrentWSAlertsError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode CurrentWSAlertsError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "CurrentWSAlertsError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void CurrentWSAlertsError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "CurrentWSAlertsError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void CurrentWSAlertsError::cloneData (const CurrentWSAlertsError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new CurrentWSAlertsErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new CurrentWSAlertsErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void CurrentWSAlertsError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  WSAlertAnnounceStatusStatus::WSAlertAnnounceStatusStatus ()  :
    _MessageID (0u),
    _WSAlertAnnounceStatus (::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceStatus__STATUS_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WSAlertAnnounceStatusStatus::WSAlertAnnounceStatusStatus (const WSAlertAnnounceStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _MessageID (0u),
    _WSAlertAnnounceStatus (::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceStatus__STATUS_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WSAlertAnnounceStatusStatus::WSAlertAnnounceStatusStatus (uint32 MessageID_, ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceStatus WSAlertAnnounceStatus_)  :
    _MessageID (MessageID_),
    _WSAlertAnnounceStatus (WSAlertAnnounceStatus_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceStatus_IsValid(WSAlertAnnounceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WSAlertAnnounceStatus_, "T_e8_WSAlertAnnounceStatus", "WSAlertAnnounceStatus", "WSAlertAnnounceStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WSAlertAnnounceStatusStatus::~WSAlertAnnounceStatusStatus() {
}

inline WSAlertAnnounceStatusStatus& WSAlertAnnounceStatusStatus::operator = (const WSAlertAnnounceStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessageID()) {
            setMessageID(rhs.getMessageID());
        } else {
            clearMessageID();
        }
        if (rhs.hasWSAlertAnnounceStatus()) {
            setWSAlertAnnounceStatus(rhs.getWSAlertAnnounceStatus());
        } else {
            clearWSAlertAnnounceStatus();
        }
    }
    return *this;
}

inline bool WSAlertAnnounceStatusStatus::operator == (const WSAlertAnnounceStatusStatus& rhs) const {
    return (((!hasMessageID() && !rhs.hasMessageID()) || getMessageID() == rhs.getMessageID()) &&
        ((!hasWSAlertAnnounceStatus() && !rhs.hasWSAlertAnnounceStatus()) || getWSAlertAnnounceStatus() == rhs.getWSAlertAnnounceStatus()));
}

inline bool WSAlertAnnounceStatusStatus::operator != (const WSAlertAnnounceStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool WSAlertAnnounceStatusStatus::operator < (const WSAlertAnnounceStatusStatus& rhs) const {
    if (hasMessageID() || rhs.hasMessageID()) {
        if (getMessageID() < rhs.getMessageID()) return true;
        if (getMessageID() > rhs.getMessageID()) return false;
    }
    if (hasWSAlertAnnounceStatus() || rhs.hasWSAlertAnnounceStatus()) {
        if ((uint32)getWSAlertAnnounceStatus() < (uint32)rhs.getWSAlertAnnounceStatus()) return true;
        if ((uint32)getWSAlertAnnounceStatus() > (uint32)rhs.getWSAlertAnnounceStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WSAlertAnnounceStatusStatus::clone() {
    return new WSAlertAnnounceStatusStatus(*this);
}

inline bool WSAlertAnnounceStatusStatus::operator > (const WSAlertAnnounceStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WSAlertAnnounceStatusStatus::clear() {
    clearMessageID();
    clearWSAlertAnnounceStatus();
}

inline void WSAlertAnnounceStatusStatus::clearMessageID() {
    if (hasMessageID()) {
         clear_has_MessageID();
        _MessageID = 0u;
     }
}

inline bool WSAlertAnnounceStatusStatus::hasMessageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 WSAlertAnnounceStatusStatus::getMessageID () const {
    return _MessageID;
}

inline void WSAlertAnnounceStatusStatus::setMessageID (uint32 MessageID_) {
    set_has_MessageID();
    this->_MessageID = MessageID_;
}

inline void WSAlertAnnounceStatusStatus::clearWSAlertAnnounceStatus() {
    if (hasWSAlertAnnounceStatus()) {
         clear_has_WSAlertAnnounceStatus();
        _WSAlertAnnounceStatus = ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceStatus__STATUS_INVALID;
     }
}

inline bool WSAlertAnnounceStatusStatus::hasWSAlertAnnounceStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceStatus WSAlertAnnounceStatusStatus::getWSAlertAnnounceStatus () const {
    return _WSAlertAnnounceStatus;
}

inline void WSAlertAnnounceStatusStatus::setWSAlertAnnounceStatus (::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceStatus WSAlertAnnounceStatus_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlertAnnounceStatus_IsValid(WSAlertAnnounceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WSAlertAnnounceStatus_, "T_e8_WSAlertAnnounceStatus", "WSAlertAnnounceStatus", "WSAlertAnnounceStatusStatus");
    }
    #endif
    set_has_WSAlertAnnounceStatus();
    this->_WSAlertAnnounceStatus = WSAlertAnnounceStatus_;
}

inline void WSAlertAnnounceStatusStatus::set_has_MessageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void WSAlertAnnounceStatusStatus::clear_has_MessageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void WSAlertAnnounceStatusStatus::set_has_WSAlertAnnounceStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void WSAlertAnnounceStatusStatus::clear_has_WSAlertAnnounceStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  WSAlertAnnounceStatusErrorStructure::WSAlertAnnounceStatusErrorStructure ()  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WSAlertAnnounceStatusErrorStructure::WSAlertAnnounceStatusErrorStructure (const WSAlertAnnounceStatusErrorStructure &rhs)  :
    _ErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WSAlertAnnounceStatusErrorStructure::WSAlertAnnounceStatusErrorStructure (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "WSAlertAnnounceStatusErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WSAlertAnnounceStatusErrorStructure::~WSAlertAnnounceStatusErrorStructure() {
}

inline WSAlertAnnounceStatusErrorStructure& WSAlertAnnounceStatusErrorStructure::operator = (const WSAlertAnnounceStatusErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool WSAlertAnnounceStatusErrorStructure::operator == (const WSAlertAnnounceStatusErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool WSAlertAnnounceStatusErrorStructure::operator != (const WSAlertAnnounceStatusErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool WSAlertAnnounceStatusErrorStructure::operator < (const WSAlertAnnounceStatusErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool WSAlertAnnounceStatusErrorStructure::operator > (const WSAlertAnnounceStatusErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WSAlertAnnounceStatusErrorStructure::clear() {
    clearErrorCode();
}

inline void WSAlertAnnounceStatusErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes__OPERATION_FAILED;
     }
}

inline bool WSAlertAnnounceStatusErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes WSAlertAnnounceStatusErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void WSAlertAnnounceStatusErrorStructure::setErrorCode (::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_wsalerts_main_fi_types::T_e8_WSAlerts_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_WSAlerts_ErrorTypes", "ErrorCode", "WSAlertAnnounceStatusErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void WSAlertAnnounceStatusErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void WSAlertAnnounceStatusErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WSAlertAnnounceStatusError::WSAlertAnnounceStatusError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  WSAlertAnnounceStatusError::WSAlertAnnounceStatusError (const WSAlertAnnounceStatusError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  WSAlertAnnounceStatusError::~WSAlertAnnounceStatusError() {
    deleteData ();
}

inline WSAlertAnnounceStatusError& WSAlertAnnounceStatusError::operator = (const WSAlertAnnounceStatusError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool WSAlertAnnounceStatusError::operator == (const WSAlertAnnounceStatusError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool WSAlertAnnounceStatusError::operator != (const WSAlertAnnounceStatusError& rhs) const {
    return ! (*this == rhs);
}

inline bool WSAlertAnnounceStatusError::operator < (const WSAlertAnnounceStatusError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool WSAlertAnnounceStatusError::operator > (const WSAlertAnnounceStatusError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline WSAlertAnnounceStatusError::WSAlertAnnounceStatusErrorField WSAlertAnnounceStatusError::getField () const {
    return __field;
}

inline void WSAlertAnnounceStatusError::setField(WSAlertAnnounceStatusError::WSAlertAnnounceStatusErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* WSAlertAnnounceStatusError::clone() {
    return new WSAlertAnnounceStatusError(*this);
}

inline bool WSAlertAnnounceStatusError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const WSAlertAnnounceStatusErrorStructure& WSAlertAnnounceStatusError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "WSAlertAnnounceStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return WSAlertAnnounceStatusErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline WSAlertAnnounceStatusErrorStructure& WSAlertAnnounceStatusError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "WSAlertAnnounceStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new WSAlertAnnounceStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline WSAlertAnnounceStatusErrorStructure* WSAlertAnnounceStatusError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'WSAlertAnnounceStatusError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new WSAlertAnnounceStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        WSAlertAnnounceStatusErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void WSAlertAnnounceStatusError::replaceCcaErrorCode (WSAlertAnnounceStatusErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void WSAlertAnnounceStatusError::setCcaErrorCode (const WSAlertAnnounceStatusErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new WSAlertAnnounceStatusErrorStructure(value);
    }
}

inline bool WSAlertAnnounceStatusError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode WSAlertAnnounceStatusError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "WSAlertAnnounceStatusError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void WSAlertAnnounceStatusError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "WSAlertAnnounceStatusError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void WSAlertAnnounceStatusError::cloneData (const WSAlertAnnounceStatusError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new WSAlertAnnounceStatusErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new WSAlertAnnounceStatusErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void WSAlertAnnounceStatusError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

} // namespace sxm_wsalerts_main_fi

#endif // SXM_WSALERTS_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
