#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef FI_TYPES_H
#define FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types fi_types
 */

namespace fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_Reserved;

class T_POSIXTime;

class T_TimeZoneElement;

class T_FIVersion;

class T_PositionWGS84;

class T_RectangleWGS84;

class T_LanguageID;

class T_DistTimeFuel;

// type definitions
/**
 * This type describes percent-values. Value 255 can be used to signal an invalid value.
 */
typedef uint8 T_u8_Percent;

/**
 * This type describes promille-values.
 */
typedef int16 T_s16_PerThousand;

/**
 * Type used to assign a index of an element in the reference list. The indexvalue '0' references the first element of the list. The value 0xffff shows that no element is referenced.
 */
typedef uint16 T_u16_IndexInReferenceList;

/**
 * Type represents an error code.
 */
typedef uint16 T_u16_ErrorCode;

/**
 * u16 type defining a revolution or repetition per minute. The value 65535 means undefined.
 */
typedef uint16 T_u16_RPM;

/**
 * tS32 type defining a weight with a resolution of 1 kg. The meaning of negative values is context dependent, and may not be allowed in several cases.
 */
typedef int32 T_s32_Kilogram;

/**
 * tS32 type defining a weight with a resolution of 1 pound (453,59237 g) . The meaning of negative values is context dependent, and may not be allowed in several cases.
 */
typedef int32 T_s32_Pound;

/**
 * tS16 type defining a length or distance with a resolution of 1 meters. The meaning of negative values is context dependent, and may not be allowed in several cases.
 */
typedef int16 T_s16_Meter;

/**
 * tS32 type defining a length or distance with a resolution of 1 meters. The meaning of negative values is context dependent, and may not be allowed in several cases.
 */
typedef int32 T_s32_Meter;

/**
 * tS32 type defining a length or distance with a resolution of 1 yard (approx. 0,9 m). The meaning of negative values is context dependent, and may not be allowed in several cases. Note that miles can be resolved from yards by multiplication with 1760.
 */
typedef int32 T_s32_Yards;

/**
 * tS32 type defining a length or distance with a resolution of 1 foot (approx. 30,32 cm). The meaning of negative values is context dependent, and may not be allowed in several cases. 3 feet are 1 yard.
 */
typedef int32 T_s32_Foot;

/**
 * tS32 type defining a length or distance with a resolution of 1 centimeter. The meaning of negative values is context dependent, and may not be allowed in several cases.
 */
typedef int32 T_s32_Centimeter;

/**
 * tS32 type defining a length or distance with a resolution of 1 inch (25,4 mm). The meaning of negative values is context dependent, and may not be allowed in several cases. 12 inches are one foot.
 */
typedef int32 T_s32_Inch;

/**
 * tS32 type defining a length or distance with a resolution of 1 millimeter. The meaning of negative values is context dependent, and may not be allowed in several cases.
 */
typedef int32 T_s32_Millimeter;

/**
 * tS32 type defining a volume of fuel with a resolution of 1 microliter.
 */
typedef int32 T_s32_Microliter;

/**
 * tS32 type defining a time with a resolution of 1 second.
 */
typedef int32 T_s32_Second;

/**
 * tU16 type defining a time with a resolution of 1 millisecond (ms).
 */
typedef uint16 T_u16_MilliSecond;

/**
 * tS32 type defining a time with a resolution of 1 millisecond (ms).
 */
typedef int32 T_s32_MilliSecond;

/**
 * tS16 type defining a speed with a resolution of 1 kilometer per hour (km/h). The meaning of negative values is context specific, and may not be allowed in several cases.
 */
typedef int16 T_s16_KmPerHour;

/**
 * tS16 type defining a speed with a resolution of 1 mile per hour (mph). The meaning of negative values is context specific, and may not be allowed in several cases.
 */
typedef int16 T_s16_MilesPerHour;

/**
 * tS16 type defining a speed with a resolution of 1 knot (seamile per hour). The meaning of negative values is context specific, and may not be allowed in several cases.
 */
typedef int16 T_s16_Knot;

/**
 * tS16 type defining a speed with a resolution of 1 centimeter per second (cm/s). The meaning of negative values is context specific, and may not be allowed in several cases.
 */
typedef int16 T_s16_CentimeterSecond;

/**
 * tS16 type defining a temperature in the unit Kelvin. (K). The meaning of negative values is context specific, and may not be allowed in several cases.
 */
typedef int16 T_s16_Kelvin;

/**
 * tS16 type defining a temperature in the unit Fahrenheit (F). The meaning of negative values is context specific, and may not be allowed in several cases.
 */
typedef int16 T_s16_Fahrenheit;

/**
 * tS32 type defining a pressure in the unit Pascal (Pa). The meaning of negative values is context specific, and may not be allowed in several cases.
 */
typedef int32 T_s32_Pascal;

/**
 * tS32 type defining the physical power with a resolution of 1 Watt. The meaning of negative values is context specific, and may not be allowed in certain cases.
 */
typedef int32 T_s32_Watt;

/**
 * tS32 type defining the longitude of an absolute position. Physical Value Range (-180° ... +180°), (West=-, East=+)
 */
typedef int32 T_s32_Longitude;

/**
 * tS32 type defining the latitude of an absolute position. Physical Value Range (-90° ... +90°), (South=-, North=+)
 */
typedef int32 T_s32_Latitude;

/**
 * tU8 type defining an absolute direction with a resolution of 360°/256. Value 0 means north, value 0x40 means west, value 0x80 means south, value 0xC0 means east.
 */
typedef uint8 T_u8_DirectionAbsolute;

/**
 * tU8 type defining an relative direction with a resolution of 360°/256. The reference for the relative direction is context dependent. A typical example for a reference direction is the current driving direction of a vehicle. Value 0 means straight (0°), value 0x40 means left (90°), value 0x80 means back (180°), value 0xC0 means right (270°).
 */
typedef uint8 T_u8_DirectionRelative;

/**
 * tS16 type defining an angle with unit 0.01° (centi-degree). The used range is context specific and could be e.g. [-90;+90] or [-180;180].
 */
typedef int16 T_s16_CentiDegree;

/**
 * tS16 type defining an angle with unit degree. The used range is context specific and could be e.g. [-180;+180] or [0;360]
 */
typedef int16 T_s16_Degree;

/**
 * tU16 type defining an absolute direction with a resolution of 360°*100. Value 0 means north, value 9000 means east, value 18000 means south, value 27000 means west.
 */
typedef uint16 T_u16_DirectionAbsolute_CentiDegree;

/**
 * tS16 type defining an relative direction or a direction deviation with a resolution of 360°*100. The reference for the relative direction is context dependent. A typical example for a reference direction is the current driving direction of a vehicle. Value 0 means straight or no deviation (0°), value 9000 means right (+90°), value 18000 means back (+180°), value -9000 means left (-90°).
 */
typedef int16 T_s16_DirectionRelative_CentiDegree;


/**
 * This type describes reserved value of enumerations or bitfields, used for unions.
 */
class T_Reserved {
public:

    /**
     * Default constructor
     */
    inline  T_Reserved ();

    /**
     * Copy constructor
     */
    inline  T_Reserved (const T_Reserved &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline  ~T_Reserved();

    /**
     * Assignment operator
     */
    inline T_Reserved& operator = (const T_Reserved& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Reserved& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Reserved& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Reserved& ) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Reserved& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const T_Reserved &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "T_POSIXTime" isn't clear, then there should be a description here.
 */
class T_POSIXTime {
public:

    /**
     * Default constructor
     */
    inline  T_POSIXTime ();

    /**
     * Copy constructor
     */
    inline  T_POSIXTime (const T_POSIXTime &rhs);

    /**
     * All fields constructor
     */
    inline  T_POSIXTime (int32 Time_);

    /**
     * Destructor
     */
    inline  ~T_POSIXTime();

    /**
     * Assignment operator
     */
    inline T_POSIXTime& operator = (const T_POSIXTime& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_POSIXTime& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_POSIXTime& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_POSIXTime& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_POSIXTime& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Time"

    static const int kTime = 0;

    /**
     * Clears the field "Time".
     *
     * The field will be set to its default value. The hasTime()
     * method will return false.
     */
    inline void clearTime();

    /**
     * Checks whether the field "Time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTime()). Otherwise it will return false.
     */
    inline bool hasTime () const;

    /**
     * Returns the value of the member "Time".
     *
     * <p>Time since the Epoch (00:00:00 UTC, January 1, 1970), measured in seconds (see  POSIX.1  Annex  B  2.2.2)</p>
     * <p>POSIX.1 defines seconds since the Epoch as a value to be interpreted as the number of seconds between a
     * specified time and the Epoch, according to a formula for conversion from UTC equivalent to conversion on
     * the nave basis that leap seconds are ignored and all years divisible by 4 are leap years.  This value is
     * not the same as the actual number of seconds between the time and the Epoch, because of leap seconds and
     * because clocks are not required to be synchronised to a standard reference.  The intention is that the
     * interpretation of seconds since the Epoch values be consistent</p>
     *
     * @return The value of the field "Time"
     */
    inline int32 getTime () const;

    /**
     * Sets the value of the member "Time".
     *
     * <p>Time since the Epoch (00:00:00 UTC, January 1, 1970), measured in seconds (see  POSIX.1  Annex  B  2.2.2)</p>
     * <p>POSIX.1 defines seconds since the Epoch as a value to be interpreted as the number of seconds between a
     * specified time and the Epoch, according to a formula for conversion from UTC equivalent to conversion on
     * the nave basis that leap seconds are ignored and all years divisible by 4 are leap years.  This value is
     * not the same as the actual number of seconds between the time and the Epoch, because of leap seconds and
     * because clocks are not required to be synchronised to a standard reference.  The intention is that the
     * interpretation of seconds since the Epoch values be consistent</p>
     *
     * @param Time The value which will be set
     */
    inline void setTime (int32 Time_);

    static const T_POSIXTime &getDefaultInstance();

private:

    inline void set_has_Time ();

    inline void clear_has_Time ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _Time;

};

/**
 * This structure contains the type and name of the given intersection.
 */
class T_TimeZoneElement {
public:

    /**
     * Default constructor
     */
    inline  T_TimeZoneElement ();

    /**
     * Copy constructor
     */
    inline  T_TimeZoneElement (const T_TimeZoneElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_TimeZoneElement (const ::std::string& Abbreviation_StandardTime_, const ::std::string& Abbreviation_DST_in_effect_, T_s32_Second TimeZoneDifference_, T_e8_DST_State DST_State_, T_s32_Second DSTDifference_, const ::std::vector< uint8 >& DST_TimeDomain_);

    /**
     * Destructor
     */
    inline  ~T_TimeZoneElement();

    /**
     * Assignment operator
     */
    inline T_TimeZoneElement& operator = (const T_TimeZoneElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TimeZoneElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TimeZoneElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TimeZoneElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TimeZoneElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Abbreviation_StandardTime"

    static const int kAbbreviation_StandardTime = 0;

    /**
     * Clears the field "Abbreviation_StandardTime".
     *
     * The field will be set to its default value. The hasAbbreviation_StandardTime()
     * method will return false.
     */
    inline void clearAbbreviation_StandardTime();

    /**
     * Checks whether the field "Abbreviation_StandardTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAbbreviation_StandardTime()). Otherwise it will return false.
     */
    inline bool hasAbbreviation_StandardTime () const;

    /**
     * Returns the value of the member "Abbreviation_StandardTime".
     *
     * The string contains the abbreviation for name of the time zone. E.g. CET for Central European Time
     *
     * @return The value of the field "Abbreviation_StandardTime"
     */
    inline const ::std::string& getAbbreviation_StandardTime () const;

    /**
     * Retrieves the value of the field "Abbreviation_StandardTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Abbreviation_StandardTime".
     */
    inline ::std::string& getAbbreviation_StandardTimeMutable ();

    /**
     * Sets the value of the member "Abbreviation_StandardTime".
     *
     * The string contains the abbreviation for name of the time zone. E.g. CET for Central European Time
     *
     * @param Abbreviation_StandardTime The value which will be set
     */
    inline void setAbbreviation_StandardTime (const ::std::string& Abbreviation_StandardTime_);

    /**
     * Sets the value of the member "Abbreviation_StandardTime".
     *
     * The string contains the abbreviation for name of the time zone. E.g. CET for Central European Time
     *
     * @param Abbreviation_StandardTime The value which will be set
     */
    inline void setAbbreviation_StandardTime (const char* Abbreviation_StandardTime_);

    /**
     * Sets the value of the member "Abbreviation_StandardTime".
     *
     * The string contains the abbreviation for name of the time zone. E.g. CET for Central European Time
     *
     * @param Abbreviation_StandardTime The value which will be set
     */
    inline void setAbbreviation_StandardTime (const char* value, size_t size);

    // API of field "Abbreviation_DST_in_effect"

    static const int kAbbreviation_DST_in_effect = 1;

    /**
     * Clears the field "Abbreviation_DST_in_effect".
     *
     * The field will be set to its default value. The hasAbbreviation_DST_in_effect()
     * method will return false.
     */
    inline void clearAbbreviation_DST_in_effect();

    /**
     * Checks whether the field "Abbreviation_DST_in_effect" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAbbreviation_DST_in_effect()). Otherwise it will return false.
     */
    inline bool hasAbbreviation_DST_in_effect () const;

    /**
     * Returns the value of the member "Abbreviation_DST_in_effect".
     *
     * The string contains the abbreviation for name of the time zone including the daylight saving time. E.g. CEST for Central European Summer Time or CEDT for Central European Daylight Time when DST is active or CET when DST is not active.
     *
     * @return The value of the field "Abbreviation_DST_in_effect"
     */
    inline const ::std::string& getAbbreviation_DST_in_effect () const;

    /**
     * Retrieves the value of the field "Abbreviation_DST_in_effect" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Abbreviation_DST_in_effect".
     */
    inline ::std::string& getAbbreviation_DST_in_effectMutable ();

    /**
     * Sets the value of the member "Abbreviation_DST_in_effect".
     *
     * The string contains the abbreviation for name of the time zone including the daylight saving time. E.g. CEST for Central European Summer Time or CEDT for Central European Daylight Time when DST is active or CET when DST is not active.
     *
     * @param Abbreviation_DST_in_effect The value which will be set
     */
    inline void setAbbreviation_DST_in_effect (const ::std::string& Abbreviation_DST_in_effect_);

    /**
     * Sets the value of the member "Abbreviation_DST_in_effect".
     *
     * The string contains the abbreviation for name of the time zone including the daylight saving time. E.g. CEST for Central European Summer Time or CEDT for Central European Daylight Time when DST is active or CET when DST is not active.
     *
     * @param Abbreviation_DST_in_effect The value which will be set
     */
    inline void setAbbreviation_DST_in_effect (const char* Abbreviation_DST_in_effect_);

    /**
     * Sets the value of the member "Abbreviation_DST_in_effect".
     *
     * The string contains the abbreviation for name of the time zone including the daylight saving time. E.g. CEST for Central European Summer Time or CEDT for Central European Daylight Time when DST is active or CET when DST is not active.
     *
     * @param Abbreviation_DST_in_effect The value which will be set
     */
    inline void setAbbreviation_DST_in_effect (const char* value, size_t size);

    // API of field "TimeZoneDifference"

    static const int kTimeZoneDifference = 2;

    /**
     * Clears the field "TimeZoneDifference".
     *
     * The field will be set to its default value. The hasTimeZoneDifference()
     * method will return false.
     */
    inline void clearTimeZoneDifference();

    /**
     * Checks whether the field "TimeZoneDifference" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeZoneDifference()). Otherwise it will return false.
     */
    inline bool hasTimeZoneDifference () const;

    /**
     * Returns the value of the member "TimeZoneDifference".
     *
     * Contains the difference in seconds to UTC
     *
     * @return The value of the field "TimeZoneDifference"
     */
    inline T_s32_Second getTimeZoneDifference () const;

    /**
     * Sets the value of the member "TimeZoneDifference".
     *
     * Contains the difference in seconds to UTC
     *
     * @param TimeZoneDifference The value which will be set
     */
    inline void setTimeZoneDifference (T_s32_Second TimeZoneDifference_);

    // API of field "DST_State"

    static const int kDST_State = 3;

    /**
     * Clears the field "DST_State".
     *
     * The field will be set to its default value. The hasDST_State()
     * method will return false.
     */
    inline void clearDST_State();

    /**
     * Checks whether the field "DST_State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDST_State()). Otherwise it will return false.
     */
    inline bool hasDST_State () const;

    /**
     * Returns the value of the member "DST_State".
     *
     * Describes the state for daylight saving time. See T_e8_DST_State documentation for furhter information.
     *
     * @return The value of the field "DST_State"
     */
    inline T_e8_DST_State getDST_State () const;

    /**
     * Sets the value of the member "DST_State".
     *
     * Describes the state for daylight saving time. See T_e8_DST_State documentation for furhter information.
     *
     * @param DST_State The value which will be set
     */
    inline void setDST_State (T_e8_DST_State DST_State_);

    // API of field "DSTDifference"

    static const int kDSTDifference = 4;

    /**
     * Clears the field "DSTDifference".
     *
     * The field will be set to its default value. The hasDSTDifference()
     * method will return false.
     */
    inline void clearDSTDifference();

    /**
     * Checks whether the field "DSTDifference" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDSTDifference()). Otherwise it will return false.
     */
    inline bool hasDSTDifference () const;

    /**
     * Returns the value of the member "DSTDifference".
     *
     * Contains the difference in seconds to 'normal' time when daylight saving time is in effect.
     *
     * @return The value of the field "DSTDifference"
     */
    inline T_s32_Second getDSTDifference () const;

    /**
     * Sets the value of the member "DSTDifference".
     *
     * Contains the difference in seconds to 'normal' time when daylight saving time is in effect.
     *
     * @param DSTDifference The value which will be set
     */
    inline void setDSTDifference (T_s32_Second DSTDifference_);

    // API of field "DST_TimeDomain"

    static const int kDST_TimeDomain = 5;

    /**
     * Clears the field "DST_TimeDomain".
     *
     * The field will be set to its default value. The hasDST_TimeDomain()
     * method will return false.
     */
    inline void clearDST_TimeDomain();

    /**
     * Checks whether the field "DST_TimeDomain" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDST_TimeDomain()). Otherwise it will return false.
     */
    inline bool hasDST_TimeDomain () const;

    /**
     * Returns the value of the member "DST_TimeDomain".
     *
     * This is the time domain expression which defines the time range for which daylight saving time is active. The time domain expression can also be empty, depending on DST_State.
     *
     * @return The value of the field "DST_TimeDomain"
     */
    inline const ::std::vector< uint8 >& getDST_TimeDomain () const;

    /**
     * Retrieves the value of the field "DST_TimeDomain" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DST_TimeDomain".
     */
    inline ::std::vector< uint8 >& getDST_TimeDomainMutable ();

    /**
     * Sets the value of the member "DST_TimeDomain".
     *
     * This is the time domain expression which defines the time range for which daylight saving time is active. The time domain expression can also be empty, depending on DST_State.
     *
     * @param DST_TimeDomain The value which will be set
     */
    inline void setDST_TimeDomain (const ::std::vector< uint8 >& DST_TimeDomain_);

    static const T_TimeZoneElement &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_Abbreviation_StandardTime ();

    inline void clear_has_Abbreviation_StandardTime ();

    inline void set_has_Abbreviation_DST_in_effect ();

    inline void clear_has_Abbreviation_DST_in_effect ();

    inline void set_has_TimeZoneDifference ();

    inline void clear_has_TimeZoneDifference ();

    inline void set_has_DST_State ();

    inline void clear_has_DST_State ();

    inline void set_has_DSTDifference ();

    inline void clear_has_DSTDifference ();

    inline void set_has_DST_TimeDomain ();

    inline void clear_has_DST_TimeDomain ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::std::string _Abbreviation_StandardTime;

    ::std::string _Abbreviation_DST_in_effect;

    T_s32_Second _TimeZoneDifference;

    T_e8_DST_State _DST_State;

    T_s32_Second _DSTDifference;

    ::std::vector< uint8 > _DST_TimeDomain;

};

/**
 * Specifies the version number of the interface as major, minor and patch version.
 */
class T_FIVersion {
public:

    /**
     * Default constructor
     */
    inline  T_FIVersion ();

    /**
     * Copy constructor
     */
    inline  T_FIVersion (const T_FIVersion &rhs);

    /**
     * All fields constructor
     */
    inline  T_FIVersion (uint8 MajorVersion_, uint8 MinorVersion_, uint8 PatchVersion_);

    /**
     * Destructor
     */
    inline  ~T_FIVersion();

    /**
     * Assignment operator
     */
    inline T_FIVersion& operator = (const T_FIVersion& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FIVersion& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FIVersion& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FIVersion& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FIVersion& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MajorVersion"

    static const int kMajorVersion = 0;

    /**
     * Clears the field "MajorVersion".
     *
     * The field will be set to its default value. The hasMajorVersion()
     * method will return false.
     */
    inline void clearMajorVersion();

    /**
     * Checks whether the field "MajorVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMajorVersion()). Otherwise it will return false.
     */
    inline bool hasMajorVersion () const;

    /**
     * Returns the value of the member "MajorVersion".
     *
     * If the meaning of "MajorVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MajorVersion"
     */
    inline uint8 getMajorVersion () const;

    /**
     * Sets the value of the member "MajorVersion".
     *
     * If the meaning of "MajorVersion" isn't clear, then there should be a description here.
     *
     * @param MajorVersion The value which will be set
     */
    inline void setMajorVersion (uint8 MajorVersion_);

    // API of field "MinorVersion"

    static const int kMinorVersion = 1;

    /**
     * Clears the field "MinorVersion".
     *
     * The field will be set to its default value. The hasMinorVersion()
     * method will return false.
     */
    inline void clearMinorVersion();

    /**
     * Checks whether the field "MinorVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinorVersion()). Otherwise it will return false.
     */
    inline bool hasMinorVersion () const;

    /**
     * Returns the value of the member "MinorVersion".
     *
     * If the meaning of "MinorVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MinorVersion"
     */
    inline uint8 getMinorVersion () const;

    /**
     * Sets the value of the member "MinorVersion".
     *
     * If the meaning of "MinorVersion" isn't clear, then there should be a description here.
     *
     * @param MinorVersion The value which will be set
     */
    inline void setMinorVersion (uint8 MinorVersion_);

    // API of field "PatchVersion"

    static const int kPatchVersion = 2;

    /**
     * Clears the field "PatchVersion".
     *
     * The field will be set to its default value. The hasPatchVersion()
     * method will return false.
     */
    inline void clearPatchVersion();

    /**
     * Checks whether the field "PatchVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPatchVersion()). Otherwise it will return false.
     */
    inline bool hasPatchVersion () const;

    /**
     * Returns the value of the member "PatchVersion".
     *
     * If the meaning of "PatchVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PatchVersion"
     */
    inline uint8 getPatchVersion () const;

    /**
     * Sets the value of the member "PatchVersion".
     *
     * If the meaning of "PatchVersion" isn't clear, then there should be a description here.
     *
     * @param PatchVersion The value which will be set
     */
    inline void setPatchVersion (uint8 PatchVersion_);

    static const T_FIVersion &getDefaultInstance();

private:

    inline void set_has_MajorVersion ();

    inline void clear_has_MajorVersion ();

    inline void set_has_MinorVersion ();

    inline void clear_has_MinorVersion ();

    inline void set_has_PatchVersion ();

    inline void clear_has_PatchVersion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _MajorVersion;

    uint8 _MinorVersion;

    uint8 _PatchVersion;

};

/**
 * Record type representing an absolute position in WGS-84 coordinates.
 */
class T_PositionWGS84 {
public:

    /**
     * Default constructor
     */
    inline  T_PositionWGS84 ();

    /**
     * Copy constructor
     */
    inline  T_PositionWGS84 (const T_PositionWGS84 &rhs);

    /**
     * All fields constructor
     */
    inline  T_PositionWGS84 (T_s32_Longitude Longitude_, T_s32_Latitude Latitude_);

    /**
     * Destructor
     */
    inline  ~T_PositionWGS84();

    /**
     * Assignment operator
     */
    inline T_PositionWGS84& operator = (const T_PositionWGS84& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PositionWGS84& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PositionWGS84& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PositionWGS84& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PositionWGS84& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Longitude"

    static const int kLongitude = 0;

    /**
     * Clears the field "Longitude".
     *
     * The field will be set to its default value. The hasLongitude()
     * method will return false.
     */
    inline void clearLongitude();

    /**
     * Checks whether the field "Longitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLongitude()). Otherwise it will return false.
     */
    inline bool hasLongitude () const;

    /**
     * Returns the value of the member "Longitude".
     *
     * Longitude of a WGS-84 position
     *
     * @return The value of the field "Longitude"
     */
    inline T_s32_Longitude getLongitude () const;

    /**
     * Sets the value of the member "Longitude".
     *
     * Longitude of a WGS-84 position
     *
     * @param Longitude The value which will be set
     */
    inline void setLongitude (T_s32_Longitude Longitude_);

    // API of field "Latitude"

    static const int kLatitude = 1;

    /**
     * Clears the field "Latitude".
     *
     * The field will be set to its default value. The hasLatitude()
     * method will return false.
     */
    inline void clearLatitude();

    /**
     * Checks whether the field "Latitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLatitude()). Otherwise it will return false.
     */
    inline bool hasLatitude () const;

    /**
     * Returns the value of the member "Latitude".
     *
     * Latitude of a WGS-84 position
     *
     * @return The value of the field "Latitude"
     */
    inline T_s32_Latitude getLatitude () const;

    /**
     * Sets the value of the member "Latitude".
     *
     * Latitude of a WGS-84 position
     *
     * @param Latitude The value which will be set
     */
    inline void setLatitude (T_s32_Latitude Latitude_);

    static const T_PositionWGS84 &getDefaultInstance();

private:

    inline void set_has_Longitude ();

    inline void clear_has_Longitude ();

    inline void set_has_Latitude ();

    inline void clear_has_Latitude ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_s32_Longitude _Longitude;

    T_s32_Latitude _Latitude;

};

/**
 * Record type representing an rectangle in absolute WGS-84 coordinates.
 */
class T_RectangleWGS84 {
public:

    /**
     * Default constructor
     */
    inline  T_RectangleWGS84 ();

    /**
     * Copy constructor
     */
    inline  T_RectangleWGS84 (const T_RectangleWGS84 &rhs);

    /**
     * All fields constructor
     */
    inline  T_RectangleWGS84 (T_s32_Longitude LongitudeMin_, T_s32_Latitude LatitudeMin_, T_s32_Longitude LongitudeMax_, T_s32_Latitude LatitudeMax_);

    /**
     * Destructor
     */
    inline  ~T_RectangleWGS84();

    /**
     * Assignment operator
     */
    inline T_RectangleWGS84& operator = (const T_RectangleWGS84& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_RectangleWGS84& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_RectangleWGS84& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_RectangleWGS84& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_RectangleWGS84& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LongitudeMin"

    static const int kLongitudeMin = 0;

    /**
     * Clears the field "LongitudeMin".
     *
     * The field will be set to its default value. The hasLongitudeMin()
     * method will return false.
     */
    inline void clearLongitudeMin();

    /**
     * Checks whether the field "LongitudeMin" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLongitudeMin()). Otherwise it will return false.
     */
    inline bool hasLongitudeMin () const;

    /**
     * Returns the value of the member "LongitudeMin".
     *
     * minimal longitude value of rectangle
     *
     * @return The value of the field "LongitudeMin"
     */
    inline T_s32_Longitude getLongitudeMin () const;

    /**
     * Sets the value of the member "LongitudeMin".
     *
     * minimal longitude value of rectangle
     *
     * @param LongitudeMin The value which will be set
     */
    inline void setLongitudeMin (T_s32_Longitude LongitudeMin_);

    // API of field "LatitudeMin"

    static const int kLatitudeMin = 1;

    /**
     * Clears the field "LatitudeMin".
     *
     * The field will be set to its default value. The hasLatitudeMin()
     * method will return false.
     */
    inline void clearLatitudeMin();

    /**
     * Checks whether the field "LatitudeMin" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLatitudeMin()). Otherwise it will return false.
     */
    inline bool hasLatitudeMin () const;

    /**
     * Returns the value of the member "LatitudeMin".
     *
     * minimal latitude value of rectangle
     *
     * @return The value of the field "LatitudeMin"
     */
    inline T_s32_Latitude getLatitudeMin () const;

    /**
     * Sets the value of the member "LatitudeMin".
     *
     * minimal latitude value of rectangle
     *
     * @param LatitudeMin The value which will be set
     */
    inline void setLatitudeMin (T_s32_Latitude LatitudeMin_);

    // API of field "LongitudeMax"

    static const int kLongitudeMax = 2;

    /**
     * Clears the field "LongitudeMax".
     *
     * The field will be set to its default value. The hasLongitudeMax()
     * method will return false.
     */
    inline void clearLongitudeMax();

    /**
     * Checks whether the field "LongitudeMax" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLongitudeMax()). Otherwise it will return false.
     */
    inline bool hasLongitudeMax () const;

    /**
     * Returns the value of the member "LongitudeMax".
     *
     * maximal longitude value of rectangle
     *
     * @return The value of the field "LongitudeMax"
     */
    inline T_s32_Longitude getLongitudeMax () const;

    /**
     * Sets the value of the member "LongitudeMax".
     *
     * maximal longitude value of rectangle
     *
     * @param LongitudeMax The value which will be set
     */
    inline void setLongitudeMax (T_s32_Longitude LongitudeMax_);

    // API of field "LatitudeMax"

    static const int kLatitudeMax = 3;

    /**
     * Clears the field "LatitudeMax".
     *
     * The field will be set to its default value. The hasLatitudeMax()
     * method will return false.
     */
    inline void clearLatitudeMax();

    /**
     * Checks whether the field "LatitudeMax" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLatitudeMax()). Otherwise it will return false.
     */
    inline bool hasLatitudeMax () const;

    /**
     * Returns the value of the member "LatitudeMax".
     *
     * maximal latitude value of rectangle
     *
     * @return The value of the field "LatitudeMax"
     */
    inline T_s32_Latitude getLatitudeMax () const;

    /**
     * Sets the value of the member "LatitudeMax".
     *
     * maximal latitude value of rectangle
     *
     * @param LatitudeMax The value which will be set
     */
    inline void setLatitudeMax (T_s32_Latitude LatitudeMax_);

    static const T_RectangleWGS84 &getDefaultInstance();

private:

    inline void set_has_LongitudeMin ();

    inline void clear_has_LongitudeMin ();

    inline void set_has_LatitudeMin ();

    inline void clear_has_LatitudeMin ();

    inline void set_has_LongitudeMax ();

    inline void clear_has_LongitudeMax ();

    inline void set_has_LatitudeMax ();

    inline void clear_has_LatitudeMax ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_s32_Longitude _LongitudeMin;

    T_s32_Latitude _LatitudeMin;

    T_s32_Longitude _LongitudeMax;

    T_s32_Latitude _LatitudeMax;

};

/**
 * Structured Type: e.g. "de",0 -> German "en", -> English
 */
class T_LanguageID {
public:

    /**
     * Default constructor
     */
    inline  T_LanguageID ();

    /**
     * Copy constructor
     */
    inline  T_LanguageID (const T_LanguageID &rhs);

    /**
     * All fields constructor
     */
    inline  T_LanguageID (T_e16_ISOLanguageCode ISO639_LanguageCode_, T_e16_ISOCountryCode ISO3166_CountryCode_);

    /**
     * Destructor
     */
    inline  ~T_LanguageID();

    /**
     * Assignment operator
     */
    inline T_LanguageID& operator = (const T_LanguageID& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_LanguageID& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_LanguageID& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_LanguageID& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_LanguageID& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ISO639_LanguageCode"

    static const int kISO639_LanguageCode = 0;

    /**
     * Clears the field "ISO639_LanguageCode".
     *
     * The field will be set to its default value. The hasISO639_LanguageCode()
     * method will return false.
     */
    inline void clearISO639_LanguageCode();

    /**
     * Checks whether the field "ISO639_LanguageCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setISO639_LanguageCode()). Otherwise it will return false.
     */
    inline bool hasISO639_LanguageCode () const;

    /**
     * Returns the value of the member "ISO639_LanguageCode".
     *
     * The ISO 639 two letter language code encoded as 16-Bit value.
     *
     * @return The value of the field "ISO639_LanguageCode"
     */
    inline T_e16_ISOLanguageCode getISO639_LanguageCode () const;

    /**
     * Sets the value of the member "ISO639_LanguageCode".
     *
     * The ISO 639 two letter language code encoded as 16-Bit value.
     *
     * @param ISO639_LanguageCode The value which will be set
     */
    inline void setISO639_LanguageCode (T_e16_ISOLanguageCode ISO639_LanguageCode_);

    // API of field "ISO3166_CountryCode"

    static const int kISO3166_CountryCode = 1;

    /**
     * Clears the field "ISO3166_CountryCode".
     *
     * The field will be set to its default value. The hasISO3166_CountryCode()
     * method will return false.
     */
    inline void clearISO3166_CountryCode();

    /**
     * Checks whether the field "ISO3166_CountryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setISO3166_CountryCode()). Otherwise it will return false.
     */
    inline bool hasISO3166_CountryCode () const;

    /**
     * Returns the value of the member "ISO3166_CountryCode".
     *
     * ISO 3166 country code (used only in case where country specific language variants are used, e.g. English US and EnglishGB). (0 = do not care)
     *
     * @return The value of the field "ISO3166_CountryCode"
     */
    inline T_e16_ISOCountryCode getISO3166_CountryCode () const;

    /**
     * Sets the value of the member "ISO3166_CountryCode".
     *
     * ISO 3166 country code (used only in case where country specific language variants are used, e.g. English US and EnglishGB). (0 = do not care)
     *
     * @param ISO3166_CountryCode The value which will be set
     */
    inline void setISO3166_CountryCode (T_e16_ISOCountryCode ISO3166_CountryCode_);

    static const T_LanguageID &getDefaultInstance();

private:

    inline void set_has_ISO639_LanguageCode ();

    inline void clear_has_ISO639_LanguageCode ();

    inline void set_has_ISO3166_CountryCode ();

    inline void clear_has_ISO3166_CountryCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e16_ISOLanguageCode _ISO639_LanguageCode;

    T_e16_ISOCountryCode _ISO3166_CountryCode;

};

/**
 * Grouping of basic types
 */
class T_DistTimeFuel {
public:

    /**
     * Default constructor
     */
    inline  T_DistTimeFuel ();

    /**
     * Copy constructor
     */
    inline  T_DistTimeFuel (const T_DistTimeFuel &rhs);

    /**
     * All fields constructor
     */
    inline  T_DistTimeFuel (T_s32_Meter Distance_, T_s32_Second Time_, T_s32_Microliter Fuel_);

    /**
     * Destructor
     */
    inline  ~T_DistTimeFuel();

    /**
     * Assignment operator
     */
    inline T_DistTimeFuel& operator = (const T_DistTimeFuel& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DistTimeFuel& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DistTimeFuel& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DistTimeFuel& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DistTimeFuel& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Distance"

    static const int kDistance = 0;

    /**
     * Clears the field "Distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "Distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "Distance".
     *
     * Distance in m.
     *
     * @return The value of the field "Distance"
     */
    inline T_s32_Meter getDistance () const;

    /**
     * Sets the value of the member "Distance".
     *
     * Distance in m.
     *
     * @param Distance The value which will be set
     */
    inline void setDistance (T_s32_Meter Distance_);

    // API of field "Time"

    static const int kTime = 1;

    /**
     * Clears the field "Time".
     *
     * The field will be set to its default value. The hasTime()
     * method will return false.
     */
    inline void clearTime();

    /**
     * Checks whether the field "Time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTime()). Otherwise it will return false.
     */
    inline bool hasTime () const;

    /**
     * Returns the value of the member "Time".
     *
     * Time in s.
     *
     * @return The value of the field "Time"
     */
    inline T_s32_Second getTime () const;

    /**
     * Sets the value of the member "Time".
     *
     * Time in s.
     *
     * @param Time The value which will be set
     */
    inline void setTime (T_s32_Second Time_);

    // API of field "Fuel"

    static const int kFuel = 2;

    /**
     * Clears the field "Fuel".
     *
     * The field will be set to its default value. The hasFuel()
     * method will return false.
     */
    inline void clearFuel();

    /**
     * Checks whether the field "Fuel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuel()). Otherwise it will return false.
     */
    inline bool hasFuel () const;

    /**
     * Returns the value of the member "Fuel".
     *
     * Fuel in microliter.
     *
     * @return The value of the field "Fuel"
     */
    inline T_s32_Microliter getFuel () const;

    /**
     * Sets the value of the member "Fuel".
     *
     * Fuel in microliter.
     *
     * @param Fuel The value which will be set
     */
    inline void setFuel (T_s32_Microliter Fuel_);

    static const T_DistTimeFuel &getDefaultInstance();

private:

    inline void set_has_Distance ();

    inline void clear_has_Distance ();

    inline void set_has_Time ();

    inline void clear_has_Time ();

    inline void set_has_Fuel ();

    inline void clear_has_Fuel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_s32_Meter _Distance;

    T_s32_Second _Time;

    T_s32_Microliter _Fuel;

};

inline  T_Reserved::T_Reserved () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Reserved::T_Reserved (const T_Reserved &rhs) {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Reserved::~T_Reserved() {
}

inline T_Reserved& T_Reserved::operator = (const T_Reserved& rhs) {
    if( this != &rhs ) {
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool T_Reserved::operator == (const T_Reserved& ) const {
    return true;
}

inline bool T_Reserved::operator != (const T_Reserved& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Reserved::operator < (const T_Reserved& ) const {
    return false;
}

inline bool T_Reserved::operator > (const T_Reserved& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Reserved::clear() {
}

inline  T_POSIXTime::T_POSIXTime ()  :
    _Time (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_POSIXTime::T_POSIXTime (const T_POSIXTime &rhs)  :
    _Time (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_POSIXTime::T_POSIXTime (int32 Time_)  :
    _Time (Time_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_POSIXTime::~T_POSIXTime() {
}

inline T_POSIXTime& T_POSIXTime::operator = (const T_POSIXTime& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTime()) {
            setTime(rhs.getTime());
        } else {
            clearTime();
        }
    }
    return *this;
}

inline bool T_POSIXTime::operator == (const T_POSIXTime& rhs) const {
    return (((!hasTime() && !rhs.hasTime()) || getTime() == rhs.getTime()));
}

inline bool T_POSIXTime::operator != (const T_POSIXTime& rhs) const {
    return ! (*this == rhs);
}

inline bool T_POSIXTime::operator < (const T_POSIXTime& rhs) const {
    if (hasTime() || rhs.hasTime()) {
        if (getTime() < rhs.getTime()) return true;
        if (getTime() > rhs.getTime()) return false;
    }
    return false;
}

inline bool T_POSIXTime::operator > (const T_POSIXTime& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_POSIXTime::clear() {
    clearTime();
}

inline void T_POSIXTime::clearTime() {
    if (hasTime()) {
         clear_has_Time();
        _Time = 0;
     }
}

inline bool T_POSIXTime::hasTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 T_POSIXTime::getTime () const {
    return _Time;
}

inline void T_POSIXTime::setTime (int32 Time_) {
    set_has_Time();
    this->_Time = Time_;
}

inline void T_POSIXTime::set_has_Time () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_POSIXTime::clear_has_Time () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_TimeZoneElement::T_TimeZoneElement ()  :
    _Abbreviation_StandardTime (),
    _Abbreviation_DST_in_effect (),
    _TimeZoneDifference (0),
    _DST_State (::fi_types::T_e8_DST_State__T_StandardTime),
    _DSTDifference (0),
    _DST_TimeDomain ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TimeZoneElement::T_TimeZoneElement (const T_TimeZoneElement &rhs)  :
    _Abbreviation_StandardTime (),
    _Abbreviation_DST_in_effect (),
    _TimeZoneDifference (0),
    _DST_State (::fi_types::T_e8_DST_State__T_StandardTime),
    _DSTDifference (0),
    _DST_TimeDomain ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TimeZoneElement::T_TimeZoneElement (const ::std::string& Abbreviation_StandardTime_, const ::std::string& Abbreviation_DST_in_effect_, T_s32_Second TimeZoneDifference_, T_e8_DST_State DST_State_, T_s32_Second DSTDifference_, const ::std::vector< uint8 >& DST_TimeDomain_)  :
    _Abbreviation_StandardTime (Abbreviation_StandardTime_),
    _Abbreviation_DST_in_effect (Abbreviation_DST_in_effect_),
    _TimeZoneDifference (TimeZoneDifference_),
    _DST_State (DST_State_),
    _DSTDifference (DSTDifference_),
    _DST_TimeDomain (DST_TimeDomain_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Abbreviation_StandardTime_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Abbreviation_DST_in_effect_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_DST_State_IsValid(DST_State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DST_State_, "T_e8_DST_State", "DST_State", "T_TimeZoneElement");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TimeZoneElement::~T_TimeZoneElement() {
}

inline T_TimeZoneElement& T_TimeZoneElement::operator = (const T_TimeZoneElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAbbreviation_StandardTime()) {
            setAbbreviation_StandardTime(rhs.getAbbreviation_StandardTime());
        } else {
            clearAbbreviation_StandardTime();
        }
        if (rhs.hasAbbreviation_DST_in_effect()) {
            setAbbreviation_DST_in_effect(rhs.getAbbreviation_DST_in_effect());
        } else {
            clearAbbreviation_DST_in_effect();
        }
        if (rhs.hasTimeZoneDifference()) {
            setTimeZoneDifference(rhs.getTimeZoneDifference());
        } else {
            clearTimeZoneDifference();
        }
        if (rhs.hasDST_State()) {
            setDST_State(rhs.getDST_State());
        } else {
            clearDST_State();
        }
        if (rhs.hasDSTDifference()) {
            setDSTDifference(rhs.getDSTDifference());
        } else {
            clearDSTDifference();
        }
        if (rhs.hasDST_TimeDomain()) {
            setDST_TimeDomain(rhs.getDST_TimeDomain());
        } else {
            clearDST_TimeDomain();
        }
    }
    return *this;
}

inline bool T_TimeZoneElement::operator == (const T_TimeZoneElement& rhs) const {
    return (((!hasAbbreviation_StandardTime() && !rhs.hasAbbreviation_StandardTime()) || getAbbreviation_StandardTime() == rhs.getAbbreviation_StandardTime()) &&
        ((!hasAbbreviation_DST_in_effect() && !rhs.hasAbbreviation_DST_in_effect()) || getAbbreviation_DST_in_effect() == rhs.getAbbreviation_DST_in_effect()) &&
        ((!hasTimeZoneDifference() && !rhs.hasTimeZoneDifference()) || getTimeZoneDifference() == rhs.getTimeZoneDifference()) &&
        ((!hasDST_State() && !rhs.hasDST_State()) || getDST_State() == rhs.getDST_State()) &&
        ((!hasDSTDifference() && !rhs.hasDSTDifference()) || getDSTDifference() == rhs.getDSTDifference()) &&
        ((!hasDST_TimeDomain() && !rhs.hasDST_TimeDomain()) || getDST_TimeDomain() == rhs.getDST_TimeDomain()));
}

inline bool T_TimeZoneElement::operator != (const T_TimeZoneElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TimeZoneElement::operator < (const T_TimeZoneElement& rhs) const {
    if (hasAbbreviation_StandardTime() || rhs.hasAbbreviation_StandardTime()) {
        if (getAbbreviation_StandardTime() < rhs.getAbbreviation_StandardTime()) return true;
        if (getAbbreviation_StandardTime() > rhs.getAbbreviation_StandardTime()) return false;
    }
    if (hasAbbreviation_DST_in_effect() || rhs.hasAbbreviation_DST_in_effect()) {
        if (getAbbreviation_DST_in_effect() < rhs.getAbbreviation_DST_in_effect()) return true;
        if (getAbbreviation_DST_in_effect() > rhs.getAbbreviation_DST_in_effect()) return false;
    }
    if (hasTimeZoneDifference() || rhs.hasTimeZoneDifference()) {
        if (getTimeZoneDifference() < rhs.getTimeZoneDifference()) return true;
        if (getTimeZoneDifference() > rhs.getTimeZoneDifference()) return false;
    }
    if (hasDST_State() || rhs.hasDST_State()) {
        if ((uint32)getDST_State() < (uint32)rhs.getDST_State()) return true;
        if ((uint32)getDST_State() > (uint32)rhs.getDST_State()) return false;
    }
    if (hasDSTDifference() || rhs.hasDSTDifference()) {
        if (getDSTDifference() < rhs.getDSTDifference()) return true;
        if (getDSTDifference() > rhs.getDSTDifference()) return false;
    }
    if (hasDST_TimeDomain() || rhs.hasDST_TimeDomain()) {
        if (getDST_TimeDomain() < rhs.getDST_TimeDomain()) return true;
        if (getDST_TimeDomain() > rhs.getDST_TimeDomain()) return false;
    }
    return false;
}

inline bool T_TimeZoneElement::operator > (const T_TimeZoneElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TimeZoneElement::clear() {
    clearAbbreviation_StandardTime();
    clearAbbreviation_DST_in_effect();
    clearTimeZoneDifference();
    clearDST_State();
    clearDSTDifference();
    clearDST_TimeDomain();
}

inline void T_TimeZoneElement::clearAbbreviation_StandardTime() {
    if (hasAbbreviation_StandardTime()) {
         clear_has_Abbreviation_StandardTime();
        _Abbreviation_StandardTime.clear();
     }
}

inline bool T_TimeZoneElement::hasAbbreviation_StandardTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_TimeZoneElement::getAbbreviation_StandardTime () const {
    return _Abbreviation_StandardTime;
}

inline ::std::string& T_TimeZoneElement::getAbbreviation_StandardTimeMutable () {
    set_has_Abbreviation_StandardTime();
    return _Abbreviation_StandardTime;
}

inline void T_TimeZoneElement::setAbbreviation_StandardTime (const ::std::string& Abbreviation_StandardTime_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Abbreviation_StandardTime_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Abbreviation_StandardTime();
    this->_Abbreviation_StandardTime = Abbreviation_StandardTime_;
}

inline void T_TimeZoneElement::setAbbreviation_StandardTime (const char* Abbreviation_StandardTime_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Abbreviation_StandardTime_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Abbreviation_StandardTime();
    this->_Abbreviation_StandardTime.assign(Abbreviation_StandardTime_);
}

inline void T_TimeZoneElement::setAbbreviation_StandardTime (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Abbreviation_StandardTime();
    this->_Abbreviation_StandardTime.assign(value, size);
}

inline void T_TimeZoneElement::clearAbbreviation_DST_in_effect() {
    if (hasAbbreviation_DST_in_effect()) {
         clear_has_Abbreviation_DST_in_effect();
        _Abbreviation_DST_in_effect.clear();
     }
}

inline bool T_TimeZoneElement::hasAbbreviation_DST_in_effect () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TimeZoneElement::getAbbreviation_DST_in_effect () const {
    return _Abbreviation_DST_in_effect;
}

inline ::std::string& T_TimeZoneElement::getAbbreviation_DST_in_effectMutable () {
    set_has_Abbreviation_DST_in_effect();
    return _Abbreviation_DST_in_effect;
}

inline void T_TimeZoneElement::setAbbreviation_DST_in_effect (const ::std::string& Abbreviation_DST_in_effect_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Abbreviation_DST_in_effect_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Abbreviation_DST_in_effect();
    this->_Abbreviation_DST_in_effect = Abbreviation_DST_in_effect_;
}

inline void T_TimeZoneElement::setAbbreviation_DST_in_effect (const char* Abbreviation_DST_in_effect_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Abbreviation_DST_in_effect_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Abbreviation_DST_in_effect();
    this->_Abbreviation_DST_in_effect.assign(Abbreviation_DST_in_effect_);
}

inline void T_TimeZoneElement::setAbbreviation_DST_in_effect (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Abbreviation_DST_in_effect();
    this->_Abbreviation_DST_in_effect.assign(value, size);
}

inline void T_TimeZoneElement::clearTimeZoneDifference() {
    if (hasTimeZoneDifference()) {
         clear_has_TimeZoneDifference();
        _TimeZoneDifference = 0;
     }
}

inline bool T_TimeZoneElement::hasTimeZoneDifference () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_s32_Second T_TimeZoneElement::getTimeZoneDifference () const {
    return _TimeZoneDifference;
}

inline void T_TimeZoneElement::setTimeZoneDifference (T_s32_Second TimeZoneDifference_) {
    set_has_TimeZoneDifference();
    this->_TimeZoneDifference = TimeZoneDifference_;
}

inline void T_TimeZoneElement::clearDST_State() {
    if (hasDST_State()) {
         clear_has_DST_State();
        _DST_State = ::fi_types::T_e8_DST_State__T_StandardTime;
     }
}

inline bool T_TimeZoneElement::hasDST_State () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_DST_State T_TimeZoneElement::getDST_State () const {
    return _DST_State;
}

inline void T_TimeZoneElement::setDST_State (T_e8_DST_State DST_State_) {
    #ifndef NDEBUG
    if (!(T_e8_DST_State_IsValid(DST_State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DST_State_, "T_e8_DST_State", "DST_State", "T_TimeZoneElement");
    }
    #endif
    set_has_DST_State();
    this->_DST_State = DST_State_;
}

inline void T_TimeZoneElement::clearDSTDifference() {
    if (hasDSTDifference()) {
         clear_has_DSTDifference();
        _DSTDifference = 0;
     }
}

inline bool T_TimeZoneElement::hasDSTDifference () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_s32_Second T_TimeZoneElement::getDSTDifference () const {
    return _DSTDifference;
}

inline void T_TimeZoneElement::setDSTDifference (T_s32_Second DSTDifference_) {
    set_has_DSTDifference();
    this->_DSTDifference = DSTDifference_;
}

inline void T_TimeZoneElement::clearDST_TimeDomain() {
    if (hasDST_TimeDomain()) {
         clear_has_DST_TimeDomain();
        _DST_TimeDomain.clear();
     }
}

inline bool T_TimeZoneElement::hasDST_TimeDomain () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::vector< uint8 >& T_TimeZoneElement::getDST_TimeDomain () const {
    return _DST_TimeDomain;
}

inline ::std::vector< uint8 >& T_TimeZoneElement::getDST_TimeDomainMutable () {
    set_has_DST_TimeDomain();
    return _DST_TimeDomain;
}

inline void T_TimeZoneElement::setDST_TimeDomain (const ::std::vector< uint8 >& DST_TimeDomain_) {
    set_has_DST_TimeDomain();
    this->_DST_TimeDomain = DST_TimeDomain_;
}

inline void T_TimeZoneElement::set_has_Abbreviation_StandardTime () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TimeZoneElement::clear_has_Abbreviation_StandardTime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TimeZoneElement::set_has_Abbreviation_DST_in_effect () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TimeZoneElement::clear_has_Abbreviation_DST_in_effect () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TimeZoneElement::set_has_TimeZoneDifference () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TimeZoneElement::clear_has_TimeZoneDifference () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TimeZoneElement::set_has_DST_State () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TimeZoneElement::clear_has_DST_State () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TimeZoneElement::set_has_DSTDifference () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TimeZoneElement::clear_has_DSTDifference () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TimeZoneElement::set_has_DST_TimeDomain () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TimeZoneElement::clear_has_DST_TimeDomain () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_FIVersion::T_FIVersion ()  :
    _MajorVersion (0u),
    _MinorVersion (0u),
    _PatchVersion (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FIVersion::T_FIVersion (const T_FIVersion &rhs)  :
    _MajorVersion (0u),
    _MinorVersion (0u),
    _PatchVersion (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FIVersion::T_FIVersion (uint8 MajorVersion_, uint8 MinorVersion_, uint8 PatchVersion_)  :
    _MajorVersion (MajorVersion_),
    _MinorVersion (MinorVersion_),
    _PatchVersion (PatchVersion_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FIVersion::~T_FIVersion() {
}

inline T_FIVersion& T_FIVersion::operator = (const T_FIVersion& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMajorVersion()) {
            setMajorVersion(rhs.getMajorVersion());
        } else {
            clearMajorVersion();
        }
        if (rhs.hasMinorVersion()) {
            setMinorVersion(rhs.getMinorVersion());
        } else {
            clearMinorVersion();
        }
        if (rhs.hasPatchVersion()) {
            setPatchVersion(rhs.getPatchVersion());
        } else {
            clearPatchVersion();
        }
    }
    return *this;
}

inline bool T_FIVersion::operator == (const T_FIVersion& rhs) const {
    return (((!hasMajorVersion() && !rhs.hasMajorVersion()) || getMajorVersion() == rhs.getMajorVersion()) &&
        ((!hasMinorVersion() && !rhs.hasMinorVersion()) || getMinorVersion() == rhs.getMinorVersion()) &&
        ((!hasPatchVersion() && !rhs.hasPatchVersion()) || getPatchVersion() == rhs.getPatchVersion()));
}

inline bool T_FIVersion::operator != (const T_FIVersion& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FIVersion::operator < (const T_FIVersion& rhs) const {
    if (hasMajorVersion() || rhs.hasMajorVersion()) {
        if (getMajorVersion() < rhs.getMajorVersion()) return true;
        if (getMajorVersion() > rhs.getMajorVersion()) return false;
    }
    if (hasMinorVersion() || rhs.hasMinorVersion()) {
        if (getMinorVersion() < rhs.getMinorVersion()) return true;
        if (getMinorVersion() > rhs.getMinorVersion()) return false;
    }
    if (hasPatchVersion() || rhs.hasPatchVersion()) {
        if (getPatchVersion() < rhs.getPatchVersion()) return true;
        if (getPatchVersion() > rhs.getPatchVersion()) return false;
    }
    return false;
}

inline bool T_FIVersion::operator > (const T_FIVersion& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FIVersion::clear() {
    clearMajorVersion();
    clearMinorVersion();
    clearPatchVersion();
}

inline void T_FIVersion::clearMajorVersion() {
    if (hasMajorVersion()) {
         clear_has_MajorVersion();
        _MajorVersion = 0u;
     }
}

inline bool T_FIVersion::hasMajorVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_FIVersion::getMajorVersion () const {
    return _MajorVersion;
}

inline void T_FIVersion::setMajorVersion (uint8 MajorVersion_) {
    set_has_MajorVersion();
    this->_MajorVersion = MajorVersion_;
}

inline void T_FIVersion::clearMinorVersion() {
    if (hasMinorVersion()) {
         clear_has_MinorVersion();
        _MinorVersion = 0u;
     }
}

inline bool T_FIVersion::hasMinorVersion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_FIVersion::getMinorVersion () const {
    return _MinorVersion;
}

inline void T_FIVersion::setMinorVersion (uint8 MinorVersion_) {
    set_has_MinorVersion();
    this->_MinorVersion = MinorVersion_;
}

inline void T_FIVersion::clearPatchVersion() {
    if (hasPatchVersion()) {
         clear_has_PatchVersion();
        _PatchVersion = 0u;
     }
}

inline bool T_FIVersion::hasPatchVersion () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_FIVersion::getPatchVersion () const {
    return _PatchVersion;
}

inline void T_FIVersion::setPatchVersion (uint8 PatchVersion_) {
    set_has_PatchVersion();
    this->_PatchVersion = PatchVersion_;
}

inline void T_FIVersion::set_has_MajorVersion () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FIVersion::clear_has_MajorVersion () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FIVersion::set_has_MinorVersion () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FIVersion::clear_has_MinorVersion () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_FIVersion::set_has_PatchVersion () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_FIVersion::clear_has_PatchVersion () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_PositionWGS84::T_PositionWGS84 ()  :
    _Longitude (0),
    _Latitude (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PositionWGS84::T_PositionWGS84 (const T_PositionWGS84 &rhs)  :
    _Longitude (0),
    _Latitude (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PositionWGS84::T_PositionWGS84 (T_s32_Longitude Longitude_, T_s32_Latitude Latitude_)  :
    _Longitude (Longitude_),
    _Latitude (Latitude_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(Latitude_ >= -1073741824, "Range check for int32 failed: %d", Latitude_);
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(Latitude_ <= 1073741823, "Range check for int32 failed: %d", Latitude_);
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PositionWGS84::~T_PositionWGS84() {
}

inline T_PositionWGS84& T_PositionWGS84::operator = (const T_PositionWGS84& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLongitude()) {
            setLongitude(rhs.getLongitude());
        } else {
            clearLongitude();
        }
        if (rhs.hasLatitude()) {
            setLatitude(rhs.getLatitude());
        } else {
            clearLatitude();
        }
    }
    return *this;
}

inline bool T_PositionWGS84::operator == (const T_PositionWGS84& rhs) const {
    return (((!hasLongitude() && !rhs.hasLongitude()) || getLongitude() == rhs.getLongitude()) &&
        ((!hasLatitude() && !rhs.hasLatitude()) || getLatitude() == rhs.getLatitude()));
}

inline bool T_PositionWGS84::operator != (const T_PositionWGS84& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PositionWGS84::operator < (const T_PositionWGS84& rhs) const {
    if (hasLongitude() || rhs.hasLongitude()) {
        if (getLongitude() < rhs.getLongitude()) return true;
        if (getLongitude() > rhs.getLongitude()) return false;
    }
    if (hasLatitude() || rhs.hasLatitude()) {
        if (getLatitude() < rhs.getLatitude()) return true;
        if (getLatitude() > rhs.getLatitude()) return false;
    }
    return false;
}

inline bool T_PositionWGS84::operator > (const T_PositionWGS84& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PositionWGS84::clear() {
    clearLongitude();
    clearLatitude();
}

inline void T_PositionWGS84::clearLongitude() {
    if (hasLongitude()) {
         clear_has_Longitude();
        _Longitude = 0;
     }
}

inline bool T_PositionWGS84::hasLongitude () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_s32_Longitude T_PositionWGS84::getLongitude () const {
    return _Longitude;
}

inline void T_PositionWGS84::setLongitude (T_s32_Longitude Longitude_) {
    set_has_Longitude();
    this->_Longitude = Longitude_;
}

inline void T_PositionWGS84::clearLatitude() {
    if (hasLatitude()) {
         clear_has_Latitude();
        _Latitude = 0;
     }
}

inline bool T_PositionWGS84::hasLatitude () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_s32_Latitude T_PositionWGS84::getLatitude () const {
    return _Latitude;
}

inline void T_PositionWGS84::setLatitude (T_s32_Latitude Latitude_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(Latitude_ >= -1073741824, "Range check for int32 failed: %d", Latitude_);
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(Latitude_ <= 1073741823, "Range check for int32 failed: %d", Latitude_);
    }
    set_has_Latitude();
    this->_Latitude = Latitude_;
}

inline void T_PositionWGS84::set_has_Longitude () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PositionWGS84::clear_has_Longitude () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PositionWGS84::set_has_Latitude () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PositionWGS84::clear_has_Latitude () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_RectangleWGS84::T_RectangleWGS84 ()  :
    _LongitudeMin (0),
    _LatitudeMin (0),
    _LongitudeMax (0),
    _LatitudeMax (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_RectangleWGS84::T_RectangleWGS84 (const T_RectangleWGS84 &rhs)  :
    _LongitudeMin (0),
    _LatitudeMin (0),
    _LongitudeMax (0),
    _LatitudeMax (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_RectangleWGS84::T_RectangleWGS84 (T_s32_Longitude LongitudeMin_, T_s32_Latitude LatitudeMin_, T_s32_Longitude LongitudeMax_, T_s32_Latitude LatitudeMax_)  :
    _LongitudeMin (LongitudeMin_),
    _LatitudeMin (LatitudeMin_),
    _LongitudeMax (LongitudeMax_),
    _LatitudeMax (LatitudeMax_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(LatitudeMin_ >= -1073741824, "Range check for int32 failed: %d", LatitudeMin_);
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(LatitudeMin_ <= 1073741823, "Range check for int32 failed: %d", LatitudeMin_);
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(LatitudeMax_ >= -1073741824, "Range check for int32 failed: %d", LatitudeMax_);
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(LatitudeMax_ <= 1073741823, "Range check for int32 failed: %d", LatitudeMax_);
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_RectangleWGS84::~T_RectangleWGS84() {
}

inline T_RectangleWGS84& T_RectangleWGS84::operator = (const T_RectangleWGS84& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLongitudeMin()) {
            setLongitudeMin(rhs.getLongitudeMin());
        } else {
            clearLongitudeMin();
        }
        if (rhs.hasLatitudeMin()) {
            setLatitudeMin(rhs.getLatitudeMin());
        } else {
            clearLatitudeMin();
        }
        if (rhs.hasLongitudeMax()) {
            setLongitudeMax(rhs.getLongitudeMax());
        } else {
            clearLongitudeMax();
        }
        if (rhs.hasLatitudeMax()) {
            setLatitudeMax(rhs.getLatitudeMax());
        } else {
            clearLatitudeMax();
        }
    }
    return *this;
}

inline bool T_RectangleWGS84::operator == (const T_RectangleWGS84& rhs) const {
    return (((!hasLongitudeMin() && !rhs.hasLongitudeMin()) || getLongitudeMin() == rhs.getLongitudeMin()) &&
        ((!hasLatitudeMin() && !rhs.hasLatitudeMin()) || getLatitudeMin() == rhs.getLatitudeMin()) &&
        ((!hasLongitudeMax() && !rhs.hasLongitudeMax()) || getLongitudeMax() == rhs.getLongitudeMax()) &&
        ((!hasLatitudeMax() && !rhs.hasLatitudeMax()) || getLatitudeMax() == rhs.getLatitudeMax()));
}

inline bool T_RectangleWGS84::operator != (const T_RectangleWGS84& rhs) const {
    return ! (*this == rhs);
}

inline bool T_RectangleWGS84::operator < (const T_RectangleWGS84& rhs) const {
    if (hasLongitudeMin() || rhs.hasLongitudeMin()) {
        if (getLongitudeMin() < rhs.getLongitudeMin()) return true;
        if (getLongitudeMin() > rhs.getLongitudeMin()) return false;
    }
    if (hasLatitudeMin() || rhs.hasLatitudeMin()) {
        if (getLatitudeMin() < rhs.getLatitudeMin()) return true;
        if (getLatitudeMin() > rhs.getLatitudeMin()) return false;
    }
    if (hasLongitudeMax() || rhs.hasLongitudeMax()) {
        if (getLongitudeMax() < rhs.getLongitudeMax()) return true;
        if (getLongitudeMax() > rhs.getLongitudeMax()) return false;
    }
    if (hasLatitudeMax() || rhs.hasLatitudeMax()) {
        if (getLatitudeMax() < rhs.getLatitudeMax()) return true;
        if (getLatitudeMax() > rhs.getLatitudeMax()) return false;
    }
    return false;
}

inline bool T_RectangleWGS84::operator > (const T_RectangleWGS84& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_RectangleWGS84::clear() {
    clearLongitudeMin();
    clearLatitudeMin();
    clearLongitudeMax();
    clearLatitudeMax();
}

inline void T_RectangleWGS84::clearLongitudeMin() {
    if (hasLongitudeMin()) {
         clear_has_LongitudeMin();
        _LongitudeMin = 0;
     }
}

inline bool T_RectangleWGS84::hasLongitudeMin () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_s32_Longitude T_RectangleWGS84::getLongitudeMin () const {
    return _LongitudeMin;
}

inline void T_RectangleWGS84::setLongitudeMin (T_s32_Longitude LongitudeMin_) {
    set_has_LongitudeMin();
    this->_LongitudeMin = LongitudeMin_;
}

inline void T_RectangleWGS84::clearLatitudeMin() {
    if (hasLatitudeMin()) {
         clear_has_LatitudeMin();
        _LatitudeMin = 0;
     }
}

inline bool T_RectangleWGS84::hasLatitudeMin () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_s32_Latitude T_RectangleWGS84::getLatitudeMin () const {
    return _LatitudeMin;
}

inline void T_RectangleWGS84::setLatitudeMin (T_s32_Latitude LatitudeMin_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(LatitudeMin_ >= -1073741824, "Range check for int32 failed: %d", LatitudeMin_);
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(LatitudeMin_ <= 1073741823, "Range check for int32 failed: %d", LatitudeMin_);
    }
    set_has_LatitudeMin();
    this->_LatitudeMin = LatitudeMin_;
}

inline void T_RectangleWGS84::clearLongitudeMax() {
    if (hasLongitudeMax()) {
         clear_has_LongitudeMax();
        _LongitudeMax = 0;
     }
}

inline bool T_RectangleWGS84::hasLongitudeMax () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_s32_Longitude T_RectangleWGS84::getLongitudeMax () const {
    return _LongitudeMax;
}

inline void T_RectangleWGS84::setLongitudeMax (T_s32_Longitude LongitudeMax_) {
    set_has_LongitudeMax();
    this->_LongitudeMax = LongitudeMax_;
}

inline void T_RectangleWGS84::clearLatitudeMax() {
    if (hasLatitudeMax()) {
         clear_has_LatitudeMax();
        _LatitudeMax = 0;
     }
}

inline bool T_RectangleWGS84::hasLatitudeMax () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_s32_Latitude T_RectangleWGS84::getLatitudeMax () const {
    return _LatitudeMax;
}

inline void T_RectangleWGS84::setLatitudeMax (T_s32_Latitude LatitudeMax_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(LatitudeMax_ >= -1073741824, "Range check for int32 failed: %d", LatitudeMax_);
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(LatitudeMax_ <= 1073741823, "Range check for int32 failed: %d", LatitudeMax_);
    }
    set_has_LatitudeMax();
    this->_LatitudeMax = LatitudeMax_;
}

inline void T_RectangleWGS84::set_has_LongitudeMin () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_RectangleWGS84::clear_has_LongitudeMin () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_RectangleWGS84::set_has_LatitudeMin () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_RectangleWGS84::clear_has_LatitudeMin () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_RectangleWGS84::set_has_LongitudeMax () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_RectangleWGS84::clear_has_LongitudeMax () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_RectangleWGS84::set_has_LatitudeMax () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_RectangleWGS84::clear_has_LatitudeMax () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_LanguageID::T_LanguageID ()  :
    _ISO639_LanguageCode (::fi_types::T_e16_ISOLanguageCode__ISO_639_1_undefined),
    _ISO3166_CountryCode (::fi_types::T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_LanguageID::T_LanguageID (const T_LanguageID &rhs)  :
    _ISO639_LanguageCode (::fi_types::T_e16_ISOLanguageCode__ISO_639_1_undefined),
    _ISO3166_CountryCode (::fi_types::T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_LanguageID::T_LanguageID (T_e16_ISOLanguageCode ISO639_LanguageCode_, T_e16_ISOCountryCode ISO3166_CountryCode_)  :
    _ISO639_LanguageCode (ISO639_LanguageCode_),
    _ISO3166_CountryCode (ISO3166_CountryCode_)
{
    #ifndef NDEBUG
    if (!(T_e16_ISOLanguageCode_IsValid(ISO639_LanguageCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ISO639_LanguageCode_, "T_e16_ISOLanguageCode", "ISO639_LanguageCode", "T_LanguageID");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e16_ISOCountryCode_IsValid(ISO3166_CountryCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ISO3166_CountryCode_, "T_e16_ISOCountryCode", "ISO3166_CountryCode", "T_LanguageID");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_LanguageID::~T_LanguageID() {
}

inline T_LanguageID& T_LanguageID::operator = (const T_LanguageID& rhs) {
    if( this != &rhs ) {
        if (rhs.hasISO639_LanguageCode()) {
            setISO639_LanguageCode(rhs.getISO639_LanguageCode());
        } else {
            clearISO639_LanguageCode();
        }
        if (rhs.hasISO3166_CountryCode()) {
            setISO3166_CountryCode(rhs.getISO3166_CountryCode());
        } else {
            clearISO3166_CountryCode();
        }
    }
    return *this;
}

inline bool T_LanguageID::operator == (const T_LanguageID& rhs) const {
    return (((!hasISO639_LanguageCode() && !rhs.hasISO639_LanguageCode()) || getISO639_LanguageCode() == rhs.getISO639_LanguageCode()) &&
        ((!hasISO3166_CountryCode() && !rhs.hasISO3166_CountryCode()) || getISO3166_CountryCode() == rhs.getISO3166_CountryCode()));
}

inline bool T_LanguageID::operator != (const T_LanguageID& rhs) const {
    return ! (*this == rhs);
}

inline bool T_LanguageID::operator < (const T_LanguageID& rhs) const {
    if (hasISO639_LanguageCode() || rhs.hasISO639_LanguageCode()) {
        if ((uint32)getISO639_LanguageCode() < (uint32)rhs.getISO639_LanguageCode()) return true;
        if ((uint32)getISO639_LanguageCode() > (uint32)rhs.getISO639_LanguageCode()) return false;
    }
    if (hasISO3166_CountryCode() || rhs.hasISO3166_CountryCode()) {
        if ((uint32)getISO3166_CountryCode() < (uint32)rhs.getISO3166_CountryCode()) return true;
        if ((uint32)getISO3166_CountryCode() > (uint32)rhs.getISO3166_CountryCode()) return false;
    }
    return false;
}

inline bool T_LanguageID::operator > (const T_LanguageID& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_LanguageID::clear() {
    clearISO639_LanguageCode();
    clearISO3166_CountryCode();
}

inline void T_LanguageID::clearISO639_LanguageCode() {
    if (hasISO639_LanguageCode()) {
         clear_has_ISO639_LanguageCode();
        _ISO639_LanguageCode = ::fi_types::T_e16_ISOLanguageCode__ISO_639_1_undefined;
     }
}

inline bool T_LanguageID::hasISO639_LanguageCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e16_ISOLanguageCode T_LanguageID::getISO639_LanguageCode () const {
    return _ISO639_LanguageCode;
}

inline void T_LanguageID::setISO639_LanguageCode (T_e16_ISOLanguageCode ISO639_LanguageCode_) {
    #ifndef NDEBUG
    if (!(T_e16_ISOLanguageCode_IsValid(ISO639_LanguageCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ISO639_LanguageCode_, "T_e16_ISOLanguageCode", "ISO639_LanguageCode", "T_LanguageID");
    }
    #endif
    set_has_ISO639_LanguageCode();
    this->_ISO639_LanguageCode = ISO639_LanguageCode_;
}

inline void T_LanguageID::clearISO3166_CountryCode() {
    if (hasISO3166_CountryCode()) {
         clear_has_ISO3166_CountryCode();
        _ISO3166_CountryCode = ::fi_types::T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED;
     }
}

inline bool T_LanguageID::hasISO3166_CountryCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e16_ISOCountryCode T_LanguageID::getISO3166_CountryCode () const {
    return _ISO3166_CountryCode;
}

inline void T_LanguageID::setISO3166_CountryCode (T_e16_ISOCountryCode ISO3166_CountryCode_) {
    #ifndef NDEBUG
    if (!(T_e16_ISOCountryCode_IsValid(ISO3166_CountryCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ISO3166_CountryCode_, "T_e16_ISOCountryCode", "ISO3166_CountryCode", "T_LanguageID");
    }
    #endif
    set_has_ISO3166_CountryCode();
    this->_ISO3166_CountryCode = ISO3166_CountryCode_;
}

inline void T_LanguageID::set_has_ISO639_LanguageCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_LanguageID::clear_has_ISO639_LanguageCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_LanguageID::set_has_ISO3166_CountryCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_LanguageID::clear_has_ISO3166_CountryCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_DistTimeFuel::T_DistTimeFuel ()  :
    _Distance (0),
    _Time (0),
    _Fuel (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DistTimeFuel::T_DistTimeFuel (const T_DistTimeFuel &rhs)  :
    _Distance (0),
    _Time (0),
    _Fuel (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DistTimeFuel::T_DistTimeFuel (T_s32_Meter Distance_, T_s32_Second Time_, T_s32_Microliter Fuel_)  :
    _Distance (Distance_),
    _Time (Time_),
    _Fuel (Fuel_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DistTimeFuel::~T_DistTimeFuel() {
}

inline T_DistTimeFuel& T_DistTimeFuel::operator = (const T_DistTimeFuel& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDistance()) {
            setDistance(rhs.getDistance());
        } else {
            clearDistance();
        }
        if (rhs.hasTime()) {
            setTime(rhs.getTime());
        } else {
            clearTime();
        }
        if (rhs.hasFuel()) {
            setFuel(rhs.getFuel());
        } else {
            clearFuel();
        }
    }
    return *this;
}

inline bool T_DistTimeFuel::operator == (const T_DistTimeFuel& rhs) const {
    return (((!hasDistance() && !rhs.hasDistance()) || getDistance() == rhs.getDistance()) &&
        ((!hasTime() && !rhs.hasTime()) || getTime() == rhs.getTime()) &&
        ((!hasFuel() && !rhs.hasFuel()) || getFuel() == rhs.getFuel()));
}

inline bool T_DistTimeFuel::operator != (const T_DistTimeFuel& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DistTimeFuel::operator < (const T_DistTimeFuel& rhs) const {
    if (hasDistance() || rhs.hasDistance()) {
        if (getDistance() < rhs.getDistance()) return true;
        if (getDistance() > rhs.getDistance()) return false;
    }
    if (hasTime() || rhs.hasTime()) {
        if (getTime() < rhs.getTime()) return true;
        if (getTime() > rhs.getTime()) return false;
    }
    if (hasFuel() || rhs.hasFuel()) {
        if (getFuel() < rhs.getFuel()) return true;
        if (getFuel() > rhs.getFuel()) return false;
    }
    return false;
}

inline bool T_DistTimeFuel::operator > (const T_DistTimeFuel& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DistTimeFuel::clear() {
    clearDistance();
    clearTime();
    clearFuel();
}

inline void T_DistTimeFuel::clearDistance() {
    if (hasDistance()) {
         clear_has_Distance();
        _Distance = 0;
     }
}

inline bool T_DistTimeFuel::hasDistance () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_s32_Meter T_DistTimeFuel::getDistance () const {
    return _Distance;
}

inline void T_DistTimeFuel::setDistance (T_s32_Meter Distance_) {
    set_has_Distance();
    this->_Distance = Distance_;
}

inline void T_DistTimeFuel::clearTime() {
    if (hasTime()) {
         clear_has_Time();
        _Time = 0;
     }
}

inline bool T_DistTimeFuel::hasTime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_s32_Second T_DistTimeFuel::getTime () const {
    return _Time;
}

inline void T_DistTimeFuel::setTime (T_s32_Second Time_) {
    set_has_Time();
    this->_Time = Time_;
}

inline void T_DistTimeFuel::clearFuel() {
    if (hasFuel()) {
         clear_has_Fuel();
        _Fuel = 0;
     }
}

inline bool T_DistTimeFuel::hasFuel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_s32_Microliter T_DistTimeFuel::getFuel () const {
    return _Fuel;
}

inline void T_DistTimeFuel::setFuel (T_s32_Microliter Fuel_) {
    set_has_Fuel();
    this->_Fuel = Fuel_;
}

inline void T_DistTimeFuel::set_has_Distance () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DistTimeFuel::clear_has_Distance () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DistTimeFuel::set_has_Time () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DistTimeFuel::clear_has_Time () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DistTimeFuel::set_has_Fuel () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DistTimeFuel::clear_has_Fuel () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace fi_types

#endif // FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
