#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_TABWEATHER_MAIN_FI_H
#define SXM_TABWEATHER_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include "sxm_tabweather_main_fi_types.h"
#include "sxm_tabweather_main_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'sxm_tabweather_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification
 *
 * Version: $Revision:   0.1  $
 *
 * Author: Rajaram Sarangapani
 *
 * Date: $Date:   June 21 2012  $
 *
 * Department: ECV3
 *
 * Title: sxm_tabweather_main_fi
 *
 * <b>Description of 'sxm_tabweather_main_fi':</b>
 *
 * RBEI/ECM
 */

namespace sxm_tabweather_main_fi {

static const int SERVICE_ID = 153;

static const int FID_GetTabWeatherInfoList = 1;

static const int FID_AddFavorite = 2;

static const int FID_RemoveFavorite = 3;

static const int FID_GetFavoriteInfo = 4;

static const int FID_SetListsConfig = 5;

static const int FID_TabWeatherInfoListStatus = 32;

static const int FID_SxmDataServiceStatus = 33;

static const int FID_SxmListMode = 34;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 2;

// forward declarations
class GetTabWeatherInfoListStart;

class GetTabWeatherInfoListResult;

class GetTabWeatherInfoListErrorStructure;

class GetTabWeatherInfoListError;

class AddFavoriteStart;

class AddFavoriteResult;

class AddFavoriteErrorStructure;

class AddFavoriteError;

class RemoveFavoriteStart;

class RemoveFavoriteResult;

class RemoveFavoriteErrorStructure;

class RemoveFavoriteError;

class GetFavoriteInfoStart;

class GetFavoriteInfoResult;

class GetFavoriteInfoErrorStructure;

class GetFavoriteInfoError;

class SetListsConfigStart;

class SetListsConfigResult;

class SetListsConfigErrorStructure;

class SetListsConfigError;

class TabWeatherInfoListStatusStatus;

class TabWeatherInfoListStatusErrorStructure;

class TabWeatherInfoListStatusError;

class SxmDataServiceStatusStatus;

class SxmListModeStatus;

class SxmListModeSet;

// type definitions
/**
 * The abort error message of the method "GetTabWeatherInfoList"
 * This method is used to get Tab Weather Information for required location.
 * Used for "Near Destination", "Nearby" and "Another City" usecases.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTabWeatherInfoListAbortError;

/**
 * The abort error message of the method "AddFavorite"
 * This method is used to get Tab Weather Information for required location
 * and to add it as a Favorite.
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFavoriteAbortError;

/**
 * The abort error message of the method "RemoveFavorite"
 * This method is to remove a favorite location by LOC_ID
 */
typedef ::asf::cca::CcaTypes::DefaultError RemoveFavoriteAbortError;

/**
 * The abort error message of the method "GetFavoriteInfo"
 * To get Tabular Weather information for the Favorite location
 */
typedef ::asf::cca::CcaTypes::DefaultError GetFavoriteInfoAbortError;

/**
 * The abort error message of the method "SetListsConfig"
 * This method is used to configure all lists
 */
typedef ::asf::cca::CcaTypes::DefaultError SetListsConfigAbortError;

/**
 * The get message of the property "TabWeatherInfoListStatus"
 * Tab Weather information result
 * Request Tab Weather information result
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TabWeatherInfoListStatusGet;

/**
 * The upreg message of the property "TabWeatherInfoListStatus"
 * Tab Weather information result
 * Register for Tab Weather Info. changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TabWeatherInfoListStatusUpReg;

/**
 * The relUpReg message of the property "TabWeatherInfoListStatus"
 * Tab Weather information result
 * Unregister for Tab Weather Info. changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TabWeatherInfoListStatusRelUpReg;

/**
 * The get message of the property "SxmDataServiceStatus"
 * Get the Status of TabWeather Data Service
 * Status of TabWeather Data Service
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusGet;

/**
 * The upreg message of the property "SxmDataServiceStatus"
 * Get the Status of TabWeather Data Service
 * Register for TabWeather Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusUpReg;

/**
 * The relUpReg message of the property "SxmDataServiceStatus"
 * Get the Status of TabWeather Data Service
 * Unregister for TabWeather Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusRelUpReg;

/**
 * The error message of 'SxmDataServiceStatus'
 * This error code specifies TabWeather Data Service Status is not available
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmDataServiceStatusError;

/**
 * The upreg message of the property "SxmListMode"
 * Set the Mode of TabWeather List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeUpReg;

/**
 * The relUpReg message of the property "SxmListMode"
 * Set the Mode of TabWeather List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeRelUpReg;

/**
 * The error message of 'SxmListMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmListModeError;


/**
 * The start message of the method "GetTabWeatherInfoList"
 * This method is used to get Tab Weather Information for required location.
 * Used for "Near Destination", "Nearby" and "Another City" usecases.
 */
class GetTabWeatherInfoListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTabWeatherInfoListStart ();

    /**
     * Copy constructor
     */
    inline  GetTabWeatherInfoListStart (const GetTabWeatherInfoListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetTabWeatherInfoListStart (uint32 ListId_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::sxm_main_fi_types::T_SxmLocation& Location_);

    /**
     * Destructor
     */
    inline virtual  ~GetTabWeatherInfoListStart();

    /**
     * Assignment operator
     */
    inline GetTabWeatherInfoListStart& operator = (const GetTabWeatherInfoListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTabWeatherInfoListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTabWeatherInfoListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTabWeatherInfoListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTabWeatherInfoListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListId"

    static const int kListId = 0;

    /**
     * Clears the field "ListId".
     *
     * The field will be set to its default value. The hasListId()
     * method will return false.
     */
    inline void clearListId();

    /**
     * Checks whether the field "ListId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListId()). Otherwise it will return false.
     */
    inline bool hasListId () const;

    /**
     * Returns the value of the member "ListId".
     *
     * List ID, value starts from 1. Refer types from T_e8_SxmListType, 4 - "Another City" usecase(LOCATION)
     *
     * @return The value of the field "ListId"
     */
    inline uint32 getListId () const;

    /**
     * Sets the value of the member "ListId".
     *
     * List ID, value starts from 1. Refer types from T_e8_SxmListType, 4 - "Another City" usecase(LOCATION)
     *
     * @param ListId The value which will be set
     */
    inline void setListId (uint32 ListId_);

    // API of field "Operation"

    static const int kOperation = 1;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * Operation to be performed
     *
     * @return The value of the field "Operation"
     */
    inline ::sxm_main_fi_types::T_e8_SxmListOperation getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * Operation to be performed
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_);

    // API of field "Location"

    static const int kLocation = 2;

    /**
     * Clears the field "Location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "Location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "Location".
     *
     * Lat, Lon and Radius are given. To be checked for "LOCATION" list type.
     * ["Another City" usecase].
     *
     * @return The value of the field "Location"
     */
    inline const ::sxm_main_fi_types::T_SxmLocation& getLocation () const;

    /**
     * Retrieves the value of the field "Location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Location".
     */
    inline ::sxm_main_fi_types::T_SxmLocation& getLocationMutable ();

    /**
     * Sets the value of the member "Location".
     *
     * Lat, Lon and Radius are given. To be checked for "LOCATION" list type.
     * ["Another City" usecase].
     *
     * @param Location The value which will be set
     */
    inline void setLocation (const ::sxm_main_fi_types::T_SxmLocation& Location_);

    static const GetTabWeatherInfoListStart &getDefaultInstance();

private:

    inline void set_has_ListId ();

    inline void clear_has_ListId ();

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    inline void set_has_Location ();

    inline void clear_has_Location ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _ListId;

    ::sxm_main_fi_types::T_e8_SxmListOperation _Operation;

    ::sxm_main_fi_types::T_SxmLocation _Location;

};

/**
 * The result message of the method "GetTabWeatherInfoList"
 * This method is used to get Tab Weather Information for required location.
 * Used for "Near Destination", "Nearby" and "Another City" usecases.
 * Result of the method. Provide Tab Weather information.
 */
class GetTabWeatherInfoListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTabWeatherInfoListResult ();

    /**
     * Copy constructor
     */
    inline  GetTabWeatherInfoListResult (const GetTabWeatherInfoListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetTabWeatherInfoListResult (uint32 ListId_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_, const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& TabWeatherInfo_);

    /**
     * Destructor
     */
    inline virtual  ~GetTabWeatherInfoListResult();

    /**
     * Assignment operator
     */
    inline GetTabWeatherInfoListResult& operator = (const GetTabWeatherInfoListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTabWeatherInfoListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTabWeatherInfoListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTabWeatherInfoListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTabWeatherInfoListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListId"

    static const int kListId = 0;

    /**
     * Clears the field "ListId".
     *
     * The field will be set to its default value. The hasListId()
     * method will return false.
     */
    inline void clearListId();

    /**
     * Checks whether the field "ListId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListId()). Otherwise it will return false.
     */
    inline bool hasListId () const;

    /**
     * Returns the value of the member "ListId".
     *
     * List ID, values 1-3 according to T_e8_SxmPredefinedListIds, 4 - "Another City" usecase
     *
     * @return The value of the field "ListId"
     */
    inline uint32 getListId () const;

    /**
     * Sets the value of the member "ListId".
     *
     * List ID, values 1-3 according to T_e8_SxmPredefinedListIds, 4 - "Another City" usecase
     *
     * @param ListId The value which will be set
     */
    inline void setListId (uint32 ListId_);

    // API of field "Operation"

    static const int kOperation = 1;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * Operation as in method-start
     *
     * @return The value of the field "Operation"
     */
    inline ::sxm_main_fi_types::T_e8_SxmListOperation getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * Operation as in method-start
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_);

    // API of field "ListInfo"

    static const int kListInfo = 2;

    /**
     * Clears the field "ListInfo".
     *
     * The field will be set to its default value. The hasListInfo()
     * method will return false.
     */
    inline void clearListInfo();

    /**
     * Checks whether the field "ListInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListInfo()). Otherwise it will return false.
     */
    inline bool hasListInfo () const;

    /**
     * Returns the value of the member "ListInfo".
     *
     * Information about the received list
     *
     * @return The value of the field "ListInfo"
     */
    inline const ::sxm_main_fi_types::T_SxmListInfo& getListInfo () const;

    /**
     * Retrieves the value of the field "ListInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListInfo".
     */
    inline ::sxm_main_fi_types::T_SxmListInfo& getListInfoMutable ();

    /**
     * Sets the value of the member "ListInfo".
     *
     * Information about the received list
     *
     * @param ListInfo The value which will be set
     */
    inline void setListInfo (const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_);

    // API of field "TabWeatherInfo"

    static const int kTabWeatherInfo = 3;

    /**
     * Clears the field "TabWeatherInfo".
     *
     * The field will be set to its default value. The hasTabWeatherInfo()
     * method will return false.
     */
    inline void clearTabWeatherInfo();

    /**
     * Checks whether the field "TabWeatherInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTabWeatherInfo()). Otherwise it will return false.
     */
    inline bool hasTabWeatherInfo () const;

    /**
     * Returns the value of the member "TabWeatherInfo".
     *
     * Tab Weather Information with parameters like Temperature, Precipitation amount,
     * Wind speed, Air quality and so on.
     *
     * @return The value of the field "TabWeatherInfo"
     */
    inline const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& getTabWeatherInfo () const;

    /**
     * Retrieves the value of the field "TabWeatherInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TabWeatherInfo".
     */
    inline ::sxm_tabweather_main_fi_types::T_WeatherInfoList& getTabWeatherInfoMutable ();

    /**
     * Sets the value of the member "TabWeatherInfo".
     *
     * Tab Weather Information with parameters like Temperature, Precipitation amount,
     * Wind speed, Air quality and so on.
     *
     * @param TabWeatherInfo The value which will be set
     */
    inline void setTabWeatherInfo (const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& TabWeatherInfo_);

    static const GetTabWeatherInfoListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_tabweather_main_fi_types::T_WeatherInfo >& getT_WeatherInfoList_DefaultInstance ();

    inline void set_has_ListId ();

    inline void clear_has_ListId ();

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    inline void set_has_ListInfo ();

    inline void clear_has_ListInfo ();

    inline void set_has_TabWeatherInfo ();

    inline void clear_has_TabWeatherInfo ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _ListId;

    ::sxm_main_fi_types::T_e8_SxmListOperation _Operation;

    ::sxm_main_fi_types::T_SxmListInfo _ListInfo;

    ::sxm_tabweather_main_fi_types::T_WeatherInfoList _TabWeatherInfo;

};

/**
 * The error message of 'GetTabWeatherInfoList'
 */
class GetTabWeatherInfoListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetTabWeatherInfoListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetTabWeatherInfoListErrorStructure (const GetTabWeatherInfoListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetTabWeatherInfoListErrorStructure (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetTabWeatherInfoListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetTabWeatherInfoListErrorStructure& operator = (const GetTabWeatherInfoListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTabWeatherInfoListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTabWeatherInfoListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTabWeatherInfoListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTabWeatherInfoListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_);

    static const GetTabWeatherInfoListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetTabWeatherInfoList'
 */
class GetTabWeatherInfoListError  : public ::asf::core::Payload {
public:

    enum GetTabWeatherInfoListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetTabWeatherInfoListError ();

   /**
     * Copy constructor
     */
    inline  GetTabWeatherInfoListError (const GetTabWeatherInfoListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetTabWeatherInfoListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetTabWeatherInfoListError& operator = (const GetTabWeatherInfoListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTabWeatherInfoListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTabWeatherInfoListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTabWeatherInfoListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTabWeatherInfoListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetTabWeatherInfoListError::GetTabWeatherInfoListErrorField getField () const;

    inline void setField(GetTabWeatherInfoListError::GetTabWeatherInfoListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetTabWeatherInfoListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetTabWeatherInfoListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetTabWeatherInfoListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetTabWeatherInfoListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetTabWeatherInfoListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetTabWeatherInfoListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetTabWeatherInfoListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetTabWeatherInfoListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetTabWeatherInfoListError &getDefaultInstance();

private:

    inline void cloneData (const GetTabWeatherInfoListError& rhs);

    inline void deleteData ();

    GetTabWeatherInfoListErrorField __field;

    union {
        GetTabWeatherInfoListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AddFavorite"
 * This method is used to get Tab Weather Information for required location
 * and to add it as a Favorite.
 */
class AddFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteStart (const AddFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteStart (const ::sxm_main_fi_types::T_SxmLocation& Location_);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteStart();

    /**
     * Assignment operator
     */
    inline AddFavoriteStart& operator = (const AddFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Location"

    static const int kLocation = 0;

    /**
     * Clears the field "Location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "Location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "Location".
     *
     * Lat, Lon and Radius are given
     *
     * @return The value of the field "Location"
     */
    inline const ::sxm_main_fi_types::T_SxmLocation& getLocation () const;

    /**
     * Retrieves the value of the field "Location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Location".
     */
    inline ::sxm_main_fi_types::T_SxmLocation& getLocationMutable ();

    /**
     * Sets the value of the member "Location".
     *
     * Lat, Lon and Radius are given
     *
     * @param Location The value which will be set
     */
    inline void setLocation (const ::sxm_main_fi_types::T_SxmLocation& Location_);

    static const AddFavoriteStart &getDefaultInstance();

private:

    inline void set_has_Location ();

    inline void clear_has_Location ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmLocation _Location;

};

/**
 * The result message of the method "AddFavorite"
 * This method is used to get Tab Weather Information for required location
 * and to add it as a Favorite.
 * Result of the method. Provide Tab Weather information.
 */
class AddFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteResult (const AddFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteResult (const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& TabWeatherInfo_, bool FavStatus_);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteResult();

    /**
     * Assignment operator
     */
    inline AddFavoriteResult& operator = (const AddFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TabWeatherInfo"

    static const int kTabWeatherInfo = 0;

    /**
     * Clears the field "TabWeatherInfo".
     *
     * The field will be set to its default value. The hasTabWeatherInfo()
     * method will return false.
     */
    inline void clearTabWeatherInfo();

    /**
     * Checks whether the field "TabWeatherInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTabWeatherInfo()). Otherwise it will return false.
     */
    inline bool hasTabWeatherInfo () const;

    /**
     * Returns the value of the member "TabWeatherInfo".
     *
     * Tab Weather Information with parameters like Temperature, Precipitation amount,
     * Wind speed, Air quality and so on.
     *
     * @return The value of the field "TabWeatherInfo"
     */
    inline const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& getTabWeatherInfo () const;

    /**
     * Retrieves the value of the field "TabWeatherInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TabWeatherInfo".
     */
    inline ::sxm_tabweather_main_fi_types::T_WeatherInfoList& getTabWeatherInfoMutable ();

    /**
     * Sets the value of the member "TabWeatherInfo".
     *
     * Tab Weather Information with parameters like Temperature, Precipitation amount,
     * Wind speed, Air quality and so on.
     *
     * @param TabWeatherInfo The value which will be set
     */
    inline void setTabWeatherInfo (const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& TabWeatherInfo_);

    // API of field "FavStatus"

    static const int kFavStatus = 1;

    /**
     * Clears the field "FavStatus".
     *
     * The field will be set to its default value. The hasFavStatus()
     * method will return false.
     */
    inline void clearFavStatus();

    /**
     * Checks whether the field "FavStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavStatus()). Otherwise it will return false.
     */
    inline bool hasFavStatus () const;

    /**
     * Returns the value of the member "FavStatus".
     *
     * Favorite status
     * TRUE  : Present in Fav. list
     * FALSE : Not present in Fav. list
     *
     * @return The value of the field "FavStatus"
     */
    inline bool getFavStatus () const;

    /**
     * Sets the value of the member "FavStatus".
     *
     * Favorite status
     * TRUE  : Present in Fav. list
     * FALSE : Not present in Fav. list
     *
     * @param FavStatus The value which will be set
     */
    inline void setFavStatus (bool FavStatus_);

    static const AddFavoriteResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_tabweather_main_fi_types::T_WeatherInfo >& getT_WeatherInfoList_DefaultInstance ();

    inline void set_has_TabWeatherInfo ();

    inline void clear_has_TabWeatherInfo ();

    inline void set_has_FavStatus ();

    inline void clear_has_FavStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_tabweather_main_fi_types::T_WeatherInfoList _TabWeatherInfo;

    bool _FavStatus;

};

/**
 * The error message of 'AddFavorite'
 */
class AddFavoriteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteErrorStructure (const AddFavoriteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteErrorStructure (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AddFavoriteErrorStructure();

    /**
     * Assignment operator
     */
    inline AddFavoriteErrorStructure& operator = (const AddFavoriteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_);

    static const AddFavoriteErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'AddFavorite'
 */
class AddFavoriteError  : public ::asf::core::Payload {
public:

    enum AddFavoriteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AddFavoriteError ();

   /**
     * Copy constructor
     */
    inline  AddFavoriteError (const AddFavoriteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteError();

    /**
     * Assigns a new value to this object.
     */
    inline AddFavoriteError& operator = (const AddFavoriteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AddFavoriteError::AddFavoriteErrorField getField () const;

    inline void setField(AddFavoriteError::AddFavoriteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AddFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AddFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AddFavoriteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AddFavoriteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AddFavoriteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AddFavoriteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AddFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AddFavoriteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AddFavoriteError &getDefaultInstance();

private:

    inline void cloneData (const AddFavoriteError& rhs);

    inline void deleteData ();

    AddFavoriteErrorField __field;

    union {
        AddFavoriteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RemoveFavorite"
 * This method is to remove a favorite location by LOC_ID
 */
class RemoveFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteStart (const RemoveFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteStart (uint32 TabWeather_LOCID_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteStart();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteStart& operator = (const RemoveFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TabWeather_LOCID"

    static const int kTabWeather_LOCID = 0;

    /**
     * Clears the field "TabWeather_LOCID".
     *
     * The field will be set to its default value. The hasTabWeather_LOCID()
     * method will return false.
     */
    inline void clearTabWeather_LOCID();

    /**
     * Checks whether the field "TabWeather_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTabWeather_LOCID()). Otherwise it will return false.
     */
    inline bool hasTabWeather_LOCID () const;

    /**
     * Returns the value of the member "TabWeather_LOCID".
     *
     * Weather Station Location ID
     *
     * @return The value of the field "TabWeather_LOCID"
     */
    inline uint32 getTabWeather_LOCID () const;

    /**
     * Sets the value of the member "TabWeather_LOCID".
     *
     * Weather Station Location ID
     *
     * @param TabWeather_LOCID The value which will be set
     */
    inline void setTabWeather_LOCID (uint32 TabWeather_LOCID_);

    static const RemoveFavoriteStart &getDefaultInstance();

private:

    inline void set_has_TabWeather_LOCID ();

    inline void clear_has_TabWeather_LOCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _TabWeather_LOCID;

};

/**
 * The result message of the method "RemoveFavorite"
 * This method is to remove a favorite location by LOC_ID
 * Result of the method. Status of Favorite
 */
class RemoveFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteResult (const RemoveFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteResult (bool FavStatus_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteResult();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteResult& operator = (const RemoveFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FavStatus"

    static const int kFavStatus = 0;

    /**
     * Clears the field "FavStatus".
     *
     * The field will be set to its default value. The hasFavStatus()
     * method will return false.
     */
    inline void clearFavStatus();

    /**
     * Checks whether the field "FavStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavStatus()). Otherwise it will return false.
     */
    inline bool hasFavStatus () const;

    /**
     * Returns the value of the member "FavStatus".
     *
     * Favorite status
     * TRUE  : Present in Fav. list
     * FALSE : Not present in Fav. list
     *
     * @return The value of the field "FavStatus"
     */
    inline bool getFavStatus () const;

    /**
     * Sets the value of the member "FavStatus".
     *
     * Favorite status
     * TRUE  : Present in Fav. list
     * FALSE : Not present in Fav. list
     *
     * @param FavStatus The value which will be set
     */
    inline void setFavStatus (bool FavStatus_);

    static const RemoveFavoriteResult &getDefaultInstance();

private:

    inline void set_has_FavStatus ();

    inline void clear_has_FavStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _FavStatus;

};

/**
 * The error message of 'RemoveFavorite'
 */
class RemoveFavoriteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteErrorStructure (const RemoveFavoriteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteErrorStructure (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~RemoveFavoriteErrorStructure();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteErrorStructure& operator = (const RemoveFavoriteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_);

    static const RemoveFavoriteErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'RemoveFavorite'
 */
class RemoveFavoriteError  : public ::asf::core::Payload {
public:

    enum RemoveFavoriteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RemoveFavoriteError ();

   /**
     * Copy constructor
     */
    inline  RemoveFavoriteError (const RemoveFavoriteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteError();

    /**
     * Assigns a new value to this object.
     */
    inline RemoveFavoriteError& operator = (const RemoveFavoriteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RemoveFavoriteError::RemoveFavoriteErrorField getField () const;

    inline void setField(RemoveFavoriteError::RemoveFavoriteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RemoveFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RemoveFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RemoveFavoriteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RemoveFavoriteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RemoveFavoriteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RemoveFavoriteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RemoveFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RemoveFavoriteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RemoveFavoriteError &getDefaultInstance();

private:

    inline void cloneData (const RemoveFavoriteError& rhs);

    inline void deleteData ();

    RemoveFavoriteErrorField __field;

    union {
        RemoveFavoriteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetFavoriteInfo"
 * To get Tabular Weather information for the Favorite location
 */
class GetFavoriteInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteInfoStart ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteInfoStart (const GetFavoriteInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteInfoStart (uint32 TabWeather_LOCID_);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteInfoStart();

    /**
     * Assignment operator
     */
    inline GetFavoriteInfoStart& operator = (const GetFavoriteInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TabWeather_LOCID"

    static const int kTabWeather_LOCID = 0;

    /**
     * Clears the field "TabWeather_LOCID".
     *
     * The field will be set to its default value. The hasTabWeather_LOCID()
     * method will return false.
     */
    inline void clearTabWeather_LOCID();

    /**
     * Checks whether the field "TabWeather_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTabWeather_LOCID()). Otherwise it will return false.
     */
    inline bool hasTabWeather_LOCID () const;

    /**
     * Returns the value of the member "TabWeather_LOCID".
     *
     * Weather Station Location ID
     *
     * @return The value of the field "TabWeather_LOCID"
     */
    inline uint32 getTabWeather_LOCID () const;

    /**
     * Sets the value of the member "TabWeather_LOCID".
     *
     * Weather Station Location ID
     *
     * @param TabWeather_LOCID The value which will be set
     */
    inline void setTabWeather_LOCID (uint32 TabWeather_LOCID_);

    static const GetFavoriteInfoStart &getDefaultInstance();

private:

    inline void set_has_TabWeather_LOCID ();

    inline void clear_has_TabWeather_LOCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _TabWeather_LOCID;

};

/**
 * The result message of the method "GetFavoriteInfo"
 * To get Tabular Weather information for the Favorite location
 * Result of the method. Provide Tab Weather information.
 */
class GetFavoriteInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteInfoResult (const GetFavoriteInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteInfoResult (const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& TabWeatherInfo_);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteInfoResult();

    /**
     * Assignment operator
     */
    inline GetFavoriteInfoResult& operator = (const GetFavoriteInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TabWeatherInfo"

    static const int kTabWeatherInfo = 0;

    /**
     * Clears the field "TabWeatherInfo".
     *
     * The field will be set to its default value. The hasTabWeatherInfo()
     * method will return false.
     */
    inline void clearTabWeatherInfo();

    /**
     * Checks whether the field "TabWeatherInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTabWeatherInfo()). Otherwise it will return false.
     */
    inline bool hasTabWeatherInfo () const;

    /**
     * Returns the value of the member "TabWeatherInfo".
     *
     * Tab Weather Information with parameters like Temperature, Precipitation amount,
     * Wind speed, Air quality and so on.
     *
     * @return The value of the field "TabWeatherInfo"
     */
    inline const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& getTabWeatherInfo () const;

    /**
     * Retrieves the value of the field "TabWeatherInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TabWeatherInfo".
     */
    inline ::sxm_tabweather_main_fi_types::T_WeatherInfoList& getTabWeatherInfoMutable ();

    /**
     * Sets the value of the member "TabWeatherInfo".
     *
     * Tab Weather Information with parameters like Temperature, Precipitation amount,
     * Wind speed, Air quality and so on.
     *
     * @param TabWeatherInfo The value which will be set
     */
    inline void setTabWeatherInfo (const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& TabWeatherInfo_);

    static const GetFavoriteInfoResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_tabweather_main_fi_types::T_WeatherInfo >& getT_WeatherInfoList_DefaultInstance ();

    inline void set_has_TabWeatherInfo ();

    inline void clear_has_TabWeatherInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_tabweather_main_fi_types::T_WeatherInfoList _TabWeatherInfo;

};

/**
 * The error message of 'GetFavoriteInfo'
 */
class GetFavoriteInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteInfoErrorStructure (const GetFavoriteInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteInfoErrorStructure (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetFavoriteInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetFavoriteInfoErrorStructure& operator = (const GetFavoriteInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_);

    static const GetFavoriteInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetFavoriteInfo'
 */
class GetFavoriteInfoError  : public ::asf::core::Payload {
public:

    enum GetFavoriteInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetFavoriteInfoError ();

   /**
     * Copy constructor
     */
    inline  GetFavoriteInfoError (const GetFavoriteInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetFavoriteInfoError& operator = (const GetFavoriteInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetFavoriteInfoError::GetFavoriteInfoErrorField getField () const;

    inline void setField(GetFavoriteInfoError::GetFavoriteInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetFavoriteInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetFavoriteInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetFavoriteInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetFavoriteInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetFavoriteInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetFavoriteInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetFavoriteInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetFavoriteInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetFavoriteInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetFavoriteInfoError& rhs);

    inline void deleteData ();

    GetFavoriteInfoErrorField __field;

    union {
        GetFavoriteInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetListsConfig"
 * This method is used to configure all lists
 */
class SetListsConfigStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigStart ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigStart (const SetListsConfigStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigStart (const ::sxm_main_fi_types::T_SxmListsConfig& Config_);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigStart();

    /**
     * Assignment operator
     */
    inline SetListsConfigStart& operator = (const SetListsConfigStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Config"

    static const int kConfig = 0;

    /**
     * Clears the field "Config".
     *
     * The field will be set to its default value. The hasConfig()
     * method will return false.
     */
    inline void clearConfig();

    /**
     * Checks whether the field "Config" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfig()). Otherwise it will return false.
     */
    inline bool hasConfig () const;

    /**
     * Returns the value of the member "Config".
     *
     * Currently in T_SxmListsConfig, Capacity is passed.
     * Capacity for Weather is "1". This Method is to provide a control over capacity.
     *
     * @return The value of the field "Config"
     */
    inline const ::sxm_main_fi_types::T_SxmListsConfig& getConfig () const;

    /**
     * Retrieves the value of the field "Config" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Config".
     */
    inline ::sxm_main_fi_types::T_SxmListsConfig& getConfigMutable ();

    /**
     * Sets the value of the member "Config".
     *
     * Currently in T_SxmListsConfig, Capacity is passed.
     * Capacity for Weather is "1". This Method is to provide a control over capacity.
     *
     * @param Config The value which will be set
     */
    inline void setConfig (const ::sxm_main_fi_types::T_SxmListsConfig& Config_);

    static const SetListsConfigStart &getDefaultInstance();

private:

    inline void set_has_Config ();

    inline void clear_has_Config ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListsConfig _Config;

};

/**
 * The result message of the method "SetListsConfig"
 * This method is used to configure all lists
 */
class SetListsConfigResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigResult ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigResult (const SetListsConfigResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigResult();

    /**
     * Assignment operator
     */
    inline SetListsConfigResult& operator = (const SetListsConfigResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if value was accepted
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if value was accepted
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetListsConfigResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SetListsConfig'
 */
class SetListsConfigErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigErrorStructure (const SetListsConfigErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigErrorStructure (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetListsConfigErrorStructure();

    /**
     * Assignment operator
     */
    inline SetListsConfigErrorStructure& operator = (const SetListsConfigErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_);

    static const SetListsConfigErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SetListsConfig'
 */
class SetListsConfigError  : public ::asf::core::Payload {
public:

    enum SetListsConfigErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetListsConfigError ();

   /**
     * Copy constructor
     */
    inline  SetListsConfigError (const SetListsConfigError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigError();

    /**
     * Assigns a new value to this object.
     */
    inline SetListsConfigError& operator = (const SetListsConfigError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetListsConfigError::SetListsConfigErrorField getField () const;

    inline void setField(SetListsConfigError::SetListsConfigErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetListsConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetListsConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetListsConfigErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetListsConfigErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetListsConfigErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetListsConfigErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetListsConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetListsConfigErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetListsConfigError &getDefaultInstance();

private:

    inline void cloneData (const SetListsConfigError& rhs);

    inline void deleteData ();

    SetListsConfigErrorField __field;

    union {
        SetListsConfigErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "TabWeatherInfoListStatus"
 * Tab Weather information result
 */
class TabWeatherInfoListStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TabWeatherInfoListStatusStatus ();

    /**
     * Copy constructor
     */
    inline  TabWeatherInfoListStatusStatus (const TabWeatherInfoListStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TabWeatherInfoListStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& TabweatherListStatus_);

    /**
     * Destructor
     */
    inline virtual  ~TabWeatherInfoListStatusStatus();

    /**
     * Assignment operator
     */
    inline TabWeatherInfoListStatusStatus& operator = (const TabWeatherInfoListStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TabWeatherInfoListStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TabWeatherInfoListStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TabWeatherInfoListStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TabWeatherInfoListStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TabweatherListStatus"

    static const int kTabweatherListStatus = 0;

    /**
     * Clears the field "TabweatherListStatus".
     *
     * The field will be set to its default value. The hasTabweatherListStatus()
     * method will return false.
     */
    inline void clearTabweatherListStatus();

    /**
     * Checks whether the field "TabweatherListStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTabweatherListStatus()). Otherwise it will return false.
     */
    inline bool hasTabweatherListStatus () const;

    /**
     * Returns the value of the member "TabweatherListStatus".
     *
     * Capacity of Lists, List ID, List type and List status
     *
     * @return The value of the field "TabweatherListStatus"
     */
    inline const ::sxm_main_fi_types::T_SxmListInfos& getTabweatherListStatus () const;

    /**
     * Retrieves the value of the field "TabweatherListStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TabweatherListStatus".
     */
    inline ::sxm_main_fi_types::T_SxmListInfos& getTabweatherListStatusMutable ();

    /**
     * Sets the value of the member "TabweatherListStatus".
     *
     * Capacity of Lists, List ID, List type and List status
     *
     * @param TabweatherListStatus The value which will be set
     */
    inline void setTabweatherListStatus (const ::sxm_main_fi_types::T_SxmListInfos& TabweatherListStatus_);

    static const TabWeatherInfoListStatusStatus &getDefaultInstance();

private:

    inline void set_has_TabweatherListStatus ();

    inline void clear_has_TabweatherListStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListInfos _TabweatherListStatus;

};

/**
 * The error message of 'TabWeatherInfoListStatus'
 */
class TabWeatherInfoListStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TabWeatherInfoListStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TabWeatherInfoListStatusErrorStructure (const TabWeatherInfoListStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TabWeatherInfoListStatusErrorStructure (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~TabWeatherInfoListStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline TabWeatherInfoListStatusErrorStructure& operator = (const TabWeatherInfoListStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TabWeatherInfoListStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TabWeatherInfoListStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TabWeatherInfoListStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TabWeatherInfoListStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_);

    static const TabWeatherInfoListStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'TabWeatherInfoListStatus'
 */
class TabWeatherInfoListStatusError  : public ::asf::core::Payload {
public:

    enum TabWeatherInfoListStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TabWeatherInfoListStatusError ();

   /**
     * Copy constructor
     */
    inline  TabWeatherInfoListStatusError (const TabWeatherInfoListStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TabWeatherInfoListStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline TabWeatherInfoListStatusError& operator = (const TabWeatherInfoListStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TabWeatherInfoListStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TabWeatherInfoListStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TabWeatherInfoListStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TabWeatherInfoListStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TabWeatherInfoListStatusError::TabWeatherInfoListStatusErrorField getField () const;

    inline void setField(TabWeatherInfoListStatusError::TabWeatherInfoListStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TabWeatherInfoListStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TabWeatherInfoListStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TabWeatherInfoListStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TabWeatherInfoListStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TabWeatherInfoListStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TabWeatherInfoListStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TabWeatherInfoListStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TabWeatherInfoListStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TabWeatherInfoListStatusError &getDefaultInstance();

private:

    inline void cloneData (const TabWeatherInfoListStatusError& rhs);

    inline void deleteData ();

    TabWeatherInfoListStatusErrorField __field;

    union {
        TabWeatherInfoListStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SxmDataServiceStatus"
 * Get the Status of TabWeather Data Service
 */
class SxmDataServiceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmDataServiceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    /**
     * Destructor
     */
    inline virtual  ~SxmDataServiceStatusStatus();

    /**
     * Assignment operator
     */
    inline SxmDataServiceStatusStatus& operator = (const SxmDataServiceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataServiceState"

    static const int kDataServiceState = 0;

    /**
     * Clears the field "DataServiceState".
     *
     * The field will be set to its default value. The hasDataServiceState()
     * method will return false.
     */
    inline void clearDataServiceState();

    /**
     * Checks whether the field "DataServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataServiceState()). Otherwise it will return false.
     */
    inline bool hasDataServiceState () const;

    /**
     * Returns the value of the member "DataServiceState".
     *
     * Status of TabWeather Data Service
     *
     * @return The value of the field "DataServiceState"
     */
    inline const ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceState () const;

    /**
     * Retrieves the value of the field "DataServiceState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DataServiceState".
     */
    inline ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceStateMutable ();

    /**
     * Sets the value of the member "DataServiceState".
     *
     * Status of TabWeather Data Service
     *
     * @param DataServiceState The value which will be set
     */
    inline void setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    static const SxmDataServiceStatusStatus &getDefaultInstance();

private:

    inline void set_has_DataServiceState ();

    inline void clear_has_DataServiceState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmDataSrvState _DataServiceState;

};

/**
 * The status message of the property "SxmListMode"
 * Set the Mode of TabWeather List.
 */
class SxmListModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeStatus ();

    /**
     * Copy constructor
     */
    inline  SxmListModeStatus (const SxmListModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeStatus();

    /**
     * Assignment operator
     */
    inline SxmListModeStatus& operator = (const SxmListModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of TabWeather List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of TabWeather List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    static const SxmListModeStatus &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

};

/**
 * The set message of the property "SxmListMode"
 * Set the Mode of TabWeather List.
 */
class SxmListModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeSet ();

    /**
     * Copy constructor
     */
    inline  SxmListModeSet (const SxmListModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeSet();

    /**
     * Assignment operator
     */
    inline SxmListModeSet& operator = (const SxmListModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of TabWeather List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of TabWeather List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    static const SxmListModeSet &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

};

inline  GetTabWeatherInfoListStart::GetTabWeatherInfoListStart ()  :
    _ListId (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _Location ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTabWeatherInfoListStart::GetTabWeatherInfoListStart (const GetTabWeatherInfoListStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ListId (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _Location ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTabWeatherInfoListStart::GetTabWeatherInfoListStart (uint32 ListId_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::sxm_main_fi_types::T_SxmLocation& Location_)  :
    _ListId (ListId_),
    _Operation (Operation_),
    _Location (Location_)
{
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetTabWeatherInfoListStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTabWeatherInfoListStart::~GetTabWeatherInfoListStart() {
}

inline GetTabWeatherInfoListStart& GetTabWeatherInfoListStart::operator = (const GetTabWeatherInfoListStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListId()) {
            setListId(rhs.getListId());
        } else {
            clearListId();
        }
        if (rhs.hasOperation()) {
            setOperation(rhs.getOperation());
        } else {
            clearOperation();
        }
        if (rhs.hasLocation()) {
            setLocation(rhs.getLocation());
        } else {
            clearLocation();
        }
    }
    return *this;
}

inline bool GetTabWeatherInfoListStart::operator == (const GetTabWeatherInfoListStart& rhs) const {
    return (((!hasListId() && !rhs.hasListId()) || getListId() == rhs.getListId()) &&
        ((!hasOperation() && !rhs.hasOperation()) || getOperation() == rhs.getOperation()) &&
        ((!hasLocation() && !rhs.hasLocation()) || getLocation() == rhs.getLocation()));
}

inline bool GetTabWeatherInfoListStart::operator != (const GetTabWeatherInfoListStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTabWeatherInfoListStart::operator < (const GetTabWeatherInfoListStart& rhs) const {
    if (hasListId() || rhs.hasListId()) {
        if (getListId() < rhs.getListId()) return true;
        if (getListId() > rhs.getListId()) return false;
    }
    if (hasOperation() || rhs.hasOperation()) {
        if ((uint32)getOperation() < (uint32)rhs.getOperation()) return true;
        if ((uint32)getOperation() > (uint32)rhs.getOperation()) return false;
    }
    if (hasLocation() || rhs.hasLocation()) {
        if (getLocation() < rhs.getLocation()) return true;
        if (getLocation() > rhs.getLocation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTabWeatherInfoListStart::clone() {
    return new GetTabWeatherInfoListStart(*this);
}

inline bool GetTabWeatherInfoListStart::operator > (const GetTabWeatherInfoListStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTabWeatherInfoListStart::clear() {
    clearListId();
    clearOperation();
    clearLocation();
}

inline void GetTabWeatherInfoListStart::clearListId() {
    if (hasListId()) {
         clear_has_ListId();
        _ListId = 0u;
     }
}

inline bool GetTabWeatherInfoListStart::hasListId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetTabWeatherInfoListStart::getListId () const {
    return _ListId;
}

inline void GetTabWeatherInfoListStart::setListId (uint32 ListId_) {
    set_has_ListId();
    this->_ListId = ListId_;
}

inline void GetTabWeatherInfoListStart::clearOperation() {
    if (hasOperation()) {
         clear_has_Operation();
        _Operation = ::sxm_main_fi_types::T_e8_SxmListOperation__IDLE;
     }
}

inline bool GetTabWeatherInfoListStart::hasOperation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_main_fi_types::T_e8_SxmListOperation GetTabWeatherInfoListStart::getOperation () const {
    return _Operation;
}

inline void GetTabWeatherInfoListStart::setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_) {
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetTabWeatherInfoListStart");
    }
    #endif
    set_has_Operation();
    this->_Operation = Operation_;
}

inline void GetTabWeatherInfoListStart::clearLocation() {
    if (hasLocation()) {
         clear_has_Location();
        _Location.clear();
     }
}

inline bool GetTabWeatherInfoListStart::hasLocation () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmLocation& GetTabWeatherInfoListStart::getLocation () const {
    return _Location;
}

inline ::sxm_main_fi_types::T_SxmLocation& GetTabWeatherInfoListStart::getLocationMutable () {
    set_has_Location();
    return _Location;
}

inline void GetTabWeatherInfoListStart::setLocation (const ::sxm_main_fi_types::T_SxmLocation& Location_) {
    set_has_Location();
    this->_Location = Location_;
}

inline void GetTabWeatherInfoListStart::set_has_ListId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTabWeatherInfoListStart::clear_has_ListId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetTabWeatherInfoListStart::set_has_Operation () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetTabWeatherInfoListStart::clear_has_Operation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetTabWeatherInfoListStart::set_has_Location () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetTabWeatherInfoListStart::clear_has_Location () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetTabWeatherInfoListResult::GetTabWeatherInfoListResult ()  :
    _ListId (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _ListInfo (),
    _TabWeatherInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTabWeatherInfoListResult::GetTabWeatherInfoListResult (const GetTabWeatherInfoListResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ListId (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _ListInfo (),
    _TabWeatherInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTabWeatherInfoListResult::GetTabWeatherInfoListResult (uint32 ListId_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_, const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& TabWeatherInfo_)  :
    _ListId (ListId_),
    _Operation (Operation_),
    _ListInfo (ListInfo_),
    _TabWeatherInfo (TabWeatherInfo_)
{
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetTabWeatherInfoListResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTabWeatherInfoListResult::~GetTabWeatherInfoListResult() {
}

inline GetTabWeatherInfoListResult& GetTabWeatherInfoListResult::operator = (const GetTabWeatherInfoListResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListId()) {
            setListId(rhs.getListId());
        } else {
            clearListId();
        }
        if (rhs.hasOperation()) {
            setOperation(rhs.getOperation());
        } else {
            clearOperation();
        }
        if (rhs.hasListInfo()) {
            setListInfo(rhs.getListInfo());
        } else {
            clearListInfo();
        }
        if (rhs.hasTabWeatherInfo()) {
            setTabWeatherInfo(rhs.getTabWeatherInfo());
        } else {
            clearTabWeatherInfo();
        }
    }
    return *this;
}

inline bool GetTabWeatherInfoListResult::operator == (const GetTabWeatherInfoListResult& rhs) const {
    return (((!hasListId() && !rhs.hasListId()) || getListId() == rhs.getListId()) &&
        ((!hasOperation() && !rhs.hasOperation()) || getOperation() == rhs.getOperation()) &&
        ((!hasListInfo() && !rhs.hasListInfo()) || getListInfo() == rhs.getListInfo()) &&
        ((!hasTabWeatherInfo() && !rhs.hasTabWeatherInfo()) || getTabWeatherInfo() == rhs.getTabWeatherInfo()));
}

inline bool GetTabWeatherInfoListResult::operator != (const GetTabWeatherInfoListResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTabWeatherInfoListResult::operator < (const GetTabWeatherInfoListResult& rhs) const {
    if (hasListId() || rhs.hasListId()) {
        if (getListId() < rhs.getListId()) return true;
        if (getListId() > rhs.getListId()) return false;
    }
    if (hasOperation() || rhs.hasOperation()) {
        if ((uint32)getOperation() < (uint32)rhs.getOperation()) return true;
        if ((uint32)getOperation() > (uint32)rhs.getOperation()) return false;
    }
    if (hasListInfo() || rhs.hasListInfo()) {
        if (getListInfo() < rhs.getListInfo()) return true;
        if (getListInfo() > rhs.getListInfo()) return false;
    }
    if (hasTabWeatherInfo() || rhs.hasTabWeatherInfo()) {
        if (getTabWeatherInfo() < rhs.getTabWeatherInfo()) return true;
        if (getTabWeatherInfo() > rhs.getTabWeatherInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTabWeatherInfoListResult::clone() {
    return new GetTabWeatherInfoListResult(*this);
}

inline bool GetTabWeatherInfoListResult::operator > (const GetTabWeatherInfoListResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTabWeatherInfoListResult::clear() {
    clearListId();
    clearOperation();
    clearListInfo();
    clearTabWeatherInfo();
}

inline void GetTabWeatherInfoListResult::clearListId() {
    if (hasListId()) {
         clear_has_ListId();
        _ListId = 0u;
     }
}

inline bool GetTabWeatherInfoListResult::hasListId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetTabWeatherInfoListResult::getListId () const {
    return _ListId;
}

inline void GetTabWeatherInfoListResult::setListId (uint32 ListId_) {
    set_has_ListId();
    this->_ListId = ListId_;
}

inline void GetTabWeatherInfoListResult::clearOperation() {
    if (hasOperation()) {
         clear_has_Operation();
        _Operation = ::sxm_main_fi_types::T_e8_SxmListOperation__IDLE;
     }
}

inline bool GetTabWeatherInfoListResult::hasOperation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_main_fi_types::T_e8_SxmListOperation GetTabWeatherInfoListResult::getOperation () const {
    return _Operation;
}

inline void GetTabWeatherInfoListResult::setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_) {
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetTabWeatherInfoListResult");
    }
    #endif
    set_has_Operation();
    this->_Operation = Operation_;
}

inline void GetTabWeatherInfoListResult::clearListInfo() {
    if (hasListInfo()) {
         clear_has_ListInfo();
        _ListInfo.clear();
     }
}

inline bool GetTabWeatherInfoListResult::hasListInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListInfo& GetTabWeatherInfoListResult::getListInfo () const {
    return _ListInfo;
}

inline ::sxm_main_fi_types::T_SxmListInfo& GetTabWeatherInfoListResult::getListInfoMutable () {
    set_has_ListInfo();
    return _ListInfo;
}

inline void GetTabWeatherInfoListResult::setListInfo (const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_) {
    set_has_ListInfo();
    this->_ListInfo = ListInfo_;
}

inline void GetTabWeatherInfoListResult::clearTabWeatherInfo() {
    if (hasTabWeatherInfo()) {
         clear_has_TabWeatherInfo();
        _TabWeatherInfo.clear();
     }
}

inline bool GetTabWeatherInfoListResult::hasTabWeatherInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& GetTabWeatherInfoListResult::getTabWeatherInfo () const {
    return _TabWeatherInfo;
}

inline ::sxm_tabweather_main_fi_types::T_WeatherInfoList& GetTabWeatherInfoListResult::getTabWeatherInfoMutable () {
    set_has_TabWeatherInfo();
    return _TabWeatherInfo;
}

inline void GetTabWeatherInfoListResult::setTabWeatherInfo (const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& TabWeatherInfo_) {
    set_has_TabWeatherInfo();
    this->_TabWeatherInfo = TabWeatherInfo_;
}

inline void GetTabWeatherInfoListResult::set_has_ListId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTabWeatherInfoListResult::clear_has_ListId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetTabWeatherInfoListResult::set_has_Operation () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetTabWeatherInfoListResult::clear_has_Operation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetTabWeatherInfoListResult::set_has_ListInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetTabWeatherInfoListResult::clear_has_ListInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetTabWeatherInfoListResult::set_has_TabWeatherInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetTabWeatherInfoListResult::clear_has_TabWeatherInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetTabWeatherInfoListErrorStructure::GetTabWeatherInfoListErrorStructure ()  :
    _ErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTabWeatherInfoListErrorStructure::GetTabWeatherInfoListErrorStructure (const GetTabWeatherInfoListErrorStructure &rhs)  :
    _ErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTabWeatherInfoListErrorStructure::GetTabWeatherInfoListErrorStructure (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_TabWeather_ErrorTypes", "ErrorCode", "GetTabWeatherInfoListErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTabWeatherInfoListErrorStructure::~GetTabWeatherInfoListErrorStructure() {
}

inline GetTabWeatherInfoListErrorStructure& GetTabWeatherInfoListErrorStructure::operator = (const GetTabWeatherInfoListErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetTabWeatherInfoListErrorStructure::operator == (const GetTabWeatherInfoListErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetTabWeatherInfoListErrorStructure::operator != (const GetTabWeatherInfoListErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTabWeatherInfoListErrorStructure::operator < (const GetTabWeatherInfoListErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetTabWeatherInfoListErrorStructure::operator > (const GetTabWeatherInfoListErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTabWeatherInfoListErrorStructure::clear() {
    clearErrorCode();
}

inline void GetTabWeatherInfoListErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID;
     }
}

inline bool GetTabWeatherInfoListErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes GetTabWeatherInfoListErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetTabWeatherInfoListErrorStructure::setErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_TabWeather_ErrorTypes", "ErrorCode", "GetTabWeatherInfoListErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetTabWeatherInfoListErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTabWeatherInfoListErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetTabWeatherInfoListError::GetTabWeatherInfoListError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetTabWeatherInfoListError::GetTabWeatherInfoListError (const GetTabWeatherInfoListError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetTabWeatherInfoListError::~GetTabWeatherInfoListError() {
    deleteData ();
}

inline GetTabWeatherInfoListError& GetTabWeatherInfoListError::operator = (const GetTabWeatherInfoListError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetTabWeatherInfoListError::operator == (const GetTabWeatherInfoListError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetTabWeatherInfoListError::operator != (const GetTabWeatherInfoListError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTabWeatherInfoListError::operator < (const GetTabWeatherInfoListError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetTabWeatherInfoListError::operator > (const GetTabWeatherInfoListError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetTabWeatherInfoListError::GetTabWeatherInfoListErrorField GetTabWeatherInfoListError::getField () const {
    return __field;
}

inline void GetTabWeatherInfoListError::setField(GetTabWeatherInfoListError::GetTabWeatherInfoListErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetTabWeatherInfoListError::clone() {
    return new GetTabWeatherInfoListError(*this);
}

inline bool GetTabWeatherInfoListError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetTabWeatherInfoListErrorStructure& GetTabWeatherInfoListError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetTabWeatherInfoListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetTabWeatherInfoListErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetTabWeatherInfoListErrorStructure& GetTabWeatherInfoListError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetTabWeatherInfoListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetTabWeatherInfoListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetTabWeatherInfoListErrorStructure* GetTabWeatherInfoListError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetTabWeatherInfoListError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetTabWeatherInfoListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetTabWeatherInfoListErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetTabWeatherInfoListError::replaceCcaErrorCode (GetTabWeatherInfoListErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetTabWeatherInfoListError::setCcaErrorCode (const GetTabWeatherInfoListErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetTabWeatherInfoListErrorStructure(value);
    }
}

inline bool GetTabWeatherInfoListError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetTabWeatherInfoListError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetTabWeatherInfoListError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetTabWeatherInfoListError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetTabWeatherInfoListError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetTabWeatherInfoListError::cloneData (const GetTabWeatherInfoListError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetTabWeatherInfoListErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetTabWeatherInfoListErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetTabWeatherInfoListError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  AddFavoriteStart::AddFavoriteStart ()  :
    _Location ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteStart::AddFavoriteStart (const AddFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Location ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteStart::AddFavoriteStart (const ::sxm_main_fi_types::T_SxmLocation& Location_)  :
    _Location (Location_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteStart::~AddFavoriteStart() {
}

inline AddFavoriteStart& AddFavoriteStart::operator = (const AddFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLocation()) {
            setLocation(rhs.getLocation());
        } else {
            clearLocation();
        }
    }
    return *this;
}

inline bool AddFavoriteStart::operator == (const AddFavoriteStart& rhs) const {
    return (((!hasLocation() && !rhs.hasLocation()) || getLocation() == rhs.getLocation()));
}

inline bool AddFavoriteStart::operator != (const AddFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteStart::operator < (const AddFavoriteStart& rhs) const {
    if (hasLocation() || rhs.hasLocation()) {
        if (getLocation() < rhs.getLocation()) return true;
        if (getLocation() > rhs.getLocation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddFavoriteStart::clone() {
    return new AddFavoriteStart(*this);
}

inline bool AddFavoriteStart::operator > (const AddFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteStart::clear() {
    clearLocation();
}

inline void AddFavoriteStart::clearLocation() {
    if (hasLocation()) {
         clear_has_Location();
        _Location.clear();
     }
}

inline bool AddFavoriteStart::hasLocation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmLocation& AddFavoriteStart::getLocation () const {
    return _Location;
}

inline ::sxm_main_fi_types::T_SxmLocation& AddFavoriteStart::getLocationMutable () {
    set_has_Location();
    return _Location;
}

inline void AddFavoriteStart::setLocation (const ::sxm_main_fi_types::T_SxmLocation& Location_) {
    set_has_Location();
    this->_Location = Location_;
}

inline void AddFavoriteStart::set_has_Location () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteStart::clear_has_Location () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddFavoriteResult::AddFavoriteResult ()  :
    _TabWeatherInfo (),
    _FavStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteResult::AddFavoriteResult (const AddFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TabWeatherInfo (),
    _FavStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteResult::AddFavoriteResult (const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& TabWeatherInfo_, bool FavStatus_)  :
    _TabWeatherInfo (TabWeatherInfo_),
    _FavStatus (FavStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteResult::~AddFavoriteResult() {
}

inline AddFavoriteResult& AddFavoriteResult::operator = (const AddFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTabWeatherInfo()) {
            setTabWeatherInfo(rhs.getTabWeatherInfo());
        } else {
            clearTabWeatherInfo();
        }
        if (rhs.hasFavStatus()) {
            setFavStatus(rhs.getFavStatus());
        } else {
            clearFavStatus();
        }
    }
    return *this;
}

inline bool AddFavoriteResult::operator == (const AddFavoriteResult& rhs) const {
    return (((!hasTabWeatherInfo() && !rhs.hasTabWeatherInfo()) || getTabWeatherInfo() == rhs.getTabWeatherInfo()) &&
        ((!hasFavStatus() && !rhs.hasFavStatus()) || getFavStatus() == rhs.getFavStatus()));
}

inline bool AddFavoriteResult::operator != (const AddFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteResult::operator < (const AddFavoriteResult& rhs) const {
    if (hasTabWeatherInfo() || rhs.hasTabWeatherInfo()) {
        if (getTabWeatherInfo() < rhs.getTabWeatherInfo()) return true;
        if (getTabWeatherInfo() > rhs.getTabWeatherInfo()) return false;
    }
    if (hasFavStatus() || rhs.hasFavStatus()) {
        if (getFavStatus() < rhs.getFavStatus()) return true;
        if (getFavStatus() > rhs.getFavStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddFavoriteResult::clone() {
    return new AddFavoriteResult(*this);
}

inline bool AddFavoriteResult::operator > (const AddFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteResult::clear() {
    clearTabWeatherInfo();
    clearFavStatus();
}

inline void AddFavoriteResult::clearTabWeatherInfo() {
    if (hasTabWeatherInfo()) {
         clear_has_TabWeatherInfo();
        _TabWeatherInfo.clear();
     }
}

inline bool AddFavoriteResult::hasTabWeatherInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& AddFavoriteResult::getTabWeatherInfo () const {
    return _TabWeatherInfo;
}

inline ::sxm_tabweather_main_fi_types::T_WeatherInfoList& AddFavoriteResult::getTabWeatherInfoMutable () {
    set_has_TabWeatherInfo();
    return _TabWeatherInfo;
}

inline void AddFavoriteResult::setTabWeatherInfo (const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& TabWeatherInfo_) {
    set_has_TabWeatherInfo();
    this->_TabWeatherInfo = TabWeatherInfo_;
}

inline void AddFavoriteResult::clearFavStatus() {
    if (hasFavStatus()) {
         clear_has_FavStatus();
        _FavStatus = false;
     }
}

inline bool AddFavoriteResult::hasFavStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool AddFavoriteResult::getFavStatus () const {
    return _FavStatus;
}

inline void AddFavoriteResult::setFavStatus (bool FavStatus_) {
    set_has_FavStatus();
    this->_FavStatus = FavStatus_;
}

inline void AddFavoriteResult::set_has_TabWeatherInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteResult::clear_has_TabWeatherInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AddFavoriteResult::set_has_FavStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void AddFavoriteResult::clear_has_FavStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AddFavoriteErrorStructure::AddFavoriteErrorStructure ()  :
    _ErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteErrorStructure::AddFavoriteErrorStructure (const AddFavoriteErrorStructure &rhs)  :
    _ErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteErrorStructure::AddFavoriteErrorStructure (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_TabWeather_ErrorTypes", "ErrorCode", "AddFavoriteErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteErrorStructure::~AddFavoriteErrorStructure() {
}

inline AddFavoriteErrorStructure& AddFavoriteErrorStructure::operator = (const AddFavoriteErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool AddFavoriteErrorStructure::operator == (const AddFavoriteErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool AddFavoriteErrorStructure::operator != (const AddFavoriteErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteErrorStructure::operator < (const AddFavoriteErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool AddFavoriteErrorStructure::operator > (const AddFavoriteErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteErrorStructure::clear() {
    clearErrorCode();
}

inline void AddFavoriteErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID;
     }
}

inline bool AddFavoriteErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes AddFavoriteErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void AddFavoriteErrorStructure::setErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_TabWeather_ErrorTypes", "ErrorCode", "AddFavoriteErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void AddFavoriteErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddFavoriteError::AddFavoriteError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  AddFavoriteError::AddFavoriteError (const AddFavoriteError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  AddFavoriteError::~AddFavoriteError() {
    deleteData ();
}

inline AddFavoriteError& AddFavoriteError::operator = (const AddFavoriteError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool AddFavoriteError::operator == (const AddFavoriteError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool AddFavoriteError::operator != (const AddFavoriteError& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteError::operator < (const AddFavoriteError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool AddFavoriteError::operator > (const AddFavoriteError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline AddFavoriteError::AddFavoriteErrorField AddFavoriteError::getField () const {
    return __field;
}

inline void AddFavoriteError::setField(AddFavoriteError::AddFavoriteErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* AddFavoriteError::clone() {
    return new AddFavoriteError(*this);
}

inline bool AddFavoriteError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const AddFavoriteErrorStructure& AddFavoriteError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AddFavoriteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return AddFavoriteErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline AddFavoriteErrorStructure& AddFavoriteError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AddFavoriteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new AddFavoriteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline AddFavoriteErrorStructure* AddFavoriteError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'AddFavoriteError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new AddFavoriteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        AddFavoriteErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void AddFavoriteError::replaceCcaErrorCode (AddFavoriteErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void AddFavoriteError::setCcaErrorCode (const AddFavoriteErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new AddFavoriteErrorStructure(value);
    }
}

inline bool AddFavoriteError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode AddFavoriteError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "AddFavoriteError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void AddFavoriteError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "AddFavoriteError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void AddFavoriteError::cloneData (const AddFavoriteError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new AddFavoriteErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new AddFavoriteErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void AddFavoriteError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  RemoveFavoriteStart::RemoveFavoriteStart ()  :
    _TabWeather_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteStart::RemoveFavoriteStart (const RemoveFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TabWeather_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteStart::RemoveFavoriteStart (uint32 TabWeather_LOCID_)  :
    _TabWeather_LOCID (TabWeather_LOCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteStart::~RemoveFavoriteStart() {
}

inline RemoveFavoriteStart& RemoveFavoriteStart::operator = (const RemoveFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTabWeather_LOCID()) {
            setTabWeather_LOCID(rhs.getTabWeather_LOCID());
        } else {
            clearTabWeather_LOCID();
        }
    }
    return *this;
}

inline bool RemoveFavoriteStart::operator == (const RemoveFavoriteStart& rhs) const {
    return (((!hasTabWeather_LOCID() && !rhs.hasTabWeather_LOCID()) || getTabWeather_LOCID() == rhs.getTabWeather_LOCID()));
}

inline bool RemoveFavoriteStart::operator != (const RemoveFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteStart::operator < (const RemoveFavoriteStart& rhs) const {
    if (hasTabWeather_LOCID() || rhs.hasTabWeather_LOCID()) {
        if (getTabWeather_LOCID() < rhs.getTabWeather_LOCID()) return true;
        if (getTabWeather_LOCID() > rhs.getTabWeather_LOCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveFavoriteStart::clone() {
    return new RemoveFavoriteStart(*this);
}

inline bool RemoveFavoriteStart::operator > (const RemoveFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteStart::clear() {
    clearTabWeather_LOCID();
}

inline void RemoveFavoriteStart::clearTabWeather_LOCID() {
    if (hasTabWeather_LOCID()) {
         clear_has_TabWeather_LOCID();
        _TabWeather_LOCID = 0u;
     }
}

inline bool RemoveFavoriteStart::hasTabWeather_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RemoveFavoriteStart::getTabWeather_LOCID () const {
    return _TabWeather_LOCID;
}

inline void RemoveFavoriteStart::setTabWeather_LOCID (uint32 TabWeather_LOCID_) {
    set_has_TabWeather_LOCID();
    this->_TabWeather_LOCID = TabWeather_LOCID_;
}

inline void RemoveFavoriteStart::set_has_TabWeather_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteStart::clear_has_TabWeather_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteResult::RemoveFavoriteResult ()  :
    _FavStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteResult::RemoveFavoriteResult (const RemoveFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _FavStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteResult::RemoveFavoriteResult (bool FavStatus_)  :
    _FavStatus (FavStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteResult::~RemoveFavoriteResult() {
}

inline RemoveFavoriteResult& RemoveFavoriteResult::operator = (const RemoveFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFavStatus()) {
            setFavStatus(rhs.getFavStatus());
        } else {
            clearFavStatus();
        }
    }
    return *this;
}

inline bool RemoveFavoriteResult::operator == (const RemoveFavoriteResult& rhs) const {
    return (((!hasFavStatus() && !rhs.hasFavStatus()) || getFavStatus() == rhs.getFavStatus()));
}

inline bool RemoveFavoriteResult::operator != (const RemoveFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteResult::operator < (const RemoveFavoriteResult& rhs) const {
    if (hasFavStatus() || rhs.hasFavStatus()) {
        if (getFavStatus() < rhs.getFavStatus()) return true;
        if (getFavStatus() > rhs.getFavStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveFavoriteResult::clone() {
    return new RemoveFavoriteResult(*this);
}

inline bool RemoveFavoriteResult::operator > (const RemoveFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteResult::clear() {
    clearFavStatus();
}

inline void RemoveFavoriteResult::clearFavStatus() {
    if (hasFavStatus()) {
         clear_has_FavStatus();
        _FavStatus = false;
     }
}

inline bool RemoveFavoriteResult::hasFavStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RemoveFavoriteResult::getFavStatus () const {
    return _FavStatus;
}

inline void RemoveFavoriteResult::setFavStatus (bool FavStatus_) {
    set_has_FavStatus();
    this->_FavStatus = FavStatus_;
}

inline void RemoveFavoriteResult::set_has_FavStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteResult::clear_has_FavStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteErrorStructure::RemoveFavoriteErrorStructure ()  :
    _ErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteErrorStructure::RemoveFavoriteErrorStructure (const RemoveFavoriteErrorStructure &rhs)  :
    _ErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteErrorStructure::RemoveFavoriteErrorStructure (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_TabWeather_ErrorTypes", "ErrorCode", "RemoveFavoriteErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteErrorStructure::~RemoveFavoriteErrorStructure() {
}

inline RemoveFavoriteErrorStructure& RemoveFavoriteErrorStructure::operator = (const RemoveFavoriteErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool RemoveFavoriteErrorStructure::operator == (const RemoveFavoriteErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool RemoveFavoriteErrorStructure::operator != (const RemoveFavoriteErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteErrorStructure::operator < (const RemoveFavoriteErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool RemoveFavoriteErrorStructure::operator > (const RemoveFavoriteErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteErrorStructure::clear() {
    clearErrorCode();
}

inline void RemoveFavoriteErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID;
     }
}

inline bool RemoveFavoriteErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes RemoveFavoriteErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void RemoveFavoriteErrorStructure::setErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_TabWeather_ErrorTypes", "ErrorCode", "RemoveFavoriteErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void RemoveFavoriteErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteError::RemoveFavoriteError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  RemoveFavoriteError::RemoveFavoriteError (const RemoveFavoriteError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  RemoveFavoriteError::~RemoveFavoriteError() {
    deleteData ();
}

inline RemoveFavoriteError& RemoveFavoriteError::operator = (const RemoveFavoriteError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool RemoveFavoriteError::operator == (const RemoveFavoriteError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool RemoveFavoriteError::operator != (const RemoveFavoriteError& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteError::operator < (const RemoveFavoriteError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool RemoveFavoriteError::operator > (const RemoveFavoriteError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline RemoveFavoriteError::RemoveFavoriteErrorField RemoveFavoriteError::getField () const {
    return __field;
}

inline void RemoveFavoriteError::setField(RemoveFavoriteError::RemoveFavoriteErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* RemoveFavoriteError::clone() {
    return new RemoveFavoriteError(*this);
}

inline bool RemoveFavoriteError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const RemoveFavoriteErrorStructure& RemoveFavoriteError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RemoveFavoriteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return RemoveFavoriteErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline RemoveFavoriteErrorStructure& RemoveFavoriteError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RemoveFavoriteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new RemoveFavoriteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline RemoveFavoriteErrorStructure* RemoveFavoriteError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'RemoveFavoriteError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new RemoveFavoriteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        RemoveFavoriteErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void RemoveFavoriteError::replaceCcaErrorCode (RemoveFavoriteErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void RemoveFavoriteError::setCcaErrorCode (const RemoveFavoriteErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new RemoveFavoriteErrorStructure(value);
    }
}

inline bool RemoveFavoriteError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode RemoveFavoriteError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "RemoveFavoriteError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void RemoveFavoriteError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "RemoveFavoriteError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void RemoveFavoriteError::cloneData (const RemoveFavoriteError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new RemoveFavoriteErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new RemoveFavoriteErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void RemoveFavoriteError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetFavoriteInfoStart::GetFavoriteInfoStart ()  :
    _TabWeather_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFavoriteInfoStart::GetFavoriteInfoStart (const GetFavoriteInfoStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TabWeather_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFavoriteInfoStart::GetFavoriteInfoStart (uint32 TabWeather_LOCID_)  :
    _TabWeather_LOCID (TabWeather_LOCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFavoriteInfoStart::~GetFavoriteInfoStart() {
}

inline GetFavoriteInfoStart& GetFavoriteInfoStart::operator = (const GetFavoriteInfoStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTabWeather_LOCID()) {
            setTabWeather_LOCID(rhs.getTabWeather_LOCID());
        } else {
            clearTabWeather_LOCID();
        }
    }
    return *this;
}

inline bool GetFavoriteInfoStart::operator == (const GetFavoriteInfoStart& rhs) const {
    return (((!hasTabWeather_LOCID() && !rhs.hasTabWeather_LOCID()) || getTabWeather_LOCID() == rhs.getTabWeather_LOCID()));
}

inline bool GetFavoriteInfoStart::operator != (const GetFavoriteInfoStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFavoriteInfoStart::operator < (const GetFavoriteInfoStart& rhs) const {
    if (hasTabWeather_LOCID() || rhs.hasTabWeather_LOCID()) {
        if (getTabWeather_LOCID() < rhs.getTabWeather_LOCID()) return true;
        if (getTabWeather_LOCID() > rhs.getTabWeather_LOCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetFavoriteInfoStart::clone() {
    return new GetFavoriteInfoStart(*this);
}

inline bool GetFavoriteInfoStart::operator > (const GetFavoriteInfoStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFavoriteInfoStart::clear() {
    clearTabWeather_LOCID();
}

inline void GetFavoriteInfoStart::clearTabWeather_LOCID() {
    if (hasTabWeather_LOCID()) {
         clear_has_TabWeather_LOCID();
        _TabWeather_LOCID = 0u;
     }
}

inline bool GetFavoriteInfoStart::hasTabWeather_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetFavoriteInfoStart::getTabWeather_LOCID () const {
    return _TabWeather_LOCID;
}

inline void GetFavoriteInfoStart::setTabWeather_LOCID (uint32 TabWeather_LOCID_) {
    set_has_TabWeather_LOCID();
    this->_TabWeather_LOCID = TabWeather_LOCID_;
}

inline void GetFavoriteInfoStart::set_has_TabWeather_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFavoriteInfoStart::clear_has_TabWeather_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetFavoriteInfoResult::GetFavoriteInfoResult ()  :
    _TabWeatherInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFavoriteInfoResult::GetFavoriteInfoResult (const GetFavoriteInfoResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TabWeatherInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFavoriteInfoResult::GetFavoriteInfoResult (const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& TabWeatherInfo_)  :
    _TabWeatherInfo (TabWeatherInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFavoriteInfoResult::~GetFavoriteInfoResult() {
}

inline GetFavoriteInfoResult& GetFavoriteInfoResult::operator = (const GetFavoriteInfoResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTabWeatherInfo()) {
            setTabWeatherInfo(rhs.getTabWeatherInfo());
        } else {
            clearTabWeatherInfo();
        }
    }
    return *this;
}

inline bool GetFavoriteInfoResult::operator == (const GetFavoriteInfoResult& rhs) const {
    return (((!hasTabWeatherInfo() && !rhs.hasTabWeatherInfo()) || getTabWeatherInfo() == rhs.getTabWeatherInfo()));
}

inline bool GetFavoriteInfoResult::operator != (const GetFavoriteInfoResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFavoriteInfoResult::operator < (const GetFavoriteInfoResult& rhs) const {
    if (hasTabWeatherInfo() || rhs.hasTabWeatherInfo()) {
        if (getTabWeatherInfo() < rhs.getTabWeatherInfo()) return true;
        if (getTabWeatherInfo() > rhs.getTabWeatherInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetFavoriteInfoResult::clone() {
    return new GetFavoriteInfoResult(*this);
}

inline bool GetFavoriteInfoResult::operator > (const GetFavoriteInfoResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFavoriteInfoResult::clear() {
    clearTabWeatherInfo();
}

inline void GetFavoriteInfoResult::clearTabWeatherInfo() {
    if (hasTabWeatherInfo()) {
         clear_has_TabWeatherInfo();
        _TabWeatherInfo.clear();
     }
}

inline bool GetFavoriteInfoResult::hasTabWeatherInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& GetFavoriteInfoResult::getTabWeatherInfo () const {
    return _TabWeatherInfo;
}

inline ::sxm_tabweather_main_fi_types::T_WeatherInfoList& GetFavoriteInfoResult::getTabWeatherInfoMutable () {
    set_has_TabWeatherInfo();
    return _TabWeatherInfo;
}

inline void GetFavoriteInfoResult::setTabWeatherInfo (const ::sxm_tabweather_main_fi_types::T_WeatherInfoList& TabWeatherInfo_) {
    set_has_TabWeatherInfo();
    this->_TabWeatherInfo = TabWeatherInfo_;
}

inline void GetFavoriteInfoResult::set_has_TabWeatherInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFavoriteInfoResult::clear_has_TabWeatherInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetFavoriteInfoErrorStructure::GetFavoriteInfoErrorStructure ()  :
    _ErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFavoriteInfoErrorStructure::GetFavoriteInfoErrorStructure (const GetFavoriteInfoErrorStructure &rhs)  :
    _ErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFavoriteInfoErrorStructure::GetFavoriteInfoErrorStructure (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_TabWeather_ErrorTypes", "ErrorCode", "GetFavoriteInfoErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFavoriteInfoErrorStructure::~GetFavoriteInfoErrorStructure() {
}

inline GetFavoriteInfoErrorStructure& GetFavoriteInfoErrorStructure::operator = (const GetFavoriteInfoErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetFavoriteInfoErrorStructure::operator == (const GetFavoriteInfoErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetFavoriteInfoErrorStructure::operator != (const GetFavoriteInfoErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFavoriteInfoErrorStructure::operator < (const GetFavoriteInfoErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetFavoriteInfoErrorStructure::operator > (const GetFavoriteInfoErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFavoriteInfoErrorStructure::clear() {
    clearErrorCode();
}

inline void GetFavoriteInfoErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID;
     }
}

inline bool GetFavoriteInfoErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes GetFavoriteInfoErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetFavoriteInfoErrorStructure::setErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_TabWeather_ErrorTypes", "ErrorCode", "GetFavoriteInfoErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetFavoriteInfoErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFavoriteInfoErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetFavoriteInfoError::GetFavoriteInfoError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetFavoriteInfoError::GetFavoriteInfoError (const GetFavoriteInfoError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetFavoriteInfoError::~GetFavoriteInfoError() {
    deleteData ();
}

inline GetFavoriteInfoError& GetFavoriteInfoError::operator = (const GetFavoriteInfoError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetFavoriteInfoError::operator == (const GetFavoriteInfoError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetFavoriteInfoError::operator != (const GetFavoriteInfoError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFavoriteInfoError::operator < (const GetFavoriteInfoError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetFavoriteInfoError::operator > (const GetFavoriteInfoError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetFavoriteInfoError::GetFavoriteInfoErrorField GetFavoriteInfoError::getField () const {
    return __field;
}

inline void GetFavoriteInfoError::setField(GetFavoriteInfoError::GetFavoriteInfoErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetFavoriteInfoError::clone() {
    return new GetFavoriteInfoError(*this);
}

inline bool GetFavoriteInfoError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetFavoriteInfoErrorStructure& GetFavoriteInfoError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetFavoriteInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetFavoriteInfoErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetFavoriteInfoErrorStructure& GetFavoriteInfoError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetFavoriteInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetFavoriteInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetFavoriteInfoErrorStructure* GetFavoriteInfoError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetFavoriteInfoError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetFavoriteInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetFavoriteInfoErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetFavoriteInfoError::replaceCcaErrorCode (GetFavoriteInfoErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetFavoriteInfoError::setCcaErrorCode (const GetFavoriteInfoErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetFavoriteInfoErrorStructure(value);
    }
}

inline bool GetFavoriteInfoError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetFavoriteInfoError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetFavoriteInfoError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetFavoriteInfoError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetFavoriteInfoError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetFavoriteInfoError::cloneData (const GetFavoriteInfoError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetFavoriteInfoErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetFavoriteInfoErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetFavoriteInfoError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SetListsConfigStart::SetListsConfigStart ()  :
    _Config ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigStart::SetListsConfigStart (const SetListsConfigStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Config ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigStart::SetListsConfigStart (const ::sxm_main_fi_types::T_SxmListsConfig& Config_)  :
    _Config (Config_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigStart::~SetListsConfigStart() {
}

inline SetListsConfigStart& SetListsConfigStart::operator = (const SetListsConfigStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfig()) {
            setConfig(rhs.getConfig());
        } else {
            clearConfig();
        }
    }
    return *this;
}

inline bool SetListsConfigStart::operator == (const SetListsConfigStart& rhs) const {
    return (((!hasConfig() && !rhs.hasConfig()) || getConfig() == rhs.getConfig()));
}

inline bool SetListsConfigStart::operator != (const SetListsConfigStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigStart::operator < (const SetListsConfigStart& rhs) const {
    if (hasConfig() || rhs.hasConfig()) {
        if (getConfig() < rhs.getConfig()) return true;
        if (getConfig() > rhs.getConfig()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetListsConfigStart::clone() {
    return new SetListsConfigStart(*this);
}

inline bool SetListsConfigStart::operator > (const SetListsConfigStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigStart::clear() {
    clearConfig();
}

inline void SetListsConfigStart::clearConfig() {
    if (hasConfig()) {
         clear_has_Config();
        _Config.clear();
     }
}

inline bool SetListsConfigStart::hasConfig () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListsConfig& SetListsConfigStart::getConfig () const {
    return _Config;
}

inline ::sxm_main_fi_types::T_SxmListsConfig& SetListsConfigStart::getConfigMutable () {
    set_has_Config();
    return _Config;
}

inline void SetListsConfigStart::setConfig (const ::sxm_main_fi_types::T_SxmListsConfig& Config_) {
    set_has_Config();
    this->_Config = Config_;
}

inline void SetListsConfigStart::set_has_Config () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigStart::clear_has_Config () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigResult::SetListsConfigResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigResult::SetListsConfigResult (const SetListsConfigResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigResult::SetListsConfigResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigResult::~SetListsConfigResult() {
}

inline SetListsConfigResult& SetListsConfigResult::operator = (const SetListsConfigResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SetListsConfigResult::operator == (const SetListsConfigResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SetListsConfigResult::operator != (const SetListsConfigResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigResult::operator < (const SetListsConfigResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetListsConfigResult::clone() {
    return new SetListsConfigResult(*this);
}

inline bool SetListsConfigResult::operator > (const SetListsConfigResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigResult::clear() {
    clearStatus();
}

inline void SetListsConfigResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool SetListsConfigResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetListsConfigResult::getStatus () const {
    return _Status;
}

inline void SetListsConfigResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void SetListsConfigResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigErrorStructure::SetListsConfigErrorStructure ()  :
    _ErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigErrorStructure::SetListsConfigErrorStructure (const SetListsConfigErrorStructure &rhs)  :
    _ErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigErrorStructure::SetListsConfigErrorStructure (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_TabWeather_ErrorTypes", "ErrorCode", "SetListsConfigErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigErrorStructure::~SetListsConfigErrorStructure() {
}

inline SetListsConfigErrorStructure& SetListsConfigErrorStructure::operator = (const SetListsConfigErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SetListsConfigErrorStructure::operator == (const SetListsConfigErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SetListsConfigErrorStructure::operator != (const SetListsConfigErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigErrorStructure::operator < (const SetListsConfigErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool SetListsConfigErrorStructure::operator > (const SetListsConfigErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigErrorStructure::clear() {
    clearErrorCode();
}

inline void SetListsConfigErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID;
     }
}

inline bool SetListsConfigErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes SetListsConfigErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void SetListsConfigErrorStructure::setErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_TabWeather_ErrorTypes", "ErrorCode", "SetListsConfigErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SetListsConfigErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigError::SetListsConfigError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SetListsConfigError::SetListsConfigError (const SetListsConfigError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SetListsConfigError::~SetListsConfigError() {
    deleteData ();
}

inline SetListsConfigError& SetListsConfigError::operator = (const SetListsConfigError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SetListsConfigError::operator == (const SetListsConfigError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SetListsConfigError::operator != (const SetListsConfigError& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigError::operator < (const SetListsConfigError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SetListsConfigError::operator > (const SetListsConfigError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SetListsConfigError::SetListsConfigErrorField SetListsConfigError::getField () const {
    return __field;
}

inline void SetListsConfigError::setField(SetListsConfigError::SetListsConfigErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SetListsConfigError::clone() {
    return new SetListsConfigError(*this);
}

inline bool SetListsConfigError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SetListsConfigErrorStructure& SetListsConfigError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetListsConfigError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SetListsConfigErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetListsConfigErrorStructure& SetListsConfigError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetListsConfigError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetListsConfigErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetListsConfigErrorStructure* SetListsConfigError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SetListsConfigError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetListsConfigErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SetListsConfigErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SetListsConfigError::replaceCcaErrorCode (SetListsConfigErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SetListsConfigError::setCcaErrorCode (const SetListsConfigErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SetListsConfigErrorStructure(value);
    }
}

inline bool SetListsConfigError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SetListsConfigError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SetListsConfigError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SetListsConfigError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SetListsConfigError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SetListsConfigError::cloneData (const SetListsConfigError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SetListsConfigErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SetListsConfigErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SetListsConfigError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  TabWeatherInfoListStatusStatus::TabWeatherInfoListStatusStatus ()  :
    _TabweatherListStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TabWeatherInfoListStatusStatus::TabWeatherInfoListStatusStatus (const TabWeatherInfoListStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _TabweatherListStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TabWeatherInfoListStatusStatus::TabWeatherInfoListStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& TabweatherListStatus_)  :
    _TabweatherListStatus (TabweatherListStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TabWeatherInfoListStatusStatus::~TabWeatherInfoListStatusStatus() {
}

inline TabWeatherInfoListStatusStatus& TabWeatherInfoListStatusStatus::operator = (const TabWeatherInfoListStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTabweatherListStatus()) {
            setTabweatherListStatus(rhs.getTabweatherListStatus());
        } else {
            clearTabweatherListStatus();
        }
    }
    return *this;
}

inline bool TabWeatherInfoListStatusStatus::operator == (const TabWeatherInfoListStatusStatus& rhs) const {
    return (((!hasTabweatherListStatus() && !rhs.hasTabweatherListStatus()) || getTabweatherListStatus() == rhs.getTabweatherListStatus()));
}

inline bool TabWeatherInfoListStatusStatus::operator != (const TabWeatherInfoListStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool TabWeatherInfoListStatusStatus::operator < (const TabWeatherInfoListStatusStatus& rhs) const {
    if (hasTabweatherListStatus() || rhs.hasTabweatherListStatus()) {
        if (getTabweatherListStatus() < rhs.getTabweatherListStatus()) return true;
        if (getTabweatherListStatus() > rhs.getTabweatherListStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TabWeatherInfoListStatusStatus::clone() {
    return new TabWeatherInfoListStatusStatus(*this);
}

inline bool TabWeatherInfoListStatusStatus::operator > (const TabWeatherInfoListStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TabWeatherInfoListStatusStatus::clear() {
    clearTabweatherListStatus();
}

inline void TabWeatherInfoListStatusStatus::clearTabweatherListStatus() {
    if (hasTabweatherListStatus()) {
         clear_has_TabweatherListStatus();
        _TabweatherListStatus.clear();
     }
}

inline bool TabWeatherInfoListStatusStatus::hasTabweatherListStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListInfos& TabWeatherInfoListStatusStatus::getTabweatherListStatus () const {
    return _TabweatherListStatus;
}

inline ::sxm_main_fi_types::T_SxmListInfos& TabWeatherInfoListStatusStatus::getTabweatherListStatusMutable () {
    set_has_TabweatherListStatus();
    return _TabweatherListStatus;
}

inline void TabWeatherInfoListStatusStatus::setTabweatherListStatus (const ::sxm_main_fi_types::T_SxmListInfos& TabweatherListStatus_) {
    set_has_TabweatherListStatus();
    this->_TabweatherListStatus = TabweatherListStatus_;
}

inline void TabWeatherInfoListStatusStatus::set_has_TabweatherListStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void TabWeatherInfoListStatusStatus::clear_has_TabweatherListStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TabWeatherInfoListStatusErrorStructure::TabWeatherInfoListStatusErrorStructure ()  :
    _ErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TabWeatherInfoListStatusErrorStructure::TabWeatherInfoListStatusErrorStructure (const TabWeatherInfoListStatusErrorStructure &rhs)  :
    _ErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TabWeatherInfoListStatusErrorStructure::TabWeatherInfoListStatusErrorStructure (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_TabWeather_ErrorTypes", "ErrorCode", "TabWeatherInfoListStatusErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TabWeatherInfoListStatusErrorStructure::~TabWeatherInfoListStatusErrorStructure() {
}

inline TabWeatherInfoListStatusErrorStructure& TabWeatherInfoListStatusErrorStructure::operator = (const TabWeatherInfoListStatusErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool TabWeatherInfoListStatusErrorStructure::operator == (const TabWeatherInfoListStatusErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool TabWeatherInfoListStatusErrorStructure::operator != (const TabWeatherInfoListStatusErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool TabWeatherInfoListStatusErrorStructure::operator < (const TabWeatherInfoListStatusErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool TabWeatherInfoListStatusErrorStructure::operator > (const TabWeatherInfoListStatusErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TabWeatherInfoListStatusErrorStructure::clear() {
    clearErrorCode();
}

inline void TabWeatherInfoListStatusErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes__WEATHER_OBJECT_INVALID;
     }
}

inline bool TabWeatherInfoListStatusErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes TabWeatherInfoListStatusErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void TabWeatherInfoListStatusErrorStructure::setErrorCode (::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_tabweather_main_fi_types::T_e8_TabWeather_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_TabWeather_ErrorTypes", "ErrorCode", "TabWeatherInfoListStatusErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void TabWeatherInfoListStatusErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void TabWeatherInfoListStatusErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TabWeatherInfoListStatusError::TabWeatherInfoListStatusError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  TabWeatherInfoListStatusError::TabWeatherInfoListStatusError (const TabWeatherInfoListStatusError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  TabWeatherInfoListStatusError::~TabWeatherInfoListStatusError() {
    deleteData ();
}

inline TabWeatherInfoListStatusError& TabWeatherInfoListStatusError::operator = (const TabWeatherInfoListStatusError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool TabWeatherInfoListStatusError::operator == (const TabWeatherInfoListStatusError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool TabWeatherInfoListStatusError::operator != (const TabWeatherInfoListStatusError& rhs) const {
    return ! (*this == rhs);
}

inline bool TabWeatherInfoListStatusError::operator < (const TabWeatherInfoListStatusError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool TabWeatherInfoListStatusError::operator > (const TabWeatherInfoListStatusError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline TabWeatherInfoListStatusError::TabWeatherInfoListStatusErrorField TabWeatherInfoListStatusError::getField () const {
    return __field;
}

inline void TabWeatherInfoListStatusError::setField(TabWeatherInfoListStatusError::TabWeatherInfoListStatusErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* TabWeatherInfoListStatusError::clone() {
    return new TabWeatherInfoListStatusError(*this);
}

inline bool TabWeatherInfoListStatusError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const TabWeatherInfoListStatusErrorStructure& TabWeatherInfoListStatusError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "TabWeatherInfoListStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return TabWeatherInfoListStatusErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline TabWeatherInfoListStatusErrorStructure& TabWeatherInfoListStatusError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "TabWeatherInfoListStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new TabWeatherInfoListStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline TabWeatherInfoListStatusErrorStructure* TabWeatherInfoListStatusError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'TabWeatherInfoListStatusError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new TabWeatherInfoListStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        TabWeatherInfoListStatusErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void TabWeatherInfoListStatusError::replaceCcaErrorCode (TabWeatherInfoListStatusErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void TabWeatherInfoListStatusError::setCcaErrorCode (const TabWeatherInfoListStatusErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new TabWeatherInfoListStatusErrorStructure(value);
    }
}

inline bool TabWeatherInfoListStatusError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode TabWeatherInfoListStatusError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "TabWeatherInfoListStatusError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void TabWeatherInfoListStatusError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "TabWeatherInfoListStatusError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void TabWeatherInfoListStatusError::cloneData (const TabWeatherInfoListStatusError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new TabWeatherInfoListStatusErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new TabWeatherInfoListStatusErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void TabWeatherInfoListStatusError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus ()  :
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_)  :
    _DataServiceState (DataServiceState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::~SxmDataServiceStatusStatus() {
}

inline SxmDataServiceStatusStatus& SxmDataServiceStatusStatus::operator = (const SxmDataServiceStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataServiceState()) {
            setDataServiceState(rhs.getDataServiceState());
        } else {
            clearDataServiceState();
        }
    }
    return *this;
}

inline bool SxmDataServiceStatusStatus::operator == (const SxmDataServiceStatusStatus& rhs) const {
    return (((!hasDataServiceState() && !rhs.hasDataServiceState()) || getDataServiceState() == rhs.getDataServiceState()));
}

inline bool SxmDataServiceStatusStatus::operator != (const SxmDataServiceStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmDataServiceStatusStatus::operator < (const SxmDataServiceStatusStatus& rhs) const {
    if (hasDataServiceState() || rhs.hasDataServiceState()) {
        if (getDataServiceState() < rhs.getDataServiceState()) return true;
        if (getDataServiceState() > rhs.getDataServiceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmDataServiceStatusStatus::clone() {
    return new SxmDataServiceStatusStatus(*this);
}

inline bool SxmDataServiceStatusStatus::operator > (const SxmDataServiceStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmDataServiceStatusStatus::clear() {
    clearDataServiceState();
}

inline void SxmDataServiceStatusStatus::clearDataServiceState() {
    if (hasDataServiceState()) {
         clear_has_DataServiceState();
        _DataServiceState.clear();
     }
}

inline bool SxmDataServiceStatusStatus::hasDataServiceState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceState () const {
    return _DataServiceState;
}

inline ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceStateMutable () {
    set_has_DataServiceState();
    return _DataServiceState;
}

inline void SxmDataServiceStatusStatus::setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_) {
    set_has_DataServiceState();
    this->_DataServiceState = DataServiceState_;
}

inline void SxmDataServiceStatusStatus::set_has_DataServiceState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmDataServiceStatusStatus::clear_has_DataServiceState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeStatus::SxmListModeStatus ()  :
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeStatus::SxmListModeStatus (const SxmListModeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeStatus::SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_)  :
    _ListMode (ListMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeStatus::~SxmListModeStatus() {
}

inline SxmListModeStatus& SxmListModeStatus::operator = (const SxmListModeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
    }
    return *this;
}

inline bool SxmListModeStatus::operator == (const SxmListModeStatus& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()));
}

inline bool SxmListModeStatus::operator != (const SxmListModeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeStatus::operator < (const SxmListModeStatus& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeStatus::clone() {
    return new SxmListModeStatus(*this);
}

inline bool SxmListModeStatus::operator > (const SxmListModeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeStatus::clear() {
    clearListMode();
}

inline void SxmListModeStatus::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeStatus::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeStatus::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeStatus::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeStatus::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeSet::SxmListModeSet ()  :
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeSet::SxmListModeSet (const SxmListModeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeSet::SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_)  :
    _ListMode (ListMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeSet::~SxmListModeSet() {
}

inline SxmListModeSet& SxmListModeSet::operator = (const SxmListModeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
    }
    return *this;
}

inline bool SxmListModeSet::operator == (const SxmListModeSet& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()));
}

inline bool SxmListModeSet::operator != (const SxmListModeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeSet::operator < (const SxmListModeSet& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeSet::clone() {
    return new SxmListModeSet(*this);
}

inline bool SxmListModeSet::operator > (const SxmListModeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeSet::clear() {
    clearListMode();
}

inline void SxmListModeSet::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeSet::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeSet::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeSet::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeSet::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace sxm_tabweather_main_fi

#endif // SXM_TABWEATHER_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
