#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_STOCKS_MAIN_FI_H
#define SXM_STOCKS_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include "sxm_stocks_main_fi_types.h"
#include "sxm_stocks_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'sxm_stocks_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Stocks feature
 *
 * Version: $Revision:   0.6  $
 *
 * Author: Visahan Balasubramanian
 *
 * Date: $Date:   May 15 2015  $
 *
 * Department: ECV3Z
 *
 * Title: sxm_stocks_main_fi
 *
 * <b>Description of 'sxm_stocks_main_fi':</b>
 *
 * RBEI/ECM
 */

namespace sxm_stocks_main_fi {

static const int SERVICE_ID = 155;

static const int FID_GetFavoriteStockSymbols = 1;

static const int FID_AddFavorite = 2;

static const int FID_RemoveFavorite = 3;

static const int FID_GetStockSymbolsByFilter = 4;

static const int FID_GetDataProviderInfo = 5;

static const int FID_SetListsConfig = 7;

static const int FID_GetStockSymbolsByFilterPS = 8;

static const int FID_ClearAllFavorites = 10;

static const int FID_StockStatus = 64;

static const int FID_SxmDataServiceStatus = 65;

static const int FID_SxmListMode = 66;

static const int FID_SxmStocksDataProviderInfoStatus = 67;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 5;

// forward declarations
class GetFavoriteStockSymbolsStart;

class GetFavoriteStockSymbolsResult;

class GetFavoriteStockSymbolsErrorStructure;

class GetFavoriteStockSymbolsError;

class AddFavoriteStart;

class AddFavoriteResult;

class AddFavoriteErrorStructure;

class AddFavoriteError;

class RemoveFavoriteStart;

class RemoveFavoriteResult;

class RemoveFavoriteErrorStructure;

class RemoveFavoriteError;

class GetStockSymbolsByFilterStart;

class GetStockSymbolsByFilterResult;

class GetStockSymbolsByFilterErrorStructure;

class GetStockSymbolsByFilterError;

class GetDataProviderInfoResult;

class GetDataProviderInfoErrorStructure;

class GetDataProviderInfoError;

class SetListsConfigStart;

class SetListsConfigResult;

class SetListsConfigErrorStructure;

class SetListsConfigError;

class GetStockSymbolsByFilterPSStart;

class GetStockSymbolsByFilterPSResult;

class GetStockSymbolsByFilterPSErrorStructure;

class GetStockSymbolsByFilterPSError;

class StockStatusStatus;

class StockStatusErrorStructure;

class StockStatusError;

class SxmDataServiceStatusStatus;

class SxmListModeStatus;

class SxmListModeSet;

class SxmStocksDataProviderInfoStatusStatus;

// type definitions
/**
 * The abort error message of the method "GetFavoriteStockSymbols"
 * This method is used to get Quote of all Favorite Stock symbols.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetFavoriteStockSymbolsAbortError;

/**
 * The abort error message of the method "AddFavorite"
 * This method takes a stock symbol in tString format as input parameter and adds it to the Favorites list for Stocks if its a valid Stock symbol.
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFavoriteAbortError;

/**
 * The abort error message of the method "RemoveFavorite"
 * This method takes a stock symbol in tString format as input parameter and removes it from the Stocks Favorites list if its a valid Stock symbol.
 */
typedef ::asf::cca::CcaTypes::DefaultError RemoveFavoriteAbortError;

/**
 * The abort error message of the method "GetStockSymbolsByFilter"
 * Retrieves a list of all stocks beginning with the given stock symbol.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetStockSymbolsByFilterAbortError;

/**
 * The start message of the method "GetDataProviderInfo"
 * Get Data Provider information as string if available.
 * No input parameters required as method argument
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetDataProviderInfoStart;

/**
 * The abort error message of the method "GetDataProviderInfo"
 * Get Data Provider information as string if available.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDataProviderInfoAbortError;

/**
 * The abort error message of the method "SetListsConfig"
 * This method is used to configure lists for stocks services
 */
typedef ::asf::cca::CcaTypes::DefaultError SetListsConfigAbortError;

/**
 * The abort error message of the method "GetStockSymbolsByFilterPS"
 * Retrieves a list of all stocks beginning with the given stock symbol, evaluates the characters to be displayed and provides the Display string to be displayed as user input in Keypad. This method needs to be used by HMI for getting Predictive speller support from MIDW.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetStockSymbolsByFilterPSAbortError;

/**
 * The start message of the method "ClearAllFavorites"
 * Clears all stocks from Favorites List. No arguments needs to be supplied to the method. The method does not provide any return value for method result.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearAllFavoritesStart;

/**
 * The result message of the method "ClearAllFavorites"
 * Clears all stocks from Favorites List. No arguments needs to be supplied to the method. The method does not provide any return value for method result.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearAllFavoritesResult;

/**
 * The abort error message of the method "ClearAllFavorites"
 * Clears all stocks from Favorites List. No arguments needs to be supplied to the method. The method does not provide any return value for method result.
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearAllFavoritesAbortError;

/**
 * The error message of 'ClearAllFavorites'
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearAllFavoritesError;

/**
 * The get message of the property "StockStatus"
 * Status of all stocks belonging to Favorites list.
 * Request Quotes for stocks in Favorites list
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StockStatusGet;

/**
 * The upreg message of the property "StockStatus"
 * Status of all stocks belonging to Favorites list.
 * Register for Stocks Quotes updates.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StockStatusUpReg;

/**
 * The relUpReg message of the property "StockStatus"
 * Status of all stocks belonging to Favorites list.
 * Unregister from Stocks Quotes updates.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StockStatusRelUpReg;

/**
 * The get message of the property "SxmDataServiceStatus"
 * Get the Status of Stocks Data Service
 * Status of Stocks Data Service
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusGet;

/**
 * The upreg message of the property "SxmDataServiceStatus"
 * Get the Status of Stocks Data Service
 * Register for Stocks Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusUpReg;

/**
 * The relUpReg message of the property "SxmDataServiceStatus"
 * Get the Status of Stocks Data Service
 * Unregister for Stocks Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusRelUpReg;

/**
 * The error message of 'SxmDataServiceStatus'
 * This error code specifies Stocks Data Service Status is not available
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmDataServiceStatusError;

/**
 * The upreg message of the property "SxmListMode"
 * Set the Mode of Stocks List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeUpReg;

/**
 * The relUpReg message of the property "SxmListMode"
 * Set the Mode of Stocks List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeRelUpReg;

/**
 * The error message of 'SxmListMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmListModeError;

/**
 * The get message of the property "SxmStocksDataProviderInfoStatus"
 * Get the Status of Data Provider Information for Stocks Feature
 * Status of Stocks Data Provider Information
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmStocksDataProviderInfoStatusGet;

/**
 * The upreg message of the property "SxmStocksDataProviderInfoStatus"
 * Get the Status of Data Provider Information for Stocks Feature
 * Register for Stocks Data Provider Information Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmStocksDataProviderInfoStatusUpReg;

/**
 * The relUpReg message of the property "SxmStocksDataProviderInfoStatus"
 * Get the Status of Data Provider Information for Stocks Feature
 * Unregister for Stocks Data Provider Information Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmStocksDataProviderInfoStatusRelUpReg;

/**
 * The error message of 'SxmStocksDataProviderInfoStatus'
 * This error code specifies Stocks Data Provider Information Status is not available
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmStocksDataProviderInfoStatusError;


/**
 * The start message of the method "GetFavoriteStockSymbols"
 * This method is used to get Quote of all Favorite Stock symbols.
 */
class GetFavoriteStockSymbolsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteStockSymbolsStart ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteStockSymbolsStart (const GetFavoriteStockSymbolsStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteStockSymbolsStart (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteStockSymbolsStart();

    /**
     * Assignment operator
     */
    inline GetFavoriteStockSymbolsStart& operator = (const GetFavoriteStockSymbolsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteStockSymbolsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteStockSymbolsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteStockSymbolsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteStockSymbolsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Stocks Type information as defined in T_e8_SxmPredefinedListIds.
     * For stocks this value must be equivalent to FAVORITES as defined in T_e8_SxmPredefinedListIds.
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Stocks Type information as defined in T_e8_SxmPredefinedListIds.
     * For stocks this value must be equivalent to FAVORITES as defined in T_e8_SxmPredefinedListIds.
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "Operation"

    static const int kOperation = 1;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * Operation to be performed
     *
     * @return The value of the field "Operation"
     */
    inline ::sxm_main_fi_types::T_e8_SxmListOperation getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * Operation to be performed
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_);

    static const GetFavoriteStockSymbolsStart &getDefaultInstance();

private:

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ListID;

    ::sxm_main_fi_types::T_e8_SxmListOperation _Operation;

};

/**
 * The result message of the method "GetFavoriteStockSymbols"
 * This method is used to get Quote of all Favorite Stock symbols.
 * Result of the method. Provide Stocks information.
 */
class GetFavoriteStockSymbolsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteStockSymbolsResult ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteStockSymbolsResult (const GetFavoriteStockSymbolsResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteStockSymbolsResult (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_, const ::sxm_stocks_main_fi_types::T_StockQuoteList& StocksQuoteList_);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteStockSymbolsResult();

    /**
     * Assignment operator
     */
    inline GetFavoriteStockSymbolsResult& operator = (const GetFavoriteStockSymbolsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteStockSymbolsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteStockSymbolsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteStockSymbolsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteStockSymbolsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Stocks type information to filter stocks info.
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Stocks type information to filter stocks info.
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "Operation"

    static const int kOperation = 1;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * Operation as in method-start
     *
     * @return The value of the field "Operation"
     */
    inline ::sxm_main_fi_types::T_e8_SxmListOperation getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * Operation as in method-start
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_);

    // API of field "ListInfo"

    static const int kListInfo = 2;

    /**
     * Clears the field "ListInfo".
     *
     * The field will be set to its default value. The hasListInfo()
     * method will return false.
     */
    inline void clearListInfo();

    /**
     * Checks whether the field "ListInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListInfo()). Otherwise it will return false.
     */
    inline bool hasListInfo () const;

    /**
     * Returns the value of the member "ListInfo".
     *
     * Information about the received list
     *
     * @return The value of the field "ListInfo"
     */
    inline const ::sxm_main_fi_types::T_SxmListInfo& getListInfo () const;

    /**
     * Retrieves the value of the field "ListInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListInfo".
     */
    inline ::sxm_main_fi_types::T_SxmListInfo& getListInfoMutable ();

    /**
     * Sets the value of the member "ListInfo".
     *
     * Information about the received list
     *
     * @param ListInfo The value which will be set
     */
    inline void setListInfo (const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_);

    // API of field "StocksQuoteList"

    static const int kStocksQuoteList = 3;

    /**
     * Clears the field "StocksQuoteList".
     *
     * The field will be set to its default value. The hasStocksQuoteList()
     * method will return false.
     */
    inline void clearStocksQuoteList();

    /**
     * Checks whether the field "StocksQuoteList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStocksQuoteList()). Otherwise it will return false.
     */
    inline bool hasStocksQuoteList () const;

    /**
     * Returns the value of the member "StocksQuoteList".
     *
     * List of all stocks quotes belonging to Favorites DSRL. Each item in the list contains stock symbol, current trading value of the stock, change in trading value of the stock since previous day's closing price and price movement direction.
     *
     * @return The value of the field "StocksQuoteList"
     */
    inline const ::sxm_stocks_main_fi_types::T_StockQuoteList& getStocksQuoteList () const;

    /**
     * Retrieves the value of the field "StocksQuoteList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StocksQuoteList".
     */
    inline ::sxm_stocks_main_fi_types::T_StockQuoteList& getStocksQuoteListMutable ();

    /**
     * Sets the value of the member "StocksQuoteList".
     *
     * List of all stocks quotes belonging to Favorites DSRL. Each item in the list contains stock symbol, current trading value of the stock, change in trading value of the stock since previous day's closing price and price movement direction.
     *
     * @param StocksQuoteList The value which will be set
     */
    inline void setStocksQuoteList (const ::sxm_stocks_main_fi_types::T_StockQuoteList& StocksQuoteList_);

    static const GetFavoriteStockSymbolsResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_stocks_main_fi_types::T_StockQuote >& getT_StockQuoteList_DefaultInstance ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    inline void set_has_ListInfo ();

    inline void clear_has_ListInfo ();

    inline void set_has_StocksQuoteList ();

    inline void clear_has_StocksQuoteList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _ListID;

    ::sxm_main_fi_types::T_e8_SxmListOperation _Operation;

    ::sxm_main_fi_types::T_SxmListInfo _ListInfo;

    ::sxm_stocks_main_fi_types::T_StockQuoteList _StocksQuoteList;

};

/**
 * The error message of 'GetFavoriteStockSymbols'
 */
class GetFavoriteStockSymbolsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteStockSymbolsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteStockSymbolsErrorStructure (const GetFavoriteStockSymbolsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteStockSymbolsErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetFavoriteStockSymbolsErrorStructure();

    /**
     * Assignment operator
     */
    inline GetFavoriteStockSymbolsErrorStructure& operator = (const GetFavoriteStockSymbolsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteStockSymbolsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteStockSymbolsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteStockSymbolsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteStockSymbolsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    static const GetFavoriteStockSymbolsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetFavoriteStockSymbols'
 */
class GetFavoriteStockSymbolsError  : public ::asf::core::Payload {
public:

    enum GetFavoriteStockSymbolsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetFavoriteStockSymbolsError ();

   /**
     * Copy constructor
     */
    inline  GetFavoriteStockSymbolsError (const GetFavoriteStockSymbolsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteStockSymbolsError();

    /**
     * Assigns a new value to this object.
     */
    inline GetFavoriteStockSymbolsError& operator = (const GetFavoriteStockSymbolsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteStockSymbolsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteStockSymbolsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteStockSymbolsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteStockSymbolsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetFavoriteStockSymbolsError::GetFavoriteStockSymbolsErrorField getField () const;

    inline void setField(GetFavoriteStockSymbolsError::GetFavoriteStockSymbolsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetFavoriteStockSymbolsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetFavoriteStockSymbolsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetFavoriteStockSymbolsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetFavoriteStockSymbolsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetFavoriteStockSymbolsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetFavoriteStockSymbolsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetFavoriteStockSymbolsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetFavoriteStockSymbolsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetFavoriteStockSymbolsError &getDefaultInstance();

private:

    inline void cloneData (const GetFavoriteStockSymbolsError& rhs);

    inline void deleteData ();

    GetFavoriteStockSymbolsErrorField __field;

    union {
        GetFavoriteStockSymbolsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AddFavorite"
 * This method takes a stock symbol in tString format as input parameter and adds it to the Favorites list for Stocks if its a valid Stock symbol.
 */
class AddFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteStart (const AddFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteStart (const ::std::string& StockSymbol_);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteStart();

    /**
     * Assignment operator
     */
    inline AddFavoriteStart& operator = (const AddFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StockSymbol"

    static const int kStockSymbol = 0;

    /**
     * Clears the field "StockSymbol".
     *
     * The field will be set to its default value. The hasStockSymbol()
     * method will return false.
     */
    inline void clearStockSymbol();

    /**
     * Checks whether the field "StockSymbol" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStockSymbol()). Otherwise it will return false.
     */
    inline bool hasStockSymbol () const;

    /**
     * Returns the value of the member "StockSymbol".
     *
     * The stock symbol that needs to be added as favorite.
     *
     * @return The value of the field "StockSymbol"
     */
    inline const ::std::string& getStockSymbol () const;

    /**
     * Retrieves the value of the field "StockSymbol" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StockSymbol".
     */
    inline ::std::string& getStockSymbolMutable ();

    /**
     * Sets the value of the member "StockSymbol".
     *
     * The stock symbol that needs to be added as favorite.
     *
     * @param StockSymbol The value which will be set
     */
    inline void setStockSymbol (const ::std::string& StockSymbol_);

    /**
     * Sets the value of the member "StockSymbol".
     *
     * The stock symbol that needs to be added as favorite.
     *
     * @param StockSymbol The value which will be set
     */
    inline void setStockSymbol (const char* StockSymbol_);

    /**
     * Sets the value of the member "StockSymbol".
     *
     * The stock symbol that needs to be added as favorite.
     *
     * @param StockSymbol The value which will be set
     */
    inline void setStockSymbol (const char* value, size_t size);

    static const AddFavoriteStart &getDefaultInstance();

private:

    inline void set_has_StockSymbol ();

    inline void clear_has_StockSymbol ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _StockSymbol;

};

/**
 * The result message of the method "AddFavorite"
 * This method takes a stock symbol in tString format as input parameter and adds it to the Favorites list for Stocks if its a valid Stock symbol.
 * Result of the method. Provide status of whether addition of the given stock symbol to the Favorites list is success or failure.
 */
class AddFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteResult (const AddFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteResult();

    /**
     * Assignment operator
     */
    inline AddFavoriteResult& operator = (const AddFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Favorite add status;
     * TRUE  : Addition of stocks to Favorites list is Success.
     * FALSE : Addition of stocks to Favorites list is Failure.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Favorite add status;
     * TRUE  : Addition of stocks to Favorites list is Success.
     * FALSE : Addition of stocks to Favorites list is Failure.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const AddFavoriteResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'AddFavorite'
 */
class AddFavoriteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteErrorStructure (const AddFavoriteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AddFavoriteErrorStructure();

    /**
     * Assignment operator
     */
    inline AddFavoriteErrorStructure& operator = (const AddFavoriteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    static const AddFavoriteErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'AddFavorite'
 */
class AddFavoriteError  : public ::asf::core::Payload {
public:

    enum AddFavoriteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AddFavoriteError ();

   /**
     * Copy constructor
     */
    inline  AddFavoriteError (const AddFavoriteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteError();

    /**
     * Assigns a new value to this object.
     */
    inline AddFavoriteError& operator = (const AddFavoriteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AddFavoriteError::AddFavoriteErrorField getField () const;

    inline void setField(AddFavoriteError::AddFavoriteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AddFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AddFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AddFavoriteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AddFavoriteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AddFavoriteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AddFavoriteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AddFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AddFavoriteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AddFavoriteError &getDefaultInstance();

private:

    inline void cloneData (const AddFavoriteError& rhs);

    inline void deleteData ();

    AddFavoriteErrorField __field;

    union {
        AddFavoriteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RemoveFavorite"
 * This method takes a stock symbol in tString format as input parameter and removes it from the Stocks Favorites list if its a valid Stock symbol.
 */
class RemoveFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteStart (const RemoveFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteStart (const ::std::string& StockSymbol_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteStart();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteStart& operator = (const RemoveFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StockSymbol"

    static const int kStockSymbol = 0;

    /**
     * Clears the field "StockSymbol".
     *
     * The field will be set to its default value. The hasStockSymbol()
     * method will return false.
     */
    inline void clearStockSymbol();

    /**
     * Checks whether the field "StockSymbol" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStockSymbol()). Otherwise it will return false.
     */
    inline bool hasStockSymbol () const;

    /**
     * Returns the value of the member "StockSymbol".
     *
     * The stock symbol that needs to be removed from favorites list.
     *
     * @return The value of the field "StockSymbol"
     */
    inline const ::std::string& getStockSymbol () const;

    /**
     * Retrieves the value of the field "StockSymbol" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StockSymbol".
     */
    inline ::std::string& getStockSymbolMutable ();

    /**
     * Sets the value of the member "StockSymbol".
     *
     * The stock symbol that needs to be removed from favorites list.
     *
     * @param StockSymbol The value which will be set
     */
    inline void setStockSymbol (const ::std::string& StockSymbol_);

    /**
     * Sets the value of the member "StockSymbol".
     *
     * The stock symbol that needs to be removed from favorites list.
     *
     * @param StockSymbol The value which will be set
     */
    inline void setStockSymbol (const char* StockSymbol_);

    /**
     * Sets the value of the member "StockSymbol".
     *
     * The stock symbol that needs to be removed from favorites list.
     *
     * @param StockSymbol The value which will be set
     */
    inline void setStockSymbol (const char* value, size_t size);

    static const RemoveFavoriteStart &getDefaultInstance();

private:

    inline void set_has_StockSymbol ();

    inline void clear_has_StockSymbol ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _StockSymbol;

};

/**
 * The result message of the method "RemoveFavorite"
 * This method takes a stock symbol in tString format as input parameter and removes it from the Stocks Favorites list if its a valid Stock symbol.
 * Result of the method. Provide status of whether removal of the given stock symbol to the Favorites list is success or failure.
 */
class RemoveFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteResult (const RemoveFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteResult();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteResult& operator = (const RemoveFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Favorite remove status;
     * TRUE  : Removal of stocks from Favorites list is Success.
     * FALSE : Removal of stocks from Favorites list is Failure.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Favorite remove status;
     * TRUE  : Removal of stocks from Favorites list is Success.
     * FALSE : Removal of stocks from Favorites list is Failure.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const RemoveFavoriteResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'RemoveFavorite'
 */
class RemoveFavoriteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteErrorStructure (const RemoveFavoriteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~RemoveFavoriteErrorStructure();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteErrorStructure& operator = (const RemoveFavoriteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    static const RemoveFavoriteErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'RemoveFavorite'
 */
class RemoveFavoriteError  : public ::asf::core::Payload {
public:

    enum RemoveFavoriteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RemoveFavoriteError ();

   /**
     * Copy constructor
     */
    inline  RemoveFavoriteError (const RemoveFavoriteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteError();

    /**
     * Assigns a new value to this object.
     */
    inline RemoveFavoriteError& operator = (const RemoveFavoriteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RemoveFavoriteError::RemoveFavoriteErrorField getField () const;

    inline void setField(RemoveFavoriteError::RemoveFavoriteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RemoveFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RemoveFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RemoveFavoriteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RemoveFavoriteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RemoveFavoriteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RemoveFavoriteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RemoveFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RemoveFavoriteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RemoveFavoriteError &getDefaultInstance();

private:

    inline void cloneData (const RemoveFavoriteError& rhs);

    inline void deleteData ();

    RemoveFavoriteErrorField __field;

    union {
        RemoveFavoriteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetStockSymbolsByFilter"
 * Retrieves a list of all stocks beginning with the given stock symbol.
 */
class GetStockSymbolsByFilterStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetStockSymbolsByFilterStart ();

    /**
     * Copy constructor
     */
    inline  GetStockSymbolsByFilterStart (const GetStockSymbolsByFilterStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetStockSymbolsByFilterStart (const ::std::string& StockFilter_);

    /**
     * Destructor
     */
    inline virtual  ~GetStockSymbolsByFilterStart();

    /**
     * Assignment operator
     */
    inline GetStockSymbolsByFilterStart& operator = (const GetStockSymbolsByFilterStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStockSymbolsByFilterStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStockSymbolsByFilterStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStockSymbolsByFilterStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStockSymbolsByFilterStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StockFilter"

    static const int kStockFilter = 0;

    /**
     * Clears the field "StockFilter".
     *
     * The field will be set to its default value. The hasStockFilter()
     * method will return false.
     */
    inline void clearStockFilter();

    /**
     * Checks whether the field "StockFilter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStockFilter()). Otherwise it will return false.
     */
    inline bool hasStockFilter () const;

    /**
     * Returns the value of the member "StockFilter".
     *
     * The input is the search key. All stocks symbols starting with this key must be retrieved.
     *
     * @return The value of the field "StockFilter"
     */
    inline const ::std::string& getStockFilter () const;

    /**
     * Retrieves the value of the field "StockFilter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StockFilter".
     */
    inline ::std::string& getStockFilterMutable ();

    /**
     * Sets the value of the member "StockFilter".
     *
     * The input is the search key. All stocks symbols starting with this key must be retrieved.
     *
     * @param StockFilter The value which will be set
     */
    inline void setStockFilter (const ::std::string& StockFilter_);

    /**
     * Sets the value of the member "StockFilter".
     *
     * The input is the search key. All stocks symbols starting with this key must be retrieved.
     *
     * @param StockFilter The value which will be set
     */
    inline void setStockFilter (const char* StockFilter_);

    /**
     * Sets the value of the member "StockFilter".
     *
     * The input is the search key. All stocks symbols starting with this key must be retrieved.
     *
     * @param StockFilter The value which will be set
     */
    inline void setStockFilter (const char* value, size_t size);

    static const GetStockSymbolsByFilterStart &getDefaultInstance();

private:

    inline void set_has_StockFilter ();

    inline void clear_has_StockFilter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _StockFilter;

};

/**
 * The result message of the method "GetStockSymbolsByFilter"
 * Retrieves a list of all stocks beginning with the given stock symbol.
 * Result of the method. Provide All stocks symbols that begin with a particular string.
 */
class GetStockSymbolsByFilterResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetStockSymbolsByFilterResult ();

    /**
     * Copy constructor
     */
    inline  GetStockSymbolsByFilterResult (const GetStockSymbolsByFilterResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetStockSymbolsByFilterResult (const ::sxm_stocks_main_fi_types::T_StockFilterList& StockFilterList_);

    /**
     * Destructor
     */
    inline virtual  ~GetStockSymbolsByFilterResult();

    /**
     * Assignment operator
     */
    inline GetStockSymbolsByFilterResult& operator = (const GetStockSymbolsByFilterResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStockSymbolsByFilterResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStockSymbolsByFilterResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStockSymbolsByFilterResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStockSymbolsByFilterResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StockFilterList"

    static const int kStockFilterList = 0;

    /**
     * Clears the field "StockFilterList".
     *
     * The field will be set to its default value. The hasStockFilterList()
     * method will return false.
     */
    inline void clearStockFilterList();

    /**
     * Checks whether the field "StockFilterList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStockFilterList()). Otherwise it will return false.
     */
    inline bool hasStockFilterList () const;

    /**
     * Returns the value of the member "StockFilterList".
     *
     * List of all Stocks starting with a given symbol.
     *
     * @return The value of the field "StockFilterList"
     */
    inline const ::sxm_stocks_main_fi_types::T_StockFilterList& getStockFilterList () const;

    /**
     * Retrieves the value of the field "StockFilterList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StockFilterList".
     */
    inline ::sxm_stocks_main_fi_types::T_StockFilterList& getStockFilterListMutable ();

    /**
     * Sets the value of the member "StockFilterList".
     *
     * List of all Stocks starting with a given symbol.
     *
     * @param StockFilterList The value which will be set
     */
    inline void setStockFilterList (const ::sxm_stocks_main_fi_types::T_StockFilterList& StockFilterList_);

    static const GetStockSymbolsByFilterResult &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_StockFilterList ();

    inline void clear_has_StockFilterList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_stocks_main_fi_types::T_StockFilterList _StockFilterList;

};

/**
 * The error message of 'GetStockSymbolsByFilter'
 */
class GetStockSymbolsByFilterErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetStockSymbolsByFilterErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetStockSymbolsByFilterErrorStructure (const GetStockSymbolsByFilterErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetStockSymbolsByFilterErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetStockSymbolsByFilterErrorStructure();

    /**
     * Assignment operator
     */
    inline GetStockSymbolsByFilterErrorStructure& operator = (const GetStockSymbolsByFilterErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStockSymbolsByFilterErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStockSymbolsByFilterErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStockSymbolsByFilterErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStockSymbolsByFilterErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    static const GetStockSymbolsByFilterErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetStockSymbolsByFilter'
 */
class GetStockSymbolsByFilterError  : public ::asf::core::Payload {
public:

    enum GetStockSymbolsByFilterErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetStockSymbolsByFilterError ();

   /**
     * Copy constructor
     */
    inline  GetStockSymbolsByFilterError (const GetStockSymbolsByFilterError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetStockSymbolsByFilterError();

    /**
     * Assigns a new value to this object.
     */
    inline GetStockSymbolsByFilterError& operator = (const GetStockSymbolsByFilterError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStockSymbolsByFilterError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStockSymbolsByFilterError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStockSymbolsByFilterError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStockSymbolsByFilterError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetStockSymbolsByFilterError::GetStockSymbolsByFilterErrorField getField () const;

    inline void setField(GetStockSymbolsByFilterError::GetStockSymbolsByFilterErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetStockSymbolsByFilterErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetStockSymbolsByFilterErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetStockSymbolsByFilterErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetStockSymbolsByFilterErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetStockSymbolsByFilterErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetStockSymbolsByFilterErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetStockSymbolsByFilterErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetStockSymbolsByFilterErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetStockSymbolsByFilterError &getDefaultInstance();

private:

    inline void cloneData (const GetStockSymbolsByFilterError& rhs);

    inline void deleteData ();

    GetStockSymbolsByFilterErrorField __field;

    union {
        GetStockSymbolsByFilterErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "GetDataProviderInfo"
 * Get Data Provider information as string if available.
 * Result of the method. Returns Data provider information.
 */
class GetDataProviderInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDataProviderInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetDataProviderInfoResult (const GetDataProviderInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetDataProviderInfoResult (const ::std::string& DataProviderInfo_);

    /**
     * Destructor
     */
    inline virtual  ~GetDataProviderInfoResult();

    /**
     * Assignment operator
     */
    inline GetDataProviderInfoResult& operator = (const GetDataProviderInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDataProviderInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDataProviderInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDataProviderInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDataProviderInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataProviderInfo"

    static const int kDataProviderInfo = 0;

    /**
     * Clears the field "DataProviderInfo".
     *
     * The field will be set to its default value. The hasDataProviderInfo()
     * method will return false.
     */
    inline void clearDataProviderInfo();

    /**
     * Checks whether the field "DataProviderInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataProviderInfo()). Otherwise it will return false.
     */
    inline bool hasDataProviderInfo () const;

    /**
     * Returns the value of the member "DataProviderInfo".
     *
     * Data provider information for Stocks feature.
     *
     * @return The value of the field "DataProviderInfo"
     */
    inline const ::std::string& getDataProviderInfo () const;

    /**
     * Retrieves the value of the field "DataProviderInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DataProviderInfo".
     */
    inline ::std::string& getDataProviderInfoMutable ();

    /**
     * Sets the value of the member "DataProviderInfo".
     *
     * Data provider information for Stocks feature.
     *
     * @param DataProviderInfo The value which will be set
     */
    inline void setDataProviderInfo (const ::std::string& DataProviderInfo_);

    /**
     * Sets the value of the member "DataProviderInfo".
     *
     * Data provider information for Stocks feature.
     *
     * @param DataProviderInfo The value which will be set
     */
    inline void setDataProviderInfo (const char* DataProviderInfo_);

    /**
     * Sets the value of the member "DataProviderInfo".
     *
     * Data provider information for Stocks feature.
     *
     * @param DataProviderInfo The value which will be set
     */
    inline void setDataProviderInfo (const char* value, size_t size);

    static const GetDataProviderInfoResult &getDefaultInstance();

private:

    inline void set_has_DataProviderInfo ();

    inline void clear_has_DataProviderInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _DataProviderInfo;

};

/**
 * The error message of 'GetDataProviderInfo'
 */
class GetDataProviderInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetDataProviderInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetDataProviderInfoErrorStructure (const GetDataProviderInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetDataProviderInfoErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetDataProviderInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetDataProviderInfoErrorStructure& operator = (const GetDataProviderInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDataProviderInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDataProviderInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDataProviderInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDataProviderInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    static const GetDataProviderInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetDataProviderInfo'
 */
class GetDataProviderInfoError  : public ::asf::core::Payload {
public:

    enum GetDataProviderInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetDataProviderInfoError ();

   /**
     * Copy constructor
     */
    inline  GetDataProviderInfoError (const GetDataProviderInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetDataProviderInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetDataProviderInfoError& operator = (const GetDataProviderInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDataProviderInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDataProviderInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDataProviderInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDataProviderInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetDataProviderInfoError::GetDataProviderInfoErrorField getField () const;

    inline void setField(GetDataProviderInfoError::GetDataProviderInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetDataProviderInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetDataProviderInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetDataProviderInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetDataProviderInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetDataProviderInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetDataProviderInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetDataProviderInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetDataProviderInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetDataProviderInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetDataProviderInfoError& rhs);

    inline void deleteData ();

    GetDataProviderInfoErrorField __field;

    union {
        GetDataProviderInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetListsConfig"
 * This method is used to configure lists for stocks services
 */
class SetListsConfigStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigStart ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigStart (const SetListsConfigStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigStart (const ::sxm_main_fi_types::T_SxmListsConfig& Config_);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigStart();

    /**
     * Assignment operator
     */
    inline SetListsConfigStart& operator = (const SetListsConfigStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Config"

    static const int kConfig = 0;

    /**
     * Clears the field "Config".
     *
     * The field will be set to its default value. The hasConfig()
     * method will return false.
     */
    inline void clearConfig();

    /**
     * Checks whether the field "Config" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfig()). Otherwise it will return false.
     */
    inline bool hasConfig () const;

    /**
     * Returns the value of the member "Config".
     *
     * Generic configuration for stocks list. Capacity for Stocks is "1". This needs to be passed to maintain uniformity across all SXM services.
     *
     * @return The value of the field "Config"
     */
    inline const ::sxm_main_fi_types::T_SxmListsConfig& getConfig () const;

    /**
     * Retrieves the value of the field "Config" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Config".
     */
    inline ::sxm_main_fi_types::T_SxmListsConfig& getConfigMutable ();

    /**
     * Sets the value of the member "Config".
     *
     * Generic configuration for stocks list. Capacity for Stocks is "1". This needs to be passed to maintain uniformity across all SXM services.
     *
     * @param Config The value which will be set
     */
    inline void setConfig (const ::sxm_main_fi_types::T_SxmListsConfig& Config_);

    static const SetListsConfigStart &getDefaultInstance();

private:

    inline void set_has_Config ();

    inline void clear_has_Config ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListsConfig _Config;

};

/**
 * The result message of the method "SetListsConfig"
 * This method is used to configure lists for stocks services
 */
class SetListsConfigResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigResult ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigResult (const SetListsConfigResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigResult();

    /**
     * Assignment operator
     */
    inline SetListsConfigResult& operator = (const SetListsConfigResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if value is accepted; FALSE otherwise
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if value is accepted; FALSE otherwise
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetListsConfigResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SetListsConfig'
 */
class SetListsConfigErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigErrorStructure (const SetListsConfigErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetListsConfigErrorStructure();

    /**
     * Assignment operator
     */
    inline SetListsConfigErrorStructure& operator = (const SetListsConfigErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    static const SetListsConfigErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SetListsConfig'
 */
class SetListsConfigError  : public ::asf::core::Payload {
public:

    enum SetListsConfigErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetListsConfigError ();

   /**
     * Copy constructor
     */
    inline  SetListsConfigError (const SetListsConfigError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigError();

    /**
     * Assigns a new value to this object.
     */
    inline SetListsConfigError& operator = (const SetListsConfigError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetListsConfigError::SetListsConfigErrorField getField () const;

    inline void setField(SetListsConfigError::SetListsConfigErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetListsConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetListsConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetListsConfigErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetListsConfigErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetListsConfigErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetListsConfigErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetListsConfigErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetListsConfigErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetListsConfigError &getDefaultInstance();

private:

    inline void cloneData (const SetListsConfigError& rhs);

    inline void deleteData ();

    SetListsConfigErrorField __field;

    union {
        SetListsConfigErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetStockSymbolsByFilterPS"
 * Retrieves a list of all stocks beginning with the given stock symbol, evaluates the characters to be displayed and provides the Display string to be displayed as user input in Keypad. This method needs to be used by HMI for getting Predictive speller support from MIDW.
 */
class GetStockSymbolsByFilterPSStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetStockSymbolsByFilterPSStart ();

    /**
     * Copy constructor
     */
    inline  GetStockSymbolsByFilterPSStart (const GetStockSymbolsByFilterPSStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetStockSymbolsByFilterPSStart (const ::std::string& StockFilter_, bool IsBackSpace_);

    /**
     * Destructor
     */
    inline virtual  ~GetStockSymbolsByFilterPSStart();

    /**
     * Assignment operator
     */
    inline GetStockSymbolsByFilterPSStart& operator = (const GetStockSymbolsByFilterPSStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStockSymbolsByFilterPSStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStockSymbolsByFilterPSStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStockSymbolsByFilterPSStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStockSymbolsByFilterPSStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StockFilter"

    static const int kStockFilter = 0;

    /**
     * Clears the field "StockFilter".
     *
     * The field will be set to its default value. The hasStockFilter()
     * method will return false.
     */
    inline void clearStockFilter();

    /**
     * Checks whether the field "StockFilter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStockFilter()). Otherwise it will return false.
     */
    inline bool hasStockFilter () const;

    /**
     * Returns the value of the member "StockFilter".
     *
     * The input is the search key. All stocks symbols starting with this key must be retrieved.
     *
     * @return The value of the field "StockFilter"
     */
    inline const ::std::string& getStockFilter () const;

    /**
     * Retrieves the value of the field "StockFilter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StockFilter".
     */
    inline ::std::string& getStockFilterMutable ();

    /**
     * Sets the value of the member "StockFilter".
     *
     * The input is the search key. All stocks symbols starting with this key must be retrieved.
     *
     * @param StockFilter The value which will be set
     */
    inline void setStockFilter (const ::std::string& StockFilter_);

    /**
     * Sets the value of the member "StockFilter".
     *
     * The input is the search key. All stocks symbols starting with this key must be retrieved.
     *
     * @param StockFilter The value which will be set
     */
    inline void setStockFilter (const char* StockFilter_);

    /**
     * Sets the value of the member "StockFilter".
     *
     * The input is the search key. All stocks symbols starting with this key must be retrieved.
     *
     * @param StockFilter The value which will be set
     */
    inline void setStockFilter (const char* value, size_t size);

    // API of field "IsBackSpace"

    static const int kIsBackSpace = 1;

    /**
     * Clears the field "IsBackSpace".
     *
     * The field will be set to its default value. The hasIsBackSpace()
     * method will return false.
     */
    inline void clearIsBackSpace();

    /**
     * Checks whether the field "IsBackSpace" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsBackSpace()). Otherwise it will return false.
     */
    inline bool hasIsBackSpace () const;

    /**
     * Returns the value of the member "IsBackSpace".
     *
     * True if backspace is entered, False otherwise.
     *
     * @return The value of the field "IsBackSpace"
     */
    inline bool getIsBackSpace () const;

    /**
     * Sets the value of the member "IsBackSpace".
     *
     * True if backspace is entered, False otherwise.
     *
     * @param IsBackSpace The value which will be set
     */
    inline void setIsBackSpace (bool IsBackSpace_);

    static const GetStockSymbolsByFilterPSStart &getDefaultInstance();

private:

    inline void set_has_StockFilter ();

    inline void clear_has_StockFilter ();

    inline void set_has_IsBackSpace ();

    inline void clear_has_IsBackSpace ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _StockFilter;

    bool _IsBackSpace;

};

/**
 * The result message of the method "GetStockSymbolsByFilterPS"
 * Retrieves a list of all stocks beginning with the given stock symbol, evaluates the characters to be displayed and provides the Display string to be displayed as user input in Keypad. This method needs to be used by HMI for getting Predictive speller support from MIDW.
 * Result of the method. Provides 1)All stocks symbols that begin with a particular string, 2) All characters to be enabled and 3) The string to be displayed in keypad.
 */
class GetStockSymbolsByFilterPSResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetStockSymbolsByFilterPSResult ();

    /**
     * Copy constructor
     */
    inline  GetStockSymbolsByFilterPSResult (const GetStockSymbolsByFilterPSResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetStockSymbolsByFilterPSResult (const ::sxm_stocks_main_fi_types::T_StockFilterList& StockFilterList_, const ::std::string& AllCharsToEnable_, const ::std::string& DisplayString_, uint32 Count_);

    /**
     * Destructor
     */
    inline virtual  ~GetStockSymbolsByFilterPSResult();

    /**
     * Assignment operator
     */
    inline GetStockSymbolsByFilterPSResult& operator = (const GetStockSymbolsByFilterPSResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStockSymbolsByFilterPSResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStockSymbolsByFilterPSResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStockSymbolsByFilterPSResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStockSymbolsByFilterPSResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StockFilterList"

    static const int kStockFilterList = 0;

    /**
     * Clears the field "StockFilterList".
     *
     * The field will be set to its default value. The hasStockFilterList()
     * method will return false.
     */
    inline void clearStockFilterList();

    /**
     * Checks whether the field "StockFilterList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStockFilterList()). Otherwise it will return false.
     */
    inline bool hasStockFilterList () const;

    /**
     * Returns the value of the member "StockFilterList".
     *
     * List of all Stocks starting with a given symbol. If there are no characters entered in speller, then this List size would be empty in which case the calling application has to check for the value Count in methodResult.
     *
     * @return The value of the field "StockFilterList"
     */
    inline const ::sxm_stocks_main_fi_types::T_StockFilterList& getStockFilterList () const;

    /**
     * Retrieves the value of the field "StockFilterList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StockFilterList".
     */
    inline ::sxm_stocks_main_fi_types::T_StockFilterList& getStockFilterListMutable ();

    /**
     * Sets the value of the member "StockFilterList".
     *
     * List of all Stocks starting with a given symbol. If there are no characters entered in speller, then this List size would be empty in which case the calling application has to check for the value Count in methodResult.
     *
     * @param StockFilterList The value which will be set
     */
    inline void setStockFilterList (const ::sxm_stocks_main_fi_types::T_StockFilterList& StockFilterList_);

    // API of field "AllCharsToEnable"

    static const int kAllCharsToEnable = 1;

    /**
     * Clears the field "AllCharsToEnable".
     *
     * The field will be set to its default value. The hasAllCharsToEnable()
     * method will return false.
     */
    inline void clearAllCharsToEnable();

    /**
     * Checks whether the field "AllCharsToEnable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAllCharsToEnable()). Otherwise it will return false.
     */
    inline bool hasAllCharsToEnable () const;

    /**
     * Returns the value of the member "AllCharsToEnable".
     *
     * Set of all characters to be enabled in Keypad is packed into string.
     *
     * @return The value of the field "AllCharsToEnable"
     */
    inline const ::std::string& getAllCharsToEnable () const;

    /**
     * Retrieves the value of the field "AllCharsToEnable" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AllCharsToEnable".
     */
    inline ::std::string& getAllCharsToEnableMutable ();

    /**
     * Sets the value of the member "AllCharsToEnable".
     *
     * Set of all characters to be enabled in Keypad is packed into string.
     *
     * @param AllCharsToEnable The value which will be set
     */
    inline void setAllCharsToEnable (const ::std::string& AllCharsToEnable_);

    /**
     * Sets the value of the member "AllCharsToEnable".
     *
     * Set of all characters to be enabled in Keypad is packed into string.
     *
     * @param AllCharsToEnable The value which will be set
     */
    inline void setAllCharsToEnable (const char* AllCharsToEnable_);

    /**
     * Sets the value of the member "AllCharsToEnable".
     *
     * Set of all characters to be enabled in Keypad is packed into string.
     *
     * @param AllCharsToEnable The value which will be set
     */
    inline void setAllCharsToEnable (const char* value, size_t size);

    // API of field "DisplayString"

    static const int kDisplayString = 2;

    /**
     * Clears the field "DisplayString".
     *
     * The field will be set to its default value. The hasDisplayString()
     * method will return false.
     */
    inline void clearDisplayString();

    /**
     * Checks whether the field "DisplayString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayString()). Otherwise it will return false.
     */
    inline bool hasDisplayString () const;

    /**
     * Returns the value of the member "DisplayString".
     *
     * The actual string to be displayed as user input in Keypad. Needed to handle backspace character.
     *
     * @return The value of the field "DisplayString"
     */
    inline const ::std::string& getDisplayString () const;

    /**
     * Retrieves the value of the field "DisplayString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayString".
     */
    inline ::std::string& getDisplayStringMutable ();

    /**
     * Sets the value of the member "DisplayString".
     *
     * The actual string to be displayed as user input in Keypad. Needed to handle backspace character.
     *
     * @param DisplayString The value which will be set
     */
    inline void setDisplayString (const ::std::string& DisplayString_);

    /**
     * Sets the value of the member "DisplayString".
     *
     * The actual string to be displayed as user input in Keypad. Needed to handle backspace character.
     *
     * @param DisplayString The value which will be set
     */
    inline void setDisplayString (const char* DisplayString_);

    /**
     * Sets the value of the member "DisplayString".
     *
     * The actual string to be displayed as user input in Keypad. Needed to handle backspace character.
     *
     * @param DisplayString The value which will be set
     */
    inline void setDisplayString (const char* value, size_t size);

    // API of field "Count"

    static const int kCount = 3;

    /**
     * Clears the field "Count".
     *
     * The field will be set to its default value. The hasCount()
     * method will return false.
     */
    inline void clearCount();

    /**
     * Checks whether the field "Count" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCount()). Otherwise it will return false.
     */
    inline bool hasCount () const;

    /**
     * Returns the value of the member "Count".
     *
     * The number of stock symbols that begin with the given leading characters. This case would be applicable if the number of characters entered in speller is zero.
     *
     * @return The value of the field "Count"
     */
    inline uint32 getCount () const;

    /**
     * Sets the value of the member "Count".
     *
     * The number of stock symbols that begin with the given leading characters. This case would be applicable if the number of characters entered in speller is zero.
     *
     * @param Count The value which will be set
     */
    inline void setCount (uint32 Count_);

    static const GetStockSymbolsByFilterPSResult &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_StockFilterList ();

    inline void clear_has_StockFilterList ();

    inline void set_has_AllCharsToEnable ();

    inline void clear_has_AllCharsToEnable ();

    inline void set_has_DisplayString ();

    inline void clear_has_DisplayString ();

    inline void set_has_Count ();

    inline void clear_has_Count ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::sxm_stocks_main_fi_types::T_StockFilterList _StockFilterList;

    ::std::string _AllCharsToEnable;

    ::std::string _DisplayString;

    uint32 _Count;

};

/**
 * The error message of 'GetStockSymbolsByFilterPS'
 */
class GetStockSymbolsByFilterPSErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetStockSymbolsByFilterPSErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetStockSymbolsByFilterPSErrorStructure (const GetStockSymbolsByFilterPSErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetStockSymbolsByFilterPSErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetStockSymbolsByFilterPSErrorStructure();

    /**
     * Assignment operator
     */
    inline GetStockSymbolsByFilterPSErrorStructure& operator = (const GetStockSymbolsByFilterPSErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStockSymbolsByFilterPSErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStockSymbolsByFilterPSErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStockSymbolsByFilterPSErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStockSymbolsByFilterPSErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    static const GetStockSymbolsByFilterPSErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetStockSymbolsByFilterPS'
 */
class GetStockSymbolsByFilterPSError  : public ::asf::core::Payload {
public:

    enum GetStockSymbolsByFilterPSErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetStockSymbolsByFilterPSError ();

   /**
     * Copy constructor
     */
    inline  GetStockSymbolsByFilterPSError (const GetStockSymbolsByFilterPSError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetStockSymbolsByFilterPSError();

    /**
     * Assigns a new value to this object.
     */
    inline GetStockSymbolsByFilterPSError& operator = (const GetStockSymbolsByFilterPSError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStockSymbolsByFilterPSError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStockSymbolsByFilterPSError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStockSymbolsByFilterPSError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStockSymbolsByFilterPSError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetStockSymbolsByFilterPSError::GetStockSymbolsByFilterPSErrorField getField () const;

    inline void setField(GetStockSymbolsByFilterPSError::GetStockSymbolsByFilterPSErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetStockSymbolsByFilterPSErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetStockSymbolsByFilterPSErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetStockSymbolsByFilterPSErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetStockSymbolsByFilterPSErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetStockSymbolsByFilterPSErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetStockSymbolsByFilterPSErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetStockSymbolsByFilterPSErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetStockSymbolsByFilterPSErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetStockSymbolsByFilterPSError &getDefaultInstance();

private:

    inline void cloneData (const GetStockSymbolsByFilterPSError& rhs);

    inline void deleteData ();

    GetStockSymbolsByFilterPSErrorField __field;

    union {
        GetStockSymbolsByFilterPSErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "StockStatus"
 * Status of all stocks belonging to Favorites list.
 */
class StockStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StockStatusStatus ();

    /**
     * Copy constructor
     */
    inline  StockStatusStatus (const StockStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StockStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& StockStatus_);

    /**
     * Destructor
     */
    inline virtual  ~StockStatusStatus();

    /**
     * Assignment operator
     */
    inline StockStatusStatus& operator = (const StockStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StockStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StockStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StockStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StockStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StockStatus"

    static const int kStockStatus = 0;

    /**
     * Clears the field "StockStatus".
     *
     * The field will be set to its default value. The hasStockStatus()
     * method will return false.
     */
    inline void clearStockStatus();

    /**
     * Checks whether the field "StockStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStockStatus()). Otherwise it will return false.
     */
    inline bool hasStockStatus () const;

    /**
     * Returns the value of the member "StockStatus".
     *
     * Stocks Lists configuration and other status info.
     *
     * @return The value of the field "StockStatus"
     */
    inline const ::sxm_main_fi_types::T_SxmListInfos& getStockStatus () const;

    /**
     * Retrieves the value of the field "StockStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StockStatus".
     */
    inline ::sxm_main_fi_types::T_SxmListInfos& getStockStatusMutable ();

    /**
     * Sets the value of the member "StockStatus".
     *
     * Stocks Lists configuration and other status info.
     *
     * @param StockStatus The value which will be set
     */
    inline void setStockStatus (const ::sxm_main_fi_types::T_SxmListInfos& StockStatus_);

    static const StockStatusStatus &getDefaultInstance();

private:

    inline void set_has_StockStatus ();

    inline void clear_has_StockStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListInfos _StockStatus;

};

/**
 * The error message of 'StockStatus'
 */
class StockStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  StockStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  StockStatusErrorStructure (const StockStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  StockStatusErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~StockStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline StockStatusErrorStructure& operator = (const StockStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StockStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StockStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StockStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StockStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Stocks Feature.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_);

    static const StockStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'StockStatus'
 */
class StockStatusError  : public ::asf::core::Payload {
public:

    enum StockStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  StockStatusError ();

   /**
     * Copy constructor
     */
    inline  StockStatusError (const StockStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~StockStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline StockStatusError& operator = (const StockStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StockStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StockStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StockStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StockStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline StockStatusError::StockStatusErrorField getField () const;

    inline void setField(StockStatusError::StockStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "StockStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "StockStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const StockStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline StockStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline StockStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (StockStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "StockStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const StockStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const StockStatusError &getDefaultInstance();

private:

    inline void cloneData (const StockStatusError& rhs);

    inline void deleteData ();

    StockStatusErrorField __field;

    union {
        StockStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SxmDataServiceStatus"
 * Get the Status of Stocks Data Service
 */
class SxmDataServiceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmDataServiceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    /**
     * Destructor
     */
    inline virtual  ~SxmDataServiceStatusStatus();

    /**
     * Assignment operator
     */
    inline SxmDataServiceStatusStatus& operator = (const SxmDataServiceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataServiceState"

    static const int kDataServiceState = 0;

    /**
     * Clears the field "DataServiceState".
     *
     * The field will be set to its default value. The hasDataServiceState()
     * method will return false.
     */
    inline void clearDataServiceState();

    /**
     * Checks whether the field "DataServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataServiceState()). Otherwise it will return false.
     */
    inline bool hasDataServiceState () const;

    /**
     * Returns the value of the member "DataServiceState".
     *
     * Status of Stocks Data Service
     *
     * @return The value of the field "DataServiceState"
     */
    inline const ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceState () const;

    /**
     * Retrieves the value of the field "DataServiceState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DataServiceState".
     */
    inline ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceStateMutable ();

    /**
     * Sets the value of the member "DataServiceState".
     *
     * Status of Stocks Data Service
     *
     * @param DataServiceState The value which will be set
     */
    inline void setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    static const SxmDataServiceStatusStatus &getDefaultInstance();

private:

    inline void set_has_DataServiceState ();

    inline void clear_has_DataServiceState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmDataSrvState _DataServiceState;

};

/**
 * The status message of the property "SxmListMode"
 * Set the Mode of Stocks List.
 */
class SxmListModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeStatus ();

    /**
     * Copy constructor
     */
    inline  SxmListModeStatus (const SxmListModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeStatus();

    /**
     * Assignment operator
     */
    inline SxmListModeStatus& operator = (const SxmListModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of Stocks List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of Stocks List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    static const SxmListModeStatus &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

};

/**
 * The set message of the property "SxmListMode"
 * Set the Mode of Stocks List.
 */
class SxmListModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeSet ();

    /**
     * Copy constructor
     */
    inline  SxmListModeSet (const SxmListModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeSet();

    /**
     * Assignment operator
     */
    inline SxmListModeSet& operator = (const SxmListModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of Stocks List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of Stocks List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    static const SxmListModeSet &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

};

/**
 * The status message of the property "SxmStocksDataProviderInfoStatus"
 * Get the Status of Data Provider Information for Stocks Feature
 */
class SxmStocksDataProviderInfoStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmStocksDataProviderInfoStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SxmStocksDataProviderInfoStatusStatus (const SxmStocksDataProviderInfoStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmStocksDataProviderInfoStatusStatus (bool DataProviderInfoStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SxmStocksDataProviderInfoStatusStatus();

    /**
     * Assignment operator
     */
    inline SxmStocksDataProviderInfoStatusStatus& operator = (const SxmStocksDataProviderInfoStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmStocksDataProviderInfoStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmStocksDataProviderInfoStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmStocksDataProviderInfoStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmStocksDataProviderInfoStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataProviderInfoStatus"

    static const int kDataProviderInfoStatus = 0;

    /**
     * Clears the field "DataProviderInfoStatus".
     *
     * The field will be set to its default value. The hasDataProviderInfoStatus()
     * method will return false.
     */
    inline void clearDataProviderInfoStatus();

    /**
     * Checks whether the field "DataProviderInfoStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataProviderInfoStatus()). Otherwise it will return false.
     */
    inline bool hasDataProviderInfoStatus () const;

    /**
     * Returns the value of the member "DataProviderInfoStatus".
     *
     * Status of Stocks Data Provider Information. TRUE if Data Provider Information is received OTA; FALSE if is its not yet received
     *
     * @return The value of the field "DataProviderInfoStatus"
     */
    inline bool getDataProviderInfoStatus () const;

    /**
     * Sets the value of the member "DataProviderInfoStatus".
     *
     * Status of Stocks Data Provider Information. TRUE if Data Provider Information is received OTA; FALSE if is its not yet received
     *
     * @param DataProviderInfoStatus The value which will be set
     */
    inline void setDataProviderInfoStatus (bool DataProviderInfoStatus_);

    static const SxmStocksDataProviderInfoStatusStatus &getDefaultInstance();

private:

    inline void set_has_DataProviderInfoStatus ();

    inline void clear_has_DataProviderInfoStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _DataProviderInfoStatus;

};

inline  GetFavoriteStockSymbolsStart::GetFavoriteStockSymbolsStart ()  :
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFavoriteStockSymbolsStart::GetFavoriteStockSymbolsStart (const GetFavoriteStockSymbolsStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFavoriteStockSymbolsStart::GetFavoriteStockSymbolsStart (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_)  :
    _ListID (ListID_),
    _Operation (Operation_)
{
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetFavoriteStockSymbolsStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFavoriteStockSymbolsStart::~GetFavoriteStockSymbolsStart() {
}

inline GetFavoriteStockSymbolsStart& GetFavoriteStockSymbolsStart::operator = (const GetFavoriteStockSymbolsStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasOperation()) {
            setOperation(rhs.getOperation());
        } else {
            clearOperation();
        }
    }
    return *this;
}

inline bool GetFavoriteStockSymbolsStart::operator == (const GetFavoriteStockSymbolsStart& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasOperation() && !rhs.hasOperation()) || getOperation() == rhs.getOperation()));
}

inline bool GetFavoriteStockSymbolsStart::operator != (const GetFavoriteStockSymbolsStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFavoriteStockSymbolsStart::operator < (const GetFavoriteStockSymbolsStart& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasOperation() || rhs.hasOperation()) {
        if ((uint32)getOperation() < (uint32)rhs.getOperation()) return true;
        if ((uint32)getOperation() > (uint32)rhs.getOperation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetFavoriteStockSymbolsStart::clone() {
    return new GetFavoriteStockSymbolsStart(*this);
}

inline bool GetFavoriteStockSymbolsStart::operator > (const GetFavoriteStockSymbolsStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFavoriteStockSymbolsStart::clear() {
    clearListID();
    clearOperation();
}

inline void GetFavoriteStockSymbolsStart::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetFavoriteStockSymbolsStart::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetFavoriteStockSymbolsStart::getListID () const {
    return _ListID;
}

inline void GetFavoriteStockSymbolsStart::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetFavoriteStockSymbolsStart::clearOperation() {
    if (hasOperation()) {
         clear_has_Operation();
        _Operation = ::sxm_main_fi_types::T_e8_SxmListOperation__IDLE;
     }
}

inline bool GetFavoriteStockSymbolsStart::hasOperation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_main_fi_types::T_e8_SxmListOperation GetFavoriteStockSymbolsStart::getOperation () const {
    return _Operation;
}

inline void GetFavoriteStockSymbolsStart::setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_) {
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetFavoriteStockSymbolsStart");
    }
    #endif
    set_has_Operation();
    this->_Operation = Operation_;
}

inline void GetFavoriteStockSymbolsStart::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFavoriteStockSymbolsStart::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetFavoriteStockSymbolsStart::set_has_Operation () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetFavoriteStockSymbolsStart::clear_has_Operation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetFavoriteStockSymbolsResult::GetFavoriteStockSymbolsResult ()  :
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _ListInfo (),
    _StocksQuoteList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFavoriteStockSymbolsResult::GetFavoriteStockSymbolsResult (const GetFavoriteStockSymbolsResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _ListInfo (),
    _StocksQuoteList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFavoriteStockSymbolsResult::GetFavoriteStockSymbolsResult (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_, const ::sxm_stocks_main_fi_types::T_StockQuoteList& StocksQuoteList_)  :
    _ListID (ListID_),
    _Operation (Operation_),
    _ListInfo (ListInfo_),
    _StocksQuoteList (StocksQuoteList_)
{
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetFavoriteStockSymbolsResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFavoriteStockSymbolsResult::~GetFavoriteStockSymbolsResult() {
}

inline GetFavoriteStockSymbolsResult& GetFavoriteStockSymbolsResult::operator = (const GetFavoriteStockSymbolsResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasOperation()) {
            setOperation(rhs.getOperation());
        } else {
            clearOperation();
        }
        if (rhs.hasListInfo()) {
            setListInfo(rhs.getListInfo());
        } else {
            clearListInfo();
        }
        if (rhs.hasStocksQuoteList()) {
            setStocksQuoteList(rhs.getStocksQuoteList());
        } else {
            clearStocksQuoteList();
        }
    }
    return *this;
}

inline bool GetFavoriteStockSymbolsResult::operator == (const GetFavoriteStockSymbolsResult& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasOperation() && !rhs.hasOperation()) || getOperation() == rhs.getOperation()) &&
        ((!hasListInfo() && !rhs.hasListInfo()) || getListInfo() == rhs.getListInfo()) &&
        ((!hasStocksQuoteList() && !rhs.hasStocksQuoteList()) || getStocksQuoteList() == rhs.getStocksQuoteList()));
}

inline bool GetFavoriteStockSymbolsResult::operator != (const GetFavoriteStockSymbolsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFavoriteStockSymbolsResult::operator < (const GetFavoriteStockSymbolsResult& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasOperation() || rhs.hasOperation()) {
        if ((uint32)getOperation() < (uint32)rhs.getOperation()) return true;
        if ((uint32)getOperation() > (uint32)rhs.getOperation()) return false;
    }
    if (hasListInfo() || rhs.hasListInfo()) {
        if (getListInfo() < rhs.getListInfo()) return true;
        if (getListInfo() > rhs.getListInfo()) return false;
    }
    if (hasStocksQuoteList() || rhs.hasStocksQuoteList()) {
        if (getStocksQuoteList() < rhs.getStocksQuoteList()) return true;
        if (getStocksQuoteList() > rhs.getStocksQuoteList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetFavoriteStockSymbolsResult::clone() {
    return new GetFavoriteStockSymbolsResult(*this);
}

inline bool GetFavoriteStockSymbolsResult::operator > (const GetFavoriteStockSymbolsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFavoriteStockSymbolsResult::clear() {
    clearListID();
    clearOperation();
    clearListInfo();
    clearStocksQuoteList();
}

inline void GetFavoriteStockSymbolsResult::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetFavoriteStockSymbolsResult::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetFavoriteStockSymbolsResult::getListID () const {
    return _ListID;
}

inline void GetFavoriteStockSymbolsResult::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetFavoriteStockSymbolsResult::clearOperation() {
    if (hasOperation()) {
         clear_has_Operation();
        _Operation = ::sxm_main_fi_types::T_e8_SxmListOperation__IDLE;
     }
}

inline bool GetFavoriteStockSymbolsResult::hasOperation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_main_fi_types::T_e8_SxmListOperation GetFavoriteStockSymbolsResult::getOperation () const {
    return _Operation;
}

inline void GetFavoriteStockSymbolsResult::setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_) {
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetFavoriteStockSymbolsResult");
    }
    #endif
    set_has_Operation();
    this->_Operation = Operation_;
}

inline void GetFavoriteStockSymbolsResult::clearListInfo() {
    if (hasListInfo()) {
         clear_has_ListInfo();
        _ListInfo.clear();
     }
}

inline bool GetFavoriteStockSymbolsResult::hasListInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListInfo& GetFavoriteStockSymbolsResult::getListInfo () const {
    return _ListInfo;
}

inline ::sxm_main_fi_types::T_SxmListInfo& GetFavoriteStockSymbolsResult::getListInfoMutable () {
    set_has_ListInfo();
    return _ListInfo;
}

inline void GetFavoriteStockSymbolsResult::setListInfo (const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_) {
    set_has_ListInfo();
    this->_ListInfo = ListInfo_;
}

inline void GetFavoriteStockSymbolsResult::clearStocksQuoteList() {
    if (hasStocksQuoteList()) {
         clear_has_StocksQuoteList();
        _StocksQuoteList.clear();
     }
}

inline bool GetFavoriteStockSymbolsResult::hasStocksQuoteList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::sxm_stocks_main_fi_types::T_StockQuoteList& GetFavoriteStockSymbolsResult::getStocksQuoteList () const {
    return _StocksQuoteList;
}

inline ::sxm_stocks_main_fi_types::T_StockQuoteList& GetFavoriteStockSymbolsResult::getStocksQuoteListMutable () {
    set_has_StocksQuoteList();
    return _StocksQuoteList;
}

inline void GetFavoriteStockSymbolsResult::setStocksQuoteList (const ::sxm_stocks_main_fi_types::T_StockQuoteList& StocksQuoteList_) {
    set_has_StocksQuoteList();
    this->_StocksQuoteList = StocksQuoteList_;
}

inline void GetFavoriteStockSymbolsResult::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFavoriteStockSymbolsResult::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetFavoriteStockSymbolsResult::set_has_Operation () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetFavoriteStockSymbolsResult::clear_has_Operation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetFavoriteStockSymbolsResult::set_has_ListInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetFavoriteStockSymbolsResult::clear_has_ListInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetFavoriteStockSymbolsResult::set_has_StocksQuoteList () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetFavoriteStockSymbolsResult::clear_has_StocksQuoteList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetFavoriteStockSymbolsErrorStructure::GetFavoriteStockSymbolsErrorStructure ()  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFavoriteStockSymbolsErrorStructure::GetFavoriteStockSymbolsErrorStructure (const GetFavoriteStockSymbolsErrorStructure &rhs)  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFavoriteStockSymbolsErrorStructure::GetFavoriteStockSymbolsErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "GetFavoriteStockSymbolsErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFavoriteStockSymbolsErrorStructure::~GetFavoriteStockSymbolsErrorStructure() {
}

inline GetFavoriteStockSymbolsErrorStructure& GetFavoriteStockSymbolsErrorStructure::operator = (const GetFavoriteStockSymbolsErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetFavoriteStockSymbolsErrorStructure::operator == (const GetFavoriteStockSymbolsErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetFavoriteStockSymbolsErrorStructure::operator != (const GetFavoriteStockSymbolsErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFavoriteStockSymbolsErrorStructure::operator < (const GetFavoriteStockSymbolsErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetFavoriteStockSymbolsErrorStructure::operator > (const GetFavoriteStockSymbolsErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFavoriteStockSymbolsErrorStructure::clear() {
    clearErrorCode();
}

inline void GetFavoriteStockSymbolsErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE;
     }
}

inline bool GetFavoriteStockSymbolsErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes GetFavoriteStockSymbolsErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetFavoriteStockSymbolsErrorStructure::setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "GetFavoriteStockSymbolsErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetFavoriteStockSymbolsErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFavoriteStockSymbolsErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetFavoriteStockSymbolsError::GetFavoriteStockSymbolsError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetFavoriteStockSymbolsError::GetFavoriteStockSymbolsError (const GetFavoriteStockSymbolsError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetFavoriteStockSymbolsError::~GetFavoriteStockSymbolsError() {
    deleteData ();
}

inline GetFavoriteStockSymbolsError& GetFavoriteStockSymbolsError::operator = (const GetFavoriteStockSymbolsError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetFavoriteStockSymbolsError::operator == (const GetFavoriteStockSymbolsError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetFavoriteStockSymbolsError::operator != (const GetFavoriteStockSymbolsError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFavoriteStockSymbolsError::operator < (const GetFavoriteStockSymbolsError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetFavoriteStockSymbolsError::operator > (const GetFavoriteStockSymbolsError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetFavoriteStockSymbolsError::GetFavoriteStockSymbolsErrorField GetFavoriteStockSymbolsError::getField () const {
    return __field;
}

inline void GetFavoriteStockSymbolsError::setField(GetFavoriteStockSymbolsError::GetFavoriteStockSymbolsErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetFavoriteStockSymbolsError::clone() {
    return new GetFavoriteStockSymbolsError(*this);
}

inline bool GetFavoriteStockSymbolsError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetFavoriteStockSymbolsErrorStructure& GetFavoriteStockSymbolsError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetFavoriteStockSymbolsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetFavoriteStockSymbolsErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetFavoriteStockSymbolsErrorStructure& GetFavoriteStockSymbolsError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetFavoriteStockSymbolsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetFavoriteStockSymbolsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetFavoriteStockSymbolsErrorStructure* GetFavoriteStockSymbolsError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetFavoriteStockSymbolsError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetFavoriteStockSymbolsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetFavoriteStockSymbolsErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetFavoriteStockSymbolsError::replaceCcaErrorCode (GetFavoriteStockSymbolsErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetFavoriteStockSymbolsError::setCcaErrorCode (const GetFavoriteStockSymbolsErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetFavoriteStockSymbolsErrorStructure(value);
    }
}

inline bool GetFavoriteStockSymbolsError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetFavoriteStockSymbolsError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetFavoriteStockSymbolsError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetFavoriteStockSymbolsError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetFavoriteStockSymbolsError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetFavoriteStockSymbolsError::cloneData (const GetFavoriteStockSymbolsError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetFavoriteStockSymbolsErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetFavoriteStockSymbolsErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetFavoriteStockSymbolsError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  AddFavoriteStart::AddFavoriteStart ()  :
    _StockSymbol ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteStart::AddFavoriteStart (const AddFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _StockSymbol ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteStart::AddFavoriteStart (const ::std::string& StockSymbol_)  :
    _StockSymbol (StockSymbol_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockSymbol_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteStart::~AddFavoriteStart() {
}

inline AddFavoriteStart& AddFavoriteStart::operator = (const AddFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStockSymbol()) {
            setStockSymbol(rhs.getStockSymbol());
        } else {
            clearStockSymbol();
        }
    }
    return *this;
}

inline bool AddFavoriteStart::operator == (const AddFavoriteStart& rhs) const {
    return (((!hasStockSymbol() && !rhs.hasStockSymbol()) || getStockSymbol() == rhs.getStockSymbol()));
}

inline bool AddFavoriteStart::operator != (const AddFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteStart::operator < (const AddFavoriteStart& rhs) const {
    if (hasStockSymbol() || rhs.hasStockSymbol()) {
        if (getStockSymbol() < rhs.getStockSymbol()) return true;
        if (getStockSymbol() > rhs.getStockSymbol()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddFavoriteStart::clone() {
    return new AddFavoriteStart(*this);
}

inline bool AddFavoriteStart::operator > (const AddFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteStart::clear() {
    clearStockSymbol();
}

inline void AddFavoriteStart::clearStockSymbol() {
    if (hasStockSymbol()) {
         clear_has_StockSymbol();
        _StockSymbol.clear();
     }
}

inline bool AddFavoriteStart::hasStockSymbol () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AddFavoriteStart::getStockSymbol () const {
    return _StockSymbol;
}

inline ::std::string& AddFavoriteStart::getStockSymbolMutable () {
    set_has_StockSymbol();
    return _StockSymbol;
}

inline void AddFavoriteStart::setStockSymbol (const ::std::string& StockSymbol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockSymbol_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockSymbol();
    this->_StockSymbol = StockSymbol_;
}

inline void AddFavoriteStart::setStockSymbol (const char* StockSymbol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockSymbol_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockSymbol();
    this->_StockSymbol.assign(StockSymbol_);
}

inline void AddFavoriteStart::setStockSymbol (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockSymbol();
    this->_StockSymbol.assign(value, size);
}

inline void AddFavoriteStart::set_has_StockSymbol () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteStart::clear_has_StockSymbol () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddFavoriteResult::AddFavoriteResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteResult::AddFavoriteResult (const AddFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteResult::AddFavoriteResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteResult::~AddFavoriteResult() {
}

inline AddFavoriteResult& AddFavoriteResult::operator = (const AddFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool AddFavoriteResult::operator == (const AddFavoriteResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool AddFavoriteResult::operator != (const AddFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteResult::operator < (const AddFavoriteResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddFavoriteResult::clone() {
    return new AddFavoriteResult(*this);
}

inline bool AddFavoriteResult::operator > (const AddFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteResult::clear() {
    clearStatus();
}

inline void AddFavoriteResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool AddFavoriteResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AddFavoriteResult::getStatus () const {
    return _Status;
}

inline void AddFavoriteResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void AddFavoriteResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddFavoriteErrorStructure::AddFavoriteErrorStructure ()  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteErrorStructure::AddFavoriteErrorStructure (const AddFavoriteErrorStructure &rhs)  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteErrorStructure::AddFavoriteErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "AddFavoriteErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteErrorStructure::~AddFavoriteErrorStructure() {
}

inline AddFavoriteErrorStructure& AddFavoriteErrorStructure::operator = (const AddFavoriteErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool AddFavoriteErrorStructure::operator == (const AddFavoriteErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool AddFavoriteErrorStructure::operator != (const AddFavoriteErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteErrorStructure::operator < (const AddFavoriteErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool AddFavoriteErrorStructure::operator > (const AddFavoriteErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteErrorStructure::clear() {
    clearErrorCode();
}

inline void AddFavoriteErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE;
     }
}

inline bool AddFavoriteErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes AddFavoriteErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void AddFavoriteErrorStructure::setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "AddFavoriteErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void AddFavoriteErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddFavoriteError::AddFavoriteError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  AddFavoriteError::AddFavoriteError (const AddFavoriteError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  AddFavoriteError::~AddFavoriteError() {
    deleteData ();
}

inline AddFavoriteError& AddFavoriteError::operator = (const AddFavoriteError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool AddFavoriteError::operator == (const AddFavoriteError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool AddFavoriteError::operator != (const AddFavoriteError& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteError::operator < (const AddFavoriteError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool AddFavoriteError::operator > (const AddFavoriteError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline AddFavoriteError::AddFavoriteErrorField AddFavoriteError::getField () const {
    return __field;
}

inline void AddFavoriteError::setField(AddFavoriteError::AddFavoriteErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* AddFavoriteError::clone() {
    return new AddFavoriteError(*this);
}

inline bool AddFavoriteError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const AddFavoriteErrorStructure& AddFavoriteError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AddFavoriteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return AddFavoriteErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline AddFavoriteErrorStructure& AddFavoriteError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AddFavoriteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new AddFavoriteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline AddFavoriteErrorStructure* AddFavoriteError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'AddFavoriteError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new AddFavoriteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        AddFavoriteErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void AddFavoriteError::replaceCcaErrorCode (AddFavoriteErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void AddFavoriteError::setCcaErrorCode (const AddFavoriteErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new AddFavoriteErrorStructure(value);
    }
}

inline bool AddFavoriteError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode AddFavoriteError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "AddFavoriteError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void AddFavoriteError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "AddFavoriteError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void AddFavoriteError::cloneData (const AddFavoriteError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new AddFavoriteErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new AddFavoriteErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void AddFavoriteError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  RemoveFavoriteStart::RemoveFavoriteStart ()  :
    _StockSymbol ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteStart::RemoveFavoriteStart (const RemoveFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _StockSymbol ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteStart::RemoveFavoriteStart (const ::std::string& StockSymbol_)  :
    _StockSymbol (StockSymbol_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockSymbol_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteStart::~RemoveFavoriteStart() {
}

inline RemoveFavoriteStart& RemoveFavoriteStart::operator = (const RemoveFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStockSymbol()) {
            setStockSymbol(rhs.getStockSymbol());
        } else {
            clearStockSymbol();
        }
    }
    return *this;
}

inline bool RemoveFavoriteStart::operator == (const RemoveFavoriteStart& rhs) const {
    return (((!hasStockSymbol() && !rhs.hasStockSymbol()) || getStockSymbol() == rhs.getStockSymbol()));
}

inline bool RemoveFavoriteStart::operator != (const RemoveFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteStart::operator < (const RemoveFavoriteStart& rhs) const {
    if (hasStockSymbol() || rhs.hasStockSymbol()) {
        if (getStockSymbol() < rhs.getStockSymbol()) return true;
        if (getStockSymbol() > rhs.getStockSymbol()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveFavoriteStart::clone() {
    return new RemoveFavoriteStart(*this);
}

inline bool RemoveFavoriteStart::operator > (const RemoveFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteStart::clear() {
    clearStockSymbol();
}

inline void RemoveFavoriteStart::clearStockSymbol() {
    if (hasStockSymbol()) {
         clear_has_StockSymbol();
        _StockSymbol.clear();
     }
}

inline bool RemoveFavoriteStart::hasStockSymbol () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemoveFavoriteStart::getStockSymbol () const {
    return _StockSymbol;
}

inline ::std::string& RemoveFavoriteStart::getStockSymbolMutable () {
    set_has_StockSymbol();
    return _StockSymbol;
}

inline void RemoveFavoriteStart::setStockSymbol (const ::std::string& StockSymbol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockSymbol_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockSymbol();
    this->_StockSymbol = StockSymbol_;
}

inline void RemoveFavoriteStart::setStockSymbol (const char* StockSymbol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockSymbol_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockSymbol();
    this->_StockSymbol.assign(StockSymbol_);
}

inline void RemoveFavoriteStart::setStockSymbol (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockSymbol();
    this->_StockSymbol.assign(value, size);
}

inline void RemoveFavoriteStart::set_has_StockSymbol () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteStart::clear_has_StockSymbol () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteResult::RemoveFavoriteResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteResult::RemoveFavoriteResult (const RemoveFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteResult::RemoveFavoriteResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteResult::~RemoveFavoriteResult() {
}

inline RemoveFavoriteResult& RemoveFavoriteResult::operator = (const RemoveFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool RemoveFavoriteResult::operator == (const RemoveFavoriteResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool RemoveFavoriteResult::operator != (const RemoveFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteResult::operator < (const RemoveFavoriteResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveFavoriteResult::clone() {
    return new RemoveFavoriteResult(*this);
}

inline bool RemoveFavoriteResult::operator > (const RemoveFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteResult::clear() {
    clearStatus();
}

inline void RemoveFavoriteResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool RemoveFavoriteResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RemoveFavoriteResult::getStatus () const {
    return _Status;
}

inline void RemoveFavoriteResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void RemoveFavoriteResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteErrorStructure::RemoveFavoriteErrorStructure ()  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteErrorStructure::RemoveFavoriteErrorStructure (const RemoveFavoriteErrorStructure &rhs)  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteErrorStructure::RemoveFavoriteErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "RemoveFavoriteErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteErrorStructure::~RemoveFavoriteErrorStructure() {
}

inline RemoveFavoriteErrorStructure& RemoveFavoriteErrorStructure::operator = (const RemoveFavoriteErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool RemoveFavoriteErrorStructure::operator == (const RemoveFavoriteErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool RemoveFavoriteErrorStructure::operator != (const RemoveFavoriteErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteErrorStructure::operator < (const RemoveFavoriteErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool RemoveFavoriteErrorStructure::operator > (const RemoveFavoriteErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteErrorStructure::clear() {
    clearErrorCode();
}

inline void RemoveFavoriteErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE;
     }
}

inline bool RemoveFavoriteErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes RemoveFavoriteErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void RemoveFavoriteErrorStructure::setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "RemoveFavoriteErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void RemoveFavoriteErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteError::RemoveFavoriteError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  RemoveFavoriteError::RemoveFavoriteError (const RemoveFavoriteError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  RemoveFavoriteError::~RemoveFavoriteError() {
    deleteData ();
}

inline RemoveFavoriteError& RemoveFavoriteError::operator = (const RemoveFavoriteError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool RemoveFavoriteError::operator == (const RemoveFavoriteError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool RemoveFavoriteError::operator != (const RemoveFavoriteError& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteError::operator < (const RemoveFavoriteError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool RemoveFavoriteError::operator > (const RemoveFavoriteError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline RemoveFavoriteError::RemoveFavoriteErrorField RemoveFavoriteError::getField () const {
    return __field;
}

inline void RemoveFavoriteError::setField(RemoveFavoriteError::RemoveFavoriteErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* RemoveFavoriteError::clone() {
    return new RemoveFavoriteError(*this);
}

inline bool RemoveFavoriteError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const RemoveFavoriteErrorStructure& RemoveFavoriteError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RemoveFavoriteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return RemoveFavoriteErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline RemoveFavoriteErrorStructure& RemoveFavoriteError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RemoveFavoriteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new RemoveFavoriteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline RemoveFavoriteErrorStructure* RemoveFavoriteError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'RemoveFavoriteError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new RemoveFavoriteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        RemoveFavoriteErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void RemoveFavoriteError::replaceCcaErrorCode (RemoveFavoriteErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void RemoveFavoriteError::setCcaErrorCode (const RemoveFavoriteErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new RemoveFavoriteErrorStructure(value);
    }
}

inline bool RemoveFavoriteError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode RemoveFavoriteError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "RemoveFavoriteError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void RemoveFavoriteError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "RemoveFavoriteError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void RemoveFavoriteError::cloneData (const RemoveFavoriteError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new RemoveFavoriteErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new RemoveFavoriteErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void RemoveFavoriteError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetStockSymbolsByFilterStart::GetStockSymbolsByFilterStart ()  :
    _StockFilter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStockSymbolsByFilterStart::GetStockSymbolsByFilterStart (const GetStockSymbolsByFilterStart &rhs)  :
    ::asf::core::Payload(rhs),
    _StockFilter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStockSymbolsByFilterStart::GetStockSymbolsByFilterStart (const ::std::string& StockFilter_)  :
    _StockFilter (StockFilter_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockFilter_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStockSymbolsByFilterStart::~GetStockSymbolsByFilterStart() {
}

inline GetStockSymbolsByFilterStart& GetStockSymbolsByFilterStart::operator = (const GetStockSymbolsByFilterStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStockFilter()) {
            setStockFilter(rhs.getStockFilter());
        } else {
            clearStockFilter();
        }
    }
    return *this;
}

inline bool GetStockSymbolsByFilterStart::operator == (const GetStockSymbolsByFilterStart& rhs) const {
    return (((!hasStockFilter() && !rhs.hasStockFilter()) || getStockFilter() == rhs.getStockFilter()));
}

inline bool GetStockSymbolsByFilterStart::operator != (const GetStockSymbolsByFilterStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStockSymbolsByFilterStart::operator < (const GetStockSymbolsByFilterStart& rhs) const {
    if (hasStockFilter() || rhs.hasStockFilter()) {
        if (getStockFilter() < rhs.getStockFilter()) return true;
        if (getStockFilter() > rhs.getStockFilter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetStockSymbolsByFilterStart::clone() {
    return new GetStockSymbolsByFilterStart(*this);
}

inline bool GetStockSymbolsByFilterStart::operator > (const GetStockSymbolsByFilterStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStockSymbolsByFilterStart::clear() {
    clearStockFilter();
}

inline void GetStockSymbolsByFilterStart::clearStockFilter() {
    if (hasStockFilter()) {
         clear_has_StockFilter();
        _StockFilter.clear();
     }
}

inline bool GetStockSymbolsByFilterStart::hasStockFilter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetStockSymbolsByFilterStart::getStockFilter () const {
    return _StockFilter;
}

inline ::std::string& GetStockSymbolsByFilterStart::getStockFilterMutable () {
    set_has_StockFilter();
    return _StockFilter;
}

inline void GetStockSymbolsByFilterStart::setStockFilter (const ::std::string& StockFilter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockFilter_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockFilter();
    this->_StockFilter = StockFilter_;
}

inline void GetStockSymbolsByFilterStart::setStockFilter (const char* StockFilter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockFilter_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockFilter();
    this->_StockFilter.assign(StockFilter_);
}

inline void GetStockSymbolsByFilterStart::setStockFilter (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockFilter();
    this->_StockFilter.assign(value, size);
}

inline void GetStockSymbolsByFilterStart::set_has_StockFilter () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStockSymbolsByFilterStart::clear_has_StockFilter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetStockSymbolsByFilterResult::GetStockSymbolsByFilterResult ()  :
    _StockFilterList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStockSymbolsByFilterResult::GetStockSymbolsByFilterResult (const GetStockSymbolsByFilterResult &rhs)  :
    ::asf::core::Payload(rhs),
    _StockFilterList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStockSymbolsByFilterResult::GetStockSymbolsByFilterResult (const ::sxm_stocks_main_fi_types::T_StockFilterList& StockFilterList_)  :
    _StockFilterList (StockFilterList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStockSymbolsByFilterResult::~GetStockSymbolsByFilterResult() {
}

inline GetStockSymbolsByFilterResult& GetStockSymbolsByFilterResult::operator = (const GetStockSymbolsByFilterResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStockFilterList()) {
            setStockFilterList(rhs.getStockFilterList());
        } else {
            clearStockFilterList();
        }
    }
    return *this;
}

inline bool GetStockSymbolsByFilterResult::operator == (const GetStockSymbolsByFilterResult& rhs) const {
    return (((!hasStockFilterList() && !rhs.hasStockFilterList()) || getStockFilterList() == rhs.getStockFilterList()));
}

inline bool GetStockSymbolsByFilterResult::operator != (const GetStockSymbolsByFilterResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStockSymbolsByFilterResult::operator < (const GetStockSymbolsByFilterResult& rhs) const {
    if (hasStockFilterList() || rhs.hasStockFilterList()) {
        if (getStockFilterList() < rhs.getStockFilterList()) return true;
        if (getStockFilterList() > rhs.getStockFilterList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetStockSymbolsByFilterResult::clone() {
    return new GetStockSymbolsByFilterResult(*this);
}

inline bool GetStockSymbolsByFilterResult::operator > (const GetStockSymbolsByFilterResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStockSymbolsByFilterResult::clear() {
    clearStockFilterList();
}

inline void GetStockSymbolsByFilterResult::clearStockFilterList() {
    if (hasStockFilterList()) {
         clear_has_StockFilterList();
        _StockFilterList.clear();
     }
}

inline bool GetStockSymbolsByFilterResult::hasStockFilterList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_stocks_main_fi_types::T_StockFilterList& GetStockSymbolsByFilterResult::getStockFilterList () const {
    return _StockFilterList;
}

inline ::sxm_stocks_main_fi_types::T_StockFilterList& GetStockSymbolsByFilterResult::getStockFilterListMutable () {
    set_has_StockFilterList();
    return _StockFilterList;
}

inline void GetStockSymbolsByFilterResult::setStockFilterList (const ::sxm_stocks_main_fi_types::T_StockFilterList& StockFilterList_) {
    set_has_StockFilterList();
    this->_StockFilterList = StockFilterList_;
}

inline void GetStockSymbolsByFilterResult::set_has_StockFilterList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStockSymbolsByFilterResult::clear_has_StockFilterList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetStockSymbolsByFilterErrorStructure::GetStockSymbolsByFilterErrorStructure ()  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStockSymbolsByFilterErrorStructure::GetStockSymbolsByFilterErrorStructure (const GetStockSymbolsByFilterErrorStructure &rhs)  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStockSymbolsByFilterErrorStructure::GetStockSymbolsByFilterErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "GetStockSymbolsByFilterErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStockSymbolsByFilterErrorStructure::~GetStockSymbolsByFilterErrorStructure() {
}

inline GetStockSymbolsByFilterErrorStructure& GetStockSymbolsByFilterErrorStructure::operator = (const GetStockSymbolsByFilterErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetStockSymbolsByFilterErrorStructure::operator == (const GetStockSymbolsByFilterErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetStockSymbolsByFilterErrorStructure::operator != (const GetStockSymbolsByFilterErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStockSymbolsByFilterErrorStructure::operator < (const GetStockSymbolsByFilterErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetStockSymbolsByFilterErrorStructure::operator > (const GetStockSymbolsByFilterErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStockSymbolsByFilterErrorStructure::clear() {
    clearErrorCode();
}

inline void GetStockSymbolsByFilterErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE;
     }
}

inline bool GetStockSymbolsByFilterErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes GetStockSymbolsByFilterErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetStockSymbolsByFilterErrorStructure::setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "GetStockSymbolsByFilterErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetStockSymbolsByFilterErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStockSymbolsByFilterErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetStockSymbolsByFilterError::GetStockSymbolsByFilterError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetStockSymbolsByFilterError::GetStockSymbolsByFilterError (const GetStockSymbolsByFilterError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetStockSymbolsByFilterError::~GetStockSymbolsByFilterError() {
    deleteData ();
}

inline GetStockSymbolsByFilterError& GetStockSymbolsByFilterError::operator = (const GetStockSymbolsByFilterError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetStockSymbolsByFilterError::operator == (const GetStockSymbolsByFilterError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetStockSymbolsByFilterError::operator != (const GetStockSymbolsByFilterError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStockSymbolsByFilterError::operator < (const GetStockSymbolsByFilterError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetStockSymbolsByFilterError::operator > (const GetStockSymbolsByFilterError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetStockSymbolsByFilterError::GetStockSymbolsByFilterErrorField GetStockSymbolsByFilterError::getField () const {
    return __field;
}

inline void GetStockSymbolsByFilterError::setField(GetStockSymbolsByFilterError::GetStockSymbolsByFilterErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetStockSymbolsByFilterError::clone() {
    return new GetStockSymbolsByFilterError(*this);
}

inline bool GetStockSymbolsByFilterError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetStockSymbolsByFilterErrorStructure& GetStockSymbolsByFilterError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetStockSymbolsByFilterError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetStockSymbolsByFilterErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetStockSymbolsByFilterErrorStructure& GetStockSymbolsByFilterError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetStockSymbolsByFilterError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetStockSymbolsByFilterErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetStockSymbolsByFilterErrorStructure* GetStockSymbolsByFilterError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetStockSymbolsByFilterError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetStockSymbolsByFilterErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetStockSymbolsByFilterErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetStockSymbolsByFilterError::replaceCcaErrorCode (GetStockSymbolsByFilterErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetStockSymbolsByFilterError::setCcaErrorCode (const GetStockSymbolsByFilterErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetStockSymbolsByFilterErrorStructure(value);
    }
}

inline bool GetStockSymbolsByFilterError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetStockSymbolsByFilterError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetStockSymbolsByFilterError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetStockSymbolsByFilterError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetStockSymbolsByFilterError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetStockSymbolsByFilterError::cloneData (const GetStockSymbolsByFilterError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetStockSymbolsByFilterErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetStockSymbolsByFilterErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetStockSymbolsByFilterError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetDataProviderInfoResult::GetDataProviderInfoResult ()  :
    _DataProviderInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetDataProviderInfoResult::GetDataProviderInfoResult (const GetDataProviderInfoResult &rhs)  :
    ::asf::core::Payload(rhs),
    _DataProviderInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetDataProviderInfoResult::GetDataProviderInfoResult (const ::std::string& DataProviderInfo_)  :
    _DataProviderInfo (DataProviderInfo_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DataProviderInfo_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetDataProviderInfoResult::~GetDataProviderInfoResult() {
}

inline GetDataProviderInfoResult& GetDataProviderInfoResult::operator = (const GetDataProviderInfoResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataProviderInfo()) {
            setDataProviderInfo(rhs.getDataProviderInfo());
        } else {
            clearDataProviderInfo();
        }
    }
    return *this;
}

inline bool GetDataProviderInfoResult::operator == (const GetDataProviderInfoResult& rhs) const {
    return (((!hasDataProviderInfo() && !rhs.hasDataProviderInfo()) || getDataProviderInfo() == rhs.getDataProviderInfo()));
}

inline bool GetDataProviderInfoResult::operator != (const GetDataProviderInfoResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDataProviderInfoResult::operator < (const GetDataProviderInfoResult& rhs) const {
    if (hasDataProviderInfo() || rhs.hasDataProviderInfo()) {
        if (getDataProviderInfo() < rhs.getDataProviderInfo()) return true;
        if (getDataProviderInfo() > rhs.getDataProviderInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetDataProviderInfoResult::clone() {
    return new GetDataProviderInfoResult(*this);
}

inline bool GetDataProviderInfoResult::operator > (const GetDataProviderInfoResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetDataProviderInfoResult::clear() {
    clearDataProviderInfo();
}

inline void GetDataProviderInfoResult::clearDataProviderInfo() {
    if (hasDataProviderInfo()) {
         clear_has_DataProviderInfo();
        _DataProviderInfo.clear();
     }
}

inline bool GetDataProviderInfoResult::hasDataProviderInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetDataProviderInfoResult::getDataProviderInfo () const {
    return _DataProviderInfo;
}

inline ::std::string& GetDataProviderInfoResult::getDataProviderInfoMutable () {
    set_has_DataProviderInfo();
    return _DataProviderInfo;
}

inline void GetDataProviderInfoResult::setDataProviderInfo (const ::std::string& DataProviderInfo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DataProviderInfo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DataProviderInfo();
    this->_DataProviderInfo = DataProviderInfo_;
}

inline void GetDataProviderInfoResult::setDataProviderInfo (const char* DataProviderInfo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DataProviderInfo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DataProviderInfo();
    this->_DataProviderInfo.assign(DataProviderInfo_);
}

inline void GetDataProviderInfoResult::setDataProviderInfo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DataProviderInfo();
    this->_DataProviderInfo.assign(value, size);
}

inline void GetDataProviderInfoResult::set_has_DataProviderInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetDataProviderInfoResult::clear_has_DataProviderInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetDataProviderInfoErrorStructure::GetDataProviderInfoErrorStructure ()  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetDataProviderInfoErrorStructure::GetDataProviderInfoErrorStructure (const GetDataProviderInfoErrorStructure &rhs)  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetDataProviderInfoErrorStructure::GetDataProviderInfoErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "GetDataProviderInfoErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetDataProviderInfoErrorStructure::~GetDataProviderInfoErrorStructure() {
}

inline GetDataProviderInfoErrorStructure& GetDataProviderInfoErrorStructure::operator = (const GetDataProviderInfoErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetDataProviderInfoErrorStructure::operator == (const GetDataProviderInfoErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetDataProviderInfoErrorStructure::operator != (const GetDataProviderInfoErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDataProviderInfoErrorStructure::operator < (const GetDataProviderInfoErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetDataProviderInfoErrorStructure::operator > (const GetDataProviderInfoErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetDataProviderInfoErrorStructure::clear() {
    clearErrorCode();
}

inline void GetDataProviderInfoErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE;
     }
}

inline bool GetDataProviderInfoErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes GetDataProviderInfoErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetDataProviderInfoErrorStructure::setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "GetDataProviderInfoErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetDataProviderInfoErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetDataProviderInfoErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetDataProviderInfoError::GetDataProviderInfoError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetDataProviderInfoError::GetDataProviderInfoError (const GetDataProviderInfoError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetDataProviderInfoError::~GetDataProviderInfoError() {
    deleteData ();
}

inline GetDataProviderInfoError& GetDataProviderInfoError::operator = (const GetDataProviderInfoError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetDataProviderInfoError::operator == (const GetDataProviderInfoError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetDataProviderInfoError::operator != (const GetDataProviderInfoError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDataProviderInfoError::operator < (const GetDataProviderInfoError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetDataProviderInfoError::operator > (const GetDataProviderInfoError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetDataProviderInfoError::GetDataProviderInfoErrorField GetDataProviderInfoError::getField () const {
    return __field;
}

inline void GetDataProviderInfoError::setField(GetDataProviderInfoError::GetDataProviderInfoErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetDataProviderInfoError::clone() {
    return new GetDataProviderInfoError(*this);
}

inline bool GetDataProviderInfoError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetDataProviderInfoErrorStructure& GetDataProviderInfoError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetDataProviderInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetDataProviderInfoErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetDataProviderInfoErrorStructure& GetDataProviderInfoError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetDataProviderInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetDataProviderInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetDataProviderInfoErrorStructure* GetDataProviderInfoError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetDataProviderInfoError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetDataProviderInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetDataProviderInfoErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetDataProviderInfoError::replaceCcaErrorCode (GetDataProviderInfoErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetDataProviderInfoError::setCcaErrorCode (const GetDataProviderInfoErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetDataProviderInfoErrorStructure(value);
    }
}

inline bool GetDataProviderInfoError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetDataProviderInfoError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetDataProviderInfoError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetDataProviderInfoError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetDataProviderInfoError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetDataProviderInfoError::cloneData (const GetDataProviderInfoError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetDataProviderInfoErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetDataProviderInfoErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetDataProviderInfoError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SetListsConfigStart::SetListsConfigStart ()  :
    _Config ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigStart::SetListsConfigStart (const SetListsConfigStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Config ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigStart::SetListsConfigStart (const ::sxm_main_fi_types::T_SxmListsConfig& Config_)  :
    _Config (Config_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigStart::~SetListsConfigStart() {
}

inline SetListsConfigStart& SetListsConfigStart::operator = (const SetListsConfigStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfig()) {
            setConfig(rhs.getConfig());
        } else {
            clearConfig();
        }
    }
    return *this;
}

inline bool SetListsConfigStart::operator == (const SetListsConfigStart& rhs) const {
    return (((!hasConfig() && !rhs.hasConfig()) || getConfig() == rhs.getConfig()));
}

inline bool SetListsConfigStart::operator != (const SetListsConfigStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigStart::operator < (const SetListsConfigStart& rhs) const {
    if (hasConfig() || rhs.hasConfig()) {
        if (getConfig() < rhs.getConfig()) return true;
        if (getConfig() > rhs.getConfig()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetListsConfigStart::clone() {
    return new SetListsConfigStart(*this);
}

inline bool SetListsConfigStart::operator > (const SetListsConfigStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigStart::clear() {
    clearConfig();
}

inline void SetListsConfigStart::clearConfig() {
    if (hasConfig()) {
         clear_has_Config();
        _Config.clear();
     }
}

inline bool SetListsConfigStart::hasConfig () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListsConfig& SetListsConfigStart::getConfig () const {
    return _Config;
}

inline ::sxm_main_fi_types::T_SxmListsConfig& SetListsConfigStart::getConfigMutable () {
    set_has_Config();
    return _Config;
}

inline void SetListsConfigStart::setConfig (const ::sxm_main_fi_types::T_SxmListsConfig& Config_) {
    set_has_Config();
    this->_Config = Config_;
}

inline void SetListsConfigStart::set_has_Config () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigStart::clear_has_Config () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigResult::SetListsConfigResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigResult::SetListsConfigResult (const SetListsConfigResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigResult::SetListsConfigResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigResult::~SetListsConfigResult() {
}

inline SetListsConfigResult& SetListsConfigResult::operator = (const SetListsConfigResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SetListsConfigResult::operator == (const SetListsConfigResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SetListsConfigResult::operator != (const SetListsConfigResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigResult::operator < (const SetListsConfigResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetListsConfigResult::clone() {
    return new SetListsConfigResult(*this);
}

inline bool SetListsConfigResult::operator > (const SetListsConfigResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigResult::clear() {
    clearStatus();
}

inline void SetListsConfigResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool SetListsConfigResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetListsConfigResult::getStatus () const {
    return _Status;
}

inline void SetListsConfigResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void SetListsConfigResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigErrorStructure::SetListsConfigErrorStructure ()  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigErrorStructure::SetListsConfigErrorStructure (const SetListsConfigErrorStructure &rhs)  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigErrorStructure::SetListsConfigErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "SetListsConfigErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigErrorStructure::~SetListsConfigErrorStructure() {
}

inline SetListsConfigErrorStructure& SetListsConfigErrorStructure::operator = (const SetListsConfigErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SetListsConfigErrorStructure::operator == (const SetListsConfigErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SetListsConfigErrorStructure::operator != (const SetListsConfigErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigErrorStructure::operator < (const SetListsConfigErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool SetListsConfigErrorStructure::operator > (const SetListsConfigErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigErrorStructure::clear() {
    clearErrorCode();
}

inline void SetListsConfigErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE;
     }
}

inline bool SetListsConfigErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes SetListsConfigErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void SetListsConfigErrorStructure::setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "SetListsConfigErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SetListsConfigErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigError::SetListsConfigError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SetListsConfigError::SetListsConfigError (const SetListsConfigError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SetListsConfigError::~SetListsConfigError() {
    deleteData ();
}

inline SetListsConfigError& SetListsConfigError::operator = (const SetListsConfigError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SetListsConfigError::operator == (const SetListsConfigError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SetListsConfigError::operator != (const SetListsConfigError& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigError::operator < (const SetListsConfigError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SetListsConfigError::operator > (const SetListsConfigError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SetListsConfigError::SetListsConfigErrorField SetListsConfigError::getField () const {
    return __field;
}

inline void SetListsConfigError::setField(SetListsConfigError::SetListsConfigErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SetListsConfigError::clone() {
    return new SetListsConfigError(*this);
}

inline bool SetListsConfigError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SetListsConfigErrorStructure& SetListsConfigError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetListsConfigError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SetListsConfigErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetListsConfigErrorStructure& SetListsConfigError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetListsConfigError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetListsConfigErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetListsConfigErrorStructure* SetListsConfigError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SetListsConfigError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetListsConfigErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SetListsConfigErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SetListsConfigError::replaceCcaErrorCode (SetListsConfigErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SetListsConfigError::setCcaErrorCode (const SetListsConfigErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SetListsConfigErrorStructure(value);
    }
}

inline bool SetListsConfigError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SetListsConfigError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SetListsConfigError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SetListsConfigError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SetListsConfigError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SetListsConfigError::cloneData (const SetListsConfigError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SetListsConfigErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SetListsConfigErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SetListsConfigError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetStockSymbolsByFilterPSStart::GetStockSymbolsByFilterPSStart ()  :
    _StockFilter (),
    _IsBackSpace (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStockSymbolsByFilterPSStart::GetStockSymbolsByFilterPSStart (const GetStockSymbolsByFilterPSStart &rhs)  :
    ::asf::core::Payload(rhs),
    _StockFilter (),
    _IsBackSpace (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStockSymbolsByFilterPSStart::GetStockSymbolsByFilterPSStart (const ::std::string& StockFilter_, bool IsBackSpace_)  :
    _StockFilter (StockFilter_),
    _IsBackSpace (IsBackSpace_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockFilter_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStockSymbolsByFilterPSStart::~GetStockSymbolsByFilterPSStart() {
}

inline GetStockSymbolsByFilterPSStart& GetStockSymbolsByFilterPSStart::operator = (const GetStockSymbolsByFilterPSStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStockFilter()) {
            setStockFilter(rhs.getStockFilter());
        } else {
            clearStockFilter();
        }
        if (rhs.hasIsBackSpace()) {
            setIsBackSpace(rhs.getIsBackSpace());
        } else {
            clearIsBackSpace();
        }
    }
    return *this;
}

inline bool GetStockSymbolsByFilterPSStart::operator == (const GetStockSymbolsByFilterPSStart& rhs) const {
    return (((!hasStockFilter() && !rhs.hasStockFilter()) || getStockFilter() == rhs.getStockFilter()) &&
        ((!hasIsBackSpace() && !rhs.hasIsBackSpace()) || getIsBackSpace() == rhs.getIsBackSpace()));
}

inline bool GetStockSymbolsByFilterPSStart::operator != (const GetStockSymbolsByFilterPSStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStockSymbolsByFilterPSStart::operator < (const GetStockSymbolsByFilterPSStart& rhs) const {
    if (hasStockFilter() || rhs.hasStockFilter()) {
        if (getStockFilter() < rhs.getStockFilter()) return true;
        if (getStockFilter() > rhs.getStockFilter()) return false;
    }
    if (hasIsBackSpace() || rhs.hasIsBackSpace()) {
        if (getIsBackSpace() < rhs.getIsBackSpace()) return true;
        if (getIsBackSpace() > rhs.getIsBackSpace()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetStockSymbolsByFilterPSStart::clone() {
    return new GetStockSymbolsByFilterPSStart(*this);
}

inline bool GetStockSymbolsByFilterPSStart::operator > (const GetStockSymbolsByFilterPSStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStockSymbolsByFilterPSStart::clear() {
    clearStockFilter();
    clearIsBackSpace();
}

inline void GetStockSymbolsByFilterPSStart::clearStockFilter() {
    if (hasStockFilter()) {
         clear_has_StockFilter();
        _StockFilter.clear();
     }
}

inline bool GetStockSymbolsByFilterPSStart::hasStockFilter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetStockSymbolsByFilterPSStart::getStockFilter () const {
    return _StockFilter;
}

inline ::std::string& GetStockSymbolsByFilterPSStart::getStockFilterMutable () {
    set_has_StockFilter();
    return _StockFilter;
}

inline void GetStockSymbolsByFilterPSStart::setStockFilter (const ::std::string& StockFilter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockFilter_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockFilter();
    this->_StockFilter = StockFilter_;
}

inline void GetStockSymbolsByFilterPSStart::setStockFilter (const char* StockFilter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockFilter_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockFilter();
    this->_StockFilter.assign(StockFilter_);
}

inline void GetStockSymbolsByFilterPSStart::setStockFilter (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockFilter();
    this->_StockFilter.assign(value, size);
}

inline void GetStockSymbolsByFilterPSStart::clearIsBackSpace() {
    if (hasIsBackSpace()) {
         clear_has_IsBackSpace();
        _IsBackSpace = false;
     }
}

inline bool GetStockSymbolsByFilterPSStart::hasIsBackSpace () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool GetStockSymbolsByFilterPSStart::getIsBackSpace () const {
    return _IsBackSpace;
}

inline void GetStockSymbolsByFilterPSStart::setIsBackSpace (bool IsBackSpace_) {
    set_has_IsBackSpace();
    this->_IsBackSpace = IsBackSpace_;
}

inline void GetStockSymbolsByFilterPSStart::set_has_StockFilter () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStockSymbolsByFilterPSStart::clear_has_StockFilter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetStockSymbolsByFilterPSStart::set_has_IsBackSpace () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetStockSymbolsByFilterPSStart::clear_has_IsBackSpace () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetStockSymbolsByFilterPSResult::GetStockSymbolsByFilterPSResult ()  :
    _StockFilterList (),
    _AllCharsToEnable (),
    _DisplayString (),
    _Count (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStockSymbolsByFilterPSResult::GetStockSymbolsByFilterPSResult (const GetStockSymbolsByFilterPSResult &rhs)  :
    ::asf::core::Payload(rhs),
    _StockFilterList (),
    _AllCharsToEnable (),
    _DisplayString (),
    _Count (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStockSymbolsByFilterPSResult::GetStockSymbolsByFilterPSResult (const ::sxm_stocks_main_fi_types::T_StockFilterList& StockFilterList_, const ::std::string& AllCharsToEnable_, const ::std::string& DisplayString_, uint32 Count_)  :
    _StockFilterList (StockFilterList_),
    _AllCharsToEnable (AllCharsToEnable_),
    _DisplayString (DisplayString_),
    _Count (Count_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AllCharsToEnable_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DisplayString_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStockSymbolsByFilterPSResult::~GetStockSymbolsByFilterPSResult() {
}

inline GetStockSymbolsByFilterPSResult& GetStockSymbolsByFilterPSResult::operator = (const GetStockSymbolsByFilterPSResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStockFilterList()) {
            setStockFilterList(rhs.getStockFilterList());
        } else {
            clearStockFilterList();
        }
        if (rhs.hasAllCharsToEnable()) {
            setAllCharsToEnable(rhs.getAllCharsToEnable());
        } else {
            clearAllCharsToEnable();
        }
        if (rhs.hasDisplayString()) {
            setDisplayString(rhs.getDisplayString());
        } else {
            clearDisplayString();
        }
        if (rhs.hasCount()) {
            setCount(rhs.getCount());
        } else {
            clearCount();
        }
    }
    return *this;
}

inline bool GetStockSymbolsByFilterPSResult::operator == (const GetStockSymbolsByFilterPSResult& rhs) const {
    return (((!hasStockFilterList() && !rhs.hasStockFilterList()) || getStockFilterList() == rhs.getStockFilterList()) &&
        ((!hasAllCharsToEnable() && !rhs.hasAllCharsToEnable()) || getAllCharsToEnable() == rhs.getAllCharsToEnable()) &&
        ((!hasDisplayString() && !rhs.hasDisplayString()) || getDisplayString() == rhs.getDisplayString()) &&
        ((!hasCount() && !rhs.hasCount()) || getCount() == rhs.getCount()));
}

inline bool GetStockSymbolsByFilterPSResult::operator != (const GetStockSymbolsByFilterPSResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStockSymbolsByFilterPSResult::operator < (const GetStockSymbolsByFilterPSResult& rhs) const {
    if (hasStockFilterList() || rhs.hasStockFilterList()) {
        if (getStockFilterList() < rhs.getStockFilterList()) return true;
        if (getStockFilterList() > rhs.getStockFilterList()) return false;
    }
    if (hasAllCharsToEnable() || rhs.hasAllCharsToEnable()) {
        if (getAllCharsToEnable() < rhs.getAllCharsToEnable()) return true;
        if (getAllCharsToEnable() > rhs.getAllCharsToEnable()) return false;
    }
    if (hasDisplayString() || rhs.hasDisplayString()) {
        if (getDisplayString() < rhs.getDisplayString()) return true;
        if (getDisplayString() > rhs.getDisplayString()) return false;
    }
    if (hasCount() || rhs.hasCount()) {
        if (getCount() < rhs.getCount()) return true;
        if (getCount() > rhs.getCount()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetStockSymbolsByFilterPSResult::clone() {
    return new GetStockSymbolsByFilterPSResult(*this);
}

inline bool GetStockSymbolsByFilterPSResult::operator > (const GetStockSymbolsByFilterPSResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStockSymbolsByFilterPSResult::clear() {
    clearStockFilterList();
    clearAllCharsToEnable();
    clearDisplayString();
    clearCount();
}

inline void GetStockSymbolsByFilterPSResult::clearStockFilterList() {
    if (hasStockFilterList()) {
         clear_has_StockFilterList();
        _StockFilterList.clear();
     }
}

inline bool GetStockSymbolsByFilterPSResult::hasStockFilterList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_stocks_main_fi_types::T_StockFilterList& GetStockSymbolsByFilterPSResult::getStockFilterList () const {
    return _StockFilterList;
}

inline ::sxm_stocks_main_fi_types::T_StockFilterList& GetStockSymbolsByFilterPSResult::getStockFilterListMutable () {
    set_has_StockFilterList();
    return _StockFilterList;
}

inline void GetStockSymbolsByFilterPSResult::setStockFilterList (const ::sxm_stocks_main_fi_types::T_StockFilterList& StockFilterList_) {
    set_has_StockFilterList();
    this->_StockFilterList = StockFilterList_;
}

inline void GetStockSymbolsByFilterPSResult::clearAllCharsToEnable() {
    if (hasAllCharsToEnable()) {
         clear_has_AllCharsToEnable();
        _AllCharsToEnable.clear();
     }
}

inline bool GetStockSymbolsByFilterPSResult::hasAllCharsToEnable () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& GetStockSymbolsByFilterPSResult::getAllCharsToEnable () const {
    return _AllCharsToEnable;
}

inline ::std::string& GetStockSymbolsByFilterPSResult::getAllCharsToEnableMutable () {
    set_has_AllCharsToEnable();
    return _AllCharsToEnable;
}

inline void GetStockSymbolsByFilterPSResult::setAllCharsToEnable (const ::std::string& AllCharsToEnable_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AllCharsToEnable_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AllCharsToEnable();
    this->_AllCharsToEnable = AllCharsToEnable_;
}

inline void GetStockSymbolsByFilterPSResult::setAllCharsToEnable (const char* AllCharsToEnable_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AllCharsToEnable_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AllCharsToEnable();
    this->_AllCharsToEnable.assign(AllCharsToEnable_);
}

inline void GetStockSymbolsByFilterPSResult::setAllCharsToEnable (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AllCharsToEnable();
    this->_AllCharsToEnable.assign(value, size);
}

inline void GetStockSymbolsByFilterPSResult::clearDisplayString() {
    if (hasDisplayString()) {
         clear_has_DisplayString();
        _DisplayString.clear();
     }
}

inline bool GetStockSymbolsByFilterPSResult::hasDisplayString () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& GetStockSymbolsByFilterPSResult::getDisplayString () const {
    return _DisplayString;
}

inline ::std::string& GetStockSymbolsByFilterPSResult::getDisplayStringMutable () {
    set_has_DisplayString();
    return _DisplayString;
}

inline void GetStockSymbolsByFilterPSResult::setDisplayString (const ::std::string& DisplayString_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DisplayString_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DisplayString();
    this->_DisplayString = DisplayString_;
}

inline void GetStockSymbolsByFilterPSResult::setDisplayString (const char* DisplayString_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DisplayString_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DisplayString();
    this->_DisplayString.assign(DisplayString_);
}

inline void GetStockSymbolsByFilterPSResult::setDisplayString (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DisplayString();
    this->_DisplayString.assign(value, size);
}

inline void GetStockSymbolsByFilterPSResult::clearCount() {
    if (hasCount()) {
         clear_has_Count();
        _Count = 0u;
     }
}

inline bool GetStockSymbolsByFilterPSResult::hasCount () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 GetStockSymbolsByFilterPSResult::getCount () const {
    return _Count;
}

inline void GetStockSymbolsByFilterPSResult::setCount (uint32 Count_) {
    set_has_Count();
    this->_Count = Count_;
}

inline void GetStockSymbolsByFilterPSResult::set_has_StockFilterList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStockSymbolsByFilterPSResult::clear_has_StockFilterList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetStockSymbolsByFilterPSResult::set_has_AllCharsToEnable () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetStockSymbolsByFilterPSResult::clear_has_AllCharsToEnable () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetStockSymbolsByFilterPSResult::set_has_DisplayString () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetStockSymbolsByFilterPSResult::clear_has_DisplayString () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetStockSymbolsByFilterPSResult::set_has_Count () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetStockSymbolsByFilterPSResult::clear_has_Count () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetStockSymbolsByFilterPSErrorStructure::GetStockSymbolsByFilterPSErrorStructure ()  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStockSymbolsByFilterPSErrorStructure::GetStockSymbolsByFilterPSErrorStructure (const GetStockSymbolsByFilterPSErrorStructure &rhs)  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStockSymbolsByFilterPSErrorStructure::GetStockSymbolsByFilterPSErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "GetStockSymbolsByFilterPSErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStockSymbolsByFilterPSErrorStructure::~GetStockSymbolsByFilterPSErrorStructure() {
}

inline GetStockSymbolsByFilterPSErrorStructure& GetStockSymbolsByFilterPSErrorStructure::operator = (const GetStockSymbolsByFilterPSErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetStockSymbolsByFilterPSErrorStructure::operator == (const GetStockSymbolsByFilterPSErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetStockSymbolsByFilterPSErrorStructure::operator != (const GetStockSymbolsByFilterPSErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStockSymbolsByFilterPSErrorStructure::operator < (const GetStockSymbolsByFilterPSErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetStockSymbolsByFilterPSErrorStructure::operator > (const GetStockSymbolsByFilterPSErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStockSymbolsByFilterPSErrorStructure::clear() {
    clearErrorCode();
}

inline void GetStockSymbolsByFilterPSErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE;
     }
}

inline bool GetStockSymbolsByFilterPSErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes GetStockSymbolsByFilterPSErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetStockSymbolsByFilterPSErrorStructure::setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "GetStockSymbolsByFilterPSErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetStockSymbolsByFilterPSErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStockSymbolsByFilterPSErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetStockSymbolsByFilterPSError::GetStockSymbolsByFilterPSError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetStockSymbolsByFilterPSError::GetStockSymbolsByFilterPSError (const GetStockSymbolsByFilterPSError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetStockSymbolsByFilterPSError::~GetStockSymbolsByFilterPSError() {
    deleteData ();
}

inline GetStockSymbolsByFilterPSError& GetStockSymbolsByFilterPSError::operator = (const GetStockSymbolsByFilterPSError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetStockSymbolsByFilterPSError::operator == (const GetStockSymbolsByFilterPSError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetStockSymbolsByFilterPSError::operator != (const GetStockSymbolsByFilterPSError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStockSymbolsByFilterPSError::operator < (const GetStockSymbolsByFilterPSError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetStockSymbolsByFilterPSError::operator > (const GetStockSymbolsByFilterPSError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetStockSymbolsByFilterPSError::GetStockSymbolsByFilterPSErrorField GetStockSymbolsByFilterPSError::getField () const {
    return __field;
}

inline void GetStockSymbolsByFilterPSError::setField(GetStockSymbolsByFilterPSError::GetStockSymbolsByFilterPSErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetStockSymbolsByFilterPSError::clone() {
    return new GetStockSymbolsByFilterPSError(*this);
}

inline bool GetStockSymbolsByFilterPSError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetStockSymbolsByFilterPSErrorStructure& GetStockSymbolsByFilterPSError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetStockSymbolsByFilterPSError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetStockSymbolsByFilterPSErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetStockSymbolsByFilterPSErrorStructure& GetStockSymbolsByFilterPSError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetStockSymbolsByFilterPSError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetStockSymbolsByFilterPSErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetStockSymbolsByFilterPSErrorStructure* GetStockSymbolsByFilterPSError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetStockSymbolsByFilterPSError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetStockSymbolsByFilterPSErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetStockSymbolsByFilterPSErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetStockSymbolsByFilterPSError::replaceCcaErrorCode (GetStockSymbolsByFilterPSErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetStockSymbolsByFilterPSError::setCcaErrorCode (const GetStockSymbolsByFilterPSErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetStockSymbolsByFilterPSErrorStructure(value);
    }
}

inline bool GetStockSymbolsByFilterPSError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetStockSymbolsByFilterPSError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetStockSymbolsByFilterPSError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetStockSymbolsByFilterPSError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetStockSymbolsByFilterPSError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetStockSymbolsByFilterPSError::cloneData (const GetStockSymbolsByFilterPSError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetStockSymbolsByFilterPSErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetStockSymbolsByFilterPSErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetStockSymbolsByFilterPSError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  StockStatusStatus::StockStatusStatus ()  :
    _StockStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StockStatusStatus::StockStatusStatus (const StockStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _StockStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StockStatusStatus::StockStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& StockStatus_)  :
    _StockStatus (StockStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StockStatusStatus::~StockStatusStatus() {
}

inline StockStatusStatus& StockStatusStatus::operator = (const StockStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStockStatus()) {
            setStockStatus(rhs.getStockStatus());
        } else {
            clearStockStatus();
        }
    }
    return *this;
}

inline bool StockStatusStatus::operator == (const StockStatusStatus& rhs) const {
    return (((!hasStockStatus() && !rhs.hasStockStatus()) || getStockStatus() == rhs.getStockStatus()));
}

inline bool StockStatusStatus::operator != (const StockStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool StockStatusStatus::operator < (const StockStatusStatus& rhs) const {
    if (hasStockStatus() || rhs.hasStockStatus()) {
        if (getStockStatus() < rhs.getStockStatus()) return true;
        if (getStockStatus() > rhs.getStockStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StockStatusStatus::clone() {
    return new StockStatusStatus(*this);
}

inline bool StockStatusStatus::operator > (const StockStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StockStatusStatus::clear() {
    clearStockStatus();
}

inline void StockStatusStatus::clearStockStatus() {
    if (hasStockStatus()) {
         clear_has_StockStatus();
        _StockStatus.clear();
     }
}

inline bool StockStatusStatus::hasStockStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListInfos& StockStatusStatus::getStockStatus () const {
    return _StockStatus;
}

inline ::sxm_main_fi_types::T_SxmListInfos& StockStatusStatus::getStockStatusMutable () {
    set_has_StockStatus();
    return _StockStatus;
}

inline void StockStatusStatus::setStockStatus (const ::sxm_main_fi_types::T_SxmListInfos& StockStatus_) {
    set_has_StockStatus();
    this->_StockStatus = StockStatus_;
}

inline void StockStatusStatus::set_has_StockStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void StockStatusStatus::clear_has_StockStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StockStatusErrorStructure::StockStatusErrorStructure ()  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StockStatusErrorStructure::StockStatusErrorStructure (const StockStatusErrorStructure &rhs)  :
    _ErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StockStatusErrorStructure::StockStatusErrorStructure (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "StockStatusErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StockStatusErrorStructure::~StockStatusErrorStructure() {
}

inline StockStatusErrorStructure& StockStatusErrorStructure::operator = (const StockStatusErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool StockStatusErrorStructure::operator == (const StockStatusErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool StockStatusErrorStructure::operator != (const StockStatusErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool StockStatusErrorStructure::operator < (const StockStatusErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool StockStatusErrorStructure::operator > (const StockStatusErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StockStatusErrorStructure::clear() {
    clearErrorCode();
}

inline void StockStatusErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes__STOCK_ERRORTYPE_NONE;
     }
}

inline bool StockStatusErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes StockStatusErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void StockStatusErrorStructure::setErrorCode (::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_stocks_main_fi_types::T_e8_Stock_ErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8_Stock_ErrorTypes", "ErrorCode", "StockStatusErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void StockStatusErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void StockStatusErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StockStatusError::StockStatusError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  StockStatusError::StockStatusError (const StockStatusError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  StockStatusError::~StockStatusError() {
    deleteData ();
}

inline StockStatusError& StockStatusError::operator = (const StockStatusError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool StockStatusError::operator == (const StockStatusError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool StockStatusError::operator != (const StockStatusError& rhs) const {
    return ! (*this == rhs);
}

inline bool StockStatusError::operator < (const StockStatusError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool StockStatusError::operator > (const StockStatusError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline StockStatusError::StockStatusErrorField StockStatusError::getField () const {
    return __field;
}

inline void StockStatusError::setField(StockStatusError::StockStatusErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* StockStatusError::clone() {
    return new StockStatusError(*this);
}

inline bool StockStatusError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const StockStatusErrorStructure& StockStatusError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "StockStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return StockStatusErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline StockStatusErrorStructure& StockStatusError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "StockStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new StockStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline StockStatusErrorStructure* StockStatusError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'StockStatusError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new StockStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        StockStatusErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void StockStatusError::replaceCcaErrorCode (StockStatusErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void StockStatusError::setCcaErrorCode (const StockStatusErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new StockStatusErrorStructure(value);
    }
}

inline bool StockStatusError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode StockStatusError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "StockStatusError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void StockStatusError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "StockStatusError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void StockStatusError::cloneData (const StockStatusError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new StockStatusErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new StockStatusErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void StockStatusError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus ()  :
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_)  :
    _DataServiceState (DataServiceState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::~SxmDataServiceStatusStatus() {
}

inline SxmDataServiceStatusStatus& SxmDataServiceStatusStatus::operator = (const SxmDataServiceStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataServiceState()) {
            setDataServiceState(rhs.getDataServiceState());
        } else {
            clearDataServiceState();
        }
    }
    return *this;
}

inline bool SxmDataServiceStatusStatus::operator == (const SxmDataServiceStatusStatus& rhs) const {
    return (((!hasDataServiceState() && !rhs.hasDataServiceState()) || getDataServiceState() == rhs.getDataServiceState()));
}

inline bool SxmDataServiceStatusStatus::operator != (const SxmDataServiceStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmDataServiceStatusStatus::operator < (const SxmDataServiceStatusStatus& rhs) const {
    if (hasDataServiceState() || rhs.hasDataServiceState()) {
        if (getDataServiceState() < rhs.getDataServiceState()) return true;
        if (getDataServiceState() > rhs.getDataServiceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmDataServiceStatusStatus::clone() {
    return new SxmDataServiceStatusStatus(*this);
}

inline bool SxmDataServiceStatusStatus::operator > (const SxmDataServiceStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmDataServiceStatusStatus::clear() {
    clearDataServiceState();
}

inline void SxmDataServiceStatusStatus::clearDataServiceState() {
    if (hasDataServiceState()) {
         clear_has_DataServiceState();
        _DataServiceState.clear();
     }
}

inline bool SxmDataServiceStatusStatus::hasDataServiceState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceState () const {
    return _DataServiceState;
}

inline ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceStateMutable () {
    set_has_DataServiceState();
    return _DataServiceState;
}

inline void SxmDataServiceStatusStatus::setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_) {
    set_has_DataServiceState();
    this->_DataServiceState = DataServiceState_;
}

inline void SxmDataServiceStatusStatus::set_has_DataServiceState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmDataServiceStatusStatus::clear_has_DataServiceState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeStatus::SxmListModeStatus ()  :
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeStatus::SxmListModeStatus (const SxmListModeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeStatus::SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_)  :
    _ListMode (ListMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeStatus::~SxmListModeStatus() {
}

inline SxmListModeStatus& SxmListModeStatus::operator = (const SxmListModeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
    }
    return *this;
}

inline bool SxmListModeStatus::operator == (const SxmListModeStatus& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()));
}

inline bool SxmListModeStatus::operator != (const SxmListModeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeStatus::operator < (const SxmListModeStatus& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeStatus::clone() {
    return new SxmListModeStatus(*this);
}

inline bool SxmListModeStatus::operator > (const SxmListModeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeStatus::clear() {
    clearListMode();
}

inline void SxmListModeStatus::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeStatus::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeStatus::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeStatus::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeStatus::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeSet::SxmListModeSet ()  :
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeSet::SxmListModeSet (const SxmListModeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeSet::SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_)  :
    _ListMode (ListMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeSet::~SxmListModeSet() {
}

inline SxmListModeSet& SxmListModeSet::operator = (const SxmListModeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
    }
    return *this;
}

inline bool SxmListModeSet::operator == (const SxmListModeSet& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()));
}

inline bool SxmListModeSet::operator != (const SxmListModeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeSet::operator < (const SxmListModeSet& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeSet::clone() {
    return new SxmListModeSet(*this);
}

inline bool SxmListModeSet::operator > (const SxmListModeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeSet::clear() {
    clearListMode();
}

inline void SxmListModeSet::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeSet::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeSet::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeSet::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeSet::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmStocksDataProviderInfoStatusStatus::SxmStocksDataProviderInfoStatusStatus ()  :
    _DataProviderInfoStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmStocksDataProviderInfoStatusStatus::SxmStocksDataProviderInfoStatusStatus (const SxmStocksDataProviderInfoStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DataProviderInfoStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmStocksDataProviderInfoStatusStatus::SxmStocksDataProviderInfoStatusStatus (bool DataProviderInfoStatus_)  :
    _DataProviderInfoStatus (DataProviderInfoStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmStocksDataProviderInfoStatusStatus::~SxmStocksDataProviderInfoStatusStatus() {
}

inline SxmStocksDataProviderInfoStatusStatus& SxmStocksDataProviderInfoStatusStatus::operator = (const SxmStocksDataProviderInfoStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataProviderInfoStatus()) {
            setDataProviderInfoStatus(rhs.getDataProviderInfoStatus());
        } else {
            clearDataProviderInfoStatus();
        }
    }
    return *this;
}

inline bool SxmStocksDataProviderInfoStatusStatus::operator == (const SxmStocksDataProviderInfoStatusStatus& rhs) const {
    return (((!hasDataProviderInfoStatus() && !rhs.hasDataProviderInfoStatus()) || getDataProviderInfoStatus() == rhs.getDataProviderInfoStatus()));
}

inline bool SxmStocksDataProviderInfoStatusStatus::operator != (const SxmStocksDataProviderInfoStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmStocksDataProviderInfoStatusStatus::operator < (const SxmStocksDataProviderInfoStatusStatus& rhs) const {
    if (hasDataProviderInfoStatus() || rhs.hasDataProviderInfoStatus()) {
        if (getDataProviderInfoStatus() < rhs.getDataProviderInfoStatus()) return true;
        if (getDataProviderInfoStatus() > rhs.getDataProviderInfoStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmStocksDataProviderInfoStatusStatus::clone() {
    return new SxmStocksDataProviderInfoStatusStatus(*this);
}

inline bool SxmStocksDataProviderInfoStatusStatus::operator > (const SxmStocksDataProviderInfoStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmStocksDataProviderInfoStatusStatus::clear() {
    clearDataProviderInfoStatus();
}

inline void SxmStocksDataProviderInfoStatusStatus::clearDataProviderInfoStatus() {
    if (hasDataProviderInfoStatus()) {
         clear_has_DataProviderInfoStatus();
        _DataProviderInfoStatus = false;
     }
}

inline bool SxmStocksDataProviderInfoStatusStatus::hasDataProviderInfoStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SxmStocksDataProviderInfoStatusStatus::getDataProviderInfoStatus () const {
    return _DataProviderInfoStatus;
}

inline void SxmStocksDataProviderInfoStatusStatus::setDataProviderInfoStatus (bool DataProviderInfoStatus_) {
    set_has_DataProviderInfoStatus();
    this->_DataProviderInfoStatus = DataProviderInfoStatus_;
}

inline void SxmStocksDataProviderInfoStatusStatus::set_has_DataProviderInfoStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmStocksDataProviderInfoStatusStatus::clear_has_DataProviderInfoStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace sxm_stocks_main_fi

#endif // SXM_STOCKS_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
