#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_PHONETICS_MAIN_FI_TYPES_H
#define SXM_PHONETICS_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sxm_phonetics_main_fi_types
 */

namespace sxm_phonetics_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_ChannelPhoneticsInfo;

class T_CategoryPhoneticsInfo;

class T_LeaguePhoneticsInfo;

class T_MarketPhoneticsInfo;

class T_TeamPhoneticsInfo;


/**
 * If the meaning of "T_ChannelPhoneticsInfo" isn't clear, then there should be a description here.
 */
class T_ChannelPhoneticsInfo {
public:

    /**
     * Default constructor
     */
    inline  T_ChannelPhoneticsInfo ();

    /**
     * Copy constructor
     */
    inline  T_ChannelPhoneticsInfo (const T_ChannelPhoneticsInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_ChannelPhoneticsInfo (uint32 ID_, const ::std::vector< ::std::string >& PhoneticsData_);

    /**
     * Destructor
     */
    inline  ~T_ChannelPhoneticsInfo();

    /**
     * Assignment operator
     */
    inline T_ChannelPhoneticsInfo& operator = (const T_ChannelPhoneticsInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ChannelPhoneticsInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ChannelPhoneticsInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ChannelPhoneticsInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ChannelPhoneticsInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ID"

    static const int kID = 0;

    /**
     * Clears the field "ID".
     *
     * The field will be set to its default value. The hasID()
     * method will return false.
     */
    inline void clearID();

    /**
     * Checks whether the field "ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setID()). Otherwise it will return false.
     */
    inline bool hasID () const;

    /**
     * Returns the value of the member "ID".
     *
     * ServiceID for ChannelName.
     *
     * @return The value of the field "ID"
     */
    inline uint32 getID () const;

    /**
     * Sets the value of the member "ID".
     *
     * ServiceID for ChannelName.
     *
     * @param ID The value which will be set
     */
    inline void setID (uint32 ID_);

    // API of field "PhoneticsData"

    static const int kPhoneticsData = 1;

    /**
     * Clears the field "PhoneticsData".
     *
     * The field will be set to its default value. The hasPhoneticsData()
     * method will return false.
     */
    inline void clearPhoneticsData();

    /**
     * Checks whether the field "PhoneticsData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneticsData()). Otherwise it will return false.
     */
    inline bool hasPhoneticsData () const;

    /**
     * Returns the value of the member "PhoneticsData".
     *
     * list of phonetics data available for particular ID
     *
     * @return The value of the field "PhoneticsData"
     */
    inline const ::std::vector< ::std::string >& getPhoneticsData () const;

    /**
     * Retrieves the value of the field "PhoneticsData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneticsData".
     */
    inline ::std::vector< ::std::string >& getPhoneticsDataMutable ();

    /**
     * Sets the value of the member "PhoneticsData".
     *
     * list of phonetics data available for particular ID
     *
     * @param PhoneticsData The value which will be set
     */
    inline void setPhoneticsData (const ::std::vector< ::std::string >& PhoneticsData_);

    static const T_ChannelPhoneticsInfo &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_ID ();

    inline void clear_has_ID ();

    inline void set_has_PhoneticsData ();

    inline void clear_has_PhoneticsData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ID;

    ::std::vector< ::std::string > _PhoneticsData;

};

/**
 * If the meaning of "T_CategoryPhoneticsInfo" isn't clear, then there should be a description here.
 */
class T_CategoryPhoneticsInfo {
public:

    /**
     * Default constructor
     */
    inline  T_CategoryPhoneticsInfo ();

    /**
     * Copy constructor
     */
    inline  T_CategoryPhoneticsInfo (const T_CategoryPhoneticsInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_CategoryPhoneticsInfo (uint32 ID_, const ::std::vector< ::std::string >& PhoneticsData_);

    /**
     * Destructor
     */
    inline  ~T_CategoryPhoneticsInfo();

    /**
     * Assignment operator
     */
    inline T_CategoryPhoneticsInfo& operator = (const T_CategoryPhoneticsInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CategoryPhoneticsInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CategoryPhoneticsInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CategoryPhoneticsInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CategoryPhoneticsInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ID"

    static const int kID = 0;

    /**
     * Clears the field "ID".
     *
     * The field will be set to its default value. The hasID()
     * method will return false.
     */
    inline void clearID();

    /**
     * Checks whether the field "ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setID()). Otherwise it will return false.
     */
    inline bool hasID () const;

    /**
     * Returns the value of the member "ID".
     *
     * CategoryID for CategoryName.
     *
     * @return The value of the field "ID"
     */
    inline uint32 getID () const;

    /**
     * Sets the value of the member "ID".
     *
     * CategoryID for CategoryName.
     *
     * @param ID The value which will be set
     */
    inline void setID (uint32 ID_);

    // API of field "PhoneticsData"

    static const int kPhoneticsData = 1;

    /**
     * Clears the field "PhoneticsData".
     *
     * The field will be set to its default value. The hasPhoneticsData()
     * method will return false.
     */
    inline void clearPhoneticsData();

    /**
     * Checks whether the field "PhoneticsData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneticsData()). Otherwise it will return false.
     */
    inline bool hasPhoneticsData () const;

    /**
     * Returns the value of the member "PhoneticsData".
     *
     * list of phonetics data available for particular ID
     *
     * @return The value of the field "PhoneticsData"
     */
    inline const ::std::vector< ::std::string >& getPhoneticsData () const;

    /**
     * Retrieves the value of the field "PhoneticsData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneticsData".
     */
    inline ::std::vector< ::std::string >& getPhoneticsDataMutable ();

    /**
     * Sets the value of the member "PhoneticsData".
     *
     * list of phonetics data available for particular ID
     *
     * @param PhoneticsData The value which will be set
     */
    inline void setPhoneticsData (const ::std::vector< ::std::string >& PhoneticsData_);

    static const T_CategoryPhoneticsInfo &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_ID ();

    inline void clear_has_ID ();

    inline void set_has_PhoneticsData ();

    inline void clear_has_PhoneticsData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ID;

    ::std::vector< ::std::string > _PhoneticsData;

};

/**
 * If the meaning of "T_LeaguePhoneticsInfo" isn't clear, then there should be a description here.
 */
class T_LeaguePhoneticsInfo {
public:

    /**
     * Default constructor
     */
    inline  T_LeaguePhoneticsInfo ();

    /**
     * Copy constructor
     */
    inline  T_LeaguePhoneticsInfo (const T_LeaguePhoneticsInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_LeaguePhoneticsInfo (uint32 ID_, const ::std::vector< ::std::string >& PhoneticsData_);

    /**
     * Destructor
     */
    inline  ~T_LeaguePhoneticsInfo();

    /**
     * Assignment operator
     */
    inline T_LeaguePhoneticsInfo& operator = (const T_LeaguePhoneticsInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_LeaguePhoneticsInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_LeaguePhoneticsInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_LeaguePhoneticsInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_LeaguePhoneticsInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ID"

    static const int kID = 0;

    /**
     * Clears the field "ID".
     *
     * The field will be set to its default value. The hasID()
     * method will return false.
     */
    inline void clearID();

    /**
     * Checks whether the field "ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setID()). Otherwise it will return false.
     */
    inline bool hasID () const;

    /**
     * Returns the value of the member "ID".
     *
     * LeagueID for LeagueName.
     *
     * @return The value of the field "ID"
     */
    inline uint32 getID () const;

    /**
     * Sets the value of the member "ID".
     *
     * LeagueID for LeagueName.
     *
     * @param ID The value which will be set
     */
    inline void setID (uint32 ID_);

    // API of field "PhoneticsData"

    static const int kPhoneticsData = 1;

    /**
     * Clears the field "PhoneticsData".
     *
     * The field will be set to its default value. The hasPhoneticsData()
     * method will return false.
     */
    inline void clearPhoneticsData();

    /**
     * Checks whether the field "PhoneticsData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneticsData()). Otherwise it will return false.
     */
    inline bool hasPhoneticsData () const;

    /**
     * Returns the value of the member "PhoneticsData".
     *
     * list of phonetics data available for particular ID
     *
     * @return The value of the field "PhoneticsData"
     */
    inline const ::std::vector< ::std::string >& getPhoneticsData () const;

    /**
     * Retrieves the value of the field "PhoneticsData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneticsData".
     */
    inline ::std::vector< ::std::string >& getPhoneticsDataMutable ();

    /**
     * Sets the value of the member "PhoneticsData".
     *
     * list of phonetics data available for particular ID
     *
     * @param PhoneticsData The value which will be set
     */
    inline void setPhoneticsData (const ::std::vector< ::std::string >& PhoneticsData_);

    static const T_LeaguePhoneticsInfo &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_ID ();

    inline void clear_has_ID ();

    inline void set_has_PhoneticsData ();

    inline void clear_has_PhoneticsData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ID;

    ::std::vector< ::std::string > _PhoneticsData;

};

/**
 * If the meaning of "T_MarketPhoneticsInfo" isn't clear, then there should be a description here.
 */
class T_MarketPhoneticsInfo {
public:

    /**
     * Default constructor
     */
    inline  T_MarketPhoneticsInfo ();

    /**
     * Copy constructor
     */
    inline  T_MarketPhoneticsInfo (const T_MarketPhoneticsInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_MarketPhoneticsInfo (const ::std::string& ID_, const ::std::vector< ::std::string >& PhoneticsData_);

    /**
     * Destructor
     */
    inline  ~T_MarketPhoneticsInfo();

    /**
     * Assignment operator
     */
    inline T_MarketPhoneticsInfo& operator = (const T_MarketPhoneticsInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MarketPhoneticsInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MarketPhoneticsInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MarketPhoneticsInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MarketPhoneticsInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ID"

    static const int kID = 0;

    /**
     * Clears the field "ID".
     *
     * The field will be set to its default value. The hasID()
     * method will return false.
     */
    inline void clearID();

    /**
     * Checks whether the field "ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setID()). Otherwise it will return false.
     */
    inline bool hasID () const;

    /**
     * Returns the value of the member "ID".
     *
     * Market ID for Market Name.
     *
     * @return The value of the field "ID"
     */
    inline const ::std::string& getID () const;

    /**
     * Retrieves the value of the field "ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ID".
     */
    inline ::std::string& getIDMutable ();

    /**
     * Sets the value of the member "ID".
     *
     * Market ID for Market Name.
     *
     * @param ID The value which will be set
     */
    inline void setID (const ::std::string& ID_);

    /**
     * Sets the value of the member "ID".
     *
     * Market ID for Market Name.
     *
     * @param ID The value which will be set
     */
    inline void setID (const char* ID_);

    /**
     * Sets the value of the member "ID".
     *
     * Market ID for Market Name.
     *
     * @param ID The value which will be set
     */
    inline void setID (const char* value, size_t size);

    // API of field "PhoneticsData"

    static const int kPhoneticsData = 1;

    /**
     * Clears the field "PhoneticsData".
     *
     * The field will be set to its default value. The hasPhoneticsData()
     * method will return false.
     */
    inline void clearPhoneticsData();

    /**
     * Checks whether the field "PhoneticsData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneticsData()). Otherwise it will return false.
     */
    inline bool hasPhoneticsData () const;

    /**
     * Returns the value of the member "PhoneticsData".
     *
     * list of phonetics data available for particular ID
     *
     * @return The value of the field "PhoneticsData"
     */
    inline const ::std::vector< ::std::string >& getPhoneticsData () const;

    /**
     * Retrieves the value of the field "PhoneticsData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneticsData".
     */
    inline ::std::vector< ::std::string >& getPhoneticsDataMutable ();

    /**
     * Sets the value of the member "PhoneticsData".
     *
     * list of phonetics data available for particular ID
     *
     * @param PhoneticsData The value which will be set
     */
    inline void setPhoneticsData (const ::std::vector< ::std::string >& PhoneticsData_);

    static const T_MarketPhoneticsInfo &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_ID ();

    inline void clear_has_ID ();

    inline void set_has_PhoneticsData ();

    inline void clear_has_PhoneticsData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _ID;

    ::std::vector< ::std::string > _PhoneticsData;

};

/**
 * If the meaning of "T_TeamPhoneticsInfo" isn't clear, then there should be a description here.
 */
class T_TeamPhoneticsInfo {
public:

    /**
     * Default constructor
     */
    inline  T_TeamPhoneticsInfo ();

    /**
     * Copy constructor
     */
    inline  T_TeamPhoneticsInfo (const T_TeamPhoneticsInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_TeamPhoneticsInfo (uint32 ID_, const ::std::vector< uint8 >& LeagueID_, const ::std::vector< ::std::string >& PhoneticsData_);

    /**
     * Destructor
     */
    inline  ~T_TeamPhoneticsInfo();

    /**
     * Assignment operator
     */
    inline T_TeamPhoneticsInfo& operator = (const T_TeamPhoneticsInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TeamPhoneticsInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TeamPhoneticsInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TeamPhoneticsInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TeamPhoneticsInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ID"

    static const int kID = 0;

    /**
     * Clears the field "ID".
     *
     * The field will be set to its default value. The hasID()
     * method will return false.
     */
    inline void clearID();

    /**
     * Checks whether the field "ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setID()). Otherwise it will return false.
     */
    inline bool hasID () const;

    /**
     * Returns the value of the member "ID".
     *
     * Team ID for Team Name.
     *
     * @return The value of the field "ID"
     */
    inline uint32 getID () const;

    /**
     * Sets the value of the member "ID".
     *
     * Team ID for Team Name.
     *
     * @param ID The value which will be set
     */
    inline void setID (uint32 ID_);

    // API of field "LeagueID"

    static const int kLeagueID = 1;

    /**
     * Clears the field "LeagueID".
     *
     * The field will be set to its default value. The hasLeagueID()
     * method will return false.
     */
    inline void clearLeagueID();

    /**
     * Checks whether the field "LeagueID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueID()). Otherwise it will return false.
     */
    inline bool hasLeagueID () const;

    /**
     * Returns the value of the member "LeagueID".
     *
     * list of league ids where this team belongs to
     *
     * @return The value of the field "LeagueID"
     */
    inline const ::std::vector< uint8 >& getLeagueID () const;

    /**
     * Retrieves the value of the field "LeagueID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LeagueID".
     */
    inline ::std::vector< uint8 >& getLeagueIDMutable ();

    /**
     * Sets the value of the member "LeagueID".
     *
     * list of league ids where this team belongs to
     *
     * @param LeagueID The value which will be set
     */
    inline void setLeagueID (const ::std::vector< uint8 >& LeagueID_);

    // API of field "PhoneticsData"

    static const int kPhoneticsData = 2;

    /**
     * Clears the field "PhoneticsData".
     *
     * The field will be set to its default value. The hasPhoneticsData()
     * method will return false.
     */
    inline void clearPhoneticsData();

    /**
     * Checks whether the field "PhoneticsData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneticsData()). Otherwise it will return false.
     */
    inline bool hasPhoneticsData () const;

    /**
     * Returns the value of the member "PhoneticsData".
     *
     * list of phonetics data available for particular ID
     *
     * @return The value of the field "PhoneticsData"
     */
    inline const ::std::vector< ::std::string >& getPhoneticsData () const;

    /**
     * Retrieves the value of the field "PhoneticsData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneticsData".
     */
    inline ::std::vector< ::std::string >& getPhoneticsDataMutable ();

    /**
     * Sets the value of the member "PhoneticsData".
     *
     * list of phonetics data available for particular ID
     *
     * @param PhoneticsData The value which will be set
     */
    inline void setPhoneticsData (const ::std::vector< ::std::string >& PhoneticsData_);

    static const T_TeamPhoneticsInfo &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_ID ();

    inline void clear_has_ID ();

    inline void set_has_LeagueID ();

    inline void clear_has_LeagueID ();

    inline void set_has_PhoneticsData ();

    inline void clear_has_PhoneticsData ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _ID;

    ::std::vector< uint8 > _LeagueID;

    ::std::vector< ::std::string > _PhoneticsData;

};

inline  T_ChannelPhoneticsInfo::T_ChannelPhoneticsInfo ()  :
    _ID (0u),
    _PhoneticsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ChannelPhoneticsInfo::T_ChannelPhoneticsInfo (const T_ChannelPhoneticsInfo &rhs)  :
    _ID (0u),
    _PhoneticsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ChannelPhoneticsInfo::T_ChannelPhoneticsInfo (uint32 ID_, const ::std::vector< ::std::string >& PhoneticsData_)  :
    _ID (ID_),
    _PhoneticsData (PhoneticsData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ChannelPhoneticsInfo::~T_ChannelPhoneticsInfo() {
}

inline T_ChannelPhoneticsInfo& T_ChannelPhoneticsInfo::operator = (const T_ChannelPhoneticsInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasID()) {
            setID(rhs.getID());
        } else {
            clearID();
        }
        if (rhs.hasPhoneticsData()) {
            setPhoneticsData(rhs.getPhoneticsData());
        } else {
            clearPhoneticsData();
        }
    }
    return *this;
}

inline bool T_ChannelPhoneticsInfo::operator == (const T_ChannelPhoneticsInfo& rhs) const {
    return (((!hasID() && !rhs.hasID()) || getID() == rhs.getID()) &&
        ((!hasPhoneticsData() && !rhs.hasPhoneticsData()) || getPhoneticsData() == rhs.getPhoneticsData()));
}

inline bool T_ChannelPhoneticsInfo::operator != (const T_ChannelPhoneticsInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ChannelPhoneticsInfo::operator < (const T_ChannelPhoneticsInfo& rhs) const {
    if (hasID() || rhs.hasID()) {
        if (getID() < rhs.getID()) return true;
        if (getID() > rhs.getID()) return false;
    }
    if (hasPhoneticsData() || rhs.hasPhoneticsData()) {
        if (getPhoneticsData() < rhs.getPhoneticsData()) return true;
        if (getPhoneticsData() > rhs.getPhoneticsData()) return false;
    }
    return false;
}

inline bool T_ChannelPhoneticsInfo::operator > (const T_ChannelPhoneticsInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ChannelPhoneticsInfo::clear() {
    clearID();
    clearPhoneticsData();
}

inline void T_ChannelPhoneticsInfo::clearID() {
    if (hasID()) {
         clear_has_ID();
        _ID = 0u;
     }
}

inline bool T_ChannelPhoneticsInfo::hasID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_ChannelPhoneticsInfo::getID () const {
    return _ID;
}

inline void T_ChannelPhoneticsInfo::setID (uint32 ID_) {
    set_has_ID();
    this->_ID = ID_;
}

inline void T_ChannelPhoneticsInfo::clearPhoneticsData() {
    if (hasPhoneticsData()) {
         clear_has_PhoneticsData();
        _PhoneticsData.clear();
     }
}

inline bool T_ChannelPhoneticsInfo::hasPhoneticsData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& T_ChannelPhoneticsInfo::getPhoneticsData () const {
    return _PhoneticsData;
}

inline ::std::vector< ::std::string >& T_ChannelPhoneticsInfo::getPhoneticsDataMutable () {
    set_has_PhoneticsData();
    return _PhoneticsData;
}

inline void T_ChannelPhoneticsInfo::setPhoneticsData (const ::std::vector< ::std::string >& PhoneticsData_) {
    set_has_PhoneticsData();
    this->_PhoneticsData = PhoneticsData_;
}

inline void T_ChannelPhoneticsInfo::set_has_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ChannelPhoneticsInfo::clear_has_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ChannelPhoneticsInfo::set_has_PhoneticsData () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ChannelPhoneticsInfo::clear_has_PhoneticsData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_CategoryPhoneticsInfo::T_CategoryPhoneticsInfo ()  :
    _ID (0u),
    _PhoneticsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CategoryPhoneticsInfo::T_CategoryPhoneticsInfo (const T_CategoryPhoneticsInfo &rhs)  :
    _ID (0u),
    _PhoneticsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CategoryPhoneticsInfo::T_CategoryPhoneticsInfo (uint32 ID_, const ::std::vector< ::std::string >& PhoneticsData_)  :
    _ID (ID_),
    _PhoneticsData (PhoneticsData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CategoryPhoneticsInfo::~T_CategoryPhoneticsInfo() {
}

inline T_CategoryPhoneticsInfo& T_CategoryPhoneticsInfo::operator = (const T_CategoryPhoneticsInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasID()) {
            setID(rhs.getID());
        } else {
            clearID();
        }
        if (rhs.hasPhoneticsData()) {
            setPhoneticsData(rhs.getPhoneticsData());
        } else {
            clearPhoneticsData();
        }
    }
    return *this;
}

inline bool T_CategoryPhoneticsInfo::operator == (const T_CategoryPhoneticsInfo& rhs) const {
    return (((!hasID() && !rhs.hasID()) || getID() == rhs.getID()) &&
        ((!hasPhoneticsData() && !rhs.hasPhoneticsData()) || getPhoneticsData() == rhs.getPhoneticsData()));
}

inline bool T_CategoryPhoneticsInfo::operator != (const T_CategoryPhoneticsInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CategoryPhoneticsInfo::operator < (const T_CategoryPhoneticsInfo& rhs) const {
    if (hasID() || rhs.hasID()) {
        if (getID() < rhs.getID()) return true;
        if (getID() > rhs.getID()) return false;
    }
    if (hasPhoneticsData() || rhs.hasPhoneticsData()) {
        if (getPhoneticsData() < rhs.getPhoneticsData()) return true;
        if (getPhoneticsData() > rhs.getPhoneticsData()) return false;
    }
    return false;
}

inline bool T_CategoryPhoneticsInfo::operator > (const T_CategoryPhoneticsInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CategoryPhoneticsInfo::clear() {
    clearID();
    clearPhoneticsData();
}

inline void T_CategoryPhoneticsInfo::clearID() {
    if (hasID()) {
         clear_has_ID();
        _ID = 0u;
     }
}

inline bool T_CategoryPhoneticsInfo::hasID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_CategoryPhoneticsInfo::getID () const {
    return _ID;
}

inline void T_CategoryPhoneticsInfo::setID (uint32 ID_) {
    set_has_ID();
    this->_ID = ID_;
}

inline void T_CategoryPhoneticsInfo::clearPhoneticsData() {
    if (hasPhoneticsData()) {
         clear_has_PhoneticsData();
        _PhoneticsData.clear();
     }
}

inline bool T_CategoryPhoneticsInfo::hasPhoneticsData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& T_CategoryPhoneticsInfo::getPhoneticsData () const {
    return _PhoneticsData;
}

inline ::std::vector< ::std::string >& T_CategoryPhoneticsInfo::getPhoneticsDataMutable () {
    set_has_PhoneticsData();
    return _PhoneticsData;
}

inline void T_CategoryPhoneticsInfo::setPhoneticsData (const ::std::vector< ::std::string >& PhoneticsData_) {
    set_has_PhoneticsData();
    this->_PhoneticsData = PhoneticsData_;
}

inline void T_CategoryPhoneticsInfo::set_has_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CategoryPhoneticsInfo::clear_has_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CategoryPhoneticsInfo::set_has_PhoneticsData () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CategoryPhoneticsInfo::clear_has_PhoneticsData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_LeaguePhoneticsInfo::T_LeaguePhoneticsInfo ()  :
    _ID (0u),
    _PhoneticsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_LeaguePhoneticsInfo::T_LeaguePhoneticsInfo (const T_LeaguePhoneticsInfo &rhs)  :
    _ID (0u),
    _PhoneticsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_LeaguePhoneticsInfo::T_LeaguePhoneticsInfo (uint32 ID_, const ::std::vector< ::std::string >& PhoneticsData_)  :
    _ID (ID_),
    _PhoneticsData (PhoneticsData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_LeaguePhoneticsInfo::~T_LeaguePhoneticsInfo() {
}

inline T_LeaguePhoneticsInfo& T_LeaguePhoneticsInfo::operator = (const T_LeaguePhoneticsInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasID()) {
            setID(rhs.getID());
        } else {
            clearID();
        }
        if (rhs.hasPhoneticsData()) {
            setPhoneticsData(rhs.getPhoneticsData());
        } else {
            clearPhoneticsData();
        }
    }
    return *this;
}

inline bool T_LeaguePhoneticsInfo::operator == (const T_LeaguePhoneticsInfo& rhs) const {
    return (((!hasID() && !rhs.hasID()) || getID() == rhs.getID()) &&
        ((!hasPhoneticsData() && !rhs.hasPhoneticsData()) || getPhoneticsData() == rhs.getPhoneticsData()));
}

inline bool T_LeaguePhoneticsInfo::operator != (const T_LeaguePhoneticsInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_LeaguePhoneticsInfo::operator < (const T_LeaguePhoneticsInfo& rhs) const {
    if (hasID() || rhs.hasID()) {
        if (getID() < rhs.getID()) return true;
        if (getID() > rhs.getID()) return false;
    }
    if (hasPhoneticsData() || rhs.hasPhoneticsData()) {
        if (getPhoneticsData() < rhs.getPhoneticsData()) return true;
        if (getPhoneticsData() > rhs.getPhoneticsData()) return false;
    }
    return false;
}

inline bool T_LeaguePhoneticsInfo::operator > (const T_LeaguePhoneticsInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_LeaguePhoneticsInfo::clear() {
    clearID();
    clearPhoneticsData();
}

inline void T_LeaguePhoneticsInfo::clearID() {
    if (hasID()) {
         clear_has_ID();
        _ID = 0u;
     }
}

inline bool T_LeaguePhoneticsInfo::hasID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_LeaguePhoneticsInfo::getID () const {
    return _ID;
}

inline void T_LeaguePhoneticsInfo::setID (uint32 ID_) {
    set_has_ID();
    this->_ID = ID_;
}

inline void T_LeaguePhoneticsInfo::clearPhoneticsData() {
    if (hasPhoneticsData()) {
         clear_has_PhoneticsData();
        _PhoneticsData.clear();
     }
}

inline bool T_LeaguePhoneticsInfo::hasPhoneticsData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& T_LeaguePhoneticsInfo::getPhoneticsData () const {
    return _PhoneticsData;
}

inline ::std::vector< ::std::string >& T_LeaguePhoneticsInfo::getPhoneticsDataMutable () {
    set_has_PhoneticsData();
    return _PhoneticsData;
}

inline void T_LeaguePhoneticsInfo::setPhoneticsData (const ::std::vector< ::std::string >& PhoneticsData_) {
    set_has_PhoneticsData();
    this->_PhoneticsData = PhoneticsData_;
}

inline void T_LeaguePhoneticsInfo::set_has_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_LeaguePhoneticsInfo::clear_has_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_LeaguePhoneticsInfo::set_has_PhoneticsData () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_LeaguePhoneticsInfo::clear_has_PhoneticsData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_MarketPhoneticsInfo::T_MarketPhoneticsInfo ()  :
    _ID (),
    _PhoneticsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MarketPhoneticsInfo::T_MarketPhoneticsInfo (const T_MarketPhoneticsInfo &rhs)  :
    _ID (),
    _PhoneticsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MarketPhoneticsInfo::T_MarketPhoneticsInfo (const ::std::string& ID_, const ::std::vector< ::std::string >& PhoneticsData_)  :
    _ID (ID_),
    _PhoneticsData (PhoneticsData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ID_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MarketPhoneticsInfo::~T_MarketPhoneticsInfo() {
}

inline T_MarketPhoneticsInfo& T_MarketPhoneticsInfo::operator = (const T_MarketPhoneticsInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasID()) {
            setID(rhs.getID());
        } else {
            clearID();
        }
        if (rhs.hasPhoneticsData()) {
            setPhoneticsData(rhs.getPhoneticsData());
        } else {
            clearPhoneticsData();
        }
    }
    return *this;
}

inline bool T_MarketPhoneticsInfo::operator == (const T_MarketPhoneticsInfo& rhs) const {
    return (((!hasID() && !rhs.hasID()) || getID() == rhs.getID()) &&
        ((!hasPhoneticsData() && !rhs.hasPhoneticsData()) || getPhoneticsData() == rhs.getPhoneticsData()));
}

inline bool T_MarketPhoneticsInfo::operator != (const T_MarketPhoneticsInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MarketPhoneticsInfo::operator < (const T_MarketPhoneticsInfo& rhs) const {
    if (hasID() || rhs.hasID()) {
        if (getID() < rhs.getID()) return true;
        if (getID() > rhs.getID()) return false;
    }
    if (hasPhoneticsData() || rhs.hasPhoneticsData()) {
        if (getPhoneticsData() < rhs.getPhoneticsData()) return true;
        if (getPhoneticsData() > rhs.getPhoneticsData()) return false;
    }
    return false;
}

inline bool T_MarketPhoneticsInfo::operator > (const T_MarketPhoneticsInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MarketPhoneticsInfo::clear() {
    clearID();
    clearPhoneticsData();
}

inline void T_MarketPhoneticsInfo::clearID() {
    if (hasID()) {
         clear_has_ID();
        _ID.clear();
     }
}

inline bool T_MarketPhoneticsInfo::hasID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_MarketPhoneticsInfo::getID () const {
    return _ID;
}

inline ::std::string& T_MarketPhoneticsInfo::getIDMutable () {
    set_has_ID();
    return _ID;
}

inline void T_MarketPhoneticsInfo::setID (const ::std::string& ID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ID();
    this->_ID = ID_;
}

inline void T_MarketPhoneticsInfo::setID (const char* ID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ID();
    this->_ID.assign(ID_);
}

inline void T_MarketPhoneticsInfo::setID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ID();
    this->_ID.assign(value, size);
}

inline void T_MarketPhoneticsInfo::clearPhoneticsData() {
    if (hasPhoneticsData()) {
         clear_has_PhoneticsData();
        _PhoneticsData.clear();
     }
}

inline bool T_MarketPhoneticsInfo::hasPhoneticsData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& T_MarketPhoneticsInfo::getPhoneticsData () const {
    return _PhoneticsData;
}

inline ::std::vector< ::std::string >& T_MarketPhoneticsInfo::getPhoneticsDataMutable () {
    set_has_PhoneticsData();
    return _PhoneticsData;
}

inline void T_MarketPhoneticsInfo::setPhoneticsData (const ::std::vector< ::std::string >& PhoneticsData_) {
    set_has_PhoneticsData();
    this->_PhoneticsData = PhoneticsData_;
}

inline void T_MarketPhoneticsInfo::set_has_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MarketPhoneticsInfo::clear_has_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MarketPhoneticsInfo::set_has_PhoneticsData () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MarketPhoneticsInfo::clear_has_PhoneticsData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TeamPhoneticsInfo::T_TeamPhoneticsInfo ()  :
    _ID (0u),
    _LeagueID (),
    _PhoneticsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TeamPhoneticsInfo::T_TeamPhoneticsInfo (const T_TeamPhoneticsInfo &rhs)  :
    _ID (0u),
    _LeagueID (),
    _PhoneticsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TeamPhoneticsInfo::T_TeamPhoneticsInfo (uint32 ID_, const ::std::vector< uint8 >& LeagueID_, const ::std::vector< ::std::string >& PhoneticsData_)  :
    _ID (ID_),
    _LeagueID (LeagueID_),
    _PhoneticsData (PhoneticsData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TeamPhoneticsInfo::~T_TeamPhoneticsInfo() {
}

inline T_TeamPhoneticsInfo& T_TeamPhoneticsInfo::operator = (const T_TeamPhoneticsInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasID()) {
            setID(rhs.getID());
        } else {
            clearID();
        }
        if (rhs.hasLeagueID()) {
            setLeagueID(rhs.getLeagueID());
        } else {
            clearLeagueID();
        }
        if (rhs.hasPhoneticsData()) {
            setPhoneticsData(rhs.getPhoneticsData());
        } else {
            clearPhoneticsData();
        }
    }
    return *this;
}

inline bool T_TeamPhoneticsInfo::operator == (const T_TeamPhoneticsInfo& rhs) const {
    return (((!hasID() && !rhs.hasID()) || getID() == rhs.getID()) &&
        ((!hasLeagueID() && !rhs.hasLeagueID()) || getLeagueID() == rhs.getLeagueID()) &&
        ((!hasPhoneticsData() && !rhs.hasPhoneticsData()) || getPhoneticsData() == rhs.getPhoneticsData()));
}

inline bool T_TeamPhoneticsInfo::operator != (const T_TeamPhoneticsInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TeamPhoneticsInfo::operator < (const T_TeamPhoneticsInfo& rhs) const {
    if (hasID() || rhs.hasID()) {
        if (getID() < rhs.getID()) return true;
        if (getID() > rhs.getID()) return false;
    }
    if (hasLeagueID() || rhs.hasLeagueID()) {
        if (getLeagueID() < rhs.getLeagueID()) return true;
        if (getLeagueID() > rhs.getLeagueID()) return false;
    }
    if (hasPhoneticsData() || rhs.hasPhoneticsData()) {
        if (getPhoneticsData() < rhs.getPhoneticsData()) return true;
        if (getPhoneticsData() > rhs.getPhoneticsData()) return false;
    }
    return false;
}

inline bool T_TeamPhoneticsInfo::operator > (const T_TeamPhoneticsInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TeamPhoneticsInfo::clear() {
    clearID();
    clearLeagueID();
    clearPhoneticsData();
}

inline void T_TeamPhoneticsInfo::clearID() {
    if (hasID()) {
         clear_has_ID();
        _ID = 0u;
     }
}

inline bool T_TeamPhoneticsInfo::hasID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_TeamPhoneticsInfo::getID () const {
    return _ID;
}

inline void T_TeamPhoneticsInfo::setID (uint32 ID_) {
    set_has_ID();
    this->_ID = ID_;
}

inline void T_TeamPhoneticsInfo::clearLeagueID() {
    if (hasLeagueID()) {
         clear_has_LeagueID();
        _LeagueID.clear();
     }
}

inline bool T_TeamPhoneticsInfo::hasLeagueID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& T_TeamPhoneticsInfo::getLeagueID () const {
    return _LeagueID;
}

inline ::std::vector< uint8 >& T_TeamPhoneticsInfo::getLeagueIDMutable () {
    set_has_LeagueID();
    return _LeagueID;
}

inline void T_TeamPhoneticsInfo::setLeagueID (const ::std::vector< uint8 >& LeagueID_) {
    set_has_LeagueID();
    this->_LeagueID = LeagueID_;
}

inline void T_TeamPhoneticsInfo::clearPhoneticsData() {
    if (hasPhoneticsData()) {
         clear_has_PhoneticsData();
        _PhoneticsData.clear();
     }
}

inline bool T_TeamPhoneticsInfo::hasPhoneticsData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< ::std::string >& T_TeamPhoneticsInfo::getPhoneticsData () const {
    return _PhoneticsData;
}

inline ::std::vector< ::std::string >& T_TeamPhoneticsInfo::getPhoneticsDataMutable () {
    set_has_PhoneticsData();
    return _PhoneticsData;
}

inline void T_TeamPhoneticsInfo::setPhoneticsData (const ::std::vector< ::std::string >& PhoneticsData_) {
    set_has_PhoneticsData();
    this->_PhoneticsData = PhoneticsData_;
}

inline void T_TeamPhoneticsInfo::set_has_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TeamPhoneticsInfo::clear_has_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TeamPhoneticsInfo::set_has_LeagueID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TeamPhoneticsInfo::clear_has_LeagueID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TeamPhoneticsInfo::set_has_PhoneticsData () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TeamPhoneticsInfo::clear_has_PhoneticsData () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace sxm_phonetics_main_fi_types

#endif // SXM_PHONETICS_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
