/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_PHONETICS_MAIN_FIPROXY_H
#define SXM_PHONETICS_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "sxm_phonetics_main_fi.h"

namespace sxm_phonetics_main_fi {

class Sxm_phonetics_main_fiProxy;

class GetPhoneticsDataCallbackIF {
public:
    virtual ~GetPhoneticsDataCallbackIF() {}

    virtual void onGetPhoneticsDataError(const ::boost::shared_ptr< Sxm_phonetics_main_fiProxy >& proxy, const ::boost::shared_ptr< GetPhoneticsDataError >& error) = 0;

    virtual void onGetPhoneticsDataResult(const ::boost::shared_ptr< Sxm_phonetics_main_fiProxy >& proxy, const ::boost::shared_ptr< GetPhoneticsDataResult >& result) = 0;
};

class PhoneticsUpdateCallbackIF {
public:
    virtual ~PhoneticsUpdateCallbackIF() {}

    virtual void onPhoneticsUpdateError(const ::boost::shared_ptr< Sxm_phonetics_main_fiProxy >& proxy, const ::boost::shared_ptr< PhoneticsUpdateError >& error) = 0;

    virtual void onPhoneticsUpdateStatus(const ::boost::shared_ptr< Sxm_phonetics_main_fiProxy >& proxy, const ::boost::shared_ptr< PhoneticsUpdateStatus >& status) = 0;
};

class Sxm_phonetics_main_fiProxyCallback;

/**
 * Sxm_phonetics_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'sxm_phonetics_main_fi' (specified in file
 * sxm_phonetics_main_fi.xml).
 *
 * CCA Functional Interface 'sxm_phonetics_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Phonetics
 *
 * Version: $Revision:   0.1  $
 *
 * Author: Narasimhulu Kavadapu (Phonetics)
 *
 * Date: $Date:   AUG 21 2015  12:00 PM  $
 *
 * Department: ECV
 *
 * Title: sxm_phonetics_main_fi
 *
 * <b>Description of 'sxm_phonetics_main_fi':</b>
 *
 * RBEI
 */
class Sxm_phonetics_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Sxm_phonetics_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_phonetics_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_phonetics_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_phonetics_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_phonetics_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Sxm_phonetics_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Sxm_phonetics_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Sxm_phonetics_main_fiProxy();

    // Method 'GetPhoneticsData'

    /**
     * Call the method 'GetPhoneticsData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetPhoneticsData'</b>:
     *
     * method to get Phonetics Data for Channels, Categories, Markets, Teams and Leagues
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param PhoneticsType Type of the Phonetics Data required. Available types are defined in T_e8PhoneticsType.
     * Multiple types can be sent using bitwise OR operator.
     *
     * @param LanguageType Type of Language in which the Phonetics data is required. Available types are defined in T_e8LanguageType.
     * Multiple types can be sent using bitwise OR operator.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPhoneticsDataStart(GetPhoneticsDataCallbackIF& cb, uint8 phoneticsType, uint8 languageType);

    // Property 'PhoneticsUpdate'

    /**
     * Notify on the property 'PhoneticsUpdate'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'PhoneticsUpdate'</b>:
     *
     * Property to inform updates for phonetics data
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPhoneticsUpdateUpReg(PhoneticsUpdateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'PhoneticsUpdate'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'PhoneticsUpdate'</b>:
     *
     * Property to inform updates for phonetics data
     *
     * @param act The act which was previously returned by the
     * sendPhoneticsUpdateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPhoneticsUpdateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PhoneticsUpdate'.
     */
    void sendPhoneticsUpdateRelUpRegAll ();

    /**
     * Returns the current value of the property 'PhoneticsUpdate' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasPhoneticsUpdate() returns true.
     *
     * @return the previously received value of the property 'PhoneticsUpdate'.
     */
    const PhoneticsUpdateStatus& getPhoneticsUpdate() const;

    /**
     * Determines whether a status message for the property 'PhoneticsUpdate' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPhoneticsUpdate() const;

    /**
     * Request the value of the property 'PhoneticsUpdate' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PhoneticsUpdate'</b>:
     *
     * Property to inform updates for phonetics data
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPhoneticsUpdateGet(PhoneticsUpdateCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Sxm_phonetics_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'PhoneticsUpdate'

    ::asf::core::nullable< PhoneticsUpdateStatus > _phoneticsUpdate;

    DECLARE_CLASS_LOGGER();

    friend class Sxm_phonetics_main_fiProxyCallback;
};

} // namespace sxm_phonetics_main_fi

#endif // SXM_PHONETICS_MAIN_FIPROXY_H
