/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_PARKING_MAIN_FIPROXY_H
#define SXM_PARKING_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "sxm_main_fi_types.h"
#include "sxm_parking_main_fi.h"
#include "sxm_parking_main_fi_types.h"
#include <vector>

namespace sxm_parking_main_fi {

class Sxm_parking_main_fiProxy;

class AddFavoriteCallbackIF {
public:
    virtual ~AddFavoriteCallbackIF() {}

    virtual void onAddFavoriteError(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< AddFavoriteError >& error) = 0;

    virtual void onAddFavoriteResult(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< AddFavoriteResult >& result) = 0;
};

class GetParkingInfoListCallbackIF {
public:
    virtual ~GetParkingInfoListCallbackIF() {}

    virtual void onGetParkingInfoListError(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< GetParkingInfoListError >& error) = 0;

    virtual void onGetParkingInfoListResult(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< GetParkingInfoListResult >& result) = 0;
};

class GetParkingStationInfoCallbackIF {
public:
    virtual ~GetParkingStationInfoCallbackIF() {}

    virtual void onGetParkingStationInfoError(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< GetParkingStationInfoError >& error) = 0;

    virtual void onGetParkingStationInfoResult(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< GetParkingStationInfoResult >& result) = 0;
};

class ParkingInfoListsStatusCallbackIF {
public:
    virtual ~ParkingInfoListsStatusCallbackIF() {}

    virtual void onParkingInfoListsStatusError(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< ParkingInfoListsStatusError >& error) = 0;

    virtual void onParkingInfoListsStatusStatus(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< ParkingInfoListsStatusStatus >& status) = 0;
};

class RemoveFavoriteCallbackIF {
public:
    virtual ~RemoveFavoriteCallbackIF() {}

    virtual void onRemoveFavoriteError(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< RemoveFavoriteError >& error) = 0;

    virtual void onRemoveFavoriteResult(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< RemoveFavoriteResult >& result) = 0;
};

class RestoreFavoritesCallbackIF {
public:
    virtual ~RestoreFavoritesCallbackIF() {}

    virtual void onRestoreFavoritesError(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< RestoreFavoritesError >& error) = 0;

    virtual void onRestoreFavoritesResult(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< RestoreFavoritesResult >& result) = 0;
};

class SetFilterConfigCallbackIF {
public:
    virtual ~SetFilterConfigCallbackIF() {}

    virtual void onSetFilterConfigError(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< SetFilterConfigError >& error) = 0;

    virtual void onSetFilterConfigResult(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< SetFilterConfigResult >& result) = 0;
};

class SetFilterConfigurationCallbackIF {
public:
    virtual ~SetFilterConfigurationCallbackIF() {}

    virtual void onSetFilterConfigurationError(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< SetFilterConfigurationError >& error) = 0;

    virtual void onSetFilterConfigurationResult(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< SetFilterConfigurationResult >& result) = 0;
};

class SxmDataServiceStatusCallbackIF {
public:
    virtual ~SxmDataServiceStatusCallbackIF() {}

    virtual void onSxmDataServiceStatusError(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusError >& error) = 0;

    virtual void onSxmDataServiceStatusStatus(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusStatus >& status) = 0;
};

class SxmListModeCallbackIF {
public:
    virtual ~SxmListModeCallbackIF() {}

    virtual void onSxmListModeError(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeError >& error) = 0;

    virtual void onSxmListModeStatus(const ::boost::shared_ptr< Sxm_parking_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeStatus >& status) = 0;
};

class Sxm_parking_main_fiProxyCallback;

/**
 * Sxm_parking_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'sxm_parking_main_fi' (specified in file
 * sxm_parking_main_fi.xml).
 *
 * CCA Functional Interface 'sxm_parking_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Parking
 *
 * Version: $Revision:   0.2  $
 *
 * Author: Narasimhulu Kavadapu (Parking)
 *
 * Date: $Date:   March17 2016  14:00 PM  $
 *
 * Department: ECV
 *
 * Title: sxm_parking_main_fi
 *
 * <b>Description of 'sxm_parking_main_fi':</b>
 *
 * RBEI
 */
class Sxm_parking_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Sxm_parking_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_parking_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_parking_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_parking_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_parking_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Sxm_parking_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Sxm_parking_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Sxm_parking_main_fiProxy();

    // Method 'GetParkingInfoList'

    /**
     * Call the method 'GetParkingInfoList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetParkingInfoList'</b>:
     *
     * This method is used to get Parking list
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ListID type of parking user requested for
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetParkingInfoListStart(GetParkingInfoListCallbackIF& cb, uint32 listID);

    // Method 'GetParkingStationInfo'

    /**
     * Call the method 'GetParkingStationInfo'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetParkingStationInfo'</b>:
     *
     * Get Parking location information of particular parking ID
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ParkingID Parking location ID
     *
     * @param ListID Location Type
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetParkingStationInfoStart(GetParkingStationInfoCallbackIF& cb, uint32 parkingID, uint32 listID);

    // Method 'AddFavorite'

    /**
     * Call the method 'AddFavorite'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'AddFavorite'</b>:
     *
     * This method is used to add Parking station
     * information into favorite list
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ParkingID Parking ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddFavoriteStart(AddFavoriteCallbackIF& cb, uint32 parkingID);

    // Method 'RemoveFavorite'

    /**
     * Call the method 'RemoveFavorite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RemoveFavorite'</b>:
     *
     * This method is used to Remove Parking station
     * information from favorite list
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ParkingID Parking ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveFavoriteStart(RemoveFavoriteCallbackIF& cb, uint32 parkingID);

    // Method 'SetFilterConfig'

    /**
     * Call the method 'SetFilterConfig'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetFilterConfig'</b>:
     *
     * method to Set Filter configuration.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param FilterConfig Filter Configuration.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFilterConfigStart(SetFilterConfigCallbackIF& cb, const ::sxm_parking_main_fi_types::T_FilterConfig& filterConfig);

    // Method 'RestoreFavorites'

    /**
     * Call the method 'RestoreFavorites'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RestoreFavorites'</b>:
     *
     * This method is used to restore favorites persisted by client.
     * This method to be called on power up to restore default favorites.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param FavoriteList List of Favorites to be restored.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRestoreFavoritesStart(RestoreFavoritesCallbackIF& cb, const ::std::vector< uint32 >& favoriteList);

    // Method 'SetFilterConfiguration'

    /**
     * Call the method 'SetFilterConfiguration'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetFilterConfiguration'</b>:
     *
     * method to Set Filter configuration.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param FilterConfig Filter Configuration.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFilterConfigurationStart(SetFilterConfigurationCallbackIF& cb, const ::sxm_parking_main_fi_types::T_FilterConfiguration& filterConfig);

    // Property 'ParkingInfoListsStatus'

    /**
     * Notify on the property 'ParkingInfoListsStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'ParkingInfoListsStatus'</b>:
     *
     * Status of all configured Lists
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendParkingInfoListsStatusUpReg(ParkingInfoListsStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ParkingInfoListsStatus'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ParkingInfoListsStatus'</b>:
     *
     * Status of all configured Lists
     *
     * @param act The act which was previously returned by the
     * sendParkingInfoListsStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendParkingInfoListsStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ParkingInfoListsStatus'.
     */
    void sendParkingInfoListsStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'ParkingInfoListsStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasParkingInfoListsStatus() returns true.
     *
     * @return the previously received value of the property 'ParkingInfoListsStatus'.
     */
    const ParkingInfoListsStatusStatus& getParkingInfoListsStatus() const;

    /**
     * Determines whether a status message for the property 'ParkingInfoListsStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasParkingInfoListsStatus() const;

    /**
     * Request the value of the property 'ParkingInfoListsStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'ParkingInfoListsStatus'</b>:
     *
     * Status of all configured Lists
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendParkingInfoListsStatusGet(ParkingInfoListsStatusCallbackIF& cb);

    // Property 'SxmDataServiceStatus'

    /**
     * Notify on the property 'SxmDataServiceStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Parking Data Service
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmDataServiceStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Parking Data Service
     *
     * @param act The act which was previously returned by the
     * sendSxmDataServiceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmDataServiceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmDataServiceStatus'.
     */
    void sendSxmDataServiceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmDataServiceStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSxmDataServiceStatus() returns true.
     *
     * @return the previously received value of the property 'SxmDataServiceStatus'.
     */
    const SxmDataServiceStatusStatus& getSxmDataServiceStatus() const;

    /**
     * Determines whether a status message for the property 'SxmDataServiceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmDataServiceStatus() const;

    /**
     * Request the value of the property 'SxmDataServiceStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Parking Data Service
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb);

    // Property 'SxmListMode'

    /**
     * Notify on the property 'SxmListMode'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Parking List.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeUpReg(SxmListModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmListMode'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Parking List.
     *
     * @param act The act which was previously returned by the
     * sendSxmListModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmListModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmListMode'.
     */
    void sendSxmListModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmListMode' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSxmListMode() returns true.
     *
     * @return the previously received value of the property 'SxmListMode'.
     */
    const SxmListModeStatus& getSxmListMode() const;

    /**
     * Determines whether a status message for the property 'SxmListMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmListMode() const;

    /**
     * Set the value of the property 'SxmListMode'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Parking List.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param ListMode Set the Mode of Parking List
     *
     * @param DummyData Dummy data for ASF code generation
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeSet(SxmListModeCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListMode& listMode, bool dummyData = 0);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Sxm_parking_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'ParkingInfoListsStatus'

    ::asf::core::nullable< ParkingInfoListsStatusStatus > _parkingInfoListsStatus;

    // Property 'SxmDataServiceStatus'

    ::asf::core::nullable< SxmDataServiceStatusStatus > _sxmDataServiceStatus;

    // Property 'SxmListMode'

    ::asf::core::nullable< SxmListModeStatus > _sxmListMode;

    DECLARE_CLASS_LOGGER();

    friend class Sxm_parking_main_fiProxyCallback;
};

} // namespace sxm_parking_main_fi

#endif // SXM_PARKING_MAIN_FIPROXY_H
