#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_PARKING_MAIN_FI_H
#define SXM_PARKING_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "sxm_main_fi_types.h"
#include "sxm_parking_main_fi_types.h"
#include "sxm_parking_main_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'sxm_parking_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Parking
 *
 * Version: $Revision:   0.2  $
 *
 * Author: Narasimhulu Kavadapu (Parking)
 *
 * Date: $Date:   March17 2016  14:00 PM  $
 *
 * Department: ECV
 *
 * Title: sxm_parking_main_fi
 *
 * <b>Description of 'sxm_parking_main_fi':</b>
 *
 * RBEI
 */

namespace sxm_parking_main_fi {

static const int SERVICE_ID = 190;

static const int FID_GetParkingInfoList = 1;

static const int FID_GetParkingStationInfo = 2;

static const int FID_AddFavorite = 3;

static const int FID_RemoveFavorite = 4;

static const int FID_SetFilterConfig = 5;

static const int FID_RestoreFavorites = 6;

static const int FID_SetFilterConfiguration = 7;

static const int FID_ParkingInfoListsStatus = 16;

static const int FID_SxmDataServiceStatus = 17;

static const int FID_SxmListMode = 18;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 2;

static const int VERSION_PATCH = 1;

// forward declarations
class GetParkingInfoListStart;

class GetParkingInfoListResult;

class GetParkingInfoListErrorStructure;

class GetParkingInfoListError;

class GetParkingStationInfoStart;

class GetParkingStationInfoResult;

class GetParkingStationInfoErrorStructure;

class GetParkingStationInfoError;

class AddFavoriteStart;

class AddFavoriteResult;

class RemoveFavoriteStart;

class RemoveFavoriteResult;

class SetFilterConfigStart;

class SetFilterConfigResult;

class RestoreFavoritesStart;

class RestoreFavoritesResult;

class RestoreFavoritesErrorStructure;

class RestoreFavoritesError;

class SetFilterConfigurationStart;

class SetFilterConfigurationResult;

class ParkingInfoListsStatusStatus;

class SxmDataServiceStatusStatus;

class SxmListModeStatus;

class SxmListModeSet;

// type definitions
/**
 * The abort error message of the method "GetParkingInfoList"
 * This method is used to get Parking list
 */
typedef ::asf::cca::CcaTypes::DefaultError GetParkingInfoListAbortError;

/**
 * The abort error message of the method "GetParkingStationInfo"
 * Get Parking location information of particular parking ID
 */
typedef ::asf::cca::CcaTypes::DefaultError GetParkingStationInfoAbortError;

/**
 * The abort error message of the method "AddFavorite"
 * This method is used to add Parking station
 * information into favorite list
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFavoriteAbortError;

/**
 * The error message of 'AddFavorite'
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFavoriteError;

/**
 * The abort error message of the method "RemoveFavorite"
 * This method is used to Remove Parking station
 * information from favorite list
 */
typedef ::asf::cca::CcaTypes::DefaultError RemoveFavoriteAbortError;

/**
 * The error message of 'RemoveFavorite'
 */
typedef ::asf::cca::CcaTypes::DefaultError RemoveFavoriteError;

/**
 * The abort error message of the method "SetFilterConfig"
 * method to Set Filter configuration.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFilterConfigAbortError;

/**
 * The error message of 'SetFilterConfig'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFilterConfigError;

/**
 * The abort error message of the method "RestoreFavorites"
 * This method is used to restore favorites persisted by client.
 * This method to be called on power up to restore default favorites.
 */
typedef ::asf::cca::CcaTypes::DefaultError RestoreFavoritesAbortError;

/**
 * The abort error message of the method "SetFilterConfiguration"
 * method to Set Filter configuration.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFilterConfigurationAbortError;

/**
 * The error message of 'SetFilterConfiguration'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFilterConfigurationError;

/**
 * The get message of the property "ParkingInfoListsStatus"
 * Status of all configured Lists
 * Parking information Available
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ParkingInfoListsStatusGet;

/**
 * The upreg message of the property "ParkingInfoListsStatus"
 * Status of all configured Lists
 * Register for Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ParkingInfoListsStatusUpReg;

/**
 * The relUpReg message of the property "ParkingInfoListsStatus"
 * Status of all configured Lists
 * Unregister for Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ParkingInfoListsStatusRelUpReg;

/**
 * The error message of 'ParkingInfoListsStatus'
 * todo
 */
typedef ::asf::cca::CcaTypes::DefaultError ParkingInfoListsStatusError;

/**
 * The get message of the property "SxmDataServiceStatus"
 * Get the Status of Parking Data Service
 * Status of Parking Data Service
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusGet;

/**
 * The upreg message of the property "SxmDataServiceStatus"
 * Get the Status of Parking Data Service
 * Register for Parking Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusUpReg;

/**
 * The relUpReg message of the property "SxmDataServiceStatus"
 * Get the Status of Parking Data Service
 * Unregister for Parking Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusRelUpReg;

/**
 * The error message of 'SxmDataServiceStatus'
 * This error code specifies Parking Data Service Status is not available
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmDataServiceStatusError;

/**
 * The upreg message of the property "SxmListMode"
 * Set the Mode of Parking List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeUpReg;

/**
 * The relUpReg message of the property "SxmListMode"
 * Set the Mode of Parking List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeRelUpReg;

/**
 * The error message of 'SxmListMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmListModeError;


/**
 * The start message of the method "GetParkingInfoList"
 * This method is used to get Parking list
 */
class GetParkingInfoListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetParkingInfoListStart ();

    /**
     * Copy constructor
     */
    inline  GetParkingInfoListStart (const GetParkingInfoListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetParkingInfoListStart (uint32 ListID_);

    /**
     * Destructor
     */
    inline virtual  ~GetParkingInfoListStart();

    /**
     * Assignment operator
     */
    inline GetParkingInfoListStart& operator = (const GetParkingInfoListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetParkingInfoListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetParkingInfoListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetParkingInfoListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetParkingInfoListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * type of parking user requested for
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * type of parking user requested for
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    static const GetParkingInfoListStart &getDefaultInstance();

private:

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ListID;

};

/**
 * The result message of the method "GetParkingInfoList"
 * This method is used to get Parking list
 */
class GetParkingInfoListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetParkingInfoListResult ();

    /**
     * Copy constructor
     */
    inline  GetParkingInfoListResult (const GetParkingInfoListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetParkingInfoListResult (uint32 ListID_, const ::std::vector< ::sxm_parking_main_fi_types::T_ParkingInfo >& ParkingInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~GetParkingInfoListResult();

    /**
     * Assignment operator
     */
    inline GetParkingInfoListResult& operator = (const GetParkingInfoListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetParkingInfoListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetParkingInfoListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetParkingInfoListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetParkingInfoListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * type of parking user requested for
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * type of parking user requested for
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "ParkingInfoList"

    static const int kParkingInfoList = 1;

    /**
     * Clears the field "ParkingInfoList".
     *
     * The field will be set to its default value. The hasParkingInfoList()
     * method will return false.
     */
    inline void clearParkingInfoList();

    /**
     * Checks whether the field "ParkingInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParkingInfoList()). Otherwise it will return false.
     */
    inline bool hasParkingInfoList () const;

    /**
     * Returns the value of the member "ParkingInfoList".
     *
     * Parking Info list requested for.
     *
     * @return The value of the field "ParkingInfoList"
     */
    inline const ::std::vector< ::sxm_parking_main_fi_types::T_ParkingInfo >& getParkingInfoList () const;

    /**
     * Retrieves the value of the field "ParkingInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ParkingInfoList".
     */
    inline ::std::vector< ::sxm_parking_main_fi_types::T_ParkingInfo >& getParkingInfoListMutable ();

    /**
     * Sets the value of the member "ParkingInfoList".
     *
     * Parking Info list requested for.
     *
     * @param ParkingInfoList The value which will be set
     */
    inline void setParkingInfoList (const ::std::vector< ::sxm_parking_main_fi_types::T_ParkingInfo >& ParkingInfoList_);

    static const GetParkingInfoListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_parking_main_fi_types::T_ParkingInfo >& getT_ParkingInfoList_DefaultInstance ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_ParkingInfoList ();

    inline void clear_has_ParkingInfoList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ListID;

    ::std::vector< ::sxm_parking_main_fi_types::T_ParkingInfo > _ParkingInfoList;

};

/**
 * The error message of 'GetParkingInfoList'
 */
class GetParkingInfoListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetParkingInfoListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetParkingInfoListErrorStructure (const GetParkingInfoListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetParkingInfoListErrorStructure (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetParkingInfoListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetParkingInfoListErrorStructure& operator = (const GetParkingInfoListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetParkingInfoListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetParkingInfoListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetParkingInfoListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetParkingInfoListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Parking list is empty
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_parking_main_fi_types::T_e8ParkingErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Parking list is empty
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes ErrorCode_);

    static const GetParkingInfoListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_parking_main_fi_types::T_e8ParkingErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetParkingInfoList'
 */
class GetParkingInfoListError  : public ::asf::core::Payload {
public:

    enum GetParkingInfoListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetParkingInfoListError ();

   /**
     * Copy constructor
     */
    inline  GetParkingInfoListError (const GetParkingInfoListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetParkingInfoListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetParkingInfoListError& operator = (const GetParkingInfoListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetParkingInfoListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetParkingInfoListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetParkingInfoListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetParkingInfoListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetParkingInfoListError::GetParkingInfoListErrorField getField () const;

    inline void setField(GetParkingInfoListError::GetParkingInfoListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetParkingInfoListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetParkingInfoListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetParkingInfoListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetParkingInfoListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetParkingInfoListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetParkingInfoListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetParkingInfoListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetParkingInfoListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetParkingInfoListError &getDefaultInstance();

private:

    inline void cloneData (const GetParkingInfoListError& rhs);

    inline void deleteData ();

    GetParkingInfoListErrorField __field;

    union {
        GetParkingInfoListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetParkingStationInfo"
 * Get Parking location information of particular parking ID
 */
class GetParkingStationInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetParkingStationInfoStart ();

    /**
     * Copy constructor
     */
    inline  GetParkingStationInfoStart (const GetParkingStationInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetParkingStationInfoStart (uint32 ParkingID_, uint32 ListID_);

    /**
     * Destructor
     */
    inline virtual  ~GetParkingStationInfoStart();

    /**
     * Assignment operator
     */
    inline GetParkingStationInfoStart& operator = (const GetParkingStationInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetParkingStationInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetParkingStationInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetParkingStationInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetParkingStationInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ParkingID"

    static const int kParkingID = 0;

    /**
     * Clears the field "ParkingID".
     *
     * The field will be set to its default value. The hasParkingID()
     * method will return false.
     */
    inline void clearParkingID();

    /**
     * Checks whether the field "ParkingID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParkingID()). Otherwise it will return false.
     */
    inline bool hasParkingID () const;

    /**
     * Returns the value of the member "ParkingID".
     *
     * Parking location ID
     *
     * @return The value of the field "ParkingID"
     */
    inline uint32 getParkingID () const;

    /**
     * Sets the value of the member "ParkingID".
     *
     * Parking location ID
     *
     * @param ParkingID The value which will be set
     */
    inline void setParkingID (uint32 ParkingID_);

    // API of field "ListID"

    static const int kListID = 1;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Location Type
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Location Type
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    static const GetParkingStationInfoStart &getDefaultInstance();

private:

    inline void set_has_ParkingID ();

    inline void clear_has_ParkingID ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ParkingID;

    uint32 _ListID;

};

/**
 * The result message of the method "GetParkingStationInfo"
 * Get Parking location information of particular parking ID
 */
class GetParkingStationInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetParkingStationInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetParkingStationInfoResult (const GetParkingStationInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetParkingStationInfoResult (const ::sxm_parking_main_fi_types::T_ParkingInfo& ParkingStationInfo_, uint32 ListID_);

    /**
     * Destructor
     */
    inline virtual  ~GetParkingStationInfoResult();

    /**
     * Assignment operator
     */
    inline GetParkingStationInfoResult& operator = (const GetParkingStationInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetParkingStationInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetParkingStationInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetParkingStationInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetParkingStationInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ParkingStationInfo"

    static const int kParkingStationInfo = 0;

    /**
     * Clears the field "ParkingStationInfo".
     *
     * The field will be set to its default value. The hasParkingStationInfo()
     * method will return false.
     */
    inline void clearParkingStationInfo();

    /**
     * Checks whether the field "ParkingStationInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParkingStationInfo()). Otherwise it will return false.
     */
    inline bool hasParkingStationInfo () const;

    /**
     * Returns the value of the member "ParkingStationInfo".
     *
     * Parking station information
     *
     * @return The value of the field "ParkingStationInfo"
     */
    inline const ::sxm_parking_main_fi_types::T_ParkingInfo& getParkingStationInfo () const;

    /**
     * Retrieves the value of the field "ParkingStationInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ParkingStationInfo".
     */
    inline ::sxm_parking_main_fi_types::T_ParkingInfo& getParkingStationInfoMutable ();

    /**
     * Sets the value of the member "ParkingStationInfo".
     *
     * Parking station information
     *
     * @param ParkingStationInfo The value which will be set
     */
    inline void setParkingStationInfo (const ::sxm_parking_main_fi_types::T_ParkingInfo& ParkingStationInfo_);

    // API of field "ListID"

    static const int kListID = 1;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Location Type
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Location Type
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    static const GetParkingStationInfoResult &getDefaultInstance();

private:

    inline void set_has_ParkingStationInfo ();

    inline void clear_has_ParkingStationInfo ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_parking_main_fi_types::T_ParkingInfo _ParkingStationInfo;

    uint32 _ListID;

};

/**
 * The error message of 'GetParkingStationInfo'
 */
class GetParkingStationInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetParkingStationInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetParkingStationInfoErrorStructure (const GetParkingStationInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetParkingStationInfoErrorStructure (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetParkingStationInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetParkingStationInfoErrorStructure& operator = (const GetParkingStationInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetParkingStationInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetParkingStationInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetParkingStationInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetParkingStationInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Parking station unavailability
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_parking_main_fi_types::T_e8ParkingErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Parking station unavailability
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes ErrorCode_);

    static const GetParkingStationInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_parking_main_fi_types::T_e8ParkingErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetParkingStationInfo'
 */
class GetParkingStationInfoError  : public ::asf::core::Payload {
public:

    enum GetParkingStationInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetParkingStationInfoError ();

   /**
     * Copy constructor
     */
    inline  GetParkingStationInfoError (const GetParkingStationInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetParkingStationInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetParkingStationInfoError& operator = (const GetParkingStationInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetParkingStationInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetParkingStationInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetParkingStationInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetParkingStationInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetParkingStationInfoError::GetParkingStationInfoErrorField getField () const;

    inline void setField(GetParkingStationInfoError::GetParkingStationInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetParkingStationInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetParkingStationInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetParkingStationInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetParkingStationInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetParkingStationInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetParkingStationInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetParkingStationInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetParkingStationInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetParkingStationInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetParkingStationInfoError& rhs);

    inline void deleteData ();

    GetParkingStationInfoErrorField __field;

    union {
        GetParkingStationInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AddFavorite"
 * This method is used to add Parking station
 * information into favorite list
 */
class AddFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteStart (const AddFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteStart (uint32 ParkingID_);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteStart();

    /**
     * Assignment operator
     */
    inline AddFavoriteStart& operator = (const AddFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ParkingID"

    static const int kParkingID = 0;

    /**
     * Clears the field "ParkingID".
     *
     * The field will be set to its default value. The hasParkingID()
     * method will return false.
     */
    inline void clearParkingID();

    /**
     * Checks whether the field "ParkingID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParkingID()). Otherwise it will return false.
     */
    inline bool hasParkingID () const;

    /**
     * Returns the value of the member "ParkingID".
     *
     * Parking ID
     *
     * @return The value of the field "ParkingID"
     */
    inline uint32 getParkingID () const;

    /**
     * Sets the value of the member "ParkingID".
     *
     * Parking ID
     *
     * @param ParkingID The value which will be set
     */
    inline void setParkingID (uint32 ParkingID_);

    static const AddFavoriteStart &getDefaultInstance();

private:

    inline void set_has_ParkingID ();

    inline void clear_has_ParkingID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ParkingID;

};

/**
 * The result message of the method "AddFavorite"
 * This method is used to add Parking station
 * information into favorite list
 */
class AddFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteResult (const AddFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteResult();

    /**
     * Assignment operator
     */
    inline AddFavoriteResult& operator = (const AddFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Successfully add in favorite list return True
     * else return False
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Successfully add in favorite list return True
     * else return False
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const AddFavoriteResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "RemoveFavorite"
 * This method is used to Remove Parking station
 * information from favorite list
 */
class RemoveFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteStart (const RemoveFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteStart (uint32 ParkingID_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteStart();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteStart& operator = (const RemoveFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ParkingID"

    static const int kParkingID = 0;

    /**
     * Clears the field "ParkingID".
     *
     * The field will be set to its default value. The hasParkingID()
     * method will return false.
     */
    inline void clearParkingID();

    /**
     * Checks whether the field "ParkingID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParkingID()). Otherwise it will return false.
     */
    inline bool hasParkingID () const;

    /**
     * Returns the value of the member "ParkingID".
     *
     * Parking ID
     *
     * @return The value of the field "ParkingID"
     */
    inline uint32 getParkingID () const;

    /**
     * Sets the value of the member "ParkingID".
     *
     * Parking ID
     *
     * @param ParkingID The value which will be set
     */
    inline void setParkingID (uint32 ParkingID_);

    static const RemoveFavoriteStart &getDefaultInstance();

private:

    inline void set_has_ParkingID ();

    inline void clear_has_ParkingID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ParkingID;

};

/**
 * The result message of the method "RemoveFavorite"
 * This method is used to Remove Parking station
 * information from favorite list
 */
class RemoveFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteResult (const RemoveFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteResult();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteResult& operator = (const RemoveFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * True for Success
     * False for failed.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * True for Success
     * False for failed.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const RemoveFavoriteResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SetFilterConfig"
 * method to Set Filter configuration.
 */
class SetFilterConfigStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFilterConfigStart ();

    /**
     * Copy constructor
     */
    inline  SetFilterConfigStart (const SetFilterConfigStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetFilterConfigStart (const ::sxm_parking_main_fi_types::T_FilterConfig& FilterConfig_);

    /**
     * Destructor
     */
    inline virtual  ~SetFilterConfigStart();

    /**
     * Assignment operator
     */
    inline SetFilterConfigStart& operator = (const SetFilterConfigStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFilterConfigStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFilterConfigStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFilterConfigStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFilterConfigStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FilterConfig"

    static const int kFilterConfig = 0;

    /**
     * Clears the field "FilterConfig".
     *
     * The field will be set to its default value. The hasFilterConfig()
     * method will return false.
     */
    inline void clearFilterConfig();

    /**
     * Checks whether the field "FilterConfig" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilterConfig()). Otherwise it will return false.
     */
    inline bool hasFilterConfig () const;

    /**
     * Returns the value of the member "FilterConfig".
     *
     * Filter Configuration.
     *
     * @return The value of the field "FilterConfig"
     */
    inline const ::sxm_parking_main_fi_types::T_FilterConfig& getFilterConfig () const;

    /**
     * Retrieves the value of the field "FilterConfig" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FilterConfig".
     */
    inline ::sxm_parking_main_fi_types::T_FilterConfig& getFilterConfigMutable ();

    /**
     * Sets the value of the member "FilterConfig".
     *
     * Filter Configuration.
     *
     * @param FilterConfig The value which will be set
     */
    inline void setFilterConfig (const ::sxm_parking_main_fi_types::T_FilterConfig& FilterConfig_);

    static const SetFilterConfigStart &getDefaultInstance();

private:

    inline void set_has_FilterConfig ();

    inline void clear_has_FilterConfig ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_parking_main_fi_types::T_FilterConfig _FilterConfig;

};

/**
 * The result message of the method "SetFilterConfig"
 * method to Set Filter configuration.
 */
class SetFilterConfigResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFilterConfigResult ();

    /**
     * Copy constructor
     */
    inline  SetFilterConfigResult (const SetFilterConfigResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetFilterConfigResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetFilterConfigResult();

    /**
     * Assignment operator
     */
    inline SetFilterConfigResult& operator = (const SetFilterConfigResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFilterConfigResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFilterConfigResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFilterConfigResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFilterConfigResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * True for Success
     * False for failed.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * True for Success
     * False for failed.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetFilterConfigResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "RestoreFavorites"
 * This method is used to restore favorites persisted by client.
 * This method to be called on power up to restore default favorites.
 */
class RestoreFavoritesStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestoreFavoritesStart ();

    /**
     * Copy constructor
     */
    inline  RestoreFavoritesStart (const RestoreFavoritesStart &rhs);

    /**
     * All fields constructor
     */
    inline  RestoreFavoritesStart (const ::std::vector< uint32 >& FavoriteList_);

    /**
     * Destructor
     */
    inline virtual  ~RestoreFavoritesStart();

    /**
     * Assignment operator
     */
    inline RestoreFavoritesStart& operator = (const RestoreFavoritesStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestoreFavoritesStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestoreFavoritesStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestoreFavoritesStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestoreFavoritesStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FavoriteList"

    static const int kFavoriteList = 0;

    /**
     * Clears the field "FavoriteList".
     *
     * The field will be set to its default value. The hasFavoriteList()
     * method will return false.
     */
    inline void clearFavoriteList();

    /**
     * Checks whether the field "FavoriteList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteList()). Otherwise it will return false.
     */
    inline bool hasFavoriteList () const;

    /**
     * Returns the value of the member "FavoriteList".
     *
     * List of Favorites to be restored.
     *
     * @return The value of the field "FavoriteList"
     */
    inline const ::std::vector< uint32 >& getFavoriteList () const;

    /**
     * Retrieves the value of the field "FavoriteList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FavoriteList".
     */
    inline ::std::vector< uint32 >& getFavoriteListMutable ();

    /**
     * Sets the value of the member "FavoriteList".
     *
     * List of Favorites to be restored.
     *
     * @param FavoriteList The value which will be set
     */
    inline void setFavoriteList (const ::std::vector< uint32 >& FavoriteList_);

    static const RestoreFavoritesStart &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_FavoriteList ();

    inline void clear_has_FavoriteList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint32 > _FavoriteList;

};

/**
 * The result message of the method "RestoreFavorites"
 * This method is used to restore favorites persisted by client.
 * This method to be called on power up to restore default favorites.
 */
class RestoreFavoritesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestoreFavoritesResult ();

    /**
     * Copy constructor
     */
    inline  RestoreFavoritesResult (const RestoreFavoritesResult &rhs);

    /**
     * All fields constructor
     */
    inline  RestoreFavoritesResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~RestoreFavoritesResult();

    /**
     * Assignment operator
     */
    inline RestoreFavoritesResult& operator = (const RestoreFavoritesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestoreFavoritesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestoreFavoritesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestoreFavoritesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestoreFavoritesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status of the Operation.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Status of the Operation.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const RestoreFavoritesResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'RestoreFavorites'
 */
class RestoreFavoritesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RestoreFavoritesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RestoreFavoritesErrorStructure (const RestoreFavoritesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RestoreFavoritesErrorStructure (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~RestoreFavoritesErrorStructure();

    /**
     * Assignment operator
     */
    inline RestoreFavoritesErrorStructure& operator = (const RestoreFavoritesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestoreFavoritesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestoreFavoritesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestoreFavoritesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestoreFavoritesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * error code.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_parking_main_fi_types::T_e8ParkingErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * error code.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes ErrorCode_);

    static const RestoreFavoritesErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_parking_main_fi_types::T_e8ParkingErrorTypes _ErrorCode;

};

/**
 * The error message of 'RestoreFavorites'
 */
class RestoreFavoritesError  : public ::asf::core::Payload {
public:

    enum RestoreFavoritesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RestoreFavoritesError ();

   /**
     * Copy constructor
     */
    inline  RestoreFavoritesError (const RestoreFavoritesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RestoreFavoritesError();

    /**
     * Assigns a new value to this object.
     */
    inline RestoreFavoritesError& operator = (const RestoreFavoritesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestoreFavoritesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestoreFavoritesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestoreFavoritesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestoreFavoritesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RestoreFavoritesError::RestoreFavoritesErrorField getField () const;

    inline void setField(RestoreFavoritesError::RestoreFavoritesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RestoreFavoritesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RestoreFavoritesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RestoreFavoritesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RestoreFavoritesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RestoreFavoritesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RestoreFavoritesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RestoreFavoritesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RestoreFavoritesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RestoreFavoritesError &getDefaultInstance();

private:

    inline void cloneData (const RestoreFavoritesError& rhs);

    inline void deleteData ();

    RestoreFavoritesErrorField __field;

    union {
        RestoreFavoritesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetFilterConfiguration"
 * method to Set Filter configuration.
 */
class SetFilterConfigurationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFilterConfigurationStart ();

    /**
     * Copy constructor
     */
    inline  SetFilterConfigurationStart (const SetFilterConfigurationStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetFilterConfigurationStart (const ::sxm_parking_main_fi_types::T_FilterConfiguration& FilterConfig_);

    /**
     * Destructor
     */
    inline virtual  ~SetFilterConfigurationStart();

    /**
     * Assignment operator
     */
    inline SetFilterConfigurationStart& operator = (const SetFilterConfigurationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFilterConfigurationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFilterConfigurationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFilterConfigurationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFilterConfigurationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FilterConfig"

    static const int kFilterConfig = 0;

    /**
     * Clears the field "FilterConfig".
     *
     * The field will be set to its default value. The hasFilterConfig()
     * method will return false.
     */
    inline void clearFilterConfig();

    /**
     * Checks whether the field "FilterConfig" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilterConfig()). Otherwise it will return false.
     */
    inline bool hasFilterConfig () const;

    /**
     * Returns the value of the member "FilterConfig".
     *
     * Filter Configuration.
     *
     * @return The value of the field "FilterConfig"
     */
    inline const ::sxm_parking_main_fi_types::T_FilterConfiguration& getFilterConfig () const;

    /**
     * Retrieves the value of the field "FilterConfig" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FilterConfig".
     */
    inline ::sxm_parking_main_fi_types::T_FilterConfiguration& getFilterConfigMutable ();

    /**
     * Sets the value of the member "FilterConfig".
     *
     * Filter Configuration.
     *
     * @param FilterConfig The value which will be set
     */
    inline void setFilterConfig (const ::sxm_parking_main_fi_types::T_FilterConfiguration& FilterConfig_);

    static const SetFilterConfigurationStart &getDefaultInstance();

private:

    inline void set_has_FilterConfig ();

    inline void clear_has_FilterConfig ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_parking_main_fi_types::T_FilterConfiguration _FilterConfig;

};

/**
 * The result message of the method "SetFilterConfiguration"
 * method to Set Filter configuration.
 */
class SetFilterConfigurationResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFilterConfigurationResult ();

    /**
     * Copy constructor
     */
    inline  SetFilterConfigurationResult (const SetFilterConfigurationResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetFilterConfigurationResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetFilterConfigurationResult();

    /**
     * Assignment operator
     */
    inline SetFilterConfigurationResult& operator = (const SetFilterConfigurationResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFilterConfigurationResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFilterConfigurationResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFilterConfigurationResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFilterConfigurationResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * True for Success
     * False for failed.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * True for Success
     * False for failed.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetFilterConfigurationResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The status message of the property "ParkingInfoListsStatus"
 * Status of all configured Lists
 */
class ParkingInfoListsStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ParkingInfoListsStatusStatus ();

    /**
     * Copy constructor
     */
    inline  ParkingInfoListsStatusStatus (const ParkingInfoListsStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ParkingInfoListsStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& InfoList_);

    /**
     * Destructor
     */
    inline virtual  ~ParkingInfoListsStatusStatus();

    /**
     * Assignment operator
     */
    inline ParkingInfoListsStatusStatus& operator = (const ParkingInfoListsStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ParkingInfoListsStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ParkingInfoListsStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ParkingInfoListsStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ParkingInfoListsStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InfoList"

    static const int kInfoList = 0;

    /**
     * Clears the field "InfoList".
     *
     * The field will be set to its default value. The hasInfoList()
     * method will return false.
     */
    inline void clearInfoList();

    /**
     * Checks whether the field "InfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInfoList()). Otherwise it will return false.
     */
    inline bool hasInfoList () const;

    /**
     * Returns the value of the member "InfoList".
     *
     * list containing status of all list provide by Parking
     *
     * @return The value of the field "InfoList"
     */
    inline const ::sxm_main_fi_types::T_SxmListInfos& getInfoList () const;

    /**
     * Retrieves the value of the field "InfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "InfoList".
     */
    inline ::sxm_main_fi_types::T_SxmListInfos& getInfoListMutable ();

    /**
     * Sets the value of the member "InfoList".
     *
     * list containing status of all list provide by Parking
     *
     * @param InfoList The value which will be set
     */
    inline void setInfoList (const ::sxm_main_fi_types::T_SxmListInfos& InfoList_);

    static const ParkingInfoListsStatusStatus &getDefaultInstance();

private:

    inline void set_has_InfoList ();

    inline void clear_has_InfoList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListInfos _InfoList;

};

/**
 * The status message of the property "SxmDataServiceStatus"
 * Get the Status of Parking Data Service
 */
class SxmDataServiceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmDataServiceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    /**
     * Destructor
     */
    inline virtual  ~SxmDataServiceStatusStatus();

    /**
     * Assignment operator
     */
    inline SxmDataServiceStatusStatus& operator = (const SxmDataServiceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataServiceState"

    static const int kDataServiceState = 0;

    /**
     * Clears the field "DataServiceState".
     *
     * The field will be set to its default value. The hasDataServiceState()
     * method will return false.
     */
    inline void clearDataServiceState();

    /**
     * Checks whether the field "DataServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataServiceState()). Otherwise it will return false.
     */
    inline bool hasDataServiceState () const;

    /**
     * Returns the value of the member "DataServiceState".
     *
     * Status of Parking Data Service
     *
     * @return The value of the field "DataServiceState"
     */
    inline const ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceState () const;

    /**
     * Retrieves the value of the field "DataServiceState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DataServiceState".
     */
    inline ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceStateMutable ();

    /**
     * Sets the value of the member "DataServiceState".
     *
     * Status of Parking Data Service
     *
     * @param DataServiceState The value which will be set
     */
    inline void setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    static const SxmDataServiceStatusStatus &getDefaultInstance();

private:

    inline void set_has_DataServiceState ();

    inline void clear_has_DataServiceState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmDataSrvState _DataServiceState;

};

/**
 * The status message of the property "SxmListMode"
 * Set the Mode of Parking List.
 */
class SxmListModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeStatus ();

    /**
     * Copy constructor
     */
    inline  SxmListModeStatus (const SxmListModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_, bool DummyData_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeStatus();

    /**
     * Assignment operator
     */
    inline SxmListModeStatus& operator = (const SxmListModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of Parking List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of Parking List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    // API of field "DummyData"

    static const int kDummyData = 1;

    /**
     * Clears the field "DummyData".
     *
     * The field will be set to its default value. The hasDummyData()
     * method will return false.
     */
    inline void clearDummyData();

    /**
     * Checks whether the field "DummyData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDummyData()). Otherwise it will return false.
     */
    inline bool hasDummyData () const;

    /**
     * Returns the value of the member "DummyData".
     *
     * Dummy data for ASF code generation
     *
     * @return The value of the field "DummyData"
     */
    inline bool getDummyData () const;

    /**
     * Sets the value of the member "DummyData".
     *
     * Dummy data for ASF code generation
     *
     * @param DummyData The value which will be set
     */
    inline void setDummyData (bool DummyData_);

    static const SxmListModeStatus &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    inline void set_has_DummyData ();

    inline void clear_has_DummyData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

    bool _DummyData;

};

/**
 * The set message of the property "SxmListMode"
 * Set the Mode of Parking List.
 */
class SxmListModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeSet ();

    /**
     * Copy constructor
     */
    inline  SxmListModeSet (const SxmListModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_, bool DummyData_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeSet();

    /**
     * Assignment operator
     */
    inline SxmListModeSet& operator = (const SxmListModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of Parking List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of Parking List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    // API of field "DummyData"

    static const int kDummyData = 1;

    /**
     * Clears the field "DummyData".
     *
     * The field will be set to its default value. The hasDummyData()
     * method will return false.
     */
    inline void clearDummyData();

    /**
     * Checks whether the field "DummyData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDummyData()). Otherwise it will return false.
     */
    inline bool hasDummyData () const;

    /**
     * Returns the value of the member "DummyData".
     *
     * Dummy data for ASF code generation
     *
     * @return The value of the field "DummyData"
     */
    inline bool getDummyData () const;

    /**
     * Sets the value of the member "DummyData".
     *
     * Dummy data for ASF code generation
     *
     * @param DummyData The value which will be set
     */
    inline void setDummyData (bool DummyData_);

    static const SxmListModeSet &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    inline void set_has_DummyData ();

    inline void clear_has_DummyData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

    bool _DummyData;

};

inline  GetParkingInfoListStart::GetParkingInfoListStart ()  :
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetParkingInfoListStart::GetParkingInfoListStart (const GetParkingInfoListStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetParkingInfoListStart::GetParkingInfoListStart (uint32 ListID_)  :
    _ListID (ListID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetParkingInfoListStart::~GetParkingInfoListStart() {
}

inline GetParkingInfoListStart& GetParkingInfoListStart::operator = (const GetParkingInfoListStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
    }
    return *this;
}

inline bool GetParkingInfoListStart::operator == (const GetParkingInfoListStart& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()));
}

inline bool GetParkingInfoListStart::operator != (const GetParkingInfoListStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetParkingInfoListStart::operator < (const GetParkingInfoListStart& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetParkingInfoListStart::clone() {
    return new GetParkingInfoListStart(*this);
}

inline bool GetParkingInfoListStart::operator > (const GetParkingInfoListStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetParkingInfoListStart::clear() {
    clearListID();
}

inline void GetParkingInfoListStart::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetParkingInfoListStart::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetParkingInfoListStart::getListID () const {
    return _ListID;
}

inline void GetParkingInfoListStart::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetParkingInfoListStart::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetParkingInfoListStart::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetParkingInfoListResult::GetParkingInfoListResult ()  :
    _ListID (0u),
    _ParkingInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetParkingInfoListResult::GetParkingInfoListResult (const GetParkingInfoListResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ListID (0u),
    _ParkingInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetParkingInfoListResult::GetParkingInfoListResult (uint32 ListID_, const ::std::vector< ::sxm_parking_main_fi_types::T_ParkingInfo >& ParkingInfoList_)  :
    _ListID (ListID_),
    _ParkingInfoList (ParkingInfoList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetParkingInfoListResult::~GetParkingInfoListResult() {
}

inline GetParkingInfoListResult& GetParkingInfoListResult::operator = (const GetParkingInfoListResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasParkingInfoList()) {
            setParkingInfoList(rhs.getParkingInfoList());
        } else {
            clearParkingInfoList();
        }
    }
    return *this;
}

inline bool GetParkingInfoListResult::operator == (const GetParkingInfoListResult& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasParkingInfoList() && !rhs.hasParkingInfoList()) || getParkingInfoList() == rhs.getParkingInfoList()));
}

inline bool GetParkingInfoListResult::operator != (const GetParkingInfoListResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetParkingInfoListResult::operator < (const GetParkingInfoListResult& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasParkingInfoList() || rhs.hasParkingInfoList()) {
        if (getParkingInfoList() < rhs.getParkingInfoList()) return true;
        if (getParkingInfoList() > rhs.getParkingInfoList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetParkingInfoListResult::clone() {
    return new GetParkingInfoListResult(*this);
}

inline bool GetParkingInfoListResult::operator > (const GetParkingInfoListResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetParkingInfoListResult::clear() {
    clearListID();
    clearParkingInfoList();
}

inline void GetParkingInfoListResult::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetParkingInfoListResult::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetParkingInfoListResult::getListID () const {
    return _ListID;
}

inline void GetParkingInfoListResult::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetParkingInfoListResult::clearParkingInfoList() {
    if (hasParkingInfoList()) {
         clear_has_ParkingInfoList();
        _ParkingInfoList.clear();
     }
}

inline bool GetParkingInfoListResult::hasParkingInfoList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::sxm_parking_main_fi_types::T_ParkingInfo >& GetParkingInfoListResult::getParkingInfoList () const {
    return _ParkingInfoList;
}

inline ::std::vector< ::sxm_parking_main_fi_types::T_ParkingInfo >& GetParkingInfoListResult::getParkingInfoListMutable () {
    set_has_ParkingInfoList();
    return _ParkingInfoList;
}

inline void GetParkingInfoListResult::setParkingInfoList (const ::std::vector< ::sxm_parking_main_fi_types::T_ParkingInfo >& ParkingInfoList_) {
    set_has_ParkingInfoList();
    this->_ParkingInfoList = ParkingInfoList_;
}

inline void GetParkingInfoListResult::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetParkingInfoListResult::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetParkingInfoListResult::set_has_ParkingInfoList () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetParkingInfoListResult::clear_has_ParkingInfoList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetParkingInfoListErrorStructure::GetParkingInfoListErrorStructure ()  :
    _ErrorCode (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes__PARKING_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetParkingInfoListErrorStructure::GetParkingInfoListErrorStructure (const GetParkingInfoListErrorStructure &rhs)  :
    _ErrorCode (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes__PARKING_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetParkingInfoListErrorStructure::GetParkingInfoListErrorStructure (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_parking_main_fi_types::T_e8ParkingErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8ParkingErrorTypes", "ErrorCode", "GetParkingInfoListErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetParkingInfoListErrorStructure::~GetParkingInfoListErrorStructure() {
}

inline GetParkingInfoListErrorStructure& GetParkingInfoListErrorStructure::operator = (const GetParkingInfoListErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetParkingInfoListErrorStructure::operator == (const GetParkingInfoListErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetParkingInfoListErrorStructure::operator != (const GetParkingInfoListErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetParkingInfoListErrorStructure::operator < (const GetParkingInfoListErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetParkingInfoListErrorStructure::operator > (const GetParkingInfoListErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetParkingInfoListErrorStructure::clear() {
    clearErrorCode();
}

inline void GetParkingInfoListErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_parking_main_fi_types::T_e8ParkingErrorTypes__PARKING_INFOLIST_EMPTY;
     }
}

inline bool GetParkingInfoListErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_parking_main_fi_types::T_e8ParkingErrorTypes GetParkingInfoListErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetParkingInfoListErrorStructure::setErrorCode (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_parking_main_fi_types::T_e8ParkingErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8ParkingErrorTypes", "ErrorCode", "GetParkingInfoListErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetParkingInfoListErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetParkingInfoListErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetParkingInfoListError::GetParkingInfoListError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetParkingInfoListError::GetParkingInfoListError (const GetParkingInfoListError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetParkingInfoListError::~GetParkingInfoListError() {
    deleteData ();
}

inline GetParkingInfoListError& GetParkingInfoListError::operator = (const GetParkingInfoListError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetParkingInfoListError::operator == (const GetParkingInfoListError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetParkingInfoListError::operator != (const GetParkingInfoListError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetParkingInfoListError::operator < (const GetParkingInfoListError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetParkingInfoListError::operator > (const GetParkingInfoListError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetParkingInfoListError::GetParkingInfoListErrorField GetParkingInfoListError::getField () const {
    return __field;
}

inline void GetParkingInfoListError::setField(GetParkingInfoListError::GetParkingInfoListErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetParkingInfoListError::clone() {
    return new GetParkingInfoListError(*this);
}

inline bool GetParkingInfoListError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetParkingInfoListErrorStructure& GetParkingInfoListError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetParkingInfoListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetParkingInfoListErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetParkingInfoListErrorStructure& GetParkingInfoListError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetParkingInfoListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetParkingInfoListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetParkingInfoListErrorStructure* GetParkingInfoListError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetParkingInfoListError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetParkingInfoListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetParkingInfoListErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetParkingInfoListError::replaceCcaErrorCode (GetParkingInfoListErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetParkingInfoListError::setCcaErrorCode (const GetParkingInfoListErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetParkingInfoListErrorStructure(value);
    }
}

inline bool GetParkingInfoListError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetParkingInfoListError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetParkingInfoListError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetParkingInfoListError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetParkingInfoListError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetParkingInfoListError::cloneData (const GetParkingInfoListError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetParkingInfoListErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetParkingInfoListErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetParkingInfoListError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetParkingStationInfoStart::GetParkingStationInfoStart ()  :
    _ParkingID (0u),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetParkingStationInfoStart::GetParkingStationInfoStart (const GetParkingStationInfoStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ParkingID (0u),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetParkingStationInfoStart::GetParkingStationInfoStart (uint32 ParkingID_, uint32 ListID_)  :
    _ParkingID (ParkingID_),
    _ListID (ListID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetParkingStationInfoStart::~GetParkingStationInfoStart() {
}

inline GetParkingStationInfoStart& GetParkingStationInfoStart::operator = (const GetParkingStationInfoStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasParkingID()) {
            setParkingID(rhs.getParkingID());
        } else {
            clearParkingID();
        }
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
    }
    return *this;
}

inline bool GetParkingStationInfoStart::operator == (const GetParkingStationInfoStart& rhs) const {
    return (((!hasParkingID() && !rhs.hasParkingID()) || getParkingID() == rhs.getParkingID()) &&
        ((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()));
}

inline bool GetParkingStationInfoStart::operator != (const GetParkingStationInfoStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetParkingStationInfoStart::operator < (const GetParkingStationInfoStart& rhs) const {
    if (hasParkingID() || rhs.hasParkingID()) {
        if (getParkingID() < rhs.getParkingID()) return true;
        if (getParkingID() > rhs.getParkingID()) return false;
    }
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetParkingStationInfoStart::clone() {
    return new GetParkingStationInfoStart(*this);
}

inline bool GetParkingStationInfoStart::operator > (const GetParkingStationInfoStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetParkingStationInfoStart::clear() {
    clearParkingID();
    clearListID();
}

inline void GetParkingStationInfoStart::clearParkingID() {
    if (hasParkingID()) {
         clear_has_ParkingID();
        _ParkingID = 0u;
     }
}

inline bool GetParkingStationInfoStart::hasParkingID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetParkingStationInfoStart::getParkingID () const {
    return _ParkingID;
}

inline void GetParkingStationInfoStart::setParkingID (uint32 ParkingID_) {
    set_has_ParkingID();
    this->_ParkingID = ParkingID_;
}

inline void GetParkingStationInfoStart::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetParkingStationInfoStart::hasListID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetParkingStationInfoStart::getListID () const {
    return _ListID;
}

inline void GetParkingStationInfoStart::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetParkingStationInfoStart::set_has_ParkingID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetParkingStationInfoStart::clear_has_ParkingID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetParkingStationInfoStart::set_has_ListID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetParkingStationInfoStart::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetParkingStationInfoResult::GetParkingStationInfoResult ()  :
    _ParkingStationInfo (),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetParkingStationInfoResult::GetParkingStationInfoResult (const GetParkingStationInfoResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ParkingStationInfo (),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetParkingStationInfoResult::GetParkingStationInfoResult (const ::sxm_parking_main_fi_types::T_ParkingInfo& ParkingStationInfo_, uint32 ListID_)  :
    _ParkingStationInfo (ParkingStationInfo_),
    _ListID (ListID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetParkingStationInfoResult::~GetParkingStationInfoResult() {
}

inline GetParkingStationInfoResult& GetParkingStationInfoResult::operator = (const GetParkingStationInfoResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasParkingStationInfo()) {
            setParkingStationInfo(rhs.getParkingStationInfo());
        } else {
            clearParkingStationInfo();
        }
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
    }
    return *this;
}

inline bool GetParkingStationInfoResult::operator == (const GetParkingStationInfoResult& rhs) const {
    return (((!hasParkingStationInfo() && !rhs.hasParkingStationInfo()) || getParkingStationInfo() == rhs.getParkingStationInfo()) &&
        ((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()));
}

inline bool GetParkingStationInfoResult::operator != (const GetParkingStationInfoResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetParkingStationInfoResult::operator < (const GetParkingStationInfoResult& rhs) const {
    if (hasParkingStationInfo() || rhs.hasParkingStationInfo()) {
        if (getParkingStationInfo() < rhs.getParkingStationInfo()) return true;
        if (getParkingStationInfo() > rhs.getParkingStationInfo()) return false;
    }
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetParkingStationInfoResult::clone() {
    return new GetParkingStationInfoResult(*this);
}

inline bool GetParkingStationInfoResult::operator > (const GetParkingStationInfoResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetParkingStationInfoResult::clear() {
    clearParkingStationInfo();
    clearListID();
}

inline void GetParkingStationInfoResult::clearParkingStationInfo() {
    if (hasParkingStationInfo()) {
         clear_has_ParkingStationInfo();
        _ParkingStationInfo.clear();
     }
}

inline bool GetParkingStationInfoResult::hasParkingStationInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_parking_main_fi_types::T_ParkingInfo& GetParkingStationInfoResult::getParkingStationInfo () const {
    return _ParkingStationInfo;
}

inline ::sxm_parking_main_fi_types::T_ParkingInfo& GetParkingStationInfoResult::getParkingStationInfoMutable () {
    set_has_ParkingStationInfo();
    return _ParkingStationInfo;
}

inline void GetParkingStationInfoResult::setParkingStationInfo (const ::sxm_parking_main_fi_types::T_ParkingInfo& ParkingStationInfo_) {
    set_has_ParkingStationInfo();
    this->_ParkingStationInfo = ParkingStationInfo_;
}

inline void GetParkingStationInfoResult::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetParkingStationInfoResult::hasListID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetParkingStationInfoResult::getListID () const {
    return _ListID;
}

inline void GetParkingStationInfoResult::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetParkingStationInfoResult::set_has_ParkingStationInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetParkingStationInfoResult::clear_has_ParkingStationInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetParkingStationInfoResult::set_has_ListID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetParkingStationInfoResult::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetParkingStationInfoErrorStructure::GetParkingStationInfoErrorStructure ()  :
    _ErrorCode (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes__PARKING_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetParkingStationInfoErrorStructure::GetParkingStationInfoErrorStructure (const GetParkingStationInfoErrorStructure &rhs)  :
    _ErrorCode (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes__PARKING_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetParkingStationInfoErrorStructure::GetParkingStationInfoErrorStructure (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_parking_main_fi_types::T_e8ParkingErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8ParkingErrorTypes", "ErrorCode", "GetParkingStationInfoErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetParkingStationInfoErrorStructure::~GetParkingStationInfoErrorStructure() {
}

inline GetParkingStationInfoErrorStructure& GetParkingStationInfoErrorStructure::operator = (const GetParkingStationInfoErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetParkingStationInfoErrorStructure::operator == (const GetParkingStationInfoErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetParkingStationInfoErrorStructure::operator != (const GetParkingStationInfoErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetParkingStationInfoErrorStructure::operator < (const GetParkingStationInfoErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetParkingStationInfoErrorStructure::operator > (const GetParkingStationInfoErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetParkingStationInfoErrorStructure::clear() {
    clearErrorCode();
}

inline void GetParkingStationInfoErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_parking_main_fi_types::T_e8ParkingErrorTypes__PARKING_INFOLIST_EMPTY;
     }
}

inline bool GetParkingStationInfoErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_parking_main_fi_types::T_e8ParkingErrorTypes GetParkingStationInfoErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetParkingStationInfoErrorStructure::setErrorCode (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_parking_main_fi_types::T_e8ParkingErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8ParkingErrorTypes", "ErrorCode", "GetParkingStationInfoErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetParkingStationInfoErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetParkingStationInfoErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetParkingStationInfoError::GetParkingStationInfoError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetParkingStationInfoError::GetParkingStationInfoError (const GetParkingStationInfoError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetParkingStationInfoError::~GetParkingStationInfoError() {
    deleteData ();
}

inline GetParkingStationInfoError& GetParkingStationInfoError::operator = (const GetParkingStationInfoError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetParkingStationInfoError::operator == (const GetParkingStationInfoError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetParkingStationInfoError::operator != (const GetParkingStationInfoError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetParkingStationInfoError::operator < (const GetParkingStationInfoError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetParkingStationInfoError::operator > (const GetParkingStationInfoError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetParkingStationInfoError::GetParkingStationInfoErrorField GetParkingStationInfoError::getField () const {
    return __field;
}

inline void GetParkingStationInfoError::setField(GetParkingStationInfoError::GetParkingStationInfoErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetParkingStationInfoError::clone() {
    return new GetParkingStationInfoError(*this);
}

inline bool GetParkingStationInfoError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetParkingStationInfoErrorStructure& GetParkingStationInfoError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetParkingStationInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetParkingStationInfoErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetParkingStationInfoErrorStructure& GetParkingStationInfoError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetParkingStationInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetParkingStationInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetParkingStationInfoErrorStructure* GetParkingStationInfoError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetParkingStationInfoError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetParkingStationInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetParkingStationInfoErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetParkingStationInfoError::replaceCcaErrorCode (GetParkingStationInfoErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetParkingStationInfoError::setCcaErrorCode (const GetParkingStationInfoErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetParkingStationInfoErrorStructure(value);
    }
}

inline bool GetParkingStationInfoError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetParkingStationInfoError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetParkingStationInfoError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetParkingStationInfoError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetParkingStationInfoError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetParkingStationInfoError::cloneData (const GetParkingStationInfoError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetParkingStationInfoErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetParkingStationInfoErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetParkingStationInfoError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  AddFavoriteStart::AddFavoriteStart ()  :
    _ParkingID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteStart::AddFavoriteStart (const AddFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ParkingID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteStart::AddFavoriteStart (uint32 ParkingID_)  :
    _ParkingID (ParkingID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteStart::~AddFavoriteStart() {
}

inline AddFavoriteStart& AddFavoriteStart::operator = (const AddFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasParkingID()) {
            setParkingID(rhs.getParkingID());
        } else {
            clearParkingID();
        }
    }
    return *this;
}

inline bool AddFavoriteStart::operator == (const AddFavoriteStart& rhs) const {
    return (((!hasParkingID() && !rhs.hasParkingID()) || getParkingID() == rhs.getParkingID()));
}

inline bool AddFavoriteStart::operator != (const AddFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteStart::operator < (const AddFavoriteStart& rhs) const {
    if (hasParkingID() || rhs.hasParkingID()) {
        if (getParkingID() < rhs.getParkingID()) return true;
        if (getParkingID() > rhs.getParkingID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddFavoriteStart::clone() {
    return new AddFavoriteStart(*this);
}

inline bool AddFavoriteStart::operator > (const AddFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteStart::clear() {
    clearParkingID();
}

inline void AddFavoriteStart::clearParkingID() {
    if (hasParkingID()) {
         clear_has_ParkingID();
        _ParkingID = 0u;
     }
}

inline bool AddFavoriteStart::hasParkingID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AddFavoriteStart::getParkingID () const {
    return _ParkingID;
}

inline void AddFavoriteStart::setParkingID (uint32 ParkingID_) {
    set_has_ParkingID();
    this->_ParkingID = ParkingID_;
}

inline void AddFavoriteStart::set_has_ParkingID () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteStart::clear_has_ParkingID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddFavoriteResult::AddFavoriteResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteResult::AddFavoriteResult (const AddFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteResult::AddFavoriteResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteResult::~AddFavoriteResult() {
}

inline AddFavoriteResult& AddFavoriteResult::operator = (const AddFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool AddFavoriteResult::operator == (const AddFavoriteResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool AddFavoriteResult::operator != (const AddFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteResult::operator < (const AddFavoriteResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddFavoriteResult::clone() {
    return new AddFavoriteResult(*this);
}

inline bool AddFavoriteResult::operator > (const AddFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteResult::clear() {
    clearStatus();
}

inline void AddFavoriteResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool AddFavoriteResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AddFavoriteResult::getStatus () const {
    return _Status;
}

inline void AddFavoriteResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void AddFavoriteResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteStart::RemoveFavoriteStart ()  :
    _ParkingID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteStart::RemoveFavoriteStart (const RemoveFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ParkingID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteStart::RemoveFavoriteStart (uint32 ParkingID_)  :
    _ParkingID (ParkingID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteStart::~RemoveFavoriteStart() {
}

inline RemoveFavoriteStart& RemoveFavoriteStart::operator = (const RemoveFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasParkingID()) {
            setParkingID(rhs.getParkingID());
        } else {
            clearParkingID();
        }
    }
    return *this;
}

inline bool RemoveFavoriteStart::operator == (const RemoveFavoriteStart& rhs) const {
    return (((!hasParkingID() && !rhs.hasParkingID()) || getParkingID() == rhs.getParkingID()));
}

inline bool RemoveFavoriteStart::operator != (const RemoveFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteStart::operator < (const RemoveFavoriteStart& rhs) const {
    if (hasParkingID() || rhs.hasParkingID()) {
        if (getParkingID() < rhs.getParkingID()) return true;
        if (getParkingID() > rhs.getParkingID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveFavoriteStart::clone() {
    return new RemoveFavoriteStart(*this);
}

inline bool RemoveFavoriteStart::operator > (const RemoveFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteStart::clear() {
    clearParkingID();
}

inline void RemoveFavoriteStart::clearParkingID() {
    if (hasParkingID()) {
         clear_has_ParkingID();
        _ParkingID = 0u;
     }
}

inline bool RemoveFavoriteStart::hasParkingID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RemoveFavoriteStart::getParkingID () const {
    return _ParkingID;
}

inline void RemoveFavoriteStart::setParkingID (uint32 ParkingID_) {
    set_has_ParkingID();
    this->_ParkingID = ParkingID_;
}

inline void RemoveFavoriteStart::set_has_ParkingID () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteStart::clear_has_ParkingID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteResult::RemoveFavoriteResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteResult::RemoveFavoriteResult (const RemoveFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteResult::RemoveFavoriteResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteResult::~RemoveFavoriteResult() {
}

inline RemoveFavoriteResult& RemoveFavoriteResult::operator = (const RemoveFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool RemoveFavoriteResult::operator == (const RemoveFavoriteResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool RemoveFavoriteResult::operator != (const RemoveFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteResult::operator < (const RemoveFavoriteResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveFavoriteResult::clone() {
    return new RemoveFavoriteResult(*this);
}

inline bool RemoveFavoriteResult::operator > (const RemoveFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteResult::clear() {
    clearStatus();
}

inline void RemoveFavoriteResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool RemoveFavoriteResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RemoveFavoriteResult::getStatus () const {
    return _Status;
}

inline void RemoveFavoriteResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void RemoveFavoriteResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetFilterConfigStart::SetFilterConfigStart ()  :
    _FilterConfig ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFilterConfigStart::SetFilterConfigStart (const SetFilterConfigStart &rhs)  :
    ::asf::core::Payload(rhs),
    _FilterConfig ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFilterConfigStart::SetFilterConfigStart (const ::sxm_parking_main_fi_types::T_FilterConfig& FilterConfig_)  :
    _FilterConfig (FilterConfig_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFilterConfigStart::~SetFilterConfigStart() {
}

inline SetFilterConfigStart& SetFilterConfigStart::operator = (const SetFilterConfigStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFilterConfig()) {
            setFilterConfig(rhs.getFilterConfig());
        } else {
            clearFilterConfig();
        }
    }
    return *this;
}

inline bool SetFilterConfigStart::operator == (const SetFilterConfigStart& rhs) const {
    return (((!hasFilterConfig() && !rhs.hasFilterConfig()) || getFilterConfig() == rhs.getFilterConfig()));
}

inline bool SetFilterConfigStart::operator != (const SetFilterConfigStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFilterConfigStart::operator < (const SetFilterConfigStart& rhs) const {
    if (hasFilterConfig() || rhs.hasFilterConfig()) {
        if (getFilterConfig() < rhs.getFilterConfig()) return true;
        if (getFilterConfig() > rhs.getFilterConfig()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFilterConfigStart::clone() {
    return new SetFilterConfigStart(*this);
}

inline bool SetFilterConfigStart::operator > (const SetFilterConfigStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFilterConfigStart::clear() {
    clearFilterConfig();
}

inline void SetFilterConfigStart::clearFilterConfig() {
    if (hasFilterConfig()) {
         clear_has_FilterConfig();
        _FilterConfig.clear();
     }
}

inline bool SetFilterConfigStart::hasFilterConfig () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_parking_main_fi_types::T_FilterConfig& SetFilterConfigStart::getFilterConfig () const {
    return _FilterConfig;
}

inline ::sxm_parking_main_fi_types::T_FilterConfig& SetFilterConfigStart::getFilterConfigMutable () {
    set_has_FilterConfig();
    return _FilterConfig;
}

inline void SetFilterConfigStart::setFilterConfig (const ::sxm_parking_main_fi_types::T_FilterConfig& FilterConfig_) {
    set_has_FilterConfig();
    this->_FilterConfig = FilterConfig_;
}

inline void SetFilterConfigStart::set_has_FilterConfig () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFilterConfigStart::clear_has_FilterConfig () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetFilterConfigResult::SetFilterConfigResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFilterConfigResult::SetFilterConfigResult (const SetFilterConfigResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFilterConfigResult::SetFilterConfigResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFilterConfigResult::~SetFilterConfigResult() {
}

inline SetFilterConfigResult& SetFilterConfigResult::operator = (const SetFilterConfigResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SetFilterConfigResult::operator == (const SetFilterConfigResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SetFilterConfigResult::operator != (const SetFilterConfigResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFilterConfigResult::operator < (const SetFilterConfigResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFilterConfigResult::clone() {
    return new SetFilterConfigResult(*this);
}

inline bool SetFilterConfigResult::operator > (const SetFilterConfigResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFilterConfigResult::clear() {
    clearStatus();
}

inline void SetFilterConfigResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool SetFilterConfigResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetFilterConfigResult::getStatus () const {
    return _Status;
}

inline void SetFilterConfigResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void SetFilterConfigResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFilterConfigResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestoreFavoritesStart::RestoreFavoritesStart ()  :
    _FavoriteList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestoreFavoritesStart::RestoreFavoritesStart (const RestoreFavoritesStart &rhs)  :
    ::asf::core::Payload(rhs),
    _FavoriteList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestoreFavoritesStart::RestoreFavoritesStart (const ::std::vector< uint32 >& FavoriteList_)  :
    _FavoriteList (FavoriteList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestoreFavoritesStart::~RestoreFavoritesStart() {
}

inline RestoreFavoritesStart& RestoreFavoritesStart::operator = (const RestoreFavoritesStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFavoriteList()) {
            setFavoriteList(rhs.getFavoriteList());
        } else {
            clearFavoriteList();
        }
    }
    return *this;
}

inline bool RestoreFavoritesStart::operator == (const RestoreFavoritesStart& rhs) const {
    return (((!hasFavoriteList() && !rhs.hasFavoriteList()) || getFavoriteList() == rhs.getFavoriteList()));
}

inline bool RestoreFavoritesStart::operator != (const RestoreFavoritesStart& rhs) const {
    return ! (*this == rhs);
}

inline bool RestoreFavoritesStart::operator < (const RestoreFavoritesStart& rhs) const {
    if (hasFavoriteList() || rhs.hasFavoriteList()) {
        if (getFavoriteList() < rhs.getFavoriteList()) return true;
        if (getFavoriteList() > rhs.getFavoriteList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RestoreFavoritesStart::clone() {
    return new RestoreFavoritesStart(*this);
}

inline bool RestoreFavoritesStart::operator > (const RestoreFavoritesStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestoreFavoritesStart::clear() {
    clearFavoriteList();
}

inline void RestoreFavoritesStart::clearFavoriteList() {
    if (hasFavoriteList()) {
         clear_has_FavoriteList();
        _FavoriteList.clear();
     }
}

inline bool RestoreFavoritesStart::hasFavoriteList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint32 >& RestoreFavoritesStart::getFavoriteList () const {
    return _FavoriteList;
}

inline ::std::vector< uint32 >& RestoreFavoritesStart::getFavoriteListMutable () {
    set_has_FavoriteList();
    return _FavoriteList;
}

inline void RestoreFavoritesStart::setFavoriteList (const ::std::vector< uint32 >& FavoriteList_) {
    set_has_FavoriteList();
    this->_FavoriteList = FavoriteList_;
}

inline void RestoreFavoritesStart::set_has_FavoriteList () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestoreFavoritesStart::clear_has_FavoriteList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestoreFavoritesResult::RestoreFavoritesResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestoreFavoritesResult::RestoreFavoritesResult (const RestoreFavoritesResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestoreFavoritesResult::RestoreFavoritesResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestoreFavoritesResult::~RestoreFavoritesResult() {
}

inline RestoreFavoritesResult& RestoreFavoritesResult::operator = (const RestoreFavoritesResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool RestoreFavoritesResult::operator == (const RestoreFavoritesResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool RestoreFavoritesResult::operator != (const RestoreFavoritesResult& rhs) const {
    return ! (*this == rhs);
}

inline bool RestoreFavoritesResult::operator < (const RestoreFavoritesResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RestoreFavoritesResult::clone() {
    return new RestoreFavoritesResult(*this);
}

inline bool RestoreFavoritesResult::operator > (const RestoreFavoritesResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestoreFavoritesResult::clear() {
    clearStatus();
}

inline void RestoreFavoritesResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool RestoreFavoritesResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RestoreFavoritesResult::getStatus () const {
    return _Status;
}

inline void RestoreFavoritesResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void RestoreFavoritesResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestoreFavoritesResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestoreFavoritesErrorStructure::RestoreFavoritesErrorStructure ()  :
    _ErrorCode (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes__PARKING_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestoreFavoritesErrorStructure::RestoreFavoritesErrorStructure (const RestoreFavoritesErrorStructure &rhs)  :
    _ErrorCode (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes__PARKING_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestoreFavoritesErrorStructure::RestoreFavoritesErrorStructure (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_parking_main_fi_types::T_e8ParkingErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8ParkingErrorTypes", "ErrorCode", "RestoreFavoritesErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestoreFavoritesErrorStructure::~RestoreFavoritesErrorStructure() {
}

inline RestoreFavoritesErrorStructure& RestoreFavoritesErrorStructure::operator = (const RestoreFavoritesErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool RestoreFavoritesErrorStructure::operator == (const RestoreFavoritesErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool RestoreFavoritesErrorStructure::operator != (const RestoreFavoritesErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool RestoreFavoritesErrorStructure::operator < (const RestoreFavoritesErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool RestoreFavoritesErrorStructure::operator > (const RestoreFavoritesErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestoreFavoritesErrorStructure::clear() {
    clearErrorCode();
}

inline void RestoreFavoritesErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_parking_main_fi_types::T_e8ParkingErrorTypes__PARKING_INFOLIST_EMPTY;
     }
}

inline bool RestoreFavoritesErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_parking_main_fi_types::T_e8ParkingErrorTypes RestoreFavoritesErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void RestoreFavoritesErrorStructure::setErrorCode (::sxm_parking_main_fi_types::T_e8ParkingErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_parking_main_fi_types::T_e8ParkingErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8ParkingErrorTypes", "ErrorCode", "RestoreFavoritesErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void RestoreFavoritesErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestoreFavoritesErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestoreFavoritesError::RestoreFavoritesError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  RestoreFavoritesError::RestoreFavoritesError (const RestoreFavoritesError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  RestoreFavoritesError::~RestoreFavoritesError() {
    deleteData ();
}

inline RestoreFavoritesError& RestoreFavoritesError::operator = (const RestoreFavoritesError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool RestoreFavoritesError::operator == (const RestoreFavoritesError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool RestoreFavoritesError::operator != (const RestoreFavoritesError& rhs) const {
    return ! (*this == rhs);
}

inline bool RestoreFavoritesError::operator < (const RestoreFavoritesError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool RestoreFavoritesError::operator > (const RestoreFavoritesError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline RestoreFavoritesError::RestoreFavoritesErrorField RestoreFavoritesError::getField () const {
    return __field;
}

inline void RestoreFavoritesError::setField(RestoreFavoritesError::RestoreFavoritesErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* RestoreFavoritesError::clone() {
    return new RestoreFavoritesError(*this);
}

inline bool RestoreFavoritesError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const RestoreFavoritesErrorStructure& RestoreFavoritesError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RestoreFavoritesError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return RestoreFavoritesErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline RestoreFavoritesErrorStructure& RestoreFavoritesError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RestoreFavoritesError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new RestoreFavoritesErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline RestoreFavoritesErrorStructure* RestoreFavoritesError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'RestoreFavoritesError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new RestoreFavoritesErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        RestoreFavoritesErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void RestoreFavoritesError::replaceCcaErrorCode (RestoreFavoritesErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void RestoreFavoritesError::setCcaErrorCode (const RestoreFavoritesErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new RestoreFavoritesErrorStructure(value);
    }
}

inline bool RestoreFavoritesError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode RestoreFavoritesError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "RestoreFavoritesError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void RestoreFavoritesError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "RestoreFavoritesError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void RestoreFavoritesError::cloneData (const RestoreFavoritesError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new RestoreFavoritesErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new RestoreFavoritesErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void RestoreFavoritesError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SetFilterConfigurationStart::SetFilterConfigurationStart ()  :
    _FilterConfig ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFilterConfigurationStart::SetFilterConfigurationStart (const SetFilterConfigurationStart &rhs)  :
    ::asf::core::Payload(rhs),
    _FilterConfig ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFilterConfigurationStart::SetFilterConfigurationStart (const ::sxm_parking_main_fi_types::T_FilterConfiguration& FilterConfig_)  :
    _FilterConfig (FilterConfig_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFilterConfigurationStart::~SetFilterConfigurationStart() {
}

inline SetFilterConfigurationStart& SetFilterConfigurationStart::operator = (const SetFilterConfigurationStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFilterConfig()) {
            setFilterConfig(rhs.getFilterConfig());
        } else {
            clearFilterConfig();
        }
    }
    return *this;
}

inline bool SetFilterConfigurationStart::operator == (const SetFilterConfigurationStart& rhs) const {
    return (((!hasFilterConfig() && !rhs.hasFilterConfig()) || getFilterConfig() == rhs.getFilterConfig()));
}

inline bool SetFilterConfigurationStart::operator != (const SetFilterConfigurationStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFilterConfigurationStart::operator < (const SetFilterConfigurationStart& rhs) const {
    if (hasFilterConfig() || rhs.hasFilterConfig()) {
        if (getFilterConfig() < rhs.getFilterConfig()) return true;
        if (getFilterConfig() > rhs.getFilterConfig()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFilterConfigurationStart::clone() {
    return new SetFilterConfigurationStart(*this);
}

inline bool SetFilterConfigurationStart::operator > (const SetFilterConfigurationStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFilterConfigurationStart::clear() {
    clearFilterConfig();
}

inline void SetFilterConfigurationStart::clearFilterConfig() {
    if (hasFilterConfig()) {
         clear_has_FilterConfig();
        _FilterConfig.clear();
     }
}

inline bool SetFilterConfigurationStart::hasFilterConfig () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_parking_main_fi_types::T_FilterConfiguration& SetFilterConfigurationStart::getFilterConfig () const {
    return _FilterConfig;
}

inline ::sxm_parking_main_fi_types::T_FilterConfiguration& SetFilterConfigurationStart::getFilterConfigMutable () {
    set_has_FilterConfig();
    return _FilterConfig;
}

inline void SetFilterConfigurationStart::setFilterConfig (const ::sxm_parking_main_fi_types::T_FilterConfiguration& FilterConfig_) {
    set_has_FilterConfig();
    this->_FilterConfig = FilterConfig_;
}

inline void SetFilterConfigurationStart::set_has_FilterConfig () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFilterConfigurationStart::clear_has_FilterConfig () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetFilterConfigurationResult::SetFilterConfigurationResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFilterConfigurationResult::SetFilterConfigurationResult (const SetFilterConfigurationResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFilterConfigurationResult::SetFilterConfigurationResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFilterConfigurationResult::~SetFilterConfigurationResult() {
}

inline SetFilterConfigurationResult& SetFilterConfigurationResult::operator = (const SetFilterConfigurationResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SetFilterConfigurationResult::operator == (const SetFilterConfigurationResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SetFilterConfigurationResult::operator != (const SetFilterConfigurationResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFilterConfigurationResult::operator < (const SetFilterConfigurationResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFilterConfigurationResult::clone() {
    return new SetFilterConfigurationResult(*this);
}

inline bool SetFilterConfigurationResult::operator > (const SetFilterConfigurationResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFilterConfigurationResult::clear() {
    clearStatus();
}

inline void SetFilterConfigurationResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool SetFilterConfigurationResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetFilterConfigurationResult::getStatus () const {
    return _Status;
}

inline void SetFilterConfigurationResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void SetFilterConfigurationResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFilterConfigurationResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ParkingInfoListsStatusStatus::ParkingInfoListsStatusStatus ()  :
    _InfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ParkingInfoListsStatusStatus::ParkingInfoListsStatusStatus (const ParkingInfoListsStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _InfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ParkingInfoListsStatusStatus::ParkingInfoListsStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& InfoList_)  :
    _InfoList (InfoList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ParkingInfoListsStatusStatus::~ParkingInfoListsStatusStatus() {
}

inline ParkingInfoListsStatusStatus& ParkingInfoListsStatusStatus::operator = (const ParkingInfoListsStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInfoList()) {
            setInfoList(rhs.getInfoList());
        } else {
            clearInfoList();
        }
    }
    return *this;
}

inline bool ParkingInfoListsStatusStatus::operator == (const ParkingInfoListsStatusStatus& rhs) const {
    return (((!hasInfoList() && !rhs.hasInfoList()) || getInfoList() == rhs.getInfoList()));
}

inline bool ParkingInfoListsStatusStatus::operator != (const ParkingInfoListsStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ParkingInfoListsStatusStatus::operator < (const ParkingInfoListsStatusStatus& rhs) const {
    if (hasInfoList() || rhs.hasInfoList()) {
        if (getInfoList() < rhs.getInfoList()) return true;
        if (getInfoList() > rhs.getInfoList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ParkingInfoListsStatusStatus::clone() {
    return new ParkingInfoListsStatusStatus(*this);
}

inline bool ParkingInfoListsStatusStatus::operator > (const ParkingInfoListsStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ParkingInfoListsStatusStatus::clear() {
    clearInfoList();
}

inline void ParkingInfoListsStatusStatus::clearInfoList() {
    if (hasInfoList()) {
         clear_has_InfoList();
        _InfoList.clear();
     }
}

inline bool ParkingInfoListsStatusStatus::hasInfoList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListInfos& ParkingInfoListsStatusStatus::getInfoList () const {
    return _InfoList;
}

inline ::sxm_main_fi_types::T_SxmListInfos& ParkingInfoListsStatusStatus::getInfoListMutable () {
    set_has_InfoList();
    return _InfoList;
}

inline void ParkingInfoListsStatusStatus::setInfoList (const ::sxm_main_fi_types::T_SxmListInfos& InfoList_) {
    set_has_InfoList();
    this->_InfoList = InfoList_;
}

inline void ParkingInfoListsStatusStatus::set_has_InfoList () {
    _has_bits_[0] |= 1u << 0;
}

inline void ParkingInfoListsStatusStatus::clear_has_InfoList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus ()  :
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_)  :
    _DataServiceState (DataServiceState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::~SxmDataServiceStatusStatus() {
}

inline SxmDataServiceStatusStatus& SxmDataServiceStatusStatus::operator = (const SxmDataServiceStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataServiceState()) {
            setDataServiceState(rhs.getDataServiceState());
        } else {
            clearDataServiceState();
        }
    }
    return *this;
}

inline bool SxmDataServiceStatusStatus::operator == (const SxmDataServiceStatusStatus& rhs) const {
    return (((!hasDataServiceState() && !rhs.hasDataServiceState()) || getDataServiceState() == rhs.getDataServiceState()));
}

inline bool SxmDataServiceStatusStatus::operator != (const SxmDataServiceStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmDataServiceStatusStatus::operator < (const SxmDataServiceStatusStatus& rhs) const {
    if (hasDataServiceState() || rhs.hasDataServiceState()) {
        if (getDataServiceState() < rhs.getDataServiceState()) return true;
        if (getDataServiceState() > rhs.getDataServiceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmDataServiceStatusStatus::clone() {
    return new SxmDataServiceStatusStatus(*this);
}

inline bool SxmDataServiceStatusStatus::operator > (const SxmDataServiceStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmDataServiceStatusStatus::clear() {
    clearDataServiceState();
}

inline void SxmDataServiceStatusStatus::clearDataServiceState() {
    if (hasDataServiceState()) {
         clear_has_DataServiceState();
        _DataServiceState.clear();
     }
}

inline bool SxmDataServiceStatusStatus::hasDataServiceState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceState () const {
    return _DataServiceState;
}

inline ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceStateMutable () {
    set_has_DataServiceState();
    return _DataServiceState;
}

inline void SxmDataServiceStatusStatus::setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_) {
    set_has_DataServiceState();
    this->_DataServiceState = DataServiceState_;
}

inline void SxmDataServiceStatusStatus::set_has_DataServiceState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmDataServiceStatusStatus::clear_has_DataServiceState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeStatus::SxmListModeStatus ()  :
    _ListMode (),
    _DummyData (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeStatus::SxmListModeStatus (const SxmListModeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode (),
    _DummyData (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeStatus::SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_, bool DummyData_)  :
    _ListMode (ListMode_),
    _DummyData (DummyData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeStatus::~SxmListModeStatus() {
}

inline SxmListModeStatus& SxmListModeStatus::operator = (const SxmListModeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
        if (rhs.hasDummyData()) {
            setDummyData(rhs.getDummyData());
        } else {
            clearDummyData();
        }
    }
    return *this;
}

inline bool SxmListModeStatus::operator == (const SxmListModeStatus& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()) &&
        ((!hasDummyData() && !rhs.hasDummyData()) || getDummyData() == rhs.getDummyData()));
}

inline bool SxmListModeStatus::operator != (const SxmListModeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeStatus::operator < (const SxmListModeStatus& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    if (hasDummyData() || rhs.hasDummyData()) {
        if (getDummyData() < rhs.getDummyData()) return true;
        if (getDummyData() > rhs.getDummyData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeStatus::clone() {
    return new SxmListModeStatus(*this);
}

inline bool SxmListModeStatus::operator > (const SxmListModeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeStatus::clear() {
    clearListMode();
    clearDummyData();
}

inline void SxmListModeStatus::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeStatus::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeStatus::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeStatus::clearDummyData() {
    if (hasDummyData()) {
         clear_has_DummyData();
        _DummyData = false;
     }
}

inline bool SxmListModeStatus::hasDummyData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SxmListModeStatus::getDummyData () const {
    return _DummyData;
}

inline void SxmListModeStatus::setDummyData (bool DummyData_) {
    set_has_DummyData();
    this->_DummyData = DummyData_;
}

inline void SxmListModeStatus::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeStatus::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SxmListModeStatus::set_has_DummyData () {
    _has_bits_[0] |= 1u << 1;
}

inline void SxmListModeStatus::clear_has_DummyData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SxmListModeSet::SxmListModeSet ()  :
    _ListMode (),
    _DummyData (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeSet::SxmListModeSet (const SxmListModeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode (),
    _DummyData (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeSet::SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_, bool DummyData_)  :
    _ListMode (ListMode_),
    _DummyData (DummyData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeSet::~SxmListModeSet() {
}

inline SxmListModeSet& SxmListModeSet::operator = (const SxmListModeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
        if (rhs.hasDummyData()) {
            setDummyData(rhs.getDummyData());
        } else {
            clearDummyData();
        }
    }
    return *this;
}

inline bool SxmListModeSet::operator == (const SxmListModeSet& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()) &&
        ((!hasDummyData() && !rhs.hasDummyData()) || getDummyData() == rhs.getDummyData()));
}

inline bool SxmListModeSet::operator != (const SxmListModeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeSet::operator < (const SxmListModeSet& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    if (hasDummyData() || rhs.hasDummyData()) {
        if (getDummyData() < rhs.getDummyData()) return true;
        if (getDummyData() > rhs.getDummyData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeSet::clone() {
    return new SxmListModeSet(*this);
}

inline bool SxmListModeSet::operator > (const SxmListModeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeSet::clear() {
    clearListMode();
    clearDummyData();
}

inline void SxmListModeSet::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeSet::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeSet::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeSet::clearDummyData() {
    if (hasDummyData()) {
         clear_has_DummyData();
        _DummyData = false;
     }
}

inline bool SxmListModeSet::hasDummyData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SxmListModeSet::getDummyData () const {
    return _DummyData;
}

inline void SxmListModeSet::setDummyData (bool DummyData_) {
    set_has_DummyData();
    this->_DummyData = DummyData_;
}

inline void SxmListModeSet::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeSet::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SxmListModeSet::set_has_DummyData () {
    _has_bits_[0] |= 1u << 1;
}

inline void SxmListModeSet::clear_has_DummyData () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace sxm_parking_main_fi

#endif // SXM_PARKING_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
