#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_MOVIES_MAIN_FI_TYPES_H
#define SXM_MOVIES_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_main_fi_types.h"
#include "sxm_movies_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sxm_movies_main_fi_types
 */

namespace sxm_movies_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_TheatreInfo;

class T_MovieInfo;

class T_TheatreDetails;

class T_ShowDate;

class T_ShowTimes;

class T_MovieTimes;

class T_MovieDetails;

// type definitions
/**
 * If the meaning of "T_MovieTimesList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MovieTimes > T_MovieTimesList;

/**
 * If the meaning of "T_TheatreInfoList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TheatreInfo > T_TheatreInfoList;

/**
 * If the meaning of "T_MoviesList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MovieInfo > T_MoviesList;


/**
 * If the meaning of "T_TheatreInfo" isn't clear, then there should be a description here.
 */
class T_TheatreInfo {
public:

    /**
     * Default constructor
     */
    inline  T_TheatreInfo ();

    /**
     * Copy constructor
     */
    inline  T_TheatreInfo (const T_TheatreInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_TheatreInfo (uint32 Theater_LOCID_, const ::std::string& TheatreName_, const ::std::string& TheaterCity_, float Distance_, const ::sxm_main_fi_types::T_SxmLocation& TheaterLocation_);

    /**
     * Destructor
     */
    inline  ~T_TheatreInfo();

    /**
     * Assignment operator
     */
    inline T_TheatreInfo& operator = (const T_TheatreInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TheatreInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TheatreInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TheatreInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TheatreInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Theater_LOCID"

    static const int kTheater_LOCID = 0;

    /**
     * Clears the field "Theater_LOCID".
     *
     * The field will be set to its default value. The hasTheater_LOCID()
     * method will return false.
     */
    inline void clearTheater_LOCID();

    /**
     * Checks whether the field "Theater_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheater_LOCID()). Otherwise it will return false.
     */
    inline bool hasTheater_LOCID () const;

    /**
     * Returns the value of the member "Theater_LOCID".
     *
     * Theatre Loc ID
     *
     * @return The value of the field "Theater_LOCID"
     */
    inline uint32 getTheater_LOCID () const;

    /**
     * Sets the value of the member "Theater_LOCID".
     *
     * Theatre Loc ID
     *
     * @param Theater_LOCID The value which will be set
     */
    inline void setTheater_LOCID (uint32 Theater_LOCID_);

    // API of field "TheatreName"

    static const int kTheatreName = 1;

    /**
     * Clears the field "TheatreName".
     *
     * The field will be set to its default value. The hasTheatreName()
     * method will return false.
     */
    inline void clearTheatreName();

    /**
     * Checks whether the field "TheatreName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheatreName()). Otherwise it will return false.
     */
    inline bool hasTheatreName () const;

    /**
     * Returns the value of the member "TheatreName".
     *
     * Theatre Name
     *
     * @return The value of the field "TheatreName"
     */
    inline const ::std::string& getTheatreName () const;

    /**
     * Retrieves the value of the field "TheatreName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheatreName".
     */
    inline ::std::string& getTheatreNameMutable ();

    /**
     * Sets the value of the member "TheatreName".
     *
     * Theatre Name
     *
     * @param TheatreName The value which will be set
     */
    inline void setTheatreName (const ::std::string& TheatreName_);

    /**
     * Sets the value of the member "TheatreName".
     *
     * Theatre Name
     *
     * @param TheatreName The value which will be set
     */
    inline void setTheatreName (const char* TheatreName_);

    /**
     * Sets the value of the member "TheatreName".
     *
     * Theatre Name
     *
     * @param TheatreName The value which will be set
     */
    inline void setTheatreName (const char* value, size_t size);

    // API of field "TheaterCity"

    static const int kTheaterCity = 2;

    /**
     * Clears the field "TheaterCity".
     *
     * The field will be set to its default value. The hasTheaterCity()
     * method will return false.
     */
    inline void clearTheaterCity();

    /**
     * Checks whether the field "TheaterCity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheaterCity()). Otherwise it will return false.
     */
    inline bool hasTheaterCity () const;

    /**
     * Returns the value of the member "TheaterCity".
     *
     * Theater City
     *
     * @return The value of the field "TheaterCity"
     */
    inline const ::std::string& getTheaterCity () const;

    /**
     * Retrieves the value of the field "TheaterCity" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheaterCity".
     */
    inline ::std::string& getTheaterCityMutable ();

    /**
     * Sets the value of the member "TheaterCity".
     *
     * Theater City
     *
     * @param TheaterCity The value which will be set
     */
    inline void setTheaterCity (const ::std::string& TheaterCity_);

    /**
     * Sets the value of the member "TheaterCity".
     *
     * Theater City
     *
     * @param TheaterCity The value which will be set
     */
    inline void setTheaterCity (const char* TheaterCity_);

    /**
     * Sets the value of the member "TheaterCity".
     *
     * Theater City
     *
     * @param TheaterCity The value which will be set
     */
    inline void setTheaterCity (const char* value, size_t size);

    // API of field "Distance"

    static const int kDistance = 3;

    /**
     * Clears the field "Distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "Distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "Distance".
     *
     * Distance from device position
     *
     * @return The value of the field "Distance"
     */
    inline float getDistance () const;

    /**
     * Sets the value of the member "Distance".
     *
     * Distance from device position
     *
     * @param Distance The value which will be set
     */
    inline void setDistance (float Distance_);

    // API of field "TheaterLocation"

    static const int kTheaterLocation = 4;

    /**
     * Clears the field "TheaterLocation".
     *
     * The field will be set to its default value. The hasTheaterLocation()
     * method will return false.
     */
    inline void clearTheaterLocation();

    /**
     * Checks whether the field "TheaterLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheaterLocation()). Otherwise it will return false.
     */
    inline bool hasTheaterLocation () const;

    /**
     * Returns the value of the member "TheaterLocation".
     *
     * Theatre Location information
     *
     * @return The value of the field "TheaterLocation"
     */
    inline const ::sxm_main_fi_types::T_SxmLocation& getTheaterLocation () const;

    /**
     * Retrieves the value of the field "TheaterLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheaterLocation".
     */
    inline ::sxm_main_fi_types::T_SxmLocation& getTheaterLocationMutable ();

    /**
     * Sets the value of the member "TheaterLocation".
     *
     * Theatre Location information
     *
     * @param TheaterLocation The value which will be set
     */
    inline void setTheaterLocation (const ::sxm_main_fi_types::T_SxmLocation& TheaterLocation_);

    static const T_TheatreInfo &getDefaultInstance();

private:

    inline void set_has_Theater_LOCID ();

    inline void clear_has_Theater_LOCID ();

    inline void set_has_TheatreName ();

    inline void clear_has_TheatreName ();

    inline void set_has_TheaterCity ();

    inline void clear_has_TheaterCity ();

    inline void set_has_Distance ();

    inline void clear_has_Distance ();

    inline void set_has_TheaterLocation ();

    inline void clear_has_TheaterLocation ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _Theater_LOCID;

    ::std::string _TheatreName;

    ::std::string _TheaterCity;

    float _Distance;

    ::sxm_main_fi_types::T_SxmLocation _TheaterLocation;

};

/**
 * If the meaning of "T_MovieInfo" isn't clear, then there should be a description here.
 */
class T_MovieInfo {
public:

    /**
     * Default constructor
     */
    inline  T_MovieInfo ();

    /**
     * Copy constructor
     */
    inline  T_MovieInfo (const T_MovieInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_MovieInfo (uint32 MOVIE_ID_, const ::std::string& MovieName_, const ::std::string& MovieRating_);

    /**
     * Destructor
     */
    inline  ~T_MovieInfo();

    /**
     * Assignment operator
     */
    inline T_MovieInfo& operator = (const T_MovieInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MovieInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MovieInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MovieInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MovieInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MOVIE_ID"

    static const int kMOVIE_ID = 0;

    /**
     * Clears the field "MOVIE_ID".
     *
     * The field will be set to its default value. The hasMOVIE_ID()
     * method will return false.
     */
    inline void clearMOVIE_ID();

    /**
     * Checks whether the field "MOVIE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMOVIE_ID()). Otherwise it will return false.
     */
    inline bool hasMOVIE_ID () const;

    /**
     * Returns the value of the member "MOVIE_ID".
     *
     * Theatre Loc ID
     *
     * @return The value of the field "MOVIE_ID"
     */
    inline uint32 getMOVIE_ID () const;

    /**
     * Sets the value of the member "MOVIE_ID".
     *
     * Theatre Loc ID
     *
     * @param MOVIE_ID The value which will be set
     */
    inline void setMOVIE_ID (uint32 MOVIE_ID_);

    // API of field "MovieName"

    static const int kMovieName = 1;

    /**
     * Clears the field "MovieName".
     *
     * The field will be set to its default value. The hasMovieName()
     * method will return false.
     */
    inline void clearMovieName();

    /**
     * Checks whether the field "MovieName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovieName()). Otherwise it will return false.
     */
    inline bool hasMovieName () const;

    /**
     * Returns the value of the member "MovieName".
     *
     * Movie Name
     *
     * @return The value of the field "MovieName"
     */
    inline const ::std::string& getMovieName () const;

    /**
     * Retrieves the value of the field "MovieName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MovieName".
     */
    inline ::std::string& getMovieNameMutable ();

    /**
     * Sets the value of the member "MovieName".
     *
     * Movie Name
     *
     * @param MovieName The value which will be set
     */
    inline void setMovieName (const ::std::string& MovieName_);

    /**
     * Sets the value of the member "MovieName".
     *
     * Movie Name
     *
     * @param MovieName The value which will be set
     */
    inline void setMovieName (const char* MovieName_);

    /**
     * Sets the value of the member "MovieName".
     *
     * Movie Name
     *
     * @param MovieName The value which will be set
     */
    inline void setMovieName (const char* value, size_t size);

    // API of field "MovieRating"

    static const int kMovieRating = 2;

    /**
     * Clears the field "MovieRating".
     *
     * The field will be set to its default value. The hasMovieRating()
     * method will return false.
     */
    inline void clearMovieRating();

    /**
     * Checks whether the field "MovieRating" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovieRating()). Otherwise it will return false.
     */
    inline bool hasMovieRating () const;

    /**
     * Returns the value of the member "MovieRating".
     *
     * Movie Rating
     *
     * @return The value of the field "MovieRating"
     */
    inline const ::std::string& getMovieRating () const;

    /**
     * Retrieves the value of the field "MovieRating" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MovieRating".
     */
    inline ::std::string& getMovieRatingMutable ();

    /**
     * Sets the value of the member "MovieRating".
     *
     * Movie Rating
     *
     * @param MovieRating The value which will be set
     */
    inline void setMovieRating (const ::std::string& MovieRating_);

    /**
     * Sets the value of the member "MovieRating".
     *
     * Movie Rating
     *
     * @param MovieRating The value which will be set
     */
    inline void setMovieRating (const char* MovieRating_);

    /**
     * Sets the value of the member "MovieRating".
     *
     * Movie Rating
     *
     * @param MovieRating The value which will be set
     */
    inline void setMovieRating (const char* value, size_t size);

    static const T_MovieInfo &getDefaultInstance();

private:

    inline void set_has_MOVIE_ID ();

    inline void clear_has_MOVIE_ID ();

    inline void set_has_MovieName ();

    inline void clear_has_MovieName ();

    inline void set_has_MovieRating ();

    inline void clear_has_MovieRating ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _MOVIE_ID;

    ::std::string _MovieName;

    ::std::string _MovieRating;

};

/**
 * If the meaning of "T_TheatreDetails" isn't clear, then there should be a description here.
 */
class T_TheatreDetails {
public:

    /**
     * Default constructor
     */
    inline  T_TheatreDetails ();

    /**
     * Copy constructor
     */
    inline  T_TheatreDetails (const T_TheatreDetails &rhs);

    /**
     * All fields constructor
     */
    inline  T_TheatreDetails (uint32 Theater_LOCID_, const ::std::string& TheatreName_, const ::std::string& TheatreStreetNum_, const ::std::string& TheatreStreetName_, const ::std::string& TheatreCity_, const ::std::string& TheatreState_, const ::std::string& TheatreZip_, const ::std::string& TheatrePhone_, bool isTheaterFavorite_, const ::sxm_main_fi_types::T_SxmLocation& TheaterLocation_, const ::std::vector< T_e8_TheatreAmenities >& TheaterAmenities_);

    /**
     * Destructor
     */
    inline  ~T_TheatreDetails();

    /**
     * Assignment operator
     */
    inline T_TheatreDetails& operator = (const T_TheatreDetails& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TheatreDetails& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TheatreDetails& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TheatreDetails& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TheatreDetails& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Theater_LOCID"

    static const int kTheater_LOCID = 0;

    /**
     * Clears the field "Theater_LOCID".
     *
     * The field will be set to its default value. The hasTheater_LOCID()
     * method will return false.
     */
    inline void clearTheater_LOCID();

    /**
     * Checks whether the field "Theater_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheater_LOCID()). Otherwise it will return false.
     */
    inline bool hasTheater_LOCID () const;

    /**
     * Returns the value of the member "Theater_LOCID".
     *
     * Theatre Loc ID
     *
     * @return The value of the field "Theater_LOCID"
     */
    inline uint32 getTheater_LOCID () const;

    /**
     * Sets the value of the member "Theater_LOCID".
     *
     * Theatre Loc ID
     *
     * @param Theater_LOCID The value which will be set
     */
    inline void setTheater_LOCID (uint32 Theater_LOCID_);

    // API of field "TheatreName"

    static const int kTheatreName = 1;

    /**
     * Clears the field "TheatreName".
     *
     * The field will be set to its default value. The hasTheatreName()
     * method will return false.
     */
    inline void clearTheatreName();

    /**
     * Checks whether the field "TheatreName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheatreName()). Otherwise it will return false.
     */
    inline bool hasTheatreName () const;

    /**
     * Returns the value of the member "TheatreName".
     *
     * Theatre Name
     *
     * @return The value of the field "TheatreName"
     */
    inline const ::std::string& getTheatreName () const;

    /**
     * Retrieves the value of the field "TheatreName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheatreName".
     */
    inline ::std::string& getTheatreNameMutable ();

    /**
     * Sets the value of the member "TheatreName".
     *
     * Theatre Name
     *
     * @param TheatreName The value which will be set
     */
    inline void setTheatreName (const ::std::string& TheatreName_);

    /**
     * Sets the value of the member "TheatreName".
     *
     * Theatre Name
     *
     * @param TheatreName The value which will be set
     */
    inline void setTheatreName (const char* TheatreName_);

    /**
     * Sets the value of the member "TheatreName".
     *
     * Theatre Name
     *
     * @param TheatreName The value which will be set
     */
    inline void setTheatreName (const char* value, size_t size);

    // API of field "TheatreStreetNum"

    static const int kTheatreStreetNum = 2;

    /**
     * Clears the field "TheatreStreetNum".
     *
     * The field will be set to its default value. The hasTheatreStreetNum()
     * method will return false.
     */
    inline void clearTheatreStreetNum();

    /**
     * Checks whether the field "TheatreStreetNum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheatreStreetNum()). Otherwise it will return false.
     */
    inline bool hasTheatreStreetNum () const;

    /**
     * Returns the value of the member "TheatreStreetNum".
     *
     * Theatre Street Number
     *
     * @return The value of the field "TheatreStreetNum"
     */
    inline const ::std::string& getTheatreStreetNum () const;

    /**
     * Retrieves the value of the field "TheatreStreetNum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheatreStreetNum".
     */
    inline ::std::string& getTheatreStreetNumMutable ();

    /**
     * Sets the value of the member "TheatreStreetNum".
     *
     * Theatre Street Number
     *
     * @param TheatreStreetNum The value which will be set
     */
    inline void setTheatreStreetNum (const ::std::string& TheatreStreetNum_);

    /**
     * Sets the value of the member "TheatreStreetNum".
     *
     * Theatre Street Number
     *
     * @param TheatreStreetNum The value which will be set
     */
    inline void setTheatreStreetNum (const char* TheatreStreetNum_);

    /**
     * Sets the value of the member "TheatreStreetNum".
     *
     * Theatre Street Number
     *
     * @param TheatreStreetNum The value which will be set
     */
    inline void setTheatreStreetNum (const char* value, size_t size);

    // API of field "TheatreStreetName"

    static const int kTheatreStreetName = 3;

    /**
     * Clears the field "TheatreStreetName".
     *
     * The field will be set to its default value. The hasTheatreStreetName()
     * method will return false.
     */
    inline void clearTheatreStreetName();

    /**
     * Checks whether the field "TheatreStreetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheatreStreetName()). Otherwise it will return false.
     */
    inline bool hasTheatreStreetName () const;

    /**
     * Returns the value of the member "TheatreStreetName".
     *
     * Theatre Street Name
     *
     * @return The value of the field "TheatreStreetName"
     */
    inline const ::std::string& getTheatreStreetName () const;

    /**
     * Retrieves the value of the field "TheatreStreetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheatreStreetName".
     */
    inline ::std::string& getTheatreStreetNameMutable ();

    /**
     * Sets the value of the member "TheatreStreetName".
     *
     * Theatre Street Name
     *
     * @param TheatreStreetName The value which will be set
     */
    inline void setTheatreStreetName (const ::std::string& TheatreStreetName_);

    /**
     * Sets the value of the member "TheatreStreetName".
     *
     * Theatre Street Name
     *
     * @param TheatreStreetName The value which will be set
     */
    inline void setTheatreStreetName (const char* TheatreStreetName_);

    /**
     * Sets the value of the member "TheatreStreetName".
     *
     * Theatre Street Name
     *
     * @param TheatreStreetName The value which will be set
     */
    inline void setTheatreStreetName (const char* value, size_t size);

    // API of field "TheatreCity"

    static const int kTheatreCity = 4;

    /**
     * Clears the field "TheatreCity".
     *
     * The field will be set to its default value. The hasTheatreCity()
     * method will return false.
     */
    inline void clearTheatreCity();

    /**
     * Checks whether the field "TheatreCity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheatreCity()). Otherwise it will return false.
     */
    inline bool hasTheatreCity () const;

    /**
     * Returns the value of the member "TheatreCity".
     *
     * Theatre City
     *
     * @return The value of the field "TheatreCity"
     */
    inline const ::std::string& getTheatreCity () const;

    /**
     * Retrieves the value of the field "TheatreCity" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheatreCity".
     */
    inline ::std::string& getTheatreCityMutable ();

    /**
     * Sets the value of the member "TheatreCity".
     *
     * Theatre City
     *
     * @param TheatreCity The value which will be set
     */
    inline void setTheatreCity (const ::std::string& TheatreCity_);

    /**
     * Sets the value of the member "TheatreCity".
     *
     * Theatre City
     *
     * @param TheatreCity The value which will be set
     */
    inline void setTheatreCity (const char* TheatreCity_);

    /**
     * Sets the value of the member "TheatreCity".
     *
     * Theatre City
     *
     * @param TheatreCity The value which will be set
     */
    inline void setTheatreCity (const char* value, size_t size);

    // API of field "TheatreState"

    static const int kTheatreState = 5;

    /**
     * Clears the field "TheatreState".
     *
     * The field will be set to its default value. The hasTheatreState()
     * method will return false.
     */
    inline void clearTheatreState();

    /**
     * Checks whether the field "TheatreState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheatreState()). Otherwise it will return false.
     */
    inline bool hasTheatreState () const;

    /**
     * Returns the value of the member "TheatreState".
     *
     * Theatre State
     *
     * @return The value of the field "TheatreState"
     */
    inline const ::std::string& getTheatreState () const;

    /**
     * Retrieves the value of the field "TheatreState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheatreState".
     */
    inline ::std::string& getTheatreStateMutable ();

    /**
     * Sets the value of the member "TheatreState".
     *
     * Theatre State
     *
     * @param TheatreState The value which will be set
     */
    inline void setTheatreState (const ::std::string& TheatreState_);

    /**
     * Sets the value of the member "TheatreState".
     *
     * Theatre State
     *
     * @param TheatreState The value which will be set
     */
    inline void setTheatreState (const char* TheatreState_);

    /**
     * Sets the value of the member "TheatreState".
     *
     * Theatre State
     *
     * @param TheatreState The value which will be set
     */
    inline void setTheatreState (const char* value, size_t size);

    // API of field "TheatreZip"

    static const int kTheatreZip = 6;

    /**
     * Clears the field "TheatreZip".
     *
     * The field will be set to its default value. The hasTheatreZip()
     * method will return false.
     */
    inline void clearTheatreZip();

    /**
     * Checks whether the field "TheatreZip" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheatreZip()). Otherwise it will return false.
     */
    inline bool hasTheatreZip () const;

    /**
     * Returns the value of the member "TheatreZip".
     *
     * Theatre ZIP Code
     *
     * @return The value of the field "TheatreZip"
     */
    inline const ::std::string& getTheatreZip () const;

    /**
     * Retrieves the value of the field "TheatreZip" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheatreZip".
     */
    inline ::std::string& getTheatreZipMutable ();

    /**
     * Sets the value of the member "TheatreZip".
     *
     * Theatre ZIP Code
     *
     * @param TheatreZip The value which will be set
     */
    inline void setTheatreZip (const ::std::string& TheatreZip_);

    /**
     * Sets the value of the member "TheatreZip".
     *
     * Theatre ZIP Code
     *
     * @param TheatreZip The value which will be set
     */
    inline void setTheatreZip (const char* TheatreZip_);

    /**
     * Sets the value of the member "TheatreZip".
     *
     * Theatre ZIP Code
     *
     * @param TheatreZip The value which will be set
     */
    inline void setTheatreZip (const char* value, size_t size);

    // API of field "TheatrePhone"

    static const int kTheatrePhone = 7;

    /**
     * Clears the field "TheatrePhone".
     *
     * The field will be set to its default value. The hasTheatrePhone()
     * method will return false.
     */
    inline void clearTheatrePhone();

    /**
     * Checks whether the field "TheatrePhone" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheatrePhone()). Otherwise it will return false.
     */
    inline bool hasTheatrePhone () const;

    /**
     * Returns the value of the member "TheatrePhone".
     *
     * Theatre Phone Number
     *
     * @return The value of the field "TheatrePhone"
     */
    inline const ::std::string& getTheatrePhone () const;

    /**
     * Retrieves the value of the field "TheatrePhone" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheatrePhone".
     */
    inline ::std::string& getTheatrePhoneMutable ();

    /**
     * Sets the value of the member "TheatrePhone".
     *
     * Theatre Phone Number
     *
     * @param TheatrePhone The value which will be set
     */
    inline void setTheatrePhone (const ::std::string& TheatrePhone_);

    /**
     * Sets the value of the member "TheatrePhone".
     *
     * Theatre Phone Number
     *
     * @param TheatrePhone The value which will be set
     */
    inline void setTheatrePhone (const char* TheatrePhone_);

    /**
     * Sets the value of the member "TheatrePhone".
     *
     * Theatre Phone Number
     *
     * @param TheatrePhone The value which will be set
     */
    inline void setTheatrePhone (const char* value, size_t size);

    // API of field "isTheaterFavorite"

    static const int kIsTheaterFavorite = 8;

    /**
     * Clears the field "isTheaterFavorite".
     *
     * The field will be set to its default value. The hasIsTheaterFavorite()
     * method will return false.
     */
    inline void clearIsTheaterFavorite();

    /**
     * Checks whether the field "isTheaterFavorite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsTheaterFavorite()). Otherwise it will return false.
     */
    inline bool hasIsTheaterFavorite () const;

    /**
     * Returns the value of the member "isTheaterFavorite".
     *
     * is Theatre Favorite or not
     *
     * @return The value of the field "isTheaterFavorite"
     */
    inline bool getIsTheaterFavorite () const;

    /**
     * Sets the value of the member "isTheaterFavorite".
     *
     * is Theatre Favorite or not
     *
     * @param isTheaterFavorite The value which will be set
     */
    inline void setIsTheaterFavorite (bool isTheaterFavorite_);

    // API of field "TheaterLocation"

    static const int kTheaterLocation = 9;

    /**
     * Clears the field "TheaterLocation".
     *
     * The field will be set to its default value. The hasTheaterLocation()
     * method will return false.
     */
    inline void clearTheaterLocation();

    /**
     * Checks whether the field "TheaterLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheaterLocation()). Otherwise it will return false.
     */
    inline bool hasTheaterLocation () const;

    /**
     * Returns the value of the member "TheaterLocation".
     *
     * Theatre Location information
     *
     * @return The value of the field "TheaterLocation"
     */
    inline const ::sxm_main_fi_types::T_SxmLocation& getTheaterLocation () const;

    /**
     * Retrieves the value of the field "TheaterLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheaterLocation".
     */
    inline ::sxm_main_fi_types::T_SxmLocation& getTheaterLocationMutable ();

    /**
     * Sets the value of the member "TheaterLocation".
     *
     * Theatre Location information
     *
     * @param TheaterLocation The value which will be set
     */
    inline void setTheaterLocation (const ::sxm_main_fi_types::T_SxmLocation& TheaterLocation_);

    // API of field "TheaterAmenities"

    static const int kTheaterAmenities = 10;

    /**
     * Clears the field "TheaterAmenities".
     *
     * The field will be set to its default value. The hasTheaterAmenities()
     * method will return false.
     */
    inline void clearTheaterAmenities();

    /**
     * Checks whether the field "TheaterAmenities" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheaterAmenities()). Otherwise it will return false.
     */
    inline bool hasTheaterAmenities () const;

    /**
     * Returns the value of the member "TheaterAmenities".
     *
     * List of Theatre Seating Amenities information. Max items in the list could be THEATRE_AMENITIES_NUM_AMENITIES.
     *
     * @return The value of the field "TheaterAmenities"
     */
    inline const ::std::vector< T_e8_TheatreAmenities >& getTheaterAmenities () const;

    /**
     * Retrieves the value of the field "TheaterAmenities" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheaterAmenities".
     */
    inline ::std::vector< T_e8_TheatreAmenities >& getTheaterAmenitiesMutable ();

    /**
     * Sets the value of the member "TheaterAmenities".
     *
     * List of Theatre Seating Amenities information. Max items in the list could be THEATRE_AMENITIES_NUM_AMENITIES.
     *
     * @param TheaterAmenities The value which will be set
     */
    inline void setTheaterAmenities (const ::std::vector< T_e8_TheatreAmenities >& TheaterAmenities_);

    static const T_TheatreDetails &getDefaultInstance();

private:

    static const ::std::vector< T_e8_TheatreAmenities >& getT_e8_TheatreAmenitiesList_DefaultInstance ();

    inline void set_has_Theater_LOCID ();

    inline void clear_has_Theater_LOCID ();

    inline void set_has_TheatreName ();

    inline void clear_has_TheatreName ();

    inline void set_has_TheatreStreetNum ();

    inline void clear_has_TheatreStreetNum ();

    inline void set_has_TheatreStreetName ();

    inline void clear_has_TheatreStreetName ();

    inline void set_has_TheatreCity ();

    inline void clear_has_TheatreCity ();

    inline void set_has_TheatreState ();

    inline void clear_has_TheatreState ();

    inline void set_has_TheatreZip ();

    inline void clear_has_TheatreZip ();

    inline void set_has_TheatrePhone ();

    inline void clear_has_TheatrePhone ();

    inline void set_has_isTheaterFavorite ();

    inline void clear_has_isTheaterFavorite ();

    inline void set_has_TheaterLocation ();

    inline void clear_has_TheaterLocation ();

    inline void set_has_TheaterAmenities ();

    inline void clear_has_TheaterAmenities ();

    uint32 _has_bits_[ (11 + 31) / 32];

    uint32 _Theater_LOCID;

    ::std::string _TheatreName;

    ::std::string _TheatreStreetNum;

    ::std::string _TheatreStreetName;

    ::std::string _TheatreCity;

    ::std::string _TheatreState;

    ::std::string _TheatreZip;

    ::std::string _TheatrePhone;

    bool _isTheaterFavorite;

    ::sxm_main_fi_types::T_SxmLocation _TheaterLocation;

    ::std::vector< T_e8_TheatreAmenities > _TheaterAmenities;

};

/**
 * If the meaning of "T_ShowDate" isn't clear, then there should be a description here.
 */
class T_ShowDate {
public:

    /**
     * Default constructor
     */
    inline  T_ShowDate ();

    /**
     * Copy constructor
     */
    inline  T_ShowDate (const T_ShowDate &rhs);

    /**
     * All fields constructor
     */
    inline  T_ShowDate (uint16 Date_, uint16 Month_, uint32 Year_);

    /**
     * Destructor
     */
    inline  ~T_ShowDate();

    /**
     * Assignment operator
     */
    inline T_ShowDate& operator = (const T_ShowDate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ShowDate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ShowDate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ShowDate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ShowDate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Date"

    static const int kDate = 0;

    /**
     * Clears the field "Date".
     *
     * The field will be set to its default value. The hasDate()
     * method will return false.
     */
    inline void clearDate();

    /**
     * Checks whether the field "Date" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDate()). Otherwise it will return false.
     */
    inline bool hasDate () const;

    /**
     * Returns the value of the member "Date".
     *
     * Movie Screen Day's date
     *
     * @return The value of the field "Date"
     */
    inline uint16 getDate () const;

    /**
     * Sets the value of the member "Date".
     *
     * Movie Screen Day's date
     *
     * @param Date The value which will be set
     */
    inline void setDate (uint16 Date_);

    // API of field "Month"

    static const int kMonth = 1;

    /**
     * Clears the field "Month".
     *
     * The field will be set to its default value. The hasMonth()
     * method will return false.
     */
    inline void clearMonth();

    /**
     * Checks whether the field "Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMonth()). Otherwise it will return false.
     */
    inline bool hasMonth () const;

    /**
     * Returns the value of the member "Month".
     *
     * Movie Screen Day's Month
     *
     * @return The value of the field "Month"
     */
    inline uint16 getMonth () const;

    /**
     * Sets the value of the member "Month".
     *
     * Movie Screen Day's Month
     *
     * @param Month The value which will be set
     */
    inline void setMonth (uint16 Month_);

    // API of field "Year"

    static const int kYear = 2;

    /**
     * Clears the field "Year".
     *
     * The field will be set to its default value. The hasYear()
     * method will return false.
     */
    inline void clearYear();

    /**
     * Checks whether the field "Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYear()). Otherwise it will return false.
     */
    inline bool hasYear () const;

    /**
     * Returns the value of the member "Year".
     *
     * Movie Screen Day's Year
     *
     * @return The value of the field "Year"
     */
    inline uint32 getYear () const;

    /**
     * Sets the value of the member "Year".
     *
     * Movie Screen Day's Year
     *
     * @param Year The value which will be set
     */
    inline void setYear (uint32 Year_);

    static const T_ShowDate &getDefaultInstance();

private:

    inline void set_has_Date ();

    inline void clear_has_Date ();

    inline void set_has_Month ();

    inline void clear_has_Month ();

    inline void set_has_Year ();

    inline void clear_has_Year ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _Date;

    uint16 _Month;

    uint32 _Year;

};

/**
 * If the meaning of "T_ShowTimes" isn't clear, then there should be a description here.
 */
class T_ShowTimes {
public:

    /**
     * Default constructor
     */
    inline  T_ShowTimes ();

    /**
     * Copy constructor
     */
    inline  T_ShowTimes (const T_ShowTimes &rhs);

    /**
     * All fields constructor
     */
    inline  T_ShowTimes (uint16 Hour_, uint16 Minutes_);

    /**
     * Destructor
     */
    inline  ~T_ShowTimes();

    /**
     * Assignment operator
     */
    inline T_ShowTimes& operator = (const T_ShowTimes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ShowTimes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ShowTimes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ShowTimes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ShowTimes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Hour"

    static const int kHour = 0;

    /**
     * Clears the field "Hour".
     *
     * The field will be set to its default value. The hasHour()
     * method will return false.
     */
    inline void clearHour();

    /**
     * Checks whether the field "Hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHour()). Otherwise it will return false.
     */
    inline bool hasHour () const;

    /**
     * Returns the value of the member "Hour".
     *
     * Movie's Show Time in Hrs
     *
     * @return The value of the field "Hour"
     */
    inline uint16 getHour () const;

    /**
     * Sets the value of the member "Hour".
     *
     * Movie's Show Time in Hrs
     *
     * @param Hour The value which will be set
     */
    inline void setHour (uint16 Hour_);

    // API of field "Minutes"

    static const int kMinutes = 1;

    /**
     * Clears the field "Minutes".
     *
     * The field will be set to its default value. The hasMinutes()
     * method will return false.
     */
    inline void clearMinutes();

    /**
     * Checks whether the field "Minutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinutes()). Otherwise it will return false.
     */
    inline bool hasMinutes () const;

    /**
     * Returns the value of the member "Minutes".
     *
     * Movie's Show Time in Minutes
     *
     * @return The value of the field "Minutes"
     */
    inline uint16 getMinutes () const;

    /**
     * Sets the value of the member "Minutes".
     *
     * Movie's Show Time in Minutes
     *
     * @param Minutes The value which will be set
     */
    inline void setMinutes (uint16 Minutes_);

    static const T_ShowTimes &getDefaultInstance();

private:

    inline void set_has_Hour ();

    inline void clear_has_Hour ();

    inline void set_has_Minutes ();

    inline void clear_has_Minutes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _Hour;

    uint16 _Minutes;

};

/**
 * If the meaning of "T_MovieTimes" isn't clear, then there should be a description here.
 */
class T_MovieTimes {
public:

    /**
     * Default constructor
     */
    inline  T_MovieTimes ();

    /**
     * Copy constructor
     */
    inline  T_MovieTimes (const T_MovieTimes &rhs);

    /**
     * All fields constructor
     */
    inline  T_MovieTimes (const T_ShowDate& ShowDate_, const ::std::vector< T_ShowTimes >& ShowTimes_);

    /**
     * Destructor
     */
    inline  ~T_MovieTimes();

    /**
     * Assignment operator
     */
    inline T_MovieTimes& operator = (const T_MovieTimes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MovieTimes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MovieTimes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MovieTimes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MovieTimes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ShowDate"

    static const int kShowDate = 0;

    /**
     * Clears the field "ShowDate".
     *
     * The field will be set to its default value. The hasShowDate()
     * method will return false.
     */
    inline void clearShowDate();

    /**
     * Checks whether the field "ShowDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShowDate()). Otherwise it will return false.
     */
    inline bool hasShowDate () const;

    /**
     * Returns the value of the member "ShowDate".
     *
     * Movie Screening Day time
     *
     * @return The value of the field "ShowDate"
     */
    inline const T_ShowDate& getShowDate () const;

    /**
     * Retrieves the value of the field "ShowDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ShowDate".
     */
    inline T_ShowDate& getShowDateMutable ();

    /**
     * Sets the value of the member "ShowDate".
     *
     * Movie Screening Day time
     *
     * @param ShowDate The value which will be set
     */
    inline void setShowDate (const T_ShowDate& ShowDate_);

    // API of field "ShowTimes"

    static const int kShowTimes = 1;

    /**
     * Clears the field "ShowTimes".
     *
     * The field will be set to its default value. The hasShowTimes()
     * method will return false.
     */
    inline void clearShowTimes();

    /**
     * Checks whether the field "ShowTimes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShowTimes()). Otherwise it will return false.
     */
    inline bool hasShowTimes () const;

    /**
     * Returns the value of the member "ShowTimes".
     *
     * Movie Times List
     *
     * @return The value of the field "ShowTimes"
     */
    inline const ::std::vector< T_ShowTimes >& getShowTimes () const;

    /**
     * Retrieves the value of the field "ShowTimes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ShowTimes".
     */
    inline ::std::vector< T_ShowTimes >& getShowTimesMutable ();

    /**
     * Sets the value of the member "ShowTimes".
     *
     * Movie Times List
     *
     * @param ShowTimes The value which will be set
     */
    inline void setShowTimes (const ::std::vector< T_ShowTimes >& ShowTimes_);

    static const T_MovieTimes &getDefaultInstance();

private:

    static const ::std::vector< T_ShowTimes >& getT_ShowTimesList_DefaultInstance ();

    inline void set_has_ShowDate ();

    inline void clear_has_ShowDate ();

    inline void set_has_ShowTimes ();

    inline void clear_has_ShowTimes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_ShowDate _ShowDate;

    ::std::vector< T_ShowTimes > _ShowTimes;

};

/**
 * If the meaning of "T_MovieDetails" isn't clear, then there should be a description here.
 */
class T_MovieDetails {
public:

    /**
     * Default constructor
     */
    inline  T_MovieDetails ();

    /**
     * Copy constructor
     */
    inline  T_MovieDetails (const T_MovieDetails &rhs);

    /**
     * All fields constructor
     */
    inline  T_MovieDetails (uint32 MOVIE_ID_, const ::std::string& MovieName_, const ::std::string& MovieRating_, const ::std::string& sMovieLength_, const ::std::string& MovieActors_, const ::std::string& MovieSummury_, const T_MovieTimesList& MovieTimesList_);

    /**
     * Destructor
     */
    inline  ~T_MovieDetails();

    /**
     * Assignment operator
     */
    inline T_MovieDetails& operator = (const T_MovieDetails& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MovieDetails& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MovieDetails& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MovieDetails& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MovieDetails& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MOVIE_ID"

    static const int kMOVIE_ID = 0;

    /**
     * Clears the field "MOVIE_ID".
     *
     * The field will be set to its default value. The hasMOVIE_ID()
     * method will return false.
     */
    inline void clearMOVIE_ID();

    /**
     * Checks whether the field "MOVIE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMOVIE_ID()). Otherwise it will return false.
     */
    inline bool hasMOVIE_ID () const;

    /**
     * Returns the value of the member "MOVIE_ID".
     *
     * Theatre Loc ID
     *
     * @return The value of the field "MOVIE_ID"
     */
    inline uint32 getMOVIE_ID () const;

    /**
     * Sets the value of the member "MOVIE_ID".
     *
     * Theatre Loc ID
     *
     * @param MOVIE_ID The value which will be set
     */
    inline void setMOVIE_ID (uint32 MOVIE_ID_);

    // API of field "MovieName"

    static const int kMovieName = 1;

    /**
     * Clears the field "MovieName".
     *
     * The field will be set to its default value. The hasMovieName()
     * method will return false.
     */
    inline void clearMovieName();

    /**
     * Checks whether the field "MovieName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovieName()). Otherwise it will return false.
     */
    inline bool hasMovieName () const;

    /**
     * Returns the value of the member "MovieName".
     *
     * Movie Name
     *
     * @return The value of the field "MovieName"
     */
    inline const ::std::string& getMovieName () const;

    /**
     * Retrieves the value of the field "MovieName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MovieName".
     */
    inline ::std::string& getMovieNameMutable ();

    /**
     * Sets the value of the member "MovieName".
     *
     * Movie Name
     *
     * @param MovieName The value which will be set
     */
    inline void setMovieName (const ::std::string& MovieName_);

    /**
     * Sets the value of the member "MovieName".
     *
     * Movie Name
     *
     * @param MovieName The value which will be set
     */
    inline void setMovieName (const char* MovieName_);

    /**
     * Sets the value of the member "MovieName".
     *
     * Movie Name
     *
     * @param MovieName The value which will be set
     */
    inline void setMovieName (const char* value, size_t size);

    // API of field "MovieRating"

    static const int kMovieRating = 2;

    /**
     * Clears the field "MovieRating".
     *
     * The field will be set to its default value. The hasMovieRating()
     * method will return false.
     */
    inline void clearMovieRating();

    /**
     * Checks whether the field "MovieRating" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovieRating()). Otherwise it will return false.
     */
    inline bool hasMovieRating () const;

    /**
     * Returns the value of the member "MovieRating".
     *
     * Movie Rating
     *
     * @return The value of the field "MovieRating"
     */
    inline const ::std::string& getMovieRating () const;

    /**
     * Retrieves the value of the field "MovieRating" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MovieRating".
     */
    inline ::std::string& getMovieRatingMutable ();

    /**
     * Sets the value of the member "MovieRating".
     *
     * Movie Rating
     *
     * @param MovieRating The value which will be set
     */
    inline void setMovieRating (const ::std::string& MovieRating_);

    /**
     * Sets the value of the member "MovieRating".
     *
     * Movie Rating
     *
     * @param MovieRating The value which will be set
     */
    inline void setMovieRating (const char* MovieRating_);

    /**
     * Sets the value of the member "MovieRating".
     *
     * Movie Rating
     *
     * @param MovieRating The value which will be set
     */
    inline void setMovieRating (const char* value, size_t size);

    // API of field "sMovieLength"

    static const int kSMovieLength = 3;

    /**
     * Clears the field "sMovieLength".
     *
     * The field will be set to its default value. The hasSMovieLength()
     * method will return false.
     */
    inline void clearSMovieLength();

    /**
     * Checks whether the field "sMovieLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMovieLength()). Otherwise it will return false.
     */
    inline bool hasSMovieLength () const;

    /**
     * Returns the value of the member "sMovieLength".
     *
     * Movie Length
     *
     * @return The value of the field "sMovieLength"
     */
    inline const ::std::string& getSMovieLength () const;

    /**
     * Retrieves the value of the field "sMovieLength" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMovieLength".
     */
    inline ::std::string& getSMovieLengthMutable ();

    /**
     * Sets the value of the member "sMovieLength".
     *
     * Movie Length
     *
     * @param sMovieLength The value which will be set
     */
    inline void setSMovieLength (const ::std::string& sMovieLength_);

    /**
     * Sets the value of the member "sMovieLength".
     *
     * Movie Length
     *
     * @param sMovieLength The value which will be set
     */
    inline void setSMovieLength (const char* sMovieLength_);

    /**
     * Sets the value of the member "sMovieLength".
     *
     * Movie Length
     *
     * @param sMovieLength The value which will be set
     */
    inline void setSMovieLength (const char* value, size_t size);

    // API of field "MovieActors"

    static const int kMovieActors = 4;

    /**
     * Clears the field "MovieActors".
     *
     * The field will be set to its default value. The hasMovieActors()
     * method will return false.
     */
    inline void clearMovieActors();

    /**
     * Checks whether the field "MovieActors" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovieActors()). Otherwise it will return false.
     */
    inline bool hasMovieActors () const;

    /**
     * Returns the value of the member "MovieActors".
     *
     * Movie Actors
     *
     * @return The value of the field "MovieActors"
     */
    inline const ::std::string& getMovieActors () const;

    /**
     * Retrieves the value of the field "MovieActors" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MovieActors".
     */
    inline ::std::string& getMovieActorsMutable ();

    /**
     * Sets the value of the member "MovieActors".
     *
     * Movie Actors
     *
     * @param MovieActors The value which will be set
     */
    inline void setMovieActors (const ::std::string& MovieActors_);

    /**
     * Sets the value of the member "MovieActors".
     *
     * Movie Actors
     *
     * @param MovieActors The value which will be set
     */
    inline void setMovieActors (const char* MovieActors_);

    /**
     * Sets the value of the member "MovieActors".
     *
     * Movie Actors
     *
     * @param MovieActors The value which will be set
     */
    inline void setMovieActors (const char* value, size_t size);

    // API of field "MovieSummury"

    static const int kMovieSummury = 5;

    /**
     * Clears the field "MovieSummury".
     *
     * The field will be set to its default value. The hasMovieSummury()
     * method will return false.
     */
    inline void clearMovieSummury();

    /**
     * Checks whether the field "MovieSummury" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovieSummury()). Otherwise it will return false.
     */
    inline bool hasMovieSummury () const;

    /**
     * Returns the value of the member "MovieSummury".
     *
     * Movie Summury
     *
     * @return The value of the field "MovieSummury"
     */
    inline const ::std::string& getMovieSummury () const;

    /**
     * Retrieves the value of the field "MovieSummury" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MovieSummury".
     */
    inline ::std::string& getMovieSummuryMutable ();

    /**
     * Sets the value of the member "MovieSummury".
     *
     * Movie Summury
     *
     * @param MovieSummury The value which will be set
     */
    inline void setMovieSummury (const ::std::string& MovieSummury_);

    /**
     * Sets the value of the member "MovieSummury".
     *
     * Movie Summury
     *
     * @param MovieSummury The value which will be set
     */
    inline void setMovieSummury (const char* MovieSummury_);

    /**
     * Sets the value of the member "MovieSummury".
     *
     * Movie Summury
     *
     * @param MovieSummury The value which will be set
     */
    inline void setMovieSummury (const char* value, size_t size);

    // API of field "MovieTimesList"

    static const int kMovieTimesList = 6;

    /**
     * Clears the field "MovieTimesList".
     *
     * The field will be set to its default value. The hasMovieTimesList()
     * method will return false.
     */
    inline void clearMovieTimesList();

    /**
     * Checks whether the field "MovieTimesList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovieTimesList()). Otherwise it will return false.
     */
    inline bool hasMovieTimesList () const;

    /**
     * Returns the value of the member "MovieTimesList".
     *
     * Movie Times
     *
     * @return The value of the field "MovieTimesList"
     */
    inline const T_MovieTimesList& getMovieTimesList () const;

    /**
     * Retrieves the value of the field "MovieTimesList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MovieTimesList".
     */
    inline T_MovieTimesList& getMovieTimesListMutable ();

    /**
     * Sets the value of the member "MovieTimesList".
     *
     * Movie Times
     *
     * @param MovieTimesList The value which will be set
     */
    inline void setMovieTimesList (const T_MovieTimesList& MovieTimesList_);

    static const T_MovieDetails &getDefaultInstance();

private:

    static const ::std::vector< T_MovieTimes >& getT_MovieTimesList_DefaultInstance ();

    inline void set_has_MOVIE_ID ();

    inline void clear_has_MOVIE_ID ();

    inline void set_has_MovieName ();

    inline void clear_has_MovieName ();

    inline void set_has_MovieRating ();

    inline void clear_has_MovieRating ();

    inline void set_has_sMovieLength ();

    inline void clear_has_sMovieLength ();

    inline void set_has_MovieActors ();

    inline void clear_has_MovieActors ();

    inline void set_has_MovieSummury ();

    inline void clear_has_MovieSummury ();

    inline void set_has_MovieTimesList ();

    inline void clear_has_MovieTimesList ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint32 _MOVIE_ID;

    ::std::string _MovieName;

    ::std::string _MovieRating;

    ::std::string _sMovieLength;

    ::std::string _MovieActors;

    ::std::string _MovieSummury;

    T_MovieTimesList _MovieTimesList;

};

inline  T_TheatreInfo::T_TheatreInfo ()  :
    _Theater_LOCID (0u),
    _TheatreName (),
    _TheaterCity (),
    _Distance (0.0f),
    _TheaterLocation ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TheatreInfo::T_TheatreInfo (const T_TheatreInfo &rhs)  :
    _Theater_LOCID (0u),
    _TheatreName (),
    _TheaterCity (),
    _Distance (0.0f),
    _TheaterLocation ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TheatreInfo::T_TheatreInfo (uint32 Theater_LOCID_, const ::std::string& TheatreName_, const ::std::string& TheaterCity_, float Distance_, const ::sxm_main_fi_types::T_SxmLocation& TheaterLocation_)  :
    _Theater_LOCID (Theater_LOCID_),
    _TheatreName (TheatreName_),
    _TheaterCity (TheaterCity_),
    _Distance (Distance_),
    _TheaterLocation (TheaterLocation_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheaterCity_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TheatreInfo::~T_TheatreInfo() {
}

inline T_TheatreInfo& T_TheatreInfo::operator = (const T_TheatreInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTheater_LOCID()) {
            setTheater_LOCID(rhs.getTheater_LOCID());
        } else {
            clearTheater_LOCID();
        }
        if (rhs.hasTheatreName()) {
            setTheatreName(rhs.getTheatreName());
        } else {
            clearTheatreName();
        }
        if (rhs.hasTheaterCity()) {
            setTheaterCity(rhs.getTheaterCity());
        } else {
            clearTheaterCity();
        }
        if (rhs.hasDistance()) {
            setDistance(rhs.getDistance());
        } else {
            clearDistance();
        }
        if (rhs.hasTheaterLocation()) {
            setTheaterLocation(rhs.getTheaterLocation());
        } else {
            clearTheaterLocation();
        }
    }
    return *this;
}

inline bool T_TheatreInfo::operator == (const T_TheatreInfo& rhs) const {
    return (((!hasTheater_LOCID() && !rhs.hasTheater_LOCID()) || getTheater_LOCID() == rhs.getTheater_LOCID()) &&
        ((!hasTheatreName() && !rhs.hasTheatreName()) || getTheatreName() == rhs.getTheatreName()) &&
        ((!hasTheaterCity() && !rhs.hasTheaterCity()) || getTheaterCity() == rhs.getTheaterCity()) &&
        ((!hasDistance() && !rhs.hasDistance()) || getDistance() == rhs.getDistance()) &&
        ((!hasTheaterLocation() && !rhs.hasTheaterLocation()) || getTheaterLocation() == rhs.getTheaterLocation()));
}

inline bool T_TheatreInfo::operator != (const T_TheatreInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TheatreInfo::operator < (const T_TheatreInfo& rhs) const {
    if (hasTheater_LOCID() || rhs.hasTheater_LOCID()) {
        if (getTheater_LOCID() < rhs.getTheater_LOCID()) return true;
        if (getTheater_LOCID() > rhs.getTheater_LOCID()) return false;
    }
    if (hasTheatreName() || rhs.hasTheatreName()) {
        if (getTheatreName() < rhs.getTheatreName()) return true;
        if (getTheatreName() > rhs.getTheatreName()) return false;
    }
    if (hasTheaterCity() || rhs.hasTheaterCity()) {
        if (getTheaterCity() < rhs.getTheaterCity()) return true;
        if (getTheaterCity() > rhs.getTheaterCity()) return false;
    }
    if (hasDistance() || rhs.hasDistance()) {
        if (getDistance() < rhs.getDistance()) return true;
        if (getDistance() > rhs.getDistance()) return false;
    }
    if (hasTheaterLocation() || rhs.hasTheaterLocation()) {
        if (getTheaterLocation() < rhs.getTheaterLocation()) return true;
        if (getTheaterLocation() > rhs.getTheaterLocation()) return false;
    }
    return false;
}

inline bool T_TheatreInfo::operator > (const T_TheatreInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TheatreInfo::clear() {
    clearTheater_LOCID();
    clearTheatreName();
    clearTheaterCity();
    clearDistance();
    clearTheaterLocation();
}

inline void T_TheatreInfo::clearTheater_LOCID() {
    if (hasTheater_LOCID()) {
         clear_has_Theater_LOCID();
        _Theater_LOCID = 0u;
     }
}

inline bool T_TheatreInfo::hasTheater_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_TheatreInfo::getTheater_LOCID () const {
    return _Theater_LOCID;
}

inline void T_TheatreInfo::setTheater_LOCID (uint32 Theater_LOCID_) {
    set_has_Theater_LOCID();
    this->_Theater_LOCID = Theater_LOCID_;
}

inline void T_TheatreInfo::clearTheatreName() {
    if (hasTheatreName()) {
         clear_has_TheatreName();
        _TheatreName.clear();
     }
}

inline bool T_TheatreInfo::hasTheatreName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TheatreInfo::getTheatreName () const {
    return _TheatreName;
}

inline ::std::string& T_TheatreInfo::getTheatreNameMutable () {
    set_has_TheatreName();
    return _TheatreName;
}

inline void T_TheatreInfo::setTheatreName (const ::std::string& TheatreName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreName();
    this->_TheatreName = TheatreName_;
}

inline void T_TheatreInfo::setTheatreName (const char* TheatreName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreName();
    this->_TheatreName.assign(TheatreName_);
}

inline void T_TheatreInfo::setTheatreName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreName();
    this->_TheatreName.assign(value, size);
}

inline void T_TheatreInfo::clearTheaterCity() {
    if (hasTheaterCity()) {
         clear_has_TheaterCity();
        _TheaterCity.clear();
     }
}

inline bool T_TheatreInfo::hasTheaterCity () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_TheatreInfo::getTheaterCity () const {
    return _TheaterCity;
}

inline ::std::string& T_TheatreInfo::getTheaterCityMutable () {
    set_has_TheaterCity();
    return _TheaterCity;
}

inline void T_TheatreInfo::setTheaterCity (const ::std::string& TheaterCity_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheaterCity_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheaterCity();
    this->_TheaterCity = TheaterCity_;
}

inline void T_TheatreInfo::setTheaterCity (const char* TheaterCity_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheaterCity_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheaterCity();
    this->_TheaterCity.assign(TheaterCity_);
}

inline void T_TheatreInfo::setTheaterCity (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheaterCity();
    this->_TheaterCity.assign(value, size);
}

inline void T_TheatreInfo::clearDistance() {
    if (hasDistance()) {
         clear_has_Distance();
        _Distance = 0.0f;
     }
}

inline bool T_TheatreInfo::hasDistance () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline float T_TheatreInfo::getDistance () const {
    return _Distance;
}

inline void T_TheatreInfo::setDistance (float Distance_) {
    set_has_Distance();
    this->_Distance = Distance_;
}

inline void T_TheatreInfo::clearTheaterLocation() {
    if (hasTheaterLocation()) {
         clear_has_TheaterLocation();
        _TheaterLocation.clear();
     }
}

inline bool T_TheatreInfo::hasTheaterLocation () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmLocation& T_TheatreInfo::getTheaterLocation () const {
    return _TheaterLocation;
}

inline ::sxm_main_fi_types::T_SxmLocation& T_TheatreInfo::getTheaterLocationMutable () {
    set_has_TheaterLocation();
    return _TheaterLocation;
}

inline void T_TheatreInfo::setTheaterLocation (const ::sxm_main_fi_types::T_SxmLocation& TheaterLocation_) {
    set_has_TheaterLocation();
    this->_TheaterLocation = TheaterLocation_;
}

inline void T_TheatreInfo::set_has_Theater_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TheatreInfo::clear_has_Theater_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TheatreInfo::set_has_TheatreName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TheatreInfo::clear_has_TheatreName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TheatreInfo::set_has_TheaterCity () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TheatreInfo::clear_has_TheaterCity () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TheatreInfo::set_has_Distance () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TheatreInfo::clear_has_Distance () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TheatreInfo::set_has_TheaterLocation () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TheatreInfo::clear_has_TheaterLocation () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_MovieInfo::T_MovieInfo ()  :
    _MOVIE_ID (0u),
    _MovieName (),
    _MovieRating ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MovieInfo::T_MovieInfo (const T_MovieInfo &rhs)  :
    _MOVIE_ID (0u),
    _MovieName (),
    _MovieRating ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MovieInfo::T_MovieInfo (uint32 MOVIE_ID_, const ::std::string& MovieName_, const ::std::string& MovieRating_)  :
    _MOVIE_ID (MOVIE_ID_),
    _MovieName (MovieName_),
    _MovieRating (MovieRating_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieRating_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MovieInfo::~T_MovieInfo() {
}

inline T_MovieInfo& T_MovieInfo::operator = (const T_MovieInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMOVIE_ID()) {
            setMOVIE_ID(rhs.getMOVIE_ID());
        } else {
            clearMOVIE_ID();
        }
        if (rhs.hasMovieName()) {
            setMovieName(rhs.getMovieName());
        } else {
            clearMovieName();
        }
        if (rhs.hasMovieRating()) {
            setMovieRating(rhs.getMovieRating());
        } else {
            clearMovieRating();
        }
    }
    return *this;
}

inline bool T_MovieInfo::operator == (const T_MovieInfo& rhs) const {
    return (((!hasMOVIE_ID() && !rhs.hasMOVIE_ID()) || getMOVIE_ID() == rhs.getMOVIE_ID()) &&
        ((!hasMovieName() && !rhs.hasMovieName()) || getMovieName() == rhs.getMovieName()) &&
        ((!hasMovieRating() && !rhs.hasMovieRating()) || getMovieRating() == rhs.getMovieRating()));
}

inline bool T_MovieInfo::operator != (const T_MovieInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MovieInfo::operator < (const T_MovieInfo& rhs) const {
    if (hasMOVIE_ID() || rhs.hasMOVIE_ID()) {
        if (getMOVIE_ID() < rhs.getMOVIE_ID()) return true;
        if (getMOVIE_ID() > rhs.getMOVIE_ID()) return false;
    }
    if (hasMovieName() || rhs.hasMovieName()) {
        if (getMovieName() < rhs.getMovieName()) return true;
        if (getMovieName() > rhs.getMovieName()) return false;
    }
    if (hasMovieRating() || rhs.hasMovieRating()) {
        if (getMovieRating() < rhs.getMovieRating()) return true;
        if (getMovieRating() > rhs.getMovieRating()) return false;
    }
    return false;
}

inline bool T_MovieInfo::operator > (const T_MovieInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MovieInfo::clear() {
    clearMOVIE_ID();
    clearMovieName();
    clearMovieRating();
}

inline void T_MovieInfo::clearMOVIE_ID() {
    if (hasMOVIE_ID()) {
         clear_has_MOVIE_ID();
        _MOVIE_ID = 0u;
     }
}

inline bool T_MovieInfo::hasMOVIE_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_MovieInfo::getMOVIE_ID () const {
    return _MOVIE_ID;
}

inline void T_MovieInfo::setMOVIE_ID (uint32 MOVIE_ID_) {
    set_has_MOVIE_ID();
    this->_MOVIE_ID = MOVIE_ID_;
}

inline void T_MovieInfo::clearMovieName() {
    if (hasMovieName()) {
         clear_has_MovieName();
        _MovieName.clear();
     }
}

inline bool T_MovieInfo::hasMovieName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_MovieInfo::getMovieName () const {
    return _MovieName;
}

inline ::std::string& T_MovieInfo::getMovieNameMutable () {
    set_has_MovieName();
    return _MovieName;
}

inline void T_MovieInfo::setMovieName (const ::std::string& MovieName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieName();
    this->_MovieName = MovieName_;
}

inline void T_MovieInfo::setMovieName (const char* MovieName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieName();
    this->_MovieName.assign(MovieName_);
}

inline void T_MovieInfo::setMovieName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieName();
    this->_MovieName.assign(value, size);
}

inline void T_MovieInfo::clearMovieRating() {
    if (hasMovieRating()) {
         clear_has_MovieRating();
        _MovieRating.clear();
     }
}

inline bool T_MovieInfo::hasMovieRating () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_MovieInfo::getMovieRating () const {
    return _MovieRating;
}

inline ::std::string& T_MovieInfo::getMovieRatingMutable () {
    set_has_MovieRating();
    return _MovieRating;
}

inline void T_MovieInfo::setMovieRating (const ::std::string& MovieRating_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieRating_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieRating();
    this->_MovieRating = MovieRating_;
}

inline void T_MovieInfo::setMovieRating (const char* MovieRating_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieRating_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieRating();
    this->_MovieRating.assign(MovieRating_);
}

inline void T_MovieInfo::setMovieRating (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieRating();
    this->_MovieRating.assign(value, size);
}

inline void T_MovieInfo::set_has_MOVIE_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MovieInfo::clear_has_MOVIE_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MovieInfo::set_has_MovieName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MovieInfo::clear_has_MovieName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MovieInfo::set_has_MovieRating () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MovieInfo::clear_has_MovieRating () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TheatreDetails::T_TheatreDetails ()  :
    _Theater_LOCID (0u),
    _TheatreName (),
    _TheatreStreetNum (),
    _TheatreStreetName (),
    _TheatreCity (),
    _TheatreState (),
    _TheatreZip (),
    _TheatrePhone (),
    _isTheaterFavorite (false),
    _TheaterLocation (),
    _TheaterAmenities ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TheatreDetails::T_TheatreDetails (const T_TheatreDetails &rhs)  :
    _Theater_LOCID (0u),
    _TheatreName (),
    _TheatreStreetNum (),
    _TheatreStreetName (),
    _TheatreCity (),
    _TheatreState (),
    _TheatreZip (),
    _TheatrePhone (),
    _isTheaterFavorite (false),
    _TheaterLocation (),
    _TheaterAmenities ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TheatreDetails::T_TheatreDetails (uint32 Theater_LOCID_, const ::std::string& TheatreName_, const ::std::string& TheatreStreetNum_, const ::std::string& TheatreStreetName_, const ::std::string& TheatreCity_, const ::std::string& TheatreState_, const ::std::string& TheatreZip_, const ::std::string& TheatrePhone_, bool isTheaterFavorite_, const ::sxm_main_fi_types::T_SxmLocation& TheaterLocation_, const ::std::vector< T_e8_TheatreAmenities >& TheaterAmenities_)  :
    _Theater_LOCID (Theater_LOCID_),
    _TheatreName (TheatreName_),
    _TheatreStreetNum (TheatreStreetNum_),
    _TheatreStreetName (TheatreStreetName_),
    _TheatreCity (TheatreCity_),
    _TheatreState (TheatreState_),
    _TheatreZip (TheatreZip_),
    _TheatrePhone (TheatrePhone_),
    _isTheaterFavorite (isTheaterFavorite_),
    _TheaterLocation (TheaterLocation_),
    _TheaterAmenities (TheaterAmenities_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreStreetNum_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreStreetName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreCity_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreState_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreZip_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatrePhone_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TheatreDetails::~T_TheatreDetails() {
}

inline T_TheatreDetails& T_TheatreDetails::operator = (const T_TheatreDetails& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTheater_LOCID()) {
            setTheater_LOCID(rhs.getTheater_LOCID());
        } else {
            clearTheater_LOCID();
        }
        if (rhs.hasTheatreName()) {
            setTheatreName(rhs.getTheatreName());
        } else {
            clearTheatreName();
        }
        if (rhs.hasTheatreStreetNum()) {
            setTheatreStreetNum(rhs.getTheatreStreetNum());
        } else {
            clearTheatreStreetNum();
        }
        if (rhs.hasTheatreStreetName()) {
            setTheatreStreetName(rhs.getTheatreStreetName());
        } else {
            clearTheatreStreetName();
        }
        if (rhs.hasTheatreCity()) {
            setTheatreCity(rhs.getTheatreCity());
        } else {
            clearTheatreCity();
        }
        if (rhs.hasTheatreState()) {
            setTheatreState(rhs.getTheatreState());
        } else {
            clearTheatreState();
        }
        if (rhs.hasTheatreZip()) {
            setTheatreZip(rhs.getTheatreZip());
        } else {
            clearTheatreZip();
        }
        if (rhs.hasTheatrePhone()) {
            setTheatrePhone(rhs.getTheatrePhone());
        } else {
            clearTheatrePhone();
        }
        if (rhs.hasIsTheaterFavorite()) {
            setIsTheaterFavorite(rhs.getIsTheaterFavorite());
        } else {
            clearIsTheaterFavorite();
        }
        if (rhs.hasTheaterLocation()) {
            setTheaterLocation(rhs.getTheaterLocation());
        } else {
            clearTheaterLocation();
        }
        if (rhs.hasTheaterAmenities()) {
            setTheaterAmenities(rhs.getTheaterAmenities());
        } else {
            clearTheaterAmenities();
        }
    }
    return *this;
}

inline bool T_TheatreDetails::operator == (const T_TheatreDetails& rhs) const {
    return (((!hasTheater_LOCID() && !rhs.hasTheater_LOCID()) || getTheater_LOCID() == rhs.getTheater_LOCID()) &&
        ((!hasTheatreName() && !rhs.hasTheatreName()) || getTheatreName() == rhs.getTheatreName()) &&
        ((!hasTheatreStreetNum() && !rhs.hasTheatreStreetNum()) || getTheatreStreetNum() == rhs.getTheatreStreetNum()) &&
        ((!hasTheatreStreetName() && !rhs.hasTheatreStreetName()) || getTheatreStreetName() == rhs.getTheatreStreetName()) &&
        ((!hasTheatreCity() && !rhs.hasTheatreCity()) || getTheatreCity() == rhs.getTheatreCity()) &&
        ((!hasTheatreState() && !rhs.hasTheatreState()) || getTheatreState() == rhs.getTheatreState()) &&
        ((!hasTheatreZip() && !rhs.hasTheatreZip()) || getTheatreZip() == rhs.getTheatreZip()) &&
        ((!hasTheatrePhone() && !rhs.hasTheatrePhone()) || getTheatrePhone() == rhs.getTheatrePhone()) &&
        ((!hasIsTheaterFavorite() && !rhs.hasIsTheaterFavorite()) || getIsTheaterFavorite() == rhs.getIsTheaterFavorite()) &&
        ((!hasTheaterLocation() && !rhs.hasTheaterLocation()) || getTheaterLocation() == rhs.getTheaterLocation()) &&
        ((!hasTheaterAmenities() && !rhs.hasTheaterAmenities()) || getTheaterAmenities() == rhs.getTheaterAmenities()));
}

inline bool T_TheatreDetails::operator != (const T_TheatreDetails& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TheatreDetails::operator < (const T_TheatreDetails& rhs) const {
    if (hasTheater_LOCID() || rhs.hasTheater_LOCID()) {
        if (getTheater_LOCID() < rhs.getTheater_LOCID()) return true;
        if (getTheater_LOCID() > rhs.getTheater_LOCID()) return false;
    }
    if (hasTheatreName() || rhs.hasTheatreName()) {
        if (getTheatreName() < rhs.getTheatreName()) return true;
        if (getTheatreName() > rhs.getTheatreName()) return false;
    }
    if (hasTheatreStreetNum() || rhs.hasTheatreStreetNum()) {
        if (getTheatreStreetNum() < rhs.getTheatreStreetNum()) return true;
        if (getTheatreStreetNum() > rhs.getTheatreStreetNum()) return false;
    }
    if (hasTheatreStreetName() || rhs.hasTheatreStreetName()) {
        if (getTheatreStreetName() < rhs.getTheatreStreetName()) return true;
        if (getTheatreStreetName() > rhs.getTheatreStreetName()) return false;
    }
    if (hasTheatreCity() || rhs.hasTheatreCity()) {
        if (getTheatreCity() < rhs.getTheatreCity()) return true;
        if (getTheatreCity() > rhs.getTheatreCity()) return false;
    }
    if (hasTheatreState() || rhs.hasTheatreState()) {
        if (getTheatreState() < rhs.getTheatreState()) return true;
        if (getTheatreState() > rhs.getTheatreState()) return false;
    }
    if (hasTheatreZip() || rhs.hasTheatreZip()) {
        if (getTheatreZip() < rhs.getTheatreZip()) return true;
        if (getTheatreZip() > rhs.getTheatreZip()) return false;
    }
    if (hasTheatrePhone() || rhs.hasTheatrePhone()) {
        if (getTheatrePhone() < rhs.getTheatrePhone()) return true;
        if (getTheatrePhone() > rhs.getTheatrePhone()) return false;
    }
    if (hasIsTheaterFavorite() || rhs.hasIsTheaterFavorite()) {
        if (getIsTheaterFavorite() < rhs.getIsTheaterFavorite()) return true;
        if (getIsTheaterFavorite() > rhs.getIsTheaterFavorite()) return false;
    }
    if (hasTheaterLocation() || rhs.hasTheaterLocation()) {
        if (getTheaterLocation() < rhs.getTheaterLocation()) return true;
        if (getTheaterLocation() > rhs.getTheaterLocation()) return false;
    }
    if (hasTheaterAmenities() || rhs.hasTheaterAmenities()) {
        if (getTheaterAmenities() < rhs.getTheaterAmenities()) return true;
        if (getTheaterAmenities() > rhs.getTheaterAmenities()) return false;
    }
    return false;
}

inline bool T_TheatreDetails::operator > (const T_TheatreDetails& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TheatreDetails::clear() {
    clearTheater_LOCID();
    clearTheatreName();
    clearTheatreStreetNum();
    clearTheatreStreetName();
    clearTheatreCity();
    clearTheatreState();
    clearTheatreZip();
    clearTheatrePhone();
    clearIsTheaterFavorite();
    clearTheaterLocation();
    clearTheaterAmenities();
}

inline void T_TheatreDetails::clearTheater_LOCID() {
    if (hasTheater_LOCID()) {
         clear_has_Theater_LOCID();
        _Theater_LOCID = 0u;
     }
}

inline bool T_TheatreDetails::hasTheater_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_TheatreDetails::getTheater_LOCID () const {
    return _Theater_LOCID;
}

inline void T_TheatreDetails::setTheater_LOCID (uint32 Theater_LOCID_) {
    set_has_Theater_LOCID();
    this->_Theater_LOCID = Theater_LOCID_;
}

inline void T_TheatreDetails::clearTheatreName() {
    if (hasTheatreName()) {
         clear_has_TheatreName();
        _TheatreName.clear();
     }
}

inline bool T_TheatreDetails::hasTheatreName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TheatreDetails::getTheatreName () const {
    return _TheatreName;
}

inline ::std::string& T_TheatreDetails::getTheatreNameMutable () {
    set_has_TheatreName();
    return _TheatreName;
}

inline void T_TheatreDetails::setTheatreName (const ::std::string& TheatreName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreName();
    this->_TheatreName = TheatreName_;
}

inline void T_TheatreDetails::setTheatreName (const char* TheatreName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreName();
    this->_TheatreName.assign(TheatreName_);
}

inline void T_TheatreDetails::setTheatreName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreName();
    this->_TheatreName.assign(value, size);
}

inline void T_TheatreDetails::clearTheatreStreetNum() {
    if (hasTheatreStreetNum()) {
         clear_has_TheatreStreetNum();
        _TheatreStreetNum.clear();
     }
}

inline bool T_TheatreDetails::hasTheatreStreetNum () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_TheatreDetails::getTheatreStreetNum () const {
    return _TheatreStreetNum;
}

inline ::std::string& T_TheatreDetails::getTheatreStreetNumMutable () {
    set_has_TheatreStreetNum();
    return _TheatreStreetNum;
}

inline void T_TheatreDetails::setTheatreStreetNum (const ::std::string& TheatreStreetNum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreStreetNum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreStreetNum();
    this->_TheatreStreetNum = TheatreStreetNum_;
}

inline void T_TheatreDetails::setTheatreStreetNum (const char* TheatreStreetNum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreStreetNum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreStreetNum();
    this->_TheatreStreetNum.assign(TheatreStreetNum_);
}

inline void T_TheatreDetails::setTheatreStreetNum (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreStreetNum();
    this->_TheatreStreetNum.assign(value, size);
}

inline void T_TheatreDetails::clearTheatreStreetName() {
    if (hasTheatreStreetName()) {
         clear_has_TheatreStreetName();
        _TheatreStreetName.clear();
     }
}

inline bool T_TheatreDetails::hasTheatreStreetName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_TheatreDetails::getTheatreStreetName () const {
    return _TheatreStreetName;
}

inline ::std::string& T_TheatreDetails::getTheatreStreetNameMutable () {
    set_has_TheatreStreetName();
    return _TheatreStreetName;
}

inline void T_TheatreDetails::setTheatreStreetName (const ::std::string& TheatreStreetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreStreetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreStreetName();
    this->_TheatreStreetName = TheatreStreetName_;
}

inline void T_TheatreDetails::setTheatreStreetName (const char* TheatreStreetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreStreetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreStreetName();
    this->_TheatreStreetName.assign(TheatreStreetName_);
}

inline void T_TheatreDetails::setTheatreStreetName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreStreetName();
    this->_TheatreStreetName.assign(value, size);
}

inline void T_TheatreDetails::clearTheatreCity() {
    if (hasTheatreCity()) {
         clear_has_TheatreCity();
        _TheatreCity.clear();
     }
}

inline bool T_TheatreDetails::hasTheatreCity () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_TheatreDetails::getTheatreCity () const {
    return _TheatreCity;
}

inline ::std::string& T_TheatreDetails::getTheatreCityMutable () {
    set_has_TheatreCity();
    return _TheatreCity;
}

inline void T_TheatreDetails::setTheatreCity (const ::std::string& TheatreCity_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreCity_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreCity();
    this->_TheatreCity = TheatreCity_;
}

inline void T_TheatreDetails::setTheatreCity (const char* TheatreCity_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreCity_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreCity();
    this->_TheatreCity.assign(TheatreCity_);
}

inline void T_TheatreDetails::setTheatreCity (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreCity();
    this->_TheatreCity.assign(value, size);
}

inline void T_TheatreDetails::clearTheatreState() {
    if (hasTheatreState()) {
         clear_has_TheatreState();
        _TheatreState.clear();
     }
}

inline bool T_TheatreDetails::hasTheatreState () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_TheatreDetails::getTheatreState () const {
    return _TheatreState;
}

inline ::std::string& T_TheatreDetails::getTheatreStateMutable () {
    set_has_TheatreState();
    return _TheatreState;
}

inline void T_TheatreDetails::setTheatreState (const ::std::string& TheatreState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreState();
    this->_TheatreState = TheatreState_;
}

inline void T_TheatreDetails::setTheatreState (const char* TheatreState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreState();
    this->_TheatreState.assign(TheatreState_);
}

inline void T_TheatreDetails::setTheatreState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreState();
    this->_TheatreState.assign(value, size);
}

inline void T_TheatreDetails::clearTheatreZip() {
    if (hasTheatreZip()) {
         clear_has_TheatreZip();
        _TheatreZip.clear();
     }
}

inline bool T_TheatreDetails::hasTheatreZip () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_TheatreDetails::getTheatreZip () const {
    return _TheatreZip;
}

inline ::std::string& T_TheatreDetails::getTheatreZipMutable () {
    set_has_TheatreZip();
    return _TheatreZip;
}

inline void T_TheatreDetails::setTheatreZip (const ::std::string& TheatreZip_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreZip_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreZip();
    this->_TheatreZip = TheatreZip_;
}

inline void T_TheatreDetails::setTheatreZip (const char* TheatreZip_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatreZip_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreZip();
    this->_TheatreZip.assign(TheatreZip_);
}

inline void T_TheatreDetails::setTheatreZip (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatreZip();
    this->_TheatreZip.assign(value, size);
}

inline void T_TheatreDetails::clearTheatrePhone() {
    if (hasTheatrePhone()) {
         clear_has_TheatrePhone();
        _TheatrePhone.clear();
     }
}

inline bool T_TheatreDetails::hasTheatrePhone () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_TheatreDetails::getTheatrePhone () const {
    return _TheatrePhone;
}

inline ::std::string& T_TheatreDetails::getTheatrePhoneMutable () {
    set_has_TheatrePhone();
    return _TheatrePhone;
}

inline void T_TheatreDetails::setTheatrePhone (const ::std::string& TheatrePhone_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatrePhone_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatrePhone();
    this->_TheatrePhone = TheatrePhone_;
}

inline void T_TheatreDetails::setTheatrePhone (const char* TheatrePhone_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TheatrePhone_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatrePhone();
    this->_TheatrePhone.assign(TheatrePhone_);
}

inline void T_TheatreDetails::setTheatrePhone (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TheatrePhone();
    this->_TheatrePhone.assign(value, size);
}

inline void T_TheatreDetails::clearIsTheaterFavorite() {
    if (hasIsTheaterFavorite()) {
         clear_has_isTheaterFavorite();
        _isTheaterFavorite = false;
     }
}

inline bool T_TheatreDetails::hasIsTheaterFavorite () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_TheatreDetails::getIsTheaterFavorite () const {
    return _isTheaterFavorite;
}

inline void T_TheatreDetails::setIsTheaterFavorite (bool isTheaterFavorite_) {
    set_has_isTheaterFavorite();
    this->_isTheaterFavorite = isTheaterFavorite_;
}

inline void T_TheatreDetails::clearTheaterLocation() {
    if (hasTheaterLocation()) {
         clear_has_TheaterLocation();
        _TheaterLocation.clear();
     }
}

inline bool T_TheatreDetails::hasTheaterLocation () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmLocation& T_TheatreDetails::getTheaterLocation () const {
    return _TheaterLocation;
}

inline ::sxm_main_fi_types::T_SxmLocation& T_TheatreDetails::getTheaterLocationMutable () {
    set_has_TheaterLocation();
    return _TheaterLocation;
}

inline void T_TheatreDetails::setTheaterLocation (const ::sxm_main_fi_types::T_SxmLocation& TheaterLocation_) {
    set_has_TheaterLocation();
    this->_TheaterLocation = TheaterLocation_;
}

inline void T_TheatreDetails::clearTheaterAmenities() {
    if (hasTheaterAmenities()) {
         clear_has_TheaterAmenities();
        _TheaterAmenities.clear();
     }
}

inline bool T_TheatreDetails::hasTheaterAmenities () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::vector< T_e8_TheatreAmenities >& T_TheatreDetails::getTheaterAmenities () const {
    return _TheaterAmenities;
}

inline ::std::vector< T_e8_TheatreAmenities >& T_TheatreDetails::getTheaterAmenitiesMutable () {
    set_has_TheaterAmenities();
    return _TheaterAmenities;
}

inline void T_TheatreDetails::setTheaterAmenities (const ::std::vector< T_e8_TheatreAmenities >& TheaterAmenities_) {
    set_has_TheaterAmenities();
    this->_TheaterAmenities = TheaterAmenities_;
}

inline void T_TheatreDetails::set_has_Theater_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TheatreDetails::clear_has_Theater_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TheatreDetails::set_has_TheatreName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TheatreDetails::clear_has_TheatreName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TheatreDetails::set_has_TheatreStreetNum () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TheatreDetails::clear_has_TheatreStreetNum () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TheatreDetails::set_has_TheatreStreetName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TheatreDetails::clear_has_TheatreStreetName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TheatreDetails::set_has_TheatreCity () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TheatreDetails::clear_has_TheatreCity () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TheatreDetails::set_has_TheatreState () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TheatreDetails::clear_has_TheatreState () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TheatreDetails::set_has_TheatreZip () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TheatreDetails::clear_has_TheatreZip () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_TheatreDetails::set_has_TheatrePhone () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_TheatreDetails::clear_has_TheatrePhone () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_TheatreDetails::set_has_isTheaterFavorite () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_TheatreDetails::clear_has_isTheaterFavorite () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_TheatreDetails::set_has_TheaterLocation () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_TheatreDetails::clear_has_TheaterLocation () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_TheatreDetails::set_has_TheaterAmenities () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_TheatreDetails::clear_has_TheaterAmenities () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline  T_ShowDate::T_ShowDate ()  :
    _Date (0u),
    _Month (0u),
    _Year (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ShowDate::T_ShowDate (const T_ShowDate &rhs)  :
    _Date (0u),
    _Month (0u),
    _Year (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ShowDate::T_ShowDate (uint16 Date_, uint16 Month_, uint32 Year_)  :
    _Date (Date_),
    _Month (Month_),
    _Year (Year_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ShowDate::~T_ShowDate() {
}

inline T_ShowDate& T_ShowDate::operator = (const T_ShowDate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDate()) {
            setDate(rhs.getDate());
        } else {
            clearDate();
        }
        if (rhs.hasMonth()) {
            setMonth(rhs.getMonth());
        } else {
            clearMonth();
        }
        if (rhs.hasYear()) {
            setYear(rhs.getYear());
        } else {
            clearYear();
        }
    }
    return *this;
}

inline bool T_ShowDate::operator == (const T_ShowDate& rhs) const {
    return (((!hasDate() && !rhs.hasDate()) || getDate() == rhs.getDate()) &&
        ((!hasMonth() && !rhs.hasMonth()) || getMonth() == rhs.getMonth()) &&
        ((!hasYear() && !rhs.hasYear()) || getYear() == rhs.getYear()));
}

inline bool T_ShowDate::operator != (const T_ShowDate& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ShowDate::operator < (const T_ShowDate& rhs) const {
    if (hasDate() || rhs.hasDate()) {
        if (getDate() < rhs.getDate()) return true;
        if (getDate() > rhs.getDate()) return false;
    }
    if (hasMonth() || rhs.hasMonth()) {
        if (getMonth() < rhs.getMonth()) return true;
        if (getMonth() > rhs.getMonth()) return false;
    }
    if (hasYear() || rhs.hasYear()) {
        if (getYear() < rhs.getYear()) return true;
        if (getYear() > rhs.getYear()) return false;
    }
    return false;
}

inline bool T_ShowDate::operator > (const T_ShowDate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ShowDate::clear() {
    clearDate();
    clearMonth();
    clearYear();
}

inline void T_ShowDate::clearDate() {
    if (hasDate()) {
         clear_has_Date();
        _Date = 0u;
     }
}

inline bool T_ShowDate::hasDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_ShowDate::getDate () const {
    return _Date;
}

inline void T_ShowDate::setDate (uint16 Date_) {
    set_has_Date();
    this->_Date = Date_;
}

inline void T_ShowDate::clearMonth() {
    if (hasMonth()) {
         clear_has_Month();
        _Month = 0u;
     }
}

inline bool T_ShowDate::hasMonth () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_ShowDate::getMonth () const {
    return _Month;
}

inline void T_ShowDate::setMonth (uint16 Month_) {
    set_has_Month();
    this->_Month = Month_;
}

inline void T_ShowDate::clearYear() {
    if (hasYear()) {
         clear_has_Year();
        _Year = 0u;
     }
}

inline bool T_ShowDate::hasYear () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_ShowDate::getYear () const {
    return _Year;
}

inline void T_ShowDate::setYear (uint32 Year_) {
    set_has_Year();
    this->_Year = Year_;
}

inline void T_ShowDate::set_has_Date () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ShowDate::clear_has_Date () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ShowDate::set_has_Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ShowDate::clear_has_Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ShowDate::set_has_Year () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ShowDate::clear_has_Year () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_ShowTimes::T_ShowTimes ()  :
    _Hour (0u),
    _Minutes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ShowTimes::T_ShowTimes (const T_ShowTimes &rhs)  :
    _Hour (0u),
    _Minutes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ShowTimes::T_ShowTimes (uint16 Hour_, uint16 Minutes_)  :
    _Hour (Hour_),
    _Minutes (Minutes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ShowTimes::~T_ShowTimes() {
}

inline T_ShowTimes& T_ShowTimes::operator = (const T_ShowTimes& rhs) {
    if( this != &rhs ) {
        if (rhs.hasHour()) {
            setHour(rhs.getHour());
        } else {
            clearHour();
        }
        if (rhs.hasMinutes()) {
            setMinutes(rhs.getMinutes());
        } else {
            clearMinutes();
        }
    }
    return *this;
}

inline bool T_ShowTimes::operator == (const T_ShowTimes& rhs) const {
    return (((!hasHour() && !rhs.hasHour()) || getHour() == rhs.getHour()) &&
        ((!hasMinutes() && !rhs.hasMinutes()) || getMinutes() == rhs.getMinutes()));
}

inline bool T_ShowTimes::operator != (const T_ShowTimes& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ShowTimes::operator < (const T_ShowTimes& rhs) const {
    if (hasHour() || rhs.hasHour()) {
        if (getHour() < rhs.getHour()) return true;
        if (getHour() > rhs.getHour()) return false;
    }
    if (hasMinutes() || rhs.hasMinutes()) {
        if (getMinutes() < rhs.getMinutes()) return true;
        if (getMinutes() > rhs.getMinutes()) return false;
    }
    return false;
}

inline bool T_ShowTimes::operator > (const T_ShowTimes& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ShowTimes::clear() {
    clearHour();
    clearMinutes();
}

inline void T_ShowTimes::clearHour() {
    if (hasHour()) {
         clear_has_Hour();
        _Hour = 0u;
     }
}

inline bool T_ShowTimes::hasHour () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_ShowTimes::getHour () const {
    return _Hour;
}

inline void T_ShowTimes::setHour (uint16 Hour_) {
    set_has_Hour();
    this->_Hour = Hour_;
}

inline void T_ShowTimes::clearMinutes() {
    if (hasMinutes()) {
         clear_has_Minutes();
        _Minutes = 0u;
     }
}

inline bool T_ShowTimes::hasMinutes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_ShowTimes::getMinutes () const {
    return _Minutes;
}

inline void T_ShowTimes::setMinutes (uint16 Minutes_) {
    set_has_Minutes();
    this->_Minutes = Minutes_;
}

inline void T_ShowTimes::set_has_Hour () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ShowTimes::clear_has_Hour () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ShowTimes::set_has_Minutes () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ShowTimes::clear_has_Minutes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_MovieTimes::T_MovieTimes ()  :
    _ShowDate (),
    _ShowTimes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MovieTimes::T_MovieTimes (const T_MovieTimes &rhs)  :
    _ShowDate (),
    _ShowTimes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MovieTimes::T_MovieTimes (const T_ShowDate& ShowDate_, const ::std::vector< T_ShowTimes >& ShowTimes_)  :
    _ShowDate (ShowDate_),
    _ShowTimes (ShowTimes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MovieTimes::~T_MovieTimes() {
}

inline T_MovieTimes& T_MovieTimes::operator = (const T_MovieTimes& rhs) {
    if( this != &rhs ) {
        if (rhs.hasShowDate()) {
            setShowDate(rhs.getShowDate());
        } else {
            clearShowDate();
        }
        if (rhs.hasShowTimes()) {
            setShowTimes(rhs.getShowTimes());
        } else {
            clearShowTimes();
        }
    }
    return *this;
}

inline bool T_MovieTimes::operator == (const T_MovieTimes& rhs) const {
    return (((!hasShowDate() && !rhs.hasShowDate()) || getShowDate() == rhs.getShowDate()) &&
        ((!hasShowTimes() && !rhs.hasShowTimes()) || getShowTimes() == rhs.getShowTimes()));
}

inline bool T_MovieTimes::operator != (const T_MovieTimes& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MovieTimes::operator < (const T_MovieTimes& rhs) const {
    if (hasShowDate() || rhs.hasShowDate()) {
        if (getShowDate() < rhs.getShowDate()) return true;
        if (getShowDate() > rhs.getShowDate()) return false;
    }
    if (hasShowTimes() || rhs.hasShowTimes()) {
        if (getShowTimes() < rhs.getShowTimes()) return true;
        if (getShowTimes() > rhs.getShowTimes()) return false;
    }
    return false;
}

inline bool T_MovieTimes::operator > (const T_MovieTimes& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MovieTimes::clear() {
    clearShowDate();
    clearShowTimes();
}

inline void T_MovieTimes::clearShowDate() {
    if (hasShowDate()) {
         clear_has_ShowDate();
        _ShowDate.clear();
     }
}

inline bool T_MovieTimes::hasShowDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_ShowDate& T_MovieTimes::getShowDate () const {
    return _ShowDate;
}

inline T_ShowDate& T_MovieTimes::getShowDateMutable () {
    set_has_ShowDate();
    return _ShowDate;
}

inline void T_MovieTimes::setShowDate (const T_ShowDate& ShowDate_) {
    set_has_ShowDate();
    this->_ShowDate = ShowDate_;
}

inline void T_MovieTimes::clearShowTimes() {
    if (hasShowTimes()) {
         clear_has_ShowTimes();
        _ShowTimes.clear();
     }
}

inline bool T_MovieTimes::hasShowTimes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_ShowTimes >& T_MovieTimes::getShowTimes () const {
    return _ShowTimes;
}

inline ::std::vector< T_ShowTimes >& T_MovieTimes::getShowTimesMutable () {
    set_has_ShowTimes();
    return _ShowTimes;
}

inline void T_MovieTimes::setShowTimes (const ::std::vector< T_ShowTimes >& ShowTimes_) {
    set_has_ShowTimes();
    this->_ShowTimes = ShowTimes_;
}

inline void T_MovieTimes::set_has_ShowDate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MovieTimes::clear_has_ShowDate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MovieTimes::set_has_ShowTimes () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MovieTimes::clear_has_ShowTimes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_MovieDetails::T_MovieDetails ()  :
    _MOVIE_ID (0u),
    _MovieName (),
    _MovieRating (),
    _sMovieLength (),
    _MovieActors (),
    _MovieSummury (),
    _MovieTimesList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MovieDetails::T_MovieDetails (const T_MovieDetails &rhs)  :
    _MOVIE_ID (0u),
    _MovieName (),
    _MovieRating (),
    _sMovieLength (),
    _MovieActors (),
    _MovieSummury (),
    _MovieTimesList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MovieDetails::T_MovieDetails (uint32 MOVIE_ID_, const ::std::string& MovieName_, const ::std::string& MovieRating_, const ::std::string& sMovieLength_, const ::std::string& MovieActors_, const ::std::string& MovieSummury_, const T_MovieTimesList& MovieTimesList_)  :
    _MOVIE_ID (MOVIE_ID_),
    _MovieName (MovieName_),
    _MovieRating (MovieRating_),
    _sMovieLength (sMovieLength_),
    _MovieActors (MovieActors_),
    _MovieSummury (MovieSummury_),
    _MovieTimesList (MovieTimesList_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieRating_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMovieLength_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieActors_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieSummury_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MovieDetails::~T_MovieDetails() {
}

inline T_MovieDetails& T_MovieDetails::operator = (const T_MovieDetails& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMOVIE_ID()) {
            setMOVIE_ID(rhs.getMOVIE_ID());
        } else {
            clearMOVIE_ID();
        }
        if (rhs.hasMovieName()) {
            setMovieName(rhs.getMovieName());
        } else {
            clearMovieName();
        }
        if (rhs.hasMovieRating()) {
            setMovieRating(rhs.getMovieRating());
        } else {
            clearMovieRating();
        }
        if (rhs.hasSMovieLength()) {
            setSMovieLength(rhs.getSMovieLength());
        } else {
            clearSMovieLength();
        }
        if (rhs.hasMovieActors()) {
            setMovieActors(rhs.getMovieActors());
        } else {
            clearMovieActors();
        }
        if (rhs.hasMovieSummury()) {
            setMovieSummury(rhs.getMovieSummury());
        } else {
            clearMovieSummury();
        }
        if (rhs.hasMovieTimesList()) {
            setMovieTimesList(rhs.getMovieTimesList());
        } else {
            clearMovieTimesList();
        }
    }
    return *this;
}

inline bool T_MovieDetails::operator == (const T_MovieDetails& rhs) const {
    return (((!hasMOVIE_ID() && !rhs.hasMOVIE_ID()) || getMOVIE_ID() == rhs.getMOVIE_ID()) &&
        ((!hasMovieName() && !rhs.hasMovieName()) || getMovieName() == rhs.getMovieName()) &&
        ((!hasMovieRating() && !rhs.hasMovieRating()) || getMovieRating() == rhs.getMovieRating()) &&
        ((!hasSMovieLength() && !rhs.hasSMovieLength()) || getSMovieLength() == rhs.getSMovieLength()) &&
        ((!hasMovieActors() && !rhs.hasMovieActors()) || getMovieActors() == rhs.getMovieActors()) &&
        ((!hasMovieSummury() && !rhs.hasMovieSummury()) || getMovieSummury() == rhs.getMovieSummury()) &&
        ((!hasMovieTimesList() && !rhs.hasMovieTimesList()) || getMovieTimesList() == rhs.getMovieTimesList()));
}

inline bool T_MovieDetails::operator != (const T_MovieDetails& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MovieDetails::operator < (const T_MovieDetails& rhs) const {
    if (hasMOVIE_ID() || rhs.hasMOVIE_ID()) {
        if (getMOVIE_ID() < rhs.getMOVIE_ID()) return true;
        if (getMOVIE_ID() > rhs.getMOVIE_ID()) return false;
    }
    if (hasMovieName() || rhs.hasMovieName()) {
        if (getMovieName() < rhs.getMovieName()) return true;
        if (getMovieName() > rhs.getMovieName()) return false;
    }
    if (hasMovieRating() || rhs.hasMovieRating()) {
        if (getMovieRating() < rhs.getMovieRating()) return true;
        if (getMovieRating() > rhs.getMovieRating()) return false;
    }
    if (hasSMovieLength() || rhs.hasSMovieLength()) {
        if (getSMovieLength() < rhs.getSMovieLength()) return true;
        if (getSMovieLength() > rhs.getSMovieLength()) return false;
    }
    if (hasMovieActors() || rhs.hasMovieActors()) {
        if (getMovieActors() < rhs.getMovieActors()) return true;
        if (getMovieActors() > rhs.getMovieActors()) return false;
    }
    if (hasMovieSummury() || rhs.hasMovieSummury()) {
        if (getMovieSummury() < rhs.getMovieSummury()) return true;
        if (getMovieSummury() > rhs.getMovieSummury()) return false;
    }
    if (hasMovieTimesList() || rhs.hasMovieTimesList()) {
        if (getMovieTimesList() < rhs.getMovieTimesList()) return true;
        if (getMovieTimesList() > rhs.getMovieTimesList()) return false;
    }
    return false;
}

inline bool T_MovieDetails::operator > (const T_MovieDetails& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MovieDetails::clear() {
    clearMOVIE_ID();
    clearMovieName();
    clearMovieRating();
    clearSMovieLength();
    clearMovieActors();
    clearMovieSummury();
    clearMovieTimesList();
}

inline void T_MovieDetails::clearMOVIE_ID() {
    if (hasMOVIE_ID()) {
         clear_has_MOVIE_ID();
        _MOVIE_ID = 0u;
     }
}

inline bool T_MovieDetails::hasMOVIE_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_MovieDetails::getMOVIE_ID () const {
    return _MOVIE_ID;
}

inline void T_MovieDetails::setMOVIE_ID (uint32 MOVIE_ID_) {
    set_has_MOVIE_ID();
    this->_MOVIE_ID = MOVIE_ID_;
}

inline void T_MovieDetails::clearMovieName() {
    if (hasMovieName()) {
         clear_has_MovieName();
        _MovieName.clear();
     }
}

inline bool T_MovieDetails::hasMovieName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_MovieDetails::getMovieName () const {
    return _MovieName;
}

inline ::std::string& T_MovieDetails::getMovieNameMutable () {
    set_has_MovieName();
    return _MovieName;
}

inline void T_MovieDetails::setMovieName (const ::std::string& MovieName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieName();
    this->_MovieName = MovieName_;
}

inline void T_MovieDetails::setMovieName (const char* MovieName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieName();
    this->_MovieName.assign(MovieName_);
}

inline void T_MovieDetails::setMovieName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieName();
    this->_MovieName.assign(value, size);
}

inline void T_MovieDetails::clearMovieRating() {
    if (hasMovieRating()) {
         clear_has_MovieRating();
        _MovieRating.clear();
     }
}

inline bool T_MovieDetails::hasMovieRating () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_MovieDetails::getMovieRating () const {
    return _MovieRating;
}

inline ::std::string& T_MovieDetails::getMovieRatingMutable () {
    set_has_MovieRating();
    return _MovieRating;
}

inline void T_MovieDetails::setMovieRating (const ::std::string& MovieRating_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieRating_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieRating();
    this->_MovieRating = MovieRating_;
}

inline void T_MovieDetails::setMovieRating (const char* MovieRating_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieRating_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieRating();
    this->_MovieRating.assign(MovieRating_);
}

inline void T_MovieDetails::setMovieRating (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieRating();
    this->_MovieRating.assign(value, size);
}

inline void T_MovieDetails::clearSMovieLength() {
    if (hasSMovieLength()) {
         clear_has_sMovieLength();
        _sMovieLength.clear();
     }
}

inline bool T_MovieDetails::hasSMovieLength () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_MovieDetails::getSMovieLength () const {
    return _sMovieLength;
}

inline ::std::string& T_MovieDetails::getSMovieLengthMutable () {
    set_has_sMovieLength();
    return _sMovieLength;
}

inline void T_MovieDetails::setSMovieLength (const ::std::string& sMovieLength_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMovieLength_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMovieLength();
    this->_sMovieLength = sMovieLength_;
}

inline void T_MovieDetails::setSMovieLength (const char* sMovieLength_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMovieLength_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMovieLength();
    this->_sMovieLength.assign(sMovieLength_);
}

inline void T_MovieDetails::setSMovieLength (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMovieLength();
    this->_sMovieLength.assign(value, size);
}

inline void T_MovieDetails::clearMovieActors() {
    if (hasMovieActors()) {
         clear_has_MovieActors();
        _MovieActors.clear();
     }
}

inline bool T_MovieDetails::hasMovieActors () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_MovieDetails::getMovieActors () const {
    return _MovieActors;
}

inline ::std::string& T_MovieDetails::getMovieActorsMutable () {
    set_has_MovieActors();
    return _MovieActors;
}

inline void T_MovieDetails::setMovieActors (const ::std::string& MovieActors_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieActors_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieActors();
    this->_MovieActors = MovieActors_;
}

inline void T_MovieDetails::setMovieActors (const char* MovieActors_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieActors_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieActors();
    this->_MovieActors.assign(MovieActors_);
}

inline void T_MovieDetails::setMovieActors (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieActors();
    this->_MovieActors.assign(value, size);
}

inline void T_MovieDetails::clearMovieSummury() {
    if (hasMovieSummury()) {
         clear_has_MovieSummury();
        _MovieSummury.clear();
     }
}

inline bool T_MovieDetails::hasMovieSummury () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_MovieDetails::getMovieSummury () const {
    return _MovieSummury;
}

inline ::std::string& T_MovieDetails::getMovieSummuryMutable () {
    set_has_MovieSummury();
    return _MovieSummury;
}

inline void T_MovieDetails::setMovieSummury (const ::std::string& MovieSummury_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieSummury_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieSummury();
    this->_MovieSummury = MovieSummury_;
}

inline void T_MovieDetails::setMovieSummury (const char* MovieSummury_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieSummury_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieSummury();
    this->_MovieSummury.assign(MovieSummury_);
}

inline void T_MovieDetails::setMovieSummury (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieSummury();
    this->_MovieSummury.assign(value, size);
}

inline void T_MovieDetails::clearMovieTimesList() {
    if (hasMovieTimesList()) {
         clear_has_MovieTimesList();
        _MovieTimesList.clear();
     }
}

inline bool T_MovieDetails::hasMovieTimesList () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const T_MovieTimesList& T_MovieDetails::getMovieTimesList () const {
    return _MovieTimesList;
}

inline T_MovieTimesList& T_MovieDetails::getMovieTimesListMutable () {
    set_has_MovieTimesList();
    return _MovieTimesList;
}

inline void T_MovieDetails::setMovieTimesList (const T_MovieTimesList& MovieTimesList_) {
    set_has_MovieTimesList();
    this->_MovieTimesList = MovieTimesList_;
}

inline void T_MovieDetails::set_has_MOVIE_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MovieDetails::clear_has_MOVIE_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MovieDetails::set_has_MovieName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MovieDetails::clear_has_MovieName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MovieDetails::set_has_MovieRating () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MovieDetails::clear_has_MovieRating () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MovieDetails::set_has_sMovieLength () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MovieDetails::clear_has_sMovieLength () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MovieDetails::set_has_MovieActors () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MovieDetails::clear_has_MovieActors () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MovieDetails::set_has_MovieSummury () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MovieDetails::clear_has_MovieSummury () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_MovieDetails::set_has_MovieTimesList () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_MovieDetails::clear_has_MovieTimesList () {
    _has_bits_[0] &= ~ (1u << 6);
}

} // namespace sxm_movies_main_fi_types

#endif // SXM_MOVIES_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
