#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_MOVIES_MAIN_FI_H
#define SXM_MOVIES_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include "sxm_movies_main_fi_types.h"
#include "sxm_movies_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'sxm_movies_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Movies
 *
 * Version: $Revision:   0.2  $
 *
 * Author: Narasimhulu Kavadapu
 *
 * Date: $Date:   Feb 14 2013  16:00 PM  $
 *
 * Department: ECV
 *
 * Title: sxm_movies_main_fi
 *
 * <b>Description of 'sxm_movies_main_fi':</b>
 *
 * RBEI
 */

namespace sxm_movies_main_fi {

static const int SERVICE_ID = 156;

static const int FID_GetTheatreList = 1;

static const int FID_GetTheatreInfo = 2;

static const int FID_GetMoviesList = 3;

static const int FID_GetMovieInfo = 4;

static const int FID_AddFavorite = 5;

static const int FID_RemoveFavorite = 6;

static const int FID_SearchMovie = 8;

static const int FID_SetListsConfig = 9;

static const int FID_TheatreListsStatus = 16;

static const int FID_SxmDataServiceStatus = 17;

static const int FID_SxmListMode = 18;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 7;

// forward declarations
class GetTheatreListStart;

class GetTheatreListResult;

class GetTheatreListErrorStructure;

class GetTheatreListError;

class GetTheatreInfoStart;

class GetTheatreInfoResult;

class GetTheatreInfoErrorStructure;

class GetTheatreInfoError;

class GetMoviesListStart;

class GetMoviesListResult;

class GetMoviesListErrorStructure;

class GetMoviesListError;

class GetMovieInfoStart;

class GetMovieInfoResult;

class GetMovieInfoErrorStructure;

class GetMovieInfoError;

class AddFavoriteStart;

class AddFavoriteResult;

class RemoveFavoriteStart;

class RemoveFavoriteResult;

class SearchMovieStart;

class SearchMovieResult;

class SearchMovieErrorStructure;

class SearchMovieError;

class SetListsConfigStart;

class SetListsConfigResult;

class TheatreListsStatusStatus;

class SxmDataServiceStatusStatus;

class SxmListModeStatus;

class SxmListModeSet;

// type definitions
/**
 * The abort error message of the method "GetTheatreList"
 * This method is used to get list of theaters containing theater name and other details.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTheatreListAbortError;

/**
 * The abort error message of the method "GetTheatreInfo"
 * Get complete details of particular theater.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTheatreInfoAbortError;

/**
 * The abort error message of the method "GetMoviesList"
 * This method is used to get list of movies containing movie name and other required details.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetMoviesListAbortError;

/**
 * The abort error message of the method "GetMovieInfo"
 * Get complete details of particular theater.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetMovieInfoAbortError;

/**
 * The abort error message of the method "AddFavorite"
 * This method is used to add a Theatre
 * to favorite list
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFavoriteAbortError;

/**
 * The error message of 'AddFavorite'
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFavoriteError;

/**
 * The abort error message of the method "RemoveFavorite"
 * This method is used to Remove Theatre
 * from favorite list
 */
typedef ::asf::cca::CcaTypes::DefaultError RemoveFavoriteAbortError;

/**
 * The error message of 'RemoveFavorite'
 */
typedef ::asf::cca::CcaTypes::DefaultError RemoveFavoriteError;

/**
 * The abort error message of the method "SearchMovie"
 * This method is used to get list of movies containing used typed string.
 */
typedef ::asf::cca::CcaTypes::DefaultError SearchMovieAbortError;

/**
 * The abort error message of the method "SetListsConfig"
 * This method is used to configure theatre lists.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetListsConfigAbortError;

/**
 * The error message of 'SetListsConfig'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetListsConfigError;

/**
 * The get message of the property "TheatreListsStatus"
 * Status of all configured Lists
 * To Get Theater Lists Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TheatreListsStatusGet;

/**
 * The upreg message of the property "TheatreListsStatus"
 * Status of all configured Lists
 * Register for Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TheatreListsStatusUpReg;

/**
 * The relUpReg message of the property "TheatreListsStatus"
 * Status of all configured Lists
 * Unregister for Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TheatreListsStatusRelUpReg;

/**
 * The error message of 'TheatreListsStatus'
 * Error Description
 */
typedef ::asf::cca::CcaTypes::DefaultError TheatreListsStatusError;

/**
 * The get message of the property "SxmDataServiceStatus"
 * Get the Status of Movies Data Service
 * Status of Movies Data Service
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusGet;

/**
 * The upreg message of the property "SxmDataServiceStatus"
 * Get the Status of Movies Data Service
 * Register for Movies Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusUpReg;

/**
 * The relUpReg message of the property "SxmDataServiceStatus"
 * Get the Status of Movies Data Service
 * Unregister for Movies Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusRelUpReg;

/**
 * The error message of 'SxmDataServiceStatus'
 * This error code specifies Movies Data Service Status is not available
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmDataServiceStatusError;

/**
 * The upreg message of the property "SxmListMode"
 * Set the Mode of Movies List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeUpReg;

/**
 * The relUpReg message of the property "SxmListMode"
 * Set the Mode of Movies List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeRelUpReg;

/**
 * The error message of 'SxmListMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmListModeError;


/**
 * The start message of the method "GetTheatreList"
 * This method is used to get list of theaters containing theater name and other details.
 */
class GetTheatreListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTheatreListStart ();

    /**
     * Copy constructor
     */
    inline  GetTheatreListStart (const GetTheatreListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetTheatreListStart (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, uint32 MovieID_, const ::std::string& SearchString_);

    /**
     * Destructor
     */
    inline virtual  ~GetTheatreListStart();

    /**
     * Assignment operator
     */
    inline GetTheatreListStart& operator = (const GetTheatreListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTheatreListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTheatreListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTheatreListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTheatreListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Theatre type information to filter theatre info
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Theatre type information to filter theatre info
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "Operation"

    static const int kOperation = 1;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * Operation to be performed
     *
     * @return The value of the field "Operation"
     */
    inline ::sxm_main_fi_types::T_e8_SxmListOperation getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * Operation to be performed
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_);

    // API of field "MovieID"

    static const int kMovieID = 2;

    /**
     * Clears the field "MovieID".
     *
     * The field will be set to its default value. The hasMovieID()
     * method will return false.
     */
    inline void clearMovieID();

    /**
     * Checks whether the field "MovieID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovieID()). Otherwise it will return false.
     */
    inline bool hasMovieID () const;

    /**
     * Returns the value of the member "MovieID".
     *
     * To get theatre list playing particular movie.
     * MovieID shall be zero , for complete theater list.
     *
     * @return The value of the field "MovieID"
     */
    inline uint32 getMovieID () const;

    /**
     * Sets the value of the member "MovieID".
     *
     * To get theatre list playing particular movie.
     * MovieID shall be zero , for complete theater list.
     *
     * @param MovieID The value which will be set
     */
    inline void setMovieID (uint32 MovieID_);

    // API of field "SearchString"

    static const int kSearchString = 3;

    /**
     * Clears the field "SearchString".
     *
     * The field will be set to its default value. The hasSearchString()
     * method will return false.
     */
    inline void clearSearchString();

    /**
     * Checks whether the field "SearchString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSearchString()). Otherwise it will return false.
     */
    inline bool hasSearchString () const;

    /**
     * Returns the value of the member "SearchString".
     *
     * To get theater list containing "SearchString".
     * SearchString shall be used for "SearchTheaters" case
     *
     * @return The value of the field "SearchString"
     */
    inline const ::std::string& getSearchString () const;

    /**
     * Retrieves the value of the field "SearchString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SearchString".
     */
    inline ::std::string& getSearchStringMutable ();

    /**
     * Sets the value of the member "SearchString".
     *
     * To get theater list containing "SearchString".
     * SearchString shall be used for "SearchTheaters" case
     *
     * @param SearchString The value which will be set
     */
    inline void setSearchString (const ::std::string& SearchString_);

    /**
     * Sets the value of the member "SearchString".
     *
     * To get theater list containing "SearchString".
     * SearchString shall be used for "SearchTheaters" case
     *
     * @param SearchString The value which will be set
     */
    inline void setSearchString (const char* SearchString_);

    /**
     * Sets the value of the member "SearchString".
     *
     * To get theater list containing "SearchString".
     * SearchString shall be used for "SearchTheaters" case
     *
     * @param SearchString The value which will be set
     */
    inline void setSearchString (const char* value, size_t size);

    static const GetTheatreListStart &getDefaultInstance();

private:

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    inline void set_has_MovieID ();

    inline void clear_has_MovieID ();

    inline void set_has_SearchString ();

    inline void clear_has_SearchString ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _ListID;

    ::sxm_main_fi_types::T_e8_SxmListOperation _Operation;

    uint32 _MovieID;

    ::std::string _SearchString;

};

/**
 * The result message of the method "GetTheatreList"
 * This method is used to get list of theaters containing theater name and other details.
 */
class GetTheatreListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTheatreListResult ();

    /**
     * Copy constructor
     */
    inline  GetTheatreListResult (const GetTheatreListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetTheatreListResult (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_, const ::sxm_movies_main_fi_types::T_TheatreInfoList& TheatreInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~GetTheatreListResult();

    /**
     * Assignment operator
     */
    inline GetTheatreListResult& operator = (const GetTheatreListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTheatreListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTheatreListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTheatreListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTheatreListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Theatre type information to filter theatre info.
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Theatre type information to filter theatre info.
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "Operation"

    static const int kOperation = 1;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * Operation as in method-start
     *
     * @return The value of the field "Operation"
     */
    inline ::sxm_main_fi_types::T_e8_SxmListOperation getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * Operation as in method-start
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_);

    // API of field "ListInfo"

    static const int kListInfo = 2;

    /**
     * Clears the field "ListInfo".
     *
     * The field will be set to its default value. The hasListInfo()
     * method will return false.
     */
    inline void clearListInfo();

    /**
     * Checks whether the field "ListInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListInfo()). Otherwise it will return false.
     */
    inline bool hasListInfo () const;

    /**
     * Returns the value of the member "ListInfo".
     *
     * Information about the received list
     *
     * @return The value of the field "ListInfo"
     */
    inline const ::sxm_main_fi_types::T_SxmListInfo& getListInfo () const;

    /**
     * Retrieves the value of the field "ListInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListInfo".
     */
    inline ::sxm_main_fi_types::T_SxmListInfo& getListInfoMutable ();

    /**
     * Sets the value of the member "ListInfo".
     *
     * Information about the received list
     *
     * @param ListInfo The value which will be set
     */
    inline void setListInfo (const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_);

    // API of field "TheatreInfoList"

    static const int kTheatreInfoList = 3;

    /**
     * Clears the field "TheatreInfoList".
     *
     * The field will be set to its default value. The hasTheatreInfoList()
     * method will return false.
     */
    inline void clearTheatreInfoList();

    /**
     * Checks whether the field "TheatreInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheatreInfoList()). Otherwise it will return false.
     */
    inline bool hasTheatreInfoList () const;

    /**
     * Returns the value of the member "TheatreInfoList".
     *
     * list of theaters with their name and other info.
     *
     * @return The value of the field "TheatreInfoList"
     */
    inline const ::sxm_movies_main_fi_types::T_TheatreInfoList& getTheatreInfoList () const;

    /**
     * Retrieves the value of the field "TheatreInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheatreInfoList".
     */
    inline ::sxm_movies_main_fi_types::T_TheatreInfoList& getTheatreInfoListMutable ();

    /**
     * Sets the value of the member "TheatreInfoList".
     *
     * list of theaters with their name and other info.
     *
     * @param TheatreInfoList The value which will be set
     */
    inline void setTheatreInfoList (const ::sxm_movies_main_fi_types::T_TheatreInfoList& TheatreInfoList_);

    static const GetTheatreListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_movies_main_fi_types::T_TheatreInfo >& getT_TheatreInfoList_DefaultInstance ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    inline void set_has_ListInfo ();

    inline void clear_has_ListInfo ();

    inline void set_has_TheatreInfoList ();

    inline void clear_has_TheatreInfoList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _ListID;

    ::sxm_main_fi_types::T_e8_SxmListOperation _Operation;

    ::sxm_main_fi_types::T_SxmListInfo _ListInfo;

    ::sxm_movies_main_fi_types::T_TheatreInfoList _TheatreInfoList;

};

/**
 * The error message of 'GetTheatreList'
 */
class GetTheatreListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetTheatreListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetTheatreListErrorStructure (const GetTheatreListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetTheatreListErrorStructure (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetTheatreListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetTheatreListErrorStructure& operator = (const GetTheatreListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTheatreListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTheatreListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTheatreListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTheatreListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies theatre list is empty.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_movies_main_fi_types::T_e8MovieErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies theatre list is empty.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_);

    static const GetTheatreListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_movies_main_fi_types::T_e8MovieErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetTheatreList'
 */
class GetTheatreListError  : public ::asf::core::Payload {
public:

    enum GetTheatreListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetTheatreListError ();

   /**
     * Copy constructor
     */
    inline  GetTheatreListError (const GetTheatreListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetTheatreListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetTheatreListError& operator = (const GetTheatreListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTheatreListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTheatreListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTheatreListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTheatreListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetTheatreListError::GetTheatreListErrorField getField () const;

    inline void setField(GetTheatreListError::GetTheatreListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetTheatreListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetTheatreListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetTheatreListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetTheatreListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetTheatreListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetTheatreListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetTheatreListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetTheatreListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetTheatreListError &getDefaultInstance();

private:

    inline void cloneData (const GetTheatreListError& rhs);

    inline void deleteData ();

    GetTheatreListErrorField __field;

    union {
        GetTheatreListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetTheatreInfo"
 * Get complete details of particular theater.
 */
class GetTheatreInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTheatreInfoStart ();

    /**
     * Copy constructor
     */
    inline  GetTheatreInfoStart (const GetTheatreInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetTheatreInfoStart (uint32 THEATRE_LOCID_, uint32 ListID_);

    /**
     * Destructor
     */
    inline virtual  ~GetTheatreInfoStart();

    /**
     * Assignment operator
     */
    inline GetTheatreInfoStart& operator = (const GetTheatreInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTheatreInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTheatreInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTheatreInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTheatreInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "THEATRE_LOCID"

    static const int kTHEATRE_LOCID = 0;

    /**
     * Clears the field "THEATRE_LOCID".
     *
     * The field will be set to its default value. The hasTHEATRE_LOCID()
     * method will return false.
     */
    inline void clearTHEATRE_LOCID();

    /**
     * Checks whether the field "THEATRE_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTHEATRE_LOCID()). Otherwise it will return false.
     */
    inline bool hasTHEATRE_LOCID () const;

    /**
     * Returns the value of the member "THEATRE_LOCID".
     *
     * Theatre Location ID
     *
     * @return The value of the field "THEATRE_LOCID"
     */
    inline uint32 getTHEATRE_LOCID () const;

    /**
     * Sets the value of the member "THEATRE_LOCID".
     *
     * Theatre Location ID
     *
     * @param THEATRE_LOCID The value which will be set
     */
    inline void setTHEATRE_LOCID (uint32 THEATRE_LOCID_);

    // API of field "ListID"

    static const int kListID = 1;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Theatre Location Type
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Theatre Location Type
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    static const GetTheatreInfoStart &getDefaultInstance();

private:

    inline void set_has_THEATRE_LOCID ();

    inline void clear_has_THEATRE_LOCID ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _THEATRE_LOCID;

    uint32 _ListID;

};

/**
 * The result message of the method "GetTheatreInfo"
 * Get complete details of particular theater.
 */
class GetTheatreInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTheatreInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetTheatreInfoResult (const GetTheatreInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetTheatreInfoResult (const ::sxm_movies_main_fi_types::T_TheatreDetails& TheatreInfo_, uint32 ListID_);

    /**
     * Destructor
     */
    inline virtual  ~GetTheatreInfoResult();

    /**
     * Assignment operator
     */
    inline GetTheatreInfoResult& operator = (const GetTheatreInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTheatreInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTheatreInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTheatreInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTheatreInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TheatreInfo"

    static const int kTheatreInfo = 0;

    /**
     * Clears the field "TheatreInfo".
     *
     * The field will be set to its default value. The hasTheatreInfo()
     * method will return false.
     */
    inline void clearTheatreInfo();

    /**
     * Checks whether the field "TheatreInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheatreInfo()). Otherwise it will return false.
     */
    inline bool hasTheatreInfo () const;

    /**
     * Returns the value of the member "TheatreInfo".
     *
     * Theatre details.
     *
     * @return The value of the field "TheatreInfo"
     */
    inline const ::sxm_movies_main_fi_types::T_TheatreDetails& getTheatreInfo () const;

    /**
     * Retrieves the value of the field "TheatreInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheatreInfo".
     */
    inline ::sxm_movies_main_fi_types::T_TheatreDetails& getTheatreInfoMutable ();

    /**
     * Sets the value of the member "TheatreInfo".
     *
     * Theatre details.
     *
     * @param TheatreInfo The value which will be set
     */
    inline void setTheatreInfo (const ::sxm_movies_main_fi_types::T_TheatreDetails& TheatreInfo_);

    // API of field "ListID"

    static const int kListID = 1;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Location Type.
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Location Type.
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    static const GetTheatreInfoResult &getDefaultInstance();

private:

    inline void set_has_TheatreInfo ();

    inline void clear_has_TheatreInfo ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_movies_main_fi_types::T_TheatreDetails _TheatreInfo;

    uint32 _ListID;

};

/**
 * The error message of 'GetTheatreInfo'
 */
class GetTheatreInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetTheatreInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetTheatreInfoErrorStructure (const GetTheatreInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetTheatreInfoErrorStructure (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetTheatreInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetTheatreInfoErrorStructure& operator = (const GetTheatreInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTheatreInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTheatreInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTheatreInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTheatreInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Theatre unavailability
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_movies_main_fi_types::T_e8MovieErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Theatre unavailability
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_);

    static const GetTheatreInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_movies_main_fi_types::T_e8MovieErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetTheatreInfo'
 */
class GetTheatreInfoError  : public ::asf::core::Payload {
public:

    enum GetTheatreInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetTheatreInfoError ();

   /**
     * Copy constructor
     */
    inline  GetTheatreInfoError (const GetTheatreInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetTheatreInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetTheatreInfoError& operator = (const GetTheatreInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTheatreInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTheatreInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTheatreInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTheatreInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetTheatreInfoError::GetTheatreInfoErrorField getField () const;

    inline void setField(GetTheatreInfoError::GetTheatreInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetTheatreInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetTheatreInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetTheatreInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetTheatreInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetTheatreInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetTheatreInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetTheatreInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetTheatreInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetTheatreInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetTheatreInfoError& rhs);

    inline void deleteData ();

    GetTheatreInfoErrorField __field;

    union {
        GetTheatreInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetMoviesList"
 * This method is used to get list of movies containing movie name and other required details.
 */
class GetMoviesListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMoviesListStart ();

    /**
     * Copy constructor
     */
    inline  GetMoviesListStart (const GetMoviesListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetMoviesListStart (uint32 ListID_, uint32 Theater_LOCID_);

    /**
     * Destructor
     */
    inline virtual  ~GetMoviesListStart();

    /**
     * Assignment operator
     */
    inline GetMoviesListStart& operator = (const GetMoviesListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMoviesListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMoviesListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMoviesListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMoviesListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Movie information to filter movie info
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Movie information to filter movie info
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "Theater_LOCID"

    static const int kTheater_LOCID = 1;

    /**
     * Clears the field "Theater_LOCID".
     *
     * The field will be set to its default value. The hasTheater_LOCID()
     * method will return false.
     */
    inline void clearTheater_LOCID();

    /**
     * Checks whether the field "Theater_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheater_LOCID()). Otherwise it will return false.
     */
    inline bool hasTheater_LOCID () const;

    /**
     * Returns the value of the member "Theater_LOCID".
     *
     * here Theater_LOCID implies a theater location ID to get movies list of particular theater.
     * for complete movies list,Theater_LOCID should be zero.
     *
     * @return The value of the field "Theater_LOCID"
     */
    inline uint32 getTheater_LOCID () const;

    /**
     * Sets the value of the member "Theater_LOCID".
     *
     * here Theater_LOCID implies a theater location ID to get movies list of particular theater.
     * for complete movies list,Theater_LOCID should be zero.
     *
     * @param Theater_LOCID The value which will be set
     */
    inline void setTheater_LOCID (uint32 Theater_LOCID_);

    static const GetMoviesListStart &getDefaultInstance();

private:

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_Theater_LOCID ();

    inline void clear_has_Theater_LOCID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ListID;

    uint32 _Theater_LOCID;

};

/**
 * The result message of the method "GetMoviesList"
 * This method is used to get list of movies containing movie name and other required details.
 */
class GetMoviesListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMoviesListResult ();

    /**
     * Copy constructor
     */
    inline  GetMoviesListResult (const GetMoviesListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetMoviesListResult (uint32 ListID_, const ::sxm_movies_main_fi_types::T_MoviesList& MoviesInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~GetMoviesListResult();

    /**
     * Assignment operator
     */
    inline GetMoviesListResult& operator = (const GetMoviesListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMoviesListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMoviesListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMoviesListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMoviesListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * movie information to filter movie info.
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * movie information to filter movie info.
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "MoviesInfoList"

    static const int kMoviesInfoList = 1;

    /**
     * Clears the field "MoviesInfoList".
     *
     * The field will be set to its default value. The hasMoviesInfoList()
     * method will return false.
     */
    inline void clearMoviesInfoList();

    /**
     * Checks whether the field "MoviesInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMoviesInfoList()). Otherwise it will return false.
     */
    inline bool hasMoviesInfoList () const;

    /**
     * Returns the value of the member "MoviesInfoList".
     *
     * list of movies with their name and other required info.
     *
     * @return The value of the field "MoviesInfoList"
     */
    inline const ::sxm_movies_main_fi_types::T_MoviesList& getMoviesInfoList () const;

    /**
     * Retrieves the value of the field "MoviesInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MoviesInfoList".
     */
    inline ::sxm_movies_main_fi_types::T_MoviesList& getMoviesInfoListMutable ();

    /**
     * Sets the value of the member "MoviesInfoList".
     *
     * list of movies with their name and other required info.
     *
     * @param MoviesInfoList The value which will be set
     */
    inline void setMoviesInfoList (const ::sxm_movies_main_fi_types::T_MoviesList& MoviesInfoList_);

    static const GetMoviesListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_movies_main_fi_types::T_MovieInfo >& getT_MovieInfoList_DefaultInstance ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_MoviesInfoList ();

    inline void clear_has_MoviesInfoList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ListID;

    ::sxm_movies_main_fi_types::T_MoviesList _MoviesInfoList;

};

/**
 * The error message of 'GetMoviesList'
 */
class GetMoviesListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetMoviesListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetMoviesListErrorStructure (const GetMoviesListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetMoviesListErrorStructure (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetMoviesListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetMoviesListErrorStructure& operator = (const GetMoviesListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMoviesListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMoviesListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMoviesListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMoviesListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies movie list is empty.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_movies_main_fi_types::T_e8MovieErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies movie list is empty.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_);

    static const GetMoviesListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_movies_main_fi_types::T_e8MovieErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetMoviesList'
 */
class GetMoviesListError  : public ::asf::core::Payload {
public:

    enum GetMoviesListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetMoviesListError ();

   /**
     * Copy constructor
     */
    inline  GetMoviesListError (const GetMoviesListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetMoviesListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetMoviesListError& operator = (const GetMoviesListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMoviesListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMoviesListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMoviesListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMoviesListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetMoviesListError::GetMoviesListErrorField getField () const;

    inline void setField(GetMoviesListError::GetMoviesListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetMoviesListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetMoviesListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetMoviesListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetMoviesListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetMoviesListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetMoviesListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetMoviesListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetMoviesListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetMoviesListError &getDefaultInstance();

private:

    inline void cloneData (const GetMoviesListError& rhs);

    inline void deleteData ();

    GetMoviesListErrorField __field;

    union {
        GetMoviesListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetMovieInfo"
 * Get complete details of particular theater.
 */
class GetMovieInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMovieInfoStart ();

    /**
     * Copy constructor
     */
    inline  GetMovieInfoStart (const GetMovieInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetMovieInfoStart (uint32 MOVIE_ID_, uint32 ListID_, uint32 Theater_LOCID_);

    /**
     * Destructor
     */
    inline virtual  ~GetMovieInfoStart();

    /**
     * Assignment operator
     */
    inline GetMovieInfoStart& operator = (const GetMovieInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMovieInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMovieInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMovieInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMovieInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MOVIE_ID"

    static const int kMOVIE_ID = 0;

    /**
     * Clears the field "MOVIE_ID".
     *
     * The field will be set to its default value. The hasMOVIE_ID()
     * method will return false.
     */
    inline void clearMOVIE_ID();

    /**
     * Checks whether the field "MOVIE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMOVIE_ID()). Otherwise it will return false.
     */
    inline bool hasMOVIE_ID () const;

    /**
     * Returns the value of the member "MOVIE_ID".
     *
     * Movie ID
     *
     * @return The value of the field "MOVIE_ID"
     */
    inline uint32 getMOVIE_ID () const;

    /**
     * Sets the value of the member "MOVIE_ID".
     *
     * Movie ID
     *
     * @param MOVIE_ID The value which will be set
     */
    inline void setMOVIE_ID (uint32 MOVIE_ID_);

    // API of field "ListID"

    static const int kListID = 1;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Theatre Location Type in which movie is playing
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Theatre Location Type in which movie is playing
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "Theater_LOCID"

    static const int kTheater_LOCID = 2;

    /**
     * Clears the field "Theater_LOCID".
     *
     * The field will be set to its default value. The hasTheater_LOCID()
     * method will return false.
     */
    inline void clearTheater_LOCID();

    /**
     * Checks whether the field "Theater_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheater_LOCID()). Otherwise it will return false.
     */
    inline bool hasTheater_LOCID () const;

    /**
     * Returns the value of the member "Theater_LOCID".
     *
     * here Theater_LOCID implies a theater location ID to get movies details if playing in particular theater.
     * for particular movie detials(i.e MOVI_ID) playing in any theatre ,Theater_LOCID should be zero.
     *
     * @return The value of the field "Theater_LOCID"
     */
    inline uint32 getTheater_LOCID () const;

    /**
     * Sets the value of the member "Theater_LOCID".
     *
     * here Theater_LOCID implies a theater location ID to get movies details if playing in particular theater.
     * for particular movie detials(i.e MOVI_ID) playing in any theatre ,Theater_LOCID should be zero.
     *
     * @param Theater_LOCID The value which will be set
     */
    inline void setTheater_LOCID (uint32 Theater_LOCID_);

    static const GetMovieInfoStart &getDefaultInstance();

private:

    inline void set_has_MOVIE_ID ();

    inline void clear_has_MOVIE_ID ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_Theater_LOCID ();

    inline void clear_has_Theater_LOCID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _MOVIE_ID;

    uint32 _ListID;

    uint32 _Theater_LOCID;

};

/**
 * The result message of the method "GetMovieInfo"
 * Get complete details of particular theater.
 */
class GetMovieInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMovieInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetMovieInfoResult (const GetMovieInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetMovieInfoResult (const ::sxm_movies_main_fi_types::T_MovieDetails& MovieInfo_, uint32 ListID_);

    /**
     * Destructor
     */
    inline virtual  ~GetMovieInfoResult();

    /**
     * Assignment operator
     */
    inline GetMovieInfoResult& operator = (const GetMovieInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMovieInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMovieInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMovieInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMovieInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MovieInfo"

    static const int kMovieInfo = 0;

    /**
     * Clears the field "MovieInfo".
     *
     * The field will be set to its default value. The hasMovieInfo()
     * method will return false.
     */
    inline void clearMovieInfo();

    /**
     * Checks whether the field "MovieInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovieInfo()). Otherwise it will return false.
     */
    inline bool hasMovieInfo () const;

    /**
     * Returns the value of the member "MovieInfo".
     *
     * Movie information.
     *
     * @return The value of the field "MovieInfo"
     */
    inline const ::sxm_movies_main_fi_types::T_MovieDetails& getMovieInfo () const;

    /**
     * Retrieves the value of the field "MovieInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MovieInfo".
     */
    inline ::sxm_movies_main_fi_types::T_MovieDetails& getMovieInfoMutable ();

    /**
     * Sets the value of the member "MovieInfo".
     *
     * Movie information.
     *
     * @param MovieInfo The value which will be set
     */
    inline void setMovieInfo (const ::sxm_movies_main_fi_types::T_MovieDetails& MovieInfo_);

    // API of field "ListID"

    static const int kListID = 1;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Theatre Location Type in which movie is playing.
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Theatre Location Type in which movie is playing.
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    static const GetMovieInfoResult &getDefaultInstance();

private:

    inline void set_has_MovieInfo ();

    inline void clear_has_MovieInfo ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_movies_main_fi_types::T_MovieDetails _MovieInfo;

    uint32 _ListID;

};

/**
 * The error message of 'GetMovieInfo'
 */
class GetMovieInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetMovieInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetMovieInfoErrorStructure (const GetMovieInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetMovieInfoErrorStructure (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetMovieInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetMovieInfoErrorStructure& operator = (const GetMovieInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMovieInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMovieInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMovieInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMovieInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies movie unavailability
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_movies_main_fi_types::T_e8MovieErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies movie unavailability
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_);

    static const GetMovieInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_movies_main_fi_types::T_e8MovieErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetMovieInfo'
 */
class GetMovieInfoError  : public ::asf::core::Payload {
public:

    enum GetMovieInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetMovieInfoError ();

   /**
     * Copy constructor
     */
    inline  GetMovieInfoError (const GetMovieInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetMovieInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetMovieInfoError& operator = (const GetMovieInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMovieInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMovieInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMovieInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMovieInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetMovieInfoError::GetMovieInfoErrorField getField () const;

    inline void setField(GetMovieInfoError::GetMovieInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetMovieInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetMovieInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetMovieInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetMovieInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetMovieInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetMovieInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetMovieInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetMovieInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetMovieInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetMovieInfoError& rhs);

    inline void deleteData ();

    GetMovieInfoErrorField __field;

    union {
        GetMovieInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AddFavorite"
 * This method is used to add a Theatre
 * to favorite list
 */
class AddFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteStart (const AddFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteStart (uint32 Theater_LOCID_);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteStart();

    /**
     * Assignment operator
     */
    inline AddFavoriteStart& operator = (const AddFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Theater_LOCID"

    static const int kTheater_LOCID = 0;

    /**
     * Clears the field "Theater_LOCID".
     *
     * The field will be set to its default value. The hasTheater_LOCID()
     * method will return false.
     */
    inline void clearTheater_LOCID();

    /**
     * Checks whether the field "Theater_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheater_LOCID()). Otherwise it will return false.
     */
    inline bool hasTheater_LOCID () const;

    /**
     * Returns the value of the member "Theater_LOCID".
     *
     * Theatre Location ID
     *
     * @return The value of the field "Theater_LOCID"
     */
    inline uint32 getTheater_LOCID () const;

    /**
     * Sets the value of the member "Theater_LOCID".
     *
     * Theatre Location ID
     *
     * @param Theater_LOCID The value which will be set
     */
    inline void setTheater_LOCID (uint32 Theater_LOCID_);

    static const AddFavoriteStart &getDefaultInstance();

private:

    inline void set_has_Theater_LOCID ();

    inline void clear_has_Theater_LOCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Theater_LOCID;

};

/**
 * The result message of the method "AddFavorite"
 * This method is used to add a Theatre
 * to favorite list
 */
class AddFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteResult (const AddFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteResult();

    /**
     * Assignment operator
     */
    inline AddFavoriteResult& operator = (const AddFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Successfully added in favorite list returns -  True
     * else returns  - False
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Successfully added in favorite list returns -  True
     * else returns  - False
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const AddFavoriteResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "RemoveFavorite"
 * This method is used to Remove Theatre
 * from favorite list
 */
class RemoveFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteStart (const RemoveFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteStart (uint32 Theater_LOCID_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteStart();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteStart& operator = (const RemoveFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Theater_LOCID"

    static const int kTheater_LOCID = 0;

    /**
     * Clears the field "Theater_LOCID".
     *
     * The field will be set to its default value. The hasTheater_LOCID()
     * method will return false.
     */
    inline void clearTheater_LOCID();

    /**
     * Checks whether the field "Theater_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheater_LOCID()). Otherwise it will return false.
     */
    inline bool hasTheater_LOCID () const;

    /**
     * Returns the value of the member "Theater_LOCID".
     *
     * Theatre Location ID
     *
     * @return The value of the field "Theater_LOCID"
     */
    inline uint32 getTheater_LOCID () const;

    /**
     * Sets the value of the member "Theater_LOCID".
     *
     * Theatre Location ID
     *
     * @param Theater_LOCID The value which will be set
     */
    inline void setTheater_LOCID (uint32 Theater_LOCID_);

    static const RemoveFavoriteStart &getDefaultInstance();

private:

    inline void set_has_Theater_LOCID ();

    inline void clear_has_Theater_LOCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Theater_LOCID;

};

/**
 * The result message of the method "RemoveFavorite"
 * This method is used to Remove Theatre
 * from favorite list
 */
class RemoveFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteResult (const RemoveFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteResult();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteResult& operator = (const RemoveFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Successfully removed from favorite list returns -  True
     * else returns  - False
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Successfully removed from favorite list returns -  True
     * else returns  - False
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const RemoveFavoriteResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SearchMovie"
 * This method is used to get list of movies containing used typed string.
 */
class SearchMovieStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SearchMovieStart ();

    /**
     * Copy constructor
     */
    inline  SearchMovieStart (const SearchMovieStart &rhs);

    /**
     * All fields constructor
     */
    inline  SearchMovieStart (const ::std::string& MovieName_);

    /**
     * Destructor
     */
    inline virtual  ~SearchMovieStart();

    /**
     * Assignment operator
     */
    inline SearchMovieStart& operator = (const SearchMovieStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchMovieStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchMovieStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchMovieStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchMovieStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MovieName"

    static const int kMovieName = 0;

    /**
     * Clears the field "MovieName".
     *
     * The field will be set to its default value. The hasMovieName()
     * method will return false.
     */
    inline void clearMovieName();

    /**
     * Checks whether the field "MovieName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovieName()). Otherwise it will return false.
     */
    inline bool hasMovieName () const;

    /**
     * Returns the value of the member "MovieName".
     *
     * Name of the movie user want to search for.
     *
     * @return The value of the field "MovieName"
     */
    inline const ::std::string& getMovieName () const;

    /**
     * Retrieves the value of the field "MovieName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MovieName".
     */
    inline ::std::string& getMovieNameMutable ();

    /**
     * Sets the value of the member "MovieName".
     *
     * Name of the movie user want to search for.
     *
     * @param MovieName The value which will be set
     */
    inline void setMovieName (const ::std::string& MovieName_);

    /**
     * Sets the value of the member "MovieName".
     *
     * Name of the movie user want to search for.
     *
     * @param MovieName The value which will be set
     */
    inline void setMovieName (const char* MovieName_);

    /**
     * Sets the value of the member "MovieName".
     *
     * Name of the movie user want to search for.
     *
     * @param MovieName The value which will be set
     */
    inline void setMovieName (const char* value, size_t size);

    static const SearchMovieStart &getDefaultInstance();

private:

    inline void set_has_MovieName ();

    inline void clear_has_MovieName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _MovieName;

};

/**
 * The result message of the method "SearchMovie"
 * This method is used to get list of movies containing used typed string.
 */
class SearchMovieResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SearchMovieResult ();

    /**
     * Copy constructor
     */
    inline  SearchMovieResult (const SearchMovieResult &rhs);

    /**
     * All fields constructor
     */
    inline  SearchMovieResult (const ::sxm_movies_main_fi_types::T_MoviesList& MoviesList_);

    /**
     * Destructor
     */
    inline virtual  ~SearchMovieResult();

    /**
     * Assignment operator
     */
    inline SearchMovieResult& operator = (const SearchMovieResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchMovieResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchMovieResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchMovieResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchMovieResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MoviesList"

    static const int kMoviesList = 0;

    /**
     * Clears the field "MoviesList".
     *
     * The field will be set to its default value. The hasMoviesList()
     * method will return false.
     */
    inline void clearMoviesList();

    /**
     * Checks whether the field "MoviesList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMoviesList()). Otherwise it will return false.
     */
    inline bool hasMoviesList () const;

    /**
     * Returns the value of the member "MoviesList".
     *
     * list of movies containing search string.
     *
     * @return The value of the field "MoviesList"
     */
    inline const ::sxm_movies_main_fi_types::T_MoviesList& getMoviesList () const;

    /**
     * Retrieves the value of the field "MoviesList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MoviesList".
     */
    inline ::sxm_movies_main_fi_types::T_MoviesList& getMoviesListMutable ();

    /**
     * Sets the value of the member "MoviesList".
     *
     * list of movies containing search string.
     *
     * @param MoviesList The value which will be set
     */
    inline void setMoviesList (const ::sxm_movies_main_fi_types::T_MoviesList& MoviesList_);

    static const SearchMovieResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_movies_main_fi_types::T_MovieInfo >& getT_MovieInfoList_DefaultInstance ();

    inline void set_has_MoviesList ();

    inline void clear_has_MoviesList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_movies_main_fi_types::T_MoviesList _MoviesList;

};

/**
 * The error message of 'SearchMovie'
 */
class SearchMovieErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SearchMovieErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SearchMovieErrorStructure (const SearchMovieErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SearchMovieErrorStructure (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SearchMovieErrorStructure();

    /**
     * Assignment operator
     */
    inline SearchMovieErrorStructure& operator = (const SearchMovieErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchMovieErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchMovieErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchMovieErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchMovieErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies movies list is not available yet.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_movies_main_fi_types::T_e8MovieErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies movies list is not available yet.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_);

    static const SearchMovieErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_movies_main_fi_types::T_e8MovieErrorTypes _ErrorCode;

};

/**
 * The error message of 'SearchMovie'
 */
class SearchMovieError  : public ::asf::core::Payload {
public:

    enum SearchMovieErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SearchMovieError ();

   /**
     * Copy constructor
     */
    inline  SearchMovieError (const SearchMovieError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SearchMovieError();

    /**
     * Assigns a new value to this object.
     */
    inline SearchMovieError& operator = (const SearchMovieError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchMovieError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchMovieError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchMovieError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchMovieError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SearchMovieError::SearchMovieErrorField getField () const;

    inline void setField(SearchMovieError::SearchMovieErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SearchMovieErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SearchMovieErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SearchMovieErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SearchMovieErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SearchMovieErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SearchMovieErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SearchMovieErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SearchMovieErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SearchMovieError &getDefaultInstance();

private:

    inline void cloneData (const SearchMovieError& rhs);

    inline void deleteData ();

    SearchMovieErrorField __field;

    union {
        SearchMovieErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetListsConfig"
 * This method is used to configure theatre lists.
 */
class SetListsConfigStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigStart ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigStart (const SetListsConfigStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigStart (const ::sxm_main_fi_types::T_SxmListsConfig& Config_);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigStart();

    /**
     * Assignment operator
     */
    inline SetListsConfigStart& operator = (const SetListsConfigStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Config"

    static const int kConfig = 0;

    /**
     * Clears the field "Config".
     *
     * The field will be set to its default value. The hasConfig()
     * method will return false.
     */
    inline void clearConfig();

    /**
     * Checks whether the field "Config" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfig()). Otherwise it will return false.
     */
    inline bool hasConfig () const;

    /**
     * Returns the value of the member "Config".
     *
     * Generic configuration for all lists of Theatres
     *
     * @return The value of the field "Config"
     */
    inline const ::sxm_main_fi_types::T_SxmListsConfig& getConfig () const;

    /**
     * Retrieves the value of the field "Config" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Config".
     */
    inline ::sxm_main_fi_types::T_SxmListsConfig& getConfigMutable ();

    /**
     * Sets the value of the member "Config".
     *
     * Generic configuration for all lists of Theatres
     *
     * @param Config The value which will be set
     */
    inline void setConfig (const ::sxm_main_fi_types::T_SxmListsConfig& Config_);

    static const SetListsConfigStart &getDefaultInstance();

private:

    inline void set_has_Config ();

    inline void clear_has_Config ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListsConfig _Config;

};

/**
 * The result message of the method "SetListsConfig"
 * This method is used to configure theatre lists.
 */
class SetListsConfigResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigResult ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigResult (const SetListsConfigResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigResult();

    /**
     * Assignment operator
     */
    inline SetListsConfigResult& operator = (const SetListsConfigResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE - value is accepted
     * FALSE - value is rejected
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE - value is accepted
     * FALSE - value is rejected
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetListsConfigResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The status message of the property "TheatreListsStatus"
 * Status of all configured Lists
 */
class TheatreListsStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TheatreListsStatusStatus ();

    /**
     * Copy constructor
     */
    inline  TheatreListsStatusStatus (const TheatreListsStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TheatreListsStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& TheatreListsStatus_);

    /**
     * Destructor
     */
    inline virtual  ~TheatreListsStatusStatus();

    /**
     * Assignment operator
     */
    inline TheatreListsStatusStatus& operator = (const TheatreListsStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TheatreListsStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TheatreListsStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TheatreListsStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TheatreListsStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TheatreListsStatus"

    static const int kTheatreListsStatus = 0;

    /**
     * Clears the field "TheatreListsStatus".
     *
     * The field will be set to its default value. The hasTheatreListsStatus()
     * method will return false.
     */
    inline void clearTheatreListsStatus();

    /**
     * Checks whether the field "TheatreListsStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTheatreListsStatus()). Otherwise it will return false.
     */
    inline bool hasTheatreListsStatus () const;

    /**
     * Returns the value of the member "TheatreListsStatus".
     *
     * Theatre Lists configuration and other status info.
     *
     * @return The value of the field "TheatreListsStatus"
     */
    inline const ::sxm_main_fi_types::T_SxmListInfos& getTheatreListsStatus () const;

    /**
     * Retrieves the value of the field "TheatreListsStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TheatreListsStatus".
     */
    inline ::sxm_main_fi_types::T_SxmListInfos& getTheatreListsStatusMutable ();

    /**
     * Sets the value of the member "TheatreListsStatus".
     *
     * Theatre Lists configuration and other status info.
     *
     * @param TheatreListsStatus The value which will be set
     */
    inline void setTheatreListsStatus (const ::sxm_main_fi_types::T_SxmListInfos& TheatreListsStatus_);

    static const TheatreListsStatusStatus &getDefaultInstance();

private:

    inline void set_has_TheatreListsStatus ();

    inline void clear_has_TheatreListsStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListInfos _TheatreListsStatus;

};

/**
 * The status message of the property "SxmDataServiceStatus"
 * Get the Status of Movies Data Service
 */
class SxmDataServiceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmDataServiceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    /**
     * Destructor
     */
    inline virtual  ~SxmDataServiceStatusStatus();

    /**
     * Assignment operator
     */
    inline SxmDataServiceStatusStatus& operator = (const SxmDataServiceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataServiceState"

    static const int kDataServiceState = 0;

    /**
     * Clears the field "DataServiceState".
     *
     * The field will be set to its default value. The hasDataServiceState()
     * method will return false.
     */
    inline void clearDataServiceState();

    /**
     * Checks whether the field "DataServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataServiceState()). Otherwise it will return false.
     */
    inline bool hasDataServiceState () const;

    /**
     * Returns the value of the member "DataServiceState".
     *
     * Status of Movies Data Service
     *
     * @return The value of the field "DataServiceState"
     */
    inline const ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceState () const;

    /**
     * Retrieves the value of the field "DataServiceState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DataServiceState".
     */
    inline ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceStateMutable ();

    /**
     * Sets the value of the member "DataServiceState".
     *
     * Status of Movies Data Service
     *
     * @param DataServiceState The value which will be set
     */
    inline void setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    static const SxmDataServiceStatusStatus &getDefaultInstance();

private:

    inline void set_has_DataServiceState ();

    inline void clear_has_DataServiceState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmDataSrvState _DataServiceState;

};

/**
 * The status message of the property "SxmListMode"
 * Set the Mode of Movies List.
 */
class SxmListModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeStatus ();

    /**
     * Copy constructor
     */
    inline  SxmListModeStatus (const SxmListModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeStatus();

    /**
     * Assignment operator
     */
    inline SxmListModeStatus& operator = (const SxmListModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of Movies List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of Movies List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    static const SxmListModeStatus &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

};

/**
 * The set message of the property "SxmListMode"
 * Set the Mode of Movies List.
 */
class SxmListModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeSet ();

    /**
     * Copy constructor
     */
    inline  SxmListModeSet (const SxmListModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeSet();

    /**
     * Assignment operator
     */
    inline SxmListModeSet& operator = (const SxmListModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of Movies List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of Movies List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    static const SxmListModeSet &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

};

inline  GetTheatreListStart::GetTheatreListStart ()  :
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _MovieID (0u),
    _SearchString ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTheatreListStart::GetTheatreListStart (const GetTheatreListStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _MovieID (0u),
    _SearchString ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTheatreListStart::GetTheatreListStart (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, uint32 MovieID_, const ::std::string& SearchString_)  :
    _ListID (ListID_),
    _Operation (Operation_),
    _MovieID (MovieID_),
    _SearchString (SearchString_)
{
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetTheatreListStart");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SearchString_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTheatreListStart::~GetTheatreListStart() {
}

inline GetTheatreListStart& GetTheatreListStart::operator = (const GetTheatreListStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasOperation()) {
            setOperation(rhs.getOperation());
        } else {
            clearOperation();
        }
        if (rhs.hasMovieID()) {
            setMovieID(rhs.getMovieID());
        } else {
            clearMovieID();
        }
        if (rhs.hasSearchString()) {
            setSearchString(rhs.getSearchString());
        } else {
            clearSearchString();
        }
    }
    return *this;
}

inline bool GetTheatreListStart::operator == (const GetTheatreListStart& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasOperation() && !rhs.hasOperation()) || getOperation() == rhs.getOperation()) &&
        ((!hasMovieID() && !rhs.hasMovieID()) || getMovieID() == rhs.getMovieID()) &&
        ((!hasSearchString() && !rhs.hasSearchString()) || getSearchString() == rhs.getSearchString()));
}

inline bool GetTheatreListStart::operator != (const GetTheatreListStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTheatreListStart::operator < (const GetTheatreListStart& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasOperation() || rhs.hasOperation()) {
        if ((uint32)getOperation() < (uint32)rhs.getOperation()) return true;
        if ((uint32)getOperation() > (uint32)rhs.getOperation()) return false;
    }
    if (hasMovieID() || rhs.hasMovieID()) {
        if (getMovieID() < rhs.getMovieID()) return true;
        if (getMovieID() > rhs.getMovieID()) return false;
    }
    if (hasSearchString() || rhs.hasSearchString()) {
        if (getSearchString() < rhs.getSearchString()) return true;
        if (getSearchString() > rhs.getSearchString()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTheatreListStart::clone() {
    return new GetTheatreListStart(*this);
}

inline bool GetTheatreListStart::operator > (const GetTheatreListStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTheatreListStart::clear() {
    clearListID();
    clearOperation();
    clearMovieID();
    clearSearchString();
}

inline void GetTheatreListStart::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetTheatreListStart::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetTheatreListStart::getListID () const {
    return _ListID;
}

inline void GetTheatreListStart::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetTheatreListStart::clearOperation() {
    if (hasOperation()) {
         clear_has_Operation();
        _Operation = ::sxm_main_fi_types::T_e8_SxmListOperation__IDLE;
     }
}

inline bool GetTheatreListStart::hasOperation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_main_fi_types::T_e8_SxmListOperation GetTheatreListStart::getOperation () const {
    return _Operation;
}

inline void GetTheatreListStart::setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_) {
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetTheatreListStart");
    }
    #endif
    set_has_Operation();
    this->_Operation = Operation_;
}

inline void GetTheatreListStart::clearMovieID() {
    if (hasMovieID()) {
         clear_has_MovieID();
        _MovieID = 0u;
     }
}

inline bool GetTheatreListStart::hasMovieID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 GetTheatreListStart::getMovieID () const {
    return _MovieID;
}

inline void GetTheatreListStart::setMovieID (uint32 MovieID_) {
    set_has_MovieID();
    this->_MovieID = MovieID_;
}

inline void GetTheatreListStart::clearSearchString() {
    if (hasSearchString()) {
         clear_has_SearchString();
        _SearchString.clear();
     }
}

inline bool GetTheatreListStart::hasSearchString () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& GetTheatreListStart::getSearchString () const {
    return _SearchString;
}

inline ::std::string& GetTheatreListStart::getSearchStringMutable () {
    set_has_SearchString();
    return _SearchString;
}

inline void GetTheatreListStart::setSearchString (const ::std::string& SearchString_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SearchString_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SearchString();
    this->_SearchString = SearchString_;
}

inline void GetTheatreListStart::setSearchString (const char* SearchString_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SearchString_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SearchString();
    this->_SearchString.assign(SearchString_);
}

inline void GetTheatreListStart::setSearchString (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SearchString();
    this->_SearchString.assign(value, size);
}

inline void GetTheatreListStart::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTheatreListStart::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetTheatreListStart::set_has_Operation () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetTheatreListStart::clear_has_Operation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetTheatreListStart::set_has_MovieID () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetTheatreListStart::clear_has_MovieID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetTheatreListStart::set_has_SearchString () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetTheatreListStart::clear_has_SearchString () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetTheatreListResult::GetTheatreListResult ()  :
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _ListInfo (),
    _TheatreInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTheatreListResult::GetTheatreListResult (const GetTheatreListResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _ListInfo (),
    _TheatreInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTheatreListResult::GetTheatreListResult (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_, const ::sxm_movies_main_fi_types::T_TheatreInfoList& TheatreInfoList_)  :
    _ListID (ListID_),
    _Operation (Operation_),
    _ListInfo (ListInfo_),
    _TheatreInfoList (TheatreInfoList_)
{
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetTheatreListResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTheatreListResult::~GetTheatreListResult() {
}

inline GetTheatreListResult& GetTheatreListResult::operator = (const GetTheatreListResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasOperation()) {
            setOperation(rhs.getOperation());
        } else {
            clearOperation();
        }
        if (rhs.hasListInfo()) {
            setListInfo(rhs.getListInfo());
        } else {
            clearListInfo();
        }
        if (rhs.hasTheatreInfoList()) {
            setTheatreInfoList(rhs.getTheatreInfoList());
        } else {
            clearTheatreInfoList();
        }
    }
    return *this;
}

inline bool GetTheatreListResult::operator == (const GetTheatreListResult& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasOperation() && !rhs.hasOperation()) || getOperation() == rhs.getOperation()) &&
        ((!hasListInfo() && !rhs.hasListInfo()) || getListInfo() == rhs.getListInfo()) &&
        ((!hasTheatreInfoList() && !rhs.hasTheatreInfoList()) || getTheatreInfoList() == rhs.getTheatreInfoList()));
}

inline bool GetTheatreListResult::operator != (const GetTheatreListResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTheatreListResult::operator < (const GetTheatreListResult& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasOperation() || rhs.hasOperation()) {
        if ((uint32)getOperation() < (uint32)rhs.getOperation()) return true;
        if ((uint32)getOperation() > (uint32)rhs.getOperation()) return false;
    }
    if (hasListInfo() || rhs.hasListInfo()) {
        if (getListInfo() < rhs.getListInfo()) return true;
        if (getListInfo() > rhs.getListInfo()) return false;
    }
    if (hasTheatreInfoList() || rhs.hasTheatreInfoList()) {
        if (getTheatreInfoList() < rhs.getTheatreInfoList()) return true;
        if (getTheatreInfoList() > rhs.getTheatreInfoList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTheatreListResult::clone() {
    return new GetTheatreListResult(*this);
}

inline bool GetTheatreListResult::operator > (const GetTheatreListResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTheatreListResult::clear() {
    clearListID();
    clearOperation();
    clearListInfo();
    clearTheatreInfoList();
}

inline void GetTheatreListResult::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetTheatreListResult::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetTheatreListResult::getListID () const {
    return _ListID;
}

inline void GetTheatreListResult::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetTheatreListResult::clearOperation() {
    if (hasOperation()) {
         clear_has_Operation();
        _Operation = ::sxm_main_fi_types::T_e8_SxmListOperation__IDLE;
     }
}

inline bool GetTheatreListResult::hasOperation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_main_fi_types::T_e8_SxmListOperation GetTheatreListResult::getOperation () const {
    return _Operation;
}

inline void GetTheatreListResult::setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_) {
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetTheatreListResult");
    }
    #endif
    set_has_Operation();
    this->_Operation = Operation_;
}

inline void GetTheatreListResult::clearListInfo() {
    if (hasListInfo()) {
         clear_has_ListInfo();
        _ListInfo.clear();
     }
}

inline bool GetTheatreListResult::hasListInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListInfo& GetTheatreListResult::getListInfo () const {
    return _ListInfo;
}

inline ::sxm_main_fi_types::T_SxmListInfo& GetTheatreListResult::getListInfoMutable () {
    set_has_ListInfo();
    return _ListInfo;
}

inline void GetTheatreListResult::setListInfo (const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_) {
    set_has_ListInfo();
    this->_ListInfo = ListInfo_;
}

inline void GetTheatreListResult::clearTheatreInfoList() {
    if (hasTheatreInfoList()) {
         clear_has_TheatreInfoList();
        _TheatreInfoList.clear();
     }
}

inline bool GetTheatreListResult::hasTheatreInfoList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::sxm_movies_main_fi_types::T_TheatreInfoList& GetTheatreListResult::getTheatreInfoList () const {
    return _TheatreInfoList;
}

inline ::sxm_movies_main_fi_types::T_TheatreInfoList& GetTheatreListResult::getTheatreInfoListMutable () {
    set_has_TheatreInfoList();
    return _TheatreInfoList;
}

inline void GetTheatreListResult::setTheatreInfoList (const ::sxm_movies_main_fi_types::T_TheatreInfoList& TheatreInfoList_) {
    set_has_TheatreInfoList();
    this->_TheatreInfoList = TheatreInfoList_;
}

inline void GetTheatreListResult::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTheatreListResult::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetTheatreListResult::set_has_Operation () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetTheatreListResult::clear_has_Operation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetTheatreListResult::set_has_ListInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetTheatreListResult::clear_has_ListInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetTheatreListResult::set_has_TheatreInfoList () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetTheatreListResult::clear_has_TheatreInfoList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetTheatreListErrorStructure::GetTheatreListErrorStructure ()  :
    _ErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTheatreListErrorStructure::GetTheatreListErrorStructure (const GetTheatreListErrorStructure &rhs)  :
    _ErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTheatreListErrorStructure::GetTheatreListErrorStructure (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_movies_main_fi_types::T_e8MovieErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8MovieErrorTypes", "ErrorCode", "GetTheatreListErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTheatreListErrorStructure::~GetTheatreListErrorStructure() {
}

inline GetTheatreListErrorStructure& GetTheatreListErrorStructure::operator = (const GetTheatreListErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetTheatreListErrorStructure::operator == (const GetTheatreListErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetTheatreListErrorStructure::operator != (const GetTheatreListErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTheatreListErrorStructure::operator < (const GetTheatreListErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetTheatreListErrorStructure::operator > (const GetTheatreListErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTheatreListErrorStructure::clear() {
    clearErrorCode();
}

inline void GetTheatreListErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE;
     }
}

inline bool GetTheatreListErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_movies_main_fi_types::T_e8MovieErrorTypes GetTheatreListErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetTheatreListErrorStructure::setErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_movies_main_fi_types::T_e8MovieErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8MovieErrorTypes", "ErrorCode", "GetTheatreListErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetTheatreListErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTheatreListErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetTheatreListError::GetTheatreListError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetTheatreListError::GetTheatreListError (const GetTheatreListError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetTheatreListError::~GetTheatreListError() {
    deleteData ();
}

inline GetTheatreListError& GetTheatreListError::operator = (const GetTheatreListError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetTheatreListError::operator == (const GetTheatreListError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetTheatreListError::operator != (const GetTheatreListError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTheatreListError::operator < (const GetTheatreListError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetTheatreListError::operator > (const GetTheatreListError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetTheatreListError::GetTheatreListErrorField GetTheatreListError::getField () const {
    return __field;
}

inline void GetTheatreListError::setField(GetTheatreListError::GetTheatreListErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetTheatreListError::clone() {
    return new GetTheatreListError(*this);
}

inline bool GetTheatreListError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetTheatreListErrorStructure& GetTheatreListError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetTheatreListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetTheatreListErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetTheatreListErrorStructure& GetTheatreListError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetTheatreListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetTheatreListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetTheatreListErrorStructure* GetTheatreListError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetTheatreListError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetTheatreListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetTheatreListErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetTheatreListError::replaceCcaErrorCode (GetTheatreListErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetTheatreListError::setCcaErrorCode (const GetTheatreListErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetTheatreListErrorStructure(value);
    }
}

inline bool GetTheatreListError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetTheatreListError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetTheatreListError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetTheatreListError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetTheatreListError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetTheatreListError::cloneData (const GetTheatreListError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetTheatreListErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetTheatreListErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetTheatreListError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetTheatreInfoStart::GetTheatreInfoStart ()  :
    _THEATRE_LOCID (0u),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTheatreInfoStart::GetTheatreInfoStart (const GetTheatreInfoStart &rhs)  :
    ::asf::core::Payload(rhs),
    _THEATRE_LOCID (0u),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTheatreInfoStart::GetTheatreInfoStart (uint32 THEATRE_LOCID_, uint32 ListID_)  :
    _THEATRE_LOCID (THEATRE_LOCID_),
    _ListID (ListID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTheatreInfoStart::~GetTheatreInfoStart() {
}

inline GetTheatreInfoStart& GetTheatreInfoStart::operator = (const GetTheatreInfoStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTHEATRE_LOCID()) {
            setTHEATRE_LOCID(rhs.getTHEATRE_LOCID());
        } else {
            clearTHEATRE_LOCID();
        }
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
    }
    return *this;
}

inline bool GetTheatreInfoStart::operator == (const GetTheatreInfoStart& rhs) const {
    return (((!hasTHEATRE_LOCID() && !rhs.hasTHEATRE_LOCID()) || getTHEATRE_LOCID() == rhs.getTHEATRE_LOCID()) &&
        ((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()));
}

inline bool GetTheatreInfoStart::operator != (const GetTheatreInfoStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTheatreInfoStart::operator < (const GetTheatreInfoStart& rhs) const {
    if (hasTHEATRE_LOCID() || rhs.hasTHEATRE_LOCID()) {
        if (getTHEATRE_LOCID() < rhs.getTHEATRE_LOCID()) return true;
        if (getTHEATRE_LOCID() > rhs.getTHEATRE_LOCID()) return false;
    }
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTheatreInfoStart::clone() {
    return new GetTheatreInfoStart(*this);
}

inline bool GetTheatreInfoStart::operator > (const GetTheatreInfoStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTheatreInfoStart::clear() {
    clearTHEATRE_LOCID();
    clearListID();
}

inline void GetTheatreInfoStart::clearTHEATRE_LOCID() {
    if (hasTHEATRE_LOCID()) {
         clear_has_THEATRE_LOCID();
        _THEATRE_LOCID = 0u;
     }
}

inline bool GetTheatreInfoStart::hasTHEATRE_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetTheatreInfoStart::getTHEATRE_LOCID () const {
    return _THEATRE_LOCID;
}

inline void GetTheatreInfoStart::setTHEATRE_LOCID (uint32 THEATRE_LOCID_) {
    set_has_THEATRE_LOCID();
    this->_THEATRE_LOCID = THEATRE_LOCID_;
}

inline void GetTheatreInfoStart::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetTheatreInfoStart::hasListID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetTheatreInfoStart::getListID () const {
    return _ListID;
}

inline void GetTheatreInfoStart::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetTheatreInfoStart::set_has_THEATRE_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTheatreInfoStart::clear_has_THEATRE_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetTheatreInfoStart::set_has_ListID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetTheatreInfoStart::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetTheatreInfoResult::GetTheatreInfoResult ()  :
    _TheatreInfo (),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTheatreInfoResult::GetTheatreInfoResult (const GetTheatreInfoResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TheatreInfo (),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTheatreInfoResult::GetTheatreInfoResult (const ::sxm_movies_main_fi_types::T_TheatreDetails& TheatreInfo_, uint32 ListID_)  :
    _TheatreInfo (TheatreInfo_),
    _ListID (ListID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTheatreInfoResult::~GetTheatreInfoResult() {
}

inline GetTheatreInfoResult& GetTheatreInfoResult::operator = (const GetTheatreInfoResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTheatreInfo()) {
            setTheatreInfo(rhs.getTheatreInfo());
        } else {
            clearTheatreInfo();
        }
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
    }
    return *this;
}

inline bool GetTheatreInfoResult::operator == (const GetTheatreInfoResult& rhs) const {
    return (((!hasTheatreInfo() && !rhs.hasTheatreInfo()) || getTheatreInfo() == rhs.getTheatreInfo()) &&
        ((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()));
}

inline bool GetTheatreInfoResult::operator != (const GetTheatreInfoResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTheatreInfoResult::operator < (const GetTheatreInfoResult& rhs) const {
    if (hasTheatreInfo() || rhs.hasTheatreInfo()) {
        if (getTheatreInfo() < rhs.getTheatreInfo()) return true;
        if (getTheatreInfo() > rhs.getTheatreInfo()) return false;
    }
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTheatreInfoResult::clone() {
    return new GetTheatreInfoResult(*this);
}

inline bool GetTheatreInfoResult::operator > (const GetTheatreInfoResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTheatreInfoResult::clear() {
    clearTheatreInfo();
    clearListID();
}

inline void GetTheatreInfoResult::clearTheatreInfo() {
    if (hasTheatreInfo()) {
         clear_has_TheatreInfo();
        _TheatreInfo.clear();
     }
}

inline bool GetTheatreInfoResult::hasTheatreInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_movies_main_fi_types::T_TheatreDetails& GetTheatreInfoResult::getTheatreInfo () const {
    return _TheatreInfo;
}

inline ::sxm_movies_main_fi_types::T_TheatreDetails& GetTheatreInfoResult::getTheatreInfoMutable () {
    set_has_TheatreInfo();
    return _TheatreInfo;
}

inline void GetTheatreInfoResult::setTheatreInfo (const ::sxm_movies_main_fi_types::T_TheatreDetails& TheatreInfo_) {
    set_has_TheatreInfo();
    this->_TheatreInfo = TheatreInfo_;
}

inline void GetTheatreInfoResult::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetTheatreInfoResult::hasListID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetTheatreInfoResult::getListID () const {
    return _ListID;
}

inline void GetTheatreInfoResult::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetTheatreInfoResult::set_has_TheatreInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTheatreInfoResult::clear_has_TheatreInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetTheatreInfoResult::set_has_ListID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetTheatreInfoResult::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetTheatreInfoErrorStructure::GetTheatreInfoErrorStructure ()  :
    _ErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTheatreInfoErrorStructure::GetTheatreInfoErrorStructure (const GetTheatreInfoErrorStructure &rhs)  :
    _ErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTheatreInfoErrorStructure::GetTheatreInfoErrorStructure (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_movies_main_fi_types::T_e8MovieErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8MovieErrorTypes", "ErrorCode", "GetTheatreInfoErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTheatreInfoErrorStructure::~GetTheatreInfoErrorStructure() {
}

inline GetTheatreInfoErrorStructure& GetTheatreInfoErrorStructure::operator = (const GetTheatreInfoErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetTheatreInfoErrorStructure::operator == (const GetTheatreInfoErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetTheatreInfoErrorStructure::operator != (const GetTheatreInfoErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTheatreInfoErrorStructure::operator < (const GetTheatreInfoErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetTheatreInfoErrorStructure::operator > (const GetTheatreInfoErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTheatreInfoErrorStructure::clear() {
    clearErrorCode();
}

inline void GetTheatreInfoErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE;
     }
}

inline bool GetTheatreInfoErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_movies_main_fi_types::T_e8MovieErrorTypes GetTheatreInfoErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetTheatreInfoErrorStructure::setErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_movies_main_fi_types::T_e8MovieErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8MovieErrorTypes", "ErrorCode", "GetTheatreInfoErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetTheatreInfoErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTheatreInfoErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetTheatreInfoError::GetTheatreInfoError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetTheatreInfoError::GetTheatreInfoError (const GetTheatreInfoError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetTheatreInfoError::~GetTheatreInfoError() {
    deleteData ();
}

inline GetTheatreInfoError& GetTheatreInfoError::operator = (const GetTheatreInfoError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetTheatreInfoError::operator == (const GetTheatreInfoError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetTheatreInfoError::operator != (const GetTheatreInfoError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTheatreInfoError::operator < (const GetTheatreInfoError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetTheatreInfoError::operator > (const GetTheatreInfoError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetTheatreInfoError::GetTheatreInfoErrorField GetTheatreInfoError::getField () const {
    return __field;
}

inline void GetTheatreInfoError::setField(GetTheatreInfoError::GetTheatreInfoErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetTheatreInfoError::clone() {
    return new GetTheatreInfoError(*this);
}

inline bool GetTheatreInfoError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetTheatreInfoErrorStructure& GetTheatreInfoError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetTheatreInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetTheatreInfoErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetTheatreInfoErrorStructure& GetTheatreInfoError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetTheatreInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetTheatreInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetTheatreInfoErrorStructure* GetTheatreInfoError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetTheatreInfoError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetTheatreInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetTheatreInfoErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetTheatreInfoError::replaceCcaErrorCode (GetTheatreInfoErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetTheatreInfoError::setCcaErrorCode (const GetTheatreInfoErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetTheatreInfoErrorStructure(value);
    }
}

inline bool GetTheatreInfoError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetTheatreInfoError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetTheatreInfoError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetTheatreInfoError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetTheatreInfoError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetTheatreInfoError::cloneData (const GetTheatreInfoError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetTheatreInfoErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetTheatreInfoErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetTheatreInfoError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetMoviesListStart::GetMoviesListStart ()  :
    _ListID (0u),
    _Theater_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetMoviesListStart::GetMoviesListStart (const GetMoviesListStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ListID (0u),
    _Theater_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetMoviesListStart::GetMoviesListStart (uint32 ListID_, uint32 Theater_LOCID_)  :
    _ListID (ListID_),
    _Theater_LOCID (Theater_LOCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetMoviesListStart::~GetMoviesListStart() {
}

inline GetMoviesListStart& GetMoviesListStart::operator = (const GetMoviesListStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasTheater_LOCID()) {
            setTheater_LOCID(rhs.getTheater_LOCID());
        } else {
            clearTheater_LOCID();
        }
    }
    return *this;
}

inline bool GetMoviesListStart::operator == (const GetMoviesListStart& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasTheater_LOCID() && !rhs.hasTheater_LOCID()) || getTheater_LOCID() == rhs.getTheater_LOCID()));
}

inline bool GetMoviesListStart::operator != (const GetMoviesListStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetMoviesListStart::operator < (const GetMoviesListStart& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasTheater_LOCID() || rhs.hasTheater_LOCID()) {
        if (getTheater_LOCID() < rhs.getTheater_LOCID()) return true;
        if (getTheater_LOCID() > rhs.getTheater_LOCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetMoviesListStart::clone() {
    return new GetMoviesListStart(*this);
}

inline bool GetMoviesListStart::operator > (const GetMoviesListStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetMoviesListStart::clear() {
    clearListID();
    clearTheater_LOCID();
}

inline void GetMoviesListStart::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetMoviesListStart::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetMoviesListStart::getListID () const {
    return _ListID;
}

inline void GetMoviesListStart::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetMoviesListStart::clearTheater_LOCID() {
    if (hasTheater_LOCID()) {
         clear_has_Theater_LOCID();
        _Theater_LOCID = 0u;
     }
}

inline bool GetMoviesListStart::hasTheater_LOCID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetMoviesListStart::getTheater_LOCID () const {
    return _Theater_LOCID;
}

inline void GetMoviesListStart::setTheater_LOCID (uint32 Theater_LOCID_) {
    set_has_Theater_LOCID();
    this->_Theater_LOCID = Theater_LOCID_;
}

inline void GetMoviesListStart::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetMoviesListStart::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetMoviesListStart::set_has_Theater_LOCID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetMoviesListStart::clear_has_Theater_LOCID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetMoviesListResult::GetMoviesListResult ()  :
    _ListID (0u),
    _MoviesInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetMoviesListResult::GetMoviesListResult (const GetMoviesListResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ListID (0u),
    _MoviesInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetMoviesListResult::GetMoviesListResult (uint32 ListID_, const ::sxm_movies_main_fi_types::T_MoviesList& MoviesInfoList_)  :
    _ListID (ListID_),
    _MoviesInfoList (MoviesInfoList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetMoviesListResult::~GetMoviesListResult() {
}

inline GetMoviesListResult& GetMoviesListResult::operator = (const GetMoviesListResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasMoviesInfoList()) {
            setMoviesInfoList(rhs.getMoviesInfoList());
        } else {
            clearMoviesInfoList();
        }
    }
    return *this;
}

inline bool GetMoviesListResult::operator == (const GetMoviesListResult& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasMoviesInfoList() && !rhs.hasMoviesInfoList()) || getMoviesInfoList() == rhs.getMoviesInfoList()));
}

inline bool GetMoviesListResult::operator != (const GetMoviesListResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetMoviesListResult::operator < (const GetMoviesListResult& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasMoviesInfoList() || rhs.hasMoviesInfoList()) {
        if (getMoviesInfoList() < rhs.getMoviesInfoList()) return true;
        if (getMoviesInfoList() > rhs.getMoviesInfoList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetMoviesListResult::clone() {
    return new GetMoviesListResult(*this);
}

inline bool GetMoviesListResult::operator > (const GetMoviesListResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetMoviesListResult::clear() {
    clearListID();
    clearMoviesInfoList();
}

inline void GetMoviesListResult::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetMoviesListResult::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetMoviesListResult::getListID () const {
    return _ListID;
}

inline void GetMoviesListResult::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetMoviesListResult::clearMoviesInfoList() {
    if (hasMoviesInfoList()) {
         clear_has_MoviesInfoList();
        _MoviesInfoList.clear();
     }
}

inline bool GetMoviesListResult::hasMoviesInfoList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::sxm_movies_main_fi_types::T_MoviesList& GetMoviesListResult::getMoviesInfoList () const {
    return _MoviesInfoList;
}

inline ::sxm_movies_main_fi_types::T_MoviesList& GetMoviesListResult::getMoviesInfoListMutable () {
    set_has_MoviesInfoList();
    return _MoviesInfoList;
}

inline void GetMoviesListResult::setMoviesInfoList (const ::sxm_movies_main_fi_types::T_MoviesList& MoviesInfoList_) {
    set_has_MoviesInfoList();
    this->_MoviesInfoList = MoviesInfoList_;
}

inline void GetMoviesListResult::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetMoviesListResult::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetMoviesListResult::set_has_MoviesInfoList () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetMoviesListResult::clear_has_MoviesInfoList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetMoviesListErrorStructure::GetMoviesListErrorStructure ()  :
    _ErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetMoviesListErrorStructure::GetMoviesListErrorStructure (const GetMoviesListErrorStructure &rhs)  :
    _ErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetMoviesListErrorStructure::GetMoviesListErrorStructure (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_movies_main_fi_types::T_e8MovieErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8MovieErrorTypes", "ErrorCode", "GetMoviesListErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetMoviesListErrorStructure::~GetMoviesListErrorStructure() {
}

inline GetMoviesListErrorStructure& GetMoviesListErrorStructure::operator = (const GetMoviesListErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetMoviesListErrorStructure::operator == (const GetMoviesListErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetMoviesListErrorStructure::operator != (const GetMoviesListErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetMoviesListErrorStructure::operator < (const GetMoviesListErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetMoviesListErrorStructure::operator > (const GetMoviesListErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetMoviesListErrorStructure::clear() {
    clearErrorCode();
}

inline void GetMoviesListErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE;
     }
}

inline bool GetMoviesListErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_movies_main_fi_types::T_e8MovieErrorTypes GetMoviesListErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetMoviesListErrorStructure::setErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_movies_main_fi_types::T_e8MovieErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8MovieErrorTypes", "ErrorCode", "GetMoviesListErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetMoviesListErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetMoviesListErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetMoviesListError::GetMoviesListError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetMoviesListError::GetMoviesListError (const GetMoviesListError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetMoviesListError::~GetMoviesListError() {
    deleteData ();
}

inline GetMoviesListError& GetMoviesListError::operator = (const GetMoviesListError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetMoviesListError::operator == (const GetMoviesListError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetMoviesListError::operator != (const GetMoviesListError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetMoviesListError::operator < (const GetMoviesListError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetMoviesListError::operator > (const GetMoviesListError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetMoviesListError::GetMoviesListErrorField GetMoviesListError::getField () const {
    return __field;
}

inline void GetMoviesListError::setField(GetMoviesListError::GetMoviesListErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetMoviesListError::clone() {
    return new GetMoviesListError(*this);
}

inline bool GetMoviesListError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetMoviesListErrorStructure& GetMoviesListError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetMoviesListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetMoviesListErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetMoviesListErrorStructure& GetMoviesListError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetMoviesListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetMoviesListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetMoviesListErrorStructure* GetMoviesListError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetMoviesListError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetMoviesListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetMoviesListErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetMoviesListError::replaceCcaErrorCode (GetMoviesListErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetMoviesListError::setCcaErrorCode (const GetMoviesListErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetMoviesListErrorStructure(value);
    }
}

inline bool GetMoviesListError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetMoviesListError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetMoviesListError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetMoviesListError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetMoviesListError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetMoviesListError::cloneData (const GetMoviesListError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetMoviesListErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetMoviesListErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetMoviesListError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetMovieInfoStart::GetMovieInfoStart ()  :
    _MOVIE_ID (0u),
    _ListID (0u),
    _Theater_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetMovieInfoStart::GetMovieInfoStart (const GetMovieInfoStart &rhs)  :
    ::asf::core::Payload(rhs),
    _MOVIE_ID (0u),
    _ListID (0u),
    _Theater_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetMovieInfoStart::GetMovieInfoStart (uint32 MOVIE_ID_, uint32 ListID_, uint32 Theater_LOCID_)  :
    _MOVIE_ID (MOVIE_ID_),
    _ListID (ListID_),
    _Theater_LOCID (Theater_LOCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetMovieInfoStart::~GetMovieInfoStart() {
}

inline GetMovieInfoStart& GetMovieInfoStart::operator = (const GetMovieInfoStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMOVIE_ID()) {
            setMOVIE_ID(rhs.getMOVIE_ID());
        } else {
            clearMOVIE_ID();
        }
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasTheater_LOCID()) {
            setTheater_LOCID(rhs.getTheater_LOCID());
        } else {
            clearTheater_LOCID();
        }
    }
    return *this;
}

inline bool GetMovieInfoStart::operator == (const GetMovieInfoStart& rhs) const {
    return (((!hasMOVIE_ID() && !rhs.hasMOVIE_ID()) || getMOVIE_ID() == rhs.getMOVIE_ID()) &&
        ((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasTheater_LOCID() && !rhs.hasTheater_LOCID()) || getTheater_LOCID() == rhs.getTheater_LOCID()));
}

inline bool GetMovieInfoStart::operator != (const GetMovieInfoStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetMovieInfoStart::operator < (const GetMovieInfoStart& rhs) const {
    if (hasMOVIE_ID() || rhs.hasMOVIE_ID()) {
        if (getMOVIE_ID() < rhs.getMOVIE_ID()) return true;
        if (getMOVIE_ID() > rhs.getMOVIE_ID()) return false;
    }
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasTheater_LOCID() || rhs.hasTheater_LOCID()) {
        if (getTheater_LOCID() < rhs.getTheater_LOCID()) return true;
        if (getTheater_LOCID() > rhs.getTheater_LOCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetMovieInfoStart::clone() {
    return new GetMovieInfoStart(*this);
}

inline bool GetMovieInfoStart::operator > (const GetMovieInfoStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetMovieInfoStart::clear() {
    clearMOVIE_ID();
    clearListID();
    clearTheater_LOCID();
}

inline void GetMovieInfoStart::clearMOVIE_ID() {
    if (hasMOVIE_ID()) {
         clear_has_MOVIE_ID();
        _MOVIE_ID = 0u;
     }
}

inline bool GetMovieInfoStart::hasMOVIE_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetMovieInfoStart::getMOVIE_ID () const {
    return _MOVIE_ID;
}

inline void GetMovieInfoStart::setMOVIE_ID (uint32 MOVIE_ID_) {
    set_has_MOVIE_ID();
    this->_MOVIE_ID = MOVIE_ID_;
}

inline void GetMovieInfoStart::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetMovieInfoStart::hasListID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetMovieInfoStart::getListID () const {
    return _ListID;
}

inline void GetMovieInfoStart::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetMovieInfoStart::clearTheater_LOCID() {
    if (hasTheater_LOCID()) {
         clear_has_Theater_LOCID();
        _Theater_LOCID = 0u;
     }
}

inline bool GetMovieInfoStart::hasTheater_LOCID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 GetMovieInfoStart::getTheater_LOCID () const {
    return _Theater_LOCID;
}

inline void GetMovieInfoStart::setTheater_LOCID (uint32 Theater_LOCID_) {
    set_has_Theater_LOCID();
    this->_Theater_LOCID = Theater_LOCID_;
}

inline void GetMovieInfoStart::set_has_MOVIE_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetMovieInfoStart::clear_has_MOVIE_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetMovieInfoStart::set_has_ListID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetMovieInfoStart::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetMovieInfoStart::set_has_Theater_LOCID () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetMovieInfoStart::clear_has_Theater_LOCID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetMovieInfoResult::GetMovieInfoResult ()  :
    _MovieInfo (),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetMovieInfoResult::GetMovieInfoResult (const GetMovieInfoResult &rhs)  :
    ::asf::core::Payload(rhs),
    _MovieInfo (),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetMovieInfoResult::GetMovieInfoResult (const ::sxm_movies_main_fi_types::T_MovieDetails& MovieInfo_, uint32 ListID_)  :
    _MovieInfo (MovieInfo_),
    _ListID (ListID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetMovieInfoResult::~GetMovieInfoResult() {
}

inline GetMovieInfoResult& GetMovieInfoResult::operator = (const GetMovieInfoResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMovieInfo()) {
            setMovieInfo(rhs.getMovieInfo());
        } else {
            clearMovieInfo();
        }
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
    }
    return *this;
}

inline bool GetMovieInfoResult::operator == (const GetMovieInfoResult& rhs) const {
    return (((!hasMovieInfo() && !rhs.hasMovieInfo()) || getMovieInfo() == rhs.getMovieInfo()) &&
        ((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()));
}

inline bool GetMovieInfoResult::operator != (const GetMovieInfoResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetMovieInfoResult::operator < (const GetMovieInfoResult& rhs) const {
    if (hasMovieInfo() || rhs.hasMovieInfo()) {
        if (getMovieInfo() < rhs.getMovieInfo()) return true;
        if (getMovieInfo() > rhs.getMovieInfo()) return false;
    }
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetMovieInfoResult::clone() {
    return new GetMovieInfoResult(*this);
}

inline bool GetMovieInfoResult::operator > (const GetMovieInfoResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetMovieInfoResult::clear() {
    clearMovieInfo();
    clearListID();
}

inline void GetMovieInfoResult::clearMovieInfo() {
    if (hasMovieInfo()) {
         clear_has_MovieInfo();
        _MovieInfo.clear();
     }
}

inline bool GetMovieInfoResult::hasMovieInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_movies_main_fi_types::T_MovieDetails& GetMovieInfoResult::getMovieInfo () const {
    return _MovieInfo;
}

inline ::sxm_movies_main_fi_types::T_MovieDetails& GetMovieInfoResult::getMovieInfoMutable () {
    set_has_MovieInfo();
    return _MovieInfo;
}

inline void GetMovieInfoResult::setMovieInfo (const ::sxm_movies_main_fi_types::T_MovieDetails& MovieInfo_) {
    set_has_MovieInfo();
    this->_MovieInfo = MovieInfo_;
}

inline void GetMovieInfoResult::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetMovieInfoResult::hasListID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetMovieInfoResult::getListID () const {
    return _ListID;
}

inline void GetMovieInfoResult::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetMovieInfoResult::set_has_MovieInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetMovieInfoResult::clear_has_MovieInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetMovieInfoResult::set_has_ListID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetMovieInfoResult::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetMovieInfoErrorStructure::GetMovieInfoErrorStructure ()  :
    _ErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetMovieInfoErrorStructure::GetMovieInfoErrorStructure (const GetMovieInfoErrorStructure &rhs)  :
    _ErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetMovieInfoErrorStructure::GetMovieInfoErrorStructure (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_movies_main_fi_types::T_e8MovieErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8MovieErrorTypes", "ErrorCode", "GetMovieInfoErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetMovieInfoErrorStructure::~GetMovieInfoErrorStructure() {
}

inline GetMovieInfoErrorStructure& GetMovieInfoErrorStructure::operator = (const GetMovieInfoErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetMovieInfoErrorStructure::operator == (const GetMovieInfoErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetMovieInfoErrorStructure::operator != (const GetMovieInfoErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetMovieInfoErrorStructure::operator < (const GetMovieInfoErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetMovieInfoErrorStructure::operator > (const GetMovieInfoErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetMovieInfoErrorStructure::clear() {
    clearErrorCode();
}

inline void GetMovieInfoErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE;
     }
}

inline bool GetMovieInfoErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_movies_main_fi_types::T_e8MovieErrorTypes GetMovieInfoErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetMovieInfoErrorStructure::setErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_movies_main_fi_types::T_e8MovieErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8MovieErrorTypes", "ErrorCode", "GetMovieInfoErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetMovieInfoErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetMovieInfoErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetMovieInfoError::GetMovieInfoError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetMovieInfoError::GetMovieInfoError (const GetMovieInfoError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetMovieInfoError::~GetMovieInfoError() {
    deleteData ();
}

inline GetMovieInfoError& GetMovieInfoError::operator = (const GetMovieInfoError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetMovieInfoError::operator == (const GetMovieInfoError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetMovieInfoError::operator != (const GetMovieInfoError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetMovieInfoError::operator < (const GetMovieInfoError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetMovieInfoError::operator > (const GetMovieInfoError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetMovieInfoError::GetMovieInfoErrorField GetMovieInfoError::getField () const {
    return __field;
}

inline void GetMovieInfoError::setField(GetMovieInfoError::GetMovieInfoErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetMovieInfoError::clone() {
    return new GetMovieInfoError(*this);
}

inline bool GetMovieInfoError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetMovieInfoErrorStructure& GetMovieInfoError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetMovieInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetMovieInfoErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetMovieInfoErrorStructure& GetMovieInfoError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetMovieInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetMovieInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetMovieInfoErrorStructure* GetMovieInfoError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetMovieInfoError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetMovieInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetMovieInfoErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetMovieInfoError::replaceCcaErrorCode (GetMovieInfoErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetMovieInfoError::setCcaErrorCode (const GetMovieInfoErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetMovieInfoErrorStructure(value);
    }
}

inline bool GetMovieInfoError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetMovieInfoError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetMovieInfoError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetMovieInfoError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetMovieInfoError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetMovieInfoError::cloneData (const GetMovieInfoError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetMovieInfoErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetMovieInfoErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetMovieInfoError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  AddFavoriteStart::AddFavoriteStart ()  :
    _Theater_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteStart::AddFavoriteStart (const AddFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Theater_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteStart::AddFavoriteStart (uint32 Theater_LOCID_)  :
    _Theater_LOCID (Theater_LOCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteStart::~AddFavoriteStart() {
}

inline AddFavoriteStart& AddFavoriteStart::operator = (const AddFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTheater_LOCID()) {
            setTheater_LOCID(rhs.getTheater_LOCID());
        } else {
            clearTheater_LOCID();
        }
    }
    return *this;
}

inline bool AddFavoriteStart::operator == (const AddFavoriteStart& rhs) const {
    return (((!hasTheater_LOCID() && !rhs.hasTheater_LOCID()) || getTheater_LOCID() == rhs.getTheater_LOCID()));
}

inline bool AddFavoriteStart::operator != (const AddFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteStart::operator < (const AddFavoriteStart& rhs) const {
    if (hasTheater_LOCID() || rhs.hasTheater_LOCID()) {
        if (getTheater_LOCID() < rhs.getTheater_LOCID()) return true;
        if (getTheater_LOCID() > rhs.getTheater_LOCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddFavoriteStart::clone() {
    return new AddFavoriteStart(*this);
}

inline bool AddFavoriteStart::operator > (const AddFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteStart::clear() {
    clearTheater_LOCID();
}

inline void AddFavoriteStart::clearTheater_LOCID() {
    if (hasTheater_LOCID()) {
         clear_has_Theater_LOCID();
        _Theater_LOCID = 0u;
     }
}

inline bool AddFavoriteStart::hasTheater_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AddFavoriteStart::getTheater_LOCID () const {
    return _Theater_LOCID;
}

inline void AddFavoriteStart::setTheater_LOCID (uint32 Theater_LOCID_) {
    set_has_Theater_LOCID();
    this->_Theater_LOCID = Theater_LOCID_;
}

inline void AddFavoriteStart::set_has_Theater_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteStart::clear_has_Theater_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddFavoriteResult::AddFavoriteResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteResult::AddFavoriteResult (const AddFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteResult::AddFavoriteResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteResult::~AddFavoriteResult() {
}

inline AddFavoriteResult& AddFavoriteResult::operator = (const AddFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool AddFavoriteResult::operator == (const AddFavoriteResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool AddFavoriteResult::operator != (const AddFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteResult::operator < (const AddFavoriteResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddFavoriteResult::clone() {
    return new AddFavoriteResult(*this);
}

inline bool AddFavoriteResult::operator > (const AddFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteResult::clear() {
    clearStatus();
}

inline void AddFavoriteResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool AddFavoriteResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AddFavoriteResult::getStatus () const {
    return _Status;
}

inline void AddFavoriteResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void AddFavoriteResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteStart::RemoveFavoriteStart ()  :
    _Theater_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteStart::RemoveFavoriteStart (const RemoveFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Theater_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteStart::RemoveFavoriteStart (uint32 Theater_LOCID_)  :
    _Theater_LOCID (Theater_LOCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteStart::~RemoveFavoriteStart() {
}

inline RemoveFavoriteStart& RemoveFavoriteStart::operator = (const RemoveFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTheater_LOCID()) {
            setTheater_LOCID(rhs.getTheater_LOCID());
        } else {
            clearTheater_LOCID();
        }
    }
    return *this;
}

inline bool RemoveFavoriteStart::operator == (const RemoveFavoriteStart& rhs) const {
    return (((!hasTheater_LOCID() && !rhs.hasTheater_LOCID()) || getTheater_LOCID() == rhs.getTheater_LOCID()));
}

inline bool RemoveFavoriteStart::operator != (const RemoveFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteStart::operator < (const RemoveFavoriteStart& rhs) const {
    if (hasTheater_LOCID() || rhs.hasTheater_LOCID()) {
        if (getTheater_LOCID() < rhs.getTheater_LOCID()) return true;
        if (getTheater_LOCID() > rhs.getTheater_LOCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveFavoriteStart::clone() {
    return new RemoveFavoriteStart(*this);
}

inline bool RemoveFavoriteStart::operator > (const RemoveFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteStart::clear() {
    clearTheater_LOCID();
}

inline void RemoveFavoriteStart::clearTheater_LOCID() {
    if (hasTheater_LOCID()) {
         clear_has_Theater_LOCID();
        _Theater_LOCID = 0u;
     }
}

inline bool RemoveFavoriteStart::hasTheater_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RemoveFavoriteStart::getTheater_LOCID () const {
    return _Theater_LOCID;
}

inline void RemoveFavoriteStart::setTheater_LOCID (uint32 Theater_LOCID_) {
    set_has_Theater_LOCID();
    this->_Theater_LOCID = Theater_LOCID_;
}

inline void RemoveFavoriteStart::set_has_Theater_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteStart::clear_has_Theater_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteResult::RemoveFavoriteResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteResult::RemoveFavoriteResult (const RemoveFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteResult::RemoveFavoriteResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteResult::~RemoveFavoriteResult() {
}

inline RemoveFavoriteResult& RemoveFavoriteResult::operator = (const RemoveFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool RemoveFavoriteResult::operator == (const RemoveFavoriteResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool RemoveFavoriteResult::operator != (const RemoveFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteResult::operator < (const RemoveFavoriteResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveFavoriteResult::clone() {
    return new RemoveFavoriteResult(*this);
}

inline bool RemoveFavoriteResult::operator > (const RemoveFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteResult::clear() {
    clearStatus();
}

inline void RemoveFavoriteResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool RemoveFavoriteResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RemoveFavoriteResult::getStatus () const {
    return _Status;
}

inline void RemoveFavoriteResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void RemoveFavoriteResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SearchMovieStart::SearchMovieStart ()  :
    _MovieName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SearchMovieStart::SearchMovieStart (const SearchMovieStart &rhs)  :
    ::asf::core::Payload(rhs),
    _MovieName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SearchMovieStart::SearchMovieStart (const ::std::string& MovieName_)  :
    _MovieName (MovieName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SearchMovieStart::~SearchMovieStart() {
}

inline SearchMovieStart& SearchMovieStart::operator = (const SearchMovieStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMovieName()) {
            setMovieName(rhs.getMovieName());
        } else {
            clearMovieName();
        }
    }
    return *this;
}

inline bool SearchMovieStart::operator == (const SearchMovieStart& rhs) const {
    return (((!hasMovieName() && !rhs.hasMovieName()) || getMovieName() == rhs.getMovieName()));
}

inline bool SearchMovieStart::operator != (const SearchMovieStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SearchMovieStart::operator < (const SearchMovieStart& rhs) const {
    if (hasMovieName() || rhs.hasMovieName()) {
        if (getMovieName() < rhs.getMovieName()) return true;
        if (getMovieName() > rhs.getMovieName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SearchMovieStart::clone() {
    return new SearchMovieStart(*this);
}

inline bool SearchMovieStart::operator > (const SearchMovieStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SearchMovieStart::clear() {
    clearMovieName();
}

inline void SearchMovieStart::clearMovieName() {
    if (hasMovieName()) {
         clear_has_MovieName();
        _MovieName.clear();
     }
}

inline bool SearchMovieStart::hasMovieName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SearchMovieStart::getMovieName () const {
    return _MovieName;
}

inline ::std::string& SearchMovieStart::getMovieNameMutable () {
    set_has_MovieName();
    return _MovieName;
}

inline void SearchMovieStart::setMovieName (const ::std::string& MovieName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieName();
    this->_MovieName = MovieName_;
}

inline void SearchMovieStart::setMovieName (const char* MovieName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieName();
    this->_MovieName.assign(MovieName_);
}

inline void SearchMovieStart::setMovieName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieName();
    this->_MovieName.assign(value, size);
}

inline void SearchMovieStart::set_has_MovieName () {
    _has_bits_[0] |= 1u << 0;
}

inline void SearchMovieStart::clear_has_MovieName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SearchMovieResult::SearchMovieResult ()  :
    _MoviesList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SearchMovieResult::SearchMovieResult (const SearchMovieResult &rhs)  :
    ::asf::core::Payload(rhs),
    _MoviesList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SearchMovieResult::SearchMovieResult (const ::sxm_movies_main_fi_types::T_MoviesList& MoviesList_)  :
    _MoviesList (MoviesList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SearchMovieResult::~SearchMovieResult() {
}

inline SearchMovieResult& SearchMovieResult::operator = (const SearchMovieResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMoviesList()) {
            setMoviesList(rhs.getMoviesList());
        } else {
            clearMoviesList();
        }
    }
    return *this;
}

inline bool SearchMovieResult::operator == (const SearchMovieResult& rhs) const {
    return (((!hasMoviesList() && !rhs.hasMoviesList()) || getMoviesList() == rhs.getMoviesList()));
}

inline bool SearchMovieResult::operator != (const SearchMovieResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SearchMovieResult::operator < (const SearchMovieResult& rhs) const {
    if (hasMoviesList() || rhs.hasMoviesList()) {
        if (getMoviesList() < rhs.getMoviesList()) return true;
        if (getMoviesList() > rhs.getMoviesList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SearchMovieResult::clone() {
    return new SearchMovieResult(*this);
}

inline bool SearchMovieResult::operator > (const SearchMovieResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SearchMovieResult::clear() {
    clearMoviesList();
}

inline void SearchMovieResult::clearMoviesList() {
    if (hasMoviesList()) {
         clear_has_MoviesList();
        _MoviesList.clear();
     }
}

inline bool SearchMovieResult::hasMoviesList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_movies_main_fi_types::T_MoviesList& SearchMovieResult::getMoviesList () const {
    return _MoviesList;
}

inline ::sxm_movies_main_fi_types::T_MoviesList& SearchMovieResult::getMoviesListMutable () {
    set_has_MoviesList();
    return _MoviesList;
}

inline void SearchMovieResult::setMoviesList (const ::sxm_movies_main_fi_types::T_MoviesList& MoviesList_) {
    set_has_MoviesList();
    this->_MoviesList = MoviesList_;
}

inline void SearchMovieResult::set_has_MoviesList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SearchMovieResult::clear_has_MoviesList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SearchMovieErrorStructure::SearchMovieErrorStructure ()  :
    _ErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SearchMovieErrorStructure::SearchMovieErrorStructure (const SearchMovieErrorStructure &rhs)  :
    _ErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SearchMovieErrorStructure::SearchMovieErrorStructure (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_movies_main_fi_types::T_e8MovieErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8MovieErrorTypes", "ErrorCode", "SearchMovieErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SearchMovieErrorStructure::~SearchMovieErrorStructure() {
}

inline SearchMovieErrorStructure& SearchMovieErrorStructure::operator = (const SearchMovieErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SearchMovieErrorStructure::operator == (const SearchMovieErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SearchMovieErrorStructure::operator != (const SearchMovieErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SearchMovieErrorStructure::operator < (const SearchMovieErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool SearchMovieErrorStructure::operator > (const SearchMovieErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SearchMovieErrorStructure::clear() {
    clearErrorCode();
}

inline void SearchMovieErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_movies_main_fi_types::T_e8MovieErrorTypes__UNAVAILABLE;
     }
}

inline bool SearchMovieErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_movies_main_fi_types::T_e8MovieErrorTypes SearchMovieErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void SearchMovieErrorStructure::setErrorCode (::sxm_movies_main_fi_types::T_e8MovieErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_movies_main_fi_types::T_e8MovieErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8MovieErrorTypes", "ErrorCode", "SearchMovieErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SearchMovieErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SearchMovieErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SearchMovieError::SearchMovieError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SearchMovieError::SearchMovieError (const SearchMovieError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SearchMovieError::~SearchMovieError() {
    deleteData ();
}

inline SearchMovieError& SearchMovieError::operator = (const SearchMovieError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SearchMovieError::operator == (const SearchMovieError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SearchMovieError::operator != (const SearchMovieError& rhs) const {
    return ! (*this == rhs);
}

inline bool SearchMovieError::operator < (const SearchMovieError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SearchMovieError::operator > (const SearchMovieError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SearchMovieError::SearchMovieErrorField SearchMovieError::getField () const {
    return __field;
}

inline void SearchMovieError::setField(SearchMovieError::SearchMovieErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SearchMovieError::clone() {
    return new SearchMovieError(*this);
}

inline bool SearchMovieError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SearchMovieErrorStructure& SearchMovieError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SearchMovieError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SearchMovieErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SearchMovieErrorStructure& SearchMovieError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SearchMovieError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SearchMovieErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SearchMovieErrorStructure* SearchMovieError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SearchMovieError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SearchMovieErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SearchMovieErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SearchMovieError::replaceCcaErrorCode (SearchMovieErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SearchMovieError::setCcaErrorCode (const SearchMovieErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SearchMovieErrorStructure(value);
    }
}

inline bool SearchMovieError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SearchMovieError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SearchMovieError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SearchMovieError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SearchMovieError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SearchMovieError::cloneData (const SearchMovieError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SearchMovieErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SearchMovieErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SearchMovieError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SetListsConfigStart::SetListsConfigStart ()  :
    _Config ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigStart::SetListsConfigStart (const SetListsConfigStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Config ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigStart::SetListsConfigStart (const ::sxm_main_fi_types::T_SxmListsConfig& Config_)  :
    _Config (Config_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigStart::~SetListsConfigStart() {
}

inline SetListsConfigStart& SetListsConfigStart::operator = (const SetListsConfigStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfig()) {
            setConfig(rhs.getConfig());
        } else {
            clearConfig();
        }
    }
    return *this;
}

inline bool SetListsConfigStart::operator == (const SetListsConfigStart& rhs) const {
    return (((!hasConfig() && !rhs.hasConfig()) || getConfig() == rhs.getConfig()));
}

inline bool SetListsConfigStart::operator != (const SetListsConfigStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigStart::operator < (const SetListsConfigStart& rhs) const {
    if (hasConfig() || rhs.hasConfig()) {
        if (getConfig() < rhs.getConfig()) return true;
        if (getConfig() > rhs.getConfig()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetListsConfigStart::clone() {
    return new SetListsConfigStart(*this);
}

inline bool SetListsConfigStart::operator > (const SetListsConfigStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigStart::clear() {
    clearConfig();
}

inline void SetListsConfigStart::clearConfig() {
    if (hasConfig()) {
         clear_has_Config();
        _Config.clear();
     }
}

inline bool SetListsConfigStart::hasConfig () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListsConfig& SetListsConfigStart::getConfig () const {
    return _Config;
}

inline ::sxm_main_fi_types::T_SxmListsConfig& SetListsConfigStart::getConfigMutable () {
    set_has_Config();
    return _Config;
}

inline void SetListsConfigStart::setConfig (const ::sxm_main_fi_types::T_SxmListsConfig& Config_) {
    set_has_Config();
    this->_Config = Config_;
}

inline void SetListsConfigStart::set_has_Config () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigStart::clear_has_Config () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigResult::SetListsConfigResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigResult::SetListsConfigResult (const SetListsConfigResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigResult::SetListsConfigResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigResult::~SetListsConfigResult() {
}

inline SetListsConfigResult& SetListsConfigResult::operator = (const SetListsConfigResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SetListsConfigResult::operator == (const SetListsConfigResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SetListsConfigResult::operator != (const SetListsConfigResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigResult::operator < (const SetListsConfigResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetListsConfigResult::clone() {
    return new SetListsConfigResult(*this);
}

inline bool SetListsConfigResult::operator > (const SetListsConfigResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigResult::clear() {
    clearStatus();
}

inline void SetListsConfigResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool SetListsConfigResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetListsConfigResult::getStatus () const {
    return _Status;
}

inline void SetListsConfigResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void SetListsConfigResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TheatreListsStatusStatus::TheatreListsStatusStatus ()  :
    _TheatreListsStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TheatreListsStatusStatus::TheatreListsStatusStatus (const TheatreListsStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _TheatreListsStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TheatreListsStatusStatus::TheatreListsStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& TheatreListsStatus_)  :
    _TheatreListsStatus (TheatreListsStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TheatreListsStatusStatus::~TheatreListsStatusStatus() {
}

inline TheatreListsStatusStatus& TheatreListsStatusStatus::operator = (const TheatreListsStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTheatreListsStatus()) {
            setTheatreListsStatus(rhs.getTheatreListsStatus());
        } else {
            clearTheatreListsStatus();
        }
    }
    return *this;
}

inline bool TheatreListsStatusStatus::operator == (const TheatreListsStatusStatus& rhs) const {
    return (((!hasTheatreListsStatus() && !rhs.hasTheatreListsStatus()) || getTheatreListsStatus() == rhs.getTheatreListsStatus()));
}

inline bool TheatreListsStatusStatus::operator != (const TheatreListsStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool TheatreListsStatusStatus::operator < (const TheatreListsStatusStatus& rhs) const {
    if (hasTheatreListsStatus() || rhs.hasTheatreListsStatus()) {
        if (getTheatreListsStatus() < rhs.getTheatreListsStatus()) return true;
        if (getTheatreListsStatus() > rhs.getTheatreListsStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TheatreListsStatusStatus::clone() {
    return new TheatreListsStatusStatus(*this);
}

inline bool TheatreListsStatusStatus::operator > (const TheatreListsStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TheatreListsStatusStatus::clear() {
    clearTheatreListsStatus();
}

inline void TheatreListsStatusStatus::clearTheatreListsStatus() {
    if (hasTheatreListsStatus()) {
         clear_has_TheatreListsStatus();
        _TheatreListsStatus.clear();
     }
}

inline bool TheatreListsStatusStatus::hasTheatreListsStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListInfos& TheatreListsStatusStatus::getTheatreListsStatus () const {
    return _TheatreListsStatus;
}

inline ::sxm_main_fi_types::T_SxmListInfos& TheatreListsStatusStatus::getTheatreListsStatusMutable () {
    set_has_TheatreListsStatus();
    return _TheatreListsStatus;
}

inline void TheatreListsStatusStatus::setTheatreListsStatus (const ::sxm_main_fi_types::T_SxmListInfos& TheatreListsStatus_) {
    set_has_TheatreListsStatus();
    this->_TheatreListsStatus = TheatreListsStatus_;
}

inline void TheatreListsStatusStatus::set_has_TheatreListsStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void TheatreListsStatusStatus::clear_has_TheatreListsStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus ()  :
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_)  :
    _DataServiceState (DataServiceState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::~SxmDataServiceStatusStatus() {
}

inline SxmDataServiceStatusStatus& SxmDataServiceStatusStatus::operator = (const SxmDataServiceStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataServiceState()) {
            setDataServiceState(rhs.getDataServiceState());
        } else {
            clearDataServiceState();
        }
    }
    return *this;
}

inline bool SxmDataServiceStatusStatus::operator == (const SxmDataServiceStatusStatus& rhs) const {
    return (((!hasDataServiceState() && !rhs.hasDataServiceState()) || getDataServiceState() == rhs.getDataServiceState()));
}

inline bool SxmDataServiceStatusStatus::operator != (const SxmDataServiceStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmDataServiceStatusStatus::operator < (const SxmDataServiceStatusStatus& rhs) const {
    if (hasDataServiceState() || rhs.hasDataServiceState()) {
        if (getDataServiceState() < rhs.getDataServiceState()) return true;
        if (getDataServiceState() > rhs.getDataServiceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmDataServiceStatusStatus::clone() {
    return new SxmDataServiceStatusStatus(*this);
}

inline bool SxmDataServiceStatusStatus::operator > (const SxmDataServiceStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmDataServiceStatusStatus::clear() {
    clearDataServiceState();
}

inline void SxmDataServiceStatusStatus::clearDataServiceState() {
    if (hasDataServiceState()) {
         clear_has_DataServiceState();
        _DataServiceState.clear();
     }
}

inline bool SxmDataServiceStatusStatus::hasDataServiceState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceState () const {
    return _DataServiceState;
}

inline ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceStateMutable () {
    set_has_DataServiceState();
    return _DataServiceState;
}

inline void SxmDataServiceStatusStatus::setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_) {
    set_has_DataServiceState();
    this->_DataServiceState = DataServiceState_;
}

inline void SxmDataServiceStatusStatus::set_has_DataServiceState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmDataServiceStatusStatus::clear_has_DataServiceState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeStatus::SxmListModeStatus ()  :
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeStatus::SxmListModeStatus (const SxmListModeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeStatus::SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_)  :
    _ListMode (ListMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeStatus::~SxmListModeStatus() {
}

inline SxmListModeStatus& SxmListModeStatus::operator = (const SxmListModeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
    }
    return *this;
}

inline bool SxmListModeStatus::operator == (const SxmListModeStatus& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()));
}

inline bool SxmListModeStatus::operator != (const SxmListModeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeStatus::operator < (const SxmListModeStatus& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeStatus::clone() {
    return new SxmListModeStatus(*this);
}

inline bool SxmListModeStatus::operator > (const SxmListModeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeStatus::clear() {
    clearListMode();
}

inline void SxmListModeStatus::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeStatus::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeStatus::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeStatus::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeStatus::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeSet::SxmListModeSet ()  :
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeSet::SxmListModeSet (const SxmListModeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeSet::SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_)  :
    _ListMode (ListMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeSet::~SxmListModeSet() {
}

inline SxmListModeSet& SxmListModeSet::operator = (const SxmListModeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
    }
    return *this;
}

inline bool SxmListModeSet::operator == (const SxmListModeSet& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()));
}

inline bool SxmListModeSet::operator != (const SxmListModeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeSet::operator < (const SxmListModeSet& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeSet::clone() {
    return new SxmListModeSet(*this);
}

inline bool SxmListModeSet::operator > (const SxmListModeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeSet::clear() {
    clearListMode();
}

inline void SxmListModeSet::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeSet::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeSet::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeSet::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeSet::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace sxm_movies_main_fi

#endif // SXM_MOVIES_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
