#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_FUEL_MAIN_FI_TYPES_H
#define SXM_FUEL_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_fuel_main_fi_typesConst.h"
#include "sxm_main_fi_types.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sxm_fuel_main_fi_types
 */

namespace sxm_fuel_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_FuelInfo;

class T_FuelTypeInfo;

class T_FuelTypeInfolist;

class T_FuelStationInfo;

// type definitions
/**
 * If the meaning of "T_FuelInfoList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_FuelInfo > T_FuelInfoList;

/**
 * If the meaning of "T_BrandNameList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< ::std::string > T_BrandNameList;

/**
 * If the meaning of "T_FuelTypeList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_FuelTypeInfo > T_FuelTypeList;


/**
 * If the meaning of "T_FuelInfo" isn't clear, then there should be a description here.
 */
class T_FuelInfo {
public:

    /**
     * Default constructor
     */
    inline  T_FuelInfo ();

    /**
     * Copy constructor
     */
    inline  T_FuelInfo (const T_FuelInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_FuelInfo (const ::std::string& StationName_, const ::std::string& Brand_, T_e8_FuelTypeEnum FuelType_, uint32 Fuel_LOCID_, const ::std::string& FuelName_, const ::std::string& FuelPrice_, uint8 FuelAge_, const ::sxm_main_fi_types::T_SxmLocation& FuelLoc_, float FuelDistKm_, float FuelDistMile_, uint32 NumPrices_);

    /**
     * Destructor
     */
    inline  ~T_FuelInfo();

    /**
     * Assignment operator
     */
    inline T_FuelInfo& operator = (const T_FuelInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FuelInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FuelInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FuelInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FuelInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StationName"

    static const int kStationName = 0;

    /**
     * Clears the field "StationName".
     *
     * The field will be set to its default value. The hasStationName()
     * method will return false.
     */
    inline void clearStationName();

    /**
     * Checks whether the field "StationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationName()). Otherwise it will return false.
     */
    inline bool hasStationName () const;

    /**
     * Returns the value of the member "StationName".
     *
     * Station Name
     *
     * @return The value of the field "StationName"
     */
    inline const ::std::string& getStationName () const;

    /**
     * Retrieves the value of the field "StationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StationName".
     */
    inline ::std::string& getStationNameMutable ();

    /**
     * Sets the value of the member "StationName".
     *
     * Station Name
     *
     * @param StationName The value which will be set
     */
    inline void setStationName (const ::std::string& StationName_);

    /**
     * Sets the value of the member "StationName".
     *
     * Station Name
     *
     * @param StationName The value which will be set
     */
    inline void setStationName (const char* StationName_);

    /**
     * Sets the value of the member "StationName".
     *
     * Station Name
     *
     * @param StationName The value which will be set
     */
    inline void setStationName (const char* value, size_t size);

    // API of field "Brand"

    static const int kBrand = 1;

    /**
     * Clears the field "Brand".
     *
     * The field will be set to its default value. The hasBrand()
     * method will return false.
     */
    inline void clearBrand();

    /**
     * Checks whether the field "Brand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrand()). Otherwise it will return false.
     */
    inline bool hasBrand () const;

    /**
     * Returns the value of the member "Brand".
     *
     * Brand Name
     *
     * @return The value of the field "Brand"
     */
    inline const ::std::string& getBrand () const;

    /**
     * Retrieves the value of the field "Brand" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Brand".
     */
    inline ::std::string& getBrandMutable ();

    /**
     * Sets the value of the member "Brand".
     *
     * Brand Name
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const ::std::string& Brand_);

    /**
     * Sets the value of the member "Brand".
     *
     * Brand Name
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const char* Brand_);

    /**
     * Sets the value of the member "Brand".
     *
     * Brand Name
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const char* value, size_t size);

    // API of field "FuelType"

    static const int kFuelType = 2;

    /**
     * Clears the field "FuelType".
     *
     * The field will be set to its default value. The hasFuelType()
     * method will return false.
     */
    inline void clearFuelType();

    /**
     * Checks whether the field "FuelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelType()). Otherwise it will return false.
     */
    inline bool hasFuelType () const;

    /**
     * Returns the value of the member "FuelType".
     *
     * Fuel Type
     *
     * @return The value of the field "FuelType"
     */
    inline T_e8_FuelTypeEnum getFuelType () const;

    /**
     * Sets the value of the member "FuelType".
     *
     * Fuel Type
     *
     * @param FuelType The value which will be set
     */
    inline void setFuelType (T_e8_FuelTypeEnum FuelType_);

    // API of field "Fuel_LOCID"

    static const int kFuel_LOCID = 3;

    /**
     * Clears the field "Fuel_LOCID".
     *
     * The field will be set to its default value. The hasFuel_LOCID()
     * method will return false.
     */
    inline void clearFuel_LOCID();

    /**
     * Checks whether the field "Fuel_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuel_LOCID()). Otherwise it will return false.
     */
    inline bool hasFuel_LOCID () const;

    /**
     * Returns the value of the member "Fuel_LOCID".
     *
     * LOCID
     *
     * @return The value of the field "Fuel_LOCID"
     */
    inline uint32 getFuel_LOCID () const;

    /**
     * Sets the value of the member "Fuel_LOCID".
     *
     * LOCID
     *
     * @param Fuel_LOCID The value which will be set
     */
    inline void setFuel_LOCID (uint32 Fuel_LOCID_);

    // API of field "FuelName"

    static const int kFuelName = 4;

    /**
     * Clears the field "FuelName".
     *
     * The field will be set to its default value. The hasFuelName()
     * method will return false.
     */
    inline void clearFuelName();

    /**
     * Checks whether the field "FuelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelName()). Otherwise it will return false.
     */
    inline bool hasFuelName () const;

    /**
     * Returns the value of the member "FuelName".
     *
     * Fuel Name
     *
     * @return The value of the field "FuelName"
     */
    inline const ::std::string& getFuelName () const;

    /**
     * Retrieves the value of the field "FuelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelName".
     */
    inline ::std::string& getFuelNameMutable ();

    /**
     * Sets the value of the member "FuelName".
     *
     * Fuel Name
     *
     * @param FuelName The value which will be set
     */
    inline void setFuelName (const ::std::string& FuelName_);

    /**
     * Sets the value of the member "FuelName".
     *
     * Fuel Name
     *
     * @param FuelName The value which will be set
     */
    inline void setFuelName (const char* FuelName_);

    /**
     * Sets the value of the member "FuelName".
     *
     * Fuel Name
     *
     * @param FuelName The value which will be set
     */
    inline void setFuelName (const char* value, size_t size);

    // API of field "FuelPrice"

    static const int kFuelPrice = 5;

    /**
     * Clears the field "FuelPrice".
     *
     * The field will be set to its default value. The hasFuelPrice()
     * method will return false.
     */
    inline void clearFuelPrice();

    /**
     * Checks whether the field "FuelPrice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelPrice()). Otherwise it will return false.
     */
    inline bool hasFuelPrice () const;

    /**
     * Returns the value of the member "FuelPrice".
     *
     * Fuel Price
     *
     * @return The value of the field "FuelPrice"
     */
    inline const ::std::string& getFuelPrice () const;

    /**
     * Retrieves the value of the field "FuelPrice" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelPrice".
     */
    inline ::std::string& getFuelPriceMutable ();

    /**
     * Sets the value of the member "FuelPrice".
     *
     * Fuel Price
     *
     * @param FuelPrice The value which will be set
     */
    inline void setFuelPrice (const ::std::string& FuelPrice_);

    /**
     * Sets the value of the member "FuelPrice".
     *
     * Fuel Price
     *
     * @param FuelPrice The value which will be set
     */
    inline void setFuelPrice (const char* FuelPrice_);

    /**
     * Sets the value of the member "FuelPrice".
     *
     * Fuel Price
     *
     * @param FuelPrice The value which will be set
     */
    inline void setFuelPrice (const char* value, size_t size);

    // API of field "FuelAge"

    static const int kFuelAge = 6;

    /**
     * Clears the field "FuelAge".
     *
     * The field will be set to its default value. The hasFuelAge()
     * method will return false.
     */
    inline void clearFuelAge();

    /**
     * Checks whether the field "FuelAge" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelAge()). Otherwise it will return false.
     */
    inline bool hasFuelAge () const;

    /**
     * Returns the value of the member "FuelAge".
     *
     * Fuel Age
     *
     * @return The value of the field "FuelAge"
     */
    inline uint8 getFuelAge () const;

    /**
     * Sets the value of the member "FuelAge".
     *
     * Fuel Age
     *
     * @param FuelAge The value which will be set
     */
    inline void setFuelAge (uint8 FuelAge_);

    // API of field "FuelLoc"

    static const int kFuelLoc = 7;

    /**
     * Clears the field "FuelLoc".
     *
     * The field will be set to its default value. The hasFuelLoc()
     * method will return false.
     */
    inline void clearFuelLoc();

    /**
     * Checks whether the field "FuelLoc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelLoc()). Otherwise it will return false.
     */
    inline bool hasFuelLoc () const;

    /**
     * Returns the value of the member "FuelLoc".
     *
     * Fuel Location information
     *
     * @return The value of the field "FuelLoc"
     */
    inline const ::sxm_main_fi_types::T_SxmLocation& getFuelLoc () const;

    /**
     * Retrieves the value of the field "FuelLoc" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelLoc".
     */
    inline ::sxm_main_fi_types::T_SxmLocation& getFuelLocMutable ();

    /**
     * Sets the value of the member "FuelLoc".
     *
     * Fuel Location information
     *
     * @param FuelLoc The value which will be set
     */
    inline void setFuelLoc (const ::sxm_main_fi_types::T_SxmLocation& FuelLoc_);

    // API of field "FuelDistKm"

    static const int kFuelDistKm = 8;

    /**
     * Clears the field "FuelDistKm".
     *
     * The field will be set to its default value. The hasFuelDistKm()
     * method will return false.
     */
    inline void clearFuelDistKm();

    /**
     * Checks whether the field "FuelDistKm" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelDistKm()). Otherwise it will return false.
     */
    inline bool hasFuelDistKm () const;

    /**
     * Returns the value of the member "FuelDistKm".
     *
     * Fuel station Distance Info in Kilometer
     *
     * @return The value of the field "FuelDistKm"
     */
    inline float getFuelDistKm () const;

    /**
     * Sets the value of the member "FuelDistKm".
     *
     * Fuel station Distance Info in Kilometer
     *
     * @param FuelDistKm The value which will be set
     */
    inline void setFuelDistKm (float FuelDistKm_);

    // API of field "FuelDistMile"

    static const int kFuelDistMile = 9;

    /**
     * Clears the field "FuelDistMile".
     *
     * The field will be set to its default value. The hasFuelDistMile()
     * method will return false.
     */
    inline void clearFuelDistMile();

    /**
     * Checks whether the field "FuelDistMile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelDistMile()). Otherwise it will return false.
     */
    inline bool hasFuelDistMile () const;

    /**
     * Returns the value of the member "FuelDistMile".
     *
     * Fuel station Distance Info in Miles
     *
     * @return The value of the field "FuelDistMile"
     */
    inline float getFuelDistMile () const;

    /**
     * Sets the value of the member "FuelDistMile".
     *
     * Fuel station Distance Info in Miles
     *
     * @param FuelDistMile The value which will be set
     */
    inline void setFuelDistMile (float FuelDistMile_);

    // API of field "NumPrices"

    static const int kNumPrices = 10;

    /**
     * Clears the field "NumPrices".
     *
     * The field will be set to its default value. The hasNumPrices()
     * method will return false.
     */
    inline void clearNumPrices();

    /**
     * Checks whether the field "NumPrices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumPrices()). Otherwise it will return false.
     */
    inline bool hasNumPrices () const;

    /**
     * Returns the value of the member "NumPrices".
     *
     * Number of fuel price
     *
     * @return The value of the field "NumPrices"
     */
    inline uint32 getNumPrices () const;

    /**
     * Sets the value of the member "NumPrices".
     *
     * Number of fuel price
     *
     * @param NumPrices The value which will be set
     */
    inline void setNumPrices (uint32 NumPrices_);

    static const T_FuelInfo &getDefaultInstance();

private:

    inline void set_has_StationName ();

    inline void clear_has_StationName ();

    inline void set_has_Brand ();

    inline void clear_has_Brand ();

    inline void set_has_FuelType ();

    inline void clear_has_FuelType ();

    inline void set_has_Fuel_LOCID ();

    inline void clear_has_Fuel_LOCID ();

    inline void set_has_FuelName ();

    inline void clear_has_FuelName ();

    inline void set_has_FuelPrice ();

    inline void clear_has_FuelPrice ();

    inline void set_has_FuelAge ();

    inline void clear_has_FuelAge ();

    inline void set_has_FuelLoc ();

    inline void clear_has_FuelLoc ();

    inline void set_has_FuelDistKm ();

    inline void clear_has_FuelDistKm ();

    inline void set_has_FuelDistMile ();

    inline void clear_has_FuelDistMile ();

    inline void set_has_NumPrices ();

    inline void clear_has_NumPrices ();

    uint32 _has_bits_[ (11 + 31) / 32];

    ::std::string _StationName;

    ::std::string _Brand;

    T_e8_FuelTypeEnum _FuelType;

    uint32 _Fuel_LOCID;

    ::std::string _FuelName;

    ::std::string _FuelPrice;

    uint8 _FuelAge;

    ::sxm_main_fi_types::T_SxmLocation _FuelLoc;

    float _FuelDistKm;

    float _FuelDistMile;

    uint32 _NumPrices;

};

/**
 * If the meaning of "T_FuelTypeInfo" isn't clear, then there should be a description here.
 */
class T_FuelTypeInfo {
public:

    /**
     * Default constructor
     */
    inline  T_FuelTypeInfo ();

    /**
     * Copy constructor
     */
    inline  T_FuelTypeInfo (const T_FuelTypeInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_FuelTypeInfo (T_e8_FuelTypeEnum FuelType_, const ::std::string& FuelName_);

    /**
     * Destructor
     */
    inline  ~T_FuelTypeInfo();

    /**
     * Assignment operator
     */
    inline T_FuelTypeInfo& operator = (const T_FuelTypeInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FuelTypeInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FuelTypeInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FuelTypeInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FuelTypeInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FuelType"

    static const int kFuelType = 0;

    /**
     * Clears the field "FuelType".
     *
     * The field will be set to its default value. The hasFuelType()
     * method will return false.
     */
    inline void clearFuelType();

    /**
     * Checks whether the field "FuelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelType()). Otherwise it will return false.
     */
    inline bool hasFuelType () const;

    /**
     * Returns the value of the member "FuelType".
     *
     * Fuel Type
     *
     * @return The value of the field "FuelType"
     */
    inline T_e8_FuelTypeEnum getFuelType () const;

    /**
     * Sets the value of the member "FuelType".
     *
     * Fuel Type
     *
     * @param FuelType The value which will be set
     */
    inline void setFuelType (T_e8_FuelTypeEnum FuelType_);

    // API of field "FuelName"

    static const int kFuelName = 1;

    /**
     * Clears the field "FuelName".
     *
     * The field will be set to its default value. The hasFuelName()
     * method will return false.
     */
    inline void clearFuelName();

    /**
     * Checks whether the field "FuelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelName()). Otherwise it will return false.
     */
    inline bool hasFuelName () const;

    /**
     * Returns the value of the member "FuelName".
     *
     * Fuel Name
     *
     * @return The value of the field "FuelName"
     */
    inline const ::std::string& getFuelName () const;

    /**
     * Retrieves the value of the field "FuelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelName".
     */
    inline ::std::string& getFuelNameMutable ();

    /**
     * Sets the value of the member "FuelName".
     *
     * Fuel Name
     *
     * @param FuelName The value which will be set
     */
    inline void setFuelName (const ::std::string& FuelName_);

    /**
     * Sets the value of the member "FuelName".
     *
     * Fuel Name
     *
     * @param FuelName The value which will be set
     */
    inline void setFuelName (const char* FuelName_);

    /**
     * Sets the value of the member "FuelName".
     *
     * Fuel Name
     *
     * @param FuelName The value which will be set
     */
    inline void setFuelName (const char* value, size_t size);

    static const T_FuelTypeInfo &getDefaultInstance();

private:

    inline void set_has_FuelType ();

    inline void clear_has_FuelType ();

    inline void set_has_FuelName ();

    inline void clear_has_FuelName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_FuelTypeEnum _FuelType;

    ::std::string _FuelName;

};

/**
 * If the meaning of "T_FuelTypeInfolist" isn't clear, then there should be a description here.
 */
class T_FuelTypeInfolist {
public:

    /**
     * Default constructor
     */
    inline  T_FuelTypeInfolist ();

    /**
     * Copy constructor
     */
    inline  T_FuelTypeInfolist (const T_FuelTypeInfolist &rhs);

    /**
     * All fields constructor
     */
    inline  T_FuelTypeInfolist (const ::std::string& FuelName_, const ::std::string& FuelPrice_, uint8 FuelAge_, bool FuelAvail_, T_e8_FuelTypeEnum FuelType_);

    /**
     * Destructor
     */
    inline  ~T_FuelTypeInfolist();

    /**
     * Assignment operator
     */
    inline T_FuelTypeInfolist& operator = (const T_FuelTypeInfolist& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FuelTypeInfolist& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FuelTypeInfolist& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FuelTypeInfolist& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FuelTypeInfolist& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FuelName"

    static const int kFuelName = 0;

    /**
     * Clears the field "FuelName".
     *
     * The field will be set to its default value. The hasFuelName()
     * method will return false.
     */
    inline void clearFuelName();

    /**
     * Checks whether the field "FuelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelName()). Otherwise it will return false.
     */
    inline bool hasFuelName () const;

    /**
     * Returns the value of the member "FuelName".
     *
     * Fuel Name
     *
     * @return The value of the field "FuelName"
     */
    inline const ::std::string& getFuelName () const;

    /**
     * Retrieves the value of the field "FuelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelName".
     */
    inline ::std::string& getFuelNameMutable ();

    /**
     * Sets the value of the member "FuelName".
     *
     * Fuel Name
     *
     * @param FuelName The value which will be set
     */
    inline void setFuelName (const ::std::string& FuelName_);

    /**
     * Sets the value of the member "FuelName".
     *
     * Fuel Name
     *
     * @param FuelName The value which will be set
     */
    inline void setFuelName (const char* FuelName_);

    /**
     * Sets the value of the member "FuelName".
     *
     * Fuel Name
     *
     * @param FuelName The value which will be set
     */
    inline void setFuelName (const char* value, size_t size);

    // API of field "FuelPrice"

    static const int kFuelPrice = 1;

    /**
     * Clears the field "FuelPrice".
     *
     * The field will be set to its default value. The hasFuelPrice()
     * method will return false.
     */
    inline void clearFuelPrice();

    /**
     * Checks whether the field "FuelPrice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelPrice()). Otherwise it will return false.
     */
    inline bool hasFuelPrice () const;

    /**
     * Returns the value of the member "FuelPrice".
     *
     * Fuel Price
     *
     * @return The value of the field "FuelPrice"
     */
    inline const ::std::string& getFuelPrice () const;

    /**
     * Retrieves the value of the field "FuelPrice" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelPrice".
     */
    inline ::std::string& getFuelPriceMutable ();

    /**
     * Sets the value of the member "FuelPrice".
     *
     * Fuel Price
     *
     * @param FuelPrice The value which will be set
     */
    inline void setFuelPrice (const ::std::string& FuelPrice_);

    /**
     * Sets the value of the member "FuelPrice".
     *
     * Fuel Price
     *
     * @param FuelPrice The value which will be set
     */
    inline void setFuelPrice (const char* FuelPrice_);

    /**
     * Sets the value of the member "FuelPrice".
     *
     * Fuel Price
     *
     * @param FuelPrice The value which will be set
     */
    inline void setFuelPrice (const char* value, size_t size);

    // API of field "FuelAge"

    static const int kFuelAge = 2;

    /**
     * Clears the field "FuelAge".
     *
     * The field will be set to its default value. The hasFuelAge()
     * method will return false.
     */
    inline void clearFuelAge();

    /**
     * Checks whether the field "FuelAge" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelAge()). Otherwise it will return false.
     */
    inline bool hasFuelAge () const;

    /**
     * Returns the value of the member "FuelAge".
     *
     * Fuel Age
     *
     * @return The value of the field "FuelAge"
     */
    inline uint8 getFuelAge () const;

    /**
     * Sets the value of the member "FuelAge".
     *
     * Fuel Age
     *
     * @param FuelAge The value which will be set
     */
    inline void setFuelAge (uint8 FuelAge_);

    // API of field "FuelAvail"

    static const int kFuelAvail = 3;

    /**
     * Clears the field "FuelAvail".
     *
     * The field will be set to its default value. The hasFuelAvail()
     * method will return false.
     */
    inline void clearFuelAvail();

    /**
     * Checks whether the field "FuelAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelAvail()). Otherwise it will return false.
     */
    inline bool hasFuelAvail () const;

    /**
     * Returns the value of the member "FuelAvail".
     *
     * Fuel Availability
     *
     * @return The value of the field "FuelAvail"
     */
    inline bool getFuelAvail () const;

    /**
     * Sets the value of the member "FuelAvail".
     *
     * Fuel Availability
     *
     * @param FuelAvail The value which will be set
     */
    inline void setFuelAvail (bool FuelAvail_);

    // API of field "FuelType"

    static const int kFuelType = 4;

    /**
     * Clears the field "FuelType".
     *
     * The field will be set to its default value. The hasFuelType()
     * method will return false.
     */
    inline void clearFuelType();

    /**
     * Checks whether the field "FuelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelType()). Otherwise it will return false.
     */
    inline bool hasFuelType () const;

    /**
     * Returns the value of the member "FuelType".
     *
     * Fuel Type
     *
     * @return The value of the field "FuelType"
     */
    inline T_e8_FuelTypeEnum getFuelType () const;

    /**
     * Sets the value of the member "FuelType".
     *
     * Fuel Type
     *
     * @param FuelType The value which will be set
     */
    inline void setFuelType (T_e8_FuelTypeEnum FuelType_);

    static const T_FuelTypeInfolist &getDefaultInstance();

private:

    inline void set_has_FuelName ();

    inline void clear_has_FuelName ();

    inline void set_has_FuelPrice ();

    inline void clear_has_FuelPrice ();

    inline void set_has_FuelAge ();

    inline void clear_has_FuelAge ();

    inline void set_has_FuelAvail ();

    inline void clear_has_FuelAvail ();

    inline void set_has_FuelType ();

    inline void clear_has_FuelType ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _FuelName;

    ::std::string _FuelPrice;

    uint8 _FuelAge;

    bool _FuelAvail;

    T_e8_FuelTypeEnum _FuelType;

};

/**
 * If the meaning of "T_FuelStationInfo" isn't clear, then there should be a description here.
 */
class T_FuelStationInfo {
public:

    /**
     * Default constructor
     */
    inline  T_FuelStationInfo ();

    /**
     * Copy constructor
     */
    inline  T_FuelStationInfo (const T_FuelStationInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_FuelStationInfo (const ::std::string& StationName_, const ::std::string& Brand_, const ::std::string& StreetName_, const ::std::string& City_, const ::std::string& State_, const ::std::string& ZipCode_, const ::std::string& Phone_, uint32 Fuel_LOCID_, const ::std::string& Amenity_, bool FuelFavInfo_, const ::sxm_main_fi_types::T_SxmLocation& FuelLocation_, const ::std::vector< T_FuelTypeInfolist >& FuelTypelist_, const ::std::vector< T_e8_FuelStationAmenity >& StationAmenitylist_, uint32 NumPrices_);

    /**
     * Destructor
     */
    inline  ~T_FuelStationInfo();

    /**
     * Assignment operator
     */
    inline T_FuelStationInfo& operator = (const T_FuelStationInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FuelStationInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FuelStationInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FuelStationInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FuelStationInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StationName"

    static const int kStationName = 0;

    /**
     * Clears the field "StationName".
     *
     * The field will be set to its default value. The hasStationName()
     * method will return false.
     */
    inline void clearStationName();

    /**
     * Checks whether the field "StationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationName()). Otherwise it will return false.
     */
    inline bool hasStationName () const;

    /**
     * Returns the value of the member "StationName".
     *
     * Station Name
     *
     * @return The value of the field "StationName"
     */
    inline const ::std::string& getStationName () const;

    /**
     * Retrieves the value of the field "StationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StationName".
     */
    inline ::std::string& getStationNameMutable ();

    /**
     * Sets the value of the member "StationName".
     *
     * Station Name
     *
     * @param StationName The value which will be set
     */
    inline void setStationName (const ::std::string& StationName_);

    /**
     * Sets the value of the member "StationName".
     *
     * Station Name
     *
     * @param StationName The value which will be set
     */
    inline void setStationName (const char* StationName_);

    /**
     * Sets the value of the member "StationName".
     *
     * Station Name
     *
     * @param StationName The value which will be set
     */
    inline void setStationName (const char* value, size_t size);

    // API of field "Brand"

    static const int kBrand = 1;

    /**
     * Clears the field "Brand".
     *
     * The field will be set to its default value. The hasBrand()
     * method will return false.
     */
    inline void clearBrand();

    /**
     * Checks whether the field "Brand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrand()). Otherwise it will return false.
     */
    inline bool hasBrand () const;

    /**
     * Returns the value of the member "Brand".
     *
     * Brand Name
     *
     * @return The value of the field "Brand"
     */
    inline const ::std::string& getBrand () const;

    /**
     * Retrieves the value of the field "Brand" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Brand".
     */
    inline ::std::string& getBrandMutable ();

    /**
     * Sets the value of the member "Brand".
     *
     * Brand Name
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const ::std::string& Brand_);

    /**
     * Sets the value of the member "Brand".
     *
     * Brand Name
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const char* Brand_);

    /**
     * Sets the value of the member "Brand".
     *
     * Brand Name
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const char* value, size_t size);

    // API of field "StreetName"

    static const int kStreetName = 2;

    /**
     * Clears the field "StreetName".
     *
     * The field will be set to its default value. The hasStreetName()
     * method will return false.
     */
    inline void clearStreetName();

    /**
     * Checks whether the field "StreetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStreetName()). Otherwise it will return false.
     */
    inline bool hasStreetName () const;

    /**
     * Returns the value of the member "StreetName".
     *
     * StreetName
     *
     * @return The value of the field "StreetName"
     */
    inline const ::std::string& getStreetName () const;

    /**
     * Retrieves the value of the field "StreetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StreetName".
     */
    inline ::std::string& getStreetNameMutable ();

    /**
     * Sets the value of the member "StreetName".
     *
     * StreetName
     *
     * @param StreetName The value which will be set
     */
    inline void setStreetName (const ::std::string& StreetName_);

    /**
     * Sets the value of the member "StreetName".
     *
     * StreetName
     *
     * @param StreetName The value which will be set
     */
    inline void setStreetName (const char* StreetName_);

    /**
     * Sets the value of the member "StreetName".
     *
     * StreetName
     *
     * @param StreetName The value which will be set
     */
    inline void setStreetName (const char* value, size_t size);

    // API of field "City"

    static const int kCity = 3;

    /**
     * Clears the field "City".
     *
     * The field will be set to its default value. The hasCity()
     * method will return false.
     */
    inline void clearCity();

    /**
     * Checks whether the field "City" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCity()). Otherwise it will return false.
     */
    inline bool hasCity () const;

    /**
     * Returns the value of the member "City".
     *
     * City
     *
     * @return The value of the field "City"
     */
    inline const ::std::string& getCity () const;

    /**
     * Retrieves the value of the field "City" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "City".
     */
    inline ::std::string& getCityMutable ();

    /**
     * Sets the value of the member "City".
     *
     * City
     *
     * @param City The value which will be set
     */
    inline void setCity (const ::std::string& City_);

    /**
     * Sets the value of the member "City".
     *
     * City
     *
     * @param City The value which will be set
     */
    inline void setCity (const char* City_);

    /**
     * Sets the value of the member "City".
     *
     * City
     *
     * @param City The value which will be set
     */
    inline void setCity (const char* value, size_t size);

    // API of field "State"

    static const int kState = 4;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * State
     *
     * @return The value of the field "State"
     */
    inline const ::std::string& getState () const;

    /**
     * Retrieves the value of the field "State" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "State".
     */
    inline ::std::string& getStateMutable ();

    /**
     * Sets the value of the member "State".
     *
     * State
     *
     * @param State The value which will be set
     */
    inline void setState (const ::std::string& State_);

    /**
     * Sets the value of the member "State".
     *
     * State
     *
     * @param State The value which will be set
     */
    inline void setState (const char* State_);

    /**
     * Sets the value of the member "State".
     *
     * State
     *
     * @param State The value which will be set
     */
    inline void setState (const char* value, size_t size);

    // API of field "ZipCode"

    static const int kZipCode = 5;

    /**
     * Clears the field "ZipCode".
     *
     * The field will be set to its default value. The hasZipCode()
     * method will return false.
     */
    inline void clearZipCode();

    /**
     * Checks whether the field "ZipCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setZipCode()). Otherwise it will return false.
     */
    inline bool hasZipCode () const;

    /**
     * Returns the value of the member "ZipCode".
     *
     * ZipCode
     *
     * @return The value of the field "ZipCode"
     */
    inline const ::std::string& getZipCode () const;

    /**
     * Retrieves the value of the field "ZipCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ZipCode".
     */
    inline ::std::string& getZipCodeMutable ();

    /**
     * Sets the value of the member "ZipCode".
     *
     * ZipCode
     *
     * @param ZipCode The value which will be set
     */
    inline void setZipCode (const ::std::string& ZipCode_);

    /**
     * Sets the value of the member "ZipCode".
     *
     * ZipCode
     *
     * @param ZipCode The value which will be set
     */
    inline void setZipCode (const char* ZipCode_);

    /**
     * Sets the value of the member "ZipCode".
     *
     * ZipCode
     *
     * @param ZipCode The value which will be set
     */
    inline void setZipCode (const char* value, size_t size);

    // API of field "Phone"

    static const int kPhone = 6;

    /**
     * Clears the field "Phone".
     *
     * The field will be set to its default value. The hasPhone()
     * method will return false.
     */
    inline void clearPhone();

    /**
     * Checks whether the field "Phone" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhone()). Otherwise it will return false.
     */
    inline bool hasPhone () const;

    /**
     * Returns the value of the member "Phone".
     *
     * Phone
     *
     * @return The value of the field "Phone"
     */
    inline const ::std::string& getPhone () const;

    /**
     * Retrieves the value of the field "Phone" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Phone".
     */
    inline ::std::string& getPhoneMutable ();

    /**
     * Sets the value of the member "Phone".
     *
     * Phone
     *
     * @param Phone The value which will be set
     */
    inline void setPhone (const ::std::string& Phone_);

    /**
     * Sets the value of the member "Phone".
     *
     * Phone
     *
     * @param Phone The value which will be set
     */
    inline void setPhone (const char* Phone_);

    /**
     * Sets the value of the member "Phone".
     *
     * Phone
     *
     * @param Phone The value which will be set
     */
    inline void setPhone (const char* value, size_t size);

    // API of field "Fuel_LOCID"

    static const int kFuel_LOCID = 7;

    /**
     * Clears the field "Fuel_LOCID".
     *
     * The field will be set to its default value. The hasFuel_LOCID()
     * method will return false.
     */
    inline void clearFuel_LOCID();

    /**
     * Checks whether the field "Fuel_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuel_LOCID()). Otherwise it will return false.
     */
    inline bool hasFuel_LOCID () const;

    /**
     * Returns the value of the member "Fuel_LOCID".
     *
     * Phone
     *
     * @return The value of the field "Fuel_LOCID"
     */
    inline uint32 getFuel_LOCID () const;

    /**
     * Sets the value of the member "Fuel_LOCID".
     *
     * Phone
     *
     * @param Fuel_LOCID The value which will be set
     */
    inline void setFuel_LOCID (uint32 Fuel_LOCID_);

    // API of field "Amenity"

    static const int kAmenity = 8;

    /**
     * Clears the field "Amenity".
     *
     * The field will be set to its default value. The hasAmenity()
     * method will return false.
     */
    inline void clearAmenity();

    /**
     * Checks whether the field "Amenity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmenity()). Otherwise it will return false.
     */
    inline bool hasAmenity () const;

    /**
     * Returns the value of the member "Amenity".
     *
     * AMENITY
     *
     * @return The value of the field "Amenity"
     */
    inline const ::std::string& getAmenity () const;

    /**
     * Retrieves the value of the field "Amenity" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Amenity".
     */
    inline ::std::string& getAmenityMutable ();

    /**
     * Sets the value of the member "Amenity".
     *
     * AMENITY
     *
     * @param Amenity The value which will be set
     */
    inline void setAmenity (const ::std::string& Amenity_);

    /**
     * Sets the value of the member "Amenity".
     *
     * AMENITY
     *
     * @param Amenity The value which will be set
     */
    inline void setAmenity (const char* Amenity_);

    /**
     * Sets the value of the member "Amenity".
     *
     * AMENITY
     *
     * @param Amenity The value which will be set
     */
    inline void setAmenity (const char* value, size_t size);

    // API of field "FuelFavInfo"

    static const int kFuelFavInfo = 9;

    /**
     * Clears the field "FuelFavInfo".
     *
     * The field will be set to its default value. The hasFuelFavInfo()
     * method will return false.
     */
    inline void clearFuelFavInfo();

    /**
     * Checks whether the field "FuelFavInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelFavInfo()). Otherwise it will return false.
     */
    inline bool hasFuelFavInfo () const;

    /**
     * Returns the value of the member "FuelFavInfo".
     *
     * Fuel Favorit Info
     *
     * @return The value of the field "FuelFavInfo"
     */
    inline bool getFuelFavInfo () const;

    /**
     * Sets the value of the member "FuelFavInfo".
     *
     * Fuel Favorit Info
     *
     * @param FuelFavInfo The value which will be set
     */
    inline void setFuelFavInfo (bool FuelFavInfo_);

    // API of field "FuelLocation"

    static const int kFuelLocation = 10;

    /**
     * Clears the field "FuelLocation".
     *
     * The field will be set to its default value. The hasFuelLocation()
     * method will return false.
     */
    inline void clearFuelLocation();

    /**
     * Checks whether the field "FuelLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelLocation()). Otherwise it will return false.
     */
    inline bool hasFuelLocation () const;

    /**
     * Returns the value of the member "FuelLocation".
     *
     * Theatre Location information
     *
     * @return The value of the field "FuelLocation"
     */
    inline const ::sxm_main_fi_types::T_SxmLocation& getFuelLocation () const;

    /**
     * Retrieves the value of the field "FuelLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelLocation".
     */
    inline ::sxm_main_fi_types::T_SxmLocation& getFuelLocationMutable ();

    /**
     * Sets the value of the member "FuelLocation".
     *
     * Theatre Location information
     *
     * @param FuelLocation The value which will be set
     */
    inline void setFuelLocation (const ::sxm_main_fi_types::T_SxmLocation& FuelLocation_);

    // API of field "FuelTypelist"

    static const int kFuelTypelist = 11;

    /**
     * Clears the field "FuelTypelist".
     *
     * The field will be set to its default value. The hasFuelTypelist()
     * method will return false.
     */
    inline void clearFuelTypelist();

    /**
     * Checks whether the field "FuelTypelist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelTypelist()). Otherwise it will return false.
     */
    inline bool hasFuelTypelist () const;

    /**
     * Returns the value of the member "FuelTypelist".
     *
     * List of Information for each fuel types
     *
     * @return The value of the field "FuelTypelist"
     */
    inline const ::std::vector< T_FuelTypeInfolist >& getFuelTypelist () const;

    /**
     * Retrieves the value of the field "FuelTypelist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelTypelist".
     */
    inline ::std::vector< T_FuelTypeInfolist >& getFuelTypelistMutable ();

    /**
     * Sets the value of the member "FuelTypelist".
     *
     * List of Information for each fuel types
     *
     * @param FuelTypelist The value which will be set
     */
    inline void setFuelTypelist (const ::std::vector< T_FuelTypeInfolist >& FuelTypelist_);

    // API of field "StationAmenitylist"

    static const int kStationAmenitylist = 12;

    /**
     * Clears the field "StationAmenitylist".
     *
     * The field will be set to its default value. The hasStationAmenitylist()
     * method will return false.
     */
    inline void clearStationAmenitylist();

    /**
     * Checks whether the field "StationAmenitylist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationAmenitylist()). Otherwise it will return false.
     */
    inline bool hasStationAmenitylist () const;

    /**
     * Returns the value of the member "StationAmenitylist".
     *
     * List of Information for each fuel types
     *
     * @return The value of the field "StationAmenitylist"
     */
    inline const ::std::vector< T_e8_FuelStationAmenity >& getStationAmenitylist () const;

    /**
     * Retrieves the value of the field "StationAmenitylist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StationAmenitylist".
     */
    inline ::std::vector< T_e8_FuelStationAmenity >& getStationAmenitylistMutable ();

    /**
     * Sets the value of the member "StationAmenitylist".
     *
     * List of Information for each fuel types
     *
     * @param StationAmenitylist The value which will be set
     */
    inline void setStationAmenitylist (const ::std::vector< T_e8_FuelStationAmenity >& StationAmenitylist_);

    // API of field "NumPrices"

    static const int kNumPrices = 13;

    /**
     * Clears the field "NumPrices".
     *
     * The field will be set to its default value. The hasNumPrices()
     * method will return false.
     */
    inline void clearNumPrices();

    /**
     * Checks whether the field "NumPrices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumPrices()). Otherwise it will return false.
     */
    inline bool hasNumPrices () const;

    /**
     * Returns the value of the member "NumPrices".
     *
     * Number of fuel price
     *
     * @return The value of the field "NumPrices"
     */
    inline uint32 getNumPrices () const;

    /**
     * Sets the value of the member "NumPrices".
     *
     * Number of fuel price
     *
     * @param NumPrices The value which will be set
     */
    inline void setNumPrices (uint32 NumPrices_);

    static const T_FuelStationInfo &getDefaultInstance();

private:

    static const ::std::vector< T_FuelTypeInfolist >& getT_FuelTypeInfolistList_DefaultInstance ();

    static const ::std::vector< T_e8_FuelStationAmenity >& getT_e8_FuelStationAmenityList_DefaultInstance ();

    inline void set_has_StationName ();

    inline void clear_has_StationName ();

    inline void set_has_Brand ();

    inline void clear_has_Brand ();

    inline void set_has_StreetName ();

    inline void clear_has_StreetName ();

    inline void set_has_City ();

    inline void clear_has_City ();

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_ZipCode ();

    inline void clear_has_ZipCode ();

    inline void set_has_Phone ();

    inline void clear_has_Phone ();

    inline void set_has_Fuel_LOCID ();

    inline void clear_has_Fuel_LOCID ();

    inline void set_has_Amenity ();

    inline void clear_has_Amenity ();

    inline void set_has_FuelFavInfo ();

    inline void clear_has_FuelFavInfo ();

    inline void set_has_FuelLocation ();

    inline void clear_has_FuelLocation ();

    inline void set_has_FuelTypelist ();

    inline void clear_has_FuelTypelist ();

    inline void set_has_StationAmenitylist ();

    inline void clear_has_StationAmenitylist ();

    inline void set_has_NumPrices ();

    inline void clear_has_NumPrices ();

    uint32 _has_bits_[ (14 + 31) / 32];

    ::std::string _StationName;

    ::std::string _Brand;

    ::std::string _StreetName;

    ::std::string _City;

    ::std::string _State;

    ::std::string _ZipCode;

    ::std::string _Phone;

    uint32 _Fuel_LOCID;

    ::std::string _Amenity;

    bool _FuelFavInfo;

    ::sxm_main_fi_types::T_SxmLocation _FuelLocation;

    ::std::vector< T_FuelTypeInfolist > _FuelTypelist;

    ::std::vector< T_e8_FuelStationAmenity > _StationAmenitylist;

    uint32 _NumPrices;

};

inline  T_FuelInfo::T_FuelInfo ()  :
    _StationName (),
    _Brand (),
    _FuelType (::sxm_fuel_main_fi_types::T_e8_FuelTypeEnum__FUEL_TYPE_REGULAR),
    _Fuel_LOCID (0u),
    _FuelName (),
    _FuelPrice (),
    _FuelAge (0u),
    _FuelLoc (),
    _FuelDistKm (0.0f),
    _FuelDistMile (0.0f),
    _NumPrices (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FuelInfo::T_FuelInfo (const T_FuelInfo &rhs)  :
    _StationName (),
    _Brand (),
    _FuelType (::sxm_fuel_main_fi_types::T_e8_FuelTypeEnum__FUEL_TYPE_REGULAR),
    _Fuel_LOCID (0u),
    _FuelName (),
    _FuelPrice (),
    _FuelAge (0u),
    _FuelLoc (),
    _FuelDistKm (0.0f),
    _FuelDistMile (0.0f),
    _NumPrices (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FuelInfo::T_FuelInfo (const ::std::string& StationName_, const ::std::string& Brand_, T_e8_FuelTypeEnum FuelType_, uint32 Fuel_LOCID_, const ::std::string& FuelName_, const ::std::string& FuelPrice_, uint8 FuelAge_, const ::sxm_main_fi_types::T_SxmLocation& FuelLoc_, float FuelDistKm_, float FuelDistMile_, uint32 NumPrices_)  :
    _StationName (StationName_),
    _Brand (Brand_),
    _FuelType (FuelType_),
    _Fuel_LOCID (Fuel_LOCID_),
    _FuelName (FuelName_),
    _FuelPrice (FuelPrice_),
    _FuelAge (FuelAge_),
    _FuelLoc (FuelLoc_),
    _FuelDistKm (FuelDistKm_),
    _FuelDistMile (FuelDistMile_),
    _NumPrices (NumPrices_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_FuelTypeEnum_IsValid(FuelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FuelType_, "T_e8_FuelTypeEnum", "FuelType", "T_FuelInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelPrice_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FuelInfo::~T_FuelInfo() {
}

inline T_FuelInfo& T_FuelInfo::operator = (const T_FuelInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStationName()) {
            setStationName(rhs.getStationName());
        } else {
            clearStationName();
        }
        if (rhs.hasBrand()) {
            setBrand(rhs.getBrand());
        } else {
            clearBrand();
        }
        if (rhs.hasFuelType()) {
            setFuelType(rhs.getFuelType());
        } else {
            clearFuelType();
        }
        if (rhs.hasFuel_LOCID()) {
            setFuel_LOCID(rhs.getFuel_LOCID());
        } else {
            clearFuel_LOCID();
        }
        if (rhs.hasFuelName()) {
            setFuelName(rhs.getFuelName());
        } else {
            clearFuelName();
        }
        if (rhs.hasFuelPrice()) {
            setFuelPrice(rhs.getFuelPrice());
        } else {
            clearFuelPrice();
        }
        if (rhs.hasFuelAge()) {
            setFuelAge(rhs.getFuelAge());
        } else {
            clearFuelAge();
        }
        if (rhs.hasFuelLoc()) {
            setFuelLoc(rhs.getFuelLoc());
        } else {
            clearFuelLoc();
        }
        if (rhs.hasFuelDistKm()) {
            setFuelDistKm(rhs.getFuelDistKm());
        } else {
            clearFuelDistKm();
        }
        if (rhs.hasFuelDistMile()) {
            setFuelDistMile(rhs.getFuelDistMile());
        } else {
            clearFuelDistMile();
        }
        if (rhs.hasNumPrices()) {
            setNumPrices(rhs.getNumPrices());
        } else {
            clearNumPrices();
        }
    }
    return *this;
}

inline bool T_FuelInfo::operator == (const T_FuelInfo& rhs) const {
    return (((!hasStationName() && !rhs.hasStationName()) || getStationName() == rhs.getStationName()) &&
        ((!hasBrand() && !rhs.hasBrand()) || getBrand() == rhs.getBrand()) &&
        ((!hasFuelType() && !rhs.hasFuelType()) || getFuelType() == rhs.getFuelType()) &&
        ((!hasFuel_LOCID() && !rhs.hasFuel_LOCID()) || getFuel_LOCID() == rhs.getFuel_LOCID()) &&
        ((!hasFuelName() && !rhs.hasFuelName()) || getFuelName() == rhs.getFuelName()) &&
        ((!hasFuelPrice() && !rhs.hasFuelPrice()) || getFuelPrice() == rhs.getFuelPrice()) &&
        ((!hasFuelAge() && !rhs.hasFuelAge()) || getFuelAge() == rhs.getFuelAge()) &&
        ((!hasFuelLoc() && !rhs.hasFuelLoc()) || getFuelLoc() == rhs.getFuelLoc()) &&
        ((!hasFuelDistKm() && !rhs.hasFuelDistKm()) || getFuelDistKm() == rhs.getFuelDistKm()) &&
        ((!hasFuelDistMile() && !rhs.hasFuelDistMile()) || getFuelDistMile() == rhs.getFuelDistMile()) &&
        ((!hasNumPrices() && !rhs.hasNumPrices()) || getNumPrices() == rhs.getNumPrices()));
}

inline bool T_FuelInfo::operator != (const T_FuelInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FuelInfo::operator < (const T_FuelInfo& rhs) const {
    if (hasStationName() || rhs.hasStationName()) {
        if (getStationName() < rhs.getStationName()) return true;
        if (getStationName() > rhs.getStationName()) return false;
    }
    if (hasBrand() || rhs.hasBrand()) {
        if (getBrand() < rhs.getBrand()) return true;
        if (getBrand() > rhs.getBrand()) return false;
    }
    if (hasFuelType() || rhs.hasFuelType()) {
        if ((uint32)getFuelType() < (uint32)rhs.getFuelType()) return true;
        if ((uint32)getFuelType() > (uint32)rhs.getFuelType()) return false;
    }
    if (hasFuel_LOCID() || rhs.hasFuel_LOCID()) {
        if (getFuel_LOCID() < rhs.getFuel_LOCID()) return true;
        if (getFuel_LOCID() > rhs.getFuel_LOCID()) return false;
    }
    if (hasFuelName() || rhs.hasFuelName()) {
        if (getFuelName() < rhs.getFuelName()) return true;
        if (getFuelName() > rhs.getFuelName()) return false;
    }
    if (hasFuelPrice() || rhs.hasFuelPrice()) {
        if (getFuelPrice() < rhs.getFuelPrice()) return true;
        if (getFuelPrice() > rhs.getFuelPrice()) return false;
    }
    if (hasFuelAge() || rhs.hasFuelAge()) {
        if (getFuelAge() < rhs.getFuelAge()) return true;
        if (getFuelAge() > rhs.getFuelAge()) return false;
    }
    if (hasFuelLoc() || rhs.hasFuelLoc()) {
        if (getFuelLoc() < rhs.getFuelLoc()) return true;
        if (getFuelLoc() > rhs.getFuelLoc()) return false;
    }
    if (hasFuelDistKm() || rhs.hasFuelDistKm()) {
        if (getFuelDistKm() < rhs.getFuelDistKm()) return true;
        if (getFuelDistKm() > rhs.getFuelDistKm()) return false;
    }
    if (hasFuelDistMile() || rhs.hasFuelDistMile()) {
        if (getFuelDistMile() < rhs.getFuelDistMile()) return true;
        if (getFuelDistMile() > rhs.getFuelDistMile()) return false;
    }
    if (hasNumPrices() || rhs.hasNumPrices()) {
        if (getNumPrices() < rhs.getNumPrices()) return true;
        if (getNumPrices() > rhs.getNumPrices()) return false;
    }
    return false;
}

inline bool T_FuelInfo::operator > (const T_FuelInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FuelInfo::clear() {
    clearStationName();
    clearBrand();
    clearFuelType();
    clearFuel_LOCID();
    clearFuelName();
    clearFuelPrice();
    clearFuelAge();
    clearFuelLoc();
    clearFuelDistKm();
    clearFuelDistMile();
    clearNumPrices();
}

inline void T_FuelInfo::clearStationName() {
    if (hasStationName()) {
         clear_has_StationName();
        _StationName.clear();
     }
}

inline bool T_FuelInfo::hasStationName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_FuelInfo::getStationName () const {
    return _StationName;
}

inline ::std::string& T_FuelInfo::getStationNameMutable () {
    set_has_StationName();
    return _StationName;
}

inline void T_FuelInfo::setStationName (const ::std::string& StationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationName();
    this->_StationName = StationName_;
}

inline void T_FuelInfo::setStationName (const char* StationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationName();
    this->_StationName.assign(StationName_);
}

inline void T_FuelInfo::setStationName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationName();
    this->_StationName.assign(value, size);
}

inline void T_FuelInfo::clearBrand() {
    if (hasBrand()) {
         clear_has_Brand();
        _Brand.clear();
     }
}

inline bool T_FuelInfo::hasBrand () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_FuelInfo::getBrand () const {
    return _Brand;
}

inline ::std::string& T_FuelInfo::getBrandMutable () {
    set_has_Brand();
    return _Brand;
}

inline void T_FuelInfo::setBrand (const ::std::string& Brand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand = Brand_;
}

inline void T_FuelInfo::setBrand (const char* Brand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand.assign(Brand_);
}

inline void T_FuelInfo::setBrand (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand.assign(value, size);
}

inline void T_FuelInfo::clearFuelType() {
    if (hasFuelType()) {
         clear_has_FuelType();
        _FuelType = ::sxm_fuel_main_fi_types::T_e8_FuelTypeEnum__FUEL_TYPE_REGULAR;
     }
}

inline bool T_FuelInfo::hasFuelType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_FuelTypeEnum T_FuelInfo::getFuelType () const {
    return _FuelType;
}

inline void T_FuelInfo::setFuelType (T_e8_FuelTypeEnum FuelType_) {
    #ifndef NDEBUG
    if (!(T_e8_FuelTypeEnum_IsValid(FuelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FuelType_, "T_e8_FuelTypeEnum", "FuelType", "T_FuelInfo");
    }
    #endif
    set_has_FuelType();
    this->_FuelType = FuelType_;
}

inline void T_FuelInfo::clearFuel_LOCID() {
    if (hasFuel_LOCID()) {
         clear_has_Fuel_LOCID();
        _Fuel_LOCID = 0u;
     }
}

inline bool T_FuelInfo::hasFuel_LOCID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_FuelInfo::getFuel_LOCID () const {
    return _Fuel_LOCID;
}

inline void T_FuelInfo::setFuel_LOCID (uint32 Fuel_LOCID_) {
    set_has_Fuel_LOCID();
    this->_Fuel_LOCID = Fuel_LOCID_;
}

inline void T_FuelInfo::clearFuelName() {
    if (hasFuelName()) {
         clear_has_FuelName();
        _FuelName.clear();
     }
}

inline bool T_FuelInfo::hasFuelName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_FuelInfo::getFuelName () const {
    return _FuelName;
}

inline ::std::string& T_FuelInfo::getFuelNameMutable () {
    set_has_FuelName();
    return _FuelName;
}

inline void T_FuelInfo::setFuelName (const ::std::string& FuelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelName();
    this->_FuelName = FuelName_;
}

inline void T_FuelInfo::setFuelName (const char* FuelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelName();
    this->_FuelName.assign(FuelName_);
}

inline void T_FuelInfo::setFuelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelName();
    this->_FuelName.assign(value, size);
}

inline void T_FuelInfo::clearFuelPrice() {
    if (hasFuelPrice()) {
         clear_has_FuelPrice();
        _FuelPrice.clear();
     }
}

inline bool T_FuelInfo::hasFuelPrice () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_FuelInfo::getFuelPrice () const {
    return _FuelPrice;
}

inline ::std::string& T_FuelInfo::getFuelPriceMutable () {
    set_has_FuelPrice();
    return _FuelPrice;
}

inline void T_FuelInfo::setFuelPrice (const ::std::string& FuelPrice_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelPrice_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelPrice();
    this->_FuelPrice = FuelPrice_;
}

inline void T_FuelInfo::setFuelPrice (const char* FuelPrice_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelPrice_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelPrice();
    this->_FuelPrice.assign(FuelPrice_);
}

inline void T_FuelInfo::setFuelPrice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelPrice();
    this->_FuelPrice.assign(value, size);
}

inline void T_FuelInfo::clearFuelAge() {
    if (hasFuelAge()) {
         clear_has_FuelAge();
        _FuelAge = 0u;
     }
}

inline bool T_FuelInfo::hasFuelAge () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_FuelInfo::getFuelAge () const {
    return _FuelAge;
}

inline void T_FuelInfo::setFuelAge (uint8 FuelAge_) {
    set_has_FuelAge();
    this->_FuelAge = FuelAge_;
}

inline void T_FuelInfo::clearFuelLoc() {
    if (hasFuelLoc()) {
         clear_has_FuelLoc();
        _FuelLoc.clear();
     }
}

inline bool T_FuelInfo::hasFuelLoc () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmLocation& T_FuelInfo::getFuelLoc () const {
    return _FuelLoc;
}

inline ::sxm_main_fi_types::T_SxmLocation& T_FuelInfo::getFuelLocMutable () {
    set_has_FuelLoc();
    return _FuelLoc;
}

inline void T_FuelInfo::setFuelLoc (const ::sxm_main_fi_types::T_SxmLocation& FuelLoc_) {
    set_has_FuelLoc();
    this->_FuelLoc = FuelLoc_;
}

inline void T_FuelInfo::clearFuelDistKm() {
    if (hasFuelDistKm()) {
         clear_has_FuelDistKm();
        _FuelDistKm = 0.0f;
     }
}

inline bool T_FuelInfo::hasFuelDistKm () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline float T_FuelInfo::getFuelDistKm () const {
    return _FuelDistKm;
}

inline void T_FuelInfo::setFuelDistKm (float FuelDistKm_) {
    set_has_FuelDistKm();
    this->_FuelDistKm = FuelDistKm_;
}

inline void T_FuelInfo::clearFuelDistMile() {
    if (hasFuelDistMile()) {
         clear_has_FuelDistMile();
        _FuelDistMile = 0.0f;
     }
}

inline bool T_FuelInfo::hasFuelDistMile () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline float T_FuelInfo::getFuelDistMile () const {
    return _FuelDistMile;
}

inline void T_FuelInfo::setFuelDistMile (float FuelDistMile_) {
    set_has_FuelDistMile();
    this->_FuelDistMile = FuelDistMile_;
}

inline void T_FuelInfo::clearNumPrices() {
    if (hasNumPrices()) {
         clear_has_NumPrices();
        _NumPrices = 0u;
     }
}

inline bool T_FuelInfo::hasNumPrices () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint32 T_FuelInfo::getNumPrices () const {
    return _NumPrices;
}

inline void T_FuelInfo::setNumPrices (uint32 NumPrices_) {
    set_has_NumPrices();
    this->_NumPrices = NumPrices_;
}

inline void T_FuelInfo::set_has_StationName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FuelInfo::clear_has_StationName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FuelInfo::set_has_Brand () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FuelInfo::clear_has_Brand () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_FuelInfo::set_has_FuelType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_FuelInfo::clear_has_FuelType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_FuelInfo::set_has_Fuel_LOCID () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_FuelInfo::clear_has_Fuel_LOCID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_FuelInfo::set_has_FuelName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_FuelInfo::clear_has_FuelName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_FuelInfo::set_has_FuelPrice () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_FuelInfo::clear_has_FuelPrice () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_FuelInfo::set_has_FuelAge () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_FuelInfo::clear_has_FuelAge () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_FuelInfo::set_has_FuelLoc () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_FuelInfo::clear_has_FuelLoc () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_FuelInfo::set_has_FuelDistKm () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_FuelInfo::clear_has_FuelDistKm () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_FuelInfo::set_has_FuelDistMile () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_FuelInfo::clear_has_FuelDistMile () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_FuelInfo::set_has_NumPrices () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_FuelInfo::clear_has_NumPrices () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline  T_FuelTypeInfo::T_FuelTypeInfo ()  :
    _FuelType (::sxm_fuel_main_fi_types::T_e8_FuelTypeEnum__FUEL_TYPE_REGULAR),
    _FuelName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FuelTypeInfo::T_FuelTypeInfo (const T_FuelTypeInfo &rhs)  :
    _FuelType (::sxm_fuel_main_fi_types::T_e8_FuelTypeEnum__FUEL_TYPE_REGULAR),
    _FuelName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FuelTypeInfo::T_FuelTypeInfo (T_e8_FuelTypeEnum FuelType_, const ::std::string& FuelName_)  :
    _FuelType (FuelType_),
    _FuelName (FuelName_)
{
    #ifndef NDEBUG
    if (!(T_e8_FuelTypeEnum_IsValid(FuelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FuelType_, "T_e8_FuelTypeEnum", "FuelType", "T_FuelTypeInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FuelTypeInfo::~T_FuelTypeInfo() {
}

inline T_FuelTypeInfo& T_FuelTypeInfo::operator = (const T_FuelTypeInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasFuelType()) {
            setFuelType(rhs.getFuelType());
        } else {
            clearFuelType();
        }
        if (rhs.hasFuelName()) {
            setFuelName(rhs.getFuelName());
        } else {
            clearFuelName();
        }
    }
    return *this;
}

inline bool T_FuelTypeInfo::operator == (const T_FuelTypeInfo& rhs) const {
    return (((!hasFuelType() && !rhs.hasFuelType()) || getFuelType() == rhs.getFuelType()) &&
        ((!hasFuelName() && !rhs.hasFuelName()) || getFuelName() == rhs.getFuelName()));
}

inline bool T_FuelTypeInfo::operator != (const T_FuelTypeInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FuelTypeInfo::operator < (const T_FuelTypeInfo& rhs) const {
    if (hasFuelType() || rhs.hasFuelType()) {
        if ((uint32)getFuelType() < (uint32)rhs.getFuelType()) return true;
        if ((uint32)getFuelType() > (uint32)rhs.getFuelType()) return false;
    }
    if (hasFuelName() || rhs.hasFuelName()) {
        if (getFuelName() < rhs.getFuelName()) return true;
        if (getFuelName() > rhs.getFuelName()) return false;
    }
    return false;
}

inline bool T_FuelTypeInfo::operator > (const T_FuelTypeInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FuelTypeInfo::clear() {
    clearFuelType();
    clearFuelName();
}

inline void T_FuelTypeInfo::clearFuelType() {
    if (hasFuelType()) {
         clear_has_FuelType();
        _FuelType = ::sxm_fuel_main_fi_types::T_e8_FuelTypeEnum__FUEL_TYPE_REGULAR;
     }
}

inline bool T_FuelTypeInfo::hasFuelType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_FuelTypeEnum T_FuelTypeInfo::getFuelType () const {
    return _FuelType;
}

inline void T_FuelTypeInfo::setFuelType (T_e8_FuelTypeEnum FuelType_) {
    #ifndef NDEBUG
    if (!(T_e8_FuelTypeEnum_IsValid(FuelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FuelType_, "T_e8_FuelTypeEnum", "FuelType", "T_FuelTypeInfo");
    }
    #endif
    set_has_FuelType();
    this->_FuelType = FuelType_;
}

inline void T_FuelTypeInfo::clearFuelName() {
    if (hasFuelName()) {
         clear_has_FuelName();
        _FuelName.clear();
     }
}

inline bool T_FuelTypeInfo::hasFuelName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_FuelTypeInfo::getFuelName () const {
    return _FuelName;
}

inline ::std::string& T_FuelTypeInfo::getFuelNameMutable () {
    set_has_FuelName();
    return _FuelName;
}

inline void T_FuelTypeInfo::setFuelName (const ::std::string& FuelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelName();
    this->_FuelName = FuelName_;
}

inline void T_FuelTypeInfo::setFuelName (const char* FuelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelName();
    this->_FuelName.assign(FuelName_);
}

inline void T_FuelTypeInfo::setFuelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelName();
    this->_FuelName.assign(value, size);
}

inline void T_FuelTypeInfo::set_has_FuelType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FuelTypeInfo::clear_has_FuelType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FuelTypeInfo::set_has_FuelName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FuelTypeInfo::clear_has_FuelName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_FuelTypeInfolist::T_FuelTypeInfolist ()  :
    _FuelName (),
    _FuelPrice (),
    _FuelAge (0u),
    _FuelAvail (false),
    _FuelType (::sxm_fuel_main_fi_types::T_e8_FuelTypeEnum__FUEL_TYPE_REGULAR)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FuelTypeInfolist::T_FuelTypeInfolist (const T_FuelTypeInfolist &rhs)  :
    _FuelName (),
    _FuelPrice (),
    _FuelAge (0u),
    _FuelAvail (false),
    _FuelType (::sxm_fuel_main_fi_types::T_e8_FuelTypeEnum__FUEL_TYPE_REGULAR)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FuelTypeInfolist::T_FuelTypeInfolist (const ::std::string& FuelName_, const ::std::string& FuelPrice_, uint8 FuelAge_, bool FuelAvail_, T_e8_FuelTypeEnum FuelType_)  :
    _FuelName (FuelName_),
    _FuelPrice (FuelPrice_),
    _FuelAge (FuelAge_),
    _FuelAvail (FuelAvail_),
    _FuelType (FuelType_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelPrice_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_FuelTypeEnum_IsValid(FuelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FuelType_, "T_e8_FuelTypeEnum", "FuelType", "T_FuelTypeInfolist");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FuelTypeInfolist::~T_FuelTypeInfolist() {
}

inline T_FuelTypeInfolist& T_FuelTypeInfolist::operator = (const T_FuelTypeInfolist& rhs) {
    if( this != &rhs ) {
        if (rhs.hasFuelName()) {
            setFuelName(rhs.getFuelName());
        } else {
            clearFuelName();
        }
        if (rhs.hasFuelPrice()) {
            setFuelPrice(rhs.getFuelPrice());
        } else {
            clearFuelPrice();
        }
        if (rhs.hasFuelAge()) {
            setFuelAge(rhs.getFuelAge());
        } else {
            clearFuelAge();
        }
        if (rhs.hasFuelAvail()) {
            setFuelAvail(rhs.getFuelAvail());
        } else {
            clearFuelAvail();
        }
        if (rhs.hasFuelType()) {
            setFuelType(rhs.getFuelType());
        } else {
            clearFuelType();
        }
    }
    return *this;
}

inline bool T_FuelTypeInfolist::operator == (const T_FuelTypeInfolist& rhs) const {
    return (((!hasFuelName() && !rhs.hasFuelName()) || getFuelName() == rhs.getFuelName()) &&
        ((!hasFuelPrice() && !rhs.hasFuelPrice()) || getFuelPrice() == rhs.getFuelPrice()) &&
        ((!hasFuelAge() && !rhs.hasFuelAge()) || getFuelAge() == rhs.getFuelAge()) &&
        ((!hasFuelAvail() && !rhs.hasFuelAvail()) || getFuelAvail() == rhs.getFuelAvail()) &&
        ((!hasFuelType() && !rhs.hasFuelType()) || getFuelType() == rhs.getFuelType()));
}

inline bool T_FuelTypeInfolist::operator != (const T_FuelTypeInfolist& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FuelTypeInfolist::operator < (const T_FuelTypeInfolist& rhs) const {
    if (hasFuelName() || rhs.hasFuelName()) {
        if (getFuelName() < rhs.getFuelName()) return true;
        if (getFuelName() > rhs.getFuelName()) return false;
    }
    if (hasFuelPrice() || rhs.hasFuelPrice()) {
        if (getFuelPrice() < rhs.getFuelPrice()) return true;
        if (getFuelPrice() > rhs.getFuelPrice()) return false;
    }
    if (hasFuelAge() || rhs.hasFuelAge()) {
        if (getFuelAge() < rhs.getFuelAge()) return true;
        if (getFuelAge() > rhs.getFuelAge()) return false;
    }
    if (hasFuelAvail() || rhs.hasFuelAvail()) {
        if (getFuelAvail() < rhs.getFuelAvail()) return true;
        if (getFuelAvail() > rhs.getFuelAvail()) return false;
    }
    if (hasFuelType() || rhs.hasFuelType()) {
        if ((uint32)getFuelType() < (uint32)rhs.getFuelType()) return true;
        if ((uint32)getFuelType() > (uint32)rhs.getFuelType()) return false;
    }
    return false;
}

inline bool T_FuelTypeInfolist::operator > (const T_FuelTypeInfolist& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FuelTypeInfolist::clear() {
    clearFuelName();
    clearFuelPrice();
    clearFuelAge();
    clearFuelAvail();
    clearFuelType();
}

inline void T_FuelTypeInfolist::clearFuelName() {
    if (hasFuelName()) {
         clear_has_FuelName();
        _FuelName.clear();
     }
}

inline bool T_FuelTypeInfolist::hasFuelName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_FuelTypeInfolist::getFuelName () const {
    return _FuelName;
}

inline ::std::string& T_FuelTypeInfolist::getFuelNameMutable () {
    set_has_FuelName();
    return _FuelName;
}

inline void T_FuelTypeInfolist::setFuelName (const ::std::string& FuelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelName();
    this->_FuelName = FuelName_;
}

inline void T_FuelTypeInfolist::setFuelName (const char* FuelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelName();
    this->_FuelName.assign(FuelName_);
}

inline void T_FuelTypeInfolist::setFuelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelName();
    this->_FuelName.assign(value, size);
}

inline void T_FuelTypeInfolist::clearFuelPrice() {
    if (hasFuelPrice()) {
         clear_has_FuelPrice();
        _FuelPrice.clear();
     }
}

inline bool T_FuelTypeInfolist::hasFuelPrice () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_FuelTypeInfolist::getFuelPrice () const {
    return _FuelPrice;
}

inline ::std::string& T_FuelTypeInfolist::getFuelPriceMutable () {
    set_has_FuelPrice();
    return _FuelPrice;
}

inline void T_FuelTypeInfolist::setFuelPrice (const ::std::string& FuelPrice_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelPrice_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelPrice();
    this->_FuelPrice = FuelPrice_;
}

inline void T_FuelTypeInfolist::setFuelPrice (const char* FuelPrice_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelPrice_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelPrice();
    this->_FuelPrice.assign(FuelPrice_);
}

inline void T_FuelTypeInfolist::setFuelPrice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelPrice();
    this->_FuelPrice.assign(value, size);
}

inline void T_FuelTypeInfolist::clearFuelAge() {
    if (hasFuelAge()) {
         clear_has_FuelAge();
        _FuelAge = 0u;
     }
}

inline bool T_FuelTypeInfolist::hasFuelAge () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_FuelTypeInfolist::getFuelAge () const {
    return _FuelAge;
}

inline void T_FuelTypeInfolist::setFuelAge (uint8 FuelAge_) {
    set_has_FuelAge();
    this->_FuelAge = FuelAge_;
}

inline void T_FuelTypeInfolist::clearFuelAvail() {
    if (hasFuelAvail()) {
         clear_has_FuelAvail();
        _FuelAvail = false;
     }
}

inline bool T_FuelTypeInfolist::hasFuelAvail () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_FuelTypeInfolist::getFuelAvail () const {
    return _FuelAvail;
}

inline void T_FuelTypeInfolist::setFuelAvail (bool FuelAvail_) {
    set_has_FuelAvail();
    this->_FuelAvail = FuelAvail_;
}

inline void T_FuelTypeInfolist::clearFuelType() {
    if (hasFuelType()) {
         clear_has_FuelType();
        _FuelType = ::sxm_fuel_main_fi_types::T_e8_FuelTypeEnum__FUEL_TYPE_REGULAR;
     }
}

inline bool T_FuelTypeInfolist::hasFuelType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_FuelTypeEnum T_FuelTypeInfolist::getFuelType () const {
    return _FuelType;
}

inline void T_FuelTypeInfolist::setFuelType (T_e8_FuelTypeEnum FuelType_) {
    #ifndef NDEBUG
    if (!(T_e8_FuelTypeEnum_IsValid(FuelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FuelType_, "T_e8_FuelTypeEnum", "FuelType", "T_FuelTypeInfolist");
    }
    #endif
    set_has_FuelType();
    this->_FuelType = FuelType_;
}

inline void T_FuelTypeInfolist::set_has_FuelName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FuelTypeInfolist::clear_has_FuelName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FuelTypeInfolist::set_has_FuelPrice () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FuelTypeInfolist::clear_has_FuelPrice () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_FuelTypeInfolist::set_has_FuelAge () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_FuelTypeInfolist::clear_has_FuelAge () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_FuelTypeInfolist::set_has_FuelAvail () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_FuelTypeInfolist::clear_has_FuelAvail () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_FuelTypeInfolist::set_has_FuelType () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_FuelTypeInfolist::clear_has_FuelType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_FuelStationInfo::T_FuelStationInfo ()  :
    _StationName (),
    _Brand (),
    _StreetName (),
    _City (),
    _State (),
    _ZipCode (),
    _Phone (),
    _Fuel_LOCID (0u),
    _Amenity (),
    _FuelFavInfo (false),
    _FuelLocation (),
    _FuelTypelist (),
    _StationAmenitylist (),
    _NumPrices (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FuelStationInfo::T_FuelStationInfo (const T_FuelStationInfo &rhs)  :
    _StationName (),
    _Brand (),
    _StreetName (),
    _City (),
    _State (),
    _ZipCode (),
    _Phone (),
    _Fuel_LOCID (0u),
    _Amenity (),
    _FuelFavInfo (false),
    _FuelLocation (),
    _FuelTypelist (),
    _StationAmenitylist (),
    _NumPrices (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FuelStationInfo::T_FuelStationInfo (const ::std::string& StationName_, const ::std::string& Brand_, const ::std::string& StreetName_, const ::std::string& City_, const ::std::string& State_, const ::std::string& ZipCode_, const ::std::string& Phone_, uint32 Fuel_LOCID_, const ::std::string& Amenity_, bool FuelFavInfo_, const ::sxm_main_fi_types::T_SxmLocation& FuelLocation_, const ::std::vector< T_FuelTypeInfolist >& FuelTypelist_, const ::std::vector< T_e8_FuelStationAmenity >& StationAmenitylist_, uint32 NumPrices_)  :
    _StationName (StationName_),
    _Brand (Brand_),
    _StreetName (StreetName_),
    _City (City_),
    _State (State_),
    _ZipCode (ZipCode_),
    _Phone (Phone_),
    _Fuel_LOCID (Fuel_LOCID_),
    _Amenity (Amenity_),
    _FuelFavInfo (FuelFavInfo_),
    _FuelLocation (FuelLocation_),
    _FuelTypelist (FuelTypelist_),
    _StationAmenitylist (StationAmenitylist_),
    _NumPrices (NumPrices_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StreetName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (City_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ZipCode_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phone_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Amenity_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FuelStationInfo::~T_FuelStationInfo() {
}

inline T_FuelStationInfo& T_FuelStationInfo::operator = (const T_FuelStationInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStationName()) {
            setStationName(rhs.getStationName());
        } else {
            clearStationName();
        }
        if (rhs.hasBrand()) {
            setBrand(rhs.getBrand());
        } else {
            clearBrand();
        }
        if (rhs.hasStreetName()) {
            setStreetName(rhs.getStreetName());
        } else {
            clearStreetName();
        }
        if (rhs.hasCity()) {
            setCity(rhs.getCity());
        } else {
            clearCity();
        }
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
        if (rhs.hasZipCode()) {
            setZipCode(rhs.getZipCode());
        } else {
            clearZipCode();
        }
        if (rhs.hasPhone()) {
            setPhone(rhs.getPhone());
        } else {
            clearPhone();
        }
        if (rhs.hasFuel_LOCID()) {
            setFuel_LOCID(rhs.getFuel_LOCID());
        } else {
            clearFuel_LOCID();
        }
        if (rhs.hasAmenity()) {
            setAmenity(rhs.getAmenity());
        } else {
            clearAmenity();
        }
        if (rhs.hasFuelFavInfo()) {
            setFuelFavInfo(rhs.getFuelFavInfo());
        } else {
            clearFuelFavInfo();
        }
        if (rhs.hasFuelLocation()) {
            setFuelLocation(rhs.getFuelLocation());
        } else {
            clearFuelLocation();
        }
        if (rhs.hasFuelTypelist()) {
            setFuelTypelist(rhs.getFuelTypelist());
        } else {
            clearFuelTypelist();
        }
        if (rhs.hasStationAmenitylist()) {
            setStationAmenitylist(rhs.getStationAmenitylist());
        } else {
            clearStationAmenitylist();
        }
        if (rhs.hasNumPrices()) {
            setNumPrices(rhs.getNumPrices());
        } else {
            clearNumPrices();
        }
    }
    return *this;
}

inline bool T_FuelStationInfo::operator == (const T_FuelStationInfo& rhs) const {
    return (((!hasStationName() && !rhs.hasStationName()) || getStationName() == rhs.getStationName()) &&
        ((!hasBrand() && !rhs.hasBrand()) || getBrand() == rhs.getBrand()) &&
        ((!hasStreetName() && !rhs.hasStreetName()) || getStreetName() == rhs.getStreetName()) &&
        ((!hasCity() && !rhs.hasCity()) || getCity() == rhs.getCity()) &&
        ((!hasState() && !rhs.hasState()) || getState() == rhs.getState()) &&
        ((!hasZipCode() && !rhs.hasZipCode()) || getZipCode() == rhs.getZipCode()) &&
        ((!hasPhone() && !rhs.hasPhone()) || getPhone() == rhs.getPhone()) &&
        ((!hasFuel_LOCID() && !rhs.hasFuel_LOCID()) || getFuel_LOCID() == rhs.getFuel_LOCID()) &&
        ((!hasAmenity() && !rhs.hasAmenity()) || getAmenity() == rhs.getAmenity()) &&
        ((!hasFuelFavInfo() && !rhs.hasFuelFavInfo()) || getFuelFavInfo() == rhs.getFuelFavInfo()) &&
        ((!hasFuelLocation() && !rhs.hasFuelLocation()) || getFuelLocation() == rhs.getFuelLocation()) &&
        ((!hasFuelTypelist() && !rhs.hasFuelTypelist()) || getFuelTypelist() == rhs.getFuelTypelist()) &&
        ((!hasStationAmenitylist() && !rhs.hasStationAmenitylist()) || getStationAmenitylist() == rhs.getStationAmenitylist()) &&
        ((!hasNumPrices() && !rhs.hasNumPrices()) || getNumPrices() == rhs.getNumPrices()));
}

inline bool T_FuelStationInfo::operator != (const T_FuelStationInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FuelStationInfo::operator < (const T_FuelStationInfo& rhs) const {
    if (hasStationName() || rhs.hasStationName()) {
        if (getStationName() < rhs.getStationName()) return true;
        if (getStationName() > rhs.getStationName()) return false;
    }
    if (hasBrand() || rhs.hasBrand()) {
        if (getBrand() < rhs.getBrand()) return true;
        if (getBrand() > rhs.getBrand()) return false;
    }
    if (hasStreetName() || rhs.hasStreetName()) {
        if (getStreetName() < rhs.getStreetName()) return true;
        if (getStreetName() > rhs.getStreetName()) return false;
    }
    if (hasCity() || rhs.hasCity()) {
        if (getCity() < rhs.getCity()) return true;
        if (getCity() > rhs.getCity()) return false;
    }
    if (hasState() || rhs.hasState()) {
        if (getState() < rhs.getState()) return true;
        if (getState() > rhs.getState()) return false;
    }
    if (hasZipCode() || rhs.hasZipCode()) {
        if (getZipCode() < rhs.getZipCode()) return true;
        if (getZipCode() > rhs.getZipCode()) return false;
    }
    if (hasPhone() || rhs.hasPhone()) {
        if (getPhone() < rhs.getPhone()) return true;
        if (getPhone() > rhs.getPhone()) return false;
    }
    if (hasFuel_LOCID() || rhs.hasFuel_LOCID()) {
        if (getFuel_LOCID() < rhs.getFuel_LOCID()) return true;
        if (getFuel_LOCID() > rhs.getFuel_LOCID()) return false;
    }
    if (hasAmenity() || rhs.hasAmenity()) {
        if (getAmenity() < rhs.getAmenity()) return true;
        if (getAmenity() > rhs.getAmenity()) return false;
    }
    if (hasFuelFavInfo() || rhs.hasFuelFavInfo()) {
        if (getFuelFavInfo() < rhs.getFuelFavInfo()) return true;
        if (getFuelFavInfo() > rhs.getFuelFavInfo()) return false;
    }
    if (hasFuelLocation() || rhs.hasFuelLocation()) {
        if (getFuelLocation() < rhs.getFuelLocation()) return true;
        if (getFuelLocation() > rhs.getFuelLocation()) return false;
    }
    if (hasFuelTypelist() || rhs.hasFuelTypelist()) {
        if (getFuelTypelist() < rhs.getFuelTypelist()) return true;
        if (getFuelTypelist() > rhs.getFuelTypelist()) return false;
    }
    if (hasStationAmenitylist() || rhs.hasStationAmenitylist()) {
        if (getStationAmenitylist() < rhs.getStationAmenitylist()) return true;
        if (getStationAmenitylist() > rhs.getStationAmenitylist()) return false;
    }
    if (hasNumPrices() || rhs.hasNumPrices()) {
        if (getNumPrices() < rhs.getNumPrices()) return true;
        if (getNumPrices() > rhs.getNumPrices()) return false;
    }
    return false;
}

inline bool T_FuelStationInfo::operator > (const T_FuelStationInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FuelStationInfo::clear() {
    clearStationName();
    clearBrand();
    clearStreetName();
    clearCity();
    clearState();
    clearZipCode();
    clearPhone();
    clearFuel_LOCID();
    clearAmenity();
    clearFuelFavInfo();
    clearFuelLocation();
    clearFuelTypelist();
    clearStationAmenitylist();
    clearNumPrices();
}

inline void T_FuelStationInfo::clearStationName() {
    if (hasStationName()) {
         clear_has_StationName();
        _StationName.clear();
     }
}

inline bool T_FuelStationInfo::hasStationName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_FuelStationInfo::getStationName () const {
    return _StationName;
}

inline ::std::string& T_FuelStationInfo::getStationNameMutable () {
    set_has_StationName();
    return _StationName;
}

inline void T_FuelStationInfo::setStationName (const ::std::string& StationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationName();
    this->_StationName = StationName_;
}

inline void T_FuelStationInfo::setStationName (const char* StationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationName();
    this->_StationName.assign(StationName_);
}

inline void T_FuelStationInfo::setStationName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationName();
    this->_StationName.assign(value, size);
}

inline void T_FuelStationInfo::clearBrand() {
    if (hasBrand()) {
         clear_has_Brand();
        _Brand.clear();
     }
}

inline bool T_FuelStationInfo::hasBrand () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_FuelStationInfo::getBrand () const {
    return _Brand;
}

inline ::std::string& T_FuelStationInfo::getBrandMutable () {
    set_has_Brand();
    return _Brand;
}

inline void T_FuelStationInfo::setBrand (const ::std::string& Brand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand = Brand_;
}

inline void T_FuelStationInfo::setBrand (const char* Brand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand.assign(Brand_);
}

inline void T_FuelStationInfo::setBrand (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand.assign(value, size);
}

inline void T_FuelStationInfo::clearStreetName() {
    if (hasStreetName()) {
         clear_has_StreetName();
        _StreetName.clear();
     }
}

inline bool T_FuelStationInfo::hasStreetName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_FuelStationInfo::getStreetName () const {
    return _StreetName;
}

inline ::std::string& T_FuelStationInfo::getStreetNameMutable () {
    set_has_StreetName();
    return _StreetName;
}

inline void T_FuelStationInfo::setStreetName (const ::std::string& StreetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StreetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StreetName();
    this->_StreetName = StreetName_;
}

inline void T_FuelStationInfo::setStreetName (const char* StreetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StreetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StreetName();
    this->_StreetName.assign(StreetName_);
}

inline void T_FuelStationInfo::setStreetName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StreetName();
    this->_StreetName.assign(value, size);
}

inline void T_FuelStationInfo::clearCity() {
    if (hasCity()) {
         clear_has_City();
        _City.clear();
     }
}

inline bool T_FuelStationInfo::hasCity () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_FuelStationInfo::getCity () const {
    return _City;
}

inline ::std::string& T_FuelStationInfo::getCityMutable () {
    set_has_City();
    return _City;
}

inline void T_FuelStationInfo::setCity (const ::std::string& City_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (City_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_City();
    this->_City = City_;
}

inline void T_FuelStationInfo::setCity (const char* City_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (City_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_City();
    this->_City.assign(City_);
}

inline void T_FuelStationInfo::setCity (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_City();
    this->_City.assign(value, size);
}

inline void T_FuelStationInfo::clearState() {
    if (hasState()) {
         clear_has_State();
        _State.clear();
     }
}

inline bool T_FuelStationInfo::hasState () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_FuelStationInfo::getState () const {
    return _State;
}

inline ::std::string& T_FuelStationInfo::getStateMutable () {
    set_has_State();
    return _State;
}

inline void T_FuelStationInfo::setState (const ::std::string& State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State = State_;
}

inline void T_FuelStationInfo::setState (const char* State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(State_);
}

inline void T_FuelStationInfo::setState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(value, size);
}

inline void T_FuelStationInfo::clearZipCode() {
    if (hasZipCode()) {
         clear_has_ZipCode();
        _ZipCode.clear();
     }
}

inline bool T_FuelStationInfo::hasZipCode () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_FuelStationInfo::getZipCode () const {
    return _ZipCode;
}

inline ::std::string& T_FuelStationInfo::getZipCodeMutable () {
    set_has_ZipCode();
    return _ZipCode;
}

inline void T_FuelStationInfo::setZipCode (const ::std::string& ZipCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ZipCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ZipCode();
    this->_ZipCode = ZipCode_;
}

inline void T_FuelStationInfo::setZipCode (const char* ZipCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ZipCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ZipCode();
    this->_ZipCode.assign(ZipCode_);
}

inline void T_FuelStationInfo::setZipCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ZipCode();
    this->_ZipCode.assign(value, size);
}

inline void T_FuelStationInfo::clearPhone() {
    if (hasPhone()) {
         clear_has_Phone();
        _Phone.clear();
     }
}

inline bool T_FuelStationInfo::hasPhone () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_FuelStationInfo::getPhone () const {
    return _Phone;
}

inline ::std::string& T_FuelStationInfo::getPhoneMutable () {
    set_has_Phone();
    return _Phone;
}

inline void T_FuelStationInfo::setPhone (const ::std::string& Phone_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phone_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phone();
    this->_Phone = Phone_;
}

inline void T_FuelStationInfo::setPhone (const char* Phone_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phone_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phone();
    this->_Phone.assign(Phone_);
}

inline void T_FuelStationInfo::setPhone (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phone();
    this->_Phone.assign(value, size);
}

inline void T_FuelStationInfo::clearFuel_LOCID() {
    if (hasFuel_LOCID()) {
         clear_has_Fuel_LOCID();
        _Fuel_LOCID = 0u;
     }
}

inline bool T_FuelStationInfo::hasFuel_LOCID () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 T_FuelStationInfo::getFuel_LOCID () const {
    return _Fuel_LOCID;
}

inline void T_FuelStationInfo::setFuel_LOCID (uint32 Fuel_LOCID_) {
    set_has_Fuel_LOCID();
    this->_Fuel_LOCID = Fuel_LOCID_;
}

inline void T_FuelStationInfo::clearAmenity() {
    if (hasAmenity()) {
         clear_has_Amenity();
        _Amenity.clear();
     }
}

inline bool T_FuelStationInfo::hasAmenity () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_FuelStationInfo::getAmenity () const {
    return _Amenity;
}

inline ::std::string& T_FuelStationInfo::getAmenityMutable () {
    set_has_Amenity();
    return _Amenity;
}

inline void T_FuelStationInfo::setAmenity (const ::std::string& Amenity_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Amenity_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Amenity();
    this->_Amenity = Amenity_;
}

inline void T_FuelStationInfo::setAmenity (const char* Amenity_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Amenity_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Amenity();
    this->_Amenity.assign(Amenity_);
}

inline void T_FuelStationInfo::setAmenity (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Amenity();
    this->_Amenity.assign(value, size);
}

inline void T_FuelStationInfo::clearFuelFavInfo() {
    if (hasFuelFavInfo()) {
         clear_has_FuelFavInfo();
        _FuelFavInfo = false;
     }
}

inline bool T_FuelStationInfo::hasFuelFavInfo () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool T_FuelStationInfo::getFuelFavInfo () const {
    return _FuelFavInfo;
}

inline void T_FuelStationInfo::setFuelFavInfo (bool FuelFavInfo_) {
    set_has_FuelFavInfo();
    this->_FuelFavInfo = FuelFavInfo_;
}

inline void T_FuelStationInfo::clearFuelLocation() {
    if (hasFuelLocation()) {
         clear_has_FuelLocation();
        _FuelLocation.clear();
     }
}

inline bool T_FuelStationInfo::hasFuelLocation () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmLocation& T_FuelStationInfo::getFuelLocation () const {
    return _FuelLocation;
}

inline ::sxm_main_fi_types::T_SxmLocation& T_FuelStationInfo::getFuelLocationMutable () {
    set_has_FuelLocation();
    return _FuelLocation;
}

inline void T_FuelStationInfo::setFuelLocation (const ::sxm_main_fi_types::T_SxmLocation& FuelLocation_) {
    set_has_FuelLocation();
    this->_FuelLocation = FuelLocation_;
}

inline void T_FuelStationInfo::clearFuelTypelist() {
    if (hasFuelTypelist()) {
         clear_has_FuelTypelist();
        _FuelTypelist.clear();
     }
}

inline bool T_FuelStationInfo::hasFuelTypelist () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::vector< T_FuelTypeInfolist >& T_FuelStationInfo::getFuelTypelist () const {
    return _FuelTypelist;
}

inline ::std::vector< T_FuelTypeInfolist >& T_FuelStationInfo::getFuelTypelistMutable () {
    set_has_FuelTypelist();
    return _FuelTypelist;
}

inline void T_FuelStationInfo::setFuelTypelist (const ::std::vector< T_FuelTypeInfolist >& FuelTypelist_) {
    set_has_FuelTypelist();
    this->_FuelTypelist = FuelTypelist_;
}

inline void T_FuelStationInfo::clearStationAmenitylist() {
    if (hasStationAmenitylist()) {
         clear_has_StationAmenitylist();
        _StationAmenitylist.clear();
     }
}

inline bool T_FuelStationInfo::hasStationAmenitylist () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::vector< T_e8_FuelStationAmenity >& T_FuelStationInfo::getStationAmenitylist () const {
    return _StationAmenitylist;
}

inline ::std::vector< T_e8_FuelStationAmenity >& T_FuelStationInfo::getStationAmenitylistMutable () {
    set_has_StationAmenitylist();
    return _StationAmenitylist;
}

inline void T_FuelStationInfo::setStationAmenitylist (const ::std::vector< T_e8_FuelStationAmenity >& StationAmenitylist_) {
    set_has_StationAmenitylist();
    this->_StationAmenitylist = StationAmenitylist_;
}

inline void T_FuelStationInfo::clearNumPrices() {
    if (hasNumPrices()) {
         clear_has_NumPrices();
        _NumPrices = 0u;
     }
}

inline bool T_FuelStationInfo::hasNumPrices () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint32 T_FuelStationInfo::getNumPrices () const {
    return _NumPrices;
}

inline void T_FuelStationInfo::setNumPrices (uint32 NumPrices_) {
    set_has_NumPrices();
    this->_NumPrices = NumPrices_;
}

inline void T_FuelStationInfo::set_has_StationName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FuelStationInfo::clear_has_StationName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FuelStationInfo::set_has_Brand () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FuelStationInfo::clear_has_Brand () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_FuelStationInfo::set_has_StreetName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_FuelStationInfo::clear_has_StreetName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_FuelStationInfo::set_has_City () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_FuelStationInfo::clear_has_City () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_FuelStationInfo::set_has_State () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_FuelStationInfo::clear_has_State () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_FuelStationInfo::set_has_ZipCode () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_FuelStationInfo::clear_has_ZipCode () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_FuelStationInfo::set_has_Phone () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_FuelStationInfo::clear_has_Phone () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_FuelStationInfo::set_has_Fuel_LOCID () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_FuelStationInfo::clear_has_Fuel_LOCID () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_FuelStationInfo::set_has_Amenity () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_FuelStationInfo::clear_has_Amenity () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_FuelStationInfo::set_has_FuelFavInfo () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_FuelStationInfo::clear_has_FuelFavInfo () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_FuelStationInfo::set_has_FuelLocation () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_FuelStationInfo::clear_has_FuelLocation () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_FuelStationInfo::set_has_FuelTypelist () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_FuelStationInfo::clear_has_FuelTypelist () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_FuelStationInfo::set_has_StationAmenitylist () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_FuelStationInfo::clear_has_StationAmenitylist () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_FuelStationInfo::set_has_NumPrices () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_FuelStationInfo::clear_has_NumPrices () {
    _has_bits_[0] &= ~ (1u << 13);
}

} // namespace sxm_fuel_main_fi_types

#endif // SXM_FUEL_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
