#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_CHANNELART_MAIN_FI_TYPES_H
#define SXM_CHANNELART_MAIN_FI_TYPES_H

#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include <cstring>
#include <vector>

/**
 * Types sxm_channelart_main_fi_types
 */

namespace sxm_channelart_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_ImageData;


/**
 * List of channel art images
 */
class T_ImageData {
public:

    /**
     * Default constructor
     */
    inline  T_ImageData ();

    /**
     * Copy constructor
     */
    inline  T_ImageData (const T_ImageData &rhs);

    /**
     * All fields constructor
     */
    inline  T_ImageData (uint16 SID_, const ::std::vector< uint8 >& ImageData_, uint32 ImageDataSize_);

    /**
     * Destructor
     */
    inline  ~T_ImageData();

    /**
     * Assignment operator
     */
    inline T_ImageData& operator = (const T_ImageData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ImageData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ImageData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ImageData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ImageData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SID"

    static const int kSID = 0;

    /**
     * Clears the field "SID".
     *
     * The field will be set to its default value. The hasSID()
     * method will return false.
     */
    inline void clearSID();

    /**
     * Checks whether the field "SID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSID()). Otherwise it will return false.
     */
    inline bool hasSID () const;

    /**
     * Returns the value of the member "SID".
     *
     * ServiceIdentifier
     *
     * @return The value of the field "SID"
     */
    inline uint16 getSID () const;

    /**
     * Sets the value of the member "SID".
     *
     * ServiceIdentifier
     *
     * @param SID The value which will be set
     */
    inline void setSID (uint16 SID_);

    // API of field "ImageData"

    static const int kImageData = 1;

    /**
     * Clears the field "ImageData".
     *
     * The field will be set to its default value. The hasImageData()
     * method will return false.
     */
    inline void clearImageData();

    /**
     * Checks whether the field "ImageData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageData()). Otherwise it will return false.
     */
    inline bool hasImageData () const;

    /**
     * Returns the value of the member "ImageData".
     *
     * List of image data.
     *
     * @return The value of the field "ImageData"
     */
    inline const ::std::vector< uint8 >& getImageData () const;

    /**
     * Retrieves the value of the field "ImageData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ImageData".
     */
    inline ::std::vector< uint8 >& getImageDataMutable ();

    /**
     * Sets the value of the member "ImageData".
     *
     * List of image data.
     *
     * @param ImageData The value which will be set
     */
    inline void setImageData (const ::std::vector< uint8 >& ImageData_);

    // API of field "ImageDataSize"

    static const int kImageDataSize = 2;

    /**
     * Clears the field "ImageDataSize".
     *
     * The field will be set to its default value. The hasImageDataSize()
     * method will return false.
     */
    inline void clearImageDataSize();

    /**
     * Checks whether the field "ImageDataSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageDataSize()). Otherwise it will return false.
     */
    inline bool hasImageDataSize () const;

    /**
     * Returns the value of the member "ImageDataSize".
     *
     * Image data size in bytes
     *
     * @return The value of the field "ImageDataSize"
     */
    inline uint32 getImageDataSize () const;

    /**
     * Sets the value of the member "ImageDataSize".
     *
     * Image data size in bytes
     *
     * @param ImageDataSize The value which will be set
     */
    inline void setImageDataSize (uint32 ImageDataSize_);

    static const T_ImageData &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_SID ();

    inline void clear_has_SID ();

    inline void set_has_ImageData ();

    inline void clear_has_ImageData ();

    inline void set_has_ImageDataSize ();

    inline void clear_has_ImageDataSize ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _SID;

    ::std::vector< uint8 > _ImageData;

    uint32 _ImageDataSize;

};

inline  T_ImageData::T_ImageData ()  :
    _SID (0u),
    _ImageData (),
    _ImageDataSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ImageData::T_ImageData (const T_ImageData &rhs)  :
    _SID (0u),
    _ImageData (),
    _ImageDataSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ImageData::T_ImageData (uint16 SID_, const ::std::vector< uint8 >& ImageData_, uint32 ImageDataSize_)  :
    _SID (SID_),
    _ImageData (ImageData_),
    _ImageDataSize (ImageDataSize_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ImageData::~T_ImageData() {
}

inline T_ImageData& T_ImageData::operator = (const T_ImageData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSID()) {
            setSID(rhs.getSID());
        } else {
            clearSID();
        }
        if (rhs.hasImageData()) {
            setImageData(rhs.getImageData());
        } else {
            clearImageData();
        }
        if (rhs.hasImageDataSize()) {
            setImageDataSize(rhs.getImageDataSize());
        } else {
            clearImageDataSize();
        }
    }
    return *this;
}

inline bool T_ImageData::operator == (const T_ImageData& rhs) const {
    return (((!hasSID() && !rhs.hasSID()) || getSID() == rhs.getSID()) &&
        ((!hasImageData() && !rhs.hasImageData()) || getImageData() == rhs.getImageData()) &&
        ((!hasImageDataSize() && !rhs.hasImageDataSize()) || getImageDataSize() == rhs.getImageDataSize()));
}

inline bool T_ImageData::operator != (const T_ImageData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ImageData::operator < (const T_ImageData& rhs) const {
    if (hasSID() || rhs.hasSID()) {
        if (getSID() < rhs.getSID()) return true;
        if (getSID() > rhs.getSID()) return false;
    }
    if (hasImageData() || rhs.hasImageData()) {
        if (getImageData() < rhs.getImageData()) return true;
        if (getImageData() > rhs.getImageData()) return false;
    }
    if (hasImageDataSize() || rhs.hasImageDataSize()) {
        if (getImageDataSize() < rhs.getImageDataSize()) return true;
        if (getImageDataSize() > rhs.getImageDataSize()) return false;
    }
    return false;
}

inline bool T_ImageData::operator > (const T_ImageData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ImageData::clear() {
    clearSID();
    clearImageData();
    clearImageDataSize();
}

inline void T_ImageData::clearSID() {
    if (hasSID()) {
         clear_has_SID();
        _SID = 0u;
     }
}

inline bool T_ImageData::hasSID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_ImageData::getSID () const {
    return _SID;
}

inline void T_ImageData::setSID (uint16 SID_) {
    set_has_SID();
    this->_SID = SID_;
}

inline void T_ImageData::clearImageData() {
    if (hasImageData()) {
         clear_has_ImageData();
        _ImageData.clear();
     }
}

inline bool T_ImageData::hasImageData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& T_ImageData::getImageData () const {
    return _ImageData;
}

inline ::std::vector< uint8 >& T_ImageData::getImageDataMutable () {
    set_has_ImageData();
    return _ImageData;
}

inline void T_ImageData::setImageData (const ::std::vector< uint8 >& ImageData_) {
    set_has_ImageData();
    this->_ImageData = ImageData_;
}

inline void T_ImageData::clearImageDataSize() {
    if (hasImageDataSize()) {
         clear_has_ImageDataSize();
        _ImageDataSize = 0u;
     }
}

inline bool T_ImageData::hasImageDataSize () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_ImageData::getImageDataSize () const {
    return _ImageDataSize;
}

inline void T_ImageData::setImageDataSize (uint32 ImageDataSize_) {
    set_has_ImageDataSize();
    this->_ImageDataSize = ImageDataSize_;
}

inline void T_ImageData::set_has_SID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ImageData::clear_has_SID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ImageData::set_has_ImageData () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ImageData::clear_has_ImageData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ImageData::set_has_ImageDataSize () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ImageData::clear_has_ImageDataSize () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace sxm_channelart_main_fi_types

#endif // SXM_CHANNELART_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
