/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_CHANNELART_MAIN_FIPROXY_H
#define SXM_CHANNELART_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "sxm_channelart_main_fi.h"
#include <vector>

namespace sxm_channelart_main_fi {

class Sxm_channelart_main_fiProxy;

class GetChannelArtCallbackIF {
public:
    virtual ~GetChannelArtCallbackIF() {}

    virtual void onGetChannelArtError(const ::boost::shared_ptr< Sxm_channelart_main_fiProxy >& proxy, const ::boost::shared_ptr< GetChannelArtError >& error) = 0;

    virtual void onGetChannelArtResult(const ::boost::shared_ptr< Sxm_channelart_main_fiProxy >& proxy, const ::boost::shared_ptr< GetChannelArtResult >& result) = 0;
};

class GetChannelArtListCallbackIF {
public:
    virtual ~GetChannelArtListCallbackIF() {}

    virtual void onGetChannelArtListError(const ::boost::shared_ptr< Sxm_channelart_main_fiProxy >& proxy, const ::boost::shared_ptr< GetChannelArtListError >& error) = 0;

    virtual void onGetChannelArtListResult(const ::boost::shared_ptr< Sxm_channelart_main_fiProxy >& proxy, const ::boost::shared_ptr< GetChannelArtListResult >& result) = 0;
};

class SxmDataServiceStatusCallbackIF {
public:
    virtual ~SxmDataServiceStatusCallbackIF() {}

    virtual void onSxmDataServiceStatusError(const ::boost::shared_ptr< Sxm_channelart_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusError >& error) = 0;

    virtual void onSxmDataServiceStatusStatus(const ::boost::shared_ptr< Sxm_channelart_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusStatus >& status) = 0;
};

class Sxm_channelart_main_fiProxyCallback;

/**
 * Sxm_channelart_main_fiProxy is the client side representation of the
 * CCA Functional Interface 'sxm_channelart_main_fi' (specified in file
 * sxm_channelart_main_fi.xml).
 *
 * CCA Functional Interface 'sxm_channelart_main_fi'
 *
 * Fullname: SXM ChannelArt Functional Interface Specification
 *
 * Version: $Revision:   0.2  $
 *
 * Author: Tarun Mehta (ECV2)
 *
 * Date: $Date:   August 21 2015  10:00 AM  $
 *
 * Department: ECV2
 *
 * Title: sxm_channelart_main_fi
 *
 * <b>Description of 'sxm_channelart_main_fi':</b>
 *
 * ECV2 RBEI
 */
class Sxm_channelart_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Sxm_channelart_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_channelart_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_channelart_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_channelart_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_channelart_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Sxm_channelart_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Sxm_channelart_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Sxm_channelart_main_fiProxy();

    // Method 'GetChannelArt'

    /**
     * Call the method 'GetChannelArt'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetChannelArt'</b>:
     *
     * Provides Imagedata and Imagedata size
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param SID ServiceIdentifier
     *
     * @param ChannelGraphicsType Refer to T_e8_ChnGraphicsTypes for various image types.
     * These can be bit-wise OR'ed to form single request for multiple types.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetChannelArtStart(GetChannelArtCallbackIF& cb, uint16 sID, uint8 channelGraphicsType);

    // Method 'GetChannelArtList'

    /**
     * Call the method 'GetChannelArtList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetChannelArtList'</b>:
     *
     * Provides List of Channel Art Images for the given SID.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ListOfSID List of ServiceIdentifier
     *
     * @param ChannelGraphicsType SUPPORTED IMAGE TYPES
     * 0 - NO IMAGE
     * 1 - IMAGE LOGO
     * 2 - SECONDARY LOGO
     * 4 - BACKGROUND IMAGE
     * 8 - IMAGE ALBUM
     * (These Image Types can be bit-wise OR'ed to form the various image requests).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetChannelArtListStart(GetChannelArtListCallbackIF& cb, const ::std::vector< uint16 >& listOfSID, uint8 channelGraphicsType);

    // Property 'SxmDataServiceStatus'

    /**
     * Notify on the property 'SxmDataServiceStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of ChannelArt Data Service
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmDataServiceStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of ChannelArt Data Service
     *
     * @param act The act which was previously returned by the
     * sendSxmDataServiceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmDataServiceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmDataServiceStatus'.
     */
    void sendSxmDataServiceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmDataServiceStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSxmDataServiceStatus() returns true.
     *
     * @return the previously received value of the property 'SxmDataServiceStatus'.
     */
    const SxmDataServiceStatusStatus& getSxmDataServiceStatus() const;

    /**
     * Determines whether a status message for the property 'SxmDataServiceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmDataServiceStatus() const;

    /**
     * Request the value of the property 'SxmDataServiceStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of ChannelArt Data Service
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Sxm_channelart_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'SxmDataServiceStatus'

    ::asf::core::nullable< SxmDataServiceStatusStatus > _sxmDataServiceStatus;

    DECLARE_CLASS_LOGGER();

    friend class Sxm_channelart_main_fiProxyCallback;
};

} // namespace sxm_channelart_main_fi

#endif // SXM_CHANNELART_MAIN_FIPROXY_H
