#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_CHANNELART_MAIN_FI_H
#define SXM_CHANNELART_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "sxm_channelart_main_fi_types.h"
#include "sxm_channelart_main_fi_typesConst.h"
#include "sxm_main_fi_types.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'sxm_channelart_main_fi'
 *
 * Fullname: SXM ChannelArt Functional Interface Specification
 *
 * Version: $Revision:   0.2  $
 *
 * Author: Tarun Mehta (ECV2)
 *
 * Date: $Date:   August 21 2015  10:00 AM  $
 *
 * Department: ECV2
 *
 * Title: sxm_channelart_main_fi
 *
 * <b>Description of 'sxm_channelart_main_fi':</b>
 *
 * ECV2 RBEI
 */

namespace sxm_channelart_main_fi {

static const int SERVICE_ID = 161;

static const int FID_GetChannelArt = 1;

static const int FID_GetChannelArtList = 3;

static const int FID_SxmDataServiceStatus = 2;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 3;

static const int VERSION_PATCH = 0;

// forward declarations
class GetChannelArtStart;

class GetChannelArtResult;

class GetChannelArtErrorStructure;

class GetChannelArtError;

class GetChannelArtListStart;

class GetChannelArtListResult;

class GetChannelArtListErrorStructure;

class GetChannelArtListError;

class SxmDataServiceStatusStatus;

// type definitions
/**
 * The abort error message of the method "GetChannelArt"
 * Provides Imagedata and Imagedata size
 */
typedef ::asf::cca::CcaTypes::DefaultError GetChannelArtAbortError;

/**
 * The abort error message of the method "GetChannelArtList"
 * Provides List of Channel Art Images for the given SID.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetChannelArtListAbortError;

/**
 * The get message of the property "SxmDataServiceStatus"
 * Get the Status of ChannelArt Data Service
 * Status of ChannelArt Data Service
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusGet;

/**
 * The upreg message of the property "SxmDataServiceStatus"
 * Get the Status of ChannelArt Data Service
 * Register for ChannelArt Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusUpReg;

/**
 * The relUpReg message of the property "SxmDataServiceStatus"
 * Get the Status of ChannelArt Data Service
 * Unregister for ChannelArt Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusRelUpReg;

/**
 * The error message of 'SxmDataServiceStatus'
 * This error code specifies ChannelArt Data Service Status is not available
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmDataServiceStatusError;


/**
 * The start message of the method "GetChannelArt"
 * Provides Imagedata and Imagedata size
 * Get ChannelArt for a channelSID
 */
class GetChannelArtStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChannelArtStart ();

    /**
     * Copy constructor
     */
    inline  GetChannelArtStart (const GetChannelArtStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelArtStart (uint16 SID_, uint8 ChannelGraphicsType_);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelArtStart();

    /**
     * Assignment operator
     */
    inline GetChannelArtStart& operator = (const GetChannelArtStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelArtStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelArtStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelArtStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelArtStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SID"

    static const int kSID = 0;

    /**
     * Clears the field "SID".
     *
     * The field will be set to its default value. The hasSID()
     * method will return false.
     */
    inline void clearSID();

    /**
     * Checks whether the field "SID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSID()). Otherwise it will return false.
     */
    inline bool hasSID () const;

    /**
     * Returns the value of the member "SID".
     *
     * ServiceIdentifier
     *
     * @return The value of the field "SID"
     */
    inline uint16 getSID () const;

    /**
     * Sets the value of the member "SID".
     *
     * ServiceIdentifier
     *
     * @param SID The value which will be set
     */
    inline void setSID (uint16 SID_);

    // API of field "ChannelGraphicsType"

    static const int kChannelGraphicsType = 1;

    /**
     * Clears the field "ChannelGraphicsType".
     *
     * The field will be set to its default value. The hasChannelGraphicsType()
     * method will return false.
     */
    inline void clearChannelGraphicsType();

    /**
     * Checks whether the field "ChannelGraphicsType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelGraphicsType()). Otherwise it will return false.
     */
    inline bool hasChannelGraphicsType () const;

    /**
     * Returns the value of the member "ChannelGraphicsType".
     *
     * Refer to T_e8_ChnGraphicsTypes for various image types.
     * These can be bit-wise OR'ed to form single request for multiple types.
     *
     * @return The value of the field "ChannelGraphicsType"
     */
    inline uint8 getChannelGraphicsType () const;

    /**
     * Sets the value of the member "ChannelGraphicsType".
     *
     * Refer to T_e8_ChnGraphicsTypes for various image types.
     * These can be bit-wise OR'ed to form single request for multiple types.
     *
     * @param ChannelGraphicsType The value which will be set
     */
    inline void setChannelGraphicsType (uint8 ChannelGraphicsType_);

    static const GetChannelArtStart &getDefaultInstance();

private:

    inline void set_has_SID ();

    inline void clear_has_SID ();

    inline void set_has_ChannelGraphicsType ();

    inline void clear_has_ChannelGraphicsType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _SID;

    uint8 _ChannelGraphicsType;

};

/**
 * The result message of the method "GetChannelArt"
 * Provides Imagedata and Imagedata size
 */
class GetChannelArtResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChannelArtResult ();

    /**
     * Copy constructor
     */
    inline  GetChannelArtResult (const GetChannelArtResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelArtResult (uint8 ChannelGraphicsType_, const ::std::vector< uint8 >& u8ImageData_, const ::std::vector< uint8 >& AlbumImageData_, uint32 ImageDataSize_, uint32 AlbumImageSize_, uint16 SID_);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelArtResult();

    /**
     * Assignment operator
     */
    inline GetChannelArtResult& operator = (const GetChannelArtResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelArtResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelArtResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelArtResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelArtResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelGraphicsType"

    static const int kChannelGraphicsType = 0;

    /**
     * Clears the field "ChannelGraphicsType".
     *
     * The field will be set to its default value. The hasChannelGraphicsType()
     * method will return false.
     */
    inline void clearChannelGraphicsType();

    /**
     * Checks whether the field "ChannelGraphicsType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelGraphicsType()). Otherwise it will return false.
     */
    inline bool hasChannelGraphicsType () const;

    /**
     * Returns the value of the member "ChannelGraphicsType".
     *
     * Refer to T_e8_ChnGraphicsTypes for various image types.
     * These can be bit-wise OR'ed to form single request for multiple types.
     *
     * @return The value of the field "ChannelGraphicsType"
     */
    inline uint8 getChannelGraphicsType () const;

    /**
     * Sets the value of the member "ChannelGraphicsType".
     *
     * Refer to T_e8_ChnGraphicsTypes for various image types.
     * These can be bit-wise OR'ed to form single request for multiple types.
     *
     * @param ChannelGraphicsType The value which will be set
     */
    inline void setChannelGraphicsType (uint8 ChannelGraphicsType_);

    // API of field "u8ImageData"

    static const int kU8ImageData = 1;

    /**
     * Clears the field "u8ImageData".
     *
     * The field will be set to its default value. The hasU8ImageData()
     * method will return false.
     */
    inline void clearU8ImageData();

    /**
     * Checks whether the field "u8ImageData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ImageData()). Otherwise it will return false.
     */
    inline bool hasU8ImageData () const;

    /**
     * Returns the value of the member "u8ImageData".
     *
     * <p>list of Image data</p>
     *
     * @return The value of the field "u8ImageData"
     */
    inline const ::std::vector< uint8 >& getU8ImageData () const;

    /**
     * Retrieves the value of the field "u8ImageData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u8ImageData".
     */
    inline ::std::vector< uint8 >& getU8ImageDataMutable ();

    /**
     * Sets the value of the member "u8ImageData".
     *
     * <p>list of Image data</p>
     *
     * @param u8ImageData The value which will be set
     */
    inline void setU8ImageData (const ::std::vector< uint8 >& u8ImageData_);

    // API of field "AlbumImageData"

    static const int kAlbumImageData = 2;

    /**
     * Clears the field "AlbumImageData".
     *
     * The field will be set to its default value. The hasAlbumImageData()
     * method will return false.
     */
    inline void clearAlbumImageData();

    /**
     * Checks whether the field "AlbumImageData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlbumImageData()). Otherwise it will return false.
     */
    inline bool hasAlbumImageData () const;

    /**
     * Returns the value of the member "AlbumImageData".
     *
     * <p>list of Album Image data</p>
     *
     * @return The value of the field "AlbumImageData"
     */
    inline const ::std::vector< uint8 >& getAlbumImageData () const;

    /**
     * Retrieves the value of the field "AlbumImageData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlbumImageData".
     */
    inline ::std::vector< uint8 >& getAlbumImageDataMutable ();

    /**
     * Sets the value of the member "AlbumImageData".
     *
     * <p>list of Album Image data</p>
     *
     * @param AlbumImageData The value which will be set
     */
    inline void setAlbumImageData (const ::std::vector< uint8 >& AlbumImageData_);

    // API of field "ImageDataSize"

    static const int kImageDataSize = 3;

    /**
     * Clears the field "ImageDataSize".
     *
     * The field will be set to its default value. The hasImageDataSize()
     * method will return false.
     */
    inline void clearImageDataSize();

    /**
     * Checks whether the field "ImageDataSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageDataSize()). Otherwise it will return false.
     */
    inline bool hasImageDataSize () const;

    /**
     * Returns the value of the member "ImageDataSize".
     *
     * Image data size in bytes
     *
     * @return The value of the field "ImageDataSize"
     */
    inline uint32 getImageDataSize () const;

    /**
     * Sets the value of the member "ImageDataSize".
     *
     * Image data size in bytes
     *
     * @param ImageDataSize The value which will be set
     */
    inline void setImageDataSize (uint32 ImageDataSize_);

    // API of field "AlbumImageSize"

    static const int kAlbumImageSize = 4;

    /**
     * Clears the field "AlbumImageSize".
     *
     * The field will be set to its default value. The hasAlbumImageSize()
     * method will return false.
     */
    inline void clearAlbumImageSize();

    /**
     * Checks whether the field "AlbumImageSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlbumImageSize()). Otherwise it will return false.
     */
    inline bool hasAlbumImageSize () const;

    /**
     * Returns the value of the member "AlbumImageSize".
     *
     * Album Image data size in bytes
     *
     * @return The value of the field "AlbumImageSize"
     */
    inline uint32 getAlbumImageSize () const;

    /**
     * Sets the value of the member "AlbumImageSize".
     *
     * Album Image data size in bytes
     *
     * @param AlbumImageSize The value which will be set
     */
    inline void setAlbumImageSize (uint32 AlbumImageSize_);

    // API of field "SID"

    static const int kSID = 5;

    /**
     * Clears the field "SID".
     *
     * The field will be set to its default value. The hasSID()
     * method will return false.
     */
    inline void clearSID();

    /**
     * Checks whether the field "SID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSID()). Otherwise it will return false.
     */
    inline bool hasSID () const;

    /**
     * Returns the value of the member "SID".
     *
     * ServiceIdentifier
     *
     * @return The value of the field "SID"
     */
    inline uint16 getSID () const;

    /**
     * Sets the value of the member "SID".
     *
     * ServiceIdentifier
     *
     * @param SID The value which will be set
     */
    inline void setSID (uint16 SID_);

    static const GetChannelArtResult &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_ChannelGraphicsType ();

    inline void clear_has_ChannelGraphicsType ();

    inline void set_has_u8ImageData ();

    inline void clear_has_u8ImageData ();

    inline void set_has_AlbumImageData ();

    inline void clear_has_AlbumImageData ();

    inline void set_has_ImageDataSize ();

    inline void clear_has_ImageDataSize ();

    inline void set_has_AlbumImageSize ();

    inline void clear_has_AlbumImageSize ();

    inline void set_has_SID ();

    inline void clear_has_SID ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint8 _ChannelGraphicsType;

    ::std::vector< uint8 > _u8ImageData;

    ::std::vector< uint8 > _AlbumImageData;

    uint32 _ImageDataSize;

    uint32 _AlbumImageSize;

    uint16 _SID;

};

/**
 * The error message of 'GetChannelArt'
 */
class GetChannelArtErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetChannelArtErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetChannelArtErrorStructure (const GetChannelArtErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelArtErrorStructure (::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetChannelArtErrorStructure();

    /**
     * Assignment operator
     */
    inline GetChannelArtErrorStructure& operator = (const GetChannelArtErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelArtErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelArtErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelArtErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelArtErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes ErrorCode_);

    static const GetChannelArtErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetChannelArt'
 */
class GetChannelArtError  : public ::asf::core::Payload {
public:

    enum GetChannelArtErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetChannelArtError ();

   /**
     * Copy constructor
     */
    inline  GetChannelArtError (const GetChannelArtError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelArtError();

    /**
     * Assigns a new value to this object.
     */
    inline GetChannelArtError& operator = (const GetChannelArtError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelArtError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelArtError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelArtError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelArtError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetChannelArtError::GetChannelArtErrorField getField () const;

    inline void setField(GetChannelArtError::GetChannelArtErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetChannelArtErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetChannelArtErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetChannelArtErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetChannelArtErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetChannelArtErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetChannelArtErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetChannelArtErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetChannelArtErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetChannelArtError &getDefaultInstance();

private:

    inline void cloneData (const GetChannelArtError& rhs);

    inline void deleteData ();

    GetChannelArtErrorField __field;

    union {
        GetChannelArtErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetChannelArtList"
 * Provides List of Channel Art Images for the given SID.
 * Get ChannelArt for list of channel SID
 */
class GetChannelArtListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChannelArtListStart ();

    /**
     * Copy constructor
     */
    inline  GetChannelArtListStart (const GetChannelArtListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelArtListStart (const ::std::vector< uint16 >& ListOfSID_, uint8 ChannelGraphicsType_);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelArtListStart();

    /**
     * Assignment operator
     */
    inline GetChannelArtListStart& operator = (const GetChannelArtListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelArtListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelArtListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelArtListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelArtListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListOfSID"

    static const int kListOfSID = 0;

    /**
     * Clears the field "ListOfSID".
     *
     * The field will be set to its default value. The hasListOfSID()
     * method will return false.
     */
    inline void clearListOfSID();

    /**
     * Checks whether the field "ListOfSID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListOfSID()). Otherwise it will return false.
     */
    inline bool hasListOfSID () const;

    /**
     * Returns the value of the member "ListOfSID".
     *
     * List of ServiceIdentifier
     *
     * @return The value of the field "ListOfSID"
     */
    inline const ::std::vector< uint16 >& getListOfSID () const;

    /**
     * Retrieves the value of the field "ListOfSID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListOfSID".
     */
    inline ::std::vector< uint16 >& getListOfSIDMutable ();

    /**
     * Sets the value of the member "ListOfSID".
     *
     * List of ServiceIdentifier
     *
     * @param ListOfSID The value which will be set
     */
    inline void setListOfSID (const ::std::vector< uint16 >& ListOfSID_);

    // API of field "ChannelGraphicsType"

    static const int kChannelGraphicsType = 1;

    /**
     * Clears the field "ChannelGraphicsType".
     *
     * The field will be set to its default value. The hasChannelGraphicsType()
     * method will return false.
     */
    inline void clearChannelGraphicsType();

    /**
     * Checks whether the field "ChannelGraphicsType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelGraphicsType()). Otherwise it will return false.
     */
    inline bool hasChannelGraphicsType () const;

    /**
     * Returns the value of the member "ChannelGraphicsType".
     *
     * SUPPORTED IMAGE TYPES
     * 0 - NO IMAGE
     * 1 - IMAGE LOGO
     * 2 - SECONDARY LOGO
     * 4 - BACKGROUND IMAGE
     * 8 - IMAGE ALBUM
     * (These Image Types can be bit-wise OR'ed to form the various image requests).
     *
     * @return The value of the field "ChannelGraphicsType"
     */
    inline uint8 getChannelGraphicsType () const;

    /**
     * Sets the value of the member "ChannelGraphicsType".
     *
     * SUPPORTED IMAGE TYPES
     * 0 - NO IMAGE
     * 1 - IMAGE LOGO
     * 2 - SECONDARY LOGO
     * 4 - BACKGROUND IMAGE
     * 8 - IMAGE ALBUM
     * (These Image Types can be bit-wise OR'ed to form the various image requests).
     *
     * @param ChannelGraphicsType The value which will be set
     */
    inline void setChannelGraphicsType (uint8 ChannelGraphicsType_);

    static const GetChannelArtListStart &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_ListOfSID ();

    inline void clear_has_ListOfSID ();

    inline void set_has_ChannelGraphicsType ();

    inline void clear_has_ChannelGraphicsType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< uint16 > _ListOfSID;

    uint8 _ChannelGraphicsType;

};

/**
 * The result message of the method "GetChannelArtList"
 * Provides List of Channel Art Images for the given SID.
 */
class GetChannelArtListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChannelArtListResult ();

    /**
     * Copy constructor
     */
    inline  GetChannelArtListResult (const GetChannelArtListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelArtListResult (uint8 ChannelGraphicsType_, const ::std::vector< ::sxm_channelart_main_fi_types::T_ImageData >& ImageDataList_);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelArtListResult();

    /**
     * Assignment operator
     */
    inline GetChannelArtListResult& operator = (const GetChannelArtListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelArtListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelArtListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelArtListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelArtListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelGraphicsType"

    static const int kChannelGraphicsType = 0;

    /**
     * Clears the field "ChannelGraphicsType".
     *
     * The field will be set to its default value. The hasChannelGraphicsType()
     * method will return false.
     */
    inline void clearChannelGraphicsType();

    /**
     * Checks whether the field "ChannelGraphicsType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelGraphicsType()). Otherwise it will return false.
     */
    inline bool hasChannelGraphicsType () const;

    /**
     * Returns the value of the member "ChannelGraphicsType".
     *
     * SUPPORTED IMAGE TYPES
     * 0 - NO IMAGE
     * 1 - IMAGE LOGO
     * 2 - SECONDARY LOGO
     * 4 - BACKGROUND IMAGE
     * 8 - IMAGE ALBUM
     * (These Image Types can be bit-wise OR'ed to form the various images).
     *
     * @return The value of the field "ChannelGraphicsType"
     */
    inline uint8 getChannelGraphicsType () const;

    /**
     * Sets the value of the member "ChannelGraphicsType".
     *
     * SUPPORTED IMAGE TYPES
     * 0 - NO IMAGE
     * 1 - IMAGE LOGO
     * 2 - SECONDARY LOGO
     * 4 - BACKGROUND IMAGE
     * 8 - IMAGE ALBUM
     * (These Image Types can be bit-wise OR'ed to form the various images).
     *
     * @param ChannelGraphicsType The value which will be set
     */
    inline void setChannelGraphicsType (uint8 ChannelGraphicsType_);

    // API of field "ImageDataList"

    static const int kImageDataList = 1;

    /**
     * Clears the field "ImageDataList".
     *
     * The field will be set to its default value. The hasImageDataList()
     * method will return false.
     */
    inline void clearImageDataList();

    /**
     * Checks whether the field "ImageDataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageDataList()). Otherwise it will return false.
     */
    inline bool hasImageDataList () const;

    /**
     * Returns the value of the member "ImageDataList".
     *
     * <p>list of Image data</p>
     *
     * @return The value of the field "ImageDataList"
     */
    inline const ::std::vector< ::sxm_channelart_main_fi_types::T_ImageData >& getImageDataList () const;

    /**
     * Retrieves the value of the field "ImageDataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ImageDataList".
     */
    inline ::std::vector< ::sxm_channelart_main_fi_types::T_ImageData >& getImageDataListMutable ();

    /**
     * Sets the value of the member "ImageDataList".
     *
     * <p>list of Image data</p>
     *
     * @param ImageDataList The value which will be set
     */
    inline void setImageDataList (const ::std::vector< ::sxm_channelart_main_fi_types::T_ImageData >& ImageDataList_);

    static const GetChannelArtListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_channelart_main_fi_types::T_ImageData >& getT_ImageDataList_DefaultInstance ();

    inline void set_has_ChannelGraphicsType ();

    inline void clear_has_ChannelGraphicsType ();

    inline void set_has_ImageDataList ();

    inline void clear_has_ImageDataList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ChannelGraphicsType;

    ::std::vector< ::sxm_channelart_main_fi_types::T_ImageData > _ImageDataList;

};

/**
 * The error message of 'GetChannelArtList'
 */
class GetChannelArtListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetChannelArtListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetChannelArtListErrorStructure (const GetChannelArtListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelArtListErrorStructure (::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetChannelArtListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetChannelArtListErrorStructure& operator = (const GetChannelArtListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelArtListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelArtListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelArtListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelArtListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes ErrorCode_);

    static const GetChannelArtListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetChannelArtList'
 */
class GetChannelArtListError  : public ::asf::core::Payload {
public:

    enum GetChannelArtListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetChannelArtListError ();

   /**
     * Copy constructor
     */
    inline  GetChannelArtListError (const GetChannelArtListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelArtListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetChannelArtListError& operator = (const GetChannelArtListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelArtListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelArtListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelArtListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelArtListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetChannelArtListError::GetChannelArtListErrorField getField () const;

    inline void setField(GetChannelArtListError::GetChannelArtListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetChannelArtListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetChannelArtListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetChannelArtListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetChannelArtListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetChannelArtListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetChannelArtListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetChannelArtListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetChannelArtListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetChannelArtListError &getDefaultInstance();

private:

    inline void cloneData (const GetChannelArtListError& rhs);

    inline void deleteData ();

    GetChannelArtListErrorField __field;

    union {
        GetChannelArtListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SxmDataServiceStatus"
 * Get the Status of ChannelArt Data Service
 */
class SxmDataServiceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmDataServiceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    /**
     * Destructor
     */
    inline virtual  ~SxmDataServiceStatusStatus();

    /**
     * Assignment operator
     */
    inline SxmDataServiceStatusStatus& operator = (const SxmDataServiceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataServiceState"

    static const int kDataServiceState = 0;

    /**
     * Clears the field "DataServiceState".
     *
     * The field will be set to its default value. The hasDataServiceState()
     * method will return false.
     */
    inline void clearDataServiceState();

    /**
     * Checks whether the field "DataServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataServiceState()). Otherwise it will return false.
     */
    inline bool hasDataServiceState () const;

    /**
     * Returns the value of the member "DataServiceState".
     *
     * Status of ChannelArt Data Service
     *
     * @return The value of the field "DataServiceState"
     */
    inline const ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceState () const;

    /**
     * Retrieves the value of the field "DataServiceState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DataServiceState".
     */
    inline ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceStateMutable ();

    /**
     * Sets the value of the member "DataServiceState".
     *
     * Status of ChannelArt Data Service
     *
     * @param DataServiceState The value which will be set
     */
    inline void setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    static const SxmDataServiceStatusStatus &getDefaultInstance();

private:

    inline void set_has_DataServiceState ();

    inline void clear_has_DataServiceState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmDataSrvState _DataServiceState;

};

inline  GetChannelArtStart::GetChannelArtStart ()  :
    _SID (0u),
    _ChannelGraphicsType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetChannelArtStart::GetChannelArtStart (const GetChannelArtStart &rhs)  :
    ::asf::core::Payload(rhs),
    _SID (0u),
    _ChannelGraphicsType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetChannelArtStart::GetChannelArtStart (uint16 SID_, uint8 ChannelGraphicsType_)  :
    _SID (SID_),
    _ChannelGraphicsType (ChannelGraphicsType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetChannelArtStart::~GetChannelArtStart() {
}

inline GetChannelArtStart& GetChannelArtStart::operator = (const GetChannelArtStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSID()) {
            setSID(rhs.getSID());
        } else {
            clearSID();
        }
        if (rhs.hasChannelGraphicsType()) {
            setChannelGraphicsType(rhs.getChannelGraphicsType());
        } else {
            clearChannelGraphicsType();
        }
    }
    return *this;
}

inline bool GetChannelArtStart::operator == (const GetChannelArtStart& rhs) const {
    return (((!hasSID() && !rhs.hasSID()) || getSID() == rhs.getSID()) &&
        ((!hasChannelGraphicsType() && !rhs.hasChannelGraphicsType()) || getChannelGraphicsType() == rhs.getChannelGraphicsType()));
}

inline bool GetChannelArtStart::operator != (const GetChannelArtStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetChannelArtStart::operator < (const GetChannelArtStart& rhs) const {
    if (hasSID() || rhs.hasSID()) {
        if (getSID() < rhs.getSID()) return true;
        if (getSID() > rhs.getSID()) return false;
    }
    if (hasChannelGraphicsType() || rhs.hasChannelGraphicsType()) {
        if (getChannelGraphicsType() < rhs.getChannelGraphicsType()) return true;
        if (getChannelGraphicsType() > rhs.getChannelGraphicsType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetChannelArtStart::clone() {
    return new GetChannelArtStart(*this);
}

inline bool GetChannelArtStart::operator > (const GetChannelArtStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetChannelArtStart::clear() {
    clearSID();
    clearChannelGraphicsType();
}

inline void GetChannelArtStart::clearSID() {
    if (hasSID()) {
         clear_has_SID();
        _SID = 0u;
     }
}

inline bool GetChannelArtStart::hasSID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 GetChannelArtStart::getSID () const {
    return _SID;
}

inline void GetChannelArtStart::setSID (uint16 SID_) {
    set_has_SID();
    this->_SID = SID_;
}

inline void GetChannelArtStart::clearChannelGraphicsType() {
    if (hasChannelGraphicsType()) {
         clear_has_ChannelGraphicsType();
        _ChannelGraphicsType = 0u;
     }
}

inline bool GetChannelArtStart::hasChannelGraphicsType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetChannelArtStart::getChannelGraphicsType () const {
    return _ChannelGraphicsType;
}

inline void GetChannelArtStart::setChannelGraphicsType (uint8 ChannelGraphicsType_) {
    set_has_ChannelGraphicsType();
    this->_ChannelGraphicsType = ChannelGraphicsType_;
}

inline void GetChannelArtStart::set_has_SID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetChannelArtStart::clear_has_SID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetChannelArtStart::set_has_ChannelGraphicsType () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetChannelArtStart::clear_has_ChannelGraphicsType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetChannelArtResult::GetChannelArtResult ()  :
    _ChannelGraphicsType (0u),
    _u8ImageData (),
    _AlbumImageData (),
    _ImageDataSize (0u),
    _AlbumImageSize (0u),
    _SID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetChannelArtResult::GetChannelArtResult (const GetChannelArtResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ChannelGraphicsType (0u),
    _u8ImageData (),
    _AlbumImageData (),
    _ImageDataSize (0u),
    _AlbumImageSize (0u),
    _SID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetChannelArtResult::GetChannelArtResult (uint8 ChannelGraphicsType_, const ::std::vector< uint8 >& u8ImageData_, const ::std::vector< uint8 >& AlbumImageData_, uint32 ImageDataSize_, uint32 AlbumImageSize_, uint16 SID_)  :
    _ChannelGraphicsType (ChannelGraphicsType_),
    _u8ImageData (u8ImageData_),
    _AlbumImageData (AlbumImageData_),
    _ImageDataSize (ImageDataSize_),
    _AlbumImageSize (AlbumImageSize_),
    _SID (SID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetChannelArtResult::~GetChannelArtResult() {
}

inline GetChannelArtResult& GetChannelArtResult::operator = (const GetChannelArtResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChannelGraphicsType()) {
            setChannelGraphicsType(rhs.getChannelGraphicsType());
        } else {
            clearChannelGraphicsType();
        }
        if (rhs.hasU8ImageData()) {
            setU8ImageData(rhs.getU8ImageData());
        } else {
            clearU8ImageData();
        }
        if (rhs.hasAlbumImageData()) {
            setAlbumImageData(rhs.getAlbumImageData());
        } else {
            clearAlbumImageData();
        }
        if (rhs.hasImageDataSize()) {
            setImageDataSize(rhs.getImageDataSize());
        } else {
            clearImageDataSize();
        }
        if (rhs.hasAlbumImageSize()) {
            setAlbumImageSize(rhs.getAlbumImageSize());
        } else {
            clearAlbumImageSize();
        }
        if (rhs.hasSID()) {
            setSID(rhs.getSID());
        } else {
            clearSID();
        }
    }
    return *this;
}

inline bool GetChannelArtResult::operator == (const GetChannelArtResult& rhs) const {
    return (((!hasChannelGraphicsType() && !rhs.hasChannelGraphicsType()) || getChannelGraphicsType() == rhs.getChannelGraphicsType()) &&
        ((!hasU8ImageData() && !rhs.hasU8ImageData()) || getU8ImageData() == rhs.getU8ImageData()) &&
        ((!hasAlbumImageData() && !rhs.hasAlbumImageData()) || getAlbumImageData() == rhs.getAlbumImageData()) &&
        ((!hasImageDataSize() && !rhs.hasImageDataSize()) || getImageDataSize() == rhs.getImageDataSize()) &&
        ((!hasAlbumImageSize() && !rhs.hasAlbumImageSize()) || getAlbumImageSize() == rhs.getAlbumImageSize()) &&
        ((!hasSID() && !rhs.hasSID()) || getSID() == rhs.getSID()));
}

inline bool GetChannelArtResult::operator != (const GetChannelArtResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetChannelArtResult::operator < (const GetChannelArtResult& rhs) const {
    if (hasChannelGraphicsType() || rhs.hasChannelGraphicsType()) {
        if (getChannelGraphicsType() < rhs.getChannelGraphicsType()) return true;
        if (getChannelGraphicsType() > rhs.getChannelGraphicsType()) return false;
    }
    if (hasU8ImageData() || rhs.hasU8ImageData()) {
        if (getU8ImageData() < rhs.getU8ImageData()) return true;
        if (getU8ImageData() > rhs.getU8ImageData()) return false;
    }
    if (hasAlbumImageData() || rhs.hasAlbumImageData()) {
        if (getAlbumImageData() < rhs.getAlbumImageData()) return true;
        if (getAlbumImageData() > rhs.getAlbumImageData()) return false;
    }
    if (hasImageDataSize() || rhs.hasImageDataSize()) {
        if (getImageDataSize() < rhs.getImageDataSize()) return true;
        if (getImageDataSize() > rhs.getImageDataSize()) return false;
    }
    if (hasAlbumImageSize() || rhs.hasAlbumImageSize()) {
        if (getAlbumImageSize() < rhs.getAlbumImageSize()) return true;
        if (getAlbumImageSize() > rhs.getAlbumImageSize()) return false;
    }
    if (hasSID() || rhs.hasSID()) {
        if (getSID() < rhs.getSID()) return true;
        if (getSID() > rhs.getSID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetChannelArtResult::clone() {
    return new GetChannelArtResult(*this);
}

inline bool GetChannelArtResult::operator > (const GetChannelArtResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetChannelArtResult::clear() {
    clearChannelGraphicsType();
    clearU8ImageData();
    clearAlbumImageData();
    clearImageDataSize();
    clearAlbumImageSize();
    clearSID();
}

inline void GetChannelArtResult::clearChannelGraphicsType() {
    if (hasChannelGraphicsType()) {
         clear_has_ChannelGraphicsType();
        _ChannelGraphicsType = 0u;
     }
}

inline bool GetChannelArtResult::hasChannelGraphicsType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetChannelArtResult::getChannelGraphicsType () const {
    return _ChannelGraphicsType;
}

inline void GetChannelArtResult::setChannelGraphicsType (uint8 ChannelGraphicsType_) {
    set_has_ChannelGraphicsType();
    this->_ChannelGraphicsType = ChannelGraphicsType_;
}

inline void GetChannelArtResult::clearU8ImageData() {
    if (hasU8ImageData()) {
         clear_has_u8ImageData();
        _u8ImageData.clear();
     }
}

inline bool GetChannelArtResult::hasU8ImageData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& GetChannelArtResult::getU8ImageData () const {
    return _u8ImageData;
}

inline ::std::vector< uint8 >& GetChannelArtResult::getU8ImageDataMutable () {
    set_has_u8ImageData();
    return _u8ImageData;
}

inline void GetChannelArtResult::setU8ImageData (const ::std::vector< uint8 >& u8ImageData_) {
    set_has_u8ImageData();
    this->_u8ImageData = u8ImageData_;
}

inline void GetChannelArtResult::clearAlbumImageData() {
    if (hasAlbumImageData()) {
         clear_has_AlbumImageData();
        _AlbumImageData.clear();
     }
}

inline bool GetChannelArtResult::hasAlbumImageData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint8 >& GetChannelArtResult::getAlbumImageData () const {
    return _AlbumImageData;
}

inline ::std::vector< uint8 >& GetChannelArtResult::getAlbumImageDataMutable () {
    set_has_AlbumImageData();
    return _AlbumImageData;
}

inline void GetChannelArtResult::setAlbumImageData (const ::std::vector< uint8 >& AlbumImageData_) {
    set_has_AlbumImageData();
    this->_AlbumImageData = AlbumImageData_;
}

inline void GetChannelArtResult::clearImageDataSize() {
    if (hasImageDataSize()) {
         clear_has_ImageDataSize();
        _ImageDataSize = 0u;
     }
}

inline bool GetChannelArtResult::hasImageDataSize () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 GetChannelArtResult::getImageDataSize () const {
    return _ImageDataSize;
}

inline void GetChannelArtResult::setImageDataSize (uint32 ImageDataSize_) {
    set_has_ImageDataSize();
    this->_ImageDataSize = ImageDataSize_;
}

inline void GetChannelArtResult::clearAlbumImageSize() {
    if (hasAlbumImageSize()) {
         clear_has_AlbumImageSize();
        _AlbumImageSize = 0u;
     }
}

inline bool GetChannelArtResult::hasAlbumImageSize () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 GetChannelArtResult::getAlbumImageSize () const {
    return _AlbumImageSize;
}

inline void GetChannelArtResult::setAlbumImageSize (uint32 AlbumImageSize_) {
    set_has_AlbumImageSize();
    this->_AlbumImageSize = AlbumImageSize_;
}

inline void GetChannelArtResult::clearSID() {
    if (hasSID()) {
         clear_has_SID();
        _SID = 0u;
     }
}

inline bool GetChannelArtResult::hasSID () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 GetChannelArtResult::getSID () const {
    return _SID;
}

inline void GetChannelArtResult::setSID (uint16 SID_) {
    set_has_SID();
    this->_SID = SID_;
}

inline void GetChannelArtResult::set_has_ChannelGraphicsType () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetChannelArtResult::clear_has_ChannelGraphicsType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetChannelArtResult::set_has_u8ImageData () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetChannelArtResult::clear_has_u8ImageData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetChannelArtResult::set_has_AlbumImageData () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetChannelArtResult::clear_has_AlbumImageData () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetChannelArtResult::set_has_ImageDataSize () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetChannelArtResult::clear_has_ImageDataSize () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void GetChannelArtResult::set_has_AlbumImageSize () {
    _has_bits_[0] |= 1u << 4;
}

inline void GetChannelArtResult::clear_has_AlbumImageSize () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void GetChannelArtResult::set_has_SID () {
    _has_bits_[0] |= 1u << 5;
}

inline void GetChannelArtResult::clear_has_SID () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  GetChannelArtErrorStructure::GetChannelArtErrorStructure ()  :
    _ErrorCode (::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes__CHANNELART_SERVICE_ERROR)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetChannelArtErrorStructure::GetChannelArtErrorStructure (const GetChannelArtErrorStructure &rhs)  :
    _ErrorCode (::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes__CHANNELART_SERVICE_ERROR)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetChannelArtErrorStructure::GetChannelArtErrorStructure (::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8ChannelArtErrorTypes", "ErrorCode", "GetChannelArtErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetChannelArtErrorStructure::~GetChannelArtErrorStructure() {
}

inline GetChannelArtErrorStructure& GetChannelArtErrorStructure::operator = (const GetChannelArtErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetChannelArtErrorStructure::operator == (const GetChannelArtErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetChannelArtErrorStructure::operator != (const GetChannelArtErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetChannelArtErrorStructure::operator < (const GetChannelArtErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetChannelArtErrorStructure::operator > (const GetChannelArtErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetChannelArtErrorStructure::clear() {
    clearErrorCode();
}

inline void GetChannelArtErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes__CHANNELART_SERVICE_ERROR;
     }
}

inline bool GetChannelArtErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes GetChannelArtErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetChannelArtErrorStructure::setErrorCode (::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8ChannelArtErrorTypes", "ErrorCode", "GetChannelArtErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetChannelArtErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetChannelArtErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetChannelArtError::GetChannelArtError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetChannelArtError::GetChannelArtError (const GetChannelArtError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetChannelArtError::~GetChannelArtError() {
    deleteData ();
}

inline GetChannelArtError& GetChannelArtError::operator = (const GetChannelArtError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetChannelArtError::operator == (const GetChannelArtError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetChannelArtError::operator != (const GetChannelArtError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetChannelArtError::operator < (const GetChannelArtError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetChannelArtError::operator > (const GetChannelArtError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetChannelArtError::GetChannelArtErrorField GetChannelArtError::getField () const {
    return __field;
}

inline void GetChannelArtError::setField(GetChannelArtError::GetChannelArtErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetChannelArtError::clone() {
    return new GetChannelArtError(*this);
}

inline bool GetChannelArtError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetChannelArtErrorStructure& GetChannelArtError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetChannelArtError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetChannelArtErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetChannelArtErrorStructure& GetChannelArtError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetChannelArtError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetChannelArtErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetChannelArtErrorStructure* GetChannelArtError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetChannelArtError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetChannelArtErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetChannelArtErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetChannelArtError::replaceCcaErrorCode (GetChannelArtErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetChannelArtError::setCcaErrorCode (const GetChannelArtErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetChannelArtErrorStructure(value);
    }
}

inline bool GetChannelArtError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetChannelArtError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetChannelArtError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetChannelArtError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetChannelArtError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetChannelArtError::cloneData (const GetChannelArtError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetChannelArtErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetChannelArtErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetChannelArtError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetChannelArtListStart::GetChannelArtListStart ()  :
    _ListOfSID (),
    _ChannelGraphicsType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetChannelArtListStart::GetChannelArtListStart (const GetChannelArtListStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ListOfSID (),
    _ChannelGraphicsType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetChannelArtListStart::GetChannelArtListStart (const ::std::vector< uint16 >& ListOfSID_, uint8 ChannelGraphicsType_)  :
    _ListOfSID (ListOfSID_),
    _ChannelGraphicsType (ChannelGraphicsType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetChannelArtListStart::~GetChannelArtListStart() {
}

inline GetChannelArtListStart& GetChannelArtListStart::operator = (const GetChannelArtListStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListOfSID()) {
            setListOfSID(rhs.getListOfSID());
        } else {
            clearListOfSID();
        }
        if (rhs.hasChannelGraphicsType()) {
            setChannelGraphicsType(rhs.getChannelGraphicsType());
        } else {
            clearChannelGraphicsType();
        }
    }
    return *this;
}

inline bool GetChannelArtListStart::operator == (const GetChannelArtListStart& rhs) const {
    return (((!hasListOfSID() && !rhs.hasListOfSID()) || getListOfSID() == rhs.getListOfSID()) &&
        ((!hasChannelGraphicsType() && !rhs.hasChannelGraphicsType()) || getChannelGraphicsType() == rhs.getChannelGraphicsType()));
}

inline bool GetChannelArtListStart::operator != (const GetChannelArtListStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetChannelArtListStart::operator < (const GetChannelArtListStart& rhs) const {
    if (hasListOfSID() || rhs.hasListOfSID()) {
        if (getListOfSID() < rhs.getListOfSID()) return true;
        if (getListOfSID() > rhs.getListOfSID()) return false;
    }
    if (hasChannelGraphicsType() || rhs.hasChannelGraphicsType()) {
        if (getChannelGraphicsType() < rhs.getChannelGraphicsType()) return true;
        if (getChannelGraphicsType() > rhs.getChannelGraphicsType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetChannelArtListStart::clone() {
    return new GetChannelArtListStart(*this);
}

inline bool GetChannelArtListStart::operator > (const GetChannelArtListStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetChannelArtListStart::clear() {
    clearListOfSID();
    clearChannelGraphicsType();
}

inline void GetChannelArtListStart::clearListOfSID() {
    if (hasListOfSID()) {
         clear_has_ListOfSID();
        _ListOfSID.clear();
     }
}

inline bool GetChannelArtListStart::hasListOfSID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint16 >& GetChannelArtListStart::getListOfSID () const {
    return _ListOfSID;
}

inline ::std::vector< uint16 >& GetChannelArtListStart::getListOfSIDMutable () {
    set_has_ListOfSID();
    return _ListOfSID;
}

inline void GetChannelArtListStart::setListOfSID (const ::std::vector< uint16 >& ListOfSID_) {
    set_has_ListOfSID();
    this->_ListOfSID = ListOfSID_;
}

inline void GetChannelArtListStart::clearChannelGraphicsType() {
    if (hasChannelGraphicsType()) {
         clear_has_ChannelGraphicsType();
        _ChannelGraphicsType = 0u;
     }
}

inline bool GetChannelArtListStart::hasChannelGraphicsType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetChannelArtListStart::getChannelGraphicsType () const {
    return _ChannelGraphicsType;
}

inline void GetChannelArtListStart::setChannelGraphicsType (uint8 ChannelGraphicsType_) {
    set_has_ChannelGraphicsType();
    this->_ChannelGraphicsType = ChannelGraphicsType_;
}

inline void GetChannelArtListStart::set_has_ListOfSID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetChannelArtListStart::clear_has_ListOfSID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetChannelArtListStart::set_has_ChannelGraphicsType () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetChannelArtListStart::clear_has_ChannelGraphicsType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetChannelArtListResult::GetChannelArtListResult ()  :
    _ChannelGraphicsType (0u),
    _ImageDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetChannelArtListResult::GetChannelArtListResult (const GetChannelArtListResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ChannelGraphicsType (0u),
    _ImageDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetChannelArtListResult::GetChannelArtListResult (uint8 ChannelGraphicsType_, const ::std::vector< ::sxm_channelart_main_fi_types::T_ImageData >& ImageDataList_)  :
    _ChannelGraphicsType (ChannelGraphicsType_),
    _ImageDataList (ImageDataList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetChannelArtListResult::~GetChannelArtListResult() {
}

inline GetChannelArtListResult& GetChannelArtListResult::operator = (const GetChannelArtListResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChannelGraphicsType()) {
            setChannelGraphicsType(rhs.getChannelGraphicsType());
        } else {
            clearChannelGraphicsType();
        }
        if (rhs.hasImageDataList()) {
            setImageDataList(rhs.getImageDataList());
        } else {
            clearImageDataList();
        }
    }
    return *this;
}

inline bool GetChannelArtListResult::operator == (const GetChannelArtListResult& rhs) const {
    return (((!hasChannelGraphicsType() && !rhs.hasChannelGraphicsType()) || getChannelGraphicsType() == rhs.getChannelGraphicsType()) &&
        ((!hasImageDataList() && !rhs.hasImageDataList()) || getImageDataList() == rhs.getImageDataList()));
}

inline bool GetChannelArtListResult::operator != (const GetChannelArtListResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetChannelArtListResult::operator < (const GetChannelArtListResult& rhs) const {
    if (hasChannelGraphicsType() || rhs.hasChannelGraphicsType()) {
        if (getChannelGraphicsType() < rhs.getChannelGraphicsType()) return true;
        if (getChannelGraphicsType() > rhs.getChannelGraphicsType()) return false;
    }
    if (hasImageDataList() || rhs.hasImageDataList()) {
        if (getImageDataList() < rhs.getImageDataList()) return true;
        if (getImageDataList() > rhs.getImageDataList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetChannelArtListResult::clone() {
    return new GetChannelArtListResult(*this);
}

inline bool GetChannelArtListResult::operator > (const GetChannelArtListResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetChannelArtListResult::clear() {
    clearChannelGraphicsType();
    clearImageDataList();
}

inline void GetChannelArtListResult::clearChannelGraphicsType() {
    if (hasChannelGraphicsType()) {
         clear_has_ChannelGraphicsType();
        _ChannelGraphicsType = 0u;
     }
}

inline bool GetChannelArtListResult::hasChannelGraphicsType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetChannelArtListResult::getChannelGraphicsType () const {
    return _ChannelGraphicsType;
}

inline void GetChannelArtListResult::setChannelGraphicsType (uint8 ChannelGraphicsType_) {
    set_has_ChannelGraphicsType();
    this->_ChannelGraphicsType = ChannelGraphicsType_;
}

inline void GetChannelArtListResult::clearImageDataList() {
    if (hasImageDataList()) {
         clear_has_ImageDataList();
        _ImageDataList.clear();
     }
}

inline bool GetChannelArtListResult::hasImageDataList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::sxm_channelart_main_fi_types::T_ImageData >& GetChannelArtListResult::getImageDataList () const {
    return _ImageDataList;
}

inline ::std::vector< ::sxm_channelart_main_fi_types::T_ImageData >& GetChannelArtListResult::getImageDataListMutable () {
    set_has_ImageDataList();
    return _ImageDataList;
}

inline void GetChannelArtListResult::setImageDataList (const ::std::vector< ::sxm_channelart_main_fi_types::T_ImageData >& ImageDataList_) {
    set_has_ImageDataList();
    this->_ImageDataList = ImageDataList_;
}

inline void GetChannelArtListResult::set_has_ChannelGraphicsType () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetChannelArtListResult::clear_has_ChannelGraphicsType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetChannelArtListResult::set_has_ImageDataList () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetChannelArtListResult::clear_has_ImageDataList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetChannelArtListErrorStructure::GetChannelArtListErrorStructure ()  :
    _ErrorCode (::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes__CHANNELART_SERVICE_ERROR)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetChannelArtListErrorStructure::GetChannelArtListErrorStructure (const GetChannelArtListErrorStructure &rhs)  :
    _ErrorCode (::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes__CHANNELART_SERVICE_ERROR)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetChannelArtListErrorStructure::GetChannelArtListErrorStructure (::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8ChannelArtErrorTypes", "ErrorCode", "GetChannelArtListErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetChannelArtListErrorStructure::~GetChannelArtListErrorStructure() {
}

inline GetChannelArtListErrorStructure& GetChannelArtListErrorStructure::operator = (const GetChannelArtListErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetChannelArtListErrorStructure::operator == (const GetChannelArtListErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetChannelArtListErrorStructure::operator != (const GetChannelArtListErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetChannelArtListErrorStructure::operator < (const GetChannelArtListErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetChannelArtListErrorStructure::operator > (const GetChannelArtListErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetChannelArtListErrorStructure::clear() {
    clearErrorCode();
}

inline void GetChannelArtListErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes__CHANNELART_SERVICE_ERROR;
     }
}

inline bool GetChannelArtListErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes GetChannelArtListErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetChannelArtListErrorStructure::setErrorCode (::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_channelart_main_fi_types::T_e8ChannelArtErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8ChannelArtErrorTypes", "ErrorCode", "GetChannelArtListErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetChannelArtListErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetChannelArtListErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetChannelArtListError::GetChannelArtListError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetChannelArtListError::GetChannelArtListError (const GetChannelArtListError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetChannelArtListError::~GetChannelArtListError() {
    deleteData ();
}

inline GetChannelArtListError& GetChannelArtListError::operator = (const GetChannelArtListError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetChannelArtListError::operator == (const GetChannelArtListError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetChannelArtListError::operator != (const GetChannelArtListError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetChannelArtListError::operator < (const GetChannelArtListError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetChannelArtListError::operator > (const GetChannelArtListError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetChannelArtListError::GetChannelArtListErrorField GetChannelArtListError::getField () const {
    return __field;
}

inline void GetChannelArtListError::setField(GetChannelArtListError::GetChannelArtListErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetChannelArtListError::clone() {
    return new GetChannelArtListError(*this);
}

inline bool GetChannelArtListError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetChannelArtListErrorStructure& GetChannelArtListError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetChannelArtListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetChannelArtListErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetChannelArtListErrorStructure& GetChannelArtListError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetChannelArtListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetChannelArtListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetChannelArtListErrorStructure* GetChannelArtListError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetChannelArtListError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetChannelArtListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetChannelArtListErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetChannelArtListError::replaceCcaErrorCode (GetChannelArtListErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetChannelArtListError::setCcaErrorCode (const GetChannelArtListErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetChannelArtListErrorStructure(value);
    }
}

inline bool GetChannelArtListError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetChannelArtListError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetChannelArtListError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetChannelArtListError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetChannelArtListError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetChannelArtListError::cloneData (const GetChannelArtListError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetChannelArtListErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetChannelArtListErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetChannelArtListError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus ()  :
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_)  :
    _DataServiceState (DataServiceState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::~SxmDataServiceStatusStatus() {
}

inline SxmDataServiceStatusStatus& SxmDataServiceStatusStatus::operator = (const SxmDataServiceStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataServiceState()) {
            setDataServiceState(rhs.getDataServiceState());
        } else {
            clearDataServiceState();
        }
    }
    return *this;
}

inline bool SxmDataServiceStatusStatus::operator == (const SxmDataServiceStatusStatus& rhs) const {
    return (((!hasDataServiceState() && !rhs.hasDataServiceState()) || getDataServiceState() == rhs.getDataServiceState()));
}

inline bool SxmDataServiceStatusStatus::operator != (const SxmDataServiceStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmDataServiceStatusStatus::operator < (const SxmDataServiceStatusStatus& rhs) const {
    if (hasDataServiceState() || rhs.hasDataServiceState()) {
        if (getDataServiceState() < rhs.getDataServiceState()) return true;
        if (getDataServiceState() > rhs.getDataServiceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmDataServiceStatusStatus::clone() {
    return new SxmDataServiceStatusStatus(*this);
}

inline bool SxmDataServiceStatusStatus::operator > (const SxmDataServiceStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmDataServiceStatusStatus::clear() {
    clearDataServiceState();
}

inline void SxmDataServiceStatusStatus::clearDataServiceState() {
    if (hasDataServiceState()) {
         clear_has_DataServiceState();
        _DataServiceState.clear();
     }
}

inline bool SxmDataServiceStatusStatus::hasDataServiceState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceState () const {
    return _DataServiceState;
}

inline ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceStateMutable () {
    set_has_DataServiceState();
    return _DataServiceState;
}

inline void SxmDataServiceStatusStatus::setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_) {
    set_has_DataServiceState();
    this->_DataServiceState = DataServiceState_;
}

inline void SxmDataServiceStatusStatus::set_has_DataServiceState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmDataServiceStatusStatus::clear_has_DataServiceState () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace sxm_channelart_main_fi

#endif // SXM_CHANNELART_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
