#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_CANADIAN_FUEL_MAIN_FI_TYPES_H
#define SXM_CANADIAN_FUEL_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_canadian_fuel_main_fi_typesConst.h"
#include "sxm_main_fi_types.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sxm_canadian_fuel_main_fi_types
 */

namespace sxm_canadian_fuel_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_CanFuelInfo;

class T_CanFuelTypeInfo;

class T_CanFuelTypeInfolist;

class T_CanFuelStationInfo;

// type definitions
/**
 * If the meaning of "T_CanFuelInfoList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_CanFuelInfo > T_CanFuelInfoList;

/**
 * If the meaning of "T_CanBrandNameList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< ::std::string > T_CanBrandNameList;

/**
 * If the meaning of "T_CanFuelTypeList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_CanFuelTypeInfo > T_CanFuelTypeList;


/**
 * If the meaning of "T_CanFuelInfo" isn't clear, then there should be a description here.
 */
class T_CanFuelInfo {
public:

    /**
     * Default constructor
     */
    inline  T_CanFuelInfo ();

    /**
     * Copy constructor
     */
    inline  T_CanFuelInfo (const T_CanFuelInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_CanFuelInfo (const ::std::string& StationName_, const ::std::string& Brand_, T_e8_CanFuelTypeEnum CanFuelType_, uint32 CanFuel_LOCID_, const ::std::string& CanFuelName_, const ::std::string& CanFuelPrice_, uint8 CanFuelAge_, const ::sxm_main_fi_types::T_SxmLocation& CanFuelLoc_, float CanFuelDistKm_, float CanFuelDistMile_, uint32 NumPrices_);

    /**
     * Destructor
     */
    inline  ~T_CanFuelInfo();

    /**
     * Assignment operator
     */
    inline T_CanFuelInfo& operator = (const T_CanFuelInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CanFuelInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CanFuelInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CanFuelInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CanFuelInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StationName"

    static const int kStationName = 0;

    /**
     * Clears the field "StationName".
     *
     * The field will be set to its default value. The hasStationName()
     * method will return false.
     */
    inline void clearStationName();

    /**
     * Checks whether the field "StationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationName()). Otherwise it will return false.
     */
    inline bool hasStationName () const;

    /**
     * Returns the value of the member "StationName".
     *
     * Station Name
     *
     * @return The value of the field "StationName"
     */
    inline const ::std::string& getStationName () const;

    /**
     * Retrieves the value of the field "StationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StationName".
     */
    inline ::std::string& getStationNameMutable ();

    /**
     * Sets the value of the member "StationName".
     *
     * Station Name
     *
     * @param StationName The value which will be set
     */
    inline void setStationName (const ::std::string& StationName_);

    /**
     * Sets the value of the member "StationName".
     *
     * Station Name
     *
     * @param StationName The value which will be set
     */
    inline void setStationName (const char* StationName_);

    /**
     * Sets the value of the member "StationName".
     *
     * Station Name
     *
     * @param StationName The value which will be set
     */
    inline void setStationName (const char* value, size_t size);

    // API of field "Brand"

    static const int kBrand = 1;

    /**
     * Clears the field "Brand".
     *
     * The field will be set to its default value. The hasBrand()
     * method will return false.
     */
    inline void clearBrand();

    /**
     * Checks whether the field "Brand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrand()). Otherwise it will return false.
     */
    inline bool hasBrand () const;

    /**
     * Returns the value of the member "Brand".
     *
     * Brand Name
     *
     * @return The value of the field "Brand"
     */
    inline const ::std::string& getBrand () const;

    /**
     * Retrieves the value of the field "Brand" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Brand".
     */
    inline ::std::string& getBrandMutable ();

    /**
     * Sets the value of the member "Brand".
     *
     * Brand Name
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const ::std::string& Brand_);

    /**
     * Sets the value of the member "Brand".
     *
     * Brand Name
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const char* Brand_);

    /**
     * Sets the value of the member "Brand".
     *
     * Brand Name
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const char* value, size_t size);

    // API of field "CanFuelType"

    static const int kCanFuelType = 2;

    /**
     * Clears the field "CanFuelType".
     *
     * The field will be set to its default value. The hasCanFuelType()
     * method will return false.
     */
    inline void clearCanFuelType();

    /**
     * Checks whether the field "CanFuelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuelType()). Otherwise it will return false.
     */
    inline bool hasCanFuelType () const;

    /**
     * Returns the value of the member "CanFuelType".
     *
     * Canadian Fuel Type
     *
     * @return The value of the field "CanFuelType"
     */
    inline T_e8_CanFuelTypeEnum getCanFuelType () const;

    /**
     * Sets the value of the member "CanFuelType".
     *
     * Canadian Fuel Type
     *
     * @param CanFuelType The value which will be set
     */
    inline void setCanFuelType (T_e8_CanFuelTypeEnum CanFuelType_);

    // API of field "CanFuel_LOCID"

    static const int kCanFuel_LOCID = 3;

    /**
     * Clears the field "CanFuel_LOCID".
     *
     * The field will be set to its default value. The hasCanFuel_LOCID()
     * method will return false.
     */
    inline void clearCanFuel_LOCID();

    /**
     * Checks whether the field "CanFuel_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuel_LOCID()). Otherwise it will return false.
     */
    inline bool hasCanFuel_LOCID () const;

    /**
     * Returns the value of the member "CanFuel_LOCID".
     *
     * LOCID
     *
     * @return The value of the field "CanFuel_LOCID"
     */
    inline uint32 getCanFuel_LOCID () const;

    /**
     * Sets the value of the member "CanFuel_LOCID".
     *
     * LOCID
     *
     * @param CanFuel_LOCID The value which will be set
     */
    inline void setCanFuel_LOCID (uint32 CanFuel_LOCID_);

    // API of field "CanFuelName"

    static const int kCanFuelName = 4;

    /**
     * Clears the field "CanFuelName".
     *
     * The field will be set to its default value. The hasCanFuelName()
     * method will return false.
     */
    inline void clearCanFuelName();

    /**
     * Checks whether the field "CanFuelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuelName()). Otherwise it will return false.
     */
    inline bool hasCanFuelName () const;

    /**
     * Returns the value of the member "CanFuelName".
     *
     * Fuel Name
     *
     * @return The value of the field "CanFuelName"
     */
    inline const ::std::string& getCanFuelName () const;

    /**
     * Retrieves the value of the field "CanFuelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CanFuelName".
     */
    inline ::std::string& getCanFuelNameMutable ();

    /**
     * Sets the value of the member "CanFuelName".
     *
     * Fuel Name
     *
     * @param CanFuelName The value which will be set
     */
    inline void setCanFuelName (const ::std::string& CanFuelName_);

    /**
     * Sets the value of the member "CanFuelName".
     *
     * Fuel Name
     *
     * @param CanFuelName The value which will be set
     */
    inline void setCanFuelName (const char* CanFuelName_);

    /**
     * Sets the value of the member "CanFuelName".
     *
     * Fuel Name
     *
     * @param CanFuelName The value which will be set
     */
    inline void setCanFuelName (const char* value, size_t size);

    // API of field "CanFuelPrice"

    static const int kCanFuelPrice = 5;

    /**
     * Clears the field "CanFuelPrice".
     *
     * The field will be set to its default value. The hasCanFuelPrice()
     * method will return false.
     */
    inline void clearCanFuelPrice();

    /**
     * Checks whether the field "CanFuelPrice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuelPrice()). Otherwise it will return false.
     */
    inline bool hasCanFuelPrice () const;

    /**
     * Returns the value of the member "CanFuelPrice".
     *
     * Fuel Price
     *
     * @return The value of the field "CanFuelPrice"
     */
    inline const ::std::string& getCanFuelPrice () const;

    /**
     * Retrieves the value of the field "CanFuelPrice" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CanFuelPrice".
     */
    inline ::std::string& getCanFuelPriceMutable ();

    /**
     * Sets the value of the member "CanFuelPrice".
     *
     * Fuel Price
     *
     * @param CanFuelPrice The value which will be set
     */
    inline void setCanFuelPrice (const ::std::string& CanFuelPrice_);

    /**
     * Sets the value of the member "CanFuelPrice".
     *
     * Fuel Price
     *
     * @param CanFuelPrice The value which will be set
     */
    inline void setCanFuelPrice (const char* CanFuelPrice_);

    /**
     * Sets the value of the member "CanFuelPrice".
     *
     * Fuel Price
     *
     * @param CanFuelPrice The value which will be set
     */
    inline void setCanFuelPrice (const char* value, size_t size);

    // API of field "CanFuelAge"

    static const int kCanFuelAge = 6;

    /**
     * Clears the field "CanFuelAge".
     *
     * The field will be set to its default value. The hasCanFuelAge()
     * method will return false.
     */
    inline void clearCanFuelAge();

    /**
     * Checks whether the field "CanFuelAge" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuelAge()). Otherwise it will return false.
     */
    inline bool hasCanFuelAge () const;

    /**
     * Returns the value of the member "CanFuelAge".
     *
     * Fuel Age
     *
     * @return The value of the field "CanFuelAge"
     */
    inline uint8 getCanFuelAge () const;

    /**
     * Sets the value of the member "CanFuelAge".
     *
     * Fuel Age
     *
     * @param CanFuelAge The value which will be set
     */
    inline void setCanFuelAge (uint8 CanFuelAge_);

    // API of field "CanFuelLoc"

    static const int kCanFuelLoc = 7;

    /**
     * Clears the field "CanFuelLoc".
     *
     * The field will be set to its default value. The hasCanFuelLoc()
     * method will return false.
     */
    inline void clearCanFuelLoc();

    /**
     * Checks whether the field "CanFuelLoc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuelLoc()). Otherwise it will return false.
     */
    inline bool hasCanFuelLoc () const;

    /**
     * Returns the value of the member "CanFuelLoc".
     *
     * Fuel Location information
     *
     * @return The value of the field "CanFuelLoc"
     */
    inline const ::sxm_main_fi_types::T_SxmLocation& getCanFuelLoc () const;

    /**
     * Retrieves the value of the field "CanFuelLoc" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CanFuelLoc".
     */
    inline ::sxm_main_fi_types::T_SxmLocation& getCanFuelLocMutable ();

    /**
     * Sets the value of the member "CanFuelLoc".
     *
     * Fuel Location information
     *
     * @param CanFuelLoc The value which will be set
     */
    inline void setCanFuelLoc (const ::sxm_main_fi_types::T_SxmLocation& CanFuelLoc_);

    // API of field "CanFuelDistKm"

    static const int kCanFuelDistKm = 8;

    /**
     * Clears the field "CanFuelDistKm".
     *
     * The field will be set to its default value. The hasCanFuelDistKm()
     * method will return false.
     */
    inline void clearCanFuelDistKm();

    /**
     * Checks whether the field "CanFuelDistKm" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuelDistKm()). Otherwise it will return false.
     */
    inline bool hasCanFuelDistKm () const;

    /**
     * Returns the value of the member "CanFuelDistKm".
     *
     * Fuel station Distance Info in Kilometer
     *
     * @return The value of the field "CanFuelDistKm"
     */
    inline float getCanFuelDistKm () const;

    /**
     * Sets the value of the member "CanFuelDistKm".
     *
     * Fuel station Distance Info in Kilometer
     *
     * @param CanFuelDistKm The value which will be set
     */
    inline void setCanFuelDistKm (float CanFuelDistKm_);

    // API of field "CanFuelDistMile"

    static const int kCanFuelDistMile = 9;

    /**
     * Clears the field "CanFuelDistMile".
     *
     * The field will be set to its default value. The hasCanFuelDistMile()
     * method will return false.
     */
    inline void clearCanFuelDistMile();

    /**
     * Checks whether the field "CanFuelDistMile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuelDistMile()). Otherwise it will return false.
     */
    inline bool hasCanFuelDistMile () const;

    /**
     * Returns the value of the member "CanFuelDistMile".
     *
     * Fuel station Distance Info in Miles
     *
     * @return The value of the field "CanFuelDistMile"
     */
    inline float getCanFuelDistMile () const;

    /**
     * Sets the value of the member "CanFuelDistMile".
     *
     * Fuel station Distance Info in Miles
     *
     * @param CanFuelDistMile The value which will be set
     */
    inline void setCanFuelDistMile (float CanFuelDistMile_);

    // API of field "NumPrices"

    static const int kNumPrices = 10;

    /**
     * Clears the field "NumPrices".
     *
     * The field will be set to its default value. The hasNumPrices()
     * method will return false.
     */
    inline void clearNumPrices();

    /**
     * Checks whether the field "NumPrices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumPrices()). Otherwise it will return false.
     */
    inline bool hasNumPrices () const;

    /**
     * Returns the value of the member "NumPrices".
     *
     * Number of fuel price
     *
     * @return The value of the field "NumPrices"
     */
    inline uint32 getNumPrices () const;

    /**
     * Sets the value of the member "NumPrices".
     *
     * Number of fuel price
     *
     * @param NumPrices The value which will be set
     */
    inline void setNumPrices (uint32 NumPrices_);

    static const T_CanFuelInfo &getDefaultInstance();

private:

    inline void set_has_StationName ();

    inline void clear_has_StationName ();

    inline void set_has_Brand ();

    inline void clear_has_Brand ();

    inline void set_has_CanFuelType ();

    inline void clear_has_CanFuelType ();

    inline void set_has_CanFuel_LOCID ();

    inline void clear_has_CanFuel_LOCID ();

    inline void set_has_CanFuelName ();

    inline void clear_has_CanFuelName ();

    inline void set_has_CanFuelPrice ();

    inline void clear_has_CanFuelPrice ();

    inline void set_has_CanFuelAge ();

    inline void clear_has_CanFuelAge ();

    inline void set_has_CanFuelLoc ();

    inline void clear_has_CanFuelLoc ();

    inline void set_has_CanFuelDistKm ();

    inline void clear_has_CanFuelDistKm ();

    inline void set_has_CanFuelDistMile ();

    inline void clear_has_CanFuelDistMile ();

    inline void set_has_NumPrices ();

    inline void clear_has_NumPrices ();

    uint32 _has_bits_[ (11 + 31) / 32];

    ::std::string _StationName;

    ::std::string _Brand;

    T_e8_CanFuelTypeEnum _CanFuelType;

    uint32 _CanFuel_LOCID;

    ::std::string _CanFuelName;

    ::std::string _CanFuelPrice;

    uint8 _CanFuelAge;

    ::sxm_main_fi_types::T_SxmLocation _CanFuelLoc;

    float _CanFuelDistKm;

    float _CanFuelDistMile;

    uint32 _NumPrices;

};

/**
 * If the meaning of "T_CanFuelTypeInfo" isn't clear, then there should be a description here.
 */
class T_CanFuelTypeInfo {
public:

    /**
     * Default constructor
     */
    inline  T_CanFuelTypeInfo ();

    /**
     * Copy constructor
     */
    inline  T_CanFuelTypeInfo (const T_CanFuelTypeInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_CanFuelTypeInfo (T_e8_CanFuelTypeEnum CanFuelType_, const ::std::string& CanFuelName_);

    /**
     * Destructor
     */
    inline  ~T_CanFuelTypeInfo();

    /**
     * Assignment operator
     */
    inline T_CanFuelTypeInfo& operator = (const T_CanFuelTypeInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CanFuelTypeInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CanFuelTypeInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CanFuelTypeInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CanFuelTypeInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CanFuelType"

    static const int kCanFuelType = 0;

    /**
     * Clears the field "CanFuelType".
     *
     * The field will be set to its default value. The hasCanFuelType()
     * method will return false.
     */
    inline void clearCanFuelType();

    /**
     * Checks whether the field "CanFuelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuelType()). Otherwise it will return false.
     */
    inline bool hasCanFuelType () const;

    /**
     * Returns the value of the member "CanFuelType".
     *
     * Canadian Fuel Type
     *
     * @return The value of the field "CanFuelType"
     */
    inline T_e8_CanFuelTypeEnum getCanFuelType () const;

    /**
     * Sets the value of the member "CanFuelType".
     *
     * Canadian Fuel Type
     *
     * @param CanFuelType The value which will be set
     */
    inline void setCanFuelType (T_e8_CanFuelTypeEnum CanFuelType_);

    // API of field "CanFuelName"

    static const int kCanFuelName = 1;

    /**
     * Clears the field "CanFuelName".
     *
     * The field will be set to its default value. The hasCanFuelName()
     * method will return false.
     */
    inline void clearCanFuelName();

    /**
     * Checks whether the field "CanFuelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuelName()). Otherwise it will return false.
     */
    inline bool hasCanFuelName () const;

    /**
     * Returns the value of the member "CanFuelName".
     *
     * Canadian Fuel Name
     *
     * @return The value of the field "CanFuelName"
     */
    inline const ::std::string& getCanFuelName () const;

    /**
     * Retrieves the value of the field "CanFuelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CanFuelName".
     */
    inline ::std::string& getCanFuelNameMutable ();

    /**
     * Sets the value of the member "CanFuelName".
     *
     * Canadian Fuel Name
     *
     * @param CanFuelName The value which will be set
     */
    inline void setCanFuelName (const ::std::string& CanFuelName_);

    /**
     * Sets the value of the member "CanFuelName".
     *
     * Canadian Fuel Name
     *
     * @param CanFuelName The value which will be set
     */
    inline void setCanFuelName (const char* CanFuelName_);

    /**
     * Sets the value of the member "CanFuelName".
     *
     * Canadian Fuel Name
     *
     * @param CanFuelName The value which will be set
     */
    inline void setCanFuelName (const char* value, size_t size);

    static const T_CanFuelTypeInfo &getDefaultInstance();

private:

    inline void set_has_CanFuelType ();

    inline void clear_has_CanFuelType ();

    inline void set_has_CanFuelName ();

    inline void clear_has_CanFuelName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_CanFuelTypeEnum _CanFuelType;

    ::std::string _CanFuelName;

};

/**
 * If the meaning of "T_CanFuelTypeInfolist" isn't clear, then there should be a description here.
 */
class T_CanFuelTypeInfolist {
public:

    /**
     * Default constructor
     */
    inline  T_CanFuelTypeInfolist ();

    /**
     * Copy constructor
     */
    inline  T_CanFuelTypeInfolist (const T_CanFuelTypeInfolist &rhs);

    /**
     * All fields constructor
     */
    inline  T_CanFuelTypeInfolist (const ::std::string& FuelName_, const ::std::string& FuelPrice_, uint8 FuelAge_, bool FuelAvail_, T_e8_CanFuelTypeEnum FuelType_);

    /**
     * Destructor
     */
    inline  ~T_CanFuelTypeInfolist();

    /**
     * Assignment operator
     */
    inline T_CanFuelTypeInfolist& operator = (const T_CanFuelTypeInfolist& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CanFuelTypeInfolist& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CanFuelTypeInfolist& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CanFuelTypeInfolist& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CanFuelTypeInfolist& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FuelName"

    static const int kFuelName = 0;

    /**
     * Clears the field "FuelName".
     *
     * The field will be set to its default value. The hasFuelName()
     * method will return false.
     */
    inline void clearFuelName();

    /**
     * Checks whether the field "FuelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelName()). Otherwise it will return false.
     */
    inline bool hasFuelName () const;

    /**
     * Returns the value of the member "FuelName".
     *
     * Canadian Fuel Name
     *
     * @return The value of the field "FuelName"
     */
    inline const ::std::string& getFuelName () const;

    /**
     * Retrieves the value of the field "FuelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelName".
     */
    inline ::std::string& getFuelNameMutable ();

    /**
     * Sets the value of the member "FuelName".
     *
     * Canadian Fuel Name
     *
     * @param FuelName The value which will be set
     */
    inline void setFuelName (const ::std::string& FuelName_);

    /**
     * Sets the value of the member "FuelName".
     *
     * Canadian Fuel Name
     *
     * @param FuelName The value which will be set
     */
    inline void setFuelName (const char* FuelName_);

    /**
     * Sets the value of the member "FuelName".
     *
     * Canadian Fuel Name
     *
     * @param FuelName The value which will be set
     */
    inline void setFuelName (const char* value, size_t size);

    // API of field "FuelPrice"

    static const int kFuelPrice = 1;

    /**
     * Clears the field "FuelPrice".
     *
     * The field will be set to its default value. The hasFuelPrice()
     * method will return false.
     */
    inline void clearFuelPrice();

    /**
     * Checks whether the field "FuelPrice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelPrice()). Otherwise it will return false.
     */
    inline bool hasFuelPrice () const;

    /**
     * Returns the value of the member "FuelPrice".
     *
     * Fuel Price
     *
     * @return The value of the field "FuelPrice"
     */
    inline const ::std::string& getFuelPrice () const;

    /**
     * Retrieves the value of the field "FuelPrice" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelPrice".
     */
    inline ::std::string& getFuelPriceMutable ();

    /**
     * Sets the value of the member "FuelPrice".
     *
     * Fuel Price
     *
     * @param FuelPrice The value which will be set
     */
    inline void setFuelPrice (const ::std::string& FuelPrice_);

    /**
     * Sets the value of the member "FuelPrice".
     *
     * Fuel Price
     *
     * @param FuelPrice The value which will be set
     */
    inline void setFuelPrice (const char* FuelPrice_);

    /**
     * Sets the value of the member "FuelPrice".
     *
     * Fuel Price
     *
     * @param FuelPrice The value which will be set
     */
    inline void setFuelPrice (const char* value, size_t size);

    // API of field "FuelAge"

    static const int kFuelAge = 2;

    /**
     * Clears the field "FuelAge".
     *
     * The field will be set to its default value. The hasFuelAge()
     * method will return false.
     */
    inline void clearFuelAge();

    /**
     * Checks whether the field "FuelAge" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelAge()). Otherwise it will return false.
     */
    inline bool hasFuelAge () const;

    /**
     * Returns the value of the member "FuelAge".
     *
     * Fuel Age
     *
     * @return The value of the field "FuelAge"
     */
    inline uint8 getFuelAge () const;

    /**
     * Sets the value of the member "FuelAge".
     *
     * Fuel Age
     *
     * @param FuelAge The value which will be set
     */
    inline void setFuelAge (uint8 FuelAge_);

    // API of field "FuelAvail"

    static const int kFuelAvail = 3;

    /**
     * Clears the field "FuelAvail".
     *
     * The field will be set to its default value. The hasFuelAvail()
     * method will return false.
     */
    inline void clearFuelAvail();

    /**
     * Checks whether the field "FuelAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelAvail()). Otherwise it will return false.
     */
    inline bool hasFuelAvail () const;

    /**
     * Returns the value of the member "FuelAvail".
     *
     * Fuel Availability
     *
     * @return The value of the field "FuelAvail"
     */
    inline bool getFuelAvail () const;

    /**
     * Sets the value of the member "FuelAvail".
     *
     * Fuel Availability
     *
     * @param FuelAvail The value which will be set
     */
    inline void setFuelAvail (bool FuelAvail_);

    // API of field "FuelType"

    static const int kFuelType = 4;

    /**
     * Clears the field "FuelType".
     *
     * The field will be set to its default value. The hasFuelType()
     * method will return false.
     */
    inline void clearFuelType();

    /**
     * Checks whether the field "FuelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelType()). Otherwise it will return false.
     */
    inline bool hasFuelType () const;

    /**
     * Returns the value of the member "FuelType".
     *
     * Fuel Type
     *
     * @return The value of the field "FuelType"
     */
    inline T_e8_CanFuelTypeEnum getFuelType () const;

    /**
     * Sets the value of the member "FuelType".
     *
     * Fuel Type
     *
     * @param FuelType The value which will be set
     */
    inline void setFuelType (T_e8_CanFuelTypeEnum FuelType_);

    static const T_CanFuelTypeInfolist &getDefaultInstance();

private:

    inline void set_has_FuelName ();

    inline void clear_has_FuelName ();

    inline void set_has_FuelPrice ();

    inline void clear_has_FuelPrice ();

    inline void set_has_FuelAge ();

    inline void clear_has_FuelAge ();

    inline void set_has_FuelAvail ();

    inline void clear_has_FuelAvail ();

    inline void set_has_FuelType ();

    inline void clear_has_FuelType ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _FuelName;

    ::std::string _FuelPrice;

    uint8 _FuelAge;

    bool _FuelAvail;

    T_e8_CanFuelTypeEnum _FuelType;

};

/**
 * If the meaning of "T_CanFuelStationInfo" isn't clear, then there should be a description here.
 */
class T_CanFuelStationInfo {
public:

    /**
     * Default constructor
     */
    inline  T_CanFuelStationInfo ();

    /**
     * Copy constructor
     */
    inline  T_CanFuelStationInfo (const T_CanFuelStationInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_CanFuelStationInfo (const ::std::string& StationName_, const ::std::string& Brand_, const ::std::string& StreetName_, const ::std::string& City_, const ::std::string& State_, const ::std::string& ZipCode_, const ::std::string& Phone_, uint32 Fuel_LOCID_, const ::std::string& Amenity_, bool CanFuelFavInfo_, const ::sxm_main_fi_types::T_SxmLocation& CanFuelLocation_, const ::std::vector< T_CanFuelTypeInfolist >& CanFuelTypelist_, const ::std::vector< T_e8_CanFuelStationAmenity >& StationAmenitylist_, uint32 NumPrices_);

    /**
     * Destructor
     */
    inline  ~T_CanFuelStationInfo();

    /**
     * Assignment operator
     */
    inline T_CanFuelStationInfo& operator = (const T_CanFuelStationInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CanFuelStationInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CanFuelStationInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CanFuelStationInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CanFuelStationInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StationName"

    static const int kStationName = 0;

    /**
     * Clears the field "StationName".
     *
     * The field will be set to its default value. The hasStationName()
     * method will return false.
     */
    inline void clearStationName();

    /**
     * Checks whether the field "StationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationName()). Otherwise it will return false.
     */
    inline bool hasStationName () const;

    /**
     * Returns the value of the member "StationName".
     *
     * Station Name
     *
     * @return The value of the field "StationName"
     */
    inline const ::std::string& getStationName () const;

    /**
     * Retrieves the value of the field "StationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StationName".
     */
    inline ::std::string& getStationNameMutable ();

    /**
     * Sets the value of the member "StationName".
     *
     * Station Name
     *
     * @param StationName The value which will be set
     */
    inline void setStationName (const ::std::string& StationName_);

    /**
     * Sets the value of the member "StationName".
     *
     * Station Name
     *
     * @param StationName The value which will be set
     */
    inline void setStationName (const char* StationName_);

    /**
     * Sets the value of the member "StationName".
     *
     * Station Name
     *
     * @param StationName The value which will be set
     */
    inline void setStationName (const char* value, size_t size);

    // API of field "Brand"

    static const int kBrand = 1;

    /**
     * Clears the field "Brand".
     *
     * The field will be set to its default value. The hasBrand()
     * method will return false.
     */
    inline void clearBrand();

    /**
     * Checks whether the field "Brand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrand()). Otherwise it will return false.
     */
    inline bool hasBrand () const;

    /**
     * Returns the value of the member "Brand".
     *
     * Brand Name
     *
     * @return The value of the field "Brand"
     */
    inline const ::std::string& getBrand () const;

    /**
     * Retrieves the value of the field "Brand" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Brand".
     */
    inline ::std::string& getBrandMutable ();

    /**
     * Sets the value of the member "Brand".
     *
     * Brand Name
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const ::std::string& Brand_);

    /**
     * Sets the value of the member "Brand".
     *
     * Brand Name
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const char* Brand_);

    /**
     * Sets the value of the member "Brand".
     *
     * Brand Name
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const char* value, size_t size);

    // API of field "StreetName"

    static const int kStreetName = 2;

    /**
     * Clears the field "StreetName".
     *
     * The field will be set to its default value. The hasStreetName()
     * method will return false.
     */
    inline void clearStreetName();

    /**
     * Checks whether the field "StreetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStreetName()). Otherwise it will return false.
     */
    inline bool hasStreetName () const;

    /**
     * Returns the value of the member "StreetName".
     *
     * StreetName
     *
     * @return The value of the field "StreetName"
     */
    inline const ::std::string& getStreetName () const;

    /**
     * Retrieves the value of the field "StreetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StreetName".
     */
    inline ::std::string& getStreetNameMutable ();

    /**
     * Sets the value of the member "StreetName".
     *
     * StreetName
     *
     * @param StreetName The value which will be set
     */
    inline void setStreetName (const ::std::string& StreetName_);

    /**
     * Sets the value of the member "StreetName".
     *
     * StreetName
     *
     * @param StreetName The value which will be set
     */
    inline void setStreetName (const char* StreetName_);

    /**
     * Sets the value of the member "StreetName".
     *
     * StreetName
     *
     * @param StreetName The value which will be set
     */
    inline void setStreetName (const char* value, size_t size);

    // API of field "City"

    static const int kCity = 3;

    /**
     * Clears the field "City".
     *
     * The field will be set to its default value. The hasCity()
     * method will return false.
     */
    inline void clearCity();

    /**
     * Checks whether the field "City" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCity()). Otherwise it will return false.
     */
    inline bool hasCity () const;

    /**
     * Returns the value of the member "City".
     *
     * City
     *
     * @return The value of the field "City"
     */
    inline const ::std::string& getCity () const;

    /**
     * Retrieves the value of the field "City" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "City".
     */
    inline ::std::string& getCityMutable ();

    /**
     * Sets the value of the member "City".
     *
     * City
     *
     * @param City The value which will be set
     */
    inline void setCity (const ::std::string& City_);

    /**
     * Sets the value of the member "City".
     *
     * City
     *
     * @param City The value which will be set
     */
    inline void setCity (const char* City_);

    /**
     * Sets the value of the member "City".
     *
     * City
     *
     * @param City The value which will be set
     */
    inline void setCity (const char* value, size_t size);

    // API of field "State"

    static const int kState = 4;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * State
     *
     * @return The value of the field "State"
     */
    inline const ::std::string& getState () const;

    /**
     * Retrieves the value of the field "State" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "State".
     */
    inline ::std::string& getStateMutable ();

    /**
     * Sets the value of the member "State".
     *
     * State
     *
     * @param State The value which will be set
     */
    inline void setState (const ::std::string& State_);

    /**
     * Sets the value of the member "State".
     *
     * State
     *
     * @param State The value which will be set
     */
    inline void setState (const char* State_);

    /**
     * Sets the value of the member "State".
     *
     * State
     *
     * @param State The value which will be set
     */
    inline void setState (const char* value, size_t size);

    // API of field "ZipCode"

    static const int kZipCode = 5;

    /**
     * Clears the field "ZipCode".
     *
     * The field will be set to its default value. The hasZipCode()
     * method will return false.
     */
    inline void clearZipCode();

    /**
     * Checks whether the field "ZipCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setZipCode()). Otherwise it will return false.
     */
    inline bool hasZipCode () const;

    /**
     * Returns the value of the member "ZipCode".
     *
     * ZipCode
     *
     * @return The value of the field "ZipCode"
     */
    inline const ::std::string& getZipCode () const;

    /**
     * Retrieves the value of the field "ZipCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ZipCode".
     */
    inline ::std::string& getZipCodeMutable ();

    /**
     * Sets the value of the member "ZipCode".
     *
     * ZipCode
     *
     * @param ZipCode The value which will be set
     */
    inline void setZipCode (const ::std::string& ZipCode_);

    /**
     * Sets the value of the member "ZipCode".
     *
     * ZipCode
     *
     * @param ZipCode The value which will be set
     */
    inline void setZipCode (const char* ZipCode_);

    /**
     * Sets the value of the member "ZipCode".
     *
     * ZipCode
     *
     * @param ZipCode The value which will be set
     */
    inline void setZipCode (const char* value, size_t size);

    // API of field "Phone"

    static const int kPhone = 6;

    /**
     * Clears the field "Phone".
     *
     * The field will be set to its default value. The hasPhone()
     * method will return false.
     */
    inline void clearPhone();

    /**
     * Checks whether the field "Phone" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhone()). Otherwise it will return false.
     */
    inline bool hasPhone () const;

    /**
     * Returns the value of the member "Phone".
     *
     * Phone
     *
     * @return The value of the field "Phone"
     */
    inline const ::std::string& getPhone () const;

    /**
     * Retrieves the value of the field "Phone" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Phone".
     */
    inline ::std::string& getPhoneMutable ();

    /**
     * Sets the value of the member "Phone".
     *
     * Phone
     *
     * @param Phone The value which will be set
     */
    inline void setPhone (const ::std::string& Phone_);

    /**
     * Sets the value of the member "Phone".
     *
     * Phone
     *
     * @param Phone The value which will be set
     */
    inline void setPhone (const char* Phone_);

    /**
     * Sets the value of the member "Phone".
     *
     * Phone
     *
     * @param Phone The value which will be set
     */
    inline void setPhone (const char* value, size_t size);

    // API of field "Fuel_LOCID"

    static const int kFuel_LOCID = 7;

    /**
     * Clears the field "Fuel_LOCID".
     *
     * The field will be set to its default value. The hasFuel_LOCID()
     * method will return false.
     */
    inline void clearFuel_LOCID();

    /**
     * Checks whether the field "Fuel_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuel_LOCID()). Otherwise it will return false.
     */
    inline bool hasFuel_LOCID () const;

    /**
     * Returns the value of the member "Fuel_LOCID".
     *
     * Phone
     *
     * @return The value of the field "Fuel_LOCID"
     */
    inline uint32 getFuel_LOCID () const;

    /**
     * Sets the value of the member "Fuel_LOCID".
     *
     * Phone
     *
     * @param Fuel_LOCID The value which will be set
     */
    inline void setFuel_LOCID (uint32 Fuel_LOCID_);

    // API of field "Amenity"

    static const int kAmenity = 8;

    /**
     * Clears the field "Amenity".
     *
     * The field will be set to its default value. The hasAmenity()
     * method will return false.
     */
    inline void clearAmenity();

    /**
     * Checks whether the field "Amenity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmenity()). Otherwise it will return false.
     */
    inline bool hasAmenity () const;

    /**
     * Returns the value of the member "Amenity".
     *
     * AMENITY
     *
     * @return The value of the field "Amenity"
     */
    inline const ::std::string& getAmenity () const;

    /**
     * Retrieves the value of the field "Amenity" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Amenity".
     */
    inline ::std::string& getAmenityMutable ();

    /**
     * Sets the value of the member "Amenity".
     *
     * AMENITY
     *
     * @param Amenity The value which will be set
     */
    inline void setAmenity (const ::std::string& Amenity_);

    /**
     * Sets the value of the member "Amenity".
     *
     * AMENITY
     *
     * @param Amenity The value which will be set
     */
    inline void setAmenity (const char* Amenity_);

    /**
     * Sets the value of the member "Amenity".
     *
     * AMENITY
     *
     * @param Amenity The value which will be set
     */
    inline void setAmenity (const char* value, size_t size);

    // API of field "CanFuelFavInfo"

    static const int kCanFuelFavInfo = 9;

    /**
     * Clears the field "CanFuelFavInfo".
     *
     * The field will be set to its default value. The hasCanFuelFavInfo()
     * method will return false.
     */
    inline void clearCanFuelFavInfo();

    /**
     * Checks whether the field "CanFuelFavInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuelFavInfo()). Otherwise it will return false.
     */
    inline bool hasCanFuelFavInfo () const;

    /**
     * Returns the value of the member "CanFuelFavInfo".
     *
     * Fuel Favorit Info
     *
     * @return The value of the field "CanFuelFavInfo"
     */
    inline bool getCanFuelFavInfo () const;

    /**
     * Sets the value of the member "CanFuelFavInfo".
     *
     * Fuel Favorit Info
     *
     * @param CanFuelFavInfo The value which will be set
     */
    inline void setCanFuelFavInfo (bool CanFuelFavInfo_);

    // API of field "CanFuelLocation"

    static const int kCanFuelLocation = 10;

    /**
     * Clears the field "CanFuelLocation".
     *
     * The field will be set to its default value. The hasCanFuelLocation()
     * method will return false.
     */
    inline void clearCanFuelLocation();

    /**
     * Checks whether the field "CanFuelLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuelLocation()). Otherwise it will return false.
     */
    inline bool hasCanFuelLocation () const;

    /**
     * Returns the value of the member "CanFuelLocation".
     *
     * Theatre Location information
     *
     * @return The value of the field "CanFuelLocation"
     */
    inline const ::sxm_main_fi_types::T_SxmLocation& getCanFuelLocation () const;

    /**
     * Retrieves the value of the field "CanFuelLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CanFuelLocation".
     */
    inline ::sxm_main_fi_types::T_SxmLocation& getCanFuelLocationMutable ();

    /**
     * Sets the value of the member "CanFuelLocation".
     *
     * Theatre Location information
     *
     * @param CanFuelLocation The value which will be set
     */
    inline void setCanFuelLocation (const ::sxm_main_fi_types::T_SxmLocation& CanFuelLocation_);

    // API of field "CanFuelTypelist"

    static const int kCanFuelTypelist = 11;

    /**
     * Clears the field "CanFuelTypelist".
     *
     * The field will be set to its default value. The hasCanFuelTypelist()
     * method will return false.
     */
    inline void clearCanFuelTypelist();

    /**
     * Checks whether the field "CanFuelTypelist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanFuelTypelist()). Otherwise it will return false.
     */
    inline bool hasCanFuelTypelist () const;

    /**
     * Returns the value of the member "CanFuelTypelist".
     *
     * List of Information for each fuel types
     *
     * @return The value of the field "CanFuelTypelist"
     */
    inline const ::std::vector< T_CanFuelTypeInfolist >& getCanFuelTypelist () const;

    /**
     * Retrieves the value of the field "CanFuelTypelist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CanFuelTypelist".
     */
    inline ::std::vector< T_CanFuelTypeInfolist >& getCanFuelTypelistMutable ();

    /**
     * Sets the value of the member "CanFuelTypelist".
     *
     * List of Information for each fuel types
     *
     * @param CanFuelTypelist The value which will be set
     */
    inline void setCanFuelTypelist (const ::std::vector< T_CanFuelTypeInfolist >& CanFuelTypelist_);

    // API of field "StationAmenitylist"

    static const int kStationAmenitylist = 12;

    /**
     * Clears the field "StationAmenitylist".
     *
     * The field will be set to its default value. The hasStationAmenitylist()
     * method will return false.
     */
    inline void clearStationAmenitylist();

    /**
     * Checks whether the field "StationAmenitylist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationAmenitylist()). Otherwise it will return false.
     */
    inline bool hasStationAmenitylist () const;

    /**
     * Returns the value of the member "StationAmenitylist".
     *
     * List of Information for each fuel types
     *
     * @return The value of the field "StationAmenitylist"
     */
    inline const ::std::vector< T_e8_CanFuelStationAmenity >& getStationAmenitylist () const;

    /**
     * Retrieves the value of the field "StationAmenitylist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StationAmenitylist".
     */
    inline ::std::vector< T_e8_CanFuelStationAmenity >& getStationAmenitylistMutable ();

    /**
     * Sets the value of the member "StationAmenitylist".
     *
     * List of Information for each fuel types
     *
     * @param StationAmenitylist The value which will be set
     */
    inline void setStationAmenitylist (const ::std::vector< T_e8_CanFuelStationAmenity >& StationAmenitylist_);

    // API of field "NumPrices"

    static const int kNumPrices = 13;

    /**
     * Clears the field "NumPrices".
     *
     * The field will be set to its default value. The hasNumPrices()
     * method will return false.
     */
    inline void clearNumPrices();

    /**
     * Checks whether the field "NumPrices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumPrices()). Otherwise it will return false.
     */
    inline bool hasNumPrices () const;

    /**
     * Returns the value of the member "NumPrices".
     *
     * Number of fuel price
     *
     * @return The value of the field "NumPrices"
     */
    inline uint32 getNumPrices () const;

    /**
     * Sets the value of the member "NumPrices".
     *
     * Number of fuel price
     *
     * @param NumPrices The value which will be set
     */
    inline void setNumPrices (uint32 NumPrices_);

    static const T_CanFuelStationInfo &getDefaultInstance();

private:

    static const ::std::vector< T_CanFuelTypeInfolist >& getT_CanFuelTypeInfolistList_DefaultInstance ();

    static const ::std::vector< T_e8_CanFuelStationAmenity >& getT_e8_CanFuelStationAmenityList_DefaultInstance ();

    inline void set_has_StationName ();

    inline void clear_has_StationName ();

    inline void set_has_Brand ();

    inline void clear_has_Brand ();

    inline void set_has_StreetName ();

    inline void clear_has_StreetName ();

    inline void set_has_City ();

    inline void clear_has_City ();

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_ZipCode ();

    inline void clear_has_ZipCode ();

    inline void set_has_Phone ();

    inline void clear_has_Phone ();

    inline void set_has_Fuel_LOCID ();

    inline void clear_has_Fuel_LOCID ();

    inline void set_has_Amenity ();

    inline void clear_has_Amenity ();

    inline void set_has_CanFuelFavInfo ();

    inline void clear_has_CanFuelFavInfo ();

    inline void set_has_CanFuelLocation ();

    inline void clear_has_CanFuelLocation ();

    inline void set_has_CanFuelTypelist ();

    inline void clear_has_CanFuelTypelist ();

    inline void set_has_StationAmenitylist ();

    inline void clear_has_StationAmenitylist ();

    inline void set_has_NumPrices ();

    inline void clear_has_NumPrices ();

    uint32 _has_bits_[ (14 + 31) / 32];

    ::std::string _StationName;

    ::std::string _Brand;

    ::std::string _StreetName;

    ::std::string _City;

    ::std::string _State;

    ::std::string _ZipCode;

    ::std::string _Phone;

    uint32 _Fuel_LOCID;

    ::std::string _Amenity;

    bool _CanFuelFavInfo;

    ::sxm_main_fi_types::T_SxmLocation _CanFuelLocation;

    ::std::vector< T_CanFuelTypeInfolist > _CanFuelTypelist;

    ::std::vector< T_e8_CanFuelStationAmenity > _StationAmenitylist;

    uint32 _NumPrices;

};

inline  T_CanFuelInfo::T_CanFuelInfo ()  :
    _StationName (),
    _Brand (),
    _CanFuelType (::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelTypeEnum__CAN_FUEL_TYPE_REGULAR),
    _CanFuel_LOCID (0u),
    _CanFuelName (),
    _CanFuelPrice (),
    _CanFuelAge (0u),
    _CanFuelLoc (),
    _CanFuelDistKm (0.0f),
    _CanFuelDistMile (0.0f),
    _NumPrices (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CanFuelInfo::T_CanFuelInfo (const T_CanFuelInfo &rhs)  :
    _StationName (),
    _Brand (),
    _CanFuelType (::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelTypeEnum__CAN_FUEL_TYPE_REGULAR),
    _CanFuel_LOCID (0u),
    _CanFuelName (),
    _CanFuelPrice (),
    _CanFuelAge (0u),
    _CanFuelLoc (),
    _CanFuelDistKm (0.0f),
    _CanFuelDistMile (0.0f),
    _NumPrices (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CanFuelInfo::T_CanFuelInfo (const ::std::string& StationName_, const ::std::string& Brand_, T_e8_CanFuelTypeEnum CanFuelType_, uint32 CanFuel_LOCID_, const ::std::string& CanFuelName_, const ::std::string& CanFuelPrice_, uint8 CanFuelAge_, const ::sxm_main_fi_types::T_SxmLocation& CanFuelLoc_, float CanFuelDistKm_, float CanFuelDistMile_, uint32 NumPrices_)  :
    _StationName (StationName_),
    _Brand (Brand_),
    _CanFuelType (CanFuelType_),
    _CanFuel_LOCID (CanFuel_LOCID_),
    _CanFuelName (CanFuelName_),
    _CanFuelPrice (CanFuelPrice_),
    _CanFuelAge (CanFuelAge_),
    _CanFuelLoc (CanFuelLoc_),
    _CanFuelDistKm (CanFuelDistKm_),
    _CanFuelDistMile (CanFuelDistMile_),
    _NumPrices (NumPrices_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_CanFuelTypeEnum_IsValid(CanFuelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CanFuelType_, "T_e8_CanFuelTypeEnum", "CanFuelType", "T_CanFuelInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CanFuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CanFuelPrice_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CanFuelInfo::~T_CanFuelInfo() {
}

inline T_CanFuelInfo& T_CanFuelInfo::operator = (const T_CanFuelInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStationName()) {
            setStationName(rhs.getStationName());
        } else {
            clearStationName();
        }
        if (rhs.hasBrand()) {
            setBrand(rhs.getBrand());
        } else {
            clearBrand();
        }
        if (rhs.hasCanFuelType()) {
            setCanFuelType(rhs.getCanFuelType());
        } else {
            clearCanFuelType();
        }
        if (rhs.hasCanFuel_LOCID()) {
            setCanFuel_LOCID(rhs.getCanFuel_LOCID());
        } else {
            clearCanFuel_LOCID();
        }
        if (rhs.hasCanFuelName()) {
            setCanFuelName(rhs.getCanFuelName());
        } else {
            clearCanFuelName();
        }
        if (rhs.hasCanFuelPrice()) {
            setCanFuelPrice(rhs.getCanFuelPrice());
        } else {
            clearCanFuelPrice();
        }
        if (rhs.hasCanFuelAge()) {
            setCanFuelAge(rhs.getCanFuelAge());
        } else {
            clearCanFuelAge();
        }
        if (rhs.hasCanFuelLoc()) {
            setCanFuelLoc(rhs.getCanFuelLoc());
        } else {
            clearCanFuelLoc();
        }
        if (rhs.hasCanFuelDistKm()) {
            setCanFuelDistKm(rhs.getCanFuelDistKm());
        } else {
            clearCanFuelDistKm();
        }
        if (rhs.hasCanFuelDistMile()) {
            setCanFuelDistMile(rhs.getCanFuelDistMile());
        } else {
            clearCanFuelDistMile();
        }
        if (rhs.hasNumPrices()) {
            setNumPrices(rhs.getNumPrices());
        } else {
            clearNumPrices();
        }
    }
    return *this;
}

inline bool T_CanFuelInfo::operator == (const T_CanFuelInfo& rhs) const {
    return (((!hasStationName() && !rhs.hasStationName()) || getStationName() == rhs.getStationName()) &&
        ((!hasBrand() && !rhs.hasBrand()) || getBrand() == rhs.getBrand()) &&
        ((!hasCanFuelType() && !rhs.hasCanFuelType()) || getCanFuelType() == rhs.getCanFuelType()) &&
        ((!hasCanFuel_LOCID() && !rhs.hasCanFuel_LOCID()) || getCanFuel_LOCID() == rhs.getCanFuel_LOCID()) &&
        ((!hasCanFuelName() && !rhs.hasCanFuelName()) || getCanFuelName() == rhs.getCanFuelName()) &&
        ((!hasCanFuelPrice() && !rhs.hasCanFuelPrice()) || getCanFuelPrice() == rhs.getCanFuelPrice()) &&
        ((!hasCanFuelAge() && !rhs.hasCanFuelAge()) || getCanFuelAge() == rhs.getCanFuelAge()) &&
        ((!hasCanFuelLoc() && !rhs.hasCanFuelLoc()) || getCanFuelLoc() == rhs.getCanFuelLoc()) &&
        ((!hasCanFuelDistKm() && !rhs.hasCanFuelDistKm()) || getCanFuelDistKm() == rhs.getCanFuelDistKm()) &&
        ((!hasCanFuelDistMile() && !rhs.hasCanFuelDistMile()) || getCanFuelDistMile() == rhs.getCanFuelDistMile()) &&
        ((!hasNumPrices() && !rhs.hasNumPrices()) || getNumPrices() == rhs.getNumPrices()));
}

inline bool T_CanFuelInfo::operator != (const T_CanFuelInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CanFuelInfo::operator < (const T_CanFuelInfo& rhs) const {
    if (hasStationName() || rhs.hasStationName()) {
        if (getStationName() < rhs.getStationName()) return true;
        if (getStationName() > rhs.getStationName()) return false;
    }
    if (hasBrand() || rhs.hasBrand()) {
        if (getBrand() < rhs.getBrand()) return true;
        if (getBrand() > rhs.getBrand()) return false;
    }
    if (hasCanFuelType() || rhs.hasCanFuelType()) {
        if ((uint32)getCanFuelType() < (uint32)rhs.getCanFuelType()) return true;
        if ((uint32)getCanFuelType() > (uint32)rhs.getCanFuelType()) return false;
    }
    if (hasCanFuel_LOCID() || rhs.hasCanFuel_LOCID()) {
        if (getCanFuel_LOCID() < rhs.getCanFuel_LOCID()) return true;
        if (getCanFuel_LOCID() > rhs.getCanFuel_LOCID()) return false;
    }
    if (hasCanFuelName() || rhs.hasCanFuelName()) {
        if (getCanFuelName() < rhs.getCanFuelName()) return true;
        if (getCanFuelName() > rhs.getCanFuelName()) return false;
    }
    if (hasCanFuelPrice() || rhs.hasCanFuelPrice()) {
        if (getCanFuelPrice() < rhs.getCanFuelPrice()) return true;
        if (getCanFuelPrice() > rhs.getCanFuelPrice()) return false;
    }
    if (hasCanFuelAge() || rhs.hasCanFuelAge()) {
        if (getCanFuelAge() < rhs.getCanFuelAge()) return true;
        if (getCanFuelAge() > rhs.getCanFuelAge()) return false;
    }
    if (hasCanFuelLoc() || rhs.hasCanFuelLoc()) {
        if (getCanFuelLoc() < rhs.getCanFuelLoc()) return true;
        if (getCanFuelLoc() > rhs.getCanFuelLoc()) return false;
    }
    if (hasCanFuelDistKm() || rhs.hasCanFuelDistKm()) {
        if (getCanFuelDistKm() < rhs.getCanFuelDistKm()) return true;
        if (getCanFuelDistKm() > rhs.getCanFuelDistKm()) return false;
    }
    if (hasCanFuelDistMile() || rhs.hasCanFuelDistMile()) {
        if (getCanFuelDistMile() < rhs.getCanFuelDistMile()) return true;
        if (getCanFuelDistMile() > rhs.getCanFuelDistMile()) return false;
    }
    if (hasNumPrices() || rhs.hasNumPrices()) {
        if (getNumPrices() < rhs.getNumPrices()) return true;
        if (getNumPrices() > rhs.getNumPrices()) return false;
    }
    return false;
}

inline bool T_CanFuelInfo::operator > (const T_CanFuelInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CanFuelInfo::clear() {
    clearStationName();
    clearBrand();
    clearCanFuelType();
    clearCanFuel_LOCID();
    clearCanFuelName();
    clearCanFuelPrice();
    clearCanFuelAge();
    clearCanFuelLoc();
    clearCanFuelDistKm();
    clearCanFuelDistMile();
    clearNumPrices();
}

inline void T_CanFuelInfo::clearStationName() {
    if (hasStationName()) {
         clear_has_StationName();
        _StationName.clear();
     }
}

inline bool T_CanFuelInfo::hasStationName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_CanFuelInfo::getStationName () const {
    return _StationName;
}

inline ::std::string& T_CanFuelInfo::getStationNameMutable () {
    set_has_StationName();
    return _StationName;
}

inline void T_CanFuelInfo::setStationName (const ::std::string& StationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationName();
    this->_StationName = StationName_;
}

inline void T_CanFuelInfo::setStationName (const char* StationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationName();
    this->_StationName.assign(StationName_);
}

inline void T_CanFuelInfo::setStationName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationName();
    this->_StationName.assign(value, size);
}

inline void T_CanFuelInfo::clearBrand() {
    if (hasBrand()) {
         clear_has_Brand();
        _Brand.clear();
     }
}

inline bool T_CanFuelInfo::hasBrand () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_CanFuelInfo::getBrand () const {
    return _Brand;
}

inline ::std::string& T_CanFuelInfo::getBrandMutable () {
    set_has_Brand();
    return _Brand;
}

inline void T_CanFuelInfo::setBrand (const ::std::string& Brand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand = Brand_;
}

inline void T_CanFuelInfo::setBrand (const char* Brand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand.assign(Brand_);
}

inline void T_CanFuelInfo::setBrand (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand.assign(value, size);
}

inline void T_CanFuelInfo::clearCanFuelType() {
    if (hasCanFuelType()) {
         clear_has_CanFuelType();
        _CanFuelType = ::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelTypeEnum__CAN_FUEL_TYPE_REGULAR;
     }
}

inline bool T_CanFuelInfo::hasCanFuelType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_CanFuelTypeEnum T_CanFuelInfo::getCanFuelType () const {
    return _CanFuelType;
}

inline void T_CanFuelInfo::setCanFuelType (T_e8_CanFuelTypeEnum CanFuelType_) {
    #ifndef NDEBUG
    if (!(T_e8_CanFuelTypeEnum_IsValid(CanFuelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CanFuelType_, "T_e8_CanFuelTypeEnum", "CanFuelType", "T_CanFuelInfo");
    }
    #endif
    set_has_CanFuelType();
    this->_CanFuelType = CanFuelType_;
}

inline void T_CanFuelInfo::clearCanFuel_LOCID() {
    if (hasCanFuel_LOCID()) {
         clear_has_CanFuel_LOCID();
        _CanFuel_LOCID = 0u;
     }
}

inline bool T_CanFuelInfo::hasCanFuel_LOCID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_CanFuelInfo::getCanFuel_LOCID () const {
    return _CanFuel_LOCID;
}

inline void T_CanFuelInfo::setCanFuel_LOCID (uint32 CanFuel_LOCID_) {
    set_has_CanFuel_LOCID();
    this->_CanFuel_LOCID = CanFuel_LOCID_;
}

inline void T_CanFuelInfo::clearCanFuelName() {
    if (hasCanFuelName()) {
         clear_has_CanFuelName();
        _CanFuelName.clear();
     }
}

inline bool T_CanFuelInfo::hasCanFuelName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_CanFuelInfo::getCanFuelName () const {
    return _CanFuelName;
}

inline ::std::string& T_CanFuelInfo::getCanFuelNameMutable () {
    set_has_CanFuelName();
    return _CanFuelName;
}

inline void T_CanFuelInfo::setCanFuelName (const ::std::string& CanFuelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CanFuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CanFuelName();
    this->_CanFuelName = CanFuelName_;
}

inline void T_CanFuelInfo::setCanFuelName (const char* CanFuelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CanFuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CanFuelName();
    this->_CanFuelName.assign(CanFuelName_);
}

inline void T_CanFuelInfo::setCanFuelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CanFuelName();
    this->_CanFuelName.assign(value, size);
}

inline void T_CanFuelInfo::clearCanFuelPrice() {
    if (hasCanFuelPrice()) {
         clear_has_CanFuelPrice();
        _CanFuelPrice.clear();
     }
}

inline bool T_CanFuelInfo::hasCanFuelPrice () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_CanFuelInfo::getCanFuelPrice () const {
    return _CanFuelPrice;
}

inline ::std::string& T_CanFuelInfo::getCanFuelPriceMutable () {
    set_has_CanFuelPrice();
    return _CanFuelPrice;
}

inline void T_CanFuelInfo::setCanFuelPrice (const ::std::string& CanFuelPrice_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CanFuelPrice_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CanFuelPrice();
    this->_CanFuelPrice = CanFuelPrice_;
}

inline void T_CanFuelInfo::setCanFuelPrice (const char* CanFuelPrice_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CanFuelPrice_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CanFuelPrice();
    this->_CanFuelPrice.assign(CanFuelPrice_);
}

inline void T_CanFuelInfo::setCanFuelPrice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CanFuelPrice();
    this->_CanFuelPrice.assign(value, size);
}

inline void T_CanFuelInfo::clearCanFuelAge() {
    if (hasCanFuelAge()) {
         clear_has_CanFuelAge();
        _CanFuelAge = 0u;
     }
}

inline bool T_CanFuelInfo::hasCanFuelAge () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_CanFuelInfo::getCanFuelAge () const {
    return _CanFuelAge;
}

inline void T_CanFuelInfo::setCanFuelAge (uint8 CanFuelAge_) {
    set_has_CanFuelAge();
    this->_CanFuelAge = CanFuelAge_;
}

inline void T_CanFuelInfo::clearCanFuelLoc() {
    if (hasCanFuelLoc()) {
         clear_has_CanFuelLoc();
        _CanFuelLoc.clear();
     }
}

inline bool T_CanFuelInfo::hasCanFuelLoc () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmLocation& T_CanFuelInfo::getCanFuelLoc () const {
    return _CanFuelLoc;
}

inline ::sxm_main_fi_types::T_SxmLocation& T_CanFuelInfo::getCanFuelLocMutable () {
    set_has_CanFuelLoc();
    return _CanFuelLoc;
}

inline void T_CanFuelInfo::setCanFuelLoc (const ::sxm_main_fi_types::T_SxmLocation& CanFuelLoc_) {
    set_has_CanFuelLoc();
    this->_CanFuelLoc = CanFuelLoc_;
}

inline void T_CanFuelInfo::clearCanFuelDistKm() {
    if (hasCanFuelDistKm()) {
         clear_has_CanFuelDistKm();
        _CanFuelDistKm = 0.0f;
     }
}

inline bool T_CanFuelInfo::hasCanFuelDistKm () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline float T_CanFuelInfo::getCanFuelDistKm () const {
    return _CanFuelDistKm;
}

inline void T_CanFuelInfo::setCanFuelDistKm (float CanFuelDistKm_) {
    set_has_CanFuelDistKm();
    this->_CanFuelDistKm = CanFuelDistKm_;
}

inline void T_CanFuelInfo::clearCanFuelDistMile() {
    if (hasCanFuelDistMile()) {
         clear_has_CanFuelDistMile();
        _CanFuelDistMile = 0.0f;
     }
}

inline bool T_CanFuelInfo::hasCanFuelDistMile () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline float T_CanFuelInfo::getCanFuelDistMile () const {
    return _CanFuelDistMile;
}

inline void T_CanFuelInfo::setCanFuelDistMile (float CanFuelDistMile_) {
    set_has_CanFuelDistMile();
    this->_CanFuelDistMile = CanFuelDistMile_;
}

inline void T_CanFuelInfo::clearNumPrices() {
    if (hasNumPrices()) {
         clear_has_NumPrices();
        _NumPrices = 0u;
     }
}

inline bool T_CanFuelInfo::hasNumPrices () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint32 T_CanFuelInfo::getNumPrices () const {
    return _NumPrices;
}

inline void T_CanFuelInfo::setNumPrices (uint32 NumPrices_) {
    set_has_NumPrices();
    this->_NumPrices = NumPrices_;
}

inline void T_CanFuelInfo::set_has_StationName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CanFuelInfo::clear_has_StationName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CanFuelInfo::set_has_Brand () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CanFuelInfo::clear_has_Brand () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_CanFuelInfo::set_has_CanFuelType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_CanFuelInfo::clear_has_CanFuelType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_CanFuelInfo::set_has_CanFuel_LOCID () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_CanFuelInfo::clear_has_CanFuel_LOCID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_CanFuelInfo::set_has_CanFuelName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_CanFuelInfo::clear_has_CanFuelName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_CanFuelInfo::set_has_CanFuelPrice () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_CanFuelInfo::clear_has_CanFuelPrice () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_CanFuelInfo::set_has_CanFuelAge () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_CanFuelInfo::clear_has_CanFuelAge () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_CanFuelInfo::set_has_CanFuelLoc () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_CanFuelInfo::clear_has_CanFuelLoc () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_CanFuelInfo::set_has_CanFuelDistKm () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_CanFuelInfo::clear_has_CanFuelDistKm () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_CanFuelInfo::set_has_CanFuelDistMile () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_CanFuelInfo::clear_has_CanFuelDistMile () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_CanFuelInfo::set_has_NumPrices () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_CanFuelInfo::clear_has_NumPrices () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline  T_CanFuelTypeInfo::T_CanFuelTypeInfo ()  :
    _CanFuelType (::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelTypeEnum__CAN_FUEL_TYPE_REGULAR),
    _CanFuelName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CanFuelTypeInfo::T_CanFuelTypeInfo (const T_CanFuelTypeInfo &rhs)  :
    _CanFuelType (::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelTypeEnum__CAN_FUEL_TYPE_REGULAR),
    _CanFuelName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CanFuelTypeInfo::T_CanFuelTypeInfo (T_e8_CanFuelTypeEnum CanFuelType_, const ::std::string& CanFuelName_)  :
    _CanFuelType (CanFuelType_),
    _CanFuelName (CanFuelName_)
{
    #ifndef NDEBUG
    if (!(T_e8_CanFuelTypeEnum_IsValid(CanFuelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CanFuelType_, "T_e8_CanFuelTypeEnum", "CanFuelType", "T_CanFuelTypeInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CanFuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CanFuelTypeInfo::~T_CanFuelTypeInfo() {
}

inline T_CanFuelTypeInfo& T_CanFuelTypeInfo::operator = (const T_CanFuelTypeInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCanFuelType()) {
            setCanFuelType(rhs.getCanFuelType());
        } else {
            clearCanFuelType();
        }
        if (rhs.hasCanFuelName()) {
            setCanFuelName(rhs.getCanFuelName());
        } else {
            clearCanFuelName();
        }
    }
    return *this;
}

inline bool T_CanFuelTypeInfo::operator == (const T_CanFuelTypeInfo& rhs) const {
    return (((!hasCanFuelType() && !rhs.hasCanFuelType()) || getCanFuelType() == rhs.getCanFuelType()) &&
        ((!hasCanFuelName() && !rhs.hasCanFuelName()) || getCanFuelName() == rhs.getCanFuelName()));
}

inline bool T_CanFuelTypeInfo::operator != (const T_CanFuelTypeInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CanFuelTypeInfo::operator < (const T_CanFuelTypeInfo& rhs) const {
    if (hasCanFuelType() || rhs.hasCanFuelType()) {
        if ((uint32)getCanFuelType() < (uint32)rhs.getCanFuelType()) return true;
        if ((uint32)getCanFuelType() > (uint32)rhs.getCanFuelType()) return false;
    }
    if (hasCanFuelName() || rhs.hasCanFuelName()) {
        if (getCanFuelName() < rhs.getCanFuelName()) return true;
        if (getCanFuelName() > rhs.getCanFuelName()) return false;
    }
    return false;
}

inline bool T_CanFuelTypeInfo::operator > (const T_CanFuelTypeInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CanFuelTypeInfo::clear() {
    clearCanFuelType();
    clearCanFuelName();
}

inline void T_CanFuelTypeInfo::clearCanFuelType() {
    if (hasCanFuelType()) {
         clear_has_CanFuelType();
        _CanFuelType = ::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelTypeEnum__CAN_FUEL_TYPE_REGULAR;
     }
}

inline bool T_CanFuelTypeInfo::hasCanFuelType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_CanFuelTypeEnum T_CanFuelTypeInfo::getCanFuelType () const {
    return _CanFuelType;
}

inline void T_CanFuelTypeInfo::setCanFuelType (T_e8_CanFuelTypeEnum CanFuelType_) {
    #ifndef NDEBUG
    if (!(T_e8_CanFuelTypeEnum_IsValid(CanFuelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CanFuelType_, "T_e8_CanFuelTypeEnum", "CanFuelType", "T_CanFuelTypeInfo");
    }
    #endif
    set_has_CanFuelType();
    this->_CanFuelType = CanFuelType_;
}

inline void T_CanFuelTypeInfo::clearCanFuelName() {
    if (hasCanFuelName()) {
         clear_has_CanFuelName();
        _CanFuelName.clear();
     }
}

inline bool T_CanFuelTypeInfo::hasCanFuelName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_CanFuelTypeInfo::getCanFuelName () const {
    return _CanFuelName;
}

inline ::std::string& T_CanFuelTypeInfo::getCanFuelNameMutable () {
    set_has_CanFuelName();
    return _CanFuelName;
}

inline void T_CanFuelTypeInfo::setCanFuelName (const ::std::string& CanFuelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CanFuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CanFuelName();
    this->_CanFuelName = CanFuelName_;
}

inline void T_CanFuelTypeInfo::setCanFuelName (const char* CanFuelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CanFuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CanFuelName();
    this->_CanFuelName.assign(CanFuelName_);
}

inline void T_CanFuelTypeInfo::setCanFuelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CanFuelName();
    this->_CanFuelName.assign(value, size);
}

inline void T_CanFuelTypeInfo::set_has_CanFuelType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CanFuelTypeInfo::clear_has_CanFuelType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CanFuelTypeInfo::set_has_CanFuelName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CanFuelTypeInfo::clear_has_CanFuelName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_CanFuelTypeInfolist::T_CanFuelTypeInfolist ()  :
    _FuelName (),
    _FuelPrice (),
    _FuelAge (0u),
    _FuelAvail (false),
    _FuelType (::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelTypeEnum__CAN_FUEL_TYPE_REGULAR)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CanFuelTypeInfolist::T_CanFuelTypeInfolist (const T_CanFuelTypeInfolist &rhs)  :
    _FuelName (),
    _FuelPrice (),
    _FuelAge (0u),
    _FuelAvail (false),
    _FuelType (::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelTypeEnum__CAN_FUEL_TYPE_REGULAR)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CanFuelTypeInfolist::T_CanFuelTypeInfolist (const ::std::string& FuelName_, const ::std::string& FuelPrice_, uint8 FuelAge_, bool FuelAvail_, T_e8_CanFuelTypeEnum FuelType_)  :
    _FuelName (FuelName_),
    _FuelPrice (FuelPrice_),
    _FuelAge (FuelAge_),
    _FuelAvail (FuelAvail_),
    _FuelType (FuelType_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelPrice_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_CanFuelTypeEnum_IsValid(FuelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FuelType_, "T_e8_CanFuelTypeEnum", "FuelType", "T_CanFuelTypeInfolist");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CanFuelTypeInfolist::~T_CanFuelTypeInfolist() {
}

inline T_CanFuelTypeInfolist& T_CanFuelTypeInfolist::operator = (const T_CanFuelTypeInfolist& rhs) {
    if( this != &rhs ) {
        if (rhs.hasFuelName()) {
            setFuelName(rhs.getFuelName());
        } else {
            clearFuelName();
        }
        if (rhs.hasFuelPrice()) {
            setFuelPrice(rhs.getFuelPrice());
        } else {
            clearFuelPrice();
        }
        if (rhs.hasFuelAge()) {
            setFuelAge(rhs.getFuelAge());
        } else {
            clearFuelAge();
        }
        if (rhs.hasFuelAvail()) {
            setFuelAvail(rhs.getFuelAvail());
        } else {
            clearFuelAvail();
        }
        if (rhs.hasFuelType()) {
            setFuelType(rhs.getFuelType());
        } else {
            clearFuelType();
        }
    }
    return *this;
}

inline bool T_CanFuelTypeInfolist::operator == (const T_CanFuelTypeInfolist& rhs) const {
    return (((!hasFuelName() && !rhs.hasFuelName()) || getFuelName() == rhs.getFuelName()) &&
        ((!hasFuelPrice() && !rhs.hasFuelPrice()) || getFuelPrice() == rhs.getFuelPrice()) &&
        ((!hasFuelAge() && !rhs.hasFuelAge()) || getFuelAge() == rhs.getFuelAge()) &&
        ((!hasFuelAvail() && !rhs.hasFuelAvail()) || getFuelAvail() == rhs.getFuelAvail()) &&
        ((!hasFuelType() && !rhs.hasFuelType()) || getFuelType() == rhs.getFuelType()));
}

inline bool T_CanFuelTypeInfolist::operator != (const T_CanFuelTypeInfolist& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CanFuelTypeInfolist::operator < (const T_CanFuelTypeInfolist& rhs) const {
    if (hasFuelName() || rhs.hasFuelName()) {
        if (getFuelName() < rhs.getFuelName()) return true;
        if (getFuelName() > rhs.getFuelName()) return false;
    }
    if (hasFuelPrice() || rhs.hasFuelPrice()) {
        if (getFuelPrice() < rhs.getFuelPrice()) return true;
        if (getFuelPrice() > rhs.getFuelPrice()) return false;
    }
    if (hasFuelAge() || rhs.hasFuelAge()) {
        if (getFuelAge() < rhs.getFuelAge()) return true;
        if (getFuelAge() > rhs.getFuelAge()) return false;
    }
    if (hasFuelAvail() || rhs.hasFuelAvail()) {
        if (getFuelAvail() < rhs.getFuelAvail()) return true;
        if (getFuelAvail() > rhs.getFuelAvail()) return false;
    }
    if (hasFuelType() || rhs.hasFuelType()) {
        if ((uint32)getFuelType() < (uint32)rhs.getFuelType()) return true;
        if ((uint32)getFuelType() > (uint32)rhs.getFuelType()) return false;
    }
    return false;
}

inline bool T_CanFuelTypeInfolist::operator > (const T_CanFuelTypeInfolist& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CanFuelTypeInfolist::clear() {
    clearFuelName();
    clearFuelPrice();
    clearFuelAge();
    clearFuelAvail();
    clearFuelType();
}

inline void T_CanFuelTypeInfolist::clearFuelName() {
    if (hasFuelName()) {
         clear_has_FuelName();
        _FuelName.clear();
     }
}

inline bool T_CanFuelTypeInfolist::hasFuelName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_CanFuelTypeInfolist::getFuelName () const {
    return _FuelName;
}

inline ::std::string& T_CanFuelTypeInfolist::getFuelNameMutable () {
    set_has_FuelName();
    return _FuelName;
}

inline void T_CanFuelTypeInfolist::setFuelName (const ::std::string& FuelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelName();
    this->_FuelName = FuelName_;
}

inline void T_CanFuelTypeInfolist::setFuelName (const char* FuelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelName();
    this->_FuelName.assign(FuelName_);
}

inline void T_CanFuelTypeInfolist::setFuelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelName();
    this->_FuelName.assign(value, size);
}

inline void T_CanFuelTypeInfolist::clearFuelPrice() {
    if (hasFuelPrice()) {
         clear_has_FuelPrice();
        _FuelPrice.clear();
     }
}

inline bool T_CanFuelTypeInfolist::hasFuelPrice () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_CanFuelTypeInfolist::getFuelPrice () const {
    return _FuelPrice;
}

inline ::std::string& T_CanFuelTypeInfolist::getFuelPriceMutable () {
    set_has_FuelPrice();
    return _FuelPrice;
}

inline void T_CanFuelTypeInfolist::setFuelPrice (const ::std::string& FuelPrice_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelPrice_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelPrice();
    this->_FuelPrice = FuelPrice_;
}

inline void T_CanFuelTypeInfolist::setFuelPrice (const char* FuelPrice_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelPrice_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelPrice();
    this->_FuelPrice.assign(FuelPrice_);
}

inline void T_CanFuelTypeInfolist::setFuelPrice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelPrice();
    this->_FuelPrice.assign(value, size);
}

inline void T_CanFuelTypeInfolist::clearFuelAge() {
    if (hasFuelAge()) {
         clear_has_FuelAge();
        _FuelAge = 0u;
     }
}

inline bool T_CanFuelTypeInfolist::hasFuelAge () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_CanFuelTypeInfolist::getFuelAge () const {
    return _FuelAge;
}

inline void T_CanFuelTypeInfolist::setFuelAge (uint8 FuelAge_) {
    set_has_FuelAge();
    this->_FuelAge = FuelAge_;
}

inline void T_CanFuelTypeInfolist::clearFuelAvail() {
    if (hasFuelAvail()) {
         clear_has_FuelAvail();
        _FuelAvail = false;
     }
}

inline bool T_CanFuelTypeInfolist::hasFuelAvail () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_CanFuelTypeInfolist::getFuelAvail () const {
    return _FuelAvail;
}

inline void T_CanFuelTypeInfolist::setFuelAvail (bool FuelAvail_) {
    set_has_FuelAvail();
    this->_FuelAvail = FuelAvail_;
}

inline void T_CanFuelTypeInfolist::clearFuelType() {
    if (hasFuelType()) {
         clear_has_FuelType();
        _FuelType = ::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelTypeEnum__CAN_FUEL_TYPE_REGULAR;
     }
}

inline bool T_CanFuelTypeInfolist::hasFuelType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_CanFuelTypeEnum T_CanFuelTypeInfolist::getFuelType () const {
    return _FuelType;
}

inline void T_CanFuelTypeInfolist::setFuelType (T_e8_CanFuelTypeEnum FuelType_) {
    #ifndef NDEBUG
    if (!(T_e8_CanFuelTypeEnum_IsValid(FuelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FuelType_, "T_e8_CanFuelTypeEnum", "FuelType", "T_CanFuelTypeInfolist");
    }
    #endif
    set_has_FuelType();
    this->_FuelType = FuelType_;
}

inline void T_CanFuelTypeInfolist::set_has_FuelName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CanFuelTypeInfolist::clear_has_FuelName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CanFuelTypeInfolist::set_has_FuelPrice () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CanFuelTypeInfolist::clear_has_FuelPrice () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_CanFuelTypeInfolist::set_has_FuelAge () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_CanFuelTypeInfolist::clear_has_FuelAge () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_CanFuelTypeInfolist::set_has_FuelAvail () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_CanFuelTypeInfolist::clear_has_FuelAvail () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_CanFuelTypeInfolist::set_has_FuelType () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_CanFuelTypeInfolist::clear_has_FuelType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_CanFuelStationInfo::T_CanFuelStationInfo ()  :
    _StationName (),
    _Brand (),
    _StreetName (),
    _City (),
    _State (),
    _ZipCode (),
    _Phone (),
    _Fuel_LOCID (0u),
    _Amenity (),
    _CanFuelFavInfo (false),
    _CanFuelLocation (),
    _CanFuelTypelist (),
    _StationAmenitylist (),
    _NumPrices (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CanFuelStationInfo::T_CanFuelStationInfo (const T_CanFuelStationInfo &rhs)  :
    _StationName (),
    _Brand (),
    _StreetName (),
    _City (),
    _State (),
    _ZipCode (),
    _Phone (),
    _Fuel_LOCID (0u),
    _Amenity (),
    _CanFuelFavInfo (false),
    _CanFuelLocation (),
    _CanFuelTypelist (),
    _StationAmenitylist (),
    _NumPrices (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CanFuelStationInfo::T_CanFuelStationInfo (const ::std::string& StationName_, const ::std::string& Brand_, const ::std::string& StreetName_, const ::std::string& City_, const ::std::string& State_, const ::std::string& ZipCode_, const ::std::string& Phone_, uint32 Fuel_LOCID_, const ::std::string& Amenity_, bool CanFuelFavInfo_, const ::sxm_main_fi_types::T_SxmLocation& CanFuelLocation_, const ::std::vector< T_CanFuelTypeInfolist >& CanFuelTypelist_, const ::std::vector< T_e8_CanFuelStationAmenity >& StationAmenitylist_, uint32 NumPrices_)  :
    _StationName (StationName_),
    _Brand (Brand_),
    _StreetName (StreetName_),
    _City (City_),
    _State (State_),
    _ZipCode (ZipCode_),
    _Phone (Phone_),
    _Fuel_LOCID (Fuel_LOCID_),
    _Amenity (Amenity_),
    _CanFuelFavInfo (CanFuelFavInfo_),
    _CanFuelLocation (CanFuelLocation_),
    _CanFuelTypelist (CanFuelTypelist_),
    _StationAmenitylist (StationAmenitylist_),
    _NumPrices (NumPrices_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StreetName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (City_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ZipCode_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phone_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Amenity_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CanFuelStationInfo::~T_CanFuelStationInfo() {
}

inline T_CanFuelStationInfo& T_CanFuelStationInfo::operator = (const T_CanFuelStationInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStationName()) {
            setStationName(rhs.getStationName());
        } else {
            clearStationName();
        }
        if (rhs.hasBrand()) {
            setBrand(rhs.getBrand());
        } else {
            clearBrand();
        }
        if (rhs.hasStreetName()) {
            setStreetName(rhs.getStreetName());
        } else {
            clearStreetName();
        }
        if (rhs.hasCity()) {
            setCity(rhs.getCity());
        } else {
            clearCity();
        }
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
        if (rhs.hasZipCode()) {
            setZipCode(rhs.getZipCode());
        } else {
            clearZipCode();
        }
        if (rhs.hasPhone()) {
            setPhone(rhs.getPhone());
        } else {
            clearPhone();
        }
        if (rhs.hasFuel_LOCID()) {
            setFuel_LOCID(rhs.getFuel_LOCID());
        } else {
            clearFuel_LOCID();
        }
        if (rhs.hasAmenity()) {
            setAmenity(rhs.getAmenity());
        } else {
            clearAmenity();
        }
        if (rhs.hasCanFuelFavInfo()) {
            setCanFuelFavInfo(rhs.getCanFuelFavInfo());
        } else {
            clearCanFuelFavInfo();
        }
        if (rhs.hasCanFuelLocation()) {
            setCanFuelLocation(rhs.getCanFuelLocation());
        } else {
            clearCanFuelLocation();
        }
        if (rhs.hasCanFuelTypelist()) {
            setCanFuelTypelist(rhs.getCanFuelTypelist());
        } else {
            clearCanFuelTypelist();
        }
        if (rhs.hasStationAmenitylist()) {
            setStationAmenitylist(rhs.getStationAmenitylist());
        } else {
            clearStationAmenitylist();
        }
        if (rhs.hasNumPrices()) {
            setNumPrices(rhs.getNumPrices());
        } else {
            clearNumPrices();
        }
    }
    return *this;
}

inline bool T_CanFuelStationInfo::operator == (const T_CanFuelStationInfo& rhs) const {
    return (((!hasStationName() && !rhs.hasStationName()) || getStationName() == rhs.getStationName()) &&
        ((!hasBrand() && !rhs.hasBrand()) || getBrand() == rhs.getBrand()) &&
        ((!hasStreetName() && !rhs.hasStreetName()) || getStreetName() == rhs.getStreetName()) &&
        ((!hasCity() && !rhs.hasCity()) || getCity() == rhs.getCity()) &&
        ((!hasState() && !rhs.hasState()) || getState() == rhs.getState()) &&
        ((!hasZipCode() && !rhs.hasZipCode()) || getZipCode() == rhs.getZipCode()) &&
        ((!hasPhone() && !rhs.hasPhone()) || getPhone() == rhs.getPhone()) &&
        ((!hasFuel_LOCID() && !rhs.hasFuel_LOCID()) || getFuel_LOCID() == rhs.getFuel_LOCID()) &&
        ((!hasAmenity() && !rhs.hasAmenity()) || getAmenity() == rhs.getAmenity()) &&
        ((!hasCanFuelFavInfo() && !rhs.hasCanFuelFavInfo()) || getCanFuelFavInfo() == rhs.getCanFuelFavInfo()) &&
        ((!hasCanFuelLocation() && !rhs.hasCanFuelLocation()) || getCanFuelLocation() == rhs.getCanFuelLocation()) &&
        ((!hasCanFuelTypelist() && !rhs.hasCanFuelTypelist()) || getCanFuelTypelist() == rhs.getCanFuelTypelist()) &&
        ((!hasStationAmenitylist() && !rhs.hasStationAmenitylist()) || getStationAmenitylist() == rhs.getStationAmenitylist()) &&
        ((!hasNumPrices() && !rhs.hasNumPrices()) || getNumPrices() == rhs.getNumPrices()));
}

inline bool T_CanFuelStationInfo::operator != (const T_CanFuelStationInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CanFuelStationInfo::operator < (const T_CanFuelStationInfo& rhs) const {
    if (hasStationName() || rhs.hasStationName()) {
        if (getStationName() < rhs.getStationName()) return true;
        if (getStationName() > rhs.getStationName()) return false;
    }
    if (hasBrand() || rhs.hasBrand()) {
        if (getBrand() < rhs.getBrand()) return true;
        if (getBrand() > rhs.getBrand()) return false;
    }
    if (hasStreetName() || rhs.hasStreetName()) {
        if (getStreetName() < rhs.getStreetName()) return true;
        if (getStreetName() > rhs.getStreetName()) return false;
    }
    if (hasCity() || rhs.hasCity()) {
        if (getCity() < rhs.getCity()) return true;
        if (getCity() > rhs.getCity()) return false;
    }
    if (hasState() || rhs.hasState()) {
        if (getState() < rhs.getState()) return true;
        if (getState() > rhs.getState()) return false;
    }
    if (hasZipCode() || rhs.hasZipCode()) {
        if (getZipCode() < rhs.getZipCode()) return true;
        if (getZipCode() > rhs.getZipCode()) return false;
    }
    if (hasPhone() || rhs.hasPhone()) {
        if (getPhone() < rhs.getPhone()) return true;
        if (getPhone() > rhs.getPhone()) return false;
    }
    if (hasFuel_LOCID() || rhs.hasFuel_LOCID()) {
        if (getFuel_LOCID() < rhs.getFuel_LOCID()) return true;
        if (getFuel_LOCID() > rhs.getFuel_LOCID()) return false;
    }
    if (hasAmenity() || rhs.hasAmenity()) {
        if (getAmenity() < rhs.getAmenity()) return true;
        if (getAmenity() > rhs.getAmenity()) return false;
    }
    if (hasCanFuelFavInfo() || rhs.hasCanFuelFavInfo()) {
        if (getCanFuelFavInfo() < rhs.getCanFuelFavInfo()) return true;
        if (getCanFuelFavInfo() > rhs.getCanFuelFavInfo()) return false;
    }
    if (hasCanFuelLocation() || rhs.hasCanFuelLocation()) {
        if (getCanFuelLocation() < rhs.getCanFuelLocation()) return true;
        if (getCanFuelLocation() > rhs.getCanFuelLocation()) return false;
    }
    if (hasCanFuelTypelist() || rhs.hasCanFuelTypelist()) {
        if (getCanFuelTypelist() < rhs.getCanFuelTypelist()) return true;
        if (getCanFuelTypelist() > rhs.getCanFuelTypelist()) return false;
    }
    if (hasStationAmenitylist() || rhs.hasStationAmenitylist()) {
        if (getStationAmenitylist() < rhs.getStationAmenitylist()) return true;
        if (getStationAmenitylist() > rhs.getStationAmenitylist()) return false;
    }
    if (hasNumPrices() || rhs.hasNumPrices()) {
        if (getNumPrices() < rhs.getNumPrices()) return true;
        if (getNumPrices() > rhs.getNumPrices()) return false;
    }
    return false;
}

inline bool T_CanFuelStationInfo::operator > (const T_CanFuelStationInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CanFuelStationInfo::clear() {
    clearStationName();
    clearBrand();
    clearStreetName();
    clearCity();
    clearState();
    clearZipCode();
    clearPhone();
    clearFuel_LOCID();
    clearAmenity();
    clearCanFuelFavInfo();
    clearCanFuelLocation();
    clearCanFuelTypelist();
    clearStationAmenitylist();
    clearNumPrices();
}

inline void T_CanFuelStationInfo::clearStationName() {
    if (hasStationName()) {
         clear_has_StationName();
        _StationName.clear();
     }
}

inline bool T_CanFuelStationInfo::hasStationName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_CanFuelStationInfo::getStationName () const {
    return _StationName;
}

inline ::std::string& T_CanFuelStationInfo::getStationNameMutable () {
    set_has_StationName();
    return _StationName;
}

inline void T_CanFuelStationInfo::setStationName (const ::std::string& StationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationName();
    this->_StationName = StationName_;
}

inline void T_CanFuelStationInfo::setStationName (const char* StationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationName();
    this->_StationName.assign(StationName_);
}

inline void T_CanFuelStationInfo::setStationName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationName();
    this->_StationName.assign(value, size);
}

inline void T_CanFuelStationInfo::clearBrand() {
    if (hasBrand()) {
         clear_has_Brand();
        _Brand.clear();
     }
}

inline bool T_CanFuelStationInfo::hasBrand () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_CanFuelStationInfo::getBrand () const {
    return _Brand;
}

inline ::std::string& T_CanFuelStationInfo::getBrandMutable () {
    set_has_Brand();
    return _Brand;
}

inline void T_CanFuelStationInfo::setBrand (const ::std::string& Brand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand = Brand_;
}

inline void T_CanFuelStationInfo::setBrand (const char* Brand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand.assign(Brand_);
}

inline void T_CanFuelStationInfo::setBrand (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand.assign(value, size);
}

inline void T_CanFuelStationInfo::clearStreetName() {
    if (hasStreetName()) {
         clear_has_StreetName();
        _StreetName.clear();
     }
}

inline bool T_CanFuelStationInfo::hasStreetName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_CanFuelStationInfo::getStreetName () const {
    return _StreetName;
}

inline ::std::string& T_CanFuelStationInfo::getStreetNameMutable () {
    set_has_StreetName();
    return _StreetName;
}

inline void T_CanFuelStationInfo::setStreetName (const ::std::string& StreetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StreetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StreetName();
    this->_StreetName = StreetName_;
}

inline void T_CanFuelStationInfo::setStreetName (const char* StreetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StreetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StreetName();
    this->_StreetName.assign(StreetName_);
}

inline void T_CanFuelStationInfo::setStreetName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StreetName();
    this->_StreetName.assign(value, size);
}

inline void T_CanFuelStationInfo::clearCity() {
    if (hasCity()) {
         clear_has_City();
        _City.clear();
     }
}

inline bool T_CanFuelStationInfo::hasCity () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_CanFuelStationInfo::getCity () const {
    return _City;
}

inline ::std::string& T_CanFuelStationInfo::getCityMutable () {
    set_has_City();
    return _City;
}

inline void T_CanFuelStationInfo::setCity (const ::std::string& City_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (City_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_City();
    this->_City = City_;
}

inline void T_CanFuelStationInfo::setCity (const char* City_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (City_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_City();
    this->_City.assign(City_);
}

inline void T_CanFuelStationInfo::setCity (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_City();
    this->_City.assign(value, size);
}

inline void T_CanFuelStationInfo::clearState() {
    if (hasState()) {
         clear_has_State();
        _State.clear();
     }
}

inline bool T_CanFuelStationInfo::hasState () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_CanFuelStationInfo::getState () const {
    return _State;
}

inline ::std::string& T_CanFuelStationInfo::getStateMutable () {
    set_has_State();
    return _State;
}

inline void T_CanFuelStationInfo::setState (const ::std::string& State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State = State_;
}

inline void T_CanFuelStationInfo::setState (const char* State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(State_);
}

inline void T_CanFuelStationInfo::setState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(value, size);
}

inline void T_CanFuelStationInfo::clearZipCode() {
    if (hasZipCode()) {
         clear_has_ZipCode();
        _ZipCode.clear();
     }
}

inline bool T_CanFuelStationInfo::hasZipCode () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_CanFuelStationInfo::getZipCode () const {
    return _ZipCode;
}

inline ::std::string& T_CanFuelStationInfo::getZipCodeMutable () {
    set_has_ZipCode();
    return _ZipCode;
}

inline void T_CanFuelStationInfo::setZipCode (const ::std::string& ZipCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ZipCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ZipCode();
    this->_ZipCode = ZipCode_;
}

inline void T_CanFuelStationInfo::setZipCode (const char* ZipCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ZipCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ZipCode();
    this->_ZipCode.assign(ZipCode_);
}

inline void T_CanFuelStationInfo::setZipCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ZipCode();
    this->_ZipCode.assign(value, size);
}

inline void T_CanFuelStationInfo::clearPhone() {
    if (hasPhone()) {
         clear_has_Phone();
        _Phone.clear();
     }
}

inline bool T_CanFuelStationInfo::hasPhone () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_CanFuelStationInfo::getPhone () const {
    return _Phone;
}

inline ::std::string& T_CanFuelStationInfo::getPhoneMutable () {
    set_has_Phone();
    return _Phone;
}

inline void T_CanFuelStationInfo::setPhone (const ::std::string& Phone_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phone_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phone();
    this->_Phone = Phone_;
}

inline void T_CanFuelStationInfo::setPhone (const char* Phone_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phone_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phone();
    this->_Phone.assign(Phone_);
}

inline void T_CanFuelStationInfo::setPhone (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phone();
    this->_Phone.assign(value, size);
}

inline void T_CanFuelStationInfo::clearFuel_LOCID() {
    if (hasFuel_LOCID()) {
         clear_has_Fuel_LOCID();
        _Fuel_LOCID = 0u;
     }
}

inline bool T_CanFuelStationInfo::hasFuel_LOCID () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 T_CanFuelStationInfo::getFuel_LOCID () const {
    return _Fuel_LOCID;
}

inline void T_CanFuelStationInfo::setFuel_LOCID (uint32 Fuel_LOCID_) {
    set_has_Fuel_LOCID();
    this->_Fuel_LOCID = Fuel_LOCID_;
}

inline void T_CanFuelStationInfo::clearAmenity() {
    if (hasAmenity()) {
         clear_has_Amenity();
        _Amenity.clear();
     }
}

inline bool T_CanFuelStationInfo::hasAmenity () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_CanFuelStationInfo::getAmenity () const {
    return _Amenity;
}

inline ::std::string& T_CanFuelStationInfo::getAmenityMutable () {
    set_has_Amenity();
    return _Amenity;
}

inline void T_CanFuelStationInfo::setAmenity (const ::std::string& Amenity_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Amenity_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Amenity();
    this->_Amenity = Amenity_;
}

inline void T_CanFuelStationInfo::setAmenity (const char* Amenity_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Amenity_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Amenity();
    this->_Amenity.assign(Amenity_);
}

inline void T_CanFuelStationInfo::setAmenity (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Amenity();
    this->_Amenity.assign(value, size);
}

inline void T_CanFuelStationInfo::clearCanFuelFavInfo() {
    if (hasCanFuelFavInfo()) {
         clear_has_CanFuelFavInfo();
        _CanFuelFavInfo = false;
     }
}

inline bool T_CanFuelStationInfo::hasCanFuelFavInfo () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool T_CanFuelStationInfo::getCanFuelFavInfo () const {
    return _CanFuelFavInfo;
}

inline void T_CanFuelStationInfo::setCanFuelFavInfo (bool CanFuelFavInfo_) {
    set_has_CanFuelFavInfo();
    this->_CanFuelFavInfo = CanFuelFavInfo_;
}

inline void T_CanFuelStationInfo::clearCanFuelLocation() {
    if (hasCanFuelLocation()) {
         clear_has_CanFuelLocation();
        _CanFuelLocation.clear();
     }
}

inline bool T_CanFuelStationInfo::hasCanFuelLocation () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmLocation& T_CanFuelStationInfo::getCanFuelLocation () const {
    return _CanFuelLocation;
}

inline ::sxm_main_fi_types::T_SxmLocation& T_CanFuelStationInfo::getCanFuelLocationMutable () {
    set_has_CanFuelLocation();
    return _CanFuelLocation;
}

inline void T_CanFuelStationInfo::setCanFuelLocation (const ::sxm_main_fi_types::T_SxmLocation& CanFuelLocation_) {
    set_has_CanFuelLocation();
    this->_CanFuelLocation = CanFuelLocation_;
}

inline void T_CanFuelStationInfo::clearCanFuelTypelist() {
    if (hasCanFuelTypelist()) {
         clear_has_CanFuelTypelist();
        _CanFuelTypelist.clear();
     }
}

inline bool T_CanFuelStationInfo::hasCanFuelTypelist () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::vector< T_CanFuelTypeInfolist >& T_CanFuelStationInfo::getCanFuelTypelist () const {
    return _CanFuelTypelist;
}

inline ::std::vector< T_CanFuelTypeInfolist >& T_CanFuelStationInfo::getCanFuelTypelistMutable () {
    set_has_CanFuelTypelist();
    return _CanFuelTypelist;
}

inline void T_CanFuelStationInfo::setCanFuelTypelist (const ::std::vector< T_CanFuelTypeInfolist >& CanFuelTypelist_) {
    set_has_CanFuelTypelist();
    this->_CanFuelTypelist = CanFuelTypelist_;
}

inline void T_CanFuelStationInfo::clearStationAmenitylist() {
    if (hasStationAmenitylist()) {
         clear_has_StationAmenitylist();
        _StationAmenitylist.clear();
     }
}

inline bool T_CanFuelStationInfo::hasStationAmenitylist () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::vector< T_e8_CanFuelStationAmenity >& T_CanFuelStationInfo::getStationAmenitylist () const {
    return _StationAmenitylist;
}

inline ::std::vector< T_e8_CanFuelStationAmenity >& T_CanFuelStationInfo::getStationAmenitylistMutable () {
    set_has_StationAmenitylist();
    return _StationAmenitylist;
}

inline void T_CanFuelStationInfo::setStationAmenitylist (const ::std::vector< T_e8_CanFuelStationAmenity >& StationAmenitylist_) {
    set_has_StationAmenitylist();
    this->_StationAmenitylist = StationAmenitylist_;
}

inline void T_CanFuelStationInfo::clearNumPrices() {
    if (hasNumPrices()) {
         clear_has_NumPrices();
        _NumPrices = 0u;
     }
}

inline bool T_CanFuelStationInfo::hasNumPrices () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint32 T_CanFuelStationInfo::getNumPrices () const {
    return _NumPrices;
}

inline void T_CanFuelStationInfo::setNumPrices (uint32 NumPrices_) {
    set_has_NumPrices();
    this->_NumPrices = NumPrices_;
}

inline void T_CanFuelStationInfo::set_has_StationName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CanFuelStationInfo::clear_has_StationName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CanFuelStationInfo::set_has_Brand () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CanFuelStationInfo::clear_has_Brand () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_CanFuelStationInfo::set_has_StreetName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_CanFuelStationInfo::clear_has_StreetName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_CanFuelStationInfo::set_has_City () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_CanFuelStationInfo::clear_has_City () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_CanFuelStationInfo::set_has_State () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_CanFuelStationInfo::clear_has_State () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_CanFuelStationInfo::set_has_ZipCode () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_CanFuelStationInfo::clear_has_ZipCode () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_CanFuelStationInfo::set_has_Phone () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_CanFuelStationInfo::clear_has_Phone () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_CanFuelStationInfo::set_has_Fuel_LOCID () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_CanFuelStationInfo::clear_has_Fuel_LOCID () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_CanFuelStationInfo::set_has_Amenity () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_CanFuelStationInfo::clear_has_Amenity () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_CanFuelStationInfo::set_has_CanFuelFavInfo () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_CanFuelStationInfo::clear_has_CanFuelFavInfo () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_CanFuelStationInfo::set_has_CanFuelLocation () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_CanFuelStationInfo::clear_has_CanFuelLocation () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_CanFuelStationInfo::set_has_CanFuelTypelist () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_CanFuelStationInfo::clear_has_CanFuelTypelist () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_CanFuelStationInfo::set_has_StationAmenitylist () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_CanFuelStationInfo::clear_has_StationAmenitylist () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_CanFuelStationInfo::set_has_NumPrices () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_CanFuelStationInfo::clear_has_NumPrices () {
    _has_bits_[0] &= ~ (1u << 13);
}

} // namespace sxm_canadian_fuel_main_fi_types

#endif // SXM_CANADIAN_FUEL_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
