/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "sxm_audio_main_fi_types.h"
#include "sxm_audio_main_fi_typesConst.h"
#include "sxm_audio_main_fi_typesJson.h"
#include "sxm_audio_main_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_ChannelListEntry"

void serializeJson (const ::sxm_audio_main_fi_types::T_ChannelListEntry& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasServiceID()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceID" , 9);
        yajl_gen_integer(g, (long long)value.getServiceID());
    }
    if (!isSparse || value.hasChannelID()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelID" , 9);
        yajl_gen_integer(g, (long long)value.getChannelID());
    }
    if (!isSparse || value.hasChannelNameAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelNameAvail" , 16);
        yajl_gen_bool(g, (bool)value.getChannelNameAvail());
    }
    if (!isSparse || value.hasChannelName()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelName" , 11);
        const char *s = value.getChannelName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasChannelArtistName()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelArtistName" , 17);
        const char *s = value.getChannelArtistName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasChannelSongName()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelSongName" , 15);
        const char *s = value.getChannelSongName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPresetNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "PresetNumber" , 12);
        yajl_gen_integer(g, (long long)value.getPresetNumber());
    }
    if (!isSparse || value.hasIsLocked()) {
        yajl_gen_string(g, (const unsigned char*)  "IsLocked" , 8);
        yajl_gen_bool(g, (bool)value.getIsLocked());
    }
    if (!isSparse || value.hasIsAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "IsAvailable" , 11);
        yajl_gen_bool(g, (bool)value.getIsAvailable());
    }
    if (!isSparse || value.hasIsMature()) {
        yajl_gen_string(g, (const unsigned char*)  "IsMature" , 8);
        yajl_gen_bool(g, (bool)value.getIsMature());
    }
    if (!isSparse || value.hasIsSkipped()) {
        yajl_gen_string(g, (const unsigned char*)  "IsSkipped" , 9);
        yajl_gen_bool(g, (bool)value.getIsSkipped());
    }
    if (!isSparse || value.hasChannelGraphicAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelGraphicAvail" , 19);
        const char* s = ::sxm_audio_main_fi_types::T_e8_Graphics_Name(value.getChannelGraphicAvail());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getChannelGraphicAvail());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_ChannelListEntry& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_PresetListEntry"

void serializeJson (const ::sxm_audio_main_fi_types::T_PresetListEntry& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasServiceID()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceID" , 9);
        yajl_gen_integer(g, (long long)value.getServiceID());
    }
    if (!isSparse || value.hasChannelID()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelID" , 9);
        yajl_gen_integer(g, (long long)value.getChannelID());
    }
    if (!isSparse || value.hasChannelNameAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelNameAvail" , 16);
        yajl_gen_bool(g, (bool)value.getChannelNameAvail());
    }
    if (!isSparse || value.hasChannelName()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelName" , 11);
        const char *s = value.getChannelName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasChannelActive()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelActive" , 13);
        yajl_gen_bool(g, (bool)value.getChannelActive());
    }
    if (!isSparse || value.hasChnGraphicAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "ChnGraphicAvail" , 15);
        const char* s = ::sxm_audio_main_fi_types::T_e8_Graphics_Name(value.getChnGraphicAvail());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getChnGraphicAvail());
    }
    if (!isSparse || value.hasIsSmartFavorite()) {
        yajl_gen_string(g, (const unsigned char*)  "IsSmartFavorite" , 15);
        yajl_gen_bool(g, (bool)value.getIsSmartFavorite());
    }
    if (!isSparse || value.hasIsLocked()) {
        yajl_gen_string(g, (const unsigned char*)  "IsLocked" , 8);
        yajl_gen_bool(g, (bool)value.getIsLocked());
    }
    if (!isSparse || value.hasIsAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "IsAvailable" , 11);
        yajl_gen_bool(g, (bool)value.getIsAvailable());
    }
    if (!isSparse || value.hasIsMature()) {
        yajl_gen_string(g, (const unsigned char*)  "IsMature" , 8);
        yajl_gen_bool(g, (bool)value.getIsMature());
    }
    if (!isSparse || value.hasIsSkipped()) {
        yajl_gen_string(g, (const unsigned char*)  "IsSkipped" , 9);
        yajl_gen_bool(g, (bool)value.getIsSkipped());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_PresetListEntry& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_CategoryListEntry"

void serializeJson (const ::sxm_audio_main_fi_types::T_CategoryListEntry& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCategoryType()) {
        yajl_gen_string(g, (const unsigned char*)  "CategoryType" , 12);
        yajl_gen_integer(g, (long long)value.getCategoryType());
    }
    if (!isSparse || value.hasCategoryNameAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "CategoryNameAvail" , 17);
        yajl_gen_bool(g, (bool)value.getCategoryNameAvail());
    }
    if (!isSparse || value.hasCategoryName()) {
        yajl_gen_string(g, (const unsigned char*)  "CategoryName" , 12);
        const char *s = value.getCategoryName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasChannelList()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelList" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_audio_main_fi_types::T_ChannelListEntry >& o1 = value.getChannelList();
        {
            ::std::vector< ::sxm_audio_main_fi_types::T_ChannelListEntry >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_CategoryListEntry& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_ChannelInformation"

void serializeJson (const ::sxm_audio_main_fi_types::T_ChannelInformation& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannelNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelNumber" , 13);
        yajl_gen_integer(g, (long long)value.getChannelNumber());
    }
    if (!isSparse || value.hasSID()) {
        yajl_gen_string(g, (const unsigned char*)  "SID" , 3);
        yajl_gen_integer(g, (long long)value.getSID());
    }
    if (!isSparse || value.hasChannelNameAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelNameAvail" , 16);
        yajl_gen_bool(g, (bool)value.getChannelNameAvail());
    }
    if (!isSparse || value.hasChannelName()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelName" , 11);
        const char *s = value.getChannelName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCategoryType()) {
        yajl_gen_string(g, (const unsigned char*)  "CategoryType" , 12);
        yajl_gen_integer(g, (long long)value.getCategoryType());
    }
    if (!isSparse || value.hasPrimaryCategoryType()) {
        yajl_gen_string(g, (const unsigned char*)  "PrimaryCategoryType" , 19);
        yajl_gen_integer(g, (long long)value.getPrimaryCategoryType());
    }
    if (!isSparse || value.hasCategoryNameAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "CategoryNameAvail" , 17);
        yajl_gen_bool(g, (bool)value.getCategoryNameAvail());
    }
    if (!isSparse || value.hasCategoryName()) {
        yajl_gen_string(g, (const unsigned char*)  "CategoryName" , 12);
        const char *s = value.getCategoryName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasArtistSongnameAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "ArtistSongnameAvail" , 19);
        yajl_gen_bool(g, (bool)value.getArtistSongnameAvail());
    }
    if (!isSparse || value.hasArtistNameAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "ArtistNameAvail" , 15);
        yajl_gen_bool(g, (bool)value.getArtistNameAvail());
    }
    if (!isSparse || value.hasArtistName()) {
        yajl_gen_string(g, (const unsigned char*)  "ArtistName" , 10);
        const char *s = value.getArtistName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSongNameAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "SongNameAvail" , 13);
        yajl_gen_bool(g, (bool)value.getSongNameAvail());
    }
    if (!isSparse || value.hasSongName()) {
        yajl_gen_string(g, (const unsigned char*)  "SongName" , 8);
        const char *s = value.getSongName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasExtSongNameAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "ExtSongNameAvail" , 16);
        yajl_gen_bool(g, (bool)value.getExtSongNameAvail());
    }
    if (!isSparse || value.hasExtSongName()) {
        yajl_gen_string(g, (const unsigned char*)  "ExtSongName" , 11);
        const char *s = value.getExtSongName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasExtArtistNameAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "ExtArtistNameAvail" , 18);
        yajl_gen_bool(g, (bool)value.getExtArtistNameAvail());
    }
    if (!isSparse || value.hasExtArtistName()) {
        yajl_gen_string(g, (const unsigned char*)  "ExtArtistName" , 13);
        const char *s = value.getExtArtistName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasChnGraphicAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "ChnGraphicAvail" , 15);
        yajl_gen_bool(g, (bool)value.getChnGraphicAvail());
    }
    if (!isSparse || value.hasChnArtAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "ChnArtAvail" , 11);
        const char* s = ::sxm_audio_main_fi_types::T_e8_Graphics_Name(value.getChnArtAvail());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getChnArtAvail());
    }
    if (!isSparse || value.hasAlbumArtAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "AlbumArtAvail" , 13);
        const char* s = ::sxm_audio_main_fi_types::T_e8_Graphics_Name(value.getAlbumArtAvail());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAlbumArtAvail());
    }
    if (!isSparse || value.hasIsLocked()) {
        yajl_gen_string(g, (const unsigned char*)  "IsLocked" , 8);
        yajl_gen_bool(g, (bool)value.getIsLocked());
    }
    if (!isSparse || value.hasIsAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "IsAvailable" , 11);
        yajl_gen_bool(g, (bool)value.getIsAvailable());
    }
    if (!isSparse || value.hasIsMature()) {
        yajl_gen_string(g, (const unsigned char*)  "IsMature" , 8);
        yajl_gen_bool(g, (bool)value.getIsMature());
    }
    if (!isSparse || value.hasIsSkipped()) {
        yajl_gen_string(g, (const unsigned char*)  "IsSkipped" , 9);
        yajl_gen_bool(g, (bool)value.getIsSkipped());
    }
    if (!isSparse || value.hasArtistAlertStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ArtistAlertStatus" , 17);
        yajl_gen_bool(g, (bool)value.getArtistAlertStatus());
    }
    if (!isSparse || value.hasSongAlertStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SongAlertStatus" , 15);
        yajl_gen_bool(g, (bool)value.getSongAlertStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_ChannelInformation& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SxmSignalQuality"

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmSignalQuality& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAntennaStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "AntennaStatus" , 13);
        const char* s = ::sxm_audio_main_fi_types::T_e8_Sxm_AntennaState_Name(value.getAntennaStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAntennaStatus());
    }
    if (!isSparse || value.hasSignalQualityStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SignalQualityStatus" , 19);
        const char* s = ::sxm_audio_main_fi_types::T_e8_Sxm_SignalQuality_Name(value.getSignalQualityStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSignalQualityStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmSignalQuality& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SxmDetSignalQuality"

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmDetSignalQuality& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSigQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "SigQuality" , 10);
        const char *s = value.getSigQuality().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTunerStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "TunerStatus" , 11);
        const char *s = value.getTunerStatus().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasENSALockStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ENSALockStatus" , 14);
        const char *s = value.getENSALockStatus().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasENSBLockStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ENSBLockStatus" , 14);
        const char *s = value.getENSBLockStatus().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBerS1()) {
        yajl_gen_string(g, (const unsigned char*)  "BerS1" , 5);
        const char *s = value.getBerS1().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBerS2()) {
        yajl_gen_string(g, (const unsigned char*)  "BerS2" , 5);
        const char *s = value.getBerS2().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBerT()) {
        yajl_gen_string(g, (const unsigned char*)  "BerT" , 4);
        const char *s = value.getBerT().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCtoNS1A()) {
        yajl_gen_string(g, (const unsigned char*)  "CtoNS1A" , 7);
        const char *s = value.getCtoNS1A().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCtoNS1B()) {
        yajl_gen_string(g, (const unsigned char*)  "CtoNS1B" , 7);
        const char *s = value.getCtoNS1B().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCtoNS2A()) {
        yajl_gen_string(g, (const unsigned char*)  "CtoNS2A" , 7);
        const char *s = value.getCtoNS2A().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCtoNS2B()) {
        yajl_gen_string(g, (const unsigned char*)  "CtoNS2B" , 7);
        const char *s = value.getCtoNS2B().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRSErrsWords()) {
        yajl_gen_string(g, (const unsigned char*)  "RSErrsWords" , 11);
        const char *s = value.getRSErrsWords().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRSErrSatSymb()) {
        yajl_gen_string(g, (const unsigned char*)  "RSErrSatSymb" , 12);
        const char *s = value.getRSErrSatSymb().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRSErrTerrSymb()) {
        yajl_gen_string(g, (const unsigned char*)  "RSErrTerrSymb" , 13);
        const char *s = value.getRSErrTerrSymb().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTunerCarrFreqOfset()) {
        yajl_gen_string(g, (const unsigned char*)  "TunerCarrFreqOfset" , 18);
        const char *s = value.getTunerCarrFreqOfset().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRSSI()) {
        yajl_gen_string(g, (const unsigned char*)  "RSSI" , 4);
        const char *s = value.getRSSI().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmDetSignalQuality& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SxmDetOvrlSignalQuality"

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmDetOvrlSignalQuality& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasReceiverState()) {
        yajl_gen_string(g, (const unsigned char*)  "ReceiverState" , 13);
        const char *s = value.getReceiverState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOBerS1A()) {
        yajl_gen_string(g, (const unsigned char*)  "OBerS1A" , 7);
        const char *s = value.getOBerS1A().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOBerS2A()) {
        yajl_gen_string(g, (const unsigned char*)  "OBerS2A" , 7);
        const char *s = value.getOBerS2A().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOBerTA()) {
        yajl_gen_string(g, (const unsigned char*)  "OBerTA" , 6);
        const char *s = value.getOBerTA().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOBerS1B()) {
        yajl_gen_string(g, (const unsigned char*)  "OBerS1B" , 7);
        const char *s = value.getOBerS1B().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOBerS2B()) {
        yajl_gen_string(g, (const unsigned char*)  "OBerS2B" , 7);
        const char *s = value.getOBerS2B().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOBerTB()) {
        yajl_gen_string(g, (const unsigned char*)  "OBerTB" , 6);
        const char *s = value.getOBerTB().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOBERTrbWrdErRt0A()) {
        yajl_gen_string(g, (const unsigned char*)  "OBERTrbWrdErRt0A" , 16);
        const char *s = value.getOBERTrbWrdErRt0A().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOBERTrbWrdErRt0B()) {
        yajl_gen_string(g, (const unsigned char*)  "OBERTrbWrdErRt0B" , 16);
        const char *s = value.getOBERTrbWrdErRt0B().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOBERTrbWrdErRt1A()) {
        yajl_gen_string(g, (const unsigned char*)  "OBERTrbWrdErRt1A" , 16);
        const char *s = value.getOBERTrbWrdErRt1A().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOBERTrbWrdErRt1B()) {
        yajl_gen_string(g, (const unsigned char*)  "OBERTrbWrdErRt1B" , 16);
        const char *s = value.getOBERTrbWrdErRt1B().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOBERTrbWrdErRt2A()) {
        yajl_gen_string(g, (const unsigned char*)  "OBERTrbWrdErRt2A" , 16);
        const char *s = value.getOBERTrbWrdErRt2A().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOBERTrbWrdErRt2B()) {
        yajl_gen_string(g, (const unsigned char*)  "OBERTrbWrdErRt2B" , 16);
        const char *s = value.getOBERTrbWrdErRt2B().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmDetOvrlSignalQuality& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SxmVersionInfo"

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmVersionInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasModuleId()) {
        yajl_gen_string(g, (const unsigned char*)  "ModuleId" , 8);
        const char *s = value.getModuleId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasHwRev()) {
        yajl_gen_string(g, (const unsigned char*)  "HwRev" , 5);
        const char *s = value.getHwRev().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSwRev()) {
        yajl_gen_string(g, (const unsigned char*)  "SwRev" , 5);
        const char *s = value.getSwRev().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSxiRev()) {
        yajl_gen_string(g, (const unsigned char*)  "SxiRev" , 6);
        const char *s = value.getSxiRev().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBbRev()) {
        yajl_gen_string(g, (const unsigned char*)  "BbRev" , 5);
        const char *s = value.getBbRev().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasHDecRev()) {
        yajl_gen_string(g, (const unsigned char*)  "HDecRev" , 7);
        const char *s = value.getHDecRev().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRFRev()) {
        yajl_gen_string(g, (const unsigned char*)  "RFRev" , 5);
        const char *s = value.getRFRev().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCapability()) {
        yajl_gen_string(g, (const unsigned char*)  "Capability" , 10);
        const char *s = value.getCapability().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSPLRev()) {
        yajl_gen_string(g, (const unsigned char*)  "SPLRev" , 6);
        const char *s = value.getSPLRev().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmVersionInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SxmDataSubStatus"

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmDataSubStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSubStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SubStatus" , 9);
        yajl_gen_integer(g, (long long)value.getSubStatus());
    }
    if (!isSparse || value.hasReasonCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ReasonCode" , 10);
        yajl_gen_integer(g, (long long)value.getReasonCode());
    }
    if (!isSparse || value.hasSuspendedDate()) {
        yajl_gen_string(g, (const unsigned char*)  "SuspendedDate" , 13);
        yajl_gen_integer(g, (long long)value.getSuspendedDate());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmDataSubStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SxmDiagTestModeData"

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmDiagTestModeData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDetSignalQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "DetSignalQuality" , 16);
        serializeJson(value.getDetSignalQuality(), g, options);
    }
    if (!isSparse || value.hasDetOvrlSignalQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "DetOvrlSignalQuality" , 20);
        serializeJson(value.getDetOvrlSignalQuality(), g, options);
    }
    if (!isSparse || value.hasSxmVersionInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "SxmVersionInfo" , 14);
        serializeJson(value.getSxmVersionInfo(), g, options);
    }
    if (!isSparse || value.hasSxmSubscriptionState()) {
        yajl_gen_string(g, (const unsigned char*)  "SxmSubscriptionState" , 20);
        serializeJson(value.getSxmSubscriptionState(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmDiagTestModeData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SxmSmsDbInfo"

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmSmsDbInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCgsDb()) {
        yajl_gen_string(g, (const unsigned char*)  "CgsDb" , 5);
        const char *s = value.getCgsDb().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFuelDb()) {
        yajl_gen_string(g, (const unsigned char*)  "FuelDb" , 6);
        const char *s = value.getFuelDb().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMovieDb()) {
        yajl_gen_string(g, (const unsigned char*)  "MovieDb" , 7);
        const char *s = value.getMovieDb().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTabWeatherDb()) {
        yajl_gen_string(g, (const unsigned char*)  "TabWeatherDb" , 12);
        const char *s = value.getTabWeatherDb().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStockDb()) {
        yajl_gen_string(g, (const unsigned char*)  "StockDb" , 7);
        const char *s = value.getStockDb().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasWsAlertsDb()) {
        yajl_gen_string(g, (const unsigned char*)  "WsAlertsDb" , 10);
        const char *s = value.getWsAlertsDb().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSportsDB()) {
        yajl_gen_string(g, (const unsigned char*)  "SportsDB" , 8);
        const char *s = value.getSportsDB().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasParkingDB()) {
        yajl_gen_string(g, (const unsigned char*)  "ParkingDB" , 9);
        const char *s = value.getParkingDB().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPhoneticsDB()) {
        yajl_gen_string(g, (const unsigned char*)  "PhoneticsDB" , 11);
        const char *s = value.getPhoneticsDB().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFuelCanadaDB()) {
        yajl_gen_string(g, (const unsigned char*)  "FuelCanadaDB" , 12);
        const char *s = value.getFuelCanadaDB().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSafeViewdb()) {
        yajl_gen_string(g, (const unsigned char*)  "SafeViewdb" , 10);
        const char *s = value.getSafeViewdb().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSmsVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "SmsVersion" , 10);
        const char *s = value.getSmsVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmSmsDbInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SxmAudioSubInfo"

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmAudioSubInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSubStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SubStatus" , 9);
        yajl_gen_integer(g, (long long)value.getSubStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SxmAudioSubInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SmartFavoritePreset"

void serializeJson (const ::sxm_audio_main_fi_types::T_SmartFavoritePreset& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPresetIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "PresetIndex" , 11);
        yajl_gen_integer(g, (long long)value.getPresetIndex());
    }
    if (!isSparse || value.hasIsSmartFavorite()) {
        yajl_gen_string(g, (const unsigned char*)  "IsSmartFavorite" , 15);
        yajl_gen_bool(g, (bool)value.getIsSmartFavorite());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SmartFavoritePreset& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SFListElement"

void serializeJson (const ::sxm_audio_main_fi_types::T_SFListElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPresetIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "PresetIndex" , 11);
        yajl_gen_integer(g, (long long)value.getPresetIndex());
    }
    if (!isSparse || value.hasIsRepeated()) {
        yajl_gen_string(g, (const unsigned char*)  "IsRepeated" , 10);
        yajl_gen_bool(g, (bool)value.getIsRepeated());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SFListElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_InstantReplayStatus"

void serializeJson (const ::sxm_audio_main_fi_types::T_InstantReplayStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRecordDuration()) {
        yajl_gen_string(g, (const unsigned char*)  "RecordDuration" , 14);
        yajl_gen_integer(g, (long long)value.getRecordDuration());
    }
    if (!isSparse || value.hasTimeToLive()) {
        yajl_gen_string(g, (const unsigned char*)  "TimeToLive" , 10);
        yajl_gen_integer(g, (long long)value.getTimeToLive());
    }
    if (!isSparse || value.hasPlayPercentage()) {
        yajl_gen_string(g, (const unsigned char*)  "PlayPercentage" , 14);
        yajl_gen_integer(g, (long long)value.getPlayPercentage());
    }
    if (!isSparse || value.hasFillPercentage()) {
        yajl_gen_string(g, (const unsigned char*)  "FillPercentage" , 14);
        yajl_gen_integer(g, (long long)value.getFillPercentage());
    }
    if (!isSparse || value.hasElapsedTime()) {
        yajl_gen_string(g, (const unsigned char*)  "ElapsedTime" , 11);
        yajl_gen_integer(g, (long long)value.getElapsedTime());
    }
    if (!isSparse || value.hasPlaybackStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "PlaybackStatus" , 14);
        const char* s = ::sxm_audio_main_fi_types::T_e8_IRPlaybackStatus_Name(value.getPlaybackStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getPlaybackStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_InstantReplayStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_RegisteredFavorite"

void serializeJson (const ::sxm_audio_main_fi_types::T_RegisteredFavorite& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasContentName()) {
        yajl_gen_string(g, (const unsigned char*)  "ContentName" , 11);
        const char *s = value.getContentName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasIsEnabled()) {
        yajl_gen_string(g, (const unsigned char*)  "IsEnabled" , 9);
        yajl_gen_bool(g, (bool)value.getIsEnabled());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_RegisteredFavorite& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_ChannelStatus"

void serializeJson (const ::sxm_audio_main_fi_types::T_b8_ChannelStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getCHANNEL_STATUS_MATURED()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_STATUS_MATURED" , 22);
        yajl_gen_bool(g, (bool)value.getCHANNEL_STATUS_MATURED());
    }
    if (value.getCHANNEL_STATUS_LOCKED()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_STATUS_LOCKED" , 21);
        yajl_gen_bool(g, (bool)value.getCHANNEL_STATUS_LOCKED());
    }
    if (value.getCHANNEL_STATUS_SKIPPED()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_STATUS_SKIPPED" , 22);
        yajl_gen_bool(g, (bool)value.getCHANNEL_STATUS_SKIPPED());
    }
    if (value.getCHANNEL_STATUS_TUNABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_STATUS_TUNABLE" , 22);
        yajl_gen_bool(g, (bool)value.getCHANNEL_STATUS_TUNABLE());
    }
    if (value.getCHANNEL_STATUS_B4_RFU()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_STATUS_B4_RFU" , 21);
        yajl_gen_bool(g, (bool)value.getCHANNEL_STATUS_B4_RFU());
    }
    if (value.getCHANNEL_STATUS_B5_RFU()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_STATUS_B5_RFU" , 21);
        yajl_gen_bool(g, (bool)value.getCHANNEL_STATUS_B5_RFU());
    }
    if (value.getCHANNEL_STATUS_B6_RFU()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_STATUS_B6_RFU" , 21);
        yajl_gen_bool(g, (bool)value.getCHANNEL_STATUS_B6_RFU());
    }
    if (value.getCHANNEL_STATUS_B7_RFU()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_STATUS_B7_RFU" , 21);
        yajl_gen_bool(g, (bool)value.getCHANNEL_STATUS_B7_RFU());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_b8_ChannelStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AlertInfo"

void serializeJson (const ::sxm_audio_main_fi_types::T_AlertInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasServiceID()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceID" , 9);
        yajl_gen_integer(g, (long long)value.getServiceID());
    }
    if (!isSparse || value.hasChannelID()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelID" , 9);
        yajl_gen_integer(g, (long long)value.getChannelID());
    }
    if (!isSparse || value.hasFavoriteType()) {
        yajl_gen_string(g, (const unsigned char*)  "FavoriteType" , 12);
        const char* s = ::sxm_audio_main_fi_types::T_e8_FavoriteType_Name(value.getFavoriteType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getFavoriteType());
    }
    if (!isSparse || value.hasChannelName()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelName" , 11);
        const char *s = value.getChannelName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasArtistName()) {
        yajl_gen_string(g, (const unsigned char*)  "ArtistName" , 10);
        const char *s = value.getArtistName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSongName()) {
        yajl_gen_string(g, (const unsigned char*)  "SongName" , 8);
        const char *s = value.getSongName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasChnGraphicsAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "ChnGraphicsAvailable" , 20);
        const char* s = ::sxm_audio_main_fi_types::T_e8_Graphics_Name(value.getChnGraphicsAvailable());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getChnGraphicsAvailable());
    }
    if (!isSparse || value.hasChannelStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelStatus" , 13);
        serializeJson(value.getChannelStatus(), g, options);
    }
    if (!isSparse || value.hasIsExpired()) {
        yajl_gen_string(g, (const unsigned char*)  "IsExpired" , 9);
        yajl_gen_bool(g, (bool)value.getIsExpired());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_AlertInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MarketListEntry"

void serializeJson (const ::sxm_audio_main_fi_types::T_MarketListEntry& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAbbrMarketName()) {
        yajl_gen_string(g, (const unsigned char*)  "AbbrMarketName" , 14);
        const char *s = value.getAbbrMarketName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFullMarketName()) {
        yajl_gen_string(g, (const unsigned char*)  "FullMarketName" , 14);
        const char *s = value.getFullMarketName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBIsActiveMarket()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsActiveMarket" , 15);
        yajl_gen_bool(g, (bool)value.getBIsActiveMarket());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_MarketListEntry& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SportsFlash_FavoriteTeam"

void serializeJson (const ::sxm_audio_main_fi_types::T_SportsFlash_FavoriteTeam& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSportType()) {
        yajl_gen_string(g, (const unsigned char*)  "SportType" , 9);
        const char* s = ::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport_Name(value.getSportType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSportType());
    }
    if (!isSparse || value.hasLeagueID()) {
        yajl_gen_string(g, (const unsigned char*)  "LeagueID" , 8);
        yajl_gen_integer(g, (long long)value.getLeagueID());
    }
    if (!isSparse || value.hasLeagueType()) {
        yajl_gen_string(g, (const unsigned char*)  "LeagueType" , 10);
        const char* s = ::sxm_audio_main_fi_types::T_e8_SportsFlash_League_Name(value.getLeagueType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLeagueType());
    }
    if (!isSparse || value.hasLeagueAbbrName()) {
        yajl_gen_string(g, (const unsigned char*)  "LeagueAbbrName" , 14);
        const char *s = value.getLeagueAbbrName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasLeagueFullName()) {
        yajl_gen_string(g, (const unsigned char*)  "LeagueFullName" , 14);
        const char *s = value.getLeagueFullName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeamID()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamID" , 6);
        yajl_gen_integer(g, (long long)value.getTeamID());
    }
    if (!isSparse || value.hasTeamName()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamName" , 8);
        const char *s = value.getTeamName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeamNickName()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamNickName" , 12);
        const char *s = value.getTeamNickName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeamAbbrName()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamAbbrName" , 12);
        const char *s = value.getTeamAbbrName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeamFullName()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamFullName" , 12);
        const char *s = value.getTeamFullName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasIsFavorite()) {
        yajl_gen_string(g, (const unsigned char*)  "IsFavorite" , 10);
        yajl_gen_bool(g, (bool)value.getIsFavorite());
    }
    if (!isSparse || value.hasIsMonitored()) {
        yajl_gen_string(g, (const unsigned char*)  "IsMonitored" , 11);
        yajl_gen_bool(g, (bool)value.getIsMonitored());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SportsFlash_FavoriteTeam& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SportsFlash_Game"

void serializeJson (const ::sxm_audio_main_fi_types::T_SportsFlash_Game& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannelID()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelID" , 9);
        yajl_gen_integer(g, (long long)value.getChannelID());
    }
    if (!isSparse || value.hasServiceID()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceID" , 9);
        yajl_gen_integer(g, (long long)value.getServiceID());
    }
    if (!isSparse || value.hasIsLocked()) {
        yajl_gen_string(g, (const unsigned char*)  "IsLocked" , 8);
        yajl_gen_bool(g, (bool)value.getIsLocked());
    }
    if (!isSparse || value.hasIsMature()) {
        yajl_gen_string(g, (const unsigned char*)  "IsMature" , 8);
        yajl_gen_bool(g, (bool)value.getIsMature());
    }
    if (!isSparse || value.hasIsSkipped()) {
        yajl_gen_string(g, (const unsigned char*)  "IsSkipped" , 9);
        yajl_gen_bool(g, (bool)value.getIsSkipped());
    }
    if (!isSparse || value.hasBias()) {
        yajl_gen_string(g, (const unsigned char*)  "Bias" , 4);
        yajl_gen_integer(g, (long long)value.getBias());
    }
    if (!isSparse || value.hasHomeTeam()) {
        yajl_gen_string(g, (const unsigned char*)  "HomeTeam" , 8);
        serializeJson(value.getHomeTeam(), g, options);
    }
    if (!isSparse || value.hasAwayTeam()) {
        yajl_gen_string(g, (const unsigned char*)  "AwayTeam" , 8);
        serializeJson(value.getAwayTeam(), g, options);
    }
    if (!isSparse || value.hasChnGraphicsAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "ChnGraphicsAvailable" , 20);
        const char* s = ::sxm_audio_main_fi_types::T_e8_Graphics_Name(value.getChnGraphicsAvailable());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getChnGraphicsAvailable());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SportsFlash_Game& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SportsFlash_FlashEvent"

void serializeJson (const ::sxm_audio_main_fi_types::T_SportsFlash_FlashEvent& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGameInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "GameInfo" , 8);
        serializeJson(value.getGameInfo(), g, options);
    }
    if (!isSparse || value.hasFlashEventID()) {
        yajl_gen_string(g, (const unsigned char*)  "FlashEventID" , 12);
        yajl_gen_integer(g, (long long)value.getFlashEventID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SportsFlash_FlashEvent& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SportsFlash_League"

void serializeJson (const ::sxm_audio_main_fi_types::T_SportsFlash_League& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSportType()) {
        yajl_gen_string(g, (const unsigned char*)  "SportType" , 9);
        const char* s = ::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport_Name(value.getSportType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSportType());
    }
    if (!isSparse || value.hasLeagueID()) {
        yajl_gen_string(g, (const unsigned char*)  "LeagueID" , 8);
        yajl_gen_integer(g, (long long)value.getLeagueID());
    }
    if (!isSparse || value.hasLeagueType()) {
        yajl_gen_string(g, (const unsigned char*)  "LeagueType" , 10);
        const char* s = ::sxm_audio_main_fi_types::T_e8_SportsFlash_League_Name(value.getLeagueType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLeagueType());
    }
    if (!isSparse || value.hasLeagueAbbrName()) {
        yajl_gen_string(g, (const unsigned char*)  "LeagueAbbrName" , 14);
        const char *s = value.getLeagueAbbrName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasLeagueFullName()) {
        yajl_gen_string(g, (const unsigned char*)  "LeagueFullName" , 14);
        const char *s = value.getLeagueFullName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SportsFlash_League& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SportsFlash_Team"

void serializeJson (const ::sxm_audio_main_fi_types::T_SportsFlash_Team& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTeamID()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamID" , 6);
        yajl_gen_integer(g, (long long)value.getTeamID());
    }
    if (!isSparse || value.hasTeamName()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamName" , 8);
        const char *s = value.getTeamName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeamNickName()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamNickName" , 12);
        const char *s = value.getTeamNickName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeamAbbrName()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamAbbrName" , 12);
        const char *s = value.getTeamAbbrName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeamFullName()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamFullName" , 12);
        const char *s = value.getTeamFullName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasIsFavorite()) {
        yajl_gen_string(g, (const unsigned char*)  "IsFavorite" , 10);
        yajl_gen_bool(g, (bool)value.getIsFavorite());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SportsFlash_Team& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SportsFlash_MonitorTeam"

void serializeJson (const ::sxm_audio_main_fi_types::T_SportsFlash_MonitorTeam& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLeagueID()) {
        yajl_gen_string(g, (const unsigned char*)  "LeagueID" , 8);
        yajl_gen_integer(g, (long long)value.getLeagueID());
    }
    if (!isSparse || value.hasTeamID()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamID" , 6);
        yajl_gen_integer(g, (long long)value.getTeamID());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_SportsFlash_MonitorTeam& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_BrowseRateConfiguration"

void serializeJson (const ::sxm_audio_main_fi_types::T_BrowseRateConfiguration& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDuration()) {
        yajl_gen_string(g, (const unsigned char*)  "duration" , 8);
        yajl_gen_integer(g, (long long)value.getDuration());
    }
    if (!isSparse || value.hasRate()) {
        yajl_gen_string(g, (const unsigned char*)  "rate" , 4);
        yajl_gen_integer(g, (long long)value.getRate());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_BrowseRateConfiguration& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_BrowseChannelConfig"

void serializeJson (const ::sxm_audio_main_fi_types::T_BrowseChannelConfig& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfiguration()) {
        yajl_gen_string(g, (const unsigned char*)  "Configuration" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_audio_main_fi_types::T_BrowseRateConfiguration >& o3 = value.getConfiguration();
        {
            ::std::vector< ::sxm_audio_main_fi_types::T_BrowseRateConfiguration >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasLoop()) {
        yajl_gen_string(g, (const unsigned char*)  "Loop" , 4);
        const char* s = ::sxm_audio_main_fi_types::T_e8_BrowseChannelLoop_Name(value.getLoop());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLoop());
    }
    if (!isSparse || value.hasType()) {
        yajl_gen_string(g, (const unsigned char*)  "Type" , 4);
        const char* s = ::sxm_audio_main_fi_types::T_e8_BrowseChannelType_Name(value.getType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_BrowseChannelConfig& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b16_CHANNEL_EVENT"

void serializeJson (const ::sxm_audio_main_fi_types::T_b16_CHANNEL_EVENT& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getCHANNEL_EVENT_SERVICE_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_SERVICE_ID" , 24);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_SERVICE_ID());
    }
    if (value.getCHANNEL_EVENT_CHANNEL_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_CHANNEL_ID" , 24);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_CHANNEL_ID());
    }
    if (value.getCHANNEL_EVENT_ATTRIBUTES()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_ATTRIBUTES" , 24);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_ATTRIBUTES());
    }
    if (value.getCHANNEL_EVENT_NAME()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_NAME" , 18);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_NAME());
    }
    if (value.getCHANNEL_EVENT_CATEGORY()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_CATEGORY" , 22);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_CATEGORY());
    }
    if (value.getCHANNEL_EVENT_TITLE()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_TITLE" , 19);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_TITLE());
    }
    if (value.getCHANNEL_EVENT_ARTIST()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_ARTIST" , 20);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_ARTIST());
    }
    if (value.getCHANNEL_EVENT_ALBUM()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_ALBUM" , 19);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_ALBUM());
    }
    if (value.getCHANNEL_EVENT_ART()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_ART" , 17);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_ART());
    }
    if (value.getCHANNEL_EVENT_REMOVED()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_REMOVED" , 21);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_REMOVED());
    }
    if (value.getCHANNEL_EVENT_b10_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_b10_reserved" , 26);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_b10_reserved());
    }
    if (value.getCHANNEL_EVENT_b11_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_b11_reserved" , 26);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_b11_reserved());
    }
    if (value.getCHANNEL_EVENT_b12_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_b12_reserved" , 26);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_b12_reserved());
    }
    if (value.getCHANNEL_EVENT_b13_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_b13_reserved" , 26);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_b13_reserved());
    }
    if (value.getCHANNEL_EVENT_b14_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_b14_reserved" , 26);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_b14_reserved());
    }
    if (value.getCHANNEL_EVENT_b15_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "CHANNEL_EVENT_b15_reserved" , 26);
        yajl_gen_bool(g, (bool)value.getCHANNEL_EVENT_b15_reserved());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_b16_CHANNEL_EVENT& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_LocalTimeDate"

void serializeJson (const ::sxm_audio_main_fi_types::T_LocalTimeDate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Year" , 7);
        yajl_gen_integer(g, (long long)value.getS16Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    if (!isSparse || value.hasU8Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Day" , 5);
        yajl_gen_integer(g, (long long)value.getU8Day());
    }
    if (!isSparse || value.hasU8Hours()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hours" , 7);
        yajl_gen_integer(g, (long long)value.getU8Hours());
    }
    if (!isSparse || value.hasU8Minutes()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minutes" , 9);
        yajl_gen_integer(g, (long long)value.getU8Minutes());
    }
    if (!isSparse || value.hasU8Seconds()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Seconds" , 9);
        yajl_gen_integer(g, (long long)value.getU8Seconds());
    }
    if (!isSparse || value.hasU8Weekday()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Weekday" , 9);
        yajl_gen_integer(g, (long long)value.getU8Weekday());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_LocalTimeDate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_PresetEntry"

void serializeJson (const ::sxm_audio_main_fi_types::T_PresetEntry& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "Index" , 5);
        yajl_gen_integer(g, (long long)value.getIndex());
    }
    if (!isSparse || value.hasSID()) {
        yajl_gen_string(g, (const unsigned char*)  "SID" , 3);
        yajl_gen_integer(g, (long long)value.getSID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_PresetEntry& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_ProfileResponse"

void serializeJson (const ::sxm_audio_main_fi_types::T_ProfileResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        const char* s = ::sxm_audio_main_fi_types::T_Status_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    if (!isSparse || value.hasProfileAction()) {
        yajl_gen_string(g, (const unsigned char*)  "ProfileAction" , 13);
        const char* s = ::sxm_audio_main_fi_types::T_ProfileAction_Name(value.getProfileAction());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getProfileAction());
    }
    if (!isSparse || value.hasProfileStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ProfileStatus" , 13);
        const char* s = ::sxm_audio_main_fi_types::T_ProfileStatus_Name(value.getProfileStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getProfileStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_ProfileResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_PresetsConfiguration"

void serializeJson (const ::sxm_audio_main_fi_types::T_PresetsConfiguration& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBandCount()) {
        yajl_gen_string(g, (const unsigned char*)  "BandCount" , 9);
        yajl_gen_integer(g, (long long)value.getBandCount());
    }
    if (!isSparse || value.hasBandCapacity()) {
        yajl_gen_string(g, (const unsigned char*)  "BandCapacity" , 12);
        yajl_gen_integer(g, (long long)value.getBandCapacity());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_audio_main_fi_types::T_PresetsConfiguration& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_ChannelListEntry& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_PresetListEntry& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_CategoryListEntry& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_ChannelInformation& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SxmSignalQuality& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SxmDetSignalQuality& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SxmDetOvrlSignalQuality& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SxmVersionInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SxmDataSubStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SxmDiagTestModeData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SxmSmsDbInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SxmAudioSubInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SmartFavoritePreset& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SFListElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_InstantReplayStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_RegisteredFavorite& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_b8_ChannelStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_AlertInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_MarketListEntry& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SportsFlash_FavoriteTeam& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SportsFlash_Game& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SportsFlash_FlashEvent& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SportsFlash_League& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SportsFlash_Team& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_SportsFlash_MonitorTeam& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_BrowseRateConfiguration& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_BrowseChannelConfig& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_b16_CHANNEL_EVENT& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_LocalTimeDate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_PresetEntry& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_ProfileResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_audio_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_audio_main_fi_types::T_PresetsConfiguration& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_audio_main_fi_types

