#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_AUDIO_MAIN_FI_TYPES_H
#define SXM_AUDIO_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_audio_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sxm_audio_main_fi_types
 */

namespace sxm_audio_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_ChannelListEntry;

class T_PresetListEntry;

class T_CategoryListEntry;

class T_ChannelInformation;

class T_SxmSignalQuality;

class T_SxmDetSignalQuality;

class T_SxmDetOvrlSignalQuality;

class T_SxmVersionInfo;

class T_SxmDataSubStatus;

class T_SxmDiagTestModeData;

class T_SxmSmsDbInfo;

class T_SxmAudioSubInfo;

class T_SmartFavoritePreset;

class T_SFListElement;

class T_InstantReplayStatus;

class T_RegisteredFavorite;

class T_b8_ChannelStatus;

class T_AlertInfo;

class T_MarketListEntry;

class T_SportsFlash_FavoriteTeam;

class T_SportsFlash_Game;

class T_SportsFlash_FlashEvent;

class T_SportsFlash_League;

class T_SportsFlash_Team;

class T_SportsFlash_MonitorTeam;

class T_BrowseRateConfiguration;

class T_BrowseChannelConfig;

class T_b16_CHANNEL_EVENT;

class T_LocalTimeDate;

class T_PresetEntry;

class T_ProfileResponse;

class T_PresetsConfiguration;

// type definitions
/**
 * If the meaning of "T_ChannelList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_ChannelListEntry > T_ChannelList;

/**
 * If the meaning of "T_PresetChannelList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_PresetListEntry > T_PresetChannelList;

/**
 * If the meaning of "T_MarketList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MarketListEntry > T_MarketList;


/**
 * If the meaning of "T_ChannelListEntry" isn't clear, then there should be a description here.
 */
class T_ChannelListEntry {
public:

    /**
     * Default constructor
     */
    inline  T_ChannelListEntry ();

    /**
     * Copy constructor
     */
    inline  T_ChannelListEntry (const T_ChannelListEntry &rhs);

    /**
     * All fields constructor
     */
    inline  T_ChannelListEntry (uint16 ServiceID_, uint16 ChannelID_, bool ChannelNameAvail_, const ::std::string& ChannelName_, const ::std::string& ChannelArtistName_, const ::std::string& ChannelSongName_, uint8 PresetNumber_, bool IsLocked_, bool IsAvailable_, bool IsMature_, bool IsSkipped_, T_e8_Graphics ChannelGraphicAvail_);

    /**
     * Destructor
     */
    inline  ~T_ChannelListEntry();

    /**
     * Assignment operator
     */
    inline T_ChannelListEntry& operator = (const T_ChannelListEntry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ChannelListEntry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ChannelListEntry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ChannelListEntry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ChannelListEntry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceID"

    static const int kServiceID = 0;

    /**
     * Clears the field "ServiceID".
     *
     * The field will be set to its default value. The hasServiceID()
     * method will return false.
     */
    inline void clearServiceID();

    /**
     * Checks whether the field "ServiceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceID()). Otherwise it will return false.
     */
    inline bool hasServiceID () const;

    /**
     * Returns the value of the member "ServiceID".
     *
     * Unique identifier of the service
     *
     * @return The value of the field "ServiceID"
     */
    inline uint16 getServiceID () const;

    /**
     * Sets the value of the member "ServiceID".
     *
     * Unique identifier of the service
     *
     * @param ServiceID The value which will be set
     */
    inline void setServiceID (uint16 ServiceID_);

    // API of field "ChannelID"

    static const int kChannelID = 1;

    /**
     * Clears the field "ChannelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "ChannelID".
     *
     * Unique identifier of the channel
     *
     * @return The value of the field "ChannelID"
     */
    inline uint16 getChannelID () const;

    /**
     * Sets the value of the member "ChannelID".
     *
     * Unique identifier of the channel
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (uint16 ChannelID_);

    // API of field "ChannelNameAvail"

    static const int kChannelNameAvail = 2;

    /**
     * Clears the field "ChannelNameAvail".
     *
     * The field will be set to its default value. The hasChannelNameAvail()
     * method will return false.
     */
    inline void clearChannelNameAvail();

    /**
     * Checks whether the field "ChannelNameAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelNameAvail()). Otherwise it will return false.
     */
    inline bool hasChannelNameAvail () const;

    /**
     * Returns the value of the member "ChannelNameAvail".
     *
     * Channel name is available or not.
     * TRUE = Available, FALSE = Not available
     *
     * @return The value of the field "ChannelNameAvail"
     */
    inline bool getChannelNameAvail () const;

    /**
     * Sets the value of the member "ChannelNameAvail".
     *
     * Channel name is available or not.
     * TRUE = Available, FALSE = Not available
     *
     * @param ChannelNameAvail The value which will be set
     */
    inline void setChannelNameAvail (bool ChannelNameAvail_);

    // API of field "ChannelName"

    static const int kChannelName = 3;

    /**
     * Clears the field "ChannelName".
     *
     * The field will be set to its default value. The hasChannelName()
     * method will return false.
     */
    inline void clearChannelName();

    /**
     * Checks whether the field "ChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelName()). Otherwise it will return false.
     */
    inline bool hasChannelName () const;

    /**
     * Returns the value of the member "ChannelName".
     *
     * Name of the channel. The maximum size for the ChannelName
     * is 16 bytes (ASCII characters).
     *
     * @return The value of the field "ChannelName"
     */
    inline const ::std::string& getChannelName () const;

    /**
     * Retrieves the value of the field "ChannelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelName".
     */
    inline ::std::string& getChannelNameMutable ();

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of the channel. The maximum size for the ChannelName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const ::std::string& ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of the channel. The maximum size for the ChannelName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of the channel. The maximum size for the ChannelName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* value, size_t size);

    // API of field "ChannelArtistName"

    static const int kChannelArtistName = 4;

    /**
     * Clears the field "ChannelArtistName".
     *
     * The field will be set to its default value. The hasChannelArtistName()
     * method will return false.
     */
    inline void clearChannelArtistName();

    /**
     * Checks whether the field "ChannelArtistName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelArtistName()). Otherwise it will return false.
     */
    inline bool hasChannelArtistName () const;

    /**
     * Returns the value of the member "ChannelArtistName".
     *
     * Name of the artist. The maximum size for the ChannelArtistName
     * is 16 bytes (ASCII characters).
     *
     * @return The value of the field "ChannelArtistName"
     */
    inline const ::std::string& getChannelArtistName () const;

    /**
     * Retrieves the value of the field "ChannelArtistName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelArtistName".
     */
    inline ::std::string& getChannelArtistNameMutable ();

    /**
     * Sets the value of the member "ChannelArtistName".
     *
     * Name of the artist. The maximum size for the ChannelArtistName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelArtistName The value which will be set
     */
    inline void setChannelArtistName (const ::std::string& ChannelArtistName_);

    /**
     * Sets the value of the member "ChannelArtistName".
     *
     * Name of the artist. The maximum size for the ChannelArtistName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelArtistName The value which will be set
     */
    inline void setChannelArtistName (const char* ChannelArtistName_);

    /**
     * Sets the value of the member "ChannelArtistName".
     *
     * Name of the artist. The maximum size for the ChannelArtistName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelArtistName The value which will be set
     */
    inline void setChannelArtistName (const char* value, size_t size);

    // API of field "ChannelSongName"

    static const int kChannelSongName = 5;

    /**
     * Clears the field "ChannelSongName".
     *
     * The field will be set to its default value. The hasChannelSongName()
     * method will return false.
     */
    inline void clearChannelSongName();

    /**
     * Checks whether the field "ChannelSongName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelSongName()). Otherwise it will return false.
     */
    inline bool hasChannelSongName () const;

    /**
     * Returns the value of the member "ChannelSongName".
     *
     * Name of the song. The maximum size for the ChannelSongName
     * is 16 bytes (ASCII characters).
     *
     * @return The value of the field "ChannelSongName"
     */
    inline const ::std::string& getChannelSongName () const;

    /**
     * Retrieves the value of the field "ChannelSongName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelSongName".
     */
    inline ::std::string& getChannelSongNameMutable ();

    /**
     * Sets the value of the member "ChannelSongName".
     *
     * Name of the song. The maximum size for the ChannelSongName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelSongName The value which will be set
     */
    inline void setChannelSongName (const ::std::string& ChannelSongName_);

    /**
     * Sets the value of the member "ChannelSongName".
     *
     * Name of the song. The maximum size for the ChannelSongName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelSongName The value which will be set
     */
    inline void setChannelSongName (const char* ChannelSongName_);

    /**
     * Sets the value of the member "ChannelSongName".
     *
     * Name of the song. The maximum size for the ChannelSongName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelSongName The value which will be set
     */
    inline void setChannelSongName (const char* value, size_t size);

    // API of field "PresetNumber"

    static const int kPresetNumber = 6;

    /**
     * Clears the field "PresetNumber".
     *
     * The field will be set to its default value. The hasPresetNumber()
     * method will return false.
     */
    inline void clearPresetNumber();

    /**
     * Checks whether the field "PresetNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetNumber()). Otherwise it will return false.
     */
    inline bool hasPresetNumber () const;

    /**
     * Returns the value of the member "PresetNumber".
     *
     * Identify the preset number. If the value is 0 the channel
     * is not in the preset list. Otherwise the value is 1 to max
     * number preset.
     *
     * @return The value of the field "PresetNumber"
     */
    inline uint8 getPresetNumber () const;

    /**
     * Sets the value of the member "PresetNumber".
     *
     * Identify the preset number. If the value is 0 the channel
     * is not in the preset list. Otherwise the value is 1 to max
     * number preset.
     *
     * @param PresetNumber The value which will be set
     */
    inline void setPresetNumber (uint8 PresetNumber_);

    // API of field "IsLocked"

    static const int kIsLocked = 7;

    /**
     * Clears the field "IsLocked".
     *
     * The field will be set to its default value. The hasIsLocked()
     * method will return false.
     */
    inline void clearIsLocked();

    /**
     * Checks whether the field "IsLocked" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsLocked()). Otherwise it will return false.
     */
    inline bool hasIsLocked () const;

    /**
     * Returns the value of the member "IsLocked".
     *
     * Channel's Lock status.
     * TRUE, if the channel is locked;
     * FALSE, if the channel is unlocked;
     *
     * @return The value of the field "IsLocked"
     */
    inline bool getIsLocked () const;

    /**
     * Sets the value of the member "IsLocked".
     *
     * Channel's Lock status.
     * TRUE, if the channel is locked;
     * FALSE, if the channel is unlocked;
     *
     * @param IsLocked The value which will be set
     */
    inline void setIsLocked (bool IsLocked_);

    // API of field "IsAvailable"

    static const int kIsAvailable = 8;

    /**
     * Clears the field "IsAvailable".
     *
     * The field will be set to its default value. The hasIsAvailable()
     * method will return false.
     */
    inline void clearIsAvailable();

    /**
     * Checks whether the field "IsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsAvailable()). Otherwise it will return false.
     */
    inline bool hasIsAvailable () const;

    /**
     * Returns the value of the member "IsAvailable".
     *
     * Channel's Availability status.
     * TRUE, if the channel is subscribed and available;
     * FALSE, if the channel is either unsubscribed or not aired;
     *
     * @return The value of the field "IsAvailable"
     */
    inline bool getIsAvailable () const;

    /**
     * Sets the value of the member "IsAvailable".
     *
     * Channel's Availability status.
     * TRUE, if the channel is subscribed and available;
     * FALSE, if the channel is either unsubscribed or not aired;
     *
     * @param IsAvailable The value which will be set
     */
    inline void setIsAvailable (bool IsAvailable_);

    // API of field "IsMature"

    static const int kIsMature = 9;

    /**
     * Clears the field "IsMature".
     *
     * The field will be set to its default value. The hasIsMature()
     * method will return false.
     */
    inline void clearIsMature();

    /**
     * Checks whether the field "IsMature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMature()). Otherwise it will return false.
     */
    inline bool hasIsMature () const;

    /**
     * Returns the value of the member "IsMature".
     *
     * Channel's Broadcast content type.
     * TRUE, if the channel is identified as a channel which MAY be broadcasting mature or adult content and may need Parental Guidance;
     * FALSE, if Parental Guidance not required;
     *
     * @return The value of the field "IsMature"
     */
    inline bool getIsMature () const;

    /**
     * Sets the value of the member "IsMature".
     *
     * Channel's Broadcast content type.
     * TRUE, if the channel is identified as a channel which MAY be broadcasting mature or adult content and may need Parental Guidance;
     * FALSE, if Parental Guidance not required;
     *
     * @param IsMature The value which will be set
     */
    inline void setIsMature (bool IsMature_);

    // API of field "IsSkipped"

    static const int kIsSkipped = 10;

    /**
     * Clears the field "IsSkipped".
     *
     * The field will be set to its default value. The hasIsSkipped()
     * method will return false.
     */
    inline void clearIsSkipped();

    /**
     * Checks whether the field "IsSkipped" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsSkipped()). Otherwise it will return false.
     */
    inline bool hasIsSkipped () const;

    /**
     * Returns the value of the member "IsSkipped".
     *
     * Channel's Skip status.
     * TRUE, if the channel is skipped;
     * FALSE, if the channel is unskipped;
     *
     * @return The value of the field "IsSkipped"
     */
    inline bool getIsSkipped () const;

    /**
     * Sets the value of the member "IsSkipped".
     *
     * Channel's Skip status.
     * TRUE, if the channel is skipped;
     * FALSE, if the channel is unskipped;
     *
     * @param IsSkipped The value which will be set
     */
    inline void setIsSkipped (bool IsSkipped_);

    // API of field "ChannelGraphicAvail"

    static const int kChannelGraphicAvail = 11;

    /**
     * Clears the field "ChannelGraphicAvail".
     *
     * The field will be set to its default value. The hasChannelGraphicAvail()
     * method will return false.
     */
    inline void clearChannelGraphicAvail();

    /**
     * Checks whether the field "ChannelGraphicAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelGraphicAvail()). Otherwise it will return false.
     */
    inline bool hasChannelGraphicAvail () const;

    /**
     * Returns the value of the member "ChannelGraphicAvail".
     *
     * Indicates whether Channel Graphics needs to be refreshed.
     *
     * @return The value of the field "ChannelGraphicAvail"
     */
    inline T_e8_Graphics getChannelGraphicAvail () const;

    /**
     * Sets the value of the member "ChannelGraphicAvail".
     *
     * Indicates whether Channel Graphics needs to be refreshed.
     *
     * @param ChannelGraphicAvail The value which will be set
     */
    inline void setChannelGraphicAvail (T_e8_Graphics ChannelGraphicAvail_);

    static const T_ChannelListEntry &getDefaultInstance();

private:

    inline void set_has_ServiceID ();

    inline void clear_has_ServiceID ();

    inline void set_has_ChannelID ();

    inline void clear_has_ChannelID ();

    inline void set_has_ChannelNameAvail ();

    inline void clear_has_ChannelNameAvail ();

    inline void set_has_ChannelName ();

    inline void clear_has_ChannelName ();

    inline void set_has_ChannelArtistName ();

    inline void clear_has_ChannelArtistName ();

    inline void set_has_ChannelSongName ();

    inline void clear_has_ChannelSongName ();

    inline void set_has_PresetNumber ();

    inline void clear_has_PresetNumber ();

    inline void set_has_IsLocked ();

    inline void clear_has_IsLocked ();

    inline void set_has_IsAvailable ();

    inline void clear_has_IsAvailable ();

    inline void set_has_IsMature ();

    inline void clear_has_IsMature ();

    inline void set_has_IsSkipped ();

    inline void clear_has_IsSkipped ();

    inline void set_has_ChannelGraphicAvail ();

    inline void clear_has_ChannelGraphicAvail ();

    uint32 _has_bits_[ (12 + 31) / 32];

    uint16 _ServiceID;

    uint16 _ChannelID;

    bool _ChannelNameAvail;

    ::std::string _ChannelName;

    ::std::string _ChannelArtistName;

    ::std::string _ChannelSongName;

    uint8 _PresetNumber;

    bool _IsLocked;

    bool _IsAvailable;

    bool _IsMature;

    bool _IsSkipped;

    T_e8_Graphics _ChannelGraphicAvail;

};

/**
 * If the meaning of "T_PresetListEntry" isn't clear, then there should be a description here.
 */
class T_PresetListEntry {
public:

    /**
     * Default constructor
     */
    inline  T_PresetListEntry ();

    /**
     * Copy constructor
     */
    inline  T_PresetListEntry (const T_PresetListEntry &rhs);

    /**
     * All fields constructor
     */
    inline  T_PresetListEntry (uint16 ServiceID_, uint16 ChannelID_, bool ChannelNameAvail_, const ::std::string& ChannelName_, bool ChannelActive_, T_e8_Graphics ChnGraphicAvail_, bool IsSmartFavorite_, bool IsLocked_, bool IsAvailable_, bool IsMature_, bool IsSkipped_);

    /**
     * Destructor
     */
    inline  ~T_PresetListEntry();

    /**
     * Assignment operator
     */
    inline T_PresetListEntry& operator = (const T_PresetListEntry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PresetListEntry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PresetListEntry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PresetListEntry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PresetListEntry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceID"

    static const int kServiceID = 0;

    /**
     * Clears the field "ServiceID".
     *
     * The field will be set to its default value. The hasServiceID()
     * method will return false.
     */
    inline void clearServiceID();

    /**
     * Checks whether the field "ServiceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceID()). Otherwise it will return false.
     */
    inline bool hasServiceID () const;

    /**
     * Returns the value of the member "ServiceID".
     *
     * Unique identifier of the service
     *
     * @return The value of the field "ServiceID"
     */
    inline uint16 getServiceID () const;

    /**
     * Sets the value of the member "ServiceID".
     *
     * Unique identifier of the service
     *
     * @param ServiceID The value which will be set
     */
    inline void setServiceID (uint16 ServiceID_);

    // API of field "ChannelID"

    static const int kChannelID = 1;

    /**
     * Clears the field "ChannelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "ChannelID".
     *
     * Unique identifier of the channel
     *
     * @return The value of the field "ChannelID"
     */
    inline uint16 getChannelID () const;

    /**
     * Sets the value of the member "ChannelID".
     *
     * Unique identifier of the channel
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (uint16 ChannelID_);

    // API of field "ChannelNameAvail"

    static const int kChannelNameAvail = 2;

    /**
     * Clears the field "ChannelNameAvail".
     *
     * The field will be set to its default value. The hasChannelNameAvail()
     * method will return false.
     */
    inline void clearChannelNameAvail();

    /**
     * Checks whether the field "ChannelNameAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelNameAvail()). Otherwise it will return false.
     */
    inline bool hasChannelNameAvail () const;

    /**
     * Returns the value of the member "ChannelNameAvail".
     *
     * Channel name is available or not
     * TRUE = Available, FALSE = Not available
     *
     * @return The value of the field "ChannelNameAvail"
     */
    inline bool getChannelNameAvail () const;

    /**
     * Sets the value of the member "ChannelNameAvail".
     *
     * Channel name is available or not
     * TRUE = Available, FALSE = Not available
     *
     * @param ChannelNameAvail The value which will be set
     */
    inline void setChannelNameAvail (bool ChannelNameAvail_);

    // API of field "ChannelName"

    static const int kChannelName = 3;

    /**
     * Clears the field "ChannelName".
     *
     * The field will be set to its default value. The hasChannelName()
     * method will return false.
     */
    inline void clearChannelName();

    /**
     * Checks whether the field "ChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelName()). Otherwise it will return false.
     */
    inline bool hasChannelName () const;

    /**
     * Returns the value of the member "ChannelName".
     *
     * Name of the channel. The maximum size for the ChannelName
     * is 16 bytes (ASCII characters).
     *
     * @return The value of the field "ChannelName"
     */
    inline const ::std::string& getChannelName () const;

    /**
     * Retrieves the value of the field "ChannelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelName".
     */
    inline ::std::string& getChannelNameMutable ();

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of the channel. The maximum size for the ChannelName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const ::std::string& ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of the channel. The maximum size for the ChannelName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of the channel. The maximum size for the ChannelName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* value, size_t size);

    // API of field "ChannelActive"

    static const int kChannelActive = 4;

    /**
     * Clears the field "ChannelActive".
     *
     * The field will be set to its default value. The hasChannelActive()
     * method will return false.
     */
    inline void clearChannelActive();

    /**
     * Checks whether the field "ChannelActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelActive()). Otherwise it will return false.
     */
    inline bool hasChannelActive () const;

    /**
     * Returns the value of the member "ChannelActive".
     *
     * This field is used to decide whether the entry needs to be greyed
     * out or not. For e.g. in case of an OFF AIR channel, this flag is
     * set to FALSE. TRUE = Channel is active , FALSE = Channel is not
     * active (i.e. may be greyed out)
     *
     * @return The value of the field "ChannelActive"
     */
    inline bool getChannelActive () const;

    /**
     * Sets the value of the member "ChannelActive".
     *
     * This field is used to decide whether the entry needs to be greyed
     * out or not. For e.g. in case of an OFF AIR channel, this flag is
     * set to FALSE. TRUE = Channel is active , FALSE = Channel is not
     * active (i.e. may be greyed out)
     *
     * @param ChannelActive The value which will be set
     */
    inline void setChannelActive (bool ChannelActive_);

    // API of field "ChnGraphicAvail"

    static const int kChnGraphicAvail = 5;

    /**
     * Clears the field "ChnGraphicAvail".
     *
     * The field will be set to its default value. The hasChnGraphicAvail()
     * method will return false.
     */
    inline void clearChnGraphicAvail();

    /**
     * Checks whether the field "ChnGraphicAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChnGraphicAvail()). Otherwise it will return false.
     */
    inline bool hasChnGraphicAvail () const;

    /**
     * Returns the value of the member "ChnGraphicAvail".
     *
     * Indicates whether Channel Graphics needs to be refreshed.
     *
     * @return The value of the field "ChnGraphicAvail"
     */
    inline T_e8_Graphics getChnGraphicAvail () const;

    /**
     * Sets the value of the member "ChnGraphicAvail".
     *
     * Indicates whether Channel Graphics needs to be refreshed.
     *
     * @param ChnGraphicAvail The value which will be set
     */
    inline void setChnGraphicAvail (T_e8_Graphics ChnGraphicAvail_);

    // API of field "IsSmartFavorite"

    static const int kIsSmartFavorite = 6;

    /**
     * Clears the field "IsSmartFavorite".
     *
     * The field will be set to its default value. The hasIsSmartFavorite()
     * method will return false.
     */
    inline void clearIsSmartFavorite();

    /**
     * Checks whether the field "IsSmartFavorite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsSmartFavorite()). Otherwise it will return false.
     */
    inline bool hasIsSmartFavorite () const;

    /**
     * Returns the value of the member "IsSmartFavorite".
     *
     * Flag to indicate if the channel is a smart favorite channel.
     *
     * @return The value of the field "IsSmartFavorite"
     */
    inline bool getIsSmartFavorite () const;

    /**
     * Sets the value of the member "IsSmartFavorite".
     *
     * Flag to indicate if the channel is a smart favorite channel.
     *
     * @param IsSmartFavorite The value which will be set
     */
    inline void setIsSmartFavorite (bool IsSmartFavorite_);

    // API of field "IsLocked"

    static const int kIsLocked = 7;

    /**
     * Clears the field "IsLocked".
     *
     * The field will be set to its default value. The hasIsLocked()
     * method will return false.
     */
    inline void clearIsLocked();

    /**
     * Checks whether the field "IsLocked" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsLocked()). Otherwise it will return false.
     */
    inline bool hasIsLocked () const;

    /**
     * Returns the value of the member "IsLocked".
     *
     * Channel's Lock status.
     * TRUE, if the channel is locked;
     * FALSE, if the channel is unlocked;
     *
     * @return The value of the field "IsLocked"
     */
    inline bool getIsLocked () const;

    /**
     * Sets the value of the member "IsLocked".
     *
     * Channel's Lock status.
     * TRUE, if the channel is locked;
     * FALSE, if the channel is unlocked;
     *
     * @param IsLocked The value which will be set
     */
    inline void setIsLocked (bool IsLocked_);

    // API of field "IsAvailable"

    static const int kIsAvailable = 8;

    /**
     * Clears the field "IsAvailable".
     *
     * The field will be set to its default value. The hasIsAvailable()
     * method will return false.
     */
    inline void clearIsAvailable();

    /**
     * Checks whether the field "IsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsAvailable()). Otherwise it will return false.
     */
    inline bool hasIsAvailable () const;

    /**
     * Returns the value of the member "IsAvailable".
     *
     * Channel's Availability status.
     * TRUE, if the channel is subscribed and available;
     * FALSE, if the channel is either unsubscribed or not aired;
     *
     * @return The value of the field "IsAvailable"
     */
    inline bool getIsAvailable () const;

    /**
     * Sets the value of the member "IsAvailable".
     *
     * Channel's Availability status.
     * TRUE, if the channel is subscribed and available;
     * FALSE, if the channel is either unsubscribed or not aired;
     *
     * @param IsAvailable The value which will be set
     */
    inline void setIsAvailable (bool IsAvailable_);

    // API of field "IsMature"

    static const int kIsMature = 9;

    /**
     * Clears the field "IsMature".
     *
     * The field will be set to its default value. The hasIsMature()
     * method will return false.
     */
    inline void clearIsMature();

    /**
     * Checks whether the field "IsMature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMature()). Otherwise it will return false.
     */
    inline bool hasIsMature () const;

    /**
     * Returns the value of the member "IsMature".
     *
     * Channel's Broadcast content type.
     * TRUE, if the channel is identified as a channel which MAY be broadcasting mature or adult content and may need Parental Guidance;
     * FALSE, if Parental Guidance not required;
     *
     * @return The value of the field "IsMature"
     */
    inline bool getIsMature () const;

    /**
     * Sets the value of the member "IsMature".
     *
     * Channel's Broadcast content type.
     * TRUE, if the channel is identified as a channel which MAY be broadcasting mature or adult content and may need Parental Guidance;
     * FALSE, if Parental Guidance not required;
     *
     * @param IsMature The value which will be set
     */
    inline void setIsMature (bool IsMature_);

    // API of field "IsSkipped"

    static const int kIsSkipped = 10;

    /**
     * Clears the field "IsSkipped".
     *
     * The field will be set to its default value. The hasIsSkipped()
     * method will return false.
     */
    inline void clearIsSkipped();

    /**
     * Checks whether the field "IsSkipped" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsSkipped()). Otherwise it will return false.
     */
    inline bool hasIsSkipped () const;

    /**
     * Returns the value of the member "IsSkipped".
     *
     * Channel's Skip status.
     * TRUE, if the channel is skipped;
     * FALSE, if the channel is unskipped;
     *
     * @return The value of the field "IsSkipped"
     */
    inline bool getIsSkipped () const;

    /**
     * Sets the value of the member "IsSkipped".
     *
     * Channel's Skip status.
     * TRUE, if the channel is skipped;
     * FALSE, if the channel is unskipped;
     *
     * @param IsSkipped The value which will be set
     */
    inline void setIsSkipped (bool IsSkipped_);

    static const T_PresetListEntry &getDefaultInstance();

private:

    inline void set_has_ServiceID ();

    inline void clear_has_ServiceID ();

    inline void set_has_ChannelID ();

    inline void clear_has_ChannelID ();

    inline void set_has_ChannelNameAvail ();

    inline void clear_has_ChannelNameAvail ();

    inline void set_has_ChannelName ();

    inline void clear_has_ChannelName ();

    inline void set_has_ChannelActive ();

    inline void clear_has_ChannelActive ();

    inline void set_has_ChnGraphicAvail ();

    inline void clear_has_ChnGraphicAvail ();

    inline void set_has_IsSmartFavorite ();

    inline void clear_has_IsSmartFavorite ();

    inline void set_has_IsLocked ();

    inline void clear_has_IsLocked ();

    inline void set_has_IsAvailable ();

    inline void clear_has_IsAvailable ();

    inline void set_has_IsMature ();

    inline void clear_has_IsMature ();

    inline void set_has_IsSkipped ();

    inline void clear_has_IsSkipped ();

    uint32 _has_bits_[ (11 + 31) / 32];

    uint16 _ServiceID;

    uint16 _ChannelID;

    bool _ChannelNameAvail;

    ::std::string _ChannelName;

    bool _ChannelActive;

    T_e8_Graphics _ChnGraphicAvail;

    bool _IsSmartFavorite;

    bool _IsLocked;

    bool _IsAvailable;

    bool _IsMature;

    bool _IsSkipped;

};

/**
 * If the meaning of "T_CategoryListEntry" isn't clear, then there should be a description here.
 */
class T_CategoryListEntry {
public:

    /**
     * Default constructor
     */
    inline  T_CategoryListEntry ();

    /**
     * Copy constructor
     */
    inline  T_CategoryListEntry (const T_CategoryListEntry &rhs);

    /**
     * All fields constructor
     */
    inline  T_CategoryListEntry (uint16 CategoryType_, bool CategoryNameAvail_, const ::std::string& CategoryName_, const T_ChannelList& ChannelList_);

    /**
     * Destructor
     */
    inline  ~T_CategoryListEntry();

    /**
     * Assignment operator
     */
    inline T_CategoryListEntry& operator = (const T_CategoryListEntry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CategoryListEntry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CategoryListEntry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CategoryListEntry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CategoryListEntry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CategoryType"

    static const int kCategoryType = 0;

    /**
     * Clears the field "CategoryType".
     *
     * The field will be set to its default value. The hasCategoryType()
     * method will return false.
     */
    inline void clearCategoryType();

    /**
     * Checks whether the field "CategoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryType()). Otherwise it will return false.
     */
    inline bool hasCategoryType () const;

    /**
     * Returns the value of the member "CategoryType".
     *
     * Unique identifier of the category
     *
     * @return The value of the field "CategoryType"
     */
    inline uint16 getCategoryType () const;

    /**
     * Sets the value of the member "CategoryType".
     *
     * Unique identifier of the category
     *
     * @param CategoryType The value which will be set
     */
    inline void setCategoryType (uint16 CategoryType_);

    // API of field "CategoryNameAvail"

    static const int kCategoryNameAvail = 1;

    /**
     * Clears the field "CategoryNameAvail".
     *
     * The field will be set to its default value. The hasCategoryNameAvail()
     * method will return false.
     */
    inline void clearCategoryNameAvail();

    /**
     * Checks whether the field "CategoryNameAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryNameAvail()). Otherwise it will return false.
     */
    inline bool hasCategoryNameAvail () const;

    /**
     * Returns the value of the member "CategoryNameAvail".
     *
     * category name is available or not.
     * TRUE = Available, FALSE = Not available
     *
     * @return The value of the field "CategoryNameAvail"
     */
    inline bool getCategoryNameAvail () const;

    /**
     * Sets the value of the member "CategoryNameAvail".
     *
     * category name is available or not.
     * TRUE = Available, FALSE = Not available
     *
     * @param CategoryNameAvail The value which will be set
     */
    inline void setCategoryNameAvail (bool CategoryNameAvail_);

    // API of field "CategoryName"

    static const int kCategoryName = 2;

    /**
     * Clears the field "CategoryName".
     *
     * The field will be set to its default value. The hasCategoryName()
     * method will return false.
     */
    inline void clearCategoryName();

    /**
     * Checks whether the field "CategoryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryName()). Otherwise it will return false.
     */
    inline bool hasCategoryName () const;

    /**
     * Returns the value of the member "CategoryName".
     *
     * Name of the category.The maximum size for the CategoryName
     * is 16 bytes (ASCII characters).
     *
     * @return The value of the field "CategoryName"
     */
    inline const ::std::string& getCategoryName () const;

    /**
     * Retrieves the value of the field "CategoryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CategoryName".
     */
    inline ::std::string& getCategoryNameMutable ();

    /**
     * Sets the value of the member "CategoryName".
     *
     * Name of the category.The maximum size for the CategoryName
     * is 16 bytes (ASCII characters).
     *
     * @param CategoryName The value which will be set
     */
    inline void setCategoryName (const ::std::string& CategoryName_);

    /**
     * Sets the value of the member "CategoryName".
     *
     * Name of the category.The maximum size for the CategoryName
     * is 16 bytes (ASCII characters).
     *
     * @param CategoryName The value which will be set
     */
    inline void setCategoryName (const char* CategoryName_);

    /**
     * Sets the value of the member "CategoryName".
     *
     * Name of the category.The maximum size for the CategoryName
     * is 16 bytes (ASCII characters).
     *
     * @param CategoryName The value which will be set
     */
    inline void setCategoryName (const char* value, size_t size);

    // API of field "ChannelList"

    static const int kChannelList = 3;

    /**
     * Clears the field "ChannelList".
     *
     * The field will be set to its default value. The hasChannelList()
     * method will return false.
     */
    inline void clearChannelList();

    /**
     * Checks whether the field "ChannelList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelList()). Otherwise it will return false.
     */
    inline bool hasChannelList () const;

    /**
     * Returns the value of the member "ChannelList".
     *
     * list of channel in this cateogry
     *
     * @return The value of the field "ChannelList"
     */
    inline const T_ChannelList& getChannelList () const;

    /**
     * Retrieves the value of the field "ChannelList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelList".
     */
    inline T_ChannelList& getChannelListMutable ();

    /**
     * Sets the value of the member "ChannelList".
     *
     * list of channel in this cateogry
     *
     * @param ChannelList The value which will be set
     */
    inline void setChannelList (const T_ChannelList& ChannelList_);

    static const T_CategoryListEntry &getDefaultInstance();

private:

    static const ::std::vector< T_ChannelListEntry >& getT_ChannelListEntryList_DefaultInstance ();

    inline void set_has_CategoryType ();

    inline void clear_has_CategoryType ();

    inline void set_has_CategoryNameAvail ();

    inline void clear_has_CategoryNameAvail ();

    inline void set_has_CategoryName ();

    inline void clear_has_CategoryName ();

    inline void set_has_ChannelList ();

    inline void clear_has_ChannelList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _CategoryType;

    bool _CategoryNameAvail;

    ::std::string _CategoryName;

    T_ChannelList _ChannelList;

};

/**
 * If the meaning of "T_ChannelInformation" isn't clear, then there should be a description here.
 */
class T_ChannelInformation {
public:

    /**
     * Default constructor
     */
    inline  T_ChannelInformation ();

    /**
     * Copy constructor
     */
    inline  T_ChannelInformation (const T_ChannelInformation &rhs);

    /**
     * All fields constructor
     */
    inline  T_ChannelInformation (uint16 ChannelNumber_, uint16 SID_, bool ChannelNameAvail_, const ::std::string& ChannelName_, uint16 CategoryType_, uint16 PrimaryCategoryType_, bool CategoryNameAvail_, const ::std::string& CategoryName_, bool ArtistSongnameAvail_, bool ArtistNameAvail_, const ::std::string& ArtistName_, bool SongNameAvail_, const ::std::string& SongName_, bool ExtSongNameAvail_, const ::std::string& ExtSongName_, bool ExtArtistNameAvail_, const ::std::string& ExtArtistName_, bool ChnGraphicAvail_, T_e8_Graphics ChnArtAvail_, T_e8_Graphics AlbumArtAvail_, bool IsLocked_, bool IsAvailable_, bool IsMature_, bool IsSkipped_, bool ArtistAlertStatus_, bool SongAlertStatus_);

    /**
     * Destructor
     */
    inline  ~T_ChannelInformation();

    /**
     * Assignment operator
     */
    inline T_ChannelInformation& operator = (const T_ChannelInformation& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ChannelInformation& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ChannelInformation& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ChannelInformation& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ChannelInformation& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelNumber"

    static const int kChannelNumber = 0;

    /**
     * Clears the field "ChannelNumber".
     *
     * The field will be set to its default value. The hasChannelNumber()
     * method will return false.
     */
    inline void clearChannelNumber();

    /**
     * Checks whether the field "ChannelNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelNumber()). Otherwise it will return false.
     */
    inline bool hasChannelNumber () const;

    /**
     * Returns the value of the member "ChannelNumber".
     *
     * Channel Number (Unique identifier of the channel) Range:0 to 65535
     *
     * @return The value of the field "ChannelNumber"
     */
    inline uint16 getChannelNumber () const;

    /**
     * Sets the value of the member "ChannelNumber".
     *
     * Channel Number (Unique identifier of the channel) Range:0 to 65535
     *
     * @param ChannelNumber The value which will be set
     */
    inline void setChannelNumber (uint16 ChannelNumber_);

    // API of field "SID"

    static const int kSID = 1;

    /**
     * Clears the field "SID".
     *
     * The field will be set to its default value. The hasSID()
     * method will return false.
     */
    inline void clearSID();

    /**
     * Checks whether the field "SID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSID()). Otherwise it will return false.
     */
    inline bool hasSID () const;

    /**
     * Returns the value of the member "SID".
     *
     * Service Identifier(Unique service identifier of the channel) Range:1 to 65535, 0 = Invalid Value
     *
     * @return The value of the field "SID"
     */
    inline uint16 getSID () const;

    /**
     * Sets the value of the member "SID".
     *
     * Service Identifier(Unique service identifier of the channel) Range:1 to 65535, 0 = Invalid Value
     *
     * @param SID The value which will be set
     */
    inline void setSID (uint16 SID_);

    // API of field "ChannelNameAvail"

    static const int kChannelNameAvail = 2;

    /**
     * Clears the field "ChannelNameAvail".
     *
     * The field will be set to its default value. The hasChannelNameAvail()
     * method will return false.
     */
    inline void clearChannelNameAvail();

    /**
     * Checks whether the field "ChannelNameAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelNameAvail()). Otherwise it will return false.
     */
    inline bool hasChannelNameAvail () const;

    /**
     * Returns the value of the member "ChannelNameAvail".
     *
     * Channel name is available or not TRUE if Available, FALSE if Not available
     *
     * @return The value of the field "ChannelNameAvail"
     */
    inline bool getChannelNameAvail () const;

    /**
     * Sets the value of the member "ChannelNameAvail".
     *
     * Channel name is available or not TRUE if Available, FALSE if Not available
     *
     * @param ChannelNameAvail The value which will be set
     */
    inline void setChannelNameAvail (bool ChannelNameAvail_);

    // API of field "ChannelName"

    static const int kChannelName = 3;

    /**
     * Clears the field "ChannelName".
     *
     * The field will be set to its default value. The hasChannelName()
     * method will return false.
     */
    inline void clearChannelName();

    /**
     * Checks whether the field "ChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelName()). Otherwise it will return false.
     */
    inline bool hasChannelName () const;

    /**
     * Returns the value of the member "ChannelName".
     *
     * Name of the channel.The maximum size for the ChannelName is 16 bytes (ASCII characters).
     *
     * @return The value of the field "ChannelName"
     */
    inline const ::std::string& getChannelName () const;

    /**
     * Retrieves the value of the field "ChannelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelName".
     */
    inline ::std::string& getChannelNameMutable ();

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of the channel.The maximum size for the ChannelName is 16 bytes (ASCII characters).
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const ::std::string& ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of the channel.The maximum size for the ChannelName is 16 bytes (ASCII characters).
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of the channel.The maximum size for the ChannelName is 16 bytes (ASCII characters).
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* value, size_t size);

    // API of field "CategoryType"

    static const int kCategoryType = 4;

    /**
     * Clears the field "CategoryType".
     *
     * The field will be set to its default value. The hasCategoryType()
     * method will return false.
     */
    inline void clearCategoryType();

    /**
     * Checks whether the field "CategoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryType()). Otherwise it will return false.
     */
    inline bool hasCategoryType () const;

    /**
     * Returns the value of the member "CategoryType".
     *
     * Actual used category for this channel: Range 0 to 31
     *
     * @return The value of the field "CategoryType"
     */
    inline uint16 getCategoryType () const;

    /**
     * Sets the value of the member "CategoryType".
     *
     * Actual used category for this channel: Range 0 to 31
     *
     * @param CategoryType The value which will be set
     */
    inline void setCategoryType (uint16 CategoryType_);

    // API of field "PrimaryCategoryType"

    static const int kPrimaryCategoryType = 5;

    /**
     * Clears the field "PrimaryCategoryType".
     *
     * The field will be set to its default value. The hasPrimaryCategoryType()
     * method will return false.
     */
    inline void clearPrimaryCategoryType();

    /**
     * Checks whether the field "PrimaryCategoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrimaryCategoryType()). Otherwise it will return false.
     */
    inline bool hasPrimaryCategoryType () const;

    /**
     * Returns the value of the member "PrimaryCategoryType".
     *
     * Primary category for this channel: Range 0 to 31
     *
     * @return The value of the field "PrimaryCategoryType"
     */
    inline uint16 getPrimaryCategoryType () const;

    /**
     * Sets the value of the member "PrimaryCategoryType".
     *
     * Primary category for this channel: Range 0 to 31
     *
     * @param PrimaryCategoryType The value which will be set
     */
    inline void setPrimaryCategoryType (uint16 PrimaryCategoryType_);

    // API of field "CategoryNameAvail"

    static const int kCategoryNameAvail = 6;

    /**
     * Clears the field "CategoryNameAvail".
     *
     * The field will be set to its default value. The hasCategoryNameAvail()
     * method will return false.
     */
    inline void clearCategoryNameAvail();

    /**
     * Checks whether the field "CategoryNameAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryNameAvail()). Otherwise it will return false.
     */
    inline bool hasCategoryNameAvail () const;

    /**
     * Returns the value of the member "CategoryNameAvail".
     *
     * Category name is available or not
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @return The value of the field "CategoryNameAvail"
     */
    inline bool getCategoryNameAvail () const;

    /**
     * Sets the value of the member "CategoryNameAvail".
     *
     * Category name is available or not
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @param CategoryNameAvail The value which will be set
     */
    inline void setCategoryNameAvail (bool CategoryNameAvail_);

    // API of field "CategoryName"

    static const int kCategoryName = 7;

    /**
     * Clears the field "CategoryName".
     *
     * The field will be set to its default value. The hasCategoryName()
     * method will return false.
     */
    inline void clearCategoryName();

    /**
     * Checks whether the field "CategoryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryName()). Otherwise it will return false.
     */
    inline bool hasCategoryName () const;

    /**
     * Returns the value of the member "CategoryName".
     *
     * Main category name.The maximum size for the CategoryName is 16 bytes (ASCII characters).
     *
     * @return The value of the field "CategoryName"
     */
    inline const ::std::string& getCategoryName () const;

    /**
     * Retrieves the value of the field "CategoryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CategoryName".
     */
    inline ::std::string& getCategoryNameMutable ();

    /**
     * Sets the value of the member "CategoryName".
     *
     * Main category name.The maximum size for the CategoryName is 16 bytes (ASCII characters).
     *
     * @param CategoryName The value which will be set
     */
    inline void setCategoryName (const ::std::string& CategoryName_);

    /**
     * Sets the value of the member "CategoryName".
     *
     * Main category name.The maximum size for the CategoryName is 16 bytes (ASCII characters).
     *
     * @param CategoryName The value which will be set
     */
    inline void setCategoryName (const char* CategoryName_);

    /**
     * Sets the value of the member "CategoryName".
     *
     * Main category name.The maximum size for the CategoryName is 16 bytes (ASCII characters).
     *
     * @param CategoryName The value which will be set
     */
    inline void setCategoryName (const char* value, size_t size);

    // API of field "ArtistSongnameAvail"

    static const int kArtistSongnameAvail = 8;

    /**
     * Clears the field "ArtistSongnameAvail".
     *
     * The field will be set to its default value. The hasArtistSongnameAvail()
     * method will return false.
     */
    inline void clearArtistSongnameAvail();

    /**
     * Checks whether the field "ArtistSongnameAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArtistSongnameAvail()). Otherwise it will return false.
     */
    inline bool hasArtistSongnameAvail () const;

    /**
     * Returns the value of the member "ArtistSongnameAvail".
     *
     * Artist name and Song name are avaialble or not
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @return The value of the field "ArtistSongnameAvail"
     */
    inline bool getArtistSongnameAvail () const;

    /**
     * Sets the value of the member "ArtistSongnameAvail".
     *
     * Artist name and Song name are avaialble or not
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @param ArtistSongnameAvail The value which will be set
     */
    inline void setArtistSongnameAvail (bool ArtistSongnameAvail_);

    // API of field "ArtistNameAvail"

    static const int kArtistNameAvail = 9;

    /**
     * Clears the field "ArtistNameAvail".
     *
     * The field will be set to its default value. The hasArtistNameAvail()
     * method will return false.
     */
    inline void clearArtistNameAvail();

    /**
     * Checks whether the field "ArtistNameAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArtistNameAvail()). Otherwise it will return false.
     */
    inline bool hasArtistNameAvail () const;

    /**
     * Returns the value of the member "ArtistNameAvail".
     *
     * Artist name avaialble or not
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @return The value of the field "ArtistNameAvail"
     */
    inline bool getArtistNameAvail () const;

    /**
     * Sets the value of the member "ArtistNameAvail".
     *
     * Artist name avaialble or not
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @param ArtistNameAvail The value which will be set
     */
    inline void setArtistNameAvail (bool ArtistNameAvail_);

    // API of field "ArtistName"

    static const int kArtistName = 10;

    /**
     * Clears the field "ArtistName".
     *
     * The field will be set to its default value. The hasArtistName()
     * method will return false.
     */
    inline void clearArtistName();

    /**
     * Checks whether the field "ArtistName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArtistName()). Otherwise it will return false.
     */
    inline bool hasArtistName () const;

    /**
     * Returns the value of the member "ArtistName".
     *
     * Artist name of the currently playing song.The maximum size for the ArtistName is 16 bytes (ASCII characters).
     *
     * @return The value of the field "ArtistName"
     */
    inline const ::std::string& getArtistName () const;

    /**
     * Retrieves the value of the field "ArtistName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ArtistName".
     */
    inline ::std::string& getArtistNameMutable ();

    /**
     * Sets the value of the member "ArtistName".
     *
     * Artist name of the currently playing song.The maximum size for the ArtistName is 16 bytes (ASCII characters).
     *
     * @param ArtistName The value which will be set
     */
    inline void setArtistName (const ::std::string& ArtistName_);

    /**
     * Sets the value of the member "ArtistName".
     *
     * Artist name of the currently playing song.The maximum size for the ArtistName is 16 bytes (ASCII characters).
     *
     * @param ArtistName The value which will be set
     */
    inline void setArtistName (const char* ArtistName_);

    /**
     * Sets the value of the member "ArtistName".
     *
     * Artist name of the currently playing song.The maximum size for the ArtistName is 16 bytes (ASCII characters).
     *
     * @param ArtistName The value which will be set
     */
    inline void setArtistName (const char* value, size_t size);

    // API of field "SongNameAvail"

    static const int kSongNameAvail = 11;

    /**
     * Clears the field "SongNameAvail".
     *
     * The field will be set to its default value. The hasSongNameAvail()
     * method will return false.
     */
    inline void clearSongNameAvail();

    /**
     * Checks whether the field "SongNameAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSongNameAvail()). Otherwise it will return false.
     */
    inline bool hasSongNameAvail () const;

    /**
     * Returns the value of the member "SongNameAvail".
     *
     * Song name are avaialble or not
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @return The value of the field "SongNameAvail"
     */
    inline bool getSongNameAvail () const;

    /**
     * Sets the value of the member "SongNameAvail".
     *
     * Song name are avaialble or not
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @param SongNameAvail The value which will be set
     */
    inline void setSongNameAvail (bool SongNameAvail_);

    // API of field "SongName"

    static const int kSongName = 12;

    /**
     * Clears the field "SongName".
     *
     * The field will be set to its default value. The hasSongName()
     * method will return false.
     */
    inline void clearSongName();

    /**
     * Checks whether the field "SongName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSongName()). Otherwise it will return false.
     */
    inline bool hasSongName () const;

    /**
     * Returns the value of the member "SongName".
     *
     * Title of the currently playing song. The maximum size for the SongName is 16 bytes (ASCII characters).
     *
     * @return The value of the field "SongName"
     */
    inline const ::std::string& getSongName () const;

    /**
     * Retrieves the value of the field "SongName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SongName".
     */
    inline ::std::string& getSongNameMutable ();

    /**
     * Sets the value of the member "SongName".
     *
     * Title of the currently playing song. The maximum size for the SongName is 16 bytes (ASCII characters).
     *
     * @param SongName The value which will be set
     */
    inline void setSongName (const ::std::string& SongName_);

    /**
     * Sets the value of the member "SongName".
     *
     * Title of the currently playing song. The maximum size for the SongName is 16 bytes (ASCII characters).
     *
     * @param SongName The value which will be set
     */
    inline void setSongName (const char* SongName_);

    /**
     * Sets the value of the member "SongName".
     *
     * Title of the currently playing song. The maximum size for the SongName is 16 bytes (ASCII characters).
     *
     * @param SongName The value which will be set
     */
    inline void setSongName (const char* value, size_t size);

    // API of field "ExtSongNameAvail"

    static const int kExtSongNameAvail = 13;

    /**
     * Clears the field "ExtSongNameAvail".
     *
     * The field will be set to its default value. The hasExtSongNameAvail()
     * method will return false.
     */
    inline void clearExtSongNameAvail();

    /**
     * Checks whether the field "ExtSongNameAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtSongNameAvail()). Otherwise it will return false.
     */
    inline bool hasExtSongNameAvail () const;

    /**
     * Returns the value of the member "ExtSongNameAvail".
     *
     * Extended song name availabilty
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @return The value of the field "ExtSongNameAvail"
     */
    inline bool getExtSongNameAvail () const;

    /**
     * Sets the value of the member "ExtSongNameAvail".
     *
     * Extended song name availabilty
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @param ExtSongNameAvail The value which will be set
     */
    inline void setExtSongNameAvail (bool ExtSongNameAvail_);

    // API of field "ExtSongName"

    static const int kExtSongName = 14;

    /**
     * Clears the field "ExtSongName".
     *
     * The field will be set to its default value. The hasExtSongName()
     * method will return false.
     */
    inline void clearExtSongName();

    /**
     * Checks whether the field "ExtSongName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtSongName()). Otherwise it will return false.
     */
    inline bool hasExtSongName () const;

    /**
     * Returns the value of the member "ExtSongName".
     *
     * Extended song name of the currently playing song.The maximum size for the ExtSongName is 80 bytes (ASCII characters)
     *
     * @return The value of the field "ExtSongName"
     */
    inline const ::std::string& getExtSongName () const;

    /**
     * Retrieves the value of the field "ExtSongName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ExtSongName".
     */
    inline ::std::string& getExtSongNameMutable ();

    /**
     * Sets the value of the member "ExtSongName".
     *
     * Extended song name of the currently playing song.The maximum size for the ExtSongName is 80 bytes (ASCII characters)
     *
     * @param ExtSongName The value which will be set
     */
    inline void setExtSongName (const ::std::string& ExtSongName_);

    /**
     * Sets the value of the member "ExtSongName".
     *
     * Extended song name of the currently playing song.The maximum size for the ExtSongName is 80 bytes (ASCII characters)
     *
     * @param ExtSongName The value which will be set
     */
    inline void setExtSongName (const char* ExtSongName_);

    /**
     * Sets the value of the member "ExtSongName".
     *
     * Extended song name of the currently playing song.The maximum size for the ExtSongName is 80 bytes (ASCII characters)
     *
     * @param ExtSongName The value which will be set
     */
    inline void setExtSongName (const char* value, size_t size);

    // API of field "ExtArtistNameAvail"

    static const int kExtArtistNameAvail = 15;

    /**
     * Clears the field "ExtArtistNameAvail".
     *
     * The field will be set to its default value. The hasExtArtistNameAvail()
     * method will return false.
     */
    inline void clearExtArtistNameAvail();

    /**
     * Checks whether the field "ExtArtistNameAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtArtistNameAvail()). Otherwise it will return false.
     */
    inline bool hasExtArtistNameAvail () const;

    /**
     * Returns the value of the member "ExtArtistNameAvail".
     *
     * Extended Artist name availabilty
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @return The value of the field "ExtArtistNameAvail"
     */
    inline bool getExtArtistNameAvail () const;

    /**
     * Sets the value of the member "ExtArtistNameAvail".
     *
     * Extended Artist name availabilty
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @param ExtArtistNameAvail The value which will be set
     */
    inline void setExtArtistNameAvail (bool ExtArtistNameAvail_);

    // API of field "ExtArtistName"

    static const int kExtArtistName = 16;

    /**
     * Clears the field "ExtArtistName".
     *
     * The field will be set to its default value. The hasExtArtistName()
     * method will return false.
     */
    inline void clearExtArtistName();

    /**
     * Checks whether the field "ExtArtistName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtArtistName()). Otherwise it will return false.
     */
    inline bool hasExtArtistName () const;

    /**
     * Returns the value of the member "ExtArtistName".
     *
     * Extended artist name of the currently playing song.The maximum size for the ExtArtistName is 80 bytes (ASCII characters)
     *
     * @return The value of the field "ExtArtistName"
     */
    inline const ::std::string& getExtArtistName () const;

    /**
     * Retrieves the value of the field "ExtArtistName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ExtArtistName".
     */
    inline ::std::string& getExtArtistNameMutable ();

    /**
     * Sets the value of the member "ExtArtistName".
     *
     * Extended artist name of the currently playing song.The maximum size for the ExtArtistName is 80 bytes (ASCII characters)
     *
     * @param ExtArtistName The value which will be set
     */
    inline void setExtArtistName (const ::std::string& ExtArtistName_);

    /**
     * Sets the value of the member "ExtArtistName".
     *
     * Extended artist name of the currently playing song.The maximum size for the ExtArtistName is 80 bytes (ASCII characters)
     *
     * @param ExtArtistName The value which will be set
     */
    inline void setExtArtistName (const char* ExtArtistName_);

    /**
     * Sets the value of the member "ExtArtistName".
     *
     * Extended artist name of the currently playing song.The maximum size for the ExtArtistName is 80 bytes (ASCII characters)
     *
     * @param ExtArtistName The value which will be set
     */
    inline void setExtArtistName (const char* value, size_t size);

    // API of field "ChnGraphicAvail"

    static const int kChnGraphicAvail = 17;

    /**
     * Clears the field "ChnGraphicAvail".
     *
     * The field will be set to its default value. The hasChnGraphicAvail()
     * method will return false.
     */
    inline void clearChnGraphicAvail();

    /**
     * Checks whether the field "ChnGraphicAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChnGraphicAvail()). Otherwise it will return false.
     */
    inline bool hasChnGraphicAvail () const;

    /**
     * Returns the value of the member "ChnGraphicAvail".
     *
     * Channel Graphics availabilty
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @return The value of the field "ChnGraphicAvail"
     */
    inline bool getChnGraphicAvail () const;

    /**
     * Sets the value of the member "ChnGraphicAvail".
     *
     * Channel Graphics availabilty
     * <p>TRUE = Available</p>
     * <p>FALSE = Not available</p>
     *
     * @param ChnGraphicAvail The value which will be set
     */
    inline void setChnGraphicAvail (bool ChnGraphicAvail_);

    // API of field "ChnArtAvail"

    static const int kChnArtAvail = 18;

    /**
     * Clears the field "ChnArtAvail".
     *
     * The field will be set to its default value. The hasChnArtAvail()
     * method will return false.
     */
    inline void clearChnArtAvail();

    /**
     * Checks whether the field "ChnArtAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChnArtAvail()). Otherwise it will return false.
     */
    inline bool hasChnArtAvail () const;

    /**
     * Returns the value of the member "ChnArtAvail".
     *
     * Channel Art availability
     * <p>0 = Applications need to use the channel graphics that was passed earlier. No need to refresh.</p>
     * <p>1 = New channel graphics available for the channel. Refresh and fetch new channel graphics.</p>
     * <p>2 = The channel graphics present is corrupted or not available. Please use default graphics for the channel.</p>
     *
     * @return The value of the field "ChnArtAvail"
     */
    inline T_e8_Graphics getChnArtAvail () const;

    /**
     * Sets the value of the member "ChnArtAvail".
     *
     * Channel Art availability
     * <p>0 = Applications need to use the channel graphics that was passed earlier. No need to refresh.</p>
     * <p>1 = New channel graphics available for the channel. Refresh and fetch new channel graphics.</p>
     * <p>2 = The channel graphics present is corrupted or not available. Please use default graphics for the channel.</p>
     *
     * @param ChnArtAvail The value which will be set
     */
    inline void setChnArtAvail (T_e8_Graphics ChnArtAvail_);

    // API of field "AlbumArtAvail"

    static const int kAlbumArtAvail = 19;

    /**
     * Clears the field "AlbumArtAvail".
     *
     * The field will be set to its default value. The hasAlbumArtAvail()
     * method will return false.
     */
    inline void clearAlbumArtAvail();

    /**
     * Checks whether the field "AlbumArtAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlbumArtAvail()). Otherwise it will return false.
     */
    inline bool hasAlbumArtAvail () const;

    /**
     * Returns the value of the member "AlbumArtAvail".
     *
     * Album Art availability
     * <p>0 = Applications need to use the channel graphics that was passed earlier. No need to refresh.</p>
     * <p>1 = New album graphics available for the channel. Refresh and fetch new album graphics.</p>
     * <p>2 = The channel graphics present is corrupted or not available. Please use default graphics for the channel.</p>
     *
     * @return The value of the field "AlbumArtAvail"
     */
    inline T_e8_Graphics getAlbumArtAvail () const;

    /**
     * Sets the value of the member "AlbumArtAvail".
     *
     * Album Art availability
     * <p>0 = Applications need to use the channel graphics that was passed earlier. No need to refresh.</p>
     * <p>1 = New album graphics available for the channel. Refresh and fetch new album graphics.</p>
     * <p>2 = The channel graphics present is corrupted or not available. Please use default graphics for the channel.</p>
     *
     * @param AlbumArtAvail The value which will be set
     */
    inline void setAlbumArtAvail (T_e8_Graphics AlbumArtAvail_);

    // API of field "IsLocked"

    static const int kIsLocked = 20;

    /**
     * Clears the field "IsLocked".
     *
     * The field will be set to its default value. The hasIsLocked()
     * method will return false.
     */
    inline void clearIsLocked();

    /**
     * Checks whether the field "IsLocked" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsLocked()). Otherwise it will return false.
     */
    inline bool hasIsLocked () const;

    /**
     * Returns the value of the member "IsLocked".
     *
     * Channel's Lock status.
     * TRUE, if the channel is locked;
     * FALSE, if the channel is unlocked;
     *
     * @return The value of the field "IsLocked"
     */
    inline bool getIsLocked () const;

    /**
     * Sets the value of the member "IsLocked".
     *
     * Channel's Lock status.
     * TRUE, if the channel is locked;
     * FALSE, if the channel is unlocked;
     *
     * @param IsLocked The value which will be set
     */
    inline void setIsLocked (bool IsLocked_);

    // API of field "IsAvailable"

    static const int kIsAvailable = 21;

    /**
     * Clears the field "IsAvailable".
     *
     * The field will be set to its default value. The hasIsAvailable()
     * method will return false.
     */
    inline void clearIsAvailable();

    /**
     * Checks whether the field "IsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsAvailable()). Otherwise it will return false.
     */
    inline bool hasIsAvailable () const;

    /**
     * Returns the value of the member "IsAvailable".
     *
     * Channel's Availability status.
     * TRUE, if the channel is subscribed and available;
     * FALSE, if the channel is either unsubscribed or not aired;
     *
     * @return The value of the field "IsAvailable"
     */
    inline bool getIsAvailable () const;

    /**
     * Sets the value of the member "IsAvailable".
     *
     * Channel's Availability status.
     * TRUE, if the channel is subscribed and available;
     * FALSE, if the channel is either unsubscribed or not aired;
     *
     * @param IsAvailable The value which will be set
     */
    inline void setIsAvailable (bool IsAvailable_);

    // API of field "IsMature"

    static const int kIsMature = 22;

    /**
     * Clears the field "IsMature".
     *
     * The field will be set to its default value. The hasIsMature()
     * method will return false.
     */
    inline void clearIsMature();

    /**
     * Checks whether the field "IsMature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMature()). Otherwise it will return false.
     */
    inline bool hasIsMature () const;

    /**
     * Returns the value of the member "IsMature".
     *
     * Channel's Broadcast content type.
     * TRUE, if the channel is identified as a channel which MAY be broadcasting mature or adult content and may need Parental Guidance;
     * FALSE, if Parental Guidance not required;
     *
     * @return The value of the field "IsMature"
     */
    inline bool getIsMature () const;

    /**
     * Sets the value of the member "IsMature".
     *
     * Channel's Broadcast content type.
     * TRUE, if the channel is identified as a channel which MAY be broadcasting mature or adult content and may need Parental Guidance;
     * FALSE, if Parental Guidance not required;
     *
     * @param IsMature The value which will be set
     */
    inline void setIsMature (bool IsMature_);

    // API of field "IsSkipped"

    static const int kIsSkipped = 23;

    /**
     * Clears the field "IsSkipped".
     *
     * The field will be set to its default value. The hasIsSkipped()
     * method will return false.
     */
    inline void clearIsSkipped();

    /**
     * Checks whether the field "IsSkipped" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsSkipped()). Otherwise it will return false.
     */
    inline bool hasIsSkipped () const;

    /**
     * Returns the value of the member "IsSkipped".
     *
     * Channel's Skip status.
     * TRUE, if the channel is skipped;
     * FALSE, if the channel is unskipped;
     *
     * @return The value of the field "IsSkipped"
     */
    inline bool getIsSkipped () const;

    /**
     * Sets the value of the member "IsSkipped".
     *
     * Channel's Skip status.
     * TRUE, if the channel is skipped;
     * FALSE, if the channel is unskipped;
     *
     * @param IsSkipped The value which will be set
     */
    inline void setIsSkipped (bool IsSkipped_);

    // API of field "ArtistAlertStatus"

    static const int kArtistAlertStatus = 24;

    /**
     * Clears the field "ArtistAlertStatus".
     *
     * The field will be set to its default value. The hasArtistAlertStatus()
     * method will return false.
     */
    inline void clearArtistAlertStatus();

    /**
     * Checks whether the field "ArtistAlertStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArtistAlertStatus()). Otherwise it will return false.
     */
    inline bool hasArtistAlertStatus () const;

    /**
     * Returns the value of the member "ArtistAlertStatus".
     *
     * Artist alert status
     * TRUE, if artist info is available;
     * FALSE, if artist info is not available;
     *
     * @return The value of the field "ArtistAlertStatus"
     */
    inline bool getArtistAlertStatus () const;

    /**
     * Sets the value of the member "ArtistAlertStatus".
     *
     * Artist alert status
     * TRUE, if artist info is available;
     * FALSE, if artist info is not available;
     *
     * @param ArtistAlertStatus The value which will be set
     */
    inline void setArtistAlertStatus (bool ArtistAlertStatus_);

    // API of field "SongAlertStatus"

    static const int kSongAlertStatus = 25;

    /**
     * Clears the field "SongAlertStatus".
     *
     * The field will be set to its default value. The hasSongAlertStatus()
     * method will return false.
     */
    inline void clearSongAlertStatus();

    /**
     * Checks whether the field "SongAlertStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSongAlertStatus()). Otherwise it will return false.
     */
    inline bool hasSongAlertStatus () const;

    /**
     * Returns the value of the member "SongAlertStatus".
     *
     * Song alert status
     * TRUE, if song info is available;
     * FALSE, if song info is not available;
     *
     * @return The value of the field "SongAlertStatus"
     */
    inline bool getSongAlertStatus () const;

    /**
     * Sets the value of the member "SongAlertStatus".
     *
     * Song alert status
     * TRUE, if song info is available;
     * FALSE, if song info is not available;
     *
     * @param SongAlertStatus The value which will be set
     */
    inline void setSongAlertStatus (bool SongAlertStatus_);

    static const T_ChannelInformation &getDefaultInstance();

private:

    inline void set_has_ChannelNumber ();

    inline void clear_has_ChannelNumber ();

    inline void set_has_SID ();

    inline void clear_has_SID ();

    inline void set_has_ChannelNameAvail ();

    inline void clear_has_ChannelNameAvail ();

    inline void set_has_ChannelName ();

    inline void clear_has_ChannelName ();

    inline void set_has_CategoryType ();

    inline void clear_has_CategoryType ();

    inline void set_has_PrimaryCategoryType ();

    inline void clear_has_PrimaryCategoryType ();

    inline void set_has_CategoryNameAvail ();

    inline void clear_has_CategoryNameAvail ();

    inline void set_has_CategoryName ();

    inline void clear_has_CategoryName ();

    inline void set_has_ArtistSongnameAvail ();

    inline void clear_has_ArtistSongnameAvail ();

    inline void set_has_ArtistNameAvail ();

    inline void clear_has_ArtistNameAvail ();

    inline void set_has_ArtistName ();

    inline void clear_has_ArtistName ();

    inline void set_has_SongNameAvail ();

    inline void clear_has_SongNameAvail ();

    inline void set_has_SongName ();

    inline void clear_has_SongName ();

    inline void set_has_ExtSongNameAvail ();

    inline void clear_has_ExtSongNameAvail ();

    inline void set_has_ExtSongName ();

    inline void clear_has_ExtSongName ();

    inline void set_has_ExtArtistNameAvail ();

    inline void clear_has_ExtArtistNameAvail ();

    inline void set_has_ExtArtistName ();

    inline void clear_has_ExtArtistName ();

    inline void set_has_ChnGraphicAvail ();

    inline void clear_has_ChnGraphicAvail ();

    inline void set_has_ChnArtAvail ();

    inline void clear_has_ChnArtAvail ();

    inline void set_has_AlbumArtAvail ();

    inline void clear_has_AlbumArtAvail ();

    inline void set_has_IsLocked ();

    inline void clear_has_IsLocked ();

    inline void set_has_IsAvailable ();

    inline void clear_has_IsAvailable ();

    inline void set_has_IsMature ();

    inline void clear_has_IsMature ();

    inline void set_has_IsSkipped ();

    inline void clear_has_IsSkipped ();

    inline void set_has_ArtistAlertStatus ();

    inline void clear_has_ArtistAlertStatus ();

    inline void set_has_SongAlertStatus ();

    inline void clear_has_SongAlertStatus ();

    uint32 _has_bits_[ (26 + 31) / 32];

    uint16 _ChannelNumber;

    uint16 _SID;

    bool _ChannelNameAvail;

    ::std::string _ChannelName;

    uint16 _CategoryType;

    uint16 _PrimaryCategoryType;

    bool _CategoryNameAvail;

    ::std::string _CategoryName;

    bool _ArtistSongnameAvail;

    bool _ArtistNameAvail;

    ::std::string _ArtistName;

    bool _SongNameAvail;

    ::std::string _SongName;

    bool _ExtSongNameAvail;

    ::std::string _ExtSongName;

    bool _ExtArtistNameAvail;

    ::std::string _ExtArtistName;

    bool _ChnGraphicAvail;

    T_e8_Graphics _ChnArtAvail;

    T_e8_Graphics _AlbumArtAvail;

    bool _IsLocked;

    bool _IsAvailable;

    bool _IsMature;

    bool _IsSkipped;

    bool _ArtistAlertStatus;

    bool _SongAlertStatus;

};

/**
 * If the meaning of "T_SxmSignalQuality" isn't clear, then there should be a description here.
 */
class T_SxmSignalQuality {
public:

    /**
     * Default constructor
     */
    inline  T_SxmSignalQuality ();

    /**
     * Copy constructor
     */
    inline  T_SxmSignalQuality (const T_SxmSignalQuality &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmSignalQuality (T_e8_Sxm_AntennaState AntennaStatus_, T_e8_Sxm_SignalQuality SignalQualityStatus_);

    /**
     * Destructor
     */
    inline  ~T_SxmSignalQuality();

    /**
     * Assignment operator
     */
    inline T_SxmSignalQuality& operator = (const T_SxmSignalQuality& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmSignalQuality& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmSignalQuality& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmSignalQuality& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmSignalQuality& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AntennaStatus"

    static const int kAntennaStatus = 0;

    /**
     * Clears the field "AntennaStatus".
     *
     * The field will be set to its default value. The hasAntennaStatus()
     * method will return false.
     */
    inline void clearAntennaStatus();

    /**
     * Checks whether the field "AntennaStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAntennaStatus()). Otherwise it will return false.
     */
    inline bool hasAntennaStatus () const;

    /**
     * Returns the value of the member "AntennaStatus".
     *
     * Antenna status
     *
     * @return The value of the field "AntennaStatus"
     */
    inline T_e8_Sxm_AntennaState getAntennaStatus () const;

    /**
     * Sets the value of the member "AntennaStatus".
     *
     * Antenna status
     *
     * @param AntennaStatus The value which will be set
     */
    inline void setAntennaStatus (T_e8_Sxm_AntennaState AntennaStatus_);

    // API of field "SignalQualityStatus"

    static const int kSignalQualityStatus = 1;

    /**
     * Clears the field "SignalQualityStatus".
     *
     * The field will be set to its default value. The hasSignalQualityStatus()
     * method will return false.
     */
    inline void clearSignalQualityStatus();

    /**
     * Checks whether the field "SignalQualityStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSignalQualityStatus()). Otherwise it will return false.
     */
    inline bool hasSignalQualityStatus () const;

    /**
     * Returns the value of the member "SignalQualityStatus".
     *
     * Signal quality status
     *
     * @return The value of the field "SignalQualityStatus"
     */
    inline T_e8_Sxm_SignalQuality getSignalQualityStatus () const;

    /**
     * Sets the value of the member "SignalQualityStatus".
     *
     * Signal quality status
     *
     * @param SignalQualityStatus The value which will be set
     */
    inline void setSignalQualityStatus (T_e8_Sxm_SignalQuality SignalQualityStatus_);

    static const T_SxmSignalQuality &getDefaultInstance();

private:

    inline void set_has_AntennaStatus ();

    inline void clear_has_AntennaStatus ();

    inline void set_has_SignalQualityStatus ();

    inline void clear_has_SignalQualityStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_Sxm_AntennaState _AntennaStatus;

    T_e8_Sxm_SignalQuality _SignalQualityStatus;

};

/**
 * If the meaning of "T_SxmDetSignalQuality" isn't clear, then there should be a description here.
 */
class T_SxmDetSignalQuality {
public:

    /**
     * Default constructor
     */
    inline  T_SxmDetSignalQuality ();

    /**
     * Copy constructor
     */
    inline  T_SxmDetSignalQuality (const T_SxmDetSignalQuality &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmDetSignalQuality (const ::std::string& SigQuality_, const ::std::string& TunerStatus_, const ::std::string& ENSALockStatus_, const ::std::string& ENSBLockStatus_, const ::std::string& BerS1_, const ::std::string& BerS2_, const ::std::string& BerT_, const ::std::string& CtoNS1A_, const ::std::string& CtoNS1B_, const ::std::string& CtoNS2A_, const ::std::string& CtoNS2B_, const ::std::string& RSErrsWords_, const ::std::string& RSErrSatSymb_, const ::std::string& RSErrTerrSymb_, const ::std::string& TunerCarrFreqOfset_, const ::std::string& RSSI_);

    /**
     * Destructor
     */
    inline  ~T_SxmDetSignalQuality();

    /**
     * Assignment operator
     */
    inline T_SxmDetSignalQuality& operator = (const T_SxmDetSignalQuality& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmDetSignalQuality& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmDetSignalQuality& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmDetSignalQuality& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmDetSignalQuality& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SigQuality"

    static const int kSigQuality = 0;

    /**
     * Clears the field "SigQuality".
     *
     * The field will be set to its default value. The hasSigQuality()
     * method will return false.
     */
    inline void clearSigQuality();

    /**
     * Checks whether the field "SigQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSigQuality()). Otherwise it will return false.
     */
    inline bool hasSigQuality () const;

    /**
     * Returns the value of the member "SigQuality".
     *
     * 0x00 = No signal
     * 0x01 = Very Weak
     * 0x02 = Weak signal
     * 0x03 = Marginal signal
     * 0x04 = Good signal
     *
     * @return The value of the field "SigQuality"
     */
    inline const ::std::string& getSigQuality () const;

    /**
     * Retrieves the value of the field "SigQuality" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SigQuality".
     */
    inline ::std::string& getSigQualityMutable ();

    /**
     * Sets the value of the member "SigQuality".
     *
     * 0x00 = No signal
     * 0x01 = Very Weak
     * 0x02 = Weak signal
     * 0x03 = Marginal signal
     * 0x04 = Good signal
     *
     * @param SigQuality The value which will be set
     */
    inline void setSigQuality (const ::std::string& SigQuality_);

    /**
     * Sets the value of the member "SigQuality".
     *
     * 0x00 = No signal
     * 0x01 = Very Weak
     * 0x02 = Weak signal
     * 0x03 = Marginal signal
     * 0x04 = Good signal
     *
     * @param SigQuality The value which will be set
     */
    inline void setSigQuality (const char* SigQuality_);

    /**
     * Sets the value of the member "SigQuality".
     *
     * 0x00 = No signal
     * 0x01 = Very Weak
     * 0x02 = Weak signal
     * 0x03 = Marginal signal
     * 0x04 = Good signal
     *
     * @param SigQuality The value which will be set
     */
    inline void setSigQuality (const char* value, size_t size);

    // API of field "TunerStatus"

    static const int kTunerStatus = 1;

    /**
     * Clears the field "TunerStatus".
     *
     * The field will be set to its default value. The hasTunerStatus()
     * method will return false.
     */
    inline void clearTunerStatus();

    /**
     * Checks whether the field "TunerStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerStatus()). Otherwise it will return false.
     */
    inline bool hasTunerStatus () const;

    /**
     * Returns the value of the member "TunerStatus".
     *
     * Values depend on the bit being set
     * Bit 0 :PLL Lock;
     * Bit 1 :Antenna Detected;
     * Bit 2 :Antenna Undercurrent;
     * Bit 3 :Antenna Overcurrent;
     * Bit 4 :RF AGC Engaged;
     * Bit 5 :IF AGC Engaged;
     * Bit 6 :Reserved
     * Bit 7 :Reserved
     *
     * @return The value of the field "TunerStatus"
     */
    inline const ::std::string& getTunerStatus () const;

    /**
     * Retrieves the value of the field "TunerStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerStatus".
     */
    inline ::std::string& getTunerStatusMutable ();

    /**
     * Sets the value of the member "TunerStatus".
     *
     * Values depend on the bit being set
     * Bit 0 :PLL Lock;
     * Bit 1 :Antenna Detected;
     * Bit 2 :Antenna Undercurrent;
     * Bit 3 :Antenna Overcurrent;
     * Bit 4 :RF AGC Engaged;
     * Bit 5 :IF AGC Engaged;
     * Bit 6 :Reserved
     * Bit 7 :Reserved
     *
     * @param TunerStatus The value which will be set
     */
    inline void setTunerStatus (const ::std::string& TunerStatus_);

    /**
     * Sets the value of the member "TunerStatus".
     *
     * Values depend on the bit being set
     * Bit 0 :PLL Lock;
     * Bit 1 :Antenna Detected;
     * Bit 2 :Antenna Undercurrent;
     * Bit 3 :Antenna Overcurrent;
     * Bit 4 :RF AGC Engaged;
     * Bit 5 :IF AGC Engaged;
     * Bit 6 :Reserved
     * Bit 7 :Reserved
     *
     * @param TunerStatus The value which will be set
     */
    inline void setTunerStatus (const char* TunerStatus_);

    /**
     * Sets the value of the member "TunerStatus".
     *
     * Values depend on the bit being set
     * Bit 0 :PLL Lock;
     * Bit 1 :Antenna Detected;
     * Bit 2 :Antenna Undercurrent;
     * Bit 3 :Antenna Overcurrent;
     * Bit 4 :RF AGC Engaged;
     * Bit 5 :IF AGC Engaged;
     * Bit 6 :Reserved
     * Bit 7 :Reserved
     *
     * @param TunerStatus The value which will be set
     */
    inline void setTunerStatus (const char* value, size_t size);

    // API of field "ENSALockStatus"

    static const int kENSALockStatus = 2;

    /**
     * Clears the field "ENSALockStatus".
     *
     * The field will be set to its default value. The hasENSALockStatus()
     * method will return false.
     */
    inline void clearENSALockStatus();

    /**
     * Checks whether the field "ENSALockStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setENSALockStatus()). Otherwise it will return false.
     */
    inline bool hasENSALockStatus () const;

    /**
     * Returns the value of the member "ENSALockStatus".
     *
     * Values depend on the bit being set
     * Bit 0 :TMCM;
     * Bit 1 :TTDM;
     * Bit 2 :S2QPSK;
     * Bit 3 :S2TDM;
     * Bit 4 :S1QPSK;
     * Bit 5 :S1TDM;
     * Bit 6 :Reserved
     * Bit 7 :Reserved
     *
     * @return The value of the field "ENSALockStatus"
     */
    inline const ::std::string& getENSALockStatus () const;

    /**
     * Retrieves the value of the field "ENSALockStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ENSALockStatus".
     */
    inline ::std::string& getENSALockStatusMutable ();

    /**
     * Sets the value of the member "ENSALockStatus".
     *
     * Values depend on the bit being set
     * Bit 0 :TMCM;
     * Bit 1 :TTDM;
     * Bit 2 :S2QPSK;
     * Bit 3 :S2TDM;
     * Bit 4 :S1QPSK;
     * Bit 5 :S1TDM;
     * Bit 6 :Reserved
     * Bit 7 :Reserved
     *
     * @param ENSALockStatus The value which will be set
     */
    inline void setENSALockStatus (const ::std::string& ENSALockStatus_);

    /**
     * Sets the value of the member "ENSALockStatus".
     *
     * Values depend on the bit being set
     * Bit 0 :TMCM;
     * Bit 1 :TTDM;
     * Bit 2 :S2QPSK;
     * Bit 3 :S2TDM;
     * Bit 4 :S1QPSK;
     * Bit 5 :S1TDM;
     * Bit 6 :Reserved
     * Bit 7 :Reserved
     *
     * @param ENSALockStatus The value which will be set
     */
    inline void setENSALockStatus (const char* ENSALockStatus_);

    /**
     * Sets the value of the member "ENSALockStatus".
     *
     * Values depend on the bit being set
     * Bit 0 :TMCM;
     * Bit 1 :TTDM;
     * Bit 2 :S2QPSK;
     * Bit 3 :S2TDM;
     * Bit 4 :S1QPSK;
     * Bit 5 :S1TDM;
     * Bit 6 :Reserved
     * Bit 7 :Reserved
     *
     * @param ENSALockStatus The value which will be set
     */
    inline void setENSALockStatus (const char* value, size_t size);

    // API of field "ENSBLockStatus"

    static const int kENSBLockStatus = 3;

    /**
     * Clears the field "ENSBLockStatus".
     *
     * The field will be set to its default value. The hasENSBLockStatus()
     * method will return false.
     */
    inline void clearENSBLockStatus();

    /**
     * Checks whether the field "ENSBLockStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setENSBLockStatus()). Otherwise it will return false.
     */
    inline bool hasENSBLockStatus () const;

    /**
     * Returns the value of the member "ENSBLockStatus".
     *
     * Values depend on the bit being set
     * Bit 0 :TMCM;
     * Bit 1 :TTDM;
     * Bit 2 :S2QPSK;
     * Bit 3 :S2TDM;
     * Bit 4 :S1QPSK;
     * Bit 5 :S1TDM;
     * Bit 6 :Reserved
     * Bit 7 :Reserved
     *
     * @return The value of the field "ENSBLockStatus"
     */
    inline const ::std::string& getENSBLockStatus () const;

    /**
     * Retrieves the value of the field "ENSBLockStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ENSBLockStatus".
     */
    inline ::std::string& getENSBLockStatusMutable ();

    /**
     * Sets the value of the member "ENSBLockStatus".
     *
     * Values depend on the bit being set
     * Bit 0 :TMCM;
     * Bit 1 :TTDM;
     * Bit 2 :S2QPSK;
     * Bit 3 :S2TDM;
     * Bit 4 :S1QPSK;
     * Bit 5 :S1TDM;
     * Bit 6 :Reserved
     * Bit 7 :Reserved
     *
     * @param ENSBLockStatus The value which will be set
     */
    inline void setENSBLockStatus (const ::std::string& ENSBLockStatus_);

    /**
     * Sets the value of the member "ENSBLockStatus".
     *
     * Values depend on the bit being set
     * Bit 0 :TMCM;
     * Bit 1 :TTDM;
     * Bit 2 :S2QPSK;
     * Bit 3 :S2TDM;
     * Bit 4 :S1QPSK;
     * Bit 5 :S1TDM;
     * Bit 6 :Reserved
     * Bit 7 :Reserved
     *
     * @param ENSBLockStatus The value which will be set
     */
    inline void setENSBLockStatus (const char* ENSBLockStatus_);

    /**
     * Sets the value of the member "ENSBLockStatus".
     *
     * Values depend on the bit being set
     * Bit 0 :TMCM;
     * Bit 1 :TTDM;
     * Bit 2 :S2QPSK;
     * Bit 3 :S2TDM;
     * Bit 4 :S1QPSK;
     * Bit 5 :S1TDM;
     * Bit 6 :Reserved
     * Bit 7 :Reserved
     *
     * @param ENSBLockStatus The value which will be set
     */
    inline void setENSBLockStatus (const char* value, size_t size);

    // API of field "BerS1"

    static const int kBerS1 = 4;

    /**
     * Clears the field "BerS1".
     *
     * The field will be set to its default value. The hasBerS1()
     * method will return false.
     */
    inline void clearBerS1();

    /**
     * Checks whether the field "BerS1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBerS1()). Otherwise it will return false.
     */
    inline bool hasBerS1 () const;

    /**
     * Returns the value of the member "BerS1".
     *
     * Bit error rate for 1st Satellite :0 to 100 % (in tenths of percent)
     *
     * @return The value of the field "BerS1"
     */
    inline const ::std::string& getBerS1 () const;

    /**
     * Retrieves the value of the field "BerS1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BerS1".
     */
    inline ::std::string& getBerS1Mutable ();

    /**
     * Sets the value of the member "BerS1".
     *
     * Bit error rate for 1st Satellite :0 to 100 % (in tenths of percent)
     *
     * @param BerS1 The value which will be set
     */
    inline void setBerS1 (const ::std::string& BerS1_);

    /**
     * Sets the value of the member "BerS1".
     *
     * Bit error rate for 1st Satellite :0 to 100 % (in tenths of percent)
     *
     * @param BerS1 The value which will be set
     */
    inline void setBerS1 (const char* BerS1_);

    /**
     * Sets the value of the member "BerS1".
     *
     * Bit error rate for 1st Satellite :0 to 100 % (in tenths of percent)
     *
     * @param BerS1 The value which will be set
     */
    inline void setBerS1 (const char* value, size_t size);

    // API of field "BerS2"

    static const int kBerS2 = 5;

    /**
     * Clears the field "BerS2".
     *
     * The field will be set to its default value. The hasBerS2()
     * method will return false.
     */
    inline void clearBerS2();

    /**
     * Checks whether the field "BerS2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBerS2()). Otherwise it will return false.
     */
    inline bool hasBerS2 () const;

    /**
     * Returns the value of the member "BerS2".
     *
     * Bit error rate for 2nd Satellite :0 to 100 % (in tenths of percent)
     *
     * @return The value of the field "BerS2"
     */
    inline const ::std::string& getBerS2 () const;

    /**
     * Retrieves the value of the field "BerS2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BerS2".
     */
    inline ::std::string& getBerS2Mutable ();

    /**
     * Sets the value of the member "BerS2".
     *
     * Bit error rate for 2nd Satellite :0 to 100 % (in tenths of percent)
     *
     * @param BerS2 The value which will be set
     */
    inline void setBerS2 (const ::std::string& BerS2_);

    /**
     * Sets the value of the member "BerS2".
     *
     * Bit error rate for 2nd Satellite :0 to 100 % (in tenths of percent)
     *
     * @param BerS2 The value which will be set
     */
    inline void setBerS2 (const char* BerS2_);

    /**
     * Sets the value of the member "BerS2".
     *
     * Bit error rate for 2nd Satellite :0 to 100 % (in tenths of percent)
     *
     * @param BerS2 The value which will be set
     */
    inline void setBerS2 (const char* value, size_t size);

    // API of field "BerT"

    static const int kBerT = 6;

    /**
     * Clears the field "BerT".
     *
     * The field will be set to its default value. The hasBerT()
     * method will return false.
     */
    inline void clearBerT();

    /**
     * Checks whether the field "BerT" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBerT()). Otherwise it will return false.
     */
    inline bool hasBerT () const;

    /**
     * Returns the value of the member "BerT".
     *
     * Bit error rate for terrrestrial Satellite :0 to 100 % (in tenths of percent)
     *
     * @return The value of the field "BerT"
     */
    inline const ::std::string& getBerT () const;

    /**
     * Retrieves the value of the field "BerT" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BerT".
     */
    inline ::std::string& getBerTMutable ();

    /**
     * Sets the value of the member "BerT".
     *
     * Bit error rate for terrrestrial Satellite :0 to 100 % (in tenths of percent)
     *
     * @param BerT The value which will be set
     */
    inline void setBerT (const ::std::string& BerT_);

    /**
     * Sets the value of the member "BerT".
     *
     * Bit error rate for terrrestrial Satellite :0 to 100 % (in tenths of percent)
     *
     * @param BerT The value which will be set
     */
    inline void setBerT (const char* BerT_);

    /**
     * Sets the value of the member "BerT".
     *
     * Bit error rate for terrrestrial Satellite :0 to 100 % (in tenths of percent)
     *
     * @param BerT The value which will be set
     */
    inline void setBerT (const char* value, size_t size);

    // API of field "CtoNS1A"

    static const int kCtoNS1A = 7;

    /**
     * Clears the field "CtoNS1A".
     *
     * The field will be set to its default value. The hasCtoNS1A()
     * method will return false.
     */
    inline void clearCtoNS1A();

    /**
     * Checks whether the field "CtoNS1A" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCtoNS1A()). Otherwise it will return false.
     */
    inline bool hasCtoNS1A () const;

    /**
     * Returns the value of the member "CtoNS1A".
     *
     * Satellite 1 Ensemble A carrier to noise ratio in dB. The value is reported
     * in 0.25 dB steps. Therefore, the carrier to noise ratio in dB is the octet
     * value divided by 4. The least significant bit is a carrier to noise ratio of
     * 0.25 dB and a value of 0x7F is a carrier to noise ratio of 31.75 dB.
     * For example, 0x0D = 3.25 dB.
     *
     * @return The value of the field "CtoNS1A"
     */
    inline const ::std::string& getCtoNS1A () const;

    /**
     * Retrieves the value of the field "CtoNS1A" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CtoNS1A".
     */
    inline ::std::string& getCtoNS1AMutable ();

    /**
     * Sets the value of the member "CtoNS1A".
     *
     * Satellite 1 Ensemble A carrier to noise ratio in dB. The value is reported
     * in 0.25 dB steps. Therefore, the carrier to noise ratio in dB is the octet
     * value divided by 4. The least significant bit is a carrier to noise ratio of
     * 0.25 dB and a value of 0x7F is a carrier to noise ratio of 31.75 dB.
     * For example, 0x0D = 3.25 dB.
     *
     * @param CtoNS1A The value which will be set
     */
    inline void setCtoNS1A (const ::std::string& CtoNS1A_);

    /**
     * Sets the value of the member "CtoNS1A".
     *
     * Satellite 1 Ensemble A carrier to noise ratio in dB. The value is reported
     * in 0.25 dB steps. Therefore, the carrier to noise ratio in dB is the octet
     * value divided by 4. The least significant bit is a carrier to noise ratio of
     * 0.25 dB and a value of 0x7F is a carrier to noise ratio of 31.75 dB.
     * For example, 0x0D = 3.25 dB.
     *
     * @param CtoNS1A The value which will be set
     */
    inline void setCtoNS1A (const char* CtoNS1A_);

    /**
     * Sets the value of the member "CtoNS1A".
     *
     * Satellite 1 Ensemble A carrier to noise ratio in dB. The value is reported
     * in 0.25 dB steps. Therefore, the carrier to noise ratio in dB is the octet
     * value divided by 4. The least significant bit is a carrier to noise ratio of
     * 0.25 dB and a value of 0x7F is a carrier to noise ratio of 31.75 dB.
     * For example, 0x0D = 3.25 dB.
     *
     * @param CtoNS1A The value which will be set
     */
    inline void setCtoNS1A (const char* value, size_t size);

    // API of field "CtoNS1B"

    static const int kCtoNS1B = 8;

    /**
     * Clears the field "CtoNS1B".
     *
     * The field will be set to its default value. The hasCtoNS1B()
     * method will return false.
     */
    inline void clearCtoNS1B();

    /**
     * Checks whether the field "CtoNS1B" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCtoNS1B()). Otherwise it will return false.
     */
    inline bool hasCtoNS1B () const;

    /**
     * Returns the value of the member "CtoNS1B".
     *
     * Satellite 1 Ensemble B carrier to noise ratio in dB. The value is reported in 0.25 dB steps.
     *
     * @return The value of the field "CtoNS1B"
     */
    inline const ::std::string& getCtoNS1B () const;

    /**
     * Retrieves the value of the field "CtoNS1B" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CtoNS1B".
     */
    inline ::std::string& getCtoNS1BMutable ();

    /**
     * Sets the value of the member "CtoNS1B".
     *
     * Satellite 1 Ensemble B carrier to noise ratio in dB. The value is reported in 0.25 dB steps.
     *
     * @param CtoNS1B The value which will be set
     */
    inline void setCtoNS1B (const ::std::string& CtoNS1B_);

    /**
     * Sets the value of the member "CtoNS1B".
     *
     * Satellite 1 Ensemble B carrier to noise ratio in dB. The value is reported in 0.25 dB steps.
     *
     * @param CtoNS1B The value which will be set
     */
    inline void setCtoNS1B (const char* CtoNS1B_);

    /**
     * Sets the value of the member "CtoNS1B".
     *
     * Satellite 1 Ensemble B carrier to noise ratio in dB. The value is reported in 0.25 dB steps.
     *
     * @param CtoNS1B The value which will be set
     */
    inline void setCtoNS1B (const char* value, size_t size);

    // API of field "CtoNS2A"

    static const int kCtoNS2A = 9;

    /**
     * Clears the field "CtoNS2A".
     *
     * The field will be set to its default value. The hasCtoNS2A()
     * method will return false.
     */
    inline void clearCtoNS2A();

    /**
     * Checks whether the field "CtoNS2A" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCtoNS2A()). Otherwise it will return false.
     */
    inline bool hasCtoNS2A () const;

    /**
     * Returns the value of the member "CtoNS2A".
     *
     * Satellite 2 Ensemble A carrier to noise ratio in dB. The value is reported in 0.25 dB steps.
     *
     * @return The value of the field "CtoNS2A"
     */
    inline const ::std::string& getCtoNS2A () const;

    /**
     * Retrieves the value of the field "CtoNS2A" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CtoNS2A".
     */
    inline ::std::string& getCtoNS2AMutable ();

    /**
     * Sets the value of the member "CtoNS2A".
     *
     * Satellite 2 Ensemble A carrier to noise ratio in dB. The value is reported in 0.25 dB steps.
     *
     * @param CtoNS2A The value which will be set
     */
    inline void setCtoNS2A (const ::std::string& CtoNS2A_);

    /**
     * Sets the value of the member "CtoNS2A".
     *
     * Satellite 2 Ensemble A carrier to noise ratio in dB. The value is reported in 0.25 dB steps.
     *
     * @param CtoNS2A The value which will be set
     */
    inline void setCtoNS2A (const char* CtoNS2A_);

    /**
     * Sets the value of the member "CtoNS2A".
     *
     * Satellite 2 Ensemble A carrier to noise ratio in dB. The value is reported in 0.25 dB steps.
     *
     * @param CtoNS2A The value which will be set
     */
    inline void setCtoNS2A (const char* value, size_t size);

    // API of field "CtoNS2B"

    static const int kCtoNS2B = 10;

    /**
     * Clears the field "CtoNS2B".
     *
     * The field will be set to its default value. The hasCtoNS2B()
     * method will return false.
     */
    inline void clearCtoNS2B();

    /**
     * Checks whether the field "CtoNS2B" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCtoNS2B()). Otherwise it will return false.
     */
    inline bool hasCtoNS2B () const;

    /**
     * Returns the value of the member "CtoNS2B".
     *
     * Satellite 2 Ensemble B carrier to noise ratio in dB. The value is reported in 0.25 dB steps.
     *
     * @return The value of the field "CtoNS2B"
     */
    inline const ::std::string& getCtoNS2B () const;

    /**
     * Retrieves the value of the field "CtoNS2B" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CtoNS2B".
     */
    inline ::std::string& getCtoNS2BMutable ();

    /**
     * Sets the value of the member "CtoNS2B".
     *
     * Satellite 2 Ensemble B carrier to noise ratio in dB. The value is reported in 0.25 dB steps.
     *
     * @param CtoNS2B The value which will be set
     */
    inline void setCtoNS2B (const ::std::string& CtoNS2B_);

    /**
     * Sets the value of the member "CtoNS2B".
     *
     * Satellite 2 Ensemble B carrier to noise ratio in dB. The value is reported in 0.25 dB steps.
     *
     * @param CtoNS2B The value which will be set
     */
    inline void setCtoNS2B (const char* CtoNS2B_);

    /**
     * Sets the value of the member "CtoNS2B".
     *
     * Satellite 2 Ensemble B carrier to noise ratio in dB. The value is reported in 0.25 dB steps.
     *
     * @param CtoNS2B The value which will be set
     */
    inline void setCtoNS2B (const char* value, size_t size);

    // API of field "RSErrsWords"

    static const int kRSErrsWords = 11;

    /**
     * Clears the field "RSErrsWords".
     *
     * The field will be set to its default value. The hasRSErrsWords()
     * method will return false.
     */
    inline void clearRSErrsWords();

    /**
     * Checks whether the field "RSErrsWords" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSErrsWords()). Otherwise it will return false.
     */
    inline bool hasRSErrsWords () const;

    /**
     * Returns the value of the member "RSErrsWords".
     *
     * The averaged rate of uncorrectable words. (in tenths of percent).
     *
     * @return The value of the field "RSErrsWords"
     */
    inline const ::std::string& getRSErrsWords () const;

    /**
     * Retrieves the value of the field "RSErrsWords" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RSErrsWords".
     */
    inline ::std::string& getRSErrsWordsMutable ();

    /**
     * Sets the value of the member "RSErrsWords".
     *
     * The averaged rate of uncorrectable words. (in tenths of percent).
     *
     * @param RSErrsWords The value which will be set
     */
    inline void setRSErrsWords (const ::std::string& RSErrsWords_);

    /**
     * Sets the value of the member "RSErrsWords".
     *
     * The averaged rate of uncorrectable words. (in tenths of percent).
     *
     * @param RSErrsWords The value which will be set
     */
    inline void setRSErrsWords (const char* RSErrsWords_);

    /**
     * Sets the value of the member "RSErrsWords".
     *
     * The averaged rate of uncorrectable words. (in tenths of percent).
     *
     * @param RSErrsWords The value which will be set
     */
    inline void setRSErrsWords (const char* value, size_t size);

    // API of field "RSErrSatSymb"

    static const int kRSErrSatSymb = 12;

    /**
     * Clears the field "RSErrSatSymb".
     *
     * The field will be set to its default value. The hasRSErrSatSymb()
     * method will return false.
     */
    inline void clearRSErrSatSymb();

    /**
     * Checks whether the field "RSErrSatSymb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSErrSatSymb()). Otherwise it will return false.
     */
    inline bool hasRSErrSatSymb () const;

    /**
     * Returns the value of the member "RSErrSatSymb".
     *
     * The averaged symbol error rate of the RS decoder of the satellite channels (in tenths of percent).
     *
     * @return The value of the field "RSErrSatSymb"
     */
    inline const ::std::string& getRSErrSatSymb () const;

    /**
     * Retrieves the value of the field "RSErrSatSymb" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RSErrSatSymb".
     */
    inline ::std::string& getRSErrSatSymbMutable ();

    /**
     * Sets the value of the member "RSErrSatSymb".
     *
     * The averaged symbol error rate of the RS decoder of the satellite channels (in tenths of percent).
     *
     * @param RSErrSatSymb The value which will be set
     */
    inline void setRSErrSatSymb (const ::std::string& RSErrSatSymb_);

    /**
     * Sets the value of the member "RSErrSatSymb".
     *
     * The averaged symbol error rate of the RS decoder of the satellite channels (in tenths of percent).
     *
     * @param RSErrSatSymb The value which will be set
     */
    inline void setRSErrSatSymb (const char* RSErrSatSymb_);

    /**
     * Sets the value of the member "RSErrSatSymb".
     *
     * The averaged symbol error rate of the RS decoder of the satellite channels (in tenths of percent).
     *
     * @param RSErrSatSymb The value which will be set
     */
    inline void setRSErrSatSymb (const char* value, size_t size);

    // API of field "RSErrTerrSymb"

    static const int kRSErrTerrSymb = 13;

    /**
     * Clears the field "RSErrTerrSymb".
     *
     * The field will be set to its default value. The hasRSErrTerrSymb()
     * method will return false.
     */
    inline void clearRSErrTerrSymb();

    /**
     * Checks whether the field "RSErrTerrSymb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSErrTerrSymb()). Otherwise it will return false.
     */
    inline bool hasRSErrTerrSymb () const;

    /**
     * Returns the value of the member "RSErrTerrSymb".
     *
     * The averaged symbol error rate of the RS decoder of the satellite channels (in tenths of percent).
     *
     * @return The value of the field "RSErrTerrSymb"
     */
    inline const ::std::string& getRSErrTerrSymb () const;

    /**
     * Retrieves the value of the field "RSErrTerrSymb" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RSErrTerrSymb".
     */
    inline ::std::string& getRSErrTerrSymbMutable ();

    /**
     * Sets the value of the member "RSErrTerrSymb".
     *
     * The averaged symbol error rate of the RS decoder of the satellite channels (in tenths of percent).
     *
     * @param RSErrTerrSymb The value which will be set
     */
    inline void setRSErrTerrSymb (const ::std::string& RSErrTerrSymb_);

    /**
     * Sets the value of the member "RSErrTerrSymb".
     *
     * The averaged symbol error rate of the RS decoder of the satellite channels (in tenths of percent).
     *
     * @param RSErrTerrSymb The value which will be set
     */
    inline void setRSErrTerrSymb (const char* RSErrTerrSymb_);

    /**
     * Sets the value of the member "RSErrTerrSymb".
     *
     * The averaged symbol error rate of the RS decoder of the satellite channels (in tenths of percent).
     *
     * @param RSErrTerrSymb The value which will be set
     */
    inline void setRSErrTerrSymb (const char* value, size_t size);

    // API of field "TunerCarrFreqOfset"

    static const int kTunerCarrFreqOfset = 14;

    /**
     * Clears the field "TunerCarrFreqOfset".
     *
     * The field will be set to its default value. The hasTunerCarrFreqOfset()
     * method will return false.
     */
    inline void clearTunerCarrFreqOfset();

    /**
     * Checks whether the field "TunerCarrFreqOfset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerCarrFreqOfset()). Otherwise it will return false.
     */
    inline bool hasTunerCarrFreqOfset () const;

    /**
     * Returns the value of the member "TunerCarrFreqOfset".
     *
     * Offset is reported in units of Hz with a minimum step size of 100 Hz. For example, a value of 1
     * reports a 100 Hz offset and a value of 10 reports a 1000 Hz. The expected range is +/- 80 kHz.
     *
     * @return The value of the field "TunerCarrFreqOfset"
     */
    inline const ::std::string& getTunerCarrFreqOfset () const;

    /**
     * Retrieves the value of the field "TunerCarrFreqOfset" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerCarrFreqOfset".
     */
    inline ::std::string& getTunerCarrFreqOfsetMutable ();

    /**
     * Sets the value of the member "TunerCarrFreqOfset".
     *
     * Offset is reported in units of Hz with a minimum step size of 100 Hz. For example, a value of 1
     * reports a 100 Hz offset and a value of 10 reports a 1000 Hz. The expected range is +/- 80 kHz.
     *
     * @param TunerCarrFreqOfset The value which will be set
     */
    inline void setTunerCarrFreqOfset (const ::std::string& TunerCarrFreqOfset_);

    /**
     * Sets the value of the member "TunerCarrFreqOfset".
     *
     * Offset is reported in units of Hz with a minimum step size of 100 Hz. For example, a value of 1
     * reports a 100 Hz offset and a value of 10 reports a 1000 Hz. The expected range is +/- 80 kHz.
     *
     * @param TunerCarrFreqOfset The value which will be set
     */
    inline void setTunerCarrFreqOfset (const char* TunerCarrFreqOfset_);

    /**
     * Sets the value of the member "TunerCarrFreqOfset".
     *
     * Offset is reported in units of Hz with a minimum step size of 100 Hz. For example, a value of 1
     * reports a 100 Hz offset and a value of 10 reports a 1000 Hz. The expected range is +/- 80 kHz.
     *
     * @param TunerCarrFreqOfset The value which will be set
     */
    inline void setTunerCarrFreqOfset (const char* value, size_t size);

    // API of field "RSSI"

    static const int kRSSI = 15;

    /**
     * Clears the field "RSSI".
     *
     * The field will be set to its default value. The hasRSSI()
     * method will return false.
     */
    inline void clearRSSI();

    /**
     * Checks whether the field "RSSI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSSI()). Otherwise it will return false.
     */
    inline bool hasRSSI () const;

    /**
     * Returns the value of the member "RSSI".
     *
     * Received Signal Strength Indication (RSSI) in units of dBm with range from 0 to -128 dBm.
     *
     * @return The value of the field "RSSI"
     */
    inline const ::std::string& getRSSI () const;

    /**
     * Retrieves the value of the field "RSSI" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RSSI".
     */
    inline ::std::string& getRSSIMutable ();

    /**
     * Sets the value of the member "RSSI".
     *
     * Received Signal Strength Indication (RSSI) in units of dBm with range from 0 to -128 dBm.
     *
     * @param RSSI The value which will be set
     */
    inline void setRSSI (const ::std::string& RSSI_);

    /**
     * Sets the value of the member "RSSI".
     *
     * Received Signal Strength Indication (RSSI) in units of dBm with range from 0 to -128 dBm.
     *
     * @param RSSI The value which will be set
     */
    inline void setRSSI (const char* RSSI_);

    /**
     * Sets the value of the member "RSSI".
     *
     * Received Signal Strength Indication (RSSI) in units of dBm with range from 0 to -128 dBm.
     *
     * @param RSSI The value which will be set
     */
    inline void setRSSI (const char* value, size_t size);

    static const T_SxmDetSignalQuality &getDefaultInstance();

private:

    inline void set_has_SigQuality ();

    inline void clear_has_SigQuality ();

    inline void set_has_TunerStatus ();

    inline void clear_has_TunerStatus ();

    inline void set_has_ENSALockStatus ();

    inline void clear_has_ENSALockStatus ();

    inline void set_has_ENSBLockStatus ();

    inline void clear_has_ENSBLockStatus ();

    inline void set_has_BerS1 ();

    inline void clear_has_BerS1 ();

    inline void set_has_BerS2 ();

    inline void clear_has_BerS2 ();

    inline void set_has_BerT ();

    inline void clear_has_BerT ();

    inline void set_has_CtoNS1A ();

    inline void clear_has_CtoNS1A ();

    inline void set_has_CtoNS1B ();

    inline void clear_has_CtoNS1B ();

    inline void set_has_CtoNS2A ();

    inline void clear_has_CtoNS2A ();

    inline void set_has_CtoNS2B ();

    inline void clear_has_CtoNS2B ();

    inline void set_has_RSErrsWords ();

    inline void clear_has_RSErrsWords ();

    inline void set_has_RSErrSatSymb ();

    inline void clear_has_RSErrSatSymb ();

    inline void set_has_RSErrTerrSymb ();

    inline void clear_has_RSErrTerrSymb ();

    inline void set_has_TunerCarrFreqOfset ();

    inline void clear_has_TunerCarrFreqOfset ();

    inline void set_has_RSSI ();

    inline void clear_has_RSSI ();

    uint32 _has_bits_[ (16 + 31) / 32];

    ::std::string _SigQuality;

    ::std::string _TunerStatus;

    ::std::string _ENSALockStatus;

    ::std::string _ENSBLockStatus;

    ::std::string _BerS1;

    ::std::string _BerS2;

    ::std::string _BerT;

    ::std::string _CtoNS1A;

    ::std::string _CtoNS1B;

    ::std::string _CtoNS2A;

    ::std::string _CtoNS2B;

    ::std::string _RSErrsWords;

    ::std::string _RSErrSatSymb;

    ::std::string _RSErrTerrSymb;

    ::std::string _TunerCarrFreqOfset;

    ::std::string _RSSI;

};

/**
 * If the meaning of "T_SxmDetOvrlSignalQuality" isn't clear, then there should be a description here.
 */
class T_SxmDetOvrlSignalQuality {
public:

    /**
     * Default constructor
     */
    inline  T_SxmDetOvrlSignalQuality ();

    /**
     * Copy constructor
     */
    inline  T_SxmDetOvrlSignalQuality (const T_SxmDetOvrlSignalQuality &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmDetOvrlSignalQuality (const ::std::string& ReceiverState_, const ::std::string& OBerS1A_, const ::std::string& OBerS2A_, const ::std::string& OBerTA_, const ::std::string& OBerS1B_, const ::std::string& OBerS2B_, const ::std::string& OBerTB_, const ::std::string& OBERTrbWrdErRt0A_, const ::std::string& OBERTrbWrdErRt0B_, const ::std::string& OBERTrbWrdErRt1A_, const ::std::string& OBERTrbWrdErRt1B_, const ::std::string& OBERTrbWrdErRt2A_, const ::std::string& OBERTrbWrdErRt2B_);

    /**
     * Destructor
     */
    inline  ~T_SxmDetOvrlSignalQuality();

    /**
     * Assignment operator
     */
    inline T_SxmDetOvrlSignalQuality& operator = (const T_SxmDetOvrlSignalQuality& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmDetOvrlSignalQuality& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmDetOvrlSignalQuality& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmDetOvrlSignalQuality& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmDetOvrlSignalQuality& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ReceiverState"

    static const int kReceiverState = 0;

    /**
     * Clears the field "ReceiverState".
     *
     * The field will be set to its default value. The hasReceiverState()
     * method will return false.
     */
    inline void clearReceiverState();

    /**
     * Checks whether the field "ReceiverState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceiverState()). Otherwise it will return false.
     */
    inline bool hasReceiverState () const;

    /**
     * Returns the value of the member "ReceiverState".
     *
     * Receiver State
     * Bit 0 :TB otdm;
     * Bit 1 :S2B otdm;
     * Bit 2 :S1B otdm;
     * Bit 3 :Pipe LckB;
     * Bit 4 :TA otdm ;
     * Bit 5 :S2A otdm;
     * Bit 6 :S1A otdm
     * Bit 7 :Pipe LckA
     *
     * @return The value of the field "ReceiverState"
     */
    inline const ::std::string& getReceiverState () const;

    /**
     * Retrieves the value of the field "ReceiverState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceiverState".
     */
    inline ::std::string& getReceiverStateMutable ();

    /**
     * Sets the value of the member "ReceiverState".
     *
     * Receiver State
     * Bit 0 :TB otdm;
     * Bit 1 :S2B otdm;
     * Bit 2 :S1B otdm;
     * Bit 3 :Pipe LckB;
     * Bit 4 :TA otdm ;
     * Bit 5 :S2A otdm;
     * Bit 6 :S1A otdm
     * Bit 7 :Pipe LckA
     *
     * @param ReceiverState The value which will be set
     */
    inline void setReceiverState (const ::std::string& ReceiverState_);

    /**
     * Sets the value of the member "ReceiverState".
     *
     * Receiver State
     * Bit 0 :TB otdm;
     * Bit 1 :S2B otdm;
     * Bit 2 :S1B otdm;
     * Bit 3 :Pipe LckB;
     * Bit 4 :TA otdm ;
     * Bit 5 :S2A otdm;
     * Bit 6 :S1A otdm
     * Bit 7 :Pipe LckA
     *
     * @param ReceiverState The value which will be set
     */
    inline void setReceiverState (const char* ReceiverState_);

    /**
     * Sets the value of the member "ReceiverState".
     *
     * Receiver State
     * Bit 0 :TB otdm;
     * Bit 1 :S2B otdm;
     * Bit 2 :S1B otdm;
     * Bit 3 :Pipe LckB;
     * Bit 4 :TA otdm ;
     * Bit 5 :S2A otdm;
     * Bit 6 :S1A otdm
     * Bit 7 :Pipe LckA
     *
     * @param ReceiverState The value which will be set
     */
    inline void setReceiverState (const char* value, size_t size);

    // API of field "OBerS1A"

    static const int kOBerS1A = 1;

    /**
     * Clears the field "OBerS1A".
     *
     * The field will be set to its default value. The hasOBerS1A()
     * method will return false.
     */
    inline void clearOBerS1A();

    /**
     * Checks whether the field "OBerS1A" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBerS1A()). Otherwise it will return false.
     */
    inline bool hasOBerS1A () const;

    /**
     * Returns the value of the member "OBerS1A".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @return The value of the field "OBerS1A"
     */
    inline const ::std::string& getOBerS1A () const;

    /**
     * Retrieves the value of the field "OBerS1A" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OBerS1A".
     */
    inline ::std::string& getOBerS1AMutable ();

    /**
     * Sets the value of the member "OBerS1A".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerS1A The value which will be set
     */
    inline void setOBerS1A (const ::std::string& OBerS1A_);

    /**
     * Sets the value of the member "OBerS1A".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerS1A The value which will be set
     */
    inline void setOBerS1A (const char* OBerS1A_);

    /**
     * Sets the value of the member "OBerS1A".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerS1A The value which will be set
     */
    inline void setOBerS1A (const char* value, size_t size);

    // API of field "OBerS2A"

    static const int kOBerS2A = 2;

    /**
     * Clears the field "OBerS2A".
     *
     * The field will be set to its default value. The hasOBerS2A()
     * method will return false.
     */
    inline void clearOBerS2A();

    /**
     * Checks whether the field "OBerS2A" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBerS2A()). Otherwise it will return false.
     */
    inline bool hasOBerS2A () const;

    /**
     * Returns the value of the member "OBerS2A".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @return The value of the field "OBerS2A"
     */
    inline const ::std::string& getOBerS2A () const;

    /**
     * Retrieves the value of the field "OBerS2A" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OBerS2A".
     */
    inline ::std::string& getOBerS2AMutable ();

    /**
     * Sets the value of the member "OBerS2A".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerS2A The value which will be set
     */
    inline void setOBerS2A (const ::std::string& OBerS2A_);

    /**
     * Sets the value of the member "OBerS2A".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerS2A The value which will be set
     */
    inline void setOBerS2A (const char* OBerS2A_);

    /**
     * Sets the value of the member "OBerS2A".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerS2A The value which will be set
     */
    inline void setOBerS2A (const char* value, size_t size);

    // API of field "OBerTA"

    static const int kOBerTA = 3;

    /**
     * Clears the field "OBerTA".
     *
     * The field will be set to its default value. The hasOBerTA()
     * method will return false.
     */
    inline void clearOBerTA();

    /**
     * Checks whether the field "OBerTA" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBerTA()). Otherwise it will return false.
     */
    inline bool hasOBerTA () const;

    /**
     * Returns the value of the member "OBerTA".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @return The value of the field "OBerTA"
     */
    inline const ::std::string& getOBerTA () const;

    /**
     * Retrieves the value of the field "OBerTA" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OBerTA".
     */
    inline ::std::string& getOBerTAMutable ();

    /**
     * Sets the value of the member "OBerTA".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerTA The value which will be set
     */
    inline void setOBerTA (const ::std::string& OBerTA_);

    /**
     * Sets the value of the member "OBerTA".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerTA The value which will be set
     */
    inline void setOBerTA (const char* OBerTA_);

    /**
     * Sets the value of the member "OBerTA".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerTA The value which will be set
     */
    inline void setOBerTA (const char* value, size_t size);

    // API of field "OBerS1B"

    static const int kOBerS1B = 4;

    /**
     * Clears the field "OBerS1B".
     *
     * The field will be set to its default value. The hasOBerS1B()
     * method will return false.
     */
    inline void clearOBerS1B();

    /**
     * Checks whether the field "OBerS1B" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBerS1B()). Otherwise it will return false.
     */
    inline bool hasOBerS1B () const;

    /**
     * Returns the value of the member "OBerS1B".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @return The value of the field "OBerS1B"
     */
    inline const ::std::string& getOBerS1B () const;

    /**
     * Retrieves the value of the field "OBerS1B" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OBerS1B".
     */
    inline ::std::string& getOBerS1BMutable ();

    /**
     * Sets the value of the member "OBerS1B".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerS1B The value which will be set
     */
    inline void setOBerS1B (const ::std::string& OBerS1B_);

    /**
     * Sets the value of the member "OBerS1B".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerS1B The value which will be set
     */
    inline void setOBerS1B (const char* OBerS1B_);

    /**
     * Sets the value of the member "OBerS1B".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerS1B The value which will be set
     */
    inline void setOBerS1B (const char* value, size_t size);

    // API of field "OBerS2B"

    static const int kOBerS2B = 5;

    /**
     * Clears the field "OBerS2B".
     *
     * The field will be set to its default value. The hasOBerS2B()
     * method will return false.
     */
    inline void clearOBerS2B();

    /**
     * Checks whether the field "OBerS2B" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBerS2B()). Otherwise it will return false.
     */
    inline bool hasOBerS2B () const;

    /**
     * Returns the value of the member "OBerS2B".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @return The value of the field "OBerS2B"
     */
    inline const ::std::string& getOBerS2B () const;

    /**
     * Retrieves the value of the field "OBerS2B" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OBerS2B".
     */
    inline ::std::string& getOBerS2BMutable ();

    /**
     * Sets the value of the member "OBerS2B".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerS2B The value which will be set
     */
    inline void setOBerS2B (const ::std::string& OBerS2B_);

    /**
     * Sets the value of the member "OBerS2B".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerS2B The value which will be set
     */
    inline void setOBerS2B (const char* OBerS2B_);

    /**
     * Sets the value of the member "OBerS2B".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerS2B The value which will be set
     */
    inline void setOBerS2B (const char* value, size_t size);

    // API of field "OBerTB"

    static const int kOBerTB = 6;

    /**
     * Clears the field "OBerTB".
     *
     * The field will be set to its default value. The hasOBerTB()
     * method will return false.
     */
    inline void clearOBerTB();

    /**
     * Checks whether the field "OBerTB" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBerTB()). Otherwise it will return false.
     */
    inline bool hasOBerTB () const;

    /**
     * Returns the value of the member "OBerTB".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @return The value of the field "OBerTB"
     */
    inline const ::std::string& getOBerTB () const;

    /**
     * Retrieves the value of the field "OBerTB" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OBerTB".
     */
    inline ::std::string& getOBerTBMutable ();

    /**
     * Sets the value of the member "OBerTB".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerTB The value which will be set
     */
    inline void setOBerTB (const ::std::string& OBerTB_);

    /**
     * Sets the value of the member "OBerTB".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerTB The value which will be set
     */
    inline void setOBerTB (const char* OBerTB_);

    /**
     * Sets the value of the member "OBerTB".
     *
     * 0 to 100 %. (in tenths of percent).
     *
     * @param OBerTB The value which will be set
     */
    inline void setOBerTB (const char* value, size_t size);

    // API of field "OBERTrbWrdErRt0A"

    static const int kOBERTrbWrdErRt0A = 7;

    /**
     * Clears the field "OBERTrbWrdErRt0A".
     *
     * The field will be set to its default value. The hasOBERTrbWrdErRt0A()
     * method will return false.
     */
    inline void clearOBERTrbWrdErRt0A();

    /**
     * Checks whether the field "OBERTrbWrdErRt0A" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBERTrbWrdErRt0A()). Otherwise it will return false.
     */
    inline bool hasOBERTrbWrdErRt0A () const;

    /**
     * Returns the value of the member "OBERTrbWrdErRt0A".
     *
     * Turbo Word Error Rate (Pipe 0A): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent);999.9% for inactive pipe.
     *
     * @return The value of the field "OBERTrbWrdErRt0A"
     */
    inline const ::std::string& getOBERTrbWrdErRt0A () const;

    /**
     * Retrieves the value of the field "OBERTrbWrdErRt0A" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OBERTrbWrdErRt0A".
     */
    inline ::std::string& getOBERTrbWrdErRt0AMutable ();

    /**
     * Sets the value of the member "OBERTrbWrdErRt0A".
     *
     * Turbo Word Error Rate (Pipe 0A): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent);999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt0A The value which will be set
     */
    inline void setOBERTrbWrdErRt0A (const ::std::string& OBERTrbWrdErRt0A_);

    /**
     * Sets the value of the member "OBERTrbWrdErRt0A".
     *
     * Turbo Word Error Rate (Pipe 0A): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent);999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt0A The value which will be set
     */
    inline void setOBERTrbWrdErRt0A (const char* OBERTrbWrdErRt0A_);

    /**
     * Sets the value of the member "OBERTrbWrdErRt0A".
     *
     * Turbo Word Error Rate (Pipe 0A): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent);999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt0A The value which will be set
     */
    inline void setOBERTrbWrdErRt0A (const char* value, size_t size);

    // API of field "OBERTrbWrdErRt0B"

    static const int kOBERTrbWrdErRt0B = 8;

    /**
     * Clears the field "OBERTrbWrdErRt0B".
     *
     * The field will be set to its default value. The hasOBERTrbWrdErRt0B()
     * method will return false.
     */
    inline void clearOBERTrbWrdErRt0B();

    /**
     * Checks whether the field "OBERTrbWrdErRt0B" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBERTrbWrdErRt0B()). Otherwise it will return false.
     */
    inline bool hasOBERTrbWrdErRt0B () const;

    /**
     * Returns the value of the member "OBERTrbWrdErRt0B".
     *
     * Turbo Word Error Rate (Pipe 0B): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
     *
     * @return The value of the field "OBERTrbWrdErRt0B"
     */
    inline const ::std::string& getOBERTrbWrdErRt0B () const;

    /**
     * Retrieves the value of the field "OBERTrbWrdErRt0B" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OBERTrbWrdErRt0B".
     */
    inline ::std::string& getOBERTrbWrdErRt0BMutable ();

    /**
     * Sets the value of the member "OBERTrbWrdErRt0B".
     *
     * Turbo Word Error Rate (Pipe 0B): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt0B The value which will be set
     */
    inline void setOBERTrbWrdErRt0B (const ::std::string& OBERTrbWrdErRt0B_);

    /**
     * Sets the value of the member "OBERTrbWrdErRt0B".
     *
     * Turbo Word Error Rate (Pipe 0B): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt0B The value which will be set
     */
    inline void setOBERTrbWrdErRt0B (const char* OBERTrbWrdErRt0B_);

    /**
     * Sets the value of the member "OBERTrbWrdErRt0B".
     *
     * Turbo Word Error Rate (Pipe 0B): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt0B The value which will be set
     */
    inline void setOBERTrbWrdErRt0B (const char* value, size_t size);

    // API of field "OBERTrbWrdErRt1A"

    static const int kOBERTrbWrdErRt1A = 9;

    /**
     * Clears the field "OBERTrbWrdErRt1A".
     *
     * The field will be set to its default value. The hasOBERTrbWrdErRt1A()
     * method will return false.
     */
    inline void clearOBERTrbWrdErRt1A();

    /**
     * Checks whether the field "OBERTrbWrdErRt1A" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBERTrbWrdErRt1A()). Otherwise it will return false.
     */
    inline bool hasOBERTrbWrdErRt1A () const;

    /**
     * Returns the value of the member "OBERTrbWrdErRt1A".
     *
     * Turbo Word Error Rate (Pipe 1A): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent);999.9% for inactive pipe.
     *
     * @return The value of the field "OBERTrbWrdErRt1A"
     */
    inline const ::std::string& getOBERTrbWrdErRt1A () const;

    /**
     * Retrieves the value of the field "OBERTrbWrdErRt1A" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OBERTrbWrdErRt1A".
     */
    inline ::std::string& getOBERTrbWrdErRt1AMutable ();

    /**
     * Sets the value of the member "OBERTrbWrdErRt1A".
     *
     * Turbo Word Error Rate (Pipe 1A): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent);999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt1A The value which will be set
     */
    inline void setOBERTrbWrdErRt1A (const ::std::string& OBERTrbWrdErRt1A_);

    /**
     * Sets the value of the member "OBERTrbWrdErRt1A".
     *
     * Turbo Word Error Rate (Pipe 1A): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent);999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt1A The value which will be set
     */
    inline void setOBERTrbWrdErRt1A (const char* OBERTrbWrdErRt1A_);

    /**
     * Sets the value of the member "OBERTrbWrdErRt1A".
     *
     * Turbo Word Error Rate (Pipe 1A): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent);999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt1A The value which will be set
     */
    inline void setOBERTrbWrdErRt1A (const char* value, size_t size);

    // API of field "OBERTrbWrdErRt1B"

    static const int kOBERTrbWrdErRt1B = 10;

    /**
     * Clears the field "OBERTrbWrdErRt1B".
     *
     * The field will be set to its default value. The hasOBERTrbWrdErRt1B()
     * method will return false.
     */
    inline void clearOBERTrbWrdErRt1B();

    /**
     * Checks whether the field "OBERTrbWrdErRt1B" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBERTrbWrdErRt1B()). Otherwise it will return false.
     */
    inline bool hasOBERTrbWrdErRt1B () const;

    /**
     * Returns the value of the member "OBERTrbWrdErRt1B".
     *
     * Turbo Word Error Rate (Pipe 1B): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
     *
     * @return The value of the field "OBERTrbWrdErRt1B"
     */
    inline const ::std::string& getOBERTrbWrdErRt1B () const;

    /**
     * Retrieves the value of the field "OBERTrbWrdErRt1B" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OBERTrbWrdErRt1B".
     */
    inline ::std::string& getOBERTrbWrdErRt1BMutable ();

    /**
     * Sets the value of the member "OBERTrbWrdErRt1B".
     *
     * Turbo Word Error Rate (Pipe 1B): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt1B The value which will be set
     */
    inline void setOBERTrbWrdErRt1B (const ::std::string& OBERTrbWrdErRt1B_);

    /**
     * Sets the value of the member "OBERTrbWrdErRt1B".
     *
     * Turbo Word Error Rate (Pipe 1B): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt1B The value which will be set
     */
    inline void setOBERTrbWrdErRt1B (const char* OBERTrbWrdErRt1B_);

    /**
     * Sets the value of the member "OBERTrbWrdErRt1B".
     *
     * Turbo Word Error Rate (Pipe 1B): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt1B The value which will be set
     */
    inline void setOBERTrbWrdErRt1B (const char* value, size_t size);

    // API of field "OBERTrbWrdErRt2A"

    static const int kOBERTrbWrdErRt2A = 11;

    /**
     * Clears the field "OBERTrbWrdErRt2A".
     *
     * The field will be set to its default value. The hasOBERTrbWrdErRt2A()
     * method will return false.
     */
    inline void clearOBERTrbWrdErRt2A();

    /**
     * Checks whether the field "OBERTrbWrdErRt2A" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBERTrbWrdErRt2A()). Otherwise it will return false.
     */
    inline bool hasOBERTrbWrdErRt2A () const;

    /**
     * Returns the value of the member "OBERTrbWrdErRt2A".
     *
     * Turbo Word Error Rate (Pipe 2A): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent);999.9% for inactive pipe.
     *
     * @return The value of the field "OBERTrbWrdErRt2A"
     */
    inline const ::std::string& getOBERTrbWrdErRt2A () const;

    /**
     * Retrieves the value of the field "OBERTrbWrdErRt2A" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OBERTrbWrdErRt2A".
     */
    inline ::std::string& getOBERTrbWrdErRt2AMutable ();

    /**
     * Sets the value of the member "OBERTrbWrdErRt2A".
     *
     * Turbo Word Error Rate (Pipe 2A): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent);999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt2A The value which will be set
     */
    inline void setOBERTrbWrdErRt2A (const ::std::string& OBERTrbWrdErRt2A_);

    /**
     * Sets the value of the member "OBERTrbWrdErRt2A".
     *
     * Turbo Word Error Rate (Pipe 2A): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent);999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt2A The value which will be set
     */
    inline void setOBERTrbWrdErRt2A (const char* OBERTrbWrdErRt2A_);

    /**
     * Sets the value of the member "OBERTrbWrdErRt2A".
     *
     * Turbo Word Error Rate (Pipe 2A): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent);999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt2A The value which will be set
     */
    inline void setOBERTrbWrdErRt2A (const char* value, size_t size);

    // API of field "OBERTrbWrdErRt2B"

    static const int kOBERTrbWrdErRt2B = 12;

    /**
     * Clears the field "OBERTrbWrdErRt2B".
     *
     * The field will be set to its default value. The hasOBERTrbWrdErRt2B()
     * method will return false.
     */
    inline void clearOBERTrbWrdErRt2B();

    /**
     * Checks whether the field "OBERTrbWrdErRt2B" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBERTrbWrdErRt2B()). Otherwise it will return false.
     */
    inline bool hasOBERTrbWrdErRt2B () const;

    /**
     * Returns the value of the member "OBERTrbWrdErRt2B".
     *
     * Turbo Word Error Rate (Pipe 2B): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
     *
     * @return The value of the field "OBERTrbWrdErRt2B"
     */
    inline const ::std::string& getOBERTrbWrdErRt2B () const;

    /**
     * Retrieves the value of the field "OBERTrbWrdErRt2B" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OBERTrbWrdErRt2B".
     */
    inline ::std::string& getOBERTrbWrdErRt2BMutable ();

    /**
     * Sets the value of the member "OBERTrbWrdErRt2B".
     *
     * Turbo Word Error Rate (Pipe 2B): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt2B The value which will be set
     */
    inline void setOBERTrbWrdErRt2B (const ::std::string& OBERTrbWrdErRt2B_);

    /**
     * Sets the value of the member "OBERTrbWrdErRt2B".
     *
     * Turbo Word Error Rate (Pipe 2B): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt2B The value which will be set
     */
    inline void setOBERTrbWrdErRt2B (const char* OBERTrbWrdErRt2B_);

    /**
     * Sets the value of the member "OBERTrbWrdErRt2B".
     *
     * Turbo Word Error Rate (Pipe 2B): The averaged rate of uncorrectable
     * words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
     *
     * @param OBERTrbWrdErRt2B The value which will be set
     */
    inline void setOBERTrbWrdErRt2B (const char* value, size_t size);

    static const T_SxmDetOvrlSignalQuality &getDefaultInstance();

private:

    inline void set_has_ReceiverState ();

    inline void clear_has_ReceiverState ();

    inline void set_has_OBerS1A ();

    inline void clear_has_OBerS1A ();

    inline void set_has_OBerS2A ();

    inline void clear_has_OBerS2A ();

    inline void set_has_OBerTA ();

    inline void clear_has_OBerTA ();

    inline void set_has_OBerS1B ();

    inline void clear_has_OBerS1B ();

    inline void set_has_OBerS2B ();

    inline void clear_has_OBerS2B ();

    inline void set_has_OBerTB ();

    inline void clear_has_OBerTB ();

    inline void set_has_OBERTrbWrdErRt0A ();

    inline void clear_has_OBERTrbWrdErRt0A ();

    inline void set_has_OBERTrbWrdErRt0B ();

    inline void clear_has_OBERTrbWrdErRt0B ();

    inline void set_has_OBERTrbWrdErRt1A ();

    inline void clear_has_OBERTrbWrdErRt1A ();

    inline void set_has_OBERTrbWrdErRt1B ();

    inline void clear_has_OBERTrbWrdErRt1B ();

    inline void set_has_OBERTrbWrdErRt2A ();

    inline void clear_has_OBERTrbWrdErRt2A ();

    inline void set_has_OBERTrbWrdErRt2B ();

    inline void clear_has_OBERTrbWrdErRt2B ();

    uint32 _has_bits_[ (13 + 31) / 32];

    ::std::string _ReceiverState;

    ::std::string _OBerS1A;

    ::std::string _OBerS2A;

    ::std::string _OBerTA;

    ::std::string _OBerS1B;

    ::std::string _OBerS2B;

    ::std::string _OBerTB;

    ::std::string _OBERTrbWrdErRt0A;

    ::std::string _OBERTrbWrdErRt0B;

    ::std::string _OBERTrbWrdErRt1A;

    ::std::string _OBERTrbWrdErRt1B;

    ::std::string _OBERTrbWrdErRt2A;

    ::std::string _OBERTrbWrdErRt2B;

};

/**
 * If the meaning of "T_SxmVersionInfo" isn't clear, then there should be a description here.
 */
class T_SxmVersionInfo {
public:

    /**
     * Default constructor
     */
    inline  T_SxmVersionInfo ();

    /**
     * Copy constructor
     */
    inline  T_SxmVersionInfo (const T_SxmVersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmVersionInfo (const ::std::string& ModuleId_, const ::std::string& HwRev_, const ::std::string& SwRev_, const ::std::string& SxiRev_, const ::std::string& BbRev_, const ::std::string& HDecRev_, const ::std::string& RFRev_, const ::std::string& Capability_, const ::std::string& SPLRev_);

    /**
     * Destructor
     */
    inline  ~T_SxmVersionInfo();

    /**
     * Assignment operator
     */
    inline T_SxmVersionInfo& operator = (const T_SxmVersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmVersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmVersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmVersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmVersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ModuleId"

    static const int kModuleId = 0;

    /**
     * Clears the field "ModuleId".
     *
     * The field will be set to its default value. The hasModuleId()
     * method will return false.
     */
    inline void clearModuleId();

    /**
     * Checks whether the field "ModuleId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setModuleId()). Otherwise it will return false.
     */
    inline bool hasModuleId () const;

    /**
     * Returns the value of the member "ModuleId".
     *
     * Module Id.
     *
     * @return The value of the field "ModuleId"
     */
    inline const ::std::string& getModuleId () const;

    /**
     * Retrieves the value of the field "ModuleId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ModuleId".
     */
    inline ::std::string& getModuleIdMutable ();

    /**
     * Sets the value of the member "ModuleId".
     *
     * Module Id.
     *
     * @param ModuleId The value which will be set
     */
    inline void setModuleId (const ::std::string& ModuleId_);

    /**
     * Sets the value of the member "ModuleId".
     *
     * Module Id.
     *
     * @param ModuleId The value which will be set
     */
    inline void setModuleId (const char* ModuleId_);

    /**
     * Sets the value of the member "ModuleId".
     *
     * Module Id.
     *
     * @param ModuleId The value which will be set
     */
    inline void setModuleId (const char* value, size_t size);

    // API of field "HwRev"

    static const int kHwRev = 1;

    /**
     * Clears the field "HwRev".
     *
     * The field will be set to its default value. The hasHwRev()
     * method will return false.
     */
    inline void clearHwRev();

    /**
     * Checks whether the field "HwRev" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHwRev()). Otherwise it will return false.
     */
    inline bool hasHwRev () const;

    /**
     * Returns the value of the member "HwRev".
     *
     * Module hardware revision.
     *
     * @return The value of the field "HwRev"
     */
    inline const ::std::string& getHwRev () const;

    /**
     * Retrieves the value of the field "HwRev" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "HwRev".
     */
    inline ::std::string& getHwRevMutable ();

    /**
     * Sets the value of the member "HwRev".
     *
     * Module hardware revision.
     *
     * @param HwRev The value which will be set
     */
    inline void setHwRev (const ::std::string& HwRev_);

    /**
     * Sets the value of the member "HwRev".
     *
     * Module hardware revision.
     *
     * @param HwRev The value which will be set
     */
    inline void setHwRev (const char* HwRev_);

    /**
     * Sets the value of the member "HwRev".
     *
     * Module hardware revision.
     *
     * @param HwRev The value which will be set
     */
    inline void setHwRev (const char* value, size_t size);

    // API of field "SwRev"

    static const int kSwRev = 2;

    /**
     * Clears the field "SwRev".
     *
     * The field will be set to its default value. The hasSwRev()
     * method will return false.
     */
    inline void clearSwRev();

    /**
     * Checks whether the field "SwRev" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwRev()). Otherwise it will return false.
     */
    inline bool hasSwRev () const;

    /**
     * Returns the value of the member "SwRev".
     *
     * Module sotware revision.
     *
     * @return The value of the field "SwRev"
     */
    inline const ::std::string& getSwRev () const;

    /**
     * Retrieves the value of the field "SwRev" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SwRev".
     */
    inline ::std::string& getSwRevMutable ();

    /**
     * Sets the value of the member "SwRev".
     *
     * Module sotware revision.
     *
     * @param SwRev The value which will be set
     */
    inline void setSwRev (const ::std::string& SwRev_);

    /**
     * Sets the value of the member "SwRev".
     *
     * Module sotware revision.
     *
     * @param SwRev The value which will be set
     */
    inline void setSwRev (const char* SwRev_);

    /**
     * Sets the value of the member "SwRev".
     *
     * Module sotware revision.
     *
     * @param SwRev The value which will be set
     */
    inline void setSwRev (const char* value, size_t size);

    // API of field "SxiRev"

    static const int kSxiRev = 3;

    /**
     * Clears the field "SxiRev".
     *
     * The field will be set to its default value. The hasSxiRev()
     * method will return false.
     */
    inline void clearSxiRev();

    /**
     * Checks whether the field "SxiRev" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSxiRev()). Otherwise it will return false.
     */
    inline bool hasSxiRev () const;

    /**
     * Returns the value of the member "SxiRev".
     *
     * Module Sxi revision.
     *
     * @return The value of the field "SxiRev"
     */
    inline const ::std::string& getSxiRev () const;

    /**
     * Retrieves the value of the field "SxiRev" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SxiRev".
     */
    inline ::std::string& getSxiRevMutable ();

    /**
     * Sets the value of the member "SxiRev".
     *
     * Module Sxi revision.
     *
     * @param SxiRev The value which will be set
     */
    inline void setSxiRev (const ::std::string& SxiRev_);

    /**
     * Sets the value of the member "SxiRev".
     *
     * Module Sxi revision.
     *
     * @param SxiRev The value which will be set
     */
    inline void setSxiRev (const char* SxiRev_);

    /**
     * Sets the value of the member "SxiRev".
     *
     * Module Sxi revision.
     *
     * @param SxiRev The value which will be set
     */
    inline void setSxiRev (const char* value, size_t size);

    // API of field "BbRev"

    static const int kBbRev = 4;

    /**
     * Clears the field "BbRev".
     *
     * The field will be set to its default value. The hasBbRev()
     * method will return false.
     */
    inline void clearBbRev();

    /**
     * Checks whether the field "BbRev" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBbRev()). Otherwise it will return false.
     */
    inline bool hasBbRev () const;

    /**
     * Returns the value of the member "BbRev".
     *
     * BB revision.
     *
     * @return The value of the field "BbRev"
     */
    inline const ::std::string& getBbRev () const;

    /**
     * Retrieves the value of the field "BbRev" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BbRev".
     */
    inline ::std::string& getBbRevMutable ();

    /**
     * Sets the value of the member "BbRev".
     *
     * BB revision.
     *
     * @param BbRev The value which will be set
     */
    inline void setBbRev (const ::std::string& BbRev_);

    /**
     * Sets the value of the member "BbRev".
     *
     * BB revision.
     *
     * @param BbRev The value which will be set
     */
    inline void setBbRev (const char* BbRev_);

    /**
     * Sets the value of the member "BbRev".
     *
     * BB revision.
     *
     * @param BbRev The value which will be set
     */
    inline void setBbRev (const char* value, size_t size);

    // API of field "HDecRev"

    static const int kHDecRev = 5;

    /**
     * Clears the field "HDecRev".
     *
     * The field will be set to its default value. The hasHDecRev()
     * method will return false.
     */
    inline void clearHDecRev();

    /**
     * Checks whether the field "HDecRev" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHDecRev()). Otherwise it will return false.
     */
    inline bool hasHDecRev () const;

    /**
     * Returns the value of the member "HDecRev".
     *
     * HDec revision.
     *
     * @return The value of the field "HDecRev"
     */
    inline const ::std::string& getHDecRev () const;

    /**
     * Retrieves the value of the field "HDecRev" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "HDecRev".
     */
    inline ::std::string& getHDecRevMutable ();

    /**
     * Sets the value of the member "HDecRev".
     *
     * HDec revision.
     *
     * @param HDecRev The value which will be set
     */
    inline void setHDecRev (const ::std::string& HDecRev_);

    /**
     * Sets the value of the member "HDecRev".
     *
     * HDec revision.
     *
     * @param HDecRev The value which will be set
     */
    inline void setHDecRev (const char* HDecRev_);

    /**
     * Sets the value of the member "HDecRev".
     *
     * HDec revision.
     *
     * @param HDecRev The value which will be set
     */
    inline void setHDecRev (const char* value, size_t size);

    // API of field "RFRev"

    static const int kRFRev = 6;

    /**
     * Clears the field "RFRev".
     *
     * The field will be set to its default value. The hasRFRev()
     * method will return false.
     */
    inline void clearRFRev();

    /**
     * Checks whether the field "RFRev" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRFRev()). Otherwise it will return false.
     */
    inline bool hasRFRev () const;

    /**
     * Returns the value of the member "RFRev".
     *
     * RFRev revision.
     *
     * @return The value of the field "RFRev"
     */
    inline const ::std::string& getRFRev () const;

    /**
     * Retrieves the value of the field "RFRev" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RFRev".
     */
    inline ::std::string& getRFRevMutable ();

    /**
     * Sets the value of the member "RFRev".
     *
     * RFRev revision.
     *
     * @param RFRev The value which will be set
     */
    inline void setRFRev (const ::std::string& RFRev_);

    /**
     * Sets the value of the member "RFRev".
     *
     * RFRev revision.
     *
     * @param RFRev The value which will be set
     */
    inline void setRFRev (const char* RFRev_);

    /**
     * Sets the value of the member "RFRev".
     *
     * RFRev revision.
     *
     * @param RFRev The value which will be set
     */
    inline void setRFRev (const char* value, size_t size);

    // API of field "Capability"

    static const int kCapability = 7;

    /**
     * Clears the field "Capability".
     *
     * The field will be set to its default value. The hasCapability()
     * method will return false.
     */
    inline void clearCapability();

    /**
     * Checks whether the field "Capability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCapability()). Otherwise it will return false.
     */
    inline bool hasCapability () const;

    /**
     * Returns the value of the member "Capability".
     *
     * Capability.
     *
     * @return The value of the field "Capability"
     */
    inline const ::std::string& getCapability () const;

    /**
     * Retrieves the value of the field "Capability" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Capability".
     */
    inline ::std::string& getCapabilityMutable ();

    /**
     * Sets the value of the member "Capability".
     *
     * Capability.
     *
     * @param Capability The value which will be set
     */
    inline void setCapability (const ::std::string& Capability_);

    /**
     * Sets the value of the member "Capability".
     *
     * Capability.
     *
     * @param Capability The value which will be set
     */
    inline void setCapability (const char* Capability_);

    /**
     * Sets the value of the member "Capability".
     *
     * Capability.
     *
     * @param Capability The value which will be set
     */
    inline void setCapability (const char* value, size_t size);

    // API of field "SPLRev"

    static const int kSPLRev = 8;

    /**
     * Clears the field "SPLRev".
     *
     * The field will be set to its default value. The hasSPLRev()
     * method will return false.
     */
    inline void clearSPLRev();

    /**
     * Checks whether the field "SPLRev" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPLRev()). Otherwise it will return false.
     */
    inline bool hasSPLRev () const;

    /**
     * Returns the value of the member "SPLRev".
     *
     * Serial Program Loader Revision.Returns 9 characters in hex format
     *
     * @return The value of the field "SPLRev"
     */
    inline const ::std::string& getSPLRev () const;

    /**
     * Retrieves the value of the field "SPLRev" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SPLRev".
     */
    inline ::std::string& getSPLRevMutable ();

    /**
     * Sets the value of the member "SPLRev".
     *
     * Serial Program Loader Revision.Returns 9 characters in hex format
     *
     * @param SPLRev The value which will be set
     */
    inline void setSPLRev (const ::std::string& SPLRev_);

    /**
     * Sets the value of the member "SPLRev".
     *
     * Serial Program Loader Revision.Returns 9 characters in hex format
     *
     * @param SPLRev The value which will be set
     */
    inline void setSPLRev (const char* SPLRev_);

    /**
     * Sets the value of the member "SPLRev".
     *
     * Serial Program Loader Revision.Returns 9 characters in hex format
     *
     * @param SPLRev The value which will be set
     */
    inline void setSPLRev (const char* value, size_t size);

    static const T_SxmVersionInfo &getDefaultInstance();

private:

    inline void set_has_ModuleId ();

    inline void clear_has_ModuleId ();

    inline void set_has_HwRev ();

    inline void clear_has_HwRev ();

    inline void set_has_SwRev ();

    inline void clear_has_SwRev ();

    inline void set_has_SxiRev ();

    inline void clear_has_SxiRev ();

    inline void set_has_BbRev ();

    inline void clear_has_BbRev ();

    inline void set_has_HDecRev ();

    inline void clear_has_HDecRev ();

    inline void set_has_RFRev ();

    inline void clear_has_RFRev ();

    inline void set_has_Capability ();

    inline void clear_has_Capability ();

    inline void set_has_SPLRev ();

    inline void clear_has_SPLRev ();

    uint32 _has_bits_[ (9 + 31) / 32];

    ::std::string _ModuleId;

    ::std::string _HwRev;

    ::std::string _SwRev;

    ::std::string _SxiRev;

    ::std::string _BbRev;

    ::std::string _HDecRev;

    ::std::string _RFRev;

    ::std::string _Capability;

    ::std::string _SPLRev;

};

/**
 * If the meaning of "T_SxmDataSubStatus" isn't clear, then there should be a description here.
 */
class T_SxmDataSubStatus {
public:

    /**
     * Default constructor
     */
    inline  T_SxmDataSubStatus ();

    /**
     * Copy constructor
     */
    inline  T_SxmDataSubStatus (const T_SxmDataSubStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmDataSubStatus (uint8 SubStatus_, uint8 ReasonCode_, uint32 SuspendedDate_);

    /**
     * Destructor
     */
    inline  ~T_SxmDataSubStatus();

    /**
     * Assignment operator
     */
    inline T_SxmDataSubStatus& operator = (const T_SxmDataSubStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmDataSubStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmDataSubStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmDataSubStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmDataSubStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SubStatus"

    static const int kSubStatus = 0;

    /**
     * Clears the field "SubStatus".
     *
     * The field will be set to its default value. The hasSubStatus()
     * method will return false.
     */
    inline void clearSubStatus();

    /**
     * Checks whether the field "SubStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubStatus()). Otherwise it will return false.
     */
    inline bool hasSubStatus () const;

    /**
     * Returns the value of the member "SubStatus".
     *
     * Module Subscription status got from Engineering data
     *
     * @return The value of the field "SubStatus"
     */
    inline uint8 getSubStatus () const;

    /**
     * Sets the value of the member "SubStatus".
     *
     * Module Subscription status got from Engineering data
     *
     * @param SubStatus The value which will be set
     */
    inline void setSubStatus (uint8 SubStatus_);

    // API of field "ReasonCode"

    static const int kReasonCode = 1;

    /**
     * Clears the field "ReasonCode".
     *
     * The field will be set to its default value. The hasReasonCode()
     * method will return false.
     */
    inline void clearReasonCode();

    /**
     * Checks whether the field "ReasonCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReasonCode()). Otherwise it will return false.
     */
    inline bool hasReasonCode () const;

    /**
     * Returns the value of the member "ReasonCode".
     *
     * Reason Code for suspension
     *
     * @return The value of the field "ReasonCode"
     */
    inline uint8 getReasonCode () const;

    /**
     * Sets the value of the member "ReasonCode".
     *
     * Reason Code for suspension
     *
     * @param ReasonCode The value which will be set
     */
    inline void setReasonCode (uint8 ReasonCode_);

    // API of field "SuspendedDate"

    static const int kSuspendedDate = 2;

    /**
     * Clears the field "SuspendedDate".
     *
     * The field will be set to its default value. The hasSuspendedDate()
     * method will return false.
     */
    inline void clearSuspendedDate();

    /**
     * Checks whether the field "SuspendedDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuspendedDate()). Otherwise it will return false.
     */
    inline bool hasSuspendedDate () const;

    /**
     * Returns the value of the member "SuspendedDate".
     *
     * Suspended date
     *
     * @return The value of the field "SuspendedDate"
     */
    inline uint32 getSuspendedDate () const;

    /**
     * Sets the value of the member "SuspendedDate".
     *
     * Suspended date
     *
     * @param SuspendedDate The value which will be set
     */
    inline void setSuspendedDate (uint32 SuspendedDate_);

    static const T_SxmDataSubStatus &getDefaultInstance();

private:

    inline void set_has_SubStatus ();

    inline void clear_has_SubStatus ();

    inline void set_has_ReasonCode ();

    inline void clear_has_ReasonCode ();

    inline void set_has_SuspendedDate ();

    inline void clear_has_SuspendedDate ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _SubStatus;

    uint8 _ReasonCode;

    uint32 _SuspendedDate;

};

/**
 * If the meaning of "T_SxmDiagTestModeData" isn't clear, then there should be a description here.
 */
class T_SxmDiagTestModeData {
public:

    /**
     * Default constructor
     */
    inline  T_SxmDiagTestModeData ();

    /**
     * Copy constructor
     */
    inline  T_SxmDiagTestModeData (const T_SxmDiagTestModeData &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmDiagTestModeData (const T_SxmDetSignalQuality& DetSignalQuality_, const T_SxmDetOvrlSignalQuality& DetOvrlSignalQuality_, const T_SxmVersionInfo& SxmVersionInfo_, const T_SxmDataSubStatus& SxmSubscriptionState_);

    /**
     * Destructor
     */
    inline  ~T_SxmDiagTestModeData();

    /**
     * Assignment operator
     */
    inline T_SxmDiagTestModeData& operator = (const T_SxmDiagTestModeData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmDiagTestModeData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmDiagTestModeData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmDiagTestModeData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmDiagTestModeData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DetSignalQuality"

    static const int kDetSignalQuality = 0;

    /**
     * Clears the field "DetSignalQuality".
     *
     * The field will be set to its default value. The hasDetSignalQuality()
     * method will return false.
     */
    inline void clearDetSignalQuality();

    /**
     * Checks whether the field "DetSignalQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDetSignalQuality()). Otherwise it will return false.
     */
    inline bool hasDetSignalQuality () const;

    /**
     * Returns the value of the member "DetSignalQuality".
     *
     * Structure containing detailed signal quality values
     *
     * @return The value of the field "DetSignalQuality"
     */
    inline const T_SxmDetSignalQuality& getDetSignalQuality () const;

    /**
     * Retrieves the value of the field "DetSignalQuality" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DetSignalQuality".
     */
    inline T_SxmDetSignalQuality& getDetSignalQualityMutable ();

    /**
     * Sets the value of the member "DetSignalQuality".
     *
     * Structure containing detailed signal quality values
     *
     * @param DetSignalQuality The value which will be set
     */
    inline void setDetSignalQuality (const T_SxmDetSignalQuality& DetSignalQuality_);

    // API of field "DetOvrlSignalQuality"

    static const int kDetOvrlSignalQuality = 1;

    /**
     * Clears the field "DetOvrlSignalQuality".
     *
     * The field will be set to its default value. The hasDetOvrlSignalQuality()
     * method will return false.
     */
    inline void clearDetOvrlSignalQuality();

    /**
     * Checks whether the field "DetOvrlSignalQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDetOvrlSignalQuality()). Otherwise it will return false.
     */
    inline bool hasDetOvrlSignalQuality () const;

    /**
     * Returns the value of the member "DetOvrlSignalQuality".
     *
     * Structure containing detailed overlay signal quality values
     *
     * @return The value of the field "DetOvrlSignalQuality"
     */
    inline const T_SxmDetOvrlSignalQuality& getDetOvrlSignalQuality () const;

    /**
     * Retrieves the value of the field "DetOvrlSignalQuality" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DetOvrlSignalQuality".
     */
    inline T_SxmDetOvrlSignalQuality& getDetOvrlSignalQualityMutable ();

    /**
     * Sets the value of the member "DetOvrlSignalQuality".
     *
     * Structure containing detailed overlay signal quality values
     *
     * @param DetOvrlSignalQuality The value which will be set
     */
    inline void setDetOvrlSignalQuality (const T_SxmDetOvrlSignalQuality& DetOvrlSignalQuality_);

    // API of field "SxmVersionInfo"

    static const int kSxmVersionInfo = 2;

    /**
     * Clears the field "SxmVersionInfo".
     *
     * The field will be set to its default value. The hasSxmVersionInfo()
     * method will return false.
     */
    inline void clearSxmVersionInfo();

    /**
     * Checks whether the field "SxmVersionInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSxmVersionInfo()). Otherwise it will return false.
     */
    inline bool hasSxmVersionInfo () const;

    /**
     * Returns the value of the member "SxmVersionInfo".
     *
     * Structure containing SXM version info
     *
     * @return The value of the field "SxmVersionInfo"
     */
    inline const T_SxmVersionInfo& getSxmVersionInfo () const;

    /**
     * Retrieves the value of the field "SxmVersionInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SxmVersionInfo".
     */
    inline T_SxmVersionInfo& getSxmVersionInfoMutable ();

    /**
     * Sets the value of the member "SxmVersionInfo".
     *
     * Structure containing SXM version info
     *
     * @param SxmVersionInfo The value which will be set
     */
    inline void setSxmVersionInfo (const T_SxmVersionInfo& SxmVersionInfo_);

    // API of field "SxmSubscriptionState"

    static const int kSxmSubscriptionState = 3;

    /**
     * Clears the field "SxmSubscriptionState".
     *
     * The field will be set to its default value. The hasSxmSubscriptionState()
     * method will return false.
     */
    inline void clearSxmSubscriptionState();

    /**
     * Checks whether the field "SxmSubscriptionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSxmSubscriptionState()). Otherwise it will return false.
     */
    inline bool hasSxmSubscriptionState () const;

    /**
     * Returns the value of the member "SxmSubscriptionState".
     *
     * Structure containing Module subscription status
     *
     * @return The value of the field "SxmSubscriptionState"
     */
    inline const T_SxmDataSubStatus& getSxmSubscriptionState () const;

    /**
     * Retrieves the value of the field "SxmSubscriptionState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SxmSubscriptionState".
     */
    inline T_SxmDataSubStatus& getSxmSubscriptionStateMutable ();

    /**
     * Sets the value of the member "SxmSubscriptionState".
     *
     * Structure containing Module subscription status
     *
     * @param SxmSubscriptionState The value which will be set
     */
    inline void setSxmSubscriptionState (const T_SxmDataSubStatus& SxmSubscriptionState_);

    static const T_SxmDiagTestModeData &getDefaultInstance();

private:

    inline void set_has_DetSignalQuality ();

    inline void clear_has_DetSignalQuality ();

    inline void set_has_DetOvrlSignalQuality ();

    inline void clear_has_DetOvrlSignalQuality ();

    inline void set_has_SxmVersionInfo ();

    inline void clear_has_SxmVersionInfo ();

    inline void set_has_SxmSubscriptionState ();

    inline void clear_has_SxmSubscriptionState ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_SxmDetSignalQuality _DetSignalQuality;

    T_SxmDetOvrlSignalQuality _DetOvrlSignalQuality;

    T_SxmVersionInfo _SxmVersionInfo;

    T_SxmDataSubStatus _SxmSubscriptionState;

};

/**
 * If the meaning of "T_SxmSmsDbInfo" isn't clear, then there should be a description here.
 */
class T_SxmSmsDbInfo {
public:

    /**
     * Default constructor
     */
    inline  T_SxmSmsDbInfo ();

    /**
     * Copy constructor
     */
    inline  T_SxmSmsDbInfo (const T_SxmSmsDbInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmSmsDbInfo (const ::std::string& CgsDb_, const ::std::string& FuelDb_, const ::std::string& MovieDb_, const ::std::string& TabWeatherDb_, const ::std::string& StockDb_, const ::std::string& WsAlertsDb_, const ::std::string& SportsDB_, const ::std::string& ParkingDB_, const ::std::string& PhoneticsDB_, const ::std::string& FuelCanadaDB_, const ::std::string& SafeViewdb_, const ::std::string& SmsVersion_);

    /**
     * Destructor
     */
    inline  ~T_SxmSmsDbInfo();

    /**
     * Assignment operator
     */
    inline T_SxmSmsDbInfo& operator = (const T_SxmSmsDbInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmSmsDbInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmSmsDbInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmSmsDbInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmSmsDbInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CgsDb"

    static const int kCgsDb = 0;

    /**
     * Clears the field "CgsDb".
     *
     * The field will be set to its default value. The hasCgsDb()
     * method will return false.
     */
    inline void clearCgsDb();

    /**
     * Checks whether the field "CgsDb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCgsDb()). Otherwise it will return false.
     */
    inline bool hasCgsDb () const;

    /**
     * Returns the value of the member "CgsDb".
     *
     * Channel graphics reference database version.
     *
     * @return The value of the field "CgsDb"
     */
    inline const ::std::string& getCgsDb () const;

    /**
     * Retrieves the value of the field "CgsDb" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CgsDb".
     */
    inline ::std::string& getCgsDbMutable ();

    /**
     * Sets the value of the member "CgsDb".
     *
     * Channel graphics reference database version.
     *
     * @param CgsDb The value which will be set
     */
    inline void setCgsDb (const ::std::string& CgsDb_);

    /**
     * Sets the value of the member "CgsDb".
     *
     * Channel graphics reference database version.
     *
     * @param CgsDb The value which will be set
     */
    inline void setCgsDb (const char* CgsDb_);

    /**
     * Sets the value of the member "CgsDb".
     *
     * Channel graphics reference database version.
     *
     * @param CgsDb The value which will be set
     */
    inline void setCgsDb (const char* value, size_t size);

    // API of field "FuelDb"

    static const int kFuelDb = 1;

    /**
     * Clears the field "FuelDb".
     *
     * The field will be set to its default value. The hasFuelDb()
     * method will return false.
     */
    inline void clearFuelDb();

    /**
     * Checks whether the field "FuelDb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelDb()). Otherwise it will return false.
     */
    inline bool hasFuelDb () const;

    /**
     * Returns the value of the member "FuelDb".
     *
     * USA Fuel reference database version.
     *
     * @return The value of the field "FuelDb"
     */
    inline const ::std::string& getFuelDb () const;

    /**
     * Retrieves the value of the field "FuelDb" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelDb".
     */
    inline ::std::string& getFuelDbMutable ();

    /**
     * Sets the value of the member "FuelDb".
     *
     * USA Fuel reference database version.
     *
     * @param FuelDb The value which will be set
     */
    inline void setFuelDb (const ::std::string& FuelDb_);

    /**
     * Sets the value of the member "FuelDb".
     *
     * USA Fuel reference database version.
     *
     * @param FuelDb The value which will be set
     */
    inline void setFuelDb (const char* FuelDb_);

    /**
     * Sets the value of the member "FuelDb".
     *
     * USA Fuel reference database version.
     *
     * @param FuelDb The value which will be set
     */
    inline void setFuelDb (const char* value, size_t size);

    // API of field "MovieDb"

    static const int kMovieDb = 2;

    /**
     * Clears the field "MovieDb".
     *
     * The field will be set to its default value. The hasMovieDb()
     * method will return false.
     */
    inline void clearMovieDb();

    /**
     * Checks whether the field "MovieDb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovieDb()). Otherwise it will return false.
     */
    inline bool hasMovieDb () const;

    /**
     * Returns the value of the member "MovieDb".
     *
     * Movie reference database version.
     *
     * @return The value of the field "MovieDb"
     */
    inline const ::std::string& getMovieDb () const;

    /**
     * Retrieves the value of the field "MovieDb" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MovieDb".
     */
    inline ::std::string& getMovieDbMutable ();

    /**
     * Sets the value of the member "MovieDb".
     *
     * Movie reference database version.
     *
     * @param MovieDb The value which will be set
     */
    inline void setMovieDb (const ::std::string& MovieDb_);

    /**
     * Sets the value of the member "MovieDb".
     *
     * Movie reference database version.
     *
     * @param MovieDb The value which will be set
     */
    inline void setMovieDb (const char* MovieDb_);

    /**
     * Sets the value of the member "MovieDb".
     *
     * Movie reference database version.
     *
     * @param MovieDb The value which will be set
     */
    inline void setMovieDb (const char* value, size_t size);

    // API of field "TabWeatherDb"

    static const int kTabWeatherDb = 3;

    /**
     * Clears the field "TabWeatherDb".
     *
     * The field will be set to its default value. The hasTabWeatherDb()
     * method will return false.
     */
    inline void clearTabWeatherDb();

    /**
     * Checks whether the field "TabWeatherDb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTabWeatherDb()). Otherwise it will return false.
     */
    inline bool hasTabWeatherDb () const;

    /**
     * Returns the value of the member "TabWeatherDb".
     *
     * Tabular Weather reference database version.
     *
     * @return The value of the field "TabWeatherDb"
     */
    inline const ::std::string& getTabWeatherDb () const;

    /**
     * Retrieves the value of the field "TabWeatherDb" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TabWeatherDb".
     */
    inline ::std::string& getTabWeatherDbMutable ();

    /**
     * Sets the value of the member "TabWeatherDb".
     *
     * Tabular Weather reference database version.
     *
     * @param TabWeatherDb The value which will be set
     */
    inline void setTabWeatherDb (const ::std::string& TabWeatherDb_);

    /**
     * Sets the value of the member "TabWeatherDb".
     *
     * Tabular Weather reference database version.
     *
     * @param TabWeatherDb The value which will be set
     */
    inline void setTabWeatherDb (const char* TabWeatherDb_);

    /**
     * Sets the value of the member "TabWeatherDb".
     *
     * Tabular Weather reference database version.
     *
     * @param TabWeatherDb The value which will be set
     */
    inline void setTabWeatherDb (const char* value, size_t size);

    // API of field "StockDb"

    static const int kStockDb = 4;

    /**
     * Clears the field "StockDb".
     *
     * The field will be set to its default value. The hasStockDb()
     * method will return false.
     */
    inline void clearStockDb();

    /**
     * Checks whether the field "StockDb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStockDb()). Otherwise it will return false.
     */
    inline bool hasStockDb () const;

    /**
     * Returns the value of the member "StockDb".
     *
     * Stock reference database version.
     *
     * @return The value of the field "StockDb"
     */
    inline const ::std::string& getStockDb () const;

    /**
     * Retrieves the value of the field "StockDb" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StockDb".
     */
    inline ::std::string& getStockDbMutable ();

    /**
     * Sets the value of the member "StockDb".
     *
     * Stock reference database version.
     *
     * @param StockDb The value which will be set
     */
    inline void setStockDb (const ::std::string& StockDb_);

    /**
     * Sets the value of the member "StockDb".
     *
     * Stock reference database version.
     *
     * @param StockDb The value which will be set
     */
    inline void setStockDb (const char* StockDb_);

    /**
     * Sets the value of the member "StockDb".
     *
     * Stock reference database version.
     *
     * @param StockDb The value which will be set
     */
    inline void setStockDb (const char* value, size_t size);

    // API of field "WsAlertsDb"

    static const int kWsAlertsDb = 5;

    /**
     * Clears the field "WsAlertsDb".
     *
     * The field will be set to its default value. The hasWsAlertsDb()
     * method will return false.
     */
    inline void clearWsAlertsDb();

    /**
     * Checks whether the field "WsAlertsDb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWsAlertsDb()). Otherwise it will return false.
     */
    inline bool hasWsAlertsDb () const;

    /**
     * Returns the value of the member "WsAlertsDb".
     *
     * WS Alerts reference database version.
     *
     * @return The value of the field "WsAlertsDb"
     */
    inline const ::std::string& getWsAlertsDb () const;

    /**
     * Retrieves the value of the field "WsAlertsDb" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WsAlertsDb".
     */
    inline ::std::string& getWsAlertsDbMutable ();

    /**
     * Sets the value of the member "WsAlertsDb".
     *
     * WS Alerts reference database version.
     *
     * @param WsAlertsDb The value which will be set
     */
    inline void setWsAlertsDb (const ::std::string& WsAlertsDb_);

    /**
     * Sets the value of the member "WsAlertsDb".
     *
     * WS Alerts reference database version.
     *
     * @param WsAlertsDb The value which will be set
     */
    inline void setWsAlertsDb (const char* WsAlertsDb_);

    /**
     * Sets the value of the member "WsAlertsDb".
     *
     * WS Alerts reference database version.
     *
     * @param WsAlertsDb The value which will be set
     */
    inline void setWsAlertsDb (const char* value, size_t size);

    // API of field "SportsDB"

    static const int kSportsDB = 6;

    /**
     * Clears the field "SportsDB".
     *
     * The field will be set to its default value. The hasSportsDB()
     * method will return false.
     */
    inline void clearSportsDB();

    /**
     * Checks whether the field "SportsDB" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportsDB()). Otherwise it will return false.
     */
    inline bool hasSportsDB () const;

    /**
     * Returns the value of the member "SportsDB".
     *
     * Sports reference database version.
     *
     * @return The value of the field "SportsDB"
     */
    inline const ::std::string& getSportsDB () const;

    /**
     * Retrieves the value of the field "SportsDB" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SportsDB".
     */
    inline ::std::string& getSportsDBMutable ();

    /**
     * Sets the value of the member "SportsDB".
     *
     * Sports reference database version.
     *
     * @param SportsDB The value which will be set
     */
    inline void setSportsDB (const ::std::string& SportsDB_);

    /**
     * Sets the value of the member "SportsDB".
     *
     * Sports reference database version.
     *
     * @param SportsDB The value which will be set
     */
    inline void setSportsDB (const char* SportsDB_);

    /**
     * Sets the value of the member "SportsDB".
     *
     * Sports reference database version.
     *
     * @param SportsDB The value which will be set
     */
    inline void setSportsDB (const char* value, size_t size);

    // API of field "ParkingDB"

    static const int kParkingDB = 7;

    /**
     * Clears the field "ParkingDB".
     *
     * The field will be set to its default value. The hasParkingDB()
     * method will return false.
     */
    inline void clearParkingDB();

    /**
     * Checks whether the field "ParkingDB" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParkingDB()). Otherwise it will return false.
     */
    inline bool hasParkingDB () const;

    /**
     * Returns the value of the member "ParkingDB".
     *
     * Parking reference database version.
     *
     * @return The value of the field "ParkingDB"
     */
    inline const ::std::string& getParkingDB () const;

    /**
     * Retrieves the value of the field "ParkingDB" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ParkingDB".
     */
    inline ::std::string& getParkingDBMutable ();

    /**
     * Sets the value of the member "ParkingDB".
     *
     * Parking reference database version.
     *
     * @param ParkingDB The value which will be set
     */
    inline void setParkingDB (const ::std::string& ParkingDB_);

    /**
     * Sets the value of the member "ParkingDB".
     *
     * Parking reference database version.
     *
     * @param ParkingDB The value which will be set
     */
    inline void setParkingDB (const char* ParkingDB_);

    /**
     * Sets the value of the member "ParkingDB".
     *
     * Parking reference database version.
     *
     * @param ParkingDB The value which will be set
     */
    inline void setParkingDB (const char* value, size_t size);

    // API of field "PhoneticsDB"

    static const int kPhoneticsDB = 8;

    /**
     * Clears the field "PhoneticsDB".
     *
     * The field will be set to its default value. The hasPhoneticsDB()
     * method will return false.
     */
    inline void clearPhoneticsDB();

    /**
     * Checks whether the field "PhoneticsDB" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneticsDB()). Otherwise it will return false.
     */
    inline bool hasPhoneticsDB () const;

    /**
     * Returns the value of the member "PhoneticsDB".
     *
     * Phonetics reference database version.
     *
     * @return The value of the field "PhoneticsDB"
     */
    inline const ::std::string& getPhoneticsDB () const;

    /**
     * Retrieves the value of the field "PhoneticsDB" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneticsDB".
     */
    inline ::std::string& getPhoneticsDBMutable ();

    /**
     * Sets the value of the member "PhoneticsDB".
     *
     * Phonetics reference database version.
     *
     * @param PhoneticsDB The value which will be set
     */
    inline void setPhoneticsDB (const ::std::string& PhoneticsDB_);

    /**
     * Sets the value of the member "PhoneticsDB".
     *
     * Phonetics reference database version.
     *
     * @param PhoneticsDB The value which will be set
     */
    inline void setPhoneticsDB (const char* PhoneticsDB_);

    /**
     * Sets the value of the member "PhoneticsDB".
     *
     * Phonetics reference database version.
     *
     * @param PhoneticsDB The value which will be set
     */
    inline void setPhoneticsDB (const char* value, size_t size);

    // API of field "FuelCanadaDB"

    static const int kFuelCanadaDB = 9;

    /**
     * Clears the field "FuelCanadaDB".
     *
     * The field will be set to its default value. The hasFuelCanadaDB()
     * method will return false.
     */
    inline void clearFuelCanadaDB();

    /**
     * Checks whether the field "FuelCanadaDB" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelCanadaDB()). Otherwise it will return false.
     */
    inline bool hasFuelCanadaDB () const;

    /**
     * Returns the value of the member "FuelCanadaDB".
     *
     * Canadaian Fuel reference database version.
     *
     * @return The value of the field "FuelCanadaDB"
     */
    inline const ::std::string& getFuelCanadaDB () const;

    /**
     * Retrieves the value of the field "FuelCanadaDB" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelCanadaDB".
     */
    inline ::std::string& getFuelCanadaDBMutable ();

    /**
     * Sets the value of the member "FuelCanadaDB".
     *
     * Canadaian Fuel reference database version.
     *
     * @param FuelCanadaDB The value which will be set
     */
    inline void setFuelCanadaDB (const ::std::string& FuelCanadaDB_);

    /**
     * Sets the value of the member "FuelCanadaDB".
     *
     * Canadaian Fuel reference database version.
     *
     * @param FuelCanadaDB The value which will be set
     */
    inline void setFuelCanadaDB (const char* FuelCanadaDB_);

    /**
     * Sets the value of the member "FuelCanadaDB".
     *
     * Canadaian Fuel reference database version.
     *
     * @param FuelCanadaDB The value which will be set
     */
    inline void setFuelCanadaDB (const char* value, size_t size);

    // API of field "SafeViewdb"

    static const int kSafeViewdb = 10;

    /**
     * Clears the field "SafeViewdb".
     *
     * The field will be set to its default value. The hasSafeViewdb()
     * method will return false.
     */
    inline void clearSafeViewdb();

    /**
     * Checks whether the field "SafeViewdb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSafeViewdb()). Otherwise it will return false.
     */
    inline bool hasSafeViewdb () const;

    /**
     * Returns the value of the member "SafeViewdb".
     *
     * Safe View reference database version.
     *
     * @return The value of the field "SafeViewdb"
     */
    inline const ::std::string& getSafeViewdb () const;

    /**
     * Retrieves the value of the field "SafeViewdb" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SafeViewdb".
     */
    inline ::std::string& getSafeViewdbMutable ();

    /**
     * Sets the value of the member "SafeViewdb".
     *
     * Safe View reference database version.
     *
     * @param SafeViewdb The value which will be set
     */
    inline void setSafeViewdb (const ::std::string& SafeViewdb_);

    /**
     * Sets the value of the member "SafeViewdb".
     *
     * Safe View reference database version.
     *
     * @param SafeViewdb The value which will be set
     */
    inline void setSafeViewdb (const char* SafeViewdb_);

    /**
     * Sets the value of the member "SafeViewdb".
     *
     * Safe View reference database version.
     *
     * @param SafeViewdb The value which will be set
     */
    inline void setSafeViewdb (const char* value, size_t size);

    // API of field "SmsVersion"

    static const int kSmsVersion = 11;

    /**
     * Clears the field "SmsVersion".
     *
     * The field will be set to its default value. The hasSmsVersion()
     * method will return false.
     */
    inline void clearSmsVersion();

    /**
     * Checks whether the field "SmsVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSmsVersion()). Otherwise it will return false.
     */
    inline bool hasSmsVersion () const;

    /**
     * Returns the value of the member "SmsVersion".
     *
     * Current SMS version.
     *
     * @return The value of the field "SmsVersion"
     */
    inline const ::std::string& getSmsVersion () const;

    /**
     * Retrieves the value of the field "SmsVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SmsVersion".
     */
    inline ::std::string& getSmsVersionMutable ();

    /**
     * Sets the value of the member "SmsVersion".
     *
     * Current SMS version.
     *
     * @param SmsVersion The value which will be set
     */
    inline void setSmsVersion (const ::std::string& SmsVersion_);

    /**
     * Sets the value of the member "SmsVersion".
     *
     * Current SMS version.
     *
     * @param SmsVersion The value which will be set
     */
    inline void setSmsVersion (const char* SmsVersion_);

    /**
     * Sets the value of the member "SmsVersion".
     *
     * Current SMS version.
     *
     * @param SmsVersion The value which will be set
     */
    inline void setSmsVersion (const char* value, size_t size);

    static const T_SxmSmsDbInfo &getDefaultInstance();

private:

    inline void set_has_CgsDb ();

    inline void clear_has_CgsDb ();

    inline void set_has_FuelDb ();

    inline void clear_has_FuelDb ();

    inline void set_has_MovieDb ();

    inline void clear_has_MovieDb ();

    inline void set_has_TabWeatherDb ();

    inline void clear_has_TabWeatherDb ();

    inline void set_has_StockDb ();

    inline void clear_has_StockDb ();

    inline void set_has_WsAlertsDb ();

    inline void clear_has_WsAlertsDb ();

    inline void set_has_SportsDB ();

    inline void clear_has_SportsDB ();

    inline void set_has_ParkingDB ();

    inline void clear_has_ParkingDB ();

    inline void set_has_PhoneticsDB ();

    inline void clear_has_PhoneticsDB ();

    inline void set_has_FuelCanadaDB ();

    inline void clear_has_FuelCanadaDB ();

    inline void set_has_SafeViewdb ();

    inline void clear_has_SafeViewdb ();

    inline void set_has_SmsVersion ();

    inline void clear_has_SmsVersion ();

    uint32 _has_bits_[ (12 + 31) / 32];

    ::std::string _CgsDb;

    ::std::string _FuelDb;

    ::std::string _MovieDb;

    ::std::string _TabWeatherDb;

    ::std::string _StockDb;

    ::std::string _WsAlertsDb;

    ::std::string _SportsDB;

    ::std::string _ParkingDB;

    ::std::string _PhoneticsDB;

    ::std::string _FuelCanadaDB;

    ::std::string _SafeViewdb;

    ::std::string _SmsVersion;

};

/**
 * If the meaning of "T_SxmAudioSubInfo" isn't clear, then there should be a description here.
 */
class T_SxmAudioSubInfo {
public:

    /**
     * Default constructor
     */
    inline  T_SxmAudioSubInfo ();

    /**
     * Copy constructor
     */
    inline  T_SxmAudioSubInfo (const T_SxmAudioSubInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmAudioSubInfo (uint8 SubStatus_);

    /**
     * Destructor
     */
    inline  ~T_SxmAudioSubInfo();

    /**
     * Assignment operator
     */
    inline T_SxmAudioSubInfo& operator = (const T_SxmAudioSubInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmAudioSubInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmAudioSubInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmAudioSubInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmAudioSubInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SubStatus"

    static const int kSubStatus = 0;

    /**
     * Clears the field "SubStatus".
     *
     * The field will be set to its default value. The hasSubStatus()
     * method will return false.
     */
    inline void clearSubStatus();

    /**
     * Checks whether the field "SubStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubStatus()). Otherwise it will return false.
     */
    inline bool hasSubStatus () const;

    /**
     * Returns the value of the member "SubStatus".
     *
     * Audio Subscription status.Currently mapped to module subscription status itself.
     *
     * @return The value of the field "SubStatus"
     */
    inline uint8 getSubStatus () const;

    /**
     * Sets the value of the member "SubStatus".
     *
     * Audio Subscription status.Currently mapped to module subscription status itself.
     *
     * @param SubStatus The value which will be set
     */
    inline void setSubStatus (uint8 SubStatus_);

    static const T_SxmAudioSubInfo &getDefaultInstance();

private:

    inline void set_has_SubStatus ();

    inline void clear_has_SubStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _SubStatus;

};

/**
 * If the meaning of "T_SmartFavoritePreset" isn't clear, then there should be a description here.
 */
class T_SmartFavoritePreset {
public:

    /**
     * Default constructor
     */
    inline  T_SmartFavoritePreset ();

    /**
     * Copy constructor
     */
    inline  T_SmartFavoritePreset (const T_SmartFavoritePreset &rhs);

    /**
     * All fields constructor
     */
    inline  T_SmartFavoritePreset (uint8 PresetIndex_, bool IsSmartFavorite_);

    /**
     * Destructor
     */
    inline  ~T_SmartFavoritePreset();

    /**
     * Assignment operator
     */
    inline T_SmartFavoritePreset& operator = (const T_SmartFavoritePreset& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SmartFavoritePreset& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SmartFavoritePreset& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SmartFavoritePreset& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SmartFavoritePreset& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PresetIndex"

    static const int kPresetIndex = 0;

    /**
     * Clears the field "PresetIndex".
     *
     * The field will be set to its default value. The hasPresetIndex()
     * method will return false.
     */
    inline void clearPresetIndex();

    /**
     * Checks whether the field "PresetIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetIndex()). Otherwise it will return false.
     */
    inline bool hasPresetIndex () const;

    /**
     * Returns the value of the member "PresetIndex".
     *
     * Preset index value
     *
     * @return The value of the field "PresetIndex"
     */
    inline uint8 getPresetIndex () const;

    /**
     * Sets the value of the member "PresetIndex".
     *
     * Preset index value
     *
     * @param PresetIndex The value which will be set
     */
    inline void setPresetIndex (uint8 PresetIndex_);

    // API of field "IsSmartFavorite"

    static const int kIsSmartFavorite = 1;

    /**
     * Clears the field "IsSmartFavorite".
     *
     * The field will be set to its default value. The hasIsSmartFavorite()
     * method will return false.
     */
    inline void clearIsSmartFavorite();

    /**
     * Checks whether the field "IsSmartFavorite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsSmartFavorite()). Otherwise it will return false.
     */
    inline bool hasIsSmartFavorite () const;

    /**
     * Returns the value of the member "IsSmartFavorite".
     *
     * Flag to indicate preset index contains smart favorite channel
     *
     * @return The value of the field "IsSmartFavorite"
     */
    inline bool getIsSmartFavorite () const;

    /**
     * Sets the value of the member "IsSmartFavorite".
     *
     * Flag to indicate preset index contains smart favorite channel
     *
     * @param IsSmartFavorite The value which will be set
     */
    inline void setIsSmartFavorite (bool IsSmartFavorite_);

    static const T_SmartFavoritePreset &getDefaultInstance();

private:

    inline void set_has_PresetIndex ();

    inline void clear_has_PresetIndex ();

    inline void set_has_IsSmartFavorite ();

    inline void clear_has_IsSmartFavorite ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _PresetIndex;

    bool _IsSmartFavorite;

};

/**
 * If the meaning of "T_SFListElement" isn't clear, then there should be a description here.
 */
class T_SFListElement {
public:

    /**
     * Default constructor
     */
    inline  T_SFListElement ();

    /**
     * Copy constructor
     */
    inline  T_SFListElement (const T_SFListElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_SFListElement (uint8 PresetIndex_, bool IsRepeated_);

    /**
     * Destructor
     */
    inline  ~T_SFListElement();

    /**
     * Assignment operator
     */
    inline T_SFListElement& operator = (const T_SFListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SFListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SFListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SFListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SFListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PresetIndex"

    static const int kPresetIndex = 0;

    /**
     * Clears the field "PresetIndex".
     *
     * The field will be set to its default value. The hasPresetIndex()
     * method will return false.
     */
    inline void clearPresetIndex();

    /**
     * Checks whether the field "PresetIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetIndex()). Otherwise it will return false.
     */
    inline bool hasPresetIndex () const;

    /**
     * Returns the value of the member "PresetIndex".
     *
     * Preset index value
     *
     * @return The value of the field "PresetIndex"
     */
    inline uint8 getPresetIndex () const;

    /**
     * Sets the value of the member "PresetIndex".
     *
     * Preset index value
     *
     * @param PresetIndex The value which will be set
     */
    inline void setPresetIndex (uint8 PresetIndex_);

    // API of field "IsRepeated"

    static const int kIsRepeated = 1;

    /**
     * Clears the field "IsRepeated".
     *
     * The field will be set to its default value. The hasIsRepeated()
     * method will return false.
     */
    inline void clearIsRepeated();

    /**
     * Checks whether the field "IsRepeated" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsRepeated()). Otherwise it will return false.
     */
    inline bool hasIsRepeated () const;

    /**
     * Returns the value of the member "IsRepeated".
     *
     * Flag to indicate same channel is stored in other presets as well
     *
     * @return The value of the field "IsRepeated"
     */
    inline bool getIsRepeated () const;

    /**
     * Sets the value of the member "IsRepeated".
     *
     * Flag to indicate same channel is stored in other presets as well
     *
     * @param IsRepeated The value which will be set
     */
    inline void setIsRepeated (bool IsRepeated_);

    static const T_SFListElement &getDefaultInstance();

private:

    inline void set_has_PresetIndex ();

    inline void clear_has_PresetIndex ();

    inline void set_has_IsRepeated ();

    inline void clear_has_IsRepeated ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _PresetIndex;

    bool _IsRepeated;

};

/**
 * If the meaning of "T_InstantReplayStatus" isn't clear, then there should be a description here.
 */
class T_InstantReplayStatus {
public:

    /**
     * Default constructor
     */
    inline  T_InstantReplayStatus ();

    /**
     * Copy constructor
     */
    inline  T_InstantReplayStatus (const T_InstantReplayStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_InstantReplayStatus (uint32 RecordDuration_, uint32 TimeToLive_, uint8 PlayPercentage_, uint8 FillPercentage_, uint32 ElapsedTime_, T_e8_IRPlaybackStatus PlaybackStatus_);

    /**
     * Destructor
     */
    inline  ~T_InstantReplayStatus();

    /**
     * Assignment operator
     */
    inline T_InstantReplayStatus& operator = (const T_InstantReplayStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_InstantReplayStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_InstantReplayStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_InstantReplayStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_InstantReplayStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RecordDuration"

    static const int kRecordDuration = 0;

    /**
     * Clears the field "RecordDuration".
     *
     * The field will be set to its default value. The hasRecordDuration()
     * method will return false.
     */
    inline void clearRecordDuration();

    /**
     * Checks whether the field "RecordDuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecordDuration()). Otherwise it will return false.
     */
    inline bool hasRecordDuration () const;

    /**
     * Returns the value of the member "RecordDuration".
     *
     * Buffer recorded duration. Range: 0 to 3600
     *
     * @return The value of the field "RecordDuration"
     */
    inline uint32 getRecordDuration () const;

    /**
     * Sets the value of the member "RecordDuration".
     *
     * Buffer recorded duration. Range: 0 to 3600
     *
     * @param RecordDuration The value which will be set
     */
    inline void setRecordDuration (uint32 RecordDuration_);

    // API of field "TimeToLive"

    static const int kTimeToLive = 1;

    /**
     * Clears the field "TimeToLive".
     *
     * The field will be set to its default value. The hasTimeToLive()
     * method will return false.
     */
    inline void clearTimeToLive();

    /**
     * Checks whether the field "TimeToLive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeToLive()). Otherwise it will return false.
     */
    inline bool hasTimeToLive () const;

    /**
     * Returns the value of the member "TimeToLive".
     *
     * Time to LIVE data. Range: 0 to 3600
     *
     * @return The value of the field "TimeToLive"
     */
    inline uint32 getTimeToLive () const;

    /**
     * Sets the value of the member "TimeToLive".
     *
     * Time to LIVE data. Range: 0 to 3600
     *
     * @param TimeToLive The value which will be set
     */
    inline void setTimeToLive (uint32 TimeToLive_);

    // API of field "PlayPercentage"

    static const int kPlayPercentage = 2;

    /**
     * Clears the field "PlayPercentage".
     *
     * The field will be set to its default value. The hasPlayPercentage()
     * method will return false.
     */
    inline void clearPlayPercentage();

    /**
     * Checks whether the field "PlayPercentage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPlayPercentage()). Otherwise it will return false.
     */
    inline bool hasPlayPercentage () const;

    /**
     * Returns the value of the member "PlayPercentage".
     *
     * Percentage of buffer at which the current play point is present
     *
     * @return The value of the field "PlayPercentage"
     */
    inline uint8 getPlayPercentage () const;

    /**
     * Sets the value of the member "PlayPercentage".
     *
     * Percentage of buffer at which the current play point is present
     *
     * @param PlayPercentage The value which will be set
     */
    inline void setPlayPercentage (uint8 PlayPercentage_);

    // API of field "FillPercentage"

    static const int kFillPercentage = 3;

    /**
     * Clears the field "FillPercentage".
     *
     * The field will be set to its default value. The hasFillPercentage()
     * method will return false.
     */
    inline void clearFillPercentage();

    /**
     * Checks whether the field "FillPercentage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFillPercentage()). Otherwise it will return false.
     */
    inline bool hasFillPercentage () const;

    /**
     * Returns the value of the member "FillPercentage".
     *
     * Percentage of buffer that currently contains stored data
     *
     * @return The value of the field "FillPercentage"
     */
    inline uint8 getFillPercentage () const;

    /**
     * Sets the value of the member "FillPercentage".
     *
     * Percentage of buffer that currently contains stored data
     *
     * @param FillPercentage The value which will be set
     */
    inline void setFillPercentage (uint8 FillPercentage_);

    // API of field "ElapsedTime"

    static const int kElapsedTime = 4;

    /**
     * Clears the field "ElapsedTime".
     *
     * The field will be set to its default value. The hasElapsedTime()
     * method will return false.
     */
    inline void clearElapsedTime();

    /**
     * Checks whether the field "ElapsedTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElapsedTime()). Otherwise it will return false.
     */
    inline bool hasElapsedTime () const;

    /**
     * Returns the value of the member "ElapsedTime".
     *
     * Elapsed time in recorded buffer
     *
     * @return The value of the field "ElapsedTime"
     */
    inline uint32 getElapsedTime () const;

    /**
     * Sets the value of the member "ElapsedTime".
     *
     * Elapsed time in recorded buffer
     *
     * @param ElapsedTime The value which will be set
     */
    inline void setElapsedTime (uint32 ElapsedTime_);

    // API of field "PlaybackStatus"

    static const int kPlaybackStatus = 5;

    /**
     * Clears the field "PlaybackStatus".
     *
     * The field will be set to its default value. The hasPlaybackStatus()
     * method will return false.
     */
    inline void clearPlaybackStatus();

    /**
     * Checks whether the field "PlaybackStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPlaybackStatus()). Otherwise it will return false.
     */
    inline bool hasPlaybackStatus () const;

    /**
     * Returns the value of the member "PlaybackStatus".
     *
     * Current playback status for play pause toggle button
     *
     * @return The value of the field "PlaybackStatus"
     */
    inline T_e8_IRPlaybackStatus getPlaybackStatus () const;

    /**
     * Sets the value of the member "PlaybackStatus".
     *
     * Current playback status for play pause toggle button
     *
     * @param PlaybackStatus The value which will be set
     */
    inline void setPlaybackStatus (T_e8_IRPlaybackStatus PlaybackStatus_);

    static const T_InstantReplayStatus &getDefaultInstance();

private:

    inline void set_has_RecordDuration ();

    inline void clear_has_RecordDuration ();

    inline void set_has_TimeToLive ();

    inline void clear_has_TimeToLive ();

    inline void set_has_PlayPercentage ();

    inline void clear_has_PlayPercentage ();

    inline void set_has_FillPercentage ();

    inline void clear_has_FillPercentage ();

    inline void set_has_ElapsedTime ();

    inline void clear_has_ElapsedTime ();

    inline void set_has_PlaybackStatus ();

    inline void clear_has_PlaybackStatus ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint32 _RecordDuration;

    uint32 _TimeToLive;

    uint8 _PlayPercentage;

    uint8 _FillPercentage;

    uint32 _ElapsedTime;

    T_e8_IRPlaybackStatus _PlaybackStatus;

};

/**
 * Contains info related to registered favorite
 */
class T_RegisteredFavorite {
public:

    /**
     * Default constructor
     */
    inline  T_RegisteredFavorite ();

    /**
     * Copy constructor
     */
    inline  T_RegisteredFavorite (const T_RegisteredFavorite &rhs);

    /**
     * All fields constructor
     */
    inline  T_RegisteredFavorite (const ::std::string& ContentName_, bool IsEnabled_);

    /**
     * Destructor
     */
    inline  ~T_RegisteredFavorite();

    /**
     * Assignment operator
     */
    inline T_RegisteredFavorite& operator = (const T_RegisteredFavorite& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_RegisteredFavorite& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_RegisteredFavorite& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_RegisteredFavorite& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_RegisteredFavorite& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ContentName"

    static const int kContentName = 0;

    /**
     * Clears the field "ContentName".
     *
     * The field will be set to its default value. The hasContentName()
     * method will return false.
     */
    inline void clearContentName();

    /**
     * Checks whether the field "ContentName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContentName()). Otherwise it will return false.
     */
    inline bool hasContentName () const;

    /**
     * Returns the value of the member "ContentName".
     *
     * Name of registered content either artist or song name
     *
     * @return The value of the field "ContentName"
     */
    inline const ::std::string& getContentName () const;

    /**
     * Retrieves the value of the field "ContentName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ContentName".
     */
    inline ::std::string& getContentNameMutable ();

    /**
     * Sets the value of the member "ContentName".
     *
     * Name of registered content either artist or song name
     *
     * @param ContentName The value which will be set
     */
    inline void setContentName (const ::std::string& ContentName_);

    /**
     * Sets the value of the member "ContentName".
     *
     * Name of registered content either artist or song name
     *
     * @param ContentName The value which will be set
     */
    inline void setContentName (const char* ContentName_);

    /**
     * Sets the value of the member "ContentName".
     *
     * Name of registered content either artist or song name
     *
     * @param ContentName The value which will be set
     */
    inline void setContentName (const char* value, size_t size);

    // API of field "IsEnabled"

    static const int kIsEnabled = 1;

    /**
     * Clears the field "IsEnabled".
     *
     * The field will be set to its default value. The hasIsEnabled()
     * method will return false.
     */
    inline void clearIsEnabled();

    /**
     * Checks whether the field "IsEnabled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsEnabled()). Otherwise it will return false.
     */
    inline bool hasIsEnabled () const;

    /**
     * Returns the value of the member "IsEnabled".
     *
     * TRUE means registered content is ENABLED else DISABLED
     *
     * @return The value of the field "IsEnabled"
     */
    inline bool getIsEnabled () const;

    /**
     * Sets the value of the member "IsEnabled".
     *
     * TRUE means registered content is ENABLED else DISABLED
     *
     * @param IsEnabled The value which will be set
     */
    inline void setIsEnabled (bool IsEnabled_);

    static const T_RegisteredFavorite &getDefaultInstance();

private:

    inline void set_has_ContentName ();

    inline void clear_has_ContentName ();

    inline void set_has_IsEnabled ();

    inline void clear_has_IsEnabled ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _ContentName;

    bool _IsEnabled;

};

/**
 * Channel status event mask
 */
class T_b8_ChannelStatus {
public:

    /**
     * Default constructor
     */
    inline  T_b8_ChannelStatus ();

    /**
     * Copy constructor
     */
    inline  T_b8_ChannelStatus (const T_b8_ChannelStatus &c);

    /**
     * Field constructor
     */
    inline  T_b8_ChannelStatus (bool CHANNEL_STATUS_MATURED, bool CHANNEL_STATUS_LOCKED, bool CHANNEL_STATUS_SKIPPED, bool CHANNEL_STATUS_TUNABLE, bool CHANNEL_STATUS_B4_RFU, bool CHANNEL_STATUS_B5_RFU, bool CHANNEL_STATUS_B6_RFU, bool CHANNEL_STATUS_B7_RFU);

    /**
     * Assignment operator
     */
    inline T_b8_ChannelStatus& operator = (const T_b8_ChannelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_ChannelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_ChannelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_ChannelStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_ChannelStatus& rhs) const;

    /**
     * Sets the value of the member "CHANNEL_STATUS_MATURED".
     *
     * If the meaning of "CHANNEL_STATUS_MATURED" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_STATUS_MATURED The value which will be set
     */
    inline void setCHANNEL_STATUS_MATURED (bool CHANNEL_STATUS_MATURED);

    /**
     * Returns the value of the member "CHANNEL_STATUS_MATURED".
     *
     * If the meaning of "CHANNEL_STATUS_MATURED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_STATUS_MATURED"
     */
    inline bool getCHANNEL_STATUS_MATURED () const;

    /**
     * Sets the value of the member "CHANNEL_STATUS_LOCKED".
     *
     * If the meaning of "CHANNEL_STATUS_LOCKED" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_STATUS_LOCKED The value which will be set
     */
    inline void setCHANNEL_STATUS_LOCKED (bool CHANNEL_STATUS_LOCKED);

    /**
     * Returns the value of the member "CHANNEL_STATUS_LOCKED".
     *
     * If the meaning of "CHANNEL_STATUS_LOCKED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_STATUS_LOCKED"
     */
    inline bool getCHANNEL_STATUS_LOCKED () const;

    /**
     * Sets the value of the member "CHANNEL_STATUS_SKIPPED".
     *
     * If the meaning of "CHANNEL_STATUS_SKIPPED" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_STATUS_SKIPPED The value which will be set
     */
    inline void setCHANNEL_STATUS_SKIPPED (bool CHANNEL_STATUS_SKIPPED);

    /**
     * Returns the value of the member "CHANNEL_STATUS_SKIPPED".
     *
     * If the meaning of "CHANNEL_STATUS_SKIPPED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_STATUS_SKIPPED"
     */
    inline bool getCHANNEL_STATUS_SKIPPED () const;

    /**
     * Sets the value of the member "CHANNEL_STATUS_TUNABLE".
     *
     * If the meaning of "CHANNEL_STATUS_TUNABLE" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_STATUS_TUNABLE The value which will be set
     */
    inline void setCHANNEL_STATUS_TUNABLE (bool CHANNEL_STATUS_TUNABLE);

    /**
     * Returns the value of the member "CHANNEL_STATUS_TUNABLE".
     *
     * If the meaning of "CHANNEL_STATUS_TUNABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_STATUS_TUNABLE"
     */
    inline bool getCHANNEL_STATUS_TUNABLE () const;

    /**
     * Sets the value of the member "CHANNEL_STATUS_B4_RFU".
     *
     * If the meaning of "CHANNEL_STATUS_B4_RFU" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_STATUS_B4_RFU The value which will be set
     */
    inline void setCHANNEL_STATUS_B4_RFU (bool CHANNEL_STATUS_B4_RFU);

    /**
     * Returns the value of the member "CHANNEL_STATUS_B4_RFU".
     *
     * If the meaning of "CHANNEL_STATUS_B4_RFU" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_STATUS_B4_RFU"
     */
    inline bool getCHANNEL_STATUS_B4_RFU () const;

    /**
     * Sets the value of the member "CHANNEL_STATUS_B5_RFU".
     *
     * If the meaning of "CHANNEL_STATUS_B5_RFU" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_STATUS_B5_RFU The value which will be set
     */
    inline void setCHANNEL_STATUS_B5_RFU (bool CHANNEL_STATUS_B5_RFU);

    /**
     * Returns the value of the member "CHANNEL_STATUS_B5_RFU".
     *
     * If the meaning of "CHANNEL_STATUS_B5_RFU" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_STATUS_B5_RFU"
     */
    inline bool getCHANNEL_STATUS_B5_RFU () const;

    /**
     * Sets the value of the member "CHANNEL_STATUS_B6_RFU".
     *
     * If the meaning of "CHANNEL_STATUS_B6_RFU" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_STATUS_B6_RFU The value which will be set
     */
    inline void setCHANNEL_STATUS_B6_RFU (bool CHANNEL_STATUS_B6_RFU);

    /**
     * Returns the value of the member "CHANNEL_STATUS_B6_RFU".
     *
     * If the meaning of "CHANNEL_STATUS_B6_RFU" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_STATUS_B6_RFU"
     */
    inline bool getCHANNEL_STATUS_B6_RFU () const;

    /**
     * Sets the value of the member "CHANNEL_STATUS_B7_RFU".
     *
     * If the meaning of "CHANNEL_STATUS_B7_RFU" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_STATUS_B7_RFU The value which will be set
     */
    inline void setCHANNEL_STATUS_B7_RFU (bool CHANNEL_STATUS_B7_RFU);

    /**
     * Returns the value of the member "CHANNEL_STATUS_B7_RFU".
     *
     * If the meaning of "CHANNEL_STATUS_B7_RFU" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_STATUS_B7_RFU"
     */
    inline bool getCHANNEL_STATUS_B7_RFU () const;

    static const T_b8_ChannelStatus &getDefaultInstance();

private:

    bool _CHANNEL_STATUS_MATURED:1;

    bool _CHANNEL_STATUS_LOCKED:1;

    bool _CHANNEL_STATUS_SKIPPED:1;

    bool _CHANNEL_STATUS_TUNABLE:1;

    bool _CHANNEL_STATUS_B4_RFU:1;

    bool _CHANNEL_STATUS_B5_RFU:1;

    bool _CHANNEL_STATUS_B6_RFU:1;

    bool _CHANNEL_STATUS_B7_RFU:1;

};

/**
 * Contains alert information of artist or song
 */
class T_AlertInfo {
public:

    /**
     * Default constructor
     */
    inline  T_AlertInfo ();

    /**
     * Copy constructor
     */
    inline  T_AlertInfo (const T_AlertInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_AlertInfo (uint16 ServiceID_, uint16 ChannelID_, T_e8_FavoriteType FavoriteType_, const ::std::string& ChannelName_, const ::std::string& ArtistName_, const ::std::string& SongName_, T_e8_Graphics ChnGraphicsAvailable_, const T_b8_ChannelStatus& ChannelStatus_, bool IsExpired_);

    /**
     * Destructor
     */
    inline  ~T_AlertInfo();

    /**
     * Assignment operator
     */
    inline T_AlertInfo& operator = (const T_AlertInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AlertInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AlertInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AlertInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AlertInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceID"

    static const int kServiceID = 0;

    /**
     * Clears the field "ServiceID".
     *
     * The field will be set to its default value. The hasServiceID()
     * method will return false.
     */
    inline void clearServiceID();

    /**
     * Checks whether the field "ServiceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceID()). Otherwise it will return false.
     */
    inline bool hasServiceID () const;

    /**
     * Returns the value of the member "ServiceID".
     *
     * Service ID
     *
     * @return The value of the field "ServiceID"
     */
    inline uint16 getServiceID () const;

    /**
     * Sets the value of the member "ServiceID".
     *
     * Service ID
     *
     * @param ServiceID The value which will be set
     */
    inline void setServiceID (uint16 ServiceID_);

    // API of field "ChannelID"

    static const int kChannelID = 1;

    /**
     * Clears the field "ChannelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "ChannelID".
     *
     * Channel ID
     *
     * @return The value of the field "ChannelID"
     */
    inline uint16 getChannelID () const;

    /**
     * Sets the value of the member "ChannelID".
     *
     * Channel ID
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (uint16 ChannelID_);

    // API of field "FavoriteType"

    static const int kFavoriteType = 2;

    /**
     * Clears the field "FavoriteType".
     *
     * The field will be set to its default value. The hasFavoriteType()
     * method will return false.
     */
    inline void clearFavoriteType();

    /**
     * Checks whether the field "FavoriteType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteType()). Otherwise it will return false.
     */
    inline bool hasFavoriteType () const;

    /**
     * Returns the value of the member "FavoriteType".
     *
     * Specifies favorite type for alert
     *
     * @return The value of the field "FavoriteType"
     */
    inline T_e8_FavoriteType getFavoriteType () const;

    /**
     * Sets the value of the member "FavoriteType".
     *
     * Specifies favorite type for alert
     *
     * @param FavoriteType The value which will be set
     */
    inline void setFavoriteType (T_e8_FavoriteType FavoriteType_);

    // API of field "ChannelName"

    static const int kChannelName = 3;

    /**
     * Clears the field "ChannelName".
     *
     * The field will be set to its default value. The hasChannelName()
     * method will return false.
     */
    inline void clearChannelName();

    /**
     * Checks whether the field "ChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelName()). Otherwise it will return false.
     */
    inline bool hasChannelName () const;

    /**
     * Returns the value of the member "ChannelName".
     *
     * Name of channel for alert
     *
     * @return The value of the field "ChannelName"
     */
    inline const ::std::string& getChannelName () const;

    /**
     * Retrieves the value of the field "ChannelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelName".
     */
    inline ::std::string& getChannelNameMutable ();

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of channel for alert
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const ::std::string& ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of channel for alert
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of channel for alert
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* value, size_t size);

    // API of field "ArtistName"

    static const int kArtistName = 4;

    /**
     * Clears the field "ArtistName".
     *
     * The field will be set to its default value. The hasArtistName()
     * method will return false.
     */
    inline void clearArtistName();

    /**
     * Checks whether the field "ArtistName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArtistName()). Otherwise it will return false.
     */
    inline bool hasArtistName () const;

    /**
     * Returns the value of the member "ArtistName".
     *
     * Name of artist from artist or song alert
     *
     * @return The value of the field "ArtistName"
     */
    inline const ::std::string& getArtistName () const;

    /**
     * Retrieves the value of the field "ArtistName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ArtistName".
     */
    inline ::std::string& getArtistNameMutable ();

    /**
     * Sets the value of the member "ArtistName".
     *
     * Name of artist from artist or song alert
     *
     * @param ArtistName The value which will be set
     */
    inline void setArtistName (const ::std::string& ArtistName_);

    /**
     * Sets the value of the member "ArtistName".
     *
     * Name of artist from artist or song alert
     *
     * @param ArtistName The value which will be set
     */
    inline void setArtistName (const char* ArtistName_);

    /**
     * Sets the value of the member "ArtistName".
     *
     * Name of artist from artist or song alert
     *
     * @param ArtistName The value which will be set
     */
    inline void setArtistName (const char* value, size_t size);

    // API of field "SongName"

    static const int kSongName = 5;

    /**
     * Clears the field "SongName".
     *
     * The field will be set to its default value. The hasSongName()
     * method will return false.
     */
    inline void clearSongName();

    /**
     * Checks whether the field "SongName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSongName()). Otherwise it will return false.
     */
    inline bool hasSongName () const;

    /**
     * Returns the value of the member "SongName".
     *
     * Name of song from artist or song alert
     *
     * @return The value of the field "SongName"
     */
    inline const ::std::string& getSongName () const;

    /**
     * Retrieves the value of the field "SongName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SongName".
     */
    inline ::std::string& getSongNameMutable ();

    /**
     * Sets the value of the member "SongName".
     *
     * Name of song from artist or song alert
     *
     * @param SongName The value which will be set
     */
    inline void setSongName (const ::std::string& SongName_);

    /**
     * Sets the value of the member "SongName".
     *
     * Name of song from artist or song alert
     *
     * @param SongName The value which will be set
     */
    inline void setSongName (const char* SongName_);

    /**
     * Sets the value of the member "SongName".
     *
     * Name of song from artist or song alert
     *
     * @param SongName The value which will be set
     */
    inline void setSongName (const char* value, size_t size);

    // API of field "ChnGraphicsAvailable"

    static const int kChnGraphicsAvailable = 6;

    /**
     * Clears the field "ChnGraphicsAvailable".
     *
     * The field will be set to its default value. The hasChnGraphicsAvailable()
     * method will return false.
     */
    inline void clearChnGraphicsAvailable();

    /**
     * Checks whether the field "ChnGraphicsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChnGraphicsAvailable()). Otherwise it will return false.
     */
    inline bool hasChnGraphicsAvailable () const;

    /**
     * Returns the value of the member "ChnGraphicsAvailable".
     *
     * Indicates the channel graphics availability
     *
     * @return The value of the field "ChnGraphicsAvailable"
     */
    inline T_e8_Graphics getChnGraphicsAvailable () const;

    /**
     * Sets the value of the member "ChnGraphicsAvailable".
     *
     * Indicates the channel graphics availability
     *
     * @param ChnGraphicsAvailable The value which will be set
     */
    inline void setChnGraphicsAvailable (T_e8_Graphics ChnGraphicsAvailable_);

    // API of field "ChannelStatus"

    static const int kChannelStatus = 7;

    /**
     * Clears the field "ChannelStatus".
     *
     * The field will be set to its default value. The hasChannelStatus()
     * method will return false.
     */
    inline void clearChannelStatus();

    /**
     * Checks whether the field "ChannelStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelStatus()). Otherwise it will return false.
     */
    inline bool hasChannelStatus () const;

    /**
     * Returns the value of the member "ChannelStatus".
     *
     * Channel status for matured, locked, skipped, tunable channel.
     *
     * @return The value of the field "ChannelStatus"
     */
    inline const T_b8_ChannelStatus& getChannelStatus () const;

    /**
     * Retrieves the value of the field "ChannelStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelStatus".
     */
    inline T_b8_ChannelStatus& getChannelStatusMutable ();

    /**
     * Sets the value of the member "ChannelStatus".
     *
     * Channel status for matured, locked, skipped, tunable channel.
     *
     * @param ChannelStatus The value which will be set
     */
    inline void setChannelStatus (const T_b8_ChannelStatus& ChannelStatus_);

    // API of field "IsExpired"

    static const int kIsExpired = 8;

    /**
     * Clears the field "IsExpired".
     *
     * The field will be set to its default value. The hasIsExpired()
     * method will return false.
     */
    inline void clearIsExpired();

    /**
     * Checks whether the field "IsExpired" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsExpired()). Otherwise it will return false.
     */
    inline bool hasIsExpired () const;

    /**
     * Returns the value of the member "IsExpired".
     *
     * Indicates wheather alert is expired or not. If it is TRUE means alert is expired else not
     *
     * @return The value of the field "IsExpired"
     */
    inline bool getIsExpired () const;

    /**
     * Sets the value of the member "IsExpired".
     *
     * Indicates wheather alert is expired or not. If it is TRUE means alert is expired else not
     *
     * @param IsExpired The value which will be set
     */
    inline void setIsExpired (bool IsExpired_);

    static const T_AlertInfo &getDefaultInstance();

private:

    inline void set_has_ServiceID ();

    inline void clear_has_ServiceID ();

    inline void set_has_ChannelID ();

    inline void clear_has_ChannelID ();

    inline void set_has_FavoriteType ();

    inline void clear_has_FavoriteType ();

    inline void set_has_ChannelName ();

    inline void clear_has_ChannelName ();

    inline void set_has_ArtistName ();

    inline void clear_has_ArtistName ();

    inline void set_has_SongName ();

    inline void clear_has_SongName ();

    inline void set_has_ChnGraphicsAvailable ();

    inline void clear_has_ChnGraphicsAvailable ();

    inline void set_has_ChannelStatus ();

    inline void clear_has_ChannelStatus ();

    inline void set_has_IsExpired ();

    inline void clear_has_IsExpired ();

    uint32 _has_bits_[ (9 + 31) / 32];

    uint16 _ServiceID;

    uint16 _ChannelID;

    T_e8_FavoriteType _FavoriteType;

    ::std::string _ChannelName;

    ::std::string _ArtistName;

    ::std::string _SongName;

    T_e8_Graphics _ChnGraphicsAvailable;

    T_b8_ChannelStatus _ChannelStatus;

    bool _IsExpired;

};

/**
 * If the meaning of "T_MarketListEntry" isn't clear, then there should be a description here.
 */
class T_MarketListEntry {
public:

    /**
     * Default constructor
     */
    inline  T_MarketListEntry ();

    /**
     * Copy constructor
     */
    inline  T_MarketListEntry (const T_MarketListEntry &rhs);

    /**
     * All fields constructor
     */
    inline  T_MarketListEntry (const ::std::string& AbbrMarketName_, const ::std::string& FullMarketName_, bool bIsActiveMarket_);

    /**
     * Destructor
     */
    inline  ~T_MarketListEntry();

    /**
     * Assignment operator
     */
    inline T_MarketListEntry& operator = (const T_MarketListEntry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MarketListEntry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MarketListEntry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MarketListEntry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MarketListEntry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AbbrMarketName"

    static const int kAbbrMarketName = 0;

    /**
     * Clears the field "AbbrMarketName".
     *
     * The field will be set to its default value. The hasAbbrMarketName()
     * method will return false.
     */
    inline void clearAbbrMarketName();

    /**
     * Checks whether the field "AbbrMarketName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAbbrMarketName()). Otherwise it will return false.
     */
    inline bool hasAbbrMarketName () const;

    /**
     * Returns the value of the member "AbbrMarketName".
     *
     * Abbreviated market name.
     *
     * @return The value of the field "AbbrMarketName"
     */
    inline const ::std::string& getAbbrMarketName () const;

    /**
     * Retrieves the value of the field "AbbrMarketName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AbbrMarketName".
     */
    inline ::std::string& getAbbrMarketNameMutable ();

    /**
     * Sets the value of the member "AbbrMarketName".
     *
     * Abbreviated market name.
     *
     * @param AbbrMarketName The value which will be set
     */
    inline void setAbbrMarketName (const ::std::string& AbbrMarketName_);

    /**
     * Sets the value of the member "AbbrMarketName".
     *
     * Abbreviated market name.
     *
     * @param AbbrMarketName The value which will be set
     */
    inline void setAbbrMarketName (const char* AbbrMarketName_);

    /**
     * Sets the value of the member "AbbrMarketName".
     *
     * Abbreviated market name.
     *
     * @param AbbrMarketName The value which will be set
     */
    inline void setAbbrMarketName (const char* value, size_t size);

    // API of field "FullMarketName"

    static const int kFullMarketName = 1;

    /**
     * Clears the field "FullMarketName".
     *
     * The field will be set to its default value. The hasFullMarketName()
     * method will return false.
     */
    inline void clearFullMarketName();

    /**
     * Checks whether the field "FullMarketName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFullMarketName()). Otherwise it will return false.
     */
    inline bool hasFullMarketName () const;

    /**
     * Returns the value of the member "FullMarketName".
     *
     * Full market name.
     *
     * @return The value of the field "FullMarketName"
     */
    inline const ::std::string& getFullMarketName () const;

    /**
     * Retrieves the value of the field "FullMarketName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FullMarketName".
     */
    inline ::std::string& getFullMarketNameMutable ();

    /**
     * Sets the value of the member "FullMarketName".
     *
     * Full market name.
     *
     * @param FullMarketName The value which will be set
     */
    inline void setFullMarketName (const ::std::string& FullMarketName_);

    /**
     * Sets the value of the member "FullMarketName".
     *
     * Full market name.
     *
     * @param FullMarketName The value which will be set
     */
    inline void setFullMarketName (const char* FullMarketName_);

    /**
     * Sets the value of the member "FullMarketName".
     *
     * Full market name.
     *
     * @param FullMarketName The value which will be set
     */
    inline void setFullMarketName (const char* value, size_t size);

    // API of field "bIsActiveMarket"

    static const int kBIsActiveMarket = 2;

    /**
     * Clears the field "bIsActiveMarket".
     *
     * The field will be set to its default value. The hasBIsActiveMarket()
     * method will return false.
     */
    inline void clearBIsActiveMarket();

    /**
     * Checks whether the field "bIsActiveMarket" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsActiveMarket()). Otherwise it will return false.
     */
    inline bool hasBIsActiveMarket () const;

    /**
     * Returns the value of the member "bIsActiveMarket".
     *
     * TRUE, if this city/region is set for TW NOW monitoring. FALSE, if not.
     *
     * @return The value of the field "bIsActiveMarket"
     */
    inline bool getBIsActiveMarket () const;

    /**
     * Sets the value of the member "bIsActiveMarket".
     *
     * TRUE, if this city/region is set for TW NOW monitoring. FALSE, if not.
     *
     * @param bIsActiveMarket The value which will be set
     */
    inline void setBIsActiveMarket (bool bIsActiveMarket_);

    static const T_MarketListEntry &getDefaultInstance();

private:

    inline void set_has_AbbrMarketName ();

    inline void clear_has_AbbrMarketName ();

    inline void set_has_FullMarketName ();

    inline void clear_has_FullMarketName ();

    inline void set_has_bIsActiveMarket ();

    inline void clear_has_bIsActiveMarket ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _AbbrMarketName;

    ::std::string _FullMarketName;

    bool _bIsActiveMarket;

};

/**
 * All information required to represent a Team.
 */
class T_SportsFlash_FavoriteTeam {
public:

    /**
     * Default constructor
     */
    inline  T_SportsFlash_FavoriteTeam ();

    /**
     * Copy constructor
     */
    inline  T_SportsFlash_FavoriteTeam (const T_SportsFlash_FavoriteTeam &rhs);

    /**
     * All fields constructor
     */
    inline  T_SportsFlash_FavoriteTeam (T_e8_SportsFlash_Sport SportType_, uint8 LeagueID_, T_e8_SportsFlash_League LeagueType_, const ::std::string& LeagueAbbrName_, const ::std::string& LeagueFullName_, uint16 TeamID_, const ::std::string& TeamName_, const ::std::string& TeamNickName_, const ::std::string& TeamAbbrName_, const ::std::string& TeamFullName_, bool IsFavorite_, bool IsMonitored_);

    /**
     * Destructor
     */
    inline  ~T_SportsFlash_FavoriteTeam();

    /**
     * Assignment operator
     */
    inline T_SportsFlash_FavoriteTeam& operator = (const T_SportsFlash_FavoriteTeam& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SportsFlash_FavoriteTeam& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SportsFlash_FavoriteTeam& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SportsFlash_FavoriteTeam& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SportsFlash_FavoriteTeam& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportType"

    static const int kSportType = 0;

    /**
     * Clears the field "SportType".
     *
     * The field will be set to its default value. The hasSportType()
     * method will return false.
     */
    inline void clearSportType();

    /**
     * Checks whether the field "SportType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportType()). Otherwise it will return false.
     */
    inline bool hasSportType () const;

    /**
     * Returns the value of the member "SportType".
     *
     * Type of sport.
     *
     * @return The value of the field "SportType"
     */
    inline T_e8_SportsFlash_Sport getSportType () const;

    /**
     * Sets the value of the member "SportType".
     *
     * Type of sport.
     *
     * @param SportType The value which will be set
     */
    inline void setSportType (T_e8_SportsFlash_Sport SportType_);

    // API of field "LeagueID"

    static const int kLeagueID = 1;

    /**
     * Clears the field "LeagueID".
     *
     * The field will be set to its default value. The hasLeagueID()
     * method will return false.
     */
    inline void clearLeagueID();

    /**
     * Checks whether the field "LeagueID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueID()). Otherwise it will return false.
     */
    inline bool hasLeagueID () const;

    /**
     * Returns the value of the member "LeagueID".
     *
     * League ID to which the team is affiliated.
     *
     * @return The value of the field "LeagueID"
     */
    inline uint8 getLeagueID () const;

    /**
     * Sets the value of the member "LeagueID".
     *
     * League ID to which the team is affiliated.
     *
     * @param LeagueID The value which will be set
     */
    inline void setLeagueID (uint8 LeagueID_);

    // API of field "LeagueType"

    static const int kLeagueType = 2;

    /**
     * Clears the field "LeagueType".
     *
     * The field will be set to its default value. The hasLeagueType()
     * method will return false.
     */
    inline void clearLeagueType();

    /**
     * Checks whether the field "LeagueType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueType()). Otherwise it will return false.
     */
    inline bool hasLeagueType () const;

    /**
     * Returns the value of the member "LeagueType".
     *
     * Type of league.
     *
     * @return The value of the field "LeagueType"
     */
    inline T_e8_SportsFlash_League getLeagueType () const;

    /**
     * Sets the value of the member "LeagueType".
     *
     * Type of league.
     *
     * @param LeagueType The value which will be set
     */
    inline void setLeagueType (T_e8_SportsFlash_League LeagueType_);

    // API of field "LeagueAbbrName"

    static const int kLeagueAbbrName = 3;

    /**
     * Clears the field "LeagueAbbrName".
     *
     * The field will be set to its default value. The hasLeagueAbbrName()
     * method will return false.
     */
    inline void clearLeagueAbbrName();

    /**
     * Checks whether the field "LeagueAbbrName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueAbbrName()). Otherwise it will return false.
     */
    inline bool hasLeagueAbbrName () const;

    /**
     * Returns the value of the member "LeagueAbbrName".
     *
     * Abbreviated league name.
     *
     * @return The value of the field "LeagueAbbrName"
     */
    inline const ::std::string& getLeagueAbbrName () const;

    /**
     * Retrieves the value of the field "LeagueAbbrName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LeagueAbbrName".
     */
    inline ::std::string& getLeagueAbbrNameMutable ();

    /**
     * Sets the value of the member "LeagueAbbrName".
     *
     * Abbreviated league name.
     *
     * @param LeagueAbbrName The value which will be set
     */
    inline void setLeagueAbbrName (const ::std::string& LeagueAbbrName_);

    /**
     * Sets the value of the member "LeagueAbbrName".
     *
     * Abbreviated league name.
     *
     * @param LeagueAbbrName The value which will be set
     */
    inline void setLeagueAbbrName (const char* LeagueAbbrName_);

    /**
     * Sets the value of the member "LeagueAbbrName".
     *
     * Abbreviated league name.
     *
     * @param LeagueAbbrName The value which will be set
     */
    inline void setLeagueAbbrName (const char* value, size_t size);

    // API of field "LeagueFullName"

    static const int kLeagueFullName = 4;

    /**
     * Clears the field "LeagueFullName".
     *
     * The field will be set to its default value. The hasLeagueFullName()
     * method will return false.
     */
    inline void clearLeagueFullName();

    /**
     * Checks whether the field "LeagueFullName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueFullName()). Otherwise it will return false.
     */
    inline bool hasLeagueFullName () const;

    /**
     * Returns the value of the member "LeagueFullName".
     *
     * Full league name.
     *
     * @return The value of the field "LeagueFullName"
     */
    inline const ::std::string& getLeagueFullName () const;

    /**
     * Retrieves the value of the field "LeagueFullName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LeagueFullName".
     */
    inline ::std::string& getLeagueFullNameMutable ();

    /**
     * Sets the value of the member "LeagueFullName".
     *
     * Full league name.
     *
     * @param LeagueFullName The value which will be set
     */
    inline void setLeagueFullName (const ::std::string& LeagueFullName_);

    /**
     * Sets the value of the member "LeagueFullName".
     *
     * Full league name.
     *
     * @param LeagueFullName The value which will be set
     */
    inline void setLeagueFullName (const char* LeagueFullName_);

    /**
     * Sets the value of the member "LeagueFullName".
     *
     * Full league name.
     *
     * @param LeagueFullName The value which will be set
     */
    inline void setLeagueFullName (const char* value, size_t size);

    // API of field "TeamID"

    static const int kTeamID = 5;

    /**
     * Clears the field "TeamID".
     *
     * The field will be set to its default value. The hasTeamID()
     * method will return false.
     */
    inline void clearTeamID();

    /**
     * Checks whether the field "TeamID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamID()). Otherwise it will return false.
     */
    inline bool hasTeamID () const;

    /**
     * Returns the value of the member "TeamID".
     *
     * Team's unique ID within the league.
     *
     * @return The value of the field "TeamID"
     */
    inline uint16 getTeamID () const;

    /**
     * Sets the value of the member "TeamID".
     *
     * Team's unique ID within the league.
     *
     * @param TeamID The value which will be set
     */
    inline void setTeamID (uint16 TeamID_);

    // API of field "TeamName"

    static const int kTeamName = 6;

    /**
     * Clears the field "TeamName".
     *
     * The field will be set to its default value. The hasTeamName()
     * method will return false.
     */
    inline void clearTeamName();

    /**
     * Checks whether the field "TeamName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamName()). Otherwise it will return false.
     */
    inline bool hasTeamName () const;

    /**
     * Returns the value of the member "TeamName".
     *
     * Team given Name.
     *
     * @return The value of the field "TeamName"
     */
    inline const ::std::string& getTeamName () const;

    /**
     * Retrieves the value of the field "TeamName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TeamName".
     */
    inline ::std::string& getTeamNameMutable ();

    /**
     * Sets the value of the member "TeamName".
     *
     * Team given Name.
     *
     * @param TeamName The value which will be set
     */
    inline void setTeamName (const ::std::string& TeamName_);

    /**
     * Sets the value of the member "TeamName".
     *
     * Team given Name.
     *
     * @param TeamName The value which will be set
     */
    inline void setTeamName (const char* TeamName_);

    /**
     * Sets the value of the member "TeamName".
     *
     * Team given Name.
     *
     * @param TeamName The value which will be set
     */
    inline void setTeamName (const char* value, size_t size);

    // API of field "TeamNickName"

    static const int kTeamNickName = 7;

    /**
     * Clears the field "TeamNickName".
     *
     * The field will be set to its default value. The hasTeamNickName()
     * method will return false.
     */
    inline void clearTeamNickName();

    /**
     * Checks whether the field "TeamNickName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamNickName()). Otherwise it will return false.
     */
    inline bool hasTeamNickName () const;

    /**
     * Returns the value of the member "TeamNickName".
     *
     * Team's Nick Name.
     *
     * @return The value of the field "TeamNickName"
     */
    inline const ::std::string& getTeamNickName () const;

    /**
     * Retrieves the value of the field "TeamNickName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TeamNickName".
     */
    inline ::std::string& getTeamNickNameMutable ();

    /**
     * Sets the value of the member "TeamNickName".
     *
     * Team's Nick Name.
     *
     * @param TeamNickName The value which will be set
     */
    inline void setTeamNickName (const ::std::string& TeamNickName_);

    /**
     * Sets the value of the member "TeamNickName".
     *
     * Team's Nick Name.
     *
     * @param TeamNickName The value which will be set
     */
    inline void setTeamNickName (const char* TeamNickName_);

    /**
     * Sets the value of the member "TeamNickName".
     *
     * Team's Nick Name.
     *
     * @param TeamNickName The value which will be set
     */
    inline void setTeamNickName (const char* value, size_t size);

    // API of field "TeamAbbrName"

    static const int kTeamAbbrName = 8;

    /**
     * Clears the field "TeamAbbrName".
     *
     * The field will be set to its default value. The hasTeamAbbrName()
     * method will return false.
     */
    inline void clearTeamAbbrName();

    /**
     * Checks whether the field "TeamAbbrName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamAbbrName()). Otherwise it will return false.
     */
    inline bool hasTeamAbbrName () const;

    /**
     * Returns the value of the member "TeamAbbrName".
     *
     * Team's Abbreviated Name.
     *
     * @return The value of the field "TeamAbbrName"
     */
    inline const ::std::string& getTeamAbbrName () const;

    /**
     * Retrieves the value of the field "TeamAbbrName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TeamAbbrName".
     */
    inline ::std::string& getTeamAbbrNameMutable ();

    /**
     * Sets the value of the member "TeamAbbrName".
     *
     * Team's Abbreviated Name.
     *
     * @param TeamAbbrName The value which will be set
     */
    inline void setTeamAbbrName (const ::std::string& TeamAbbrName_);

    /**
     * Sets the value of the member "TeamAbbrName".
     *
     * Team's Abbreviated Name.
     *
     * @param TeamAbbrName The value which will be set
     */
    inline void setTeamAbbrName (const char* TeamAbbrName_);

    /**
     * Sets the value of the member "TeamAbbrName".
     *
     * Team's Abbreviated Name.
     *
     * @param TeamAbbrName The value which will be set
     */
    inline void setTeamAbbrName (const char* value, size_t size);

    // API of field "TeamFullName"

    static const int kTeamFullName = 9;

    /**
     * Clears the field "TeamFullName".
     *
     * The field will be set to its default value. The hasTeamFullName()
     * method will return false.
     */
    inline void clearTeamFullName();

    /**
     * Checks whether the field "TeamFullName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamFullName()). Otherwise it will return false.
     */
    inline bool hasTeamFullName () const;

    /**
     * Returns the value of the member "TeamFullName".
     *
     * Team's Full Name.(TeamName + " " + TeamNickName)
     *
     * @return The value of the field "TeamFullName"
     */
    inline const ::std::string& getTeamFullName () const;

    /**
     * Retrieves the value of the field "TeamFullName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TeamFullName".
     */
    inline ::std::string& getTeamFullNameMutable ();

    /**
     * Sets the value of the member "TeamFullName".
     *
     * Team's Full Name.(TeamName + " " + TeamNickName)
     *
     * @param TeamFullName The value which will be set
     */
    inline void setTeamFullName (const ::std::string& TeamFullName_);

    /**
     * Sets the value of the member "TeamFullName".
     *
     * Team's Full Name.(TeamName + " " + TeamNickName)
     *
     * @param TeamFullName The value which will be set
     */
    inline void setTeamFullName (const char* TeamFullName_);

    /**
     * Sets the value of the member "TeamFullName".
     *
     * Team's Full Name.(TeamName + " " + TeamNickName)
     *
     * @param TeamFullName The value which will be set
     */
    inline void setTeamFullName (const char* value, size_t size);

    // API of field "IsFavorite"

    static const int kIsFavorite = 10;

    /**
     * Clears the field "IsFavorite".
     *
     * The field will be set to its default value. The hasIsFavorite()
     * method will return false.
     */
    inline void clearIsFavorite();

    /**
     * Checks whether the field "IsFavorite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsFavorite()). Otherwise it will return false.
     */
    inline bool hasIsFavorite () const;

    /**
     * Returns the value of the member "IsFavorite".
     *
     * TRUE if the team is set as a favorite, FALSE if not.
     *
     * @return The value of the field "IsFavorite"
     */
    inline bool getIsFavorite () const;

    /**
     * Sets the value of the member "IsFavorite".
     *
     * TRUE if the team is set as a favorite, FALSE if not.
     *
     * @param IsFavorite The value which will be set
     */
    inline void setIsFavorite (bool IsFavorite_);

    // API of field "IsMonitored"

    static const int kIsMonitored = 11;

    /**
     * Clears the field "IsMonitored".
     *
     * The field will be set to its default value. The hasIsMonitored()
     * method will return false.
     */
    inline void clearIsMonitored();

    /**
     * Checks whether the field "IsMonitored" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMonitored()). Otherwise it will return false.
     */
    inline bool hasIsMonitored () const;

    /**
     * Returns the value of the member "IsMonitored".
     *
     * TRUE if the team could be monitored for Sports Flash notifications, FALSE if not.
     *
     * @return The value of the field "IsMonitored"
     */
    inline bool getIsMonitored () const;

    /**
     * Sets the value of the member "IsMonitored".
     *
     * TRUE if the team could be monitored for Sports Flash notifications, FALSE if not.
     *
     * @param IsMonitored The value which will be set
     */
    inline void setIsMonitored (bool IsMonitored_);

    static const T_SportsFlash_FavoriteTeam &getDefaultInstance();

private:

    inline void set_has_SportType ();

    inline void clear_has_SportType ();

    inline void set_has_LeagueID ();

    inline void clear_has_LeagueID ();

    inline void set_has_LeagueType ();

    inline void clear_has_LeagueType ();

    inline void set_has_LeagueAbbrName ();

    inline void clear_has_LeagueAbbrName ();

    inline void set_has_LeagueFullName ();

    inline void clear_has_LeagueFullName ();

    inline void set_has_TeamID ();

    inline void clear_has_TeamID ();

    inline void set_has_TeamName ();

    inline void clear_has_TeamName ();

    inline void set_has_TeamNickName ();

    inline void clear_has_TeamNickName ();

    inline void set_has_TeamAbbrName ();

    inline void clear_has_TeamAbbrName ();

    inline void set_has_TeamFullName ();

    inline void clear_has_TeamFullName ();

    inline void set_has_IsFavorite ();

    inline void clear_has_IsFavorite ();

    inline void set_has_IsMonitored ();

    inline void clear_has_IsMonitored ();

    uint32 _has_bits_[ (12 + 31) / 32];

    T_e8_SportsFlash_Sport _SportType;

    uint8 _LeagueID;

    T_e8_SportsFlash_League _LeagueType;

    ::std::string _LeagueAbbrName;

    ::std::string _LeagueFullName;

    uint16 _TeamID;

    ::std::string _TeamName;

    ::std::string _TeamNickName;

    ::std::string _TeamAbbrName;

    ::std::string _TeamFullName;

    bool _IsFavorite;

    bool _IsMonitored;

};

/**
 * All information required to represent an ongoing game.
 */
class T_SportsFlash_Game {
public:

    /**
     * Default constructor
     */
    inline  T_SportsFlash_Game ();

    /**
     * Copy constructor
     */
    inline  T_SportsFlash_Game (const T_SportsFlash_Game &rhs);

    /**
     * All fields constructor
     */
    inline  T_SportsFlash_Game (uint16 ChannelID_, uint16 ServiceID_, bool IsLocked_, bool IsMature_, bool IsSkipped_, uint16 Bias_, const T_SportsFlash_FavoriteTeam& HomeTeam_, const T_SportsFlash_FavoriteTeam& AwayTeam_, T_e8_Graphics ChnGraphicsAvailable_);

    /**
     * Destructor
     */
    inline  ~T_SportsFlash_Game();

    /**
     * Assignment operator
     */
    inline T_SportsFlash_Game& operator = (const T_SportsFlash_Game& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SportsFlash_Game& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SportsFlash_Game& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SportsFlash_Game& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SportsFlash_Game& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelID"

    static const int kChannelID = 0;

    /**
     * Clears the field "ChannelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "ChannelID".
     *
     * Channel ID of the channel playing the game.
     *
     * @return The value of the field "ChannelID"
     */
    inline uint16 getChannelID () const;

    /**
     * Sets the value of the member "ChannelID".
     *
     * Channel ID of the channel playing the game.
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (uint16 ChannelID_);

    // API of field "ServiceID"

    static const int kServiceID = 1;

    /**
     * Clears the field "ServiceID".
     *
     * The field will be set to its default value. The hasServiceID()
     * method will return false.
     */
    inline void clearServiceID();

    /**
     * Checks whether the field "ServiceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceID()). Otherwise it will return false.
     */
    inline bool hasServiceID () const;

    /**
     * Returns the value of the member "ServiceID".
     *
     * Service ID
     *
     * @return The value of the field "ServiceID"
     */
    inline uint16 getServiceID () const;

    /**
     * Sets the value of the member "ServiceID".
     *
     * Service ID
     *
     * @param ServiceID The value which will be set
     */
    inline void setServiceID (uint16 ServiceID_);

    // API of field "IsLocked"

    static const int kIsLocked = 2;

    /**
     * Clears the field "IsLocked".
     *
     * The field will be set to its default value. The hasIsLocked()
     * method will return false.
     */
    inline void clearIsLocked();

    /**
     * Checks whether the field "IsLocked" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsLocked()). Otherwise it will return false.
     */
    inline bool hasIsLocked () const;

    /**
     * Returns the value of the member "IsLocked".
     *
     * TRUE if the channel is locked by the user; FALSE if not locked.
     *
     * @return The value of the field "IsLocked"
     */
    inline bool getIsLocked () const;

    /**
     * Sets the value of the member "IsLocked".
     *
     * TRUE if the channel is locked by the user; FALSE if not locked.
     *
     * @param IsLocked The value which will be set
     */
    inline void setIsLocked (bool IsLocked_);

    // API of field "IsMature"

    static const int kIsMature = 3;

    /**
     * Clears the field "IsMature".
     *
     * The field will be set to its default value. The hasIsMature()
     * method will return false.
     */
    inline void clearIsMature();

    /**
     * Checks whether the field "IsMature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMature()). Otherwise it will return false.
     */
    inline bool hasIsMature () const;

    /**
     * Returns the value of the member "IsMature".
     *
     * TRUE if the channel is identified to be broadcasting mature content; FALSE otherwise.
     *
     * @return The value of the field "IsMature"
     */
    inline bool getIsMature () const;

    /**
     * Sets the value of the member "IsMature".
     *
     * TRUE if the channel is identified to be broadcasting mature content; FALSE otherwise.
     *
     * @param IsMature The value which will be set
     */
    inline void setIsMature (bool IsMature_);

    // API of field "IsSkipped"

    static const int kIsSkipped = 4;

    /**
     * Clears the field "IsSkipped".
     *
     * The field will be set to its default value. The hasIsSkipped()
     * method will return false.
     */
    inline void clearIsSkipped();

    /**
     * Checks whether the field "IsSkipped" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsSkipped()). Otherwise it will return false.
     */
    inline bool hasIsSkipped () const;

    /**
     * Returns the value of the member "IsSkipped".
     *
     * TRUE if user has set the channel to be skipped from browsing; FALSE otherwise.
     *
     * @return The value of the field "IsSkipped"
     */
    inline bool getIsSkipped () const;

    /**
     * Sets the value of the member "IsSkipped".
     *
     * TRUE if user has set the channel to be skipped from browsing; FALSE otherwise.
     *
     * @param IsSkipped The value which will be set
     */
    inline void setIsSkipped (bool IsSkipped_);

    // API of field "Bias"

    static const int kBias = 5;

    /**
     * Clears the field "Bias".
     *
     * The field will be set to its default value. The hasBias()
     * method will return false.
     */
    inline void clearBias();

    /**
     * Checks whether the field "Bias" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBias()). Otherwise it will return false.
     */
    inline bool hasBias () const;

    /**
     * Returns the value of the member "Bias".
     *
     * BIAS value used to filter the games according to priority set by user.
     *
     * @return The value of the field "Bias"
     */
    inline uint16 getBias () const;

    /**
     * Sets the value of the member "Bias".
     *
     * BIAS value used to filter the games according to priority set by user.
     *
     * @param Bias The value which will be set
     */
    inline void setBias (uint16 Bias_);

    // API of field "HomeTeam"

    static const int kHomeTeam = 6;

    /**
     * Clears the field "HomeTeam".
     *
     * The field will be set to its default value. The hasHomeTeam()
     * method will return false.
     */
    inline void clearHomeTeam();

    /**
     * Checks whether the field "HomeTeam" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHomeTeam()). Otherwise it will return false.
     */
    inline bool hasHomeTeam () const;

    /**
     * Returns the value of the member "HomeTeam".
     *
     * Home team information.
     *
     * @return The value of the field "HomeTeam"
     */
    inline const T_SportsFlash_FavoriteTeam& getHomeTeam () const;

    /**
     * Retrieves the value of the field "HomeTeam" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "HomeTeam".
     */
    inline T_SportsFlash_FavoriteTeam& getHomeTeamMutable ();

    /**
     * Sets the value of the member "HomeTeam".
     *
     * Home team information.
     *
     * @param HomeTeam The value which will be set
     */
    inline void setHomeTeam (const T_SportsFlash_FavoriteTeam& HomeTeam_);

    // API of field "AwayTeam"

    static const int kAwayTeam = 7;

    /**
     * Clears the field "AwayTeam".
     *
     * The field will be set to its default value. The hasAwayTeam()
     * method will return false.
     */
    inline void clearAwayTeam();

    /**
     * Checks whether the field "AwayTeam" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAwayTeam()). Otherwise it will return false.
     */
    inline bool hasAwayTeam () const;

    /**
     * Returns the value of the member "AwayTeam".
     *
     * Away team information.
     *
     * @return The value of the field "AwayTeam"
     */
    inline const T_SportsFlash_FavoriteTeam& getAwayTeam () const;

    /**
     * Retrieves the value of the field "AwayTeam" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AwayTeam".
     */
    inline T_SportsFlash_FavoriteTeam& getAwayTeamMutable ();

    /**
     * Sets the value of the member "AwayTeam".
     *
     * Away team information.
     *
     * @param AwayTeam The value which will be set
     */
    inline void setAwayTeam (const T_SportsFlash_FavoriteTeam& AwayTeam_);

    // API of field "ChnGraphicsAvailable"

    static const int kChnGraphicsAvailable = 8;

    /**
     * Clears the field "ChnGraphicsAvailable".
     *
     * The field will be set to its default value. The hasChnGraphicsAvailable()
     * method will return false.
     */
    inline void clearChnGraphicsAvailable();

    /**
     * Checks whether the field "ChnGraphicsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChnGraphicsAvailable()). Otherwise it will return false.
     */
    inline bool hasChnGraphicsAvailable () const;

    /**
     * Returns the value of the member "ChnGraphicsAvailable".
     *
     * Indicates the channel graphics availability
     *
     * @return The value of the field "ChnGraphicsAvailable"
     */
    inline T_e8_Graphics getChnGraphicsAvailable () const;

    /**
     * Sets the value of the member "ChnGraphicsAvailable".
     *
     * Indicates the channel graphics availability
     *
     * @param ChnGraphicsAvailable The value which will be set
     */
    inline void setChnGraphicsAvailable (T_e8_Graphics ChnGraphicsAvailable_);

    static const T_SportsFlash_Game &getDefaultInstance();

private:

    inline void set_has_ChannelID ();

    inline void clear_has_ChannelID ();

    inline void set_has_ServiceID ();

    inline void clear_has_ServiceID ();

    inline void set_has_IsLocked ();

    inline void clear_has_IsLocked ();

    inline void set_has_IsMature ();

    inline void clear_has_IsMature ();

    inline void set_has_IsSkipped ();

    inline void clear_has_IsSkipped ();

    inline void set_has_Bias ();

    inline void clear_has_Bias ();

    inline void set_has_HomeTeam ();

    inline void clear_has_HomeTeam ();

    inline void set_has_AwayTeam ();

    inline void clear_has_AwayTeam ();

    inline void set_has_ChnGraphicsAvailable ();

    inline void clear_has_ChnGraphicsAvailable ();

    uint32 _has_bits_[ (9 + 31) / 32];

    uint16 _ChannelID;

    uint16 _ServiceID;

    bool _IsLocked;

    bool _IsMature;

    bool _IsSkipped;

    uint16 _Bias;

    T_SportsFlash_FavoriteTeam _HomeTeam;

    T_SportsFlash_FavoriteTeam _AwayTeam;

    T_e8_Graphics _ChnGraphicsAvailable;

};

/**
 * Detailed Information for an active flash event.
 */
class T_SportsFlash_FlashEvent {
public:

    /**
     * Default constructor
     */
    inline  T_SportsFlash_FlashEvent ();

    /**
     * Copy constructor
     */
    inline  T_SportsFlash_FlashEvent (const T_SportsFlash_FlashEvent &rhs);

    /**
     * All fields constructor
     */
    inline  T_SportsFlash_FlashEvent (const T_SportsFlash_Game& GameInfo_, uint32 FlashEventID_);

    /**
     * Destructor
     */
    inline  ~T_SportsFlash_FlashEvent();

    /**
     * Assignment operator
     */
    inline T_SportsFlash_FlashEvent& operator = (const T_SportsFlash_FlashEvent& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SportsFlash_FlashEvent& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SportsFlash_FlashEvent& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SportsFlash_FlashEvent& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SportsFlash_FlashEvent& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GameInfo"

    static const int kGameInfo = 0;

    /**
     * Clears the field "GameInfo".
     *
     * The field will be set to its default value. The hasGameInfo()
     * method will return false.
     */
    inline void clearGameInfo();

    /**
     * Checks whether the field "GameInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGameInfo()). Otherwise it will return false.
     */
    inline bool hasGameInfo () const;

    /**
     * Returns the value of the member "GameInfo".
     *
     * Channel ID of the channel playing the game.
     *
     * @return The value of the field "GameInfo"
     */
    inline const T_SportsFlash_Game& getGameInfo () const;

    /**
     * Retrieves the value of the field "GameInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GameInfo".
     */
    inline T_SportsFlash_Game& getGameInfoMutable ();

    /**
     * Sets the value of the member "GameInfo".
     *
     * Channel ID of the channel playing the game.
     *
     * @param GameInfo The value which will be set
     */
    inline void setGameInfo (const T_SportsFlash_Game& GameInfo_);

    // API of field "FlashEventID"

    static const int kFlashEventID = 1;

    /**
     * Clears the field "FlashEventID".
     *
     * The field will be set to its default value. The hasFlashEventID()
     * method will return false.
     */
    inline void clearFlashEventID();

    /**
     * Checks whether the field "FlashEventID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlashEventID()). Otherwise it will return false.
     */
    inline bool hasFlashEventID () const;

    /**
     * Returns the value of the member "FlashEventID".
     *
     * ID of the Flash Event used for subsequent control of the event playback.
     *
     * @return The value of the field "FlashEventID"
     */
    inline uint32 getFlashEventID () const;

    /**
     * Sets the value of the member "FlashEventID".
     *
     * ID of the Flash Event used for subsequent control of the event playback.
     *
     * @param FlashEventID The value which will be set
     */
    inline void setFlashEventID (uint32 FlashEventID_);

    static const T_SportsFlash_FlashEvent &getDefaultInstance();

private:

    inline void set_has_GameInfo ();

    inline void clear_has_GameInfo ();

    inline void set_has_FlashEventID ();

    inline void clear_has_FlashEventID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_SportsFlash_Game _GameInfo;

    uint32 _FlashEventID;

};

/**
 * Details about a sports flash enabled league.
 */
class T_SportsFlash_League {
public:

    /**
     * Default constructor
     */
    inline  T_SportsFlash_League ();

    /**
     * Copy constructor
     */
    inline  T_SportsFlash_League (const T_SportsFlash_League &rhs);

    /**
     * All fields constructor
     */
    inline  T_SportsFlash_League (T_e8_SportsFlash_Sport SportType_, uint8 LeagueID_, T_e8_SportsFlash_League LeagueType_, const ::std::string& LeagueAbbrName_, const ::std::string& LeagueFullName_);

    /**
     * Destructor
     */
    inline  ~T_SportsFlash_League();

    /**
     * Assignment operator
     */
    inline T_SportsFlash_League& operator = (const T_SportsFlash_League& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SportsFlash_League& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SportsFlash_League& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SportsFlash_League& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SportsFlash_League& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportType"

    static const int kSportType = 0;

    /**
     * Clears the field "SportType".
     *
     * The field will be set to its default value. The hasSportType()
     * method will return false.
     */
    inline void clearSportType();

    /**
     * Checks whether the field "SportType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportType()). Otherwise it will return false.
     */
    inline bool hasSportType () const;

    /**
     * Returns the value of the member "SportType".
     *
     * Type of sport.
     *
     * @return The value of the field "SportType"
     */
    inline T_e8_SportsFlash_Sport getSportType () const;

    /**
     * Sets the value of the member "SportType".
     *
     * Type of sport.
     *
     * @param SportType The value which will be set
     */
    inline void setSportType (T_e8_SportsFlash_Sport SportType_);

    // API of field "LeagueID"

    static const int kLeagueID = 1;

    /**
     * Clears the field "LeagueID".
     *
     * The field will be set to its default value. The hasLeagueID()
     * method will return false.
     */
    inline void clearLeagueID();

    /**
     * Checks whether the field "LeagueID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueID()). Otherwise it will return false.
     */
    inline bool hasLeagueID () const;

    /**
     * Returns the value of the member "LeagueID".
     *
     * League's unique ID.
     *
     * @return The value of the field "LeagueID"
     */
    inline uint8 getLeagueID () const;

    /**
     * Sets the value of the member "LeagueID".
     *
     * League's unique ID.
     *
     * @param LeagueID The value which will be set
     */
    inline void setLeagueID (uint8 LeagueID_);

    // API of field "LeagueType"

    static const int kLeagueType = 2;

    /**
     * Clears the field "LeagueType".
     *
     * The field will be set to its default value. The hasLeagueType()
     * method will return false.
     */
    inline void clearLeagueType();

    /**
     * Checks whether the field "LeagueType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueType()). Otherwise it will return false.
     */
    inline bool hasLeagueType () const;

    /**
     * Returns the value of the member "LeagueType".
     *
     * Type of league.
     *
     * @return The value of the field "LeagueType"
     */
    inline T_e8_SportsFlash_League getLeagueType () const;

    /**
     * Sets the value of the member "LeagueType".
     *
     * Type of league.
     *
     * @param LeagueType The value which will be set
     */
    inline void setLeagueType (T_e8_SportsFlash_League LeagueType_);

    // API of field "LeagueAbbrName"

    static const int kLeagueAbbrName = 3;

    /**
     * Clears the field "LeagueAbbrName".
     *
     * The field will be set to its default value. The hasLeagueAbbrName()
     * method will return false.
     */
    inline void clearLeagueAbbrName();

    /**
     * Checks whether the field "LeagueAbbrName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueAbbrName()). Otherwise it will return false.
     */
    inline bool hasLeagueAbbrName () const;

    /**
     * Returns the value of the member "LeagueAbbrName".
     *
     * Abbreviated league name.
     * <p>Example. NFL.</p>
     *
     * @return The value of the field "LeagueAbbrName"
     */
    inline const ::std::string& getLeagueAbbrName () const;

    /**
     * Retrieves the value of the field "LeagueAbbrName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LeagueAbbrName".
     */
    inline ::std::string& getLeagueAbbrNameMutable ();

    /**
     * Sets the value of the member "LeagueAbbrName".
     *
     * Abbreviated league name.
     * <p>Example. NFL.</p>
     *
     * @param LeagueAbbrName The value which will be set
     */
    inline void setLeagueAbbrName (const ::std::string& LeagueAbbrName_);

    /**
     * Sets the value of the member "LeagueAbbrName".
     *
     * Abbreviated league name.
     * <p>Example. NFL.</p>
     *
     * @param LeagueAbbrName The value which will be set
     */
    inline void setLeagueAbbrName (const char* LeagueAbbrName_);

    /**
     * Sets the value of the member "LeagueAbbrName".
     *
     * Abbreviated league name.
     * <p>Example. NFL.</p>
     *
     * @param LeagueAbbrName The value which will be set
     */
    inline void setLeagueAbbrName (const char* value, size_t size);

    // API of field "LeagueFullName"

    static const int kLeagueFullName = 4;

    /**
     * Clears the field "LeagueFullName".
     *
     * The field will be set to its default value. The hasLeagueFullName()
     * method will return false.
     */
    inline void clearLeagueFullName();

    /**
     * Checks whether the field "LeagueFullName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueFullName()). Otherwise it will return false.
     */
    inline bool hasLeagueFullName () const;

    /**
     * Returns the value of the member "LeagueFullName".
     *
     * Full league name.
     * <p>Example. National Football League.</p>
     *
     * @return The value of the field "LeagueFullName"
     */
    inline const ::std::string& getLeagueFullName () const;

    /**
     * Retrieves the value of the field "LeagueFullName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LeagueFullName".
     */
    inline ::std::string& getLeagueFullNameMutable ();

    /**
     * Sets the value of the member "LeagueFullName".
     *
     * Full league name.
     * <p>Example. National Football League.</p>
     *
     * @param LeagueFullName The value which will be set
     */
    inline void setLeagueFullName (const ::std::string& LeagueFullName_);

    /**
     * Sets the value of the member "LeagueFullName".
     *
     * Full league name.
     * <p>Example. National Football League.</p>
     *
     * @param LeagueFullName The value which will be set
     */
    inline void setLeagueFullName (const char* LeagueFullName_);

    /**
     * Sets the value of the member "LeagueFullName".
     *
     * Full league name.
     * <p>Example. National Football League.</p>
     *
     * @param LeagueFullName The value which will be set
     */
    inline void setLeagueFullName (const char* value, size_t size);

    static const T_SportsFlash_League &getDefaultInstance();

private:

    inline void set_has_SportType ();

    inline void clear_has_SportType ();

    inline void set_has_LeagueID ();

    inline void clear_has_LeagueID ();

    inline void set_has_LeagueType ();

    inline void clear_has_LeagueType ();

    inline void set_has_LeagueAbbrName ();

    inline void clear_has_LeagueAbbrName ();

    inline void set_has_LeagueFullName ();

    inline void clear_has_LeagueFullName ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_SportsFlash_Sport _SportType;

    uint8 _LeagueID;

    T_e8_SportsFlash_League _LeagueType;

    ::std::string _LeagueAbbrName;

    ::std::string _LeagueFullName;

};

/**
 * Details about a sports flash supported team.
 */
class T_SportsFlash_Team {
public:

    /**
     * Default constructor
     */
    inline  T_SportsFlash_Team ();

    /**
     * Copy constructor
     */
    inline  T_SportsFlash_Team (const T_SportsFlash_Team &rhs);

    /**
     * All fields constructor
     */
    inline  T_SportsFlash_Team (uint16 TeamID_, const ::std::string& TeamName_, const ::std::string& TeamNickName_, const ::std::string& TeamAbbrName_, const ::std::string& TeamFullName_, bool IsFavorite_);

    /**
     * Destructor
     */
    inline  ~T_SportsFlash_Team();

    /**
     * Assignment operator
     */
    inline T_SportsFlash_Team& operator = (const T_SportsFlash_Team& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SportsFlash_Team& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SportsFlash_Team& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SportsFlash_Team& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SportsFlash_Team& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TeamID"

    static const int kTeamID = 0;

    /**
     * Clears the field "TeamID".
     *
     * The field will be set to its default value. The hasTeamID()
     * method will return false.
     */
    inline void clearTeamID();

    /**
     * Checks whether the field "TeamID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamID()). Otherwise it will return false.
     */
    inline bool hasTeamID () const;

    /**
     * Returns the value of the member "TeamID".
     *
     * Team's unique ID within the league.
     *
     * @return The value of the field "TeamID"
     */
    inline uint16 getTeamID () const;

    /**
     * Sets the value of the member "TeamID".
     *
     * Team's unique ID within the league.
     *
     * @param TeamID The value which will be set
     */
    inline void setTeamID (uint16 TeamID_);

    // API of field "TeamName"

    static const int kTeamName = 1;

    /**
     * Clears the field "TeamName".
     *
     * The field will be set to its default value. The hasTeamName()
     * method will return false.
     */
    inline void clearTeamName();

    /**
     * Checks whether the field "TeamName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamName()). Otherwise it will return false.
     */
    inline bool hasTeamName () const;

    /**
     * Returns the value of the member "TeamName".
     *
     * Team given Name.
     *
     * @return The value of the field "TeamName"
     */
    inline const ::std::string& getTeamName () const;

    /**
     * Retrieves the value of the field "TeamName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TeamName".
     */
    inline ::std::string& getTeamNameMutable ();

    /**
     * Sets the value of the member "TeamName".
     *
     * Team given Name.
     *
     * @param TeamName The value which will be set
     */
    inline void setTeamName (const ::std::string& TeamName_);

    /**
     * Sets the value of the member "TeamName".
     *
     * Team given Name.
     *
     * @param TeamName The value which will be set
     */
    inline void setTeamName (const char* TeamName_);

    /**
     * Sets the value of the member "TeamName".
     *
     * Team given Name.
     *
     * @param TeamName The value which will be set
     */
    inline void setTeamName (const char* value, size_t size);

    // API of field "TeamNickName"

    static const int kTeamNickName = 2;

    /**
     * Clears the field "TeamNickName".
     *
     * The field will be set to its default value. The hasTeamNickName()
     * method will return false.
     */
    inline void clearTeamNickName();

    /**
     * Checks whether the field "TeamNickName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamNickName()). Otherwise it will return false.
     */
    inline bool hasTeamNickName () const;

    /**
     * Returns the value of the member "TeamNickName".
     *
     * Team's Nick Name.
     *
     * @return The value of the field "TeamNickName"
     */
    inline const ::std::string& getTeamNickName () const;

    /**
     * Retrieves the value of the field "TeamNickName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TeamNickName".
     */
    inline ::std::string& getTeamNickNameMutable ();

    /**
     * Sets the value of the member "TeamNickName".
     *
     * Team's Nick Name.
     *
     * @param TeamNickName The value which will be set
     */
    inline void setTeamNickName (const ::std::string& TeamNickName_);

    /**
     * Sets the value of the member "TeamNickName".
     *
     * Team's Nick Name.
     *
     * @param TeamNickName The value which will be set
     */
    inline void setTeamNickName (const char* TeamNickName_);

    /**
     * Sets the value of the member "TeamNickName".
     *
     * Team's Nick Name.
     *
     * @param TeamNickName The value which will be set
     */
    inline void setTeamNickName (const char* value, size_t size);

    // API of field "TeamAbbrName"

    static const int kTeamAbbrName = 3;

    /**
     * Clears the field "TeamAbbrName".
     *
     * The field will be set to its default value. The hasTeamAbbrName()
     * method will return false.
     */
    inline void clearTeamAbbrName();

    /**
     * Checks whether the field "TeamAbbrName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamAbbrName()). Otherwise it will return false.
     */
    inline bool hasTeamAbbrName () const;

    /**
     * Returns the value of the member "TeamAbbrName".
     *
     * Team's Abbreviated Name.
     *
     * @return The value of the field "TeamAbbrName"
     */
    inline const ::std::string& getTeamAbbrName () const;

    /**
     * Retrieves the value of the field "TeamAbbrName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TeamAbbrName".
     */
    inline ::std::string& getTeamAbbrNameMutable ();

    /**
     * Sets the value of the member "TeamAbbrName".
     *
     * Team's Abbreviated Name.
     *
     * @param TeamAbbrName The value which will be set
     */
    inline void setTeamAbbrName (const ::std::string& TeamAbbrName_);

    /**
     * Sets the value of the member "TeamAbbrName".
     *
     * Team's Abbreviated Name.
     *
     * @param TeamAbbrName The value which will be set
     */
    inline void setTeamAbbrName (const char* TeamAbbrName_);

    /**
     * Sets the value of the member "TeamAbbrName".
     *
     * Team's Abbreviated Name.
     *
     * @param TeamAbbrName The value which will be set
     */
    inline void setTeamAbbrName (const char* value, size_t size);

    // API of field "TeamFullName"

    static const int kTeamFullName = 4;

    /**
     * Clears the field "TeamFullName".
     *
     * The field will be set to its default value. The hasTeamFullName()
     * method will return false.
     */
    inline void clearTeamFullName();

    /**
     * Checks whether the field "TeamFullName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamFullName()). Otherwise it will return false.
     */
    inline bool hasTeamFullName () const;

    /**
     * Returns the value of the member "TeamFullName".
     *
     * Team's Full Name.(TeamName + " " + TeamNickName)
     *
     * @return The value of the field "TeamFullName"
     */
    inline const ::std::string& getTeamFullName () const;

    /**
     * Retrieves the value of the field "TeamFullName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TeamFullName".
     */
    inline ::std::string& getTeamFullNameMutable ();

    /**
     * Sets the value of the member "TeamFullName".
     *
     * Team's Full Name.(TeamName + " " + TeamNickName)
     *
     * @param TeamFullName The value which will be set
     */
    inline void setTeamFullName (const ::std::string& TeamFullName_);

    /**
     * Sets the value of the member "TeamFullName".
     *
     * Team's Full Name.(TeamName + " " + TeamNickName)
     *
     * @param TeamFullName The value which will be set
     */
    inline void setTeamFullName (const char* TeamFullName_);

    /**
     * Sets the value of the member "TeamFullName".
     *
     * Team's Full Name.(TeamName + " " + TeamNickName)
     *
     * @param TeamFullName The value which will be set
     */
    inline void setTeamFullName (const char* value, size_t size);

    // API of field "IsFavorite"

    static const int kIsFavorite = 5;

    /**
     * Clears the field "IsFavorite".
     *
     * The field will be set to its default value. The hasIsFavorite()
     * method will return false.
     */
    inline void clearIsFavorite();

    /**
     * Checks whether the field "IsFavorite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsFavorite()). Otherwise it will return false.
     */
    inline bool hasIsFavorite () const;

    /**
     * Returns the value of the member "IsFavorite".
     *
     * TRUE if the team is set as a favorite, FALSE if not.
     *
     * @return The value of the field "IsFavorite"
     */
    inline bool getIsFavorite () const;

    /**
     * Sets the value of the member "IsFavorite".
     *
     * TRUE if the team is set as a favorite, FALSE if not.
     *
     * @param IsFavorite The value which will be set
     */
    inline void setIsFavorite (bool IsFavorite_);

    static const T_SportsFlash_Team &getDefaultInstance();

private:

    inline void set_has_TeamID ();

    inline void clear_has_TeamID ();

    inline void set_has_TeamName ();

    inline void clear_has_TeamName ();

    inline void set_has_TeamNickName ();

    inline void clear_has_TeamNickName ();

    inline void set_has_TeamAbbrName ();

    inline void clear_has_TeamAbbrName ();

    inline void set_has_TeamFullName ();

    inline void clear_has_TeamFullName ();

    inline void set_has_IsFavorite ();

    inline void clear_has_IsFavorite ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint16 _TeamID;

    ::std::string _TeamName;

    ::std::string _TeamNickName;

    ::std::string _TeamAbbrName;

    ::std::string _TeamFullName;

    bool _IsFavorite;

};

/**
 * Details about a favorite team that needs to be set or unset for monitoring.
 */
class T_SportsFlash_MonitorTeam {
public:

    /**
     * Default constructor
     */
    inline  T_SportsFlash_MonitorTeam ();

    /**
     * Copy constructor
     */
    inline  T_SportsFlash_MonitorTeam (const T_SportsFlash_MonitorTeam &rhs);

    /**
     * All fields constructor
     */
    inline  T_SportsFlash_MonitorTeam (uint8 LeagueID_, uint16 TeamID_, bool Status_);

    /**
     * Destructor
     */
    inline  ~T_SportsFlash_MonitorTeam();

    /**
     * Assignment operator
     */
    inline T_SportsFlash_MonitorTeam& operator = (const T_SportsFlash_MonitorTeam& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SportsFlash_MonitorTeam& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SportsFlash_MonitorTeam& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SportsFlash_MonitorTeam& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SportsFlash_MonitorTeam& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LeagueID"

    static const int kLeagueID = 0;

    /**
     * Clears the field "LeagueID".
     *
     * The field will be set to its default value. The hasLeagueID()
     * method will return false.
     */
    inline void clearLeagueID();

    /**
     * Checks whether the field "LeagueID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueID()). Otherwise it will return false.
     */
    inline bool hasLeagueID () const;

    /**
     * Returns the value of the member "LeagueID".
     *
     * The League Id to which the team is affiliated to.
     *
     * @return The value of the field "LeagueID"
     */
    inline uint8 getLeagueID () const;

    /**
     * Sets the value of the member "LeagueID".
     *
     * The League Id to which the team is affiliated to.
     *
     * @param LeagueID The value which will be set
     */
    inline void setLeagueID (uint8 LeagueID_);

    // API of field "TeamID"

    static const int kTeamID = 1;

    /**
     * Clears the field "TeamID".
     *
     * The field will be set to its default value. The hasTeamID()
     * method will return false.
     */
    inline void clearTeamID();

    /**
     * Checks whether the field "TeamID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamID()). Otherwise it will return false.
     */
    inline bool hasTeamID () const;

    /**
     * Returns the value of the member "TeamID".
     *
     * The Team ID whose Monitor status has to be changed.
     *
     * @return The value of the field "TeamID"
     */
    inline uint16 getTeamID () const;

    /**
     * Sets the value of the member "TeamID".
     *
     * The Team ID whose Monitor status has to be changed.
     *
     * @param TeamID The value which will be set
     */
    inline void setTeamID (uint16 TeamID_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Enable or Disable Team Monitor status.
     * <p>TRUE, if games involving the team has to be monitored and notifications be sent.</p>
     * <p>FALSE, if games involving the team need not be monitored and hence no notifications be sent.</p>
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Enable or Disable Team Monitor status.
     * <p>TRUE, if games involving the team has to be monitored and notifications be sent.</p>
     * <p>FALSE, if games involving the team need not be monitored and hence no notifications be sent.</p>
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const T_SportsFlash_MonitorTeam &getDefaultInstance();

private:

    inline void set_has_LeagueID ();

    inline void clear_has_LeagueID ();

    inline void set_has_TeamID ();

    inline void clear_has_TeamID ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _LeagueID;

    uint16 _TeamID;

    bool _Status;

};

/**
 * Configure the duration and steps at which the channels need to be browsed.
 * <p>Example 1: duration = 2 sec and rate = 500 msec. --> For a duration of next 2 seconds, change channel once in 0.5 seconds. For next 2 seconds,  (2/0.5) 4 channels would be changed.</p>
 * <p>Example 2: duration = 10 sec and rate = 1000 msec. --> For a duration of next 10 seconds, change channel once in 1 second. For next 10 seconds, (10/1) 10 channels would be changed.</p>
 * <p>Example 3: duration = 0 sec and rate = 500 msec. --> Channels would be changed every 0.5 seconds forever until RapidChannelBrowse is stopped.</p>
 */
class T_BrowseRateConfiguration {
public:

    /**
     * Default constructor
     */
    inline  T_BrowseRateConfiguration ();

    /**
     * Copy constructor
     */
    inline  T_BrowseRateConfiguration (const T_BrowseRateConfiguration &rhs);

    /**
     * All fields constructor
     */
    inline  T_BrowseRateConfiguration (uint16 duration_, uint16 rate_);

    /**
     * Destructor
     */
    inline  ~T_BrowseRateConfiguration();

    /**
     * Assignment operator
     */
    inline T_BrowseRateConfiguration& operator = (const T_BrowseRateConfiguration& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BrowseRateConfiguration& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BrowseRateConfiguration& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BrowseRateConfiguration& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BrowseRateConfiguration& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "duration"

    static const int kDuration = 0;

    /**
     * Clears the field "duration".
     *
     * The field will be set to its default value. The hasDuration()
     * method will return false.
     */
    inline void clearDuration();

    /**
     * Checks whether the field "duration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDuration()). Otherwise it will return false.
     */
    inline bool hasDuration () const;

    /**
     * Returns the value of the member "duration".
     *
     * (Units in seconds.) Overall duration until which the speed has to be maintained. If value = 0, then continue with the same channel rate forever.
     *
     * @return The value of the field "duration"
     */
    inline uint16 getDuration () const;

    /**
     * Sets the value of the member "duration".
     *
     * (Units in seconds.) Overall duration until which the speed has to be maintained. If value = 0, then continue with the same channel rate forever.
     *
     * @param duration The value which will be set
     */
    inline void setDuration (uint16 duration_);

    // API of field "rate"

    static const int kRate = 1;

    /**
     * Clears the field "rate".
     *
     * The field will be set to its default value. The hasRate()
     * method will return false.
     */
    inline void clearRate();

    /**
     * Checks whether the field "rate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRate()). Otherwise it will return false.
     */
    inline bool hasRate () const;

    /**
     * Returns the value of the member "rate".
     *
     * (Units in milliseconds.)Rate at which the channel change has to be made.
     * <p>Minimum value = 100; Maximum value = 65535;</p>
     *
     * @return The value of the field "rate"
     */
    inline uint16 getRate () const;

    /**
     * Sets the value of the member "rate".
     *
     * (Units in milliseconds.)Rate at which the channel change has to be made.
     * <p>Minimum value = 100; Maximum value = 65535;</p>
     *
     * @param rate The value which will be set
     */
    inline void setRate (uint16 rate_);

    static const T_BrowseRateConfiguration &getDefaultInstance();

private:

    inline void set_has_duration ();

    inline void clear_has_duration ();

    inline void set_has_rate ();

    inline void clear_has_rate ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _duration;

    uint16 _rate;

};

/**
 * Configuration parameters for Rapid Channel Browsing.
 */
class T_BrowseChannelConfig {
public:

    /**
     * Default constructor
     */
    inline  T_BrowseChannelConfig ();

    /**
     * Copy constructor
     */
    inline  T_BrowseChannelConfig (const T_BrowseChannelConfig &rhs);

    /**
     * All fields constructor
     */
    inline  T_BrowseChannelConfig (const ::std::vector< T_BrowseRateConfiguration >& Configuration_, T_e8_BrowseChannelLoop Loop_, T_e8_BrowseChannelType Type_);

    /**
     * Destructor
     */
    inline  ~T_BrowseChannelConfig();

    /**
     * Assignment operator
     */
    inline T_BrowseChannelConfig& operator = (const T_BrowseChannelConfig& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BrowseChannelConfig& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BrowseChannelConfig& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BrowseChannelConfig& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BrowseChannelConfig& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Configuration"

    static const int kConfiguration = 0;

    /**
     * Clears the field "Configuration".
     *
     * The field will be set to its default value. The hasConfiguration()
     * method will return false.
     */
    inline void clearConfiguration();

    /**
     * Checks whether the field "Configuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfiguration()). Otherwise it will return false.
     */
    inline bool hasConfiguration () const;

    /**
     * Returns the value of the member "Configuration".
     *
     * If Client sends a list of 3 items....say BrowseRateConfiguration[0] = { 2, 500};
     * <p>BrowseRateConfiguration[1] = { 6, 300}; BrowseRateConfiguration[2] = { 0, 200};</p>
     * <p>Once method RapidChannelBrowseStart is received, FC_SXM changes channels for the first 2 seconds every 0.5 seconds once, next 6 seconds a channel is changed 0.3 seconds once and after that a channel is changed 0.2 seconds once until method RapidChannelBrowseStop is issued.</p>
     * <p>Channel change refers to a property update(RapidChannelBrowseInfo) being triggered from FC_SXM.</p>
     *
     * @return The value of the field "Configuration"
     */
    inline const ::std::vector< T_BrowseRateConfiguration >& getConfiguration () const;

    /**
     * Retrieves the value of the field "Configuration" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Configuration".
     */
    inline ::std::vector< T_BrowseRateConfiguration >& getConfigurationMutable ();

    /**
     * Sets the value of the member "Configuration".
     *
     * If Client sends a list of 3 items....say BrowseRateConfiguration[0] = { 2, 500};
     * <p>BrowseRateConfiguration[1] = { 6, 300}; BrowseRateConfiguration[2] = { 0, 200};</p>
     * <p>Once method RapidChannelBrowseStart is received, FC_SXM changes channels for the first 2 seconds every 0.5 seconds once, next 6 seconds a channel is changed 0.3 seconds once and after that a channel is changed 0.2 seconds once until method RapidChannelBrowseStop is issued.</p>
     * <p>Channel change refers to a property update(RapidChannelBrowseInfo) being triggered from FC_SXM.</p>
     *
     * @param Configuration The value which will be set
     */
    inline void setConfiguration (const ::std::vector< T_BrowseRateConfiguration >& Configuration_);

    // API of field "Loop"

    static const int kLoop = 1;

    /**
     * Clears the field "Loop".
     *
     * The field will be set to its default value. The hasLoop()
     * method will return false.
     */
    inline void clearLoop();

    /**
     * Checks whether the field "Loop" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoop()). Otherwise it will return false.
     */
    inline bool hasLoop () const;

    /**
     * Returns the value of the member "Loop".
     *
     * Set the way the channel browse needs to Loop through.
     *
     * @return The value of the field "Loop"
     */
    inline T_e8_BrowseChannelLoop getLoop () const;

    /**
     * Sets the value of the member "Loop".
     *
     * Set the way the channel browse needs to Loop through.
     *
     * @param Loop The value which will be set
     */
    inline void setLoop (T_e8_BrowseChannelLoop Loop_);

    // API of field "Type"

    static const int kType = 2;

    /**
     * Clears the field "Type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "Type".
     *
     * Set if all channels or only channels belonging to a category needs to be considered for Rapid Channel Browsing.
     *
     * @return The value of the field "Type"
     */
    inline T_e8_BrowseChannelType getType () const;

    /**
     * Sets the value of the member "Type".
     *
     * Set if all channels or only channels belonging to a category needs to be considered for Rapid Channel Browsing.
     *
     * @param Type The value which will be set
     */
    inline void setType (T_e8_BrowseChannelType Type_);

    static const T_BrowseChannelConfig &getDefaultInstance();

private:

    static const ::std::vector< T_BrowseRateConfiguration >& getT_BrowseRateConfigurationList_DefaultInstance ();

    inline void set_has_Configuration ();

    inline void clear_has_Configuration ();

    inline void set_has_Loop ();

    inline void clear_has_Loop ();

    inline void set_has_Type ();

    inline void clear_has_Type ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< T_BrowseRateConfiguration > _Configuration;

    T_e8_BrowseChannelLoop _Loop;

    T_e8_BrowseChannelType _Type;

};

/**
 * Channel Event Mask
 */
class T_b16_CHANNEL_EVENT {
public:

    /**
     * Default constructor
     */
    inline  T_b16_CHANNEL_EVENT ();

    /**
     * Copy constructor
     */
    inline  T_b16_CHANNEL_EVENT (const T_b16_CHANNEL_EVENT &c);

    /**
     * Field constructor
     */
    inline  T_b16_CHANNEL_EVENT (bool CHANNEL_EVENT_SERVICE_ID, bool CHANNEL_EVENT_CHANNEL_ID, bool CHANNEL_EVENT_ATTRIBUTES, bool CHANNEL_EVENT_NAME, bool CHANNEL_EVENT_CATEGORY, bool CHANNEL_EVENT_TITLE, bool CHANNEL_EVENT_ARTIST, bool CHANNEL_EVENT_ALBUM, bool CHANNEL_EVENT_ART, bool CHANNEL_EVENT_REMOVED, bool CHANNEL_EVENT_b10_reserved, bool CHANNEL_EVENT_b11_reserved, bool CHANNEL_EVENT_b12_reserved, bool CHANNEL_EVENT_b13_reserved, bool CHANNEL_EVENT_b14_reserved, bool CHANNEL_EVENT_b15_reserved);

    /**
     * Assignment operator
     */
    inline T_b16_CHANNEL_EVENT& operator = (const T_b16_CHANNEL_EVENT& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b16_CHANNEL_EVENT& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b16_CHANNEL_EVENT& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b16_CHANNEL_EVENT& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b16_CHANNEL_EVENT& rhs) const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_SERVICE_ID".
     *
     * If the meaning of "CHANNEL_EVENT_SERVICE_ID" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_SERVICE_ID The value which will be set
     */
    inline void setCHANNEL_EVENT_SERVICE_ID (bool CHANNEL_EVENT_SERVICE_ID);

    /**
     * Returns the value of the member "CHANNEL_EVENT_SERVICE_ID".
     *
     * If the meaning of "CHANNEL_EVENT_SERVICE_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_SERVICE_ID"
     */
    inline bool getCHANNEL_EVENT_SERVICE_ID () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_CHANNEL_ID".
     *
     * If the meaning of "CHANNEL_EVENT_CHANNEL_ID" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_CHANNEL_ID The value which will be set
     */
    inline void setCHANNEL_EVENT_CHANNEL_ID (bool CHANNEL_EVENT_CHANNEL_ID);

    /**
     * Returns the value of the member "CHANNEL_EVENT_CHANNEL_ID".
     *
     * If the meaning of "CHANNEL_EVENT_CHANNEL_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_CHANNEL_ID"
     */
    inline bool getCHANNEL_EVENT_CHANNEL_ID () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_ATTRIBUTES".
     *
     * If the meaning of "CHANNEL_EVENT_ATTRIBUTES" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_ATTRIBUTES The value which will be set
     */
    inline void setCHANNEL_EVENT_ATTRIBUTES (bool CHANNEL_EVENT_ATTRIBUTES);

    /**
     * Returns the value of the member "CHANNEL_EVENT_ATTRIBUTES".
     *
     * If the meaning of "CHANNEL_EVENT_ATTRIBUTES" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_ATTRIBUTES"
     */
    inline bool getCHANNEL_EVENT_ATTRIBUTES () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_NAME".
     *
     * If the meaning of "CHANNEL_EVENT_NAME" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_NAME The value which will be set
     */
    inline void setCHANNEL_EVENT_NAME (bool CHANNEL_EVENT_NAME);

    /**
     * Returns the value of the member "CHANNEL_EVENT_NAME".
     *
     * If the meaning of "CHANNEL_EVENT_NAME" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_NAME"
     */
    inline bool getCHANNEL_EVENT_NAME () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_CATEGORY".
     *
     * If the meaning of "CHANNEL_EVENT_CATEGORY" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_CATEGORY The value which will be set
     */
    inline void setCHANNEL_EVENT_CATEGORY (bool CHANNEL_EVENT_CATEGORY);

    /**
     * Returns the value of the member "CHANNEL_EVENT_CATEGORY".
     *
     * If the meaning of "CHANNEL_EVENT_CATEGORY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_CATEGORY"
     */
    inline bool getCHANNEL_EVENT_CATEGORY () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_TITLE".
     *
     * If the meaning of "CHANNEL_EVENT_TITLE" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_TITLE The value which will be set
     */
    inline void setCHANNEL_EVENT_TITLE (bool CHANNEL_EVENT_TITLE);

    /**
     * Returns the value of the member "CHANNEL_EVENT_TITLE".
     *
     * If the meaning of "CHANNEL_EVENT_TITLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_TITLE"
     */
    inline bool getCHANNEL_EVENT_TITLE () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_ARTIST".
     *
     * If the meaning of "CHANNEL_EVENT_ARTIST" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_ARTIST The value which will be set
     */
    inline void setCHANNEL_EVENT_ARTIST (bool CHANNEL_EVENT_ARTIST);

    /**
     * Returns the value of the member "CHANNEL_EVENT_ARTIST".
     *
     * If the meaning of "CHANNEL_EVENT_ARTIST" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_ARTIST"
     */
    inline bool getCHANNEL_EVENT_ARTIST () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_ALBUM".
     *
     * If the meaning of "CHANNEL_EVENT_ALBUM" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_ALBUM The value which will be set
     */
    inline void setCHANNEL_EVENT_ALBUM (bool CHANNEL_EVENT_ALBUM);

    /**
     * Returns the value of the member "CHANNEL_EVENT_ALBUM".
     *
     * If the meaning of "CHANNEL_EVENT_ALBUM" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_ALBUM"
     */
    inline bool getCHANNEL_EVENT_ALBUM () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_ART".
     *
     * If the meaning of "CHANNEL_EVENT_ART" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_ART The value which will be set
     */
    inline void setCHANNEL_EVENT_ART (bool CHANNEL_EVENT_ART);

    /**
     * Returns the value of the member "CHANNEL_EVENT_ART".
     *
     * If the meaning of "CHANNEL_EVENT_ART" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_ART"
     */
    inline bool getCHANNEL_EVENT_ART () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_REMOVED".
     *
     * If the meaning of "CHANNEL_EVENT_REMOVED" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_REMOVED The value which will be set
     */
    inline void setCHANNEL_EVENT_REMOVED (bool CHANNEL_EVENT_REMOVED);

    /**
     * Returns the value of the member "CHANNEL_EVENT_REMOVED".
     *
     * If the meaning of "CHANNEL_EVENT_REMOVED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_REMOVED"
     */
    inline bool getCHANNEL_EVENT_REMOVED () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_b10_reserved".
     *
     * If the meaning of "CHANNEL_EVENT_b10_reserved" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_b10_reserved The value which will be set
     */
    inline void setCHANNEL_EVENT_b10_reserved (bool CHANNEL_EVENT_b10_reserved);

    /**
     * Returns the value of the member "CHANNEL_EVENT_b10_reserved".
     *
     * If the meaning of "CHANNEL_EVENT_b10_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_b10_reserved"
     */
    inline bool getCHANNEL_EVENT_b10_reserved () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_b11_reserved".
     *
     * If the meaning of "CHANNEL_EVENT_b11_reserved" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_b11_reserved The value which will be set
     */
    inline void setCHANNEL_EVENT_b11_reserved (bool CHANNEL_EVENT_b11_reserved);

    /**
     * Returns the value of the member "CHANNEL_EVENT_b11_reserved".
     *
     * If the meaning of "CHANNEL_EVENT_b11_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_b11_reserved"
     */
    inline bool getCHANNEL_EVENT_b11_reserved () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_b12_reserved".
     *
     * If the meaning of "CHANNEL_EVENT_b12_reserved" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_b12_reserved The value which will be set
     */
    inline void setCHANNEL_EVENT_b12_reserved (bool CHANNEL_EVENT_b12_reserved);

    /**
     * Returns the value of the member "CHANNEL_EVENT_b12_reserved".
     *
     * If the meaning of "CHANNEL_EVENT_b12_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_b12_reserved"
     */
    inline bool getCHANNEL_EVENT_b12_reserved () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_b13_reserved".
     *
     * If the meaning of "CHANNEL_EVENT_b13_reserved" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_b13_reserved The value which will be set
     */
    inline void setCHANNEL_EVENT_b13_reserved (bool CHANNEL_EVENT_b13_reserved);

    /**
     * Returns the value of the member "CHANNEL_EVENT_b13_reserved".
     *
     * If the meaning of "CHANNEL_EVENT_b13_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_b13_reserved"
     */
    inline bool getCHANNEL_EVENT_b13_reserved () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_b14_reserved".
     *
     * If the meaning of "CHANNEL_EVENT_b14_reserved" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_b14_reserved The value which will be set
     */
    inline void setCHANNEL_EVENT_b14_reserved (bool CHANNEL_EVENT_b14_reserved);

    /**
     * Returns the value of the member "CHANNEL_EVENT_b14_reserved".
     *
     * If the meaning of "CHANNEL_EVENT_b14_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_b14_reserved"
     */
    inline bool getCHANNEL_EVENT_b14_reserved () const;

    /**
     * Sets the value of the member "CHANNEL_EVENT_b15_reserved".
     *
     * If the meaning of "CHANNEL_EVENT_b15_reserved" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_EVENT_b15_reserved The value which will be set
     */
    inline void setCHANNEL_EVENT_b15_reserved (bool CHANNEL_EVENT_b15_reserved);

    /**
     * Returns the value of the member "CHANNEL_EVENT_b15_reserved".
     *
     * If the meaning of "CHANNEL_EVENT_b15_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_EVENT_b15_reserved"
     */
    inline bool getCHANNEL_EVENT_b15_reserved () const;

    static const T_b16_CHANNEL_EVENT &getDefaultInstance();

private:

    bool _CHANNEL_EVENT_SERVICE_ID:1;

    bool _CHANNEL_EVENT_CHANNEL_ID:1;

    bool _CHANNEL_EVENT_ATTRIBUTES:1;

    bool _CHANNEL_EVENT_NAME:1;

    bool _CHANNEL_EVENT_CATEGORY:1;

    bool _CHANNEL_EVENT_TITLE:1;

    bool _CHANNEL_EVENT_ARTIST:1;

    bool _CHANNEL_EVENT_ALBUM:1;

    bool _CHANNEL_EVENT_ART:1;

    bool _CHANNEL_EVENT_REMOVED:1;

    bool _CHANNEL_EVENT_b10_reserved:1;

    bool _CHANNEL_EVENT_b11_reserved:1;

    bool _CHANNEL_EVENT_b12_reserved:1;

    bool _CHANNEL_EVENT_b13_reserved:1;

    bool _CHANNEL_EVENT_b14_reserved:1;

    bool _CHANNEL_EVENT_b15_reserved:1;

};

/**
 * Details about Clock Time
 */
class T_LocalTimeDate {
public:

    /**
     * Default constructor
     */
    inline  T_LocalTimeDate ();

    /**
     * Copy constructor
     */
    inline  T_LocalTimeDate (const T_LocalTimeDate &rhs);

    /**
     * All fields constructor
     */
    inline  T_LocalTimeDate (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_);

    /**
     * Destructor
     */
    inline  ~T_LocalTimeDate();

    /**
     * Assignment operator
     */
    inline T_LocalTimeDate& operator = (const T_LocalTimeDate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_LocalTimeDate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_LocalTimeDate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_LocalTimeDate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_LocalTimeDate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16Year"

    static const int kS16Year = 0;

    /**
     * Clears the field "s16Year".
     *
     * The field will be set to its default value. The hasS16Year()
     * method will return false.
     */
    inline void clearS16Year();

    /**
     * Checks whether the field "s16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Year()). Otherwise it will return false.
     */
    inline bool hasS16Year () const;

    /**
     * Returns the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     *
     * @return The value of the field "s16Year"
     */
    inline int16 getS16Year () const;

    /**
     * Sets the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     *
     * @param s16Year The value which will be set
     */
    inline void setS16Year (int16 s16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hours"

    static const int kU8Hours = 3;

    /**
     * Clears the field "u8Hours".
     *
     * The field will be set to its default value. The hasU8Hours()
     * method will return false.
     */
    inline void clearU8Hours();

    /**
     * Checks whether the field "u8Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hours()). Otherwise it will return false.
     */
    inline bool hasU8Hours () const;

    /**
     * Returns the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat setting).
     *
     * @return The value of the field "u8Hours"
     */
    inline uint8 getU8Hours () const;

    /**
     * Sets the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat setting).
     *
     * @param u8Hours The value which will be set
     */
    inline void setU8Hours (uint8 u8Hours_);

    // API of field "u8Minutes"

    static const int kU8Minutes = 4;

    /**
     * Clears the field "u8Minutes".
     *
     * The field will be set to its default value. The hasU8Minutes()
     * method will return false.
     */
    inline void clearU8Minutes();

    /**
     * Checks whether the field "u8Minutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minutes()). Otherwise it will return false.
     */
    inline bool hasU8Minutes () const;

    /**
     * Returns the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @return The value of the field "u8Minutes"
     */
    inline uint8 getU8Minutes () const;

    /**
     * Sets the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @param u8Minutes The value which will be set
     */
    inline void setU8Minutes (uint8 u8Minutes_);

    // API of field "u8Seconds"

    static const int kU8Seconds = 5;

    /**
     * Clears the field "u8Seconds".
     *
     * The field will be set to its default value. The hasU8Seconds()
     * method will return false.
     */
    inline void clearU8Seconds();

    /**
     * Checks whether the field "u8Seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Seconds()). Otherwise it will return false.
     */
    inline bool hasU8Seconds () const;

    /**
     * Returns the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @return The value of the field "u8Seconds"
     */
    inline uint8 getU8Seconds () const;

    /**
     * Sets the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @param u8Seconds The value which will be set
     */
    inline void setU8Seconds (uint8 u8Seconds_);

    // API of field "u8Weekday"

    static const int kU8Weekday = 6;

    /**
     * Clears the field "u8Weekday".
     *
     * The field will be set to its default value. The hasU8Weekday()
     * method will return false.
     */
    inline void clearU8Weekday();

    /**
     * Checks whether the field "u8Weekday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Weekday()). Otherwise it will return false.
     */
    inline bool hasU8Weekday () const;

    /**
     * Returns the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @return The value of the field "u8Weekday"
     */
    inline uint8 getU8Weekday () const;

    /**
     * Sets the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @param u8Weekday The value which will be set
     */
    inline void setU8Weekday (uint8 u8Weekday_);

    static const T_LocalTimeDate &getDefaultInstance();

private:

    inline void set_has_s16Year ();

    inline void clear_has_s16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hours ();

    inline void clear_has_u8Hours ();

    inline void set_has_u8Minutes ();

    inline void clear_has_u8Minutes ();

    inline void set_has_u8Seconds ();

    inline void clear_has_u8Seconds ();

    inline void set_has_u8Weekday ();

    inline void clear_has_u8Weekday ();

    uint32 _has_bits_[ (7 + 31) / 32];

    int16 _s16Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hours;

    uint8 _u8Minutes;

    uint8 _u8Seconds;

    uint8 _u8Weekday;

};

/**
 * If the meaning of "T_PresetEntry" isn't clear, then there should be a description here.
 */
class T_PresetEntry {
public:

    /**
     * Default constructor
     */
    inline  T_PresetEntry ();

    /**
     * Copy constructor
     */
    inline  T_PresetEntry (const T_PresetEntry &rhs);

    /**
     * All fields constructor
     */
    inline  T_PresetEntry (uint16 Index_, uint16 SID_);

    /**
     * Destructor
     */
    inline  ~T_PresetEntry();

    /**
     * Assignment operator
     */
    inline T_PresetEntry& operator = (const T_PresetEntry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PresetEntry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PresetEntry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PresetEntry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PresetEntry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Index"

    static const int kIndex = 0;

    /**
     * Clears the field "Index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "Index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "Index".
     *
     * Preset index of the channel.
     *
     * @return The value of the field "Index"
     */
    inline uint16 getIndex () const;

    /**
     * Sets the value of the member "Index".
     *
     * Preset index of the channel.
     *
     * @param Index The value which will be set
     */
    inline void setIndex (uint16 Index_);

    // API of field "SID"

    static const int kSID = 1;

    /**
     * Clears the field "SID".
     *
     * The field will be set to its default value. The hasSID()
     * method will return false.
     */
    inline void clearSID();

    /**
     * Checks whether the field "SID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSID()). Otherwise it will return false.
     */
    inline bool hasSID () const;

    /**
     * Returns the value of the member "SID".
     *
     * Service ID of the channel.
     *
     * @return The value of the field "SID"
     */
    inline uint16 getSID () const;

    /**
     * Sets the value of the member "SID".
     *
     * Service ID of the channel.
     *
     * @param SID The value which will be set
     */
    inline void setSID (uint16 SID_);

    static const T_PresetEntry &getDefaultInstance();

private:

    inline void set_has_Index ();

    inline void clear_has_Index ();

    inline void set_has_SID ();

    inline void clear_has_SID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _Index;

    uint16 _SID;

};

/**
 * If the meaning of "T_ProfileResponse" isn't clear, then there should be a description here.
 */
class T_ProfileResponse {
public:

    /**
     * Default constructor
     */
    inline  T_ProfileResponse ();

    /**
     * Copy constructor
     */
    inline  T_ProfileResponse (const T_ProfileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  T_ProfileResponse (T_Status Status_, T_ProfileAction ProfileAction_, T_ProfileStatus ProfileStatus_);

    /**
     * Destructor
     */
    inline  ~T_ProfileResponse();

    /**
     * Assignment operator
     */
    inline T_ProfileResponse& operator = (const T_ProfileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ProfileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ProfileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ProfileResponse& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ProfileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * User profile action status success/failed.
     *
     * @return The value of the field "Status"
     */
    inline T_Status getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * User profile action status success/failed.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (T_Status Status_);

    // API of field "ProfileAction"

    static const int kProfileAction = 1;

    /**
     * Clears the field "ProfileAction".
     *
     * The field will be set to its default value. The hasProfileAction()
     * method will return false.
     */
    inline void clearProfileAction();

    /**
     * Checks whether the field "ProfileAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfileAction()). Otherwise it will return false.
     */
    inline bool hasProfileAction () const;

    /**
     * Returns the value of the member "ProfileAction".
     *
     * Type of profile action
     *
     * @return The value of the field "ProfileAction"
     */
    inline T_ProfileAction getProfileAction () const;

    /**
     * Sets the value of the member "ProfileAction".
     *
     * Type of profile action
     *
     * @param ProfileAction The value which will be set
     */
    inline void setProfileAction (T_ProfileAction ProfileAction_);

    // API of field "ProfileStatus"

    static const int kProfileStatus = 2;

    /**
     * Clears the field "ProfileStatus".
     *
     * The field will be set to its default value. The hasProfileStatus()
     * method will return false.
     */
    inline void clearProfileStatus();

    /**
     * Checks whether the field "ProfileStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfileStatus()). Otherwise it will return false.
     */
    inline bool hasProfileStatus () const;

    /**
     * Returns the value of the member "ProfileStatus".
     *
     * Type of profile action
     *
     * @return The value of the field "ProfileStatus"
     */
    inline T_ProfileStatus getProfileStatus () const;

    /**
     * Sets the value of the member "ProfileStatus".
     *
     * Type of profile action
     *
     * @param ProfileStatus The value which will be set
     */
    inline void setProfileStatus (T_ProfileStatus ProfileStatus_);

    static const T_ProfileResponse &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    inline void set_has_ProfileAction ();

    inline void clear_has_ProfileAction ();

    inline void set_has_ProfileStatus ();

    inline void clear_has_ProfileStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_Status _Status;

    T_ProfileAction _ProfileAction;

    T_ProfileStatus _ProfileStatus;

};

/**
 * If the meaning of "T_PresetsConfiguration" isn't clear, then there should be a description here.
 */
class T_PresetsConfiguration {
public:

    /**
     * Default constructor
     */
    inline  T_PresetsConfiguration ();

    /**
     * Copy constructor
     */
    inline  T_PresetsConfiguration (const T_PresetsConfiguration &rhs);

    /**
     * All fields constructor
     */
    inline  T_PresetsConfiguration (uint8 BandCount_, uint8 BandCapacity_);

    /**
     * Destructor
     */
    inline  ~T_PresetsConfiguration();

    /**
     * Assignment operator
     */
    inline T_PresetsConfiguration& operator = (const T_PresetsConfiguration& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PresetsConfiguration& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PresetsConfiguration& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PresetsConfiguration& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PresetsConfiguration& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BandCount"

    static const int kBandCount = 0;

    /**
     * Clears the field "BandCount".
     *
     * The field will be set to its default value. The hasBandCount()
     * method will return false.
     */
    inline void clearBandCount();

    /**
     * Checks whether the field "BandCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBandCount()). Otherwise it will return false.
     */
    inline bool hasBandCount () const;

    /**
     * Returns the value of the member "BandCount".
     *
     * Number of preset bands.
     *
     * @return The value of the field "BandCount"
     */
    inline uint8 getBandCount () const;

    /**
     * Sets the value of the member "BandCount".
     *
     * Number of preset bands.
     *
     * @param BandCount The value which will be set
     */
    inline void setBandCount (uint8 BandCount_);

    // API of field "BandCapacity"

    static const int kBandCapacity = 1;

    /**
     * Clears the field "BandCapacity".
     *
     * The field will be set to its default value. The hasBandCapacity()
     * method will return false.
     */
    inline void clearBandCapacity();

    /**
     * Checks whether the field "BandCapacity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBandCapacity()). Otherwise it will return false.
     */
    inline bool hasBandCapacity () const;

    /**
     * Returns the value of the member "BandCapacity".
     *
     * Maximum number of presets in each band.
     *
     * @return The value of the field "BandCapacity"
     */
    inline uint8 getBandCapacity () const;

    /**
     * Sets the value of the member "BandCapacity".
     *
     * Maximum number of presets in each band.
     *
     * @param BandCapacity The value which will be set
     */
    inline void setBandCapacity (uint8 BandCapacity_);

    static const T_PresetsConfiguration &getDefaultInstance();

private:

    inline void set_has_BandCount ();

    inline void clear_has_BandCount ();

    inline void set_has_BandCapacity ();

    inline void clear_has_BandCapacity ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _BandCount;

    uint8 _BandCapacity;

};

inline  T_ChannelListEntry::T_ChannelListEntry ()  :
    _ServiceID (0u),
    _ChannelID (0u),
    _ChannelNameAvail (false),
    _ChannelName (),
    _ChannelArtistName (),
    _ChannelSongName (),
    _PresetNumber (0u),
    _IsLocked (false),
    _IsAvailable (false),
    _IsMature (false),
    _IsSkipped (false),
    _ChannelGraphicAvail (::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ChannelListEntry::T_ChannelListEntry (const T_ChannelListEntry &rhs)  :
    _ServiceID (0u),
    _ChannelID (0u),
    _ChannelNameAvail (false),
    _ChannelName (),
    _ChannelArtistName (),
    _ChannelSongName (),
    _PresetNumber (0u),
    _IsLocked (false),
    _IsAvailable (false),
    _IsMature (false),
    _IsSkipped (false),
    _ChannelGraphicAvail (::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ChannelListEntry::T_ChannelListEntry (uint16 ServiceID_, uint16 ChannelID_, bool ChannelNameAvail_, const ::std::string& ChannelName_, const ::std::string& ChannelArtistName_, const ::std::string& ChannelSongName_, uint8 PresetNumber_, bool IsLocked_, bool IsAvailable_, bool IsMature_, bool IsSkipped_, T_e8_Graphics ChannelGraphicAvail_)  :
    _ServiceID (ServiceID_),
    _ChannelID (ChannelID_),
    _ChannelNameAvail (ChannelNameAvail_),
    _ChannelName (ChannelName_),
    _ChannelArtistName (ChannelArtistName_),
    _ChannelSongName (ChannelSongName_),
    _PresetNumber (PresetNumber_),
    _IsLocked (IsLocked_),
    _IsAvailable (IsAvailable_),
    _IsMature (IsMature_),
    _IsSkipped (IsSkipped_),
    _ChannelGraphicAvail (ChannelGraphicAvail_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelSongName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_Graphics_IsValid(ChannelGraphicAvail_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChannelGraphicAvail_, "T_e8_Graphics", "ChannelGraphicAvail", "T_ChannelListEntry");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ChannelListEntry::~T_ChannelListEntry() {
}

inline T_ChannelListEntry& T_ChannelListEntry::operator = (const T_ChannelListEntry& rhs) {
    if( this != &rhs ) {
        if (rhs.hasServiceID()) {
            setServiceID(rhs.getServiceID());
        } else {
            clearServiceID();
        }
        if (rhs.hasChannelID()) {
            setChannelID(rhs.getChannelID());
        } else {
            clearChannelID();
        }
        if (rhs.hasChannelNameAvail()) {
            setChannelNameAvail(rhs.getChannelNameAvail());
        } else {
            clearChannelNameAvail();
        }
        if (rhs.hasChannelName()) {
            setChannelName(rhs.getChannelName());
        } else {
            clearChannelName();
        }
        if (rhs.hasChannelArtistName()) {
            setChannelArtistName(rhs.getChannelArtistName());
        } else {
            clearChannelArtistName();
        }
        if (rhs.hasChannelSongName()) {
            setChannelSongName(rhs.getChannelSongName());
        } else {
            clearChannelSongName();
        }
        if (rhs.hasPresetNumber()) {
            setPresetNumber(rhs.getPresetNumber());
        } else {
            clearPresetNumber();
        }
        if (rhs.hasIsLocked()) {
            setIsLocked(rhs.getIsLocked());
        } else {
            clearIsLocked();
        }
        if (rhs.hasIsAvailable()) {
            setIsAvailable(rhs.getIsAvailable());
        } else {
            clearIsAvailable();
        }
        if (rhs.hasIsMature()) {
            setIsMature(rhs.getIsMature());
        } else {
            clearIsMature();
        }
        if (rhs.hasIsSkipped()) {
            setIsSkipped(rhs.getIsSkipped());
        } else {
            clearIsSkipped();
        }
        if (rhs.hasChannelGraphicAvail()) {
            setChannelGraphicAvail(rhs.getChannelGraphicAvail());
        } else {
            clearChannelGraphicAvail();
        }
    }
    return *this;
}

inline bool T_ChannelListEntry::operator == (const T_ChannelListEntry& rhs) const {
    return (((!hasServiceID() && !rhs.hasServiceID()) || getServiceID() == rhs.getServiceID()) &&
        ((!hasChannelID() && !rhs.hasChannelID()) || getChannelID() == rhs.getChannelID()) &&
        ((!hasChannelNameAvail() && !rhs.hasChannelNameAvail()) || getChannelNameAvail() == rhs.getChannelNameAvail()) &&
        ((!hasChannelName() && !rhs.hasChannelName()) || getChannelName() == rhs.getChannelName()) &&
        ((!hasChannelArtistName() && !rhs.hasChannelArtistName()) || getChannelArtistName() == rhs.getChannelArtistName()) &&
        ((!hasChannelSongName() && !rhs.hasChannelSongName()) || getChannelSongName() == rhs.getChannelSongName()) &&
        ((!hasPresetNumber() && !rhs.hasPresetNumber()) || getPresetNumber() == rhs.getPresetNumber()) &&
        ((!hasIsLocked() && !rhs.hasIsLocked()) || getIsLocked() == rhs.getIsLocked()) &&
        ((!hasIsAvailable() && !rhs.hasIsAvailable()) || getIsAvailable() == rhs.getIsAvailable()) &&
        ((!hasIsMature() && !rhs.hasIsMature()) || getIsMature() == rhs.getIsMature()) &&
        ((!hasIsSkipped() && !rhs.hasIsSkipped()) || getIsSkipped() == rhs.getIsSkipped()) &&
        ((!hasChannelGraphicAvail() && !rhs.hasChannelGraphicAvail()) || getChannelGraphicAvail() == rhs.getChannelGraphicAvail()));
}

inline bool T_ChannelListEntry::operator != (const T_ChannelListEntry& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ChannelListEntry::operator < (const T_ChannelListEntry& rhs) const {
    if (hasServiceID() || rhs.hasServiceID()) {
        if (getServiceID() < rhs.getServiceID()) return true;
        if (getServiceID() > rhs.getServiceID()) return false;
    }
    if (hasChannelID() || rhs.hasChannelID()) {
        if (getChannelID() < rhs.getChannelID()) return true;
        if (getChannelID() > rhs.getChannelID()) return false;
    }
    if (hasChannelNameAvail() || rhs.hasChannelNameAvail()) {
        if (getChannelNameAvail() < rhs.getChannelNameAvail()) return true;
        if (getChannelNameAvail() > rhs.getChannelNameAvail()) return false;
    }
    if (hasChannelName() || rhs.hasChannelName()) {
        if (getChannelName() < rhs.getChannelName()) return true;
        if (getChannelName() > rhs.getChannelName()) return false;
    }
    if (hasChannelArtistName() || rhs.hasChannelArtistName()) {
        if (getChannelArtistName() < rhs.getChannelArtistName()) return true;
        if (getChannelArtistName() > rhs.getChannelArtistName()) return false;
    }
    if (hasChannelSongName() || rhs.hasChannelSongName()) {
        if (getChannelSongName() < rhs.getChannelSongName()) return true;
        if (getChannelSongName() > rhs.getChannelSongName()) return false;
    }
    if (hasPresetNumber() || rhs.hasPresetNumber()) {
        if (getPresetNumber() < rhs.getPresetNumber()) return true;
        if (getPresetNumber() > rhs.getPresetNumber()) return false;
    }
    if (hasIsLocked() || rhs.hasIsLocked()) {
        if (getIsLocked() < rhs.getIsLocked()) return true;
        if (getIsLocked() > rhs.getIsLocked()) return false;
    }
    if (hasIsAvailable() || rhs.hasIsAvailable()) {
        if (getIsAvailable() < rhs.getIsAvailable()) return true;
        if (getIsAvailable() > rhs.getIsAvailable()) return false;
    }
    if (hasIsMature() || rhs.hasIsMature()) {
        if (getIsMature() < rhs.getIsMature()) return true;
        if (getIsMature() > rhs.getIsMature()) return false;
    }
    if (hasIsSkipped() || rhs.hasIsSkipped()) {
        if (getIsSkipped() < rhs.getIsSkipped()) return true;
        if (getIsSkipped() > rhs.getIsSkipped()) return false;
    }
    if (hasChannelGraphicAvail() || rhs.hasChannelGraphicAvail()) {
        if ((uint32)getChannelGraphicAvail() < (uint32)rhs.getChannelGraphicAvail()) return true;
        if ((uint32)getChannelGraphicAvail() > (uint32)rhs.getChannelGraphicAvail()) return false;
    }
    return false;
}

inline bool T_ChannelListEntry::operator > (const T_ChannelListEntry& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ChannelListEntry::clear() {
    clearServiceID();
    clearChannelID();
    clearChannelNameAvail();
    clearChannelName();
    clearChannelArtistName();
    clearChannelSongName();
    clearPresetNumber();
    clearIsLocked();
    clearIsAvailable();
    clearIsMature();
    clearIsSkipped();
    clearChannelGraphicAvail();
}

inline void T_ChannelListEntry::clearServiceID() {
    if (hasServiceID()) {
         clear_has_ServiceID();
        _ServiceID = 0u;
     }
}

inline bool T_ChannelListEntry::hasServiceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_ChannelListEntry::getServiceID () const {
    return _ServiceID;
}

inline void T_ChannelListEntry::setServiceID (uint16 ServiceID_) {
    set_has_ServiceID();
    this->_ServiceID = ServiceID_;
}

inline void T_ChannelListEntry::clearChannelID() {
    if (hasChannelID()) {
         clear_has_ChannelID();
        _ChannelID = 0u;
     }
}

inline bool T_ChannelListEntry::hasChannelID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_ChannelListEntry::getChannelID () const {
    return _ChannelID;
}

inline void T_ChannelListEntry::setChannelID (uint16 ChannelID_) {
    set_has_ChannelID();
    this->_ChannelID = ChannelID_;
}

inline void T_ChannelListEntry::clearChannelNameAvail() {
    if (hasChannelNameAvail()) {
         clear_has_ChannelNameAvail();
        _ChannelNameAvail = false;
     }
}

inline bool T_ChannelListEntry::hasChannelNameAvail () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_ChannelListEntry::getChannelNameAvail () const {
    return _ChannelNameAvail;
}

inline void T_ChannelListEntry::setChannelNameAvail (bool ChannelNameAvail_) {
    set_has_ChannelNameAvail();
    this->_ChannelNameAvail = ChannelNameAvail_;
}

inline void T_ChannelListEntry::clearChannelName() {
    if (hasChannelName()) {
         clear_has_ChannelName();
        _ChannelName.clear();
     }
}

inline bool T_ChannelListEntry::hasChannelName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_ChannelListEntry::getChannelName () const {
    return _ChannelName;
}

inline ::std::string& T_ChannelListEntry::getChannelNameMutable () {
    set_has_ChannelName();
    return _ChannelName;
}

inline void T_ChannelListEntry::setChannelName (const ::std::string& ChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName = ChannelName_;
}

inline void T_ChannelListEntry::setChannelName (const char* ChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName.assign(ChannelName_);
}

inline void T_ChannelListEntry::setChannelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName.assign(value, size);
}

inline void T_ChannelListEntry::clearChannelArtistName() {
    if (hasChannelArtistName()) {
         clear_has_ChannelArtistName();
        _ChannelArtistName.clear();
     }
}

inline bool T_ChannelListEntry::hasChannelArtistName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_ChannelListEntry::getChannelArtistName () const {
    return _ChannelArtistName;
}

inline ::std::string& T_ChannelListEntry::getChannelArtistNameMutable () {
    set_has_ChannelArtistName();
    return _ChannelArtistName;
}

inline void T_ChannelListEntry::setChannelArtistName (const ::std::string& ChannelArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelArtistName();
    this->_ChannelArtistName = ChannelArtistName_;
}

inline void T_ChannelListEntry::setChannelArtistName (const char* ChannelArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelArtistName();
    this->_ChannelArtistName.assign(ChannelArtistName_);
}

inline void T_ChannelListEntry::setChannelArtistName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelArtistName();
    this->_ChannelArtistName.assign(value, size);
}

inline void T_ChannelListEntry::clearChannelSongName() {
    if (hasChannelSongName()) {
         clear_has_ChannelSongName();
        _ChannelSongName.clear();
     }
}

inline bool T_ChannelListEntry::hasChannelSongName () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_ChannelListEntry::getChannelSongName () const {
    return _ChannelSongName;
}

inline ::std::string& T_ChannelListEntry::getChannelSongNameMutable () {
    set_has_ChannelSongName();
    return _ChannelSongName;
}

inline void T_ChannelListEntry::setChannelSongName (const ::std::string& ChannelSongName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelSongName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelSongName();
    this->_ChannelSongName = ChannelSongName_;
}

inline void T_ChannelListEntry::setChannelSongName (const char* ChannelSongName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelSongName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelSongName();
    this->_ChannelSongName.assign(ChannelSongName_);
}

inline void T_ChannelListEntry::setChannelSongName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelSongName();
    this->_ChannelSongName.assign(value, size);
}

inline void T_ChannelListEntry::clearPresetNumber() {
    if (hasPresetNumber()) {
         clear_has_PresetNumber();
        _PresetNumber = 0u;
     }
}

inline bool T_ChannelListEntry::hasPresetNumber () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_ChannelListEntry::getPresetNumber () const {
    return _PresetNumber;
}

inline void T_ChannelListEntry::setPresetNumber (uint8 PresetNumber_) {
    set_has_PresetNumber();
    this->_PresetNumber = PresetNumber_;
}

inline void T_ChannelListEntry::clearIsLocked() {
    if (hasIsLocked()) {
         clear_has_IsLocked();
        _IsLocked = false;
     }
}

inline bool T_ChannelListEntry::hasIsLocked () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_ChannelListEntry::getIsLocked () const {
    return _IsLocked;
}

inline void T_ChannelListEntry::setIsLocked (bool IsLocked_) {
    set_has_IsLocked();
    this->_IsLocked = IsLocked_;
}

inline void T_ChannelListEntry::clearIsAvailable() {
    if (hasIsAvailable()) {
         clear_has_IsAvailable();
        _IsAvailable = false;
     }
}

inline bool T_ChannelListEntry::hasIsAvailable () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_ChannelListEntry::getIsAvailable () const {
    return _IsAvailable;
}

inline void T_ChannelListEntry::setIsAvailable (bool IsAvailable_) {
    set_has_IsAvailable();
    this->_IsAvailable = IsAvailable_;
}

inline void T_ChannelListEntry::clearIsMature() {
    if (hasIsMature()) {
         clear_has_IsMature();
        _IsMature = false;
     }
}

inline bool T_ChannelListEntry::hasIsMature () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool T_ChannelListEntry::getIsMature () const {
    return _IsMature;
}

inline void T_ChannelListEntry::setIsMature (bool IsMature_) {
    set_has_IsMature();
    this->_IsMature = IsMature_;
}

inline void T_ChannelListEntry::clearIsSkipped() {
    if (hasIsSkipped()) {
         clear_has_IsSkipped();
        _IsSkipped = false;
     }
}

inline bool T_ChannelListEntry::hasIsSkipped () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool T_ChannelListEntry::getIsSkipped () const {
    return _IsSkipped;
}

inline void T_ChannelListEntry::setIsSkipped (bool IsSkipped_) {
    set_has_IsSkipped();
    this->_IsSkipped = IsSkipped_;
}

inline void T_ChannelListEntry::clearChannelGraphicAvail() {
    if (hasChannelGraphicAvail()) {
         clear_has_ChannelGraphicAvail();
        _ChannelGraphicAvail = ::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH;
     }
}

inline bool T_ChannelListEntry::hasChannelGraphicAvail () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline T_e8_Graphics T_ChannelListEntry::getChannelGraphicAvail () const {
    return _ChannelGraphicAvail;
}

inline void T_ChannelListEntry::setChannelGraphicAvail (T_e8_Graphics ChannelGraphicAvail_) {
    #ifndef NDEBUG
    if (!(T_e8_Graphics_IsValid(ChannelGraphicAvail_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChannelGraphicAvail_, "T_e8_Graphics", "ChannelGraphicAvail", "T_ChannelListEntry");
    }
    #endif
    set_has_ChannelGraphicAvail();
    this->_ChannelGraphicAvail = ChannelGraphicAvail_;
}

inline void T_ChannelListEntry::set_has_ServiceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ChannelListEntry::clear_has_ServiceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ChannelListEntry::set_has_ChannelID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ChannelListEntry::clear_has_ChannelID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ChannelListEntry::set_has_ChannelNameAvail () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ChannelListEntry::clear_has_ChannelNameAvail () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_ChannelListEntry::set_has_ChannelName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_ChannelListEntry::clear_has_ChannelName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_ChannelListEntry::set_has_ChannelArtistName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_ChannelListEntry::clear_has_ChannelArtistName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_ChannelListEntry::set_has_ChannelSongName () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_ChannelListEntry::clear_has_ChannelSongName () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_ChannelListEntry::set_has_PresetNumber () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_ChannelListEntry::clear_has_PresetNumber () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_ChannelListEntry::set_has_IsLocked () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_ChannelListEntry::clear_has_IsLocked () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_ChannelListEntry::set_has_IsAvailable () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_ChannelListEntry::clear_has_IsAvailable () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_ChannelListEntry::set_has_IsMature () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_ChannelListEntry::clear_has_IsMature () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_ChannelListEntry::set_has_IsSkipped () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_ChannelListEntry::clear_has_IsSkipped () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_ChannelListEntry::set_has_ChannelGraphicAvail () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_ChannelListEntry::clear_has_ChannelGraphicAvail () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline  T_PresetListEntry::T_PresetListEntry ()  :
    _ServiceID (0u),
    _ChannelID (0u),
    _ChannelNameAvail (false),
    _ChannelName (),
    _ChannelActive (false),
    _ChnGraphicAvail (::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH),
    _IsSmartFavorite (false),
    _IsLocked (false),
    _IsAvailable (false),
    _IsMature (false),
    _IsSkipped (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PresetListEntry::T_PresetListEntry (const T_PresetListEntry &rhs)  :
    _ServiceID (0u),
    _ChannelID (0u),
    _ChannelNameAvail (false),
    _ChannelName (),
    _ChannelActive (false),
    _ChnGraphicAvail (::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH),
    _IsSmartFavorite (false),
    _IsLocked (false),
    _IsAvailable (false),
    _IsMature (false),
    _IsSkipped (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PresetListEntry::T_PresetListEntry (uint16 ServiceID_, uint16 ChannelID_, bool ChannelNameAvail_, const ::std::string& ChannelName_, bool ChannelActive_, T_e8_Graphics ChnGraphicAvail_, bool IsSmartFavorite_, bool IsLocked_, bool IsAvailable_, bool IsMature_, bool IsSkipped_)  :
    _ServiceID (ServiceID_),
    _ChannelID (ChannelID_),
    _ChannelNameAvail (ChannelNameAvail_),
    _ChannelName (ChannelName_),
    _ChannelActive (ChannelActive_),
    _ChnGraphicAvail (ChnGraphicAvail_),
    _IsSmartFavorite (IsSmartFavorite_),
    _IsLocked (IsLocked_),
    _IsAvailable (IsAvailable_),
    _IsMature (IsMature_),
    _IsSkipped (IsSkipped_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_Graphics_IsValid(ChnGraphicAvail_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChnGraphicAvail_, "T_e8_Graphics", "ChnGraphicAvail", "T_PresetListEntry");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PresetListEntry::~T_PresetListEntry() {
}

inline T_PresetListEntry& T_PresetListEntry::operator = (const T_PresetListEntry& rhs) {
    if( this != &rhs ) {
        if (rhs.hasServiceID()) {
            setServiceID(rhs.getServiceID());
        } else {
            clearServiceID();
        }
        if (rhs.hasChannelID()) {
            setChannelID(rhs.getChannelID());
        } else {
            clearChannelID();
        }
        if (rhs.hasChannelNameAvail()) {
            setChannelNameAvail(rhs.getChannelNameAvail());
        } else {
            clearChannelNameAvail();
        }
        if (rhs.hasChannelName()) {
            setChannelName(rhs.getChannelName());
        } else {
            clearChannelName();
        }
        if (rhs.hasChannelActive()) {
            setChannelActive(rhs.getChannelActive());
        } else {
            clearChannelActive();
        }
        if (rhs.hasChnGraphicAvail()) {
            setChnGraphicAvail(rhs.getChnGraphicAvail());
        } else {
            clearChnGraphicAvail();
        }
        if (rhs.hasIsSmartFavorite()) {
            setIsSmartFavorite(rhs.getIsSmartFavorite());
        } else {
            clearIsSmartFavorite();
        }
        if (rhs.hasIsLocked()) {
            setIsLocked(rhs.getIsLocked());
        } else {
            clearIsLocked();
        }
        if (rhs.hasIsAvailable()) {
            setIsAvailable(rhs.getIsAvailable());
        } else {
            clearIsAvailable();
        }
        if (rhs.hasIsMature()) {
            setIsMature(rhs.getIsMature());
        } else {
            clearIsMature();
        }
        if (rhs.hasIsSkipped()) {
            setIsSkipped(rhs.getIsSkipped());
        } else {
            clearIsSkipped();
        }
    }
    return *this;
}

inline bool T_PresetListEntry::operator == (const T_PresetListEntry& rhs) const {
    return (((!hasServiceID() && !rhs.hasServiceID()) || getServiceID() == rhs.getServiceID()) &&
        ((!hasChannelID() && !rhs.hasChannelID()) || getChannelID() == rhs.getChannelID()) &&
        ((!hasChannelNameAvail() && !rhs.hasChannelNameAvail()) || getChannelNameAvail() == rhs.getChannelNameAvail()) &&
        ((!hasChannelName() && !rhs.hasChannelName()) || getChannelName() == rhs.getChannelName()) &&
        ((!hasChannelActive() && !rhs.hasChannelActive()) || getChannelActive() == rhs.getChannelActive()) &&
        ((!hasChnGraphicAvail() && !rhs.hasChnGraphicAvail()) || getChnGraphicAvail() == rhs.getChnGraphicAvail()) &&
        ((!hasIsSmartFavorite() && !rhs.hasIsSmartFavorite()) || getIsSmartFavorite() == rhs.getIsSmartFavorite()) &&
        ((!hasIsLocked() && !rhs.hasIsLocked()) || getIsLocked() == rhs.getIsLocked()) &&
        ((!hasIsAvailable() && !rhs.hasIsAvailable()) || getIsAvailable() == rhs.getIsAvailable()) &&
        ((!hasIsMature() && !rhs.hasIsMature()) || getIsMature() == rhs.getIsMature()) &&
        ((!hasIsSkipped() && !rhs.hasIsSkipped()) || getIsSkipped() == rhs.getIsSkipped()));
}

inline bool T_PresetListEntry::operator != (const T_PresetListEntry& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PresetListEntry::operator < (const T_PresetListEntry& rhs) const {
    if (hasServiceID() || rhs.hasServiceID()) {
        if (getServiceID() < rhs.getServiceID()) return true;
        if (getServiceID() > rhs.getServiceID()) return false;
    }
    if (hasChannelID() || rhs.hasChannelID()) {
        if (getChannelID() < rhs.getChannelID()) return true;
        if (getChannelID() > rhs.getChannelID()) return false;
    }
    if (hasChannelNameAvail() || rhs.hasChannelNameAvail()) {
        if (getChannelNameAvail() < rhs.getChannelNameAvail()) return true;
        if (getChannelNameAvail() > rhs.getChannelNameAvail()) return false;
    }
    if (hasChannelName() || rhs.hasChannelName()) {
        if (getChannelName() < rhs.getChannelName()) return true;
        if (getChannelName() > rhs.getChannelName()) return false;
    }
    if (hasChannelActive() || rhs.hasChannelActive()) {
        if (getChannelActive() < rhs.getChannelActive()) return true;
        if (getChannelActive() > rhs.getChannelActive()) return false;
    }
    if (hasChnGraphicAvail() || rhs.hasChnGraphicAvail()) {
        if ((uint32)getChnGraphicAvail() < (uint32)rhs.getChnGraphicAvail()) return true;
        if ((uint32)getChnGraphicAvail() > (uint32)rhs.getChnGraphicAvail()) return false;
    }
    if (hasIsSmartFavorite() || rhs.hasIsSmartFavorite()) {
        if (getIsSmartFavorite() < rhs.getIsSmartFavorite()) return true;
        if (getIsSmartFavorite() > rhs.getIsSmartFavorite()) return false;
    }
    if (hasIsLocked() || rhs.hasIsLocked()) {
        if (getIsLocked() < rhs.getIsLocked()) return true;
        if (getIsLocked() > rhs.getIsLocked()) return false;
    }
    if (hasIsAvailable() || rhs.hasIsAvailable()) {
        if (getIsAvailable() < rhs.getIsAvailable()) return true;
        if (getIsAvailable() > rhs.getIsAvailable()) return false;
    }
    if (hasIsMature() || rhs.hasIsMature()) {
        if (getIsMature() < rhs.getIsMature()) return true;
        if (getIsMature() > rhs.getIsMature()) return false;
    }
    if (hasIsSkipped() || rhs.hasIsSkipped()) {
        if (getIsSkipped() < rhs.getIsSkipped()) return true;
        if (getIsSkipped() > rhs.getIsSkipped()) return false;
    }
    return false;
}

inline bool T_PresetListEntry::operator > (const T_PresetListEntry& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PresetListEntry::clear() {
    clearServiceID();
    clearChannelID();
    clearChannelNameAvail();
    clearChannelName();
    clearChannelActive();
    clearChnGraphicAvail();
    clearIsSmartFavorite();
    clearIsLocked();
    clearIsAvailable();
    clearIsMature();
    clearIsSkipped();
}

inline void T_PresetListEntry::clearServiceID() {
    if (hasServiceID()) {
         clear_has_ServiceID();
        _ServiceID = 0u;
     }
}

inline bool T_PresetListEntry::hasServiceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_PresetListEntry::getServiceID () const {
    return _ServiceID;
}

inline void T_PresetListEntry::setServiceID (uint16 ServiceID_) {
    set_has_ServiceID();
    this->_ServiceID = ServiceID_;
}

inline void T_PresetListEntry::clearChannelID() {
    if (hasChannelID()) {
         clear_has_ChannelID();
        _ChannelID = 0u;
     }
}

inline bool T_PresetListEntry::hasChannelID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_PresetListEntry::getChannelID () const {
    return _ChannelID;
}

inline void T_PresetListEntry::setChannelID (uint16 ChannelID_) {
    set_has_ChannelID();
    this->_ChannelID = ChannelID_;
}

inline void T_PresetListEntry::clearChannelNameAvail() {
    if (hasChannelNameAvail()) {
         clear_has_ChannelNameAvail();
        _ChannelNameAvail = false;
     }
}

inline bool T_PresetListEntry::hasChannelNameAvail () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_PresetListEntry::getChannelNameAvail () const {
    return _ChannelNameAvail;
}

inline void T_PresetListEntry::setChannelNameAvail (bool ChannelNameAvail_) {
    set_has_ChannelNameAvail();
    this->_ChannelNameAvail = ChannelNameAvail_;
}

inline void T_PresetListEntry::clearChannelName() {
    if (hasChannelName()) {
         clear_has_ChannelName();
        _ChannelName.clear();
     }
}

inline bool T_PresetListEntry::hasChannelName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_PresetListEntry::getChannelName () const {
    return _ChannelName;
}

inline ::std::string& T_PresetListEntry::getChannelNameMutable () {
    set_has_ChannelName();
    return _ChannelName;
}

inline void T_PresetListEntry::setChannelName (const ::std::string& ChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName = ChannelName_;
}

inline void T_PresetListEntry::setChannelName (const char* ChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName.assign(ChannelName_);
}

inline void T_PresetListEntry::setChannelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName.assign(value, size);
}

inline void T_PresetListEntry::clearChannelActive() {
    if (hasChannelActive()) {
         clear_has_ChannelActive();
        _ChannelActive = false;
     }
}

inline bool T_PresetListEntry::hasChannelActive () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_PresetListEntry::getChannelActive () const {
    return _ChannelActive;
}

inline void T_PresetListEntry::setChannelActive (bool ChannelActive_) {
    set_has_ChannelActive();
    this->_ChannelActive = ChannelActive_;
}

inline void T_PresetListEntry::clearChnGraphicAvail() {
    if (hasChnGraphicAvail()) {
         clear_has_ChnGraphicAvail();
        _ChnGraphicAvail = ::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH;
     }
}

inline bool T_PresetListEntry::hasChnGraphicAvail () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_Graphics T_PresetListEntry::getChnGraphicAvail () const {
    return _ChnGraphicAvail;
}

inline void T_PresetListEntry::setChnGraphicAvail (T_e8_Graphics ChnGraphicAvail_) {
    #ifndef NDEBUG
    if (!(T_e8_Graphics_IsValid(ChnGraphicAvail_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChnGraphicAvail_, "T_e8_Graphics", "ChnGraphicAvail", "T_PresetListEntry");
    }
    #endif
    set_has_ChnGraphicAvail();
    this->_ChnGraphicAvail = ChnGraphicAvail_;
}

inline void T_PresetListEntry::clearIsSmartFavorite() {
    if (hasIsSmartFavorite()) {
         clear_has_IsSmartFavorite();
        _IsSmartFavorite = false;
     }
}

inline bool T_PresetListEntry::hasIsSmartFavorite () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_PresetListEntry::getIsSmartFavorite () const {
    return _IsSmartFavorite;
}

inline void T_PresetListEntry::setIsSmartFavorite (bool IsSmartFavorite_) {
    set_has_IsSmartFavorite();
    this->_IsSmartFavorite = IsSmartFavorite_;
}

inline void T_PresetListEntry::clearIsLocked() {
    if (hasIsLocked()) {
         clear_has_IsLocked();
        _IsLocked = false;
     }
}

inline bool T_PresetListEntry::hasIsLocked () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_PresetListEntry::getIsLocked () const {
    return _IsLocked;
}

inline void T_PresetListEntry::setIsLocked (bool IsLocked_) {
    set_has_IsLocked();
    this->_IsLocked = IsLocked_;
}

inline void T_PresetListEntry::clearIsAvailable() {
    if (hasIsAvailable()) {
         clear_has_IsAvailable();
        _IsAvailable = false;
     }
}

inline bool T_PresetListEntry::hasIsAvailable () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_PresetListEntry::getIsAvailable () const {
    return _IsAvailable;
}

inline void T_PresetListEntry::setIsAvailable (bool IsAvailable_) {
    set_has_IsAvailable();
    this->_IsAvailable = IsAvailable_;
}

inline void T_PresetListEntry::clearIsMature() {
    if (hasIsMature()) {
         clear_has_IsMature();
        _IsMature = false;
     }
}

inline bool T_PresetListEntry::hasIsMature () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool T_PresetListEntry::getIsMature () const {
    return _IsMature;
}

inline void T_PresetListEntry::setIsMature (bool IsMature_) {
    set_has_IsMature();
    this->_IsMature = IsMature_;
}

inline void T_PresetListEntry::clearIsSkipped() {
    if (hasIsSkipped()) {
         clear_has_IsSkipped();
        _IsSkipped = false;
     }
}

inline bool T_PresetListEntry::hasIsSkipped () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool T_PresetListEntry::getIsSkipped () const {
    return _IsSkipped;
}

inline void T_PresetListEntry::setIsSkipped (bool IsSkipped_) {
    set_has_IsSkipped();
    this->_IsSkipped = IsSkipped_;
}

inline void T_PresetListEntry::set_has_ServiceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PresetListEntry::clear_has_ServiceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PresetListEntry::set_has_ChannelID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PresetListEntry::clear_has_ChannelID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PresetListEntry::set_has_ChannelNameAvail () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PresetListEntry::clear_has_ChannelNameAvail () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_PresetListEntry::set_has_ChannelName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_PresetListEntry::clear_has_ChannelName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_PresetListEntry::set_has_ChannelActive () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_PresetListEntry::clear_has_ChannelActive () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_PresetListEntry::set_has_ChnGraphicAvail () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_PresetListEntry::clear_has_ChnGraphicAvail () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_PresetListEntry::set_has_IsSmartFavorite () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_PresetListEntry::clear_has_IsSmartFavorite () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_PresetListEntry::set_has_IsLocked () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_PresetListEntry::clear_has_IsLocked () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_PresetListEntry::set_has_IsAvailable () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_PresetListEntry::clear_has_IsAvailable () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_PresetListEntry::set_has_IsMature () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_PresetListEntry::clear_has_IsMature () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_PresetListEntry::set_has_IsSkipped () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_PresetListEntry::clear_has_IsSkipped () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline  T_CategoryListEntry::T_CategoryListEntry ()  :
    _CategoryType (0u),
    _CategoryNameAvail (false),
    _CategoryName (),
    _ChannelList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CategoryListEntry::T_CategoryListEntry (const T_CategoryListEntry &rhs)  :
    _CategoryType (0u),
    _CategoryNameAvail (false),
    _CategoryName (),
    _ChannelList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CategoryListEntry::T_CategoryListEntry (uint16 CategoryType_, bool CategoryNameAvail_, const ::std::string& CategoryName_, const T_ChannelList& ChannelList_)  :
    _CategoryType (CategoryType_),
    _CategoryNameAvail (CategoryNameAvail_),
    _CategoryName (CategoryName_),
    _ChannelList (ChannelList_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CategoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CategoryListEntry::~T_CategoryListEntry() {
}

inline T_CategoryListEntry& T_CategoryListEntry::operator = (const T_CategoryListEntry& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCategoryType()) {
            setCategoryType(rhs.getCategoryType());
        } else {
            clearCategoryType();
        }
        if (rhs.hasCategoryNameAvail()) {
            setCategoryNameAvail(rhs.getCategoryNameAvail());
        } else {
            clearCategoryNameAvail();
        }
        if (rhs.hasCategoryName()) {
            setCategoryName(rhs.getCategoryName());
        } else {
            clearCategoryName();
        }
        if (rhs.hasChannelList()) {
            setChannelList(rhs.getChannelList());
        } else {
            clearChannelList();
        }
    }
    return *this;
}

inline bool T_CategoryListEntry::operator == (const T_CategoryListEntry& rhs) const {
    return (((!hasCategoryType() && !rhs.hasCategoryType()) || getCategoryType() == rhs.getCategoryType()) &&
        ((!hasCategoryNameAvail() && !rhs.hasCategoryNameAvail()) || getCategoryNameAvail() == rhs.getCategoryNameAvail()) &&
        ((!hasCategoryName() && !rhs.hasCategoryName()) || getCategoryName() == rhs.getCategoryName()) &&
        ((!hasChannelList() && !rhs.hasChannelList()) || getChannelList() == rhs.getChannelList()));
}

inline bool T_CategoryListEntry::operator != (const T_CategoryListEntry& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CategoryListEntry::operator < (const T_CategoryListEntry& rhs) const {
    if (hasCategoryType() || rhs.hasCategoryType()) {
        if (getCategoryType() < rhs.getCategoryType()) return true;
        if (getCategoryType() > rhs.getCategoryType()) return false;
    }
    if (hasCategoryNameAvail() || rhs.hasCategoryNameAvail()) {
        if (getCategoryNameAvail() < rhs.getCategoryNameAvail()) return true;
        if (getCategoryNameAvail() > rhs.getCategoryNameAvail()) return false;
    }
    if (hasCategoryName() || rhs.hasCategoryName()) {
        if (getCategoryName() < rhs.getCategoryName()) return true;
        if (getCategoryName() > rhs.getCategoryName()) return false;
    }
    if (hasChannelList() || rhs.hasChannelList()) {
        if (getChannelList() < rhs.getChannelList()) return true;
        if (getChannelList() > rhs.getChannelList()) return false;
    }
    return false;
}

inline bool T_CategoryListEntry::operator > (const T_CategoryListEntry& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CategoryListEntry::clear() {
    clearCategoryType();
    clearCategoryNameAvail();
    clearCategoryName();
    clearChannelList();
}

inline void T_CategoryListEntry::clearCategoryType() {
    if (hasCategoryType()) {
         clear_has_CategoryType();
        _CategoryType = 0u;
     }
}

inline bool T_CategoryListEntry::hasCategoryType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_CategoryListEntry::getCategoryType () const {
    return _CategoryType;
}

inline void T_CategoryListEntry::setCategoryType (uint16 CategoryType_) {
    set_has_CategoryType();
    this->_CategoryType = CategoryType_;
}

inline void T_CategoryListEntry::clearCategoryNameAvail() {
    if (hasCategoryNameAvail()) {
         clear_has_CategoryNameAvail();
        _CategoryNameAvail = false;
     }
}

inline bool T_CategoryListEntry::hasCategoryNameAvail () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_CategoryListEntry::getCategoryNameAvail () const {
    return _CategoryNameAvail;
}

inline void T_CategoryListEntry::setCategoryNameAvail (bool CategoryNameAvail_) {
    set_has_CategoryNameAvail();
    this->_CategoryNameAvail = CategoryNameAvail_;
}

inline void T_CategoryListEntry::clearCategoryName() {
    if (hasCategoryName()) {
         clear_has_CategoryName();
        _CategoryName.clear();
     }
}

inline bool T_CategoryListEntry::hasCategoryName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_CategoryListEntry::getCategoryName () const {
    return _CategoryName;
}

inline ::std::string& T_CategoryListEntry::getCategoryNameMutable () {
    set_has_CategoryName();
    return _CategoryName;
}

inline void T_CategoryListEntry::setCategoryName (const ::std::string& CategoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CategoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CategoryName();
    this->_CategoryName = CategoryName_;
}

inline void T_CategoryListEntry::setCategoryName (const char* CategoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CategoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CategoryName();
    this->_CategoryName.assign(CategoryName_);
}

inline void T_CategoryListEntry::setCategoryName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CategoryName();
    this->_CategoryName.assign(value, size);
}

inline void T_CategoryListEntry::clearChannelList() {
    if (hasChannelList()) {
         clear_has_ChannelList();
        _ChannelList.clear();
     }
}

inline bool T_CategoryListEntry::hasChannelList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_ChannelList& T_CategoryListEntry::getChannelList () const {
    return _ChannelList;
}

inline T_ChannelList& T_CategoryListEntry::getChannelListMutable () {
    set_has_ChannelList();
    return _ChannelList;
}

inline void T_CategoryListEntry::setChannelList (const T_ChannelList& ChannelList_) {
    set_has_ChannelList();
    this->_ChannelList = ChannelList_;
}

inline void T_CategoryListEntry::set_has_CategoryType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CategoryListEntry::clear_has_CategoryType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CategoryListEntry::set_has_CategoryNameAvail () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CategoryListEntry::clear_has_CategoryNameAvail () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_CategoryListEntry::set_has_CategoryName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_CategoryListEntry::clear_has_CategoryName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_CategoryListEntry::set_has_ChannelList () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_CategoryListEntry::clear_has_ChannelList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_ChannelInformation::T_ChannelInformation ()  :
    _ChannelNumber (0u),
    _SID (0u),
    _ChannelNameAvail (false),
    _ChannelName (),
    _CategoryType (0u),
    _PrimaryCategoryType (0u),
    _CategoryNameAvail (false),
    _CategoryName (),
    _ArtistSongnameAvail (false),
    _ArtistNameAvail (false),
    _ArtistName (),
    _SongNameAvail (false),
    _SongName (),
    _ExtSongNameAvail (false),
    _ExtSongName (),
    _ExtArtistNameAvail (false),
    _ExtArtistName (),
    _ChnGraphicAvail (false),
    _ChnArtAvail (::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH),
    _AlbumArtAvail (::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH),
    _IsLocked (false),
    _IsAvailable (false),
    _IsMature (false),
    _IsSkipped (false),
    _ArtistAlertStatus (false),
    _SongAlertStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ChannelInformation::T_ChannelInformation (const T_ChannelInformation &rhs)  :
    _ChannelNumber (0u),
    _SID (0u),
    _ChannelNameAvail (false),
    _ChannelName (),
    _CategoryType (0u),
    _PrimaryCategoryType (0u),
    _CategoryNameAvail (false),
    _CategoryName (),
    _ArtistSongnameAvail (false),
    _ArtistNameAvail (false),
    _ArtistName (),
    _SongNameAvail (false),
    _SongName (),
    _ExtSongNameAvail (false),
    _ExtSongName (),
    _ExtArtistNameAvail (false),
    _ExtArtistName (),
    _ChnGraphicAvail (false),
    _ChnArtAvail (::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH),
    _AlbumArtAvail (::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH),
    _IsLocked (false),
    _IsAvailable (false),
    _IsMature (false),
    _IsSkipped (false),
    _ArtistAlertStatus (false),
    _SongAlertStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ChannelInformation::T_ChannelInformation (uint16 ChannelNumber_, uint16 SID_, bool ChannelNameAvail_, const ::std::string& ChannelName_, uint16 CategoryType_, uint16 PrimaryCategoryType_, bool CategoryNameAvail_, const ::std::string& CategoryName_, bool ArtistSongnameAvail_, bool ArtistNameAvail_, const ::std::string& ArtistName_, bool SongNameAvail_, const ::std::string& SongName_, bool ExtSongNameAvail_, const ::std::string& ExtSongName_, bool ExtArtistNameAvail_, const ::std::string& ExtArtistName_, bool ChnGraphicAvail_, T_e8_Graphics ChnArtAvail_, T_e8_Graphics AlbumArtAvail_, bool IsLocked_, bool IsAvailable_, bool IsMature_, bool IsSkipped_, bool ArtistAlertStatus_, bool SongAlertStatus_)  :
    _ChannelNumber (ChannelNumber_),
    _SID (SID_),
    _ChannelNameAvail (ChannelNameAvail_),
    _ChannelName (ChannelName_),
    _CategoryType (CategoryType_),
    _PrimaryCategoryType (PrimaryCategoryType_),
    _CategoryNameAvail (CategoryNameAvail_),
    _CategoryName (CategoryName_),
    _ArtistSongnameAvail (ArtistSongnameAvail_),
    _ArtistNameAvail (ArtistNameAvail_),
    _ArtistName (ArtistName_),
    _SongNameAvail (SongNameAvail_),
    _SongName (SongName_),
    _ExtSongNameAvail (ExtSongNameAvail_),
    _ExtSongName (ExtSongName_),
    _ExtArtistNameAvail (ExtArtistNameAvail_),
    _ExtArtistName (ExtArtistName_),
    _ChnGraphicAvail (ChnGraphicAvail_),
    _ChnArtAvail (ChnArtAvail_),
    _AlbumArtAvail (AlbumArtAvail_),
    _IsLocked (IsLocked_),
    _IsAvailable (IsAvailable_),
    _IsMature (IsMature_),
    _IsSkipped (IsSkipped_),
    _ArtistAlertStatus (ArtistAlertStatus_),
    _SongAlertStatus (SongAlertStatus_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CategoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SongName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ExtSongName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ExtArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_Graphics_IsValid(ChnArtAvail_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChnArtAvail_, "T_e8_Graphics", "ChnArtAvail", "T_ChannelInformation");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_Graphics_IsValid(AlbumArtAvail_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AlbumArtAvail_, "T_e8_Graphics", "AlbumArtAvail", "T_ChannelInformation");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ChannelInformation::~T_ChannelInformation() {
}

inline T_ChannelInformation& T_ChannelInformation::operator = (const T_ChannelInformation& rhs) {
    if( this != &rhs ) {
        if (rhs.hasChannelNumber()) {
            setChannelNumber(rhs.getChannelNumber());
        } else {
            clearChannelNumber();
        }
        if (rhs.hasSID()) {
            setSID(rhs.getSID());
        } else {
            clearSID();
        }
        if (rhs.hasChannelNameAvail()) {
            setChannelNameAvail(rhs.getChannelNameAvail());
        } else {
            clearChannelNameAvail();
        }
        if (rhs.hasChannelName()) {
            setChannelName(rhs.getChannelName());
        } else {
            clearChannelName();
        }
        if (rhs.hasCategoryType()) {
            setCategoryType(rhs.getCategoryType());
        } else {
            clearCategoryType();
        }
        if (rhs.hasPrimaryCategoryType()) {
            setPrimaryCategoryType(rhs.getPrimaryCategoryType());
        } else {
            clearPrimaryCategoryType();
        }
        if (rhs.hasCategoryNameAvail()) {
            setCategoryNameAvail(rhs.getCategoryNameAvail());
        } else {
            clearCategoryNameAvail();
        }
        if (rhs.hasCategoryName()) {
            setCategoryName(rhs.getCategoryName());
        } else {
            clearCategoryName();
        }
        if (rhs.hasArtistSongnameAvail()) {
            setArtistSongnameAvail(rhs.getArtistSongnameAvail());
        } else {
            clearArtistSongnameAvail();
        }
        if (rhs.hasArtistNameAvail()) {
            setArtistNameAvail(rhs.getArtistNameAvail());
        } else {
            clearArtistNameAvail();
        }
        if (rhs.hasArtistName()) {
            setArtistName(rhs.getArtistName());
        } else {
            clearArtistName();
        }
        if (rhs.hasSongNameAvail()) {
            setSongNameAvail(rhs.getSongNameAvail());
        } else {
            clearSongNameAvail();
        }
        if (rhs.hasSongName()) {
            setSongName(rhs.getSongName());
        } else {
            clearSongName();
        }
        if (rhs.hasExtSongNameAvail()) {
            setExtSongNameAvail(rhs.getExtSongNameAvail());
        } else {
            clearExtSongNameAvail();
        }
        if (rhs.hasExtSongName()) {
            setExtSongName(rhs.getExtSongName());
        } else {
            clearExtSongName();
        }
        if (rhs.hasExtArtistNameAvail()) {
            setExtArtistNameAvail(rhs.getExtArtistNameAvail());
        } else {
            clearExtArtistNameAvail();
        }
        if (rhs.hasExtArtistName()) {
            setExtArtistName(rhs.getExtArtistName());
        } else {
            clearExtArtistName();
        }
        if (rhs.hasChnGraphicAvail()) {
            setChnGraphicAvail(rhs.getChnGraphicAvail());
        } else {
            clearChnGraphicAvail();
        }
        if (rhs.hasChnArtAvail()) {
            setChnArtAvail(rhs.getChnArtAvail());
        } else {
            clearChnArtAvail();
        }
        if (rhs.hasAlbumArtAvail()) {
            setAlbumArtAvail(rhs.getAlbumArtAvail());
        } else {
            clearAlbumArtAvail();
        }
        if (rhs.hasIsLocked()) {
            setIsLocked(rhs.getIsLocked());
        } else {
            clearIsLocked();
        }
        if (rhs.hasIsAvailable()) {
            setIsAvailable(rhs.getIsAvailable());
        } else {
            clearIsAvailable();
        }
        if (rhs.hasIsMature()) {
            setIsMature(rhs.getIsMature());
        } else {
            clearIsMature();
        }
        if (rhs.hasIsSkipped()) {
            setIsSkipped(rhs.getIsSkipped());
        } else {
            clearIsSkipped();
        }
        if (rhs.hasArtistAlertStatus()) {
            setArtistAlertStatus(rhs.getArtistAlertStatus());
        } else {
            clearArtistAlertStatus();
        }
        if (rhs.hasSongAlertStatus()) {
            setSongAlertStatus(rhs.getSongAlertStatus());
        } else {
            clearSongAlertStatus();
        }
    }
    return *this;
}

inline bool T_ChannelInformation::operator == (const T_ChannelInformation& rhs) const {
    return (((!hasChannelNumber() && !rhs.hasChannelNumber()) || getChannelNumber() == rhs.getChannelNumber()) &&
        ((!hasSID() && !rhs.hasSID()) || getSID() == rhs.getSID()) &&
        ((!hasChannelNameAvail() && !rhs.hasChannelNameAvail()) || getChannelNameAvail() == rhs.getChannelNameAvail()) &&
        ((!hasChannelName() && !rhs.hasChannelName()) || getChannelName() == rhs.getChannelName()) &&
        ((!hasCategoryType() && !rhs.hasCategoryType()) || getCategoryType() == rhs.getCategoryType()) &&
        ((!hasPrimaryCategoryType() && !rhs.hasPrimaryCategoryType()) || getPrimaryCategoryType() == rhs.getPrimaryCategoryType()) &&
        ((!hasCategoryNameAvail() && !rhs.hasCategoryNameAvail()) || getCategoryNameAvail() == rhs.getCategoryNameAvail()) &&
        ((!hasCategoryName() && !rhs.hasCategoryName()) || getCategoryName() == rhs.getCategoryName()) &&
        ((!hasArtistSongnameAvail() && !rhs.hasArtistSongnameAvail()) || getArtistSongnameAvail() == rhs.getArtistSongnameAvail()) &&
        ((!hasArtistNameAvail() && !rhs.hasArtistNameAvail()) || getArtistNameAvail() == rhs.getArtistNameAvail()) &&
        ((!hasArtistName() && !rhs.hasArtistName()) || getArtistName() == rhs.getArtistName()) &&
        ((!hasSongNameAvail() && !rhs.hasSongNameAvail()) || getSongNameAvail() == rhs.getSongNameAvail()) &&
        ((!hasSongName() && !rhs.hasSongName()) || getSongName() == rhs.getSongName()) &&
        ((!hasExtSongNameAvail() && !rhs.hasExtSongNameAvail()) || getExtSongNameAvail() == rhs.getExtSongNameAvail()) &&
        ((!hasExtSongName() && !rhs.hasExtSongName()) || getExtSongName() == rhs.getExtSongName()) &&
        ((!hasExtArtistNameAvail() && !rhs.hasExtArtistNameAvail()) || getExtArtistNameAvail() == rhs.getExtArtistNameAvail()) &&
        ((!hasExtArtistName() && !rhs.hasExtArtistName()) || getExtArtistName() == rhs.getExtArtistName()) &&
        ((!hasChnGraphicAvail() && !rhs.hasChnGraphicAvail()) || getChnGraphicAvail() == rhs.getChnGraphicAvail()) &&
        ((!hasChnArtAvail() && !rhs.hasChnArtAvail()) || getChnArtAvail() == rhs.getChnArtAvail()) &&
        ((!hasAlbumArtAvail() && !rhs.hasAlbumArtAvail()) || getAlbumArtAvail() == rhs.getAlbumArtAvail()) &&
        ((!hasIsLocked() && !rhs.hasIsLocked()) || getIsLocked() == rhs.getIsLocked()) &&
        ((!hasIsAvailable() && !rhs.hasIsAvailable()) || getIsAvailable() == rhs.getIsAvailable()) &&
        ((!hasIsMature() && !rhs.hasIsMature()) || getIsMature() == rhs.getIsMature()) &&
        ((!hasIsSkipped() && !rhs.hasIsSkipped()) || getIsSkipped() == rhs.getIsSkipped()) &&
        ((!hasArtistAlertStatus() && !rhs.hasArtistAlertStatus()) || getArtistAlertStatus() == rhs.getArtistAlertStatus()) &&
        ((!hasSongAlertStatus() && !rhs.hasSongAlertStatus()) || getSongAlertStatus() == rhs.getSongAlertStatus()));
}

inline bool T_ChannelInformation::operator != (const T_ChannelInformation& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ChannelInformation::operator < (const T_ChannelInformation& rhs) const {
    if (hasChannelNumber() || rhs.hasChannelNumber()) {
        if (getChannelNumber() < rhs.getChannelNumber()) return true;
        if (getChannelNumber() > rhs.getChannelNumber()) return false;
    }
    if (hasSID() || rhs.hasSID()) {
        if (getSID() < rhs.getSID()) return true;
        if (getSID() > rhs.getSID()) return false;
    }
    if (hasChannelNameAvail() || rhs.hasChannelNameAvail()) {
        if (getChannelNameAvail() < rhs.getChannelNameAvail()) return true;
        if (getChannelNameAvail() > rhs.getChannelNameAvail()) return false;
    }
    if (hasChannelName() || rhs.hasChannelName()) {
        if (getChannelName() < rhs.getChannelName()) return true;
        if (getChannelName() > rhs.getChannelName()) return false;
    }
    if (hasCategoryType() || rhs.hasCategoryType()) {
        if (getCategoryType() < rhs.getCategoryType()) return true;
        if (getCategoryType() > rhs.getCategoryType()) return false;
    }
    if (hasPrimaryCategoryType() || rhs.hasPrimaryCategoryType()) {
        if (getPrimaryCategoryType() < rhs.getPrimaryCategoryType()) return true;
        if (getPrimaryCategoryType() > rhs.getPrimaryCategoryType()) return false;
    }
    if (hasCategoryNameAvail() || rhs.hasCategoryNameAvail()) {
        if (getCategoryNameAvail() < rhs.getCategoryNameAvail()) return true;
        if (getCategoryNameAvail() > rhs.getCategoryNameAvail()) return false;
    }
    if (hasCategoryName() || rhs.hasCategoryName()) {
        if (getCategoryName() < rhs.getCategoryName()) return true;
        if (getCategoryName() > rhs.getCategoryName()) return false;
    }
    if (hasArtistSongnameAvail() || rhs.hasArtistSongnameAvail()) {
        if (getArtistSongnameAvail() < rhs.getArtistSongnameAvail()) return true;
        if (getArtistSongnameAvail() > rhs.getArtistSongnameAvail()) return false;
    }
    if (hasArtistNameAvail() || rhs.hasArtistNameAvail()) {
        if (getArtistNameAvail() < rhs.getArtistNameAvail()) return true;
        if (getArtistNameAvail() > rhs.getArtistNameAvail()) return false;
    }
    if (hasArtistName() || rhs.hasArtistName()) {
        if (getArtistName() < rhs.getArtistName()) return true;
        if (getArtistName() > rhs.getArtistName()) return false;
    }
    if (hasSongNameAvail() || rhs.hasSongNameAvail()) {
        if (getSongNameAvail() < rhs.getSongNameAvail()) return true;
        if (getSongNameAvail() > rhs.getSongNameAvail()) return false;
    }
    if (hasSongName() || rhs.hasSongName()) {
        if (getSongName() < rhs.getSongName()) return true;
        if (getSongName() > rhs.getSongName()) return false;
    }
    if (hasExtSongNameAvail() || rhs.hasExtSongNameAvail()) {
        if (getExtSongNameAvail() < rhs.getExtSongNameAvail()) return true;
        if (getExtSongNameAvail() > rhs.getExtSongNameAvail()) return false;
    }
    if (hasExtSongName() || rhs.hasExtSongName()) {
        if (getExtSongName() < rhs.getExtSongName()) return true;
        if (getExtSongName() > rhs.getExtSongName()) return false;
    }
    if (hasExtArtistNameAvail() || rhs.hasExtArtistNameAvail()) {
        if (getExtArtistNameAvail() < rhs.getExtArtistNameAvail()) return true;
        if (getExtArtistNameAvail() > rhs.getExtArtistNameAvail()) return false;
    }
    if (hasExtArtistName() || rhs.hasExtArtistName()) {
        if (getExtArtistName() < rhs.getExtArtistName()) return true;
        if (getExtArtistName() > rhs.getExtArtistName()) return false;
    }
    if (hasChnGraphicAvail() || rhs.hasChnGraphicAvail()) {
        if (getChnGraphicAvail() < rhs.getChnGraphicAvail()) return true;
        if (getChnGraphicAvail() > rhs.getChnGraphicAvail()) return false;
    }
    if (hasChnArtAvail() || rhs.hasChnArtAvail()) {
        if ((uint32)getChnArtAvail() < (uint32)rhs.getChnArtAvail()) return true;
        if ((uint32)getChnArtAvail() > (uint32)rhs.getChnArtAvail()) return false;
    }
    if (hasAlbumArtAvail() || rhs.hasAlbumArtAvail()) {
        if ((uint32)getAlbumArtAvail() < (uint32)rhs.getAlbumArtAvail()) return true;
        if ((uint32)getAlbumArtAvail() > (uint32)rhs.getAlbumArtAvail()) return false;
    }
    if (hasIsLocked() || rhs.hasIsLocked()) {
        if (getIsLocked() < rhs.getIsLocked()) return true;
        if (getIsLocked() > rhs.getIsLocked()) return false;
    }
    if (hasIsAvailable() || rhs.hasIsAvailable()) {
        if (getIsAvailable() < rhs.getIsAvailable()) return true;
        if (getIsAvailable() > rhs.getIsAvailable()) return false;
    }
    if (hasIsMature() || rhs.hasIsMature()) {
        if (getIsMature() < rhs.getIsMature()) return true;
        if (getIsMature() > rhs.getIsMature()) return false;
    }
    if (hasIsSkipped() || rhs.hasIsSkipped()) {
        if (getIsSkipped() < rhs.getIsSkipped()) return true;
        if (getIsSkipped() > rhs.getIsSkipped()) return false;
    }
    if (hasArtistAlertStatus() || rhs.hasArtistAlertStatus()) {
        if (getArtistAlertStatus() < rhs.getArtistAlertStatus()) return true;
        if (getArtistAlertStatus() > rhs.getArtistAlertStatus()) return false;
    }
    if (hasSongAlertStatus() || rhs.hasSongAlertStatus()) {
        if (getSongAlertStatus() < rhs.getSongAlertStatus()) return true;
        if (getSongAlertStatus() > rhs.getSongAlertStatus()) return false;
    }
    return false;
}

inline bool T_ChannelInformation::operator > (const T_ChannelInformation& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ChannelInformation::clear() {
    clearChannelNumber();
    clearSID();
    clearChannelNameAvail();
    clearChannelName();
    clearCategoryType();
    clearPrimaryCategoryType();
    clearCategoryNameAvail();
    clearCategoryName();
    clearArtistSongnameAvail();
    clearArtistNameAvail();
    clearArtistName();
    clearSongNameAvail();
    clearSongName();
    clearExtSongNameAvail();
    clearExtSongName();
    clearExtArtistNameAvail();
    clearExtArtistName();
    clearChnGraphicAvail();
    clearChnArtAvail();
    clearAlbumArtAvail();
    clearIsLocked();
    clearIsAvailable();
    clearIsMature();
    clearIsSkipped();
    clearArtistAlertStatus();
    clearSongAlertStatus();
}

inline void T_ChannelInformation::clearChannelNumber() {
    if (hasChannelNumber()) {
         clear_has_ChannelNumber();
        _ChannelNumber = 0u;
     }
}

inline bool T_ChannelInformation::hasChannelNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_ChannelInformation::getChannelNumber () const {
    return _ChannelNumber;
}

inline void T_ChannelInformation::setChannelNumber (uint16 ChannelNumber_) {
    set_has_ChannelNumber();
    this->_ChannelNumber = ChannelNumber_;
}

inline void T_ChannelInformation::clearSID() {
    if (hasSID()) {
         clear_has_SID();
        _SID = 0u;
     }
}

inline bool T_ChannelInformation::hasSID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_ChannelInformation::getSID () const {
    return _SID;
}

inline void T_ChannelInformation::setSID (uint16 SID_) {
    set_has_SID();
    this->_SID = SID_;
}

inline void T_ChannelInformation::clearChannelNameAvail() {
    if (hasChannelNameAvail()) {
         clear_has_ChannelNameAvail();
        _ChannelNameAvail = false;
     }
}

inline bool T_ChannelInformation::hasChannelNameAvail () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_ChannelInformation::getChannelNameAvail () const {
    return _ChannelNameAvail;
}

inline void T_ChannelInformation::setChannelNameAvail (bool ChannelNameAvail_) {
    set_has_ChannelNameAvail();
    this->_ChannelNameAvail = ChannelNameAvail_;
}

inline void T_ChannelInformation::clearChannelName() {
    if (hasChannelName()) {
         clear_has_ChannelName();
        _ChannelName.clear();
     }
}

inline bool T_ChannelInformation::hasChannelName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_ChannelInformation::getChannelName () const {
    return _ChannelName;
}

inline ::std::string& T_ChannelInformation::getChannelNameMutable () {
    set_has_ChannelName();
    return _ChannelName;
}

inline void T_ChannelInformation::setChannelName (const ::std::string& ChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName = ChannelName_;
}

inline void T_ChannelInformation::setChannelName (const char* ChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName.assign(ChannelName_);
}

inline void T_ChannelInformation::setChannelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName.assign(value, size);
}

inline void T_ChannelInformation::clearCategoryType() {
    if (hasCategoryType()) {
         clear_has_CategoryType();
        _CategoryType = 0u;
     }
}

inline bool T_ChannelInformation::hasCategoryType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 T_ChannelInformation::getCategoryType () const {
    return _CategoryType;
}

inline void T_ChannelInformation::setCategoryType (uint16 CategoryType_) {
    set_has_CategoryType();
    this->_CategoryType = CategoryType_;
}

inline void T_ChannelInformation::clearPrimaryCategoryType() {
    if (hasPrimaryCategoryType()) {
         clear_has_PrimaryCategoryType();
        _PrimaryCategoryType = 0u;
     }
}

inline bool T_ChannelInformation::hasPrimaryCategoryType () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 T_ChannelInformation::getPrimaryCategoryType () const {
    return _PrimaryCategoryType;
}

inline void T_ChannelInformation::setPrimaryCategoryType (uint16 PrimaryCategoryType_) {
    set_has_PrimaryCategoryType();
    this->_PrimaryCategoryType = PrimaryCategoryType_;
}

inline void T_ChannelInformation::clearCategoryNameAvail() {
    if (hasCategoryNameAvail()) {
         clear_has_CategoryNameAvail();
        _CategoryNameAvail = false;
     }
}

inline bool T_ChannelInformation::hasCategoryNameAvail () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_ChannelInformation::getCategoryNameAvail () const {
    return _CategoryNameAvail;
}

inline void T_ChannelInformation::setCategoryNameAvail (bool CategoryNameAvail_) {
    set_has_CategoryNameAvail();
    this->_CategoryNameAvail = CategoryNameAvail_;
}

inline void T_ChannelInformation::clearCategoryName() {
    if (hasCategoryName()) {
         clear_has_CategoryName();
        _CategoryName.clear();
     }
}

inline bool T_ChannelInformation::hasCategoryName () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_ChannelInformation::getCategoryName () const {
    return _CategoryName;
}

inline ::std::string& T_ChannelInformation::getCategoryNameMutable () {
    set_has_CategoryName();
    return _CategoryName;
}

inline void T_ChannelInformation::setCategoryName (const ::std::string& CategoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CategoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CategoryName();
    this->_CategoryName = CategoryName_;
}

inline void T_ChannelInformation::setCategoryName (const char* CategoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CategoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CategoryName();
    this->_CategoryName.assign(CategoryName_);
}

inline void T_ChannelInformation::setCategoryName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CategoryName();
    this->_CategoryName.assign(value, size);
}

inline void T_ChannelInformation::clearArtistSongnameAvail() {
    if (hasArtistSongnameAvail()) {
         clear_has_ArtistSongnameAvail();
        _ArtistSongnameAvail = false;
     }
}

inline bool T_ChannelInformation::hasArtistSongnameAvail () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_ChannelInformation::getArtistSongnameAvail () const {
    return _ArtistSongnameAvail;
}

inline void T_ChannelInformation::setArtistSongnameAvail (bool ArtistSongnameAvail_) {
    set_has_ArtistSongnameAvail();
    this->_ArtistSongnameAvail = ArtistSongnameAvail_;
}

inline void T_ChannelInformation::clearArtistNameAvail() {
    if (hasArtistNameAvail()) {
         clear_has_ArtistNameAvail();
        _ArtistNameAvail = false;
     }
}

inline bool T_ChannelInformation::hasArtistNameAvail () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool T_ChannelInformation::getArtistNameAvail () const {
    return _ArtistNameAvail;
}

inline void T_ChannelInformation::setArtistNameAvail (bool ArtistNameAvail_) {
    set_has_ArtistNameAvail();
    this->_ArtistNameAvail = ArtistNameAvail_;
}

inline void T_ChannelInformation::clearArtistName() {
    if (hasArtistName()) {
         clear_has_ArtistName();
        _ArtistName.clear();
     }
}

inline bool T_ChannelInformation::hasArtistName () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_ChannelInformation::getArtistName () const {
    return _ArtistName;
}

inline ::std::string& T_ChannelInformation::getArtistNameMutable () {
    set_has_ArtistName();
    return _ArtistName;
}

inline void T_ChannelInformation::setArtistName (const ::std::string& ArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ArtistName();
    this->_ArtistName = ArtistName_;
}

inline void T_ChannelInformation::setArtistName (const char* ArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ArtistName();
    this->_ArtistName.assign(ArtistName_);
}

inline void T_ChannelInformation::setArtistName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ArtistName();
    this->_ArtistName.assign(value, size);
}

inline void T_ChannelInformation::clearSongNameAvail() {
    if (hasSongNameAvail()) {
         clear_has_SongNameAvail();
        _SongNameAvail = false;
     }
}

inline bool T_ChannelInformation::hasSongNameAvail () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline bool T_ChannelInformation::getSongNameAvail () const {
    return _SongNameAvail;
}

inline void T_ChannelInformation::setSongNameAvail (bool SongNameAvail_) {
    set_has_SongNameAvail();
    this->_SongNameAvail = SongNameAvail_;
}

inline void T_ChannelInformation::clearSongName() {
    if (hasSongName()) {
         clear_has_SongName();
        _SongName.clear();
     }
}

inline bool T_ChannelInformation::hasSongName () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::string& T_ChannelInformation::getSongName () const {
    return _SongName;
}

inline ::std::string& T_ChannelInformation::getSongNameMutable () {
    set_has_SongName();
    return _SongName;
}

inline void T_ChannelInformation::setSongName (const ::std::string& SongName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SongName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SongName();
    this->_SongName = SongName_;
}

inline void T_ChannelInformation::setSongName (const char* SongName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SongName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SongName();
    this->_SongName.assign(SongName_);
}

inline void T_ChannelInformation::setSongName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SongName();
    this->_SongName.assign(value, size);
}

inline void T_ChannelInformation::clearExtSongNameAvail() {
    if (hasExtSongNameAvail()) {
         clear_has_ExtSongNameAvail();
        _ExtSongNameAvail = false;
     }
}

inline bool T_ChannelInformation::hasExtSongNameAvail () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline bool T_ChannelInformation::getExtSongNameAvail () const {
    return _ExtSongNameAvail;
}

inline void T_ChannelInformation::setExtSongNameAvail (bool ExtSongNameAvail_) {
    set_has_ExtSongNameAvail();
    this->_ExtSongNameAvail = ExtSongNameAvail_;
}

inline void T_ChannelInformation::clearExtSongName() {
    if (hasExtSongName()) {
         clear_has_ExtSongName();
        _ExtSongName.clear();
     }
}

inline bool T_ChannelInformation::hasExtSongName () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const ::std::string& T_ChannelInformation::getExtSongName () const {
    return _ExtSongName;
}

inline ::std::string& T_ChannelInformation::getExtSongNameMutable () {
    set_has_ExtSongName();
    return _ExtSongName;
}

inline void T_ChannelInformation::setExtSongName (const ::std::string& ExtSongName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ExtSongName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ExtSongName();
    this->_ExtSongName = ExtSongName_;
}

inline void T_ChannelInformation::setExtSongName (const char* ExtSongName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ExtSongName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ExtSongName();
    this->_ExtSongName.assign(ExtSongName_);
}

inline void T_ChannelInformation::setExtSongName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ExtSongName();
    this->_ExtSongName.assign(value, size);
}

inline void T_ChannelInformation::clearExtArtistNameAvail() {
    if (hasExtArtistNameAvail()) {
         clear_has_ExtArtistNameAvail();
        _ExtArtistNameAvail = false;
     }
}

inline bool T_ChannelInformation::hasExtArtistNameAvail () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline bool T_ChannelInformation::getExtArtistNameAvail () const {
    return _ExtArtistNameAvail;
}

inline void T_ChannelInformation::setExtArtistNameAvail (bool ExtArtistNameAvail_) {
    set_has_ExtArtistNameAvail();
    this->_ExtArtistNameAvail = ExtArtistNameAvail_;
}

inline void T_ChannelInformation::clearExtArtistName() {
    if (hasExtArtistName()) {
         clear_has_ExtArtistName();
        _ExtArtistName.clear();
     }
}

inline bool T_ChannelInformation::hasExtArtistName () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline const ::std::string& T_ChannelInformation::getExtArtistName () const {
    return _ExtArtistName;
}

inline ::std::string& T_ChannelInformation::getExtArtistNameMutable () {
    set_has_ExtArtistName();
    return _ExtArtistName;
}

inline void T_ChannelInformation::setExtArtistName (const ::std::string& ExtArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ExtArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ExtArtistName();
    this->_ExtArtistName = ExtArtistName_;
}

inline void T_ChannelInformation::setExtArtistName (const char* ExtArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ExtArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ExtArtistName();
    this->_ExtArtistName.assign(ExtArtistName_);
}

inline void T_ChannelInformation::setExtArtistName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ExtArtistName();
    this->_ExtArtistName.assign(value, size);
}

inline void T_ChannelInformation::clearChnGraphicAvail() {
    if (hasChnGraphicAvail()) {
         clear_has_ChnGraphicAvail();
        _ChnGraphicAvail = false;
     }
}

inline bool T_ChannelInformation::hasChnGraphicAvail () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline bool T_ChannelInformation::getChnGraphicAvail () const {
    return _ChnGraphicAvail;
}

inline void T_ChannelInformation::setChnGraphicAvail (bool ChnGraphicAvail_) {
    set_has_ChnGraphicAvail();
    this->_ChnGraphicAvail = ChnGraphicAvail_;
}

inline void T_ChannelInformation::clearChnArtAvail() {
    if (hasChnArtAvail()) {
         clear_has_ChnArtAvail();
        _ChnArtAvail = ::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH;
     }
}

inline bool T_ChannelInformation::hasChnArtAvail () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline T_e8_Graphics T_ChannelInformation::getChnArtAvail () const {
    return _ChnArtAvail;
}

inline void T_ChannelInformation::setChnArtAvail (T_e8_Graphics ChnArtAvail_) {
    #ifndef NDEBUG
    if (!(T_e8_Graphics_IsValid(ChnArtAvail_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChnArtAvail_, "T_e8_Graphics", "ChnArtAvail", "T_ChannelInformation");
    }
    #endif
    set_has_ChnArtAvail();
    this->_ChnArtAvail = ChnArtAvail_;
}

inline void T_ChannelInformation::clearAlbumArtAvail() {
    if (hasAlbumArtAvail()) {
         clear_has_AlbumArtAvail();
        _AlbumArtAvail = ::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH;
     }
}

inline bool T_ChannelInformation::hasAlbumArtAvail () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline T_e8_Graphics T_ChannelInformation::getAlbumArtAvail () const {
    return _AlbumArtAvail;
}

inline void T_ChannelInformation::setAlbumArtAvail (T_e8_Graphics AlbumArtAvail_) {
    #ifndef NDEBUG
    if (!(T_e8_Graphics_IsValid(AlbumArtAvail_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AlbumArtAvail_, "T_e8_Graphics", "AlbumArtAvail", "T_ChannelInformation");
    }
    #endif
    set_has_AlbumArtAvail();
    this->_AlbumArtAvail = AlbumArtAvail_;
}

inline void T_ChannelInformation::clearIsLocked() {
    if (hasIsLocked()) {
         clear_has_IsLocked();
        _IsLocked = false;
     }
}

inline bool T_ChannelInformation::hasIsLocked () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline bool T_ChannelInformation::getIsLocked () const {
    return _IsLocked;
}

inline void T_ChannelInformation::setIsLocked (bool IsLocked_) {
    set_has_IsLocked();
    this->_IsLocked = IsLocked_;
}

inline void T_ChannelInformation::clearIsAvailable() {
    if (hasIsAvailable()) {
         clear_has_IsAvailable();
        _IsAvailable = false;
     }
}

inline bool T_ChannelInformation::hasIsAvailable () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline bool T_ChannelInformation::getIsAvailable () const {
    return _IsAvailable;
}

inline void T_ChannelInformation::setIsAvailable (bool IsAvailable_) {
    set_has_IsAvailable();
    this->_IsAvailable = IsAvailable_;
}

inline void T_ChannelInformation::clearIsMature() {
    if (hasIsMature()) {
         clear_has_IsMature();
        _IsMature = false;
     }
}

inline bool T_ChannelInformation::hasIsMature () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline bool T_ChannelInformation::getIsMature () const {
    return _IsMature;
}

inline void T_ChannelInformation::setIsMature (bool IsMature_) {
    set_has_IsMature();
    this->_IsMature = IsMature_;
}

inline void T_ChannelInformation::clearIsSkipped() {
    if (hasIsSkipped()) {
         clear_has_IsSkipped();
        _IsSkipped = false;
     }
}

inline bool T_ChannelInformation::hasIsSkipped () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline bool T_ChannelInformation::getIsSkipped () const {
    return _IsSkipped;
}

inline void T_ChannelInformation::setIsSkipped (bool IsSkipped_) {
    set_has_IsSkipped();
    this->_IsSkipped = IsSkipped_;
}

inline void T_ChannelInformation::clearArtistAlertStatus() {
    if (hasArtistAlertStatus()) {
         clear_has_ArtistAlertStatus();
        _ArtistAlertStatus = false;
     }
}

inline bool T_ChannelInformation::hasArtistAlertStatus () const {
    return (_has_bits_[0] & (1u << 24)) > 0;
}

inline bool T_ChannelInformation::getArtistAlertStatus () const {
    return _ArtistAlertStatus;
}

inline void T_ChannelInformation::setArtistAlertStatus (bool ArtistAlertStatus_) {
    set_has_ArtistAlertStatus();
    this->_ArtistAlertStatus = ArtistAlertStatus_;
}

inline void T_ChannelInformation::clearSongAlertStatus() {
    if (hasSongAlertStatus()) {
         clear_has_SongAlertStatus();
        _SongAlertStatus = false;
     }
}

inline bool T_ChannelInformation::hasSongAlertStatus () const {
    return (_has_bits_[0] & (1u << 25)) > 0;
}

inline bool T_ChannelInformation::getSongAlertStatus () const {
    return _SongAlertStatus;
}

inline void T_ChannelInformation::setSongAlertStatus (bool SongAlertStatus_) {
    set_has_SongAlertStatus();
    this->_SongAlertStatus = SongAlertStatus_;
}

inline void T_ChannelInformation::set_has_ChannelNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ChannelInformation::clear_has_ChannelNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ChannelInformation::set_has_SID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ChannelInformation::clear_has_SID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ChannelInformation::set_has_ChannelNameAvail () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ChannelInformation::clear_has_ChannelNameAvail () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_ChannelInformation::set_has_ChannelName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_ChannelInformation::clear_has_ChannelName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_ChannelInformation::set_has_CategoryType () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_ChannelInformation::clear_has_CategoryType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_ChannelInformation::set_has_PrimaryCategoryType () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_ChannelInformation::clear_has_PrimaryCategoryType () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_ChannelInformation::set_has_CategoryNameAvail () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_ChannelInformation::clear_has_CategoryNameAvail () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_ChannelInformation::set_has_CategoryName () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_ChannelInformation::clear_has_CategoryName () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_ChannelInformation::set_has_ArtistSongnameAvail () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_ChannelInformation::clear_has_ArtistSongnameAvail () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_ChannelInformation::set_has_ArtistNameAvail () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_ChannelInformation::clear_has_ArtistNameAvail () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_ChannelInformation::set_has_ArtistName () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_ChannelInformation::clear_has_ArtistName () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_ChannelInformation::set_has_SongNameAvail () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_ChannelInformation::clear_has_SongNameAvail () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_ChannelInformation::set_has_SongName () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_ChannelInformation::clear_has_SongName () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_ChannelInformation::set_has_ExtSongNameAvail () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_ChannelInformation::clear_has_ExtSongNameAvail () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_ChannelInformation::set_has_ExtSongName () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_ChannelInformation::clear_has_ExtSongName () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_ChannelInformation::set_has_ExtArtistNameAvail () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_ChannelInformation::clear_has_ExtArtistNameAvail () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_ChannelInformation::set_has_ExtArtistName () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_ChannelInformation::clear_has_ExtArtistName () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_ChannelInformation::set_has_ChnGraphicAvail () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_ChannelInformation::clear_has_ChnGraphicAvail () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_ChannelInformation::set_has_ChnArtAvail () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_ChannelInformation::clear_has_ChnArtAvail () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_ChannelInformation::set_has_AlbumArtAvail () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_ChannelInformation::clear_has_AlbumArtAvail () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_ChannelInformation::set_has_IsLocked () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_ChannelInformation::clear_has_IsLocked () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_ChannelInformation::set_has_IsAvailable () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_ChannelInformation::clear_has_IsAvailable () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_ChannelInformation::set_has_IsMature () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_ChannelInformation::clear_has_IsMature () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_ChannelInformation::set_has_IsSkipped () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_ChannelInformation::clear_has_IsSkipped () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline void T_ChannelInformation::set_has_ArtistAlertStatus () {
    _has_bits_[0] |= 1u << 24;
}

inline void T_ChannelInformation::clear_has_ArtistAlertStatus () {
    _has_bits_[0] &= ~ (1u << 24);
}

inline void T_ChannelInformation::set_has_SongAlertStatus () {
    _has_bits_[0] |= 1u << 25;
}

inline void T_ChannelInformation::clear_has_SongAlertStatus () {
    _has_bits_[0] &= ~ (1u << 25);
}

inline  T_SxmSignalQuality::T_SxmSignalQuality ()  :
    _AntennaStatus (::sxm_audio_main_fi_types::T_e8_Sxm_AntennaState__FC_SXM_DIAG_ANT_UNSUPPORTED),
    _SignalQualityStatus (::sxm_audio_main_fi_types::T_e8_Sxm_SignalQuality__FC_SXM_DIAG_SQ_NO_SIGNAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmSignalQuality::T_SxmSignalQuality (const T_SxmSignalQuality &rhs)  :
    _AntennaStatus (::sxm_audio_main_fi_types::T_e8_Sxm_AntennaState__FC_SXM_DIAG_ANT_UNSUPPORTED),
    _SignalQualityStatus (::sxm_audio_main_fi_types::T_e8_Sxm_SignalQuality__FC_SXM_DIAG_SQ_NO_SIGNAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmSignalQuality::T_SxmSignalQuality (T_e8_Sxm_AntennaState AntennaStatus_, T_e8_Sxm_SignalQuality SignalQualityStatus_)  :
    _AntennaStatus (AntennaStatus_),
    _SignalQualityStatus (SignalQualityStatus_)
{
    #ifndef NDEBUG
    if (!(T_e8_Sxm_AntennaState_IsValid(AntennaStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AntennaStatus_, "T_e8_Sxm_AntennaState", "AntennaStatus", "T_SxmSignalQuality");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_Sxm_SignalQuality_IsValid(SignalQualityStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SignalQualityStatus_, "T_e8_Sxm_SignalQuality", "SignalQualityStatus", "T_SxmSignalQuality");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmSignalQuality::~T_SxmSignalQuality() {
}

inline T_SxmSignalQuality& T_SxmSignalQuality::operator = (const T_SxmSignalQuality& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAntennaStatus()) {
            setAntennaStatus(rhs.getAntennaStatus());
        } else {
            clearAntennaStatus();
        }
        if (rhs.hasSignalQualityStatus()) {
            setSignalQualityStatus(rhs.getSignalQualityStatus());
        } else {
            clearSignalQualityStatus();
        }
    }
    return *this;
}

inline bool T_SxmSignalQuality::operator == (const T_SxmSignalQuality& rhs) const {
    return (((!hasAntennaStatus() && !rhs.hasAntennaStatus()) || getAntennaStatus() == rhs.getAntennaStatus()) &&
        ((!hasSignalQualityStatus() && !rhs.hasSignalQualityStatus()) || getSignalQualityStatus() == rhs.getSignalQualityStatus()));
}

inline bool T_SxmSignalQuality::operator != (const T_SxmSignalQuality& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmSignalQuality::operator < (const T_SxmSignalQuality& rhs) const {
    if (hasAntennaStatus() || rhs.hasAntennaStatus()) {
        if ((uint32)getAntennaStatus() < (uint32)rhs.getAntennaStatus()) return true;
        if ((uint32)getAntennaStatus() > (uint32)rhs.getAntennaStatus()) return false;
    }
    if (hasSignalQualityStatus() || rhs.hasSignalQualityStatus()) {
        if ((uint32)getSignalQualityStatus() < (uint32)rhs.getSignalQualityStatus()) return true;
        if ((uint32)getSignalQualityStatus() > (uint32)rhs.getSignalQualityStatus()) return false;
    }
    return false;
}

inline bool T_SxmSignalQuality::operator > (const T_SxmSignalQuality& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmSignalQuality::clear() {
    clearAntennaStatus();
    clearSignalQualityStatus();
}

inline void T_SxmSignalQuality::clearAntennaStatus() {
    if (hasAntennaStatus()) {
         clear_has_AntennaStatus();
        _AntennaStatus = ::sxm_audio_main_fi_types::T_e8_Sxm_AntennaState__FC_SXM_DIAG_ANT_UNSUPPORTED;
     }
}

inline bool T_SxmSignalQuality::hasAntennaStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Sxm_AntennaState T_SxmSignalQuality::getAntennaStatus () const {
    return _AntennaStatus;
}

inline void T_SxmSignalQuality::setAntennaStatus (T_e8_Sxm_AntennaState AntennaStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_Sxm_AntennaState_IsValid(AntennaStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AntennaStatus_, "T_e8_Sxm_AntennaState", "AntennaStatus", "T_SxmSignalQuality");
    }
    #endif
    set_has_AntennaStatus();
    this->_AntennaStatus = AntennaStatus_;
}

inline void T_SxmSignalQuality::clearSignalQualityStatus() {
    if (hasSignalQualityStatus()) {
         clear_has_SignalQualityStatus();
        _SignalQualityStatus = ::sxm_audio_main_fi_types::T_e8_Sxm_SignalQuality__FC_SXM_DIAG_SQ_NO_SIGNAL;
     }
}

inline bool T_SxmSignalQuality::hasSignalQualityStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Sxm_SignalQuality T_SxmSignalQuality::getSignalQualityStatus () const {
    return _SignalQualityStatus;
}

inline void T_SxmSignalQuality::setSignalQualityStatus (T_e8_Sxm_SignalQuality SignalQualityStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_Sxm_SignalQuality_IsValid(SignalQualityStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SignalQualityStatus_, "T_e8_Sxm_SignalQuality", "SignalQualityStatus", "T_SxmSignalQuality");
    }
    #endif
    set_has_SignalQualityStatus();
    this->_SignalQualityStatus = SignalQualityStatus_;
}

inline void T_SxmSignalQuality::set_has_AntennaStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmSignalQuality::clear_has_AntennaStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SxmSignalQuality::set_has_SignalQualityStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SxmSignalQuality::clear_has_SignalQualityStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SxmDetSignalQuality::T_SxmDetSignalQuality ()  :
    _SigQuality (),
    _TunerStatus (),
    _ENSALockStatus (),
    _ENSBLockStatus (),
    _BerS1 (),
    _BerS2 (),
    _BerT (),
    _CtoNS1A (),
    _CtoNS1B (),
    _CtoNS2A (),
    _CtoNS2B (),
    _RSErrsWords (),
    _RSErrSatSymb (),
    _RSErrTerrSymb (),
    _TunerCarrFreqOfset (),
    _RSSI ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmDetSignalQuality::T_SxmDetSignalQuality (const T_SxmDetSignalQuality &rhs)  :
    _SigQuality (),
    _TunerStatus (),
    _ENSALockStatus (),
    _ENSBLockStatus (),
    _BerS1 (),
    _BerS2 (),
    _BerT (),
    _CtoNS1A (),
    _CtoNS1B (),
    _CtoNS2A (),
    _CtoNS2B (),
    _RSErrsWords (),
    _RSErrSatSymb (),
    _RSErrTerrSymb (),
    _TunerCarrFreqOfset (),
    _RSSI ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmDetSignalQuality::T_SxmDetSignalQuality (const ::std::string& SigQuality_, const ::std::string& TunerStatus_, const ::std::string& ENSALockStatus_, const ::std::string& ENSBLockStatus_, const ::std::string& BerS1_, const ::std::string& BerS2_, const ::std::string& BerT_, const ::std::string& CtoNS1A_, const ::std::string& CtoNS1B_, const ::std::string& CtoNS2A_, const ::std::string& CtoNS2B_, const ::std::string& RSErrsWords_, const ::std::string& RSErrSatSymb_, const ::std::string& RSErrTerrSymb_, const ::std::string& TunerCarrFreqOfset_, const ::std::string& RSSI_)  :
    _SigQuality (SigQuality_),
    _TunerStatus (TunerStatus_),
    _ENSALockStatus (ENSALockStatus_),
    _ENSBLockStatus (ENSBLockStatus_),
    _BerS1 (BerS1_),
    _BerS2 (BerS2_),
    _BerT (BerT_),
    _CtoNS1A (CtoNS1A_),
    _CtoNS1B (CtoNS1B_),
    _CtoNS2A (CtoNS2A_),
    _CtoNS2B (CtoNS2B_),
    _RSErrsWords (RSErrsWords_),
    _RSErrSatSymb (RSErrSatSymb_),
    _RSErrTerrSymb (RSErrTerrSymb_),
    _TunerCarrFreqOfset (TunerCarrFreqOfset_),
    _RSSI (RSSI_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SigQuality_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TunerStatus_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ENSALockStatus_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ENSBLockStatus_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BerS1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BerS2_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BerT_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CtoNS1A_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CtoNS1B_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CtoNS2A_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CtoNS2B_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RSErrsWords_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RSErrSatSymb_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RSErrTerrSymb_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TunerCarrFreqOfset_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RSSI_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmDetSignalQuality::~T_SxmDetSignalQuality() {
}

inline T_SxmDetSignalQuality& T_SxmDetSignalQuality::operator = (const T_SxmDetSignalQuality& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSigQuality()) {
            setSigQuality(rhs.getSigQuality());
        } else {
            clearSigQuality();
        }
        if (rhs.hasTunerStatus()) {
            setTunerStatus(rhs.getTunerStatus());
        } else {
            clearTunerStatus();
        }
        if (rhs.hasENSALockStatus()) {
            setENSALockStatus(rhs.getENSALockStatus());
        } else {
            clearENSALockStatus();
        }
        if (rhs.hasENSBLockStatus()) {
            setENSBLockStatus(rhs.getENSBLockStatus());
        } else {
            clearENSBLockStatus();
        }
        if (rhs.hasBerS1()) {
            setBerS1(rhs.getBerS1());
        } else {
            clearBerS1();
        }
        if (rhs.hasBerS2()) {
            setBerS2(rhs.getBerS2());
        } else {
            clearBerS2();
        }
        if (rhs.hasBerT()) {
            setBerT(rhs.getBerT());
        } else {
            clearBerT();
        }
        if (rhs.hasCtoNS1A()) {
            setCtoNS1A(rhs.getCtoNS1A());
        } else {
            clearCtoNS1A();
        }
        if (rhs.hasCtoNS1B()) {
            setCtoNS1B(rhs.getCtoNS1B());
        } else {
            clearCtoNS1B();
        }
        if (rhs.hasCtoNS2A()) {
            setCtoNS2A(rhs.getCtoNS2A());
        } else {
            clearCtoNS2A();
        }
        if (rhs.hasCtoNS2B()) {
            setCtoNS2B(rhs.getCtoNS2B());
        } else {
            clearCtoNS2B();
        }
        if (rhs.hasRSErrsWords()) {
            setRSErrsWords(rhs.getRSErrsWords());
        } else {
            clearRSErrsWords();
        }
        if (rhs.hasRSErrSatSymb()) {
            setRSErrSatSymb(rhs.getRSErrSatSymb());
        } else {
            clearRSErrSatSymb();
        }
        if (rhs.hasRSErrTerrSymb()) {
            setRSErrTerrSymb(rhs.getRSErrTerrSymb());
        } else {
            clearRSErrTerrSymb();
        }
        if (rhs.hasTunerCarrFreqOfset()) {
            setTunerCarrFreqOfset(rhs.getTunerCarrFreqOfset());
        } else {
            clearTunerCarrFreqOfset();
        }
        if (rhs.hasRSSI()) {
            setRSSI(rhs.getRSSI());
        } else {
            clearRSSI();
        }
    }
    return *this;
}

inline bool T_SxmDetSignalQuality::operator == (const T_SxmDetSignalQuality& rhs) const {
    return (((!hasSigQuality() && !rhs.hasSigQuality()) || getSigQuality() == rhs.getSigQuality()) &&
        ((!hasTunerStatus() && !rhs.hasTunerStatus()) || getTunerStatus() == rhs.getTunerStatus()) &&
        ((!hasENSALockStatus() && !rhs.hasENSALockStatus()) || getENSALockStatus() == rhs.getENSALockStatus()) &&
        ((!hasENSBLockStatus() && !rhs.hasENSBLockStatus()) || getENSBLockStatus() == rhs.getENSBLockStatus()) &&
        ((!hasBerS1() && !rhs.hasBerS1()) || getBerS1() == rhs.getBerS1()) &&
        ((!hasBerS2() && !rhs.hasBerS2()) || getBerS2() == rhs.getBerS2()) &&
        ((!hasBerT() && !rhs.hasBerT()) || getBerT() == rhs.getBerT()) &&
        ((!hasCtoNS1A() && !rhs.hasCtoNS1A()) || getCtoNS1A() == rhs.getCtoNS1A()) &&
        ((!hasCtoNS1B() && !rhs.hasCtoNS1B()) || getCtoNS1B() == rhs.getCtoNS1B()) &&
        ((!hasCtoNS2A() && !rhs.hasCtoNS2A()) || getCtoNS2A() == rhs.getCtoNS2A()) &&
        ((!hasCtoNS2B() && !rhs.hasCtoNS2B()) || getCtoNS2B() == rhs.getCtoNS2B()) &&
        ((!hasRSErrsWords() && !rhs.hasRSErrsWords()) || getRSErrsWords() == rhs.getRSErrsWords()) &&
        ((!hasRSErrSatSymb() && !rhs.hasRSErrSatSymb()) || getRSErrSatSymb() == rhs.getRSErrSatSymb()) &&
        ((!hasRSErrTerrSymb() && !rhs.hasRSErrTerrSymb()) || getRSErrTerrSymb() == rhs.getRSErrTerrSymb()) &&
        ((!hasTunerCarrFreqOfset() && !rhs.hasTunerCarrFreqOfset()) || getTunerCarrFreqOfset() == rhs.getTunerCarrFreqOfset()) &&
        ((!hasRSSI() && !rhs.hasRSSI()) || getRSSI() == rhs.getRSSI()));
}

inline bool T_SxmDetSignalQuality::operator != (const T_SxmDetSignalQuality& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmDetSignalQuality::operator < (const T_SxmDetSignalQuality& rhs) const {
    if (hasSigQuality() || rhs.hasSigQuality()) {
        if (getSigQuality() < rhs.getSigQuality()) return true;
        if (getSigQuality() > rhs.getSigQuality()) return false;
    }
    if (hasTunerStatus() || rhs.hasTunerStatus()) {
        if (getTunerStatus() < rhs.getTunerStatus()) return true;
        if (getTunerStatus() > rhs.getTunerStatus()) return false;
    }
    if (hasENSALockStatus() || rhs.hasENSALockStatus()) {
        if (getENSALockStatus() < rhs.getENSALockStatus()) return true;
        if (getENSALockStatus() > rhs.getENSALockStatus()) return false;
    }
    if (hasENSBLockStatus() || rhs.hasENSBLockStatus()) {
        if (getENSBLockStatus() < rhs.getENSBLockStatus()) return true;
        if (getENSBLockStatus() > rhs.getENSBLockStatus()) return false;
    }
    if (hasBerS1() || rhs.hasBerS1()) {
        if (getBerS1() < rhs.getBerS1()) return true;
        if (getBerS1() > rhs.getBerS1()) return false;
    }
    if (hasBerS2() || rhs.hasBerS2()) {
        if (getBerS2() < rhs.getBerS2()) return true;
        if (getBerS2() > rhs.getBerS2()) return false;
    }
    if (hasBerT() || rhs.hasBerT()) {
        if (getBerT() < rhs.getBerT()) return true;
        if (getBerT() > rhs.getBerT()) return false;
    }
    if (hasCtoNS1A() || rhs.hasCtoNS1A()) {
        if (getCtoNS1A() < rhs.getCtoNS1A()) return true;
        if (getCtoNS1A() > rhs.getCtoNS1A()) return false;
    }
    if (hasCtoNS1B() || rhs.hasCtoNS1B()) {
        if (getCtoNS1B() < rhs.getCtoNS1B()) return true;
        if (getCtoNS1B() > rhs.getCtoNS1B()) return false;
    }
    if (hasCtoNS2A() || rhs.hasCtoNS2A()) {
        if (getCtoNS2A() < rhs.getCtoNS2A()) return true;
        if (getCtoNS2A() > rhs.getCtoNS2A()) return false;
    }
    if (hasCtoNS2B() || rhs.hasCtoNS2B()) {
        if (getCtoNS2B() < rhs.getCtoNS2B()) return true;
        if (getCtoNS2B() > rhs.getCtoNS2B()) return false;
    }
    if (hasRSErrsWords() || rhs.hasRSErrsWords()) {
        if (getRSErrsWords() < rhs.getRSErrsWords()) return true;
        if (getRSErrsWords() > rhs.getRSErrsWords()) return false;
    }
    if (hasRSErrSatSymb() || rhs.hasRSErrSatSymb()) {
        if (getRSErrSatSymb() < rhs.getRSErrSatSymb()) return true;
        if (getRSErrSatSymb() > rhs.getRSErrSatSymb()) return false;
    }
    if (hasRSErrTerrSymb() || rhs.hasRSErrTerrSymb()) {
        if (getRSErrTerrSymb() < rhs.getRSErrTerrSymb()) return true;
        if (getRSErrTerrSymb() > rhs.getRSErrTerrSymb()) return false;
    }
    if (hasTunerCarrFreqOfset() || rhs.hasTunerCarrFreqOfset()) {
        if (getTunerCarrFreqOfset() < rhs.getTunerCarrFreqOfset()) return true;
        if (getTunerCarrFreqOfset() > rhs.getTunerCarrFreqOfset()) return false;
    }
    if (hasRSSI() || rhs.hasRSSI()) {
        if (getRSSI() < rhs.getRSSI()) return true;
        if (getRSSI() > rhs.getRSSI()) return false;
    }
    return false;
}

inline bool T_SxmDetSignalQuality::operator > (const T_SxmDetSignalQuality& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmDetSignalQuality::clear() {
    clearSigQuality();
    clearTunerStatus();
    clearENSALockStatus();
    clearENSBLockStatus();
    clearBerS1();
    clearBerS2();
    clearBerT();
    clearCtoNS1A();
    clearCtoNS1B();
    clearCtoNS2A();
    clearCtoNS2B();
    clearRSErrsWords();
    clearRSErrSatSymb();
    clearRSErrTerrSymb();
    clearTunerCarrFreqOfset();
    clearRSSI();
}

inline void T_SxmDetSignalQuality::clearSigQuality() {
    if (hasSigQuality()) {
         clear_has_SigQuality();
        _SigQuality.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasSigQuality () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getSigQuality () const {
    return _SigQuality;
}

inline ::std::string& T_SxmDetSignalQuality::getSigQualityMutable () {
    set_has_SigQuality();
    return _SigQuality;
}

inline void T_SxmDetSignalQuality::setSigQuality (const ::std::string& SigQuality_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SigQuality_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SigQuality();
    this->_SigQuality = SigQuality_;
}

inline void T_SxmDetSignalQuality::setSigQuality (const char* SigQuality_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SigQuality_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SigQuality();
    this->_SigQuality.assign(SigQuality_);
}

inline void T_SxmDetSignalQuality::setSigQuality (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SigQuality();
    this->_SigQuality.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearTunerStatus() {
    if (hasTunerStatus()) {
         clear_has_TunerStatus();
        _TunerStatus.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasTunerStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getTunerStatus () const {
    return _TunerStatus;
}

inline ::std::string& T_SxmDetSignalQuality::getTunerStatusMutable () {
    set_has_TunerStatus();
    return _TunerStatus;
}

inline void T_SxmDetSignalQuality::setTunerStatus (const ::std::string& TunerStatus_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TunerStatus_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TunerStatus();
    this->_TunerStatus = TunerStatus_;
}

inline void T_SxmDetSignalQuality::setTunerStatus (const char* TunerStatus_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TunerStatus_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TunerStatus();
    this->_TunerStatus.assign(TunerStatus_);
}

inline void T_SxmDetSignalQuality::setTunerStatus (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TunerStatus();
    this->_TunerStatus.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearENSALockStatus() {
    if (hasENSALockStatus()) {
         clear_has_ENSALockStatus();
        _ENSALockStatus.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasENSALockStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getENSALockStatus () const {
    return _ENSALockStatus;
}

inline ::std::string& T_SxmDetSignalQuality::getENSALockStatusMutable () {
    set_has_ENSALockStatus();
    return _ENSALockStatus;
}

inline void T_SxmDetSignalQuality::setENSALockStatus (const ::std::string& ENSALockStatus_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ENSALockStatus_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ENSALockStatus();
    this->_ENSALockStatus = ENSALockStatus_;
}

inline void T_SxmDetSignalQuality::setENSALockStatus (const char* ENSALockStatus_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ENSALockStatus_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ENSALockStatus();
    this->_ENSALockStatus.assign(ENSALockStatus_);
}

inline void T_SxmDetSignalQuality::setENSALockStatus (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ENSALockStatus();
    this->_ENSALockStatus.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearENSBLockStatus() {
    if (hasENSBLockStatus()) {
         clear_has_ENSBLockStatus();
        _ENSBLockStatus.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasENSBLockStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getENSBLockStatus () const {
    return _ENSBLockStatus;
}

inline ::std::string& T_SxmDetSignalQuality::getENSBLockStatusMutable () {
    set_has_ENSBLockStatus();
    return _ENSBLockStatus;
}

inline void T_SxmDetSignalQuality::setENSBLockStatus (const ::std::string& ENSBLockStatus_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ENSBLockStatus_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ENSBLockStatus();
    this->_ENSBLockStatus = ENSBLockStatus_;
}

inline void T_SxmDetSignalQuality::setENSBLockStatus (const char* ENSBLockStatus_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ENSBLockStatus_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ENSBLockStatus();
    this->_ENSBLockStatus.assign(ENSBLockStatus_);
}

inline void T_SxmDetSignalQuality::setENSBLockStatus (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ENSBLockStatus();
    this->_ENSBLockStatus.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearBerS1() {
    if (hasBerS1()) {
         clear_has_BerS1();
        _BerS1.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasBerS1 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getBerS1 () const {
    return _BerS1;
}

inline ::std::string& T_SxmDetSignalQuality::getBerS1Mutable () {
    set_has_BerS1();
    return _BerS1;
}

inline void T_SxmDetSignalQuality::setBerS1 (const ::std::string& BerS1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BerS1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BerS1();
    this->_BerS1 = BerS1_;
}

inline void T_SxmDetSignalQuality::setBerS1 (const char* BerS1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BerS1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BerS1();
    this->_BerS1.assign(BerS1_);
}

inline void T_SxmDetSignalQuality::setBerS1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BerS1();
    this->_BerS1.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearBerS2() {
    if (hasBerS2()) {
         clear_has_BerS2();
        _BerS2.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasBerS2 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getBerS2 () const {
    return _BerS2;
}

inline ::std::string& T_SxmDetSignalQuality::getBerS2Mutable () {
    set_has_BerS2();
    return _BerS2;
}

inline void T_SxmDetSignalQuality::setBerS2 (const ::std::string& BerS2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BerS2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BerS2();
    this->_BerS2 = BerS2_;
}

inline void T_SxmDetSignalQuality::setBerS2 (const char* BerS2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BerS2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BerS2();
    this->_BerS2.assign(BerS2_);
}

inline void T_SxmDetSignalQuality::setBerS2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BerS2();
    this->_BerS2.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearBerT() {
    if (hasBerT()) {
         clear_has_BerT();
        _BerT.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasBerT () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getBerT () const {
    return _BerT;
}

inline ::std::string& T_SxmDetSignalQuality::getBerTMutable () {
    set_has_BerT();
    return _BerT;
}

inline void T_SxmDetSignalQuality::setBerT (const ::std::string& BerT_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BerT_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BerT();
    this->_BerT = BerT_;
}

inline void T_SxmDetSignalQuality::setBerT (const char* BerT_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BerT_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BerT();
    this->_BerT.assign(BerT_);
}

inline void T_SxmDetSignalQuality::setBerT (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BerT();
    this->_BerT.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearCtoNS1A() {
    if (hasCtoNS1A()) {
         clear_has_CtoNS1A();
        _CtoNS1A.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasCtoNS1A () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getCtoNS1A () const {
    return _CtoNS1A;
}

inline ::std::string& T_SxmDetSignalQuality::getCtoNS1AMutable () {
    set_has_CtoNS1A();
    return _CtoNS1A;
}

inline void T_SxmDetSignalQuality::setCtoNS1A (const ::std::string& CtoNS1A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CtoNS1A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CtoNS1A();
    this->_CtoNS1A = CtoNS1A_;
}

inline void T_SxmDetSignalQuality::setCtoNS1A (const char* CtoNS1A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CtoNS1A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CtoNS1A();
    this->_CtoNS1A.assign(CtoNS1A_);
}

inline void T_SxmDetSignalQuality::setCtoNS1A (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CtoNS1A();
    this->_CtoNS1A.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearCtoNS1B() {
    if (hasCtoNS1B()) {
         clear_has_CtoNS1B();
        _CtoNS1B.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasCtoNS1B () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getCtoNS1B () const {
    return _CtoNS1B;
}

inline ::std::string& T_SxmDetSignalQuality::getCtoNS1BMutable () {
    set_has_CtoNS1B();
    return _CtoNS1B;
}

inline void T_SxmDetSignalQuality::setCtoNS1B (const ::std::string& CtoNS1B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CtoNS1B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CtoNS1B();
    this->_CtoNS1B = CtoNS1B_;
}

inline void T_SxmDetSignalQuality::setCtoNS1B (const char* CtoNS1B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CtoNS1B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CtoNS1B();
    this->_CtoNS1B.assign(CtoNS1B_);
}

inline void T_SxmDetSignalQuality::setCtoNS1B (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CtoNS1B();
    this->_CtoNS1B.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearCtoNS2A() {
    if (hasCtoNS2A()) {
         clear_has_CtoNS2A();
        _CtoNS2A.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasCtoNS2A () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getCtoNS2A () const {
    return _CtoNS2A;
}

inline ::std::string& T_SxmDetSignalQuality::getCtoNS2AMutable () {
    set_has_CtoNS2A();
    return _CtoNS2A;
}

inline void T_SxmDetSignalQuality::setCtoNS2A (const ::std::string& CtoNS2A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CtoNS2A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CtoNS2A();
    this->_CtoNS2A = CtoNS2A_;
}

inline void T_SxmDetSignalQuality::setCtoNS2A (const char* CtoNS2A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CtoNS2A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CtoNS2A();
    this->_CtoNS2A.assign(CtoNS2A_);
}

inline void T_SxmDetSignalQuality::setCtoNS2A (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CtoNS2A();
    this->_CtoNS2A.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearCtoNS2B() {
    if (hasCtoNS2B()) {
         clear_has_CtoNS2B();
        _CtoNS2B.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasCtoNS2B () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getCtoNS2B () const {
    return _CtoNS2B;
}

inline ::std::string& T_SxmDetSignalQuality::getCtoNS2BMutable () {
    set_has_CtoNS2B();
    return _CtoNS2B;
}

inline void T_SxmDetSignalQuality::setCtoNS2B (const ::std::string& CtoNS2B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CtoNS2B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CtoNS2B();
    this->_CtoNS2B = CtoNS2B_;
}

inline void T_SxmDetSignalQuality::setCtoNS2B (const char* CtoNS2B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CtoNS2B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CtoNS2B();
    this->_CtoNS2B.assign(CtoNS2B_);
}

inline void T_SxmDetSignalQuality::setCtoNS2B (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CtoNS2B();
    this->_CtoNS2B.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearRSErrsWords() {
    if (hasRSErrsWords()) {
         clear_has_RSErrsWords();
        _RSErrsWords.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasRSErrsWords () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getRSErrsWords () const {
    return _RSErrsWords;
}

inline ::std::string& T_SxmDetSignalQuality::getRSErrsWordsMutable () {
    set_has_RSErrsWords();
    return _RSErrsWords;
}

inline void T_SxmDetSignalQuality::setRSErrsWords (const ::std::string& RSErrsWords_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RSErrsWords_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RSErrsWords();
    this->_RSErrsWords = RSErrsWords_;
}

inline void T_SxmDetSignalQuality::setRSErrsWords (const char* RSErrsWords_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RSErrsWords_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RSErrsWords();
    this->_RSErrsWords.assign(RSErrsWords_);
}

inline void T_SxmDetSignalQuality::setRSErrsWords (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RSErrsWords();
    this->_RSErrsWords.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearRSErrSatSymb() {
    if (hasRSErrSatSymb()) {
         clear_has_RSErrSatSymb();
        _RSErrSatSymb.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasRSErrSatSymb () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getRSErrSatSymb () const {
    return _RSErrSatSymb;
}

inline ::std::string& T_SxmDetSignalQuality::getRSErrSatSymbMutable () {
    set_has_RSErrSatSymb();
    return _RSErrSatSymb;
}

inline void T_SxmDetSignalQuality::setRSErrSatSymb (const ::std::string& RSErrSatSymb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RSErrSatSymb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RSErrSatSymb();
    this->_RSErrSatSymb = RSErrSatSymb_;
}

inline void T_SxmDetSignalQuality::setRSErrSatSymb (const char* RSErrSatSymb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RSErrSatSymb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RSErrSatSymb();
    this->_RSErrSatSymb.assign(RSErrSatSymb_);
}

inline void T_SxmDetSignalQuality::setRSErrSatSymb (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RSErrSatSymb();
    this->_RSErrSatSymb.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearRSErrTerrSymb() {
    if (hasRSErrTerrSymb()) {
         clear_has_RSErrTerrSymb();
        _RSErrTerrSymb.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasRSErrTerrSymb () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getRSErrTerrSymb () const {
    return _RSErrTerrSymb;
}

inline ::std::string& T_SxmDetSignalQuality::getRSErrTerrSymbMutable () {
    set_has_RSErrTerrSymb();
    return _RSErrTerrSymb;
}

inline void T_SxmDetSignalQuality::setRSErrTerrSymb (const ::std::string& RSErrTerrSymb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RSErrTerrSymb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RSErrTerrSymb();
    this->_RSErrTerrSymb = RSErrTerrSymb_;
}

inline void T_SxmDetSignalQuality::setRSErrTerrSymb (const char* RSErrTerrSymb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RSErrTerrSymb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RSErrTerrSymb();
    this->_RSErrTerrSymb.assign(RSErrTerrSymb_);
}

inline void T_SxmDetSignalQuality::setRSErrTerrSymb (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RSErrTerrSymb();
    this->_RSErrTerrSymb.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearTunerCarrFreqOfset() {
    if (hasTunerCarrFreqOfset()) {
         clear_has_TunerCarrFreqOfset();
        _TunerCarrFreqOfset.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasTunerCarrFreqOfset () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getTunerCarrFreqOfset () const {
    return _TunerCarrFreqOfset;
}

inline ::std::string& T_SxmDetSignalQuality::getTunerCarrFreqOfsetMutable () {
    set_has_TunerCarrFreqOfset();
    return _TunerCarrFreqOfset;
}

inline void T_SxmDetSignalQuality::setTunerCarrFreqOfset (const ::std::string& TunerCarrFreqOfset_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TunerCarrFreqOfset_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TunerCarrFreqOfset();
    this->_TunerCarrFreqOfset = TunerCarrFreqOfset_;
}

inline void T_SxmDetSignalQuality::setTunerCarrFreqOfset (const char* TunerCarrFreqOfset_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TunerCarrFreqOfset_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TunerCarrFreqOfset();
    this->_TunerCarrFreqOfset.assign(TunerCarrFreqOfset_);
}

inline void T_SxmDetSignalQuality::setTunerCarrFreqOfset (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TunerCarrFreqOfset();
    this->_TunerCarrFreqOfset.assign(value, size);
}

inline void T_SxmDetSignalQuality::clearRSSI() {
    if (hasRSSI()) {
         clear_has_RSSI();
        _RSSI.clear();
     }
}

inline bool T_SxmDetSignalQuality::hasRSSI () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline const ::std::string& T_SxmDetSignalQuality::getRSSI () const {
    return _RSSI;
}

inline ::std::string& T_SxmDetSignalQuality::getRSSIMutable () {
    set_has_RSSI();
    return _RSSI;
}

inline void T_SxmDetSignalQuality::setRSSI (const ::std::string& RSSI_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RSSI_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RSSI();
    this->_RSSI = RSSI_;
}

inline void T_SxmDetSignalQuality::setRSSI (const char* RSSI_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RSSI_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RSSI();
    this->_RSSI.assign(RSSI_);
}

inline void T_SxmDetSignalQuality::setRSSI (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RSSI();
    this->_RSSI.assign(value, size);
}

inline void T_SxmDetSignalQuality::set_has_SigQuality () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmDetSignalQuality::clear_has_SigQuality () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SxmDetSignalQuality::set_has_TunerStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SxmDetSignalQuality::clear_has_TunerStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SxmDetSignalQuality::set_has_ENSALockStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SxmDetSignalQuality::clear_has_ENSALockStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SxmDetSignalQuality::set_has_ENSBLockStatus () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SxmDetSignalQuality::clear_has_ENSBLockStatus () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SxmDetSignalQuality::set_has_BerS1 () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SxmDetSignalQuality::clear_has_BerS1 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SxmDetSignalQuality::set_has_BerS2 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SxmDetSignalQuality::clear_has_BerS2 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SxmDetSignalQuality::set_has_BerT () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SxmDetSignalQuality::clear_has_BerT () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SxmDetSignalQuality::set_has_CtoNS1A () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SxmDetSignalQuality::clear_has_CtoNS1A () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_SxmDetSignalQuality::set_has_CtoNS1B () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_SxmDetSignalQuality::clear_has_CtoNS1B () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_SxmDetSignalQuality::set_has_CtoNS2A () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_SxmDetSignalQuality::clear_has_CtoNS2A () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_SxmDetSignalQuality::set_has_CtoNS2B () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_SxmDetSignalQuality::clear_has_CtoNS2B () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_SxmDetSignalQuality::set_has_RSErrsWords () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_SxmDetSignalQuality::clear_has_RSErrsWords () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_SxmDetSignalQuality::set_has_RSErrSatSymb () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_SxmDetSignalQuality::clear_has_RSErrSatSymb () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_SxmDetSignalQuality::set_has_RSErrTerrSymb () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_SxmDetSignalQuality::clear_has_RSErrTerrSymb () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_SxmDetSignalQuality::set_has_TunerCarrFreqOfset () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_SxmDetSignalQuality::clear_has_TunerCarrFreqOfset () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_SxmDetSignalQuality::set_has_RSSI () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_SxmDetSignalQuality::clear_has_RSSI () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline  T_SxmDetOvrlSignalQuality::T_SxmDetOvrlSignalQuality ()  :
    _ReceiverState (),
    _OBerS1A (),
    _OBerS2A (),
    _OBerTA (),
    _OBerS1B (),
    _OBerS2B (),
    _OBerTB (),
    _OBERTrbWrdErRt0A (),
    _OBERTrbWrdErRt0B (),
    _OBERTrbWrdErRt1A (),
    _OBERTrbWrdErRt1B (),
    _OBERTrbWrdErRt2A (),
    _OBERTrbWrdErRt2B ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmDetOvrlSignalQuality::T_SxmDetOvrlSignalQuality (const T_SxmDetOvrlSignalQuality &rhs)  :
    _ReceiverState (),
    _OBerS1A (),
    _OBerS2A (),
    _OBerTA (),
    _OBerS1B (),
    _OBerS2B (),
    _OBerTB (),
    _OBERTrbWrdErRt0A (),
    _OBERTrbWrdErRt0B (),
    _OBERTrbWrdErRt1A (),
    _OBERTrbWrdErRt1B (),
    _OBERTrbWrdErRt2A (),
    _OBERTrbWrdErRt2B ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmDetOvrlSignalQuality::T_SxmDetOvrlSignalQuality (const ::std::string& ReceiverState_, const ::std::string& OBerS1A_, const ::std::string& OBerS2A_, const ::std::string& OBerTA_, const ::std::string& OBerS1B_, const ::std::string& OBerS2B_, const ::std::string& OBerTB_, const ::std::string& OBERTrbWrdErRt0A_, const ::std::string& OBERTrbWrdErRt0B_, const ::std::string& OBERTrbWrdErRt1A_, const ::std::string& OBERTrbWrdErRt1B_, const ::std::string& OBERTrbWrdErRt2A_, const ::std::string& OBERTrbWrdErRt2B_)  :
    _ReceiverState (ReceiverState_),
    _OBerS1A (OBerS1A_),
    _OBerS2A (OBerS2A_),
    _OBerTA (OBerTA_),
    _OBerS1B (OBerS1B_),
    _OBerS2B (OBerS2B_),
    _OBerTB (OBerTB_),
    _OBERTrbWrdErRt0A (OBERTrbWrdErRt0A_),
    _OBERTrbWrdErRt0B (OBERTrbWrdErRt0B_),
    _OBERTrbWrdErRt1A (OBERTrbWrdErRt1A_),
    _OBERTrbWrdErRt1B (OBERTrbWrdErRt1B_),
    _OBERTrbWrdErRt2A (OBERTrbWrdErRt2A_),
    _OBERTrbWrdErRt2B (OBERTrbWrdErRt2B_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceiverState_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerS1A_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerS2A_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerTA_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerS1B_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerS2B_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerTB_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt0A_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt0B_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt1A_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt1B_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt2A_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt2B_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmDetOvrlSignalQuality::~T_SxmDetOvrlSignalQuality() {
}

inline T_SxmDetOvrlSignalQuality& T_SxmDetOvrlSignalQuality::operator = (const T_SxmDetOvrlSignalQuality& rhs) {
    if( this != &rhs ) {
        if (rhs.hasReceiverState()) {
            setReceiverState(rhs.getReceiverState());
        } else {
            clearReceiverState();
        }
        if (rhs.hasOBerS1A()) {
            setOBerS1A(rhs.getOBerS1A());
        } else {
            clearOBerS1A();
        }
        if (rhs.hasOBerS2A()) {
            setOBerS2A(rhs.getOBerS2A());
        } else {
            clearOBerS2A();
        }
        if (rhs.hasOBerTA()) {
            setOBerTA(rhs.getOBerTA());
        } else {
            clearOBerTA();
        }
        if (rhs.hasOBerS1B()) {
            setOBerS1B(rhs.getOBerS1B());
        } else {
            clearOBerS1B();
        }
        if (rhs.hasOBerS2B()) {
            setOBerS2B(rhs.getOBerS2B());
        } else {
            clearOBerS2B();
        }
        if (rhs.hasOBerTB()) {
            setOBerTB(rhs.getOBerTB());
        } else {
            clearOBerTB();
        }
        if (rhs.hasOBERTrbWrdErRt0A()) {
            setOBERTrbWrdErRt0A(rhs.getOBERTrbWrdErRt0A());
        } else {
            clearOBERTrbWrdErRt0A();
        }
        if (rhs.hasOBERTrbWrdErRt0B()) {
            setOBERTrbWrdErRt0B(rhs.getOBERTrbWrdErRt0B());
        } else {
            clearOBERTrbWrdErRt0B();
        }
        if (rhs.hasOBERTrbWrdErRt1A()) {
            setOBERTrbWrdErRt1A(rhs.getOBERTrbWrdErRt1A());
        } else {
            clearOBERTrbWrdErRt1A();
        }
        if (rhs.hasOBERTrbWrdErRt1B()) {
            setOBERTrbWrdErRt1B(rhs.getOBERTrbWrdErRt1B());
        } else {
            clearOBERTrbWrdErRt1B();
        }
        if (rhs.hasOBERTrbWrdErRt2A()) {
            setOBERTrbWrdErRt2A(rhs.getOBERTrbWrdErRt2A());
        } else {
            clearOBERTrbWrdErRt2A();
        }
        if (rhs.hasOBERTrbWrdErRt2B()) {
            setOBERTrbWrdErRt2B(rhs.getOBERTrbWrdErRt2B());
        } else {
            clearOBERTrbWrdErRt2B();
        }
    }
    return *this;
}

inline bool T_SxmDetOvrlSignalQuality::operator == (const T_SxmDetOvrlSignalQuality& rhs) const {
    return (((!hasReceiverState() && !rhs.hasReceiverState()) || getReceiverState() == rhs.getReceiverState()) &&
        ((!hasOBerS1A() && !rhs.hasOBerS1A()) || getOBerS1A() == rhs.getOBerS1A()) &&
        ((!hasOBerS2A() && !rhs.hasOBerS2A()) || getOBerS2A() == rhs.getOBerS2A()) &&
        ((!hasOBerTA() && !rhs.hasOBerTA()) || getOBerTA() == rhs.getOBerTA()) &&
        ((!hasOBerS1B() && !rhs.hasOBerS1B()) || getOBerS1B() == rhs.getOBerS1B()) &&
        ((!hasOBerS2B() && !rhs.hasOBerS2B()) || getOBerS2B() == rhs.getOBerS2B()) &&
        ((!hasOBerTB() && !rhs.hasOBerTB()) || getOBerTB() == rhs.getOBerTB()) &&
        ((!hasOBERTrbWrdErRt0A() && !rhs.hasOBERTrbWrdErRt0A()) || getOBERTrbWrdErRt0A() == rhs.getOBERTrbWrdErRt0A()) &&
        ((!hasOBERTrbWrdErRt0B() && !rhs.hasOBERTrbWrdErRt0B()) || getOBERTrbWrdErRt0B() == rhs.getOBERTrbWrdErRt0B()) &&
        ((!hasOBERTrbWrdErRt1A() && !rhs.hasOBERTrbWrdErRt1A()) || getOBERTrbWrdErRt1A() == rhs.getOBERTrbWrdErRt1A()) &&
        ((!hasOBERTrbWrdErRt1B() && !rhs.hasOBERTrbWrdErRt1B()) || getOBERTrbWrdErRt1B() == rhs.getOBERTrbWrdErRt1B()) &&
        ((!hasOBERTrbWrdErRt2A() && !rhs.hasOBERTrbWrdErRt2A()) || getOBERTrbWrdErRt2A() == rhs.getOBERTrbWrdErRt2A()) &&
        ((!hasOBERTrbWrdErRt2B() && !rhs.hasOBERTrbWrdErRt2B()) || getOBERTrbWrdErRt2B() == rhs.getOBERTrbWrdErRt2B()));
}

inline bool T_SxmDetOvrlSignalQuality::operator != (const T_SxmDetOvrlSignalQuality& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmDetOvrlSignalQuality::operator < (const T_SxmDetOvrlSignalQuality& rhs) const {
    if (hasReceiverState() || rhs.hasReceiverState()) {
        if (getReceiverState() < rhs.getReceiverState()) return true;
        if (getReceiverState() > rhs.getReceiverState()) return false;
    }
    if (hasOBerS1A() || rhs.hasOBerS1A()) {
        if (getOBerS1A() < rhs.getOBerS1A()) return true;
        if (getOBerS1A() > rhs.getOBerS1A()) return false;
    }
    if (hasOBerS2A() || rhs.hasOBerS2A()) {
        if (getOBerS2A() < rhs.getOBerS2A()) return true;
        if (getOBerS2A() > rhs.getOBerS2A()) return false;
    }
    if (hasOBerTA() || rhs.hasOBerTA()) {
        if (getOBerTA() < rhs.getOBerTA()) return true;
        if (getOBerTA() > rhs.getOBerTA()) return false;
    }
    if (hasOBerS1B() || rhs.hasOBerS1B()) {
        if (getOBerS1B() < rhs.getOBerS1B()) return true;
        if (getOBerS1B() > rhs.getOBerS1B()) return false;
    }
    if (hasOBerS2B() || rhs.hasOBerS2B()) {
        if (getOBerS2B() < rhs.getOBerS2B()) return true;
        if (getOBerS2B() > rhs.getOBerS2B()) return false;
    }
    if (hasOBerTB() || rhs.hasOBerTB()) {
        if (getOBerTB() < rhs.getOBerTB()) return true;
        if (getOBerTB() > rhs.getOBerTB()) return false;
    }
    if (hasOBERTrbWrdErRt0A() || rhs.hasOBERTrbWrdErRt0A()) {
        if (getOBERTrbWrdErRt0A() < rhs.getOBERTrbWrdErRt0A()) return true;
        if (getOBERTrbWrdErRt0A() > rhs.getOBERTrbWrdErRt0A()) return false;
    }
    if (hasOBERTrbWrdErRt0B() || rhs.hasOBERTrbWrdErRt0B()) {
        if (getOBERTrbWrdErRt0B() < rhs.getOBERTrbWrdErRt0B()) return true;
        if (getOBERTrbWrdErRt0B() > rhs.getOBERTrbWrdErRt0B()) return false;
    }
    if (hasOBERTrbWrdErRt1A() || rhs.hasOBERTrbWrdErRt1A()) {
        if (getOBERTrbWrdErRt1A() < rhs.getOBERTrbWrdErRt1A()) return true;
        if (getOBERTrbWrdErRt1A() > rhs.getOBERTrbWrdErRt1A()) return false;
    }
    if (hasOBERTrbWrdErRt1B() || rhs.hasOBERTrbWrdErRt1B()) {
        if (getOBERTrbWrdErRt1B() < rhs.getOBERTrbWrdErRt1B()) return true;
        if (getOBERTrbWrdErRt1B() > rhs.getOBERTrbWrdErRt1B()) return false;
    }
    if (hasOBERTrbWrdErRt2A() || rhs.hasOBERTrbWrdErRt2A()) {
        if (getOBERTrbWrdErRt2A() < rhs.getOBERTrbWrdErRt2A()) return true;
        if (getOBERTrbWrdErRt2A() > rhs.getOBERTrbWrdErRt2A()) return false;
    }
    if (hasOBERTrbWrdErRt2B() || rhs.hasOBERTrbWrdErRt2B()) {
        if (getOBERTrbWrdErRt2B() < rhs.getOBERTrbWrdErRt2B()) return true;
        if (getOBERTrbWrdErRt2B() > rhs.getOBERTrbWrdErRt2B()) return false;
    }
    return false;
}

inline bool T_SxmDetOvrlSignalQuality::operator > (const T_SxmDetOvrlSignalQuality& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmDetOvrlSignalQuality::clear() {
    clearReceiverState();
    clearOBerS1A();
    clearOBerS2A();
    clearOBerTA();
    clearOBerS1B();
    clearOBerS2B();
    clearOBerTB();
    clearOBERTrbWrdErRt0A();
    clearOBERTrbWrdErRt0B();
    clearOBERTrbWrdErRt1A();
    clearOBERTrbWrdErRt1B();
    clearOBERTrbWrdErRt2A();
    clearOBERTrbWrdErRt2B();
}

inline void T_SxmDetOvrlSignalQuality::clearReceiverState() {
    if (hasReceiverState()) {
         clear_has_ReceiverState();
        _ReceiverState.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasReceiverState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getReceiverState () const {
    return _ReceiverState;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getReceiverStateMutable () {
    set_has_ReceiverState();
    return _ReceiverState;
}

inline void T_SxmDetOvrlSignalQuality::setReceiverState (const ::std::string& ReceiverState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceiverState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceiverState();
    this->_ReceiverState = ReceiverState_;
}

inline void T_SxmDetOvrlSignalQuality::setReceiverState (const char* ReceiverState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceiverState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceiverState();
    this->_ReceiverState.assign(ReceiverState_);
}

inline void T_SxmDetOvrlSignalQuality::setReceiverState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceiverState();
    this->_ReceiverState.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::clearOBerS1A() {
    if (hasOBerS1A()) {
         clear_has_OBerS1A();
        _OBerS1A.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasOBerS1A () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getOBerS1A () const {
    return _OBerS1A;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getOBerS1AMutable () {
    set_has_OBerS1A();
    return _OBerS1A;
}

inline void T_SxmDetOvrlSignalQuality::setOBerS1A (const ::std::string& OBerS1A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerS1A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerS1A();
    this->_OBerS1A = OBerS1A_;
}

inline void T_SxmDetOvrlSignalQuality::setOBerS1A (const char* OBerS1A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerS1A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerS1A();
    this->_OBerS1A.assign(OBerS1A_);
}

inline void T_SxmDetOvrlSignalQuality::setOBerS1A (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerS1A();
    this->_OBerS1A.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::clearOBerS2A() {
    if (hasOBerS2A()) {
         clear_has_OBerS2A();
        _OBerS2A.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasOBerS2A () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getOBerS2A () const {
    return _OBerS2A;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getOBerS2AMutable () {
    set_has_OBerS2A();
    return _OBerS2A;
}

inline void T_SxmDetOvrlSignalQuality::setOBerS2A (const ::std::string& OBerS2A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerS2A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerS2A();
    this->_OBerS2A = OBerS2A_;
}

inline void T_SxmDetOvrlSignalQuality::setOBerS2A (const char* OBerS2A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerS2A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerS2A();
    this->_OBerS2A.assign(OBerS2A_);
}

inline void T_SxmDetOvrlSignalQuality::setOBerS2A (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerS2A();
    this->_OBerS2A.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::clearOBerTA() {
    if (hasOBerTA()) {
         clear_has_OBerTA();
        _OBerTA.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasOBerTA () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getOBerTA () const {
    return _OBerTA;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getOBerTAMutable () {
    set_has_OBerTA();
    return _OBerTA;
}

inline void T_SxmDetOvrlSignalQuality::setOBerTA (const ::std::string& OBerTA_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerTA_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerTA();
    this->_OBerTA = OBerTA_;
}

inline void T_SxmDetOvrlSignalQuality::setOBerTA (const char* OBerTA_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerTA_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerTA();
    this->_OBerTA.assign(OBerTA_);
}

inline void T_SxmDetOvrlSignalQuality::setOBerTA (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerTA();
    this->_OBerTA.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::clearOBerS1B() {
    if (hasOBerS1B()) {
         clear_has_OBerS1B();
        _OBerS1B.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasOBerS1B () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getOBerS1B () const {
    return _OBerS1B;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getOBerS1BMutable () {
    set_has_OBerS1B();
    return _OBerS1B;
}

inline void T_SxmDetOvrlSignalQuality::setOBerS1B (const ::std::string& OBerS1B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerS1B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerS1B();
    this->_OBerS1B = OBerS1B_;
}

inline void T_SxmDetOvrlSignalQuality::setOBerS1B (const char* OBerS1B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerS1B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerS1B();
    this->_OBerS1B.assign(OBerS1B_);
}

inline void T_SxmDetOvrlSignalQuality::setOBerS1B (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerS1B();
    this->_OBerS1B.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::clearOBerS2B() {
    if (hasOBerS2B()) {
         clear_has_OBerS2B();
        _OBerS2B.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasOBerS2B () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getOBerS2B () const {
    return _OBerS2B;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getOBerS2BMutable () {
    set_has_OBerS2B();
    return _OBerS2B;
}

inline void T_SxmDetOvrlSignalQuality::setOBerS2B (const ::std::string& OBerS2B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerS2B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerS2B();
    this->_OBerS2B = OBerS2B_;
}

inline void T_SxmDetOvrlSignalQuality::setOBerS2B (const char* OBerS2B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerS2B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerS2B();
    this->_OBerS2B.assign(OBerS2B_);
}

inline void T_SxmDetOvrlSignalQuality::setOBerS2B (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerS2B();
    this->_OBerS2B.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::clearOBerTB() {
    if (hasOBerTB()) {
         clear_has_OBerTB();
        _OBerTB.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasOBerTB () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getOBerTB () const {
    return _OBerTB;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getOBerTBMutable () {
    set_has_OBerTB();
    return _OBerTB;
}

inline void T_SxmDetOvrlSignalQuality::setOBerTB (const ::std::string& OBerTB_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerTB_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerTB();
    this->_OBerTB = OBerTB_;
}

inline void T_SxmDetOvrlSignalQuality::setOBerTB (const char* OBerTB_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBerTB_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerTB();
    this->_OBerTB.assign(OBerTB_);
}

inline void T_SxmDetOvrlSignalQuality::setOBerTB (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBerTB();
    this->_OBerTB.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::clearOBERTrbWrdErRt0A() {
    if (hasOBERTrbWrdErRt0A()) {
         clear_has_OBERTrbWrdErRt0A();
        _OBERTrbWrdErRt0A.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasOBERTrbWrdErRt0A () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getOBERTrbWrdErRt0A () const {
    return _OBERTrbWrdErRt0A;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getOBERTrbWrdErRt0AMutable () {
    set_has_OBERTrbWrdErRt0A();
    return _OBERTrbWrdErRt0A;
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt0A (const ::std::string& OBERTrbWrdErRt0A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt0A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt0A();
    this->_OBERTrbWrdErRt0A = OBERTrbWrdErRt0A_;
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt0A (const char* OBERTrbWrdErRt0A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt0A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt0A();
    this->_OBERTrbWrdErRt0A.assign(OBERTrbWrdErRt0A_);
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt0A (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt0A();
    this->_OBERTrbWrdErRt0A.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::clearOBERTrbWrdErRt0B() {
    if (hasOBERTrbWrdErRt0B()) {
         clear_has_OBERTrbWrdErRt0B();
        _OBERTrbWrdErRt0B.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasOBERTrbWrdErRt0B () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getOBERTrbWrdErRt0B () const {
    return _OBERTrbWrdErRt0B;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getOBERTrbWrdErRt0BMutable () {
    set_has_OBERTrbWrdErRt0B();
    return _OBERTrbWrdErRt0B;
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt0B (const ::std::string& OBERTrbWrdErRt0B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt0B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt0B();
    this->_OBERTrbWrdErRt0B = OBERTrbWrdErRt0B_;
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt0B (const char* OBERTrbWrdErRt0B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt0B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt0B();
    this->_OBERTrbWrdErRt0B.assign(OBERTrbWrdErRt0B_);
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt0B (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt0B();
    this->_OBERTrbWrdErRt0B.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::clearOBERTrbWrdErRt1A() {
    if (hasOBERTrbWrdErRt1A()) {
         clear_has_OBERTrbWrdErRt1A();
        _OBERTrbWrdErRt1A.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasOBERTrbWrdErRt1A () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getOBERTrbWrdErRt1A () const {
    return _OBERTrbWrdErRt1A;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getOBERTrbWrdErRt1AMutable () {
    set_has_OBERTrbWrdErRt1A();
    return _OBERTrbWrdErRt1A;
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt1A (const ::std::string& OBERTrbWrdErRt1A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt1A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt1A();
    this->_OBERTrbWrdErRt1A = OBERTrbWrdErRt1A_;
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt1A (const char* OBERTrbWrdErRt1A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt1A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt1A();
    this->_OBERTrbWrdErRt1A.assign(OBERTrbWrdErRt1A_);
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt1A (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt1A();
    this->_OBERTrbWrdErRt1A.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::clearOBERTrbWrdErRt1B() {
    if (hasOBERTrbWrdErRt1B()) {
         clear_has_OBERTrbWrdErRt1B();
        _OBERTrbWrdErRt1B.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasOBERTrbWrdErRt1B () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getOBERTrbWrdErRt1B () const {
    return _OBERTrbWrdErRt1B;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getOBERTrbWrdErRt1BMutable () {
    set_has_OBERTrbWrdErRt1B();
    return _OBERTrbWrdErRt1B;
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt1B (const ::std::string& OBERTrbWrdErRt1B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt1B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt1B();
    this->_OBERTrbWrdErRt1B = OBERTrbWrdErRt1B_;
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt1B (const char* OBERTrbWrdErRt1B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt1B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt1B();
    this->_OBERTrbWrdErRt1B.assign(OBERTrbWrdErRt1B_);
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt1B (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt1B();
    this->_OBERTrbWrdErRt1B.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::clearOBERTrbWrdErRt2A() {
    if (hasOBERTrbWrdErRt2A()) {
         clear_has_OBERTrbWrdErRt2A();
        _OBERTrbWrdErRt2A.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasOBERTrbWrdErRt2A () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getOBERTrbWrdErRt2A () const {
    return _OBERTrbWrdErRt2A;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getOBERTrbWrdErRt2AMutable () {
    set_has_OBERTrbWrdErRt2A();
    return _OBERTrbWrdErRt2A;
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt2A (const ::std::string& OBERTrbWrdErRt2A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt2A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt2A();
    this->_OBERTrbWrdErRt2A = OBERTrbWrdErRt2A_;
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt2A (const char* OBERTrbWrdErRt2A_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt2A_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt2A();
    this->_OBERTrbWrdErRt2A.assign(OBERTrbWrdErRt2A_);
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt2A (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt2A();
    this->_OBERTrbWrdErRt2A.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::clearOBERTrbWrdErRt2B() {
    if (hasOBERTrbWrdErRt2B()) {
         clear_has_OBERTrbWrdErRt2B();
        _OBERTrbWrdErRt2B.clear();
     }
}

inline bool T_SxmDetOvrlSignalQuality::hasOBERTrbWrdErRt2B () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::string& T_SxmDetOvrlSignalQuality::getOBERTrbWrdErRt2B () const {
    return _OBERTrbWrdErRt2B;
}

inline ::std::string& T_SxmDetOvrlSignalQuality::getOBERTrbWrdErRt2BMutable () {
    set_has_OBERTrbWrdErRt2B();
    return _OBERTrbWrdErRt2B;
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt2B (const ::std::string& OBERTrbWrdErRt2B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt2B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt2B();
    this->_OBERTrbWrdErRt2B = OBERTrbWrdErRt2B_;
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt2B (const char* OBERTrbWrdErRt2B_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (OBERTrbWrdErRt2B_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt2B();
    this->_OBERTrbWrdErRt2B.assign(OBERTrbWrdErRt2B_);
}

inline void T_SxmDetOvrlSignalQuality::setOBERTrbWrdErRt2B (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_OBERTrbWrdErRt2B();
    this->_OBERTrbWrdErRt2B.assign(value, size);
}

inline void T_SxmDetOvrlSignalQuality::set_has_ReceiverState () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_ReceiverState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SxmDetOvrlSignalQuality::set_has_OBerS1A () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_OBerS1A () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SxmDetOvrlSignalQuality::set_has_OBerS2A () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_OBerS2A () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SxmDetOvrlSignalQuality::set_has_OBerTA () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_OBerTA () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SxmDetOvrlSignalQuality::set_has_OBerS1B () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_OBerS1B () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SxmDetOvrlSignalQuality::set_has_OBerS2B () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_OBerS2B () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SxmDetOvrlSignalQuality::set_has_OBerTB () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_OBerTB () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SxmDetOvrlSignalQuality::set_has_OBERTrbWrdErRt0A () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_OBERTrbWrdErRt0A () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_SxmDetOvrlSignalQuality::set_has_OBERTrbWrdErRt0B () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_OBERTrbWrdErRt0B () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_SxmDetOvrlSignalQuality::set_has_OBERTrbWrdErRt1A () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_OBERTrbWrdErRt1A () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_SxmDetOvrlSignalQuality::set_has_OBERTrbWrdErRt1B () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_OBERTrbWrdErRt1B () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_SxmDetOvrlSignalQuality::set_has_OBERTrbWrdErRt2A () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_OBERTrbWrdErRt2A () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_SxmDetOvrlSignalQuality::set_has_OBERTrbWrdErRt2B () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_SxmDetOvrlSignalQuality::clear_has_OBERTrbWrdErRt2B () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline  T_SxmVersionInfo::T_SxmVersionInfo ()  :
    _ModuleId (),
    _HwRev (),
    _SwRev (),
    _SxiRev (),
    _BbRev (),
    _HDecRev (),
    _RFRev (),
    _Capability (),
    _SPLRev ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmVersionInfo::T_SxmVersionInfo (const T_SxmVersionInfo &rhs)  :
    _ModuleId (),
    _HwRev (),
    _SwRev (),
    _SxiRev (),
    _BbRev (),
    _HDecRev (),
    _RFRev (),
    _Capability (),
    _SPLRev ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmVersionInfo::T_SxmVersionInfo (const ::std::string& ModuleId_, const ::std::string& HwRev_, const ::std::string& SwRev_, const ::std::string& SxiRev_, const ::std::string& BbRev_, const ::std::string& HDecRev_, const ::std::string& RFRev_, const ::std::string& Capability_, const ::std::string& SPLRev_)  :
    _ModuleId (ModuleId_),
    _HwRev (HwRev_),
    _SwRev (SwRev_),
    _SxiRev (SxiRev_),
    _BbRev (BbRev_),
    _HDecRev (HDecRev_),
    _RFRev (RFRev_),
    _Capability (Capability_),
    _SPLRev (SPLRev_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ModuleId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (HwRev_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SwRev_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SxiRev_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BbRev_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (HDecRev_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RFRev_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Capability_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SPLRev_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmVersionInfo::~T_SxmVersionInfo() {
}

inline T_SxmVersionInfo& T_SxmVersionInfo::operator = (const T_SxmVersionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasModuleId()) {
            setModuleId(rhs.getModuleId());
        } else {
            clearModuleId();
        }
        if (rhs.hasHwRev()) {
            setHwRev(rhs.getHwRev());
        } else {
            clearHwRev();
        }
        if (rhs.hasSwRev()) {
            setSwRev(rhs.getSwRev());
        } else {
            clearSwRev();
        }
        if (rhs.hasSxiRev()) {
            setSxiRev(rhs.getSxiRev());
        } else {
            clearSxiRev();
        }
        if (rhs.hasBbRev()) {
            setBbRev(rhs.getBbRev());
        } else {
            clearBbRev();
        }
        if (rhs.hasHDecRev()) {
            setHDecRev(rhs.getHDecRev());
        } else {
            clearHDecRev();
        }
        if (rhs.hasRFRev()) {
            setRFRev(rhs.getRFRev());
        } else {
            clearRFRev();
        }
        if (rhs.hasCapability()) {
            setCapability(rhs.getCapability());
        } else {
            clearCapability();
        }
        if (rhs.hasSPLRev()) {
            setSPLRev(rhs.getSPLRev());
        } else {
            clearSPLRev();
        }
    }
    return *this;
}

inline bool T_SxmVersionInfo::operator == (const T_SxmVersionInfo& rhs) const {
    return (((!hasModuleId() && !rhs.hasModuleId()) || getModuleId() == rhs.getModuleId()) &&
        ((!hasHwRev() && !rhs.hasHwRev()) || getHwRev() == rhs.getHwRev()) &&
        ((!hasSwRev() && !rhs.hasSwRev()) || getSwRev() == rhs.getSwRev()) &&
        ((!hasSxiRev() && !rhs.hasSxiRev()) || getSxiRev() == rhs.getSxiRev()) &&
        ((!hasBbRev() && !rhs.hasBbRev()) || getBbRev() == rhs.getBbRev()) &&
        ((!hasHDecRev() && !rhs.hasHDecRev()) || getHDecRev() == rhs.getHDecRev()) &&
        ((!hasRFRev() && !rhs.hasRFRev()) || getRFRev() == rhs.getRFRev()) &&
        ((!hasCapability() && !rhs.hasCapability()) || getCapability() == rhs.getCapability()) &&
        ((!hasSPLRev() && !rhs.hasSPLRev()) || getSPLRev() == rhs.getSPLRev()));
}

inline bool T_SxmVersionInfo::operator != (const T_SxmVersionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmVersionInfo::operator < (const T_SxmVersionInfo& rhs) const {
    if (hasModuleId() || rhs.hasModuleId()) {
        if (getModuleId() < rhs.getModuleId()) return true;
        if (getModuleId() > rhs.getModuleId()) return false;
    }
    if (hasHwRev() || rhs.hasHwRev()) {
        if (getHwRev() < rhs.getHwRev()) return true;
        if (getHwRev() > rhs.getHwRev()) return false;
    }
    if (hasSwRev() || rhs.hasSwRev()) {
        if (getSwRev() < rhs.getSwRev()) return true;
        if (getSwRev() > rhs.getSwRev()) return false;
    }
    if (hasSxiRev() || rhs.hasSxiRev()) {
        if (getSxiRev() < rhs.getSxiRev()) return true;
        if (getSxiRev() > rhs.getSxiRev()) return false;
    }
    if (hasBbRev() || rhs.hasBbRev()) {
        if (getBbRev() < rhs.getBbRev()) return true;
        if (getBbRev() > rhs.getBbRev()) return false;
    }
    if (hasHDecRev() || rhs.hasHDecRev()) {
        if (getHDecRev() < rhs.getHDecRev()) return true;
        if (getHDecRev() > rhs.getHDecRev()) return false;
    }
    if (hasRFRev() || rhs.hasRFRev()) {
        if (getRFRev() < rhs.getRFRev()) return true;
        if (getRFRev() > rhs.getRFRev()) return false;
    }
    if (hasCapability() || rhs.hasCapability()) {
        if (getCapability() < rhs.getCapability()) return true;
        if (getCapability() > rhs.getCapability()) return false;
    }
    if (hasSPLRev() || rhs.hasSPLRev()) {
        if (getSPLRev() < rhs.getSPLRev()) return true;
        if (getSPLRev() > rhs.getSPLRev()) return false;
    }
    return false;
}

inline bool T_SxmVersionInfo::operator > (const T_SxmVersionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmVersionInfo::clear() {
    clearModuleId();
    clearHwRev();
    clearSwRev();
    clearSxiRev();
    clearBbRev();
    clearHDecRev();
    clearRFRev();
    clearCapability();
    clearSPLRev();
}

inline void T_SxmVersionInfo::clearModuleId() {
    if (hasModuleId()) {
         clear_has_ModuleId();
        _ModuleId.clear();
     }
}

inline bool T_SxmVersionInfo::hasModuleId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_SxmVersionInfo::getModuleId () const {
    return _ModuleId;
}

inline ::std::string& T_SxmVersionInfo::getModuleIdMutable () {
    set_has_ModuleId();
    return _ModuleId;
}

inline void T_SxmVersionInfo::setModuleId (const ::std::string& ModuleId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ModuleId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ModuleId();
    this->_ModuleId = ModuleId_;
}

inline void T_SxmVersionInfo::setModuleId (const char* ModuleId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ModuleId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ModuleId();
    this->_ModuleId.assign(ModuleId_);
}

inline void T_SxmVersionInfo::setModuleId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ModuleId();
    this->_ModuleId.assign(value, size);
}

inline void T_SxmVersionInfo::clearHwRev() {
    if (hasHwRev()) {
         clear_has_HwRev();
        _HwRev.clear();
     }
}

inline bool T_SxmVersionInfo::hasHwRev () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SxmVersionInfo::getHwRev () const {
    return _HwRev;
}

inline ::std::string& T_SxmVersionInfo::getHwRevMutable () {
    set_has_HwRev();
    return _HwRev;
}

inline void T_SxmVersionInfo::setHwRev (const ::std::string& HwRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (HwRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_HwRev();
    this->_HwRev = HwRev_;
}

inline void T_SxmVersionInfo::setHwRev (const char* HwRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (HwRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_HwRev();
    this->_HwRev.assign(HwRev_);
}

inline void T_SxmVersionInfo::setHwRev (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_HwRev();
    this->_HwRev.assign(value, size);
}

inline void T_SxmVersionInfo::clearSwRev() {
    if (hasSwRev()) {
         clear_has_SwRev();
        _SwRev.clear();
     }
}

inline bool T_SxmVersionInfo::hasSwRev () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_SxmVersionInfo::getSwRev () const {
    return _SwRev;
}

inline ::std::string& T_SxmVersionInfo::getSwRevMutable () {
    set_has_SwRev();
    return _SwRev;
}

inline void T_SxmVersionInfo::setSwRev (const ::std::string& SwRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SwRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SwRev();
    this->_SwRev = SwRev_;
}

inline void T_SxmVersionInfo::setSwRev (const char* SwRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SwRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SwRev();
    this->_SwRev.assign(SwRev_);
}

inline void T_SxmVersionInfo::setSwRev (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SwRev();
    this->_SwRev.assign(value, size);
}

inline void T_SxmVersionInfo::clearSxiRev() {
    if (hasSxiRev()) {
         clear_has_SxiRev();
        _SxiRev.clear();
     }
}

inline bool T_SxmVersionInfo::hasSxiRev () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_SxmVersionInfo::getSxiRev () const {
    return _SxiRev;
}

inline ::std::string& T_SxmVersionInfo::getSxiRevMutable () {
    set_has_SxiRev();
    return _SxiRev;
}

inline void T_SxmVersionInfo::setSxiRev (const ::std::string& SxiRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SxiRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SxiRev();
    this->_SxiRev = SxiRev_;
}

inline void T_SxmVersionInfo::setSxiRev (const char* SxiRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SxiRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SxiRev();
    this->_SxiRev.assign(SxiRev_);
}

inline void T_SxmVersionInfo::setSxiRev (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SxiRev();
    this->_SxiRev.assign(value, size);
}

inline void T_SxmVersionInfo::clearBbRev() {
    if (hasBbRev()) {
         clear_has_BbRev();
        _BbRev.clear();
     }
}

inline bool T_SxmVersionInfo::hasBbRev () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_SxmVersionInfo::getBbRev () const {
    return _BbRev;
}

inline ::std::string& T_SxmVersionInfo::getBbRevMutable () {
    set_has_BbRev();
    return _BbRev;
}

inline void T_SxmVersionInfo::setBbRev (const ::std::string& BbRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BbRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BbRev();
    this->_BbRev = BbRev_;
}

inline void T_SxmVersionInfo::setBbRev (const char* BbRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BbRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BbRev();
    this->_BbRev.assign(BbRev_);
}

inline void T_SxmVersionInfo::setBbRev (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BbRev();
    this->_BbRev.assign(value, size);
}

inline void T_SxmVersionInfo::clearHDecRev() {
    if (hasHDecRev()) {
         clear_has_HDecRev();
        _HDecRev.clear();
     }
}

inline bool T_SxmVersionInfo::hasHDecRev () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_SxmVersionInfo::getHDecRev () const {
    return _HDecRev;
}

inline ::std::string& T_SxmVersionInfo::getHDecRevMutable () {
    set_has_HDecRev();
    return _HDecRev;
}

inline void T_SxmVersionInfo::setHDecRev (const ::std::string& HDecRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (HDecRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_HDecRev();
    this->_HDecRev = HDecRev_;
}

inline void T_SxmVersionInfo::setHDecRev (const char* HDecRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (HDecRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_HDecRev();
    this->_HDecRev.assign(HDecRev_);
}

inline void T_SxmVersionInfo::setHDecRev (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_HDecRev();
    this->_HDecRev.assign(value, size);
}

inline void T_SxmVersionInfo::clearRFRev() {
    if (hasRFRev()) {
         clear_has_RFRev();
        _RFRev.clear();
     }
}

inline bool T_SxmVersionInfo::hasRFRev () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_SxmVersionInfo::getRFRev () const {
    return _RFRev;
}

inline ::std::string& T_SxmVersionInfo::getRFRevMutable () {
    set_has_RFRev();
    return _RFRev;
}

inline void T_SxmVersionInfo::setRFRev (const ::std::string& RFRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RFRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RFRev();
    this->_RFRev = RFRev_;
}

inline void T_SxmVersionInfo::setRFRev (const char* RFRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RFRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RFRev();
    this->_RFRev.assign(RFRev_);
}

inline void T_SxmVersionInfo::setRFRev (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RFRev();
    this->_RFRev.assign(value, size);
}

inline void T_SxmVersionInfo::clearCapability() {
    if (hasCapability()) {
         clear_has_Capability();
        _Capability.clear();
     }
}

inline bool T_SxmVersionInfo::hasCapability () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_SxmVersionInfo::getCapability () const {
    return _Capability;
}

inline ::std::string& T_SxmVersionInfo::getCapabilityMutable () {
    set_has_Capability();
    return _Capability;
}

inline void T_SxmVersionInfo::setCapability (const ::std::string& Capability_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Capability_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Capability();
    this->_Capability = Capability_;
}

inline void T_SxmVersionInfo::setCapability (const char* Capability_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Capability_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Capability();
    this->_Capability.assign(Capability_);
}

inline void T_SxmVersionInfo::setCapability (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Capability();
    this->_Capability.assign(value, size);
}

inline void T_SxmVersionInfo::clearSPLRev() {
    if (hasSPLRev()) {
         clear_has_SPLRev();
        _SPLRev.clear();
     }
}

inline bool T_SxmVersionInfo::hasSPLRev () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_SxmVersionInfo::getSPLRev () const {
    return _SPLRev;
}

inline ::std::string& T_SxmVersionInfo::getSPLRevMutable () {
    set_has_SPLRev();
    return _SPLRev;
}

inline void T_SxmVersionInfo::setSPLRev (const ::std::string& SPLRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SPLRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SPLRev();
    this->_SPLRev = SPLRev_;
}

inline void T_SxmVersionInfo::setSPLRev (const char* SPLRev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SPLRev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SPLRev();
    this->_SPLRev.assign(SPLRev_);
}

inline void T_SxmVersionInfo::setSPLRev (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SPLRev();
    this->_SPLRev.assign(value, size);
}

inline void T_SxmVersionInfo::set_has_ModuleId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmVersionInfo::clear_has_ModuleId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SxmVersionInfo::set_has_HwRev () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SxmVersionInfo::clear_has_HwRev () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SxmVersionInfo::set_has_SwRev () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SxmVersionInfo::clear_has_SwRev () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SxmVersionInfo::set_has_SxiRev () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SxmVersionInfo::clear_has_SxiRev () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SxmVersionInfo::set_has_BbRev () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SxmVersionInfo::clear_has_BbRev () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SxmVersionInfo::set_has_HDecRev () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SxmVersionInfo::clear_has_HDecRev () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SxmVersionInfo::set_has_RFRev () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SxmVersionInfo::clear_has_RFRev () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SxmVersionInfo::set_has_Capability () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SxmVersionInfo::clear_has_Capability () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_SxmVersionInfo::set_has_SPLRev () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_SxmVersionInfo::clear_has_SPLRev () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_SxmDataSubStatus::T_SxmDataSubStatus ()  :
    _SubStatus (0u),
    _ReasonCode (0u),
    _SuspendedDate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmDataSubStatus::T_SxmDataSubStatus (const T_SxmDataSubStatus &rhs)  :
    _SubStatus (0u),
    _ReasonCode (0u),
    _SuspendedDate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmDataSubStatus::T_SxmDataSubStatus (uint8 SubStatus_, uint8 ReasonCode_, uint32 SuspendedDate_)  :
    _SubStatus (SubStatus_),
    _ReasonCode (ReasonCode_),
    _SuspendedDate (SuspendedDate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmDataSubStatus::~T_SxmDataSubStatus() {
}

inline T_SxmDataSubStatus& T_SxmDataSubStatus::operator = (const T_SxmDataSubStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSubStatus()) {
            setSubStatus(rhs.getSubStatus());
        } else {
            clearSubStatus();
        }
        if (rhs.hasReasonCode()) {
            setReasonCode(rhs.getReasonCode());
        } else {
            clearReasonCode();
        }
        if (rhs.hasSuspendedDate()) {
            setSuspendedDate(rhs.getSuspendedDate());
        } else {
            clearSuspendedDate();
        }
    }
    return *this;
}

inline bool T_SxmDataSubStatus::operator == (const T_SxmDataSubStatus& rhs) const {
    return (((!hasSubStatus() && !rhs.hasSubStatus()) || getSubStatus() == rhs.getSubStatus()) &&
        ((!hasReasonCode() && !rhs.hasReasonCode()) || getReasonCode() == rhs.getReasonCode()) &&
        ((!hasSuspendedDate() && !rhs.hasSuspendedDate()) || getSuspendedDate() == rhs.getSuspendedDate()));
}

inline bool T_SxmDataSubStatus::operator != (const T_SxmDataSubStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmDataSubStatus::operator < (const T_SxmDataSubStatus& rhs) const {
    if (hasSubStatus() || rhs.hasSubStatus()) {
        if (getSubStatus() < rhs.getSubStatus()) return true;
        if (getSubStatus() > rhs.getSubStatus()) return false;
    }
    if (hasReasonCode() || rhs.hasReasonCode()) {
        if (getReasonCode() < rhs.getReasonCode()) return true;
        if (getReasonCode() > rhs.getReasonCode()) return false;
    }
    if (hasSuspendedDate() || rhs.hasSuspendedDate()) {
        if (getSuspendedDate() < rhs.getSuspendedDate()) return true;
        if (getSuspendedDate() > rhs.getSuspendedDate()) return false;
    }
    return false;
}

inline bool T_SxmDataSubStatus::operator > (const T_SxmDataSubStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmDataSubStatus::clear() {
    clearSubStatus();
    clearReasonCode();
    clearSuspendedDate();
}

inline void T_SxmDataSubStatus::clearSubStatus() {
    if (hasSubStatus()) {
         clear_has_SubStatus();
        _SubStatus = 0u;
     }
}

inline bool T_SxmDataSubStatus::hasSubStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SxmDataSubStatus::getSubStatus () const {
    return _SubStatus;
}

inline void T_SxmDataSubStatus::setSubStatus (uint8 SubStatus_) {
    set_has_SubStatus();
    this->_SubStatus = SubStatus_;
}

inline void T_SxmDataSubStatus::clearReasonCode() {
    if (hasReasonCode()) {
         clear_has_ReasonCode();
        _ReasonCode = 0u;
     }
}

inline bool T_SxmDataSubStatus::hasReasonCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_SxmDataSubStatus::getReasonCode () const {
    return _ReasonCode;
}

inline void T_SxmDataSubStatus::setReasonCode (uint8 ReasonCode_) {
    set_has_ReasonCode();
    this->_ReasonCode = ReasonCode_;
}

inline void T_SxmDataSubStatus::clearSuspendedDate() {
    if (hasSuspendedDate()) {
         clear_has_SuspendedDate();
        _SuspendedDate = 0u;
     }
}

inline bool T_SxmDataSubStatus::hasSuspendedDate () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_SxmDataSubStatus::getSuspendedDate () const {
    return _SuspendedDate;
}

inline void T_SxmDataSubStatus::setSuspendedDate (uint32 SuspendedDate_) {
    set_has_SuspendedDate();
    this->_SuspendedDate = SuspendedDate_;
}

inline void T_SxmDataSubStatus::set_has_SubStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmDataSubStatus::clear_has_SubStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SxmDataSubStatus::set_has_ReasonCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SxmDataSubStatus::clear_has_ReasonCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SxmDataSubStatus::set_has_SuspendedDate () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SxmDataSubStatus::clear_has_SuspendedDate () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SxmDiagTestModeData::T_SxmDiagTestModeData ()  :
    _DetSignalQuality (),
    _DetOvrlSignalQuality (),
    _SxmVersionInfo (),
    _SxmSubscriptionState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmDiagTestModeData::T_SxmDiagTestModeData (const T_SxmDiagTestModeData &rhs)  :
    _DetSignalQuality (),
    _DetOvrlSignalQuality (),
    _SxmVersionInfo (),
    _SxmSubscriptionState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmDiagTestModeData::T_SxmDiagTestModeData (const T_SxmDetSignalQuality& DetSignalQuality_, const T_SxmDetOvrlSignalQuality& DetOvrlSignalQuality_, const T_SxmVersionInfo& SxmVersionInfo_, const T_SxmDataSubStatus& SxmSubscriptionState_)  :
    _DetSignalQuality (DetSignalQuality_),
    _DetOvrlSignalQuality (DetOvrlSignalQuality_),
    _SxmVersionInfo (SxmVersionInfo_),
    _SxmSubscriptionState (SxmSubscriptionState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmDiagTestModeData::~T_SxmDiagTestModeData() {
}

inline T_SxmDiagTestModeData& T_SxmDiagTestModeData::operator = (const T_SxmDiagTestModeData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDetSignalQuality()) {
            setDetSignalQuality(rhs.getDetSignalQuality());
        } else {
            clearDetSignalQuality();
        }
        if (rhs.hasDetOvrlSignalQuality()) {
            setDetOvrlSignalQuality(rhs.getDetOvrlSignalQuality());
        } else {
            clearDetOvrlSignalQuality();
        }
        if (rhs.hasSxmVersionInfo()) {
            setSxmVersionInfo(rhs.getSxmVersionInfo());
        } else {
            clearSxmVersionInfo();
        }
        if (rhs.hasSxmSubscriptionState()) {
            setSxmSubscriptionState(rhs.getSxmSubscriptionState());
        } else {
            clearSxmSubscriptionState();
        }
    }
    return *this;
}

inline bool T_SxmDiagTestModeData::operator == (const T_SxmDiagTestModeData& rhs) const {
    return (((!hasDetSignalQuality() && !rhs.hasDetSignalQuality()) || getDetSignalQuality() == rhs.getDetSignalQuality()) &&
        ((!hasDetOvrlSignalQuality() && !rhs.hasDetOvrlSignalQuality()) || getDetOvrlSignalQuality() == rhs.getDetOvrlSignalQuality()) &&
        ((!hasSxmVersionInfo() && !rhs.hasSxmVersionInfo()) || getSxmVersionInfo() == rhs.getSxmVersionInfo()) &&
        ((!hasSxmSubscriptionState() && !rhs.hasSxmSubscriptionState()) || getSxmSubscriptionState() == rhs.getSxmSubscriptionState()));
}

inline bool T_SxmDiagTestModeData::operator != (const T_SxmDiagTestModeData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmDiagTestModeData::operator < (const T_SxmDiagTestModeData& rhs) const {
    if (hasDetSignalQuality() || rhs.hasDetSignalQuality()) {
        if (getDetSignalQuality() < rhs.getDetSignalQuality()) return true;
        if (getDetSignalQuality() > rhs.getDetSignalQuality()) return false;
    }
    if (hasDetOvrlSignalQuality() || rhs.hasDetOvrlSignalQuality()) {
        if (getDetOvrlSignalQuality() < rhs.getDetOvrlSignalQuality()) return true;
        if (getDetOvrlSignalQuality() > rhs.getDetOvrlSignalQuality()) return false;
    }
    if (hasSxmVersionInfo() || rhs.hasSxmVersionInfo()) {
        if (getSxmVersionInfo() < rhs.getSxmVersionInfo()) return true;
        if (getSxmVersionInfo() > rhs.getSxmVersionInfo()) return false;
    }
    if (hasSxmSubscriptionState() || rhs.hasSxmSubscriptionState()) {
        if (getSxmSubscriptionState() < rhs.getSxmSubscriptionState()) return true;
        if (getSxmSubscriptionState() > rhs.getSxmSubscriptionState()) return false;
    }
    return false;
}

inline bool T_SxmDiagTestModeData::operator > (const T_SxmDiagTestModeData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmDiagTestModeData::clear() {
    clearDetSignalQuality();
    clearDetOvrlSignalQuality();
    clearSxmVersionInfo();
    clearSxmSubscriptionState();
}

inline void T_SxmDiagTestModeData::clearDetSignalQuality() {
    if (hasDetSignalQuality()) {
         clear_has_DetSignalQuality();
        _DetSignalQuality.clear();
     }
}

inline bool T_SxmDiagTestModeData::hasDetSignalQuality () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_SxmDetSignalQuality& T_SxmDiagTestModeData::getDetSignalQuality () const {
    return _DetSignalQuality;
}

inline T_SxmDetSignalQuality& T_SxmDiagTestModeData::getDetSignalQualityMutable () {
    set_has_DetSignalQuality();
    return _DetSignalQuality;
}

inline void T_SxmDiagTestModeData::setDetSignalQuality (const T_SxmDetSignalQuality& DetSignalQuality_) {
    set_has_DetSignalQuality();
    this->_DetSignalQuality = DetSignalQuality_;
}

inline void T_SxmDiagTestModeData::clearDetOvrlSignalQuality() {
    if (hasDetOvrlSignalQuality()) {
         clear_has_DetOvrlSignalQuality();
        _DetOvrlSignalQuality.clear();
     }
}

inline bool T_SxmDiagTestModeData::hasDetOvrlSignalQuality () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_SxmDetOvrlSignalQuality& T_SxmDiagTestModeData::getDetOvrlSignalQuality () const {
    return _DetOvrlSignalQuality;
}

inline T_SxmDetOvrlSignalQuality& T_SxmDiagTestModeData::getDetOvrlSignalQualityMutable () {
    set_has_DetOvrlSignalQuality();
    return _DetOvrlSignalQuality;
}

inline void T_SxmDiagTestModeData::setDetOvrlSignalQuality (const T_SxmDetOvrlSignalQuality& DetOvrlSignalQuality_) {
    set_has_DetOvrlSignalQuality();
    this->_DetOvrlSignalQuality = DetOvrlSignalQuality_;
}

inline void T_SxmDiagTestModeData::clearSxmVersionInfo() {
    if (hasSxmVersionInfo()) {
         clear_has_SxmVersionInfo();
        _SxmVersionInfo.clear();
     }
}

inline bool T_SxmDiagTestModeData::hasSxmVersionInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_SxmVersionInfo& T_SxmDiagTestModeData::getSxmVersionInfo () const {
    return _SxmVersionInfo;
}

inline T_SxmVersionInfo& T_SxmDiagTestModeData::getSxmVersionInfoMutable () {
    set_has_SxmVersionInfo();
    return _SxmVersionInfo;
}

inline void T_SxmDiagTestModeData::setSxmVersionInfo (const T_SxmVersionInfo& SxmVersionInfo_) {
    set_has_SxmVersionInfo();
    this->_SxmVersionInfo = SxmVersionInfo_;
}

inline void T_SxmDiagTestModeData::clearSxmSubscriptionState() {
    if (hasSxmSubscriptionState()) {
         clear_has_SxmSubscriptionState();
        _SxmSubscriptionState.clear();
     }
}

inline bool T_SxmDiagTestModeData::hasSxmSubscriptionState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_SxmDataSubStatus& T_SxmDiagTestModeData::getSxmSubscriptionState () const {
    return _SxmSubscriptionState;
}

inline T_SxmDataSubStatus& T_SxmDiagTestModeData::getSxmSubscriptionStateMutable () {
    set_has_SxmSubscriptionState();
    return _SxmSubscriptionState;
}

inline void T_SxmDiagTestModeData::setSxmSubscriptionState (const T_SxmDataSubStatus& SxmSubscriptionState_) {
    set_has_SxmSubscriptionState();
    this->_SxmSubscriptionState = SxmSubscriptionState_;
}

inline void T_SxmDiagTestModeData::set_has_DetSignalQuality () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmDiagTestModeData::clear_has_DetSignalQuality () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SxmDiagTestModeData::set_has_DetOvrlSignalQuality () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SxmDiagTestModeData::clear_has_DetOvrlSignalQuality () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SxmDiagTestModeData::set_has_SxmVersionInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SxmDiagTestModeData::clear_has_SxmVersionInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SxmDiagTestModeData::set_has_SxmSubscriptionState () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SxmDiagTestModeData::clear_has_SxmSubscriptionState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_SxmSmsDbInfo::T_SxmSmsDbInfo ()  :
    _CgsDb (),
    _FuelDb (),
    _MovieDb (),
    _TabWeatherDb (),
    _StockDb (),
    _WsAlertsDb (),
    _SportsDB (),
    _ParkingDB (),
    _PhoneticsDB (),
    _FuelCanadaDB (),
    _SafeViewdb (),
    _SmsVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmSmsDbInfo::T_SxmSmsDbInfo (const T_SxmSmsDbInfo &rhs)  :
    _CgsDb (),
    _FuelDb (),
    _MovieDb (),
    _TabWeatherDb (),
    _StockDb (),
    _WsAlertsDb (),
    _SportsDB (),
    _ParkingDB (),
    _PhoneticsDB (),
    _FuelCanadaDB (),
    _SafeViewdb (),
    _SmsVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmSmsDbInfo::T_SxmSmsDbInfo (const ::std::string& CgsDb_, const ::std::string& FuelDb_, const ::std::string& MovieDb_, const ::std::string& TabWeatherDb_, const ::std::string& StockDb_, const ::std::string& WsAlertsDb_, const ::std::string& SportsDB_, const ::std::string& ParkingDB_, const ::std::string& PhoneticsDB_, const ::std::string& FuelCanadaDB_, const ::std::string& SafeViewdb_, const ::std::string& SmsVersion_)  :
    _CgsDb (CgsDb_),
    _FuelDb (FuelDb_),
    _MovieDb (MovieDb_),
    _TabWeatherDb (TabWeatherDb_),
    _StockDb (StockDb_),
    _WsAlertsDb (WsAlertsDb_),
    _SportsDB (SportsDB_),
    _ParkingDB (ParkingDB_),
    _PhoneticsDB (PhoneticsDB_),
    _FuelCanadaDB (FuelCanadaDB_),
    _SafeViewdb (SafeViewdb_),
    _SmsVersion (SmsVersion_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CgsDb_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelDb_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieDb_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TabWeatherDb_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockDb_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (WsAlertsDb_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SportsDB_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ParkingDB_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PhoneticsDB_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelCanadaDB_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SafeViewdb_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SmsVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmSmsDbInfo::~T_SxmSmsDbInfo() {
}

inline T_SxmSmsDbInfo& T_SxmSmsDbInfo::operator = (const T_SxmSmsDbInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCgsDb()) {
            setCgsDb(rhs.getCgsDb());
        } else {
            clearCgsDb();
        }
        if (rhs.hasFuelDb()) {
            setFuelDb(rhs.getFuelDb());
        } else {
            clearFuelDb();
        }
        if (rhs.hasMovieDb()) {
            setMovieDb(rhs.getMovieDb());
        } else {
            clearMovieDb();
        }
        if (rhs.hasTabWeatherDb()) {
            setTabWeatherDb(rhs.getTabWeatherDb());
        } else {
            clearTabWeatherDb();
        }
        if (rhs.hasStockDb()) {
            setStockDb(rhs.getStockDb());
        } else {
            clearStockDb();
        }
        if (rhs.hasWsAlertsDb()) {
            setWsAlertsDb(rhs.getWsAlertsDb());
        } else {
            clearWsAlertsDb();
        }
        if (rhs.hasSportsDB()) {
            setSportsDB(rhs.getSportsDB());
        } else {
            clearSportsDB();
        }
        if (rhs.hasParkingDB()) {
            setParkingDB(rhs.getParkingDB());
        } else {
            clearParkingDB();
        }
        if (rhs.hasPhoneticsDB()) {
            setPhoneticsDB(rhs.getPhoneticsDB());
        } else {
            clearPhoneticsDB();
        }
        if (rhs.hasFuelCanadaDB()) {
            setFuelCanadaDB(rhs.getFuelCanadaDB());
        } else {
            clearFuelCanadaDB();
        }
        if (rhs.hasSafeViewdb()) {
            setSafeViewdb(rhs.getSafeViewdb());
        } else {
            clearSafeViewdb();
        }
        if (rhs.hasSmsVersion()) {
            setSmsVersion(rhs.getSmsVersion());
        } else {
            clearSmsVersion();
        }
    }
    return *this;
}

inline bool T_SxmSmsDbInfo::operator == (const T_SxmSmsDbInfo& rhs) const {
    return (((!hasCgsDb() && !rhs.hasCgsDb()) || getCgsDb() == rhs.getCgsDb()) &&
        ((!hasFuelDb() && !rhs.hasFuelDb()) || getFuelDb() == rhs.getFuelDb()) &&
        ((!hasMovieDb() && !rhs.hasMovieDb()) || getMovieDb() == rhs.getMovieDb()) &&
        ((!hasTabWeatherDb() && !rhs.hasTabWeatherDb()) || getTabWeatherDb() == rhs.getTabWeatherDb()) &&
        ((!hasStockDb() && !rhs.hasStockDb()) || getStockDb() == rhs.getStockDb()) &&
        ((!hasWsAlertsDb() && !rhs.hasWsAlertsDb()) || getWsAlertsDb() == rhs.getWsAlertsDb()) &&
        ((!hasSportsDB() && !rhs.hasSportsDB()) || getSportsDB() == rhs.getSportsDB()) &&
        ((!hasParkingDB() && !rhs.hasParkingDB()) || getParkingDB() == rhs.getParkingDB()) &&
        ((!hasPhoneticsDB() && !rhs.hasPhoneticsDB()) || getPhoneticsDB() == rhs.getPhoneticsDB()) &&
        ((!hasFuelCanadaDB() && !rhs.hasFuelCanadaDB()) || getFuelCanadaDB() == rhs.getFuelCanadaDB()) &&
        ((!hasSafeViewdb() && !rhs.hasSafeViewdb()) || getSafeViewdb() == rhs.getSafeViewdb()) &&
        ((!hasSmsVersion() && !rhs.hasSmsVersion()) || getSmsVersion() == rhs.getSmsVersion()));
}

inline bool T_SxmSmsDbInfo::operator != (const T_SxmSmsDbInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmSmsDbInfo::operator < (const T_SxmSmsDbInfo& rhs) const {
    if (hasCgsDb() || rhs.hasCgsDb()) {
        if (getCgsDb() < rhs.getCgsDb()) return true;
        if (getCgsDb() > rhs.getCgsDb()) return false;
    }
    if (hasFuelDb() || rhs.hasFuelDb()) {
        if (getFuelDb() < rhs.getFuelDb()) return true;
        if (getFuelDb() > rhs.getFuelDb()) return false;
    }
    if (hasMovieDb() || rhs.hasMovieDb()) {
        if (getMovieDb() < rhs.getMovieDb()) return true;
        if (getMovieDb() > rhs.getMovieDb()) return false;
    }
    if (hasTabWeatherDb() || rhs.hasTabWeatherDb()) {
        if (getTabWeatherDb() < rhs.getTabWeatherDb()) return true;
        if (getTabWeatherDb() > rhs.getTabWeatherDb()) return false;
    }
    if (hasStockDb() || rhs.hasStockDb()) {
        if (getStockDb() < rhs.getStockDb()) return true;
        if (getStockDb() > rhs.getStockDb()) return false;
    }
    if (hasWsAlertsDb() || rhs.hasWsAlertsDb()) {
        if (getWsAlertsDb() < rhs.getWsAlertsDb()) return true;
        if (getWsAlertsDb() > rhs.getWsAlertsDb()) return false;
    }
    if (hasSportsDB() || rhs.hasSportsDB()) {
        if (getSportsDB() < rhs.getSportsDB()) return true;
        if (getSportsDB() > rhs.getSportsDB()) return false;
    }
    if (hasParkingDB() || rhs.hasParkingDB()) {
        if (getParkingDB() < rhs.getParkingDB()) return true;
        if (getParkingDB() > rhs.getParkingDB()) return false;
    }
    if (hasPhoneticsDB() || rhs.hasPhoneticsDB()) {
        if (getPhoneticsDB() < rhs.getPhoneticsDB()) return true;
        if (getPhoneticsDB() > rhs.getPhoneticsDB()) return false;
    }
    if (hasFuelCanadaDB() || rhs.hasFuelCanadaDB()) {
        if (getFuelCanadaDB() < rhs.getFuelCanadaDB()) return true;
        if (getFuelCanadaDB() > rhs.getFuelCanadaDB()) return false;
    }
    if (hasSafeViewdb() || rhs.hasSafeViewdb()) {
        if (getSafeViewdb() < rhs.getSafeViewdb()) return true;
        if (getSafeViewdb() > rhs.getSafeViewdb()) return false;
    }
    if (hasSmsVersion() || rhs.hasSmsVersion()) {
        if (getSmsVersion() < rhs.getSmsVersion()) return true;
        if (getSmsVersion() > rhs.getSmsVersion()) return false;
    }
    return false;
}

inline bool T_SxmSmsDbInfo::operator > (const T_SxmSmsDbInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmSmsDbInfo::clear() {
    clearCgsDb();
    clearFuelDb();
    clearMovieDb();
    clearTabWeatherDb();
    clearStockDb();
    clearWsAlertsDb();
    clearSportsDB();
    clearParkingDB();
    clearPhoneticsDB();
    clearFuelCanadaDB();
    clearSafeViewdb();
    clearSmsVersion();
}

inline void T_SxmSmsDbInfo::clearCgsDb() {
    if (hasCgsDb()) {
         clear_has_CgsDb();
        _CgsDb.clear();
     }
}

inline bool T_SxmSmsDbInfo::hasCgsDb () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_SxmSmsDbInfo::getCgsDb () const {
    return _CgsDb;
}

inline ::std::string& T_SxmSmsDbInfo::getCgsDbMutable () {
    set_has_CgsDb();
    return _CgsDb;
}

inline void T_SxmSmsDbInfo::setCgsDb (const ::std::string& CgsDb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CgsDb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CgsDb();
    this->_CgsDb = CgsDb_;
}

inline void T_SxmSmsDbInfo::setCgsDb (const char* CgsDb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CgsDb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CgsDb();
    this->_CgsDb.assign(CgsDb_);
}

inline void T_SxmSmsDbInfo::setCgsDb (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CgsDb();
    this->_CgsDb.assign(value, size);
}

inline void T_SxmSmsDbInfo::clearFuelDb() {
    if (hasFuelDb()) {
         clear_has_FuelDb();
        _FuelDb.clear();
     }
}

inline bool T_SxmSmsDbInfo::hasFuelDb () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SxmSmsDbInfo::getFuelDb () const {
    return _FuelDb;
}

inline ::std::string& T_SxmSmsDbInfo::getFuelDbMutable () {
    set_has_FuelDb();
    return _FuelDb;
}

inline void T_SxmSmsDbInfo::setFuelDb (const ::std::string& FuelDb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelDb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelDb();
    this->_FuelDb = FuelDb_;
}

inline void T_SxmSmsDbInfo::setFuelDb (const char* FuelDb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelDb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelDb();
    this->_FuelDb.assign(FuelDb_);
}

inline void T_SxmSmsDbInfo::setFuelDb (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelDb();
    this->_FuelDb.assign(value, size);
}

inline void T_SxmSmsDbInfo::clearMovieDb() {
    if (hasMovieDb()) {
         clear_has_MovieDb();
        _MovieDb.clear();
     }
}

inline bool T_SxmSmsDbInfo::hasMovieDb () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_SxmSmsDbInfo::getMovieDb () const {
    return _MovieDb;
}

inline ::std::string& T_SxmSmsDbInfo::getMovieDbMutable () {
    set_has_MovieDb();
    return _MovieDb;
}

inline void T_SxmSmsDbInfo::setMovieDb (const ::std::string& MovieDb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieDb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieDb();
    this->_MovieDb = MovieDb_;
}

inline void T_SxmSmsDbInfo::setMovieDb (const char* MovieDb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MovieDb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieDb();
    this->_MovieDb.assign(MovieDb_);
}

inline void T_SxmSmsDbInfo::setMovieDb (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MovieDb();
    this->_MovieDb.assign(value, size);
}

inline void T_SxmSmsDbInfo::clearTabWeatherDb() {
    if (hasTabWeatherDb()) {
         clear_has_TabWeatherDb();
        _TabWeatherDb.clear();
     }
}

inline bool T_SxmSmsDbInfo::hasTabWeatherDb () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_SxmSmsDbInfo::getTabWeatherDb () const {
    return _TabWeatherDb;
}

inline ::std::string& T_SxmSmsDbInfo::getTabWeatherDbMutable () {
    set_has_TabWeatherDb();
    return _TabWeatherDb;
}

inline void T_SxmSmsDbInfo::setTabWeatherDb (const ::std::string& TabWeatherDb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TabWeatherDb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TabWeatherDb();
    this->_TabWeatherDb = TabWeatherDb_;
}

inline void T_SxmSmsDbInfo::setTabWeatherDb (const char* TabWeatherDb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TabWeatherDb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TabWeatherDb();
    this->_TabWeatherDb.assign(TabWeatherDb_);
}

inline void T_SxmSmsDbInfo::setTabWeatherDb (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TabWeatherDb();
    this->_TabWeatherDb.assign(value, size);
}

inline void T_SxmSmsDbInfo::clearStockDb() {
    if (hasStockDb()) {
         clear_has_StockDb();
        _StockDb.clear();
     }
}

inline bool T_SxmSmsDbInfo::hasStockDb () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_SxmSmsDbInfo::getStockDb () const {
    return _StockDb;
}

inline ::std::string& T_SxmSmsDbInfo::getStockDbMutable () {
    set_has_StockDb();
    return _StockDb;
}

inline void T_SxmSmsDbInfo::setStockDb (const ::std::string& StockDb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockDb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockDb();
    this->_StockDb = StockDb_;
}

inline void T_SxmSmsDbInfo::setStockDb (const char* StockDb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StockDb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockDb();
    this->_StockDb.assign(StockDb_);
}

inline void T_SxmSmsDbInfo::setStockDb (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StockDb();
    this->_StockDb.assign(value, size);
}

inline void T_SxmSmsDbInfo::clearWsAlertsDb() {
    if (hasWsAlertsDb()) {
         clear_has_WsAlertsDb();
        _WsAlertsDb.clear();
     }
}

inline bool T_SxmSmsDbInfo::hasWsAlertsDb () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_SxmSmsDbInfo::getWsAlertsDb () const {
    return _WsAlertsDb;
}

inline ::std::string& T_SxmSmsDbInfo::getWsAlertsDbMutable () {
    set_has_WsAlertsDb();
    return _WsAlertsDb;
}

inline void T_SxmSmsDbInfo::setWsAlertsDb (const ::std::string& WsAlertsDb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (WsAlertsDb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_WsAlertsDb();
    this->_WsAlertsDb = WsAlertsDb_;
}

inline void T_SxmSmsDbInfo::setWsAlertsDb (const char* WsAlertsDb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (WsAlertsDb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_WsAlertsDb();
    this->_WsAlertsDb.assign(WsAlertsDb_);
}

inline void T_SxmSmsDbInfo::setWsAlertsDb (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_WsAlertsDb();
    this->_WsAlertsDb.assign(value, size);
}

inline void T_SxmSmsDbInfo::clearSportsDB() {
    if (hasSportsDB()) {
         clear_has_SportsDB();
        _SportsDB.clear();
     }
}

inline bool T_SxmSmsDbInfo::hasSportsDB () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_SxmSmsDbInfo::getSportsDB () const {
    return _SportsDB;
}

inline ::std::string& T_SxmSmsDbInfo::getSportsDBMutable () {
    set_has_SportsDB();
    return _SportsDB;
}

inline void T_SxmSmsDbInfo::setSportsDB (const ::std::string& SportsDB_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SportsDB_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SportsDB();
    this->_SportsDB = SportsDB_;
}

inline void T_SxmSmsDbInfo::setSportsDB (const char* SportsDB_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SportsDB_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SportsDB();
    this->_SportsDB.assign(SportsDB_);
}

inline void T_SxmSmsDbInfo::setSportsDB (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SportsDB();
    this->_SportsDB.assign(value, size);
}

inline void T_SxmSmsDbInfo::clearParkingDB() {
    if (hasParkingDB()) {
         clear_has_ParkingDB();
        _ParkingDB.clear();
     }
}

inline bool T_SxmSmsDbInfo::hasParkingDB () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_SxmSmsDbInfo::getParkingDB () const {
    return _ParkingDB;
}

inline ::std::string& T_SxmSmsDbInfo::getParkingDBMutable () {
    set_has_ParkingDB();
    return _ParkingDB;
}

inline void T_SxmSmsDbInfo::setParkingDB (const ::std::string& ParkingDB_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ParkingDB_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ParkingDB();
    this->_ParkingDB = ParkingDB_;
}

inline void T_SxmSmsDbInfo::setParkingDB (const char* ParkingDB_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ParkingDB_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ParkingDB();
    this->_ParkingDB.assign(ParkingDB_);
}

inline void T_SxmSmsDbInfo::setParkingDB (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ParkingDB();
    this->_ParkingDB.assign(value, size);
}

inline void T_SxmSmsDbInfo::clearPhoneticsDB() {
    if (hasPhoneticsDB()) {
         clear_has_PhoneticsDB();
        _PhoneticsDB.clear();
     }
}

inline bool T_SxmSmsDbInfo::hasPhoneticsDB () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_SxmSmsDbInfo::getPhoneticsDB () const {
    return _PhoneticsDB;
}

inline ::std::string& T_SxmSmsDbInfo::getPhoneticsDBMutable () {
    set_has_PhoneticsDB();
    return _PhoneticsDB;
}

inline void T_SxmSmsDbInfo::setPhoneticsDB (const ::std::string& PhoneticsDB_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PhoneticsDB_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PhoneticsDB();
    this->_PhoneticsDB = PhoneticsDB_;
}

inline void T_SxmSmsDbInfo::setPhoneticsDB (const char* PhoneticsDB_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PhoneticsDB_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PhoneticsDB();
    this->_PhoneticsDB.assign(PhoneticsDB_);
}

inline void T_SxmSmsDbInfo::setPhoneticsDB (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PhoneticsDB();
    this->_PhoneticsDB.assign(value, size);
}

inline void T_SxmSmsDbInfo::clearFuelCanadaDB() {
    if (hasFuelCanadaDB()) {
         clear_has_FuelCanadaDB();
        _FuelCanadaDB.clear();
     }
}

inline bool T_SxmSmsDbInfo::hasFuelCanadaDB () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_SxmSmsDbInfo::getFuelCanadaDB () const {
    return _FuelCanadaDB;
}

inline ::std::string& T_SxmSmsDbInfo::getFuelCanadaDBMutable () {
    set_has_FuelCanadaDB();
    return _FuelCanadaDB;
}

inline void T_SxmSmsDbInfo::setFuelCanadaDB (const ::std::string& FuelCanadaDB_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelCanadaDB_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelCanadaDB();
    this->_FuelCanadaDB = FuelCanadaDB_;
}

inline void T_SxmSmsDbInfo::setFuelCanadaDB (const char* FuelCanadaDB_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FuelCanadaDB_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelCanadaDB();
    this->_FuelCanadaDB.assign(FuelCanadaDB_);
}

inline void T_SxmSmsDbInfo::setFuelCanadaDB (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FuelCanadaDB();
    this->_FuelCanadaDB.assign(value, size);
}

inline void T_SxmSmsDbInfo::clearSafeViewdb() {
    if (hasSafeViewdb()) {
         clear_has_SafeViewdb();
        _SafeViewdb.clear();
     }
}

inline bool T_SxmSmsDbInfo::hasSafeViewdb () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_SxmSmsDbInfo::getSafeViewdb () const {
    return _SafeViewdb;
}

inline ::std::string& T_SxmSmsDbInfo::getSafeViewdbMutable () {
    set_has_SafeViewdb();
    return _SafeViewdb;
}

inline void T_SxmSmsDbInfo::setSafeViewdb (const ::std::string& SafeViewdb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SafeViewdb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SafeViewdb();
    this->_SafeViewdb = SafeViewdb_;
}

inline void T_SxmSmsDbInfo::setSafeViewdb (const char* SafeViewdb_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SafeViewdb_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SafeViewdb();
    this->_SafeViewdb.assign(SafeViewdb_);
}

inline void T_SxmSmsDbInfo::setSafeViewdb (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SafeViewdb();
    this->_SafeViewdb.assign(value, size);
}

inline void T_SxmSmsDbInfo::clearSmsVersion() {
    if (hasSmsVersion()) {
         clear_has_SmsVersion();
        _SmsVersion.clear();
     }
}

inline bool T_SxmSmsDbInfo::hasSmsVersion () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_SxmSmsDbInfo::getSmsVersion () const {
    return _SmsVersion;
}

inline ::std::string& T_SxmSmsDbInfo::getSmsVersionMutable () {
    set_has_SmsVersion();
    return _SmsVersion;
}

inline void T_SxmSmsDbInfo::setSmsVersion (const ::std::string& SmsVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SmsVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SmsVersion();
    this->_SmsVersion = SmsVersion_;
}

inline void T_SxmSmsDbInfo::setSmsVersion (const char* SmsVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SmsVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SmsVersion();
    this->_SmsVersion.assign(SmsVersion_);
}

inline void T_SxmSmsDbInfo::setSmsVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SmsVersion();
    this->_SmsVersion.assign(value, size);
}

inline void T_SxmSmsDbInfo::set_has_CgsDb () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmSmsDbInfo::clear_has_CgsDb () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SxmSmsDbInfo::set_has_FuelDb () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SxmSmsDbInfo::clear_has_FuelDb () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SxmSmsDbInfo::set_has_MovieDb () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SxmSmsDbInfo::clear_has_MovieDb () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SxmSmsDbInfo::set_has_TabWeatherDb () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SxmSmsDbInfo::clear_has_TabWeatherDb () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SxmSmsDbInfo::set_has_StockDb () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SxmSmsDbInfo::clear_has_StockDb () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SxmSmsDbInfo::set_has_WsAlertsDb () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SxmSmsDbInfo::clear_has_WsAlertsDb () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SxmSmsDbInfo::set_has_SportsDB () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SxmSmsDbInfo::clear_has_SportsDB () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SxmSmsDbInfo::set_has_ParkingDB () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SxmSmsDbInfo::clear_has_ParkingDB () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_SxmSmsDbInfo::set_has_PhoneticsDB () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_SxmSmsDbInfo::clear_has_PhoneticsDB () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_SxmSmsDbInfo::set_has_FuelCanadaDB () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_SxmSmsDbInfo::clear_has_FuelCanadaDB () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_SxmSmsDbInfo::set_has_SafeViewdb () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_SxmSmsDbInfo::clear_has_SafeViewdb () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_SxmSmsDbInfo::set_has_SmsVersion () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_SxmSmsDbInfo::clear_has_SmsVersion () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline  T_SxmAudioSubInfo::T_SxmAudioSubInfo ()  :
    _SubStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmAudioSubInfo::T_SxmAudioSubInfo (const T_SxmAudioSubInfo &rhs)  :
    _SubStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmAudioSubInfo::T_SxmAudioSubInfo (uint8 SubStatus_)  :
    _SubStatus (SubStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmAudioSubInfo::~T_SxmAudioSubInfo() {
}

inline T_SxmAudioSubInfo& T_SxmAudioSubInfo::operator = (const T_SxmAudioSubInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSubStatus()) {
            setSubStatus(rhs.getSubStatus());
        } else {
            clearSubStatus();
        }
    }
    return *this;
}

inline bool T_SxmAudioSubInfo::operator == (const T_SxmAudioSubInfo& rhs) const {
    return (((!hasSubStatus() && !rhs.hasSubStatus()) || getSubStatus() == rhs.getSubStatus()));
}

inline bool T_SxmAudioSubInfo::operator != (const T_SxmAudioSubInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmAudioSubInfo::operator < (const T_SxmAudioSubInfo& rhs) const {
    if (hasSubStatus() || rhs.hasSubStatus()) {
        if (getSubStatus() < rhs.getSubStatus()) return true;
        if (getSubStatus() > rhs.getSubStatus()) return false;
    }
    return false;
}

inline bool T_SxmAudioSubInfo::operator > (const T_SxmAudioSubInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmAudioSubInfo::clear() {
    clearSubStatus();
}

inline void T_SxmAudioSubInfo::clearSubStatus() {
    if (hasSubStatus()) {
         clear_has_SubStatus();
        _SubStatus = 0u;
     }
}

inline bool T_SxmAudioSubInfo::hasSubStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SxmAudioSubInfo::getSubStatus () const {
    return _SubStatus;
}

inline void T_SxmAudioSubInfo::setSubStatus (uint8 SubStatus_) {
    set_has_SubStatus();
    this->_SubStatus = SubStatus_;
}

inline void T_SxmAudioSubInfo::set_has_SubStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmAudioSubInfo::clear_has_SubStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_SmartFavoritePreset::T_SmartFavoritePreset ()  :
    _PresetIndex (0u),
    _IsSmartFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SmartFavoritePreset::T_SmartFavoritePreset (const T_SmartFavoritePreset &rhs)  :
    _PresetIndex (0u),
    _IsSmartFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SmartFavoritePreset::T_SmartFavoritePreset (uint8 PresetIndex_, bool IsSmartFavorite_)  :
    _PresetIndex (PresetIndex_),
    _IsSmartFavorite (IsSmartFavorite_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SmartFavoritePreset::~T_SmartFavoritePreset() {
}

inline T_SmartFavoritePreset& T_SmartFavoritePreset::operator = (const T_SmartFavoritePreset& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPresetIndex()) {
            setPresetIndex(rhs.getPresetIndex());
        } else {
            clearPresetIndex();
        }
        if (rhs.hasIsSmartFavorite()) {
            setIsSmartFavorite(rhs.getIsSmartFavorite());
        } else {
            clearIsSmartFavorite();
        }
    }
    return *this;
}

inline bool T_SmartFavoritePreset::operator == (const T_SmartFavoritePreset& rhs) const {
    return (((!hasPresetIndex() && !rhs.hasPresetIndex()) || getPresetIndex() == rhs.getPresetIndex()) &&
        ((!hasIsSmartFavorite() && !rhs.hasIsSmartFavorite()) || getIsSmartFavorite() == rhs.getIsSmartFavorite()));
}

inline bool T_SmartFavoritePreset::operator != (const T_SmartFavoritePreset& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SmartFavoritePreset::operator < (const T_SmartFavoritePreset& rhs) const {
    if (hasPresetIndex() || rhs.hasPresetIndex()) {
        if (getPresetIndex() < rhs.getPresetIndex()) return true;
        if (getPresetIndex() > rhs.getPresetIndex()) return false;
    }
    if (hasIsSmartFavorite() || rhs.hasIsSmartFavorite()) {
        if (getIsSmartFavorite() < rhs.getIsSmartFavorite()) return true;
        if (getIsSmartFavorite() > rhs.getIsSmartFavorite()) return false;
    }
    return false;
}

inline bool T_SmartFavoritePreset::operator > (const T_SmartFavoritePreset& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SmartFavoritePreset::clear() {
    clearPresetIndex();
    clearIsSmartFavorite();
}

inline void T_SmartFavoritePreset::clearPresetIndex() {
    if (hasPresetIndex()) {
         clear_has_PresetIndex();
        _PresetIndex = 0u;
     }
}

inline bool T_SmartFavoritePreset::hasPresetIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SmartFavoritePreset::getPresetIndex () const {
    return _PresetIndex;
}

inline void T_SmartFavoritePreset::setPresetIndex (uint8 PresetIndex_) {
    set_has_PresetIndex();
    this->_PresetIndex = PresetIndex_;
}

inline void T_SmartFavoritePreset::clearIsSmartFavorite() {
    if (hasIsSmartFavorite()) {
         clear_has_IsSmartFavorite();
        _IsSmartFavorite = false;
     }
}

inline bool T_SmartFavoritePreset::hasIsSmartFavorite () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_SmartFavoritePreset::getIsSmartFavorite () const {
    return _IsSmartFavorite;
}

inline void T_SmartFavoritePreset::setIsSmartFavorite (bool IsSmartFavorite_) {
    set_has_IsSmartFavorite();
    this->_IsSmartFavorite = IsSmartFavorite_;
}

inline void T_SmartFavoritePreset::set_has_PresetIndex () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SmartFavoritePreset::clear_has_PresetIndex () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SmartFavoritePreset::set_has_IsSmartFavorite () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SmartFavoritePreset::clear_has_IsSmartFavorite () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SFListElement::T_SFListElement ()  :
    _PresetIndex (0u),
    _IsRepeated (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SFListElement::T_SFListElement (const T_SFListElement &rhs)  :
    _PresetIndex (0u),
    _IsRepeated (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SFListElement::T_SFListElement (uint8 PresetIndex_, bool IsRepeated_)  :
    _PresetIndex (PresetIndex_),
    _IsRepeated (IsRepeated_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SFListElement::~T_SFListElement() {
}

inline T_SFListElement& T_SFListElement::operator = (const T_SFListElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPresetIndex()) {
            setPresetIndex(rhs.getPresetIndex());
        } else {
            clearPresetIndex();
        }
        if (rhs.hasIsRepeated()) {
            setIsRepeated(rhs.getIsRepeated());
        } else {
            clearIsRepeated();
        }
    }
    return *this;
}

inline bool T_SFListElement::operator == (const T_SFListElement& rhs) const {
    return (((!hasPresetIndex() && !rhs.hasPresetIndex()) || getPresetIndex() == rhs.getPresetIndex()) &&
        ((!hasIsRepeated() && !rhs.hasIsRepeated()) || getIsRepeated() == rhs.getIsRepeated()));
}

inline bool T_SFListElement::operator != (const T_SFListElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SFListElement::operator < (const T_SFListElement& rhs) const {
    if (hasPresetIndex() || rhs.hasPresetIndex()) {
        if (getPresetIndex() < rhs.getPresetIndex()) return true;
        if (getPresetIndex() > rhs.getPresetIndex()) return false;
    }
    if (hasIsRepeated() || rhs.hasIsRepeated()) {
        if (getIsRepeated() < rhs.getIsRepeated()) return true;
        if (getIsRepeated() > rhs.getIsRepeated()) return false;
    }
    return false;
}

inline bool T_SFListElement::operator > (const T_SFListElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SFListElement::clear() {
    clearPresetIndex();
    clearIsRepeated();
}

inline void T_SFListElement::clearPresetIndex() {
    if (hasPresetIndex()) {
         clear_has_PresetIndex();
        _PresetIndex = 0u;
     }
}

inline bool T_SFListElement::hasPresetIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SFListElement::getPresetIndex () const {
    return _PresetIndex;
}

inline void T_SFListElement::setPresetIndex (uint8 PresetIndex_) {
    set_has_PresetIndex();
    this->_PresetIndex = PresetIndex_;
}

inline void T_SFListElement::clearIsRepeated() {
    if (hasIsRepeated()) {
         clear_has_IsRepeated();
        _IsRepeated = false;
     }
}

inline bool T_SFListElement::hasIsRepeated () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_SFListElement::getIsRepeated () const {
    return _IsRepeated;
}

inline void T_SFListElement::setIsRepeated (bool IsRepeated_) {
    set_has_IsRepeated();
    this->_IsRepeated = IsRepeated_;
}

inline void T_SFListElement::set_has_PresetIndex () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SFListElement::clear_has_PresetIndex () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SFListElement::set_has_IsRepeated () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SFListElement::clear_has_IsRepeated () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_InstantReplayStatus::T_InstantReplayStatus ()  :
    _RecordDuration (0u),
    _TimeToLive (0u),
    _PlayPercentage (0u),
    _FillPercentage (0u),
    _ElapsedTime (0u),
    _PlaybackStatus (::sxm_audio_main_fi_types::T_e8_IRPlaybackStatus__SXM_AUDIO_IR_PLAY_STATE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_InstantReplayStatus::T_InstantReplayStatus (const T_InstantReplayStatus &rhs)  :
    _RecordDuration (0u),
    _TimeToLive (0u),
    _PlayPercentage (0u),
    _FillPercentage (0u),
    _ElapsedTime (0u),
    _PlaybackStatus (::sxm_audio_main_fi_types::T_e8_IRPlaybackStatus__SXM_AUDIO_IR_PLAY_STATE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_InstantReplayStatus::T_InstantReplayStatus (uint32 RecordDuration_, uint32 TimeToLive_, uint8 PlayPercentage_, uint8 FillPercentage_, uint32 ElapsedTime_, T_e8_IRPlaybackStatus PlaybackStatus_)  :
    _RecordDuration (RecordDuration_),
    _TimeToLive (TimeToLive_),
    _PlayPercentage (PlayPercentage_),
    _FillPercentage (FillPercentage_),
    _ElapsedTime (ElapsedTime_),
    _PlaybackStatus (PlaybackStatus_)
{
    #ifndef NDEBUG
    if (!(T_e8_IRPlaybackStatus_IsValid(PlaybackStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PlaybackStatus_, "T_e8_IRPlaybackStatus", "PlaybackStatus", "T_InstantReplayStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_InstantReplayStatus::~T_InstantReplayStatus() {
}

inline T_InstantReplayStatus& T_InstantReplayStatus::operator = (const T_InstantReplayStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRecordDuration()) {
            setRecordDuration(rhs.getRecordDuration());
        } else {
            clearRecordDuration();
        }
        if (rhs.hasTimeToLive()) {
            setTimeToLive(rhs.getTimeToLive());
        } else {
            clearTimeToLive();
        }
        if (rhs.hasPlayPercentage()) {
            setPlayPercentage(rhs.getPlayPercentage());
        } else {
            clearPlayPercentage();
        }
        if (rhs.hasFillPercentage()) {
            setFillPercentage(rhs.getFillPercentage());
        } else {
            clearFillPercentage();
        }
        if (rhs.hasElapsedTime()) {
            setElapsedTime(rhs.getElapsedTime());
        } else {
            clearElapsedTime();
        }
        if (rhs.hasPlaybackStatus()) {
            setPlaybackStatus(rhs.getPlaybackStatus());
        } else {
            clearPlaybackStatus();
        }
    }
    return *this;
}

inline bool T_InstantReplayStatus::operator == (const T_InstantReplayStatus& rhs) const {
    return (((!hasRecordDuration() && !rhs.hasRecordDuration()) || getRecordDuration() == rhs.getRecordDuration()) &&
        ((!hasTimeToLive() && !rhs.hasTimeToLive()) || getTimeToLive() == rhs.getTimeToLive()) &&
        ((!hasPlayPercentage() && !rhs.hasPlayPercentage()) || getPlayPercentage() == rhs.getPlayPercentage()) &&
        ((!hasFillPercentage() && !rhs.hasFillPercentage()) || getFillPercentage() == rhs.getFillPercentage()) &&
        ((!hasElapsedTime() && !rhs.hasElapsedTime()) || getElapsedTime() == rhs.getElapsedTime()) &&
        ((!hasPlaybackStatus() && !rhs.hasPlaybackStatus()) || getPlaybackStatus() == rhs.getPlaybackStatus()));
}

inline bool T_InstantReplayStatus::operator != (const T_InstantReplayStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_InstantReplayStatus::operator < (const T_InstantReplayStatus& rhs) const {
    if (hasRecordDuration() || rhs.hasRecordDuration()) {
        if (getRecordDuration() < rhs.getRecordDuration()) return true;
        if (getRecordDuration() > rhs.getRecordDuration()) return false;
    }
    if (hasTimeToLive() || rhs.hasTimeToLive()) {
        if (getTimeToLive() < rhs.getTimeToLive()) return true;
        if (getTimeToLive() > rhs.getTimeToLive()) return false;
    }
    if (hasPlayPercentage() || rhs.hasPlayPercentage()) {
        if (getPlayPercentage() < rhs.getPlayPercentage()) return true;
        if (getPlayPercentage() > rhs.getPlayPercentage()) return false;
    }
    if (hasFillPercentage() || rhs.hasFillPercentage()) {
        if (getFillPercentage() < rhs.getFillPercentage()) return true;
        if (getFillPercentage() > rhs.getFillPercentage()) return false;
    }
    if (hasElapsedTime() || rhs.hasElapsedTime()) {
        if (getElapsedTime() < rhs.getElapsedTime()) return true;
        if (getElapsedTime() > rhs.getElapsedTime()) return false;
    }
    if (hasPlaybackStatus() || rhs.hasPlaybackStatus()) {
        if ((uint32)getPlaybackStatus() < (uint32)rhs.getPlaybackStatus()) return true;
        if ((uint32)getPlaybackStatus() > (uint32)rhs.getPlaybackStatus()) return false;
    }
    return false;
}

inline bool T_InstantReplayStatus::operator > (const T_InstantReplayStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_InstantReplayStatus::clear() {
    clearRecordDuration();
    clearTimeToLive();
    clearPlayPercentage();
    clearFillPercentage();
    clearElapsedTime();
    clearPlaybackStatus();
}

inline void T_InstantReplayStatus::clearRecordDuration() {
    if (hasRecordDuration()) {
         clear_has_RecordDuration();
        _RecordDuration = 0u;
     }
}

inline bool T_InstantReplayStatus::hasRecordDuration () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_InstantReplayStatus::getRecordDuration () const {
    return _RecordDuration;
}

inline void T_InstantReplayStatus::setRecordDuration (uint32 RecordDuration_) {
    set_has_RecordDuration();
    this->_RecordDuration = RecordDuration_;
}

inline void T_InstantReplayStatus::clearTimeToLive() {
    if (hasTimeToLive()) {
         clear_has_TimeToLive();
        _TimeToLive = 0u;
     }
}

inline bool T_InstantReplayStatus::hasTimeToLive () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_InstantReplayStatus::getTimeToLive () const {
    return _TimeToLive;
}

inline void T_InstantReplayStatus::setTimeToLive (uint32 TimeToLive_) {
    set_has_TimeToLive();
    this->_TimeToLive = TimeToLive_;
}

inline void T_InstantReplayStatus::clearPlayPercentage() {
    if (hasPlayPercentage()) {
         clear_has_PlayPercentage();
        _PlayPercentage = 0u;
     }
}

inline bool T_InstantReplayStatus::hasPlayPercentage () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_InstantReplayStatus::getPlayPercentage () const {
    return _PlayPercentage;
}

inline void T_InstantReplayStatus::setPlayPercentage (uint8 PlayPercentage_) {
    set_has_PlayPercentage();
    this->_PlayPercentage = PlayPercentage_;
}

inline void T_InstantReplayStatus::clearFillPercentage() {
    if (hasFillPercentage()) {
         clear_has_FillPercentage();
        _FillPercentage = 0u;
     }
}

inline bool T_InstantReplayStatus::hasFillPercentage () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_InstantReplayStatus::getFillPercentage () const {
    return _FillPercentage;
}

inline void T_InstantReplayStatus::setFillPercentage (uint8 FillPercentage_) {
    set_has_FillPercentage();
    this->_FillPercentage = FillPercentage_;
}

inline void T_InstantReplayStatus::clearElapsedTime() {
    if (hasElapsedTime()) {
         clear_has_ElapsedTime();
        _ElapsedTime = 0u;
     }
}

inline bool T_InstantReplayStatus::hasElapsedTime () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_InstantReplayStatus::getElapsedTime () const {
    return _ElapsedTime;
}

inline void T_InstantReplayStatus::setElapsedTime (uint32 ElapsedTime_) {
    set_has_ElapsedTime();
    this->_ElapsedTime = ElapsedTime_;
}

inline void T_InstantReplayStatus::clearPlaybackStatus() {
    if (hasPlaybackStatus()) {
         clear_has_PlaybackStatus();
        _PlaybackStatus = ::sxm_audio_main_fi_types::T_e8_IRPlaybackStatus__SXM_AUDIO_IR_PLAY_STATE;
     }
}

inline bool T_InstantReplayStatus::hasPlaybackStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_IRPlaybackStatus T_InstantReplayStatus::getPlaybackStatus () const {
    return _PlaybackStatus;
}

inline void T_InstantReplayStatus::setPlaybackStatus (T_e8_IRPlaybackStatus PlaybackStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_IRPlaybackStatus_IsValid(PlaybackStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PlaybackStatus_, "T_e8_IRPlaybackStatus", "PlaybackStatus", "T_InstantReplayStatus");
    }
    #endif
    set_has_PlaybackStatus();
    this->_PlaybackStatus = PlaybackStatus_;
}

inline void T_InstantReplayStatus::set_has_RecordDuration () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_InstantReplayStatus::clear_has_RecordDuration () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_InstantReplayStatus::set_has_TimeToLive () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_InstantReplayStatus::clear_has_TimeToLive () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_InstantReplayStatus::set_has_PlayPercentage () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_InstantReplayStatus::clear_has_PlayPercentage () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_InstantReplayStatus::set_has_FillPercentage () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_InstantReplayStatus::clear_has_FillPercentage () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_InstantReplayStatus::set_has_ElapsedTime () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_InstantReplayStatus::clear_has_ElapsedTime () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_InstantReplayStatus::set_has_PlaybackStatus () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_InstantReplayStatus::clear_has_PlaybackStatus () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_RegisteredFavorite::T_RegisteredFavorite ()  :
    _ContentName (),
    _IsEnabled (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_RegisteredFavorite::T_RegisteredFavorite (const T_RegisteredFavorite &rhs)  :
    _ContentName (),
    _IsEnabled (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_RegisteredFavorite::T_RegisteredFavorite (const ::std::string& ContentName_, bool IsEnabled_)  :
    _ContentName (ContentName_),
    _IsEnabled (IsEnabled_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ContentName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_RegisteredFavorite::~T_RegisteredFavorite() {
}

inline T_RegisteredFavorite& T_RegisteredFavorite::operator = (const T_RegisteredFavorite& rhs) {
    if( this != &rhs ) {
        if (rhs.hasContentName()) {
            setContentName(rhs.getContentName());
        } else {
            clearContentName();
        }
        if (rhs.hasIsEnabled()) {
            setIsEnabled(rhs.getIsEnabled());
        } else {
            clearIsEnabled();
        }
    }
    return *this;
}

inline bool T_RegisteredFavorite::operator == (const T_RegisteredFavorite& rhs) const {
    return (((!hasContentName() && !rhs.hasContentName()) || getContentName() == rhs.getContentName()) &&
        ((!hasIsEnabled() && !rhs.hasIsEnabled()) || getIsEnabled() == rhs.getIsEnabled()));
}

inline bool T_RegisteredFavorite::operator != (const T_RegisteredFavorite& rhs) const {
    return ! (*this == rhs);
}

inline bool T_RegisteredFavorite::operator < (const T_RegisteredFavorite& rhs) const {
    if (hasContentName() || rhs.hasContentName()) {
        if (getContentName() < rhs.getContentName()) return true;
        if (getContentName() > rhs.getContentName()) return false;
    }
    if (hasIsEnabled() || rhs.hasIsEnabled()) {
        if (getIsEnabled() < rhs.getIsEnabled()) return true;
        if (getIsEnabled() > rhs.getIsEnabled()) return false;
    }
    return false;
}

inline bool T_RegisteredFavorite::operator > (const T_RegisteredFavorite& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_RegisteredFavorite::clear() {
    clearContentName();
    clearIsEnabled();
}

inline void T_RegisteredFavorite::clearContentName() {
    if (hasContentName()) {
         clear_has_ContentName();
        _ContentName.clear();
     }
}

inline bool T_RegisteredFavorite::hasContentName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_RegisteredFavorite::getContentName () const {
    return _ContentName;
}

inline ::std::string& T_RegisteredFavorite::getContentNameMutable () {
    set_has_ContentName();
    return _ContentName;
}

inline void T_RegisteredFavorite::setContentName (const ::std::string& ContentName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ContentName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ContentName();
    this->_ContentName = ContentName_;
}

inline void T_RegisteredFavorite::setContentName (const char* ContentName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ContentName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ContentName();
    this->_ContentName.assign(ContentName_);
}

inline void T_RegisteredFavorite::setContentName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ContentName();
    this->_ContentName.assign(value, size);
}

inline void T_RegisteredFavorite::clearIsEnabled() {
    if (hasIsEnabled()) {
         clear_has_IsEnabled();
        _IsEnabled = false;
     }
}

inline bool T_RegisteredFavorite::hasIsEnabled () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_RegisteredFavorite::getIsEnabled () const {
    return _IsEnabled;
}

inline void T_RegisteredFavorite::setIsEnabled (bool IsEnabled_) {
    set_has_IsEnabled();
    this->_IsEnabled = IsEnabled_;
}

inline void T_RegisteredFavorite::set_has_ContentName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_RegisteredFavorite::clear_has_ContentName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_RegisteredFavorite::set_has_IsEnabled () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_RegisteredFavorite::clear_has_IsEnabled () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_b8_ChannelStatus::T_b8_ChannelStatus ()  :
    _CHANNEL_STATUS_MATURED (false),
    _CHANNEL_STATUS_LOCKED (false),
    _CHANNEL_STATUS_SKIPPED (false),
    _CHANNEL_STATUS_TUNABLE (false),
    _CHANNEL_STATUS_B4_RFU (false),
    _CHANNEL_STATUS_B5_RFU (false),
    _CHANNEL_STATUS_B6_RFU (false),
    _CHANNEL_STATUS_B7_RFU (false)
{
}

inline  T_b8_ChannelStatus::T_b8_ChannelStatus (const T_b8_ChannelStatus &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_ChannelStatus::T_b8_ChannelStatus (bool CHANNEL_STATUS_MATURED, bool CHANNEL_STATUS_LOCKED, bool CHANNEL_STATUS_SKIPPED, bool CHANNEL_STATUS_TUNABLE, bool CHANNEL_STATUS_B4_RFU, bool CHANNEL_STATUS_B5_RFU, bool CHANNEL_STATUS_B6_RFU, bool CHANNEL_STATUS_B7_RFU) :
    _CHANNEL_STATUS_MATURED (CHANNEL_STATUS_MATURED),
    _CHANNEL_STATUS_LOCKED (CHANNEL_STATUS_LOCKED),
    _CHANNEL_STATUS_SKIPPED (CHANNEL_STATUS_SKIPPED),
    _CHANNEL_STATUS_TUNABLE (CHANNEL_STATUS_TUNABLE),
    _CHANNEL_STATUS_B4_RFU (CHANNEL_STATUS_B4_RFU),
    _CHANNEL_STATUS_B5_RFU (CHANNEL_STATUS_B5_RFU),
    _CHANNEL_STATUS_B6_RFU (CHANNEL_STATUS_B6_RFU),
    _CHANNEL_STATUS_B7_RFU (CHANNEL_STATUS_B7_RFU)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_ChannelStatus& T_b8_ChannelStatus::operator = (const T_b8_ChannelStatus& rhs) {
    if( this != &rhs ) {
        _CHANNEL_STATUS_MATURED = rhs._CHANNEL_STATUS_MATURED;
        _CHANNEL_STATUS_LOCKED = rhs._CHANNEL_STATUS_LOCKED;
        _CHANNEL_STATUS_SKIPPED = rhs._CHANNEL_STATUS_SKIPPED;
        _CHANNEL_STATUS_TUNABLE = rhs._CHANNEL_STATUS_TUNABLE;
        _CHANNEL_STATUS_B4_RFU = rhs._CHANNEL_STATUS_B4_RFU;
        _CHANNEL_STATUS_B5_RFU = rhs._CHANNEL_STATUS_B5_RFU;
        _CHANNEL_STATUS_B6_RFU = rhs._CHANNEL_STATUS_B6_RFU;
        _CHANNEL_STATUS_B7_RFU = rhs._CHANNEL_STATUS_B7_RFU;
    }
    return *this;
}

inline bool T_b8_ChannelStatus::operator == (const T_b8_ChannelStatus& rhs) const {
    return (_CHANNEL_STATUS_MATURED == rhs._CHANNEL_STATUS_MATURED &&
        _CHANNEL_STATUS_LOCKED == rhs._CHANNEL_STATUS_LOCKED &&
        _CHANNEL_STATUS_SKIPPED == rhs._CHANNEL_STATUS_SKIPPED &&
        _CHANNEL_STATUS_TUNABLE == rhs._CHANNEL_STATUS_TUNABLE &&
        _CHANNEL_STATUS_B4_RFU == rhs._CHANNEL_STATUS_B4_RFU &&
        _CHANNEL_STATUS_B5_RFU == rhs._CHANNEL_STATUS_B5_RFU &&
        _CHANNEL_STATUS_B6_RFU == rhs._CHANNEL_STATUS_B6_RFU &&
        _CHANNEL_STATUS_B7_RFU == rhs._CHANNEL_STATUS_B7_RFU);
}

inline bool T_b8_ChannelStatus::operator != (const T_b8_ChannelStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_ChannelStatus::operator < (const T_b8_ChannelStatus& rhs) const {
    if (getCHANNEL_STATUS_MATURED() < rhs.getCHANNEL_STATUS_MATURED()) return true;
    if (getCHANNEL_STATUS_MATURED() > rhs.getCHANNEL_STATUS_MATURED()) return false;

    if (getCHANNEL_STATUS_LOCKED() < rhs.getCHANNEL_STATUS_LOCKED()) return true;
    if (getCHANNEL_STATUS_LOCKED() > rhs.getCHANNEL_STATUS_LOCKED()) return false;

    if (getCHANNEL_STATUS_SKIPPED() < rhs.getCHANNEL_STATUS_SKIPPED()) return true;
    if (getCHANNEL_STATUS_SKIPPED() > rhs.getCHANNEL_STATUS_SKIPPED()) return false;

    if (getCHANNEL_STATUS_TUNABLE() < rhs.getCHANNEL_STATUS_TUNABLE()) return true;
    if (getCHANNEL_STATUS_TUNABLE() > rhs.getCHANNEL_STATUS_TUNABLE()) return false;

    if (getCHANNEL_STATUS_B4_RFU() < rhs.getCHANNEL_STATUS_B4_RFU()) return true;
    if (getCHANNEL_STATUS_B4_RFU() > rhs.getCHANNEL_STATUS_B4_RFU()) return false;

    if (getCHANNEL_STATUS_B5_RFU() < rhs.getCHANNEL_STATUS_B5_RFU()) return true;
    if (getCHANNEL_STATUS_B5_RFU() > rhs.getCHANNEL_STATUS_B5_RFU()) return false;

    if (getCHANNEL_STATUS_B6_RFU() < rhs.getCHANNEL_STATUS_B6_RFU()) return true;
    if (getCHANNEL_STATUS_B6_RFU() > rhs.getCHANNEL_STATUS_B6_RFU()) return false;

    if (getCHANNEL_STATUS_B7_RFU() < rhs.getCHANNEL_STATUS_B7_RFU()) return true;
    if (getCHANNEL_STATUS_B7_RFU() > rhs.getCHANNEL_STATUS_B7_RFU()) return false;

    return false;
}

inline bool T_b8_ChannelStatus::operator > (const T_b8_ChannelStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_ChannelStatus::setCHANNEL_STATUS_MATURED (bool CHANNEL_STATUS_MATURED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_STATUS_MATURED = CHANNEL_STATUS_MATURED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelStatus::getCHANNEL_STATUS_MATURED () const {
    return _CHANNEL_STATUS_MATURED;
}

inline void T_b8_ChannelStatus::setCHANNEL_STATUS_LOCKED (bool CHANNEL_STATUS_LOCKED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_STATUS_LOCKED = CHANNEL_STATUS_LOCKED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelStatus::getCHANNEL_STATUS_LOCKED () const {
    return _CHANNEL_STATUS_LOCKED;
}

inline void T_b8_ChannelStatus::setCHANNEL_STATUS_SKIPPED (bool CHANNEL_STATUS_SKIPPED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_STATUS_SKIPPED = CHANNEL_STATUS_SKIPPED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelStatus::getCHANNEL_STATUS_SKIPPED () const {
    return _CHANNEL_STATUS_SKIPPED;
}

inline void T_b8_ChannelStatus::setCHANNEL_STATUS_TUNABLE (bool CHANNEL_STATUS_TUNABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_STATUS_TUNABLE = CHANNEL_STATUS_TUNABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelStatus::getCHANNEL_STATUS_TUNABLE () const {
    return _CHANNEL_STATUS_TUNABLE;
}

inline void T_b8_ChannelStatus::setCHANNEL_STATUS_B4_RFU (bool CHANNEL_STATUS_B4_RFU) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_STATUS_B4_RFU = CHANNEL_STATUS_B4_RFU;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelStatus::getCHANNEL_STATUS_B4_RFU () const {
    return _CHANNEL_STATUS_B4_RFU;
}

inline void T_b8_ChannelStatus::setCHANNEL_STATUS_B5_RFU (bool CHANNEL_STATUS_B5_RFU) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_STATUS_B5_RFU = CHANNEL_STATUS_B5_RFU;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelStatus::getCHANNEL_STATUS_B5_RFU () const {
    return _CHANNEL_STATUS_B5_RFU;
}

inline void T_b8_ChannelStatus::setCHANNEL_STATUS_B6_RFU (bool CHANNEL_STATUS_B6_RFU) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_STATUS_B6_RFU = CHANNEL_STATUS_B6_RFU;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelStatus::getCHANNEL_STATUS_B6_RFU () const {
    return _CHANNEL_STATUS_B6_RFU;
}

inline void T_b8_ChannelStatus::setCHANNEL_STATUS_B7_RFU (bool CHANNEL_STATUS_B7_RFU) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_STATUS_B7_RFU = CHANNEL_STATUS_B7_RFU;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelStatus::getCHANNEL_STATUS_B7_RFU () const {
    return _CHANNEL_STATUS_B7_RFU;
}

inline  T_AlertInfo::T_AlertInfo ()  :
    _ServiceID (0u),
    _ChannelID (0u),
    _FavoriteType (::sxm_audio_main_fi_types::T_e8_FavoriteType__FAVORITE_ARTIST),
    _ChannelName (),
    _ArtistName (),
    _SongName (),
    _ChnGraphicsAvailable (::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH),
    _ChannelStatus (),
    _IsExpired (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AlertInfo::T_AlertInfo (const T_AlertInfo &rhs)  :
    _ServiceID (0u),
    _ChannelID (0u),
    _FavoriteType (::sxm_audio_main_fi_types::T_e8_FavoriteType__FAVORITE_ARTIST),
    _ChannelName (),
    _ArtistName (),
    _SongName (),
    _ChnGraphicsAvailable (::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH),
    _ChannelStatus (),
    _IsExpired (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AlertInfo::T_AlertInfo (uint16 ServiceID_, uint16 ChannelID_, T_e8_FavoriteType FavoriteType_, const ::std::string& ChannelName_, const ::std::string& ArtistName_, const ::std::string& SongName_, T_e8_Graphics ChnGraphicsAvailable_, const T_b8_ChannelStatus& ChannelStatus_, bool IsExpired_)  :
    _ServiceID (ServiceID_),
    _ChannelID (ChannelID_),
    _FavoriteType (FavoriteType_),
    _ChannelName (ChannelName_),
    _ArtistName (ArtistName_),
    _SongName (SongName_),
    _ChnGraphicsAvailable (ChnGraphicsAvailable_),
    _ChannelStatus (ChannelStatus_),
    _IsExpired (IsExpired_)
{
    #ifndef NDEBUG
    if (!(T_e8_FavoriteType_IsValid(FavoriteType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FavoriteType_, "T_e8_FavoriteType", "FavoriteType", "T_AlertInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SongName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_Graphics_IsValid(ChnGraphicsAvailable_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChnGraphicsAvailable_, "T_e8_Graphics", "ChnGraphicsAvailable", "T_AlertInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AlertInfo::~T_AlertInfo() {
}

inline T_AlertInfo& T_AlertInfo::operator = (const T_AlertInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasServiceID()) {
            setServiceID(rhs.getServiceID());
        } else {
            clearServiceID();
        }
        if (rhs.hasChannelID()) {
            setChannelID(rhs.getChannelID());
        } else {
            clearChannelID();
        }
        if (rhs.hasFavoriteType()) {
            setFavoriteType(rhs.getFavoriteType());
        } else {
            clearFavoriteType();
        }
        if (rhs.hasChannelName()) {
            setChannelName(rhs.getChannelName());
        } else {
            clearChannelName();
        }
        if (rhs.hasArtistName()) {
            setArtistName(rhs.getArtistName());
        } else {
            clearArtistName();
        }
        if (rhs.hasSongName()) {
            setSongName(rhs.getSongName());
        } else {
            clearSongName();
        }
        if (rhs.hasChnGraphicsAvailable()) {
            setChnGraphicsAvailable(rhs.getChnGraphicsAvailable());
        } else {
            clearChnGraphicsAvailable();
        }
        if (rhs.hasChannelStatus()) {
            setChannelStatus(rhs.getChannelStatus());
        } else {
            clearChannelStatus();
        }
        if (rhs.hasIsExpired()) {
            setIsExpired(rhs.getIsExpired());
        } else {
            clearIsExpired();
        }
    }
    return *this;
}

inline bool T_AlertInfo::operator == (const T_AlertInfo& rhs) const {
    return (((!hasServiceID() && !rhs.hasServiceID()) || getServiceID() == rhs.getServiceID()) &&
        ((!hasChannelID() && !rhs.hasChannelID()) || getChannelID() == rhs.getChannelID()) &&
        ((!hasFavoriteType() && !rhs.hasFavoriteType()) || getFavoriteType() == rhs.getFavoriteType()) &&
        ((!hasChannelName() && !rhs.hasChannelName()) || getChannelName() == rhs.getChannelName()) &&
        ((!hasArtistName() && !rhs.hasArtistName()) || getArtistName() == rhs.getArtistName()) &&
        ((!hasSongName() && !rhs.hasSongName()) || getSongName() == rhs.getSongName()) &&
        ((!hasChnGraphicsAvailable() && !rhs.hasChnGraphicsAvailable()) || getChnGraphicsAvailable() == rhs.getChnGraphicsAvailable()) &&
        ((!hasChannelStatus() && !rhs.hasChannelStatus()) || getChannelStatus() == rhs.getChannelStatus()) &&
        ((!hasIsExpired() && !rhs.hasIsExpired()) || getIsExpired() == rhs.getIsExpired()));
}

inline bool T_AlertInfo::operator != (const T_AlertInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AlertInfo::operator < (const T_AlertInfo& rhs) const {
    if (hasServiceID() || rhs.hasServiceID()) {
        if (getServiceID() < rhs.getServiceID()) return true;
        if (getServiceID() > rhs.getServiceID()) return false;
    }
    if (hasChannelID() || rhs.hasChannelID()) {
        if (getChannelID() < rhs.getChannelID()) return true;
        if (getChannelID() > rhs.getChannelID()) return false;
    }
    if (hasFavoriteType() || rhs.hasFavoriteType()) {
        if ((uint32)getFavoriteType() < (uint32)rhs.getFavoriteType()) return true;
        if ((uint32)getFavoriteType() > (uint32)rhs.getFavoriteType()) return false;
    }
    if (hasChannelName() || rhs.hasChannelName()) {
        if (getChannelName() < rhs.getChannelName()) return true;
        if (getChannelName() > rhs.getChannelName()) return false;
    }
    if (hasArtistName() || rhs.hasArtistName()) {
        if (getArtistName() < rhs.getArtistName()) return true;
        if (getArtistName() > rhs.getArtistName()) return false;
    }
    if (hasSongName() || rhs.hasSongName()) {
        if (getSongName() < rhs.getSongName()) return true;
        if (getSongName() > rhs.getSongName()) return false;
    }
    if (hasChnGraphicsAvailable() || rhs.hasChnGraphicsAvailable()) {
        if ((uint32)getChnGraphicsAvailable() < (uint32)rhs.getChnGraphicsAvailable()) return true;
        if ((uint32)getChnGraphicsAvailable() > (uint32)rhs.getChnGraphicsAvailable()) return false;
    }
    if (hasChannelStatus() || rhs.hasChannelStatus()) {
        if (getChannelStatus() < rhs.getChannelStatus()) return true;
        if (getChannelStatus() > rhs.getChannelStatus()) return false;
    }
    if (hasIsExpired() || rhs.hasIsExpired()) {
        if (getIsExpired() < rhs.getIsExpired()) return true;
        if (getIsExpired() > rhs.getIsExpired()) return false;
    }
    return false;
}

inline bool T_AlertInfo::operator > (const T_AlertInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AlertInfo::clear() {
    clearServiceID();
    clearChannelID();
    clearFavoriteType();
    clearChannelName();
    clearArtistName();
    clearSongName();
    clearChnGraphicsAvailable();
    clearChannelStatus();
    clearIsExpired();
}

inline void T_AlertInfo::clearServiceID() {
    if (hasServiceID()) {
         clear_has_ServiceID();
        _ServiceID = 0u;
     }
}

inline bool T_AlertInfo::hasServiceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_AlertInfo::getServiceID () const {
    return _ServiceID;
}

inline void T_AlertInfo::setServiceID (uint16 ServiceID_) {
    set_has_ServiceID();
    this->_ServiceID = ServiceID_;
}

inline void T_AlertInfo::clearChannelID() {
    if (hasChannelID()) {
         clear_has_ChannelID();
        _ChannelID = 0u;
     }
}

inline bool T_AlertInfo::hasChannelID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_AlertInfo::getChannelID () const {
    return _ChannelID;
}

inline void T_AlertInfo::setChannelID (uint16 ChannelID_) {
    set_has_ChannelID();
    this->_ChannelID = ChannelID_;
}

inline void T_AlertInfo::clearFavoriteType() {
    if (hasFavoriteType()) {
         clear_has_FavoriteType();
        _FavoriteType = ::sxm_audio_main_fi_types::T_e8_FavoriteType__FAVORITE_ARTIST;
     }
}

inline bool T_AlertInfo::hasFavoriteType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_FavoriteType T_AlertInfo::getFavoriteType () const {
    return _FavoriteType;
}

inline void T_AlertInfo::setFavoriteType (T_e8_FavoriteType FavoriteType_) {
    #ifndef NDEBUG
    if (!(T_e8_FavoriteType_IsValid(FavoriteType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FavoriteType_, "T_e8_FavoriteType", "FavoriteType", "T_AlertInfo");
    }
    #endif
    set_has_FavoriteType();
    this->_FavoriteType = FavoriteType_;
}

inline void T_AlertInfo::clearChannelName() {
    if (hasChannelName()) {
         clear_has_ChannelName();
        _ChannelName.clear();
     }
}

inline bool T_AlertInfo::hasChannelName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_AlertInfo::getChannelName () const {
    return _ChannelName;
}

inline ::std::string& T_AlertInfo::getChannelNameMutable () {
    set_has_ChannelName();
    return _ChannelName;
}

inline void T_AlertInfo::setChannelName (const ::std::string& ChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName = ChannelName_;
}

inline void T_AlertInfo::setChannelName (const char* ChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName.assign(ChannelName_);
}

inline void T_AlertInfo::setChannelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName.assign(value, size);
}

inline void T_AlertInfo::clearArtistName() {
    if (hasArtistName()) {
         clear_has_ArtistName();
        _ArtistName.clear();
     }
}

inline bool T_AlertInfo::hasArtistName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_AlertInfo::getArtistName () const {
    return _ArtistName;
}

inline ::std::string& T_AlertInfo::getArtistNameMutable () {
    set_has_ArtistName();
    return _ArtistName;
}

inline void T_AlertInfo::setArtistName (const ::std::string& ArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ArtistName();
    this->_ArtistName = ArtistName_;
}

inline void T_AlertInfo::setArtistName (const char* ArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ArtistName();
    this->_ArtistName.assign(ArtistName_);
}

inline void T_AlertInfo::setArtistName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ArtistName();
    this->_ArtistName.assign(value, size);
}

inline void T_AlertInfo::clearSongName() {
    if (hasSongName()) {
         clear_has_SongName();
        _SongName.clear();
     }
}

inline bool T_AlertInfo::hasSongName () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_AlertInfo::getSongName () const {
    return _SongName;
}

inline ::std::string& T_AlertInfo::getSongNameMutable () {
    set_has_SongName();
    return _SongName;
}

inline void T_AlertInfo::setSongName (const ::std::string& SongName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SongName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SongName();
    this->_SongName = SongName_;
}

inline void T_AlertInfo::setSongName (const char* SongName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SongName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SongName();
    this->_SongName.assign(SongName_);
}

inline void T_AlertInfo::setSongName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SongName();
    this->_SongName.assign(value, size);
}

inline void T_AlertInfo::clearChnGraphicsAvailable() {
    if (hasChnGraphicsAvailable()) {
         clear_has_ChnGraphicsAvailable();
        _ChnGraphicsAvailable = ::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH;
     }
}

inline bool T_AlertInfo::hasChnGraphicsAvailable () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_Graphics T_AlertInfo::getChnGraphicsAvailable () const {
    return _ChnGraphicsAvailable;
}

inline void T_AlertInfo::setChnGraphicsAvailable (T_e8_Graphics ChnGraphicsAvailable_) {
    #ifndef NDEBUG
    if (!(T_e8_Graphics_IsValid(ChnGraphicsAvailable_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChnGraphicsAvailable_, "T_e8_Graphics", "ChnGraphicsAvailable", "T_AlertInfo");
    }
    #endif
    set_has_ChnGraphicsAvailable();
    this->_ChnGraphicsAvailable = ChnGraphicsAvailable_;
}

inline void T_AlertInfo::clearChannelStatus() {
    if (hasChannelStatus()) {
         clear_has_ChannelStatus();
        _ChannelStatus = T_b8_ChannelStatus ();
     }
}

inline bool T_AlertInfo::hasChannelStatus () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const T_b8_ChannelStatus& T_AlertInfo::getChannelStatus () const {
    return _ChannelStatus;
}

inline T_b8_ChannelStatus& T_AlertInfo::getChannelStatusMutable () {
    set_has_ChannelStatus();
    return _ChannelStatus;
}

inline void T_AlertInfo::setChannelStatus (const T_b8_ChannelStatus& ChannelStatus_) {
    set_has_ChannelStatus();
    this->_ChannelStatus = ChannelStatus_;
}

inline void T_AlertInfo::clearIsExpired() {
    if (hasIsExpired()) {
         clear_has_IsExpired();
        _IsExpired = false;
     }
}

inline bool T_AlertInfo::hasIsExpired () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_AlertInfo::getIsExpired () const {
    return _IsExpired;
}

inline void T_AlertInfo::setIsExpired (bool IsExpired_) {
    set_has_IsExpired();
    this->_IsExpired = IsExpired_;
}

inline void T_AlertInfo::set_has_ServiceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AlertInfo::clear_has_ServiceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AlertInfo::set_has_ChannelID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AlertInfo::clear_has_ChannelID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AlertInfo::set_has_FavoriteType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AlertInfo::clear_has_FavoriteType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AlertInfo::set_has_ChannelName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AlertInfo::clear_has_ChannelName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_AlertInfo::set_has_ArtistName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_AlertInfo::clear_has_ArtistName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_AlertInfo::set_has_SongName () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_AlertInfo::clear_has_SongName () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_AlertInfo::set_has_ChnGraphicsAvailable () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_AlertInfo::clear_has_ChnGraphicsAvailable () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_AlertInfo::set_has_ChannelStatus () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_AlertInfo::clear_has_ChannelStatus () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_AlertInfo::set_has_IsExpired () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_AlertInfo::clear_has_IsExpired () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_MarketListEntry::T_MarketListEntry ()  :
    _AbbrMarketName (),
    _FullMarketName (),
    _bIsActiveMarket (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MarketListEntry::T_MarketListEntry (const T_MarketListEntry &rhs)  :
    _AbbrMarketName (),
    _FullMarketName (),
    _bIsActiveMarket (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MarketListEntry::T_MarketListEntry (const ::std::string& AbbrMarketName_, const ::std::string& FullMarketName_, bool bIsActiveMarket_)  :
    _AbbrMarketName (AbbrMarketName_),
    _FullMarketName (FullMarketName_),
    _bIsActiveMarket (bIsActiveMarket_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AbbrMarketName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FullMarketName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MarketListEntry::~T_MarketListEntry() {
}

inline T_MarketListEntry& T_MarketListEntry::operator = (const T_MarketListEntry& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAbbrMarketName()) {
            setAbbrMarketName(rhs.getAbbrMarketName());
        } else {
            clearAbbrMarketName();
        }
        if (rhs.hasFullMarketName()) {
            setFullMarketName(rhs.getFullMarketName());
        } else {
            clearFullMarketName();
        }
        if (rhs.hasBIsActiveMarket()) {
            setBIsActiveMarket(rhs.getBIsActiveMarket());
        } else {
            clearBIsActiveMarket();
        }
    }
    return *this;
}

inline bool T_MarketListEntry::operator == (const T_MarketListEntry& rhs) const {
    return (((!hasAbbrMarketName() && !rhs.hasAbbrMarketName()) || getAbbrMarketName() == rhs.getAbbrMarketName()) &&
        ((!hasFullMarketName() && !rhs.hasFullMarketName()) || getFullMarketName() == rhs.getFullMarketName()) &&
        ((!hasBIsActiveMarket() && !rhs.hasBIsActiveMarket()) || getBIsActiveMarket() == rhs.getBIsActiveMarket()));
}

inline bool T_MarketListEntry::operator != (const T_MarketListEntry& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MarketListEntry::operator < (const T_MarketListEntry& rhs) const {
    if (hasAbbrMarketName() || rhs.hasAbbrMarketName()) {
        if (getAbbrMarketName() < rhs.getAbbrMarketName()) return true;
        if (getAbbrMarketName() > rhs.getAbbrMarketName()) return false;
    }
    if (hasFullMarketName() || rhs.hasFullMarketName()) {
        if (getFullMarketName() < rhs.getFullMarketName()) return true;
        if (getFullMarketName() > rhs.getFullMarketName()) return false;
    }
    if (hasBIsActiveMarket() || rhs.hasBIsActiveMarket()) {
        if (getBIsActiveMarket() < rhs.getBIsActiveMarket()) return true;
        if (getBIsActiveMarket() > rhs.getBIsActiveMarket()) return false;
    }
    return false;
}

inline bool T_MarketListEntry::operator > (const T_MarketListEntry& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MarketListEntry::clear() {
    clearAbbrMarketName();
    clearFullMarketName();
    clearBIsActiveMarket();
}

inline void T_MarketListEntry::clearAbbrMarketName() {
    if (hasAbbrMarketName()) {
         clear_has_AbbrMarketName();
        _AbbrMarketName.clear();
     }
}

inline bool T_MarketListEntry::hasAbbrMarketName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_MarketListEntry::getAbbrMarketName () const {
    return _AbbrMarketName;
}

inline ::std::string& T_MarketListEntry::getAbbrMarketNameMutable () {
    set_has_AbbrMarketName();
    return _AbbrMarketName;
}

inline void T_MarketListEntry::setAbbrMarketName (const ::std::string& AbbrMarketName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AbbrMarketName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AbbrMarketName();
    this->_AbbrMarketName = AbbrMarketName_;
}

inline void T_MarketListEntry::setAbbrMarketName (const char* AbbrMarketName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AbbrMarketName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AbbrMarketName();
    this->_AbbrMarketName.assign(AbbrMarketName_);
}

inline void T_MarketListEntry::setAbbrMarketName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AbbrMarketName();
    this->_AbbrMarketName.assign(value, size);
}

inline void T_MarketListEntry::clearFullMarketName() {
    if (hasFullMarketName()) {
         clear_has_FullMarketName();
        _FullMarketName.clear();
     }
}

inline bool T_MarketListEntry::hasFullMarketName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_MarketListEntry::getFullMarketName () const {
    return _FullMarketName;
}

inline ::std::string& T_MarketListEntry::getFullMarketNameMutable () {
    set_has_FullMarketName();
    return _FullMarketName;
}

inline void T_MarketListEntry::setFullMarketName (const ::std::string& FullMarketName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FullMarketName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FullMarketName();
    this->_FullMarketName = FullMarketName_;
}

inline void T_MarketListEntry::setFullMarketName (const char* FullMarketName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FullMarketName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FullMarketName();
    this->_FullMarketName.assign(FullMarketName_);
}

inline void T_MarketListEntry::setFullMarketName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FullMarketName();
    this->_FullMarketName.assign(value, size);
}

inline void T_MarketListEntry::clearBIsActiveMarket() {
    if (hasBIsActiveMarket()) {
         clear_has_bIsActiveMarket();
        _bIsActiveMarket = false;
     }
}

inline bool T_MarketListEntry::hasBIsActiveMarket () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_MarketListEntry::getBIsActiveMarket () const {
    return _bIsActiveMarket;
}

inline void T_MarketListEntry::setBIsActiveMarket (bool bIsActiveMarket_) {
    set_has_bIsActiveMarket();
    this->_bIsActiveMarket = bIsActiveMarket_;
}

inline void T_MarketListEntry::set_has_AbbrMarketName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MarketListEntry::clear_has_AbbrMarketName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MarketListEntry::set_has_FullMarketName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MarketListEntry::clear_has_FullMarketName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MarketListEntry::set_has_bIsActiveMarket () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MarketListEntry::clear_has_bIsActiveMarket () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SportsFlash_FavoriteTeam::T_SportsFlash_FavoriteTeam ()  :
    _SportType (::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport__SPORTS_UNKNOWN),
    _LeagueID (0u),
    _LeagueType (::sxm_audio_main_fi_types::T_e8_SportsFlash_League__LEAGUE_NFL),
    _LeagueAbbrName (),
    _LeagueFullName (),
    _TeamID (0u),
    _TeamName (),
    _TeamNickName (),
    _TeamAbbrName (),
    _TeamFullName (),
    _IsFavorite (false),
    _IsMonitored (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SportsFlash_FavoriteTeam::T_SportsFlash_FavoriteTeam (const T_SportsFlash_FavoriteTeam &rhs)  :
    _SportType (::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport__SPORTS_UNKNOWN),
    _LeagueID (0u),
    _LeagueType (::sxm_audio_main_fi_types::T_e8_SportsFlash_League__LEAGUE_NFL),
    _LeagueAbbrName (),
    _LeagueFullName (),
    _TeamID (0u),
    _TeamName (),
    _TeamNickName (),
    _TeamAbbrName (),
    _TeamFullName (),
    _IsFavorite (false),
    _IsMonitored (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SportsFlash_FavoriteTeam::T_SportsFlash_FavoriteTeam (T_e8_SportsFlash_Sport SportType_, uint8 LeagueID_, T_e8_SportsFlash_League LeagueType_, const ::std::string& LeagueAbbrName_, const ::std::string& LeagueFullName_, uint16 TeamID_, const ::std::string& TeamName_, const ::std::string& TeamNickName_, const ::std::string& TeamAbbrName_, const ::std::string& TeamFullName_, bool IsFavorite_, bool IsMonitored_)  :
    _SportType (SportType_),
    _LeagueID (LeagueID_),
    _LeagueType (LeagueType_),
    _LeagueAbbrName (LeagueAbbrName_),
    _LeagueFullName (LeagueFullName_),
    _TeamID (TeamID_),
    _TeamName (TeamName_),
    _TeamNickName (TeamNickName_),
    _TeamAbbrName (TeamAbbrName_),
    _TeamFullName (TeamFullName_),
    _IsFavorite (IsFavorite_),
    _IsMonitored (IsMonitored_)
{
    #ifndef NDEBUG
    if (!(T_e8_SportsFlash_Sport_IsValid(SportType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SportType_, "T_e8_SportsFlash_Sport", "SportType", "T_SportsFlash_FavoriteTeam");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SportsFlash_League_IsValid(LeagueType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", LeagueType_, "T_e8_SportsFlash_League", "LeagueType", "T_SportsFlash_FavoriteTeam");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LeagueAbbrName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LeagueFullName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamNickName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamAbbrName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamFullName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SportsFlash_FavoriteTeam::~T_SportsFlash_FavoriteTeam() {
}

inline T_SportsFlash_FavoriteTeam& T_SportsFlash_FavoriteTeam::operator = (const T_SportsFlash_FavoriteTeam& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSportType()) {
            setSportType(rhs.getSportType());
        } else {
            clearSportType();
        }
        if (rhs.hasLeagueID()) {
            setLeagueID(rhs.getLeagueID());
        } else {
            clearLeagueID();
        }
        if (rhs.hasLeagueType()) {
            setLeagueType(rhs.getLeagueType());
        } else {
            clearLeagueType();
        }
        if (rhs.hasLeagueAbbrName()) {
            setLeagueAbbrName(rhs.getLeagueAbbrName());
        } else {
            clearLeagueAbbrName();
        }
        if (rhs.hasLeagueFullName()) {
            setLeagueFullName(rhs.getLeagueFullName());
        } else {
            clearLeagueFullName();
        }
        if (rhs.hasTeamID()) {
            setTeamID(rhs.getTeamID());
        } else {
            clearTeamID();
        }
        if (rhs.hasTeamName()) {
            setTeamName(rhs.getTeamName());
        } else {
            clearTeamName();
        }
        if (rhs.hasTeamNickName()) {
            setTeamNickName(rhs.getTeamNickName());
        } else {
            clearTeamNickName();
        }
        if (rhs.hasTeamAbbrName()) {
            setTeamAbbrName(rhs.getTeamAbbrName());
        } else {
            clearTeamAbbrName();
        }
        if (rhs.hasTeamFullName()) {
            setTeamFullName(rhs.getTeamFullName());
        } else {
            clearTeamFullName();
        }
        if (rhs.hasIsFavorite()) {
            setIsFavorite(rhs.getIsFavorite());
        } else {
            clearIsFavorite();
        }
        if (rhs.hasIsMonitored()) {
            setIsMonitored(rhs.getIsMonitored());
        } else {
            clearIsMonitored();
        }
    }
    return *this;
}

inline bool T_SportsFlash_FavoriteTeam::operator == (const T_SportsFlash_FavoriteTeam& rhs) const {
    return (((!hasSportType() && !rhs.hasSportType()) || getSportType() == rhs.getSportType()) &&
        ((!hasLeagueID() && !rhs.hasLeagueID()) || getLeagueID() == rhs.getLeagueID()) &&
        ((!hasLeagueType() && !rhs.hasLeagueType()) || getLeagueType() == rhs.getLeagueType()) &&
        ((!hasLeagueAbbrName() && !rhs.hasLeagueAbbrName()) || getLeagueAbbrName() == rhs.getLeagueAbbrName()) &&
        ((!hasLeagueFullName() && !rhs.hasLeagueFullName()) || getLeagueFullName() == rhs.getLeagueFullName()) &&
        ((!hasTeamID() && !rhs.hasTeamID()) || getTeamID() == rhs.getTeamID()) &&
        ((!hasTeamName() && !rhs.hasTeamName()) || getTeamName() == rhs.getTeamName()) &&
        ((!hasTeamNickName() && !rhs.hasTeamNickName()) || getTeamNickName() == rhs.getTeamNickName()) &&
        ((!hasTeamAbbrName() && !rhs.hasTeamAbbrName()) || getTeamAbbrName() == rhs.getTeamAbbrName()) &&
        ((!hasTeamFullName() && !rhs.hasTeamFullName()) || getTeamFullName() == rhs.getTeamFullName()) &&
        ((!hasIsFavorite() && !rhs.hasIsFavorite()) || getIsFavorite() == rhs.getIsFavorite()) &&
        ((!hasIsMonitored() && !rhs.hasIsMonitored()) || getIsMonitored() == rhs.getIsMonitored()));
}

inline bool T_SportsFlash_FavoriteTeam::operator != (const T_SportsFlash_FavoriteTeam& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SportsFlash_FavoriteTeam::operator < (const T_SportsFlash_FavoriteTeam& rhs) const {
    if (hasSportType() || rhs.hasSportType()) {
        if ((uint32)getSportType() < (uint32)rhs.getSportType()) return true;
        if ((uint32)getSportType() > (uint32)rhs.getSportType()) return false;
    }
    if (hasLeagueID() || rhs.hasLeagueID()) {
        if (getLeagueID() < rhs.getLeagueID()) return true;
        if (getLeagueID() > rhs.getLeagueID()) return false;
    }
    if (hasLeagueType() || rhs.hasLeagueType()) {
        if ((uint32)getLeagueType() < (uint32)rhs.getLeagueType()) return true;
        if ((uint32)getLeagueType() > (uint32)rhs.getLeagueType()) return false;
    }
    if (hasLeagueAbbrName() || rhs.hasLeagueAbbrName()) {
        if (getLeagueAbbrName() < rhs.getLeagueAbbrName()) return true;
        if (getLeagueAbbrName() > rhs.getLeagueAbbrName()) return false;
    }
    if (hasLeagueFullName() || rhs.hasLeagueFullName()) {
        if (getLeagueFullName() < rhs.getLeagueFullName()) return true;
        if (getLeagueFullName() > rhs.getLeagueFullName()) return false;
    }
    if (hasTeamID() || rhs.hasTeamID()) {
        if (getTeamID() < rhs.getTeamID()) return true;
        if (getTeamID() > rhs.getTeamID()) return false;
    }
    if (hasTeamName() || rhs.hasTeamName()) {
        if (getTeamName() < rhs.getTeamName()) return true;
        if (getTeamName() > rhs.getTeamName()) return false;
    }
    if (hasTeamNickName() || rhs.hasTeamNickName()) {
        if (getTeamNickName() < rhs.getTeamNickName()) return true;
        if (getTeamNickName() > rhs.getTeamNickName()) return false;
    }
    if (hasTeamAbbrName() || rhs.hasTeamAbbrName()) {
        if (getTeamAbbrName() < rhs.getTeamAbbrName()) return true;
        if (getTeamAbbrName() > rhs.getTeamAbbrName()) return false;
    }
    if (hasTeamFullName() || rhs.hasTeamFullName()) {
        if (getTeamFullName() < rhs.getTeamFullName()) return true;
        if (getTeamFullName() > rhs.getTeamFullName()) return false;
    }
    if (hasIsFavorite() || rhs.hasIsFavorite()) {
        if (getIsFavorite() < rhs.getIsFavorite()) return true;
        if (getIsFavorite() > rhs.getIsFavorite()) return false;
    }
    if (hasIsMonitored() || rhs.hasIsMonitored()) {
        if (getIsMonitored() < rhs.getIsMonitored()) return true;
        if (getIsMonitored() > rhs.getIsMonitored()) return false;
    }
    return false;
}

inline bool T_SportsFlash_FavoriteTeam::operator > (const T_SportsFlash_FavoriteTeam& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SportsFlash_FavoriteTeam::clear() {
    clearSportType();
    clearLeagueID();
    clearLeagueType();
    clearLeagueAbbrName();
    clearLeagueFullName();
    clearTeamID();
    clearTeamName();
    clearTeamNickName();
    clearTeamAbbrName();
    clearTeamFullName();
    clearIsFavorite();
    clearIsMonitored();
}

inline void T_SportsFlash_FavoriteTeam::clearSportType() {
    if (hasSportType()) {
         clear_has_SportType();
        _SportType = ::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport__SPORTS_UNKNOWN;
     }
}

inline bool T_SportsFlash_FavoriteTeam::hasSportType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_SportsFlash_Sport T_SportsFlash_FavoriteTeam::getSportType () const {
    return _SportType;
}

inline void T_SportsFlash_FavoriteTeam::setSportType (T_e8_SportsFlash_Sport SportType_) {
    #ifndef NDEBUG
    if (!(T_e8_SportsFlash_Sport_IsValid(SportType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SportType_, "T_e8_SportsFlash_Sport", "SportType", "T_SportsFlash_FavoriteTeam");
    }
    #endif
    set_has_SportType();
    this->_SportType = SportType_;
}

inline void T_SportsFlash_FavoriteTeam::clearLeagueID() {
    if (hasLeagueID()) {
         clear_has_LeagueID();
        _LeagueID = 0u;
     }
}

inline bool T_SportsFlash_FavoriteTeam::hasLeagueID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_SportsFlash_FavoriteTeam::getLeagueID () const {
    return _LeagueID;
}

inline void T_SportsFlash_FavoriteTeam::setLeagueID (uint8 LeagueID_) {
    set_has_LeagueID();
    this->_LeagueID = LeagueID_;
}

inline void T_SportsFlash_FavoriteTeam::clearLeagueType() {
    if (hasLeagueType()) {
         clear_has_LeagueType();
        _LeagueType = ::sxm_audio_main_fi_types::T_e8_SportsFlash_League__LEAGUE_NFL;
     }
}

inline bool T_SportsFlash_FavoriteTeam::hasLeagueType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_SportsFlash_League T_SportsFlash_FavoriteTeam::getLeagueType () const {
    return _LeagueType;
}

inline void T_SportsFlash_FavoriteTeam::setLeagueType (T_e8_SportsFlash_League LeagueType_) {
    #ifndef NDEBUG
    if (!(T_e8_SportsFlash_League_IsValid(LeagueType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", LeagueType_, "T_e8_SportsFlash_League", "LeagueType", "T_SportsFlash_FavoriteTeam");
    }
    #endif
    set_has_LeagueType();
    this->_LeagueType = LeagueType_;
}

inline void T_SportsFlash_FavoriteTeam::clearLeagueAbbrName() {
    if (hasLeagueAbbrName()) {
         clear_has_LeagueAbbrName();
        _LeagueAbbrName.clear();
     }
}

inline bool T_SportsFlash_FavoriteTeam::hasLeagueAbbrName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_SportsFlash_FavoriteTeam::getLeagueAbbrName () const {
    return _LeagueAbbrName;
}

inline ::std::string& T_SportsFlash_FavoriteTeam::getLeagueAbbrNameMutable () {
    set_has_LeagueAbbrName();
    return _LeagueAbbrName;
}

inline void T_SportsFlash_FavoriteTeam::setLeagueAbbrName (const ::std::string& LeagueAbbrName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LeagueAbbrName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LeagueAbbrName();
    this->_LeagueAbbrName = LeagueAbbrName_;
}

inline void T_SportsFlash_FavoriteTeam::setLeagueAbbrName (const char* LeagueAbbrName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LeagueAbbrName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LeagueAbbrName();
    this->_LeagueAbbrName.assign(LeagueAbbrName_);
}

inline void T_SportsFlash_FavoriteTeam::setLeagueAbbrName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LeagueAbbrName();
    this->_LeagueAbbrName.assign(value, size);
}

inline void T_SportsFlash_FavoriteTeam::clearLeagueFullName() {
    if (hasLeagueFullName()) {
         clear_has_LeagueFullName();
        _LeagueFullName.clear();
     }
}

inline bool T_SportsFlash_FavoriteTeam::hasLeagueFullName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_SportsFlash_FavoriteTeam::getLeagueFullName () const {
    return _LeagueFullName;
}

inline ::std::string& T_SportsFlash_FavoriteTeam::getLeagueFullNameMutable () {
    set_has_LeagueFullName();
    return _LeagueFullName;
}

inline void T_SportsFlash_FavoriteTeam::setLeagueFullName (const ::std::string& LeagueFullName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LeagueFullName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LeagueFullName();
    this->_LeagueFullName = LeagueFullName_;
}

inline void T_SportsFlash_FavoriteTeam::setLeagueFullName (const char* LeagueFullName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LeagueFullName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LeagueFullName();
    this->_LeagueFullName.assign(LeagueFullName_);
}

inline void T_SportsFlash_FavoriteTeam::setLeagueFullName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LeagueFullName();
    this->_LeagueFullName.assign(value, size);
}

inline void T_SportsFlash_FavoriteTeam::clearTeamID() {
    if (hasTeamID()) {
         clear_has_TeamID();
        _TeamID = 0u;
     }
}

inline bool T_SportsFlash_FavoriteTeam::hasTeamID () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 T_SportsFlash_FavoriteTeam::getTeamID () const {
    return _TeamID;
}

inline void T_SportsFlash_FavoriteTeam::setTeamID (uint16 TeamID_) {
    set_has_TeamID();
    this->_TeamID = TeamID_;
}

inline void T_SportsFlash_FavoriteTeam::clearTeamName() {
    if (hasTeamName()) {
         clear_has_TeamName();
        _TeamName.clear();
     }
}

inline bool T_SportsFlash_FavoriteTeam::hasTeamName () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_SportsFlash_FavoriteTeam::getTeamName () const {
    return _TeamName;
}

inline ::std::string& T_SportsFlash_FavoriteTeam::getTeamNameMutable () {
    set_has_TeamName();
    return _TeamName;
}

inline void T_SportsFlash_FavoriteTeam::setTeamName (const ::std::string& TeamName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamName();
    this->_TeamName = TeamName_;
}

inline void T_SportsFlash_FavoriteTeam::setTeamName (const char* TeamName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamName();
    this->_TeamName.assign(TeamName_);
}

inline void T_SportsFlash_FavoriteTeam::setTeamName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamName();
    this->_TeamName.assign(value, size);
}

inline void T_SportsFlash_FavoriteTeam::clearTeamNickName() {
    if (hasTeamNickName()) {
         clear_has_TeamNickName();
        _TeamNickName.clear();
     }
}

inline bool T_SportsFlash_FavoriteTeam::hasTeamNickName () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_SportsFlash_FavoriteTeam::getTeamNickName () const {
    return _TeamNickName;
}

inline ::std::string& T_SportsFlash_FavoriteTeam::getTeamNickNameMutable () {
    set_has_TeamNickName();
    return _TeamNickName;
}

inline void T_SportsFlash_FavoriteTeam::setTeamNickName (const ::std::string& TeamNickName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamNickName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamNickName();
    this->_TeamNickName = TeamNickName_;
}

inline void T_SportsFlash_FavoriteTeam::setTeamNickName (const char* TeamNickName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamNickName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamNickName();
    this->_TeamNickName.assign(TeamNickName_);
}

inline void T_SportsFlash_FavoriteTeam::setTeamNickName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamNickName();
    this->_TeamNickName.assign(value, size);
}

inline void T_SportsFlash_FavoriteTeam::clearTeamAbbrName() {
    if (hasTeamAbbrName()) {
         clear_has_TeamAbbrName();
        _TeamAbbrName.clear();
     }
}

inline bool T_SportsFlash_FavoriteTeam::hasTeamAbbrName () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_SportsFlash_FavoriteTeam::getTeamAbbrName () const {
    return _TeamAbbrName;
}

inline ::std::string& T_SportsFlash_FavoriteTeam::getTeamAbbrNameMutable () {
    set_has_TeamAbbrName();
    return _TeamAbbrName;
}

inline void T_SportsFlash_FavoriteTeam::setTeamAbbrName (const ::std::string& TeamAbbrName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamAbbrName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamAbbrName();
    this->_TeamAbbrName = TeamAbbrName_;
}

inline void T_SportsFlash_FavoriteTeam::setTeamAbbrName (const char* TeamAbbrName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamAbbrName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamAbbrName();
    this->_TeamAbbrName.assign(TeamAbbrName_);
}

inline void T_SportsFlash_FavoriteTeam::setTeamAbbrName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamAbbrName();
    this->_TeamAbbrName.assign(value, size);
}

inline void T_SportsFlash_FavoriteTeam::clearTeamFullName() {
    if (hasTeamFullName()) {
         clear_has_TeamFullName();
        _TeamFullName.clear();
     }
}

inline bool T_SportsFlash_FavoriteTeam::hasTeamFullName () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_SportsFlash_FavoriteTeam::getTeamFullName () const {
    return _TeamFullName;
}

inline ::std::string& T_SportsFlash_FavoriteTeam::getTeamFullNameMutable () {
    set_has_TeamFullName();
    return _TeamFullName;
}

inline void T_SportsFlash_FavoriteTeam::setTeamFullName (const ::std::string& TeamFullName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamFullName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamFullName();
    this->_TeamFullName = TeamFullName_;
}

inline void T_SportsFlash_FavoriteTeam::setTeamFullName (const char* TeamFullName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamFullName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamFullName();
    this->_TeamFullName.assign(TeamFullName_);
}

inline void T_SportsFlash_FavoriteTeam::setTeamFullName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamFullName();
    this->_TeamFullName.assign(value, size);
}

inline void T_SportsFlash_FavoriteTeam::clearIsFavorite() {
    if (hasIsFavorite()) {
         clear_has_IsFavorite();
        _IsFavorite = false;
     }
}

inline bool T_SportsFlash_FavoriteTeam::hasIsFavorite () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool T_SportsFlash_FavoriteTeam::getIsFavorite () const {
    return _IsFavorite;
}

inline void T_SportsFlash_FavoriteTeam::setIsFavorite (bool IsFavorite_) {
    set_has_IsFavorite();
    this->_IsFavorite = IsFavorite_;
}

inline void T_SportsFlash_FavoriteTeam::clearIsMonitored() {
    if (hasIsMonitored()) {
         clear_has_IsMonitored();
        _IsMonitored = false;
     }
}

inline bool T_SportsFlash_FavoriteTeam::hasIsMonitored () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline bool T_SportsFlash_FavoriteTeam::getIsMonitored () const {
    return _IsMonitored;
}

inline void T_SportsFlash_FavoriteTeam::setIsMonitored (bool IsMonitored_) {
    set_has_IsMonitored();
    this->_IsMonitored = IsMonitored_;
}

inline void T_SportsFlash_FavoriteTeam::set_has_SportType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SportsFlash_FavoriteTeam::clear_has_SportType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SportsFlash_FavoriteTeam::set_has_LeagueID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SportsFlash_FavoriteTeam::clear_has_LeagueID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SportsFlash_FavoriteTeam::set_has_LeagueType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SportsFlash_FavoriteTeam::clear_has_LeagueType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SportsFlash_FavoriteTeam::set_has_LeagueAbbrName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SportsFlash_FavoriteTeam::clear_has_LeagueAbbrName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SportsFlash_FavoriteTeam::set_has_LeagueFullName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SportsFlash_FavoriteTeam::clear_has_LeagueFullName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SportsFlash_FavoriteTeam::set_has_TeamID () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SportsFlash_FavoriteTeam::clear_has_TeamID () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SportsFlash_FavoriteTeam::set_has_TeamName () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SportsFlash_FavoriteTeam::clear_has_TeamName () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SportsFlash_FavoriteTeam::set_has_TeamNickName () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SportsFlash_FavoriteTeam::clear_has_TeamNickName () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_SportsFlash_FavoriteTeam::set_has_TeamAbbrName () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_SportsFlash_FavoriteTeam::clear_has_TeamAbbrName () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_SportsFlash_FavoriteTeam::set_has_TeamFullName () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_SportsFlash_FavoriteTeam::clear_has_TeamFullName () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_SportsFlash_FavoriteTeam::set_has_IsFavorite () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_SportsFlash_FavoriteTeam::clear_has_IsFavorite () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_SportsFlash_FavoriteTeam::set_has_IsMonitored () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_SportsFlash_FavoriteTeam::clear_has_IsMonitored () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline  T_SportsFlash_Game::T_SportsFlash_Game ()  :
    _ChannelID (0u),
    _ServiceID (0u),
    _IsLocked (false),
    _IsMature (false),
    _IsSkipped (false),
    _Bias (0u),
    _HomeTeam (),
    _AwayTeam (),
    _ChnGraphicsAvailable (::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SportsFlash_Game::T_SportsFlash_Game (const T_SportsFlash_Game &rhs)  :
    _ChannelID (0u),
    _ServiceID (0u),
    _IsLocked (false),
    _IsMature (false),
    _IsSkipped (false),
    _Bias (0u),
    _HomeTeam (),
    _AwayTeam (),
    _ChnGraphicsAvailable (::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SportsFlash_Game::T_SportsFlash_Game (uint16 ChannelID_, uint16 ServiceID_, bool IsLocked_, bool IsMature_, bool IsSkipped_, uint16 Bias_, const T_SportsFlash_FavoriteTeam& HomeTeam_, const T_SportsFlash_FavoriteTeam& AwayTeam_, T_e8_Graphics ChnGraphicsAvailable_)  :
    _ChannelID (ChannelID_),
    _ServiceID (ServiceID_),
    _IsLocked (IsLocked_),
    _IsMature (IsMature_),
    _IsSkipped (IsSkipped_),
    _Bias (Bias_),
    _HomeTeam (HomeTeam_),
    _AwayTeam (AwayTeam_),
    _ChnGraphicsAvailable (ChnGraphicsAvailable_)
{
    #ifndef NDEBUG
    if (!(T_e8_Graphics_IsValid(ChnGraphicsAvailable_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChnGraphicsAvailable_, "T_e8_Graphics", "ChnGraphicsAvailable", "T_SportsFlash_Game");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SportsFlash_Game::~T_SportsFlash_Game() {
}

inline T_SportsFlash_Game& T_SportsFlash_Game::operator = (const T_SportsFlash_Game& rhs) {
    if( this != &rhs ) {
        if (rhs.hasChannelID()) {
            setChannelID(rhs.getChannelID());
        } else {
            clearChannelID();
        }
        if (rhs.hasServiceID()) {
            setServiceID(rhs.getServiceID());
        } else {
            clearServiceID();
        }
        if (rhs.hasIsLocked()) {
            setIsLocked(rhs.getIsLocked());
        } else {
            clearIsLocked();
        }
        if (rhs.hasIsMature()) {
            setIsMature(rhs.getIsMature());
        } else {
            clearIsMature();
        }
        if (rhs.hasIsSkipped()) {
            setIsSkipped(rhs.getIsSkipped());
        } else {
            clearIsSkipped();
        }
        if (rhs.hasBias()) {
            setBias(rhs.getBias());
        } else {
            clearBias();
        }
        if (rhs.hasHomeTeam()) {
            setHomeTeam(rhs.getHomeTeam());
        } else {
            clearHomeTeam();
        }
        if (rhs.hasAwayTeam()) {
            setAwayTeam(rhs.getAwayTeam());
        } else {
            clearAwayTeam();
        }
        if (rhs.hasChnGraphicsAvailable()) {
            setChnGraphicsAvailable(rhs.getChnGraphicsAvailable());
        } else {
            clearChnGraphicsAvailable();
        }
    }
    return *this;
}

inline bool T_SportsFlash_Game::operator == (const T_SportsFlash_Game& rhs) const {
    return (((!hasChannelID() && !rhs.hasChannelID()) || getChannelID() == rhs.getChannelID()) &&
        ((!hasServiceID() && !rhs.hasServiceID()) || getServiceID() == rhs.getServiceID()) &&
        ((!hasIsLocked() && !rhs.hasIsLocked()) || getIsLocked() == rhs.getIsLocked()) &&
        ((!hasIsMature() && !rhs.hasIsMature()) || getIsMature() == rhs.getIsMature()) &&
        ((!hasIsSkipped() && !rhs.hasIsSkipped()) || getIsSkipped() == rhs.getIsSkipped()) &&
        ((!hasBias() && !rhs.hasBias()) || getBias() == rhs.getBias()) &&
        ((!hasHomeTeam() && !rhs.hasHomeTeam()) || getHomeTeam() == rhs.getHomeTeam()) &&
        ((!hasAwayTeam() && !rhs.hasAwayTeam()) || getAwayTeam() == rhs.getAwayTeam()) &&
        ((!hasChnGraphicsAvailable() && !rhs.hasChnGraphicsAvailable()) || getChnGraphicsAvailable() == rhs.getChnGraphicsAvailable()));
}

inline bool T_SportsFlash_Game::operator != (const T_SportsFlash_Game& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SportsFlash_Game::operator < (const T_SportsFlash_Game& rhs) const {
    if (hasChannelID() || rhs.hasChannelID()) {
        if (getChannelID() < rhs.getChannelID()) return true;
        if (getChannelID() > rhs.getChannelID()) return false;
    }
    if (hasServiceID() || rhs.hasServiceID()) {
        if (getServiceID() < rhs.getServiceID()) return true;
        if (getServiceID() > rhs.getServiceID()) return false;
    }
    if (hasIsLocked() || rhs.hasIsLocked()) {
        if (getIsLocked() < rhs.getIsLocked()) return true;
        if (getIsLocked() > rhs.getIsLocked()) return false;
    }
    if (hasIsMature() || rhs.hasIsMature()) {
        if (getIsMature() < rhs.getIsMature()) return true;
        if (getIsMature() > rhs.getIsMature()) return false;
    }
    if (hasIsSkipped() || rhs.hasIsSkipped()) {
        if (getIsSkipped() < rhs.getIsSkipped()) return true;
        if (getIsSkipped() > rhs.getIsSkipped()) return false;
    }
    if (hasBias() || rhs.hasBias()) {
        if (getBias() < rhs.getBias()) return true;
        if (getBias() > rhs.getBias()) return false;
    }
    if (hasHomeTeam() || rhs.hasHomeTeam()) {
        if (getHomeTeam() < rhs.getHomeTeam()) return true;
        if (getHomeTeam() > rhs.getHomeTeam()) return false;
    }
    if (hasAwayTeam() || rhs.hasAwayTeam()) {
        if (getAwayTeam() < rhs.getAwayTeam()) return true;
        if (getAwayTeam() > rhs.getAwayTeam()) return false;
    }
    if (hasChnGraphicsAvailable() || rhs.hasChnGraphicsAvailable()) {
        if ((uint32)getChnGraphicsAvailable() < (uint32)rhs.getChnGraphicsAvailable()) return true;
        if ((uint32)getChnGraphicsAvailable() > (uint32)rhs.getChnGraphicsAvailable()) return false;
    }
    return false;
}

inline bool T_SportsFlash_Game::operator > (const T_SportsFlash_Game& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SportsFlash_Game::clear() {
    clearChannelID();
    clearServiceID();
    clearIsLocked();
    clearIsMature();
    clearIsSkipped();
    clearBias();
    clearHomeTeam();
    clearAwayTeam();
    clearChnGraphicsAvailable();
}

inline void T_SportsFlash_Game::clearChannelID() {
    if (hasChannelID()) {
         clear_has_ChannelID();
        _ChannelID = 0u;
     }
}

inline bool T_SportsFlash_Game::hasChannelID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_SportsFlash_Game::getChannelID () const {
    return _ChannelID;
}

inline void T_SportsFlash_Game::setChannelID (uint16 ChannelID_) {
    set_has_ChannelID();
    this->_ChannelID = ChannelID_;
}

inline void T_SportsFlash_Game::clearServiceID() {
    if (hasServiceID()) {
         clear_has_ServiceID();
        _ServiceID = 0u;
     }
}

inline bool T_SportsFlash_Game::hasServiceID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_SportsFlash_Game::getServiceID () const {
    return _ServiceID;
}

inline void T_SportsFlash_Game::setServiceID (uint16 ServiceID_) {
    set_has_ServiceID();
    this->_ServiceID = ServiceID_;
}

inline void T_SportsFlash_Game::clearIsLocked() {
    if (hasIsLocked()) {
         clear_has_IsLocked();
        _IsLocked = false;
     }
}

inline bool T_SportsFlash_Game::hasIsLocked () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_SportsFlash_Game::getIsLocked () const {
    return _IsLocked;
}

inline void T_SportsFlash_Game::setIsLocked (bool IsLocked_) {
    set_has_IsLocked();
    this->_IsLocked = IsLocked_;
}

inline void T_SportsFlash_Game::clearIsMature() {
    if (hasIsMature()) {
         clear_has_IsMature();
        _IsMature = false;
     }
}

inline bool T_SportsFlash_Game::hasIsMature () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_SportsFlash_Game::getIsMature () const {
    return _IsMature;
}

inline void T_SportsFlash_Game::setIsMature (bool IsMature_) {
    set_has_IsMature();
    this->_IsMature = IsMature_;
}

inline void T_SportsFlash_Game::clearIsSkipped() {
    if (hasIsSkipped()) {
         clear_has_IsSkipped();
        _IsSkipped = false;
     }
}

inline bool T_SportsFlash_Game::hasIsSkipped () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_SportsFlash_Game::getIsSkipped () const {
    return _IsSkipped;
}

inline void T_SportsFlash_Game::setIsSkipped (bool IsSkipped_) {
    set_has_IsSkipped();
    this->_IsSkipped = IsSkipped_;
}

inline void T_SportsFlash_Game::clearBias() {
    if (hasBias()) {
         clear_has_Bias();
        _Bias = 0u;
     }
}

inline bool T_SportsFlash_Game::hasBias () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 T_SportsFlash_Game::getBias () const {
    return _Bias;
}

inline void T_SportsFlash_Game::setBias (uint16 Bias_) {
    set_has_Bias();
    this->_Bias = Bias_;
}

inline void T_SportsFlash_Game::clearHomeTeam() {
    if (hasHomeTeam()) {
         clear_has_HomeTeam();
        _HomeTeam.clear();
     }
}

inline bool T_SportsFlash_Game::hasHomeTeam () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const T_SportsFlash_FavoriteTeam& T_SportsFlash_Game::getHomeTeam () const {
    return _HomeTeam;
}

inline T_SportsFlash_FavoriteTeam& T_SportsFlash_Game::getHomeTeamMutable () {
    set_has_HomeTeam();
    return _HomeTeam;
}

inline void T_SportsFlash_Game::setHomeTeam (const T_SportsFlash_FavoriteTeam& HomeTeam_) {
    set_has_HomeTeam();
    this->_HomeTeam = HomeTeam_;
}

inline void T_SportsFlash_Game::clearAwayTeam() {
    if (hasAwayTeam()) {
         clear_has_AwayTeam();
        _AwayTeam.clear();
     }
}

inline bool T_SportsFlash_Game::hasAwayTeam () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const T_SportsFlash_FavoriteTeam& T_SportsFlash_Game::getAwayTeam () const {
    return _AwayTeam;
}

inline T_SportsFlash_FavoriteTeam& T_SportsFlash_Game::getAwayTeamMutable () {
    set_has_AwayTeam();
    return _AwayTeam;
}

inline void T_SportsFlash_Game::setAwayTeam (const T_SportsFlash_FavoriteTeam& AwayTeam_) {
    set_has_AwayTeam();
    this->_AwayTeam = AwayTeam_;
}

inline void T_SportsFlash_Game::clearChnGraphicsAvailable() {
    if (hasChnGraphicsAvailable()) {
         clear_has_ChnGraphicsAvailable();
        _ChnGraphicsAvailable = ::sxm_audio_main_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH;
     }
}

inline bool T_SportsFlash_Game::hasChnGraphicsAvailable () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline T_e8_Graphics T_SportsFlash_Game::getChnGraphicsAvailable () const {
    return _ChnGraphicsAvailable;
}

inline void T_SportsFlash_Game::setChnGraphicsAvailable (T_e8_Graphics ChnGraphicsAvailable_) {
    #ifndef NDEBUG
    if (!(T_e8_Graphics_IsValid(ChnGraphicsAvailable_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChnGraphicsAvailable_, "T_e8_Graphics", "ChnGraphicsAvailable", "T_SportsFlash_Game");
    }
    #endif
    set_has_ChnGraphicsAvailable();
    this->_ChnGraphicsAvailable = ChnGraphicsAvailable_;
}

inline void T_SportsFlash_Game::set_has_ChannelID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SportsFlash_Game::clear_has_ChannelID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SportsFlash_Game::set_has_ServiceID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SportsFlash_Game::clear_has_ServiceID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SportsFlash_Game::set_has_IsLocked () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SportsFlash_Game::clear_has_IsLocked () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SportsFlash_Game::set_has_IsMature () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SportsFlash_Game::clear_has_IsMature () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SportsFlash_Game::set_has_IsSkipped () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SportsFlash_Game::clear_has_IsSkipped () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SportsFlash_Game::set_has_Bias () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SportsFlash_Game::clear_has_Bias () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SportsFlash_Game::set_has_HomeTeam () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SportsFlash_Game::clear_has_HomeTeam () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SportsFlash_Game::set_has_AwayTeam () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SportsFlash_Game::clear_has_AwayTeam () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_SportsFlash_Game::set_has_ChnGraphicsAvailable () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_SportsFlash_Game::clear_has_ChnGraphicsAvailable () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_SportsFlash_FlashEvent::T_SportsFlash_FlashEvent ()  :
    _GameInfo (),
    _FlashEventID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SportsFlash_FlashEvent::T_SportsFlash_FlashEvent (const T_SportsFlash_FlashEvent &rhs)  :
    _GameInfo (),
    _FlashEventID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SportsFlash_FlashEvent::T_SportsFlash_FlashEvent (const T_SportsFlash_Game& GameInfo_, uint32 FlashEventID_)  :
    _GameInfo (GameInfo_),
    _FlashEventID (FlashEventID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SportsFlash_FlashEvent::~T_SportsFlash_FlashEvent() {
}

inline T_SportsFlash_FlashEvent& T_SportsFlash_FlashEvent::operator = (const T_SportsFlash_FlashEvent& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGameInfo()) {
            setGameInfo(rhs.getGameInfo());
        } else {
            clearGameInfo();
        }
        if (rhs.hasFlashEventID()) {
            setFlashEventID(rhs.getFlashEventID());
        } else {
            clearFlashEventID();
        }
    }
    return *this;
}

inline bool T_SportsFlash_FlashEvent::operator == (const T_SportsFlash_FlashEvent& rhs) const {
    return (((!hasGameInfo() && !rhs.hasGameInfo()) || getGameInfo() == rhs.getGameInfo()) &&
        ((!hasFlashEventID() && !rhs.hasFlashEventID()) || getFlashEventID() == rhs.getFlashEventID()));
}

inline bool T_SportsFlash_FlashEvent::operator != (const T_SportsFlash_FlashEvent& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SportsFlash_FlashEvent::operator < (const T_SportsFlash_FlashEvent& rhs) const {
    if (hasGameInfo() || rhs.hasGameInfo()) {
        if (getGameInfo() < rhs.getGameInfo()) return true;
        if (getGameInfo() > rhs.getGameInfo()) return false;
    }
    if (hasFlashEventID() || rhs.hasFlashEventID()) {
        if (getFlashEventID() < rhs.getFlashEventID()) return true;
        if (getFlashEventID() > rhs.getFlashEventID()) return false;
    }
    return false;
}

inline bool T_SportsFlash_FlashEvent::operator > (const T_SportsFlash_FlashEvent& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SportsFlash_FlashEvent::clear() {
    clearGameInfo();
    clearFlashEventID();
}

inline void T_SportsFlash_FlashEvent::clearGameInfo() {
    if (hasGameInfo()) {
         clear_has_GameInfo();
        _GameInfo.clear();
     }
}

inline bool T_SportsFlash_FlashEvent::hasGameInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_SportsFlash_Game& T_SportsFlash_FlashEvent::getGameInfo () const {
    return _GameInfo;
}

inline T_SportsFlash_Game& T_SportsFlash_FlashEvent::getGameInfoMutable () {
    set_has_GameInfo();
    return _GameInfo;
}

inline void T_SportsFlash_FlashEvent::setGameInfo (const T_SportsFlash_Game& GameInfo_) {
    set_has_GameInfo();
    this->_GameInfo = GameInfo_;
}

inline void T_SportsFlash_FlashEvent::clearFlashEventID() {
    if (hasFlashEventID()) {
         clear_has_FlashEventID();
        _FlashEventID = 0u;
     }
}

inline bool T_SportsFlash_FlashEvent::hasFlashEventID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_SportsFlash_FlashEvent::getFlashEventID () const {
    return _FlashEventID;
}

inline void T_SportsFlash_FlashEvent::setFlashEventID (uint32 FlashEventID_) {
    set_has_FlashEventID();
    this->_FlashEventID = FlashEventID_;
}

inline void T_SportsFlash_FlashEvent::set_has_GameInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SportsFlash_FlashEvent::clear_has_GameInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SportsFlash_FlashEvent::set_has_FlashEventID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SportsFlash_FlashEvent::clear_has_FlashEventID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SportsFlash_League::T_SportsFlash_League ()  :
    _SportType (::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport__SPORTS_UNKNOWN),
    _LeagueID (0u),
    _LeagueType (::sxm_audio_main_fi_types::T_e8_SportsFlash_League__LEAGUE_NFL),
    _LeagueAbbrName (),
    _LeagueFullName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SportsFlash_League::T_SportsFlash_League (const T_SportsFlash_League &rhs)  :
    _SportType (::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport__SPORTS_UNKNOWN),
    _LeagueID (0u),
    _LeagueType (::sxm_audio_main_fi_types::T_e8_SportsFlash_League__LEAGUE_NFL),
    _LeagueAbbrName (),
    _LeagueFullName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SportsFlash_League::T_SportsFlash_League (T_e8_SportsFlash_Sport SportType_, uint8 LeagueID_, T_e8_SportsFlash_League LeagueType_, const ::std::string& LeagueAbbrName_, const ::std::string& LeagueFullName_)  :
    _SportType (SportType_),
    _LeagueID (LeagueID_),
    _LeagueType (LeagueType_),
    _LeagueAbbrName (LeagueAbbrName_),
    _LeagueFullName (LeagueFullName_)
{
    #ifndef NDEBUG
    if (!(T_e8_SportsFlash_Sport_IsValid(SportType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SportType_, "T_e8_SportsFlash_Sport", "SportType", "T_SportsFlash_League");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SportsFlash_League_IsValid(LeagueType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", LeagueType_, "T_e8_SportsFlash_League", "LeagueType", "T_SportsFlash_League");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LeagueAbbrName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LeagueFullName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SportsFlash_League::~T_SportsFlash_League() {
}

inline T_SportsFlash_League& T_SportsFlash_League::operator = (const T_SportsFlash_League& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSportType()) {
            setSportType(rhs.getSportType());
        } else {
            clearSportType();
        }
        if (rhs.hasLeagueID()) {
            setLeagueID(rhs.getLeagueID());
        } else {
            clearLeagueID();
        }
        if (rhs.hasLeagueType()) {
            setLeagueType(rhs.getLeagueType());
        } else {
            clearLeagueType();
        }
        if (rhs.hasLeagueAbbrName()) {
            setLeagueAbbrName(rhs.getLeagueAbbrName());
        } else {
            clearLeagueAbbrName();
        }
        if (rhs.hasLeagueFullName()) {
            setLeagueFullName(rhs.getLeagueFullName());
        } else {
            clearLeagueFullName();
        }
    }
    return *this;
}

inline bool T_SportsFlash_League::operator == (const T_SportsFlash_League& rhs) const {
    return (((!hasSportType() && !rhs.hasSportType()) || getSportType() == rhs.getSportType()) &&
        ((!hasLeagueID() && !rhs.hasLeagueID()) || getLeagueID() == rhs.getLeagueID()) &&
        ((!hasLeagueType() && !rhs.hasLeagueType()) || getLeagueType() == rhs.getLeagueType()) &&
        ((!hasLeagueAbbrName() && !rhs.hasLeagueAbbrName()) || getLeagueAbbrName() == rhs.getLeagueAbbrName()) &&
        ((!hasLeagueFullName() && !rhs.hasLeagueFullName()) || getLeagueFullName() == rhs.getLeagueFullName()));
}

inline bool T_SportsFlash_League::operator != (const T_SportsFlash_League& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SportsFlash_League::operator < (const T_SportsFlash_League& rhs) const {
    if (hasSportType() || rhs.hasSportType()) {
        if ((uint32)getSportType() < (uint32)rhs.getSportType()) return true;
        if ((uint32)getSportType() > (uint32)rhs.getSportType()) return false;
    }
    if (hasLeagueID() || rhs.hasLeagueID()) {
        if (getLeagueID() < rhs.getLeagueID()) return true;
        if (getLeagueID() > rhs.getLeagueID()) return false;
    }
    if (hasLeagueType() || rhs.hasLeagueType()) {
        if ((uint32)getLeagueType() < (uint32)rhs.getLeagueType()) return true;
        if ((uint32)getLeagueType() > (uint32)rhs.getLeagueType()) return false;
    }
    if (hasLeagueAbbrName() || rhs.hasLeagueAbbrName()) {
        if (getLeagueAbbrName() < rhs.getLeagueAbbrName()) return true;
        if (getLeagueAbbrName() > rhs.getLeagueAbbrName()) return false;
    }
    if (hasLeagueFullName() || rhs.hasLeagueFullName()) {
        if (getLeagueFullName() < rhs.getLeagueFullName()) return true;
        if (getLeagueFullName() > rhs.getLeagueFullName()) return false;
    }
    return false;
}

inline bool T_SportsFlash_League::operator > (const T_SportsFlash_League& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SportsFlash_League::clear() {
    clearSportType();
    clearLeagueID();
    clearLeagueType();
    clearLeagueAbbrName();
    clearLeagueFullName();
}

inline void T_SportsFlash_League::clearSportType() {
    if (hasSportType()) {
         clear_has_SportType();
        _SportType = ::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport__SPORTS_UNKNOWN;
     }
}

inline bool T_SportsFlash_League::hasSportType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_SportsFlash_Sport T_SportsFlash_League::getSportType () const {
    return _SportType;
}

inline void T_SportsFlash_League::setSportType (T_e8_SportsFlash_Sport SportType_) {
    #ifndef NDEBUG
    if (!(T_e8_SportsFlash_Sport_IsValid(SportType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SportType_, "T_e8_SportsFlash_Sport", "SportType", "T_SportsFlash_League");
    }
    #endif
    set_has_SportType();
    this->_SportType = SportType_;
}

inline void T_SportsFlash_League::clearLeagueID() {
    if (hasLeagueID()) {
         clear_has_LeagueID();
        _LeagueID = 0u;
     }
}

inline bool T_SportsFlash_League::hasLeagueID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_SportsFlash_League::getLeagueID () const {
    return _LeagueID;
}

inline void T_SportsFlash_League::setLeagueID (uint8 LeagueID_) {
    set_has_LeagueID();
    this->_LeagueID = LeagueID_;
}

inline void T_SportsFlash_League::clearLeagueType() {
    if (hasLeagueType()) {
         clear_has_LeagueType();
        _LeagueType = ::sxm_audio_main_fi_types::T_e8_SportsFlash_League__LEAGUE_NFL;
     }
}

inline bool T_SportsFlash_League::hasLeagueType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_SportsFlash_League T_SportsFlash_League::getLeagueType () const {
    return _LeagueType;
}

inline void T_SportsFlash_League::setLeagueType (T_e8_SportsFlash_League LeagueType_) {
    #ifndef NDEBUG
    if (!(T_e8_SportsFlash_League_IsValid(LeagueType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", LeagueType_, "T_e8_SportsFlash_League", "LeagueType", "T_SportsFlash_League");
    }
    #endif
    set_has_LeagueType();
    this->_LeagueType = LeagueType_;
}

inline void T_SportsFlash_League::clearLeagueAbbrName() {
    if (hasLeagueAbbrName()) {
         clear_has_LeagueAbbrName();
        _LeagueAbbrName.clear();
     }
}

inline bool T_SportsFlash_League::hasLeagueAbbrName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_SportsFlash_League::getLeagueAbbrName () const {
    return _LeagueAbbrName;
}

inline ::std::string& T_SportsFlash_League::getLeagueAbbrNameMutable () {
    set_has_LeagueAbbrName();
    return _LeagueAbbrName;
}

inline void T_SportsFlash_League::setLeagueAbbrName (const ::std::string& LeagueAbbrName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LeagueAbbrName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LeagueAbbrName();
    this->_LeagueAbbrName = LeagueAbbrName_;
}

inline void T_SportsFlash_League::setLeagueAbbrName (const char* LeagueAbbrName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LeagueAbbrName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LeagueAbbrName();
    this->_LeagueAbbrName.assign(LeagueAbbrName_);
}

inline void T_SportsFlash_League::setLeagueAbbrName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LeagueAbbrName();
    this->_LeagueAbbrName.assign(value, size);
}

inline void T_SportsFlash_League::clearLeagueFullName() {
    if (hasLeagueFullName()) {
         clear_has_LeagueFullName();
        _LeagueFullName.clear();
     }
}

inline bool T_SportsFlash_League::hasLeagueFullName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_SportsFlash_League::getLeagueFullName () const {
    return _LeagueFullName;
}

inline ::std::string& T_SportsFlash_League::getLeagueFullNameMutable () {
    set_has_LeagueFullName();
    return _LeagueFullName;
}

inline void T_SportsFlash_League::setLeagueFullName (const ::std::string& LeagueFullName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LeagueFullName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LeagueFullName();
    this->_LeagueFullName = LeagueFullName_;
}

inline void T_SportsFlash_League::setLeagueFullName (const char* LeagueFullName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LeagueFullName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LeagueFullName();
    this->_LeagueFullName.assign(LeagueFullName_);
}

inline void T_SportsFlash_League::setLeagueFullName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LeagueFullName();
    this->_LeagueFullName.assign(value, size);
}

inline void T_SportsFlash_League::set_has_SportType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SportsFlash_League::clear_has_SportType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SportsFlash_League::set_has_LeagueID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SportsFlash_League::clear_has_LeagueID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SportsFlash_League::set_has_LeagueType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SportsFlash_League::clear_has_LeagueType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SportsFlash_League::set_has_LeagueAbbrName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SportsFlash_League::clear_has_LeagueAbbrName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SportsFlash_League::set_has_LeagueFullName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SportsFlash_League::clear_has_LeagueFullName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_SportsFlash_Team::T_SportsFlash_Team ()  :
    _TeamID (0u),
    _TeamName (),
    _TeamNickName (),
    _TeamAbbrName (),
    _TeamFullName (),
    _IsFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SportsFlash_Team::T_SportsFlash_Team (const T_SportsFlash_Team &rhs)  :
    _TeamID (0u),
    _TeamName (),
    _TeamNickName (),
    _TeamAbbrName (),
    _TeamFullName (),
    _IsFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SportsFlash_Team::T_SportsFlash_Team (uint16 TeamID_, const ::std::string& TeamName_, const ::std::string& TeamNickName_, const ::std::string& TeamAbbrName_, const ::std::string& TeamFullName_, bool IsFavorite_)  :
    _TeamID (TeamID_),
    _TeamName (TeamName_),
    _TeamNickName (TeamNickName_),
    _TeamAbbrName (TeamAbbrName_),
    _TeamFullName (TeamFullName_),
    _IsFavorite (IsFavorite_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamNickName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamAbbrName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamFullName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SportsFlash_Team::~T_SportsFlash_Team() {
}

inline T_SportsFlash_Team& T_SportsFlash_Team::operator = (const T_SportsFlash_Team& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTeamID()) {
            setTeamID(rhs.getTeamID());
        } else {
            clearTeamID();
        }
        if (rhs.hasTeamName()) {
            setTeamName(rhs.getTeamName());
        } else {
            clearTeamName();
        }
        if (rhs.hasTeamNickName()) {
            setTeamNickName(rhs.getTeamNickName());
        } else {
            clearTeamNickName();
        }
        if (rhs.hasTeamAbbrName()) {
            setTeamAbbrName(rhs.getTeamAbbrName());
        } else {
            clearTeamAbbrName();
        }
        if (rhs.hasTeamFullName()) {
            setTeamFullName(rhs.getTeamFullName());
        } else {
            clearTeamFullName();
        }
        if (rhs.hasIsFavorite()) {
            setIsFavorite(rhs.getIsFavorite());
        } else {
            clearIsFavorite();
        }
    }
    return *this;
}

inline bool T_SportsFlash_Team::operator == (const T_SportsFlash_Team& rhs) const {
    return (((!hasTeamID() && !rhs.hasTeamID()) || getTeamID() == rhs.getTeamID()) &&
        ((!hasTeamName() && !rhs.hasTeamName()) || getTeamName() == rhs.getTeamName()) &&
        ((!hasTeamNickName() && !rhs.hasTeamNickName()) || getTeamNickName() == rhs.getTeamNickName()) &&
        ((!hasTeamAbbrName() && !rhs.hasTeamAbbrName()) || getTeamAbbrName() == rhs.getTeamAbbrName()) &&
        ((!hasTeamFullName() && !rhs.hasTeamFullName()) || getTeamFullName() == rhs.getTeamFullName()) &&
        ((!hasIsFavorite() && !rhs.hasIsFavorite()) || getIsFavorite() == rhs.getIsFavorite()));
}

inline bool T_SportsFlash_Team::operator != (const T_SportsFlash_Team& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SportsFlash_Team::operator < (const T_SportsFlash_Team& rhs) const {
    if (hasTeamID() || rhs.hasTeamID()) {
        if (getTeamID() < rhs.getTeamID()) return true;
        if (getTeamID() > rhs.getTeamID()) return false;
    }
    if (hasTeamName() || rhs.hasTeamName()) {
        if (getTeamName() < rhs.getTeamName()) return true;
        if (getTeamName() > rhs.getTeamName()) return false;
    }
    if (hasTeamNickName() || rhs.hasTeamNickName()) {
        if (getTeamNickName() < rhs.getTeamNickName()) return true;
        if (getTeamNickName() > rhs.getTeamNickName()) return false;
    }
    if (hasTeamAbbrName() || rhs.hasTeamAbbrName()) {
        if (getTeamAbbrName() < rhs.getTeamAbbrName()) return true;
        if (getTeamAbbrName() > rhs.getTeamAbbrName()) return false;
    }
    if (hasTeamFullName() || rhs.hasTeamFullName()) {
        if (getTeamFullName() < rhs.getTeamFullName()) return true;
        if (getTeamFullName() > rhs.getTeamFullName()) return false;
    }
    if (hasIsFavorite() || rhs.hasIsFavorite()) {
        if (getIsFavorite() < rhs.getIsFavorite()) return true;
        if (getIsFavorite() > rhs.getIsFavorite()) return false;
    }
    return false;
}

inline bool T_SportsFlash_Team::operator > (const T_SportsFlash_Team& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SportsFlash_Team::clear() {
    clearTeamID();
    clearTeamName();
    clearTeamNickName();
    clearTeamAbbrName();
    clearTeamFullName();
    clearIsFavorite();
}

inline void T_SportsFlash_Team::clearTeamID() {
    if (hasTeamID()) {
         clear_has_TeamID();
        _TeamID = 0u;
     }
}

inline bool T_SportsFlash_Team::hasTeamID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_SportsFlash_Team::getTeamID () const {
    return _TeamID;
}

inline void T_SportsFlash_Team::setTeamID (uint16 TeamID_) {
    set_has_TeamID();
    this->_TeamID = TeamID_;
}

inline void T_SportsFlash_Team::clearTeamName() {
    if (hasTeamName()) {
         clear_has_TeamName();
        _TeamName.clear();
     }
}

inline bool T_SportsFlash_Team::hasTeamName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SportsFlash_Team::getTeamName () const {
    return _TeamName;
}

inline ::std::string& T_SportsFlash_Team::getTeamNameMutable () {
    set_has_TeamName();
    return _TeamName;
}

inline void T_SportsFlash_Team::setTeamName (const ::std::string& TeamName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamName();
    this->_TeamName = TeamName_;
}

inline void T_SportsFlash_Team::setTeamName (const char* TeamName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamName();
    this->_TeamName.assign(TeamName_);
}

inline void T_SportsFlash_Team::setTeamName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamName();
    this->_TeamName.assign(value, size);
}

inline void T_SportsFlash_Team::clearTeamNickName() {
    if (hasTeamNickName()) {
         clear_has_TeamNickName();
        _TeamNickName.clear();
     }
}

inline bool T_SportsFlash_Team::hasTeamNickName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_SportsFlash_Team::getTeamNickName () const {
    return _TeamNickName;
}

inline ::std::string& T_SportsFlash_Team::getTeamNickNameMutable () {
    set_has_TeamNickName();
    return _TeamNickName;
}

inline void T_SportsFlash_Team::setTeamNickName (const ::std::string& TeamNickName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamNickName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamNickName();
    this->_TeamNickName = TeamNickName_;
}

inline void T_SportsFlash_Team::setTeamNickName (const char* TeamNickName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamNickName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamNickName();
    this->_TeamNickName.assign(TeamNickName_);
}

inline void T_SportsFlash_Team::setTeamNickName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamNickName();
    this->_TeamNickName.assign(value, size);
}

inline void T_SportsFlash_Team::clearTeamAbbrName() {
    if (hasTeamAbbrName()) {
         clear_has_TeamAbbrName();
        _TeamAbbrName.clear();
     }
}

inline bool T_SportsFlash_Team::hasTeamAbbrName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_SportsFlash_Team::getTeamAbbrName () const {
    return _TeamAbbrName;
}

inline ::std::string& T_SportsFlash_Team::getTeamAbbrNameMutable () {
    set_has_TeamAbbrName();
    return _TeamAbbrName;
}

inline void T_SportsFlash_Team::setTeamAbbrName (const ::std::string& TeamAbbrName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamAbbrName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamAbbrName();
    this->_TeamAbbrName = TeamAbbrName_;
}

inline void T_SportsFlash_Team::setTeamAbbrName (const char* TeamAbbrName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamAbbrName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamAbbrName();
    this->_TeamAbbrName.assign(TeamAbbrName_);
}

inline void T_SportsFlash_Team::setTeamAbbrName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamAbbrName();
    this->_TeamAbbrName.assign(value, size);
}

inline void T_SportsFlash_Team::clearTeamFullName() {
    if (hasTeamFullName()) {
         clear_has_TeamFullName();
        _TeamFullName.clear();
     }
}

inline bool T_SportsFlash_Team::hasTeamFullName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_SportsFlash_Team::getTeamFullName () const {
    return _TeamFullName;
}

inline ::std::string& T_SportsFlash_Team::getTeamFullNameMutable () {
    set_has_TeamFullName();
    return _TeamFullName;
}

inline void T_SportsFlash_Team::setTeamFullName (const ::std::string& TeamFullName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamFullName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamFullName();
    this->_TeamFullName = TeamFullName_;
}

inline void T_SportsFlash_Team::setTeamFullName (const char* TeamFullName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TeamFullName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamFullName();
    this->_TeamFullName.assign(TeamFullName_);
}

inline void T_SportsFlash_Team::setTeamFullName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TeamFullName();
    this->_TeamFullName.assign(value, size);
}

inline void T_SportsFlash_Team::clearIsFavorite() {
    if (hasIsFavorite()) {
         clear_has_IsFavorite();
        _IsFavorite = false;
     }
}

inline bool T_SportsFlash_Team::hasIsFavorite () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool T_SportsFlash_Team::getIsFavorite () const {
    return _IsFavorite;
}

inline void T_SportsFlash_Team::setIsFavorite (bool IsFavorite_) {
    set_has_IsFavorite();
    this->_IsFavorite = IsFavorite_;
}

inline void T_SportsFlash_Team::set_has_TeamID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SportsFlash_Team::clear_has_TeamID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SportsFlash_Team::set_has_TeamName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SportsFlash_Team::clear_has_TeamName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SportsFlash_Team::set_has_TeamNickName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SportsFlash_Team::clear_has_TeamNickName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SportsFlash_Team::set_has_TeamAbbrName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SportsFlash_Team::clear_has_TeamAbbrName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SportsFlash_Team::set_has_TeamFullName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SportsFlash_Team::clear_has_TeamFullName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SportsFlash_Team::set_has_IsFavorite () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SportsFlash_Team::clear_has_IsFavorite () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_SportsFlash_MonitorTeam::T_SportsFlash_MonitorTeam ()  :
    _LeagueID (0u),
    _TeamID (0u),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SportsFlash_MonitorTeam::T_SportsFlash_MonitorTeam (const T_SportsFlash_MonitorTeam &rhs)  :
    _LeagueID (0u),
    _TeamID (0u),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SportsFlash_MonitorTeam::T_SportsFlash_MonitorTeam (uint8 LeagueID_, uint16 TeamID_, bool Status_)  :
    _LeagueID (LeagueID_),
    _TeamID (TeamID_),
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SportsFlash_MonitorTeam::~T_SportsFlash_MonitorTeam() {
}

inline T_SportsFlash_MonitorTeam& T_SportsFlash_MonitorTeam::operator = (const T_SportsFlash_MonitorTeam& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLeagueID()) {
            setLeagueID(rhs.getLeagueID());
        } else {
            clearLeagueID();
        }
        if (rhs.hasTeamID()) {
            setTeamID(rhs.getTeamID());
        } else {
            clearTeamID();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool T_SportsFlash_MonitorTeam::operator == (const T_SportsFlash_MonitorTeam& rhs) const {
    return (((!hasLeagueID() && !rhs.hasLeagueID()) || getLeagueID() == rhs.getLeagueID()) &&
        ((!hasTeamID() && !rhs.hasTeamID()) || getTeamID() == rhs.getTeamID()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool T_SportsFlash_MonitorTeam::operator != (const T_SportsFlash_MonitorTeam& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SportsFlash_MonitorTeam::operator < (const T_SportsFlash_MonitorTeam& rhs) const {
    if (hasLeagueID() || rhs.hasLeagueID()) {
        if (getLeagueID() < rhs.getLeagueID()) return true;
        if (getLeagueID() > rhs.getLeagueID()) return false;
    }
    if (hasTeamID() || rhs.hasTeamID()) {
        if (getTeamID() < rhs.getTeamID()) return true;
        if (getTeamID() > rhs.getTeamID()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline bool T_SportsFlash_MonitorTeam::operator > (const T_SportsFlash_MonitorTeam& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SportsFlash_MonitorTeam::clear() {
    clearLeagueID();
    clearTeamID();
    clearStatus();
}

inline void T_SportsFlash_MonitorTeam::clearLeagueID() {
    if (hasLeagueID()) {
         clear_has_LeagueID();
        _LeagueID = 0u;
     }
}

inline bool T_SportsFlash_MonitorTeam::hasLeagueID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SportsFlash_MonitorTeam::getLeagueID () const {
    return _LeagueID;
}

inline void T_SportsFlash_MonitorTeam::setLeagueID (uint8 LeagueID_) {
    set_has_LeagueID();
    this->_LeagueID = LeagueID_;
}

inline void T_SportsFlash_MonitorTeam::clearTeamID() {
    if (hasTeamID()) {
         clear_has_TeamID();
        _TeamID = 0u;
     }
}

inline bool T_SportsFlash_MonitorTeam::hasTeamID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_SportsFlash_MonitorTeam::getTeamID () const {
    return _TeamID;
}

inline void T_SportsFlash_MonitorTeam::setTeamID (uint16 TeamID_) {
    set_has_TeamID();
    this->_TeamID = TeamID_;
}

inline void T_SportsFlash_MonitorTeam::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool T_SportsFlash_MonitorTeam::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_SportsFlash_MonitorTeam::getStatus () const {
    return _Status;
}

inline void T_SportsFlash_MonitorTeam::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void T_SportsFlash_MonitorTeam::set_has_LeagueID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SportsFlash_MonitorTeam::clear_has_LeagueID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SportsFlash_MonitorTeam::set_has_TeamID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SportsFlash_MonitorTeam::clear_has_TeamID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SportsFlash_MonitorTeam::set_has_Status () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SportsFlash_MonitorTeam::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_BrowseRateConfiguration::T_BrowseRateConfiguration ()  :
    _duration (0u),
    _rate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BrowseRateConfiguration::T_BrowseRateConfiguration (const T_BrowseRateConfiguration &rhs)  :
    _duration (0u),
    _rate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BrowseRateConfiguration::T_BrowseRateConfiguration (uint16 duration_, uint16 rate_)  :
    _duration (duration_),
    _rate (rate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BrowseRateConfiguration::~T_BrowseRateConfiguration() {
}

inline T_BrowseRateConfiguration& T_BrowseRateConfiguration::operator = (const T_BrowseRateConfiguration& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDuration()) {
            setDuration(rhs.getDuration());
        } else {
            clearDuration();
        }
        if (rhs.hasRate()) {
            setRate(rhs.getRate());
        } else {
            clearRate();
        }
    }
    return *this;
}

inline bool T_BrowseRateConfiguration::operator == (const T_BrowseRateConfiguration& rhs) const {
    return (((!hasDuration() && !rhs.hasDuration()) || getDuration() == rhs.getDuration()) &&
        ((!hasRate() && !rhs.hasRate()) || getRate() == rhs.getRate()));
}

inline bool T_BrowseRateConfiguration::operator != (const T_BrowseRateConfiguration& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BrowseRateConfiguration::operator < (const T_BrowseRateConfiguration& rhs) const {
    if (hasDuration() || rhs.hasDuration()) {
        if (getDuration() < rhs.getDuration()) return true;
        if (getDuration() > rhs.getDuration()) return false;
    }
    if (hasRate() || rhs.hasRate()) {
        if (getRate() < rhs.getRate()) return true;
        if (getRate() > rhs.getRate()) return false;
    }
    return false;
}

inline bool T_BrowseRateConfiguration::operator > (const T_BrowseRateConfiguration& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BrowseRateConfiguration::clear() {
    clearDuration();
    clearRate();
}

inline void T_BrowseRateConfiguration::clearDuration() {
    if (hasDuration()) {
         clear_has_duration();
        _duration = 0u;
     }
}

inline bool T_BrowseRateConfiguration::hasDuration () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_BrowseRateConfiguration::getDuration () const {
    return _duration;
}

inline void T_BrowseRateConfiguration::setDuration (uint16 duration_) {
    set_has_duration();
    this->_duration = duration_;
}

inline void T_BrowseRateConfiguration::clearRate() {
    if (hasRate()) {
         clear_has_rate();
        _rate = 0u;
     }
}

inline bool T_BrowseRateConfiguration::hasRate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_BrowseRateConfiguration::getRate () const {
    return _rate;
}

inline void T_BrowseRateConfiguration::setRate (uint16 rate_) {
    set_has_rate();
    this->_rate = rate_;
}

inline void T_BrowseRateConfiguration::set_has_duration () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BrowseRateConfiguration::clear_has_duration () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BrowseRateConfiguration::set_has_rate () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BrowseRateConfiguration::clear_has_rate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_BrowseChannelConfig::T_BrowseChannelConfig ()  :
    _Configuration (),
    _Loop (::sxm_audio_main_fi_types::T_e8_BrowseChannelLoop__LOOP_AROUND),
    _Type (::sxm_audio_main_fi_types::T_e8_BrowseChannelType__BROWSETYPE_ALL_CHANNELS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BrowseChannelConfig::T_BrowseChannelConfig (const T_BrowseChannelConfig &rhs)  :
    _Configuration (),
    _Loop (::sxm_audio_main_fi_types::T_e8_BrowseChannelLoop__LOOP_AROUND),
    _Type (::sxm_audio_main_fi_types::T_e8_BrowseChannelType__BROWSETYPE_ALL_CHANNELS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BrowseChannelConfig::T_BrowseChannelConfig (const ::std::vector< T_BrowseRateConfiguration >& Configuration_, T_e8_BrowseChannelLoop Loop_, T_e8_BrowseChannelType Type_)  :
    _Configuration (Configuration_),
    _Loop (Loop_),
    _Type (Type_)
{
    #ifndef NDEBUG
    if (!(T_e8_BrowseChannelLoop_IsValid(Loop_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Loop_, "T_e8_BrowseChannelLoop", "Loop", "T_BrowseChannelConfig");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BrowseChannelType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_BrowseChannelType", "Type", "T_BrowseChannelConfig");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BrowseChannelConfig::~T_BrowseChannelConfig() {
}

inline T_BrowseChannelConfig& T_BrowseChannelConfig::operator = (const T_BrowseChannelConfig& rhs) {
    if( this != &rhs ) {
        if (rhs.hasConfiguration()) {
            setConfiguration(rhs.getConfiguration());
        } else {
            clearConfiguration();
        }
        if (rhs.hasLoop()) {
            setLoop(rhs.getLoop());
        } else {
            clearLoop();
        }
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
    }
    return *this;
}

inline bool T_BrowseChannelConfig::operator == (const T_BrowseChannelConfig& rhs) const {
    return (((!hasConfiguration() && !rhs.hasConfiguration()) || getConfiguration() == rhs.getConfiguration()) &&
        ((!hasLoop() && !rhs.hasLoop()) || getLoop() == rhs.getLoop()) &&
        ((!hasType() && !rhs.hasType()) || getType() == rhs.getType()));
}

inline bool T_BrowseChannelConfig::operator != (const T_BrowseChannelConfig& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BrowseChannelConfig::operator < (const T_BrowseChannelConfig& rhs) const {
    if (hasConfiguration() || rhs.hasConfiguration()) {
        if (getConfiguration() < rhs.getConfiguration()) return true;
        if (getConfiguration() > rhs.getConfiguration()) return false;
    }
    if (hasLoop() || rhs.hasLoop()) {
        if ((uint32)getLoop() < (uint32)rhs.getLoop()) return true;
        if ((uint32)getLoop() > (uint32)rhs.getLoop()) return false;
    }
    if (hasType() || rhs.hasType()) {
        if ((uint32)getType() < (uint32)rhs.getType()) return true;
        if ((uint32)getType() > (uint32)rhs.getType()) return false;
    }
    return false;
}

inline bool T_BrowseChannelConfig::operator > (const T_BrowseChannelConfig& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BrowseChannelConfig::clear() {
    clearConfiguration();
    clearLoop();
    clearType();
}

inline void T_BrowseChannelConfig::clearConfiguration() {
    if (hasConfiguration()) {
         clear_has_Configuration();
        _Configuration.clear();
     }
}

inline bool T_BrowseChannelConfig::hasConfiguration () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< T_BrowseRateConfiguration >& T_BrowseChannelConfig::getConfiguration () const {
    return _Configuration;
}

inline ::std::vector< T_BrowseRateConfiguration >& T_BrowseChannelConfig::getConfigurationMutable () {
    set_has_Configuration();
    return _Configuration;
}

inline void T_BrowseChannelConfig::setConfiguration (const ::std::vector< T_BrowseRateConfiguration >& Configuration_) {
    set_has_Configuration();
    this->_Configuration = Configuration_;
}

inline void T_BrowseChannelConfig::clearLoop() {
    if (hasLoop()) {
         clear_has_Loop();
        _Loop = ::sxm_audio_main_fi_types::T_e8_BrowseChannelLoop__LOOP_AROUND;
     }
}

inline bool T_BrowseChannelConfig::hasLoop () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_BrowseChannelLoop T_BrowseChannelConfig::getLoop () const {
    return _Loop;
}

inline void T_BrowseChannelConfig::setLoop (T_e8_BrowseChannelLoop Loop_) {
    #ifndef NDEBUG
    if (!(T_e8_BrowseChannelLoop_IsValid(Loop_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Loop_, "T_e8_BrowseChannelLoop", "Loop", "T_BrowseChannelConfig");
    }
    #endif
    set_has_Loop();
    this->_Loop = Loop_;
}

inline void T_BrowseChannelConfig::clearType() {
    if (hasType()) {
         clear_has_Type();
        _Type = ::sxm_audio_main_fi_types::T_e8_BrowseChannelType__BROWSETYPE_ALL_CHANNELS;
     }
}

inline bool T_BrowseChannelConfig::hasType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_BrowseChannelType T_BrowseChannelConfig::getType () const {
    return _Type;
}

inline void T_BrowseChannelConfig::setType (T_e8_BrowseChannelType Type_) {
    #ifndef NDEBUG
    if (!(T_e8_BrowseChannelType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_BrowseChannelType", "Type", "T_BrowseChannelConfig");
    }
    #endif
    set_has_Type();
    this->_Type = Type_;
}

inline void T_BrowseChannelConfig::set_has_Configuration () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BrowseChannelConfig::clear_has_Configuration () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BrowseChannelConfig::set_has_Loop () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BrowseChannelConfig::clear_has_Loop () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BrowseChannelConfig::set_has_Type () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BrowseChannelConfig::clear_has_Type () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_b16_CHANNEL_EVENT::T_b16_CHANNEL_EVENT ()  :
    _CHANNEL_EVENT_SERVICE_ID (false),
    _CHANNEL_EVENT_CHANNEL_ID (false),
    _CHANNEL_EVENT_ATTRIBUTES (false),
    _CHANNEL_EVENT_NAME (false),
    _CHANNEL_EVENT_CATEGORY (false),
    _CHANNEL_EVENT_TITLE (false),
    _CHANNEL_EVENT_ARTIST (false),
    _CHANNEL_EVENT_ALBUM (false),
    _CHANNEL_EVENT_ART (false),
    _CHANNEL_EVENT_REMOVED (false),
    _CHANNEL_EVENT_b10_reserved (false),
    _CHANNEL_EVENT_b11_reserved (false),
    _CHANNEL_EVENT_b12_reserved (false),
    _CHANNEL_EVENT_b13_reserved (false),
    _CHANNEL_EVENT_b14_reserved (false),
    _CHANNEL_EVENT_b15_reserved (false)
{
}

inline  T_b16_CHANNEL_EVENT::T_b16_CHANNEL_EVENT (const T_b16_CHANNEL_EVENT &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b16_CHANNEL_EVENT::T_b16_CHANNEL_EVENT (bool CHANNEL_EVENT_SERVICE_ID, bool CHANNEL_EVENT_CHANNEL_ID, bool CHANNEL_EVENT_ATTRIBUTES, bool CHANNEL_EVENT_NAME, bool CHANNEL_EVENT_CATEGORY, bool CHANNEL_EVENT_TITLE, bool CHANNEL_EVENT_ARTIST, bool CHANNEL_EVENT_ALBUM, bool CHANNEL_EVENT_ART, bool CHANNEL_EVENT_REMOVED, bool CHANNEL_EVENT_b10_reserved, bool CHANNEL_EVENT_b11_reserved, bool CHANNEL_EVENT_b12_reserved, bool CHANNEL_EVENT_b13_reserved, bool CHANNEL_EVENT_b14_reserved, bool CHANNEL_EVENT_b15_reserved) :
    _CHANNEL_EVENT_SERVICE_ID (CHANNEL_EVENT_SERVICE_ID),
    _CHANNEL_EVENT_CHANNEL_ID (CHANNEL_EVENT_CHANNEL_ID),
    _CHANNEL_EVENT_ATTRIBUTES (CHANNEL_EVENT_ATTRIBUTES),
    _CHANNEL_EVENT_NAME (CHANNEL_EVENT_NAME),
    _CHANNEL_EVENT_CATEGORY (CHANNEL_EVENT_CATEGORY),
    _CHANNEL_EVENT_TITLE (CHANNEL_EVENT_TITLE),
    _CHANNEL_EVENT_ARTIST (CHANNEL_EVENT_ARTIST),
    _CHANNEL_EVENT_ALBUM (CHANNEL_EVENT_ALBUM),
    _CHANNEL_EVENT_ART (CHANNEL_EVENT_ART),
    _CHANNEL_EVENT_REMOVED (CHANNEL_EVENT_REMOVED),
    _CHANNEL_EVENT_b10_reserved (CHANNEL_EVENT_b10_reserved),
    _CHANNEL_EVENT_b11_reserved (CHANNEL_EVENT_b11_reserved),
    _CHANNEL_EVENT_b12_reserved (CHANNEL_EVENT_b12_reserved),
    _CHANNEL_EVENT_b13_reserved (CHANNEL_EVENT_b13_reserved),
    _CHANNEL_EVENT_b14_reserved (CHANNEL_EVENT_b14_reserved),
    _CHANNEL_EVENT_b15_reserved (CHANNEL_EVENT_b15_reserved)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b16_CHANNEL_EVENT& T_b16_CHANNEL_EVENT::operator = (const T_b16_CHANNEL_EVENT& rhs) {
    if( this != &rhs ) {
        _CHANNEL_EVENT_SERVICE_ID = rhs._CHANNEL_EVENT_SERVICE_ID;
        _CHANNEL_EVENT_CHANNEL_ID = rhs._CHANNEL_EVENT_CHANNEL_ID;
        _CHANNEL_EVENT_ATTRIBUTES = rhs._CHANNEL_EVENT_ATTRIBUTES;
        _CHANNEL_EVENT_NAME = rhs._CHANNEL_EVENT_NAME;
        _CHANNEL_EVENT_CATEGORY = rhs._CHANNEL_EVENT_CATEGORY;
        _CHANNEL_EVENT_TITLE = rhs._CHANNEL_EVENT_TITLE;
        _CHANNEL_EVENT_ARTIST = rhs._CHANNEL_EVENT_ARTIST;
        _CHANNEL_EVENT_ALBUM = rhs._CHANNEL_EVENT_ALBUM;
        _CHANNEL_EVENT_ART = rhs._CHANNEL_EVENT_ART;
        _CHANNEL_EVENT_REMOVED = rhs._CHANNEL_EVENT_REMOVED;
        _CHANNEL_EVENT_b10_reserved = rhs._CHANNEL_EVENT_b10_reserved;
        _CHANNEL_EVENT_b11_reserved = rhs._CHANNEL_EVENT_b11_reserved;
        _CHANNEL_EVENT_b12_reserved = rhs._CHANNEL_EVENT_b12_reserved;
        _CHANNEL_EVENT_b13_reserved = rhs._CHANNEL_EVENT_b13_reserved;
        _CHANNEL_EVENT_b14_reserved = rhs._CHANNEL_EVENT_b14_reserved;
        _CHANNEL_EVENT_b15_reserved = rhs._CHANNEL_EVENT_b15_reserved;
    }
    return *this;
}

inline bool T_b16_CHANNEL_EVENT::operator == (const T_b16_CHANNEL_EVENT& rhs) const {
    return (_CHANNEL_EVENT_SERVICE_ID == rhs._CHANNEL_EVENT_SERVICE_ID &&
        _CHANNEL_EVENT_CHANNEL_ID == rhs._CHANNEL_EVENT_CHANNEL_ID &&
        _CHANNEL_EVENT_ATTRIBUTES == rhs._CHANNEL_EVENT_ATTRIBUTES &&
        _CHANNEL_EVENT_NAME == rhs._CHANNEL_EVENT_NAME &&
        _CHANNEL_EVENT_CATEGORY == rhs._CHANNEL_EVENT_CATEGORY &&
        _CHANNEL_EVENT_TITLE == rhs._CHANNEL_EVENT_TITLE &&
        _CHANNEL_EVENT_ARTIST == rhs._CHANNEL_EVENT_ARTIST &&
        _CHANNEL_EVENT_ALBUM == rhs._CHANNEL_EVENT_ALBUM &&
        _CHANNEL_EVENT_ART == rhs._CHANNEL_EVENT_ART &&
        _CHANNEL_EVENT_REMOVED == rhs._CHANNEL_EVENT_REMOVED &&
        _CHANNEL_EVENT_b10_reserved == rhs._CHANNEL_EVENT_b10_reserved &&
        _CHANNEL_EVENT_b11_reserved == rhs._CHANNEL_EVENT_b11_reserved &&
        _CHANNEL_EVENT_b12_reserved == rhs._CHANNEL_EVENT_b12_reserved &&
        _CHANNEL_EVENT_b13_reserved == rhs._CHANNEL_EVENT_b13_reserved &&
        _CHANNEL_EVENT_b14_reserved == rhs._CHANNEL_EVENT_b14_reserved &&
        _CHANNEL_EVENT_b15_reserved == rhs._CHANNEL_EVENT_b15_reserved);
}

inline bool T_b16_CHANNEL_EVENT::operator != (const T_b16_CHANNEL_EVENT& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b16_CHANNEL_EVENT::operator < (const T_b16_CHANNEL_EVENT& rhs) const {
    if (getCHANNEL_EVENT_SERVICE_ID() < rhs.getCHANNEL_EVENT_SERVICE_ID()) return true;
    if (getCHANNEL_EVENT_SERVICE_ID() > rhs.getCHANNEL_EVENT_SERVICE_ID()) return false;

    if (getCHANNEL_EVENT_CHANNEL_ID() < rhs.getCHANNEL_EVENT_CHANNEL_ID()) return true;
    if (getCHANNEL_EVENT_CHANNEL_ID() > rhs.getCHANNEL_EVENT_CHANNEL_ID()) return false;

    if (getCHANNEL_EVENT_ATTRIBUTES() < rhs.getCHANNEL_EVENT_ATTRIBUTES()) return true;
    if (getCHANNEL_EVENT_ATTRIBUTES() > rhs.getCHANNEL_EVENT_ATTRIBUTES()) return false;

    if (getCHANNEL_EVENT_NAME() < rhs.getCHANNEL_EVENT_NAME()) return true;
    if (getCHANNEL_EVENT_NAME() > rhs.getCHANNEL_EVENT_NAME()) return false;

    if (getCHANNEL_EVENT_CATEGORY() < rhs.getCHANNEL_EVENT_CATEGORY()) return true;
    if (getCHANNEL_EVENT_CATEGORY() > rhs.getCHANNEL_EVENT_CATEGORY()) return false;

    if (getCHANNEL_EVENT_TITLE() < rhs.getCHANNEL_EVENT_TITLE()) return true;
    if (getCHANNEL_EVENT_TITLE() > rhs.getCHANNEL_EVENT_TITLE()) return false;

    if (getCHANNEL_EVENT_ARTIST() < rhs.getCHANNEL_EVENT_ARTIST()) return true;
    if (getCHANNEL_EVENT_ARTIST() > rhs.getCHANNEL_EVENT_ARTIST()) return false;

    if (getCHANNEL_EVENT_ALBUM() < rhs.getCHANNEL_EVENT_ALBUM()) return true;
    if (getCHANNEL_EVENT_ALBUM() > rhs.getCHANNEL_EVENT_ALBUM()) return false;

    if (getCHANNEL_EVENT_ART() < rhs.getCHANNEL_EVENT_ART()) return true;
    if (getCHANNEL_EVENT_ART() > rhs.getCHANNEL_EVENT_ART()) return false;

    if (getCHANNEL_EVENT_REMOVED() < rhs.getCHANNEL_EVENT_REMOVED()) return true;
    if (getCHANNEL_EVENT_REMOVED() > rhs.getCHANNEL_EVENT_REMOVED()) return false;

    if (getCHANNEL_EVENT_b10_reserved() < rhs.getCHANNEL_EVENT_b10_reserved()) return true;
    if (getCHANNEL_EVENT_b10_reserved() > rhs.getCHANNEL_EVENT_b10_reserved()) return false;

    if (getCHANNEL_EVENT_b11_reserved() < rhs.getCHANNEL_EVENT_b11_reserved()) return true;
    if (getCHANNEL_EVENT_b11_reserved() > rhs.getCHANNEL_EVENT_b11_reserved()) return false;

    if (getCHANNEL_EVENT_b12_reserved() < rhs.getCHANNEL_EVENT_b12_reserved()) return true;
    if (getCHANNEL_EVENT_b12_reserved() > rhs.getCHANNEL_EVENT_b12_reserved()) return false;

    if (getCHANNEL_EVENT_b13_reserved() < rhs.getCHANNEL_EVENT_b13_reserved()) return true;
    if (getCHANNEL_EVENT_b13_reserved() > rhs.getCHANNEL_EVENT_b13_reserved()) return false;

    if (getCHANNEL_EVENT_b14_reserved() < rhs.getCHANNEL_EVENT_b14_reserved()) return true;
    if (getCHANNEL_EVENT_b14_reserved() > rhs.getCHANNEL_EVENT_b14_reserved()) return false;

    if (getCHANNEL_EVENT_b15_reserved() < rhs.getCHANNEL_EVENT_b15_reserved()) return true;
    if (getCHANNEL_EVENT_b15_reserved() > rhs.getCHANNEL_EVENT_b15_reserved()) return false;

    return false;
}

inline bool T_b16_CHANNEL_EVENT::operator > (const T_b16_CHANNEL_EVENT& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_SERVICE_ID (bool CHANNEL_EVENT_SERVICE_ID) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_SERVICE_ID = CHANNEL_EVENT_SERVICE_ID;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_SERVICE_ID () const {
    return _CHANNEL_EVENT_SERVICE_ID;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_CHANNEL_ID (bool CHANNEL_EVENT_CHANNEL_ID) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_CHANNEL_ID = CHANNEL_EVENT_CHANNEL_ID;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_CHANNEL_ID () const {
    return _CHANNEL_EVENT_CHANNEL_ID;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_ATTRIBUTES (bool CHANNEL_EVENT_ATTRIBUTES) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_ATTRIBUTES = CHANNEL_EVENT_ATTRIBUTES;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_ATTRIBUTES () const {
    return _CHANNEL_EVENT_ATTRIBUTES;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_NAME (bool CHANNEL_EVENT_NAME) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_NAME = CHANNEL_EVENT_NAME;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_NAME () const {
    return _CHANNEL_EVENT_NAME;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_CATEGORY (bool CHANNEL_EVENT_CATEGORY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_CATEGORY = CHANNEL_EVENT_CATEGORY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_CATEGORY () const {
    return _CHANNEL_EVENT_CATEGORY;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_TITLE (bool CHANNEL_EVENT_TITLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_TITLE = CHANNEL_EVENT_TITLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_TITLE () const {
    return _CHANNEL_EVENT_TITLE;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_ARTIST (bool CHANNEL_EVENT_ARTIST) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_ARTIST = CHANNEL_EVENT_ARTIST;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_ARTIST () const {
    return _CHANNEL_EVENT_ARTIST;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_ALBUM (bool CHANNEL_EVENT_ALBUM) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_ALBUM = CHANNEL_EVENT_ALBUM;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_ALBUM () const {
    return _CHANNEL_EVENT_ALBUM;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_ART (bool CHANNEL_EVENT_ART) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_ART = CHANNEL_EVENT_ART;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_ART () const {
    return _CHANNEL_EVENT_ART;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_REMOVED (bool CHANNEL_EVENT_REMOVED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_REMOVED = CHANNEL_EVENT_REMOVED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_REMOVED () const {
    return _CHANNEL_EVENT_REMOVED;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_b10_reserved (bool CHANNEL_EVENT_b10_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_b10_reserved = CHANNEL_EVENT_b10_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_b10_reserved () const {
    return _CHANNEL_EVENT_b10_reserved;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_b11_reserved (bool CHANNEL_EVENT_b11_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_b11_reserved = CHANNEL_EVENT_b11_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_b11_reserved () const {
    return _CHANNEL_EVENT_b11_reserved;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_b12_reserved (bool CHANNEL_EVENT_b12_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_b12_reserved = CHANNEL_EVENT_b12_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_b12_reserved () const {
    return _CHANNEL_EVENT_b12_reserved;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_b13_reserved (bool CHANNEL_EVENT_b13_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_b13_reserved = CHANNEL_EVENT_b13_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_b13_reserved () const {
    return _CHANNEL_EVENT_b13_reserved;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_b14_reserved (bool CHANNEL_EVENT_b14_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_b14_reserved = CHANNEL_EVENT_b14_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_b14_reserved () const {
    return _CHANNEL_EVENT_b14_reserved;
}

inline void T_b16_CHANNEL_EVENT::setCHANNEL_EVENT_b15_reserved (bool CHANNEL_EVENT_b15_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_EVENT_b15_reserved = CHANNEL_EVENT_b15_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_CHANNEL_EVENT::getCHANNEL_EVENT_b15_reserved () const {
    return _CHANNEL_EVENT_b15_reserved;
}

inline  T_LocalTimeDate::T_LocalTimeDate ()  :
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_LocalTimeDate::T_LocalTimeDate (const T_LocalTimeDate &rhs)  :
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_LocalTimeDate::T_LocalTimeDate (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_)  :
    _s16Year (s16Year_),
    _u8Month (u8Month_),
    _u8Day (u8Day_),
    _u8Hours (u8Hours_),
    _u8Minutes (u8Minutes_),
    _u8Seconds (u8Seconds_),
    _u8Weekday (u8Weekday_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_LocalTimeDate::~T_LocalTimeDate() {
}

inline T_LocalTimeDate& T_LocalTimeDate::operator = (const T_LocalTimeDate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasS16Year()) {
            setS16Year(rhs.getS16Year());
        } else {
            clearS16Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
        if (rhs.hasU8Day()) {
            setU8Day(rhs.getU8Day());
        } else {
            clearU8Day();
        }
        if (rhs.hasU8Hours()) {
            setU8Hours(rhs.getU8Hours());
        } else {
            clearU8Hours();
        }
        if (rhs.hasU8Minutes()) {
            setU8Minutes(rhs.getU8Minutes());
        } else {
            clearU8Minutes();
        }
        if (rhs.hasU8Seconds()) {
            setU8Seconds(rhs.getU8Seconds());
        } else {
            clearU8Seconds();
        }
        if (rhs.hasU8Weekday()) {
            setU8Weekday(rhs.getU8Weekday());
        } else {
            clearU8Weekday();
        }
    }
    return *this;
}

inline bool T_LocalTimeDate::operator == (const T_LocalTimeDate& rhs) const {
    return (((!hasS16Year() && !rhs.hasS16Year()) || getS16Year() == rhs.getS16Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()) &&
        ((!hasU8Day() && !rhs.hasU8Day()) || getU8Day() == rhs.getU8Day()) &&
        ((!hasU8Hours() && !rhs.hasU8Hours()) || getU8Hours() == rhs.getU8Hours()) &&
        ((!hasU8Minutes() && !rhs.hasU8Minutes()) || getU8Minutes() == rhs.getU8Minutes()) &&
        ((!hasU8Seconds() && !rhs.hasU8Seconds()) || getU8Seconds() == rhs.getU8Seconds()) &&
        ((!hasU8Weekday() && !rhs.hasU8Weekday()) || getU8Weekday() == rhs.getU8Weekday()));
}

inline bool T_LocalTimeDate::operator != (const T_LocalTimeDate& rhs) const {
    return ! (*this == rhs);
}

inline bool T_LocalTimeDate::operator < (const T_LocalTimeDate& rhs) const {
    if (hasS16Year() || rhs.hasS16Year()) {
        if (getS16Year() < rhs.getS16Year()) return true;
        if (getS16Year() > rhs.getS16Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    if (hasU8Day() || rhs.hasU8Day()) {
        if (getU8Day() < rhs.getU8Day()) return true;
        if (getU8Day() > rhs.getU8Day()) return false;
    }
    if (hasU8Hours() || rhs.hasU8Hours()) {
        if (getU8Hours() < rhs.getU8Hours()) return true;
        if (getU8Hours() > rhs.getU8Hours()) return false;
    }
    if (hasU8Minutes() || rhs.hasU8Minutes()) {
        if (getU8Minutes() < rhs.getU8Minutes()) return true;
        if (getU8Minutes() > rhs.getU8Minutes()) return false;
    }
    if (hasU8Seconds() || rhs.hasU8Seconds()) {
        if (getU8Seconds() < rhs.getU8Seconds()) return true;
        if (getU8Seconds() > rhs.getU8Seconds()) return false;
    }
    if (hasU8Weekday() || rhs.hasU8Weekday()) {
        if (getU8Weekday() < rhs.getU8Weekday()) return true;
        if (getU8Weekday() > rhs.getU8Weekday()) return false;
    }
    return false;
}

inline bool T_LocalTimeDate::operator > (const T_LocalTimeDate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_LocalTimeDate::clear() {
    clearS16Year();
    clearU8Month();
    clearU8Day();
    clearU8Hours();
    clearU8Minutes();
    clearU8Seconds();
    clearU8Weekday();
}

inline void T_LocalTimeDate::clearS16Year() {
    if (hasS16Year()) {
         clear_has_s16Year();
        _s16Year = 0;
     }
}

inline bool T_LocalTimeDate::hasS16Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 T_LocalTimeDate::getS16Year () const {
    return _s16Year;
}

inline void T_LocalTimeDate::setS16Year (int16 s16Year_) {
    set_has_s16Year();
    this->_s16Year = s16Year_;
}

inline void T_LocalTimeDate::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool T_LocalTimeDate::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_LocalTimeDate::getU8Month () const {
    return _u8Month;
}

inline void T_LocalTimeDate::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void T_LocalTimeDate::clearU8Day() {
    if (hasU8Day()) {
         clear_has_u8Day();
        _u8Day = 0u;
     }
}

inline bool T_LocalTimeDate::hasU8Day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_LocalTimeDate::getU8Day () const {
    return _u8Day;
}

inline void T_LocalTimeDate::setU8Day (uint8 u8Day_) {
    set_has_u8Day();
    this->_u8Day = u8Day_;
}

inline void T_LocalTimeDate::clearU8Hours() {
    if (hasU8Hours()) {
         clear_has_u8Hours();
        _u8Hours = 0u;
     }
}

inline bool T_LocalTimeDate::hasU8Hours () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_LocalTimeDate::getU8Hours () const {
    return _u8Hours;
}

inline void T_LocalTimeDate::setU8Hours (uint8 u8Hours_) {
    set_has_u8Hours();
    this->_u8Hours = u8Hours_;
}

inline void T_LocalTimeDate::clearU8Minutes() {
    if (hasU8Minutes()) {
         clear_has_u8Minutes();
        _u8Minutes = 0u;
     }
}

inline bool T_LocalTimeDate::hasU8Minutes () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_LocalTimeDate::getU8Minutes () const {
    return _u8Minutes;
}

inline void T_LocalTimeDate::setU8Minutes (uint8 u8Minutes_) {
    set_has_u8Minutes();
    this->_u8Minutes = u8Minutes_;
}

inline void T_LocalTimeDate::clearU8Seconds() {
    if (hasU8Seconds()) {
         clear_has_u8Seconds();
        _u8Seconds = 0u;
     }
}

inline bool T_LocalTimeDate::hasU8Seconds () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_LocalTimeDate::getU8Seconds () const {
    return _u8Seconds;
}

inline void T_LocalTimeDate::setU8Seconds (uint8 u8Seconds_) {
    set_has_u8Seconds();
    this->_u8Seconds = u8Seconds_;
}

inline void T_LocalTimeDate::clearU8Weekday() {
    if (hasU8Weekday()) {
         clear_has_u8Weekday();
        _u8Weekday = 0u;
     }
}

inline bool T_LocalTimeDate::hasU8Weekday () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_LocalTimeDate::getU8Weekday () const {
    return _u8Weekday;
}

inline void T_LocalTimeDate::setU8Weekday (uint8 u8Weekday_) {
    set_has_u8Weekday();
    this->_u8Weekday = u8Weekday_;
}

inline void T_LocalTimeDate::set_has_s16Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_LocalTimeDate::clear_has_s16Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_LocalTimeDate::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_LocalTimeDate::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_LocalTimeDate::set_has_u8Day () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_LocalTimeDate::clear_has_u8Day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_LocalTimeDate::set_has_u8Hours () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_LocalTimeDate::clear_has_u8Hours () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_LocalTimeDate::set_has_u8Minutes () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_LocalTimeDate::clear_has_u8Minutes () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_LocalTimeDate::set_has_u8Seconds () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_LocalTimeDate::clear_has_u8Seconds () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_LocalTimeDate::set_has_u8Weekday () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_LocalTimeDate::clear_has_u8Weekday () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_PresetEntry::T_PresetEntry ()  :
    _Index (0u),
    _SID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PresetEntry::T_PresetEntry (const T_PresetEntry &rhs)  :
    _Index (0u),
    _SID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PresetEntry::T_PresetEntry (uint16 Index_, uint16 SID_)  :
    _Index (Index_),
    _SID (SID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PresetEntry::~T_PresetEntry() {
}

inline T_PresetEntry& T_PresetEntry::operator = (const T_PresetEntry& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIndex()) {
            setIndex(rhs.getIndex());
        } else {
            clearIndex();
        }
        if (rhs.hasSID()) {
            setSID(rhs.getSID());
        } else {
            clearSID();
        }
    }
    return *this;
}

inline bool T_PresetEntry::operator == (const T_PresetEntry& rhs) const {
    return (((!hasIndex() && !rhs.hasIndex()) || getIndex() == rhs.getIndex()) &&
        ((!hasSID() && !rhs.hasSID()) || getSID() == rhs.getSID()));
}

inline bool T_PresetEntry::operator != (const T_PresetEntry& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PresetEntry::operator < (const T_PresetEntry& rhs) const {
    if (hasIndex() || rhs.hasIndex()) {
        if (getIndex() < rhs.getIndex()) return true;
        if (getIndex() > rhs.getIndex()) return false;
    }
    if (hasSID() || rhs.hasSID()) {
        if (getSID() < rhs.getSID()) return true;
        if (getSID() > rhs.getSID()) return false;
    }
    return false;
}

inline bool T_PresetEntry::operator > (const T_PresetEntry& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PresetEntry::clear() {
    clearIndex();
    clearSID();
}

inline void T_PresetEntry::clearIndex() {
    if (hasIndex()) {
         clear_has_Index();
        _Index = 0u;
     }
}

inline bool T_PresetEntry::hasIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_PresetEntry::getIndex () const {
    return _Index;
}

inline void T_PresetEntry::setIndex (uint16 Index_) {
    set_has_Index();
    this->_Index = Index_;
}

inline void T_PresetEntry::clearSID() {
    if (hasSID()) {
         clear_has_SID();
        _SID = 0u;
     }
}

inline bool T_PresetEntry::hasSID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_PresetEntry::getSID () const {
    return _SID;
}

inline void T_PresetEntry::setSID (uint16 SID_) {
    set_has_SID();
    this->_SID = SID_;
}

inline void T_PresetEntry::set_has_Index () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PresetEntry::clear_has_Index () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PresetEntry::set_has_SID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PresetEntry::clear_has_SID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_ProfileResponse::T_ProfileResponse ()  :
    _Status (::sxm_audio_main_fi_types::T_Status__Failed),
    _ProfileAction (::sxm_audio_main_fi_types::T_ProfileAction__ActiveProfile),
    _ProfileStatus (::sxm_audio_main_fi_types::T_ProfileStatus__Idle)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ProfileResponse::T_ProfileResponse (const T_ProfileResponse &rhs)  :
    _Status (::sxm_audio_main_fi_types::T_Status__Failed),
    _ProfileAction (::sxm_audio_main_fi_types::T_ProfileAction__ActiveProfile),
    _ProfileStatus (::sxm_audio_main_fi_types::T_ProfileStatus__Idle)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ProfileResponse::T_ProfileResponse (T_Status Status_, T_ProfileAction ProfileAction_, T_ProfileStatus ProfileStatus_)  :
    _Status (Status_),
    _ProfileAction (ProfileAction_),
    _ProfileStatus (ProfileStatus_)
{
    #ifndef NDEBUG
    if (!(T_Status_IsValid(Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_Status", "Status", "T_ProfileResponse");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_ProfileAction_IsValid(ProfileAction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ProfileAction_, "T_ProfileAction", "ProfileAction", "T_ProfileResponse");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_ProfileStatus_IsValid(ProfileStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ProfileStatus_, "T_ProfileStatus", "ProfileStatus", "T_ProfileResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ProfileResponse::~T_ProfileResponse() {
}

inline T_ProfileResponse& T_ProfileResponse::operator = (const T_ProfileResponse& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasProfileAction()) {
            setProfileAction(rhs.getProfileAction());
        } else {
            clearProfileAction();
        }
        if (rhs.hasProfileStatus()) {
            setProfileStatus(rhs.getProfileStatus());
        } else {
            clearProfileStatus();
        }
    }
    return *this;
}

inline bool T_ProfileResponse::operator == (const T_ProfileResponse& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasProfileAction() && !rhs.hasProfileAction()) || getProfileAction() == rhs.getProfileAction()) &&
        ((!hasProfileStatus() && !rhs.hasProfileStatus()) || getProfileStatus() == rhs.getProfileStatus()));
}

inline bool T_ProfileResponse::operator != (const T_ProfileResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ProfileResponse::operator < (const T_ProfileResponse& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    if (hasProfileAction() || rhs.hasProfileAction()) {
        if ((uint32)getProfileAction() < (uint32)rhs.getProfileAction()) return true;
        if ((uint32)getProfileAction() > (uint32)rhs.getProfileAction()) return false;
    }
    if (hasProfileStatus() || rhs.hasProfileStatus()) {
        if ((uint32)getProfileStatus() < (uint32)rhs.getProfileStatus()) return true;
        if ((uint32)getProfileStatus() > (uint32)rhs.getProfileStatus()) return false;
    }
    return false;
}

inline bool T_ProfileResponse::operator > (const T_ProfileResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ProfileResponse::clear() {
    clearStatus();
    clearProfileAction();
    clearProfileStatus();
}

inline void T_ProfileResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::sxm_audio_main_fi_types::T_Status__Failed;
     }
}

inline bool T_ProfileResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_Status T_ProfileResponse::getStatus () const {
    return _Status;
}

inline void T_ProfileResponse::setStatus (T_Status Status_) {
    #ifndef NDEBUG
    if (!(T_Status_IsValid(Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_Status", "Status", "T_ProfileResponse");
    }
    #endif
    set_has_Status();
    this->_Status = Status_;
}

inline void T_ProfileResponse::clearProfileAction() {
    if (hasProfileAction()) {
         clear_has_ProfileAction();
        _ProfileAction = ::sxm_audio_main_fi_types::T_ProfileAction__ActiveProfile;
     }
}

inline bool T_ProfileResponse::hasProfileAction () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_ProfileAction T_ProfileResponse::getProfileAction () const {
    return _ProfileAction;
}

inline void T_ProfileResponse::setProfileAction (T_ProfileAction ProfileAction_) {
    #ifndef NDEBUG
    if (!(T_ProfileAction_IsValid(ProfileAction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ProfileAction_, "T_ProfileAction", "ProfileAction", "T_ProfileResponse");
    }
    #endif
    set_has_ProfileAction();
    this->_ProfileAction = ProfileAction_;
}

inline void T_ProfileResponse::clearProfileStatus() {
    if (hasProfileStatus()) {
         clear_has_ProfileStatus();
        _ProfileStatus = ::sxm_audio_main_fi_types::T_ProfileStatus__Idle;
     }
}

inline bool T_ProfileResponse::hasProfileStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_ProfileStatus T_ProfileResponse::getProfileStatus () const {
    return _ProfileStatus;
}

inline void T_ProfileResponse::setProfileStatus (T_ProfileStatus ProfileStatus_) {
    #ifndef NDEBUG
    if (!(T_ProfileStatus_IsValid(ProfileStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ProfileStatus_, "T_ProfileStatus", "ProfileStatus", "T_ProfileResponse");
    }
    #endif
    set_has_ProfileStatus();
    this->_ProfileStatus = ProfileStatus_;
}

inline void T_ProfileResponse::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ProfileResponse::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ProfileResponse::set_has_ProfileAction () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ProfileResponse::clear_has_ProfileAction () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ProfileResponse::set_has_ProfileStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ProfileResponse::clear_has_ProfileStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_PresetsConfiguration::T_PresetsConfiguration ()  :
    _BandCount (0u),
    _BandCapacity (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PresetsConfiguration::T_PresetsConfiguration (const T_PresetsConfiguration &rhs)  :
    _BandCount (0u),
    _BandCapacity (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PresetsConfiguration::T_PresetsConfiguration (uint8 BandCount_, uint8 BandCapacity_)  :
    _BandCount (BandCount_),
    _BandCapacity (BandCapacity_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PresetsConfiguration::~T_PresetsConfiguration() {
}

inline T_PresetsConfiguration& T_PresetsConfiguration::operator = (const T_PresetsConfiguration& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBandCount()) {
            setBandCount(rhs.getBandCount());
        } else {
            clearBandCount();
        }
        if (rhs.hasBandCapacity()) {
            setBandCapacity(rhs.getBandCapacity());
        } else {
            clearBandCapacity();
        }
    }
    return *this;
}

inline bool T_PresetsConfiguration::operator == (const T_PresetsConfiguration& rhs) const {
    return (((!hasBandCount() && !rhs.hasBandCount()) || getBandCount() == rhs.getBandCount()) &&
        ((!hasBandCapacity() && !rhs.hasBandCapacity()) || getBandCapacity() == rhs.getBandCapacity()));
}

inline bool T_PresetsConfiguration::operator != (const T_PresetsConfiguration& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PresetsConfiguration::operator < (const T_PresetsConfiguration& rhs) const {
    if (hasBandCount() || rhs.hasBandCount()) {
        if (getBandCount() < rhs.getBandCount()) return true;
        if (getBandCount() > rhs.getBandCount()) return false;
    }
    if (hasBandCapacity() || rhs.hasBandCapacity()) {
        if (getBandCapacity() < rhs.getBandCapacity()) return true;
        if (getBandCapacity() > rhs.getBandCapacity()) return false;
    }
    return false;
}

inline bool T_PresetsConfiguration::operator > (const T_PresetsConfiguration& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PresetsConfiguration::clear() {
    clearBandCount();
    clearBandCapacity();
}

inline void T_PresetsConfiguration::clearBandCount() {
    if (hasBandCount()) {
         clear_has_BandCount();
        _BandCount = 0u;
     }
}

inline bool T_PresetsConfiguration::hasBandCount () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_PresetsConfiguration::getBandCount () const {
    return _BandCount;
}

inline void T_PresetsConfiguration::setBandCount (uint8 BandCount_) {
    set_has_BandCount();
    this->_BandCount = BandCount_;
}

inline void T_PresetsConfiguration::clearBandCapacity() {
    if (hasBandCapacity()) {
         clear_has_BandCapacity();
        _BandCapacity = 0u;
     }
}

inline bool T_PresetsConfiguration::hasBandCapacity () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_PresetsConfiguration::getBandCapacity () const {
    return _BandCapacity;
}

inline void T_PresetsConfiguration::setBandCapacity (uint8 BandCapacity_) {
    set_has_BandCapacity();
    this->_BandCapacity = BandCapacity_;
}

inline void T_PresetsConfiguration::set_has_BandCount () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PresetsConfiguration::clear_has_BandCount () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PresetsConfiguration::set_has_BandCapacity () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PresetsConfiguration::clear_has_BandCapacity () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace sxm_audio_main_fi_types

#endif // SXM_AUDIO_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
