#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_AUDIO_MAIN_FI_H
#define SXM_AUDIO_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_audio_main_fi_types.h"
#include "sxm_audio_main_fi_typesConst.h"
#include "sxm_main_fi_types.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'sxm_audio_main_fi'
 *
 * Fullname: SXM Audio Functional Interface Specification
 *
 * Version: $Revision:   0.9  $
 *
 * Author: Rakshitha K R
 *
 * Date: $Date:   April 27 2018  10:00 AM  $
 *
 * Department: ECO1
 *
 * Title: sxm_audio_main_fi
 *
 * <b>Description of 'sxm_audio_main_fi':</b>
 *
 * ECO1 RBEI
 */

namespace sxm_audio_main_fi {

static const int SERVICE_ID = 150;

static const int FID_GetChannelList = 64;

static const int FID_GetCategoryList = 65;

static const int FID_SelectChannel = 66;

static const int FID_SelectChannelWithDwellTime = 67;

static const int FID_StorePreset = 68;

static const int FID_RecallPreset = 69;

static const int FID_SetAutoCompareParameters = 70;

static const int FID_SetDestinationPosition = 71;

static const int FID_DiagTestModeEnable = 72;

static const int FID_DiagUpcValues = 73;

static const int FID_TWNowSetMarket = 74;

static const int FID_TWNowGetActiveMarket = 75;

static const int FID_TWNowBulletinPlayback = 76;

static const int FID_TWNowGetBulletinID = 77;

static const int FID_TWNowGetAvailableMarkets = 78;

static const int FID_TWNowEnable = 79;

static const int FID_DiagSxmReset = 80;

static const int FID_FirmwareDownload = 81;

static const int FID_ExternalDiagnosisMode = 82;

static const int FID_InstantReplayControl = 83;

static const int FID_EnableTuneStart = 84;

static const int FID_SmartFavoriteListControl = 85;

static const int FID_SetCurrentVolume = 86;

static const int FID_TuneScanControl = 87;

static const int FID_GetPresetList = 88;

static const int FID_DisableMatureChannels = 89;

static const int FID_SkipChannel = 90;

static const int FID_SaveFavorite = 91;

static const int FID_GetFavoriteList = 92;

static const int FID_ModifyFavorite = 93;

static const int FID_GetAlertNoticeList = 94;

static const int FID_SportsFlashEnableNotification = 112;

static const int FID_SportsFlashAddFavoriteTeam = 113;

static const int FID_SportsFlashRemoveFavoriteTeam = 114;

static const int FID_SportsFlashRemoveAllFavoriteTeams = 115;

static const int FID_SportsFlashGetAllFavorites = 116;

static const int FID_SportsFlashGetCurrentGames = 117;

static const int FID_SportsFlashSetGamesMonitor = 118;

static const int FID_SportsFlashGetCurrentFlashEvents = 119;

static const int FID_SportsFlashPlayFlashEvent = 120;

static const int FID_SportsFlashAbortFlashEvent = 121;

static const int FID_SportsFlashGetCurrentFlashEventID = 122;

static const int FID_SportsFlashEnabledLeagues = 123;

static const int FID_SportsFlashGetTeams = 124;

static const int FID_SportsFlashMonitorTeams = 125;

static const int FID_GetChannelInfo = 126;

static const int FID_SetDevicePosition = 130;

static const int FID_SetCategoryMonitor = 131;

static const int FID_RapidChannelBrowseStart = 132;

static const int FID_RapidChannelBrowseStop = 133;

static const int FID_ResetSXMModule = 135;

static const int FID_UserProfile = 95;

static const int FID_GetPresetsConfig = 161;

static const int FID_SetPresetList = 162;

static const int FID_ChannelInformation = 96;

static const int FID_AutoCompare = 97;

static const int FID_SystemMessage = 98;

static const int FID_ChannelListStatus = 99;

static const int FID_CurrentChannelGraphic = 100;

static const int FID_CategoryListStatus = 101;

static const int FID_InstantReplayStatus = 102;

static const int FID_InstantReplayMode = 103;

static const int FID_TuneScanContentStatus = 104;

static const int FID_PresetChannelUpdate = 105;

static const int FID_SxmDataServiceStatus = 128;

static const int FID_SxmDataServiceAntennaStatus = 129;

static const int FID_PresetListUpdate = 134;

static const int FID_DiagTestModeData = 145;

static const int FID_DiagSxmVersion = 146;

static const int FID_SxmDiagSignalQuality = 147;

static const int FID_SxmDiagAntennaState = 148;

static const int FID_SxmRadioId = 149;

static const int FID_SxmSmsDbVersions = 150;

static const int FID_SxmAudioSubInfo = 151;

static const int FID_SxmModuleSubInfo = 152;

static const int FID_FirmwareDownloadProgress = 153;

static const int FID_FavoriteContentAlertInfo = 106;

static const int FID_AlertNoticeListUpdate = 107;

static const int FID_TWNowServiceStatus = 108;

static const int FID_TWNowBulletinStatus = 109;

static const int FID_SetClockParams = 110;

static const int FID_SportsFlash_ServiceStatus = 154;

static const int FID_SportsFlash_GameEventNotification = 155;

static const int FID_SportsFlash_FlashEventNotification = 156;

static const int FID_TWNowPlaybackStatus = 157;

static const int FID_SportsFlash_PlaybackStatus = 158;

static const int FID_RapidChannelBrowseInfo = 160;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 2;

static const int VERSION_MINOR = 7;

static const int VERSION_PATCH = 8;

// forward declarations
class GetChannelListStart;

class GetChannelListResult;

class GetChannelListErrorStructure;

class GetChannelListError;

class GetCategoryListStart;

class GetCategoryListResult;

class GetCategoryListErrorStructure;

class GetCategoryListError;

class SelectChannelStart;

class SelectChannelResult;

class SelectChannelErrorStructure;

class SelectChannelError;

class SelectChannelWithDwellTimeStart;

class SelectChannelWithDwellTimeResult;

class SelectChannelWithDwellTimeErrorStructure;

class SelectChannelWithDwellTimeError;

class StorePresetStart;

class StorePresetResult;

class StorePresetErrorStructure;

class StorePresetError;

class RecallPresetStart;

class RecallPresetResult;

class RecallPresetErrorStructure;

class RecallPresetError;

class SetAutoCompareParametersStart;

class SetAutoCompareParametersResult;

class SetAutoCompareParametersErrorStructure;

class SetAutoCompareParametersError;

class SetDestinationPositionStart;

class SetDestinationPositionResult;

class SetDestinationPositionErrorStructure;

class SetDestinationPositionError;

class DiagTestModeEnableStart;

class DiagTestModeEnableErrorStructure;

class DiagTestModeEnableError;

class DiagUpcValuesStart;

class DiagUpcValuesResult;

class DiagUpcValuesErrorStructure;

class DiagUpcValuesError;

class TWNowSetMarketStart;

class TWNowSetMarketResult;

class TWNowSetMarketErrorStructure;

class TWNowSetMarketError;

class TWNowGetActiveMarketResult;

class TWNowGetActiveMarketErrorStructure;

class TWNowGetActiveMarketError;

class TWNowBulletinPlaybackStart;

class TWNowBulletinPlaybackResult;

class TWNowBulletinPlaybackErrorStructure;

class TWNowBulletinPlaybackError;

class TWNowGetBulletinIDResult;

class TWNowGetBulletinIDErrorStructure;

class TWNowGetBulletinIDError;

class TWNowGetAvailableMarketsResult;

class TWNowGetAvailableMarketsErrorStructure;

class TWNowGetAvailableMarketsError;

class TWNowEnableStart;

class TWNowEnableResult;

class TWNowEnableErrorStructure;

class TWNowEnableError;

class DiagSxmResetStart;

class DiagSxmResetErrorStructure;

class DiagSxmResetError;

class FirmwareDownloadStart;

class FirmwareDownloadResult;

class FirmwareDownloadErrorStructure;

class FirmwareDownloadError;

class ExternalDiagnosisModeStart;

class ExternalDiagnosisModeErrorStructure;

class ExternalDiagnosisModeError;

class InstantReplayControlStart;

class InstantReplayControlResult;

class InstantReplayControlErrorStructure;

class InstantReplayControlError;

class EnableTuneStartStart;

class EnableTuneStartResult;

class EnableTuneStartErrorStructure;

class EnableTuneStartError;

class SmartFavoriteListControlStart;

class SmartFavoriteListControlResult;

class SmartFavoriteListControlErrorStructure;

class SmartFavoriteListControlError;

class SetCurrentVolumeStart;

class SetCurrentVolumeResult;

class SetCurrentVolumeErrorStructure;

class SetCurrentVolumeError;

class TuneScanControlStart;

class TuneScanControlResult;

class TuneScanControlErrorStructure;

class TuneScanControlError;

class GetPresetListStart;

class GetPresetListResult;

class GetPresetListErrorStructure;

class GetPresetListError;

class DisableMatureChannelsStart;

class DisableMatureChannelsResult;

class DisableMatureChannelsErrorStructure;

class DisableMatureChannelsError;

class SkipChannelStart;

class SkipChannelResult;

class SkipChannelErrorStructure;

class SkipChannelError;

class SaveFavoriteStart;

class SaveFavoriteResult;

class SaveFavoriteErrorStructure;

class SaveFavoriteError;

class GetFavoriteListStart;

class GetFavoriteListResult;

class GetFavoriteListErrorStructure;

class GetFavoriteListError;

class ModifyFavoriteStart;

class ModifyFavoriteResult;

class ModifyFavoriteErrorStructure;

class ModifyFavoriteError;

class GetAlertNoticeListStart;

class GetAlertNoticeListResult;

class GetAlertNoticeListErrorStructure;

class GetAlertNoticeListError;

class SportsFlashEnableNotificationStart;

class SportsFlashEnableNotificationResult;

class SportsFlashEnableNotificationErrorStructure;

class SportsFlashEnableNotificationError;

class SportsFlashAddFavoriteTeamStart;

class SportsFlashAddFavoriteTeamResult;

class SportsFlashAddFavoriteTeamErrorStructure;

class SportsFlashAddFavoriteTeamError;

class SportsFlashRemoveFavoriteTeamStart;

class SportsFlashRemoveFavoriteTeamResult;

class SportsFlashRemoveFavoriteTeamErrorStructure;

class SportsFlashRemoveFavoriteTeamError;

class SportsFlashRemoveAllFavoriteTeamsResult;

class SportsFlashRemoveAllFavoriteTeamsErrorStructure;

class SportsFlashRemoveAllFavoriteTeamsError;

class SportsFlashGetAllFavoritesResult;

class SportsFlashGetAllFavoritesErrorStructure;

class SportsFlashGetAllFavoritesError;

class SportsFlashGetCurrentGamesResult;

class SportsFlashGetCurrentGamesErrorStructure;

class SportsFlashGetCurrentGamesError;

class SportsFlashSetGamesMonitorStart;

class SportsFlashSetGamesMonitorResult;

class SportsFlashSetGamesMonitorErrorStructure;

class SportsFlashSetGamesMonitorError;

class SportsFlashGetCurrentFlashEventsResult;

class SportsFlashGetCurrentFlashEventsErrorStructure;

class SportsFlashGetCurrentFlashEventsError;

class SportsFlashPlayFlashEventStart;

class SportsFlashPlayFlashEventResult;

class SportsFlashPlayFlashEventErrorStructure;

class SportsFlashPlayFlashEventError;

class SportsFlashAbortFlashEventResult;

class SportsFlashAbortFlashEventErrorStructure;

class SportsFlashAbortFlashEventError;

class SportsFlashGetCurrentFlashEventIDResult;

class SportsFlashGetCurrentFlashEventIDErrorStructure;

class SportsFlashGetCurrentFlashEventIDError;

class SportsFlashEnabledLeaguesResult;

class SportsFlashEnabledLeaguesErrorStructure;

class SportsFlashEnabledLeaguesError;

class SportsFlashGetTeamsStart;

class SportsFlashGetTeamsResult;

class SportsFlashGetTeamsErrorStructure;

class SportsFlashGetTeamsError;

class SportsFlashMonitorTeamsStart;

class SportsFlashMonitorTeamsResult;

class SportsFlashMonitorTeamsErrorStructure;

class SportsFlashMonitorTeamsError;

class GetChannelInfoStart;

class GetChannelInfoResult;

class GetChannelInfoErrorStructure;

class GetChannelInfoError;

class SetDevicePositionStart;

class SetDevicePositionResult;

class SetDevicePositionErrorStructure;

class SetDevicePositionError;

class SetCategoryMonitorStart;

class SetCategoryMonitorResult;

class SetCategoryMonitorErrorStructure;

class SetCategoryMonitorError;

class RapidChannelBrowseStartStart;

class RapidChannelBrowseStartResult;

class RapidChannelBrowseStartErrorStructure;

class RapidChannelBrowseStartError;

class RapidChannelBrowseStopStart;

class RapidChannelBrowseStopResult;

class RapidChannelBrowseStopErrorStructure;

class RapidChannelBrowseStopError;

class ResetSXMModuleResult;

class ResetSXMModuleErrorStructure;

class ResetSXMModuleError;

class UserProfileStart;

class UserProfileResult;

class UserProfileErrorStructure;

class UserProfileError;

class GetPresetsConfigResult;

class GetPresetsConfigErrorStructure;

class GetPresetsConfigError;

class SetPresetListStart;

class SetPresetListResult;

class SetPresetListErrorStructure;

class SetPresetListError;

class ChannelInformationStatus;

class ChannelInformationErrorStructure;

class ChannelInformationError;

class AutoCompareStatus;

class AutoCompareErrorStructure;

class AutoCompareError;

class SystemMessageStatus;

class SystemMessageErrorStructure;

class SystemMessageError;

class ChannelListStatusStatus;

class ChannelListStatusErrorStructure;

class ChannelListStatusError;

class CurrentChannelGraphicStatus;

class CurrentChannelGraphicErrorStructure;

class CurrentChannelGraphicError;

class CategoryListStatusStatus;

class CategoryListStatusErrorStructure;

class CategoryListStatusError;

class InstantReplayStatusStatus;

class InstantReplayStatusErrorStructure;

class InstantReplayStatusError;

class InstantReplayModeStatus;

class InstantReplayModeErrorStructure;

class InstantReplayModeError;

class TuneScanContentStatusStatus;

class TuneScanContentStatusErrorStructure;

class TuneScanContentStatusError;

class PresetChannelUpdateStatus;

class PresetChannelUpdateErrorStructure;

class PresetChannelUpdateError;

class SxmDataServiceStatusStatus;

class SxmDataServiceAntennaStatusStatus;

class PresetListUpdateStatus;

class PresetListUpdateErrorStructure;

class PresetListUpdateError;

class DiagTestModeDataStatus;

class DiagTestModeDataErrorStructure;

class DiagTestModeDataError;

class DiagSxmVersionStatus;

class DiagSxmVersionErrorStructure;

class DiagSxmVersionError;

class SxmDiagSignalQualityStatus;

class SxmDiagSignalQualityErrorStructure;

class SxmDiagSignalQualityError;

class SxmDiagAntennaStateStatus;

class SxmDiagAntennaStateErrorStructure;

class SxmDiagAntennaStateError;

class SxmRadioIdStatus;

class SxmRadioIdErrorStructure;

class SxmRadioIdError;

class SxmSmsDbVersionsStatus;

class SxmSmsDbVersionsErrorStructure;

class SxmSmsDbVersionsError;

class SxmAudioSubInfoStatus;

class SxmAudioSubInfoErrorStructure;

class SxmAudioSubInfoError;

class SxmModuleSubInfoStatus;

class SxmModuleSubInfoErrorStructure;

class SxmModuleSubInfoError;

class FirmwareDownloadProgressStatus;

class FirmwareDownloadProgressErrorStructure;

class FirmwareDownloadProgressError;

class FavoriteContentAlertInfoStatus;

class FavoriteContentAlertInfoErrorStructure;

class FavoriteContentAlertInfoError;

class AlertNoticeListUpdateStatus;

class AlertNoticeListUpdateErrorStructure;

class AlertNoticeListUpdateError;

class TWNowServiceStatusStatus;

class TWNowServiceStatusErrorStructure;

class TWNowServiceStatusError;

class TWNowBulletinStatusStatus;

class TWNowBulletinStatusErrorStructure;

class TWNowBulletinStatusError;

class SetClockParamsStatus;

class SetClockParamsSet;

class SetClockParamsErrorStructure;

class SetClockParamsError;

class SportsFlash_ServiceStatusStatus;

class SportsFlash_ServiceStatusErrorStructure;

class SportsFlash_ServiceStatusError;

class SportsFlash_GameEventNotificationStatus;

class SportsFlash_GameEventNotificationErrorStructure;

class SportsFlash_GameEventNotificationError;

class SportsFlash_FlashEventNotificationStatus;

class SportsFlash_FlashEventNotificationErrorStructure;

class SportsFlash_FlashEventNotificationError;

class TWNowPlaybackStatusStatus;

class TWNowPlaybackStatusErrorStructure;

class TWNowPlaybackStatusError;

class SportsFlash_PlaybackStatusStatus;

class SportsFlash_PlaybackStatusErrorStructure;

class SportsFlash_PlaybackStatusError;

class RapidChannelBrowseInfoStatus;

class RapidChannelBrowseInfoErrorStructure;

class RapidChannelBrowseInfoError;

// type definitions
/**
 * The abort error message of the method "GetChannelList"
 * Send the list of (audio) channels.
 * <p>@Figure fileName = ../figures/XM_Tuner_GetChannelList.gif width =</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError GetChannelListAbortError;

/**
 * The abort error message of the method "GetCategoryList"
 * Send the list of (audio) category
 */
typedef ::asf::cca::CcaTypes::DefaultError GetCategoryListAbortError;

/**
 * The abort error message of the method "SelectChannel"
 * "Select an audio channel"
 * <p>@Figure fileName = ../figures/XM_Tuner_SelectChannel.gif width =</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SelectChannelAbortError;

/**
 * The abort error message of the method "SelectChannelWithDwellTime"
 * Select an audio channel with a delay. This method is used in the Manual
 * Tuning by scrolling. The channel selection
 * will be made only after the expiry of the dwell time. In case a
 * new selection happens before the timer expiry, the timer will be
 * restarted.
 */
typedef ::asf::cca::CcaTypes::DefaultError SelectChannelWithDwellTimeAbortError;

/**
 * The abort error message of the method "StorePreset"
 * Store the current tuned station to one preset of the preset list
 */
typedef ::asf::cca::CcaTypes::DefaultError StorePresetAbortError;

/**
 * The abort error message of the method "RecallPreset"
 * Recall one preset of the preset list identified by PresetElement
 */
typedef ::asf::cca::CcaTypes::DefaultError RecallPresetAbortError;

/**
 * The abort error message of the method "SetAutoCompareParameters"
 * Set the autocompare parameters.This can be used by the client to
 * set the range of preset elements in the current user selected favourite page.
 * The xmtuner application performs the autocompare only on preset elements
 * which falls in this range. If there is no autocompare match found in this range,
 * then xmtuner update zero as aurocompare range.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAutoCompareParametersAbortError;

/**
 * The abort error message of the method "SetDestinationPosition"
 * Set the destination position from HMI. This can be used to set latitude
 * and longitude for required data services.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDestinationPositionAbortError;

/**
 * The result message of the method "DiagTestModeEnable"
 * Enable or Disable generation of data for developer test mode via
 * Property DiagTestModeData
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagTestModeEnableResult;

/**
 * The abort error message of the method "DiagTestModeEnable"
 * Enable or Disable generation of data for developer test mode via
 * Property DiagTestModeData
 */
typedef ::asf::cca::CcaTypes::DefaultError DiagTestModeEnableAbortError;

/**
 * The abort error message of the method "DiagUpcValues"
 * Request for UPC values.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiagUpcValuesAbortError;

/**
 * The abort error message of the method "TWNowSetMarket"
 * Set or Unset a market for monitoring
 */
typedef ::asf::cca::CcaTypes::DefaultError TWNowSetMarketAbortError;

/**
 * The start message of the method "TWNowGetActiveMarket"
 * Get currently monitored market.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TWNowGetActiveMarketStart;

/**
 * The abort error message of the method "TWNowGetActiveMarket"
 * Get currently monitored market.
 */
typedef ::asf::cca::CcaTypes::DefaultError TWNowGetActiveMarketAbortError;

/**
 * The abort error message of the method "TWNowBulletinPlayback"
 * Either Switch playback to the channel broadcasting the Traffic/Weather report or Abort the currently playing report to switch back to the last tuned channel. After the Traffic/Weather report has been fully played the Module switches to the previous channel automatically.
 */
typedef ::asf::cca::CcaTypes::DefaultError TWNowBulletinPlaybackAbortError;

/**
 * The start message of the method "TWNowGetBulletinID"
 * Retrieve currently playing Bulletin ID.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TWNowGetBulletinIDStart;

/**
 * The abort error message of the method "TWNowGetBulletinID"
 * Retrieve currently playing Bulletin ID.
 */
typedef ::asf::cca::CcaTypes::DefaultError TWNowGetBulletinIDAbortError;

/**
 * The start message of the method "TWNowGetAvailableMarkets"
 * Get list of all available markets that could be monitored by SMS.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TWNowGetAvailableMarketsStart;

/**
 * The abort error message of the method "TWNowGetAvailableMarkets"
 * Get list of all available markets that could be monitored by SMS.
 */
typedef ::asf::cca::CcaTypes::DefaultError TWNowGetAvailableMarketsAbortError;

/**
 * The abort error message of the method "TWNowEnable"
 * Enable or Disable updates to be sent for the selected markets.
 */
typedef ::asf::cca::CcaTypes::DefaultError TWNowEnableAbortError;

/**
 * The result message of the method "DiagSxmReset"
 * Request for resetting individual Data service data bases and the user data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagSxmResetResult;

/**
 * The abort error message of the method "DiagSxmReset"
 * Request for resetting individual Data service data bases and the user data.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiagSxmResetAbortError;

/**
 * The abort error message of the method "FirmwareDownload"
 * Download of x65 firmware
 */
typedef ::asf::cca::CcaTypes::DefaultError FirmwareDownloadAbortError;

/**
 * The result message of the method "ExternalDiagnosisMode"
 * Method to enter and Exit from external Diagnosis mode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ExternalDiagnosisModeResult;

/**
 * The abort error message of the method "ExternalDiagnosisMode"
 * Method to enter and Exit from external Diagnosis mode
 */
typedef ::asf::cca::CcaTypes::DefaultError ExternalDiagnosisModeAbortError;

/**
 * The abort error message of the method "InstantReplayControl"
 * Method to control sxm audio instant replay functionality
 */
typedef ::asf::cca::CcaTypes::DefaultError InstantReplayControlAbortError;

/**
 * The abort error message of the method "EnableTuneStart"
 * Method to enable or disable tune start functionality
 */
typedef ::asf::cca::CcaTypes::DefaultError EnableTuneStartAbortError;

/**
 * The abort error message of the method "SmartFavoriteListControl"
 * Get list of smart favorite channels preset list indexs
 */
typedef ::asf::cca::CcaTypes::DefaultError SmartFavoriteListControlAbortError;

/**
 * The abort error message of the method "SetCurrentVolume"
 * Set current volume mute or unmute state
 */
typedef ::asf::cca::CcaTypes::DefaultError SetCurrentVolumeAbortError;

/**
 * The abort error message of the method "TuneScanControl"
 * Method to control sxm audio tune scan functionality
 */
typedef ::asf::cca::CcaTypes::DefaultError TuneScanControlAbortError;

/**
 * The abort error message of the method "GetPresetList"
 * Get the list of channels in the selected preset band.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetPresetListAbortError;

/**
 * The abort error message of the method "DisableMatureChannels"
 * Lock/Unlock all channels that are identified to Broadcast Mature Content.
 */
typedef ::asf::cca::CcaTypes::DefaultError DisableMatureChannelsAbortError;

/**
 * The abort error message of the method "SkipChannel"
 * Method to be set or unset channel skip status to one or all channels .
 */
typedef ::asf::cca::CcaTypes::DefaultError SkipChannelAbortError;

/**
 * The abort error message of the method "SaveFavorite"
 * Save the currently playing channel as favorite artist or song
 */
typedef ::asf::cca::CcaTypes::DefaultError SaveFavoriteAbortError;

/**
 * The abort error message of the method "GetFavoriteList"
 * Get list of favorite for artist or song
 */
typedef ::asf::cca::CcaTypes::DefaultError GetFavoriteListAbortError;

/**
 * The abort error message of the method "ModifyFavorite"
 * Get alert notification list
 */
typedef ::asf::cca::CcaTypes::DefaultError ModifyFavoriteAbortError;

/**
 * The abort error message of the method "GetAlertNoticeList"
 * Get alert notification list
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAlertNoticeListAbortError;

/**
 * The abort error message of the method "SportsFlashEnableNotification"
 * Enable or Disable receiving Sports Flash Notifications. The status set from here is stored by SMS in sms.cfg file and the values would be retained after power cycles.
 * <p>There are no API's exposed by SMS to retrieve if SportsFlashNotifications are enabled or not. So its the role of client to store this status being sent to MIDW persistently.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashEnableNotificationAbortError;

/**
 * The abort error message of the method "SportsFlashAddFavoriteTeam"
 * Adds a team as a favorite and thereby starts monitoring the sports flash events involving the team.
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashAddFavoriteTeamAbortError;

/**
 * The abort error message of the method "SportsFlashRemoveFavoriteTeam"
 * Removes a team from favorite list and thereby stops monitoring the sports flash events involving the team.
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashRemoveFavoriteTeamAbortError;

/**
 * The start message of the method "SportsFlashRemoveAllFavoriteTeams"
 * Removes all teams from favourites list and thereby stops monitoring all the sports flash events.
 * No input parameters needed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlashRemoveAllFavoriteTeamsStart;

/**
 * The abort error message of the method "SportsFlashRemoveAllFavoriteTeams"
 * Removes all teams from favourites list and thereby stops monitoring all the sports flash events.
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashRemoveAllFavoriteTeamsAbortError;

/**
 * The start message of the method "SportsFlashGetAllFavorites"
 * Get All teams that are currently registered for Sports Flash Event notifications.
 * No input parameters needed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlashGetAllFavoritesStart;

/**
 * The abort error message of the method "SportsFlashGetAllFavorites"
 * Get All teams that are currently registered for Sports Flash Event notifications.
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashGetAllFavoritesAbortError;

/**
 * The start message of the method "SportsFlashGetCurrentGames"
 * Retrieve list of all the currently ongoing game events involving user specified favourite teams filtered from duplicates.
 * No input parameters needed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlashGetCurrentGamesStart;

/**
 * The abort error message of the method "SportsFlashGetCurrentGames"
 * Retrieve list of all the currently ongoing game events involving user specified favourite teams filtered from duplicates.
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashGetCurrentGamesAbortError;

/**
 * The abort error message of the method "SportsFlashSetGamesMonitor"
 * Set up a list of game channels to monitor for Sports Flash events.
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashSetGamesMonitorAbortError;

/**
 * The start message of the method "SportsFlashGetCurrentFlashEvents"
 * Retreive information list about each occurred and not yet expired Flash Event at any moment.
 * No input parameters needed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlashGetCurrentFlashEventsStart;

/**
 * The abort error message of the method "SportsFlashGetCurrentFlashEvents"
 * Retreive information list about each occurred and not yet expired Flash Event at any moment.
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashGetCurrentFlashEventsAbortError;

/**
 * The abort error message of the method "SportsFlashPlayFlashEvent"
 * Switch playback to the channel playing the Flash Event reported by the Monitor.
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashPlayFlashEventAbortError;

/**
 * The start message of the method "SportsFlashAbortFlashEvent"
 * Abort playback of the channel, playing the Flash Event.
 * No input parameters needed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlashAbortFlashEventStart;

/**
 * The abort error message of the method "SportsFlashAbortFlashEvent"
 * Abort playback of the channel, playing the Flash Event.
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashAbortFlashEventAbortError;

/**
 * The start message of the method "SportsFlashGetCurrentFlashEventID"
 * Retrieve currently playing sports flash event ID.
 * No input parameters needed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlashGetCurrentFlashEventIDStart;

/**
 * The abort error message of the method "SportsFlashGetCurrentFlashEventID"
 * Retrieve currently playing sports flash event ID.
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashGetCurrentFlashEventIDAbortError;

/**
 * The start message of the method "SportsFlashEnabledLeagues"
 * Get List of all leagues for which Sport Flash Feature is supported.
 * No input parameters needed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlashEnabledLeaguesStart;

/**
 * The abort error message of the method "SportsFlashEnabledLeagues"
 * Get List of all leagues for which Sport Flash Feature is supported.
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashEnabledLeaguesAbortError;

/**
 * The abort error message of the method "SportsFlashGetTeams"
 * Get List of all sports flash content supported teams affiliated to a League.
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashGetTeamsAbortError;

/**
 * The abort error message of the method "SportsFlashMonitorTeams"
 * Method is applicable only for Teams that are already part of Favorite teams.
 * <p>Setting or unsetting favorite teams for sports flash monitoring. Method does not modify a teams entry to the Favorites list.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SportsFlashMonitorTeamsAbortError;

/**
 * The abort error message of the method "GetChannelInfo"
 * Get Channel information list for the given list of SIDs
 */
typedef ::asf::cca::CcaTypes::DefaultError GetChannelInfoAbortError;

/**
 * The abort error message of the method "SetDevicePosition"
 * Set the device position from HMI.
 * This can be used to set latitude and longitude for required data services.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDevicePositionAbortError;

/**
 * The abort error message of the method "SetCategoryMonitor"
 * Method informs FC_SXM about the category user is interested in.
 * Upon receiving this instruction, FC_SXM would notify clients through property CategoryListStatus if the attribute of any channels within the selected category changes.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetCategoryMonitorAbortError;

/**
 * The abort error message of the method "RapidChannelBrowseStart"
 * Start Rapid Channel Browsing.
 */
typedef ::asf::cca::CcaTypes::DefaultError RapidChannelBrowseStartAbortError;

/**
 * The abort error message of the method "RapidChannelBrowseStop"
 * Stop Rapid Channel Browsing and tune to channel being passed.
 */
typedef ::asf::cca::CcaTypes::DefaultError RapidChannelBrowseStopAbortError;

/**
 * The start message of the method "ResetSXMModule"
 * Method Resets SXM Tuner Module to factory default state. All SXM services are stopped and restarted.
 * Reset SXM Tuner Module. No input parameters needed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetSXMModuleStart;

/**
 * The abort error message of the method "ResetSXMModule"
 * Method Resets SXM Tuner Module to factory default state. All SXM services are stopped and restarted.
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetSXMModuleAbortError;

/**
 * The abort error message of the method "UserProfile"
 * Method to perform varios user profile actions.
 */
typedef ::asf::cca::CcaTypes::DefaultError UserProfileAbortError;

/**
 * The start message of the method "GetPresetsConfig"
 * Method to get preset configuration.
 * No input parameters needed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetPresetsConfigStart;

/**
 * The abort error message of the method "GetPresetsConfig"
 * Method to get preset configuration.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetPresetsConfigAbortError;

/**
 * The abort error message of the method "SetPresetList"
 * Method to set preset list.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPresetListAbortError;

/**
 * The get message of the property "ChannelInformation"
 * Information of actual channel
 * Request information of actual (audio) channel
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChannelInformationGet;

/**
 * The upreg message of the property "ChannelInformation"
 * Information of actual channel
 * Registers for Channel information changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChannelInformationUpReg;

/**
 * The relUpReg message of the property "ChannelInformation"
 * Information of actual channel
 * Unregister for Channel information changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChannelInformationRelUpReg;

/**
 * The get message of the property "AutoCompare"
 * AutoCompare result
 * Request last AutoCompare result
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoCompareGet;

/**
 * The upreg message of the property "AutoCompare"
 * AutoCompare result
 * Register for AutoCompare changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoCompareUpReg;

/**
 * The relUpReg message of the property "AutoCompare"
 * AutoCompare result
 * Unregister for AutoCompare changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoCompareRelUpReg;

/**
 * The get message of the property "SystemMessage"
 * XM System Error Conditions
 * Request Current XM System Error Condition
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemMessageGet;

/**
 * The upreg message of the property "SystemMessage"
 * XM System Error Conditions
 * Register for System Error message changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemMessageUpReg;

/**
 * The relUpReg message of the property "SystemMessage"
 * XM System Error Conditions
 * Unregister System Error message changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemMessageRelUpReg;

/**
 * The get message of the property "ChannelListStatus"
 * Provide the status of the XM Channel List. This status update will be given the synchronization
 * of the Channel List with respect to the XM-Tuner module is completed. The client could use this
 * property status for sending the GetChannelList requests.
 * Request to get Channel List status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChannelListStatusGet;

/**
 * The upreg message of the property "ChannelListStatus"
 * Provide the status of the XM Channel List. This status update will be given the synchronization
 * of the Channel List with respect to the XM-Tuner module is completed. The client could use this
 * property status for sending the GetChannelList requests.
 * Register for ChannelListStatus
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChannelListStatusUpReg;

/**
 * The relUpReg message of the property "ChannelListStatus"
 * Provide the status of the XM Channel List. This status update will be given the synchronization
 * of the Channel List with respect to the XM-Tuner module is completed. The client could use this
 * property status for sending the GetChannelList requests.
 * Unregister for ChannelListStatus
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChannelListStatusRelUpReg;

/**
 * The get message of the property "CurrentChannelGraphic"
 * Get information of channel graphics stored in ffs
 * Request to get Channel Graphic for current SID
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentChannelGraphicGet;

/**
 * The upreg message of the property "CurrentChannelGraphic"
 * Get information of channel graphics stored in ffs
 * Register for Subscription
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentChannelGraphicUpReg;

/**
 * The relUpReg message of the property "CurrentChannelGraphic"
 * Get information of channel graphics stored in ffs
 * Unregister Subscription
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentChannelGraphicRelUpReg;

/**
 * The get message of the property "CategoryListStatus"
 * Provide the status of the XM Category List. This status update will be given the synchronization
 * of the Category List with respect to the XM-Tuner module is completed. The client could use this
 * property status for sending the GetCategoryList requests.
 * Request to get Category List status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CategoryListStatusGet;

/**
 * The upreg message of the property "CategoryListStatus"
 * Provide the status of the XM Category List. This status update will be given the synchronization
 * of the Category List with respect to the XM-Tuner module is completed. The client could use this
 * property status for sending the GetCategoryList requests.
 * Register for CategoryListStatus
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CategoryListStatusUpReg;

/**
 * The relUpReg message of the property "CategoryListStatus"
 * Provide the status of the XM Category List. This status update will be given the synchronization
 * of the Category List with respect to the XM-Tuner module is completed. The client could use this
 * property status for sending the GetCategoryList requests.
 * Unregister for CategoryListStatus
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CategoryListStatusRelUpReg;

/**
 * The get message of the property "InstantReplayStatus"
 * Information on instant replay buffer status and controls
 * Request instant replay status information
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InstantReplayStatusGet;

/**
 * The upreg message of the property "InstantReplayStatus"
 * Information on instant replay buffer status and controls
 * Registers for instant replay status updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InstantReplayStatusUpReg;

/**
 * The relUpReg message of the property "InstantReplayStatus"
 * Information on instant replay buffer status and controls
 * Unregister for instant replay status updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InstantReplayStatusRelUpReg;

/**
 * The get message of the property "InstantReplayMode"
 * Information on instant replay mode
 * Request instant replay mode information
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InstantReplayModeGet;

/**
 * The upreg message of the property "InstantReplayMode"
 * Information on instant replay mode
 * Registers for instant replay mode updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InstantReplayModeUpReg;

/**
 * The relUpReg message of the property "InstantReplayMode"
 * Information on instant replay mode
 * Unregister for instant replay mode updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InstantReplayModeRelUpReg;

/**
 * The get message of the property "TuneScanContentStatus"
 * Get the Tune Scan content status
 * Request tune scan content information
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TuneScanContentStatusGet;

/**
 * The upreg message of the property "TuneScanContentStatus"
 * Get the Tune Scan content status
 * Registers for tune scan updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TuneScanContentStatusUpReg;

/**
 * The relUpReg message of the property "TuneScanContentStatus"
 * Get the Tune Scan content status
 * UnRegisters for tune scan updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TuneScanContentStatusRelUpReg;

/**
 * The get message of the property "PresetChannelUpdate"
 * Notify change in one of the Preset channels.
 * Request Preset channel change data
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PresetChannelUpdateGet;

/**
 * The upreg message of the property "PresetChannelUpdate"
 * Notify change in one of the Preset channels.
 * Registers for Preset channel change updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PresetChannelUpdateUpReg;

/**
 * The relUpReg message of the property "PresetChannelUpdate"
 * Notify change in one of the Preset channels.
 * De-register from Preset channel change updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PresetChannelUpdateRelUpReg;

/**
 * The get message of the property "SxmDataServiceStatus"
 * Get the Status of of all our data-services
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusGet;

/**
 * The upreg message of the property "SxmDataServiceStatus"
 * Get the Status of of all our data-services
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusUpReg;

/**
 * The relUpReg message of the property "SxmDataServiceStatus"
 * Get the Status of of all our data-services
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusRelUpReg;

/**
 * The error message of 'SxmDataServiceStatus'
 * An Error occured
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmDataServiceStatusError;

/**
 * The get message of the property "SxmDataServiceAntennaStatus"
 * Get the current antenna status for data services travel link
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceAntennaStatusGet;

/**
 * The upreg message of the property "SxmDataServiceAntennaStatus"
 * Get the current antenna status for data services travel link
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceAntennaStatusUpReg;

/**
 * The relUpReg message of the property "SxmDataServiceAntennaStatus"
 * Get the current antenna status for data services travel link
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceAntennaStatusRelUpReg;

/**
 * The error message of 'SxmDataServiceAntennaStatus'
 * An Error occured
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmDataServiceAntennaStatusError;

/**
 * The get message of the property "PresetListUpdate"
 * Notify change in all Preset channels. Upon receiving this notification, clients must refresh its Presest List and must do a methodstart for GetPresetsList.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PresetListUpdateGet;

/**
 * The upreg message of the property "PresetListUpdate"
 * Notify change in all Preset channels. Upon receiving this notification, clients must refresh its Presest List and must do a methodstart for GetPresetsList.
 * Registers for Preset List update
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PresetListUpdateUpReg;

/**
 * The relUpReg message of the property "PresetListUpdate"
 * Notify change in all Preset channels. Upon receiving this notification, clients must refresh its Presest List and must do a methodstart for GetPresetsList.
 * De-register from Preset List update
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PresetListUpdateRelUpReg;

/**
 * The upreg message of the property "DiagTestModeData"
 * Test mode data for developer test mode.
 * Generating of data has to be enabled via DiagTestModeEnable
 * Not Get is provided.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagTestModeDataUpReg;

/**
 * The relUpReg message of the property "DiagTestModeData"
 * Test mode data for developer test mode.
 * Generating of data has to be enabled via DiagTestModeEnable
 * Not Get is provided.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagTestModeDataRelUpReg;

/**
 * The upreg message of the property "DiagSxmVersion"
 * This gives the SXM version information.Required for
 * Diagnosis service test mode as well
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagSxmVersionUpReg;

/**
 * The relUpReg message of the property "DiagSxmVersion"
 * This gives the SXM version information.Required for
 * Diagnosis service test mode as well
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagSxmVersionRelUpReg;

/**
 * The get message of the property "SxmDiagSignalQuality"
 * This properties provides the signal quality parameters
 * Request signal quality values
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDiagSignalQualityGet;

/**
 * The upreg message of the property "SxmDiagSignalQuality"
 * This properties provides the signal quality parameters
 * Register for signal quality changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDiagSignalQualityUpReg;

/**
 * The relUpReg message of the property "SxmDiagSignalQuality"
 * This properties provides the signal quality parameters
 * Unregister for signal quality changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDiagSignalQualityRelUpReg;

/**
 * The get message of the property "SxmDiagAntennaState"
 * This properties provides the Antenna status parameters
 * Request Current Antenna status values
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDiagAntennaStateGet;

/**
 * The upreg message of the property "SxmDiagAntennaState"
 * This properties provides the Antenna status parameters
 * Register for Antenna Status changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDiagAntennaStateUpReg;

/**
 * The relUpReg message of the property "SxmDiagAntennaState"
 * This properties provides the Antenna status parameters
 * Unregister for Antenna State changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDiagAntennaStateRelUpReg;

/**
 * The get message of the property "SxmRadioId"
 * This properties provides the SXM Radio ID
 * Request SXM Radio ID
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmRadioIdGet;

/**
 * The upreg message of the property "SxmRadioId"
 * This properties provides the SXM Radio ID
 * Register for Radio Id
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmRadioIdUpReg;

/**
 * The relUpReg message of the property "SxmRadioId"
 * This properties provides the SXM Radio ID
 * Unregister for Radio ID
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmRadioIdRelUpReg;

/**
 * The upreg message of the property "SxmSmsDbVersions"
 * This gives the SMS Database versions as well as the current SMS version.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmSmsDbVersionsUpReg;

/**
 * The relUpReg message of the property "SxmSmsDbVersions"
 * This gives the SMS Database versions as well as the current SMS version.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmSmsDbVersionsRelUpReg;

/**
 * The upreg message of the property "SxmAudioSubInfo"
 * This gives the Audio subscription status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmAudioSubInfoUpReg;

/**
 * The relUpReg message of the property "SxmAudioSubInfo"
 * This gives the Audio subscription status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmAudioSubInfoRelUpReg;

/**
 * The upreg message of the property "SxmModuleSubInfo"
 * This gives the Module subscription status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmModuleSubInfoUpReg;

/**
 * The relUpReg message of the property "SxmModuleSubInfo"
 * This gives the Module subscription status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmModuleSubInfoRelUpReg;

/**
 * The get message of the property "FirmwareDownloadProgress"
 * Status of the firmware-download
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FirmwareDownloadProgressGet;

/**
 * The upreg message of the property "FirmwareDownloadProgress"
 * Status of the firmware-download
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FirmwareDownloadProgressUpReg;

/**
 * The relUpReg message of the property "FirmwareDownloadProgress"
 * Status of the firmware-download
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FirmwareDownloadProgressRelUpReg;

/**
 * The get message of the property "FavoriteContentAlertInfo"
 * This property will notify the information about alerts
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FavoriteContentAlertInfoGet;

/**
 * The upreg message of the property "FavoriteContentAlertInfo"
 * This property will notify the information about alerts
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FavoriteContentAlertInfoUpReg;

/**
 * The relUpReg message of the property "FavoriteContentAlertInfo"
 * This property will notify the information about alerts
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FavoriteContentAlertInfoRelUpReg;

/**
 * The get message of the property "AlertNoticeListUpdate"
 * This property will notify when alert list is available
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AlertNoticeListUpdateGet;

/**
 * The upreg message of the property "AlertNoticeListUpdate"
 * This property will notify when alert list is available
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AlertNoticeListUpdateUpReg;

/**
 * The relUpReg message of the property "AlertNoticeListUpdate"
 * This property will notify when alert list is available
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AlertNoticeListUpdateRelUpReg;

/**
 * The get message of the property "TWNowServiceStatus"
 * This property will notify the status of TWNowService
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TWNowServiceStatusGet;

/**
 * The upreg message of the property "TWNowServiceStatus"
 * This property will notify the status of TWNowService
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TWNowServiceStatusUpReg;

/**
 * The relUpReg message of the property "TWNowServiceStatus"
 * This property will notify the status of TWNowService
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TWNowServiceStatusRelUpReg;

/**
 * The get message of the property "TWNowBulletinStatus"
 * This property will notify TWNow Bulletin Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TWNowBulletinStatusGet;

/**
 * The upreg message of the property "TWNowBulletinStatus"
 * This property will notify TWNow Bulletin Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TWNowBulletinStatusUpReg;

/**
 * The relUpReg message of the property "TWNowBulletinStatus"
 * This property will notify TWNow Bulletin Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TWNowBulletinStatusRelUpReg;

/**
 * The upreg message of the property "SetClockParams"
 * Property to set Clock Parameters
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetClockParamsUpReg;

/**
 * The relUpReg message of the property "SetClockParams"
 * Property to set Clock Parameters
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetClockParamsRelUpReg;

/**
 * The get message of the property "SportsFlash_ServiceStatus"
 * This property will notify the status of Sports Flash Service.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlash_ServiceStatusGet;

/**
 * The upreg message of the property "SportsFlash_ServiceStatus"
 * This property will notify the status of Sports Flash Service.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlash_ServiceStatusUpReg;

/**
 * The relUpReg message of the property "SportsFlash_ServiceStatus"
 * This property will notify the status of Sports Flash Service.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlash_ServiceStatusRelUpReg;

/**
 * The get message of the property "SportsFlash_GameEventNotification"
 * This property will notify Game Event Updates. On receiving this notification application can use the params passed directly or it can also invoke method SportsFlashGetCurrentGames.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlash_GameEventNotificationGet;

/**
 * The upreg message of the property "SportsFlash_GameEventNotification"
 * This property will notify Game Event Updates. On receiving this notification application can use the params passed directly or it can also invoke method SportsFlashGetCurrentGames.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlash_GameEventNotificationUpReg;

/**
 * The relUpReg message of the property "SportsFlash_GameEventNotification"
 * This property will notify Game Event Updates. On receiving this notification application can use the params passed directly or it can also invoke method SportsFlashGetCurrentGames.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlash_GameEventNotificationRelUpReg;

/**
 * The get message of the property "SportsFlash_FlashEventNotification"
 * This property will notify Flash Event Updates. On receiving this notification application can use the params passed directly or it can also invoke method SportsFlashGetCurrentFlashEvents.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlash_FlashEventNotificationGet;

/**
 * The upreg message of the property "SportsFlash_FlashEventNotification"
 * This property will notify Flash Event Updates. On receiving this notification application can use the params passed directly or it can also invoke method SportsFlashGetCurrentFlashEvents.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlash_FlashEventNotificationUpReg;

/**
 * The relUpReg message of the property "SportsFlash_FlashEventNotification"
 * This property will notify Flash Event Updates. On receiving this notification application can use the params passed directly or it can also invoke method SportsFlashGetCurrentFlashEvents.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlash_FlashEventNotificationRelUpReg;

/**
 * The get message of the property "TWNowPlaybackStatus"
 * This property will notify clients if TWNow Bulletin is currently being played or not.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TWNowPlaybackStatusGet;

/**
 * The upreg message of the property "TWNowPlaybackStatus"
 * This property will notify clients if TWNow Bulletin is currently being played or not.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TWNowPlaybackStatusUpReg;

/**
 * The relUpReg message of the property "TWNowPlaybackStatus"
 * This property will notify clients if TWNow Bulletin is currently being played or not.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TWNowPlaybackStatusRelUpReg;

/**
 * The get message of the property "SportsFlash_PlaybackStatus"
 * This property will notify clients if a sports flash event is currently being played or not.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlash_PlaybackStatusGet;

/**
 * The upreg message of the property "SportsFlash_PlaybackStatus"
 * This property will notify clients if a sports flash event is currently being played or not.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlash_PlaybackStatusUpReg;

/**
 * The relUpReg message of the property "SportsFlash_PlaybackStatus"
 * This property will notify clients if a sports flash event is currently being played or not.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsFlash_PlaybackStatusRelUpReg;

/**
 * The get message of the property "RapidChannelBrowseInfo"
 * While Rapid Channel Browsing is Active, inform Client to changeover to the next channel.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RapidChannelBrowseInfoGet;

/**
 * The upreg message of the property "RapidChannelBrowseInfo"
 * While Rapid Channel Browsing is Active, inform Client to changeover to the next channel.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RapidChannelBrowseInfoUpReg;

/**
 * The relUpReg message of the property "RapidChannelBrowseInfo"
 * While Rapid Channel Browsing is Active, inform Client to changeover to the next channel.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RapidChannelBrowseInfoRelUpReg;


/**
 * The start message of the method "GetChannelList"
 * Send the list of (audio) channels.
 * <p>@Figure fileName = ../figures/XM_Tuner_GetChannelList.gif width =</p>
 * Start a Method
 */
class GetChannelListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChannelListStart ();

    /**
     * Copy constructor
     */
    inline  GetChannelListStart (const GetChannelListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelListStart (uint16 Index_, uint16 Range_);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelListStart();

    /**
     * Assignment operator
     */
    inline GetChannelListStart& operator = (const GetChannelListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Index"

    static const int kIndex = 0;

    /**
     * Clears the field "Index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "Index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "Index".
     *
     * Starting channel number from which the Channel List should begin.
     * The range of values it can take is from 0 to 65535. If the channel
     * number mentioned in "index" is not available, then next available
     * channel will be taken as index.
     *
     * @return The value of the field "Index"
     */
    inline uint16 getIndex () const;

    /**
     * Sets the value of the member "Index".
     *
     * Starting channel number from which the Channel List should begin.
     * The range of values it can take is from 0 to 65535. If the channel
     * number mentioned in "index" is not available, then next available
     * channel will be taken as index.
     *
     * @param Index The value which will be set
     */
    inline void setIndex (uint16 Index_);

    // API of field "Range"

    static const int kRange = 1;

    /**
     * Clears the field "Range".
     *
     * The field will be set to its default value. The hasRange()
     * method will return false.
     */
    inline void clearRange();

    /**
     * Checks whether the field "Range" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRange()). Otherwise it will return false.
     */
    inline bool hasRange () const;

    /**
     * Returns the value of the member "Range".
     *
     * Number of Channel List entries starting from Index. The range of values
     * it can take is from 1 to 65535. If this value is zero, then entire Channel
     * List will be given
     *
     * @return The value of the field "Range"
     */
    inline uint16 getRange () const;

    /**
     * Sets the value of the member "Range".
     *
     * Number of Channel List entries starting from Index. The range of values
     * it can take is from 1 to 65535. If this value is zero, then entire Channel
     * List will be given
     *
     * @param Range The value which will be set
     */
    inline void setRange (uint16 Range_);

    static const GetChannelListStart &getDefaultInstance();

private:

    inline void set_has_Index ();

    inline void clear_has_Index ();

    inline void set_has_Range ();

    inline void clear_has_Range ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _Index;

    uint16 _Range;

};

/**
 * The result message of the method "GetChannelList"
 * Send the list of (audio) channels.
 * <p>@Figure fileName = ../figures/XM_Tuner_GetChannelList.gif width =</p>
 * Result of a method
 */
class GetChannelListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChannelListResult ();

    /**
     * Copy constructor
     */
    inline  GetChannelListResult (const GetChannelListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelListResult (const ::std::vector< ::sxm_audio_main_fi_types::T_ChannelListEntry >& ChannelList_, uint16 NextIndex_, ::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelListResult();

    /**
     * Assignment operator
     */
    inline GetChannelListResult& operator = (const GetChannelListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelList"

    static const int kChannelList = 0;

    /**
     * Clears the field "ChannelList".
     *
     * The field will be set to its default value. The hasChannelList()
     * method will return false.
     */
    inline void clearChannelList();

    /**
     * Checks whether the field "ChannelList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelList()). Otherwise it will return false.
     */
    inline bool hasChannelList () const;

    /**
     * Returns the value of the member "ChannelList".
     *
     * Subset of Channel List containing ServiceID, ChannelID, ChannelName
     *
     * @return The value of the field "ChannelList"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_ChannelListEntry >& getChannelList () const;

    /**
     * Retrieves the value of the field "ChannelList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelList".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_ChannelListEntry >& getChannelListMutable ();

    /**
     * Sets the value of the member "ChannelList".
     *
     * Subset of Channel List containing ServiceID, ChannelID, ChannelName
     *
     * @param ChannelList The value which will be set
     */
    inline void setChannelList (const ::std::vector< ::sxm_audio_main_fi_types::T_ChannelListEntry >& ChannelList_);

    // API of field "NextIndex"

    static const int kNextIndex = 1;

    /**
     * Clears the field "NextIndex".
     *
     * The field will be set to its default value. The hasNextIndex()
     * method will return false.
     */
    inline void clearNextIndex();

    /**
     * Checks whether the field "NextIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextIndex()). Otherwise it will return false.
     */
    inline bool hasNextIndex () const;

    /**
     * Returns the value of the member "NextIndex".
     *
     * Next available channel number in the Channel List (May be used as the
     * index in the next Channel List request)
     *
     * @return The value of the field "NextIndex"
     */
    inline uint16 getNextIndex () const;

    /**
     * Sets the value of the member "NextIndex".
     *
     * Next available channel number in the Channel List (May be used as the
     * index in the next Channel List request)
     *
     * @param NextIndex The value which will be set
     */
    inline void setNextIndex (uint16 NextIndex_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status of the method
     *
     * @return The value of the field "Status"
     */
    inline ::sxm_audio_main_fi_types::T_e8_MethodStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Status of the method
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    static const GetChannelListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_ChannelListEntry >& getT_ChannelListEntryList_DefaultInstance ();

    inline void set_has_ChannelList ();

    inline void clear_has_ChannelList ();

    inline void set_has_NextIndex ();

    inline void clear_has_NextIndex ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< ::sxm_audio_main_fi_types::T_ChannelListEntry > _ChannelList;

    uint16 _NextIndex;

    ::sxm_audio_main_fi_types::T_e8_MethodStatus _Status;

};

/**
 * The error message of 'GetChannelList'
 */
class GetChannelListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetChannelListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetChannelListErrorStructure (const GetChannelListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelListErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetChannelListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetChannelListErrorStructure& operator = (const GetChannelListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const GetChannelListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetChannelList'
 */
class GetChannelListError  : public ::asf::core::Payload {
public:

    enum GetChannelListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetChannelListError ();

   /**
     * Copy constructor
     */
    inline  GetChannelListError (const GetChannelListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetChannelListError& operator = (const GetChannelListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetChannelListError::GetChannelListErrorField getField () const;

    inline void setField(GetChannelListError::GetChannelListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetChannelListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetChannelListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetChannelListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetChannelListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetChannelListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetChannelListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetChannelListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetChannelListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetChannelListError &getDefaultInstance();

private:

    inline void cloneData (const GetChannelListError& rhs);

    inline void deleteData ();

    GetChannelListErrorField __field;

    union {
        GetChannelListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetCategoryList"
 * Send the list of (audio) category
 * Start a Method
 */
class GetCategoryListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetCategoryListStart ();

    /**
     * Copy constructor
     */
    inline  GetCategoryListStart (const GetCategoryListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetCategoryListStart (uint16 CategoryType_);

    /**
     * Destructor
     */
    inline virtual  ~GetCategoryListStart();

    /**
     * Assignment operator
     */
    inline GetCategoryListStart& operator = (const GetCategoryListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCategoryListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCategoryListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCategoryListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCategoryListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CategoryType"

    static const int kCategoryType = 0;

    /**
     * Clears the field "CategoryType".
     *
     * The field will be set to its default value. The hasCategoryType()
     * method will return false.
     */
    inline void clearCategoryType();

    /**
     * Checks whether the field "CategoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryType()). Otherwise it will return false.
     */
    inline bool hasCategoryType () const;

    /**
     * Returns the value of the member "CategoryType".
     *
     * 0 = all categories, 1 to 63 = corresponding broadcast category,
     * 255 = current category,
     * 257 to 319 = corresponding virtual category
     *
     * @return The value of the field "CategoryType"
     */
    inline uint16 getCategoryType () const;

    /**
     * Sets the value of the member "CategoryType".
     *
     * 0 = all categories, 1 to 63 = corresponding broadcast category,
     * 255 = current category,
     * 257 to 319 = corresponding virtual category
     *
     * @param CategoryType The value which will be set
     */
    inline void setCategoryType (uint16 CategoryType_);

    static const GetCategoryListStart &getDefaultInstance();

private:

    inline void set_has_CategoryType ();

    inline void clear_has_CategoryType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _CategoryType;

};

/**
 * The result message of the method "GetCategoryList"
 * Send the list of (audio) category
 * Result of a method
 */
class GetCategoryListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetCategoryListResult ();

    /**
     * Copy constructor
     */
    inline  GetCategoryListResult (const GetCategoryListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetCategoryListResult (const ::std::vector< ::sxm_audio_main_fi_types::T_CategoryListEntry >& CategoryList_, uint16 CategoryType_, ::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    /**
     * Destructor
     */
    inline virtual  ~GetCategoryListResult();

    /**
     * Assignment operator
     */
    inline GetCategoryListResult& operator = (const GetCategoryListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCategoryListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCategoryListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCategoryListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCategoryListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CategoryList"

    static const int kCategoryList = 0;

    /**
     * Clears the field "CategoryList".
     *
     * The field will be set to its default value. The hasCategoryList()
     * method will return false.
     */
    inline void clearCategoryList();

    /**
     * Checks whether the field "CategoryList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryList()). Otherwise it will return false.
     */
    inline bool hasCategoryList () const;

    /**
     * Returns the value of the member "CategoryList".
     *
     * Subset of category list. List containing category type, category name avail flag,
     * category name and list of channel related to the specified category type(list of T_CategoryListEntry)
     *
     * @return The value of the field "CategoryList"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_CategoryListEntry >& getCategoryList () const;

    /**
     * Retrieves the value of the field "CategoryList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CategoryList".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_CategoryListEntry >& getCategoryListMutable ();

    /**
     * Sets the value of the member "CategoryList".
     *
     * Subset of category list. List containing category type, category name avail flag,
     * category name and list of channel related to the specified category type(list of T_CategoryListEntry)
     *
     * @param CategoryList The value which will be set
     */
    inline void setCategoryList (const ::std::vector< ::sxm_audio_main_fi_types::T_CategoryListEntry >& CategoryList_);

    // API of field "CategoryType"

    static const int kCategoryType = 1;

    /**
     * Clears the field "CategoryType".
     *
     * The field will be set to its default value. The hasCategoryType()
     * method will return false.
     */
    inline void clearCategoryType();

    /**
     * Checks whether the field "CategoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryType()). Otherwise it will return false.
     */
    inline bool hasCategoryType () const;

    /**
     * Returns the value of the member "CategoryType".
     *
     * 0 = all categories,
     * 1 to 63 = corresponding broadcast category,
     * 255 = current category,
     * 257 to 319 = corresponding virtual category
     *
     * @return The value of the field "CategoryType"
     */
    inline uint16 getCategoryType () const;

    /**
     * Sets the value of the member "CategoryType".
     *
     * 0 = all categories,
     * 1 to 63 = corresponding broadcast category,
     * 255 = current category,
     * 257 to 319 = corresponding virtual category
     *
     * @param CategoryType The value which will be set
     */
    inline void setCategoryType (uint16 CategoryType_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * status of the method
     *
     * @return The value of the field "Status"
     */
    inline ::sxm_audio_main_fi_types::T_e8_MethodStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * status of the method
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    static const GetCategoryListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_CategoryListEntry >& getT_CategoryListEntryList_DefaultInstance ();

    inline void set_has_CategoryList ();

    inline void clear_has_CategoryList ();

    inline void set_has_CategoryType ();

    inline void clear_has_CategoryType ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< ::sxm_audio_main_fi_types::T_CategoryListEntry > _CategoryList;

    uint16 _CategoryType;

    ::sxm_audio_main_fi_types::T_e8_MethodStatus _Status;

};

/**
 * The error message of 'GetCategoryList'
 */
class GetCategoryListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetCategoryListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetCategoryListErrorStructure (const GetCategoryListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetCategoryListErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetCategoryListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetCategoryListErrorStructure& operator = (const GetCategoryListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCategoryListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCategoryListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCategoryListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCategoryListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const GetCategoryListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetCategoryList'
 */
class GetCategoryListError  : public ::asf::core::Payload {
public:

    enum GetCategoryListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetCategoryListError ();

   /**
     * Copy constructor
     */
    inline  GetCategoryListError (const GetCategoryListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetCategoryListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetCategoryListError& operator = (const GetCategoryListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCategoryListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCategoryListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCategoryListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCategoryListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetCategoryListError::GetCategoryListErrorField getField () const;

    inline void setField(GetCategoryListError::GetCategoryListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetCategoryListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetCategoryListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetCategoryListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetCategoryListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetCategoryListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetCategoryListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetCategoryListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetCategoryListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetCategoryListError &getDefaultInstance();

private:

    inline void cloneData (const GetCategoryListError& rhs);

    inline void deleteData ();

    GetCategoryListErrorField __field;

    union {
        GetCategoryListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SelectChannel"
 * "Select an audio channel"
 * <p>@Figure fileName = ../figures/XM_Tuner_SelectChannel.gif width =</p>
 * Select Channel
 */
class SelectChannelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectChannelStart ();

    /**
     * Copy constructor
     */
    inline  SelectChannelStart (const SelectChannelStart &rhs);

    /**
     * All fields constructor
     */
    inline  SelectChannelStart (::sxm_audio_main_fi_types::T_e8_SelectChannelMode SelectionMode_, uint16 CidOrSid_, uint16 CategoryType_, uint8 Steps_);

    /**
     * Destructor
     */
    inline virtual  ~SelectChannelStart();

    /**
     * Assignment operator
     */
    inline SelectChannelStart& operator = (const SelectChannelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectChannelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectChannelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectChannelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectChannelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SelectionMode"

    static const int kSelectionMode = 0;

    /**
     * Clears the field "SelectionMode".
     *
     * The field will be set to its default value. The hasSelectionMode()
     * method will return false.
     */
    inline void clearSelectionMode();

    /**
     * Checks whether the field "SelectionMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelectionMode()). Otherwise it will return false.
     */
    inline bool hasSelectionMode () const;

    /**
     * Returns the value of the member "SelectionMode".
     *
     * Mode for selecting the channel.
     *
     * @return The value of the field "SelectionMode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_SelectChannelMode getSelectionMode () const;

    /**
     * Sets the value of the member "SelectionMode".
     *
     * Mode for selecting the channel.
     *
     * @param SelectionMode The value which will be set
     */
    inline void setSelectionMode (::sxm_audio_main_fi_types::T_e8_SelectChannelMode SelectionMode_);

    // API of field "CidOrSid"

    static const int kCidOrSid = 1;

    /**
     * Clears the field "CidOrSid".
     *
     * The field will be set to its default value. The hasCidOrSid()
     * method will return false.
     */
    inline void clearCidOrSid();

    /**
     * Checks whether the field "CidOrSid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCidOrSid()). Otherwise it will return false.
     */
    inline bool hasCidOrSid () const;

    /**
     * Returns the value of the member "CidOrSid".
     *
     * ChannelIdentifier or ServiceIdentifier.
     * <p>XMTUN_SELECT_CHANNEL_UP or  CHANNEL_DOWN: This value will be ignored.</p>
     * <p>XMTUN_SELECT_PROGRAM_UP or PROGRAM_DOWN: In the case of CategoryType = 255 this value will be ignored too.
     * If the CategorType 1 to 63 or 257 to 319 and this value is set, the first available Channel in the specified category will be select.</p>
     *
     * @return The value of the field "CidOrSid"
     */
    inline uint16 getCidOrSid () const;

    /**
     * Sets the value of the member "CidOrSid".
     *
     * ChannelIdentifier or ServiceIdentifier.
     * <p>XMTUN_SELECT_CHANNEL_UP or  CHANNEL_DOWN: This value will be ignored.</p>
     * <p>XMTUN_SELECT_PROGRAM_UP or PROGRAM_DOWN: In the case of CategoryType = 255 this value will be ignored too.
     * If the CategorType 1 to 63 or 257 to 319 and this value is set, the first available Channel in the specified category will be select.</p>
     *
     * @param CidOrSid The value which will be set
     */
    inline void setCidOrSid (uint16 CidOrSid_);

    // API of field "CategoryType"

    static const int kCategoryType = 2;

    /**
     * Clears the field "CategoryType".
     *
     * The field will be set to its default value. The hasCategoryType()
     * method will return false.
     */
    inline void clearCategoryType();

    /**
     * Checks whether the field "CategoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryType()). Otherwise it will return false.
     */
    inline bool hasCategoryType () const;

    /**
     * Returns the value of the member "CategoryType".
     *
     * Valid Range: "1 to 63 and 257 to 319".
     * <p>Note 1:
     * 0 denotes the next or previews category up or down from the actual category.</p>
     * <p>Note 2:
     * 1 to 63 denotes the new broadcast category by the category number.</p>
     * <p>Note 3:
     * 257 to 319 denotes the new virtual category by the category number.</p>
     * <p>Note 4:
     * 254 denotes current category. If the actual channel the last or first channel in the actual categories list,
     * the first or last channel of the
     * categories behind or before will be select.</p>
     * <p>Note 5:
     * 255 denotes current category. (The category of the current active channel)
     * If current active channel is 0 or current Channel belongs to Category 0,
     * then PROGRAM_UP and PROGRAM_DOWN request with CategoryType = 255 would fail.</p>
     * <p>Note 6:
     * This parameter used for sending the CBM request only in
     * case of selection modes XMTUN_PROGRAM_UP/_DOWN(SDARS receiver increments or decrements the channelID
     * or SID value and continues to search for next available channel in the specified Broadcast CategoryType(1 to 63))
     * or Virtual CategoryType(257 to 319).
     * In all other channel selection modes this parameter has no effect on channel selection.</p>
     * <p>Note 7:
     * In all modes of channel selection, it is used for updating the value of "User Search Category"(FktID: 0x75).</p>
     *
     * @return The value of the field "CategoryType"
     */
    inline uint16 getCategoryType () const;

    /**
     * Sets the value of the member "CategoryType".
     *
     * Valid Range: "1 to 63 and 257 to 319".
     * <p>Note 1:
     * 0 denotes the next or previews category up or down from the actual category.</p>
     * <p>Note 2:
     * 1 to 63 denotes the new broadcast category by the category number.</p>
     * <p>Note 3:
     * 257 to 319 denotes the new virtual category by the category number.</p>
     * <p>Note 4:
     * 254 denotes current category. If the actual channel the last or first channel in the actual categories list,
     * the first or last channel of the
     * categories behind or before will be select.</p>
     * <p>Note 5:
     * 255 denotes current category. (The category of the current active channel)
     * If current active channel is 0 or current Channel belongs to Category 0,
     * then PROGRAM_UP and PROGRAM_DOWN request with CategoryType = 255 would fail.</p>
     * <p>Note 6:
     * This parameter used for sending the CBM request only in
     * case of selection modes XMTUN_PROGRAM_UP/_DOWN(SDARS receiver increments or decrements the channelID
     * or SID value and continues to search for next available channel in the specified Broadcast CategoryType(1 to 63))
     * or Virtual CategoryType(257 to 319).
     * In all other channel selection modes this parameter has no effect on channel selection.</p>
     * <p>Note 7:
     * In all modes of channel selection, it is used for updating the value of "User Search Category"(FktID: 0x75).</p>
     *
     * @param CategoryType The value which will be set
     */
    inline void setCategoryType (uint16 CategoryType_);

    // API of field "Steps"

    static const int kSteps = 3;

    /**
     * Clears the field "Steps".
     *
     * The field will be set to its default value. The hasSteps()
     * method will return false.
     */
    inline void clearSteps();

    /**
     * Checks whether the field "Steps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSteps()). Otherwise it will return false.
     */
    inline bool hasSteps () const;

    /**
     * Returns the value of the member "Steps".
     *
     * <p>This value will determine the number of relative channel increment/decrement based on the selection mode.</p>
     * <p>Steps will be considered in the case of selection mode XMTUN_PROGRAM_UP/_DOWN and  XMTUN_CHANNEL_UP/_DOWN
     * - ignored otherwise. Default value of step is set to 1.</p>
     * <p>e.g. Current Channel = 5, Channel line-up = 5, 10, 11, 12, 19, 88, 103, 220, 227,229. XMTUN_CHANNEL_UP with "Steps" = 6
     * will select channel 103.</p>
     *
     * @return The value of the field "Steps"
     */
    inline uint8 getSteps () const;

    /**
     * Sets the value of the member "Steps".
     *
     * <p>This value will determine the number of relative channel increment/decrement based on the selection mode.</p>
     * <p>Steps will be considered in the case of selection mode XMTUN_PROGRAM_UP/_DOWN and  XMTUN_CHANNEL_UP/_DOWN
     * - ignored otherwise. Default value of step is set to 1.</p>
     * <p>e.g. Current Channel = 5, Channel line-up = 5, 10, 11, 12, 19, 88, 103, 220, 227,229. XMTUN_CHANNEL_UP with "Steps" = 6
     * will select channel 103.</p>
     *
     * @param Steps The value which will be set
     */
    inline void setSteps (uint8 Steps_);

    static const SelectChannelStart &getDefaultInstance();

private:

    inline void set_has_SelectionMode ();

    inline void clear_has_SelectionMode ();

    inline void set_has_CidOrSid ();

    inline void clear_has_CidOrSid ();

    inline void set_has_CategoryType ();

    inline void clear_has_CategoryType ();

    inline void set_has_Steps ();

    inline void clear_has_Steps ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_SelectChannelMode _SelectionMode;

    uint16 _CidOrSid;

    uint16 _CategoryType;

    uint8 _Steps;

};

/**
 * The result message of the method "SelectChannel"
 * "Select an audio channel"
 * <p>@Figure fileName = ../figures/XM_Tuner_SelectChannel.gif width =</p>
 * Result of method
 */
class SelectChannelResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectChannelResult ();

    /**
     * Copy constructor
     */
    inline  SelectChannelResult (const SelectChannelResult &rhs);

    /**
     * All fields constructor
     */
    inline  SelectChannelResult (::sxm_audio_main_fi_types::T_e8_SelectChannelMode SelectionMode_, bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SelectChannelResult();

    /**
     * Assignment operator
     */
    inline SelectChannelResult& operator = (const SelectChannelResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectChannelResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectChannelResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectChannelResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectChannelResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SelectionMode"

    static const int kSelectionMode = 0;

    /**
     * Clears the field "SelectionMode".
     *
     * The field will be set to its default value. The hasSelectionMode()
     * method will return false.
     */
    inline void clearSelectionMode();

    /**
     * Checks whether the field "SelectionMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelectionMode()). Otherwise it will return false.
     */
    inline bool hasSelectionMode () const;

    /**
     * Returns the value of the member "SelectionMode".
     *
     * Requested Mode for selecting the Channel
     *
     * @return The value of the field "SelectionMode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_SelectChannelMode getSelectionMode () const;

    /**
     * Sets the value of the member "SelectionMode".
     *
     * Requested Mode for selecting the Channel
     *
     * @param SelectionMode The value which will be set
     */
    inline void setSelectionMode (::sxm_audio_main_fi_types::T_e8_SelectChannelMode SelectionMode_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * The method result denotes "sending of channel select message to tuner module is success or failed".
     * <p>NOTE:-The actual result of channel select will be updated through
     * proporties "ChannelInformation"    and "SystemMessage".</p>
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * The method result denotes "sending of channel select message to tuner module is success or failed".
     * <p>NOTE:-The actual result of channel select will be updated through
     * proporties "ChannelInformation"    and "SystemMessage".</p>
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SelectChannelResult &getDefaultInstance();

private:

    inline void set_has_SelectionMode ();

    inline void clear_has_SelectionMode ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_SelectChannelMode _SelectionMode;

    bool _Status;

};

/**
 * The error message of 'SelectChannel'
 */
class SelectChannelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SelectChannelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SelectChannelErrorStructure (const SelectChannelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SelectChannelErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SelectChannelErrorStructure();

    /**
     * Assignment operator
     */
    inline SelectChannelErrorStructure& operator = (const SelectChannelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectChannelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectChannelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectChannelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectChannelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SelectChannelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SelectChannel'
 */
class SelectChannelError  : public ::asf::core::Payload {
public:

    enum SelectChannelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SelectChannelError ();

   /**
     * Copy constructor
     */
    inline  SelectChannelError (const SelectChannelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SelectChannelError();

    /**
     * Assigns a new value to this object.
     */
    inline SelectChannelError& operator = (const SelectChannelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectChannelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectChannelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectChannelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectChannelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SelectChannelError::SelectChannelErrorField getField () const;

    inline void setField(SelectChannelError::SelectChannelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SelectChannelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SelectChannelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SelectChannelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SelectChannelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SelectChannelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SelectChannelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SelectChannelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SelectChannelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SelectChannelError &getDefaultInstance();

private:

    inline void cloneData (const SelectChannelError& rhs);

    inline void deleteData ();

    SelectChannelErrorField __field;

    union {
        SelectChannelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SelectChannelWithDwellTime"
 * Select an audio channel with a delay. This method is used in the Manual
 * Tuning by scrolling. The channel selection
 * will be made only after the expiry of the dwell time. In case a
 * new selection happens before the timer expiry, the timer will be
 * restarted.
 * Select channel with dwell time
 */
class SelectChannelWithDwellTimeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectChannelWithDwellTimeStart ();

    /**
     * Copy constructor
     */
    inline  SelectChannelWithDwellTimeStart (const SelectChannelWithDwellTimeStart &rhs);

    /**
     * All fields constructor
     */
    inline  SelectChannelWithDwellTimeStart (::sxm_audio_main_fi_types::T_e8_SelectChannelMode SelectionMode_, uint16 CidOrSid_, uint16 CategoryType_, uint8 Steps_, uint16 DwellTime_);

    /**
     * Destructor
     */
    inline virtual  ~SelectChannelWithDwellTimeStart();

    /**
     * Assignment operator
     */
    inline SelectChannelWithDwellTimeStart& operator = (const SelectChannelWithDwellTimeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectChannelWithDwellTimeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectChannelWithDwellTimeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectChannelWithDwellTimeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectChannelWithDwellTimeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SelectionMode"

    static const int kSelectionMode = 0;

    /**
     * Clears the field "SelectionMode".
     *
     * The field will be set to its default value. The hasSelectionMode()
     * method will return false.
     */
    inline void clearSelectionMode();

    /**
     * Checks whether the field "SelectionMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelectionMode()). Otherwise it will return false.
     */
    inline bool hasSelectionMode () const;

    /**
     * Returns the value of the member "SelectionMode".
     *
     * Mode for selecting the channel.
     *
     * @return The value of the field "SelectionMode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_SelectChannelMode getSelectionMode () const;

    /**
     * Sets the value of the member "SelectionMode".
     *
     * Mode for selecting the channel.
     *
     * @param SelectionMode The value which will be set
     */
    inline void setSelectionMode (::sxm_audio_main_fi_types::T_e8_SelectChannelMode SelectionMode_);

    // API of field "CidOrSid"

    static const int kCidOrSid = 1;

    /**
     * Clears the field "CidOrSid".
     *
     * The field will be set to its default value. The hasCidOrSid()
     * method will return false.
     */
    inline void clearCidOrSid();

    /**
     * Checks whether the field "CidOrSid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCidOrSid()). Otherwise it will return false.
     */
    inline bool hasCidOrSid () const;

    /**
     * Returns the value of the member "CidOrSid".
     *
     * ChannelIdentifier or ServiceIdentifier.
     * <p>XMTUN_SELECT_CHANNEL_UP or  CHANNEL_DOWN: This value will be ignored.</p>
     * <p>XMTUN_SELECT_PROGRAM_UP or PROGRAM_DOWN: In the case of CategoryType = 255 this value will be
     * ignored too. If the CategorType is broadcast 1 to 63 or virtual 257 to 319 and this value is set, the first available Channel
     * in the specified category will be select.</p>
     *
     * @return The value of the field "CidOrSid"
     */
    inline uint16 getCidOrSid () const;

    /**
     * Sets the value of the member "CidOrSid".
     *
     * ChannelIdentifier or ServiceIdentifier.
     * <p>XMTUN_SELECT_CHANNEL_UP or  CHANNEL_DOWN: This value will be ignored.</p>
     * <p>XMTUN_SELECT_PROGRAM_UP or PROGRAM_DOWN: In the case of CategoryType = 255 this value will be
     * ignored too. If the CategorType is broadcast 1 to 63 or virtual 257 to 319 and this value is set, the first available Channel
     * in the specified category will be select.</p>
     *
     * @param CidOrSid The value which will be set
     */
    inline void setCidOrSid (uint16 CidOrSid_);

    // API of field "CategoryType"

    static const int kCategoryType = 2;

    /**
     * Clears the field "CategoryType".
     *
     * The field will be set to its default value. The hasCategoryType()
     * method will return false.
     */
    inline void clearCategoryType();

    /**
     * Checks whether the field "CategoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryType()). Otherwise it will return false.
     */
    inline bool hasCategoryType () const;

    /**
     * Returns the value of the member "CategoryType".
     *
     * Valid Range: "0,1 to 31, 254 or 255".
     * <p>Note 1:
     * 0 denotes the next or previews category up or down from the actual category.</p>
     * <p>Note 2:
     * 1 o 31 denotes the new category by the category number.</p>
     * <p>Note 3:
     * 254 denotes current category. If the actual channel the last or first channel in the actual categorie list,
     * the first or last channel of the
     * categorie behind or before will be select.</p>
     * <p>Note 4:
     * 255 denotes current category. (The category of the current active channel)
     * If current active channel is 0 or current Channel belongs to Category 0,
     * then PROGRAM_UP and PROGRAM_DOWN request with CategoryType = 255 would fail.</p>
     * <p>Note 5:
     * This parameter used for sending the CBM request only in
     * case of selection modes XMTUN_PROGRAM_UP/_DOWN(SDARS receiver increments or decrements the channelID or SID
     * value and continues to search for next available channel in the specified CategoryType(1 to 63 or 257 to 319)).
     * In all other channel selection modes this parameter has no effect on channel selection.</p>
     * <p>Note 6:
     * In all modes of channel selection, it is used for updating the value of "User Search Category"(FktID: 0x75).</p>
     *
     * @return The value of the field "CategoryType"
     */
    inline uint16 getCategoryType () const;

    /**
     * Sets the value of the member "CategoryType".
     *
     * Valid Range: "0,1 to 31, 254 or 255".
     * <p>Note 1:
     * 0 denotes the next or previews category up or down from the actual category.</p>
     * <p>Note 2:
     * 1 o 31 denotes the new category by the category number.</p>
     * <p>Note 3:
     * 254 denotes current category. If the actual channel the last or first channel in the actual categorie list,
     * the first or last channel of the
     * categorie behind or before will be select.</p>
     * <p>Note 4:
     * 255 denotes current category. (The category of the current active channel)
     * If current active channel is 0 or current Channel belongs to Category 0,
     * then PROGRAM_UP and PROGRAM_DOWN request with CategoryType = 255 would fail.</p>
     * <p>Note 5:
     * This parameter used for sending the CBM request only in
     * case of selection modes XMTUN_PROGRAM_UP/_DOWN(SDARS receiver increments or decrements the channelID or SID
     * value and continues to search for next available channel in the specified CategoryType(1 to 63 or 257 to 319)).
     * In all other channel selection modes this parameter has no effect on channel selection.</p>
     * <p>Note 6:
     * In all modes of channel selection, it is used for updating the value of "User Search Category"(FktID: 0x75).</p>
     *
     * @param CategoryType The value which will be set
     */
    inline void setCategoryType (uint16 CategoryType_);

    // API of field "Steps"

    static const int kSteps = 3;

    /**
     * Clears the field "Steps".
     *
     * The field will be set to its default value. The hasSteps()
     * method will return false.
     */
    inline void clearSteps();

    /**
     * Checks whether the field "Steps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSteps()). Otherwise it will return false.
     */
    inline bool hasSteps () const;

    /**
     * Returns the value of the member "Steps".
     *
     * This value will determine the number of relative channel increment/decrement based on the selection mode.
     * Steps will be considered in the case of selection mode XMTUN_PROGRAM_UP/_DOWN and
     * XMTUN_CHANNEL_UP/_DOWN - ignored otherwise. Default value of step is set to 1.
     * e.g. Current Channel = 5, Channel line-up = 5, 10, 11, 12, 19, 88, 103, 220, 227,229.
     * XMTUN_CHANNEL_UP with "Steps" = 6 will select channel 103.
     *
     * @return The value of the field "Steps"
     */
    inline uint8 getSteps () const;

    /**
     * Sets the value of the member "Steps".
     *
     * This value will determine the number of relative channel increment/decrement based on the selection mode.
     * Steps will be considered in the case of selection mode XMTUN_PROGRAM_UP/_DOWN and
     * XMTUN_CHANNEL_UP/_DOWN - ignored otherwise. Default value of step is set to 1.
     * e.g. Current Channel = 5, Channel line-up = 5, 10, 11, 12, 19, 88, 103, 220, 227,229.
     * XMTUN_CHANNEL_UP with "Steps" = 6 will select channel 103.
     *
     * @param Steps The value which will be set
     */
    inline void setSteps (uint8 Steps_);

    // API of field "DwellTime"

    static const int kDwellTime = 4;

    /**
     * Clears the field "DwellTime".
     *
     * The field will be set to its default value. The hasDwellTime()
     * method will return false.
     */
    inline void clearDwellTime();

    /**
     * Checks whether the field "DwellTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDwellTime()). Otherwise it will return false.
     */
    inline bool hasDwellTime () const;

    /**
     * Returns the value of the member "DwellTime".
     *
     * Dwell time in ms.
     *
     * @return The value of the field "DwellTime"
     */
    inline uint16 getDwellTime () const;

    /**
     * Sets the value of the member "DwellTime".
     *
     * Dwell time in ms.
     *
     * @param DwellTime The value which will be set
     */
    inline void setDwellTime (uint16 DwellTime_);

    static const SelectChannelWithDwellTimeStart &getDefaultInstance();

private:

    inline void set_has_SelectionMode ();

    inline void clear_has_SelectionMode ();

    inline void set_has_CidOrSid ();

    inline void clear_has_CidOrSid ();

    inline void set_has_CategoryType ();

    inline void clear_has_CategoryType ();

    inline void set_has_Steps ();

    inline void clear_has_Steps ();

    inline void set_has_DwellTime ();

    inline void clear_has_DwellTime ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_SelectChannelMode _SelectionMode;

    uint16 _CidOrSid;

    uint16 _CategoryType;

    uint8 _Steps;

    uint16 _DwellTime;

};

/**
 * The result message of the method "SelectChannelWithDwellTime"
 * Select an audio channel with a delay. This method is used in the Manual
 * Tuning by scrolling. The channel selection
 * will be made only after the expiry of the dwell time. In case a
 * new selection happens before the timer expiry, the timer will be
 * restarted.
 * MethodResult will be used for MethodAbort
 */
class SelectChannelWithDwellTimeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectChannelWithDwellTimeResult ();

    /**
     * Copy constructor
     */
    inline  SelectChannelWithDwellTimeResult (const SelectChannelWithDwellTimeResult &rhs);

    /**
     * All fields constructor
     */
    inline  SelectChannelWithDwellTimeResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SelectChannelWithDwellTimeResult();

    /**
     * Assignment operator
     */
    inline SelectChannelWithDwellTimeResult& operator = (const SelectChannelWithDwellTimeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectChannelWithDwellTimeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectChannelWithDwellTimeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectChannelWithDwellTimeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectChannelWithDwellTimeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Abort was successful or not. TRUE on success and FALSE on failure.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Abort was successful or not. TRUE on success and FALSE on failure.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SelectChannelWithDwellTimeResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SelectChannelWithDwellTime'
 */
class SelectChannelWithDwellTimeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SelectChannelWithDwellTimeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SelectChannelWithDwellTimeErrorStructure (const SelectChannelWithDwellTimeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SelectChannelWithDwellTimeErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SelectChannelWithDwellTimeErrorStructure();

    /**
     * Assignment operator
     */
    inline SelectChannelWithDwellTimeErrorStructure& operator = (const SelectChannelWithDwellTimeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectChannelWithDwellTimeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectChannelWithDwellTimeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectChannelWithDwellTimeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectChannelWithDwellTimeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SelectChannelWithDwellTimeErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SelectChannelWithDwellTime'
 */
class SelectChannelWithDwellTimeError  : public ::asf::core::Payload {
public:

    enum SelectChannelWithDwellTimeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SelectChannelWithDwellTimeError ();

   /**
     * Copy constructor
     */
    inline  SelectChannelWithDwellTimeError (const SelectChannelWithDwellTimeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SelectChannelWithDwellTimeError();

    /**
     * Assigns a new value to this object.
     */
    inline SelectChannelWithDwellTimeError& operator = (const SelectChannelWithDwellTimeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectChannelWithDwellTimeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectChannelWithDwellTimeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectChannelWithDwellTimeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectChannelWithDwellTimeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SelectChannelWithDwellTimeError::SelectChannelWithDwellTimeErrorField getField () const;

    inline void setField(SelectChannelWithDwellTimeError::SelectChannelWithDwellTimeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SelectChannelWithDwellTimeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SelectChannelWithDwellTimeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SelectChannelWithDwellTimeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SelectChannelWithDwellTimeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SelectChannelWithDwellTimeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SelectChannelWithDwellTimeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SelectChannelWithDwellTimeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SelectChannelWithDwellTimeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SelectChannelWithDwellTimeError &getDefaultInstance();

private:

    inline void cloneData (const SelectChannelWithDwellTimeError& rhs);

    inline void deleteData ();

    SelectChannelWithDwellTimeErrorField __field;

    union {
        SelectChannelWithDwellTimeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "StorePreset"
 * Store the current tuned station to one preset of the preset list
 * Start method and get cyclic messages while processing and get the result
 * when finished "OPTYPE_STARTRESULT"
 */
class StorePresetStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StorePresetStart ();

    /**
     * Copy constructor
     */
    inline  StorePresetStart (const StorePresetStart &rhs);

    /**
     * All fields constructor
     */
    inline  StorePresetStart (uint8 PresetElement_);

    /**
     * Destructor
     */
    inline virtual  ~StorePresetStart();

    /**
     * Assignment operator
     */
    inline StorePresetStart& operator = (const StorePresetStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StorePresetStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StorePresetStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StorePresetStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StorePresetStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PresetElement"

    static const int kPresetElement = 0;

    /**
     * Clears the field "PresetElement".
     *
     * The field will be set to its default value. The hasPresetElement()
     * method will return false.
     */
    inline void clearPresetElement();

    /**
     * Checks whether the field "PresetElement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetElement()). Otherwise it will return false.
     */
    inline bool hasPresetElement () const;

    /**
     * Returns the value of the member "PresetElement".
     *
     * Identify the preset
     *
     * @return The value of the field "PresetElement"
     */
    inline uint8 getPresetElement () const;

    /**
     * Sets the value of the member "PresetElement".
     *
     * Identify the preset
     *
     * @param PresetElement The value which will be set
     */
    inline void setPresetElement (uint8 PresetElement_);

    static const StorePresetStart &getDefaultInstance();

private:

    inline void set_has_PresetElement ();

    inline void clear_has_PresetElement ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PresetElement;

};

/**
 * The result message of the method "StorePreset"
 * Store the current tuned station to one preset of the preset list
 * Result of method
 */
class StorePresetResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StorePresetResult ();

    /**
     * Copy constructor
     */
    inline  StorePresetResult (const StorePresetResult &rhs);

    /**
     * All fields constructor
     */
    inline  StorePresetResult (uint8 PresetElement_, const ::std::vector< ::sxm_audio_main_fi_types::T_SmartFavoritePreset >& SmartFavoriteList_, bool Status_, const ::sxm_audio_main_fi_types::T_PresetListEntry& PresetListElement_);

    /**
     * Destructor
     */
    inline virtual  ~StorePresetResult();

    /**
     * Assignment operator
     */
    inline StorePresetResult& operator = (const StorePresetResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StorePresetResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StorePresetResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StorePresetResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StorePresetResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PresetElement"

    static const int kPresetElement = 0;

    /**
     * Clears the field "PresetElement".
     *
     * The field will be set to its default value. The hasPresetElement()
     * method will return false.
     */
    inline void clearPresetElement();

    /**
     * Checks whether the field "PresetElement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetElement()). Otherwise it will return false.
     */
    inline bool hasPresetElement () const;

    /**
     * Returns the value of the member "PresetElement".
     *
     * Identify the preset
     *
     * @return The value of the field "PresetElement"
     */
    inline uint8 getPresetElement () const;

    /**
     * Sets the value of the member "PresetElement".
     *
     * Identify the preset
     *
     * @param PresetElement The value which will be set
     */
    inline void setPresetElement (uint8 PresetElement_);

    // API of field "SmartFavoriteList"

    static const int kSmartFavoriteList = 1;

    /**
     * Clears the field "SmartFavoriteList".
     *
     * The field will be set to its default value. The hasSmartFavoriteList()
     * method will return false.
     */
    inline void clearSmartFavoriteList();

    /**
     * Checks whether the field "SmartFavoriteList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSmartFavoriteList()). Otherwise it will return false.
     */
    inline bool hasSmartFavoriteList () const;

    /**
     * Returns the value of the member "SmartFavoriteList".
     *
     * Subset of Smart favorite list containing preset index and smart favorite flag
     *
     * @return The value of the field "SmartFavoriteList"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_SmartFavoritePreset >& getSmartFavoriteList () const;

    /**
     * Retrieves the value of the field "SmartFavoriteList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SmartFavoriteList".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_SmartFavoritePreset >& getSmartFavoriteListMutable ();

    /**
     * Sets the value of the member "SmartFavoriteList".
     *
     * Subset of Smart favorite list containing preset index and smart favorite flag
     *
     * @param SmartFavoriteList The value which will be set
     */
    inline void setSmartFavoriteList (const ::std::vector< ::sxm_audio_main_fi_types::T_SmartFavoritePreset >& SmartFavoriteList_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Storing was successful or not. TRUE on success and FALSE on failure
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Storing was successful or not. TRUE on success and FALSE on failure
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    // API of field "PresetListElement"

    static const int kPresetListElement = 3;

    /**
     * Clears the field "PresetListElement".
     *
     * The field will be set to its default value. The hasPresetListElement()
     * method will return false.
     */
    inline void clearPresetListElement();

    /**
     * Checks whether the field "PresetListElement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetListElement()). Otherwise it will return false.
     */
    inline bool hasPresetListElement () const;

    /**
     * Returns the value of the member "PresetListElement".
     *
     * Preset list element containing channel info (ServiceID, ChannelID, ChannelName)
     *
     * @return The value of the field "PresetListElement"
     */
    inline const ::sxm_audio_main_fi_types::T_PresetListEntry& getPresetListElement () const;

    /**
     * Retrieves the value of the field "PresetListElement" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PresetListElement".
     */
    inline ::sxm_audio_main_fi_types::T_PresetListEntry& getPresetListElementMutable ();

    /**
     * Sets the value of the member "PresetListElement".
     *
     * Preset list element containing channel info (ServiceID, ChannelID, ChannelName)
     *
     * @param PresetListElement The value which will be set
     */
    inline void setPresetListElement (const ::sxm_audio_main_fi_types::T_PresetListEntry& PresetListElement_);

    static const StorePresetResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_SmartFavoritePreset >& getT_SmartFavoritePresetList_DefaultInstance ();

    inline void set_has_PresetElement ();

    inline void clear_has_PresetElement ();

    inline void set_has_SmartFavoriteList ();

    inline void clear_has_SmartFavoriteList ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    inline void set_has_PresetListElement ();

    inline void clear_has_PresetListElement ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _PresetElement;

    ::std::vector< ::sxm_audio_main_fi_types::T_SmartFavoritePreset > _SmartFavoriteList;

    bool _Status;

    ::sxm_audio_main_fi_types::T_PresetListEntry _PresetListElement;

};

/**
 * The error message of 'StorePreset'
 */
class StorePresetErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  StorePresetErrorStructure ();

    /**
     * Copy constructor
     */
    inline  StorePresetErrorStructure (const StorePresetErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  StorePresetErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~StorePresetErrorStructure();

    /**
     * Assignment operator
     */
    inline StorePresetErrorStructure& operator = (const StorePresetErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StorePresetErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StorePresetErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StorePresetErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StorePresetErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const StorePresetErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'StorePreset'
 */
class StorePresetError  : public ::asf::core::Payload {
public:

    enum StorePresetErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  StorePresetError ();

   /**
     * Copy constructor
     */
    inline  StorePresetError (const StorePresetError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~StorePresetError();

    /**
     * Assigns a new value to this object.
     */
    inline StorePresetError& operator = (const StorePresetError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StorePresetError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StorePresetError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StorePresetError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StorePresetError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline StorePresetError::StorePresetErrorField getField () const;

    inline void setField(StorePresetError::StorePresetErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "StorePresetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "StorePresetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const StorePresetErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline StorePresetErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline StorePresetErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (StorePresetErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "StorePresetErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const StorePresetErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const StorePresetError &getDefaultInstance();

private:

    inline void cloneData (const StorePresetError& rhs);

    inline void deleteData ();

    StorePresetErrorField __field;

    union {
        StorePresetErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RecallPreset"
 * Recall one preset of the preset list identified by PresetElement
 * Start method and get cyclic messages while processing and
 * get the result when finished "OPTYPE_STARTRESULT"
 */
class RecallPresetStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RecallPresetStart ();

    /**
     * Copy constructor
     */
    inline  RecallPresetStart (const RecallPresetStart &rhs);

    /**
     * All fields constructor
     */
    inline  RecallPresetStart (uint8 PresetElement_);

    /**
     * Destructor
     */
    inline virtual  ~RecallPresetStart();

    /**
     * Assignment operator
     */
    inline RecallPresetStart& operator = (const RecallPresetStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecallPresetStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecallPresetStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecallPresetStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecallPresetStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PresetElement"

    static const int kPresetElement = 0;

    /**
     * Clears the field "PresetElement".
     *
     * The field will be set to its default value. The hasPresetElement()
     * method will return false.
     */
    inline void clearPresetElement();

    /**
     * Checks whether the field "PresetElement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetElement()). Otherwise it will return false.
     */
    inline bool hasPresetElement () const;

    /**
     * Returns the value of the member "PresetElement".
     *
     * Identify the preset
     *
     * @return The value of the field "PresetElement"
     */
    inline uint8 getPresetElement () const;

    /**
     * Sets the value of the member "PresetElement".
     *
     * Identify the preset
     *
     * @param PresetElement The value which will be set
     */
    inline void setPresetElement (uint8 PresetElement_);

    static const RecallPresetStart &getDefaultInstance();

private:

    inline void set_has_PresetElement ();

    inline void clear_has_PresetElement ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PresetElement;

};

/**
 * The result message of the method "RecallPreset"
 * Recall one preset of the preset list identified by PresetElement
 * Result of a method
 */
class RecallPresetResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RecallPresetResult ();

    /**
     * Copy constructor
     */
    inline  RecallPresetResult (const RecallPresetResult &rhs);

    /**
     * All fields constructor
     */
    inline  RecallPresetResult (uint8 PresetElement_, bool Status_, const ::sxm_audio_main_fi_types::T_PresetListEntry& PresetListElement_);

    /**
     * Destructor
     */
    inline virtual  ~RecallPresetResult();

    /**
     * Assignment operator
     */
    inline RecallPresetResult& operator = (const RecallPresetResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecallPresetResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecallPresetResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecallPresetResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecallPresetResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PresetElement"

    static const int kPresetElement = 0;

    /**
     * Clears the field "PresetElement".
     *
     * The field will be set to its default value. The hasPresetElement()
     * method will return false.
     */
    inline void clearPresetElement();

    /**
     * Checks whether the field "PresetElement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetElement()). Otherwise it will return false.
     */
    inline bool hasPresetElement () const;

    /**
     * Returns the value of the member "PresetElement".
     *
     * Identify the preset
     *
     * @return The value of the field "PresetElement"
     */
    inline uint8 getPresetElement () const;

    /**
     * Sets the value of the member "PresetElement".
     *
     * Identify the preset
     *
     * @param PresetElement The value which will be set
     */
    inline void setPresetElement (uint8 PresetElement_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Recalling was successful or not. TRUE on success and FALSE on failure
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Recalling was successful or not. TRUE on success and FALSE on failure
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    // API of field "PresetListElement"

    static const int kPresetListElement = 2;

    /**
     * Clears the field "PresetListElement".
     *
     * The field will be set to its default value. The hasPresetListElement()
     * method will return false.
     */
    inline void clearPresetListElement();

    /**
     * Checks whether the field "PresetListElement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetListElement()). Otherwise it will return false.
     */
    inline bool hasPresetListElement () const;

    /**
     * Returns the value of the member "PresetListElement".
     *
     * An update of the preset list element containing channel info (ServiceID, ChannelID, ChannelName)
     *
     * @return The value of the field "PresetListElement"
     */
    inline const ::sxm_audio_main_fi_types::T_PresetListEntry& getPresetListElement () const;

    /**
     * Retrieves the value of the field "PresetListElement" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PresetListElement".
     */
    inline ::sxm_audio_main_fi_types::T_PresetListEntry& getPresetListElementMutable ();

    /**
     * Sets the value of the member "PresetListElement".
     *
     * An update of the preset list element containing channel info (ServiceID, ChannelID, ChannelName)
     *
     * @param PresetListElement The value which will be set
     */
    inline void setPresetListElement (const ::sxm_audio_main_fi_types::T_PresetListEntry& PresetListElement_);

    static const RecallPresetResult &getDefaultInstance();

private:

    inline void set_has_PresetElement ();

    inline void clear_has_PresetElement ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    inline void set_has_PresetListElement ();

    inline void clear_has_PresetListElement ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _PresetElement;

    bool _Status;

    ::sxm_audio_main_fi_types::T_PresetListEntry _PresetListElement;

};

/**
 * The error message of 'RecallPreset'
 */
class RecallPresetErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RecallPresetErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RecallPresetErrorStructure (const RecallPresetErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RecallPresetErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~RecallPresetErrorStructure();

    /**
     * Assignment operator
     */
    inline RecallPresetErrorStructure& operator = (const RecallPresetErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecallPresetErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecallPresetErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecallPresetErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecallPresetErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const RecallPresetErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'RecallPreset'
 */
class RecallPresetError  : public ::asf::core::Payload {
public:

    enum RecallPresetErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RecallPresetError ();

   /**
     * Copy constructor
     */
    inline  RecallPresetError (const RecallPresetError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RecallPresetError();

    /**
     * Assigns a new value to this object.
     */
    inline RecallPresetError& operator = (const RecallPresetError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecallPresetError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecallPresetError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecallPresetError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecallPresetError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RecallPresetError::RecallPresetErrorField getField () const;

    inline void setField(RecallPresetError::RecallPresetErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RecallPresetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RecallPresetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RecallPresetErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RecallPresetErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RecallPresetErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RecallPresetErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RecallPresetErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RecallPresetErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RecallPresetError &getDefaultInstance();

private:

    inline void cloneData (const RecallPresetError& rhs);

    inline void deleteData ();

    RecallPresetErrorField __field;

    union {
        RecallPresetErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetAutoCompareParameters"
 * Set the autocompare parameters.This can be used by the client to
 * set the range of preset elements in the current user selected favourite page.
 * The xmtuner application performs the autocompare only on preset elements
 * which falls in this range. If there is no autocompare match found in this range,
 * then xmtuner update zero as aurocompare range.
 * Set the autocompare parameters
 */
class SetAutoCompareParametersStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAutoCompareParametersStart ();

    /**
     * Copy constructor
     */
    inline  SetAutoCompareParametersStart (const SetAutoCompareParametersStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetAutoCompareParametersStart (uint8 u8FirstElement_, uint8 u8LastElement_);

    /**
     * Destructor
     */
    inline virtual  ~SetAutoCompareParametersStart();

    /**
     * Assignment operator
     */
    inline SetAutoCompareParametersStart& operator = (const SetAutoCompareParametersStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutoCompareParametersStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutoCompareParametersStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutoCompareParametersStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutoCompareParametersStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8FirstElement"

    static const int kU8FirstElement = 0;

    /**
     * Clears the field "u8FirstElement".
     *
     * The field will be set to its default value. The hasU8FirstElement()
     * method will return false.
     */
    inline void clearU8FirstElement();

    /**
     * Checks whether the field "u8FirstElement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FirstElement()). Otherwise it will return false.
     */
    inline bool hasU8FirstElement () const;

    /**
     * Returns the value of the member "u8FirstElement".
     *
     * First element of the autocompare range. Default value is 1
     *
     * @return The value of the field "u8FirstElement"
     */
    inline uint8 getU8FirstElement () const;

    /**
     * Sets the value of the member "u8FirstElement".
     *
     * First element of the autocompare range. Default value is 1
     *
     * @param u8FirstElement The value which will be set
     */
    inline void setU8FirstElement (uint8 u8FirstElement_);

    // API of field "u8LastElement"

    static const int kU8LastElement = 1;

    /**
     * Clears the field "u8LastElement".
     *
     * The field will be set to its default value. The hasU8LastElement()
     * method will return false.
     */
    inline void clearU8LastElement();

    /**
     * Checks whether the field "u8LastElement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LastElement()). Otherwise it will return false.
     */
    inline bool hasU8LastElement () const;

    /**
     * Returns the value of the member "u8LastElement".
     *
     * Last element of the autocompare range. Default value is 18
     *
     * @return The value of the field "u8LastElement"
     */
    inline uint8 getU8LastElement () const;

    /**
     * Sets the value of the member "u8LastElement".
     *
     * Last element of the autocompare range. Default value is 18
     *
     * @param u8LastElement The value which will be set
     */
    inline void setU8LastElement (uint8 u8LastElement_);

    static const SetAutoCompareParametersStart &getDefaultInstance();

private:

    inline void set_has_u8FirstElement ();

    inline void clear_has_u8FirstElement ();

    inline void set_has_u8LastElement ();

    inline void clear_has_u8LastElement ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8FirstElement;

    uint8 _u8LastElement;

};

/**
 * The result message of the method "SetAutoCompareParameters"
 * Set the autocompare parameters.This can be used by the client to
 * set the range of preset elements in the current user selected favourite page.
 * The xmtuner application performs the autocompare only on preset elements
 * which falls in this range. If there is no autocompare match found in this range,
 * then xmtuner update zero as aurocompare range.
 * Result of method
 */
class SetAutoCompareParametersResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAutoCompareParametersResult ();

    /**
     * Copy constructor
     */
    inline  SetAutoCompareParametersResult (const SetAutoCompareParametersResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetAutoCompareParametersResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetAutoCompareParametersResult();

    /**
     * Assignment operator
     */
    inline SetAutoCompareParametersResult& operator = (const SetAutoCompareParametersResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutoCompareParametersResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutoCompareParametersResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutoCompareParametersResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutoCompareParametersResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if Autocompare Parameter is set successfully.
     * FALSE if Failed to set autocompare parameter.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if Autocompare Parameter is set successfully.
     * FALSE if Failed to set autocompare parameter.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetAutoCompareParametersResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SetAutoCompareParameters'
 */
class SetAutoCompareParametersErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetAutoCompareParametersErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetAutoCompareParametersErrorStructure (const SetAutoCompareParametersErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetAutoCompareParametersErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetAutoCompareParametersErrorStructure();

    /**
     * Assignment operator
     */
    inline SetAutoCompareParametersErrorStructure& operator = (const SetAutoCompareParametersErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutoCompareParametersErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutoCompareParametersErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutoCompareParametersErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutoCompareParametersErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of the error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of the error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SetAutoCompareParametersErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SetAutoCompareParameters'
 */
class SetAutoCompareParametersError  : public ::asf::core::Payload {
public:

    enum SetAutoCompareParametersErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetAutoCompareParametersError ();

   /**
     * Copy constructor
     */
    inline  SetAutoCompareParametersError (const SetAutoCompareParametersError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetAutoCompareParametersError();

    /**
     * Assigns a new value to this object.
     */
    inline SetAutoCompareParametersError& operator = (const SetAutoCompareParametersError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutoCompareParametersError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutoCompareParametersError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutoCompareParametersError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutoCompareParametersError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetAutoCompareParametersError::SetAutoCompareParametersErrorField getField () const;

    inline void setField(SetAutoCompareParametersError::SetAutoCompareParametersErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetAutoCompareParametersErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetAutoCompareParametersErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetAutoCompareParametersErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetAutoCompareParametersErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetAutoCompareParametersErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetAutoCompareParametersErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetAutoCompareParametersErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetAutoCompareParametersErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetAutoCompareParametersError &getDefaultInstance();

private:

    inline void cloneData (const SetAutoCompareParametersError& rhs);

    inline void deleteData ();

    SetAutoCompareParametersErrorField __field;

    union {
        SetAutoCompareParametersErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetDestinationPosition"
 * Set the destination position from HMI. This can be used to set latitude
 * and longitude for required data services.
 * Set the Destination Position
 */
class SetDestinationPositionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDestinationPositionStart ();

    /**
     * Copy constructor
     */
    inline  SetDestinationPositionStart (const SetDestinationPositionStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetDestinationPositionStart (int32 s32Latitude_, int32 s32Longitude_);

    /**
     * Destructor
     */
    inline virtual  ~SetDestinationPositionStart();

    /**
     * Assignment operator
     */
    inline SetDestinationPositionStart& operator = (const SetDestinationPositionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDestinationPositionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDestinationPositionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDestinationPositionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDestinationPositionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32Latitude"

    static const int kS32Latitude = 0;

    /**
     * Clears the field "s32Latitude".
     *
     * The field will be set to its default value. The hasS32Latitude()
     * method will return false.
     */
    inline void clearS32Latitude();

    /**
     * Checks whether the field "s32Latitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32Latitude()). Otherwise it will return false.
     */
    inline bool hasS32Latitude () const;

    /**
     * Returns the value of the member "s32Latitude".
     *
     * Latitude of the Destination Position. Default value is 0
     *
     * @return The value of the field "s32Latitude"
     */
    inline int32 getS32Latitude () const;

    /**
     * Sets the value of the member "s32Latitude".
     *
     * Latitude of the Destination Position. Default value is 0
     *
     * @param s32Latitude The value which will be set
     */
    inline void setS32Latitude (int32 s32Latitude_);

    // API of field "s32Longitude"

    static const int kS32Longitude = 1;

    /**
     * Clears the field "s32Longitude".
     *
     * The field will be set to its default value. The hasS32Longitude()
     * method will return false.
     */
    inline void clearS32Longitude();

    /**
     * Checks whether the field "s32Longitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32Longitude()). Otherwise it will return false.
     */
    inline bool hasS32Longitude () const;

    /**
     * Returns the value of the member "s32Longitude".
     *
     * Longitude of the Destination Position. Default value is 0
     *
     * @return The value of the field "s32Longitude"
     */
    inline int32 getS32Longitude () const;

    /**
     * Sets the value of the member "s32Longitude".
     *
     * Longitude of the Destination Position. Default value is 0
     *
     * @param s32Longitude The value which will be set
     */
    inline void setS32Longitude (int32 s32Longitude_);

    static const SetDestinationPositionStart &getDefaultInstance();

private:

    inline void set_has_s32Latitude ();

    inline void clear_has_s32Latitude ();

    inline void set_has_s32Longitude ();

    inline void clear_has_s32Longitude ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _s32Latitude;

    int32 _s32Longitude;

};

/**
 * The result message of the method "SetDestinationPosition"
 * Set the destination position from HMI. This can be used to set latitude
 * and longitude for required data services.
 * Result of method
 */
class SetDestinationPositionResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDestinationPositionResult ();

    /**
     * Copy constructor
     */
    inline  SetDestinationPositionResult (const SetDestinationPositionResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetDestinationPositionResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetDestinationPositionResult();

    /**
     * Assignment operator
     */
    inline SetDestinationPositionResult& operator = (const SetDestinationPositionResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDestinationPositionResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDestinationPositionResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDestinationPositionResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDestinationPositionResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if Destination Position is set successfully.
     * FALSE if failed to set Destination Position.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if Destination Position is set successfully.
     * FALSE if failed to set Destination Position.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetDestinationPositionResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SetDestinationPosition'
 */
class SetDestinationPositionErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetDestinationPositionErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetDestinationPositionErrorStructure (const SetDestinationPositionErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetDestinationPositionErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetDestinationPositionErrorStructure();

    /**
     * Assignment operator
     */
    inline SetDestinationPositionErrorStructure& operator = (const SetDestinationPositionErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDestinationPositionErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDestinationPositionErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDestinationPositionErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDestinationPositionErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of the error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of the error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SetDestinationPositionErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SetDestinationPosition'
 */
class SetDestinationPositionError  : public ::asf::core::Payload {
public:

    enum SetDestinationPositionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetDestinationPositionError ();

   /**
     * Copy constructor
     */
    inline  SetDestinationPositionError (const SetDestinationPositionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetDestinationPositionError();

    /**
     * Assigns a new value to this object.
     */
    inline SetDestinationPositionError& operator = (const SetDestinationPositionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDestinationPositionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDestinationPositionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDestinationPositionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDestinationPositionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetDestinationPositionError::SetDestinationPositionErrorField getField () const;

    inline void setField(SetDestinationPositionError::SetDestinationPositionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetDestinationPositionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetDestinationPositionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetDestinationPositionErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetDestinationPositionErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetDestinationPositionErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetDestinationPositionErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetDestinationPositionErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetDestinationPositionErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetDestinationPositionError &getDefaultInstance();

private:

    inline void cloneData (const SetDestinationPositionError& rhs);

    inline void deleteData ();

    SetDestinationPositionErrorField __field;

    union {
        SetDestinationPositionErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DiagTestModeEnable"
 * Enable or Disable generation of data for developer test mode via
 * Property DiagTestModeData
 * Enable or Disable generation of data for developer test mode via
 * Property DiagTestModeData
 */
class DiagTestModeEnableStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagTestModeEnableStart ();

    /**
     * Copy constructor
     */
    inline  DiagTestModeEnableStart (const DiagTestModeEnableStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiagTestModeEnableStart (bool bEnable_);

    /**
     * Destructor
     */
    inline virtual  ~DiagTestModeEnableStart();

    /**
     * Assignment operator
     */
    inline DiagTestModeEnableStart& operator = (const DiagTestModeEnableStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagTestModeEnableStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagTestModeEnableStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagTestModeEnableStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagTestModeEnableStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEnable"

    static const int kBEnable = 0;

    /**
     * Clears the field "bEnable".
     *
     * The field will be set to its default value. The hasBEnable()
     * method will return false.
     */
    inline void clearBEnable();

    /**
     * Checks whether the field "bEnable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEnable()). Otherwise it will return false.
     */
    inline bool hasBEnable () const;

    /**
     * Returns the value of the member "bEnable".
     *
     * TRUE=enable, FALSE=disable
     *
     * @return The value of the field "bEnable"
     */
    inline bool getBEnable () const;

    /**
     * Sets the value of the member "bEnable".
     *
     * TRUE=enable, FALSE=disable
     *
     * @param bEnable The value which will be set
     */
    inline void setBEnable (bool bEnable_);

    static const DiagTestModeEnableStart &getDefaultInstance();

private:

    inline void set_has_bEnable ();

    inline void clear_has_bEnable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bEnable;

};

/**
 * The error message of 'DiagTestModeEnable'
 */
class DiagTestModeEnableErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DiagTestModeEnableErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DiagTestModeEnableErrorStructure (const DiagTestModeEnableErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DiagTestModeEnableErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DiagTestModeEnableErrorStructure();

    /**
     * Assignment operator
     */
    inline DiagTestModeEnableErrorStructure& operator = (const DiagTestModeEnableErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagTestModeEnableErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagTestModeEnableErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagTestModeEnableErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagTestModeEnableErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const DiagTestModeEnableErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'DiagTestModeEnable'
 */
class DiagTestModeEnableError  : public ::asf::core::Payload {
public:

    enum DiagTestModeEnableErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DiagTestModeEnableError ();

   /**
     * Copy constructor
     */
    inline  DiagTestModeEnableError (const DiagTestModeEnableError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DiagTestModeEnableError();

    /**
     * Assigns a new value to this object.
     */
    inline DiagTestModeEnableError& operator = (const DiagTestModeEnableError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagTestModeEnableError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagTestModeEnableError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagTestModeEnableError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagTestModeEnableError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DiagTestModeEnableError::DiagTestModeEnableErrorField getField () const;

    inline void setField(DiagTestModeEnableError::DiagTestModeEnableErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DiagTestModeEnableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DiagTestModeEnableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DiagTestModeEnableErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DiagTestModeEnableErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DiagTestModeEnableErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DiagTestModeEnableErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DiagTestModeEnableErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DiagTestModeEnableErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DiagTestModeEnableError &getDefaultInstance();

private:

    inline void cloneData (const DiagTestModeEnableError& rhs);

    inline void deleteData ();

    DiagTestModeEnableErrorField __field;

    union {
        DiagTestModeEnableErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DiagUpcValues"
 * Request for UPC values.
 * Request for UPC values.
 */
class DiagUpcValuesStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagUpcValuesStart ();

    /**
     * Copy constructor
     */
    inline  DiagUpcValuesStart (const DiagUpcValuesStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiagUpcValuesStart (uint8 GetVal_);

    /**
     * Destructor
     */
    inline virtual  ~DiagUpcValuesStart();

    /**
     * Assignment operator
     */
    inline DiagUpcValuesStart& operator = (const DiagUpcValuesStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagUpcValuesStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagUpcValuesStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagUpcValuesStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagUpcValuesStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GetVal"

    static const int kGetVal = 0;

    /**
     * Clears the field "GetVal".
     *
     * The field will be set to its default value. The hasGetVal()
     * method will return false.
     */
    inline void clearGetVal();

    /**
     * Checks whether the field "GetVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGetVal()). Otherwise it will return false.
     */
    inline bool hasGetVal () const;

    /**
     * Returns the value of the member "GetVal".
     *
     * 1 = STM
     * 2 = SXM status in Settings Menu
     *
     * @return The value of the field "GetVal"
     */
    inline uint8 getGetVal () const;

    /**
     * Sets the value of the member "GetVal".
     *
     * 1 = STM
     * 2 = SXM status in Settings Menu
     *
     * @param GetVal The value which will be set
     */
    inline void setGetVal (uint8 GetVal_);

    static const DiagUpcValuesStart &getDefaultInstance();

private:

    inline void set_has_GetVal ();

    inline void clear_has_GetVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _GetVal;

};

/**
 * The result message of the method "DiagUpcValues"
 * Request for UPC values.
 * Return UPC values
 */
class DiagUpcValuesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagUpcValuesResult ();

    /**
     * Copy constructor
     */
    inline  DiagUpcValuesResult (const DiagUpcValuesResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiagUpcValuesResult (const ::std::string& UpcLid0_, const ::std::string& UpcLid1_);

    /**
     * Destructor
     */
    inline virtual  ~DiagUpcValuesResult();

    /**
     * Assignment operator
     */
    inline DiagUpcValuesResult& operator = (const DiagUpcValuesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagUpcValuesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagUpcValuesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagUpcValuesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagUpcValuesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpcLid0"

    static const int kUpcLid0 = 0;

    /**
     * Clears the field "UpcLid0".
     *
     * The field will be set to its default value. The hasUpcLid0()
     * method will return false.
     */
    inline void clearUpcLid0();

    /**
     * Checks whether the field "UpcLid0" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpcLid0()). Otherwise it will return false.
     */
    inline bool hasUpcLid0 () const;

    /**
     * Returns the value of the member "UpcLid0".
     *
     * First 6 byte of UPC
     *
     * @return The value of the field "UpcLid0"
     */
    inline const ::std::string& getUpcLid0 () const;

    /**
     * Retrieves the value of the field "UpcLid0" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UpcLid0".
     */
    inline ::std::string& getUpcLid0Mutable ();

    /**
     * Sets the value of the member "UpcLid0".
     *
     * First 6 byte of UPC
     *
     * @param UpcLid0 The value which will be set
     */
    inline void setUpcLid0 (const ::std::string& UpcLid0_);

    /**
     * Sets the value of the member "UpcLid0".
     *
     * First 6 byte of UPC
     *
     * @param UpcLid0 The value which will be set
     */
    inline void setUpcLid0 (const char* UpcLid0_);

    /**
     * Sets the value of the member "UpcLid0".
     *
     * First 6 byte of UPC
     *
     * @param UpcLid0 The value which will be set
     */
    inline void setUpcLid0 (const char* value, size_t size);

    // API of field "UpcLid1"

    static const int kUpcLid1 = 1;

    /**
     * Clears the field "UpcLid1".
     *
     * The field will be set to its default value. The hasUpcLid1()
     * method will return false.
     */
    inline void clearUpcLid1();

    /**
     * Checks whether the field "UpcLid1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpcLid1()). Otherwise it will return false.
     */
    inline bool hasUpcLid1 () const;

    /**
     * Returns the value of the member "UpcLid1".
     *
     * Rest 6 byte of UPC
     *
     * @return The value of the field "UpcLid1"
     */
    inline const ::std::string& getUpcLid1 () const;

    /**
     * Retrieves the value of the field "UpcLid1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UpcLid1".
     */
    inline ::std::string& getUpcLid1Mutable ();

    /**
     * Sets the value of the member "UpcLid1".
     *
     * Rest 6 byte of UPC
     *
     * @param UpcLid1 The value which will be set
     */
    inline void setUpcLid1 (const ::std::string& UpcLid1_);

    /**
     * Sets the value of the member "UpcLid1".
     *
     * Rest 6 byte of UPC
     *
     * @param UpcLid1 The value which will be set
     */
    inline void setUpcLid1 (const char* UpcLid1_);

    /**
     * Sets the value of the member "UpcLid1".
     *
     * Rest 6 byte of UPC
     *
     * @param UpcLid1 The value which will be set
     */
    inline void setUpcLid1 (const char* value, size_t size);

    static const DiagUpcValuesResult &getDefaultInstance();

private:

    inline void set_has_UpcLid0 ();

    inline void clear_has_UpcLid0 ();

    inline void set_has_UpcLid1 ();

    inline void clear_has_UpcLid1 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _UpcLid0;

    ::std::string _UpcLid1;

};

/**
 * The error message of 'DiagUpcValues'
 */
class DiagUpcValuesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DiagUpcValuesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DiagUpcValuesErrorStructure (const DiagUpcValuesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DiagUpcValuesErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DiagUpcValuesErrorStructure();

    /**
     * Assignment operator
     */
    inline DiagUpcValuesErrorStructure& operator = (const DiagUpcValuesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagUpcValuesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagUpcValuesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagUpcValuesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagUpcValuesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const DiagUpcValuesErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'DiagUpcValues'
 */
class DiagUpcValuesError  : public ::asf::core::Payload {
public:

    enum DiagUpcValuesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DiagUpcValuesError ();

   /**
     * Copy constructor
     */
    inline  DiagUpcValuesError (const DiagUpcValuesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DiagUpcValuesError();

    /**
     * Assigns a new value to this object.
     */
    inline DiagUpcValuesError& operator = (const DiagUpcValuesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagUpcValuesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagUpcValuesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagUpcValuesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagUpcValuesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DiagUpcValuesError::DiagUpcValuesErrorField getField () const;

    inline void setField(DiagUpcValuesError::DiagUpcValuesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DiagUpcValuesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DiagUpcValuesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DiagUpcValuesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DiagUpcValuesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DiagUpcValuesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DiagUpcValuesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DiagUpcValuesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DiagUpcValuesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DiagUpcValuesError &getDefaultInstance();

private:

    inline void cloneData (const DiagUpcValuesError& rhs);

    inline void deleteData ();

    DiagUpcValuesErrorField __field;

    union {
        DiagUpcValuesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "TWNowSetMarket"
 * Set or Unset a market for monitoring
 */
class TWNowSetMarketStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TWNowSetMarketStart ();

    /**
     * Copy constructor
     */
    inline  TWNowSetMarketStart (const TWNowSetMarketStart &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowSetMarketStart (bool Status_, const ::std::string& Market_);

    /**
     * Destructor
     */
    inline virtual  ~TWNowSetMarketStart();

    /**
     * Assignment operator
     */
    inline TWNowSetMarketStart& operator = (const TWNowSetMarketStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowSetMarketStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowSetMarketStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowSetMarketStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowSetMarketStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE - Set the market for monitoring; FALSE - unset the market from monitoring.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE - Set the market for monitoring; FALSE - unset the market from monitoring.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    // API of field "Market"

    static const int kMarket = 1;

    /**
     * Clears the field "Market".
     *
     * The field will be set to its default value. The hasMarket()
     * method will return false.
     */
    inline void clearMarket();

    /**
     * Checks whether the field "Market" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMarket()). Otherwise it will return false.
     */
    inline bool hasMarket () const;

    /**
     * Returns the value of the member "Market".
     *
     * The Full name of the market.
     *
     * @return The value of the field "Market"
     */
    inline const ::std::string& getMarket () const;

    /**
     * Retrieves the value of the field "Market" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Market".
     */
    inline ::std::string& getMarketMutable ();

    /**
     * Sets the value of the member "Market".
     *
     * The Full name of the market.
     *
     * @param Market The value which will be set
     */
    inline void setMarket (const ::std::string& Market_);

    /**
     * Sets the value of the member "Market".
     *
     * The Full name of the market.
     *
     * @param Market The value which will be set
     */
    inline void setMarket (const char* Market_);

    /**
     * Sets the value of the member "Market".
     *
     * The Full name of the market.
     *
     * @param Market The value which will be set
     */
    inline void setMarket (const char* value, size_t size);

    static const TWNowSetMarketStart &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    inline void set_has_Market ();

    inline void clear_has_Market ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _Status;

    ::std::string _Market;

};

/**
 * The result message of the method "TWNowSetMarket"
 * Set or Unset a market for monitoring
 */
class TWNowSetMarketResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TWNowSetMarketResult ();

    /**
     * Copy constructor
     */
    inline  TWNowSetMarketResult (const TWNowSetMarketResult &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowSetMarketResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~TWNowSetMarketResult();

    /**
     * Assignment operator
     */
    inline TWNowSetMarketResult& operator = (const TWNowSetMarketResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowSetMarketResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowSetMarketResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowSetMarketResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowSetMarketResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status of SetNewMarket request. TRUE, if the request was successful; FALSE, if not.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Status of SetNewMarket request. TRUE, if the request was successful; FALSE, if not.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const TWNowSetMarketResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'TWNowSetMarket'
 */
class TWNowSetMarketErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TWNowSetMarketErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TWNowSetMarketErrorStructure (const TWNowSetMarketErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowSetMarketErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~TWNowSetMarketErrorStructure();

    /**
     * Assignment operator
     */
    inline TWNowSetMarketErrorStructure& operator = (const TWNowSetMarketErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowSetMarketErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowSetMarketErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowSetMarketErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowSetMarketErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const TWNowSetMarketErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'TWNowSetMarket'
 */
class TWNowSetMarketError  : public ::asf::core::Payload {
public:

    enum TWNowSetMarketErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TWNowSetMarketError ();

   /**
     * Copy constructor
     */
    inline  TWNowSetMarketError (const TWNowSetMarketError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TWNowSetMarketError();

    /**
     * Assigns a new value to this object.
     */
    inline TWNowSetMarketError& operator = (const TWNowSetMarketError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowSetMarketError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowSetMarketError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowSetMarketError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowSetMarketError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TWNowSetMarketError::TWNowSetMarketErrorField getField () const;

    inline void setField(TWNowSetMarketError::TWNowSetMarketErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TWNowSetMarketErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TWNowSetMarketErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TWNowSetMarketErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TWNowSetMarketErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TWNowSetMarketErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TWNowSetMarketErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TWNowSetMarketErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TWNowSetMarketErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TWNowSetMarketError &getDefaultInstance();

private:

    inline void cloneData (const TWNowSetMarketError& rhs);

    inline void deleteData ();

    TWNowSetMarketErrorField __field;

    union {
        TWNowSetMarketErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "TWNowGetActiveMarket"
 * Get currently monitored market.
 */
class TWNowGetActiveMarketResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TWNowGetActiveMarketResult ();

    /**
     * Copy constructor
     */
    inline  TWNowGetActiveMarketResult (const TWNowGetActiveMarketResult &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowGetActiveMarketResult (const ::sxm_audio_main_fi_types::T_MarketListEntry& Market_);

    /**
     * Destructor
     */
    inline virtual  ~TWNowGetActiveMarketResult();

    /**
     * Assignment operator
     */
    inline TWNowGetActiveMarketResult& operator = (const TWNowGetActiveMarketResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowGetActiveMarketResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowGetActiveMarketResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowGetActiveMarketResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowGetActiveMarketResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Market"

    static const int kMarket = 0;

    /**
     * Clears the field "Market".
     *
     * The field will be set to its default value. The hasMarket()
     * method will return false.
     */
    inline void clearMarket();

    /**
     * Checks whether the field "Market" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMarket()). Otherwise it will return false.
     */
    inline bool hasMarket () const;

    /**
     * Returns the value of the member "Market".
     *
     * Get the user's preferred market previously set by the Application or restored from the config file.
     * <p>If no market is set previously the fields for Market would be empty.</p>
     *
     * @return The value of the field "Market"
     */
    inline const ::sxm_audio_main_fi_types::T_MarketListEntry& getMarket () const;

    /**
     * Retrieves the value of the field "Market" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Market".
     */
    inline ::sxm_audio_main_fi_types::T_MarketListEntry& getMarketMutable ();

    /**
     * Sets the value of the member "Market".
     *
     * Get the user's preferred market previously set by the Application or restored from the config file.
     * <p>If no market is set previously the fields for Market would be empty.</p>
     *
     * @param Market The value which will be set
     */
    inline void setMarket (const ::sxm_audio_main_fi_types::T_MarketListEntry& Market_);

    static const TWNowGetActiveMarketResult &getDefaultInstance();

private:

    inline void set_has_Market ();

    inline void clear_has_Market ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_MarketListEntry _Market;

};

/**
 * The error message of 'TWNowGetActiveMarket'
 */
class TWNowGetActiveMarketErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TWNowGetActiveMarketErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TWNowGetActiveMarketErrorStructure (const TWNowGetActiveMarketErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowGetActiveMarketErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~TWNowGetActiveMarketErrorStructure();

    /**
     * Assignment operator
     */
    inline TWNowGetActiveMarketErrorStructure& operator = (const TWNowGetActiveMarketErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowGetActiveMarketErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowGetActiveMarketErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowGetActiveMarketErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowGetActiveMarketErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const TWNowGetActiveMarketErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'TWNowGetActiveMarket'
 */
class TWNowGetActiveMarketError  : public ::asf::core::Payload {
public:

    enum TWNowGetActiveMarketErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TWNowGetActiveMarketError ();

   /**
     * Copy constructor
     */
    inline  TWNowGetActiveMarketError (const TWNowGetActiveMarketError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TWNowGetActiveMarketError();

    /**
     * Assigns a new value to this object.
     */
    inline TWNowGetActiveMarketError& operator = (const TWNowGetActiveMarketError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowGetActiveMarketError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowGetActiveMarketError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowGetActiveMarketError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowGetActiveMarketError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TWNowGetActiveMarketError::TWNowGetActiveMarketErrorField getField () const;

    inline void setField(TWNowGetActiveMarketError::TWNowGetActiveMarketErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TWNowGetActiveMarketErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TWNowGetActiveMarketErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TWNowGetActiveMarketErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TWNowGetActiveMarketErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TWNowGetActiveMarketErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TWNowGetActiveMarketErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TWNowGetActiveMarketErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TWNowGetActiveMarketErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TWNowGetActiveMarketError &getDefaultInstance();

private:

    inline void cloneData (const TWNowGetActiveMarketError& rhs);

    inline void deleteData ();

    TWNowGetActiveMarketErrorField __field;

    union {
        TWNowGetActiveMarketErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "TWNowBulletinPlayback"
 * Either Switch playback to the channel broadcasting the Traffic/Weather report or Abort the currently playing report to switch back to the last tuned channel. After the Traffic/Weather report has been fully played the Module switches to the previous channel automatically.
 */
class TWNowBulletinPlaybackStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TWNowBulletinPlaybackStart ();

    /**
     * Copy constructor
     */
    inline  TWNowBulletinPlaybackStart (const TWNowBulletinPlaybackStart &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowBulletinPlaybackStart (uint32 BulletinID_, ::sxm_audio_main_fi_types::T_e8_TWNow_Bulletin_PlayBackAction Action_);

    /**
     * Destructor
     */
    inline virtual  ~TWNowBulletinPlaybackStart();

    /**
     * Assignment operator
     */
    inline TWNowBulletinPlaybackStart& operator = (const TWNowBulletinPlaybackStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowBulletinPlaybackStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowBulletinPlaybackStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowBulletinPlaybackStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowBulletinPlaybackStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BulletinID"

    static const int kBulletinID = 0;

    /**
     * Clears the field "BulletinID".
     *
     * The field will be set to its default value. The hasBulletinID()
     * method will return false.
     */
    inline void clearBulletinID();

    /**
     * Checks whether the field "BulletinID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBulletinID()). Otherwise it will return false.
     */
    inline bool hasBulletinID () const;

    /**
     * Returns the value of the member "BulletinID".
     *
     * The Bulletin ID to be played.
     *
     * @return The value of the field "BulletinID"
     */
    inline uint32 getBulletinID () const;

    /**
     * Sets the value of the member "BulletinID".
     *
     * The Bulletin ID to be played.
     *
     * @param BulletinID The value which will be set
     */
    inline void setBulletinID (uint32 BulletinID_);

    // API of field "Action"

    static const int kAction = 1;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * Action to be taken.
     *
     * @return The value of the field "Action"
     */
    inline ::sxm_audio_main_fi_types::T_e8_TWNow_Bulletin_PlayBackAction getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * Action to be taken.
     *
     * @param Action The value which will be set
     */
    inline void setAction (::sxm_audio_main_fi_types::T_e8_TWNow_Bulletin_PlayBackAction Action_);

    static const TWNowBulletinPlaybackStart &getDefaultInstance();

private:

    inline void set_has_BulletinID ();

    inline void clear_has_BulletinID ();

    inline void set_has_Action ();

    inline void clear_has_Action ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _BulletinID;

    ::sxm_audio_main_fi_types::T_e8_TWNow_Bulletin_PlayBackAction _Action;

};

/**
 * The result message of the method "TWNowBulletinPlayback"
 * Either Switch playback to the channel broadcasting the Traffic/Weather report or Abort the currently playing report to switch back to the last tuned channel. After the Traffic/Weather report has been fully played the Module switches to the previous channel automatically.
 */
class TWNowBulletinPlaybackResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TWNowBulletinPlaybackResult ();

    /**
     * Copy constructor
     */
    inline  TWNowBulletinPlaybackResult (const TWNowBulletinPlaybackResult &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowBulletinPlaybackResult (bool Status_, ::sxm_audio_main_fi_types::T_e8_TWNow_Bulletin_PlayBackAction Action_);

    /**
     * Destructor
     */
    inline virtual  ~TWNowBulletinPlaybackResult();

    /**
     * Assignment operator
     */
    inline TWNowBulletinPlaybackResult& operator = (const TWNowBulletinPlaybackResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowBulletinPlaybackResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowBulletinPlaybackResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowBulletinPlaybackResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowBulletinPlaybackResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Execution status of the play or abort operation.
     * <p>TRUE if the requested operation was executed successfully; FALSE, if not.</p>
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Execution status of the play or abort operation.
     * <p>TRUE if the requested operation was executed successfully; FALSE, if not.</p>
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    // API of field "Action"

    static const int kAction = 1;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * Action for which the status is reported.
     *
     * @return The value of the field "Action"
     */
    inline ::sxm_audio_main_fi_types::T_e8_TWNow_Bulletin_PlayBackAction getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * Action for which the status is reported.
     *
     * @param Action The value which will be set
     */
    inline void setAction (::sxm_audio_main_fi_types::T_e8_TWNow_Bulletin_PlayBackAction Action_);

    static const TWNowBulletinPlaybackResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    inline void set_has_Action ();

    inline void clear_has_Action ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _Status;

    ::sxm_audio_main_fi_types::T_e8_TWNow_Bulletin_PlayBackAction _Action;

};

/**
 * The error message of 'TWNowBulletinPlayback'
 */
class TWNowBulletinPlaybackErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TWNowBulletinPlaybackErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TWNowBulletinPlaybackErrorStructure (const TWNowBulletinPlaybackErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowBulletinPlaybackErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~TWNowBulletinPlaybackErrorStructure();

    /**
     * Assignment operator
     */
    inline TWNowBulletinPlaybackErrorStructure& operator = (const TWNowBulletinPlaybackErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowBulletinPlaybackErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowBulletinPlaybackErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowBulletinPlaybackErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowBulletinPlaybackErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const TWNowBulletinPlaybackErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'TWNowBulletinPlayback'
 */
class TWNowBulletinPlaybackError  : public ::asf::core::Payload {
public:

    enum TWNowBulletinPlaybackErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TWNowBulletinPlaybackError ();

   /**
     * Copy constructor
     */
    inline  TWNowBulletinPlaybackError (const TWNowBulletinPlaybackError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TWNowBulletinPlaybackError();

    /**
     * Assigns a new value to this object.
     */
    inline TWNowBulletinPlaybackError& operator = (const TWNowBulletinPlaybackError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowBulletinPlaybackError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowBulletinPlaybackError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowBulletinPlaybackError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowBulletinPlaybackError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TWNowBulletinPlaybackError::TWNowBulletinPlaybackErrorField getField () const;

    inline void setField(TWNowBulletinPlaybackError::TWNowBulletinPlaybackErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TWNowBulletinPlaybackErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TWNowBulletinPlaybackErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TWNowBulletinPlaybackErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TWNowBulletinPlaybackErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TWNowBulletinPlaybackErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TWNowBulletinPlaybackErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TWNowBulletinPlaybackErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TWNowBulletinPlaybackErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TWNowBulletinPlaybackError &getDefaultInstance();

private:

    inline void cloneData (const TWNowBulletinPlaybackError& rhs);

    inline void deleteData ();

    TWNowBulletinPlaybackErrorField __field;

    union {
        TWNowBulletinPlaybackErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "TWNowGetBulletinID"
 * Retrieve currently playing Bulletin ID.
 */
class TWNowGetBulletinIDResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TWNowGetBulletinIDResult ();

    /**
     * Copy constructor
     */
    inline  TWNowGetBulletinIDResult (const TWNowGetBulletinIDResult &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowGetBulletinIDResult (uint32 BulletinID_);

    /**
     * Destructor
     */
    inline virtual  ~TWNowGetBulletinIDResult();

    /**
     * Assignment operator
     */
    inline TWNowGetBulletinIDResult& operator = (const TWNowGetBulletinIDResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowGetBulletinIDResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowGetBulletinIDResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowGetBulletinIDResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowGetBulletinIDResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BulletinID"

    static const int kBulletinID = 0;

    /**
     * Clears the field "BulletinID".
     *
     * The field will be set to its default value. The hasBulletinID()
     * method will return false.
     */
    inline void clearBulletinID();

    /**
     * Checks whether the field "BulletinID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBulletinID()). Otherwise it will return false.
     */
    inline bool hasBulletinID () const;

    /**
     * Returns the value of the member "BulletinID".
     *
     * Current Playing TW Now Event's Bulletin ID.
     * <p>If ID of the current playing event could not be retrieved or if TWNow Event is not playing, then UN32_MAX is passed(2 ^ 32).</p>
     *
     * @return The value of the field "BulletinID"
     */
    inline uint32 getBulletinID () const;

    /**
     * Sets the value of the member "BulletinID".
     *
     * Current Playing TW Now Event's Bulletin ID.
     * <p>If ID of the current playing event could not be retrieved or if TWNow Event is not playing, then UN32_MAX is passed(2 ^ 32).</p>
     *
     * @param BulletinID The value which will be set
     */
    inline void setBulletinID (uint32 BulletinID_);

    static const TWNowGetBulletinIDResult &getDefaultInstance();

private:

    inline void set_has_BulletinID ();

    inline void clear_has_BulletinID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _BulletinID;

};

/**
 * The error message of 'TWNowGetBulletinID'
 */
class TWNowGetBulletinIDErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TWNowGetBulletinIDErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TWNowGetBulletinIDErrorStructure (const TWNowGetBulletinIDErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowGetBulletinIDErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~TWNowGetBulletinIDErrorStructure();

    /**
     * Assignment operator
     */
    inline TWNowGetBulletinIDErrorStructure& operator = (const TWNowGetBulletinIDErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowGetBulletinIDErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowGetBulletinIDErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowGetBulletinIDErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowGetBulletinIDErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const TWNowGetBulletinIDErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'TWNowGetBulletinID'
 */
class TWNowGetBulletinIDError  : public ::asf::core::Payload {
public:

    enum TWNowGetBulletinIDErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TWNowGetBulletinIDError ();

   /**
     * Copy constructor
     */
    inline  TWNowGetBulletinIDError (const TWNowGetBulletinIDError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TWNowGetBulletinIDError();

    /**
     * Assigns a new value to this object.
     */
    inline TWNowGetBulletinIDError& operator = (const TWNowGetBulletinIDError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowGetBulletinIDError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowGetBulletinIDError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowGetBulletinIDError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowGetBulletinIDError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TWNowGetBulletinIDError::TWNowGetBulletinIDErrorField getField () const;

    inline void setField(TWNowGetBulletinIDError::TWNowGetBulletinIDErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TWNowGetBulletinIDErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TWNowGetBulletinIDErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TWNowGetBulletinIDErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TWNowGetBulletinIDErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TWNowGetBulletinIDErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TWNowGetBulletinIDErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TWNowGetBulletinIDErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TWNowGetBulletinIDErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TWNowGetBulletinIDError &getDefaultInstance();

private:

    inline void cloneData (const TWNowGetBulletinIDError& rhs);

    inline void deleteData ();

    TWNowGetBulletinIDErrorField __field;

    union {
        TWNowGetBulletinIDErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "TWNowGetAvailableMarkets"
 * Get list of all available markets that could be monitored by SMS.
 */
class TWNowGetAvailableMarketsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TWNowGetAvailableMarketsResult ();

    /**
     * Copy constructor
     */
    inline  TWNowGetAvailableMarketsResult (const TWNowGetAvailableMarketsResult &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowGetAvailableMarketsResult (const ::sxm_audio_main_fi_types::T_MarketList& Markets_);

    /**
     * Destructor
     */
    inline virtual  ~TWNowGetAvailableMarketsResult();

    /**
     * Assignment operator
     */
    inline TWNowGetAvailableMarketsResult& operator = (const TWNowGetAvailableMarketsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowGetAvailableMarketsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowGetAvailableMarketsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowGetAvailableMarketsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowGetAvailableMarketsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Markets"

    static const int kMarkets = 0;

    /**
     * Clears the field "Markets".
     *
     * The field will be set to its default value. The hasMarkets()
     * method will return false.
     */
    inline void clearMarkets();

    /**
     * Checks whether the field "Markets" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMarkets()). Otherwise it will return false.
     */
    inline bool hasMarkets () const;

    /**
     * Returns the value of the member "Markets".
     *
     * List of markets reported by SMS.
     *
     * @return The value of the field "Markets"
     */
    inline const ::sxm_audio_main_fi_types::T_MarketList& getMarkets () const;

    /**
     * Retrieves the value of the field "Markets" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Markets".
     */
    inline ::sxm_audio_main_fi_types::T_MarketList& getMarketsMutable ();

    /**
     * Sets the value of the member "Markets".
     *
     * List of markets reported by SMS.
     *
     * @param Markets The value which will be set
     */
    inline void setMarkets (const ::sxm_audio_main_fi_types::T_MarketList& Markets_);

    static const TWNowGetAvailableMarketsResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_MarketListEntry >& getT_MarketListEntryList_DefaultInstance ();

    inline void set_has_Markets ();

    inline void clear_has_Markets ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_MarketList _Markets;

};

/**
 * The error message of 'TWNowGetAvailableMarkets'
 */
class TWNowGetAvailableMarketsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TWNowGetAvailableMarketsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TWNowGetAvailableMarketsErrorStructure (const TWNowGetAvailableMarketsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowGetAvailableMarketsErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~TWNowGetAvailableMarketsErrorStructure();

    /**
     * Assignment operator
     */
    inline TWNowGetAvailableMarketsErrorStructure& operator = (const TWNowGetAvailableMarketsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowGetAvailableMarketsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowGetAvailableMarketsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowGetAvailableMarketsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowGetAvailableMarketsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const TWNowGetAvailableMarketsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'TWNowGetAvailableMarkets'
 */
class TWNowGetAvailableMarketsError  : public ::asf::core::Payload {
public:

    enum TWNowGetAvailableMarketsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TWNowGetAvailableMarketsError ();

   /**
     * Copy constructor
     */
    inline  TWNowGetAvailableMarketsError (const TWNowGetAvailableMarketsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TWNowGetAvailableMarketsError();

    /**
     * Assigns a new value to this object.
     */
    inline TWNowGetAvailableMarketsError& operator = (const TWNowGetAvailableMarketsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowGetAvailableMarketsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowGetAvailableMarketsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowGetAvailableMarketsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowGetAvailableMarketsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TWNowGetAvailableMarketsError::TWNowGetAvailableMarketsErrorField getField () const;

    inline void setField(TWNowGetAvailableMarketsError::TWNowGetAvailableMarketsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TWNowGetAvailableMarketsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TWNowGetAvailableMarketsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TWNowGetAvailableMarketsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TWNowGetAvailableMarketsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TWNowGetAvailableMarketsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TWNowGetAvailableMarketsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TWNowGetAvailableMarketsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TWNowGetAvailableMarketsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TWNowGetAvailableMarketsError &getDefaultInstance();

private:

    inline void cloneData (const TWNowGetAvailableMarketsError& rhs);

    inline void deleteData ();

    TWNowGetAvailableMarketsErrorField __field;

    union {
        TWNowGetAvailableMarketsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "TWNowEnable"
 * Enable or Disable updates to be sent for the selected markets.
 */
class TWNowEnableStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TWNowEnableStart ();

    /**
     * Copy constructor
     */
    inline  TWNowEnableStart (const TWNowEnableStart &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowEnableStart (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~TWNowEnableStart();

    /**
     * Assignment operator
     */
    inline TWNowEnableStart& operator = (const TWNowEnableStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowEnableStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowEnableStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowEnableStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowEnableStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Enable or disable market updates.
     * <p>TRUE - Enable market updates.</p>
     * <p>FALSE - Disable market updates. Setting the State to false does not switch off the TW_Now Service, instead only the updates would be disabled.</p>
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Enable or disable market updates.
     * <p>TRUE - Enable market updates.</p>
     * <p>FALSE - Disable market updates. Setting the State to false does not switch off the TW_Now Service, instead only the updates would be disabled.</p>
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const TWNowEnableStart &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The result message of the method "TWNowEnable"
 * Enable or Disable updates to be sent for the selected markets.
 */
class TWNowEnableResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TWNowEnableResult ();

    /**
     * Copy constructor
     */
    inline  TWNowEnableResult (const TWNowEnableResult &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowEnableResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~TWNowEnableResult();

    /**
     * Assignment operator
     */
    inline TWNowEnableResult& operator = (const TWNowEnableResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowEnableResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowEnableResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowEnableResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowEnableResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status of TWNowEnable enable/disable operation.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Status of TWNowEnable enable/disable operation.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const TWNowEnableResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'TWNowEnable'
 */
class TWNowEnableErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TWNowEnableErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TWNowEnableErrorStructure (const TWNowEnableErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TWNowEnableErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~TWNowEnableErrorStructure();

    /**
     * Assignment operator
     */
    inline TWNowEnableErrorStructure& operator = (const TWNowEnableErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowEnableErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowEnableErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowEnableErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowEnableErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const TWNowEnableErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'TWNowEnable'
 */
class TWNowEnableError  : public ::asf::core::Payload {
public:

    enum TWNowEnableErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TWNowEnableError ();

   /**
     * Copy constructor
     */
    inline  TWNowEnableError (const TWNowEnableError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TWNowEnableError();

    /**
     * Assigns a new value to this object.
     */
    inline TWNowEnableError& operator = (const TWNowEnableError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWNowEnableError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWNowEnableError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWNowEnableError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWNowEnableError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TWNowEnableError::TWNowEnableErrorField getField () const;

    inline void setField(TWNowEnableError::TWNowEnableErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TWNowEnableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TWNowEnableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TWNowEnableErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TWNowEnableErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TWNowEnableErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TWNowEnableErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TWNowEnableErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TWNowEnableErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TWNowEnableError &getDefaultInstance();

private:

    inline void cloneData (const TWNowEnableError& rhs);

    inline void deleteData ();

    TWNowEnableErrorField __field;

    union {
        TWNowEnableErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DiagSxmReset"
 * Request for resetting individual Data service data bases and the user data.
 * Request for resetting individual Data service data bases and the user data..
 */
class DiagSxmResetStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagSxmResetStart ();

    /**
     * Copy constructor
     */
    inline  DiagSxmResetStart (const DiagSxmResetStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiagSxmResetStart (uint8 tU8Request_);

    /**
     * Destructor
     */
    inline virtual  ~DiagSxmResetStart();

    /**
     * Assignment operator
     */
    inline DiagSxmResetStart& operator = (const DiagSxmResetStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagSxmResetStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagSxmResetStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagSxmResetStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagSxmResetStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tU8Request"

    static const int kTU8Request = 0;

    /**
     * Clears the field "tU8Request".
     *
     * The field will be set to its default value. The hasTU8Request()
     * method will return false.
     */
    inline void clearTU8Request();

    /**
     * Checks whether the field "tU8Request" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTU8Request()). Otherwise it will return false.
     */
    inline bool hasTU8Request () const;

    /**
     * Returns the value of the member "tU8Request".
     *
     * <p>0 = Complete default setting</p>
     * <p>2 = Reset CGS</p>
     * <p>4 = Reset Movie</p>
     * <p>6 = Reset Tab Weather</p>
     * <p>7 = Reset Fuel</p>
     * <p>8 = Reset Stocks</p>
     * <p>9 = Reset Sports</p>
     * <p>10 = Reset CanadianFuel</p>
     * <p>11 = Reset WeatherAlerts</p>
     * <p>12 = Reset Parking</p>
     * <p>13 = Reset Phonetics</p>
     * <p>14 = Reset Safeview</p>
     *
     * @return The value of the field "tU8Request"
     */
    inline uint8 getTU8Request () const;

    /**
     * Sets the value of the member "tU8Request".
     *
     * <p>0 = Complete default setting</p>
     * <p>2 = Reset CGS</p>
     * <p>4 = Reset Movie</p>
     * <p>6 = Reset Tab Weather</p>
     * <p>7 = Reset Fuel</p>
     * <p>8 = Reset Stocks</p>
     * <p>9 = Reset Sports</p>
     * <p>10 = Reset CanadianFuel</p>
     * <p>11 = Reset WeatherAlerts</p>
     * <p>12 = Reset Parking</p>
     * <p>13 = Reset Phonetics</p>
     * <p>14 = Reset Safeview</p>
     *
     * @param tU8Request The value which will be set
     */
    inline void setTU8Request (uint8 tU8Request_);

    static const DiagSxmResetStart &getDefaultInstance();

private:

    inline void set_has_tU8Request ();

    inline void clear_has_tU8Request ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _tU8Request;

};

/**
 * The error message of 'DiagSxmReset'
 */
class DiagSxmResetErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DiagSxmResetErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DiagSxmResetErrorStructure (const DiagSxmResetErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DiagSxmResetErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DiagSxmResetErrorStructure();

    /**
     * Assignment operator
     */
    inline DiagSxmResetErrorStructure& operator = (const DiagSxmResetErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagSxmResetErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagSxmResetErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagSxmResetErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagSxmResetErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const DiagSxmResetErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'DiagSxmReset'
 */
class DiagSxmResetError  : public ::asf::core::Payload {
public:

    enum DiagSxmResetErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DiagSxmResetError ();

   /**
     * Copy constructor
     */
    inline  DiagSxmResetError (const DiagSxmResetError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DiagSxmResetError();

    /**
     * Assigns a new value to this object.
     */
    inline DiagSxmResetError& operator = (const DiagSxmResetError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagSxmResetError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagSxmResetError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagSxmResetError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagSxmResetError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DiagSxmResetError::DiagSxmResetErrorField getField () const;

    inline void setField(DiagSxmResetError::DiagSxmResetErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DiagSxmResetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DiagSxmResetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DiagSxmResetErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DiagSxmResetErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DiagSxmResetErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DiagSxmResetErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DiagSxmResetErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DiagSxmResetErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DiagSxmResetError &getDefaultInstance();

private:

    inline void cloneData (const DiagSxmResetError& rhs);

    inline void deleteData ();

    DiagSxmResetErrorField __field;

    union {
        DiagSxmResetErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FirmwareDownload"
 * Download of x65 firmware
 * Request Download of x65 firmware
 */
class FirmwareDownloadStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FirmwareDownloadStart ();

    /**
     * Copy constructor
     */
    inline  FirmwareDownloadStart (const FirmwareDownloadStart &rhs);

    /**
     * All fields constructor
     */
    inline  FirmwareDownloadStart (const ::std::string& File_, const ::std::string& Version_, bool bForced_);

    /**
     * Destructor
     */
    inline virtual  ~FirmwareDownloadStart();

    /**
     * Assignment operator
     */
    inline FirmwareDownloadStart& operator = (const FirmwareDownloadStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FirmwareDownloadStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FirmwareDownloadStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FirmwareDownloadStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FirmwareDownloadStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "File"

    static const int kFile = 0;

    /**
     * Clears the field "File".
     *
     * The field will be set to its default value. The hasFile()
     * method will return false.
     */
    inline void clearFile();

    /**
     * Checks whether the field "File" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFile()). Otherwise it will return false.
     */
    inline bool hasFile () const;

    /**
     * Returns the value of the member "File".
     *
     * Path and name of firmware-file, e.g. /var/opt/bosch/static/x65_firmware.bin
     *
     * @return The value of the field "File"
     */
    inline const ::std::string& getFile () const;

    /**
     * Retrieves the value of the field "File" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "File".
     */
    inline ::std::string& getFileMutable ();

    /**
     * Sets the value of the member "File".
     *
     * Path and name of firmware-file, e.g. /var/opt/bosch/static/x65_firmware.bin
     *
     * @param File The value which will be set
     */
    inline void setFile (const ::std::string& File_);

    /**
     * Sets the value of the member "File".
     *
     * Path and name of firmware-file, e.g. /var/opt/bosch/static/x65_firmware.bin
     *
     * @param File The value which will be set
     */
    inline void setFile (const char* File_);

    /**
     * Sets the value of the member "File".
     *
     * Path and name of firmware-file, e.g. /var/opt/bosch/static/x65_firmware.bin
     *
     * @param File The value which will be set
     */
    inline void setFile (const char* value, size_t size);

    // API of field "Version"

    static const int kVersion = 1;

    /**
     * Clears the field "Version".
     *
     * The field will be set to its default value. The hasVersion()
     * method will return false.
     */
    inline void clearVersion();

    /**
     * Checks whether the field "Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersion()). Otherwise it will return false.
     */
    inline bool hasVersion () const;

    /**
     * Returns the value of the member "Version".
     *
     * Version of the firmware.
     *
     * @return The value of the field "Version"
     */
    inline const ::std::string& getVersion () const;

    /**
     * Retrieves the value of the field "Version" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Version".
     */
    inline ::std::string& getVersionMutable ();

    /**
     * Sets the value of the member "Version".
     *
     * Version of the firmware.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const ::std::string& Version_);

    /**
     * Sets the value of the member "Version".
     *
     * Version of the firmware.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const char* Version_);

    /**
     * Sets the value of the member "Version".
     *
     * Version of the firmware.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const char* value, size_t size);

    // API of field "bForced"

    static const int kBForced = 2;

    /**
     * Clears the field "bForced".
     *
     * The field will be set to its default value. The hasBForced()
     * method will return false.
     */
    inline void clearBForced();

    /**
     * Checks whether the field "bForced" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBForced()). Otherwise it will return false.
     */
    inline bool hasBForced () const;

    /**
     * Returns the value of the member "bForced".
     *
     * TRUE: forced download, download even if new version is identical to new version
     * FALSE:No download if versions are identical
     *
     * @return The value of the field "bForced"
     */
    inline bool getBForced () const;

    /**
     * Sets the value of the member "bForced".
     *
     * TRUE: forced download, download even if new version is identical to new version
     * FALSE:No download if versions are identical
     *
     * @param bForced The value which will be set
     */
    inline void setBForced (bool bForced_);

    static const FirmwareDownloadStart &getDefaultInstance();

private:

    inline void set_has_File ();

    inline void clear_has_File ();

    inline void set_has_Version ();

    inline void clear_has_Version ();

    inline void set_has_bForced ();

    inline void clear_has_bForced ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _File;

    ::std::string _Version;

    bool _bForced;

};

/**
 * The result message of the method "FirmwareDownload"
 * Download of x65 firmware
 */
class FirmwareDownloadResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FirmwareDownloadResult ();

    /**
     * Copy constructor
     */
    inline  FirmwareDownloadResult (const FirmwareDownloadResult &rhs);

    /**
     * All fields constructor
     */
    inline  FirmwareDownloadResult (::sxm_audio_main_fi_types::T_e8_SxmFirmwareDownloadResult enResult_);

    /**
     * Destructor
     */
    inline virtual  ~FirmwareDownloadResult();

    /**
     * Assignment operator
     */
    inline FirmwareDownloadResult& operator = (const FirmwareDownloadResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FirmwareDownloadResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FirmwareDownloadResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FirmwareDownloadResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FirmwareDownloadResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enResult"

    static const int kEnResult = 0;

    /**
     * Clears the field "enResult".
     *
     * The field will be set to its default value. The hasEnResult()
     * method will return false.
     */
    inline void clearEnResult();

    /**
     * Checks whether the field "enResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnResult()). Otherwise it will return false.
     */
    inline bool hasEnResult () const;

    /**
     * Returns the value of the member "enResult".
     *
     * Specifies the result
     *
     * @return The value of the field "enResult"
     */
    inline ::sxm_audio_main_fi_types::T_e8_SxmFirmwareDownloadResult getEnResult () const;

    /**
     * Sets the value of the member "enResult".
     *
     * Specifies the result
     *
     * @param enResult The value which will be set
     */
    inline void setEnResult (::sxm_audio_main_fi_types::T_e8_SxmFirmwareDownloadResult enResult_);

    static const FirmwareDownloadResult &getDefaultInstance();

private:

    inline void set_has_enResult ();

    inline void clear_has_enResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_SxmFirmwareDownloadResult _enResult;

};

/**
 * The error message of 'FirmwareDownload'
 */
class FirmwareDownloadErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FirmwareDownloadErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FirmwareDownloadErrorStructure (const FirmwareDownloadErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FirmwareDownloadErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FirmwareDownloadErrorStructure();

    /**
     * Assignment operator
     */
    inline FirmwareDownloadErrorStructure& operator = (const FirmwareDownloadErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FirmwareDownloadErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FirmwareDownloadErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FirmwareDownloadErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FirmwareDownloadErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const FirmwareDownloadErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'FirmwareDownload'
 */
class FirmwareDownloadError  : public ::asf::core::Payload {
public:

    enum FirmwareDownloadErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FirmwareDownloadError ();

   /**
     * Copy constructor
     */
    inline  FirmwareDownloadError (const FirmwareDownloadError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FirmwareDownloadError();

    /**
     * Assigns a new value to this object.
     */
    inline FirmwareDownloadError& operator = (const FirmwareDownloadError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FirmwareDownloadError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FirmwareDownloadError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FirmwareDownloadError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FirmwareDownloadError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FirmwareDownloadError::FirmwareDownloadErrorField getField () const;

    inline void setField(FirmwareDownloadError::FirmwareDownloadErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FirmwareDownloadErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FirmwareDownloadErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FirmwareDownloadErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FirmwareDownloadErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FirmwareDownloadErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FirmwareDownloadErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FirmwareDownloadErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FirmwareDownloadErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FirmwareDownloadError &getDefaultInstance();

private:

    inline void cloneData (const FirmwareDownloadError& rhs);

    inline void deleteData ();

    FirmwareDownloadErrorField __field;

    union {
        FirmwareDownloadErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ExternalDiagnosisMode"
 * Method to enter and Exit from external Diagnosis mode
 * Request to enter External Diag mode
 */
class ExternalDiagnosisModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ExternalDiagnosisModeStart ();

    /**
     * Copy constructor
     */
    inline  ExternalDiagnosisModeStart (const ExternalDiagnosisModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  ExternalDiagnosisModeStart (::sxm_audio_main_fi_types::T_e8_SxmExtDiagMode Mode_);

    /**
     * Destructor
     */
    inline virtual  ~ExternalDiagnosisModeStart();

    /**
     * Assignment operator
     */
    inline ExternalDiagnosisModeStart& operator = (const ExternalDiagnosisModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExternalDiagnosisModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExternalDiagnosisModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExternalDiagnosisModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExternalDiagnosisModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Mode"

    static const int kMode = 0;

    /**
     * Clears the field "Mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "Mode".
     *
     * Mode describing whether the external diagnosis mode is ON or OFF
     *
     * @return The value of the field "Mode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_SxmExtDiagMode getMode () const;

    /**
     * Sets the value of the member "Mode".
     *
     * Mode describing whether the external diagnosis mode is ON or OFF
     *
     * @param Mode The value which will be set
     */
    inline void setMode (::sxm_audio_main_fi_types::T_e8_SxmExtDiagMode Mode_);

    static const ExternalDiagnosisModeStart &getDefaultInstance();

private:

    inline void set_has_Mode ();

    inline void clear_has_Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_SxmExtDiagMode _Mode;

};

/**
 * The error message of 'ExternalDiagnosisMode'
 */
class ExternalDiagnosisModeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ExternalDiagnosisModeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ExternalDiagnosisModeErrorStructure (const ExternalDiagnosisModeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ExternalDiagnosisModeErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~ExternalDiagnosisModeErrorStructure();

    /**
     * Assignment operator
     */
    inline ExternalDiagnosisModeErrorStructure& operator = (const ExternalDiagnosisModeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExternalDiagnosisModeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExternalDiagnosisModeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExternalDiagnosisModeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExternalDiagnosisModeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const ExternalDiagnosisModeErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'ExternalDiagnosisMode'
 */
class ExternalDiagnosisModeError  : public ::asf::core::Payload {
public:

    enum ExternalDiagnosisModeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ExternalDiagnosisModeError ();

   /**
     * Copy constructor
     */
    inline  ExternalDiagnosisModeError (const ExternalDiagnosisModeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ExternalDiagnosisModeError();

    /**
     * Assigns a new value to this object.
     */
    inline ExternalDiagnosisModeError& operator = (const ExternalDiagnosisModeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExternalDiagnosisModeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExternalDiagnosisModeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExternalDiagnosisModeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExternalDiagnosisModeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ExternalDiagnosisModeError::ExternalDiagnosisModeErrorField getField () const;

    inline void setField(ExternalDiagnosisModeError::ExternalDiagnosisModeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ExternalDiagnosisModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ExternalDiagnosisModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ExternalDiagnosisModeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ExternalDiagnosisModeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ExternalDiagnosisModeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ExternalDiagnosisModeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ExternalDiagnosisModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ExternalDiagnosisModeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ExternalDiagnosisModeError &getDefaultInstance();

private:

    inline void cloneData (const ExternalDiagnosisModeError& rhs);

    inline void deleteData ();

    ExternalDiagnosisModeErrorField __field;

    union {
        ExternalDiagnosisModeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "InstantReplayControl"
 * Method to control sxm audio instant replay functionality
 * Request to play / pause / seek forward / seek backward / skip forward / skip backward tracks in sxm audio
 */
class InstantReplayControlStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InstantReplayControlStart ();

    /**
     * Copy constructor
     */
    inline  InstantReplayControlStart (const InstantReplayControlStart &rhs);

    /**
     * All fields constructor
     */
    inline  InstantReplayControlStart (::sxm_audio_main_fi_types::T_e8_IRPlaybackMode u8IRPlaybackMode_);

    /**
     * Destructor
     */
    inline virtual  ~InstantReplayControlStart();

    /**
     * Assignment operator
     */
    inline InstantReplayControlStart& operator = (const InstantReplayControlStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InstantReplayControlStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InstantReplayControlStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InstantReplayControlStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InstantReplayControlStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8IRPlaybackMode"

    static const int kU8IRPlaybackMode = 0;

    /**
     * Clears the field "u8IRPlaybackMode".
     *
     * The field will be set to its default value. The hasU8IRPlaybackMode()
     * method will return false.
     */
    inline void clearU8IRPlaybackMode();

    /**
     * Checks whether the field "u8IRPlaybackMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8IRPlaybackMode()). Otherwise it will return false.
     */
    inline bool hasU8IRPlaybackMode () const;

    /**
     * Returns the value of the member "u8IRPlaybackMode".
     *
     * Playback type defines the control type to be performed
     * <p>0 - PLAY CURRENT TRACK</p>
     * <p>1 - PAUSE CURRENT TRACK</p>
     * <p>2 - SEEK FORWARD IN CURRENT TRACK</p>
     * <p>3 - SEEK BACKWARD IN CURRENT TRACK</p>
     * <p>4 - SKIP TO START OF NEXT TRACK</p>
     * <p>5 - SKIP TO START OF PREVIOUS TRACK</p>
     * <p>6 - JUMP TO LIVE MODE</p>
     *
     * @return The value of the field "u8IRPlaybackMode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_IRPlaybackMode getU8IRPlaybackMode () const;

    /**
     * Sets the value of the member "u8IRPlaybackMode".
     *
     * Playback type defines the control type to be performed
     * <p>0 - PLAY CURRENT TRACK</p>
     * <p>1 - PAUSE CURRENT TRACK</p>
     * <p>2 - SEEK FORWARD IN CURRENT TRACK</p>
     * <p>3 - SEEK BACKWARD IN CURRENT TRACK</p>
     * <p>4 - SKIP TO START OF NEXT TRACK</p>
     * <p>5 - SKIP TO START OF PREVIOUS TRACK</p>
     * <p>6 - JUMP TO LIVE MODE</p>
     *
     * @param u8IRPlaybackMode The value which will be set
     */
    inline void setU8IRPlaybackMode (::sxm_audio_main_fi_types::T_e8_IRPlaybackMode u8IRPlaybackMode_);

    static const InstantReplayControlStart &getDefaultInstance();

private:

    inline void set_has_u8IRPlaybackMode ();

    inline void clear_has_u8IRPlaybackMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_IRPlaybackMode _u8IRPlaybackMode;

};

/**
 * The result message of the method "InstantReplayControl"
 * Method to control sxm audio instant replay functionality
 */
class InstantReplayControlResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InstantReplayControlResult ();

    /**
     * Copy constructor
     */
    inline  InstantReplayControlResult (const InstantReplayControlResult &rhs);

    /**
     * All fields constructor
     */
    inline  InstantReplayControlResult (::sxm_audio_main_fi_types::T_e8_IRPlaybackMode u8IRPlaybackMode_, ::sxm_audio_main_fi_types::T_e8_IRPlaybackStatus u8IRPlaybackState_, ::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    /**
     * Destructor
     */
    inline virtual  ~InstantReplayControlResult();

    /**
     * Assignment operator
     */
    inline InstantReplayControlResult& operator = (const InstantReplayControlResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InstantReplayControlResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InstantReplayControlResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InstantReplayControlResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InstantReplayControlResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8IRPlaybackMode"

    static const int kU8IRPlaybackMode = 0;

    /**
     * Clears the field "u8IRPlaybackMode".
     *
     * The field will be set to its default value. The hasU8IRPlaybackMode()
     * method will return false.
     */
    inline void clearU8IRPlaybackMode();

    /**
     * Checks whether the field "u8IRPlaybackMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8IRPlaybackMode()). Otherwise it will return false.
     */
    inline bool hasU8IRPlaybackMode () const;

    /**
     * Returns the value of the member "u8IRPlaybackMode".
     *
     * Playback type defines the control type to be performed
     * <p>0 - PLAY CURRENT TRACK</p>
     * <p>1 - PAUSE CURRENT TRACK</p>
     * <p>2 - SEEK FORWARD IN CURRENT TRACK</p>
     * <p>3 - SEEK BACKWARD IN CURRENT TRACK</p>
     * <p>4 - SKIP TO START OF NEXT TRACK</p>
     * <p>5 - SKIP TO START OF PREVIOUS TRACK</p>
     * <p>6 - JUMP TO LIVE MODE</p>
     *
     * @return The value of the field "u8IRPlaybackMode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_IRPlaybackMode getU8IRPlaybackMode () const;

    /**
     * Sets the value of the member "u8IRPlaybackMode".
     *
     * Playback type defines the control type to be performed
     * <p>0 - PLAY CURRENT TRACK</p>
     * <p>1 - PAUSE CURRENT TRACK</p>
     * <p>2 - SEEK FORWARD IN CURRENT TRACK</p>
     * <p>3 - SEEK BACKWARD IN CURRENT TRACK</p>
     * <p>4 - SKIP TO START OF NEXT TRACK</p>
     * <p>5 - SKIP TO START OF PREVIOUS TRACK</p>
     * <p>6 - JUMP TO LIVE MODE</p>
     *
     * @param u8IRPlaybackMode The value which will be set
     */
    inline void setU8IRPlaybackMode (::sxm_audio_main_fi_types::T_e8_IRPlaybackMode u8IRPlaybackMode_);

    // API of field "u8IRPlaybackState"

    static const int kU8IRPlaybackState = 1;

    /**
     * Clears the field "u8IRPlaybackState".
     *
     * The field will be set to its default value. The hasU8IRPlaybackState()
     * method will return false.
     */
    inline void clearU8IRPlaybackState();

    /**
     * Checks whether the field "u8IRPlaybackState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8IRPlaybackState()). Otherwise it will return false.
     */
    inline bool hasU8IRPlaybackState () const;

    /**
     * Returns the value of the member "u8IRPlaybackState".
     *
     * Playback state currently set
     * 0 - PLAY
     * 1 - PAUSE
     * 2 - SEEK
     * 3 - SKIP
     * 4 - SEEK NOT ALLOWED
     * 5 - SKIP NOT ALLOWED
     * 6 - UNKNOWN STATE
     *
     * @return The value of the field "u8IRPlaybackState"
     */
    inline ::sxm_audio_main_fi_types::T_e8_IRPlaybackStatus getU8IRPlaybackState () const;

    /**
     * Sets the value of the member "u8IRPlaybackState".
     *
     * Playback state currently set
     * 0 - PLAY
     * 1 - PAUSE
     * 2 - SEEK
     * 3 - SKIP
     * 4 - SEEK NOT ALLOWED
     * 5 - SKIP NOT ALLOWED
     * 6 - UNKNOWN STATE
     *
     * @param u8IRPlaybackState The value which will be set
     */
    inline void setU8IRPlaybackState (::sxm_audio_main_fi_types::T_e8_IRPlaybackStatus u8IRPlaybackState_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status information of instant replay method start request.
     *
     * @return The value of the field "Status"
     */
    inline ::sxm_audio_main_fi_types::T_e8_MethodStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Status information of instant replay method start request.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    static const InstantReplayControlResult &getDefaultInstance();

private:

    inline void set_has_u8IRPlaybackMode ();

    inline void clear_has_u8IRPlaybackMode ();

    inline void set_has_u8IRPlaybackState ();

    inline void clear_has_u8IRPlaybackState ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_IRPlaybackMode _u8IRPlaybackMode;

    ::sxm_audio_main_fi_types::T_e8_IRPlaybackStatus _u8IRPlaybackState;

    ::sxm_audio_main_fi_types::T_e8_MethodStatus _Status;

};

/**
 * The error message of 'InstantReplayControl'
 */
class InstantReplayControlErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  InstantReplayControlErrorStructure ();

    /**
     * Copy constructor
     */
    inline  InstantReplayControlErrorStructure (const InstantReplayControlErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  InstantReplayControlErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~InstantReplayControlErrorStructure();

    /**
     * Assignment operator
     */
    inline InstantReplayControlErrorStructure& operator = (const InstantReplayControlErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InstantReplayControlErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InstantReplayControlErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InstantReplayControlErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InstantReplayControlErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const InstantReplayControlErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'InstantReplayControl'
 */
class InstantReplayControlError  : public ::asf::core::Payload {
public:

    enum InstantReplayControlErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  InstantReplayControlError ();

   /**
     * Copy constructor
     */
    inline  InstantReplayControlError (const InstantReplayControlError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~InstantReplayControlError();

    /**
     * Assigns a new value to this object.
     */
    inline InstantReplayControlError& operator = (const InstantReplayControlError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InstantReplayControlError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InstantReplayControlError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InstantReplayControlError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InstantReplayControlError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline InstantReplayControlError::InstantReplayControlErrorField getField () const;

    inline void setField(InstantReplayControlError::InstantReplayControlErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "InstantReplayControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "InstantReplayControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const InstantReplayControlErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline InstantReplayControlErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline InstantReplayControlErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (InstantReplayControlErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "InstantReplayControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const InstantReplayControlErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const InstantReplayControlError &getDefaultInstance();

private:

    inline void cloneData (const InstantReplayControlError& rhs);

    inline void deleteData ();

    InstantReplayControlErrorField __field;

    union {
        InstantReplayControlErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "EnableTuneStart"
 * Method to enable or disable tune start functionality
 * Enable or disable tune start functionality
 */
class EnableTuneStartStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnableTuneStartStart ();

    /**
     * Copy constructor
     */
    inline  EnableTuneStartStart (const EnableTuneStartStart &rhs);

    /**
     * All fields constructor
     */
    inline  EnableTuneStartStart (bool bEnableTuneStart_);

    /**
     * Destructor
     */
    inline virtual  ~EnableTuneStartStart();

    /**
     * Assignment operator
     */
    inline EnableTuneStartStart& operator = (const EnableTuneStartStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnableTuneStartStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnableTuneStartStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnableTuneStartStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnableTuneStartStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEnableTuneStart"

    static const int kBEnableTuneStart = 0;

    /**
     * Clears the field "bEnableTuneStart".
     *
     * The field will be set to its default value. The hasBEnableTuneStart()
     * method will return false.
     */
    inline void clearBEnableTuneStart();

    /**
     * Checks whether the field "bEnableTuneStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEnableTuneStart()). Otherwise it will return false.
     */
    inline bool hasBEnableTuneStart () const;

    /**
     * Returns the value of the member "bEnableTuneStart".
     *
     * To enable TUNE START set TRUE
     * To disable TUNE START set FALSE
     *
     * @return The value of the field "bEnableTuneStart"
     */
    inline bool getBEnableTuneStart () const;

    /**
     * Sets the value of the member "bEnableTuneStart".
     *
     * To enable TUNE START set TRUE
     * To disable TUNE START set FALSE
     *
     * @param bEnableTuneStart The value which will be set
     */
    inline void setBEnableTuneStart (bool bEnableTuneStart_);

    static const EnableTuneStartStart &getDefaultInstance();

private:

    inline void set_has_bEnableTuneStart ();

    inline void clear_has_bEnableTuneStart ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bEnableTuneStart;

};

/**
 * The result message of the method "EnableTuneStart"
 * Method to enable or disable tune start functionality
 */
class EnableTuneStartResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnableTuneStartResult ();

    /**
     * Copy constructor
     */
    inline  EnableTuneStartResult (const EnableTuneStartResult &rhs);

    /**
     * All fields constructor
     */
    inline  EnableTuneStartResult (::sxm_audio_main_fi_types::T_e8_MethodStatus Status_, bool bEnableTuneStart_);

    /**
     * Destructor
     */
    inline virtual  ~EnableTuneStartResult();

    /**
     * Assignment operator
     */
    inline EnableTuneStartResult& operator = (const EnableTuneStartResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnableTuneStartResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnableTuneStartResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnableTuneStartResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnableTuneStartResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * EnableTuneStart was successful or not
     *
     * @return The value of the field "Status"
     */
    inline ::sxm_audio_main_fi_types::T_e8_MethodStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * EnableTuneStart was successful or not
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    // API of field "bEnableTuneStart"

    static const int kBEnableTuneStart = 1;

    /**
     * Clears the field "bEnableTuneStart".
     *
     * The field will be set to its default value. The hasBEnableTuneStart()
     * method will return false.
     */
    inline void clearBEnableTuneStart();

    /**
     * Checks whether the field "bEnableTuneStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEnableTuneStart()). Otherwise it will return false.
     */
    inline bool hasBEnableTuneStart () const;

    /**
     * Returns the value of the member "bEnableTuneStart".
     *
     * To enable TUNE START set TRUE
     * To disable TUNE START set FALSE
     *
     * @return The value of the field "bEnableTuneStart"
     */
    inline bool getBEnableTuneStart () const;

    /**
     * Sets the value of the member "bEnableTuneStart".
     *
     * To enable TUNE START set TRUE
     * To disable TUNE START set FALSE
     *
     * @param bEnableTuneStart The value which will be set
     */
    inline void setBEnableTuneStart (bool bEnableTuneStart_);

    static const EnableTuneStartResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    inline void set_has_bEnableTuneStart ();

    inline void clear_has_bEnableTuneStart ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_MethodStatus _Status;

    bool _bEnableTuneStart;

};

/**
 * The error message of 'EnableTuneStart'
 */
class EnableTuneStartErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  EnableTuneStartErrorStructure ();

    /**
     * Copy constructor
     */
    inline  EnableTuneStartErrorStructure (const EnableTuneStartErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  EnableTuneStartErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~EnableTuneStartErrorStructure();

    /**
     * Assignment operator
     */
    inline EnableTuneStartErrorStructure& operator = (const EnableTuneStartErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnableTuneStartErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnableTuneStartErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnableTuneStartErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnableTuneStartErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const EnableTuneStartErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'EnableTuneStart'
 */
class EnableTuneStartError  : public ::asf::core::Payload {
public:

    enum EnableTuneStartErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  EnableTuneStartError ();

   /**
     * Copy constructor
     */
    inline  EnableTuneStartError (const EnableTuneStartError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~EnableTuneStartError();

    /**
     * Assigns a new value to this object.
     */
    inline EnableTuneStartError& operator = (const EnableTuneStartError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnableTuneStartError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnableTuneStartError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnableTuneStartError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnableTuneStartError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline EnableTuneStartError::EnableTuneStartErrorField getField () const;

    inline void setField(EnableTuneStartError::EnableTuneStartErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "EnableTuneStartErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "EnableTuneStartErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const EnableTuneStartErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline EnableTuneStartErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline EnableTuneStartErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (EnableTuneStartErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "EnableTuneStartErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const EnableTuneStartErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const EnableTuneStartError &getDefaultInstance();

private:

    inline void cloneData (const EnableTuneStartError& rhs);

    inline void deleteData ();

    EnableTuneStartErrorField __field;

    union {
        EnableTuneStartErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SmartFavoriteListControl"
 * Get list of smart favorite channels preset list indexs
 * Start method and get cyclic messages while processing and get the result
 * when finished "OPTYPE_STARTRESULT"
 */
class SmartFavoriteListControlStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SmartFavoriteListControlStart ();

    /**
     * Copy constructor
     */
    inline  SmartFavoriteListControlStart (const SmartFavoriteListControlStart &rhs);

    /**
     * All fields constructor
     */
    inline  SmartFavoriteListControlStart (::sxm_audio_main_fi_types::T_e8_SFOperation Operation_, uint8 ListIndex_);

    /**
     * Destructor
     */
    inline virtual  ~SmartFavoriteListControlStart();

    /**
     * Assignment operator
     */
    inline SmartFavoriteListControlStart& operator = (const SmartFavoriteListControlStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SmartFavoriteListControlStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SmartFavoriteListControlStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SmartFavoriteListControlStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SmartFavoriteListControlStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Operation"

    static const int kOperation = 0;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * Operation to be Performed on Smart Favorite List
     *
     * @return The value of the field "Operation"
     */
    inline ::sxm_audio_main_fi_types::T_e8_SFOperation getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * Operation to be Performed on Smart Favorite List
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (::sxm_audio_main_fi_types::T_e8_SFOperation Operation_);

    // API of field "ListIndex"

    static const int kListIndex = 1;

    /**
     * Clears the field "ListIndex".
     *
     * The field will be set to its default value. The hasListIndex()
     * method will return false.
     */
    inline void clearListIndex();

    /**
     * Checks whether the field "ListIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListIndex()). Otherwise it will return false.
     */
    inline bool hasListIndex () const;

    /**
     * Returns the value of the member "ListIndex".
     *
     * List index used for ADD and REMOVE setup mode
     *
     * @return The value of the field "ListIndex"
     */
    inline uint8 getListIndex () const;

    /**
     * Sets the value of the member "ListIndex".
     *
     * List index used for ADD and REMOVE setup mode
     *
     * @param ListIndex The value which will be set
     */
    inline void setListIndex (uint8 ListIndex_);

    static const SmartFavoriteListControlStart &getDefaultInstance();

private:

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    inline void set_has_ListIndex ();

    inline void clear_has_ListIndex ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_SFOperation _Operation;

    uint8 _ListIndex;

};

/**
 * The result message of the method "SmartFavoriteListControl"
 * Get list of smart favorite channels preset list indexs
 * Result of method
 */
class SmartFavoriteListControlResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SmartFavoriteListControlResult ();

    /**
     * Copy constructor
     */
    inline  SmartFavoriteListControlResult (const SmartFavoriteListControlResult &rhs);

    /**
     * All fields constructor
     */
    inline  SmartFavoriteListControlResult (::sxm_audio_main_fi_types::T_e8_SFOperation Operation_, const ::std::vector< ::sxm_audio_main_fi_types::T_SFListElement >& SmartFavoriteList_, bool EnableAddPreset_, ::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    /**
     * Destructor
     */
    inline virtual  ~SmartFavoriteListControlResult();

    /**
     * Assignment operator
     */
    inline SmartFavoriteListControlResult& operator = (const SmartFavoriteListControlResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SmartFavoriteListControlResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SmartFavoriteListControlResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SmartFavoriteListControlResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SmartFavoriteListControlResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Operation"

    static const int kOperation = 0;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * Operation to be Performed on Smart Favorite List
     *
     * @return The value of the field "Operation"
     */
    inline ::sxm_audio_main_fi_types::T_e8_SFOperation getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * Operation to be Performed on Smart Favorite List
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (::sxm_audio_main_fi_types::T_e8_SFOperation Operation_);

    // API of field "SmartFavoriteList"

    static const int kSmartFavoriteList = 1;

    /**
     * Clears the field "SmartFavoriteList".
     *
     * The field will be set to its default value. The hasSmartFavoriteList()
     * method will return false.
     */
    inline void clearSmartFavoriteList();

    /**
     * Checks whether the field "SmartFavoriteList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSmartFavoriteList()). Otherwise it will return false.
     */
    inline bool hasSmartFavoriteList () const;

    /**
     * Returns the value of the member "SmartFavoriteList".
     *
     * Smart favorite list containing preset index and repetation flag
     *
     * @return The value of the field "SmartFavoriteList"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_SFListElement >& getSmartFavoriteList () const;

    /**
     * Retrieves the value of the field "SmartFavoriteList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SmartFavoriteList".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_SFListElement >& getSmartFavoriteListMutable ();

    /**
     * Sets the value of the member "SmartFavoriteList".
     *
     * Smart favorite list containing preset index and repetation flag
     *
     * @param SmartFavoriteList The value which will be set
     */
    inline void setSmartFavoriteList (const ::std::vector< ::sxm_audio_main_fi_types::T_SFListElement >& SmartFavoriteList_);

    // API of field "EnableAddPreset"

    static const int kEnableAddPreset = 2;

    /**
     * Clears the field "EnableAddPreset".
     *
     * The field will be set to its default value. The hasEnableAddPreset()
     * method will return false.
     */
    inline void clearEnableAddPreset();

    /**
     * Checks whether the field "EnableAddPreset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnableAddPreset()). Otherwise it will return false.
     */
    inline bool hasEnableAddPreset () const;

    /**
     * Returns the value of the member "EnableAddPreset".
     *
     * Flag to enable / disable add preset options further
     *
     * @return The value of the field "EnableAddPreset"
     */
    inline bool getEnableAddPreset () const;

    /**
     * Sets the value of the member "EnableAddPreset".
     *
     * Flag to enable / disable add preset options further
     *
     * @param EnableAddPreset The value which will be set
     */
    inline void setEnableAddPreset (bool EnableAddPreset_);

    // API of field "Status"

    static const int kStatus = 3;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Get smart favorite list control success or failure status
     *
     * @return The value of the field "Status"
     */
    inline ::sxm_audio_main_fi_types::T_e8_MethodStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Get smart favorite list control success or failure status
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    static const SmartFavoriteListControlResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_SFListElement >& getT_SFListElementList_DefaultInstance ();

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    inline void set_has_SmartFavoriteList ();

    inline void clear_has_SmartFavoriteList ();

    inline void set_has_EnableAddPreset ();

    inline void clear_has_EnableAddPreset ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_SFOperation _Operation;

    ::std::vector< ::sxm_audio_main_fi_types::T_SFListElement > _SmartFavoriteList;

    bool _EnableAddPreset;

    ::sxm_audio_main_fi_types::T_e8_MethodStatus _Status;

};

/**
 * The error message of 'SmartFavoriteListControl'
 */
class SmartFavoriteListControlErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SmartFavoriteListControlErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SmartFavoriteListControlErrorStructure (const SmartFavoriteListControlErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SmartFavoriteListControlErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SmartFavoriteListControlErrorStructure();

    /**
     * Assignment operator
     */
    inline SmartFavoriteListControlErrorStructure& operator = (const SmartFavoriteListControlErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SmartFavoriteListControlErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SmartFavoriteListControlErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SmartFavoriteListControlErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SmartFavoriteListControlErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SmartFavoriteListControlErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SmartFavoriteListControl'
 */
class SmartFavoriteListControlError  : public ::asf::core::Payload {
public:

    enum SmartFavoriteListControlErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SmartFavoriteListControlError ();

   /**
     * Copy constructor
     */
    inline  SmartFavoriteListControlError (const SmartFavoriteListControlError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SmartFavoriteListControlError();

    /**
     * Assigns a new value to this object.
     */
    inline SmartFavoriteListControlError& operator = (const SmartFavoriteListControlError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SmartFavoriteListControlError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SmartFavoriteListControlError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SmartFavoriteListControlError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SmartFavoriteListControlError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SmartFavoriteListControlError::SmartFavoriteListControlErrorField getField () const;

    inline void setField(SmartFavoriteListControlError::SmartFavoriteListControlErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SmartFavoriteListControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SmartFavoriteListControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SmartFavoriteListControlErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SmartFavoriteListControlErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SmartFavoriteListControlErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SmartFavoriteListControlErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SmartFavoriteListControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SmartFavoriteListControlErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SmartFavoriteListControlError &getDefaultInstance();

private:

    inline void cloneData (const SmartFavoriteListControlError& rhs);

    inline void deleteData ();

    SmartFavoriteListControlErrorField __field;

    union {
        SmartFavoriteListControlErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetCurrentVolume"
 * Set current volume mute or unmute state
 * Start method and get cyclic messages while processing and get the result
 * when finished "OPTYPE_STARTRESULT"
 */
class SetCurrentVolumeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetCurrentVolumeStart ();

    /**
     * Copy constructor
     */
    inline  SetCurrentVolumeStart (const SetCurrentVolumeStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetCurrentVolumeStart (bool IsMuteActive_);

    /**
     * Destructor
     */
    inline virtual  ~SetCurrentVolumeStart();

    /**
     * Assignment operator
     */
    inline SetCurrentVolumeStart& operator = (const SetCurrentVolumeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCurrentVolumeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCurrentVolumeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCurrentVolumeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCurrentVolumeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IsMuteActive"

    static const int kIsMuteActive = 0;

    /**
     * Clears the field "IsMuteActive".
     *
     * The field will be set to its default value. The hasIsMuteActive()
     * method will return false.
     */
    inline void clearIsMuteActive();

    /**
     * Checks whether the field "IsMuteActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMuteActive()). Otherwise it will return false.
     */
    inline bool hasIsMuteActive () const;

    /**
     * Returns the value of the member "IsMuteActive".
     *
     * Flag to inform audio is mute or unmute
     *
     * @return The value of the field "IsMuteActive"
     */
    inline bool getIsMuteActive () const;

    /**
     * Sets the value of the member "IsMuteActive".
     *
     * Flag to inform audio is mute or unmute
     *
     * @param IsMuteActive The value which will be set
     */
    inline void setIsMuteActive (bool IsMuteActive_);

    static const SetCurrentVolumeStart &getDefaultInstance();

private:

    inline void set_has_IsMuteActive ();

    inline void clear_has_IsMuteActive ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _IsMuteActive;

};

/**
 * The result message of the method "SetCurrentVolume"
 * Set current volume mute or unmute state
 * Result of method
 */
class SetCurrentVolumeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetCurrentVolumeResult ();

    /**
     * Copy constructor
     */
    inline  SetCurrentVolumeResult (const SetCurrentVolumeResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetCurrentVolumeResult (bool IsMuteActive_, ::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetCurrentVolumeResult();

    /**
     * Assignment operator
     */
    inline SetCurrentVolumeResult& operator = (const SetCurrentVolumeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCurrentVolumeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCurrentVolumeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCurrentVolumeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCurrentVolumeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IsMuteActive"

    static const int kIsMuteActive = 0;

    /**
     * Clears the field "IsMuteActive".
     *
     * The field will be set to its default value. The hasIsMuteActive()
     * method will return false.
     */
    inline void clearIsMuteActive();

    /**
     * Checks whether the field "IsMuteActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMuteActive()). Otherwise it will return false.
     */
    inline bool hasIsMuteActive () const;

    /**
     * Returns the value of the member "IsMuteActive".
     *
     * Flag to inform audio is mute or unmute
     *
     * @return The value of the field "IsMuteActive"
     */
    inline bool getIsMuteActive () const;

    /**
     * Sets the value of the member "IsMuteActive".
     *
     * Flag to inform audio is mute or unmute
     *
     * @param IsMuteActive The value which will be set
     */
    inline void setIsMuteActive (bool IsMuteActive_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Set current volume success or failure status
     *
     * @return The value of the field "Status"
     */
    inline ::sxm_audio_main_fi_types::T_e8_MethodStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Set current volume success or failure status
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    static const SetCurrentVolumeResult &getDefaultInstance();

private:

    inline void set_has_IsMuteActive ();

    inline void clear_has_IsMuteActive ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _IsMuteActive;

    ::sxm_audio_main_fi_types::T_e8_MethodStatus _Status;

};

/**
 * The error message of 'SetCurrentVolume'
 */
class SetCurrentVolumeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetCurrentVolumeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetCurrentVolumeErrorStructure (const SetCurrentVolumeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetCurrentVolumeErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetCurrentVolumeErrorStructure();

    /**
     * Assignment operator
     */
    inline SetCurrentVolumeErrorStructure& operator = (const SetCurrentVolumeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCurrentVolumeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCurrentVolumeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCurrentVolumeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCurrentVolumeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SetCurrentVolumeErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SetCurrentVolume'
 */
class SetCurrentVolumeError  : public ::asf::core::Payload {
public:

    enum SetCurrentVolumeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetCurrentVolumeError ();

   /**
     * Copy constructor
     */
    inline  SetCurrentVolumeError (const SetCurrentVolumeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetCurrentVolumeError();

    /**
     * Assigns a new value to this object.
     */
    inline SetCurrentVolumeError& operator = (const SetCurrentVolumeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCurrentVolumeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCurrentVolumeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCurrentVolumeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCurrentVolumeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetCurrentVolumeError::SetCurrentVolumeErrorField getField () const;

    inline void setField(SetCurrentVolumeError::SetCurrentVolumeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetCurrentVolumeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetCurrentVolumeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetCurrentVolumeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetCurrentVolumeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetCurrentVolumeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetCurrentVolumeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetCurrentVolumeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetCurrentVolumeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetCurrentVolumeError &getDefaultInstance();

private:

    inline void cloneData (const SetCurrentVolumeError& rhs);

    inline void deleteData ();

    SetCurrentVolumeErrorField __field;

    union {
        SetCurrentVolumeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "TuneScanControl"
 * Method to control sxm audio tune scan functionality
 * Request to start / stop tune scan in sxm audio
 */
class TuneScanControlStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TuneScanControlStart ();

    /**
     * Copy constructor
     */
    inline  TuneScanControlStart (const TuneScanControlStart &rhs);

    /**
     * All fields constructor
     */
    inline  TuneScanControlStart (::sxm_audio_main_fi_types::T_e8_TuneScanMode TuneScanMode_);

    /**
     * Destructor
     */
    inline virtual  ~TuneScanControlStart();

    /**
     * Assignment operator
     */
    inline TuneScanControlStart& operator = (const TuneScanControlStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TuneScanControlStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TuneScanControlStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TuneScanControlStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TuneScanControlStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TuneScanMode"

    static const int kTuneScanMode = 0;

    /**
     * Clears the field "TuneScanMode".
     *
     * The field will be set to its default value. The hasTuneScanMode()
     * method will return false.
     */
    inline void clearTuneScanMode();

    /**
     * Checks whether the field "TuneScanMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTuneScanMode()). Otherwise it will return false.
     */
    inline bool hasTuneScanMode () const;

    /**
     * Returns the value of the member "TuneScanMode".
     *
     * Tune Scan type defines the control type to be performed
     * 0 - START TUNE SCAN
     * 1 - STOP TUNE SCAN
     * 2 - SKIP FORWARD TUNE SCAN
     * 3 - SKIP BACKWARD TUNE SCAN
     * 4 - ABORT TUNE SCAN
     *
     * @return The value of the field "TuneScanMode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_TuneScanMode getTuneScanMode () const;

    /**
     * Sets the value of the member "TuneScanMode".
     *
     * Tune Scan type defines the control type to be performed
     * 0 - START TUNE SCAN
     * 1 - STOP TUNE SCAN
     * 2 - SKIP FORWARD TUNE SCAN
     * 3 - SKIP BACKWARD TUNE SCAN
     * 4 - ABORT TUNE SCAN
     *
     * @param TuneScanMode The value which will be set
     */
    inline void setTuneScanMode (::sxm_audio_main_fi_types::T_e8_TuneScanMode TuneScanMode_);

    static const TuneScanControlStart &getDefaultInstance();

private:

    inline void set_has_TuneScanMode ();

    inline void clear_has_TuneScanMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_TuneScanMode _TuneScanMode;

};

/**
 * The result message of the method "TuneScanControl"
 * Method to control sxm audio tune scan functionality
 */
class TuneScanControlResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TuneScanControlResult ();

    /**
     * Copy constructor
     */
    inline  TuneScanControlResult (const TuneScanControlResult &rhs);

    /**
     * All fields constructor
     */
    inline  TuneScanControlResult (::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    /**
     * Destructor
     */
    inline virtual  ~TuneScanControlResult();

    /**
     * Assignment operator
     */
    inline TuneScanControlResult& operator = (const TuneScanControlResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TuneScanControlResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TuneScanControlResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TuneScanControlResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TuneScanControlResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TuneScanControl was successful or not
     *
     * @return The value of the field "Status"
     */
    inline ::sxm_audio_main_fi_types::T_e8_MethodStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TuneScanControl was successful or not
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    static const TuneScanControlResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_MethodStatus _Status;

};

/**
 * The error message of 'TuneScanControl'
 */
class TuneScanControlErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TuneScanControlErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TuneScanControlErrorStructure (const TuneScanControlErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TuneScanControlErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~TuneScanControlErrorStructure();

    /**
     * Assignment operator
     */
    inline TuneScanControlErrorStructure& operator = (const TuneScanControlErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TuneScanControlErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TuneScanControlErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TuneScanControlErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TuneScanControlErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const TuneScanControlErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'TuneScanControl'
 */
class TuneScanControlError  : public ::asf::core::Payload {
public:

    enum TuneScanControlErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TuneScanControlError ();

   /**
     * Copy constructor
     */
    inline  TuneScanControlError (const TuneScanControlError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TuneScanControlError();

    /**
     * Assigns a new value to this object.
     */
    inline TuneScanControlError& operator = (const TuneScanControlError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TuneScanControlError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TuneScanControlError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TuneScanControlError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TuneScanControlError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TuneScanControlError::TuneScanControlErrorField getField () const;

    inline void setField(TuneScanControlError::TuneScanControlErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TuneScanControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TuneScanControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TuneScanControlErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TuneScanControlErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TuneScanControlErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TuneScanControlErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TuneScanControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TuneScanControlErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TuneScanControlError &getDefaultInstance();

private:

    inline void cloneData (const TuneScanControlError& rhs);

    inline void deleteData ();

    TuneScanControlErrorField __field;

    union {
        TuneScanControlErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetPresetList"
 * Get the list of channels in the selected preset band.
 */
class GetPresetListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPresetListStart ();

    /**
     * Copy constructor
     */
    inline  GetPresetListStart (const GetPresetListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetPresetListStart (uint32 PresetBand_);

    /**
     * Destructor
     */
    inline virtual  ~GetPresetListStart();

    /**
     * Assignment operator
     */
    inline GetPresetListStart& operator = (const GetPresetListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPresetListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPresetListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPresetListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPresetListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PresetBand"

    static const int kPresetBand = 0;

    /**
     * Clears the field "PresetBand".
     *
     * The field will be set to its default value. The hasPresetBand()
     * method will return false.
     */
    inline void clearPresetBand();

    /**
     * Checks whether the field "PresetBand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetBand()). Otherwise it will return false.
     */
    inline bool hasPresetBand () const;

    /**
     * Returns the value of the member "PresetBand".
     *
     * The preset band for which the list of channels and their properties needs to be retrieved. If the preset band is 255, then preset list of all the available bands will be provided.
     *
     * @return The value of the field "PresetBand"
     */
    inline uint32 getPresetBand () const;

    /**
     * Sets the value of the member "PresetBand".
     *
     * The preset band for which the list of channels and their properties needs to be retrieved. If the preset band is 255, then preset list of all the available bands will be provided.
     *
     * @param PresetBand The value which will be set
     */
    inline void setPresetBand (uint32 PresetBand_);

    static const GetPresetListStart &getDefaultInstance();

private:

    inline void set_has_PresetBand ();

    inline void clear_has_PresetBand ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _PresetBand;

};

/**
 * The result message of the method "GetPresetList"
 * Get the list of channels in the selected preset band.
 * Result of method. Provide presets list.
 */
class GetPresetListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPresetListResult ();

    /**
     * Copy constructor
     */
    inline  GetPresetListResult (const GetPresetListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetPresetListResult (const ::sxm_audio_main_fi_types::T_PresetChannelList& PresetChannels_, ::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    /**
     * Destructor
     */
    inline virtual  ~GetPresetListResult();

    /**
     * Assignment operator
     */
    inline GetPresetListResult& operator = (const GetPresetListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPresetListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPresetListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPresetListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPresetListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PresetChannels"

    static const int kPresetChannels = 0;

    /**
     * Clears the field "PresetChannels".
     *
     * The field will be set to its default value. The hasPresetChannels()
     * method will return false.
     */
    inline void clearPresetChannels();

    /**
     * Checks whether the field "PresetChannels" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetChannels()). Otherwise it will return false.
     */
    inline bool hasPresetChannels () const;

    /**
     * Returns the value of the member "PresetChannels".
     *
     * List of channels in the selected preset band
     *
     * @return The value of the field "PresetChannels"
     */
    inline const ::sxm_audio_main_fi_types::T_PresetChannelList& getPresetChannels () const;

    /**
     * Retrieves the value of the field "PresetChannels" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PresetChannels".
     */
    inline ::sxm_audio_main_fi_types::T_PresetChannelList& getPresetChannelsMutable ();

    /**
     * Sets the value of the member "PresetChannels".
     *
     * List of channels in the selected preset band
     *
     * @param PresetChannels The value which will be set
     */
    inline void setPresetChannels (const ::sxm_audio_main_fi_types::T_PresetChannelList& PresetChannels_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Get presets list success or failure status
     *
     * @return The value of the field "Status"
     */
    inline ::sxm_audio_main_fi_types::T_e8_MethodStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Get presets list success or failure status
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::sxm_audio_main_fi_types::T_e8_MethodStatus Status_);

    static const GetPresetListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_PresetListEntry >& getT_PresetListEntryList_DefaultInstance ();

    inline void set_has_PresetChannels ();

    inline void clear_has_PresetChannels ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_audio_main_fi_types::T_PresetChannelList _PresetChannels;

    ::sxm_audio_main_fi_types::T_e8_MethodStatus _Status;

};

/**
 * The error message of 'GetPresetList'
 */
class GetPresetListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetPresetListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetPresetListErrorStructure (const GetPresetListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetPresetListErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetPresetListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetPresetListErrorStructure& operator = (const GetPresetListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPresetListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPresetListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPresetListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPresetListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const GetPresetListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetPresetList'
 */
class GetPresetListError  : public ::asf::core::Payload {
public:

    enum GetPresetListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetPresetListError ();

   /**
     * Copy constructor
     */
    inline  GetPresetListError (const GetPresetListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetPresetListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetPresetListError& operator = (const GetPresetListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPresetListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPresetListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPresetListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPresetListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetPresetListError::GetPresetListErrorField getField () const;

    inline void setField(GetPresetListError::GetPresetListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetPresetListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetPresetListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetPresetListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetPresetListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetPresetListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetPresetListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetPresetListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetPresetListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetPresetListError &getDefaultInstance();

private:

    inline void cloneData (const GetPresetListError& rhs);

    inline void deleteData ();

    GetPresetListErrorField __field;

    union {
        GetPresetListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DisableMatureChannels"
 * Lock/Unlock all channels that are identified to Broadcast Mature Content.
 */
class DisableMatureChannelsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisableMatureChannelsStart ();

    /**
     * Copy constructor
     */
    inline  DisableMatureChannelsStart (const DisableMatureChannelsStart &rhs);

    /**
     * All fields constructor
     */
    inline  DisableMatureChannelsStart (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~DisableMatureChannelsStart();

    /**
     * Assignment operator
     */
    inline DisableMatureChannelsStart& operator = (const DisableMatureChannelsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisableMatureChannelsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisableMatureChannelsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisableMatureChannelsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisableMatureChannelsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Enable/Disable Mature Channels.
     * <p>If TRUE, all mature channels would be locked.</p>
     * <p>If FALSE, all mature channels would be unlocked.</p>
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Enable/Disable Mature Channels.
     * <p>If TRUE, all mature channels would be locked.</p>
     * <p>If FALSE, all mature channels would be unlocked.</p>
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const DisableMatureChannelsStart &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The result message of the method "DisableMatureChannels"
 * Lock/Unlock all channels that are identified to Broadcast Mature Content.
 * Disable Mature Channels status.
 */
class DisableMatureChannelsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisableMatureChannelsResult ();

    /**
     * Copy constructor
     */
    inline  DisableMatureChannelsResult (const DisableMatureChannelsResult &rhs);

    /**
     * All fields constructor
     */
    inline  DisableMatureChannelsResult (bool LockStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DisableMatureChannelsResult();

    /**
     * Assignment operator
     */
    inline DisableMatureChannelsResult& operator = (const DisableMatureChannelsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisableMatureChannelsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisableMatureChannelsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisableMatureChannelsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisableMatureChannelsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LockStatus"

    static const int kLockStatus = 0;

    /**
     * Clears the field "LockStatus".
     *
     * The field will be set to its default value. The hasLockStatus()
     * method will return false.
     */
    inline void clearLockStatus();

    /**
     * Checks whether the field "LockStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLockStatus()). Otherwise it will return false.
     */
    inline bool hasLockStatus () const;

    /**
     * Returns the value of the member "LockStatus".
     *
     * Status of method request.
     * <p>If TRUE, the request to Lock/Unlock Mature Channels was successful.</p>
     * <p>If FALSE, the request to Lock/Unlock Mature Channels was unsuccessful.</p>
     *
     * @return The value of the field "LockStatus"
     */
    inline bool getLockStatus () const;

    /**
     * Sets the value of the member "LockStatus".
     *
     * Status of method request.
     * <p>If TRUE, the request to Lock/Unlock Mature Channels was successful.</p>
     * <p>If FALSE, the request to Lock/Unlock Mature Channels was unsuccessful.</p>
     *
     * @param LockStatus The value which will be set
     */
    inline void setLockStatus (bool LockStatus_);

    static const DisableMatureChannelsResult &getDefaultInstance();

private:

    inline void set_has_LockStatus ();

    inline void clear_has_LockStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _LockStatus;

};

/**
 * The error message of 'DisableMatureChannels'
 */
class DisableMatureChannelsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DisableMatureChannelsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DisableMatureChannelsErrorStructure (const DisableMatureChannelsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DisableMatureChannelsErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DisableMatureChannelsErrorStructure();

    /**
     * Assignment operator
     */
    inline DisableMatureChannelsErrorStructure& operator = (const DisableMatureChannelsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisableMatureChannelsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisableMatureChannelsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisableMatureChannelsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisableMatureChannelsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const DisableMatureChannelsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'DisableMatureChannels'
 */
class DisableMatureChannelsError  : public ::asf::core::Payload {
public:

    enum DisableMatureChannelsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DisableMatureChannelsError ();

   /**
     * Copy constructor
     */
    inline  DisableMatureChannelsError (const DisableMatureChannelsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DisableMatureChannelsError();

    /**
     * Assigns a new value to this object.
     */
    inline DisableMatureChannelsError& operator = (const DisableMatureChannelsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisableMatureChannelsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisableMatureChannelsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisableMatureChannelsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisableMatureChannelsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DisableMatureChannelsError::DisableMatureChannelsErrorField getField () const;

    inline void setField(DisableMatureChannelsError::DisableMatureChannelsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DisableMatureChannelsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DisableMatureChannelsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DisableMatureChannelsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DisableMatureChannelsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DisableMatureChannelsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DisableMatureChannelsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DisableMatureChannelsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DisableMatureChannelsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DisableMatureChannelsError &getDefaultInstance();

private:

    inline void cloneData (const DisableMatureChannelsError& rhs);

    inline void deleteData ();

    DisableMatureChannelsErrorField __field;

    union {
        DisableMatureChannelsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SkipChannel"
 * Method to be set or unset channel skip status to one or all channels .
 */
class SkipChannelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SkipChannelStart ();

    /**
     * Copy constructor
     */
    inline  SkipChannelStart (const SkipChannelStart &rhs);

    /**
     * All fields constructor
     */
    inline  SkipChannelStart (::sxm_audio_main_fi_types::T_e8_ChannelSkipType SkipChannelType_, uint16 ServiceID_, uint16 ChannelID_);

    /**
     * Destructor
     */
    inline virtual  ~SkipChannelStart();

    /**
     * Assignment operator
     */
    inline SkipChannelStart& operator = (const SkipChannelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SkipChannelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SkipChannelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SkipChannelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SkipChannelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SkipChannelType"

    static const int kSkipChannelType = 0;

    /**
     * Clears the field "SkipChannelType".
     *
     * The field will be set to its default value. The hasSkipChannelType()
     * method will return false.
     */
    inline void clearSkipChannelType();

    /**
     * Checks whether the field "SkipChannelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSkipChannelType()). Otherwise it will return false.
     */
    inline bool hasSkipChannelType () const;

    /**
     * Returns the value of the member "SkipChannelType".
     *
     * Set/Unset channel skip state to one or all channels.
     *
     * @return The value of the field "SkipChannelType"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ChannelSkipType getSkipChannelType () const;

    /**
     * Sets the value of the member "SkipChannelType".
     *
     * Set/Unset channel skip state to one or all channels.
     *
     * @param SkipChannelType The value which will be set
     */
    inline void setSkipChannelType (::sxm_audio_main_fi_types::T_e8_ChannelSkipType SkipChannelType_);

    // API of field "ServiceID"

    static const int kServiceID = 1;

    /**
     * Clears the field "ServiceID".
     *
     * The field will be set to its default value. The hasServiceID()
     * method will return false.
     */
    inline void clearServiceID();

    /**
     * Checks whether the field "ServiceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceID()). Otherwise it will return false.
     */
    inline bool hasServiceID () const;

    /**
     * Returns the value of the member "ServiceID".
     *
     * Applicable only if skip action is either SKIP_SELECTION or UNSKIP_SELECTION.
     * Channel's ServiceID.
     *
     * @return The value of the field "ServiceID"
     */
    inline uint16 getServiceID () const;

    /**
     * Sets the value of the member "ServiceID".
     *
     * Applicable only if skip action is either SKIP_SELECTION or UNSKIP_SELECTION.
     * Channel's ServiceID.
     *
     * @param ServiceID The value which will be set
     */
    inline void setServiceID (uint16 ServiceID_);

    // API of field "ChannelID"

    static const int kChannelID = 2;

    /**
     * Clears the field "ChannelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "ChannelID".
     *
     * Applicable only if skip action is either SKIP_SELECTION or UNSKIP_SELECTION.
     * Channel's ServiceID.
     *
     * @return The value of the field "ChannelID"
     */
    inline uint16 getChannelID () const;

    /**
     * Sets the value of the member "ChannelID".
     *
     * Applicable only if skip action is either SKIP_SELECTION or UNSKIP_SELECTION.
     * Channel's ServiceID.
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (uint16 ChannelID_);

    static const SkipChannelStart &getDefaultInstance();

private:

    inline void set_has_SkipChannelType ();

    inline void clear_has_SkipChannelType ();

    inline void set_has_ServiceID ();

    inline void clear_has_ServiceID ();

    inline void set_has_ChannelID ();

    inline void clear_has_ChannelID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ChannelSkipType _SkipChannelType;

    uint16 _ServiceID;

    uint16 _ChannelID;

};

/**
 * The result message of the method "SkipChannel"
 * Method to be set or unset channel skip status to one or all channels .
 * Disable Mature Channels status.
 */
class SkipChannelResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SkipChannelResult ();

    /**
     * Copy constructor
     */
    inline  SkipChannelResult (const SkipChannelResult &rhs);

    /**
     * All fields constructor
     */
    inline  SkipChannelResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SkipChannelResult();

    /**
     * Assignment operator
     */
    inline SkipChannelResult& operator = (const SkipChannelResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SkipChannelResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SkipChannelResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SkipChannelResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SkipChannelResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status of method request.
     * <p>If TRUE, the request to Skip/Unskip One/All Channel(s) was successful.</p>
     * <p>If FALSE, the request to Skip/Unskip One/All Channel(s) was unsuccessful.</p>
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Status of method request.
     * <p>If TRUE, the request to Skip/Unskip One/All Channel(s) was successful.</p>
     * <p>If FALSE, the request to Skip/Unskip One/All Channel(s) was unsuccessful.</p>
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SkipChannelResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SkipChannel'
 */
class SkipChannelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SkipChannelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SkipChannelErrorStructure (const SkipChannelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SkipChannelErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SkipChannelErrorStructure();

    /**
     * Assignment operator
     */
    inline SkipChannelErrorStructure& operator = (const SkipChannelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SkipChannelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SkipChannelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SkipChannelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SkipChannelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SkipChannelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SkipChannel'
 */
class SkipChannelError  : public ::asf::core::Payload {
public:

    enum SkipChannelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SkipChannelError ();

   /**
     * Copy constructor
     */
    inline  SkipChannelError (const SkipChannelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SkipChannelError();

    /**
     * Assigns a new value to this object.
     */
    inline SkipChannelError& operator = (const SkipChannelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SkipChannelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SkipChannelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SkipChannelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SkipChannelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SkipChannelError::SkipChannelErrorField getField () const;

    inline void setField(SkipChannelError::SkipChannelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SkipChannelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SkipChannelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SkipChannelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SkipChannelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SkipChannelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SkipChannelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SkipChannelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SkipChannelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SkipChannelError &getDefaultInstance();

private:

    inline void cloneData (const SkipChannelError& rhs);

    inline void deleteData ();

    SkipChannelErrorField __field;

    union {
        SkipChannelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SaveFavorite"
 * Save the currently playing channel as favorite artist or song
 */
class SaveFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SaveFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  SaveFavoriteStart (const SaveFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  SaveFavoriteStart (uint16 ServiceID_, uint16 ChannelID_, ::sxm_audio_main_fi_types::T_e8_FavoriteType FavoriteType_, uint8 MaxFavoriteCount_);

    /**
     * Destructor
     */
    inline virtual  ~SaveFavoriteStart();

    /**
     * Assignment operator
     */
    inline SaveFavoriteStart& operator = (const SaveFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceID"

    static const int kServiceID = 0;

    /**
     * Clears the field "ServiceID".
     *
     * The field will be set to its default value. The hasServiceID()
     * method will return false.
     */
    inline void clearServiceID();

    /**
     * Checks whether the field "ServiceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceID()). Otherwise it will return false.
     */
    inline bool hasServiceID () const;

    /**
     * Returns the value of the member "ServiceID".
     *
     * Service ID
     *
     * @return The value of the field "ServiceID"
     */
    inline uint16 getServiceID () const;

    /**
     * Sets the value of the member "ServiceID".
     *
     * Service ID
     *
     * @param ServiceID The value which will be set
     */
    inline void setServiceID (uint16 ServiceID_);

    // API of field "ChannelID"

    static const int kChannelID = 1;

    /**
     * Clears the field "ChannelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "ChannelID".
     *
     * Channel ID
     *
     * @return The value of the field "ChannelID"
     */
    inline uint16 getChannelID () const;

    /**
     * Sets the value of the member "ChannelID".
     *
     * Channel ID
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (uint16 ChannelID_);

    // API of field "FavoriteType"

    static const int kFavoriteType = 2;

    /**
     * Clears the field "FavoriteType".
     *
     * The field will be set to its default value. The hasFavoriteType()
     * method will return false.
     */
    inline void clearFavoriteType();

    /**
     * Checks whether the field "FavoriteType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteType()). Otherwise it will return false.
     */
    inline bool hasFavoriteType () const;

    /**
     * Returns the value of the member "FavoriteType".
     *
     * The type of favorite either ARTIST or SONG
     *
     * @return The value of the field "FavoriteType"
     */
    inline ::sxm_audio_main_fi_types::T_e8_FavoriteType getFavoriteType () const;

    /**
     * Sets the value of the member "FavoriteType".
     *
     * The type of favorite either ARTIST or SONG
     *
     * @param FavoriteType The value which will be set
     */
    inline void setFavoriteType (::sxm_audio_main_fi_types::T_e8_FavoriteType FavoriteType_);

    // API of field "MaxFavoriteCount"

    static const int kMaxFavoriteCount = 3;

    /**
     * Clears the field "MaxFavoriteCount".
     *
     * The field will be set to its default value. The hasMaxFavoriteCount()
     * method will return false.
     */
    inline void clearMaxFavoriteCount();

    /**
     * Checks whether the field "MaxFavoriteCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxFavoriteCount()). Otherwise it will return false.
     */
    inline bool hasMaxFavoriteCount () const;

    /**
     * Returns the value of the member "MaxFavoriteCount".
     *
     * Maximum no. of favorite count supported
     *
     * @return The value of the field "MaxFavoriteCount"
     */
    inline uint8 getMaxFavoriteCount () const;

    /**
     * Sets the value of the member "MaxFavoriteCount".
     *
     * Maximum no. of favorite count supported
     *
     * @param MaxFavoriteCount The value which will be set
     */
    inline void setMaxFavoriteCount (uint8 MaxFavoriteCount_);

    static const SaveFavoriteStart &getDefaultInstance();

private:

    inline void set_has_ServiceID ();

    inline void clear_has_ServiceID ();

    inline void set_has_ChannelID ();

    inline void clear_has_ChannelID ();

    inline void set_has_FavoriteType ();

    inline void clear_has_FavoriteType ();

    inline void set_has_MaxFavoriteCount ();

    inline void clear_has_MaxFavoriteCount ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _ServiceID;

    uint16 _ChannelID;

    ::sxm_audio_main_fi_types::T_e8_FavoriteType _FavoriteType;

    uint8 _MaxFavoriteCount;

};

/**
 * The result message of the method "SaveFavorite"
 * Save the currently playing channel as favorite artist or song
 */
class SaveFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SaveFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  SaveFavoriteResult (const SaveFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  SaveFavoriteResult (const ::std::string& ContentName_, ::sxm_audio_main_fi_types::T_e8_FavoriteType FavoriteType_, uint8 FavoriteCount_, ::sxm_audio_main_fi_types::T_e8_FavoriteStatus Status_);

    /**
     * Destructor
     */
    inline virtual  ~SaveFavoriteResult();

    /**
     * Assignment operator
     */
    inline SaveFavoriteResult& operator = (const SaveFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ContentName"

    static const int kContentName = 0;

    /**
     * Clears the field "ContentName".
     *
     * The field will be set to its default value. The hasContentName()
     * method will return false.
     */
    inline void clearContentName();

    /**
     * Checks whether the field "ContentName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContentName()). Otherwise it will return false.
     */
    inline bool hasContentName () const;

    /**
     * Returns the value of the member "ContentName".
     *
     * Name of the saved content
     *
     * @return The value of the field "ContentName"
     */
    inline const ::std::string& getContentName () const;

    /**
     * Retrieves the value of the field "ContentName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ContentName".
     */
    inline ::std::string& getContentNameMutable ();

    /**
     * Sets the value of the member "ContentName".
     *
     * Name of the saved content
     *
     * @param ContentName The value which will be set
     */
    inline void setContentName (const ::std::string& ContentName_);

    /**
     * Sets the value of the member "ContentName".
     *
     * Name of the saved content
     *
     * @param ContentName The value which will be set
     */
    inline void setContentName (const char* ContentName_);

    /**
     * Sets the value of the member "ContentName".
     *
     * Name of the saved content
     *
     * @param ContentName The value which will be set
     */
    inline void setContentName (const char* value, size_t size);

    // API of field "FavoriteType"

    static const int kFavoriteType = 1;

    /**
     * Clears the field "FavoriteType".
     *
     * The field will be set to its default value. The hasFavoriteType()
     * method will return false.
     */
    inline void clearFavoriteType();

    /**
     * Checks whether the field "FavoriteType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteType()). Otherwise it will return false.
     */
    inline bool hasFavoriteType () const;

    /**
     * Returns the value of the member "FavoriteType".
     *
     * The type of favorite either ARTIST or SONG
     *
     * @return The value of the field "FavoriteType"
     */
    inline ::sxm_audio_main_fi_types::T_e8_FavoriteType getFavoriteType () const;

    /**
     * Sets the value of the member "FavoriteType".
     *
     * The type of favorite either ARTIST or SONG
     *
     * @param FavoriteType The value which will be set
     */
    inline void setFavoriteType (::sxm_audio_main_fi_types::T_e8_FavoriteType FavoriteType_);

    // API of field "FavoriteCount"

    static const int kFavoriteCount = 2;

    /**
     * Clears the field "FavoriteCount".
     *
     * The field will be set to its default value. The hasFavoriteCount()
     * method will return false.
     */
    inline void clearFavoriteCount();

    /**
     * Checks whether the field "FavoriteCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteCount()). Otherwise it will return false.
     */
    inline bool hasFavoriteCount () const;

    /**
     * Returns the value of the member "FavoriteCount".
     *
     * No of registered favorites either for artist or song
     *
     * @return The value of the field "FavoriteCount"
     */
    inline uint8 getFavoriteCount () const;

    /**
     * Sets the value of the member "FavoriteCount".
     *
     * No of registered favorites either for artist or song
     *
     * @param FavoriteCount The value which will be set
     */
    inline void setFavoriteCount (uint8 FavoriteCount_);

    // API of field "Status"

    static const int kStatus = 3;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status of save favorite
     *
     * @return The value of the field "Status"
     */
    inline ::sxm_audio_main_fi_types::T_e8_FavoriteStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Status of save favorite
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::sxm_audio_main_fi_types::T_e8_FavoriteStatus Status_);

    static const SaveFavoriteResult &getDefaultInstance();

private:

    inline void set_has_ContentName ();

    inline void clear_has_ContentName ();

    inline void set_has_FavoriteType ();

    inline void clear_has_FavoriteType ();

    inline void set_has_FavoriteCount ();

    inline void clear_has_FavoriteCount ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _ContentName;

    ::sxm_audio_main_fi_types::T_e8_FavoriteType _FavoriteType;

    uint8 _FavoriteCount;

    ::sxm_audio_main_fi_types::T_e8_FavoriteStatus _Status;

};

/**
 * The error message of 'SaveFavorite'
 */
class SaveFavoriteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SaveFavoriteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SaveFavoriteErrorStructure (const SaveFavoriteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SaveFavoriteErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SaveFavoriteErrorStructure();

    /**
     * Assignment operator
     */
    inline SaveFavoriteErrorStructure& operator = (const SaveFavoriteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveFavoriteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveFavoriteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveFavoriteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveFavoriteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SaveFavoriteErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SaveFavorite'
 */
class SaveFavoriteError  : public ::asf::core::Payload {
public:

    enum SaveFavoriteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SaveFavoriteError ();

   /**
     * Copy constructor
     */
    inline  SaveFavoriteError (const SaveFavoriteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SaveFavoriteError();

    /**
     * Assigns a new value to this object.
     */
    inline SaveFavoriteError& operator = (const SaveFavoriteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveFavoriteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveFavoriteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveFavoriteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveFavoriteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SaveFavoriteError::SaveFavoriteErrorField getField () const;

    inline void setField(SaveFavoriteError::SaveFavoriteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SaveFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SaveFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SaveFavoriteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SaveFavoriteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SaveFavoriteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SaveFavoriteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SaveFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SaveFavoriteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SaveFavoriteError &getDefaultInstance();

private:

    inline void cloneData (const SaveFavoriteError& rhs);

    inline void deleteData ();

    SaveFavoriteErrorField __field;

    union {
        SaveFavoriteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetFavoriteList"
 * Get list of favorite for artist or song
 */
class GetFavoriteListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteListStart ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteListStart (const GetFavoriteListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteListStart (::sxm_audio_main_fi_types::T_e8_FavoriteType FavoriteType_);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteListStart();

    /**
     * Assignment operator
     */
    inline GetFavoriteListStart& operator = (const GetFavoriteListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FavoriteType"

    static const int kFavoriteType = 0;

    /**
     * Clears the field "FavoriteType".
     *
     * The field will be set to its default value. The hasFavoriteType()
     * method will return false.
     */
    inline void clearFavoriteType();

    /**
     * Checks whether the field "FavoriteType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteType()). Otherwise it will return false.
     */
    inline bool hasFavoriteType () const;

    /**
     * Returns the value of the member "FavoriteType".
     *
     * The type of favorite either ARTIST or SONG
     *
     * @return The value of the field "FavoriteType"
     */
    inline ::sxm_audio_main_fi_types::T_e8_FavoriteType getFavoriteType () const;

    /**
     * Sets the value of the member "FavoriteType".
     *
     * The type of favorite either ARTIST or SONG
     *
     * @param FavoriteType The value which will be set
     */
    inline void setFavoriteType (::sxm_audio_main_fi_types::T_e8_FavoriteType FavoriteType_);

    static const GetFavoriteListStart &getDefaultInstance();

private:

    inline void set_has_FavoriteType ();

    inline void clear_has_FavoriteType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_FavoriteType _FavoriteType;

};

/**
 * The result message of the method "GetFavoriteList"
 * Get list of favorite for artist or song
 */
class GetFavoriteListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteListResult ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteListResult (const GetFavoriteListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteListResult (const ::std::vector< ::sxm_audio_main_fi_types::T_RegisteredFavorite >& RegisteredFavoriteList_);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteListResult();

    /**
     * Assignment operator
     */
    inline GetFavoriteListResult& operator = (const GetFavoriteListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RegisteredFavoriteList"

    static const int kRegisteredFavoriteList = 0;

    /**
     * Clears the field "RegisteredFavoriteList".
     *
     * The field will be set to its default value. The hasRegisteredFavoriteList()
     * method will return false.
     */
    inline void clearRegisteredFavoriteList();

    /**
     * Checks whether the field "RegisteredFavoriteList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegisteredFavoriteList()). Otherwise it will return false.
     */
    inline bool hasRegisteredFavoriteList () const;

    /**
     * Returns the value of the member "RegisteredFavoriteList".
     *
     * List of registered favorite artist or song
     *
     * @return The value of the field "RegisteredFavoriteList"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_RegisteredFavorite >& getRegisteredFavoriteList () const;

    /**
     * Retrieves the value of the field "RegisteredFavoriteList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RegisteredFavoriteList".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_RegisteredFavorite >& getRegisteredFavoriteListMutable ();

    /**
     * Sets the value of the member "RegisteredFavoriteList".
     *
     * List of registered favorite artist or song
     *
     * @param RegisteredFavoriteList The value which will be set
     */
    inline void setRegisteredFavoriteList (const ::std::vector< ::sxm_audio_main_fi_types::T_RegisteredFavorite >& RegisteredFavoriteList_);

    static const GetFavoriteListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_RegisteredFavorite >& getT_RegisteredFavoriteList_DefaultInstance ();

    inline void set_has_RegisteredFavoriteList ();

    inline void clear_has_RegisteredFavoriteList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_audio_main_fi_types::T_RegisteredFavorite > _RegisteredFavoriteList;

};

/**
 * The error message of 'GetFavoriteList'
 */
class GetFavoriteListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteListErrorStructure (const GetFavoriteListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteListErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetFavoriteListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetFavoriteListErrorStructure& operator = (const GetFavoriteListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const GetFavoriteListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetFavoriteList'
 */
class GetFavoriteListError  : public ::asf::core::Payload {
public:

    enum GetFavoriteListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetFavoriteListError ();

   /**
     * Copy constructor
     */
    inline  GetFavoriteListError (const GetFavoriteListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetFavoriteListError& operator = (const GetFavoriteListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetFavoriteListError::GetFavoriteListErrorField getField () const;

    inline void setField(GetFavoriteListError::GetFavoriteListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetFavoriteListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetFavoriteListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetFavoriteListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetFavoriteListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetFavoriteListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetFavoriteListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetFavoriteListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetFavoriteListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetFavoriteListError &getDefaultInstance();

private:

    inline void cloneData (const GetFavoriteListError& rhs);

    inline void deleteData ();

    GetFavoriteListErrorField __field;

    union {
        GetFavoriteListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ModifyFavorite"
 * Get alert notification list
 */
class ModifyFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ModifyFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  ModifyFavoriteStart (const ModifyFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  ModifyFavoriteStart (::sxm_audio_main_fi_types::T_e8_FavoriteType FavoriteType_, ::sxm_audio_main_fi_types::T_e8_Action Action_, const ::std::string& ContentName_);

    /**
     * Destructor
     */
    inline virtual  ~ModifyFavoriteStart();

    /**
     * Assignment operator
     */
    inline ModifyFavoriteStart& operator = (const ModifyFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ModifyFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ModifyFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ModifyFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ModifyFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FavoriteType"

    static const int kFavoriteType = 0;

    /**
     * Clears the field "FavoriteType".
     *
     * The field will be set to its default value. The hasFavoriteType()
     * method will return false.
     */
    inline void clearFavoriteType();

    /**
     * Checks whether the field "FavoriteType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteType()). Otherwise it will return false.
     */
    inline bool hasFavoriteType () const;

    /**
     * Returns the value of the member "FavoriteType".
     *
     * The type of favorite either ARTIST or SONG
     *
     * @return The value of the field "FavoriteType"
     */
    inline ::sxm_audio_main_fi_types::T_e8_FavoriteType getFavoriteType () const;

    /**
     * Sets the value of the member "FavoriteType".
     *
     * The type of favorite either ARTIST or SONG
     *
     * @param FavoriteType The value which will be set
     */
    inline void setFavoriteType (::sxm_audio_main_fi_types::T_e8_FavoriteType FavoriteType_);

    // API of field "Action"

    static const int kAction = 1;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * Action to be taken on favorite
     *
     * @return The value of the field "Action"
     */
    inline ::sxm_audio_main_fi_types::T_e8_Action getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * Action to be taken on favorite
     *
     * @param Action The value which will be set
     */
    inline void setAction (::sxm_audio_main_fi_types::T_e8_Action Action_);

    // API of field "ContentName"

    static const int kContentName = 2;

    /**
     * Clears the field "ContentName".
     *
     * The field will be set to its default value. The hasContentName()
     * method will return false.
     */
    inline void clearContentName();

    /**
     * Checks whether the field "ContentName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContentName()). Otherwise it will return false.
     */
    inline bool hasContentName () const;

    /**
     * Returns the value of the member "ContentName".
     *
     * <p>Contains string of selected favorite either artist or song. This value should be NULL when action is BLOCK, UNBLOCK, ENABLE_ALL, DISABLE_ALL, DELETE_ALL</p>
     *
     * @return The value of the field "ContentName"
     */
    inline const ::std::string& getContentName () const;

    /**
     * Retrieves the value of the field "ContentName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ContentName".
     */
    inline ::std::string& getContentNameMutable ();

    /**
     * Sets the value of the member "ContentName".
     *
     * <p>Contains string of selected favorite either artist or song. This value should be NULL when action is BLOCK, UNBLOCK, ENABLE_ALL, DISABLE_ALL, DELETE_ALL</p>
     *
     * @param ContentName The value which will be set
     */
    inline void setContentName (const ::std::string& ContentName_);

    /**
     * Sets the value of the member "ContentName".
     *
     * <p>Contains string of selected favorite either artist or song. This value should be NULL when action is BLOCK, UNBLOCK, ENABLE_ALL, DISABLE_ALL, DELETE_ALL</p>
     *
     * @param ContentName The value which will be set
     */
    inline void setContentName (const char* ContentName_);

    /**
     * Sets the value of the member "ContentName".
     *
     * <p>Contains string of selected favorite either artist or song. This value should be NULL when action is BLOCK, UNBLOCK, ENABLE_ALL, DISABLE_ALL, DELETE_ALL</p>
     *
     * @param ContentName The value which will be set
     */
    inline void setContentName (const char* value, size_t size);

    static const ModifyFavoriteStart &getDefaultInstance();

private:

    inline void set_has_FavoriteType ();

    inline void clear_has_FavoriteType ();

    inline void set_has_Action ();

    inline void clear_has_Action ();

    inline void set_has_ContentName ();

    inline void clear_has_ContentName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_FavoriteType _FavoriteType;

    ::sxm_audio_main_fi_types::T_e8_Action _Action;

    ::std::string _ContentName;

};

/**
 * The result message of the method "ModifyFavorite"
 * Get alert notification list
 */
class ModifyFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ModifyFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  ModifyFavoriteResult (const ModifyFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  ModifyFavoriteResult (::sxm_audio_main_fi_types::T_e8_FavoriteType FavoriteType_, ::sxm_audio_main_fi_types::T_e8_Action Action_, const ::std::string& ContentName_);

    /**
     * Destructor
     */
    inline virtual  ~ModifyFavoriteResult();

    /**
     * Assignment operator
     */
    inline ModifyFavoriteResult& operator = (const ModifyFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ModifyFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ModifyFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ModifyFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ModifyFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FavoriteType"

    static const int kFavoriteType = 0;

    /**
     * Clears the field "FavoriteType".
     *
     * The field will be set to its default value. The hasFavoriteType()
     * method will return false.
     */
    inline void clearFavoriteType();

    /**
     * Checks whether the field "FavoriteType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteType()). Otherwise it will return false.
     */
    inline bool hasFavoriteType () const;

    /**
     * Returns the value of the member "FavoriteType".
     *
     * The type of favorite either ARTIST or SONG
     *
     * @return The value of the field "FavoriteType"
     */
    inline ::sxm_audio_main_fi_types::T_e8_FavoriteType getFavoriteType () const;

    /**
     * Sets the value of the member "FavoriteType".
     *
     * The type of favorite either ARTIST or SONG
     *
     * @param FavoriteType The value which will be set
     */
    inline void setFavoriteType (::sxm_audio_main_fi_types::T_e8_FavoriteType FavoriteType_);

    // API of field "Action"

    static const int kAction = 1;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * Action to be taken on favorite
     *
     * @return The value of the field "Action"
     */
    inline ::sxm_audio_main_fi_types::T_e8_Action getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * Action to be taken on favorite
     *
     * @param Action The value which will be set
     */
    inline void setAction (::sxm_audio_main_fi_types::T_e8_Action Action_);

    // API of field "ContentName"

    static const int kContentName = 2;

    /**
     * Clears the field "ContentName".
     *
     * The field will be set to its default value. The hasContentName()
     * method will return false.
     */
    inline void clearContentName();

    /**
     * Checks whether the field "ContentName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContentName()). Otherwise it will return false.
     */
    inline bool hasContentName () const;

    /**
     * Returns the value of the member "ContentName".
     *
     * <p>Contains string of favorite either artist or song. This value should be NULL when action is BLOCK, UNBLOCK, ENABLE_ALL, DISABLE_ALL, DELETE_ALL</p>
     *
     * @return The value of the field "ContentName"
     */
    inline const ::std::string& getContentName () const;

    /**
     * Retrieves the value of the field "ContentName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ContentName".
     */
    inline ::std::string& getContentNameMutable ();

    /**
     * Sets the value of the member "ContentName".
     *
     * <p>Contains string of favorite either artist or song. This value should be NULL when action is BLOCK, UNBLOCK, ENABLE_ALL, DISABLE_ALL, DELETE_ALL</p>
     *
     * @param ContentName The value which will be set
     */
    inline void setContentName (const ::std::string& ContentName_);

    /**
     * Sets the value of the member "ContentName".
     *
     * <p>Contains string of favorite either artist or song. This value should be NULL when action is BLOCK, UNBLOCK, ENABLE_ALL, DISABLE_ALL, DELETE_ALL</p>
     *
     * @param ContentName The value which will be set
     */
    inline void setContentName (const char* ContentName_);

    /**
     * Sets the value of the member "ContentName".
     *
     * <p>Contains string of favorite either artist or song. This value should be NULL when action is BLOCK, UNBLOCK, ENABLE_ALL, DISABLE_ALL, DELETE_ALL</p>
     *
     * @param ContentName The value which will be set
     */
    inline void setContentName (const char* value, size_t size);

    static const ModifyFavoriteResult &getDefaultInstance();

private:

    inline void set_has_FavoriteType ();

    inline void clear_has_FavoriteType ();

    inline void set_has_Action ();

    inline void clear_has_Action ();

    inline void set_has_ContentName ();

    inline void clear_has_ContentName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_FavoriteType _FavoriteType;

    ::sxm_audio_main_fi_types::T_e8_Action _Action;

    ::std::string _ContentName;

};

/**
 * The error message of 'ModifyFavorite'
 */
class ModifyFavoriteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ModifyFavoriteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ModifyFavoriteErrorStructure (const ModifyFavoriteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ModifyFavoriteErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~ModifyFavoriteErrorStructure();

    /**
     * Assignment operator
     */
    inline ModifyFavoriteErrorStructure& operator = (const ModifyFavoriteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ModifyFavoriteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ModifyFavoriteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ModifyFavoriteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ModifyFavoriteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const ModifyFavoriteErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'ModifyFavorite'
 */
class ModifyFavoriteError  : public ::asf::core::Payload {
public:

    enum ModifyFavoriteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ModifyFavoriteError ();

   /**
     * Copy constructor
     */
    inline  ModifyFavoriteError (const ModifyFavoriteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ModifyFavoriteError();

    /**
     * Assigns a new value to this object.
     */
    inline ModifyFavoriteError& operator = (const ModifyFavoriteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ModifyFavoriteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ModifyFavoriteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ModifyFavoriteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ModifyFavoriteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ModifyFavoriteError::ModifyFavoriteErrorField getField () const;

    inline void setField(ModifyFavoriteError::ModifyFavoriteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ModifyFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ModifyFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ModifyFavoriteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ModifyFavoriteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ModifyFavoriteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ModifyFavoriteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ModifyFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ModifyFavoriteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ModifyFavoriteError &getDefaultInstance();

private:

    inline void cloneData (const ModifyFavoriteError& rhs);

    inline void deleteData ();

    ModifyFavoriteErrorField __field;

    union {
        ModifyFavoriteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetAlertNoticeList"
 * Get alert notification list
 */
class GetAlertNoticeListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAlertNoticeListStart ();

    /**
     * Copy constructor
     */
    inline  GetAlertNoticeListStart (const GetAlertNoticeListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetAlertNoticeListStart (::sxm_audio_main_fi_types::T_e8_FavoriteType FavoriteType_);

    /**
     * Destructor
     */
    inline virtual  ~GetAlertNoticeListStart();

    /**
     * Assignment operator
     */
    inline GetAlertNoticeListStart& operator = (const GetAlertNoticeListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAlertNoticeListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAlertNoticeListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAlertNoticeListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAlertNoticeListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FavoriteType"

    static const int kFavoriteType = 0;

    /**
     * Clears the field "FavoriteType".
     *
     * The field will be set to its default value. The hasFavoriteType()
     * method will return false.
     */
    inline void clearFavoriteType();

    /**
     * Checks whether the field "FavoriteType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteType()). Otherwise it will return false.
     */
    inline bool hasFavoriteType () const;

    /**
     * Returns the value of the member "FavoriteType".
     *
     * The type of favorite either ARTIST or SONG
     *
     * @return The value of the field "FavoriteType"
     */
    inline ::sxm_audio_main_fi_types::T_e8_FavoriteType getFavoriteType () const;

    /**
     * Sets the value of the member "FavoriteType".
     *
     * The type of favorite either ARTIST or SONG
     *
     * @param FavoriteType The value which will be set
     */
    inline void setFavoriteType (::sxm_audio_main_fi_types::T_e8_FavoriteType FavoriteType_);

    static const GetAlertNoticeListStart &getDefaultInstance();

private:

    inline void set_has_FavoriteType ();

    inline void clear_has_FavoriteType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_FavoriteType _FavoriteType;

};

/**
 * The result message of the method "GetAlertNoticeList"
 * Get alert notification list
 */
class GetAlertNoticeListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAlertNoticeListResult ();

    /**
     * Copy constructor
     */
    inline  GetAlertNoticeListResult (const GetAlertNoticeListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetAlertNoticeListResult (const ::std::vector< ::sxm_audio_main_fi_types::T_AlertInfo >& AlertInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~GetAlertNoticeListResult();

    /**
     * Assignment operator
     */
    inline GetAlertNoticeListResult& operator = (const GetAlertNoticeListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAlertNoticeListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAlertNoticeListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAlertNoticeListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAlertNoticeListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AlertInfoList"

    static const int kAlertInfoList = 0;

    /**
     * Clears the field "AlertInfoList".
     *
     * The field will be set to its default value. The hasAlertInfoList()
     * method will return false.
     */
    inline void clearAlertInfoList();

    /**
     * Checks whether the field "AlertInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertInfoList()). Otherwise it will return false.
     */
    inline bool hasAlertInfoList () const;

    /**
     * Returns the value of the member "AlertInfoList".
     *
     * List of the alert notifications
     *
     * @return The value of the field "AlertInfoList"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_AlertInfo >& getAlertInfoList () const;

    /**
     * Retrieves the value of the field "AlertInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlertInfoList".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_AlertInfo >& getAlertInfoListMutable ();

    /**
     * Sets the value of the member "AlertInfoList".
     *
     * List of the alert notifications
     *
     * @param AlertInfoList The value which will be set
     */
    inline void setAlertInfoList (const ::std::vector< ::sxm_audio_main_fi_types::T_AlertInfo >& AlertInfoList_);

    static const GetAlertNoticeListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_AlertInfo >& getT_AlertInfoList_DefaultInstance ();

    inline void set_has_AlertInfoList ();

    inline void clear_has_AlertInfoList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_audio_main_fi_types::T_AlertInfo > _AlertInfoList;

};

/**
 * The error message of 'GetAlertNoticeList'
 */
class GetAlertNoticeListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetAlertNoticeListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetAlertNoticeListErrorStructure (const GetAlertNoticeListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetAlertNoticeListErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetAlertNoticeListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetAlertNoticeListErrorStructure& operator = (const GetAlertNoticeListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAlertNoticeListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAlertNoticeListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAlertNoticeListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAlertNoticeListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const GetAlertNoticeListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetAlertNoticeList'
 */
class GetAlertNoticeListError  : public ::asf::core::Payload {
public:

    enum GetAlertNoticeListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetAlertNoticeListError ();

   /**
     * Copy constructor
     */
    inline  GetAlertNoticeListError (const GetAlertNoticeListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetAlertNoticeListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetAlertNoticeListError& operator = (const GetAlertNoticeListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAlertNoticeListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAlertNoticeListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAlertNoticeListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAlertNoticeListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetAlertNoticeListError::GetAlertNoticeListErrorField getField () const;

    inline void setField(GetAlertNoticeListError::GetAlertNoticeListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetAlertNoticeListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetAlertNoticeListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetAlertNoticeListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetAlertNoticeListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetAlertNoticeListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetAlertNoticeListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetAlertNoticeListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetAlertNoticeListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetAlertNoticeListError &getDefaultInstance();

private:

    inline void cloneData (const GetAlertNoticeListError& rhs);

    inline void deleteData ();

    GetAlertNoticeListErrorField __field;

    union {
        GetAlertNoticeListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SportsFlashEnableNotification"
 * Enable or Disable receiving Sports Flash Notifications. The status set from here is stored by SMS in sms.cfg file and the values would be retained after power cycles.
 * <p>There are no API's exposed by SMS to retrieve if SportsFlashNotifications are enabled or not. So its the role of client to store this status being sent to MIDW persistently.</p>
 */
class SportsFlashEnableNotificationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashEnableNotificationStart ();

    /**
     * Copy constructor
     */
    inline  SportsFlashEnableNotificationStart (const SportsFlashEnableNotificationStart &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashEnableNotificationStart (bool Enable_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashEnableNotificationStart();

    /**
     * Assignment operator
     */
    inline SportsFlashEnableNotificationStart& operator = (const SportsFlashEnableNotificationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashEnableNotificationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashEnableNotificationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashEnableNotificationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashEnableNotificationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Enable"

    static const int kEnable = 0;

    /**
     * Clears the field "Enable".
     *
     * The field will be set to its default value. The hasEnable()
     * method will return false.
     */
    inline void clearEnable();

    /**
     * Checks whether the field "Enable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnable()). Otherwise it will return false.
     */
    inline bool hasEnable () const;

    /**
     * Returns the value of the member "Enable".
     *
     * Enable or disable sports flash notifications being received by MIDW.
     * <p>TRUE - Enables sports flash notifications.</p>
     * <p>FALSE - Disables sports flash notifications.</p>
     *
     * @return The value of the field "Enable"
     */
    inline bool getEnable () const;

    /**
     * Sets the value of the member "Enable".
     *
     * Enable or disable sports flash notifications being received by MIDW.
     * <p>TRUE - Enables sports flash notifications.</p>
     * <p>FALSE - Disables sports flash notifications.</p>
     *
     * @param Enable The value which will be set
     */
    inline void setEnable (bool Enable_);

    static const SportsFlashEnableNotificationStart &getDefaultInstance();

private:

    inline void set_has_Enable ();

    inline void clear_has_Enable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Enable;

};

/**
 * The result message of the method "SportsFlashEnableNotification"
 * Enable or Disable receiving Sports Flash Notifications. The status set from here is stored by SMS in sms.cfg file and the values would be retained after power cycles.
 * <p>There are no API's exposed by SMS to retrieve if SportsFlashNotifications are enabled or not. So its the role of client to store this status being sent to MIDW persistently.</p>
 */
class SportsFlashEnableNotificationResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashEnableNotificationResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashEnableNotificationResult (const SportsFlashEnableNotificationResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashEnableNotificationResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashEnableNotificationResult();

    /**
     * Assignment operator
     */
    inline SportsFlashEnableNotificationResult& operator = (const SportsFlashEnableNotificationResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashEnableNotificationResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashEnableNotificationResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashEnableNotificationResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashEnableNotificationResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status of Sports Flash enable/disable notification.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Status of Sports Flash enable/disable notification.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SportsFlashEnableNotificationResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SportsFlashEnableNotification'
 */
class SportsFlashEnableNotificationErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashEnableNotificationErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashEnableNotificationErrorStructure (const SportsFlashEnableNotificationErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashEnableNotificationErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashEnableNotificationErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashEnableNotificationErrorStructure& operator = (const SportsFlashEnableNotificationErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashEnableNotificationErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashEnableNotificationErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashEnableNotificationErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashEnableNotificationErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashEnableNotificationErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashEnableNotification'
 */
class SportsFlashEnableNotificationError  : public ::asf::core::Payload {
public:

    enum SportsFlashEnableNotificationErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashEnableNotificationError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashEnableNotificationError (const SportsFlashEnableNotificationError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashEnableNotificationError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashEnableNotificationError& operator = (const SportsFlashEnableNotificationError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashEnableNotificationError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashEnableNotificationError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashEnableNotificationError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashEnableNotificationError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashEnableNotificationError::SportsFlashEnableNotificationErrorField getField () const;

    inline void setField(SportsFlashEnableNotificationError::SportsFlashEnableNotificationErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashEnableNotificationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashEnableNotificationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashEnableNotificationErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashEnableNotificationErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashEnableNotificationErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashEnableNotificationErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashEnableNotificationErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashEnableNotificationErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashEnableNotificationError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashEnableNotificationError& rhs);

    inline void deleteData ();

    SportsFlashEnableNotificationErrorField __field;

    union {
        SportsFlashEnableNotificationErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SportsFlashAddFavoriteTeam"
 * Adds a team as a favorite and thereby starts monitoring the sports flash events involving the team.
 */
class SportsFlashAddFavoriteTeamStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashAddFavoriteTeamStart ();

    /**
     * Copy constructor
     */
    inline  SportsFlashAddFavoriteTeamStart (const SportsFlashAddFavoriteTeamStart &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashAddFavoriteTeamStart (::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport SportType_, uint8 LeagueID_, uint16 TeamID_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashAddFavoriteTeamStart();

    /**
     * Assignment operator
     */
    inline SportsFlashAddFavoriteTeamStart& operator = (const SportsFlashAddFavoriteTeamStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashAddFavoriteTeamStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashAddFavoriteTeamStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashAddFavoriteTeamStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashAddFavoriteTeamStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportType"

    static const int kSportType = 0;

    /**
     * Clears the field "SportType".
     *
     * The field will be set to its default value. The hasSportType()
     * method will return false.
     */
    inline void clearSportType();

    /**
     * Checks whether the field "SportType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportType()). Otherwise it will return false.
     */
    inline bool hasSportType () const;

    /**
     * Returns the value of the member "SportType".
     *
     * The Sport Type to which the team belongs to.
     *
     * @return The value of the field "SportType"
     */
    inline ::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport getSportType () const;

    /**
     * Sets the value of the member "SportType".
     *
     * The Sport Type to which the team belongs to.
     *
     * @param SportType The value which will be set
     */
    inline void setSportType (::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport SportType_);

    // API of field "LeagueID"

    static const int kLeagueID = 1;

    /**
     * Clears the field "LeagueID".
     *
     * The field will be set to its default value. The hasLeagueID()
     * method will return false.
     */
    inline void clearLeagueID();

    /**
     * Checks whether the field "LeagueID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueID()). Otherwise it will return false.
     */
    inline bool hasLeagueID () const;

    /**
     * Returns the value of the member "LeagueID".
     *
     * The League Id to which the team is affiliated to.
     *
     * @return The value of the field "LeagueID"
     */
    inline uint8 getLeagueID () const;

    /**
     * Sets the value of the member "LeagueID".
     *
     * The League Id to which the team is affiliated to.
     *
     * @param LeagueID The value which will be set
     */
    inline void setLeagueID (uint8 LeagueID_);

    // API of field "TeamID"

    static const int kTeamID = 2;

    /**
     * Clears the field "TeamID".
     *
     * The field will be set to its default value. The hasTeamID()
     * method will return false.
     */
    inline void clearTeamID();

    /**
     * Checks whether the field "TeamID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamID()). Otherwise it will return false.
     */
    inline bool hasTeamID () const;

    /**
     * Returns the value of the member "TeamID".
     *
     * The Team ID for the team that needs to be added as favorite.
     *
     * @return The value of the field "TeamID"
     */
    inline uint16 getTeamID () const;

    /**
     * Sets the value of the member "TeamID".
     *
     * The Team ID for the team that needs to be added as favorite.
     *
     * @param TeamID The value which will be set
     */
    inline void setTeamID (uint16 TeamID_);

    static const SportsFlashAddFavoriteTeamStart &getDefaultInstance();

private:

    inline void set_has_SportType ();

    inline void clear_has_SportType ();

    inline void set_has_LeagueID ();

    inline void clear_has_LeagueID ();

    inline void set_has_TeamID ();

    inline void clear_has_TeamID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport _SportType;

    uint8 _LeagueID;

    uint16 _TeamID;

};

/**
 * The result message of the method "SportsFlashAddFavoriteTeam"
 * Adds a team as a favorite and thereby starts monitoring the sports flash events involving the team.
 */
class SportsFlashAddFavoriteTeamResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashAddFavoriteTeamResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashAddFavoriteTeamResult (const SportsFlashAddFavoriteTeamResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashAddFavoriteTeamResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashAddFavoriteTeamResult();

    /**
     * Assignment operator
     */
    inline SportsFlashAddFavoriteTeamResult& operator = (const SportsFlashAddFavoriteTeamResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashAddFavoriteTeamResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashAddFavoriteTeamResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashAddFavoriteTeamResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashAddFavoriteTeamResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if addition of a team to be monitored for sports flash events is success. FALSE upon failure.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if addition of a team to be monitored for sports flash events is success. FALSE upon failure.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SportsFlashAddFavoriteTeamResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SportsFlashAddFavoriteTeam'
 */
class SportsFlashAddFavoriteTeamErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashAddFavoriteTeamErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashAddFavoriteTeamErrorStructure (const SportsFlashAddFavoriteTeamErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashAddFavoriteTeamErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashAddFavoriteTeamErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashAddFavoriteTeamErrorStructure& operator = (const SportsFlashAddFavoriteTeamErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashAddFavoriteTeamErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashAddFavoriteTeamErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashAddFavoriteTeamErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashAddFavoriteTeamErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashAddFavoriteTeamErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashAddFavoriteTeam'
 */
class SportsFlashAddFavoriteTeamError  : public ::asf::core::Payload {
public:

    enum SportsFlashAddFavoriteTeamErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashAddFavoriteTeamError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashAddFavoriteTeamError (const SportsFlashAddFavoriteTeamError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashAddFavoriteTeamError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashAddFavoriteTeamError& operator = (const SportsFlashAddFavoriteTeamError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashAddFavoriteTeamError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashAddFavoriteTeamError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashAddFavoriteTeamError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashAddFavoriteTeamError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashAddFavoriteTeamError::SportsFlashAddFavoriteTeamErrorField getField () const;

    inline void setField(SportsFlashAddFavoriteTeamError::SportsFlashAddFavoriteTeamErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashAddFavoriteTeamErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashAddFavoriteTeamErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashAddFavoriteTeamErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashAddFavoriteTeamErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashAddFavoriteTeamErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashAddFavoriteTeamErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashAddFavoriteTeamErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashAddFavoriteTeamErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashAddFavoriteTeamError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashAddFavoriteTeamError& rhs);

    inline void deleteData ();

    SportsFlashAddFavoriteTeamErrorField __field;

    union {
        SportsFlashAddFavoriteTeamErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SportsFlashRemoveFavoriteTeam"
 * Removes a team from favorite list and thereby stops monitoring the sports flash events involving the team.
 */
class SportsFlashRemoveFavoriteTeamStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashRemoveFavoriteTeamStart ();

    /**
     * Copy constructor
     */
    inline  SportsFlashRemoveFavoriteTeamStart (const SportsFlashRemoveFavoriteTeamStart &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashRemoveFavoriteTeamStart (::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport SportType_, uint8 LeagueID_, uint16 TeamID_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashRemoveFavoriteTeamStart();

    /**
     * Assignment operator
     */
    inline SportsFlashRemoveFavoriteTeamStart& operator = (const SportsFlashRemoveFavoriteTeamStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashRemoveFavoriteTeamStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashRemoveFavoriteTeamStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashRemoveFavoriteTeamStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashRemoveFavoriteTeamStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportType"

    static const int kSportType = 0;

    /**
     * Clears the field "SportType".
     *
     * The field will be set to its default value. The hasSportType()
     * method will return false.
     */
    inline void clearSportType();

    /**
     * Checks whether the field "SportType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportType()). Otherwise it will return false.
     */
    inline bool hasSportType () const;

    /**
     * Returns the value of the member "SportType".
     *
     * The Sport Type to which the team belongs to.
     *
     * @return The value of the field "SportType"
     */
    inline ::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport getSportType () const;

    /**
     * Sets the value of the member "SportType".
     *
     * The Sport Type to which the team belongs to.
     *
     * @param SportType The value which will be set
     */
    inline void setSportType (::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport SportType_);

    // API of field "LeagueID"

    static const int kLeagueID = 1;

    /**
     * Clears the field "LeagueID".
     *
     * The field will be set to its default value. The hasLeagueID()
     * method will return false.
     */
    inline void clearLeagueID();

    /**
     * Checks whether the field "LeagueID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueID()). Otherwise it will return false.
     */
    inline bool hasLeagueID () const;

    /**
     * Returns the value of the member "LeagueID".
     *
     * The League Id to which the team is affiliated to.
     *
     * @return The value of the field "LeagueID"
     */
    inline uint8 getLeagueID () const;

    /**
     * Sets the value of the member "LeagueID".
     *
     * The League Id to which the team is affiliated to.
     *
     * @param LeagueID The value which will be set
     */
    inline void setLeagueID (uint8 LeagueID_);

    // API of field "TeamID"

    static const int kTeamID = 2;

    /**
     * Clears the field "TeamID".
     *
     * The field will be set to its default value. The hasTeamID()
     * method will return false.
     */
    inline void clearTeamID();

    /**
     * Checks whether the field "TeamID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamID()). Otherwise it will return false.
     */
    inline bool hasTeamID () const;

    /**
     * Returns the value of the member "TeamID".
     *
     * The Team ID for the team that needs to be remove from favorites list.
     *
     * @return The value of the field "TeamID"
     */
    inline uint16 getTeamID () const;

    /**
     * Sets the value of the member "TeamID".
     *
     * The Team ID for the team that needs to be remove from favorites list.
     *
     * @param TeamID The value which will be set
     */
    inline void setTeamID (uint16 TeamID_);

    static const SportsFlashRemoveFavoriteTeamStart &getDefaultInstance();

private:

    inline void set_has_SportType ();

    inline void clear_has_SportType ();

    inline void set_has_LeagueID ();

    inline void clear_has_LeagueID ();

    inline void set_has_TeamID ();

    inline void clear_has_TeamID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport _SportType;

    uint8 _LeagueID;

    uint16 _TeamID;

};

/**
 * The result message of the method "SportsFlashRemoveFavoriteTeam"
 * Removes a team from favorite list and thereby stops monitoring the sports flash events involving the team.
 */
class SportsFlashRemoveFavoriteTeamResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashRemoveFavoriteTeamResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashRemoveFavoriteTeamResult (const SportsFlashRemoveFavoriteTeamResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashRemoveFavoriteTeamResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashRemoveFavoriteTeamResult();

    /**
     * Assignment operator
     */
    inline SportsFlashRemoveFavoriteTeamResult& operator = (const SportsFlashRemoveFavoriteTeamResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashRemoveFavoriteTeamResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashRemoveFavoriteTeamResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashRemoveFavoriteTeamResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashRemoveFavoriteTeamResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if removal of a team to be monitored for sports flash events is success. FALSE upon failure.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if removal of a team to be monitored for sports flash events is success. FALSE upon failure.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SportsFlashRemoveFavoriteTeamResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SportsFlashRemoveFavoriteTeam'
 */
class SportsFlashRemoveFavoriteTeamErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashRemoveFavoriteTeamErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashRemoveFavoriteTeamErrorStructure (const SportsFlashRemoveFavoriteTeamErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashRemoveFavoriteTeamErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashRemoveFavoriteTeamErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashRemoveFavoriteTeamErrorStructure& operator = (const SportsFlashRemoveFavoriteTeamErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashRemoveFavoriteTeamErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashRemoveFavoriteTeamErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashRemoveFavoriteTeamErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashRemoveFavoriteTeamErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashRemoveFavoriteTeamErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashRemoveFavoriteTeam'
 */
class SportsFlashRemoveFavoriteTeamError  : public ::asf::core::Payload {
public:

    enum SportsFlashRemoveFavoriteTeamErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashRemoveFavoriteTeamError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashRemoveFavoriteTeamError (const SportsFlashRemoveFavoriteTeamError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashRemoveFavoriteTeamError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashRemoveFavoriteTeamError& operator = (const SportsFlashRemoveFavoriteTeamError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashRemoveFavoriteTeamError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashRemoveFavoriteTeamError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashRemoveFavoriteTeamError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashRemoveFavoriteTeamError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashRemoveFavoriteTeamError::SportsFlashRemoveFavoriteTeamErrorField getField () const;

    inline void setField(SportsFlashRemoveFavoriteTeamError::SportsFlashRemoveFavoriteTeamErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashRemoveFavoriteTeamErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashRemoveFavoriteTeamErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashRemoveFavoriteTeamErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashRemoveFavoriteTeamErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashRemoveFavoriteTeamErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashRemoveFavoriteTeamErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashRemoveFavoriteTeamErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashRemoveFavoriteTeamErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashRemoveFavoriteTeamError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashRemoveFavoriteTeamError& rhs);

    inline void deleteData ();

    SportsFlashRemoveFavoriteTeamErrorField __field;

    union {
        SportsFlashRemoveFavoriteTeamErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "SportsFlashRemoveAllFavoriteTeams"
 * Removes all teams from favourites list and thereby stops monitoring all the sports flash events.
 */
class SportsFlashRemoveAllFavoriteTeamsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashRemoveAllFavoriteTeamsResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashRemoveAllFavoriteTeamsResult (const SportsFlashRemoveAllFavoriteTeamsResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashRemoveAllFavoriteTeamsResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashRemoveAllFavoriteTeamsResult();

    /**
     * Assignment operator
     */
    inline SportsFlashRemoveAllFavoriteTeamsResult& operator = (const SportsFlashRemoveAllFavoriteTeamsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashRemoveAllFavoriteTeamsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashRemoveAllFavoriteTeamsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashRemoveAllFavoriteTeamsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashRemoveAllFavoriteTeamsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if removal of a team to be monitored for sports flash events is success. FALSE upon failure.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if removal of a team to be monitored for sports flash events is success. FALSE upon failure.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SportsFlashRemoveAllFavoriteTeamsResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SportsFlashRemoveAllFavoriteTeams'
 */
class SportsFlashRemoveAllFavoriteTeamsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashRemoveAllFavoriteTeamsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashRemoveAllFavoriteTeamsErrorStructure (const SportsFlashRemoveAllFavoriteTeamsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashRemoveAllFavoriteTeamsErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashRemoveAllFavoriteTeamsErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashRemoveAllFavoriteTeamsErrorStructure& operator = (const SportsFlashRemoveAllFavoriteTeamsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashRemoveAllFavoriteTeamsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashRemoveAllFavoriteTeamsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashRemoveAllFavoriteTeamsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashRemoveAllFavoriteTeamsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashRemoveAllFavoriteTeamsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashRemoveAllFavoriteTeams'
 */
class SportsFlashRemoveAllFavoriteTeamsError  : public ::asf::core::Payload {
public:

    enum SportsFlashRemoveAllFavoriteTeamsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashRemoveAllFavoriteTeamsError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashRemoveAllFavoriteTeamsError (const SportsFlashRemoveAllFavoriteTeamsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashRemoveAllFavoriteTeamsError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashRemoveAllFavoriteTeamsError& operator = (const SportsFlashRemoveAllFavoriteTeamsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashRemoveAllFavoriteTeamsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashRemoveAllFavoriteTeamsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashRemoveAllFavoriteTeamsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashRemoveAllFavoriteTeamsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashRemoveAllFavoriteTeamsError::SportsFlashRemoveAllFavoriteTeamsErrorField getField () const;

    inline void setField(SportsFlashRemoveAllFavoriteTeamsError::SportsFlashRemoveAllFavoriteTeamsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashRemoveAllFavoriteTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashRemoveAllFavoriteTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashRemoveAllFavoriteTeamsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashRemoveAllFavoriteTeamsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashRemoveAllFavoriteTeamsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashRemoveAllFavoriteTeamsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashRemoveAllFavoriteTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashRemoveAllFavoriteTeamsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashRemoveAllFavoriteTeamsError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashRemoveAllFavoriteTeamsError& rhs);

    inline void deleteData ();

    SportsFlashRemoveAllFavoriteTeamsErrorField __field;

    union {
        SportsFlashRemoveAllFavoriteTeamsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "SportsFlashGetAllFavorites"
 * Get All teams that are currently registered for Sports Flash Event notifications.
 */
class SportsFlashGetAllFavoritesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashGetAllFavoritesResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashGetAllFavoritesResult (const SportsFlashGetAllFavoritesResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashGetAllFavoritesResult (const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_FavoriteTeam >& FavouritesList_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashGetAllFavoritesResult();

    /**
     * Assignment operator
     */
    inline SportsFlashGetAllFavoritesResult& operator = (const SportsFlashGetAllFavoritesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetAllFavoritesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetAllFavoritesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetAllFavoritesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetAllFavoritesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FavouritesList"

    static const int kFavouritesList = 0;

    /**
     * Clears the field "FavouritesList".
     *
     * The field will be set to its default value. The hasFavouritesList()
     * method will return false.
     */
    inline void clearFavouritesList();

    /**
     * Checks whether the field "FavouritesList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavouritesList()). Otherwise it will return false.
     */
    inline bool hasFavouritesList () const;

    /**
     * Returns the value of the member "FavouritesList".
     *
     * List of Favorite Teams
     *
     * @return The value of the field "FavouritesList"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_FavoriteTeam >& getFavouritesList () const;

    /**
     * Retrieves the value of the field "FavouritesList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FavouritesList".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_FavoriteTeam >& getFavouritesListMutable ();

    /**
     * Sets the value of the member "FavouritesList".
     *
     * List of Favorite Teams
     *
     * @param FavouritesList The value which will be set
     */
    inline void setFavouritesList (const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_FavoriteTeam >& FavouritesList_);

    static const SportsFlashGetAllFavoritesResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_FavoriteTeam >& getT_SportsFlash_FavoriteTeamList_DefaultInstance ();

    inline void set_has_FavouritesList ();

    inline void clear_has_FavouritesList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_FavoriteTeam > _FavouritesList;

};

/**
 * The error message of 'SportsFlashGetAllFavorites'
 */
class SportsFlashGetAllFavoritesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashGetAllFavoritesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashGetAllFavoritesErrorStructure (const SportsFlashGetAllFavoritesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashGetAllFavoritesErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashGetAllFavoritesErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashGetAllFavoritesErrorStructure& operator = (const SportsFlashGetAllFavoritesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetAllFavoritesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetAllFavoritesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetAllFavoritesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetAllFavoritesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashGetAllFavoritesErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashGetAllFavorites'
 */
class SportsFlashGetAllFavoritesError  : public ::asf::core::Payload {
public:

    enum SportsFlashGetAllFavoritesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashGetAllFavoritesError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashGetAllFavoritesError (const SportsFlashGetAllFavoritesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashGetAllFavoritesError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashGetAllFavoritesError& operator = (const SportsFlashGetAllFavoritesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetAllFavoritesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetAllFavoritesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetAllFavoritesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetAllFavoritesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashGetAllFavoritesError::SportsFlashGetAllFavoritesErrorField getField () const;

    inline void setField(SportsFlashGetAllFavoritesError::SportsFlashGetAllFavoritesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashGetAllFavoritesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashGetAllFavoritesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashGetAllFavoritesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashGetAllFavoritesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashGetAllFavoritesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashGetAllFavoritesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashGetAllFavoritesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashGetAllFavoritesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashGetAllFavoritesError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashGetAllFavoritesError& rhs);

    inline void deleteData ();

    SportsFlashGetAllFavoritesErrorField __field;

    union {
        SportsFlashGetAllFavoritesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "SportsFlashGetCurrentGames"
 * Retrieve list of all the currently ongoing game events involving user specified favourite teams filtered from duplicates.
 */
class SportsFlashGetCurrentGamesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashGetCurrentGamesResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashGetCurrentGamesResult (const SportsFlashGetCurrentGamesResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashGetCurrentGamesResult (const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_Game >& Games_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashGetCurrentGamesResult();

    /**
     * Assignment operator
     */
    inline SportsFlashGetCurrentGamesResult& operator = (const SportsFlashGetCurrentGamesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetCurrentGamesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetCurrentGamesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetCurrentGamesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetCurrentGamesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Games"

    static const int kGames = 0;

    /**
     * Clears the field "Games".
     *
     * The field will be set to its default value. The hasGames()
     * method will return false.
     */
    inline void clearGames();

    /**
     * Checks whether the field "Games" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGames()). Otherwise it will return false.
     */
    inline bool hasGames () const;

    /**
     * Returns the value of the member "Games".
     *
     * List of Ongoing games involving favourite teams.
     *
     * @return The value of the field "Games"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_Game >& getGames () const;

    /**
     * Retrieves the value of the field "Games" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Games".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_Game >& getGamesMutable ();

    /**
     * Sets the value of the member "Games".
     *
     * List of Ongoing games involving favourite teams.
     *
     * @param Games The value which will be set
     */
    inline void setGames (const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_Game >& Games_);

    static const SportsFlashGetCurrentGamesResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_Game >& getT_SportsFlash_GameList_DefaultInstance ();

    inline void set_has_Games ();

    inline void clear_has_Games ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_Game > _Games;

};

/**
 * The error message of 'SportsFlashGetCurrentGames'
 */
class SportsFlashGetCurrentGamesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashGetCurrentGamesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashGetCurrentGamesErrorStructure (const SportsFlashGetCurrentGamesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashGetCurrentGamesErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashGetCurrentGamesErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashGetCurrentGamesErrorStructure& operator = (const SportsFlashGetCurrentGamesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetCurrentGamesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetCurrentGamesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetCurrentGamesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetCurrentGamesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashGetCurrentGamesErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashGetCurrentGames'
 */
class SportsFlashGetCurrentGamesError  : public ::asf::core::Payload {
public:

    enum SportsFlashGetCurrentGamesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashGetCurrentGamesError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashGetCurrentGamesError (const SportsFlashGetCurrentGamesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashGetCurrentGamesError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashGetCurrentGamesError& operator = (const SportsFlashGetCurrentGamesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetCurrentGamesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetCurrentGamesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetCurrentGamesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetCurrentGamesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashGetCurrentGamesError::SportsFlashGetCurrentGamesErrorField getField () const;

    inline void setField(SportsFlashGetCurrentGamesError::SportsFlashGetCurrentGamesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashGetCurrentGamesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashGetCurrentGamesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashGetCurrentGamesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashGetCurrentGamesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashGetCurrentGamesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashGetCurrentGamesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashGetCurrentGamesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashGetCurrentGamesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashGetCurrentGamesError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashGetCurrentGamesError& rhs);

    inline void deleteData ();

    SportsFlashGetCurrentGamesErrorField __field;

    union {
        SportsFlashGetCurrentGamesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SportsFlashSetGamesMonitor"
 * Set up a list of game channels to monitor for Sports Flash events.
 * List of ChannelIDs that needs to be monitored for sports flash events. The list of channels provided here would overwrite the existing channel list that are monitored.
 */
class SportsFlashSetGamesMonitorStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashSetGamesMonitorStart ();

    /**
     * Copy constructor
     */
    inline  SportsFlashSetGamesMonitorStart (const SportsFlashSetGamesMonitorStart &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashSetGamesMonitorStart (const ::std::vector< uint16 >& ChannelIDs_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashSetGamesMonitorStart();

    /**
     * Assignment operator
     */
    inline SportsFlashSetGamesMonitorStart& operator = (const SportsFlashSetGamesMonitorStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashSetGamesMonitorStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashSetGamesMonitorStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashSetGamesMonitorStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashSetGamesMonitorStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelIDs"

    static const int kChannelIDs = 0;

    /**
     * Clears the field "ChannelIDs".
     *
     * The field will be set to its default value. The hasChannelIDs()
     * method will return false.
     */
    inline void clearChannelIDs();

    /**
     * Checks whether the field "ChannelIDs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelIDs()). Otherwise it will return false.
     */
    inline bool hasChannelIDs () const;

    /**
     * Returns the value of the member "ChannelIDs".
     *
     * Channel IDs to be set up for monitoring
     *
     * @return The value of the field "ChannelIDs"
     */
    inline const ::std::vector< uint16 >& getChannelIDs () const;

    /**
     * Retrieves the value of the field "ChannelIDs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelIDs".
     */
    inline ::std::vector< uint16 >& getChannelIDsMutable ();

    /**
     * Sets the value of the member "ChannelIDs".
     *
     * Channel IDs to be set up for monitoring
     *
     * @param ChannelIDs The value which will be set
     */
    inline void setChannelIDs (const ::std::vector< uint16 >& ChannelIDs_);

    static const SportsFlashSetGamesMonitorStart &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_ChannelIDs ();

    inline void clear_has_ChannelIDs ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint16 > _ChannelIDs;

};

/**
 * The result message of the method "SportsFlashSetGamesMonitor"
 * Set up a list of game channels to monitor for Sports Flash events.
 */
class SportsFlashSetGamesMonitorResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashSetGamesMonitorResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashSetGamesMonitorResult (const SportsFlashSetGamesMonitorResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashSetGamesMonitorResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashSetGamesMonitorResult();

    /**
     * Assignment operator
     */
    inline SportsFlashSetGamesMonitorResult& operator = (const SportsFlashSetGamesMonitorResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashSetGamesMonitorResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashSetGamesMonitorResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashSetGamesMonitorResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashSetGamesMonitorResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if setting up of games to be monitored for sports flash events is success. FALSE upon failure.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if setting up of games to be monitored for sports flash events is success. FALSE upon failure.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SportsFlashSetGamesMonitorResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SportsFlashSetGamesMonitor'
 */
class SportsFlashSetGamesMonitorErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashSetGamesMonitorErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashSetGamesMonitorErrorStructure (const SportsFlashSetGamesMonitorErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashSetGamesMonitorErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashSetGamesMonitorErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashSetGamesMonitorErrorStructure& operator = (const SportsFlashSetGamesMonitorErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashSetGamesMonitorErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashSetGamesMonitorErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashSetGamesMonitorErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashSetGamesMonitorErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashSetGamesMonitorErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashSetGamesMonitor'
 */
class SportsFlashSetGamesMonitorError  : public ::asf::core::Payload {
public:

    enum SportsFlashSetGamesMonitorErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashSetGamesMonitorError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashSetGamesMonitorError (const SportsFlashSetGamesMonitorError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashSetGamesMonitorError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashSetGamesMonitorError& operator = (const SportsFlashSetGamesMonitorError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashSetGamesMonitorError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashSetGamesMonitorError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashSetGamesMonitorError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashSetGamesMonitorError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashSetGamesMonitorError::SportsFlashSetGamesMonitorErrorField getField () const;

    inline void setField(SportsFlashSetGamesMonitorError::SportsFlashSetGamesMonitorErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashSetGamesMonitorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashSetGamesMonitorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashSetGamesMonitorErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashSetGamesMonitorErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashSetGamesMonitorErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashSetGamesMonitorErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashSetGamesMonitorErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashSetGamesMonitorErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashSetGamesMonitorError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashSetGamesMonitorError& rhs);

    inline void deleteData ();

    SportsFlashSetGamesMonitorErrorField __field;

    union {
        SportsFlashSetGamesMonitorErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "SportsFlashGetCurrentFlashEvents"
 * Retreive information list about each occurred and not yet expired Flash Event at any moment.
 */
class SportsFlashGetCurrentFlashEventsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashGetCurrentFlashEventsResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashGetCurrentFlashEventsResult (const SportsFlashGetCurrentFlashEventsResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashGetCurrentFlashEventsResult (const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_FlashEvent >& FlashEvents_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashGetCurrentFlashEventsResult();

    /**
     * Assignment operator
     */
    inline SportsFlashGetCurrentFlashEventsResult& operator = (const SportsFlashGetCurrentFlashEventsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetCurrentFlashEventsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetCurrentFlashEventsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetCurrentFlashEventsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetCurrentFlashEventsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FlashEvents"

    static const int kFlashEvents = 0;

    /**
     * Clears the field "FlashEvents".
     *
     * The field will be set to its default value. The hasFlashEvents()
     * method will return false.
     */
    inline void clearFlashEvents();

    /**
     * Checks whether the field "FlashEvents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlashEvents()). Otherwise it will return false.
     */
    inline bool hasFlashEvents () const;

    /**
     * Returns the value of the member "FlashEvents".
     *
     * List of each reported and not yet expired Flash Event.
     *
     * @return The value of the field "FlashEvents"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_FlashEvent >& getFlashEvents () const;

    /**
     * Retrieves the value of the field "FlashEvents" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FlashEvents".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_FlashEvent >& getFlashEventsMutable ();

    /**
     * Sets the value of the member "FlashEvents".
     *
     * List of each reported and not yet expired Flash Event.
     *
     * @param FlashEvents The value which will be set
     */
    inline void setFlashEvents (const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_FlashEvent >& FlashEvents_);

    static const SportsFlashGetCurrentFlashEventsResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_FlashEvent >& getT_SportsFlash_FlashEventList_DefaultInstance ();

    inline void set_has_FlashEvents ();

    inline void clear_has_FlashEvents ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_FlashEvent > _FlashEvents;

};

/**
 * The error message of 'SportsFlashGetCurrentFlashEvents'
 */
class SportsFlashGetCurrentFlashEventsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashGetCurrentFlashEventsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashGetCurrentFlashEventsErrorStructure (const SportsFlashGetCurrentFlashEventsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashGetCurrentFlashEventsErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashGetCurrentFlashEventsErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashGetCurrentFlashEventsErrorStructure& operator = (const SportsFlashGetCurrentFlashEventsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetCurrentFlashEventsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetCurrentFlashEventsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetCurrentFlashEventsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetCurrentFlashEventsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashGetCurrentFlashEventsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashGetCurrentFlashEvents'
 */
class SportsFlashGetCurrentFlashEventsError  : public ::asf::core::Payload {
public:

    enum SportsFlashGetCurrentFlashEventsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashGetCurrentFlashEventsError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashGetCurrentFlashEventsError (const SportsFlashGetCurrentFlashEventsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashGetCurrentFlashEventsError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashGetCurrentFlashEventsError& operator = (const SportsFlashGetCurrentFlashEventsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetCurrentFlashEventsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetCurrentFlashEventsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetCurrentFlashEventsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetCurrentFlashEventsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashGetCurrentFlashEventsError::SportsFlashGetCurrentFlashEventsErrorField getField () const;

    inline void setField(SportsFlashGetCurrentFlashEventsError::SportsFlashGetCurrentFlashEventsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashGetCurrentFlashEventsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashGetCurrentFlashEventsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashGetCurrentFlashEventsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashGetCurrentFlashEventsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashGetCurrentFlashEventsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashGetCurrentFlashEventsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashGetCurrentFlashEventsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashGetCurrentFlashEventsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashGetCurrentFlashEventsError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashGetCurrentFlashEventsError& rhs);

    inline void deleteData ();

    SportsFlashGetCurrentFlashEventsErrorField __field;

    union {
        SportsFlashGetCurrentFlashEventsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SportsFlashPlayFlashEvent"
 * Switch playback to the channel playing the Flash Event reported by the Monitor.
 */
class SportsFlashPlayFlashEventStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashPlayFlashEventStart ();

    /**
     * Copy constructor
     */
    inline  SportsFlashPlayFlashEventStart (const SportsFlashPlayFlashEventStart &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashPlayFlashEventStart (uint32 FlashEventID_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashPlayFlashEventStart();

    /**
     * Assignment operator
     */
    inline SportsFlashPlayFlashEventStart& operator = (const SportsFlashPlayFlashEventStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashPlayFlashEventStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashPlayFlashEventStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashPlayFlashEventStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashPlayFlashEventStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FlashEventID"

    static const int kFlashEventID = 0;

    /**
     * Clears the field "FlashEventID".
     *
     * The field will be set to its default value. The hasFlashEventID()
     * method will return false.
     */
    inline void clearFlashEventID();

    /**
     * Checks whether the field "FlashEventID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlashEventID()). Otherwise it will return false.
     */
    inline bool hasFlashEventID () const;

    /**
     * Returns the value of the member "FlashEventID".
     *
     * ID of the Flash Event used for playback.
     *
     * @return The value of the field "FlashEventID"
     */
    inline uint32 getFlashEventID () const;

    /**
     * Sets the value of the member "FlashEventID".
     *
     * ID of the Flash Event used for playback.
     *
     * @param FlashEventID The value which will be set
     */
    inline void setFlashEventID (uint32 FlashEventID_);

    static const SportsFlashPlayFlashEventStart &getDefaultInstance();

private:

    inline void set_has_FlashEventID ();

    inline void clear_has_FlashEventID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _FlashEventID;

};

/**
 * The result message of the method "SportsFlashPlayFlashEvent"
 * Switch playback to the channel playing the Flash Event reported by the Monitor.
 */
class SportsFlashPlayFlashEventResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashPlayFlashEventResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashPlayFlashEventResult (const SportsFlashPlayFlashEventResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashPlayFlashEventResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashPlayFlashEventResult();

    /**
     * Assignment operator
     */
    inline SportsFlashPlayFlashEventResult& operator = (const SportsFlashPlayFlashEventResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashPlayFlashEventResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashPlayFlashEventResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashPlayFlashEventResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashPlayFlashEventResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if playback of sports flash event is success. FALSE upon failure.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if playback of sports flash event is success. FALSE upon failure.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SportsFlashPlayFlashEventResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SportsFlashPlayFlashEvent'
 */
class SportsFlashPlayFlashEventErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashPlayFlashEventErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashPlayFlashEventErrorStructure (const SportsFlashPlayFlashEventErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashPlayFlashEventErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashPlayFlashEventErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashPlayFlashEventErrorStructure& operator = (const SportsFlashPlayFlashEventErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashPlayFlashEventErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashPlayFlashEventErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashPlayFlashEventErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashPlayFlashEventErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashPlayFlashEventErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashPlayFlashEvent'
 */
class SportsFlashPlayFlashEventError  : public ::asf::core::Payload {
public:

    enum SportsFlashPlayFlashEventErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashPlayFlashEventError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashPlayFlashEventError (const SportsFlashPlayFlashEventError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashPlayFlashEventError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashPlayFlashEventError& operator = (const SportsFlashPlayFlashEventError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashPlayFlashEventError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashPlayFlashEventError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashPlayFlashEventError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashPlayFlashEventError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashPlayFlashEventError::SportsFlashPlayFlashEventErrorField getField () const;

    inline void setField(SportsFlashPlayFlashEventError::SportsFlashPlayFlashEventErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashPlayFlashEventErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashPlayFlashEventErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashPlayFlashEventErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashPlayFlashEventErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashPlayFlashEventErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashPlayFlashEventErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashPlayFlashEventErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashPlayFlashEventErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashPlayFlashEventError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashPlayFlashEventError& rhs);

    inline void deleteData ();

    SportsFlashPlayFlashEventErrorField __field;

    union {
        SportsFlashPlayFlashEventErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "SportsFlashAbortFlashEvent"
 * Abort playback of the channel, playing the Flash Event.
 */
class SportsFlashAbortFlashEventResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashAbortFlashEventResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashAbortFlashEventResult (const SportsFlashAbortFlashEventResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashAbortFlashEventResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashAbortFlashEventResult();

    /**
     * Assignment operator
     */
    inline SportsFlashAbortFlashEventResult& operator = (const SportsFlashAbortFlashEventResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashAbortFlashEventResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashAbortFlashEventResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashAbortFlashEventResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashAbortFlashEventResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if abort playback of sports flash event is success. FALSE upon failure.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if abort playback of sports flash event is success. FALSE upon failure.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SportsFlashAbortFlashEventResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SportsFlashAbortFlashEvent'
 */
class SportsFlashAbortFlashEventErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashAbortFlashEventErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashAbortFlashEventErrorStructure (const SportsFlashAbortFlashEventErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashAbortFlashEventErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashAbortFlashEventErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashAbortFlashEventErrorStructure& operator = (const SportsFlashAbortFlashEventErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashAbortFlashEventErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashAbortFlashEventErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashAbortFlashEventErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashAbortFlashEventErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashAbortFlashEventErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashAbortFlashEvent'
 */
class SportsFlashAbortFlashEventError  : public ::asf::core::Payload {
public:

    enum SportsFlashAbortFlashEventErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashAbortFlashEventError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashAbortFlashEventError (const SportsFlashAbortFlashEventError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashAbortFlashEventError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashAbortFlashEventError& operator = (const SportsFlashAbortFlashEventError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashAbortFlashEventError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashAbortFlashEventError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashAbortFlashEventError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashAbortFlashEventError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashAbortFlashEventError::SportsFlashAbortFlashEventErrorField getField () const;

    inline void setField(SportsFlashAbortFlashEventError::SportsFlashAbortFlashEventErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashAbortFlashEventErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashAbortFlashEventErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashAbortFlashEventErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashAbortFlashEventErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashAbortFlashEventErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashAbortFlashEventErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashAbortFlashEventErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashAbortFlashEventErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashAbortFlashEventError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashAbortFlashEventError& rhs);

    inline void deleteData ();

    SportsFlashAbortFlashEventErrorField __field;

    union {
        SportsFlashAbortFlashEventErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "SportsFlashGetCurrentFlashEventID"
 * Retrieve currently playing sports flash event ID.
 */
class SportsFlashGetCurrentFlashEventIDResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashGetCurrentFlashEventIDResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashGetCurrentFlashEventIDResult (const SportsFlashGetCurrentFlashEventIDResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashGetCurrentFlashEventIDResult (uint32 FlashEventID_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashGetCurrentFlashEventIDResult();

    /**
     * Assignment operator
     */
    inline SportsFlashGetCurrentFlashEventIDResult& operator = (const SportsFlashGetCurrentFlashEventIDResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetCurrentFlashEventIDResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetCurrentFlashEventIDResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetCurrentFlashEventIDResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetCurrentFlashEventIDResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FlashEventID"

    static const int kFlashEventID = 0;

    /**
     * Clears the field "FlashEventID".
     *
     * The field will be set to its default value. The hasFlashEventID()
     * method will return false.
     */
    inline void clearFlashEventID();

    /**
     * Checks whether the field "FlashEventID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlashEventID()). Otherwise it will return false.
     */
    inline bool hasFlashEventID () const;

    /**
     * Returns the value of the member "FlashEventID".
     *
     * Current Playing Sports Flash Event's ID.
     * <p>If ID of the current playing event could not be retrieved or if SportsFlash Event is not playing, then UN32_MAX is passed(2 ^ 32).</p>
     *
     * @return The value of the field "FlashEventID"
     */
    inline uint32 getFlashEventID () const;

    /**
     * Sets the value of the member "FlashEventID".
     *
     * Current Playing Sports Flash Event's ID.
     * <p>If ID of the current playing event could not be retrieved or if SportsFlash Event is not playing, then UN32_MAX is passed(2 ^ 32).</p>
     *
     * @param FlashEventID The value which will be set
     */
    inline void setFlashEventID (uint32 FlashEventID_);

    static const SportsFlashGetCurrentFlashEventIDResult &getDefaultInstance();

private:

    inline void set_has_FlashEventID ();

    inline void clear_has_FlashEventID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _FlashEventID;

};

/**
 * The error message of 'SportsFlashGetCurrentFlashEventID'
 */
class SportsFlashGetCurrentFlashEventIDErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashGetCurrentFlashEventIDErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashGetCurrentFlashEventIDErrorStructure (const SportsFlashGetCurrentFlashEventIDErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashGetCurrentFlashEventIDErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashGetCurrentFlashEventIDErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashGetCurrentFlashEventIDErrorStructure& operator = (const SportsFlashGetCurrentFlashEventIDErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetCurrentFlashEventIDErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetCurrentFlashEventIDErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetCurrentFlashEventIDErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetCurrentFlashEventIDErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashGetCurrentFlashEventIDErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashGetCurrentFlashEventID'
 */
class SportsFlashGetCurrentFlashEventIDError  : public ::asf::core::Payload {
public:

    enum SportsFlashGetCurrentFlashEventIDErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashGetCurrentFlashEventIDError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashGetCurrentFlashEventIDError (const SportsFlashGetCurrentFlashEventIDError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashGetCurrentFlashEventIDError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashGetCurrentFlashEventIDError& operator = (const SportsFlashGetCurrentFlashEventIDError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetCurrentFlashEventIDError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetCurrentFlashEventIDError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetCurrentFlashEventIDError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetCurrentFlashEventIDError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashGetCurrentFlashEventIDError::SportsFlashGetCurrentFlashEventIDErrorField getField () const;

    inline void setField(SportsFlashGetCurrentFlashEventIDError::SportsFlashGetCurrentFlashEventIDErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashGetCurrentFlashEventIDErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashGetCurrentFlashEventIDErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashGetCurrentFlashEventIDErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashGetCurrentFlashEventIDErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashGetCurrentFlashEventIDErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashGetCurrentFlashEventIDErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashGetCurrentFlashEventIDErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashGetCurrentFlashEventIDErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashGetCurrentFlashEventIDError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashGetCurrentFlashEventIDError& rhs);

    inline void deleteData ();

    SportsFlashGetCurrentFlashEventIDErrorField __field;

    union {
        SportsFlashGetCurrentFlashEventIDErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "SportsFlashEnabledLeagues"
 * Get List of all leagues for which Sport Flash Feature is supported.
 */
class SportsFlashEnabledLeaguesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashEnabledLeaguesResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashEnabledLeaguesResult (const SportsFlashEnabledLeaguesResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashEnabledLeaguesResult (const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_League >& Leagues_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashEnabledLeaguesResult();

    /**
     * Assignment operator
     */
    inline SportsFlashEnabledLeaguesResult& operator = (const SportsFlashEnabledLeaguesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashEnabledLeaguesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashEnabledLeaguesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashEnabledLeaguesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashEnabledLeaguesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Leagues"

    static const int kLeagues = 0;

    /**
     * Clears the field "Leagues".
     *
     * The field will be set to its default value. The hasLeagues()
     * method will return false.
     */
    inline void clearLeagues();

    /**
     * Checks whether the field "Leagues" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagues()). Otherwise it will return false.
     */
    inline bool hasLeagues () const;

    /**
     * Returns the value of the member "Leagues".
     *
     * List of sports flash supported leagues. Leagues that do not support Sports Flash feature are not added as part of this list.
     *
     * @return The value of the field "Leagues"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_League >& getLeagues () const;

    /**
     * Retrieves the value of the field "Leagues" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Leagues".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_League >& getLeaguesMutable ();

    /**
     * Sets the value of the member "Leagues".
     *
     * List of sports flash supported leagues. Leagues that do not support Sports Flash feature are not added as part of this list.
     *
     * @param Leagues The value which will be set
     */
    inline void setLeagues (const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_League >& Leagues_);

    static const SportsFlashEnabledLeaguesResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_League >& getT_SportsFlash_LeagueList_DefaultInstance ();

    inline void set_has_Leagues ();

    inline void clear_has_Leagues ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_League > _Leagues;

};

/**
 * The error message of 'SportsFlashEnabledLeagues'
 */
class SportsFlashEnabledLeaguesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashEnabledLeaguesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashEnabledLeaguesErrorStructure (const SportsFlashEnabledLeaguesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashEnabledLeaguesErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashEnabledLeaguesErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashEnabledLeaguesErrorStructure& operator = (const SportsFlashEnabledLeaguesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashEnabledLeaguesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashEnabledLeaguesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashEnabledLeaguesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashEnabledLeaguesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashEnabledLeaguesErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashEnabledLeagues'
 */
class SportsFlashEnabledLeaguesError  : public ::asf::core::Payload {
public:

    enum SportsFlashEnabledLeaguesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashEnabledLeaguesError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashEnabledLeaguesError (const SportsFlashEnabledLeaguesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashEnabledLeaguesError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashEnabledLeaguesError& operator = (const SportsFlashEnabledLeaguesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashEnabledLeaguesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashEnabledLeaguesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashEnabledLeaguesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashEnabledLeaguesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashEnabledLeaguesError::SportsFlashEnabledLeaguesErrorField getField () const;

    inline void setField(SportsFlashEnabledLeaguesError::SportsFlashEnabledLeaguesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashEnabledLeaguesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashEnabledLeaguesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashEnabledLeaguesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashEnabledLeaguesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashEnabledLeaguesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashEnabledLeaguesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashEnabledLeaguesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashEnabledLeaguesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashEnabledLeaguesError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashEnabledLeaguesError& rhs);

    inline void deleteData ();

    SportsFlashEnabledLeaguesErrorField __field;

    union {
        SportsFlashEnabledLeaguesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SportsFlashGetTeams"
 * Get List of all sports flash content supported teams affiliated to a League.
 */
class SportsFlashGetTeamsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashGetTeamsStart ();

    /**
     * Copy constructor
     */
    inline  SportsFlashGetTeamsStart (const SportsFlashGetTeamsStart &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashGetTeamsStart (::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport SportType_, uint8 LeagueID_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashGetTeamsStart();

    /**
     * Assignment operator
     */
    inline SportsFlashGetTeamsStart& operator = (const SportsFlashGetTeamsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetTeamsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetTeamsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetTeamsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetTeamsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportType"

    static const int kSportType = 0;

    /**
     * Clears the field "SportType".
     *
     * The field will be set to its default value. The hasSportType()
     * method will return false.
     */
    inline void clearSportType();

    /**
     * Checks whether the field "SportType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportType()). Otherwise it will return false.
     */
    inline bool hasSportType () const;

    /**
     * Returns the value of the member "SportType".
     *
     * The Sport Type to which the team belongs to.
     *
     * @return The value of the field "SportType"
     */
    inline ::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport getSportType () const;

    /**
     * Sets the value of the member "SportType".
     *
     * The Sport Type to which the team belongs to.
     *
     * @param SportType The value which will be set
     */
    inline void setSportType (::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport SportType_);

    // API of field "LeagueID"

    static const int kLeagueID = 1;

    /**
     * Clears the field "LeagueID".
     *
     * The field will be set to its default value. The hasLeagueID()
     * method will return false.
     */
    inline void clearLeagueID();

    /**
     * Checks whether the field "LeagueID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueID()). Otherwise it will return false.
     */
    inline bool hasLeagueID () const;

    /**
     * Returns the value of the member "LeagueID".
     *
     * The League Id to which the team is affiliated to.
     *
     * @return The value of the field "LeagueID"
     */
    inline uint8 getLeagueID () const;

    /**
     * Sets the value of the member "LeagueID".
     *
     * The League Id to which the team is affiliated to.
     *
     * @param LeagueID The value which will be set
     */
    inline void setLeagueID (uint8 LeagueID_);

    static const SportsFlashGetTeamsStart &getDefaultInstance();

private:

    inline void set_has_SportType ();

    inline void clear_has_SportType ();

    inline void set_has_LeagueID ();

    inline void clear_has_LeagueID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport _SportType;

    uint8 _LeagueID;

};

/**
 * The result message of the method "SportsFlashGetTeams"
 * Get List of all sports flash content supported teams affiliated to a League.
 */
class SportsFlashGetTeamsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashGetTeamsResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashGetTeamsResult (const SportsFlashGetTeamsResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashGetTeamsResult (const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_Team >& Teams_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashGetTeamsResult();

    /**
     * Assignment operator
     */
    inline SportsFlashGetTeamsResult& operator = (const SportsFlashGetTeamsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetTeamsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetTeamsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetTeamsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetTeamsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Teams"

    static const int kTeams = 0;

    /**
     * Clears the field "Teams".
     *
     * The field will be set to its default value. The hasTeams()
     * method will return false.
     */
    inline void clearTeams();

    /**
     * Checks whether the field "Teams" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeams()). Otherwise it will return false.
     */
    inline bool hasTeams () const;

    /**
     * Returns the value of the member "Teams".
     *
     * List of sports flash enabled teams affiliated to the league. Teams that do not support Sports Flash feature are not added as part of this list.
     *
     * @return The value of the field "Teams"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_Team >& getTeams () const;

    /**
     * Retrieves the value of the field "Teams" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Teams".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_Team >& getTeamsMutable ();

    /**
     * Sets the value of the member "Teams".
     *
     * List of sports flash enabled teams affiliated to the league. Teams that do not support Sports Flash feature are not added as part of this list.
     *
     * @param Teams The value which will be set
     */
    inline void setTeams (const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_Team >& Teams_);

    static const SportsFlashGetTeamsResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_Team >& getT_SportsFlash_TeamList_DefaultInstance ();

    inline void set_has_Teams ();

    inline void clear_has_Teams ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_Team > _Teams;

};

/**
 * The error message of 'SportsFlashGetTeams'
 */
class SportsFlashGetTeamsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashGetTeamsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashGetTeamsErrorStructure (const SportsFlashGetTeamsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashGetTeamsErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashGetTeamsErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashGetTeamsErrorStructure& operator = (const SportsFlashGetTeamsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetTeamsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetTeamsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetTeamsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetTeamsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashGetTeamsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashGetTeams'
 */
class SportsFlashGetTeamsError  : public ::asf::core::Payload {
public:

    enum SportsFlashGetTeamsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashGetTeamsError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashGetTeamsError (const SportsFlashGetTeamsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashGetTeamsError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashGetTeamsError& operator = (const SportsFlashGetTeamsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashGetTeamsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashGetTeamsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashGetTeamsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashGetTeamsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashGetTeamsError::SportsFlashGetTeamsErrorField getField () const;

    inline void setField(SportsFlashGetTeamsError::SportsFlashGetTeamsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashGetTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashGetTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashGetTeamsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashGetTeamsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashGetTeamsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashGetTeamsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashGetTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashGetTeamsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashGetTeamsError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashGetTeamsError& rhs);

    inline void deleteData ();

    SportsFlashGetTeamsErrorField __field;

    union {
        SportsFlashGetTeamsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SportsFlashMonitorTeams"
 * Method is applicable only for Teams that are already part of Favorite teams.
 * <p>Setting or unsetting favorite teams for sports flash monitoring. Method does not modify a teams entry to the Favorites list.</p>
 */
class SportsFlashMonitorTeamsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashMonitorTeamsStart ();

    /**
     * Copy constructor
     */
    inline  SportsFlashMonitorTeamsStart (const SportsFlashMonitorTeamsStart &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashMonitorTeamsStart (const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_MonitorTeam >& FavoriteTeams_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashMonitorTeamsStart();

    /**
     * Assignment operator
     */
    inline SportsFlashMonitorTeamsStart& operator = (const SportsFlashMonitorTeamsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashMonitorTeamsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashMonitorTeamsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashMonitorTeamsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashMonitorTeamsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FavoriteTeams"

    static const int kFavoriteTeams = 0;

    /**
     * Clears the field "FavoriteTeams".
     *
     * The field will be set to its default value. The hasFavoriteTeams()
     * method will return false.
     */
    inline void clearFavoriteTeams();

    /**
     * Checks whether the field "FavoriteTeams" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteTeams()). Otherwise it will return false.
     */
    inline bool hasFavoriteTeams () const;

    /**
     * Returns the value of the member "FavoriteTeams".
     *
     * List of each reported and not yet expired Flash Event.
     *
     * @return The value of the field "FavoriteTeams"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_MonitorTeam >& getFavoriteTeams () const;

    /**
     * Retrieves the value of the field "FavoriteTeams" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FavoriteTeams".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_MonitorTeam >& getFavoriteTeamsMutable ();

    /**
     * Sets the value of the member "FavoriteTeams".
     *
     * List of each reported and not yet expired Flash Event.
     *
     * @param FavoriteTeams The value which will be set
     */
    inline void setFavoriteTeams (const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_MonitorTeam >& FavoriteTeams_);

    static const SportsFlashMonitorTeamsStart &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_MonitorTeam >& getT_SportsFlash_MonitorTeamList_DefaultInstance ();

    inline void set_has_FavoriteTeams ();

    inline void clear_has_FavoriteTeams ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_MonitorTeam > _FavoriteTeams;

};

/**
 * The result message of the method "SportsFlashMonitorTeams"
 * Method is applicable only for Teams that are already part of Favorite teams.
 * <p>Setting or unsetting favorite teams for sports flash monitoring. Method does not modify a teams entry to the Favorites list.</p>
 */
class SportsFlashMonitorTeamsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashMonitorTeamsResult ();

    /**
     * Copy constructor
     */
    inline  SportsFlashMonitorTeamsResult (const SportsFlashMonitorTeamsResult &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashMonitorTeamsResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashMonitorTeamsResult();

    /**
     * Assignment operator
     */
    inline SportsFlashMonitorTeamsResult& operator = (const SportsFlashMonitorTeamsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashMonitorTeamsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashMonitorTeamsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashMonitorTeamsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashMonitorTeamsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if setting or unsetting a TEAM for sending Sports Flash events is success. FALSE upon failure.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if setting or unsetting a TEAM for sending Sports Flash events is success. FALSE upon failure.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SportsFlashMonitorTeamsResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SportsFlashMonitorTeams'
 */
class SportsFlashMonitorTeamsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsFlashMonitorTeamsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsFlashMonitorTeamsErrorStructure (const SportsFlashMonitorTeamsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsFlashMonitorTeamsErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsFlashMonitorTeamsErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsFlashMonitorTeamsErrorStructure& operator = (const SportsFlashMonitorTeamsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashMonitorTeamsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashMonitorTeamsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashMonitorTeamsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashMonitorTeamsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SportsFlashMonitorTeamsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsFlashMonitorTeams'
 */
class SportsFlashMonitorTeamsError  : public ::asf::core::Payload {
public:

    enum SportsFlashMonitorTeamsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsFlashMonitorTeamsError ();

   /**
     * Copy constructor
     */
    inline  SportsFlashMonitorTeamsError (const SportsFlashMonitorTeamsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsFlashMonitorTeamsError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsFlashMonitorTeamsError& operator = (const SportsFlashMonitorTeamsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsFlashMonitorTeamsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsFlashMonitorTeamsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsFlashMonitorTeamsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsFlashMonitorTeamsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsFlashMonitorTeamsError::SportsFlashMonitorTeamsErrorField getField () const;

    inline void setField(SportsFlashMonitorTeamsError::SportsFlashMonitorTeamsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsFlashMonitorTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsFlashMonitorTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsFlashMonitorTeamsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsFlashMonitorTeamsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsFlashMonitorTeamsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsFlashMonitorTeamsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsFlashMonitorTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsFlashMonitorTeamsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsFlashMonitorTeamsError &getDefaultInstance();

private:

    inline void cloneData (const SportsFlashMonitorTeamsError& rhs);

    inline void deleteData ();

    SportsFlashMonitorTeamsErrorField __field;

    union {
        SportsFlashMonitorTeamsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetChannelInfo"
 * Get Channel information list for the given list of SIDs
 */
class GetChannelInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChannelInfoStart ();

    /**
     * Copy constructor
     */
    inline  GetChannelInfoStart (const GetChannelInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelInfoStart (const ::std::vector< uint16 >& SIDList_);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelInfoStart();

    /**
     * Assignment operator
     */
    inline GetChannelInfoStart& operator = (const GetChannelInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SIDList"

    static const int kSIDList = 0;

    /**
     * Clears the field "SIDList".
     *
     * The field will be set to its default value. The hasSIDList()
     * method will return false.
     */
    inline void clearSIDList();

    /**
     * Checks whether the field "SIDList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSIDList()). Otherwise it will return false.
     */
    inline bool hasSIDList () const;

    /**
     * Returns the value of the member "SIDList".
     *
     * List of ServiceIdentifier
     *
     * @return The value of the field "SIDList"
     */
    inline const ::std::vector< uint16 >& getSIDList () const;

    /**
     * Retrieves the value of the field "SIDList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SIDList".
     */
    inline ::std::vector< uint16 >& getSIDListMutable ();

    /**
     * Sets the value of the member "SIDList".
     *
     * List of ServiceIdentifier
     *
     * @param SIDList The value which will be set
     */
    inline void setSIDList (const ::std::vector< uint16 >& SIDList_);

    static const GetChannelInfoStart &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_SIDList ();

    inline void clear_has_SIDList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint16 > _SIDList;

};

/**
 * The result message of the method "GetChannelInfo"
 * Get Channel information list for the given list of SIDs
 */
class GetChannelInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChannelInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetChannelInfoResult (const GetChannelInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelInfoResult (const ::std::vector< ::sxm_audio_main_fi_types::T_ChannelInformation >& ChannelInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelInfoResult();

    /**
     * Assignment operator
     */
    inline GetChannelInfoResult& operator = (const GetChannelInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelInfoList"

    static const int kChannelInfoList = 0;

    /**
     * Clears the field "ChannelInfoList".
     *
     * The field will be set to its default value. The hasChannelInfoList()
     * method will return false.
     */
    inline void clearChannelInfoList();

    /**
     * Checks whether the field "ChannelInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelInfoList()). Otherwise it will return false.
     */
    inline bool hasChannelInfoList () const;

    /**
     * Returns the value of the member "ChannelInfoList".
     *
     * <p>list of Channel information data</p>
     *
     * @return The value of the field "ChannelInfoList"
     */
    inline const ::std::vector< ::sxm_audio_main_fi_types::T_ChannelInformation >& getChannelInfoList () const;

    /**
     * Retrieves the value of the field "ChannelInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelInfoList".
     */
    inline ::std::vector< ::sxm_audio_main_fi_types::T_ChannelInformation >& getChannelInfoListMutable ();

    /**
     * Sets the value of the member "ChannelInfoList".
     *
     * <p>list of Channel information data</p>
     *
     * @param ChannelInfoList The value which will be set
     */
    inline void setChannelInfoList (const ::std::vector< ::sxm_audio_main_fi_types::T_ChannelInformation >& ChannelInfoList_);

    static const GetChannelInfoResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_audio_main_fi_types::T_ChannelInformation >& getT_ChannelInformationList_DefaultInstance ();

    inline void set_has_ChannelInfoList ();

    inline void clear_has_ChannelInfoList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_audio_main_fi_types::T_ChannelInformation > _ChannelInfoList;

};

/**
 * The error message of 'GetChannelInfo'
 */
class GetChannelInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetChannelInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetChannelInfoErrorStructure (const GetChannelInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelInfoErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetChannelInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetChannelInfoErrorStructure& operator = (const GetChannelInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of an error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const GetChannelInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetChannelInfo'
 */
class GetChannelInfoError  : public ::asf::core::Payload {
public:

    enum GetChannelInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetChannelInfoError ();

   /**
     * Copy constructor
     */
    inline  GetChannelInfoError (const GetChannelInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetChannelInfoError& operator = (const GetChannelInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetChannelInfoError::GetChannelInfoErrorField getField () const;

    inline void setField(GetChannelInfoError::GetChannelInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetChannelInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetChannelInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetChannelInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetChannelInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetChannelInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetChannelInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetChannelInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetChannelInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetChannelInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetChannelInfoError& rhs);

    inline void deleteData ();

    GetChannelInfoErrorField __field;

    union {
        GetChannelInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetDevicePosition"
 * Set the device position from HMI.
 * This can be used to set latitude and longitude for required data services.
 * Set the Device Position
 */
class SetDevicePositionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDevicePositionStart ();

    /**
     * Copy constructor
     */
    inline  SetDevicePositionStart (const SetDevicePositionStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetDevicePositionStart (int32 Latitude_, int32 Longitude_);

    /**
     * Destructor
     */
    inline virtual  ~SetDevicePositionStart();

    /**
     * Assignment operator
     */
    inline SetDevicePositionStart& operator = (const SetDevicePositionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDevicePositionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDevicePositionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDevicePositionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDevicePositionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Latitude"

    static const int kLatitude = 0;

    /**
     * Clears the field "Latitude".
     *
     * The field will be set to its default value. The hasLatitude()
     * method will return false.
     */
    inline void clearLatitude();

    /**
     * Checks whether the field "Latitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLatitude()). Otherwise it will return false.
     */
    inline bool hasLatitude () const;

    /**
     * Returns the value of the member "Latitude".
     *
     * Latitude of the Device Position. Default value is 0
     *
     * @return The value of the field "Latitude"
     */
    inline int32 getLatitude () const;

    /**
     * Sets the value of the member "Latitude".
     *
     * Latitude of the Device Position. Default value is 0
     *
     * @param Latitude The value which will be set
     */
    inline void setLatitude (int32 Latitude_);

    // API of field "Longitude"

    static const int kLongitude = 1;

    /**
     * Clears the field "Longitude".
     *
     * The field will be set to its default value. The hasLongitude()
     * method will return false.
     */
    inline void clearLongitude();

    /**
     * Checks whether the field "Longitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLongitude()). Otherwise it will return false.
     */
    inline bool hasLongitude () const;

    /**
     * Returns the value of the member "Longitude".
     *
     * Longitude of the Device Position. Default value is 0
     *
     * @return The value of the field "Longitude"
     */
    inline int32 getLongitude () const;

    /**
     * Sets the value of the member "Longitude".
     *
     * Longitude of the Device Position. Default value is 0
     *
     * @param Longitude The value which will be set
     */
    inline void setLongitude (int32 Longitude_);

    static const SetDevicePositionStart &getDefaultInstance();

private:

    inline void set_has_Latitude ();

    inline void clear_has_Latitude ();

    inline void set_has_Longitude ();

    inline void clear_has_Longitude ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _Latitude;

    int32 _Longitude;

};

/**
 * The result message of the method "SetDevicePosition"
 * Set the device position from HMI.
 * This can be used to set latitude and longitude for required data services.
 * Result of method
 */
class SetDevicePositionResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDevicePositionResult ();

    /**
     * Copy constructor
     */
    inline  SetDevicePositionResult (const SetDevicePositionResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetDevicePositionResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetDevicePositionResult();

    /**
     * Assignment operator
     */
    inline SetDevicePositionResult& operator = (const SetDevicePositionResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDevicePositionResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDevicePositionResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDevicePositionResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDevicePositionResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if Device Position is set successfully.
     * FALSE if failed to set Device Position.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if Device Position is set successfully.
     * FALSE if failed to set Device Position.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetDevicePositionResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SetDevicePosition'
 */
class SetDevicePositionErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetDevicePositionErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetDevicePositionErrorStructure (const SetDevicePositionErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetDevicePositionErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetDevicePositionErrorStructure();

    /**
     * Assignment operator
     */
    inline SetDevicePositionErrorStructure& operator = (const SetDevicePositionErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDevicePositionErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDevicePositionErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDevicePositionErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDevicePositionErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of the error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of the error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SetDevicePositionErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SetDevicePosition'
 */
class SetDevicePositionError  : public ::asf::core::Payload {
public:

    enum SetDevicePositionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetDevicePositionError ();

   /**
     * Copy constructor
     */
    inline  SetDevicePositionError (const SetDevicePositionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetDevicePositionError();

    /**
     * Assigns a new value to this object.
     */
    inline SetDevicePositionError& operator = (const SetDevicePositionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDevicePositionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDevicePositionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDevicePositionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDevicePositionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetDevicePositionError::SetDevicePositionErrorField getField () const;

    inline void setField(SetDevicePositionError::SetDevicePositionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetDevicePositionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetDevicePositionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetDevicePositionErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetDevicePositionErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetDevicePositionErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetDevicePositionErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetDevicePositionErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetDevicePositionErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetDevicePositionError &getDefaultInstance();

private:

    inline void cloneData (const SetDevicePositionError& rhs);

    inline void deleteData ();

    SetDevicePositionErrorField __field;

    union {
        SetDevicePositionErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetCategoryMonitor"
 * Method informs FC_SXM about the category user is interested in.
 * Upon receiving this instruction, FC_SXM would notify clients through property CategoryListStatus if the attribute of any channels within the selected category changes.
 * Set or unset the category to be monitored.
 */
class SetCategoryMonitorStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetCategoryMonitorStart ();

    /**
     * Copy constructor
     */
    inline  SetCategoryMonitorStart (const SetCategoryMonitorStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetCategoryMonitorStart (uint16 CategoryID_, const ::sxm_audio_main_fi_types::T_b16_CHANNEL_EVENT& ChannelEvents_, bool MonitorBrowsableChannels_, bool EnableMonitoring_);

    /**
     * Destructor
     */
    inline virtual  ~SetCategoryMonitorStart();

    /**
     * Assignment operator
     */
    inline SetCategoryMonitorStart& operator = (const SetCategoryMonitorStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCategoryMonitorStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCategoryMonitorStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCategoryMonitorStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCategoryMonitorStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CategoryID"

    static const int kCategoryID = 0;

    /**
     * Clears the field "CategoryID".
     *
     * The field will be set to its default value. The hasCategoryID()
     * method will return false.
     */
    inline void clearCategoryID();

    /**
     * Checks whether the field "CategoryID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryID()). Otherwise it will return false.
     */
    inline bool hasCategoryID () const;

    /**
     * Returns the value of the member "CategoryID".
     *
     * The categoryID which has to be monitored.
     * <p>If Category ID is 0, then by default all channels would be monitored.</p>
     *
     * @return The value of the field "CategoryID"
     */
    inline uint16 getCategoryID () const;

    /**
     * Sets the value of the member "CategoryID".
     *
     * The categoryID which has to be monitored.
     * <p>If Category ID is 0, then by default all channels would be monitored.</p>
     *
     * @param CategoryID The value which will be set
     */
    inline void setCategoryID (uint16 CategoryID_);

    // API of field "ChannelEvents"

    static const int kChannelEvents = 1;

    /**
     * Clears the field "ChannelEvents".
     *
     * The field will be set to its default value. The hasChannelEvents()
     * method will return false.
     */
    inline void clearChannelEvents();

    /**
     * Checks whether the field "ChannelEvents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelEvents()). Otherwise it will return false.
     */
    inline bool hasChannelEvents () const;

    /**
     * Returns the value of the member "ChannelEvents".
     *
     * Bitfield. The channel events that needs to be monitored.
     *
     * @return The value of the field "ChannelEvents"
     */
    inline const ::sxm_audio_main_fi_types::T_b16_CHANNEL_EVENT& getChannelEvents () const;

    /**
     * Retrieves the value of the field "ChannelEvents" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelEvents".
     */
    inline ::sxm_audio_main_fi_types::T_b16_CHANNEL_EVENT& getChannelEventsMutable ();

    /**
     * Sets the value of the member "ChannelEvents".
     *
     * Bitfield. The channel events that needs to be monitored.
     *
     * @param ChannelEvents The value which will be set
     */
    inline void setChannelEvents (const ::sxm_audio_main_fi_types::T_b16_CHANNEL_EVENT& ChannelEvents_);

    // API of field "MonitorBrowsableChannels"

    static const int kMonitorBrowsableChannels = 2;

    /**
     * Clears the field "MonitorBrowsableChannels".
     *
     * The field will be set to its default value. The hasMonitorBrowsableChannels()
     * method will return false.
     */
    inline void clearMonitorBrowsableChannels();

    /**
     * Checks whether the field "MonitorBrowsableChannels" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMonitorBrowsableChannels()). Otherwise it will return false.
     */
    inline bool hasMonitorBrowsableChannels () const;

    /**
     * Returns the value of the member "MonitorBrowsableChannels".
     *
     * If TRUE, then monitor only channels within the category that are Browsable and don't monitor for Skipped and Locked channels.
     * <p>If FALSE, then monitor for all channels within the category irrespective of channel browsable status.</p>
     *
     * @return The value of the field "MonitorBrowsableChannels"
     */
    inline bool getMonitorBrowsableChannels () const;

    /**
     * Sets the value of the member "MonitorBrowsableChannels".
     *
     * If TRUE, then monitor only channels within the category that are Browsable and don't monitor for Skipped and Locked channels.
     * <p>If FALSE, then monitor for all channels within the category irrespective of channel browsable status.</p>
     *
     * @param MonitorBrowsableChannels The value which will be set
     */
    inline void setMonitorBrowsableChannels (bool MonitorBrowsableChannels_);

    // API of field "EnableMonitoring"

    static const int kEnableMonitoring = 3;

    /**
     * Clears the field "EnableMonitoring".
     *
     * The field will be set to its default value. The hasEnableMonitoring()
     * method will return false.
     */
    inline void clearEnableMonitoring();

    /**
     * Checks whether the field "EnableMonitoring" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnableMonitoring()). Otherwise it will return false.
     */
    inline bool hasEnableMonitoring () const;

    /**
     * Returns the value of the member "EnableMonitoring".
     *
     * True if the category has to be monitored for channel attribute changes;
     * False if None of the categories has to be monitored. If this field's value is passed as zero the other fields values becomes insignificant and would be ignored.
     *
     * @return The value of the field "EnableMonitoring"
     */
    inline bool getEnableMonitoring () const;

    /**
     * Sets the value of the member "EnableMonitoring".
     *
     * True if the category has to be monitored for channel attribute changes;
     * False if None of the categories has to be monitored. If this field's value is passed as zero the other fields values becomes insignificant and would be ignored.
     *
     * @param EnableMonitoring The value which will be set
     */
    inline void setEnableMonitoring (bool EnableMonitoring_);

    static const SetCategoryMonitorStart &getDefaultInstance();

private:

    inline void set_has_CategoryID ();

    inline void clear_has_CategoryID ();

    inline void set_has_ChannelEvents ();

    inline void clear_has_ChannelEvents ();

    inline void set_has_MonitorBrowsableChannels ();

    inline void clear_has_MonitorBrowsableChannels ();

    inline void set_has_EnableMonitoring ();

    inline void clear_has_EnableMonitoring ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _CategoryID;

    ::sxm_audio_main_fi_types::T_b16_CHANNEL_EVENT _ChannelEvents;

    bool _MonitorBrowsableChannels;

    bool _EnableMonitoring;

};

/**
 * The result message of the method "SetCategoryMonitor"
 * Method informs FC_SXM about the category user is interested in.
 * Upon receiving this instruction, FC_SXM would notify clients through property CategoryListStatus if the attribute of any channels within the selected category changes.
 * Request status
 */
class SetCategoryMonitorResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetCategoryMonitorResult ();

    /**
     * Copy constructor
     */
    inline  SetCategoryMonitorResult (const SetCategoryMonitorResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetCategoryMonitorResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetCategoryMonitorResult();

    /**
     * Assignment operator
     */
    inline SetCategoryMonitorResult& operator = (const SetCategoryMonitorResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCategoryMonitorResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCategoryMonitorResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCategoryMonitorResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCategoryMonitorResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if given category has been set for monitoring successfully.
     * FALSE if given category could not be set for monitoring.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if given category has been set for monitoring successfully.
     * FALSE if given category could not be set for monitoring.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetCategoryMonitorResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'SetCategoryMonitor'
 */
class SetCategoryMonitorErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetCategoryMonitorErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetCategoryMonitorErrorStructure (const SetCategoryMonitorErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetCategoryMonitorErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetCategoryMonitorErrorStructure();

    /**
     * Assignment operator
     */
    inline SetCategoryMonitorErrorStructure& operator = (const SetCategoryMonitorErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCategoryMonitorErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCategoryMonitorErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCategoryMonitorErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCategoryMonitorErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of the error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of the error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const SetCategoryMonitorErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'SetCategoryMonitor'
 */
class SetCategoryMonitorError  : public ::asf::core::Payload {
public:

    enum SetCategoryMonitorErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetCategoryMonitorError ();

   /**
     * Copy constructor
     */
    inline  SetCategoryMonitorError (const SetCategoryMonitorError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetCategoryMonitorError();

    /**
     * Assigns a new value to this object.
     */
    inline SetCategoryMonitorError& operator = (const SetCategoryMonitorError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCategoryMonitorError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCategoryMonitorError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCategoryMonitorError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCategoryMonitorError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetCategoryMonitorError::SetCategoryMonitorErrorField getField () const;

    inline void setField(SetCategoryMonitorError::SetCategoryMonitorErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetCategoryMonitorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetCategoryMonitorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetCategoryMonitorErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetCategoryMonitorErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetCategoryMonitorErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetCategoryMonitorErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetCategoryMonitorErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetCategoryMonitorErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetCategoryMonitorError &getDefaultInstance();

private:

    inline void cloneData (const SetCategoryMonitorError& rhs);

    inline void deleteData ();

    SetCategoryMonitorErrorField __field;

    union {
        SetCategoryMonitorErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RapidChannelBrowseStart"
 * Start Rapid Channel Browsing.
 * Instruct FC_SXM MIDW to start with Rapid Channel Browsing.
 * <p>By default, the index from where RapidChannelBrowsing has to start would be taken from the current tuned channel.</p>
 */
class RapidChannelBrowseStartStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RapidChannelBrowseStartStart ();

    /**
     * Copy constructor
     */
    inline  RapidChannelBrowseStartStart (const RapidChannelBrowseStartStart &rhs);

    /**
     * All fields constructor
     */
    inline  RapidChannelBrowseStartStart (::sxm_audio_main_fi_types::T_e8_BrowseDirection Direction_, const ::sxm_audio_main_fi_types::T_BrowseChannelConfig& Config_, uint16 CategoryID_);

    /**
     * Destructor
     */
    inline virtual  ~RapidChannelBrowseStartStart();

    /**
     * Assignment operator
     */
    inline RapidChannelBrowseStartStart& operator = (const RapidChannelBrowseStartStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RapidChannelBrowseStartStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RapidChannelBrowseStartStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RapidChannelBrowseStartStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RapidChannelBrowseStartStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Direction"

    static const int kDirection = 0;

    /**
     * Clears the field "Direction".
     *
     * The field will be set to its default value. The hasDirection()
     * method will return false.
     */
    inline void clearDirection();

    /**
     * Checks whether the field "Direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirection()). Otherwise it will return false.
     */
    inline bool hasDirection () const;

    /**
     * Returns the value of the member "Direction".
     *
     * Channel Browse direction. (UP or DOWN)
     *
     * @return The value of the field "Direction"
     */
    inline ::sxm_audio_main_fi_types::T_e8_BrowseDirection getDirection () const;

    /**
     * Sets the value of the member "Direction".
     *
     * Channel Browse direction. (UP or DOWN)
     *
     * @param Direction The value which will be set
     */
    inline void setDirection (::sxm_audio_main_fi_types::T_e8_BrowseDirection Direction_);

    // API of field "Config"

    static const int kConfig = 1;

    /**
     * Clears the field "Config".
     *
     * The field will be set to its default value. The hasConfig()
     * method will return false.
     */
    inline void clearConfig();

    /**
     * Checks whether the field "Config" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfig()). Otherwise it will return false.
     */
    inline bool hasConfig () const;

    /**
     * Returns the value of the member "Config".
     *
     * Set if all channels or only channels belonging to a category needs to be considered for Rapid Channel Browsing.
     *
     * @return The value of the field "Config"
     */
    inline const ::sxm_audio_main_fi_types::T_BrowseChannelConfig& getConfig () const;

    /**
     * Retrieves the value of the field "Config" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Config".
     */
    inline ::sxm_audio_main_fi_types::T_BrowseChannelConfig& getConfigMutable ();

    /**
     * Sets the value of the member "Config".
     *
     * Set if all channels or only channels belonging to a category needs to be considered for Rapid Channel Browsing.
     *
     * @param Config The value which will be set
     */
    inline void setConfig (const ::sxm_audio_main_fi_types::T_BrowseChannelConfig& Config_);

    // API of field "CategoryID"

    static const int kCategoryID = 2;

    /**
     * Clears the field "CategoryID".
     *
     * The field will be set to its default value. The hasCategoryID()
     * method will return false.
     */
    inline void clearCategoryID();

    /**
     * Checks whether the field "CategoryID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryID()). Otherwise it will return false.
     */
    inline bool hasCategoryID () const;

    /**
     * Returns the value of the member "CategoryID".
     *
     * This parameter would be considered only if Type value is set to be "BROWSETYPE_CATEGORY_CHANNELS". If the type is BROWSETYPE_ALL_CHANNELS, then this parameter is ignored altogether.
     *
     * @return The value of the field "CategoryID"
     */
    inline uint16 getCategoryID () const;

    /**
     * Sets the value of the member "CategoryID".
     *
     * This parameter would be considered only if Type value is set to be "BROWSETYPE_CATEGORY_CHANNELS". If the type is BROWSETYPE_ALL_CHANNELS, then this parameter is ignored altogether.
     *
     * @param CategoryID The value which will be set
     */
    inline void setCategoryID (uint16 CategoryID_);

    static const RapidChannelBrowseStartStart &getDefaultInstance();

private:

    inline void set_has_Direction ();

    inline void clear_has_Direction ();

    inline void set_has_Config ();

    inline void clear_has_Config ();

    inline void set_has_CategoryID ();

    inline void clear_has_CategoryID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_BrowseDirection _Direction;

    ::sxm_audio_main_fi_types::T_BrowseChannelConfig _Config;

    uint16 _CategoryID;

};

/**
 * The result message of the method "RapidChannelBrowseStart"
 * Start Rapid Channel Browsing.
 * Request status
 */
class RapidChannelBrowseStartResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RapidChannelBrowseStartResult ();

    /**
     * Copy constructor
     */
    inline  RapidChannelBrowseStartResult (const RapidChannelBrowseStartResult &rhs);

    /**
     * All fields constructor
     */
    inline  RapidChannelBrowseStartResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~RapidChannelBrowseStartResult();

    /**
     * Assignment operator
     */
    inline RapidChannelBrowseStartResult& operator = (const RapidChannelBrowseStartResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RapidChannelBrowseStartResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RapidChannelBrowseStartResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RapidChannelBrowseStartResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RapidChannelBrowseStartResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if start of Rapid channel browsing is succesfull.
     * FALSE if start of Rapid channel browsing is NOT succesfull.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if start of Rapid channel browsing is succesfull.
     * FALSE if start of Rapid channel browsing is NOT succesfull.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const RapidChannelBrowseStartResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'RapidChannelBrowseStart'
 */
class RapidChannelBrowseStartErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RapidChannelBrowseStartErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RapidChannelBrowseStartErrorStructure (const RapidChannelBrowseStartErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RapidChannelBrowseStartErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~RapidChannelBrowseStartErrorStructure();

    /**
     * Assignment operator
     */
    inline RapidChannelBrowseStartErrorStructure& operator = (const RapidChannelBrowseStartErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RapidChannelBrowseStartErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RapidChannelBrowseStartErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RapidChannelBrowseStartErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RapidChannelBrowseStartErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of the error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of the error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const RapidChannelBrowseStartErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'RapidChannelBrowseStart'
 */
class RapidChannelBrowseStartError  : public ::asf::core::Payload {
public:

    enum RapidChannelBrowseStartErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RapidChannelBrowseStartError ();

   /**
     * Copy constructor
     */
    inline  RapidChannelBrowseStartError (const RapidChannelBrowseStartError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RapidChannelBrowseStartError();

    /**
     * Assigns a new value to this object.
     */
    inline RapidChannelBrowseStartError& operator = (const RapidChannelBrowseStartError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RapidChannelBrowseStartError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RapidChannelBrowseStartError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RapidChannelBrowseStartError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RapidChannelBrowseStartError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RapidChannelBrowseStartError::RapidChannelBrowseStartErrorField getField () const;

    inline void setField(RapidChannelBrowseStartError::RapidChannelBrowseStartErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RapidChannelBrowseStartErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RapidChannelBrowseStartErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RapidChannelBrowseStartErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RapidChannelBrowseStartErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RapidChannelBrowseStartErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RapidChannelBrowseStartErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RapidChannelBrowseStartErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RapidChannelBrowseStartErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RapidChannelBrowseStartError &getDefaultInstance();

private:

    inline void cloneData (const RapidChannelBrowseStartError& rhs);

    inline void deleteData ();

    RapidChannelBrowseStartErrorField __field;

    union {
        RapidChannelBrowseStartErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RapidChannelBrowseStop"
 * Stop Rapid Channel Browsing and tune to channel being passed.
 * Stop Rapid Channel Browsing.
 */
class RapidChannelBrowseStopStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RapidChannelBrowseStopStart ();

    /**
     * Copy constructor
     */
    inline  RapidChannelBrowseStopStart (const RapidChannelBrowseStopStart &rhs);

    /**
     * All fields constructor
     */
    inline  RapidChannelBrowseStopStart (uint16 ChannelID_);

    /**
     * Destructor
     */
    inline virtual  ~RapidChannelBrowseStopStart();

    /**
     * Assignment operator
     */
    inline RapidChannelBrowseStopStart& operator = (const RapidChannelBrowseStopStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RapidChannelBrowseStopStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RapidChannelBrowseStopStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RapidChannelBrowseStopStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RapidChannelBrowseStopStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelID"

    static const int kChannelID = 0;

    /**
     * Clears the field "ChannelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "ChannelID".
     *
     * The channelID which has to be tuned in addition to stopping Rapid Channel Browsing.
     * <p>This channelID that was last displayed to user while Rapid channel browsing was in progress;</p>
     * <p>Client needs to send channelID to FC_SXM
     * <p>a) to prevent any deviations in the channel being referred by FC_SXM and Clients;</p>
     * <p>b) to prevent any unexpected delays in asf.</p></p>
     *
     * @return The value of the field "ChannelID"
     */
    inline uint16 getChannelID () const;

    /**
     * Sets the value of the member "ChannelID".
     *
     * The channelID which has to be tuned in addition to stopping Rapid Channel Browsing.
     * <p>This channelID that was last displayed to user while Rapid channel browsing was in progress;</p>
     * <p>Client needs to send channelID to FC_SXM
     * <p>a) to prevent any deviations in the channel being referred by FC_SXM and Clients;</p>
     * <p>b) to prevent any unexpected delays in asf.</p></p>
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (uint16 ChannelID_);

    static const RapidChannelBrowseStopStart &getDefaultInstance();

private:

    inline void set_has_ChannelID ();

    inline void clear_has_ChannelID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _ChannelID;

};

/**
 * The result message of the method "RapidChannelBrowseStop"
 * Stop Rapid Channel Browsing and tune to channel being passed.
 * Request status
 */
class RapidChannelBrowseStopResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RapidChannelBrowseStopResult ();

    /**
     * Copy constructor
     */
    inline  RapidChannelBrowseStopResult (const RapidChannelBrowseStopResult &rhs);

    /**
     * All fields constructor
     */
    inline  RapidChannelBrowseStopResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~RapidChannelBrowseStopResult();

    /**
     * Assignment operator
     */
    inline RapidChannelBrowseStopResult& operator = (const RapidChannelBrowseStopResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RapidChannelBrowseStopResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RapidChannelBrowseStopResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RapidChannelBrowseStopResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RapidChannelBrowseStopResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if stopping of Rapid channel browsing is succesfull.
     * FALSE if stopping of Rapid channel browsing is NOT succesfull.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if stopping of Rapid channel browsing is succesfull.
     * FALSE if stopping of Rapid channel browsing is NOT succesfull.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const RapidChannelBrowseStopResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The error message of 'RapidChannelBrowseStop'
 */
class RapidChannelBrowseStopErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RapidChannelBrowseStopErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RapidChannelBrowseStopErrorStructure (const RapidChannelBrowseStopErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RapidChannelBrowseStopErrorStructure (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~RapidChannelBrowseStopErrorStructure();

    /**
     * Assignment operator
     */
    inline RapidChannelBrowseStopErrorStructure& operator = (const RapidChannelBrowseStopErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RapidChannelBrowseStopErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RapidChannelBrowseStopErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RapidChannelBrowseStopErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RapidChannelBrowseStopErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * The error code specifies the reason of the error
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_audio_main_fi_types::T_e8_ErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * The error code specifies the reason of the error
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_audio_main_fi_types::T_e8_ErrorTypes ErrorCode_);

    static const RapidChannelBrowseStopErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_audio_main_fi_types::T_e8_ErrorTypes _ErrorCode;

};

/**
 * The error message of 'RapidChannelBrowseStop'
 */
class RapidChannelBrowseStopError  : public ::asf::core::Payload {
public:

    enum RapidChannelBrowseStopErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RapidChannelBrowseStopError ();

   /**
     * Copy constructor
     */
    inline  RapidChannelBrowseStopError (const RapidChannelBrowseStopError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RapidChannelBrowseStopError();

    /**
     * Assigns a new value to this object.
     */
    inline RapidChannelBrowseStopError& operator = (const RapidChannelBrowseStopError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RapidChannelBrowseStopError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RapidChannelBrowseStopError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RapidChannelBrowseStopError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RapidChannelBrowseStopError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RapidChannelBrowseStopError::RapidChannelBrowseStopErrorField getField () const;

    inline void setField(RapidChannelBrowseStopError::RapidChannelBrowseStopErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RapidChannelBrowseStopErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RapidChannelBrowseStopErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RapidChannelBrowseStopErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RapidChannelBrowseStopErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RapidChannelBrowseStopErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RapidChannelBrowseStopErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RapidChannelBrowseStopErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RapidChannelBrowseStopErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RapidChannelBrowseStopError &getDefaultInstance();

private:

    inline void cloneData (const RapidChannelBrowseStopError& rhs);

    inline void deleteData ();

    RapidChannelBrowseStopErrorField __field;

    union {
        RapidChannelBrowseStopErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "ResetSXMModule"
 * Method Resets SXM Tuner Module to factory default state. All SXM services are stopped and restarted.
 * Request status
 */
class ResetSXMModuleResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetSXMModuleResult ();

    /**
     * Copy constructor
     */
    inline  ResetSXMModuleResult (const ResetSXMModuleResult &rhs);

    /**
     * All fields constructor
     */
    inline  ResetSXMModuleResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~ResetSXMModuleResult();

    /**
     * Assignment operator
     */
    inline ResetSXMModuleResult& operator = (const ResetSXMModuleResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetSXMModuleResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetSXMModuleResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetSXMModuleResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetSXMModuleResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasSt