/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "fi_types.h"
#include "fi_typesCca.h"
#include "sxm_agw_main_fi_types.h"
#include "sxm_agw_main_fi_typesCca.h"
#include "sxm_agw_main_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getTileType();
    out << (uint8) in.getTileDataType();
    out << in.getSharedMemoryName();
    out << in.getSharedMemorySize();
    out << in.getTimeout();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o0;
    in >> o0;
    out.setTileType((::sxm_agw_main_fi_types::T_e8_SXMTileType)o0);
    uint8 o1;
    in >> o1;
    out.setTileDataType((::sxm_agw_main_fi_types::T_e8_SXMTileDataType)o1);
    ::std::string o2;
    in >> o2;
    out.setSharedMemoryName(o2);
    uint32 o3;
    in >> o3;
    out.setSharedMemorySize(o3);
    int32 o4;
    in >> o4;
    out.setTimeout(o4);
}

void serializeCca(const ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getIssueTime(), out, majorVersion);
    serializeCca(in.getUpperLeftCorner(), out, majorVersion);
    serializeCca(in.getLowerRightCorner(), out, majorVersion);
    out << in.getWidth();
    out << in.getHeight();
    out << in.getPixelValueOffset();
    out << in.getPixelValuePrecision();
    out << in.getAddressOffset();
    out << in.getTileSize();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getIssueTimeMutable(), majorVersion);
    deserializeCca(in, out.getUpperLeftCornerMutable(), majorVersion);
    deserializeCca(in, out.getLowerRightCornerMutable(), majorVersion);
    uint32 o5;
    in >> o5;
    out.setWidth(o5);
    uint32 o6;
    in >> o6;
    out.setHeight(o6);
    int32 o7;
    in >> o7;
    out.setPixelValueOffset(o7);
    int32 o8;
    in >> o8;
    out.setPixelValuePrecision(o8);
    uint32 o9;
    in >> o9;
    out.setAddressOffset(o9);
    uint32 o10;
    in >> o10;
    out.setTileSize(o10);
}

void serializeCca(const ::sxm_agw_main_fi_types::T_SXMShape& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    switch(in.getField()) {
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_RESERVED:
    {
        out << (uint8) 0;
        serializeCca(in.getT_Reserved(), out, majorVersion);
        break;
    }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_FRONT:
    {
        out << (uint8) 1;
        serializeCca(in.getT_SXMShapeTypeFront(), out, majorVersion);
        break;
    }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_PRESSURE_CENTER:
    {
        out << (uint8) 2;
        serializeCca(in.getT_SXMShapeTypePressureCenter(), out, majorVersion);
        break;
    }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_ISOBAR:
    {
        out << (uint8) 3;
        serializeCca(in.getT_SXMShapeTypeIsobar(), out, majorVersion);
        break;
    }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_STORM_POSITION:
    {
        out << (uint8) 4;
        serializeCca(in.getT_SXMShapeTypeStormPosition(), out, majorVersion);
        break;
    }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_WIND_RADIUS:
    {
        out << (uint8) 5;
        serializeCca(in.getT_SXMShapeTypeWindRadius(), out, majorVersion);
        break;
    }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES:
    {
        out << (uint8) 6;
        serializeCca(in.getT_SXMShapeTypeStormAttributes(), out, majorVersion);
        break;
    }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_STORM_TRACK:
    {
        out << (uint8) 7;
        serializeCca(in.getT_SXMShapeTypeStormTrack(), out, majorVersion);
        break;
    }
    default:
        break;
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_agw_main_fi_types::T_SXMShape& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o12;
    in >> o12;
    uint8 o11(o12);
    switch (o11) {
    case 0:
    {
        out.setField (::sxm_agw_main_fi_types::T_SXMShape::E_T_RESERVED);
        deserializeCca(in, out.getT_ReservedMutable(), majorVersion);
        break;
    }
    case 1:
    {
        out.setField (::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_FRONT);
        deserializeCca(in, out.getT_SXMShapeTypeFrontMutable(), majorVersion);
        break;
    }
    case 2:
    {
        out.setField (::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_PRESSURE_CENTER);
        deserializeCca(in, out.getT_SXMShapeTypePressureCenterMutable(), majorVersion);
        break;
    }
    case 3:
    {
        out.setField (::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_ISOBAR);
        deserializeCca(in, out.getT_SXMShapeTypeIsobarMutable(), majorVersion);
        break;
    }
    case 4:
    {
        out.setField (::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_STORM_POSITION);
        deserializeCca(in, out.getT_SXMShapeTypeStormPositionMutable(), majorVersion);
        break;
    }
    case 5:
    {
        out.setField (::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_WIND_RADIUS);
        deserializeCca(in, out.getT_SXMShapeTypeWindRadiusMutable(), majorVersion);
        break;
    }
    case 6:
    {
        out.setField (::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES);
        deserializeCca(in, out.getT_SXMShapeTypeStormAttributesMutable(), majorVersion);
        break;
    }
    case 7:
    {
        out.setField (::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_STORM_TRACK);
        deserializeCca(in, out.getT_SXMShapeTypeStormTrackMutable(), majorVersion);
        break;
    }
    default:
        break;

    }
}

void serializeCca(const ::sxm_agw_main_fi_types::T_SXMShapeTypeFront& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getIssueTime(), out, majorVersion);
    out << (uint8) in.getFrontType();
    {
        uint32 o13 = static_cast<uint32>(in.getGeoPoints().size());
        out << o13;
        ::std::vector< ::fi_types::T_PositionWGS84 >::const_iterator o14;
        for (o14 = in.getGeoPoints().begin(); o14 != in.getGeoPoints().end(); ++o14) {
            serializeCca((*o14), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_agw_main_fi_types::T_SXMShapeTypeFront& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getIssueTimeMutable(), majorVersion);
    uint8 o15;
    in >> o15;
    out.setFrontType((::sxm_agw_main_fi_types::T_e8_FrontType)o15);
    {
        uint32 o16;
        in >> o16;
        out.getGeoPointsMutable().clear ();
        out.getGeoPointsMutable().reserve (o16);
        for (uint32 o17 = 0; o17 < o16; o17++) {
            ::fi_types::T_PositionWGS84 o18;
            deserializeCca(in, o18, majorVersion);
            out.getGeoPointsMutable().push_back (o18);
        }
    }
}

void serializeCca(const ::sxm_agw_main_fi_types::T_SXMShapeTypePressureCenter& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getIssueTime(), out, majorVersion);
    out << (uint8) in.getPressureType();
    out << in.getPressure();
    serializeCca(in.getGeoPoint(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_agw_main_fi_types::T_SXMShapeTypePressureCenter& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getIssueTimeMutable(), majorVersion);
    uint8 o19;
    in >> o19;
    out.setPressureType((::sxm_agw_main_fi_types::T_e8_PressureType)o19);
    int32 o20;
    in >> o20;
    out.setPressure(o20);
    deserializeCca(in, out.getGeoPointMutable(), majorVersion);
}

void serializeCca(const ::sxm_agw_main_fi_types::T_SXMShapeTypeIsobar& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getIssueTime(), out, majorVersion);
    out << in.getPressure();
    {
        uint32 o21 = static_cast<uint32>(in.getGeoPoints().size());
        out << o21;
        ::std::vector< ::fi_types::T_PositionWGS84 >::const_iterator o22;
        for (o22 = in.getGeoPoints().begin(); o22 != in.getGeoPoints().end(); ++o22) {
            serializeCca((*o22), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_agw_main_fi_types::T_SXMShapeTypeIsobar& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getIssueTimeMutable(), majorVersion);
    int32 o23;
    in >> o23;
    out.setPressure(o23);
    {
        uint32 o24;
        in >> o24;
        out.getGeoPointsMutable().clear ();
        out.getGeoPointsMutable().reserve (o24);
        for (uint32 o25 = 0; o25 < o24; o25++) {
            ::fi_types::T_PositionWGS84 o26;
            deserializeCca(in, o26, majorVersion);
            out.getGeoPointsMutable().push_back (o26);
        }
    }
}

void serializeCca(const ::sxm_agw_main_fi_types::T_SXMShapeTypeStormTrack& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getStormUniqueId();
    out << in.getStormName();
    {
        uint32 o27 = static_cast<uint32>(in.getStormPositions().size());
        out << o27;
        ::std::vector< ::sxm_agw_main_fi_types::T_SXMShapeTypeStormPosition >::const_iterator o28;
        for (o28 = in.getStormPositions().begin(); o28 != in.getStormPositions().end(); ++o28) {
            serializeCca((*o28), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_agw_main_fi_types::T_SXMShapeTypeStormTrack& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o29;
    in >> o29;
    out.setStormUniqueId(o29);
    ::std::string o30;
    in >> o30;
    out.setStormName(o30);
    {
        uint32 o31;
        in >> o31;
        out.getStormPositionsMutable().clear ();
        out.getStormPositionsMutable().reserve (o31);
        for (uint32 o32 = 0; o32 < o31; o32++) {
            ::sxm_agw_main_fi_types::T_SXMShapeTypeStormPosition o33;
            deserializeCca(in, o33, majorVersion);
            out.getStormPositionsMutable().push_back (o33);
        }
    }
}

void serializeCca(const ::sxm_agw_main_fi_types::T_SXMShapeTypeStormPosition& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getIssueTime(), out, majorVersion);
    if (1 >= majorVersion) {
        out << in.getStormUniqueId();
    }
    if (1 >= majorVersion) {
        out << in.getStormName();
    }
    out << in.getSequenceId();
    out << (uint8) in.getPositionType();
    out << in.getDirection();
    out << in.getSpeed();
    out << in.getMaxSustainedWinds();
    out << in.getGusts();
    out << in.getPressure();
    serializeCca(in.getTimestamp(), out, majorVersion);
    out << (uint8) in.getStormType();
    serializeCca(in.getGeoPoint(), out, majorVersion);
    if (2 <= majorVersion) {
        {
            uint32 o34 = static_cast<uint32>(in.getWindRadii().size());
            out << o34;
            ::std::vector< ::sxm_agw_main_fi_types::T_SXMShapeTypeWindRadius >::const_iterator o35;
            for (o35 = in.getWindRadii().begin(); o35 != in.getWindRadii().end(); ++o35) {
                serializeCca((*o35), out, majorVersion);
            }
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_agw_main_fi_types::T_SXMShapeTypeStormPosition& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getIssueTimeMutable(), majorVersion);
    if (1 >= majorVersion) {
        ::std::string o36;
        in >> o36;
        out.setStormUniqueId(o36);
    }
    if (1 >= majorVersion) {
        ::std::string o37;
        in >> o37;
        out.setStormName(o37);
    }
    uint16 o38;
    in >> o38;
    out.setSequenceId(o38);
    uint8 o39;
    in >> o39;
    out.setPositionType((::sxm_agw_main_fi_types::T_e8_StormPositionType)o39);
    int16 o40;
    in >> o40;
    out.setDirection(o40);
    int16 o41;
    in >> o41;
    out.setSpeed(o41);
    int16 o42;
    in >> o42;
    out.setMaxSustainedWinds(o42);
    int16 o43;
    in >> o43;
    out.setGusts(o43);
    int32 o44;
    in >> o44;
    out.setPressure(o44);
    deserializeCca(in, out.getTimestampMutable(), majorVersion);
    uint8 o45;
    in >> o45;
    out.setStormType((::sxm_agw_main_fi_types::T_e8_StormType)o45);
    deserializeCca(in, out.getGeoPointMutable(), majorVersion);
    if (2 <= majorVersion) {
        {
            uint32 o46;
            in >> o46;
            out.getWindRadiiMutable().clear ();
            out.getWindRadiiMutable().reserve (o46);
            for (uint32 o47 = 0; o47 < o46; o47++) {
                ::sxm_agw_main_fi_types::T_SXMShapeTypeWindRadius o48;
                deserializeCca(in, o48, majorVersion);
                out.getWindRadiiMutable().push_back (o48);
            }
        }
    }
}

void serializeCca(const ::sxm_agw_main_fi_types::T_SXMShapeTypeWindRadius& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    if (1 >= majorVersion) {
        serializeCca(in.getIssueTime(), out, majorVersion);
    }
    if (1 >= majorVersion) {
        out << in.getStormUniqueId();
    }
    if (1 >= majorVersion) {
        out << in.getSequenceId();
    }
    out << in.getWindSpeed();
    {
        uint32 o49 = static_cast<uint32>(in.getGeoPoints().size());
        out << o49;
        ::std::vector< ::fi_types::T_PositionWGS84 >::const_iterator o50;
        for (o50 = in.getGeoPoints().begin(); o50 != in.getGeoPoints().end(); ++o50) {
            serializeCca((*o50), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_agw_main_fi_types::T_SXMShapeTypeWindRadius& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    if (1 >= majorVersion) {
        deserializeCca(in, out.getIssueTimeMutable(), majorVersion);
    }
    if (1 >= majorVersion) {
        ::std::string o51;
        in >> o51;
        out.setStormUniqueId(o51);
    }
    if (1 >= majorVersion) {
        uint16 o52;
        in >> o52;
        out.setSequenceId(o52);
    }
    int16 o53;
    in >> o53;
    out.setWindSpeed(o53);
    {
        uint32 o54;
        in >> o54;
        out.getGeoPointsMutable().clear ();
        out.getGeoPointsMutable().reserve (o54);
        for (uint32 o55 = 0; o55 < o54; o55++) {
            ::fi_types::T_PositionWGS84 o56;
            deserializeCca(in, o56, majorVersion);
            out.getGeoPointsMutable().push_back (o56);
        }
    }
}

void serializeCca(const ::sxm_agw_main_fi_types::T_SXMShapeTypeStormAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getIssueTime(), out, majorVersion);
    out << in.getStormUniqueId();
    serializeCca(in.getObservationTime(), out, majorVersion);
    out << in.getEchoTopHeight();
    out << in.getMovementDirection();
    out << in.getMovementSpeed();
    serializeCca(in.getStormType(), out, majorVersion);
    serializeCca(in.getGeoPoint(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_agw_main_fi_types::T_SXMShapeTypeStormAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getIssueTimeMutable(), majorVersion);
    ::std::string o57;
    in >> o57;
    out.setStormUniqueId(o57);
    deserializeCca(in, out.getObservationTimeMutable(), majorVersion);
    int32 o58;
    in >> o58;
    out.setEchoTopHeight(o58);
    int16 o59;
    in >> o59;
    out.setMovementDirection(o59);
    int16 o60;
    in >> o60;
    out.setMovementSpeed(o60);
    deserializeCca(in, out.getStormTypeMutable(), majorVersion);
    deserializeCca(in, out.getGeoPointMutable(), majorVersion);
}

void serializeCca(const ::sxm_agw_main_fi_types::T_b8_StormType& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getHailProbable()) {
        bitmask |= (1 << 0);
    }
    if (in.getHailPositive()) {
        bitmask |= (1 << 1);
    }
    if (in.getMesocyclonic()) {
        bitmask |= (1 << 2);
    }
    if (in.getTornadic()) {
        bitmask |= (1 << 3);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_agw_main_fi_types::T_b8_StormType& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o61;
    in >> o61;
    uint8 bitmask(o61);

    if (bitmask & (1 << 0)) {
        out.setHailProbable (true);
    }
    if (bitmask & (1 << 1)) {
        out.setHailPositive (true);
    }
    if (bitmask & (1 << 2)) {
        out.setMesocyclonic (true);
    }
    if (bitmask & (1 << 3)) {
        out.setTornadic (true);
    }
}

