#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_AGW_MAIN_FI_TYPES_H
#define SXM_AGW_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_types.h"
#include "sxm_agw_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sxm_agw_main_fi_types
 */

namespace sxm_agw_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_SXMSharedMemoryDescription;

class T_SXMSharedMemoryTile;

class T_SXMShapeTypeFront;

class T_SXMShapeTypePressureCenter;

class T_SXMShapeTypeIsobar;

class T_SXMShapeTypeWindRadius;

class T_SXMShapeTypeStormPosition;

class T_b8_StormType;

class T_SXMShapeTypeStormAttributes;

class T_SXMShapeTypeStormTrack;

class T_SXMShape;


/**
 * This structure describes a shared-memory for data-exchange
 */
class T_SXMSharedMemoryDescription {
public:

    /**
     * Default constructor
     */
    inline  T_SXMSharedMemoryDescription ();

    /**
     * Copy constructor
     */
    inline  T_SXMSharedMemoryDescription (const T_SXMSharedMemoryDescription &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMSharedMemoryDescription (T_e8_SXMTileType TileType_, T_e8_SXMTileDataType TileDataType_, const ::std::string& SharedMemoryName_, uint32 SharedMemorySize_, ::fi_types::T_s32_MilliSecond Timeout_);

    /**
     * Destructor
     */
    inline  ~T_SXMSharedMemoryDescription();

    /**
     * Assignment operator
     */
    inline T_SXMSharedMemoryDescription& operator = (const T_SXMSharedMemoryDescription& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMSharedMemoryDescription& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMSharedMemoryDescription& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMSharedMemoryDescription& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMSharedMemoryDescription& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TileType"

    static const int kTileType = 0;

    /**
     * Clears the field "TileType".
     *
     * The field will be set to its default value. The hasTileType()
     * method will return false.
     */
    inline void clearTileType();

    /**
     * Checks whether the field "TileType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTileType()). Otherwise it will return false.
     */
    inline bool hasTileType () const;

    /**
     * Returns the value of the member "TileType".
     *
     * Type of tile to exchange data for with this shared memory.
     *
     * @return The value of the field "TileType"
     */
    inline T_e8_SXMTileType getTileType () const;

    /**
     * Sets the value of the member "TileType".
     *
     * Type of tile to exchange data for with this shared memory.
     *
     * @param TileType The value which will be set
     */
    inline void setTileType (T_e8_SXMTileType TileType_);

    // API of field "TileDataType"

    static const int kTileDataType = 1;

    /**
     * Clears the field "TileDataType".
     *
     * The field will be set to its default value. The hasTileDataType()
     * method will return false.
     */
    inline void clearTileDataType();

    /**
     * Checks whether the field "TileDataType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTileDataType()). Otherwise it will return false.
     */
    inline bool hasTileDataType () const;

    /**
     * Returns the value of the member "TileDataType".
     *
     * Data-Type of the tile in buffer, gives information how to interpret the data.
     *
     * @return The value of the field "TileDataType"
     */
    inline T_e8_SXMTileDataType getTileDataType () const;

    /**
     * Sets the value of the member "TileDataType".
     *
     * Data-Type of the tile in buffer, gives information how to interpret the data.
     *
     * @param TileDataType The value which will be set
     */
    inline void setTileDataType (T_e8_SXMTileDataType TileDataType_);

    // API of field "SharedMemoryName"

    static const int kSharedMemoryName = 2;

    /**
     * Clears the field "SharedMemoryName".
     *
     * The field will be set to its default value. The hasSharedMemoryName()
     * method will return false.
     */
    inline void clearSharedMemoryName();

    /**
     * Checks whether the field "SharedMemoryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSharedMemoryName()). Otherwise it will return false.
     */
    inline bool hasSharedMemoryName () const;

    /**
     * Returns the value of the member "SharedMemoryName".
     *
     * Name of shared memory to exchange data.
     *
     * @return The value of the field "SharedMemoryName"
     */
    inline const ::std::string& getSharedMemoryName () const;

    /**
     * Retrieves the value of the field "SharedMemoryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SharedMemoryName".
     */
    inline ::std::string& getSharedMemoryNameMutable ();

    /**
     * Sets the value of the member "SharedMemoryName".
     *
     * Name of shared memory to exchange data.
     *
     * @param SharedMemoryName The value which will be set
     */
    inline void setSharedMemoryName (const ::std::string& SharedMemoryName_);

    /**
     * Sets the value of the member "SharedMemoryName".
     *
     * Name of shared memory to exchange data.
     *
     * @param SharedMemoryName The value which will be set
     */
    inline void setSharedMemoryName (const char* SharedMemoryName_);

    /**
     * Sets the value of the member "SharedMemoryName".
     *
     * Name of shared memory to exchange data.
     *
     * @param SharedMemoryName The value which will be set
     */
    inline void setSharedMemoryName (const char* value, size_t size);

    // API of field "SharedMemorySize"

    static const int kSharedMemorySize = 3;

    /**
     * Clears the field "SharedMemorySize".
     *
     * The field will be set to its default value. The hasSharedMemorySize()
     * method will return false.
     */
    inline void clearSharedMemorySize();

    /**
     * Checks whether the field "SharedMemorySize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSharedMemorySize()). Otherwise it will return false.
     */
    inline bool hasSharedMemorySize () const;

    /**
     * Returns the value of the member "SharedMemorySize".
     *
     * Size of shared memory to exchange data.
     *
     * @return The value of the field "SharedMemorySize"
     */
    inline uint32 getSharedMemorySize () const;

    /**
     * Sets the value of the member "SharedMemorySize".
     *
     * Size of shared memory to exchange data.
     *
     * @param SharedMemorySize The value which will be set
     */
    inline void setSharedMemorySize (uint32 SharedMemorySize_);

    // API of field "Timeout"

    static const int kTimeout = 4;

    /**
     * Clears the field "Timeout".
     *
     * The field will be set to its default value. The hasTimeout()
     * method will return false.
     */
    inline void clearTimeout();

    /**
     * Checks whether the field "Timeout" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeout()). Otherwise it will return false.
     */
    inline bool hasTimeout () const;

    /**
     * Returns the value of the member "Timeout".
     *
     * <p>Contains the timeout in milliseconds, negative values are not allowed.</p>
     * <p>The server uses a value that is a little bit greater after which he releases
     * shared memory if client does not call the release method.</p>
     *
     * @return The value of the field "Timeout"
     */
    inline ::fi_types::T_s32_MilliSecond getTimeout () const;

    /**
     * Sets the value of the member "Timeout".
     *
     * <p>Contains the timeout in milliseconds, negative values are not allowed.</p>
     * <p>The server uses a value that is a little bit greater after which he releases
     * shared memory if client does not call the release method.</p>
     *
     * @param Timeout The value which will be set
     */
    inline void setTimeout (::fi_types::T_s32_MilliSecond Timeout_);

    static const T_SXMSharedMemoryDescription &getDefaultInstance();

private:

    inline void set_has_TileType ();

    inline void clear_has_TileType ();

    inline void set_has_TileDataType ();

    inline void clear_has_TileDataType ();

    inline void set_has_SharedMemoryName ();

    inline void clear_has_SharedMemoryName ();

    inline void set_has_SharedMemorySize ();

    inline void clear_has_SharedMemorySize ();

    inline void set_has_Timeout ();

    inline void clear_has_Timeout ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_SXMTileType _TileType;

    T_e8_SXMTileDataType _TileDataType;

    ::std::string _SharedMemoryName;

    uint32 _SharedMemorySize;

    ::fi_types::T_s32_MilliSecond _Timeout;

};

/**
 * This structure holds information about one tile stored in shared memory.
 */
class T_SXMSharedMemoryTile {
public:

    /**
     * Default constructor
     */
    inline  T_SXMSharedMemoryTile ();

    /**
     * Copy constructor
     */
    inline  T_SXMSharedMemoryTile (const T_SXMSharedMemoryTile &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMSharedMemoryTile (const ::fi_types::T_POSIXTime& IssueTime_, const ::fi_types::T_PositionWGS84& UpperLeftCorner_, const ::fi_types::T_PositionWGS84& LowerRightCorner_, uint32 Width_, uint32 Height_, int32 PixelValueOffset_, int32 PixelValuePrecision_, uint32 AddressOffset_, uint32 TileSize_);

    /**
     * Destructor
     */
    inline  ~T_SXMSharedMemoryTile();

    /**
     * Assignment operator
     */
    inline T_SXMSharedMemoryTile& operator = (const T_SXMSharedMemoryTile& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMSharedMemoryTile& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMSharedMemoryTile& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMSharedMemoryTile& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMSharedMemoryTile& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IssueTime"

    static const int kIssueTime = 0;

    /**
     * Clears the field "IssueTime".
     *
     * The field will be set to its default value. The hasIssueTime()
     * method will return false.
     */
    inline void clearIssueTime();

    /**
     * Checks whether the field "IssueTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIssueTime()). Otherwise it will return false.
     */
    inline bool hasIssueTime () const;

    /**
     * Returns the value of the member "IssueTime".
     *
     * Issue time of this tile
     *
     * @return The value of the field "IssueTime"
     */
    inline const ::fi_types::T_POSIXTime& getIssueTime () const;

    /**
     * Retrieves the value of the field "IssueTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IssueTime".
     */
    inline ::fi_types::T_POSIXTime& getIssueTimeMutable ();

    /**
     * Sets the value of the member "IssueTime".
     *
     * Issue time of this tile
     *
     * @param IssueTime The value which will be set
     */
    inline void setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_);

    // API of field "UpperLeftCorner"

    static const int kUpperLeftCorner = 1;

    /**
     * Clears the field "UpperLeftCorner".
     *
     * The field will be set to its default value. The hasUpperLeftCorner()
     * method will return false.
     */
    inline void clearUpperLeftCorner();

    /**
     * Checks whether the field "UpperLeftCorner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpperLeftCorner()). Otherwise it will return false.
     */
    inline bool hasUpperLeftCorner () const;

    /**
     * Returns the value of the member "UpperLeftCorner".
     *
     * Upper left (North-West) corner
     *
     * @return The value of the field "UpperLeftCorner"
     */
    inline const ::fi_types::T_PositionWGS84& getUpperLeftCorner () const;

    /**
     * Retrieves the value of the field "UpperLeftCorner" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UpperLeftCorner".
     */
    inline ::fi_types::T_PositionWGS84& getUpperLeftCornerMutable ();

    /**
     * Sets the value of the member "UpperLeftCorner".
     *
     * Upper left (North-West) corner
     *
     * @param UpperLeftCorner The value which will be set
     */
    inline void setUpperLeftCorner (const ::fi_types::T_PositionWGS84& UpperLeftCorner_);

    // API of field "LowerRightCorner"

    static const int kLowerRightCorner = 2;

    /**
     * Clears the field "LowerRightCorner".
     *
     * The field will be set to its default value. The hasLowerRightCorner()
     * method will return false.
     */
    inline void clearLowerRightCorner();

    /**
     * Checks whether the field "LowerRightCorner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLowerRightCorner()). Otherwise it will return false.
     */
    inline bool hasLowerRightCorner () const;

    /**
     * Returns the value of the member "LowerRightCorner".
     *
     * Lower right (South-East) corner
     *
     * @return The value of the field "LowerRightCorner"
     */
    inline const ::fi_types::T_PositionWGS84& getLowerRightCorner () const;

    /**
     * Retrieves the value of the field "LowerRightCorner" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LowerRightCorner".
     */
    inline ::fi_types::T_PositionWGS84& getLowerRightCornerMutable ();

    /**
     * Sets the value of the member "LowerRightCorner".
     *
     * Lower right (South-East) corner
     *
     * @param LowerRightCorner The value which will be set
     */
    inline void setLowerRightCorner (const ::fi_types::T_PositionWGS84& LowerRightCorner_);

    // API of field "Width"

    static const int kWidth = 3;

    /**
     * Clears the field "Width".
     *
     * The field will be set to its default value. The hasWidth()
     * method will return false.
     */
    inline void clearWidth();

    /**
     * Checks whether the field "Width" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWidth()). Otherwise it will return false.
     */
    inline bool hasWidth () const;

    /**
     * Returns the value of the member "Width".
     *
     * Width in pixels.
     *
     * @return The value of the field "Width"
     */
    inline uint32 getWidth () const;

    /**
     * Sets the value of the member "Width".
     *
     * Width in pixels.
     *
     * @param Width The value which will be set
     */
    inline void setWidth (uint32 Width_);

    // API of field "Height"

    static const int kHeight = 4;

    /**
     * Clears the field "Height".
     *
     * The field will be set to its default value. The hasHeight()
     * method will return false.
     */
    inline void clearHeight();

    /**
     * Checks whether the field "Height" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHeight()). Otherwise it will return false.
     */
    inline bool hasHeight () const;

    /**
     * Returns the value of the member "Height".
     *
     * Height in pixels.
     *
     * @return The value of the field "Height"
     */
    inline uint32 getHeight () const;

    /**
     * Sets the value of the member "Height".
     *
     * Height in pixels.
     *
     * @param Height The value which will be set
     */
    inline void setHeight (uint32 Height_);

    // API of field "PixelValueOffset"

    static const int kPixelValueOffset = 5;

    /**
     * Clears the field "PixelValueOffset".
     *
     * The field will be set to its default value. The hasPixelValueOffset()
     * method will return false.
     */
    inline void clearPixelValueOffset();

    /**
     * Checks whether the field "PixelValueOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPixelValueOffset()). Otherwise it will return false.
     */
    inline bool hasPixelValueOffset () const;

    /**
     * Returns the value of the member "PixelValueOffset".
     *
     * Offset to add to each pixel value in tile buffer, set to -1 if unkown or not allowed.
     *
     * @return The value of the field "PixelValueOffset"
     */
    inline int32 getPixelValueOffset () const;

    /**
     * Sets the value of the member "PixelValueOffset".
     *
     * Offset to add to each pixel value in tile buffer, set to -1 if unkown or not allowed.
     *
     * @param PixelValueOffset The value which will be set
     */
    inline void setPixelValueOffset (int32 PixelValueOffset_);

    // API of field "PixelValuePrecision"

    static const int kPixelValuePrecision = 6;

    /**
     * Clears the field "PixelValuePrecision".
     *
     * The field will be set to its default value. The hasPixelValuePrecision()
     * method will return false.
     */
    inline void clearPixelValuePrecision();

    /**
     * Checks whether the field "PixelValuePrecision" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPixelValuePrecision()). Otherwise it will return false.
     */
    inline bool hasPixelValuePrecision () const;

    /**
     * Returns the value of the member "PixelValuePrecision".
     *
     * Precision to multiply each pixel value in tile buffer with, set to -1 if unkown or not allowed.
     *
     * @return The value of the field "PixelValuePrecision"
     */
    inline int32 getPixelValuePrecision () const;

    /**
     * Sets the value of the member "PixelValuePrecision".
     *
     * Precision to multiply each pixel value in tile buffer with, set to -1 if unkown or not allowed.
     *
     * @param PixelValuePrecision The value which will be set
     */
    inline void setPixelValuePrecision (int32 PixelValuePrecision_);

    // API of field "AddressOffset"

    static const int kAddressOffset = 7;

    /**
     * Clears the field "AddressOffset".
     *
     * The field will be set to its default value. The hasAddressOffset()
     * method will return false.
     */
    inline void clearAddressOffset();

    /**
     * Checks whether the field "AddressOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressOffset()). Otherwise it will return false.
     */
    inline bool hasAddressOffset () const;

    /**
     * Returns the value of the member "AddressOffset".
     *
     * Address Offset of the tile in the Shared Memory.
     *
     * @return The value of the field "AddressOffset"
     */
    inline uint32 getAddressOffset () const;

    /**
     * Sets the value of the member "AddressOffset".
     *
     * Address Offset of the tile in the Shared Memory.
     *
     * @param AddressOffset The value which will be set
     */
    inline void setAddressOffset (uint32 AddressOffset_);

    // API of field "TileSize"

    static const int kTileSize = 8;

    /**
     * Clears the field "TileSize".
     *
     * The field will be set to its default value. The hasTileSize()
     * method will return false.
     */
    inline void clearTileSize();

    /**
     * Checks whether the field "TileSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTileSize()). Otherwise it will return false.
     */
    inline bool hasTileSize () const;

    /**
     * Returns the value of the member "TileSize".
     *
     * Size of the tile in the Shared Memory in bytes.
     *
     * @return The value of the field "TileSize"
     */
    inline uint32 getTileSize () const;

    /**
     * Sets the value of the member "TileSize".
     *
     * Size of the tile in the Shared Memory in bytes.
     *
     * @param TileSize The value which will be set
     */
    inline void setTileSize (uint32 TileSize_);

    static const T_SXMSharedMemoryTile &getDefaultInstance();

private:

    inline void set_has_IssueTime ();

    inline void clear_has_IssueTime ();

    inline void set_has_UpperLeftCorner ();

    inline void clear_has_UpperLeftCorner ();

    inline void set_has_LowerRightCorner ();

    inline void clear_has_LowerRightCorner ();

    inline void set_has_Width ();

    inline void clear_has_Width ();

    inline void set_has_Height ();

    inline void clear_has_Height ();

    inline void set_has_PixelValueOffset ();

    inline void clear_has_PixelValueOffset ();

    inline void set_has_PixelValuePrecision ();

    inline void clear_has_PixelValuePrecision ();

    inline void set_has_AddressOffset ();

    inline void clear_has_AddressOffset ();

    inline void set_has_TileSize ();

    inline void clear_has_TileSize ();

    uint32 _has_bits_[ (9 + 31) / 32];

    ::fi_types::T_POSIXTime _IssueTime;

    ::fi_types::T_PositionWGS84 _UpperLeftCorner;

    ::fi_types::T_PositionWGS84 _LowerRightCorner;

    uint32 _Width;

    uint32 _Height;

    int32 _PixelValueOffset;

    int32 _PixelValuePrecision;

    uint32 _AddressOffset;

    uint32 _TileSize;

};

/**
 * This structure defines a shape of the type front
 */
class T_SXMShapeTypeFront {
public:

    /**
     * Default constructor
     */
    inline  T_SXMShapeTypeFront ();

    /**
     * Copy constructor
     */
    inline  T_SXMShapeTypeFront (const T_SXMShapeTypeFront &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMShapeTypeFront (const ::fi_types::T_POSIXTime& IssueTime_, T_e8_FrontType FrontType_, const ::std::vector< ::fi_types::T_PositionWGS84 >& GeoPoints_);

    /**
     * Destructor
     */
    inline  ~T_SXMShapeTypeFront();

    /**
     * Assignment operator
     */
    inline T_SXMShapeTypeFront& operator = (const T_SXMShapeTypeFront& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMShapeTypeFront& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMShapeTypeFront& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMShapeTypeFront& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMShapeTypeFront& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IssueTime"

    static const int kIssueTime = 0;

    /**
     * Clears the field "IssueTime".
     *
     * The field will be set to its default value. The hasIssueTime()
     * method will return false.
     */
    inline void clearIssueTime();

    /**
     * Checks whether the field "IssueTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIssueTime()). Otherwise it will return false.
     */
    inline bool hasIssueTime () const;

    /**
     * Returns the value of the member "IssueTime".
     *
     * Issue time of this shape, -1 if invalid
     *
     * @return The value of the field "IssueTime"
     */
    inline const ::fi_types::T_POSIXTime& getIssueTime () const;

    /**
     * Retrieves the value of the field "IssueTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IssueTime".
     */
    inline ::fi_types::T_POSIXTime& getIssueTimeMutable ();

    /**
     * Sets the value of the member "IssueTime".
     *
     * Issue time of this shape, -1 if invalid
     *
     * @param IssueTime The value which will be set
     */
    inline void setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_);

    // API of field "FrontType"

    static const int kFrontType = 1;

    /**
     * Clears the field "FrontType".
     *
     * The field will be set to its default value. The hasFrontType()
     * method will return false.
     */
    inline void clearFrontType();

    /**
     * Checks whether the field "FrontType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrontType()). Otherwise it will return false.
     */
    inline bool hasFrontType () const;

    /**
     * Returns the value of the member "FrontType".
     *
     * Front type
     *
     * @return The value of the field "FrontType"
     */
    inline T_e8_FrontType getFrontType () const;

    /**
     * Sets the value of the member "FrontType".
     *
     * Front type
     *
     * @param FrontType The value which will be set
     */
    inline void setFrontType (T_e8_FrontType FrontType_);

    // API of field "GeoPoints"

    static const int kGeoPoints = 2;

    /**
     * Clears the field "GeoPoints".
     *
     * The field will be set to its default value. The hasGeoPoints()
     * method will return false.
     */
    inline void clearGeoPoints();

    /**
     * Checks whether the field "GeoPoints" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeoPoints()). Otherwise it will return false.
     */
    inline bool hasGeoPoints () const;

    /**
     * Returns the value of the member "GeoPoints".
     *
     * List of coordinates forming this shape.
     *
     * @return The value of the field "GeoPoints"
     */
    inline const ::std::vector< ::fi_types::T_PositionWGS84 >& getGeoPoints () const;

    /**
     * Retrieves the value of the field "GeoPoints" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GeoPoints".
     */
    inline ::std::vector< ::fi_types::T_PositionWGS84 >& getGeoPointsMutable ();

    /**
     * Sets the value of the member "GeoPoints".
     *
     * List of coordinates forming this shape.
     *
     * @param GeoPoints The value which will be set
     */
    inline void setGeoPoints (const ::std::vector< ::fi_types::T_PositionWGS84 >& GeoPoints_);

    static const T_SXMShapeTypeFront &getDefaultInstance();

private:

    static const ::std::vector< ::fi_types::T_PositionWGS84 >& getT_PositionWGS84List_DefaultInstance ();

    inline void set_has_IssueTime ();

    inline void clear_has_IssueTime ();

    inline void set_has_FrontType ();

    inline void clear_has_FrontType ();

    inline void set_has_GeoPoints ();

    inline void clear_has_GeoPoints ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::fi_types::T_POSIXTime _IssueTime;

    T_e8_FrontType _FrontType;

    ::std::vector< ::fi_types::T_PositionWGS84 > _GeoPoints;

};

/**
 * This structure defines a shape of the type pressure-center
 */
class T_SXMShapeTypePressureCenter {
public:

    /**
     * Default constructor
     */
    inline  T_SXMShapeTypePressureCenter ();

    /**
     * Copy constructor
     */
    inline  T_SXMShapeTypePressureCenter (const T_SXMShapeTypePressureCenter &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMShapeTypePressureCenter (const ::fi_types::T_POSIXTime& IssueTime_, T_e8_PressureType PressureType_, ::fi_types::T_s32_Pascal Pressure_, const ::fi_types::T_PositionWGS84& GeoPoint_);

    /**
     * Destructor
     */
    inline  ~T_SXMShapeTypePressureCenter();

    /**
     * Assignment operator
     */
    inline T_SXMShapeTypePressureCenter& operator = (const T_SXMShapeTypePressureCenter& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMShapeTypePressureCenter& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMShapeTypePressureCenter& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMShapeTypePressureCenter& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMShapeTypePressureCenter& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IssueTime"

    static const int kIssueTime = 0;

    /**
     * Clears the field "IssueTime".
     *
     * The field will be set to its default value. The hasIssueTime()
     * method will return false.
     */
    inline void clearIssueTime();

    /**
     * Checks whether the field "IssueTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIssueTime()). Otherwise it will return false.
     */
    inline bool hasIssueTime () const;

    /**
     * Returns the value of the member "IssueTime".
     *
     * Issue time of this shape, -1 means invalid
     *
     * @return The value of the field "IssueTime"
     */
    inline const ::fi_types::T_POSIXTime& getIssueTime () const;

    /**
     * Retrieves the value of the field "IssueTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IssueTime".
     */
    inline ::fi_types::T_POSIXTime& getIssueTimeMutable ();

    /**
     * Sets the value of the member "IssueTime".
     *
     * Issue time of this shape, -1 means invalid
     *
     * @param IssueTime The value which will be set
     */
    inline void setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_);

    // API of field "PressureType"

    static const int kPressureType = 1;

    /**
     * Clears the field "PressureType".
     *
     * The field will be set to its default value. The hasPressureType()
     * method will return false.
     */
    inline void clearPressureType();

    /**
     * Checks whether the field "PressureType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPressureType()). Otherwise it will return false.
     */
    inline bool hasPressureType () const;

    /**
     * Returns the value of the member "PressureType".
     *
     * Pressure type
     *
     * @return The value of the field "PressureType"
     */
    inline T_e8_PressureType getPressureType () const;

    /**
     * Sets the value of the member "PressureType".
     *
     * Pressure type
     *
     * @param PressureType The value which will be set
     */
    inline void setPressureType (T_e8_PressureType PressureType_);

    // API of field "Pressure"

    static const int kPressure = 2;

    /**
     * Clears the field "Pressure".
     *
     * The field will be set to its default value. The hasPressure()
     * method will return false.
     */
    inline void clearPressure();

    /**
     * Checks whether the field "Pressure" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPressure()). Otherwise it will return false.
     */
    inline bool hasPressure () const;

    /**
     * Returns the value of the member "Pressure".
     *
     * Pressure value in Pascal (100 Pascal = 1 millibar), -1 means invalid.
     *
     * @return The value of the field "Pressure"
     */
    inline ::fi_types::T_s32_Pascal getPressure () const;

    /**
     * Sets the value of the member "Pressure".
     *
     * Pressure value in Pascal (100 Pascal = 1 millibar), -1 means invalid.
     *
     * @param Pressure The value which will be set
     */
    inline void setPressure (::fi_types::T_s32_Pascal Pressure_);

    // API of field "GeoPoint"

    static const int kGeoPoint = 3;

    /**
     * Clears the field "GeoPoint".
     *
     * The field will be set to its default value. The hasGeoPoint()
     * method will return false.
     */
    inline void clearGeoPoint();

    /**
     * Checks whether the field "GeoPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeoPoint()). Otherwise it will return false.
     */
    inline bool hasGeoPoint () const;

    /**
     * Returns the value of the member "GeoPoint".
     *
     * Coordinate for this pressure center
     *
     * @return The value of the field "GeoPoint"
     */
    inline const ::fi_types::T_PositionWGS84& getGeoPoint () const;

    /**
     * Retrieves the value of the field "GeoPoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GeoPoint".
     */
    inline ::fi_types::T_PositionWGS84& getGeoPointMutable ();

    /**
     * Sets the value of the member "GeoPoint".
     *
     * Coordinate for this pressure center
     *
     * @param GeoPoint The value which will be set
     */
    inline void setGeoPoint (const ::fi_types::T_PositionWGS84& GeoPoint_);

    static const T_SXMShapeTypePressureCenter &getDefaultInstance();

private:

    inline void set_has_IssueTime ();

    inline void clear_has_IssueTime ();

    inline void set_has_PressureType ();

    inline void clear_has_PressureType ();

    inline void set_has_Pressure ();

    inline void clear_has_Pressure ();

    inline void set_has_GeoPoint ();

    inline void clear_has_GeoPoint ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::fi_types::T_POSIXTime _IssueTime;

    T_e8_PressureType _PressureType;

    ::fi_types::T_s32_Pascal _Pressure;

    ::fi_types::T_PositionWGS84 _GeoPoint;

};

/**
 * This structure defines a shape of the type isobar
 */
class T_SXMShapeTypeIsobar {
public:

    /**
     * Default constructor
     */
    inline  T_SXMShapeTypeIsobar ();

    /**
     * Copy constructor
     */
    inline  T_SXMShapeTypeIsobar (const T_SXMShapeTypeIsobar &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMShapeTypeIsobar (const ::fi_types::T_POSIXTime& IssueTime_, ::fi_types::T_s32_Pascal Pressure_, const ::std::vector< ::fi_types::T_PositionWGS84 >& GeoPoints_);

    /**
     * Destructor
     */
    inline  ~T_SXMShapeTypeIsobar();

    /**
     * Assignment operator
     */
    inline T_SXMShapeTypeIsobar& operator = (const T_SXMShapeTypeIsobar& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMShapeTypeIsobar& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMShapeTypeIsobar& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMShapeTypeIsobar& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMShapeTypeIsobar& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IssueTime"

    static const int kIssueTime = 0;

    /**
     * Clears the field "IssueTime".
     *
     * The field will be set to its default value. The hasIssueTime()
     * method will return false.
     */
    inline void clearIssueTime();

    /**
     * Checks whether the field "IssueTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIssueTime()). Otherwise it will return false.
     */
    inline bool hasIssueTime () const;

    /**
     * Returns the value of the member "IssueTime".
     *
     * Issue time of this shape, -1 means invalid
     *
     * @return The value of the field "IssueTime"
     */
    inline const ::fi_types::T_POSIXTime& getIssueTime () const;

    /**
     * Retrieves the value of the field "IssueTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IssueTime".
     */
    inline ::fi_types::T_POSIXTime& getIssueTimeMutable ();

    /**
     * Sets the value of the member "IssueTime".
     *
     * Issue time of this shape, -1 means invalid
     *
     * @param IssueTime The value which will be set
     */
    inline void setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_);

    // API of field "Pressure"

    static const int kPressure = 1;

    /**
     * Clears the field "Pressure".
     *
     * The field will be set to its default value. The hasPressure()
     * method will return false.
     */
    inline void clearPressure();

    /**
     * Checks whether the field "Pressure" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPressure()). Otherwise it will return false.
     */
    inline bool hasPressure () const;

    /**
     * Returns the value of the member "Pressure".
     *
     * pressure value in Pascal (100 Pascal = 1 millibar), -1 means invalid.
     *
     * @return The value of the field "Pressure"
     */
    inline ::fi_types::T_s32_Pascal getPressure () const;

    /**
     * Sets the value of the member "Pressure".
     *
     * pressure value in Pascal (100 Pascal = 1 millibar), -1 means invalid.
     *
     * @param Pressure The value which will be set
     */
    inline void setPressure (::fi_types::T_s32_Pascal Pressure_);

    // API of field "GeoPoints"

    static const int kGeoPoints = 2;

    /**
     * Clears the field "GeoPoints".
     *
     * The field will be set to its default value. The hasGeoPoints()
     * method will return false.
     */
    inline void clearGeoPoints();

    /**
     * Checks whether the field "GeoPoints" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeoPoints()). Otherwise it will return false.
     */
    inline bool hasGeoPoints () const;

    /**
     * Returns the value of the member "GeoPoints".
     *
     * List of coordinates forming this shape.
     *
     * @return The value of the field "GeoPoints"
     */
    inline const ::std::vector< ::fi_types::T_PositionWGS84 >& getGeoPoints () const;

    /**
     * Retrieves the value of the field "GeoPoints" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GeoPoints".
     */
    inline ::std::vector< ::fi_types::T_PositionWGS84 >& getGeoPointsMutable ();

    /**
     * Sets the value of the member "GeoPoints".
     *
     * List of coordinates forming this shape.
     *
     * @param GeoPoints The value which will be set
     */
    inline void setGeoPoints (const ::std::vector< ::fi_types::T_PositionWGS84 >& GeoPoints_);

    static const T_SXMShapeTypeIsobar &getDefaultInstance();

private:

    static const ::std::vector< ::fi_types::T_PositionWGS84 >& getT_PositionWGS84List_DefaultInstance ();

    inline void set_has_IssueTime ();

    inline void clear_has_IssueTime ();

    inline void set_has_Pressure ();

    inline void clear_has_Pressure ();

    inline void set_has_GeoPoints ();

    inline void clear_has_GeoPoints ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::fi_types::T_POSIXTime _IssueTime;

    ::fi_types::T_s32_Pascal _Pressure;

    ::std::vector< ::fi_types::T_PositionWGS84 > _GeoPoints;

};

/**
 * This structure defines a shape of the type wind-radius
 */
class T_SXMShapeTypeWindRadius {
public:

    /**
     * Default constructor
     */
    inline  T_SXMShapeTypeWindRadius ();

    /**
     * Copy constructor
     */
    inline  T_SXMShapeTypeWindRadius (const T_SXMShapeTypeWindRadius &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMShapeTypeWindRadius (const ::fi_types::T_POSIXTime& IssueTime_, const ::std::string& StormUniqueId_, uint16 SequenceId_, ::fi_types::T_s16_Knot WindSpeed_, const ::std::vector< ::fi_types::T_PositionWGS84 >& GeoPoints_);

    /**
     * Destructor
     */
    inline  ~T_SXMShapeTypeWindRadius();

    /**
     * Assignment operator
     */
    inline T_SXMShapeTypeWindRadius& operator = (const T_SXMShapeTypeWindRadius& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMShapeTypeWindRadius& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMShapeTypeWindRadius& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMShapeTypeWindRadius& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMShapeTypeWindRadius& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IssueTime"

    static const int kIssueTime = 0;

    /**
     * Clears the field "IssueTime".
     *
     * The field will be set to its default value. The hasIssueTime()
     * method will return false.
     */
    inline void clearIssueTime();

    /**
     * Checks whether the field "IssueTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIssueTime()). Otherwise it will return false.
     */
    inline bool hasIssueTime () const;

    /**
     * Returns the value of the member "IssueTime".
     *
     * Issue time of this shape, -1 means invalid
     *
     * @return The value of the field "IssueTime"
     */
    inline const ::fi_types::T_POSIXTime& getIssueTime () const;

    /**
     * Retrieves the value of the field "IssueTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IssueTime".
     */
    inline ::fi_types::T_POSIXTime& getIssueTimeMutable ();

    /**
     * Sets the value of the member "IssueTime".
     *
     * Issue time of this shape, -1 means invalid
     *
     * @param IssueTime The value which will be set
     */
    inline void setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_);

    // API of field "StormUniqueId"

    static const int kStormUniqueId = 1;

    /**
     * Clears the field "StormUniqueId".
     *
     * The field will be set to its default value. The hasStormUniqueId()
     * method will return false.
     */
    inline void clearStormUniqueId();

    /**
     * Checks whether the field "StormUniqueId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStormUniqueId()). Otherwise it will return false.
     */
    inline bool hasStormUniqueId () const;

    /**
     * Returns the value of the member "StormUniqueId".
     *
     * Id to identify the storm in other shapes.
     *
     * @return The value of the field "StormUniqueId"
     */
    inline const ::std::string& getStormUniqueId () const;

    /**
     * Retrieves the value of the field "StormUniqueId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StormUniqueId".
     */
    inline ::std::string& getStormUniqueIdMutable ();

    /**
     * Sets the value of the member "StormUniqueId".
     *
     * Id to identify the storm in other shapes.
     *
     * @param StormUniqueId The value which will be set
     */
    inline void setStormUniqueId (const ::std::string& StormUniqueId_);

    /**
     * Sets the value of the member "StormUniqueId".
     *
     * Id to identify the storm in other shapes.
     *
     * @param StormUniqueId The value which will be set
     */
    inline void setStormUniqueId (const char* StormUniqueId_);

    /**
     * Sets the value of the member "StormUniqueId".
     *
     * Id to identify the storm in other shapes.
     *
     * @param StormUniqueId The value which will be set
     */
    inline void setStormUniqueId (const char* value, size_t size);

    // API of field "SequenceId"

    static const int kSequenceId = 2;

    /**
     * Clears the field "SequenceId".
     *
     * The field will be set to its default value. The hasSequenceId()
     * method will return false.
     */
    inline void clearSequenceId();

    /**
     * Checks whether the field "SequenceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSequenceId()). Otherwise it will return false.
     */
    inline bool hasSequenceId () const;

    /**
     * Returns the value of the member "SequenceId".
     *
     * Sequence-id of this wind-info, to be mapped to corresponding position of the storm
     *
     * @return The value of the field "SequenceId"
     */
    inline uint16 getSequenceId () const;

    /**
     * Sets the value of the member "SequenceId".
     *
     * Sequence-id of this wind-info, to be mapped to corresponding position of the storm
     *
     * @param SequenceId The value which will be set
     */
    inline void setSequenceId (uint16 SequenceId_);

    // API of field "WindSpeed"

    static const int kWindSpeed = 3;

    /**
     * Clears the field "WindSpeed".
     *
     * The field will be set to its default value. The hasWindSpeed()
     * method will return false.
     */
    inline void clearWindSpeed();

    /**
     * Checks whether the field "WindSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWindSpeed()). Otherwise it will return false.
     */
    inline bool hasWindSpeed () const;

    /**
     * Returns the value of the member "WindSpeed".
     *
     * Wind speed inside this shape, -1 means invalid
     *
     * @return The value of the field "WindSpeed"
     */
    inline ::fi_types::T_s16_Knot getWindSpeed () const;

    /**
     * Sets the value of the member "WindSpeed".
     *
     * Wind speed inside this shape, -1 means invalid
     *
     * @param WindSpeed The value which will be set
     */
    inline void setWindSpeed (::fi_types::T_s16_Knot WindSpeed_);

    // API of field "GeoPoints"

    static const int kGeoPoints = 4;

    /**
     * Clears the field "GeoPoints".
     *
     * The field will be set to its default value. The hasGeoPoints()
     * method will return false.
     */
    inline void clearGeoPoints();

    /**
     * Checks whether the field "GeoPoints" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeoPoints()). Otherwise it will return false.
     */
    inline bool hasGeoPoints () const;

    /**
     * Returns the value of the member "GeoPoints".
     *
     * List of coordinates forming the shape for which wind has same speed.
     *
     * @return The value of the field "GeoPoints"
     */
    inline const ::std::vector< ::fi_types::T_PositionWGS84 >& getGeoPoints () const;

    /**
     * Retrieves the value of the field "GeoPoints" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GeoPoints".
     */
    inline ::std::vector< ::fi_types::T_PositionWGS84 >& getGeoPointsMutable ();

    /**
     * Sets the value of the member "GeoPoints".
     *
     * List of coordinates forming the shape for which wind has same speed.
     *
     * @param GeoPoints The value which will be set
     */
    inline void setGeoPoints (const ::std::vector< ::fi_types::T_PositionWGS84 >& GeoPoints_);

    static const T_SXMShapeTypeWindRadius &getDefaultInstance();

private:

    static const ::std::vector< ::fi_types::T_PositionWGS84 >& getT_PositionWGS84List_DefaultInstance ();

    inline void set_has_IssueTime ();

    inline void clear_has_IssueTime ();

    inline void set_has_StormUniqueId ();

    inline void clear_has_StormUniqueId ();

    inline void set_has_SequenceId ();

    inline void clear_has_SequenceId ();

    inline void set_has_WindSpeed ();

    inline void clear_has_WindSpeed ();

    inline void set_has_GeoPoints ();

    inline void clear_has_GeoPoints ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::fi_types::T_POSIXTime _IssueTime;

    ::std::string _StormUniqueId;

    uint16 _SequenceId;

    ::fi_types::T_s16_Knot _WindSpeed;

    ::std::vector< ::fi_types::T_PositionWGS84 > _GeoPoints;

};

/**
 * This structure defines a shape of the type storm-position
 */
class T_SXMShapeTypeStormPosition {
public:

    /**
     * Default constructor
     */
    inline  T_SXMShapeTypeStormPosition ();

    /**
     * Copy constructor
     */
    inline  T_SXMShapeTypeStormPosition (const T_SXMShapeTypeStormPosition &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMShapeTypeStormPosition (const ::fi_types::T_POSIXTime& IssueTime_, const ::std::string& StormUniqueId_, const ::std::string& StormName_, uint16 SequenceId_, T_e8_StormPositionType PositionType_, ::fi_types::T_s16_Degree Direction_, ::fi_types::T_s16_Knot Speed_, ::fi_types::T_s16_Knot MaxSustainedWinds_, ::fi_types::T_s16_Knot Gusts_, ::fi_types::T_s32_Pascal Pressure_, const ::fi_types::T_POSIXTime& Timestamp_, T_e8_StormType StormType_, const ::fi_types::T_PositionWGS84& GeoPoint_, const ::std::vector< T_SXMShapeTypeWindRadius >& WindRadii_);

    /**
     * Destructor
     */
    inline  ~T_SXMShapeTypeStormPosition();

    /**
     * Assignment operator
     */
    inline T_SXMShapeTypeStormPosition& operator = (const T_SXMShapeTypeStormPosition& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMShapeTypeStormPosition& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMShapeTypeStormPosition& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMShapeTypeStormPosition& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMShapeTypeStormPosition& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IssueTime"

    static const int kIssueTime = 0;

    /**
     * Clears the field "IssueTime".
     *
     * The field will be set to its default value. The hasIssueTime()
     * method will return false.
     */
    inline void clearIssueTime();

    /**
     * Checks whether the field "IssueTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIssueTime()). Otherwise it will return false.
     */
    inline bool hasIssueTime () const;

    /**
     * Returns the value of the member "IssueTime".
     *
     * Issue time of this shape, -1 means invalid
     *
     * @return The value of the field "IssueTime"
     */
    inline const ::fi_types::T_POSIXTime& getIssueTime () const;

    /**
     * Retrieves the value of the field "IssueTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IssueTime".
     */
    inline ::fi_types::T_POSIXTime& getIssueTimeMutable ();

    /**
     * Sets the value of the member "IssueTime".
     *
     * Issue time of this shape, -1 means invalid
     *
     * @param IssueTime The value which will be set
     */
    inline void setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_);

    // API of field "StormUniqueId"

    static const int kStormUniqueId = 1;

    /**
     * Clears the field "StormUniqueId".
     *
     * The field will be set to its default value. The hasStormUniqueId()
     * method will return false.
     */
    inline void clearStormUniqueId();

    /**
     * Checks whether the field "StormUniqueId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStormUniqueId()). Otherwise it will return false.
     */
    inline bool hasStormUniqueId () const;

    /**
     * Returns the value of the member "StormUniqueId".
     *
     * Id to identify the storm in other shapes.
     *
     * @return The value of the field "StormUniqueId"
     */
    inline const ::std::string& getStormUniqueId () const;

    /**
     * Retrieves the value of the field "StormUniqueId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StormUniqueId".
     */
    inline ::std::string& getStormUniqueIdMutable ();

    /**
     * Sets the value of the member "StormUniqueId".
     *
     * Id to identify the storm in other shapes.
     *
     * @param StormUniqueId The value which will be set
     */
    inline void setStormUniqueId (const ::std::string& StormUniqueId_);

    /**
     * Sets the value of the member "StormUniqueId".
     *
     * Id to identify the storm in other shapes.
     *
     * @param StormUniqueId The value which will be set
     */
    inline void setStormUniqueId (const char* StormUniqueId_);

    /**
     * Sets the value of the member "StormUniqueId".
     *
     * Id to identify the storm in other shapes.
     *
     * @param StormUniqueId The value which will be set
     */
    inline void setStormUniqueId (const char* value, size_t size);

    // API of field "StormName"

    static const int kStormName = 2;

    /**
     * Clears the field "StormName".
     *
     * The field will be set to its default value. The hasStormName()
     * method will return false.
     */
    inline void clearStormName();

    /**
     * Checks whether the field "StormName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStormName()). Otherwise it will return false.
     */
    inline bool hasStormName () const;

    /**
     * Returns the value of the member "StormName".
     *
     * Name of the storm
     *
     * @return The value of the field "StormName"
     */
    inline const ::std::string& getStormName () const;

    /**
     * Retrieves the value of the field "StormName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StormName".
     */
    inline ::std::string& getStormNameMutable ();

    /**
     * Sets the value of the member "StormName".
     *
     * Name of the storm
     *
     * @param StormName The value which will be set
     */
    inline void setStormName (const ::std::string& StormName_);

    /**
     * Sets the value of the member "StormName".
     *
     * Name of the storm
     *
     * @param StormName The value which will be set
     */
    inline void setStormName (const char* StormName_);

    /**
     * Sets the value of the member "StormName".
     *
     * Name of the storm
     *
     * @param StormName The value which will be set
     */
    inline void setStormName (const char* value, size_t size);

    // API of field "SequenceId"

    static const int kSequenceId = 3;

    /**
     * Clears the field "SequenceId".
     *
     * The field will be set to its default value. The hasSequenceId()
     * method will return false.
     */
    inline void clearSequenceId();

    /**
     * Checks whether the field "SequenceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSequenceId()). Otherwise it will return false.
     */
    inline bool hasSequenceId () const;

    /**
     * Returns the value of the member "SequenceId".
     *
     * Sequence-id of this position of the storm
     *
     * @return The value of the field "SequenceId"
     */
    inline uint16 getSequenceId () const;

    /**
     * Sets the value of the member "SequenceId".
     *
     * Sequence-id of this position of the storm
     *
     * @param SequenceId The value which will be set
     */
    inline void setSequenceId (uint16 SequenceId_);

    // API of field "PositionType"

    static const int kPositionType = 4;

    /**
     * Clears the field "PositionType".
     *
     * The field will be set to its default value. The hasPositionType()
     * method will return false.
     */
    inline void clearPositionType();

    /**
     * Checks whether the field "PositionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPositionType()). Otherwise it will return false.
     */
    inline bool hasPositionType () const;

    /**
     * Returns the value of the member "PositionType".
     *
     * Position type
     *
     * @return The value of the field "PositionType"
     */
    inline T_e8_StormPositionType getPositionType () const;

    /**
     * Sets the value of the member "PositionType".
     *
     * Position type
     *
     * @param PositionType The value which will be set
     */
    inline void setPositionType (T_e8_StormPositionType PositionType_);

    // API of field "Direction"

    static const int kDirection = 5;

    /**
     * Clears the field "Direction".
     *
     * The field will be set to its default value. The hasDirection()
     * method will return false.
     */
    inline void clearDirection();

    /**
     * Checks whether the field "Direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirection()). Otherwise it will return false.
     */
    inline bool hasDirection () const;

    /**
     * Returns the value of the member "Direction".
     *
     * travelling direction, -1 means invalid
     *
     * @return The value of the field "Direction"
     */
    inline ::fi_types::T_s16_Degree getDirection () const;

    /**
     * Sets the value of the member "Direction".
     *
     * travelling direction, -1 means invalid
     *
     * @param Direction The value which will be set
     */
    inline void setDirection (::fi_types::T_s16_Degree Direction_);

    // API of field "Speed"

    static const int kSpeed = 6;

    /**
     * Clears the field "Speed".
     *
     * The field will be set to its default value. The hasSpeed()
     * method will return false.
     */
    inline void clearSpeed();

    /**
     * Checks whether the field "Speed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeed()). Otherwise it will return false.
     */
    inline bool hasSpeed () const;

    /**
     * Returns the value of the member "Speed".
     *
     * Travelling speed of the storm, -1 means invalid
     *
     * @return The value of the field "Speed"
     */
    inline ::fi_types::T_s16_Knot getSpeed () const;

    /**
     * Sets the value of the member "Speed".
     *
     * Travelling speed of the storm, -1 means invalid
     *
     * @param Speed The value which will be set
     */
    inline void setSpeed (::fi_types::T_s16_Knot Speed_);

    // API of field "MaxSustainedWinds"

    static const int kMaxSustainedWinds = 7;

    /**
     * Clears the field "MaxSustainedWinds".
     *
     * The field will be set to its default value. The hasMaxSustainedWinds()
     * method will return false.
     */
    inline void clearMaxSustainedWinds();

    /**
     * Checks whether the field "MaxSustainedWinds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxSustainedWinds()). Otherwise it will return false.
     */
    inline bool hasMaxSustainedWinds () const;

    /**
     * Returns the value of the member "MaxSustainedWinds".
     *
     * Max. wind speed in knots, -1 means invalid
     *
     * @return The value of the field "MaxSustainedWinds"
     */
    inline ::fi_types::T_s16_Knot getMaxSustainedWinds () const;

    /**
     * Sets the value of the member "MaxSustainedWinds".
     *
     * Max. wind speed in knots, -1 means invalid
     *
     * @param MaxSustainedWinds The value which will be set
     */
    inline void setMaxSustainedWinds (::fi_types::T_s16_Knot MaxSustainedWinds_);

    // API of field "Gusts"

    static const int kGusts = 8;

    /**
     * Clears the field "Gusts".
     *
     * The field will be set to its default value. The hasGusts()
     * method will return false.
     */
    inline void clearGusts();

    /**
     * Checks whether the field "Gusts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGusts()). Otherwise it will return false.
     */
    inline bool hasGusts () const;

    /**
     * Returns the value of the member "Gusts".
     *
     * Gusts speed in knots, -1 means invalid
     *
     * @return The value of the field "Gusts"
     */
    inline ::fi_types::T_s16_Knot getGusts () const;

    /**
     * Sets the value of the member "Gusts".
     *
     * Gusts speed in knots, -1 means invalid
     *
     * @param Gusts The value which will be set
     */
    inline void setGusts (::fi_types::T_s16_Knot Gusts_);

    // API of field "Pressure"

    static const int kPressure = 9;

    /**
     * Clears the field "Pressure".
     *
     * The field will be set to its default value. The hasPressure()
     * method will return false.
     */
    inline void clearPressure();

    /**
     * Checks whether the field "Pressure" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPressure()). Otherwise it will return false.
     */
    inline bool hasPressure () const;

    /**
     * Returns the value of the member "Pressure".
     *
     * Pressure value in Pascal (100 Pascal = 1 millibar), -1 means invalid
     *
     * @return The value of the field "Pressure"
     */
    inline ::fi_types::T_s32_Pascal getPressure () const;

    /**
     * Sets the value of the member "Pressure".
     *
     * Pressure value in Pascal (100 Pascal = 1 millibar), -1 means invalid
     *
     * @param Pressure The value which will be set
     */
    inline void setPressure (::fi_types::T_s32_Pascal Pressure_);

    // API of field "Timestamp"

    static const int kTimestamp = 10;

    /**
     * Clears the field "Timestamp".
     *
     * The field will be set to its default value. The hasTimestamp()
     * method will return false.
     */
    inline void clearTimestamp();

    /**
     * Checks whether the field "Timestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimestamp()). Otherwise it will return false.
     */
    inline bool hasTimestamp () const;

    /**
     * Returns the value of the member "Timestamp".
     *
     * Storm position time stamp, -1 means invalid
     *
     * @return The value of the field "Timestamp"
     */
    inline const ::fi_types::T_POSIXTime& getTimestamp () const;

    /**
     * Retrieves the value of the field "Timestamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Timestamp".
     */
    inline ::fi_types::T_POSIXTime& getTimestampMutable ();

    /**
     * Sets the value of the member "Timestamp".
     *
     * Storm position time stamp, -1 means invalid
     *
     * @param Timestamp The value which will be set
     */
    inline void setTimestamp (const ::fi_types::T_POSIXTime& Timestamp_);

    // API of field "StormType"

    static const int kStormType = 11;

    /**
     * Clears the field "StormType".
     *
     * The field will be set to its default value. The hasStormType()
     * method will return false.
     */
    inline void clearStormType();

    /**
     * Checks whether the field "StormType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStormType()). Otherwise it will return false.
     */
    inline bool hasStormType () const;

    /**
     * Returns the value of the member "StormType".
     *
     * Storm type
     *
     * @return The value of the field "StormType"
     */
    inline T_e8_StormType getStormType () const;

    /**
     * Sets the value of the member "StormType".
     *
     * Storm type
     *
     * @param StormType The value which will be set
     */
    inline void setStormType (T_e8_StormType StormType_);

    // API of field "GeoPoint"

    static const int kGeoPoint = 12;

    /**
     * Clears the field "GeoPoint".
     *
     * The field will be set to its default value. The hasGeoPoint()
     * method will return false.
     */
    inline void clearGeoPoint();

    /**
     * Checks whether the field "GeoPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeoPoint()). Otherwise it will return false.
     */
    inline bool hasGeoPoint () const;

    /**
     * Returns the value of the member "GeoPoint".
     *
     * Coordinate for this storm position
     *
     * @return The value of the field "GeoPoint"
     */
    inline const ::fi_types::T_PositionWGS84& getGeoPoint () const;

    /**
     * Retrieves the value of the field "GeoPoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GeoPoint".
     */
    inline ::fi_types::T_PositionWGS84& getGeoPointMutable ();

    /**
     * Sets the value of the member "GeoPoint".
     *
     * Coordinate for this storm position
     *
     * @param GeoPoint The value which will be set
     */
    inline void setGeoPoint (const ::fi_types::T_PositionWGS84& GeoPoint_);

    // API of field "WindRadii"

    static const int kWindRadii = 13;

    /**
     * Clears the field "WindRadii".
     *
     * The field will be set to its default value. The hasWindRadii()
     * method will return false.
     */
    inline void clearWindRadii();

    /**
     * Checks whether the field "WindRadii" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWindRadii()). Otherwise it will return false.
     */
    inline bool hasWindRadii () const;

    /**
     * Returns the value of the member "WindRadii".
     *
     * List of wind radii belonging to this storm-position.
     *
     * @return The value of the field "WindRadii"
     */
    inline const ::std::vector< T_SXMShapeTypeWindRadius >& getWindRadii () const;

    /**
     * Retrieves the value of the field "WindRadii" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WindRadii".
     */
    inline ::std::vector< T_SXMShapeTypeWindRadius >& getWindRadiiMutable ();

    /**
     * Sets the value of the member "WindRadii".
     *
     * List of wind radii belonging to this storm-position.
     *
     * @param WindRadii The value which will be set
     */
    inline void setWindRadii (const ::std::vector< T_SXMShapeTypeWindRadius >& WindRadii_);

    static const T_SXMShapeTypeStormPosition &getDefaultInstance();

private:

    static const ::std::vector< T_SXMShapeTypeWindRadius >& getT_SXMShapeTypeWindRadiusList_DefaultInstance ();

    inline void set_has_IssueTime ();

    inline void clear_has_IssueTime ();

    inline void set_has_StormUniqueId ();

    inline void clear_has_StormUniqueId ();

    inline void set_has_StormName ();

    inline void clear_has_StormName ();

    inline void set_has_SequenceId ();

    inline void clear_has_SequenceId ();

    inline void set_has_PositionType ();

    inline void clear_has_PositionType ();

    inline void set_has_Direction ();

    inline void clear_has_Direction ();

    inline void set_has_Speed ();

    inline void clear_has_Speed ();

    inline void set_has_MaxSustainedWinds ();

    inline void clear_has_MaxSustainedWinds ();

    inline void set_has_Gusts ();

    inline void clear_has_Gusts ();

    inline void set_has_Pressure ();

    inline void clear_has_Pressure ();

    inline void set_has_Timestamp ();

    inline void clear_has_Timestamp ();

    inline void set_has_StormType ();

    inline void clear_has_StormType ();

    inline void set_has_GeoPoint ();

    inline void clear_has_GeoPoint ();

    inline void set_has_WindRadii ();

    inline void clear_has_WindRadii ();

    uint32 _has_bits_[ (14 + 31) / 32];

    ::fi_types::T_POSIXTime _IssueTime;

    ::std::string _StormUniqueId;

    ::std::string _StormName;

    uint16 _SequenceId;

    T_e8_StormPositionType _PositionType;

    ::fi_types::T_s16_Degree _Direction;

    ::fi_types::T_s16_Knot _Speed;

    ::fi_types::T_s16_Knot _MaxSustainedWinds;

    ::fi_types::T_s16_Knot _Gusts;

    ::fi_types::T_s32_Pascal _Pressure;

    ::fi_types::T_POSIXTime _Timestamp;

    T_e8_StormType _StormType;

    ::fi_types::T_PositionWGS84 _GeoPoint;

    ::std::vector< T_SXMShapeTypeWindRadius > _WindRadii;

};

/**
 * Storm type description
 */
class T_b8_StormType {
public:

    /**
     * Default constructor
     */
    inline  T_b8_StormType ();

    /**
     * Copy constructor
     */
    inline  T_b8_StormType (const T_b8_StormType &c);

    /**
     * Field constructor
     */
    inline  T_b8_StormType (bool HailProbable, bool HailPositive, bool Mesocyclonic, bool Tornadic);

    /**
     * Assignment operator
     */
    inline T_b8_StormType& operator = (const T_b8_StormType& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_StormType& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_StormType& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_StormType& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_StormType& rhs) const;

    /**
     * Sets the value of the member "HailProbable".
     *
     * If the meaning of "HailProbable" isn't clear, then there should be a description here.
     *
     * @param HailProbable The value which will be set
     */
    inline void setHailProbable (bool HailProbable);

    /**
     * Returns the value of the member "HailProbable".
     *
     * If the meaning of "HailProbable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HailProbable"
     */
    inline bool getHailProbable () const;

    /**
     * Sets the value of the member "HailPositive".
     *
     * If the meaning of "HailPositive" isn't clear, then there should be a description here.
     *
     * @param HailPositive The value which will be set
     */
    inline void setHailPositive (bool HailPositive);

    /**
     * Returns the value of the member "HailPositive".
     *
     * If the meaning of "HailPositive" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HailPositive"
     */
    inline bool getHailPositive () const;

    /**
     * Sets the value of the member "Mesocyclonic".
     *
     * If the meaning of "Mesocyclonic" isn't clear, then there should be a description here.
     *
     * @param Mesocyclonic The value which will be set
     */
    inline void setMesocyclonic (bool Mesocyclonic);

    /**
     * Returns the value of the member "Mesocyclonic".
     *
     * If the meaning of "Mesocyclonic" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Mesocyclonic"
     */
    inline bool getMesocyclonic () const;

    /**
     * Sets the value of the member "Tornadic".
     *
     * If the meaning of "Tornadic" isn't clear, then there should be a description here.
     *
     * @param Tornadic The value which will be set
     */
    inline void setTornadic (bool Tornadic);

    /**
     * Returns the value of the member "Tornadic".
     *
     * If the meaning of "Tornadic" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Tornadic"
     */
    inline bool getTornadic () const;

    static const T_b8_StormType &getDefaultInstance();

private:

    bool _HailProbable:1;

    bool _HailPositive:1;

    bool _Mesocyclonic:1;

    bool _Tornadic:1;

};

/**
 * This structure defines a shape of the type storm-attributes
 */
class T_SXMShapeTypeStormAttributes {
public:

    /**
     * Default constructor
     */
    inline  T_SXMShapeTypeStormAttributes ();

    /**
     * Copy constructor
     */
    inline  T_SXMShapeTypeStormAttributes (const T_SXMShapeTypeStormAttributes &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMShapeTypeStormAttributes (const ::fi_types::T_POSIXTime& IssueTime_, const ::std::string& StormUniqueId_, const ::fi_types::T_POSIXTime& ObservationTime_, ::fi_types::T_s32_Foot EchoTopHeight_, ::fi_types::T_s16_Degree MovementDirection_, ::fi_types::T_s16_Knot MovementSpeed_, const T_b8_StormType& StormType_, const ::fi_types::T_PositionWGS84& GeoPoint_);

    /**
     * Destructor
     */
    inline  ~T_SXMShapeTypeStormAttributes();

    /**
     * Assignment operator
     */
    inline T_SXMShapeTypeStormAttributes& operator = (const T_SXMShapeTypeStormAttributes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMShapeTypeStormAttributes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMShapeTypeStormAttributes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMShapeTypeStormAttributes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMShapeTypeStormAttributes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IssueTime"

    static const int kIssueTime = 0;

    /**
     * Clears the field "IssueTime".
     *
     * The field will be set to its default value. The hasIssueTime()
     * method will return false.
     */
    inline void clearIssueTime();

    /**
     * Checks whether the field "IssueTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIssueTime()). Otherwise it will return false.
     */
    inline bool hasIssueTime () const;

    /**
     * Returns the value of the member "IssueTime".
     *
     * Issue time of this shape, -1 means invalid
     *
     * @return The value of the field "IssueTime"
     */
    inline const ::fi_types::T_POSIXTime& getIssueTime () const;

    /**
     * Retrieves the value of the field "IssueTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IssueTime".
     */
    inline ::fi_types::T_POSIXTime& getIssueTimeMutable ();

    /**
     * Sets the value of the member "IssueTime".
     *
     * Issue time of this shape, -1 means invalid
     *
     * @param IssueTime The value which will be set
     */
    inline void setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_);

    // API of field "StormUniqueId"

    static const int kStormUniqueId = 1;

    /**
     * Clears the field "StormUniqueId".
     *
     * The field will be set to its default value. The hasStormUniqueId()
     * method will return false.
     */
    inline void clearStormUniqueId();

    /**
     * Checks whether the field "StormUniqueId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStormUniqueId()). Otherwise it will return false.
     */
    inline bool hasStormUniqueId () const;

    /**
     * Returns the value of the member "StormUniqueId".
     *
     * Id for this storm (handled like an unique name)
     *
     * @return The value of the field "StormUniqueId"
     */
    inline const ::std::string& getStormUniqueId () const;

    /**
     * Retrieves the value of the field "StormUniqueId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StormUniqueId".
     */
    inline ::std::string& getStormUniqueIdMutable ();

    /**
     * Sets the value of the member "StormUniqueId".
     *
     * Id for this storm (handled like an unique name)
     *
     * @param StormUniqueId The value which will be set
     */
    inline void setStormUniqueId (const ::std::string& StormUniqueId_);

    /**
     * Sets the value of the member "StormUniqueId".
     *
     * Id for this storm (handled like an unique name)
     *
     * @param StormUniqueId The value which will be set
     */
    inline void setStormUniqueId (const char* StormUniqueId_);

    /**
     * Sets the value of the member "StormUniqueId".
     *
     * Id for this storm (handled like an unique name)
     *
     * @param StormUniqueId The value which will be set
     */
    inline void setStormUniqueId (const char* value, size_t size);

    // API of field "ObservationTime"

    static const int kObservationTime = 2;

    /**
     * Clears the field "ObservationTime".
     *
     * The field will be set to its default value. The hasObservationTime()
     * method will return false.
     */
    inline void clearObservationTime();

    /**
     * Checks whether the field "ObservationTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setObservationTime()). Otherwise it will return false.
     */
    inline bool hasObservationTime () const;

    /**
     * Returns the value of the member "ObservationTime".
     *
     * Storm observation time stamp in UTC
     *
     * @return The value of the field "ObservationTime"
     */
    inline const ::fi_types::T_POSIXTime& getObservationTime () const;

    /**
     * Retrieves the value of the field "ObservationTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ObservationTime".
     */
    inline ::fi_types::T_POSIXTime& getObservationTimeMutable ();

    /**
     * Sets the value of the member "ObservationTime".
     *
     * Storm observation time stamp in UTC
     *
     * @param ObservationTime The value which will be set
     */
    inline void setObservationTime (const ::fi_types::T_POSIXTime& ObservationTime_);

    // API of field "EchoTopHeight"

    static const int kEchoTopHeight = 3;

    /**
     * Clears the field "EchoTopHeight".
     *
     * The field will be set to its default value. The hasEchoTopHeight()
     * method will return false.
     */
    inline void clearEchoTopHeight();

    /**
     * Checks whether the field "EchoTopHeight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEchoTopHeight()). Otherwise it will return false.
     */
    inline bool hasEchoTopHeight () const;

    /**
     * Returns the value of the member "EchoTopHeight".
     *
     * Echo top height in feet, -1 means invalid
     *
     * @return The value of the field "EchoTopHeight"
     */
    inline ::fi_types::T_s32_Foot getEchoTopHeight () const;

    /**
     * Sets the value of the member "EchoTopHeight".
     *
     * Echo top height in feet, -1 means invalid
     *
     * @param EchoTopHeight The value which will be set
     */
    inline void setEchoTopHeight (::fi_types::T_s32_Foot EchoTopHeight_);

    // API of field "MovementDirection"

    static const int kMovementDirection = 4;

    /**
     * Clears the field "MovementDirection".
     *
     * The field will be set to its default value. The hasMovementDirection()
     * method will return false.
     */
    inline void clearMovementDirection();

    /**
     * Checks whether the field "MovementDirection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovementDirection()). Otherwise it will return false.
     */
    inline bool hasMovementDirection () const;

    /**
     * Returns the value of the member "MovementDirection".
     *
     * Moving direction, -1 means invalid
     *
     * @return The value of the field "MovementDirection"
     */
    inline ::fi_types::T_s16_Degree getMovementDirection () const;

    /**
     * Sets the value of the member "MovementDirection".
     *
     * Moving direction, -1 means invalid
     *
     * @param MovementDirection The value which will be set
     */
    inline void setMovementDirection (::fi_types::T_s16_Degree MovementDirection_);

    // API of field "MovementSpeed"

    static const int kMovementSpeed = 5;

    /**
     * Clears the field "MovementSpeed".
     *
     * The field will be set to its default value. The hasMovementSpeed()
     * method will return false.
     */
    inline void clearMovementSpeed();

    /**
     * Checks whether the field "MovementSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMovementSpeed()). Otherwise it will return false.
     */
    inline bool hasMovementSpeed () const;

    /**
     * Returns the value of the member "MovementSpeed".
     *
     * Movement speed of the storm, -1 means invalid
     *
     * @return The value of the field "MovementSpeed"
     */
    inline ::fi_types::T_s16_Knot getMovementSpeed () const;

    /**
     * Sets the value of the member "MovementSpeed".
     *
     * Movement speed of the storm, -1 means invalid
     *
     * @param MovementSpeed The value which will be set
     */
    inline void setMovementSpeed (::fi_types::T_s16_Knot MovementSpeed_);

    // API of field "StormType"

    static const int kStormType = 6;

    /**
     * Clears the field "StormType".
     *
     * The field will be set to its default value. The hasStormType()
     * method will return false.
     */
    inline void clearStormType();

    /**
     * Checks whether the field "StormType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStormType()). Otherwise it will return false.
     */
    inline bool hasStormType () const;

    /**
     * Returns the value of the member "StormType".
     *
     * Bitfield describing the storm type
     *
     * @return The value of the field "StormType"
     */
    inline const T_b8_StormType& getStormType () const;

    /**
     * Retrieves the value of the field "StormType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StormType".
     */
    inline T_b8_StormType& getStormTypeMutable ();

    /**
     * Sets the value of the member "StormType".
     *
     * Bitfield describing the storm type
     *
     * @param StormType The value which will be set
     */
    inline void setStormType (const T_b8_StormType& StormType_);

    // API of field "GeoPoint"

    static const int kGeoPoint = 7;

    /**
     * Clears the field "GeoPoint".
     *
     * The field will be set to its default value. The hasGeoPoint()
     * method will return false.
     */
    inline void clearGeoPoint();

    /**
     * Checks whether the field "GeoPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeoPoint()). Otherwise it will return false.
     */
    inline bool hasGeoPoint () const;

    /**
     * Returns the value of the member "GeoPoint".
     *
     * Coordinate for this storm
     *
     * @return The value of the field "GeoPoint"
     */
    inline const ::fi_types::T_PositionWGS84& getGeoPoint () const;

    /**
     * Retrieves the value of the field "GeoPoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GeoPoint".
     */
    inline ::fi_types::T_PositionWGS84& getGeoPointMutable ();

    /**
     * Sets the value of the member "GeoPoint".
     *
     * Coordinate for this storm
     *
     * @param GeoPoint The value which will be set
     */
    inline void setGeoPoint (const ::fi_types::T_PositionWGS84& GeoPoint_);

    static const T_SXMShapeTypeStormAttributes &getDefaultInstance();

private:

    inline void set_has_IssueTime ();

    inline void clear_has_IssueTime ();

    inline void set_has_StormUniqueId ();

    inline void clear_has_StormUniqueId ();

    inline void set_has_ObservationTime ();

    inline void clear_has_ObservationTime ();

    inline void set_has_EchoTopHeight ();

    inline void clear_has_EchoTopHeight ();

    inline void set_has_MovementDirection ();

    inline void clear_has_MovementDirection ();

    inline void set_has_MovementSpeed ();

    inline void clear_has_MovementSpeed ();

    inline void set_has_StormType ();

    inline void clear_has_StormType ();

    inline void set_has_GeoPoint ();

    inline void clear_has_GeoPoint ();

    uint32 _has_bits_[ (8 + 31) / 32];

    ::fi_types::T_POSIXTime _IssueTime;

    ::std::string _StormUniqueId;

    ::fi_types::T_POSIXTime _ObservationTime;

    ::fi_types::T_s32_Foot _EchoTopHeight;

    ::fi_types::T_s16_Degree _MovementDirection;

    ::fi_types::T_s16_Knot _MovementSpeed;

    T_b8_StormType _StormType;

    ::fi_types::T_PositionWGS84 _GeoPoint;

};

/**
 * This structure defines a shape of the type storm track
 */
class T_SXMShapeTypeStormTrack {
public:

    /**
     * Default constructor
     */
    inline  T_SXMShapeTypeStormTrack ();

    /**
     * Copy constructor
     */
    inline  T_SXMShapeTypeStormTrack (const T_SXMShapeTypeStormTrack &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMShapeTypeStormTrack (const ::std::string& StormUniqueId_, const ::std::string& StormName_, const ::std::vector< T_SXMShapeTypeStormPosition >& StormPositions_);

    /**
     * Destructor
     */
    inline  ~T_SXMShapeTypeStormTrack();

    /**
     * Assignment operator
     */
    inline T_SXMShapeTypeStormTrack& operator = (const T_SXMShapeTypeStormTrack& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMShapeTypeStormTrack& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMShapeTypeStormTrack& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMShapeTypeStormTrack& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMShapeTypeStormTrack& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StormUniqueId"

    static const int kStormUniqueId = 0;

    /**
     * Clears the field "StormUniqueId".
     *
     * The field will be set to its default value. The hasStormUniqueId()
     * method will return false.
     */
    inline void clearStormUniqueId();

    /**
     * Checks whether the field "StormUniqueId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStormUniqueId()). Otherwise it will return false.
     */
    inline bool hasStormUniqueId () const;

    /**
     * Returns the value of the member "StormUniqueId".
     *
     * Id to identify the storm in other shapes.
     *
     * @return The value of the field "StormUniqueId"
     */
    inline const ::std::string& getStormUniqueId () const;

    /**
     * Retrieves the value of the field "StormUniqueId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StormUniqueId".
     */
    inline ::std::string& getStormUniqueIdMutable ();

    /**
     * Sets the value of the member "StormUniqueId".
     *
     * Id to identify the storm in other shapes.
     *
     * @param StormUniqueId The value which will be set
     */
    inline void setStormUniqueId (const ::std::string& StormUniqueId_);

    /**
     * Sets the value of the member "StormUniqueId".
     *
     * Id to identify the storm in other shapes.
     *
     * @param StormUniqueId The value which will be set
     */
    inline void setStormUniqueId (const char* StormUniqueId_);

    /**
     * Sets the value of the member "StormUniqueId".
     *
     * Id to identify the storm in other shapes.
     *
     * @param StormUniqueId The value which will be set
     */
    inline void setStormUniqueId (const char* value, size_t size);

    // API of field "StormName"

    static const int kStormName = 1;

    /**
     * Clears the field "StormName".
     *
     * The field will be set to its default value. The hasStormName()
     * method will return false.
     */
    inline void clearStormName();

    /**
     * Checks whether the field "StormName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStormName()). Otherwise it will return false.
     */
    inline bool hasStormName () const;

    /**
     * Returns the value of the member "StormName".
     *
     * Name of the storm
     *
     * @return The value of the field "StormName"
     */
    inline const ::std::string& getStormName () const;

    /**
     * Retrieves the value of the field "StormName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StormName".
     */
    inline ::std::string& getStormNameMutable ();

    /**
     * Sets the value of the member "StormName".
     *
     * Name of the storm
     *
     * @param StormName The value which will be set
     */
    inline void setStormName (const ::std::string& StormName_);

    /**
     * Sets the value of the member "StormName".
     *
     * Name of the storm
     *
     * @param StormName The value which will be set
     */
    inline void setStormName (const char* StormName_);

    /**
     * Sets the value of the member "StormName".
     *
     * Name of the storm
     *
     * @param StormName The value which will be set
     */
    inline void setStormName (const char* value, size_t size);

    // API of field "StormPositions"

    static const int kStormPositions = 2;

    /**
     * Clears the field "StormPositions".
     *
     * The field will be set to its default value. The hasStormPositions()
     * method will return false.
     */
    inline void clearStormPositions();

    /**
     * Checks whether the field "StormPositions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStormPositions()). Otherwise it will return false.
     */
    inline bool hasStormPositions () const;

    /**
     * Returns the value of the member "StormPositions".
     *
     * List of storm positions belonging to this storm.
     *
     * @return The value of the field "StormPositions"
     */
    inline const ::std::vector< T_SXMShapeTypeStormPosition >& getStormPositions () const;

    /**
     * Retrieves the value of the field "StormPositions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StormPositions".
     */
    inline ::std::vector< T_SXMShapeTypeStormPosition >& getStormPositionsMutable ();

    /**
     * Sets the value of the member "StormPositions".
     *
     * List of storm positions belonging to this storm.
     *
     * @param StormPositions The value which will be set
     */
    inline void setStormPositions (const ::std::vector< T_SXMShapeTypeStormPosition >& StormPositions_);

    static const T_SXMShapeTypeStormTrack &getDefaultInstance();

private:

    static const ::std::vector< T_SXMShapeTypeStormPosition >& getT_SXMShapeTypeStormPositionList_DefaultInstance ();

    inline void set_has_StormUniqueId ();

    inline void clear_has_StormUniqueId ();

    inline void set_has_StormName ();

    inline void clear_has_StormName ();

    inline void set_has_StormPositions ();

    inline void clear_has_StormPositions ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _StormUniqueId;

    ::std::string _StormName;

    ::std::vector< T_SXMShapeTypeStormPosition > _StormPositions;

};

/**
 * If the meaning of "T_SXMShape" isn't clear, then there should be a description here.
 */
class T_SXMShape {
public:

    enum T_SXMShapeField {
        E_T_RESERVED = 0,
        E_T_SXMSHAPE_TYPE_FRONT = 1,
        E_T_SXMSHAPE_TYPE_PRESSURE_CENTER = 2,
        E_T_SXMSHAPE_TYPE_ISOBAR = 3,
        E_T_SXMSHAPE_TYPE_STORM_POSITION = 4,
        E_T_SXMSHAPE_TYPE_WIND_RADIUS = 5,
        E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES = 6,
        E_T_SXMSHAPE_TYPE_STORM_TRACK = 7
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "T_Reserved".
     */
    inline  T_SXMShape ();

   /**
     * Copy constructor
     */
    inline  T_SXMShape (const T_SXMShape& rhs);

    /**
     * Destructor
     */
    inline  ~T_SXMShape();

    /**
     * Assigns a new value to this object.
     */
    inline T_SXMShape& operator = (const T_SXMShape& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMShape& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMShape& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMShape& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMShape& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline T_SXMShape::T_SXMShapeField getField () const;

    inline void setField(T_SXMShape::T_SXMShapeField field);

    // ---- Field accessors -------------------------------------------

    // API of field "T_Reserved"

    static const int kT_Reserved = 0;

    /**
     * Returns true if the field "T_Reserved" has a value.
     *
     * If the meaning of "T_Reserved" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_Reserved", otherwise false
     */
    inline bool hasT_Reserved () const;

    /**
     * Returns the value of field "T_Reserved".It is only valid to call this
     * method if hasT_Reserved() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "T_Reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ::fi_types::T_Reserved& getT_Reserved() const ;

    /**
     * Retrieves the value of the field "T_Reserved" as a mutable object. Any
     * modifications on the returned object will affect the containing object.
     *
     * It is only valid to call this method if isT_Reserved() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ::fi_types::T_Reserved& getT_ReservedMutable();

    /**
     * Release the object stored in the field "T_Reserved".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_Reserved" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_Reserved"
     */
    inline ::fi_types::T_Reserved* releaseT_Reserved();

    /**
     * Replace the field "T_Reserved".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_Reserved (::fi_types::T_Reserved* T_Reserved);

    /**
     * Sets the value of the field "T_Reserved". A field which was previously
     * set will be cleared.
     *
     * If the meaning of "T_Reserved" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_Reserved (const ::fi_types::T_Reserved& value);

    // API of field "T_SXMShapeTypeFront"

    static const int kT_SXMShapeTypeFront = 1;

    /**
     * Returns true if the field "T_SXMShapeTypeFront" has a value.
     *
     * If the meaning of "T_SXMShapeTypeFront" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_SXMShapeTypeFront", otherwise false
     */
    inline bool hasT_SXMShapeTypeFront () const;

    /**
     * Returns the value of field "T_SXMShapeTypeFront".It is only valid to
     * call this method if hasT_SXMShapeTypeFront() returns true. Otherwise
     * the behavior is not specified.
     *
     * If the meaning of "T_SXMShapeTypeFront" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_SXMShapeTypeFront& getT_SXMShapeTypeFront() const ;

    /**
     * Retrieves the value of the field "T_SXMShapeTypeFront" as a mutable
     * object. Any modifications on the returned object will affect the
     * containing object.
     *
     * It is only valid to call this method if isT_SXMShapeTypeFront() returns
     * true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline T_SXMShapeTypeFront& getT_SXMShapeTypeFrontMutable();

    /**
     * Release the object stored in the field "T_SXMShapeTypeFront".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_SXMShapeTypeFront" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_SXMShapeTypeFront"
     */
    inline T_SXMShapeTypeFront* releaseT_SXMShapeTypeFront();

    /**
     * Replace the field "T_SXMShapeTypeFront".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_SXMShapeTypeFront (T_SXMShapeTypeFront* T_SXMShapeTypeFront);

    /**
     * Sets the value of the field "T_SXMShapeTypeFront". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "T_SXMShapeTypeFront" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_SXMShapeTypeFront (const T_SXMShapeTypeFront& value);

    // API of field "T_SXMShapeTypePressureCenter"

    static const int kT_SXMShapeTypePressureCenter = 2;

    /**
     * Returns true if the field "T_SXMShapeTypePressureCenter" has a value.
     *
     * If the meaning of "T_SXMShapeTypePressureCenter" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_SXMShapeTypePressureCenter", otherwise false
     */
    inline bool hasT_SXMShapeTypePressureCenter () const;

    /**
     * Returns the value of field "T_SXMShapeTypePressureCenter".It is only
     * valid to call this method if hasT_SXMShapeTypePressureCenter() returns
     * true. Otherwise the behavior is not specified.
     *
     * If the meaning of "T_SXMShapeTypePressureCenter" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_SXMShapeTypePressureCenter& getT_SXMShapeTypePressureCenter() const ;

    /**
     * Retrieves the value of the field "T_SXMShapeTypePressureCenter" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if
     * isT_SXMShapeTypePressureCenter() returns true. Otherwise the behavior
     * is not specified.
     *
     * @return The value of the union
     */
    inline T_SXMShapeTypePressureCenter& getT_SXMShapeTypePressureCenterMutable();

    /**
     * Release the object stored in the field "T_SXMShapeTypePressureCenter".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_SXMShapeTypePressureCenter" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_SXMShapeTypePressureCenter"
     */
    inline T_SXMShapeTypePressureCenter* releaseT_SXMShapeTypePressureCenter();

    /**
     * Replace the field "T_SXMShapeTypePressureCenter".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_SXMShapeTypePressureCenter (T_SXMShapeTypePressureCenter* T_SXMShapeTypePressureCenter);

    /**
     * Sets the value of the field "T_SXMShapeTypePressureCenter". A field
     * which was previously set will be cleared.
     *
     * If the meaning of "T_SXMShapeTypePressureCenter" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_SXMShapeTypePressureCenter (const T_SXMShapeTypePressureCenter& value);

    // API of field "T_SXMShapeTypeIsobar"

    static const int kT_SXMShapeTypeIsobar = 3;

    /**
     * Returns true if the field "T_SXMShapeTypeIsobar" has a value.
     *
     * If the meaning of "T_SXMShapeTypeIsobar" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_SXMShapeTypeIsobar", otherwise false
     */
    inline bool hasT_SXMShapeTypeIsobar () const;

    /**
     * Returns the value of field "T_SXMShapeTypeIsobar".It is only valid to
     * call this method if hasT_SXMShapeTypeIsobar() returns true. Otherwise
     * the behavior is not specified.
     *
     * If the meaning of "T_SXMShapeTypeIsobar" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_SXMShapeTypeIsobar& getT_SXMShapeTypeIsobar() const ;

    /**
     * Retrieves the value of the field "T_SXMShapeTypeIsobar" as a mutable
     * object. Any modifications on the returned object will affect the
     * containing object.
     *
     * It is only valid to call this method if isT_SXMShapeTypeIsobar()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline T_SXMShapeTypeIsobar& getT_SXMShapeTypeIsobarMutable();

    /**
     * Release the object stored in the field "T_SXMShapeTypeIsobar".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_SXMShapeTypeIsobar" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_SXMShapeTypeIsobar"
     */
    inline T_SXMShapeTypeIsobar* releaseT_SXMShapeTypeIsobar();

    /**
     * Replace the field "T_SXMShapeTypeIsobar".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_SXMShapeTypeIsobar (T_SXMShapeTypeIsobar* T_SXMShapeTypeIsobar);

    /**
     * Sets the value of the field "T_SXMShapeTypeIsobar". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "T_SXMShapeTypeIsobar" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_SXMShapeTypeIsobar (const T_SXMShapeTypeIsobar& value);

    // API of field "T_SXMShapeTypeStormPosition"

    static const int kT_SXMShapeTypeStormPosition = 4;

    /**
     * Returns true if the field "T_SXMShapeTypeStormPosition" has a value.
     *
     * If the meaning of "T_SXMShapeTypeStormPosition" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_SXMShapeTypeStormPosition", otherwise false
     */
    inline bool hasT_SXMShapeTypeStormPosition () const;

    /**
     * Returns the value of field "T_SXMShapeTypeStormPosition".It is only
     * valid to call this method if hasT_SXMShapeTypeStormPosition() returns
     * true. Otherwise the behavior is not specified.
     *
     * If the meaning of "T_SXMShapeTypeStormPosition" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_SXMShapeTypeStormPosition& getT_SXMShapeTypeStormPosition() const ;

    /**
     * Retrieves the value of the field "T_SXMShapeTypeStormPosition" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if isT_SXMShapeTypeStormPosition()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline T_SXMShapeTypeStormPosition& getT_SXMShapeTypeStormPositionMutable();

    /**
     * Release the object stored in the field "T_SXMShapeTypeStormPosition".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_SXMShapeTypeStormPosition" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_SXMShapeTypeStormPosition"
     */
    inline T_SXMShapeTypeStormPosition* releaseT_SXMShapeTypeStormPosition();

    /**
     * Replace the field "T_SXMShapeTypeStormPosition".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_SXMShapeTypeStormPosition (T_SXMShapeTypeStormPosition* T_SXMShapeTypeStormPosition);

    /**
     * Sets the value of the field "T_SXMShapeTypeStormPosition". A field
     * which was previously set will be cleared.
     *
     * If the meaning of "T_SXMShapeTypeStormPosition" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_SXMShapeTypeStormPosition (const T_SXMShapeTypeStormPosition& value);

    // API of field "T_SXMShapeTypeWindRadius"

    static const int kT_SXMShapeTypeWindRadius = 5;

    /**
     * Returns true if the field "T_SXMShapeTypeWindRadius" has a value.
     *
     * If the meaning of "T_SXMShapeTypeWindRadius" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_SXMShapeTypeWindRadius", otherwise false
     */
    inline bool hasT_SXMShapeTypeWindRadius () const;

    /**
     * Returns the value of field "T_SXMShapeTypeWindRadius".It is only valid
     * to call this method if hasT_SXMShapeTypeWindRadius() returns true.
     * Otherwise the behavior is not specified.
     *
     * If the meaning of "T_SXMShapeTypeWindRadius" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_SXMShapeTypeWindRadius& getT_SXMShapeTypeWindRadius() const ;

    /**
     * Retrieves the value of the field "T_SXMShapeTypeWindRadius" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if isT_SXMShapeTypeWindRadius()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline T_SXMShapeTypeWindRadius& getT_SXMShapeTypeWindRadiusMutable();

    /**
     * Release the object stored in the field "T_SXMShapeTypeWindRadius".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_SXMShapeTypeWindRadius" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_SXMShapeTypeWindRadius"
     */
    inline T_SXMShapeTypeWindRadius* releaseT_SXMShapeTypeWindRadius();

    /**
     * Replace the field "T_SXMShapeTypeWindRadius".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_SXMShapeTypeWindRadius (T_SXMShapeTypeWindRadius* T_SXMShapeTypeWindRadius);

    /**
     * Sets the value of the field "T_SXMShapeTypeWindRadius". A field which
     * was previously set will be cleared.
     *
     * If the meaning of "T_SXMShapeTypeWindRadius" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_SXMShapeTypeWindRadius (const T_SXMShapeTypeWindRadius& value);

    // API of field "T_SXMShapeTypeStormAttributes"

    static const int kT_SXMShapeTypeStormAttributes = 6;

    /**
     * Returns true if the field "T_SXMShapeTypeStormAttributes" has a value.
     *
     * If the meaning of "T_SXMShapeTypeStormAttributes" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_SXMShapeTypeStormAttributes", otherwise false
     */
    inline bool hasT_SXMShapeTypeStormAttributes () const;

    /**
     * Returns the value of field "T_SXMShapeTypeStormAttributes".It is only
     * valid to call this method if hasT_SXMShapeTypeStormAttributes() returns
     * true. Otherwise the behavior is not specified.
     *
     * If the meaning of "T_SXMShapeTypeStormAttributes" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_SXMShapeTypeStormAttributes& getT_SXMShapeTypeStormAttributes() const ;

    /**
     * Retrieves the value of the field "T_SXMShapeTypeStormAttributes" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if
     * isT_SXMShapeTypeStormAttributes() returns true. Otherwise the behavior
     * is not specified.
     *
     * @return The value of the union
     */
    inline T_SXMShapeTypeStormAttributes& getT_SXMShapeTypeStormAttributesMutable();

    /**
     * Release the object stored in the field "T_SXMShapeTypeStormAttributes".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_SXMShapeTypeStormAttributes" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_SXMShapeTypeStormAttributes"
     */
    inline T_SXMShapeTypeStormAttributes* releaseT_SXMShapeTypeStormAttributes();

    /**
     * Replace the field "T_SXMShapeTypeStormAttributes".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_SXMShapeTypeStormAttributes (T_SXMShapeTypeStormAttributes* T_SXMShapeTypeStormAttributes);

    /**
     * Sets the value of the field "T_SXMShapeTypeStormAttributes". A field
     * which was previously set will be cleared.
     *
     * If the meaning of "T_SXMShapeTypeStormAttributes" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_SXMShapeTypeStormAttributes (const T_SXMShapeTypeStormAttributes& value);

    // API of field "T_SXMShapeTypeStormTrack"

    static const int kT_SXMShapeTypeStormTrack = 7;

    /**
     * Returns true if the field "T_SXMShapeTypeStormTrack" has a value.
     *
     * If the meaning of "T_SXMShapeTypeStormTrack" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_SXMShapeTypeStormTrack", otherwise false
     */
    inline bool hasT_SXMShapeTypeStormTrack () const;

    /**
     * Returns the value of field "T_SXMShapeTypeStormTrack".It is only valid
     * to call this method if hasT_SXMShapeTypeStormTrack() returns true.
     * Otherwise the behavior is not specified.
     *
     * If the meaning of "T_SXMShapeTypeStormTrack" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_SXMShapeTypeStormTrack& getT_SXMShapeTypeStormTrack() const ;

    /**
     * Retrieves the value of the field "T_SXMShapeTypeStormTrack" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if isT_SXMShapeTypeStormTrack()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline T_SXMShapeTypeStormTrack& getT_SXMShapeTypeStormTrackMutable();

    /**
     * Release the object stored in the field "T_SXMShapeTypeStormTrack".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_SXMShapeTypeStormTrack" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_SXMShapeTypeStormTrack"
     */
    inline T_SXMShapeTypeStormTrack* releaseT_SXMShapeTypeStormTrack();

    /**
     * Replace the field "T_SXMShapeTypeStormTrack".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_SXMShapeTypeStormTrack (T_SXMShapeTypeStormTrack* T_SXMShapeTypeStormTrack);

    /**
     * Sets the value of the field "T_SXMShapeTypeStormTrack". A field which
     * was previously set will be cleared.
     *
     * If the meaning of "T_SXMShapeTypeStormTrack" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_SXMShapeTypeStormTrack (const T_SXMShapeTypeStormTrack& value);

    static const T_SXMShape &getDefaultInstance();

private:

    inline void cloneData (const T_SXMShape& rhs);

    inline void deleteData ();

    T_SXMShapeField __field;

    union {
        ::fi_types::T_Reserved* T_Reserved_;
        T_SXMShapeTypeFront* T_SXMShapeTypeFront_;
        T_SXMShapeTypePressureCenter* T_SXMShapeTypePressureCenter_;
        T_SXMShapeTypeIsobar* T_SXMShapeTypeIsobar_;
        T_SXMShapeTypeStormPosition* T_SXMShapeTypeStormPosition_;
        T_SXMShapeTypeWindRadius* T_SXMShapeTypeWindRadius_;
        T_SXMShapeTypeStormAttributes* T_SXMShapeTypeStormAttributes_;
        T_SXMShapeTypeStormTrack* T_SXMShapeTypeStormTrack_;
    } _data;

};

inline  T_SXMSharedMemoryDescription::T_SXMSharedMemoryDescription ()  :
    _TileType (::sxm_agw_main_fi_types::T_e8_SXMTileType__T_Reserved),
    _TileDataType (::sxm_agw_main_fi_types::T_e8_SXMTileDataType__T_Reserved),
    _SharedMemoryName (),
    _SharedMemorySize (0u),
    _Timeout (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMSharedMemoryDescription::T_SXMSharedMemoryDescription (const T_SXMSharedMemoryDescription &rhs)  :
    _TileType (::sxm_agw_main_fi_types::T_e8_SXMTileType__T_Reserved),
    _TileDataType (::sxm_agw_main_fi_types::T_e8_SXMTileDataType__T_Reserved),
    _SharedMemoryName (),
    _SharedMemorySize (0u),
    _Timeout (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMSharedMemoryDescription::T_SXMSharedMemoryDescription (T_e8_SXMTileType TileType_, T_e8_SXMTileDataType TileDataType_, const ::std::string& SharedMemoryName_, uint32 SharedMemorySize_, ::fi_types::T_s32_MilliSecond Timeout_)  :
    _TileType (TileType_),
    _TileDataType (TileDataType_),
    _SharedMemoryName (SharedMemoryName_),
    _SharedMemorySize (SharedMemorySize_),
    _Timeout (Timeout_)
{
    #ifndef NDEBUG
    if (!(T_e8_SXMTileType_IsValid(TileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TileType_, "T_e8_SXMTileType", "TileType", "T_SXMSharedMemoryDescription");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SXMTileDataType_IsValid(TileDataType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TileDataType_, "T_e8_SXMTileDataType", "TileDataType", "T_SXMSharedMemoryDescription");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SharedMemoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMSharedMemoryDescription::~T_SXMSharedMemoryDescription() {
}

inline T_SXMSharedMemoryDescription& T_SXMSharedMemoryDescription::operator = (const T_SXMSharedMemoryDescription& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTileType()) {
            setTileType(rhs.getTileType());
        } else {
            clearTileType();
        }
        if (rhs.hasTileDataType()) {
            setTileDataType(rhs.getTileDataType());
        } else {
            clearTileDataType();
        }
        if (rhs.hasSharedMemoryName()) {
            setSharedMemoryName(rhs.getSharedMemoryName());
        } else {
            clearSharedMemoryName();
        }
        if (rhs.hasSharedMemorySize()) {
            setSharedMemorySize(rhs.getSharedMemorySize());
        } else {
            clearSharedMemorySize();
        }
        if (rhs.hasTimeout()) {
            setTimeout(rhs.getTimeout());
        } else {
            clearTimeout();
        }
    }
    return *this;
}

inline bool T_SXMSharedMemoryDescription::operator == (const T_SXMSharedMemoryDescription& rhs) const {
    return (((!hasTileType() && !rhs.hasTileType()) || getTileType() == rhs.getTileType()) &&
        ((!hasTileDataType() && !rhs.hasTileDataType()) || getTileDataType() == rhs.getTileDataType()) &&
        ((!hasSharedMemoryName() && !rhs.hasSharedMemoryName()) || getSharedMemoryName() == rhs.getSharedMemoryName()) &&
        ((!hasSharedMemorySize() && !rhs.hasSharedMemorySize()) || getSharedMemorySize() == rhs.getSharedMemorySize()) &&
        ((!hasTimeout() && !rhs.hasTimeout()) || getTimeout() == rhs.getTimeout()));
}

inline bool T_SXMSharedMemoryDescription::operator != (const T_SXMSharedMemoryDescription& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMSharedMemoryDescription::operator < (const T_SXMSharedMemoryDescription& rhs) const {
    if (hasTileType() || rhs.hasTileType()) {
        if ((uint32)getTileType() < (uint32)rhs.getTileType()) return true;
        if ((uint32)getTileType() > (uint32)rhs.getTileType()) return false;
    }
    if (hasTileDataType() || rhs.hasTileDataType()) {
        if ((uint32)getTileDataType() < (uint32)rhs.getTileDataType()) return true;
        if ((uint32)getTileDataType() > (uint32)rhs.getTileDataType()) return false;
    }
    if (hasSharedMemoryName() || rhs.hasSharedMemoryName()) {
        if (getSharedMemoryName() < rhs.getSharedMemoryName()) return true;
        if (getSharedMemoryName() > rhs.getSharedMemoryName()) return false;
    }
    if (hasSharedMemorySize() || rhs.hasSharedMemorySize()) {
        if (getSharedMemorySize() < rhs.getSharedMemorySize()) return true;
        if (getSharedMemorySize() > rhs.getSharedMemorySize()) return false;
    }
    if (hasTimeout() || rhs.hasTimeout()) {
        if (getTimeout() < rhs.getTimeout()) return true;
        if (getTimeout() > rhs.getTimeout()) return false;
    }
    return false;
}

inline bool T_SXMSharedMemoryDescription::operator > (const T_SXMSharedMemoryDescription& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMSharedMemoryDescription::clear() {
    clearTileType();
    clearTileDataType();
    clearSharedMemoryName();
    clearSharedMemorySize();
    clearTimeout();
}

inline void T_SXMSharedMemoryDescription::clearTileType() {
    if (hasTileType()) {
         clear_has_TileType();
        _TileType = ::sxm_agw_main_fi_types::T_e8_SXMTileType__T_Reserved;
     }
}

inline bool T_SXMSharedMemoryDescription::hasTileType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_SXMTileType T_SXMSharedMemoryDescription::getTileType () const {
    return _TileType;
}

inline void T_SXMSharedMemoryDescription::setTileType (T_e8_SXMTileType TileType_) {
    #ifndef NDEBUG
    if (!(T_e8_SXMTileType_IsValid(TileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TileType_, "T_e8_SXMTileType", "TileType", "T_SXMSharedMemoryDescription");
    }
    #endif
    set_has_TileType();
    this->_TileType = TileType_;
}

inline void T_SXMSharedMemoryDescription::clearTileDataType() {
    if (hasTileDataType()) {
         clear_has_TileDataType();
        _TileDataType = ::sxm_agw_main_fi_types::T_e8_SXMTileDataType__T_Reserved;
     }
}

inline bool T_SXMSharedMemoryDescription::hasTileDataType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_SXMTileDataType T_SXMSharedMemoryDescription::getTileDataType () const {
    return _TileDataType;
}

inline void T_SXMSharedMemoryDescription::setTileDataType (T_e8_SXMTileDataType TileDataType_) {
    #ifndef NDEBUG
    if (!(T_e8_SXMTileDataType_IsValid(TileDataType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TileDataType_, "T_e8_SXMTileDataType", "TileDataType", "T_SXMSharedMemoryDescription");
    }
    #endif
    set_has_TileDataType();
    this->_TileDataType = TileDataType_;
}

inline void T_SXMSharedMemoryDescription::clearSharedMemoryName() {
    if (hasSharedMemoryName()) {
         clear_has_SharedMemoryName();
        _SharedMemoryName.clear();
     }
}

inline bool T_SXMSharedMemoryDescription::hasSharedMemoryName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_SXMSharedMemoryDescription::getSharedMemoryName () const {
    return _SharedMemoryName;
}

inline ::std::string& T_SXMSharedMemoryDescription::getSharedMemoryNameMutable () {
    set_has_SharedMemoryName();
    return _SharedMemoryName;
}

inline void T_SXMSharedMemoryDescription::setSharedMemoryName (const ::std::string& SharedMemoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SharedMemoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SharedMemoryName();
    this->_SharedMemoryName = SharedMemoryName_;
}

inline void T_SXMSharedMemoryDescription::setSharedMemoryName (const char* SharedMemoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SharedMemoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SharedMemoryName();
    this->_SharedMemoryName.assign(SharedMemoryName_);
}

inline void T_SXMSharedMemoryDescription::setSharedMemoryName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SharedMemoryName();
    this->_SharedMemoryName.assign(value, size);
}

inline void T_SXMSharedMemoryDescription::clearSharedMemorySize() {
    if (hasSharedMemorySize()) {
         clear_has_SharedMemorySize();
        _SharedMemorySize = 0u;
     }
}

inline bool T_SXMSharedMemoryDescription::hasSharedMemorySize () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_SXMSharedMemoryDescription::getSharedMemorySize () const {
    return _SharedMemorySize;
}

inline void T_SXMSharedMemoryDescription::setSharedMemorySize (uint32 SharedMemorySize_) {
    set_has_SharedMemorySize();
    this->_SharedMemorySize = SharedMemorySize_;
}

inline void T_SXMSharedMemoryDescription::clearTimeout() {
    if (hasTimeout()) {
         clear_has_Timeout();
        _Timeout = 0;
     }
}

inline bool T_SXMSharedMemoryDescription::hasTimeout () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::fi_types::T_s32_MilliSecond T_SXMSharedMemoryDescription::getTimeout () const {
    return _Timeout;
}

inline void T_SXMSharedMemoryDescription::setTimeout (::fi_types::T_s32_MilliSecond Timeout_) {
    set_has_Timeout();
    this->_Timeout = Timeout_;
}

inline void T_SXMSharedMemoryDescription::set_has_TileType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMSharedMemoryDescription::clear_has_TileType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMSharedMemoryDescription::set_has_TileDataType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMSharedMemoryDescription::clear_has_TileDataType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMSharedMemoryDescription::set_has_SharedMemoryName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMSharedMemoryDescription::clear_has_SharedMemoryName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SXMSharedMemoryDescription::set_has_SharedMemorySize () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SXMSharedMemoryDescription::clear_has_SharedMemorySize () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SXMSharedMemoryDescription::set_has_Timeout () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SXMSharedMemoryDescription::clear_has_Timeout () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_SXMSharedMemoryTile::T_SXMSharedMemoryTile ()  :
    _IssueTime (),
    _UpperLeftCorner (),
    _LowerRightCorner (),
    _Width (0u),
    _Height (0u),
    _PixelValueOffset (0),
    _PixelValuePrecision (0),
    _AddressOffset (0u),
    _TileSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMSharedMemoryTile::T_SXMSharedMemoryTile (const T_SXMSharedMemoryTile &rhs)  :
    _IssueTime (),
    _UpperLeftCorner (),
    _LowerRightCorner (),
    _Width (0u),
    _Height (0u),
    _PixelValueOffset (0),
    _PixelValuePrecision (0),
    _AddressOffset (0u),
    _TileSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMSharedMemoryTile::T_SXMSharedMemoryTile (const ::fi_types::T_POSIXTime& IssueTime_, const ::fi_types::T_PositionWGS84& UpperLeftCorner_, const ::fi_types::T_PositionWGS84& LowerRightCorner_, uint32 Width_, uint32 Height_, int32 PixelValueOffset_, int32 PixelValuePrecision_, uint32 AddressOffset_, uint32 TileSize_)  :
    _IssueTime (IssueTime_),
    _UpperLeftCorner (UpperLeftCorner_),
    _LowerRightCorner (LowerRightCorner_),
    _Width (Width_),
    _Height (Height_),
    _PixelValueOffset (PixelValueOffset_),
    _PixelValuePrecision (PixelValuePrecision_),
    _AddressOffset (AddressOffset_),
    _TileSize (TileSize_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMSharedMemoryTile::~T_SXMSharedMemoryTile() {
}

inline T_SXMSharedMemoryTile& T_SXMSharedMemoryTile::operator = (const T_SXMSharedMemoryTile& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIssueTime()) {
            setIssueTime(rhs.getIssueTime());
        } else {
            clearIssueTime();
        }
        if (rhs.hasUpperLeftCorner()) {
            setUpperLeftCorner(rhs.getUpperLeftCorner());
        } else {
            clearUpperLeftCorner();
        }
        if (rhs.hasLowerRightCorner()) {
            setLowerRightCorner(rhs.getLowerRightCorner());
        } else {
            clearLowerRightCorner();
        }
        if (rhs.hasWidth()) {
            setWidth(rhs.getWidth());
        } else {
            clearWidth();
        }
        if (rhs.hasHeight()) {
            setHeight(rhs.getHeight());
        } else {
            clearHeight();
        }
        if (rhs.hasPixelValueOffset()) {
            setPixelValueOffset(rhs.getPixelValueOffset());
        } else {
            clearPixelValueOffset();
        }
        if (rhs.hasPixelValuePrecision()) {
            setPixelValuePrecision(rhs.getPixelValuePrecision());
        } else {
            clearPixelValuePrecision();
        }
        if (rhs.hasAddressOffset()) {
            setAddressOffset(rhs.getAddressOffset());
        } else {
            clearAddressOffset();
        }
        if (rhs.hasTileSize()) {
            setTileSize(rhs.getTileSize());
        } else {
            clearTileSize();
        }
    }
    return *this;
}

inline bool T_SXMSharedMemoryTile::operator == (const T_SXMSharedMemoryTile& rhs) const {
    return (((!hasIssueTime() && !rhs.hasIssueTime()) || getIssueTime() == rhs.getIssueTime()) &&
        ((!hasUpperLeftCorner() && !rhs.hasUpperLeftCorner()) || getUpperLeftCorner() == rhs.getUpperLeftCorner()) &&
        ((!hasLowerRightCorner() && !rhs.hasLowerRightCorner()) || getLowerRightCorner() == rhs.getLowerRightCorner()) &&
        ((!hasWidth() && !rhs.hasWidth()) || getWidth() == rhs.getWidth()) &&
        ((!hasHeight() && !rhs.hasHeight()) || getHeight() == rhs.getHeight()) &&
        ((!hasPixelValueOffset() && !rhs.hasPixelValueOffset()) || getPixelValueOffset() == rhs.getPixelValueOffset()) &&
        ((!hasPixelValuePrecision() && !rhs.hasPixelValuePrecision()) || getPixelValuePrecision() == rhs.getPixelValuePrecision()) &&
        ((!hasAddressOffset() && !rhs.hasAddressOffset()) || getAddressOffset() == rhs.getAddressOffset()) &&
        ((!hasTileSize() && !rhs.hasTileSize()) || getTileSize() == rhs.getTileSize()));
}

inline bool T_SXMSharedMemoryTile::operator != (const T_SXMSharedMemoryTile& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMSharedMemoryTile::operator < (const T_SXMSharedMemoryTile& rhs) const {
    if (hasIssueTime() || rhs.hasIssueTime()) {
        if (getIssueTime() < rhs.getIssueTime()) return true;
        if (getIssueTime() > rhs.getIssueTime()) return false;
    }
    if (hasUpperLeftCorner() || rhs.hasUpperLeftCorner()) {
        if (getUpperLeftCorner() < rhs.getUpperLeftCorner()) return true;
        if (getUpperLeftCorner() > rhs.getUpperLeftCorner()) return false;
    }
    if (hasLowerRightCorner() || rhs.hasLowerRightCorner()) {
        if (getLowerRightCorner() < rhs.getLowerRightCorner()) return true;
        if (getLowerRightCorner() > rhs.getLowerRightCorner()) return false;
    }
    if (hasWidth() || rhs.hasWidth()) {
        if (getWidth() < rhs.getWidth()) return true;
        if (getWidth() > rhs.getWidth()) return false;
    }
    if (hasHeight() || rhs.hasHeight()) {
        if (getHeight() < rhs.getHeight()) return true;
        if (getHeight() > rhs.getHeight()) return false;
    }
    if (hasPixelValueOffset() || rhs.hasPixelValueOffset()) {
        if (getPixelValueOffset() < rhs.getPixelValueOffset()) return true;
        if (getPixelValueOffset() > rhs.getPixelValueOffset()) return false;
    }
    if (hasPixelValuePrecision() || rhs.hasPixelValuePrecision()) {
        if (getPixelValuePrecision() < rhs.getPixelValuePrecision()) return true;
        if (getPixelValuePrecision() > rhs.getPixelValuePrecision()) return false;
    }
    if (hasAddressOffset() || rhs.hasAddressOffset()) {
        if (getAddressOffset() < rhs.getAddressOffset()) return true;
        if (getAddressOffset() > rhs.getAddressOffset()) return false;
    }
    if (hasTileSize() || rhs.hasTileSize()) {
        if (getTileSize() < rhs.getTileSize()) return true;
        if (getTileSize() > rhs.getTileSize()) return false;
    }
    return false;
}

inline bool T_SXMSharedMemoryTile::operator > (const T_SXMSharedMemoryTile& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMSharedMemoryTile::clear() {
    clearIssueTime();
    clearUpperLeftCorner();
    clearLowerRightCorner();
    clearWidth();
    clearHeight();
    clearPixelValueOffset();
    clearPixelValuePrecision();
    clearAddressOffset();
    clearTileSize();
}

inline void T_SXMSharedMemoryTile::clearIssueTime() {
    if (hasIssueTime()) {
         clear_has_IssueTime();
        _IssueTime.clear();
     }
}

inline bool T_SXMSharedMemoryTile::hasIssueTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_types::T_POSIXTime& T_SXMSharedMemoryTile::getIssueTime () const {
    return _IssueTime;
}

inline ::fi_types::T_POSIXTime& T_SXMSharedMemoryTile::getIssueTimeMutable () {
    set_has_IssueTime();
    return _IssueTime;
}

inline void T_SXMSharedMemoryTile::setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_) {
    set_has_IssueTime();
    this->_IssueTime = IssueTime_;
}

inline void T_SXMSharedMemoryTile::clearUpperLeftCorner() {
    if (hasUpperLeftCorner()) {
         clear_has_UpperLeftCorner();
        _UpperLeftCorner.clear();
     }
}

inline bool T_SXMSharedMemoryTile::hasUpperLeftCorner () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_types::T_PositionWGS84& T_SXMSharedMemoryTile::getUpperLeftCorner () const {
    return _UpperLeftCorner;
}

inline ::fi_types::T_PositionWGS84& T_SXMSharedMemoryTile::getUpperLeftCornerMutable () {
    set_has_UpperLeftCorner();
    return _UpperLeftCorner;
}

inline void T_SXMSharedMemoryTile::setUpperLeftCorner (const ::fi_types::T_PositionWGS84& UpperLeftCorner_) {
    set_has_UpperLeftCorner();
    this->_UpperLeftCorner = UpperLeftCorner_;
}

inline void T_SXMSharedMemoryTile::clearLowerRightCorner() {
    if (hasLowerRightCorner()) {
         clear_has_LowerRightCorner();
        _LowerRightCorner.clear();
     }
}

inline bool T_SXMSharedMemoryTile::hasLowerRightCorner () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_types::T_PositionWGS84& T_SXMSharedMemoryTile::getLowerRightCorner () const {
    return _LowerRightCorner;
}

inline ::fi_types::T_PositionWGS84& T_SXMSharedMemoryTile::getLowerRightCornerMutable () {
    set_has_LowerRightCorner();
    return _LowerRightCorner;
}

inline void T_SXMSharedMemoryTile::setLowerRightCorner (const ::fi_types::T_PositionWGS84& LowerRightCorner_) {
    set_has_LowerRightCorner();
    this->_LowerRightCorner = LowerRightCorner_;
}

inline void T_SXMSharedMemoryTile::clearWidth() {
    if (hasWidth()) {
         clear_has_Width();
        _Width = 0u;
     }
}

inline bool T_SXMSharedMemoryTile::hasWidth () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_SXMSharedMemoryTile::getWidth () const {
    return _Width;
}

inline void T_SXMSharedMemoryTile::setWidth (uint32 Width_) {
    set_has_Width();
    this->_Width = Width_;
}

inline void T_SXMSharedMemoryTile::clearHeight() {
    if (hasHeight()) {
         clear_has_Height();
        _Height = 0u;
     }
}

inline bool T_SXMSharedMemoryTile::hasHeight () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_SXMSharedMemoryTile::getHeight () const {
    return _Height;
}

inline void T_SXMSharedMemoryTile::setHeight (uint32 Height_) {
    set_has_Height();
    this->_Height = Height_;
}

inline void T_SXMSharedMemoryTile::clearPixelValueOffset() {
    if (hasPixelValueOffset()) {
         clear_has_PixelValueOffset();
        _PixelValueOffset = 0;
     }
}

inline bool T_SXMSharedMemoryTile::hasPixelValueOffset () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline int32 T_SXMSharedMemoryTile::getPixelValueOffset () const {
    return _PixelValueOffset;
}

inline void T_SXMSharedMemoryTile::setPixelValueOffset (int32 PixelValueOffset_) {
    set_has_PixelValueOffset();
    this->_PixelValueOffset = PixelValueOffset_;
}

inline void T_SXMSharedMemoryTile::clearPixelValuePrecision() {
    if (hasPixelValuePrecision()) {
         clear_has_PixelValuePrecision();
        _PixelValuePrecision = 0;
     }
}

inline bool T_SXMSharedMemoryTile::hasPixelValuePrecision () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline int32 T_SXMSharedMemoryTile::getPixelValuePrecision () const {
    return _PixelValuePrecision;
}

inline void T_SXMSharedMemoryTile::setPixelValuePrecision (int32 PixelValuePrecision_) {
    set_has_PixelValuePrecision();
    this->_PixelValuePrecision = PixelValuePrecision_;
}

inline void T_SXMSharedMemoryTile::clearAddressOffset() {
    if (hasAddressOffset()) {
         clear_has_AddressOffset();
        _AddressOffset = 0u;
     }
}

inline bool T_SXMSharedMemoryTile::hasAddressOffset () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 T_SXMSharedMemoryTile::getAddressOffset () const {
    return _AddressOffset;
}

inline void T_SXMSharedMemoryTile::setAddressOffset (uint32 AddressOffset_) {
    set_has_AddressOffset();
    this->_AddressOffset = AddressOffset_;
}

inline void T_SXMSharedMemoryTile::clearTileSize() {
    if (hasTileSize()) {
         clear_has_TileSize();
        _TileSize = 0u;
     }
}

inline bool T_SXMSharedMemoryTile::hasTileSize () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 T_SXMSharedMemoryTile::getTileSize () const {
    return _TileSize;
}

inline void T_SXMSharedMemoryTile::setTileSize (uint32 TileSize_) {
    set_has_TileSize();
    this->_TileSize = TileSize_;
}

inline void T_SXMSharedMemoryTile::set_has_IssueTime () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMSharedMemoryTile::clear_has_IssueTime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMSharedMemoryTile::set_has_UpperLeftCorner () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMSharedMemoryTile::clear_has_UpperLeftCorner () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMSharedMemoryTile::set_has_LowerRightCorner () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMSharedMemoryTile::clear_has_LowerRightCorner () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SXMSharedMemoryTile::set_has_Width () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SXMSharedMemoryTile::clear_has_Width () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SXMSharedMemoryTile::set_has_Height () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SXMSharedMemoryTile::clear_has_Height () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SXMSharedMemoryTile::set_has_PixelValueOffset () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SXMSharedMemoryTile::clear_has_PixelValueOffset () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SXMSharedMemoryTile::set_has_PixelValuePrecision () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SXMSharedMemoryTile::clear_has_PixelValuePrecision () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SXMSharedMemoryTile::set_has_AddressOffset () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SXMSharedMemoryTile::clear_has_AddressOffset () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_SXMSharedMemoryTile::set_has_TileSize () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_SXMSharedMemoryTile::clear_has_TileSize () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_SXMShapeTypeFront::T_SXMShapeTypeFront ()  :
    _IssueTime (),
    _FrontType (::sxm_agw_main_fi_types::T_e8_FrontType__Unknown),
    _GeoPoints ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMShapeTypeFront::T_SXMShapeTypeFront (const T_SXMShapeTypeFront &rhs)  :
    _IssueTime (),
    _FrontType (::sxm_agw_main_fi_types::T_e8_FrontType__Unknown),
    _GeoPoints ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMShapeTypeFront::T_SXMShapeTypeFront (const ::fi_types::T_POSIXTime& IssueTime_, T_e8_FrontType FrontType_, const ::std::vector< ::fi_types::T_PositionWGS84 >& GeoPoints_)  :
    _IssueTime (IssueTime_),
    _FrontType (FrontType_),
    _GeoPoints (GeoPoints_)
{
    #ifndef NDEBUG
    if (!(T_e8_FrontType_IsValid(FrontType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FrontType_, "T_e8_FrontType", "FrontType", "T_SXMShapeTypeFront");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMShapeTypeFront::~T_SXMShapeTypeFront() {
}

inline T_SXMShapeTypeFront& T_SXMShapeTypeFront::operator = (const T_SXMShapeTypeFront& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIssueTime()) {
            setIssueTime(rhs.getIssueTime());
        } else {
            clearIssueTime();
        }
        if (rhs.hasFrontType()) {
            setFrontType(rhs.getFrontType());
        } else {
            clearFrontType();
        }
        if (rhs.hasGeoPoints()) {
            setGeoPoints(rhs.getGeoPoints());
        } else {
            clearGeoPoints();
        }
    }
    return *this;
}

inline bool T_SXMShapeTypeFront::operator == (const T_SXMShapeTypeFront& rhs) const {
    return (((!hasIssueTime() && !rhs.hasIssueTime()) || getIssueTime() == rhs.getIssueTime()) &&
        ((!hasFrontType() && !rhs.hasFrontType()) || getFrontType() == rhs.getFrontType()) &&
        ((!hasGeoPoints() && !rhs.hasGeoPoints()) || getGeoPoints() == rhs.getGeoPoints()));
}

inline bool T_SXMShapeTypeFront::operator != (const T_SXMShapeTypeFront& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMShapeTypeFront::operator < (const T_SXMShapeTypeFront& rhs) const {
    if (hasIssueTime() || rhs.hasIssueTime()) {
        if (getIssueTime() < rhs.getIssueTime()) return true;
        if (getIssueTime() > rhs.getIssueTime()) return false;
    }
    if (hasFrontType() || rhs.hasFrontType()) {
        if ((uint32)getFrontType() < (uint32)rhs.getFrontType()) return true;
        if ((uint32)getFrontType() > (uint32)rhs.getFrontType()) return false;
    }
    if (hasGeoPoints() || rhs.hasGeoPoints()) {
        if (getGeoPoints() < rhs.getGeoPoints()) return true;
        if (getGeoPoints() > rhs.getGeoPoints()) return false;
    }
    return false;
}

inline bool T_SXMShapeTypeFront::operator > (const T_SXMShapeTypeFront& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMShapeTypeFront::clear() {
    clearIssueTime();
    clearFrontType();
    clearGeoPoints();
}

inline void T_SXMShapeTypeFront::clearIssueTime() {
    if (hasIssueTime()) {
         clear_has_IssueTime();
        _IssueTime.clear();
     }
}

inline bool T_SXMShapeTypeFront::hasIssueTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_types::T_POSIXTime& T_SXMShapeTypeFront::getIssueTime () const {
    return _IssueTime;
}

inline ::fi_types::T_POSIXTime& T_SXMShapeTypeFront::getIssueTimeMutable () {
    set_has_IssueTime();
    return _IssueTime;
}

inline void T_SXMShapeTypeFront::setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_) {
    set_has_IssueTime();
    this->_IssueTime = IssueTime_;
}

inline void T_SXMShapeTypeFront::clearFrontType() {
    if (hasFrontType()) {
         clear_has_FrontType();
        _FrontType = ::sxm_agw_main_fi_types::T_e8_FrontType__Unknown;
     }
}

inline bool T_SXMShapeTypeFront::hasFrontType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_FrontType T_SXMShapeTypeFront::getFrontType () const {
    return _FrontType;
}

inline void T_SXMShapeTypeFront::setFrontType (T_e8_FrontType FrontType_) {
    #ifndef NDEBUG
    if (!(T_e8_FrontType_IsValid(FrontType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FrontType_, "T_e8_FrontType", "FrontType", "T_SXMShapeTypeFront");
    }
    #endif
    set_has_FrontType();
    this->_FrontType = FrontType_;
}

inline void T_SXMShapeTypeFront::clearGeoPoints() {
    if (hasGeoPoints()) {
         clear_has_GeoPoints();
        _GeoPoints.clear();
     }
}

inline bool T_SXMShapeTypeFront::hasGeoPoints () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< ::fi_types::T_PositionWGS84 >& T_SXMShapeTypeFront::getGeoPoints () const {
    return _GeoPoints;
}

inline ::std::vector< ::fi_types::T_PositionWGS84 >& T_SXMShapeTypeFront::getGeoPointsMutable () {
    set_has_GeoPoints();
    return _GeoPoints;
}

inline void T_SXMShapeTypeFront::setGeoPoints (const ::std::vector< ::fi_types::T_PositionWGS84 >& GeoPoints_) {
    set_has_GeoPoints();
    this->_GeoPoints = GeoPoints_;
}

inline void T_SXMShapeTypeFront::set_has_IssueTime () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMShapeTypeFront::clear_has_IssueTime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMShapeTypeFront::set_has_FrontType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMShapeTypeFront::clear_has_FrontType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMShapeTypeFront::set_has_GeoPoints () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMShapeTypeFront::clear_has_GeoPoints () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SXMShapeTypePressureCenter::T_SXMShapeTypePressureCenter ()  :
    _IssueTime (),
    _PressureType (::sxm_agw_main_fi_types::T_e8_PressureType__Unknown),
    _Pressure (0),
    _GeoPoint ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMShapeTypePressureCenter::T_SXMShapeTypePressureCenter (const T_SXMShapeTypePressureCenter &rhs)  :
    _IssueTime (),
    _PressureType (::sxm_agw_main_fi_types::T_e8_PressureType__Unknown),
    _Pressure (0),
    _GeoPoint ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMShapeTypePressureCenter::T_SXMShapeTypePressureCenter (const ::fi_types::T_POSIXTime& IssueTime_, T_e8_PressureType PressureType_, ::fi_types::T_s32_Pascal Pressure_, const ::fi_types::T_PositionWGS84& GeoPoint_)  :
    _IssueTime (IssueTime_),
    _PressureType (PressureType_),
    _Pressure (Pressure_),
    _GeoPoint (GeoPoint_)
{
    #ifndef NDEBUG
    if (!(T_e8_PressureType_IsValid(PressureType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PressureType_, "T_e8_PressureType", "PressureType", "T_SXMShapeTypePressureCenter");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMShapeTypePressureCenter::~T_SXMShapeTypePressureCenter() {
}

inline T_SXMShapeTypePressureCenter& T_SXMShapeTypePressureCenter::operator = (const T_SXMShapeTypePressureCenter& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIssueTime()) {
            setIssueTime(rhs.getIssueTime());
        } else {
            clearIssueTime();
        }
        if (rhs.hasPressureType()) {
            setPressureType(rhs.getPressureType());
        } else {
            clearPressureType();
        }
        if (rhs.hasPressure()) {
            setPressure(rhs.getPressure());
        } else {
            clearPressure();
        }
        if (rhs.hasGeoPoint()) {
            setGeoPoint(rhs.getGeoPoint());
        } else {
            clearGeoPoint();
        }
    }
    return *this;
}

inline bool T_SXMShapeTypePressureCenter::operator == (const T_SXMShapeTypePressureCenter& rhs) const {
    return (((!hasIssueTime() && !rhs.hasIssueTime()) || getIssueTime() == rhs.getIssueTime()) &&
        ((!hasPressureType() && !rhs.hasPressureType()) || getPressureType() == rhs.getPressureType()) &&
        ((!hasPressure() && !rhs.hasPressure()) || getPressure() == rhs.getPressure()) &&
        ((!hasGeoPoint() && !rhs.hasGeoPoint()) || getGeoPoint() == rhs.getGeoPoint()));
}

inline bool T_SXMShapeTypePressureCenter::operator != (const T_SXMShapeTypePressureCenter& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMShapeTypePressureCenter::operator < (const T_SXMShapeTypePressureCenter& rhs) const {
    if (hasIssueTime() || rhs.hasIssueTime()) {
        if (getIssueTime() < rhs.getIssueTime()) return true;
        if (getIssueTime() > rhs.getIssueTime()) return false;
    }
    if (hasPressureType() || rhs.hasPressureType()) {
        if ((uint32)getPressureType() < (uint32)rhs.getPressureType()) return true;
        if ((uint32)getPressureType() > (uint32)rhs.getPressureType()) return false;
    }
    if (hasPressure() || rhs.hasPressure()) {
        if (getPressure() < rhs.getPressure()) return true;
        if (getPressure() > rhs.getPressure()) return false;
    }
    if (hasGeoPoint() || rhs.hasGeoPoint()) {
        if (getGeoPoint() < rhs.getGeoPoint()) return true;
        if (getGeoPoint() > rhs.getGeoPoint()) return false;
    }
    return false;
}

inline bool T_SXMShapeTypePressureCenter::operator > (const T_SXMShapeTypePressureCenter& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMShapeTypePressureCenter::clear() {
    clearIssueTime();
    clearPressureType();
    clearPressure();
    clearGeoPoint();
}

inline void T_SXMShapeTypePressureCenter::clearIssueTime() {
    if (hasIssueTime()) {
         clear_has_IssueTime();
        _IssueTime.clear();
     }
}

inline bool T_SXMShapeTypePressureCenter::hasIssueTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_types::T_POSIXTime& T_SXMShapeTypePressureCenter::getIssueTime () const {
    return _IssueTime;
}

inline ::fi_types::T_POSIXTime& T_SXMShapeTypePressureCenter::getIssueTimeMutable () {
    set_has_IssueTime();
    return _IssueTime;
}

inline void T_SXMShapeTypePressureCenter::setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_) {
    set_has_IssueTime();
    this->_IssueTime = IssueTime_;
}

inline void T_SXMShapeTypePressureCenter::clearPressureType() {
    if (hasPressureType()) {
         clear_has_PressureType();
        _PressureType = ::sxm_agw_main_fi_types::T_e8_PressureType__Unknown;
     }
}

inline bool T_SXMShapeTypePressureCenter::hasPressureType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_PressureType T_SXMShapeTypePressureCenter::getPressureType () const {
    return _PressureType;
}

inline void T_SXMShapeTypePressureCenter::setPressureType (T_e8_PressureType PressureType_) {
    #ifndef NDEBUG
    if (!(T_e8_PressureType_IsValid(PressureType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PressureType_, "T_e8_PressureType", "PressureType", "T_SXMShapeTypePressureCenter");
    }
    #endif
    set_has_PressureType();
    this->_PressureType = PressureType_;
}

inline void T_SXMShapeTypePressureCenter::clearPressure() {
    if (hasPressure()) {
         clear_has_Pressure();
        _Pressure = 0;
     }
}

inline bool T_SXMShapeTypePressureCenter::hasPressure () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::fi_types::T_s32_Pascal T_SXMShapeTypePressureCenter::getPressure () const {
    return _Pressure;
}

inline void T_SXMShapeTypePressureCenter::setPressure (::fi_types::T_s32_Pascal Pressure_) {
    set_has_Pressure();
    this->_Pressure = Pressure_;
}

inline void T_SXMShapeTypePressureCenter::clearGeoPoint() {
    if (hasGeoPoint()) {
         clear_has_GeoPoint();
        _GeoPoint.clear();
     }
}

inline bool T_SXMShapeTypePressureCenter::hasGeoPoint () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::fi_types::T_PositionWGS84& T_SXMShapeTypePressureCenter::getGeoPoint () const {
    return _GeoPoint;
}

inline ::fi_types::T_PositionWGS84& T_SXMShapeTypePressureCenter::getGeoPointMutable () {
    set_has_GeoPoint();
    return _GeoPoint;
}

inline void T_SXMShapeTypePressureCenter::setGeoPoint (const ::fi_types::T_PositionWGS84& GeoPoint_) {
    set_has_GeoPoint();
    this->_GeoPoint = GeoPoint_;
}

inline void T_SXMShapeTypePressureCenter::set_has_IssueTime () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMShapeTypePressureCenter::clear_has_IssueTime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMShapeTypePressureCenter::set_has_PressureType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMShapeTypePressureCenter::clear_has_PressureType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMShapeTypePressureCenter::set_has_Pressure () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMShapeTypePressureCenter::clear_has_Pressure () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SXMShapeTypePressureCenter::set_has_GeoPoint () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SXMShapeTypePressureCenter::clear_has_GeoPoint () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_SXMShapeTypeIsobar::T_SXMShapeTypeIsobar ()  :
    _IssueTime (),
    _Pressure (0),
    _GeoPoints ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMShapeTypeIsobar::T_SXMShapeTypeIsobar (const T_SXMShapeTypeIsobar &rhs)  :
    _IssueTime (),
    _Pressure (0),
    _GeoPoints ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMShapeTypeIsobar::T_SXMShapeTypeIsobar (const ::fi_types::T_POSIXTime& IssueTime_, ::fi_types::T_s32_Pascal Pressure_, const ::std::vector< ::fi_types::T_PositionWGS84 >& GeoPoints_)  :
    _IssueTime (IssueTime_),
    _Pressure (Pressure_),
    _GeoPoints (GeoPoints_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMShapeTypeIsobar::~T_SXMShapeTypeIsobar() {
}

inline T_SXMShapeTypeIsobar& T_SXMShapeTypeIsobar::operator = (const T_SXMShapeTypeIsobar& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIssueTime()) {
            setIssueTime(rhs.getIssueTime());
        } else {
            clearIssueTime();
        }
        if (rhs.hasPressure()) {
            setPressure(rhs.getPressure());
        } else {
            clearPressure();
        }
        if (rhs.hasGeoPoints()) {
            setGeoPoints(rhs.getGeoPoints());
        } else {
            clearGeoPoints();
        }
    }
    return *this;
}

inline bool T_SXMShapeTypeIsobar::operator == (const T_SXMShapeTypeIsobar& rhs) const {
    return (((!hasIssueTime() && !rhs.hasIssueTime()) || getIssueTime() == rhs.getIssueTime()) &&
        ((!hasPressure() && !rhs.hasPressure()) || getPressure() == rhs.getPressure()) &&
        ((!hasGeoPoints() && !rhs.hasGeoPoints()) || getGeoPoints() == rhs.getGeoPoints()));
}

inline bool T_SXMShapeTypeIsobar::operator != (const T_SXMShapeTypeIsobar& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMShapeTypeIsobar::operator < (const T_SXMShapeTypeIsobar& rhs) const {
    if (hasIssueTime() || rhs.hasIssueTime()) {
        if (getIssueTime() < rhs.getIssueTime()) return true;
        if (getIssueTime() > rhs.getIssueTime()) return false;
    }
    if (hasPressure() || rhs.hasPressure()) {
        if (getPressure() < rhs.getPressure()) return true;
        if (getPressure() > rhs.getPressure()) return false;
    }
    if (hasGeoPoints() || rhs.hasGeoPoints()) {
        if (getGeoPoints() < rhs.getGeoPoints()) return true;
        if (getGeoPoints() > rhs.getGeoPoints()) return false;
    }
    return false;
}

inline bool T_SXMShapeTypeIsobar::operator > (const T_SXMShapeTypeIsobar& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMShapeTypeIsobar::clear() {
    clearIssueTime();
    clearPressure();
    clearGeoPoints();
}

inline void T_SXMShapeTypeIsobar::clearIssueTime() {
    if (hasIssueTime()) {
         clear_has_IssueTime();
        _IssueTime.clear();
     }
}

inline bool T_SXMShapeTypeIsobar::hasIssueTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_types::T_POSIXTime& T_SXMShapeTypeIsobar::getIssueTime () const {
    return _IssueTime;
}

inline ::fi_types::T_POSIXTime& T_SXMShapeTypeIsobar::getIssueTimeMutable () {
    set_has_IssueTime();
    return _IssueTime;
}

inline void T_SXMShapeTypeIsobar::setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_) {
    set_has_IssueTime();
    this->_IssueTime = IssueTime_;
}

inline void T_SXMShapeTypeIsobar::clearPressure() {
    if (hasPressure()) {
         clear_has_Pressure();
        _Pressure = 0;
     }
}

inline bool T_SXMShapeTypeIsobar::hasPressure () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::fi_types::T_s32_Pascal T_SXMShapeTypeIsobar::getPressure () const {
    return _Pressure;
}

inline void T_SXMShapeTypeIsobar::setPressure (::fi_types::T_s32_Pascal Pressure_) {
    set_has_Pressure();
    this->_Pressure = Pressure_;
}

inline void T_SXMShapeTypeIsobar::clearGeoPoints() {
    if (hasGeoPoints()) {
         clear_has_GeoPoints();
        _GeoPoints.clear();
     }
}

inline bool T_SXMShapeTypeIsobar::hasGeoPoints () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< ::fi_types::T_PositionWGS84 >& T_SXMShapeTypeIsobar::getGeoPoints () const {
    return _GeoPoints;
}

inline ::std::vector< ::fi_types::T_PositionWGS84 >& T_SXMShapeTypeIsobar::getGeoPointsMutable () {
    set_has_GeoPoints();
    return _GeoPoints;
}

inline void T_SXMShapeTypeIsobar::setGeoPoints (const ::std::vector< ::fi_types::T_PositionWGS84 >& GeoPoints_) {
    set_has_GeoPoints();
    this->_GeoPoints = GeoPoints_;
}

inline void T_SXMShapeTypeIsobar::set_has_IssueTime () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMShapeTypeIsobar::clear_has_IssueTime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMShapeTypeIsobar::set_has_Pressure () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMShapeTypeIsobar::clear_has_Pressure () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMShapeTypeIsobar::set_has_GeoPoints () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMShapeTypeIsobar::clear_has_GeoPoints () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SXMShapeTypeWindRadius::T_SXMShapeTypeWindRadius ()  :
    _IssueTime (),
    _StormUniqueId (),
    _SequenceId (0u),
    _WindSpeed (0),
    _GeoPoints ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMShapeTypeWindRadius::T_SXMShapeTypeWindRadius (const T_SXMShapeTypeWindRadius &rhs)  :
    _IssueTime (),
    _StormUniqueId (),
    _SequenceId (0u),
    _WindSpeed (0),
    _GeoPoints ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMShapeTypeWindRadius::T_SXMShapeTypeWindRadius (const ::fi_types::T_POSIXTime& IssueTime_, const ::std::string& StormUniqueId_, uint16 SequenceId_, ::fi_types::T_s16_Knot WindSpeed_, const ::std::vector< ::fi_types::T_PositionWGS84 >& GeoPoints_)  :
    _IssueTime (IssueTime_),
    _StormUniqueId (StormUniqueId_),
    _SequenceId (SequenceId_),
    _WindSpeed (WindSpeed_),
    _GeoPoints (GeoPoints_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormUniqueId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMShapeTypeWindRadius::~T_SXMShapeTypeWindRadius() {
}

inline T_SXMShapeTypeWindRadius& T_SXMShapeTypeWindRadius::operator = (const T_SXMShapeTypeWindRadius& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIssueTime()) {
            setIssueTime(rhs.getIssueTime());
        } else {
            clearIssueTime();
        }
        if (rhs.hasStormUniqueId()) {
            setStormUniqueId(rhs.getStormUniqueId());
        } else {
            clearStormUniqueId();
        }
        if (rhs.hasSequenceId()) {
            setSequenceId(rhs.getSequenceId());
        } else {
            clearSequenceId();
        }
        if (rhs.hasWindSpeed()) {
            setWindSpeed(rhs.getWindSpeed());
        } else {
            clearWindSpeed();
        }
        if (rhs.hasGeoPoints()) {
            setGeoPoints(rhs.getGeoPoints());
        } else {
            clearGeoPoints();
        }
    }
    return *this;
}

inline bool T_SXMShapeTypeWindRadius::operator == (const T_SXMShapeTypeWindRadius& rhs) const {
    return (((!hasIssueTime() && !rhs.hasIssueTime()) || getIssueTime() == rhs.getIssueTime()) &&
        ((!hasStormUniqueId() && !rhs.hasStormUniqueId()) || getStormUniqueId() == rhs.getStormUniqueId()) &&
        ((!hasSequenceId() && !rhs.hasSequenceId()) || getSequenceId() == rhs.getSequenceId()) &&
        ((!hasWindSpeed() && !rhs.hasWindSpeed()) || getWindSpeed() == rhs.getWindSpeed()) &&
        ((!hasGeoPoints() && !rhs.hasGeoPoints()) || getGeoPoints() == rhs.getGeoPoints()));
}

inline bool T_SXMShapeTypeWindRadius::operator != (const T_SXMShapeTypeWindRadius& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMShapeTypeWindRadius::operator < (const T_SXMShapeTypeWindRadius& rhs) const {
    if (hasIssueTime() || rhs.hasIssueTime()) {
        if (getIssueTime() < rhs.getIssueTime()) return true;
        if (getIssueTime() > rhs.getIssueTime()) return false;
    }
    if (hasStormUniqueId() || rhs.hasStormUniqueId()) {
        if (getStormUniqueId() < rhs.getStormUniqueId()) return true;
        if (getStormUniqueId() > rhs.getStormUniqueId()) return false;
    }
    if (hasSequenceId() || rhs.hasSequenceId()) {
        if (getSequenceId() < rhs.getSequenceId()) return true;
        if (getSequenceId() > rhs.getSequenceId()) return false;
    }
    if (hasWindSpeed() || rhs.hasWindSpeed()) {
        if (getWindSpeed() < rhs.getWindSpeed()) return true;
        if (getWindSpeed() > rhs.getWindSpeed()) return false;
    }
    if (hasGeoPoints() || rhs.hasGeoPoints()) {
        if (getGeoPoints() < rhs.getGeoPoints()) return true;
        if (getGeoPoints() > rhs.getGeoPoints()) return false;
    }
    return false;
}

inline bool T_SXMShapeTypeWindRadius::operator > (const T_SXMShapeTypeWindRadius& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMShapeTypeWindRadius::clear() {
    clearIssueTime();
    clearStormUniqueId();
    clearSequenceId();
    clearWindSpeed();
    clearGeoPoints();
}

inline void T_SXMShapeTypeWindRadius::clearIssueTime() {
    if (hasIssueTime()) {
         clear_has_IssueTime();
        _IssueTime.clear();
     }
}

inline bool T_SXMShapeTypeWindRadius::hasIssueTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_types::T_POSIXTime& T_SXMShapeTypeWindRadius::getIssueTime () const {
    return _IssueTime;
}

inline ::fi_types::T_POSIXTime& T_SXMShapeTypeWindRadius::getIssueTimeMutable () {
    set_has_IssueTime();
    return _IssueTime;
}

inline void T_SXMShapeTypeWindRadius::setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_) {
    set_has_IssueTime();
    this->_IssueTime = IssueTime_;
}

inline void T_SXMShapeTypeWindRadius::clearStormUniqueId() {
    if (hasStormUniqueId()) {
         clear_has_StormUniqueId();
        _StormUniqueId.clear();
     }
}

inline bool T_SXMShapeTypeWindRadius::hasStormUniqueId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SXMShapeTypeWindRadius::getStormUniqueId () const {
    return _StormUniqueId;
}

inline ::std::string& T_SXMShapeTypeWindRadius::getStormUniqueIdMutable () {
    set_has_StormUniqueId();
    return _StormUniqueId;
}

inline void T_SXMShapeTypeWindRadius::setStormUniqueId (const ::std::string& StormUniqueId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormUniqueId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormUniqueId();
    this->_StormUniqueId = StormUniqueId_;
}

inline void T_SXMShapeTypeWindRadius::setStormUniqueId (const char* StormUniqueId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormUniqueId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormUniqueId();
    this->_StormUniqueId.assign(StormUniqueId_);
}

inline void T_SXMShapeTypeWindRadius::setStormUniqueId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormUniqueId();
    this->_StormUniqueId.assign(value, size);
}

inline void T_SXMShapeTypeWindRadius::clearSequenceId() {
    if (hasSequenceId()) {
         clear_has_SequenceId();
        _SequenceId = 0u;
     }
}

inline bool T_SXMShapeTypeWindRadius::hasSequenceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_SXMShapeTypeWindRadius::getSequenceId () const {
    return _SequenceId;
}

inline void T_SXMShapeTypeWindRadius::setSequenceId (uint16 SequenceId_) {
    set_has_SequenceId();
    this->_SequenceId = SequenceId_;
}

inline void T_SXMShapeTypeWindRadius::clearWindSpeed() {
    if (hasWindSpeed()) {
         clear_has_WindSpeed();
        _WindSpeed = 0;
     }
}

inline bool T_SXMShapeTypeWindRadius::hasWindSpeed () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::fi_types::T_s16_Knot T_SXMShapeTypeWindRadius::getWindSpeed () const {
    return _WindSpeed;
}

inline void T_SXMShapeTypeWindRadius::setWindSpeed (::fi_types::T_s16_Knot WindSpeed_) {
    set_has_WindSpeed();
    this->_WindSpeed = WindSpeed_;
}

inline void T_SXMShapeTypeWindRadius::clearGeoPoints() {
    if (hasGeoPoints()) {
         clear_has_GeoPoints();
        _GeoPoints.clear();
     }
}

inline bool T_SXMShapeTypeWindRadius::hasGeoPoints () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::vector< ::fi_types::T_PositionWGS84 >& T_SXMShapeTypeWindRadius::getGeoPoints () const {
    return _GeoPoints;
}

inline ::std::vector< ::fi_types::T_PositionWGS84 >& T_SXMShapeTypeWindRadius::getGeoPointsMutable () {
    set_has_GeoPoints();
    return _GeoPoints;
}

inline void T_SXMShapeTypeWindRadius::setGeoPoints (const ::std::vector< ::fi_types::T_PositionWGS84 >& GeoPoints_) {
    set_has_GeoPoints();
    this->_GeoPoints = GeoPoints_;
}

inline void T_SXMShapeTypeWindRadius::set_has_IssueTime () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMShapeTypeWindRadius::clear_has_IssueTime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMShapeTypeWindRadius::set_has_StormUniqueId () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMShapeTypeWindRadius::clear_has_StormUniqueId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMShapeTypeWindRadius::set_has_SequenceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMShapeTypeWindRadius::clear_has_SequenceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SXMShapeTypeWindRadius::set_has_WindSpeed () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SXMShapeTypeWindRadius::clear_has_WindSpeed () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SXMShapeTypeWindRadius::set_has_GeoPoints () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SXMShapeTypeWindRadius::clear_has_GeoPoints () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_SXMShapeTypeStormPosition::T_SXMShapeTypeStormPosition ()  :
    _IssueTime (),
    _StormUniqueId (),
    _StormName (),
    _SequenceId (0u),
    _PositionType (::sxm_agw_main_fi_types::T_e8_StormPositionType__Unknown),
    _Direction (0),
    _Speed (0),
    _MaxSustainedWinds (0),
    _Gusts (0),
    _Pressure (0),
    _Timestamp (),
    _StormType (::sxm_agw_main_fi_types::T_e8_StormType__Unknown),
    _GeoPoint (),
    _WindRadii ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMShapeTypeStormPosition::T_SXMShapeTypeStormPosition (const T_SXMShapeTypeStormPosition &rhs)  :
    _IssueTime (),
    _StormUniqueId (),
    _StormName (),
    _SequenceId (0u),
    _PositionType (::sxm_agw_main_fi_types::T_e8_StormPositionType__Unknown),
    _Direction (0),
    _Speed (0),
    _MaxSustainedWinds (0),
    _Gusts (0),
    _Pressure (0),
    _Timestamp (),
    _StormType (::sxm_agw_main_fi_types::T_e8_StormType__Unknown),
    _GeoPoint (),
    _WindRadii ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMShapeTypeStormPosition::T_SXMShapeTypeStormPosition (const ::fi_types::T_POSIXTime& IssueTime_, const ::std::string& StormUniqueId_, const ::std::string& StormName_, uint16 SequenceId_, T_e8_StormPositionType PositionType_, ::fi_types::T_s16_Degree Direction_, ::fi_types::T_s16_Knot Speed_, ::fi_types::T_s16_Knot MaxSustainedWinds_, ::fi_types::T_s16_Knot Gusts_, ::fi_types::T_s32_Pascal Pressure_, const ::fi_types::T_POSIXTime& Timestamp_, T_e8_StormType StormType_, const ::fi_types::T_PositionWGS84& GeoPoint_, const ::std::vector< T_SXMShapeTypeWindRadius >& WindRadii_)  :
    _IssueTime (IssueTime_),
    _StormUniqueId (StormUniqueId_),
    _StormName (StormName_),
    _SequenceId (SequenceId_),
    _PositionType (PositionType_),
    _Direction (Direction_),
    _Speed (Speed_),
    _MaxSustainedWinds (MaxSustainedWinds_),
    _Gusts (Gusts_),
    _Pressure (Pressure_),
    _Timestamp (Timestamp_),
    _StormType (StormType_),
    _GeoPoint (GeoPoint_),
    _WindRadii (WindRadii_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormUniqueId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_StormPositionType_IsValid(PositionType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PositionType_, "T_e8_StormPositionType", "PositionType", "T_SXMShapeTypeStormPosition");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_StormType_IsValid(StormType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StormType_, "T_e8_StormType", "StormType", "T_SXMShapeTypeStormPosition");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMShapeTypeStormPosition::~T_SXMShapeTypeStormPosition() {
}

inline T_SXMShapeTypeStormPosition& T_SXMShapeTypeStormPosition::operator = (const T_SXMShapeTypeStormPosition& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIssueTime()) {
            setIssueTime(rhs.getIssueTime());
        } else {
            clearIssueTime();
        }
        if (rhs.hasStormUniqueId()) {
            setStormUniqueId(rhs.getStormUniqueId());
        } else {
            clearStormUniqueId();
        }
        if (rhs.hasStormName()) {
            setStormName(rhs.getStormName());
        } else {
            clearStormName();
        }
        if (rhs.hasSequenceId()) {
            setSequenceId(rhs.getSequenceId());
        } else {
            clearSequenceId();
        }
        if (rhs.hasPositionType()) {
            setPositionType(rhs.getPositionType());
        } else {
            clearPositionType();
        }
        if (rhs.hasDirection()) {
            setDirection(rhs.getDirection());
        } else {
            clearDirection();
        }
        if (rhs.hasSpeed()) {
            setSpeed(rhs.getSpeed());
        } else {
            clearSpeed();
        }
        if (rhs.hasMaxSustainedWinds()) {
            setMaxSustainedWinds(rhs.getMaxSustainedWinds());
        } else {
            clearMaxSustainedWinds();
        }
        if (rhs.hasGusts()) {
            setGusts(rhs.getGusts());
        } else {
            clearGusts();
        }
        if (rhs.hasPressure()) {
            setPressure(rhs.getPressure());
        } else {
            clearPressure();
        }
        if (rhs.hasTimestamp()) {
            setTimestamp(rhs.getTimestamp());
        } else {
            clearTimestamp();
        }
        if (rhs.hasStormType()) {
            setStormType(rhs.getStormType());
        } else {
            clearStormType();
        }
        if (rhs.hasGeoPoint()) {
            setGeoPoint(rhs.getGeoPoint());
        } else {
            clearGeoPoint();
        }
        if (rhs.hasWindRadii()) {
            setWindRadii(rhs.getWindRadii());
        } else {
            clearWindRadii();
        }
    }
    return *this;
}

inline bool T_SXMShapeTypeStormPosition::operator == (const T_SXMShapeTypeStormPosition& rhs) const {
    return (((!hasIssueTime() && !rhs.hasIssueTime()) || getIssueTime() == rhs.getIssueTime()) &&
        ((!hasStormUniqueId() && !rhs.hasStormUniqueId()) || getStormUniqueId() == rhs.getStormUniqueId()) &&
        ((!hasStormName() && !rhs.hasStormName()) || getStormName() == rhs.getStormName()) &&
        ((!hasSequenceId() && !rhs.hasSequenceId()) || getSequenceId() == rhs.getSequenceId()) &&
        ((!hasPositionType() && !rhs.hasPositionType()) || getPositionType() == rhs.getPositionType()) &&
        ((!hasDirection() && !rhs.hasDirection()) || getDirection() == rhs.getDirection()) &&
        ((!hasSpeed() && !rhs.hasSpeed()) || getSpeed() == rhs.getSpeed()) &&
        ((!hasMaxSustainedWinds() && !rhs.hasMaxSustainedWinds()) || getMaxSustainedWinds() == rhs.getMaxSustainedWinds()) &&
        ((!hasGusts() && !rhs.hasGusts()) || getGusts() == rhs.getGusts()) &&
        ((!hasPressure() && !rhs.hasPressure()) || getPressure() == rhs.getPressure()) &&
        ((!hasTimestamp() && !rhs.hasTimestamp()) || getTimestamp() == rhs.getTimestamp()) &&
        ((!hasStormType() && !rhs.hasStormType()) || getStormType() == rhs.getStormType()) &&
        ((!hasGeoPoint() && !rhs.hasGeoPoint()) || getGeoPoint() == rhs.getGeoPoint()) &&
        ((!hasWindRadii() && !rhs.hasWindRadii()) || getWindRadii() == rhs.getWindRadii()));
}

inline bool T_SXMShapeTypeStormPosition::operator != (const T_SXMShapeTypeStormPosition& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMShapeTypeStormPosition::operator < (const T_SXMShapeTypeStormPosition& rhs) const {
    if (hasIssueTime() || rhs.hasIssueTime()) {
        if (getIssueTime() < rhs.getIssueTime()) return true;
        if (getIssueTime() > rhs.getIssueTime()) return false;
    }
    if (hasStormUniqueId() || rhs.hasStormUniqueId()) {
        if (getStormUniqueId() < rhs.getStormUniqueId()) return true;
        if (getStormUniqueId() > rhs.getStormUniqueId()) return false;
    }
    if (hasStormName() || rhs.hasStormName()) {
        if (getStormName() < rhs.getStormName()) return true;
        if (getStormName() > rhs.getStormName()) return false;
    }
    if (hasSequenceId() || rhs.hasSequenceId()) {
        if (getSequenceId() < rhs.getSequenceId()) return true;
        if (getSequenceId() > rhs.getSequenceId()) return false;
    }
    if (hasPositionType() || rhs.hasPositionType()) {
        if ((uint32)getPositionType() < (uint32)rhs.getPositionType()) return true;
        if ((uint32)getPositionType() > (uint32)rhs.getPositionType()) return false;
    }
    if (hasDirection() || rhs.hasDirection()) {
        if (getDirection() < rhs.getDirection()) return true;
        if (getDirection() > rhs.getDirection()) return false;
    }
    if (hasSpeed() || rhs.hasSpeed()) {
        if (getSpeed() < rhs.getSpeed()) return true;
        if (getSpeed() > rhs.getSpeed()) return false;
    }
    if (hasMaxSustainedWinds() || rhs.hasMaxSustainedWinds()) {
        if (getMaxSustainedWinds() < rhs.getMaxSustainedWinds()) return true;
        if (getMaxSustainedWinds() > rhs.getMaxSustainedWinds()) return false;
    }
    if (hasGusts() || rhs.hasGusts()) {
        if (getGusts() < rhs.getGusts()) return true;
        if (getGusts() > rhs.getGusts()) return false;
    }
    if (hasPressure() || rhs.hasPressure()) {
        if (getPressure() < rhs.getPressure()) return true;
        if (getPressure() > rhs.getPressure()) return false;
    }
    if (hasTimestamp() || rhs.hasTimestamp()) {
        if (getTimestamp() < rhs.getTimestamp()) return true;
        if (getTimestamp() > rhs.getTimestamp()) return false;
    }
    if (hasStormType() || rhs.hasStormType()) {
        if ((uint32)getStormType() < (uint32)rhs.getStormType()) return true;
        if ((uint32)getStormType() > (uint32)rhs.getStormType()) return false;
    }
    if (hasGeoPoint() || rhs.hasGeoPoint()) {
        if (getGeoPoint() < rhs.getGeoPoint()) return true;
        if (getGeoPoint() > rhs.getGeoPoint()) return false;
    }
    if (hasWindRadii() || rhs.hasWindRadii()) {
        if (getWindRadii() < rhs.getWindRadii()) return true;
        if (getWindRadii() > rhs.getWindRadii()) return false;
    }
    return false;
}

inline bool T_SXMShapeTypeStormPosition::operator > (const T_SXMShapeTypeStormPosition& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMShapeTypeStormPosition::clear() {
    clearIssueTime();
    clearStormUniqueId();
    clearStormName();
    clearSequenceId();
    clearPositionType();
    clearDirection();
    clearSpeed();
    clearMaxSustainedWinds();
    clearGusts();
    clearPressure();
    clearTimestamp();
    clearStormType();
    clearGeoPoint();
    clearWindRadii();
}

inline void T_SXMShapeTypeStormPosition::clearIssueTime() {
    if (hasIssueTime()) {
         clear_has_IssueTime();
        _IssueTime.clear();
     }
}

inline bool T_SXMShapeTypeStormPosition::hasIssueTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_types::T_POSIXTime& T_SXMShapeTypeStormPosition::getIssueTime () const {
    return _IssueTime;
}

inline ::fi_types::T_POSIXTime& T_SXMShapeTypeStormPosition::getIssueTimeMutable () {
    set_has_IssueTime();
    return _IssueTime;
}

inline void T_SXMShapeTypeStormPosition::setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_) {
    set_has_IssueTime();
    this->_IssueTime = IssueTime_;
}

inline void T_SXMShapeTypeStormPosition::clearStormUniqueId() {
    if (hasStormUniqueId()) {
         clear_has_StormUniqueId();
        _StormUniqueId.clear();
     }
}

inline bool T_SXMShapeTypeStormPosition::hasStormUniqueId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SXMShapeTypeStormPosition::getStormUniqueId () const {
    return _StormUniqueId;
}

inline ::std::string& T_SXMShapeTypeStormPosition::getStormUniqueIdMutable () {
    set_has_StormUniqueId();
    return _StormUniqueId;
}

inline void T_SXMShapeTypeStormPosition::setStormUniqueId (const ::std::string& StormUniqueId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormUniqueId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormUniqueId();
    this->_StormUniqueId = StormUniqueId_;
}

inline void T_SXMShapeTypeStormPosition::setStormUniqueId (const char* StormUniqueId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormUniqueId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormUniqueId();
    this->_StormUniqueId.assign(StormUniqueId_);
}

inline void T_SXMShapeTypeStormPosition::setStormUniqueId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormUniqueId();
    this->_StormUniqueId.assign(value, size);
}

inline void T_SXMShapeTypeStormPosition::clearStormName() {
    if (hasStormName()) {
         clear_has_StormName();
        _StormName.clear();
     }
}

inline bool T_SXMShapeTypeStormPosition::hasStormName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_SXMShapeTypeStormPosition::getStormName () const {
    return _StormName;
}

inline ::std::string& T_SXMShapeTypeStormPosition::getStormNameMutable () {
    set_has_StormName();
    return _StormName;
}

inline void T_SXMShapeTypeStormPosition::setStormName (const ::std::string& StormName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormName();
    this->_StormName = StormName_;
}

inline void T_SXMShapeTypeStormPosition::setStormName (const char* StormName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormName();
    this->_StormName.assign(StormName_);
}

inline void T_SXMShapeTypeStormPosition::setStormName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormName();
    this->_StormName.assign(value, size);
}

inline void T_SXMShapeTypeStormPosition::clearSequenceId() {
    if (hasSequenceId()) {
         clear_has_SequenceId();
        _SequenceId = 0u;
     }
}

inline bool T_SXMShapeTypeStormPosition::hasSequenceId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_SXMShapeTypeStormPosition::getSequenceId () const {
    return _SequenceId;
}

inline void T_SXMShapeTypeStormPosition::setSequenceId (uint16 SequenceId_) {
    set_has_SequenceId();
    this->_SequenceId = SequenceId_;
}

inline void T_SXMShapeTypeStormPosition::clearPositionType() {
    if (hasPositionType()) {
         clear_has_PositionType();
        _PositionType = ::sxm_agw_main_fi_types::T_e8_StormPositionType__Unknown;
     }
}

inline bool T_SXMShapeTypeStormPosition::hasPositionType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_StormPositionType T_SXMShapeTypeStormPosition::getPositionType () const {
    return _PositionType;
}

inline void T_SXMShapeTypeStormPosition::setPositionType (T_e8_StormPositionType PositionType_) {
    #ifndef NDEBUG
    if (!(T_e8_StormPositionType_IsValid(PositionType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PositionType_, "T_e8_StormPositionType", "PositionType", "T_SXMShapeTypeStormPosition");
    }
    #endif
    set_has_PositionType();
    this->_PositionType = PositionType_;
}

inline void T_SXMShapeTypeStormPosition::clearDirection() {
    if (hasDirection()) {
         clear_has_Direction();
        _Direction = 0;
     }
}

inline bool T_SXMShapeTypeStormPosition::hasDirection () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline ::fi_types::T_s16_Degree T_SXMShapeTypeStormPosition::getDirection () const {
    return _Direction;
}

inline void T_SXMShapeTypeStormPosition::setDirection (::fi_types::T_s16_Degree Direction_) {
    set_has_Direction();
    this->_Direction = Direction_;
}

inline void T_SXMShapeTypeStormPosition::clearSpeed() {
    if (hasSpeed()) {
         clear_has_Speed();
        _Speed = 0;
     }
}

inline bool T_SXMShapeTypeStormPosition::hasSpeed () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline ::fi_types::T_s16_Knot T_SXMShapeTypeStormPosition::getSpeed () const {
    return _Speed;
}

inline void T_SXMShapeTypeStormPosition::setSpeed (::fi_types::T_s16_Knot Speed_) {
    set_has_Speed();
    this->_Speed = Speed_;
}

inline void T_SXMShapeTypeStormPosition::clearMaxSustainedWinds() {
    if (hasMaxSustainedWinds()) {
         clear_has_MaxSustainedWinds();
        _MaxSustainedWinds = 0;
     }
}

inline bool T_SXMShapeTypeStormPosition::hasMaxSustainedWinds () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline ::fi_types::T_s16_Knot T_SXMShapeTypeStormPosition::getMaxSustainedWinds () const {
    return _MaxSustainedWinds;
}

inline void T_SXMShapeTypeStormPosition::setMaxSustainedWinds (::fi_types::T_s16_Knot MaxSustainedWinds_) {
    set_has_MaxSustainedWinds();
    this->_MaxSustainedWinds = MaxSustainedWinds_;
}

inline void T_SXMShapeTypeStormPosition::clearGusts() {
    if (hasGusts()) {
         clear_has_Gusts();
        _Gusts = 0;
     }
}

inline bool T_SXMShapeTypeStormPosition::hasGusts () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline ::fi_types::T_s16_Knot T_SXMShapeTypeStormPosition::getGusts () const {
    return _Gusts;
}

inline void T_SXMShapeTypeStormPosition::setGusts (::fi_types::T_s16_Knot Gusts_) {
    set_has_Gusts();
    this->_Gusts = Gusts_;
}

inline void T_SXMShapeTypeStormPosition::clearPressure() {
    if (hasPressure()) {
         clear_has_Pressure();
        _Pressure = 0;
     }
}

inline bool T_SXMShapeTypeStormPosition::hasPressure () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline ::fi_types::T_s32_Pascal T_SXMShapeTypeStormPosition::getPressure () const {
    return _Pressure;
}

inline void T_SXMShapeTypeStormPosition::setPressure (::fi_types::T_s32_Pascal Pressure_) {
    set_has_Pressure();
    this->_Pressure = Pressure_;
}

inline void T_SXMShapeTypeStormPosition::clearTimestamp() {
    if (hasTimestamp()) {
         clear_has_Timestamp();
        _Timestamp.clear();
     }
}

inline bool T_SXMShapeTypeStormPosition::hasTimestamp () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::fi_types::T_POSIXTime& T_SXMShapeTypeStormPosition::getTimestamp () const {
    return _Timestamp;
}

inline ::fi_types::T_POSIXTime& T_SXMShapeTypeStormPosition::getTimestampMutable () {
    set_has_Timestamp();
    return _Timestamp;
}

inline void T_SXMShapeTypeStormPosition::setTimestamp (const ::fi_types::T_POSIXTime& Timestamp_) {
    set_has_Timestamp();
    this->_Timestamp = Timestamp_;
}

inline void T_SXMShapeTypeStormPosition::clearStormType() {
    if (hasStormType()) {
         clear_has_StormType();
        _StormType = ::sxm_agw_main_fi_types::T_e8_StormType__Unknown;
     }
}

inline bool T_SXMShapeTypeStormPosition::hasStormType () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline T_e8_StormType T_SXMShapeTypeStormPosition::getStormType () const {
    return _StormType;
}

inline void T_SXMShapeTypeStormPosition::setStormType (T_e8_StormType StormType_) {
    #ifndef NDEBUG
    if (!(T_e8_StormType_IsValid(StormType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StormType_, "T_e8_StormType", "StormType", "T_SXMShapeTypeStormPosition");
    }
    #endif
    set_has_StormType();
    this->_StormType = StormType_;
}

inline void T_SXMShapeTypeStormPosition::clearGeoPoint() {
    if (hasGeoPoint()) {
         clear_has_GeoPoint();
        _GeoPoint.clear();
     }
}

inline bool T_SXMShapeTypeStormPosition::hasGeoPoint () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::fi_types::T_PositionWGS84& T_SXMShapeTypeStormPosition::getGeoPoint () const {
    return _GeoPoint;
}

inline ::fi_types::T_PositionWGS84& T_SXMShapeTypeStormPosition::getGeoPointMutable () {
    set_has_GeoPoint();
    return _GeoPoint;
}

inline void T_SXMShapeTypeStormPosition::setGeoPoint (const ::fi_types::T_PositionWGS84& GeoPoint_) {
    set_has_GeoPoint();
    this->_GeoPoint = GeoPoint_;
}

inline void T_SXMShapeTypeStormPosition::clearWindRadii() {
    if (hasWindRadii()) {
         clear_has_WindRadii();
        _WindRadii.clear();
     }
}

inline bool T_SXMShapeTypeStormPosition::hasWindRadii () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline const ::std::vector< T_SXMShapeTypeWindRadius >& T_SXMShapeTypeStormPosition::getWindRadii () const {
    return _WindRadii;
}

inline ::std::vector< T_SXMShapeTypeWindRadius >& T_SXMShapeTypeStormPosition::getWindRadiiMutable () {
    set_has_WindRadii();
    return _WindRadii;
}

inline void T_SXMShapeTypeStormPosition::setWindRadii (const ::std::vector< T_SXMShapeTypeWindRadius >& WindRadii_) {
    set_has_WindRadii();
    this->_WindRadii = WindRadii_;
}

inline void T_SXMShapeTypeStormPosition::set_has_IssueTime () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMShapeTypeStormPosition::clear_has_IssueTime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMShapeTypeStormPosition::set_has_StormUniqueId () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMShapeTypeStormPosition::clear_has_StormUniqueId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMShapeTypeStormPosition::set_has_StormName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMShapeTypeStormPosition::clear_has_StormName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SXMShapeTypeStormPosition::set_has_SequenceId () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SXMShapeTypeStormPosition::clear_has_SequenceId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SXMShapeTypeStormPosition::set_has_PositionType () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SXMShapeTypeStormPosition::clear_has_PositionType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SXMShapeTypeStormPosition::set_has_Direction () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SXMShapeTypeStormPosition::clear_has_Direction () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SXMShapeTypeStormPosition::set_has_Speed () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SXMShapeTypeStormPosition::clear_has_Speed () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SXMShapeTypeStormPosition::set_has_MaxSustainedWinds () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SXMShapeTypeStormPosition::clear_has_MaxSustainedWinds () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_SXMShapeTypeStormPosition::set_has_Gusts () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_SXMShapeTypeStormPosition::clear_has_Gusts () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_SXMShapeTypeStormPosition::set_has_Pressure () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_SXMShapeTypeStormPosition::clear_has_Pressure () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_SXMShapeTypeStormPosition::set_has_Timestamp () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_SXMShapeTypeStormPosition::clear_has_Timestamp () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_SXMShapeTypeStormPosition::set_has_StormType () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_SXMShapeTypeStormPosition::clear_has_StormType () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_SXMShapeTypeStormPosition::set_has_GeoPoint () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_SXMShapeTypeStormPosition::clear_has_GeoPoint () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_SXMShapeTypeStormPosition::set_has_WindRadii () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_SXMShapeTypeStormPosition::clear_has_WindRadii () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline  T_b8_StormType::T_b8_StormType ()  :
    _HailProbable (false),
    _HailPositive (false),
    _Mesocyclonic (false),
    _Tornadic (false)
{
}

inline  T_b8_StormType::T_b8_StormType (const T_b8_StormType &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_StormType::T_b8_StormType (bool HailProbable, bool HailPositive, bool Mesocyclonic, bool Tornadic) :
    _HailProbable (HailProbable),
    _HailPositive (HailPositive),
    _Mesocyclonic (Mesocyclonic),
    _Tornadic (Tornadic)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_StormType& T_b8_StormType::operator = (const T_b8_StormType& rhs) {
    if( this != &rhs ) {
        _HailProbable = rhs._HailProbable;
        _HailPositive = rhs._HailPositive;
        _Mesocyclonic = rhs._Mesocyclonic;
        _Tornadic = rhs._Tornadic;
    }
    return *this;
}

inline bool T_b8_StormType::operator == (const T_b8_StormType& rhs) const {
    return (_HailProbable == rhs._HailProbable &&
        _HailPositive == rhs._HailPositive &&
        _Mesocyclonic == rhs._Mesocyclonic &&
        _Tornadic == rhs._Tornadic);
}

inline bool T_b8_StormType::operator != (const T_b8_StormType& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_StormType::operator < (const T_b8_StormType& rhs) const {
    if (getHailProbable() < rhs.getHailProbable()) return true;
    if (getHailProbable() > rhs.getHailProbable()) return false;

    if (getHailPositive() < rhs.getHailPositive()) return true;
    if (getHailPositive() > rhs.getHailPositive()) return false;

    if (getMesocyclonic() < rhs.getMesocyclonic()) return true;
    if (getMesocyclonic() > rhs.getMesocyclonic()) return false;

    if (getTornadic() < rhs.getTornadic()) return true;
    if (getTornadic() > rhs.getTornadic()) return false;

    return false;
}

inline bool T_b8_StormType::operator > (const T_b8_StormType& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_StormType::setHailProbable (bool HailProbable) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_HailProbable = HailProbable;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_StormType::getHailProbable () const {
    return _HailProbable;
}

inline void T_b8_StormType::setHailPositive (bool HailPositive) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_HailPositive = HailPositive;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_StormType::getHailPositive () const {
    return _HailPositive;
}

inline void T_b8_StormType::setMesocyclonic (bool Mesocyclonic) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_Mesocyclonic = Mesocyclonic;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_StormType::getMesocyclonic () const {
    return _Mesocyclonic;
}

inline void T_b8_StormType::setTornadic (bool Tornadic) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_Tornadic = Tornadic;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_StormType::getTornadic () const {
    return _Tornadic;
}

inline  T_SXMShapeTypeStormAttributes::T_SXMShapeTypeStormAttributes ()  :
    _IssueTime (),
    _StormUniqueId (),
    _ObservationTime (),
    _EchoTopHeight (0),
    _MovementDirection (0),
    _MovementSpeed (0),
    _StormType (),
    _GeoPoint ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMShapeTypeStormAttributes::T_SXMShapeTypeStormAttributes (const T_SXMShapeTypeStormAttributes &rhs)  :
    _IssueTime (),
    _StormUniqueId (),
    _ObservationTime (),
    _EchoTopHeight (0),
    _MovementDirection (0),
    _MovementSpeed (0),
    _StormType (),
    _GeoPoint ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMShapeTypeStormAttributes::T_SXMShapeTypeStormAttributes (const ::fi_types::T_POSIXTime& IssueTime_, const ::std::string& StormUniqueId_, const ::fi_types::T_POSIXTime& ObservationTime_, ::fi_types::T_s32_Foot EchoTopHeight_, ::fi_types::T_s16_Degree MovementDirection_, ::fi_types::T_s16_Knot MovementSpeed_, const T_b8_StormType& StormType_, const ::fi_types::T_PositionWGS84& GeoPoint_)  :
    _IssueTime (IssueTime_),
    _StormUniqueId (StormUniqueId_),
    _ObservationTime (ObservationTime_),
    _EchoTopHeight (EchoTopHeight_),
    _MovementDirection (MovementDirection_),
    _MovementSpeed (MovementSpeed_),
    _StormType (StormType_),
    _GeoPoint (GeoPoint_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormUniqueId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMShapeTypeStormAttributes::~T_SXMShapeTypeStormAttributes() {
}

inline T_SXMShapeTypeStormAttributes& T_SXMShapeTypeStormAttributes::operator = (const T_SXMShapeTypeStormAttributes& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIssueTime()) {
            setIssueTime(rhs.getIssueTime());
        } else {
            clearIssueTime();
        }
        if (rhs.hasStormUniqueId()) {
            setStormUniqueId(rhs.getStormUniqueId());
        } else {
            clearStormUniqueId();
        }
        if (rhs.hasObservationTime()) {
            setObservationTime(rhs.getObservationTime());
        } else {
            clearObservationTime();
        }
        if (rhs.hasEchoTopHeight()) {
            setEchoTopHeight(rhs.getEchoTopHeight());
        } else {
            clearEchoTopHeight();
        }
        if (rhs.hasMovementDirection()) {
            setMovementDirection(rhs.getMovementDirection());
        } else {
            clearMovementDirection();
        }
        if (rhs.hasMovementSpeed()) {
            setMovementSpeed(rhs.getMovementSpeed());
        } else {
            clearMovementSpeed();
        }
        if (rhs.hasStormType()) {
            setStormType(rhs.getStormType());
        } else {
            clearStormType();
        }
        if (rhs.hasGeoPoint()) {
            setGeoPoint(rhs.getGeoPoint());
        } else {
            clearGeoPoint();
        }
    }
    return *this;
}

inline bool T_SXMShapeTypeStormAttributes::operator == (const T_SXMShapeTypeStormAttributes& rhs) const {
    return (((!hasIssueTime() && !rhs.hasIssueTime()) || getIssueTime() == rhs.getIssueTime()) &&
        ((!hasStormUniqueId() && !rhs.hasStormUniqueId()) || getStormUniqueId() == rhs.getStormUniqueId()) &&
        ((!hasObservationTime() && !rhs.hasObservationTime()) || getObservationTime() == rhs.getObservationTime()) &&
        ((!hasEchoTopHeight() && !rhs.hasEchoTopHeight()) || getEchoTopHeight() == rhs.getEchoTopHeight()) &&
        ((!hasMovementDirection() && !rhs.hasMovementDirection()) || getMovementDirection() == rhs.getMovementDirection()) &&
        ((!hasMovementSpeed() && !rhs.hasMovementSpeed()) || getMovementSpeed() == rhs.getMovementSpeed()) &&
        ((!hasStormType() && !rhs.hasStormType()) || getStormType() == rhs.getStormType()) &&
        ((!hasGeoPoint() && !rhs.hasGeoPoint()) || getGeoPoint() == rhs.getGeoPoint()));
}

inline bool T_SXMShapeTypeStormAttributes::operator != (const T_SXMShapeTypeStormAttributes& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMShapeTypeStormAttributes::operator < (const T_SXMShapeTypeStormAttributes& rhs) const {
    if (hasIssueTime() || rhs.hasIssueTime()) {
        if (getIssueTime() < rhs.getIssueTime()) return true;
        if (getIssueTime() > rhs.getIssueTime()) return false;
    }
    if (hasStormUniqueId() || rhs.hasStormUniqueId()) {
        if (getStormUniqueId() < rhs.getStormUniqueId()) return true;
        if (getStormUniqueId() > rhs.getStormUniqueId()) return false;
    }
    if (hasObservationTime() || rhs.hasObservationTime()) {
        if (getObservationTime() < rhs.getObservationTime()) return true;
        if (getObservationTime() > rhs.getObservationTime()) return false;
    }
    if (hasEchoTopHeight() || rhs.hasEchoTopHeight()) {
        if (getEchoTopHeight() < rhs.getEchoTopHeight()) return true;
        if (getEchoTopHeight() > rhs.getEchoTopHeight()) return false;
    }
    if (hasMovementDirection() || rhs.hasMovementDirection()) {
        if (getMovementDirection() < rhs.getMovementDirection()) return true;
        if (getMovementDirection() > rhs.getMovementDirection()) return false;
    }
    if (hasMovementSpeed() || rhs.hasMovementSpeed()) {
        if (getMovementSpeed() < rhs.getMovementSpeed()) return true;
        if (getMovementSpeed() > rhs.getMovementSpeed()) return false;
    }
    if (hasStormType() || rhs.hasStormType()) {
        if (getStormType() < rhs.getStormType()) return true;
        if (getStormType() > rhs.getStormType()) return false;
    }
    if (hasGeoPoint() || rhs.hasGeoPoint()) {
        if (getGeoPoint() < rhs.getGeoPoint()) return true;
        if (getGeoPoint() > rhs.getGeoPoint()) return false;
    }
    return false;
}

inline bool T_SXMShapeTypeStormAttributes::operator > (const T_SXMShapeTypeStormAttributes& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMShapeTypeStormAttributes::clear() {
    clearIssueTime();
    clearStormUniqueId();
    clearObservationTime();
    clearEchoTopHeight();
    clearMovementDirection();
    clearMovementSpeed();
    clearStormType();
    clearGeoPoint();
}

inline void T_SXMShapeTypeStormAttributes::clearIssueTime() {
    if (hasIssueTime()) {
         clear_has_IssueTime();
        _IssueTime.clear();
     }
}

inline bool T_SXMShapeTypeStormAttributes::hasIssueTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_types::T_POSIXTime& T_SXMShapeTypeStormAttributes::getIssueTime () const {
    return _IssueTime;
}

inline ::fi_types::T_POSIXTime& T_SXMShapeTypeStormAttributes::getIssueTimeMutable () {
    set_has_IssueTime();
    return _IssueTime;
}

inline void T_SXMShapeTypeStormAttributes::setIssueTime (const ::fi_types::T_POSIXTime& IssueTime_) {
    set_has_IssueTime();
    this->_IssueTime = IssueTime_;
}

inline void T_SXMShapeTypeStormAttributes::clearStormUniqueId() {
    if (hasStormUniqueId()) {
         clear_has_StormUniqueId();
        _StormUniqueId.clear();
     }
}

inline bool T_SXMShapeTypeStormAttributes::hasStormUniqueId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SXMShapeTypeStormAttributes::getStormUniqueId () const {
    return _StormUniqueId;
}

inline ::std::string& T_SXMShapeTypeStormAttributes::getStormUniqueIdMutable () {
    set_has_StormUniqueId();
    return _StormUniqueId;
}

inline void T_SXMShapeTypeStormAttributes::setStormUniqueId (const ::std::string& StormUniqueId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormUniqueId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormUniqueId();
    this->_StormUniqueId = StormUniqueId_;
}

inline void T_SXMShapeTypeStormAttributes::setStormUniqueId (const char* StormUniqueId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormUniqueId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormUniqueId();
    this->_StormUniqueId.assign(StormUniqueId_);
}

inline void T_SXMShapeTypeStormAttributes::setStormUniqueId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormUniqueId();
    this->_StormUniqueId.assign(value, size);
}

inline void T_SXMShapeTypeStormAttributes::clearObservationTime() {
    if (hasObservationTime()) {
         clear_has_ObservationTime();
        _ObservationTime.clear();
     }
}

inline bool T_SXMShapeTypeStormAttributes::hasObservationTime () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_types::T_POSIXTime& T_SXMShapeTypeStormAttributes::getObservationTime () const {
    return _ObservationTime;
}

inline ::fi_types::T_POSIXTime& T_SXMShapeTypeStormAttributes::getObservationTimeMutable () {
    set_has_ObservationTime();
    return _ObservationTime;
}

inline void T_SXMShapeTypeStormAttributes::setObservationTime (const ::fi_types::T_POSIXTime& ObservationTime_) {
    set_has_ObservationTime();
    this->_ObservationTime = ObservationTime_;
}

inline void T_SXMShapeTypeStormAttributes::clearEchoTopHeight() {
    if (hasEchoTopHeight()) {
         clear_has_EchoTopHeight();
        _EchoTopHeight = 0;
     }
}

inline bool T_SXMShapeTypeStormAttributes::hasEchoTopHeight () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::fi_types::T_s32_Foot T_SXMShapeTypeStormAttributes::getEchoTopHeight () const {
    return _EchoTopHeight;
}

inline void T_SXMShapeTypeStormAttributes::setEchoTopHeight (::fi_types::T_s32_Foot EchoTopHeight_) {
    set_has_EchoTopHeight();
    this->_EchoTopHeight = EchoTopHeight_;
}

inline void T_SXMShapeTypeStormAttributes::clearMovementDirection() {
    if (hasMovementDirection()) {
         clear_has_MovementDirection();
        _MovementDirection = 0;
     }
}

inline bool T_SXMShapeTypeStormAttributes::hasMovementDirection () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::fi_types::T_s16_Degree T_SXMShapeTypeStormAttributes::getMovementDirection () const {
    return _MovementDirection;
}

inline void T_SXMShapeTypeStormAttributes::setMovementDirection (::fi_types::T_s16_Degree MovementDirection_) {
    set_has_MovementDirection();
    this->_MovementDirection = MovementDirection_;
}

inline void T_SXMShapeTypeStormAttributes::clearMovementSpeed() {
    if (hasMovementSpeed()) {
         clear_has_MovementSpeed();
        _MovementSpeed = 0;
     }
}

inline bool T_SXMShapeTypeStormAttributes::hasMovementSpeed () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline ::fi_types::T_s16_Knot T_SXMShapeTypeStormAttributes::getMovementSpeed () const {
    return _MovementSpeed;
}

inline void T_SXMShapeTypeStormAttributes::setMovementSpeed (::fi_types::T_s16_Knot MovementSpeed_) {
    set_has_MovementSpeed();
    this->_MovementSpeed = MovementSpeed_;
}

inline void T_SXMShapeTypeStormAttributes::clearStormType() {
    if (hasStormType()) {
         clear_has_StormType();
        _StormType = T_b8_StormType ();
     }
}

inline bool T_SXMShapeTypeStormAttributes::hasStormType () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const T_b8_StormType& T_SXMShapeTypeStormAttributes::getStormType () const {
    return _StormType;
}

inline T_b8_StormType& T_SXMShapeTypeStormAttributes::getStormTypeMutable () {
    set_has_StormType();
    return _StormType;
}

inline void T_SXMShapeTypeStormAttributes::setStormType (const T_b8_StormType& StormType_) {
    set_has_StormType();
    this->_StormType = StormType_;
}

inline void T_SXMShapeTypeStormAttributes::clearGeoPoint() {
    if (hasGeoPoint()) {
         clear_has_GeoPoint();
        _GeoPoint.clear();
     }
}

inline bool T_SXMShapeTypeStormAttributes::hasGeoPoint () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::fi_types::T_PositionWGS84& T_SXMShapeTypeStormAttributes::getGeoPoint () const {
    return _GeoPoint;
}

inline ::fi_types::T_PositionWGS84& T_SXMShapeTypeStormAttributes::getGeoPointMutable () {
    set_has_GeoPoint();
    return _GeoPoint;
}

inline void T_SXMShapeTypeStormAttributes::setGeoPoint (const ::fi_types::T_PositionWGS84& GeoPoint_) {
    set_has_GeoPoint();
    this->_GeoPoint = GeoPoint_;
}

inline void T_SXMShapeTypeStormAttributes::set_has_IssueTime () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMShapeTypeStormAttributes::clear_has_IssueTime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMShapeTypeStormAttributes::set_has_StormUniqueId () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMShapeTypeStormAttributes::clear_has_StormUniqueId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMShapeTypeStormAttributes::set_has_ObservationTime () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMShapeTypeStormAttributes::clear_has_ObservationTime () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SXMShapeTypeStormAttributes::set_has_EchoTopHeight () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SXMShapeTypeStormAttributes::clear_has_EchoTopHeight () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SXMShapeTypeStormAttributes::set_has_MovementDirection () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SXMShapeTypeStormAttributes::clear_has_MovementDirection () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SXMShapeTypeStormAttributes::set_has_MovementSpeed () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SXMShapeTypeStormAttributes::clear_has_MovementSpeed () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SXMShapeTypeStormAttributes::set_has_StormType () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SXMShapeTypeStormAttributes::clear_has_StormType () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SXMShapeTypeStormAttributes::set_has_GeoPoint () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SXMShapeTypeStormAttributes::clear_has_GeoPoint () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_SXMShapeTypeStormTrack::T_SXMShapeTypeStormTrack ()  :
    _StormUniqueId (),
    _StormName (),
    _StormPositions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMShapeTypeStormTrack::T_SXMShapeTypeStormTrack (const T_SXMShapeTypeStormTrack &rhs)  :
    _StormUniqueId (),
    _StormName (),
    _StormPositions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMShapeTypeStormTrack::T_SXMShapeTypeStormTrack (const ::std::string& StormUniqueId_, const ::std::string& StormName_, const ::std::vector< T_SXMShapeTypeStormPosition >& StormPositions_)  :
    _StormUniqueId (StormUniqueId_),
    _StormName (StormName_),
    _StormPositions (StormPositions_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormUniqueId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMShapeTypeStormTrack::~T_SXMShapeTypeStormTrack() {
}

inline T_SXMShapeTypeStormTrack& T_SXMShapeTypeStormTrack::operator = (const T_SXMShapeTypeStormTrack& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStormUniqueId()) {
            setStormUniqueId(rhs.getStormUniqueId());
        } else {
            clearStormUniqueId();
        }
        if (rhs.hasStormName()) {
            setStormName(rhs.getStormName());
        } else {
            clearStormName();
        }
        if (rhs.hasStormPositions()) {
            setStormPositions(rhs.getStormPositions());
        } else {
            clearStormPositions();
        }
    }
    return *this;
}

inline bool T_SXMShapeTypeStormTrack::operator == (const T_SXMShapeTypeStormTrack& rhs) const {
    return (((!hasStormUniqueId() && !rhs.hasStormUniqueId()) || getStormUniqueId() == rhs.getStormUniqueId()) &&
        ((!hasStormName() && !rhs.hasStormName()) || getStormName() == rhs.getStormName()) &&
        ((!hasStormPositions() && !rhs.hasStormPositions()) || getStormPositions() == rhs.getStormPositions()));
}

inline bool T_SXMShapeTypeStormTrack::operator != (const T_SXMShapeTypeStormTrack& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMShapeTypeStormTrack::operator < (const T_SXMShapeTypeStormTrack& rhs) const {
    if (hasStormUniqueId() || rhs.hasStormUniqueId()) {
        if (getStormUniqueId() < rhs.getStormUniqueId()) return true;
        if (getStormUniqueId() > rhs.getStormUniqueId()) return false;
    }
    if (hasStormName() || rhs.hasStormName()) {
        if (getStormName() < rhs.getStormName()) return true;
        if (getStormName() > rhs.getStormName()) return false;
    }
    if (hasStormPositions() || rhs.hasStormPositions()) {
        if (getStormPositions() < rhs.getStormPositions()) return true;
        if (getStormPositions() > rhs.getStormPositions()) return false;
    }
    return false;
}

inline bool T_SXMShapeTypeStormTrack::operator > (const T_SXMShapeTypeStormTrack& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMShapeTypeStormTrack::clear() {
    clearStormUniqueId();
    clearStormName();
    clearStormPositions();
}

inline void T_SXMShapeTypeStormTrack::clearStormUniqueId() {
    if (hasStormUniqueId()) {
         clear_has_StormUniqueId();
        _StormUniqueId.clear();
     }
}

inline bool T_SXMShapeTypeStormTrack::hasStormUniqueId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_SXMShapeTypeStormTrack::getStormUniqueId () const {
    return _StormUniqueId;
}

inline ::std::string& T_SXMShapeTypeStormTrack::getStormUniqueIdMutable () {
    set_has_StormUniqueId();
    return _StormUniqueId;
}

inline void T_SXMShapeTypeStormTrack::setStormUniqueId (const ::std::string& StormUniqueId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormUniqueId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormUniqueId();
    this->_StormUniqueId = StormUniqueId_;
}

inline void T_SXMShapeTypeStormTrack::setStormUniqueId (const char* StormUniqueId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormUniqueId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormUniqueId();
    this->_StormUniqueId.assign(StormUniqueId_);
}

inline void T_SXMShapeTypeStormTrack::setStormUniqueId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormUniqueId();
    this->_StormUniqueId.assign(value, size);
}

inline void T_SXMShapeTypeStormTrack::clearStormName() {
    if (hasStormName()) {
         clear_has_StormName();
        _StormName.clear();
     }
}

inline bool T_SXMShapeTypeStormTrack::hasStormName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SXMShapeTypeStormTrack::getStormName () const {
    return _StormName;
}

inline ::std::string& T_SXMShapeTypeStormTrack::getStormNameMutable () {
    set_has_StormName();
    return _StormName;
}

inline void T_SXMShapeTypeStormTrack::setStormName (const ::std::string& StormName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormName();
    this->_StormName = StormName_;
}

inline void T_SXMShapeTypeStormTrack::setStormName (const char* StormName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StormName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormName();
    this->_StormName.assign(StormName_);
}

inline void T_SXMShapeTypeStormTrack::setStormName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StormName();
    this->_StormName.assign(value, size);
}

inline void T_SXMShapeTypeStormTrack::clearStormPositions() {
    if (hasStormPositions()) {
         clear_has_StormPositions();
        _StormPositions.clear();
     }
}

inline bool T_SXMShapeTypeStormTrack::hasStormPositions () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< T_SXMShapeTypeStormPosition >& T_SXMShapeTypeStormTrack::getStormPositions () const {
    return _StormPositions;
}

inline ::std::vector< T_SXMShapeTypeStormPosition >& T_SXMShapeTypeStormTrack::getStormPositionsMutable () {
    set_has_StormPositions();
    return _StormPositions;
}

inline void T_SXMShapeTypeStormTrack::setStormPositions (const ::std::vector< T_SXMShapeTypeStormPosition >& StormPositions_) {
    set_has_StormPositions();
    this->_StormPositions = StormPositions_;
}

inline void T_SXMShapeTypeStormTrack::set_has_StormUniqueId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMShapeTypeStormTrack::clear_has_StormUniqueId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMShapeTypeStormTrack::set_has_StormName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMShapeTypeStormTrack::clear_has_StormName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMShapeTypeStormTrack::set_has_StormPositions () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMShapeTypeStormTrack::clear_has_StormPositions () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SXMShape::T_SXMShape () :
    __field (E_T_RESERVED),
    _data()
{
    _data.T_Reserved_ = NULL;
}

inline  T_SXMShape::T_SXMShape (const T_SXMShape& rhs) :
    __field (E_T_RESERVED),
    _data()
{
    _data.T_Reserved_ = NULL;
    *this = rhs;
}

inline  T_SXMShape::~T_SXMShape() {
    deleteData ();
}

inline T_SXMShape& T_SXMShape::operator = (const T_SXMShape& rhs) {
    if( this != &rhs ) {
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool T_SXMShape::operator == (const T_SXMShape& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_T_RESERVED:
            if (_data.T_Reserved_ == NULL && rhs._data.T_Reserved_ == NULL) {
                return true;
            }
            return (getT_Reserved() == rhs.getT_Reserved());
        case E_T_SXMSHAPE_TYPE_FRONT:
            if (_data.T_SXMShapeTypeFront_ == NULL && rhs._data.T_SXMShapeTypeFront_ == NULL) {
                return true;
            }
            return (getT_SXMShapeTypeFront() == rhs.getT_SXMShapeTypeFront());
        case E_T_SXMSHAPE_TYPE_PRESSURE_CENTER:
            if (_data.T_SXMShapeTypePressureCenter_ == NULL && rhs._data.T_SXMShapeTypePressureCenter_ == NULL) {
                return true;
            }
            return (getT_SXMShapeTypePressureCenter() == rhs.getT_SXMShapeTypePressureCenter());
        case E_T_SXMSHAPE_TYPE_ISOBAR:
            if (_data.T_SXMShapeTypeIsobar_ == NULL && rhs._data.T_SXMShapeTypeIsobar_ == NULL) {
                return true;
            }
            return (getT_SXMShapeTypeIsobar() == rhs.getT_SXMShapeTypeIsobar());
        case E_T_SXMSHAPE_TYPE_STORM_POSITION:
            if (_data.T_SXMShapeTypeStormPosition_ == NULL && rhs._data.T_SXMShapeTypeStormPosition_ == NULL) {
                return true;
            }
            return (getT_SXMShapeTypeStormPosition() == rhs.getT_SXMShapeTypeStormPosition());
        case E_T_SXMSHAPE_TYPE_WIND_RADIUS:
            if (_data.T_SXMShapeTypeWindRadius_ == NULL && rhs._data.T_SXMShapeTypeWindRadius_ == NULL) {
                return true;
            }
            return (getT_SXMShapeTypeWindRadius() == rhs.getT_SXMShapeTypeWindRadius());
        case E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES:
            if (_data.T_SXMShapeTypeStormAttributes_ == NULL && rhs._data.T_SXMShapeTypeStormAttributes_ == NULL) {
                return true;
            }
            return (getT_SXMShapeTypeStormAttributes() == rhs.getT_SXMShapeTypeStormAttributes());
        case E_T_SXMSHAPE_TYPE_STORM_TRACK:
            if (_data.T_SXMShapeTypeStormTrack_ == NULL && rhs._data.T_SXMShapeTypeStormTrack_ == NULL) {
                return true;
            }
            return (getT_SXMShapeTypeStormTrack() == rhs.getT_SXMShapeTypeStormTrack());
        default:
            return false;
        }
    }
    return false;
}

inline bool T_SXMShape::operator != (const T_SXMShape& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMShape::operator < (const T_SXMShape& rhs) const  {
    if (hasT_Reserved() && rhs.hasT_Reserved()) {
        if (getT_Reserved() < rhs.getT_Reserved()) return true;
        if (getT_Reserved() > rhs.getT_Reserved()) return false;
    } else {
        if (hasT_Reserved() && !rhs.hasT_Reserved())
            return true;
        else if (!hasT_Reserved() && rhs.hasT_Reserved())
            return false;
    }

    if (hasT_SXMShapeTypeFront() && rhs.hasT_SXMShapeTypeFront()) {
        if (getT_SXMShapeTypeFront() < rhs.getT_SXMShapeTypeFront()) return true;
        if (getT_SXMShapeTypeFront() > rhs.getT_SXMShapeTypeFront()) return false;
    } else {
        if (hasT_SXMShapeTypeFront() && !rhs.hasT_SXMShapeTypeFront())
            return true;
        else if (!hasT_SXMShapeTypeFront() && rhs.hasT_SXMShapeTypeFront())
            return false;
    }

    if (hasT_SXMShapeTypePressureCenter() && rhs.hasT_SXMShapeTypePressureCenter()) {
        if (getT_SXMShapeTypePressureCenter() < rhs.getT_SXMShapeTypePressureCenter()) return true;
        if (getT_SXMShapeTypePressureCenter() > rhs.getT_SXMShapeTypePressureCenter()) return false;
    } else {
        if (hasT_SXMShapeTypePressureCenter() && !rhs.hasT_SXMShapeTypePressureCenter())
            return true;
        else if (!hasT_SXMShapeTypePressureCenter() && rhs.hasT_SXMShapeTypePressureCenter())
            return false;
    }

    if (hasT_SXMShapeTypeIsobar() && rhs.hasT_SXMShapeTypeIsobar()) {
        if (getT_SXMShapeTypeIsobar() < rhs.getT_SXMShapeTypeIsobar()) return true;
        if (getT_SXMShapeTypeIsobar() > rhs.getT_SXMShapeTypeIsobar()) return false;
    } else {
        if (hasT_SXMShapeTypeIsobar() && !rhs.hasT_SXMShapeTypeIsobar())
            return true;
        else if (!hasT_SXMShapeTypeIsobar() && rhs.hasT_SXMShapeTypeIsobar())
            return false;
    }

    if (hasT_SXMShapeTypeStormPosition() && rhs.hasT_SXMShapeTypeStormPosition()) {
        if (getT_SXMShapeTypeStormPosition() < rhs.getT_SXMShapeTypeStormPosition()) return true;
        if (getT_SXMShapeTypeStormPosition() > rhs.getT_SXMShapeTypeStormPosition()) return false;
    } else {
        if (hasT_SXMShapeTypeStormPosition() && !rhs.hasT_SXMShapeTypeStormPosition())
            return true;
        else if (!hasT_SXMShapeTypeStormPosition() && rhs.hasT_SXMShapeTypeStormPosition())
            return false;
    }

    if (hasT_SXMShapeTypeWindRadius() && rhs.hasT_SXMShapeTypeWindRadius()) {
        if (getT_SXMShapeTypeWindRadius() < rhs.getT_SXMShapeTypeWindRadius()) return true;
        if (getT_SXMShapeTypeWindRadius() > rhs.getT_SXMShapeTypeWindRadius()) return false;
    } else {
        if (hasT_SXMShapeTypeWindRadius() && !rhs.hasT_SXMShapeTypeWindRadius())
            return true;
        else if (!hasT_SXMShapeTypeWindRadius() && rhs.hasT_SXMShapeTypeWindRadius())
            return false;
    }

    if (hasT_SXMShapeTypeStormAttributes() && rhs.hasT_SXMShapeTypeStormAttributes()) {
        if (getT_SXMShapeTypeStormAttributes() < rhs.getT_SXMShapeTypeStormAttributes()) return true;
        if (getT_SXMShapeTypeStormAttributes() > rhs.getT_SXMShapeTypeStormAttributes()) return false;
    } else {
        if (hasT_SXMShapeTypeStormAttributes() && !rhs.hasT_SXMShapeTypeStormAttributes())
            return true;
        else if (!hasT_SXMShapeTypeStormAttributes() && rhs.hasT_SXMShapeTypeStormAttributes())
            return false;
    }

    if (hasT_SXMShapeTypeStormTrack() && rhs.hasT_SXMShapeTypeStormTrack()) {
        if (getT_SXMShapeTypeStormTrack() < rhs.getT_SXMShapeTypeStormTrack()) return true;
        if (getT_SXMShapeTypeStormTrack() > rhs.getT_SXMShapeTypeStormTrack()) return false;
    } else {
        if (hasT_SXMShapeTypeStormTrack() && !rhs.hasT_SXMShapeTypeStormTrack())
            return true;
        else if (!hasT_SXMShapeTypeStormTrack() && rhs.hasT_SXMShapeTypeStormTrack())
            return false;
    }

    return false;
}

inline bool T_SXMShape::operator > (const T_SXMShape& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline T_SXMShape::T_SXMShapeField T_SXMShape::getField () const {
    return __field;
}

inline void T_SXMShape::setField(T_SXMShape::T_SXMShapeField field) {
    deleteData();
    __field = field;
}

inline bool T_SXMShape::hasT_Reserved () const {
    return __field == E_T_RESERVED;
}

inline const ::fi_types::T_Reserved& T_SXMShape::getT_Reserved() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_Reserved(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_Reserved", "T_SXMShape", getField());
    }
    if (hasT_Reserved()) {
        if (_data.T_Reserved_ == NULL) {
            return ::fi_types::T_Reserved::getDefaultInstance();
        }
        return *_data.T_Reserved_;
    }
    abort();
}

inline ::fi_types::T_Reserved& T_SXMShape::getT_ReservedMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_Reserved(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_Reserved", "T_SXMShape", getField());
    }
    if (hasT_Reserved()) {
        if (_data.T_Reserved_ == NULL) {
            _data.T_Reserved_ = new ::fi_types::T_Reserved();
            CHECK_ALLOCATION( _data.T_Reserved_ );
        }
        return *_data.T_Reserved_;
    }
    abort();
}

inline ::fi_types::T_Reserved* T_SXMShape::releaseT_Reserved() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_Reserved(), "Can't release value for field 'T_SXMShape', have field %d", getField());
    }
    if (hasT_Reserved()) {
        if (_data.T_Reserved_ == NULL) {
            _data.T_Reserved_ = new ::fi_types::T_Reserved();
            CHECK_ALLOCATION( _data.T_Reserved_ );
        }
        ::fi_types::T_Reserved* temp = _data.T_Reserved_;
        _data.T_Reserved_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_SXMShape::replaceT_Reserved (::fi_types::T_Reserved* T_Reserved) {
    if (__field != E_T_RESERVED || _data.T_Reserved_ != T_Reserved) {
        deleteData ();
        __field = E_T_RESERVED;
        _data.T_Reserved_ = T_Reserved;
    }
}

inline void T_SXMShape::setT_Reserved (const ::fi_types::T_Reserved& value) {
    if (__field == E_T_RESERVED && _data.T_Reserved_ != NULL) {
        *_data.T_Reserved_ = value;
    } else {
        deleteData ();
        __field = E_T_RESERVED;
        _data.T_Reserved_ = new ::fi_types::T_Reserved(value);
    }
}

inline bool T_SXMShape::hasT_SXMShapeTypeFront () const {
    return __field == E_T_SXMSHAPE_TYPE_FRONT;
}

inline const T_SXMShapeTypeFront& T_SXMShape::getT_SXMShapeTypeFront() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypeFront(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypeFront", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypeFront()) {
        if (_data.T_SXMShapeTypeFront_ == NULL) {
            return T_SXMShapeTypeFront::getDefaultInstance();
        }
        return *_data.T_SXMShapeTypeFront_;
    }
    abort();
}

inline T_SXMShapeTypeFront& T_SXMShape::getT_SXMShapeTypeFrontMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypeFront(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypeFront", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypeFront()) {
        if (_data.T_SXMShapeTypeFront_ == NULL) {
            _data.T_SXMShapeTypeFront_ = new T_SXMShapeTypeFront();
            CHECK_ALLOCATION( _data.T_SXMShapeTypeFront_ );
        }
        return *_data.T_SXMShapeTypeFront_;
    }
    abort();
}

inline T_SXMShapeTypeFront* T_SXMShape::releaseT_SXMShapeTypeFront() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_SXMShapeTypeFront(), "Can't release value for field 'T_SXMShape', have field %d", getField());
    }
    if (hasT_SXMShapeTypeFront()) {
        if (_data.T_SXMShapeTypeFront_ == NULL) {
            _data.T_SXMShapeTypeFront_ = new T_SXMShapeTypeFront();
            CHECK_ALLOCATION( _data.T_SXMShapeTypeFront_ );
        }
        T_SXMShapeTypeFront* temp = _data.T_SXMShapeTypeFront_;
        _data.T_SXMShapeTypeFront_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_SXMShape::replaceT_SXMShapeTypeFront (T_SXMShapeTypeFront* T_SXMShapeTypeFront) {
    if (__field != E_T_SXMSHAPE_TYPE_FRONT || _data.T_SXMShapeTypeFront_ != T_SXMShapeTypeFront) {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_FRONT;
        _data.T_SXMShapeTypeFront_ = T_SXMShapeTypeFront;
    }
}

inline void T_SXMShape::setT_SXMShapeTypeFront (const T_SXMShapeTypeFront& value) {
    if (__field == E_T_SXMSHAPE_TYPE_FRONT && _data.T_SXMShapeTypeFront_ != NULL) {
        *_data.T_SXMShapeTypeFront_ = value;
    } else {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_FRONT;
        _data.T_SXMShapeTypeFront_ = new T_SXMShapeTypeFront(value);
    }
}

inline bool T_SXMShape::hasT_SXMShapeTypePressureCenter () const {
    return __field == E_T_SXMSHAPE_TYPE_PRESSURE_CENTER;
}

inline const T_SXMShapeTypePressureCenter& T_SXMShape::getT_SXMShapeTypePressureCenter() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypePressureCenter(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypePressureCenter", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypePressureCenter()) {
        if (_data.T_SXMShapeTypePressureCenter_ == NULL) {
            return T_SXMShapeTypePressureCenter::getDefaultInstance();
        }
        return *_data.T_SXMShapeTypePressureCenter_;
    }
    abort();
}

inline T_SXMShapeTypePressureCenter& T_SXMShape::getT_SXMShapeTypePressureCenterMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypePressureCenter(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypePressureCenter", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypePressureCenter()) {
        if (_data.T_SXMShapeTypePressureCenter_ == NULL) {
            _data.T_SXMShapeTypePressureCenter_ = new T_SXMShapeTypePressureCenter();
            CHECK_ALLOCATION( _data.T_SXMShapeTypePressureCenter_ );
        }
        return *_data.T_SXMShapeTypePressureCenter_;
    }
    abort();
}

inline T_SXMShapeTypePressureCenter* T_SXMShape::releaseT_SXMShapeTypePressureCenter() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_SXMShapeTypePressureCenter(), "Can't release value for field 'T_SXMShape', have field %d", getField());
    }
    if (hasT_SXMShapeTypePressureCenter()) {
        if (_data.T_SXMShapeTypePressureCenter_ == NULL) {
            _data.T_SXMShapeTypePressureCenter_ = new T_SXMShapeTypePressureCenter();
            CHECK_ALLOCATION( _data.T_SXMShapeTypePressureCenter_ );
        }
        T_SXMShapeTypePressureCenter* temp = _data.T_SXMShapeTypePressureCenter_;
        _data.T_SXMShapeTypePressureCenter_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_SXMShape::replaceT_SXMShapeTypePressureCenter (T_SXMShapeTypePressureCenter* T_SXMShapeTypePressureCenter) {
    if (__field != E_T_SXMSHAPE_TYPE_PRESSURE_CENTER || _data.T_SXMShapeTypePressureCenter_ != T_SXMShapeTypePressureCenter) {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_PRESSURE_CENTER;
        _data.T_SXMShapeTypePressureCenter_ = T_SXMShapeTypePressureCenter;
    }
}

inline void T_SXMShape::setT_SXMShapeTypePressureCenter (const T_SXMShapeTypePressureCenter& value) {
    if (__field == E_T_SXMSHAPE_TYPE_PRESSURE_CENTER && _data.T_SXMShapeTypePressureCenter_ != NULL) {
        *_data.T_SXMShapeTypePressureCenter_ = value;
    } else {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_PRESSURE_CENTER;
        _data.T_SXMShapeTypePressureCenter_ = new T_SXMShapeTypePressureCenter(value);
    }
}

inline bool T_SXMShape::hasT_SXMShapeTypeIsobar () const {
    return __field == E_T_SXMSHAPE_TYPE_ISOBAR;
}

inline const T_SXMShapeTypeIsobar& T_SXMShape::getT_SXMShapeTypeIsobar() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypeIsobar(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypeIsobar", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypeIsobar()) {
        if (_data.T_SXMShapeTypeIsobar_ == NULL) {
            return T_SXMShapeTypeIsobar::getDefaultInstance();
        }
        return *_data.T_SXMShapeTypeIsobar_;
    }
    abort();
}

inline T_SXMShapeTypeIsobar& T_SXMShape::getT_SXMShapeTypeIsobarMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypeIsobar(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypeIsobar", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypeIsobar()) {
        if (_data.T_SXMShapeTypeIsobar_ == NULL) {
            _data.T_SXMShapeTypeIsobar_ = new T_SXMShapeTypeIsobar();
            CHECK_ALLOCATION( _data.T_SXMShapeTypeIsobar_ );
        }
        return *_data.T_SXMShapeTypeIsobar_;
    }
    abort();
}

inline T_SXMShapeTypeIsobar* T_SXMShape::releaseT_SXMShapeTypeIsobar() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_SXMShapeTypeIsobar(), "Can't release value for field 'T_SXMShape', have field %d", getField());
    }
    if (hasT_SXMShapeTypeIsobar()) {
        if (_data.T_SXMShapeTypeIsobar_ == NULL) {
            _data.T_SXMShapeTypeIsobar_ = new T_SXMShapeTypeIsobar();
            CHECK_ALLOCATION( _data.T_SXMShapeTypeIsobar_ );
        }
        T_SXMShapeTypeIsobar* temp = _data.T_SXMShapeTypeIsobar_;
        _data.T_SXMShapeTypeIsobar_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_SXMShape::replaceT_SXMShapeTypeIsobar (T_SXMShapeTypeIsobar* T_SXMShapeTypeIsobar) {
    if (__field != E_T_SXMSHAPE_TYPE_ISOBAR || _data.T_SXMShapeTypeIsobar_ != T_SXMShapeTypeIsobar) {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_ISOBAR;
        _data.T_SXMShapeTypeIsobar_ = T_SXMShapeTypeIsobar;
    }
}

inline void T_SXMShape::setT_SXMShapeTypeIsobar (const T_SXMShapeTypeIsobar& value) {
    if (__field == E_T_SXMSHAPE_TYPE_ISOBAR && _data.T_SXMShapeTypeIsobar_ != NULL) {
        *_data.T_SXMShapeTypeIsobar_ = value;
    } else {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_ISOBAR;
        _data.T_SXMShapeTypeIsobar_ = new T_SXMShapeTypeIsobar(value);
    }
}

inline bool T_SXMShape::hasT_SXMShapeTypeStormPosition () const {
    return __field == E_T_SXMSHAPE_TYPE_STORM_POSITION;
}

inline const T_SXMShapeTypeStormPosition& T_SXMShape::getT_SXMShapeTypeStormPosition() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypeStormPosition(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypeStormPosition", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypeStormPosition()) {
        if (_data.T_SXMShapeTypeStormPosition_ == NULL) {
            return T_SXMShapeTypeStormPosition::getDefaultInstance();
        }
        return *_data.T_SXMShapeTypeStormPosition_;
    }
    abort();
}

inline T_SXMShapeTypeStormPosition& T_SXMShape::getT_SXMShapeTypeStormPositionMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypeStormPosition(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypeStormPosition", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypeStormPosition()) {
        if (_data.T_SXMShapeTypeStormPosition_ == NULL) {
            _data.T_SXMShapeTypeStormPosition_ = new T_SXMShapeTypeStormPosition();
            CHECK_ALLOCATION( _data.T_SXMShapeTypeStormPosition_ );
        }
        return *_data.T_SXMShapeTypeStormPosition_;
    }
    abort();
}

inline T_SXMShapeTypeStormPosition* T_SXMShape::releaseT_SXMShapeTypeStormPosition() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_SXMShapeTypeStormPosition(), "Can't release value for field 'T_SXMShape', have field %d", getField());
    }
    if (hasT_SXMShapeTypeStormPosition()) {
        if (_data.T_SXMShapeTypeStormPosition_ == NULL) {
            _data.T_SXMShapeTypeStormPosition_ = new T_SXMShapeTypeStormPosition();
            CHECK_ALLOCATION( _data.T_SXMShapeTypeStormPosition_ );
        }
        T_SXMShapeTypeStormPosition* temp = _data.T_SXMShapeTypeStormPosition_;
        _data.T_SXMShapeTypeStormPosition_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_SXMShape::replaceT_SXMShapeTypeStormPosition (T_SXMShapeTypeStormPosition* T_SXMShapeTypeStormPosition) {
    if (__field != E_T_SXMSHAPE_TYPE_STORM_POSITION || _data.T_SXMShapeTypeStormPosition_ != T_SXMShapeTypeStormPosition) {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_STORM_POSITION;
        _data.T_SXMShapeTypeStormPosition_ = T_SXMShapeTypeStormPosition;
    }
}

inline void T_SXMShape::setT_SXMShapeTypeStormPosition (const T_SXMShapeTypeStormPosition& value) {
    if (__field == E_T_SXMSHAPE_TYPE_STORM_POSITION && _data.T_SXMShapeTypeStormPosition_ != NULL) {
        *_data.T_SXMShapeTypeStormPosition_ = value;
    } else {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_STORM_POSITION;
        _data.T_SXMShapeTypeStormPosition_ = new T_SXMShapeTypeStormPosition(value);
    }
}

inline bool T_SXMShape::hasT_SXMShapeTypeWindRadius () const {
    return __field == E_T_SXMSHAPE_TYPE_WIND_RADIUS;
}

inline const T_SXMShapeTypeWindRadius& T_SXMShape::getT_SXMShapeTypeWindRadius() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypeWindRadius(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypeWindRadius", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypeWindRadius()) {
        if (_data.T_SXMShapeTypeWindRadius_ == NULL) {
            return T_SXMShapeTypeWindRadius::getDefaultInstance();
        }
        return *_data.T_SXMShapeTypeWindRadius_;
    }
    abort();
}

inline T_SXMShapeTypeWindRadius& T_SXMShape::getT_SXMShapeTypeWindRadiusMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypeWindRadius(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypeWindRadius", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypeWindRadius()) {
        if (_data.T_SXMShapeTypeWindRadius_ == NULL) {
            _data.T_SXMShapeTypeWindRadius_ = new T_SXMShapeTypeWindRadius();
            CHECK_ALLOCATION( _data.T_SXMShapeTypeWindRadius_ );
        }
        return *_data.T_SXMShapeTypeWindRadius_;
    }
    abort();
}

inline T_SXMShapeTypeWindRadius* T_SXMShape::releaseT_SXMShapeTypeWindRadius() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_SXMShapeTypeWindRadius(), "Can't release value for field 'T_SXMShape', have field %d", getField());
    }
    if (hasT_SXMShapeTypeWindRadius()) {
        if (_data.T_SXMShapeTypeWindRadius_ == NULL) {
            _data.T_SXMShapeTypeWindRadius_ = new T_SXMShapeTypeWindRadius();
            CHECK_ALLOCATION( _data.T_SXMShapeTypeWindRadius_ );
        }
        T_SXMShapeTypeWindRadius* temp = _data.T_SXMShapeTypeWindRadius_;
        _data.T_SXMShapeTypeWindRadius_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_SXMShape::replaceT_SXMShapeTypeWindRadius (T_SXMShapeTypeWindRadius* T_SXMShapeTypeWindRadius) {
    if (__field != E_T_SXMSHAPE_TYPE_WIND_RADIUS || _data.T_SXMShapeTypeWindRadius_ != T_SXMShapeTypeWindRadius) {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_WIND_RADIUS;
        _data.T_SXMShapeTypeWindRadius_ = T_SXMShapeTypeWindRadius;
    }
}

inline void T_SXMShape::setT_SXMShapeTypeWindRadius (const T_SXMShapeTypeWindRadius& value) {
    if (__field == E_T_SXMSHAPE_TYPE_WIND_RADIUS && _data.T_SXMShapeTypeWindRadius_ != NULL) {
        *_data.T_SXMShapeTypeWindRadius_ = value;
    } else {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_WIND_RADIUS;
        _data.T_SXMShapeTypeWindRadius_ = new T_SXMShapeTypeWindRadius(value);
    }
}

inline bool T_SXMShape::hasT_SXMShapeTypeStormAttributes () const {
    return __field == E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES;
}

inline const T_SXMShapeTypeStormAttributes& T_SXMShape::getT_SXMShapeTypeStormAttributes() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypeStormAttributes(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypeStormAttributes", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypeStormAttributes()) {
        if (_data.T_SXMShapeTypeStormAttributes_ == NULL) {
            return T_SXMShapeTypeStormAttributes::getDefaultInstance();
        }
        return *_data.T_SXMShapeTypeStormAttributes_;
    }
    abort();
}

inline T_SXMShapeTypeStormAttributes& T_SXMShape::getT_SXMShapeTypeStormAttributesMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypeStormAttributes(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypeStormAttributes", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypeStormAttributes()) {
        if (_data.T_SXMShapeTypeStormAttributes_ == NULL) {
            _data.T_SXMShapeTypeStormAttributes_ = new T_SXMShapeTypeStormAttributes();
            CHECK_ALLOCATION( _data.T_SXMShapeTypeStormAttributes_ );
        }
        return *_data.T_SXMShapeTypeStormAttributes_;
    }
    abort();
}

inline T_SXMShapeTypeStormAttributes* T_SXMShape::releaseT_SXMShapeTypeStormAttributes() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_SXMShapeTypeStormAttributes(), "Can't release value for field 'T_SXMShape', have field %d", getField());
    }
    if (hasT_SXMShapeTypeStormAttributes()) {
        if (_data.T_SXMShapeTypeStormAttributes_ == NULL) {
            _data.T_SXMShapeTypeStormAttributes_ = new T_SXMShapeTypeStormAttributes();
            CHECK_ALLOCATION( _data.T_SXMShapeTypeStormAttributes_ );
        }
        T_SXMShapeTypeStormAttributes* temp = _data.T_SXMShapeTypeStormAttributes_;
        _data.T_SXMShapeTypeStormAttributes_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_SXMShape::replaceT_SXMShapeTypeStormAttributes (T_SXMShapeTypeStormAttributes* T_SXMShapeTypeStormAttributes) {
    if (__field != E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES || _data.T_SXMShapeTypeStormAttributes_ != T_SXMShapeTypeStormAttributes) {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES;
        _data.T_SXMShapeTypeStormAttributes_ = T_SXMShapeTypeStormAttributes;
    }
}

inline void T_SXMShape::setT_SXMShapeTypeStormAttributes (const T_SXMShapeTypeStormAttributes& value) {
    if (__field == E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES && _data.T_SXMShapeTypeStormAttributes_ != NULL) {
        *_data.T_SXMShapeTypeStormAttributes_ = value;
    } else {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES;
        _data.T_SXMShapeTypeStormAttributes_ = new T_SXMShapeTypeStormAttributes(value);
    }
}

inline bool T_SXMShape::hasT_SXMShapeTypeStormTrack () const {
    return __field == E_T_SXMSHAPE_TYPE_STORM_TRACK;
}

inline const T_SXMShapeTypeStormTrack& T_SXMShape::getT_SXMShapeTypeStormTrack() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypeStormTrack(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypeStormTrack", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypeStormTrack()) {
        if (_data.T_SXMShapeTypeStormTrack_ == NULL) {
            return T_SXMShapeTypeStormTrack::getDefaultInstance();
        }
        return *_data.T_SXMShapeTypeStormTrack_;
    }
    abort();
}

inline T_SXMShapeTypeStormTrack& T_SXMShape::getT_SXMShapeTypeStormTrackMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_SXMShapeTypeStormTrack(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_SXMShapeTypeStormTrack", "T_SXMShape", getField());
    }
    if (hasT_SXMShapeTypeStormTrack()) {
        if (_data.T_SXMShapeTypeStormTrack_ == NULL) {
            _data.T_SXMShapeTypeStormTrack_ = new T_SXMShapeTypeStormTrack();
            CHECK_ALLOCATION( _data.T_SXMShapeTypeStormTrack_ );
        }
        return *_data.T_SXMShapeTypeStormTrack_;
    }
    abort();
}

inline T_SXMShapeTypeStormTrack* T_SXMShape::releaseT_SXMShapeTypeStormTrack() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_SXMShapeTypeStormTrack(), "Can't release value for field 'T_SXMShape', have field %d", getField());
    }
    if (hasT_SXMShapeTypeStormTrack()) {
        if (_data.T_SXMShapeTypeStormTrack_ == NULL) {
            _data.T_SXMShapeTypeStormTrack_ = new T_SXMShapeTypeStormTrack();
            CHECK_ALLOCATION( _data.T_SXMShapeTypeStormTrack_ );
        }
        T_SXMShapeTypeStormTrack* temp = _data.T_SXMShapeTypeStormTrack_;
        _data.T_SXMShapeTypeStormTrack_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_SXMShape::replaceT_SXMShapeTypeStormTrack (T_SXMShapeTypeStormTrack* T_SXMShapeTypeStormTrack) {
    if (__field != E_T_SXMSHAPE_TYPE_STORM_TRACK || _data.T_SXMShapeTypeStormTrack_ != T_SXMShapeTypeStormTrack) {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_STORM_TRACK;
        _data.T_SXMShapeTypeStormTrack_ = T_SXMShapeTypeStormTrack;
    }
}

inline void T_SXMShape::setT_SXMShapeTypeStormTrack (const T_SXMShapeTypeStormTrack& value) {
    if (__field == E_T_SXMSHAPE_TYPE_STORM_TRACK && _data.T_SXMShapeTypeStormTrack_ != NULL) {
        *_data.T_SXMShapeTypeStormTrack_ = value;
    } else {
        deleteData ();
        __field = E_T_SXMSHAPE_TYPE_STORM_TRACK;
        _data.T_SXMShapeTypeStormTrack_ = new T_SXMShapeTypeStormTrack(value);
    }
}

inline void T_SXMShape::cloneData (const T_SXMShape& rhs) {
    switch (rhs.__field) {
    case E_T_RESERVED:
        if (__field == E_T_RESERVED) {
            if (rhs._data.T_Reserved_ == NULL)
                deleteData ();
            else {
                if (_data.T_Reserved_ != NULL) {
                    *_data.T_Reserved_ =  *rhs._data.T_Reserved_;
                } else {
                    _data.T_Reserved_ = new ::fi_types::T_Reserved(*rhs._data.T_Reserved_);
                }
            }
        } else {
            if (_data.T_Reserved_ != 0) deleteData ();
            if (rhs._data.T_Reserved_ != NULL) {
                _data.T_Reserved_ = new ::fi_types::T_Reserved(*rhs._data.T_Reserved_);
            }
        }
        break;
    case E_T_SXMSHAPE_TYPE_FRONT:
        if (__field == E_T_SXMSHAPE_TYPE_FRONT) {
            if (rhs._data.T_SXMShapeTypeFront_ == NULL)
                deleteData ();
            else {
                if (_data.T_SXMShapeTypeFront_ != NULL) {
                    *_data.T_SXMShapeTypeFront_ =  *rhs._data.T_SXMShapeTypeFront_;
                } else {
                    _data.T_SXMShapeTypeFront_ = new T_SXMShapeTypeFront(*rhs._data.T_SXMShapeTypeFront_);
                }
            }
        } else {
            if (_data.T_SXMShapeTypeFront_ != 0) deleteData ();
            if (rhs._data.T_SXMShapeTypeFront_ != NULL) {
                _data.T_SXMShapeTypeFront_ = new T_SXMShapeTypeFront(*rhs._data.T_SXMShapeTypeFront_);
            }
        }
        break;
    case E_T_SXMSHAPE_TYPE_PRESSURE_CENTER:
        if (__field == E_T_SXMSHAPE_TYPE_PRESSURE_CENTER) {
            if (rhs._data.T_SXMShapeTypePressureCenter_ == NULL)
                deleteData ();
            else {
                if (_data.T_SXMShapeTypePressureCenter_ != NULL) {
                    *_data.T_SXMShapeTypePressureCenter_ =  *rhs._data.T_SXMShapeTypePressureCenter_;
                } else {
                    _data.T_SXMShapeTypePressureCenter_ = new T_SXMShapeTypePressureCenter(*rhs._data.T_SXMShapeTypePressureCenter_);
                }
            }
        } else {
            if (_data.T_SXMShapeTypePressureCenter_ != 0) deleteData ();
            if (rhs._data.T_SXMShapeTypePressureCenter_ != NULL) {
                _data.T_SXMShapeTypePressureCenter_ = new T_SXMShapeTypePressureCenter(*rhs._data.T_SXMShapeTypePressureCenter_);
            }
        }
        break;
    case E_T_SXMSHAPE_TYPE_ISOBAR:
        if (__field == E_T_SXMSHAPE_TYPE_ISOBAR) {
            if (rhs._data.T_SXMShapeTypeIsobar_ == NULL)
                deleteData ();
            else {
                if (_data.T_SXMShapeTypeIsobar_ != NULL) {
                    *_data.T_SXMShapeTypeIsobar_ =  *rhs._data.T_SXMShapeTypeIsobar_;
                } else {
                    _data.T_SXMShapeTypeIsobar_ = new T_SXMShapeTypeIsobar(*rhs._data.T_SXMShapeTypeIsobar_);
                }
            }
        } else {
            if (_data.T_SXMShapeTypeIsobar_ != 0) deleteData ();
            if (rhs._data.T_SXMShapeTypeIsobar_ != NULL) {
                _data.T_SXMShapeTypeIsobar_ = new T_SXMShapeTypeIsobar(*rhs._data.T_SXMShapeTypeIsobar_);
            }
        }
        break;
    case E_T_SXMSHAPE_TYPE_STORM_POSITION:
        if (__field == E_T_SXMSHAPE_TYPE_STORM_POSITION) {
            if (rhs._data.T_SXMShapeTypeStormPosition_ == NULL)
                deleteData ();
            else {
                if (_data.T_SXMShapeTypeStormPosition_ != NULL) {
                    *_data.T_SXMShapeTypeStormPosition_ =  *rhs._data.T_SXMShapeTypeStormPosition_;
                } else {
                    _data.T_SXMShapeTypeStormPosition_ = new T_SXMShapeTypeStormPosition(*rhs._data.T_SXMShapeTypeStormPosition_);
                }
            }
        } else {
            if (_data.T_SXMShapeTypeStormPosition_ != 0) deleteData ();
            if (rhs._data.T_SXMShapeTypeStormPosition_ != NULL) {
                _data.T_SXMShapeTypeStormPosition_ = new T_SXMShapeTypeStormPosition(*rhs._data.T_SXMShapeTypeStormPosition_);
            }
        }
        break;
    case E_T_SXMSHAPE_TYPE_WIND_RADIUS:
        if (__field == E_T_SXMSHAPE_TYPE_WIND_RADIUS) {
            if (rhs._data.T_SXMShapeTypeWindRadius_ == NULL)
                deleteData ();
            else {
                if (_data.T_SXMShapeTypeWindRadius_ != NULL) {
                    *_data.T_SXMShapeTypeWindRadius_ =  *rhs._data.T_SXMShapeTypeWindRadius_;
                } else {
                    _data.T_SXMShapeTypeWindRadius_ = new T_SXMShapeTypeWindRadius(*rhs._data.T_SXMShapeTypeWindRadius_);
                }
            }
        } else {
            if (_data.T_SXMShapeTypeWindRadius_ != 0) deleteData ();
            if (rhs._data.T_SXMShapeTypeWindRadius_ != NULL) {
                _data.T_SXMShapeTypeWindRadius_ = new T_SXMShapeTypeWindRadius(*rhs._data.T_SXMShapeTypeWindRadius_);
            }
        }
        break;
    case E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES:
        if (__field == E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES) {
            if (rhs._data.T_SXMShapeTypeStormAttributes_ == NULL)
                deleteData ();
            else {
                if (_data.T_SXMShapeTypeStormAttributes_ != NULL) {
                    *_data.T_SXMShapeTypeStormAttributes_ =  *rhs._data.T_SXMShapeTypeStormAttributes_;
                } else {
                    _data.T_SXMShapeTypeStormAttributes_ = new T_SXMShapeTypeStormAttributes(*rhs._data.T_SXMShapeTypeStormAttributes_);
                }
            }
        } else {
            if (_data.T_SXMShapeTypeStormAttributes_ != 0) deleteData ();
            if (rhs._data.T_SXMShapeTypeStormAttributes_ != NULL) {
                _data.T_SXMShapeTypeStormAttributes_ = new T_SXMShapeTypeStormAttributes(*rhs._data.T_SXMShapeTypeStormAttributes_);
            }
        }
        break;
    case E_T_SXMSHAPE_TYPE_STORM_TRACK:
        if (__field == E_T_SXMSHAPE_TYPE_STORM_TRACK) {
            if (rhs._data.T_SXMShapeTypeStormTrack_ == NULL)
                deleteData ();
            else {
                if (_data.T_SXMShapeTypeStormTrack_ != NULL) {
                    *_data.T_SXMShapeTypeStormTrack_ =  *rhs._data.T_SXMShapeTypeStormTrack_;
                } else {
                    _data.T_SXMShapeTypeStormTrack_ = new T_SXMShapeTypeStormTrack(*rhs._data.T_SXMShapeTypeStormTrack_);
                }
            }
        } else {
            if (_data.T_SXMShapeTypeStormTrack_ != 0) deleteData ();
            if (rhs._data.T_SXMShapeTypeStormTrack_ != NULL) {
                _data.T_SXMShapeTypeStormTrack_ = new T_SXMShapeTypeStormTrack(*rhs._data.T_SXMShapeTypeStormTrack_);
            }
        }
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void T_SXMShape::deleteData () {
    switch (__field) {
    case E_T_RESERVED:
        delete _data.T_Reserved_;
        _data.T_Reserved_ = NULL;
        break;
    case E_T_SXMSHAPE_TYPE_FRONT:
        delete _data.T_SXMShapeTypeFront_;
        _data.T_SXMShapeTypeFront_ = NULL;
        break;
    case E_T_SXMSHAPE_TYPE_PRESSURE_CENTER:
        delete _data.T_SXMShapeTypePressureCenter_;
        _data.T_SXMShapeTypePressureCenter_ = NULL;
        break;
    case E_T_SXMSHAPE_TYPE_ISOBAR:
        delete _data.T_SXMShapeTypeIsobar_;
        _data.T_SXMShapeTypeIsobar_ = NULL;
        break;
    case E_T_SXMSHAPE_TYPE_STORM_POSITION:
        delete _data.T_SXMShapeTypeStormPosition_;
        _data.T_SXMShapeTypeStormPosition_ = NULL;
        break;
    case E_T_SXMSHAPE_TYPE_WIND_RADIUS:
        delete _data.T_SXMShapeTypeWindRadius_;
        _data.T_SXMShapeTypeWindRadius_ = NULL;
        break;
    case E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES:
        delete _data.T_SXMShapeTypeStormAttributes_;
        _data.T_SXMShapeTypeStormAttributes_ = NULL;
        break;
    case E_T_SXMSHAPE_TYPE_STORM_TRACK:
        delete _data.T_SXMShapeTypeStormTrack_;
        _data.T_SXMShapeTypeStormTrack_ = NULL;
        break;
    default:
        break;
    }
}

} // namespace sxm_agw_main_fi_types

#endif // SXM_AGW_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
