#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SWITCHCTRL_MAIN_FI_TYPES_H
#define SWITCHCTRL_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "switchctrl_main_fi_typesConst.h"
#include <cstring>

/**
 * Types switchctrl_main_fi_types
 */

namespace switchctrl_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_SwCtrl_ConnectionStatus;

class T_SwitchCtrl_VersionInfo;

class T_SwitchCtrl_UnitVersion;


/**
 * Record type containing connection status of MCAN Unit
 */
class T_SwCtrl_ConnectionStatus {
public:

    /**
     * Default constructor
     */
    inline  T_SwCtrl_ConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  T_SwCtrl_ConnectionStatus (const T_SwCtrl_ConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_SwCtrl_ConnectionStatus (T_e8_MCanUnitType e8UnitType_, bool bIsConnected_, uint8 u8AbsenceState_, uint8 u8MuteState_);

    /**
     * Destructor
     */
    inline  ~T_SwCtrl_ConnectionStatus();

    /**
     * Assignment operator
     */
    inline T_SwCtrl_ConnectionStatus& operator = (const T_SwCtrl_ConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SwCtrl_ConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SwCtrl_ConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SwCtrl_ConnectionStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SwCtrl_ConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8UnitType"

    static const int kE8UnitType = 0;

    /**
     * Clears the field "e8UnitType".
     *
     * The field will be set to its default value. The hasE8UnitType()
     * method will return false.
     */
    inline void clearE8UnitType();

    /**
     * Checks whether the field "e8UnitType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8UnitType()). Otherwise it will return false.
     */
    inline bool hasE8UnitType () const;

    /**
     * Returns the value of the member "e8UnitType".
     *
     * Type of Unit
     *
     * @return The value of the field "e8UnitType"
     */
    inline T_e8_MCanUnitType getE8UnitType () const;

    /**
     * Sets the value of the member "e8UnitType".
     *
     * Type of Unit
     *
     * @param e8UnitType The value which will be set
     */
    inline void setE8UnitType (T_e8_MCanUnitType e8UnitType_);

    // API of field "bIsConnected"

    static const int kBIsConnected = 1;

    /**
     * Clears the field "bIsConnected".
     *
     * The field will be set to its default value. The hasBIsConnected()
     * method will return false.
     */
    inline void clearBIsConnected();

    /**
     * Checks whether the field "bIsConnected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsConnected()). Otherwise it will return false.
     */
    inline bool hasBIsConnected () const;

    /**
     * Returns the value of the member "bIsConnected".
     *
     * FALSE: This MCAN Unit is not connected.
     * TRUE: This MCAN Unit is connected.
     *
     * @return The value of the field "bIsConnected"
     */
    inline bool getBIsConnected () const;

    /**
     * Sets the value of the member "bIsConnected".
     *
     * FALSE: This MCAN Unit is not connected.
     * TRUE: This MCAN Unit is connected.
     *
     * @param bIsConnected The value which will be set
     */
    inline void setBIsConnected (bool bIsConnected_);

    // API of field "u8AbsenceState"

    static const int kU8AbsenceState = 2;

    /**
     * Clears the field "u8AbsenceState".
     *
     * The field will be set to its default value. The hasU8AbsenceState()
     * method will return false.
     */
    inline void clearU8AbsenceState();

    /**
     * Checks whether the field "u8AbsenceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AbsenceState()). Otherwise it will return false.
     */
    inline bool hasU8AbsenceState () const;

    /**
     * Returns the value of the member "u8AbsenceState".
     *
     * Indicates the absence of CMF(Channel Management Frames), ie: if CMF were not Received.
     * 0x00 = Connection OK
     * 0x80 = CMF currently absent (Connection currently NOK)
     * 0xC0 = CMF Confirmed Absent (Connection confirmed NOK)
     * 0xFF = Absence Detection is Masked (Diagnostics not active)
     *
     * @return The value of the field "u8AbsenceState"
     */
    inline uint8 getU8AbsenceState () const;

    /**
     * Sets the value of the member "u8AbsenceState".
     *
     * Indicates the absence of CMF(Channel Management Frames), ie: if CMF were not Received.
     * 0x00 = Connection OK
     * 0x80 = CMF currently absent (Connection currently NOK)
     * 0xC0 = CMF Confirmed Absent (Connection confirmed NOK)
     * 0xFF = Absence Detection is Masked (Diagnostics not active)
     *
     * @param u8AbsenceState The value which will be set
     */
    inline void setU8AbsenceState (uint8 u8AbsenceState_);

    // API of field "u8MuteState"

    static const int kU8MuteState = 3;

    /**
     * Clears the field "u8MuteState".
     *
     * The field will be set to its default value. The hasU8MuteState()
     * method will return false.
     */
    inline void clearU8MuteState();

    /**
     * Checks whether the field "u8MuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8MuteState()). Otherwise it will return false.
     */
    inline bool hasU8MuteState () const;

    /**
     * Returns the value of the member "u8MuteState".
     *
     * Indicates SENDING ERROR (MUTE)of CMF(Channel Management Frames)
     * 0x00 = CMF Not Muted - OK
     * 0x80 = CMF currently MUTE (Connection currently NOK)
     * 0xC0 = CMF Confirmed MUTE (Connection confirmed NOK)
     * 0xFF = MUTE Detection is Masked (Diagnostics not active)
     *
     * @return The value of the field "u8MuteState"
     */
    inline uint8 getU8MuteState () const;

    /**
     * Sets the value of the member "u8MuteState".
     *
     * Indicates SENDING ERROR (MUTE)of CMF(Channel Management Frames)
     * 0x00 = CMF Not Muted - OK
     * 0x80 = CMF currently MUTE (Connection currently NOK)
     * 0xC0 = CMF Confirmed MUTE (Connection confirmed NOK)
     * 0xFF = MUTE Detection is Masked (Diagnostics not active)
     *
     * @param u8MuteState The value which will be set
     */
    inline void setU8MuteState (uint8 u8MuteState_);

    static const T_SwCtrl_ConnectionStatus &getDefaultInstance();

private:

    inline void set_has_e8UnitType ();

    inline void clear_has_e8UnitType ();

    inline void set_has_bIsConnected ();

    inline void clear_has_bIsConnected ();

    inline void set_has_u8AbsenceState ();

    inline void clear_has_u8AbsenceState ();

    inline void set_has_u8MuteState ();

    inline void clear_has_u8MuteState ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e8_MCanUnitType _e8UnitType;

    bool _bIsConnected;

    uint8 _u8AbsenceState;

    uint8 _u8MuteState;

};

/**
 * Record type containing version information.
 */
class T_SwitchCtrl_VersionInfo {
public:

    /**
     * Default constructor
     */
    inline  T_SwitchCtrl_VersionInfo ();

    /**
     * Copy constructor
     */
    inline  T_SwitchCtrl_VersionInfo (const T_SwitchCtrl_VersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_SwitchCtrl_VersionInfo (uint8 u8Upper_, uint8 u8Mid_, uint8 u8Lower_);

    /**
     * Destructor
     */
    inline  ~T_SwitchCtrl_VersionInfo();

    /**
     * Assignment operator
     */
    inline T_SwitchCtrl_VersionInfo& operator = (const T_SwitchCtrl_VersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SwitchCtrl_VersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SwitchCtrl_VersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SwitchCtrl_VersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SwitchCtrl_VersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Upper"

    static const int kU8Upper = 0;

    /**
     * Clears the field "u8Upper".
     *
     * The field will be set to its default value. The hasU8Upper()
     * method will return false.
     */
    inline void clearU8Upper();

    /**
     * Checks whether the field "u8Upper" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Upper()). Otherwise it will return false.
     */
    inline bool hasU8Upper () const;

    /**
     * Returns the value of the member "u8Upper".
     *
     * Upper (= Major) version number.
     *
     * @return The value of the field "u8Upper"
     */
    inline uint8 getU8Upper () const;

    /**
     * Sets the value of the member "u8Upper".
     *
     * Upper (= Major) version number.
     *
     * @param u8Upper The value which will be set
     */
    inline void setU8Upper (uint8 u8Upper_);

    // API of field "u8Mid"

    static const int kU8Mid = 1;

    /**
     * Clears the field "u8Mid".
     *
     * The field will be set to its default value. The hasU8Mid()
     * method will return false.
     */
    inline void clearU8Mid();

    /**
     * Checks whether the field "u8Mid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Mid()). Otherwise it will return false.
     */
    inline bool hasU8Mid () const;

    /**
     * Returns the value of the member "u8Mid".
     *
     * Mid (= Minor) version number.
     *
     * @return The value of the field "u8Mid"
     */
    inline uint8 getU8Mid () const;

    /**
     * Sets the value of the member "u8Mid".
     *
     * Mid (= Minor) version number.
     *
     * @param u8Mid The value which will be set
     */
    inline void setU8Mid (uint8 u8Mid_);

    // API of field "u8Lower"

    static const int kU8Lower = 2;

    /**
     * Clears the field "u8Lower".
     *
     * The field will be set to its default value. The hasU8Lower()
     * method will return false.
     */
    inline void clearU8Lower();

    /**
     * Checks whether the field "u8Lower" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Lower()). Otherwise it will return false.
     */
    inline bool hasU8Lower () const;

    /**
     * Returns the value of the member "u8Lower".
     *
     * Lower (= Patch) version number.
     *
     * @return The value of the field "u8Lower"
     */
    inline uint8 getU8Lower () const;

    /**
     * Sets the value of the member "u8Lower".
     *
     * Lower (= Patch) version number.
     *
     * @param u8Lower The value which will be set
     */
    inline void setU8Lower (uint8 u8Lower_);

    static const T_SwitchCtrl_VersionInfo &getDefaultInstance();

private:

    inline void set_has_u8Upper ();

    inline void clear_has_u8Upper ();

    inline void set_has_u8Mid ();

    inline void clear_has_u8Mid ();

    inline void set_has_u8Lower ();

    inline void clear_has_u8Lower ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8Upper;

    uint8 _u8Mid;

    uint8 _u8Lower;

};

/**
 * Record type containing the version info of a MCAN unit.
 */
class T_SwitchCtrl_UnitVersion {
public:

    /**
     * Default constructor
     */
    inline  T_SwitchCtrl_UnitVersion ();

    /**
     * Copy constructor
     */
    inline  T_SwitchCtrl_UnitVersion (const T_SwitchCtrl_UnitVersion &rhs);

    /**
     * All fields constructor
     */
    inline  T_SwitchCtrl_UnitVersion (T_e8_MCanUnitType e8UnitType_, const T_SwitchCtrl_VersionInfo& rVersion_);

    /**
     * Destructor
     */
    inline  ~T_SwitchCtrl_UnitVersion();

    /**
     * Assignment operator
     */
    inline T_SwitchCtrl_UnitVersion& operator = (const T_SwitchCtrl_UnitVersion& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SwitchCtrl_UnitVersion& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SwitchCtrl_UnitVersion& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SwitchCtrl_UnitVersion& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SwitchCtrl_UnitVersion& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8UnitType"

    static const int kE8UnitType = 0;

    /**
     * Clears the field "e8UnitType".
     *
     * The field will be set to its default value. The hasE8UnitType()
     * method will return false.
     */
    inline void clearE8UnitType();

    /**
     * Checks whether the field "e8UnitType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8UnitType()). Otherwise it will return false.
     */
    inline bool hasE8UnitType () const;

    /**
     * Returns the value of the member "e8UnitType".
     *
     * Type of the unit.
     *
     * @return The value of the field "e8UnitType"
     */
    inline T_e8_MCanUnitType getE8UnitType () const;

    /**
     * Sets the value of the member "e8UnitType".
     *
     * Type of the unit.
     *
     * @param e8UnitType The value which will be set
     */
    inline void setE8UnitType (T_e8_MCanUnitType e8UnitType_);

    // API of field "rVersion"

    static const int kRVersion = 1;

    /**
     * Clears the field "rVersion".
     *
     * The field will be set to its default value. The hasRVersion()
     * method will return false.
     */
    inline void clearRVersion();

    /**
     * Checks whether the field "rVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRVersion()). Otherwise it will return false.
     */
    inline bool hasRVersion () const;

    /**
     * Returns the value of the member "rVersion".
     *
     * Record with information about the version.
     *
     * @return The value of the field "rVersion"
     */
    inline const T_SwitchCtrl_VersionInfo& getRVersion () const;

    /**
     * Retrieves the value of the field "rVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rVersion".
     */
    inline T_SwitchCtrl_VersionInfo& getRVersionMutable ();

    /**
     * Sets the value of the member "rVersion".
     *
     * Record with information about the version.
     *
     * @param rVersion The value which will be set
     */
    inline void setRVersion (const T_SwitchCtrl_VersionInfo& rVersion_);

    static const T_SwitchCtrl_UnitVersion &getDefaultInstance();

private:

    inline void set_has_e8UnitType ();

    inline void clear_has_e8UnitType ();

    inline void set_has_rVersion ();

    inline void clear_has_rVersion ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_MCanUnitType _e8UnitType;

    T_SwitchCtrl_VersionInfo _rVersion;

};

inline  T_SwCtrl_ConnectionStatus::T_SwCtrl_ConnectionStatus ()  :
    _e8UnitType (::switchctrl_main_fi_types::T_e8_MCanUnitType__RearSeat),
    _bIsConnected (false),
    _u8AbsenceState (0u),
    _u8MuteState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SwCtrl_ConnectionStatus::T_SwCtrl_ConnectionStatus (const T_SwCtrl_ConnectionStatus &rhs)  :
    _e8UnitType (::switchctrl_main_fi_types::T_e8_MCanUnitType__RearSeat),
    _bIsConnected (false),
    _u8AbsenceState (0u),
    _u8MuteState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SwCtrl_ConnectionStatus::T_SwCtrl_ConnectionStatus (T_e8_MCanUnitType e8UnitType_, bool bIsConnected_, uint8 u8AbsenceState_, uint8 u8MuteState_)  :
    _e8UnitType (e8UnitType_),
    _bIsConnected (bIsConnected_),
    _u8AbsenceState (u8AbsenceState_),
    _u8MuteState (u8MuteState_)
{
    #ifndef NDEBUG
    if (!(T_e8_MCanUnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_MCanUnitType", "e8UnitType", "T_SwCtrl_ConnectionStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SwCtrl_ConnectionStatus::~T_SwCtrl_ConnectionStatus() {
}

inline T_SwCtrl_ConnectionStatus& T_SwCtrl_ConnectionStatus::operator = (const T_SwCtrl_ConnectionStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8UnitType()) {
            setE8UnitType(rhs.getE8UnitType());
        } else {
            clearE8UnitType();
        }
        if (rhs.hasBIsConnected()) {
            setBIsConnected(rhs.getBIsConnected());
        } else {
            clearBIsConnected();
        }
        if (rhs.hasU8AbsenceState()) {
            setU8AbsenceState(rhs.getU8AbsenceState());
        } else {
            clearU8AbsenceState();
        }
        if (rhs.hasU8MuteState()) {
            setU8MuteState(rhs.getU8MuteState());
        } else {
            clearU8MuteState();
        }
    }
    return *this;
}

inline bool T_SwCtrl_ConnectionStatus::operator == (const T_SwCtrl_ConnectionStatus& rhs) const {
    return (((!hasE8UnitType() && !rhs.hasE8UnitType()) || getE8UnitType() == rhs.getE8UnitType()) &&
        ((!hasBIsConnected() && !rhs.hasBIsConnected()) || getBIsConnected() == rhs.getBIsConnected()) &&
        ((!hasU8AbsenceState() && !rhs.hasU8AbsenceState()) || getU8AbsenceState() == rhs.getU8AbsenceState()) &&
        ((!hasU8MuteState() && !rhs.hasU8MuteState()) || getU8MuteState() == rhs.getU8MuteState()));
}

inline bool T_SwCtrl_ConnectionStatus::operator != (const T_SwCtrl_ConnectionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SwCtrl_ConnectionStatus::operator < (const T_SwCtrl_ConnectionStatus& rhs) const {
    if (hasE8UnitType() || rhs.hasE8UnitType()) {
        if ((uint32)getE8UnitType() < (uint32)rhs.getE8UnitType()) return true;
        if ((uint32)getE8UnitType() > (uint32)rhs.getE8UnitType()) return false;
    }
    if (hasBIsConnected() || rhs.hasBIsConnected()) {
        if (getBIsConnected() < rhs.getBIsConnected()) return true;
        if (getBIsConnected() > rhs.getBIsConnected()) return false;
    }
    if (hasU8AbsenceState() || rhs.hasU8AbsenceState()) {
        if (getU8AbsenceState() < rhs.getU8AbsenceState()) return true;
        if (getU8AbsenceState() > rhs.getU8AbsenceState()) return false;
    }
    if (hasU8MuteState() || rhs.hasU8MuteState()) {
        if (getU8MuteState() < rhs.getU8MuteState()) return true;
        if (getU8MuteState() > rhs.getU8MuteState()) return false;
    }
    return false;
}

inline bool T_SwCtrl_ConnectionStatus::operator > (const T_SwCtrl_ConnectionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SwCtrl_ConnectionStatus::clear() {
    clearE8UnitType();
    clearBIsConnected();
    clearU8AbsenceState();
    clearU8MuteState();
}

inline void T_SwCtrl_ConnectionStatus::clearE8UnitType() {
    if (hasE8UnitType()) {
         clear_has_e8UnitType();
        _e8UnitType = ::switchctrl_main_fi_types::T_e8_MCanUnitType__RearSeat;
     }
}

inline bool T_SwCtrl_ConnectionStatus::hasE8UnitType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_MCanUnitType T_SwCtrl_ConnectionStatus::getE8UnitType () const {
    return _e8UnitType;
}

inline void T_SwCtrl_ConnectionStatus::setE8UnitType (T_e8_MCanUnitType e8UnitType_) {
    #ifndef NDEBUG
    if (!(T_e8_MCanUnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_MCanUnitType", "e8UnitType", "T_SwCtrl_ConnectionStatus");
    }
    #endif
    set_has_e8UnitType();
    this->_e8UnitType = e8UnitType_;
}

inline void T_SwCtrl_ConnectionStatus::clearBIsConnected() {
    if (hasBIsConnected()) {
         clear_has_bIsConnected();
        _bIsConnected = false;
     }
}

inline bool T_SwCtrl_ConnectionStatus::hasBIsConnected () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_SwCtrl_ConnectionStatus::getBIsConnected () const {
    return _bIsConnected;
}

inline void T_SwCtrl_ConnectionStatus::setBIsConnected (bool bIsConnected_) {
    set_has_bIsConnected();
    this->_bIsConnected = bIsConnected_;
}

inline void T_SwCtrl_ConnectionStatus::clearU8AbsenceState() {
    if (hasU8AbsenceState()) {
         clear_has_u8AbsenceState();
        _u8AbsenceState = 0u;
     }
}

inline bool T_SwCtrl_ConnectionStatus::hasU8AbsenceState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_SwCtrl_ConnectionStatus::getU8AbsenceState () const {
    return _u8AbsenceState;
}

inline void T_SwCtrl_ConnectionStatus::setU8AbsenceState (uint8 u8AbsenceState_) {
    set_has_u8AbsenceState();
    this->_u8AbsenceState = u8AbsenceState_;
}

inline void T_SwCtrl_ConnectionStatus::clearU8MuteState() {
    if (hasU8MuteState()) {
         clear_has_u8MuteState();
        _u8MuteState = 0u;
     }
}

inline bool T_SwCtrl_ConnectionStatus::hasU8MuteState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_SwCtrl_ConnectionStatus::getU8MuteState () const {
    return _u8MuteState;
}

inline void T_SwCtrl_ConnectionStatus::setU8MuteState (uint8 u8MuteState_) {
    set_has_u8MuteState();
    this->_u8MuteState = u8MuteState_;
}

inline void T_SwCtrl_ConnectionStatus::set_has_e8UnitType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SwCtrl_ConnectionStatus::clear_has_e8UnitType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SwCtrl_ConnectionStatus::set_has_bIsConnected () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SwCtrl_ConnectionStatus::clear_has_bIsConnected () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SwCtrl_ConnectionStatus::set_has_u8AbsenceState () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SwCtrl_ConnectionStatus::clear_has_u8AbsenceState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SwCtrl_ConnectionStatus::set_has_u8MuteState () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SwCtrl_ConnectionStatus::clear_has_u8MuteState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_SwitchCtrl_VersionInfo::T_SwitchCtrl_VersionInfo ()  :
    _u8Upper (0u),
    _u8Mid (0u),
    _u8Lower (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SwitchCtrl_VersionInfo::T_SwitchCtrl_VersionInfo (const T_SwitchCtrl_VersionInfo &rhs)  :
    _u8Upper (0u),
    _u8Mid (0u),
    _u8Lower (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SwitchCtrl_VersionInfo::T_SwitchCtrl_VersionInfo (uint8 u8Upper_, uint8 u8Mid_, uint8 u8Lower_)  :
    _u8Upper (u8Upper_),
    _u8Mid (u8Mid_),
    _u8Lower (u8Lower_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SwitchCtrl_VersionInfo::~T_SwitchCtrl_VersionInfo() {
}

inline T_SwitchCtrl_VersionInfo& T_SwitchCtrl_VersionInfo::operator = (const T_SwitchCtrl_VersionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Upper()) {
            setU8Upper(rhs.getU8Upper());
        } else {
            clearU8Upper();
        }
        if (rhs.hasU8Mid()) {
            setU8Mid(rhs.getU8Mid());
        } else {
            clearU8Mid();
        }
        if (rhs.hasU8Lower()) {
            setU8Lower(rhs.getU8Lower());
        } else {
            clearU8Lower();
        }
    }
    return *this;
}

inline bool T_SwitchCtrl_VersionInfo::operator == (const T_SwitchCtrl_VersionInfo& rhs) const {
    return (((!hasU8Upper() && !rhs.hasU8Upper()) || getU8Upper() == rhs.getU8Upper()) &&
        ((!hasU8Mid() && !rhs.hasU8Mid()) || getU8Mid() == rhs.getU8Mid()) &&
        ((!hasU8Lower() && !rhs.hasU8Lower()) || getU8Lower() == rhs.getU8Lower()));
}

inline bool T_SwitchCtrl_VersionInfo::operator != (const T_SwitchCtrl_VersionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SwitchCtrl_VersionInfo::operator < (const T_SwitchCtrl_VersionInfo& rhs) const {
    if (hasU8Upper() || rhs.hasU8Upper()) {
        if (getU8Upper() < rhs.getU8Upper()) return true;
        if (getU8Upper() > rhs.getU8Upper()) return false;
    }
    if (hasU8Mid() || rhs.hasU8Mid()) {
        if (getU8Mid() < rhs.getU8Mid()) return true;
        if (getU8Mid() > rhs.getU8Mid()) return false;
    }
    if (hasU8Lower() || rhs.hasU8Lower()) {
        if (getU8Lower() < rhs.getU8Lower()) return true;
        if (getU8Lower() > rhs.getU8Lower()) return false;
    }
    return false;
}

inline bool T_SwitchCtrl_VersionInfo::operator > (const T_SwitchCtrl_VersionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SwitchCtrl_VersionInfo::clear() {
    clearU8Upper();
    clearU8Mid();
    clearU8Lower();
}

inline void T_SwitchCtrl_VersionInfo::clearU8Upper() {
    if (hasU8Upper()) {
         clear_has_u8Upper();
        _u8Upper = 0u;
     }
}

inline bool T_SwitchCtrl_VersionInfo::hasU8Upper () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SwitchCtrl_VersionInfo::getU8Upper () const {
    return _u8Upper;
}

inline void T_SwitchCtrl_VersionInfo::setU8Upper (uint8 u8Upper_) {
    set_has_u8Upper();
    this->_u8Upper = u8Upper_;
}

inline void T_SwitchCtrl_VersionInfo::clearU8Mid() {
    if (hasU8Mid()) {
         clear_has_u8Mid();
        _u8Mid = 0u;
     }
}

inline bool T_SwitchCtrl_VersionInfo::hasU8Mid () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_SwitchCtrl_VersionInfo::getU8Mid () const {
    return _u8Mid;
}

inline void T_SwitchCtrl_VersionInfo::setU8Mid (uint8 u8Mid_) {
    set_has_u8Mid();
    this->_u8Mid = u8Mid_;
}

inline void T_SwitchCtrl_VersionInfo::clearU8Lower() {
    if (hasU8Lower()) {
         clear_has_u8Lower();
        _u8Lower = 0u;
     }
}

inline bool T_SwitchCtrl_VersionInfo::hasU8Lower () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_SwitchCtrl_VersionInfo::getU8Lower () const {
    return _u8Lower;
}

inline void T_SwitchCtrl_VersionInfo::setU8Lower (uint8 u8Lower_) {
    set_has_u8Lower();
    this->_u8Lower = u8Lower_;
}

inline void T_SwitchCtrl_VersionInfo::set_has_u8Upper () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SwitchCtrl_VersionInfo::clear_has_u8Upper () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SwitchCtrl_VersionInfo::set_has_u8Mid () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SwitchCtrl_VersionInfo::clear_has_u8Mid () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SwitchCtrl_VersionInfo::set_has_u8Lower () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SwitchCtrl_VersionInfo::clear_has_u8Lower () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SwitchCtrl_UnitVersion::T_SwitchCtrl_UnitVersion ()  :
    _e8UnitType (::switchctrl_main_fi_types::T_e8_MCanUnitType__RearSeat),
    _rVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SwitchCtrl_UnitVersion::T_SwitchCtrl_UnitVersion (const T_SwitchCtrl_UnitVersion &rhs)  :
    _e8UnitType (::switchctrl_main_fi_types::T_e8_MCanUnitType__RearSeat),
    _rVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SwitchCtrl_UnitVersion::T_SwitchCtrl_UnitVersion (T_e8_MCanUnitType e8UnitType_, const T_SwitchCtrl_VersionInfo& rVersion_)  :
    _e8UnitType (e8UnitType_),
    _rVersion (rVersion_)
{
    #ifndef NDEBUG
    if (!(T_e8_MCanUnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_MCanUnitType", "e8UnitType", "T_SwitchCtrl_UnitVersion");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SwitchCtrl_UnitVersion::~T_SwitchCtrl_UnitVersion() {
}

inline T_SwitchCtrl_UnitVersion& T_SwitchCtrl_UnitVersion::operator = (const T_SwitchCtrl_UnitVersion& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8UnitType()) {
            setE8UnitType(rhs.getE8UnitType());
        } else {
            clearE8UnitType();
        }
        if (rhs.hasRVersion()) {
            setRVersion(rhs.getRVersion());
        } else {
            clearRVersion();
        }
    }
    return *this;
}

inline bool T_SwitchCtrl_UnitVersion::operator == (const T_SwitchCtrl_UnitVersion& rhs) const {
    return (((!hasE8UnitType() && !rhs.hasE8UnitType()) || getE8UnitType() == rhs.getE8UnitType()) &&
        ((!hasRVersion() && !rhs.hasRVersion()) || getRVersion() == rhs.getRVersion()));
}

inline bool T_SwitchCtrl_UnitVersion::operator != (const T_SwitchCtrl_UnitVersion& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SwitchCtrl_UnitVersion::operator < (const T_SwitchCtrl_UnitVersion& rhs) const {
    if (hasE8UnitType() || rhs.hasE8UnitType()) {
        if ((uint32)getE8UnitType() < (uint32)rhs.getE8UnitType()) return true;
        if ((uint32)getE8UnitType() > (uint32)rhs.getE8UnitType()) return false;
    }
    if (hasRVersion() || rhs.hasRVersion()) {
        if (getRVersion() < rhs.getRVersion()) return true;
        if (getRVersion() > rhs.getRVersion()) return false;
    }
    return false;
}

inline bool T_SwitchCtrl_UnitVersion::operator > (const T_SwitchCtrl_UnitVersion& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SwitchCtrl_UnitVersion::clear() {
    clearE8UnitType();
    clearRVersion();
}

inline void T_SwitchCtrl_UnitVersion::clearE8UnitType() {
    if (hasE8UnitType()) {
         clear_has_e8UnitType();
        _e8UnitType = ::switchctrl_main_fi_types::T_e8_MCanUnitType__RearSeat;
     }
}

inline bool T_SwitchCtrl_UnitVersion::hasE8UnitType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_MCanUnitType T_SwitchCtrl_UnitVersion::getE8UnitType () const {
    return _e8UnitType;
}

inline void T_SwitchCtrl_UnitVersion::setE8UnitType (T_e8_MCanUnitType e8UnitType_) {
    #ifndef NDEBUG
    if (!(T_e8_MCanUnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_MCanUnitType", "e8UnitType", "T_SwitchCtrl_UnitVersion");
    }
    #endif
    set_has_e8UnitType();
    this->_e8UnitType = e8UnitType_;
}

inline void T_SwitchCtrl_UnitVersion::clearRVersion() {
    if (hasRVersion()) {
         clear_has_rVersion();
        _rVersion.clear();
     }
}

inline bool T_SwitchCtrl_UnitVersion::hasRVersion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_SwitchCtrl_VersionInfo& T_SwitchCtrl_UnitVersion::getRVersion () const {
    return _rVersion;
}

inline T_SwitchCtrl_VersionInfo& T_SwitchCtrl_UnitVersion::getRVersionMutable () {
    set_has_rVersion();
    return _rVersion;
}

inline void T_SwitchCtrl_UnitVersion::setRVersion (const T_SwitchCtrl_VersionInfo& rVersion_) {
    set_has_rVersion();
    this->_rVersion = rVersion_;
}

inline void T_SwitchCtrl_UnitVersion::set_has_e8UnitType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SwitchCtrl_UnitVersion::clear_has_e8UnitType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SwitchCtrl_UnitVersion::set_has_rVersion () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SwitchCtrl_UnitVersion::clear_has_rVersion () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace switchctrl_main_fi_types

#endif // SWITCHCTRL_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
