/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "switchctrl_main_fiCca.h"
#include "switchctrl_main_fiJson.h"
#include "switchctrl_main_fiProxy.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace switchctrl_main_fi {

/*static*/ ::asf::core::Logger Switchctrl_main_fiProxy::_logger ("/switchctrl_main_fi/Switchctrl_main_fiProxy");


class Switchctrl_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Switchctrl_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Switchctrl_main_fiProxy> proxy = ::boost::static_pointer_cast<Switchctrl_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_ResetHistory: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::ResetHistoryResult);
                                setActAndLogResult(message, "ResetHistory", reinterpret_cast<act_t>(this), _logger);
                                ((ResetHistoryCallbackIF*) _callback)->onResetHistoryResult (proxy, ::boost::static_pointer_cast<ResetHistoryResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::ResetHistoryError);
                                setActAndLogError(message, "ResetHistory", reinterpret_cast<act_t>(this), _logger);
                                ((ResetHistoryCallbackIF*) _callback)->onResetHistoryError (proxy, ::boost::static_pointer_cast<ResetHistoryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_VersionInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::VersionInfoResult);
                                setActAndLogResult(message, "VersionInfo", reinterpret_cast<act_t>(this), _logger);
                                ((VersionInfoCallbackIF*) _callback)->onVersionInfoResult (proxy, ::boost::static_pointer_cast<VersionInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::VersionInfoError);
                                setActAndLogError(message, "VersionInfo", reinterpret_cast<act_t>(this), _logger);
                                ((VersionInfoCallbackIF*) _callback)->onVersionInfoError (proxy, ::boost::static_pointer_cast<VersionInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_BeepInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::BeepInfoResult);
                                setActAndLogResult(message, "BeepInfo", reinterpret_cast<act_t>(this), _logger);
                                ((BeepInfoCallbackIF*) _callback)->onBeepInfoResult (proxy, ::boost::static_pointer_cast<BeepInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::BeepInfoError);
                                setActAndLogError(message, "BeepInfo", reinterpret_cast<act_t>(this), _logger);
                                ((BeepInfoCallbackIF*) _callback)->onBeepInfoError (proxy, ::boost::static_pointer_cast<BeepInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RearSeat_Connection: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::RearSeat_ConnectionStatus);
                                setActAndLogStatus(message, "RearSeat_Connection", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RearSeat_ConnectionStatus> payload = ::boost::static_pointer_cast<RearSeat_ConnectionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RearSeat_ConnectionStatus >& refNullableStatus = proxy->_rearSeat_Connection;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RearSeat_ConnectionCallbackIF*) _callback)->onRearSeat_ConnectionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((RearSeat_ConnectionCallbackIF*) _callback)->onRearSeat_ConnectionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::RearSeat_ConnectionError);
                                setActAndLogError(message, "RearSeat_Connection", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((RearSeat_ConnectionCallbackIF*) _callback)->onRearSeat_ConnectionError(proxy, ::boost::static_pointer_cast<RearSeat_ConnectionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ITCommander_Connection: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::ITCommander_ConnectionStatus);
                                setActAndLogStatus(message, "ITCommander_Connection", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ITCommander_ConnectionStatus> payload = ::boost::static_pointer_cast<ITCommander_ConnectionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ITCommander_ConnectionStatus >& refNullableStatus = proxy->_iTCommander_Connection;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ITCommander_ConnectionCallbackIF*) _callback)->onITCommander_ConnectionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ITCommander_ConnectionCallbackIF*) _callback)->onITCommander_ConnectionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::ITCommander_ConnectionError);
                                setActAndLogError(message, "ITCommander_Connection", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ITCommander_ConnectionCallbackIF*) _callback)->onITCommander_ConnectionError(proxy, ::boost::static_pointer_cast<ITCommander_ConnectionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_HardwareVersion: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::HardwareVersionStatus);
                                setActAndLogStatus(message, "HardwareVersion", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<HardwareVersionStatus> payload = ::boost::static_pointer_cast<HardwareVersionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< HardwareVersionStatus >& refNullableStatus = proxy->_hardwareVersion;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((HardwareVersionCallbackIF*) _callback)->onHardwareVersionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((HardwareVersionCallbackIF*) _callback)->onHardwareVersionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::HardwareVersionError);
                                setActAndLogError(message, "HardwareVersion", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((HardwareVersionCallbackIF*) _callback)->onHardwareVersionError(proxy, ::boost::static_pointer_cast<HardwareVersionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SoftwareVersion: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::SoftwareVersionStatus);
                                setActAndLogStatus(message, "SoftwareVersion", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SoftwareVersionStatus> payload = ::boost::static_pointer_cast<SoftwareVersionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SoftwareVersionStatus >& refNullableStatus = proxy->_softwareVersion;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SoftwareVersionCallbackIF*) _callback)->onSoftwareVersionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SoftwareVersionCallbackIF*) _callback)->onSoftwareVersionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::SoftwareVersionError);
                                setActAndLogError(message, "SoftwareVersion", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SoftwareVersionCallbackIF*) _callback)->onSoftwareVersionError(proxy, ::boost::static_pointer_cast<SoftwareVersionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PrimaryIntegratedSwitch_Connection: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::PrimaryIntegratedSwitch_ConnectionStatus);
                                setActAndLogStatus(message, "PrimaryIntegratedSwitch_Connection", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<PrimaryIntegratedSwitch_ConnectionStatus> payload = ::boost::static_pointer_cast<PrimaryIntegratedSwitch_ConnectionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< PrimaryIntegratedSwitch_ConnectionStatus >& refNullableStatus = proxy->_primaryIntegratedSwitch_Connection;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((PrimaryIntegratedSwitch_ConnectionCallbackIF*) _callback)->onPrimaryIntegratedSwitch_ConnectionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((PrimaryIntegratedSwitch_ConnectionCallbackIF*) _callback)->onPrimaryIntegratedSwitch_ConnectionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::switchctrl_main_fi::PrimaryIntegratedSwitch_ConnectionError);
                                setActAndLogError(message, "PrimaryIntegratedSwitch_Connection", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((PrimaryIntegratedSwitch_ConnectionCallbackIF*) _callback)->onPrimaryIntegratedSwitch_ConnectionError(proxy, ::boost::static_pointer_cast<PrimaryIntegratedSwitch_ConnectionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Switchctrl_main_fiProxy> proxy = ::boost::static_pointer_cast<Switchctrl_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_ResetHistory: {
                ::boost::shared_ptr< ResetHistoryError > payload (new ResetHistoryError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResetHistory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ResetHistoryCallbackIF*) _callback)->onResetHistoryError (proxy, payload);
                return true;
            }
            case FID_VersionInfo: {
                ::boost::shared_ptr< VersionInfoError > payload (new VersionInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VersionInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((VersionInfoCallbackIF*) _callback)->onVersionInfoError (proxy, payload);
                return true;
            }
            case FID_BeepInfo: {
                ::boost::shared_ptr< BeepInfoError > payload (new BeepInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BeepInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((BeepInfoCallbackIF*) _callback)->onBeepInfoError (proxy, payload);
                return true;
            }
            case FID_RearSeat_Connection: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< RearSeat_ConnectionError > payload (new RearSeat_ConnectionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RearSeat_Connection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RearSeat_ConnectionCallbackIF*) _callback)->onRearSeat_ConnectionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ITCommander_Connection: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ITCommander_ConnectionError > payload (new ITCommander_ConnectionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ITCommander_Connection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ITCommander_ConnectionCallbackIF*) _callback)->onITCommander_ConnectionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_HardwareVersion: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< HardwareVersionError > payload (new HardwareVersionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HardwareVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((HardwareVersionCallbackIF*) _callback)->onHardwareVersionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SoftwareVersion: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SoftwareVersionError > payload (new SoftwareVersionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SoftwareVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SoftwareVersionCallbackIF*) _callback)->onSoftwareVersionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_PrimaryIntegratedSwitch_Connection: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< PrimaryIntegratedSwitch_ConnectionError > payload (new PrimaryIntegratedSwitch_ConnectionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PrimaryIntegratedSwitch_Connection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((PrimaryIntegratedSwitch_ConnectionCallbackIF*) _callback)->onPrimaryIntegratedSwitch_ConnectionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Switchctrl_main_fiProxyCallback::_logger (Switchctrl_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Switchctrl_main_fiProxy > Switchctrl_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Switchctrl_main_fiProxy >  proxyNew(new Switchctrl_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Switchctrl_main_fiProxy > Switchctrl_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Switchctrl_main_fiProxy >  proxyNew(new Switchctrl_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Switchctrl_main_fiProxy > Switchctrl_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Switchctrl_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Switchctrl_main_fiProxy >  proxyNew(new Switchctrl_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Switchctrl_main_fiProxy::Switchctrl_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Switchctrl_main_fiProxy::~Switchctrl_main_fiProxy()
{
    LOG_INFO ("Entering ~Switchctrl_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Switchctrl_main_fiProxy::sendResetHistoryStart(ResetHistoryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ResetHistory);
        ::boost::shared_ptr< ResetHistoryStart > payload (new ResetHistoryStart());
        CCA_MESSAGE(ccaMessage,header,ResetHistoryStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ResetHistory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetHistory);
        ::boost::shared_ptr< ResetHistoryError > payload (new ResetHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ResetHistory", &cb);
    }
}

act_t Switchctrl_main_fiProxy::sendVersionInfoStart(VersionInfoCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_VersionInfo);
        ::boost::shared_ptr< VersionInfoStart > payload (new VersionInfoStart());
        CCA_MESSAGE(ccaMessage,header,VersionInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "VersionInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VersionInfo);
        ::boost::shared_ptr< VersionInfoError > payload (new VersionInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VersionInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "VersionInfo", &cb);
    }
}

act_t Switchctrl_main_fiProxy::sendBeepInfoStart(BeepInfoCallbackIF& cb, uint8 u8NoOfBeeps, uint8 u8BeepTime, uint8 u8Period) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_BeepInfo);
        ::boost::shared_ptr< BeepInfoStart > payload (new BeepInfoStart());
        payload->setU8NoOfBeeps(u8NoOfBeeps);
        payload->setU8BeepTime(u8BeepTime);
        payload->setU8Period(u8Period);
        CCA_MESSAGE(ccaMessage,header,BeepInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "BeepInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_BeepInfo);
        ::boost::shared_ptr< BeepInfoError > payload (new BeepInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BeepInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "BeepInfo", &cb);
    }
}

act_t Switchctrl_main_fiProxy::sendRearSeat_ConnectionUpReg(RearSeat_ConnectionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RearSeat_Connection);
        ::boost::shared_ptr< RearSeat_ConnectionUpReg > payload (new RearSeat_ConnectionUpReg());
        CCA_MESSAGE(ccaMessage,header,RearSeat_ConnectionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RearSeat_ConnectionRelUpReg > payloadRelUpRegHeap (new RearSeat_ConnectionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RearSeat_Connection, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::switchctrl_main_fi::RearSeat_ConnectionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RearSeat_Connection, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RearSeat_Connection", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RearSeat_Connection", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRearSeat_Connection()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RearSeat_Connection, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RearSeat_ConnectionStatus > payloadLoopback (new RearSeat_ConnectionStatus(getRearSeat_Connection()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RearSeat_ConnectionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RearSeat_Connection);
        ::boost::shared_ptr< RearSeat_ConnectionError > payload (new RearSeat_ConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RearSeat_ConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RearSeat_Connection", &cb);
    }
}

bool Switchctrl_main_fiProxy::sendRearSeat_ConnectionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RearSeat_Connection,"RearSeat_Connection");
}

void Switchctrl_main_fiProxy::sendRearSeat_ConnectionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RearSeat_Connection);
}

const RearSeat_ConnectionStatus& Switchctrl_main_fiProxy::getRearSeat_Connection() const {
    return _rearSeat_Connection.get();
}

bool Switchctrl_main_fiProxy::hasRearSeat_Connection() const {
    return _rearSeat_Connection.hasValue();
}

act_t Switchctrl_main_fiProxy::sendRearSeat_ConnectionGet(RearSeat_ConnectionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RearSeat_Connection);
        ::boost::shared_ptr< RearSeat_ConnectionGet > payload (new RearSeat_ConnectionGet());
        CCA_MESSAGE(ccaMessage,header,RearSeat_ConnectionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RearSeat_Connection", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RearSeat_Connection);
        ::boost::shared_ptr< RearSeat_ConnectionError > payload (new RearSeat_ConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RearSeat_ConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RearSeat_Connection", &cb);
    }
}

act_t Switchctrl_main_fiProxy::sendITCommander_ConnectionUpReg(ITCommander_ConnectionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ITCommander_Connection);
        ::boost::shared_ptr< ITCommander_ConnectionUpReg > payload (new ITCommander_ConnectionUpReg());
        CCA_MESSAGE(ccaMessage,header,ITCommander_ConnectionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ITCommander_ConnectionRelUpReg > payloadRelUpRegHeap (new ITCommander_ConnectionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ITCommander_Connection, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::switchctrl_main_fi::ITCommander_ConnectionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ITCommander_Connection, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ITCommander_Connection", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ITCommander_Connection", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasITCommander_Connection()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ITCommander_Connection, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ITCommander_ConnectionStatus > payloadLoopback (new ITCommander_ConnectionStatus(getITCommander_Connection()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ITCommander_ConnectionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ITCommander_Connection);
        ::boost::shared_ptr< ITCommander_ConnectionError > payload (new ITCommander_ConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ITCommander_ConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ITCommander_Connection", &cb);
    }
}

bool Switchctrl_main_fiProxy::sendITCommander_ConnectionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ITCommander_Connection,"ITCommander_Connection");
}

void Switchctrl_main_fiProxy::sendITCommander_ConnectionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ITCommander_Connection);
}

const ITCommander_ConnectionStatus& Switchctrl_main_fiProxy::getITCommander_Connection() const {
    return _iTCommander_Connection.get();
}

bool Switchctrl_main_fiProxy::hasITCommander_Connection() const {
    return _iTCommander_Connection.hasValue();
}

act_t Switchctrl_main_fiProxy::sendITCommander_ConnectionGet(ITCommander_ConnectionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ITCommander_Connection);
        ::boost::shared_ptr< ITCommander_ConnectionGet > payload (new ITCommander_ConnectionGet());
        CCA_MESSAGE(ccaMessage,header,ITCommander_ConnectionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ITCommander_Connection", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ITCommander_Connection);
        ::boost::shared_ptr< ITCommander_ConnectionError > payload (new ITCommander_ConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ITCommander_ConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ITCommander_Connection", &cb);
    }
}

act_t Switchctrl_main_fiProxy::sendHardwareVersionUpReg(HardwareVersionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_HardwareVersion);
        ::boost::shared_ptr< HardwareVersionUpReg > payload (new HardwareVersionUpReg());
        CCA_MESSAGE(ccaMessage,header,HardwareVersionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< HardwareVersionRelUpReg > payloadRelUpRegHeap (new HardwareVersionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_HardwareVersion, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::switchctrl_main_fi::HardwareVersionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_HardwareVersion, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "HardwareVersion", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "HardwareVersion", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasHardwareVersion()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_HardwareVersion, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< HardwareVersionStatus > payloadLoopback (new HardwareVersionStatus(getHardwareVersion()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,HardwareVersionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HardwareVersion);
        ::boost::shared_ptr< HardwareVersionError > payload (new HardwareVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HardwareVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "HardwareVersion", &cb);
    }
}

bool Switchctrl_main_fiProxy::sendHardwareVersionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_HardwareVersion,"HardwareVersion");
}

void Switchctrl_main_fiProxy::sendHardwareVersionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_HardwareVersion);
}

const HardwareVersionStatus& Switchctrl_main_fiProxy::getHardwareVersion() const {
    return _hardwareVersion.get();
}

bool Switchctrl_main_fiProxy::hasHardwareVersion() const {
    return _hardwareVersion.hasValue();
}

act_t Switchctrl_main_fiProxy::sendHardwareVersionGet(HardwareVersionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_HardwareVersion);
        ::boost::shared_ptr< HardwareVersionGet > payload (new HardwareVersionGet());
        CCA_MESSAGE(ccaMessage,header,HardwareVersionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "HardwareVersion", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HardwareVersion);
        ::boost::shared_ptr< HardwareVersionError > payload (new HardwareVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HardwareVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "HardwareVersion", &cb);
    }
}

act_t Switchctrl_main_fiProxy::sendSoftwareVersionUpReg(SoftwareVersionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SoftwareVersion);
        ::boost::shared_ptr< SoftwareVersionUpReg > payload (new SoftwareVersionUpReg());
        CCA_MESSAGE(ccaMessage,header,SoftwareVersionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SoftwareVersionRelUpReg > payloadRelUpRegHeap (new SoftwareVersionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SoftwareVersion, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::switchctrl_main_fi::SoftwareVersionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SoftwareVersion, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SoftwareVersion", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SoftwareVersion", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSoftwareVersion()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SoftwareVersion, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SoftwareVersionStatus > payloadLoopback (new SoftwareVersionStatus(getSoftwareVersion()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SoftwareVersionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SoftwareVersion);
        ::boost::shared_ptr< SoftwareVersionError > payload (new SoftwareVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SoftwareVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SoftwareVersion", &cb);
    }
}

bool Switchctrl_main_fiProxy::sendSoftwareVersionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SoftwareVersion,"SoftwareVersion");
}

void Switchctrl_main_fiProxy::sendSoftwareVersionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SoftwareVersion);
}

const SoftwareVersionStatus& Switchctrl_main_fiProxy::getSoftwareVersion() const {
    return _softwareVersion.get();
}

bool Switchctrl_main_fiProxy::hasSoftwareVersion() const {
    return _softwareVersion.hasValue();
}

act_t Switchctrl_main_fiProxy::sendSoftwareVersionGet(SoftwareVersionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SoftwareVersion);
        ::boost::shared_ptr< SoftwareVersionGet > payload (new SoftwareVersionGet());
        CCA_MESSAGE(ccaMessage,header,SoftwareVersionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SoftwareVersion", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SoftwareVersion);
        ::boost::shared_ptr< SoftwareVersionError > payload (new SoftwareVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SoftwareVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SoftwareVersion", &cb);
    }
}

act_t Switchctrl_main_fiProxy::sendPrimaryIntegratedSwitch_ConnectionUpReg(PrimaryIntegratedSwitch_ConnectionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_PrimaryIntegratedSwitch_Connection);
        ::boost::shared_ptr< PrimaryIntegratedSwitch_ConnectionUpReg > payload (new PrimaryIntegratedSwitch_ConnectionUpReg());
        CCA_MESSAGE(ccaMessage,header,PrimaryIntegratedSwitch_ConnectionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< PrimaryIntegratedSwitch_ConnectionRelUpReg > payloadRelUpRegHeap (new PrimaryIntegratedSwitch_ConnectionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_PrimaryIntegratedSwitch_Connection, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::switchctrl_main_fi::PrimaryIntegratedSwitch_ConnectionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_PrimaryIntegratedSwitch_Connection, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "PrimaryIntegratedSwitch_Connection", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "PrimaryIntegratedSwitch_Connection", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasPrimaryIntegratedSwitch_Connection()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_PrimaryIntegratedSwitch_Connection, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< PrimaryIntegratedSwitch_ConnectionStatus > payloadLoopback (new PrimaryIntegratedSwitch_ConnectionStatus(getPrimaryIntegratedSwitch_Connection()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,PrimaryIntegratedSwitch_ConnectionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PrimaryIntegratedSwitch_Connection);
        ::boost::shared_ptr< PrimaryIntegratedSwitch_ConnectionError > payload (new PrimaryIntegratedSwitch_ConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PrimaryIntegratedSwitch_ConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "PrimaryIntegratedSwitch_Connection", &cb);
    }
}

bool Switchctrl_main_fiProxy::sendPrimaryIntegratedSwitch_ConnectionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_PrimaryIntegratedSwitch_Connection,"PrimaryIntegratedSwitch_Connection");
}

void Switchctrl_main_fiProxy::sendPrimaryIntegratedSwitch_ConnectionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_PrimaryIntegratedSwitch_Connection);
}

const PrimaryIntegratedSwitch_ConnectionStatus& Switchctrl_main_fiProxy::getPrimaryIntegratedSwitch_Connection() const {
    return _primaryIntegratedSwitch_Connection.get();
}

bool Switchctrl_main_fiProxy::hasPrimaryIntegratedSwitch_Connection() const {
    return _primaryIntegratedSwitch_Connection.hasValue();
}

act_t Switchctrl_main_fiProxy::sendPrimaryIntegratedSwitch_ConnectionGet(PrimaryIntegratedSwitch_ConnectionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_PrimaryIntegratedSwitch_Connection);
        ::boost::shared_ptr< PrimaryIntegratedSwitch_ConnectionGet > payload (new PrimaryIntegratedSwitch_ConnectionGet());
        CCA_MESSAGE(ccaMessage,header,PrimaryIntegratedSwitch_ConnectionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "PrimaryIntegratedSwitch_Connection", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PrimaryIntegratedSwitch_Connection);
        ::boost::shared_ptr< PrimaryIntegratedSwitch_ConnectionError > payload (new PrimaryIntegratedSwitch_ConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PrimaryIntegratedSwitch_ConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "PrimaryIntegratedSwitch_Connection", &cb);
    }
}


void Switchctrl_main_fiProxy::clearAllProperties ()
{
    _rearSeat_Connection = ::asf::core::nullable<RearSeat_ConnectionStatus>();
    _iTCommander_Connection = ::asf::core::nullable<ITCommander_ConnectionStatus>();
    _hardwareVersion = ::asf::core::nullable<HardwareVersionStatus>();
    _softwareVersion = ::asf::core::nullable<SoftwareVersionStatus>();
    _primaryIntegratedSwitch_Connection = ::asf::core::nullable<PrimaryIntegratedSwitch_ConnectionStatus>();
}

void Switchctrl_main_fiProxy::sendRelUpRegAll()
{
    sendRearSeat_ConnectionRelUpRegAll();
    sendITCommander_ConnectionRelUpRegAll();
    sendHardwareVersionRelUpRegAll();
    sendSoftwareVersionRelUpRegAll();
    sendPrimaryIntegratedSwitch_ConnectionRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Switchctrl_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Switchctrl_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace switchctrl_main_fi
