#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SWITCHCTRL_MAIN_FI_H
#define SWITCHCTRL_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "switchctrl_main_fi_types.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'switchctrl_main_fi'
 *
 * Fullname: SwitchCtrl CCA Service, Application Functional Interface
 *
 * Version:
 *
 * Author: Sandeep Gupta (RBEI/ECV)
 *
 * Date: $Date: 12 Nov 2015 09:00:00  $
 *
 * Department:
 *
 * Title: SWITCH_CONTROL_FI
 *
 * <b>Description of 'switchctrl_main_fi':</b>
 *
 * SwitchCtrl_FI messages for CCA applications
 */

namespace switchctrl_main_fi {

static const int SERVICE_ID = 184;

static const int FID_RearSeat_Connection = 1;

static const int FID_ITCommander_Connection = 2;

static const int FID_HardwareVersion = 3;

static const int FID_SoftwareVersion = 4;

static const int FID_PrimaryIntegratedSwitch_Connection = 5;

static const int FID_ResetHistory = 4096;

static const int FID_VersionInfo = 4097;

static const int FID_BeepInfo = 4098;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 2;

// forward declarations
class RearSeat_ConnectionStatus;

class ITCommander_ConnectionStatus;

class HardwareVersionStatus;

class SoftwareVersionStatus;

class PrimaryIntegratedSwitch_ConnectionStatus;

class BeepInfoStart;

// type definitions
/**
 * The get message of the property "RearSeat_Connection"
 * This property gives information about the connection status to the Rear Seat MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RearSeat_ConnectionGet;

/**
 * The upreg message of the property "RearSeat_Connection"
 * This property gives information about the connection status to the Rear Seat MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RearSeat_ConnectionUpReg;

/**
 * The relUpReg message of the property "RearSeat_Connection"
 * This property gives information about the connection status to the Rear Seat MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RearSeat_ConnectionRelUpReg;

/**
 * The error message of 'RearSeat_Connection'
 */
typedef ::asf::cca::CcaTypes::DefaultError RearSeat_ConnectionError;

/**
 * The get message of the property "ITCommander_Connection"
 * This property gives information about the connection status to the IT Commander MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ITCommander_ConnectionGet;

/**
 * The upreg message of the property "ITCommander_Connection"
 * This property gives information about the connection status to the IT Commander MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ITCommander_ConnectionUpReg;

/**
 * The relUpReg message of the property "ITCommander_Connection"
 * This property gives information about the connection status to the IT Commander MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ITCommander_ConnectionRelUpReg;

/**
 * The error message of 'ITCommander_Connection'
 */
typedef ::asf::cca::CcaTypes::DefaultError ITCommander_ConnectionError;

/**
 * The get message of the property "HardwareVersion"
 * This property gives information about the hardware version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HardwareVersionGet;

/**
 * The upreg message of the property "HardwareVersion"
 * This property gives information about the hardware version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HardwareVersionUpReg;

/**
 * The relUpReg message of the property "HardwareVersion"
 * This property gives information about the hardware version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HardwareVersionRelUpReg;

/**
 * The error message of 'HardwareVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError HardwareVersionError;

/**
 * The get message of the property "SoftwareVersion"
 * This property gives information about the software version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SoftwareVersionGet;

/**
 * The upreg message of the property "SoftwareVersion"
 * This property gives information about the software version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SoftwareVersionUpReg;

/**
 * The relUpReg message of the property "SoftwareVersion"
 * This property gives information about the software version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SoftwareVersionRelUpReg;

/**
 * The error message of 'SoftwareVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError SoftwareVersionError;

/**
 * The get message of the property "PrimaryIntegratedSwitch_Connection"
 * This property gives information about the connection status to the Primary Integrated Switch MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PrimaryIntegratedSwitch_ConnectionGet;

/**
 * The upreg message of the property "PrimaryIntegratedSwitch_Connection"
 * This property gives information about the connection status to the Primary Integrated Switch MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PrimaryIntegratedSwitch_ConnectionUpReg;

/**
 * The relUpReg message of the property "PrimaryIntegratedSwitch_Connection"
 * This property gives information about the connection status to the Primary Integrated Switch MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PrimaryIntegratedSwitch_ConnectionRelUpReg;

/**
 * The error message of 'PrimaryIntegratedSwitch_Connection'
 */
typedef ::asf::cca::CcaTypes::DefaultError PrimaryIntegratedSwitch_ConnectionError;

/**
 * The start message of the method "ResetHistory"
 * Send INC message request to V850 to reset MCAN Units Connection History.
 * Send INC Message to V850 with u8History as 0x01
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetHistoryStart;

/**
 * The result message of the method "ResetHistory"
 * Send INC message request to V850 to reset MCAN Units Connection History.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetHistoryResult;

/**
 * The abort error message of the method "ResetHistory"
 * Send INC message request to V850 to reset MCAN Units Connection History.
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetHistoryAbortError;

/**
 * The error message of 'ResetHistory'
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetHistoryError;

/**
 * The start message of the method "VersionInfo"
 * Send INC message request to V850 to get version for MCAN Units Connection History.
 * Send INC Message to V850
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VersionInfoStart;

/**
 * The result message of the method "VersionInfo"
 * Send INC message request to V850 to get version for MCAN Units Connection History.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VersionInfoResult;

/**
 * The abort error message of the method "VersionInfo"
 * Send INC message request to V850 to get version for MCAN Units Connection History.
 */
typedef ::asf::cca::CcaTypes::DefaultError VersionInfoAbortError;

/**
 * The error message of 'VersionInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError VersionInfoError;

/**
 * The result message of the method "BeepInfo"
 * AUDIO calls this function as a trigger to send Beep information
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BeepInfoResult;

/**
 * The abort error message of the method "BeepInfo"
 * AUDIO calls this function as a trigger to send Beep information
 */
typedef ::asf::cca::CcaTypes::DefaultError BeepInfoAbortError;

/**
 * The error message of 'BeepInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError BeepInfoError;


/**
 * The status message of the property "RearSeat_Connection"
 * This property gives information about the connection status to the Rear Seat MCAN units.
 */
class RearSeat_ConnectionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RearSeat_ConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  RearSeat_ConnectionStatus (const RearSeat_ConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RearSeat_ConnectionStatus (const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& RSCConnectionStatus_);

    /**
     * Destructor
     */
    inline virtual  ~RearSeat_ConnectionStatus();

    /**
     * Assignment operator
     */
    inline RearSeat_ConnectionStatus& operator = (const RearSeat_ConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RearSeat_ConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RearSeat_ConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RearSeat_ConnectionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RearSeat_ConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RSCConnectionStatus"

    static const int kRSCConnectionStatus = 0;

    /**
     * Clears the field "RSCConnectionStatus".
     *
     * The field will be set to its default value. The hasRSCConnectionStatus()
     * method will return false.
     */
    inline void clearRSCConnectionStatus();

    /**
     * Checks whether the field "RSCConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSCConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasRSCConnectionStatus () const;

    /**
     * Returns the value of the member "RSCConnectionStatus".
     *
     * Structure with connection status of RearSeat MCAN unit.
     *
     * @return The value of the field "RSCConnectionStatus"
     */
    inline const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& getRSCConnectionStatus () const;

    /**
     * Retrieves the value of the field "RSCConnectionStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RSCConnectionStatus".
     */
    inline ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& getRSCConnectionStatusMutable ();

    /**
     * Sets the value of the member "RSCConnectionStatus".
     *
     * Structure with connection status of RearSeat MCAN unit.
     *
     * @param RSCConnectionStatus The value which will be set
     */
    inline void setRSCConnectionStatus (const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& RSCConnectionStatus_);

    static const RearSeat_ConnectionStatus &getDefaultInstance();

private:

    inline void set_has_RSCConnectionStatus ();

    inline void clear_has_RSCConnectionStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus _RSCConnectionStatus;

};

/**
 * The status message of the property "ITCommander_Connection"
 * This property gives information about the connection status to the IT Commander MCAN units.
 */
class ITCommander_ConnectionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ITCommander_ConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  ITCommander_ConnectionStatus (const ITCommander_ConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ITCommander_ConnectionStatus (const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& ITCommConnStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ITCommander_ConnectionStatus();

    /**
     * Assignment operator
     */
    inline ITCommander_ConnectionStatus& operator = (const ITCommander_ConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ITCommander_ConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ITCommander_ConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ITCommander_ConnectionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ITCommander_ConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ITCommConnStatus"

    static const int kITCommConnStatus = 0;

    /**
     * Clears the field "ITCommConnStatus".
     *
     * The field will be set to its default value. The hasITCommConnStatus()
     * method will return false.
     */
    inline void clearITCommConnStatus();

    /**
     * Checks whether the field "ITCommConnStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setITCommConnStatus()). Otherwise it will return false.
     */
    inline bool hasITCommConnStatus () const;

    /**
     * Returns the value of the member "ITCommConnStatus".
     *
     * Structure with connection status of RearSeat MCAN unit.
     *
     * @return The value of the field "ITCommConnStatus"
     */
    inline const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& getITCommConnStatus () const;

    /**
     * Retrieves the value of the field "ITCommConnStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ITCommConnStatus".
     */
    inline ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& getITCommConnStatusMutable ();

    /**
     * Sets the value of the member "ITCommConnStatus".
     *
     * Structure with connection status of RearSeat MCAN unit.
     *
     * @param ITCommConnStatus The value which will be set
     */
    inline void setITCommConnStatus (const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& ITCommConnStatus_);

    static const ITCommander_ConnectionStatus &getDefaultInstance();

private:

    inline void set_has_ITCommConnStatus ();

    inline void clear_has_ITCommConnStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus _ITCommConnStatus;

};

/**
 * The status message of the property "HardwareVersion"
 * This property gives information about the hardware version of the various MCAN units.
 */
class HardwareVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HardwareVersionStatus ();

    /**
     * Copy constructor
     */
    inline  HardwareVersionStatus (const HardwareVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  HardwareVersionStatus (const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& arHardwareVersionList_);

    /**
     * Destructor
     */
    inline virtual  ~HardwareVersionStatus();

    /**
     * Assignment operator
     */
    inline HardwareVersionStatus& operator = (const HardwareVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HardwareVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HardwareVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HardwareVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HardwareVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arHardwareVersionList"

    static const int kArHardwareVersionList = 0;

    /**
     * Clears the field "arHardwareVersionList".
     *
     * The field will be set to its default value. The hasArHardwareVersionList()
     * method will return false.
     */
    inline void clearArHardwareVersionList();

    /**
     * Checks whether the field "arHardwareVersionList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArHardwareVersionList()). Otherwise it will return false.
     */
    inline bool hasArHardwareVersionList () const;

    /**
     * Returns the value of the member "arHardwareVersionList".
     *
     * List with hardware version of each MCAN unit.
     *
     * @return The value of the field "arHardwareVersionList"
     */
    inline const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& getArHardwareVersionList () const;

    /**
     * Retrieves the value of the field "arHardwareVersionList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arHardwareVersionList".
     */
    inline ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& getArHardwareVersionListMutable ();

    /**
     * Sets the value of the member "arHardwareVersionList".
     *
     * List with hardware version of each MCAN unit.
     *
     * @param arHardwareVersionList The value which will be set
     */
    inline void setArHardwareVersionList (const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& arHardwareVersionList_);

    static const HardwareVersionStatus &getDefaultInstance();

private:

    static const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& getT_SwitchCtrl_UnitVersionList_DefaultInstance ();

    inline void set_has_arHardwareVersionList ();

    inline void clear_has_arHardwareVersionList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion > _arHardwareVersionList;

};

/**
 * The status message of the property "SoftwareVersion"
 * This property gives information about the software version of the various MCAN units.
 */
class SoftwareVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SoftwareVersionStatus ();

    /**
     * Copy constructor
     */
    inline  SoftwareVersionStatus (const SoftwareVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SoftwareVersionStatus (const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& arSoftwareVersionList_);

    /**
     * Destructor
     */
    inline virtual  ~SoftwareVersionStatus();

    /**
     * Assignment operator
     */
    inline SoftwareVersionStatus& operator = (const SoftwareVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SoftwareVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SoftwareVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SoftwareVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SoftwareVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arSoftwareVersionList"

    static const int kArSoftwareVersionList = 0;

    /**
     * Clears the field "arSoftwareVersionList".
     *
     * The field will be set to its default value. The hasArSoftwareVersionList()
     * method will return false.
     */
    inline void clearArSoftwareVersionList();

    /**
     * Checks whether the field "arSoftwareVersionList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArSoftwareVersionList()). Otherwise it will return false.
     */
    inline bool hasArSoftwareVersionList () const;

    /**
     * Returns the value of the member "arSoftwareVersionList".
     *
     * List with software version of each MCAN unit.
     *
     * @return The value of the field "arSoftwareVersionList"
     */
    inline const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& getArSoftwareVersionList () const;

    /**
     * Retrieves the value of the field "arSoftwareVersionList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arSoftwareVersionList".
     */
    inline ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& getArSoftwareVersionListMutable ();

    /**
     * Sets the value of the member "arSoftwareVersionList".
     *
     * List with software version of each MCAN unit.
     *
     * @param arSoftwareVersionList The value which will be set
     */
    inline void setArSoftwareVersionList (const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& arSoftwareVersionList_);

    static const SoftwareVersionStatus &getDefaultInstance();

private:

    static const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& getT_SwitchCtrl_UnitVersionList_DefaultInstance ();

    inline void set_has_arSoftwareVersionList ();

    inline void clear_has_arSoftwareVersionList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion > _arSoftwareVersionList;

};

/**
 * The status message of the property "PrimaryIntegratedSwitch_Connection"
 * This property gives information about the connection status to the Primary Integrated Switch MCAN units.
 */
class PrimaryIntegratedSwitch_ConnectionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PrimaryIntegratedSwitch_ConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  PrimaryIntegratedSwitch_ConnectionStatus (const PrimaryIntegratedSwitch_ConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PrimaryIntegratedSwitch_ConnectionStatus (const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& PrimarySwitchConnStatus_);

    /**
     * Destructor
     */
    inline virtual  ~PrimaryIntegratedSwitch_ConnectionStatus();

    /**
     * Assignment operator
     */
    inline PrimaryIntegratedSwitch_ConnectionStatus& operator = (const PrimaryIntegratedSwitch_ConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrimaryIntegratedSwitch_ConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrimaryIntegratedSwitch_ConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrimaryIntegratedSwitch_ConnectionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrimaryIntegratedSwitch_ConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PrimarySwitchConnStatus"

    static const int kPrimarySwitchConnStatus = 0;

    /**
     * Clears the field "PrimarySwitchConnStatus".
     *
     * The field will be set to its default value. The hasPrimarySwitchConnStatus()
     * method will return false.
     */
    inline void clearPrimarySwitchConnStatus();

    /**
     * Checks whether the field "PrimarySwitchConnStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrimarySwitchConnStatus()). Otherwise it will return false.
     */
    inline bool hasPrimarySwitchConnStatus () const;

    /**
     * Returns the value of the member "PrimarySwitchConnStatus".
     *
     * Structure with connection status of Primary Integrated Switch MCAN unit.
     *
     * @return The value of the field "PrimarySwitchConnStatus"
     */
    inline const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& getPrimarySwitchConnStatus () const;

    /**
     * Retrieves the value of the field "PrimarySwitchConnStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PrimarySwitchConnStatus".
     */
    inline ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& getPrimarySwitchConnStatusMutable ();

    /**
     * Sets the value of the member "PrimarySwitchConnStatus".
     *
     * Structure with connection status of Primary Integrated Switch MCAN unit.
     *
     * @param PrimarySwitchConnStatus The value which will be set
     */
    inline void setPrimarySwitchConnStatus (const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& PrimarySwitchConnStatus_);

    static const PrimaryIntegratedSwitch_ConnectionStatus &getDefaultInstance();

private:

    inline void set_has_PrimarySwitchConnStatus ();

    inline void clear_has_PrimarySwitchConnStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus _PrimarySwitchConnStatus;

};

/**
 * The start message of the method "BeepInfo"
 * AUDIO calls this function as a trigger to send Beep information
 * Send INC Message to V850
 */
class BeepInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeepInfoStart ();

    /**
     * Copy constructor
     */
    inline  BeepInfoStart (const BeepInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  BeepInfoStart (uint8 u8NoOfBeeps_, uint8 u8BeepTime_, uint8 u8Period_);

    /**
     * Destructor
     */
    inline virtual  ~BeepInfoStart();

    /**
     * Assignment operator
     */
    inline BeepInfoStart& operator = (const BeepInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeepInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeepInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeepInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeepInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8NoOfBeeps"

    static const int kU8NoOfBeeps = 0;

    /**
     * Clears the field "u8NoOfBeeps".
     *
     * The field will be set to its default value. The hasU8NoOfBeeps()
     * method will return false.
     */
    inline void clearU8NoOfBeeps();

    /**
     * Checks whether the field "u8NoOfBeeps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NoOfBeeps()). Otherwise it will return false.
     */
    inline bool hasU8NoOfBeeps () const;

    /**
     * Returns the value of the member "u8NoOfBeeps".
     *
     * AUDIO sends No of Beep and Frequency of the beep
     *
     * @return The value of the field "u8NoOfBeeps"
     */
    inline uint8 getU8NoOfBeeps () const;

    /**
     * Sets the value of the member "u8NoOfBeeps".
     *
     * AUDIO sends No of Beep and Frequency of the beep
     *
     * @param u8NoOfBeeps The value which will be set
     */
    inline void setU8NoOfBeeps (uint8 u8NoOfBeeps_);

    // API of field "u8BeepTime"

    static const int kU8BeepTime = 1;

    /**
     * Clears the field "u8BeepTime".
     *
     * The field will be set to its default value. The hasU8BeepTime()
     * method will return false.
     */
    inline void clearU8BeepTime();

    /**
     * Checks whether the field "u8BeepTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8BeepTime()). Otherwise it will return false.
     */
    inline bool hasU8BeepTime () const;

    /**
     * Returns the value of the member "u8BeepTime".
     *
     * AUDIO sends Time of Beep
     *
     * @return The value of the field "u8BeepTime"
     */
    inline uint8 getU8BeepTime () const;

    /**
     * Sets the value of the member "u8BeepTime".
     *
     * AUDIO sends Time of Beep
     *
     * @param u8BeepTime The value which will be set
     */
    inline void setU8BeepTime (uint8 u8BeepTime_);

    // API of field "u8Period"

    static const int kU8Period = 2;

    /**
     * Clears the field "u8Period".
     *
     * The field will be set to its default value. The hasU8Period()
     * method will return false.
     */
    inline void clearU8Period();

    /**
     * Checks whether the field "u8Period" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Period()). Otherwise it will return false.
     */
    inline bool hasU8Period () const;

    /**
     * Returns the value of the member "u8Period".
     *
     * AUDIO sends The period of Beep
     *
     * @return The value of the field "u8Period"
     */
    inline uint8 getU8Period () const;

    /**
     * Sets the value of the member "u8Period".
     *
     * AUDIO sends The period of Beep
     *
     * @param u8Period The value which will be set
     */
    inline void setU8Period (uint8 u8Period_);

    static const BeepInfoStart &getDefaultInstance();

private:

    inline void set_has_u8NoOfBeeps ();

    inline void clear_has_u8NoOfBeeps ();

    inline void set_has_u8BeepTime ();

    inline void clear_has_u8BeepTime ();

    inline void set_has_u8Period ();

    inline void clear_has_u8Period ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8NoOfBeeps;

    uint8 _u8BeepTime;

    uint8 _u8Period;

};

inline  RearSeat_ConnectionStatus::RearSeat_ConnectionStatus ()  :
    _RSCConnectionStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RearSeat_ConnectionStatus::RearSeat_ConnectionStatus (const RearSeat_ConnectionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _RSCConnectionStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RearSeat_ConnectionStatus::RearSeat_ConnectionStatus (const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& RSCConnectionStatus_)  :
    _RSCConnectionStatus (RSCConnectionStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RearSeat_ConnectionStatus::~RearSeat_ConnectionStatus() {
}

inline RearSeat_ConnectionStatus& RearSeat_ConnectionStatus::operator = (const RearSeat_ConnectionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRSCConnectionStatus()) {
            setRSCConnectionStatus(rhs.getRSCConnectionStatus());
        } else {
            clearRSCConnectionStatus();
        }
    }
    return *this;
}

inline bool RearSeat_ConnectionStatus::operator == (const RearSeat_ConnectionStatus& rhs) const {
    return (((!hasRSCConnectionStatus() && !rhs.hasRSCConnectionStatus()) || getRSCConnectionStatus() == rhs.getRSCConnectionStatus()));
}

inline bool RearSeat_ConnectionStatus::operator != (const RearSeat_ConnectionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool RearSeat_ConnectionStatus::operator < (const RearSeat_ConnectionStatus& rhs) const {
    if (hasRSCConnectionStatus() || rhs.hasRSCConnectionStatus()) {
        if (getRSCConnectionStatus() < rhs.getRSCConnectionStatus()) return true;
        if (getRSCConnectionStatus() > rhs.getRSCConnectionStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RearSeat_ConnectionStatus::clone() {
    return new RearSeat_ConnectionStatus(*this);
}

inline bool RearSeat_ConnectionStatus::operator > (const RearSeat_ConnectionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RearSeat_ConnectionStatus::clear() {
    clearRSCConnectionStatus();
}

inline void RearSeat_ConnectionStatus::clearRSCConnectionStatus() {
    if (hasRSCConnectionStatus()) {
         clear_has_RSCConnectionStatus();
        _RSCConnectionStatus.clear();
     }
}

inline bool RearSeat_ConnectionStatus::hasRSCConnectionStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& RearSeat_ConnectionStatus::getRSCConnectionStatus () const {
    return _RSCConnectionStatus;
}

inline ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& RearSeat_ConnectionStatus::getRSCConnectionStatusMutable () {
    set_has_RSCConnectionStatus();
    return _RSCConnectionStatus;
}

inline void RearSeat_ConnectionStatus::setRSCConnectionStatus (const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& RSCConnectionStatus_) {
    set_has_RSCConnectionStatus();
    this->_RSCConnectionStatus = RSCConnectionStatus_;
}

inline void RearSeat_ConnectionStatus::set_has_RSCConnectionStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void RearSeat_ConnectionStatus::clear_has_RSCConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ITCommander_ConnectionStatus::ITCommander_ConnectionStatus ()  :
    _ITCommConnStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ITCommander_ConnectionStatus::ITCommander_ConnectionStatus (const ITCommander_ConnectionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ITCommConnStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ITCommander_ConnectionStatus::ITCommander_ConnectionStatus (const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& ITCommConnStatus_)  :
    _ITCommConnStatus (ITCommConnStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ITCommander_ConnectionStatus::~ITCommander_ConnectionStatus() {
}

inline ITCommander_ConnectionStatus& ITCommander_ConnectionStatus::operator = (const ITCommander_ConnectionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasITCommConnStatus()) {
            setITCommConnStatus(rhs.getITCommConnStatus());
        } else {
            clearITCommConnStatus();
        }
    }
    return *this;
}

inline bool ITCommander_ConnectionStatus::operator == (const ITCommander_ConnectionStatus& rhs) const {
    return (((!hasITCommConnStatus() && !rhs.hasITCommConnStatus()) || getITCommConnStatus() == rhs.getITCommConnStatus()));
}

inline bool ITCommander_ConnectionStatus::operator != (const ITCommander_ConnectionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ITCommander_ConnectionStatus::operator < (const ITCommander_ConnectionStatus& rhs) const {
    if (hasITCommConnStatus() || rhs.hasITCommConnStatus()) {
        if (getITCommConnStatus() < rhs.getITCommConnStatus()) return true;
        if (getITCommConnStatus() > rhs.getITCommConnStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ITCommander_ConnectionStatus::clone() {
    return new ITCommander_ConnectionStatus(*this);
}

inline bool ITCommander_ConnectionStatus::operator > (const ITCommander_ConnectionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ITCommander_ConnectionStatus::clear() {
    clearITCommConnStatus();
}

inline void ITCommander_ConnectionStatus::clearITCommConnStatus() {
    if (hasITCommConnStatus()) {
         clear_has_ITCommConnStatus();
        _ITCommConnStatus.clear();
     }
}

inline bool ITCommander_ConnectionStatus::hasITCommConnStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& ITCommander_ConnectionStatus::getITCommConnStatus () const {
    return _ITCommConnStatus;
}

inline ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& ITCommander_ConnectionStatus::getITCommConnStatusMutable () {
    set_has_ITCommConnStatus();
    return _ITCommConnStatus;
}

inline void ITCommander_ConnectionStatus::setITCommConnStatus (const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& ITCommConnStatus_) {
    set_has_ITCommConnStatus();
    this->_ITCommConnStatus = ITCommConnStatus_;
}

inline void ITCommander_ConnectionStatus::set_has_ITCommConnStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void ITCommander_ConnectionStatus::clear_has_ITCommConnStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HardwareVersionStatus::HardwareVersionStatus ()  :
    _arHardwareVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HardwareVersionStatus::HardwareVersionStatus (const HardwareVersionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _arHardwareVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HardwareVersionStatus::HardwareVersionStatus (const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& arHardwareVersionList_)  :
    _arHardwareVersionList (arHardwareVersionList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HardwareVersionStatus::~HardwareVersionStatus() {
}

inline HardwareVersionStatus& HardwareVersionStatus::operator = (const HardwareVersionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArHardwareVersionList()) {
            setArHardwareVersionList(rhs.getArHardwareVersionList());
        } else {
            clearArHardwareVersionList();
        }
    }
    return *this;
}

inline bool HardwareVersionStatus::operator == (const HardwareVersionStatus& rhs) const {
    return (((!hasArHardwareVersionList() && !rhs.hasArHardwareVersionList()) || getArHardwareVersionList() == rhs.getArHardwareVersionList()));
}

inline bool HardwareVersionStatus::operator != (const HardwareVersionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool HardwareVersionStatus::operator < (const HardwareVersionStatus& rhs) const {
    if (hasArHardwareVersionList() || rhs.hasArHardwareVersionList()) {
        if (getArHardwareVersionList() < rhs.getArHardwareVersionList()) return true;
        if (getArHardwareVersionList() > rhs.getArHardwareVersionList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HardwareVersionStatus::clone() {
    return new HardwareVersionStatus(*this);
}

inline bool HardwareVersionStatus::operator > (const HardwareVersionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HardwareVersionStatus::clear() {
    clearArHardwareVersionList();
}

inline void HardwareVersionStatus::clearArHardwareVersionList() {
    if (hasArHardwareVersionList()) {
         clear_has_arHardwareVersionList();
        _arHardwareVersionList.clear();
     }
}

inline bool HardwareVersionStatus::hasArHardwareVersionList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& HardwareVersionStatus::getArHardwareVersionList () const {
    return _arHardwareVersionList;
}

inline ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& HardwareVersionStatus::getArHardwareVersionListMutable () {
    set_has_arHardwareVersionList();
    return _arHardwareVersionList;
}

inline void HardwareVersionStatus::setArHardwareVersionList (const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& arHardwareVersionList_) {
    set_has_arHardwareVersionList();
    this->_arHardwareVersionList = arHardwareVersionList_;
}

inline void HardwareVersionStatus::set_has_arHardwareVersionList () {
    _has_bits_[0] |= 1u << 0;
}

inline void HardwareVersionStatus::clear_has_arHardwareVersionList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SoftwareVersionStatus::SoftwareVersionStatus ()  :
    _arSoftwareVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SoftwareVersionStatus::SoftwareVersionStatus (const SoftwareVersionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _arSoftwareVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SoftwareVersionStatus::SoftwareVersionStatus (const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& arSoftwareVersionList_)  :
    _arSoftwareVersionList (arSoftwareVersionList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SoftwareVersionStatus::~SoftwareVersionStatus() {
}

inline SoftwareVersionStatus& SoftwareVersionStatus::operator = (const SoftwareVersionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArSoftwareVersionList()) {
            setArSoftwareVersionList(rhs.getArSoftwareVersionList());
        } else {
            clearArSoftwareVersionList();
        }
    }
    return *this;
}

inline bool SoftwareVersionStatus::operator == (const SoftwareVersionStatus& rhs) const {
    return (((!hasArSoftwareVersionList() && !rhs.hasArSoftwareVersionList()) || getArSoftwareVersionList() == rhs.getArSoftwareVersionList()));
}

inline bool SoftwareVersionStatus::operator != (const SoftwareVersionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SoftwareVersionStatus::operator < (const SoftwareVersionStatus& rhs) const {
    if (hasArSoftwareVersionList() || rhs.hasArSoftwareVersionList()) {
        if (getArSoftwareVersionList() < rhs.getArSoftwareVersionList()) return true;
        if (getArSoftwareVersionList() > rhs.getArSoftwareVersionList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SoftwareVersionStatus::clone() {
    return new SoftwareVersionStatus(*this);
}

inline bool SoftwareVersionStatus::operator > (const SoftwareVersionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SoftwareVersionStatus::clear() {
    clearArSoftwareVersionList();
}

inline void SoftwareVersionStatus::clearArSoftwareVersionList() {
    if (hasArSoftwareVersionList()) {
         clear_has_arSoftwareVersionList();
        _arSoftwareVersionList.clear();
     }
}

inline bool SoftwareVersionStatus::hasArSoftwareVersionList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& SoftwareVersionStatus::getArSoftwareVersionList () const {
    return _arSoftwareVersionList;
}

inline ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& SoftwareVersionStatus::getArSoftwareVersionListMutable () {
    set_has_arSoftwareVersionList();
    return _arSoftwareVersionList;
}

inline void SoftwareVersionStatus::setArSoftwareVersionList (const ::std::vector< ::switchctrl_main_fi_types::T_SwitchCtrl_UnitVersion >& arSoftwareVersionList_) {
    set_has_arSoftwareVersionList();
    this->_arSoftwareVersionList = arSoftwareVersionList_;
}

inline void SoftwareVersionStatus::set_has_arSoftwareVersionList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SoftwareVersionStatus::clear_has_arSoftwareVersionList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PrimaryIntegratedSwitch_ConnectionStatus::PrimaryIntegratedSwitch_ConnectionStatus ()  :
    _PrimarySwitchConnStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PrimaryIntegratedSwitch_ConnectionStatus::PrimaryIntegratedSwitch_ConnectionStatus (const PrimaryIntegratedSwitch_ConnectionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _PrimarySwitchConnStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PrimaryIntegratedSwitch_ConnectionStatus::PrimaryIntegratedSwitch_ConnectionStatus (const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& PrimarySwitchConnStatus_)  :
    _PrimarySwitchConnStatus (PrimarySwitchConnStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PrimaryIntegratedSwitch_ConnectionStatus::~PrimaryIntegratedSwitch_ConnectionStatus() {
}

inline PrimaryIntegratedSwitch_ConnectionStatus& PrimaryIntegratedSwitch_ConnectionStatus::operator = (const PrimaryIntegratedSwitch_ConnectionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPrimarySwitchConnStatus()) {
            setPrimarySwitchConnStatus(rhs.getPrimarySwitchConnStatus());
        } else {
            clearPrimarySwitchConnStatus();
        }
    }
    return *this;
}

inline bool PrimaryIntegratedSwitch_ConnectionStatus::operator == (const PrimaryIntegratedSwitch_ConnectionStatus& rhs) const {
    return (((!hasPrimarySwitchConnStatus() && !rhs.hasPrimarySwitchConnStatus()) || getPrimarySwitchConnStatus() == rhs.getPrimarySwitchConnStatus()));
}

inline bool PrimaryIntegratedSwitch_ConnectionStatus::operator != (const PrimaryIntegratedSwitch_ConnectionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool PrimaryIntegratedSwitch_ConnectionStatus::operator < (const PrimaryIntegratedSwitch_ConnectionStatus& rhs) const {
    if (hasPrimarySwitchConnStatus() || rhs.hasPrimarySwitchConnStatus()) {
        if (getPrimarySwitchConnStatus() < rhs.getPrimarySwitchConnStatus()) return true;
        if (getPrimarySwitchConnStatus() > rhs.getPrimarySwitchConnStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PrimaryIntegratedSwitch_ConnectionStatus::clone() {
    return new PrimaryIntegratedSwitch_ConnectionStatus(*this);
}

inline bool PrimaryIntegratedSwitch_ConnectionStatus::operator > (const PrimaryIntegratedSwitch_ConnectionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PrimaryIntegratedSwitch_ConnectionStatus::clear() {
    clearPrimarySwitchConnStatus();
}

inline void PrimaryIntegratedSwitch_ConnectionStatus::clearPrimarySwitchConnStatus() {
    if (hasPrimarySwitchConnStatus()) {
         clear_has_PrimarySwitchConnStatus();
        _PrimarySwitchConnStatus.clear();
     }
}

inline bool PrimaryIntegratedSwitch_ConnectionStatus::hasPrimarySwitchConnStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& PrimaryIntegratedSwitch_ConnectionStatus::getPrimarySwitchConnStatus () const {
    return _PrimarySwitchConnStatus;
}

inline ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& PrimaryIntegratedSwitch_ConnectionStatus::getPrimarySwitchConnStatusMutable () {
    set_has_PrimarySwitchConnStatus();
    return _PrimarySwitchConnStatus;
}

inline void PrimaryIntegratedSwitch_ConnectionStatus::setPrimarySwitchConnStatus (const ::switchctrl_main_fi_types::T_SwCtrl_ConnectionStatus& PrimarySwitchConnStatus_) {
    set_has_PrimarySwitchConnStatus();
    this->_PrimarySwitchConnStatus = PrimarySwitchConnStatus_;
}

inline void PrimaryIntegratedSwitch_ConnectionStatus::set_has_PrimarySwitchConnStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void PrimaryIntegratedSwitch_ConnectionStatus::clear_has_PrimarySwitchConnStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BeepInfoStart::BeepInfoStart ()  :
    _u8NoOfBeeps (0u),
    _u8BeepTime (0u),
    _u8Period (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BeepInfoStart::BeepInfoStart (const BeepInfoStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u8NoOfBeeps (0u),
    _u8BeepTime (0u),
    _u8Period (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BeepInfoStart::BeepInfoStart (uint8 u8NoOfBeeps_, uint8 u8BeepTime_, uint8 u8Period_)  :
    _u8NoOfBeeps (u8NoOfBeeps_),
    _u8BeepTime (u8BeepTime_),
    _u8Period (u8Period_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BeepInfoStart::~BeepInfoStart() {
}

inline BeepInfoStart& BeepInfoStart::operator = (const BeepInfoStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8NoOfBeeps()) {
            setU8NoOfBeeps(rhs.getU8NoOfBeeps());
        } else {
            clearU8NoOfBeeps();
        }
        if (rhs.hasU8BeepTime()) {
            setU8BeepTime(rhs.getU8BeepTime());
        } else {
            clearU8BeepTime();
        }
        if (rhs.hasU8Period()) {
            setU8Period(rhs.getU8Period());
        } else {
            clearU8Period();
        }
    }
    return *this;
}

inline bool BeepInfoStart::operator == (const BeepInfoStart& rhs) const {
    return (((!hasU8NoOfBeeps() && !rhs.hasU8NoOfBeeps()) || getU8NoOfBeeps() == rhs.getU8NoOfBeeps()) &&
        ((!hasU8BeepTime() && !rhs.hasU8BeepTime()) || getU8BeepTime() == rhs.getU8BeepTime()) &&
        ((!hasU8Period() && !rhs.hasU8Period()) || getU8Period() == rhs.getU8Period()));
}

inline bool BeepInfoStart::operator != (const BeepInfoStart& rhs) const {
    return ! (*this == rhs);
}

inline bool BeepInfoStart::operator < (const BeepInfoStart& rhs) const {
    if (hasU8NoOfBeeps() || rhs.hasU8NoOfBeeps()) {
        if (getU8NoOfBeeps() < rhs.getU8NoOfBeeps()) return true;
        if (getU8NoOfBeeps() > rhs.getU8NoOfBeeps()) return false;
    }
    if (hasU8BeepTime() || rhs.hasU8BeepTime()) {
        if (getU8BeepTime() < rhs.getU8BeepTime()) return true;
        if (getU8BeepTime() > rhs.getU8BeepTime()) return false;
    }
    if (hasU8Period() || rhs.hasU8Period()) {
        if (getU8Period() < rhs.getU8Period()) return true;
        if (getU8Period() > rhs.getU8Period()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BeepInfoStart::clone() {
    return new BeepInfoStart(*this);
}

inline bool BeepInfoStart::operator > (const BeepInfoStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BeepInfoStart::clear() {
    clearU8NoOfBeeps();
    clearU8BeepTime();
    clearU8Period();
}

inline void BeepInfoStart::clearU8NoOfBeeps() {
    if (hasU8NoOfBeeps()) {
         clear_has_u8NoOfBeeps();
        _u8NoOfBeeps = 0u;
     }
}

inline bool BeepInfoStart::hasU8NoOfBeeps () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BeepInfoStart::getU8NoOfBeeps () const {
    return _u8NoOfBeeps;
}

inline void BeepInfoStart::setU8NoOfBeeps (uint8 u8NoOfBeeps_) {
    set_has_u8NoOfBeeps();
    this->_u8NoOfBeeps = u8NoOfBeeps_;
}

inline void BeepInfoStart::clearU8BeepTime() {
    if (hasU8BeepTime()) {
         clear_has_u8BeepTime();
        _u8BeepTime = 0u;
     }
}

inline bool BeepInfoStart::hasU8BeepTime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 BeepInfoStart::getU8BeepTime () const {
    return _u8BeepTime;
}

inline void BeepInfoStart::setU8BeepTime (uint8 u8BeepTime_) {
    set_has_u8BeepTime();
    this->_u8BeepTime = u8BeepTime_;
}

inline void BeepInfoStart::clearU8Period() {
    if (hasU8Period()) {
         clear_has_u8Period();
        _u8Period = 0u;
     }
}

inline bool BeepInfoStart::hasU8Period () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 BeepInfoStart::getU8Period () const {
    return _u8Period;
}

inline void BeepInfoStart::setU8Period (uint8 u8Period_) {
    set_has_u8Period();
    this->_u8Period = u8Period_;
}

inline void BeepInfoStart::set_has_u8NoOfBeeps () {
    _has_bits_[0] |= 1u << 0;
}

inline void BeepInfoStart::clear_has_u8NoOfBeeps () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BeepInfoStart::set_has_u8BeepTime () {
    _has_bits_[0] |= 1u << 1;
}

inline void BeepInfoStart::clear_has_u8BeepTime () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BeepInfoStart::set_has_u8Period () {
    _has_bits_[0] |= 1u << 2;
}

inline void BeepInfoStart::clear_has_u8Period () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace switchctrl_main_fi

#endif // SWITCHCTRL_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
