/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_LCM_STARTUPCONTROLLERPROXY_H
#define ORG_BOSCH_CM_LCM_STARTUPCONTROLLERPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/cm/lcm/startupcontroller.h"
#include "org/bosch/cm/lcm/startupcontrollerConst.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace startupcontroller {

class StartupcontrollerProxy;

class FI_VersionCallbackIF {
public:
    virtual ~FI_VersionCallbackIF() {}

    virtual void onFI_VersionError(const ::boost::shared_ptr< StartupcontrollerProxy >& proxy, const ::boost::shared_ptr< FI_VersionError >& error) = 0;

    virtual void onFI_VersionUpdate(const ::boost::shared_ptr< StartupcontrollerProxy >& proxy, const ::boost::shared_ptr< FI_VersionUpdate >& update) = 0;
};

class StartupFailureIndicationCallbackIF {
public:
    virtual ~StartupFailureIndicationCallbackIF() {}

    virtual void onStartupFailureIndicationError(const ::boost::shared_ptr< StartupcontrollerProxy >& proxy, const ::boost::shared_ptr< StartupFailureIndicationError >& error) = 0;

    virtual void onStartupFailureIndicationUpdate(const ::boost::shared_ptr< StartupcontrollerProxy >& proxy, const ::boost::shared_ptr< StartupFailureIndicationUpdate >& update) = 0;
};

class StartupStatusCallbackIF {
public:
    virtual ~StartupStatusCallbackIF() {}

    virtual void onStartupStatusError(const ::boost::shared_ptr< StartupcontrollerProxy >& proxy, const ::boost::shared_ptr< StartupStatusError >& error) = 0;

    virtual void onStartupStatusUpdate(const ::boost::shared_ptr< StartupcontrollerProxy >& proxy, const ::boost::shared_ptr< StartupStatusUpdate >& update) = 0;
};


/**
 * StartupcontrollerProxy is the client side representation of the D-Bus
 * service interface 'org.bosch.cm.lcm.startupcontroller' (specified in
 * file StartupController_.xml).
 *
 * the StartupController service is used to communicate between LCM and StartupController application
 * 	The LCM informs the StartupController when all applications have been started
 */
class StartupcontrollerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of StartupcontrollerProxy.
     */
    static ::boost::shared_ptr< StartupcontrollerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of StartupcontrollerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< StartupcontrollerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of StartupcontrollerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< StartupcontrollerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< StartupcontrollerProxy > proxyNew(new StartupcontrollerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~StartupcontrollerProxy ();



    // Property 'FI_Version'


    /**
     * Request the value of the property 'FI_Version' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    instance.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFI_VersionGet(FI_VersionCallbackIF& cb);


    /**
     * Returns the current value of the property 'FI_Version' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasFI_Version() returns true.
     *
     * @return the previously received value of the property 'FI_Version'.
     */
    const ::std::string& getFI_Version() const;

    /**
     * Determines whether a status message for the property 'FI_Version' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFI_Version() const;

    // Property 'StartupStatus'


    /**
     * Request the value of the property 'StartupStatus' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'StartupStatus'</b>:
     *
     * Status of the startup
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartupStatusGet(StartupStatusCallbackIF& cb);

    /**
     * Set the value of the property 'StartupStatus'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendStartupStatusSet(StartupStatusCallbackIF& cb,
     * StartupState startupStatus) method instead.
     *
     * <b>Documentation of 'StartupStatus'</b>:
     *
     * Status of the startup
     */
    void sendStartupStatusSet(StartupState startupStatus);

    /**
     * Set the value of the property 'StartupStatus'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'StartupStatus'</b>:
     *
     * Status of the startup
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartupStatusSet(StartupStatusCallbackIF& cb, StartupState startupStatus);

    /**
     * Returns the current value of the property 'StartupStatus' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasStartupStatus() returns true.
     *
     * @return the previously received value of the property 'StartupStatus'.
     */
    StartupState getStartupStatus() const;

    /**
     * Determines whether a status message for the property 'StartupStatus'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasStartupStatus() const;

    // Property 'StartupFailureIndication'

    /**
     * Notify on the property 'StartupFailureIndication'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'StartupFailureIndication'</b>:
     *
     * Message describes the failure of the startup
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartupFailureIndicationRegister(StartupFailureIndicationCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'StartupFailureIndication'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'StartupFailureIndication'</b>:
     *
     * Message describes the failure of the startup
     *
     * @param act The act which was previously returned by the
     * sendStartupFailureIndicationRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendStartupFailureIndicationDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'StartupFailureIndication'.
     */
    void sendStartupFailureIndicationDeregisterAll() const;

    /**
     * Request the value of the property 'StartupFailureIndication' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'StartupFailureIndication'</b>:
     *
     * Message describes the failure of the startup
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartupFailureIndicationGet(StartupFailureIndicationCallbackIF& cb);

    /**
     * Set the value of the property 'StartupFailureIndication'. This method
     * sends a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendStartupFailureIndicationSet(StartupFailureIndicationCallbackIF& cb,
     * const StartupFailureInfo& startupFailureIndication) method instead.
     *
     * <b>Documentation of 'StartupFailureIndication'</b>:
     *
     * Message describes the failure of the startup
     */
    void sendStartupFailureIndicationSet(const StartupFailureInfo& startupFailureIndication);

    /**
     * Set the value of the property 'StartupFailureIndication'. This method
     * sends a Set message to the D-Bus server.
     *
     * <b>Documentation of 'StartupFailureIndication'</b>:
     *
     * Message describes the failure of the startup
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartupFailureIndicationSet(StartupFailureIndicationCallbackIF& cb, const StartupFailureInfo& startupFailureIndication);

    /**
     * Returns the current value of the property 'StartupFailureIndication'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasStartupFailureIndication() returns true.
     *
     * @return the previously received value of the property 'StartupFailureIndication'.
     */
    const StartupFailureInfo& getStartupFailureIndication() const;

    /**
     * Determines whether a status message for the property
     * 'StartupFailureIndication' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasStartupFailureIndication() const;


    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    StartupcontrollerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'FI_Version'

    ::asf::core::nullable< FI_VersionUpdate > _fI_Version;

    // Property 'StartupStatus'

    ::asf::core::nullable< StartupStatusUpdate > _startupStatus;

    // Property 'StartupFailureIndication'

    ::asf::core::nullable< StartupFailureIndicationUpdate > _startupFailureIndication;

    DECLARE_CLASS_LOGGER();

    friend class StartupcontrollerProxyCallback;
};

} // namespace startupcontroller
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_LCM_STARTUPCONTROLLERPROXY_H
